/********************************************************************************
*                                                                               *
*                  Ascii newline stream handling                                *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
#ifndef FXEXARRAY_H
#define FXEXARRAY_H

/**
 * The purpose of this header is to make using FXArray less frustrating...
 * ... as well an anything else that may be useful...
 *
 * ie. as a programmer you wont need to remember to #include the particulars
 *     about your platform's placement-new operator.
 */

#ifdef _GNU_SOURCE
#  include <new>
#endif
#include <fox/fxver.h>
#include <fox/fxdefs.h>
#include <fox/FXElement.h>
#include <fox/FXArray.h>
#include <fox/FXString.h>
#include <fox/FXObjectList.h>
using namespace FX;
namespace FXEX {
class FXIOHandle;
class FXSocket;

/// support arrays/lists of strings
typedef FXArray<FXString> FXStringList;

/// list of FXint's
typedef FXArray<FXint> FXIntList;

/// List of IO handles
typedef FXObjectListOf<FXIOHandle> FXIOHandleList;

/// lists of sockets
typedef FXObjectListOf<FXSocket> FXSocketList;

} // namespace FXEX
#endif //FXEXARRAY_H
