/**************************************************************************
   THIS CODE AND INFORMATION IS PROVIDED 'AS IS' WITHOUT WARRANTY OF
   ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
   THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
   PARTICULAR PURPOSE.

   Copyright 1998 Microsoft Corporation.  All Rights Reserved.
**************************************************************************/

/**************************************************************************

   File:          evntsink.cpp

   Description:   This file contains the implementation of the event sink.

**************************************************************************/

/**************************************************************************
   #include statements
**************************************************************************/

#include "includes.h"
#include "evntsink.h"
#include "main.h"

/**************************************************************************
   function prototypes
**************************************************************************/

/**************************************************************************
   global variables and definitions
**************************************************************************/

/**************************************************************************

   CEventSink::CEventSink()

**************************************************************************/

CEventSink::CEventSink()
{
    m_cRefs     = 1;
}

/**************************************************************************

   CEventSink::QueryInterface()

**************************************************************************/

STDMETHODIMP CEventSink::QueryInterface(REFIID riid, PVOID *ppvObject)
{
    if (!ppvObject)
        return E_POINTER;

    if (IsEqualIID(riid, IID_IDispatch))
        *ppvObject = (IDispatch *)this;
    else if (IsEqualIID(riid, IID_IUnknown))
        *ppvObject = this;
    else
    {
        *ppvObject = NULL;
        return E_NOINTERFACE;
    }

    AddRef();
    return S_OK;
}

/**************************************************************************

   CEventSink::AddRef()

**************************************************************************/

ULONG CEventSink::AddRef(void)
{
    return ++m_cRefs;
}

/**************************************************************************

   CEventSink::Release()

**************************************************************************/

ULONG CEventSink::Release(void)
{
    if (--m_cRefs)
        return m_cRefs;

    delete this;
    return 0;
}

/**************************************************************************

   CEventSink::GetIDsOfNames()

**************************************************************************/

HRESULT CEventSink::GetIDsOfNames(REFIID riid, OLECHAR FAR* FAR* rgszNames, unsigned int cNames, LCID lcid, DISPID FAR* rgdispid)
{
    *rgdispid = DISPID_UNKNOWN;
    return DISP_E_UNKNOWNNAME;
}

/**************************************************************************

   CEventSink::GetTypeInfo()

**************************************************************************/

HRESULT CEventSink::GetTypeInfo(unsigned int itinfo, LCID lcid, ITypeInfo FAR* FAR* pptinfo)
{
    return E_NOTIMPL;
}

/**************************************************************************

   CEventSink::GetTypeInfoCount()

**************************************************************************/

HRESULT CEventSink::GetTypeInfoCount(unsigned int FAR * pctinfo)
{
    return E_NOTIMPL;
}

/**************************************************************************

   CEventSink::Invoke()

**************************************************************************/

HRESULT CEventSink::Invoke(DISPID dispid, REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS FAR *pdispparams, VARIANT FAR *pvarResult, EXCEPINFO FAR * pexecinfo, unsigned int FAR *puArgErr)
{
    switch (dispid) {
      // OLE ID's -> depend on OCX!!!
    case 0x00000001:
      // do something
      break;
      
    case 0x00000002:
      // do something else
      break;
      
    default:
      break;
    }

    return S_OK;
}
