#include "FXClientSocket.h"

FXIMPLEMENT(FXClientSocket, FXSocket, NULL, 0);

FXClientSocket::FXClientSocket(FXApp *app, FXObject *tgt, FXSelector sel): FXSocket(app, tgt, sel) {
  hostinfo = NULL;
  ServerPort = -1;
}

void FXClientSocket::create() {
  FXSocket::create();
}

FXint FXClientSocket::setServerAddress(const FXString &ServerAddress) {
  struct in_addr addr;
  if(isConnected()) return SOCKET_ERROR;
  if(!inet_aton(ServerAddress.text(), &addr)) return SOCKET_ERROR;
  hostinfo = gethostbyaddr(&addr, sizeof(struct in_addr), AF_INET);
  if(!hostinfo) return SOCKET_ERROR;
  ServerName = hostinfo->h_name;
  this->ServerAddress = ServerAddress;
  return 0;
}

FXint FXClientSocket::setServerName(const FXString &ServerName) {
  if(isConnected()) return SOCKET_ERROR;
  hostinfo = gethostbyname(ServerName.text());
  if(!hostinfo) return SOCKET_ERROR;
  this->ServerName = ServerName;
  ServerAddress = inet_ntoa(* ((struct in_addr *)hostinfo->h_addr));
  return 0;
}

FXint FXClientSocket::setServerPort(FXint ServerPort) {
  if(isConnected()) return SOCKET_ERROR;
  if((ServerPort<0)||(ServerPort>65535)) return SOCKET_ERROR;
  this->ServerPort = ServerPort;
  return 0;
}

long FXClientSocket::connect() {
  int ret;
  if((ServerPort<0) || !hostinfo) return SOCKET_ERROR;
  if(newSocket() == INVALID_SOCKET_HANDLE) return SOCKET_ERROR;
  remoteSide.sin_family = AF_INET;
  remoteSide.sin_port = htons(ServerPort);
  remoteSide.sin_addr = *((struct in_addr *) hostinfo->h_addr);
  ret = ::connect(getSocket(), (struct sockaddr *) &remoteSide, sizeof(remoteSide));
  if(ret == SOCKET_ERROR) return SOCKET_ERROR;
  setConnected(TRUE);
  return 0;
}
