#include <fx.h>
#include "ThreadedPipe.h"

class MyMainWindow : public FXMainWindow
{
	FXDECLARE(MyMainWindow)
protected:
	FXTextField * _input;
	FXText * _output;
	ThreadedPipe * threadedPipe;
protected:
	MyMainWindow();
public:
	enum {
		ID_INPUT=FXMainWindow::ID_LAST,
		ID_OUTPUT,
		ID_LAST
	};
public:
	long onCmdInput(FXObject *, FXSelector, void *);
	long onReadOutput(FXObject *, FXSelector, void *);
	long onClose(FXObject *, FXSelector, void *);
public:
	MyMainWindow(FXApp * app, const FXString & title);
	virtual void create();
	void displayError(char *pszAPI);
};

FXDEFMAP(MyMainWindow) MyMainWindowMap[]={
  FXMAPFUNC(SEL_COMMAND, MyMainWindow::ID_INPUT, MyMainWindow::onCmdInput),
  FXMAPFUNC(SEL_THREAD_EVENT, MyMainWindow::ID_OUTPUT, MyMainWindow::onReadOutput),
};

FXIMPLEMENT(MyMainWindow,FXMainWindow,MyMainWindowMap,ARRAYNUMBER(MyMainWindowMap))

MyMainWindow::MyMainWindow()
{
}

MyMainWindow::MyMainWindow(FXApp * app, const FXString & title) :
	FXMainWindow(app, title, NULL, NULL, DECOR_ALL, 0, 0, 400, 600)
{
	FXVerticalFrame * vFrame = new FXVerticalFrame(this, FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X);
	new FXLabel(vFrame, "Type in your text then press <Return>", NULL, LAYOUT_CENTER_X);
	_input = new FXTextField(vFrame, 0, this, ID_INPUT, FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X);

	new FXHorizontalSeparator(this, SEPARATOR_GROOVE|LAYOUT_FILL_X);
	vFrame = new FXVerticalFrame(this, FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_FILL_Y);
	new FXLabel(vFrame, "Output from the pipe", NULL, LAYOUT_CENTER_X);
	_output = new FXText(vFrame, NULL, 0, LAYOUT_FILL_X|LAYOUT_FILL_Y); 
}

long MyMainWindow::onCmdInput(FXObject *, FXSelector, void *)
{
	FXString buf = _input->getText() + "\n";
	threadedPipe->write(buf);
	return 1;
}

long MyMainWindow::onReadOutput(FXObject *, FXSelector, void *)
{
	const FXString & buf = threadedPipe->read();
	_output->appendText(buf.text(), buf.length());
	_output->makePositionVisible(_output->getLength());

	return 1;
}

void MyMainWindow::create()
{
	FXMainWindow::create();
	_input->setText("Coucou !");
	_input->setFocus();
	_input->selectAll();

	// create and launch the threaded pipe
	threadedPipe = new ThreadedPipe(this, ID_OUTPUT);
	threadedPipe->start();

	show(PLACEMENT_SCREEN);
}

int main(int argc, char ** argv)
{
	FXApp app("Pipes Win32", "pini");
	app.init(argc, argv);

	MyMainWindow mainWindow(&app, "Pipes Win32");
	app.create();
	app.run();

	return 0;
}
