<?php
$header_title = 'Bibliography';
include './include/begin-head.php';
include './include/begin-body.php';
?>

<p>
    This document contains a list of all known references to REDUCE
    sorted by first-author surname.
</p>

<!-- See https://getbootstrap.com/docs/5.0/components/navs-tabs/#javascript-behavior -->

<nav>
    <div class="nav nav-tabs" id="TabbedHeader" role="tablist"></div>
</nav>

<div class="tab-content" id="TabbedContent">
    <dl id='A'>
        <dt id="Abbott:87a">[Abbott:87a] J.&nbsp;A. Abbott.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-51517-8_155">Integration: Solving the Risch differential equation</a>. In: <em>Proc. EUROCAL &apos;87, Lecture Notes in Computer Science</em>, volume 378, pages 465-467. Springer-Verlag, 1987.</dd>
        <dt id="Abbott:88">[Abbott:88] J.&nbsp;A. Abbott.</dt>
        <dd><em>Factorisation of Polynomials over Algebraic Number Fields</em>. PhD thesis, Univ. of Bath, England, 1988.</dd>
        <dt id="Abbott:89">[Abbott:89] J.&nbsp;A. Abbott.</dt>
        <dd><a href="http://doi.acm.org/10.1145/74540.74555">Recovery of algebraic numbers from their p-adic approximations</a>. In: <em>Proc. of ISSAC &apos;89</em>, pages 112-120. ACM Press, New York, 1989.</dd>
        <dt id="Abbott:85">[Abbott:85] J.&nbsp;A. Abbott, R.&nbsp;J. Bradford, and J.&nbsp;H. Davenport.</dt>
        <dd><a href="http://doi.acm.org/10.1145/1089402.1089408">A remark on factorisation</a>. <em>SIGSAM Bulletin</em> <strong>19</strong> no. 2, pages 31-33, May 1985.</dd>
        <dt id="Abbott:86">[Abbott:86] J.&nbsp;A. Abbott, R.&nbsp;J. Bradford, and J.&nbsp;H. Davenport.</dt>
        <dd><a href="http://doi.acm.org/10.1145/32439.32490">The Bath algebraic number package</a>. In: <em>SYMSAC &apos;86: Proceedings of the fifth ACM symposium on Symbolic and algebraic computation</em>, pages 250-253, New York, NY, USA, 1986. ACM.</dd>
        <dt id="Abbott:89a">[Abbott:89a] J.&nbsp;A. Abbott, R.&nbsp;J. Bradford, and J.&nbsp;H. Davenport.</dt>
        <dd>A remark on the multiplication of sparse polynomials. Technical Report TR 89-21, School of Mathematical Sciences, University of Bath, 1989.</dd>
        <dt id="Abbott:87">[Abbott:87] J.&nbsp;A. Abbott and J.&nbsp;H. Davenport.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-51517-8_144">Polynomial factorization: An exploration of Lenstra&apos;s algorithm</a>. In: <em>Proc. EUROCAL &apos;87, Lecture Notes in Computer Science</em>, volume 378, pages 391-402. Springer-Verlag, 1987.</dd>
        <dt id="Abbott:88a">[Abbott:88a] J.&nbsp;A. Abbott and J.&nbsp;H. Davenport.</dt>
        <dd>A remark on a paper by Wang: Another surprising property of 42. <em>Math. Comp.</em> <strong>51</strong>, pages 837-839, 1988.</dd>
        <dt id="Abbott:98">[Abbott:98] John&nbsp;A. Abbott, Andr&eacute; van Leeuwen, and Andreas Strotmann.</dt>
        <dd><a href="http://people.brunel.ac.uk/~hssrjis/issue/Volume%208%20%20Abstracts/j834p4~1.htm">OpenMath: communicating mathematical information between co-operating agents in a knowledge network</a>. <em>Journal of Intelligent Systems</em> <strong>8</strong> no. 3/4, 1998.</dd>
        <dt id="Abdali:88">[Abdali:88] S.&nbsp;K. Abdali and D.&nbsp;S. Wise.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-51084-2_9">Experiments with quadtree representation of matrices</a>. In: <em>Proc. of ISSAC &apos;88</em>, volume 358, pages 96-108. Springer-Verlag, 1988.</dd>
        <dt id="Abiezzi:83">[Abiezzi:83] Salim&nbsp;S. Abi-Ezzi.</dt>
        <dd><a href="http://doi.acm.org/10.1145/1089338.1089345">Clarification to the symbolic mode in REDUCE</a>. <em>SIGSAM Bulletin</em> <strong>17</strong> no. 3 and 4, pages 43-47, August and November 1983.</dd>
        <dt id="Abramov:91">[Abramov:91] S.&nbsp;A. Abramov and K.&nbsp;Yu. Kvansenko.</dt>
        <dd><a href="http://doi.acm.org/10.1145/120694.120735">Fast algorithms to search for the rational solutions of linear differential equations with polynomial coefficients</a>. In: Stephen&nbsp;M. Watt, editor, <em>Proc. of the 1991 International Symposium on Symbolic and Algebraic Computation</em>, pages 267-270, Maryland, 1991. ACM Press.</dd>
        <dt id="Abramov:91a">[Abramov:91a] S.&nbsp;A. Abramov and K.&nbsp;Yu. Kvashenko.</dt>
        <dd>Fast search of a certain type solutions of linear ordinary differential equations with polynomial coefficients. Technical report, Computer Center of the USSR, Academy of Science, Moscow, 1991.</dd>
        <dt id="Adamchik90">[Adamchik90] V.&nbsp;S. Adamchik and O.&nbsp;I. Marichev.</dt>
        <dd><a href="http://doi.acm.org/10.1145/96877.96930">The algorithm for calculating integrals of hypergeometric type functions and its realization in REDUCE system</a>. In: S.&nbsp;Watanabe and Morio Nagata, editors, <em>Proceedings of the 1990 International Symposium on Symbolic and Algebraic Computation</em>, pages 212-224. ACM, Addison-Wesley, 1990.</dd>
        <dt id="Adams:83">[Adams:83] K.&nbsp;J. Adams.</dt>
        <dd><a href="http://dx.doi.org/10.1109/TNS.1983.4332839">Analytic estimates for the dynamic aperture of nonlinear lattices</a>. <em>IEEE Trans. Nucl. Sci.</em>
            <strong>30</strong> no. 4, pages 2436-2438, August 1983.</dd>
        <dt id="Adkins:83">[Adkins:83] G.&nbsp;S. Adkins.</dt>
        <dd><a href="http://link.aps.org/doi/10.1103/PhysRevA.27.530">Analytic evaluation of an O(&alpha;) vertex correction to the rate of orthopositronium</a>. <em>Phys. Rev. A</em> <strong>27</strong> no. 1, pages 530-532, 1983.</dd>
        <dt id="Adkins:85">[Adkins:85] G.&nbsp;S. Adkins.</dt>
        <dd><a href="http://link.aps.org/doi/10.1103/PhysRevA.31.1250">Inner-vertex contributions to the decay rate of orthopositronium</a>. <em>Phys. Rev. A</em> <strong>31</strong> no. 3, pages 1250-1252, 1985.</dd>
        <dt id="Adkins:83a">[Adkins:83a] G.&nbsp;S. Adkins and F.&nbsp;R. Brown.</dt>
        <dd><a href="http://link.aps.org/doi/10.1103/PhysRevA.28.1164">Rate for positronium decay to five photons</a>. <em>Phys. Rev. A</em> <strong>28</strong> no. 2, pages 1164-1165, 1983.</dd>
        <dt id="Aguilera-Navarro:87">[Aguilera-Navarro:87] V.&nbsp;C. Aguilera-Navarro, R.&nbsp;Guardiola, C.&nbsp;Keller, M.&nbsp;de&nbsp;Llano, M.&nbsp;Popovic, and M.&nbsp;Fortes.</dt>
        <dd><a href="http://link.aps.org/doi/10.1103/PhysRevA.35.3901">Van der Waals perturbation theory for fermion and boson ground-state matter</a>. <em>Phys. Rev. A</em> <strong>35</strong> no. 9, pages 3901-3910, 1987.</dd>
        <dt id="Akselrod:90">[Akselrod:90] I.R. Akselrod, V.P. Gerdt, V.E. Kovtun, and V.N. Robuk.</dt>
        <dd>Construction of a Lie algebra by a subset of generators and commutation relations. Preprint E5-90-508, J.I.N.R., 1990.</dd>
        <dt id="Aldins:69">[Aldins:69] J.&nbsp;Aldins, S.&nbsp;J. Brodsky, A.&nbsp;J. Dufner, and T.&nbsp;Kinoshita.</dt>
        <dd><a href="http://link.aps.org/doi/10.1103/PhysRevLett.23.441">Photon-photon scattering contribution to the sixth order magnetic moments of the muon and electron</a>. <em>Physical Review Letters</em> <strong>23</strong> no. 8, pages 441-443, 1969.</dd>
        <dt id="Alekseev:86">[Alekseev:86] A.&nbsp;I. Alekseev and V.&nbsp;F. Edneral.</dt>
        <dd>Tensor structure of axial gauge polarization operator in the infrared region. Preprint 86-46, IHEP, 1986.</dd>
        <dt id="Alekseev:87a">[Alekseev:87a] A.&nbsp;I. Alekseev and V.&nbsp;F. Edneral.</dt>
        <dd>On evaluation of Feynman integrals in axial gauge. Preprint 87-118, IHEP, 1987.</dd>
        <dt id="Alekseev:87">[Alekseev:87] A.&nbsp;I. Alekseev and V.&nbsp;F. Edneral.</dt>
        <dd>Tensor structure of gluon polarization operator in the axial gauge for infra-red region. <em>Journal of Nuclear Physics</em> pages 1105-1114, 1987.</dd>
        <dt id="Alfeld:82">[Alfeld:82] P.&nbsp;Alfeld.</dt>
        <dd>Fixed point iteration with inexact function values. <em>Math. Comp.</em> <strong>38</strong>, pages 87-98, 1982.</dd>
        <dt id="Amirkhanov:87">[Amirkhanov:87] I.&nbsp;V. Amirkhanov, E.&nbsp;P. Zhidkov, and I.&nbsp;E. Zhidkova.</dt>
        <dd>The conditions of bounding of the oscillation amplitudes of charge particle within the resonance vicinity investigations. Technical Report P11-87-452, J.I.N.R., Dubna, 1987.</dd>
        <dt id="Amirkhanov:91">[Amirkhanov:91] I.V. Amirkhanov, E.P. Zhidkov, and I.E. Zhidkova.</dt>
        <dd><a href="http://doi.acm.org/10.1145/120694.120767">The betatron oscillations in the vicinity of nonlinear resonance in cyclic accelerator investigation</a>. In: Stephen&nbsp;M. Watt, editor, <em>Proc. of the 1991 International Symposium on Symbolic and Algebraic Computation</em>, pages 452-453, Maryland, 1991. ACM Press.</dd>
        <dt id="Anco:04a">[Anco:04a] S.&nbsp;Anco and T.&nbsp;Wolf.</dt>
        <dd><a href="http://www.atlantis-press.com/php/download_paper.php?id=477">Some symmetry classifications of hyperbolic vector evolution equations</a>. <em>JNMP</em> <strong>12</strong> no. Supplement 1, pages 13-31, 2005. preprint nlin.SI/0412015.</dd>
        <dt id="Antweiler:89">[Antweiler:89] Werner Antweiler, Andreas Strotmann, and Volker Winkelmann.</dt>
        <dd><a href="http://doi.acm.org/10.1145/70936.70940">A TeX-REDUCE-interface</a>. <em>SIGSAM Bulletin</em> <strong>23</strong> no. 2, pages 26-33, February 1989.</dd>
        <dt id="Appelquist:70">[Appelquist:70] T.&nbsp;W. Appelquist and S.&nbsp;J. Brodsky.</dt>
        <dd><a href="http://link.aps.org/doi/10.1103/PhysRevLett.24.562">The order &alpha;<sup>2</sup> electrodynamic corrections to the Lamb shift</a>. <em>Physical Review Letters</em> <strong>24</strong> no. 11, pages 562-565, 1970.</dd>
        <dt id="Arbuzov:86">[Arbuzov:86] B.&nbsp;A. Arbuzov, E.&nbsp;E. Boos, and A.&nbsp;I. Davydychev.</dt>
        <dd>Infrared asymptotics of gluonic Green functions in covariant gauge. Preprint 86-123, IHEP, 1986.</dd>
        <dt id="Arous:93">[Arous:93] Gerard&nbsp;Ben Arous, Michael Cranston, and Wilfrid&nbsp;S. Kendall.</dt>
        <dd>Coupling constructions for hypoelliptic diffusions: Two examples. Research Report 261, University of Warwick, Dept. of Statistics, October 1993.</dd>
        <dt id="AskeyWilson:85">[AskeyWilson:85] R.&nbsp;Askey and J.&nbsp;Wilson.</dt>
        <dd>Some basic hypergeometric orthogonal polynomials that generalize jacobi polynomials. <em>Memoirs Amer. Math. Soc.</em> <strong>54</strong> no. 319, March 1985.</dd>
        <dt id="Aso:81">[Aso:81] T.&nbsp;Aso, T.&nbsp;Nonoyama, and S.&nbsp;Kato.</dt>
        <dd><a href="http://dx.doi.org/10.1029/JA086iA13p11388">Numerical simulation of semidiurnal atmospheric tides</a>. <em>J. Geophys. Res.</em> <strong>86</strong> no. 11, pages 388-400, 1981.</dd>
        <dt id="Atherton:73">[Atherton:73] R.&nbsp;W. Atherton and G.&nbsp;M. Homsey.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0021-9991(73)90124-1">Use of symbolic computation to generate evolution equations and asymptotic solutions to elliptic equations</a>. <em>Journal of Computational Physics</em> <strong>13</strong> no. 1, pages 45-59, 1973.</dd>
        <dt id="Atkinson:08">[Atkinson:08] James Atkinson, Jarmo Hietarinta, and Frank Nijhoff.</dt>
        <dd><a href="http://arxiv.org/abs/0801.0806">Soliton solutions for Q3</a>. <em>Journal of Physics A: Mathematical and Theoretical</em> <strong>41</strong> no. 14, pages 1-11, April 2008.</dd>
        <dt id="Audoly:98">[Audoly:98] S.&nbsp;Audoly, L.&nbsp;D&apos;Angi&ograve;, M.P. Saccomani, and C.&nbsp;Cobelli.</dt>
        <dd><a href="http://dx.doi.org/10.1109/10.650350">Global identifiability of linear compartmental models. A computer algebra algorithm</a>. <em>IEEE Trans. Biomedical Engineering</em> <strong>45</strong> no. 1, pages 36-47, 1998.</dd>
        <dt id="Aurenche:84">[Aurenche:84] P.&nbsp;Aurenche, A.&nbsp;Douir, R.&nbsp;Baier, M.&nbsp;Fontannaz, and D.&nbsp;Schiff.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0370-2693(84)90475-1">Photoproduction of hadrons at large transverse momentum in second order QCD</a>. <em>Physics Letters B</em> <strong>135</strong> no. 1-3, pages 164-168, 1984.</dd>
        <dt id="Aurenche:84a">[Aurenche:84a] P.&nbsp;Aurenche, A.&nbsp;Douir, R.&nbsp;Baier, M.&nbsp;Fontannaz, and D.&nbsp;Schiff.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0370-2693(84)91053-0">Prompt photon production at large p<sub>T</sub> in GCD beyond the leading order</a>. <em>Physics Letters B</em> <strong>140</strong> no. 1, pages 87-92, 1984.</dd>
        <dt id="Autin:89">[Autin:89] B.&nbsp;Autin and J.&nbsp;Bengtsson.</dt>
        <dd><a href="http://dx.doi.org/10.1016/S0747-7171(89)80050-1">Symbolic evaluation of integrals occurring in accelerator orbit theory</a>. <em>Journal of Symbolic Computation</em> <strong>7</strong> no. 2, pages 183-187, February 1989.</dd>
    </dl>

    <dl id='B'>
        <dt id="Baekler:87a">[Baekler:87a] P.&nbsp;Baekler and M.&nbsp;Guerses.</dt>
        <dd><a href="http://dx.doi.org/10.1007/BF00416847">Exact solutions of the Poincar&eacute; gauge theory from its linearized field equations</a>. <em>Lett. Math. Phys.</em> <strong>14</strong> no. 3, pages 185-191, October 1987.</dd>
        <dt id="Baekler:88b">[Baekler:88b] P.&nbsp;Baekler, M.&nbsp;Guerses, and F.&nbsp;W. Hehl.</dt>
        <dd><a href="http://dx.doi.org/10.1088/0264-9381/5/7/001">A new method to solve the field equations of Poincar&eacute; gauge theories</a>. <em>Classical and Quantum Gravity</em> <strong>5</strong> no. 7, pages L105-L112, 1988.</dd>
        <dt id="Baekler:88a">[Baekler:88a] P.&nbsp;Baekler, M.&nbsp;Guerses, F.&nbsp;W. Hehl, and J.&nbsp;D. McCrea.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0375-9601(88)90366-0">The exterior gravitational field of a charged spinning source in the Poincar&eacute; gauge theory: A Kerr-Newman metric with dynamic torsion</a>. <em>Physics Letters A</em> <strong>128</strong> no. 5, pages 245-250, 1988.</dd>
        <dt id="Baekler:87">[Baekler:87] P.&nbsp;Baekler, R.&nbsp;Hecht, F.&nbsp;W. Hehl, and T.&nbsp;Shirafuji.</dt>
        <dd><a href="http://ptp.ipap.jp/link?PTP/78/16/">Mass and spin of exact solutions of the Poincar&eacute; gauge theory</a>. <em>Prog. Theor. Phys.</em> <strong>78</strong> no. 1, pages 16-21, 1987.</dd>
        <dt id="Baekler:84">[Baekler:84] P.&nbsp;Baekler and F.&nbsp;W. Hehl.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0375-9601(84)90627-3">A charged Taub-NUT metric with torsion: A new axially symmetric solution of the Poincar&eacute; gauge field theory</a>. <em>Physics Letters A</em> <strong>100</strong> no. 8, pages 277-316, 1984.</dd>
        <dt id="Baekler:86">[Baekler:86] P.&nbsp;Baekler, F.&nbsp;W. Hehl, and E.&nbsp;W. Mielke.</dt>
        <dd>Nonmetricity and torsion: Facts and fancies in gauge approaches to gravity. In: R.&nbsp;Ruffini, editor, <em>Proc. 4th Marcel Grossmann Meeting on General Relativity</em>, pages 277-316. North-Holland, Amsterdam, 1986.</dd>
        <dt id="Baekler:87b">[Baekler:87b] P.&nbsp;Baekler, E.&nbsp;W. Mielke, and F.&nbsp;W. Hehl.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0550-3213(87)90239-2">Kinky torsion in a Poincar&eacute; gauge model of gravity coupled to a massless scalar field</a>. <em>Nuclear Physics B</em> <strong>288</strong>, pages 800-812, 1987.</dd>
        <dt id="Baekler:88">[Baekler:88] P.&nbsp;Baekler, M.&nbsp;Seitz, and V.&nbsp;Winkelmann.</dt>
        <dd><a href="http://dx.doi.org/10.1088/0264-9381/5/3/009">Cylindrically symmetric solutions of self-consistently coupled Dirac fields in gauge theories of gravity</a>. <em>Classical and Quantum Gravity</em> <strong>5</strong> no. 3, pages 479-490, 1988.</dd>
        <dt id="Baekler:84a">[Baekler:84a] Peter Baekler and Friedrich&nbsp;W. Hehl.</dt>
        <dd>On the dynamics of the torsion of spacetime: Exact solutions in a gauge theoretical model of gravity. In: Errol Gotsman and Gerald Tauber, editors, <em>From SU(3) to Gravity</em>, pages 341-360. Cambridge University Press, 1985.</dd>
        <dt id="Bahrdt:90">[Bahrdt:90] J.&nbsp;Bahrdt and G.&nbsp;W&uuml;stefeld.</dt>
        <dd>A new tracking routine for particles in undulator and wiggler fields. Report BESSY TB Nr. 158, Technischer Bericht, October 1990.</dd>
        <dt id="Bahrdt:91">[Bahrdt:91] J.&nbsp;Bahrdt and G.&nbsp;W&uuml;stefeld.</dt>
        <dd>Canonical particle tracking in undulator fields. In: <em>Proceedings of the IEEE 1991 Particle Accelerator Conference, San Francisco</em>, page 266, 1991.</dd>
        <dt id="Bahrdt:92">[Bahrdt:92] J.&nbsp;Bahrdt and G.&nbsp;W&uuml;stefeld.</dt>
        <dd>A taylor-expanded generating function for particle motion in arbitrary magnetic fields. In: <em>Proceedings of the Third European Particle Accelerator Conference, Berlin (Germany)</em>, page 670, 1992.</dd>
        <dt id="Bahrdt:07">[Bahrdt:07] Johannes Bahrdt.</dt>
        <dd><a href="http://dx.doi.org/10.1103/PhysRevSTAB.10.060701">Wavefront tracking within the stationary phase approximation</a>. <em>Phys. Rev. ST Accel. Beams</em> <strong>10</strong> no. 6, page 060701, Jun 2007.</dd>
        <dt id="Baier:81">[Baier:81] V.&nbsp;N. Baier and A.&nbsp;G. Grozin.</dt>
        <dd>Inclusive quarkonium production in e<sup>+</sup> e<sup>-</sup> annihilation. <em>Yad. Fiz. (Sov. J. Nucl. Phys.)</em> <strong>33</strong> no. 2, pages 491-500, 1981.</dd>
        <dt id="Baier:85">[Baier:85] V.&nbsp;N. Baier and A.&nbsp;G. Grozin.</dt>
        <dd><a href="http://dx.doi.org/10.1007/BF01571399">Gluonic contributions to the exclusive amplitudes</a>. <em>Zeitschrift f&uuml;r Physik C. Particles and Fields</em> <strong>29</strong>, pages 161-165, 1985.</dd>
        <dt id="Baier:90">[Baier:90] V.&nbsp;N. Baier and A.&nbsp;G. Grozin.</dt>
        <dd><a href="http://dx.doi.org/10.1007/BF01552334">Decay B &rarr; D l <span style="text-decoration: overline;">&nu;</span> from QCD sum rules</a>. <em>Zeitschrift f&uuml;r Physik C. Particles and Fields</em> <strong>47</strong>, pages 669-675, 1990.</dd>
        <dt id="Bajla:78">[Bajla:78] I.&nbsp;Bajla, G.&nbsp;A. Ososkov, and A.&nbsp;C. Hearn.</dt>
        <dd>The orthogonalization program of polynomials in two variables in REDUCE-2 language. Report P10-11944, J.I.N.R., Dubna, 1978.</dd>
        <dt id="Baker:81a">[Baker:81a] G.&nbsp;A. Baker, L.&nbsp;P. Benofy, M.&nbsp;Fortes, M.&nbsp;de&nbsp;Llano, S.&nbsp;M. Peltier, and A.&nbsp;Plastino.</dt>
        <dd><a href="http://link.aps.org/doi/10.1103/PhysRevA.26.3575">Hard-core square-well fermion</a>. <em>Phys. Rev. A</em> <strong>26</strong> no. 6, pages 3575-3588, 1982.</dd>
        <dt id="Baker:81">[Baker:81] George&nbsp;A. Baker(Jr.) and Peter Graves-Morris.</dt>
        <dd><em>Pad&eacute; Approximants, Part I: Basic Theory</em>. Addison-Wesley Publishing Company, Reading, Massachusetts, 1981.</dd>
        <dt id="Balian:78">[Balian:78] R.&nbsp;Balian, G.&nbsp;Parisi, and A.&nbsp;Voros.</dt>
        <dd>Quartic oscillator. In: <em>Proc. of the Colloq. on Mathematical Problems in Feynman Path Integrals, Marseille</em>, May 1978.</dd>
        <dt id="Bamberger:88">[Bamberger:88] L.&nbsp;Bamberger.</dt>
        <dd>An error validation package for REDUCE. In: <em>ESPRIT &apos;88: putting the technology to use: proceedings of the 5th Annual ESPRIT Conference, Brussels</em>, pages 467-474 (vol. 1), Siemens AG, Munich, West Germany, 1988.</dd>
        <dt id="Baranov:07">[Baranov:07] S.&nbsp;P. Baranov.</dt>
        <dd><a href="http://link.aps.org/abstract/PRD/v74/e074002">Associated y+b+<span style="text-decoration: overline;">b</span> production at the Fermilab Tevatron and CERN LHC</a>. <em>Physical Review D (Particles and Fields)</em> <strong>74</strong> no. 7, page 074002, November 2006.</dd>
        <dt id="Baranov:06">[Baranov:06] S.&nbsp;P. Baranov.</dt>
        <dd><a href="http://link.aps.org/abstract/PRD/v73/e074021">Topics in associated j/&psi; + c + <span style="text-decoration: overline;">c</span> production at modern colliders</a>. <em>Physical Review D (Particles and Fields)</em> <strong>73</strong> no. 7, page 074021, 2006.</dd>
        <dt id="Baranov:08">[Baranov:08] S.&nbsp;P. Baranov and A.&nbsp;Szczurek.</dt>
        <dd><a href="http://arxiv.org/abs/0710.1792">Inclusive production of j/&psi; meson in proton-proton collisions at bnl rhic</a>. <em>Physical Review D (Particles and Fields)</em> <strong>77</strong> no. 5, page 054016, 2008.</dd>
        <dt id="Barbier:92">[Barbier:92] Christine Barbier, Peter Bettess, and Jacqueline&nbsp;A. Bettess.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0747-7171(92)90021-U">Automatic generation of mapping functions for infinite elements using REDUCE</a>. <em>Journal of Symbolic Computation</em> <strong>14</strong> no. 5, pages 523-534, November 1992.</dd>
        <dt id="Barfoot:86">[Barfoot:86] D.&nbsp;T. Barfoot and D.&nbsp;J. Broadhurst.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0370-2693(86)90815-4">Investigation of a bound on the anomalous dimensions of four-quark operators</a>. <em>Physics Letters B</em> <strong>166</strong> no. 3, pages 347-350, 1986.</dd>
        <dt id="Barfoot:87">[Barfoot:87] D.&nbsp;T. Barfoot and D.&nbsp;J. Broadhurst.</dt>
        <dd><a href="http://dx.doi.org/10.1007/BF01552545">Finite field theories in three dimensions with and without supersymmetry</a>. <em>Zeitschrift f&uuml;r Physik C. Particles and Fields</em> <strong>33</strong> no. 3, pages 391-395, September 1987.</dd>
        <dt id="Barfoot:88">[Barfoot:88] D.&nbsp;T. Barfoot and D.&nbsp;J. Broadhurst.</dt>
        <dd><a href="http://dx.doi.org/10.1007/BF01412581">Z<sub>2</sub>&times;S<sub>6</sub>
            symmetry of the two-loop diagram</a>. <em>Zeitschrift f&uuml;r Physik C. Particles and Fields</em> <strong>41</strong> no. 1, pages 81-85, March 1988.</dd>
        <dt id="Bark:78">[Bark:78] Fritz&nbsp;H. Bark and Herman Tinoco.</dt>
        <dd><a href="http://dx.doi.org/10.1017/S0022112078001627">Stability of plane Poiseuille flow of a dilute suspension of slender fibres</a>. <em>J. Fluid Mech.</em> <strong>87</strong> no. 2, pages 321-333, 1978.</dd>
        <dt id="Barthes-Biesel:73">[Barthes-Biesel:73] D.&nbsp;Barthes-Biesel and A.&nbsp;Acrivos.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0021-9991(73)90161-7">On computer generated analytic solutions to the equations of fluid mechanics, the case of creeping flows</a>. <em>Journal of Computational Physics</em> <strong>12</strong> no. 3, pages 403-411, 1973.</dd>
        <dt id="Barton:72">[Barton:72] David Barton and Anthony&nbsp;C. Hearn.</dt>
        <dd>Comment on problem #2 - the Y(2n) functions. <em>SIGSAM Bulletin</em> <strong>15</strong>, 1972.</dd>
        <dt id="Basios:95">[Basios:95] V.&nbsp;Basios, N.&nbsp;A. Chekanov, B.&nbsp;L. Markovski, V.&nbsp;A. Rostovtsev, and S.&nbsp;I. Vinitsky.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0010-4655(95)00080-Y">GITA: A REDUCE program for the normalization of polynomial hamiltonians</a>. <em>Computer Physics Communications</em> <strong>90</strong>, pages 355-368, October 1995.</dd>
        <dt id="Bateman:86">[Bateman:86] G.&nbsp;Bateman and R.&nbsp;G. Storer.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0021-9991(86)90023-9">Direct determination of axisymmetric magnetohydrodynamic equilibrium in Hamada coordinates</a>. <em>Journal of Computational Physics</em> <strong>64</strong> no. 1, pages 161-176, 1986.</dd>
        <dt id="Bayram:04">[Bayram:04] Mustafa Bayram.</dt>
        <dd><a href="http://dx.doi.org/10.1016/S0096-3003(03)00600-3">Application of computer algebra matrix operation techniques to the control of metabolic networks</a>. <em>Applied Mathematics and Computation</em> <strong>152</strong> no. 1, pages 289-297, April 2004.</dd>
        <dt id="Becker:93">[Becker:93] Thomas Becker, Volker Weispfenning, and Heinz Kredel.</dt>
        <dd><a href="http://dx.doi.org/http://www.springer.com/math/book/978-0-387-97971-7"><em>Gr&ouml;bner bases, a computational approach to commutative algebra</em></a>. Springer-Verlag (Graduate Texts in Mathematics 141), 1993.</dd>
        <dt id="Belkov:91">[Belkov:91] Alexander&nbsp;A. Bel&apos;Kov and Alexander&nbsp;V. Lanyov.</dt>
        <dd><a href="http://doi.acm.org/10.1145/120694.120768">REDUCE usage for calculation of low-energy process amplitudes in chiral QCD model</a>. In: Stephen&nbsp;M. Watt, editor, <em>Proc. of the 1991 International Symposium on Symbolic and Algebraic Computation</em>, pages 454-455, Maryland, 1991. ACM Press.</dd>
        <dt id="Belkov:96">[Belkov:96] Alexander&nbsp;A. Bel&apos;Kov, Alexander&nbsp;V. Lanyov, and A.&nbsp;Schaale.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0010-4655(96)00031-8">Calculation of heat-kernel coefficients and usage of computer algebra</a>. <em>Computer Physics Communications</em> <strong>95</strong> no. 2 and 3, pages 123-130, June 1996.</dd>
        <dt id="Bennett:88">[Bennett:88] J.&nbsp;P. Bennett, J.&nbsp;H. Davenport, and H.&nbsp;M. Sauro.</dt>
        <dd>Solution of some equations in biochemistry. Technical Report 88-12, School of Mathematical Sciences, University of Bath, England, 1988.</dd>
        <dt id="Bennett:93">[Bennett:93] J.&nbsp;P. Bennett, M.&nbsp;Grinfeld, and J.&nbsp;Hubble.</dt>
        <dd><a href="http://dx.doi.org/10.1006/jsco.1993.1006">Computer algebra techniques in affinity binding equations: the dimer case</a>. <em>Journal of Symbolic Computation</em> <strong>15</strong> no. 1, pages 79-83, January 1993.</dd>
        <dt id="Berends:81">[Berends:81] A.&nbsp;Berends, R.&nbsp;Kleiss, P.&nbsp;de&nbsp;Causmaecher, and T.&nbsp;T. Wu.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0370-2693(81)90685-7">Single bremsstrahlung process in gauge theories</a>. <em>Physics Letters B</em>
            <strong>103</strong> no. 2, pages 124-128, 1981.</dd>
        <dt id="Berkovich:06">[Berkovich:06] L.&nbsp;M. Berkovich and S.&nbsp;A. Evlakhov.</dt>
        <dd><a href="http://dx.doi.org/10.1134/S0361768806030066">On the Euler-Imshenetskii-Darboux transformation of linear second-order equations</a>. <em>Programming and Computer Software</em> <strong>32</strong> no. 3, pages 154-165, 2006.</dd>
        <dt id="Berkovich:89">[Berkovich:89] L.M. Berkovich, V.P. Gerdt, Z.T. Kostova, and M.L. Nechaevsky.</dt>
        <dd>Second order reducible linear differential equations. Preprint E5-89-141, J.I.N.R., Dubna, 1989.</dd>
        <dt id="Berkovich:90">[Berkovich:90] L.M. Berkovich, V.P. Gerdt, Z.T. Kostova, and M.L. Nechaevsky.</dt>
        <dd>Computer algebra generating related 2nd order linear differential equation. Preprint E5-90-509, J.I.N.R., Dubna, 1990.</dd>
        <dt id="Berman:63">[Berman:63] S.&nbsp;M. Berman and Y.&nbsp;S. Tsai.</dt>
        <dd><a href="http://link.aps.org/doi/10.1103/PhysRevLett.11.483">Intermediate boson pair production as a means for determining its magnetic moment</a>. <em>Physical Review Letters</em> <strong>11</strong> no. 10, pages 483-487, 1963.</dd>
        <dt id="Berndt:91">[Berndt:91] R.&nbsp;Berndt, A.&nbsp;Lock, G.&nbsp;Witte, and Ch. W&ouml;ll.</dt>
        <dd><a href="http://doi.acm.org/10.1145/120694.120763">Application of computer algebra to surface lattice dynamics</a>. In: Stephen&nbsp;M. Watt, editor, <em>Proc. of the 1991 International Symposium on Symbolic and Algebraic Computation</em>, pages 433-438, Maryland, 1991. ACM Press.</dd>
        <dt id="Berth:00">[Berth:00] Matthias Berth, Frank-Michael Moser, and Arrigo Triulzi.</dt>
        <dd>Implementing computational services based on OpenMath. In: V.&nbsp;G. Ganzha, E.&nbsp;W. Mayr, and E.&nbsp;V. Vorozhtsov, editors, <em>Computer Algebra in Symbolic Computing, CASC 2000</em>, pages 49-60. Springer-Verlag, 2000.</dd>
        <dt id="Bessis:85">[Bessis:85] N.&nbsp;Bessis, G.&nbsp;Bessis, and D.&nbsp;Roux.</dt>
        <dd><a href="http://link.aps.org/doi/10.1103/PhysRevA.32.2044">Closed-form expressions for the Dirac-Coulomb radial r<sup>t</sup> integrals</a>. <em>Phys. Rev. A</em> <strong>32</strong> no. 4, pages 2044-2050, 1985.</dd>
        <dt id="Bilge:92">[Bilge:92] Ayse&nbsp;H&uuml;meyra Bilge.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0010-4655(92)90013-O">A REDUCE program for the integration of differential polynomials</a>. <em>Computer Physics Communications</em> <strong>71</strong> no. 3, pages 263-268, September 1992.</dd>
        <dt id="Billoire:78">[Billoire:78] A.&nbsp;Billoire, R.&nbsp;Lacaze, A.&nbsp;Morel, and H.&nbsp;Navelet.</dt>
        <dd>The OZI rule violating radiative decays of the heavy pseudoscalars. Report DpH-T 43/78, CEN-Saclay, 1978.</dd>
        <dt id="Biro:87">[Biro:87] T.&nbsp;S. Biro, K.&nbsp;Niita, A.&nbsp;L. de&nbsp;Paoli, W.&nbsp;Bauer, W.&nbsp;Cassing, and U.&nbsp;Mosel.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0375-9474(87)90080-7">Microscopic theory of photon production in proton-nucleus and nucleus-nucleus collisions</a>. <em>Nuclear Physics A</em> <strong>475</strong> no. 3, pages 579-597, December 1987.</dd>
        <dt id="Biro:86">[Biro:86] T.&nbsp;S. Biro, J.&nbsp;Zimanyi, and M.&nbsp;Zimanyi.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0370-2693(86)90344-8">Hadrochemistry in relativistic mean fields</a>. <em>Physics Letters B</em> <strong>167</strong> no. 3, pages 271-276, February 1986.</dd>
        <dt id="Birrell:77">[Birrell:77] N.&nbsp;D. Birrell.</dt>
        <dd>The application of adiabatic regularization to calculations of cosmological interest. Technical report, Dept. Math, King&apos;s College, London, 1977.</dd>
        <dt id="Biswas:75">[Biswas:75] S.&nbsp;N. Biswas, S.&nbsp;R. Chaudhuri, K.&nbsp;S. Taank, and J.&nbsp;A. Campbell.</dt>
        <dd><a href="http://link.aps.org/doi/10.1103/PhysRevD.12.2523">Neutrino production in stellar matter by photons in a renormalizable scalar-boson-exchange model of weak interactions</a>. <em>Physical Review D (Particles and Fields)</em> <strong>12</strong> no. 8, pages 2523-2525, 1975.</dd>
        <dt id="Bittencourt:90">[Bittencourt:90] Guilherme Bittencourt and Jacques Calmet.</dt>
        <dd>Integrating computer algebra and knowledge representation. Preprint, Universit&auml;t Karlsruhe Institut f&uuml;r Algorithmen und Kognitive Systeme, 1990.</dd>
        <dt id="Blum:93">[Blum:93] W.&nbsp;Blum, V.&nbsp;Ganzha, and W.&nbsp;Strampp.</dt>
        <dd>An introduction to ode&apos;s by cas. In: G.&nbsp;Jacob, N.&nbsp;E. Oussous, and S.&nbsp;Steinberg, editors, <em>Proceedings of the 1993 International IMACS Symposium on Symbolic Computation</em>, pages 110-119. IMACS, Laboratoire d&apos;Informatique Fondamentale de Lille, France, 1993.</dd>
        <dt id="Bocko:92">[Bocko:92] J.&nbsp;Bocko.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0010-4655(92)90141-K">EQSHELL - a REDUCE-based program for generation of equations of equilibrium for shell</a>. <em>Computer Physics Communications</em> <strong>69</strong> no. 1, pages 215-222, February 1992.</dd>
        <dt id="Bodwin:04">[Bodwin:04] Geoffrey&nbsp;T. Bodwin and Jungil Lee.</dt>
        <dd><a href="http://arxiv.org/abs/hep-ph/0308016">Relativistic corrections to gluon fragmentation into spin-triplet s-wave quarkonium</a>. <em>Physical Review D (Particles and Fields)</em> <strong>69</strong> no. 5, page 054003, Mar 2004.</dd>
        <dt id="Boege:86">[Boege:86] W.&nbsp;Boege, R.&nbsp;Gebauer, and H.&nbsp;Kredel.</dt>
        <dd><a href="http://dx.doi.org/10.1006/jsco.1996.0042">Some examples for solving systems of algebraic equations by calculating Groebner bases</a>. <em>Journal of Symbolic Computation</em> <strong>2</strong> no. 1, pages 83-98, March 1986.</dd>
        <dt id="Bogdanova:88">[Bogdanova:88] N.&nbsp;Bogdanova and H.&nbsp;Hogreve.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0010-4655(88)90051-3">A REDUCE package for exact Coulomb interaction matrix elements</a>. <em>Computer Physics Communications</em> <strong>48</strong> no. 2, pages 319-326, February 1988.</dd>
        <dt id="Bondarev:06">[Bondarev:06] Alexander&nbsp;L. Bondarev.</dt>
        <dd><a href="http://arxiv.org/abs/hep-ph/0504223">A new method for calculation of traces of dirac &gamma;-matrices in minkowski space</a>. <em>Nuclear Physics B</em> <strong>733</strong> no. 1-2, pages 48-58, January 2006.</dd>
        <dt id="Bordoni:81">[Bordoni:81] Luciana Bordoni and Attilio Colagrossi.</dt>
        <dd><a href="http://doi.acm.org/10.1145/1089257.1089259">An application of REDUCE to industrial mechanics</a>. <em>SIGSAM Bulletin</em> <strong>15</strong> no. 2, pages 8-12, May 1981.</dd>
        <dt id="Borst:94">[Borst:94] W.&nbsp;N. Borst, V.&nbsp;V. Goldman, and J.&nbsp;A. van Hulzen.</dt>
        <dd><a href="http://doi.acm.org/10.1145/190347.190359">GENTRAN 90: a REDUCE package for the generation of Fortran 90 code</a>. In: <em>Symbolic and Algebraic Computation</em>, ISSAC, pages 45-51. SIGSAM, ACM, 1994.</dd>
        <dt id="Bowyer:87">[Bowyer:87] A.&nbsp;Bowyer, J.&nbsp;H. Davenport, P.&nbsp;S. Milne, J.&nbsp;A. Padget, and A.&nbsp;F. Wallis.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-51517-8_122">Applications of computer algebra in solid modelling</a>. In: <em>Proc. EUROCAL &apos;87, Lecture Notes in Computer Science</em>, volume 378, pages 244-245. Springer-Verlag, 1987.</dd>
        <dt id="Boyd:78">[Boyd:78] John&nbsp;P. Boyd.</dt>
        <dd>The effects of latitudinal shear on equatorial waves, part I: Theory and methods. Preprint, Dept. of Atmos. and Oceanic Science, Univ. of Michigan, January 1978.</dd>
        <dt id="Boyd:93">[Boyd:93] John&nbsp;P. Boyd.</dt>
        <dd><a href="http://dx.doi.org/10.1006/jsco.1993.1054">Chebyshev and Legendre spectral methods in algebraic manipulation languages</a>. <em>Journal of Symbolic Computation</em> <strong>16</strong> no. 4, pages 377-399, October 1993.</dd>
        <dt id="Brackx:92">[Brackx:92] F.&nbsp;Brackx and D.&nbsp;Constales.</dt>
        <dd><em>Computer Algebra with LISP and REDUCE</em>. Kluwer Academic Publishers, 1992.</dd>
        <dt id="Brackx:87a">[Brackx:87a] F.&nbsp;Brackx, D.&nbsp;Constales, R.&nbsp;Delanghe, and H.&nbsp;Serras.</dt>
        <dd>Clifford algebra with REDUCE. <em>Rend. Circ. Mat. Palermo, Ser. II</em> <strong>16</strong>, pages 11-19, 1987.</dd>
        <dt id="Brackx:89">[Brackx:89] F.&nbsp;Brackx, D.&nbsp;Constales, A.&nbsp;Ronveaux, and H.&nbsp;Serras.</dt>
        <dd><a href="http://dx.doi.org/10.1016/S0747-7171(89)80071-9">On the harmonic and monogenic decomposition of polynomials</a>. <em>Journal of Symbolic Computation</em> <strong>8</strong> no. 3, pages 297-304, September 1989.</dd>
        <dt id="Brackx:87">[Brackx:87] F.&nbsp;Brackx and H.&nbsp;Serras.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-51517-8_117">Boundary value problems for the Laplacian in Euclidean space solved by symbolic computation</a>. In: <em>Proc. EUROCAL &apos;87, Lecture Notes in Computer Science</em>, volume 378, pages 208-215. Springer-Verlag, 1987.</dd>
        <dt id="Bradford:88">[Bradford:88] R.&nbsp;J. Bradford and J.&nbsp;H. Davenport.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-51084-2_22">Effective tests for cyclotomic polynomials</a>. In: <em>Proc. of ISSAC &apos;88</em>, volume 358, pages 244-251. Springer-Verlag, 1988.</dd>
        <dt id="Bradford:86">[Bradford:86] R.&nbsp;J. Bradford, A.&nbsp;C. Hearn, J.&nbsp;A. Padget, and E.&nbsp;Schr&uuml;fer.</dt>
        <dd><a href="http://doi.acm.org/10.1145/32439.32460">Enlarging the reduce domain of computation</a>. In: <em>SYMSAC &apos;86: Proceedings of the fifth ACM symposium on Symbolic and algebraic computation</em>, pages 100-106, New York, NY, USA, 1986. ACM.</dd>
        <dt id="Bradford:90">[Bradford:90] Russell Bradford.</dt>
        <dd><a href="http://doi.acm.org/10.1145/96877.96965">A parallelization of the Buchberger algorithm</a>. In: S.&nbsp;Watanabe and Morio Nagata, editors, <em>Proceedings of the International Symposium on Symbolic and Algebraic Computation</em>, page 296. ACM, Addison-Wesley, 1990.</dd>
        <dt id="Brand:99">[Brand:99] A.&nbsp;Brand, M.&nbsp;Mohammadzadeh, and T.&nbsp;Wolf.</dt>
        <dd><a href="http://dx.doi.org/10.1006/jsco.1998.0250">Computer algebra algorithms and routines for the computation of conservation laws and fixing of gauge in differential expressions</a>. <em>Journal of Symbolic Computation</em> <strong>27</strong> no. 2, pages 221-238, February 1999.</dd>
        <dt id="Brand:92">[Brand:92] A.&nbsp;Brand and T.&nbsp;Wolf.</dt>
        <dd>The computer algebra package CRACK for investigating PDEs. In: <em>Proc. of ERCIM, Partial Differential Equations and Group Theory, Bonn</em>, page&nbsp;24, 1992.</dd>
        <dt id="Brand:94">[Brand:94] A.&nbsp;Brand and T.&nbsp;Wolf.</dt>
        <dd>Heuristics for overdetermined systems of PDEs. In: S.&nbsp;McKee J.H.&nbsp;Johnson and A.&nbsp;Vella, editors, <em>Proc. of `AI in Mathematics&apos;, Glasgow, April 91</em>. Oxford University Press, 1994.</dd>
        <dt id="Brand:95">[Brand:95] A.&nbsp;Brand and T.&nbsp;Wolf.</dt>
        <dd><a href="http://doi.acm.org/10.1145/214441.214444">Investigating DEs with CRACK and related programs</a>. <em>SIGSAM Bulletin</em> <strong>Special Issue</strong>, pages 1-8, June 1995.</dd>
        <dt id="Brand:96">[Brand:96] A.&nbsp;Brand and T.&nbsp;Wolf.</dt>
        <dd><a href="http://dx.doi.org/10.1016/S0378-4754(96)00014-6">Approaches to solving nonlinear ODEs</a>. <em>Math. Comp. Simul.</em> <strong>42</strong> no. 4-6, pages 391-398, 1996.</dd>
        <dt id="Brand:97">[Brand:97] A.&nbsp;Brand and T.&nbsp;Wolf.</dt>
        <dd><a href="http://dx.doi.org/10.1016/S0895-7177(97)00064-2">Examples of the investigation of differential equations with modularized programs</a>. <em>Math. Comput. Modelling</em> <strong>25</strong> no. 8/9, pages 133-139, April-May 1997.</dd>
        <dt id="Broadhurst:83">[Broadhurst:83] D.&nbsp;J. Broadhurst.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0370-2693(83)90432-X">Non-relativistic sum rules for QCD<sub>2</sub>, QED and QCD<sub>4</sub></a>. <em>Physics Letters B</em> <strong>123</strong> no. 3-4, pages 251-254, 1983.</dd>
        <dt id="Broadhurst:85a">[Broadhurst:85a] D.&nbsp;J. Broadhurst.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0370-2693(85)90340-5">Evaluation of a class of Feynman diagrams for all numbers of loops and dimensions</a>. <em>Physics Letters B</em> <strong>164</strong> no. 4-6, pages 356-360, 1985.</dd>
        <dt id="Broadhurst:87">[Broadhurst:87] D.&nbsp;J. Broadhurst.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0370-2693(87)90364-9">Two-loop negative-dimensional integration</a>. <em>Physics Letters B</em> <strong>197</strong> no. 1-2, pages 179-182, 1987.</dd>
        <dt id="Broadhurst:90">[Broadhurst:90] D.&nbsp;J. Broadhurst.</dt>
        <dd><a href="http://dx.doi.org/10.1007/BF01551921">The master two-loop diagram with masses</a>. <em>Zeitschrift f&uuml;r Physik C. Particles and Fields</em>
            <strong>47</strong> no. 1, pages 115-124, March 1990.</dd>
        <dt id="Broadhurst:92a">[Broadhurst:92a] D.&nbsp;J. Broadhurst.</dt>
        <dd><a href="http://dx.doi.org/10.1007/BF01559486">Three-loop on-shell charge renormalization without integration: &Lambda;<sup><span style="text-decoration: overline;">MS</span></sup><sub>QED</sub> to four loops</a>. <em>Zeitschrift f&uuml;r Physik C. Particles and Fields</em> <strong>54</strong> no. 4, pages 599-606, December 1992.</dd>
        <dt id="Broadhurst:93">[Broadhurst:93] D.&nbsp;J. Broadhurst.</dt>
        <dd><a href="http://dx.doi.org/10.1007/BF01560355">Large N expansion of QED: asymptotic photon propagator and contributions to the muon anomaly, for any number of loops</a>. <em>Zeitschrift f&uuml;r Physik C. Particles and Fields</em> <strong>58</strong> no. 2, pages 339-345, June 1993.</dd>
        <dt id="Broadhurst:96">[Broadhurst:96] D.&nbsp;J. Broadhurst.</dt>
        <dd>On the enumeration of irreducible &kappa;-fold euler sums and their roles in knot theory and field theory. Technical Report OUT-4102-62, Open University, Milton Keynes MK7 6AA, England, April 1996.</dd>
        <dt id="Broadhurst:94">[Broadhurst:94] D.&nbsp;J. Broadhurst, P.&nbsp;A. Baikov, V.&nbsp;A. Ilyin, J.&nbsp;Fleischer, O.&nbsp;V. Tarasov, and V.&nbsp;A. Smirnov.</dt>
        <dd><a href="http://arxiv.org/pdf/hep-ph/9403274">Two-loop gluon-condensate contributions to heavy-quark current correlators: exact results and approximations</a>. <em>Physics Letters B</em> <strong>329</strong> no. 1, pages 103-110, 1994.</dd>
        <dt id="Broadhurst:93a">[Broadhurst:93a] D.&nbsp;J. Broadhurst, J.&nbsp;Fleischer, and O.&nbsp;V. Tarasov.</dt>
        <dd><a href="http://arxiv.org/pdf/hep-ph/9304303">Two-loop two-point functions with masses: asymptotic expansions and Taylor series, in any dimension</a>. <em>Zeitschrift f&uuml;r Physik C. Particles and Fields</em> <strong>60</strong> no. 2, pages 287-301, 1993.</dd>
        <dt id="Broadhurst:84">[Broadhurst:84] D.&nbsp;J. Broadhurst and S.&nbsp;C. Generalis.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0370-2693(84)91139-0">Can mass singularities be minimally subtracted?</a>. <em>Physics Letters B</em> <strong>142</strong> no. 1-2, pages 75-79, 1984.</dd>
        <dt id="Broadhurst:85">[Broadhurst:85] D.&nbsp;J. Broadhurst and S.&nbsp;C. Generalis.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0370-2693(85)90715-4">Dimension-8 contributions to light-quark QCD sum rules</a>. <em>Physics Letters B</em> <strong>165</strong> no. 1-3, pages 175-180, 1985.</dd>
        <dt id="Broadhurst:91b">[Broadhurst:91b] D.&nbsp;J. Broadhurst, N.&nbsp;Gray, and K.&nbsp;Schilcher.</dt>
        <dd><a href="http://dx.doi.org/10.1007/BF01412333">Gauge-invariant on-shell Z_2 in QED, QCD and the effective field theory of a static quark</a>. <em>Zeitschrift f&uuml;r Physik C. Particles and Fields</em> <strong>52</strong> no. 1, pages 111-122, March 1991.</dd>
        <dt id="Broadhurst:86">[Broadhurst:86] D.&nbsp;J. Broadhurst and A.&nbsp;G. Grozin.</dt>
        <dd><a href="http://dx.doi.org/10.1007/BF01552503">Exploiting the 1,440-fold symmetry of the master two-loop diagram</a>. <em>Zeitschrift f&uuml;r Physik C. Particles and Fields</em> <strong>32</strong> no. 2, pages 249-253, June 1986.</dd>
        <dt id="Broadhurst:91a">[Broadhurst:91a] D.&nbsp;J. Broadhurst and A.&nbsp;G. Grozin.</dt>
        <dd>Operator product expansion in static-quark effective theory: large perturbative corrections. Technical Report OUT-4102-31, Open University, Milton Keynes MK7 6AA, England, 1991.</dd>
        <dt id="Broadhurst:91">[Broadhurst:91] D.&nbsp;J. Broadhurst and A.&nbsp;G. Grozin.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0370-2693(91)90532-U">Two-loop renormalization of the effective field theory of a static quark</a>. <em>Physics Letters B</em> <strong>267</strong> no. 1, pages 105-110, 1991.</dd>
        <dt id="Broadhurst:92">[Broadhurst:92] D.&nbsp;J. Broadhurst and A.&nbsp;G. Grozin.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0370-2693(92)92009-6">Operator product expansion in static-quark effective field theory: Large perturbative correction</a>. <em>Physics Letters B</em> <strong>274</strong> no. 3-4, pages 421-427, 1992.</dd>
        <dt id="Brodsky:69">[Brodsky:69] S.&nbsp;J. Brodsky.</dt>
        <dd>Status of quantum electrodynamics. In: <em>Proc. International Symposium on Electron and Photon Interactions at High Energies, Liverpool, England</em>, 1969.</dd>
        <dt id="Brodsky:70">[Brodsky:70] S.&nbsp;J. Brodsky.</dt>
        <dd>Quantum electrodynamic theory: Its relation to precision low energy experiments. Report SLAC-PUB-795, SLAC, August 1970.</dd>
        <dt id="Brodsky:71">[Brodsky:71] S.&nbsp;J. Brodsky.</dt>
        <dd>Algebraic computation techniques in quantum electrodynamics. In: <em>Proc. 2nd Computing Methods in Theoretical Physics, Marseilles</em>, volume&nbsp;II, pages IV-1 to IV-27, 1971.</dd>
        <dt id="Brodsky:72">[Brodsky:72] S.&nbsp;J. Brodsky.</dt>
        <dd>Atomic physics and quantum electrodynamics in the infinite momentum frame. Report SLAC-PUB-1118, SLAC, August 1972.</dd>
        <dt id="Brodsky:72a">[Brodsky:72a] S.&nbsp;J. Brodsky, J.&nbsp;F. Gunion, and R.&nbsp;L. Jaffe.</dt>
        <dd><a href="http://link.aps.org/doi/10.1103/PhysRevD.6.2487">Test for fractionally charged partons from deep-inelastic bremsstrahlung in the scaling region</a>. <em>Physical Review D (Particles and Fields)</em> <strong>6</strong> no. 9, pages 2487-2494, 1972.</dd>
        <dt id="Brodsky:62">[Brodsky:62] S.&nbsp;J. Brodsky, A.&nbsp;C. Hearn, and R.&nbsp;G. Parsons.</dt>
        <dd><a href="http://link.aps.org/doi/10.1103/PhysRev.187.1899">Determination of the real part of the Compton amplitude at a nucleon resonance</a>. <em>Phys. Rev.</em> <strong>187</strong> no. 5, pages 1899-1904, 1962.</dd>
        <dt id="Brodsky:72b">[Brodsky:72b] S.&nbsp;J. Brodsky and R.&nbsp;Roskies.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0370-2693(72)90688-0">Quantum electrodynamics and renormalization theory in the infinite momentum frame</a>. <em>Physics Letters B</em> <strong>41</strong> no. 4, pages 517-520, 1972.</dd>
        <dt id="Brodsky:73">[Brodsky:73] S.&nbsp;J. Brodsky, R.&nbsp;Roskies, and R.&nbsp;Suaya.</dt>
        <dd><a href="http://link.aps.org/doi/10.1103/PhysRevD.8.4574">Quantum electrodynamics and renormalization theory in the infinite-momentum frame</a>. <em>Physical Review D (Particles and Fields)</em> <strong>8</strong> no. 12, pages 4574-4594, 1973.</dd>
        <dt id="Brodsky1967">[Brodsky1967] S.&nbsp;J. Brodsky and J.&nbsp;D. Sullivan.</dt>
        <dd><a href="http://link.aps.org/doi/10.1103/PhysRev.156.1644">W-boson contribution to the anomalous magnetic moment of the muon</a>. <em>Phys. Rev.</em> <strong>156</strong> no. 5, pages 1644-1647, 1967.</dd>
        <dt id="Bronstein:97">[Bronstein:97] Manuel Bronstein.</dt>
        <dd><a href="http://www.springer.com/math/algebra/book/978-3-540-21493-9"><em>Symbolic Integration I: Transcendental Functions</em></a>. Springer-Verlag, Heidelberg, 1997.</dd>
        <dt id="Broughan:82">[Broughan:82] K.&nbsp;A. Broughan.</dt>
        <dd>Grad-Fokker-Planck plasma equations. Part 1. Collision moments. <em>J. Plasma Phys.</em> <strong>27</strong>, pages 437-452, 1982.</dd>
        <dt id="Broughan:91">[Broughan:91] K.&nbsp;A. Broughan, G.&nbsp;Keady, T.&nbsp;D. Robb, M.&nbsp;G. Richardson, and M.&nbsp;C. Dewar.</dt>
        <dd><a href="http://doi.acm.org/10.1145/122514.122518">Some symbolic computing links to the NAG numeric library</a>. <em>SIGSAM Bulletin</em> <strong>25</strong> no. 3, pages 28-37, July 1991.</dd>
        <dt id="Brown:79">[Brown:79] W.&nbsp;S. Brown and A.&nbsp;C. Hearn.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0010-4655(79)90082-1">Applications of symbolic algebraic computation</a>. <em>Computer Physics Communications</em> <strong>17</strong> no. 1-2, pages 207-215, 1979.</dd>
        <dt id="Brunelli:03">[Brunelli:03] J.C. Brunelli, A.&nbsp;Das, and Z.&nbsp;Popowicz.</dt>
        <dd><a href="http://arxiv.org/pdf/nlin.SI/0304047">Supersymmetric extensions of harry - dym hierarchy</a>. <em>Journal of Mathematical Physics</em> <strong>44</strong>, pages 4756 - 4767, 2003.</dd>
        <dt id="Bryan-Jones:87">[Bryan-Jones:87] Jane Bryan-Jones.</dt>
        <dd>A tutorial in computer algebra for statisticians. <em>The Professional Statistician</em> <strong>6</strong> no. 6, page TBD, December 1987.</dd>
        <dt id="Burnel">[Burnel] A.&nbsp;Burnel and H.&nbsp;Caprasse.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0370-2693(91)90065-X">Locality in class iii noncovariant gauges</a>. <em>Physics Letters B</em> <strong>265</strong> no. 3-4, pages 355-360, 1991.</dd>
        <dt id="Burnel:94a">[Burnel:94a] A.&nbsp;Burnel and H.&nbsp;Caprasse.</dt>
        <dd><a href="http://dx.doi.org/10.1142/S0129183194001136">Computing the BRST operator used in quantization of gauge theories</a>. <em>International Journal of Modern Physics C</em> <strong>5</strong> no. 6, pages 1035-1047, December 1994.</dd>
        <dt id="Burnel:94">[Burnel:94] A.&nbsp;Burnel, H.&nbsp;Caprasse, and A.&nbsp;Dresse.</dt>
        <dd>Computing the BRST operator. Technical report, D&eacute;partement d&apos;Astronomie et d&apos;Astrophysique, Universit&eacute; de Li&egrave;ge, 1994.</dd>
    </dl>

    <dl id='C'>
        <dt id="Calmet:83">[Calmet:83] J.&nbsp;Calmet and J.&nbsp;A. van Hulzen.</dt>
        <dd>Computer algebra applications. In: B.&nbsp;Buchberger, G.&nbsp;E. Collins, R.&nbsp;Loos, and R.&nbsp;Albrecht, editors, <em>Computer Algebra Symbolic and Algebraic Computation</em>. Springer-Verlag, 2nd edition, 1983.</dd>
        <dt id="Calmet:72">[Calmet:72] Jacques Calmet.</dt>
        <dd>Further evaluation of the sixth order corrections to the anomalous magnetic moment of the electron. Technical report, Department of Physics, University of Utah, 1972.</dd>
        <dt id="Calmet:72a">[Calmet:72a] Jacques Calmet.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0010-4655(72)90008-2">A REDUCE approach to the calculation of Feynman diagrams</a>. <em>Computer Physics Communications</em> <strong>4</strong> no. 2, pages 199-204, 1972.</dd>
        <dt id="Calmet:74">[Calmet:74] Jacques Calmet.</dt>
        <dd><a href="http://doi.acm.org/10.1145/1086837.1086849">Computer recognition of divergences in Feynman graphs</a>. <em>SIGSAM Bulletin</em> <strong>8</strong> no. 3, pages 74-75, August 1974.</dd>
        <dt id="Campbell:67">[Campbell:67] J.&nbsp;A. Campbell.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0550-3213(67)90129-0">Algebraic computation of radiative corrections for electron-positron scattering</a>. <em>Nuclear Physics B</em> <strong>1</strong> no. 5, pages 283-300, March 1967.</dd>
        <dt id="Campbell:68">[Campbell:68] J.&nbsp;A. Campbell.</dt>
        <dd>Astrophysical consequences of the existence of charged intermediate vector bosons. <em>Aust. Journ. of Phys.</em> <strong>21</strong>, pages 139-148, 1968.</dd>
        <dt id="Campbell:74">[Campbell:74] J.&nbsp;A. Campbell.</dt>
        <dd>Symbolic computing and its relationship to particle physics. <em>Acta Physica Austriaca</em> <strong>Suppl. XIII</strong>, pages 595-647, 1974.</dd>
        <dt id="Campbell:70a">[Campbell:70a] J.&nbsp;A. Campbell, R.&nbsp;B. Clark, and D.&nbsp;Horn.</dt>
        <dd><a href="http://link.aps.org/doi/10.1103/PhysRevD.2.217">Low-t theorems for charged-pion photoproduction</a>. <em>Physical Review D (Particles and Fields)</em> <strong>2</strong> no. 1, pages 217-224, 1970.</dd>
        <dt id="Campbell:87">[Campbell:87] J.&nbsp;A. Campbell, P.&nbsp;O. Fr&ouml;man, and E.&nbsp;Walles.</dt>
        <dd>Explicit series formulae for the evaluation of integrals by the method of steepest descents. <em>Studies in Applied Mathematics</em> <strong>77</strong>, pages 151-172, 1987.</dd>
        <dt id="Campbell:70">[Campbell:70] J.&nbsp;A. Campbell and A.&nbsp;C. Hearn.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0021-9991(70)90064-1">Symbolic analysis of Feynman diagrams by computer</a>. <em>Journal of Computational Physics</em> <strong>5</strong> no. 2, pages 280-327, April 1970.</dd>
        <dt>[Cao:2013] Meng Cao and A.&nbsp;J. Roberts.</dt>
        <dd>Multiscale modelling couples patches of wave-like simulations. In Scott McCue, Tim Moroney, Dann Mallet, and Judith Bunder, editors, <em>Proceedings of the 16th Biennial Computational Techniques and Applications Conference, CTAC-2012</em>, volume 54 of <em>ANZIAM J.</em>, pages C153&ndash;C170, May 2013.</dd>
        <dt>[Cao:2016a] Meng Cao and A.&nbsp;J. Roberts.</dt>
        <dd>Modelling suspended sediment in environmental turbulent fluids. <em>J. Engrg. Maths</em>, 98(1):187&ndash;204, 2016.</dd>
        <dt>[Cao:2016b] Meng Cao and A.&nbsp;J. Roberts.</dt>
        <dd>Multiscale modelling couples patches of nonlinear wave-like simulations. <em>IMA J. Applied Maths.</em>, 81(2):228&ndash;254, 2016.</dd>
        <dt id="Caprasse:84">[Caprasse:84] H.&nbsp;Caprasse.</dt>
        <dd>Description et utilisation d&apos;une extension du programme REDUCE. Technical report, Physique Th&eacute;orique et Math&eacute;matique, Universit&eacute; de Li&egrave;ge, October 1984.</dd>
        <dt id="Caprasse:86a">[Caprasse:86a] H.&nbsp;Caprasse.</dt>
        <dd><a href="http://doi.acm.org/10.1145/12917.12920">A complete simplification package for the absolute value function in REDUCE</a>. <em>SIGSAM Bulletin</em> <strong>20</strong> no. 1 and 2, pages 18-21, February and May 1986.</dd>
        <dt id="Caprasse:86">[Caprasse:86] H.&nbsp;Caprasse.</dt>
        <dd><a href="http://doi.acm.org/10.1145/14956.14957">Description of an extension of the matrix package of REDUCE</a>. <em>SIGSAM Bulletin</em> <strong>20</strong> no. 4, pages 7-10, December 1986.</dd>
        <dt id="Caprasse:89a">[Caprasse:89a] H.&nbsp;Caprasse.</dt>
        <dd>Les th&eacute;ories des Champs dans le monde de REDUCE (in French). <em>CALSYF (to appear)</em> , 1989.</dd>
        <dt id="Caprasse:90">[Caprasse:90] H.&nbsp;Caprasse.</dt>
        <dd><a href="http://dx.doi.org/10.1016/S0747-7171(08)80007-7">Renormalization group, function iterations and computer algebra</a>. <em>Journal of Symbolic Computation</em> <strong>9</strong> no. 1, pages 61-72, January 1990.</dd>
        <dt id="Caprasse:91">[Caprasse:91] H.&nbsp;Caprasse, J.&nbsp;Demaret, K.&nbsp;Gatermann, and H.&nbsp;Melenk.</dt>
        <dd><a href="http://dx.doi.org/10.1142/S0129183191000901">Power-law type solutions of fourth-order gravity for multidimensional Bianchi I universes</a>. <em>International Journal of Modern Physics C</em> <strong>2</strong> no. 2, pages 601-611, June 1991.</dd>
        <dt id="Caprasse:88">[Caprasse:88] H.&nbsp;Caprasse, J.&nbsp;Demaret, and E.&nbsp;Schruefer.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-51084-2_11">Can EXCALC be used to investigate High-dimensional cosmological models with Non-Linear Lagrangians?</a>. In: <em>Proc. of ISSAC &apos;88</em>, pages 116-124. Springer-Verlag, 1988.</dd>
        <dt id="Caprasse:85">[Caprasse:85] H.&nbsp;Caprasse and M.&nbsp;Hans.</dt>
        <dd><a href="http://doi.acm.org/10.1145/1089411.1089417">A new use of operators in the algebraic mode of REDUCE</a>. <em>SIGSAM Bulletin</em> <strong>19</strong> no. 3, pages 46-52, August 1985.</dd>
        <dt id="Carlson:80">[Carlson:80] P.&nbsp;Carlson.</dt>
        <dd><a href="http://link.aip.org/link/?JMAPAQ/21/1149/1">Coordinate free relativity</a>. <em>Journal of Mathematical Physics</em> <strong>21</strong>, pages 1149-1154, 1980.</dd>
        <dt id="Carroll:73">[Carroll:73] R.&nbsp;Carroll.</dt>
        <dd><em>The Anomalous Magnetic Moment of the Electron in the Mass Operator Formalism</em>. PhD thesis, University of Michigan, 1973.</dd>
        <dt id="Carroll:75">[Carroll:75] R.&nbsp;Carroll.</dt>
        <dd><a href="http://link.aps.org/doi/10.1103/PhysRevD.8.2349">Mass-operator calculation of the electron g-factor</a>. <em>Physical Review D (Particles and Fields)</em> <strong>12</strong> no. 8, pages 2344-2354, 1975.</dd>
        <dt id="Celik:04a">[Celik:04a] Ercan &Ccedil;elik and Mustafa Bayram.</dt>
        <dd><a href="http://dx.doi.org/10.1016/S0096-3003(03)00612-X">Application of Gr&ouml;bner basis techniques to enzyme kinetics</a>. <em>Applied Mathematics and Computation</em> <strong>153</strong> no. 1, pages 97-109, May 2004.</dd>
        <dt id="Cejchan">[Cejchan] A.&nbsp;Cejchan and J.&nbsp;Nadrchal.</dt>
        <dd>Application of REDUCE-2 and analytic integration program in the theoretical solid state physics. Technical report, Institute of Physics, CSAV, Prague, 1981.</dd>
        <dt id="Chaffy:88">[Chaffy:88] C.&nbsp;Chaffy-Camus.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-51084-2_7">An application of REDUCE to the approximation of f(x,y)</a>. In: <em>Proc. of ISSAC &apos;88</em>, volume 358, pages 73-84. Springer-Verlag, 1988.</dd>
        <dt id="Chao:95">[Chao:95] Xu&nbsp;Chao and A.J. Roberts.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0378-4371(95)00387-8">On the low-dimensional modelling of Stratonovich stochastic differential equations</a>. <em>Physica A</em> <strong>225</strong> no. 1, pages 62-80, 1996.</dd>
        <dt id="Chinnick:86">[Chinnick:86] K.&nbsp;Chinnick, C.&nbsp;Gibson, J.&nbsp;F. Griffiths, and W.&nbsp;Kordylewski.</dt>
        <dd>Isothermal interpretations of oscillatory ignition during hydrogen oxidation in an open system. I. Analytical predictions and experimental measurements of periodicity. <em>Proc. Roy. Soc. Lond.</em> <strong>A405</strong>, pages 117-128, 1986.</dd>
        <dt id="Chou:90">[Chou:90] S.-C. Chou.</dt>
        <dd><a href="http://doi.acm.org/10.1145/96877.96942">Automated reasoning in geometries using the characteristic set method and Gr&ouml;bner basis method</a>. In: <em>ISSAC &apos;90: Proceedings of the international symposium on Symbolic and algebraic computation</em>, pages 255-260, New York, NY, USA. ACM.</dd>
        <dt id="Chou:84">[Chou:84] S.-C. Chou.</dt>
        <dd>Proving elementary geometry theorems using Wu&apos;s algorithm. In: <em>Contemp. Math.</em>, volume&nbsp;19, pages 243 - 286. AMS, Providence, Rhode Island, 1984.</dd>
        <dt id="Chou:88">[Chou:88] S.-C. Chou.</dt>
        <dd><em>Mechanical geometry theorem proving</em>. Reidel, Dortrecht, 1988.</dd>
        <dt id="Cline:90">[Cline:90] Terry Cline, Harold Abelson, and Warren Harris.</dt>
        <dd>Symbolic computing in engineering design. <em>AI EDAM</em> , February 1990.</dd>
        <dt id="Cohen:84">[Cohen:84] H.&nbsp;I. Cohen, I.&nbsp;B. Frick, and J.&nbsp;E.man.</dt>
        <dd>Algebraic computing in general relativity. <em>General Relativity and Gravitation, ed.</em> pages 139-162, 1984.</dd>
        <dt id="Cohen:76">[Cohen:76] H.&nbsp;I. Cohen, O.&nbsp;Leringe, and Y.&nbsp;Sundblad.</dt>
        <dd>The use of algebraic computing in general relativity. Technical Report TRITA-MEK-76-02, The Royal Institute of Technology Department of Mechanics, 1976.</dd>
        <dt id="Cohen:76a">[Cohen:76a] I.&nbsp;Cohen and F.&nbsp;Bark.</dt>
        <dd>Perturbation calculations for the spin up problem using REDUCE. Technical Report TRITA-MEK-76-03, The Royal Institute of Technology, Department of Mechanics, 1976.</dd>
        <dt id="Cohen:77">[Cohen:77] I.&nbsp;Cohen and S.&nbsp;Yu. Slavyanov.</dt>
        <dd>Smooth perturbations of the Schr&ouml;dinger equation with a linear potential related to the charmonium models. USIP Report 77-17, University of Stockholm Institute of Physics, 1977.</dd>
        <dt id="Cohen:89">[Cohen:89] Joel&nbsp;S. Cohen.</dt>
        <dd>The effective use of computer algebra systems. In: <em>Transactions of the Sixth Army Conference on Applied Mathematics and Computing</em>, pages 677-698, 1989.</dd>
        <dt id="Connor:84a">[Connor:84a] J.&nbsp;N.&nbsp;L. Connor, P.&nbsp;R. Curtis, C.&nbsp;J. Edge, and A.&nbsp;Lagan&agrave;.</dt>
        <dd><a href="http://link.aip.org/link/?JCPSA6/80/1362/1">The uniform asymptotic swallowtail approximation: Application to the collinear h+f<sub>2</sub>
            chemical reactions</a>. <em>Journal of Chemical Physics</em> <strong>80</strong> no. 3, pages 1362-1363, February 1984.</dd>
        <dt id="Connor:84">[Connor:84] J.&nbsp;N.&nbsp;L. Connor, P.&nbsp;R. Curtis, and D.&nbsp;Farrelly.</dt>
        <dd><a href="http://dx.doi.org/10.1088/0305-4470/17/2/016">The uniform asymptotic swallowtail approximation: Practical methods for oscillating integrals with four coalescing saddle points</a>. <em>J. Phys. A: Math. Gen.</em> <strong>17</strong> no. 2, pages 283-310, 1984.</dd>
        <dt id="Conwell:84">[Conwell:84] P.&nbsp;R. Conwell, P.&nbsp;W. Barber, and C.&nbsp;K. Rushworth.</dt>
        <dd><a href="http://dx.doi.org/10.1364/JOSAA.1.000062">Resonant spectra of dielectric sphere</a>. <em>J. Opt. Soc. Am. A</em> <strong>1</strong> no. 1, pages 62-67, 1984.</dd>
        <dt id="Cotaescu:97">[Cotaescu:97] I.&nbsp;I. Cotaescu and D.&nbsp;N. Vulcanov.</dt>
        <dd><a href="http://dx.doi.org/10.1142/S0129183197000254">New routines for algebraic programing of the dirac equation</a>. <em>International Journal of Modern Physics C</em> <strong>8</strong> no. 2, pages 273-286, 1997.</dd>
        <dt id="Cowan:79">[Cowan:79] Richard&nbsp;M. Cowan and Martin&nbsp;L. Griss.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-09519-5_79">Hashing - the key to rapid pattern matching</a>. In: <em>Proc. EUROSAM 1979, Lecture Notes in Computer Science</em>, volume&nbsp;72, pages 266-278. Springer-Verlag, 1979.</dd>
        <dt id="Cox:92">[Cox:92] D.&nbsp;Cox, J.&nbsp;Little, and D.&nbsp;O&apos;Shea.</dt>
        <dd><a href="http://dx.doi.org/10.1007/978-0-387-35651-8"><em>Ideals, Varieties and Algorithms: An Introduction of Computational Algebraic Geometry and Commutative Algebra</em></a>. Springer-Verlag, 1992.</dd>
        <dt id="Cox:91">[Cox:91] S.M. Cox and A.J. Roberts.</dt>
        <dd><a href="http://anziamj.austms.org.au/V32/part4/Cox.html">Centre manifolds of forced dynamical systems</a>. <em>J. Austral. Math. Soc. B</em> <strong>32</strong>, pages 401-436, 1991.</dd>
        <dt id="Cox:92a">[Cox:92a] S.M. Cox and A.J. Roberts.</dt>
        <dd>The quasi-geostrophic slow manifold. In: <em>Proc 11th Aust. Fluid Mech Conf</em>, 1992.</dd>
        <dt id="Coxeter:67">[Coxeter:67] H.S.M. Coxeter and S.L. Greitzer.</dt>
        <dd><em>Geometry revisted</em>. Random House, The L.W. Singer Comp., New York, 1967.</dd>
        <dt id="Cung:75">[Cung:75] V.&nbsp;K. Cung.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0370-2693(75)90189-6">Differential cross section of e<sup>+</sup> + e<sup>-</sup> to e<sup>+</sup> + &mu;<sup>-</sup> + <span style="text-decoration: overline;">&nu;</span><sub>&mu;</sub> + <span style="text-decoration: overline;">&nu;</span><sub>e</sub></a>. <em>Physics Letters B</em> <strong>55</strong> no. 1, pages 67-70, 1975.</dd>
    </dl>

    <dl id='D'>
        <dt id="DAngio:94">[DAngio:94] L.&nbsp;D&apos;Angi&ograve;, S.&nbsp;Audoly, G.&nbsp;Bellu, M.P. Saccomani, and C.&nbsp;Cobelli.</dt>
        <dd>Structural identifiability of nonlinear systems: algorithms based on differential ideals. In: M.&nbsp;Blanke and T.&nbsp;Soderstrom, editors, <em>Proc. SYSID &apos;94, 10th IFAC Symposium on System Identification</em>, volume&nbsp;3, pages 13-18, Copenhagen, Denmark, 1994. Danish Automation Society 1994.</dd>
        <dt id="Darbaidze:86a">[Darbaidze:86a] J.&nbsp;Z. Darbaidze, V.&nbsp;A. Matveev, Z.&nbsp;V. Merebashvili, and L.&nbsp;A. Slepchenko.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0370-2693(86)91053-1">Gluon bremsstrahlung in supersymmetric QCD</a>. <em>Physics Letters B</em> <strong>177</strong> no. 2, pages 188-190, 1986.</dd>
        <dt id="Darbaidze:86">[Darbaidze:86] Ya.&nbsp;Z. Darbaidze.</dt>
        <dd>A gluon bremsstrahlung in supersymmetry QCD. Preprint P2-86-825, JINR, 1986.</dd>
        <dt id="Darbaidze:88">[Darbaidze:88] Ya.&nbsp;Z. Darbaidze, Z.V. Merebashvili, and V.A. Rostovtsev.</dt>
        <dd>Some computer realizations of the REDUCE-3 calculations for exclusive processes. Preprint P2-88-769, JINR, 1988.</dd>
        <dt id="Darbaidze:89">[Darbaidze:89] Ya.&nbsp;Z. Darbaidze and V.A. Rostovtsev.</dt>
        <dd>Analysis of the differential equations for the exclusive processes and explanation for the &ldquo;Mystery&rdquo; of the Gamma-Distribution. Preprint E2-89-286, JINR, 1989.</dd>
        <dt id="Das:01">[Das:01] A.&nbsp;Das and Z.&nbsp;Popowicz.</dt>
        <dd><a href="http://dx.doi.org/10.1088/0305-4470/34/31/305">Supersymmetric moyal - lax representation</a>. <em>J. Phys. A: Math. Gen.</em> <strong>34</strong>
            no. 31, page 6105, 2001.</dd>
        <dt id="Das:01a">[Das:01a] A.&nbsp;Das and Z.&nbsp;Popowicz.</dt>
        <dd><a href="http://dx.doi.org/10.1016/S0375-9601(02)00145-7">Supersymmetric polyropic gas dynamics</a>. <em>Physics Letters A</em> <strong>296</strong>
            no. 1, pages 15-26, 2002.</dd>
        <dt id="Das:00">[Das:00] Ashok Das and Ziemowit Popowicz.</dt>
        <dd><a href="http://dx.doi.org/10.1016/S0375-9601(00)00392-3">Dispersionless stb</a>. <em>Physics Letters A</em> <strong>272</strong> no. 1-2, pages 65-73, 2000.</dd>
        <dt id="Das:00a">[Das:00a] Ashok Das and Ziemowit Popowicz.</dt>
        <dd><a href="http://dx.doi.org/10.1016/S0375-9601(00)00523-5">New nonlocal charges in susy integrable models</a>. <em>Physics Letters A</em> <strong>274</strong>
            no. 1-2, pages 30-36, 2000.</dd>
        <dt id="Dautcourt:79">[Dautcourt:79] G.&nbsp;Dautcourt.</dt>
        <dd>Application of REDUCE to algebraic computations in general relativity and astrophysics. In: <em>Proc. of the Workshop in Symbolic Computation, Dubna, U.S.S.R.</em>, September 1979.</dd>
        <dt id="Dautcourt:83">[Dautcourt:83] G.&nbsp;Dautcourt.</dt>
        <dd><a href="http://dx.doi.org/10.1088/0305-4470/16/15/016">The cosmological problem as an initial value problem on the observer&apos;s past light cone: Geometry</a>. <em>J. Phys. A: Math. Gen.</em> <strong>16</strong> no. 15, pages 3507-3528, 1983.</dd>
        <dt id="Dautcourt:80">[Dautcourt:80] G.&nbsp;Dautcourt and K.&nbsp;P. Jann.</dt>
        <dd>A program package in REDUCE 2 for algebraic computations in general relativity. Technical report, Zentralinstitut fuer Astrophysik der Akademie der Wissenschaften, 1980.</dd>
        <dt id="Dautcourt:81">[Dautcourt:81] G.&nbsp;Dautcourt, K.&nbsp;P. Jann, E.&nbsp;Riemer, and M.&nbsp;Riemer.</dt>
        <dd><a href="http://dx.doi.org/10.1002/asna.2103020102">User&apos;s guide to REDUCE subroutines for algebraic computations in general relativity</a>. <em>Astron. Nachr.</em> <strong>302</strong> no. 1, pages 1-13, 1981.</dd>
        <dt id="Davenport:88">[Davenport:88] J.&nbsp;H. Davenport.</dt>
        <dd>The world of computer algebra. <em>New Scientist</em> <strong>1629</strong>, pages 71-72, September 1988.</dd>
        <dt id="Davenport:88c">[Davenport:88c] J.&nbsp;H. Davenport, Y.&nbsp;Siret, and E.&nbsp;Tournier.</dt>
        <dd><em>Kompyuter Algebra (in Russian)</em>. MIR, 1st edition, 1991.</dd>
        <dt id="Davenport:88b">[Davenport:88b] J.&nbsp;H. Davenport, Y.&nbsp;Siret, and E.&nbsp;Tournier.</dt>
        <dd><em>Calcul Formel (in French)</em>. Masson, 2nd edition, 1993.</dd>
        <dt id="Davenport:88a">[Davenport:88a] J.&nbsp;H. Davenport, Y.&nbsp;Siret, and E.&nbsp;Tournier.</dt>
        <dd><em>Computer Algebra, Systems and Algorithms for Algebraic Computation</em>. Academic Press, 2nd edition, 1993.</dd>
        <dt id="Davenport:85">[Davenport:85] James Davenport and Julian Padget.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-15984-3_231">HEUGCD: how elementary upperbounds generate cheaper data</a>. In: <em>Proc. EUROCAL 1985, Lecture Notes in Computer Science</em>, volume 204, pages 18-28. Springer-Verlag, 1985.</dd>
        <dt id="Davenport:82">[Davenport:82] James&nbsp;H. Davenport.</dt>
        <dd><a href="http://doi.acm.org/10.1145/1089297.1089298">Fast REDUCE: the trade-off between efficiency and generality</a>. <em>SIGSAM Bulletin</em> <strong>16</strong> no. 1, pages 8-11, February 1982.</dd>
        <dt id="Davenport:82a">[Davenport:82a] James&nbsp;H. Davenport.</dt>
        <dd><a href="http://doi.acm.org/10.1145/1089310.1089313">What do we want from a high-level language?</a>. <em>SIGSAM Bulletin</em> <strong>16</strong> no. 4, pages 6-9, November 1982.</dd>
        <dt id="Davenport:81">[Davenport:81] James&nbsp;Harold Davenport.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-10290-6"><em>On the Integration of Algebraic Functions</em></a>, <em>Lecture Notes in Computer Science</em> 102. Springer-Verlag, 1981.</dd>
        <dt id="deRop:88">[deRop:88] Y.&nbsp;de&nbsp;Rop and J.&nbsp;Demaret.</dt>
        <dd><a href="http://dx.doi.org/10.1007/BF00758934">Using EXCALC to study nondiagonal multidimensional spatially homogeneous cosmologies</a>. <em>General Relativity and Gravitation</em> <strong>20</strong> no. 11, pages 1127-1139, November 1988.</dd>
        <dt id="Della-Dora:85">[Della-Dora:85] Jean Della-Dora, Claire Dicrescenzo, and Dominique Duval.</dt>
        <dd>About a new method for computing in algebraic number fields. Technical report, Universit&eacute; de Grenoble, Institut Fourier, France, November 1985.</dd>
        <dt id="Demaret:89">[Demaret:89] J.&nbsp;Demaret, H.&nbsp;Caprasse, A.&nbsp;Moussiaux, Ph. Tombal, and D.&nbsp;Papadopoulos.</dt>
        <dd><a href="http://link.aps.org/doi/10.1103/PhysRevD.41.1163">Ten-dimensional Lovelock-type Space-Times</a>. <em>Physical Review D (Particles and Fields)</em>
            <strong>41</strong> no. 4, pages 1163-1171, 1990.</dd>
        <dt id="Demichev:85">[Demichev:85] A.&nbsp;P. Demichev and A.&nbsp;Ya. Rodionov.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0010-4655(85)90112-2">A REDUCE program for the calculation of geometrical characteristics of compactified multidimensional Riemannian space</a>. <em>Computer Physics Communications</em> <strong>38</strong> no. 3, pages 441-448, 1985.</dd>
        <dt id="Demichev:86">[Demichev:86] A.&nbsp;P. Demichev and A.&nbsp;Ya. Rodionov.</dt>
        <dd>Freund-Rubin type solutions for different compactifications of the eleven-dimensional space. Preprint 86-85, Institute for High Energy Physics, 1986.</dd>
        <dt id="Dewar:89">[Dewar:89] M.&nbsp;C. Dewar.</dt>
        <dd>IRENA - an integrated symbolic and numerical computation environment. In: <em>Proc. of ISSAC &apos;89</em>, pages 171-179. ACM Press, New York, 1989.</dd>
        <dt id="Dhar:85">[Dhar:85] D.&nbsp;Dhar and J-M. Maillard.</dt>
        <dd><a href="http://dx.doi.org/10.1088/0305-4470/18/7/010">Susceptibility of the checkerboard Ising model</a>. <em>J. Phys. A: Math. Gen.</em> <strong>18</strong> no. 7, pages L383-L388, 1985.</dd>
        <dt id="Dicrescenzo:85">[Dicrescenzo:85] Claire Dicrescenzo.</dt>
        <dd>Algebraic computation on algebraic numbers. Technical report, Institut Fourier, Laboratoire de Math&eacute;matiques, France, December 1985.</dd>
        <dt id="Dimas:05">[Dimas:05] Stelios DIMAS and Dimitri TSOUBELIS.</dt>
        <dd><a href="http://www.ucy.ac.cy/~mogran10/Proof/Dimas.pdf">Sym: A new symmetry-finding package for mathematica</a>. In: <em>Proceedings of 10th International Conference in MOdern GRoup ANalysis</em>, pages 64-70, 2005.</dd>
        <dt id="Diver:91">[Diver:91] D.&nbsp;A. Diver.</dt>
        <dd><a href="http://dx.doi.org/10.1016/S0747-7171(08)80049-1">Modelling waves with computer algebra</a>. <em>Journal of Symbolic Computation</em> <strong>11</strong> no. 3, pages 275-289, March 1991.</dd>
        <dt id="Diver">[Diver] D.&nbsp;A. Diver, E.&nbsp;Q. Laing, and C.&nbsp;C. Sellar.</dt>
        <dd>Waves in a cold plasma with a spatially rotating magnetic field. Report GU TPA 88/12-1, Department of Physics and Astronomy, University of Glasgow, Plasma Physics Group, 1988.</dd>
        <dt id="Diver:86">[Diver:86] D.&nbsp;A. Diver and E.&nbsp;W. Laing.</dt>
        <dd>Proc. 8th Europhysics conference on computational physics. In: D.&nbsp;Biskamp, editor, <em>Computing in Plasma Physics</em>, 1986.</dd>
        <dt id="Diver:88">[Diver:88] D.&nbsp;A. Diver and E.&nbsp;W. Laing.</dt>
        <dd>In: <em>Proc. XV European Conference on Controlled Fusion and Plasma Heating</em>, 1988.</dd>
        <dt id="Diver:88a">[Diver:88a] D.&nbsp;A. Diver and E.&nbsp;W. Laing.</dt>
        <dd>Alfven resonance absorption in a magnetofluid. Report GUTPA 88/04-01, Department of Physics and Astronomy, University of Glasgow, Plasma Physics Group, July 1988.</dd>
        <dt id="Dolzmann:95">[Dolzmann:95] Andreas Dolzmann and Thomas Sturm.</dt>
        <dd>Simplification of quantifier-free formulas over ordered fields. Technical Report MIP-9517, Universit&auml;t Passau, Fakult&auml;t F&uuml;r Mathematik und Informatik, October 1995.</dd>
        <dt id="Dolzmann:96">[Dolzmann:96] Andreas Dolzmann and Thomas Sturm.</dt>
        <dd>REDLOG computer algebra meets computer logic. Technical Report MIP-9603, Universit&auml;t Passau, Fakult&auml;t F&uuml;r Mathematik und Informatik, February 1996.</dd>
        <dt id="Dolzmann:96a">[Dolzmann:96a] Andreas Dolzmann and Thomas Sturm.</dt>
        <dd>Redlog user manual. Technical Report MIP-9616, FMI, Universit&auml;t Passau, D-94030 Passau, Germany, October 1996. Edition 1.0 for Version 1.0.</dd>
        <dt id="Dolzmann:97">[Dolzmann:97] Andreas Dolzmann and Thomas Sturm.</dt>
        <dd>Guarded expressions in practice. Technical Report MIP-9702, Universit&auml;t Passau, Fakult&auml;t F&uuml;r Mathematik und Informatik, January 1997.</dd>
        <dt id="Dolzmann:97a">[Dolzmann:97a] Andreas Dolzmann and Thomas Sturm.</dt>
        <dd><a href="http://doi.acm.org/10.1145/261320.261324">Redlog: Computer algebra meets computer logic</a>. <em>ACM SIGSAM Bulletin</em> <strong>31</strong> no. 2, pages 2-9, June 1997.</dd>
        <dt id="Dolzmann:97b">[Dolzmann:97b] Andreas Dolzmann and Thomas Sturm.</dt>
        <dd><a href="http://dx.doi.org/10.1006/jsco.1997.0123">Simplification of quantifier-free formulae over ordered fields</a>. <em>Journal of Symbolic Computation</em> <strong>24</strong> no. 2, pages 209-231, August 1997.</dd>
        <dt id="Dolzmann:99">[Dolzmann:99] Andreas Dolzmann and Thomas Sturm.</dt>
        <dd><em>Redlog User Manual</em>. FMI, Universit&auml;t Passau, D-94030 Passau, Germany, April 1999. Edition 2.0 for Version 2.0.</dd>
        <dt id="Della-Dora:81">[Della-Dora:81] J.&nbsp;Della Dora and E.&nbsp;Tournier.</dt>
        <dd>Solutions formelles d&apos;equations differentielles au voisinage de points singuliers reguliers. Report 239, Centre National de la Recherche Scientifique, 1981.</dd>
        <dt id="Della-Dora:84">[Della-Dora:84] J.&nbsp;Della Dora and E.&nbsp;Tournier.</dt>
        <dd><a href="http://dx.doi.org/10.1007/BFb0032825">Homogeneous linear difference equation (Frobenius-Boole Method)</a>. In: <em>Proc. EUROSAM 1984, Lecture Notes in Computer Science</em>, volume 174, pages 2-12. Springer-Verlag, 1984.</dd>
        <dt id="Dorfi:85">[Dorfi:85] E.&nbsp;A. Dorfi and L.&nbsp;O&apos;C. Drury.</dt>
        <dd>Simple adaptive grids for 1D initial value problems. Technical Report MPI H-1985-V21, Max-Plack-Institut fuer Kernphysik, Heidelberg, West Germany, 1985.</dd>
        <dt id="Dorizzi:86">[Dorizzi:86] B.&nbsp;Dorizzi, B.&nbsp;Grammaticos, J.&nbsp;Hietarinta, A.&nbsp;Ramani, and F.&nbsp;Schwarz.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0375-9601(86)90377-4">New integrable three dimensional quartic potentials</a>. <em>Physics Letters A</em> <strong>116</strong> no. 9, pages 432-436, 1986.</dd>
        <dt id="dosSantos:87a">[dosSantos:87a] R.&nbsp;P. dos Santos.</dt>
        <dd><em>O M&eacute;todo de Supercampos para o C&aacute;lculo de Potencial Efetivo em Modelos com Supercampos Quirais: Os Modelos de Wess e Zumino e de O&apos;Raifeartaigh</em>. PhD thesis, Centro Brasileiro de Pesquisas F&iacute;sicas, 1987.</dd>
        <dt id="dosSantos:90">[dosSantos:90] R.&nbsp;P. dos Santos and W.&nbsp;L. Roque.</dt>
        <dd><a href="http://doi.acm.org/10.1145/101108.101110">On the design of an expert help system for computer algebra systems</a>. <em>SIGSAM Bulletin</em> <strong>24</strong> no. 4, pages 22-25, October 1990.</dd>
        <dt id="dosSantos:85">[dosSantos:85] R.&nbsp;P. dos Santos and P.&nbsp;P. Srivastava.</dt>
        <dd>Two-loop effective potential for Wess-Zumino model using superfields. Technical Report IC/85/205, International Centre for Theoretical Physics, October 1985.</dd>
        <dt id="dosSantos:88a">[dosSantos:88a] Renato&nbsp;P. dos Santos.</dt>
        <dd>Introdu&ccedil;&atilde;o ao sistema REDUCE de c&aacute;lculo alg&eacute;brico. Technical Report CBPF-NT-001/88, CBPF, Rio de Janeiro, Brazil, 1988.</dd>
        <dt id="dosSantos:87">[dosSantos:87] Renato&nbsp;P. dos Santos.</dt>
        <dd><a href="http://dx.doi.org/10.1016/S0747-7171(89)80032-X">Using REDUCE in supersymmetry</a>. <em>Journal of Symbolic Computation</em> <strong>7</strong> no. 5, pages 523-525, 1989.</dd>
        <dt id="Dresse:93">[Dresse:93] A.&nbsp;Dresse.</dt>
        <dd>Treatment of dummy variables and BRST theory in computer algebra. In: G.&nbsp;Jacob, N.&nbsp;E. Oussous, and S.&nbsp;Steinberg, editors, <em>Proceedings of the 1993 International IMACS Symposium on Symbolic Computation</em>, pages 110-119. IMACS, Laboratoire d&apos;Informatique Fondamentale de Lille, France, 1993.</dd>
        <dt id="Drska:91a">[Drska:91a] L.&nbsp;Drska, J.&nbsp;Limpouch, and R.&nbsp;Liska.</dt>
        <dd>Fokker-Planck Simulations of Ultrashort-pulse Laser-plasma Interactions in the Plane and Cylindrical Geometries. In: <em>20-th ECLIM, European Conference on Laser Interaction with Matter, Warsaw</em>, pages 23-26, 1991.</dd>
        <dt id="Drska:91">[Drska:91] L.&nbsp;Drska, J.&nbsp;Limpouch, and R.&nbsp;Liska.</dt>
        <dd>Simulation study of laser-matter interaction in subpicosecond range. In: N.&nbsp;L. Tsintsadze, editor, <em>10-th European Summer School on Plasma Physics, Tbilisi, September 2-15,1990</em>, pages 435-440, Singapore, 1991. World Scientific.</dd>
        <dt id="Drska:92">[Drska:92] L.&nbsp;Drska, J.&nbsp;Limpouch, and R.&nbsp;Liska.</dt>
        <dd>Fokker-Planck Simulations of Ultrashort-pulse Laser-plasma Interactions. <em>Laser and Particle Beams</em> <strong>10</strong>, pages 461-471, 1992.</dd>
        <dt id="Drska:93a">[Drska:93a] L.&nbsp;Drska, J.&nbsp;Limpouch, and R.&nbsp;Liska.</dt>
        <dd>Fokker-Planck simulation of interactions of femtosecond laser pulses with dense plasmas. <em>Acta Polytechnica, Czech Technical University, Prague</em> <strong>33</strong> no. 3, pages 13-21, 1993.</dd>
        <dt id="Drska:93">[Drska:93] L.&nbsp;Drska, J.&nbsp;Limpouch, and R.&nbsp;Liska.</dt>
        <dd>Symbolic computations in simulation code development and femtosecond-pulse laser-plasma interaction studies. In: R.A. de&nbsp;Groot and J.&nbsp;Nadrchal, editors,  <em>Physics Computing &apos;92</em>, pages 318-319, Singapore, 1993. World Scientific. Prague, August 24-28, 1992.</dd>
        <dt id="Drska:90">[Drska:90] Ladislav Drska, Richard Liska, and Milan Sinor.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0010-4655(90)90120-P">Two practical packages for computational physics-GCPM, RLFI</a>. <em>Computer Physics Communications</em> <strong>61</strong> no. 1-2, pages 225-230, November 1990.</dd>
        <dt id="Dubowsky:75">[Dubowsky:75] S.&nbsp;Dubowsky and J.&nbsp;L. Grant.</dt>
        <dd>Application of symbolic manipulation to time domain analysis of nonlinear dynamic systems. <em>Journ. of Dynamic Systems, Measurement, and Control</em> <strong>75-Aut-J</strong>, 1975.</dd>
        <dt id="Dudley:89">[Dudley:89] M.&nbsp;L. Dudley and R.&nbsp;W. James.</dt>
        <dd><a href="http://dx.doi.org/10.1016/S0747-7171(89)80038-0">Computer-aided derivation of spherical harmonic spectral equations in astrogeophyics</a>. <em>Journal of Symbolic Computation</em> <strong>8</strong> no. 4, pages 423-427, October 1989.</dd>
        <dt id="Dufner:69">[Dufner:69] A.&nbsp;M. Dufner and Y.&nbsp;S. Tsai.</dt>
        <dd><a href="http://link.aps.org/doi/10.1103/PhysRev.168.1801">Phenomenological analysis of the &gamma;nn* form factors</a>. <em>Phys. Rev.</em> <strong>168</strong> no. 5, pages 1801-1809, 1969.</dd>
        <dt id="Dulyan:87">[Dulyan:87] L.&nbsp;S. Dulyan.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-51517-8_107">The calculation of QCD triangular Feynman graphs in the external gluonic field using REDUCE-2 system</a>. In: <em>Proc. EUROCAL &apos;87, Lecture Notes in Computer Science</em>, volume 378, pages 172-173. Springer-Verlag, 1987.</dd>
        <dt id="Duncan:86">[Duncan:86] Anthony Duncan and Ralph Roskies.</dt>
        <dd><a href="http://dx.doi.org/10.1006/jsco.1996.0048">Representations of unusual mathematical structures in scientific applications of symbolic computation</a>. <em>Journal of Symbolic Computation</em> <strong>2</strong> no. 2, pages 201-206, June 1986.</dd>
        <dt id="Duval:87">[Duval:87] Dominique Duval.</dt>
        <dd><em>Diverses questions relatives au Calcul Formel Avec des Nombres Alg&eacute;briques</em>. PhD thesis, L&apos;Universit&eacute; Scientifique, Technologique et M&eacute;dicale de Grenoble, 1987.</dd>
        <dt id="Dyer:94">[Dyer:94] Charles&nbsp;C. Dyer.</dt>
        <dd><a href="http://doi.acm.org/10.1145/190347.190414">An application of symbolic computation in the physical sciences</a>. In: <em>Symbolic and Algebraic Computation</em>, ISSAC, pages 181-186. SIGSAM, ACM, 1994.</dd>
    </dl>

    <dl id='E'>
        <dt id="Earles:70">[Earles:70] D.&nbsp;Earles.</dt>
        <dd><a href="http://link.aps.org/doi/10.1103/PhysRevLett.25.129">A measurement of the electron-production of muon pairs</a>. <em>Physical Review Letters</em>
            <strong>25</strong> no. 2, pages 129-133, 1970.</dd>
        <dt id="Eastwood:87">[Eastwood:87] James&nbsp;W. Eastwood.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0010-4655(87)90073-7">Orthovec: A REDUCE program for 3-D vector analysis in orthogonal curvilinear coordinates</a>. <em>Computer Physics Communications</em> <strong>47</strong> no. 1, pages 139-147, October 1987.</dd>
        <dt id="Eastwood:91">[Eastwood:91] James&nbsp;W. Eastwood.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0010-4655(91)90054-O">ORTHOVEC: version 2 of the REDUCE program for 3-D vector analysis in orthogonal curvilinear coordinates</a>. <em>Computer Physics Communications</em> <strong>64</strong> no. 1, pages 121-122, April 1991.</dd>
        <dt id="Eastwood:87a">[Eastwood:87a] James&nbsp;W. Eastwood and Christopher J.&nbsp;H. Watson.</dt>
        <dd>An analytic theory of Wave-Current interactions. Technical Report Plasma Physics Note 87/7, Culham Laboratory, Theory and Optics Division, February 1987.</dd>
        <dt id="Edelen:82">[Edelen:82] D.&nbsp;G.&nbsp;B. Edelen.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0020-7225(82)90002-7">Isovector fields for problems in the mechanics of solids and fluids</a>. <em>Int. Journ. Eng. Sci.</em> <strong>20</strong> no. 7, pages 803-815, 1982.</dd>
        <dt id="Edelen:81">[Edelen:81] Dominic G.&nbsp;B. Edelen.</dt>
        <dd>Programs for calculation of isovector fields in the REDUCE-2 environment. Technical Report TBD, Center for the Application of Mathematics, Lehigh University, August 1981.</dd>
        <dt id="Edneral:89">[Edneral:89] Viktor&nbsp;F. Edneral, Aleksandr&nbsp;P. Kryukov, and Anatolii&nbsp;Ia. Rodionov.</dt>
        <dd><em>The language of the analytic computer program REDUCE</em>. Moscow, Izd-vo, Moskovskogo un-ta, 1989.</dd>
        <dt>Dieter Egger.</dt>
        <dd><em><a href="http://www.shaker.eu/shop/OND-00000-0000140">Hyper-Kugeln und ihre Oberfl&auml;chen.</a></em> (OND-00000-0000140) 69 pages, 41 figures, <a href="http://www.shaker.eu/">Shaker Verlag</a>, July 2012.</dd>
        <dt>Dieter Egger.</dt>
        <dd><em><a href="http://www.shaker.eu/shop/OND-00000-0000142">&Uuml;ber eine Spezielle Metrik</a></em> (OND-00000-0000142) 26 pages, 1 figure, <a href="http://www.shaker.eu/">Shaker Verlag</a>, August 2012.  (See also the bottom of our <a href="/tutorials.php#egger">tutorials page</a>.)
            <dt id="Eisenberger:90">[Eisenberger:90] Moshe Eisenberger.</dt>
            <dd><a href="http://dx.doi.org/10.1016/S0747-7171(08)80030-2">Application of symbolic algebra to the analysis of plates on variable elastic foundation</a>. <em>Journal of Symbolic Computation</em> <strong>9</strong> no. 2, pages 207-213, February 1990.</dd>
            <dt id="Eissfeller:86">[Eissfeller:86] Bernd Ei&szlig;feller and G&uuml;nter&nbsp;W. Hein.</dt>
            <dd>A contribution to 3D-Operational geodesy. Technical Report Heft 17, Universit&auml;rer Studiengang Vermessungswesen and Universit&auml;t der Bundeswehr M&uuml;nchen, December 1986.</dd>
            <dt id="Eitelbach:73">[Eitelbach:73] D.&nbsp;L. Eitelbach.</dt>
            <dd><em>Automatic Analysis of Problems in Elementary Mechanics</em>. PhD thesis, University of Illinois, 1973.</dd>
            <dt id="Eleuterio:82">[Eleuterio:82] S.&nbsp;M. Eleut&eacute;rio and R.&nbsp;V. Mendes.</dt>
            <dd><a href="http://dx.doi.org/10.1016/0021-9991(82)90040-7">Note on equivalence and singularities: An application of computer algebra</a>. <em>Journal of Computational Physics</em> <strong>48</strong> no. 1, pages 150-156, October 1982.</dd>
            <dt id="Eliseev:85">[Eliseev:85] V.&nbsp;P. Eliseev, R.&nbsp;N. Fedorova, and V.&nbsp;V. Kornyak.</dt>
            <dd><a href="http://dx.doi.org/10.1016/0010-4655(85)90027-X">A REDUCE program for determining point and contact Lie symmetries of differential equations</a>. <em>Computer Physics Communications</em> <strong>36</strong> no. 4, pages 383-389, 1985.</dd>
            <dt id="Elishakoff:87a">[Elishakoff:87a] Isaac Elishakoff and Brian Couch.</dt>
            <dd><a href="http://dx.doi.org/10.1016/S0747-7171(87)80015-9">Application of symbolic algebra to the instability of a nonconservative system</a>. <em>Journal of Symbolic Computation</em> <strong>4</strong> no. 3, pages 391-396, December 1987.</dd>
            <dt id="Elishakoff:87">[Elishakoff:87] Isaac Elishakoff and Joseph Hollkamp.</dt>
            <dd><a href="http://dx.doi.org/10.1016/0045-7825(87)90088-0">Computerized symbolic solution for a nonconservative system in which instability occurs by flutter in one range of a parameter and by divergence in another</a>. <em>Comp. Methods in Applied Mechanics and Engineering</em> <strong>62</strong>, pages 27-46, 1987.</dd>
            <dt id="Esteban:90">[Esteban:90] E.P. Esteban and E.&nbsp;Ramos.</dt>
            <dd>Algebraic computing and the Newman-Penrose formalism. <em>Computers in Physics</em> pages 285-290, May/June 1990.</dd>
            <dt id="Euler:02">[Euler:02] Euler, N., Wolf, T., Leach, P.G.L., and Euler, M.</dt>
            <dd><a href="http://dx.doi.org/10.1023/A:1022838932176">Linearizable third order odes and generalised sundman transformations: The case x&apos;&apos;&apos;=0</a>. <em>Acta Applicandae Mathematicae</em> <strong>76</strong> no. 1, pages 89-115, March 2003.</dd>
    </dl>

    <dl id='F'>
        <dt id="Falck:89">[Falck:89] N.&nbsp;K. Falck, D.&nbsp;Graudenz, and G.&nbsp;Kramer.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0010-4655(89)90019-2">Cross section for five-parton production in e<sup>+</sup> e<sup>-</sup> annihilation</a>. <em>Computer Physics Communications</em> <strong>56</strong> no. 2, pages 181-198, December 1989.</dd>
        <dt id="Fazio:84">[Fazio:84] P.&nbsp;M. Fazio and G.&nbsp;E. Copeland.</dt>
        <dd><a href="http://link.aps.org/doi/10.1103/PhysRevLett.53.163">Cooper-type minima in multipole cross sections of atomic hydrogen</a>. <em>Physical Review Letters</em> <strong>53</strong> no. 2, pages 163-165, July 1984.</dd>
        <dt id="Fedorova:87">[Fedorova:87] R.&nbsp;N. Fedorova, V.&nbsp;P. Gerdt, N.&nbsp;N. Govorun, and V.&nbsp;P. Shirikov.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-51517-8_80">Computer algebra in physical research of Joint Institute for Nuclear Research</a>. In: <em>Proc. EUROCAL &apos;87, Lecture Notes in Computer Science</em>, volume 378, pages 1-10. Springer-Verlag, 1987.</dd>
        <dt id="Fedorova:87a">[Fedorova:87a] R.&nbsp;N. Fedorova and V.&nbsp;V. Kornyak.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-51517-8_108">Computer algebra application for determining local symmetries of differential equations</a>. In: <em>Proc. EUROCAL &apos;87, Lecture Notes in Computer Science</em>, volume 378, pages 174-175. Springer-Verlag, 1987.</dd>
        <dt id="Feldmar:86">[Feldmar:86] E.&nbsp;Feldmar and K.&nbsp;S. K&ouml;lbig.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0010-4655(86)90137-2">REDUCE procedures for the manipulation of generalized power series</a>. <em>Computer Physics Communications</em> <strong>39</strong> no. 2, pages 267-284, 1986.</dd>
        <dt id="Feuillebois:84">[Feuillebois:84] F.&nbsp;Feuillebois.</dt>
        <dd><a href="http://dx.doi.org/10.1017/S0022112084000306">Sedimentation in a dispersion with vertical inhomogeneities</a>. <em>J. Fluid Mech.</em> <strong>139</strong>, pages 145-171, 1984.</dd>
        <dt id="Fitch:89a">[Fitch:89a] J.&nbsp;Fitch.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0307-904X(90)90179-9">Compiling for parallelism</a>. <em>Computer Algebra and Parallelism</em> pages 19-31, 1989.</dd>
        <dt id="Fitch:81">[Fitch:81] J.&nbsp;P. Fitch.</dt>
        <dd>User-based integration software. In: <em>Proc. 1981 ACM Symposium on Symbolic and Algebraic Computation</em>, pages 245-248, 1981.</dd>
        <dt id="Fitch:83">[Fitch:83] J.&nbsp;P. Fitch.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-12868-9_97">Implementing REDUCE on a microcomputer</a>. In: <em>Proc. EUROCAL 1983, Lecture Notes in Computer Science</em>, volume 162, pages 128-136. Springer-Verlag, 1983.</dd>
        <dt id="Fitch:85a">[Fitch:85a] J.&nbsp;P. Fitch.</dt>
        <dd>Applying computer algebra. In: <em>International Conference on Computer Algebra and its Application in Theory</em>, pages 262-275, 1985.</dd>
        <dt id="Fitch:85">[Fitch:85] J.&nbsp;P. Fitch.</dt>
        <dd><a href="http://dx.doi.org/10.1016/S0747-7171(85)80015-8">Solving algebraic problems with REDUCE</a>. <em>Journal of Symbolic Computation</em> <strong>1</strong> no. 2, pages 211-227, June 1985.</dd>
        <dt id="Fitch:87">[Fitch:87] J.&nbsp;P. Fitch.</dt>
        <dd>Utilisation du calcul formel. In: P.&nbsp;Chenin, editor, <em>Calcul Formel et Automatique</em>, pages 119-136. Editions du CNRS, 1987.</dd>
        <dt id="Fitch:89">[Fitch:89] J.&nbsp;P. Fitch.</dt>
        <dd><a href="http://doi.acm.org/10.1145/74540.74560">Can REDUCE be run in parallel?</a>. In: <em>Proc. of ISSAC &apos;89</em>, pages 155-162. ACM Press, New York, 1989.</dd>
        <dt id="Fitch:90">[Fitch:90] J.&nbsp;P. Fitch.</dt>
        <dd><a href="http://doi.acm.org/10.1145/96877.96897">A delivery system for REDUCE</a>. In: S.&nbsp;Watanabe and Morio Nagata, editors, <em>Proceedings of the International Symposium on Symbolic and Algebraic Computation</em>, pages 76-81. ACM, Addison-Wesley, 1990.</dd>
        <dt id="Cohen:79">[Cohen:79] J.&nbsp;P. Fitch and H.&nbsp;I. Cohen.</dt>
        <dd><a href="http://dx.doi.org/10.1007/BF00759304">Using CAMAL for algebraic calculations in general relativity</a>. <em>General Relativity and Gravitation</em> <strong>11</strong> no. 6, pages 411-418, December 1979.</dd>
        <dt id="Fitch:87a">[Fitch:87a] J.&nbsp;P. Fitch and R.&nbsp;G. Hall.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-51517-8_94">Symbolic computation and the finite element method</a>. In: <em>Proc. EUROCAL &apos;87, Lecture Notes in Computer Science</em>, volume 378, pages 95-96. Springer-Verlag, 1987.</dd>
        <dt id="Fitch:73">[Fitch:73] John Fitch.</dt>
        <dd><a href="http://doi.acm.org/10.1145/1086814.1086815">Problems #3 and #4 in REDUCE and MACSYMA</a>. <em>SIGSAM Bulletin</em> no. 28, pages 10-11, 1973.</dd>
        <dt id="Fitch:90a">[Fitch:90a] John Fitch.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0010-4655(90)90104-9">The symbolic-numeric interface</a>. <em>Computer Physics Communications</em> <strong>61</strong> no. 1-2, pages 22-33, November 1990.</dd>
        <dt id="Fitch:93">[Fitch:93] John Fitch.</dt>
        <dd>Mathematics goes automatic. <em>Physics world</em> <strong>6</strong> no. 6, pages 48-52, June 1993.</dd>
        <dt id="Flatau:86">[Flatau:86] Piotr&nbsp;J. Flatau, John&nbsp;P. Boyd, and William&nbsp;R. Cotton.</dt>
        <dd>Symbolic algebra in applied mathematics and geophysical fluid dynamics - REDUCE examples. Technical report, Dept. of Atmospheric and Oceanic Science, University of Michigan, and Dept. of Atmospheric Science, Colorado State University, 1986.</dd>
        <dt id="Flath:86">[Flath:86] Dan Flath.</dt>
        <dd>Remarks on tensor operators. Research Report 266, National University of Singapore, Department of Mathematics, July 1986.</dd>
        <dt id="Fleischer:71">[Fleischer:71] J.&nbsp;Fleischer.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0021-9991(73)90172-1">Partial wave analysis of nucleon-nucleon Bethe-Salpeter equation on the computer</a>. <em>Journal of Computational Physics</em> <strong>12</strong> no. 1, pages 112-123, 1973.</dd>
        <dt id="Fleischer:73">[Fleischer:73] J.&nbsp;Fleischer, J.&nbsp;L. Gammel, and M.&nbsp;T. Menzel.</dt>
        <dd><a href="http://link.aps.org/doi/10.1103/PhysRevD.8.1545">Matrix Pad&eacute; approximants for the <sup>1</sup>S<sub>0</sub>- and <sup>3</sup>P<sub>0</sub>- partial waves in nucleon-nucleon scattering</a>. <em>Physical Review D (Particles and Fields)</em> <strong>8</strong>, pages 1545-1552, 1973.</dd>
        <dt id="Fleischer:75">[Fleischer:75] J.&nbsp;Fleischer and J.&nbsp;A. Tjon.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0550-3213(75)90313-2">Bethe-Salpeter equation for J=0 nucleon-nucleon scattering with one-boson exchange</a>. <em>Nuclear Physics B</em> <strong>84</strong> no. 2, pages 375-396, January 1975.</dd>
        <dt id="Fogelholm:82">[Fogelholm:82] Rabbe Fogelholm and Inge&nbsp;B. Frick.</dt>
        <dd><a href="http://doi.acm.org/10.1145/1089310.1089314">Standard LISP for the VAX: a provisional implementation</a>. <em>SIGSAM Bulletin</em> <strong>16</strong> no. 4, pages 10-12, November 1982.</dd>
        <dt id="Foster:89">[Foster:89] Kenneth&nbsp;R. Foster and Haim&nbsp;H. Bau.</dt>
        <dd><a href="http://dx.doi.org/10.1126/science.243.4891.679">Symbolic manipulation programs for the personal computer</a>. <em>Science</em> <strong>243</strong>, pages 679-243, February 1989.</dd>
        <dt id="Fox:71">[Fox:71] J.&nbsp;A. Fox.</dt>
        <dd><a href="http://link.aps.org/doi/10.1103/PhysRevD.3.3228">Recalculation of the crossed graph contribution to the 4th order Lamb shift</a>. <em>Physical Review D (Particles and Fields)</em> <strong>3</strong> no. 12, pages 3228-3230, 1971.</dd>
        <dt id="Fox:74">[Fox:74] John&nbsp;A. Fox and Anthony&nbsp;C. Hearn.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0021-9991(74)90055-2">Analytic computation of some integrals in fourth order quantum electrodynamics</a>. <em>Journal of Computational Physics</em> <strong>14</strong> no. 3, pages 301-317, March 1974.</dd>
        <dt id="Franceschetti:85">[Franceschetti:85] G.&nbsp;Franceschetti and I.&nbsp;Pinto.</dt>
        <dd><a href="http://dx.doi.org/10.1364/JOSAA.2.000997">Nonlinear propagation and scattering: Analytical solution and symbolic code implementation</a>. <em>J. Opt. Soc. Am. A</em> <strong>2</strong> no. 6, pages 997-1006, 1985.</dd>
        <dt id="Freire:89">[Freire:89] E.&nbsp;Freire, E.&nbsp;Gamero, and E.&nbsp;Ponce.</dt>
        <dd>An algorithm for symbolic computation of Hopf bifurcation. In: E.&nbsp;Kaltofen and S.&nbsp;M. Watt, editors, <em>Proceedings of the third conference on Computers and mathematics</em>, pages 109-118. Springer-Verlag, New York, 1989.</dd>
        <dt id="Freire:88">[Freire:88] E.&nbsp;Freire, E.&nbsp;Gamero, E.&nbsp;Ponce, and L.&nbsp;G. Franquelo.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-51084-2_20">An algorithm for symbolic computation of center manifolds</a>. In: <em>Proc. of ISSAC &apos;88</em>, volume 358, pages 218-230. Springer-Verlag, 1988.</dd>
        <dt id="Frick:82">[Frick:82] I.&nbsp;G. Frick and R.&nbsp;Fogelholm.</dt>
        <dd>An implementation of Standard Lisp built on top of Franz Lisp. Report, University of Stockholm, Institute of Physics, April 1982.</dd>
        <dt id="Fritzsche:06">[Fritzsche:06] S.&nbsp;Fritzsche.</dt>
        <dd><a href="http://dx.doi.org/10.1002/qua.20773">Application of point-group symmetries in chemistry and physics: A computer-algebraic approach</a>. <em>International Journal of Quantum Chemistry</em> <strong>106</strong> no. 1, pages 98-129, 2006.</dd>
        <dt id="Fujimoto:06">[Fujimoto:06] J.&nbsp;Fujimoto, T.&nbsp;Ishikawaa, K.&nbsp;Katob, T.&nbsp;Kanekoa, N.&nbsp;Nakazawa, Y.&nbsp;Shimizuc, J.&nbsp;Vermaserend, and Y.&nbsp;Yasuie.</dt>
        <dd><a href="http://dx.doi.org/10.1016/j.nuclphysbps.2006.09.039">Grace with form</a>. <em>Nuclear Physics B - Proceedings Supplements</em> <strong>160</strong>, pages 150-154, 2006. Proceedings of the 8th DESY Workshop on Elementary Particle Theory, Proceedings of the 8th DESY Workshop on Elementary Particle Theory.</dd>
        <dt id="Fujimoto:84">[Fujimoto:84] Y.&nbsp;Fujimoto and T.&nbsp;Garavaglia.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0370-2693(84)91642-3">Phase diagrams in Scalar QED</a>. <em>Physics Letters B</em> <strong>148</strong> no. 1-3, pages 220-224, November 1984.</dd>
        <dt id="Fuzio:85">[Fuzio:85] P.&nbsp;M. Fuzio and G.&nbsp;E. Copeland.</dt>
        <dd><a href="http://link.aps.org/doi/10.1103/PhysRevA.31.187">Partial radiative-recombination cross sections for excited states of hydrogen</a>. <em>Phys. Rev. A</em> <strong>31</strong> no. 1, pages 187-195, 1985.</dd>
    </dl>

    <dl id='G'>
        <dt id="Gaemers">[Gaemers] K.&nbsp;J.&nbsp;F. Gaemers, R.&nbsp;Gastmans, and F.&nbsp;M. Renard.</dt>
        <dd><a href="http://dx.doi.org/10.1103/PhysRevD.19.1605">Neutrino counting in e<sup>+</sup> e<sup>-</sup> collisions</a>. <em>Physical Review D (Particles and Fields)</em> <strong>19</strong> no. 5, pages 1605-1606, 1979.</dd>
        <dt id="Gaemers:78">[Gaemers:78] K.&nbsp;J.&nbsp;F. Gaemers and G.&nbsp;J. Gounaris.</dt>
        <dd><a href="http://dx.doi.org/10.1007/BF01440226">Polarization amplitudes for e<sup>+</sup>e<sup>-</sup> &rarr; W<sup>+</sup>W<sup>-</sup> &rarr; ZZ</a>. <em>Zeitschrift f&uuml;r Physik C Particles and Fields</em> <strong>1</strong> no. 3, pages 259-268, September 1979.</dd>
        <dt id="Ganzha:89">[Ganzha:89] V.&nbsp;Ganzha and R.&nbsp;Liska.</dt>
        <dd>Application of the REDUCE computer algebra system to stability analysis of difference schemes. In: E.&nbsp;Kaltofen and S.&nbsp;M. Watt, editors, <em>Proc. Computers and Mathematics &apos;89</em>, pages 119-129. Springer-Verlag, New York, 1989.</dd>
        <dt id="Ganzha:90a">[Ganzha:90a] V.&nbsp;G. Ganzha, S.&nbsp;V. Meleshko, and V.&nbsp;P. Shelest.</dt>
        <dd><a href="http://doi.acm.org/10.1145/96877.96970">Application of REDUCE system for analyzing consistency of systems of P.D.E.&apos;s</a>. In: S.&nbsp;Watanabe and Morio Nagata, editors, <em>Proceedings of the International Symposium on Symbolic and Algebraic Computation</em>, page 301. ACM, Addison-Wesley, 1990.</dd>
        <dt id="Ganzha:94">[Ganzha:94] V.&nbsp;G. Ganzha, E.&nbsp;V. Vorozhtsov, J.&nbsp;Boers, and J.&nbsp;A. van Hulzen.</dt>
        <dd><a href="http://doi.acm.org/10.1145/190347.190422">Symbolic-numeric stability investigations of Jameson&apos;s schemes for thin-layer Navier-Stokes equations</a>. In: <em>Symbolic and Algebraic Computation</em>, ISSAC, pages 234-241. SIGSAM, ACM, 1994.</dd>
        <dt id="Ganzha:93">[Ganzha:93] V.&nbsp;G. Ganzha, E.&nbsp;V. Vorozhtsov, and R.&nbsp;Liska.</dt>
        <dd>Stability Analysis of Difference Initial-value Problems with the Aid of REDUCE System. In: V.G. Ganzha, V.M. Rudenko, and E.V. Vorozhtsov, editors, <em>Computer Algebra and Its Applications to Mechanics</em>, pages 31-41, New York, 1993. Nova Science Publishers. CAAM-90, Novosibirsk, Irkutsk, August 28 - September 3, 1990.</dd>
        <dt id="Ganzha:91">[Ganzha:91] V.G. Ganzha, B.&nbsp;Yu. Scobelev, and E.V. Vorozhtsov.</dt>
        <dd><a href="http://doi.acm.org/10.1145/120694.120760">Stability analysis of difference schemes by the catastrophe theory methods and by means of computer algebra</a>. In: Stephen&nbsp;M. Watt, editor, <em>Proc. of the 1991 International Symposium on Symbolic and Algebraic Computation</em>, pages 427-428, Maryland, 1991. ACM Press.</dd>
        <dt id="Ganzha:90">[Ganzha:90] Victor&nbsp;G. Ganzha and Michail&nbsp;Yu. Shaskov.</dt>
        <dd><a href="http://doi.acm.org/10.1145/96877.96923">Local approximation study of difference operators by means of REDUCE system</a>. In: S.&nbsp;Watanabe and Morio Nagata, editors, <em>Proceedings of the International Symposium on Symbolic and Algebraic Computation</em>, pages 185-192. ACM, Addison-Wesley, 1990.</dd>
        <dt id="Ganzha:99">[Ganzha:99] Victor&nbsp;G. Ganzha and Evgenii&nbsp;V. Vorozhtsov.</dt>
        <dd><a href="http://dx.doi.org/10.1006/jsco.1999.0289">Application of computer algebra systems for stability analysis of difference schemes on curvilinear grids</a>. <em>Journal of Symbolic Computation</em> <strong>28</strong> no. 3, pages 401-433, 1999.</dd>
        <dt id="Garavaglia:80">[Garavaglia:80] T.&nbsp;Garavaglia.</dt>
        <dd><a href="http://dx.doi.org/10.1007/BF02730158">A covariant formulation for polarized electron (muon) scattering on spin-zero and polarized spin-&frac12; targets</a>. <em>Il Nuovo Cimento A</em> <strong>56</strong> no. 2, pages 121-128, March 1980.</dd>
        <dt id="Garavaglia:84">[Garavaglia:84] Theodore Garavaglia.</dt>
        <dd><a href="http://link.aps.org/doi/10.1103/PhysRevD.29.387">Dirac- and Majorana-neutrino-mass effects in neutrino-electron elastic scattering</a>. <em>Physical Review D (Particles and Fields)</em> <strong>29</strong> no. 3, pages 387-392, February 1984.</dd>
        <dt id="Garavaglia">[Garavaglia] Theodore Garavaglia.</dt>
        <dd><a href="http://dx.doi.org/10.1007/BF02080690">Polarized electron scattering on spin zero and polarized spin-&frac12; targets: Deep inelastic scattering, elastic electron-muon scattering, and elastic electron-nucleon scattering</a>. <em>International Journal of Theoretical Physics</em> <strong>23</strong> no. 3, pages 251-294, 1984.</dd>
        <dt id="Garcia:86">[Garcia:86] Arnaldo Garcia and Paulo Viana.</dt>
        <dd>Weierstrass points on certain non-classical curves. <em>Arch. Math.</em> <strong>46</strong>, pages 315-322, 1986.</dd>
        <dt id="Garrad:86">[Garrad:86] A.&nbsp;D. Garrad and D.&nbsp;C. Quarton.</dt>
        <dd><a href="http://dx.doi.org/10.1016/S0022-460X(86)80022-0">Symbolic computing as a tool in wind turbine dynamics</a>. <em>Journ. of Sound and Vibration</em> <strong>109</strong> no. 1, pages 65-78, August 1986.</dd>
        <dt id="Gasper:95">[Gasper:95]</dt>
        <dd>G.&nbsp;Gasper, <a href="http://arxiv.org/abs/math.CA/9509223">Lecture notes for an introductory minicourse on q-series</a>. 1995.</dd>
        <dt id="GasperRahman:90">[GasperRahman:90] G.&nbsp;Gasper and M.&nbsp;Rahman.</dt>
        <dd><em>Basic Hypergeometric Series</em>. Number&nbsp;35 in Encyclopedia of Mathematics and its Applications. Cambridge University Press, London and New York, 1990.</dd>
        <dt id="Gastmans:79">[Gastmans:79] R.&nbsp;Gastmans, A.&nbsp;van Proeyen, and P.&nbsp;Verbaeten.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0010-4655(79)90112-7">Symbolic evaluations of dimensionally regularized Feynman diagrams</a>. <em>Computer Physics Communications</em> <strong>18</strong> no. 2, pages 201-203, 1979.</dd>
        <dt id="Gatermann:90">[Gatermann:90] Karin Gatermann.</dt>
        <dd><a href="http://www.zib.de/Publications/Reports/TR-90-01.pdf">Gruppentheoretische Konstruktion von symmetrischen Kubaturformeln</a>. Preprint TR 90-1, Konrad-Zuse-Zentrum f&uuml;r Informationstechnik Berlin, January 1990.</dd>
        <dt id="Gatermann:90a">[Gatermann:90a] Karin Gatermann.</dt>
        <dd><a href="http://doi.acm.org/10.1145/96877.96907">Symbolic solution of polynomial equation systems with symmetry</a>. In: S.&nbsp;Watanabe and Morio Nagata, editors, <em>Proceedings of the 1990 International Symposium on Symbolic and Algebraic Computation</em>, pages 112-119. ACM, Addison-Wesley, 1990.</dd>
        <dt id="Gatermann:91a">[Gatermann:91a] Karin Gatermann.</dt>
        <dd><a href="http://doi.acm.org/10.1145/120694.120762">Mixed symbolic-numeric solution of symmetrical nonlinear systems</a>. In: Stephen&nbsp;M. Watt, editor, <em>Proc. of the 1991 International Symposium on Symbolic and Algebraic Computation</em>, pages 431-432, Maryland, 1991. ACM, ACM Press.</dd>
        <dt id="Gatermann:92">[Gatermann:92] Karin Gatermann.</dt>
        <dd><a href="http://opus.kobv.de/zib/volltexte/1992/82/pdf/SC-92-13.pdf">Computation of bifurcation graphs</a>. In: E.&nbsp;Allgower, K.&nbsp;Georg, and R.&nbsp;Miranda, editors, <em>Exploiting Symmetry in Applied and Numerical Analysis: 1992 AMS-SIAM Summer Seminar in Applied Mathematics, July 26- August 1, 1992, AMS Lectures in Applied Mathematics V</em>, volume&nbsp;29, pages 187-201, June 1992.</dd>
        <dt id="Gatermann:94">[Gatermann:94] Karin Gatermann.</dt>
        <dd><a href="http://dx.doi.org/10.1007/BF01191379">Semi-invariants, equivariants and algorithms</a>. <em>Applicable Algebra in Engineering, Communication and Computing</em> <strong>7</strong> no. 2, pages 105-124, March 1996.</dd>
        <dt id="Gatermann:2000">[Gatermann:2000] Karin Gatermann.</dt>
        <dd><a href="http://www.springer.com/math/cse/book/978-3-540-67161-9"><em>Computer Algebra Methods for Equivariant Dynamical Systems</em></a>. Springer-Verlag, 2000.</dd>
        <dt id="Gatermann:91b">[Gatermann:91b] Karin Gatermann and Andreas Hohmann.</dt>
        <dd><a href="http://opus.kobv.de/zib/volltexte/1991/57/">Hexagonal lattice dome-illustration of a nontrivial bifurcation problem</a>. Preprint SC-91-8, Konrad-Zuse-Zentrum f&uuml;r Informationstechnik Berlin, July 1991.</dd>
        <dt id="Gatermann:91">[Gatermann:91] Karin Gatermann and Andreas Hohmann.</dt>
        <dd><a href="http://opus.kobv.de/zib/volltexte/1990/39/">Symbolic exploitation of symmetry in numerical pathfollowing</a>. <em>IMPACT of Computing in Science and Engineering</em> <strong>3</strong> no. 4, pages 330-365, December 1991.
        </dd>
        <dt id="Gatermann:95">[Gatermann:95] Karin Gatermann and Reiner Lauterbach.</dt>
        <dd><a href="http://opus.kobv.de/zib/volltexte/1995/169/pdf/SC-95-03.pdf">Automatic classification of normal forms</a>. <em>Nonlinear Analysis: Theory, Methods &amp; Applications</em> <strong>34</strong> no. 2, pages 157-190, October 199.</dd>
        <dt id="Gatermann:93">[Gatermann:93] Karin Gatermann and Bodo Werner.</dt>
        <dd><a href="http://opus.kobv.de/zib/volltexte/1992/98/">Group theoretical mode interactions with different symmetries</a>. <em>International Journal on Bifurcation and Chaos</em> <strong>4</strong> no. 1, pages 177-191, 1994.</dd>
        <dt id="Gatermann:93a">[Gatermann:93a]</dt>
        <dd>Karin Gatermann and Bodo Werner, <a href="http://opus.kobv.de/zib/volltexte/1993/111/"><em>Secondary Hopf bifurcation caused by steady-state steady-state mode interaction</em></a>, <em>Fields Institute Communications</em>&nbsp;5, pages 209-224. American Mathematical Society, 1996.</dd>
        <dt id="Gates:85a">[Gates:85a] Barbara&nbsp;L. Gates.</dt>
        <dd><a href="http://doi.acm.org/10.1145/1089411.1089415">Gentran: An automatic code generation facility for REDUCE</a>. <em>SIGSAM Bulletin</em> <strong>19</strong>
            no. 3, pages 24-42, August 1985.</dd>
        <dt id="Gates:85c">[Gates:85c] Barbara&nbsp;L. Gates.</dt>
        <dd>Gentran design and implementation, REDUCE version. Memorandum INF-85-12, Twente University of Technology, Department of Computer Science, The Netherlands, August 1985.</dd>
        <dt id="Gates:85b">[Gates:85b] Barbara&nbsp;L. Gates.</dt>
        <dd>Gentran user&apos;s manual - REDUCE version. Memorandum INF-85-11, Twente University of Technology, Department of Computer Science, The Netherlands, June 1985.</dd>
        <dt id="Gates:86">[Gates:86] Barbara&nbsp;L. Gates.</dt>
        <dd><a href="http://doi.acm.org/10.1145/32439.32459">A numerical code generation facility for REDUCE</a>. In: <em>SYMSAC &apos;86: Proceedings of the fifth ACM symposium on Symbolic and algebraic computation</em>, pages 94-99, New York, NY, USA, 1986. ACM.</dd>
        <dt id="Gates:85">[Gates:85] Barbara&nbsp;L. Gates and J.&nbsp;A. van Hulzen.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-15984-3_333">Automatic generation of optimized programs</a>. In: <em>Proc. EUROCAL &apos;85</em>, volume 204, pages 583-584, April 1985.</dd>
        <dt id="Gebauer:85">[Gebauer:85] R&uuml;diger Gebauer and H.&nbsp;Michael M&ouml;ller.</dt>
        <dd>A fast variant of Buchberger&apos;s algorithm. Technical report, Universit&auml;t Heidelberg and Fernuniversit&auml;t Hagen, October 1985.</dd>
        <dt id="Gebauer:88">[Gebauer:88] R&uuml;diger Gebauer and H.&nbsp;Michael M&ouml;ller.</dt>
        <dd><a href="http://dx.doi.org/10.1016/S0747-7171(88)80048-8">On an installation of Buchberger&apos;s algorithm</a>. <em>Journal of Symbolic Computation</em> <strong>6</strong> no. 2 and 3, pages 275-286, 1988.</dd>
        <dt id="Geddes:92">[Geddes:92] K.O. Geddes, S.R. Czapor, and G.&nbsp;Labahn.</dt>
        <dd><a href="http://dx.doi.org/10.1007/b102438"><em>Algorithms for Computer Algebra</em></a>. Kluwer Academic Publishers, 1992.</dd>
        <dt id="Generalis:84">[Generalis:84] S.&nbsp;C. Generalis and D.&nbsp;J. Broadhurst.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0370-2693(84)90040-6">The heavy-quark expansion and QCD sum rules for light quarks</a>. <em>Physics Letters B</em> <strong>139</strong> no. 1-2, pages 85-89, 1984.</dd>
        <dt id="George:68">[George:68] D.&nbsp;J. George.</dt>
        <dd><a href="http://link.aps.org/doi/10.1103/PhysRev.167.1357">A covariant theory of the disintegration of the deuteron by pions and photons at high energy</a>. <em>Phys. Rev.</em> <strong>167</strong> no. 5, pages 1357-1364, 1968.</dd>
        <dt id="Gerdt:93">[Gerdt:93] V.&nbsp;Gerdt.</dt>
        <dd>Homogeneity of integrability conditions for multiparametric families of polynomial-nonlinear evolution equations. In: G.&nbsp;Jacob, N.&nbsp;E. Oussous, and S.&nbsp;Steinberg, editors, <em>Proceedings of the 1993 International IMACS Symposium on Symbolic Computation</em>, pages 181-186. IMACS, Laboratoire d&apos;Informatique Fondamentale de Lille, France, 1993.</dd>
        <dt id="Gerdt:80">[Gerdt:80] V.&nbsp;P. Gerdt.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0010-4655(80)90113-7">Analytical calculations in high energy physics by computer</a>. <em>Computer Physics Communications</em> <strong>20</strong> no. 1, pages 85-90, 1980.</dd>
        <dt id="Gerdt:80b">[Gerdt:80b] V.&nbsp;P. Gerdt.</dt>
        <dd>On global structure of the general solution of the Chew-Low equations. <em>Sov. Theor. Math. Phys.</em> <strong>48</strong> no. 3, pages 790-796, 1982.</dd>
        <dt id="Gerdt:91b">[Gerdt:91b] V.&nbsp;P. Gerdt.</dt>
        <dd>Computer algebra tools for higher symmetry analysis of nonlinear evolution equations. In: <em>Proceedings of the IFIP TC2/WG 2.5 Working Conference on Programming Environments for High-Level Scientific Problem Solving</em>, pages 107-117, Amsterdam, The Netherlands, The Netherlands, 1991. North-Holland Publishing Co.</dd>
        <dt id="Gerdt:00">[Gerdt:00] V.&nbsp;P. Gerdt.</dt>
        <dd><a href="http://dx.doi.org/10.1023/A:1013596522989%20%20http://arxiv.org/abs/math?papernum=9912030">Involutive division technique: Some generalizations and optimizations</a>. <em>J. Math. Sci.</em> <strong>258</strong>, pages 185-206, 2000.</dd>
        <dt id="Gerdt:98">[Gerdt:98] V.&nbsp;P. Gerdt and Yu.&nbsp;A. Blinkov.</dt>
        <dd><a href="http://dx.doi.org/10.1016/S0378-4754(97)00127-4">Involutive bases of polynomial ideals</a>. <em>Math. Comp. Simul.</em> <strong>45</strong> no. 5-6, pages 519-541, March 1998.</dd>
        <dt id="Gerdt:98a">[Gerdt:98a] V.&nbsp;P. Gerdt and Yu.&nbsp;A. Blinkov.</dt>
        <dd><a href="http://dx.doi.org/10.1016/S0378-4754(97)00128-6">Minimal involutive bases</a>. <em>Math. Comp. Simul.</em> pages 543-560, 1998.</dd>
        <dt id="Gerdt:89">[Gerdt:89] V.&nbsp;P. Gerdt and N.&nbsp;A. Kostov.</dt>
        <dd>Computer algebra in the theory of ordinary differential equations of halphen type. In: E.&nbsp;Kaltofen and S.&nbsp;M. Watt, editors, <em>Proc. Computers and Mathematics &apos;89</em>, pages 279-288. Springer-Verlag, New York, 1989.</dd>
        <dt id="Gerdt:87a">[Gerdt:87a] V.&nbsp;P. Gerdt, N.&nbsp;A. Kostov, and Z.&nbsp;T. Kostova.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-51517-8_116">Computer algebra and computation of Puiseux expansions of algebraic functions</a>. In: <em>Proc. EUROCAL &apos;87, Lecture Notes in Computer Science</em>, volume 378, pages 206-207. Springer-Verlag, 1987.</dd>
        <dt id="Gerdt:85b">[Gerdt:85b] V.&nbsp;P. Gerdt, N.&nbsp;A. Kostov, and P.&nbsp;P. Raychev.</dt>
        <dd>Calculation of the matrix elements of the Hamiltonian of the interacting vector boson model using computer algebra - matrix elements of the Hamiltonian and some U(6)-Clebsch-Gordon coefficients. Technical Report E4-85-263, Institute for Nuclear Research and Nuclear Energy, Bulgarian Academy of Sciences, Sofia, Bulgaria, 1985.</dd>
        <dt id="Gerdt:85a">[Gerdt:85a] V.&nbsp;P. Gerdt, N.&nbsp;A. Kostov, P.&nbsp;P. Raychev, and R.&nbsp;P. Roussev.</dt>
        <dd>Calculation of the matrix elements of the Hamiltonian of the interacting vector boson model using computer algebra - basic concepts of the interacting vector boson model and matrix elements of the SU(3)-Quadrupole operator. Technical Report E4-85-262, Institute for Nuclear Research and Nuclear Energy, Bulgarian Academy of Sciences, Sofia, Bulgaria, 1985.</dd>
        <dt id="Gerdt:85c">[Gerdt:85c] V.&nbsp;P. Gerdt, N.&nbsp;A. Kostov, P.&nbsp;P. Raychev, and R.&nbsp;P. Roussev.</dt>
        <dd>Calculation of the matrix elements of the Hamiltonian of the interacting vector boson model using computer algebra - matrix elements of the Hamiltonian - analytical results. Technical Report E4-85-264, Institute for Nuclear Research and Nuclear Energy, Bulgarian Academy of Sciences, Sofia, Bulgaria, 1985.</dd>
        <dt id="Gerdt:90c">[Gerdt:90c] V.&nbsp;P. Gerdt, N.&nbsp;A. Kostov, and A.&nbsp;Yu. Zharkov.</dt>
        <dd>Nonlinear evolution equations and solving algebraic systems: The importance of computer algebra. In: <em>International Conference on Solitons and Its Applications</em>, pages 120-128, Singapore, 1990. World Scientific.</dd>
        <dt id="Gerdt:89a">[Gerdt:89a] V.&nbsp;P. Gerdt, Z.&nbsp;T. Kostova, N.&nbsp;A. Kostov, and I.&nbsp;P. Yudin.</dt>
        <dd>Algebraic-numeric calculations of proton trajectories in bending magnets of synchrotron accelerator. Preprint E11-89-755, J.I.N.R., Dubna, 1989.</dd>
        <dt id="Gerdt:86">[Gerdt:86] V.&nbsp;P. Gerdt, M.&nbsp;G. Meshcheryakov, and D.&nbsp;V. Shirkov.</dt>
        <dd>Computers in theoretical physics. Technical Report P2-86-848, J.I.N.R., Dubna, 1986.</dd>
        <dt id="Gerdt:87">[Gerdt:87] V.&nbsp;P. Gerdt, A.&nbsp;B. Shabat, S.&nbsp;I. Svinolupov, and A.&nbsp;Yu. Zharkov.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-51517-8_92">Computer algebra application for investigating integrability of nonlinear evolution systems</a>. In: <em>Proc. EUROCAL &apos;87, Lecture Notes in Computer Science</em>, volume 378, pages 81-92. Springer-Verlag, 1987.</dd>
        <dt id="Gerdt:85">[Gerdt:85] V.&nbsp;P. Gerdt, A.&nbsp;B. Shvachka, and A.&nbsp;Yu. Zharkov.</dt>
        <dd><a href="http://dx.doi.org/10.1016/S0747-7171(85)80031-6">Computer algebra application for classification of integrable non-linear evolution equations</a>. <em>Journal of Symbolic Computation</em> <strong>1</strong> no. 1, pages 101-107, 1985.</dd>
        <dt id="Gerdt:80a">[Gerdt:80a] V.&nbsp;P. Gerdt, O.&nbsp;V. Tarasov, and D.&nbsp;V. Shirkov.</dt>
        <dd>Analytical calculations on digital computers for applications in physics and mathematics. <em>Sov. Phys. USP</em> <strong>23</strong>, pages 59-77, 1980.</dd>
        <dt id="Gerdt:91a">[Gerdt:91a] V.&nbsp;P. Gerdt and P.&nbsp;Tiller.</dt>
        <dd>A Reduce program for symbolic computation of Puiseux expansions. Preprint E5-91-401, J.I.N.R., Dubna, 1991.</dd>
        <dt id="Gerdt:89b">[Gerdt:89b] V.&nbsp;P. Gerdt and A.&nbsp;Yu. Zharkov.</dt>
        <dd>Solving the polynomial system arising in classification of integrable coupled KdV-like systems. Preprint P5-89-231, J.I.N.R., Dubna, 1989.</dd>
        <dt id="Gerdt:90b">[Gerdt:90b] V.&nbsp;P. Gerdt and A.&nbsp;Yu. Zharkov.</dt>
        <dd><a href="http://dx.doi.org/10.1016/S0747-7171(08)80041-7">Computer classification of integrable coupled KdV-Like systems</a>. <em>Journal of Symbolic Computation</em> <strong>10</strong> no. 2, pages 203-207, 1990.</dd>
        <dt id="Gerdt:90">[Gerdt:90] V.&nbsp;P. Gerdt and A.&nbsp;Yu. Zharkov.</dt>
        <dd><a href="http://doi.acm.org/10.1145/96877.96939">Computer generation of necessary integrability conditions for polynomial-nonlinear evolution systems</a>. In: S.&nbsp;Watanabe and Morio Nagata, editors, <em>Proceedings of the International Symposium on Symbolic and Algebraic Computation</em>, pages 250-254. ACM, Addison-Wesley, 1990.</dd>
        <dt id="Gerdt:91">[Gerdt:91] V.&nbsp;P. Gerdt and A.&nbsp;Yu. Zharkov.</dt>
        <dd><a href="http://doi.acm.org/10.1145/120694.120742">Lie-B&auml;cklund symmetries of coupled nonlinear Schr&ouml;dinger equations</a>. In: Stephen&nbsp;M. Watt, editor,  <em>Proc. of the 1991 International Symposium on Symbolic and Algebraic Computation</em>, pages 313-314, Maryland, 1991. ACM Press.</dd>
        <dt id="Gerdt:90a">[Gerdt:90a] Vladimar&nbsp;P. Gerdt, Nikolai&nbsp;V. Khutornoy, and Alexey&nbsp;Yu. Zharkov.</dt>
        <dd><a href="http://doi.acm.org/10.1145/96877.96968">Solving algebraic systems which arise as necessary integrability conditions for polynomial-nonlinear evolution equations</a>. In: S.&nbsp;Watanabe and Morio Nagata, editors, <em>Proceedings of the International Symposium on Symbolic and Algebraic Computation</em>, page 299. ACM, Addison-Wesley, 1990.</dd>
        <dt id="Gervois:74">[Gervois:74] A.&nbsp;Gervois and Y.&nbsp;Pomeau.</dt>
        <dd><a href="http://link.aps.org/doi/10.1103/PhysRevA.9.2196">Logarithmic divergence in the virial expansion of transport coefficients of hard spheres</a>. <em>Phys. Rev. A</em> <strong>9</strong> no. 5, pages 2196-2213, 1974.</dd>
        <dt id="Ghergu:2001">[Ghergu:2001] F.&nbsp;Ghergu and D.N. Vulcanov.</dt>
        <dd><a href="http://cise.aip.org/getabs/servlet/GetabsServlet?prog=normal&id=CSENFA000003000002000065000001&idtype=cvips&gifs=Yes">Using algebraic programming to teach general relativity</a>. <em>Computing in Science and Engineering</em> <strong>3</strong> no. 2, pages 65-70, March 2001.</dd>
        <dt id="Gladd:82">[Gladd:82] N.&nbsp;T. Gladd.</dt>
        <dd>Computational aspects of research on the relativistic Whistler instability. Technical Report J530-82-020, Jaycor, June 1982.</dd>
        <dt id="Gladkih:83">[Gladkih:83] I.&nbsp;Gladkih and E.&nbsp;Lovas.</dt>
        <dd>On the application of computer algebra languages in the Central Research Institute for Physics. In: <em>Proceedings of the International Conference on Systems and Techniques of Analytical Computing and Their Applications in Theoretical Physics, D11-83-511, Dubna</em>, 1983.</dd>
        <dt id="Gladkih:84">[Gladkih:84] I.&nbsp;Gladkih and M.&nbsp;Zimanyi.</dt>
        <dd>Comparison of systems for symbolic computing in use in the Central Research Institute for Physics (in Russian). In: <em>Proceedings of the International Conference on Computer-Based Scientific Research, Plovdiv</em>, 1984.</dd>
        <dt id="Goldman:89">[Goldman:89] V.&nbsp;V. Goldman and J.&nbsp;A. van Hulzen.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0307-904X(90)90179-9">Automatic code vectorization of arithmetic expressions by bottom-up structure recognition</a>. In: J.&nbsp;Della Dora and J.&nbsp;Fitch, editors, <em>Computer Algebra and Parallelism</em>, pages 119-132. Academic Press, London, 1989. Presentations made at a workshop held at the TIM3 Laboratory of the University of Grenoble, June, 1988.</dd>
        <dt id="Golley">[Golley] Bruce&nbsp;W. Golley and Joseph Petrolito.</dt>
        <dd>An alternative finite strip technique for the static analysis of single-span, multi-span and continuous plates. In: <em>Proc. International Conference on Finite Element Methods</em>, 1982.</dd>
        <dt id="Good:75">[Good:75] D.&nbsp;Good, R.&nbsp;L. London, and W.&nbsp;W. Bledsoe.</dt>
        <dd><a href="http://doi.acm.org/10.1145/390016.808472">An interactive program verification system</a>. <em>SIGPLAN Notices</em> <strong>10</strong> no. 6, pages 482-492, June 1975.</dd>
        <dt id="Gosper:78">[Gosper:78] R.&nbsp;W. Gosper, Jr.</dt>
        <dd><a href="http://www.pnas.org/content/75/1/40.abstract">Decision procedure for indefinite hypergeometric summation</a>. <em>Proc. Natl. Acad. Sci. USA</em>
            <strong>75</strong> no. 1, pages 40-42, January 1978.</dd>
        <dt id="Goto:77">[Goto:77] E.&nbsp;Goto and T.&nbsp;Soma.</dt>
        <dd>MOL (moving objective lens) formulation of deflective aberration free system. <em>Optik</em> <strong>48</strong>, pages 255-270, 1977.</dd>
        <dt id="Goto:78">[Goto:78] E.&nbsp;Goto and T.&nbsp;Soma.</dt>
        <dd>Electron beam lithography for advanced LSI fabrication. In: <em>Proc. 1978 National Computer Conference, AFIPS Press, New Jersey</em>, pages 1223-1228, 1978.</dd>
        <dt id="Gould:84">[Gould:84] H.&nbsp;W. Gould and M.&nbsp;E. Mays.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0022-247X(84)90125-2">Series expansions of means</a>. <em>Journ. of Mathematical Analysis and Applications</em>
            <strong>101</strong> no. 2, pages 611-621, July 1984.</dd>
        <dt id="Graebe:95">[Graebe:95] H.-G. Gr&auml;be.</dt>
        <dd><a href="http://www.informatik.uni-leipzig.de/~graebe/ComputerAlgebra/Software/Cali"><em>CALI - A Reduce package for commutative algebra. Version 2.2.1</em></a>. Uni Leipzig, June 1995.</dd>
        <dt id="Graebe:93">[Graebe:93] Hans-Gert Gr&auml;be.</dt>
        <dd><a href="http://dx.doi.org/10.1006/jsco.1993.1014">On lucky primes</a>. <em>Journal of Symbolic Computation</em> <strong>15</strong> no. 2, pages 199-209, February 1993.</dd>
        <dt id="Gragert:81">[Gragert:81] Peter Gragert.</dt>
        <dd><em>Symbolic Computations in Prolongation Theory</em>. PhD thesis, Twente University of Technology, The Netherlands, 1981.</dd>
        <dt id="Grammaticos:85">[Grammaticos:85] B.&nbsp;Grammaticos, B.&nbsp;Dorizzi, A.&nbsp;Ramani, and J.&nbsp;Hietarinta.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0375-9601(85)90259-2">Extending integrable Hamiltonian systems from 2 to N dimensions</a>. <em>Physics Letters A</em> <strong>109</strong> no. 3, pages 81-84, 1985.</dd>
        <dt id="Grammaticos">[Grammaticos] B.&nbsp;Grammaticos and A.&nbsp;Voros.</dt>
        <dd><em>Semi-Classical Approximations for Nuclear Hamiltonians: II. Spin-dependent Potentials</em>.</dd>
        <dt id="Grammaticos:78">[Grammaticos:78] B.&nbsp;Grammaticos and A.&nbsp;Voros.</dt>
        <dd>Semi-classical approximations for nuclear Hamiltonians I. Spin-independent potentials. Preprint DPh-T/78-75, CEN, Saclay, August 1978.</dd>
        <dt id="Gray:90">[Gray:90] N.&nbsp;Gray, D.&nbsp;J. Broadhurst, W.&nbsp;Grafe, and K.&nbsp;Schilcher.</dt>
        <dd><a href="http://dx.doi.org/10.1007/BF01614703">Three-loop relation of quark <span style="text-decoration: overline;">MS</span> and pole masses</a>. <em>Zeitschrift f&uuml;r Physik C. Particles and Fields</em> <strong>48</strong> no. 4, pages 673-679, December 1990.</dd>
        <dt id="Grebot:94">[Grebot:94] G.&nbsp;Grebot and T.Wolf.</dt>
        <dd><a href="http://dx.doi.org/10.1142/S0218271894000551">Automatic symmetry investigation of space-time metrics</a>. In: <em>Proceedings of the Journees Relativistes &apos;93 in Brussels, Int. J. of Mod. Phys. D</em>, volume&nbsp;3, pages 323-326, 1994.</dd>
        <dt id="Greenland:84">[Greenland:84] P.&nbsp;T. Greenland.</dt>
        <dd><a href="http://dx.doi.org/10.1088/0022-3700/17/9/029">Comparison between phase diffusion and random telegraph signal models of laser bandwidth</a>. <em>J. Phys. B: At. Mol. Phys.</em> <strong>17</strong>, pages 1919-1925, 1984.</dd>
        <dt id="Grimm">[Grimm] R.&nbsp;Grimm and H.&nbsp;K&uuml;hnelt.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0010-4655(80)90111-3">Using REDUCE in problems of supersymmetry and supergravity</a>. <em>Computer Physics Communications</em> <strong>20</strong>, page&nbsp;77, 1980.</dd>
        <dt id="Griss:74">[Griss:74] M.&nbsp;L. Griss.</dt>
        <dd>The algebraic solution of large sparse systems of linear equations using REDUCE 2. In: <em>Proc. ACM 74</em>, pages 105-111, 1974.</dd>
        <dt id="Griss:74a">[Griss:74a] M.&nbsp;L. Griss.</dt>
        <dd><a href="http://doi.acm.org/10.1145/355666.355668">The algebraic solution of sparse linear systems via minor expansion</a>. <em>ACM Trans. Math. Softw.</em> <strong>2</strong> no. 1, pages 31-49, 1976.</dd>
        <dt id="Griss:77a">[Griss:77a] M.&nbsp;L. Griss.</dt>
        <dd>Efficient recursive minor expansion. <em>ACM Trans. Math. Softw.</em> , 1977.</dd>
        <dt id="Griss:75">[Griss:75] Martin&nbsp;L. Griss.</dt>
        <dd>The REDUCE system for computer algebra. In: <em>Proc. ACM 75</em>, pages 4-5, 1975.</dd>
        <dt id="Griss:76">[Griss:76] Martin&nbsp;L. Griss.</dt>
        <dd><a href="http://doi.acm.org/10.1145/800205.806323">The definition and use of data structures in reduce</a>. In: <em>SYMSAC &apos;76: Proceedings of the third ACM symposium on Symbolic and algebraic computation</em>, pages 53-59, New York, NY, USA, 1976. ACM.</dd>
        <dt id="Griss:76a">[Griss:76a] Martin&nbsp;L. Griss.</dt>
        <dd>An efficient sparse minor expansion algorithm. In: <em>Proc. ACM 76</em>, pages 429-434, 1976.</dd>
        <dt id="Griss:77">[Griss:77] Martin&nbsp;L. Griss.</dt>
        <dd>Efficient expression evaluation in sparse minor expansion, using hashing and deferred evaluation. In: <em>Proc. 10th Hawaii International Conference on Systems Sciences, Western Periodicals, Calif.</em>, pages 169-172, 1977.</dd>
        <dt id="Griss:78">[Griss:78] Martin&nbsp;L. Griss.</dt>
        <dd><a href="http://dx.doi.org/10.1109/TC.1978.1674974">Using an efficient sparse minor expansion algorithm to compute polynomial subresultants and the greatest common denominator</a>. <em>IEEE Trans on Computers</em> <strong>C-27</strong> no. 10, pages 945-950, 1978.</dd>
        <dt id="Griss:82">[Griss:82] Martin&nbsp;L. Griss, Eric Benson, and Gerald Q.&nbsp;Maguire Jr.</dt>
        <dd>PSL: A portable Lisp system. In: <em>Proc. ACM Symposium on Lisp and Functional Programming</em>, pages 88-97, 1982.</dd>
        <dt id="Griss:79">[Griss:79] Martin&nbsp;L. Griss and Anthony&nbsp;C. Hearn.</dt>
        <dd><a href="http://dx.doi.org/10.1002/spe.4380110603">Portable LISP compiler</a>. <em>Software - Practice and Experience</em> <strong>11</strong> no. 6, pages 541-605, June 1979.</dd>
        <dt id="Griss:78a">[Griss:78a] Martin&nbsp;L. Griss and Robert&nbsp;R. Kessler.</dt>
        <dd>REDUCE/1700: A micro-coded Algebra system. In: <em>MICRO 11: Proceedings of the 11th annual workshop on Microprogramming</em>, pages 130-138, Piscataway, NJ, USA, 1978. IEEE Press.</dd>
        <dt id="Griss:79a">[Griss:79a] Martin&nbsp;L. Griss and Robert&nbsp;R. Kessler.</dt>
        <dd>A micro-programmed implementation of Standard LISP and REDUCE on the Burroughs B1700/B1800 computer. Report, University of Utah, February 1979.</dd>
        <dt id="Grozin:83">[Grozin:83] A.&nbsp;G. Grozin.</dt>
        <dd>Calculation of one-loop diagrams of 1 &rarr; 2 decays with REDUCE. In: <em>Proc. Int. Conf. on Computer Algebra in Theoretical Physics, Dubna</em>, pages 226-231, 1983.</dd>
        <dt id="Grozin:88">[Grozin:88] A.&nbsp;G. Grozin.</dt>
        <dd>Solving physical problems with REDUCE. 1. REDUCE language 2. Classical nonlinear oscillator. Preprint 88-115, Institute of Nuclear Physics 630090, Novosibirsk, USSR, 1988.</dd>
        <dt id="Grozin:88a">[Grozin:88a] A.&nbsp;G. Grozin.</dt>
        <dd>Solving physical problems with REDUCE. 3. Nonlinear water waves 4. Calculation of the curvature tensor 5. Angular momentum addition. Preprint 88-136, Institute of Nuclear Physics 630090, Novosibirsk, USSR, 1988.</dd>
        <dt id="Grozin:88b">[Grozin:88b] A.&nbsp;G. Grozin.</dt>
        <dd>Solving physical problems with REDUCE. 6. Quantum nonlinear oscillator 7. Rotator in a weak field 8. Radiative transitions in charmonium. Preprint 88-140, Institute of Nuclear Physics 630090, Novosibirsk, USSR, 1988.</dd>
        <dt id="Grozin:90">[Grozin:90] A.&nbsp;G. Grozin.</dt>
        <dd>REDUCE in elementary particle physics. Introduction. Technical Report INP 90-42, Institute of Nuclear Physics, Novosibirsk, 1990.</dd>
        <dt id="Grozin:90b">[Grozin:90b] A.&nbsp;G. Grozin.</dt>
        <dd>REDUCE in elementary particle physics. Quantum chromodynamics. Technical Report INP 90-62, Institute of Nuclear Physics, Novosibirsk, 1990.</dd>
        <dt id="Grozin:90a">[Grozin:90a] A.&nbsp;G. Grozin.</dt>
        <dd>REDUCE in elementary particle physics. Quantum electrodynamics. Technical Report INP 90-71, Institute of Nuclear Physics, Novosibirsk, 1990.</dd>
        <dt id="Grozin:91a">[Grozin:91a] A.&nbsp;G. Grozin.</dt>
        <dd>REDUCE in elementary particle physics. Radiative corrections. Technical Report INP 91-46, Institute of Nuclear Physics, Novosibirsk, 1991.</dd>
        <dt id="Grozin:91">[Grozin:91] A.&nbsp;G. Grozin.</dt>
        <dd>REDUCE in elementary particle physics. Weak interactions. Technical Report INP 91-56, Institute of Nuclear Physics, Novosibirsk, 1991.</dd>
        <dt id="Grozin:97">[Grozin:97] A.&nbsp;G. Grozin.</dt>
        <dd><em>Using REDUCE in High Energy Physics</em>. Cambridge University Press, 1997.</dd>
        <dt id="Grozin:01">[Grozin:01] A.G. Grozin.</dt>
        <dd><a href="http://arxiv.org/abs/cs/0107036v2">Texmacs interfaces to maxima, mupad and reduce</a>. <em>CoRR</em> <strong>cs.SC/0107036</strong>, 2001.</dd>
        <dt id="Gunion:72">[Gunion:72] J.&nbsp;F. Gunion, S.&nbsp;J. Brodsky, and R.&nbsp;Blankenbecler.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0370-2693(72)90022-6">Composite theory of large angle scattering and new tests of parton concepts</a>. <em>Physics Letters B</em> <strong>39</strong> no. 5, pages 649-653, 1972.</dd>
        <dt id="Gunion:73">[Gunion:73] J.&nbsp;F. Gunion, S.&nbsp;J. Brodsky, and R.&nbsp;Blankenbecler.</dt>
        <dd><a href="http://dx.doi.org/10.1103/PhysRevD.8.287">Large angle scattering and the interchange force</a>. <em>Physical Review D</em> <strong>8</strong> no. 1, pages 287-312, 1973.</dd>
        <dt id="Gunion:85">[Gunion:85] J.&nbsp;F. Gunion and Z.&nbsp;Kunszt.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0370-2693(85)90774-9">Improved analytic techniques for tree graph calculations and the g g q <span style="text-decoration: overline;">q</span> &#8467; <span style="text-decoration: overline;">&#8467;</span> subprocess</a>. <em>Physics Letters B</em> <strong>161</strong> no. 4-6, pages 333-340, 1985.</dd>
    </dl>

    <dl id='H'>
        <dt id="Hadinger:87">[Hadinger:87] G.&nbsp;Hadinger and Y.&nbsp;S. Tergimen.</dt>
        <dd><a href="http://link.aip.org/link/?JCPSA6/87/2143/1">Recurrence relations for the Dunham coefficients and analytic expressions of the diagonal radial matrix elements for an anharmonic oscillator</a>. <em>Journal of Chemical Physics</em> <strong>87</strong> no. 4, pages 2143-2150, 1987.</dd>
        <dt id="Handy:87">[Handy:87] N.&nbsp;C. Handy.</dt>
        <dd><a href="http://dx.doi.org/10.1080/00268978700101081">The derivation of vibration-rotation kinetic energy operators, in internal coordinates</a>. <em>Molecular Physics</em> <strong>61</strong> no. 1, pages 207-223, May 1987.</dd>
        <dt id="Harlander:05">[Harlander:05] Robert Harlander and Philipp Kant.</dt>
        <dd><a href="http://arxiv.org/abs/hep-ph/0509189">Higgs production and decay: Analytic results at next-to-leading order qcd</a>. <em>JHEP</em> <strong>0512</strong>, page 015, 2005.</dd>
        <dt id="Harper:87">[Harper:87] David Harper.</dt>
        <dd><em>Dynamics of the Outer Satellites of Saturn</em>. PhD thesis, Univ. of Liverpool, England, 1987.</dd>
        <dt id="Harper:89a">[Harper:89a] David Harper.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0010-4655(89)90092-1">Vector33: a REDUCE program for vector algebra and calculus in orthogonal curvilinear coordinates</a>. <em>Computer Physics Communications</em> <strong>54</strong> no. 2 and 3, pages 295-305, June and July 1989.</dd>
        <dt id="Harper:89">[Harper:89] David Harper, Chris Wooff, and David Hodgkinson.</dt>
        <dd>A guide to computer algebra systems. Report, Computer Laboratory, The University of Liverpool, Liverpool, England, September 1989.</dd>
        <dt id="Harrington:77a">[Harrington:77a] S.&nbsp;J. Harrington.</dt>
        <dd><a href="http://doi.acm.org/10.1145/1088252.1088254">REDUCE solution to problem #8</a>. <em>SIGSAM Bulletin</em> <strong>11 and 12</strong> no. 4 and 1, pages 7-8, November and February 1977 and 1978.</dd>
        <dt id="Harrington:77">[Harrington:77] Steven&nbsp;J. Harrington.</dt>
        <dd>A symbolic limit evaluation program in REDUCE. 1977.</dd>
        <dt id="Harrington:79">[Harrington:79] Steven&nbsp;J. Harrington.</dt>
        <dd><a href="http://dx.doi.org/10.1093/comjnl/22.2.127">A new symbolic integration system in REDUCE</a>. <em>The Computer Journal</em> <strong>22</strong> no. 2, pages 127-131, 1979.</dd>
        <dt id="Harrington:79a">[Harrington:79a] Steven&nbsp;J. Harrington.</dt>
        <dd><a href="http://doi.acm.org/10.1145/1088282.1088286">A symbolic limit evaluation program in REDUCE</a>. <em>SIGSAM Bulletin</em> <strong>13</strong> no. 1, pages 27-31, February 1979.</dd>
        <dt id="Hartley:91">[Hartley:91] David Hartley and Robin&nbsp;W. Tucker.</dt>
        <dd><a href="http://dx.doi.org/10.1016/S0747-7171(08)80146-0">A constructive implementation of the Cartan-K&auml;hler theory of exterior differential systems</a>.  <em>Journal of Symbolic Computation</em> <strong>12</strong> no. 6, pages 655-667, December 1991.</dd>
        <dt id="Hartley:95">[Hartley:95] David Hartley and Philip Tuckey.</dt>
        <dd><a href="http://dx.doi.org/10.1006/jsco.1995.1046">Gr&ouml;bner bases in Clifford and Grassman algebras</a>. <em>Journal of Symbolic Computation</em> <strong>20</strong> no. 2, pages 197-205, August 1995.</dd>
        <dt id="Hasenfratz:80">[Hasenfratz:80] Anna Hasenfratz and Peter Hasenfratz.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0370-2693(80)90118-5">The connection between the &Lambda; parameters of lattice and continuum QCD</a>. <em>Physics Letters B</em> <strong>93</strong> no. 1-2, pages 165-169, June 1980.</dd>
        <dt id="Hearn:66">[Hearn:66] A.&nbsp;C. Hearn.</dt>
        <dd><a href="http://doi.acm.org/10.1145/365758.365766">Computation of algebraic properties of elementary particle reactions using a digital computer</a>. <em>Comm. ACM</em> <strong>9</strong> no. 8, pages 573-577, 1966.</dd>
        <dt id="Hearn:66a">[Hearn:66a] A.&nbsp;C. Hearn.</dt>
        <dd>Standard Lisp. <em>SIGPLAN Notices</em> <strong>4</strong> no. 9, 1966.</dd>
        <dt id="Hearn:76b">[Hearn:76b] A.&nbsp;C. Hearn.</dt>
        <dd><a href="http://doc.cern.ch/yellowrep/1976/1976-024/p201.pdf">Symbolic computation</a>. In: <em>Proc. CERN 1976 Computing School, CERN Geneva</em>, pages 201-211, 1976.</dd>
        <dt id="Hearn:77">[Hearn:77] A.&nbsp;C. Hearn.</dt>
        <dd>The structure of algebraic computations. In: <em>Proc. of the Fourth Colloquium on Advanced Comp. Methods in Theor. Physics. St. Maximin, France</em>, pages 1-15, 1977.</dd>
        <dt id="Hearn:69">[Hearn:69] A.&nbsp;C. Hearn, P.&nbsp;K. Kuo, and D.&nbsp;R. Yennie.</dt>
        <dd><a href="http://link.aps.org/doi/10.1103/PhysRev.187.2088">Radiative corrections to an electron-positron scattering experiment</a>. <em>Phys. Rev.</em> <strong>187</strong> no. 5, pages 2088-2096, 1969.</dd>
        <dt id="Hearn:68">[Hearn:68] Anthony&nbsp;C. Hearn.</dt>
        <dd>REDUCE: A user-oriented interactive system for algebraic simplification. In: M.&nbsp;Klerer and J.&nbsp;Reinfelds, editors, <em>Interactive Systems for Experimental Applied Mathematics</em>, pages 79-90, New York, 1968. Academic Press.</dd>
        <dt id="Hearn:69a">[Hearn:69a] Anthony&nbsp;C. Hearn.</dt>
        <dd>The problem of substitution. In: R.G. Tobey, editor, <em>Proc. of the 1968 Summer Institute on Symbolic Mathematical Computation</em>, pages 3-19, Cambridge, Mass, 1969. IBM Boston Prog. Center.</dd>
        <dt id="Hearn:71">[Hearn:71] Anthony&nbsp;C. Hearn.</dt>
        <dd><a href="http://doi.acm.org/10.1145/362637.362641">Applications of symbolic manipulation in theoretical physics</a>. <em>Comm. ACM</em> <strong>14</strong> no. 8, pages 511-516, 1971.</dd>
        <dt id="Hearn:71b">[Hearn:71b] Anthony&nbsp;C. Hearn.</dt>
        <dd>Calculation of traces of products of gamma matrices. In: <em>Proc. of the Second Colloquium on Advanced Computing Methods in Theoretical Physics, CNRS, Marseilles</em>, pages I-30 - I-44, 1971.</dd>
        <dt id="Hearn:71c">[Hearn:71c] Anthony&nbsp;C. Hearn.</dt>
        <dd>The computer solution of algebraic problems by pattern matching. In: <em>Proc. of the Second Colloquium on Advanced Computing Methods in Theoretical Physics, CNRS, Marseilles</em>, pages I-45 - I-57, 1971.</dd>
        <dt id="Hearn:71a">[Hearn:71a] Anthony&nbsp;C. Hearn.</dt>
        <dd><a href="http://doi.acm.org/10.1145/800204.806277">REDUCE 2: A system and language for algebraic manipulation</a>. In: S.R. Petrick, editor, <em>SYMSAC &apos;71: Proceedings of the second ACM symposium on Symbolic and algebraic manipulation</em>, pages 128-133. ACM, New York, 1971.</dd>
        <dt id="Hearn:72">[Hearn:72] Anthony&nbsp;C. Hearn.</dt>
        <dd>Computer solution of symbolic problems in theoretical physics. In: <em>Computing as a Language of Physics, IAEA, Vienna</em>, pages 567-596, 1972.</dd>
        <dt id="Hearn:72a">[Hearn:72a] Anthony&nbsp;C. Hearn.</dt>
        <dd><a href="http://doi.acm.org/10.1145/1093522.1093524">Improved non-modular polynomial GCD algorithm</a>. <em>SIGSAM Bulletin</em> no. 23, pages 10-15, 1972.</dd>
        <dt id="Hearn:72b">[Hearn:72b] Anthony&nbsp;C. Hearn.</dt>
        <dd><a href="http://doi.acm.org/10.1145/1086793.1086797">A REDUCE solution of problem #2 - the Y(2n) functions</a>. <em>SIGSAM Bulletin</em> no. 24, pages 14-15, 1972.</dd>
        <dt id="Hearn:73a">[Hearn:73a] Anthony&nbsp;C. Hearn.</dt>
        <dd>The REDUCE program for computer algebra. In: <em>Proc. of the Third Colloquium on Advanced Computing Methods in Theoretical Physics, CNRS, Marseilles</em>, 1973.</dd>
        <dt id="Hearn:74a">[Hearn:74a] Anthony&nbsp;C. Hearn.</dt>
        <dd><a href="http://doi.acm.org/10.1145/1408800.1408891">A mode analyzing algebraic manipulation program</a>. In: <em>ACM &apos;74: Proceedings of the 1974 annual ACM conference</em>, pages 722-724. ACM, 1974.</dd>
        <dt id="Hearn:74">[Hearn:74] Anthony&nbsp;C. Hearn.</dt>
        <dd>Polynomial and rational function representations. In: <em>Proc. Math Software II, Purdue University</em>, 1974.</dd>
        <dt id="Hearn:76a">[Hearn:76a] Anthony&nbsp;C. Hearn.</dt>
        <dd><a href="http://doi.acm.org/10.1145/800205.806322">A new reduce model for algebraic simplification</a>. In: <em>SYMSAC &apos;76: Proceedings of the third ACM symposium on Symbolic and algebraic computation</em>, pages 46-52, New York, NY, USA, 1976. ACM.</dd>
        <dt id="Hearn:76">[Hearn:76] Anthony&nbsp;C. Hearn.</dt>
        <dd>Scientific applications of symbolic computation. <em>Computer Science and Scientific Comp.</em> pages 83-108, 1976.</dd>
        <dt id="Hearn:78">[Hearn:78] Anthony&nbsp;C. Hearn.</dt>
        <dd>Algebraic manipulation by computer. In: <em>Proc. Intern. Meeting on Programm. and Math. Meth. for Solving Phys. Probs., Dubna, USSR</em>, pages 96-116, 1978.</dd>
        <dt id="Hearn:79">[Hearn:79] Anthony&nbsp;C. Hearn.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-09519-5_74">Non-modular computation of polynomial GCDs using trial division</a>. In: <em>Symbolic and Algebraic Computation (EUROSAM &apos;79, An International Symposium on Symbolic and Algebraic Manipulation, Marseille, France, June 1979)</em>, <em>Lecture Notes in Computer Science</em>&nbsp;72, pages 227-239. Springer Berlin / Heidelberg, 1979.</dd>
        <dt id="Hearn:80">[Hearn:80] Anthony&nbsp;C. Hearn.</dt>
        <dd>The personal algebra machine. In: <em>Information Processing 80, Proc. IFIP Congress 80</em>, pages 621-628, 1980.</dd>
        <dt id="Hearn:81a">[Hearn:81a] Anthony&nbsp;C. Hearn.</dt>
        <dd><a href="http://doc.cern.ch/cgi-bin/tiff2pdf?/archive/cernrep/1981/81-03/p390.tif">Symbolic computation and its application to high-energy physics</a>. In: <em>Proc. 1980 CERN School of Computing, Geneva</em>, pages 390-406, 1981.</dd>
        <dt id="Hearn:82">[Hearn:82] Anthony&nbsp;C. Hearn.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-11607-9_31">REDUCE - a case study in algebra system development</a>. In: <em>Computer Algebra (EUROCAM &apos;82, European Computer Algebra Conference Marseille, France 5-7 April 1982 )</em>, <em>Lecture Notes in Computer Science</em> 144, pages 263-272. Springer Berlin / Heidelberg, 1982.</dd>
        <dt id="Hearn:85">[Hearn:85] Anthony&nbsp;C. Hearn.</dt>
        <dd>Structure: The key to improved algebraic computation. In: <em>Proc. of the Second RIKEN International Symposium on Symbolic and Algebraic Computation by Computers</em>, pages 215-230, Singapore, 1985. World Scientific.</dd>
        <dt id="Hearn:86">[Hearn:86] Anthony&nbsp;C. Hearn.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-16776-5_744">Optimal evaluation of algebraic expressions</a>. In: <em>AAECC-3: Proceedings of the 3rd International Conference on Algebraic Algorithms and Error-Correcting Codes</em>, <em>Lecture Notes in Computer Science</em> 229, pages 392-403. Springer Verlag, 1986.</dd>
        <dt id="Hearn:91">[Hearn:91] Anthony&nbsp;C. Hearn.</dt>
        <dd><a href="http://www.uni-koeln.de/REDUCE/3.6/doc/reduce/">REDUCE User&apos;s Manual, Version 3.6</a>. Report CP 78, RAND, July 1995.</dd>
        <dt id="Hearn:99">[Hearn:99] Anthony&nbsp;C. Hearn.</dt>
        <dd><a href="http://www.zib.de/Symbolik/reduce/moredocs/reduce.pdf">REDUCE User&apos;s Manual, Version 3.7</a>. Report, Anthony C. Hearn, July 1999.</dd>
        <dt id="Hearn:04">[Hearn:04] Anthony&nbsp;C. Hearn.</dt>
        <dd><a href="http://reduce-algebra.com/docs/reduce.pdf">REDUCE User&apos;s Manual, Version 3.8</a>. Report, Anthony C. Hearn, April 2004.</dd>
        <dt id="Hearn:05">[Hearn:05] Anthony&nbsp;C. Hearn.</dt>
        <dd><a href="http://reduce-algebra.com/reduce40.pdf">REDUCE: The First Forty Years</a>. In: Andreas Dolzmann, Andreas Seidl, and Thomas Sturm, editors, <em>Algorithmic Algebra and Logic. Proceedings of the A3L</em>, pages 19-24. Books on Demand GmbH Norderstedt, 2005.</dd>
        <dt id="Hearn:82a">[Hearn:82a] Anthony&nbsp;C. Hearn, M.&nbsp;L. Griss, and E.&nbsp;Benson.</dt>
        <dd>Current status of a portable LISP compiler. In: <em>Proc. SIGPLAN &apos;82 Symp. on Compiler Construction, ACM</em>, pages 276-283, 1982.</dd>
        <dt id="Hearn:73">[Hearn:73] Anthony&nbsp;C. Hearn and R&uuml;diger G.&nbsp;K. Loos.</dt>
        <dd><a href="http://doi.acm.org/10.1145/800192.805696">Extended polynomial algorithms</a>. In: <em>ACM&apos;73: Proceedings of the annual conference</em>, pages 147-152, 1973.</dd>
        <dt id="Hearn:79a">[Hearn:79a] Anthony&nbsp;C. Hearn and Arthur&nbsp;C. Norman.</dt>
        <dd><a href="http://doi.acm.org/10.1145/954004.954005">A one-pass prettyprinter</a>. <em>SIGPLAN Notices</em> <strong>14</strong> no. 12, pages 50-58, December 1979.</dd>
        <dt id="Hearn:93">[Hearn:93] Anthony&nbsp;C. Hearn and Eberhard Schr&uuml;fer.</dt>
        <dd><a href="http://dx.doi.org/10.1007/BFb0013174">An order-sorted approach to algebraic computation</a>. In: <em>Design and Implementation of Symbolic Computation Systems (International Symposium, DISCO &apos;93 Gmunden, Austria, September 15–17, 1993 Proceedings)</em>, <em>Lecture Notes In Computer Science</em> 722, pages 134-144. Springer-Verlag, 1993.</dd>
        <dt id="Hearn:95">[Hearn:95] Anthony&nbsp;C. Hearn and Eberhard Schr&uuml;fer.</dt>
        <dd><a href="http://dx.doi.org/10.1006/jsco.1995.1005">A computer algebra system based on order-sorted algebra</a>. <em>Journal of Symbolic Computation</em> <strong>19</strong> no. 1-3, pages 65-77, January 1995.</dd>
        <dt id="Hearn:81">[Hearn:81] Anthony&nbsp;C. Hearn and S.&nbsp;Watanabe.</dt>
        <dd>Analytic integration by computer. <em>Information Processing Society of Japan</em> <strong>22</strong> no. 7, pages 639-650, 1981.</dd>
        <dt id="Hehl:92">[Hehl:92] Friedrich&nbsp;W. Hehl and Hartmut Meyer.</dt>
        <dd>Mit buchstaben auf dem computer rechnen. <em>Physikalische Bl&auml;tter</em> <strong>48</strong>, pages 377-381, 1992.</dd>
        <dt id="Hehl:98">[Hehl:98] F.W. Hehl, A.&nbsp;Mac&iacute;as, and J.&nbsp;Socorro.</dt>
        <dd><a href="http://dx.doi.org/10.1016/S0010-4655(98)00133-7">Computer algebra in gravity: Reduce-excalc programs for (non-)riemannian spacetimes. i</a>. <em>Computer Physics Communications</em> <strong>115</strong> no. 2-3, pages 264-283, December 1998.</dd>
        <dt id="Hehl:2003">[Hehl:2003] F.W. Hehl and Yu.N. Obukhov.</dt>
        <dd><em>Foundations of Classical Electrodynamics: Charge, Flux, and Metric</em>. Birkh&auml;user, Boston, MA, 2003.</dd>
        <dt id="Hehl:92a">[Hehl:92a] F.W. Hehl, V.&nbsp;Winkelmann, and H.&nbsp;Meyer.</dt>
        <dd><em>Computer-Algebra. Ein Kompaktkurs &uuml;ber die Anwendung von REDUCE</em>. Springer-Verlag, Berlin, Heidelberg, New York, ISBN 3-540-55724-5, 1992.</dd>
        <dt id="Hereman:96">[Hereman:96] Willy Hereman.</dt>
        <dd>Computer algebra: lightening the load. <em>Physics World</em> <strong>9</strong> no. 3, pages 47-52, March 1996.</dd>
        <dt id="Hermann:83">[Hermann:83] R.&nbsp;Hermann.</dt>
        <dd><a href="http://link.aip.org/link/?JMAPAQ/24/510/1">Geometric construction and properties of some families of solutions of nonlinear partial differential equations</a>. <em>Journal of Mathematical Physics</em> <strong>24</strong> no. 3, pages 510-521, 1983.</dd>
        <dt id="Hess:84">[Hess:84] P.&nbsp;O. Hess and W.&nbsp;Greiner.</dt>
        <dd><a href="http://dx.doi.org/10.1007/BF02902566">The collective modes of nuclear molecules</a>. <em>Il Nuovo Cimento A</em> <strong>83</strong> no. 1, pages 76-177, September 1984.</dd>
        <dt id="Hettich:77">[Hettich:77] R.&nbsp;P. Hettich and J.&nbsp;A. van Hulzen.</dt>
        <dd>Approximation with a class of rational functions. Memorandum 165, Department of Applied Mathematics, Twente University of Technology, The Netherlands, May 1977.</dd>
        <dt id="Hietarinta:83a">[Hietarinta:83a] J.&nbsp;Hietarinta.</dt>
        <dd><a href="http://link.aps.org/doi/10.1103/PhysRevA.28.3670">Integrable families of Henon-Heiles type Hamiltonians and a new duality</a>. <em>Phys. Rev. A</em> <strong>28</strong> no. 6, pages 3670-3672, 1983.</dd>
        <dt id="Hietarinta:83">[Hietarinta:83] J.&nbsp;Hietarinta.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0375-9601(83)90178-0">A search for integrable two-dimensional Hamiltonian systems with polynomial potential</a>. <em>Physics Letters A</em> <strong>96</strong> no. 6, pages 273-278, 1983.</dd>
        <dt id="Hietarinta:84">[Hietarinta:84] J.&nbsp;Hietarinta.</dt>
        <dd><a href="http://link.aip.org/link/?JMAPAQ/25/1833/1">Classical versus quantum integrability</a>. <em>Journal of Mathematical Physics</em> <strong>25</strong>, pages 1833-1840, 1984.</dd>
        <dt id="Hietarinta:84a">[Hietarinta:84a] J.&nbsp;Hietarinta.</dt>
        <dd><a href="http://link.aps.org/doi/10.1103/PhysRevLett.52.1057">New integrable Hamiltonians with transcendental invariants</a>. <em>Physical Review Letters</em> <strong>52</strong> no. 13, pages 1057-1060, 1984.</dd>
        <dt id="Hietarinta:85">[Hietarinta:85] J.&nbsp;Hietarinta.</dt>
        <dd><a href="http://link.aip.org/link/?JMAPAQ/26/1970/1">How to construct integrable Fokker-Planck and electromagnetic Hamiltonians from ordinary integrable Hamiltonians</a>. <em>Journal of Mathematical Physics</em> <strong>26</strong>, pages 1970-1975, 1985.</dd>
        <dt id="Hietarinta:87">[Hietarinta:87] J.&nbsp;Hietarinta.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0370-1573(87)90089-5">Direct methods for the search of the second invariant</a>. <em>Physics Reports</em> <strong>147</strong> no. 2, pages 87-154, 1987.</dd>
        <dt id="Hietarinta:87a">[Hietarinta:87a] J.&nbsp;Hietarinta.</dt>
        <dd><a href="http://link.aip.org/link/?JMAPAQ/28/1732/1">A search of bilinear equations passing Hirota&apos;s three-soliton condition: I. KdV-type bilinear equations</a>. <em>Journal of Mathematical Physics</em> <strong>28</strong>, pages 1732-1742, 1987.</dd>
        <dt id="Hietarinta:87b">[Hietarinta:87b] J.&nbsp;Hietarinta.</dt>
        <dd><a href="http://link.aip.org/link/?JMAPAQ/28/2094/1">A search of bilinear equations passing Hirota&apos;s three-soliton condition: II. mKdV-type bilinear equations</a>. <em>Journal of Mathematical Physics</em> <strong>28</strong>, pages 2094-2101, 1987.</dd>
        <dt id="Hietarinta:87c">[Hietarinta:87c] J.&nbsp;Hietarinta.</dt>
        <dd><a href="http://link.aip.org/link/?JMAPAQ/28/2586/1">A search of bilinear equations passing Hirota&apos;s three-soliton condition: III. Sine-Gordon-type bilinear equations</a>. <em>Journal of Mathematical Physics</em> <strong>28</strong>, pages 2586-2592, 1987.</dd>
        <dt id="Hietarinta:88">[Hietarinta:88] J.&nbsp;Hietarinta.</dt>
        <dd><a href="http://link.aip.org/link/?JMAPAQ/29/628/1">A search of bilinear equations passing Hirota&apos;s three-soliton condition: IV. complex bilinear equations</a>. <em>Journal of Mathematical Physics</em> <strong>29</strong>, pages 628-635, 1988.</dd>
        <dt id="Hietarinta:91">[Hietarinta:91] J.&nbsp;Hietarinta.</dt>
        <dd>From an analytical formula to a movie by way of REDUCE and C. In: <em>Proc. of the Workshop on Symbolic and Numeric Computation</em>, pages 117-126. Research Reports, Computing Centre of Helsinki University, 1991.</dd>
        <dt id="Hietarinta:09">[Hietarinta:09]</dt>
        <dd>J.&nbsp;Hietarinta, <a href="http://dx.doi.org/10.1007/978-3-540-88111-7_9"><em>Hirota&apos;s Bilinear Method and Its Connection with Integrability</em></a>, <em>Lecture Notes in Physics</em> 767, chapter&nbsp;08, pages 279-314. Springer, 2009.</dd>
        <dt id="Hietarinta:89">[Hietarinta:89] J.&nbsp;Hietarinta and B.&nbsp;Grammaticos.</dt>
        <dd><a href="http://dx.doi.org/10.1088/0305-4470/22/9/020">On the &#8463;<sup>2</sup>-correction terms in quantum integrability</a>. <em>J. Phys. A: Math. Gen.</em> <strong>22</strong> no. 9, pages 1315-1322, 1989.</dd>
        <dt id="Hietarinta:84b">[Hietarinta:84b] J.&nbsp;Hietarinta, B.&nbsp;Grammaticos, B.&nbsp;Dorizzi, and A.&nbsp;Ramani.</dt>
        <dd><a href="http://link.aps.org/doi/10.1103/PhysRevLett.53.1707">Coupling-constant metamorphosis and duality between integrable Hamiltonian systems</a>. <em>Physical Review Letters</em> <strong>53</strong> no. 18, pages 1707-1710, 1984.</dd>
        <dt id="Hietarinta:92">[Hietarinta:92] Jarmo Hietarinta.</dt>
        <dd><a href="http://dx.doi.org/http://doi.acm.org/10.1145/143242.143351">Solving the constant quantum yang-baxter equation in 2 dimensions with massive use of factorizing gr&ouml;bner basis computations</a>. Technical report, University of Turku, Finland, New York, NY, USA, 1992.</dd>
        <dt id="Hietarinta:92a">[Hietarinta:92a] Jarmo Hietarinta.</dt>
        <dd>Solving the two-dimensional constant quantum Yang-Baxter equation. Report TURKU-FL-R7, University of Turku, Finland, May 1992.</dd>
        <dt id="Hirota:89">[Hirota:89] Ryogo Hirota and Masaaki Ito.</dt>
        <dd><em>Introduction to REDUCE - Doing Symbolic Computation on PC</em>. Science sha, Tokyo, June 1989.</dd>
        <dt id="Horowitz:75">[Horowitz:75] E.&nbsp;Horowitz and D.&nbsp;R. Musser.</dt>
        <dd>The synthesis and use of algebraic specifications of data structures. Preprint, University of Southern California, 1975.</dd>
        <dt id="Horwitz:83">[Horwitz:83] B.&nbsp;Horwitz.</dt>
        <dd><a href="http://www.pubmedcentral.nih.gov/articlerender.fcgi?artid=1329013">Unequal diameters and their effects on time varying voltages in branched neurons</a>. <em>BioPhys. J.</em> <strong>41</strong> no. 1, pages 51-66, January 1983.</dd>
        <dt id="Hughes:90">[Hughes:90] D.&nbsp;I. Hughes.</dt>
        <dd><a href="http://dx.doi.org/10.1016/S0747-7171(08)80164-2">Symbolic computation with fermions</a>. <em>Journal of Symbolic Computation</em> <strong>10</strong> no. 6, pages 657-664, December 1990.</dd>
        <dt id="Hulshof:83">[Hulshof:83] B.&nbsp;J.&nbsp;A. Hulshof and J.&nbsp;A. van Hulzen.</dt>
        <dd><a href="http://doi.acm.org/10.1145/1089320.1089323">Some REDUCE facilities for pretty printing subscripts and formal derivatives</a>. <em>SIGSAM Bulletin</em> <strong>17</strong> no. 1, pages 16-20, February 1983.</dd>
        <dt id="Hulshof:84">[Hulshof:84] B.&nbsp;J.&nbsp;A. Hulshof and J.&nbsp;A. van Hulzen.</dt>
        <dd><a href="http://dx.doi.org/10.1007/BFb0032848">Automatic error cumulation control</a>. In: <em>Proc. EUROSAM 1984, Lecture Notes in Computer Science</em>, volume 174, pages 260-271. Springer-Verlag, 1984.</dd>
        <dt id="Hulshof:85">[Hulshof:85] B.&nbsp;J.&nbsp;A. Hulshof and J.&nbsp;A. van Hulzen.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-15984-3_282">An expression compression package for REDUCE based on factorization and controlled expansion</a>. In: <em>Proc. EUROCAL 1985, Lecture Notes in Computer Science</em>, volume 204, pages 315-316. Springer-Verlag, 1985.</dd>
        <dt id="Hulshof:81">[Hulshof:81] B.&nbsp;J.&nbsp;A. Hulshof, J.&nbsp;A. van Hulzen, and J.&nbsp;Smit.</dt>
        <dd>Code optimization facilities applied in the Netform context. Memorandum 368, Department of Applied Mathematics, Twente University of Technology, The Netherlands, December 1981.</dd>
        <dt id="Hunt:91">[Hunt:91] R.&nbsp;E. Hunt and D.&nbsp;G. Crighton.</dt>
        <dd>Instability of flows in spatially developing media. <em>Proc. Roy. Soc. Lond. A</em> <strong>435</strong>, pages 109-128, 1991.</dd>
        <dt id="Husberg:81">[Husberg:81] N.&nbsp;Husberg.</dt>
        <dd>Preliminary II REDUCE-2 and Analitik-74, a comparison. Technical report, Helsinki University of Technology Computing Center, November 1981.</dd>
    </dl>

    <dl id='I'>
        <dt id="Idesawa:77">[Idesawa:77] M.&nbsp;Idesawa and T.&nbsp;Yatagai.</dt>
        <dd>General theory of projection-type Moir&eacute; topography. Scientific Papers&nbsp;71, Institute of Physical and Chemical Research, Wako-Shi, Saitama, 1977.</dd>
        <dt id="Finan:80">[Finan:80] Charles Henry&nbsp;Finan III.</dt>
        <dd><em>The alternating-direction implicit numerical solution of the time-dependent, three-dimensional, single fluid resistive magnetohydrodynamic equations</em>. PhD thesis, University of California, Davis, December 1980.</dd>
        <dt id="Ilyin:87">[Ilyin:87] V.&nbsp;A. Ilyin and A.&nbsp;P. Kryukov.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-51517-8_120">DIMREG - the package for calculations in the dimensional regularization with 4-dimensional &gamma;<sup>5</sup>
            -matrix in quantum field theory</a>. In: <em>Proc. EUROCAL &apos;87, Lecture Notes in Computer Science</em>, volume 378, pages 225-232. Springer-Verlag, 1987.</dd>
        <dt id="Ilyin:91">[Ilyin:91] V.&nbsp;A. Ilyin and A.&nbsp;P. Kryukov.</dt>
        <dd><a href="http://doi.acm.org/10.1145/120694.120727">Symbolic simplification of tensor expressions using symmetries, dummy indices and identities</a>. In: Stephen&nbsp;M. Watt, editor, <em>Proc. of the 1991 International Symposium on Symbolic and Algebraic Computation</em>, pages 224-228, Maryland, 1991. ACM Press.</dd>
        <dt id="Ilyin:96">[Ilyin:96] V.&nbsp;A. Ilyin and A.&nbsp;P. Kryukov.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0010-4655(96)00060-4">ATENSOR - REDUCE program for tensor simplification</a>. <em>Computer Physics Communications</em> <strong>96</strong> no. 1, pages 36-52, July 1996.</dd>
        <dt id="Ilyin:89">[Ilyin:89] V.&nbsp;A. Ilyin, A.&nbsp;P. Kryukov, A.&nbsp;Ya. Rodioniov, and A.&nbsp;Yu. Taranov.</dt>
        <dd><a href="http://doi.acm.org/10.1145/70927.70929">Fast algorithm for calculation of Dirac&apos;s gamma-matrices traces</a>. <em>SIGSAM Bulletin</em> <strong>23</strong> no. 4, pages 15-24, October 1989.</dd>
        <dt id="Ilyin:91a">[Ilyin:91a] V.&nbsp;A. Ilyin, A.&nbsp;P. Kryukov, A.&nbsp;Ya. Rodionov, and A&nbsp;Yu. Taranov.</dt>
        <dd><a href="http://doi.acm.org/10.1145/120694.120769">PC implementation of fast Dirac matrix trace calculations</a>. In: Stephen&nbsp;M. Watt, editor, <em>Proc. of the 1991 International Symposium on Symbolic and Algebraic Computation</em>, pages 456-457, Maryland, 1991. ACM Press.</dd>
        <dt id="IMO">[IMO]</dt>
        <dd><a href="http://olympiads.win.tue.nl/imo">International mathematics olympiad (imo)</a>.</dd>
        <dt id="Inada:80">[Inada:80] Nobuyuki Inada.</dt>
        <dd>Fortran-based LISP system for REDUCE. Technical report, Information Science Laboratory, The Institute of Physical and Chemical Research, 1980.</dd>
        <dt id="Ioakimidis:90a">[Ioakimidis:90a] N.&nbsp;I. Ioakimidis.</dt>
        <dd>Construction of singular integral equations for interacting straight cracks by using REDUCE. Technical report, Division of Applied Mathematics and Mechanics, School of Engineering, University of Patras, Greece, 1990.</dd>
        <dt id="Ioakimidis:90">[Ioakimidis:90] N.&nbsp;I. Ioakimidis.</dt>
        <dd>Construction of the equation of caustics in dynamic plane elasticity problems with the help of REDUCE. Technical report, Division of Applied Mathematics and Mechanics, School of Engineering, University of Patras, Greece, 1990.</dd>
        <dt id="Ito:85">[Ito:85] M.&nbsp;Ito.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0010-4655(85)90009-8">A REDUCE program for evaluating a Lax pair form</a>. <em>Computer Physics Communications</em> <strong>34</strong> no. 3, pages 325-331, 1985.</dd>
        <dt id="Ito:85a">[Ito:85a] M.&nbsp;Ito and F.&nbsp;Kako.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0010-4655(85)90109-2">A REDUCE program for finding conserved densities of partial differential equations with uniform rank</a>. <em>Computer Physics Communications</em> <strong>38</strong> no. 3, pages 415-419, 1985.</dd>
        <dt id="Ito:88">[Ito:88] Masaaki Ito.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0010-4655(88)90188-9">A REDUCE program for Hirota&apos;s bilinear operator and Wronskian operations</a>. <em>Computer Physics Communications</em> <strong>50</strong> no. 3, pages 321-330, August 1988.</dd>
        <dt id="Ito:94">[Ito:94] Masaaki Ito.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0010-4655(94)90193-7">SYMCD - a REDUCE package for finding symmetries and conserved densitites of systems of nonlinear evolution equations</a>. <em>Computer Physics Communications</em> <strong>79</strong> no. 3, pages 547-554, May 1994.</dd>
        <dt id="Ito:90a">[Ito:90a] Nobuyasu Ito.</dt>
        <dd><a href="http://ptp.ipap.jp/link?PTP/83/682/">Discrete-time and single-spin-flip dynamics of the Ising chain</a>. <em>Prog. Theor. Phys.</em> <strong>83</strong> no. 4, pages 682-692, April 1990.</dd>
        <dt id="Ito:90">[Ito:90] Nobuyasu Ito and Tetsuhiko Chikyu.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0378-4371(90)90012-H">Multi-spin-flip dynamics of the Ising chain</a>. <em>Physica A</em> <strong>166</strong> no. 2, pages 193-205, 1990.</dd>
    </dl>

    <dl id='J'>
        <dt id="Jansen:86">[Jansen:86] Paul Jansen and Peter Weidner.</dt>
        <dd><a href="http://doi.acm.org/10.1145/5960.5962">High-accuracy arithmetic software-some tests of the ACRITH problem-solving routines</a>. <em>ACM Trans. Math. Softw.</em> <strong>12</strong> no. 1, pages 62-70, March 1986.</dd>
        <dt id="Janssen:87">[Janssen:87] M.&nbsp;H.&nbsp;M. Janssen, D.&nbsp;H. Parker, and S.&nbsp;Stolte.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0301-0104(87)80003-4">Saturation in laser-induced fluorescence: Effects on alignment parameters</a>. <em>Chemical Phys.</em> <strong>113</strong> no. 3, pages 357-382, 1987.</dd>
        <dt id="Jeffrey:84">[Jeffrey:84] D.&nbsp;J. Jeffrey and Y.&nbsp;Onishi.</dt>
        <dd>The forces and couples acting on two nearly touching spheres in low-Reynolds-number flow. <em>Z. Ang. Math. Phys.</em> <strong>35</strong>, pages 634-641, 1984.</dd>
        <dt id="Jimenez:88">[Jimenez:88] Javier Jim&eacute;nez.</dt>
        <dd><a href="http://journals.cambridge.org/action/displayAbstract?fromPage=online&aid=394399&fulltextType=RA&fileId=S0022112088001041">Linear stability of a non-symmetric, inviscid, k&aacute;rm&aacute;n street of small uniform vortices</a>. <em>Journal of Fluid Mechanics Digital Archive</em> <strong>189</strong> no. -1, pages 337-348, 1988.</dd>
    </dl>

    <dl id='K'>
        <dt id="Kadlecsik:88">[Kadlecsik:88] J.&nbsp;Kadlecsik.</dt>
        <dd><a href="http://dx.doi.org/10.1007/BF01566925">New approaches to the axisymmetric vacuum</a>. <em>Zeitschrift f&uuml;r Physik C. Particles and Fields</em> <strong>41</strong> no. 2, pages 265-269, June 1988.</dd>
        <dt id="Kadlecsik:92">[Kadlecsik:92] Jo&oacute;zsef Kadlecsik.</dt>
        <dd>Tensor manipulation package for general relativity calculations. Preprint KFKI-1992-05/B+M, Central Research Institute for Physics, Budapest, 1992.</dd>
        <dt id="Kadlecsik:96">[Kadlecsik:96] Jo&oacute;zsef Kadlecsik.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0010-4655(95)00137-9">Ricci calculus package in REDUCE</a>. <em>Computer Physics Communications</em> <strong>93</strong> no. 2 and 3, pages 265-282, February 1996.</dd>
        <dt id="Kagan:88">[Kagan:88] Y.&nbsp;Y. Kagan.</dt>
        <dd><a href="http://dx.doi.org/10.1029/JB093iB09p10560">Static sources of elastic deformation in a homogeneous half-space</a>. <em>J. Geophys. Res.</em> <strong>93</strong> no. B9, pages 10,560-10,574, September 1988.</dd>
        <dt id="Kagan:85">[Kagan:85] Y.&nbsp;Y. Kagan and L.&nbsp;Knopoff.</dt>
        <dd><a href="http://dx.doi.org/10.1111/j.1365-246X.1985.tb06411.x">The first-order statistical moment of the seismic moment tensor</a>. <em>Geophys. J. Intern.</em> <strong>81</strong> no. 2, pages 429-444, 1985.</dd>
        <dt id="Kahn:69">[Kahn:69] M.&nbsp;E. Kahn.</dt>
        <dd>The near-minimum-time control of open loop articulated kinematic chains. Report AIM-106, Stanford University, Computer Science Dept., 1969.</dd>
        <dt id="Kamal:81">[Kamal:81] A.&nbsp;N. Kamal, J.&nbsp;Kodaira, and T.&nbsp;Muta.</dt>
        <dd>Gluon jets from heavy paraquarkonium. Technical Report SLAC-PUB-2725, University of Alberta, Canada and Stanford University, California and Fermi National Accelerator Laboratory, Illinois, April 1981.</dd>
        <dt id="Kamel:69">[Kamel:69] A.&nbsp;A. Kamel.</dt>
        <dd>Perturbation method in the theory of non-linear oscillations. Report, Stanford University, Dept. of Aeronautics and Astronautics, 1969.</dd>
        <dt id="Kamel:69a">[Kamel:69a] A.&nbsp;A. Kamel.</dt>
        <dd>Perturbation theory based on Lie transforms and its application to the stability of motion near Sun-perturbed Earth-Moon triangular libration points. Report 391, Stanford University, Dept. of Aeronautics and Astronautics, 1969.</dd>
        <dt id="Kamel:78">[Kamel:78] A.&nbsp;A. Kamel.</dt>
        <dd>Synchronous satellite ephemeris due to earth&apos;s triaxiality and luni-solar effects. In: <em>AIAA/AAS Astrodynamics Conference, Palo Alto, CA</em>, August 1978.</dd>
        <dt id="Kanada:75">[Kanada:75] Y.&nbsp;Kanada.</dt>
        <dd>Implementation of HLISP and algebraic manipulation language REDUCE 2. Report 75-01, University of Tokyo Information Science Lab, 1975.</dd>
        <dt id="Kanada:81">[Kanada:81] Yasumasa Kanada and Tateaki Sasaki.</dt>
        <dd><a href="http://doi.acm.org/10.1145/1089257.1089260">LISP-based big-float system is not slow</a>. <em>SIGSAM Bulletin</em> <strong>15</strong> no. 2, pages 13-19, May 1981.</dd>
        <dt id="Kaneko:89">[Kaneko:89] Toshiaki Kaneko and Setsuya Kawabata.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0010-4655(89)90073-8">A preprocessor for Fortran source code produced by REDUCE</a>. <em>Computer Physics Communications</em> <strong>55</strong> no. 2, pages 141-147, September 1989.</dd>
        <dt id="Kang:05a">[Kang:05a] Daekyoung Kang, Jong-Wan Lee, Jungil Lee, Taewon Kim, and Pyungwon Ko.</dt>
        <dd><a href="http://arxiv.org/abs/hep-ph/0412381">Color-evaporation-model calculation of e<sup>+</sup>e<sup>-</sup>&rarr;j/&psi;+c<span style="text-decoration: overline;">c</span>+x at s=10.6 gev</a>. <em>Physical Review D (Particles and Fields)</em> <strong>71</strong> no. 9, page 094019, May 2005.</dd>
        <dt id="Kang:05">[Kang:05] Daekyoung Kang, Jong-Wan Lee, Jungil Lee, Taewon Kim, and Pyungwon Ko.</dt>
        <dd><a href="http://arxiv.org/abs/hep-ph/0412224">Inclusive production of four charm hadrons in e<sup>+</sup>e<sup>-</sup> annihilation at B factories</a>. <em>Physical Review D (Particles and Fields)</em> <strong>71</strong> no. 7, page 071501, Apr 2005.</dd>
        <dt id="Kaplan:05">[Kaplan:05] Michael Kaplan.</dt>
        <dd><em>Computeralgebra</em>. Springer, 2005.</dd>
        <dt id="Kaps:85">[Kaps:85] P.&nbsp;Kaps, S.&nbsp;W.&nbsp;H. Poon, and T.&nbsp;D. Bui.</dt>
        <dd><a href="http://dx.doi.org/10.1007/BF02242171">Rosenbrock methods for stiff ODEs: A comparison of Richardson extrapolation and embedding techniques</a>. <em>Computing</em> <strong>34</strong> no. 1, pages 17-40, March 1985.</dd>
        <dt id="Karr:85">[Karr:85] Michael Karr.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-15984-3_334">Canonical form for rational exponential expressions</a>. In: <em>Proc. EUROCAL 1985, Lecture Notes in Computer Science</em>, volume 204, pages 585-594. Springer-Verlag, 1985.</dd>
        <dt id="Katsura:85">[Katsura:85] Shigetoshi Katsura.</dt>
        <dd>Application of the formula manipulating system to statistical mechanics. In: <em>Proc. of the Second RIKEN International Symposium on Symbolic and Algebraic Computation by Computers</em>, pages 155-180, Singapore, 1985. World Scientific.</dd>
        <dt id="Kauffman:73">[Kauffman:73] S.&nbsp;K. Kauffman.</dt>
        <dd><em>Ortho-Positronium Annihilation: Steps Toward Computing the First Order Radiative Corrections</em>. PhD thesis, California Institute of Technology, 1973.</dd>
        <dt id="Kazasov:87">[Kazasov:87] C.&nbsp;Kazasov.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-51517-8_100">Laplace transformations in REDUCE 3</a>. In: <em>Proc. EUROCAL &apos;87, Lecture Notes in Computer Science</em>, volume 378, pages 132-133. Springer-Verlag, 1987.</dd>
        <dt id="Keady:85">[Keady:85] Grant Keady.</dt>
        <dd>The power concavity of solutions of some semilinear elliptic Boundary-Value problems. <em>Bull. Austral. Math. Soc.</em> <strong>31</strong>, pages 181-184, 1985.</dd>
        <dt id="Keener:83">[Keener:83] James&nbsp;P. Keener.</dt>
        <dd><a href="http://dx.doi.org/10.1137/0143066">Oscillatory coexistence in the chemostat: a codimension two unfolding</a>. <em>SIAM J. Appl. Math.</em>
            <strong>43</strong> no. 5, pages 1005-1018, 1983.</dd>
        <dt id="Keener:85">[Keener:85] James&nbsp;P. Keener.</dt>
        <dd><a href="http://www.springerlink.com/content/lw0561t473023726/?p=802f3b767ee54701ab322cfcdd6110ed&pi=0">Oscillatory coexistence in a food chain model with competing predators</a>. <em>J. Math. Biology</em> <strong>22</strong> no. 2, pages 123-135, 1985.</dd>
        <dt id="Keener:89">[Keener:89] James&nbsp;P. Keener.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0167-2789(89)90262-5">Knotted scroll wave filaments in excitable media</a>. <em>Physica D</em> <strong>34</strong> no. 3, pages 378-390, 1989.</dd>
        <dt id="Keener:90">[Keener:90] James&nbsp;P. Keener.</dt>
        <dd><a href="http://dx.doi.org/10.1017/S0022112090001732">Knotted vortex filaments in an ideal fluid</a>. <em>J. Fluid Mech.</em> <strong>211</strong>, pages 629-651, 1990.</dd>
        <dt id="Kendall:88">[Kendall:88] W.&nbsp;S. Kendall.</dt>
        <dd>Symbolic computation and the diffusion of shapes of triads. <em>Adv. Appl. Prob.</em> <strong>20</strong>, pages 775-797, 1988.</dd>
        <dt id="Kendall:89">[Kendall:89] W.&nbsp;S. Kendall.</dt>
        <dd>The diffusion of Euclidean shape. Research Report 161, University of Warwick, Dept. of Statistics, 1989.</dd>
        <dt id="Kendall:89a">[Kendall:89a] W.&nbsp;S. Kendall.</dt>
        <dd>Probability, convexity, and harmonic maps with small image i: Uniqueness and fine existence. Research Report 162, University of Warwick, Dept. of Statistics, 1989.</dd>
        <dt id="Kendall:90">[Kendall:90] W.&nbsp;S. Kendall.</dt>
        <dd>Computer algebra and stochastic calculus. <em>Notices A.M.S.</em> <strong>37</strong>, pages 1254-1256, 1990.</dd>
        <dt id="Kendall:91">[Kendall:91] Wilfred&nbsp;S. Kendall.</dt>
        <dd>Computer algebra and stochastic calculus. Research Report 203, University of Warwick, Dept. of Statistics, 1991.</dd>
        <dt id="Kendall:91a">[Kendall:91a] Wilfred&nbsp;S. Kendall.</dt>
        <dd>Symbolic It&ocirc; calculus: An introduction. Research Report 217, University of Warwick, Dept. of Statistics, 1991.</dd>
        <dt id="Kendall:93">[Kendall:93] Wilfred&nbsp;S. Kendall.</dt>
        <dd>Probability, convexity, and harmonic maps ii: Smoothness via probabilistic gradient inequalities. Research Report 260, University of Warwick, Dept. of Statistics, October 1993.</dd>
        <dt id="Kerner:75">[Kerner:75] W.&nbsp;Kerner and R.&nbsp;C. Grimm.</dt>
        <dd>MHD spectra for Tokamaks with non-circular cross sections. In: <em>Proc. Seventh Conference on Numerical Simulation of Plasmas, Courant Institute, NYU</em>, 1975.</dd>
        <dt id="Kersten:84">[Kersten:84] P.&nbsp;Kersten and R.&nbsp;Martini.</dt>
        <dd><a href="http://dx.doi.org/10.1088/0305-4470/17/5/001">The harmonic map and killing fields for self-dual SU(3) Yang-Mills equations</a>. <em>J. Phys. A: Math. Gen.</em> <strong>17</strong> no. 5, pages L227-L230, 1984.</dd>
        <dt id="Kersten:83">[Kersten:83] P.&nbsp;H.&nbsp;M. Kersten.</dt>
        <dd><a href="http://link.aip.org/link/?JMAPAQ/24/2374/1">Infinitesimal symmetries and conserved currents for nonlinear Dirac equation</a>. <em>Journal of Mathematical Physics</em> <strong>24</strong>, pages 2374-2376, 1983.</dd>
        <dt id="Kersten:86">[Kersten:86] P.&nbsp;H.&nbsp;M. Kersten.</dt>
        <dd><a href="http://link.aip.org/link/?JMAPAQ/27/1139/1">Creating and annihilating Lie-B&auml;cklund transformations of the Federbush model</a>. <em>Journal of Mathematical Physics</em> <strong>27</strong>, pages 1139-1144, 1986.</dd>
        <dt id="Kersten:86a">[Kersten:86a] P.&nbsp;H.&nbsp;M. Kersten and H.&nbsp;M. M.&nbsp;Ten Eikelder.</dt>
        <dd><a href="http://link.aip.org/link/?JMAPAQ/27/2140/1">Infinite hierarchies of t-independent and t-dependent conserved functionals of the Federbush model</a>. <em>Journal of Mathematical Physics</em> <strong>27</strong>, pages 2140-2145, 1986.</dd>
        <dt id="Kersten:86b">[Kersten:86b] P.&nbsp;H.&nbsp;M. Kersten and H.&nbsp;M. M.&nbsp;Ten Eikelder.</dt>
        <dd><a href="http://link.aip.org/link/?JMAPAQ/27/2791/1">An infinite number of infinite hierarchies of conserved quantities of the Federbush model</a>. <em>Journal of Mathematical Physics</em> <strong>27</strong>, pages 2791-2796, 1986.</dd>
        <dt id="Killalea:80">[Killalea:80] M.&nbsp;K. Killalea and B.&nbsp;J. McCoy.</dt>
        <dd><a href="http://dx.doi.org/10.1002/bip.1980.360191014">Concentration distribution and spatial moments of moving macromolecules undergoing isomerization</a>. <em>Biopolymers</em> <strong>19</strong> no. 10, pages 1875-1886, 1980.</dd>
        <dt id="Kinoshita:72">[Kinoshita:72] T.&nbsp;Kinoshita and P.&nbsp;Cvitanovic.</dt>
        <dd>Sixth order radiative corrections to the electron magnetic moment. Report CLNS-197, Cornell Lab. for Nuclear Studies, October 1972.</dd>
        <dt id="Kinoshita:73">[Kinoshita:73] T.&nbsp;Kinoshita and P.&nbsp;Cvitanovic.</dt>
        <dd>Feynman-Dyson rules in parametric space. Report CLNS-209, Cornell Lab. for Nuclear Studies, January 1973.</dd>
        <dt id="KisWolf:05b">[KisWolf:05b] A.&nbsp;Kiselev and T.&nbsp;Wolf.</dt>
        <dd><a href="http://arxiv.org/abs/nlin/0511056v1">On weakly non-local, nilpotent, and super-recursion operators for n=1 homogeneous super-equations</a>. In: <em>Proc. Int. Workshop `Supersymmetries and Quantum Symmetries-05 (SQS&apos;05)</em>, pages 234-240. JINR, 2005. preprint, to appear in proceedings of Dubna International Workshop &ldquo;Supersymmetries and Quantum Symmetries&rdquo; (SQS&apos;05), arXiv math-ph/0511056.</dd>
        <dt id="KisWolf:06">[KisWolf:06]</dt>
        <dd>A.&nbsp;Kiselev and T.&nbsp;Wolf, Classification of integrable super-systems using the SsTools environment. preprint, arXiv nlin.SI/0609065, 2006.</dd>
        <dt id="KisWolf:05a">[KisWolf:05a] A.&nbsp;Kiselev and T.&nbsp;Wolf.</dt>
        <dd><a href="http://www.emis.de/journals/SIGMA/2006/Paper030/">Supersymmetric representations and integrable super-extensions of the burgers and bussinesq equations</a>. <em>SIGMA</em> <strong>2</strong>, page&nbsp;19, 2006. Paper 030, also arXiv math-ph/0511071.</dd>
        <dt id="Kitatani:86">[Kitatani:86] H.&nbsp;Kitatani, S.&nbsp;Miyashita, and M.&nbsp;Suzuki.</dt>
        <dd><a href="http://jpsj.ipap.jp/link?JPSJ/55/865/">Reentrant phenomena in some Ising spin systems - rigorous results and effects of an external field</a>. <em>J. Phys. Soc. Japan</em> <strong>55</strong> no. 3, pages 865-876, 1986.</dd>
        <dt id="Klimov:93">[Klimov:93] D.&nbsp;M. Klimov, V.&nbsp;V. Leonov, and V.&nbsp;M. Rudenko.</dt>
        <dd><a href="http://dx.doi.org/10.1006/jsco.1993.1005">The study of motion for a gyroscope with gimbal suspension: Obtaining the highest approximations for a drift of magnus</a>. <em>Journal of Symbolic Computation</em> <strong>15</strong> no. 1, pages 73-78, January 1993.</dd>
        <dt id="Kobayashi:88">[Kobayashi:88] H.&nbsp;Kobayashi, S.&nbsp;Moritsugu, and R.&nbsp;W. Hogan.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-51084-2_13">Solving systems of algebraic equations</a>. In: <em>Proc. of ISSAC &apos;88</em>, volume 358, pages 139-149. Springer-Verlag, 1988.</dd>
        <dt id="Kobayashi:84">[Kobayashi:84] Hidestune Kobayashi.</dt>
        <dd>Weierstrass points on a curve, X<sup>7</sup><sub>0</sub>+X<sup>7</sup><sub>1</sub>+X<sup>7</sup><sub>2</sub>=0. Preprint&nbsp;28, Research Institute of Science and Technology, Nihon University, March 1984.</dd>
        <dt id="Kocbach:94">[Kocbach:94] L.&nbsp;Kocbach and R.&nbsp;Liska.</dt>
        <dd><a href="http://dx.doi.org/10.1088/0953-4075/27/18/002">Closed form formula for the exchange integrals in the impact-parameter treatment of heavy-particle collisions</a>. <em>J. Phys. B: At. Mol. Opt. Phys.</em> <strong>27</strong> no. 18, pages L619-L624, 1994.</dd>
        <dt id="Kocbach:98">[Kocbach:98] L.&nbsp;Kocbach and R.&nbsp;Liska.</dt>
        <dd><a href="http://dx.doi.org/10.1006/jsco.1997.0182">Generation and verification of algorithms for symbolic-numeric processing</a>. <em>Journal of Symbolic Computation</em> <strong>25</strong> no. 3, pages 367-382, 1998.</dd>
        <dt id="Kocbach:01">[Kocbach:01] L.&nbsp;Kocbach and R.&nbsp;Liska.</dt>
        <dd>Automatic construction of code for two-electron repulsion matrix elements in travelling gaussian basis for atomic collisions using computer algebra. In: <em>XXII ICPEAC, Twenty Second International Conference on Photonic, Electronic and Atomic Collisions</em>, page 526, Santa Fe, 2001. July 18-24, 2001.</dd>
        <dt id="Kodaira:85">[Kodaira:85] Hiroshi Kodaira and Hiroshi Toshima.</dt>
        <dd>Gini coefficient of wealth in life cycle model. In: <em>Proc. of the Second RIKEN International Symposium on Symbolic and Algebraic Computation by Computers</em>, pages 119-151, Singapore, 1985. World Scientific.</dd>
        <dt id="KoekoekSwarttouw:94">[KoekoekSwarttouw:94] R.&nbsp;Koekoek and R.&nbsp;F. Swarttouw.</dt>
        <dd>The askey-scheme of hypergeometric orthogonal polynomials and its q-analogue. Report 94-05, Faculty of Technical Mathematics and Informatics, Technische Universiteit Delft, Delft, 1994.</dd>
        <dt id="Koepf:94a">[Koepf:94a] Wolfram Koepf.</dt>
        <dd>Algebraische darstellung transzendenter funktionen (in German). Preprint SC 94-24, Konrad-Zuse-Zentrum f&uuml;r Informationstechnik Berlin, October 1994.</dd>
        <dt id="Koepf:94b">[Koepf:94b] Wolfram Koepf.</dt>
        <dd>Algorithms for the indefinite and definite summation. Preprint SC 94-33, Konrad-Zuse-Zentrum f&uuml;r Informationstechnik Berlin, December 1994.</dd>
        <dt id="Koepf:95d">[Koepf:95d] Wolfram Koepf.</dt>
        <dd>Efficient computation of orthogonal polynomials in computer algebra. Preprint SC 95-42, Konrad-Zuse-Zentrum f&uuml;r Informationstechnik Berlin, December 1995.</dd>
        <dt id="Koepf:95c">[Koepf:95c] Wolfram Koepf.</dt>
        <dd>The identification problem for transcendental functions. Preprint SC 95-13, Konrad-Zuse-Zentrum f&uuml;r Informationstechnik Berlin, May 1995.</dd>
        <dt id="Koepf:95a">[Koepf:95a] Wolfram Koepf.</dt>
        <dd>Identities for families of orthogonal polynomials and special functions. Preprint SC 95-1, Konrad-Zuse-Zentrum f&uuml;r Informationstechnik Berlin, January 1995.</dd>
        <dt id="Koepf:95">[Koepf:95] Wolfram Koepf.</dt>
        <dd><a href="http://doi.acm.org/10.1145/216685.216687">REDUCE package for the indefinite and definite summation</a>. <em>SIGSAM Bulletin</em> <strong>29</strong> no. 1, pages 14-30, January 1995.</dd>
        <dt id="Koepf:95b">[Koepf:95b] Wolfram Koepf.</dt>
        <dd>Reduce packages on power series, z-transformation, residues and trigonometric simplification. Preprint TR 95-3, Konrad-Zuse-Zentrum f&uuml;r Informationstechnik Berlin, June 1995.</dd>
        <dt id="Koepf:94">[Koepf:94] Wolfram Koepf and Dieter Schmersau.</dt>
        <dd>Spaces of functions satisfying simple differential equations. Preprint TR 94-2, Konrad-Zuse-Zentrum f&uuml;r Informationstechnik Berlin, March 1994.</dd>
        <dt id="Koh:82">[Koh:82] I.&nbsp;G. Koh, Y.&nbsp;D. Kim, Y.&nbsp;J. Park, C.&nbsp;H. Kim, and Y.&nbsp;S. Kim.</dt>
        <dd><a href="http://link.aip.org/link/?JMAPAQ/23/1210/1">Complete set of SU(5) monopole solution</a>. <em>Journal of Mathematical Physics</em> <strong>23</strong>, pages 1210-1212, 1982.</dd>
        <dt id="Kohout:98">[Kohout:98] Ladislav&nbsp;J. Kohout and Andreas Strotmann.</dt>
        <dd>Understanding and improving content markup for the web: from the perspectives of formal linguistics, algebraic logics, and cognitive science. In: <em>ISIC/CIRA/ISAS &apos;98 Joint Conference on the Science and Technology of Intelligent Systems</em>, 1998.</dd>
        <dt id="Koike:92">[Koike:92] F.&nbsp;Koike.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0010-4655(92)90147-Q">Explicit formulae of angular momentum coupling coefficients</a>. <em>Computer Physics Communications</em> <strong>72</strong>, pages 154-164, November 1992.</dd>
        <dt id="Kolar:90">[Kolar:90] M.&nbsp;Kol&aacute;&rcaron; and M.&nbsp;K. Ali.</dt>
        <dd><a href="http://link.aps.org/doi/10.1103/PhysRevA.42.7112">Trace maps associated with general two-letter substitution rules</a>. <em>Phys. Rev. A</em>
            <strong>42</strong> no. 12, pages 7112-7124, December 1990.</dd>
        <dt id="Koelbig:81b">[Koelbig:81b] K.&nbsp;S. K&ouml;lbig.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0010-4655(81)90129-6">A program for computing the conical functions of the first kind P<sup>m</sup><sub>-1/2+i&tau;</sub>(x) for m = 0 and m = 1</a>. <em>Computer Physics Communications</em> <strong>23</strong> no. 1, pages 51-61, 1981.</dd>
        <dt id="Koelbig:82">[Koelbig:82] K.&nbsp;S. K&ouml;lbig.</dt>
        <dd>Closed expressions for &int;<sub>0</sub><sup>1</sup> t<sup>-1</sup>&nbsp;log<sup>n-1</sup> t log<sup>p</sup>(1-t) dt. <em>Math. Comp.</em> <strong>39</strong> no. 160, pages 647-654, October 1982.</dd>
        <dt id="Koelbig:83">[Koelbig:83] K.&nbsp;S. K&ouml;lbig.</dt>
        <dd>On the integral &int;<sub>0</sub><sup>&pi;/2</sup>&nbsp;log<sup>n</sup> cos x&nbsp;log<sup>p</sup> sin x dx. <em>Math. Comp.</em> <strong>40</strong>, pages 565-570, April 1983.</dd>
        <dt id="Koelbig:83a">[Koelbig:83a] K.&nbsp;S. K&ouml;lbig.</dt>
        <dd>On the integral &int;<sub>0</sub><sup>&infin;</sup>&nbsp;e<sup>-&mu; t</sup>&nbsp;t<sup>&nu;-1</sup>&nbsp;log<sup>m</sup>t&nbsp;dt. <em>Math. Comp.</em> <strong>41</strong>, pages 171-182, 1983.</dd>
        <dt id="Koelbig:84b">[Koelbig:84b] K.&nbsp;S. K&ouml;lbig.</dt>
        <dd><a href="http://doc.cern.ch//archive/electronic/other/generic/public/cer-000066111.pdf">Some problems involving special functions arising from physics at CERN</a>. Technical Report DD 84-14, CERN, Data Handling Division, September 1984.</dd>
        <dt id="Koelbig:85a">[Koelbig:85a] K.&nbsp;S. K&ouml;lbig.</dt>
        <dd><a href="http://dx.doi.org/10.1016/S0747-7171(85)80032-8">Explicit evaluation of certain definite integrals involving powers of logarithms</a>. <em>Journal of Symbolic Computation</em> <strong>1</strong> no. 1, pages 109-114, March 1985.</dd>
        <dt id="Koelbig:86">[Koelbig:86] K.&nbsp;S. K&ouml;lbig.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0377-0427(86)90070-1">On the integral &int;<sub>0</sub><sup>&infin;</sup>&nbsp;x<sup>&nu;-1</sup>&nbsp;(1+&beta; x)<sup>-&lambda;</sup>&nbsp;ln<sup>m</sup>x&nbsp;dx</a>. <em>Journal of Comp. and Appl. Math.</em> <strong>14</strong> no. 3, pages 319-344, March 1986.</dd>
        <dt id="Koelbig:85">[Koelbig:85] K.&nbsp;S. K&ouml;lbig.</dt>
        <dd><a href="http://documents.cern.ch/cgi-bin/setlink?base=generic&categ=public&id=cer-000074639">On the integral &int;<sub>0</sub><sup>1</sup>&nbsp;x<sup>&nu;-1</sup>&nbsp;(1-x)<sup>-&lambda;</sup>&nbsp;ln<sup>m</sup>x&nbsp;dx</a>. <em>Journal of Computational and Applied Mathematics</em> <strong>18</strong> no. 3, pages 369-394, June 1987.</dd>
        <dt id="Koelbig:82a">[Koelbig:82a] K.&nbsp;S. K&ouml;lbig and W.&nbsp;R&uuml;hl.</dt>
        <dd><a href="http://dx.doi.org/10.1007/BF01548610">Complex zeros of the partition function for two-dimensional U(N) lattice gauge theories</a>. <em>Zeitschrift für Physik C Particles and Fields</em> <strong>12</strong> no. 2, pages 135-143, 1982.</dd>
        <dt id="Koelbig:84">[Koelbig:84] K.&nbsp;S. K&ouml;lbig and B.&nbsp;Schorr.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0010-4655(84)90065-1">Asymptotic expansions for the Landau density and distribution function</a>. <em>Computer Physics Communications</em> <strong>32</strong> no. 2, pages 121-131, 1984.</dd>
        <dt id="Koelbig:84a">[Koelbig:84a] K.&nbsp;S. K&ouml;lbig and B.&nbsp;Schorr.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0010-4655(84)90085-7">A program package for the Landau distribution</a>. <em>Computer Physics Communications</em> <strong>31</strong> no. 1, pages 97-111, 1984.</dd>
        <dt id="Koelbig:81">[Koelbig:81] K.&nbsp;S. K&ouml;lbig and F.&nbsp;Schwarz.</dt>
        <dd><a href="http://dx.doi.org/10.1007/BF02277182">On positive function series</a>. <em>Computing</em> <strong>27</strong> no. 4, pages 319-337, December 1981.</dd>
        <dt id="Koornwinder:93">[Koornwinder:93] T.&nbsp;H. Koornwinder.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0377-0427(93)90317-5">On Zeilberger&apos;s algorithm and its q-analogue: a rigorous description</a>. <em>J. of Comput. and Appl. Math.</em> <strong>48</strong> no. 1-2, pages 91-111, October 1993.</dd>
        <dt id="Koerner:06">[Koerner:06] J.&nbsp;G. K&ouml;rner, Z.&nbsp;Merebashvili, and M.&nbsp;Rogal.</dt>
        <dd><a href="http://arxiv.org/abs/hep-ph/0608287">Next-to-next-to-leading order O(&alpha;<sup>2</sup> &alpha;<sub>S</sub><sup>2</sup>) results for top quark pair production in photon-photon collisions: The one-loop squared contributions</a>. <em>Physical Review D (Particles and Fields)</em> <strong>74</strong> no. 9, page 094006, 2006.</dd>
        <dt id="Koerner:06a">[Koerner:06a] J.&nbsp;G. K&ouml;rner, Z.&nbsp;Merebashvili, and M.&nbsp;Rogal.</dt>
        <dd><a href="http://arxiv.org/abs/hep-ph/0511264">One-loop amplitudes for four-point functions with two external massive quarks and two external massless partons up to O(&epsilon;<sup>2</sup>)</a>. <em>Physical Review D (Particles and Fields)</em> <strong>73</strong> no. 3, page 034030, 2006.</dd>
        <dt id="Kornyak:87">[Kornyak:87] V.&nbsp;V. Kornyak and R.&nbsp;N. Fedorova.</dt>
        <dd>A REDUCE program to calculate determining equations of Lie-Baecklund symmetries of differential equations. Technical Report P11-87-19, J.I.N.R., Dubna, 1987.</dd>
        <dt id="Kotorynski:86">[Kotorynski:86] W.&nbsp;P. Kotorynski.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0045-7930(86)90017-4">Steady laminar flow through a twisted pipe of elliptical cross-section</a>. <em>Computers and Fluids</em> <strong>14</strong> no. 4, pages 433-444, 1986.</dd>
        <dt id="Krack:82">[Krack:82] K.&nbsp;Krack.</dt>
        <dd>Rechnerunterst&uuml;tzte Entwicklung der Mittelbreitenformeln und absch&auml;tzung ihrer ellipsoidischen Anteile zur l&ouml;sung der zweiten geod&auml;tischen Hauptaufgabe auf dem Rotationsellipsoid. <em>Z. Vermessungswes.</em> <strong>107</strong>, pages 502-513, 1982.</dd>
        <dt id="Kraus:73">[Kraus:73] J.&nbsp;Kraus.</dt>
        <dd><em>Delbr&uuml;ckstreuung und Pr&uuml;fung der Quantenelektrodynamik</em>. PhD thesis, Ludwig-Maximilians-Universit&auml;t zu M&uuml;nchen, 1973.</dd>
        <dt id="Kredel:88">[Kredel:88] Heinz Kredel.</dt>
        <dd><a href="http://doi.acm.org/10.1145/43882.43887">Admissible termorderings used in computer algebra systems</a>. <em>SIGSAM Bulletin</em> <strong>22</strong> no. 1, pages 28-31, January 1988.</dd>
        <dt id="Krivonos:99">[Krivonos:99]</dt>
        <dd>Sergey Krivonos and Ziemowit Popowicz, <a href="http://www.springerlink.com/content/k5x7t0ht1246gg6m/?p=814f7059b37348f682dc28ade97ee89d&pi=23"><em>N=2 SUSY Two-Boson KP Hierarchy, (Derivative) NLS Equation and Miura Transformations</em></a>, <em>Lecture Notes in Physics</em> 524, pages 252-260. 1994.</dd>
        <dt id="Kruse:83">[Kruse:83] Hans-Guenther Kruse and Karin Ohlsen.</dt>
        <dd><a href="http://doi.acm.org/10.1145/1089320.1089324">About the realization of an extended, but really interactive REDUCE by integration of a small editing and executing system</a>. <em>SIGSAM Bulletin</em> <strong>17</strong> no. 1, pages 21-25, February 1983.</dd>
        <dt id="Kryukov:84">[Kryukov:84] A.&nbsp;P. Kryukov.</dt>
        <dd><a href="http://doi.acm.org/10.1145/1089389.1089393">An antitranslator of the RLISP language</a>. <em>SIGSAM Bulletin</em> <strong>18</strong> no. 3, pages 12-15, August 1984.</dd>
        <dt id="Kryukov:85">[Kryukov:85] A.&nbsp;P. Kryukov and A.&nbsp;Ya. Rodionov.</dt>
        <dd><a href="http://doi.acm.org/10.1145/1089402.1089409">Dynamic-debugging system for the REDUCE programs</a>. <em>SIGSAM Bulletin</em> <strong>19</strong> no. 2, pages 34-37, May 1985.</dd>
        <dt id="Kryukov:85a">[Kryukov:85a] A.&nbsp;P. Kryukov and A.&nbsp;Ya. Rodionov.</dt>
        <dd><a href="http://doi.acm.org/10.1145/1089411.1089416">Interactive REDUCE</a>. <em>SIGSAM Bulletin</em> <strong>19</strong> no. 3, pages 43-45, August 1985.</dd>
        <dt id="Kryukov:87a">[Kryukov:87a] A.&nbsp;P. Kryukov and A.&nbsp;Ya. Rodionov.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-51517-8_12">CTS - algebraic debugging system for REDUCE programs</a>. In: <em>Proc. EUROCAL &apos;87, Lecture Notes in Computer Science</em>, volume 378, pages 233-243. Springer-Verlag, 1987.</dd>
        <dt id="Kryukov:88a">[Kryukov:88a] A.&nbsp;P. Kryukov and A.&nbsp;Ya. Rodionov.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0010-4655(88)90052-5">Program &ldquo;COLOR&rdquo; for computing the group-theoretic weight of Feynman diagrams in Non-Abelian gauge theories</a>. <em>Computer Physics Communications</em> <strong>48</strong> no. 2, pages 327-334, February 1988.</dd>
        <dt id="Kryukov">[Kryukov] A.&nbsp;P. Kryukov and A.&nbsp;Ya. Rodionov.</dt>
        <dd>Usage of REDUCE for computations of group-theoretical weight of Feynman diagrams in non-abelian gauge theories. Technical report, Institute of Nuclear Physics, Moscow, USSR, TBD.</dd>
        <dt id="Kryukov:87">[Kryukov:87] A.&nbsp;P. Kryukov, A.&nbsp;Ya. Rodionov, and V.&nbsp;A. Rostovtsev.</dt>
        <dd>Pattern compilation in REDUCE. Technical Report P11-87-302, J.I.N.R., Dubna, 1987.</dd>
        <dt id="Kryukov:88">[Kryukov:88] A.&nbsp;P. Kryukov, A.&nbsp;Ya. Rodionov, and V.&nbsp;A. Rostovtsev.</dt>
        <dd>New programming tools for computing substitution rules in REDUCE system. Technical Report P11-88-402, J.I.N.R., Dubna, 1988.</dd>
        <dt id="Kryukov:91">[Kryukov:91] A.&nbsp;P. Kryukov, A.&nbsp;Ya. Rodionov, A.&nbsp;Yu. Taranov, and E.&nbsp;Shablygin.</dt>
        <dd><em>Programming in R-Lisp</em>. Radio and Connective Publishers, Moscow, 1991.</dd>
        <dt id="Kryukov:88b">[Kryukov:88b] A.&nbsp;P. Kryukov and D.&nbsp;A. Slavnov.</dt>
        <dd>The role of the gg &rarr; c<span style="text-decoration: overline;">c</span>g process in the cross section of production of charmed particles (in Russian). Preprint 88-49/70, Moscow State University, 1988.</dd>
        <dt id="Kuppers:71">[Kuppers:71] G.&nbsp;Kuppers, D.&nbsp;Pfirsch, and H.&nbsp;Tasso.</dt>
        <dd>M.H.D. - stability of axisymmetric plasmas. Report CN -28/F-14, Max-Planck-Institut fuer Plasmaphysik, 1971.</dd>
    </dl>

    <dl id='L'>
        <dt id="Lagos:04">[Lagos:04] Bernardo&nbsp;M. Lagos and Pedro&nbsp;A. Morettin.</dt>
        <dd><a href="http://dx.doi.org/10.1111/j.1467-9892.2004.00338.x">Improvement of the likelihood ratio test statistic in arma models</a>. <em>Journal of Time Series Analysis</em> <strong>25</strong> no. 1, pages 83-101, 2004.</dd>
        <dt id="Lambin:84">[Lambin:84] P.&nbsp;Lambin and J.&nbsp;P. Vigneron.</dt>
        <dd><a href="http://link.aps.org/doi/10.1103/PhysRevB.29.3430">Computation of crystal Green&apos;s functions in the complex-energy plane with the use of the analytical tetrahedron method</a>. <em>Phys. Rev. B</em> <strong>29</strong> no. 6, pages 3430-3437, 1984.</dd>
        <dt id="Lang:79">[Lang:79] C.&nbsp;B. Lang and W.&nbsp;Porod.</dt>
        <dd>Symmetry breaking and &pi; K amplitudes in the unphysical region. Report UNIGRAZ-UTP 08/79, Institut f&uuml;r Theor. Physik, Univ. Graz, 1979.</dd>
        <dt id="Laursen:79">[Laursen:79] M.&nbsp;L. Laursen and M.&nbsp;A. Samuel.</dt>
        <dd>The n-bubble diagram contribution to the g-2 of the electron - Mathematical structure of the analytical expression. Research Note&nbsp;96, Oklahoma State Univ. Quantum Theoretical Research Group, 1979.</dd>
        <dt id="Laursen:81">[Laursen:81] M.&nbsp;L. Laursen and M.&nbsp;A. Samuel.</dt>
        <dd><a href="http://link.aip.org/link/?JMAPAQ/22/1114/1">The n-bubble diagram contribution to g-2</a>. <em>Journal of Mathematical Physics</em> <strong>22</strong>, pages 1114-1126, 1981.</dd>
        <dt id="Laursen:80">[Laursen:80] Morten&nbsp;L. Laursen and Mark&nbsp;A. Samuel.</dt>
        <dd>Borel transform technique and the n-Bubble diagram contribution to the lepton anomaly. Research Note&nbsp;10, Oklahoma State Univ. Quantum Theoretical Research Group, August 1980.</dd>
        <dt id="Lecourtier:85">[Lecourtier:85] Y.&nbsp;Lecourtier and A.&nbsp;Raksanyi.</dt>
        <dd>Algebraic manipulation routines for testing structural properties. <em>IFAC Identification and System Parameter Estimation</em> pages 543-549, 1985.</dd>
        <dt id="Lee:85">[Lee:85] H-C Lee and M.&nbsp;S. Milgram.</dt>
        <dd><a href="http://link.aip.org/link/?JMAPAQ/26/1793/1">On the axial gauge: Ward identities and the separation of infrared and ultraviolet singularities by analytical regularization</a>. <em>Journal of Mathematical Physics</em> <strong>26</strong>, pages 1793-1804, 1985.</dd>
        <dt id="Leler:85">[Leler:85] Wm&nbsp;Leler and Neil Soiffer.</dt>
        <dd><a href="http://doi.acm.org/10.1145/1089411.1089414">An interactive graphical interface for REDUCE</a>. <em>SIGSAM Bulletin</em> <strong>19</strong> no. 3, pages 17-23, August 1985.</dd>
        <dt id="Lepage:83">[Lepage:83] G.&nbsp;P. Lepage, P.&nbsp;B. Mackenzie, K.&nbsp;H. Streng, and P.&nbsp;M. Zernas.</dt>
        <dd><a href="http://link.aps.org/doi/10.1103/PhysRevA.28.3090">Multiphoton decays of positronium</a>. <em>Phys. Rev. A</em> <strong>28</strong> no. 5, pages 3090-3091, 1983.</dd>
        <dt id="Levi:70">[Levi:70] I.&nbsp;Levi and N.&nbsp;Hoff.</dt>
        <dd>Non-symmetric creep buckling of circular cylindrical shells in axial compression. In: <em>Proc. Intern. Symp. in Creep Effect in Structures, Gotenburg, Sweden</em>, August 1970.</dd>
        <dt id="Levi:71">[Levi:71] I.&nbsp;M. Levi.</dt>
        <dd>Symbolic algebra by computer - applications to structural mechanics. In: <em>AIAA/ASME 12th Structures, Structural Dynamics and Materials Conference, Anaheim, California</em>, April 1971.</dd>
        <dt id="Lichard:07">[Lichard:07] Peter Lichard and Josef Jur&aacute;&ncaron;.</dt>
        <dd><a href="http://arxiv.org/pdf/hep-ph/0601234v2">Electron-positron annihilation into four charged pions and the a<sub>1</sub> &rho; &pi; lagrangian</a>. <em>Physical Review D (Particles and Fields)</em> <strong>76</strong> no. 9, page 094030, 2007.</dd>
        <dt id="Liebermann:75">[Liebermann:75] R.&nbsp;Liebermann.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0021-9991(78)90152-3">Traces of high energy processes in strong magnetic fields</a>. <em>Journal of Computational Physics</em> <strong>29</strong> no. 2, November 1975.</dd>
        <dt id="Limpouch:94">[Limpouch:94] J.&nbsp;Limpouch, L.&nbsp;Drska, and R.&nbsp;Liska.</dt>
        <dd>Fokker-Planck Simulations of Interactions of Femtosecond Laser Pulses with Dense Plasmas. <em>Laser and Particle Beams</em> <strong>12</strong>, pages 101-110, 1994.</dd>
        <dt id="Liska:84">[Liska:84] R.&nbsp;Liska.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0010-4655(84)90169-3">Program for stability and accuracy analysis of finite difference methods</a>. <em>Computer Physics Communications</em> <strong>34</strong> no. 1-2, pages 175-186, 1984.</dd>
        <dt id="Liska:91a">[Liska:91a] R.&nbsp;Liska.</dt>
        <dd>Automation of Numerical Solution of PDE Systems. In: D.V. Shirkov, V.A. Rostovtsev, and V.P. Gerdt, editors, <em>IV. International Conference on Computer Algebra in Physical Research, Dubna, May 22-26, 1990</em>, pages 357-361, Singapore, 1991. World Scientific.</dd>
        <dt id="Liska:91b">[Liska:91b] R.&nbsp;Liska.</dt>
        <dd>Numerical code generation for finite difference schemes solving. In: R.&nbsp;Vichnevetsky and J.J.H. Miller, editors, <em>IMACS&apos;91 13th World Congress on Computation and Applied Mathematics, July 22-26, 1991</em>, pages 92-93, Dublin, 1991. IMACS.</dd>
        <dt id="Liska:92">[Liska:92] R.&nbsp;Liska.</dt>
        <dd>Computer algebra in simulation code development. In: E.&nbsp;Kant, editor, <em>Intelligent Scientific Computation, AAAI Fall Symposium Series, Cambridge, Massachusetts October 23-25, 1992</em>, pages 74-79, Menlo Park, CA, 1992. AAAI.</dd>
        <dt id="Liska:91c">[Liska:91c] R.&nbsp;Liska.</dt>
        <dd>Numerical code generation for finite difference schemes solving. In: C.&nbsp;Brezinski and U.&nbsp;Kulisch, editors, <em>Computational and Applied Mathematics I - Algorithms and Theory</em>, pages 295-303, Amsterdam, 1992. Elsevier, IMACS. Selected and revised papers from the 13th IMACS World Congress, Dublin, Ireland, July 1991.</dd>
        <dt id="Liska:87">[Liska:87] R.&nbsp;Liska and D.&nbsp;Drska.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-51517-8_110">Evaluation of plasma fluid equations collision integrals using REDUCE</a>. In: <em>Proc. EUROCAL &apos;87, Lecture Notes in Computer Science</em>, volume 378, page 178. Springer-Verlag, 1987.</dd>
        <dt id="Liska:90">[Liska:90] R.&nbsp;Liska and L.&nbsp;Drska.</dt>
        <dd><a href="http://doi.acm.org/10.1145/96877.96920">FIDE: A REDUCE package for automation of FInite difference method for solving pDE</a>. In: S.&nbsp;Watanabe and Morio Nagata, editors, <em>Proceedings of the 1990 International Symposium on Symbolic and Algebraic Computation</em>, pages 169-176. ACM, Addison-Wesley, 1990.</dd>
        <dt id="Liska:95">[Liska:95] R.&nbsp;Liska, L.&nbsp;Margolin, and B.&nbsp;Wendroff.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0898-1221(95)00035-W">Nonhydrostatic two-layer models of incompressible flow</a>. <em>Computers and Math. with Applic.</em> <strong>29</strong> no. 9, pages 25-37, May 1995.</dd>
        <dt id="Liska:04">[Liska:04] R.&nbsp;Liska, M.&nbsp;Shashkov, and V.&nbsp;Ganzha.</dt>
        <dd><a href="http://dx.doi.org/10.1016/j.matcom.2004.05.008">Analysis and optimization of inner products for mimetic finite difference methods on triangular grid</a>. <em>Math. Comp. Simul.</em> <strong>67</strong> no. 1-2, pages 55-66, September 2004.</dd>
        <dt id="Liska:93">[Liska:93] R.&nbsp;Liska, M.&nbsp;Yu. Shashkov, and A.V. Solovjov.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0378-4754(93)90012-J">Support-operators Method for PDE Discretization: Symbolic Algorithms and Realization</a>. <em>Math. Comp. Simul., IMACS</em> <strong>35</strong> no. 2, pages 173-183, April 1993.</dd>
        <dt id="Liska:93a">[Liska:93a] R.&nbsp;Liska and S.&nbsp;Steinberg.</dt>
        <dd><a href="http://dx.doi.org/doi:10.1093/comjnl/36.5.497">Applying quantifier elimination to stability analysis of difference schemes</a>. <em>The Computer Journal</em> <strong>36</strong> no. 5, pages 497-503, 1993. Special issue on quantifier elimination.</dd>
        <dt id="Liska:97">[Liska:97] R.&nbsp;Liska and B.&nbsp;Wendroff.</dt>
        <dd><a href="http://dx.doi.org/10.1006/jcph.1997.5806">Analysis and computation with stratified fluid models</a>. <em>Journal of Computational Physics</em> <strong>137</strong> no. 1, pages 212-244, October 1997.</dd>
        <dt id="Liska:97a">[Liska:97a] R.&nbsp;Liska and B.&nbsp;Wendroff.</dt>
        <dd>Composite schemes for conservation laws. In: <em>Workshop 97, Part I</em>, pages 31-32, Prague, 1997. Czech Technical University.</dd>
        <dt id="Liska:98">[Liska:98] R.&nbsp;Liska and B.&nbsp;Wendroff.</dt>
        <dd><a href="http://dx.doi.org/10.1137/S0036142996310976">Composite schemes for conservation laws</a>. <em>SIAM J. Numer. Anal.</em> <strong>35</strong>
            no. 6, pages 2250-2271, December 1998.</dd>
        <dt id="Liska:99">[Liska:99] R.&nbsp;Liska and B.&nbsp;Wendroff.</dt>
        <dd>Where numerics can benefit from computer algebra in finite difference modelling of fluid flows. In: V.&nbsp;Ganzha, E.W. Mayr, and E.V. Vorozhtsov, editors, <em>Computer Algebra in Scientific Computing, CASC-99</em>, pages 268-286, Berlin, Heidelberg, 1999. Springer-Verlag. Proceedings of the Second Workshop on Computer Algebra in Scientific Computing, Munich, May 31-June 4, 1999.</dd>
        <dt id="Liska:91">[Liska:91] Richard Liska and Michail&nbsp;Yu. Shashkov.</dt>
        <dd><a href="http://doi.acm.org/10.1145/120694.120759">Algorithms for difference schemes construction on non-orthogonal logically rectangular meshes</a>. In: Stephen&nbsp;M. Watt, editor, <em>Proc. of the 1991 International Symposium on Symbolic and Algebraic Computation</em>, pages 419-426, Maryland, 1991. ACM Press.</dd>
        <dt id="Lloyd:90">[Lloyd:90] N.&nbsp;G. Lloyd and J.&nbsp;M. Pearson.</dt>
        <dd><a href="http://dx.doi.org/10.1016/S0747-7171(08)80031-4">REDUCE and the bifurcation of limit cycles</a>. <em>Journal of Symbolic Computation</em> <strong>9</strong> no. 2, pages 215-224, February 1990.</dd>
        <dt id="Loe:85">[Loe:85] Kia&nbsp;Fock Loe, Noritaka Ohsawa, and Eiichi Goto.</dt>
        <dd>Circuit simulation code generation by computer algebra. In: <em>Proc. of the Second RIKEN International Symposium on Symbolic and Algebraic Computation by Computers</em>, pages 87-103, Singapore, 1985. World Scientific.</dd>
        <dt id="London:74">[London:74] R.&nbsp;London and D.&nbsp;R. Musser.</dt>
        <dd>The application of a symbolic mathematical system to program verification. In: <em>Proc. ACM 74</em>, pages 265-273, 1974.</dd>
        <dt id="Loos:72">[Loos:72] R&uuml;diger Loos.</dt>
        <dd><a href="http://doi.acm.org/10.1145/1086784.1086787">Analytic treatment of three similar Fredholm integral equations of the second kind with reduce 2</a>. <em>SIGSAM Bulletin</em> no. 21, pages 32-40, 1972.</dd>
        <dt id="Lottati">[Lottati] Itzhak Lottati and Isaac Elishakoff.</dt>
        <dd>Refined dynamical theories of beams, plates and shells and their applications. In: <em>Proc. Euromech-Colloquium 219</em>.</dd>
        <dt id="Louw:86">[Louw:86] J.&nbsp;A. Louw, F.&nbsp;Schwarz, and W.&nbsp;H. Steeb.</dt>
        <dd><a href="http://dx.doi.org/10.1088/0305-4470/19/10/002">First integrals and Yoshida analysis of Nahm&apos;s equation</a>. <em>J. Phys. A: Math. Gen.</em> <strong>19</strong> no. 10, pages L569-L573, 1986.</dd>
        <dt id="Luegger:73">[Luegger:73] J.&nbsp;Luegger and H.&nbsp;Melenk.</dt>
        <dd>Darstellung und Bearbeitung umfangreicher LISP-Programme. <em>Angewandte Informatik</em> pages 257-263, June 1973.</dd>
        <dt id="Luegger:91">[Luegger:91] Joachim L&uuml;gger and Wolfgang Dalitz.</dt>
        <dd>Verteilung mathematischer Software mittels elektronischer Netze: Die elektronische Softwarebibliothek eLib. Preprint TR 91-2, Konrad-Zuse-Zentrum f&uuml;r Informationstechnik Berlin, February 1991.</dd>
        <dt id="Lukacs">[Lukacs] B.&nbsp;Luk&aacute;cs, Z.&nbsp;Perj&eacute;s, A.&nbsp;Sebesty&eacute;n, and A.&nbsp;Valentini.</dt>
        <dd>Stationary vacuum fields with a conformally flat three-space, ii. proof of axial symmetry. Technical Report KFKI-1982-19, Central Research Institute for Physics, Budapest, Hungary, 1982.</dd>
        <dt id="Lukaszuk:87">[Lukaszuk:87] L.&nbsp;L&uacute;kaszuk, D.&nbsp;M. Siemienczuk, and L.&nbsp;Szymanowski.</dt>
        <dd><a href="http://link.aps.org/doi/10.1103/PhysRevD.35.326">Evaluation of helicity amplitudes</a>. <em>Physical Review D (Particles and Fields)</em> <strong>35</strong> no. 1, pages 326-329, 1987.</dd>
        <dt id="Lux:75">[Lux:75] Augustin Lux.</dt>
        <dd><em>Etude d&apos;un Modele Abstrait pour une Machine LISP et de son Implantation</em>. PhD thesis, Universit&eacute; Scientifique et Medicale de Grenoble, March 1975.</dd>
    </dl>

    <dl id='M'>
        <dt id="MacCallum:86a">[MacCallum:86a] M.&nbsp;A.&nbsp;H. MacCallum.</dt>
        <dd>Algebraic computing in relativity. Technical Report TAU 86-04, Queen Mary College, University of London, 1986.</dd>
        <dt id="MacCallum:86">[MacCallum:86] M.&nbsp;A.&nbsp;H. MacCallum.</dt>
        <dd>Algebraic computing in relativity; proceedings of the workshop on dynamical spacetimes and numerical relativity held at drexel university on october 7-11, 1985. In: Joan&nbsp;M. Centrella, editor, <em>Dynamical Spacetimes and Numerical Relativity</em>, pages 411-445. Cambridge University Press, 1986.</dd>
        <dt id="MacCallum:87">[MacCallum:87] M.&nbsp;A.&nbsp;H. MacCallum.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-51517-8_83">Symbolic computation in relativity theory</a>. In: <em>Proc. EUROCAL &apos;87, Lecture Notes in Computer Science</em>, volume 378, pages 34-43. Springer-Verlag, 1987.</dd>
        <dt id="MacCallum:88">[MacCallum:88] M.&nbsp;A.&nbsp;H. MacCallum.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-51084-2_18">An ordinary differential equation solver for REDUCE</a>. In: <em>Proc. of ISSAC &apos;88</em>, volume 358, pages 196-205. Springer-Verlag, 1988.</dd>
        <dt id="MacCallum:92">[MacCallum:92] M.&nbsp;A.&nbsp;H. MacCallum and S.&nbsp;T.&nbsp;C. Siklos.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0393-0440(92)90050-B">Algebraically special hypersurface-homogeneous Einstein spaces in general relativity</a>. <em>Journal of Geometry and Physics</em> <strong>8</strong> no. 1-4, pages 221-242, March 1992.</dd>
        <dt id="MacCallum:91">[MacCallum:91] Malcolm MacCallum and Francis Wright.</dt>
        <dd><em><a href="https://global.oup.com/academic/product/algebraic-computing-with-reduce-9780198534433?lang=en&amp;cc=se">Algebraic Computing with REDUCE</a></em>. Oxford University Press, 1991.</dd>
        <dt id="MacCallum:89">[MacCallum:89] Malcolm A.&nbsp;H. MacCallum.</dt>
        <dd><a href="http://doi.acm.org/10.1145/70936.70939">Comments on the performance of algebra systems in general relativity and a recent paper by Nielsen and Pedersen</a>. <em>SIGSAM Bulletin</em> <strong>23</strong> no. 2, pages 22-25, April 1989.</dd>
        <dt id="MacDonald:94">[MacDonald:94] N.&nbsp;MacDonald.</dt>
        <dd><em>REDUCE for Physics</em>. Institute of Physics Publishing, Bristol, England, March 1994. ISBN 0 7503 0277 1.</dd>
        <dt id="Mack:73">[Mack:73] D.&nbsp;Mack.</dt>
        <dd><em>Nichtnumerische Verfahren und deren Anwendung in der Elementarteilchen-Physik</em>. PhD thesis, University of Tuebingen, 1973.</dd>
        <dt id="Mack:73a">[Mack:73a] D.&nbsp;Mack and H.&nbsp;Mitter.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0375-9601(73)90965-1">Calculation of electron-electron-bremsstrahlung cross-sections</a>. <em>Physics Letters A</em> <strong>44</strong> no. 1, pages 71-72, 1973.</dd>
        <dt id="MacKenzie:00">[MacKenzie:00] T.&nbsp;MacKenzie and A.&nbsp;J. Roberts.</dt>
        <dd><a href="http://anziamj.austms.org.au/V42/CTAC99/Mack">Holistic finite differences accurately model the dynamics of the Kuramoto-Sivashinsky equation</a>. In: David&nbsp;Harrar II and Thanh Tran, editors, <em>Proceedings of the 1999 International conference on Computational Techniques and Applications</em>, volume&nbsp;42, pages C918-C935, 2000.</dd>
        <dt id="MacKenzie:03">[MacKenzie:03] T.&nbsp;MacKenzie and A.&nbsp;J. Roberts.</dt>
        <dd><a href="http://anziamj.austms.org.au/V44/CTAC2001/Mack">Holistic discretisation of shear dispersion in a two-dimensional channel</a>. In: K.&nbsp;Burrage and Roger&nbsp;B. Sidje, editors, <em>Proc. of 10th Computational Techniques and Applications Conference CTAC-2001</em>, volume&nbsp;44, pages C512-C530, April 2003.</dd>
        <dt id="Maclaren:89">[Maclaren:89] N.&nbsp;M. MacLaren.</dt>
        <dd>The generation of sequences of multiple independent sequences of pseudorandom numbers. <em>Applied Statistics JRSS Series C</em> <strong>38</strong>, pages 351-359, 1989.</dd>
        <dt id="Maguire:81">[Maguire:81]</dt>
        <dd>Gerald&nbsp;Quentin Maguire Jr., Program transformation in REDUCE using rule sequencing. Master&apos;s thesis, Department of Computer Science, The University of Utah, March 1981.</dd>
        <dt id="Makinde:07">[Makinde:07] O.D. Makinde, R.J. Moitsheki, and B.A. Tau.</dt>
        <dd><a href="http://dx.doi.org/10.1016/j.amc.2006.10.082">Similarity reductions of equations for river pollution</a>. <em>Applied Mathematics and Computation</em> <strong>188</strong> no. 2, pages 1267-1273, May 2007.</dd>
        <dt id="Malm:82">[Malm:82] Bengt Malm.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-11607-9_34">A program in REDUCE for finding explicit solutions to certain ordinary differential equations</a>. In: <em>Proc. EUROCAM 1982</em>, <em>Lecture Notes in Computer Science</em> 144, pages 289-293. Springer-Verlag, 1982.</dd>
        <dt id="Man:93a">[Man:93a] Yiu-Kwong Man.</dt>
        <dd><a href="http://dx.doi.org/10.1006/jsco.1993.1057">Computing closed form solutions of first order ODEs using the Prelle-Singer procedure</a>. <em>Journal of Symbolic Computation</em> <strong>16</strong> no. 5, pages 423 - 443, November 1993.</dd>
        <dt id="Man:93">[Man:93] Yiu-Kwong Man.</dt>
        <dd><a href="http://dx.doi.org/10.1006/jsco.1993.1053">On computing closed forms for indefinite summations</a>. <em>Journal of Symbolic Computation</em>
            <strong>16</strong> no. 4, pages 355 - 376, October 1993.</dd>
        <dt id="Man:94">[Man:94] Yiu-Kwong Man and Francis&nbsp;J. Wright.</dt>
        <dd><a href="http://doi.acm.org/10.1145/190347.190413">Fast polynomial dispersion computation and its application to indefinite summation</a>. In: <em>Symbolic and Algebraic Computation</em>, ISSAC, pages 175-180. SIGSAM, ACM, 1994.</dd>
        <dt id="Marchant:90">[Marchant:90] T.R. Marchant and A.J. Roberts.</dt>
        <dd><a href="http://anziamj.austms.org.au/V32/part1/Marchant.html">Reflection of nonlinear deep-water waves incident onto a wedge of arbitrary angle</a>. <em>J. Austral. Math. Soc. B</em> <strong>32</strong>, pages 61-96, 1990.</dd>
        <dt id="Mars:97">[Mars:97] M.&nbsp;Mars and T.&nbsp;Wolf.</dt>
        <dd>Diagonal and non-diagonal g<sub>2</sub> perfect fluid cosmologies with a proper conformal killing vector. <em>Classical and Quantum Gravity</em> <strong>14</strong>, pages 1-28, 1997.</dd>
        <dt id="Mars:97b">[Mars:97b] M.&nbsp;Mars and T.&nbsp;Wolf.</dt>
        <dd><a href="http://dx.doi.org/10.1088/0264-9381/14/8/026">g<sub>2</sub> perfect fluid cosmologies with a proper conformal killing vector</a>. <em>Classical and Quantum Gravity</em> <strong>14</strong> no. 14, pages 2303-2330, 1997.</dd>
        <dt id="Mars:97a">[Mars:97a] M.&nbsp;Mars and T.&nbsp;Wolf.</dt>
        <dd><a href="http://dx.doi.org/10.1088/0264-9381/14/1/019">Non-diagonal g<sub>2</sub> separable perfect fluid spacetimes</a>. <em>Classical and Quantum Gravity</em> <strong>14</strong>, pages 205-226, 1997.</dd>
        <dt id="Marti:88">[Marti:88] J.&nbsp;Marti.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-51083-4_66">A graphics interface to REDUCE</a>. In: <em>Proc. AAECC-6 1988, Lecture Notes in Computer Science</em>, volume 357, pages 274-296. Springer-Verlag, 1988.</dd>
        <dt id="Marti:80">[Marti:80] J.&nbsp;Marti, A.&nbsp;C. Hearn, M.&nbsp;L. Griss, and C.&nbsp;Griss.</dt>
        <dd><a href="http://doi.acm.org/10.1145/1089212.1089218">Standard Lisp report</a>. <em>SIGSAM Bulletin</em> <strong>14</strong> no. 1, pages 23-41, February 1980.</dd>
        <dt id="Marti:79">[Marti:79] J.&nbsp;B. Marti, A.&nbsp;C. Hearn, M.&nbsp;L. Griss, and C.&nbsp;Griss.</dt>
        <dd><a href="http://doi.acm.org/10.1145/953997.953999">Standard Lisp Report</a>. <em>SIGPLAN Notices</em> <strong>14</strong> no. 10, pages 48-68, 1979.</dd>
        <dt id="Marti:78">[Marti:78] Jed Marti.</dt>
        <dd><a href="http://doi.acm.org/10.1145/987508.987512">The META/REDUCE translator writing system</a>. <em>SIGPLAN Notices</em> <strong>13</strong> no. 10, pages 42-49, October 1978.</dd>
        <dt id="Marti:93a">[Marti:93a] Jed Marti.</dt>
        <dd><a href="http://www.worldscibooks.com/compsci/2097.html"><em>RLISP &apos;88 An Evolutionary Approach to Program Design and Reuse</em></a>, <em>World Scientific Series in Computer Science</em>&nbsp;42. World Scientific, Singapore, 1993.</dd>
        <dt id="Marti:83">[Marti:83] Jed Marti and John Fitch.</dt>
        <dd><a href="http://doi.acm.org/10.1145/1089320.1089325">REDUCE 2 for CP/M</a>. <em>SIGSAM Bulletin</em> <strong>17</strong> no. 1, pages 26-27, February 1983.</dd>
        <dt id="Marti:85a">[Marti:85a] Jed&nbsp;B. Marti.</dt>
        <dd>The role of explanation in symbolic computation. In: <em>Proc. of the Second RIKEN International Symposium on Symbolic and Algebraic Computation by Computers</em>, pages 13-34, Singapore, 1985. World Scientific.</dd>
        <dt id="Marti:85">[Marti:85] Jed&nbsp;B. Marti and Anthony&nbsp;C. Hearn.</dt>
        <dd><a href="http://doi.acm.org/10.1145/1089411.1089413">REDUCE as a LISP benchmark</a>. <em>SIGSAM Bulletin</em> <strong>19</strong> no. 3, pages 8-16, August 1985.</dd>
        <dt id="Marzinkewitsch:91">[Marzinkewitsch:91] Reiner Marzinkewitsch.</dt>
        <dd><a href="http://doi.acm.org/10.1145/120694.120757">Operating computer algebra systems by handprinted input</a>. In: Stephen&nbsp;M. Watt, editor, <em>Proc. of the 1991 International Symposium on Symbolic and Algebraic Computation</em>, pages 411-413, Maryland, 1991. ACM Press.</dd>
        <dt id="Matveev:87">[Matveev:87] V.&nbsp;A. Matveev, Ya.&nbsp;Z. Darbaidze, Z.&nbsp;V. Merebashvili, and L.&nbsp;A. Slepchenko.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0370-2693(87)91342-6">Gluon fusion in SUSY QCD</a>. <em>Physics Letters B</em> <strong>191</strong> no. 1-2, pages 179-181, June 1987.</dd>
        <dt id="Maurer:86">[Maurer:86] M.&nbsp;Maurer, A.&nbsp;Hayd, and H.&nbsp;J. Kaeppeler.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0021-9991(86)90058-6">Quasi-analytical method for solving nonlinear differential equations for turbulent self-confined magneto-plasma</a>. <em>Journal of Computational Physics</em> <strong>66</strong> no. 1, pages 151-172, September 1986.</dd>
        <dt id="Mazepa:85">[Mazepa:85] N.&nbsp;E. Mazepa and S.&nbsp;I. Serdyukova.</dt>
        <dd>The stability investigation of some difference boundary problem with the application of symbolic computation system. Technical Report E5-85-39, J.I.N.R., Dubna, 1985.</dd>
        <dt id="Mazzarella:85">[Mazzarella:85] Giuseppe Mazzarella.</dt>
        <dd><a href="http://doi.acm.org/10.1145/1089402.1089407">Improved simplification of odd and even functions in REDUCE</a>. <em>SIGSAM Bulletin</em> <strong>19</strong> no. 2, pages 29-30, May 1985.</dd>
        <dt id="McCrea:81">[McCrea:81] J.&nbsp;D. McCrea.</dt>
        <dd><a href="http://dx.doi.org/10.1088/0305-4470/14/6/013">The Petrov type of a static vacuum spacetime near a normal-dominated singularity</a>. <em>J. Phys. A: Math. Gen.</em> <strong>14</strong> no. 6, pages 1351-1356, 1981.</dd>
        <dt id="McCrea:82">[McCrea:82] J.&nbsp;D. McCrea.</dt>
        <dd><a href="http://dx.doi.org/10.1088/0305-4470/16/5/018">A stationary cylindrically symmetric electrovac spacetime</a>. <em>J. Phys. A: Math. Gen.</em> <strong>15</strong> no. 5, pages 1587-1590, 1982.</dd>
        <dt id="McCrea:83">[McCrea:83] J.&nbsp;D. McCrea.</dt>
        <dd><a href="http://dx.doi.org/10.1088/0305-4470/15/5/019">Static, vacuum, cylindrical and plane symmetric solutions of the quadratic Poincar&eacute; gauge field equations</a>. <em>J. Phys. A: Math. Gen.</em> <strong>16</strong> no. 5, pages 997-1004, 1983.</dd>
        <dt id="McCrea:84">[McCrea:84] J.&nbsp;D. McCrea.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0375-9601(84)90628-5">A NUT-like solution of the quadratic-Poincar&eacute; gauge field equations</a>. <em>Physics Letters A</em> <strong>100</strong> no. 8, pages 397-399, 1984.</dd>
        <dt id="McCrea:84a">[McCrea:84a] J.&nbsp;D. McCrea.</dt>
        <dd>The use of REDUCE in finding exact solutions of the quadratic Poincar&eacute; gauge field equations. In: <em>Classical General Relativity</em>, pages 173-182. Cambridge University, 1984.</dd>
        <dt id="McCrea:87">[McCrea:87] J.&nbsp;D. McCrea.</dt>
        <dd><a href="http://www.springer.com/math/geometry/book/978-3-540-17816-3">Poincar&eacute; gauge theory of gravitation: Foundations, exact solutions and computer algebra</a>. In: <em>Differential Geometric Methods in Mathematical Physics, Proc. 14th International Conference, Salamanca, 1985</em>, <em>Lecture Notes in Mathematics</em> 1251, page&nbsp;16. Springer-Verlag, 1987.</dd>
        <dt id="McCrea:87a">[McCrea:87a] J.&nbsp;D. McCrea, P.&nbsp;Baekler, and M.&nbsp;Guerses.</dt>
        <dd><a href="http://dx.doi.org/10.1007/BF02726580">A Kerr-like solution of the Poincar&eacute; gauge field equations</a>. <em>Il Nuovo Cimento B</em> <strong>99</strong>
            no. 2, pages 171-177, June 1987.</dd>
        <dt id="McCrea:88">[McCrea:88] J.&nbsp;D. McCrea, E.&nbsp;W. Mielke, and F.&nbsp;W. Hehl.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0375-9601(88)90383-0">A remark on the axisymmetric Chen et al. solution of the Poincar&eacute; gauge theory</a>. <em>Physics Letters A</em> <strong>127</strong> no. 2, pages 65-69, 1988.</dd>
        <dt id="McIsaac:85">[McIsaac:85] Kevin McIsaac.</dt>
        <dd><a href="http://doi.acm.org/10.1145/1089402.1089403">Pattern matching algebraic identities</a>. <em>SIGSAM Bulletin</em> <strong>19</strong> no. 2, pages 4-13, May 1985.</dd>
        <dt id="Mei:03">[Mei:03] Z.&nbsp;Mei, A.&nbsp;J. Roberts, and Zhenquan Li.</dt>
        <dd><a href="http://eprints.usq.edu.au/2987/1/Mei_Roberts_Li_SECTIONwaiting_file_to_upload_(Journal_article).pdf">Modelling the dynamics of turbulent floods</a>. <em>SIAM J. Appl. Math.</em> <strong>63</strong> no. 2, pages 423-458, 2003.</dd>
        <dt id="Mei:94">[Mei:94] Z.&nbsp;Mei and A.J. Roberts.</dt>
        <dd>Equations for turbulent flood waves. In: A.&nbsp;Mielke and K.&nbsp;Kirchg&auml;ssner, editors, <em>Structure and dynamics of nonlinear waves in fluids</em>, pages 342-352. World Sci, 1995.</dd>
        <dt id="Meikle:08">[Meikle:08]</dt>
        <dd>Laura Meikle and Jacques Fleuriot, <a href="http://dx.doi.org/10.1007/978-3-540-85110-3_27"><em>Intelligent Computer Mathematics</em></a>, <em>Lecture Notes in Computer Science</em> 5144, chapter Combining Isabelle and QEPCAD-B in the Prover&apos;s Palette, pages 315-330. Springer, 2008.</dd>
        <dt id="Melenk:90">[Melenk:90] H.&nbsp;Melenk.</dt>
        <dd>Solving polynomial equation systems by Groebner type methods. <em>CWI Quarterly</em> <strong>3</strong> no. 2, pages 121-136, June 1990.</dd>
        <dt id="Melenk:91">[Melenk:91] H.&nbsp;Melenk.</dt>
        <dd>Practical application of Gr&ouml;bner bases for the solution of polynomial equation systems. In: V.&nbsp;P.&nbsp;Gerdt D.&nbsp;V.&nbsp;Shirkov, V. A.&nbsp;Tostovtsev, editor, <em>IV. International Conference on Computer Algebra in Physical Research, 1990</em>, pages 230-235, Singapore, 1991. World Scientific.</dd>
        <dt id="Melenk:93a">[Melenk:93a] H.&nbsp;Melenk.</dt>
        <dd>Automatic symbolic solution of nonlinear equation systems in REDUCE. In: G.&nbsp;Jacob, N.&nbsp;E. Oussous, and S.&nbsp;Steinberg, editors, <em>Proceedings of the 1993 International IMACS Symposium on Symbolic Computation</em>, pages 175-180. IMACS, Laboratoire d&apos;Informatique Fondamentale de Lille, France, 1993.</dd>
        <dt id="Melenk:88">[Melenk:88] H.&nbsp;Melenk, H.&nbsp;M. M&ouml;ller, and W.&nbsp;Neun.</dt>
        <dd>On Gr&ouml;bner bases computation on a supercomputer using REDUCE. Preprint SC 88-2, Konrad-Zuse-Zentrum f&uuml;r Informationstechnik Berlin, January 1988.</dd>
        <dt id="Melenk:89">[Melenk:89] H.&nbsp;Melenk, H.&nbsp;M. M&ouml;ller, and W.&nbsp;Neun.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0899-8248(89)90027-X">Symbolic solution of large stationary chemical kinetics problems</a>. <em>Impact of Computing in Science and Engineering</em> <strong>1</strong> no. 2, pages 138-167, June 1989.</dd>
        <dt id="Melenk:93">[Melenk:93] Herbert Melenk.</dt>
        <dd>Algebraic solution of nonlinear equation systems in REDUCE. Preprint TR 93-2, Konrad-Zuse-Zentrum f&uuml;r Informationstechnik Berlin, January 1993.</dd>
        <dt id="Melenk:94">[Melenk:94] Herbert Melenk.</dt>
        <dd>The complexity barrier in REDUCE a case study. Preprint TR 94-6, Konrad-Zuse-Zentrum f&uuml;r Informationstechnik Berlin, January 1994.</dd>
        <dt id="Melenk:89a">[Melenk:89a] Herbert Melenk and Winfried Neun.</dt>
        <dd>Implementation of Portable Standard LISP for the SPARC processor. Preprint SC 89-6, Konrad-Zuse-Zentrum f&uuml;r Informationstechnik Berlin, July 1989.</dd>
        <dt id="Melenk:89b">[Melenk:89b] Herbert Melenk and Winfried Neun.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0307-904X(90)90179-9">Parallel polynomial operations in the large Buchberger algorithm</a>. In: J.&nbsp;Della Dora and J.&nbsp;Fitch, editors, <em>Computer Algebra and Parallelism</em>, pages 143-158. Academic Press, London, 1989.</dd>
        <dt id="Melfo:92">[Melfo:92] A.&nbsp;Melfo and L.&nbsp;A. N&uacute;&ntilde;ez.</dt>
        <dd><a href="http://dx.doi.org/10.1007/BF00756988">Checking collineation vectors with REDUCE</a>. <em>General Relativity and Gravitation</em> <strong>24</strong> no. 11, pages 1125-1129, November 1992. A package of programs for writing and checking the solutions to the equations for various types of collineations (symmetries of the metric, christoffel, riemman and ricci tensors) is presented. Some examples of previously found collineations that have been checked are given, and new results reported.</dd>
        <dt id="Melnik:99b">[Melnik:99b] R.&nbsp;V.&nbsp;N. Melnik, A.&nbsp;J. Roberts, and K.&nbsp;A.Thomas.</dt>
        <dd>Dynamics of shape-memory-alloys: A reduction procedure for 3d models. In: W.&nbsp;Wunderlich, editor, <em>Proc. of the European Conference on Computational Mechanics: Solids, Structures and Coupled Problems in Engineering</em>, page 328, 1999.</dd>
        <dt id="Melnik:99">[Melnik:99] R.&nbsp;V.&nbsp;N. Melnik, A.&nbsp;J. Roberts, and K.&nbsp;A.Thomas.</dt>
        <dd>Modelling dynamics of shape-memory-alloys via computer algebra. In: V.V. Vardan, editor, <em>Mathematics and Control in Smart Structures, Proc. of SPIE</em>, volume 3667, pages 290-301, 1999.</dd>
        <dt id="DeMenna:87">[DeMenna:87] L.&nbsp;De Menna, G.&nbsp;Miano, and G.&nbsp;Rubinacci.</dt>
        <dd>Volterra&apos;s series solutions of free boundary plasma equilibria. <em>Phys. Fluids</em> <strong>30</strong>, pages 409-416, 1987.</dd>
        <dt id="Mercer:90">[Mercer:90] G.N. Mercer and A.J. Roberts.</dt>
        <dd><a href="http://link.aip.org/link/?SMM/50/1547/1">A centre manifold description of contaminant dispersion in channels with varying flow properties</a>. <em>SIAM J. Appl. Math.</em> <strong>50</strong> no. 6, pages 1547-1565, 1990.</dd>
        <dt id="Mercer:94a">[Mercer:94a] G.N. Mercer and A.J. Roberts.</dt>
        <dd>A complete model of shear dispersion in pipes. <em>Jap. J. Indust. Appl. Math.</em> <strong>11</strong>, pages 499-521, 1994.</dd>
        <dt id="Mirie:84">[Mirie:84] R.&nbsp;M. Mirie and C.&nbsp;H. Su.</dt>
        <dd><a href="http://dx.doi.org/10.1017/S0022112084002068">Internal solitary waves and their head-on collision part i</a>. <em>J. Fluid Mech.</em> <strong>147</strong>, pages 213-231, 1984.</dd>
        <dt id="Molenkamp:91">[Molenkamp:91] J.H.J. Molenkamp, V.V. Goldman, and J.A. van Hulzen.</dt>
        <dd><a href="http://doi.acm.org/10.1145/120694.120758">An improved approach to automatic error cumulation control</a>. In: Stephen&nbsp;M. Watt, editor, <em>Proc. of the 1991 International Symposium on Symbolic and Algebraic Computation</em>, pages 414-418, Maryland, 1991. ACM Press.</dd>
        <dt id="Moller:89">[Moller:89] H.&nbsp;Michael M&ouml;ller.</dt>
        <dd>Multivariate rational interpolation reconstruction of rational functions. Preprint SC 89-4, Konrad-Zuse-Zentrum f&uuml;r Informationstechnik Berlin, July 1989.</dd>
        <dt id="Moller:92">[Moller:92] H.&nbsp;Michael M&ouml;ller.</dt>
        <dd>On decomposing systems of polynomial equations with finitely many solutions. Preprint SC 92-15, Konrad-Zuse-Zentrum f&uuml;r Informationstechnik Berlin, June 1992.</dd>
        <dt id="Moritsugu:88">[Moritsugu:88] S.&nbsp;Moritsugu and E.&nbsp;Goto.</dt>
        <dd>A proposal for improvement of facilities of REDUCE. Technical report, Department of Information Science, University of Tokyo, Japan, December 1988.</dd>
        <dt id="Moritsugu:85">[Moritsugu:85] S.&nbsp;Moritsugu, N.&nbsp;Inada, and E.&nbsp;Goto.</dt>
        <dd>Symbolic Newton iteration and its application. In: <em>Proc. of the Second RIKEN International Symposium on Symbolic and Algebraic Computation by Computers</em>, pages 105-117, Singapore, 1985. World Scientific.</dd>
        <dt id="Moritsugu:89">[Moritsugu:89] Shuichi Moritsugu and Eiichi Goto.</dt>
        <dd><a href="http://doi.acm.org/10.1145/66062.66063">A note on the preconditioning for factorization of homogeneous polynomials</a>. <em>SIGSAM Bulletin</em> <strong>23</strong> no. 1, pages 9-12, January 1989.</dd>
        <dt id="Moritsugu:89a">[Moritsugu:89a] Shuichi Moritsugu and Makoto Matsumoto.</dt>
        <dd><a href="http://doi.acm.org/10.1145/74646.74647">A note on the numerical evaluation of arctangent function</a>. <em>SIGSAM Bulletin</em> <strong>23</strong> no. 3, pages 8-12, July 1989.</dd>
        <dt id="Mueller-Hoissen:93">[Mueller-Hoissen:93] F.&nbsp;Mueller-Hoissen.</dt>
        <dd>Noncommutative differential calculus, quantum groups and computer algebra. In: G.&nbsp;Jacob, N.&nbsp;E. Oussous, and S.&nbsp;Steinberg, editors, <em>Proceedings of the 1993 International IMACS Symposium on Symbolic Computation</em>, pages 97-102. IMACS, Laboratoire d&apos;Informatique Fondamentale de Lille, France, 1993.</dd>
        <dt id="Mueller:81">[Mueller:81] R.&nbsp;M&uuml;ller and H.&nbsp;J.&nbsp;W. M&uuml;ller-Kirsten.</dt>
        <dd><a href="http://link.aip.org/link/?JMAPAQ/22/733/1">Iteration of single- and two-channel Schr&ouml;dinger equations</a>. <em>Journal of Mathematical Physics</em> <strong>22</strong>, pages 733-749, 1981.</dd>
        <dt id="Muroa:91">[Muroa:91] Hirokazu Murao.</dt>
        <dd>Vectorization of symbolic determinant calculation. <em>Supercomputer</em> <strong>43,VIII-3</strong>, pages 36-48, 1991.</dd>
        <dt id="Murzin:85">[Murzin:85] F.&nbsp;A. Murzin.</dt>
        <dd><a href="http://dx.doi.org/10.1080/00207168508803455">Syntactic properties of the REFAL language</a>. <em>Int. J. Computer Maths.</em> <strong>17</strong> no. 2, pages 123-139, 1985.</dd>
    </dl>

    <dl id='N'>
        <dt id="Nagata:82">[Nagata:82] Morio Nagata and Makoto Shibayama.</dt>
        <dd>COSMOS: a conversational algebraic system. Technical Report No. 8201, Department of Administration Engineering, Keio University, March 1982.</dd>
        <dt id="Nagata:85">[Nagata:85] Morio Nagata and Makoto Shibayama.</dt>
        <dd>An interactive algebraic system for personal computing. In: <em>IEEE International Symposium on New Directions in Computing</em>, 1985.</dd>
        <dt id="Nakamura:89">[Nakamura:89] Hideharu Nakamura and Shouichi Matsui.</dt>
        <dd><em>Symbolic Computation in Structural Mechanics using REDUCE</em>. Gihodo Shuppan Company Ltd., 1-11-41, Akasaka, Minato-Ku, 107 Tokyo, Japan, 1989.</dd>
        <dt id="Nakashima:84a">[Nakashima:84a] T.&nbsp;T. Nakashima, R.&nbsp;E.&nbsp;D. McClung, and B.&nbsp;K. John.</dt>
        <dd>Experimental and theoretical investigation of <sub>2</sub>d-<sub>13</sub>c dept spectra on cd<sub>N</sub>. <em>J. Magnetic Resonance</em> <strong>58</strong>, pages 27-36, 1984.</dd>
        <dt id="Nakashima:84">[Nakashima:84] T.&nbsp;T. Nakashima, R.&nbsp;E.&nbsp;D. McClung, and B.&nbsp;K. John.</dt>
        <dd>A simple method for the determination of the deuterium decoupler pulse angle. <em>J. Magnetic Resonance</em> <strong>56</strong> no. 2, pages 262-274, 1984.</dd>
        <dt id="Namba:86">[Namba:86] Kenji Namba.</dt>
        <dd><a href="http://doi.acm.org/10.1145/12917.12922">Some improvements on Utah Standard Lisp</a>. <em>SIGSAM Bulletin</em> <strong>20</strong> no. 1 and 2, pages 29-36, February and May 1986.</dd>
        <dt id="Nemeth:82">[Nemeth:82] G.&nbsp;N&eacute;meth and M.&nbsp;Zim&aacute;nyi.</dt>
        <dd>Polynomial type Pad&eacute; approximants. <em>Math. Comp.</em> <strong>38</strong>, pages 553-565, 1982.</dd>
        <dt id="Nemeth:87">[Nemeth:87] G.&nbsp;N&eacute;meth and M.&nbsp;Zim&aacute;nyi.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-51517-8_150">Computation of generalized Pad&eacute; approximants</a>. In: <em>Proc. EUROCAL &apos;87, Lecture Notes in Computer Science</em>, volume 378, pages 450-451. Springer-Verlag, 1987.</dd>
        <dt id="Neun:89">[Neun:89] W.&nbsp;Neun and H.&nbsp;Melenk.</dt>
        <dd>Implementation of the LISP-arbitrary precision arithmetic for a vector processor. <em>Computer Algebra and Parallelism</em> pages 75-89, 1989.</dd>
        <dt id="Neutsch:86">[Neutsch:86] W.&nbsp;Neutsch and E.&nbsp;Schr&uuml;fer.</dt>
        <dd><a href="http://dx.doi.org/10.1007/BF00643973">Simple integrals for solving Kepler&apos;s equation</a>. <em>Astrophysics and Space Science</em> <strong>125</strong>, pages 77-83, 1986.</dd>
        <dt id="Neutsch:85">[Neutsch:85] W.&nbsp;Neutsch, E.&nbsp;Schr&uuml;fer, and A.&nbsp;Jessner.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0021-9991(85)90114-7">Note on efficient integration on the hypersphere</a>. <em>Journal of Computational Physics</em> <strong>59</strong> no. 1, pages 167-175, May 1985.</dd>
        <dt id="Ng:89">[Ng:89] Tze&nbsp;Beng Ng.</dt>
        <dd><a href="http://dx.doi.org/10.1016/S0747-7171(89)80009-4">Computation of the cohomology of BS<sub>n</sub>&lt;16&gt; for 23 &#8804; n &#8804; 26 using REDUCE</a>. <em>Journal of Symbolic Computation</em> <strong>7</strong> no. 1, pages 93-99, January 1989.</dd>
        <dt id="Niki:84">[Niki:84] Naoto Niki and Sadanori Konishi.</dt>
        <dd><a href="http://dx.doi.org/10.1080/03610918408812366">Higher order asymptotic expansions for the distribution of the sample correlation coefficient</a>. <em>Comm. Statist.-Simula. Comp.</em> <strong>13</strong> no. 2, pages 169-182, 1984.</dd>
        <dt id="Nikityuk:87">[Nikityuk:87] N.&nbsp;M. Nikityuk.</dt>
        <dd>Some questions of using coding theory and analytical calculation methods on computers. Technical Report E11-87-10, J.I.N.R., Dubna, 1987.</dd>
        <dt id="Noor:79">[Noor:79] A.&nbsp;K. Noor and C.&nbsp;M. Andersen.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0045-7949(79)90077-4">Computerized symbolic manipulation in structural mechanics - progress and potential</a>. <em>Computers and Structures</em> <strong>10</strong> no. 1-2, pages 95-118, April 1979.</dd>
        <dt id="Norman:90">[Norman:90] A.&nbsp;C. Norman.</dt>
        <dd><a href="http://doi.acm.org/10.1145/96877.96926">A critical-pair/completion based integration algorithm</a>. In: S.&nbsp;Watanabe and Morio Nagata, editors, <em>Proceedings of the International Symposium on Symbolic and Algebraic Computation</em>, pages 201-205. ACM, Addison-Wesley, 1990.</dd>
        <dt id="Norman:93">[Norman:93] A.&nbsp;C. Norman.</dt>
        <dd><a href="http://dx.doi.org/10.1007/BFb0013187">Compact delivery support for REDUCE</a>. In: <em>Proc. DISCO &apos;93</em>, <em>Lecture Notes in Comp. Science</em> 722, pages 331-340. Springer-Verlag, 1993.</dd>
        <dt id="Norman:79">[Norman:79] A.&nbsp;C. Norman and J.&nbsp;H. Davenport.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-09519-5_90">Symbolic integration - the dust settles?</a>. In: <em>Proc. EUROSAM 1979</em>, <em>Lecture Notes in Computer Science</em>&nbsp;72, pages 398-407. Springer-Verlag, 1979.</dd>
        <dt id="Norman:77">[Norman:77] A.&nbsp;C. Norman and P.&nbsp;M.&nbsp;A. Moore.</dt>
        <dd>Implementing the new Risch integration algorithm. In: <em>Proc. of the Fourth Colloquium on Advanced Comp. Methods in Theor. Phys., St. Maximin, France</em>, March 1977.</dd>
        <dt id="Norman:95">[Norman:95] A.C. Norman.</dt>
        <dd><a href="http://dx.doi.org/10.1006/jsco.1995.1008">Compact delivery support for REDUCE</a>. <em>Journal of Symbolic Computation</em> <strong>19</strong> no. 1-3, pages 133-143, January 1995.</dd>
        <dt id="Norman:78">[Norman:78] Arthur Norman.</dt>
        <dd><a href="http://doi.acm.org/10.1145/1088276.1088278">Towards a REDUCE solution to SIGSAM problem 7</a>. <em>SIGSAM Bulletin</em> <strong>12</strong>
            no. 4, pages 14-18, November 1978.</dd>
        <dt id="Norman:99">[Norman:99] Arthur&nbsp;C. Norman and Anthony&nbsp;C. Hearn.</dt>
        <dd><a href="http://www.rand.org/personal/hearn/dist.pdf">Synchronization of distributed development software</a>. In: <em>Proceedings of IMAC Workshop, ISAAC &apos;99, Vancouver, Canada</em>, June 1999.</dd>
        <dt id="Norman:83">[Norman:83] Arthur&nbsp;C. Norman and Paul&nbsp;S. Wang.</dt>
        <dd><a href="http://doi.acm.org/10.1145/1089320.1089326">A comparison of Vaxima and REDUCE</a>. <em>SIGSAM Bulletin</em> <strong>17</strong> no. 1, pages 28-30, February 1983.</dd>
        <dt id="Norton:80">[Norton:80] Lewis&nbsp;M. Norton.</dt>
        <dd><a href="http://doi.acm.org/10.1145/1089220.1089225">A note about Laplace transform tables for computer use</a>. <em>SIGSAM Bulletin</em> <strong>14</strong> no. 2, pages 30-31, May 1980.</dd>
        <dt id="Nucci:90">[Nucci:90] M.&nbsp;C. Nucci.</dt>
        <dd>Interactive REDUCE programs for calculating classical, non-classical and Lie-B&auml;cklund symmetries of differential equations. Preprint Math: 062090-051, Georgia Institute of Technology, School of Mathematics, 1990.</dd>
    </dl>

    <dl id='O'>
        <dt id="Ochiai:90">[Ochiai:90] Mitsuyuki Ochiai and Kiyokazu Nagatomo.</dt>
        <dd><em>Linear Algebra using REDUCE</em>. Kindai Kagaku sha, Tokyo, January 1990.</dd>
        <dt id="Ogilvie:82">[Ogilvie:82] J.&nbsp;F. Ogilvie.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0097-8485(82)85011-0">Applications of computer algebra in physical chemistry</a>. <em>Computers &amp; Chemistry</em> <strong>6</strong> no. 4, pages 169-172, 1982.</dd>
        <dt id="Ogilvie:89">[Ogilvie:89] J.&nbsp;F. Ogilvie.</dt>
        <dd>Computer algebra in modern physics. <em>Computers in Physics</em> no. 1, pages 66-74, January/February 1989.</dd>
        <dt id="Ono:79">[Ono:79] Kiyoshi Ono.</dt>
        <dd>BFORT - a Fortran system with arbitrary precision integer and real arithmetic. Technical report, Department of Physics, University of Tokyo, January 1979.</dd>
        <dt id="Ozieblo">[Ozieblo] A.&nbsp;Ozieblo.</dt>
        <dd>Application of REDUCE 2 in general theory of relativity. Technical report, Cyfronet - Krakow, Poland.</dd>
    </dl>

    <dl id='P'>
        <dt id="Padget90">[Padget90] Julian Padget and Alan Barnes.</dt>
        <dd><a href="http://doi.acm.org/10.1145/96877.96899">Univariate power series expansions in REDUCE</a>. In: S.&nbsp;Watanabe and Morio Nagata, editors, <em>Proceedings of the International Symposium on Symbolic and Algebraic Computation</em>, pages 82-87. ACM, Addison-Wesley, 1990.</dd>
        <dt id="Pankau:73a">[Pankau:73a] E.&nbsp;Pankau and W.&nbsp;Nakel.</dt>
        <dd>Eine Koinzidenzmessung zum Elementarprozess der Elektron-Elektron-Bremsstrahlung bei 300 keV. <em>Z. Physik</em> <strong>264</strong>, pages 139-153, 1973.</dd>
        <dt id="Pankau:73">[Pankau:73] E.&nbsp;Pankau and W.&nbsp;Nakel.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0375-9601(73)90963-8">Measurement of the absolute cross section of the elementary process of electron-electron bremsstrahlung at 300 keV</a>. <em>Physics Letters A</em> <strong>44</strong> no. 1, pages 65-67, 1973.</dd>
        <dt id="Parsons:68">[Parsons:68] R.&nbsp;G. Parsons.</dt>
        <dd><a href="http://link.aps.org/doi/10.1103/PhysRev.168.1562">An estimate of the sixth order contribution to the anomalous magnetic moment of the electron</a>. <em>Phys. Rev.</em> <strong>168</strong> no. 5, pages 1562-1567, 1968.</dd>
        <dt id="Parsons:71">[Parsons:71] R.&nbsp;G. Parsons.</dt>
        <dd>S-channel transformation matrices for helicity and invariant amplitudes for lambda + n to o + b. Memo CPT-88, Center for Particle Theory, University of Texas, January 1971.</dd>
        <dt id="Pasini:91">[Pasini:91] P.&nbsp;Pasini, F.&nbsp;Semeria, and C.&nbsp;Zannoni.</dt>
        <dd><a href="http://dx.doi.org/10.1016/S0747-7171(08)80126-5">Symbolic computation of orientational correlation function moments</a>. <em>Journal of Symbolic Computation</em> <strong>12</strong> no. 2, pages 221-231, August 1991.</dd>
        <dt id="Passmore:03">[Passmore:03] Tim Passmore and A.&nbsp;J. Roberts.</dt>
        <dd><a href="http://anziamj.austms.org.au/V44/CTAC2001/Pass">Low Prandtl number fluid convection modelled using symbolic algebra (REDUCE) and Matlab</a>. In: K.&nbsp;Burrage and Roger&nbsp;B. Sidje, editors, <em>Proc. of 10th Computational Techniques and Applications Conference CTAC-2001</em>, volume&nbsp;44, pages C590-C626, 2003.</dd>
        <dt id="Pattnaik:83">[Pattnaik:83] P.&nbsp;C. Pattnaik, G.&nbsp;Fletcher, and J.&nbsp;L. Fry.</dt>
        <dd><a href="http://link.aps.org/doi/10.1103/PhysRevB.28.3564">Improved numerical stability for norm-conserving ion-Ure pseudopotentials</a>. <em>Phys. Rev. B</em> <strong>28</strong> no. 6, pages 3564-3565, 1983.</dd>
        <dt id="PauleRiese:95">[PauleRiese:95] P.&nbsp;Paule and A.&nbsp;Riese.</dt>
        <dd>A mathematica q-analogue of zeilberger&apos;s algorithm based on an algebraically motivated approach to q-hypergeometric telescoping. In: <em>Fields Proceedings of the Workshop &apos;Special Functions, q-Series and Related Topics</em>, pages 179-210, Toronto, Ontario, 12-23 June 1995. Fields Institute for Research in Mathematical Sciences at University College.</dd>
        <dt id="Pearce:81">[Pearce:81] P.&nbsp;D. Pearce and R.&nbsp;J. Hicks.</dt>
        <dd><a href="http://doi.acm.org/10.1145/1089270.1089274">The application of algebraic optimisation techniques to algebraic mode programs for REDUCE</a>. <em>SIGSAM Bulletin</em> <strong>15</strong> no. 4, pages 15-22, November 1981.</dd>
        <dt id="Pearce:83">[Pearce:83] P.&nbsp;D. Pearce and R.&nbsp;J. Hicks.</dt>
        <dd><a href="http://doi.acm.org/10.1145/1089320.1089327">Data structures and execution times of algebraic mode programs for REDUCE</a>. <em>SIGSAM Bulletin</em> <strong>17</strong> no. 1, pages 31-37, February 1983.</dd>
        <dt id="Perjes:84b">[Perjes:84b] Z.&nbsp;Perj&eacute;s.</dt>
        <dd>Improved characterization of the Kerr metric. Technical Report KFKI-1984-115, Hungarian Academy of Sciences, Central Research Institute for Physics, 1984.</dd>
        <dt id="Perjes:84c">[Perjes:84c] Z.&nbsp;Perj&eacute;s.</dt>
        <dd>Stationary vacuum fields with a conformally flat three-space. IV. Complete solution. Technical Report INS-REP.-487, January 1984.</dd>
        <dt id="Perjes:86">[Perjes:86] Z.&nbsp;Perj&eacute;s.</dt>
        <dd>Ernst coordinates. Preprint KFKI-1986-33/B, Hungarian Academy of Sciences, Central Research Institute for Physics, 1986.</dd>
        <dt id="Perjes:86a">[Perjes:86a] Z.&nbsp;Perj&eacute;s.</dt>
        <dd><a href="http://dx.doi.org/10.1007/BF00770466">Stationary vacuum fields with a conformally flat three-space. II. Proof of axial symmetry</a>. <em>General Relativity and Gravitation</em> <strong>18</strong> no. 5, pages 511-530, May 1986.</dd>
        <dt id="Perjes:84">[Perjes:84] Z.&nbsp;Perj&eacute;s.</dt>
        <dd><a href="http://dx.doi.org/10.1007/BF00770467">Stationary vacuum fields with a conformally flat three-space. III. Complete solution</a>. <em>General Relativity and Gravitation</em> <strong>18</strong> no. 5, pages 531-547, May 1986.</dd>
        <dt id="Perjes:88">[Perjes:88] Z.&nbsp;Perj&eacute;s.</dt>
        <dd>Approaches to axisymmetry by man and machine. <em>Relativity Today</em> , 1988.</dd>
        <dt id="Perjes:84a">[Perjes:84a] Z.&nbsp;Perj&eacute;s, B.&nbsp;Luk&aacute;cs, A.&nbsp;Sebesty&eacute;n, and A.&nbsp;Valentini.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0375-9601(84)90630-3">Solution of the stationary vacuum equations of relativity for conformally flat 3-spaces</a>. <em>Physics Letters A</em> <strong>100</strong> no. 8, pages 405-406, February 1984.</dd>
        <dt id="Perlt:90">[Perlt:90] H.&nbsp;Perlt, J.&nbsp;Ranft, and J.&nbsp;Heinrich.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0010-4655(90)90021-R">Calculation of QED graphs with the Spinor technique</a>. <em>Computer Physics Communications</em> <strong>56</strong> no. 3, pages 385-390, January 1990.</dd>
        <dt id="Perrottet:78">[Perrottet:78] M.&nbsp;Perrottet.</dt>
        <dd>Signature for W boson production from jet analysis in e<sup>+</sup>e<sup>-</sup> &rarr; W<sup>+</sup>W<sup>-</sup> &rarr; hadrons. Preprint 78/P.1019, CPT 2, CNRS, Marseille, June 1978.</dd>
        <dt id="Pesic:73">[Pesic:73] P.&nbsp;D. Pesic.</dt>
        <dd>Two-photon cross section for W-pair production by colliding beams. Report SLAC-PUB-1188, Stanford University, 1973.</dd>
        <dt id="Pictiaw:69">[Pictiaw:69] Chen Pictiaw.</dt>
        <dd><em>An Analytical Investigation of Infinitesimal Spatial Motion Theory and its Application to Three-Dimensional Linkages</em>. PhD thesis, Dept. of Mech. Eng., Stanford University, March 1969.</dd>
        <dt id="Piessens:84">[Piessens:84] R.&nbsp;Piessens.</dt>
        <dd>A series expansion for the first positive zero of the Bessel function. <em>Math. Comp.</em> <strong>42</strong>, pages 195-197, 1984.</dd>
        <dt id="Piessens:86">[Piessens:86] R.&nbsp;Piessens and S.&nbsp;Ahmed.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0021-9991(86)90029-X">Note on approximation for the turning points of Bessel functions</a>. <em>Journal of Computational Physics</em> <strong>64</strong> no. 1, pages 253-257, May 1986.</dd>
        <dt id="Pignataro:85">[Pignataro:85] M.&nbsp;Pignataro, A.&nbsp;Luongo, and N.&nbsp;Rizzi.</dt>
        <dd>On the effect of the local overall interaction on the postbuckling of uniformly compressed channels. <em>Thin-Walled Structures</em> <strong>3</strong>, pages 292-321, 1985.</dd>
        <dt id="Podgorzak:84">[Podgorzak:84]</dt>
        <dd>E.&nbsp;Podg&oacute;rak and I.&nbsp;Romanowska, Application of REDUCE 2 to the construction of recurrence relations. Master&apos;s thesis, Institute of Computer Science, University of Wroclaw, 1984.</dd>
        <dt id="Pohle:89">[Pohle:89] H.J. Pohle and T.&nbsp;Wolf.</dt>
        <dd><a href="http://dx.doi.org/10.1007/BF02241219">Automatic determination of dynamical symmetries of ordinary differential equations</a>. <em>Computing</em>
            <strong>41</strong> no. 4, pages 297-306, December 1989.</dd>
        <dt id="Popowicz:93a">[Popowicz:93a] Ziemowit Popowicz.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0370-2693(93)91754-B">The Lax formulation of the N = 2 SUSY Boussinesq equation</a>. <em>Physics Letters B</em>
            <strong>319</strong> no. 4, pages 478-484, 1993. The Lax representation of the N = 2 sypersymmetric Boussinesq equation which is generated by the N = 2 supersymetric W<sub>3</sub> algebra is given. The Miura transformation which factorizes our Lax operator is found. The simple N = 2 supersymmetrization of the Lax pair of the Gelfand-Dikii hierarchy is given.</dd>
        <dt id="Popowicz:93">[Popowicz:93] Ziemowit Popowicz.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0375-9601(93)90200-J">The Lax formulation of the &quot;new&quot; n = 2 SUSY KdV equation</a>. <em>Physics Letters A</em> <strong>174</strong> no. 5-6, pages 411-415, 1993. We define the nonstandard Lax pair for the N = 2 sypersymmetric extension of the Korteweg-de Vries equation of the third kind. Hence we prove its integrability.</dd>
        <dt id="Popowicz:94b">[Popowicz:94b] Ziemowit Popowicz.</dt>
        <dd>The applications of reduce in soliton theory. <em>Proceedings of the conference I KS KOWBAN 94</em> <strong>1</strong>, pages 211-215, 1994.</dd>
        <dt id="Popowicz:94a">[Popowicz:94a] Ziemowit Popowicz.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0375-9601(94)91296-3">The extended supersymmetrization of the nonlinear Schr&ouml;dinger equation</a>. <em>Physics Letters A</em> <strong>194</strong> no. 5-6, pages 375-379, 1994.</dd>
        <dt id="Popowicz:94">[Popowicz:94] Ziemowit Popowicz.</dt>
        <dd><a href="http://dx.doi.org/10.1142/S0217751X94000844">The super w<sub>3</sub> conformal algebra and the Boussinesq Hierarchy</a>. <em>International Journal of Modern Physics A</em> <strong>9</strong> no. 12, pages 2001-2011, 1994.</dd>
        <dt id="Popowicz:96">[Popowicz:96] Ziemowit Popowicz.</dt>
        <dd><a href="http://dx.doi.org/10.1088/0305-4470/29/6/014">The extended supersymmetrization of the multicomponent kadomtsev-petviashvilli hierarchy</a>. <em>J. Phys. A: Math. Gen.</em> <strong>29</strong> no. 6, pages 1281-1291, 1996.</dd>
        <dt id="Popowicz:97b">[Popowicz:97b] Ziemowit Popowicz.</dt>
        <dd><a href="http://dx.doi.org/10.1016/S0375-9601(97)00793-7">Extensions of the n=2 supersymmetric a=-2 boussinesq hierarchy</a>. <em>Physics Letters A</em> <strong>236</strong> no. 5-6, pages 455-461, 1997.</dd>
        <dt id="Popowicz:97a">[Popowicz:97a] Ziemowit Popowicz.</dt>
        <dd><a href="http://dx.doi.org/10.1088/0305-4470/30/22/027">Integrable system constructed out of two interacting superconformal fields</a>. <em>J. Phys. A: Math. Gen.</em> <strong>30</strong> no. 22, pages 7935-7944, 1997.</dd>
        <dt id="Popowicz:97">[Popowicz:97] Ziemowit Popowicz.</dt>
        <dd><a href="http://dx.doi.org/10.1016/S0010-4655(96)00151-8">S u s y 2</a>. <em>Computer Physics Communications</em> <strong>100</strong>, pages 277-296, 1997.</dd>
        <dt id="Popowicz:98">[Popowicz:98] Ziemowit Popowicz.</dt>
        <dd>Generalization of susy n=2 kdv equation. <em>Proc. Classical and Quantum Integrable Systems III</em> pages 159-166, 1998.</dd>
        <dt id="Popowicz:99">[Popowicz:99] Ziemowit Popowicz.</dt>
        <dd><a href="http://dx.doi.org/10.1016/S0370-2693(99)00633-4">Odd bihamiltonian structure of new supersymmetric n=2,4 korteweg de vries equation and odd susy virasoro-like algebra</a>. <em>Physics Letters B</em> <strong>459</strong> no. 1-3, pages 150-158, 1999.</dd>
        <dt id="Popowicz:00">[Popowicz:00] Ziemowit Popowicz.</dt>
        <dd>The supercomplexification and odd bihamiltonian structures. <em>Proc. of the International Seminar on Supersymmetries and Quantum Symmetries</em> pages 340-350, 2000.</dd>
        <dt id="Price:84">[Price:84] S.&nbsp;L. Price, A.&nbsp;J. Stone, and M.&nbsp;Alderton.</dt>
        <dd><a href="http://dx.doi.org/10.1080/00268978400101721">Explicit formulae for the electrostatic energy, forces and torques between a pair of molecules of arbitrary symmetry</a>. <em>Molecular Physics</em> <strong>52</strong> no. 4, pages 987-1001, July 1984.</dd>
        <dt id="Proeyan:79">[Proeyan:79] A.&nbsp;Van Proeyan.</dt>
        <dd>Gravitational divergences of the electromagnetic interactions of massive vectorparticles. Preprint KUL-TF-79/032, Universiteit Leuven, October 1979.</dd>
        <dt id="Proeyan:76">[Proeyan:76] A.&nbsp;Van Proeyen.</dt>
        <dd>Quantum gravity corrections on the anomalous magnetic and quadrupole moments of a spin-1 particle. Technical report, Instituut voor Theor. Fys., Leuven, October 1976.</dd>
    </dl>

    <dl id='Q'>
        <dt id="Quarton">[Quarton] D.&nbsp;C. Quarton and A.&nbsp;D. Garrad.</dt>
        <dd>Some comments on the stability analysis of horizontal axis wind turbines. Technical report, Wind Energy Group, Taylor Woodrow Construction Ltd.</dd>
        <dt id="Quarton:84">[Quarton:84] D.&nbsp;C. Quarton and A.&nbsp;D. Garrad.</dt>
        <dd>Symbolic computing as a tool in wind turbine dynamics. Technical report, Wind Energy Group, Taylor Woodrow Construction Ltd., 1984.</dd>
    </dl>

    <dl id='R'>
        <dt id="Rao:85">[Rao:85]</dt>
        <dd>R.&nbsp;H. Rao, Deformation of a fluid-filled cylindrical membrane by a slow viscous shear flow. Master&apos;s thesis, Washington University, Dept. of Mech. Eng., Washington University, St. Louis, 1985.</dd>
        <dt id="Rayna:87">[Rayna:87] G.&nbsp;Rayna.</dt>
        <dd><a href="http://www.springer.com/math/cse/book/978-0-387-96598-7"><em>REDUCE: A System for Computer Algebra</em></a>. Springer-Verlag, 1987.</dd>
        <dt id="Renner:91">[Renner:91] Friedrich Renner.</dt>
        <dd><a href="http://doi.acm.org/10.1145/120694.120738">Nonlinear evolution equations and the Painlev&eacute; analysis: A constructive approach with REDUCE</a>. In: Stephen&nbsp;M. Watt, editor, <em>Proc. of the 1991 International Symposium on Symbolic and Algebraic Computation</em>, pages 289-294, Maryland, July 1991. ACM Press.</dd>
        <dt id="Renner:92">[Renner:92] Friedrich Renner.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0010-4655(92)90203-B">A constructive REDUCE package based upon the Painlev&eacute; analysis of nonlinear evolutions equations in hamiltonian and/or normal form</a>. <em>Computer Physics Communications</em> <strong>70</strong> no. 2, pages 409-416, June 1992.</dd>
        <dt id="Reusch:86">[Reusch:86] M.&nbsp;F. Reusch and G.&nbsp;H. Neilson.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0021-9991(86)90041-0">Torodially symmetric polynomial multipole solutions of the vector Laplace equation</a>. <em>Journal of Computational Physics</em> <strong>64</strong> no. 2, pages 416-432, June 1986.</dd>
        <dt id="Rink:71">[Rink:71] R.&nbsp;A. Rink.</dt>
        <dd><em>Application of a Digital Computer to Solve Analytically Special Classes of Linear and Nonlinear Differential Equations</em>. PhD thesis, Stanford University, 1971.</dd>
        <dt id="Rizzi:85">[Rizzi:85] N.&nbsp;Rizzi and A.&nbsp;Tatone.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0045-7949(85)90146-4">Symbolic manipulation in buckling and postbuckling analysis</a>. <em>Computers and Structures</em> <strong>21</strong> no. 4, pages 691-700, 1985.</dd>
        <dt id="Roberts:00">[Roberts:00] A.&nbsp;J. Roberts.</dt>
        <dd><a href="http://dx.doi.org/10.1016/S0010-4655(99)00494-4">Computer algebra derives correct initial conditions for low-dimensional dynamical models</a>. <em>Computer Physics Communications</em> <strong>126</strong> no. 3, pages 187-206, April 2000.</dd>
        <dt id="Roberts:01">[Roberts:01] A.&nbsp;J. Roberts.</dt>
        <dd><a href="http://dx.doi.org/10.1016/S0168-9274(00)00053-2">Holistic discretisation ensures fidelity to Burgers&apos; equation</a>. <em>Applied Numerical Modelling</em> <strong>37</strong> no. 3, pages 371-396, January 2001.</dd>
        <dt id="Roberts:03">[Roberts:03] A.&nbsp;J. Roberts.</dt>
        <dd><a href="http://anziamj.austms.org.au/V44/CTAC2001/Robe">Derive boundary conditions for holistic discretisations of Burgers&apos; equation</a>. In: K.&nbsp;Burrage and Roger&nbsp;B. Sidje, editors, <em>Proc. of 10th Computational Techniques and Applications Conference CTAC-2001</em>, volume&nbsp;44, pages C664-C686, 2003.</dd>
        <dt id="Roberts:03a">[Roberts:03a] A.&nbsp;J. Roberts.</dt>
        <dd><a href="http://anziamj.austms.org.au/V45/CTAC2003/Robe">A step towards holistic discretisation of stochastic partial differential equations</a>. In: Jagoda Crawford and A.&nbsp;J. Roberts, editors, <em>Proc. of 11th Computational Techniques and Applications Conference CTAC-2003</em>, volume&nbsp;45, pages C1-C15, 2003.</dd>
        <dt id="Roberts:06">[Roberts:06] A.&nbsp;J. Roberts.</dt>
        <dd><a href="http://eprints.usq.edu.au/1322/1/Roberts06b.pdf">Computer algebra derives discretisations of the stochastically forced burgers&apos; partial differential equation</a>. Technical report, University of Southern Queensland, Department of Maths and Computing, Toowoomba, Australia, 2006.</dd>
        <dt id="Roberts:92">[Roberts:92] A.J. Roberts.</dt>
        <dd>A sub-centre manifold description of the evolution and interaction of nonlinear dispersive waves. In: L.&nbsp;Debnath, editor, <em>Nonlinear waves</em>, chapter&nbsp;9, pages 127-156. World Sci, 1992.</dd>
        <dt id="Roberts:93">[Roberts:93] A.J. Roberts.</dt>
        <dd><a href="http://www.springerlink.com/content/h635241874h193l4/">The invariant manifold of beam deformations. part 1: the simple circular rod</a>. <em>J. Elas.</em> <strong>30</strong> no. 1, pages 1-54, 1993.</dd>
        <dt id="Roberts:94c">[Roberts:94c] A.J. Roberts.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0375-9601(96)00040-0">Low-dimensional models of thin film fluid dynamics</a>. <em>Physics Letters A</em> <strong>212</strong> no. 1-2, pages 63-72, 1996.</dd>
        <dt id="Roberts:96">[Roberts:96] A.J. Roberts.</dt>
        <dd><a href="http://dx.doi.org/10.1016/S0010-4655(96)00162-2">Low-dimensional modelling of dynamics via computer algebra</a>. <em>Computer Physics Communications</em> <strong>100</strong> no. 3, pages 215-230, March 1997.</dd>
        <dt id="Roberts:97">[Roberts:97] A.J. Roberts.</dt>
        <dd><a href="http://link.aip.org/link/?SIR/39/514/1">Solution to problem 96-14: An integral</a>. <em>SIAM Review</em> <strong>39</strong> no. 3, pages pp526-7, 1997.</dd>
        <dt id="Roberts:96a">[Roberts:96a] A.J. Roberts.</dt>
        <dd>An accurate model of thin 2d fluid flows with inertia on curved surfaces. In: P.A. Tyvand, editor, <em>Free-surface flows with viscosity</em>, <em>Advances in Fluid Mechanics Series</em>&nbsp;16, chapter&nbsp;3, pages 69-88. Comput Mech Pub, 1998.</dd>
        <dt>[Roberts:2014] A.&nbsp;J. Roberts, Tony MacKenzie, and Judith Bunder.</dt>
        <dd>A dynamical systems approach to simulating macroscale spatial dynamics in multiple dimensions. <em>J. Engineering Mathematics</em>, 86(1):175&ndash;207, 2014 <a href="http://arxiv.org/abs/1103.1187">Download (draft) article</a>.</dd>
        <dt>[Roberts:2015a] A.&nbsp;J. Roberts.</dt>
        <dd><a href="http://bookstore.siam.org/mm20/"><em>Model emergent dynamics in complex systems</em></a>. SIAM, Philadelphia, Jan 2015.</dd>
        <dt>[Roberts:2015b] A.&nbsp;J. Roberts.</dt>
        <dd>Macroscale, slowly varying, models emerge from the microscale dynamics in long thin domains. <em>IMA Journal of Applied Mathematics</em>, 80(5):1492&ndash;1518, 2015.</dd>
        <dt>[Roberts:2017] A.&nbsp;J. Roberts and J.&nbsp;E. Bunder.</dt>
        <dd>Slowly varying, macroscale models emerge from microscale dynamics over multiscale domains. <em>IMA Journal of Applied Mathematics</em>, 5 July, 2017 <a href="http://arxiv.org/abs/1612.02079">Download (draft) article</a>.</dd>
        <dt id="Rodionov:84">[Rodionov:84] A.&nbsp;Ya. Rodionov.</dt>
        <dd><a href="http://doi.acm.org/10.1145/1089389.1089394">Work with non-commutative variables in the REDUCE-2 system for analytical calculations</a>. <em>SIGSAM Bulletin</em> <strong>18</strong> no. 3, pages 16-19, August 1984.</dd>
        <dt id="Rodionov:87a">[Rodionov:87a] A.&nbsp;Ya. Rodionov and A.&nbsp;Yu. Taranov.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-51517-8_113">Combinatorial aspects of simplification of algebraic expressions</a>. In: <em>Proc. EUROCAL &apos;87, Lecture Notes in Computer Science</em>, volume 378, pages 192-201. Springer-Verlag, 1987.</dd>
        <dt id="Rodionov:87">[Rodionov:87] A.&nbsp;Ya. Rodionov and A.&nbsp;Yu. Taranov.</dt>
        <dd><a href="http://dx.doi.org/10.1088/0264-9381/4/6/028">Computation of covariant derivatives of the geodetic interval within the coincident arguments</a>. <em>Classical and Quantum Gravity</em> <strong>4</strong> no. 6, pages 1767-1775, 1987.</dd>
        <dt id="Rodionov:88">[Rodionov:88] A.&nbsp;Ya. Rodionov and A.&nbsp;Yu. Taranov.</dt>
        <dd>RTENSOR - Packet for work with tensoric expressions. Preprint 88-29/50, Moscow State University, Scientific Research Institute of Nuclear Physics, 1988.</dd>
        <dt id="Roelofs:91">[Roelofs:91] Marcel Roelofs and Peter&nbsp;K.H. Gragert.</dt>
        <dd><a href="http://doi.acm.org/10.1145/120694.120754">Implementation of multilinear operators in REDUCE and applications in mathematics</a>. In: Stephen&nbsp;M. Watt, editor, <em>Proc. of the 1991 International Symposium on Symbolic and Algebraic Computation</em>, pages 390-396, Maryland, July 1991. ACM Press.</dd>
        <dt id="Rogers:89">[Rogers:89] C.&nbsp;Rogers and W.&nbsp;F. Ames.</dt>
        <dd><em>Nonlinear Boundary Value Problems in Science and Engineering</em>. Academic Press, Inc., 1989.</dd>
        <dt id="Ronveaux:88">[Ronveaux:88] A.&nbsp;Ronveaux and G.&nbsp;Thiry.</dt>
        <dd><a href="http://doi.acm.org/10.1145/54151.54152">Polynomial solution of recurrence relation and differential equation</a>. <em>SIGSAM Bulletin</em> <strong>22</strong> no. 4, pages 9-19, October 1988.</dd>
        <dt id="Ronveaux:89">[Ronveaux:89] A.&nbsp;Ronveaux and G.&nbsp;Thiry.</dt>
        <dd><a href="http://dx.doi.org/10.1016/S0747-7171(89)80058-6">Differential equations of some orthogonal families in REDUCE</a>. <em>Journal of Symbolic Computation</em> <strong>8</strong> no. 5, pages 537-541, November 1989.</dd>
        <dt id="Roque:88">[Roque:88] Waldir&nbsp;L. Roque and Renato&nbsp;P. dos Santos.</dt>
        <dd>Computa&ccedil;&atilde;o alg&eacute;brica: &ldquo;um assistente matem&atilde;tico&rdquo;. <em>Ci&ecirc;ncia e Cultura</em> <strong>40</strong> no. 9, pages 843-852, September 1988.</dd>
        <dt id="Roque:91">[Roque:91] Waldir&nbsp;L. Roque and Renato&nbsp;P. dos Santos.</dt>
        <dd><a href="http://dx.doi.org/10.1016/S0747-7171(08)80156-3">Computer algebra in spacetime embedding</a>. <em>Journal of Symbolic Computation</em> <strong>12</strong> no. 3, pages 381-389, September 1991.</dd>
        <dt id="Roy:02">[Roy:02] R.&nbsp;Valery Roy, A.&nbsp;J. Roberts, and M.&nbsp;E. Simpson.</dt>
        <dd><a href="http://dx.doi.org/10.1017/S0022112001007133">A lubrication model of coating flows over a curved substrate in space</a>. <em>J. Fluid Mech.</em> <strong>454</strong>, pages 235-261, 2002.</dd>
        <dt id="Rudenko:91">[Rudenko:91] V.M. Rudenko, V.V. Leonov, A.F. Bragazin, and I.P Shmyglevsky.</dt>
        <dd><a href="http://doi.acm.org/10.1145/120694.120766">Application of computer algebra to the investigation of the orbital satellite motion</a>. In: Stephen&nbsp;M. Watt, editor, <em>Proc. of the 1991 International Symposium on Symbolic and Algebraic Computation</em>, pages 450-451, Maryland, July 1991. ACM Press.</dd>
    </dl>

    <dl id='S'>
        <dt id="Saccomani:97a">[Saccomani:97a] M.P. Saccomani, S.&nbsp;Audoly, G.&nbsp;Bellu, L.&nbsp;D&apos;Angi&ograve;, and C.&nbsp;Cobelli.</dt>
        <dd>A new algorithm to test global identifiability of physiological nonlinear models. In: D.A. Linkens and E.&nbsp;Carson, editors, <em>Proc. 3rd IFAC Symposium on Modelling and Control in Biomedical Systems</em>, pages 259-264, UK, 1997. Elsevier.</dd>
        <dt id="Saccomani:97b">[Saccomani:97b] M.P. Saccomani, S.&nbsp;Audoly, G.&nbsp;Bellu, L.&nbsp;D&apos;Angi&ograve;, and C.&nbsp;Cobelli.</dt>
        <dd>Global identifiability of nonlinear model parameters. In: Y.&nbsp;Sawaragi and S&nbsp;Sagara, editors, <em>Proc. SYSID &apos;97 11th IFAC Symposium on Systems Identification</em>, volume&nbsp;1, pages 219-224, Kitakyushu, Japan, 1997. Nichigen Co.</dd>
        <dt id="Saccomani:96">[Saccomani:96] M.P. Saccomani, S.&nbsp;Audoly, L.&nbsp;D&apos;Angi&ograve;, and C.&nbsp;Cobelli.</dt>
        <dd>The Buchberger algorithm to study the a priori identifiability of biological systems models. In: <em>Proc. 2nd IMACS Conf. on Applications of Computer Algebra</em>, pages 73-75, Austria, 1996. Research Institute for Symbolic Computation.</dd>
        <dt id="Saccomani:97">[Saccomani:97] M.P. Saccomani, S.&nbsp;Audoly, L.&nbsp;D&apos;Angi&ograve;, and C.&nbsp;Cobelli.</dt>
        <dd>A new software tool to test global identifiability of linear compartmental models. In: D.A. Linkens and E.&nbsp;Carson, editors, <em>Proc. 3rd IFAC Symposium on Modelling and Control in Biomedical Systems</em>, pages 253-258, UK, 1997. Elsevier.</dd>
        <dt id="Saccomani:94a">[Saccomani:94a] M.P. Saccomani, S.&nbsp;Audoly, L.&nbsp;D&apos;Angi&ograve;, R.&nbsp;Sattier, and C.&nbsp;Cobelli.</dt>
        <dd>PRIDE: a program to test a priori global identifiability of linear compartmental models. In: M.&nbsp;Blanke and T.&nbsp;Soderstrom, editors, <em>Proc. SYSID &apos;94, 10th IFAC Symposium on System Identification</em>, volume&nbsp;3, pages 25-30, Copenhagen, Denmark, 1994. Danish Automation Society 1994.</dd>
        <dt id="Saccomani:94">[Saccomani:94] M.P. Saccomani, R.&nbsp;Sattier, L.&nbsp;D&apos;Angi&ograve;, S.&nbsp;Audoly, and C.&nbsp;Cobelli.</dt>
        <dd>A software tool to test global identifiability of linear compartmental models. In: B.W. Patterson, editor, <em>Modeling and Control in Biomedical Systems</em>, pages 237-238, Madison, Wisconsin, USA, 1994. Omnipress.</dd>
        <dt id="Saez:83">[Saez:83] A.&nbsp;E. Saez and B.&nbsp;J. McCoy.</dt>
        <dd><a href="http://dx.doi.org/10.1016/S0017-9310(83)80007-6">Transient analysis of packed-bed thermal storage systems</a>. <em>Int. J. Heat Mass Transfer</em> <strong>26</strong> no. 1, pages 49-54, January 1983.</dd>
        <dt id="Sage:88">[Sage:88] Martin&nbsp;L. Sage.</dt>
        <dd><a href="http://dx.doi.org/10.1016/S0747-7171(88)80036-1">An algebraic treatment of quantum vibrations using reduce</a>. <em>Journal of Symbolic Computation</em> <strong>5</strong> no. 3, pages 377-384, June 1988.</dd>
        <dt id="Sarlet:92">[Sarlet:92] W.&nbsp;Sarlet and J.&nbsp;Vanden Bonne.</dt>
        <dd>REDUCE-procedures for the study of adjoint symmetries of second-order differential equations. <em>Journal of Symbolic Computation</em> <strong>13</strong> no. 6, pages 683-693, June 1992.</dd>
        <dt id="Sasaki:79">[Sasaki:79] Tateaki Sasaki.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-09519-5_87">An arbitrary precision real arithmetic package in REDUCE</a>. In: <em>Proc. EUROSAM 1979, Lecture Notes in Computer Science</em>, volume&nbsp;72, pages 358-368. Springer-Verlag, 1979.</dd>
        <dt id="Savage:90">[Savage:90] Stuart&nbsp;B. Savage.</dt>
        <dd><a href="http://dx.doi.org/10.1016/S0747-7171(08)80025-9">Symbolic computation of the flow of granular avalanches</a>. <em>Journal of Symbolic Computation</em> <strong>9</strong> no. 4, pages 515-530, April 1990.</dd>
        <dt id="Sayers:87">[Sayers:87] C.&nbsp;M. Sayers.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0022-3115(87)90033-X">The elastic anisotropy of polycrystalline aggregates of zirconium and its alloys</a>. <em>J. Nuclear Materials</em> <strong>144</strong> no. 3, pages 211-213, 1987.</dd>
        <dt id="Sayers:87a">[Sayers:87a] C.&nbsp;M. Sayers.</dt>
        <dd><a href="http://dx.doi.org/10.1111/j.1365-246X.1987.tb06650.x">Elastic wave anisotropy in the upper mantle</a>. <em>Geophys. J. Intern.</em> <strong>88</strong>, pages 417-424, 1987.</dd>
        <dt id="Scheer:97">[Scheer:97] M.&nbsp;Scheer and G.&nbsp;W&uuml;stefeld.</dt>
        <dd>Canonical particle tracking and end pole matching of helical insertion devices. In: <em>Proceedings of the IEEE 1997 Particle Accelerator Conference, Vancouver (Canada)</em>, page 1418, 1997.</dd>
        <dt id="Scheer:97a">[Scheer:97a] M.&nbsp;Scheer and G.&nbsp;W&uuml;stefeld.</dt>
        <dd>Tracking routines for arbitrary insertion devices. In: <em>Proceedings of the IEEE 1997 Particle Accelerator Conference, Vancouver (Canada)</em>, page 2606, 1997.</dd>
        <dt id="Schlegel:91">[Schlegel:91] H.&nbsp;Schlegel.</dt>
        <dd><a href="http://doi.acm.org/10.1145/120694.120730">Determination of the root system of semisimple Lie algbras from the Dynkin diagram</a>. In: Stephen&nbsp;M. Watt, editor, <em>Proc. of the 1991 International Symposium on Symbolic and Algebraic Computation</em>, pages 239-240, Maryland, July 1991. ACM Press.</dd>
        <dt id="Schmuck:77">[Schmuck:77] P.&nbsp;Schmuck.</dt>
        <dd>Verification of the transient, two phase fluid flow program Kachina using computerized similarity analysis. In: <em>Second GAMM Conference on Numerical Methods in Fluid Mechanics, k&ouml;ln</em>, October 1977.</dd>
        <dt id="Schoebel:92">[Schoebel:92] Franziska Schoebel.</dt>
        <dd>The symbolic classification of real four-dimensional lie algebras. Technical Report Preprint 27/92, Naturwissenschaftlich-Theoretisches Zentrum, Universitaet Leipzig, Germany, 1992.</dd>
        <dt id="Schoepf:91">[Schoepf:91] Rainer Sch&ouml;pf and Peter Deuflhard.</dt>
        <dd><a href="http://opus.kobv.de/zib/volltexte/1991/62/">OCCAL a mixed symbolic-numeric Optimal Control CALculator</a>. Preprint SC 91-13, Konrad-Zuse-Zentrum f&uuml;r Informationstechnik Berlin, December 1991.</dd>
        <dt id="Schruefer:82">[Schruefer:82] E.&nbsp;Schr&uuml;fer.</dt>
        <dd><a href="http://doi.acm.org/10.1145/1089310.1089317">An implementation of the exterior calculus in REDUCE: a status report</a>. <em>SIGSAM Bulletin</em> <strong>16</strong> no. 4, pages 27-31, November 1982.</dd>
        <dt id="Schruefer:88">[Schruefer:88] E.&nbsp;Schr&uuml;fer.</dt>
        <dd><a href="http://doi.acm.org/10.1145/49456.49459">A note on Einstein metrics</a>. <em>SIGSAM Bulletin</em> <strong>22</strong> no. 3, pages 22-26, July 1988.</dd>
        <dt id="Schruefer:87">[Schruefer:87] E.&nbsp;Schr&uuml;fer, F.&nbsp;W. Hehl, and J.&nbsp;D. McCrea.</dt>
        <dd><a href="http://dx.doi.org/10.1007/BF00770331">Exterior calculus on the computer: The REDUCE-package EXCALC applied to general relativity and to the Poincar&eacute; gauge theory</a>. <em>General Relativity and Gravitation</em> <strong>19</strong> no. 2, pages 197-218, February 1987.</dd>
        <dt id="Schruefer:81">[Schruefer:81] E.&nbsp;Schr&uuml;fer and H.&nbsp;Heintzmann.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0375-9601(81)90451-5">Lorentz-covariant eikonal method in magnetohydrodynamics II - the determination of the wave amplitude</a>. <em>Physics Letters A</em> <strong>81</strong> no. 9, pages 501-506, February 1981.</dd>
        <dt id="Schwarz:80">[Schwarz:80] F.&nbsp;Schwarz.</dt>
        <dd><a href="http://dx.doi.org/10.1002/prop.19800280403">An approximation scheme for constructing &pi;<sub>0</sub>&pi; amplitudes from ACU requirements</a>.  <em>Fortschritte der Physik</em> <strong>28</strong> no. 4, pages 201-235, 1980.</dd>
        <dt id="Schwarz:82a">[Schwarz:82a] F.&nbsp;Schwarz.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0010-4655(82)90072-8">A REDUCE package for determining Lie symmetries of ordinary and partial differential equations</a>. <em>Computer Physics Communications</em> <strong>27</strong> no. 2, pages 179-186, 1982.</dd>
        <dt id="Schwarz:82">[Schwarz:82] F.&nbsp;Schwarz.</dt>
        <dd><a href="http://jpsj.ipap.jp/link?JPSJ/51/2387/">Symmetries of the two dimensional Korteweg-De Vries equation</a>. <em>J. Phys. Soc. Japan</em> <strong>51</strong> no. 8, pages 2387-2388, 1982.</dd>
        <dt id="Schwarz:84">[Schwarz:84] F.&nbsp;Schwarz.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0167-2789(84)90447-0">The Riquier-Janet theory and its application to nonlinear evolution equations</a>. <em>Physica D</em>
            <strong>11</strong> no. 1-2, pages 243-251, 1984.</dd>
        <dt id="Schwarz:85">[Schwarz:85] F.&nbsp;Schwarz.</dt>
        <dd><a href="http://dx.doi.org/10.1007/BF02259838">Automatically determining symmetries of partial differential equations</a>. <em>Computing</em> <strong>34</strong> no. 2, pages 91-106, November 1985.</dd>
        <dt id="Schwarz:86">[Schwarz:86] F.&nbsp;Schwarz.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0010-4655(86)90138-4">A REDUCE package for determining first integrals of autonomous systems of ordinary differential equations</a>. <em>Computer Physics Communications</em> <strong>39</strong> no. 2, pages 285-296, 1986.</dd>
        <dt id="Schwarz:87">[Schwarz:87] F.&nbsp;Schwarz.</dt>
        <dd>Symmetries and involution systems: Some experiments in computer algebra. In: <em>Topics in Soliton Theory and Exactly Solvable Nonlinear Equations</em>, Singapore, August 1987. World Science Press.</dd>
        <dt id="Schwarz:88">[Schwarz:88] F.&nbsp;Schwarz.</dt>
        <dd><a href="http://link.aip.org/link/?SIR/30/450/1">Symmetries of differential equations: From Sophus Lie to computer algebra</a>. <em>SIAM Review</em> <strong>30</strong> no. 3, pages 450-481, 1988.</dd>
        <dt id="Schwarz:94">[Schwarz:94] F.&nbsp;Schwarz.</dt>
        <dd><a href="http://doi.acm.org/10.1145/182130.182132">Efficient factorization of linear ODE&apos;s</a>. <em>SIGSAM Bulletin</em> <strong>28</strong> no. 1, pages 9-17, March 1994.</dd>
        <dt id="Schwarz:84a">[Schwarz:84a] F.&nbsp;Schwarz and W.&nbsp;H. Steeb.</dt>
        <dd><a href="http://dx.doi.org/10.1088/0305-4470/17/15/001">Symmetries and first integrals for dissipative systems</a>. <em>J. Phys. A: Math. Gen.</em> <strong>17</strong> no. 15, pages L819-L823, 1984.</dd>
        <dt id="Schwarz:83a">[Schwarz:83a] Fritz Schwarz.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-12868-9_90">Automatically determining symmetries of ordinary differential equations</a>. In: <em>Proc. EUROCAL 1983, Lecture Notes in Computer Science</em>, volume 162, pages 45-54. Springer-Verlag, 1983.</dd>
        <dt id="Schwarz:83">[Schwarz:83] Fritz Schwarz.</dt>
        <dd><a href="http://doi.acm.org/10.1145/1089320.1089328">A REDUCE package for series analysis by Hadamard&apos;s theorem and QD schemes</a>. <em>SIGSAM Bulletin</em> <strong>17</strong> no. 1, pages 38-44, February 1983.</dd>
        <dt id="Schwarz:85a">[Schwarz:85a] Fritz Schwarz.</dt>
        <dd><a href="http://dx.doi.org/10.1006/jsco.1993.1016">An algorithm for determining polynomial first integrals of autonomous systems of ordinary differential equations</a>. <em>Journal of Symbolic Computation</em> <strong>1</strong> no. 2, pages 229-233, June 1985.</dd>
        <dt id="Scott:97">[Scott:97] T.&nbsp;C. Scott, I.&nbsp;P. Grant, M.&nbsp;B. Monagan, and V.&nbsp;R. Saunders.</dt>
        <dd>Generation of optimized FORTRAN code for molecular integrals of Gaussian-type functions. <em>Maple Technical Newsletter</em> <strong>4</strong> no. 2, pages 15-24, 1997.</dd>
        <dt id="Seiler:91">[Seiler:91] Werner&nbsp;M. Seiler.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0010-4655(91)90082-V">SUPERCALC- a REDUCE package for commutator calculations</a>. <em>Computer Physics Communications</em> <strong>66</strong> no. 2-3, pages 363-376, 1991.</dd>
        <dt id="Serdyukova:07">[Serdyukova:07] S.&nbsp;Serdyukova.</dt>
        <dd><a href="http://dx.doi.org/10.1134/S0361768807020090">Inverse problem for the two-dimensional discrete schr&ouml;dinger equation in a square</a>. <em>Programming and Computer Software</em> <strong>33</strong> no. 2, pages 117-119, March 2007.</dd>
        <dt id="Serdyukova:94">[Serdyukova:94] S.&nbsp;I. Serdyukova.</dt>
        <dd>Algebraic problem of studying difference boundary value problems stability on PC. Preprint E5-94-485, J.I.N.R., Dubna, 1994.</dd>
        <dt id="Serdyukova:95a">[Serdyukova:95a] S.&nbsp;I. Serdyukova.</dt>
        <dd>Stability study of rusanov scheme with boundary conditions on overlap of two domains by using CAS REDUCE. Preprint P5-95-202, J.I.N.R., Dubna, 1995.</dd>
        <dt id="Serdyukova:96">[Serdyukova:96] S.&nbsp;I. Serdyukova.</dt>
        <dd>A CAS REDUCE investigation of the stability of rusanov&apos;s stability of rusanov&apos;s scheme with conditions at domain joints. <em>Comp. Maths Math. Phys.</em> <strong>36</strong> no. 8, pages 1055-1064, 1996.</dd>
        <dt id="Serdyukova:95">[Serdyukova:95] S.&nbsp;I. Serdyukova and M.&nbsp;Thun&eacute;.</dt>
        <dd>Studying the stability of difference problems on substructured domains. Preprint E5-95-381, J.I.N.R., Dubna, 1995.</dd>
        <dt id="Shablygin:87">[Shablygin:87] E.&nbsp;Shablygin.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-51517-8_112">Integral equation with hidden eigenparameter solver: REDUCE and FORTRAN in tandem</a>. In: <em>Proc. EUROCAL &apos;87, Lecture Notes in Computer Science</em>, volume 378, pages 186-191. Springer-Verlag, 1987.</dd>
        <dt id="Shevshenko:08">[Shevshenko:08] I.I. Shevchenko.</dt>
        <dd><a href="http://dx.doi.org/10.1016/j.cpc.2007.12.001">Symbolic computation of the birkhoff normal form in the problem of stability of the triangular libration points</a>. <em>Computer Physics Communications</em> <strong>178</strong> no. 9, pages 665-672, May 2008.</dd>
        <dt id="Shmueli:83a">[Shmueli:83a] U.&nbsp;Shmueli and U.&nbsp;Kaldor.</dt>
        <dd><a href="http://dx.doi.org/10.1107/S0108767383001282">Moments of the trigonometric structure factor</a>. <em>Acta Cryst. A</em> <strong>39</strong>, pages 615-621, 1983.</dd>
        <dt id="Shmueli:83">[Shmueli:83] U.&nbsp;Shmueli and A.&nbsp;J.&nbsp;C. Wilson.</dt>
        <dd><a href="http://dx.doi.org/10.1107/S0108767383000501">Generalized intensity statistics: The subcentric distribution and effects of dispersion</a>. <em>Acta Cryst. A</em> <strong>39</strong>, pages 225-233, 1983.</dd>
        <dt id="Shtokhamer:75">[Shtokhamer:75] R.&nbsp;Shtokhamer.</dt>
        <dd>Canonical form of polynomials in the presence of side relations. Technical Report Technion-PH-76-25, Technion, 1975.</dd>
        <dt id="Shtokhamer:77">[Shtokhamer:77] R.&nbsp;Shtokhamer.</dt>
        <dd>The use of &ldquo;LET&rdquo; statements in producing short comprehended outputs. Technical Report Technion-PH-77-36, Department of Physics, Technion-Israel Institute of Technology, Haifa, Israel, 1977.</dd>
        <dt id="Silagadze:06">[Silagadze:06] Z.&nbsp;K. Silagadze.</dt>
        <dd><a href="http://arxiv.org/abs/hep-ph/0606284">Two-photon contributions to e<sup>+</sup>e<sup>-</sup>&rarr;&eta;&gamma; and e<sup>+</sup>e<sup>-</sup>&rarr; &eta;&apos;&gamma;</a>. <em>Physical Review D (Particles and Fields)</em> <strong>74</strong> no. 5, page 054003, 2006.</dd>
        <dt id="Smit:79">[Smit:79] J.&nbsp;Smit.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-09519-5_61">New recursive minor expansion algorithms, a presentation in a comparative context</a>. In: <em>Proc. EUROSAM 1979</em>, <em>Lecture Notes in Computer Science</em>&nbsp;72, pages 74-87. Springer-Verlag, 1979.</dd>
        <dt id="Smit:87">[Smit:87] J.&nbsp;Smit, S.&nbsp;H Gerez, and R.&nbsp;Mulder.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-51517-8_104">Application of a structured LISP system to computer algebra</a>. In: <em>Proc. EUROCAL &apos;87, Lecture Notes in Computer Science</em>, volume 378, pages 149-160. Springer-Verlag, 1987.</dd>
        <dt id="Smit:82">[Smit:82] J.&nbsp;Smit and J.&nbsp;A. van Hulzen.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-11607-9_33">Symbolic numeric methods in microwave technology</a>. In: <em>Proc. EUROCAM 1982</em>, <em>Lecture Notes in Computer Science</em> 144, pages 281-288. Springer-Verlag, 1982.</dd>
        <dt id="Smit:81">[Smit:81] J.&nbsp;Smit, J.&nbsp;A. van Hulzen, and B.&nbsp;J.&nbsp;A. Hulshof.</dt>
        <dd><a href="http://doi.acm.org/10.1145/1089270.1089275">NETFORM and code optimizer manual</a>. <em>SIGSAM Bulletin</em> <strong>15</strong> no. 4, pages 23-32, November 1981.</dd>
        <dt id="Soderstrand:72">[Soderstrand:72] M.&nbsp;A. Soderstrand and D.&nbsp;C. Huey.</dt>
        <dd>Sensitivities of fourth-order filters obtained by a low-pass to band-pass transformation. Report, University of California, Davis, 1972.</dd>
        <dt id="Soderstrand:74">[Soderstrand:74] M.&nbsp;A. Soderstrand and J.&nbsp;F. Lathrop.</dt>
        <dd>Two computer programs for the sensitivity analysis of higher order filters. Report SLL-73-0225, Sandia Laboratories, January 1974.</dd>
        <dt id="Soderstrand:72a">[Soderstrand:72a] M.&nbsp;A. Soderstrand and S.&nbsp;K. Mitra.</dt>
        <dd>Computer-aided sensitivity analysis of higher filters. In: <em>Proc. Second Symposium on Network Theory, Herzegnovia, Yugoslavia</em>, July 1972.</dd>
        <dt id="Sokolov:04">[Sokolov:04] V.&nbsp;V. Sokolov and T.&nbsp;Wolf.</dt>
        <dd><a href="http://dx.doi.org/10.1088/0305-4470/39/8/009">Integrable quadratic Hamiltonians on so(4) and so(3,1)</a>. <em>J. Phys. A: Math. Gen.</em> <strong>39</strong> no. 8, pages 1915-1926, 2006. arXiv, nlin.SI/0405066.</dd>
        <dt id="Sokolov:99">[Sokolov:99] V.V. Sokolov and T.&nbsp;Wolf.</dt>
        <dd><a href="http://dx.doi.org/10.1088/0266-5611/15/2/021">A symmetry test for quasilinear coupled systems</a>. <em>Inverse Problems</em> <strong>15</strong> no. 2, pages L5-L11, April 1999.</dd>
        <dt id="Sokolov:01">[Sokolov:01] V.V. Sokolov and T.&nbsp;Wolf.</dt>
        <dd><a href="http://dx.doi.org/10.1088/0305-4470/34/49/327">Classification of integrable polynomial vector evolution equations</a>. <em>J. Phys. A: Math. Gen.</em> <strong>34</strong> no. 49, pages 11139-11148, 2001.</dd>
        <dt id="Soma:77">[Soma:77] T.&nbsp;Soma.</dt>
        <dd>Relativistic aberration formulas for combined electric-magnetic focusing-deflection system. <em>Optik</em> <strong>49</strong>, pages 255-262, 1977.</dd>
        <dt id="Soma:85">[Soma:85] Takashi Soma.</dt>
        <dd>Recent applications of REDUCE in RIKEN. In: <em>Proc. of the Second RIKEN International Symposium on Symbolic and Algebraic Computation by Computers</em>, pages 181-182, Singapore, 1985. World Scientific.</dd>
        <dt id="Spiridonova:87">[Spiridonova:87] M.&nbsp;Spiridonova.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-51517-8_102">Some extensions and applications of REDUCE system</a>. In: <em>Proc. EUROCAL &apos;87, Lecture Notes in Computer Science</em>, volume 378, pages 136-137. Springer-Verlag, 1987.</dd>
        <dt id="Squire">[Squire] W.&nbsp;Squire.</dt>
        <dd>Some applications of symbolic matrix inversion. Technical report, Dept. of Mechanical and Aerospace Engineering, West Virginia University.</dd>
        <dt id="Steeb:92d">[Steeb:92d] W-H Steeb.</dt>
        <dd><a href="http://dx.doi.org/10.1142/S0129183192000919">Computer algebra and its applications in physics</a>. <em>International Journal of Modern Physics C</em> <strong>3</strong> no. 6, pages 1333-1350, December 1992.</dd>
        <dt id="Steeb:93">[Steeb:93] W-H Steeb.</dt>
        <dd><a href="http://dx.doi.org/10.1142/S0129183193000677">Fermi systems and computer algebra</a>. <em>International Journal of Modern Physics C</em> <strong>4</strong> no. 4, pages 841-846, August 1993.</dd>
        <dt id="Steeb:93a">[Steeb:93a] W.-H Steeb.</dt>
        <dd><em>Invertible Point Transformations and Nonlinear Differential Equations</em>. World Scientific Publishing, 1993.</dd>
        <dt id="Steeb:94b">[Steeb:94b] W-H Steeb.</dt>
        <dd><a href="http://dx.doi.org/10.1142/S0129183194000805">Applications of computer algebra in quantum groups</a>. <em>International Journal of Modern Physics C</em> <strong>5</strong> no. 4, pages 701-706, August 1994.</dd>
        <dt id="Steeb:94">[Steeb:94] W.-H Steeb.</dt>
        <dd><em>Chaos und Quantenchaos in dynamischen Systemen</em>. Bi-Wissenschaftsverlag, Mannheim, 1994.</dd>
        <dt id="Steeb:94c">[Steeb:94c] W-H Steeb.</dt>
        <dd>Extended Lorenz models and time dependent first integrals. <em>Zeitschrift fuer Naturforschung A</em> <strong>49</strong> no. 7-8, pages 751-753, 1994.</dd>
        <dt id="Steeb:94a">[Steeb:94a] W.-H Steeb.</dt>
        <dd><em>Quantum Mechanics using Computer Algebra</em>. World Scientific Publishing, Singapore, 1994.</dd>
        <dt id="Steeb:95">[Steeb:95] W-H Steeb.</dt>
        <dd><a href="http://dx.doi.org/10.1007/BF02187533">Bose-Fermi systems and computer algebra</a>. <em>Foundations of Physics Letters</em> <strong>8</strong> no. 1, pages 73-81, 1995.</dd>
        <dt id="Steeb:92c">[Steeb:92c] Willi-Hans Steeb.</dt>
        <dd><em>Chaos and Fractals: Algorithms and Computations</em>. BI-Wissenschaftsverlag, Mannheim, 1992.</dd>
        <dt id="Steeb:92b">[Steeb:92b] Willi-Hans Steeb and Dirk Lewien.</dt>
        <dd><em>Algorithms and Computation with REDUCE</em>. BI-Wissenschaftsverlag, Mannheim, 1992.</dd>
        <dt id="Steinberg:93">[Steinberg:93] S.&nbsp;Steinberg and R.&nbsp;Liska.</dt>
        <dd>Stability analysis and quantifier elimination. In: G.&nbsp;Jacob, N.&nbsp;E. Oussous, and S.&nbsp;Steinberg, editors, <em>Proceedings of the 1993 International IMACS Symposium on Symbolic Computation</em>, pages 62-67. IMACS, Laboratoire d&apos;Informatique Fondamentale de Lille, France, 1993.</dd>
        <dt id="Steinberg:82">[Steinberg:82] Stanly Steinberg.</dt>
        <dd><a href="http://doi.acm.org/10.1145/1089302.1089305">Mathematics and symbol manipulation</a>. <em>SIGSAM Bulletin</em> <strong>16</strong> no. 3, pages 11-15, August 1982.</dd>
        <dt id="Stephani:96">[Stephani:96] H.&nbsp;Stephani and T.&nbsp;Wolf.</dt>
        <dd><a href="http://dx.doi.org/10.1088/0264-9381/13/5/035">Spherically symmetric perfect fluids in shear-free motion - the symmetry approach</a>. <em>Classical and Quantum Gravity</em> <strong>13</strong> no. 5, pages 1261-1271, 1996.</dd>
        <dt id="Steuerwald">[Steuerwald] J.&nbsp;Steuerwald and W.&nbsp;Kerner.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0010-4655(75)90014-4">A contribution to the efficient solution of extensive symbolic computations</a>. <em>Computer Physics Communications</em> <strong>9</strong> no. 6, pages 337-349, June 1975.</dd>
        <dt id="Stoutemyer:74">[Stoutemyer:74] D.&nbsp;Stoutemyer.</dt>
        <dd><a href="http://doi.acm.org/10.1145/355719.355721">Automatic error analysis using the computer symbolic manipulation language</a>. <em>ACM Trans. Math. Softw.</em> <strong>3</strong> no. 1, pages 26-43, March 1977.</dd>
        <dt id="Stoutemyer:75">[Stoutemyer:75] David&nbsp;R. Stoutemyer.</dt>
        <dd>Symbolic computer solution of an equation in finite terms. Report UCP-33, Dept. of Comp. Science, Univ. of Utah, 1975.</dd>
        <dt id="Stoutemyer:77">[Stoutemyer:77] David&nbsp;R. Stoutemyer.</dt>
        <dd><a href="http://doi.acm.org/10.1145/355732.355734">Analytically solving integral equations by using computer algebra</a>. <em>ACM Trans. Math. Softw.</em> <strong>3</strong> no. 2, pages 128-146, June 1977.</dd>
        <dt id="Stroscio:74">[Stroscio:74] M.&nbsp;A. Stroscio and J.&nbsp;M. Holt.</dt>
        <dd><a href="http://link.aps.org/doi/10.1103/PhysRevA.10.749">Radiative corrections to the decay rate of orthopositronium</a>. <em>Phys. Rev. A</em> <strong>10</strong> no. 3, pages 749-755, September 1974.</dd>
        <dt id="Strotmann:03">[Strotmann:03] Andreas Strotmann.</dt>
        <dd><a href="http://etd.lib.fsu.edu/theses/available/etd-09042003-181524/"><em>Content markup language design principles</em></a>. PhD thesis, The Florida State University, May 2003.</dd>
        <dt id="Strotmann:00">[Strotmann:00] Andreas Strotmann and Ladislav&nbsp;J. Kohout.</dt>
        <dd><a href="http://doi.acm.org/10.1145/362001.362024">OpenMath: compositionality achieved at last</a>. <em>SIGSAM Bulletin</em> <strong>34</strong> no. 2, pages 66-72, 2000.</dd>
        <dt id="Stuart:88">[Stuart:88] Robin&nbsp;G. Stuart.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0010-4655(88)90202-0">Algebraic reduction of one-loop Feynman diagrams to scalar integrals</a>. <em>Computer Physics Communications</em> <strong>48</strong> no. 3, pages 367-389, March 1988.</dd>
        <dt id="Stuart:90">[Stuart:90] Robin&nbsp;G. Stuart and A.&nbsp;G&oacute;ngora-T.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0010-4655(90)90019-W">Algebraic reduction of one-loop Feynman diagrams to scalar integrals ii</a>. <em>Computer Physics Communications</em> <strong>56</strong> no. 3, pages 337-350, January 1990.</dd>
        <dt id="Sturm:06">[Sturm:06]</dt>
        <dd>Thomas Sturm, <a href="http://www.springerlink.com/content/16831p434v31g724"><em>Computer Algebra in Scientific Computing</em></a>, volume 4194, chapter New Domains for Applied Quantifier Elimination, pages 295-301. Springer, 2006.</dd>
        <dt id="Suppes:89">[Suppes:89] Patrick Suppes and Shuzo Takahashi.</dt>
        <dd><a href="http://dx.doi.org/10.1016/S0747-7171(89)80041-0">An interactive calculus theorem-prover for continuity properties</a>. <em>Journal of Symbolic Computation</em> <strong>7</strong> no. 6, pages 573-590, June 1989.</dd>
        <dt id="Surguladze:91">[Surguladze:91] Levan&nbsp;R. Surguladze and Mark&nbsp;A. Samuel.</dt>
        <dd><a href="http://doi.acm.org/10.1145/120694.120764">Algebraic perturbative calculations in high energy physics methods, algorithms, computer programs and physical applications</a>. In: Stephen&nbsp;M. Watt, editor, <em>Proc. of the 1991 International Symposium on Symbolic and Algebraic Computation</em>, pages 439-447, Maryland, July 1991. ACM Press.</dd>
        <dt id="Surguladze:89">[Surguladze:89] L.R. Surguladze and F.V. Tkachov.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0010-4655(89)90077-5">LOOPS: procedures for multiloop calculations in quantum field theory for the REDUCE system</a>. <em>Computer Physics Communications</em> <strong>55</strong> no. 2, pages 205-215, September 1989.</dd>
        <dt id="Suslov:99">[Suslov:99] S.&nbsp;A. Suslov and A.&nbsp;J. Roberts.</dt>
        <dd><a href="http://dx.doi.org/10.1023/A:1019169408365">Advection-dispersion in symmetric field-flow fractionation channels</a>. <em>Journal of Mathematical Chemistry</em> <strong>26</strong> no. 1-3, pages 27-46, 1999.</dd>
        <dt id="Suslov:00">[Suslov:00] S.&nbsp;A. Suslov and A.&nbsp;J. Roberts.</dt>
        <dd><a href="http://pubs.acs.org/doi/abs/10.1021/ac9915022">Modelling of sample dynamics in rectangular asymmetrical flow field-flow fractionation channels</a>. <em>Analytical Chemistry</em> <strong>72</strong> no. 18, pages 4331-4345, 2000.</dd>
    </dl>

    <dl id='T'>
        <dt id="Tallents:84">[Tallents:84] G.&nbsp;J. Tallents.</dt>
        <dd><a href="http://dx.doi.org/10.1088/0022-3700/17/18/008">The relative intensities of hydrogen-like fine structure</a>. <em>J. Phys. B: At. Mol. Phys.</em> <strong>17</strong> no. 18, pages 3677-3691, 1984.</dd>
        <dt id="Tao:90">[Tao:90] Qingsheng Tao.</dt>
        <dd><a href="http://doi.acm.org/10.1145/96877.96976">Symbolic and algebraic manipulation for formulae of interpolation and quadrature</a>. In: S.&nbsp;Watanabe and Morio Nagata, editors, <em>Proceedings of the 1990 International Symposium on Symbolic and Algebraic Computation</em>, page 306. ACM, Addison-Wesley, 1990.</dd>
        <dt id="Taraniuk:85">[Taraniuk:85] Michael Taraniuk1 and Peter Mackeonis.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-15984-3_233">Demonstration of reduce3 as implemented on a stand-alone motorola 68000 based microcomputer</a>. In: <em>Proc. EUROCAL 1985, Lecture Notes in Computer Science</em>, volume 204, page&nbsp;31. Springer-Verlag, 1985.</dd>
        <dt id="Tasso:76">[Tasso:76] H.&nbsp;Tasso and J.&nbsp;Steuerwald.</dt>
        <dd>Subroutine for series solutions of linear differential equations. Technical Report IPP 6/143, Max Planck Institut for Plasmaphysik, 1976.</dd>
        <dt id="Thas:89">[Thas:89] C.&nbsp;Thas.</dt>
        <dd>A collection of REDUCE and MACSYMA programs about college geometry. part 1. Technical Report&nbsp;5, State University of Gent, September 1989.</dd>
        <dt id="Thas:89a">[Thas:89a] C.&nbsp;Thas.</dt>
        <dd>A collection of REDUCE and MACSYMA programs about college geometry. part 2. Technical Report&nbsp;5, State University of Gent, September 1989.</dd>
        <dt id="Timoshkova:05">[Timoshkova:05] E.&nbsp;I. Timoshkova and S.&nbsp;Yu Vernov.</dt>
        <dd><a href="http://www.citebase.org/abstract?id=oai:arXiv.org:math-ph/0402049">On two nonintegrable cases of the generalized henon-heiles system with an additional nonpolynomial term</a>. <em>YAD.FIZ.</em> <strong>68</strong>, page 2008, 2005.</dd>
        <dt id="Todd:88">[Todd:88] P.&nbsp;H. Todd and G.&nbsp;W. Cherry.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-51084-2_33">Symbolic analysis of planar drawings</a>. In: <em>Proc. of ISSAC &apos;88</em>, volume 358, pages 344-355. Springer-Verlag, 1988.</dd>
        <dt id="Toth:86">[Toth:86] K.&nbsp;T&oacute;th, K.&nbsp;Szeg&ouml;, and A.&nbsp;Margaritis.</dt>
        <dd><a href="http://link.aps.org/doi/10.1103/PhysRevD.33.3306">Radiative corrections for semileptonic decays of Hyperons: `Model-Independent&apos; Part</a>. <em>Physical Review D (Particles and Fields)</em> <strong>33</strong> no. 11, pages 3306-3315, June 1986.</dd>
        <dt id="Tournier:79">[Tournier:79] Evelyne Tournier.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-09519-5_68">An algebraic form of a solution of a system of linear differential equations with constant coefficients</a>. In: <em>Proc. EUROSAM 1979, Lecture Notes in Computer Science</em>, volume&nbsp;72, pages 153-163. Springer-Verlag, 1979.</dd>
        <dt id="Tournier:87">[Tournier:87] Evelyne Tournier.</dt>
        <dd><em>Solutions Formelles D&apos;Equations Differentielles, le Logiciel de Calcul Formel: DESIR Etude Theorique et Realisation</em>. PhD thesis, L&apos;Universit&eacute; Scientifique, Technologique et Medicale de Grenoble, April 1987.</dd>
        <dt id="Trenkov:91">[Trenkov:91] I.&nbsp;Trenkov, M.&nbsp;Spiridonova, and M.&nbsp;Daskalova.</dt>
        <dd><a href="http://doi.acm.org/10.1145/120694.120765">An application of the REDUCE system for solving a mathematical geodesy problem</a>. In: Stephen&nbsp;M. Watt, editor, <em>Proc. of the 1991 International Symposium on Symbolic and Algebraic Computation</em>, pages 448-449, Maryland, July 1991. ACM Press.</dd>
        <dt id="Triulzi:00">[Triulzi:00] A.&nbsp;Triulzi and T.&nbsp;Wolf.</dt>
        <dd><a href="http://lie.math.brocku.ca/twolf/papers/sub.ps">Recognizing overdetermined subsystems of systems of equations</a>. 2000.</dd>
        <dt id="Triulzi:00a">[Triulzi:00a] Arrigo Triulzi.</dt>
        <dd><a href="http://doi.acm.org/10.1145/362001.362017">OpenMath support under CSL-hosted REDUCE</a>. <em>SIGSAM Bulletin - Special issue on OpenMath</em> <strong>2</strong> no. 34, pages 27-30, 2000.</dd>
        <dt id="Trotter:89">[Trotter:89] H.&nbsp;F. Trotter.</dt>
        <dd>Use of symbolic methods in analyzing an integral operator. In: E.&nbsp;Kaltofen and S.&nbsp;M. Watt, editors, <em>Proc. of Computers and Mathematics &apos;89</em>, pages 82-90. Springer-Verlag, New York, 1989.</dd>
        <dt id="Tsai:74">[Tsai:74] Y.&nbsp;S. Tsai.</dt>
        <dd><a href="http://link.aps.org/doi/10.1103/RevModPhys.46.815">Pair production and bremsstrahlung of charged leptons</a>. <em>Rev. Mod. Phys.</em> <strong>46</strong> no. 4, pages 815-851, October 1974.</dd>
        <dt id="Tsai:65">[Tsai:65] Y.&nbsp;S. Tsai and A.&nbsp;C. Hearn.</dt>
        <dd><a href="http://link.aps.org/doi/10.1103/PhysRev.140.B721">Differential cross-section for e<sup>+</sup> + e<sup>-</sup> &rarr; W<sup>+</sup> + W<sup>-</sup> &rarr; e<sup>-</sup> + <span style="text-decoration: overline;">&nu;</span><sub>e</sub> + &mu;<sup>+</sup> + &nu;<sub>&mu;</sub></a>. <em>Phys. Rev. B</em> <strong>140</strong>, pages B721-B729, 1965.</dd>
        <dt id="Tsuchida:05">[Tsuchida:05] T.&nbsp;Tsuchida and T.&nbsp;Wolf.</dt>
        <dd><a href="http://dx.doi.org/10.1088/0305-4470/38/35/006">Classification of polynomial integrable systems of mixed scalar and vector evolution equations. i</a>. <em>J. Phys. A: Math. Gen.</em> <strong>38</strong> no. 35, pages 7691-7733, 2005. also as preprint nlin.SI/0412003.</dd>
    </dl>

    <dl id='U'>
        <dt id="Ucoluk:82">[Ucoluk:82] G.&nbsp;&Uuml;&ccedil;oluk and A.&nbsp;Hacinliyan.</dt>
        <dd><a href="http://doi.acm.org/10.1145/1089292.1089295">A proposal for extensions to REDUCE</a>. <em>SIGSAM Bulletin</em> <strong>16</strong> no. 2, pages 4-14, May 1982.</dd>
        <dt id="Ueberberg:92">[Ueberberg:92] Johannes Ueberberg.</dt>
        <dd><em>Einf&uuml;hrung in die Computeralgebra mit REDUCE</em>. BI-Wissenschaftsverlag, Mannheim, 1992.</dd>
        <dt id="Ukolov:04">[Ukolov:04] Yu.&nbsp;A. Ukolov, N.&nbsp;A. Chekanov, A.&nbsp;A. Gusev, V.&nbsp;A. Rostovtsev, S.&nbsp;I. Vinitsky, and Y.&nbsp;Uwano.</dt>
        <dd><a href="http://dx.doi.org/doi:10.1016/j.cpc.2004.10.010">A reduce program for the normalization of polynomial hamiltonians</a>. <em>Computer Physics Communications</em> <strong>166</strong> no. 1, pages 66-80, 2004.</dd>
        <dt id="Umeno:89">[Umeno:89] Takaji Umeno, Syuichi Yamashita, Osami Saito, and Kenichi Abe.</dt>
        <dd>Symbolic computation application for the design of linear multivariable control systems. <em>Journal of Symbolic Computation</em> <strong>8</strong> no. 6, pages 581-588, December 1989.</dd>
        <dt id="Urintsev:91">[Urintsev:91] A.L. Urintsev and A.V. Samoilov.</dt>
        <dd>Complex reduce-programs for analytic solution of some problems of beam transport systems. In: D.V. Shirkov, V.A. Rostovtsev, and V.P. Gerdt, editors, <em>In: 4th International Conference on Computer Algebra in Physical Research</em>, pages 438-442, Singapore, New Jersey, London, Hong Kong, 1991. World Scientific.</dd>
    </dl>

    <dl id='V'>
        <dt id="vandenHeuvel:87a">[vandenHeuvel:87a] P.&nbsp;van&nbsp;den Heuvel, B.&nbsp;J.&nbsp;A. Hulshof, and J.&nbsp;A. van Hulzen.</dt>
        <dd><a href="http://doi.acm.org/10.1145/24559.24561">Some simple pretty-print facilities for REDUCE</a>. <em>SIGSAM Bulletin</em> <strong>21</strong> no. 1, pages 14-17, February 1987.</dd>
        <dt id="vandenHeuvel:87">[vandenHeuvel:87] P.&nbsp;van&nbsp;den Heuvel, J.&nbsp;A. van Hulzen, and V.&nbsp;V. Goldman.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-51517-8_99">Automatic generation of FORTRAN-coded Jacobians and Hessians</a>. In: <em>Proc. EUROCAL &apos;87, Lecture Notes in Computer Science</em>, volume 378, pages 120-131. Springer-Verlag, 1987.</dd>
        <dt id="vandenHeuvel:86">[vandenHeuvel:86] Pim van&nbsp;den Heuvel.</dt>
        <dd><a href="http://doi.acm.org/10.1145/12917.12918">Adding statements to REDUCE</a>. <em>SIGSAM Bulletin</em> <strong>20</strong> no. 1 and 2, pages 8-14, February and May 1986.</dd>
        <dt id="vandenHeuvel:86a">[vandenHeuvel:86a] Pim van&nbsp;den Heuvel.</dt>
        <dd>Some experiments in REDUCE related to the calculation of Groebner bases. Technical report, Department of Computer Science, Twente University of Technology, The Netherlands, June 1986.</dd>
        <dt id="vanderHoeven:04">[vanderHoeven:04] Joris van&nbsp;der Hoeven.</dt>
        <dd><a href="http://dx.doi.org/10.1145/980175.980186">GNU TeXmacs</a>. <em>SIGSAM Bulletin</em> <strong>38</strong> no. 1, pages 24-25, 2004.</dd>
        <dt id="vanHeerwaarden">[vanHeerwaarden] M.&nbsp;C. van Heerwaarden and J.&nbsp;A. van Hulzen.</dt>
        <dd>Pretty print facilities for REDUCE. Memorandum INF-88-36, Department of Computer Science, University of Twente, The Netherlands, August 1988.</dd>
        <dt id="vanHulzen:80">[vanHulzen:80] J.&nbsp;A. van Hulzen.</dt>
        <dd><a href="http://doi.acm.org/10.1145/1089220.1089227">Computational problems in producing Taylor coefficients for the rotating disk problem</a>. <em>SIGSAM Bulletin</em> <strong>14</strong> no. 2, pages 36-49, May 1980.</dd>
        <dt id="vanHulzen:81">[vanHulzen:81] J.&nbsp;A. van Hulzen.</dt>
        <dd>Breuer&apos;s grow factor algorithm in computer algebra. Memorandum 332, Department of Applied Mathematics, Twente University of Technology, The Netherlands, April 1981.</dd>
        <dt id="vanHulzen:82a">[vanHulzen:82a] J.&nbsp;A. van Hulzen.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-11607-9_19">Computer algebra systems viewed by a notorious user</a>. In: <em>Computer Algebra (EUROCAM &apos;82, European Computer Algebra Conference Marseille, France 5-7 April 1982)</em>, <em>Lecture Notes in Computer Science</em> 144, pages 166-180. Springer Berlin / Heidelberg, 1982.</dd>
        <dt id="vanHulzen:83a">[vanHulzen:83a] J.&nbsp;A. van Hulzen.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-12868-9_112">Code optimization of multivariate polynomial schemes: A pragmatic approach</a>. In: <em>Proc. EUROCAL 1983, Lecture Notes in Computer Science</em>, volume 162, pages 286-300. Springer-Verlag, 1983.</dd>
        <dt id="vanHulzen:87">[vanHulzen:87] J.&nbsp;A. van Hulzen.</dt>
        <dd>Program generation aspects of the symbolic-numeric interface. In: <em>Proc. Third Intern. Conf. on Computer Algebra and its applications in Theor. Phys, 1985</em>, pages 104-113. J.I.N.R., Dubna, USSR, 1987.</dd>
        <dt id="vanHulzen:88">[vanHulzen:88] J.&nbsp;A. van Hulzen.</dt>
        <dd>Formule manipulatie m.b.v. REDUCE (in Dutch). Technical report, Department of Computer Science, Twente University of Technology, The Netherlands, October 1988.</dd>
        <dt id="vanHulzen:89a">[vanHulzen:89a] J.&nbsp;A. van Hulzen.</dt>
        <dd>Computer algebra and numerical mathematics: The odd couple? Technical Report Informatica 89-40, Department of Computer Science, Twente University of Technology, The Netherlands, June 1989.</dd>
        <dt id="vanHulzen:83">[vanHulzen:83] J.&nbsp;A. van Hulzen and J.&nbsp;Calmet.</dt>
        <dd>Computer algebra systems. In: B.&nbsp;Buchberger, G.&nbsp;E. Collins, R.&nbsp;Loos, and R.&nbsp;Albrecht, editors, <em>Computer Algebra and Symbolic and Algebraic Computation</em>. Springer-Verlag, 2nd edition, 1983.</dd>
        <dt id="vanHulzen:82">[vanHulzen:82] J.&nbsp;A. van Hulzen and B.&nbsp;J.&nbsp;A. Hulshof.</dt>
        <dd><a href="http://doi.acm.org/10.1145/1089310.1089318">An expression analysis package for REDUCE</a>. <em>SIGSAM Bulletin</em> <strong>16</strong> no. 4, pages 32-44, November 1982.</dd>
        <dt id="vanHulzen:89">[vanHulzen:89] J.&nbsp;A. van Hulzen, B.&nbsp;J.&nbsp;A. Hulshof, B.&nbsp;L. Gates, and M.&nbsp;C.&nbsp;Van Heerwaarden.</dt>
        <dd><a href="http://doi.acm.org/10.1145/74540.74561">A code optimization package for REDUCE</a>. In: <em>Proc. of ISSAC &apos;89</em>, pages 163-170. ACM Press, New York, 1989.</dd>
        <dt id="Vega:91">[Vega:91] Laureano&nbsp;Gonz&aacute;lez Vega.</dt>
        <dd><a href="http://doi.acm.org/10.1145/120694.120755">Working with real algebraic plane curves in REDUCE: the GCUR package</a>. In: Stephen&nbsp;M. Watt, editor, <em>Proc. of the 1991 International Symposium on Symbolic and Algebraic Computation</em>, pages 397-402, Maryland, July 1991. ACM Press.</dd>
        <dt id="Vernov:04">[Vernov:04] S.Y. Vernov.</dt>
        <dd><a href="http://arxiv.org/abs/nlin/0407062">Construction of solutions for nonintegrable systems with the help of the painlev&eacute; test</a>. In: <em>Computational Science - ICCS 2004</em>, <em>Lecture Notes in Computer Science</em> 3039, pages 382-387. Springer, 2004.</dd>
        <dt id="Vernov:05">[Vernov:05] S.Yu. Vernov.</dt>
        <dd><a href="http://dx.doi.org/10.1007/11555964_39">Interdependence between the laurent-series and elliptic solutions of nonintegrable system</a>. In: <em>Computer Algebra in Scientific Computing</em>, <em>Lecture Notes in Computer Science</em> 3718, pages 457-468. Springer, 2005.</dd>
        <dt id="Vinitsky:87">[Vinitsky:87] S.&nbsp;I. Vinitsky and V.&nbsp;A. Rostovtsev.</dt>
        <dd>A use of REDUCE system in problems of hydrogen atom in an electric field. Preprint P11-87-303, J.I.N.R., Dubna, 1987.</dd>
        <dt id="Viry:93">[Viry:93] Guy Viry.</dt>
        <dd><a href="http://dx.doi.org/10.1006/jsco.1993.1027">Factorization of multivariate polynomials with coefficients in F<sub>p</sub></a>. <em>Journal of Symbolic Computation</em> <strong>15</strong> no. 4, pages 371-391, November 1993.</dd>
        <dt id="Voros:77">[Voros:77] A.&nbsp;Voros.</dt>
        <dd>Asymptotic k-expansions of stationary quantum states. <em>Ann. Inst. H. Poincare</em> <strong>26A</strong>, 1977.</dd>
        <dt id="DeVos:89">[DeVos:89] Alexis&nbsp;De Vos.</dt>
        <dd>The use of Reduce in solar energy conversion theory. Reports of the CAGe Project&nbsp;4, State University of Gent, CAGe Computer Algebra Group, August 1989.
        </dd>
        <dt id="DeVos:93">[DeVos:93] Alexis&nbsp;De Vos.</dt>
        <dd>Carnot engines, Gr&ouml;bner bases and all the winds on the earth. The CAGe Reports&nbsp;9, University of Gent, CAGe Computer Algebra Group, March 1993.</dd>
        <dt id="Vulcanov:94">[Vulcanov:94] D.&nbsp;N. Vulcanov.</dt>
        <dd><a href="http://dx.doi.org/10.1142/S0129183194001082">Adm formalism applied to some space-time models using excalc algebraic programming</a>. <em>International Journal of Modern Physics C</em> <strong>5</strong> no. 6, pages 973-985, December 1994.</dd>
        <dt id="Vulcanov:95">[Vulcanov:95] D.&nbsp;N. Vulcanov.</dt>
        <dd><a href="http://dx.doi.org/10.1142/S012918319500023X">Algebraic programming in the hamiltonian treatment of an inflationary models</a>. <em>International Journal of Modern Physics C</em> <strong>6</strong> no. 3, pages 317-326, 1995.</dd>
        <dt id="Vulcanov:96">[Vulcanov:96] D.&nbsp;N. Vulcanov.</dt>
        <dd><a href="http://www.springer.com/astronomy/general+relativity/book/978-3-540-60361-0">Algebraic programming in the canonical version of general relativity</a>. In: F.W. Hehl, R.&nbsp;Puntigam, and H.&nbsp;Ruder, editors, <em>Relativity and Scientific Computing</em>, pages 259-269. Springer Verlag, 1996.</dd>
        <dt id="Vulcanov:98">[Vulcanov:98] D.&nbsp;N. Vulcanov.</dt>
        <dd><a href="http://dx.doi.org/10.1142/S0129183198000091">Algebraic programming in the hamiltonian treatment of the einstein-maxwell equations</a>. <em>International Journal of Modern Physics C</em> <strong>9</strong> no. 1, pages 103-111, February 1998.</dd>
        <dt id="Vulcanov:2003">[Vulcanov:2003] D.&nbsp;N. Vulcanov.</dt>
        <dd><a href="http://dx.doi.org/10.1016/S0010-4655(03)00344-8">Calculation of the dirac equation in curved space-times with possible torsion using maple and reduce</a>. <em>Computer Physics Communications</em> <strong>154</strong> no. 3, pages 205-218, 2003.</dd>
        <dt id="Vulcanov:97">[Vulcanov:97] D.&nbsp;N. Vulcanov and I.&nbsp;I. Cotaescu.</dt>
        <dd><a href="http://dx.doi.org/10.1142/S0129183197000291">Dirac field gravity inertial effects and computer algebra</a>. <em>International Journal of Modern Physics C</em> <strong>8</strong> no. 2, pages 345-359, 1997.</dd>
    </dl>

    <dl id='W'>
        <dt id="Wanas">[Wanas] M.&nbsp;I. Wanas.</dt>
        <dd>The third face of computer - computer solution of symbolic problems. Technical Report CAP-3 837, Military Technical College, Cairo, Egypt.</dd>
        <dt id="Wanas:85">[Wanas:85] M.&nbsp;I. Wanas.</dt>
        <dd>Manipulation of parameters indicating the physical significance of any absolute parallelism space using REDUCE 2. In: <em>Tenth International Congress for Statistics, Computer Science, Social and Demographic Research</em>, 1985.</dd>
        <dt id="Wang:93">[Wang:93] Jian-Xiong Wang.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0010-4655(93)90010-A">Automatic calculation of Feynman loop-diagrams, i. generation of a simplified form of the amplitude</a>. <em>Computer Physics Communications</em> <strong>77</strong> no. 2, pages 263-285, October 1993.</dd>
        <dt id="Wang:84">[Wang:84] Paul&nbsp;S. Wang, T.&nbsp;Y.&nbsp;P. Chang, and J.&nbsp;A. van Hulzen.</dt>
        <dd><a href="http://dx.doi.org/10.1007/BFb0032846">Code generation and optimization for finite element analysis</a>. In: <em>Proc. EUROSAM 1984</em>, <em>Lecture Notes in Computer Science</em> 174, pages 237-247. Springer-Verlag, 1984.</dd>
        <dt id="Wassam:87">[Wassam:87] W.&nbsp;A. Wassam, Jr. and Go. Torres-Vega.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0009-2614(87)87152-X">Dual Lanczos transformation theory: Closed set of algebraic equations connecting Lanczos parameters with moments in moment expansions of time-dependent quantities</a>. <em>Chemical Phys. Lett.</em> <strong>134</strong> no. 4, pages 355-360, March 1987.</dd>
        <dt id="Wassam:87a">[Wassam:87a] W.&nbsp;A. Wassam, Jr., Go. Torres-Vega, and J.&nbsp;Neito-Frausto.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0009-2614(87)87292-5">Dual Lanczos transformation theory: Exact continued fraction expression for resonant &gamma;-ray absorption spectrum of a harmonically bound atom executing classical motion described by Smoluchowski dynamics</a>. <em>Chemical Phys. Lett.</em> <strong>136</strong> no. 1, pages 26-30, April 1987.</dd>
        <dt id="Watanabe:76">[Watanabe:76] Shunro Watanabe.</dt>
        <dd>Formula manipulations solving linear ordinary differential equations II. <em>Publications of the Research Institute for Mathematical Sciences, Kyoto University</em> <strong>11</strong> no. 2, pages 297-337, 1976.</dd>
        <dt id="Watanabe:79">[Watanabe:79] Shunro Watanabe.</dt>
        <dd>A verification for non-existence of movable branch points of six painlev&eacute; transcendents by formula manipulations. <em>Tokyo Journal of Mathematics</em> <strong>2</strong> no. 2, pages 285-291, 1979.</dd>
        <dt id="Watanabe:85">[Watanabe:85] Yoichi Watanabe.</dt>
        <dd>Symbolic manipulation of structure functions in availability analysis. Technical Report UWFDM-658, Fusion Technology Institute, University of Wisconsin, Madison, Wisconsin, November 1985.</dd>
        <dt id="Watt:94a">[Watt:94a] S.D. Watt and A.J. Roberts.</dt>
        <dd><a href="http://arxiv.org/abs/chao-dyn/9412002v1">The construction of zonal models of dispersion in channels via matching centre manifolds</a>. <em>J. Austral. Math. Soc. B</em> <strong>38</strong>, pages 101-125, 1994.</dd>
        <dt id="Watt:94">[Watt:94] S.D. Watt and A.J. Roberts.</dt>
        <dd><a href="http://link.aip.org/link/?SMM/55/1016/1">The accurate dynamic modelling of contaminant dispersion in channels</a>. <em>SIAM J. Appl. Math.</em> <strong>55</strong> no. 4, pages 1016-1038, 1995.</dd>
        <dt id="Weber:79">[Weber:79] Lawrence&nbsp;A. Weber and Gerhard Rayna.</dt>
        <dd><a href="http://doi.acm.org/10.1145/1089176.1089180">Problem #11 solved in REDUCE: a case study in program translation</a>. <em>SIGSAM Bulletin</em> <strong>13</strong> no. 4, pages 21-24, November 1979.</dd>
        <dt id="Wehner:86">[Wehner:86] M.&nbsp;F. Wehner and W.&nbsp;G. Wolfer.</dt>
        <dd><a href="http://www.springerlink.com/content/m75089177231pq45/?p=cd4e87257af2456680d633ef900ebf59&pi=12">The pressure of a hard sphere fluid on a curved surface</a>. <em>J. Statistical Phys.</em> <strong>42</strong> no. 3-4, pages 509-521, 1986.</dd>
        <dt id="Weispfenning:92">[Weispfenning:92] Volker Weispfenning.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0747-7171(92)90023-W">Comprehensive Gr&ouml;bner bases</a>. <em>Journal of Symbolic Computation</em> <strong>14</strong> no. 1, pages 1-29, July 1992.</dd>
        <dt id="Weispfenning:94">[Weispfenning:94] Volker Weispfenning.</dt>
        <dd><a href="http://doi.acm.org/10.1145/190347.190425">Quantifier elimination for real algebra - the cubic case</a>. In: <em>Symbolic and Algebraic Computation</em>, ISSAC, pages 258-263. SIGSAM, ACM, 1994.</dd>
        <dt id="Winkelmann:89">[Winkelmann:89] Volker Winkelmann and Friedrich&nbsp;W. Hehl.</dt>
        <dd>REDUCE for beginners. six lectures on the application of computer algebra. In: D.&nbsp;Stauffer, F.&nbsp;W. Hehl, V.&nbsp;Winkelmann, and J.&nbsp;G. Zabolitzky, editors, <em>Computer Simulation and Computer Algebra. Lectures for Beginners</em>, chapter&nbsp;3. Springer-Verlag, 2nd edition, 1989.</dd>
        <dt id="Winkler:88">[Winkler:88] F.&nbsp;Winkler, B.&nbsp;Kutzler, and F.&nbsp;Lichtenberger.</dt>
        <dd>Computeralgebrasysteme (in German). Report 88-10, RISC - LINZ, Austria, 1988.</dd>
        <dt id="Witham:77">[Witham:77] C.&nbsp;R. Witham and S.&nbsp;Dubowsky.</dt>
        <dd>An improved symbolic manipulation technique for the simulation of nonlinear dynamic systems with mixed time-varying and constant terms. <em>Journal of Dynamic Systems, Measurement, and Control</em> pages 157-165, September 1977.</dd>
        <dt id="Wolf:89">[Wolf:89] T.&nbsp;Wolf.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-51517-8_157">A package for the analytic investigation and exact solution of differential equations</a>. <em>Proc. EUROCAL 87, Lect. Notes in Comp. Sci.</em> <strong>378</strong>, pages 479-490, 1989.</dd>
        <dt id="Wolf:93">[Wolf:93] T.&nbsp;Wolf.</dt>
        <dd>An efficiency improved program liepde for determining lie-symmetries of pdes. In: <em>Proc. of Modern Group Analysis: advanced analytical and computational methods in mathematical physics, Catania, Italy, October 1992</em>, pages 377-385. Kluwer Academic Publishers, 1993.</dd>
        <dt id="Wolf:95a">[Wolf:95a] T.&nbsp;Wolf.</dt>
        <dd><a href="http://doi.acm.org/10.1145/220346.220348">Programs for applying symmetries of pdes</a>. In: <em>Proceedings of ISSAC 95 in Montreal</em>, pages 7-15. ACM Press, 1995.</dd>
        <dt id="Wolf:95b">[Wolf:95b] T.&nbsp;Wolf.</dt>
        <dd><a href="http://www.springer.com/astronomy/general+relativity/book/978-3-540-60361-0">The program crack for solving PDEs in general relativity</a>. In: F.W. Hehl, R.A. Puntigam, and H.&nbsp;Ruder, editors, <em>Relativity and Scientific Computing: Computer Algebra, Numerics, Visualization</em>, pages 241-258. Springer Verlag, 1996.</dd>
        <dt id="Wolf:98a">[Wolf:98a] T.&nbsp;Wolf.</dt>
        <dd><a href="http://dx.doi.org/10.1016/S0010-4655(98)00123-4">Structural equations for Killing tensors of arbitrary rank</a>. <em>Computer Physics Communications</em> <strong>115</strong> no. 2-3, pages 316-329, 1998.</dd>
        <dt id="Wolf:99a">[Wolf:99a] T.&nbsp;Wolf.</dt>
        <dd><a href="http://dx.doi.org/10.1006/jsco.2000.1069">The symbolic integration of exact PDEs</a>. <em>Journal of Symbolic Computation</em> <strong>30</strong> no. 5, pages 619-629, 2000.</dd>
        <dt id="Wolf:99d">[Wolf:99d] T.&nbsp;Wolf.</dt>
        <dd><a href="http://dx.doi.org/doi:10.1017/S0956792501004715">A comparison of four approaches to the calculation of conservation laws</a>. <em>Euro. Jnl of Applied Mathematics</em> <strong>13</strong> no. 2, pages 129-152, 2002.</dd>
        <dt id="Wolf:98c">[Wolf:98c] T.&nbsp;Wolf.</dt>
        <dd><a href="http://www.springer.com/math/cse/book/978-3-540-65466-7"><em>Conservation Laws for Geodesic Motion in Curved Spaces and PDEs</em></a>, chapter 3.1.5.1, pages 187-190. Springer, 2002.</dd>
        <dt id="Wolf:98b">[Wolf:98b] T.&nbsp;Wolf.</dt>
        <dd><a href="http://www.springer.com/math/cse/book/978-3-540-65466-7"><em>Crack, LiePDE, ApplySym and ConLaw</em></a>, chapter 4.3.5 and on CD-ROM, pages 465-468. Springer, 2002.</dd>
        <dt id="Wolf:99">[Wolf:99] T.&nbsp;Wolf.</dt>
        <dd><a href="http://dx.doi.org/10.1006/jsco.2001.0509">Size reduction and partial decoupling of systems of equations</a>. <em>Journal of Symbolic Computation</em> <strong>33</strong> no. 3, pages 367-383, 2002.</dd>
        <dt id="Wolf:02a">[Wolf:02a] T.&nbsp;Wolf.</dt>
        <dd><a href="http://dx.doi.org/10.1016/S0747-7171(03)00020-8">The integration of systems of linear pdes using conservation laws of syzygies</a>. <em>Journal of Symbolic Computation</em> <strong>35</strong> no. 5, pages 499-526, 2003.</dd>
        <dt id="Wolf:02">[Wolf:02] T.&nbsp;Wolf.</dt>
        <dd><a href="http://arxiv.org/abs/nlin/0301032">Applications of crack in the classification of integrable systems</a>. In: <em>CRM Proceedings and Lecture Notes</em>, volume&nbsp;37, pages 283-300, Montreal, 2004. Centre de Recherches Mathematiques. also preprint on arXiv: nlin.SI/0301032.</dd>
        <dt id="Wolf:04b">[Wolf:04b] T.&nbsp;Wolf.</dt>
        <dd><a href="http://lie.math.brocku.ca/twolf/papers/merge-sig.ps">Merging solutions of polynomial algebraic systems</a>. preprint,, 2004.</dd>
        <dt id="Wolf:04">[Wolf:04] T.&nbsp;Wolf.</dt>
        <dd><a href="http://arxiv.org/abs/nlin/0501034">Partial and Complete Linearization of PDEs Based on Conservation Laws</a>. In: Dongming Wang and Zhiming Zheng, editors, <em>Trends in Mathematics: Differential Equations with Symbolic Computation</em>, pages 291-306. Birkhaeuser Verlag Basel/Switzerland, 2005. also as preprint arXiv nlin.SI/0501034.</dd>
        <dt id="Wolf:06a">[Wolf:06a] T.&nbsp;Wolf.</dt>
        <dd><a href="http://www.springerlink.com/content/gh21v55703738061">Integrable quadratic Hamiltonians with a linear Lie-Poisson bracket</a>. <em>General Relativity and Gravitation</em> <strong>38</strong> no. 6, pages 1115-1127, 2006. online journal issue.</dd>
        <dt id="Wolf:07">[Wolf:07] T.&nbsp;Wolf.</dt>
        <dd><a href="http://lie.math.brocku.ca/twolf/papers/uode.pdf">The parametric solution of underdetermined linear ODEs</a>. preprint, 2007.</dd>
        <dt id="Wolf:99c">[Wolf:99c] T.&nbsp;Wolf, A.&nbsp;Brand, and M.&nbsp;Mohammadzadeh.</dt>
        <dd><a href="http://dx.doi.org/10.1006/jsco.1998.0250">Computer algebra algorithms and routines for the computation of conservation laws and fixing of gauge in differential expressions</a>. <em>Journal of Symbolic Computation</em> <strong>27</strong> no. 2, pages 221-238, February 1999.</dd>
        <dt id="Wolf:03a">[Wolf:03a] T.&nbsp;Wolf and O.&nbsp;V. Efimovskaya.</dt>
        <dd><a href="http://www.turpion.org/php/full/getFT.phtml/rd_8_155.pdf?journal_id=rd&paper_id=234&agree=on&tpdfn=rd_8_155&x=60&y=8">Classification of integrable quadratic hamiltonians on e(3)</a>. <em>Regular and Chaotic Dynamics</em> <strong>8</strong> no. 2, pages 155-162, 2003.</dd>
        <dt id="Wolf:03">[Wolf:03] Thomas Wolf.</dt>
        <dd><a href="http://dx.doi.org/10.1016/S0747-7171(03)00020-8">The integration of systems of linear PDEs using conservation laws of syzygies</a>. <em>Journal of Symbolic Computation</em> <strong>35</strong> no. 5, pages 499-526, May 2003.</dd>
        <dt id="Wolf:05">[Wolf:05] Thomas Wolf.</dt>
        <dd><a href="http://doi.acm.org/10.1145/1113439.1113455">The package CRACK for solving large overdetermined systems</a>. <em>SIGSAM Bull.</em> <strong>39</strong> no. 3, pages 95-96, 2005.</dd>
        <dt id="Wood:89">[Wood:89] John&nbsp;C. Wood.</dt>
        <dd><a href="http://dx.doi.org/10.1112/plms/s3-58.3.608">Harmonic two spheres in the unitary group</a>. <em>Proc. London Math. Soc.</em> <strong>s3-58</strong> no. 3, pages 608-624, May 1989.</dd>
        <dt id="Wright:95">[Wright:95] F.&nbsp;J. Wright.</dt>
        <dd><a href="https://sites.google.com/site/fjwcentaur/papers">REDUCE Implementation of Primitives for Univariate Skew Polynomials and Linear Ordinary Differential Operators: A progress report</a>. Technical report, Queen Mary, University of London, January 1995.</dd>
        <dt id="Wright:97">[Wright:97] F.&nbsp;J. Wright.</dt>
        <dd><a href="https://sites.google.com/site/fjwcentaur/papers">An Enhanced ODE Solver for REDUCE</a>. <i>Programming and Computer Software</i> No 3, 1997, in English, and <i>Programmirovanie</i> No 3, 1997, pp 5–22, in Russian.</dd>
        <dt id="Wright:99">[Wright:99] F.&nbsp;J. Wright.</dt>
        <dd><a href="https://sites.google.com/site/fjwcentaur/papers">Design and Implementation of ODESolve 1+ : An Enhanced REDUCE ODE Solver</a>. Technical report, Queen Mary, University of London, May 1999.</dd>
        <dt id="Wright:99a">[Wright:99a] F.&nbsp;J. Wright.</dt>
        <dd><a href="https://sites.google.com/site/fjwcentaur/papers">Design and Implementation of Web-Based Software Demonstrations</a>. Technical report, Queen Mary, University of London, May 1999.</dd>
        <dt id="Wright:00a">[Wright:00a] F.&nbsp;J. Wright.</dt>
        <dd><a href="http://doi.acm.org/10.1145/362001.362022">Interactive Mathematics via the Web using MathML</a>. <em>SIGSAM Bulletin</em> <strong>34</strong> no. 2, pages 49-57, June 2000.</dd>
        <dt id="Wright:00">[Wright:00] F.&nbsp;J. Wright.</dt>
        <dd><a href="https://sites.google.com/site/fjwcentaur/papers">Recognising and Solving Special Function ODEs</a>. Technical report, Queen Mary, University of London, January 2000.</dd>
        <dt id="Wright:85">[Wright:85] F.&nbsp;J. Wright and G.&nbsp;Dangelmayr.</dt>
        <dd><a href="http://dx.doi.org/10.1007/BF02240148">Explicit iterative algorithms to reduce a univariate catastrophe to normal form</a>. <em>Computing</em> <strong>35</strong> no. 1, pages 73-83, March 1985.</dd>
        <dt id="Wu:84a">[Wu:84a] W.-T. Wu.</dt>
        <dd>On the decision problem and the mechanization of theorem-proving in elementary geometry. In: W.&nbsp;W. Bledsoe and D.&nbsp;W. Loveland, editors, <em>Automated Theorem Proving: After 25 Years</em>, <em>Contemporary Mathematics</em>&nbsp;29, pages 213-234. AMS, Providence, Rhode Island, 1984.</dd>
        <dt id="Wu:84b">[Wu:84b] W.-T. Wu.</dt>
        <dd>Some recent advances in mechanical theorem proving of geometry. In: W.&nbsp;W. Bledsoe and D.&nbsp;W. Loveland, editors, <em>Automated Theorem Proving: After 25 Years</em>, <em>Contemporary Mathematics</em>&nbsp;29, pages 235-241. AMS, Providence, Rhode Island, 1984.</dd>
        <dt id="Wu:94">[Wu:94] W.-T. Wu.</dt>
        <dd><a href="http://www.springer.com/springerwiennewyork/mathematics/book/978-3-211-82506-8"><em>Mechanical Theorem Proving in Geometries</em></a>. Number&nbsp;1 in Texts and Monographs in Symbolic Computation. Springer, Wien, 1994.</dd>
        <dt id="Wulkow:90">[Wulkow:90] Michael Wulkow and Peter Deuflhard.</dt>
        <dd><a href="http://opus.kobv.de/zib/volltexte/1990/29/">Towards an efficient computational treatment of heterogeneous polymer reactions</a>. In: S.&nbsp;O. Fatunla, editor, <em>Computational Ordinary Differential Equations</em>, pages 287-306. University Press, Nigeria, 1992.</dd>
        <dt id="Wuestefeld:95">[Wuestefeld:95] G.&nbsp;W&uuml;stefeld.</dt>
        <dd><a href="http://dx.doi.org/10.1109/PAC.1995.505720">Particle tracking with generating functions of magnetic fringing fields</a>. In: <em>Proceedings of the IEEE 1995 Particle Acelerator Conference, Dallas (USA)</em>, volume&nbsp;5, pages 2868-2870, 1995.</dd>
    </dl>

    <dl id='Y'>
        <dt id="Yamamoto:87">[Yamamoto:87] T.&nbsp;Yamamoto and Y.&nbsp;Aoki.</dt>
        <dd><a href="http://dx.doi.org/10.1007/3-540-51517-8_101">REDUCE 3.2 on iAPX 86/286-based personal computers</a>. In: <em>Proc. EUROCAL &apos;87, Lecture Notes in Computer Science</em>, volume 378, pages 134-135. Springer-Verlag, 1987.</dd>
        <dt id="Yamartino:91">[Yamartino:91] Robert&nbsp;J. Yamartino and Richard Pavelle.</dt>
        <dd><a href="http://dx.doi.org/10.1016/S0747-7171(08)80147-2">An application of computer algebra to a problem in stratified fluid flow</a>. <em>Journal of Symbolic Computation</em> <strong>12</strong> no. 6, pages 669-672, December 1991.</dd>
        <dt id="Yannouleas:88">[Yannouleas:88] C.&nbsp;Yannouleas and J.&nbsp;M. Pacheco.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0010-4655(88)90175-0">An algebraic program for the states associated with the U(5) &sup; O(5) &sup; O(3) chain of groups</a>.  <em>Computer Physics Communications</em> <strong>52</strong> no. 1, pages 85-92, December 1988.</dd>
        <dt id="Yannouleas:89">[Yannouleas:89] C.&nbsp;Yannouleas and J.&nbsp;M. Pacheco.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0010-4655(89)90094-5">Algebraic manipulation of the states associated with the U(5) &sup; O(5) &sup; O(3) chain of groups: orthonormalization and matrix elements</a>. <em>Computer Physics Communications</em> <strong>54</strong> no. 2 and 3, pages 315-328, June and July 1989.</dd>
    </dl>

    <dl id='Z'>
        <dt id="Zacrep:75">[Zacrep:75] Douglas Zacrep and Bing-Lin Young.</dt>
        <dd><a href="http://link.aps.org/doi/10.1103/PhysRevD.12.513">Trace and Ward-Takahashi identity anomalies in an SU(3) current model with energy-momentum tensor</a>. <em>Physical Review D (Particles and Fields)</em> <strong>12</strong> no. 2, pages 513-522, 1975.</dd>
        <dt id="Zahalak:87">[Zahalak:87] G.&nbsp;I. Zahalak, P.&nbsp;R. Rao, and S.&nbsp;P. Sutera.</dt>
        <dd><a href="http://dx.doi.org/10.1017/S0022112087001538">Large deformations of a cylindrical liquid-filled membrane by a viscous shear flow</a>. <em>J. Fluid Mech.</em> <strong>179</strong>, pages 283-305, 1987.</dd>
        <dt id="Zeilberger:90">[Zeilberger:90] D.&nbsp;Zeilberger.</dt>
        <dd><a href="http://dx.doi.org/10.1016/0012-365X(90)90120-7">A fast algorithm for proving terminating hypergeometric identities</a>. <em>Discrete Math.</em> <strong>80</strong> no. 2, pages 207-211, March 1990.</dd>
        <dt id="Zeilberger:91">[Zeilberger:91] D.&nbsp;Zeilberger.</dt>
        <dd><a href="http://dx.doi.org/10.1016/S0747-7171(08)80044-2">The method of creative telescoping</a>. <em>Journal of Symbolic Computation</em> <strong>11</strong> no. 3, pages 195-204, 1991.</dd>
        <dt id="Zeng:84">[Zeng:84] Wan-zhen Zeng and Bail-lin Hao.</dt>
        <dd>Scaling property of period-n-tupling sequences in one-dimensional mappings. <em>Commun. in Theor. Phys., Beijing, China</em> <strong>3</strong> no. 3, pages 283-295, 1984.</dd>
        <dt id="Zharkov:93">[Zharkov:93] A.&nbsp;Yu. Zharkov.</dt>
        <dd><a href="http://dx.doi.org/10.1006/jsco.1993.1007">Computer classification of the integrable coupled Kdv-like systems with unit main matrix</a>. <em>Journal of Symbolic Computation</em> <strong>15</strong> no. 1, pages 85-90, January 1993.</dd>
        <dt id="Zharkov:93a">[Zharkov:93a] A.&nbsp;Yu. Zharkov and Yu.&nbsp;A. Blinkov.</dt>
        <dd>Involution approach to solving systems of algebraic equations. In: G.&nbsp;Jacob, N.&nbsp;E. Oussous, and S.&nbsp;Steinberg, editors, <em>Proceedings of the 1993 International IMACS Symposium on Symbolic Computation</em>, pages 11-16. IMACS, Laboratoire d&apos;Informatique Fondamentale de Lille, France, 1993.</dd>
        <dt id="Zhidkova:78">[Zhidkova:78] I.&nbsp;E. Zhidkova, I.&nbsp;P. Nedyalkov, and V.&nbsp;A. Rostovtsev.</dt>
        <dd>On applicability limits of the experimental method for investigating strong gravitational fields. Technical Report P2 - 11589, J.I.N.R., Dubna, 1978.</dd>
    </dl>
</div>

</div><!-- opened in begin-body.php -->

<!-- The slim version of jQuery does not include ajax (or effects)
     and I use ajax on the documentation page! -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"
        integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4="
        crossorigin="anonymous"></script>
<script>
 // Complete the set-up of the tabbed header and content:
 $("#TabbedContent > dl")
     .addClass("tab-pane fade").attr("role", "tabpanel")
     .attr("aria-labelledby", function(){return $(this).attr("id")+"-tab"})
     .each(function(){
         // Create the navigation links above the bibliography:
         let alpha = $(this).attr("id");
         $('<button class="nav-link" id="' + alpha + '-tab" \
          data-bs-toggle="tab" data-bs-target="#' + alpha + '" type="button" role="tab" \
          aria-controls="' + alpha + '" aria-selected="false">' + alpha + '</button>')
             .appendTo($("#TabbedHeader"))
     });
 // Set the initial state:
 $("#TabbedHeader > button:first-child").addClass("active").attr("aria-selected", "true");
 $("#TabbedContent > dl:first-child").addClass("show active");
</script>

<?php
include './include/footer.php';
?>

</body>
</html>
