linelength 5000$  % avoids differences between CSL and PSL
off smtabout, smtprompt;
smt();
(set-option :print-success false)
(set-logic QF_NRA)
(set-option :produce-models false)
(set-option :produce-unsat-cores false)

; sat, no models, no cad

; 01.red
(reset-assertions)
(assert (not (<= (* v5 v6) 0)))
(assert (not (<= 2 v23)))
(assert (not (<= v5 0)))
(assert (not (= 0 v5)))
(assert (not (<= v19 0)))
(assert (not (<= v23 v19)))
(assert (not (<= v5 1)))
(check-sat)

; 02.red
(reset-assertions)
(assert (<= (* v5 (* v5 (+ (- 120000000000000000000) (* v5 (* (- 120000) v5))))) 0))
(assert (not (<= v16 (/ 15707963 5000000))))
(assert (not (<= (/ 31415927 10000000) v16)))
(assert (<= v27 (* (/ 1 3) v16)))
(assert (<= (* (/ 1 4) v16) v27))
(assert (<= v5 120))
(assert (<= 100 v5))
(check-sat)

; 03.red
(reset-assertions)
(assert (<= (* v5 (+ (+ (* (- (/ 306432 125)) v6) (* (/ 12096 25) v12)) (* v5 (+ (+ (* (/ 536256 15625) v6) (* (- (/ 21168 3125)) v12)) (* v5 (+ (+ (* (- (/ 625632 1953125)) v6) (* (/ 24696 390625) v12)) (* v5 (+ (+ (* (/ 957999 488281250) v6) (* (- (/ 151263 390625000)) v12)) (* v5 (+ (+ (* (- (/ 957999 122070312500)) v6) (* (/ 151263 97656250000) v12)) (* v5 (+ (* (/ 2235331 122070312500000) v6) (* (- (/ 352947 97656250000000)) v12))))))))))))) (+ (* (- 87552) v6) (* 17280 v12))))
(assert (<= v5 0))
(assert (not (<= (* v5 (+ (+ (* (/ 306432 125) v6) (* (- (/ 12096 25)) v12)) (* v5 (+ (+ (* (- (/ 536256 15625)) v6) (* (/ 21168 3125) v12)) (* v5 (+ (+ (* (/ 625632 1953125) v6) (* (- (/ 24696 390625)) v12)) (* v5 (+ (+ (* (- (/ 957999 488281250)) v6) (* (/ 151263 390625000) v12)) (* v5 (+ (+ (* (/ 957999 122070312500) v6) (* (- (/ 151263 97656250000)) v12)) (* v5 (+ (* (- (/ 2235331 122070312500000)) v6) (* (/ 352947 97656250000000) v12))))))))))))) (+ (* 87552 v6) (* (- 17280) v12)))))
(assert (= (* v12 v12) (+ 1 (* v6 (* (- 1) v6)))))
(assert (<= v5 75))
(assert (<= 0 v5))
(check-sat)

; 04.red
(reset-assertions)
(assert (not (<= 0 v6)))
(assert (not (<= (* v16 (* (- 1) v6)) (- 1))))
(assert (not (<= (* v22 (+ (+ (/ 471 100) (* v6 (+ (- 3) (* (/ 157 100) v6)))) (* v16 (+ (+ (- 3) (* v6 (+ (- (/ 471 100)) (* v6 (+ 2 (* (- (/ 157 100)) v6)))))) (* v16 (* v6 (+ 3 (* v6 v6)))))))) (+ (+ 3 (* v6 (+ (- (/ 471 100)) (* v6 (+ 4 (* (- (/ 157 100)) v6)))))) (* v16 (+ (+ (- (/ 471 100)) (* v6 (+ 3 (* (- (/ 157 100)) v6)))) (* v16 (+ 3 (* v6 v6)))))))))
(assert (not (<= v22 0)))
(assert (not (<= v6 (- 1))))
(assert (not (<= 1 v16)))
(assert (not (<= v16 v6)))
(check-sat)

; 05.red
(reset-assertions)
(assert (<= (* v14 (+ 3 (* v5 (+ (* (- 3) v8) (* v5 (+ 1 (* v5 (* (- 1) v8)))))))) (+ (* (- 3) v8) (* v5 (+ (- 3) (* v5 (+ (* (- 1) v8) (* (- 1) v5))))))))
(assert (not (<= 0 v5)))
(assert (not (<= (* v14 (+ (- 1) (* v5 v8))) (+ v8 v5))))
(assert (not (<= v14 0)))
(assert (not (<= v8 (- 1))))
(assert (not (<= 1 v5)))
(assert (not (<= v5 v8)))
(check-sat)

; 06.red
(reset-assertions)
(assert (<= (* v5 (+ (- (/ 57 500)) (* (- (/ 361 1000000)) v5))) 12))
(assert (= (* v25 v25) (+ 1 (* v19 (* (- 1) v19)))))
(assert (<= v5 289))
(assert (<= 0 v5))
(assert (<= (* (- (/ 235 42)) v19) v25))
(check-sat)

; sat, no models, cad

; 70.red
(reset-assertions)
(assert (<= (* v5 (+ (+ (* (/ 2891855167488 125) v6) (* (- (/ 114152177664 25)) v11)) (* v5 (+ (+ (* (- (/ 5060746543104 15625)) v6) (* (/ 199766310912 3125) v11)) (* v5 (+ (+ (* (/ 5904204300288 1953125) v6) (* (- (/ 233060696064 390625)) v11)) (* v5 (+ (+ (* (- (/ 5085457219584 244140625)) v6) (* (/ 200741732352 48828125) v11)) (* v5 (+ (+ (* (/ 3390304813056 30517578125) v6) (* (- (/ 133827821568 6103515625)) v11)) (* v5 (+ (+ (* (- (/ 1792270513152 3814697265625)) v6) (* (/ 70747520256 762939453125) v11)) (* v5 (+ (+ (* (/ 757079785728 476837158203125) v6) (* (- (/ 29884728384 95367431640625)) v11)) (* v5 (+ (+ (* (- (/ 254331490518 59604644775390625)) v6) (* (/ 20078801883 23841857910156250) v11)) (* v5 (+ (+ (* (/ 66704512371 7450580596923828125) v6) (* (- (/ 10532291427 5960464477539062500)) v11)) (* v5 (+ (+ (* (- (/ 209314159509 14901161193847656250000)) v6) (* (/ 33049604133 11920928955078125000000) v11)) (* v5 (+ (+ (* (/ 112707624351 7450580596923828125000000) v6) (* (- (/ 17795940687 5960464477539062500000000)) v11)) (* v5 (+ (* (- (/ 262984456819 29802322387695312500000000000)) v6) (* (/ 41523861603 23841857910156250000000000000) v11))))))))))))))))))))))))) (+ (* 826244333568 v6) (* (- 163074539520) v11))))
(assert (not (<= (* v5 (+ (+ (* (- (/ 2891855167488 125)) v6) (* (/ 114152177664 25) v11)) (* v5 (+ (+ (* (/ 5060746543104 15625) v6) (* (- (/ 199766310912 3125)) v11)) (* v5 (+ (+ (* (- (/ 5904204300288 1953125)) v6) (* (/ 233060696064 390625) v11)) (* v5 (+ (+ (* (/ 5085457219584 244140625) v6) (* (- (/ 200741732352 48828125)) v11)) (* v5 (+ (+ (* (- (/ 3390304813056 30517578125)) v6) (* (/ 133827821568 6103515625) v11)) (* v5 (+ (+ (* (/ 1792270513152 3814697265625) v6) (* (- (/ 70747520256 762939453125)) v11)) (* v5 (+ (+ (* (- (/ 757079785728 476837158203125)) v6) (* (/ 29884728384 95367431640625) v11)) (* v5 (+ (+ (* (/ 254331490518 59604644775390625) v6) (* (- (/ 20078801883 23841857910156250)) v11)) (* v5 (+ (+ (* (- (/ 66704512371 7450580596923828125)) v6) (* (/ 10532291427 5960464477539062500) v11)) (* v5 (+ (+ (* (/ 209314159509 14901161193847656250000) v6) (* (- (/ 33049604133 11920928955078125000000)) v11)) (* v5 (+ (+ (* (- (/ 112707624351 7450580596923828125000000)) v6) (* (/ 17795940687 5960464477539062500000000) v11)) (* v5 (+ (* (/ 262984456819 29802322387695312500000000000) v6) (* (- (/ 41523861603 23841857910156250000000000000)) v11))))))))))))))))))))))))) (+ (* (- 826244333568) v6) (* 163074539520 v11)))))
(assert (not (<= v5 0)))
(assert (= (* v11 v11) (+ 1 (* v6 (* (- 1) v6)))))
(assert (<= v5 75))
(assert (<= 0 v5))
(check-sat)

; 71.red
(reset-assertions)
(assert (not (<= (* v5 (+ (* v11 (* (/ 5 4) v8)) (* v5 (* v11 (* v11 (* v8 (* (/ 1 4) v8))))))) 0)))
(assert (<= 1 v8))
(assert (<= 1 v11))
(assert (<= 1 v5))
(assert (<= v8 2))
(assert (<= v11 2))
(assert (<= v5 2))
(assert (not (<= (* v5 (* v11 (+ (* v8 (+ (- (/ 7 2)) (* (/ 1 2) v8))) (* v11 (* v8 (+ (/ 1 2) (* (/ 1 2) v8))))))) (+ (+ (- (/ 1 4)) (* (- (/ 1 4)) v8)) (* v11 (+ (- (/ 1 4)) (* (- (/ 1 4)) v8)))))))
(assert (not (<= v11 1)))
(assert (not (<= v8 1)))
(assert (not (<= v5 1)))
(check-sat)

; 73.red
(reset-assertions)
(assert (not (<= (* v5 (* 3600000000 v5)) (- 3600000000000000000000000))))
(assert (not (<= (* v13 (* v13 (+ (+ (- 1800000000000000000000000) (* v5 (* (- 1800000000) v5))) (* v13 (* v13 (+ 150000000000000000000000 (* v5 (* 150000000 v5)))))))) (+ (- 3600120000000000000000000) (* v5 (* (- 3600120000) v5))))))
(assert (not (<= v40 (/ 15707963 5000000))))
(assert (not (<= (/ 31415927 10000000) v40)))
(check-sat)

; 74.red
(reset-assertions)
(assert (<= (* v5 (* v5 (+ (/ 1 2) (* v5 (* (- (/ 1 24)) v5))))) 1))
(assert (not (<= v5 v17)))
(assert (<= (/ 1 20) v17))
(assert (<= v5 (* (/ 1 2) v23)))
(assert (not (<= (/ 31415927 10000000) v23)))
(assert (not (<= v23 (/ 15707963 5000000))))
(check-sat)

; 75.red
(reset-assertions)
(assert (not (<= (* v5 (+ (* v16 (* v16 (+ (/ 1 6) (* v16 (* v16 (+ (- (/ 1 120)) (* v16 (* v16 (+ (/ 1 5040) (* v16 (* v16 (+ (- (/ 1 362880)) (* v16 (* (/ 1 39916800) v16)))))))))))))) (* v5 (* v5 (+ (- (/ 1 6)) (* v5 (* (/ 1 120) v5))))))) 0)))
(assert (not (<= (* v5 (* v5 (+ (* (- (/ 1 6)) v16) (* v5 (* v5 (+ (* (/ 1 120) v16) (* v5 (* v5 (+ (* (- (/ 1 5040)) v16) (* v5 (* v5 (* (/ 1 362880) v16)))))))))))) (* v16 (* v16 (* v16 (+ (- (/ 1 6)) (* v16 (* v16 (+ (/ 1 120) (* v16 (* v16 (+ (- (/ 1 5040)) (* v16 (* v16 (+ (/ 1 362880) (* v16 (* (- (/ 1 39916800)) v16))))))))))))))))))
(assert (not (<= (* v5 (+ (* v16 (* v16 (+ (/ 1 6) (* v16 (* v16 (+ (- (/ 1 120)) (* v16 (* (/ 1 5040) v16)))))))) (* v5 (* v5 (+ (- (/ 1 6)) (* v5 (* v5 (+ (/ 1 120) (* v5 (* v5 (+ (- (/ 1 5040)) (* v5 (* (/ 1 362880) v5))))))))))))) 0)))
(assert (not (<= (* v5 (* v5 (+ (* (- (/ 1 6)) v16) (* v5 (* v5 (* (/ 1 120) v16)))))) (* v16 (* v16 (* v16 (+ (- (/ 1 6)) (* v16 (* v16 (+ (/ 1 120) (* v16 (* (- (/ 1 5040)) v16))))))))))))
(assert (not (<= (* v5 (+ (* v16 (* (/ 1 6) v16)) (* v5 (* v5 (+ (- (/ 1 6)) (* v5 (* (/ 1 120) v5))))))) 0)))
(assert (not (<= v16 0)))
(assert (not (<= v128 (/ 15707963 5000000))))
(assert (not (<= (/ 31415927 10000000) v128)))
(assert (not (<= v5 v16)))
(check-sat)

(set-option :produce-models true)
(set-option :model-values "root-of")

; sat, models, no cad

; 01.red
(reset-assertions)
(assert (not (<= (* v5 v6) 0)))
(assert (not (<= 2 v23)))
(assert (not (<= v5 0)))
(assert (not (= 0 v5)))
(assert (not (<= v19 0)))
(assert (not (<= v23 v19)))
(assert (not (<= v5 1)))
(check-sat)
(get-model)

; 02.red
(reset-assertions)
(assert (<= (* v5 (* v5 (+ (- 120000000000000000000) (* v5 (* (- 120000) v5))))) 0))
(assert (not (<= v16 (/ 15707963 5000000))))
(assert (not (<= (/ 31415927 10000000) v16)))
(assert (<= v27 (* (/ 1 3) v16)))
(assert (<= (* (/ 1 4) v16) v27))
(assert (<= v5 120))
(assert (<= 100 v5))
(check-sat)
(get-model)

; 03.red
(reset-assertions)
(assert (<= (* v5 (+ (+ (* (- (/ 306432 125)) v6) (* (/ 12096 25) v12)) (* v5 (+ (+ (* (/ 536256 15625) v6) (* (- (/ 21168 3125)) v12)) (* v5 (+ (+ (* (- (/ 625632 1953125)) v6) (* (/ 24696 390625) v12)) (* v5 (+ (+ (* (/ 957999 488281250) v6) (* (- (/ 151263 390625000)) v12)) (* v5 (+ (+ (* (- (/ 957999 122070312500)) v6) (* (/ 151263 97656250000) v12)) (* v5 (+ (* (/ 2235331 122070312500000) v6) (* (- (/ 352947 97656250000000)) v12))))))))))))) (+ (* (- 87552) v6) (* 17280 v12))))
(assert (<= v5 0))
(assert (not (<= (* v5 (+ (+ (* (/ 306432 125) v6) (* (- (/ 12096 25)) v12)) (* v5 (+ (+ (* (- (/ 536256 15625)) v6) (* (/ 21168 3125) v12)) (* v5 (+ (+ (* (/ 625632 1953125) v6) (* (- (/ 24696 390625)) v12)) (* v5 (+ (+ (* (- (/ 957999 488281250)) v6) (* (/ 151263 390625000) v12)) (* v5 (+ (+ (* (/ 957999 122070312500) v6) (* (- (/ 151263 97656250000)) v12)) (* v5 (+ (* (- (/ 2235331 122070312500000)) v6) (* (/ 352947 97656250000000) v12))))))))))))) (+ (* 87552 v6) (* (- 17280) v12)))))
(assert (= (* v12 v12) (+ 1 (* v6 (* (- 1) v6)))))
(assert (<= v5 75))
(assert (<= 0 v5))
(check-sat)
(get-model)

; 04.red
(reset-assertions)
(assert (not (<= 0 v6)))
(assert (not (<= (* v16 (* (- 1) v6)) (- 1))))
(assert (not (<= (* v22 (+ (+ (/ 471 100) (* v6 (+ (- 3) (* (/ 157 100) v6)))) (* v16 (+ (+ (- 3) (* v6 (+ (- (/ 471 100)) (* v6 (+ 2 (* (- (/ 157 100)) v6)))))) (* v16 (* v6 (+ 3 (* v6 v6)))))))) (+ (+ 3 (* v6 (+ (- (/ 471 100)) (* v6 (+ 4 (* (- (/ 157 100)) v6)))))) (* v16 (+ (+ (- (/ 471 100)) (* v6 (+ 3 (* (- (/ 157 100)) v6)))) (* v16 (+ 3 (* v6 v6)))))))))
(assert (not (<= v22 0)))
(assert (not (<= v6 (- 1))))
(assert (not (<= 1 v16)))
(assert (not (<= v16 v6)))
(check-sat)
(get-model)

; 05.red
(reset-assertions)
(assert (<= (* v14 (+ 3 (* v5 (+ (* (- 3) v8) (* v5 (+ 1 (* v5 (* (- 1) v8)))))))) (+ (* (- 3) v8) (* v5 (+ (- 3) (* v5 (+ (* (- 1) v8) (* (- 1) v5))))))))
(assert (not (<= 0 v5)))
(assert (not (<= (* v14 (+ (- 1) (* v5 v8))) (+ v8 v5))))
(assert (not (<= v14 0)))
(assert (not (<= v8 (- 1))))
(assert (not (<= 1 v5)))
(assert (not (<= v5 v8)))
(check-sat)
(get-model)

; 06.red
(reset-assertions)
(assert (<= (* v5 (+ (- (/ 57 500)) (* (- (/ 361 1000000)) v5))) 12))
(assert (= (* v25 v25) (+ 1 (* v19 (* (- 1) v19)))))
(assert (<= v5 289))
(assert (<= 0 v5))
(assert (<= (* (- (/ 235 42)) v19) v25))
(check-sat)
(get-model)
(set-option :model-values "approximately")
(get-model)
(set-option :model-values "root-of")

; sat, models, cad

; 70.red
(reset-assertions)
(assert (<= (* v5 (+ (+ (* (/ 2891855167488 125) v6) (* (- (/ 114152177664 25)) v11)) (* v5 (+ (+ (* (- (/ 5060746543104 15625)) v6) (* (/ 199766310912 3125) v11)) (* v5 (+ (+ (* (/ 5904204300288 1953125) v6) (* (- (/ 233060696064 390625)) v11)) (* v5 (+ (+ (* (- (/ 5085457219584 244140625)) v6) (* (/ 200741732352 48828125) v11)) (* v5 (+ (+ (* (/ 3390304813056 30517578125) v6) (* (- (/ 133827821568 6103515625)) v11)) (* v5 (+ (+ (* (- (/ 1792270513152 3814697265625)) v6) (* (/ 70747520256 762939453125) v11)) (* v5 (+ (+ (* (/ 757079785728 476837158203125) v6) (* (- (/ 29884728384 95367431640625)) v11)) (* v5 (+ (+ (* (- (/ 254331490518 59604644775390625)) v6) (* (/ 20078801883 23841857910156250) v11)) (* v5 (+ (+ (* (/ 66704512371 7450580596923828125) v6) (* (- (/ 10532291427 5960464477539062500)) v11)) (* v5 (+ (+ (* (- (/ 209314159509 14901161193847656250000)) v6) (* (/ 33049604133 11920928955078125000000) v11)) (* v5 (+ (+ (* (/ 112707624351 7450580596923828125000000) v6) (* (- (/ 17795940687 5960464477539062500000000)) v11)) (* v5 (+ (* (- (/ 262984456819 29802322387695312500000000000)) v6) (* (/ 41523861603 23841857910156250000000000000) v11))))))))))))))))))))))))) (+ (* 826244333568 v6) (* (- 163074539520) v11))))
(assert (not (<= (* v5 (+ (+ (* (- (/ 2891855167488 125)) v6) (* (/ 114152177664 25) v11)) (* v5 (+ (+ (* (/ 5060746543104 15625) v6) (* (- (/ 199766310912 3125)) v11)) (* v5 (+ (+ (* (- (/ 5904204300288 1953125)) v6) (* (/ 233060696064 390625) v11)) (* v5 (+ (+ (* (/ 5085457219584 244140625) v6) (* (- (/ 200741732352 48828125)) v11)) (* v5 (+ (+ (* (- (/ 3390304813056 30517578125)) v6) (* (/ 133827821568 6103515625) v11)) (* v5 (+ (+ (* (/ 1792270513152 3814697265625) v6) (* (- (/ 70747520256 762939453125)) v11)) (* v5 (+ (+ (* (- (/ 757079785728 476837158203125)) v6) (* (/ 29884728384 95367431640625) v11)) (* v5 (+ (+ (* (/ 254331490518 59604644775390625) v6) (* (- (/ 20078801883 23841857910156250)) v11)) (* v5 (+ (+ (* (- (/ 66704512371 7450580596923828125)) v6) (* (/ 10532291427 5960464477539062500) v11)) (* v5 (+ (+ (* (/ 209314159509 14901161193847656250000) v6) (* (- (/ 33049604133 11920928955078125000000)) v11)) (* v5 (+ (+ (* (- (/ 112707624351 7450580596923828125000000)) v6) (* (/ 17795940687 5960464477539062500000000) v11)) (* v5 (+ (* (/ 262984456819 29802322387695312500000000000) v6) (* (- (/ 41523861603 23841857910156250000000000000)) v11))))))))))))))))))))))))) (+ (* (- 826244333568) v6) (* 163074539520 v11)))))
(assert (not (<= v5 0)))
(assert (= (* v11 v11) (+ 1 (* v6 (* (- 1) v6)))))
(assert (<= v5 75))
(assert (<= 0 v5))
(check-sat)
(get-model)

; 71.red
(reset-assertions)
(assert (not (<= (* v5 (+ (* v11 (* (/ 5 4) v8)) (* v5 (* v11 (* v11 (* v8 (* (/ 1 4) v8))))))) 0)))
(assert (<= 1 v8))
(assert (<= 1 v11))
(assert (<= 1 v5))
(assert (<= v8 2))
(assert (<= v11 2))
(assert (<= v5 2))
(assert (not (<= (* v5 (* v11 (+ (* v8 (+ (- (/ 7 2)) (* (/ 1 2) v8))) (* v11 (* v8 (+ (/ 1 2) (* (/ 1 2) v8))))))) (+ (+ (- (/ 1 4)) (* (- (/ 1 4)) v8)) (* v11 (+ (- (/ 1 4)) (* (- (/ 1 4)) v8)))))))
(assert (not (<= v11 1)))
(assert (not (<= v8 1)))
(assert (not (<= v5 1)))
(check-sat)
(get-model)

; 73.red
(reset-assertions)
(assert (not (<= (* v5 (* 3600000000 v5)) (- 3600000000000000000000000))))
(assert (not (<= (* v13 (* v13 (+ (+ (- 1800000000000000000000000) (* v5 (* (- 1800000000) v5))) (* v13 (* v13 (+ 150000000000000000000000 (* v5 (* 150000000 v5)))))))) (+ (- 3600120000000000000000000) (* v5 (* (- 3600120000) v5))))))
(assert (not (<= v40 (/ 15707963 5000000))))
(assert (not (<= (/ 31415927 10000000) v40)))
(check-sat)
(get-model)

; 74.red
(reset-assertions)
(assert (<= (* v5 (* v5 (+ (/ 1 2) (* v5 (* (- (/ 1 24)) v5))))) 1))
(assert (not (<= v5 v17)))
(assert (<= (/ 1 20) v17))
(assert (<= v5 (* (/ 1 2) v23)))
(assert (not (<= (/ 31415927 10000000) v23)))
(assert (not (<= v23 (/ 15707963 5000000))))
(check-sat)
(get-model)

; 75.red
(reset-assertions)
(assert (not (<= (* v5 (+ (* v16 (* v16 (+ (/ 1 6) (* v16 (* v16 (+ (- (/ 1 120)) (* v16 (* v16 (+ (/ 1 5040) (* v16 (* v16 (+ (- (/ 1 362880)) (* v16 (* (/ 1 39916800) v16)))))))))))))) (* v5 (* v5 (+ (- (/ 1 6)) (* v5 (* (/ 1 120) v5))))))) 0)))
(assert (not (<= (* v5 (* v5 (+ (* (- (/ 1 6)) v16) (* v5 (* v5 (+ (* (/ 1 120) v16) (* v5 (* v5 (+ (* (- (/ 1 5040)) v16) (* v5 (* v5 (* (/ 1 362880) v16)))))))))))) (* v16 (* v16 (* v16 (+ (- (/ 1 6)) (* v16 (* v16 (+ (/ 1 120) (* v16 (* v16 (+ (- (/ 1 5040)) (* v16 (* v16 (+ (/ 1 362880) (* v16 (* (- (/ 1 39916800)) v16))))))))))))))))))
(assert (not (<= (* v5 (+ (* v16 (* v16 (+ (/ 1 6) (* v16 (* v16 (+ (- (/ 1 120)) (* v16 (* (/ 1 5040) v16)))))))) (* v5 (* v5 (+ (- (/ 1 6)) (* v5 (* v5 (+ (/ 1 120) (* v5 (* v5 (+ (- (/ 1 5040)) (* v5 (* (/ 1 362880) v5))))))))))))) 0)))
(assert (not (<= (* v5 (* v5 (+ (* (- (/ 1 6)) v16) (* v5 (* v5 (* (/ 1 120) v16)))))) (* v16 (* v16 (* v16 (+ (- (/ 1 6)) (* v16 (* v16 (+ (/ 1 120) (* v16 (* (- (/ 1 5040)) v16))))))))))))
(assert (not (<= (* v5 (+ (* v16 (* (/ 1 6) v16)) (* v5 (* v5 (+ (- (/ 1 6)) (* v5 (* (/ 1 120) v5))))))) 0)))
(assert (not (<= v16 0)))
(assert (not (<= v128 (/ 15707963 5000000))))
(assert (not (<= (/ 31415927 10000000) v128)))
(assert (not (<= v5 v16)))
(check-sat)
(get-model)

; 85.red
(reset-assertions)
(assert (<= (* v5 (+ (* v26 (* v26 (+ (/ 1 6) (* v26 (* v26 (+ (- (/ 1 120)) (* v26 (* v26 (+ (/ 1 5040) (* v26 (* v26 (+ (- (/ 1 362880)) (* v26 (* v26 (+ (/ 1 39916800) (* v26 (* v26 (+ (- (/ 1 6227020800)) (* v26 (* (/ 1 1307674368000) v26)))))))))))))))))))) (* v5 (* v5 (+ (- (/ 1 6)) (* v5 (* v5 (+ (/ 1 120) (* v5 (* v5 (+ (- (/ 1 5040)) (* v5 (* (/ 1 362880) v5))))))))))))) 0))
(assert (not (<= (* v5 (* v5 (+ (* (- (/ 1 6)) v26) (* v5 (* v5 (+ (* (/ 1 120) v26) (* v5 (* v5 (+ (* (- (/ 1 5040)) v26) (* v5 (* v5 (* (/ 1 362880) v26)))))))))))) (* v26 (* v26 (* v26 (+ (- (/ 1 6)) (* v26 (* v26 (+ (/ 1 120) (* v26 (* v26 (+ (- (/ 1 5040)) (* v26 (* v26 (+ (/ 1 362880) (* v26 (* (- (/ 1 39916800)) v26))))))))))))))))))
(assert (not (<= (* v5 (+ (* v26 (* v26 (+ (/ 1 6) (* v26 (* v26 (+ (- (/ 1 120)) (* v26 (* (/ 1 5040) v26)))))))) (* v5 (* v5 (+ (- (/ 1 6)) (* v5 (* v5 (+ (/ 1 120) (* v5 (* v5 (+ (- (/ 1 5040)) (* v5 (* (/ 1 362880) v5))))))))))))) 0)))
(assert (not (<= (* v5 (* v5 (+ (* (- (/ 1 6)) v26) (* v5 (* v5 (* (/ 1 120) v26)))))) (* v26 (* v26 (* v26 (+ (- (/ 1 6)) (* v26 (* v26 (+ (/ 1 120) (* v26 (* (- (/ 1 5040)) v26))))))))))))
(assert (not (<= (* v5 (+ (* v26 (* (/ 1 6) v26)) (* v5 (* v5 (+ (- (/ 1 6)) (* v5 (* (/ 1 120) v5))))))) 0)))
(assert (not (<= v26 0)))
(assert (not (<= v137 (/ 15707963 5000000))))
(assert (not (<= (/ 31415927 10000000) v137)))
(assert (<= v5 (* (/ 1 2) v137)))
(assert (<= 0 v26))
(assert (not (<= v5 v26)))
(check-sat)
(get-model)
(set-option :model-values "approximately")
(get-model)

(set-option :produce-models false)
(set-option :produce-unsat-cores false)

; unsat, no cores

; 34.red
(reset-assertions)
(assert (not (<= (* v5 (+ (- (/ 1495335813775360 3119868895908289175433)) (* (- (/ 559007298989804530384135782400 9733581927656007318022218939278759050737489)) v5))) 0)))
(assert (= (* v5 v5) (/ 1325421053866224634595698711821825 295147905179352825856)))
(assert (= (* v5 v5) (+ 277555600 (* v46 (* v46 (+ 15328072984 (* v46 (* v46 (+ 129098541721 (* v46 (* v46 (+ 21404723599 (* v46 (* v46 (+ 1024027285 (* v46 (* 15132100 v46)))))))))))))))))
(assert (not (<= v63 (/ 15707963 5000000))))
(assert (not (<= (/ 31415927 10000000) v63)))
(assert (<= 0 v5))
(check-sat)

; 35.red
(reset-assertions)
(assert (<= (* v8 (+ (* (- 231) v5) (* v8 (+ 315 (* v8 (+ (* (- 315) v5) (* v8 (+ 105 (* v8 (+ (* (- 105) v5) (* v8 (+ 5 (* v8 (* (- 5) v5)))))))))))))) (- 231)))
(assert (<= (* v8 (+ (* 231 v5) (* v8 (+ (- 315) (* v8 (+ (* 315 v5) (* v8 (+ (- 105) (* v8 (+ (* 105 v5) (* v8 (+ (- 5) (* v8 (* 5 v5)))))))))))))) 231))
(assert (not (<= (* v37 (+ (- 231) (* v8 (+ (* 231 v5) (* v8 (+ (- 315) (* v8 (+ (* 315 v5) (* v8 (+ (- 105) (* v8 (+ (* 105 v5) (* v8 (+ (- 5) (* v8 (* 5 v5)))))))))))))))) (+ (+ (/ 231 4) (* 231 v5)) (* v8 (+ (* (- (/ 231 4)) v5) (* v8 (+ (+ (/ 315 4) (* 546 v5)) (* v8 (+ (+ 77 (* (- (/ 315 4)) v5)) (* v8 (+ (+ (/ 105 4) (* 343 v5)) (* v8 (+ (+ (/ 294 5) (* (- (/ 105 4)) v5)) (* v8 (+ (+ (/ 5 4) (* (/ 256 5) v5)) (* v8 (+ 5 (* (- (/ 5 4)) v5)))))))))))))))))))
(assert (not (<= 0 v8)))
(assert (not (<= (* v37 (+ (- 1) (* v8 v5))) (+ v5 v8))))
(assert (<= (* v37 (+ 1 (* v8 (* (- 1) v5)))) (+ (+ 1 (* (- 1) v5)) (* v8 (+ (- 1) (* (- 1) v5))))))
(assert (not (<= 0 v5)))
(assert (not (<= v37 0)))
(assert (not (<= v5 (- 1))))
(assert (not (<= 1 v8)))
(assert (not (<= v8 v5)))
(check-sat)

; 36.red
(reset-assertions)
(assert (<= (* v5 (+ 12 (* v5 (+ (- 60) (* 120 v5))))) 1))
(assert (= (+ 1 (* v5 (* v5 v5))) (+ (- 1) (* v17 (* v17 v17)))))
(assert (= (* v27 (* v27 v27)) (+ (- 1) (* v17 (* v17 v17)))))
(assert (not (<= (+ (- 1) (* v17 (* v17 v17))) 2)))
(assert (not (<= v17 0)))
(assert (not (<= v5 0)))
(assert (not (<= v27 0)))
(assert (not (<= 10 (+ (- 1) (* v17 (* v17 v17))))))
(check-sat)

; 38.red
(reset-assertions)
(assert (not (<= (* (/ 86400000 2025130727) v5) v11)))
(assert (not (<= (* v15 (+ (- (/ 8832 13)) (* v15 (+ (- (/ 3174 1625)) (* v15 (+ (- (/ 12167 3250000)) (* v15 (+ (- (/ 1958887 416000000000)) (* v15 (+ (- (/ 6436343 1664000000000000)) (* (- (/ 148035889 79872000000000000000)) v15))))))))))) (+ (+ (/ 1536000 13) (* (/ 331776 65) v5)) (* (- (/ 24301568724 203125)) v11)))))
(check-sat)

; 39.red
(reset-assertions)
(assert (not (<= (* v5 (* (- 1) v6)) 0)))
(assert (not (<= v5 0)))
(assert (not (<= v14 0)))
(assert (not (<= 2 v6)))
(assert (not (<= v6 v14)))
(check-sat)

; 40.red
(reset-assertions)
(assert (not (<= 0 v5)))
(assert (not (<= (* v10 (+ (+ (* (- 6) v5) (* v13 (+ (+ (- 6) (* v5 (* 6 v5))) (* v13 (* 6 v5))))) (* v10 (+ (- 3) (* v13 (+ (* 6 v5) (* v13 (* v5 (* (- 3) v5))))))))) (+ (+ 1 (* v5 (* 3 v5))) (* v13 (+ (* 4 v5) (* v13 (+ 3 (* v5 v5)))))))))
(assert (not (<= v10 0)))
(assert (not (<= v5 (- 1))))
(assert (not (<= 1 v13)))
(assert (not (<= v13 v5)))
(check-sat)

; 41.red
(reset-assertions)
(assert (not (<= (* v5 (* v5 (* v5 (* v5 (* v5 (* v5 (* v5 (* v5 (* v5 (* v5 (* v5 (* v5 (* v5 (* v5 (* (- 2) v5))))))))))))))) 0)))
(assert (not (<= v25 1)))
(assert (not (<= v5 0)))
(assert (not (<= v30 0)))
(assert (not (<= v33 0)))
(assert (not (<= 5 v25)))
(check-sat)

; 42.red
(reset-assertions)
(assert (<= (* v5 (+ (- (/ 16128 5)) (* v5 (+ (/ 28224 625) (* v5 (+ (- (/ 32928 78125)) (* v5 (+ (/ 50421 19531250) (* v5 (+ (- (/ 50421 4882812500)) (* (/ 117649 4882812500000) v5))))))))))) (- 112896)))
(assert (= (* v40 v40) (+ 1 (* v42 (* (- 1) v42)))))
(assert (<= v5 75))
(assert (<= 0 v5))
(check-sat)

; 43.red
(reset-assertions)
(assert (not (<= (* v10 (+ (- (/ 2180412 1953125)) (* v10 (+ (/ 1635309 12207031250) (* v10 (+ (- (/ 1635309 152587890625000)) (* v10 (+ (/ 34341489 61035156250000000000) (* v10 (+ (- (/ 14717781 762939453125000000000000)) (* (/ 14717781 38146972656250000000000000000) v10))))))))))) (+ (+ (- (/ 2907216 625)) (* (/ 52704 125) v5)) (* (- (/ 228384 125)) v50)))))
(assert (not (<= (* v10 (+ (/ 8316 1953125) (* v10 (+ (- (/ 6237 12207031250)) (* v10 (+ (/ 6237 152587890625000) (* v10 (+ (- (/ 130977 61035156250000000000)) (* v10 (+ (/ 56133 762939453125000000000000) (* (- (/ 56133 38146972656250000000000000000)) v10))))))))))) (/ 11088 625))))
(assert (not (<= (* (/ 3 13) v5) v50)))
(check-sat)

(set-option :produce-models false)
(set-option :produce-unsat-cores true)

; unsat, cores

; 34.red
(reset-assertions)
(assert (not (<= (* v5 (+ (- (/ 1495335813775360 3119868895908289175433)) (* (- (/ 559007298989804530384135782400 9733581927656007318022218939278759050737489)) v5))) 0)))
(assert (= (* v5 v5) (/ 1325421053866224634595698711821825 295147905179352825856)))
(assert (= (* v5 v5) (+ 277555600 (* v46 (* v46 (+ 15328072984 (* v46 (* v46 (+ 129098541721 (* v46 (* v46 (+ 21404723599 (* v46 (* v46 (+ 1024027285 (* v46 (* 15132100 v46)))))))))))))))))
(assert (not (<= v63 (/ 15707963 5000000))))
(assert (not (<= (/ 31415927 10000000) v63)))
(assert (<= 0 v5))
(check-sat)
(get-unsat-core)

; 35.red
(reset-assertions)
(assert (<= (* v8 (+ (* (- 231) v5) (* v8 (+ 315 (* v8 (+ (* (- 315) v5) (* v8 (+ 105 (* v8 (+ (* (- 105) v5) (* v8 (+ 5 (* v8 (* (- 5) v5)))))))))))))) (- 231)))
(assert (<= (* v8 (+ (* 231 v5) (* v8 (+ (- 315) (* v8 (+ (* 315 v5) (* v8 (+ (- 105) (* v8 (+ (* 105 v5) (* v8 (+ (- 5) (* v8 (* 5 v5)))))))))))))) 231))
(assert (not (<= (* v37 (+ (- 231) (* v8 (+ (* 231 v5) (* v8 (+ (- 315) (* v8 (+ (* 315 v5) (* v8 (+ (- 105) (* v8 (+ (* 105 v5) (* v8 (+ (- 5) (* v8 (* 5 v5)))))))))))))))) (+ (+ (/ 231 4) (* 231 v5)) (* v8 (+ (* (- (/ 231 4)) v5) (* v8 (+ (+ (/ 315 4) (* 546 v5)) (* v8 (+ (+ 77 (* (- (/ 315 4)) v5)) (* v8 (+ (+ (/ 105 4) (* 343 v5)) (* v8 (+ (+ (/ 294 5) (* (- (/ 105 4)) v5)) (* v8 (+ (+ (/ 5 4) (* (/ 256 5) v5)) (* v8 (+ 5 (* (- (/ 5 4)) v5)))))))))))))))))))
(assert (not (<= 0 v8)))
(assert (not (<= (* v37 (+ (- 1) (* v8 v5))) (+ v5 v8))))
(assert (<= (* v37 (+ 1 (* v8 (* (- 1) v5)))) (+ (+ 1 (* (- 1) v5)) (* v8 (+ (- 1) (* (- 1) v5))))))
(assert (not (<= 0 v5)))
(assert (not (<= v37 0)))
(assert (not (<= v5 (- 1))))
(assert (not (<= 1 v8)))
(assert (not (<= v8 v5)))
(check-sat)
(get-unsat-core)

; 36.red
(reset-assertions)
(assert (<= (* v5 (+ 12 (* v5 (+ (- 60) (* 120 v5))))) 1))
(assert (= (+ 1 (* v5 (* v5 v5))) (+ (- 1) (* v17 (* v17 v17)))))
(assert (= (* v27 (* v27 v27)) (+ (- 1) (* v17 (* v17 v17)))))
(assert (not (<= (+ (- 1) (* v17 (* v17 v17))) 2)))
(assert (not (<= v17 0)))
(assert (not (<= v5 0)))
(assert (not (<= v27 0)))
(assert (not (<= 10 (+ (- 1) (* v17 (* v17 v17))))))
(check-sat)
(get-unsat-core)

; 38.red
(reset-assertions)
(assert (not (<= (* (/ 86400000 2025130727) v5) v11)))
(assert (not (<= (* v15 (+ (- (/ 8832 13)) (* v15 (+ (- (/ 3174 1625)) (* v15 (+ (- (/ 12167 3250000)) (* v15 (+ (- (/ 1958887 416000000000)) (* v15 (+ (- (/ 6436343 1664000000000000)) (* (- (/ 148035889 79872000000000000000)) v15))))))))))) (+ (+ (/ 1536000 13) (* (/ 331776 65) v5)) (* (- (/ 24301568724 203125)) v11)))))
(check-sat)
(get-unsat-core)

; 39.red
(reset-assertions)
(assert (not (<= (* v5 (* (- 1) v6)) 0)))
(assert (not (<= v5 0)))
(assert (not (<= v14 0)))
(assert (not (<= 2 v6)))
(assert (not (<= v6 v14)))
(check-sat)
(get-unsat-core)

; 40.red
(reset-assertions)
(assert (not (<= 0 v5)))
(assert (not (<= (* v10 (+ (+ (* (- 6) v5) (* v13 (+ (+ (- 6) (* v5 (* 6 v5))) (* v13 (* 6 v5))))) (* v10 (+ (- 3) (* v13 (+ (* 6 v5) (* v13 (* v5 (* (- 3) v5))))))))) (+ (+ 1 (* v5 (* 3 v5))) (* v13 (+ (* 4 v5) (* v13 (+ 3 (* v5 v5)))))))))
(assert (not (<= v10 0)))
(assert (not (<= v5 (- 1))))
(assert (not (<= 1 v13)))
(assert (not (<= v13 v5)))
(check-sat)
(get-unsat-core)

; 41.red
(reset-assertions)
(assert (not (<= (* v5 (* v5 (* v5 (* v5 (* v5 (* v5 (* v5 (* v5 (* v5 (* v5 (* v5 (* v5 (* v5 (* v5 (* (- 2) v5))))))))))))))) 0)))
(assert (not (<= v25 1)))
(assert (not (<= v5 0)))
(assert (not (<= v30 0)))
(assert (not (<= v33 0)))
(assert (not (<= 5 v25)))
(check-sat)
(get-unsat-core)

; 42.red
(reset-assertions)
(assert (<= (* v5 (+ (- (/ 16128 5)) (* v5 (+ (/ 28224 625) (* v5 (+ (- (/ 32928 78125)) (* v5 (+ (/ 50421 19531250) (* v5 (+ (- (/ 50421 4882812500)) (* (/ 117649 4882812500000) v5))))))))))) (- 112896)))
(assert (= (* v40 v40) (+ 1 (* v42 (* (- 1) v42)))))
(assert (<= v5 75))
(assert (<= 0 v5))
(check-sat)
(get-unsat-core)

; 43.red
(reset-assertions)
(assert (not (<= (* v10 (+ (- (/ 2180412 1953125)) (* v10 (+ (/ 1635309 12207031250) (* v10 (+ (- (/ 1635309 152587890625000)) (* v10 (+ (/ 34341489 61035156250000000000) (* v10 (+ (- (/ 14717781 762939453125000000000000)) (* (/ 14717781 38146972656250000000000000000) v10))))))))))) (+ (+ (- (/ 2907216 625)) (* (/ 52704 125) v5)) (* (- (/ 228384 125)) v50)))))
(assert (not (<= (* v10 (+ (/ 8316 1953125) (* v10 (+ (- (/ 6237 12207031250)) (* v10 (+ (/ 6237 152587890625000) (* v10 (+ (- (/ 130977 61035156250000000000)) (* v10 (+ (/ 56133 762939453125000000000000) (* (- (/ 56133 38146972656250000000000000000)) v10))))))))))) (/ 11088 625))))
(assert (not (<= (* (/ 3 13) v5) v50)))
(check-sat)
(get-unsat-core)

(exit)

end;
