// uninames.cpp                            Copyright (C) 2016-2021 Codemist


/**************************************************************************
 * Copyright (C) 2021, Codemist.                         A C Norman       *
 *                                                                        *
 * Redistribution and use in source and binary forms, with or without     *
 * modification, are permitted provided that the following conditions are *
 * met:                                                                   *
 *                                                                        *
 *     * Redistributions of source code must retain the relevant          *
 *       copyright notice, this list of conditions and the following      *
 *       disclaimer.                                                      *
 *     * Redistributions in binary form must reproduce the above          *
 *       copyright notice, this list of conditions and the following      *
 *       disclaimer in the documentation and/or other materials provided  *
 *       with the distribution.                                           *
 *                                                                        *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS    *
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT      *
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS      *
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE         *
 * COPYRIGHT OWNERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,   *
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,   *
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS  *
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND *
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR  *
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF     *
 * THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH   *
 * DAMAGE.                                                                *
 *************************************************************************/

// $Id: uninames.cpp 5598 2021-01-18 17:27:01Z arthurcnorman $

// This file is derived from one made available by the Unicode Formum.
// The Unicode character name list is from the Unicode web site and
// usage rights are as described at
//           http://www.unicode.org/copyright.html
// Their notice reads...
//
// COPYRIGHT AND PERMISSION NOTICE
//
// Copyright  1991-2014 Unicode, Inc. All rights reserved.
// Distributed under the Terms of Use in
// http://www.unicode.org/copyright.html.
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of the Unicode data files and any associated documentation
// (the "Data Files") or Unicode software and any associated documentation
// (the "Software") to deal in the Data Files or Software
// without restriction, including without limitation the rights to use,
// copy, modify, merge, publish, distribute, and/or sell copies of
// the Data Files or Software, and to permit persons to whom the Data Files
// or Software are furnished to do so, provided that
// (a) this copyright and permission notice appear with all copies
// of the Data Files or Software,
// (b) this copyright and permission notice appear in associated
// documentation, and
// (c) there is clear notice in each modified Data File or in the Software
// as well as in the documentation associated with the Data File(s) or
// Software that the data or software has been modified.
//
// THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
// ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT OF THIRD PARTY RIGHTS.
// IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
// NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
// DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
// DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
// TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
// PERFORMANCE OF THE DATA FILES OR SOFTWARE.
//
// Except as contained in this notice, the name of a copyright holder
// shall not be used in advertising or otherwise to promote the sale,
// use or other dealings in these Data Files or Software without prior
// written authorization of the copyright holder.
//



// Here is my statement about modification:
//
// These should be ALL the Unicode characters in existence at the time
// of creation of this file. Names have been adjusted by replacing spaces
// and hyphens with underscores and removing a few "<>" marks, so as to
// leave names acceptable to C/C++.


// This is a complement to uninames.h (and was derived from it). IT provides
// code to map a codepoint onto the name of the symbol it represents.

// This code is clearly odd, but it is perhaps worth noting here that
// as of 2015 if this is expressed as one big switch statement it stresses
// gcc somewhat. With -O0 optimisation on a fast computer the compilation
// takes 16 seconds, and with -O3 it takes almost 3 minutes. I hope that
// by spliting this into parts I improve these to 2.5 and 25 seconds, which
// is perhaps worth the ugliness.

static const char *uniname0(int codepoint)
{   switch (codepoint)
    {   case   0x0020: return "SPACE";
        case   0x0021: return "EXCLAMATION_MARK";
        case   0x0022: return "QUOTATION_MARK";
        case   0x0023: return "NUMBER_SIGN";
        case   0x0024: return "DOLLAR_SIGN";
        case   0x0025: return "PERCENT_SIGN";
        case   0x0026: return "AMPERSAND";
        case   0x0027: return "APOSTROPHE";
        case   0x0028: return "LEFT_PARENTHESIS";
        case   0x0029: return "RIGHT_PARENTHESIS";
        case   0x002A: return "ASTERISK";
        case   0x002B: return "PLUS_SIGN";
        case   0x002C: return "COMMA";
        case   0x002D: return "HYPHEN_MINUS";
        case   0x002E: return "FULL_STOP";
        case   0x002F: return "SOLIDUS";
        case   0x0030: return "DIGIT_ZERO";
        case   0x0031: return "DIGIT_ONE";
        case   0x0032: return "DIGIT_TWO";
        case   0x0033: return "DIGIT_THREE";
        case   0x0034: return "DIGIT_FOUR";
        case   0x0035: return "DIGIT_FIVE";
        case   0x0036: return "DIGIT_SIX";
        case   0x0037: return "DIGIT_SEVEN";
        case   0x0038: return "DIGIT_EIGHT";
        case   0x0039: return "DIGIT_NINE";
        case   0x003A: return "COLON";
        case   0x003B: return "SEMICOLON";
        case   0x003C: return "LESS_THAN_SIGN";
        case   0x003D: return "EQUALS_SIGN";
        case   0x003E: return "GREATER_THAN_SIGN";
        case   0x003F: return "QUESTION_MARK";
        case   0x0040: return "COMMERCIAL_AT";
        case   0x0041: return "LATIN_CAPITAL_LETTER_A";
        case   0x0042: return "LATIN_CAPITAL_LETTER_B";
        case   0x0043: return "LATIN_CAPITAL_LETTER_C";
        case   0x0044: return "LATIN_CAPITAL_LETTER_D";
        case   0x0045: return "LATIN_CAPITAL_LETTER_E";
        case   0x0046: return "LATIN_CAPITAL_LETTER_F";
        case   0x0047: return "LATIN_CAPITAL_LETTER_G";
        case   0x0048: return "LATIN_CAPITAL_LETTER_H";
        case   0x0049: return "LATIN_CAPITAL_LETTER_I";
        case   0x004A: return "LATIN_CAPITAL_LETTER_J";
        case   0x004B: return "LATIN_CAPITAL_LETTER_K";
        case   0x004C: return "LATIN_CAPITAL_LETTER_L";
        case   0x004D: return "LATIN_CAPITAL_LETTER_M";
        case   0x004E: return "LATIN_CAPITAL_LETTER_N";
        case   0x004F: return "LATIN_CAPITAL_LETTER_O";
        case   0x0050: return "LATIN_CAPITAL_LETTER_P";
        case   0x0051: return "LATIN_CAPITAL_LETTER_Q";
        case   0x0052: return "LATIN_CAPITAL_LETTER_R";
        case   0x0053: return "LATIN_CAPITAL_LETTER_S";
        case   0x0054: return "LATIN_CAPITAL_LETTER_T";
        case   0x0055: return "LATIN_CAPITAL_LETTER_U";
        case   0x0056: return "LATIN_CAPITAL_LETTER_V";
        case   0x0057: return "LATIN_CAPITAL_LETTER_W";
        case   0x0058: return "LATIN_CAPITAL_LETTER_X";
        case   0x0059: return "LATIN_CAPITAL_LETTER_Y";
        case   0x005A: return "LATIN_CAPITAL_LETTER_Z";
        case   0x005B: return "LEFT_SQUARE_BRACKET";
        case   0x005C: return "REVERSE_SOLIDUS";
        case   0x005D: return "RIGHT_SQUARE_BRACKET";
        case   0x005E: return "CIRCUMFLEX_ACCENT";
        case   0x005F: return "LOW_LINE";
        case   0x0060: return "GRAVE_ACCENT";
        case   0x0061: return "LATIN_SMALL_LETTER_A";
        case   0x0062: return "LATIN_SMALL_LETTER_B";
        case   0x0063: return "LATIN_SMALL_LETTER_C";
        case   0x0064: return "LATIN_SMALL_LETTER_D";
        case   0x0065: return "LATIN_SMALL_LETTER_E";
        case   0x0066: return "LATIN_SMALL_LETTER_F";
        case   0x0067: return "LATIN_SMALL_LETTER_G";
        case   0x0068: return "LATIN_SMALL_LETTER_H";
        case   0x0069: return "LATIN_SMALL_LETTER_I";
        case   0x006A: return "LATIN_SMALL_LETTER_J";
        case   0x006B: return "LATIN_SMALL_LETTER_K";
        case   0x006C: return "LATIN_SMALL_LETTER_L";
        case   0x006D: return "LATIN_SMALL_LETTER_M";
        case   0x006E: return "LATIN_SMALL_LETTER_N";
        case   0x006F: return "LATIN_SMALL_LETTER_O";
        case   0x0070: return "LATIN_SMALL_LETTER_P";
        case   0x0071: return "LATIN_SMALL_LETTER_Q";
        case   0x0072: return "LATIN_SMALL_LETTER_R";
        case   0x0073: return "LATIN_SMALL_LETTER_S";
        case   0x0074: return "LATIN_SMALL_LETTER_T";
        case   0x0075: return "LATIN_SMALL_LETTER_U";
        case   0x0076: return "LATIN_SMALL_LETTER_V";
        case   0x0077: return "LATIN_SMALL_LETTER_W";
        case   0x0078: return "LATIN_SMALL_LETTER_X";
        case   0x0079: return "LATIN_SMALL_LETTER_Y";
        case   0x007A: return "LATIN_SMALL_LETTER_Z";
        case   0x007B: return "LEFT_CURLY_BRACKET";
        case   0x007C: return "VERTICAL_LINE";
        case   0x007D: return "RIGHT_CURLY_BRACKET";
        case   0x007E: return "TILDE";
        case   0x00A0: return "NO_BREAK_SPACE";
        case   0x00A1: return "INVERTED_EXCLAMATION_MARK";
        case   0x00A2: return "CENT_SIGN";
        case   0x00A3: return "POUND_SIGN";
        case   0x00A4: return "CURRENCY_SIGN";
        case   0x00A5: return "YEN_SIGN";
        case   0x00A6: return "BROKEN_BAR";
        case   0x00A7: return "SECTION_SIGN";
        case   0x00A8: return "DIAERESIS";
        case   0x00A9: return "COPYRIGHT_SIGN";
        case   0x00AA: return "FEMININE_ORDINAL_INDICATOR";
        case   0x00AB: return "LEFT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK";
        case   0x00AC: return "NOT_SIGN";
        case   0x00AD: return "SOFT_HYPHEN";
        case   0x00AE: return "REGISTERED_SIGN";
        case   0x00AF: return "MACRON";
        case   0x00B0: return "DEGREE_SIGN";
        case   0x00B1: return "PLUS_MINUS_SIGN";
        case   0x00B2: return "SUPERSCRIPT_TWO";
        case   0x00B3: return "SUPERSCRIPT_THREE";
        case   0x00B4: return "ACUTE_ACCENT";
        case   0x00B5: return "MICRO_SIGN";
        case   0x00B6: return "PILCROW_SIGN";
        case   0x00B7: return "MIDDLE_DOT";
        case   0x00B8: return "CEDILLA";
        case   0x00B9: return "SUPERSCRIPT_ONE";
        case   0x00BA: return "MASCULINE_ORDINAL_INDICATOR";
        case   0x00BB: return "RIGHT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK";
        case   0x00BC: return "VULGAR_FRACTION_ONE_QUARTER";
        case   0x00BD: return "VULGAR_FRACTION_ONE_HALF";
        case   0x00BE: return "VULGAR_FRACTION_THREE_QUARTERS";
        case   0x00BF: return "INVERTED_QUESTION_MARK";
        case   0x00C0: return "LATIN_CAPITAL_LETTER_A_WITH_GRAVE";
        case   0x00C1: return "LATIN_CAPITAL_LETTER_A_WITH_ACUTE";
        case   0x00C2: return "LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX";
        case   0x00C3: return "LATIN_CAPITAL_LETTER_A_WITH_TILDE";
        case   0x00C4: return "LATIN_CAPITAL_LETTER_A_WITH_DIAERESIS";
        case   0x00C5: return "LATIN_CAPITAL_LETTER_A_WITH_RING_ABOVE";
        case   0x00C6: return "LATIN_CAPITAL_LETTER_AE";
        case   0x00C7: return "LATIN_CAPITAL_LETTER_C_WITH_CEDILLA";
        case   0x00C8: return "LATIN_CAPITAL_LETTER_E_WITH_GRAVE";
        case   0x00C9: return "LATIN_CAPITAL_LETTER_E_WITH_ACUTE";
        case   0x00CA: return "LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX";
        case   0x00CB: return "LATIN_CAPITAL_LETTER_E_WITH_DIAERESIS";
        case   0x00CC: return "LATIN_CAPITAL_LETTER_I_WITH_GRAVE";
        case   0x00CD: return "LATIN_CAPITAL_LETTER_I_WITH_ACUTE";
        case   0x00CE: return "LATIN_CAPITAL_LETTER_I_WITH_CIRCUMFLEX";
        case   0x00CF: return "LATIN_CAPITAL_LETTER_I_WITH_DIAERESIS";
        case   0x00D0: return "LATIN_CAPITAL_LETTER_ETH";
        case   0x00D1: return "LATIN_CAPITAL_LETTER_N_WITH_TILDE";
        case   0x00D2: return "LATIN_CAPITAL_LETTER_O_WITH_GRAVE";
        case   0x00D3: return "LATIN_CAPITAL_LETTER_O_WITH_ACUTE";
        case   0x00D4: return "LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX";
        case   0x00D5: return "LATIN_CAPITAL_LETTER_O_WITH_TILDE";
        case   0x00D6: return "LATIN_CAPITAL_LETTER_O_WITH_DIAERESIS";
        case   0x00D7: return "MULTIPLICATION_SIGN";
        case   0x00D8: return "LATIN_CAPITAL_LETTER_O_WITH_STROKE";
        case   0x00D9: return "LATIN_CAPITAL_LETTER_U_WITH_GRAVE";
        case   0x00DA: return "LATIN_CAPITAL_LETTER_U_WITH_ACUTE";
        case   0x00DB: return "LATIN_CAPITAL_LETTER_U_WITH_CIRCUMFLEX";
        case   0x00DC: return "LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS";
        case   0x00DD: return "LATIN_CAPITAL_LETTER_Y_WITH_ACUTE";
        case   0x00DE: return "LATIN_CAPITAL_LETTER_THORN";
        case   0x00DF: return "LATIN_SMALL_LETTER_SHARP_S";
        case   0x00E0: return "LATIN_SMALL_LETTER_A_WITH_GRAVE";
        case   0x00E1: return "LATIN_SMALL_LETTER_A_WITH_ACUTE";
        case   0x00E2: return "LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX";
        case   0x00E3: return "LATIN_SMALL_LETTER_A_WITH_TILDE";
        case   0x00E4: return "LATIN_SMALL_LETTER_A_WITH_DIAERESIS";
        case   0x00E5: return "LATIN_SMALL_LETTER_A_WITH_RING_ABOVE";
        case   0x00E6: return "LATIN_SMALL_LETTER_AE";
        case   0x00E7: return "LATIN_SMALL_LETTER_C_WITH_CEDILLA";
        case   0x00E8: return "LATIN_SMALL_LETTER_E_WITH_GRAVE";
        case   0x00E9: return "LATIN_SMALL_LETTER_E_WITH_ACUTE";
        case   0x00EA: return "LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX";
        case   0x00EB: return "LATIN_SMALL_LETTER_E_WITH_DIAERESIS";
        case   0x00EC: return "LATIN_SMALL_LETTER_I_WITH_GRAVE";
        case   0x00ED: return "LATIN_SMALL_LETTER_I_WITH_ACUTE";
        case   0x00EE: return "LATIN_SMALL_LETTER_I_WITH_CIRCUMFLEX";
        case   0x00EF: return "LATIN_SMALL_LETTER_I_WITH_DIAERESIS";
        case   0x00F0: return "LATIN_SMALL_LETTER_ETH";
        case   0x00F1: return "LATIN_SMALL_LETTER_N_WITH_TILDE";
        case   0x00F2: return "LATIN_SMALL_LETTER_O_WITH_GRAVE";
        case   0x00F3: return "LATIN_SMALL_LETTER_O_WITH_ACUTE";
        case   0x00F4: return "LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX";
        case   0x00F5: return "LATIN_SMALL_LETTER_O_WITH_TILDE";
        case   0x00F6: return "LATIN_SMALL_LETTER_O_WITH_DIAERESIS";
        case   0x00F7: return "DIVISION_SIGN";
        case   0x00F8: return "LATIN_SMALL_LETTER_O_WITH_STROKE";
        case   0x00F9: return "LATIN_SMALL_LETTER_U_WITH_GRAVE";
        case   0x00FA: return "LATIN_SMALL_LETTER_U_WITH_ACUTE";
        case   0x00FB: return "LATIN_SMALL_LETTER_U_WITH_CIRCUMFLEX";
        case   0x00FC: return "LATIN_SMALL_LETTER_U_WITH_DIAERESIS";
        case   0x00FD: return "LATIN_SMALL_LETTER_Y_WITH_ACUTE";
        case   0x00FE: return "LATIN_SMALL_LETTER_THORN";
        case   0x00FF: return "LATIN_SMALL_LETTER_Y_WITH_DIAERESIS";
        case   0x0100: return "LATIN_CAPITAL_LETTER_A_WITH_MACRON";
        case   0x0101: return "LATIN_SMALL_LETTER_A_WITH_MACRON";
        case   0x0102: return "LATIN_CAPITAL_LETTER_A_WITH_BREVE";
        case   0x0103: return "LATIN_SMALL_LETTER_A_WITH_BREVE";
        case   0x0104: return "LATIN_CAPITAL_LETTER_A_WITH_OGONEK";
        case   0x0105: return "LATIN_SMALL_LETTER_A_WITH_OGONEK";
        case   0x0106: return "LATIN_CAPITAL_LETTER_C_WITH_ACUTE";
        case   0x0107: return "LATIN_SMALL_LETTER_C_WITH_ACUTE";
        case   0x0108: return "LATIN_CAPITAL_LETTER_C_WITH_CIRCUMFLEX";
        case   0x0109: return "LATIN_SMALL_LETTER_C_WITH_CIRCUMFLEX";
        case   0x010A: return "LATIN_CAPITAL_LETTER_C_WITH_DOT_ABOVE";
        case   0x010B: return "LATIN_SMALL_LETTER_C_WITH_DOT_ABOVE";
        case   0x010C: return "LATIN_CAPITAL_LETTER_C_WITH_CARON";
        case   0x010D: return "LATIN_SMALL_LETTER_C_WITH_CARON";
        case   0x010E: return "LATIN_CAPITAL_LETTER_D_WITH_CARON";
        case   0x010F: return "LATIN_SMALL_LETTER_D_WITH_CARON";
        case   0x0110: return "LATIN_CAPITAL_LETTER_D_WITH_STROKE";
        case   0x0111: return "LATIN_SMALL_LETTER_D_WITH_STROKE";
        case   0x0112: return "LATIN_CAPITAL_LETTER_E_WITH_MACRON";
        case   0x0113: return "LATIN_SMALL_LETTER_E_WITH_MACRON";
        case   0x0114: return "LATIN_CAPITAL_LETTER_E_WITH_BREVE";
        case   0x0115: return "LATIN_SMALL_LETTER_E_WITH_BREVE";
        case   0x0116: return "LATIN_CAPITAL_LETTER_E_WITH_DOT_ABOVE";
        case   0x0117: return "LATIN_SMALL_LETTER_E_WITH_DOT_ABOVE";
        case   0x0118: return "LATIN_CAPITAL_LETTER_E_WITH_OGONEK";
        case   0x0119: return "LATIN_SMALL_LETTER_E_WITH_OGONEK";
        case   0x011A: return "LATIN_CAPITAL_LETTER_E_WITH_CARON";
        case   0x011B: return "LATIN_SMALL_LETTER_E_WITH_CARON";
        case   0x011C: return "LATIN_CAPITAL_LETTER_G_WITH_CIRCUMFLEX";
        case   0x011D: return "LATIN_SMALL_LETTER_G_WITH_CIRCUMFLEX";
        case   0x011E: return "LATIN_CAPITAL_LETTER_G_WITH_BREVE";
        case   0x011F: return "LATIN_SMALL_LETTER_G_WITH_BREVE";
        case   0x0120: return "LATIN_CAPITAL_LETTER_G_WITH_DOT_ABOVE";
        case   0x0121: return "LATIN_SMALL_LETTER_G_WITH_DOT_ABOVE";
        case   0x0122: return "LATIN_CAPITAL_LETTER_G_WITH_CEDILLA";
        case   0x0123: return "LATIN_SMALL_LETTER_G_WITH_CEDILLA";
        case   0x0124: return "LATIN_CAPITAL_LETTER_H_WITH_CIRCUMFLEX";
        case   0x0125: return "LATIN_SMALL_LETTER_H_WITH_CIRCUMFLEX";
        case   0x0126: return "LATIN_CAPITAL_LETTER_H_WITH_STROKE";
        case   0x0127: return "LATIN_SMALL_LETTER_H_WITH_STROKE";
        case   0x0128: return "LATIN_CAPITAL_LETTER_I_WITH_TILDE";
        case   0x0129: return "LATIN_SMALL_LETTER_I_WITH_TILDE";
        case   0x012A: return "LATIN_CAPITAL_LETTER_I_WITH_MACRON";
        case   0x012B: return "LATIN_SMALL_LETTER_I_WITH_MACRON";
        case   0x012C: return "LATIN_CAPITAL_LETTER_I_WITH_BREVE";
        case   0x012D: return "LATIN_SMALL_LETTER_I_WITH_BREVE";
        case   0x012E: return "LATIN_CAPITAL_LETTER_I_WITH_OGONEK";
        case   0x012F: return "LATIN_SMALL_LETTER_I_WITH_OGONEK";
        case   0x0130: return "LATIN_CAPITAL_LETTER_I_WITH_DOT_ABOVE";
        case   0x0131: return "LATIN_SMALL_LETTER_DOTLESS_I";
        case   0x0132: return "LATIN_CAPITAL_LIGATURE_IJ";
        case   0x0133: return "LATIN_SMALL_LIGATURE_IJ";
        case   0x0134: return "LATIN_CAPITAL_LETTER_J_WITH_CIRCUMFLEX";
        case   0x0135: return "LATIN_SMALL_LETTER_J_WITH_CIRCUMFLEX";
        case   0x0136: return "LATIN_CAPITAL_LETTER_K_WITH_CEDILLA";
        case   0x0137: return "LATIN_SMALL_LETTER_K_WITH_CEDILLA";
        case   0x0138: return "LATIN_SMALL_LETTER_KRA";
        case   0x0139: return "LATIN_CAPITAL_LETTER_L_WITH_ACUTE";
        case   0x013A: return "LATIN_SMALL_LETTER_L_WITH_ACUTE";
        case   0x013B: return "LATIN_CAPITAL_LETTER_L_WITH_CEDILLA";
        case   0x013C: return "LATIN_SMALL_LETTER_L_WITH_CEDILLA";
        case   0x013D: return "LATIN_CAPITAL_LETTER_L_WITH_CARON";
        case   0x013E: return "LATIN_SMALL_LETTER_L_WITH_CARON";
        case   0x013F: return "LATIN_CAPITAL_LETTER_L_WITH_MIDDLE_DOT";
        case   0x0140: return "LATIN_SMALL_LETTER_L_WITH_MIDDLE_DOT";
        case   0x0141: return "LATIN_CAPITAL_LETTER_L_WITH_STROKE";
        case   0x0142: return "LATIN_SMALL_LETTER_L_WITH_STROKE";
        case   0x0143: return "LATIN_CAPITAL_LETTER_N_WITH_ACUTE";
        case   0x0144: return "LATIN_SMALL_LETTER_N_WITH_ACUTE";
        case   0x0145: return "LATIN_CAPITAL_LETTER_N_WITH_CEDILLA";
        case   0x0146: return "LATIN_SMALL_LETTER_N_WITH_CEDILLA";
        case   0x0147: return "LATIN_CAPITAL_LETTER_N_WITH_CARON";
        case   0x0148: return "LATIN_SMALL_LETTER_N_WITH_CARON";
        case   0x0149: return "LATIN_SMALL_LETTER_N_PRECEDED_BY_APOSTROPHE";
        case   0x014A: return "LATIN_CAPITAL_LETTER_ENG";
        case   0x014B: return "LATIN_SMALL_LETTER_ENG";
        case   0x014C: return "LATIN_CAPITAL_LETTER_O_WITH_MACRON";
        case   0x014D: return "LATIN_SMALL_LETTER_O_WITH_MACRON";
        case   0x014E: return "LATIN_CAPITAL_LETTER_O_WITH_BREVE";
        case   0x014F: return "LATIN_SMALL_LETTER_O_WITH_BREVE";
        case   0x0150: return "LATIN_CAPITAL_LETTER_O_WITH_DOUBLE_ACUTE";
        case   0x0151: return "LATIN_SMALL_LETTER_O_WITH_DOUBLE_ACUTE";
        case   0x0152: return "LATIN_CAPITAL_LIGATURE_OE";
        case   0x0153: return "LATIN_SMALL_LIGATURE_OE";
        case   0x0154: return "LATIN_CAPITAL_LETTER_R_WITH_ACUTE";
        case   0x0155: return "LATIN_SMALL_LETTER_R_WITH_ACUTE";
        case   0x0156: return "LATIN_CAPITAL_LETTER_R_WITH_CEDILLA";
        case   0x0157: return "LATIN_SMALL_LETTER_R_WITH_CEDILLA";
        case   0x0158: return "LATIN_CAPITAL_LETTER_R_WITH_CARON";
        case   0x0159: return "LATIN_SMALL_LETTER_R_WITH_CARON";
        case   0x015A: return "LATIN_CAPITAL_LETTER_S_WITH_ACUTE";
        case   0x015B: return "LATIN_SMALL_LETTER_S_WITH_ACUTE";
        case   0x015C: return "LATIN_CAPITAL_LETTER_S_WITH_CIRCUMFLEX";
        case   0x015D: return "LATIN_SMALL_LETTER_S_WITH_CIRCUMFLEX";
        case   0x015E: return "LATIN_CAPITAL_LETTER_S_WITH_CEDILLA";
        case   0x015F: return "LATIN_SMALL_LETTER_S_WITH_CEDILLA";
        case   0x0160: return "LATIN_CAPITAL_LETTER_S_WITH_CARON";
        case   0x0161: return "LATIN_SMALL_LETTER_S_WITH_CARON";
        case   0x0162: return "LATIN_CAPITAL_LETTER_T_WITH_CEDILLA";
        case   0x0163: return "LATIN_SMALL_LETTER_T_WITH_CEDILLA";
        case   0x0164: return "LATIN_CAPITAL_LETTER_T_WITH_CARON";
        case   0x0165: return "LATIN_SMALL_LETTER_T_WITH_CARON";
        case   0x0166: return "LATIN_CAPITAL_LETTER_T_WITH_STROKE";
        case   0x0167: return "LATIN_SMALL_LETTER_T_WITH_STROKE";
        case   0x0168: return "LATIN_CAPITAL_LETTER_U_WITH_TILDE";
        case   0x0169: return "LATIN_SMALL_LETTER_U_WITH_TILDE";
        case   0x016A: return "LATIN_CAPITAL_LETTER_U_WITH_MACRON";
        case   0x016B: return "LATIN_SMALL_LETTER_U_WITH_MACRON";
        case   0x016C: return "LATIN_CAPITAL_LETTER_U_WITH_BREVE";
        case   0x016D: return "LATIN_SMALL_LETTER_U_WITH_BREVE";
        case   0x016E: return "LATIN_CAPITAL_LETTER_U_WITH_RING_ABOVE";
        case   0x016F: return "LATIN_SMALL_LETTER_U_WITH_RING_ABOVE";
        case   0x0170: return "LATIN_CAPITAL_LETTER_U_WITH_DOUBLE_ACUTE";
        case   0x0171: return "LATIN_SMALL_LETTER_U_WITH_DOUBLE_ACUTE";
        case   0x0172: return "LATIN_CAPITAL_LETTER_U_WITH_OGONEK";
        case   0x0173: return "LATIN_SMALL_LETTER_U_WITH_OGONEK";
        case   0x0174: return "LATIN_CAPITAL_LETTER_W_WITH_CIRCUMFLEX";
        case   0x0175: return "LATIN_SMALL_LETTER_W_WITH_CIRCUMFLEX";
        case   0x0176: return "LATIN_CAPITAL_LETTER_Y_WITH_CIRCUMFLEX";
        case   0x0177: return "LATIN_SMALL_LETTER_Y_WITH_CIRCUMFLEX";
        case   0x0178: return "LATIN_CAPITAL_LETTER_Y_WITH_DIAERESIS";
        case   0x0179: return "LATIN_CAPITAL_LETTER_Z_WITH_ACUTE";
        case   0x017A: return "LATIN_SMALL_LETTER_Z_WITH_ACUTE";
        case   0x017B: return "LATIN_CAPITAL_LETTER_Z_WITH_DOT_ABOVE";
        case   0x017C: return "LATIN_SMALL_LETTER_Z_WITH_DOT_ABOVE";
        case   0x017D: return "LATIN_CAPITAL_LETTER_Z_WITH_CARON";
        case   0x017E: return "LATIN_SMALL_LETTER_Z_WITH_CARON";
        case   0x017F: return "LATIN_SMALL_LETTER_LONG_S";
        case   0x0180: return "LATIN_SMALL_LETTER_B_WITH_STROKE";
        case   0x0181: return "LATIN_CAPITAL_LETTER_B_WITH_HOOK";
        case   0x0182: return "LATIN_CAPITAL_LETTER_B_WITH_TOPBAR";
        case   0x0183: return "LATIN_SMALL_LETTER_B_WITH_TOPBAR";
        case   0x0184: return "LATIN_CAPITAL_LETTER_TONE_SIX";
        case   0x0185: return "LATIN_SMALL_LETTER_TONE_SIX";
        case   0x0186: return "LATIN_CAPITAL_LETTER_OPEN_O";
        case   0x0187: return "LATIN_CAPITAL_LETTER_C_WITH_HOOK";
        case   0x0188: return "LATIN_SMALL_LETTER_C_WITH_HOOK";
        case   0x0189: return "LATIN_CAPITAL_LETTER_AFRICAN_D";
        case   0x018A: return "LATIN_CAPITAL_LETTER_D_WITH_HOOK";
        case   0x018B: return "LATIN_CAPITAL_LETTER_D_WITH_TOPBAR";
        case   0x018C: return "LATIN_SMALL_LETTER_D_WITH_TOPBAR";
        case   0x018D: return "LATIN_SMALL_LETTER_TURNED_DELTA";
        case   0x018E: return "LATIN_CAPITAL_LETTER_REVERSED_E";
        case   0x018F: return "LATIN_CAPITAL_LETTER_SCHWA";
        case   0x0190: return "LATIN_CAPITAL_LETTER_OPEN_E";
        case   0x0191: return "LATIN_CAPITAL_LETTER_F_WITH_HOOK";
        case   0x0192: return "LATIN_SMALL_LETTER_F_WITH_HOOK";
        case   0x0193: return "LATIN_CAPITAL_LETTER_G_WITH_HOOK";
        case   0x0194: return "LATIN_CAPITAL_LETTER_GAMMA";
        case   0x0195: return "LATIN_SMALL_LETTER_HV";
        case   0x0196: return "LATIN_CAPITAL_LETTER_IOTA";
        case   0x0197: return "LATIN_CAPITAL_LETTER_I_WITH_STROKE";
        case   0x0198: return "LATIN_CAPITAL_LETTER_K_WITH_HOOK";
        case   0x0199: return "LATIN_SMALL_LETTER_K_WITH_HOOK";
        case   0x019A: return "LATIN_SMALL_LETTER_L_WITH_BAR";
        case   0x019B: return "LATIN_SMALL_LETTER_LAMBDA_WITH_STROKE";
        case   0x019C: return "LATIN_CAPITAL_LETTER_TURNED_M";
        case   0x019D: return "LATIN_CAPITAL_LETTER_N_WITH_LEFT_HOOK";
        case   0x019E: return "LATIN_SMALL_LETTER_N_WITH_LONG_RIGHT_LEG";
        case   0x019F: return "LATIN_CAPITAL_LETTER_O_WITH_MIDDLE_TILDE";
        case   0x01A0: return "LATIN_CAPITAL_LETTER_O_WITH_HORN";
        case   0x01A1: return "LATIN_SMALL_LETTER_O_WITH_HORN";
        case   0x01A2: return "LATIN_CAPITAL_LETTER_OI";
        case   0x01A3: return "LATIN_SMALL_LETTER_OI";
        case   0x01A4: return "LATIN_CAPITAL_LETTER_P_WITH_HOOK";
        case   0x01A5: return "LATIN_SMALL_LETTER_P_WITH_HOOK";
        case   0x01A6: return "LATIN_LETTER_YR";
        case   0x01A7: return "LATIN_CAPITAL_LETTER_TONE_TWO";
        case   0x01A8: return "LATIN_SMALL_LETTER_TONE_TWO";
        case   0x01A9: return "LATIN_CAPITAL_LETTER_ESH";
        case   0x01AA: return "LATIN_LETTER_REVERSED_ESH_LOOP";
        case   0x01AB: return "LATIN_SMALL_LETTER_T_WITH_PALATAL_HOOK";
        case   0x01AC: return "LATIN_CAPITAL_LETTER_T_WITH_HOOK";
        case   0x01AD: return "LATIN_SMALL_LETTER_T_WITH_HOOK";
        case   0x01AE: return "LATIN_CAPITAL_LETTER_T_WITH_RETROFLEX_HOOK";
        case   0x01AF: return "LATIN_CAPITAL_LETTER_U_WITH_HORN";
        case   0x01B0: return "LATIN_SMALL_LETTER_U_WITH_HORN";
        case   0x01B1: return "LATIN_CAPITAL_LETTER_UPSILON";
        case   0x01B2: return "LATIN_CAPITAL_LETTER_V_WITH_HOOK";
        case   0x01B3: return "LATIN_CAPITAL_LETTER_Y_WITH_HOOK";
        case   0x01B4: return "LATIN_SMALL_LETTER_Y_WITH_HOOK";
        case   0x01B5: return "LATIN_CAPITAL_LETTER_Z_WITH_STROKE";
        case   0x01B6: return "LATIN_SMALL_LETTER_Z_WITH_STROKE";
        case   0x01B7: return "LATIN_CAPITAL_LETTER_EZH";
        case   0x01B8: return "LATIN_CAPITAL_LETTER_EZH_REVERSED";
        case   0x01B9: return "LATIN_SMALL_LETTER_EZH_REVERSED";
        case   0x01BA: return "LATIN_SMALL_LETTER_EZH_WITH_TAIL";
        case   0x01BB: return "LATIN_LETTER_TWO_WITH_STROKE";
        case   0x01BC: return "LATIN_CAPITAL_LETTER_TONE_FIVE";
        case   0x01BD: return "LATIN_SMALL_LETTER_TONE_FIVE";
        case   0x01BE: return
                "LATIN_LETTER_INVERTED_GLOTTAL_STOP_WITH_STROKE";
        case   0x01BF: return "LATIN_LETTER_WYNN";
        case   0x01C0: return "LATIN_LETTER_DENTAL_CLICK";
        case   0x01C1: return "LATIN_LETTER_LATERAL_CLICK";
        case   0x01C2: return "LATIN_LETTER_ALVEOLAR_CLICK";
        case   0x01C3: return "LATIN_LETTER_RETROFLEX_CLICK";
        case   0x01C4: return "LATIN_CAPITAL_LETTER_DZ_WITH_CARON";
        case   0x01C5: return
                "LATIN_CAPITAL_LETTER_D_WITH_SMALL_LETTER_Z_WITH_CARON";
        case   0x01C6: return "LATIN_SMALL_LETTER_DZ_WITH_CARON";
        case   0x01C7: return "LATIN_CAPITAL_LETTER_LJ";
        case   0x01C8: return "LATIN_CAPITAL_LETTER_L_WITH_SMALL_LETTER_J";
        case   0x01C9: return "LATIN_SMALL_LETTER_LJ";
        case   0x01CA: return "LATIN_CAPITAL_LETTER_NJ";
        case   0x01CB: return "LATIN_CAPITAL_LETTER_N_WITH_SMALL_LETTER_J";
        case   0x01CC: return "LATIN_SMALL_LETTER_NJ";
        case   0x01CD: return "LATIN_CAPITAL_LETTER_A_WITH_CARON";
        case   0x01CE: return "LATIN_SMALL_LETTER_A_WITH_CARON";
        case   0x01CF: return "LATIN_CAPITAL_LETTER_I_WITH_CARON";
        case   0x01D0: return "LATIN_SMALL_LETTER_I_WITH_CARON";
        case   0x01D1: return "LATIN_CAPITAL_LETTER_O_WITH_CARON";
        case   0x01D2: return "LATIN_SMALL_LETTER_O_WITH_CARON";
        case   0x01D3: return "LATIN_CAPITAL_LETTER_U_WITH_CARON";
        case   0x01D4: return "LATIN_SMALL_LETTER_U_WITH_CARON";
        case   0x01D5: return
                "LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS_AND_MACRON";
        case   0x01D6: return
                "LATIN_SMALL_LETTER_U_WITH_DIAERESIS_AND_MACRON";
        case   0x01D7: return
                "LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS_AND_ACUTE";
        case   0x01D8: return "LATIN_SMALL_LETTER_U_WITH_DIAERESIS_AND_ACUTE";
        case   0x01D9: return
                "LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS_AND_CARON";
        case   0x01DA: return "LATIN_SMALL_LETTER_U_WITH_DIAERESIS_AND_CARON";
        case   0x01DB: return
                "LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS_AND_GRAVE";
        case   0x01DC: return "LATIN_SMALL_LETTER_U_WITH_DIAERESIS_AND_GRAVE";
        case   0x01DD: return "LATIN_SMALL_LETTER_TURNED_E";
        case   0x01DE: return
                "LATIN_CAPITAL_LETTER_A_WITH_DIAERESIS_AND_MACRON";
        case   0x01DF: return
                "LATIN_SMALL_LETTER_A_WITH_DIAERESIS_AND_MACRON";
        case   0x01E0: return
                "LATIN_CAPITAL_LETTER_A_WITH_DOT_ABOVE_AND_MACRON";
        case   0x01E1: return
                "LATIN_SMALL_LETTER_A_WITH_DOT_ABOVE_AND_MACRON";
        case   0x01E2: return "LATIN_CAPITAL_LETTER_AE_WITH_MACRON";
        case   0x01E3: return "LATIN_SMALL_LETTER_AE_WITH_MACRON";
        case   0x01E4: return "LATIN_CAPITAL_LETTER_G_WITH_STROKE";
        case   0x01E5: return "LATIN_SMALL_LETTER_G_WITH_STROKE";
        case   0x01E6: return "LATIN_CAPITAL_LETTER_G_WITH_CARON";
        case   0x01E7: return "LATIN_SMALL_LETTER_G_WITH_CARON";
        case   0x01E8: return "LATIN_CAPITAL_LETTER_K_WITH_CARON";
        case   0x01E9: return "LATIN_SMALL_LETTER_K_WITH_CARON";
        case   0x01EA: return "LATIN_CAPITAL_LETTER_O_WITH_OGONEK";
        case   0x01EB: return "LATIN_SMALL_LETTER_O_WITH_OGONEK";
        case   0x01EC: return "LATIN_CAPITAL_LETTER_O_WITH_OGONEK_AND_MACRON";
        case   0x01ED: return "LATIN_SMALL_LETTER_O_WITH_OGONEK_AND_MACRON";
        case   0x01EE: return "LATIN_CAPITAL_LETTER_EZH_WITH_CARON";
        case   0x01EF: return "LATIN_SMALL_LETTER_EZH_WITH_CARON";
        case   0x01F0: return "LATIN_SMALL_LETTER_J_WITH_CARON";
        case   0x01F1: return "LATIN_CAPITAL_LETTER_DZ";
        case   0x01F2: return "LATIN_CAPITAL_LETTER_D_WITH_SMALL_LETTER_Z";
        case   0x01F3: return "LATIN_SMALL_LETTER_DZ";
        case   0x01F4: return "LATIN_CAPITAL_LETTER_G_WITH_ACUTE";
        case   0x01F5: return "LATIN_SMALL_LETTER_G_WITH_ACUTE";
        case   0x01F6: return "LATIN_CAPITAL_LETTER_HWAIR";
        case   0x01F7: return "LATIN_CAPITAL_LETTER_WYNN";
        case   0x01F8: return "LATIN_CAPITAL_LETTER_N_WITH_GRAVE";
        case   0x01F9: return "LATIN_SMALL_LETTER_N_WITH_GRAVE";
        case   0x01FA: return
                "LATIN_CAPITAL_LETTER_A_WITH_RING_ABOVE_AND_ACUTE";
        case   0x01FB: return
                "LATIN_SMALL_LETTER_A_WITH_RING_ABOVE_AND_ACUTE";
        case   0x01FC: return "LATIN_CAPITAL_LETTER_AE_WITH_ACUTE";
        case   0x01FD: return "LATIN_SMALL_LETTER_AE_WITH_ACUTE";
        case   0x01FE: return "LATIN_CAPITAL_LETTER_O_WITH_STROKE_AND_ACUTE";
        case   0x01FF: return "LATIN_SMALL_LETTER_O_WITH_STROKE_AND_ACUTE";
        case   0x0200: return "LATIN_CAPITAL_LETTER_A_WITH_DOUBLE_GRAVE";
        case   0x0201: return "LATIN_SMALL_LETTER_A_WITH_DOUBLE_GRAVE";
        case   0x0202: return "LATIN_CAPITAL_LETTER_A_WITH_INVERTED_BREVE";
        case   0x0203: return "LATIN_SMALL_LETTER_A_WITH_INVERTED_BREVE";
        case   0x0204: return "LATIN_CAPITAL_LETTER_E_WITH_DOUBLE_GRAVE";
        case   0x0205: return "LATIN_SMALL_LETTER_E_WITH_DOUBLE_GRAVE";
        case   0x0206: return "LATIN_CAPITAL_LETTER_E_WITH_INVERTED_BREVE";
        case   0x0207: return "LATIN_SMALL_LETTER_E_WITH_INVERTED_BREVE";
        case   0x0208: return "LATIN_CAPITAL_LETTER_I_WITH_DOUBLE_GRAVE";
        case   0x0209: return "LATIN_SMALL_LETTER_I_WITH_DOUBLE_GRAVE";
        case   0x020A: return "LATIN_CAPITAL_LETTER_I_WITH_INVERTED_BREVE";
        case   0x020B: return "LATIN_SMALL_LETTER_I_WITH_INVERTED_BREVE";
        case   0x020C: return "LATIN_CAPITAL_LETTER_O_WITH_DOUBLE_GRAVE";
        case   0x020D: return "LATIN_SMALL_LETTER_O_WITH_DOUBLE_GRAVE";
        case   0x020E: return "LATIN_CAPITAL_LETTER_O_WITH_INVERTED_BREVE";
        case   0x020F: return "LATIN_SMALL_LETTER_O_WITH_INVERTED_BREVE";
        case   0x0210: return "LATIN_CAPITAL_LETTER_R_WITH_DOUBLE_GRAVE";
        case   0x0211: return "LATIN_SMALL_LETTER_R_WITH_DOUBLE_GRAVE";
        case   0x0212: return "LATIN_CAPITAL_LETTER_R_WITH_INVERTED_BREVE";
        case   0x0213: return "LATIN_SMALL_LETTER_R_WITH_INVERTED_BREVE";
        case   0x0214: return "LATIN_CAPITAL_LETTER_U_WITH_DOUBLE_GRAVE";
        case   0x0215: return "LATIN_SMALL_LETTER_U_WITH_DOUBLE_GRAVE";
        case   0x0216: return "LATIN_CAPITAL_LETTER_U_WITH_INVERTED_BREVE";
        case   0x0217: return "LATIN_SMALL_LETTER_U_WITH_INVERTED_BREVE";
        case   0x0218: return "LATIN_CAPITAL_LETTER_S_WITH_COMMA_BELOW";
        case   0x0219: return "LATIN_SMALL_LETTER_S_WITH_COMMA_BELOW";
        case   0x021A: return "LATIN_CAPITAL_LETTER_T_WITH_COMMA_BELOW";
        case   0x021B: return "LATIN_SMALL_LETTER_T_WITH_COMMA_BELOW";
        case   0x021C: return "LATIN_CAPITAL_LETTER_YOGH";
        case   0x021D: return "LATIN_SMALL_LETTER_YOGH";
        case   0x021E: return "LATIN_CAPITAL_LETTER_H_WITH_CARON";
        case   0x021F: return "LATIN_SMALL_LETTER_H_WITH_CARON";
        case   0x0220: return "LATIN_CAPITAL_LETTER_N_WITH_LONG_RIGHT_LEG";
        case   0x0221: return "LATIN_SMALL_LETTER_D_WITH_CURL";
        case   0x0222: return "LATIN_CAPITAL_LETTER_OU";
        case   0x0223: return "LATIN_SMALL_LETTER_OU";
        case   0x0224: return "LATIN_CAPITAL_LETTER_Z_WITH_HOOK";
        case   0x0225: return "LATIN_SMALL_LETTER_Z_WITH_HOOK";
        case   0x0226: return "LATIN_CAPITAL_LETTER_A_WITH_DOT_ABOVE";
        case   0x0227: return "LATIN_SMALL_LETTER_A_WITH_DOT_ABOVE";
        case   0x0228: return "LATIN_CAPITAL_LETTER_E_WITH_CEDILLA";
        case   0x0229: return "LATIN_SMALL_LETTER_E_WITH_CEDILLA";
        case   0x022A: return
                "LATIN_CAPITAL_LETTER_O_WITH_DIAERESIS_AND_MACRON";
        case   0x022B: return
                "LATIN_SMALL_LETTER_O_WITH_DIAERESIS_AND_MACRON";
        case   0x022C: return "LATIN_CAPITAL_LETTER_O_WITH_TILDE_AND_MACRON";
        case   0x022D: return "LATIN_SMALL_LETTER_O_WITH_TILDE_AND_MACRON";
        case   0x022E: return "LATIN_CAPITAL_LETTER_O_WITH_DOT_ABOVE";
        case   0x022F: return "LATIN_SMALL_LETTER_O_WITH_DOT_ABOVE";
        case   0x0230: return
                "LATIN_CAPITAL_LETTER_O_WITH_DOT_ABOVE_AND_MACRON";
        case   0x0231: return
                "LATIN_SMALL_LETTER_O_WITH_DOT_ABOVE_AND_MACRON";
        case   0x0232: return "LATIN_CAPITAL_LETTER_Y_WITH_MACRON";
        case   0x0233: return "LATIN_SMALL_LETTER_Y_WITH_MACRON";
        case   0x0234: return "LATIN_SMALL_LETTER_L_WITH_CURL";
        case   0x0235: return "LATIN_SMALL_LETTER_N_WITH_CURL";
        case   0x0236: return "LATIN_SMALL_LETTER_T_WITH_CURL";
        case   0x0237: return "LATIN_SMALL_LETTER_DOTLESS_J";
        case   0x0238: return "LATIN_SMALL_LETTER_DB_DIGRAPH";
        case   0x0239: return "LATIN_SMALL_LETTER_QP_DIGRAPH";
        case   0x023A: return "LATIN_CAPITAL_LETTER_A_WITH_STROKE";
        case   0x023B: return "LATIN_CAPITAL_LETTER_C_WITH_STROKE";
        case   0x023C: return "LATIN_SMALL_LETTER_C_WITH_STROKE";
        case   0x023D: return "LATIN_CAPITAL_LETTER_L_WITH_BAR";
        case   0x023E: return "LATIN_CAPITAL_LETTER_T_WITH_DIAGONAL_STROKE";
        case   0x023F: return "LATIN_SMALL_LETTER_S_WITH_SWASH_TAIL";
        case   0x0240: return "LATIN_SMALL_LETTER_Z_WITH_SWASH_TAIL";
        case   0x0241: return "LATIN_CAPITAL_LETTER_GLOTTAL_STOP";
        case   0x0242: return "LATIN_SMALL_LETTER_GLOTTAL_STOP";
        case   0x0243: return "LATIN_CAPITAL_LETTER_B_WITH_STROKE";
        case   0x0244: return "LATIN_CAPITAL_LETTER_U_BAR";
        case   0x0245: return "LATIN_CAPITAL_LETTER_TURNED_V";
        case   0x0246: return "LATIN_CAPITAL_LETTER_E_WITH_STROKE";
        case   0x0247: return "LATIN_SMALL_LETTER_E_WITH_STROKE";
        case   0x0248: return "LATIN_CAPITAL_LETTER_J_WITH_STROKE";
        case   0x0249: return "LATIN_SMALL_LETTER_J_WITH_STROKE";
        case   0x024A: return "LATIN_CAPITAL_LETTER_SMALL_Q_WITH_HOOK_TAIL";
        case   0x024B: return "LATIN_SMALL_LETTER_Q_WITH_HOOK_TAIL";
        case   0x024C: return "LATIN_CAPITAL_LETTER_R_WITH_STROKE";
        case   0x024D: return "LATIN_SMALL_LETTER_R_WITH_STROKE";
        case   0x024E: return "LATIN_CAPITAL_LETTER_Y_WITH_STROKE";
        case   0x024F: return "LATIN_SMALL_LETTER_Y_WITH_STROKE";
        case   0x0250: return "LATIN_SMALL_LETTER_TURNED_A";
        case   0x0251: return "LATIN_SMALL_LETTER_ALPHA";
        case   0x0252: return "LATIN_SMALL_LETTER_TURNED_ALPHA";
        case   0x0253: return "LATIN_SMALL_LETTER_B_WITH_HOOK";
        case   0x0254: return "LATIN_SMALL_LETTER_OPEN_O";
        case   0x0255: return "LATIN_SMALL_LETTER_C_WITH_CURL";
        case   0x0256: return "LATIN_SMALL_LETTER_D_WITH_TAIL";
        case   0x0257: return "LATIN_SMALL_LETTER_D_WITH_HOOK";
        case   0x0258: return "LATIN_SMALL_LETTER_REVERSED_E";
        case   0x0259: return "LATIN_SMALL_LETTER_SCHWA";
        case   0x025A: return "LATIN_SMALL_LETTER_SCHWA_WITH_HOOK";
        case   0x025B: return "LATIN_SMALL_LETTER_OPEN_E";
        case   0x025C: return "LATIN_SMALL_LETTER_REVERSED_OPEN_E";
        case   0x025D: return "LATIN_SMALL_LETTER_REVERSED_OPEN_E_WITH_HOOK";
        case   0x025E: return "LATIN_SMALL_LETTER_CLOSED_REVERSED_OPEN_E";
        case   0x025F: return "LATIN_SMALL_LETTER_DOTLESS_J_WITH_STROKE";
        case   0x0260: return "LATIN_SMALL_LETTER_G_WITH_HOOK";
        case   0x0261: return "LATIN_SMALL_LETTER_SCRIPT_G";
        case   0x0262: return "LATIN_LETTER_SMALL_CAPITAL_G";
        case   0x0263: return "LATIN_SMALL_LETTER_GAMMA";
        case   0x0264: return "LATIN_SMALL_LETTER_RAMS_HORN";
        case   0x0265: return "LATIN_SMALL_LETTER_TURNED_H";
        case   0x0266: return "LATIN_SMALL_LETTER_H_WITH_HOOK";
        case   0x0267: return "LATIN_SMALL_LETTER_HENG_WITH_HOOK";
        case   0x0268: return "LATIN_SMALL_LETTER_I_WITH_STROKE";
        case   0x0269: return "LATIN_SMALL_LETTER_IOTA";
        case   0x026A: return "LATIN_LETTER_SMALL_CAPITAL_I";
        case   0x026B: return "LATIN_SMALL_LETTER_L_WITH_MIDDLE_TILDE";
        case   0x026C: return "LATIN_SMALL_LETTER_L_WITH_BELT";
        case   0x026D: return "LATIN_SMALL_LETTER_L_WITH_RETROFLEX_HOOK";
        case   0x026E: return "LATIN_SMALL_LETTER_LEZH";
        case   0x026F: return "LATIN_SMALL_LETTER_TURNED_M";
        case   0x0270: return "LATIN_SMALL_LETTER_TURNED_M_WITH_LONG_LEG";
        case   0x0271: return "LATIN_SMALL_LETTER_M_WITH_HOOK";
        case   0x0272: return "LATIN_SMALL_LETTER_N_WITH_LEFT_HOOK";
        case   0x0273: return "LATIN_SMALL_LETTER_N_WITH_RETROFLEX_HOOK";
        case   0x0274: return "LATIN_LETTER_SMALL_CAPITAL_N";
        case   0x0275: return "LATIN_SMALL_LETTER_BARRED_O";
        case   0x0276: return "LATIN_LETTER_SMALL_CAPITAL_OE";
        case   0x0277: return "LATIN_SMALL_LETTER_CLOSED_OMEGA";
        case   0x0278: return "LATIN_SMALL_LETTER_PHI";
        case   0x0279: return "LATIN_SMALL_LETTER_TURNED_R";
        case   0x027A: return "LATIN_SMALL_LETTER_TURNED_R_WITH_LONG_LEG";
        case   0x027B: return "LATIN_SMALL_LETTER_TURNED_R_WITH_HOOK";
        case   0x027C: return "LATIN_SMALL_LETTER_R_WITH_LONG_LEG";
        case   0x027D: return "LATIN_SMALL_LETTER_R_WITH_TAIL";
        case   0x027E: return "LATIN_SMALL_LETTER_R_WITH_FISHHOOK";
        case   0x027F: return "LATIN_SMALL_LETTER_REVERSED_R_WITH_FISHHOOK";
        case   0x0280: return "LATIN_LETTER_SMALL_CAPITAL_R";
        case   0x0281: return "LATIN_LETTER_SMALL_CAPITAL_INVERTED_R";
        case   0x0282: return "LATIN_SMALL_LETTER_S_WITH_HOOK";
        case   0x0283: return "LATIN_SMALL_LETTER_ESH";
        case   0x0284: return
                "LATIN_SMALL_LETTER_DOTLESS_J_WITH_STROKE_AND_HOOK";
        case   0x0285: return "LATIN_SMALL_LETTER_SQUAT_REVERSED_ESH";
        case   0x0286: return "LATIN_SMALL_LETTER_ESH_WITH_CURL";
        case   0x0287: return "LATIN_SMALL_LETTER_TURNED_T";
        case   0x0288: return "LATIN_SMALL_LETTER_T_WITH_RETROFLEX_HOOK";
        case   0x0289: return "LATIN_SMALL_LETTER_U_BAR";
        case   0x028A: return "LATIN_SMALL_LETTER_UPSILON";
        case   0x028B: return "LATIN_SMALL_LETTER_V_WITH_HOOK";
        case   0x028C: return "LATIN_SMALL_LETTER_TURNED_V";
        case   0x028D: return "LATIN_SMALL_LETTER_TURNED_W";
        case   0x028E: return "LATIN_SMALL_LETTER_TURNED_Y";
        case   0x028F: return "LATIN_LETTER_SMALL_CAPITAL_Y";
        case   0x0290: return "LATIN_SMALL_LETTER_Z_WITH_RETROFLEX_HOOK";
        case   0x0291: return "LATIN_SMALL_LETTER_Z_WITH_CURL";
        case   0x0292: return "LATIN_SMALL_LETTER_EZH";
        case   0x0293: return "LATIN_SMALL_LETTER_EZH_WITH_CURL";
        case   0x0294: return "LATIN_LETTER_GLOTTAL_STOP";
        case   0x0295: return "LATIN_LETTER_PHARYNGEAL_VOICED_FRICATIVE";
        case   0x0296: return "LATIN_LETTER_INVERTED_GLOTTAL_STOP";
        case   0x0297: return "LATIN_LETTER_STRETCHED_C";
        case   0x0298: return "LATIN_LETTER_BILABIAL_CLICK";
        case   0x0299: return "LATIN_LETTER_SMALL_CAPITAL_B";
        case   0x029A: return "LATIN_SMALL_LETTER_CLOSED_OPEN_E";
        case   0x029B: return "LATIN_LETTER_SMALL_CAPITAL_G_WITH_HOOK";
        case   0x029C: return "LATIN_LETTER_SMALL_CAPITAL_H";
        case   0x029D: return "LATIN_SMALL_LETTER_J_WITH_CROSSED_TAIL";
        case   0x029E: return "LATIN_SMALL_LETTER_TURNED_K";
        case   0x029F: return "LATIN_LETTER_SMALL_CAPITAL_L";
        case   0x02A0: return "LATIN_SMALL_LETTER_Q_WITH_HOOK";
        case   0x02A1: return "LATIN_LETTER_GLOTTAL_STOP_WITH_STROKE";
        case   0x02A2: return
                "LATIN_LETTER_REVERSED_GLOTTAL_STOP_WITH_STROKE";
        case   0x02A3: return "LATIN_SMALL_LETTER_DZ_DIGRAPH";
        case   0x02A4: return "LATIN_SMALL_LETTER_DEZH_DIGRAPH";
        case   0x02A5: return "LATIN_SMALL_LETTER_DZ_DIGRAPH_WITH_CURL";
        case   0x02A6: return "LATIN_SMALL_LETTER_TS_DIGRAPH";
        case   0x02A7: return "LATIN_SMALL_LETTER_TESH_DIGRAPH";
        case   0x02A8: return "LATIN_SMALL_LETTER_TC_DIGRAPH_WITH_CURL";
        case   0x02A9: return "LATIN_SMALL_LETTER_FENG_DIGRAPH";
        case   0x02AA: return "LATIN_SMALL_LETTER_LS_DIGRAPH";
        case   0x02AB: return "LATIN_SMALL_LETTER_LZ_DIGRAPH";
        case   0x02AC: return "LATIN_LETTER_BILABIAL_PERCUSSIVE";
        case   0x02AD: return "LATIN_LETTER_BIDENTAL_PERCUSSIVE";
        case   0x02AE: return "LATIN_SMALL_LETTER_TURNED_H_WITH_FISHHOOK";
        case   0x02AF: return
                "LATIN_SMALL_LETTER_TURNED_H_WITH_FISHHOOK_AND_TAIL";
        case   0x02B0: return "MODIFIER_LETTER_SMALL_H";
        case   0x02B1: return "MODIFIER_LETTER_SMALL_H_WITH_HOOK";
        case   0x02B2: return "MODIFIER_LETTER_SMALL_J";
        case   0x02B3: return "MODIFIER_LETTER_SMALL_R";
        case   0x02B4: return "MODIFIER_LETTER_SMALL_TURNED_R";
        case   0x02B5: return "MODIFIER_LETTER_SMALL_TURNED_R_WITH_HOOK";
        case   0x02B6: return "MODIFIER_LETTER_SMALL_CAPITAL_INVERTED_R";
        case   0x02B7: return "MODIFIER_LETTER_SMALL_W";
        case   0x02B8: return "MODIFIER_LETTER_SMALL_Y";
        case   0x02B9: return "MODIFIER_LETTER_PRIME";
        case   0x02BA: return "MODIFIER_LETTER_DOUBLE_PRIME";
        case   0x02BB: return "MODIFIER_LETTER_TURNED_COMMA";
        case   0x02BC: return "MODIFIER_LETTER_APOSTROPHE";
        case   0x02BD: return "MODIFIER_LETTER_REVERSED_COMMA";
        case   0x02BE: return "MODIFIER_LETTER_RIGHT_HALF_RING";
        case   0x02BF: return "MODIFIER_LETTER_LEFT_HALF_RING";
        case   0x02C0: return "MODIFIER_LETTER_GLOTTAL_STOP";
        case   0x02C1: return "MODIFIER_LETTER_REVERSED_GLOTTAL_STOP";
        case   0x02C2: return "MODIFIER_LETTER_LEFT_ARROWHEAD";
        case   0x02C3: return "MODIFIER_LETTER_RIGHT_ARROWHEAD";
        case   0x02C4: return "MODIFIER_LETTER_UP_ARROWHEAD";
        case   0x02C5: return "MODIFIER_LETTER_DOWN_ARROWHEAD";
        case   0x02C6: return "MODIFIER_LETTER_CIRCUMFLEX_ACCENT";
        case   0x02C7: return "CARON";
        case   0x02C8: return "MODIFIER_LETTER_VERTICAL_LINE";
        case   0x02C9: return "MODIFIER_LETTER_MACRON";
        case   0x02CA: return "MODIFIER_LETTER_ACUTE_ACCENT";
        case   0x02CB: return "MODIFIER_LETTER_GRAVE_ACCENT";
        case   0x02CC: return "MODIFIER_LETTER_LOW_VERTICAL_LINE";
        case   0x02CD: return "MODIFIER_LETTER_LOW_MACRON";
        case   0x02CE: return "MODIFIER_LETTER_LOW_GRAVE_ACCENT";
        case   0x02CF: return "MODIFIER_LETTER_LOW_ACUTE_ACCENT";
        case   0x02D0: return "MODIFIER_LETTER_TRIANGULAR_COLON";
        case   0x02D1: return "MODIFIER_LETTER_HALF_TRIANGULAR_COLON";
        case   0x02D2: return "MODIFIER_LETTER_CENTRED_RIGHT_HALF_RING";
        case   0x02D3: return "MODIFIER_LETTER_CENTRED_LEFT_HALF_RING";
        case   0x02D4: return "MODIFIER_LETTER_UP_TACK";
        case   0x02D5: return "MODIFIER_LETTER_DOWN_TACK";
        case   0x02D6: return "MODIFIER_LETTER_PLUS_SIGN";
        case   0x02D7: return "MODIFIER_LETTER_MINUS_SIGN";
        case   0x02D8: return "BREVE";
        case   0x02D9: return "DOT_ABOVE";
        case   0x02DA: return "RING_ABOVE";
        case   0x02DB: return "OGONEK";
        case   0x02DC: return "SMALL_TILDE";
        case   0x02DD: return "DOUBLE_ACUTE_ACCENT";
        case   0x02DE: return "MODIFIER_LETTER_RHOTIC_HOOK";
        case   0x02DF: return "MODIFIER_LETTER_CROSS_ACCENT";
        case   0x02E0: return "MODIFIER_LETTER_SMALL_GAMMA";
        case   0x02E1: return "MODIFIER_LETTER_SMALL_L";
        case   0x02E2: return "MODIFIER_LETTER_SMALL_S";
        case   0x02E3: return "MODIFIER_LETTER_SMALL_X";
        case   0x02E4: return "MODIFIER_LETTER_SMALL_REVERSED_GLOTTAL_STOP";
        case   0x02E5: return "MODIFIER_LETTER_EXTRA_HIGH_TONE_BAR";
        case   0x02E6: return "MODIFIER_LETTER_HIGH_TONE_BAR";
        case   0x02E7: return "MODIFIER_LETTER_MID_TONE_BAR";
        case   0x02E8: return "MODIFIER_LETTER_LOW_TONE_BAR";
        case   0x02E9: return "MODIFIER_LETTER_EXTRA_LOW_TONE_BAR";
        case   0x02EA: return "MODIFIER_LETTER_YIN_DEPARTING_TONE_MARK";
        case   0x02EB: return "MODIFIER_LETTER_YANG_DEPARTING_TONE_MARK";
        case   0x02EC: return "MODIFIER_LETTER_VOICING";
        case   0x02ED: return "MODIFIER_LETTER_UNASPIRATED";
        case   0x02EE: return "MODIFIER_LETTER_DOUBLE_APOSTROPHE";
        case   0x02EF: return "MODIFIER_LETTER_LOW_DOWN_ARROWHEAD";
        case   0x02F0: return "MODIFIER_LETTER_LOW_UP_ARROWHEAD";
        case   0x02F1: return "MODIFIER_LETTER_LOW_LEFT_ARROWHEAD";
        case   0x02F2: return "MODIFIER_LETTER_LOW_RIGHT_ARROWHEAD";
        case   0x02F3: return "MODIFIER_LETTER_LOW_RING";
        case   0x02F4: return "MODIFIER_LETTER_MIDDLE_GRAVE_ACCENT";
        case   0x02F5: return "MODIFIER_LETTER_MIDDLE_DOUBLE_GRAVE_ACCENT";
        case   0x02F6: return "MODIFIER_LETTER_MIDDLE_DOUBLE_ACUTE_ACCENT";
        case   0x02F7: return "MODIFIER_LETTER_LOW_TILDE";
        case   0x02F8: return "MODIFIER_LETTER_RAISED_COLON";
        case   0x02F9: return "MODIFIER_LETTER_BEGIN_HIGH_TONE";
        case   0x02FA: return "MODIFIER_LETTER_END_HIGH_TONE";
        case   0x02FB: return "MODIFIER_LETTER_BEGIN_LOW_TONE";
        case   0x02FC: return "MODIFIER_LETTER_END_LOW_TONE";
        case   0x02FD: return "MODIFIER_LETTER_SHELF";
        case   0x02FE: return "MODIFIER_LETTER_OPEN_SHELF";
        case   0x02FF: return "MODIFIER_LETTER_LOW_LEFT_ARROW";
        case   0x0300: return "COMBINING_GRAVE_ACCENT";
        case   0x0301: return "COMBINING_ACUTE_ACCENT";
        case   0x0302: return "COMBINING_CIRCUMFLEX_ACCENT";
        case   0x0303: return "COMBINING_TILDE";
        case   0x0304: return "COMBINING_MACRON";
        case   0x0305: return "COMBINING_OVERLINE";
        case   0x0306: return "COMBINING_BREVE";
        case   0x0307: return "COMBINING_DOT_ABOVE";
        case   0x0308: return "COMBINING_DIAERESIS";
        case   0x0309: return "COMBINING_HOOK_ABOVE";
        case   0x030A: return "COMBINING_RING_ABOVE";
        case   0x030B: return "COMBINING_DOUBLE_ACUTE_ACCENT";
        case   0x030C: return "COMBINING_CARON";
        case   0x030D: return "COMBINING_VERTICAL_LINE_ABOVE";
        case   0x030E: return "COMBINING_DOUBLE_VERTICAL_LINE_ABOVE";
        case   0x030F: return "COMBINING_DOUBLE_GRAVE_ACCENT";
        case   0x0310: return "COMBINING_CANDRABINDU";
        case   0x0311: return "COMBINING_INVERTED_BREVE";
        case   0x0312: return "COMBINING_TURNED_COMMA_ABOVE";
        case   0x0313: return "COMBINING_COMMA_ABOVE";
        case   0x0314: return "COMBINING_REVERSED_COMMA_ABOVE";
        case   0x0315: return "COMBINING_COMMA_ABOVE_RIGHT";
        case   0x0316: return "COMBINING_GRAVE_ACCENT_BELOW";
        case   0x0317: return "COMBINING_ACUTE_ACCENT_BELOW";
        case   0x0318: return "COMBINING_LEFT_TACK_BELOW";
        case   0x0319: return "COMBINING_RIGHT_TACK_BELOW";
        case   0x031A: return "COMBINING_LEFT_ANGLE_ABOVE";
        case   0x031B: return "COMBINING_HORN";
        case   0x031C: return "COMBINING_LEFT_HALF_RING_BELOW";
        case   0x031D: return "COMBINING_UP_TACK_BELOW";
        case   0x031E: return "COMBINING_DOWN_TACK_BELOW";
        case   0x031F: return "COMBINING_PLUS_SIGN_BELOW";
        case   0x0320: return "COMBINING_MINUS_SIGN_BELOW";
        case   0x0321: return "COMBINING_PALATALIZED_HOOK_BELOW";
        case   0x0322: return "COMBINING_RETROFLEX_HOOK_BELOW";
        case   0x0323: return "COMBINING_DOT_BELOW";
        case   0x0324: return "COMBINING_DIAERESIS_BELOW";
        case   0x0325: return "COMBINING_RING_BELOW";
        case   0x0326: return "COMBINING_COMMA_BELOW";
        case   0x0327: return "COMBINING_CEDILLA";
        case   0x0328: return "COMBINING_OGONEK";
        case   0x0329: return "COMBINING_VERTICAL_LINE_BELOW";
        case   0x032A: return "COMBINING_BRIDGE_BELOW";
        case   0x032B: return "COMBINING_INVERTED_DOUBLE_ARCH_BELOW";
        case   0x032C: return "COMBINING_CARON_BELOW";
        case   0x032D: return "COMBINING_CIRCUMFLEX_ACCENT_BELOW";
        case   0x032E: return "COMBINING_BREVE_BELOW";
        case   0x032F: return "COMBINING_INVERTED_BREVE_BELOW";
        case   0x0330: return "COMBINING_TILDE_BELOW";
        case   0x0331: return "COMBINING_MACRON_BELOW";
        case   0x0332: return "COMBINING_LOW_LINE";
        case   0x0333: return "COMBINING_DOUBLE_LOW_LINE";
        case   0x0334: return "COMBINING_TILDE_OVERLAY";
        case   0x0335: return "COMBINING_SHORT_STROKE_OVERLAY";
        case   0x0336: return "COMBINING_LONG_STROKE_OVERLAY";
        case   0x0337: return "COMBINING_SHORT_SOLIDUS_OVERLAY";
        case   0x0338: return "COMBINING_LONG_SOLIDUS_OVERLAY";
        case   0x0339: return "COMBINING_RIGHT_HALF_RING_BELOW";
        case   0x033A: return "COMBINING_INVERTED_BRIDGE_BELOW";
        case   0x033B: return "COMBINING_SQUARE_BELOW";
        case   0x033C: return "COMBINING_SEAGULL_BELOW";
        case   0x033D: return "COMBINING_X_ABOVE";
        case   0x033E: return "COMBINING_VERTICAL_TILDE";
        case   0x033F: return "COMBINING_DOUBLE_OVERLINE";
        case   0x0340: return "COMBINING_GRAVE_TONE_MARK";
        case   0x0341: return "COMBINING_ACUTE_TONE_MARK";
        case   0x0342: return "COMBINING_GREEK_PERISPOMENI";
        case   0x0343: return "COMBINING_GREEK_KORONIS";
        case   0x0344: return "COMBINING_GREEK_DIALYTIKA_TONOS";
        case   0x0345: return "COMBINING_GREEK_YPOGEGRAMMENI";
        case   0x0346: return "COMBINING_BRIDGE_ABOVE";
        case   0x0347: return "COMBINING_EQUALS_SIGN_BELOW";
        case   0x0348: return "COMBINING_DOUBLE_VERTICAL_LINE_BELOW";
        case   0x0349: return "COMBINING_LEFT_ANGLE_BELOW";
        case   0x034A: return "COMBINING_NOT_TILDE_ABOVE";
        case   0x034B: return "COMBINING_HOMOTHETIC_ABOVE";
        case   0x034C: return "COMBINING_ALMOST_EQUAL_TO_ABOVE";
        case   0x034D: return "COMBINING_LEFT_RIGHT_ARROW_BELOW";
        case   0x034E: return "COMBINING_UPWARDS_ARROW_BELOW";
        case   0x034F: return "COMBINING_GRAPHEME_JOINER";
        case   0x0350: return "COMBINING_RIGHT_ARROWHEAD_ABOVE";
        case   0x0351: return "COMBINING_LEFT_HALF_RING_ABOVE";
        case   0x0352: return "COMBINING_FERMATA";
        case   0x0353: return "COMBINING_X_BELOW";
        case   0x0354: return "COMBINING_LEFT_ARROWHEAD_BELOW";
        case   0x0355: return "COMBINING_RIGHT_ARROWHEAD_BELOW";
        case   0x0356: return
                "COMBINING_RIGHT_ARROWHEAD_AND_UP_ARROWHEAD_BELOW";
        case   0x0357: return "COMBINING_RIGHT_HALF_RING_ABOVE";
        case   0x0358: return "COMBINING_DOT_ABOVE_RIGHT";
        case   0x0359: return "COMBINING_ASTERISK_BELOW";
        case   0x035A: return "COMBINING_DOUBLE_RING_BELOW";
        case   0x035B: return "COMBINING_ZIGZAG_ABOVE";
        case   0x035C: return "COMBINING_DOUBLE_BREVE_BELOW";
        case   0x035D: return "COMBINING_DOUBLE_BREVE";
        case   0x035E: return "COMBINING_DOUBLE_MACRON";
        case   0x035F: return "COMBINING_DOUBLE_MACRON_BELOW";
        case   0x0360: return "COMBINING_DOUBLE_TILDE";
        case   0x0361: return "COMBINING_DOUBLE_INVERTED_BREVE";
        case   0x0362: return "COMBINING_DOUBLE_RIGHTWARDS_ARROW_BELOW";
        case   0x0363: return "COMBINING_LATIN_SMALL_LETTER_A";
        case   0x0364: return "COMBINING_LATIN_SMALL_LETTER_E";
        case   0x0365: return "COMBINING_LATIN_SMALL_LETTER_I";
        case   0x0366: return "COMBINING_LATIN_SMALL_LETTER_O";
        case   0x0367: return "COMBINING_LATIN_SMALL_LETTER_U";
        case   0x0368: return "COMBINING_LATIN_SMALL_LETTER_C";
        case   0x0369: return "COMBINING_LATIN_SMALL_LETTER_D";
        case   0x036A: return "COMBINING_LATIN_SMALL_LETTER_H";
        case   0x036B: return "COMBINING_LATIN_SMALL_LETTER_M";
        case   0x036C: return "COMBINING_LATIN_SMALL_LETTER_R";
        case   0x036D: return "COMBINING_LATIN_SMALL_LETTER_T";
        case   0x036E: return "COMBINING_LATIN_SMALL_LETTER_V";
        case   0x036F: return "COMBINING_LATIN_SMALL_LETTER_X";
        case   0x0370: return "GREEK_CAPITAL_LETTER_HETA";
        case   0x0371: return "GREEK_SMALL_LETTER_HETA";
        case   0x0372: return "GREEK_CAPITAL_LETTER_ARCHAIC_SAMPI";
        case   0x0373: return "GREEK_SMALL_LETTER_ARCHAIC_SAMPI";
        case   0x0374: return "GREEK_NUMERAL_SIGN";
        case   0x0375: return "GREEK_LOWER_NUMERAL_SIGN";
        case   0x0376: return "GREEK_CAPITAL_LETTER_PAMPHYLIAN_DIGAMMA";
        case   0x0377: return "GREEK_SMALL_LETTER_PAMPHYLIAN_DIGAMMA";
        case   0x037A: return "GREEK_YPOGEGRAMMENI";
        case   0x037B: return "GREEK_SMALL_REVERSED_LUNATE_SIGMA_SYMBOL";
        case   0x037C: return "GREEK_SMALL_DOTTED_LUNATE_SIGMA_SYMBOL";
        case   0x037D: return
                "GREEK_SMALL_REVERSED_DOTTED_LUNATE_SIGMA_SYMBOL";
        case   0x037E: return "GREEK_QUESTION_MARK";
        case   0x037F: return "GREEK_CAPITAL_LETTER_YOT";
        case   0x0384: return "GREEK_TONOS";
        case   0x0385: return "GREEK_DIALYTIKA_TONOS";
        case   0x0386: return "GREEK_CAPITAL_LETTER_ALPHA_WITH_TONOS";
        case   0x0387: return "GREEK_ANO_TELEIA";
        case   0x0388: return "GREEK_CAPITAL_LETTER_EPSILON_WITH_TONOS";
        case   0x0389: return "GREEK_CAPITAL_LETTER_ETA_WITH_TONOS";
        case   0x038A: return "GREEK_CAPITAL_LETTER_IOTA_WITH_TONOS";
        case   0x038C: return "GREEK_CAPITAL_LETTER_OMICRON_WITH_TONOS";
        case   0x038E: return "GREEK_CAPITAL_LETTER_UPSILON_WITH_TONOS";
        case   0x038F: return "GREEK_CAPITAL_LETTER_OMEGA_WITH_TONOS";
        case   0x0390: return
                "GREEK_SMALL_LETTER_IOTA_WITH_DIALYTIKA_AND_TONOS";
        case   0x0391: return "GREEK_CAPITAL_LETTER_ALPHA";
        case   0x0392: return "GREEK_CAPITAL_LETTER_BETA";
        case   0x0393: return "GREEK_CAPITAL_LETTER_GAMMA";
        case   0x0394: return "GREEK_CAPITAL_LETTER_DELTA";
        case   0x0395: return "GREEK_CAPITAL_LETTER_EPSILON";
        case   0x0396: return "GREEK_CAPITAL_LETTER_ZETA";
        case   0x0397: return "GREEK_CAPITAL_LETTER_ETA";
        case   0x0398: return "GREEK_CAPITAL_LETTER_THETA";
        case   0x0399: return "GREEK_CAPITAL_LETTER_IOTA";
        case   0x039A: return "GREEK_CAPITAL_LETTER_KAPPA";
        case   0x039B: return "GREEK_CAPITAL_LETTER_LAMDA";
        case   0x039C: return "GREEK_CAPITAL_LETTER_MU";
        case   0x039D: return "GREEK_CAPITAL_LETTER_NU";
        case   0x039E: return "GREEK_CAPITAL_LETTER_XI";
        case   0x039F: return "GREEK_CAPITAL_LETTER_OMICRON";
        case   0x03A0: return "GREEK_CAPITAL_LETTER_PI";
        case   0x03A1: return "GREEK_CAPITAL_LETTER_RHO";
        case   0x03A3: return "GREEK_CAPITAL_LETTER_SIGMA";
        case   0x03A4: return "GREEK_CAPITAL_LETTER_TAU";
        case   0x03A5: return "GREEK_CAPITAL_LETTER_UPSILON";
        case   0x03A6: return "GREEK_CAPITAL_LETTER_PHI";
        case   0x03A7: return "GREEK_CAPITAL_LETTER_CHI";
        case   0x03A8: return "GREEK_CAPITAL_LETTER_PSI";
        case   0x03A9: return "GREEK_CAPITAL_LETTER_OMEGA";
        case   0x03AA: return "GREEK_CAPITAL_LETTER_IOTA_WITH_DIALYTIKA";
        case   0x03AB: return "GREEK_CAPITAL_LETTER_UPSILON_WITH_DIALYTIKA";
        case   0x03AC: return "GREEK_SMALL_LETTER_ALPHA_WITH_TONOS";
        case   0x03AD: return "GREEK_SMALL_LETTER_EPSILON_WITH_TONOS";
        case   0x03AE: return "GREEK_SMALL_LETTER_ETA_WITH_TONOS";
        case   0x03AF: return "GREEK_SMALL_LETTER_IOTA_WITH_TONOS";
        case   0x03B0: return
                "GREEK_SMALL_LETTER_UPSILON_WITH_DIALYTIKA_AND_TONOS";
        case   0x03B1: return "GREEK_SMALL_LETTER_ALPHA";
        case   0x03B2: return "GREEK_SMALL_LETTER_BETA";
        case   0x03B3: return "GREEK_SMALL_LETTER_GAMMA";
        case   0x03B4: return "GREEK_SMALL_LETTER_DELTA";
        case   0x03B5: return "GREEK_SMALL_LETTER_EPSILON";
        case   0x03B6: return "GREEK_SMALL_LETTER_ZETA";
        case   0x03B7: return "GREEK_SMALL_LETTER_ETA";
        case   0x03B8: return "GREEK_SMALL_LETTER_THETA";
        case   0x03B9: return "GREEK_SMALL_LETTER_IOTA";
        case   0x03BA: return "GREEK_SMALL_LETTER_KAPPA";
        case   0x03BB: return "GREEK_SMALL_LETTER_LAMDA";
        case   0x03BC: return "GREEK_SMALL_LETTER_MU";
        case   0x03BD: return "GREEK_SMALL_LETTER_NU";
        case   0x03BE: return "GREEK_SMALL_LETTER_XI";
        case   0x03BF: return "GREEK_SMALL_LETTER_OMICRON";
        case   0x03C0: return "GREEK_SMALL_LETTER_PI";
        case   0x03C1: return "GREEK_SMALL_LETTER_RHO";
        case   0x03C2: return "GREEK_SMALL_LETTER_FINAL_SIGMA";
        case   0x03C3: return "GREEK_SMALL_LETTER_SIGMA";
        case   0x03C4: return "GREEK_SMALL_LETTER_TAU";
        case   0x03C5: return "GREEK_SMALL_LETTER_UPSILON";
        case   0x03C6: return "GREEK_SMALL_LETTER_PHI";
        case   0x03C7: return "GREEK_SMALL_LETTER_CHI";
        case   0x03C8: return "GREEK_SMALL_LETTER_PSI";
        case   0x03C9: return "GREEK_SMALL_LETTER_OMEGA";
        case   0x03CA: return "GREEK_SMALL_LETTER_IOTA_WITH_DIALYTIKA";
        case   0x03CB: return "GREEK_SMALL_LETTER_UPSILON_WITH_DIALYTIKA";
        case   0x03CC: return "GREEK_SMALL_LETTER_OMICRON_WITH_TONOS";
        case   0x03CD: return "GREEK_SMALL_LETTER_UPSILON_WITH_TONOS";
        case   0x03CE: return "GREEK_SMALL_LETTER_OMEGA_WITH_TONOS";
        case   0x03CF: return "GREEK_CAPITAL_KAI_SYMBOL";
        case   0x03D0: return "GREEK_BETA_SYMBOL";
        case   0x03D1: return "GREEK_THETA_SYMBOL";
        case   0x03D2: return "GREEK_UPSILON_WITH_HOOK_SYMBOL";
        case   0x03D3: return "GREEK_UPSILON_WITH_ACUTE_AND_HOOK_SYMBOL";
        case   0x03D4: return "GREEK_UPSILON_WITH_DIAERESIS_AND_HOOK_SYMBOL";
        case   0x03D5: return "GREEK_PHI_SYMBOL";
        case   0x03D6: return "GREEK_PI_SYMBOL";
        case   0x03D7: return "GREEK_KAI_SYMBOL";
        case   0x03D8: return "GREEK_LETTER_ARCHAIC_KOPPA";
        case   0x03D9: return "GREEK_SMALL_LETTER_ARCHAIC_KOPPA";
        case   0x03DA: return "GREEK_LETTER_STIGMA";
        case   0x03DB: return "GREEK_SMALL_LETTER_STIGMA";
        case   0x03DC: return "GREEK_LETTER_DIGAMMA";
        case   0x03DD: return "GREEK_SMALL_LETTER_DIGAMMA";
        case   0x03DE: return "GREEK_LETTER_KOPPA";
        case   0x03DF: return "GREEK_SMALL_LETTER_KOPPA";
        case   0x03E0: return "GREEK_LETTER_SAMPI";
        case   0x03E1: return "GREEK_SMALL_LETTER_SAMPI";
        case   0x03E2: return "COPTIC_CAPITAL_LETTER_SHEI";
        case   0x03E3: return "COPTIC_SMALL_LETTER_SHEI";
        case   0x03E4: return "COPTIC_CAPITAL_LETTER_FEI";
        case   0x03E5: return "COPTIC_SMALL_LETTER_FEI";
        case   0x03E6: return "COPTIC_CAPITAL_LETTER_KHEI";
        case   0x03E7: return "COPTIC_SMALL_LETTER_KHEI";
        case   0x03E8: return "COPTIC_CAPITAL_LETTER_HORI";
        case   0x03E9: return "COPTIC_SMALL_LETTER_HORI";
        case   0x03EA: return "COPTIC_CAPITAL_LETTER_GANGIA";
        case   0x03EB: return "COPTIC_SMALL_LETTER_GANGIA";
        case   0x03EC: return "COPTIC_CAPITAL_LETTER_SHIMA";
        case   0x03ED: return "COPTIC_SMALL_LETTER_SHIMA";
        case   0x03EE: return "COPTIC_CAPITAL_LETTER_DEI";
        case   0x03EF: return "COPTIC_SMALL_LETTER_DEI";
        case   0x03F0: return "GREEK_KAPPA_SYMBOL";
        case   0x03F1: return "GREEK_RHO_SYMBOL";
        case   0x03F2: return "GREEK_LUNATE_SIGMA_SYMBOL";
        case   0x03F3: return "GREEK_LETTER_YOT";
        case   0x03F4: return "GREEK_CAPITAL_THETA_SYMBOL";
        case   0x03F5: return "GREEK_LUNATE_EPSILON_SYMBOL";
        case   0x03F6: return "GREEK_REVERSED_LUNATE_EPSILON_SYMBOL";
        case   0x03F7: return "GREEK_CAPITAL_LETTER_SHO";
        case   0x03F8: return "GREEK_SMALL_LETTER_SHO";
        case   0x03F9: return "GREEK_CAPITAL_LUNATE_SIGMA_SYMBOL";
        case   0x03FA: return "GREEK_CAPITAL_LETTER_SAN";
        case   0x03FB: return "GREEK_SMALL_LETTER_SAN";
        case   0x03FC: return "GREEK_RHO_WITH_STROKE_SYMBOL";
        case   0x03FD: return "GREEK_CAPITAL_REVERSED_LUNATE_SIGMA_SYMBOL";
        case   0x03FE: return "GREEK_CAPITAL_DOTTED_LUNATE_SIGMA_SYMBOL";
        case   0x03FF: return
                "GREEK_CAPITAL_REVERSED_DOTTED_LUNATE_SIGMA_SYMBOL";
        case   0x0400: return "CYRILLIC_CAPITAL_LETTER_IE_WITH_GRAVE";
        case   0x0401: return "CYRILLIC_CAPITAL_LETTER_IO";
        case   0x0402: return "CYRILLIC_CAPITAL_LETTER_DJE";
        case   0x0403: return "CYRILLIC_CAPITAL_LETTER_GJE";
        case   0x0404: return "CYRILLIC_CAPITAL_LETTER_UKRAINIAN_IE";
        case   0x0405: return "CYRILLIC_CAPITAL_LETTER_DZE";
        case   0x0406: return
                "CYRILLIC_CAPITAL_LETTER_BYELORUSSIAN_UKRAINIAN_I";
        case   0x0407: return "CYRILLIC_CAPITAL_LETTER_YI";
        case   0x0408: return "CYRILLIC_CAPITAL_LETTER_JE";
        case   0x0409: return "CYRILLIC_CAPITAL_LETTER_LJE";
        case   0x040A: return "CYRILLIC_CAPITAL_LETTER_NJE";
        case   0x040B: return "CYRILLIC_CAPITAL_LETTER_TSHE";
        case   0x040C: return "CYRILLIC_CAPITAL_LETTER_KJE";
        case   0x040D: return "CYRILLIC_CAPITAL_LETTER_I_WITH_GRAVE";
        case   0x040E: return "CYRILLIC_CAPITAL_LETTER_SHORT_U";
        case   0x040F: return "CYRILLIC_CAPITAL_LETTER_DZHE";
        case   0x0410: return "CYRILLIC_CAPITAL_LETTER_A";
        case   0x0411: return "CYRILLIC_CAPITAL_LETTER_BE";
        case   0x0412: return "CYRILLIC_CAPITAL_LETTER_VE";
        case   0x0413: return "CYRILLIC_CAPITAL_LETTER_GHE";
        case   0x0414: return "CYRILLIC_CAPITAL_LETTER_DE";
        case   0x0415: return "CYRILLIC_CAPITAL_LETTER_IE";
        case   0x0416: return "CYRILLIC_CAPITAL_LETTER_ZHE";
        case   0x0417: return "CYRILLIC_CAPITAL_LETTER_ZE";
        case   0x0418: return "CYRILLIC_CAPITAL_LETTER_I";
        case   0x0419: return "CYRILLIC_CAPITAL_LETTER_SHORT_I";
        case   0x041A: return "CYRILLIC_CAPITAL_LETTER_KA";
        case   0x041B: return "CYRILLIC_CAPITAL_LETTER_EL";
        case   0x041C: return "CYRILLIC_CAPITAL_LETTER_EM";
        case   0x041D: return "CYRILLIC_CAPITAL_LETTER_EN";
        case   0x041E: return "CYRILLIC_CAPITAL_LETTER_O";
        case   0x041F: return "CYRILLIC_CAPITAL_LETTER_PE";
        case   0x0420: return "CYRILLIC_CAPITAL_LETTER_ER";
        case   0x0421: return "CYRILLIC_CAPITAL_LETTER_ES";
        case   0x0422: return "CYRILLIC_CAPITAL_LETTER_TE";
        case   0x0423: return "CYRILLIC_CAPITAL_LETTER_U";
        case   0x0424: return "CYRILLIC_CAPITAL_LETTER_EF";
        case   0x0425: return "CYRILLIC_CAPITAL_LETTER_HA";
        case   0x0426: return "CYRILLIC_CAPITAL_LETTER_TSE";
        case   0x0427: return "CYRILLIC_CAPITAL_LETTER_CHE";
        case   0x0428: return "CYRILLIC_CAPITAL_LETTER_SHA";
        case   0x0429: return "CYRILLIC_CAPITAL_LETTER_SHCHA";
        case   0x042A: return "CYRILLIC_CAPITAL_LETTER_HARD_SIGN";
        case   0x042B: return "CYRILLIC_CAPITAL_LETTER_YERU";
        case   0x042C: return "CYRILLIC_CAPITAL_LETTER_SOFT_SIGN";
        case   0x042D: return "CYRILLIC_CAPITAL_LETTER_E";
        case   0x042E: return "CYRILLIC_CAPITAL_LETTER_YU";
        case   0x042F: return "CYRILLIC_CAPITAL_LETTER_YA";
        case   0x0430: return "CYRILLIC_SMALL_LETTER_A";
        case   0x0431: return "CYRILLIC_SMALL_LETTER_BE";
        case   0x0432: return "CYRILLIC_SMALL_LETTER_VE";
        case   0x0433: return "CYRILLIC_SMALL_LETTER_GHE";
        case   0x0434: return "CYRILLIC_SMALL_LETTER_DE";
        case   0x0435: return "CYRILLIC_SMALL_LETTER_IE";
        case   0x0436: return "CYRILLIC_SMALL_LETTER_ZHE";
        case   0x0437: return "CYRILLIC_SMALL_LETTER_ZE";
        case   0x0438: return "CYRILLIC_SMALL_LETTER_I";
        case   0x0439: return "CYRILLIC_SMALL_LETTER_SHORT_I";
        case   0x043A: return "CYRILLIC_SMALL_LETTER_KA";
        case   0x043B: return "CYRILLIC_SMALL_LETTER_EL";
        case   0x043C: return "CYRILLIC_SMALL_LETTER_EM";
        case   0x043D: return "CYRILLIC_SMALL_LETTER_EN";
        case   0x043E: return "CYRILLIC_SMALL_LETTER_O";
        case   0x043F: return "CYRILLIC_SMALL_LETTER_PE";
        case   0x0440: return "CYRILLIC_SMALL_LETTER_ER";
        case   0x0441: return "CYRILLIC_SMALL_LETTER_ES";
        case   0x0442: return "CYRILLIC_SMALL_LETTER_TE";
        case   0x0443: return "CYRILLIC_SMALL_LETTER_U";
        case   0x0444: return "CYRILLIC_SMALL_LETTER_EF";
        case   0x0445: return "CYRILLIC_SMALL_LETTER_HA";
        case   0x0446: return "CYRILLIC_SMALL_LETTER_TSE";
        case   0x0447: return "CYRILLIC_SMALL_LETTER_CHE";
        case   0x0448: return "CYRILLIC_SMALL_LETTER_SHA";
        case   0x0449: return "CYRILLIC_SMALL_LETTER_SHCHA";
        case   0x044A: return "CYRILLIC_SMALL_LETTER_HARD_SIGN";
        case   0x044B: return "CYRILLIC_SMALL_LETTER_YERU";
        case   0x044C: return "CYRILLIC_SMALL_LETTER_SOFT_SIGN";
        case   0x044D: return "CYRILLIC_SMALL_LETTER_E";
        case   0x044E: return "CYRILLIC_SMALL_LETTER_YU";
        case   0x044F: return "CYRILLIC_SMALL_LETTER_YA";
        case   0x0450: return "CYRILLIC_SMALL_LETTER_IE_WITH_GRAVE";
        case   0x0451: return "CYRILLIC_SMALL_LETTER_IO";
        case   0x0452: return "CYRILLIC_SMALL_LETTER_DJE";
        case   0x0453: return "CYRILLIC_SMALL_LETTER_GJE";
        case   0x0454: return "CYRILLIC_SMALL_LETTER_UKRAINIAN_IE";
        case   0x0455: return "CYRILLIC_SMALL_LETTER_DZE";
        case   0x0456: return
                "CYRILLIC_SMALL_LETTER_BYELORUSSIAN_UKRAINIAN_I";
        case   0x0457: return "CYRILLIC_SMALL_LETTER_YI";
        case   0x0458: return "CYRILLIC_SMALL_LETTER_JE";
        case   0x0459: return "CYRILLIC_SMALL_LETTER_LJE";
        case   0x045A: return "CYRILLIC_SMALL_LETTER_NJE";
        case   0x045B: return "CYRILLIC_SMALL_LETTER_TSHE";
        case   0x045C: return "CYRILLIC_SMALL_LETTER_KJE";
        case   0x045D: return "CYRILLIC_SMALL_LETTER_I_WITH_GRAVE";
        case   0x045E: return "CYRILLIC_SMALL_LETTER_SHORT_U";
        case   0x045F: return "CYRILLIC_SMALL_LETTER_DZHE";
        case   0x0460: return "CYRILLIC_CAPITAL_LETTER_OMEGA";
        case   0x0461: return "CYRILLIC_SMALL_LETTER_OMEGA";
        case   0x0462: return "CYRILLIC_CAPITAL_LETTER_YAT";
        case   0x0463: return "CYRILLIC_SMALL_LETTER_YAT";
        case   0x0464: return "CYRILLIC_CAPITAL_LETTER_IOTIFIED_E";
        case   0x0465: return "CYRILLIC_SMALL_LETTER_IOTIFIED_E";
        case   0x0466: return "CYRILLIC_CAPITAL_LETTER_LITTLE_YUS";
        case   0x0467: return "CYRILLIC_SMALL_LETTER_LITTLE_YUS";
        case   0x0468: return "CYRILLIC_CAPITAL_LETTER_IOTIFIED_LITTLE_YUS";
        case   0x0469: return "CYRILLIC_SMALL_LETTER_IOTIFIED_LITTLE_YUS";
        case   0x046A: return "CYRILLIC_CAPITAL_LETTER_BIG_YUS";
        case   0x046B: return "CYRILLIC_SMALL_LETTER_BIG_YUS";
        case   0x046C: return "CYRILLIC_CAPITAL_LETTER_IOTIFIED_BIG_YUS";
        case   0x046D: return "CYRILLIC_SMALL_LETTER_IOTIFIED_BIG_YUS";
        case   0x046E: return "CYRILLIC_CAPITAL_LETTER_KSI";
        case   0x046F: return "CYRILLIC_SMALL_LETTER_KSI";
        case   0x0470: return "CYRILLIC_CAPITAL_LETTER_PSI";
        case   0x0471: return "CYRILLIC_SMALL_LETTER_PSI";
        case   0x0472: return "CYRILLIC_CAPITAL_LETTER_FITA";
        case   0x0473: return "CYRILLIC_SMALL_LETTER_FITA";
        case   0x0474: return "CYRILLIC_CAPITAL_LETTER_IZHITSA";
        case   0x0475: return "CYRILLIC_SMALL_LETTER_IZHITSA";
        case   0x0476: return
                "CYRILLIC_CAPITAL_LETTER_IZHITSA_WITH_DOUBLE_GRAVE_ACCENT";
        case   0x0477: return
                "CYRILLIC_SMALL_LETTER_IZHITSA_WITH_DOUBLE_GRAVE_ACCENT";
        case   0x0478: return "CYRILLIC_CAPITAL_LETTER_UK";
        case   0x0479: return "CYRILLIC_SMALL_LETTER_UK";
        case   0x047A: return "CYRILLIC_CAPITAL_LETTER_ROUND_OMEGA";
        case   0x047B: return "CYRILLIC_SMALL_LETTER_ROUND_OMEGA";
        case   0x047C: return "CYRILLIC_CAPITAL_LETTER_OMEGA_WITH_TITLO";
        case   0x047D: return "CYRILLIC_SMALL_LETTER_OMEGA_WITH_TITLO";
        case   0x047E: return "CYRILLIC_CAPITAL_LETTER_OT";
        case   0x047F: return "CYRILLIC_SMALL_LETTER_OT";
        case   0x0480: return "CYRILLIC_CAPITAL_LETTER_KOPPA";
        case   0x0481: return "CYRILLIC_SMALL_LETTER_KOPPA";
        case   0x0482: return "CYRILLIC_THOUSANDS_SIGN";
        case   0x0483: return "COMBINING_CYRILLIC_TITLO";
        case   0x0484: return "COMBINING_CYRILLIC_PALATALIZATION";
        case   0x0485: return "COMBINING_CYRILLIC_DASIA_PNEUMATA";
        case   0x0486: return "COMBINING_CYRILLIC_PSILI_PNEUMATA";
        case   0x0487: return "COMBINING_CYRILLIC_POKRYTIE";
        case   0x0488: return "COMBINING_CYRILLIC_HUNDRED_THOUSANDS_SIGN";
        case   0x0489: return "COMBINING_CYRILLIC_MILLIONS_SIGN";
        case   0x048A: return "CYRILLIC_CAPITAL_LETTER_SHORT_I_WITH_TAIL";
        case   0x048B: return "CYRILLIC_SMALL_LETTER_SHORT_I_WITH_TAIL";
        case   0x048C: return "CYRILLIC_CAPITAL_LETTER_SEMISOFT_SIGN";
        case   0x048D: return "CYRILLIC_SMALL_LETTER_SEMISOFT_SIGN";
        case   0x048E: return "CYRILLIC_CAPITAL_LETTER_ER_WITH_TICK";
        case   0x048F: return "CYRILLIC_SMALL_LETTER_ER_WITH_TICK";
        case   0x0490: return "CYRILLIC_CAPITAL_LETTER_GHE_WITH_UPTURN";
        case   0x0491: return "CYRILLIC_SMALL_LETTER_GHE_WITH_UPTURN";
        case   0x0492: return "CYRILLIC_CAPITAL_LETTER_GHE_WITH_STROKE";
        case   0x0493: return "CYRILLIC_SMALL_LETTER_GHE_WITH_STROKE";
        case   0x0494: return "CYRILLIC_CAPITAL_LETTER_GHE_WITH_MIDDLE_HOOK";
        case   0x0495: return "CYRILLIC_SMALL_LETTER_GHE_WITH_MIDDLE_HOOK";
        case   0x0496: return "CYRILLIC_CAPITAL_LETTER_ZHE_WITH_DESCENDER";
        case   0x0497: return "CYRILLIC_SMALL_LETTER_ZHE_WITH_DESCENDER";
        case   0x0498: return "CYRILLIC_CAPITAL_LETTER_ZE_WITH_DESCENDER";
        case   0x0499: return "CYRILLIC_SMALL_LETTER_ZE_WITH_DESCENDER";
        case   0x049A: return "CYRILLIC_CAPITAL_LETTER_KA_WITH_DESCENDER";
        case   0x049B: return "CYRILLIC_SMALL_LETTER_KA_WITH_DESCENDER";
        case   0x049C: return
                "CYRILLIC_CAPITAL_LETTER_KA_WITH_VERTICAL_STROKE";
        case   0x049D: return "CYRILLIC_SMALL_LETTER_KA_WITH_VERTICAL_STROKE";
        case   0x049E: return "CYRILLIC_CAPITAL_LETTER_KA_WITH_STROKE";
        case   0x049F: return "CYRILLIC_SMALL_LETTER_KA_WITH_STROKE";
        case   0x04A0: return "CYRILLIC_CAPITAL_LETTER_BASHKIR_KA";
        case   0x04A1: return "CYRILLIC_SMALL_LETTER_BASHKIR_KA";
        case   0x04A2: return "CYRILLIC_CAPITAL_LETTER_EN_WITH_DESCENDER";
        case   0x04A3: return "CYRILLIC_SMALL_LETTER_EN_WITH_DESCENDER";
        case   0x04A4: return "CYRILLIC_CAPITAL_LIGATURE_EN_GHE";
        case   0x04A5: return "CYRILLIC_SMALL_LIGATURE_EN_GHE";
        case   0x04A6: return "CYRILLIC_CAPITAL_LETTER_PE_WITH_MIDDLE_HOOK";
        case   0x04A7: return "CYRILLIC_SMALL_LETTER_PE_WITH_MIDDLE_HOOK";
        case   0x04A8: return "CYRILLIC_CAPITAL_LETTER_ABKHASIAN_HA";
        case   0x04A9: return "CYRILLIC_SMALL_LETTER_ABKHASIAN_HA";
        case   0x04AA: return "CYRILLIC_CAPITAL_LETTER_ES_WITH_DESCENDER";
        case   0x04AB: return "CYRILLIC_SMALL_LETTER_ES_WITH_DESCENDER";
        case   0x04AC: return "CYRILLIC_CAPITAL_LETTER_TE_WITH_DESCENDER";
        case   0x04AD: return "CYRILLIC_SMALL_LETTER_TE_WITH_DESCENDER";
        case   0x04AE: return "CYRILLIC_CAPITAL_LETTER_STRAIGHT_U";
        case   0x04AF: return "CYRILLIC_SMALL_LETTER_STRAIGHT_U";
        case   0x04B0: return
                "CYRILLIC_CAPITAL_LETTER_STRAIGHT_U_WITH_STROKE";
        case   0x04B1: return "CYRILLIC_SMALL_LETTER_STRAIGHT_U_WITH_STROKE";
        case   0x04B2: return "CYRILLIC_CAPITAL_LETTER_HA_WITH_DESCENDER";
        case   0x04B3: return "CYRILLIC_SMALL_LETTER_HA_WITH_DESCENDER";
        case   0x04B4: return "CYRILLIC_CAPITAL_LIGATURE_TE_TSE";
        case   0x04B5: return "CYRILLIC_SMALL_LIGATURE_TE_TSE";
        case   0x04B6: return "CYRILLIC_CAPITAL_LETTER_CHE_WITH_DESCENDER";
        case   0x04B7: return "CYRILLIC_SMALL_LETTER_CHE_WITH_DESCENDER";
        case   0x04B8: return
                "CYRILLIC_CAPITAL_LETTER_CHE_WITH_VERTICAL_STROKE";
        case   0x04B9: return
                "CYRILLIC_SMALL_LETTER_CHE_WITH_VERTICAL_STROKE";
        case   0x04BA: return "CYRILLIC_CAPITAL_LETTER_SHHA";
        case   0x04BB: return "CYRILLIC_SMALL_LETTER_SHHA";
        case   0x04BC: return "CYRILLIC_CAPITAL_LETTER_ABKHASIAN_CHE";
        case   0x04BD: return "CYRILLIC_SMALL_LETTER_ABKHASIAN_CHE";
        case   0x04BE: return
                "CYRILLIC_CAPITAL_LETTER_ABKHASIAN_CHE_WITH_DESCENDER";
        case   0x04BF: return
                "CYRILLIC_SMALL_LETTER_ABKHASIAN_CHE_WITH_DESCENDER";
        case   0x04C0: return "CYRILLIC_LETTER_PALOCHKA";
        case   0x04C1: return "CYRILLIC_CAPITAL_LETTER_ZHE_WITH_BREVE";
        case   0x04C2: return "CYRILLIC_SMALL_LETTER_ZHE_WITH_BREVE";
        case   0x04C3: return "CYRILLIC_CAPITAL_LETTER_KA_WITH_HOOK";
        case   0x04C4: return "CYRILLIC_SMALL_LETTER_KA_WITH_HOOK";
        case   0x04C5: return "CYRILLIC_CAPITAL_LETTER_EL_WITH_TAIL";
        case   0x04C6: return "CYRILLIC_SMALL_LETTER_EL_WITH_TAIL";
        case   0x04C7: return "CYRILLIC_CAPITAL_LETTER_EN_WITH_HOOK";
        case   0x04C8: return "CYRILLIC_SMALL_LETTER_EN_WITH_HOOK";
        case   0x04C9: return "CYRILLIC_CAPITAL_LETTER_EN_WITH_TAIL";
        case   0x04CA: return "CYRILLIC_SMALL_LETTER_EN_WITH_TAIL";
        case   0x04CB: return "CYRILLIC_CAPITAL_LETTER_KHAKASSIAN_CHE";
        case   0x04CC: return "CYRILLIC_SMALL_LETTER_KHAKASSIAN_CHE";
        case   0x04CD: return "CYRILLIC_CAPITAL_LETTER_EM_WITH_TAIL";
        case   0x04CE: return "CYRILLIC_SMALL_LETTER_EM_WITH_TAIL";
        case   0x04CF: return "CYRILLIC_SMALL_LETTER_PALOCHKA";
        case   0x04D0: return "CYRILLIC_CAPITAL_LETTER_A_WITH_BREVE";
        case   0x04D1: return "CYRILLIC_SMALL_LETTER_A_WITH_BREVE";
        case   0x04D2: return "CYRILLIC_CAPITAL_LETTER_A_WITH_DIAERESIS";
        case   0x04D3: return "CYRILLIC_SMALL_LETTER_A_WITH_DIAERESIS";
        case   0x04D4: return "CYRILLIC_CAPITAL_LIGATURE_A_IE";
        case   0x04D5: return "CYRILLIC_SMALL_LIGATURE_A_IE";
        case   0x04D6: return "CYRILLIC_CAPITAL_LETTER_IE_WITH_BREVE";
        case   0x04D7: return "CYRILLIC_SMALL_LETTER_IE_WITH_BREVE";
        case   0x04D8: return "CYRILLIC_CAPITAL_LETTER_SCHWA";
        case   0x04D9: return "CYRILLIC_SMALL_LETTER_SCHWA";
        case   0x04DA: return "CYRILLIC_CAPITAL_LETTER_SCHWA_WITH_DIAERESIS";
        case   0x04DB: return "CYRILLIC_SMALL_LETTER_SCHWA_WITH_DIAERESIS";
        case   0x04DC: return "CYRILLIC_CAPITAL_LETTER_ZHE_WITH_DIAERESIS";
        case   0x04DD: return "CYRILLIC_SMALL_LETTER_ZHE_WITH_DIAERESIS";
        case   0x04DE: return "CYRILLIC_CAPITAL_LETTER_ZE_WITH_DIAERESIS";
        case   0x04DF: return "CYRILLIC_SMALL_LETTER_ZE_WITH_DIAERESIS";
        case   0x04E0: return "CYRILLIC_CAPITAL_LETTER_ABKHASIAN_DZE";
        case   0x04E1: return "CYRILLIC_SMALL_LETTER_ABKHASIAN_DZE";
        case   0x04E2: return "CYRILLIC_CAPITAL_LETTER_I_WITH_MACRON";
        case   0x04E3: return "CYRILLIC_SMALL_LETTER_I_WITH_MACRON";
        case   0x04E4: return "CYRILLIC_CAPITAL_LETTER_I_WITH_DIAERESIS";
        case   0x04E5: return "CYRILLIC_SMALL_LETTER_I_WITH_DIAERESIS";
        case   0x04E6: return "CYRILLIC_CAPITAL_LETTER_O_WITH_DIAERESIS";
        case   0x04E7: return "CYRILLIC_SMALL_LETTER_O_WITH_DIAERESIS";
        case   0x04E8: return "CYRILLIC_CAPITAL_LETTER_BARRED_O";
        case   0x04E9: return "CYRILLIC_SMALL_LETTER_BARRED_O";
        case   0x04EA: return
                "CYRILLIC_CAPITAL_LETTER_BARRED_O_WITH_DIAERESIS";
        case   0x04EB: return "CYRILLIC_SMALL_LETTER_BARRED_O_WITH_DIAERESIS";
        case   0x04EC: return "CYRILLIC_CAPITAL_LETTER_E_WITH_DIAERESIS";
        case   0x04ED: return "CYRILLIC_SMALL_LETTER_E_WITH_DIAERESIS";
        case   0x04EE: return "CYRILLIC_CAPITAL_LETTER_U_WITH_MACRON";
        case   0x04EF: return "CYRILLIC_SMALL_LETTER_U_WITH_MACRON";
        case   0x04F0: return "CYRILLIC_CAPITAL_LETTER_U_WITH_DIAERESIS";
        case   0x04F1: return "CYRILLIC_SMALL_LETTER_U_WITH_DIAERESIS";
        case   0x04F2: return "CYRILLIC_CAPITAL_LETTER_U_WITH_DOUBLE_ACUTE";
        case   0x04F3: return "CYRILLIC_SMALL_LETTER_U_WITH_DOUBLE_ACUTE";
        case   0x04F4: return "CYRILLIC_CAPITAL_LETTER_CHE_WITH_DIAERESIS";
        case   0x04F5: return "CYRILLIC_SMALL_LETTER_CHE_WITH_DIAERESIS";
        case   0x04F6: return "CYRILLIC_CAPITAL_LETTER_GHE_WITH_DESCENDER";
        case   0x04F7: return "CYRILLIC_SMALL_LETTER_GHE_WITH_DESCENDER";
        case   0x04F8: return "CYRILLIC_CAPITAL_LETTER_YERU_WITH_DIAERESIS";
        case   0x04F9: return "CYRILLIC_SMALL_LETTER_YERU_WITH_DIAERESIS";
        case   0x04FA: return
                "CYRILLIC_CAPITAL_LETTER_GHE_WITH_STROKE_AND_HOOK";
        case   0x04FB: return
                "CYRILLIC_SMALL_LETTER_GHE_WITH_STROKE_AND_HOOK";
        case   0x04FC: return "CYRILLIC_CAPITAL_LETTER_HA_WITH_HOOK";
        case   0x04FD: return "CYRILLIC_SMALL_LETTER_HA_WITH_HOOK";
        case   0x04FE: return "CYRILLIC_CAPITAL_LETTER_HA_WITH_STROKE";
        case   0x04FF: return "CYRILLIC_SMALL_LETTER_HA_WITH_STROKE";
        case   0x0500: return "CYRILLIC_CAPITAL_LETTER_KOMI_DE";
        case   0x0501: return "CYRILLIC_SMALL_LETTER_KOMI_DE";
        case   0x0502: return "CYRILLIC_CAPITAL_LETTER_KOMI_DJE";
        case   0x0503: return "CYRILLIC_SMALL_LETTER_KOMI_DJE";
        case   0x0504: return "CYRILLIC_CAPITAL_LETTER_KOMI_ZJE";
        case   0x0505: return "CYRILLIC_SMALL_LETTER_KOMI_ZJE";
        case   0x0506: return "CYRILLIC_CAPITAL_LETTER_KOMI_DZJE";
        case   0x0507: return "CYRILLIC_SMALL_LETTER_KOMI_DZJE";
        case   0x0508: return "CYRILLIC_CAPITAL_LETTER_KOMI_LJE";
        case   0x0509: return "CYRILLIC_SMALL_LETTER_KOMI_LJE";
        case   0x050A: return "CYRILLIC_CAPITAL_LETTER_KOMI_NJE";
        case   0x050B: return "CYRILLIC_SMALL_LETTER_KOMI_NJE";
        case   0x050C: return "CYRILLIC_CAPITAL_LETTER_KOMI_SJE";
        case   0x050D: return "CYRILLIC_SMALL_LETTER_KOMI_SJE";
        case   0x050E: return "CYRILLIC_CAPITAL_LETTER_KOMI_TJE";
        case   0x050F: return "CYRILLIC_SMALL_LETTER_KOMI_TJE";
        case   0x0510: return "CYRILLIC_CAPITAL_LETTER_REVERSED_ZE";
        case   0x0511: return "CYRILLIC_SMALL_LETTER_REVERSED_ZE";
        case   0x0512: return "CYRILLIC_CAPITAL_LETTER_EL_WITH_HOOK";
        case   0x0513: return "CYRILLIC_SMALL_LETTER_EL_WITH_HOOK";
        case   0x0514: return "CYRILLIC_CAPITAL_LETTER_LHA";
        case   0x0515: return "CYRILLIC_SMALL_LETTER_LHA";
        case   0x0516: return "CYRILLIC_CAPITAL_LETTER_RHA";
        case   0x0517: return "CYRILLIC_SMALL_LETTER_RHA";
        case   0x0518: return "CYRILLIC_CAPITAL_LETTER_YAE";
        case   0x0519: return "CYRILLIC_SMALL_LETTER_YAE";
        case   0x051A: return "CYRILLIC_CAPITAL_LETTER_QA";
        case   0x051B: return "CYRILLIC_SMALL_LETTER_QA";
        case   0x051C: return "CYRILLIC_CAPITAL_LETTER_WE";
        case   0x051D: return "CYRILLIC_SMALL_LETTER_WE";
        case   0x051E: return "CYRILLIC_CAPITAL_LETTER_ALEUT_KA";
        case   0x051F: return "CYRILLIC_SMALL_LETTER_ALEUT_KA";
        case   0x0520: return "CYRILLIC_CAPITAL_LETTER_EL_WITH_MIDDLE_HOOK";
        case   0x0521: return "CYRILLIC_SMALL_LETTER_EL_WITH_MIDDLE_HOOK";
        case   0x0522: return "CYRILLIC_CAPITAL_LETTER_EN_WITH_MIDDLE_HOOK";
        case   0x0523: return "CYRILLIC_SMALL_LETTER_EN_WITH_MIDDLE_HOOK";
        case   0x0524: return "CYRILLIC_CAPITAL_LETTER_PE_WITH_DESCENDER";
        case   0x0525: return "CYRILLIC_SMALL_LETTER_PE_WITH_DESCENDER";
        case   0x0526: return "CYRILLIC_CAPITAL_LETTER_SHHA_WITH_DESCENDER";
        case   0x0527: return "CYRILLIC_SMALL_LETTER_SHHA_WITH_DESCENDER";
        case   0x0528: return "CYRILLIC_CAPITAL_LETTER_EN_WITH_LEFT_HOOK";
        case   0x0529: return "CYRILLIC_SMALL_LETTER_EN_WITH_LEFT_HOOK";
        case   0x052A: return "CYRILLIC_CAPITAL_LETTER_DZZHE";
        case   0x052B: return "CYRILLIC_SMALL_LETTER_DZZHE";
        case   0x052C: return "CYRILLIC_CAPITAL_LETTER_DCHE";
        case   0x052D: return "CYRILLIC_SMALL_LETTER_DCHE";
        case   0x052E: return "CYRILLIC_CAPITAL_LETTER_EL_WITH_DESCENDER";
        case   0x052F: return "CYRILLIC_SMALL_LETTER_EL_WITH_DESCENDER";
        case   0x0531: return "ARMENIAN_CAPITAL_LETTER_AYB";
        case   0x0532: return "ARMENIAN_CAPITAL_LETTER_BEN";
        case   0x0533: return "ARMENIAN_CAPITAL_LETTER_GIM";
        case   0x0534: return "ARMENIAN_CAPITAL_LETTER_DA";
        case   0x0535: return "ARMENIAN_CAPITAL_LETTER_ECH";
        case   0x0536: return "ARMENIAN_CAPITAL_LETTER_ZA";
        case   0x0537: return "ARMENIAN_CAPITAL_LETTER_EH";
        case   0x0538: return "ARMENIAN_CAPITAL_LETTER_ET";
        case   0x0539: return "ARMENIAN_CAPITAL_LETTER_TO";
        case   0x053A: return "ARMENIAN_CAPITAL_LETTER_ZHE";
        case   0x053B: return "ARMENIAN_CAPITAL_LETTER_INI";
        case   0x053C: return "ARMENIAN_CAPITAL_LETTER_LIWN";
        case   0x053D: return "ARMENIAN_CAPITAL_LETTER_XEH";
        case   0x053E: return "ARMENIAN_CAPITAL_LETTER_CA";
        case   0x053F: return "ARMENIAN_CAPITAL_LETTER_KEN";
        case   0x0540: return "ARMENIAN_CAPITAL_LETTER_HO";
        case   0x0541: return "ARMENIAN_CAPITAL_LETTER_JA";
        case   0x0542: return "ARMENIAN_CAPITAL_LETTER_GHAD";
        case   0x0543: return "ARMENIAN_CAPITAL_LETTER_CHEH";
        case   0x0544: return "ARMENIAN_CAPITAL_LETTER_MEN";
        case   0x0545: return "ARMENIAN_CAPITAL_LETTER_YI";
        case   0x0546: return "ARMENIAN_CAPITAL_LETTER_NOW";
        case   0x0547: return "ARMENIAN_CAPITAL_LETTER_SHA";
        case   0x0548: return "ARMENIAN_CAPITAL_LETTER_VO";
        case   0x0549: return "ARMENIAN_CAPITAL_LETTER_CHA";
        case   0x054A: return "ARMENIAN_CAPITAL_LETTER_PEH";
        case   0x054B: return "ARMENIAN_CAPITAL_LETTER_JHEH";
        case   0x054C: return "ARMENIAN_CAPITAL_LETTER_RA";
        case   0x054D: return "ARMENIAN_CAPITAL_LETTER_SEH";
        case   0x054E: return "ARMENIAN_CAPITAL_LETTER_VEW";
        case   0x054F: return "ARMENIAN_CAPITAL_LETTER_TIWN";
        case   0x0550: return "ARMENIAN_CAPITAL_LETTER_REH";
        case   0x0551: return "ARMENIAN_CAPITAL_LETTER_CO";
        case   0x0552: return "ARMENIAN_CAPITAL_LETTER_YIWN";
        case   0x0553: return "ARMENIAN_CAPITAL_LETTER_PIWR";
        case   0x0554: return "ARMENIAN_CAPITAL_LETTER_KEH";
        case   0x0555: return "ARMENIAN_CAPITAL_LETTER_OH";
        case   0x0556: return "ARMENIAN_CAPITAL_LETTER_FEH";
        case   0x0559: return "ARMENIAN_MODIFIER_LETTER_LEFT_HALF_RING";
        case   0x055A: return "ARMENIAN_APOSTROPHE";
        case   0x055B: return "ARMENIAN_EMPHASIS_MARK";
        case   0x055C: return "ARMENIAN_EXCLAMATION_MARK";
        case   0x055D: return "ARMENIAN_COMMA";
        case   0x055E: return "ARMENIAN_QUESTION_MARK";
        case   0x055F: return "ARMENIAN_ABBREVIATION_MARK";
        case   0x0561: return "ARMENIAN_SMALL_LETTER_AYB";
        case   0x0562: return "ARMENIAN_SMALL_LETTER_BEN";
        case   0x0563: return "ARMENIAN_SMALL_LETTER_GIM";
        case   0x0564: return "ARMENIAN_SMALL_LETTER_DA";
        case   0x0565: return "ARMENIAN_SMALL_LETTER_ECH";
        case   0x0566: return "ARMENIAN_SMALL_LETTER_ZA";
        case   0x0567: return "ARMENIAN_SMALL_LETTER_EH";
        case   0x0568: return "ARMENIAN_SMALL_LETTER_ET";
        case   0x0569: return "ARMENIAN_SMALL_LETTER_TO";
        case   0x056A: return "ARMENIAN_SMALL_LETTER_ZHE";
        case   0x056B: return "ARMENIAN_SMALL_LETTER_INI";
        case   0x056C: return "ARMENIAN_SMALL_LETTER_LIWN";
        case   0x056D: return "ARMENIAN_SMALL_LETTER_XEH";
        case   0x056E: return "ARMENIAN_SMALL_LETTER_CA";
        case   0x056F: return "ARMENIAN_SMALL_LETTER_KEN";
        case   0x0570: return "ARMENIAN_SMALL_LETTER_HO";
        case   0x0571: return "ARMENIAN_SMALL_LETTER_JA";
        case   0x0572: return "ARMENIAN_SMALL_LETTER_GHAD";
        case   0x0573: return "ARMENIAN_SMALL_LETTER_CHEH";
        case   0x0574: return "ARMENIAN_SMALL_LETTER_MEN";
        case   0x0575: return "ARMENIAN_SMALL_LETTER_YI";
        case   0x0576: return "ARMENIAN_SMALL_LETTER_NOW";
        case   0x0577: return "ARMENIAN_SMALL_LETTER_SHA";
        case   0x0578: return "ARMENIAN_SMALL_LETTER_VO";
        case   0x0579: return "ARMENIAN_SMALL_LETTER_CHA";
        case   0x057A: return "ARMENIAN_SMALL_LETTER_PEH";
        case   0x057B: return "ARMENIAN_SMALL_LETTER_JHEH";
        case   0x057C: return "ARMENIAN_SMALL_LETTER_RA";
        case   0x057D: return "ARMENIAN_SMALL_LETTER_SEH";
        case   0x057E: return "ARMENIAN_SMALL_LETTER_VEW";
        case   0x057F: return "ARMENIAN_SMALL_LETTER_TIWN";
        case   0x0580: return "ARMENIAN_SMALL_LETTER_REH";
        case   0x0581: return "ARMENIAN_SMALL_LETTER_CO";
        case   0x0582: return "ARMENIAN_SMALL_LETTER_YIWN";
        case   0x0583: return "ARMENIAN_SMALL_LETTER_PIWR";
        case   0x0584: return "ARMENIAN_SMALL_LETTER_KEH";
        case   0x0585: return "ARMENIAN_SMALL_LETTER_OH";
        case   0x0586: return "ARMENIAN_SMALL_LETTER_FEH";
        case   0x0587: return "ARMENIAN_SMALL_LIGATURE_ECH_YIWN";
        case   0x0589: return "ARMENIAN_FULL_STOP";
        case   0x058A: return "ARMENIAN_HYPHEN";
        case   0x058D: return "RIGHT_FACING_ARMENIAN_ETERNITY_SIGN";
        case   0x058E: return "LEFT_FACING_ARMENIAN_ETERNITY_SIGN";
        case   0x058F: return "ARMENIAN_DRAM_SIGN";
        case   0x0591: return "HEBREW_ACCENT_ETNAHTA";
        case   0x0592: return "HEBREW_ACCENT_SEGOL";
        case   0x0593: return "HEBREW_ACCENT_SHALSHELET";
        case   0x0594: return "HEBREW_ACCENT_ZAQEF_QATAN";
        case   0x0595: return "HEBREW_ACCENT_ZAQEF_GADOL";
        case   0x0596: return "HEBREW_ACCENT_TIPEHA";
        case   0x0597: return "HEBREW_ACCENT_REVIA";
        case   0x0598: return "HEBREW_ACCENT_ZARQA";
        case   0x0599: return "HEBREW_ACCENT_PASHTA";
        case   0x059A: return "HEBREW_ACCENT_YETIV";
        case   0x059B: return "HEBREW_ACCENT_TEVIR";
        case   0x059C: return "HEBREW_ACCENT_GERESH";
        case   0x059D: return "HEBREW_ACCENT_GERESH_MUQDAM";
        case   0x059E: return "HEBREW_ACCENT_GERSHAYIM";
        case   0x059F: return "HEBREW_ACCENT_QARNEY_PARA";
        case   0x05A0: return "HEBREW_ACCENT_TELISHA_GEDOLA";
        case   0x05A1: return "HEBREW_ACCENT_PAZER";
        case   0x05A2: return "HEBREW_ACCENT_ATNAH_HAFUKH";
        case   0x05A3: return "HEBREW_ACCENT_MUNAH";
        case   0x05A4: return "HEBREW_ACCENT_MAHAPAKH";
        case   0x05A5: return "HEBREW_ACCENT_MERKHA";
        case   0x05A6: return "HEBREW_ACCENT_MERKHA_KEFULA";
        case   0x05A7: return "HEBREW_ACCENT_DARGA";
        case   0x05A8: return "HEBREW_ACCENT_QADMA";
        case   0x05A9: return "HEBREW_ACCENT_TELISHA_QETANA";
        case   0x05AA: return "HEBREW_ACCENT_YERAH_BEN_YOMO";
        case   0x05AB: return "HEBREW_ACCENT_OLE";
        case   0x05AC: return "HEBREW_ACCENT_ILUY";
        case   0x05AD: return "HEBREW_ACCENT_DEHI";
        case   0x05AE: return "HEBREW_ACCENT_ZINOR";
        case   0x05AF: return "HEBREW_MARK_MASORA_CIRCLE";
        case   0x05B0: return "HEBREW_POINT_SHEVA";
        case   0x05B1: return "HEBREW_POINT_HATAF_SEGOL";
        case   0x05B2: return "HEBREW_POINT_HATAF_PATAH";
        case   0x05B3: return "HEBREW_POINT_HATAF_QAMATS";
        case   0x05B4: return "HEBREW_POINT_HIRIQ";
        case   0x05B5: return "HEBREW_POINT_TSERE";
        case   0x05B6: return "HEBREW_POINT_SEGOL";
        case   0x05B7: return "HEBREW_POINT_PATAH";
        case   0x05B8: return "HEBREW_POINT_QAMATS";
        case   0x05B9: return "HEBREW_POINT_HOLAM";
        case   0x05BA: return "HEBREW_POINT_HOLAM_HASER_FOR_VAV";
        case   0x05BB: return "HEBREW_POINT_QUBUTS";
        case   0x05BC: return "HEBREW_POINT_DAGESH_OR_MAPIQ";
        case   0x05BD: return "HEBREW_POINT_METEG";
        case   0x05BE: return "HEBREW_PUNCTUATION_MAQAF";
        case   0x05BF: return "HEBREW_POINT_RAFE";
        case   0x05C0: return "HEBREW_PUNCTUATION_PASEQ";
        case   0x05C1: return "HEBREW_POINT_SHIN_DOT";
        case   0x05C2: return "HEBREW_POINT_SIN_DOT";
        case   0x05C3: return "HEBREW_PUNCTUATION_SOF_PASUQ";
        case   0x05C4: return "HEBREW_MARK_UPPER_DOT";
        case   0x05C5: return "HEBREW_MARK_LOWER_DOT";
        case   0x05C6: return "HEBREW_PUNCTUATION_NUN_HAFUKHA";
        case   0x05C7: return "HEBREW_POINT_QAMATS_QATAN";
        case   0x05D0: return "HEBREW_LETTER_ALEF";
        case   0x05D1: return "HEBREW_LETTER_BET";
        case   0x05D2: return "HEBREW_LETTER_GIMEL";
        case   0x05D3: return "HEBREW_LETTER_DALET";
        case   0x05D4: return "HEBREW_LETTER_HE";
        case   0x05D5: return "HEBREW_LETTER_VAV";
        case   0x05D6: return "HEBREW_LETTER_ZAYIN";
        case   0x05D7: return "HEBREW_LETTER_HET";
        case   0x05D8: return "HEBREW_LETTER_TET";
        case   0x05D9: return "HEBREW_LETTER_YOD";
        case   0x05DA: return "HEBREW_LETTER_FINAL_KAF";
        case   0x05DB: return "HEBREW_LETTER_KAF";
        case   0x05DC: return "HEBREW_LETTER_LAMED";
        case   0x05DD: return "HEBREW_LETTER_FINAL_MEM";
        case   0x05DE: return "HEBREW_LETTER_MEM";
        case   0x05DF: return "HEBREW_LETTER_FINAL_NUN";
        case   0x05E0: return "HEBREW_LETTER_NUN";
        case   0x05E1: return "HEBREW_LETTER_SAMEKH";
        case   0x05E2: return "HEBREW_LETTER_AYIN";
        case   0x05E3: return "HEBREW_LETTER_FINAL_PE";
        case   0x05E4: return "HEBREW_LETTER_PE";
        case   0x05E5: return "HEBREW_LETTER_FINAL_TSADI";
        case   0x05E6: return "HEBREW_LETTER_TSADI";
        case   0x05E7: return "HEBREW_LETTER_QOF";
        case   0x05E8: return "HEBREW_LETTER_RESH";
        case   0x05E9: return "HEBREW_LETTER_SHIN";
        case   0x05EA: return "HEBREW_LETTER_TAV";
        case   0x05F0: return "HEBREW_LIGATURE_YIDDISH_DOUBLE_VAV";
        case   0x05F1: return "HEBREW_LIGATURE_YIDDISH_VAV_YOD";
        case   0x05F2: return "HEBREW_LIGATURE_YIDDISH_DOUBLE_YOD";
        case   0x05F3: return "HEBREW_PUNCTUATION_GERESH";
        case   0x05F4: return "HEBREW_PUNCTUATION_GERSHAYIM";
        case   0x0600: return "ARABIC_NUMBER_SIGN";
        case   0x0601: return "ARABIC_SIGN_SANAH";
        case   0x0602: return "ARABIC_FOOTNOTE_MARKER";
        case   0x0603: return "ARABIC_SIGN_SAFHA";
        case   0x0604: return "ARABIC_SIGN_SAMVAT";
        case   0x0605: return "ARABIC_NUMBER_MARK_ABOVE";
        case   0x0606: return "ARABIC_INDIC_CUBE_ROOT";
        case   0x0607: return "ARABIC_INDIC_FOURTH_ROOT";
        case   0x0608: return "ARABIC_RAY";
        case   0x0609: return "ARABIC_INDIC_PER_MILLE_SIGN";
        case   0x060A: return "ARABIC_INDIC_PER_TEN_THOUSAND_SIGN";
        case   0x060B: return "AFGHANI_SIGN";
        case   0x060C: return "ARABIC_COMMA";
        case   0x060D: return "ARABIC_DATE_SEPARATOR";
        case   0x060E: return "ARABIC_POETIC_VERSE_SIGN";
        case   0x060F: return "ARABIC_SIGN_MISRA";
        case   0x0610: return "ARABIC_SIGN_SALLALLAHOU_ALAYHE_WASSALLAM";
        case   0x0611: return "ARABIC_SIGN_ALAYHE_ASSALLAM";
        case   0x0612: return "ARABIC_SIGN_RAHMATULLAH_ALAYHE";
        case   0x0613: return "ARABIC_SIGN_RADI_ALLAHOU_ANHU";
        case   0x0614: return "ARABIC_SIGN_TAKHALLUS";
        case   0x0615: return "ARABIC_SMALL_HIGH_TAH";
        case   0x0616: return
                "ARABIC_SMALL_HIGH_LIGATURE_ALEF_WITH_LAM_WITH_YEH";
        case   0x0617: return "ARABIC_SMALL_HIGH_ZAIN";
        case   0x0618: return "ARABIC_SMALL_FATHA";
        case   0x0619: return "ARABIC_SMALL_DAMMA";
        case   0x061A: return "ARABIC_SMALL_KASRA";
        case   0x061B: return "ARABIC_SEMICOLON";
        case   0x061C: return "ARABIC_LETTER_MARK";
        case   0x061E: return "ARABIC_TRIPLE_DOT_PUNCTUATION_MARK";
        case   0x061F: return "ARABIC_QUESTION_MARK";
        case   0x0620: return "ARABIC_LETTER_KASHMIRI_YEH";
        case   0x0621: return "ARABIC_LETTER_HAMZA";
        case   0x0622: return "ARABIC_LETTER_ALEF_WITH_MADDA_ABOVE";
        case   0x0623: return "ARABIC_LETTER_ALEF_WITH_HAMZA_ABOVE";
        case   0x0624: return "ARABIC_LETTER_WAW_WITH_HAMZA_ABOVE";
        case   0x0625: return "ARABIC_LETTER_ALEF_WITH_HAMZA_BELOW";
        case   0x0626: return "ARABIC_LETTER_YEH_WITH_HAMZA_ABOVE";
        case   0x0627: return "ARABIC_LETTER_ALEF";
        case   0x0628: return "ARABIC_LETTER_BEH";
        case   0x0629: return "ARABIC_LETTER_TEH_MARBUTA";
        case   0x062A: return "ARABIC_LETTER_TEH";
        case   0x062B: return "ARABIC_LETTER_THEH";
        case   0x062C: return "ARABIC_LETTER_JEEM";
        case   0x062D: return "ARABIC_LETTER_HAH";
        case   0x062E: return "ARABIC_LETTER_KHAH";
        case   0x062F: return "ARABIC_LETTER_DAL";
        case   0x0630: return "ARABIC_LETTER_THAL";
        case   0x0631: return "ARABIC_LETTER_REH";
        case   0x0632: return "ARABIC_LETTER_ZAIN";
        case   0x0633: return "ARABIC_LETTER_SEEN";
        case   0x0634: return "ARABIC_LETTER_SHEEN";
        case   0x0635: return "ARABIC_LETTER_SAD";
        case   0x0636: return "ARABIC_LETTER_DAD";
        case   0x0637: return "ARABIC_LETTER_TAH";
        case   0x0638: return "ARABIC_LETTER_ZAH";
        case   0x0639: return "ARABIC_LETTER_AIN";
        case   0x063A: return "ARABIC_LETTER_GHAIN";
        case   0x063B: return "ARABIC_LETTER_KEHEH_WITH_TWO_DOTS_ABOVE";
        case   0x063C: return "ARABIC_LETTER_KEHEH_WITH_THREE_DOTS_BELOW";
        case   0x063D: return "ARABIC_LETTER_FARSI_YEH_WITH_INVERTED_V";
        case   0x063E: return "ARABIC_LETTER_FARSI_YEH_WITH_TWO_DOTS_ABOVE";
        case   0x063F: return "ARABIC_LETTER_FARSI_YEH_WITH_THREE_DOTS_ABOVE";
        case   0x0640: return "ARABIC_TATWEEL";
        case   0x0641: return "ARABIC_LETTER_FEH";
        case   0x0642: return "ARABIC_LETTER_QAF";
        case   0x0643: return "ARABIC_LETTER_KAF";
        case   0x0644: return "ARABIC_LETTER_LAM";
        case   0x0645: return "ARABIC_LETTER_MEEM";
        case   0x0646: return "ARABIC_LETTER_NOON";
        case   0x0647: return "ARABIC_LETTER_HEH";
        case   0x0648: return "ARABIC_LETTER_WAW";
        case   0x0649: return "ARABIC_LETTER_ALEF_MAKSURA";
        case   0x064A: return "ARABIC_LETTER_YEH";
        case   0x064B: return "ARABIC_FATHATAN";
        case   0x064C: return "ARABIC_DAMMATAN";
        case   0x064D: return "ARABIC_KASRATAN";
        case   0x064E: return "ARABIC_FATHA";
        case   0x064F: return "ARABIC_DAMMA";
        case   0x0650: return "ARABIC_KASRA";
        case   0x0651: return "ARABIC_SHADDA";
        case   0x0652: return "ARABIC_SUKUN";
        case   0x0653: return "ARABIC_MADDAH_ABOVE";
        case   0x0654: return "ARABIC_HAMZA_ABOVE";
        case   0x0655: return "ARABIC_HAMZA_BELOW";
        case   0x0656: return "ARABIC_SUBSCRIPT_ALEF";
        case   0x0657: return "ARABIC_INVERTED_DAMMA";
        case   0x0658: return "ARABIC_MARK_NOON_GHUNNA";
        case   0x0659: return "ARABIC_ZWARAKAY";
        case   0x065A: return "ARABIC_VOWEL_SIGN_SMALL_V_ABOVE";
        case   0x065B: return "ARABIC_VOWEL_SIGN_INVERTED_SMALL_V_ABOVE";
        case   0x065C: return "ARABIC_VOWEL_SIGN_DOT_BELOW";
        case   0x065D: return "ARABIC_REVERSED_DAMMA";
        case   0x065E: return "ARABIC_FATHA_WITH_TWO_DOTS";
        case   0x065F: return "ARABIC_WAVY_HAMZA_BELOW";
        case   0x0660: return "ARABIC_INDIC_DIGIT_ZERO";
        case   0x0661: return "ARABIC_INDIC_DIGIT_ONE";
        case   0x0662: return "ARABIC_INDIC_DIGIT_TWO";
        case   0x0663: return "ARABIC_INDIC_DIGIT_THREE";
        case   0x0664: return "ARABIC_INDIC_DIGIT_FOUR";
        case   0x0665: return "ARABIC_INDIC_DIGIT_FIVE";
        case   0x0666: return "ARABIC_INDIC_DIGIT_SIX";
        case   0x0667: return "ARABIC_INDIC_DIGIT_SEVEN";
        case   0x0668: return "ARABIC_INDIC_DIGIT_EIGHT";
        case   0x0669: return "ARABIC_INDIC_DIGIT_NINE";
        case   0x066A: return "ARABIC_PERCENT_SIGN";
        case   0x066B: return "ARABIC_DECIMAL_SEPARATOR";
        case   0x066C: return "ARABIC_THOUSANDS_SEPARATOR";
        case   0x066D: return "ARABIC_FIVE_POINTED_STAR";
        case   0x066E: return "ARABIC_LETTER_DOTLESS_BEH";
        case   0x066F: return "ARABIC_LETTER_DOTLESS_QAF";
        case   0x0670: return "ARABIC_LETTER_SUPERSCRIPT_ALEF";
        case   0x0671: return "ARABIC_LETTER_ALEF_WASLA";
        case   0x0672: return "ARABIC_LETTER_ALEF_WITH_WAVY_HAMZA_ABOVE";
        case   0x0673: return "ARABIC_LETTER_ALEF_WITH_WAVY_HAMZA_BELOW";
        case   0x0674: return "ARABIC_LETTER_HIGH_HAMZA";
        case   0x0675: return "ARABIC_LETTER_HIGH_HAMZA_ALEF";
        case   0x0676: return "ARABIC_LETTER_HIGH_HAMZA_WAW";
        case   0x0677: return "ARABIC_LETTER_U_WITH_HAMZA_ABOVE";
        case   0x0678: return "ARABIC_LETTER_HIGH_HAMZA_YEH";
        case   0x0679: return "ARABIC_LETTER_TTEH";
        case   0x067A: return "ARABIC_LETTER_TTEHEH";
        case   0x067B: return "ARABIC_LETTER_BEEH";
        case   0x067C: return "ARABIC_LETTER_TEH_WITH_RING";
        case   0x067D: return
                "ARABIC_LETTER_TEH_WITH_THREE_DOTS_ABOVE_DOWNWARDS";
        case   0x067E: return "ARABIC_LETTER_PEH";
        case   0x067F: return "ARABIC_LETTER_TEHEH";
        case   0x0680: return "ARABIC_LETTER_BEHEH";
        case   0x0681: return "ARABIC_LETTER_HAH_WITH_HAMZA_ABOVE";
        case   0x0682: return
                "ARABIC_LETTER_HAH_WITH_TWO_DOTS_VERTICAL_ABOVE";
        case   0x0683: return "ARABIC_LETTER_NYEH";
        case   0x0684: return "ARABIC_LETTER_DYEH";
        case   0x0685: return "ARABIC_LETTER_HAH_WITH_THREE_DOTS_ABOVE";
        case   0x0686: return "ARABIC_LETTER_TCHEH";
        case   0x0687: return "ARABIC_LETTER_TCHEHEH";
        case   0x0688: return "ARABIC_LETTER_DDAL";
        case   0x0689: return "ARABIC_LETTER_DAL_WITH_RING";
        case   0x068A: return "ARABIC_LETTER_DAL_WITH_DOT_BELOW";
        case   0x068B: return
                "ARABIC_LETTER_DAL_WITH_DOT_BELOW_AND_SMALL_TAH";
        case   0x068C: return "ARABIC_LETTER_DAHAL";
        case   0x068D: return "ARABIC_LETTER_DDAHAL";
        case   0x068E: return "ARABIC_LETTER_DUL";
        case   0x068F: return
                "ARABIC_LETTER_DAL_WITH_THREE_DOTS_ABOVE_DOWNWARDS";
        case   0x0690: return "ARABIC_LETTER_DAL_WITH_FOUR_DOTS_ABOVE";
        case   0x0691: return "ARABIC_LETTER_RREH";
        case   0x0692: return "ARABIC_LETTER_REH_WITH_SMALL_V";
        case   0x0693: return "ARABIC_LETTER_REH_WITH_RING";
        case   0x0694: return "ARABIC_LETTER_REH_WITH_DOT_BELOW";
        case   0x0695: return "ARABIC_LETTER_REH_WITH_SMALL_V_BELOW";
        case   0x0696: return
                "ARABIC_LETTER_REH_WITH_DOT_BELOW_AND_DOT_ABOVE";
        case   0x0697: return "ARABIC_LETTER_REH_WITH_TWO_DOTS_ABOVE";
        case   0x0698: return "ARABIC_LETTER_JEH";
        case   0x0699: return "ARABIC_LETTER_REH_WITH_FOUR_DOTS_ABOVE";
        case   0x069A: return
                "ARABIC_LETTER_SEEN_WITH_DOT_BELOW_AND_DOT_ABOVE";
        case   0x069B: return "ARABIC_LETTER_SEEN_WITH_THREE_DOTS_BELOW";
        case   0x069C: return
                "ARABIC_LETTER_SEEN_WITH_THREE_DOTS_BELOW_AND_THREE_DOTS_ABOVE";
        case   0x069D: return "ARABIC_LETTER_SAD_WITH_TWO_DOTS_BELOW";
        case   0x069E: return "ARABIC_LETTER_SAD_WITH_THREE_DOTS_ABOVE";
        case   0x069F: return "ARABIC_LETTER_TAH_WITH_THREE_DOTS_ABOVE";
        case   0x06A0: return "ARABIC_LETTER_AIN_WITH_THREE_DOTS_ABOVE";
        case   0x06A1: return "ARABIC_LETTER_DOTLESS_FEH";
        case   0x06A2: return "ARABIC_LETTER_FEH_WITH_DOT_MOVED_BELOW";
        case   0x06A3: return "ARABIC_LETTER_FEH_WITH_DOT_BELOW";
        case   0x06A4: return "ARABIC_LETTER_VEH";
        case   0x06A5: return "ARABIC_LETTER_FEH_WITH_THREE_DOTS_BELOW";
        case   0x06A6: return "ARABIC_LETTER_PEHEH";
        case   0x06A7: return "ARABIC_LETTER_QAF_WITH_DOT_ABOVE";
        case   0x06A8: return "ARABIC_LETTER_QAF_WITH_THREE_DOTS_ABOVE";
        case   0x06A9: return "ARABIC_LETTER_KEHEH";
        case   0x06AA: return "ARABIC_LETTER_SWASH_KAF";
        case   0x06AB: return "ARABIC_LETTER_KAF_WITH_RING";
        case   0x06AC: return "ARABIC_LETTER_KAF_WITH_DOT_ABOVE";
        case   0x06AD: return "ARABIC_LETTER_NG";
        case   0x06AE: return "ARABIC_LETTER_KAF_WITH_THREE_DOTS_BELOW";
        case   0x06AF: return "ARABIC_LETTER_GAF";
        case   0x06B0: return "ARABIC_LETTER_GAF_WITH_RING";
        case   0x06B1: return "ARABIC_LETTER_NGOEH";
        case   0x06B2: return "ARABIC_LETTER_GAF_WITH_TWO_DOTS_BELOW";
        case   0x06B3: return "ARABIC_LETTER_GUEH";
        case   0x06B4: return "ARABIC_LETTER_GAF_WITH_THREE_DOTS_ABOVE";
        case   0x06B5: return "ARABIC_LETTER_LAM_WITH_SMALL_V";
        case   0x06B6: return "ARABIC_LETTER_LAM_WITH_DOT_ABOVE";
        case   0x06B7: return "ARABIC_LETTER_LAM_WITH_THREE_DOTS_ABOVE";
        case   0x06B8: return "ARABIC_LETTER_LAM_WITH_THREE_DOTS_BELOW";
        case   0x06B9: return "ARABIC_LETTER_NOON_WITH_DOT_BELOW";
        case   0x06BA: return "ARABIC_LETTER_NOON_GHUNNA";
        case   0x06BB: return "ARABIC_LETTER_RNOON";
        case   0x06BC: return "ARABIC_LETTER_NOON_WITH_RING";
        case   0x06BD: return "ARABIC_LETTER_NOON_WITH_THREE_DOTS_ABOVE";
        case   0x06BE: return "ARABIC_LETTER_HEH_DOACHASHMEE";
        case   0x06BF: return "ARABIC_LETTER_TCHEH_WITH_DOT_ABOVE";
        case   0x06C0: return "ARABIC_LETTER_HEH_WITH_YEH_ABOVE";
        case   0x06C1: return "ARABIC_LETTER_HEH_GOAL";
        case   0x06C2: return "ARABIC_LETTER_HEH_GOAL_WITH_HAMZA_ABOVE";
        case   0x06C3: return "ARABIC_LETTER_TEH_MARBUTA_GOAL";
        case   0x06C4: return "ARABIC_LETTER_WAW_WITH_RING";
        case   0x06C5: return "ARABIC_LETTER_KIRGHIZ_OE";
        case   0x06C6: return "ARABIC_LETTER_OE";
        case   0x06C7: return "ARABIC_LETTER_U";
        case   0x06C8: return "ARABIC_LETTER_YU";
        case   0x06C9: return "ARABIC_LETTER_KIRGHIZ_YU";
        case   0x06CA: return "ARABIC_LETTER_WAW_WITH_TWO_DOTS_ABOVE";
        case   0x06CB: return "ARABIC_LETTER_VE";
        case   0x06CC: return "ARABIC_LETTER_FARSI_YEH";
        case   0x06CD: return "ARABIC_LETTER_YEH_WITH_TAIL";
        case   0x06CE: return "ARABIC_LETTER_YEH_WITH_SMALL_V";
        case   0x06CF: return "ARABIC_LETTER_WAW_WITH_DOT_ABOVE";
        case   0x06D0: return "ARABIC_LETTER_E";
        case   0x06D1: return "ARABIC_LETTER_YEH_WITH_THREE_DOTS_BELOW";
        case   0x06D2: return "ARABIC_LETTER_YEH_BARREE";
        case   0x06D3: return "ARABIC_LETTER_YEH_BARREE_WITH_HAMZA_ABOVE";
        case   0x06D4: return "ARABIC_FULL_STOP";
        case   0x06D5: return "ARABIC_LETTER_AE";
        case   0x06D6: return
                "ARABIC_SMALL_HIGH_LIGATURE_SAD_WITH_LAM_WITH_ALEF_MAKSURA";
        case   0x06D7: return
                "ARABIC_SMALL_HIGH_LIGATURE_QAF_WITH_LAM_WITH_ALEF_MAKSURA";
        case   0x06D8: return "ARABIC_SMALL_HIGH_MEEM_INITIAL_FORM";
        case   0x06D9: return "ARABIC_SMALL_HIGH_LAM_ALEF";
        case   0x06DA: return "ARABIC_SMALL_HIGH_JEEM";
        case   0x06DB: return "ARABIC_SMALL_HIGH_THREE_DOTS";
        case   0x06DC: return "ARABIC_SMALL_HIGH_SEEN";
        case   0x06DD: return "ARABIC_END_OF_AYAH";
        case   0x06DE: return "ARABIC_START_OF_RUB_EL_HIZB";
        case   0x06DF: return "ARABIC_SMALL_HIGH_ROUNDED_ZERO";
        case   0x06E0: return "ARABIC_SMALL_HIGH_UPRIGHT_RECTANGULAR_ZERO";
        case   0x06E1: return "ARABIC_SMALL_HIGH_DOTLESS_HEAD_OF_KHAH";
        case   0x06E2: return "ARABIC_SMALL_HIGH_MEEM_ISOLATED_FORM";
        case   0x06E3: return "ARABIC_SMALL_LOW_SEEN";
        case   0x06E4: return "ARABIC_SMALL_HIGH_MADDA";
        case   0x06E5: return "ARABIC_SMALL_WAW";
        case   0x06E6: return "ARABIC_SMALL_YEH";
        case   0x06E7: return "ARABIC_SMALL_HIGH_YEH";
        case   0x06E8: return "ARABIC_SMALL_HIGH_NOON";
        case   0x06E9: return "ARABIC_PLACE_OF_SAJDAH";
        case   0x06EA: return "ARABIC_EMPTY_CENTRE_LOW_STOP";
        case   0x06EB: return "ARABIC_EMPTY_CENTRE_HIGH_STOP";
        case   0x06EC: return "ARABIC_ROUNDED_HIGH_STOP_WITH_FILLED_CENTRE";
        case   0x06ED: return "ARABIC_SMALL_LOW_MEEM";
        case   0x06EE: return "ARABIC_LETTER_DAL_WITH_INVERTED_V";
        case   0x06EF: return "ARABIC_LETTER_REH_WITH_INVERTED_V";
        case   0x06F0: return "EXTENDED_ARABIC_INDIC_DIGIT_ZERO";
        case   0x06F1: return "EXTENDED_ARABIC_INDIC_DIGIT_ONE";
        case   0x06F2: return "EXTENDED_ARABIC_INDIC_DIGIT_TWO";
        case   0x06F3: return "EXTENDED_ARABIC_INDIC_DIGIT_THREE";
        case   0x06F4: return "EXTENDED_ARABIC_INDIC_DIGIT_FOUR";
        case   0x06F5: return "EXTENDED_ARABIC_INDIC_DIGIT_FIVE";
        case   0x06F6: return "EXTENDED_ARABIC_INDIC_DIGIT_SIX";
        case   0x06F7: return "EXTENDED_ARABIC_INDIC_DIGIT_SEVEN";
        case   0x06F8: return "EXTENDED_ARABIC_INDIC_DIGIT_EIGHT";
        case   0x06F9: return "EXTENDED_ARABIC_INDIC_DIGIT_NINE";
        case   0x06FA: return "ARABIC_LETTER_SHEEN_WITH_DOT_BELOW";
        case   0x06FB: return "ARABIC_LETTER_DAD_WITH_DOT_BELOW";
        case   0x06FC: return "ARABIC_LETTER_GHAIN_WITH_DOT_BELOW";
        case   0x06FD: return "ARABIC_SIGN_SINDHI_AMPERSAND";
        case   0x06FE: return "ARABIC_SIGN_SINDHI_POSTPOSITION_MEN";
        case   0x06FF: return "ARABIC_LETTER_HEH_WITH_INVERTED_V";
        case   0x0700: return "SYRIAC_END_OF_PARAGRAPH";
        case   0x0701: return "SYRIAC_SUPRALINEAR_FULL_STOP";
        case   0x0702: return "SYRIAC_SUBLINEAR_FULL_STOP";
        case   0x0703: return "SYRIAC_SUPRALINEAR_COLON";
        case   0x0704: return "SYRIAC_SUBLINEAR_COLON";
        case   0x0705: return "SYRIAC_HORIZONTAL_COLON";
        case   0x0706: return "SYRIAC_COLON_SKEWED_LEFT";
        case   0x0707: return "SYRIAC_COLON_SKEWED_RIGHT";
        case   0x0708: return "SYRIAC_SUPRALINEAR_COLON_SKEWED_LEFT";
        case   0x0709: return "SYRIAC_SUBLINEAR_COLON_SKEWED_RIGHT";
        case   0x070A: return "SYRIAC_CONTRACTION";
        case   0x070B: return "SYRIAC_HARKLEAN_OBELUS";
        case   0x070C: return "SYRIAC_HARKLEAN_METOBELUS";
        case   0x070D: return "SYRIAC_HARKLEAN_ASTERISCUS";
        case   0x070F: return "SYRIAC_ABBREVIATION_MARK";
        case   0x0710: return "SYRIAC_LETTER_ALAPH";
        case   0x0711: return "SYRIAC_LETTER_SUPERSCRIPT_ALAPH";
        case   0x0712: return "SYRIAC_LETTER_BETH";
        case   0x0713: return "SYRIAC_LETTER_GAMAL";
        case   0x0714: return "SYRIAC_LETTER_GAMAL_GARSHUNI";
        case   0x0715: return "SYRIAC_LETTER_DALATH";
        case   0x0716: return "SYRIAC_LETTER_DOTLESS_DALATH_RISH";
        case   0x0717: return "SYRIAC_LETTER_HE";
        case   0x0718: return "SYRIAC_LETTER_WAW";
        case   0x0719: return "SYRIAC_LETTER_ZAIN";
        case   0x071A: return "SYRIAC_LETTER_HETH";
        case   0x071B: return "SYRIAC_LETTER_TETH";
        case   0x071C: return "SYRIAC_LETTER_TETH_GARSHUNI";
        case   0x071D: return "SYRIAC_LETTER_YUDH";
        case   0x071E: return "SYRIAC_LETTER_YUDH_HE";
        case   0x071F: return "SYRIAC_LETTER_KAPH";
        case   0x0720: return "SYRIAC_LETTER_LAMADH";
        case   0x0721: return "SYRIAC_LETTER_MIM";
        case   0x0722: return "SYRIAC_LETTER_NUN";
        case   0x0723: return "SYRIAC_LETTER_SEMKATH";
        case   0x0724: return "SYRIAC_LETTER_FINAL_SEMKATH";
        case   0x0725: return "SYRIAC_LETTER_E";
        case   0x0726: return "SYRIAC_LETTER_PE";
        case   0x0727: return "SYRIAC_LETTER_REVERSED_PE";
        case   0x0728: return "SYRIAC_LETTER_SADHE";
        case   0x0729: return "SYRIAC_LETTER_QAPH";
        case   0x072A: return "SYRIAC_LETTER_RISH";
        case   0x072B: return "SYRIAC_LETTER_SHIN";
        case   0x072C: return "SYRIAC_LETTER_TAW";
        case   0x072D: return "SYRIAC_LETTER_PERSIAN_BHETH";
        case   0x072E: return "SYRIAC_LETTER_PERSIAN_GHAMAL";
        case   0x072F: return "SYRIAC_LETTER_PERSIAN_DHALATH";
        case   0x0730: return "SYRIAC_PTHAHA_ABOVE";
        case   0x0731: return "SYRIAC_PTHAHA_BELOW";
        case   0x0732: return "SYRIAC_PTHAHA_DOTTED";
        case   0x0733: return "SYRIAC_ZQAPHA_ABOVE";
        case   0x0734: return "SYRIAC_ZQAPHA_BELOW";
        case   0x0735: return "SYRIAC_ZQAPHA_DOTTED";
        case   0x0736: return "SYRIAC_RBASA_ABOVE";
        case   0x0737: return "SYRIAC_RBASA_BELOW";
        case   0x0738: return "SYRIAC_DOTTED_ZLAMA_HORIZONTAL";
        case   0x0739: return "SYRIAC_DOTTED_ZLAMA_ANGULAR";
        case   0x073A: return "SYRIAC_HBASA_ABOVE";
        case   0x073B: return "SYRIAC_HBASA_BELOW";
        case   0x073C: return "SYRIAC_HBASA_ESASA_DOTTED";
        case   0x073D: return "SYRIAC_ESASA_ABOVE";
        case   0x073E: return "SYRIAC_ESASA_BELOW";
        case   0x073F: return "SYRIAC_RWAHA";
        case   0x0740: return "SYRIAC_FEMININE_DOT";
        case   0x0741: return "SYRIAC_QUSHSHAYA";
        case   0x0742: return "SYRIAC_RUKKAKHA";
        case   0x0743: return "SYRIAC_TWO_VERTICAL_DOTS_ABOVE";
        case   0x0744: return "SYRIAC_TWO_VERTICAL_DOTS_BELOW";
        case   0x0745: return "SYRIAC_THREE_DOTS_ABOVE";
        case   0x0746: return "SYRIAC_THREE_DOTS_BELOW";
        case   0x0747: return "SYRIAC_OBLIQUE_LINE_ABOVE";
        case   0x0748: return "SYRIAC_OBLIQUE_LINE_BELOW";
        case   0x0749: return "SYRIAC_MUSIC";
        case   0x074A: return "SYRIAC_BARREKH";
        case   0x074D: return "SYRIAC_LETTER_SOGDIAN_ZHAIN";
        case   0x074E: return "SYRIAC_LETTER_SOGDIAN_KHAPH";
        case   0x074F: return "SYRIAC_LETTER_SOGDIAN_FE";
        case   0x0750: return
                "ARABIC_LETTER_BEH_WITH_THREE_DOTS_HORIZONTALLY_BELOW";
        case   0x0751: return
                "ARABIC_LETTER_BEH_WITH_DOT_BELOW_AND_THREE_DOTS_ABOVE";
        case   0x0752: return
                "ARABIC_LETTER_BEH_WITH_THREE_DOTS_POINTING_UPWARDS_BELOW";
        case   0x0753: return
                "ARABIC_LETTER_BEH_WITH_THREE_DOTS_POINTING_UPWARDS_BELOW_AND_TWO_DOTS_ABOVE";
        case   0x0754: return
                "ARABIC_LETTER_BEH_WITH_TWO_DOTS_BELOW_AND_DOT_ABOVE";
        case   0x0755: return "ARABIC_LETTER_BEH_WITH_INVERTED_SMALL_V_BELOW";
        case   0x0756: return "ARABIC_LETTER_BEH_WITH_SMALL_V";
        case   0x0757: return "ARABIC_LETTER_HAH_WITH_TWO_DOTS_ABOVE";
        case   0x0758: return
                "ARABIC_LETTER_HAH_WITH_THREE_DOTS_POINTING_UPWARDS_BELOW";
        case   0x0759: return
                "ARABIC_LETTER_DAL_WITH_TWO_DOTS_VERTICALLY_BELOW_AND_SMALL_TAH";
        case   0x075A: return "ARABIC_LETTER_DAL_WITH_INVERTED_SMALL_V_BELOW";
        case   0x075B: return "ARABIC_LETTER_REH_WITH_STROKE";
        case   0x075C: return "ARABIC_LETTER_SEEN_WITH_FOUR_DOTS_ABOVE";
        case   0x075D: return "ARABIC_LETTER_AIN_WITH_TWO_DOTS_ABOVE";
        case   0x075E: return
                "ARABIC_LETTER_AIN_WITH_THREE_DOTS_POINTING_DOWNWARDS_ABOVE";
        case   0x075F: return
                "ARABIC_LETTER_AIN_WITH_TWO_DOTS_VERTICALLY_ABOVE";
        case   0x0760: return "ARABIC_LETTER_FEH_WITH_TWO_DOTS_BELOW";
        case   0x0761: return
                "ARABIC_LETTER_FEH_WITH_THREE_DOTS_POINTING_UPWARDS_BELOW";
        case   0x0762: return "ARABIC_LETTER_KEHEH_WITH_DOT_ABOVE";
        case   0x0763: return "ARABIC_LETTER_KEHEH_WITH_THREE_DOTS_ABOVE";
        case   0x0764: return
                "ARABIC_LETTER_KEHEH_WITH_THREE_DOTS_POINTING_UPWARDS_BELOW";
        case   0x0765: return "ARABIC_LETTER_MEEM_WITH_DOT_ABOVE";
        case   0x0766: return "ARABIC_LETTER_MEEM_WITH_DOT_BELOW";
        case   0x0767: return "ARABIC_LETTER_NOON_WITH_TWO_DOTS_BELOW";
        case   0x0768: return "ARABIC_LETTER_NOON_WITH_SMALL_TAH";
        case   0x0769: return "ARABIC_LETTER_NOON_WITH_SMALL_V";
        case   0x076A: return "ARABIC_LETTER_LAM_WITH_BAR";
        case   0x076B: return
                "ARABIC_LETTER_REH_WITH_TWO_DOTS_VERTICALLY_ABOVE";
        case   0x076C: return "ARABIC_LETTER_REH_WITH_HAMZA_ABOVE";
        case   0x076D: return
                "ARABIC_LETTER_SEEN_WITH_TWO_DOTS_VERTICALLY_ABOVE";
        case   0x076E: return
                "ARABIC_LETTER_HAH_WITH_SMALL_ARABIC_LETTER_TAH_BELOW";
        case   0x076F: return
                "ARABIC_LETTER_HAH_WITH_SMALL_ARABIC_LETTER_TAH_AND_TWO_DOTS";
        case   0x0770: return
                "ARABIC_LETTER_SEEN_WITH_SMALL_ARABIC_LETTER_TAH_AND_TWO_DOTS";
        case   0x0771: return
                "ARABIC_LETTER_REH_WITH_SMALL_ARABIC_LETTER_TAH_AND_TWO_DOTS";
        case   0x0772: return
                "ARABIC_LETTER_HAH_WITH_SMALL_ARABIC_LETTER_TAH_ABOVE";
        case   0x0773: return
                "ARABIC_LETTER_ALEF_WITH_EXTENDED_ARABIC_INDIC_DIGIT_TWO_ABOVE";
        case   0x0774: return
                "ARABIC_LETTER_ALEF_WITH_EXTENDED_ARABIC_INDIC_DIGIT_THREE_ABOVE";
        case   0x0775: return
                "ARABIC_LETTER_FARSI_YEH_WITH_EXTENDED_ARABIC_INDIC_DIGIT_TWO_ABOVE";
        case   0x0776: return
                "ARABIC_LETTER_FARSI_YEH_WITH_EXTENDED_ARABIC_INDIC_DIGIT_THREE_ABOVE";
        case   0x0777: return
                "ARABIC_LETTER_FARSI_YEH_WITH_EXTENDED_ARABIC_INDIC_DIGIT_FOUR_BELOW";
        case   0x0778: return
                "ARABIC_LETTER_WAW_WITH_EXTENDED_ARABIC_INDIC_DIGIT_TWO_ABOVE";
        case   0x0779: return
                "ARABIC_LETTER_WAW_WITH_EXTENDED_ARABIC_INDIC_DIGIT_THREE_ABOVE";
        case   0x077A: return
                "ARABIC_LETTER_YEH_BARREE_WITH_EXTENDED_ARABIC_INDIC_DIGIT_TWO_ABOVE";
        case   0x077B: return
                "ARABIC_LETTER_YEH_BARREE_WITH_EXTENDED_ARABIC_INDIC_DIGIT_THREE_ABOVE";
        case   0x077C: return
                "ARABIC_LETTER_HAH_WITH_EXTENDED_ARABIC_INDIC_DIGIT_FOUR_BELOW";
        case   0x077D: return
                "ARABIC_LETTER_SEEN_WITH_EXTENDED_ARABIC_INDIC_DIGIT_FOUR_ABOVE";
        case   0x077E: return "ARABIC_LETTER_SEEN_WITH_INVERTED_V";
        case   0x077F: return "ARABIC_LETTER_KAF_WITH_TWO_DOTS_ABOVE";
        case   0x0780: return "THAANA_LETTER_HAA";
        case   0x0781: return "THAANA_LETTER_SHAVIYANI";
        case   0x0782: return "THAANA_LETTER_NOONU";
        case   0x0783: return "THAANA_LETTER_RAA";
        case   0x0784: return "THAANA_LETTER_BAA";
        case   0x0785: return "THAANA_LETTER_LHAVIYANI";
        case   0x0786: return "THAANA_LETTER_KAAFU";
        case   0x0787: return "THAANA_LETTER_ALIFU";
        case   0x0788: return "THAANA_LETTER_VAAVU";
        case   0x0789: return "THAANA_LETTER_MEEMU";
        case   0x078A: return "THAANA_LETTER_FAAFU";
        case   0x078B: return "THAANA_LETTER_DHAALU";
        case   0x078C: return "THAANA_LETTER_THAA";
        case   0x078D: return "THAANA_LETTER_LAAMU";
        case   0x078E: return "THAANA_LETTER_GAAFU";
        case   0x078F: return "THAANA_LETTER_GNAVIYANI";
        case   0x0790: return "THAANA_LETTER_SEENU";
        case   0x0791: return "THAANA_LETTER_DAVIYANI";
        case   0x0792: return "THAANA_LETTER_ZAVIYANI";
        case   0x0793: return "THAANA_LETTER_TAVIYANI";
        case   0x0794: return "THAANA_LETTER_YAA";
        case   0x0795: return "THAANA_LETTER_PAVIYANI";
        case   0x0796: return "THAANA_LETTER_JAVIYANI";
        case   0x0797: return "THAANA_LETTER_CHAVIYANI";
        case   0x0798: return "THAANA_LETTER_TTAA";
        case   0x0799: return "THAANA_LETTER_HHAA";
        case   0x079A: return "THAANA_LETTER_KHAA";
        case   0x079B: return "THAANA_LETTER_THAALU";
        case   0x079C: return "THAANA_LETTER_ZAA";
        case   0x079D: return "THAANA_LETTER_SHEENU";
        case   0x079E: return "THAANA_LETTER_SAADHU";
        case   0x079F: return "THAANA_LETTER_DAADHU";
        case   0x07A0: return "THAANA_LETTER_TO";
        case   0x07A1: return "THAANA_LETTER_ZO";
        case   0x07A2: return "THAANA_LETTER_AINU";
        case   0x07A3: return "THAANA_LETTER_GHAINU";
        case   0x07A4: return "THAANA_LETTER_QAAFU";
        case   0x07A5: return "THAANA_LETTER_WAAVU";
        case   0x07A6: return "THAANA_ABAFILI";
        case   0x07A7: return "THAANA_AABAAFILI";
        case   0x07A8: return "THAANA_IBIFILI";
        case   0x07A9: return "THAANA_EEBEEFILI";
        case   0x07AA: return "THAANA_UBUFILI";
        case   0x07AB: return "THAANA_OOBOOFILI";
        case   0x07AC: return "THAANA_EBEFILI";
        case   0x07AD: return "THAANA_EYBEYFILI";
        case   0x07AE: return "THAANA_OBOFILI";
        case   0x07AF: return "THAANA_OABOAFILI";
        case   0x07B0: return "THAANA_SUKUN";
        case   0x07B1: return "THAANA_LETTER_NAA";
        case   0x07C0: return "NKO_DIGIT_ZERO";
        case   0x07C1: return "NKO_DIGIT_ONE";
        case   0x07C2: return "NKO_DIGIT_TWO";
        case   0x07C3: return "NKO_DIGIT_THREE";
        case   0x07C4: return "NKO_DIGIT_FOUR";
        case   0x07C5: return "NKO_DIGIT_FIVE";
        case   0x07C6: return "NKO_DIGIT_SIX";
        case   0x07C7: return "NKO_DIGIT_SEVEN";
        case   0x07C8: return "NKO_DIGIT_EIGHT";
        case   0x07C9: return "NKO_DIGIT_NINE";
        case   0x07CA: return "NKO_LETTER_A";
        case   0x07CB: return "NKO_LETTER_EE";
        case   0x07CC: return "NKO_LETTER_I";
        case   0x07CD: return "NKO_LETTER_E";
        case   0x07CE: return "NKO_LETTER_U";
        case   0x07CF: return "NKO_LETTER_OO";
        case   0x07D0: return "NKO_LETTER_O";
        case   0x07D1: return "NKO_LETTER_DAGBASINNA";
        case   0x07D2: return "NKO_LETTER_N";
        case   0x07D3: return "NKO_LETTER_BA";
        case   0x07D4: return "NKO_LETTER_PA";
        case   0x07D5: return "NKO_LETTER_TA";
        case   0x07D6: return "NKO_LETTER_JA";
        case   0x07D7: return "NKO_LETTER_CHA";
        case   0x07D8: return "NKO_LETTER_DA";
        case   0x07D9: return "NKO_LETTER_RA";
        case   0x07DA: return "NKO_LETTER_RRA";
        case   0x07DB: return "NKO_LETTER_SA";
        case   0x07DC: return "NKO_LETTER_GBA";
        case   0x07DD: return "NKO_LETTER_FA";
        case   0x07DE: return "NKO_LETTER_KA";
        case   0x07DF: return "NKO_LETTER_LA";
        case   0x07E0: return "NKO_LETTER_NA_WOLOSO";
        case   0x07E1: return "NKO_LETTER_MA";
        case   0x07E2: return "NKO_LETTER_NYA";
        case   0x07E3: return "NKO_LETTER_NA";
        case   0x07E4: return "NKO_LETTER_HA";
        case   0x07E5: return "NKO_LETTER_WA";
        case   0x07E6: return "NKO_LETTER_YA";
        case   0x07E7: return "NKO_LETTER_NYA_WOLOSO";
        case   0x07E8: return "NKO_LETTER_JONA_JA";
        case   0x07E9: return "NKO_LETTER_JONA_CHA";
        case   0x07EA: return "NKO_LETTER_JONA_RA";
        case   0x07EB: return "NKO_COMBINING_SHORT_HIGH_TONE";
        case   0x07EC: return "NKO_COMBINING_SHORT_LOW_TONE";
        case   0x07ED: return "NKO_COMBINING_SHORT_RISING_TONE";
        case   0x07EE: return "NKO_COMBINING_LONG_DESCENDING_TONE";
        case   0x07EF: return "NKO_COMBINING_LONG_HIGH_TONE";
        case   0x07F0: return "NKO_COMBINING_LONG_LOW_TONE";
        case   0x07F1: return "NKO_COMBINING_LONG_RISING_TONE";
        case   0x07F2: return "NKO_COMBINING_NASALIZATION_MARK";
        case   0x07F3: return "NKO_COMBINING_DOUBLE_DOT_ABOVE";
        case   0x07F4: return "NKO_HIGH_TONE_APOSTROPHE";
        case   0x07F5: return "NKO_LOW_TONE_APOSTROPHE";
        case   0x07F6: return "NKO_SYMBOL_OO_DENNEN";
        case   0x07F7: return "NKO_SYMBOL_GBAKURUNEN";
        case   0x07F8: return "NKO_COMMA";
        case   0x07F9: return "NKO_EXCLAMATION_MARK";
        case   0x07FA: return "NKO_LAJANYALAN";
        case   0x0800: return "SAMARITAN_LETTER_ALAF";
        case   0x0801: return "SAMARITAN_LETTER_BIT";
        case   0x0802: return "SAMARITAN_LETTER_GAMAN";
        case   0x0803: return "SAMARITAN_LETTER_DALAT";
        case   0x0804: return "SAMARITAN_LETTER_IY";
        case   0x0805: return "SAMARITAN_LETTER_BAA";
        case   0x0806: return "SAMARITAN_LETTER_ZEN";
        case   0x0807: return "SAMARITAN_LETTER_IT";
        case   0x0808: return "SAMARITAN_LETTER_TIT";
        case   0x0809: return "SAMARITAN_LETTER_YUT";
        case   0x080A: return "SAMARITAN_LETTER_KAAF";
        case   0x080B: return "SAMARITAN_LETTER_LABAT";
        case   0x080C: return "SAMARITAN_LETTER_MIM";
        case   0x080D: return "SAMARITAN_LETTER_NUN";
        case   0x080E: return "SAMARITAN_LETTER_SINGAAT";
        case   0x080F: return "SAMARITAN_LETTER_IN";
        case   0x0810: return "SAMARITAN_LETTER_FI";
        case   0x0811: return "SAMARITAN_LETTER_TSAADIY";
        case   0x0812: return "SAMARITAN_LETTER_QUF";
        case   0x0813: return "SAMARITAN_LETTER_RISH";
        case   0x0814: return "SAMARITAN_LETTER_SHAN";
        case   0x0815: return "SAMARITAN_LETTER_TAAF";
        case   0x0816: return "SAMARITAN_MARK_IN";
        case   0x0817: return "SAMARITAN_MARK_IN_ALAF";
        case   0x0818: return "SAMARITAN_MARK_OCCLUSION";
        case   0x0819: return "SAMARITAN_MARK_DAGESH";
        case   0x081A: return "SAMARITAN_MODIFIER_LETTER_EPENTHETIC_YUT";
        case   0x081B: return "SAMARITAN_MARK_EPENTHETIC_YUT";
        case   0x081C: return "SAMARITAN_VOWEL_SIGN_LONG_E";
        case   0x081D: return "SAMARITAN_VOWEL_SIGN_E";
        case   0x081E: return "SAMARITAN_VOWEL_SIGN_OVERLONG_AA";
        case   0x081F: return "SAMARITAN_VOWEL_SIGN_LONG_AA";
        case   0x0820: return "SAMARITAN_VOWEL_SIGN_AA";
        case   0x0821: return "SAMARITAN_VOWEL_SIGN_OVERLONG_A";
        case   0x0822: return "SAMARITAN_VOWEL_SIGN_LONG_A";
        case   0x0823: return "SAMARITAN_VOWEL_SIGN_A";
        case   0x0824: return "SAMARITAN_MODIFIER_LETTER_SHORT_A";
        case   0x0825: return "SAMARITAN_VOWEL_SIGN_SHORT_A";
        case   0x0826: return "SAMARITAN_VOWEL_SIGN_LONG_U";
        case   0x0827: return "SAMARITAN_VOWEL_SIGN_U";
        case   0x0828: return "SAMARITAN_MODIFIER_LETTER_I";
        case   0x0829: return "SAMARITAN_VOWEL_SIGN_LONG_I";
        case   0x082A: return "SAMARITAN_VOWEL_SIGN_I";
        case   0x082B: return "SAMARITAN_VOWEL_SIGN_O";
        case   0x082C: return "SAMARITAN_VOWEL_SIGN_SUKUN";
        case   0x082D: return "SAMARITAN_MARK_NEQUDAA";
        case   0x0830: return "SAMARITAN_PUNCTUATION_NEQUDAA";
        case   0x0831: return "SAMARITAN_PUNCTUATION_AFSAAQ";
        case   0x0832: return "SAMARITAN_PUNCTUATION_ANGED";
        case   0x0833: return "SAMARITAN_PUNCTUATION_BAU";
        case   0x0834: return "SAMARITAN_PUNCTUATION_ATMAAU";
        case   0x0835: return "SAMARITAN_PUNCTUATION_SHIYYAALAA";
        case   0x0836: return "SAMARITAN_ABBREVIATION_MARK";
        case   0x0837: return "SAMARITAN_PUNCTUATION_MELODIC_QITSA";
        case   0x0838: return "SAMARITAN_PUNCTUATION_ZIQAA";
        case   0x0839: return "SAMARITAN_PUNCTUATION_QITSA";
        case   0x083A: return "SAMARITAN_PUNCTUATION_ZAEF";
        case   0x083B: return "SAMARITAN_PUNCTUATION_TURU";
        case   0x083C: return "SAMARITAN_PUNCTUATION_ARKAANU";
        case   0x083D: return "SAMARITAN_PUNCTUATION_SOF_MASHFAAT";
        case   0x083E: return "SAMARITAN_PUNCTUATION_ANNAAU";
        case   0x0840: return "MANDAIC_LETTER_HALQA";
        case   0x0841: return "MANDAIC_LETTER_AB";
        case   0x0842: return "MANDAIC_LETTER_AG";
        case   0x0843: return "MANDAIC_LETTER_AD";
        case   0x0844: return "MANDAIC_LETTER_AH";
        case   0x0845: return "MANDAIC_LETTER_USHENNA";
        case   0x0846: return "MANDAIC_LETTER_AZ";
        case   0x0847: return "MANDAIC_LETTER_IT";
        case   0x0848: return "MANDAIC_LETTER_ATT";
        case   0x0849: return "MANDAIC_LETTER_AKSA";
        case   0x084A: return "MANDAIC_LETTER_AK";
        case   0x084B: return "MANDAIC_LETTER_AL";
        case   0x084C: return "MANDAIC_LETTER_AM";
        case   0x084D: return "MANDAIC_LETTER_AN";
        case   0x084E: return "MANDAIC_LETTER_AS";
        case   0x084F: return "MANDAIC_LETTER_IN";
        case   0x0850: return "MANDAIC_LETTER_AP";
        case   0x0851: return "MANDAIC_LETTER_ASZ";
        case   0x0852: return "MANDAIC_LETTER_AQ";
        case   0x0853: return "MANDAIC_LETTER_AR";
        case   0x0854: return "MANDAIC_LETTER_ASH";
        case   0x0855: return "MANDAIC_LETTER_AT";
        case   0x0856: return "MANDAIC_LETTER_DUSHENNA";
        case   0x0857: return "MANDAIC_LETTER_KAD";
        case   0x0858: return "MANDAIC_LETTER_AIN";
        case   0x0859: return "MANDAIC_AFFRICATION_MARK";
        case   0x085A: return "MANDAIC_VOCALIZATION_MARK";
        case   0x085B: return "MANDAIC_GEMINATION_MARK";
        case   0x085E: return "MANDAIC_PUNCTUATION";
        case   0x08A0: return "ARABIC_LETTER_BEH_WITH_SMALL_V_BELOW";
        case   0x08A1: return "ARABIC_LETTER_BEH_WITH_HAMZA_ABOVE";
        case   0x08A2: return "ARABIC_LETTER_JEEM_WITH_TWO_DOTS_ABOVE";
        case   0x08A3: return "ARABIC_LETTER_TAH_WITH_TWO_DOTS_ABOVE";
        case   0x08A4: return
                "ARABIC_LETTER_FEH_WITH_DOT_BELOW_AND_THREE_DOTS_ABOVE";
        case   0x08A5: return "ARABIC_LETTER_QAF_WITH_DOT_BELOW";
        case   0x08A6: return "ARABIC_LETTER_LAM_WITH_DOUBLE_BAR";
        case   0x08A7: return "ARABIC_LETTER_MEEM_WITH_THREE_DOTS_ABOVE";
        case   0x08A8: return
                "ARABIC_LETTER_YEH_WITH_TWO_DOTS_BELOW_AND_HAMZA_ABOVE";
        case   0x08A9: return
                "ARABIC_LETTER_YEH_WITH_TWO_DOTS_BELOW_AND_DOT_ABOVE";
        case   0x08AA: return "ARABIC_LETTER_REH_WITH_LOOP";
        case   0x08AB: return "ARABIC_LETTER_WAW_WITH_DOT_WITHIN";
        case   0x08AC: return "ARABIC_LETTER_ROHINGYA_YEH";
        case   0x08AD: return "ARABIC_LETTER_LOW_ALEF";
        case   0x08AE: return "ARABIC_LETTER_DAL_WITH_THREE_DOTS_BELOW";
        case   0x08AF: return "ARABIC_LETTER_SAD_WITH_THREE_DOTS_BELOW";
        case   0x08B0: return "ARABIC_LETTER_GAF_WITH_INVERTED_STROKE";
        case   0x08B1: return "ARABIC_LETTER_STRAIGHT_WAW";
        case   0x08B2: return "ARABIC_LETTER_ZAIN_WITH_INVERTED_V_ABOVE";
        case   0x08E4: return "ARABIC_CURLY_FATHA";
        case   0x08E5: return "ARABIC_CURLY_DAMMA";
        case   0x08E6: return "ARABIC_CURLY_KASRA";
        case   0x08E7: return "ARABIC_CURLY_FATHATAN";
        case   0x08E8: return "ARABIC_CURLY_DAMMATAN";
        case   0x08E9: return "ARABIC_CURLY_KASRATAN";
        case   0x08EA: return "ARABIC_TONE_ONE_DOT_ABOVE";
        case   0x08EB: return "ARABIC_TONE_TWO_DOTS_ABOVE";
        case   0x08EC: return "ARABIC_TONE_LOOP_ABOVE";
        case   0x08ED: return "ARABIC_TONE_ONE_DOT_BELOW";
        case   0x08EE: return "ARABIC_TONE_TWO_DOTS_BELOW";
        case   0x08EF: return "ARABIC_TONE_LOOP_BELOW";
        case   0x08F0: return "ARABIC_OPEN_FATHATAN";
        case   0x08F1: return "ARABIC_OPEN_DAMMATAN";
        case   0x08F2: return "ARABIC_OPEN_KASRATAN";
        case   0x08F3: return "ARABIC_SMALL_HIGH_WAW";
        case   0x08F4: return "ARABIC_FATHA_WITH_RING";
        case   0x08F5: return "ARABIC_FATHA_WITH_DOT_ABOVE";
        case   0x08F6: return "ARABIC_KASRA_WITH_DOT_BELOW";
        case   0x08F7: return "ARABIC_LEFT_ARROWHEAD_ABOVE";
        case   0x08F8: return "ARABIC_RIGHT_ARROWHEAD_ABOVE";
        case   0x08F9: return "ARABIC_LEFT_ARROWHEAD_BELOW";
        case   0x08FA: return "ARABIC_RIGHT_ARROWHEAD_BELOW";
        case   0x08FB: return "ARABIC_DOUBLE_RIGHT_ARROWHEAD_ABOVE";
        case   0x08FC: return "ARABIC_DOUBLE_RIGHT_ARROWHEAD_ABOVE_WITH_DOT";
        case   0x08FD: return "ARABIC_RIGHT_ARROWHEAD_ABOVE_WITH_DOT";
        case   0x08FE: return "ARABIC_DAMMA_WITH_DOT";
        case   0x08FF: return "ARABIC_MARK_SIDEWAYS_NOON_GHUNNA";
        case   0x0900: return "DEVANAGARI_SIGN_INVERTED_CANDRABINDU";
        case   0x0901: return "DEVANAGARI_SIGN_CANDRABINDU";
        case   0x0902: return "DEVANAGARI_SIGN_ANUSVARA";
        case   0x0903: return "DEVANAGARI_SIGN_VISARGA";
        case   0x0904: return "DEVANAGARI_LETTER_SHORT_A";
        case   0x0905: return "DEVANAGARI_LETTER_A";
        case   0x0906: return "DEVANAGARI_LETTER_AA";
        case   0x0907: return "DEVANAGARI_LETTER_I";
        case   0x0908: return "DEVANAGARI_LETTER_II";
        case   0x0909: return "DEVANAGARI_LETTER_U";
        case   0x090A: return "DEVANAGARI_LETTER_UU";
        case   0x090B: return "DEVANAGARI_LETTER_VOCALIC_R";
        case   0x090C: return "DEVANAGARI_LETTER_VOCALIC_L";
        case   0x090D: return "DEVANAGARI_LETTER_CANDRA_E";
        case   0x090E: return "DEVANAGARI_LETTER_SHORT_E";
        case   0x090F: return "DEVANAGARI_LETTER_E";
        case   0x0910: return "DEVANAGARI_LETTER_AI";
        case   0x0911: return "DEVANAGARI_LETTER_CANDRA_O";
        case   0x0912: return "DEVANAGARI_LETTER_SHORT_O";
        case   0x0913: return "DEVANAGARI_LETTER_O";
        case   0x0914: return "DEVANAGARI_LETTER_AU";
        case   0x0915: return "DEVANAGARI_LETTER_KA";
        case   0x0916: return "DEVANAGARI_LETTER_KHA";
        case   0x0917: return "DEVANAGARI_LETTER_GA";
        case   0x0918: return "DEVANAGARI_LETTER_GHA";
        case   0x0919: return "DEVANAGARI_LETTER_NGA";
        case   0x091A: return "DEVANAGARI_LETTER_CA";
        case   0x091B: return "DEVANAGARI_LETTER_CHA";
        case   0x091C: return "DEVANAGARI_LETTER_JA";
        case   0x091D: return "DEVANAGARI_LETTER_JHA";
        case   0x091E: return "DEVANAGARI_LETTER_NYA";
        case   0x091F: return "DEVANAGARI_LETTER_TTA";
        case   0x0920: return "DEVANAGARI_LETTER_TTHA";
        case   0x0921: return "DEVANAGARI_LETTER_DDA";
        case   0x0922: return "DEVANAGARI_LETTER_DDHA";
        case   0x0923: return "DEVANAGARI_LETTER_NNA";
        case   0x0924: return "DEVANAGARI_LETTER_TA";
        case   0x0925: return "DEVANAGARI_LETTER_THA";
        case   0x0926: return "DEVANAGARI_LETTER_DA";
        case   0x0927: return "DEVANAGARI_LETTER_DHA";
        case   0x0928: return "DEVANAGARI_LETTER_NA";
        case   0x0929: return "DEVANAGARI_LETTER_NNNA";
        case   0x092A: return "DEVANAGARI_LETTER_PA";
        case   0x092B: return "DEVANAGARI_LETTER_PHA";
        case   0x092C: return "DEVANAGARI_LETTER_BA";
        case   0x092D: return "DEVANAGARI_LETTER_BHA";
        case   0x092E: return "DEVANAGARI_LETTER_MA";
        case   0x092F: return "DEVANAGARI_LETTER_YA";
        case   0x0930: return "DEVANAGARI_LETTER_RA";
        case   0x0931: return "DEVANAGARI_LETTER_RRA";
        case   0x0932: return "DEVANAGARI_LETTER_LA";
        case   0x0933: return "DEVANAGARI_LETTER_LLA";
        case   0x0934: return "DEVANAGARI_LETTER_LLLA";
        case   0x0935: return "DEVANAGARI_LETTER_VA";
        case   0x0936: return "DEVANAGARI_LETTER_SHA";
        case   0x0937: return "DEVANAGARI_LETTER_SSA";
        case   0x0938: return "DEVANAGARI_LETTER_SA";
        case   0x0939: return "DEVANAGARI_LETTER_HA";
        case   0x093A: return "DEVANAGARI_VOWEL_SIGN_OE";
        case   0x093B: return "DEVANAGARI_VOWEL_SIGN_OOE";
        case   0x093C: return "DEVANAGARI_SIGN_NUKTA";
        case   0x093D: return "DEVANAGARI_SIGN_AVAGRAHA";
        case   0x093E: return "DEVANAGARI_VOWEL_SIGN_AA";
        case   0x093F: return "DEVANAGARI_VOWEL_SIGN_I";
        case   0x0940: return "DEVANAGARI_VOWEL_SIGN_II";
        case   0x0941: return "DEVANAGARI_VOWEL_SIGN_U";
        case   0x0942: return "DEVANAGARI_VOWEL_SIGN_UU";
        case   0x0943: return "DEVANAGARI_VOWEL_SIGN_VOCALIC_R";
        case   0x0944: return "DEVANAGARI_VOWEL_SIGN_VOCALIC_RR";
        case   0x0945: return "DEVANAGARI_VOWEL_SIGN_CANDRA_E";
        case   0x0946: return "DEVANAGARI_VOWEL_SIGN_SHORT_E";
        case   0x0947: return "DEVANAGARI_VOWEL_SIGN_E";
        case   0x0948: return "DEVANAGARI_VOWEL_SIGN_AI";
        case   0x0949: return "DEVANAGARI_VOWEL_SIGN_CANDRA_O";
        case   0x094A: return "DEVANAGARI_VOWEL_SIGN_SHORT_O";
        case   0x094B: return "DEVANAGARI_VOWEL_SIGN_O";
        case   0x094C: return "DEVANAGARI_VOWEL_SIGN_AU";
        case   0x094D: return "DEVANAGARI_SIGN_VIRAMA";
        case   0x094E: return "DEVANAGARI_VOWEL_SIGN_PRISHTHAMATRA_E";
        case   0x094F: return "DEVANAGARI_VOWEL_SIGN_AW";
        case   0x0950: return "DEVANAGARI_OM";
        case   0x0951: return "DEVANAGARI_STRESS_SIGN_UDATTA";
        case   0x0952: return "DEVANAGARI_STRESS_SIGN_ANUDATTA";
        case   0x0953: return "DEVANAGARI_GRAVE_ACCENT";
        case   0x0954: return "DEVANAGARI_ACUTE_ACCENT";
        case   0x0955: return "DEVANAGARI_VOWEL_SIGN_CANDRA_LONG_E";
        case   0x0956: return "DEVANAGARI_VOWEL_SIGN_UE";
        case   0x0957: return "DEVANAGARI_VOWEL_SIGN_UUE";
        case   0x0958: return "DEVANAGARI_LETTER_QA";
        case   0x0959: return "DEVANAGARI_LETTER_KHHA";
        case   0x095A: return "DEVANAGARI_LETTER_GHHA";
        case   0x095B: return "DEVANAGARI_LETTER_ZA";
        case   0x095C: return "DEVANAGARI_LETTER_DDDHA";
        case   0x095D: return "DEVANAGARI_LETTER_RHA";
        case   0x095E: return "DEVANAGARI_LETTER_FA";
        case   0x095F: return "DEVANAGARI_LETTER_YYA";
        case   0x0960: return "DEVANAGARI_LETTER_VOCALIC_RR";
        case   0x0961: return "DEVANAGARI_LETTER_VOCALIC_LL";
        case   0x0962: return "DEVANAGARI_VOWEL_SIGN_VOCALIC_L";
        case   0x0963: return "DEVANAGARI_VOWEL_SIGN_VOCALIC_LL";
        case   0x0964: return "DEVANAGARI_DANDA";
        case   0x0965: return "DEVANAGARI_DOUBLE_DANDA";
        case   0x0966: return "DEVANAGARI_DIGIT_ZERO";
        case   0x0967: return "DEVANAGARI_DIGIT_ONE";
        case   0x0968: return "DEVANAGARI_DIGIT_TWO";
        case   0x0969: return "DEVANAGARI_DIGIT_THREE";
        case   0x096A: return "DEVANAGARI_DIGIT_FOUR";
        case   0x096B: return "DEVANAGARI_DIGIT_FIVE";
        case   0x096C: return "DEVANAGARI_DIGIT_SIX";
        case   0x096D: return "DEVANAGARI_DIGIT_SEVEN";
        case   0x096E: return "DEVANAGARI_DIGIT_EIGHT";
        case   0x096F: return "DEVANAGARI_DIGIT_NINE";
        case   0x0970: return "DEVANAGARI_ABBREVIATION_SIGN";
        case   0x0971: return "DEVANAGARI_SIGN_HIGH_SPACING_DOT";
        case   0x0972: return "DEVANAGARI_LETTER_CANDRA_A";
        case   0x0973: return "DEVANAGARI_LETTER_OE";
        case   0x0974: return "DEVANAGARI_LETTER_OOE";
        case   0x0975: return "DEVANAGARI_LETTER_AW";
        case   0x0976: return "DEVANAGARI_LETTER_UE";
        case   0x0977: return "DEVANAGARI_LETTER_UUE";
        case   0x0978: return "DEVANAGARI_LETTER_MARWARI_DDA";
        case   0x0979: return "DEVANAGARI_LETTER_ZHA";
        case   0x097A: return "DEVANAGARI_LETTER_HEAVY_YA";
        case   0x097B: return "DEVANAGARI_LETTER_GGA";
        case   0x097C: return "DEVANAGARI_LETTER_JJA";
        case   0x097D: return "DEVANAGARI_LETTER_GLOTTAL_STOP";
        case   0x097E: return "DEVANAGARI_LETTER_DDDA";
        case   0x097F: return "DEVANAGARI_LETTER_BBA";
        case   0x0980: return "BENGALI_ANJI";
        case   0x0981: return "BENGALI_SIGN_CANDRABINDU";
        case   0x0982: return "BENGALI_SIGN_ANUSVARA";
        case   0x0983: return "BENGALI_SIGN_VISARGA";
        case   0x0985: return "BENGALI_LETTER_A";
        case   0x0986: return "BENGALI_LETTER_AA";
        case   0x0987: return "BENGALI_LETTER_I";
        case   0x0988: return "BENGALI_LETTER_II";
        case   0x0989: return "BENGALI_LETTER_U";
        case   0x098A: return "BENGALI_LETTER_UU";
        case   0x098B: return "BENGALI_LETTER_VOCALIC_R";
        case   0x098C: return "BENGALI_LETTER_VOCALIC_L";
        case   0x098F: return "BENGALI_LETTER_E";
        case   0x0990: return "BENGALI_LETTER_AI";
        case   0x0993: return "BENGALI_LETTER_O";
        case   0x0994: return "BENGALI_LETTER_AU";
        case   0x0995: return "BENGALI_LETTER_KA";
        case   0x0996: return "BENGALI_LETTER_KHA";
        case   0x0997: return "BENGALI_LETTER_GA";
        case   0x0998: return "BENGALI_LETTER_GHA";
        case   0x0999: return "BENGALI_LETTER_NGA";
        case   0x099A: return "BENGALI_LETTER_CA";
        case   0x099B: return "BENGALI_LETTER_CHA";
        case   0x099C: return "BENGALI_LETTER_JA";
        case   0x099D: return "BENGALI_LETTER_JHA";
        case   0x099E: return "BENGALI_LETTER_NYA";
        case   0x099F: return "BENGALI_LETTER_TTA";
        case   0x09A0: return "BENGALI_LETTER_TTHA";
        case   0x09A1: return "BENGALI_LETTER_DDA";
        case   0x09A2: return "BENGALI_LETTER_DDHA";
        case   0x09A3: return "BENGALI_LETTER_NNA";
        case   0x09A4: return "BENGALI_LETTER_TA";
        case   0x09A5: return "BENGALI_LETTER_THA";
        case   0x09A6: return "BENGALI_LETTER_DA";
        case   0x09A7: return "BENGALI_LETTER_DHA";
        case   0x09A8: return "BENGALI_LETTER_NA";
        case   0x09AA: return "BENGALI_LETTER_PA";
        case   0x09AB: return "BENGALI_LETTER_PHA";
        case   0x09AC: return "BENGALI_LETTER_BA";
        case   0x09AD: return "BENGALI_LETTER_BHA";
        case   0x09AE: return "BENGALI_LETTER_MA";
        case   0x09AF: return "BENGALI_LETTER_YA";
        case   0x09B0: return "BENGALI_LETTER_RA";
        case   0x09B2: return "BENGALI_LETTER_LA";
        case   0x09B6: return "BENGALI_LETTER_SHA";
        case   0x09B7: return "BENGALI_LETTER_SSA";
        case   0x09B8: return "BENGALI_LETTER_SA";
        case   0x09B9: return "BENGALI_LETTER_HA";
        case   0x09BC: return "BENGALI_SIGN_NUKTA";
        case   0x09BD: return "BENGALI_SIGN_AVAGRAHA";
        case   0x09BE: return "BENGALI_VOWEL_SIGN_AA";
        case   0x09BF: return "BENGALI_VOWEL_SIGN_I";
        case   0x09C0: return "BENGALI_VOWEL_SIGN_II";
        case   0x09C1: return "BENGALI_VOWEL_SIGN_U";
        case   0x09C2: return "BENGALI_VOWEL_SIGN_UU";
        case   0x09C3: return "BENGALI_VOWEL_SIGN_VOCALIC_R";
        case   0x09C4: return "BENGALI_VOWEL_SIGN_VOCALIC_RR";
        case   0x09C7: return "BENGALI_VOWEL_SIGN_E";
        case   0x09C8: return "BENGALI_VOWEL_SIGN_AI";
        case   0x09CB: return "BENGALI_VOWEL_SIGN_O";
        case   0x09CC: return "BENGALI_VOWEL_SIGN_AU";
        case   0x09CD: return "BENGALI_SIGN_VIRAMA";
        case   0x09CE: return "BENGALI_LETTER_KHANDA_TA";
        case   0x09D7: return "BENGALI_AU_LENGTH_MARK";
        case   0x09DC: return "BENGALI_LETTER_RRA";
        case   0x09DD: return "BENGALI_LETTER_RHA";
        case   0x09DF: return "BENGALI_LETTER_YYA";
        case   0x09E0: return "BENGALI_LETTER_VOCALIC_RR";
        case   0x09E1: return "BENGALI_LETTER_VOCALIC_LL";
        case   0x09E2: return "BENGALI_VOWEL_SIGN_VOCALIC_L";
        case   0x09E3: return "BENGALI_VOWEL_SIGN_VOCALIC_LL";
        case   0x09E6: return "BENGALI_DIGIT_ZERO";
        case   0x09E7: return "BENGALI_DIGIT_ONE";
        case   0x09E8: return "BENGALI_DIGIT_TWO";
        case   0x09E9: return "BENGALI_DIGIT_THREE";
        case   0x09EA: return "BENGALI_DIGIT_FOUR";
        case   0x09EB: return "BENGALI_DIGIT_FIVE";
        case   0x09EC: return "BENGALI_DIGIT_SIX";
        case   0x09ED: return "BENGALI_DIGIT_SEVEN";
        case   0x09EE: return "BENGALI_DIGIT_EIGHT";
        case   0x09EF: return "BENGALI_DIGIT_NINE";
        case   0x09F0: return "BENGALI_LETTER_RA_WITH_MIDDLE_DIAGONAL";
        case   0x09F1: return "BENGALI_LETTER_RA_WITH_LOWER_DIAGONAL";
        case   0x09F2: return "BENGALI_RUPEE_MARK";
        case   0x09F3: return "BENGALI_RUPEE_SIGN";
        case   0x09F4: return "BENGALI_CURRENCY_NUMERATOR_ONE";
        case   0x09F5: return "BENGALI_CURRENCY_NUMERATOR_TWO";
        case   0x09F6: return "BENGALI_CURRENCY_NUMERATOR_THREE";
        case   0x09F7: return "BENGALI_CURRENCY_NUMERATOR_FOUR";
        case   0x09F8: return
                "BENGALI_CURRENCY_NUMERATOR_ONE_LESS_THAN_THE_DENOMINATOR";
        case   0x09F9: return "BENGALI_CURRENCY_DENOMINATOR_SIXTEEN";
        case   0x09FA: return "BENGALI_ISSHAR";
        case   0x09FB: return "BENGALI_GANDA_MARK";
        case   0x0A01: return "GURMUKHI_SIGN_ADAK_BINDI";
        case   0x0A02: return "GURMUKHI_SIGN_BINDI";
        case   0x0A03: return "GURMUKHI_SIGN_VISARGA";
        case   0x0A05: return "GURMUKHI_LETTER_A";
        case   0x0A06: return "GURMUKHI_LETTER_AA";
        case   0x0A07: return "GURMUKHI_LETTER_I";
        case   0x0A08: return "GURMUKHI_LETTER_II";
        case   0x0A09: return "GURMUKHI_LETTER_U";
        case   0x0A0A: return "GURMUKHI_LETTER_UU";
        case   0x0A0F: return "GURMUKHI_LETTER_EE";
        case   0x0A10: return "GURMUKHI_LETTER_AI";
        case   0x0A13: return "GURMUKHI_LETTER_OO";
        case   0x0A14: return "GURMUKHI_LETTER_AU";
        case   0x0A15: return "GURMUKHI_LETTER_KA";
        case   0x0A16: return "GURMUKHI_LETTER_KHA";
        case   0x0A17: return "GURMUKHI_LETTER_GA";
        case   0x0A18: return "GURMUKHI_LETTER_GHA";
        case   0x0A19: return "GURMUKHI_LETTER_NGA";
        case   0x0A1A: return "GURMUKHI_LETTER_CA";
        case   0x0A1B: return "GURMUKHI_LETTER_CHA";
        case   0x0A1C: return "GURMUKHI_LETTER_JA";
        case   0x0A1D: return "GURMUKHI_LETTER_JHA";
        case   0x0A1E: return "GURMUKHI_LETTER_NYA";
        case   0x0A1F: return "GURMUKHI_LETTER_TTA";
        case   0x0A20: return "GURMUKHI_LETTER_TTHA";
        case   0x0A21: return "GURMUKHI_LETTER_DDA";
        case   0x0A22: return "GURMUKHI_LETTER_DDHA";
        case   0x0A23: return "GURMUKHI_LETTER_NNA";
        case   0x0A24: return "GURMUKHI_LETTER_TA";
        case   0x0A25: return "GURMUKHI_LETTER_THA";
        case   0x0A26: return "GURMUKHI_LETTER_DA";
        case   0x0A27: return "GURMUKHI_LETTER_DHA";
        case   0x0A28: return "GURMUKHI_LETTER_NA";
        case   0x0A2A: return "GURMUKHI_LETTER_PA";
        case   0x0A2B: return "GURMUKHI_LETTER_PHA";
        case   0x0A2C: return "GURMUKHI_LETTER_BA";
        case   0x0A2D: return "GURMUKHI_LETTER_BHA";
        case   0x0A2E: return "GURMUKHI_LETTER_MA";
        case   0x0A2F: return "GURMUKHI_LETTER_YA";
        case   0x0A30: return "GURMUKHI_LETTER_RA";
        case   0x0A32: return "GURMUKHI_LETTER_LA";
        case   0x0A33: return "GURMUKHI_LETTER_LLA";
        case   0x0A35: return "GURMUKHI_LETTER_VA";
        case   0x0A36: return "GURMUKHI_LETTER_SHA";
        case   0x0A38: return "GURMUKHI_LETTER_SA";
        case   0x0A39: return "GURMUKHI_LETTER_HA";
        case   0x0A3C: return "GURMUKHI_SIGN_NUKTA";
        case   0x0A3E: return "GURMUKHI_VOWEL_SIGN_AA";
        case   0x0A3F: return "GURMUKHI_VOWEL_SIGN_I";
        case   0x0A40: return "GURMUKHI_VOWEL_SIGN_II";
        case   0x0A41: return "GURMUKHI_VOWEL_SIGN_U";
        case   0x0A42: return "GURMUKHI_VOWEL_SIGN_UU";
        case   0x0A47: return "GURMUKHI_VOWEL_SIGN_EE";
        case   0x0A48: return "GURMUKHI_VOWEL_SIGN_AI";
        case   0x0A4B: return "GURMUKHI_VOWEL_SIGN_OO";
        case   0x0A4C: return "GURMUKHI_VOWEL_SIGN_AU";
        case   0x0A4D: return "GURMUKHI_SIGN_VIRAMA";
        case   0x0A51: return "GURMUKHI_SIGN_UDAAT";
        case   0x0A59: return "GURMUKHI_LETTER_KHHA";
        case   0x0A5A: return "GURMUKHI_LETTER_GHHA";
        case   0x0A5B: return "GURMUKHI_LETTER_ZA";
        case   0x0A5C: return "GURMUKHI_LETTER_RRA";
        case   0x0A5E: return "GURMUKHI_LETTER_FA";
        case   0x0A66: return "GURMUKHI_DIGIT_ZERO";
        case   0x0A67: return "GURMUKHI_DIGIT_ONE";
        case   0x0A68: return "GURMUKHI_DIGIT_TWO";
        case   0x0A69: return "GURMUKHI_DIGIT_THREE";
        case   0x0A6A: return "GURMUKHI_DIGIT_FOUR";
        case   0x0A6B: return "GURMUKHI_DIGIT_FIVE";
        case   0x0A6C: return "GURMUKHI_DIGIT_SIX";
        case   0x0A6D: return "GURMUKHI_DIGIT_SEVEN";
        case   0x0A6E: return "GURMUKHI_DIGIT_EIGHT";
        case   0x0A6F: return "GURMUKHI_DIGIT_NINE";
        case   0x0A70: return "GURMUKHI_TIPPI";
        case   0x0A71: return "GURMUKHI_ADDAK";
        case   0x0A72: return "GURMUKHI_IRI";
        case   0x0A73: return "GURMUKHI_URA";
        case   0x0A74: return "GURMUKHI_EK_ONKAR";
        case   0x0A75: return "GURMUKHI_SIGN_YAKASH";
        case   0x0A81: return "GUJARATI_SIGN_CANDRABINDU";
        case   0x0A82: return "GUJARATI_SIGN_ANUSVARA";
        case   0x0A83: return "GUJARATI_SIGN_VISARGA";
        case   0x0A85: return "GUJARATI_LETTER_A";
        case   0x0A86: return "GUJARATI_LETTER_AA";
        case   0x0A87: return "GUJARATI_LETTER_I";
        case   0x0A88: return "GUJARATI_LETTER_II";
        case   0x0A89: return "GUJARATI_LETTER_U";
        case   0x0A8A: return "GUJARATI_LETTER_UU";
        case   0x0A8B: return "GUJARATI_LETTER_VOCALIC_R";
        case   0x0A8C: return "GUJARATI_LETTER_VOCALIC_L";
        case   0x0A8D: return "GUJARATI_VOWEL_CANDRA_E";
        case   0x0A8F: return "GUJARATI_LETTER_E";
        case   0x0A90: return "GUJARATI_LETTER_AI";
        case   0x0A91: return "GUJARATI_VOWEL_CANDRA_O";
        case   0x0A93: return "GUJARATI_LETTER_O";
        case   0x0A94: return "GUJARATI_LETTER_AU";
        case   0x0A95: return "GUJARATI_LETTER_KA";
        case   0x0A96: return "GUJARATI_LETTER_KHA";
        case   0x0A97: return "GUJARATI_LETTER_GA";
        case   0x0A98: return "GUJARATI_LETTER_GHA";
        case   0x0A99: return "GUJARATI_LETTER_NGA";
        case   0x0A9A: return "GUJARATI_LETTER_CA";
        case   0x0A9B: return "GUJARATI_LETTER_CHA";
        case   0x0A9C: return "GUJARATI_LETTER_JA";
        case   0x0A9D: return "GUJARATI_LETTER_JHA";
        case   0x0A9E: return "GUJARATI_LETTER_NYA";
        case   0x0A9F: return "GUJARATI_LETTER_TTA";
        case   0x0AA0: return "GUJARATI_LETTER_TTHA";
        case   0x0AA1: return "GUJARATI_LETTER_DDA";
        case   0x0AA2: return "GUJARATI_LETTER_DDHA";
        case   0x0AA3: return "GUJARATI_LETTER_NNA";
        case   0x0AA4: return "GUJARATI_LETTER_TA";
        case   0x0AA5: return "GUJARATI_LETTER_THA";
        case   0x0AA6: return "GUJARATI_LETTER_DA";
        case   0x0AA7: return "GUJARATI_LETTER_DHA";
        case   0x0AA8: return "GUJARATI_LETTER_NA";
        case   0x0AAA: return "GUJARATI_LETTER_PA";
        case   0x0AAB: return "GUJARATI_LETTER_PHA";
        case   0x0AAC: return "GUJARATI_LETTER_BA";
        case   0x0AAD: return "GUJARATI_LETTER_BHA";
        case   0x0AAE: return "GUJARATI_LETTER_MA";
        case   0x0AAF: return "GUJARATI_LETTER_YA";
        case   0x0AB0: return "GUJARATI_LETTER_RA";
        case   0x0AB2: return "GUJARATI_LETTER_LA";
        case   0x0AB3: return "GUJARATI_LETTER_LLA";
        case   0x0AB5: return "GUJARATI_LETTER_VA";
        case   0x0AB6: return "GUJARATI_LETTER_SHA";
        case   0x0AB7: return "GUJARATI_LETTER_SSA";
        case   0x0AB8: return "GUJARATI_LETTER_SA";
        case   0x0AB9: return "GUJARATI_LETTER_HA";
        case   0x0ABC: return "GUJARATI_SIGN_NUKTA";
        case   0x0ABD: return "GUJARATI_SIGN_AVAGRAHA";
        case   0x0ABE: return "GUJARATI_VOWEL_SIGN_AA";
        case   0x0ABF: return "GUJARATI_VOWEL_SIGN_I";
        case   0x0AC0: return "GUJARATI_VOWEL_SIGN_II";
        case   0x0AC1: return "GUJARATI_VOWEL_SIGN_U";
        case   0x0AC2: return "GUJARATI_VOWEL_SIGN_UU";
        case   0x0AC3: return "GUJARATI_VOWEL_SIGN_VOCALIC_R";
        case   0x0AC4: return "GUJARATI_VOWEL_SIGN_VOCALIC_RR";
        case   0x0AC5: return "GUJARATI_VOWEL_SIGN_CANDRA_E";
        case   0x0AC7: return "GUJARATI_VOWEL_SIGN_E";
        case   0x0AC8: return "GUJARATI_VOWEL_SIGN_AI";
        case   0x0AC9: return "GUJARATI_VOWEL_SIGN_CANDRA_O";
        case   0x0ACB: return "GUJARATI_VOWEL_SIGN_O";
        case   0x0ACC: return "GUJARATI_VOWEL_SIGN_AU";
        case   0x0ACD: return "GUJARATI_SIGN_VIRAMA";
        case   0x0AD0: return "GUJARATI_OM";
        case   0x0AE0: return "GUJARATI_LETTER_VOCALIC_RR";
        case   0x0AE1: return "GUJARATI_LETTER_VOCALIC_LL";
        case   0x0AE2: return "GUJARATI_VOWEL_SIGN_VOCALIC_L";
        case   0x0AE3: return "GUJARATI_VOWEL_SIGN_VOCALIC_LL";
        case   0x0AE6: return "GUJARATI_DIGIT_ZERO";
        case   0x0AE7: return "GUJARATI_DIGIT_ONE";
        case   0x0AE8: return "GUJARATI_DIGIT_TWO";
        case   0x0AE9: return "GUJARATI_DIGIT_THREE";
        case   0x0AEA: return "GUJARATI_DIGIT_FOUR";
        case   0x0AEB: return "GUJARATI_DIGIT_FIVE";
        case   0x0AEC: return "GUJARATI_DIGIT_SIX";
        case   0x0AED: return "GUJARATI_DIGIT_SEVEN";
        case   0x0AEE: return "GUJARATI_DIGIT_EIGHT";
        case   0x0AEF: return "GUJARATI_DIGIT_NINE";
        case   0x0AF0: return "GUJARATI_ABBREVIATION_SIGN";
        case   0x0AF1: return "GUJARATI_RUPEE_SIGN";
        case   0x0B01: return "ORIYA_SIGN_CANDRABINDU";
        case   0x0B02: return "ORIYA_SIGN_ANUSVARA";
        case   0x0B03: return "ORIYA_SIGN_VISARGA";
        case   0x0B05: return "ORIYA_LETTER_A";
        case   0x0B06: return "ORIYA_LETTER_AA";
        case   0x0B07: return "ORIYA_LETTER_I";
        case   0x0B08: return "ORIYA_LETTER_II";
        case   0x0B09: return "ORIYA_LETTER_U";
        case   0x0B0A: return "ORIYA_LETTER_UU";
        case   0x0B0B: return "ORIYA_LETTER_VOCALIC_R";
        case   0x0B0C: return "ORIYA_LETTER_VOCALIC_L";
        case   0x0B0F: return "ORIYA_LETTER_E";
        case   0x0B10: return "ORIYA_LETTER_AI";
        case   0x0B13: return "ORIYA_LETTER_O";
        case   0x0B14: return "ORIYA_LETTER_AU";
        case   0x0B15: return "ORIYA_LETTER_KA";
        case   0x0B16: return "ORIYA_LETTER_KHA";
        case   0x0B17: return "ORIYA_LETTER_GA";
        case   0x0B18: return "ORIYA_LETTER_GHA";
        case   0x0B19: return "ORIYA_LETTER_NGA";
        case   0x0B1A: return "ORIYA_LETTER_CA";
        case   0x0B1B: return "ORIYA_LETTER_CHA";
        case   0x0B1C: return "ORIYA_LETTER_JA";
        case   0x0B1D: return "ORIYA_LETTER_JHA";
        case   0x0B1E: return "ORIYA_LETTER_NYA";
        case   0x0B1F: return "ORIYA_LETTER_TTA";
        case   0x0B20: return "ORIYA_LETTER_TTHA";
        case   0x0B21: return "ORIYA_LETTER_DDA";
        case   0x0B22: return "ORIYA_LETTER_DDHA";
        case   0x0B23: return "ORIYA_LETTER_NNA";
        case   0x0B24: return "ORIYA_LETTER_TA";
        case   0x0B25: return "ORIYA_LETTER_THA";
        case   0x0B26: return "ORIYA_LETTER_DA";
        case   0x0B27: return "ORIYA_LETTER_DHA";
        case   0x0B28: return "ORIYA_LETTER_NA";
        case   0x0B2A: return "ORIYA_LETTER_PA";
        case   0x0B2B: return "ORIYA_LETTER_PHA";
        case   0x0B2C: return "ORIYA_LETTER_BA";
        case   0x0B2D: return "ORIYA_LETTER_BHA";
        case   0x0B2E: return "ORIYA_LETTER_MA";
        case   0x0B2F: return "ORIYA_LETTER_YA";
        case   0x0B30: return "ORIYA_LETTER_RA";
        case   0x0B32: return "ORIYA_LETTER_LA";
        case   0x0B33: return "ORIYA_LETTER_LLA";
        case   0x0B35: return "ORIYA_LETTER_VA";
        case   0x0B36: return "ORIYA_LETTER_SHA";
        case   0x0B37: return "ORIYA_LETTER_SSA";
        case   0x0B38: return "ORIYA_LETTER_SA";
        case   0x0B39: return "ORIYA_LETTER_HA";
        case   0x0B3C: return "ORIYA_SIGN_NUKTA";
        case   0x0B3D: return "ORIYA_SIGN_AVAGRAHA";
        case   0x0B3E: return "ORIYA_VOWEL_SIGN_AA";
        case   0x0B3F: return "ORIYA_VOWEL_SIGN_I";
        case   0x0B40: return "ORIYA_VOWEL_SIGN_II";
        case   0x0B41: return "ORIYA_VOWEL_SIGN_U";
        case   0x0B42: return "ORIYA_VOWEL_SIGN_UU";
        case   0x0B43: return "ORIYA_VOWEL_SIGN_VOCALIC_R";
        case   0x0B44: return "ORIYA_VOWEL_SIGN_VOCALIC_RR";
        case   0x0B47: return "ORIYA_VOWEL_SIGN_E";
        case   0x0B48: return "ORIYA_VOWEL_SIGN_AI";
        case   0x0B4B: return "ORIYA_VOWEL_SIGN_O";
        case   0x0B4C: return "ORIYA_VOWEL_SIGN_AU";
        case   0x0B4D: return "ORIYA_SIGN_VIRAMA";
        case   0x0B56: return "ORIYA_AI_LENGTH_MARK";
        case   0x0B57: return "ORIYA_AU_LENGTH_MARK";
        case   0x0B5C: return "ORIYA_LETTER_RRA";
        case   0x0B5D: return "ORIYA_LETTER_RHA";
        case   0x0B5F: return "ORIYA_LETTER_YYA";
        case   0x0B60: return "ORIYA_LETTER_VOCALIC_RR";
        case   0x0B61: return "ORIYA_LETTER_VOCALIC_LL";
        case   0x0B62: return "ORIYA_VOWEL_SIGN_VOCALIC_L";
        case   0x0B63: return "ORIYA_VOWEL_SIGN_VOCALIC_LL";
        case   0x0B66: return "ORIYA_DIGIT_ZERO";
        case   0x0B67: return "ORIYA_DIGIT_ONE";
        case   0x0B68: return "ORIYA_DIGIT_TWO";
        case   0x0B69: return "ORIYA_DIGIT_THREE";
        case   0x0B6A: return "ORIYA_DIGIT_FOUR";
        case   0x0B6B: return "ORIYA_DIGIT_FIVE";
        case   0x0B6C: return "ORIYA_DIGIT_SIX";
        case   0x0B6D: return "ORIYA_DIGIT_SEVEN";
        case   0x0B6E: return "ORIYA_DIGIT_EIGHT";
        case   0x0B6F: return "ORIYA_DIGIT_NINE";
        case   0x0B70: return "ORIYA_ISSHAR";
        case   0x0B71: return "ORIYA_LETTER_WA";
        case   0x0B72: return "ORIYA_FRACTION_ONE_QUARTER";
        case   0x0B73: return "ORIYA_FRACTION_ONE_HALF";
        case   0x0B74: return "ORIYA_FRACTION_THREE_QUARTERS";
        case   0x0B75: return "ORIYA_FRACTION_ONE_SIXTEENTH";
        case   0x0B76: return "ORIYA_FRACTION_ONE_EIGHTH";
        case   0x0B77: return "ORIYA_FRACTION_THREE_SIXTEENTHS";
        case   0x0B82: return "TAMIL_SIGN_ANUSVARA";
        case   0x0B83: return "TAMIL_SIGN_VISARGA";
        case   0x0B85: return "TAMIL_LETTER_A";
        case   0x0B86: return "TAMIL_LETTER_AA";
        case   0x0B87: return "TAMIL_LETTER_I";
        case   0x0B88: return "TAMIL_LETTER_II";
        case   0x0B89: return "TAMIL_LETTER_U";
        case   0x0B8A: return "TAMIL_LETTER_UU";
        case   0x0B8E: return "TAMIL_LETTER_E";
        case   0x0B8F: return "TAMIL_LETTER_EE";
        case   0x0B90: return "TAMIL_LETTER_AI";
        case   0x0B92: return "TAMIL_LETTER_O";
        case   0x0B93: return "TAMIL_LETTER_OO";
        case   0x0B94: return "TAMIL_LETTER_AU";
        case   0x0B95: return "TAMIL_LETTER_KA";
        case   0x0B99: return "TAMIL_LETTER_NGA";
        case   0x0B9A: return "TAMIL_LETTER_CA";
        case   0x0B9C: return "TAMIL_LETTER_JA";
        case   0x0B9E: return "TAMIL_LETTER_NYA";
        case   0x0B9F: return "TAMIL_LETTER_TTA";
        case   0x0BA3: return "TAMIL_LETTER_NNA";
        case   0x0BA4: return "TAMIL_LETTER_TA";
        case   0x0BA8: return "TAMIL_LETTER_NA";
        case   0x0BA9: return "TAMIL_LETTER_NNNA";
        case   0x0BAA: return "TAMIL_LETTER_PA";
        case   0x0BAE: return "TAMIL_LETTER_MA";
        case   0x0BAF: return "TAMIL_LETTER_YA";
        case   0x0BB0: return "TAMIL_LETTER_RA";
        case   0x0BB1: return "TAMIL_LETTER_RRA";
        case   0x0BB2: return "TAMIL_LETTER_LA";
        case   0x0BB3: return "TAMIL_LETTER_LLA";
        case   0x0BB4: return "TAMIL_LETTER_LLLA";
        case   0x0BB5: return "TAMIL_LETTER_VA";
        case   0x0BB6: return "TAMIL_LETTER_SHA";
        case   0x0BB7: return "TAMIL_LETTER_SSA";
        case   0x0BB8: return "TAMIL_LETTER_SA";
        case   0x0BB9: return "TAMIL_LETTER_HA";
        case   0x0BBE: return "TAMIL_VOWEL_SIGN_AA";
        case   0x0BBF: return "TAMIL_VOWEL_SIGN_I";
        case   0x0BC0: return "TAMIL_VOWEL_SIGN_II";
        case   0x0BC1: return "TAMIL_VOWEL_SIGN_U";
        case   0x0BC2: return "TAMIL_VOWEL_SIGN_UU";
        case   0x0BC6: return "TAMIL_VOWEL_SIGN_E";
        case   0x0BC7: return "TAMIL_VOWEL_SIGN_EE";
        case   0x0BC8: return "TAMIL_VOWEL_SIGN_AI";
        case   0x0BCA: return "TAMIL_VOWEL_SIGN_O";
        case   0x0BCB: return "TAMIL_VOWEL_SIGN_OO";
        case   0x0BCC: return "TAMIL_VOWEL_SIGN_AU";
        case   0x0BCD: return "TAMIL_SIGN_VIRAMA";
        case   0x0BD0: return "TAMIL_OM";
        case   0x0BD7: return "TAMIL_AU_LENGTH_MARK";
        case   0x0BE6: return "TAMIL_DIGIT_ZERO";
        case   0x0BE7: return "TAMIL_DIGIT_ONE";
        case   0x0BE8: return "TAMIL_DIGIT_TWO";
        case   0x0BE9: return "TAMIL_DIGIT_THREE";
        case   0x0BEA: return "TAMIL_DIGIT_FOUR";
        case   0x0BEB: return "TAMIL_DIGIT_FIVE";
        case   0x0BEC: return "TAMIL_DIGIT_SIX";
        case   0x0BED: return "TAMIL_DIGIT_SEVEN";
        case   0x0BEE: return "TAMIL_DIGIT_EIGHT";
        case   0x0BEF: return "TAMIL_DIGIT_NINE";
        case   0x0BF0: return "TAMIL_NUMBER_TEN";
        case   0x0BF1: return "TAMIL_NUMBER_ONE_HUNDRED";
        case   0x0BF2: return "TAMIL_NUMBER_ONE_THOUSAND";
        case   0x0BF3: return "TAMIL_DAY_SIGN";
        case   0x0BF4: return "TAMIL_MONTH_SIGN";
        case   0x0BF5: return "TAMIL_YEAR_SIGN";
        case   0x0BF6: return "TAMIL_DEBIT_SIGN";
        case   0x0BF7: return "TAMIL_CREDIT_SIGN";
        case   0x0BF8: return "TAMIL_AS_ABOVE_SIGN";
        case   0x0BF9: return "TAMIL_RUPEE_SIGN";
        case   0x0BFA: return "TAMIL_NUMBER_SIGN";
        case   0x0C00: return "TELUGU_SIGN_COMBINING_CANDRABINDU_ABOVE";
        case   0x0C01: return "TELUGU_SIGN_CANDRABINDU";
        case   0x0C02: return "TELUGU_SIGN_ANUSVARA";
        case   0x0C03: return "TELUGU_SIGN_VISARGA";
        case   0x0C05: return "TELUGU_LETTER_A";
        case   0x0C06: return "TELUGU_LETTER_AA";
        case   0x0C07: return "TELUGU_LETTER_I";
        case   0x0C08: return "TELUGU_LETTER_II";
        case   0x0C09: return "TELUGU_LETTER_U";
        case   0x0C0A: return "TELUGU_LETTER_UU";
        case   0x0C0B: return "TELUGU_LETTER_VOCALIC_R";
        case   0x0C0C: return "TELUGU_LETTER_VOCALIC_L";
        case   0x0C0E: return "TELUGU_LETTER_E";
        case   0x0C0F: return "TELUGU_LETTER_EE";
        case   0x0C10: return "TELUGU_LETTER_AI";
        case   0x0C12: return "TELUGU_LETTER_O";
        case   0x0C13: return "TELUGU_LETTER_OO";
        case   0x0C14: return "TELUGU_LETTER_AU";
        case   0x0C15: return "TELUGU_LETTER_KA";
        case   0x0C16: return "TELUGU_LETTER_KHA";
        case   0x0C17: return "TELUGU_LETTER_GA";
        case   0x0C18: return "TELUGU_LETTER_GHA";
        case   0x0C19: return "TELUGU_LETTER_NGA";
        case   0x0C1A: return "TELUGU_LETTER_CA";
        case   0x0C1B: return "TELUGU_LETTER_CHA";
        case   0x0C1C: return "TELUGU_LETTER_JA";
        case   0x0C1D: return "TELUGU_LETTER_JHA";
        case   0x0C1E: return "TELUGU_LETTER_NYA";
        case   0x0C1F: return "TELUGU_LETTER_TTA";
        case   0x0C20: return "TELUGU_LETTER_TTHA";
        case   0x0C21: return "TELUGU_LETTER_DDA";
        case   0x0C22: return "TELUGU_LETTER_DDHA";
        case   0x0C23: return "TELUGU_LETTER_NNA";
        case   0x0C24: return "TELUGU_LETTER_TA";
        case   0x0C25: return "TELUGU_LETTER_THA";
        case   0x0C26: return "TELUGU_LETTER_DA";
        case   0x0C27: return "TELUGU_LETTER_DHA";
        case   0x0C28: return "TELUGU_LETTER_NA";
        case   0x0C2A: return "TELUGU_LETTER_PA";
        case   0x0C2B: return "TELUGU_LETTER_PHA";
        case   0x0C2C: return "TELUGU_LETTER_BA";
        case   0x0C2D: return "TELUGU_LETTER_BHA";
        case   0x0C2E: return "TELUGU_LETTER_MA";
        case   0x0C2F: return "TELUGU_LETTER_YA";
        case   0x0C30: return "TELUGU_LETTER_RA";
        case   0x0C31: return "TELUGU_LETTER_RRA";
        case   0x0C32: return "TELUGU_LETTER_LA";
        case   0x0C33: return "TELUGU_LETTER_LLA";
        case   0x0C34: return "TELUGU_LETTER_LLLA";
        case   0x0C35: return "TELUGU_LETTER_VA";
        case   0x0C36: return "TELUGU_LETTER_SHA";
        case   0x0C37: return "TELUGU_LETTER_SSA";
        case   0x0C38: return "TELUGU_LETTER_SA";
        case   0x0C39: return "TELUGU_LETTER_HA";
        case   0x0C3D: return "TELUGU_SIGN_AVAGRAHA";
        case   0x0C3E: return "TELUGU_VOWEL_SIGN_AA";
        case   0x0C3F: return "TELUGU_VOWEL_SIGN_I";
        case   0x0C40: return "TELUGU_VOWEL_SIGN_II";
        case   0x0C41: return "TELUGU_VOWEL_SIGN_U";
        case   0x0C42: return "TELUGU_VOWEL_SIGN_UU";
        case   0x0C43: return "TELUGU_VOWEL_SIGN_VOCALIC_R";
        case   0x0C44: return "TELUGU_VOWEL_SIGN_VOCALIC_RR";
        case   0x0C46: return "TELUGU_VOWEL_SIGN_E";
        case   0x0C47: return "TELUGU_VOWEL_SIGN_EE";
        case   0x0C48: return "TELUGU_VOWEL_SIGN_AI";
        case   0x0C4A: return "TELUGU_VOWEL_SIGN_O";
        case   0x0C4B: return "TELUGU_VOWEL_SIGN_OO";
        case   0x0C4C: return "TELUGU_VOWEL_SIGN_AU";
        case   0x0C4D: return "TELUGU_SIGN_VIRAMA";
        case   0x0C55: return "TELUGU_LENGTH_MARK";
        case   0x0C56: return "TELUGU_AI_LENGTH_MARK";
        case   0x0C58: return "TELUGU_LETTER_TSA";
        case   0x0C59: return "TELUGU_LETTER_DZA";
        case   0x0C60: return "TELUGU_LETTER_VOCALIC_RR";
        case   0x0C61: return "TELUGU_LETTER_VOCALIC_LL";
        case   0x0C62: return "TELUGU_VOWEL_SIGN_VOCALIC_L";
        case   0x0C63: return "TELUGU_VOWEL_SIGN_VOCALIC_LL";
        case   0x0C66: return "TELUGU_DIGIT_ZERO";
        case   0x0C67: return "TELUGU_DIGIT_ONE";
        case   0x0C68: return "TELUGU_DIGIT_TWO";
        case   0x0C69: return "TELUGU_DIGIT_THREE";
        case   0x0C6A: return "TELUGU_DIGIT_FOUR";
        case   0x0C6B: return "TELUGU_DIGIT_FIVE";
        case   0x0C6C: return "TELUGU_DIGIT_SIX";
        case   0x0C6D: return "TELUGU_DIGIT_SEVEN";
        case   0x0C6E: return "TELUGU_DIGIT_EIGHT";
        case   0x0C6F: return "TELUGU_DIGIT_NINE";
        case   0x0C78: return
                "TELUGU_FRACTION_DIGIT_ZERO_FOR_ODD_POWERS_OF_FOUR";
        case   0x0C79: return
                "TELUGU_FRACTION_DIGIT_ONE_FOR_ODD_POWERS_OF_FOUR";
        case   0x0C7A: return
                "TELUGU_FRACTION_DIGIT_TWO_FOR_ODD_POWERS_OF_FOUR";
        case   0x0C7B: return
                "TELUGU_FRACTION_DIGIT_THREE_FOR_ODD_POWERS_OF_FOUR";
        case   0x0C7C: return
                "TELUGU_FRACTION_DIGIT_ONE_FOR_EVEN_POWERS_OF_FOUR";
        case   0x0C7D: return
                "TELUGU_FRACTION_DIGIT_TWO_FOR_EVEN_POWERS_OF_FOUR";
        case   0x0C7E: return
                "TELUGU_FRACTION_DIGIT_THREE_FOR_EVEN_POWERS_OF_FOUR";
        case   0x0C7F: return "TELUGU_SIGN_TUUMU";
        case   0x0C81: return "KANNADA_SIGN_CANDRABINDU";
        case   0x0C82: return "KANNADA_SIGN_ANUSVARA";
        case   0x0C83: return "KANNADA_SIGN_VISARGA";
        case   0x0C85: return "KANNADA_LETTER_A";
        case   0x0C86: return "KANNADA_LETTER_AA";
        case   0x0C87: return "KANNADA_LETTER_I";
        case   0x0C88: return "KANNADA_LETTER_II";
        case   0x0C89: return "KANNADA_LETTER_U";
        case   0x0C8A: return "KANNADA_LETTER_UU";
        case   0x0C8B: return "KANNADA_LETTER_VOCALIC_R";
        case   0x0C8C: return "KANNADA_LETTER_VOCALIC_L";
        case   0x0C8E: return "KANNADA_LETTER_E";
        case   0x0C8F: return "KANNADA_LETTER_EE";
        case   0x0C90: return "KANNADA_LETTER_AI";
        case   0x0C92: return "KANNADA_LETTER_O";
        case   0x0C93: return "KANNADA_LETTER_OO";
        case   0x0C94: return "KANNADA_LETTER_AU";
        case   0x0C95: return "KANNADA_LETTER_KA";
        case   0x0C96: return "KANNADA_LETTER_KHA";
        case   0x0C97: return "KANNADA_LETTER_GA";
        case   0x0C98: return "KANNADA_LETTER_GHA";
        case   0x0C99: return "KANNADA_LETTER_NGA";
        case   0x0C9A: return "KANNADA_LETTER_CA";
        case   0x0C9B: return "KANNADA_LETTER_CHA";
        case   0x0C9C: return "KANNADA_LETTER_JA";
        case   0x0C9D: return "KANNADA_LETTER_JHA";
        case   0x0C9E: return "KANNADA_LETTER_NYA";
        case   0x0C9F: return "KANNADA_LETTER_TTA";
        case   0x0CA0: return "KANNADA_LETTER_TTHA";
        case   0x0CA1: return "KANNADA_LETTER_DDA";
        case   0x0CA2: return "KANNADA_LETTER_DDHA";
        case   0x0CA3: return "KANNADA_LETTER_NNA";
        case   0x0CA4: return "KANNADA_LETTER_TA";
        case   0x0CA5: return "KANNADA_LETTER_THA";
        case   0x0CA6: return "KANNADA_LETTER_DA";
        case   0x0CA7: return "KANNADA_LETTER_DHA";
        case   0x0CA8: return "KANNADA_LETTER_NA";
        case   0x0CAA: return "KANNADA_LETTER_PA";
        case   0x0CAB: return "KANNADA_LETTER_PHA";
        case   0x0CAC: return "KANNADA_LETTER_BA";
        case   0x0CAD: return "KANNADA_LETTER_BHA";
        case   0x0CAE: return "KANNADA_LETTER_MA";
        case   0x0CAF: return "KANNADA_LETTER_YA";
        case   0x0CB0: return "KANNADA_LETTER_RA";
        case   0x0CB1: return "KANNADA_LETTER_RRA";
        case   0x0CB2: return "KANNADA_LETTER_LA";
        case   0x0CB3: return "KANNADA_LETTER_LLA";
        case   0x0CB5: return "KANNADA_LETTER_VA";
        case   0x0CB6: return "KANNADA_LETTER_SHA";
        case   0x0CB7: return "KANNADA_LETTER_SSA";
        case   0x0CB8: return "KANNADA_LETTER_SA";
        case   0x0CB9: return "KANNADA_LETTER_HA";
        case   0x0CBC: return "KANNADA_SIGN_NUKTA";
        case   0x0CBD: return "KANNADA_SIGN_AVAGRAHA";
        case   0x0CBE: return "KANNADA_VOWEL_SIGN_AA";
        case   0x0CBF: return "KANNADA_VOWEL_SIGN_I";
        case   0x0CC0: return "KANNADA_VOWEL_SIGN_II";
        case   0x0CC1: return "KANNADA_VOWEL_SIGN_U";
        case   0x0CC2: return "KANNADA_VOWEL_SIGN_UU";
        case   0x0CC3: return "KANNADA_VOWEL_SIGN_VOCALIC_R";
        case   0x0CC4: return "KANNADA_VOWEL_SIGN_VOCALIC_RR";
        case   0x0CC6: return "KANNADA_VOWEL_SIGN_E";
        case   0x0CC7: return "KANNADA_VOWEL_SIGN_EE";
        case   0x0CC8: return "KANNADA_VOWEL_SIGN_AI";
        case   0x0CCA: return "KANNADA_VOWEL_SIGN_O";
        case   0x0CCB: return "KANNADA_VOWEL_SIGN_OO";
        case   0x0CCC: return "KANNADA_VOWEL_SIGN_AU";
        case   0x0CCD: return "KANNADA_SIGN_VIRAMA";
        case   0x0CD5: return "KANNADA_LENGTH_MARK";
        case   0x0CD6: return "KANNADA_AI_LENGTH_MARK";
        case   0x0CDE: return "KANNADA_LETTER_FA";
        case   0x0CE0: return "KANNADA_LETTER_VOCALIC_RR";
        case   0x0CE1: return "KANNADA_LETTER_VOCALIC_LL";
        case   0x0CE2: return "KANNADA_VOWEL_SIGN_VOCALIC_L";
        case   0x0CE3: return "KANNADA_VOWEL_SIGN_VOCALIC_LL";
        case   0x0CE6: return "KANNADA_DIGIT_ZERO";
        case   0x0CE7: return "KANNADA_DIGIT_ONE";
        case   0x0CE8: return "KANNADA_DIGIT_TWO";
        case   0x0CE9: return "KANNADA_DIGIT_THREE";
        case   0x0CEA: return "KANNADA_DIGIT_FOUR";
        case   0x0CEB: return "KANNADA_DIGIT_FIVE";
        case   0x0CEC: return "KANNADA_DIGIT_SIX";
        case   0x0CED: return "KANNADA_DIGIT_SEVEN";
        case   0x0CEE: return "KANNADA_DIGIT_EIGHT";
        case   0x0CEF: return "KANNADA_DIGIT_NINE";
        case   0x0CF1: return "KANNADA_SIGN_JIHVAMULIYA";
        case   0x0CF2: return "KANNADA_SIGN_UPADHMANIYA";
        case   0x0D01: return "MALAYALAM_SIGN_CANDRABINDU";
        case   0x0D02: return "MALAYALAM_SIGN_ANUSVARA";
        case   0x0D03: return "MALAYALAM_SIGN_VISARGA";
        case   0x0D05: return "MALAYALAM_LETTER_A";
        case   0x0D06: return "MALAYALAM_LETTER_AA";
        case   0x0D07: return "MALAYALAM_LETTER_I";
        case   0x0D08: return "MALAYALAM_LETTER_II";
        case   0x0D09: return "MALAYALAM_LETTER_U";
        case   0x0D0A: return "MALAYALAM_LETTER_UU";
        case   0x0D0B: return "MALAYALAM_LETTER_VOCALIC_R";
        case   0x0D0C: return "MALAYALAM_LETTER_VOCALIC_L";
        case   0x0D0E: return "MALAYALAM_LETTER_E";
        case   0x0D0F: return "MALAYALAM_LETTER_EE";
        case   0x0D10: return "MALAYALAM_LETTER_AI";
        case   0x0D12: return "MALAYALAM_LETTER_O";
        case   0x0D13: return "MALAYALAM_LETTER_OO";
        case   0x0D14: return "MALAYALAM_LETTER_AU";
        case   0x0D15: return "MALAYALAM_LETTER_KA";
        case   0x0D16: return "MALAYALAM_LETTER_KHA";
        case   0x0D17: return "MALAYALAM_LETTER_GA";
        case   0x0D18: return "MALAYALAM_LETTER_GHA";
        case   0x0D19: return "MALAYALAM_LETTER_NGA";
        case   0x0D1A: return "MALAYALAM_LETTER_CA";
        case   0x0D1B: return "MALAYALAM_LETTER_CHA";
        case   0x0D1C: return "MALAYALAM_LETTER_JA";
        case   0x0D1D: return "MALAYALAM_LETTER_JHA";
        case   0x0D1E: return "MALAYALAM_LETTER_NYA";
        case   0x0D1F: return "MALAYALAM_LETTER_TTA";
        case   0x0D20: return "MALAYALAM_LETTER_TTHA";
        case   0x0D21: return "MALAYALAM_LETTER_DDA";
        case   0x0D22: return "MALAYALAM_LETTER_DDHA";
        case   0x0D23: return "MALAYALAM_LETTER_NNA";
        case   0x0D24: return "MALAYALAM_LETTER_TA";
        case   0x0D25: return "MALAYALAM_LETTER_THA";
        case   0x0D26: return "MALAYALAM_LETTER_DA";
        case   0x0D27: return "MALAYALAM_LETTER_DHA";
        case   0x0D28: return "MALAYALAM_LETTER_NA";
        case   0x0D29: return "MALAYALAM_LETTER_NNNA";
        case   0x0D2A: return "MALAYALAM_LETTER_PA";
        case   0x0D2B: return "MALAYALAM_LETTER_PHA";
        case   0x0D2C: return "MALAYALAM_LETTER_BA";
        case   0x0D2D: return "MALAYALAM_LETTER_BHA";
        case   0x0D2E: return "MALAYALAM_LETTER_MA";
        case   0x0D2F: return "MALAYALAM_LETTER_YA";
        case   0x0D30: return "MALAYALAM_LETTER_RA";
        case   0x0D31: return "MALAYALAM_LETTER_RRA";
        case   0x0D32: return "MALAYALAM_LETTER_LA";
        case   0x0D33: return "MALAYALAM_LETTER_LLA";
        case   0x0D34: return "MALAYALAM_LETTER_LLLA";
        case   0x0D35: return "MALAYALAM_LETTER_VA";
        case   0x0D36: return "MALAYALAM_LETTER_SHA";
        case   0x0D37: return "MALAYALAM_LETTER_SSA";
        case   0x0D38: return "MALAYALAM_LETTER_SA";
        case   0x0D39: return "MALAYALAM_LETTER_HA";
        case   0x0D3A: return "MALAYALAM_LETTER_TTTA";
        case   0x0D3D: return "MALAYALAM_SIGN_AVAGRAHA";
        case   0x0D3E: return "MALAYALAM_VOWEL_SIGN_AA";
        case   0x0D3F: return "MALAYALAM_VOWEL_SIGN_I";
        case   0x0D40: return "MALAYALAM_VOWEL_SIGN_II";
        case   0x0D41: return "MALAYALAM_VOWEL_SIGN_U";
        case   0x0D42: return "MALAYALAM_VOWEL_SIGN_UU";
        case   0x0D43: return "MALAYALAM_VOWEL_SIGN_VOCALIC_R";
        case   0x0D44: return "MALAYALAM_VOWEL_SIGN_VOCALIC_RR";
        case   0x0D46: return "MALAYALAM_VOWEL_SIGN_E";
        case   0x0D47: return "MALAYALAM_VOWEL_SIGN_EE";
        case   0x0D48: return "MALAYALAM_VOWEL_SIGN_AI";
        case   0x0D4A: return "MALAYALAM_VOWEL_SIGN_O";
        case   0x0D4B: return "MALAYALAM_VOWEL_SIGN_OO";
        case   0x0D4C: return "MALAYALAM_VOWEL_SIGN_AU";
        case   0x0D4D: return "MALAYALAM_SIGN_VIRAMA";
        case   0x0D4E: return "MALAYALAM_LETTER_DOT_REPH";
        case   0x0D57: return "MALAYALAM_AU_LENGTH_MARK";
        case   0x0D60: return "MALAYALAM_LETTER_VOCALIC_RR";
        case   0x0D61: return "MALAYALAM_LETTER_VOCALIC_LL";
        case   0x0D62: return "MALAYALAM_VOWEL_SIGN_VOCALIC_L";
        case   0x0D63: return "MALAYALAM_VOWEL_SIGN_VOCALIC_LL";
        case   0x0D66: return "MALAYALAM_DIGIT_ZERO";
        case   0x0D67: return "MALAYALAM_DIGIT_ONE";
        case   0x0D68: return "MALAYALAM_DIGIT_TWO";
        case   0x0D69: return "MALAYALAM_DIGIT_THREE";
        case   0x0D6A: return "MALAYALAM_DIGIT_FOUR";
        case   0x0D6B: return "MALAYALAM_DIGIT_FIVE";
        case   0x0D6C: return "MALAYALAM_DIGIT_SIX";
        case   0x0D6D: return "MALAYALAM_DIGIT_SEVEN";
        case   0x0D6E: return "MALAYALAM_DIGIT_EIGHT";
        case   0x0D6F: return "MALAYALAM_DIGIT_NINE";
        case   0x0D70: return "MALAYALAM_NUMBER_TEN";
        case   0x0D71: return "MALAYALAM_NUMBER_ONE_HUNDRED";
        case   0x0D72: return "MALAYALAM_NUMBER_ONE_THOUSAND";
        case   0x0D73: return "MALAYALAM_FRACTION_ONE_QUARTER";
        case   0x0D74: return "MALAYALAM_FRACTION_ONE_HALF";
        case   0x0D75: return "MALAYALAM_FRACTION_THREE_QUARTERS";
        case   0x0D79: return "MALAYALAM_DATE_MARK";
        case   0x0D7A: return "MALAYALAM_LETTER_CHILLU_NN";
        case   0x0D7B: return "MALAYALAM_LETTER_CHILLU_N";
        case   0x0D7C: return "MALAYALAM_LETTER_CHILLU_RR";
        case   0x0D7D: return "MALAYALAM_LETTER_CHILLU_L";
        case   0x0D7E: return "MALAYALAM_LETTER_CHILLU_LL";
        case   0x0D7F: return "MALAYALAM_LETTER_CHILLU_K";
        case   0x0D82: return "SINHALA_SIGN_ANUSVARAYA";
        case   0x0D83: return "SINHALA_SIGN_VISARGAYA";
        case   0x0D85: return "SINHALA_LETTER_AYANNA";
        case   0x0D86: return "SINHALA_LETTER_AAYANNA";
        case   0x0D87: return "SINHALA_LETTER_AEYANNA";
        case   0x0D88: return "SINHALA_LETTER_AEEYANNA";
        case   0x0D89: return "SINHALA_LETTER_IYANNA";
        case   0x0D8A: return "SINHALA_LETTER_IIYANNA";
        case   0x0D8B: return "SINHALA_LETTER_UYANNA";
        case   0x0D8C: return "SINHALA_LETTER_UUYANNA";
        case   0x0D8D: return "SINHALA_LETTER_IRUYANNA";
        case   0x0D8E: return "SINHALA_LETTER_IRUUYANNA";
        case   0x0D8F: return "SINHALA_LETTER_ILUYANNA";
        case   0x0D90: return "SINHALA_LETTER_ILUUYANNA";
        case   0x0D91: return "SINHALA_LETTER_EYANNA";
        case   0x0D92: return "SINHALA_LETTER_EEYANNA";
        case   0x0D93: return "SINHALA_LETTER_AIYANNA";
        case   0x0D94: return "SINHALA_LETTER_OYANNA";
        case   0x0D95: return "SINHALA_LETTER_OOYANNA";
        case   0x0D96: return "SINHALA_LETTER_AUYANNA";
        case   0x0D9A: return "SINHALA_LETTER_ALPAPRAANA_KAYANNA";
        case   0x0D9B: return "SINHALA_LETTER_MAHAAPRAANA_KAYANNA";
        case   0x0D9C: return "SINHALA_LETTER_ALPAPRAANA_GAYANNA";
        case   0x0D9D: return "SINHALA_LETTER_MAHAAPRAANA_GAYANNA";
        case   0x0D9E: return "SINHALA_LETTER_KANTAJA_NAASIKYAYA";
        case   0x0D9F: return "SINHALA_LETTER_SANYAKA_GAYANNA";
        case   0x0DA0: return "SINHALA_LETTER_ALPAPRAANA_CAYANNA";
        case   0x0DA1: return "SINHALA_LETTER_MAHAAPRAANA_CAYANNA";
        case   0x0DA2: return "SINHALA_LETTER_ALPAPRAANA_JAYANNA";
        case   0x0DA3: return "SINHALA_LETTER_MAHAAPRAANA_JAYANNA";
        case   0x0DA4: return "SINHALA_LETTER_TAALUJA_NAASIKYAYA";
        case   0x0DA5: return "SINHALA_LETTER_TAALUJA_SANYOOGA_NAAKSIKYAYA";
        case   0x0DA6: return "SINHALA_LETTER_SANYAKA_JAYANNA";
        case   0x0DA7: return "SINHALA_LETTER_ALPAPRAANA_TTAYANNA";
        case   0x0DA8: return "SINHALA_LETTER_MAHAAPRAANA_TTAYANNA";
        case   0x0DA9: return "SINHALA_LETTER_ALPAPRAANA_DDAYANNA";
        case   0x0DAA: return "SINHALA_LETTER_MAHAAPRAANA_DDAYANNA";
        case   0x0DAB: return "SINHALA_LETTER_MUURDHAJA_NAYANNA";
        case   0x0DAC: return "SINHALA_LETTER_SANYAKA_DDAYANNA";
        case   0x0DAD: return "SINHALA_LETTER_ALPAPRAANA_TAYANNA";
        case   0x0DAE: return "SINHALA_LETTER_MAHAAPRAANA_TAYANNA";
        case   0x0DAF: return "SINHALA_LETTER_ALPAPRAANA_DAYANNA";
        case   0x0DB0: return "SINHALA_LETTER_MAHAAPRAANA_DAYANNA";
        case   0x0DB1: return "SINHALA_LETTER_DANTAJA_NAYANNA";
        case   0x0DB3: return "SINHALA_LETTER_SANYAKA_DAYANNA";
        case   0x0DB4: return "SINHALA_LETTER_ALPAPRAANA_PAYANNA";
        case   0x0DB5: return "SINHALA_LETTER_MAHAAPRAANA_PAYANNA";
        case   0x0DB6: return "SINHALA_LETTER_ALPAPRAANA_BAYANNA";
        case   0x0DB7: return "SINHALA_LETTER_MAHAAPRAANA_BAYANNA";
        case   0x0DB8: return "SINHALA_LETTER_MAYANNA";
        case   0x0DB9: return "SINHALA_LETTER_AMBA_BAYANNA";
        case   0x0DBA: return "SINHALA_LETTER_YAYANNA";
        case   0x0DBB: return "SINHALA_LETTER_RAYANNA";
        case   0x0DBD: return "SINHALA_LETTER_DANTAJA_LAYANNA";
        case   0x0DC0: return "SINHALA_LETTER_VAYANNA";
        case   0x0DC1: return "SINHALA_LETTER_TAALUJA_SAYANNA";
        case   0x0DC2: return "SINHALA_LETTER_MUURDHAJA_SAYANNA";
        case   0x0DC3: return "SINHALA_LETTER_DANTAJA_SAYANNA";
        case   0x0DC4: return "SINHALA_LETTER_HAYANNA";
        case   0x0DC5: return "SINHALA_LETTER_MUURDHAJA_LAYANNA";
        case   0x0DC6: return "SINHALA_LETTER_FAYANNA";
        case   0x0DCA: return "SINHALA_SIGN_AL_LAKUNA";
        case   0x0DCF: return "SINHALA_VOWEL_SIGN_AELA_PILLA";
        case   0x0DD0: return "SINHALA_VOWEL_SIGN_KETTI_AEDA_PILLA";
        case   0x0DD1: return "SINHALA_VOWEL_SIGN_DIGA_AEDA_PILLA";
        case   0x0DD2: return "SINHALA_VOWEL_SIGN_KETTI_IS_PILLA";
        case   0x0DD3: return "SINHALA_VOWEL_SIGN_DIGA_IS_PILLA";
        case   0x0DD4: return "SINHALA_VOWEL_SIGN_KETTI_PAA_PILLA";
        case   0x0DD6: return "SINHALA_VOWEL_SIGN_DIGA_PAA_PILLA";
        case   0x0DD8: return "SINHALA_VOWEL_SIGN_GAETTA_PILLA";
        case   0x0DD9: return "SINHALA_VOWEL_SIGN_KOMBUVA";
        case   0x0DDA: return "SINHALA_VOWEL_SIGN_DIGA_KOMBUVA";
        case   0x0DDB: return "SINHALA_VOWEL_SIGN_KOMBU_DEKA";
        case   0x0DDC: return "SINHALA_VOWEL_SIGN_KOMBUVA_HAA_AELA_PILLA";
        case   0x0DDD: return
                "SINHALA_VOWEL_SIGN_KOMBUVA_HAA_DIGA_AELA_PILLA";
        case   0x0DDE: return "SINHALA_VOWEL_SIGN_KOMBUVA_HAA_GAYANUKITTA";
        case   0x0DDF: return "SINHALA_VOWEL_SIGN_GAYANUKITTA";
        case   0x0DE6: return "SINHALA_LITH_DIGIT_ZERO";
        case   0x0DE7: return "SINHALA_LITH_DIGIT_ONE";
        case   0x0DE8: return "SINHALA_LITH_DIGIT_TWO";
        case   0x0DE9: return "SINHALA_LITH_DIGIT_THREE";
        case   0x0DEA: return "SINHALA_LITH_DIGIT_FOUR";
        case   0x0DEB: return "SINHALA_LITH_DIGIT_FIVE";
        case   0x0DEC: return "SINHALA_LITH_DIGIT_SIX";
        case   0x0DED: return "SINHALA_LITH_DIGIT_SEVEN";
        case   0x0DEE: return "SINHALA_LITH_DIGIT_EIGHT";
        case   0x0DEF: return "SINHALA_LITH_DIGIT_NINE";
        case   0x0DF2: return "SINHALA_VOWEL_SIGN_DIGA_GAETTA_PILLA";
        case   0x0DF3: return "SINHALA_VOWEL_SIGN_DIGA_GAYANUKITTA";
        case   0x0DF4: return "SINHALA_PUNCTUATION_KUNDDALIYA";
        case   0x0E01: return "THAI_CHARACTER_KO_KAI";
        case   0x0E02: return "THAI_CHARACTER_KHO_KHAI";
        case   0x0E03: return "THAI_CHARACTER_KHO_KHUAT";
        case   0x0E04: return "THAI_CHARACTER_KHO_KHWAI";
        case   0x0E05: return "THAI_CHARACTER_KHO_KHON";
        case   0x0E06: return "THAI_CHARACTER_KHO_RAKHANG";
        case   0x0E07: return "THAI_CHARACTER_NGO_NGU";
        case   0x0E08: return "THAI_CHARACTER_CHO_CHAN";
        case   0x0E09: return "THAI_CHARACTER_CHO_CHING";
        case   0x0E0A: return "THAI_CHARACTER_CHO_CHANG";
        case   0x0E0B: return "THAI_CHARACTER_SO_SO";
        case   0x0E0C: return "THAI_CHARACTER_CHO_CHOE";
        case   0x0E0D: return "THAI_CHARACTER_YO_YING";
        case   0x0E0E: return "THAI_CHARACTER_DO_CHADA";
        case   0x0E0F: return "THAI_CHARACTER_TO_PATAK";
        case   0x0E10: return "THAI_CHARACTER_THO_THAN";
        case   0x0E11: return "THAI_CHARACTER_THO_NANGMONTHO";
        case   0x0E12: return "THAI_CHARACTER_THO_PHUTHAO";
        case   0x0E13: return "THAI_CHARACTER_NO_NEN";
        case   0x0E14: return "THAI_CHARACTER_DO_DEK";
        case   0x0E15: return "THAI_CHARACTER_TO_TAO";
        case   0x0E16: return "THAI_CHARACTER_THO_THUNG";
        case   0x0E17: return "THAI_CHARACTER_THO_THAHAN";
        case   0x0E18: return "THAI_CHARACTER_THO_THONG";
        case   0x0E19: return "THAI_CHARACTER_NO_NU";
        case   0x0E1A: return "THAI_CHARACTER_BO_BAIMAI";
        case   0x0E1B: return "THAI_CHARACTER_PO_PLA";
        case   0x0E1C: return "THAI_CHARACTER_PHO_PHUNG";
        case   0x0E1D: return "THAI_CHARACTER_FO_FA";
        case   0x0E1E: return "THAI_CHARACTER_PHO_PHAN";
        case   0x0E1F: return "THAI_CHARACTER_FO_FAN";
        case   0x0E20: return "THAI_CHARACTER_PHO_SAMPHAO";
        case   0x0E21: return "THAI_CHARACTER_MO_MA";
        case   0x0E22: return "THAI_CHARACTER_YO_YAK";
        case   0x0E23: return "THAI_CHARACTER_RO_RUA";
        case   0x0E24: return "THAI_CHARACTER_RU";
        case   0x0E25: return "THAI_CHARACTER_LO_LING";
        case   0x0E26: return "THAI_CHARACTER_LU";
        case   0x0E27: return "THAI_CHARACTER_WO_WAEN";
        case   0x0E28: return "THAI_CHARACTER_SO_SALA";
        case   0x0E29: return "THAI_CHARACTER_SO_RUSI";
        case   0x0E2A: return "THAI_CHARACTER_SO_SUA";
        case   0x0E2B: return "THAI_CHARACTER_HO_HIP";
        case   0x0E2C: return "THAI_CHARACTER_LO_CHULA";
        case   0x0E2D: return "THAI_CHARACTER_O_ANG";
        case   0x0E2E: return "THAI_CHARACTER_HO_NOKHUK";
        case   0x0E2F: return "THAI_CHARACTER_PAIYANNOI";
        case   0x0E30: return "THAI_CHARACTER_SARA_A";
        case   0x0E31: return "THAI_CHARACTER_MAI_HAN_AKAT";
        case   0x0E32: return "THAI_CHARACTER_SARA_AA";
        case   0x0E33: return "THAI_CHARACTER_SARA_AM";
        case   0x0E34: return "THAI_CHARACTER_SARA_I";
        case   0x0E35: return "THAI_CHARACTER_SARA_II";
        case   0x0E36: return "THAI_CHARACTER_SARA_UE";
        case   0x0E37: return "THAI_CHARACTER_SARA_UEE";
        case   0x0E38: return "THAI_CHARACTER_SARA_U";
        case   0x0E39: return "THAI_CHARACTER_SARA_UU";
        case   0x0E3A: return "THAI_CHARACTER_PHINTHU";
        case   0x0E3F: return "THAI_CURRENCY_SYMBOL_BAHT";
        case   0x0E40: return "THAI_CHARACTER_SARA_E";
        case   0x0E41: return "THAI_CHARACTER_SARA_AE";
        case   0x0E42: return "THAI_CHARACTER_SARA_O";
        case   0x0E43: return "THAI_CHARACTER_SARA_AI_MAIMUAN";
        case   0x0E44: return "THAI_CHARACTER_SARA_AI_MAIMALAI";
        case   0x0E45: return "THAI_CHARACTER_LAKKHANGYAO";
        case   0x0E46: return "THAI_CHARACTER_MAIYAMOK";
        case   0x0E47: return "THAI_CHARACTER_MAITAIKHU";
        case   0x0E48: return "THAI_CHARACTER_MAI_EK";
        case   0x0E49: return "THAI_CHARACTER_MAI_THO";
        case   0x0E4A: return "THAI_CHARACTER_MAI_TRI";
        case   0x0E4B: return "THAI_CHARACTER_MAI_CHATTAWA";
        case   0x0E4C: return "THAI_CHARACTER_THANTHAKHAT";
        case   0x0E4D: return "THAI_CHARACTER_NIKHAHIT";
        case   0x0E4E: return "THAI_CHARACTER_YAMAKKAN";
        case   0x0E4F: return "THAI_CHARACTER_FONGMAN";
        case   0x0E50: return "THAI_DIGIT_ZERO";
        case   0x0E51: return "THAI_DIGIT_ONE";
        case   0x0E52: return "THAI_DIGIT_TWO";
        case   0x0E53: return "THAI_DIGIT_THREE";
        case   0x0E54: return "THAI_DIGIT_FOUR";
        case   0x0E55: return "THAI_DIGIT_FIVE";
        case   0x0E56: return "THAI_DIGIT_SIX";
        case   0x0E57: return "THAI_DIGIT_SEVEN";
        case   0x0E58: return "THAI_DIGIT_EIGHT";
        case   0x0E59: return "THAI_DIGIT_NINE";
        case   0x0E5A: return "THAI_CHARACTER_ANGKHANKHU";
        case   0x0E5B: return "THAI_CHARACTER_KHOMUT";
        case   0x0E81: return "LAO_LETTER_KO";
        case   0x0E82: return "LAO_LETTER_KHO_SUNG";
        case   0x0E84: return "LAO_LETTER_KHO_TAM";
        case   0x0E87: return "LAO_LETTER_NGO";
        case   0x0E88: return "LAO_LETTER_CO";
        case   0x0E8A: return "LAO_LETTER_SO_TAM";
        case   0x0E8D: return "LAO_LETTER_NYO";
        case   0x0E94: return "LAO_LETTER_DO";
        case   0x0E95: return "LAO_LETTER_TO";
        case   0x0E96: return "LAO_LETTER_THO_SUNG";
        case   0x0E97: return "LAO_LETTER_THO_TAM";
        case   0x0E99: return "LAO_LETTER_NO";
        case   0x0E9A: return "LAO_LETTER_BO";
        case   0x0E9B: return "LAO_LETTER_PO";
        case   0x0E9C: return "LAO_LETTER_PHO_SUNG";
        case   0x0E9D: return "LAO_LETTER_FO_TAM";
        case   0x0E9E: return "LAO_LETTER_PHO_TAM";
        case   0x0E9F: return "LAO_LETTER_FO_SUNG";
        case   0x0EA1: return "LAO_LETTER_MO";
        case   0x0EA2: return "LAO_LETTER_YO";
        case   0x0EA3: return "LAO_LETTER_LO_LING";
        case   0x0EA5: return "LAO_LETTER_LO_LOOT";
        case   0x0EA7: return "LAO_LETTER_WO";
        case   0x0EAA: return "LAO_LETTER_SO_SUNG";
        case   0x0EAB: return "LAO_LETTER_HO_SUNG";
        case   0x0EAD: return "LAO_LETTER_O";
        case   0x0EAE: return "LAO_LETTER_HO_TAM";
        case   0x0EAF: return "LAO_ELLIPSIS";
        case   0x0EB0: return "LAO_VOWEL_SIGN_A";
        case   0x0EB1: return "LAO_VOWEL_SIGN_MAI_KAN";
        case   0x0EB2: return "LAO_VOWEL_SIGN_AA";
        case   0x0EB3: return "LAO_VOWEL_SIGN_AM";
        case   0x0EB4: return "LAO_VOWEL_SIGN_I";
        case   0x0EB5: return "LAO_VOWEL_SIGN_II";
        case   0x0EB6: return "LAO_VOWEL_SIGN_Y";
        case   0x0EB7: return "LAO_VOWEL_SIGN_YY";
        case   0x0EB8: return "LAO_VOWEL_SIGN_U";
        case   0x0EB9: return "LAO_VOWEL_SIGN_UU";
        case   0x0EBB: return "LAO_VOWEL_SIGN_MAI_KON";
        case   0x0EBC: return "LAO_SEMIVOWEL_SIGN_LO";
        case   0x0EBD: return "LAO_SEMIVOWEL_SIGN_NYO";
        case   0x0EC0: return "LAO_VOWEL_SIGN_E";
        case   0x0EC1: return "LAO_VOWEL_SIGN_EI";
        case   0x0EC2: return "LAO_VOWEL_SIGN_O";
        case   0x0EC3: return "LAO_VOWEL_SIGN_AY";
        case   0x0EC4: return "LAO_VOWEL_SIGN_AI";
        case   0x0EC6: return "LAO_KO_LA";
        case   0x0EC8: return "LAO_TONE_MAI_EK";
        case   0x0EC9: return "LAO_TONE_MAI_THO";
        case   0x0ECA: return "LAO_TONE_MAI_TI";
        case   0x0ECB: return "LAO_TONE_MAI_CATAWA";
        case   0x0ECC: return "LAO_CANCELLATION_MARK";
        case   0x0ECD: return "LAO_NIGGAHITA";
        case   0x0ED0: return "LAO_DIGIT_ZERO";
        case   0x0ED1: return "LAO_DIGIT_ONE";
        case   0x0ED2: return "LAO_DIGIT_TWO";
        case   0x0ED3: return "LAO_DIGIT_THREE";
        case   0x0ED4: return "LAO_DIGIT_FOUR";
        case   0x0ED5: return "LAO_DIGIT_FIVE";
        case   0x0ED6: return "LAO_DIGIT_SIX";
        case   0x0ED7: return "LAO_DIGIT_SEVEN";
        case   0x0ED8: return "LAO_DIGIT_EIGHT";
        case   0x0ED9: return "LAO_DIGIT_NINE";
        case   0x0EDC: return "LAO_HO_NO";
        case   0x0EDD: return "LAO_HO_MO";
        case   0x0EDE: return "LAO_LETTER_KHMU_GO";
        case   0x0EDF: return "LAO_LETTER_KHMU_NYO";
        case   0x0F00: return "TIBETAN_SYLLABLE_OM";
        case   0x0F01: return "TIBETAN_MARK_GTER_YIG_MGO_TRUNCATED_A";
        case   0x0F02: return "TIBETAN_MARK_GTER_YIG_MGO__UM_RNAM_BCAD_MA";
        case   0x0F03: return "TIBETAN_MARK_GTER_YIG_MGO__UM_GTER_TSHEG_MA";
        case   0x0F04: return "TIBETAN_MARK_INITIAL_YIG_MGO_MDUN_MA";
        case   0x0F05: return "TIBETAN_MARK_CLOSING_YIG_MGO_SGAB_MA";
        case   0x0F06: return "TIBETAN_MARK_CARET_YIG_MGO_PHUR_SHAD_MA";
        case   0x0F07: return "TIBETAN_MARK_YIG_MGO_TSHEG_SHAD_MA";
        case   0x0F08: return "TIBETAN_MARK_SBRUL_SHAD";
        case   0x0F09: return "TIBETAN_MARK_BSKUR_YIG_MGO";
        case   0x0F0A: return "TIBETAN_MARK_BKA__SHOG_YIG_MGO";
        case   0x0F0B: return "TIBETAN_MARK_INTERSYLLABIC_TSHEG";
        case   0x0F0C: return "TIBETAN_MARK_DELIMITER_TSHEG_BSTAR";
        case   0x0F0D: return "TIBETAN_MARK_SHAD";
        case   0x0F0E: return "TIBETAN_MARK_NYIS_SHAD";
        case   0x0F0F: return "TIBETAN_MARK_TSHEG_SHAD";
        case   0x0F10: return "TIBETAN_MARK_NYIS_TSHEG_SHAD";
        case   0x0F11: return "TIBETAN_MARK_RIN_CHEN_SPUNGS_SHAD";
        case   0x0F12: return "TIBETAN_MARK_RGYA_GRAM_SHAD";
        case   0x0F13: return "TIBETAN_MARK_CARET__DZUD_RTAGS_ME_LONG_CAN";
        case   0x0F14: return "TIBETAN_MARK_GTER_TSHEG";
        case   0x0F15: return "TIBETAN_LOGOTYPE_SIGN_CHAD_RTAGS";
        case   0x0F16: return "TIBETAN_LOGOTYPE_SIGN_LHAG_RTAGS";
        case   0x0F17: return
                "TIBETAN_ASTROLOGICAL_SIGN_SGRA_GCAN__CHAR_RTAGS";
        case   0x0F18: return "TIBETAN_ASTROLOGICAL_SIGN__KHYUD_PA";
        case   0x0F19: return "TIBETAN_ASTROLOGICAL_SIGN_SDONG_TSHUGS";
        case   0x0F1A: return "TIBETAN_SIGN_RDEL_DKAR_GCIG";
        case   0x0F1B: return "TIBETAN_SIGN_RDEL_DKAR_GNYIS";
        case   0x0F1C: return "TIBETAN_SIGN_RDEL_DKAR_GSUM";
        case   0x0F1D: return "TIBETAN_SIGN_RDEL_NAG_GCIG";
        case   0x0F1E: return "TIBETAN_SIGN_RDEL_NAG_GNYIS";
        case   0x0F1F: return "TIBETAN_SIGN_RDEL_DKAR_RDEL_NAG";
        case   0x0F20: return "TIBETAN_DIGIT_ZERO";
        case   0x0F21: return "TIBETAN_DIGIT_ONE";
        case   0x0F22: return "TIBETAN_DIGIT_TWO";
        case   0x0F23: return "TIBETAN_DIGIT_THREE";
        case   0x0F24: return "TIBETAN_DIGIT_FOUR";
        case   0x0F25: return "TIBETAN_DIGIT_FIVE";
        case   0x0F26: return "TIBETAN_DIGIT_SIX";
        case   0x0F27: return "TIBETAN_DIGIT_SEVEN";
        case   0x0F28: return "TIBETAN_DIGIT_EIGHT";
        case   0x0F29: return "TIBETAN_DIGIT_NINE";
        case   0x0F2A: return "TIBETAN_DIGIT_HALF_ONE";
        case   0x0F2B: return "TIBETAN_DIGIT_HALF_TWO";
        case   0x0F2C: return "TIBETAN_DIGIT_HALF_THREE";
        case   0x0F2D: return "TIBETAN_DIGIT_HALF_FOUR";
        case   0x0F2E: return "TIBETAN_DIGIT_HALF_FIVE";
        case   0x0F2F: return "TIBETAN_DIGIT_HALF_SIX";
        case   0x0F30: return "TIBETAN_DIGIT_HALF_SEVEN";
        case   0x0F31: return "TIBETAN_DIGIT_HALF_EIGHT";
        case   0x0F32: return "TIBETAN_DIGIT_HALF_NINE";
        case   0x0F33: return "TIBETAN_DIGIT_HALF_ZERO";
        case   0x0F34: return "TIBETAN_MARK_BSDUS_RTAGS";
        case   0x0F35: return "TIBETAN_MARK_NGAS_BZUNG_NYI_ZLA";
        case   0x0F36: return "TIBETAN_MARK_CARET__DZUD_RTAGS_BZHI_MIG_CAN";
        case   0x0F37: return "TIBETAN_MARK_NGAS_BZUNG_SGOR_RTAGS";
        case   0x0F38: return "TIBETAN_MARK_CHE_MGO";
        case   0x0F39: return "TIBETAN_MARK_TSA__PHRU";
        case   0x0F3A: return "TIBETAN_MARK_GUG_RTAGS_GYON";
        case   0x0F3B: return "TIBETAN_MARK_GUG_RTAGS_GYAS";
        case   0x0F3C: return "TIBETAN_MARK_ANG_KHANG_GYON";
        case   0x0F3D: return "TIBETAN_MARK_ANG_KHANG_GYAS";
        case   0x0F3E: return "TIBETAN_SIGN_YAR_TSHES";
        case   0x0F3F: return "TIBETAN_SIGN_MAR_TSHES";
        case   0x0F40: return "TIBETAN_LETTER_KA";
        case   0x0F41: return "TIBETAN_LETTER_KHA";
        case   0x0F42: return "TIBETAN_LETTER_GA";
        case   0x0F43: return "TIBETAN_LETTER_GHA";
        case   0x0F44: return "TIBETAN_LETTER_NGA";
        case   0x0F45: return "TIBETAN_LETTER_CA";
        case   0x0F46: return "TIBETAN_LETTER_CHA";
        case   0x0F47: return "TIBETAN_LETTER_JA";
        case   0x0F49: return "TIBETAN_LETTER_NYA";
        case   0x0F4A: return "TIBETAN_LETTER_TTA";
        case   0x0F4B: return "TIBETAN_LETTER_TTHA";
        case   0x0F4C: return "TIBETAN_LETTER_DDA";
        case   0x0F4D: return "TIBETAN_LETTER_DDHA";
        case   0x0F4E: return "TIBETAN_LETTER_NNA";
        case   0x0F4F: return "TIBETAN_LETTER_TA";
        case   0x0F50: return "TIBETAN_LETTER_THA";
        case   0x0F51: return "TIBETAN_LETTER_DA";
        case   0x0F52: return "TIBETAN_LETTER_DHA";
        case   0x0F53: return "TIBETAN_LETTER_NA";
        case   0x0F54: return "TIBETAN_LETTER_PA";
        case   0x0F55: return "TIBETAN_LETTER_PHA";
        case   0x0F56: return "TIBETAN_LETTER_BA";
        case   0x0F57: return "TIBETAN_LETTER_BHA";
        case   0x0F58: return "TIBETAN_LETTER_MA";
        case   0x0F59: return "TIBETAN_LETTER_TSA";
        case   0x0F5A: return "TIBETAN_LETTER_TSHA";
        case   0x0F5B: return "TIBETAN_LETTER_DZA";
        case   0x0F5C: return "TIBETAN_LETTER_DZHA";
        case   0x0F5D: return "TIBETAN_LETTER_WA";
        case   0x0F5E: return "TIBETAN_LETTER_ZHA";
        case   0x0F5F: return "TIBETAN_LETTER_ZA";
        case   0x0F60: return "TIBETAN_LETTER__A";
        case   0x0F61: return "TIBETAN_LETTER_YA";
        case   0x0F62: return "TIBETAN_LETTER_RA";
        case   0x0F63: return "TIBETAN_LETTER_LA";
        case   0x0F64: return "TIBETAN_LETTER_SHA";
        case   0x0F65: return "TIBETAN_LETTER_SSA";
        case   0x0F66: return "TIBETAN_LETTER_SA";
        case   0x0F67: return "TIBETAN_LETTER_HA";
        case   0x0F68: return "TIBETAN_LETTER_A";
        case   0x0F69: return "TIBETAN_LETTER_KSSA";
        case   0x0F6A: return "TIBETAN_LETTER_FIXED_FORM_RA";
        case   0x0F6B: return "TIBETAN_LETTER_KKA";
        case   0x0F6C: return "TIBETAN_LETTER_RRA";
        case   0x0F71: return "TIBETAN_VOWEL_SIGN_AA";
        case   0x0F72: return "TIBETAN_VOWEL_SIGN_I";
        case   0x0F73: return "TIBETAN_VOWEL_SIGN_II";
        case   0x0F74: return "TIBETAN_VOWEL_SIGN_U";
        case   0x0F75: return "TIBETAN_VOWEL_SIGN_UU";
        case   0x0F76: return "TIBETAN_VOWEL_SIGN_VOCALIC_R";
        case   0x0F77: return "TIBETAN_VOWEL_SIGN_VOCALIC_RR";
        case   0x0F78: return "TIBETAN_VOWEL_SIGN_VOCALIC_L";
        case   0x0F79: return "TIBETAN_VOWEL_SIGN_VOCALIC_LL";
        case   0x0F7A: return "TIBETAN_VOWEL_SIGN_E";
        case   0x0F7B: return "TIBETAN_VOWEL_SIGN_EE";
        case   0x0F7C: return "TIBETAN_VOWEL_SIGN_O";
        case   0x0F7D: return "TIBETAN_VOWEL_SIGN_OO";
        case   0x0F7E: return "TIBETAN_SIGN_RJES_SU_NGA_RO";
        case   0x0F7F: return "TIBETAN_SIGN_RNAM_BCAD";
        case   0x0F80: return "TIBETAN_VOWEL_SIGN_REVERSED_I";
        case   0x0F81: return "TIBETAN_VOWEL_SIGN_REVERSED_II";
        case   0x0F82: return "TIBETAN_SIGN_NYI_ZLA_NAA_DA";
        case   0x0F83: return "TIBETAN_SIGN_SNA_LDAN";
        case   0x0F84: return "TIBETAN_MARK_HALANTA";
        case   0x0F85: return "TIBETAN_MARK_PALUTA";
        case   0x0F86: return "TIBETAN_SIGN_LCI_RTAGS";
        case   0x0F87: return "TIBETAN_SIGN_YANG_RTAGS";
        case   0x0F88: return "TIBETAN_SIGN_LCE_TSA_CAN";
        case   0x0F89: return "TIBETAN_SIGN_MCHU_CAN";
        case   0x0F8A: return "TIBETAN_SIGN_GRU_CAN_RGYINGS";
        case   0x0F8B: return "TIBETAN_SIGN_GRU_MED_RGYINGS";
        case   0x0F8C: return "TIBETAN_SIGN_INVERTED_MCHU_CAN";
        case   0x0F8D: return "TIBETAN_SUBJOINED_SIGN_LCE_TSA_CAN";
        case   0x0F8E: return "TIBETAN_SUBJOINED_SIGN_MCHU_CAN";
        case   0x0F8F: return "TIBETAN_SUBJOINED_SIGN_INVERTED_MCHU_CAN";
        case   0x0F90: return "TIBETAN_SUBJOINED_LETTER_KA";
        case   0x0F91: return "TIBETAN_SUBJOINED_LETTER_KHA";
        case   0x0F92: return "TIBETAN_SUBJOINED_LETTER_GA";
        case   0x0F93: return "TIBETAN_SUBJOINED_LETTER_GHA";
        case   0x0F94: return "TIBETAN_SUBJOINED_LETTER_NGA";
        case   0x0F95: return "TIBETAN_SUBJOINED_LETTER_CA";
        case   0x0F96: return "TIBETAN_SUBJOINED_LETTER_CHA";
        case   0x0F97: return "TIBETAN_SUBJOINED_LETTER_JA";
        case   0x0F99: return "TIBETAN_SUBJOINED_LETTER_NYA";
        case   0x0F9A: return "TIBETAN_SUBJOINED_LETTER_TTA";
        case   0x0F9B: return "TIBETAN_SUBJOINED_LETTER_TTHA";
        case   0x0F9C: return "TIBETAN_SUBJOINED_LETTER_DDA";
        case   0x0F9D: return "TIBETAN_SUBJOINED_LETTER_DDHA";
        case   0x0F9E: return "TIBETAN_SUBJOINED_LETTER_NNA";
        case   0x0F9F: return "TIBETAN_SUBJOINED_LETTER_TA";
        case   0x0FA0: return "TIBETAN_SUBJOINED_LETTER_THA";
        case   0x0FA1: return "TIBETAN_SUBJOINED_LETTER_DA";
        case   0x0FA2: return "TIBETAN_SUBJOINED_LETTER_DHA";
        case   0x0FA3: return "TIBETAN_SUBJOINED_LETTER_NA";
        case   0x0FA4: return "TIBETAN_SUBJOINED_LETTER_PA";
        case   0x0FA5: return "TIBETAN_SUBJOINED_LETTER_PHA";
        case   0x0FA6: return "TIBETAN_SUBJOINED_LETTER_BA";
        case   0x0FA7: return "TIBETAN_SUBJOINED_LETTER_BHA";
        case   0x0FA8: return "TIBETAN_SUBJOINED_LETTER_MA";
        case   0x0FA9: return "TIBETAN_SUBJOINED_LETTER_TSA";
        case   0x0FAA: return "TIBETAN_SUBJOINED_LETTER_TSHA";
        case   0x0FAB: return "TIBETAN_SUBJOINED_LETTER_DZA";
        case   0x0FAC: return "TIBETAN_SUBJOINED_LETTER_DZHA";
        case   0x0FAD: return "TIBETAN_SUBJOINED_LETTER_WA";
        case   0x0FAE: return "TIBETAN_SUBJOINED_LETTER_ZHA";
        case   0x0FAF: return "TIBETAN_SUBJOINED_LETTER_ZA";
        case   0x0FB0: return "TIBETAN_SUBJOINED_LETTER__A";
        case   0x0FB1: return "TIBETAN_SUBJOINED_LETTER_YA";
        case   0x0FB2: return "TIBETAN_SUBJOINED_LETTER_RA";
        case   0x0FB3: return "TIBETAN_SUBJOINED_LETTER_LA";
        case   0x0FB4: return "TIBETAN_SUBJOINED_LETTER_SHA";
        case   0x0FB5: return "TIBETAN_SUBJOINED_LETTER_SSA";
        case   0x0FB6: return "TIBETAN_SUBJOINED_LETTER_SA";
        case   0x0FB7: return "TIBETAN_SUBJOINED_LETTER_HA";
        case   0x0FB8: return "TIBETAN_SUBJOINED_LETTER_A";
        case   0x0FB9: return "TIBETAN_SUBJOINED_LETTER_KSSA";
        case   0x0FBA: return "TIBETAN_SUBJOINED_LETTER_FIXED_FORM_WA";
        case   0x0FBB: return "TIBETAN_SUBJOINED_LETTER_FIXED_FORM_YA";
        case   0x0FBC: return "TIBETAN_SUBJOINED_LETTER_FIXED_FORM_RA";
        case   0x0FBE: return "TIBETAN_KU_RU_KHA";
        case   0x0FBF: return "TIBETAN_KU_RU_KHA_BZHI_MIG_CAN";
        case   0x0FC0: return "TIBETAN_CANTILLATION_SIGN_HEAVY_BEAT";
        case   0x0FC1: return "TIBETAN_CANTILLATION_SIGN_LIGHT_BEAT";
        case   0x0FC2: return "TIBETAN_CANTILLATION_SIGN_CANG_TE_U";
        case   0x0FC3: return "TIBETAN_CANTILLATION_SIGN_SBUB__CHAL";
        case   0x0FC4: return "TIBETAN_SYMBOL_DRIL_BU";
        case   0x0FC5: return "TIBETAN_SYMBOL_RDO_RJE";
        case   0x0FC6: return "TIBETAN_SYMBOL_PADMA_GDAN";
        case   0x0FC7: return "TIBETAN_SYMBOL_RDO_RJE_RGYA_GRAM";
        case   0x0FC8: return "TIBETAN_SYMBOL_PHUR_PA";
        case   0x0FC9: return "TIBETAN_SYMBOL_NOR_BU";
        case   0x0FCA: return "TIBETAN_SYMBOL_NOR_BU_NYIS__KHYIL";
        case   0x0FCB: return "TIBETAN_SYMBOL_NOR_BU_GSUM__KHYIL";
        case   0x0FCC: return "TIBETAN_SYMBOL_NOR_BU_BZHI__KHYIL";
        case   0x0FCE: return "TIBETAN_SIGN_RDEL_NAG_RDEL_DKAR";
        case   0x0FCF: return "TIBETAN_SIGN_RDEL_NAG_GSUM";
        case   0x0FD0: return "TIBETAN_MARK_BSKA__SHOG_GI_MGO_RGYAN";
        case   0x0FD1: return "TIBETAN_MARK_MNYAM_YIG_GI_MGO_RGYAN";
        case   0x0FD2: return "TIBETAN_MARK_NYIS_TSHEG";
        case   0x0FD3: return
                "TIBETAN_MARK_INITIAL_BRDA_RNYING_YIG_MGO_MDUN_MA";
        case   0x0FD4: return
                "TIBETAN_MARK_CLOSING_BRDA_RNYING_YIG_MGO_SGAB_MA";
        case   0x0FD5: return "RIGHT_FACING_SVASTI_SIGN";
        case   0x0FD6: return "LEFT_FACING_SVASTI_SIGN";
        case   0x0FD7: return "RIGHT_FACING_SVASTI_SIGN_WITH_DOTS";
        case   0x0FD8: return "LEFT_FACING_SVASTI_SIGN_WITH_DOTS";
        case   0x0FD9: return "TIBETAN_MARK_LEADING_MCHAN_RTAGS";
        case   0x0FDA: return "TIBETAN_MARK_TRAILING_MCHAN_RTAGS";
        case   0x1000: return "MYANMAR_LETTER_KA";
        case   0x1001: return "MYANMAR_LETTER_KHA";
        case   0x1002: return "MYANMAR_LETTER_GA";
        case   0x1003: return "MYANMAR_LETTER_GHA";
        case   0x1004: return "MYANMAR_LETTER_NGA";
        case   0x1005: return "MYANMAR_LETTER_CA";
        case   0x1006: return "MYANMAR_LETTER_CHA";
        case   0x1007: return "MYANMAR_LETTER_JA";
        case   0x1008: return "MYANMAR_LETTER_JHA";
        case   0x1009: return "MYANMAR_LETTER_NYA";
        case   0x100A: return "MYANMAR_LETTER_NNYA";
        case   0x100B: return "MYANMAR_LETTER_TTA";
        case   0x100C: return "MYANMAR_LETTER_TTHA";
        case   0x100D: return "MYANMAR_LETTER_DDA";
        case   0x100E: return "MYANMAR_LETTER_DDHA";
        case   0x100F: return "MYANMAR_LETTER_NNA";
        case   0x1010: return "MYANMAR_LETTER_TA";
        case   0x1011: return "MYANMAR_LETTER_THA";
        case   0x1012: return "MYANMAR_LETTER_DA";
        case   0x1013: return "MYANMAR_LETTER_DHA";
        case   0x1014: return "MYANMAR_LETTER_NA";
        case   0x1015: return "MYANMAR_LETTER_PA";
        case   0x1016: return "MYANMAR_LETTER_PHA";
        case   0x1017: return "MYANMAR_LETTER_BA";
        case   0x1018: return "MYANMAR_LETTER_BHA";
        case   0x1019: return "MYANMAR_LETTER_MA";
        case   0x101A: return "MYANMAR_LETTER_YA";
        case   0x101B: return "MYANMAR_LETTER_RA";
        case   0x101C: return "MYANMAR_LETTER_LA";
        case   0x101D: return "MYANMAR_LETTER_WA";
        case   0x101E: return "MYANMAR_LETTER_SA";
        case   0x101F: return "MYANMAR_LETTER_HA";
        case   0x1020: return "MYANMAR_LETTER_LLA";
        case   0x1021: return "MYANMAR_LETTER_A";
        case   0x1022: return "MYANMAR_LETTER_SHAN_A";
        case   0x1023: return "MYANMAR_LETTER_I";
        case   0x1024: return "MYANMAR_LETTER_II";
        case   0x1025: return "MYANMAR_LETTER_U";
        case   0x1026: return "MYANMAR_LETTER_UU";
        case   0x1027: return "MYANMAR_LETTER_E";
        case   0x1028: return "MYANMAR_LETTER_MON_E";
        case   0x1029: return "MYANMAR_LETTER_O";
        case   0x102A: return "MYANMAR_LETTER_AU";
        case   0x102B: return "MYANMAR_VOWEL_SIGN_TALL_AA";
        case   0x102C: return "MYANMAR_VOWEL_SIGN_AA";
        case   0x102D: return "MYANMAR_VOWEL_SIGN_I";
        case   0x102E: return "MYANMAR_VOWEL_SIGN_II";
        case   0x102F: return "MYANMAR_VOWEL_SIGN_U";
        case   0x1030: return "MYANMAR_VOWEL_SIGN_UU";
        case   0x1031: return "MYANMAR_VOWEL_SIGN_E";
        case   0x1032: return "MYANMAR_VOWEL_SIGN_AI";
        case   0x1033: return "MYANMAR_VOWEL_SIGN_MON_II";
        case   0x1034: return "MYANMAR_VOWEL_SIGN_MON_O";
        case   0x1035: return "MYANMAR_VOWEL_SIGN_E_ABOVE";
        case   0x1036: return "MYANMAR_SIGN_ANUSVARA";
        case   0x1037: return "MYANMAR_SIGN_DOT_BELOW";
        case   0x1038: return "MYANMAR_SIGN_VISARGA";
        case   0x1039: return "MYANMAR_SIGN_VIRAMA";
        case   0x103A: return "MYANMAR_SIGN_ASAT";
        case   0x103B: return "MYANMAR_CONSONANT_SIGN_MEDIAL_YA";
        case   0x103C: return "MYANMAR_CONSONANT_SIGN_MEDIAL_RA";
        case   0x103D: return "MYANMAR_CONSONANT_SIGN_MEDIAL_WA";
        case   0x103E: return "MYANMAR_CONSONANT_SIGN_MEDIAL_HA";
        case   0x103F: return "MYANMAR_LETTER_GREAT_SA";
        case   0x1040: return "MYANMAR_DIGIT_ZERO";
        case   0x1041: return "MYANMAR_DIGIT_ONE";
        case   0x1042: return "MYANMAR_DIGIT_TWO";
        case   0x1043: return "MYANMAR_DIGIT_THREE";
        case   0x1044: return "MYANMAR_DIGIT_FOUR";
        case   0x1045: return "MYANMAR_DIGIT_FIVE";
        case   0x1046: return "MYANMAR_DIGIT_SIX";
        case   0x1047: return "MYANMAR_DIGIT_SEVEN";
        case   0x1048: return "MYANMAR_DIGIT_EIGHT";
        case   0x1049: return "MYANMAR_DIGIT_NINE";
        case   0x104A: return "MYANMAR_SIGN_LITTLE_SECTION";
        case   0x104B: return "MYANMAR_SIGN_SECTION";
        case   0x104C: return "MYANMAR_SYMBOL_LOCATIVE";
        case   0x104D: return "MYANMAR_SYMBOL_COMPLETED";
        case   0x104E: return "MYANMAR_SYMBOL_AFOREMENTIONED";
        case   0x104F: return "MYANMAR_SYMBOL_GENITIVE";
        case   0x1050: return "MYANMAR_LETTER_SHA";
        case   0x1051: return "MYANMAR_LETTER_SSA";
        case   0x1052: return "MYANMAR_LETTER_VOCALIC_R";
        case   0x1053: return "MYANMAR_LETTER_VOCALIC_RR";
        case   0x1054: return "MYANMAR_LETTER_VOCALIC_L";
        case   0x1055: return "MYANMAR_LETTER_VOCALIC_LL";
        case   0x1056: return "MYANMAR_VOWEL_SIGN_VOCALIC_R";
        case   0x1057: return "MYANMAR_VOWEL_SIGN_VOCALIC_RR";
        case   0x1058: return "MYANMAR_VOWEL_SIGN_VOCALIC_L";
        case   0x1059: return "MYANMAR_VOWEL_SIGN_VOCALIC_LL";
        case   0x105A: return "MYANMAR_LETTER_MON_NGA";
        case   0x105B: return "MYANMAR_LETTER_MON_JHA";
        case   0x105C: return "MYANMAR_LETTER_MON_BBA";
        case   0x105D: return "MYANMAR_LETTER_MON_BBE";
        case   0x105E: return "MYANMAR_CONSONANT_SIGN_MON_MEDIAL_NA";
        case   0x105F: return "MYANMAR_CONSONANT_SIGN_MON_MEDIAL_MA";
        case   0x1060: return "MYANMAR_CONSONANT_SIGN_MON_MEDIAL_LA";
        case   0x1061: return "MYANMAR_LETTER_SGAW_KAREN_SHA";
        case   0x1062: return "MYANMAR_VOWEL_SIGN_SGAW_KAREN_EU";
        case   0x1063: return "MYANMAR_TONE_MARK_SGAW_KAREN_HATHI";
        case   0x1064: return "MYANMAR_TONE_MARK_SGAW_KAREN_KE_PHO";
        case   0x1065: return "MYANMAR_LETTER_WESTERN_PWO_KAREN_THA";
        case   0x1066: return "MYANMAR_LETTER_WESTERN_PWO_KAREN_PWA";
        case   0x1067: return "MYANMAR_VOWEL_SIGN_WESTERN_PWO_KAREN_EU";
        case   0x1068: return "MYANMAR_VOWEL_SIGN_WESTERN_PWO_KAREN_UE";
        case   0x1069: return "MYANMAR_SIGN_WESTERN_PWO_KAREN_TONE_1";
        case   0x106A: return "MYANMAR_SIGN_WESTERN_PWO_KAREN_TONE_2";
        case   0x106B: return "MYANMAR_SIGN_WESTERN_PWO_KAREN_TONE_3";
        case   0x106C: return "MYANMAR_SIGN_WESTERN_PWO_KAREN_TONE_4";
        case   0x106D: return "MYANMAR_SIGN_WESTERN_PWO_KAREN_TONE_5";
        case   0x106E: return "MYANMAR_LETTER_EASTERN_PWO_KAREN_NNA";
        case   0x106F: return "MYANMAR_LETTER_EASTERN_PWO_KAREN_YWA";
        case   0x1070: return "MYANMAR_LETTER_EASTERN_PWO_KAREN_GHWA";
        case   0x1071: return "MYANMAR_VOWEL_SIGN_GEBA_KAREN_I";
        case   0x1072: return "MYANMAR_VOWEL_SIGN_KAYAH_OE";
        case   0x1073: return "MYANMAR_VOWEL_SIGN_KAYAH_U";
        case   0x1074: return "MYANMAR_VOWEL_SIGN_KAYAH_EE";
        case   0x1075: return "MYANMAR_LETTER_SHAN_KA";
        case   0x1076: return "MYANMAR_LETTER_SHAN_KHA";
        case   0x1077: return "MYANMAR_LETTER_SHAN_GA";
        case   0x1078: return "MYANMAR_LETTER_SHAN_CA";
        case   0x1079: return "MYANMAR_LETTER_SHAN_ZA";
        case   0x107A: return "MYANMAR_LETTER_SHAN_NYA";
        case   0x107B: return "MYANMAR_LETTER_SHAN_DA";
        case   0x107C: return "MYANMAR_LETTER_SHAN_NA";
        case   0x107D: return "MYANMAR_LETTER_SHAN_PHA";
        case   0x107E: return "MYANMAR_LETTER_SHAN_FA";
        case   0x107F: return "MYANMAR_LETTER_SHAN_BA";
        case   0x1080: return "MYANMAR_LETTER_SHAN_THA";
        case   0x1081: return "MYANMAR_LETTER_SHAN_HA";
        case   0x1082: return "MYANMAR_CONSONANT_SIGN_SHAN_MEDIAL_WA";
        case   0x1083: return "MYANMAR_VOWEL_SIGN_SHAN_AA";
        case   0x1084: return "MYANMAR_VOWEL_SIGN_SHAN_E";
        case   0x1085: return "MYANMAR_VOWEL_SIGN_SHAN_E_ABOVE";
        case   0x1086: return "MYANMAR_VOWEL_SIGN_SHAN_FINAL_Y";
        case   0x1087: return "MYANMAR_SIGN_SHAN_TONE_2";
        case   0x1088: return "MYANMAR_SIGN_SHAN_TONE_3";
        case   0x1089: return "MYANMAR_SIGN_SHAN_TONE_5";
        case   0x108A: return "MYANMAR_SIGN_SHAN_TONE_6";
        case   0x108B: return "MYANMAR_SIGN_SHAN_COUNCIL_TONE_2";
        case   0x108C: return "MYANMAR_SIGN_SHAN_COUNCIL_TONE_3";
        case   0x108D: return "MYANMAR_SIGN_SHAN_COUNCIL_EMPHATIC_TONE";
        case   0x108E: return "MYANMAR_LETTER_RUMAI_PALAUNG_FA";
        case   0x108F: return "MYANMAR_SIGN_RUMAI_PALAUNG_TONE_5";
        case   0x1090: return "MYANMAR_SHAN_DIGIT_ZERO";
        case   0x1091: return "MYANMAR_SHAN_DIGIT_ONE";
        case   0x1092: return "MYANMAR_SHAN_DIGIT_TWO";
        case   0x1093: return "MYANMAR_SHAN_DIGIT_THREE";
        case   0x1094: return "MYANMAR_SHAN_DIGIT_FOUR";
        case   0x1095: return "MYANMAR_SHAN_DIGIT_FIVE";
        case   0x1096: return "MYANMAR_SHAN_DIGIT_SIX";
        case   0x1097: return "MYANMAR_SHAN_DIGIT_SEVEN";
        case   0x1098: return "MYANMAR_SHAN_DIGIT_EIGHT";
        case   0x1099: return "MYANMAR_SHAN_DIGIT_NINE";
        case   0x109A: return "MYANMAR_SIGN_KHAMTI_TONE_1";
        case   0x109B: return "MYANMAR_SIGN_KHAMTI_TONE_3";
        case   0x109C: return "MYANMAR_VOWEL_SIGN_AITON_A";
        case   0x109D: return "MYANMAR_VOWEL_SIGN_AITON_AI";
        case   0x109E: return "MYANMAR_SYMBOL_SHAN_ONE";
        case   0x109F: return "MYANMAR_SYMBOL_SHAN_EXCLAMATION";
        case   0x10A0: return "GEORGIAN_CAPITAL_LETTER_AN";
        case   0x10A1: return "GEORGIAN_CAPITAL_LETTER_BAN";
        case   0x10A2: return "GEORGIAN_CAPITAL_LETTER_GAN";
        case   0x10A3: return "GEORGIAN_CAPITAL_LETTER_DON";
        case   0x10A4: return "GEORGIAN_CAPITAL_LETTER_EN";
        case   0x10A5: return "GEORGIAN_CAPITAL_LETTER_VIN";
        case   0x10A6: return "GEORGIAN_CAPITAL_LETTER_ZEN";
        case   0x10A7: return "GEORGIAN_CAPITAL_LETTER_TAN";
        case   0x10A8: return "GEORGIAN_CAPITAL_LETTER_IN";
        case   0x10A9: return "GEORGIAN_CAPITAL_LETTER_KAN";
        case   0x10AA: return "GEORGIAN_CAPITAL_LETTER_LAS";
        case   0x10AB: return "GEORGIAN_CAPITAL_LETTER_MAN";
        case   0x10AC: return "GEORGIAN_CAPITAL_LETTER_NAR";
        case   0x10AD: return "GEORGIAN_CAPITAL_LETTER_ON";
        case   0x10AE: return "GEORGIAN_CAPITAL_LETTER_PAR";
        case   0x10AF: return "GEORGIAN_CAPITAL_LETTER_ZHAR";
        case   0x10B0: return "GEORGIAN_CAPITAL_LETTER_RAE";
        case   0x10B1: return "GEORGIAN_CAPITAL_LETTER_SAN";
        case   0x10B2: return "GEORGIAN_CAPITAL_LETTER_TAR";
        case   0x10B3: return "GEORGIAN_CAPITAL_LETTER_UN";
        case   0x10B4: return "GEORGIAN_CAPITAL_LETTER_PHAR";
        case   0x10B5: return "GEORGIAN_CAPITAL_LETTER_KHAR";
        case   0x10B6: return "GEORGIAN_CAPITAL_LETTER_GHAN";
        case   0x10B7: return "GEORGIAN_CAPITAL_LETTER_QAR";
        case   0x10B8: return "GEORGIAN_CAPITAL_LETTER_SHIN";
        case   0x10B9: return "GEORGIAN_CAPITAL_LETTER_CHIN";
        case   0x10BA: return "GEORGIAN_CAPITAL_LETTER_CAN";
        case   0x10BB: return "GEORGIAN_CAPITAL_LETTER_JIL";
        case   0x10BC: return "GEORGIAN_CAPITAL_LETTER_CIL";
        case   0x10BD: return "GEORGIAN_CAPITAL_LETTER_CHAR";
        case   0x10BE: return "GEORGIAN_CAPITAL_LETTER_XAN";
        case   0x10BF: return "GEORGIAN_CAPITAL_LETTER_JHAN";
        case   0x10C0: return "GEORGIAN_CAPITAL_LETTER_HAE";
        case   0x10C1: return "GEORGIAN_CAPITAL_LETTER_HE";
        case   0x10C2: return "GEORGIAN_CAPITAL_LETTER_HIE";
        case   0x10C3: return "GEORGIAN_CAPITAL_LETTER_WE";
        case   0x10C4: return "GEORGIAN_CAPITAL_LETTER_HAR";
        case   0x10C5: return "GEORGIAN_CAPITAL_LETTER_HOE";
        case   0x10C7: return "GEORGIAN_CAPITAL_LETTER_YN";
        case   0x10CD: return "GEORGIAN_CAPITAL_LETTER_AEN";
        case   0x10D0: return "GEORGIAN_LETTER_AN";
        case   0x10D1: return "GEORGIAN_LETTER_BAN";
        case   0x10D2: return "GEORGIAN_LETTER_GAN";
        case   0x10D3: return "GEORGIAN_LETTER_DON";
        case   0x10D4: return "GEORGIAN_LETTER_EN";
        case   0x10D5: return "GEORGIAN_LETTER_VIN";
        case   0x10D6: return "GEORGIAN_LETTER_ZEN";
        case   0x10D7: return "GEORGIAN_LETTER_TAN";
        case   0x10D8: return "GEORGIAN_LETTER_IN";
        case   0x10D9: return "GEORGIAN_LETTER_KAN";
        case   0x10DA: return "GEORGIAN_LETTER_LAS";
        case   0x10DB: return "GEORGIAN_LETTER_MAN";
        case   0x10DC: return "GEORGIAN_LETTER_NAR";
        case   0x10DD: return "GEORGIAN_LETTER_ON";
        case   0x10DE: return "GEORGIAN_LETTER_PAR";
        case   0x10DF: return "GEORGIAN_LETTER_ZHAR";
        case   0x10E0: return "GEORGIAN_LETTER_RAE";
        case   0x10E1: return "GEORGIAN_LETTER_SAN";
        case   0x10E2: return "GEORGIAN_LETTER_TAR";
        case   0x10E3: return "GEORGIAN_LETTER_UN";
        case   0x10E4: return "GEORGIAN_LETTER_PHAR";
        case   0x10E5: return "GEORGIAN_LETTER_KHAR";
        case   0x10E6: return "GEORGIAN_LETTER_GHAN";
        case   0x10E7: return "GEORGIAN_LETTER_QAR";
        case   0x10E8: return "GEORGIAN_LETTER_SHIN";
        case   0x10E9: return "GEORGIAN_LETTER_CHIN";
        case   0x10EA: return "GEORGIAN_LETTER_CAN";
        case   0x10EB: return "GEORGIAN_LETTER_JIL";
        case   0x10EC: return "GEORGIAN_LETTER_CIL";
        case   0x10ED: return "GEORGIAN_LETTER_CHAR";
        case   0x10EE: return "GEORGIAN_LETTER_XAN";
        case   0x10EF: return "GEORGIAN_LETTER_JHAN";
        case   0x10F0: return "GEORGIAN_LETTER_HAE";
        case   0x10F1: return "GEORGIAN_LETTER_HE";
        case   0x10F2: return "GEORGIAN_LETTER_HIE";
        case   0x10F3: return "GEORGIAN_LETTER_WE";
        case   0x10F4: return "GEORGIAN_LETTER_HAR";
        case   0x10F5: return "GEORGIAN_LETTER_HOE";
        case   0x10F6: return "GEORGIAN_LETTER_FI";
        case   0x10F7: return "GEORGIAN_LETTER_YN";
        case   0x10F8: return "GEORGIAN_LETTER_ELIFI";
        case   0x10F9: return "GEORGIAN_LETTER_TURNED_GAN";
        case   0x10FA: return "GEORGIAN_LETTER_AIN";
        case   0x10FB: return "GEORGIAN_PARAGRAPH_SEPARATOR";
        case   0x10FC: return "MODIFIER_LETTER_GEORGIAN_NAR";
        case   0x10FD: return "GEORGIAN_LETTER_AEN";
        case   0x10FE: return "GEORGIAN_LETTER_HARD_SIGN";
        case   0x10FF: return "GEORGIAN_LETTER_LABIAL_SIGN";
        case   0x1100: return "HANGUL_CHOSEONG_KIYEOK";
        case   0x1101: return "HANGUL_CHOSEONG_SSANGKIYEOK";
        case   0x1102: return "HANGUL_CHOSEONG_NIEUN";
        case   0x1103: return "HANGUL_CHOSEONG_TIKEUT";
        case   0x1104: return "HANGUL_CHOSEONG_SSANGTIKEUT";
        case   0x1105: return "HANGUL_CHOSEONG_RIEUL";
        case   0x1106: return "HANGUL_CHOSEONG_MIEUM";
        case   0x1107: return "HANGUL_CHOSEONG_PIEUP";
        case   0x1108: return "HANGUL_CHOSEONG_SSANGPIEUP";
        case   0x1109: return "HANGUL_CHOSEONG_SIOS";
        case   0x110A: return "HANGUL_CHOSEONG_SSANGSIOS";
        case   0x110B: return "HANGUL_CHOSEONG_IEUNG";
        case   0x110C: return "HANGUL_CHOSEONG_CIEUC";
        case   0x110D: return "HANGUL_CHOSEONG_SSANGCIEUC";
        case   0x110E: return "HANGUL_CHOSEONG_CHIEUCH";
        case   0x110F: return "HANGUL_CHOSEONG_KHIEUKH";
        case   0x1110: return "HANGUL_CHOSEONG_THIEUTH";
        case   0x1111: return "HANGUL_CHOSEONG_PHIEUPH";
        case   0x1112: return "HANGUL_CHOSEONG_HIEUH";
        case   0x1113: return "HANGUL_CHOSEONG_NIEUN_KIYEOK";
        case   0x1114: return "HANGUL_CHOSEONG_SSANGNIEUN";
        case   0x1115: return "HANGUL_CHOSEONG_NIEUN_TIKEUT";
        case   0x1116: return "HANGUL_CHOSEONG_NIEUN_PIEUP";
        case   0x1117: return "HANGUL_CHOSEONG_TIKEUT_KIYEOK";
        case   0x1118: return "HANGUL_CHOSEONG_RIEUL_NIEUN";
        case   0x1119: return "HANGUL_CHOSEONG_SSANGRIEUL";
        case   0x111A: return "HANGUL_CHOSEONG_RIEUL_HIEUH";
        case   0x111B: return "HANGUL_CHOSEONG_KAPYEOUNRIEUL";
        case   0x111C: return "HANGUL_CHOSEONG_MIEUM_PIEUP";
        case   0x111D: return "HANGUL_CHOSEONG_KAPYEOUNMIEUM";
        case   0x111E: return "HANGUL_CHOSEONG_PIEUP_KIYEOK";
        case   0x111F: return "HANGUL_CHOSEONG_PIEUP_NIEUN";
        case   0x1120: return "HANGUL_CHOSEONG_PIEUP_TIKEUT";
        case   0x1121: return "HANGUL_CHOSEONG_PIEUP_SIOS";
        case   0x1122: return "HANGUL_CHOSEONG_PIEUP_SIOS_KIYEOK";
        case   0x1123: return "HANGUL_CHOSEONG_PIEUP_SIOS_TIKEUT";
        case   0x1124: return "HANGUL_CHOSEONG_PIEUP_SIOS_PIEUP";
        case   0x1125: return "HANGUL_CHOSEONG_PIEUP_SSANGSIOS";
        case   0x1126: return "HANGUL_CHOSEONG_PIEUP_SIOS_CIEUC";
        case   0x1127: return "HANGUL_CHOSEONG_PIEUP_CIEUC";
        case   0x1128: return "HANGUL_CHOSEONG_PIEUP_CHIEUCH";
        case   0x1129: return "HANGUL_CHOSEONG_PIEUP_THIEUTH";
        case   0x112A: return "HANGUL_CHOSEONG_PIEUP_PHIEUPH";
        case   0x112B: return "HANGUL_CHOSEONG_KAPYEOUNPIEUP";
        case   0x112C: return "HANGUL_CHOSEONG_KAPYEOUNSSANGPIEUP";
        case   0x112D: return "HANGUL_CHOSEONG_SIOS_KIYEOK";
        case   0x112E: return "HANGUL_CHOSEONG_SIOS_NIEUN";
        case   0x112F: return "HANGUL_CHOSEONG_SIOS_TIKEUT";
        case   0x1130: return "HANGUL_CHOSEONG_SIOS_RIEUL";
        case   0x1131: return "HANGUL_CHOSEONG_SIOS_MIEUM";
        case   0x1132: return "HANGUL_CHOSEONG_SIOS_PIEUP";
        case   0x1133: return "HANGUL_CHOSEONG_SIOS_PIEUP_KIYEOK";
        case   0x1134: return "HANGUL_CHOSEONG_SIOS_SSANGSIOS";
        case   0x1135: return "HANGUL_CHOSEONG_SIOS_IEUNG";
        case   0x1136: return "HANGUL_CHOSEONG_SIOS_CIEUC";
        case   0x1137: return "HANGUL_CHOSEONG_SIOS_CHIEUCH";
        case   0x1138: return "HANGUL_CHOSEONG_SIOS_KHIEUKH";
        case   0x1139: return "HANGUL_CHOSEONG_SIOS_THIEUTH";
        case   0x113A: return "HANGUL_CHOSEONG_SIOS_PHIEUPH";
        case   0x113B: return "HANGUL_CHOSEONG_SIOS_HIEUH";
        case   0x113C: return "HANGUL_CHOSEONG_CHITUEUMSIOS";
        case   0x113D: return "HANGUL_CHOSEONG_CHITUEUMSSANGSIOS";
        case   0x113E: return "HANGUL_CHOSEONG_CEONGCHIEUMSIOS";
        case   0x113F: return "HANGUL_CHOSEONG_CEONGCHIEUMSSANGSIOS";
        case   0x1140: return "HANGUL_CHOSEONG_PANSIOS";
        case   0x1141: return "HANGUL_CHOSEONG_IEUNG_KIYEOK";
        case   0x1142: return "HANGUL_CHOSEONG_IEUNG_TIKEUT";
        case   0x1143: return "HANGUL_CHOSEONG_IEUNG_MIEUM";
        case   0x1144: return "HANGUL_CHOSEONG_IEUNG_PIEUP";
        case   0x1145: return "HANGUL_CHOSEONG_IEUNG_SIOS";
        case   0x1146: return "HANGUL_CHOSEONG_IEUNG_PANSIOS";
        case   0x1147: return "HANGUL_CHOSEONG_SSANGIEUNG";
        case   0x1148: return "HANGUL_CHOSEONG_IEUNG_CIEUC";
        case   0x1149: return "HANGUL_CHOSEONG_IEUNG_CHIEUCH";
        case   0x114A: return "HANGUL_CHOSEONG_IEUNG_THIEUTH";
        case   0x114B: return "HANGUL_CHOSEONG_IEUNG_PHIEUPH";
        case   0x114C: return "HANGUL_CHOSEONG_YESIEUNG";
        case   0x114D: return "HANGUL_CHOSEONG_CIEUC_IEUNG";
        case   0x114E: return "HANGUL_CHOSEONG_CHITUEUMCIEUC";
        case   0x114F: return "HANGUL_CHOSEONG_CHITUEUMSSANGCIEUC";
        case   0x1150: return "HANGUL_CHOSEONG_CEONGCHIEUMCIEUC";
        case   0x1151: return "HANGUL_CHOSEONG_CEONGCHIEUMSSANGCIEUC";
        case   0x1152: return "HANGUL_CHOSEONG_CHIEUCH_KHIEUKH";
        case   0x1153: return "HANGUL_CHOSEONG_CHIEUCH_HIEUH";
        case   0x1154: return "HANGUL_CHOSEONG_CHITUEUMCHIEUCH";
        case   0x1155: return "HANGUL_CHOSEONG_CEONGCHIEUMCHIEUCH";
        case   0x1156: return "HANGUL_CHOSEONG_PHIEUPH_PIEUP";
        case   0x1157: return "HANGUL_CHOSEONG_KAPYEOUNPHIEUPH";
        case   0x1158: return "HANGUL_CHOSEONG_SSANGHIEUH";
        case   0x1159: return "HANGUL_CHOSEONG_YEORINHIEUH";
        case   0x115A: return "HANGUL_CHOSEONG_KIYEOK_TIKEUT";
        case   0x115B: return "HANGUL_CHOSEONG_NIEUN_SIOS";
        case   0x115C: return "HANGUL_CHOSEONG_NIEUN_CIEUC";
        case   0x115D: return "HANGUL_CHOSEONG_NIEUN_HIEUH";
        case   0x115E: return "HANGUL_CHOSEONG_TIKEUT_RIEUL";
        case   0x115F: return "HANGUL_CHOSEONG_FILLER";
        case   0x1160: return "HANGUL_JUNGSEONG_FILLER";
        case   0x1161: return "HANGUL_JUNGSEONG_A";
        case   0x1162: return "HANGUL_JUNGSEONG_AE";
        case   0x1163: return "HANGUL_JUNGSEONG_YA";
        case   0x1164: return "HANGUL_JUNGSEONG_YAE";
        case   0x1165: return "HANGUL_JUNGSEONG_EO";
        case   0x1166: return "HANGUL_JUNGSEONG_E";
        case   0x1167: return "HANGUL_JUNGSEONG_YEO";
        case   0x1168: return "HANGUL_JUNGSEONG_YE";
        case   0x1169: return "HANGUL_JUNGSEONG_O";
        case   0x116A: return "HANGUL_JUNGSEONG_WA";
        case   0x116B: return "HANGUL_JUNGSEONG_WAE";
        case   0x116C: return "HANGUL_JUNGSEONG_OE";
        case   0x116D: return "HANGUL_JUNGSEONG_YO";
        case   0x116E: return "HANGUL_JUNGSEONG_U";
        case   0x116F: return "HANGUL_JUNGSEONG_WEO";
        case   0x1170: return "HANGUL_JUNGSEONG_WE";
        case   0x1171: return "HANGUL_JUNGSEONG_WI";
        case   0x1172: return "HANGUL_JUNGSEONG_YU";
        case   0x1173: return "HANGUL_JUNGSEONG_EU";
        case   0x1174: return "HANGUL_JUNGSEONG_YI";
        case   0x1175: return "HANGUL_JUNGSEONG_I";
        case   0x1176: return "HANGUL_JUNGSEONG_A_O";
        case   0x1177: return "HANGUL_JUNGSEONG_A_U";
        case   0x1178: return "HANGUL_JUNGSEONG_YA_O";
        case   0x1179: return "HANGUL_JUNGSEONG_YA_YO";
        case   0x117A: return "HANGUL_JUNGSEONG_EO_O";
        case   0x117B: return "HANGUL_JUNGSEONG_EO_U";
        case   0x117C: return "HANGUL_JUNGSEONG_EO_EU";
        case   0x117D: return "HANGUL_JUNGSEONG_YEO_O";
        case   0x117E: return "HANGUL_JUNGSEONG_YEO_U";
        case   0x117F: return "HANGUL_JUNGSEONG_O_EO";
        case   0x1180: return "HANGUL_JUNGSEONG_O_E";
        case   0x1181: return "HANGUL_JUNGSEONG_O_YE";
        case   0x1182: return "HANGUL_JUNGSEONG_O_O";
        case   0x1183: return "HANGUL_JUNGSEONG_O_U";
        case   0x1184: return "HANGUL_JUNGSEONG_YO_YA";
        case   0x1185: return "HANGUL_JUNGSEONG_YO_YAE";
        case   0x1186: return "HANGUL_JUNGSEONG_YO_YEO";
        case   0x1187: return "HANGUL_JUNGSEONG_YO_O";
        case   0x1188: return "HANGUL_JUNGSEONG_YO_I";
        case   0x1189: return "HANGUL_JUNGSEONG_U_A";
        case   0x118A: return "HANGUL_JUNGSEONG_U_AE";
        case   0x118B: return "HANGUL_JUNGSEONG_U_EO_EU";
        case   0x118C: return "HANGUL_JUNGSEONG_U_YE";
        case   0x118D: return "HANGUL_JUNGSEONG_U_U";
        case   0x118E: return "HANGUL_JUNGSEONG_YU_A";
        case   0x118F: return "HANGUL_JUNGSEONG_YU_EO";
        case   0x1190: return "HANGUL_JUNGSEONG_YU_E";
        case   0x1191: return "HANGUL_JUNGSEONG_YU_YEO";
        case   0x1192: return "HANGUL_JUNGSEONG_YU_YE";
        case   0x1193: return "HANGUL_JUNGSEONG_YU_U";
        case   0x1194: return "HANGUL_JUNGSEONG_YU_I";
        case   0x1195: return "HANGUL_JUNGSEONG_EU_U";
        case   0x1196: return "HANGUL_JUNGSEONG_EU_EU";
        case   0x1197: return "HANGUL_JUNGSEONG_YI_U";
        case   0x1198: return "HANGUL_JUNGSEONG_I_A";
        case   0x1199: return "HANGUL_JUNGSEONG_I_YA";
        case   0x119A: return "HANGUL_JUNGSEONG_I_O";
        case   0x119B: return "HANGUL_JUNGSEONG_I_U";
        case   0x119C: return "HANGUL_JUNGSEONG_I_EU";
        case   0x119D: return "HANGUL_JUNGSEONG_I_ARAEA";
        case   0x119E: return "HANGUL_JUNGSEONG_ARAEA";
        case   0x119F: return "HANGUL_JUNGSEONG_ARAEA_EO";
        case   0x11A0: return "HANGUL_JUNGSEONG_ARAEA_U";
        case   0x11A1: return "HANGUL_JUNGSEONG_ARAEA_I";
        case   0x11A2: return "HANGUL_JUNGSEONG_SSANGARAEA";
        case   0x11A3: return "HANGUL_JUNGSEONG_A_EU";
        case   0x11A4: return "HANGUL_JUNGSEONG_YA_U";
        case   0x11A5: return "HANGUL_JUNGSEONG_YEO_YA";
        case   0x11A6: return "HANGUL_JUNGSEONG_O_YA";
        case   0x11A7: return "HANGUL_JUNGSEONG_O_YAE";
        case   0x11A8: return "HANGUL_JONGSEONG_KIYEOK";
        case   0x11A9: return "HANGUL_JONGSEONG_SSANGKIYEOK";
        case   0x11AA: return "HANGUL_JONGSEONG_KIYEOK_SIOS";
        case   0x11AB: return "HANGUL_JONGSEONG_NIEUN";
        case   0x11AC: return "HANGUL_JONGSEONG_NIEUN_CIEUC";
        case   0x11AD: return "HANGUL_JONGSEONG_NIEUN_HIEUH";
        case   0x11AE: return "HANGUL_JONGSEONG_TIKEUT";
        case   0x11AF: return "HANGUL_JONGSEONG_RIEUL";
        case   0x11B0: return "HANGUL_JONGSEONG_RIEUL_KIYEOK";
        case   0x11B1: return "HANGUL_JONGSEONG_RIEUL_MIEUM";
        case   0x11B2: return "HANGUL_JONGSEONG_RIEUL_PIEUP";
        case   0x11B3: return "HANGUL_JONGSEONG_RIEUL_SIOS";
        case   0x11B4: return "HANGUL_JONGSEONG_RIEUL_THIEUTH";
        case   0x11B5: return "HANGUL_JONGSEONG_RIEUL_PHIEUPH";
        case   0x11B6: return "HANGUL_JONGSEONG_RIEUL_HIEUH";
        case   0x11B7: return "HANGUL_JONGSEONG_MIEUM";
        case   0x11B8: return "HANGUL_JONGSEONG_PIEUP";
        case   0x11B9: return "HANGUL_JONGSEONG_PIEUP_SIOS";
        case   0x11BA: return "HANGUL_JONGSEONG_SIOS";
        case   0x11BB: return "HANGUL_JONGSEONG_SSANGSIOS";
        case   0x11BC: return "HANGUL_JONGSEONG_IEUNG";
        case   0x11BD: return "HANGUL_JONGSEONG_CIEUC";
        case   0x11BE: return "HANGUL_JONGSEONG_CHIEUCH";
        case   0x11BF: return "HANGUL_JONGSEONG_KHIEUKH";
        case   0x11C0: return "HANGUL_JONGSEONG_THIEUTH";
        case   0x11C1: return "HANGUL_JONGSEONG_PHIEUPH";
        case   0x11C2: return "HANGUL_JONGSEONG_HIEUH";
        case   0x11C3: return "HANGUL_JONGSEONG_KIYEOK_RIEUL";
        case   0x11C4: return "HANGUL_JONGSEONG_KIYEOK_SIOS_KIYEOK";
        case   0x11C5: return "HANGUL_JONGSEONG_NIEUN_KIYEOK";
        case   0x11C6: return "HANGUL_JONGSEONG_NIEUN_TIKEUT";
        case   0x11C7: return "HANGUL_JONGSEONG_NIEUN_SIOS";
        case   0x11C8: return "HANGUL_JONGSEONG_NIEUN_PANSIOS";
        case   0x11C9: return "HANGUL_JONGSEONG_NIEUN_THIEUTH";
        case   0x11CA: return "HANGUL_JONGSEONG_TIKEUT_KIYEOK";
        case   0x11CB: return "HANGUL_JONGSEONG_TIKEUT_RIEUL";
        case   0x11CC: return "HANGUL_JONGSEONG_RIEUL_KIYEOK_SIOS";
        case   0x11CD: return "HANGUL_JONGSEONG_RIEUL_NIEUN";
        case   0x11CE: return "HANGUL_JONGSEONG_RIEUL_TIKEUT";
        case   0x11CF: return "HANGUL_JONGSEONG_RIEUL_TIKEUT_HIEUH";
        case   0x11D0: return "HANGUL_JONGSEONG_SSANGRIEUL";
        case   0x11D1: return "HANGUL_JONGSEONG_RIEUL_MIEUM_KIYEOK";
        case   0x11D2: return "HANGUL_JONGSEONG_RIEUL_MIEUM_SIOS";
        case   0x11D3: return "HANGUL_JONGSEONG_RIEUL_PIEUP_SIOS";
        case   0x11D4: return "HANGUL_JONGSEONG_RIEUL_PIEUP_HIEUH";
        case   0x11D5: return "HANGUL_JONGSEONG_RIEUL_KAPYEOUNPIEUP";
        case   0x11D6: return "HANGUL_JONGSEONG_RIEUL_SSANGSIOS";
        case   0x11D7: return "HANGUL_JONGSEONG_RIEUL_PANSIOS";
        case   0x11D8: return "HANGUL_JONGSEONG_RIEUL_KHIEUKH";
        case   0x11D9: return "HANGUL_JONGSEONG_RIEUL_YEORINHIEUH";
        case   0x11DA: return "HANGUL_JONGSEONG_MIEUM_KIYEOK";
        case   0x11DB: return "HANGUL_JONGSEONG_MIEUM_RIEUL";
        case   0x11DC: return "HANGUL_JONGSEONG_MIEUM_PIEUP";
        case   0x11DD: return "HANGUL_JONGSEONG_MIEUM_SIOS";
        case   0x11DE: return "HANGUL_JONGSEONG_MIEUM_SSANGSIOS";
        case   0x11DF: return "HANGUL_JONGSEONG_MIEUM_PANSIOS";
        case   0x11E0: return "HANGUL_JONGSEONG_MIEUM_CHIEUCH";
        case   0x11E1: return "HANGUL_JONGSEONG_MIEUM_HIEUH";
        case   0x11E2: return "HANGUL_JONGSEONG_KAPYEOUNMIEUM";
        case   0x11E3: return "HANGUL_JONGSEONG_PIEUP_RIEUL";
        case   0x11E4: return "HANGUL_JONGSEONG_PIEUP_PHIEUPH";
        case   0x11E5: return "HANGUL_JONGSEONG_PIEUP_HIEUH";
        case   0x11E6: return "HANGUL_JONGSEONG_KAPYEOUNPIEUP";
        case   0x11E7: return "HANGUL_JONGSEONG_SIOS_KIYEOK";
        case   0x11E8: return "HANGUL_JONGSEONG_SIOS_TIKEUT";
        case   0x11E9: return "HANGUL_JONGSEONG_SIOS_RIEUL";
        case   0x11EA: return "HANGUL_JONGSEONG_SIOS_PIEUP";
        case   0x11EB: return "HANGUL_JONGSEONG_PANSIOS";
        case   0x11EC: return "HANGUL_JONGSEONG_IEUNG_KIYEOK";
        case   0x11ED: return "HANGUL_JONGSEONG_IEUNG_SSANGKIYEOK";
        case   0x11EE: return "HANGUL_JONGSEONG_SSANGIEUNG";
        case   0x11EF: return "HANGUL_JONGSEONG_IEUNG_KHIEUKH";
        case   0x11F0: return "HANGUL_JONGSEONG_YESIEUNG";
        case   0x11F1: return "HANGUL_JONGSEONG_YESIEUNG_SIOS";
        case   0x11F2: return "HANGUL_JONGSEONG_YESIEUNG_PANSIOS";
        case   0x11F3: return "HANGUL_JONGSEONG_PHIEUPH_PIEUP";
        case   0x11F4: return "HANGUL_JONGSEONG_KAPYEOUNPHIEUPH";
        case   0x11F5: return "HANGUL_JONGSEONG_HIEUH_NIEUN";
        case   0x11F6: return "HANGUL_JONGSEONG_HIEUH_RIEUL";
        case   0x11F7: return "HANGUL_JONGSEONG_HIEUH_MIEUM";
        case   0x11F8: return "HANGUL_JONGSEONG_HIEUH_PIEUP";
        case   0x11F9: return "HANGUL_JONGSEONG_YEORINHIEUH";
        case   0x11FA: return "HANGUL_JONGSEONG_KIYEOK_NIEUN";
        case   0x11FB: return "HANGUL_JONGSEONG_KIYEOK_PIEUP";
        case   0x11FC: return "HANGUL_JONGSEONG_KIYEOK_CHIEUCH";
        case   0x11FD: return "HANGUL_JONGSEONG_KIYEOK_KHIEUKH";
        case   0x11FE: return "HANGUL_JONGSEONG_KIYEOK_HIEUH";
        case   0x11FF: return "HANGUL_JONGSEONG_SSANGNIEUN";
        case   0x1200: return "ETHIOPIC_SYLLABLE_HA";
        case   0x1201: return "ETHIOPIC_SYLLABLE_HU";
        case   0x1202: return "ETHIOPIC_SYLLABLE_HI";
        case   0x1203: return "ETHIOPIC_SYLLABLE_HAA";
        case   0x1204: return "ETHIOPIC_SYLLABLE_HEE";
        case   0x1205: return "ETHIOPIC_SYLLABLE_HE";
        case   0x1206: return "ETHIOPIC_SYLLABLE_HO";
        case   0x1207: return "ETHIOPIC_SYLLABLE_HOA";
        case   0x1208: return "ETHIOPIC_SYLLABLE_LA";
        case   0x1209: return "ETHIOPIC_SYLLABLE_LU";
        case   0x120A: return "ETHIOPIC_SYLLABLE_LI";
        case   0x120B: return "ETHIOPIC_SYLLABLE_LAA";
        case   0x120C: return "ETHIOPIC_SYLLABLE_LEE";
        case   0x120D: return "ETHIOPIC_SYLLABLE_LE";
        case   0x120E: return "ETHIOPIC_SYLLABLE_LO";
        case   0x120F: return "ETHIOPIC_SYLLABLE_LWA";
        case   0x1210: return "ETHIOPIC_SYLLABLE_HHA";
        case   0x1211: return "ETHIOPIC_SYLLABLE_HHU";
        case   0x1212: return "ETHIOPIC_SYLLABLE_HHI";
        case   0x1213: return "ETHIOPIC_SYLLABLE_HHAA";
        case   0x1214: return "ETHIOPIC_SYLLABLE_HHEE";
        case   0x1215: return "ETHIOPIC_SYLLABLE_HHE";
        case   0x1216: return "ETHIOPIC_SYLLABLE_HHO";
        case   0x1217: return "ETHIOPIC_SYLLABLE_HHWA";
        case   0x1218: return "ETHIOPIC_SYLLABLE_MA";
        case   0x1219: return "ETHIOPIC_SYLLABLE_MU";
        case   0x121A: return "ETHIOPIC_SYLLABLE_MI";
        case   0x121B: return "ETHIOPIC_SYLLABLE_MAA";
        case   0x121C: return "ETHIOPIC_SYLLABLE_MEE";
        case   0x121D: return "ETHIOPIC_SYLLABLE_ME";
        case   0x121E: return "ETHIOPIC_SYLLABLE_MO";
        case   0x121F: return "ETHIOPIC_SYLLABLE_MWA";
        case   0x1220: return "ETHIOPIC_SYLLABLE_SZA";
        case   0x1221: return "ETHIOPIC_SYLLABLE_SZU";
        case   0x1222: return "ETHIOPIC_SYLLABLE_SZI";
        case   0x1223: return "ETHIOPIC_SYLLABLE_SZAA";
        case   0x1224: return "ETHIOPIC_SYLLABLE_SZEE";
        case   0x1225: return "ETHIOPIC_SYLLABLE_SZE";
        case   0x1226: return "ETHIOPIC_SYLLABLE_SZO";
        case   0x1227: return "ETHIOPIC_SYLLABLE_SZWA";
        case   0x1228: return "ETHIOPIC_SYLLABLE_RA";
        case   0x1229: return "ETHIOPIC_SYLLABLE_RU";
        case   0x122A: return "ETHIOPIC_SYLLABLE_RI";
        case   0x122B: return "ETHIOPIC_SYLLABLE_RAA";
        case   0x122C: return "ETHIOPIC_SYLLABLE_REE";
        case   0x122D: return "ETHIOPIC_SYLLABLE_RE";
        case   0x122E: return "ETHIOPIC_SYLLABLE_RO";
        case   0x122F: return "ETHIOPIC_SYLLABLE_RWA";
        case   0x1230: return "ETHIOPIC_SYLLABLE_SA";
        case   0x1231: return "ETHIOPIC_SYLLABLE_SU";
        case   0x1232: return "ETHIOPIC_SYLLABLE_SI";
        case   0x1233: return "ETHIOPIC_SYLLABLE_SAA";
        case   0x1234: return "ETHIOPIC_SYLLABLE_SEE";
        case   0x1235: return "ETHIOPIC_SYLLABLE_SE";
        case   0x1236: return "ETHIOPIC_SYLLABLE_SO";
        case   0x1237: return "ETHIOPIC_SYLLABLE_SWA";
        case   0x1238: return "ETHIOPIC_SYLLABLE_SHA";
        case   0x1239: return "ETHIOPIC_SYLLABLE_SHU";
        case   0x123A: return "ETHIOPIC_SYLLABLE_SHI";
        case   0x123B: return "ETHIOPIC_SYLLABLE_SHAA";
        case   0x123C: return "ETHIOPIC_SYLLABLE_SHEE";
        case   0x123D: return "ETHIOPIC_SYLLABLE_SHE";
        case   0x123E: return "ETHIOPIC_SYLLABLE_SHO";
        case   0x123F: return "ETHIOPIC_SYLLABLE_SHWA";
        case   0x1240: return "ETHIOPIC_SYLLABLE_QA";
        case   0x1241: return "ETHIOPIC_SYLLABLE_QU";
        case   0x1242: return "ETHIOPIC_SYLLABLE_QI";
        case   0x1243: return "ETHIOPIC_SYLLABLE_QAA";
        case   0x1244: return "ETHIOPIC_SYLLABLE_QEE";
        case   0x1245: return "ETHIOPIC_SYLLABLE_QE";
        case   0x1246: return "ETHIOPIC_SYLLABLE_QO";
        case   0x1247: return "ETHIOPIC_SYLLABLE_QOA";
        case   0x1248: return "ETHIOPIC_SYLLABLE_QWA";
        case   0x124A: return "ETHIOPIC_SYLLABLE_QWI";
        case   0x124B: return "ETHIOPIC_SYLLABLE_QWAA";
        case   0x124C: return "ETHIOPIC_SYLLABLE_QWEE";
        case   0x124D: return "ETHIOPIC_SYLLABLE_QWE";
        case   0x1250: return "ETHIOPIC_SYLLABLE_QHA";
        case   0x1251: return "ETHIOPIC_SYLLABLE_QHU";
        case   0x1252: return "ETHIOPIC_SYLLABLE_QHI";
        case   0x1253: return "ETHIOPIC_SYLLABLE_QHAA";
        case   0x1254: return "ETHIOPIC_SYLLABLE_QHEE";
        case   0x1255: return "ETHIOPIC_SYLLABLE_QHE";
        case   0x1256: return "ETHIOPIC_SYLLABLE_QHO";
        case   0x1258: return "ETHIOPIC_SYLLABLE_QHWA";
        case   0x125A: return "ETHIOPIC_SYLLABLE_QHWI";
        case   0x125B: return "ETHIOPIC_SYLLABLE_QHWAA";
        case   0x125C: return "ETHIOPIC_SYLLABLE_QHWEE";
        case   0x125D: return "ETHIOPIC_SYLLABLE_QHWE";
        case   0x1260: return "ETHIOPIC_SYLLABLE_BA";
        case   0x1261: return "ETHIOPIC_SYLLABLE_BU";
        case   0x1262: return "ETHIOPIC_SYLLABLE_BI";
        case   0x1263: return "ETHIOPIC_SYLLABLE_BAA";
        case   0x1264: return "ETHIOPIC_SYLLABLE_BEE";
        case   0x1265: return "ETHIOPIC_SYLLABLE_BE";
        case   0x1266: return "ETHIOPIC_SYLLABLE_BO";
        case   0x1267: return "ETHIOPIC_SYLLABLE_BWA";
        case   0x1268: return "ETHIOPIC_SYLLABLE_VA";
        case   0x1269: return "ETHIOPIC_SYLLABLE_VU";
        case   0x126A: return "ETHIOPIC_SYLLABLE_VI";
        case   0x126B: return "ETHIOPIC_SYLLABLE_VAA";
        case   0x126C: return "ETHIOPIC_SYLLABLE_VEE";
        case   0x126D: return "ETHIOPIC_SYLLABLE_VE";
        case   0x126E: return "ETHIOPIC_SYLLABLE_VO";
        case   0x126F: return "ETHIOPIC_SYLLABLE_VWA";
        case   0x1270: return "ETHIOPIC_SYLLABLE_TA";
        case   0x1271: return "ETHIOPIC_SYLLABLE_TU";
        case   0x1272: return "ETHIOPIC_SYLLABLE_TI";
        case   0x1273: return "ETHIOPIC_SYLLABLE_TAA";
        case   0x1274: return "ETHIOPIC_SYLLABLE_TEE";
        case   0x1275: return "ETHIOPIC_SYLLABLE_TE";
        case   0x1276: return "ETHIOPIC_SYLLABLE_TO";
        case   0x1277: return "ETHIOPIC_SYLLABLE_TWA";
        case   0x1278: return "ETHIOPIC_SYLLABLE_CA";
        case   0x1279: return "ETHIOPIC_SYLLABLE_CU";
        case   0x127A: return "ETHIOPIC_SYLLABLE_CI";
        case   0x127B: return "ETHIOPIC_SYLLABLE_CAA";
        case   0x127C: return "ETHIOPIC_SYLLABLE_CEE";
        case   0x127D: return "ETHIOPIC_SYLLABLE_CE";
        case   0x127E: return "ETHIOPIC_SYLLABLE_CO";
        case   0x127F: return "ETHIOPIC_SYLLABLE_CWA";
        case   0x1280: return "ETHIOPIC_SYLLABLE_XA";
        case   0x1281: return "ETHIOPIC_SYLLABLE_XU";
        case   0x1282: return "ETHIOPIC_SYLLABLE_XI";
        case   0x1283: return "ETHIOPIC_SYLLABLE_XAA";
        case   0x1284: return "ETHIOPIC_SYLLABLE_XEE";
        case   0x1285: return "ETHIOPIC_SYLLABLE_XE";
        case   0x1286: return "ETHIOPIC_SYLLABLE_XO";
        case   0x1287: return "ETHIOPIC_SYLLABLE_XOA";
        case   0x1288: return "ETHIOPIC_SYLLABLE_XWA";
        case   0x128A: return "ETHIOPIC_SYLLABLE_XWI";
        case   0x128B: return "ETHIOPIC_SYLLABLE_XWAA";
        case   0x128C: return "ETHIOPIC_SYLLABLE_XWEE";
        case   0x128D: return "ETHIOPIC_SYLLABLE_XWE";
        case   0x1290: return "ETHIOPIC_SYLLABLE_NA";
        case   0x1291: return "ETHIOPIC_SYLLABLE_NU";
        case   0x1292: return "ETHIOPIC_SYLLABLE_NI";
        case   0x1293: return "ETHIOPIC_SYLLABLE_NAA";
        case   0x1294: return "ETHIOPIC_SYLLABLE_NEE";
        case   0x1295: return "ETHIOPIC_SYLLABLE_NE";
        case   0x1296: return "ETHIOPIC_SYLLABLE_NO";
        case   0x1297: return "ETHIOPIC_SYLLABLE_NWA";
        case   0x1298: return "ETHIOPIC_SYLLABLE_NYA";
        case   0x1299: return "ETHIOPIC_SYLLABLE_NYU";
        case   0x129A: return "ETHIOPIC_SYLLABLE_NYI";
        case   0x129B: return "ETHIOPIC_SYLLABLE_NYAA";
        case   0x129C: return "ETHIOPIC_SYLLABLE_NYEE";
        case   0x129D: return "ETHIOPIC_SYLLABLE_NYE";
        case   0x129E: return "ETHIOPIC_SYLLABLE_NYO";
        case   0x129F: return "ETHIOPIC_SYLLABLE_NYWA";
        case   0x12A0: return "ETHIOPIC_SYLLABLE_GLOTTAL_A";
        case   0x12A1: return "ETHIOPIC_SYLLABLE_GLOTTAL_U";
        case   0x12A2: return "ETHIOPIC_SYLLABLE_GLOTTAL_I";
        case   0x12A3: return "ETHIOPIC_SYLLABLE_GLOTTAL_AA";
        case   0x12A4: return "ETHIOPIC_SYLLABLE_GLOTTAL_EE";
        case   0x12A5: return "ETHIOPIC_SYLLABLE_GLOTTAL_E";
        case   0x12A6: return "ETHIOPIC_SYLLABLE_GLOTTAL_O";
        case   0x12A7: return "ETHIOPIC_SYLLABLE_GLOTTAL_WA";
        case   0x12A8: return "ETHIOPIC_SYLLABLE_KA";
        case   0x12A9: return "ETHIOPIC_SYLLABLE_KU";
        case   0x12AA: return "ETHIOPIC_SYLLABLE_KI";
        case   0x12AB: return "ETHIOPIC_SYLLABLE_KAA";
        case   0x12AC: return "ETHIOPIC_SYLLABLE_KEE";
        case   0x12AD: return "ETHIOPIC_SYLLABLE_KE";
        case   0x12AE: return "ETHIOPIC_SYLLABLE_KO";
        case   0x12AF: return "ETHIOPIC_SYLLABLE_KOA";
        case   0x12B0: return "ETHIOPIC_SYLLABLE_KWA";
        case   0x12B2: return "ETHIOPIC_SYLLABLE_KWI";
        case   0x12B3: return "ETHIOPIC_SYLLABLE_KWAA";
        case   0x12B4: return "ETHIOPIC_SYLLABLE_KWEE";
        case   0x12B5: return "ETHIOPIC_SYLLABLE_KWE";
        case   0x12B8: return "ETHIOPIC_SYLLABLE_KXA";
        case   0x12B9: return "ETHIOPIC_SYLLABLE_KXU";
        case   0x12BA: return "ETHIOPIC_SYLLABLE_KXI";
        case   0x12BB: return "ETHIOPIC_SYLLABLE_KXAA";
        case   0x12BC: return "ETHIOPIC_SYLLABLE_KXEE";
        case   0x12BD: return "ETHIOPIC_SYLLABLE_KXE";
        case   0x12BE: return "ETHIOPIC_SYLLABLE_KXO";
        case   0x12C0: return "ETHIOPIC_SYLLABLE_KXWA";
        case   0x12C2: return "ETHIOPIC_SYLLABLE_KXWI";
        case   0x12C3: return "ETHIOPIC_SYLLABLE_KXWAA";
        case   0x12C4: return "ETHIOPIC_SYLLABLE_KXWEE";
        case   0x12C5: return "ETHIOPIC_SYLLABLE_KXWE";
        case   0x12C8: return "ETHIOPIC_SYLLABLE_WA";
        case   0x12C9: return "ETHIOPIC_SYLLABLE_WU";
        case   0x12CA: return "ETHIOPIC_SYLLABLE_WI";
        case   0x12CB: return "ETHIOPIC_SYLLABLE_WAA";
        case   0x12CC: return "ETHIOPIC_SYLLABLE_WEE";
        case   0x12CD: return "ETHIOPIC_SYLLABLE_WE";
        case   0x12CE: return "ETHIOPIC_SYLLABLE_WO";
        case   0x12CF: return "ETHIOPIC_SYLLABLE_WOA";
        case   0x12D0: return "ETHIOPIC_SYLLABLE_PHARYNGEAL_A";
        case   0x12D1: return "ETHIOPIC_SYLLABLE_PHARYNGEAL_U";
        case   0x12D2: return "ETHIOPIC_SYLLABLE_PHARYNGEAL_I";
        case   0x12D3: return "ETHIOPIC_SYLLABLE_PHARYNGEAL_AA";
        case   0x12D4: return "ETHIOPIC_SYLLABLE_PHARYNGEAL_EE";
        case   0x12D5: return "ETHIOPIC_SYLLABLE_PHARYNGEAL_E";
        case   0x12D6: return "ETHIOPIC_SYLLABLE_PHARYNGEAL_O";
        case   0x12D8: return "ETHIOPIC_SYLLABLE_ZA";
        case   0x12D9: return "ETHIOPIC_SYLLABLE_ZU";
        case   0x12DA: return "ETHIOPIC_SYLLABLE_ZI";
        case   0x12DB: return "ETHIOPIC_SYLLABLE_ZAA";
        case   0x12DC: return "ETHIOPIC_SYLLABLE_ZEE";
        case   0x12DD: return "ETHIOPIC_SYLLABLE_ZE";
        case   0x12DE: return "ETHIOPIC_SYLLABLE_ZO";
        case   0x12DF: return "ETHIOPIC_SYLLABLE_ZWA";
        case   0x12E0: return "ETHIOPIC_SYLLABLE_ZHA";
        case   0x12E1: return "ETHIOPIC_SYLLABLE_ZHU";
        case   0x12E2: return "ETHIOPIC_SYLLABLE_ZHI";
        case   0x12E3: return "ETHIOPIC_SYLLABLE_ZHAA";
        case   0x12E4: return "ETHIOPIC_SYLLABLE_ZHEE";
        case   0x12E5: return "ETHIOPIC_SYLLABLE_ZHE";
        case   0x12E6: return "ETHIOPIC_SYLLABLE_ZHO";
        case   0x12E7: return "ETHIOPIC_SYLLABLE_ZHWA";
        case   0x12E8: return "ETHIOPIC_SYLLABLE_YA";
        case   0x12E9: return "ETHIOPIC_SYLLABLE_YU";
        case   0x12EA: return "ETHIOPIC_SYLLABLE_YI";
        case   0x12EB: return "ETHIOPIC_SYLLABLE_YAA";
        case   0x12EC: return "ETHIOPIC_SYLLABLE_YEE";
        case   0x12ED: return "ETHIOPIC_SYLLABLE_YE";
        case   0x12EE: return "ETHIOPIC_SYLLABLE_YO";
        case   0x12EF: return "ETHIOPIC_SYLLABLE_YOA";
        case   0x12F0: return "ETHIOPIC_SYLLABLE_DA";
        case   0x12F1: return "ETHIOPIC_SYLLABLE_DU";
        case   0x12F2: return "ETHIOPIC_SYLLABLE_DI";
        case   0x12F3: return "ETHIOPIC_SYLLABLE_DAA";
        case   0x12F4: return "ETHIOPIC_SYLLABLE_DEE";
        case   0x12F5: return "ETHIOPIC_SYLLABLE_DE";
        case   0x12F6: return "ETHIOPIC_SYLLABLE_DO";
        case   0x12F7: return "ETHIOPIC_SYLLABLE_DWA";
        case   0x12F8: return "ETHIOPIC_SYLLABLE_DDA";
        case   0x12F9: return "ETHIOPIC_SYLLABLE_DDU";
        case   0x12FA: return "ETHIOPIC_SYLLABLE_DDI";
        case   0x12FB: return "ETHIOPIC_SYLLABLE_DDAA";
        case   0x12FC: return "ETHIOPIC_SYLLABLE_DDEE";
        case   0x12FD: return "ETHIOPIC_SYLLABLE_DDE";
        case   0x12FE: return "ETHIOPIC_SYLLABLE_DDO";
        case   0x12FF: return "ETHIOPIC_SYLLABLE_DDWA";
        case   0x1300: return "ETHIOPIC_SYLLABLE_JA";
        case   0x1301: return "ETHIOPIC_SYLLABLE_JU";
        case   0x1302: return "ETHIOPIC_SYLLABLE_JI";
        case   0x1303: return "ETHIOPIC_SYLLABLE_JAA";
        case   0x1304: return "ETHIOPIC_SYLLABLE_JEE";
        case   0x1305: return "ETHIOPIC_SYLLABLE_JE";
        case   0x1306: return "ETHIOPIC_SYLLABLE_JO";
        case   0x1307: return "ETHIOPIC_SYLLABLE_JWA";
        case   0x1308: return "ETHIOPIC_SYLLABLE_GA";
        case   0x1309: return "ETHIOPIC_SYLLABLE_GU";
        case   0x130A: return "ETHIOPIC_SYLLABLE_GI";
        case   0x130B: return "ETHIOPIC_SYLLABLE_GAA";
        case   0x130C: return "ETHIOPIC_SYLLABLE_GEE";
        case   0x130D: return "ETHIOPIC_SYLLABLE_GE";
        case   0x130E: return "ETHIOPIC_SYLLABLE_GO";
        case   0x130F: return "ETHIOPIC_SYLLABLE_GOA";
        case   0x1310: return "ETHIOPIC_SYLLABLE_GWA";
        case   0x1312: return "ETHIOPIC_SYLLABLE_GWI";
        case   0x1313: return "ETHIOPIC_SYLLABLE_GWAA";
        case   0x1314: return "ETHIOPIC_SYLLABLE_GWEE";
        case   0x1315: return "ETHIOPIC_SYLLABLE_GWE";
        case   0x1318: return "ETHIOPIC_SYLLABLE_GGA";
        case   0x1319: return "ETHIOPIC_SYLLABLE_GGU";
        case   0x131A: return "ETHIOPIC_SYLLABLE_GGI";
        case   0x131B: return "ETHIOPIC_SYLLABLE_GGAA";
        case   0x131C: return "ETHIOPIC_SYLLABLE_GGEE";
        case   0x131D: return "ETHIOPIC_SYLLABLE_GGE";
        case   0x131E: return "ETHIOPIC_SYLLABLE_GGO";
        case   0x131F: return "ETHIOPIC_SYLLABLE_GGWAA";
        case   0x1320: return "ETHIOPIC_SYLLABLE_THA";
        case   0x1321: return "ETHIOPIC_SYLLABLE_THU";
        case   0x1322: return "ETHIOPIC_SYLLABLE_THI";
        case   0x1323: return "ETHIOPIC_SYLLABLE_THAA";
        case   0x1324: return "ETHIOPIC_SYLLABLE_THEE";
        case   0x1325: return "ETHIOPIC_SYLLABLE_THE";
        case   0x1326: return "ETHIOPIC_SYLLABLE_THO";
        case   0x1327: return "ETHIOPIC_SYLLABLE_THWA";
        case   0x1328: return "ETHIOPIC_SYLLABLE_CHA";
        case   0x1329: return "ETHIOPIC_SYLLABLE_CHU";
        case   0x132A: return "ETHIOPIC_SYLLABLE_CHI";
        case   0x132B: return "ETHIOPIC_SYLLABLE_CHAA";
        case   0x132C: return "ETHIOPIC_SYLLABLE_CHEE";
        case   0x132D: return "ETHIOPIC_SYLLABLE_CHE";
        case   0x132E: return "ETHIOPIC_SYLLABLE_CHO";
        case   0x132F: return "ETHIOPIC_SYLLABLE_CHWA";
        case   0x1330: return "ETHIOPIC_SYLLABLE_PHA";
        case   0x1331: return "ETHIOPIC_SYLLABLE_PHU";
        case   0x1332: return "ETHIOPIC_SYLLABLE_PHI";
        case   0x1333: return "ETHIOPIC_SYLLABLE_PHAA";
        case   0x1334: return "ETHIOPIC_SYLLABLE_PHEE";
        case   0x1335: return "ETHIOPIC_SYLLABLE_PHE";
        case   0x1336: return "ETHIOPIC_SYLLABLE_PHO";
        case   0x1337: return "ETHIOPIC_SYLLABLE_PHWA";
        case   0x1338: return "ETHIOPIC_SYLLABLE_TSA";
        case   0x1339: return "ETHIOPIC_SYLLABLE_TSU";
        case   0x133A: return "ETHIOPIC_SYLLABLE_TSI";
        case   0x133B: return "ETHIOPIC_SYLLABLE_TSAA";
        case   0x133C: return "ETHIOPIC_SYLLABLE_TSEE";
        case   0x133D: return "ETHIOPIC_SYLLABLE_TSE";
        case   0x133E: return "ETHIOPIC_SYLLABLE_TSO";
        case   0x133F: return "ETHIOPIC_SYLLABLE_TSWA";
        case   0x1340: return "ETHIOPIC_SYLLABLE_TZA";
        case   0x1341: return "ETHIOPIC_SYLLABLE_TZU";
        case   0x1342: return "ETHIOPIC_SYLLABLE_TZI";
        case   0x1343: return "ETHIOPIC_SYLLABLE_TZAA";
        case   0x1344: return "ETHIOPIC_SYLLABLE_TZEE";
        case   0x1345: return "ETHIOPIC_SYLLABLE_TZE";
        case   0x1346: return "ETHIOPIC_SYLLABLE_TZO";
        case   0x1347: return "ETHIOPIC_SYLLABLE_TZOA";
        case   0x1348: return "ETHIOPIC_SYLLABLE_FA";
        case   0x1349: return "ETHIOPIC_SYLLABLE_FU";
        case   0x134A: return "ETHIOPIC_SYLLABLE_FI";
        case   0x134B: return "ETHIOPIC_SYLLABLE_FAA";
        case   0x134C: return "ETHIOPIC_SYLLABLE_FEE";
        case   0x134D: return "ETHIOPIC_SYLLABLE_FE";
        case   0x134E: return "ETHIOPIC_SYLLABLE_FO";
        case   0x134F: return "ETHIOPIC_SYLLABLE_FWA";
        case   0x1350: return "ETHIOPIC_SYLLABLE_PA";
        case   0x1351: return "ETHIOPIC_SYLLABLE_PU";
        case   0x1352: return "ETHIOPIC_SYLLABLE_PI";
        case   0x1353: return "ETHIOPIC_SYLLABLE_PAA";
        case   0x1354: return "ETHIOPIC_SYLLABLE_PEE";
        case   0x1355: return "ETHIOPIC_SYLLABLE_PE";
        case   0x1356: return "ETHIOPIC_SYLLABLE_PO";
        case   0x1357: return "ETHIOPIC_SYLLABLE_PWA";
        case   0x1358: return "ETHIOPIC_SYLLABLE_RYA";
        case   0x1359: return "ETHIOPIC_SYLLABLE_MYA";
        case   0x135A: return "ETHIOPIC_SYLLABLE_FYA";
        case   0x135D: return
                "ETHIOPIC_COMBINING_GEMINATION_AND_VOWEL_LENGTH_MARK";
        case   0x135E: return "ETHIOPIC_COMBINING_VOWEL_LENGTH_MARK";
        case   0x135F: return "ETHIOPIC_COMBINING_GEMINATION_MARK";
        case   0x1360: return "ETHIOPIC_SECTION_MARK";
        case   0x1361: return "ETHIOPIC_WORDSPACE";
        case   0x1362: return "ETHIOPIC_FULL_STOP";
        case   0x1363: return "ETHIOPIC_COMMA";
        case   0x1364: return "ETHIOPIC_SEMICOLON";
        case   0x1365: return "ETHIOPIC_COLON";
        case   0x1366: return "ETHIOPIC_PREFACE_COLON";
        case   0x1367: return "ETHIOPIC_QUESTION_MARK";
        case   0x1368: return "ETHIOPIC_PARAGRAPH_SEPARATOR";
        case   0x1369: return "ETHIOPIC_DIGIT_ONE";
        case   0x136A: return "ETHIOPIC_DIGIT_TWO";
        case   0x136B: return "ETHIOPIC_DIGIT_THREE";
        case   0x136C: return "ETHIOPIC_DIGIT_FOUR";
        case   0x136D: return "ETHIOPIC_DIGIT_FIVE";
        case   0x136E: return "ETHIOPIC_DIGIT_SIX";
        case   0x136F: return "ETHIOPIC_DIGIT_SEVEN";
        case   0x1370: return "ETHIOPIC_DIGIT_EIGHT";
        case   0x1371: return "ETHIOPIC_DIGIT_NINE";
        case   0x1372: return "ETHIOPIC_NUMBER_TEN";
        case   0x1373: return "ETHIOPIC_NUMBER_TWENTY";
        case   0x1374: return "ETHIOPIC_NUMBER_THIRTY";
        case   0x1375: return "ETHIOPIC_NUMBER_FORTY";
        case   0x1376: return "ETHIOPIC_NUMBER_FIFTY";
        case   0x1377: return "ETHIOPIC_NUMBER_SIXTY";
        case   0x1378: return "ETHIOPIC_NUMBER_SEVENTY";
        case   0x1379: return "ETHIOPIC_NUMBER_EIGHTY";
        case   0x137A: return "ETHIOPIC_NUMBER_NINETY";
        case   0x137B: return "ETHIOPIC_NUMBER_HUNDRED";
        case   0x137C: return "ETHIOPIC_NUMBER_TEN_THOUSAND";
        case   0x1380: return "ETHIOPIC_SYLLABLE_SEBATBEIT_MWA";
        case   0x1381: return "ETHIOPIC_SYLLABLE_MWI";
        case   0x1382: return "ETHIOPIC_SYLLABLE_MWEE";
        case   0x1383: return "ETHIOPIC_SYLLABLE_MWE";
        case   0x1384: return "ETHIOPIC_SYLLABLE_SEBATBEIT_BWA";
        case   0x1385: return "ETHIOPIC_SYLLABLE_BWI";
        case   0x1386: return "ETHIOPIC_SYLLABLE_BWEE";
        case   0x1387: return "ETHIOPIC_SYLLABLE_BWE";
        case   0x1388: return "ETHIOPIC_SYLLABLE_SEBATBEIT_FWA";
        case   0x1389: return "ETHIOPIC_SYLLABLE_FWI";
        case   0x138A: return "ETHIOPIC_SYLLABLE_FWEE";
        case   0x138B: return "ETHIOPIC_SYLLABLE_FWE";
        case   0x138C: return "ETHIOPIC_SYLLABLE_SEBATBEIT_PWA";
        case   0x138D: return "ETHIOPIC_SYLLABLE_PWI";
        case   0x138E: return "ETHIOPIC_SYLLABLE_PWEE";
        case   0x138F: return "ETHIOPIC_SYLLABLE_PWE";
        case   0x1390: return "ETHIOPIC_TONAL_MARK_YIZET";
        case   0x1391: return "ETHIOPIC_TONAL_MARK_DERET";
        case   0x1392: return "ETHIOPIC_TONAL_MARK_RIKRIK";
        case   0x1393: return "ETHIOPIC_TONAL_MARK_SHORT_RIKRIK";
        case   0x1394: return "ETHIOPIC_TONAL_MARK_DIFAT";
        case   0x1395: return "ETHIOPIC_TONAL_MARK_KENAT";
        case   0x1396: return "ETHIOPIC_TONAL_MARK_CHIRET";
        case   0x1397: return "ETHIOPIC_TONAL_MARK_HIDET";
        case   0x1398: return "ETHIOPIC_TONAL_MARK_DERET_HIDET";
        case   0x1399: return "ETHIOPIC_TONAL_MARK_KURT";
        case   0x13A0: return "CHEROKEE_LETTER_A";
        case   0x13A1: return "CHEROKEE_LETTER_E";
        case   0x13A2: return "CHEROKEE_LETTER_I";
        case   0x13A3: return "CHEROKEE_LETTER_O";
        case   0x13A4: return "CHEROKEE_LETTER_U";
        case   0x13A5: return "CHEROKEE_LETTER_V";
        case   0x13A6: return "CHEROKEE_LETTER_GA";
        case   0x13A7: return "CHEROKEE_LETTER_KA";
        case   0x13A8: return "CHEROKEE_LETTER_GE";
        case   0x13A9: return "CHEROKEE_LETTER_GI";
        case   0x13AA: return "CHEROKEE_LETTER_GO";
        case   0x13AB: return "CHEROKEE_LETTER_GU";
        case   0x13AC: return "CHEROKEE_LETTER_GV";
        case   0x13AD: return "CHEROKEE_LETTER_HA";
        case   0x13AE: return "CHEROKEE_LETTER_HE";
        case   0x13AF: return "CHEROKEE_LETTER_HI";
        case   0x13B0: return "CHEROKEE_LETTER_HO";
        case   0x13B1: return "CHEROKEE_LETTER_HU";
        case   0x13B2: return "CHEROKEE_LETTER_HV";
        case   0x13B3: return "CHEROKEE_LETTER_LA";
        case   0x13B4: return "CHEROKEE_LETTER_LE";
        case   0x13B5: return "CHEROKEE_LETTER_LI";
        case   0x13B6: return "CHEROKEE_LETTER_LO";
        case   0x13B7: return "CHEROKEE_LETTER_LU";
        case   0x13B8: return "CHEROKEE_LETTER_LV";
        case   0x13B9: return "CHEROKEE_LETTER_MA";
        case   0x13BA: return "CHEROKEE_LETTER_ME";
        case   0x13BB: return "CHEROKEE_LETTER_MI";
        case   0x13BC: return "CHEROKEE_LETTER_MO";
        case   0x13BD: return "CHEROKEE_LETTER_MU";
        case   0x13BE: return "CHEROKEE_LETTER_NA";
        case   0x13BF: return "CHEROKEE_LETTER_HNA";
        case   0x13C0: return "CHEROKEE_LETTER_NAH";
        case   0x13C1: return "CHEROKEE_LETTER_NE";
        case   0x13C2: return "CHEROKEE_LETTER_NI";
        case   0x13C3: return "CHEROKEE_LETTER_NO";
        case   0x13C4: return "CHEROKEE_LETTER_NU";
        case   0x13C5: return "CHEROKEE_LETTER_NV";
        case   0x13C6: return "CHEROKEE_LETTER_QUA";
        case   0x13C7: return "CHEROKEE_LETTER_QUE";
        case   0x13C8: return "CHEROKEE_LETTER_QUI";
        case   0x13C9: return "CHEROKEE_LETTER_QUO";
        case   0x13CA: return "CHEROKEE_LETTER_QUU";
        case   0x13CB: return "CHEROKEE_LETTER_QUV";
        case   0x13CC: return "CHEROKEE_LETTER_SA";
        case   0x13CD: return "CHEROKEE_LETTER_S";
        case   0x13CE: return "CHEROKEE_LETTER_SE";
        case   0x13CF: return "CHEROKEE_LETTER_SI";
        case   0x13D0: return "CHEROKEE_LETTER_SO";
        case   0x13D1: return "CHEROKEE_LETTER_SU";
        case   0x13D2: return "CHEROKEE_LETTER_SV";
        case   0x13D3: return "CHEROKEE_LETTER_DA";
        case   0x13D4: return "CHEROKEE_LETTER_TA";
        case   0x13D5: return "CHEROKEE_LETTER_DE";
        case   0x13D6: return "CHEROKEE_LETTER_TE";
        case   0x13D7: return "CHEROKEE_LETTER_DI";
        case   0x13D8: return "CHEROKEE_LETTER_TI";
        case   0x13D9: return "CHEROKEE_LETTER_DO";
        case   0x13DA: return "CHEROKEE_LETTER_DU";
        case   0x13DB: return "CHEROKEE_LETTER_DV";
        case   0x13DC: return "CHEROKEE_LETTER_DLA";
        case   0x13DD: return "CHEROKEE_LETTER_TLA";
        case   0x13DE: return "CHEROKEE_LETTER_TLE";
        case   0x13DF: return "CHEROKEE_LETTER_TLI";
        case   0x13E0: return "CHEROKEE_LETTER_TLO";
        case   0x13E1: return "CHEROKEE_LETTER_TLU";
        case   0x13E2: return "CHEROKEE_LETTER_TLV";
        case   0x13E3: return "CHEROKEE_LETTER_TSA";
        case   0x13E4: return "CHEROKEE_LETTER_TSE";
        case   0x13E5: return "CHEROKEE_LETTER_TSI";
        case   0x13E6: return "CHEROKEE_LETTER_TSO";
        case   0x13E7: return "CHEROKEE_LETTER_TSU";
        case   0x13E8: return "CHEROKEE_LETTER_TSV";
        case   0x13E9: return "CHEROKEE_LETTER_WA";
        case   0x13EA: return "CHEROKEE_LETTER_WE";
        case   0x13EB: return "CHEROKEE_LETTER_WI";
        case   0x13EC: return "CHEROKEE_LETTER_WO";
        case   0x13ED: return "CHEROKEE_LETTER_WU";
        case   0x13EE: return "CHEROKEE_LETTER_WV";
        case   0x13EF: return "CHEROKEE_LETTER_YA";
        case   0x13F0: return "CHEROKEE_LETTER_YE";
        case   0x13F1: return "CHEROKEE_LETTER_YI";
        case   0x13F2: return "CHEROKEE_LETTER_YO";
        case   0x13F3: return "CHEROKEE_LETTER_YU";
        case   0x13F4: return "CHEROKEE_LETTER_YV";
        case   0x1400: return "CANADIAN_SYLLABICS_HYPHEN";
        case   0x1401: return "CANADIAN_SYLLABICS_E";
        case   0x1402: return "CANADIAN_SYLLABICS_AAI";
        case   0x1403: return "CANADIAN_SYLLABICS_I";
        case   0x1404: return "CANADIAN_SYLLABICS_II";
        case   0x1405: return "CANADIAN_SYLLABICS_O";
        case   0x1406: return "CANADIAN_SYLLABICS_OO";
        case   0x1407: return "CANADIAN_SYLLABICS_Y_CREE_OO";
        case   0x1408: return "CANADIAN_SYLLABICS_CARRIER_EE";
        case   0x1409: return "CANADIAN_SYLLABICS_CARRIER_I";
        case   0x140A: return "CANADIAN_SYLLABICS_A";
        case   0x140B: return "CANADIAN_SYLLABICS_AA";
        case   0x140C: return "CANADIAN_SYLLABICS_WE";
        case   0x140D: return "CANADIAN_SYLLABICS_WEST_CREE_WE";
        case   0x140E: return "CANADIAN_SYLLABICS_WI";
        case   0x140F: return "CANADIAN_SYLLABICS_WEST_CREE_WI";
        case   0x1410: return "CANADIAN_SYLLABICS_WII";
        case   0x1411: return "CANADIAN_SYLLABICS_WEST_CREE_WII";
        case   0x1412: return "CANADIAN_SYLLABICS_WO";
        case   0x1413: return "CANADIAN_SYLLABICS_WEST_CREE_WO";
        case   0x1414: return "CANADIAN_SYLLABICS_WOO";
        case   0x1415: return "CANADIAN_SYLLABICS_WEST_CREE_WOO";
        case   0x1416: return "CANADIAN_SYLLABICS_NASKAPI_WOO";
        case   0x1417: return "CANADIAN_SYLLABICS_WA";
        case   0x1418: return "CANADIAN_SYLLABICS_WEST_CREE_WA";
        case   0x1419: return "CANADIAN_SYLLABICS_WAA";
        case   0x141A: return "CANADIAN_SYLLABICS_WEST_CREE_WAA";
        case   0x141B: return "CANADIAN_SYLLABICS_NASKAPI_WAA";
        case   0x141C: return "CANADIAN_SYLLABICS_AI";
        case   0x141D: return "CANADIAN_SYLLABICS_Y_CREE_W";
        case   0x141E: return "CANADIAN_SYLLABICS_GLOTTAL_STOP";
        case   0x141F: return "CANADIAN_SYLLABICS_FINAL_ACUTE";
        case   0x1420: return "CANADIAN_SYLLABICS_FINAL_GRAVE";
        case   0x1421: return "CANADIAN_SYLLABICS_FINAL_BOTTOM_HALF_RING";
        case   0x1422: return "CANADIAN_SYLLABICS_FINAL_TOP_HALF_RING";
        case   0x1423: return "CANADIAN_SYLLABICS_FINAL_RIGHT_HALF_RING";
        case   0x1424: return "CANADIAN_SYLLABICS_FINAL_RING";
        case   0x1425: return "CANADIAN_SYLLABICS_FINAL_DOUBLE_ACUTE";
        case   0x1426: return
                "CANADIAN_SYLLABICS_FINAL_DOUBLE_SHORT_VERTICAL_STROKES";
        case   0x1427: return "CANADIAN_SYLLABICS_FINAL_MIDDLE_DOT";
        case   0x1428: return
                "CANADIAN_SYLLABICS_FINAL_SHORT_HORIZONTAL_STROKE";
        case   0x1429: return "CANADIAN_SYLLABICS_FINAL_PLUS";
        case   0x142A: return "CANADIAN_SYLLABICS_FINAL_DOWN_TACK";
        case   0x142B: return "CANADIAN_SYLLABICS_EN";
        case   0x142C: return "CANADIAN_SYLLABICS_IN";
        case   0x142D: return "CANADIAN_SYLLABICS_ON";
        case   0x142E: return "CANADIAN_SYLLABICS_AN";
        case   0x142F: return "CANADIAN_SYLLABICS_PE";
        case   0x1430: return "CANADIAN_SYLLABICS_PAAI";
        case   0x1431: return "CANADIAN_SYLLABICS_PI";
        case   0x1432: return "CANADIAN_SYLLABICS_PII";
        case   0x1433: return "CANADIAN_SYLLABICS_PO";
        case   0x1434: return "CANADIAN_SYLLABICS_POO";
        case   0x1435: return "CANADIAN_SYLLABICS_Y_CREE_POO";
        case   0x1436: return "CANADIAN_SYLLABICS_CARRIER_HEE";
        case   0x1437: return "CANADIAN_SYLLABICS_CARRIER_HI";
        case   0x1438: return "CANADIAN_SYLLABICS_PA";
        case   0x1439: return "CANADIAN_SYLLABICS_PAA";
        case   0x143A: return "CANADIAN_SYLLABICS_PWE";
        case   0x143B: return "CANADIAN_SYLLABICS_WEST_CREE_PWE";
        case   0x143C: return "CANADIAN_SYLLABICS_PWI";
        case   0x143D: return "CANADIAN_SYLLABICS_WEST_CREE_PWI";
        case   0x143E: return "CANADIAN_SYLLABICS_PWII";
        case   0x143F: return "CANADIAN_SYLLABICS_WEST_CREE_PWII";
        case   0x1440: return "CANADIAN_SYLLABICS_PWO";
        case   0x1441: return "CANADIAN_SYLLABICS_WEST_CREE_PWO";
        case   0x1442: return "CANADIAN_SYLLABICS_PWOO";
        case   0x1443: return "CANADIAN_SYLLABICS_WEST_CREE_PWOO";
        case   0x1444: return "CANADIAN_SYLLABICS_PWA";
        case   0x1445: return "CANADIAN_SYLLABICS_WEST_CREE_PWA";
        case   0x1446: return "CANADIAN_SYLLABICS_PWAA";
        case   0x1447: return "CANADIAN_SYLLABICS_WEST_CREE_PWAA";
        case   0x1448: return "CANADIAN_SYLLABICS_Y_CREE_PWAA";
        case   0x1449: return "CANADIAN_SYLLABICS_P";
        case   0x144A: return "CANADIAN_SYLLABICS_WEST_CREE_P";
        case   0x144B: return "CANADIAN_SYLLABICS_CARRIER_H";
        case   0x144C: return "CANADIAN_SYLLABICS_TE";
        case   0x144D: return "CANADIAN_SYLLABICS_TAAI";
        case   0x144E: return "CANADIAN_SYLLABICS_TI";
        case   0x144F: return "CANADIAN_SYLLABICS_TII";
        case   0x1450: return "CANADIAN_SYLLABICS_TO";
        case   0x1451: return "CANADIAN_SYLLABICS_TOO";
        case   0x1452: return "CANADIAN_SYLLABICS_Y_CREE_TOO";
        case   0x1453: return "CANADIAN_SYLLABICS_CARRIER_DEE";
        case   0x1454: return "CANADIAN_SYLLABICS_CARRIER_DI";
        case   0x1455: return "CANADIAN_SYLLABICS_TA";
        case   0x1456: return "CANADIAN_SYLLABICS_TAA";
        case   0x1457: return "CANADIAN_SYLLABICS_TWE";
        case   0x1458: return "CANADIAN_SYLLABICS_WEST_CREE_TWE";
        case   0x1459: return "CANADIAN_SYLLABICS_TWI";
        case   0x145A: return "CANADIAN_SYLLABICS_WEST_CREE_TWI";
        case   0x145B: return "CANADIAN_SYLLABICS_TWII";
        case   0x145C: return "CANADIAN_SYLLABICS_WEST_CREE_TWII";
        case   0x145D: return "CANADIAN_SYLLABICS_TWO";
        case   0x145E: return "CANADIAN_SYLLABICS_WEST_CREE_TWO";
        case   0x145F: return "CANADIAN_SYLLABICS_TWOO";
        case   0x1460: return "CANADIAN_SYLLABICS_WEST_CREE_TWOO";
        case   0x1461: return "CANADIAN_SYLLABICS_TWA";
        case   0x1462: return "CANADIAN_SYLLABICS_WEST_CREE_TWA";
        case   0x1463: return "CANADIAN_SYLLABICS_TWAA";
        case   0x1464: return "CANADIAN_SYLLABICS_WEST_CREE_TWAA";
        case   0x1465: return "CANADIAN_SYLLABICS_NASKAPI_TWAA";
        case   0x1466: return "CANADIAN_SYLLABICS_T";
        case   0x1467: return "CANADIAN_SYLLABICS_TTE";
        case   0x1468: return "CANADIAN_SYLLABICS_TTI";
        case   0x1469: return "CANADIAN_SYLLABICS_TTO";
        case   0x146A: return "CANADIAN_SYLLABICS_TTA";
        case   0x146B: return "CANADIAN_SYLLABICS_KE";
        case   0x146C: return "CANADIAN_SYLLABICS_KAAI";
        case   0x146D: return "CANADIAN_SYLLABICS_KI";
        case   0x146E: return "CANADIAN_SYLLABICS_KII";
        case   0x146F: return "CANADIAN_SYLLABICS_KO";
        case   0x1470: return "CANADIAN_SYLLABICS_KOO";
        case   0x1471: return "CANADIAN_SYLLABICS_Y_CREE_KOO";
        case   0x1472: return "CANADIAN_SYLLABICS_KA";
        case   0x1473: return "CANADIAN_SYLLABICS_KAA";
        case   0x1474: return "CANADIAN_SYLLABICS_KWE";
        case   0x1475: return "CANADIAN_SYLLABICS_WEST_CREE_KWE";
        case   0x1476: return "CANADIAN_SYLLABICS_KWI";
        case   0x1477: return "CANADIAN_SYLLABICS_WEST_CREE_KWI";
        case   0x1478: return "CANADIAN_SYLLABICS_KWII";
        case   0x1479: return "CANADIAN_SYLLABICS_WEST_CREE_KWII";
        case   0x147A: return "CANADIAN_SYLLABICS_KWO";
        case   0x147B: return "CANADIAN_SYLLABICS_WEST_CREE_KWO";
        case   0x147C: return "CANADIAN_SYLLABICS_KWOO";
        case   0x147D: return "CANADIAN_SYLLABICS_WEST_CREE_KWOO";
        case   0x147E: return "CANADIAN_SYLLABICS_KWA";
        case   0x147F: return "CANADIAN_SYLLABICS_WEST_CREE_KWA";
        case   0x1480: return "CANADIAN_SYLLABICS_KWAA";
        case   0x1481: return "CANADIAN_SYLLABICS_WEST_CREE_KWAA";
        case   0x1482: return "CANADIAN_SYLLABICS_NASKAPI_KWAA";
        case   0x1483: return "CANADIAN_SYLLABICS_K";
        case   0x1484: return "CANADIAN_SYLLABICS_KW";
        case   0x1485: return "CANADIAN_SYLLABICS_SOUTH_SLAVEY_KEH";
        case   0x1486: return "CANADIAN_SYLLABICS_SOUTH_SLAVEY_KIH";
        case   0x1487: return "CANADIAN_SYLLABICS_SOUTH_SLAVEY_KOH";
        case   0x1488: return "CANADIAN_SYLLABICS_SOUTH_SLAVEY_KAH";
        case   0x1489: return "CANADIAN_SYLLABICS_CE";
        case   0x148A: return "CANADIAN_SYLLABICS_CAAI";
        case   0x148B: return "CANADIAN_SYLLABICS_CI";
        case   0x148C: return "CANADIAN_SYLLABICS_CII";
        case   0x148D: return "CANADIAN_SYLLABICS_CO";
        case   0x148E: return "CANADIAN_SYLLABICS_COO";
        case   0x148F: return "CANADIAN_SYLLABICS_Y_CREE_COO";
        case   0x1490: return "CANADIAN_SYLLABICS_CA";
        case   0x1491: return "CANADIAN_SYLLABICS_CAA";
        case   0x1492: return "CANADIAN_SYLLABICS_CWE";
        case   0x1493: return "CANADIAN_SYLLABICS_WEST_CREE_CWE";
        case   0x1494: return "CANADIAN_SYLLABICS_CWI";
        case   0x1495: return "CANADIAN_SYLLABICS_WEST_CREE_CWI";
        case   0x1496: return "CANADIAN_SYLLABICS_CWII";
        case   0x1497: return "CANADIAN_SYLLABICS_WEST_CREE_CWII";
        case   0x1498: return "CANADIAN_SYLLABICS_CWO";
        case   0x1499: return "CANADIAN_SYLLABICS_WEST_CREE_CWO";
        case   0x149A: return "CANADIAN_SYLLABICS_CWOO";
        case   0x149B: return "CANADIAN_SYLLABICS_WEST_CREE_CWOO";
        case   0x149C: return "CANADIAN_SYLLABICS_CWA";
        case   0x149D: return "CANADIAN_SYLLABICS_WEST_CREE_CWA";
        case   0x149E: return "CANADIAN_SYLLABICS_CWAA";
        case   0x149F: return "CANADIAN_SYLLABICS_WEST_CREE_CWAA";
        case   0x14A0: return "CANADIAN_SYLLABICS_NASKAPI_CWAA";
        case   0x14A1: return "CANADIAN_SYLLABICS_C";
        case   0x14A2: return "CANADIAN_SYLLABICS_SAYISI_TH";
        case   0x14A3: return "CANADIAN_SYLLABICS_ME";
        case   0x14A4: return "CANADIAN_SYLLABICS_MAAI";
        case   0x14A5: return "CANADIAN_SYLLABICS_MI";
        case   0x14A6: return "CANADIAN_SYLLABICS_MII";
        case   0x14A7: return "CANADIAN_SYLLABICS_MO";
        case   0x14A8: return "CANADIAN_SYLLABICS_MOO";
        case   0x14A9: return "CANADIAN_SYLLABICS_Y_CREE_MOO";
        case   0x14AA: return "CANADIAN_SYLLABICS_MA";
        case   0x14AB: return "CANADIAN_SYLLABICS_MAA";
        case   0x14AC: return "CANADIAN_SYLLABICS_MWE";
        case   0x14AD: return "CANADIAN_SYLLABICS_WEST_CREE_MWE";
        case   0x14AE: return "CANADIAN_SYLLABICS_MWI";
        case   0x14AF: return "CANADIAN_SYLLABICS_WEST_CREE_MWI";
        case   0x14B0: return "CANADIAN_SYLLABICS_MWII";
        case   0x14B1: return "CANADIAN_SYLLABICS_WEST_CREE_MWII";
        case   0x14B2: return "CANADIAN_SYLLABICS_MWO";
        case   0x14B3: return "CANADIAN_SYLLABICS_WEST_CREE_MWO";
        case   0x14B4: return "CANADIAN_SYLLABICS_MWOO";
        case   0x14B5: return "CANADIAN_SYLLABICS_WEST_CREE_MWOO";
        case   0x14B6: return "CANADIAN_SYLLABICS_MWA";
        case   0x14B7: return "CANADIAN_SYLLABICS_WEST_CREE_MWA";
        case   0x14B8: return "CANADIAN_SYLLABICS_MWAA";
        case   0x14B9: return "CANADIAN_SYLLABICS_WEST_CREE_MWAA";
        case   0x14BA: return "CANADIAN_SYLLABICS_NASKAPI_MWAA";
        case   0x14BB: return "CANADIAN_SYLLABICS_M";
        case   0x14BC: return "CANADIAN_SYLLABICS_WEST_CREE_M";
        case   0x14BD: return "CANADIAN_SYLLABICS_MH";
        case   0x14BE: return "CANADIAN_SYLLABICS_ATHAPASCAN_M";
        case   0x14BF: return "CANADIAN_SYLLABICS_SAYISI_M";
        case   0x14C0: return "CANADIAN_SYLLABICS_NE";
        case   0x14C1: return "CANADIAN_SYLLABICS_NAAI";
        case   0x14C2: return "CANADIAN_SYLLABICS_NI";
        case   0x14C3: return "CANADIAN_SYLLABICS_NII";
        case   0x14C4: return "CANADIAN_SYLLABICS_NO";
        case   0x14C5: return "CANADIAN_SYLLABICS_NOO";
        case   0x14C6: return "CANADIAN_SYLLABICS_Y_CREE_NOO";
        case   0x14C7: return "CANADIAN_SYLLABICS_NA";
        case   0x14C8: return "CANADIAN_SYLLABICS_NAA";
        case   0x14C9: return "CANADIAN_SYLLABICS_NWE";
        case   0x14CA: return "CANADIAN_SYLLABICS_WEST_CREE_NWE";
        case   0x14CB: return "CANADIAN_SYLLABICS_NWA";
        case   0x14CC: return "CANADIAN_SYLLABICS_WEST_CREE_NWA";
        case   0x14CD: return "CANADIAN_SYLLABICS_NWAA";
        case   0x14CE: return "CANADIAN_SYLLABICS_WEST_CREE_NWAA";
        case   0x14CF: return "CANADIAN_SYLLABICS_NASKAPI_NWAA";
        case   0x14D0: return "CANADIAN_SYLLABICS_N";
        case   0x14D1: return "CANADIAN_SYLLABICS_CARRIER_NG";
        case   0x14D2: return "CANADIAN_SYLLABICS_NH";
        case   0x14D3: return "CANADIAN_SYLLABICS_LE";
        case   0x14D4: return "CANADIAN_SYLLABICS_LAAI";
        case   0x14D5: return "CANADIAN_SYLLABICS_LI";
        case   0x14D6: return "CANADIAN_SYLLABICS_LII";
        case   0x14D7: return "CANADIAN_SYLLABICS_LO";
        case   0x14D8: return "CANADIAN_SYLLABICS_LOO";
        case   0x14D9: return "CANADIAN_SYLLABICS_Y_CREE_LOO";
        case   0x14DA: return "CANADIAN_SYLLABICS_LA";
        case   0x14DB: return "CANADIAN_SYLLABICS_LAA";
        case   0x14DC: return "CANADIAN_SYLLABICS_LWE";
        case   0x14DD: return "CANADIAN_SYLLABICS_WEST_CREE_LWE";
        case   0x14DE: return "CANADIAN_SYLLABICS_LWI";
        case   0x14DF: return "CANADIAN_SYLLABICS_WEST_CREE_LWI";
        case   0x14E0: return "CANADIAN_SYLLABICS_LWII";
        case   0x14E1: return "CANADIAN_SYLLABICS_WEST_CREE_LWII";
        case   0x14E2: return "CANADIAN_SYLLABICS_LWO";
        case   0x14E3: return "CANADIAN_SYLLABICS_WEST_CREE_LWO";
        case   0x14E4: return "CANADIAN_SYLLABICS_LWOO";
        case   0x14E5: return "CANADIAN_SYLLABICS_WEST_CREE_LWOO";
        case   0x14E6: return "CANADIAN_SYLLABICS_LWA";
        case   0x14E7: return "CANADIAN_SYLLABICS_WEST_CREE_LWA";
        case   0x14E8: return "CANADIAN_SYLLABICS_LWAA";
        case   0x14E9: return "CANADIAN_SYLLABICS_WEST_CREE_LWAA";
        case   0x14EA: return "CANADIAN_SYLLABICS_L";
        case   0x14EB: return "CANADIAN_SYLLABICS_WEST_CREE_L";
        case   0x14EC: return "CANADIAN_SYLLABICS_MEDIAL_L";
        case   0x14ED: return "CANADIAN_SYLLABICS_SE";
        case   0x14EE: return "CANADIAN_SYLLABICS_SAAI";
        case   0x14EF: return "CANADIAN_SYLLABICS_SI";
        case   0x14F0: return "CANADIAN_SYLLABICS_SII";
        case   0x14F1: return "CANADIAN_SYLLABICS_SO";
        case   0x14F2: return "CANADIAN_SYLLABICS_SOO";
        case   0x14F3: return "CANADIAN_SYLLABICS_Y_CREE_SOO";
        case   0x14F4: return "CANADIAN_SYLLABICS_SA";
        case   0x14F5: return "CANADIAN_SYLLABICS_SAA";
        case   0x14F6: return "CANADIAN_SYLLABICS_SWE";
        case   0x14F7: return "CANADIAN_SYLLABICS_WEST_CREE_SWE";
        case   0x14F8: return "CANADIAN_SYLLABICS_SWI";
        case   0x14F9: return "CANADIAN_SYLLABICS_WEST_CREE_SWI";
        case   0x14FA: return "CANADIAN_SYLLABICS_SWII";
        case   0x14FB: return "CANADIAN_SYLLABICS_WEST_CREE_SWII";
        case   0x14FC: return "CANADIAN_SYLLABICS_SWO";
        case   0x14FD: return "CANADIAN_SYLLABICS_WEST_CREE_SWO";
        case   0x14FE: return "CANADIAN_SYLLABICS_SWOO";
        case   0x14FF: return "CANADIAN_SYLLABICS_WEST_CREE_SWOO";
        case   0x1500: return "CANADIAN_SYLLABICS_SWA";
        case   0x1501: return "CANADIAN_SYLLABICS_WEST_CREE_SWA";
        case   0x1502: return "CANADIAN_SYLLABICS_SWAA";
        case   0x1503: return "CANADIAN_SYLLABICS_WEST_CREE_SWAA";
        case   0x1504: return "CANADIAN_SYLLABICS_NASKAPI_SWAA";
        case   0x1505: return "CANADIAN_SYLLABICS_S";
        case   0x1506: return "CANADIAN_SYLLABICS_ATHAPASCAN_S";
        case   0x1507: return "CANADIAN_SYLLABICS_SW";
        case   0x1508: return "CANADIAN_SYLLABICS_BLACKFOOT_S";
        case   0x1509: return "CANADIAN_SYLLABICS_MOOSE_CREE_SK";
        case   0x150A: return "CANADIAN_SYLLABICS_NASKAPI_SKW";
        case   0x150B: return "CANADIAN_SYLLABICS_NASKAPI_S_W";
        case   0x150C: return "CANADIAN_SYLLABICS_NASKAPI_SPWA";
        case   0x150D: return "CANADIAN_SYLLABICS_NASKAPI_STWA";
        case   0x150E: return "CANADIAN_SYLLABICS_NASKAPI_SKWA";
        case   0x150F: return "CANADIAN_SYLLABICS_NASKAPI_SCWA";
        case   0x1510: return "CANADIAN_SYLLABICS_SHE";
        case   0x1511: return "CANADIAN_SYLLABICS_SHI";
        case   0x1512: return "CANADIAN_SYLLABICS_SHII";
        case   0x1513: return "CANADIAN_SYLLABICS_SHO";
        case   0x1514: return "CANADIAN_SYLLABICS_SHOO";
        case   0x1515: return "CANADIAN_SYLLABICS_SHA";
        case   0x1516: return "CANADIAN_SYLLABICS_SHAA";
        case   0x1517: return "CANADIAN_SYLLABICS_SHWE";
        case   0x1518: return "CANADIAN_SYLLABICS_WEST_CREE_SHWE";
        case   0x1519: return "CANADIAN_SYLLABICS_SHWI";
        case   0x151A: return "CANADIAN_SYLLABICS_WEST_CREE_SHWI";
        case   0x151B: return "CANADIAN_SYLLABICS_SHWII";
        case   0x151C: return "CANADIAN_SYLLABICS_WEST_CREE_SHWII";
        case   0x151D: return "CANADIAN_SYLLABICS_SHWO";
        case   0x151E: return "CANADIAN_SYLLABICS_WEST_CREE_SHWO";
        case   0x151F: return "CANADIAN_SYLLABICS_SHWOO";
        case   0x1520: return "CANADIAN_SYLLABICS_WEST_CREE_SHWOO";
        case   0x1521: return "CANADIAN_SYLLABICS_SHWA";
        case   0x1522: return "CANADIAN_SYLLABICS_WEST_CREE_SHWA";
        case   0x1523: return "CANADIAN_SYLLABICS_SHWAA";
        case   0x1524: return "CANADIAN_SYLLABICS_WEST_CREE_SHWAA";
        case   0x1525: return "CANADIAN_SYLLABICS_SH";
        case   0x1526: return "CANADIAN_SYLLABICS_YE";
        case   0x1527: return "CANADIAN_SYLLABICS_YAAI";
        case   0x1528: return "CANADIAN_SYLLABICS_YI";
        case   0x1529: return "CANADIAN_SYLLABICS_YII";
        case   0x152A: return "CANADIAN_SYLLABICS_YO";
        case   0x152B: return "CANADIAN_SYLLABICS_YOO";
        case   0x152C: return "CANADIAN_SYLLABICS_Y_CREE_YOO";
        case   0x152D: return "CANADIAN_SYLLABICS_YA";
        case   0x152E: return "CANADIAN_SYLLABICS_YAA";
        case   0x152F: return "CANADIAN_SYLLABICS_YWE";
        case   0x1530: return "CANADIAN_SYLLABICS_WEST_CREE_YWE";
        case   0x1531: return "CANADIAN_SYLLABICS_YWI";
        case   0x1532: return "CANADIAN_SYLLABICS_WEST_CREE_YWI";
        case   0x1533: return "CANADIAN_SYLLABICS_YWII";
        case   0x1534: return "CANADIAN_SYLLABICS_WEST_CREE_YWII";
        case   0x1535: return "CANADIAN_SYLLABICS_YWO";
        case   0x1536: return "CANADIAN_SYLLABICS_WEST_CREE_YWO";
        case   0x1537: return "CANADIAN_SYLLABICS_YWOO";
        case   0x1538: return "CANADIAN_SYLLABICS_WEST_CREE_YWOO";
        case   0x1539: return "CANADIAN_SYLLABICS_YWA";
        case   0x153A: return "CANADIAN_SYLLABICS_WEST_CREE_YWA";
        case   0x153B: return "CANADIAN_SYLLABICS_YWAA";
        case   0x153C: return "CANADIAN_SYLLABICS_WEST_CREE_YWAA";
        case   0x153D: return "CANADIAN_SYLLABICS_NASKAPI_YWAA";
        case   0x153E: return "CANADIAN_SYLLABICS_Y";
        case   0x153F: return "CANADIAN_SYLLABICS_BIBLE_CREE_Y";
        case   0x1540: return "CANADIAN_SYLLABICS_WEST_CREE_Y";
        case   0x1541: return "CANADIAN_SYLLABICS_SAYISI_YI";
        case   0x1542: return "CANADIAN_SYLLABICS_RE";
        case   0x1543: return "CANADIAN_SYLLABICS_R_CREE_RE";
        case   0x1544: return "CANADIAN_SYLLABICS_WEST_CREE_LE";
        case   0x1545: return "CANADIAN_SYLLABICS_RAAI";
        case   0x1546: return "CANADIAN_SYLLABICS_RI";
        case   0x1547: return "CANADIAN_SYLLABICS_RII";
        case   0x1548: return "CANADIAN_SYLLABICS_RO";
        case   0x1549: return "CANADIAN_SYLLABICS_ROO";
        case   0x154A: return "CANADIAN_SYLLABICS_WEST_CREE_LO";
        case   0x154B: return "CANADIAN_SYLLABICS_RA";
        case   0x154C: return "CANADIAN_SYLLABICS_RAA";
        case   0x154D: return "CANADIAN_SYLLABICS_WEST_CREE_LA";
        case   0x154E: return "CANADIAN_SYLLABICS_RWAA";
        case   0x154F: return "CANADIAN_SYLLABICS_WEST_CREE_RWAA";
        case   0x1550: return "CANADIAN_SYLLABICS_R";
        case   0x1551: return "CANADIAN_SYLLABICS_WEST_CREE_R";
        case   0x1552: return "CANADIAN_SYLLABICS_MEDIAL_R";
        case   0x1553: return "CANADIAN_SYLLABICS_FE";
        case   0x1554: return "CANADIAN_SYLLABICS_FAAI";
        case   0x1555: return "CANADIAN_SYLLABICS_FI";
        case   0x1556: return "CANADIAN_SYLLABICS_FII";
        case   0x1557: return "CANADIAN_SYLLABICS_FO";
        case   0x1558: return "CANADIAN_SYLLABICS_FOO";
        case   0x1559: return "CANADIAN_SYLLABICS_FA";
        case   0x155A: return "CANADIAN_SYLLABICS_FAA";
        case   0x155B: return "CANADIAN_SYLLABICS_FWAA";
        case   0x155C: return "CANADIAN_SYLLABICS_WEST_CREE_FWAA";
        case   0x155D: return "CANADIAN_SYLLABICS_F";
        case   0x155E: return "CANADIAN_SYLLABICS_THE";
        case   0x155F: return "CANADIAN_SYLLABICS_N_CREE_THE";
        case   0x1560: return "CANADIAN_SYLLABICS_THI";
        case   0x1561: return "CANADIAN_SYLLABICS_N_CREE_THI";
        case   0x1562: return "CANADIAN_SYLLABICS_THII";
        case   0x1563: return "CANADIAN_SYLLABICS_N_CREE_THII";
        case   0x1564: return "CANADIAN_SYLLABICS_THO";
        case   0x1565: return "CANADIAN_SYLLABICS_THOO";
        case   0x1566: return "CANADIAN_SYLLABICS_THA";
        case   0x1567: return "CANADIAN_SYLLABICS_THAA";
        case   0x1568: return "CANADIAN_SYLLABICS_THWAA";
        case   0x1569: return "CANADIAN_SYLLABICS_WEST_CREE_THWAA";
        case   0x156A: return "CANADIAN_SYLLABICS_TH";
        case   0x156B: return "CANADIAN_SYLLABICS_TTHE";
        case   0x156C: return "CANADIAN_SYLLABICS_TTHI";
        case   0x156D: return "CANADIAN_SYLLABICS_TTHO";
        case   0x156E: return "CANADIAN_SYLLABICS_TTHA";
        case   0x156F: return "CANADIAN_SYLLABICS_TTH";
        case   0x1570: return "CANADIAN_SYLLABICS_TYE";
        case   0x1571: return "CANADIAN_SYLLABICS_TYI";
        case   0x1572: return "CANADIAN_SYLLABICS_TYO";
        case   0x1573: return "CANADIAN_SYLLABICS_TYA";
        case   0x1574: return "CANADIAN_SYLLABICS_NUNAVIK_HE";
        case   0x1575: return "CANADIAN_SYLLABICS_NUNAVIK_HI";
        case   0x1576: return "CANADIAN_SYLLABICS_NUNAVIK_HII";
        case   0x1577: return "CANADIAN_SYLLABICS_NUNAVIK_HO";
        case   0x1578: return "CANADIAN_SYLLABICS_NUNAVIK_HOO";
        case   0x1579: return "CANADIAN_SYLLABICS_NUNAVIK_HA";
        case   0x157A: return "CANADIAN_SYLLABICS_NUNAVIK_HAA";
        case   0x157B: return "CANADIAN_SYLLABICS_NUNAVIK_H";
        case   0x157C: return "CANADIAN_SYLLABICS_NUNAVUT_H";
        case   0x157D: return "CANADIAN_SYLLABICS_HK";
        case   0x157E: return "CANADIAN_SYLLABICS_QAAI";
        case   0x157F: return "CANADIAN_SYLLABICS_QI";
        case   0x1580: return "CANADIAN_SYLLABICS_QII";
        case   0x1581: return "CANADIAN_SYLLABICS_QO";
        case   0x1582: return "CANADIAN_SYLLABICS_QOO";
        case   0x1583: return "CANADIAN_SYLLABICS_QA";
        case   0x1584: return "CANADIAN_SYLLABICS_QAA";
        case   0x1585: return "CANADIAN_SYLLABICS_Q";
        case   0x1586: return "CANADIAN_SYLLABICS_TLHE";
        case   0x1587: return "CANADIAN_SYLLABICS_TLHI";
        case   0x1588: return "CANADIAN_SYLLABICS_TLHO";
        case   0x1589: return "CANADIAN_SYLLABICS_TLHA";
        case   0x158A: return "CANADIAN_SYLLABICS_WEST_CREE_RE";
        case   0x158B: return "CANADIAN_SYLLABICS_WEST_CREE_RI";
        case   0x158C: return "CANADIAN_SYLLABICS_WEST_CREE_RO";
        case   0x158D: return "CANADIAN_SYLLABICS_WEST_CREE_RA";
        case   0x158E: return "CANADIAN_SYLLABICS_NGAAI";
        case   0x158F: return "CANADIAN_SYLLABICS_NGI";
        case   0x1590: return "CANADIAN_SYLLABICS_NGII";
        case   0x1591: return "CANADIAN_SYLLABICS_NGO";
        case   0x1592: return "CANADIAN_SYLLABICS_NGOO";
        case   0x1593: return "CANADIAN_SYLLABICS_NGA";
        case   0x1594: return "CANADIAN_SYLLABICS_NGAA";
        case   0x1595: return "CANADIAN_SYLLABICS_NG";
        case   0x1596: return "CANADIAN_SYLLABICS_NNG";
        case   0x1597: return "CANADIAN_SYLLABICS_SAYISI_SHE";
        case   0x1598: return "CANADIAN_SYLLABICS_SAYISI_SHI";
        case   0x1599: return "CANADIAN_SYLLABICS_SAYISI_SHO";
        case   0x159A: return "CANADIAN_SYLLABICS_SAYISI_SHA";
        case   0x159B: return "CANADIAN_SYLLABICS_WOODS_CREE_THE";
        case   0x159C: return "CANADIAN_SYLLABICS_WOODS_CREE_THI";
        case   0x159D: return "CANADIAN_SYLLABICS_WOODS_CREE_THO";
        case   0x159E: return "CANADIAN_SYLLABICS_WOODS_CREE_THA";
        case   0x159F: return "CANADIAN_SYLLABICS_WOODS_CREE_TH";
        case   0x15A0: return "CANADIAN_SYLLABICS_LHI";
        case   0x15A1: return "CANADIAN_SYLLABICS_LHII";
        case   0x15A2: return "CANADIAN_SYLLABICS_LHO";
        case   0x15A3: return "CANADIAN_SYLLABICS_LHOO";
        case   0x15A4: return "CANADIAN_SYLLABICS_LHA";
        case   0x15A5: return "CANADIAN_SYLLABICS_LHAA";
        case   0x15A6: return "CANADIAN_SYLLABICS_LH";
        case   0x15A7: return "CANADIAN_SYLLABICS_TH_CREE_THE";
        case   0x15A8: return "CANADIAN_SYLLABICS_TH_CREE_THI";
        case   0x15A9: return "CANADIAN_SYLLABICS_TH_CREE_THII";
        case   0x15AA: return "CANADIAN_SYLLABICS_TH_CREE_THO";
        case   0x15AB: return "CANADIAN_SYLLABICS_TH_CREE_THOO";
        case   0x15AC: return "CANADIAN_SYLLABICS_TH_CREE_THA";
        case   0x15AD: return "CANADIAN_SYLLABICS_TH_CREE_THAA";
        case   0x15AE: return "CANADIAN_SYLLABICS_TH_CREE_TH";
        case   0x15AF: return "CANADIAN_SYLLABICS_AIVILIK_B";
        case   0x15B0: return "CANADIAN_SYLLABICS_BLACKFOOT_E";
        case   0x15B1: return "CANADIAN_SYLLABICS_BLACKFOOT_I";
        case   0x15B2: return "CANADIAN_SYLLABICS_BLACKFOOT_O";
        case   0x15B3: return "CANADIAN_SYLLABICS_BLACKFOOT_A";
        case   0x15B4: return "CANADIAN_SYLLABICS_BLACKFOOT_WE";
        case   0x15B5: return "CANADIAN_SYLLABICS_BLACKFOOT_WI";
        case   0x15B6: return "CANADIAN_SYLLABICS_BLACKFOOT_WO";
        case   0x15B7: return "CANADIAN_SYLLABICS_BLACKFOOT_WA";
        case   0x15B8: return "CANADIAN_SYLLABICS_BLACKFOOT_NE";
        case   0x15B9: return "CANADIAN_SYLLABICS_BLACKFOOT_NI";
        case   0x15BA: return "CANADIAN_SYLLABICS_BLACKFOOT_NO";
        case   0x15BB: return "CANADIAN_SYLLABICS_BLACKFOOT_NA";
        case   0x15BC: return "CANADIAN_SYLLABICS_BLACKFOOT_KE";
        case   0x15BD: return "CANADIAN_SYLLABICS_BLACKFOOT_KI";
        case   0x15BE: return "CANADIAN_SYLLABICS_BLACKFOOT_KO";
        case   0x15BF: return "CANADIAN_SYLLABICS_BLACKFOOT_KA";
        case   0x15C0: return "CANADIAN_SYLLABICS_SAYISI_HE";
        case   0x15C1: return "CANADIAN_SYLLABICS_SAYISI_HI";
        case   0x15C2: return "CANADIAN_SYLLABICS_SAYISI_HO";
        case   0x15C3: return "CANADIAN_SYLLABICS_SAYISI_HA";
        case   0x15C4: return "CANADIAN_SYLLABICS_CARRIER_GHU";
        case   0x15C5: return "CANADIAN_SYLLABICS_CARRIER_GHO";
        case   0x15C6: return "CANADIAN_SYLLABICS_CARRIER_GHE";
        case   0x15C7: return "CANADIAN_SYLLABICS_CARRIER_GHEE";
        case   0x15C8: return "CANADIAN_SYLLABICS_CARRIER_GHI";
        case   0x15C9: return "CANADIAN_SYLLABICS_CARRIER_GHA";
        case   0x15CA: return "CANADIAN_SYLLABICS_CARRIER_RU";
        case   0x15CB: return "CANADIAN_SYLLABICS_CARRIER_RO";
        case   0x15CC: return "CANADIAN_SYLLABICS_CARRIER_RE";
        case   0x15CD: return "CANADIAN_SYLLABICS_CARRIER_REE";
        case   0x15CE: return "CANADIAN_SYLLABICS_CARRIER_RI";
        case   0x15CF: return "CANADIAN_SYLLABICS_CARRIER_RA";
        case   0x15D0: return "CANADIAN_SYLLABICS_CARRIER_WU";
        case   0x15D1: return "CANADIAN_SYLLABICS_CARRIER_WO";
        case   0x15D2: return "CANADIAN_SYLLABICS_CARRIER_WE";
        case   0x15D3: return "CANADIAN_SYLLABICS_CARRIER_WEE";
        case   0x15D4: return "CANADIAN_SYLLABICS_CARRIER_WI";
        case   0x15D5: return "CANADIAN_SYLLABICS_CARRIER_WA";
        case   0x15D6: return "CANADIAN_SYLLABICS_CARRIER_HWU";
        case   0x15D7: return "CANADIAN_SYLLABICS_CARRIER_HWO";
        case   0x15D8: return "CANADIAN_SYLLABICS_CARRIER_HWE";
        case   0x15D9: return "CANADIAN_SYLLABICS_CARRIER_HWEE";
        case   0x15DA: return "CANADIAN_SYLLABICS_CARRIER_HWI";
        case   0x15DB: return "CANADIAN_SYLLABICS_CARRIER_HWA";
        case   0x15DC: return "CANADIAN_SYLLABICS_CARRIER_THU";
        case   0x15DD: return "CANADIAN_SYLLABICS_CARRIER_THO";
        case   0x15DE: return "CANADIAN_SYLLABICS_CARRIER_THE";
        case   0x15DF: return "CANADIAN_SYLLABICS_CARRIER_THEE";
        case   0x15E0: return "CANADIAN_SYLLABICS_CARRIER_THI";
        case   0x15E1: return "CANADIAN_SYLLABICS_CARRIER_THA";
        case   0x15E2: return "CANADIAN_SYLLABICS_CARRIER_TTU";
        case   0x15E3: return "CANADIAN_SYLLABICS_CARRIER_TTO";
        case   0x15E4: return "CANADIAN_SYLLABICS_CARRIER_TTE";
        case   0x15E5: return "CANADIAN_SYLLABICS_CARRIER_TTEE";
        case   0x15E6: return "CANADIAN_SYLLABICS_CARRIER_TTI";
        case   0x15E7: return "CANADIAN_SYLLABICS_CARRIER_TTA";
        case   0x15E8: return "CANADIAN_SYLLABICS_CARRIER_PU";
        case   0x15E9: return "CANADIAN_SYLLABICS_CARRIER_PO";
        case   0x15EA: return "CANADIAN_SYLLABICS_CARRIER_PE";
        case   0x15EB: return "CANADIAN_SYLLABICS_CARRIER_PEE";
        case   0x15EC: return "CANADIAN_SYLLABICS_CARRIER_PI";
        case   0x15ED: return "CANADIAN_SYLLABICS_CARRIER_PA";
        case   0x15EE: return "CANADIAN_SYLLABICS_CARRIER_P";
        case   0x15EF: return "CANADIAN_SYLLABICS_CARRIER_GU";
        case   0x15F0: return "CANADIAN_SYLLABICS_CARRIER_GO";
        case   0x15F1: return "CANADIAN_SYLLABICS_CARRIER_GE";
        case   0x15F2: return "CANADIAN_SYLLABICS_CARRIER_GEE";
        case   0x15F3: return "CANADIAN_SYLLABICS_CARRIER_GI";
        case   0x15F4: return "CANADIAN_SYLLABICS_CARRIER_GA";
        case   0x15F5: return "CANADIAN_SYLLABICS_CARRIER_KHU";
        case   0x15F6: return "CANADIAN_SYLLABICS_CARRIER_KHO";
        case   0x15F7: return "CANADIAN_SYLLABICS_CARRIER_KHE";
        case   0x15F8: return "CANADIAN_SYLLABICS_CARRIER_KHEE";
        case   0x15F9: return "CANADIAN_SYLLABICS_CARRIER_KHI";
        case   0x15FA: return "CANADIAN_SYLLABICS_CARRIER_KHA";
        case   0x15FB: return "CANADIAN_SYLLABICS_CARRIER_KKU";
        case   0x15FC: return "CANADIAN_SYLLABICS_CARRIER_KKO";
        case   0x15FD: return "CANADIAN_SYLLABICS_CARRIER_KKE";
        case   0x15FE: return "CANADIAN_SYLLABICS_CARRIER_KKEE";
        case   0x15FF: return "CANADIAN_SYLLABICS_CARRIER_KKI";
        case   0x1600: return "CANADIAN_SYLLABICS_CARRIER_KKA";
        case   0x1601: return "CANADIAN_SYLLABICS_CARRIER_KK";
        case   0x1602: return "CANADIAN_SYLLABICS_CARRIER_NU";
        case   0x1603: return "CANADIAN_SYLLABICS_CARRIER_NO";
        case   0x1604: return "CANADIAN_SYLLABICS_CARRIER_NE";
        case   0x1605: return "CANADIAN_SYLLABICS_CARRIER_NEE";
        case   0x1606: return "CANADIAN_SYLLABICS_CARRIER_NI";
        case   0x1607: return "CANADIAN_SYLLABICS_CARRIER_NA";
        case   0x1608: return "CANADIAN_SYLLABICS_CARRIER_MU";
        case   0x1609: return "CANADIAN_SYLLABICS_CARRIER_MO";
        case   0x160A: return "CANADIAN_SYLLABICS_CARRIER_ME";
        case   0x160B: return "CANADIAN_SYLLABICS_CARRIER_MEE";
        case   0x160C: return "CANADIAN_SYLLABICS_CARRIER_MI";
        case   0x160D: return "CANADIAN_SYLLABICS_CARRIER_MA";
        case   0x160E: return "CANADIAN_SYLLABICS_CARRIER_YU";
        case   0x160F: return "CANADIAN_SYLLABICS_CARRIER_YO";
        case   0x1610: return "CANADIAN_SYLLABICS_CARRIER_YE";
        case   0x1611: return "CANADIAN_SYLLABICS_CARRIER_YEE";
        case   0x1612: return "CANADIAN_SYLLABICS_CARRIER_YI";
        case   0x1613: return "CANADIAN_SYLLABICS_CARRIER_YA";
        case   0x1614: return "CANADIAN_SYLLABICS_CARRIER_JU";
        case   0x1615: return "CANADIAN_SYLLABICS_SAYISI_JU";
        case   0x1616: return "CANADIAN_SYLLABICS_CARRIER_JO";
        case   0x1617: return "CANADIAN_SYLLABICS_CARRIER_JE";
        case   0x1618: return "CANADIAN_SYLLABICS_CARRIER_JEE";
        case   0x1619: return "CANADIAN_SYLLABICS_CARRIER_JI";
        case   0x161A: return "CANADIAN_SYLLABICS_SAYISI_JI";
        case   0x161B: return "CANADIAN_SYLLABICS_CARRIER_JA";
        case   0x161C: return "CANADIAN_SYLLABICS_CARRIER_JJU";
        case   0x161D: return "CANADIAN_SYLLABICS_CARRIER_JJO";
        case   0x161E: return "CANADIAN_SYLLABICS_CARRIER_JJE";
        case   0x161F: return "CANADIAN_SYLLABICS_CARRIER_JJEE";
        case   0x1620: return "CANADIAN_SYLLABICS_CARRIER_JJI";
        case   0x1621: return "CANADIAN_SYLLABICS_CARRIER_JJA";
        case   0x1622: return "CANADIAN_SYLLABICS_CARRIER_LU";
        case   0x1623: return "CANADIAN_SYLLABICS_CARRIER_LO";
        case   0x1624: return "CANADIAN_SYLLABICS_CARRIER_LE";
        case   0x1625: return "CANADIAN_SYLLABICS_CARRIER_LEE";
        case   0x1626: return "CANADIAN_SYLLABICS_CARRIER_LI";
        case   0x1627: return "CANADIAN_SYLLABICS_CARRIER_LA";
        case   0x1628: return "CANADIAN_SYLLABICS_CARRIER_DLU";
        case   0x1629: return "CANADIAN_SYLLABICS_CARRIER_DLO";
        case   0x162A: return "CANADIAN_SYLLABICS_CARRIER_DLE";
        case   0x162B: return "CANADIAN_SYLLABICS_CARRIER_DLEE";
        case   0x162C: return "CANADIAN_SYLLABICS_CARRIER_DLI";
        case   0x162D: return "CANADIAN_SYLLABICS_CARRIER_DLA";
        case   0x162E: return "CANADIAN_SYLLABICS_CARRIER_LHU";
        case   0x162F: return "CANADIAN_SYLLABICS_CARRIER_LHO";
        case   0x1630: return "CANADIAN_SYLLABICS_CARRIER_LHE";
        case   0x1631: return "CANADIAN_SYLLABICS_CARRIER_LHEE";
        case   0x1632: return "CANADIAN_SYLLABICS_CARRIER_LHI";
        case   0x1633: return "CANADIAN_SYLLABICS_CARRIER_LHA";
        case   0x1634: return "CANADIAN_SYLLABICS_CARRIER_TLHU";
        case   0x1635: return "CANADIAN_SYLLABICS_CARRIER_TLHO";
        case   0x1636: return "CANADIAN_SYLLABICS_CARRIER_TLHE";
        case   0x1637: return "CANADIAN_SYLLABICS_CARRIER_TLHEE";
        case   0x1638: return "CANADIAN_SYLLABICS_CARRIER_TLHI";
        case   0x1639: return "CANADIAN_SYLLABICS_CARRIER_TLHA";
        case   0x163A: return "CANADIAN_SYLLABICS_CARRIER_TLU";
        case   0x163B: return "CANADIAN_SYLLABICS_CARRIER_TLO";
        case   0x163C: return "CANADIAN_SYLLABICS_CARRIER_TLE";
        case   0x163D: return "CANADIAN_SYLLABICS_CARRIER_TLEE";
        case   0x163E: return "CANADIAN_SYLLABICS_CARRIER_TLI";
        case   0x163F: return "CANADIAN_SYLLABICS_CARRIER_TLA";
        case   0x1640: return "CANADIAN_SYLLABICS_CARRIER_ZU";
        case   0x1641: return "CANADIAN_SYLLABICS_CARRIER_ZO";
        case   0x1642: return "CANADIAN_SYLLABICS_CARRIER_ZE";
        case   0x1643: return "CANADIAN_SYLLABICS_CARRIER_ZEE";
        case   0x1644: return "CANADIAN_SYLLABICS_CARRIER_ZI";
        case   0x1645: return "CANADIAN_SYLLABICS_CARRIER_ZA";
        case   0x1646: return "CANADIAN_SYLLABICS_CARRIER_Z";
        case   0x1647: return "CANADIAN_SYLLABICS_CARRIER_INITIAL_Z";
        case   0x1648: return "CANADIAN_SYLLABICS_CARRIER_DZU";
        case   0x1649: return "CANADIAN_SYLLABICS_CARRIER_DZO";
        case   0x164A: return "CANADIAN_SYLLABICS_CARRIER_DZE";
        case   0x164B: return "CANADIAN_SYLLABICS_CARRIER_DZEE";
        case   0x164C: return "CANADIAN_SYLLABICS_CARRIER_DZI";
        case   0x164D: return "CANADIAN_SYLLABICS_CARRIER_DZA";
        case   0x164E: return "CANADIAN_SYLLABICS_CARRIER_SU";
        case   0x164F: return "CANADIAN_SYLLABICS_CARRIER_SO";
        case   0x1650: return "CANADIAN_SYLLABICS_CARRIER_SE";
        case   0x1651: return "CANADIAN_SYLLABICS_CARRIER_SEE";
        case   0x1652: return "CANADIAN_SYLLABICS_CARRIER_SI";
        case   0x1653: return "CANADIAN_SYLLABICS_CARRIER_SA";
        case   0x1654: return "CANADIAN_SYLLABICS_CARRIER_SHU";
        case   0x1655: return "CANADIAN_SYLLABICS_CARRIER_SHO";
        case   0x1656: return "CANADIAN_SYLLABICS_CARRIER_SHE";
        case   0x1657: return "CANADIAN_SYLLABICS_CARRIER_SHEE";
        case   0x1658: return "CANADIAN_SYLLABICS_CARRIER_SHI";
        case   0x1659: return "CANADIAN_SYLLABICS_CARRIER_SHA";
        case   0x165A: return "CANADIAN_SYLLABICS_CARRIER_SH";
        case   0x165B: return "CANADIAN_SYLLABICS_CARRIER_TSU";
        case   0x165C: return "CANADIAN_SYLLABICS_CARRIER_TSO";
        case   0x165D: return "CANADIAN_SYLLABICS_CARRIER_TSE";
        case   0x165E: return "CANADIAN_SYLLABICS_CARRIER_TSEE";
        case   0x165F: return "CANADIAN_SYLLABICS_CARRIER_TSI";
        case   0x1660: return "CANADIAN_SYLLABICS_CARRIER_TSA";
        case   0x1661: return "CANADIAN_SYLLABICS_CARRIER_CHU";
        case   0x1662: return "CANADIAN_SYLLABICS_CARRIER_CHO";
        case   0x1663: return "CANADIAN_SYLLABICS_CARRIER_CHE";
        case   0x1664: return "CANADIAN_SYLLABICS_CARRIER_CHEE";
        case   0x1665: return "CANADIAN_SYLLABICS_CARRIER_CHI";
        case   0x1666: return "CANADIAN_SYLLABICS_CARRIER_CHA";
        case   0x1667: return "CANADIAN_SYLLABICS_CARRIER_TTSU";
        case   0x1668: return "CANADIAN_SYLLABICS_CARRIER_TTSO";
        case   0x1669: return "CANADIAN_SYLLABICS_CARRIER_TTSE";
        case   0x166A: return "CANADIAN_SYLLABICS_CARRIER_TTSEE";
        case   0x166B: return "CANADIAN_SYLLABICS_CARRIER_TTSI";
        case   0x166C: return "CANADIAN_SYLLABICS_CARRIER_TTSA";
        case   0x166D: return "CANADIAN_SYLLABICS_CHI_SIGN";
        case   0x166E: return "CANADIAN_SYLLABICS_FULL_STOP";
        case   0x166F: return "CANADIAN_SYLLABICS_QAI";
        case   0x1670: return "CANADIAN_SYLLABICS_NGAI";
        case   0x1671: return "CANADIAN_SYLLABICS_NNGI";
        case   0x1672: return "CANADIAN_SYLLABICS_NNGII";
        case   0x1673: return "CANADIAN_SYLLABICS_NNGO";
        case   0x1674: return "CANADIAN_SYLLABICS_NNGOO";
        case   0x1675: return "CANADIAN_SYLLABICS_NNGA";
        case   0x1676: return "CANADIAN_SYLLABICS_NNGAA";
        case   0x1677: return "CANADIAN_SYLLABICS_WOODS_CREE_THWEE";
        case   0x1678: return "CANADIAN_SYLLABICS_WOODS_CREE_THWI";
        case   0x1679: return "CANADIAN_SYLLABICS_WOODS_CREE_THWII";
        case   0x167A: return "CANADIAN_SYLLABICS_WOODS_CREE_THWO";
        case   0x167B: return "CANADIAN_SYLLABICS_WOODS_CREE_THWOO";
        case   0x167C: return "CANADIAN_SYLLABICS_WOODS_CREE_THWA";
        case   0x167D: return "CANADIAN_SYLLABICS_WOODS_CREE_THWAA";
        case   0x167E: return "CANADIAN_SYLLABICS_WOODS_CREE_FINAL_TH";
        case   0x167F: return "CANADIAN_SYLLABICS_BLACKFOOT_W";
        case   0x1680: return "OGHAM_SPACE_MARK";
        case   0x1681: return "OGHAM_LETTER_BEITH";
        case   0x1682: return "OGHAM_LETTER_LUIS";
        case   0x1683: return "OGHAM_LETTER_FEARN";
        case   0x1684: return "OGHAM_LETTER_SAIL";
        case   0x1685: return "OGHAM_LETTER_NION";
        case   0x1686: return "OGHAM_LETTER_UATH";
        case   0x1687: return "OGHAM_LETTER_DAIR";
        case   0x1688: return "OGHAM_LETTER_TINNE";
        case   0x1689: return "OGHAM_LETTER_COLL";
        case   0x168A: return "OGHAM_LETTER_CEIRT";
        case   0x168B: return "OGHAM_LETTER_MUIN";
        case   0x168C: return "OGHAM_LETTER_GORT";
        case   0x168D: return "OGHAM_LETTER_NGEADAL";
        case   0x168E: return "OGHAM_LETTER_STRAIF";
        case   0x168F: return "OGHAM_LETTER_RUIS";
        case   0x1690: return "OGHAM_LETTER_AILM";
        case   0x1691: return "OGHAM_LETTER_ONN";
        case   0x1692: return "OGHAM_LETTER_UR";
        case   0x1693: return "OGHAM_LETTER_EADHADH";
        case   0x1694: return "OGHAM_LETTER_IODHADH";
        case   0x1695: return "OGHAM_LETTER_EABHADH";
        case   0x1696: return "OGHAM_LETTER_OR";
        case   0x1697: return "OGHAM_LETTER_UILLEANN";
        case   0x1698: return "OGHAM_LETTER_IFIN";
        case   0x1699: return "OGHAM_LETTER_EAMHANCHOLL";
        case   0x169A: return "OGHAM_LETTER_PEITH";
        case   0x169B: return "OGHAM_FEATHER_MARK";
        case   0x169C: return "OGHAM_REVERSED_FEATHER_MARK";
        case   0x16A0: return "RUNIC_LETTER_FEHU_FEOH_FE_F";
        case   0x16A1: return "RUNIC_LETTER_V";
        case   0x16A2: return "RUNIC_LETTER_URUZ_UR_U";
        case   0x16A3: return "RUNIC_LETTER_YR";
        case   0x16A4: return "RUNIC_LETTER_Y";
        case   0x16A5: return "RUNIC_LETTER_W";
        case   0x16A6: return "RUNIC_LETTER_THURISAZ_THURS_THORN";
        case   0x16A7: return "RUNIC_LETTER_ETH";
        case   0x16A8: return "RUNIC_LETTER_ANSUZ_A";
        case   0x16A9: return "RUNIC_LETTER_OS_O";
        case   0x16AA: return "RUNIC_LETTER_AC_A";
        case   0x16AB: return "RUNIC_LETTER_AESC";
        case   0x16AC: return "RUNIC_LETTER_LONG_BRANCH_OSS_O";
        case   0x16AD: return "RUNIC_LETTER_SHORT_TWIG_OSS_O";
        case   0x16AE: return "RUNIC_LETTER_O";
        case   0x16AF: return "RUNIC_LETTER_OE";
        case   0x16B0: return "RUNIC_LETTER_ON";
        case   0x16B1: return "RUNIC_LETTER_RAIDO_RAD_REID_R";
        case   0x16B2: return "RUNIC_LETTER_KAUNA";
        case   0x16B3: return "RUNIC_LETTER_CEN";
        case   0x16B4: return "RUNIC_LETTER_KAUN_K";
        case   0x16B5: return "RUNIC_LETTER_G";
        case   0x16B6: return "RUNIC_LETTER_ENG";
        case   0x16B7: return "RUNIC_LETTER_GEBO_GYFU_G";
        case   0x16B8: return "RUNIC_LETTER_GAR";
        case   0x16B9: return "RUNIC_LETTER_WUNJO_WYNN_W";
        case   0x16BA: return "RUNIC_LETTER_HAGLAZ_H";
        case   0x16BB: return "RUNIC_LETTER_HAEGL_H";
        case   0x16BC: return "RUNIC_LETTER_LONG_BRANCH_HAGALL_H";
        case   0x16BD: return "RUNIC_LETTER_SHORT_TWIG_HAGALL_H";
        case   0x16BE: return "RUNIC_LETTER_NAUDIZ_NYD_NAUD_N";
        case   0x16BF: return "RUNIC_LETTER_SHORT_TWIG_NAUD_N";
        case   0x16C0: return "RUNIC_LETTER_DOTTED_N";
        case   0x16C1: return "RUNIC_LETTER_ISAZ_IS_ISS_I";
        case   0x16C2: return "RUNIC_LETTER_E";
        case   0x16C3: return "RUNIC_LETTER_JERAN_J";
        case   0x16C4: return "RUNIC_LETTER_GER";
        case   0x16C5: return "RUNIC_LETTER_LONG_BRANCH_AR_AE";
        case   0x16C6: return "RUNIC_LETTER_SHORT_TWIG_AR_A";
        case   0x16C7: return "RUNIC_LETTER_IWAZ_EOH";
        case   0x16C8: return "RUNIC_LETTER_PERTHO_PEORTH_P";
        case   0x16C9: return "RUNIC_LETTER_ALGIZ_EOLHX";
        case   0x16CA: return "RUNIC_LETTER_SOWILO_S";
        case   0x16CB: return "RUNIC_LETTER_SIGEL_LONG_BRANCH_SOL_S";
        case   0x16CC: return "RUNIC_LETTER_SHORT_TWIG_SOL_S";
        case   0x16CD: return "RUNIC_LETTER_C";
        case   0x16CE: return "RUNIC_LETTER_Z";
        case   0x16CF: return "RUNIC_LETTER_TIWAZ_TIR_TYR_T";
        case   0x16D0: return "RUNIC_LETTER_SHORT_TWIG_TYR_T";
        case   0x16D1: return "RUNIC_LETTER_D";
        case   0x16D2: return "RUNIC_LETTER_BERKANAN_BEORC_BJARKAN_B";
        case   0x16D3: return "RUNIC_LETTER_SHORT_TWIG_BJARKAN_B";
        case   0x16D4: return "RUNIC_LETTER_DOTTED_P";
        case   0x16D5: return "RUNIC_LETTER_OPEN_P";
        case   0x16D6: return "RUNIC_LETTER_EHWAZ_EH_E";
        case   0x16D7: return "RUNIC_LETTER_MANNAZ_MAN_M";
        case   0x16D8: return "RUNIC_LETTER_LONG_BRANCH_MADR_M";
        case   0x16D9: return "RUNIC_LETTER_SHORT_TWIG_MADR_M";
        case   0x16DA: return "RUNIC_LETTER_LAUKAZ_LAGU_LOGR_L";
        case   0x16DB: return "RUNIC_LETTER_DOTTED_L";
        case   0x16DC: return "RUNIC_LETTER_INGWAZ";
        case   0x16DD: return "RUNIC_LETTER_ING";
        case   0x16DE: return "RUNIC_LETTER_DAGAZ_DAEG_D";
        case   0x16DF: return "RUNIC_LETTER_OTHALAN_ETHEL_O";
        case   0x16E0: return "RUNIC_LETTER_EAR";
        case   0x16E1: return "RUNIC_LETTER_IOR";
        case   0x16E2: return "RUNIC_LETTER_CWEORTH";
        case   0x16E3: return "RUNIC_LETTER_CALC";
        case   0x16E4: return "RUNIC_LETTER_CEALC";
        case   0x16E5: return "RUNIC_LETTER_STAN";
        case   0x16E6: return "RUNIC_LETTER_LONG_BRANCH_YR";
        case   0x16E7: return "RUNIC_LETTER_SHORT_TWIG_YR";
        case   0x16E8: return "RUNIC_LETTER_ICELANDIC_YR";
        case   0x16E9: return "RUNIC_LETTER_Q";
        case   0x16EA: return "RUNIC_LETTER_X";
        case   0x16EB: return "RUNIC_SINGLE_PUNCTUATION";
        case   0x16EC: return "RUNIC_MULTIPLE_PUNCTUATION";
        case   0x16ED: return "RUNIC_CROSS_PUNCTUATION";
        case   0x16EE: return "RUNIC_ARLAUG_SYMBOL";
        case   0x16EF: return "RUNIC_TVIMADUR_SYMBOL";
        case   0x16F0: return "RUNIC_BELGTHOR_SYMBOL";
        case   0x16F1: return "RUNIC_LETTER_K";
        case   0x16F2: return "RUNIC_LETTER_SH";
        case   0x16F3: return "RUNIC_LETTER_OO";
        case   0x16F4: return "RUNIC_LETTER_FRANKS_CASKET_OS";
        case   0x16F5: return "RUNIC_LETTER_FRANKS_CASKET_IS";
        case   0x16F6: return "RUNIC_LETTER_FRANKS_CASKET_EH";
        case   0x16F7: return "RUNIC_LETTER_FRANKS_CASKET_AC";
        case   0x16F8: return "RUNIC_LETTER_FRANKS_CASKET_AESC";
        case   0x1700: return "TAGALOG_LETTER_A";
        case   0x1701: return "TAGALOG_LETTER_I";
        case   0x1702: return "TAGALOG_LETTER_U";
        case   0x1703: return "TAGALOG_LETTER_KA";
        case   0x1704: return "TAGALOG_LETTER_GA";
        case   0x1705: return "TAGALOG_LETTER_NGA";
        case   0x1706: return "TAGALOG_LETTER_TA";
        case   0x1707: return "TAGALOG_LETTER_DA";
        case   0x1708: return "TAGALOG_LETTER_NA";
        case   0x1709: return "TAGALOG_LETTER_PA";
        case   0x170A: return "TAGALOG_LETTER_BA";
        case   0x170B: return "TAGALOG_LETTER_MA";
        case   0x170C: return "TAGALOG_LETTER_YA";
        case   0x170E: return "TAGALOG_LETTER_LA";
        case   0x170F: return "TAGALOG_LETTER_WA";
        case   0x1710: return "TAGALOG_LETTER_SA";
        case   0x1711: return "TAGALOG_LETTER_HA";
        case   0x1712: return "TAGALOG_VOWEL_SIGN_I";
        case   0x1713: return "TAGALOG_VOWEL_SIGN_U";
        case   0x1714: return "TAGALOG_SIGN_VIRAMA";
        case   0x1720: return "HANUNOO_LETTER_A";
        case   0x1721: return "HANUNOO_LETTER_I";
        case   0x1722: return "HANUNOO_LETTER_U";
        case   0x1723: return "HANUNOO_LETTER_KA";
        case   0x1724: return "HANUNOO_LETTER_GA";
        case   0x1725: return "HANUNOO_LETTER_NGA";
        case   0x1726: return "HANUNOO_LETTER_TA";
        case   0x1727: return "HANUNOO_LETTER_DA";
        case   0x1728: return "HANUNOO_LETTER_NA";
        case   0x1729: return "HANUNOO_LETTER_PA";
        case   0x172A: return "HANUNOO_LETTER_BA";
        case   0x172B: return "HANUNOO_LETTER_MA";
        case   0x172C: return "HANUNOO_LETTER_YA";
        case   0x172D: return "HANUNOO_LETTER_RA";
        case   0x172E: return "HANUNOO_LETTER_LA";
        case   0x172F: return "HANUNOO_LETTER_WA";
        case   0x1730: return "HANUNOO_LETTER_SA";
        case   0x1731: return "HANUNOO_LETTER_HA";
        case   0x1732: return "HANUNOO_VOWEL_SIGN_I";
        case   0x1733: return "HANUNOO_VOWEL_SIGN_U";
        case   0x1734: return "HANUNOO_SIGN_PAMUDPOD";
        case   0x1735: return "PHILIPPINE_SINGLE_PUNCTUATION";
        case   0x1736: return "PHILIPPINE_DOUBLE_PUNCTUATION";
        case   0x1740: return "BUHID_LETTER_A";
        case   0x1741: return "BUHID_LETTER_I";
        case   0x1742: return "BUHID_LETTER_U";
        case   0x1743: return "BUHID_LETTER_KA";
        case   0x1744: return "BUHID_LETTER_GA";
        case   0x1745: return "BUHID_LETTER_NGA";
        case   0x1746: return "BUHID_LETTER_TA";
        case   0x1747: return "BUHID_LETTER_DA";
        case   0x1748: return "BUHID_LETTER_NA";
        case   0x1749: return "BUHID_LETTER_PA";
        case   0x174A: return "BUHID_LETTER_BA";
        case   0x174B: return "BUHID_LETTER_MA";
        case   0x174C: return "BUHID_LETTER_YA";
        case   0x174D: return "BUHID_LETTER_RA";
        case   0x174E: return "BUHID_LETTER_LA";
        case   0x174F: return "BUHID_LETTER_WA";
        case   0x1750: return "BUHID_LETTER_SA";
        case   0x1751: return "BUHID_LETTER_HA";
        case   0x1752: return "BUHID_VOWEL_SIGN_I";
        case   0x1753: return "BUHID_VOWEL_SIGN_U";
        case   0x1760: return "TAGBANWA_LETTER_A";
        case   0x1761: return "TAGBANWA_LETTER_I";
        case   0x1762: return "TAGBANWA_LETTER_U";
        case   0x1763: return "TAGBANWA_LETTER_KA";
        case   0x1764: return "TAGBANWA_LETTER_GA";
        case   0x1765: return "TAGBANWA_LETTER_NGA";
        case   0x1766: return "TAGBANWA_LETTER_TA";
        case   0x1767: return "TAGBANWA_LETTER_DA";
        case   0x1768: return "TAGBANWA_LETTER_NA";
        case   0x1769: return "TAGBANWA_LETTER_PA";
        case   0x176A: return "TAGBANWA_LETTER_BA";
        case   0x176B: return "TAGBANWA_LETTER_MA";
        case   0x176C: return "TAGBANWA_LETTER_YA";
        case   0x176E: return "TAGBANWA_LETTER_LA";
        case   0x176F: return "TAGBANWA_LETTER_WA";
        case   0x1770: return "TAGBANWA_LETTER_SA";
        case   0x1772: return "TAGBANWA_VOWEL_SIGN_I";
        case   0x1773: return "TAGBANWA_VOWEL_SIGN_U";
        case   0x1780: return "KHMER_LETTER_KA";
        case   0x1781: return "KHMER_LETTER_KHA";
        case   0x1782: return "KHMER_LETTER_KO";
        case   0x1783: return "KHMER_LETTER_KHO";
        case   0x1784: return "KHMER_LETTER_NGO";
        case   0x1785: return "KHMER_LETTER_CA";
        case   0x1786: return "KHMER_LETTER_CHA";
        case   0x1787: return "KHMER_LETTER_CO";
        case   0x1788: return "KHMER_LETTER_CHO";
        case   0x1789: return "KHMER_LETTER_NYO";
        case   0x178A: return "KHMER_LETTER_DA";
        case   0x178B: return "KHMER_LETTER_TTHA";
        case   0x178C: return "KHMER_LETTER_DO";
        case   0x178D: return "KHMER_LETTER_TTHO";
        case   0x178E: return "KHMER_LETTER_NNO";
        case   0x178F: return "KHMER_LETTER_TA";
        case   0x1790: return "KHMER_LETTER_THA";
        case   0x1791: return "KHMER_LETTER_TO";
        case   0x1792: return "KHMER_LETTER_THO";
        case   0x1793: return "KHMER_LETTER_NO";
        case   0x1794: return "KHMER_LETTER_BA";
        case   0x1795: return "KHMER_LETTER_PHA";
        case   0x1796: return "KHMER_LETTER_PO";
        case   0x1797: return "KHMER_LETTER_PHO";
        case   0x1798: return "KHMER_LETTER_MO";
        case   0x1799: return "KHMER_LETTER_YO";
        case   0x179A: return "KHMER_LETTER_RO";
        case   0x179B: return "KHMER_LETTER_LO";
        case   0x179C: return "KHMER_LETTER_VO";
        case   0x179D: return "KHMER_LETTER_SHA";
        case   0x179E: return "KHMER_LETTER_SSO";
        case   0x179F: return "KHMER_LETTER_SA";
        case   0x17A0: return "KHMER_LETTER_HA";
        case   0x17A1: return "KHMER_LETTER_LA";
        case   0x17A2: return "KHMER_LETTER_QA";
        case   0x17A3: return "KHMER_INDEPENDENT_VOWEL_QAQ";
        case   0x17A4: return "KHMER_INDEPENDENT_VOWEL_QAA";
        case   0x17A5: return "KHMER_INDEPENDENT_VOWEL_QI";
        case   0x17A6: return "KHMER_INDEPENDENT_VOWEL_QII";
        case   0x17A7: return "KHMER_INDEPENDENT_VOWEL_QU";
        case   0x17A8: return "KHMER_INDEPENDENT_VOWEL_QUK";
        case   0x17A9: return "KHMER_INDEPENDENT_VOWEL_QUU";
        case   0x17AA: return "KHMER_INDEPENDENT_VOWEL_QUUV";
        case   0x17AB: return "KHMER_INDEPENDENT_VOWEL_RY";
        case   0x17AC: return "KHMER_INDEPENDENT_VOWEL_RYY";
        case   0x17AD: return "KHMER_INDEPENDENT_VOWEL_LY";
        case   0x17AE: return "KHMER_INDEPENDENT_VOWEL_LYY";
        case   0x17AF: return "KHMER_INDEPENDENT_VOWEL_QE";
        case   0x17B0: return "KHMER_INDEPENDENT_VOWEL_QAI";
        case   0x17B1: return "KHMER_INDEPENDENT_VOWEL_QOO_TYPE_ONE";
        case   0x17B2: return "KHMER_INDEPENDENT_VOWEL_QOO_TYPE_TWO";
        case   0x17B3: return "KHMER_INDEPENDENT_VOWEL_QAU";
        case   0x17B4: return "KHMER_VOWEL_INHERENT_AQ";
        case   0x17B5: return "KHMER_VOWEL_INHERENT_AA";
        case   0x17B6: return "KHMER_VOWEL_SIGN_AA";
        case   0x17B7: return "KHMER_VOWEL_SIGN_I";
        case   0x17B8: return "KHMER_VOWEL_SIGN_II";
        case   0x17B9: return "KHMER_VOWEL_SIGN_Y";
        case   0x17BA: return "KHMER_VOWEL_SIGN_YY";
        case   0x17BB: return "KHMER_VOWEL_SIGN_U";
        case   0x17BC: return "KHMER_VOWEL_SIGN_UU";
        case   0x17BD: return "KHMER_VOWEL_SIGN_UA";
        case   0x17BE: return "KHMER_VOWEL_SIGN_OE";
        case   0x17BF: return "KHMER_VOWEL_SIGN_YA";
        case   0x17C0: return "KHMER_VOWEL_SIGN_IE";
        case   0x17C1: return "KHMER_VOWEL_SIGN_E";
        case   0x17C2: return "KHMER_VOWEL_SIGN_AE";
        case   0x17C3: return "KHMER_VOWEL_SIGN_AI";
        case   0x17C4: return "KHMER_VOWEL_SIGN_OO";
        case   0x17C5: return "KHMER_VOWEL_SIGN_AU";
        case   0x17C6: return "KHMER_SIGN_NIKAHIT";
        case   0x17C7: return "KHMER_SIGN_REAHMUK";
        case   0x17C8: return "KHMER_SIGN_YUUKALEAPINTU";
        case   0x17C9: return "KHMER_SIGN_MUUSIKATOAN";
        case   0x17CA: return "KHMER_SIGN_TRIISAP";
        case   0x17CB: return "KHMER_SIGN_BANTOC";
        case   0x17CC: return "KHMER_SIGN_ROBAT";
        case   0x17CD: return "KHMER_SIGN_TOANDAKHIAT";
        case   0x17CE: return "KHMER_SIGN_KAKABAT";
        case   0x17CF: return "KHMER_SIGN_AHSDA";
        case   0x17D0: return "KHMER_SIGN_SAMYOK_SANNYA";
        case   0x17D1: return "KHMER_SIGN_VIRIAM";
        case   0x17D2: return "KHMER_SIGN_COENG";
        case   0x17D3: return "KHMER_SIGN_BATHAMASAT";
        case   0x17D4: return "KHMER_SIGN_KHAN";
        case   0x17D5: return "KHMER_SIGN_BARIYOOSAN";
        case   0x17D6: return "KHMER_SIGN_CAMNUC_PII_KUUH";
        case   0x17D7: return "KHMER_SIGN_LEK_TOO";
        case   0x17D8: return "KHMER_SIGN_BEYYAL";
        case   0x17D9: return "KHMER_SIGN_PHNAEK_MUAN";
        case   0x17DA: return "KHMER_SIGN_KOOMUUT";
        case   0x17DB: return "KHMER_CURRENCY_SYMBOL_RIEL";
        case   0x17DC: return "KHMER_SIGN_AVAKRAHASANYA";
        case   0x17DD: return "KHMER_SIGN_ATTHACAN";
        case   0x17E0: return "KHMER_DIGIT_ZERO";
        case   0x17E1: return "KHMER_DIGIT_ONE";
        case   0x17E2: return "KHMER_DIGIT_TWO";
        case   0x17E3: return "KHMER_DIGIT_THREE";
        case   0x17E4: return "KHMER_DIGIT_FOUR";
        case   0x17E5: return "KHMER_DIGIT_FIVE";
        case   0x17E6: return "KHMER_DIGIT_SIX";
        case   0x17E7: return "KHMER_DIGIT_SEVEN";
        case   0x17E8: return "KHMER_DIGIT_EIGHT";
        case   0x17E9: return "KHMER_DIGIT_NINE";
        case   0x17F0: return "KHMER_SYMBOL_LEK_ATTAK_SON";
        case   0x17F1: return "KHMER_SYMBOL_LEK_ATTAK_MUOY";
        case   0x17F2: return "KHMER_SYMBOL_LEK_ATTAK_PII";
        case   0x17F3: return "KHMER_SYMBOL_LEK_ATTAK_BEI";
        case   0x17F4: return "KHMER_SYMBOL_LEK_ATTAK_BUON";
        case   0x17F5: return "KHMER_SYMBOL_LEK_ATTAK_PRAM";
        case   0x17F6: return "KHMER_SYMBOL_LEK_ATTAK_PRAM_MUOY";
        case   0x17F7: return "KHMER_SYMBOL_LEK_ATTAK_PRAM_PII";
        case   0x17F8: return "KHMER_SYMBOL_LEK_ATTAK_PRAM_BEI";
        case   0x17F9: return "KHMER_SYMBOL_LEK_ATTAK_PRAM_BUON";
        case   0x1800: return "MONGOLIAN_BIRGA";
        case   0x1801: return "MONGOLIAN_ELLIPSIS";
        case   0x1802: return "MONGOLIAN_COMMA";
        case   0x1803: return "MONGOLIAN_FULL_STOP";
        case   0x1804: return "MONGOLIAN_COLON";
        case   0x1805: return "MONGOLIAN_FOUR_DOTS";
        case   0x1806: return "MONGOLIAN_TODO_SOFT_HYPHEN";
        case   0x1807: return "MONGOLIAN_SIBE_SYLLABLE_BOUNDARY_MARKER";
        case   0x1808: return "MONGOLIAN_MANCHU_COMMA";
        case   0x1809: return "MONGOLIAN_MANCHU_FULL_STOP";
        case   0x180A: return "MONGOLIAN_NIRUGU";
        case   0x180B: return "MONGOLIAN_FREE_VARIATION_SELECTOR_ONE";
        case   0x180C: return "MONGOLIAN_FREE_VARIATION_SELECTOR_TWO";
        case   0x180D: return "MONGOLIAN_FREE_VARIATION_SELECTOR_THREE";
        case   0x180E: return "MONGOLIAN_VOWEL_SEPARATOR";
        case   0x1810: return "MONGOLIAN_DIGIT_ZERO";
        case   0x1811: return "MONGOLIAN_DIGIT_ONE";
        case   0x1812: return "MONGOLIAN_DIGIT_TWO";
        case   0x1813: return "MONGOLIAN_DIGIT_THREE";
        case   0x1814: return "MONGOLIAN_DIGIT_FOUR";
        case   0x1815: return "MONGOLIAN_DIGIT_FIVE";
        case   0x1816: return "MONGOLIAN_DIGIT_SIX";
        case   0x1817: return "MONGOLIAN_DIGIT_SEVEN";
        case   0x1818: return "MONGOLIAN_DIGIT_EIGHT";
        case   0x1819: return "MONGOLIAN_DIGIT_NINE";
        case   0x1820: return "MONGOLIAN_LETTER_A";
        case   0x1821: return "MONGOLIAN_LETTER_E";
        case   0x1822: return "MONGOLIAN_LETTER_I";
        case   0x1823: return "MONGOLIAN_LETTER_O";
        case   0x1824: return "MONGOLIAN_LETTER_U";
        case   0x1825: return "MONGOLIAN_LETTER_OE";
        case   0x1826: return "MONGOLIAN_LETTER_UE";
        case   0x1827: return "MONGOLIAN_LETTER_EE";
        case   0x1828: return "MONGOLIAN_LETTER_NA";
        case   0x1829: return "MONGOLIAN_LETTER_ANG";
        case   0x182A: return "MONGOLIAN_LETTER_BA";
        case   0x182B: return "MONGOLIAN_LETTER_PA";
        case   0x182C: return "MONGOLIAN_LETTER_QA";
        case   0x182D: return "MONGOLIAN_LETTER_GA";
        case   0x182E: return "MONGOLIAN_LETTER_MA";
        case   0x182F: return "MONGOLIAN_LETTER_LA";
        case   0x1830: return "MONGOLIAN_LETTER_SA";
        case   0x1831: return "MONGOLIAN_LETTER_SHA";
        case   0x1832: return "MONGOLIAN_LETTER_TA";
        case   0x1833: return "MONGOLIAN_LETTER_DA";
        case   0x1834: return "MONGOLIAN_LETTER_CHA";
        case   0x1835: return "MONGOLIAN_LETTER_JA";
        case   0x1836: return "MONGOLIAN_LETTER_YA";
        case   0x1837: return "MONGOLIAN_LETTER_RA";
        case   0x1838: return "MONGOLIAN_LETTER_WA";
        case   0x1839: return "MONGOLIAN_LETTER_FA";
        case   0x183A: return "MONGOLIAN_LETTER_KA";
        case   0x183B: return "MONGOLIAN_LETTER_KHA";
        case   0x183C: return "MONGOLIAN_LETTER_TSA";
        case   0x183D: return "MONGOLIAN_LETTER_ZA";
        case   0x183E: return "MONGOLIAN_LETTER_HAA";
        case   0x183F: return "MONGOLIAN_LETTER_ZRA";
        case   0x1840: return "MONGOLIAN_LETTER_LHA";
        case   0x1841: return "MONGOLIAN_LETTER_ZHI";
        case   0x1842: return "MONGOLIAN_LETTER_CHI";
        case   0x1843: return "MONGOLIAN_LETTER_TODO_LONG_VOWEL_SIGN";
        case   0x1844: return "MONGOLIAN_LETTER_TODO_E";
        case   0x1845: return "MONGOLIAN_LETTER_TODO_I";
        case   0x1846: return "MONGOLIAN_LETTER_TODO_O";
        case   0x1847: return "MONGOLIAN_LETTER_TODO_U";
        case   0x1848: return "MONGOLIAN_LETTER_TODO_OE";
        case   0x1849: return "MONGOLIAN_LETTER_TODO_UE";
        case   0x184A: return "MONGOLIAN_LETTER_TODO_ANG";
        case   0x184B: return "MONGOLIAN_LETTER_TODO_BA";
        case   0x184C: return "MONGOLIAN_LETTER_TODO_PA";
        case   0x184D: return "MONGOLIAN_LETTER_TODO_QA";
        case   0x184E: return "MONGOLIAN_LETTER_TODO_GA";
        case   0x184F: return "MONGOLIAN_LETTER_TODO_MA";
        case   0x1850: return "MONGOLIAN_LETTER_TODO_TA";
        case   0x1851: return "MONGOLIAN_LETTER_TODO_DA";
        case   0x1852: return "MONGOLIAN_LETTER_TODO_CHA";
        case   0x1853: return "MONGOLIAN_LETTER_TODO_JA";
        case   0x1854: return "MONGOLIAN_LETTER_TODO_TSA";
        case   0x1855: return "MONGOLIAN_LETTER_TODO_YA";
        case   0x1856: return "MONGOLIAN_LETTER_TODO_WA";
        case   0x1857: return "MONGOLIAN_LETTER_TODO_KA";
        case   0x1858: return "MONGOLIAN_LETTER_TODO_GAA";
        case   0x1859: return "MONGOLIAN_LETTER_TODO_HAA";
        case   0x185A: return "MONGOLIAN_LETTER_TODO_JIA";
        case   0x185B: return "MONGOLIAN_LETTER_TODO_NIA";
        case   0x185C: return "MONGOLIAN_LETTER_TODO_DZA";
        case   0x185D: return "MONGOLIAN_LETTER_SIBE_E";
        case   0x185E: return "MONGOLIAN_LETTER_SIBE_I";
        case   0x185F: return "MONGOLIAN_LETTER_SIBE_IY";
        case   0x1860: return "MONGOLIAN_LETTER_SIBE_UE";
        case   0x1861: return "MONGOLIAN_LETTER_SIBE_U";
        case   0x1862: return "MONGOLIAN_LETTER_SIBE_ANG";
        case   0x1863: return "MONGOLIAN_LETTER_SIBE_KA";
        case   0x1864: return "MONGOLIAN_LETTER_SIBE_GA";
        case   0x1865: return "MONGOLIAN_LETTER_SIBE_HA";
        case   0x1866: return "MONGOLIAN_LETTER_SIBE_PA";
        case   0x1867: return "MONGOLIAN_LETTER_SIBE_SHA";
        case   0x1868: return "MONGOLIAN_LETTER_SIBE_TA";
        case   0x1869: return "MONGOLIAN_LETTER_SIBE_DA";
        case   0x186A: return "MONGOLIAN_LETTER_SIBE_JA";
        case   0x186B: return "MONGOLIAN_LETTER_SIBE_FA";
        case   0x186C: return "MONGOLIAN_LETTER_SIBE_GAA";
        case   0x186D: return "MONGOLIAN_LETTER_SIBE_HAA";
        case   0x186E: return "MONGOLIAN_LETTER_SIBE_TSA";
        case   0x186F: return "MONGOLIAN_LETTER_SIBE_ZA";
        case   0x1870: return "MONGOLIAN_LETTER_SIBE_RAA";
        case   0x1871: return "MONGOLIAN_LETTER_SIBE_CHA";
        case   0x1872: return "MONGOLIAN_LETTER_SIBE_ZHA";
        case   0x1873: return "MONGOLIAN_LETTER_MANCHU_I";
        case   0x1874: return "MONGOLIAN_LETTER_MANCHU_KA";
        case   0x1875: return "MONGOLIAN_LETTER_MANCHU_RA";
        case   0x1876: return "MONGOLIAN_LETTER_MANCHU_FA";
        case   0x1877: return "MONGOLIAN_LETTER_MANCHU_ZHA";
        case   0x1880: return "MONGOLIAN_LETTER_ALI_GALI_ANUSVARA_ONE";
        case   0x1881: return "MONGOLIAN_LETTER_ALI_GALI_VISARGA_ONE";
        case   0x1882: return "MONGOLIAN_LETTER_ALI_GALI_DAMARU";
        case   0x1883: return "MONGOLIAN_LETTER_ALI_GALI_UBADAMA";
        case   0x1884: return "MONGOLIAN_LETTER_ALI_GALI_INVERTED_UBADAMA";
        case   0x1885: return "MONGOLIAN_LETTER_ALI_GALI_BALUDA";
        case   0x1886: return "MONGOLIAN_LETTER_ALI_GALI_THREE_BALUDA";
        case   0x1887: return "MONGOLIAN_LETTER_ALI_GALI_A";
        case   0x1888: return "MONGOLIAN_LETTER_ALI_GALI_I";
        case   0x1889: return "MONGOLIAN_LETTER_ALI_GALI_KA";
        case   0x188A: return "MONGOLIAN_LETTER_ALI_GALI_NGA";
        case   0x188B: return "MONGOLIAN_LETTER_ALI_GALI_CA";
        case   0x188C: return "MONGOLIAN_LETTER_ALI_GALI_TTA";
        case   0x188D: return "MONGOLIAN_LETTER_ALI_GALI_TTHA";
        case   0x188E: return "MONGOLIAN_LETTER_ALI_GALI_DDA";
        case   0x188F: return "MONGOLIAN_LETTER_ALI_GALI_NNA";
        case   0x1890: return "MONGOLIAN_LETTER_ALI_GALI_TA";
        case   0x1891: return "MONGOLIAN_LETTER_ALI_GALI_DA";
        case   0x1892: return "MONGOLIAN_LETTER_ALI_GALI_PA";
        case   0x1893: return "MONGOLIAN_LETTER_ALI_GALI_PHA";
        case   0x1894: return "MONGOLIAN_LETTER_ALI_GALI_SSA";
        case   0x1895: return "MONGOLIAN_LETTER_ALI_GALI_ZHA";
        case   0x1896: return "MONGOLIAN_LETTER_ALI_GALI_ZA";
        case   0x1897: return "MONGOLIAN_LETTER_ALI_GALI_AH";
        case   0x1898: return "MONGOLIAN_LETTER_TODO_ALI_GALI_TA";
        case   0x1899: return "MONGOLIAN_LETTER_TODO_ALI_GALI_ZHA";
        case   0x189A: return "MONGOLIAN_LETTER_MANCHU_ALI_GALI_GHA";
        case   0x189B: return "MONGOLIAN_LETTER_MANCHU_ALI_GALI_NGA";
        case   0x189C: return "MONGOLIAN_LETTER_MANCHU_ALI_GALI_CA";
        case   0x189D: return "MONGOLIAN_LETTER_MANCHU_ALI_GALI_JHA";
        case   0x189E: return "MONGOLIAN_LETTER_MANCHU_ALI_GALI_TTA";
        case   0x189F: return "MONGOLIAN_LETTER_MANCHU_ALI_GALI_DDHA";
        case   0x18A0: return "MONGOLIAN_LETTER_MANCHU_ALI_GALI_TA";
        case   0x18A1: return "MONGOLIAN_LETTER_MANCHU_ALI_GALI_DHA";
        case   0x18A2: return "MONGOLIAN_LETTER_MANCHU_ALI_GALI_SSA";
        case   0x18A3: return "MONGOLIAN_LETTER_MANCHU_ALI_GALI_CYA";
        case   0x18A4: return "MONGOLIAN_LETTER_MANCHU_ALI_GALI_ZHA";
        case   0x18A5: return "MONGOLIAN_LETTER_MANCHU_ALI_GALI_ZA";
        case   0x18A6: return "MONGOLIAN_LETTER_ALI_GALI_HALF_U";
        case   0x18A7: return "MONGOLIAN_LETTER_ALI_GALI_HALF_YA";
        case   0x18A8: return "MONGOLIAN_LETTER_MANCHU_ALI_GALI_BHA";
        case   0x18A9: return "MONGOLIAN_LETTER_ALI_GALI_DAGALGA";
        case   0x18AA: return "MONGOLIAN_LETTER_MANCHU_ALI_GALI_LHA";
        case   0x18B0: return "CANADIAN_SYLLABICS_OY";
        case   0x18B1: return "CANADIAN_SYLLABICS_AY";
        case   0x18B2: return "CANADIAN_SYLLABICS_AAY";
        case   0x18B3: return "CANADIAN_SYLLABICS_WAY";
        case   0x18B4: return "CANADIAN_SYLLABICS_POY";
        case   0x18B5: return "CANADIAN_SYLLABICS_PAY";
        case   0x18B6: return "CANADIAN_SYLLABICS_PWOY";
        case   0x18B7: return "CANADIAN_SYLLABICS_TAY";
        case   0x18B8: return "CANADIAN_SYLLABICS_KAY";
        case   0x18B9: return "CANADIAN_SYLLABICS_KWAY";
        case   0x18BA: return "CANADIAN_SYLLABICS_MAY";
        case   0x18BB: return "CANADIAN_SYLLABICS_NOY";
        case   0x18BC: return "CANADIAN_SYLLABICS_NAY";
        case   0x18BD: return "CANADIAN_SYLLABICS_LAY";
        case   0x18BE: return "CANADIAN_SYLLABICS_SOY";
        case   0x18BF: return "CANADIAN_SYLLABICS_SAY";
        case   0x18C0: return "CANADIAN_SYLLABICS_SHOY";
        case   0x18C1: return "CANADIAN_SYLLABICS_SHAY";
        case   0x18C2: return "CANADIAN_SYLLABICS_SHWOY";
        case   0x18C3: return "CANADIAN_SYLLABICS_YOY";
        case   0x18C4: return "CANADIAN_SYLLABICS_YAY";
        case   0x18C5: return "CANADIAN_SYLLABICS_RAY";
        case   0x18C6: return "CANADIAN_SYLLABICS_NWI";
        case   0x18C7: return "CANADIAN_SYLLABICS_OJIBWAY_NWI";
        case   0x18C8: return "CANADIAN_SYLLABICS_NWII";
        case   0x18C9: return "CANADIAN_SYLLABICS_OJIBWAY_NWII";
        case   0x18CA: return "CANADIAN_SYLLABICS_NWO";
        case   0x18CB: return "CANADIAN_SYLLABICS_OJIBWAY_NWO";
        case   0x18CC: return "CANADIAN_SYLLABICS_NWOO";
        case   0x18CD: return "CANADIAN_SYLLABICS_OJIBWAY_NWOO";
        case   0x18CE: return "CANADIAN_SYLLABICS_RWEE";
        case   0x18CF: return "CANADIAN_SYLLABICS_RWI";
        case   0x18D0: return "CANADIAN_SYLLABICS_RWII";
        case   0x18D1: return "CANADIAN_SYLLABICS_RWO";
        case   0x18D2: return "CANADIAN_SYLLABICS_RWOO";
        case   0x18D3: return "CANADIAN_SYLLABICS_RWA";
        case   0x18D4: return "CANADIAN_SYLLABICS_OJIBWAY_P";
        case   0x18D5: return "CANADIAN_SYLLABICS_OJIBWAY_T";
        case   0x18D6: return "CANADIAN_SYLLABICS_OJIBWAY_K";
        case   0x18D7: return "CANADIAN_SYLLABICS_OJIBWAY_C";
        case   0x18D8: return "CANADIAN_SYLLABICS_OJIBWAY_M";
        case   0x18D9: return "CANADIAN_SYLLABICS_OJIBWAY_N";
        case   0x18DA: return "CANADIAN_SYLLABICS_OJIBWAY_S";
        case   0x18DB: return "CANADIAN_SYLLABICS_OJIBWAY_SH";
        case   0x18DC: return "CANADIAN_SYLLABICS_EASTERN_W";
        case   0x18DD: return "CANADIAN_SYLLABICS_WESTERN_W";
        case   0x18DE: return "CANADIAN_SYLLABICS_FINAL_SMALL_RING";
        case   0x18DF: return "CANADIAN_SYLLABICS_FINAL_RAISED_DOT";
        case   0x18E0: return "CANADIAN_SYLLABICS_R_CREE_RWE";
        case   0x18E1: return "CANADIAN_SYLLABICS_WEST_CREE_LOO";
        case   0x18E2: return "CANADIAN_SYLLABICS_WEST_CREE_LAA";
        case   0x18E3: return "CANADIAN_SYLLABICS_THWE";
        case   0x18E4: return "CANADIAN_SYLLABICS_THWA";
        case   0x18E5: return "CANADIAN_SYLLABICS_TTHWE";
        case   0x18E6: return "CANADIAN_SYLLABICS_TTHOO";
        case   0x18E7: return "CANADIAN_SYLLABICS_TTHAA";
        case   0x18E8: return "CANADIAN_SYLLABICS_TLHWE";
        case   0x18E9: return "CANADIAN_SYLLABICS_TLHOO";
        case   0x18EA: return "CANADIAN_SYLLABICS_SAYISI_SHWE";
        case   0x18EB: return "CANADIAN_SYLLABICS_SAYISI_SHOO";
        case   0x18EC: return "CANADIAN_SYLLABICS_SAYISI_HOO";
        case   0x18ED: return "CANADIAN_SYLLABICS_CARRIER_GWU";
        case   0x18EE: return "CANADIAN_SYLLABICS_CARRIER_DENE_GEE";
        case   0x18EF: return "CANADIAN_SYLLABICS_CARRIER_GAA";
        case   0x18F0: return "CANADIAN_SYLLABICS_CARRIER_GWA";
        case   0x18F1: return "CANADIAN_SYLLABICS_SAYISI_JUU";
        case   0x18F2: return "CANADIAN_SYLLABICS_CARRIER_JWA";
        case   0x18F3: return "CANADIAN_SYLLABICS_BEAVER_DENE_L";
        case   0x18F4: return "CANADIAN_SYLLABICS_BEAVER_DENE_R";
        case   0x18F5: return "CANADIAN_SYLLABICS_CARRIER_DENTAL_S";
        case   0x1900: return "LIMBU_VOWEL_CARRIER_LETTER";
        case   0x1901: return "LIMBU_LETTER_KA";
        case   0x1902: return "LIMBU_LETTER_KHA";
        case   0x1903: return "LIMBU_LETTER_GA";
        case   0x1904: return "LIMBU_LETTER_GHA";
        case   0x1905: return "LIMBU_LETTER_NGA";
        case   0x1906: return "LIMBU_LETTER_CA";
        case   0x1907: return "LIMBU_LETTER_CHA";
        case   0x1908: return "LIMBU_LETTER_JA";
        case   0x1909: return "LIMBU_LETTER_JHA";
        case   0x190A: return "LIMBU_LETTER_YAN";
        case   0x190B: return "LIMBU_LETTER_TA";
        case   0x190C: return "LIMBU_LETTER_THA";
        case   0x190D: return "LIMBU_LETTER_DA";
        case   0x190E: return "LIMBU_LETTER_DHA";
        case   0x190F: return "LIMBU_LETTER_NA";
        case   0x1910: return "LIMBU_LETTER_PA";
        case   0x1911: return "LIMBU_LETTER_PHA";
        case   0x1912: return "LIMBU_LETTER_BA";
        case   0x1913: return "LIMBU_LETTER_BHA";
        case   0x1914: return "LIMBU_LETTER_MA";
        case   0x1915: return "LIMBU_LETTER_YA";
        case   0x1916: return "LIMBU_LETTER_RA";
        case   0x1917: return "LIMBU_LETTER_LA";
        case   0x1918: return "LIMBU_LETTER_WA";
        case   0x1919: return "LIMBU_LETTER_SHA";
        case   0x191A: return "LIMBU_LETTER_SSA";
        case   0x191B: return "LIMBU_LETTER_SA";
        case   0x191C: return "LIMBU_LETTER_HA";
        case   0x191D: return "LIMBU_LETTER_GYAN";
        case   0x191E: return "LIMBU_LETTER_TRA";
        case   0x1920: return "LIMBU_VOWEL_SIGN_A";
        case   0x1921: return "LIMBU_VOWEL_SIGN_I";
        case   0x1922: return "LIMBU_VOWEL_SIGN_U";
        case   0x1923: return "LIMBU_VOWEL_SIGN_EE";
        case   0x1924: return "LIMBU_VOWEL_SIGN_AI";
        case   0x1925: return "LIMBU_VOWEL_SIGN_OO";
        case   0x1926: return "LIMBU_VOWEL_SIGN_AU";
        case   0x1927: return "LIMBU_VOWEL_SIGN_E";
        case   0x1928: return "LIMBU_VOWEL_SIGN_O";
        case   0x1929: return "LIMBU_SUBJOINED_LETTER_YA";
        case   0x192A: return "LIMBU_SUBJOINED_LETTER_RA";
        case   0x192B: return "LIMBU_SUBJOINED_LETTER_WA";
        case   0x1930: return "LIMBU_SMALL_LETTER_KA";
        case   0x1931: return "LIMBU_SMALL_LETTER_NGA";
        case   0x1932: return "LIMBU_SMALL_LETTER_ANUSVARA";
        case   0x1933: return "LIMBU_SMALL_LETTER_TA";
        case   0x1934: return "LIMBU_SMALL_LETTER_NA";
        case   0x1935: return "LIMBU_SMALL_LETTER_PA";
        case   0x1936: return "LIMBU_SMALL_LETTER_MA";
        case   0x1937: return "LIMBU_SMALL_LETTER_RA";
        case   0x1938: return "LIMBU_SMALL_LETTER_LA";
        case   0x1939: return "LIMBU_SIGN_MUKPHRENG";
        case   0x193A: return "LIMBU_SIGN_KEMPHRENG";
        case   0x193B: return "LIMBU_SIGN_SA_I";
        case   0x1940: return "LIMBU_SIGN_LOO";
        case   0x1944: return "LIMBU_EXCLAMATION_MARK";
        case   0x1945: return "LIMBU_QUESTION_MARK";
        case   0x1946: return "LIMBU_DIGIT_ZERO";
        case   0x1947: return "LIMBU_DIGIT_ONE";
        case   0x1948: return "LIMBU_DIGIT_TWO";
        case   0x1949: return "LIMBU_DIGIT_THREE";
        case   0x194A: return "LIMBU_DIGIT_FOUR";
        case   0x194B: return "LIMBU_DIGIT_FIVE";
        case   0x194C: return "LIMBU_DIGIT_SIX";
        case   0x194D: return "LIMBU_DIGIT_SEVEN";
        case   0x194E: return "LIMBU_DIGIT_EIGHT";
        case   0x194F: return "LIMBU_DIGIT_NINE";
        case   0x1950: return "TAI_LE_LETTER_KA";
        case   0x1951: return "TAI_LE_LETTER_XA";
        case   0x1952: return "TAI_LE_LETTER_NGA";
        case   0x1953: return "TAI_LE_LETTER_TSA";
        case   0x1954: return "TAI_LE_LETTER_SA";
        case   0x1955: return "TAI_LE_LETTER_YA";
        case   0x1956: return "TAI_LE_LETTER_TA";
        case   0x1957: return "TAI_LE_LETTER_THA";
        case   0x1958: return "TAI_LE_LETTER_LA";
        case   0x1959: return "TAI_LE_LETTER_PA";
        case   0x195A: return "TAI_LE_LETTER_PHA";
        case   0x195B: return "TAI_LE_LETTER_MA";
        case   0x195C: return "TAI_LE_LETTER_FA";
        case   0x195D: return "TAI_LE_LETTER_VA";
        case   0x195E: return "TAI_LE_LETTER_HA";
        case   0x195F: return "TAI_LE_LETTER_QA";
        case   0x1960: return "TAI_LE_LETTER_KHA";
        case   0x1961: return "TAI_LE_LETTER_TSHA";
        case   0x1962: return "TAI_LE_LETTER_NA";
        case   0x1963: return "TAI_LE_LETTER_A";
        case   0x1964: return "TAI_LE_LETTER_I";
        case   0x1965: return "TAI_LE_LETTER_EE";
        case   0x1966: return "TAI_LE_LETTER_EH";
        case   0x1967: return "TAI_LE_LETTER_U";
        case   0x1968: return "TAI_LE_LETTER_OO";
        case   0x1969: return "TAI_LE_LETTER_O";
        case   0x196A: return "TAI_LE_LETTER_UE";
        case   0x196B: return "TAI_LE_LETTER_E";
        case   0x196C: return "TAI_LE_LETTER_AUE";
        case   0x196D: return "TAI_LE_LETTER_AI";
        case   0x1970: return "TAI_LE_LETTER_TONE_2";
        case   0x1971: return "TAI_LE_LETTER_TONE_3";
        case   0x1972: return "TAI_LE_LETTER_TONE_4";
        case   0x1973: return "TAI_LE_LETTER_TONE_5";
        case   0x1974: return "TAI_LE_LETTER_TONE_6";
        case   0x1980: return "NEW_TAI_LUE_LETTER_HIGH_QA";
        case   0x1981: return "NEW_TAI_LUE_LETTER_LOW_QA";
        case   0x1982: return "NEW_TAI_LUE_LETTER_HIGH_KA";
        case   0x1983: return "NEW_TAI_LUE_LETTER_HIGH_XA";
        case   0x1984: return "NEW_TAI_LUE_LETTER_HIGH_NGA";
        case   0x1985: return "NEW_TAI_LUE_LETTER_LOW_KA";
        case   0x1986: return "NEW_TAI_LUE_LETTER_LOW_XA";
        case   0x1987: return "NEW_TAI_LUE_LETTER_LOW_NGA";
        case   0x1988: return "NEW_TAI_LUE_LETTER_HIGH_TSA";
        case   0x1989: return "NEW_TAI_LUE_LETTER_HIGH_SA";
        case   0x198A: return "NEW_TAI_LUE_LETTER_HIGH_YA";
        case   0x198B: return "NEW_TAI_LUE_LETTER_LOW_TSA";
        case   0x198C: return "NEW_TAI_LUE_LETTER_LOW_SA";
        case   0x198D: return "NEW_TAI_LUE_LETTER_LOW_YA";
        case   0x198E: return "NEW_TAI_LUE_LETTER_HIGH_TA";
        case   0x198F: return "NEW_TAI_LUE_LETTER_HIGH_THA";
        case   0x1990: return "NEW_TAI_LUE_LETTER_HIGH_NA";
        case   0x1991: return "NEW_TAI_LUE_LETTER_LOW_TA";
        case   0x1992: return "NEW_TAI_LUE_LETTER_LOW_THA";
        case   0x1993: return "NEW_TAI_LUE_LETTER_LOW_NA";
        case   0x1994: return "NEW_TAI_LUE_LETTER_HIGH_PA";
        case   0x1995: return "NEW_TAI_LUE_LETTER_HIGH_PHA";
        case   0x1996: return "NEW_TAI_LUE_LETTER_HIGH_MA";
        case   0x1997: return "NEW_TAI_LUE_LETTER_LOW_PA";
        case   0x1998: return "NEW_TAI_LUE_LETTER_LOW_PHA";
        case   0x1999: return "NEW_TAI_LUE_LETTER_LOW_MA";
        case   0x199A: return "NEW_TAI_LUE_LETTER_HIGH_FA";
        case   0x199B: return "NEW_TAI_LUE_LETTER_HIGH_VA";
        case   0x199C: return "NEW_TAI_LUE_LETTER_HIGH_LA";
        case   0x199D: return "NEW_TAI_LUE_LETTER_LOW_FA";
        case   0x199E: return "NEW_TAI_LUE_LETTER_LOW_VA";
        case   0x199F: return "NEW_TAI_LUE_LETTER_LOW_LA";
        case   0x19A0: return "NEW_TAI_LUE_LETTER_HIGH_HA";
        case   0x19A1: return "NEW_TAI_LUE_LETTER_HIGH_DA";
        case   0x19A2: return "NEW_TAI_LUE_LETTER_HIGH_BA";
        case   0x19A3: return "NEW_TAI_LUE_LETTER_LOW_HA";
        case   0x19A4: return "NEW_TAI_LUE_LETTER_LOW_DA";
        case   0x19A5: return "NEW_TAI_LUE_LETTER_LOW_BA";
        case   0x19A6: return "NEW_TAI_LUE_LETTER_HIGH_KVA";
        case   0x19A7: return "NEW_TAI_LUE_LETTER_HIGH_XVA";
        case   0x19A8: return "NEW_TAI_LUE_LETTER_LOW_KVA";
        case   0x19A9: return "NEW_TAI_LUE_LETTER_LOW_XVA";
        case   0x19AA: return "NEW_TAI_LUE_LETTER_HIGH_SUA";
        case   0x19AB: return "NEW_TAI_LUE_LETTER_LOW_SUA";
        case   0x19B0: return "NEW_TAI_LUE_VOWEL_SIGN_VOWEL_SHORTENER";
        case   0x19B1: return "NEW_TAI_LUE_VOWEL_SIGN_AA";
        case   0x19B2: return "NEW_TAI_LUE_VOWEL_SIGN_II";
        case   0x19B3: return "NEW_TAI_LUE_VOWEL_SIGN_U";
        case   0x19B4: return "NEW_TAI_LUE_VOWEL_SIGN_UU";
        case   0x19B5: return "NEW_TAI_LUE_VOWEL_SIGN_E";
        case   0x19B6: return "NEW_TAI_LUE_VOWEL_SIGN_AE";
        case   0x19B7: return "NEW_TAI_LUE_VOWEL_SIGN_O";
        case   0x19B8: return "NEW_TAI_LUE_VOWEL_SIGN_OA";
        case   0x19B9: return "NEW_TAI_LUE_VOWEL_SIGN_UE";
        case   0x19BA: return "NEW_TAI_LUE_VOWEL_SIGN_AY";
        case   0x19BB: return "NEW_TAI_LUE_VOWEL_SIGN_AAY";
        case   0x19BC: return "NEW_TAI_LUE_VOWEL_SIGN_UY";
        case   0x19BD: return "NEW_TAI_LUE_VOWEL_SIGN_OY";
        case   0x19BE: return "NEW_TAI_LUE_VOWEL_SIGN_OAY";
        case   0x19BF: return "NEW_TAI_LUE_VOWEL_SIGN_UEY";
        case   0x19C0: return "NEW_TAI_LUE_VOWEL_SIGN_IY";
        case   0x19C1: return "NEW_TAI_LUE_LETTER_FINAL_V";
        case   0x19C2: return "NEW_TAI_LUE_LETTER_FINAL_NG";
        case   0x19C3: return "NEW_TAI_LUE_LETTER_FINAL_N";
        case   0x19C4: return "NEW_TAI_LUE_LETTER_FINAL_M";
        case   0x19C5: return "NEW_TAI_LUE_LETTER_FINAL_K";
        case   0x19C6: return "NEW_TAI_LUE_LETTER_FINAL_D";
        case   0x19C7: return "NEW_TAI_LUE_LETTER_FINAL_B";
        case   0x19C8: return "NEW_TAI_LUE_TONE_MARK_1";
        case   0x19C9: return "NEW_TAI_LUE_TONE_MARK_2";
        case   0x19D0: return "NEW_TAI_LUE_DIGIT_ZERO";
        case   0x19D1: return "NEW_TAI_LUE_DIGIT_ONE";
        case   0x19D2: return "NEW_TAI_LUE_DIGIT_TWO";
        case   0x19D3: return "NEW_TAI_LUE_DIGIT_THREE";
        case   0x19D4: return "NEW_TAI_LUE_DIGIT_FOUR";
        case   0x19D5: return "NEW_TAI_LUE_DIGIT_FIVE";
        case   0x19D6: return "NEW_TAI_LUE_DIGIT_SIX";
        case   0x19D7: return "NEW_TAI_LUE_DIGIT_SEVEN";
        case   0x19D8: return "NEW_TAI_LUE_DIGIT_EIGHT";
        case   0x19D9: return "NEW_TAI_LUE_DIGIT_NINE";
        case   0x19DA: return "NEW_TAI_LUE_THAM_DIGIT_ONE";
        case   0x19DE: return "NEW_TAI_LUE_SIGN_LAE";
        case   0x19DF: return "NEW_TAI_LUE_SIGN_LAEV";
        case   0x19E0: return "KHMER_SYMBOL_PATHAMASAT";
        case   0x19E1: return "KHMER_SYMBOL_MUOY_KOET";
        case   0x19E2: return "KHMER_SYMBOL_PII_KOET";
        case   0x19E3: return "KHMER_SYMBOL_BEI_KOET";
        case   0x19E4: return "KHMER_SYMBOL_BUON_KOET";
        case   0x19E5: return "KHMER_SYMBOL_PRAM_KOET";
        case   0x19E6: return "KHMER_SYMBOL_PRAM_MUOY_KOET";
        case   0x19E7: return "KHMER_SYMBOL_PRAM_PII_KOET";
        case   0x19E8: return "KHMER_SYMBOL_PRAM_BEI_KOET";
        case   0x19E9: return "KHMER_SYMBOL_PRAM_BUON_KOET";
        case   0x19EA: return "KHMER_SYMBOL_DAP_KOET";
        case   0x19EB: return "KHMER_SYMBOL_DAP_MUOY_KOET";
        case   0x19EC: return "KHMER_SYMBOL_DAP_PII_KOET";
        case   0x19ED: return "KHMER_SYMBOL_DAP_BEI_KOET";
        case   0x19EE: return "KHMER_SYMBOL_DAP_BUON_KOET";
        case   0x19EF: return "KHMER_SYMBOL_DAP_PRAM_KOET";
        case   0x19F0: return "KHMER_SYMBOL_TUTEYASAT";
        case   0x19F1: return "KHMER_SYMBOL_MUOY_ROC";
        case   0x19F2: return "KHMER_SYMBOL_PII_ROC";
        case   0x19F3: return "KHMER_SYMBOL_BEI_ROC";
        case   0x19F4: return "KHMER_SYMBOL_BUON_ROC";
        case   0x19F5: return "KHMER_SYMBOL_PRAM_ROC";
        case   0x19F6: return "KHMER_SYMBOL_PRAM_MUOY_ROC";
        case   0x19F7: return "KHMER_SYMBOL_PRAM_PII_ROC";
        case   0x19F8: return "KHMER_SYMBOL_PRAM_BEI_ROC";
        case   0x19F9: return "KHMER_SYMBOL_PRAM_BUON_ROC";
        case   0x19FA: return "KHMER_SYMBOL_DAP_ROC";
        case   0x19FB: return "KHMER_SYMBOL_DAP_MUOY_ROC";
        case   0x19FC: return "KHMER_SYMBOL_DAP_PII_ROC";
        case   0x19FD: return "KHMER_SYMBOL_DAP_BEI_ROC";
        case   0x19FE: return "KHMER_SYMBOL_DAP_BUON_ROC";
        case   0x19FF: return "KHMER_SYMBOL_DAP_PRAM_ROC";
        case   0x1A00: return "BUGINESE_LETTER_KA";
        case   0x1A01: return "BUGINESE_LETTER_GA";
        case   0x1A02: return "BUGINESE_LETTER_NGA";
        case   0x1A03: return "BUGINESE_LETTER_NGKA";
        case   0x1A04: return "BUGINESE_LETTER_PA";
        case   0x1A05: return "BUGINESE_LETTER_BA";
        case   0x1A06: return "BUGINESE_LETTER_MA";
        case   0x1A07: return "BUGINESE_LETTER_MPA";
        case   0x1A08: return "BUGINESE_LETTER_TA";
        case   0x1A09: return "BUGINESE_LETTER_DA";
        case   0x1A0A: return "BUGINESE_LETTER_NA";
        case   0x1A0B: return "BUGINESE_LETTER_NRA";
        case   0x1A0C: return "BUGINESE_LETTER_CA";
        case   0x1A0D: return "BUGINESE_LETTER_JA";
        case   0x1A0E: return "BUGINESE_LETTER_NYA";
        case   0x1A0F: return "BUGINESE_LETTER_NYCA";
        case   0x1A10: return "BUGINESE_LETTER_YA";
        case   0x1A11: return "BUGINESE_LETTER_RA";
        case   0x1A12: return "BUGINESE_LETTER_LA";
        case   0x1A13: return "BUGINESE_LETTER_VA";
        case   0x1A14: return "BUGINESE_LETTER_SA";
        case   0x1A15: return "BUGINESE_LETTER_A";
        case   0x1A16: return "BUGINESE_LETTER_HA";
        case   0x1A17: return "BUGINESE_VOWEL_SIGN_I";
        case   0x1A18: return "BUGINESE_VOWEL_SIGN_U";
        case   0x1A19: return "BUGINESE_VOWEL_SIGN_E";
        case   0x1A1A: return "BUGINESE_VOWEL_SIGN_O";
        case   0x1A1B: return "BUGINESE_VOWEL_SIGN_AE";
        case   0x1A1E: return "BUGINESE_PALLAWA";
        case   0x1A1F: return "BUGINESE_END_OF_SECTION";
        case   0x1A20: return "TAI_THAM_LETTER_HIGH_KA";
        case   0x1A21: return "TAI_THAM_LETTER_HIGH_KHA";
        case   0x1A22: return "TAI_THAM_LETTER_HIGH_KXA";
        case   0x1A23: return "TAI_THAM_LETTER_LOW_KA";
        case   0x1A24: return "TAI_THAM_LETTER_LOW_KXA";
        case   0x1A25: return "TAI_THAM_LETTER_LOW_KHA";
        case   0x1A26: return "TAI_THAM_LETTER_NGA";
        case   0x1A27: return "TAI_THAM_LETTER_HIGH_CA";
        case   0x1A28: return "TAI_THAM_LETTER_HIGH_CHA";
        case   0x1A29: return "TAI_THAM_LETTER_LOW_CA";
        case   0x1A2A: return "TAI_THAM_LETTER_LOW_SA";
        case   0x1A2B: return "TAI_THAM_LETTER_LOW_CHA";
        case   0x1A2C: return "TAI_THAM_LETTER_NYA";
        case   0x1A2D: return "TAI_THAM_LETTER_RATA";
        case   0x1A2E: return "TAI_THAM_LETTER_HIGH_RATHA";
        case   0x1A2F: return "TAI_THAM_LETTER_DA";
        case   0x1A30: return "TAI_THAM_LETTER_LOW_RATHA";
        case   0x1A31: return "TAI_THAM_LETTER_RANA";
        case   0x1A32: return "TAI_THAM_LETTER_HIGH_TA";
        case   0x1A33: return "TAI_THAM_LETTER_HIGH_THA";
        case   0x1A34: return "TAI_THAM_LETTER_LOW_TA";
        case   0x1A35: return "TAI_THAM_LETTER_LOW_THA";
        case   0x1A36: return "TAI_THAM_LETTER_NA";
        case   0x1A37: return "TAI_THAM_LETTER_BA";
        case   0x1A38: return "TAI_THAM_LETTER_HIGH_PA";
        case   0x1A39: return "TAI_THAM_LETTER_HIGH_PHA";
        case   0x1A3A: return "TAI_THAM_LETTER_HIGH_FA";
        case   0x1A3B: return "TAI_THAM_LETTER_LOW_PA";
        case   0x1A3C: return "TAI_THAM_LETTER_LOW_FA";
        case   0x1A3D: return "TAI_THAM_LETTER_LOW_PHA";
        case   0x1A3E: return "TAI_THAM_LETTER_MA";
        case   0x1A3F: return "TAI_THAM_LETTER_LOW_YA";
        case   0x1A40: return "TAI_THAM_LETTER_HIGH_YA";
        case   0x1A41: return "TAI_THAM_LETTER_RA";
        case   0x1A42: return "TAI_THAM_LETTER_RUE";
        case   0x1A43: return "TAI_THAM_LETTER_LA";
        case   0x1A44: return "TAI_THAM_LETTER_LUE";
        case   0x1A45: return "TAI_THAM_LETTER_WA";
        case   0x1A46: return "TAI_THAM_LETTER_HIGH_SHA";
        case   0x1A47: return "TAI_THAM_LETTER_HIGH_SSA";
        case   0x1A48: return "TAI_THAM_LETTER_HIGH_SA";
        case   0x1A49: return "TAI_THAM_LETTER_HIGH_HA";
        case   0x1A4A: return "TAI_THAM_LETTER_LLA";
        case   0x1A4B: return "TAI_THAM_LETTER_A";
        case   0x1A4C: return "TAI_THAM_LETTER_LOW_HA";
        case   0x1A4D: return "TAI_THAM_LETTER_I";
        case   0x1A4E: return "TAI_THAM_LETTER_II";
        case   0x1A4F: return "TAI_THAM_LETTER_U";
        case   0x1A50: return "TAI_THAM_LETTER_UU";
        case   0x1A51: return "TAI_THAM_LETTER_EE";
        case   0x1A52: return "TAI_THAM_LETTER_OO";
        case   0x1A53: return "TAI_THAM_LETTER_LAE";
        case   0x1A54: return "TAI_THAM_LETTER_GREAT_SA";
        case   0x1A55: return "TAI_THAM_CONSONANT_SIGN_MEDIAL_RA";
        case   0x1A56: return "TAI_THAM_CONSONANT_SIGN_MEDIAL_LA";
        case   0x1A57: return "TAI_THAM_CONSONANT_SIGN_LA_TANG_LAI";
        case   0x1A58: return "TAI_THAM_SIGN_MAI_KANG_LAI";
        case   0x1A59: return "TAI_THAM_CONSONANT_SIGN_FINAL_NGA";
        case   0x1A5A: return "TAI_THAM_CONSONANT_SIGN_LOW_PA";
        case   0x1A5B: return "TAI_THAM_CONSONANT_SIGN_HIGH_RATHA_OR_LOW_PA";
        case   0x1A5C: return "TAI_THAM_CONSONANT_SIGN_MA";
        case   0x1A5D: return "TAI_THAM_CONSONANT_SIGN_BA";
        case   0x1A5E: return "TAI_THAM_CONSONANT_SIGN_SA";
        case   0x1A60: return "TAI_THAM_SIGN_SAKOT";
        case   0x1A61: return "TAI_THAM_VOWEL_SIGN_A";
        case   0x1A62: return "TAI_THAM_VOWEL_SIGN_MAI_SAT";
        case   0x1A63: return "TAI_THAM_VOWEL_SIGN_AA";
        case   0x1A64: return "TAI_THAM_VOWEL_SIGN_TALL_AA";
        case   0x1A65: return "TAI_THAM_VOWEL_SIGN_I";
        case   0x1A66: return "TAI_THAM_VOWEL_SIGN_II";
        case   0x1A67: return "TAI_THAM_VOWEL_SIGN_UE";
        case   0x1A68: return "TAI_THAM_VOWEL_SIGN_UUE";
        case   0x1A69: return "TAI_THAM_VOWEL_SIGN_U";
        case   0x1A6A: return "TAI_THAM_VOWEL_SIGN_UU";
        case   0x1A6B: return "TAI_THAM_VOWEL_SIGN_O";
        case   0x1A6C: return "TAI_THAM_VOWEL_SIGN_OA_BELOW";
        case   0x1A6D: return "TAI_THAM_VOWEL_SIGN_OY";
        case   0x1A6E: return "TAI_THAM_VOWEL_SIGN_E";
        case   0x1A6F: return "TAI_THAM_VOWEL_SIGN_AE";
        case   0x1A70: return "TAI_THAM_VOWEL_SIGN_OO";
        case   0x1A71: return "TAI_THAM_VOWEL_SIGN_AI";
        case   0x1A72: return "TAI_THAM_VOWEL_SIGN_THAM_AI";
        case   0x1A73: return "TAI_THAM_VOWEL_SIGN_OA_ABOVE";
        case   0x1A74: return "TAI_THAM_SIGN_MAI_KANG";
        case   0x1A75: return "TAI_THAM_SIGN_TONE_1";
        case   0x1A76: return "TAI_THAM_SIGN_TONE_2";
        case   0x1A77: return "TAI_THAM_SIGN_KHUEN_TONE_3";
        case   0x1A78: return "TAI_THAM_SIGN_KHUEN_TONE_4";
        case   0x1A79: return "TAI_THAM_SIGN_KHUEN_TONE_5";
        case   0x1A7A: return "TAI_THAM_SIGN_RA_HAAM";
        case   0x1A7B: return "TAI_THAM_SIGN_MAI_SAM";
        case   0x1A7C: return "TAI_THAM_SIGN_KHUEN_LUE_KARAN";
        case   0x1A7F: return "TAI_THAM_COMBINING_CRYPTOGRAMMIC_DOT";
        case   0x1A80: return "TAI_THAM_HORA_DIGIT_ZERO";
        case   0x1A81: return "TAI_THAM_HORA_DIGIT_ONE";
        case   0x1A82: return "TAI_THAM_HORA_DIGIT_TWO";
        case   0x1A83: return "TAI_THAM_HORA_DIGIT_THREE";
        case   0x1A84: return "TAI_THAM_HORA_DIGIT_FOUR";
        case   0x1A85: return "TAI_THAM_HORA_DIGIT_FIVE";
        case   0x1A86: return "TAI_THAM_HORA_DIGIT_SIX";
        case   0x1A87: return "TAI_THAM_HORA_DIGIT_SEVEN";
        case   0x1A88: return "TAI_THAM_HORA_DIGIT_EIGHT";
        case   0x1A89: return "TAI_THAM_HORA_DIGIT_NINE";
        case   0x1A90: return "TAI_THAM_THAM_DIGIT_ZERO";
        case   0x1A91: return "TAI_THAM_THAM_DIGIT_ONE";
        case   0x1A92: return "TAI_THAM_THAM_DIGIT_TWO";
        case   0x1A93: return "TAI_THAM_THAM_DIGIT_THREE";
        case   0x1A94: return "TAI_THAM_THAM_DIGIT_FOUR";
        case   0x1A95: return "TAI_THAM_THAM_DIGIT_FIVE";
        case   0x1A96: return "TAI_THAM_THAM_DIGIT_SIX";
        case   0x1A97: return "TAI_THAM_THAM_DIGIT_SEVEN";
        case   0x1A98: return "TAI_THAM_THAM_DIGIT_EIGHT";
        case   0x1A99: return "TAI_THAM_THAM_DIGIT_NINE";
        case   0x1AA0: return "TAI_THAM_SIGN_WIANG";
        case   0x1AA1: return "TAI_THAM_SIGN_WIANGWAAK";
        case   0x1AA2: return "TAI_THAM_SIGN_SAWAN";
        case   0x1AA3: return "TAI_THAM_SIGN_KEOW";
        case   0x1AA4: return "TAI_THAM_SIGN_HOY";
        case   0x1AA5: return "TAI_THAM_SIGN_DOKMAI";
        case   0x1AA6: return "TAI_THAM_SIGN_REVERSED_ROTATED_RANA";
        case   0x1AA7: return "TAI_THAM_SIGN_MAI_YAMOK";
        case   0x1AA8: return "TAI_THAM_SIGN_KAAN";
        case   0x1AA9: return "TAI_THAM_SIGN_KAANKUU";
        case   0x1AAA: return "TAI_THAM_SIGN_SATKAAN";
        case   0x1AAB: return "TAI_THAM_SIGN_SATKAANKUU";
        case   0x1AAC: return "TAI_THAM_SIGN_HANG";
        case   0x1AAD: return "TAI_THAM_SIGN_CAANG";
        case   0x1AB0: return "COMBINING_DOUBLED_CIRCUMFLEX_ACCENT";
        case   0x1AB1: return "COMBINING_DIAERESIS_RING";
        case   0x1AB2: return "COMBINING_INFINITY";
        case   0x1AB3: return "COMBINING_DOWNWARDS_ARROW";
        case   0x1AB4: return "COMBINING_TRIPLE_DOT";
        case   0x1AB5: return "COMBINING_X_X_BELOW";
        case   0x1AB6: return "COMBINING_WIGGLY_LINE_BELOW";
        case   0x1AB7: return "COMBINING_OPEN_MARK_BELOW";
        case   0x1AB8: return "COMBINING_DOUBLE_OPEN_MARK_BELOW";
        case   0x1AB9: return "COMBINING_LIGHT_CENTRALIZATION_STROKE_BELOW";
        case   0x1ABA: return "COMBINING_STRONG_CENTRALIZATION_STROKE_BELOW";
        case   0x1ABB: return "COMBINING_PARENTHESES_ABOVE";
        case   0x1ABC: return "COMBINING_DOUBLE_PARENTHESES_ABOVE";
        case   0x1ABD: return "COMBINING_PARENTHESES_BELOW";
        case   0x1ABE: return "COMBINING_PARENTHESES_OVERLAY";
        case   0x1B00: return "BALINESE_SIGN_ULU_RICEM";
        case   0x1B01: return "BALINESE_SIGN_ULU_CANDRA";
        case   0x1B02: return "BALINESE_SIGN_CECEK";
        case   0x1B03: return "BALINESE_SIGN_SURANG";
        case   0x1B04: return "BALINESE_SIGN_BISAH";
        case   0x1B05: return "BALINESE_LETTER_AKARA";
        case   0x1B06: return "BALINESE_LETTER_AKARA_TEDUNG";
        case   0x1B07: return "BALINESE_LETTER_IKARA";
        case   0x1B08: return "BALINESE_LETTER_IKARA_TEDUNG";
        case   0x1B09: return "BALINESE_LETTER_UKARA";
        case   0x1B0A: return "BALINESE_LETTER_UKARA_TEDUNG";
        case   0x1B0B: return "BALINESE_LETTER_RA_REPA";
        case   0x1B0C: return "BALINESE_LETTER_RA_REPA_TEDUNG";
        case   0x1B0D: return "BALINESE_LETTER_LA_LENGA";
        case   0x1B0E: return "BALINESE_LETTER_LA_LENGA_TEDUNG";
        case   0x1B0F: return "BALINESE_LETTER_EKARA";
        case   0x1B10: return "BALINESE_LETTER_AIKARA";
        case   0x1B11: return "BALINESE_LETTER_OKARA";
        case   0x1B12: return "BALINESE_LETTER_OKARA_TEDUNG";
        case   0x1B13: return "BALINESE_LETTER_KA";
        case   0x1B14: return "BALINESE_LETTER_KA_MAHAPRANA";
        case   0x1B15: return "BALINESE_LETTER_GA";
        case   0x1B16: return "BALINESE_LETTER_GA_GORA";
        case   0x1B17: return "BALINESE_LETTER_NGA";
        case   0x1B18: return "BALINESE_LETTER_CA";
        case   0x1B19: return "BALINESE_LETTER_CA_LACA";
        case   0x1B1A: return "BALINESE_LETTER_JA";
        case   0x1B1B: return "BALINESE_LETTER_JA_JERA";
        case   0x1B1C: return "BALINESE_LETTER_NYA";
        case   0x1B1D: return "BALINESE_LETTER_TA_LATIK";
        case   0x1B1E: return "BALINESE_LETTER_TA_MURDA_MAHAPRANA";
        case   0x1B1F: return "BALINESE_LETTER_DA_MURDA_ALPAPRANA";
        case   0x1B20: return "BALINESE_LETTER_DA_MURDA_MAHAPRANA";
        case   0x1B21: return "BALINESE_LETTER_NA_RAMBAT";
        case   0x1B22: return "BALINESE_LETTER_TA";
        case   0x1B23: return "BALINESE_LETTER_TA_TAWA";
        case   0x1B24: return "BALINESE_LETTER_DA";
        case   0x1B25: return "BALINESE_LETTER_DA_MADU";
        case   0x1B26: return "BALINESE_LETTER_NA";
        case   0x1B27: return "BALINESE_LETTER_PA";
        case   0x1B28: return "BALINESE_LETTER_PA_KAPAL";
        case   0x1B29: return "BALINESE_LETTER_BA";
        case   0x1B2A: return "BALINESE_LETTER_BA_KEMBANG";
        case   0x1B2B: return "BALINESE_LETTER_MA";
        case   0x1B2C: return "BALINESE_LETTER_YA";
        case   0x1B2D: return "BALINESE_LETTER_RA";
        case   0x1B2E: return "BALINESE_LETTER_LA";
        case   0x1B2F: return "BALINESE_LETTER_WA";
        case   0x1B30: return "BALINESE_LETTER_SA_SAGA";
        case   0x1B31: return "BALINESE_LETTER_SA_SAPA";
        case   0x1B32: return "BALINESE_LETTER_SA";
        case   0x1B33: return "BALINESE_LETTER_HA";
        case   0x1B34: return "BALINESE_SIGN_REREKAN";
        case   0x1B35: return "BALINESE_VOWEL_SIGN_TEDUNG";
        case   0x1B36: return "BALINESE_VOWEL_SIGN_ULU";
        case   0x1B37: return "BALINESE_VOWEL_SIGN_ULU_SARI";
        case   0x1B38: return "BALINESE_VOWEL_SIGN_SUKU";
        case   0x1B39: return "BALINESE_VOWEL_SIGN_SUKU_ILUT";
        case   0x1B3A: return "BALINESE_VOWEL_SIGN_RA_REPA";
        case   0x1B3B: return "BALINESE_VOWEL_SIGN_RA_REPA_TEDUNG";
        case   0x1B3C: return "BALINESE_VOWEL_SIGN_LA_LENGA";
        case   0x1B3D: return "BALINESE_VOWEL_SIGN_LA_LENGA_TEDUNG";
        case   0x1B3E: return "BALINESE_VOWEL_SIGN_TALING";
        case   0x1B3F: return "BALINESE_VOWEL_SIGN_TALING_REPA";
        case   0x1B40: return "BALINESE_VOWEL_SIGN_TALING_TEDUNG";
        case   0x1B41: return "BALINESE_VOWEL_SIGN_TALING_REPA_TEDUNG";
        case   0x1B42: return "BALINESE_VOWEL_SIGN_PEPET";
        case   0x1B43: return "BALINESE_VOWEL_SIGN_PEPET_TEDUNG";
        case   0x1B44: return "BALINESE_ADEG_ADEG";
        case   0x1B45: return "BALINESE_LETTER_KAF_SASAK";
        case   0x1B46: return "BALINESE_LETTER_KHOT_SASAK";
        case   0x1B47: return "BALINESE_LETTER_TZIR_SASAK";
        case   0x1B48: return "BALINESE_LETTER_EF_SASAK";
        case   0x1B49: return "BALINESE_LETTER_VE_SASAK";
        case   0x1B4A: return "BALINESE_LETTER_ZAL_SASAK";
        case   0x1B4B: return "BALINESE_LETTER_ASYURA_SASAK";
        case   0x1B50: return "BALINESE_DIGIT_ZERO";
        case   0x1B51: return "BALINESE_DIGIT_ONE";
        case   0x1B52: return "BALINESE_DIGIT_TWO";
        case   0x1B53: return "BALINESE_DIGIT_THREE";
        case   0x1B54: return "BALINESE_DIGIT_FOUR";
        case   0x1B55: return "BALINESE_DIGIT_FIVE";
        case   0x1B56: return "BALINESE_DIGIT_SIX";
        case   0x1B57: return "BALINESE_DIGIT_SEVEN";
        case   0x1B58: return "BALINESE_DIGIT_EIGHT";
        case   0x1B59: return "BALINESE_DIGIT_NINE";
        case   0x1B5A: return "BALINESE_PANTI";
        case   0x1B5B: return "BALINESE_PAMADA";
        case   0x1B5C: return "BALINESE_WINDU";
        case   0x1B5D: return "BALINESE_CARIK_PAMUNGKAH";
        case   0x1B5E: return "BALINESE_CARIK_SIKI";
        case   0x1B5F: return "BALINESE_CARIK_PAREREN";
        case   0x1B60: return "BALINESE_PAMENENG";
        case   0x1B61: return "BALINESE_MUSICAL_SYMBOL_DONG";
        case   0x1B62: return "BALINESE_MUSICAL_SYMBOL_DENG";
        case   0x1B63: return "BALINESE_MUSICAL_SYMBOL_DUNG";
        case   0x1B64: return "BALINESE_MUSICAL_SYMBOL_DANG";
        case   0x1B65: return "BALINESE_MUSICAL_SYMBOL_DANG_SURANG";
        case   0x1B66: return "BALINESE_MUSICAL_SYMBOL_DING";
        case   0x1B67: return "BALINESE_MUSICAL_SYMBOL_DAENG";
        case   0x1B68: return "BALINESE_MUSICAL_SYMBOL_DEUNG";
        case   0x1B69: return "BALINESE_MUSICAL_SYMBOL_DAING";
        case   0x1B6A: return "BALINESE_MUSICAL_SYMBOL_DANG_GEDE";
        case   0x1B6B: return "BALINESE_MUSICAL_SYMBOL_COMBINING_TEGEH";
        case   0x1B6C: return "BALINESE_MUSICAL_SYMBOL_COMBINING_ENDEP";
        case   0x1B6D: return "BALINESE_MUSICAL_SYMBOL_COMBINING_KEMPUL";
        case   0x1B6E: return "BALINESE_MUSICAL_SYMBOL_COMBINING_KEMPLI";
        case   0x1B6F: return "BALINESE_MUSICAL_SYMBOL_COMBINING_JEGOGAN";
        case   0x1B70: return
                "BALINESE_MUSICAL_SYMBOL_COMBINING_KEMPUL_WITH_JEGOGAN";
        case   0x1B71: return
                "BALINESE_MUSICAL_SYMBOL_COMBINING_KEMPLI_WITH_JEGOGAN";
        case   0x1B72: return "BALINESE_MUSICAL_SYMBOL_COMBINING_BENDE";
        case   0x1B73: return "BALINESE_MUSICAL_SYMBOL_COMBINING_GONG";
        case   0x1B74: return "BALINESE_MUSICAL_SYMBOL_RIGHT_HAND_OPEN_DUG";
        case   0x1B75: return "BALINESE_MUSICAL_SYMBOL_RIGHT_HAND_OPEN_DAG";
        case   0x1B76: return "BALINESE_MUSICAL_SYMBOL_RIGHT_HAND_CLOSED_TUK";
        case   0x1B77: return "BALINESE_MUSICAL_SYMBOL_RIGHT_HAND_CLOSED_TAK";
        case   0x1B78: return "BALINESE_MUSICAL_SYMBOL_LEFT_HAND_OPEN_PANG";
        case   0x1B79: return "BALINESE_MUSICAL_SYMBOL_LEFT_HAND_OPEN_PUNG";
        case   0x1B7A: return "BALINESE_MUSICAL_SYMBOL_LEFT_HAND_CLOSED_PLAK";
        case   0x1B7B: return "BALINESE_MUSICAL_SYMBOL_LEFT_HAND_CLOSED_PLUK";
        case   0x1B7C: return "BALINESE_MUSICAL_SYMBOL_LEFT_HAND_OPEN_PING";
        case   0x1B80: return "SUNDANESE_SIGN_PANYECEK";
        case   0x1B81: return "SUNDANESE_SIGN_PANGLAYAR";
        case   0x1B82: return "SUNDANESE_SIGN_PANGWISAD";
        case   0x1B83: return "SUNDANESE_LETTER_A";
        case   0x1B84: return "SUNDANESE_LETTER_I";
        case   0x1B85: return "SUNDANESE_LETTER_U";
        case   0x1B86: return "SUNDANESE_LETTER_AE";
        case   0x1B87: return "SUNDANESE_LETTER_O";
        case   0x1B88: return "SUNDANESE_LETTER_E";
        case   0x1B89: return "SUNDANESE_LETTER_EU";
        case   0x1B8A: return "SUNDANESE_LETTER_KA";
        case   0x1B8B: return "SUNDANESE_LETTER_QA";
        case   0x1B8C: return "SUNDANESE_LETTER_GA";
        case   0x1B8D: return "SUNDANESE_LETTER_NGA";
        case   0x1B8E: return "SUNDANESE_LETTER_CA";
        case   0x1B8F: return "SUNDANESE_LETTER_JA";
        case   0x1B90: return "SUNDANESE_LETTER_ZA";
        case   0x1B91: return "SUNDANESE_LETTER_NYA";
        case   0x1B92: return "SUNDANESE_LETTER_TA";
        case   0x1B93: return "SUNDANESE_LETTER_DA";
        case   0x1B94: return "SUNDANESE_LETTER_NA";
        case   0x1B95: return "SUNDANESE_LETTER_PA";
        case   0x1B96: return "SUNDANESE_LETTER_FA";
        case   0x1B97: return "SUNDANESE_LETTER_VA";
        case   0x1B98: return "SUNDANESE_LETTER_BA";
        case   0x1B99: return "SUNDANESE_LETTER_MA";
        case   0x1B9A: return "SUNDANESE_LETTER_YA";
        case   0x1B9B: return "SUNDANESE_LETTER_RA";
        case   0x1B9C: return "SUNDANESE_LETTER_LA";
        case   0x1B9D: return "SUNDANESE_LETTER_WA";
        case   0x1B9E: return "SUNDANESE_LETTER_SA";
        case   0x1B9F: return "SUNDANESE_LETTER_XA";
        case   0x1BA0: return "SUNDANESE_LETTER_HA";
        case   0x1BA1: return "SUNDANESE_CONSONANT_SIGN_PAMINGKAL";
        case   0x1BA2: return "SUNDANESE_CONSONANT_SIGN_PANYAKRA";
        case   0x1BA3: return "SUNDANESE_CONSONANT_SIGN_PANYIKU";
        case   0x1BA4: return "SUNDANESE_VOWEL_SIGN_PANGHULU";
        case   0x1BA5: return "SUNDANESE_VOWEL_SIGN_PANYUKU";
        case   0x1BA6: return "SUNDANESE_VOWEL_SIGN_PANAELAENG";
        case   0x1BA7: return "SUNDANESE_VOWEL_SIGN_PANOLONG";
        case   0x1BA8: return "SUNDANESE_VOWEL_SIGN_PAMEPET";
        case   0x1BA9: return "SUNDANESE_VOWEL_SIGN_PANEULEUNG";
        case   0x1BAA: return "SUNDANESE_SIGN_PAMAAEH";
        case   0x1BAB: return "SUNDANESE_SIGN_VIRAMA";
        case   0x1BAC: return "SUNDANESE_CONSONANT_SIGN_PASANGAN_MA";
        case   0x1BAD: return "SUNDANESE_CONSONANT_SIGN_PASANGAN_WA";
        case   0x1BAE: return "SUNDANESE_LETTER_KHA";
        case   0x1BAF: return "SUNDANESE_LETTER_SYA";
        case   0x1BB0: return "SUNDANESE_DIGIT_ZERO";
        case   0x1BB1: return "SUNDANESE_DIGIT_ONE";
        case   0x1BB2: return "SUNDANESE_DIGIT_TWO";
        case   0x1BB3: return "SUNDANESE_DIGIT_THREE";
        case   0x1BB4: return "SUNDANESE_DIGIT_FOUR";
        case   0x1BB5: return "SUNDANESE_DIGIT_FIVE";
        case   0x1BB6: return "SUNDANESE_DIGIT_SIX";
        case   0x1BB7: return "SUNDANESE_DIGIT_SEVEN";
        case   0x1BB8: return "SUNDANESE_DIGIT_EIGHT";
        case   0x1BB9: return "SUNDANESE_DIGIT_NINE";
        case   0x1BBA: return "SUNDANESE_AVAGRAHA";
        case   0x1BBB: return "SUNDANESE_LETTER_REU";
        case   0x1BBC: return "SUNDANESE_LETTER_LEU";
        case   0x1BBD: return "SUNDANESE_LETTER_BHA";
        case   0x1BBE: return "SUNDANESE_LETTER_FINAL_K";
        case   0x1BBF: return "SUNDANESE_LETTER_FINAL_M";
        case   0x1BC0: return "BATAK_LETTER_A";
        case   0x1BC1: return "BATAK_LETTER_SIMALUNGUN_A";
        case   0x1BC2: return "BATAK_LETTER_HA";
        case   0x1BC3: return "BATAK_LETTER_SIMALUNGUN_HA";
        case   0x1BC4: return "BATAK_LETTER_MANDAILING_HA";
        case   0x1BC5: return "BATAK_LETTER_BA";
        case   0x1BC6: return "BATAK_LETTER_KARO_BA";
        case   0x1BC7: return "BATAK_LETTER_PA";
        case   0x1BC8: return "BATAK_LETTER_SIMALUNGUN_PA";
        case   0x1BC9: return "BATAK_LETTER_NA";
        case   0x1BCA: return "BATAK_LETTER_MANDAILING_NA";
        case   0x1BCB: return "BATAK_LETTER_WA";
        case   0x1BCC: return "BATAK_LETTER_SIMALUNGUN_WA";
        case   0x1BCD: return "BATAK_LETTER_PAKPAK_WA";
        case   0x1BCE: return "BATAK_LETTER_GA";
        case   0x1BCF: return "BATAK_LETTER_SIMALUNGUN_GA";
        case   0x1BD0: return "BATAK_LETTER_JA";
        case   0x1BD1: return "BATAK_LETTER_DA";
        case   0x1BD2: return "BATAK_LETTER_RA";
        case   0x1BD3: return "BATAK_LETTER_SIMALUNGUN_RA";
        case   0x1BD4: return "BATAK_LETTER_MA";
        case   0x1BD5: return "BATAK_LETTER_SIMALUNGUN_MA";
        case   0x1BD6: return "BATAK_LETTER_SOUTHERN_TA";
        case   0x1BD7: return "BATAK_LETTER_NORTHERN_TA";
        case   0x1BD8: return "BATAK_LETTER_SA";
        case   0x1BD9: return "BATAK_LETTER_SIMALUNGUN_SA";
        case   0x1BDA: return "BATAK_LETTER_MANDAILING_SA";
        case   0x1BDB: return "BATAK_LETTER_YA";
        case   0x1BDC: return "BATAK_LETTER_SIMALUNGUN_YA";
        case   0x1BDD: return "BATAK_LETTER_NGA";
        case   0x1BDE: return "BATAK_LETTER_LA";
        case   0x1BDF: return "BATAK_LETTER_SIMALUNGUN_LA";
        case   0x1BE0: return "BATAK_LETTER_NYA";
        case   0x1BE1: return "BATAK_LETTER_CA";
        case   0x1BE2: return "BATAK_LETTER_NDA";
        case   0x1BE3: return "BATAK_LETTER_MBA";
        case   0x1BE4: return "BATAK_LETTER_I";
        case   0x1BE5: return "BATAK_LETTER_U";
        case   0x1BE6: return "BATAK_SIGN_TOMPI";
        case   0x1BE7: return "BATAK_VOWEL_SIGN_E";
        case   0x1BE8: return "BATAK_VOWEL_SIGN_PAKPAK_E";
        case   0x1BE9: return "BATAK_VOWEL_SIGN_EE";
        case   0x1BEA: return "BATAK_VOWEL_SIGN_I";
        case   0x1BEB: return "BATAK_VOWEL_SIGN_KARO_I";
        case   0x1BEC: return "BATAK_VOWEL_SIGN_O";
        case   0x1BED: return "BATAK_VOWEL_SIGN_KARO_O";
        case   0x1BEE: return "BATAK_VOWEL_SIGN_U";
        case   0x1BEF: return "BATAK_VOWEL_SIGN_U_FOR_SIMALUNGUN_SA";
        case   0x1BF0: return "BATAK_CONSONANT_SIGN_NG";
        case   0x1BF1: return "BATAK_CONSONANT_SIGN_H";
        case   0x1BF2: return "BATAK_PANGOLAT";
        case   0x1BF3: return "BATAK_PANONGONAN";
        case   0x1BFC: return "BATAK_SYMBOL_BINDU_NA_METEK";
        case   0x1BFD: return "BATAK_SYMBOL_BINDU_PINARBORAS";
        case   0x1BFE: return "BATAK_SYMBOL_BINDU_JUDUL";
        case   0x1BFF: return "BATAK_SYMBOL_BINDU_PANGOLAT";
        case   0x1C00: return "LEPCHA_LETTER_KA";
        case   0x1C01: return "LEPCHA_LETTER_KLA";
        case   0x1C02: return "LEPCHA_LETTER_KHA";
        case   0x1C03: return "LEPCHA_LETTER_GA";
        case   0x1C04: return "LEPCHA_LETTER_GLA";
        case   0x1C05: return "LEPCHA_LETTER_NGA";
        case   0x1C06: return "LEPCHA_LETTER_CA";
        case   0x1C07: return "LEPCHA_LETTER_CHA";
        case   0x1C08: return "LEPCHA_LETTER_JA";
        case   0x1C09: return "LEPCHA_LETTER_NYA";
        case   0x1C0A: return "LEPCHA_LETTER_TA";
        case   0x1C0B: return "LEPCHA_LETTER_THA";
        case   0x1C0C: return "LEPCHA_LETTER_DA";
        case   0x1C0D: return "LEPCHA_LETTER_NA";
        case   0x1C0E: return "LEPCHA_LETTER_PA";
        case   0x1C0F: return "LEPCHA_LETTER_PLA";
        case   0x1C10: return "LEPCHA_LETTER_PHA";
        case   0x1C11: return "LEPCHA_LETTER_FA";
        case   0x1C12: return "LEPCHA_LETTER_FLA";
        case   0x1C13: return "LEPCHA_LETTER_BA";
        case   0x1C14: return "LEPCHA_LETTER_BLA";
        case   0x1C15: return "LEPCHA_LETTER_MA";
        case   0x1C16: return "LEPCHA_LETTER_MLA";
        case   0x1C17: return "LEPCHA_LETTER_TSA";
        case   0x1C18: return "LEPCHA_LETTER_TSHA";
        case   0x1C19: return "LEPCHA_LETTER_DZA";
        case   0x1C1A: return "LEPCHA_LETTER_YA";
        case   0x1C1B: return "LEPCHA_LETTER_RA";
        case   0x1C1C: return "LEPCHA_LETTER_LA";
        case   0x1C1D: return "LEPCHA_LETTER_HA";
        case   0x1C1E: return "LEPCHA_LETTER_HLA";
        case   0x1C1F: return "LEPCHA_LETTER_VA";
        case   0x1C20: return "LEPCHA_LETTER_SA";
        case   0x1C21: return "LEPCHA_LETTER_SHA";
        case   0x1C22: return "LEPCHA_LETTER_WA";
        case   0x1C23: return "LEPCHA_LETTER_A";
        case   0x1C24: return "LEPCHA_SUBJOINED_LETTER_YA";
        case   0x1C25: return "LEPCHA_SUBJOINED_LETTER_RA";
        case   0x1C26: return "LEPCHA_VOWEL_SIGN_AA";
        case   0x1C27: return "LEPCHA_VOWEL_SIGN_I";
        case   0x1C28: return "LEPCHA_VOWEL_SIGN_O";
        case   0x1C29: return "LEPCHA_VOWEL_SIGN_OO";
        case   0x1C2A: return "LEPCHA_VOWEL_SIGN_U";
        case   0x1C2B: return "LEPCHA_VOWEL_SIGN_UU";
        case   0x1C2C: return "LEPCHA_VOWEL_SIGN_E";
        case   0x1C2D: return "LEPCHA_CONSONANT_SIGN_K";
        case   0x1C2E: return "LEPCHA_CONSONANT_SIGN_M";
        case   0x1C2F: return "LEPCHA_CONSONANT_SIGN_L";
        case   0x1C30: return "LEPCHA_CONSONANT_SIGN_N";
        case   0x1C31: return "LEPCHA_CONSONANT_SIGN_P";
        case   0x1C32: return "LEPCHA_CONSONANT_SIGN_R";
        case   0x1C33: return "LEPCHA_CONSONANT_SIGN_T";
        case   0x1C34: return "LEPCHA_CONSONANT_SIGN_NYIN_DO";
        case   0x1C35: return "LEPCHA_CONSONANT_SIGN_KANG";
        case   0x1C36: return "LEPCHA_SIGN_RAN";
        case   0x1C37: return "LEPCHA_SIGN_NUKTA";
        case   0x1C3B: return "LEPCHA_PUNCTUATION_TA_ROL";
        case   0x1C3C: return "LEPCHA_PUNCTUATION_NYET_THYOOM_TA_ROL";
        case   0x1C3D: return "LEPCHA_PUNCTUATION_CER_WA";
        case   0x1C3E: return "LEPCHA_PUNCTUATION_TSHOOK_CER_WA";
        case   0x1C3F: return "LEPCHA_PUNCTUATION_TSHOOK";
        case   0x1C40: return "LEPCHA_DIGIT_ZERO";
        case   0x1C41: return "LEPCHA_DIGIT_ONE";
        case   0x1C42: return "LEPCHA_DIGIT_TWO";
        case   0x1C43: return "LEPCHA_DIGIT_THREE";
        case   0x1C44: return "LEPCHA_DIGIT_FOUR";
        case   0x1C45: return "LEPCHA_DIGIT_FIVE";
        case   0x1C46: return "LEPCHA_DIGIT_SIX";
        case   0x1C47: return "LEPCHA_DIGIT_SEVEN";
        case   0x1C48: return "LEPCHA_DIGIT_EIGHT";
        case   0x1C49: return "LEPCHA_DIGIT_NINE";
        case   0x1C4D: return "LEPCHA_LETTER_TTA";
        case   0x1C4E: return "LEPCHA_LETTER_TTHA";
        case   0x1C4F: return "LEPCHA_LETTER_DDA";
        case   0x1C50: return "OL_CHIKI_DIGIT_ZERO";
        case   0x1C51: return "OL_CHIKI_DIGIT_ONE";
        case   0x1C52: return "OL_CHIKI_DIGIT_TWO";
        case   0x1C53: return "OL_CHIKI_DIGIT_THREE";
        case   0x1C54: return "OL_CHIKI_DIGIT_FOUR";
        case   0x1C55: return "OL_CHIKI_DIGIT_FIVE";
        case   0x1C56: return "OL_CHIKI_DIGIT_SIX";
        case   0x1C57: return "OL_CHIKI_DIGIT_SEVEN";
        case   0x1C58: return "OL_CHIKI_DIGIT_EIGHT";
        case   0x1C59: return "OL_CHIKI_DIGIT_NINE";
        case   0x1C5A: return "OL_CHIKI_LETTER_LA";
        case   0x1C5B: return "OL_CHIKI_LETTER_AT";
        case   0x1C5C: return "OL_CHIKI_LETTER_AG";
        case   0x1C5D: return "OL_CHIKI_LETTER_ANG";
        case   0x1C5E: return "OL_CHIKI_LETTER_AL";
        case   0x1C5F: return "OL_CHIKI_LETTER_LAA";
        case   0x1C60: return "OL_CHIKI_LETTER_AAK";
        case   0x1C61: return "OL_CHIKI_LETTER_AAJ";
        case   0x1C62: return "OL_CHIKI_LETTER_AAM";
        case   0x1C63: return "OL_CHIKI_LETTER_AAW";
        case   0x1C64: return "OL_CHIKI_LETTER_LI";
        case   0x1C65: return "OL_CHIKI_LETTER_IS";
        case   0x1C66: return "OL_CHIKI_LETTER_IH";
        case   0x1C67: return "OL_CHIKI_LETTER_INY";
        case   0x1C68: return "OL_CHIKI_LETTER_IR";
        case   0x1C69: return "OL_CHIKI_LETTER_LU";
        case   0x1C6A: return "OL_CHIKI_LETTER_UC";
        case   0x1C6B: return "OL_CHIKI_LETTER_UD";
        case   0x1C6C: return "OL_CHIKI_LETTER_UNN";
        case   0x1C6D: return "OL_CHIKI_LETTER_UY";
        case   0x1C6E: return "OL_CHIKI_LETTER_LE";
        case   0x1C6F: return "OL_CHIKI_LETTER_EP";
        case   0x1C70: return "OL_CHIKI_LETTER_EDD";
        case   0x1C71: return "OL_CHIKI_LETTER_EN";
        case   0x1C72: return "OL_CHIKI_LETTER_ERR";
        case   0x1C73: return "OL_CHIKI_LETTER_LO";
        case   0x1C74: return "OL_CHIKI_LETTER_OTT";
        case   0x1C75: return "OL_CHIKI_LETTER_OB";
        case   0x1C76: return "OL_CHIKI_LETTER_OV";
        case   0x1C77: return "OL_CHIKI_LETTER_OH";
        case   0x1C78: return "OL_CHIKI_MU_TTUDDAG";
        case   0x1C79: return "OL_CHIKI_GAAHLAA_TTUDDAAG";
        case   0x1C7A: return "OL_CHIKI_MU_GAAHLAA_TTUDDAAG";
        case   0x1C7B: return "OL_CHIKI_RELAA";
        case   0x1C7C: return "OL_CHIKI_PHAARKAA";
        case   0x1C7D: return "OL_CHIKI_AHAD";
        case   0x1C7E: return "OL_CHIKI_PUNCTUATION_MUCAAD";
        case   0x1C7F: return "OL_CHIKI_PUNCTUATION_DOUBLE_MUCAAD";
        case   0x1CC0: return "SUNDANESE_PUNCTUATION_BINDU_SURYA";
        case   0x1CC1: return "SUNDANESE_PUNCTUATION_BINDU_PANGLONG";
        case   0x1CC2: return "SUNDANESE_PUNCTUATION_BINDU_PURNAMA";
        case   0x1CC3: return "SUNDANESE_PUNCTUATION_BINDU_CAKRA";
        case   0x1CC4: return "SUNDANESE_PUNCTUATION_BINDU_LEU_SATANGA";
        case   0x1CC5: return "SUNDANESE_PUNCTUATION_BINDU_KA_SATANGA";
        case   0x1CC6: return "SUNDANESE_PUNCTUATION_BINDU_DA_SATANGA";
        case   0x1CC7: return "SUNDANESE_PUNCTUATION_BINDU_BA_SATANGA";
        case   0x1CD0: return "VEDIC_TONE_KARSHANA";
        case   0x1CD1: return "VEDIC_TONE_SHARA";
        case   0x1CD2: return "VEDIC_TONE_PRENKHA";
        case   0x1CD3: return "VEDIC_SIGN_NIHSHVASA";
        case   0x1CD4: return "VEDIC_SIGN_YAJURVEDIC_MIDLINE_SVARITA";
        case   0x1CD5: return
                "VEDIC_TONE_YAJURVEDIC_AGGRAVATED_INDEPENDENT_SVARITA";
        case   0x1CD6: return "VEDIC_TONE_YAJURVEDIC_INDEPENDENT_SVARITA";
        case   0x1CD7: return
                "VEDIC_TONE_YAJURVEDIC_KATHAKA_INDEPENDENT_SVARITA";
        case   0x1CD8: return "VEDIC_TONE_CANDRA_BELOW";
        case   0x1CD9: return
                "VEDIC_TONE_YAJURVEDIC_KATHAKA_INDEPENDENT_SVARITA_SCHROEDER0";
        case   0x1CDA: return "VEDIC_TONE_DOUBLE_SVARITA";
        case   0x1CDB: return "VEDIC_TONE_TRIPLE_SVARITA";
        case   0x1CDC: return "VEDIC_TONE_KATHAKA_ANUDATTA";
        case   0x1CDD: return "VEDIC_TONE_DOT_BELOW";
        case   0x1CDE: return "VEDIC_TONE_TWO_DOTS_BELOW";
        case   0x1CDF: return "VEDIC_TONE_THREE_DOTS_BELOW";
        case   0x1CE0: return
                "VEDIC_TONE_RIGVEDIC_KASHMIRI_INDEPENDENT_SVARITA";
        case   0x1CE1: return "VEDIC_TONE_ATHARVAVEDIC_INDEPENDENT_SVARITA";
        case   0x1CE2: return "VEDIC_SIGN_VISARGA_SVARITA";
        case   0x1CE3: return "VEDIC_SIGN_VISARGA_UDATTA";
        case   0x1CE4: return "VEDIC_SIGN_REVERSED_VISARGA_UDATTA";
        case   0x1CE5: return "VEDIC_SIGN_VISARGA_ANUDATTA";
        case   0x1CE6: return "VEDIC_SIGN_REVERSED_VISARGA_ANUDATTA";
        case   0x1CE7: return "VEDIC_SIGN_VISARGA_UDATTA_WITH_TAIL";
        case   0x1CE8: return "VEDIC_SIGN_VISARGA_ANUDATTA_WITH_TAIL";
        case   0x1CE9: return "VEDIC_SIGN_ANUSVARA_ANTARGOMUKHA";
        case   0x1CEA: return "VEDIC_SIGN_ANUSVARA_BAHIRGOMUKHA";
        case   0x1CEB: return "VEDIC_SIGN_ANUSVARA_VAMAGOMUKHA";
        case   0x1CEC: return "VEDIC_SIGN_ANUSVARA_VAMAGOMUKHA_WITH_TAIL";
        case   0x1CED: return "VEDIC_SIGN_TIRYAK";
        case   0x1CEE: return "VEDIC_SIGN_HEXIFORM_LONG_ANUSVARA";
        case   0x1CEF: return "VEDIC_SIGN_LONG_ANUSVARA";
        case   0x1CF0: return "VEDIC_SIGN_RTHANG_LONG_ANUSVARA";
        case   0x1CF1: return "VEDIC_SIGN_ANUSVARA_UBHAYATO_MUKHA";
        case   0x1CF2: return "VEDIC_SIGN_ARDHAVISARGA";
        case   0x1CF3: return "VEDIC_SIGN_ROTATED_ARDHAVISARGA";
        case   0x1CF4: return "VEDIC_TONE_CANDRA_ABOVE";
        case   0x1CF5: return "VEDIC_SIGN_JIHVAMULIYA";
        case   0x1CF6: return "VEDIC_SIGN_UPADHMANIYA";
        case   0x1CF8: return "VEDIC_TONE_RING_ABOVE";
        case   0x1CF9: return "VEDIC_TONE_DOUBLE_RING_ABOVE";
        case   0x1D00: return "LATIN_LETTER_SMALL_CAPITAL_A";
        case   0x1D01: return "LATIN_LETTER_SMALL_CAPITAL_AE";
        case   0x1D02: return "LATIN_SMALL_LETTER_TURNED_AE";
        case   0x1D03: return "LATIN_LETTER_SMALL_CAPITAL_BARRED_B";
        case   0x1D04: return "LATIN_LETTER_SMALL_CAPITAL_C";
        case   0x1D05: return "LATIN_LETTER_SMALL_CAPITAL_D";
        case   0x1D06: return "LATIN_LETTER_SMALL_CAPITAL_ETH";
        case   0x1D07: return "LATIN_LETTER_SMALL_CAPITAL_E";
        case   0x1D08: return "LATIN_SMALL_LETTER_TURNED_OPEN_E";
        case   0x1D09: return "LATIN_SMALL_LETTER_TURNED_I";
        case   0x1D0A: return "LATIN_LETTER_SMALL_CAPITAL_J";
        case   0x1D0B: return "LATIN_LETTER_SMALL_CAPITAL_K";
        case   0x1D0C: return "LATIN_LETTER_SMALL_CAPITAL_L_WITH_STROKE";
        case   0x1D0D: return "LATIN_LETTER_SMALL_CAPITAL_M";
        case   0x1D0E: return "LATIN_LETTER_SMALL_CAPITAL_REVERSED_N";
        case   0x1D0F: return "LATIN_LETTER_SMALL_CAPITAL_O";
        case   0x1D10: return "LATIN_LETTER_SMALL_CAPITAL_OPEN_O";
        case   0x1D11: return "LATIN_SMALL_LETTER_SIDEWAYS_O";
        case   0x1D12: return "LATIN_SMALL_LETTER_SIDEWAYS_OPEN_O";
        case   0x1D13: return "LATIN_SMALL_LETTER_SIDEWAYS_O_WITH_STROKE";
        case   0x1D14: return "LATIN_SMALL_LETTER_TURNED_OE";
        case   0x1D15: return "LATIN_LETTER_SMALL_CAPITAL_OU";
        case   0x1D16: return "LATIN_SMALL_LETTER_TOP_HALF_O";
        case   0x1D17: return "LATIN_SMALL_LETTER_BOTTOM_HALF_O";
        case   0x1D18: return "LATIN_LETTER_SMALL_CAPITAL_P";
        case   0x1D19: return "LATIN_LETTER_SMALL_CAPITAL_REVERSED_R";
        case   0x1D1A: return "LATIN_LETTER_SMALL_CAPITAL_TURNED_R";
        case   0x1D1B: return "LATIN_LETTER_SMALL_CAPITAL_T";
        case   0x1D1C: return "LATIN_LETTER_SMALL_CAPITAL_U";
        case   0x1D1D: return "LATIN_SMALL_LETTER_SIDEWAYS_U";
        case   0x1D1E: return "LATIN_SMALL_LETTER_SIDEWAYS_DIAERESIZED_U";
        case   0x1D1F: return "LATIN_SMALL_LETTER_SIDEWAYS_TURNED_M";
        case   0x1D20: return "LATIN_LETTER_SMALL_CAPITAL_V";
        case   0x1D21: return "LATIN_LETTER_SMALL_CAPITAL_W";
        case   0x1D22: return "LATIN_LETTER_SMALL_CAPITAL_Z";
        case   0x1D23: return "LATIN_LETTER_SMALL_CAPITAL_EZH";
        case   0x1D24: return "LATIN_LETTER_VOICED_LARYNGEAL_SPIRANT";
        case   0x1D25: return "LATIN_LETTER_AIN";
        case   0x1D26: return "GREEK_LETTER_SMALL_CAPITAL_GAMMA";
        case   0x1D27: return "GREEK_LETTER_SMALL_CAPITAL_LAMDA";
        case   0x1D28: return "GREEK_LETTER_SMALL_CAPITAL_PI";
        case   0x1D29: return "GREEK_LETTER_SMALL_CAPITAL_RHO";
        case   0x1D2A: return "GREEK_LETTER_SMALL_CAPITAL_PSI";
        case   0x1D2B: return "CYRILLIC_LETTER_SMALL_CAPITAL_EL";
        case   0x1D2C: return "MODIFIER_LETTER_CAPITAL_A";
        case   0x1D2D: return "MODIFIER_LETTER_CAPITAL_AE";
        case   0x1D2E: return "MODIFIER_LETTER_CAPITAL_B";
        case   0x1D2F: return "MODIFIER_LETTER_CAPITAL_BARRED_B";
        case   0x1D30: return "MODIFIER_LETTER_CAPITAL_D";
        case   0x1D31: return "MODIFIER_LETTER_CAPITAL_E";
        case   0x1D32: return "MODIFIER_LETTER_CAPITAL_REVERSED_E";
        case   0x1D33: return "MODIFIER_LETTER_CAPITAL_G";
        case   0x1D34: return "MODIFIER_LETTER_CAPITAL_H";
        case   0x1D35: return "MODIFIER_LETTER_CAPITAL_I";
        case   0x1D36: return "MODIFIER_LETTER_CAPITAL_J";
        case   0x1D37: return "MODIFIER_LETTER_CAPITAL_K";
        case   0x1D38: return "MODIFIER_LETTER_CAPITAL_L";
        case   0x1D39: return "MODIFIER_LETTER_CAPITAL_M";
        case   0x1D3A: return "MODIFIER_LETTER_CAPITAL_N";
        case   0x1D3B: return "MODIFIER_LETTER_CAPITAL_REVERSED_N";
        case   0x1D3C: return "MODIFIER_LETTER_CAPITAL_O";
        case   0x1D3D: return "MODIFIER_LETTER_CAPITAL_OU";
        case   0x1D3E: return "MODIFIER_LETTER_CAPITAL_P";
        case   0x1D3F: return "MODIFIER_LETTER_CAPITAL_R";
        case   0x1D40: return "MODIFIER_LETTER_CAPITAL_T";
        case   0x1D41: return "MODIFIER_LETTER_CAPITAL_U";
        case   0x1D42: return "MODIFIER_LETTER_CAPITAL_W";
        case   0x1D43: return "MODIFIER_LETTER_SMALL_A";
        case   0x1D44: return "MODIFIER_LETTER_SMALL_TURNED_A";
        case   0x1D45: return "MODIFIER_LETTER_SMALL_ALPHA";
        case   0x1D46: return "MODIFIER_LETTER_SMALL_TURNED_AE";
        case   0x1D47: return "MODIFIER_LETTER_SMALL_B";
        case   0x1D48: return "MODIFIER_LETTER_SMALL_D";
        case   0x1D49: return "MODIFIER_LETTER_SMALL_E";
        case   0x1D4A: return "MODIFIER_LETTER_SMALL_SCHWA";
        case   0x1D4B: return "MODIFIER_LETTER_SMALL_OPEN_E";
        case   0x1D4C: return "MODIFIER_LETTER_SMALL_TURNED_OPEN_E";
        case   0x1D4D: return "MODIFIER_LETTER_SMALL_G";
        case   0x1D4E: return "MODIFIER_LETTER_SMALL_TURNED_I";
        case   0x1D4F: return "MODIFIER_LETTER_SMALL_K";
        case   0x1D50: return "MODIFIER_LETTER_SMALL_M";
        case   0x1D51: return "MODIFIER_LETTER_SMALL_ENG";
        case   0x1D52: return "MODIFIER_LETTER_SMALL_O";
        case   0x1D53: return "MODIFIER_LETTER_SMALL_OPEN_O";
        case   0x1D54: return "MODIFIER_LETTER_SMALL_TOP_HALF_O";
        case   0x1D55: return "MODIFIER_LETTER_SMALL_BOTTOM_HALF_O";
        case   0x1D56: return "MODIFIER_LETTER_SMALL_P";
        case   0x1D57: return "MODIFIER_LETTER_SMALL_T";
        case   0x1D58: return "MODIFIER_LETTER_SMALL_U";
        case   0x1D59: return "MODIFIER_LETTER_SMALL_SIDEWAYS_U";
        case   0x1D5A: return "MODIFIER_LETTER_SMALL_TURNED_M";
        case   0x1D5B: return "MODIFIER_LETTER_SMALL_V";
        case   0x1D5C: return "MODIFIER_LETTER_SMALL_AIN";
        case   0x1D5D: return "MODIFIER_LETTER_SMALL_BETA";
        case   0x1D5E: return "MODIFIER_LETTER_SMALL_GREEK_GAMMA";
        case   0x1D5F: return "MODIFIER_LETTER_SMALL_DELTA";
        case   0x1D60: return "MODIFIER_LETTER_SMALL_GREEK_PHI";
        case   0x1D61: return "MODIFIER_LETTER_SMALL_CHI";
        case   0x1D62: return "LATIN_SUBSCRIPT_SMALL_LETTER_I";
        case   0x1D63: return "LATIN_SUBSCRIPT_SMALL_LETTER_R";
        case   0x1D64: return "LATIN_SUBSCRIPT_SMALL_LETTER_U";
        case   0x1D65: return "LATIN_SUBSCRIPT_SMALL_LETTER_V";
        case   0x1D66: return "GREEK_SUBSCRIPT_SMALL_LETTER_BETA";
        case   0x1D67: return "GREEK_SUBSCRIPT_SMALL_LETTER_GAMMA";
        case   0x1D68: return "GREEK_SUBSCRIPT_SMALL_LETTER_RHO";
        case   0x1D69: return "GREEK_SUBSCRIPT_SMALL_LETTER_PHI";
        case   0x1D6A: return "GREEK_SUBSCRIPT_SMALL_LETTER_CHI";
        case   0x1D6B: return "LATIN_SMALL_LETTER_UE";
        case   0x1D6C: return "LATIN_SMALL_LETTER_B_WITH_MIDDLE_TILDE";
        case   0x1D6D: return "LATIN_SMALL_LETTER_D_WITH_MIDDLE_TILDE";
        case   0x1D6E: return "LATIN_SMALL_LETTER_F_WITH_MIDDLE_TILDE";
        case   0x1D6F: return "LATIN_SMALL_LETTER_M_WITH_MIDDLE_TILDE";
        case   0x1D70: return "LATIN_SMALL_LETTER_N_WITH_MIDDLE_TILDE";
        case   0x1D71: return "LATIN_SMALL_LETTER_P_WITH_MIDDLE_TILDE";
        case   0x1D72: return "LATIN_SMALL_LETTER_R_WITH_MIDDLE_TILDE";
        case   0x1D73: return
                "LATIN_SMALL_LETTER_R_WITH_FISHHOOK_AND_MIDDLE_TILDE";
        case   0x1D74: return "LATIN_SMALL_LETTER_S_WITH_MIDDLE_TILDE";
        case   0x1D75: return "LATIN_SMALL_LETTER_T_WITH_MIDDLE_TILDE";
        case   0x1D76: return "LATIN_SMALL_LETTER_Z_WITH_MIDDLE_TILDE";
        case   0x1D77: return "LATIN_SMALL_LETTER_TURNED_G";
        case   0x1D78: return "MODIFIER_LETTER_CYRILLIC_EN";
        case   0x1D79: return "LATIN_SMALL_LETTER_INSULAR_G";
        case   0x1D7A: return "LATIN_SMALL_LETTER_TH_WITH_STRIKETHROUGH";
        case   0x1D7B: return "LATIN_SMALL_CAPITAL_LETTER_I_WITH_STROKE";
        case   0x1D7C: return "LATIN_SMALL_LETTER_IOTA_WITH_STROKE";
        case   0x1D7D: return "LATIN_SMALL_LETTER_P_WITH_STROKE";
        case   0x1D7E: return "LATIN_SMALL_CAPITAL_LETTER_U_WITH_STROKE";
        case   0x1D7F: return "LATIN_SMALL_LETTER_UPSILON_WITH_STROKE";
        case   0x1D80: return "LATIN_SMALL_LETTER_B_WITH_PALATAL_HOOK";
        case   0x1D81: return "LATIN_SMALL_LETTER_D_WITH_PALATAL_HOOK";
        case   0x1D82: return "LATIN_SMALL_LETTER_F_WITH_PALATAL_HOOK";
        case   0x1D83: return "LATIN_SMALL_LETTER_G_WITH_PALATAL_HOOK";
        case   0x1D84: return "LATIN_SMALL_LETTER_K_WITH_PALATAL_HOOK";
        case   0x1D85: return "LATIN_SMALL_LETTER_L_WITH_PALATAL_HOOK";
        case   0x1D86: return "LATIN_SMALL_LETTER_M_WITH_PALATAL_HOOK";
        case   0x1D87: return "LATIN_SMALL_LETTER_N_WITH_PALATAL_HOOK";
        case   0x1D88: return "LATIN_SMALL_LETTER_P_WITH_PALATAL_HOOK";
        case   0x1D89: return "LATIN_SMALL_LETTER_R_WITH_PALATAL_HOOK";
        case   0x1D8A: return "LATIN_SMALL_LETTER_S_WITH_PALATAL_HOOK";
        case   0x1D8B: return "LATIN_SMALL_LETTER_ESH_WITH_PALATAL_HOOK";
        case   0x1D8C: return "LATIN_SMALL_LETTER_V_WITH_PALATAL_HOOK";
        case   0x1D8D: return "LATIN_SMALL_LETTER_X_WITH_PALATAL_HOOK";
        case   0x1D8E: return "LATIN_SMALL_LETTER_Z_WITH_PALATAL_HOOK";
        case   0x1D8F: return "LATIN_SMALL_LETTER_A_WITH_RETROFLEX_HOOK";
        case   0x1D90: return "LATIN_SMALL_LETTER_ALPHA_WITH_RETROFLEX_HOOK";
        case   0x1D91: return "LATIN_SMALL_LETTER_D_WITH_HOOK_AND_TAIL";
        case   0x1D92: return "LATIN_SMALL_LETTER_E_WITH_RETROFLEX_HOOK";
        case   0x1D93: return "LATIN_SMALL_LETTER_OPEN_E_WITH_RETROFLEX_HOOK";
        case   0x1D94: return
                "LATIN_SMALL_LETTER_REVERSED_OPEN_E_WITH_RETROFLEX_HOOK";
        case   0x1D95: return "LATIN_SMALL_LETTER_SCHWA_WITH_RETROFLEX_HOOK";
        case   0x1D96: return "LATIN_SMALL_LETTER_I_WITH_RETROFLEX_HOOK";
        case   0x1D97: return "LATIN_SMALL_LETTER_OPEN_O_WITH_RETROFLEX_HOOK";
        case   0x1D98: return "LATIN_SMALL_LETTER_ESH_WITH_RETROFLEX_HOOK";
        case   0x1D99: return "LATIN_SMALL_LETTER_U_WITH_RETROFLEX_HOOK";
        case   0x1D9A: return "LATIN_SMALL_LETTER_EZH_WITH_RETROFLEX_HOOK";
        case   0x1D9B: return "MODIFIER_LETTER_SMALL_TURNED_ALPHA";
        case   0x1D9C: return "MODIFIER_LETTER_SMALL_C";
        case   0x1D9D: return "MODIFIER_LETTER_SMALL_C_WITH_CURL";
        case   0x1D9E: return "MODIFIER_LETTER_SMALL_ETH";
        case   0x1D9F: return "MODIFIER_LETTER_SMALL_REVERSED_OPEN_E";
        case   0x1DA0: return "MODIFIER_LETTER_SMALL_F";
        case   0x1DA1: return "MODIFIER_LETTER_SMALL_DOTLESS_J_WITH_STROKE";
        case   0x1DA2: return "MODIFIER_LETTER_SMALL_SCRIPT_G";
        case   0x1DA3: return "MODIFIER_LETTER_SMALL_TURNED_H";
        case   0x1DA4: return "MODIFIER_LETTER_SMALL_I_WITH_STROKE";
        case   0x1DA5: return "MODIFIER_LETTER_SMALL_IOTA";
        case   0x1DA6: return "MODIFIER_LETTER_SMALL_CAPITAL_I";
        case   0x1DA7: return "MODIFIER_LETTER_SMALL_CAPITAL_I_WITH_STROKE";
        case   0x1DA8: return "MODIFIER_LETTER_SMALL_J_WITH_CROSSED_TAIL";
        case   0x1DA9: return "MODIFIER_LETTER_SMALL_L_WITH_RETROFLEX_HOOK";
        case   0x1DAA: return "MODIFIER_LETTER_SMALL_L_WITH_PALATAL_HOOK";
        case   0x1DAB: return "MODIFIER_LETTER_SMALL_CAPITAL_L";
        case   0x1DAC: return "MODIFIER_LETTER_SMALL_M_WITH_HOOK";
        case   0x1DAD: return "MODIFIER_LETTER_SMALL_TURNED_M_WITH_LONG_LEG";
        case   0x1DAE: return "MODIFIER_LETTER_SMALL_N_WITH_LEFT_HOOK";
        case   0x1DAF: return "MODIFIER_LETTER_SMALL_N_WITH_RETROFLEX_HOOK";
        case   0x1DB0: return "MODIFIER_LETTER_SMALL_CAPITAL_N";
        case   0x1DB1: return "MODIFIER_LETTER_SMALL_BARRED_O";
        case   0x1DB2: return "MODIFIER_LETTER_SMALL_PHI";
        case   0x1DB3: return "MODIFIER_LETTER_SMALL_S_WITH_HOOK";
        case   0x1DB4: return "MODIFIER_LETTER_SMALL_ESH";
        case   0x1DB5: return "MODIFIER_LETTER_SMALL_T_WITH_PALATAL_HOOK";
        case   0x1DB6: return "MODIFIER_LETTER_SMALL_U_BAR";
        case   0x1DB7: return "MODIFIER_LETTER_SMALL_UPSILON";
        case   0x1DB8: return "MODIFIER_LETTER_SMALL_CAPITAL_U";
        case   0x1DB9: return "MODIFIER_LETTER_SMALL_V_WITH_HOOK";
        case   0x1DBA: return "MODIFIER_LETTER_SMALL_TURNED_V";
        case   0x1DBB: return "MODIFIER_LETTER_SMALL_Z";
        case   0x1DBC: return "MODIFIER_LETTER_SMALL_Z_WITH_RETROFLEX_HOOK";
        case   0x1DBD: return "MODIFIER_LETTER_SMALL_Z_WITH_CURL";
        case   0x1DBE: return "MODIFIER_LETTER_SMALL_EZH";
        case   0x1DBF: return "MODIFIER_LETTER_SMALL_THETA";
        case   0x1DC0: return "COMBINING_DOTTED_GRAVE_ACCENT";
        case   0x1DC1: return "COMBINING_DOTTED_ACUTE_ACCENT";
        case   0x1DC2: return "COMBINING_SNAKE_BELOW";
        case   0x1DC3: return "COMBINING_SUSPENSION_MARK";
        case   0x1DC4: return "COMBINING_MACRON_ACUTE";
        case   0x1DC5: return "COMBINING_GRAVE_MACRON";
        case   0x1DC6: return "COMBINING_MACRON_GRAVE";
        case   0x1DC7: return "COMBINING_ACUTE_MACRON";
        case   0x1DC8: return "COMBINING_GRAVE_ACUTE_GRAVE";
        case   0x1DC9: return "COMBINING_ACUTE_GRAVE_ACUTE";
        case   0x1DCA: return "COMBINING_LATIN_SMALL_LETTER_R_BELOW";
        case   0x1DCB: return "COMBINING_BREVE_MACRON";
        case   0x1DCC: return "COMBINING_MACRON_BREVE";
        case   0x1DCD: return "COMBINING_DOUBLE_CIRCUMFLEX_ABOVE";
        case   0x1DCE: return "COMBINING_OGONEK_ABOVE";
        case   0x1DCF: return "COMBINING_ZIGZAG_BELOW";
        case   0x1DD0: return "COMBINING_IS_BELOW";
        case   0x1DD1: return "COMBINING_UR_ABOVE";
        case   0x1DD2: return "COMBINING_US_ABOVE";
        case   0x1DD3: return
                "COMBINING_LATIN_SMALL_LETTER_FLATTENED_OPEN_A_ABOVE";
        case   0x1DD4: return "COMBINING_LATIN_SMALL_LETTER_AE";
        case   0x1DD5: return "COMBINING_LATIN_SMALL_LETTER_AO";
        case   0x1DD6: return "COMBINING_LATIN_SMALL_LETTER_AV";
        case   0x1DD7: return "COMBINING_LATIN_SMALL_LETTER_C_CEDILLA";
        case   0x1DD8: return "COMBINING_LATIN_SMALL_LETTER_INSULAR_D";
        case   0x1DD9: return "COMBINING_LATIN_SMALL_LETTER_ETH";
        case   0x1DDA: return "COMBINING_LATIN_SMALL_LETTER_G";
        case   0x1DDB: return "COMBINING_LATIN_LETTER_SMALL_CAPITAL_G";
        case   0x1DDC: return "COMBINING_LATIN_SMALL_LETTER_K";
        case   0x1DDD: return "COMBINING_LATIN_SMALL_LETTER_L";
        case   0x1DDE: return "COMBINING_LATIN_LETTER_SMALL_CAPITAL_L";
        case   0x1DDF: return "COMBINING_LATIN_LETTER_SMALL_CAPITAL_M";
        case   0x1DE0: return "COMBINING_LATIN_SMALL_LETTER_N";
        case   0x1DE1: return "COMBINING_LATIN_LETTER_SMALL_CAPITAL_N";
        case   0x1DE2: return "COMBINING_LATIN_LETTER_SMALL_CAPITAL_R";
        case   0x1DE3: return "COMBINING_LATIN_SMALL_LETTER_R_ROTUNDA";
        case   0x1DE4: return "COMBINING_LATIN_SMALL_LETTER_S";
        case   0x1DE5: return "COMBINING_LATIN_SMALL_LETTER_LONG_S";
        case   0x1DE6: return "COMBINING_LATIN_SMALL_LETTER_Z";
        case   0x1DE7: return "COMBINING_LATIN_SMALL_LETTER_ALPHA";
        case   0x1DE8: return "COMBINING_LATIN_SMALL_LETTER_B";
        case   0x1DE9: return "COMBINING_LATIN_SMALL_LETTER_BETA";
        case   0x1DEA: return "COMBINING_LATIN_SMALL_LETTER_SCHWA";
        case   0x1DEB: return "COMBINING_LATIN_SMALL_LETTER_F";
        case   0x1DEC: return
                "COMBINING_LATIN_SMALL_LETTER_L_WITH_DOUBLE_MIDDLE_TILDE";
        case   0x1DED: return
                "COMBINING_LATIN_SMALL_LETTER_O_WITH_LIGHT_CENTRALIZATION_STROKE0";
        case   0x1DEE: return "COMBINING_LATIN_SMALL_LETTER_P";
        case   0x1DEF: return "COMBINING_LATIN_SMALL_LETTER_ESH";
        case   0x1DF0: return
                "COMBINING_LATIN_SMALL_LETTER_U_WITH_LIGHT_CENTRALIZATION_STROKE";
        case   0x1DF1: return "COMBINING_LATIN_SMALL_LETTER_W";
        case   0x1DF2: return "COMBINING_LATIN_SMALL_LETTER_A_WITH_DIAERESIS";
        case   0x1DF3: return "COMBINING_LATIN_SMALL_LETTER_O_WITH_DIAERESIS";
        case   0x1DF4: return "COMBINING_LATIN_SMALL_LETTER_U_WITH_DIAERESIS";
        case   0x1DF5: return "COMBINING_UP_TACK_ABOVE";
        case   0x1DFC: return "COMBINING_DOUBLE_INVERTED_BREVE_BELOW";
        case   0x1DFD: return "COMBINING_ALMOST_EQUAL_TO_BELOW";
        case   0x1DFE: return "COMBINING_LEFT_ARROWHEAD_ABOVE";
        case   0x1DFF: return
                "COMBINING_RIGHT_ARROWHEAD_AND_DOWN_ARROWHEAD_BELOW";
        case   0x1E00: return "LATIN_CAPITAL_LETTER_A_WITH_RING_BELOW";
        case   0x1E01: return "LATIN_SMALL_LETTER_A_WITH_RING_BELOW";
        case   0x1E02: return "LATIN_CAPITAL_LETTER_B_WITH_DOT_ABOVE";
        case   0x1E03: return "LATIN_SMALL_LETTER_B_WITH_DOT_ABOVE";
        case   0x1E04: return "LATIN_CAPITAL_LETTER_B_WITH_DOT_BELOW";
        case   0x1E05: return "LATIN_SMALL_LETTER_B_WITH_DOT_BELOW";
        case   0x1E06: return "LATIN_CAPITAL_LETTER_B_WITH_LINE_BELOW";
        case   0x1E07: return "LATIN_SMALL_LETTER_B_WITH_LINE_BELOW";
        case   0x1E08: return "LATIN_CAPITAL_LETTER_C_WITH_CEDILLA_AND_ACUTE";
        case   0x1E09: return "LATIN_SMALL_LETTER_C_WITH_CEDILLA_AND_ACUTE";
        case   0x1E0A: return "LATIN_CAPITAL_LETTER_D_WITH_DOT_ABOVE";
        case   0x1E0B: return "LATIN_SMALL_LETTER_D_WITH_DOT_ABOVE";
        case   0x1E0C: return "LATIN_CAPITAL_LETTER_D_WITH_DOT_BELOW";
        case   0x1E0D: return "LATIN_SMALL_LETTER_D_WITH_DOT_BELOW";
        case   0x1E0E: return "LATIN_CAPITAL_LETTER_D_WITH_LINE_BELOW";
        case   0x1E0F: return "LATIN_SMALL_LETTER_D_WITH_LINE_BELOW";
        case   0x1E10: return "LATIN_CAPITAL_LETTER_D_WITH_CEDILLA";
        case   0x1E11: return "LATIN_SMALL_LETTER_D_WITH_CEDILLA";
        case   0x1E12: return "LATIN_CAPITAL_LETTER_D_WITH_CIRCUMFLEX_BELOW";
        case   0x1E13: return "LATIN_SMALL_LETTER_D_WITH_CIRCUMFLEX_BELOW";
        case   0x1E14: return "LATIN_CAPITAL_LETTER_E_WITH_MACRON_AND_GRAVE";
        case   0x1E15: return "LATIN_SMALL_LETTER_E_WITH_MACRON_AND_GRAVE";
        case   0x1E16: return "LATIN_CAPITAL_LETTER_E_WITH_MACRON_AND_ACUTE";
        case   0x1E17: return "LATIN_SMALL_LETTER_E_WITH_MACRON_AND_ACUTE";
        case   0x1E18: return "LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX_BELOW";
        case   0x1E19: return "LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_BELOW";
        case   0x1E1A: return "LATIN_CAPITAL_LETTER_E_WITH_TILDE_BELOW";
        case   0x1E1B: return "LATIN_SMALL_LETTER_E_WITH_TILDE_BELOW";
        case   0x1E1C: return "LATIN_CAPITAL_LETTER_E_WITH_CEDILLA_AND_BREVE";
        case   0x1E1D: return "LATIN_SMALL_LETTER_E_WITH_CEDILLA_AND_BREVE";
        case   0x1E1E: return "LATIN_CAPITAL_LETTER_F_WITH_DOT_ABOVE";
        case   0x1E1F: return "LATIN_SMALL_LETTER_F_WITH_DOT_ABOVE";
        case   0x1E20: return "LATIN_CAPITAL_LETTER_G_WITH_MACRON";
        case   0x1E21: return "LATIN_SMALL_LETTER_G_WITH_MACRON";
        case   0x1E22: return "LATIN_CAPITAL_LETTER_H_WITH_DOT_ABOVE";
        case   0x1E23: return "LATIN_SMALL_LETTER_H_WITH_DOT_ABOVE";
        case   0x1E24: return "LATIN_CAPITAL_LETTER_H_WITH_DOT_BELOW";
        case   0x1E25: return "LATIN_SMALL_LETTER_H_WITH_DOT_BELOW";
        case   0x1E26: return "LATIN_CAPITAL_LETTER_H_WITH_DIAERESIS";
        case   0x1E27: return "LATIN_SMALL_LETTER_H_WITH_DIAERESIS";
        case   0x1E28: return "LATIN_CAPITAL_LETTER_H_WITH_CEDILLA";
        case   0x1E29: return "LATIN_SMALL_LETTER_H_WITH_CEDILLA";
        case   0x1E2A: return "LATIN_CAPITAL_LETTER_H_WITH_BREVE_BELOW";
        case   0x1E2B: return "LATIN_SMALL_LETTER_H_WITH_BREVE_BELOW";
        case   0x1E2C: return "LATIN_CAPITAL_LETTER_I_WITH_TILDE_BELOW";
        case   0x1E2D: return "LATIN_SMALL_LETTER_I_WITH_TILDE_BELOW";
        case   0x1E2E: return
                "LATIN_CAPITAL_LETTER_I_WITH_DIAERESIS_AND_ACUTE";
        case   0x1E2F: return "LATIN_SMALL_LETTER_I_WITH_DIAERESIS_AND_ACUTE";
        case   0x1E30: return "LATIN_CAPITAL_LETTER_K_WITH_ACUTE";
        case   0x1E31: return "LATIN_SMALL_LETTER_K_WITH_ACUTE";
        case   0x1E32: return "LATIN_CAPITAL_LETTER_K_WITH_DOT_BELOW";
        case   0x1E33: return "LATIN_SMALL_LETTER_K_WITH_DOT_BELOW";
        case   0x1E34: return "LATIN_CAPITAL_LETTER_K_WITH_LINE_BELOW";
        case   0x1E35: return "LATIN_SMALL_LETTER_K_WITH_LINE_BELOW";
        case   0x1E36: return "LATIN_CAPITAL_LETTER_L_WITH_DOT_BELOW";
        case   0x1E37: return "LATIN_SMALL_LETTER_L_WITH_DOT_BELOW";
        case   0x1E38: return
                "LATIN_CAPITAL_LETTER_L_WITH_DOT_BELOW_AND_MACRON";
        case   0x1E39: return
                "LATIN_SMALL_LETTER_L_WITH_DOT_BELOW_AND_MACRON";
        case   0x1E3A: return "LATIN_CAPITAL_LETTER_L_WITH_LINE_BELOW";
        case   0x1E3B: return "LATIN_SMALL_LETTER_L_WITH_LINE_BELOW";
        case   0x1E3C: return "LATIN_CAPITAL_LETTER_L_WITH_CIRCUMFLEX_BELOW";
        case   0x1E3D: return "LATIN_SMALL_LETTER_L_WITH_CIRCUMFLEX_BELOW";
        case   0x1E3E: return "LATIN_CAPITAL_LETTER_M_WITH_ACUTE";
        case   0x1E3F: return "LATIN_SMALL_LETTER_M_WITH_ACUTE";
        case   0x1E40: return "LATIN_CAPITAL_LETTER_M_WITH_DOT_ABOVE";
        case   0x1E41: return "LATIN_SMALL_LETTER_M_WITH_DOT_ABOVE";
        case   0x1E42: return "LATIN_CAPITAL_LETTER_M_WITH_DOT_BELOW";
        case   0x1E43: return "LATIN_SMALL_LETTER_M_WITH_DOT_BELOW";
        case   0x1E44: return "LATIN_CAPITAL_LETTER_N_WITH_DOT_ABOVE";
        case   0x1E45: return "LATIN_SMALL_LETTER_N_WITH_DOT_ABOVE";
        case   0x1E46: return "LATIN_CAPITAL_LETTER_N_WITH_DOT_BELOW";
        case   0x1E47: return "LATIN_SMALL_LETTER_N_WITH_DOT_BELOW";
        case   0x1E48: return "LATIN_CAPITAL_LETTER_N_WITH_LINE_BELOW";
        case   0x1E49: return "LATIN_SMALL_LETTER_N_WITH_LINE_BELOW";
        case   0x1E4A: return "LATIN_CAPITAL_LETTER_N_WITH_CIRCUMFLEX_BELOW";
        case   0x1E4B: return "LATIN_SMALL_LETTER_N_WITH_CIRCUMFLEX_BELOW";
        case   0x1E4C: return "LATIN_CAPITAL_LETTER_O_WITH_TILDE_AND_ACUTE";
        case   0x1E4D: return "LATIN_SMALL_LETTER_O_WITH_TILDE_AND_ACUTE";
        case   0x1E4E: return
                "LATIN_CAPITAL_LETTER_O_WITH_TILDE_AND_DIAERESIS";
        case   0x1E4F: return "LATIN_SMALL_LETTER_O_WITH_TILDE_AND_DIAERESIS";
        case   0x1E50: return "LATIN_CAPITAL_LETTER_O_WITH_MACRON_AND_GRAVE";
        case   0x1E51: return "LATIN_SMALL_LETTER_O_WITH_MACRON_AND_GRAVE";
        case   0x1E52: return "LATIN_CAPITAL_LETTER_O_WITH_MACRON_AND_ACUTE";
        case   0x1E53: return "LATIN_SMALL_LETTER_O_WITH_MACRON_AND_ACUTE";
        case   0x1E54: return "LATIN_CAPITAL_LETTER_P_WITH_ACUTE";
        case   0x1E55: return "LATIN_SMALL_LETTER_P_WITH_ACUTE";
        case   0x1E56: return "LATIN_CAPITAL_LETTER_P_WITH_DOT_ABOVE";
        case   0x1E57: return "LATIN_SMALL_LETTER_P_WITH_DOT_ABOVE";
        case   0x1E58: return "LATIN_CAPITAL_LETTER_R_WITH_DOT_ABOVE";
        case   0x1E59: return "LATIN_SMALL_LETTER_R_WITH_DOT_ABOVE";
        case   0x1E5A: return "LATIN_CAPITAL_LETTER_R_WITH_DOT_BELOW";
        case   0x1E5B: return "LATIN_SMALL_LETTER_R_WITH_DOT_BELOW";
        case   0x1E5C: return
                "LATIN_CAPITAL_LETTER_R_WITH_DOT_BELOW_AND_MACRON";
        case   0x1E5D: return
                "LATIN_SMALL_LETTER_R_WITH_DOT_BELOW_AND_MACRON";
        case   0x1E5E: return "LATIN_CAPITAL_LETTER_R_WITH_LINE_BELOW";
        case   0x1E5F: return "LATIN_SMALL_LETTER_R_WITH_LINE_BELOW";
        case   0x1E60: return "LATIN_CAPITAL_LETTER_S_WITH_DOT_ABOVE";
        case   0x1E61: return "LATIN_SMALL_LETTER_S_WITH_DOT_ABOVE";
        case   0x1E62: return "LATIN_CAPITAL_LETTER_S_WITH_DOT_BELOW";
        case   0x1E63: return "LATIN_SMALL_LETTER_S_WITH_DOT_BELOW";
        case   0x1E64: return
                "LATIN_CAPITAL_LETTER_S_WITH_ACUTE_AND_DOT_ABOVE";
        case   0x1E65: return "LATIN_SMALL_LETTER_S_WITH_ACUTE_AND_DOT_ABOVE";
        case   0x1E66: return
                "LATIN_CAPITAL_LETTER_S_WITH_CARON_AND_DOT_ABOVE";
        case   0x1E67: return "LATIN_SMALL_LETTER_S_WITH_CARON_AND_DOT_ABOVE";
        case   0x1E68: return
                "LATIN_CAPITAL_LETTER_S_WITH_DOT_BELOW_AND_DOT_ABOVE";
        case   0x1E69: return
                "LATIN_SMALL_LETTER_S_WITH_DOT_BELOW_AND_DOT_ABOVE";
        case   0x1E6A: return "LATIN_CAPITAL_LETTER_T_WITH_DOT_ABOVE";
        case   0x1E6B: return "LATIN_SMALL_LETTER_T_WITH_DOT_ABOVE";
        case   0x1E6C: return "LATIN_CAPITAL_LETTER_T_WITH_DOT_BELOW";
        case   0x1E6D: return "LATIN_SMALL_LETTER_T_WITH_DOT_BELOW";
        case   0x1E6E: return "LATIN_CAPITAL_LETTER_T_WITH_LINE_BELOW";
        case   0x1E6F: return "LATIN_SMALL_LETTER_T_WITH_LINE_BELOW";
        case   0x1E70: return "LATIN_CAPITAL_LETTER_T_WITH_CIRCUMFLEX_BELOW";
        case   0x1E71: return "LATIN_SMALL_LETTER_T_WITH_CIRCUMFLEX_BELOW";
        case   0x1E72: return "LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS_BELOW";
        case   0x1E73: return "LATIN_SMALL_LETTER_U_WITH_DIAERESIS_BELOW";
        case   0x1E74: return "LATIN_CAPITAL_LETTER_U_WITH_TILDE_BELOW";
        case   0x1E75: return "LATIN_SMALL_LETTER_U_WITH_TILDE_BELOW";
        case   0x1E76: return "LATIN_CAPITAL_LETTER_U_WITH_CIRCUMFLEX_BELOW";
        case   0x1E77: return "LATIN_SMALL_LETTER_U_WITH_CIRCUMFLEX_BELOW";
        case   0x1E78: return "LATIN_CAPITAL_LETTER_U_WITH_TILDE_AND_ACUTE";
        case   0x1E79: return "LATIN_SMALL_LETTER_U_WITH_TILDE_AND_ACUTE";
        case   0x1E7A: return
                "LATIN_CAPITAL_LETTER_U_WITH_MACRON_AND_DIAERESIS";
        case   0x1E7B: return
                "LATIN_SMALL_LETTER_U_WITH_MACRON_AND_DIAERESIS";
        case   0x1E7C: return "LATIN_CAPITAL_LETTER_V_WITH_TILDE";
        case   0x1E7D: return "LATIN_SMALL_LETTER_V_WITH_TILDE";
        case   0x1E7E: return "LATIN_CAPITAL_LETTER_V_WITH_DOT_BELOW";
        case   0x1E7F: return "LATIN_SMALL_LETTER_V_WITH_DOT_BELOW";
        case   0x1E80: return "LATIN_CAPITAL_LETTER_W_WITH_GRAVE";
        case   0x1E81: return "LATIN_SMALL_LETTER_W_WITH_GRAVE";
        case   0x1E82: return "LATIN_CAPITAL_LETTER_W_WITH_ACUTE";
        case   0x1E83: return "LATIN_SMALL_LETTER_W_WITH_ACUTE";
        case   0x1E84: return "LATIN_CAPITAL_LETTER_W_WITH_DIAERESIS";
        case   0x1E85: return "LATIN_SMALL_LETTER_W_WITH_DIAERESIS";
        case   0x1E86: return "LATIN_CAPITAL_LETTER_W_WITH_DOT_ABOVE";
        case   0x1E87: return "LATIN_SMALL_LETTER_W_WITH_DOT_ABOVE";
        case   0x1E88: return "LATIN_CAPITAL_LETTER_W_WITH_DOT_BELOW";
        case   0x1E89: return "LATIN_SMALL_LETTER_W_WITH_DOT_BELOW";
        case   0x1E8A: return "LATIN_CAPITAL_LETTER_X_WITH_DOT_ABOVE";
        case   0x1E8B: return "LATIN_SMALL_LETTER_X_WITH_DOT_ABOVE";
        case   0x1E8C: return "LATIN_CAPITAL_LETTER_X_WITH_DIAERESIS";
        case   0x1E8D: return "LATIN_SMALL_LETTER_X_WITH_DIAERESIS";
        case   0x1E8E: return "LATIN_CAPITAL_LETTER_Y_WITH_DOT_ABOVE";
        case   0x1E8F: return "LATIN_SMALL_LETTER_Y_WITH_DOT_ABOVE";
        case   0x1E90: return "LATIN_CAPITAL_LETTER_Z_WITH_CIRCUMFLEX";
        case   0x1E91: return "LATIN_SMALL_LETTER_Z_WITH_CIRCUMFLEX";
        case   0x1E92: return "LATIN_CAPITAL_LETTER_Z_WITH_DOT_BELOW";
        case   0x1E93: return "LATIN_SMALL_LETTER_Z_WITH_DOT_BELOW";
        case   0x1E94: return "LATIN_CAPITAL_LETTER_Z_WITH_LINE_BELOW";
        case   0x1E95: return "LATIN_SMALL_LETTER_Z_WITH_LINE_BELOW";
        case   0x1E96: return "LATIN_SMALL_LETTER_H_WITH_LINE_BELOW";
        case   0x1E97: return "LATIN_SMALL_LETTER_T_WITH_DIAERESIS";
        case   0x1E98: return "LATIN_SMALL_LETTER_W_WITH_RING_ABOVE";
        case   0x1E99: return "LATIN_SMALL_LETTER_Y_WITH_RING_ABOVE";
        case   0x1E9A: return "LATIN_SMALL_LETTER_A_WITH_RIGHT_HALF_RING";
        case   0x1E9B: return "LATIN_SMALL_LETTER_LONG_S_WITH_DOT_ABOVE";
        case   0x1E9C: return
                "LATIN_SMALL_LETTER_LONG_S_WITH_DIAGONAL_STROKE";
        case   0x1E9D: return "LATIN_SMALL_LETTER_LONG_S_WITH_HIGH_STROKE";
        case   0x1E9E: return "LATIN_CAPITAL_LETTER_SHARP_S";
        case   0x1E9F: return "LATIN_SMALL_LETTER_DELTA";
        case   0x1EA0: return "LATIN_CAPITAL_LETTER_A_WITH_DOT_BELOW";
        case   0x1EA1: return "LATIN_SMALL_LETTER_A_WITH_DOT_BELOW";
        case   0x1EA2: return "LATIN_CAPITAL_LETTER_A_WITH_HOOK_ABOVE";
        case   0x1EA3: return "LATIN_SMALL_LETTER_A_WITH_HOOK_ABOVE";
        case   0x1EA4: return
                "LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX_AND_ACUTE";
        case   0x1EA5: return
                "LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX_AND_ACUTE";
        case   0x1EA6: return
                "LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX_AND_GRAVE";
        case   0x1EA7: return
                "LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX_AND_GRAVE";
        case   0x1EA8: return
                "LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX_AND_HOOK_ABOVE";
        case   0x1EA9: return
                "LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX_AND_HOOK_ABOVE";
        case   0x1EAA: return
                "LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX_AND_TILDE";
        case   0x1EAB: return
                "LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX_AND_TILDE";
        case   0x1EAC: return
                "LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX_AND_DOT_BELOW";
        case   0x1EAD: return
                "LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX_AND_DOT_BELOW";
        case   0x1EAE: return "LATIN_CAPITAL_LETTER_A_WITH_BREVE_AND_ACUTE";
        case   0x1EAF: return "LATIN_SMALL_LETTER_A_WITH_BREVE_AND_ACUTE";
        case   0x1EB0: return "LATIN_CAPITAL_LETTER_A_WITH_BREVE_AND_GRAVE";
        case   0x1EB1: return "LATIN_SMALL_LETTER_A_WITH_BREVE_AND_GRAVE";
        case   0x1EB2: return
                "LATIN_CAPITAL_LETTER_A_WITH_BREVE_AND_HOOK_ABOVE";
        case   0x1EB3: return
                "LATIN_SMALL_LETTER_A_WITH_BREVE_AND_HOOK_ABOVE";
        case   0x1EB4: return "LATIN_CAPITAL_LETTER_A_WITH_BREVE_AND_TILDE";
        case   0x1EB5: return "LATIN_SMALL_LETTER_A_WITH_BREVE_AND_TILDE";
        case   0x1EB6: return
                "LATIN_CAPITAL_LETTER_A_WITH_BREVE_AND_DOT_BELOW";
        case   0x1EB7: return "LATIN_SMALL_LETTER_A_WITH_BREVE_AND_DOT_BELOW";
        case   0x1EB8: return "LATIN_CAPITAL_LETTER_E_WITH_DOT_BELOW";
        case   0x1EB9: return "LATIN_SMALL_LETTER_E_WITH_DOT_BELOW";
        case   0x1EBA: return "LATIN_CAPITAL_LETTER_E_WITH_HOOK_ABOVE";
        case   0x1EBB: return "LATIN_SMALL_LETTER_E_WITH_HOOK_ABOVE";
        case   0x1EBC: return "LATIN_CAPITAL_LETTER_E_WITH_TILDE";
        case   0x1EBD: return "LATIN_SMALL_LETTER_E_WITH_TILDE";
        case   0x1EBE: return
                "LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX_AND_ACUTE";
        case   0x1EBF: return
                "LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_AND_ACUTE";
        case   0x1EC0: return
                "LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX_AND_GRAVE";
        case   0x1EC1: return
                "LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_AND_GRAVE";
        case   0x1EC2: return
                "LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX_AND_HOOK_ABOVE";
        case   0x1EC3: return
                "LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_AND_HOOK_ABOVE";
        case   0x1EC4: return
                "LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX_AND_TILDE";
        case   0x1EC5: return
                "LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_AND_TILDE";
        case   0x1EC6: return
                "LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX_AND_DOT_BELOW";
        case   0x1EC7: return
                "LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_AND_DOT_BELOW";
        case   0x1EC8: return "LATIN_CAPITAL_LETTER_I_WITH_HOOK_ABOVE";
        case   0x1EC9: return "LATIN_SMALL_LETTER_I_WITH_HOOK_ABOVE";
        case   0x1ECA: return "LATIN_CAPITAL_LETTER_I_WITH_DOT_BELOW";
        case   0x1ECB: return "LATIN_SMALL_LETTER_I_WITH_DOT_BELOW";
        default:       return nullptr;
    }
}

static const char *uniname1(int codepoint)
{   switch (codepoint)
    {   case   0x1ECC: return "LATIN_CAPITAL_LETTER_O_WITH_DOT_BELOW";
        case   0x1ECD: return "LATIN_SMALL_LETTER_O_WITH_DOT_BELOW";
        case   0x1ECE: return "LATIN_CAPITAL_LETTER_O_WITH_HOOK_ABOVE";
        case   0x1ECF: return "LATIN_SMALL_LETTER_O_WITH_HOOK_ABOVE";
        case   0x1ED0: return
                "LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX_AND_ACUTE";
        case   0x1ED1: return
                "LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX_AND_ACUTE";
        case   0x1ED2: return
                "LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX_AND_GRAVE";
        case   0x1ED3: return
                "LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX_AND_GRAVE";
        case   0x1ED4: return
                "LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX_AND_HOOK_ABOVE";
        case   0x1ED5: return
                "LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX_AND_HOOK_ABOVE";
        case   0x1ED6: return
                "LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX_AND_TILDE";
        case   0x1ED7: return
                "LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX_AND_TILDE";
        case   0x1ED8: return
                "LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX_AND_DOT_BELOW";
        case   0x1ED9: return
                "LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX_AND_DOT_BELOW";
        case   0x1EDA: return "LATIN_CAPITAL_LETTER_O_WITH_HORN_AND_ACUTE";
        case   0x1EDB: return "LATIN_SMALL_LETTER_O_WITH_HORN_AND_ACUTE";
        case   0x1EDC: return "LATIN_CAPITAL_LETTER_O_WITH_HORN_AND_GRAVE";
        case   0x1EDD: return "LATIN_SMALL_LETTER_O_WITH_HORN_AND_GRAVE";
        case   0x1EDE: return
                "LATIN_CAPITAL_LETTER_O_WITH_HORN_AND_HOOK_ABOVE";
        case   0x1EDF: return "LATIN_SMALL_LETTER_O_WITH_HORN_AND_HOOK_ABOVE";
        case   0x1EE0: return "LATIN_CAPITAL_LETTER_O_WITH_HORN_AND_TILDE";
        case   0x1EE1: return "LATIN_SMALL_LETTER_O_WITH_HORN_AND_TILDE";
        case   0x1EE2: return
                "LATIN_CAPITAL_LETTER_O_WITH_HORN_AND_DOT_BELOW";
        case   0x1EE3: return "LATIN_SMALL_LETTER_O_WITH_HORN_AND_DOT_BELOW";
        case   0x1EE4: return "LATIN_CAPITAL_LETTER_U_WITH_DOT_BELOW";
        case   0x1EE5: return "LATIN_SMALL_LETTER_U_WITH_DOT_BELOW";
        case   0x1EE6: return "LATIN_CAPITAL_LETTER_U_WITH_HOOK_ABOVE";
        case   0x1EE7: return "LATIN_SMALL_LETTER_U_WITH_HOOK_ABOVE";
        case   0x1EE8: return "LATIN_CAPITAL_LETTER_U_WITH_HORN_AND_ACUTE";
        case   0x1EE9: return "LATIN_SMALL_LETTER_U_WITH_HORN_AND_ACUTE";
        case   0x1EEA: return "LATIN_CAPITAL_LETTER_U_WITH_HORN_AND_GRAVE";
        case   0x1EEB: return "LATIN_SMALL_LETTER_U_WITH_HORN_AND_GRAVE";
        case   0x1EEC: return
                "LATIN_CAPITAL_LETTER_U_WITH_HORN_AND_HOOK_ABOVE";
        case   0x1EED: return "LATIN_SMALL_LETTER_U_WITH_HORN_AND_HOOK_ABOVE";
        case   0x1EEE: return "LATIN_CAPITAL_LETTER_U_WITH_HORN_AND_TILDE";
        case   0x1EEF: return "LATIN_SMALL_LETTER_U_WITH_HORN_AND_TILDE";
        case   0x1EF0: return
                "LATIN_CAPITAL_LETTER_U_WITH_HORN_AND_DOT_BELOW";
        case   0x1EF1: return "LATIN_SMALL_LETTER_U_WITH_HORN_AND_DOT_BELOW";
        case   0x1EF2: return "LATIN_CAPITAL_LETTER_Y_WITH_GRAVE";
        case   0x1EF3: return "LATIN_SMALL_LETTER_Y_WITH_GRAVE";
        case   0x1EF4: return "LATIN_CAPITAL_LETTER_Y_WITH_DOT_BELOW";
        case   0x1EF5: return "LATIN_SMALL_LETTER_Y_WITH_DOT_BELOW";
        case   0x1EF6: return "LATIN_CAPITAL_LETTER_Y_WITH_HOOK_ABOVE";
        case   0x1EF7: return "LATIN_SMALL_LETTER_Y_WITH_HOOK_ABOVE";
        case   0x1EF8: return "LATIN_CAPITAL_LETTER_Y_WITH_TILDE";
        case   0x1EF9: return "LATIN_SMALL_LETTER_Y_WITH_TILDE";
        case   0x1EFA: return "LATIN_CAPITAL_LETTER_MIDDLE_WELSH_LL";
        case   0x1EFB: return "LATIN_SMALL_LETTER_MIDDLE_WELSH_LL";
        case   0x1EFC: return "LATIN_CAPITAL_LETTER_MIDDLE_WELSH_V";
        case   0x1EFD: return "LATIN_SMALL_LETTER_MIDDLE_WELSH_V";
        case   0x1EFE: return "LATIN_CAPITAL_LETTER_Y_WITH_LOOP";
        case   0x1EFF: return "LATIN_SMALL_LETTER_Y_WITH_LOOP";
        case   0x1F00: return "GREEK_SMALL_LETTER_ALPHA_WITH_PSILI";
        case   0x1F01: return "GREEK_SMALL_LETTER_ALPHA_WITH_DASIA";
        case   0x1F02: return "GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_VARIA";
        case   0x1F03: return "GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_VARIA";
        case   0x1F04: return "GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_OXIA";
        case   0x1F05: return "GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_OXIA";
        case   0x1F06: return
                "GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_PERISPOMENI";
        case   0x1F07: return
                "GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_PERISPOMENI";
        case   0x1F08: return "GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI";
        case   0x1F09: return "GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA";
        case   0x1F0A: return
                "GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI_AND_VARIA";
        case   0x1F0B: return
                "GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA_AND_VARIA";
        case   0x1F0C: return
                "GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI_AND_OXIA";
        case   0x1F0D: return
                "GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA_AND_OXIA";
        case   0x1F0E: return
                "GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI_AND_PERISPOMENI";
        case   0x1F0F: return
                "GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA_AND_PERISPOMENI";
        case   0x1F10: return "GREEK_SMALL_LETTER_EPSILON_WITH_PSILI";
        case   0x1F11: return "GREEK_SMALL_LETTER_EPSILON_WITH_DASIA";
        case   0x1F12: return
                "GREEK_SMALL_LETTER_EPSILON_WITH_PSILI_AND_VARIA";
        case   0x1F13: return
                "GREEK_SMALL_LETTER_EPSILON_WITH_DASIA_AND_VARIA";
        case   0x1F14: return
                "GREEK_SMALL_LETTER_EPSILON_WITH_PSILI_AND_OXIA";
        case   0x1F15: return
                "GREEK_SMALL_LETTER_EPSILON_WITH_DASIA_AND_OXIA";
        case   0x1F18: return "GREEK_CAPITAL_LETTER_EPSILON_WITH_PSILI";
        case   0x1F19: return "GREEK_CAPITAL_LETTER_EPSILON_WITH_DASIA";
        case   0x1F1A: return
                "GREEK_CAPITAL_LETTER_EPSILON_WITH_PSILI_AND_VARIA";
        case   0x1F1B: return
                "GREEK_CAPITAL_LETTER_EPSILON_WITH_DASIA_AND_VARIA";
        case   0x1F1C: return
                "GREEK_CAPITAL_LETTER_EPSILON_WITH_PSILI_AND_OXIA";
        case   0x1F1D: return
                "GREEK_CAPITAL_LETTER_EPSILON_WITH_DASIA_AND_OXIA";
        case   0x1F20: return "GREEK_SMALL_LETTER_ETA_WITH_PSILI";
        case   0x1F21: return "GREEK_SMALL_LETTER_ETA_WITH_DASIA";
        case   0x1F22: return "GREEK_SMALL_LETTER_ETA_WITH_PSILI_AND_VARIA";
        case   0x1F23: return "GREEK_SMALL_LETTER_ETA_WITH_DASIA_AND_VARIA";
        case   0x1F24: return "GREEK_SMALL_LETTER_ETA_WITH_PSILI_AND_OXIA";
        case   0x1F25: return "GREEK_SMALL_LETTER_ETA_WITH_DASIA_AND_OXIA";
        case   0x1F26: return
                "GREEK_SMALL_LETTER_ETA_WITH_PSILI_AND_PERISPOMENI";
        case   0x1F27: return
                "GREEK_SMALL_LETTER_ETA_WITH_DASIA_AND_PERISPOMENI";
        case   0x1F28: return "GREEK_CAPITAL_LETTER_ETA_WITH_PSILI";
        case   0x1F29: return "GREEK_CAPITAL_LETTER_ETA_WITH_DASIA";
        case   0x1F2A: return "GREEK_CAPITAL_LETTER_ETA_WITH_PSILI_AND_VARIA";
        case   0x1F2B: return "GREEK_CAPITAL_LETTER_ETA_WITH_DASIA_AND_VARIA";
        case   0x1F2C: return "GREEK_CAPITAL_LETTER_ETA_WITH_PSILI_AND_OXIA";
        case   0x1F2D: return "GREEK_CAPITAL_LETTER_ETA_WITH_DASIA_AND_OXIA";
        case   0x1F2E: return
                "GREEK_CAPITAL_LETTER_ETA_WITH_PSILI_AND_PERISPOMENI";
        case   0x1F2F: return
                "GREEK_CAPITAL_LETTER_ETA_WITH_DASIA_AND_PERISPOMENI";
        case   0x1F30: return "GREEK_SMALL_LETTER_IOTA_WITH_PSILI";
        case   0x1F31: return "GREEK_SMALL_LETTER_IOTA_WITH_DASIA";
        case   0x1F32: return "GREEK_SMALL_LETTER_IOTA_WITH_PSILI_AND_VARIA";
        case   0x1F33: return "GREEK_SMALL_LETTER_IOTA_WITH_DASIA_AND_VARIA";
        case   0x1F34: return "GREEK_SMALL_LETTER_IOTA_WITH_PSILI_AND_OXIA";
        case   0x1F35: return "GREEK_SMALL_LETTER_IOTA_WITH_DASIA_AND_OXIA";
        case   0x1F36: return
                "GREEK_SMALL_LETTER_IOTA_WITH_PSILI_AND_PERISPOMENI";
        case   0x1F37: return
                "GREEK_SMALL_LETTER_IOTA_WITH_DASIA_AND_PERISPOMENI";
        case   0x1F38: return "GREEK_CAPITAL_LETTER_IOTA_WITH_PSILI";
        case   0x1F39: return "GREEK_CAPITAL_LETTER_IOTA_WITH_DASIA";
        case   0x1F3A: return
                "GREEK_CAPITAL_LETTER_IOTA_WITH_PSILI_AND_VARIA";
        case   0x1F3B: return
                "GREEK_CAPITAL_LETTER_IOTA_WITH_DASIA_AND_VARIA";
        case   0x1F3C: return "GREEK_CAPITAL_LETTER_IOTA_WITH_PSILI_AND_OXIA";
        case   0x1F3D: return "GREEK_CAPITAL_LETTER_IOTA_WITH_DASIA_AND_OXIA";
        case   0x1F3E: return
                "GREEK_CAPITAL_LETTER_IOTA_WITH_PSILI_AND_PERISPOMENI";
        case   0x1F3F: return
                "GREEK_CAPITAL_LETTER_IOTA_WITH_DASIA_AND_PERISPOMENI";
        case   0x1F40: return "GREEK_SMALL_LETTER_OMICRON_WITH_PSILI";
        case   0x1F41: return "GREEK_SMALL_LETTER_OMICRON_WITH_DASIA";
        case   0x1F42: return
                "GREEK_SMALL_LETTER_OMICRON_WITH_PSILI_AND_VARIA";
        case   0x1F43: return
                "GREEK_SMALL_LETTER_OMICRON_WITH_DASIA_AND_VARIA";
        case   0x1F44: return
                "GREEK_SMALL_LETTER_OMICRON_WITH_PSILI_AND_OXIA";
        case   0x1F45: return
                "GREEK_SMALL_LETTER_OMICRON_WITH_DASIA_AND_OXIA";
        case   0x1F48: return "GREEK_CAPITAL_LETTER_OMICRON_WITH_PSILI";
        case   0x1F49: return "GREEK_CAPITAL_LETTER_OMICRON_WITH_DASIA";
        case   0x1F4A: return
                "GREEK_CAPITAL_LETTER_OMICRON_WITH_PSILI_AND_VARIA";
        case   0x1F4B: return
                "GREEK_CAPITAL_LETTER_OMICRON_WITH_DASIA_AND_VARIA";
        case   0x1F4C: return
                "GREEK_CAPITAL_LETTER_OMICRON_WITH_PSILI_AND_OXIA";
        case   0x1F4D: return
                "GREEK_CAPITAL_LETTER_OMICRON_WITH_DASIA_AND_OXIA";
        case   0x1F50: return "GREEK_SMALL_LETTER_UPSILON_WITH_PSILI";
        case   0x1F51: return "GREEK_SMALL_LETTER_UPSILON_WITH_DASIA";
        case   0x1F52: return
                "GREEK_SMALL_LETTER_UPSILON_WITH_PSILI_AND_VARIA";
        case   0x1F53: return
                "GREEK_SMALL_LETTER_UPSILON_WITH_DASIA_AND_VARIA";
        case   0x1F54: return
                "GREEK_SMALL_LETTER_UPSILON_WITH_PSILI_AND_OXIA";
        case   0x1F55: return
                "GREEK_SMALL_LETTER_UPSILON_WITH_DASIA_AND_OXIA";
        case   0x1F56: return
                "GREEK_SMALL_LETTER_UPSILON_WITH_PSILI_AND_PERISPOMENI";
        case   0x1F57: return
                "GREEK_SMALL_LETTER_UPSILON_WITH_DASIA_AND_PERISPOMENI";
        case   0x1F59: return "GREEK_CAPITAL_LETTER_UPSILON_WITH_DASIA";
        case   0x1F5B: return
                "GREEK_CAPITAL_LETTER_UPSILON_WITH_DASIA_AND_VARIA";
        case   0x1F5D: return
                "GREEK_CAPITAL_LETTER_UPSILON_WITH_DASIA_AND_OXIA";
        case   0x1F5F: return
                "GREEK_CAPITAL_LETTER_UPSILON_WITH_DASIA_AND_PERISPOMENI";
        case   0x1F60: return "GREEK_SMALL_LETTER_OMEGA_WITH_PSILI";
        case   0x1F61: return "GREEK_SMALL_LETTER_OMEGA_WITH_DASIA";
        case   0x1F62: return "GREEK_SMALL_LETTER_OMEGA_WITH_PSILI_AND_VARIA";
        case   0x1F63: return "GREEK_SMALL_LETTER_OMEGA_WITH_DASIA_AND_VARIA";
        case   0x1F64: return "GREEK_SMALL_LETTER_OMEGA_WITH_PSILI_AND_OXIA";
        case   0x1F65: return "GREEK_SMALL_LETTER_OMEGA_WITH_DASIA_AND_OXIA";
        case   0x1F66: return
                "GREEK_SMALL_LETTER_OMEGA_WITH_PSILI_AND_PERISPOMENI";
        case   0x1F67: return
                "GREEK_SMALL_LETTER_OMEGA_WITH_DASIA_AND_PERISPOMENI";
        case   0x1F68: return "GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI";
        case   0x1F69: return "GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA";
        case   0x1F6A: return
                "GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI_AND_VARIA";
        case   0x1F6B: return
                "GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA_AND_VARIA";
        case   0x1F6C: return
                "GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI_AND_OXIA";
        case   0x1F6D: return
                "GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA_AND_OXIA";
        case   0x1F6E: return
                "GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI_AND_PERISPOMENI";
        case   0x1F6F: return
                "GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA_AND_PERISPOMENI";
        case   0x1F70: return "GREEK_SMALL_LETTER_ALPHA_WITH_VARIA";
        case   0x1F71: return "GREEK_SMALL_LETTER_ALPHA_WITH_OXIA";
        case   0x1F72: return "GREEK_SMALL_LETTER_EPSILON_WITH_VARIA";
        case   0x1F73: return "GREEK_SMALL_LETTER_EPSILON_WITH_OXIA";
        case   0x1F74: return "GREEK_SMALL_LETTER_ETA_WITH_VARIA";
        case   0x1F75: return "GREEK_SMALL_LETTER_ETA_WITH_OXIA";
        case   0x1F76: return "GREEK_SMALL_LETTER_IOTA_WITH_VARIA";
        case   0x1F77: return "GREEK_SMALL_LETTER_IOTA_WITH_OXIA";
        case   0x1F78: return "GREEK_SMALL_LETTER_OMICRON_WITH_VARIA";
        case   0x1F79: return "GREEK_SMALL_LETTER_OMICRON_WITH_OXIA";
        case   0x1F7A: return "GREEK_SMALL_LETTER_UPSILON_WITH_VARIA";
        case   0x1F7B: return "GREEK_SMALL_LETTER_UPSILON_WITH_OXIA";
        case   0x1F7C: return "GREEK_SMALL_LETTER_OMEGA_WITH_VARIA";
        case   0x1F7D: return "GREEK_SMALL_LETTER_OMEGA_WITH_OXIA";
        case   0x1F80: return
                "GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_YPOGEGRAMMENI";
        case   0x1F81: return
                "GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_YPOGEGRAMMENI";
        case   0x1F82: return
                "GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_VARIA_AND_YPOGEGRAMMENI";
        case   0x1F83: return
                "GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_VARIA_AND_YPOGEGRAMMENI";
        case   0x1F84: return
                "GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_OXIA_AND_YPOGEGRAMMENI";
        case   0x1F85: return
                "GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_OXIA_AND_YPOGEGRAMMENI";
        case   0x1F86: return
                "GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_PERISPOMENI_AND_YPOGEGRAMMENI";
        case   0x1F87: return
                "GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_PERISPOMENI_AND_YPOGEGRAMMENI";
        case   0x1F88: return
                "GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI_AND_PROSGEGRAMMENI";
        case   0x1F89: return
                "GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA_AND_PROSGEGRAMMENI";
        case   0x1F8A: return
                "GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI_AND_VARIA_AND_PROSGEGRAMMENI";
        case   0x1F8B: return
                "GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA_AND_VARIA_AND_PROSGEGRAMMENI";
        case   0x1F8C: return
                "GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI_AND_OXIA_AND_PROSGEGRAMMENI";
        case   0x1F8D: return
                "GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA_AND_OXIA_AND_PROSGEGRAMMENI";
        case   0x1F8E: return
                "GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI_AND_PERISPOMENI_AND_PROSGEGRAMMENI";
        case   0x1F8F: return
                "GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA_AND_PERISPOMENI_AND_PROSGEGRAMMENI";
        case   0x1F90: return
                "GREEK_SMALL_LETTER_ETA_WITH_PSILI_AND_YPOGEGRAMMENI";
        case   0x1F91: return
                "GREEK_SMALL_LETTER_ETA_WITH_DASIA_AND_YPOGEGRAMMENI";
        case   0x1F92: return
                "GREEK_SMALL_LETTER_ETA_WITH_PSILI_AND_VARIA_AND_YPOGEGRAMMENI";
        case   0x1F93: return
                "GREEK_SMALL_LETTER_ETA_WITH_DASIA_AND_VARIA_AND_YPOGEGRAMMENI";
        case   0x1F94: return
                "GREEK_SMALL_LETTER_ETA_WITH_PSILI_AND_OXIA_AND_YPOGEGRAMMENI";
        case   0x1F95: return
                "GREEK_SMALL_LETTER_ETA_WITH_DASIA_AND_OXIA_AND_YPOGEGRAMMENI";
        case   0x1F96: return
                "GREEK_SMALL_LETTER_ETA_WITH_PSILI_AND_PERISPOMENI_AND_YPOGEGRAMMENI";
        case   0x1F97: return
                "GREEK_SMALL_LETTER_ETA_WITH_DASIA_AND_PERISPOMENI_AND_YPOGEGRAMMENI";
        case   0x1F98: return
                "GREEK_CAPITAL_LETTER_ETA_WITH_PSILI_AND_PROSGEGRAMMENI";
        case   0x1F99: return
                "GREEK_CAPITAL_LETTER_ETA_WITH_DASIA_AND_PROSGEGRAMMENI";
        case   0x1F9A: return
                "GREEK_CAPITAL_LETTER_ETA_WITH_PSILI_AND_VARIA_AND_PROSGEGRAMMENI";
        case   0x1F9B: return
                "GREEK_CAPITAL_LETTER_ETA_WITH_DASIA_AND_VARIA_AND_PROSGEGRAMMENI";
        case   0x1F9C: return
                "GREEK_CAPITAL_LETTER_ETA_WITH_PSILI_AND_OXIA_AND_PROSGEGRAMMENI";
        case   0x1F9D: return
                "GREEK_CAPITAL_LETTER_ETA_WITH_DASIA_AND_OXIA_AND_PROSGEGRAMMENI";
        case   0x1F9E: return
                "GREEK_CAPITAL_LETTER_ETA_WITH_PSILI_AND_PERISPOMENI_AND_PROSGEGRAMMENI";
        case   0x1F9F: return
                "GREEK_CAPITAL_LETTER_ETA_WITH_DASIA_AND_PERISPOMENI_AND_PROSGEGRAMMENI";
        case   0x1FA0: return
                "GREEK_SMALL_LETTER_OMEGA_WITH_PSILI_AND_YPOGEGRAMMENI";
        case   0x1FA1: return
                "GREEK_SMALL_LETTER_OMEGA_WITH_DASIA_AND_YPOGEGRAMMENI";
        case   0x1FA2: return
                "GREEK_SMALL_LETTER_OMEGA_WITH_PSILI_AND_VARIA_AND_YPOGEGRAMMENI";
        case   0x1FA3: return
                "GREEK_SMALL_LETTER_OMEGA_WITH_DASIA_AND_VARIA_AND_YPOGEGRAMMENI";
        case   0x1FA4: return
                "GREEK_SMALL_LETTER_OMEGA_WITH_PSILI_AND_OXIA_AND_YPOGEGRAMMENI";
        case   0x1FA5: return
                "GREEK_SMALL_LETTER_OMEGA_WITH_DASIA_AND_OXIA_AND_YPOGEGRAMMENI";
        case   0x1FA6: return
                "GREEK_SMALL_LETTER_OMEGA_WITH_PSILI_AND_PERISPOMENI_AND_YPOGEGRAMMENI";
        case   0x1FA7: return
                "GREEK_SMALL_LETTER_OMEGA_WITH_DASIA_AND_PERISPOMENI_AND_YPOGEGRAMMENI";
        case   0x1FA8: return
                "GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI_AND_PROSGEGRAMMENI";
        case   0x1FA9: return
                "GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA_AND_PROSGEGRAMMENI";
        case   0x1FAA: return
                "GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI_AND_VARIA_AND_PROSGEGRAMMENI";
        case   0x1FAB: return
                "GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA_AND_VARIA_AND_PROSGEGRAMMENI";
        case   0x1FAC: return
                "GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI_AND_OXIA_AND_PROSGEGRAMMENI";
        case   0x1FAD: return
                "GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA_AND_OXIA_AND_PROSGEGRAMMENI";
        case   0x1FAE: return
                "GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI_AND_PERISPOMENI_AND_PROSGEGRAMMENI";
        case   0x1FAF: return
                "GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA_AND_PERISPOMENI_AND_PROSGEGRAMMENI";
        case   0x1FB0: return "GREEK_SMALL_LETTER_ALPHA_WITH_VRACHY";
        case   0x1FB1: return "GREEK_SMALL_LETTER_ALPHA_WITH_MACRON";
        case   0x1FB2: return
                "GREEK_SMALL_LETTER_ALPHA_WITH_VARIA_AND_YPOGEGRAMMENI";
        case   0x1FB3: return "GREEK_SMALL_LETTER_ALPHA_WITH_YPOGEGRAMMENI";
        case   0x1FB4: return
                "GREEK_SMALL_LETTER_ALPHA_WITH_OXIA_AND_YPOGEGRAMMENI";
        case   0x1FB6: return "GREEK_SMALL_LETTER_ALPHA_WITH_PERISPOMENI";
        case   0x1FB7: return
                "GREEK_SMALL_LETTER_ALPHA_WITH_PERISPOMENI_AND_YPOGEGRAMMENI";
        case   0x1FB8: return "GREEK_CAPITAL_LETTER_ALPHA_WITH_VRACHY";
        case   0x1FB9: return "GREEK_CAPITAL_LETTER_ALPHA_WITH_MACRON";
        case   0x1FBA: return "GREEK_CAPITAL_LETTER_ALPHA_WITH_VARIA";
        case   0x1FBB: return "GREEK_CAPITAL_LETTER_ALPHA_WITH_OXIA";
        case   0x1FBC: return
                "GREEK_CAPITAL_LETTER_ALPHA_WITH_PROSGEGRAMMENI";
        case   0x1FBD: return "GREEK_KORONIS";
        case   0x1FBE: return "GREEK_PROSGEGRAMMENI";
        case   0x1FBF: return "GREEK_PSILI";
        case   0x1FC0: return "GREEK_PERISPOMENI";
        case   0x1FC1: return "GREEK_DIALYTIKA_AND_PERISPOMENI";
        case   0x1FC2: return
                "GREEK_SMALL_LETTER_ETA_WITH_VARIA_AND_YPOGEGRAMMENI";
        case   0x1FC3: return "GREEK_SMALL_LETTER_ETA_WITH_YPOGEGRAMMENI";
        case   0x1FC4: return
                "GREEK_SMALL_LETTER_ETA_WITH_OXIA_AND_YPOGEGRAMMENI";
        case   0x1FC6: return "GREEK_SMALL_LETTER_ETA_WITH_PERISPOMENI";
        case   0x1FC7: return
                "GREEK_SMALL_LETTER_ETA_WITH_PERISPOMENI_AND_YPOGEGRAMMENI";
        case   0x1FC8: return "GREEK_CAPITAL_LETTER_EPSILON_WITH_VARIA";
        case   0x1FC9: return "GREEK_CAPITAL_LETTER_EPSILON_WITH_OXIA";
        case   0x1FCA: return "GREEK_CAPITAL_LETTER_ETA_WITH_VARIA";
        case   0x1FCB: return "GREEK_CAPITAL_LETTER_ETA_WITH_OXIA";
        case   0x1FCC: return "GREEK_CAPITAL_LETTER_ETA_WITH_PROSGEGRAMMENI";
        case   0x1FCD: return "GREEK_PSILI_AND_VARIA";
        case   0x1FCE: return "GREEK_PSILI_AND_OXIA";
        case   0x1FCF: return "GREEK_PSILI_AND_PERISPOMENI";
        case   0x1FD0: return "GREEK_SMALL_LETTER_IOTA_WITH_VRACHY";
        case   0x1FD1: return "GREEK_SMALL_LETTER_IOTA_WITH_MACRON";
        case   0x1FD2: return
                "GREEK_SMALL_LETTER_IOTA_WITH_DIALYTIKA_AND_VARIA";
        case   0x1FD3: return
                "GREEK_SMALL_LETTER_IOTA_WITH_DIALYTIKA_AND_OXIA";
        case   0x1FD6: return "GREEK_SMALL_LETTER_IOTA_WITH_PERISPOMENI";
        case   0x1FD7: return
                "GREEK_SMALL_LETTER_IOTA_WITH_DIALYTIKA_AND_PERISPOMENI";
        case   0x1FD8: return "GREEK_CAPITAL_LETTER_IOTA_WITH_VRACHY";
        case   0x1FD9: return "GREEK_CAPITAL_LETTER_IOTA_WITH_MACRON";
        case   0x1FDA: return "GREEK_CAPITAL_LETTER_IOTA_WITH_VARIA";
        case   0x1FDB: return "GREEK_CAPITAL_LETTER_IOTA_WITH_OXIA";
        case   0x1FDD: return "GREEK_DASIA_AND_VARIA";
        case   0x1FDE: return "GREEK_DASIA_AND_OXIA";
        case   0x1FDF: return "GREEK_DASIA_AND_PERISPOMENI";
        case   0x1FE0: return "GREEK_SMALL_LETTER_UPSILON_WITH_VRACHY";
        case   0x1FE1: return "GREEK_SMALL_LETTER_UPSILON_WITH_MACRON";
        case   0x1FE2: return
                "GREEK_SMALL_LETTER_UPSILON_WITH_DIALYTIKA_AND_VARIA";
        case   0x1FE3: return
                "GREEK_SMALL_LETTER_UPSILON_WITH_DIALYTIKA_AND_OXIA";
        case   0x1FE4: return "GREEK_SMALL_LETTER_RHO_WITH_PSILI";
        case   0x1FE5: return "GREEK_SMALL_LETTER_RHO_WITH_DASIA";
        case   0x1FE6: return "GREEK_SMALL_LETTER_UPSILON_WITH_PERISPOMENI";
        case   0x1FE7: return
                "GREEK_SMALL_LETTER_UPSILON_WITH_DIALYTIKA_AND_PERISPOMENI";
        case   0x1FE8: return "GREEK_CAPITAL_LETTER_UPSILON_WITH_VRACHY";
        case   0x1FE9: return "GREEK_CAPITAL_LETTER_UPSILON_WITH_MACRON";
        case   0x1FEA: return "GREEK_CAPITAL_LETTER_UPSILON_WITH_VARIA";
        case   0x1FEB: return "GREEK_CAPITAL_LETTER_UPSILON_WITH_OXIA";
        case   0x1FEC: return "GREEK_CAPITAL_LETTER_RHO_WITH_DASIA";
        case   0x1FED: return "GREEK_DIALYTIKA_AND_VARIA";
        case   0x1FEE: return "GREEK_DIALYTIKA_AND_OXIA";
        case   0x1FEF: return "GREEK_VARIA";
        case   0x1FF2: return
                "GREEK_SMALL_LETTER_OMEGA_WITH_VARIA_AND_YPOGEGRAMMENI";
        case   0x1FF3: return "GREEK_SMALL_LETTER_OMEGA_WITH_YPOGEGRAMMENI";
        case   0x1FF4: return
                "GREEK_SMALL_LETTER_OMEGA_WITH_OXIA_AND_YPOGEGRAMMENI";
        case   0x1FF6: return "GREEK_SMALL_LETTER_OMEGA_WITH_PERISPOMENI";
        case   0x1FF7: return
                "GREEK_SMALL_LETTER_OMEGA_WITH_PERISPOMENI_AND_YPOGEGRAMMENI";
        case   0x1FF8: return "GREEK_CAPITAL_LETTER_OMICRON_WITH_VARIA";
        case   0x1FF9: return "GREEK_CAPITAL_LETTER_OMICRON_WITH_OXIA";
        case   0x1FFA: return "GREEK_CAPITAL_LETTER_OMEGA_WITH_VARIA";
        case   0x1FFB: return "GREEK_CAPITAL_LETTER_OMEGA_WITH_OXIA";
        case   0x1FFC: return
                "GREEK_CAPITAL_LETTER_OMEGA_WITH_PROSGEGRAMMENI";
        case   0x1FFD: return "GREEK_OXIA";
        case   0x1FFE: return "GREEK_DASIA";
        case   0x2000: return "EN_QUAD";
        case   0x2001: return "EM_QUAD";
        case   0x2002: return "EN_SPACE";
        case   0x2003: return "EM_SPACE";
        case   0x2004: return "THREE_PER_EM_SPACE";
        case   0x2005: return "FOUR_PER_EM_SPACE";
        case   0x2006: return "SIX_PER_EM_SPACE";
        case   0x2007: return "FIGURE_SPACE";
        case   0x2008: return "PUNCTUATION_SPACE";
        case   0x2009: return "THIN_SPACE";
        case   0x200A: return "HAIR_SPACE";
        case   0x200B: return "ZERO_WIDTH_SPACE";
        case   0x200C: return "ZERO_WIDTH_NON_JOINER";
        case   0x200D: return "ZERO_WIDTH_JOINER";
        case   0x200E: return "LEFT_TO_RIGHT_MARK";
        case   0x200F: return "RIGHT_TO_LEFT_MARK";
        case   0x2010: return "HYPHEN";
        case   0x2011: return "NON_BREAKING_HYPHEN";
        case   0x2012: return "FIGURE_DASH";
        case   0x2013: return "EN_DASH";
        case   0x2014: return "EM_DASH";
        case   0x2015: return "HORIZONTAL_BAR";
        case   0x2016-2017: return "DOUBLE_VERTICAL_LINE";
        case   0x2016-2017: return "DOUBLE_LOW_LINE";
        case   0x2018: return "LEFT_SINGLE_QUOTATION_MARK";
        case   0x2021: return "RIGHT_SINGLE_QUOTATION_MARK";
        case   0x201A: return "SINGLE_LOW_9_QUOTATION_MARK";
        case   0x201B: return "SINGLE_HIGH_REVERSED_9_QUOTATION_MARK";
        case   0x201C: return "LEFT_DOUBLE_QUOTATION_MARK";
        case   0x201D: return "RIGHT_DOUBLE_QUOTATION_MARK";
        case   0x201E: return "DOUBLE_LOW_9_QUOTATION_MARK";
        case   0x201F: return "DOUBLE_HIGH_REVERSED_9_QUOTATION_MARK";
        case   0x2021: return "DAGGER";
        case   0x2021: return "DOUBLE_DAGGER";
        case   0x2022: return "BULLET";
        case   0x2023: return "TRIANGULAR_BULLET";
        case   0x2024: return "ONE_DOT_LEADER";
        case   0x2025: return "TWO_DOT_LEADER";
        case   0x2026: return "HORIZONTAL_ELLIPSIS";
        case   0x2027: return "HYPHENATION_POINT";
        case   0x2028: return "LINE_SEPARATOR";
        case   0x2029: return "PARAGRAPH_SEPARATOR";
        case   0x202A: return "LEFT_TO_RIGHT_EMBEDDING";
        case   0x202B: return "RIGHT_TO_LEFT_EMBEDDING";
        case   0x202C: return "POP_DIRECTIONAL_FORMATTING";
        case   0x202D: return "LEFT_TO_RIGHT_OVERRIDE";
        case   0x202E: return "RIGHT_TO_LEFT_OVERRIDE";
        case   0x202F: return "NARROW_NO_BREAK_SPACE";
        case   0x2030: return "PER_MILLE_SIGN";
        case   0x2031: return "PER_TEN_THOUSAND_SIGN";
        case   0x2032: return "PRIME";
        case   0x2033: return "DOUBLE_PRIME";
        case   0x2034: return "TRIPLE_PRIME";
        case   0x2035: return "REVERSED_PRIME";
        case   0x2036: return "REVERSED_DOUBLE_PRIME";
        case   0x2037: return "REVERSED_TRIPLE_PRIME";
        case   0x2038: return "CARET";
        case   0x2039: return "SINGLE_LEFT_POINTING_ANGLE_QUOTATION_MARK";
        case   0x203A: return "SINGLE_RIGHT_POINTING_ANGLE_QUOTATION_MARK";
        case   0x203B: return "REFERENCE_MARK";
        case   0x203C: return "DOUBLE_EXCLAMATION_MARK";
        case   0x203D: return "INTERROBANG";
        case   0x203E: return "OVERLINE";
        case   0x203F: return "UNDERTIE";
        case   0x2040: return "CHARACTER_TIE";
        case   0x2041: return "CARET_INSERTION_POINT";
        case   0x2042: return "ASTERISM";
        case   0x2043: return "HYPHEN_BULLET";
        case   0x2044: return "FRACTION_SLASH";
        case   0x2045: return "LEFT_SQUARE_BRACKET_WITH_QUILL";
        case   0x2046: return "RIGHT_SQUARE_BRACKET_WITH_QUILL";
        case   0x2047: return "DOUBLE_QUESTION_MARK";
        case   0x2048: return "QUESTION_EXCLAMATION_MARK";
        case   0x2049: return "EXCLAMATION_QUESTION_MARK";
        case   0x204A: return "TIRONIAN_SIGN_ET";
        case   0x204B: return "REVERSED_PILCROW_SIGN";
        case   0x204C: return "BLACK_LEFTWARDS_BULLET";
        case   0x204D: return "BLACK_RIGHTWARDS_BULLET";
        case   0x204E: return "LOW_ASTERISK";
        case   0x204F: return "REVERSED_SEMICOLON";
        case   0x2050: return "CLOSE_UP";
        case   0x2051: return "TWO_ASTERISKS_ALIGNED_VERTICALLY";
        case   0x2052: return "COMMERCIAL_MINUS_SIGN";
        case   0x2053: return "SWUNG_DASH";
        case   0x2054: return "INVERTED_UNDERTIE";
        case   0x2055: return "FLOWER_PUNCTUATION_MARK";
        case   0x2056: return "THREE_DOT_PUNCTUATION";
        case   0x2057: return "QUADRUPLE_PRIME";
        case   0x2058: return "FOUR_DOT_PUNCTUATION";
        case   0x2059: return "FIVE_DOT_PUNCTUATION";
        case   0x205A: return "TWO_DOT_PUNCTUATION";
        case   0x205B: return "FOUR_DOT_MARK";
        case   0x205C: return "DOTTED_CROSS";
        case   0x205D: return "TRICOLON";
        case   0x205E: return "VERTICAL_FOUR_DOTS";
        case   0x205F: return "MEDIUM_MATHEMATICAL_SPACE";
        case   0x2060: return "WORD_JOINER";
        case   0x2061: return "FUNCTION_APPLICATION";
        case   0x2062: return "INVISIBLE_TIMES";
        case   0x2063: return "INVISIBLE_SEPARATOR";
        case   0x2064: return "INVISIBLE_PLUS";
        case   0x2066: return "LEFT_TO_RIGHT_ISOLATE";
        case   0x2067: return "RIGHT_TO_LEFT_ISOLATE";
        case   0x2068: return "FIRST_STRONG_ISOLATE";
        case   0x2069: return "POP_DIRECTIONAL_ISOLATE";
        case   0x206A: return "INHIBIT_SYMMETRIC_SWAPPING";
        case   0x206B: return "ACTIVATE_SYMMETRIC_SWAPPING";
        case   0x206C: return "INHIBIT_ARABIC_FORM_SHAPING";
        case   0x206D: return "ACTIVATE_ARABIC_FORM_SHAPING";
        case   0x206E: return "NATIONAL_DIGIT_SHAPES";
        case   0x206F: return "NOMINAL_DIGIT_SHAPES";
        case   0x2070: return "SUPERSCRIPT_ZERO";
        case   0x2071: return "SUPERSCRIPT_LATIN_SMALL_LETTER_I";
        case   0x2074: return "SUPERSCRIPT_FOUR";
        case   0x2075: return "SUPERSCRIPT_FIVE";
        case   0x2076: return "SUPERSCRIPT_SIX";
        case   0x2077: return "SUPERSCRIPT_SEVEN";
        case   0x2078: return "SUPERSCRIPT_EIGHT";
        case   0x2079: return "SUPERSCRIPT_NINE";
        case   0x207A: return "SUPERSCRIPT_PLUS_SIGN";
        case   0x207B: return "SUPERSCRIPT_MINUS";
        case   0x207C: return "SUPERSCRIPT_EQUALS_SIGN";
        case   0x207D: return "SUPERSCRIPT_LEFT_PARENTHESIS";
        case   0x207E: return "SUPERSCRIPT_RIGHT_PARENTHESIS";
        case   0x207F: return "SUPERSCRIPT_LATIN_SMALL_LETTER_N";
        case   0x2080: return "SUBSCRIPT_ZERO";
        case   0x2081: return "SUBSCRIPT_ONE";
        case   0x2082: return "SUBSCRIPT_TWO";
        case   0x2083: return "SUBSCRIPT_THREE";
        case   0x2084: return "SUBSCRIPT_FOUR";
        case   0x2085: return "SUBSCRIPT_FIVE";
        case   0x2086: return "SUBSCRIPT_SIX";
        case   0x2087: return "SUBSCRIPT_SEVEN";
        case   0x2088: return "SUBSCRIPT_EIGHT";
        case   0x2089: return "SUBSCRIPT_NINE";
        case   0x208A: return "SUBSCRIPT_PLUS_SIGN";
        case   0x208B: return "SUBSCRIPT_MINUS";
        case   0x208C: return "SUBSCRIPT_EQUALS_SIGN";
        case   0x208D: return "SUBSCRIPT_LEFT_PARENTHESIS";
        case   0x208E: return "SUBSCRIPT_RIGHT_PARENTHESIS";
        case   0x2090: return "LATIN_SUBSCRIPT_SMALL_LETTER_A";
        case   0x2091: return "LATIN_SUBSCRIPT_SMALL_LETTER_E";
        case   0x2092: return "LATIN_SUBSCRIPT_SMALL_LETTER_O";
        case   0x2093: return "LATIN_SUBSCRIPT_SMALL_LETTER_X";
        case   0x2094: return "LATIN_SUBSCRIPT_SMALL_LETTER_SCHWA";
        case   0x2095: return "LATIN_SUBSCRIPT_SMALL_LETTER_H";
        case   0x2096: return "LATIN_SUBSCRIPT_SMALL_LETTER_K";
        case   0x2097: return "LATIN_SUBSCRIPT_SMALL_LETTER_L";
        case   0x2098: return "LATIN_SUBSCRIPT_SMALL_LETTER_M";
        case   0x2099: return "LATIN_SUBSCRIPT_SMALL_LETTER_N";
        case   0x209A: return "LATIN_SUBSCRIPT_SMALL_LETTER_P";
        case   0x209B: return "LATIN_SUBSCRIPT_SMALL_LETTER_S";
        case   0x209C: return "LATIN_SUBSCRIPT_SMALL_LETTER_T";
        case   0x20A0: return "EURO_CURRENCY_SIGN";
        case   0x20A1: return "COLON_SIGN";
        case   0x20A2: return "CRUZEIRO_SIGN";
        case   0x20A3: return "FRENCH_FRANC_SIGN";
        case   0x20A4: return "LIRA_SIGN";
        case   0x20A5: return "MILL_SIGN";
        case   0x20A6: return "NAIRA_SIGN";
        case   0x20A7: return "PESETA_SIGN";
        case   0x20A8: return "RUPEE_SIGN";
        case   0x20A9: return "WON_SIGN";
        case   0x20AA: return "NEW_SHEQEL_SIGN";
        case   0x20AB: return "DONG_SIGN";
        case   0x20AC: return "EURO_SIGN";
        case   0x20AD: return "KIP_SIGN";
        case   0x20AE: return "TUGRIK_SIGN";
        case   0x20AF: return "DRACHMA_SIGN";
        case   0x20B0: return "GERMAN_PENNY_SIGN";
        case   0x20B1: return "PESO_SIGN";
        case   0x20B2: return "GUARANI_SIGN";
        case   0x20B3: return "AUSTRAL_SIGN";
        case   0x20B4: return "HRYVNIA_SIGN";
        case   0x20B5: return "CEDI_SIGN";
        case   0x20B6: return "LIVRE_TOURNOIS_SIGN";
        case   0x20B7: return "SPESMILO_SIGN";
        case   0x20B8: return "TENGE_SIGN";
        case   0x20B9: return "INDIAN_RUPEE_SIGN";
        case   0x20BA: return "TURKISH_LIRA_SIGN";
        case   0x20BB: return "NORDIC_MARK_SIGN";
        case   0x20BC: return "MANAT_SIGN";
        case   0x20BD: return "RUBLE_SIGN";
        case   0x20D0: return "COMBINING_LEFT_HARPOON_ABOVE";
        case   0x20D1: return "COMBINING_RIGHT_HARPOON_ABOVE";
        case   0x20D2: return "COMBINING_LONG_VERTICAL_LINE_OVERLAY";
        case   0x20D3: return "COMBINING_SHORT_VERTICAL_LINE_OVERLAY";
        case   0x20D4: return "COMBINING_ANTICLOCKWISE_ARROW_ABOVE";
        case   0x20D5: return "COMBINING_CLOCKWISE_ARROW_ABOVE";
        case   0x20D6: return "COMBINING_LEFT_ARROW_ABOVE";
        case   0x20D7: return "COMBINING_RIGHT_ARROW_ABOVE";
        case   0x20D8: return "COMBINING_RING_OVERLAY";
        case   0x20D9: return "COMBINING_CLOCKWISE_RING_OVERLAY";
        case   0x20DA: return "COMBINING_ANTICLOCKWISE_RING_OVERLAY";
        case   0x20DB: return "COMBINING_THREE_DOTS_ABOVE";
        case   0x20DC: return "COMBINING_FOUR_DOTS_ABOVE";
        case   0x20DD: return "COMBINING_ENCLOSING_CIRCLE";
        case   0x20DE: return "COMBINING_ENCLOSING_SQUARE";
        case   0x20DF: return "COMBINING_ENCLOSING_DIAMOND";
        case   0x20E0: return "COMBINING_ENCLOSING_CIRCLE_BACKSLASH";
        case   0x20E1: return "COMBINING_LEFT_RIGHT_ARROW_ABOVE";
        case   0x20E2: return "COMBINING_ENCLOSING_SCREEN";
        case   0x20E3: return "COMBINING_ENCLOSING_KEYCAP";
        case   0x20E4: return "COMBINING_ENCLOSING_UPWARD_POINTING_TRIANGLE";
        case   0x20E5: return "COMBINING_REVERSE_SOLIDUS_OVERLAY";
        case   0x20E6: return "COMBINING_DOUBLE_VERTICAL_STROKE_OVERLAY";
        case   0x20E7: return "COMBINING_ANNUITY_SYMBOL";
        case   0x20E8: return "COMBINING_TRIPLE_UNDERDOT";
        case   0x20E9: return "COMBINING_WIDE_BRIDGE_ABOVE";
        case   0x20EA: return "COMBINING_LEFTWARDS_ARROW_OVERLAY";
        case   0x20EB: return "COMBINING_LONG_DOUBLE_SOLIDUS_OVERLAY";
        case   0x20EC: return
                "COMBINING_RIGHTWARDS_HARPOON_WITH_BARB_DOWNWARDS";
        case   0x20ED: return
                "COMBINING_LEFTWARDS_HARPOON_WITH_BARB_DOWNWARDS";
        case   0x20EE: return "COMBINING_LEFT_ARROW_BELOW";
        case   0x20EF: return "COMBINING_RIGHT_ARROW_BELOW";
        case   0x20F0: return "COMBINING_ASTERISK_ABOVE";
        case   0x2100: return "ACCOUNT_OF";
        case   0x2101: return "ADDRESSED_TO_THE_SUBJECT";
        case   0x2102: return "DOUBLE_STRUCK_CAPITAL_C";
        case   0x2103: return "DEGREE_CELSIUS";
        case   0x2104: return "CENTRE_LINE_SYMBOL";
        case   0x2105: return "CARE_OF";
        case   0x2106: return "CADA_UNA";
        case   0x2107: return "EULER_CONSTANT";
        case   0x2108: return "SCRUPLE";
        case   0x2109: return "DEGREE_FAHRENHEIT";
        case   0x210A: return "SCRIPT_SMALL_G";
        case   0x210B: return "SCRIPT_CAPITAL_H";
        case   0x210C: return "BLACK_LETTER_CAPITAL_H";
        case   0x210D: return "DOUBLE_STRUCK_CAPITAL_H";
        case   0x210E: return "PLANCK_CONSTANT";
        case   0x210F: return "PLANCK_CONSTANT_OVER_TWO_PI";
        case   0x2110: return "SCRIPT_CAPITAL_I";
        case   0x2111: return "BLACK_LETTER_CAPITAL_I";
        case   0x2112: return "SCRIPT_CAPITAL_L";
        case   0x2113: return "SCRIPT_SMALL_L";
        case   0x2114: return "L_B_BAR_SYMBOL";
        case   0x2115: return "DOUBLE_STRUCK_CAPITAL_N";
        case   0x2116: return "NUMERO_SIGN";
        case   0x2117: return "SOUND_RECORDING_COPYRIGHT";
        case   0x2118: return "SCRIPT_CAPITAL_P";
        case   0x2119: return "DOUBLE_STRUCK_CAPITAL_P";
        case   0x211A: return "DOUBLE_STRUCK_CAPITAL_Q";
        case   0x211B: return "SCRIPT_CAPITAL_R";
        case   0x211C: return "BLACK_LETTER_CAPITAL_R";
        case   0x211D: return "DOUBLE_STRUCK_CAPITAL_R";
        case   0x211E: return "PRESCRIPTION_TAKE";
        case   0x211F: return "RESPONSE";
        case   0x2120: return "SERVICE_MARK";
        case   0x2121: return "TELEPHONE_SIGN";
        case   0x2122: return "TRADE_MARK_SIGN";
        case   0x2123: return "VERSICLE";
        case   0x2124: return "DOUBLE_STRUCK_CAPITAL_Z";
        case   0x2125: return "OUNCE_SIGN";
        case   0x2126: return "OHM_SIGN";
        case   0x2127: return "INVERTED_OHM_SIGN";
        case   0x2128: return "BLACK_LETTER_CAPITAL_Z";
        case   0x2129: return "TURNED_GREEK_SMALL_LETTER_IOTA";
        case   0x212A: return "KELVIN_SIGN";
        case   0x212B: return "ANGSTROM_SIGN";
        case   0x212C: return "SCRIPT_CAPITAL_B";
        case   0x212D: return "BLACK_LETTER_CAPITAL_C";
        case   0x212E: return "ESTIMATED_SYMBOL";
        case   0x212F: return "SCRIPT_SMALL_E";
        case   0x2130: return "SCRIPT_CAPITAL_E";
        case   0x2131: return "SCRIPT_CAPITAL_F";
        case   0x2132: return "TURNED_CAPITAL_F";
        case   0x2133: return "SCRIPT_CAPITAL_M";
        case   0x2134: return "SCRIPT_SMALL_O";
        case   0x2135: return "ALEF_SYMBOL";
        case   0x2136: return "BET_SYMBOL";
        case   0x2137: return "GIMEL_SYMBOL";
        case   0x2138: return "DALET_SYMBOL";
        case   0x2139: return "INFORMATION_SOURCE";
        case   0x213A: return "ROTATED_CAPITAL_Q";
        case   0x213B: return "FACSIMILE_SIGN";
        case   0x213C: return "DOUBLE_STRUCK_SMALL_PI";
        case   0x213D: return "DOUBLE_STRUCK_SMALL_GAMMA";
        case   0x213E: return "DOUBLE_STRUCK_CAPITAL_GAMMA";
        case   0x213F: return "DOUBLE_STRUCK_CAPITAL_PI";
        case   0x2140: return "DOUBLE_STRUCK_N_ARY_SUMMATION";
        case   0x2141: return "TURNED_SANS_SERIF_CAPITAL_G";
        case   0x2142: return "TURNED_SANS_SERIF_CAPITAL_L";
        case   0x2143: return "REVERSED_SANS_SERIF_CAPITAL_L";
        case   0x2144: return "TURNED_SANS_SERIF_CAPITAL_Y";
        case   0x2145: return "DOUBLE_STRUCK_ITALIC_CAPITAL_D";
        case   0x2146: return "DOUBLE_STRUCK_ITALIC_SMALL_D";
        case   0x2147: return "DOUBLE_STRUCK_ITALIC_SMALL_E";
        case   0x2148: return "DOUBLE_STRUCK_ITALIC_SMALL_I";
        case   0x2149: return "DOUBLE_STRUCK_ITALIC_SMALL_J";
        case   0x214A: return "PROPERTY_LINE";
        case   0x214B: return "TURNED_AMPERSAND";
        case   0x214C: return "PER_SIGN";
        case   0x214D: return "AKTIESELSKAB";
        case   0x214E: return "TURNED_SMALL_F";
        case   0x214F: return "SYMBOL_FOR_SAMARITAN_SOURCE";
        case   0x2150: return "VULGAR_FRACTION_ONE_SEVENTH";
        case   0x2151: return "VULGAR_FRACTION_ONE_NINTH";
        case   0x2152: return "VULGAR_FRACTION_ONE_TENTH";
        case   0x2153: return "VULGAR_FRACTION_ONE_THIRD";
        case   0x2154: return "VULGAR_FRACTION_TWO_THIRDS";
        case   0x2155: return "VULGAR_FRACTION_ONE_FIFTH";
        case   0x2156: return "VULGAR_FRACTION_TWO_FIFTHS";
        case   0x2157: return "VULGAR_FRACTION_THREE_FIFTHS";
        case   0x2158: return "VULGAR_FRACTION_FOUR_FIFTHS";
        case   0x2159: return "VULGAR_FRACTION_ONE_SIXTH";
        case   0x215A: return "VULGAR_FRACTION_FIVE_SIXTHS";
        case   0x215B: return "VULGAR_FRACTION_ONE_EIGHTH";
        case   0x215C: return "VULGAR_FRACTION_THREE_EIGHTHS";
        case   0x215D: return "VULGAR_FRACTION_FIVE_EIGHTHS";
        case   0x215E: return "VULGAR_FRACTION_SEVEN_EIGHTHS";
        case   0x215F: return "FRACTION_NUMERATOR_ONE";
        case   0x2160: return "ROMAN_NUMERAL_ONE";
        case   0x2161: return "ROMAN_NUMERAL_TWO";
        case   0x2162: return "ROMAN_NUMERAL_THREE";
        case   0x2163: return "ROMAN_NUMERAL_FOUR";
        case   0x2164: return "ROMAN_NUMERAL_FIVE";
        case   0x2165: return "ROMAN_NUMERAL_SIX";
        case   0x2166: return "ROMAN_NUMERAL_SEVEN";
        case   0x2167: return "ROMAN_NUMERAL_EIGHT";
        case   0x2168: return "ROMAN_NUMERAL_NINE";
        case   0x2169: return "ROMAN_NUMERAL_TEN";
        case   0x216A: return "ROMAN_NUMERAL_ELEVEN";
        case   0x216B: return "ROMAN_NUMERAL_TWELVE";
        case   0x216C: return "ROMAN_NUMERAL_FIFTY";
        case   0x216D: return "ROMAN_NUMERAL_ONE_HUNDRED";
        case   0x216E: return "ROMAN_NUMERAL_FIVE_HUNDRED";
        case   0x216F: return "ROMAN_NUMERAL_ONE_THOUSAND";
        case   0x2170: return "SMALL_ROMAN_NUMERAL_ONE";
        case   0x2171: return "SMALL_ROMAN_NUMERAL_TWO";
        case   0x2172: return "SMALL_ROMAN_NUMERAL_THREE";
        case   0x2173: return "SMALL_ROMAN_NUMERAL_FOUR";
        case   0x2174: return "SMALL_ROMAN_NUMERAL_FIVE";
        case   0x2175: return "SMALL_ROMAN_NUMERAL_SIX";
        case   0x2176: return "SMALL_ROMAN_NUMERAL_SEVEN";
        case   0x2177: return "SMALL_ROMAN_NUMERAL_EIGHT";
        case   0x2178: return "SMALL_ROMAN_NUMERAL_NINE";
        case   0x2179: return "SMALL_ROMAN_NUMERAL_TEN";
        case   0x217A: return "SMALL_ROMAN_NUMERAL_ELEVEN";
        case   0x217B: return "SMALL_ROMAN_NUMERAL_TWELVE";
        case   0x217C: return "SMALL_ROMAN_NUMERAL_FIFTY";
        case   0x217D: return "SMALL_ROMAN_NUMERAL_ONE_HUNDRED";
        case   0x217E: return "SMALL_ROMAN_NUMERAL_FIVE_HUNDRED";
        case   0x217F: return "SMALL_ROMAN_NUMERAL_ONE_THOUSAND";
        case   0x2180: return "ROMAN_NUMERAL_ONE_THOUSAND_C_D";
        case   0x2181: return "ROMAN_NUMERAL_FIVE_THOUSAND";
        case   0x2182: return "ROMAN_NUMERAL_TEN_THOUSAND";
        case   0x2183: return "ROMAN_NUMERAL_REVERSED_ONE_HUNDRED";
        case   0x2184: return "LATIN_SMALL_LETTER_REVERSED_C";
        case   0x2185: return "ROMAN_NUMERAL_SIX_LATE_FORM";
        case   0x2186: return "ROMAN_NUMERAL_FIFTY_EARLY_FORM";
        case   0x2187: return "ROMAN_NUMERAL_FIFTY_THOUSAND";
        case   0x2188: return "ROMAN_NUMERAL_ONE_HUNDRED_THOUSAND";
        case   0x2189: return "VULGAR_FRACTION_ZERO_THIRDS";
        case   0x2190: return "LEFTWARDS_ARROW";
        case   0x2191: return "UPWARDS_ARROW";
        case   0x2192: return "RIGHTWARDS_ARROW";
        case   0x2193: return "DOWNWARDS_ARROW";
        case   0x2194: return "LEFT_RIGHT_ARROW";
        case   0x2195: return "UP_DOWN_ARROW";
        case   0x2196: return "NORTH_WEST_ARROW";
        case   0x2197: return "NORTH_EAST_ARROW";
        case   0x2198: return "SOUTH_EAST_ARROW";
        case   0x2199: return "SOUTH_WEST_ARROW";
        case   0x219A: return "LEFTWARDS_ARROW_WITH_STROKE";
        case   0x219B: return "RIGHTWARDS_ARROW_WITH_STROKE";
        case   0x219C: return "LEFTWARDS_WAVE_ARROW";
        case   0x219D: return "RIGHTWARDS_WAVE_ARROW";
        case   0x219E: return "LEFTWARDS_TWO_HEADED_ARROW";
        case   0x219F: return "UPWARDS_TWO_HEADED_ARROW";
        case   0x21A0: return "RIGHTWARDS_TWO_HEADED_ARROW";
        case   0x21A1: return "DOWNWARDS_TWO_HEADED_ARROW";
        case   0x21A2: return "LEFTWARDS_ARROW_WITH_TAIL";
        case   0x21A3: return "RIGHTWARDS_ARROW_WITH_TAIL";
        case   0x21A4: return "LEFTWARDS_ARROW_FROM_BAR";
        case   0x21A5: return "UPWARDS_ARROW_FROM_BAR";
        case   0x21A6: return "RIGHTWARDS_ARROW_FROM_BAR";
        case   0x21A7: return "DOWNWARDS_ARROW_FROM_BAR";
        case   0x21A8: return "UP_DOWN_ARROW_WITH_BASE";
        case   0x21A9: return "LEFTWARDS_ARROW_WITH_HOOK";
        case   0x21AA: return "RIGHTWARDS_ARROW_WITH_HOOK";
        case   0x21AB: return "LEFTWARDS_ARROW_WITH_LOOP";
        case   0x21AC: return "RIGHTWARDS_ARROW_WITH_LOOP";
        case   0x21AD: return "LEFT_RIGHT_WAVE_ARROW";
        case   0x21AE: return "LEFT_RIGHT_ARROW_WITH_STROKE";
        case   0x21AF: return "DOWNWARDS_ZIGZAG_ARROW";
        case   0x21B0: return "UPWARDS_ARROW_WITH_TIP_LEFTWARDS";
        case   0x21B1: return "UPWARDS_ARROW_WITH_TIP_RIGHTWARDS";
        case   0x21B2: return "DOWNWARDS_ARROW_WITH_TIP_LEFTWARDS";
        case   0x21B3: return "DOWNWARDS_ARROW_WITH_TIP_RIGHTWARDS";
        case   0x21B4: return "RIGHTWARDS_ARROW_WITH_CORNER_DOWNWARDS";
        case   0x21B5: return "DOWNWARDS_ARROW_WITH_CORNER_LEFTWARDS";
        case   0x21B6: return "ANTICLOCKWISE_TOP_SEMICIRCLE_ARROW";
        case   0x21B7: return "CLOCKWISE_TOP_SEMICIRCLE_ARROW";
        case   0x21B8: return "NORTH_WEST_ARROW_TO_LONG_BAR";
        case   0x21B9: return
                "LEFTWARDS_ARROW_TO_BAR_OVER_RIGHTWARDS_ARROW_TO_BAR";
        case   0x21BA: return "ANTICLOCKWISE_OPEN_CIRCLE_ARROW";
        case   0x21BB: return "CLOCKWISE_OPEN_CIRCLE_ARROW";
        case   0x21BC: return "LEFTWARDS_HARPOON_WITH_BARB_UPWARDS";
        case   0x21BD: return "LEFTWARDS_HARPOON_WITH_BARB_DOWNWARDS";
        case   0x21BE: return "UPWARDS_HARPOON_WITH_BARB_RIGHTWARDS";
        case   0x21BF: return "UPWARDS_HARPOON_WITH_BARB_LEFTWARDS";
        case   0x21C0: return "RIGHTWARDS_HARPOON_WITH_BARB_UPWARDS";
        case   0x21C1: return "RIGHTWARDS_HARPOON_WITH_BARB_DOWNWARDS";
        case   0x21C2: return "DOWNWARDS_HARPOON_WITH_BARB_RIGHTWARDS";
        case   0x21C3: return "DOWNWARDS_HARPOON_WITH_BARB_LEFTWARDS";
        case   0x21C4: return "RIGHTWARDS_ARROW_OVER_LEFTWARDS_ARROW";
        case   0x21C5: return "UPWARDS_ARROW_LEFTWARDS_OF_DOWNWARDS_ARROW";
        case   0x21C6: return "LEFTWARDS_ARROW_OVER_RIGHTWARDS_ARROW";
        case   0x21C7: return "LEFTWARDS_PAIRED_ARROWS";
        case   0x21C8: return "UPWARDS_PAIRED_ARROWS";
        case   0x21C9: return "RIGHTWARDS_PAIRED_ARROWS";
        case   0x21CA: return "DOWNWARDS_PAIRED_ARROWS";
        case   0x21CB: return "LEFTWARDS_HARPOON_OVER_RIGHTWARDS_HARPOON";
        case   0x21CC: return "RIGHTWARDS_HARPOON_OVER_LEFTWARDS_HARPOON";
        case   0x21CD: return "LEFTWARDS_DOUBLE_ARROW_WITH_STROKE";
        case   0x21CE: return "LEFT_RIGHT_DOUBLE_ARROW_WITH_STROKE";
        case   0x21CF: return "RIGHTWARDS_DOUBLE_ARROW_WITH_STROKE";
        case   0x21D0: return "LEFTWARDS_DOUBLE_ARROW";
        case   0x21D1: return "UPWARDS_DOUBLE_ARROW";
        case   0x21D2: return "RIGHTWARDS_DOUBLE_ARROW";
        case   0x21D3: return "DOWNWARDS_DOUBLE_ARROW";
        case   0x21D4: return "LEFT_RIGHT_DOUBLE_ARROW";
        case   0x21D5: return "UP_DOWN_DOUBLE_ARROW";
        case   0x21D6: return "NORTH_WEST_DOUBLE_ARROW";
        case   0x21D7: return "NORTH_EAST_DOUBLE_ARROW";
        case   0x21D8: return "SOUTH_EAST_DOUBLE_ARROW";
        case   0x21D9: return "SOUTH_WEST_DOUBLE_ARROW";
        case   0x21DA: return "LEFTWARDS_TRIPLE_ARROW";
        case   0x21DB: return "RIGHTWARDS_TRIPLE_ARROW";
        case   0x21DC: return "LEFTWARDS_SQUIGGLE_ARROW";
        case   0x21DD: return "RIGHTWARDS_SQUIGGLE_ARROW";
        case   0x21DE: return "UPWARDS_ARROW_WITH_DOUBLE_STROKE";
        case   0x21DF: return "DOWNWARDS_ARROW_WITH_DOUBLE_STROKE";
        case   0x21E0: return "LEFTWARDS_DASHED_ARROW";
        case   0x21E1: return "UPWARDS_DASHED_ARROW";
        case   0x21E2: return "RIGHTWARDS_DASHED_ARROW";
        case   0x21E3: return "DOWNWARDS_DASHED_ARROW";
        case   0x21E4: return "LEFTWARDS_ARROW_TO_BAR";
        case   0x21E5: return "RIGHTWARDS_ARROW_TO_BAR";
        case   0x21E6: return "LEFTWARDS_WHITE_ARROW";
        case   0x21E7: return "UPWARDS_WHITE_ARROW";
        case   0x21E8: return "RIGHTWARDS_WHITE_ARROW";
        case   0x21E9: return "DOWNWARDS_WHITE_ARROW";
        case   0x21EA: return "UPWARDS_WHITE_ARROW_FROM_BAR";
        case   0x21EB: return "UPWARDS_WHITE_ARROW_ON_PEDESTAL";
        case   0x21EC: return
                "UPWARDS_WHITE_ARROW_ON_PEDESTAL_WITH_HORIZONTAL_BAR";
        case   0x21ED: return
                "UPWARDS_WHITE_ARROW_ON_PEDESTAL_WITH_VERTICAL_BAR";
        case   0x21EE: return "UPWARDS_WHITE_DOUBLE_ARROW";
        case   0x21EF: return "UPWARDS_WHITE_DOUBLE_ARROW_ON_PEDESTAL";
        case   0x21F0: return "RIGHTWARDS_WHITE_ARROW_FROM_WALL";
        case   0x21F1: return "NORTH_WEST_ARROW_TO_CORNER";
        case   0x21F2: return "SOUTH_EAST_ARROW_TO_CORNER";
        case   0x21F3: return "UP_DOWN_WHITE_ARROW";
        case   0x21F4: return "RIGHT_ARROW_WITH_SMALL_CIRCLE";
        case   0x21F5: return "DOWNWARDS_ARROW_LEFTWARDS_OF_UPWARDS_ARROW";
        case   0x21F6: return "THREE_RIGHTWARDS_ARROWS";
        case   0x21F7: return "LEFTWARDS_ARROW_WITH_VERTICAL_STROKE";
        case   0x21F8: return "RIGHTWARDS_ARROW_WITH_VERTICAL_STROKE";
        case   0x21F9: return "LEFT_RIGHT_ARROW_WITH_VERTICAL_STROKE";
        case   0x21FA: return "LEFTWARDS_ARROW_WITH_DOUBLE_VERTICAL_STROKE";
        case   0x21FB: return "RIGHTWARDS_ARROW_WITH_DOUBLE_VERTICAL_STROKE";
        case   0x21FC: return "LEFT_RIGHT_ARROW_WITH_DOUBLE_VERTICAL_STROKE";
        case   0x21FD: return "LEFTWARDS_OPEN_HEADED_ARROW";
        case   0x21FE: return "RIGHTWARDS_OPEN_HEADED_ARROW";
        case   0x21FF: return "LEFT_RIGHT_OPEN_HEADED_ARROW";
        case   0x2200: return "FOR_ALL";
        case   0x2201: return "COMPLEMENT";
        case   0x2202: return "PARTIAL_DIFFERENTIAL";
        case   0x2203: return "THERE_EXISTS";
        case   0x2204: return "THERE_DOES_NOT_EXIST";
        case   0x2205: return "EMPTY_SET";
        case   0x2206: return "INCREMENT";
        case   0x2207: return "NABLA";
        case   0x2208: return "ELEMENT_OF";
        case   0x2209: return "NOT_AN_ELEMENT_OF";
        case   0x220A: return "SMALL_ELEMENT_OF";
        case   0x220B: return "CONTAINS_AS_MEMBER";
        case   0x220C: return "DOES_NOT_CONTAIN_AS_MEMBER";
        case   0x220D: return "SMALL_CONTAINS_AS_MEMBER";
        case   0x220E: return "END_OF_PROOF";
        case   0x220F: return "N_ARY_PRODUCT";
        case   0x2210: return "N_ARY_COPRODUCT";
        case   0x2211: return "N_ARY_SUMMATION";
        case   0x2212: return "MINUS_SIGN";
        case   0x2213: return "MINUS_OR_PLUS_SIGN";
        case   0x2214: return "DOT_PLUS";
        case   0x2215: return "DIVISION_SLASH";
        case   0x2216: return "SET_MINUS";
        case   0x2217: return "ASTERISK_OPERATOR";
        case   0x2218: return "RING_OPERATOR";
        case   0x2219: return "BULLET_OPERATOR";
        case   0x221A: return "SQUARE_ROOT";
        case   0x221B: return "CUBE_ROOT";
        case   0x221C: return "FOURTH_ROOT";
        case   0x221D: return "PROPORTIONAL_TO";
        case   0x221E: return "INFINITY";
        case   0x221F: return "RIGHT_ANGLE";
        case   0x2220: return "ANGLE";
        case   0x2221: return "MEASURED_ANGLE";
        case   0x2222: return "SPHERICAL_ANGLE";
        case   0x2223: return "DIVIDES";
        case   0x2224: return "DOES_NOT_DIVIDE";
        case   0x2225: return "PARALLEL_TO";
        case   0x2226: return "NOT_PARALLEL_TO";
        case   0x2227: return "LOGICAL_AND";
        case   0x2228: return "LOGICAL_OR";
        case   0x2229: return "INTERSECTION";
        case   0x222A: return "UNION";
        case   0x222B: return "INTEGRAL";
        case   0x222C: return "DOUBLE_INTEGRAL";
        case   0x222D: return "TRIPLE_INTEGRAL";
        case   0x222E: return "CONTOUR_INTEGRAL";
        case   0x222F: return "SURFACE_INTEGRAL";
        case   0x2230: return "VOLUME_INTEGRAL";
        case   0x2231: return "CLOCKWISE_INTEGRAL";
        case   0x2232: return "CLOCKWISE_CONTOUR_INTEGRAL";
        case   0x2233: return "ANTICLOCKWISE_CONTOUR_INTEGRAL";
        case   0x2234: return "THEREFORE";
        case   0x2235: return "BECAUSE";
        case   0x2236: return "RATIO";
        case   0x2237: return "PROPORTION";
        case   0x2238: return "DOT_MINUS";
        case   0x2239: return "EXCESS";
        case   0x223A: return "GEOMETRIC_PROPORTION";
        case   0x223B: return "HOMOTHETIC";
        case   0x223C: return "TILDE_OPERATOR";
        case   0x223D: return "REVERSED_TILDE";
        case   0x223E: return "INVERTED_LAZY_S";
        case   0x223F: return "SINE_WAVE";
        case   0x2240: return "WREATH_PRODUCT";
        case   0x2241: return "NOT_TILDE";
        case   0x2242: return "MINUS_TILDE";
        case   0x2243: return "ASYMPTOTICALLY_EQUAL_TO";
        case   0x2244: return "NOT_ASYMPTOTICALLY_EQUAL_TO";
        case   0x2245: return "APPROXIMATELY_EQUAL_TO";
        case   0x2246: return "APPROXIMATELY_BUT_NOT_ACTUALLY_EQUAL_TO";
        case   0x2247: return "NEITHER_APPROXIMATELY_NOR_ACTUALLY_EQUAL_TO";
        case   0x2248: return "ALMOST_EQUAL_TO";
        case   0x2249: return "NOT_ALMOST_EQUAL_TO";
        case   0x224A: return "ALMOST_EQUAL_OR_EQUAL_TO";
        case   0x224B: return "TRIPLE_TILDE";
        case   0x224C: return "ALL_EQUAL_TO";
        case   0x224D: return "EQUIVALENT_TO";
        case   0x224E: return "GEOMETRICALLY_EQUIVALENT_TO";
        case   0x224F: return "DIFFERENCE_BETWEEN";
        case   0x2250: return "APPROACHES_THE_LIMIT";
        case   0x2251: return "GEOMETRICALLY_EQUAL_TO";
        case   0x2252: return "APPROXIMATELY_EQUAL_TO_OR_THE_IMAGE_OF";
        case   0x2253: return "IMAGE_OF_OR_APPROXIMATELY_EQUAL_TO";
        case   0x2254: return "COLON_EQUALS";
        case   0x2255: return "EQUALS_COLON";
        case   0x2256: return "RING_IN_EQUAL_TO";
        case   0x2257: return "RING_EQUAL_TO";
        case   0x2258: return "CORRESPONDS_TO";
        case   0x2259: return "ESTIMATES";
        case   0x225A: return "EQUIANGULAR_TO";
        case   0x225B: return "STAR_EQUALS";
        case   0x225C: return "DELTA_EQUAL_TO";
        case   0x225D: return "EQUAL_TO_BY_DEFINITION";
        case   0x225E: return "MEASURED_BY";
        case   0x225F: return "QUESTIONED_EQUAL_TO";
        case   0x2260: return "NOT_EQUAL_TO";
        case   0x2261: return "IDENTICAL_TO";
        case   0x2262: return "NOT_IDENTICAL_TO";
        case   0x2263: return "STRICTLY_EQUIVALENT_TO";
        case   0x2264: return "LESS_THAN_OR_EQUAL_TO";
        case   0x2265: return "GREATER_THAN_OR_EQUAL_TO";
        case   0x2266: return "LESS_THAN_OVER_EQUAL_TO";
        case   0x2267: return "GREATER_THAN_OVER_EQUAL_TO";
        case   0x2268: return "LESS_THAN_BUT_NOT_EQUAL_TO";
        case   0x2269: return "GREATER_THAN_BUT_NOT_EQUAL_TO";
        case   0x226A: return "MUCH_LESS_THAN";
        case   0x226B: return "MUCH_GREATER_THAN";
        case   0x226C: return "BETWEEN";
        case   0x226D: return "NOT_EQUIVALENT_TO";
        case   0x226E: return "NOT_LESS_THAN";
        case   0x226F: return "NOT_GREATER_THAN";
        case   0x2270: return "NEITHER_LESS_THAN_NOR_EQUAL_TO";
        case   0x2271: return "NEITHER_GREATER_THAN_NOR_EQUAL_TO";
        case   0x2272: return "LESS_THAN_OR_EQUIVALENT_TO";
        case   0x2273: return "GREATER_THAN_OR_EQUIVALENT_TO";
        case   0x2274: return "NEITHER_LESS_THAN_NOR_EQUIVALENT_TO";
        case   0x2275: return "NEITHER_GREATER_THAN_NOR_EQUIVALENT_TO";
        case   0x2276: return "LESS_THAN_OR_GREATER_THAN";
        case   0x2277: return "GREATER_THAN_OR_LESS_THAN";
        case   0x2278: return "NEITHER_LESS_THAN_NOR_GREATER_THAN";
        case   0x2279: return "NEITHER_GREATER_THAN_NOR_LESS_THAN";
        case   0x227A: return "PRECEDES";
        case   0x227B: return "SUCCEEDS";
        case   0x227C: return "PRECEDES_OR_EQUAL_TO";
        case   0x227D: return "SUCCEEDS_OR_EQUAL_TO";
        case   0x227E: return "PRECEDES_OR_EQUIVALENT_TO";
        case   0x227F: return "SUCCEEDS_OR_EQUIVALENT_TO";
        case   0x2280: return "DOES_NOT_PRECEDE";
        case   0x2281: return "DOES_NOT_SUCCEED";
        case   0x2282: return "SUBSET_OF";
        case   0x2283: return "SUPERSET_OF";
        case   0x2284: return "NOT_A_SUBSET_OF";
        case   0x2285: return "NOT_A_SUPERSET_OF";
        case   0x2286: return "SUBSET_OF_OR_EQUAL_TO";
        case   0x2287: return "SUPERSET_OF_OR_EQUAL_TO";
        case   0x2288: return "NEITHER_A_SUBSET_OF_NOR_EQUAL_TO";
        case   0x2289: return "NEITHER_A_SUPERSET_OF_NOR_EQUAL_TO";
        case   0x228A: return "SUBSET_OF_WITH_NOT_EQUAL_TO";
        case   0x228B: return "SUPERSET_OF_WITH_NOT_EQUAL_TO";
        case   0x228C: return "MULTISET";
        case   0x228D: return "MULTISET_MULTIPLICATION";
        case   0x228E: return "MULTISET_UNION";
        case   0x228F: return "SQUARE_IMAGE_OF";
        case   0x2290: return "SQUARE_ORIGINAL_OF";
        case   0x2291: return "SQUARE_IMAGE_OF_OR_EQUAL_TO";
        case   0x2292: return "SQUARE_ORIGINAL_OF_OR_EQUAL_TO";
        case   0x2293: return "SQUARE_CAP";
        case   0x2294: return "SQUARE_CUP";
        case   0x2295: return "CIRCLED_PLUS";
        case   0x2296: return "CIRCLED_MINUS";
        case   0x2297: return "CIRCLED_TIMES";
        case   0x2298: return "CIRCLED_DIVISION_SLASH";
        case   0x2299: return "CIRCLED_DOT_OPERATOR";
        case   0x229A: return "CIRCLED_RING_OPERATOR";
        case   0x229B: return "CIRCLED_ASTERISK_OPERATOR";
        case   0x229C: return "CIRCLED_EQUALS";
        case   0x229D: return "CIRCLED_DASH";
        case   0x229E: return "SQUARED_PLUS";
        case   0x229F: return "SQUARED_MINUS";
        case   0x22A0: return "SQUARED_TIMES";
        case   0x22A1: return "SQUARED_DOT_OPERATOR";
        case   0x22A2: return "RIGHT_TACK";
        case   0x22A3: return "LEFT_TACK";
        case   0x22A4: return "DOWN_TACK";
        case   0x22A5: return "UP_TACK";
        case   0x22A6: return "ASSERTION";
        case   0x22A7: return "MODELS";
        case   0x22A8: return "TRUE";
        case   0x22A9: return "FORCES";
        case   0x22AA: return "TRIPLE_VERTICAL_BAR_RIGHT_TURNSTILE";
        case   0x22AB: return "DOUBLE_VERTICAL_BAR_DOUBLE_RIGHT_TURNSTILE";
        case   0x22AC: return "DOES_NOT_PROVE";
        case   0x22AD: return "NOT_TRUE";
        case   0x22AE: return "DOES_NOT_FORCE";
        case   0x22AF: return
                "NEGATED_DOUBLE_VERTICAL_BAR_DOUBLE_RIGHT_TURNSTILE";
        case   0x22B0: return "PRECEDES_UNDER_RELATION";
        case   0x22B1: return "SUCCEEDS_UNDER_RELATION";
        case   0x22B2: return "NORMAL_SUBGROUP_OF";
        case   0x22B3: return "CONTAINS_AS_NORMAL_SUBGROUP";
        case   0x22B4: return "NORMAL_SUBGROUP_OF_OR_EQUAL_TO";
        case   0x22B5: return "CONTAINS_AS_NORMAL_SUBGROUP_OR_EQUAL_TO";
        case   0x22B6: return "ORIGINAL_OF";
        case   0x22B7: return "IMAGE_OF";
        case   0x22B8: return "MULTIMAP";
        case   0x22B9: return "HERMITIAN_CONJUGATE_MATRIX";
        case   0x22BA: return "INTERCALATE";
        case   0x22BB: return "XOR";
        case   0x22BC: return "NAND";
        case   0x22BD: return "NOR";
        case   0x22BE: return "RIGHT_ANGLE_WITH_ARC";
        case   0x22BF: return "RIGHT_TRIANGLE";
        case   0x22C0: return "N_ARY_LOGICAL_AND";
        case   0x22C1: return "N_ARY_LOGICAL_OR";
        case   0x22C2: return "N_ARY_INTERSECTION";
        case   0x22C3: return "N_ARY_UNION";
        case   0x22C4: return "DIAMOND_OPERATOR";
        case   0x22C5: return "DOT_OPERATOR";
        case   0x22C6: return "STAR_OPERATOR";
        case   0x22C7: return "DIVISION_TIMES";
        case   0x22C8: return "BOWTIE";
        case   0x22C9: return "LEFT_NORMAL_FACTOR_SEMIDIRECT_PRODUCT";
        case   0x22CA: return "RIGHT_NORMAL_FACTOR_SEMIDIRECT_PRODUCT";
        case   0x22CB: return "LEFT_SEMIDIRECT_PRODUCT";
        case   0x22CC: return "RIGHT_SEMIDIRECT_PRODUCT";
        case   0x22CD: return "REVERSED_TILDE_EQUALS";
        case   0x22CE: return "CURLY_LOGICAL_OR";
        case   0x22CF: return "CURLY_LOGICAL_AND";
        case   0x22D0: return "DOUBLE_SUBSET";
        case   0x22D1: return "DOUBLE_SUPERSET";
        case   0x22D2: return "DOUBLE_INTERSECTION";
        case   0x22D3: return "DOUBLE_UNION";
        case   0x22D4: return "PITCHFORK";
        case   0x22D5: return "EQUAL_AND_PARALLEL_TO";
        case   0x22D6: return "LESS_THAN_WITH_DOT";
        case   0x22D7: return "GREATER_THAN_WITH_DOT";
        case   0x22D8: return "VERY_MUCH_LESS_THAN";
        case   0x22D9: return "VERY_MUCH_GREATER_THAN";
        case   0x22DA: return "LESS_THAN_EQUAL_TO_OR_GREATER_THAN";
        case   0x22DB: return "GREATER_THAN_EQUAL_TO_OR_LESS_THAN";
        case   0x22DC: return "EQUAL_TO_OR_LESS_THAN";
        case   0x22DD: return "EQUAL_TO_OR_GREATER_THAN";
        case   0x22DE: return "EQUAL_TO_OR_PRECEDES";
        case   0x22DF: return "EQUAL_TO_OR_SUCCEEDS";
        case   0x22E0: return "DOES_NOT_PRECEDE_OR_EQUAL";
        case   0x22E1: return "DOES_NOT_SUCCEED_OR_EQUAL";
        case   0x22E2: return "NOT_SQUARE_IMAGE_OF_OR_EQUAL_TO";
        case   0x22E3: return "NOT_SQUARE_ORIGINAL_OF_OR_EQUAL_TO";
        case   0x22E4: return "SQUARE_IMAGE_OF_OR_NOT_EQUAL_TO";
        case   0x22E5: return "SQUARE_ORIGINAL_OF_OR_NOT_EQUAL_TO";
        case   0x22E6: return "LESS_THAN_BUT_NOT_EQUIVALENT_TO";
        case   0x22E7: return "GREATER_THAN_BUT_NOT_EQUIVALENT_TO";
        case   0x22E8: return "PRECEDES_BUT_NOT_EQUIVALENT_TO";
        case   0x22E9: return "SUCCEEDS_BUT_NOT_EQUIVALENT_TO";
        case   0x22EA: return "NOT_NORMAL_SUBGROUP_OF";
        case   0x22EB: return "DOES_NOT_CONTAIN_AS_NORMAL_SUBGROUP";
        case   0x22EC: return "NOT_NORMAL_SUBGROUP_OF_OR_EQUAL_TO";
        case   0x22ED: return "DOES_NOT_CONTAIN_AS_NORMAL_SUBGROUP_OR_EQUAL";
        case   0x22EE: return "VERTICAL_ELLIPSIS";
        case   0x22EF: return "MIDLINE_HORIZONTAL_ELLIPSIS";
        case   0x22F0: return "UP_RIGHT_DIAGONAL_ELLIPSIS";
        case   0x22F1: return "DOWN_RIGHT_DIAGONAL_ELLIPSIS";
        case   0x22F2: return "ELEMENT_OF_WITH_LONG_HORIZONTAL_STROKE";
        case   0x22F3: return
                "ELEMENT_OF_WITH_VERTICAL_BAR_AT_END_OF_HORIZONTAL_STROKE";
        case   0x22F4: return
                "SMALL_ELEMENT_OF_WITH_VERTICAL_BAR_AT_END_OF_HORIZONTAL_STROKE";
        case   0x22F5: return "ELEMENT_OF_WITH_DOT_ABOVE";
        case   0x22F6: return "ELEMENT_OF_WITH_OVERBAR";
        case   0x22F7: return "SMALL_ELEMENT_OF_WITH_OVERBAR";
        case   0x22F8: return "ELEMENT_OF_WITH_UNDERBAR";
        case   0x22F9: return "ELEMENT_OF_WITH_TWO_HORIZONTAL_STROKES";
        case   0x22FA: return "CONTAINS_WITH_LONG_HORIZONTAL_STROKE";
        case   0x22FB: return
                "CONTAINS_WITH_VERTICAL_BAR_AT_END_OF_HORIZONTAL_STROKE";
        case   0x22FC: return
                "SMALL_CONTAINS_WITH_VERTICAL_BAR_AT_END_OF_HORIZONTAL_STROKE";
        case   0x22FD: return "CONTAINS_WITH_OVERBAR";
        case   0x22FE: return "SMALL_CONTAINS_WITH_OVERBAR";
        case   0x22FF: return "Z_NOTATION_BAG_MEMBERSHIP";
        case   0x2300: return "DIAMETER_SIGN";
        case   0x2301: return "ELECTRIC_ARROW";
        case   0x2302: return "HOUSE";
        case   0x2303: return "UP_ARROWHEAD";
        case   0x2304: return "DOWN_ARROWHEAD";
        case   0x2305: return "PROJECTIVE";
        case   0x2306: return "PERSPECTIVE";
        case   0x2307: return "WAVY_LINE";
        case   0x2308: return "LEFT_CEILING";
        case   0x2309: return "RIGHT_CEILING";
        case   0x230A: return "LEFT_FLOOR";
        case   0x230B: return "RIGHT_FLOOR";
        case   0x230C: return "BOTTOM_RIGHT_CROP";
        case   0x230D: return "BOTTOM_LEFT_CROP";
        case   0x230E: return "TOP_RIGHT_CROP";
        case   0x230F: return "TOP_LEFT_CROP";
        case   0x2310: return "REVERSED_NOT_SIGN";
        case   0x2311: return "SQUARE_LOZENGE";
        case   0x2312: return "ARC";
        case   0x2313: return "SEGMENT";
        case   0x2314: return "SECTOR";
        case   0x2315: return "TELEPHONE_RECORDER";
        case   0x2316: return "POSITION_INDICATOR";
        case   0x2317: return "VIEWDATA_SQUARE";
        case   0x2318: return "PLACE_OF_INTEREST_SIGN";
        case   0x2319: return "TURNED_NOT_SIGN";
        case   0x231A: return "WATCH";
        case   0x231B: return "HOURGLASS";
        case   0x231C: return "TOP_LEFT_CORNER";
        case   0x231D: return "TOP_RIGHT_CORNER";
        case   0x231E: return "BOTTOM_LEFT_CORNER";
        case   0x231F: return "BOTTOM_RIGHT_CORNER";
        case   0x2320: return "TOP_HALF_INTEGRAL";
        case   0x2321: return "BOTTOM_HALF_INTEGRAL";
        case   0x2322: return "FROWN";
        case   0x2323: return "SMILE";
        case   0x2324: return "UP_ARROWHEAD_BETWEEN_TWO_HORIZONTAL_BARS";
        case   0x2325: return "OPTION_KEY";
        case   0x2326: return "ERASE_TO_THE_RIGHT";
        case   0x2327: return "X_IN_A_RECTANGLE_BOX";
        case   0x2328: return "KEYBOARD";
        case   0x2329: return "LEFT_POINTING_ANGLE_BRACKET";
        case   0x232A: return "RIGHT_POINTING_ANGLE_BRACKET";
        case   0x232B: return "ERASE_TO_THE_LEFT";
        case   0x232C: return "BENZENE_RING";
        case   0x232D: return "CYLINDRICITY";
        case   0x232E: return "ALL_AROUND_PROFILE";
        case   0x232F: return "SYMMETRY";
        case   0x2330: return "TOTAL_RUNOUT";
        case   0x2331: return "DIMENSION_ORIGIN";
        case   0x2332: return "CONICAL_TAPER";
        case   0x2333: return "SLOPE";
        case   0x2334: return "COUNTERBORE";
        case   0x2335: return "COUNTERSINK";
        case   0x2336: return "APL_FUNCTIONAL_SYMBOL_I_BEAM";
        case   0x2337: return "APL_FUNCTIONAL_SYMBOL_SQUISH_QUAD";
        case   0x2338: return "APL_FUNCTIONAL_SYMBOL_QUAD_EQUAL";
        case   0x2339: return "APL_FUNCTIONAL_SYMBOL_QUAD_DIVIDE";
        case   0x233A: return "APL_FUNCTIONAL_SYMBOL_QUAD_DIAMOND";
        case   0x233B: return "APL_FUNCTIONAL_SYMBOL_QUAD_JOT";
        case   0x233C: return "APL_FUNCTIONAL_SYMBOL_QUAD_CIRCLE";
        case   0x233D: return "APL_FUNCTIONAL_SYMBOL_CIRCLE_STILE";
        case   0x233E: return "APL_FUNCTIONAL_SYMBOL_CIRCLE_JOT";
        case   0x233F: return "APL_FUNCTIONAL_SYMBOL_SLASH_BAR";
        case   0x2340: return "APL_FUNCTIONAL_SYMBOL_BACKSLASH_BAR";
        case   0x2341: return "APL_FUNCTIONAL_SYMBOL_QUAD_SLASH";
        case   0x2342: return "APL_FUNCTIONAL_SYMBOL_QUAD_BACKSLASH";
        case   0x2343: return "APL_FUNCTIONAL_SYMBOL_QUAD_LESS_THAN";
        case   0x2344: return "APL_FUNCTIONAL_SYMBOL_QUAD_GREATER_THAN";
        case   0x2345: return "APL_FUNCTIONAL_SYMBOL_LEFTWARDS_VANE";
        case   0x2346: return "APL_FUNCTIONAL_SYMBOL_RIGHTWARDS_VANE";
        case   0x2347: return "APL_FUNCTIONAL_SYMBOL_QUAD_LEFTWARDS_ARROW";
        case   0x2348: return "APL_FUNCTIONAL_SYMBOL_QUAD_RIGHTWARDS_ARROW";
        case   0x2349: return "APL_FUNCTIONAL_SYMBOL_CIRCLE_BACKSLASH";
        case   0x234A: return "APL_FUNCTIONAL_SYMBOL_DOWN_TACK_UNDERBAR";
        case   0x234B: return "APL_FUNCTIONAL_SYMBOL_DELTA_STILE";
        case   0x234C: return "APL_FUNCTIONAL_SYMBOL_QUAD_DOWN_CARET";
        case   0x234D: return "APL_FUNCTIONAL_SYMBOL_QUAD_DELTA";
        case   0x234E: return "APL_FUNCTIONAL_SYMBOL_DOWN_TACK_JOT";
        case   0x234F: return "APL_FUNCTIONAL_SYMBOL_UPWARDS_VANE";
        case   0x2350: return "APL_FUNCTIONAL_SYMBOL_QUAD_UPWARDS_ARROW";
        case   0x2351: return "APL_FUNCTIONAL_SYMBOL_UP_TACK_OVERBAR";
        case   0x2352: return "APL_FUNCTIONAL_SYMBOL_DEL_STILE";
        case   0x2353: return "APL_FUNCTIONAL_SYMBOL_QUAD_UP_CARET";
        case   0x2354: return "APL_FUNCTIONAL_SYMBOL_QUAD_DEL";
        case   0x2355: return "APL_FUNCTIONAL_SYMBOL_UP_TACK_JOT";
        case   0x2356: return "APL_FUNCTIONAL_SYMBOL_DOWNWARDS_VANE";
        case   0x2357: return "APL_FUNCTIONAL_SYMBOL_QUAD_DOWNWARDS_ARROW";
        case   0x2358: return "APL_FUNCTIONAL_SYMBOL_QUOTE_UNDERBAR";
        case   0x2359: return "APL_FUNCTIONAL_SYMBOL_DELTA_UNDERBAR";
        case   0x235A: return "APL_FUNCTIONAL_SYMBOL_DIAMOND_UNDERBAR";
        case   0x235B: return "APL_FUNCTIONAL_SYMBOL_JOT_UNDERBAR";
        case   0x235C: return "APL_FUNCTIONAL_SYMBOL_CIRCLE_UNDERBAR";
        case   0x235D: return "APL_FUNCTIONAL_SYMBOL_UP_SHOE_JOT";
        case   0x235E: return "APL_FUNCTIONAL_SYMBOL_QUOTE_QUAD";
        case   0x235F: return "APL_FUNCTIONAL_SYMBOL_CIRCLE_STAR";
        case   0x2360: return "APL_FUNCTIONAL_SYMBOL_QUAD_COLON";
        case   0x2361: return "APL_FUNCTIONAL_SYMBOL_UP_TACK_DIAERESIS";
        case   0x2362: return "APL_FUNCTIONAL_SYMBOL_DEL_DIAERESIS";
        case   0x2363: return "APL_FUNCTIONAL_SYMBOL_STAR_DIAERESIS";
        case   0x2364: return "APL_FUNCTIONAL_SYMBOL_JOT_DIAERESIS";
        case   0x2365: return "APL_FUNCTIONAL_SYMBOL_CIRCLE_DIAERESIS";
        case   0x2366: return "APL_FUNCTIONAL_SYMBOL_DOWN_SHOE_STILE";
        case   0x2367: return "APL_FUNCTIONAL_SYMBOL_LEFT_SHOE_STILE";
        case   0x2368: return "APL_FUNCTIONAL_SYMBOL_TILDE_DIAERESIS";
        case   0x2369: return "APL_FUNCTIONAL_SYMBOL_GREATER_THAN_DIAERESIS";
        case   0x236A: return "APL_FUNCTIONAL_SYMBOL_COMMA_BAR";
        case   0x236B: return "APL_FUNCTIONAL_SYMBOL_DEL_TILDE";
        case   0x236C: return "APL_FUNCTIONAL_SYMBOL_ZILDE";
        case   0x236D: return "APL_FUNCTIONAL_SYMBOL_STILE_TILDE";
        case   0x236E: return "APL_FUNCTIONAL_SYMBOL_SEMICOLON_UNDERBAR";
        case   0x236F: return "APL_FUNCTIONAL_SYMBOL_QUAD_NOT_EQUAL";
        case   0x2370: return "APL_FUNCTIONAL_SYMBOL_QUAD_QUESTION";
        case   0x2371: return "APL_FUNCTIONAL_SYMBOL_DOWN_CARET_TILDE";
        case   0x2372: return "APL_FUNCTIONAL_SYMBOL_UP_CARET_TILDE";
        case   0x2373: return "APL_FUNCTIONAL_SYMBOL_IOTA";
        case   0x2374: return "APL_FUNCTIONAL_SYMBOL_RHO";
        case   0x2375: return "APL_FUNCTIONAL_SYMBOL_OMEGA";
        case   0x2376: return "APL_FUNCTIONAL_SYMBOL_ALPHA_UNDERBAR";
        case   0x2377: return "APL_FUNCTIONAL_SYMBOL_EPSILON_UNDERBAR";
        case   0x2378: return "APL_FUNCTIONAL_SYMBOL_IOTA_UNDERBAR";
        case   0x2379: return "APL_FUNCTIONAL_SYMBOL_OMEGA_UNDERBAR";
        case   0x237A: return "APL_FUNCTIONAL_SYMBOL_ALPHA";
        case   0x237B: return "NOT_CHECK_MARK";
        case   0x237C: return "RIGHT_ANGLE_WITH_DOWNWARDS_ZIGZAG_ARROW";
        case   0x237D: return "SHOULDERED_OPEN_BOX";
        case   0x237E: return "BELL_SYMBOL";
        case   0x237F: return "VERTICAL_LINE_WITH_MIDDLE_DOT";
        case   0x2380: return "INSERTION_SYMBOL";
        case   0x2381: return "CONTINUOUS_UNDERLINE_SYMBOL";
        case   0x2382: return "DISCONTINUOUS_UNDERLINE_SYMBOL";
        case   0x2383: return "EMPHASIS_SYMBOL";
        case   0x2384: return "COMPOSITION_SYMBOL";
        case   0x2385: return "WHITE_SQUARE_WITH_CENTRE_VERTICAL_LINE";
        case   0x2386: return "ENTER_SYMBOL";
        case   0x2387: return "ALTERNATIVE_KEY_SYMBOL";
        case   0x2388: return "HELM_SYMBOL";
        case   0x2389: return "CIRCLED_HORIZONTAL_BAR_WITH_NOTCH";
        case   0x238A: return "CIRCLED_TRIANGLE_DOWN";
        case   0x238B: return "BROKEN_CIRCLE_WITH_NORTHWEST_ARROW";
        case   0x238C: return "UNDO_SYMBOL";
        case   0x238D: return "MONOSTABLE_SYMBOL";
        case   0x238E: return "HYSTERESIS_SYMBOL";
        case   0x238F: return "OPEN_CIRCUIT_OUTPUT_H_TYPE_SYMBOL";
        case   0x2390: return "OPEN_CIRCUIT_OUTPUT_L_TYPE_SYMBOL";
        case   0x2391: return "PASSIVE_PULL_DOWN_OUTPUT_SYMBOL";
        case   0x2392: return "PASSIVE_PULL_UP_OUTPUT_SYMBOL";
        case   0x2393: return "DIRECT_CURRENT_SYMBOL_FORM_TWO";
        case   0x2394: return "SOFTWARE_FUNCTION_SYMBOL";
        case   0x2395: return "APL_FUNCTIONAL_SYMBOL_QUAD";
        case   0x2396: return "DECIMAL_SEPARATOR_KEY_SYMBOL";
        case   0x2397: return "PREVIOUS_PAGE";
        case   0x2398: return "NEXT_PAGE";
        case   0x2399: return "PRINT_SCREEN_SYMBOL";
        case   0x239A: return "CLEAR_SCREEN_SYMBOL";
        case   0x239B: return "LEFT_PARENTHESIS_UPPER_HOOK";
        case   0x239C: return "LEFT_PARENTHESIS_EXTENSION";
        case   0x239D: return "LEFT_PARENTHESIS_LOWER_HOOK";
        case   0x239E: return "RIGHT_PARENTHESIS_UPPER_HOOK";
        case   0x239F: return "RIGHT_PARENTHESIS_EXTENSION";
        case   0x23A0: return "RIGHT_PARENTHESIS_LOWER_HOOK";
        case   0x23A1: return "LEFT_SQUARE_BRACKET_UPPER_CORNER";
        case   0x23A2: return "LEFT_SQUARE_BRACKET_EXTENSION";
        case   0x23A3: return "LEFT_SQUARE_BRACKET_LOWER_CORNER";
        case   0x23A4: return "RIGHT_SQUARE_BRACKET_UPPER_CORNER";
        case   0x23A5: return "RIGHT_SQUARE_BRACKET_EXTENSION";
        case   0x23A6: return "RIGHT_SQUARE_BRACKET_LOWER_CORNER";
        case   0x23A7: return "LEFT_CURLY_BRACKET_UPPER_HOOK";
        case   0x23A8: return "LEFT_CURLY_BRACKET_MIDDLE_PIECE";
        case   0x23A9: return "LEFT_CURLY_BRACKET_LOWER_HOOK";
        case   0x23AA: return "CURLY_BRACKET_EXTENSION";
        case   0x23AB: return "RIGHT_CURLY_BRACKET_UPPER_HOOK";
        case   0x23AC: return "RIGHT_CURLY_BRACKET_MIDDLE_PIECE";
        case   0x23AD: return "RIGHT_CURLY_BRACKET_LOWER_HOOK";
        case   0x23AE: return "INTEGRAL_EXTENSION";
        case   0x23AF: return "HORIZONTAL_LINE_EXTENSION";
        case   0x23B0: return
                "UPPER_LEFT_OR_LOWER_RIGHT_CURLY_BRACKET_SECTION";
        case   0x23B1: return
                "UPPER_RIGHT_OR_LOWER_LEFT_CURLY_BRACKET_SECTION";
        case   0x23B2: return "SUMMATION_TOP";
        case   0x23B3: return "SUMMATION_BOTTOM";
        case   0x23B4: return "TOP_SQUARE_BRACKET";
        case   0x23B5: return "BOTTOM_SQUARE_BRACKET";
        case   0x23B6: return "BOTTOM_SQUARE_BRACKET_OVER_TOP_SQUARE_BRACKET";
        case   0x23B7: return "RADICAL_SYMBOL_BOTTOM";
        case   0x23B8: return "LEFT_VERTICAL_BOX_LINE";
        case   0x23B9: return "RIGHT_VERTICAL_BOX_LINE";
        case   0x23BA: return "HORIZONTAL_SCAN_LINE_1";
        case   0x23BB: return "HORIZONTAL_SCAN_LINE_3";
        case   0x23BC: return "HORIZONTAL_SCAN_LINE_7";
        case   0x23BD: return "HORIZONTAL_SCAN_LINE_9";
        case   0x23BE: return "DENTISTRY_SYMBOL_LIGHT_VERTICAL_AND_TOP_RIGHT";
        case   0x23BF: return
                "DENTISTRY_SYMBOL_LIGHT_VERTICAL_AND_BOTTOM_RIGHT";
        case   0x23C0: return "DENTISTRY_SYMBOL_LIGHT_VERTICAL_WITH_CIRCLE";
        case   0x23C1: return
                "DENTISTRY_SYMBOL_LIGHT_DOWN_AND_HORIZONTAL_WITH_CIRCLE";
        case   0x23C2: return
                "DENTISTRY_SYMBOL_LIGHT_UP_AND_HORIZONTAL_WITH_CIRCLE";
        case   0x23C3: return "DENTISTRY_SYMBOL_LIGHT_VERTICAL_WITH_TRIANGLE";
        case   0x23C4: return
                "DENTISTRY_SYMBOL_LIGHT_DOWN_AND_HORIZONTAL_WITH_TRIANGLE";
        case   0x23C5: return
                "DENTISTRY_SYMBOL_LIGHT_UP_AND_HORIZONTAL_WITH_TRIANGLE";
        case   0x23C6: return "DENTISTRY_SYMBOL_LIGHT_VERTICAL_AND_WAVE";
        case   0x23C7: return
                "DENTISTRY_SYMBOL_LIGHT_DOWN_AND_HORIZONTAL_WITH_WAVE";
        case   0x23C8: return
                "DENTISTRY_SYMBOL_LIGHT_UP_AND_HORIZONTAL_WITH_WAVE";
        case   0x23C9: return "DENTISTRY_SYMBOL_LIGHT_DOWN_AND_HORIZONTAL";
        case   0x23CA: return "DENTISTRY_SYMBOL_LIGHT_UP_AND_HORIZONTAL";
        case   0x23CB: return "DENTISTRY_SYMBOL_LIGHT_VERTICAL_AND_TOP_LEFT";
        case   0x23CC: return
                "DENTISTRY_SYMBOL_LIGHT_VERTICAL_AND_BOTTOM_LEFT";
        case   0x23CD: return "SQUARE_FOOT";
        case   0x23CE: return "RETURN_SYMBOL";
        case   0x23CF: return "EJECT_SYMBOL";
        case   0x23D0: return "VERTICAL_LINE_EXTENSION";
        case   0x23D1: return "METRICAL_BREVE";
        case   0x23D2: return "METRICAL_LONG_OVER_SHORT";
        case   0x23D3: return "METRICAL_SHORT_OVER_LONG";
        case   0x23D4: return "METRICAL_LONG_OVER_TWO_SHORTS";
        case   0x23D5: return "METRICAL_TWO_SHORTS_OVER_LONG";
        case   0x23D6: return "METRICAL_TWO_SHORTS_JOINED";
        case   0x23D7: return "METRICAL_TRISEME";
        case   0x23D8: return "METRICAL_TETRASEME";
        case   0x23D9: return "METRICAL_PENTASEME";
        case   0x23DA: return "EARTH_GROUND";
        case   0x23DB: return "FUSE";
        case   0x23DC: return "TOP_PARENTHESIS";
        case   0x23DD: return "BOTTOM_PARENTHESIS";
        case   0x23DE: return "TOP_CURLY_BRACKET";
        case   0x23DF: return "BOTTOM_CURLY_BRACKET";
        case   0x23E0: return "TOP_TORTOISE_SHELL_BRACKET";
        case   0x23E1: return "BOTTOM_TORTOISE_SHELL_BRACKET";
        case   0x23E2: return "WHITE_TRAPEZIUM";
        case   0x23E3: return "BENZENE_RING_WITH_CIRCLE";
        case   0x23E4: return "STRAIGHTNESS";
        case   0x23E5: return "FLATNESS";
        case   0x23E6: return "AC_CURRENT";
        case   0x23E7: return "ELECTRICAL_INTERSECTION";
        case   0x23E8: return "DECIMAL_EXPONENT_SYMBOL";
        case   0x23E9: return "BLACK_RIGHT_POINTING_DOUBLE_TRIANGLE";
        case   0x23EA: return "BLACK_LEFT_POINTING_DOUBLE_TRIANGLE";
        case   0x23EB: return "BLACK_UP_POINTING_DOUBLE_TRIANGLE";
        case   0x23EC: return "BLACK_DOWN_POINTING_DOUBLE_TRIANGLE";
        case   0x23ED: return
                "BLACK_RIGHT_POINTING_DOUBLE_TRIANGLE_WITH_VERTICAL_BAR";
        case   0x23EE: return
                "BLACK_LEFT_POINTING_DOUBLE_TRIANGLE_WITH_VERTICAL_BAR";
        case   0x23EF: return
                "BLACK_RIGHT_POINTING_TRIANGLE_WITH_DOUBLE_VERTICAL_BAR";
        case   0x23F0: return "ALARM_CLOCK";
        case   0x23F1: return "STOPWATCH";
        case   0x23F2: return "TIMER_CLOCK";
        case   0x23F3: return "HOURGLASS_WITH_FLOWING_SAND";
        case   0x23F4: return "BLACK_MEDIUM_LEFT_POINTING_TRIANGLE";
        case   0x23F5: return "BLACK_MEDIUM_RIGHT_POINTING_TRIANGLE";
        case   0x23F6: return "BLACK_MEDIUM_UP_POINTING_TRIANGLE";
        case   0x23F7: return "BLACK_MEDIUM_DOWN_POINTING_TRIANGLE";
        case   0x23F8: return "DOUBLE_VERTICAL_BAR";
        case   0x23F9: return "BLACK_SQUARE_FOR_STOP";
        case   0x23FA: return "BLACK_CIRCLE_FOR_RECORD";
        case   0x2400: return "SYMBOL_FOR_NULL";
        case   0x2401: return "SYMBOL_FOR_START_OF_HEADING";
        case   0x2402: return "SYMBOL_FOR_START_OF_TEXT";
        case   0x2403: return "SYMBOL_FOR_END_OF_TEXT";
        case   0x2404: return "SYMBOL_FOR_END_OF_TRANSMISSION";
        case   0x2405: return "SYMBOL_FOR_ENQUIRY";
        case   0x2406: return "SYMBOL_FOR_ACKNOWLEDGE";
        case   0x2407: return "SYMBOL_FOR_BELL";
        case   0x2408: return "SYMBOL_FOR_BACKSPACE";
        case   0x2409: return "SYMBOL_FOR_HORIZONTAL_TABULATION";
        case   0x240A: return "SYMBOL_FOR_LINE_FEED";
        case   0x240B: return "SYMBOL_FOR_VERTICAL_TABULATION";
        case   0x240C: return "SYMBOL_FOR_FORM_FEED";
        case   0x240D: return "SYMBOL_FOR_CARRIAGE_RETURN";
        case   0x240E: return "SYMBOL_FOR_SHIFT_OUT";
        case   0x240F: return "SYMBOL_FOR_SHIFT_IN";
        case   0x2410: return "SYMBOL_FOR_DATA_LINK_ESCAPE";
        case   0x2411: return "SYMBOL_FOR_DEVICE_CONTROL_ONE";
        case   0x2412: return "SYMBOL_FOR_DEVICE_CONTROL_TWO";
        case   0x2413: return "SYMBOL_FOR_DEVICE_CONTROL_THREE";
        case   0x2414: return "SYMBOL_FOR_DEVICE_CONTROL_FOUR";
        case   0x2415: return "SYMBOL_FOR_NEGATIVE_ACKNOWLEDGE";
        case   0x2416: return "SYMBOL_FOR_SYNCHRONOUS_IDLE";
        case   0x2417: return "SYMBOL_FOR_END_OF_TRANSMISSION_BLOCK";
        case   0x2418: return "SYMBOL_FOR_CANCEL";
        case   0x2419: return "SYMBOL_FOR_END_OF_MEDIUM";
        case   0x241A: return "SYMBOL_FOR_SUBSTITUTE";
        case   0x241B: return "SYMBOL_FOR_ESCAPE";
        case   0x241C: return "SYMBOL_FOR_FILE_SEPARATOR";
        case   0x241D: return "SYMBOL_FOR_GROUP_SEPARATOR";
        case   0x241E: return "SYMBOL_FOR_RECORD_SEPARATOR";
        case   0x241F: return "SYMBOL_FOR_UNIT_SEPARATOR";
        case   0x2420: return "SYMBOL_FOR_SPACE";
        case   0x2421: return "SYMBOL_FOR_DELETE";
        case   0x2422: return "BLANK_SYMBOL";
        case   0x2423: return "OPEN_BOX";
        case   0x2424: return "SYMBOL_FOR_NEWLINE";
        case   0x2425: return "SYMBOL_FOR_DELETE_FORM_TWO";
        case   0x2426: return "SYMBOL_FOR_SUBSTITUTE_FORM_TWO";
        case   0x2440: return "OCR_HOOK";
        case   0x2441: return "OCR_CHAIR";
        case   0x2442: return "OCR_FORK";
        case   0x2443: return "OCR_INVERTED_FORK";
        case   0x2444: return "OCR_BELT_BUCKLE";
        case   0x2445: return "OCR_BOW_TIE";
        case   0x2446: return "OCR_BRANCH_BANK_IDENTIFICATION";
        case   0x2447: return "OCR_AMOUNT_OF_CHECK";
        case   0x2448: return "OCR_DASH";
        case   0x2449: return "OCR_CUSTOMER_ACCOUNT_NUMBER";
        case   0x244A: return "OCR_DOUBLE_BACKSLASH";
        case   0x2460: return "CIRCLED_DIGIT_ONE";
        case   0x2461: return "CIRCLED_DIGIT_TWO";
        case   0x2462: return "CIRCLED_DIGIT_THREE";
        case   0x2463: return "CIRCLED_DIGIT_FOUR";
        case   0x2464: return "CIRCLED_DIGIT_FIVE";
        case   0x2465: return "CIRCLED_DIGIT_SIX";
        case   0x2466: return "CIRCLED_DIGIT_SEVEN";
        case   0x2467: return "CIRCLED_DIGIT_EIGHT";
        case   0x2468: return "CIRCLED_DIGIT_NINE";
        case   0x2469: return "CIRCLED_NUMBER_TEN";
        case   0x246A: return "CIRCLED_NUMBER_ELEVEN";
        case   0x246B: return "CIRCLED_NUMBER_TWELVE";
        case   0x246C: return "CIRCLED_NUMBER_THIRTEEN";
        case   0x246D: return "CIRCLED_NUMBER_FOURTEEN";
        case   0x246E: return "CIRCLED_NUMBER_FIFTEEN";
        case   0x246F: return "CIRCLED_NUMBER_SIXTEEN";
        case   0x2470: return "CIRCLED_NUMBER_SEVENTEEN";
        case   0x2471: return "CIRCLED_NUMBER_EIGHTEEN";
        case   0x2472: return "CIRCLED_NUMBER_NINETEEN";
        case   0x2473: return "CIRCLED_NUMBER_TWENTY";
        case   0x2474: return "PARENTHESIZED_DIGIT_ONE";
        case   0x2475: return "PARENTHESIZED_DIGIT_TWO";
        case   0x2476: return "PARENTHESIZED_DIGIT_THREE";
        case   0x2477: return "PARENTHESIZED_DIGIT_FOUR";
        case   0x2478: return "PARENTHESIZED_DIGIT_FIVE";
        case   0x2479: return "PARENTHESIZED_DIGIT_SIX";
        case   0x247A: return "PARENTHESIZED_DIGIT_SEVEN";
        case   0x247B: return "PARENTHESIZED_DIGIT_EIGHT";
        case   0x247C: return "PARENTHESIZED_DIGIT_NINE";
        case   0x247D: return "PARENTHESIZED_NUMBER_TEN";
        case   0x247E: return "PARENTHESIZED_NUMBER_ELEVEN";
        case   0x247F: return "PARENTHESIZED_NUMBER_TWELVE";
        case   0x2480: return "PARENTHESIZED_NUMBER_THIRTEEN";
        case   0x2481: return "PARENTHESIZED_NUMBER_FOURTEEN";
        case   0x2482: return "PARENTHESIZED_NUMBER_FIFTEEN";
        case   0x2483: return "PARENTHESIZED_NUMBER_SIXTEEN";
        case   0x2484: return "PARENTHESIZED_NUMBER_SEVENTEEN";
        case   0x2485: return "PARENTHESIZED_NUMBER_EIGHTEEN";
        case   0x2486: return "PARENTHESIZED_NUMBER_NINETEEN";
        case   0x2487: return "PARENTHESIZED_NUMBER_TWENTY";
        case   0x2488: return "DIGIT_ONE_FULL_STOP";
        case   0x2489: return "DIGIT_TWO_FULL_STOP";
        case   0x248A: return "DIGIT_THREE_FULL_STOP";
        case   0x248B: return "DIGIT_FOUR_FULL_STOP";
        case   0x248C: return "DIGIT_FIVE_FULL_STOP";
        case   0x248D: return "DIGIT_SIX_FULL_STOP";
        case   0x248E: return "DIGIT_SEVEN_FULL_STOP";
        case   0x248F: return "DIGIT_EIGHT_FULL_STOP";
        case   0x2490: return "DIGIT_NINE_FULL_STOP";
        case   0x2491: return "NUMBER_TEN_FULL_STOP";
        case   0x2492: return "NUMBER_ELEVEN_FULL_STOP";
        case   0x2493: return "NUMBER_TWELVE_FULL_STOP";
        case   0x2494: return "NUMBER_THIRTEEN_FULL_STOP";
        case   0x2495: return "NUMBER_FOURTEEN_FULL_STOP";
        case   0x2496: return "NUMBER_FIFTEEN_FULL_STOP";
        case   0x2497: return "NUMBER_SIXTEEN_FULL_STOP";
        case   0x2498: return "NUMBER_SEVENTEEN_FULL_STOP";
        case   0x2499: return "NUMBER_EIGHTEEN_FULL_STOP";
        case   0x249A: return "NUMBER_NINETEEN_FULL_STOP";
        case   0x249B: return "NUMBER_TWENTY_FULL_STOP";
        case   0x249C: return "PARENTHESIZED_LATIN_SMALL_LETTER_A";
        case   0x249D: return "PARENTHESIZED_LATIN_SMALL_LETTER_B";
        case   0x249E: return "PARENTHESIZED_LATIN_SMALL_LETTER_C";
        case   0x249F: return "PARENTHESIZED_LATIN_SMALL_LETTER_D";
        case   0x24A0: return "PARENTHESIZED_LATIN_SMALL_LETTER_E";
        case   0x24A1: return "PARENTHESIZED_LATIN_SMALL_LETTER_F";
        case   0x24A2: return "PARENTHESIZED_LATIN_SMALL_LETTER_G";
        case   0x24A3: return "PARENTHESIZED_LATIN_SMALL_LETTER_H";
        case   0x24A4: return "PARENTHESIZED_LATIN_SMALL_LETTER_I";
        case   0x24A5: return "PARENTHESIZED_LATIN_SMALL_LETTER_J";
        case   0x24A6: return "PARENTHESIZED_LATIN_SMALL_LETTER_K";
        case   0x24A7: return "PARENTHESIZED_LATIN_SMALL_LETTER_L";
        case   0x24A8: return "PARENTHESIZED_LATIN_SMALL_LETTER_M";
        case   0x24A9: return "PARENTHESIZED_LATIN_SMALL_LETTER_N";
        case   0x24AA: return "PARENTHESIZED_LATIN_SMALL_LETTER_O";
        case   0x24AB: return "PARENTHESIZED_LATIN_SMALL_LETTER_P";
        case   0x24AC: return "PARENTHESIZED_LATIN_SMALL_LETTER_Q";
        case   0x24AD: return "PARENTHESIZED_LATIN_SMALL_LETTER_R";
        case   0x24AE: return "PARENTHESIZED_LATIN_SMALL_LETTER_S";
        case   0x24AF: return "PARENTHESIZED_LATIN_SMALL_LETTER_T";
        case   0x24B0: return "PARENTHESIZED_LATIN_SMALL_LETTER_U";
        case   0x24B1: return "PARENTHESIZED_LATIN_SMALL_LETTER_V";
        case   0x24B2: return "PARENTHESIZED_LATIN_SMALL_LETTER_W";
        case   0x24B3: return "PARENTHESIZED_LATIN_SMALL_LETTER_X";
        case   0x24B4: return "PARENTHESIZED_LATIN_SMALL_LETTER_Y";
        case   0x24B5: return "PARENTHESIZED_LATIN_SMALL_LETTER_Z";
        case   0x24B6: return "CIRCLED_LATIN_CAPITAL_LETTER_A";
        case   0x24B7: return "CIRCLED_LATIN_CAPITAL_LETTER_B";
        case   0x24B8: return "CIRCLED_LATIN_CAPITAL_LETTER_C";
        case   0x24B9: return "CIRCLED_LATIN_CAPITAL_LETTER_D";
        case   0x24BA: return "CIRCLED_LATIN_CAPITAL_LETTER_E";
        case   0x24BB: return "CIRCLED_LATIN_CAPITAL_LETTER_F";
        case   0x24BC: return "CIRCLED_LATIN_CAPITAL_LETTER_G";
        case   0x24BD: return "CIRCLED_LATIN_CAPITAL_LETTER_H";
        case   0x24BE: return "CIRCLED_LATIN_CAPITAL_LETTER_I";
        case   0x24BF: return "CIRCLED_LATIN_CAPITAL_LETTER_J";
        case   0x24C0: return "CIRCLED_LATIN_CAPITAL_LETTER_K";
        case   0x24C1: return "CIRCLED_LATIN_CAPITAL_LETTER_L";
        case   0x24C2: return "CIRCLED_LATIN_CAPITAL_LETTER_M";
        case   0x24C3: return "CIRCLED_LATIN_CAPITAL_LETTER_N";
        case   0x24C4: return "CIRCLED_LATIN_CAPITAL_LETTER_O";
        case   0x24C5: return "CIRCLED_LATIN_CAPITAL_LETTER_P";
        case   0x24C6: return "CIRCLED_LATIN_CAPITAL_LETTER_Q";
        case   0x24C7: return "CIRCLED_LATIN_CAPITAL_LETTER_R";
        case   0x24C8: return "CIRCLED_LATIN_CAPITAL_LETTER_S";
        case   0x24C9: return "CIRCLED_LATIN_CAPITAL_LETTER_T";
        case   0x24CA: return "CIRCLED_LATIN_CAPITAL_LETTER_U";
        case   0x24CB: return "CIRCLED_LATIN_CAPITAL_LETTER_V";
        case   0x24CC: return "CIRCLED_LATIN_CAPITAL_LETTER_W";
        case   0x24CD: return "CIRCLED_LATIN_CAPITAL_LETTER_X";
        case   0x24CE: return "CIRCLED_LATIN_CAPITAL_LETTER_Y";
        case   0x24CF: return "CIRCLED_LATIN_CAPITAL_LETTER_Z";
        case   0x24D0: return "CIRCLED_LATIN_SMALL_LETTER_A";
        case   0x24D1: return "CIRCLED_LATIN_SMALL_LETTER_B";
        case   0x24D2: return "CIRCLED_LATIN_SMALL_LETTER_C";
        case   0x24D3: return "CIRCLED_LATIN_SMALL_LETTER_D";
        case   0x24D4: return "CIRCLED_LATIN_SMALL_LETTER_E";
        case   0x24D5: return "CIRCLED_LATIN_SMALL_LETTER_F";
        case   0x24D6: return "CIRCLED_LATIN_SMALL_LETTER_G";
        case   0x24D7: return "CIRCLED_LATIN_SMALL_LETTER_H";
        case   0x24D8: return "CIRCLED_LATIN_SMALL_LETTER_I";
        case   0x24D9: return "CIRCLED_LATIN_SMALL_LETTER_J";
        case   0x24DA: return "CIRCLED_LATIN_SMALL_LETTER_K";
        case   0x24DB: return "CIRCLED_LATIN_SMALL_LETTER_L";
        case   0x24DC: return "CIRCLED_LATIN_SMALL_LETTER_M";
        case   0x24DD: return "CIRCLED_LATIN_SMALL_LETTER_N";
        case   0x24DE: return "CIRCLED_LATIN_SMALL_LETTER_O";
        case   0x24DF: return "CIRCLED_LATIN_SMALL_LETTER_P";
        case   0x24E0: return "CIRCLED_LATIN_SMALL_LETTER_Q";
        case   0x24E1: return "CIRCLED_LATIN_SMALL_LETTER_R";
        case   0x24E2: return "CIRCLED_LATIN_SMALL_LETTER_S";
        case   0x24E3: return "CIRCLED_LATIN_SMALL_LETTER_T";
        case   0x24E4: return "CIRCLED_LATIN_SMALL_LETTER_U";
        case   0x24E5: return "CIRCLED_LATIN_SMALL_LETTER_V";
        case   0x24E6: return "CIRCLED_LATIN_SMALL_LETTER_W";
        case   0x24E7: return "CIRCLED_LATIN_SMALL_LETTER_X";
        case   0x24E8: return "CIRCLED_LATIN_SMALL_LETTER_Y";
        case   0x24E9: return "CIRCLED_LATIN_SMALL_LETTER_Z";
        case   0x24EA: return "CIRCLED_DIGIT_ZERO";
        case   0x24EB: return "NEGATIVE_CIRCLED_NUMBER_ELEVEN";
        case   0x24EC: return "NEGATIVE_CIRCLED_NUMBER_TWELVE";
        case   0x24ED: return "NEGATIVE_CIRCLED_NUMBER_THIRTEEN";
        case   0x24EE: return "NEGATIVE_CIRCLED_NUMBER_FOURTEEN";
        case   0x24EF: return "NEGATIVE_CIRCLED_NUMBER_FIFTEEN";
        case   0x24F0: return "NEGATIVE_CIRCLED_NUMBER_SIXTEEN";
        case   0x24F1: return "NEGATIVE_CIRCLED_NUMBER_SEVENTEEN";
        case   0x24F2: return "NEGATIVE_CIRCLED_NUMBER_EIGHTEEN";
        case   0x24F3: return "NEGATIVE_CIRCLED_NUMBER_NINETEEN";
        case   0x24F4: return "NEGATIVE_CIRCLED_NUMBER_TWENTY";
        case   0x24F5: return "DOUBLE_CIRCLED_DIGIT_ONE";
        case   0x24F6: return "DOUBLE_CIRCLED_DIGIT_TWO";
        case   0x24F7: return "DOUBLE_CIRCLED_DIGIT_THREE";
        case   0x24F8: return "DOUBLE_CIRCLED_DIGIT_FOUR";
        case   0x24F9: return "DOUBLE_CIRCLED_DIGIT_FIVE";
        case   0x24FA: return "DOUBLE_CIRCLED_DIGIT_SIX";
        case   0x24FB: return "DOUBLE_CIRCLED_DIGIT_SEVEN";
        case   0x24FC: return "DOUBLE_CIRCLED_DIGIT_EIGHT";
        case   0x24FD: return "DOUBLE_CIRCLED_DIGIT_NINE";
        case   0x24FE: return "DOUBLE_CIRCLED_NUMBER_TEN";
        case   0x24FF: return "NEGATIVE_CIRCLED_DIGIT_ZERO";
        case   0x2500: return "BOX_DRAWINGS_LIGHT_HORIZONTAL";
        case   0x2501: return "BOX_DRAWINGS_HEAVY_HORIZONTAL";
        case   0x2502: return "BOX_DRAWINGS_LIGHT_VERTICAL";
        case   0x2503: return "BOX_DRAWINGS_HEAVY_VERTICAL";
        case   0x2504: return "BOX_DRAWINGS_LIGHT_TRIPLE_DASH_HORIZONTAL";
        case   0x2505: return "BOX_DRAWINGS_HEAVY_TRIPLE_DASH_HORIZONTAL";
        case   0x2506: return "BOX_DRAWINGS_LIGHT_TRIPLE_DASH_VERTICAL";
        case   0x2507: return "BOX_DRAWINGS_HEAVY_TRIPLE_DASH_VERTICAL";
        case   0x2508: return "BOX_DRAWINGS_LIGHT_QUADRUPLE_DASH_HORIZONTAL";
        case   0x2509: return "BOX_DRAWINGS_HEAVY_QUADRUPLE_DASH_HORIZONTAL";
        case   0x250A: return "BOX_DRAWINGS_LIGHT_QUADRUPLE_DASH_VERTICAL";
        case   0x250B: return "BOX_DRAWINGS_HEAVY_QUADRUPLE_DASH_VERTICAL";
        case   0x250C: return "BOX_DRAWINGS_LIGHT_DOWN_AND_RIGHT";
        case   0x250D: return "BOX_DRAWINGS_DOWN_LIGHT_AND_RIGHT_HEAVY";
        case   0x250E: return "BOX_DRAWINGS_DOWN_HEAVY_AND_RIGHT_LIGHT";
        case   0x250F: return "BOX_DRAWINGS_HEAVY_DOWN_AND_RIGHT";
        case   0x2510: return "BOX_DRAWINGS_LIGHT_DOWN_AND_LEFT";
        case   0x2511: return "BOX_DRAWINGS_DOWN_LIGHT_AND_LEFT_HEAVY";
        case   0x2512: return "BOX_DRAWINGS_DOWN_HEAVY_AND_LEFT_LIGHT";
        case   0x2513: return "BOX_DRAWINGS_HEAVY_DOWN_AND_LEFT";
        case   0x2514: return "BOX_DRAWINGS_LIGHT_UP_AND_RIGHT";
        case   0x2515: return "BOX_DRAWINGS_UP_LIGHT_AND_RIGHT_HEAVY";
        case   0x2516: return "BOX_DRAWINGS_UP_HEAVY_AND_RIGHT_LIGHT";
        case   0x2517: return "BOX_DRAWINGS_HEAVY_UP_AND_RIGHT";
        case   0x2518: return "BOX_DRAWINGS_LIGHT_UP_AND_LEFT";
        case   0x2519: return "BOX_DRAWINGS_UP_LIGHT_AND_LEFT_HEAVY";
        case   0x251A: return "BOX_DRAWINGS_UP_HEAVY_AND_LEFT_LIGHT";
        case   0x251B: return "BOX_DRAWINGS_HEAVY_UP_AND_LEFT";
        case   0x251C: return "BOX_DRAWINGS_LIGHT_VERTICAL_AND_RIGHT";
        case   0x251D: return "BOX_DRAWINGS_VERTICAL_LIGHT_AND_RIGHT_HEAVY";
        case   0x251E: return "BOX_DRAWINGS_UP_HEAVY_AND_RIGHT_DOWN_LIGHT";
        case   0x251F: return "BOX_DRAWINGS_DOWN_HEAVY_AND_RIGHT_UP_LIGHT";
        case   0x2520: return "BOX_DRAWINGS_VERTICAL_HEAVY_AND_RIGHT_LIGHT";
        case   0x2521: return "BOX_DRAWINGS_DOWN_LIGHT_AND_RIGHT_UP_HEAVY";
        case   0x2522: return "BOX_DRAWINGS_UP_LIGHT_AND_RIGHT_DOWN_HEAVY";
        case   0x2523: return "BOX_DRAWINGS_HEAVY_VERTICAL_AND_RIGHT";
        case   0x2524: return "BOX_DRAWINGS_LIGHT_VERTICAL_AND_LEFT";
        case   0x2525: return "BOX_DRAWINGS_VERTICAL_LIGHT_AND_LEFT_HEAVY";
        case   0x2526: return "BOX_DRAWINGS_UP_HEAVY_AND_LEFT_DOWN_LIGHT";
        case   0x2527: return "BOX_DRAWINGS_DOWN_HEAVY_AND_LEFT_UP_LIGHT";
        case   0x2528: return "BOX_DRAWINGS_VERTICAL_HEAVY_AND_LEFT_LIGHT";
        case   0x2529: return "BOX_DRAWINGS_DOWN_LIGHT_AND_LEFT_UP_HEAVY";
        case   0x252A: return "BOX_DRAWINGS_UP_LIGHT_AND_LEFT_DOWN_HEAVY";
        case   0x252B: return "BOX_DRAWINGS_HEAVY_VERTICAL_AND_LEFT";
        case   0x252C: return "BOX_DRAWINGS_LIGHT_DOWN_AND_HORIZONTAL";
        case   0x252D: return "BOX_DRAWINGS_LEFT_HEAVY_AND_RIGHT_DOWN_LIGHT";
        case   0x252E: return "BOX_DRAWINGS_RIGHT_HEAVY_AND_LEFT_DOWN_LIGHT";
        case   0x252F: return "BOX_DRAWINGS_DOWN_LIGHT_AND_HORIZONTAL_HEAVY";
        case   0x2530: return "BOX_DRAWINGS_DOWN_HEAVY_AND_HORIZONTAL_LIGHT";
        case   0x2531: return "BOX_DRAWINGS_RIGHT_LIGHT_AND_LEFT_DOWN_HEAVY";
        case   0x2532: return "BOX_DRAWINGS_LEFT_LIGHT_AND_RIGHT_DOWN_HEAVY";
        case   0x2533: return "BOX_DRAWINGS_HEAVY_DOWN_AND_HORIZONTAL";
        case   0x2534: return "BOX_DRAWINGS_LIGHT_UP_AND_HORIZONTAL";
        case   0x2535: return "BOX_DRAWINGS_LEFT_HEAVY_AND_RIGHT_UP_LIGHT";
        case   0x2536: return "BOX_DRAWINGS_RIGHT_HEAVY_AND_LEFT_UP_LIGHT";
        case   0x2537: return "BOX_DRAWINGS_UP_LIGHT_AND_HORIZONTAL_HEAVY";
        case   0x2538: return "BOX_DRAWINGS_UP_HEAVY_AND_HORIZONTAL_LIGHT";
        case   0x2539: return "BOX_DRAWINGS_RIGHT_LIGHT_AND_LEFT_UP_HEAVY";
        case   0x253A: return "BOX_DRAWINGS_LEFT_LIGHT_AND_RIGHT_UP_HEAVY";
        case   0x253B: return "BOX_DRAWINGS_HEAVY_UP_AND_HORIZONTAL";
        case   0x253C: return "BOX_DRAWINGS_LIGHT_VERTICAL_AND_HORIZONTAL";
        case   0x253D: return
                "BOX_DRAWINGS_LEFT_HEAVY_AND_RIGHT_VERTICAL_LIGHT";
        case   0x253E: return
                "BOX_DRAWINGS_RIGHT_HEAVY_AND_LEFT_VERTICAL_LIGHT";
        case   0x253F: return
                "BOX_DRAWINGS_VERTICAL_LIGHT_AND_HORIZONTAL_HEAVY";
        case   0x2540: return
                "BOX_DRAWINGS_UP_HEAVY_AND_DOWN_HORIZONTAL_LIGHT";
        case   0x2541: return
                "BOX_DRAWINGS_DOWN_HEAVY_AND_UP_HORIZONTAL_LIGHT";
        case   0x2542: return
                "BOX_DRAWINGS_VERTICAL_HEAVY_AND_HORIZONTAL_LIGHT";
        case   0x2543: return
                "BOX_DRAWINGS_LEFT_UP_HEAVY_AND_RIGHT_DOWN_LIGHT";
        case   0x2544: return
                "BOX_DRAWINGS_RIGHT_UP_HEAVY_AND_LEFT_DOWN_LIGHT";
        case   0x2545: return
                "BOX_DRAWINGS_LEFT_DOWN_HEAVY_AND_RIGHT_UP_LIGHT";
        case   0x2546: return
                "BOX_DRAWINGS_RIGHT_DOWN_HEAVY_AND_LEFT_UP_LIGHT";
        case   0x2547: return
                "BOX_DRAWINGS_DOWN_LIGHT_AND_UP_HORIZONTAL_HEAVY";
        case   0x2548: return
                "BOX_DRAWINGS_UP_LIGHT_AND_DOWN_HORIZONTAL_HEAVY";
        case   0x2549: return
                "BOX_DRAWINGS_RIGHT_LIGHT_AND_LEFT_VERTICAL_HEAVY";
        case   0x254A: return
                "BOX_DRAWINGS_LEFT_LIGHT_AND_RIGHT_VERTICAL_HEAVY";
        case   0x254B: return "BOX_DRAWINGS_HEAVY_VERTICAL_AND_HORIZONTAL";
        case   0x254C: return "BOX_DRAWINGS_LIGHT_DOUBLE_DASH_HORIZONTAL";
        case   0x254D: return "BOX_DRAWINGS_HEAVY_DOUBLE_DASH_HORIZONTAL";
        case   0x254E: return "BOX_DRAWINGS_LIGHT_DOUBLE_DASH_VERTICAL";
        case   0x254F: return "BOX_DRAWINGS_HEAVY_DOUBLE_DASH_VERTICAL";
        case   0x2550: return "BOX_DRAWINGS_DOUBLE_HORIZONTAL";
        case   0x2551: return "BOX_DRAWINGS_DOUBLE_VERTICAL";
        case   0x2552: return "BOX_DRAWINGS_DOWN_SINGLE_AND_RIGHT_DOUBLE";
        case   0x2553: return "BOX_DRAWINGS_DOWN_DOUBLE_AND_RIGHT_SINGLE";
        case   0x2554: return "BOX_DRAWINGS_DOUBLE_DOWN_AND_RIGHT";
        case   0x2555: return "BOX_DRAWINGS_DOWN_SINGLE_AND_LEFT_DOUBLE";
        case   0x2556: return "BOX_DRAWINGS_DOWN_DOUBLE_AND_LEFT_SINGLE";
        case   0x2557: return "BOX_DRAWINGS_DOUBLE_DOWN_AND_LEFT";
        case   0x2558: return "BOX_DRAWINGS_UP_SINGLE_AND_RIGHT_DOUBLE";
        case   0x2559: return "BOX_DRAWINGS_UP_DOUBLE_AND_RIGHT_SINGLE";
        case   0x255A: return "BOX_DRAWINGS_DOUBLE_UP_AND_RIGHT";
        case   0x255B: return "BOX_DRAWINGS_UP_SINGLE_AND_LEFT_DOUBLE";
        case   0x255C: return "BOX_DRAWINGS_UP_DOUBLE_AND_LEFT_SINGLE";
        case   0x255D: return "BOX_DRAWINGS_DOUBLE_UP_AND_LEFT";
        case   0x255E: return "BOX_DRAWINGS_VERTICAL_SINGLE_AND_RIGHT_DOUBLE";
        case   0x255F: return "BOX_DRAWINGS_VERTICAL_DOUBLE_AND_RIGHT_SINGLE";
        case   0x2560: return "BOX_DRAWINGS_DOUBLE_VERTICAL_AND_RIGHT";
        case   0x2561: return "BOX_DRAWINGS_VERTICAL_SINGLE_AND_LEFT_DOUBLE";
        case   0x2562: return "BOX_DRAWINGS_VERTICAL_DOUBLE_AND_LEFT_SINGLE";
        case   0x2563: return "BOX_DRAWINGS_DOUBLE_VERTICAL_AND_LEFT";
        case   0x2564: return
                "BOX_DRAWINGS_DOWN_SINGLE_AND_HORIZONTAL_DOUBLE";
        case   0x2565: return
                "BOX_DRAWINGS_DOWN_DOUBLE_AND_HORIZONTAL_SINGLE";
        case   0x2566: return "BOX_DRAWINGS_DOUBLE_DOWN_AND_HORIZONTAL";
        case   0x2567: return "BOX_DRAWINGS_UP_SINGLE_AND_HORIZONTAL_DOUBLE";
        case   0x2568: return "BOX_DRAWINGS_UP_DOUBLE_AND_HORIZONTAL_SINGLE";
        case   0x2569: return "BOX_DRAWINGS_DOUBLE_UP_AND_HORIZONTAL";
        case   0x256A: return
                "BOX_DRAWINGS_VERTICAL_SINGLE_AND_HORIZONTAL_DOUBLE";
        case   0x256B: return
                "BOX_DRAWINGS_VERTICAL_DOUBLE_AND_HORIZONTAL_SINGLE";
        case   0x256C: return "BOX_DRAWINGS_DOUBLE_VERTICAL_AND_HORIZONTAL";
        case   0x256D: return "BOX_DRAWINGS_LIGHT_ARC_DOWN_AND_RIGHT";
        case   0x256E: return "BOX_DRAWINGS_LIGHT_ARC_DOWN_AND_LEFT";
        case   0x256F: return "BOX_DRAWINGS_LIGHT_ARC_UP_AND_LEFT";
        case   0x2570: return "BOX_DRAWINGS_LIGHT_ARC_UP_AND_RIGHT";
        case   0x2571: return
                "BOX_DRAWINGS_LIGHT_DIAGONAL_UPPER_RIGHT_TO_LOWER_LEFT";
        case   0x2572: return
                "BOX_DRAWINGS_LIGHT_DIAGONAL_UPPER_LEFT_TO_LOWER_RIGHT";
        case   0x2573: return "BOX_DRAWINGS_LIGHT_DIAGONAL_CROSS";
        case   0x2574: return "BOX_DRAWINGS_LIGHT_LEFT";
        case   0x2575: return "BOX_DRAWINGS_LIGHT_UP";
        case   0x2576: return "BOX_DRAWINGS_LIGHT_RIGHT";
        case   0x2577: return "BOX_DRAWINGS_LIGHT_DOWN";
        case   0x2578: return "BOX_DRAWINGS_HEAVY_LEFT";
        case   0x2579: return "BOX_DRAWINGS_HEAVY_UP";
        case   0x257A: return "BOX_DRAWINGS_HEAVY_RIGHT";
        case   0x257B: return "BOX_DRAWINGS_HEAVY_DOWN";
        case   0x257C: return "BOX_DRAWINGS_LIGHT_LEFT_AND_HEAVY_RIGHT";
        case   0x257D: return "BOX_DRAWINGS_LIGHT_UP_AND_HEAVY_DOWN";
        case   0x257E: return "BOX_DRAWINGS_HEAVY_LEFT_AND_LIGHT_RIGHT";
        case   0x257F: return "BOX_DRAWINGS_HEAVY_UP_AND_LIGHT_DOWN";
        case   0x2580: return "UPPER_HALF_BLOCK";
        case   0x2581: return "LOWER_ONE_EIGHTH_BLOCK";
        case   0x2582: return "LOWER_ONE_QUARTER_BLOCK";
        case   0x2583: return "LOWER_THREE_EIGHTHS_BLOCK";
        case   0x2584: return "LOWER_HALF_BLOCK";
        case   0x2585: return "LOWER_FIVE_EIGHTHS_BLOCK";
        case   0x2586: return "LOWER_THREE_QUARTERS_BLOCK";
        case   0x2587: return "LOWER_SEVEN_EIGHTHS_BLOCK";
        case   0x2588: return "FULL_BLOCK";
        case   0x2589: return "LEFT_SEVEN_EIGHTHS_BLOCK";
        case   0x258A: return "LEFT_THREE_QUARTERS_BLOCK";
        case   0x258B: return "LEFT_FIVE_EIGHTHS_BLOCK";
        case   0x258C: return "LEFT_HALF_BLOCK";
        case   0x258D: return "LEFT_THREE_EIGHTHS_BLOCK";
        case   0x258E: return "LEFT_ONE_QUARTER_BLOCK";
        case   0x258F: return "LEFT_ONE_EIGHTH_BLOCK";
        case   0x2590: return "RIGHT_HALF_BLOCK";
        case   0x2591: return "LIGHT_SHADE";
        case   0x2592: return "MEDIUM_SHADE";
        case   0x2593: return "DARK_SHADE";
        case   0x2594: return "UPPER_ONE_EIGHTH_BLOCK";
        case   0x2595: return "RIGHT_ONE_EIGHTH_BLOCK";
        case   0x2596: return "QUADRANT_LOWER_LEFT";
        case   0x2597: return "QUADRANT_LOWER_RIGHT";
        case   0x2598: return "QUADRANT_UPPER_LEFT";
        case   0x2599: return
                "QUADRANT_UPPER_LEFT_AND_LOWER_LEFT_AND_LOWER_RIGHT";
        case   0x259A: return "QUADRANT_UPPER_LEFT_AND_LOWER_RIGHT";
        case   0x259B: return
                "QUADRANT_UPPER_LEFT_AND_UPPER_RIGHT_AND_LOWER_LEFT";
        case   0x259C: return
                "QUADRANT_UPPER_LEFT_AND_UPPER_RIGHT_AND_LOWER_RIGHT";
        case   0x259D: return "QUADRANT_UPPER_RIGHT";
        case   0x259E: return "QUADRANT_UPPER_RIGHT_AND_LOWER_LEFT";
        case   0x259F: return
                "QUADRANT_UPPER_RIGHT_AND_LOWER_LEFT_AND_LOWER_RIGHT";
        case   0x25A0: return "BLACK_SQUARE";
        case   0x25A1: return "WHITE_SQUARE";
        case   0x25A2: return "WHITE_SQUARE_WITH_ROUNDED_CORNERS";
        case   0x25A3: return "WHITE_SQUARE_CONTAINING_BLACK_SMALL_SQUARE";
        case   0x25A4: return "SQUARE_WITH_HORIZONTAL_FILL";
        case   0x25A5: return "SQUARE_WITH_VERTICAL_FILL";
        case   0x25A6: return "SQUARE_WITH_ORTHOGONAL_CROSSHATCH_FILL";
        case   0x25A7: return "SQUARE_WITH_UPPER_LEFT_TO_LOWER_RIGHT_FILL";
        case   0x25A8: return "SQUARE_WITH_UPPER_RIGHT_TO_LOWER_LEFT_FILL";
        case   0x25A9: return "SQUARE_WITH_DIAGONAL_CROSSHATCH_FILL";
        case   0x25AA: return "BLACK_SMALL_SQUARE";
        case   0x25AB: return "WHITE_SMALL_SQUARE";
        case   0x25AC: return "BLACK_RECTANGLE";
        case   0x25AD: return "WHITE_RECTANGLE";
        case   0x25AE: return "BLACK_VERTICAL_RECTANGLE";
        case   0x25AF: return "WHITE_VERTICAL_RECTANGLE";
        case   0x25B0: return "BLACK_PARALLELOGRAM";
        case   0x25B1: return "WHITE_PARALLELOGRAM";
        case   0x25B2: return "BLACK_UP_POINTING_TRIANGLE";
        case   0x25B3: return "WHITE_UP_POINTING_TRIANGLE";
        case   0x25B4: return "BLACK_UP_POINTING_SMALL_TRIANGLE";
        case   0x25B5: return "WHITE_UP_POINTING_SMALL_TRIANGLE";
        case   0x25B6: return "BLACK_RIGHT_POINTING_TRIANGLE";
        case   0x25B7: return "WHITE_RIGHT_POINTING_TRIANGLE";
        case   0x25B8: return "BLACK_RIGHT_POINTING_SMALL_TRIANGLE";
        case   0x25B9: return "WHITE_RIGHT_POINTING_SMALL_TRIANGLE";
        case   0x25BA: return "BLACK_RIGHT_POINTING_POINTER";
        case   0x25BB: return "WHITE_RIGHT_POINTING_POINTER";
        case   0x25BC: return "BLACK_DOWN_POINTING_TRIANGLE";
        case   0x25BD: return "WHITE_DOWN_POINTING_TRIANGLE";
        case   0x25BE: return "BLACK_DOWN_POINTING_SMALL_TRIANGLE";
        case   0x25BF: return "WHITE_DOWN_POINTING_SMALL_TRIANGLE";
        case   0x25C0: return "BLACK_LEFT_POINTING_TRIANGLE";
        case   0x25C1: return "WHITE_LEFT_POINTING_TRIANGLE";
        case   0x25C2: return "BLACK_LEFT_POINTING_SMALL_TRIANGLE";
        case   0x25C3: return "WHITE_LEFT_POINTING_SMALL_TRIANGLE";
        case   0x25C4: return "BLACK_LEFT_POINTING_POINTER";
        case   0x25C5: return "WHITE_LEFT_POINTING_POINTER";
        case   0x25C6: return "BLACK_DIAMOND";
        case   0x25C7: return "WHITE_DIAMOND";
        case   0x25C8: return "WHITE_DIAMOND_CONTAINING_BLACK_SMALL_DIAMOND";
        case   0x25C9: return "FISHEYE";
        case   0x25CA: return "LOZENGE";
        case   0x25CB: return "WHITE_CIRCLE";
        case   0x25CC: return "DOTTED_CIRCLE";
        case   0x25CD: return "CIRCLE_WITH_VERTICAL_FILL";
        case   0x25CE: return "BULLSEYE";
        case   0x25CF: return "BLACK_CIRCLE";
        case   0x25D0: return "CIRCLE_WITH_LEFT_HALF_BLACK";
        case   0x25D1: return "CIRCLE_WITH_RIGHT_HALF_BLACK";
        case   0x25D2: return "CIRCLE_WITH_LOWER_HALF_BLACK";
        case   0x25D3: return "CIRCLE_WITH_UPPER_HALF_BLACK";
        case   0x25D4: return "CIRCLE_WITH_UPPER_RIGHT_QUADRANT_BLACK";
        case   0x25D5: return "CIRCLE_WITH_ALL_BUT_UPPER_LEFT_QUADRANT_BLACK";
        case   0x25D6: return "LEFT_HALF_BLACK_CIRCLE";
        case   0x25D7: return "RIGHT_HALF_BLACK_CIRCLE";
        case   0x25D8: return "INVERSE_BULLET";
        case   0x25D9: return "INVERSE_WHITE_CIRCLE";
        case   0x25DA: return "UPPER_HALF_INVERSE_WHITE_CIRCLE";
        case   0x25DB: return "LOWER_HALF_INVERSE_WHITE_CIRCLE";
        case   0x25DC: return "UPPER_LEFT_QUADRANT_CIRCULAR_ARC";
        case   0x25DD: return "UPPER_RIGHT_QUADRANT_CIRCULAR_ARC";
        case   0x25DE: return "LOWER_RIGHT_QUADRANT_CIRCULAR_ARC";
        case   0x25DF: return "LOWER_LEFT_QUADRANT_CIRCULAR_ARC";
        case   0x25E0: return "UPPER_HALF_CIRCLE";
        case   0x25E1: return "LOWER_HALF_CIRCLE";
        case   0x25E2: return "BLACK_LOWER_RIGHT_TRIANGLE";
        case   0x25E3: return "BLACK_LOWER_LEFT_TRIANGLE";
        case   0x25E4: return "BLACK_UPPER_LEFT_TRIANGLE";
        case   0x25E5: return "BLACK_UPPER_RIGHT_TRIANGLE";
        case   0x25E6: return "WHITE_BULLET";
        case   0x25E7: return "SQUARE_WITH_LEFT_HALF_BLACK";
        case   0x25E8: return "SQUARE_WITH_RIGHT_HALF_BLACK";
        case   0x25E9: return "SQUARE_WITH_UPPER_LEFT_DIAGONAL_HALF_BLACK";
        case   0x25EA: return "SQUARE_WITH_LOWER_RIGHT_DIAGONAL_HALF_BLACK";
        case   0x25EB: return "WHITE_SQUARE_WITH_VERTICAL_BISECTING_LINE";
        case   0x25EC: return "WHITE_UP_POINTING_TRIANGLE_WITH_DOT";
        case   0x25ED: return "UP_POINTING_TRIANGLE_WITH_LEFT_HALF_BLACK";
        case   0x25EE: return "UP_POINTING_TRIANGLE_WITH_RIGHT_HALF_BLACK";
        case   0x25EF: return "LARGE_CIRCLE";
        case   0x25F0: return "WHITE_SQUARE_WITH_UPPER_LEFT_QUADRANT";
        case   0x25F1: return "WHITE_SQUARE_WITH_LOWER_LEFT_QUADRANT";
        case   0x25F2: return "WHITE_SQUARE_WITH_LOWER_RIGHT_QUADRANT";
        case   0x25F3: return "WHITE_SQUARE_WITH_UPPER_RIGHT_QUADRANT";
        case   0x25F4: return "WHITE_CIRCLE_WITH_UPPER_LEFT_QUADRANT";
        case   0x25F5: return "WHITE_CIRCLE_WITH_LOWER_LEFT_QUADRANT";
        case   0x25F6: return "WHITE_CIRCLE_WITH_LOWER_RIGHT_QUADRANT";
        case   0x25F7: return "WHITE_CIRCLE_WITH_UPPER_RIGHT_QUADRANT";
        case   0x25F8: return "UPPER_LEFT_TRIANGLE";
        case   0x25F9: return "UPPER_RIGHT_TRIANGLE";
        case   0x25FA: return "LOWER_LEFT_TRIANGLE";
        case   0x25FB: return "WHITE_MEDIUM_SQUARE";
        case   0x25FC: return "BLACK_MEDIUM_SQUARE";
        case   0x25FD: return "WHITE_MEDIUM_SMALL_SQUARE";
        case   0x25FE: return "BLACK_MEDIUM_SMALL_SQUARE";
        case   0x25FF: return "LOWER_RIGHT_TRIANGLE";
        case   0x2600: return "BLACK_SUN_WITH_RAYS";
        case   0x2601: return "CLOUD";
        case   0x2602: return "UMBRELLA";
        case   0x2603: return "SNOWMAN";
        case   0x2604: return "COMET";
        case   0x2605: return "BLACK_STAR";
        case   0x2606: return "WHITE_STAR";
        case   0x2607: return "LIGHTNING";
        case   0x2608: return "THUNDERSTORM";
        case   0x2609: return "SUN";
        case   0x260A: return "ASCENDING_NODE";
        case   0x260B: return "DESCENDING_NODE";
        case   0x260C: return "CONJUNCTION";
        case   0x260D: return "OPPOSITION";
        case   0x260E: return "BLACK_TELEPHONE";
        case   0x260F: return "WHITE_TELEPHONE";
        case   0x2610: return "BALLOT_BOX";
        case   0x2611: return "BALLOT_BOX_WITH_CHECK";
        case   0x2612: return "BALLOT_BOX_WITH_X";
        case   0x2613: return "SALTIRE";
        case   0x2614: return "UMBRELLA_WITH_RAIN_DROPS";
        case   0x2615: return "HOT_BEVERAGE";
        case   0x2616: return "WHITE_SHOGI_PIECE";
        case   0x2617: return "BLACK_SHOGI_PIECE";
        case   0x2618: return "SHAMROCK";
        case   0x2619: return "REVERSED_ROTATED_FLORAL_HEART_BULLET";
        case   0x261A: return "BLACK_LEFT_POINTING_INDEX";
        case   0x261B: return "BLACK_RIGHT_POINTING_INDEX";
        case   0x261C: return "WHITE_LEFT_POINTING_INDEX";
        case   0x261D: return "WHITE_UP_POINTING_INDEX";
        case   0x261E: return "WHITE_RIGHT_POINTING_INDEX";
        case   0x261F: return "WHITE_DOWN_POINTING_INDEX";
        case   0x2620: return "SKULL_AND_CROSSBONES";
        case   0x2621: return "CAUTION_SIGN";
        case   0x2622: return "RADIOACTIVE_SIGN";
        case   0x2623: return "BIOHAZARD_SIGN";
        case   0x2624: return "CADUCEUS";
        case   0x2625: return "ANKH";
        case   0x2626: return "ORTHODOX_CROSS";
        case   0x2627: return "CHI_RHO";
        case   0x2628: return "CROSS_OF_LORRAINE";
        case   0x2629: return "CROSS_OF_JERUSALEM";
        case   0x262A: return "STAR_AND_CRESCENT";
        case   0x262B: return "FARSI_SYMBOL";
        case   0x262C: return "ADI_SHAKTI";
        case   0x262D: return "HAMMER_AND_SICKLE";
        case   0x262E: return "PEACE_SYMBOL";
        case   0x262F: return "YIN_YANG";
        case   0x2630: return "TRIGRAM_FOR_HEAVEN";
        case   0x2631: return "TRIGRAM_FOR_LAKE";
        case   0x2632: return "TRIGRAM_FOR_FIRE";
        case   0x2633: return "TRIGRAM_FOR_THUNDER";
        case   0x2634: return "TRIGRAM_FOR_WIND";
        case   0x2635: return "TRIGRAM_FOR_WATER";
        case   0x2636: return "TRIGRAM_FOR_MOUNTAIN";
        case   0x2637: return "TRIGRAM_FOR_EARTH";
        case   0x2638: return "WHEEL_OF_DHARMA";
        case   0x2639: return "WHITE_FROWNING_FACE";
        case   0x263A: return "WHITE_SMILING_FACE";
        case   0x263B: return "BLACK_SMILING_FACE";
        case   0x263C: return "WHITE_SUN_WITH_RAYS";
        case   0x263D: return "FIRST_QUARTER_MOON";
        case   0x263E: return "LAST_QUARTER_MOON";
        case   0x263F: return "MERCURY";
        case   0x2640: return "FEMALE_SIGN";
        case   0x2641: return "EARTH";
        case   0x2642: return "MALE_SIGN";
        case   0x2643: return "JUPITER";
        case   0x2644: return "SATURN";
        case   0x2645: return "URANUS";
        case   0x2646: return "NEPTUNE";
        case   0x2647: return "PLUTO";
        case   0x2648: return "ARIES";
        case   0x2649: return "TAURUS";
        case   0x264A: return "GEMINI";
        case   0x264B: return "CANCER";
        case   0x264C: return "LEO";
        case   0x264D: return "VIRGO";
        case   0x264E: return "LIBRA";
        case   0x264F: return "SCORPIUS";
        case   0x2650: return "SAGITTARIUS";
        case   0x2651: return "CAPRICORN";
        case   0x2652: return "AQUARIUS";
        case   0x2653: return "PISCES";
        case   0x2654: return "WHITE_CHESS_KING";
        case   0x2655: return "WHITE_CHESS_QUEEN";
        case   0x2656: return "WHITE_CHESS_ROOK";
        case   0x2657: return "WHITE_CHESS_BISHOP";
        case   0x2658: return "WHITE_CHESS_KNIGHT";
        case   0x2659: return "WHITE_CHESS_PAWN";
        case   0x265A: return "BLACK_CHESS_KING";
        case   0x265B: return "BLACK_CHESS_QUEEN";
        case   0x265C: return "BLACK_CHESS_ROOK";
        case   0x265D: return "BLACK_CHESS_BISHOP";
        case   0x265E: return "BLACK_CHESS_KNIGHT";
        case   0x265F: return "BLACK_CHESS_PAWN";
        case   0x2660: return "BLACK_SPADE_SUIT";
        case   0x2661: return "WHITE_HEART_SUIT";
        case   0x2662: return "WHITE_DIAMOND_SUIT";
        case   0x2663: return "BLACK_CLUB_SUIT";
        case   0x2664: return "WHITE_SPADE_SUIT";
        case   0x2665: return "BLACK_HEART_SUIT";
        case   0x2666: return "BLACK_DIAMOND_SUIT";
        case   0x2667: return "WHITE_CLUB_SUIT";
        case   0x2668: return "HOT_SPRINGS";
        case   0x2669: return "QUARTER_NOTE";
        case   0x266A: return "EIGHTH_NOTE";
        case   0x266B: return "BEAMED_EIGHTH_NOTES";
        case   0x266C: return "BEAMED_SIXTEENTH_NOTES";
        case   0x266D: return "MUSIC_FLAT_SIGN";
        case   0x266E: return "MUSIC_NATURAL_SIGN";
        case   0x266F: return "MUSIC_SHARP_SIGN";
        case   0x2670: return "WEST_SYRIAC_CROSS";
        case   0x2671: return "EAST_SYRIAC_CROSS";
        case   0x2672: return "UNIVERSAL_RECYCLING_SYMBOL";
        case   0x2673: return "RECYCLING_SYMBOL_FOR_TYPE_1_PLASTICS";
        case   0x2674: return "RECYCLING_SYMBOL_FOR_TYPE_2_PLASTICS";
        case   0x2675: return "RECYCLING_SYMBOL_FOR_TYPE_3_PLASTICS";
        case   0x2676: return "RECYCLING_SYMBOL_FOR_TYPE_4_PLASTICS";
        case   0x2677: return "RECYCLING_SYMBOL_FOR_TYPE_5_PLASTICS";
        case   0x2678: return "RECYCLING_SYMBOL_FOR_TYPE_6_PLASTICS";
        case   0x2679: return "RECYCLING_SYMBOL_FOR_TYPE_7_PLASTICS";
        case   0x267A: return "RECYCLING_SYMBOL_FOR_GENERIC_MATERIALS";
        case   0x267B: return "BLACK_UNIVERSAL_RECYCLING_SYMBOL";
        case   0x267C: return "RECYCLED_PAPER_SYMBOL";
        case   0x267D: return "PARTIALLY_RECYCLED_PAPER_SYMBOL";
        case   0x267E: return "PERMANENT_PAPER_SIGN";
        case   0x267F: return "WHEELCHAIR_SYMBOL";
        case   0x2680: return "DIE_FACE_1";
        case   0x2681: return "DIE_FACE_2";
        case   0x2682: return "DIE_FACE_3";
        case   0x2683: return "DIE_FACE_4";
        case   0x2684: return "DIE_FACE_5";
        case   0x2685: return "DIE_FACE_6";
        case   0x2686: return "WHITE_CIRCLE_WITH_DOT_RIGHT";
        case   0x2687: return "WHITE_CIRCLE_WITH_TWO_DOTS";
        case   0x2688: return "BLACK_CIRCLE_WITH_WHITE_DOT_RIGHT";
        case   0x2689: return "BLACK_CIRCLE_WITH_TWO_WHITE_DOTS";
        case   0x268A: return "MONOGRAM_FOR_YANG";
        case   0x268B: return "MONOGRAM_FOR_YIN";
        case   0x268C: return "DIGRAM_FOR_GREATER_YANG";
        case   0x268D: return "DIGRAM_FOR_LESSER_YIN";
        case   0x268E: return "DIGRAM_FOR_LESSER_YANG";
        case   0x268F: return "DIGRAM_FOR_GREATER_YIN";
        case   0x2690: return "WHITE_FLAG";
        case   0x2691: return "BLACK_FLAG";
        case   0x2692: return "HAMMER_AND_PICK";
        case   0x2693: return "ANCHOR";
        case   0x2694: return "CROSSED_SWORDS";
        case   0x2695: return "STAFF_OF_AESCULAPIUS";
        case   0x2696: return "SCALES";
        case   0x2697: return "ALEMBIC";
        case   0x2698: return "FLOWER";
        case   0x2699: return "GEAR";
        case   0x269A: return "STAFF_OF_HERMES";
        case   0x269B: return "ATOM_SYMBOL";
        case   0x269C: return "FLEUR_DE_LIS";
        case   0x269D: return "OUTLINED_WHITE_STAR";
        case   0x269E: return "THREE_LINES_CONVERGING_RIGHT";
        case   0x269F: return "THREE_LINES_CONVERGING_LEFT";
        case   0x26A0: return "WARNING_SIGN";
        case   0x26A1: return "HIGH_VOLTAGE_SIGN";
        case   0x26A2: return "DOUBLED_FEMALE_SIGN";
        case   0x26A3: return "DOUBLED_MALE_SIGN";
        case   0x26A4: return "INTERLOCKED_FEMALE_AND_MALE_SIGN";
        case   0x26A5: return "MALE_AND_FEMALE_SIGN";
        case   0x26A6: return "MALE_WITH_STROKE_SIGN";
        case   0x26A7: return "MALE_WITH_STROKE_AND_MALE_AND_FEMALE_SIGN";
        case   0x26A8: return "VERTICAL_MALE_WITH_STROKE_SIGN";
        case   0x26A9: return "HORIZONTAL_MALE_WITH_STROKE_SIGN";
        case   0x26AA: return "MEDIUM_WHITE_CIRCLE";
        case   0x26AB: return "MEDIUM_BLACK_CIRCLE";
        case   0x26AC: return "MEDIUM_SMALL_WHITE_CIRCLE";
        case   0x26AD: return "MARRIAGE_SYMBOL";
        case   0x26AE: return "DIVORCE_SYMBOL";
        case   0x26AF: return "UNMARRIED_PARTNERSHIP_SYMBOL";
        case   0x26B0: return "COFFIN";
        case   0x26B1: return "FUNERAL_URN";
        case   0x26B2: return "NEUTER";
        case   0x26B3: return "CERES";
        case   0x26B4: return "PALLAS";
        case   0x26B5: return "JUNO";
        case   0x26B6: return "VESTA";
        case   0x26B7: return "CHIRON";
        case   0x26B8: return "BLACK_MOON_LILITH";
        case   0x26B9: return "SEXTILE";
        case   0x26BA: return "SEMISEXTILE";
        case   0x26BB: return "QUINCUNX";
        case   0x26BC: return "SESQUIQUADRATE";
        case   0x26BD: return "SOCCER_BALL";
        case   0x26BE: return "BASEBALL";
        case   0x26BF: return "SQUARED_KEY";
        case   0x26C0: return "WHITE_DRAUGHTS_MAN";
        case   0x26C1: return "WHITE_DRAUGHTS_KING";
        case   0x26C2: return "BLACK_DRAUGHTS_MAN";
        case   0x26C3: return "BLACK_DRAUGHTS_KING";
        case   0x26C4: return "SNOWMAN_WITHOUT_SNOW";
        case   0x26C5: return "SUN_BEHIND_CLOUD";
        case   0x26C6: return "RAIN";
        case   0x26C7: return "BLACK_SNOWMAN";
        case   0x26C8: return "THUNDER_CLOUD_AND_RAIN";
        case   0x26C9: return "TURNED_WHITE_SHOGI_PIECE";
        case   0x26CA: return "TURNED_BLACK_SHOGI_PIECE";
        case   0x26CB: return "WHITE_DIAMOND_IN_SQUARE";
        case   0x26CC: return "CROSSING_LANES";
        case   0x26CD: return "DISABLED_CAR";
        case   0x26CE: return "OPHIUCHUS";
        case   0x26CF: return "PICK";
        case   0x26D0: return "CAR_SLIDING";
        case   0x26D1: return "HELMET_WITH_WHITE_CROSS";
        case   0x26D2: return "CIRCLED_CROSSING_LANES";
        case   0x26D3: return "CHAINS";
        case   0x26D4: return "NO_ENTRY";
        case   0x26D5: return "ALTERNATE_ONE_WAY_LEFT_WAY_TRAFFIC";
        case   0x26D6: return "BLACK_TWO_WAY_LEFT_WAY_TRAFFIC";
        case   0x26D7: return "WHITE_TWO_WAY_LEFT_WAY_TRAFFIC";
        case   0x26D8: return "BLACK_LEFT_LANE_MERGE";
        case   0x26D9: return "WHITE_LEFT_LANE_MERGE";
        case   0x26DA: return "DRIVE_SLOW_SIGN";
        case   0x26DB: return "HEAVY_WHITE_DOWN_POINTING_TRIANGLE";
        case   0x26DC: return "LEFT_CLOSED_ENTRY";
        case   0x26DD: return "SQUARED_SALTIRE";
        case   0x26DE: return
                "FALLING_DIAGONAL_IN_WHITE_CIRCLE_IN_BLACK_SQUARE";
        case   0x26DF: return "BLACK_TRUCK";
        case   0x26E0: return "RESTRICTED_LEFT_ENTRY_1";
        case   0x26E1: return "RESTRICTED_LEFT_ENTRY_2";
        case   0x26E2: return "ASTRONOMICAL_SYMBOL_FOR_URANUS";
        case   0x26E3: return "HEAVY_CIRCLE_WITH_STROKE_AND_TWO_DOTS_ABOVE";
        case   0x26E4: return "PENTAGRAM";
        case   0x26E5: return "RIGHT_HANDED_INTERLACED_PENTAGRAM";
        case   0x26E6: return "LEFT_HANDED_INTERLACED_PENTAGRAM";
        case   0x26E7: return "INVERTED_PENTAGRAM";
        case   0x26E8: return "BLACK_CROSS_ON_SHIELD";
        case   0x26E9: return "SHINTO_SHRINE";
        case   0x26EA: return "CHURCH";
        case   0x26EB: return "CASTLE";
        case   0x26EC: return "HISTORIC_SITE";
        case   0x26ED: return "GEAR_WITHOUT_HUB";
        case   0x26EE: return "GEAR_WITH_HANDLES";
        case   0x26EF: return "MAP_SYMBOL_FOR_LIGHTHOUSE";
        case   0x26F0: return "MOUNTAIN";
        case   0x26F1: return "UMBRELLA_ON_GROUND";
        case   0x26F2: return "FOUNTAIN";
        case   0x26F3: return "FLAG_IN_HOLE";
        case   0x26F4: return "FERRY";
        case   0x26F5: return "SAILBOAT";
        case   0x26F6: return "SQUARE_FOUR_CORNERS";
        case   0x26F7: return "SKIER";
        case   0x26F8: return "ICE_SKATE";
        case   0x26F9: return "PERSON_WITH_BALL";
        case   0x26FA: return "TENT";
        case   0x26FB: return "JAPANESE_BANK_SYMBOL";
        case   0x26FC: return "HEADSTONE_GRAVEYARD_SYMBOL";
        case   0x26FD: return "FUEL_PUMP";
        case   0x26FE: return "CUP_ON_BLACK_SQUARE";
        case   0x26FF: return
                "WHITE_FLAG_WITH_HORIZONTAL_MIDDLE_BLACK_STRIPE";
        case   0x2700: return "BLACK_SAFETY_SCISSORS";
        case   0x2701: return "UPPER_BLADE_SCISSORS";
        case   0x2702: return "BLACK_SCISSORS";
        case   0x2703: return "LOWER_BLADE_SCISSORS";
        case   0x2704: return "WHITE_SCISSORS";
        case   0x2705: return "WHITE_HEAVY_CHECK_MARK";
        case   0x2706: return "TELEPHONE_LOCATION_SIGN";
        case   0x2707: return "TAPE_DRIVE";
        case   0x2708: return "AIRPLANE";
        case   0x2709: return "ENVELOPE";
        case   0x270A: return "RAISED_FIST";
        case   0x270B: return "RAISED_HAND";
        case   0x270C: return "VICTORY_HAND";
        case   0x270D: return "WRITING_HAND";
        case   0x270E: return "LOWER_RIGHT_PENCIL";
        case   0x270F: return "PENCIL";
        case   0x2710: return "UPPER_RIGHT_PENCIL";
        case   0x2711: return "WHITE_NIB";
        case   0x2712: return "BLACK_NIB";
        case   0x2713: return "CHECK_MARK";
        case   0x2714: return "HEAVY_CHECK_MARK";
        case   0x2715: return "MULTIPLICATION_X";
        case   0x2716: return "HEAVY_MULTIPLICATION_X";
        case   0x2717: return "BALLOT_X";
        case   0x2718: return "HEAVY_BALLOT_X";
        case   0x2719: return "OUTLINED_GREEK_CROSS";
        case   0x271A: return "HEAVY_GREEK_CROSS";
        case   0x271B: return "OPEN_CENTRE_CROSS";
        case   0x271C: return "HEAVY_OPEN_CENTRE_CROSS";
        case   0x271D: return "LATIN_CROSS";
        case   0x271E: return "SHADOWED_WHITE_LATIN_CROSS";
        case   0x271F: return "OUTLINED_LATIN_CROSS";
        case   0x2720: return "MALTESE_CROSS";
        case   0x2721: return "STAR_OF_DAVID";
        case   0x2722: return "FOUR_TEARDROP_SPOKED_ASTERISK";
        case   0x2723: return "FOUR_BALLOON_SPOKED_ASTERISK";
        case   0x2724: return "HEAVY_FOUR_BALLOON_SPOKED_ASTERISK";
        case   0x2725: return "FOUR_CLUB_SPOKED_ASTERISK";
        case   0x2726: return "BLACK_FOUR_POINTED_STAR";
        case   0x2727: return "WHITE_FOUR_POINTED_STAR";
        case   0x2728: return "SPARKLES";
        case   0x2729: return "STRESS_OUTLINED_WHITE_STAR";
        case   0x272A: return "CIRCLED_WHITE_STAR";
        case   0x272B: return "OPEN_CENTRE_BLACK_STAR";
        case   0x272C: return "BLACK_CENTRE_WHITE_STAR";
        case   0x272D: return "OUTLINED_BLACK_STAR";
        case   0x272E: return "HEAVY_OUTLINED_BLACK_STAR";
        case   0x272F: return "PINWHEEL_STAR";
        case   0x2730: return "SHADOWED_WHITE_STAR";
        case   0x2731: return "HEAVY_ASTERISK";
        case   0x2732: return "OPEN_CENTRE_ASTERISK";
        case   0x2733: return "EIGHT_SPOKED_ASTERISK";
        case   0x2734: return "EIGHT_POINTED_BLACK_STAR";
        case   0x2735: return "EIGHT_POINTED_PINWHEEL_STAR";
        case   0x2736: return "SIX_POINTED_BLACK_STAR";
        case   0x2737: return "EIGHT_POINTED_RECTILINEAR_BLACK_STAR";
        case   0x2738: return "HEAVY_EIGHT_POINTED_RECTILINEAR_BLACK_STAR";
        case   0x2739: return "TWELVE_POINTED_BLACK_STAR";
        case   0x273A: return "SIXTEEN_POINTED_ASTERISK";
        case   0x273B: return "TEARDROP_SPOKED_ASTERISK";
        case   0x273C: return "OPEN_CENTRE_TEARDROP_SPOKED_ASTERISK";
        case   0x273D: return "HEAVY_TEARDROP_SPOKED_ASTERISK";
        case   0x273E: return "SIX_PETALLED_BLACK_AND_WHITE_FLORETTE";
        case   0x273F: return "BLACK_FLORETTE";
        case   0x2740: return "WHITE_FLORETTE";
        case   0x2741: return "EIGHT_PETALLED_OUTLINED_BLACK_FLORETTE";
        case   0x2742: return "CIRCLED_OPEN_CENTRE_EIGHT_POINTED_STAR";
        case   0x2743: return "HEAVY_TEARDROP_SPOKED_PINWHEEL_ASTERISK";
        case   0x2744: return "SNOWFLAKE";
        case   0x2745: return "TIGHT_TRIFOLIATE_SNOWFLAKE";
        case   0x2746: return "HEAVY_CHEVRON_SNOWFLAKE";
        case   0x2747: return "SPARKLE";
        case   0x2748: return "HEAVY_SPARKLE";
        case   0x2749: return "BALLOON_SPOKED_ASTERISK";
        case   0x274A: return "EIGHT_TEARDROP_SPOKED_PROPELLER_ASTERISK";
        case   0x274B: return
                "HEAVY_EIGHT_TEARDROP_SPOKED_PROPELLER_ASTERISK";
        case   0x274C: return "CROSS_MARK";
        case   0x274D: return "SHADOWED_WHITE_CIRCLE";
        case   0x274E: return "NEGATIVE_SQUARED_CROSS_MARK";
        case   0x274F: return "LOWER_RIGHT_DROP_SHADOWED_WHITE_SQUARE";
        case   0x2750: return "UPPER_RIGHT_DROP_SHADOWED_WHITE_SQUARE";
        case   0x2751: return "LOWER_RIGHT_SHADOWED_WHITE_SQUARE";
        case   0x2752: return "UPPER_RIGHT_SHADOWED_WHITE_SQUARE";
        case   0x2753: return "BLACK_QUESTION_MARK_ORNAMENT";
        case   0x2754: return "WHITE_QUESTION_MARK_ORNAMENT";
        case   0x2755: return "WHITE_EXCLAMATION_MARK_ORNAMENT";
        case   0x2756: return "BLACK_DIAMOND_MINUS_WHITE_X";
        case   0x2757: return "HEAVY_EXCLAMATION_MARK_SYMBOL";
        case   0x2758: return "LIGHT_VERTICAL_BAR";
        case   0x2759: return "MEDIUM_VERTICAL_BAR";
        case   0x275A: return "HEAVY_VERTICAL_BAR";
        case   0x275B: return
                "HEAVY_SINGLE_TURNED_COMMA_QUOTATION_MARK_ORNAMENT";
        case   0x275C: return "HEAVY_SINGLE_COMMA_QUOTATION_MARK_ORNAMENT";
        case   0x275D: return
                "HEAVY_DOUBLE_TURNED_COMMA_QUOTATION_MARK_ORNAMENT";
        case   0x275E: return "HEAVY_DOUBLE_COMMA_QUOTATION_MARK_ORNAMENT";
        case   0x275F: return
                "HEAVY_LOW_SINGLE_COMMA_QUOTATION_MARK_ORNAMENT";
        case   0x2760: return
                "HEAVY_LOW_DOUBLE_COMMA_QUOTATION_MARK_ORNAMENT";
        case   0x2761: return "CURVED_STEM_PARAGRAPH_SIGN_ORNAMENT";
        case   0x2762: return "HEAVY_EXCLAMATION_MARK_ORNAMENT";
        case   0x2763: return "HEAVY_HEART_EXCLAMATION_MARK_ORNAMENT";
        case   0x2764: return "HEAVY_BLACK_HEART";
        case   0x2765: return "ROTATED_HEAVY_BLACK_HEART_BULLET";
        case   0x2766: return "FLORAL_HEART";
        case   0x2767: return "ROTATED_FLORAL_HEART_BULLET";
        case   0x2768: return "MEDIUM_LEFT_PARENTHESIS_ORNAMENT";
        case   0x2769: return "MEDIUM_RIGHT_PARENTHESIS_ORNAMENT";
        case   0x276A: return "MEDIUM_FLATTENED_LEFT_PARENTHESIS_ORNAMENT";
        case   0x276B: return "MEDIUM_FLATTENED_RIGHT_PARENTHESIS_ORNAMENT";
        case   0x276C: return "MEDIUM_LEFT_POINTING_ANGLE_BRACKET_ORNAMENT";
        case   0x276D: return "MEDIUM_RIGHT_POINTING_ANGLE_BRACKET_ORNAMENT";
        case   0x276E: return
                "HEAVY_LEFT_POINTING_ANGLE_QUOTATION_MARK_ORNAMENT";
        case   0x276F: return
                "HEAVY_RIGHT_POINTING_ANGLE_QUOTATION_MARK_ORNAMENT";
        case   0x2770: return "HEAVY_LEFT_POINTING_ANGLE_BRACKET_ORNAMENT";
        case   0x2771: return "HEAVY_RIGHT_POINTING_ANGLE_BRACKET_ORNAMENT";
        case   0x2772: return "LIGHT_LEFT_TORTOISE_SHELL_BRACKET_ORNAMENT";
        case   0x2773: return "LIGHT_RIGHT_TORTOISE_SHELL_BRACKET_ORNAMENT";
        case   0x2774: return "MEDIUM_LEFT_CURLY_BRACKET_ORNAMENT";
        case   0x2775: return "MEDIUM_RIGHT_CURLY_BRACKET_ORNAMENT";
        case   0x2776: return "DINGBAT_NEGATIVE_CIRCLED_DIGIT_ONE";
        case   0x2777: return "DINGBAT_NEGATIVE_CIRCLED_DIGIT_TWO";
        case   0x2778: return "DINGBAT_NEGATIVE_CIRCLED_DIGIT_THREE";
        case   0x2779: return "DINGBAT_NEGATIVE_CIRCLED_DIGIT_FOUR";
        case   0x277A: return "DINGBAT_NEGATIVE_CIRCLED_DIGIT_FIVE";
        case   0x277B: return "DINGBAT_NEGATIVE_CIRCLED_DIGIT_SIX";
        case   0x277C: return "DINGBAT_NEGATIVE_CIRCLED_DIGIT_SEVEN";
        case   0x277D: return "DINGBAT_NEGATIVE_CIRCLED_DIGIT_EIGHT";
        case   0x277E: return "DINGBAT_NEGATIVE_CIRCLED_DIGIT_NINE";
        case   0x277F: return "DINGBAT_NEGATIVE_CIRCLED_NUMBER_TEN";
        case   0x2780: return "DINGBAT_CIRCLED_SANS_SERIF_DIGIT_ONE";
        case   0x2781: return "DINGBAT_CIRCLED_SANS_SERIF_DIGIT_TWO";
        case   0x2782: return "DINGBAT_CIRCLED_SANS_SERIF_DIGIT_THREE";
        case   0x2783: return "DINGBAT_CIRCLED_SANS_SERIF_DIGIT_FOUR";
        case   0x2784: return "DINGBAT_CIRCLED_SANS_SERIF_DIGIT_FIVE";
        case   0x2785: return "DINGBAT_CIRCLED_SANS_SERIF_DIGIT_SIX";
        case   0x2786: return "DINGBAT_CIRCLED_SANS_SERIF_DIGIT_SEVEN";
        case   0x2787: return "DINGBAT_CIRCLED_SANS_SERIF_DIGIT_EIGHT";
        case   0x2788: return "DINGBAT_CIRCLED_SANS_SERIF_DIGIT_NINE";
        case   0x2789: return "DINGBAT_CIRCLED_SANS_SERIF_NUMBER_TEN";
        case   0x278A: return "DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_DIGIT_ONE";
        case   0x278B: return "DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_DIGIT_TWO";
        case   0x278C: return
                "DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_DIGIT_THREE";
        case   0x278D: return
                "DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_DIGIT_FOUR";
        case   0x278E: return
                "DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_DIGIT_FIVE";
        case   0x278F: return "DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_DIGIT_SIX";
        case   0x2790: return
                "DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_DIGIT_SEVEN";
        case   0x2791: return
                "DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_DIGIT_EIGHT";
        case   0x2792: return
                "DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_DIGIT_NINE";
        case   0x2793: return
                "DINGBAT_NEGATIVE_CIRCLED_SANS_SERIF_NUMBER_TEN";
        case   0x2794: return "HEAVY_WIDE_HEADED_RIGHTWARDS_ARROW";
        case   0x2795: return "HEAVY_PLUS_SIGN";
        case   0x2796: return "HEAVY_MINUS_SIGN";
        case   0x2797: return "HEAVY_DIVISION_SIGN";
        case   0x2798: return "HEAVY_SOUTH_EAST_ARROW";
        case   0x2799: return "HEAVY_RIGHTWARDS_ARROW";
        case   0x279A: return "HEAVY_NORTH_EAST_ARROW";
        case   0x279B: return "DRAFTING_POINT_RIGHTWARDS_ARROW";
        case   0x279C: return "HEAVY_ROUND_TIPPED_RIGHTWARDS_ARROW";
        case   0x279D: return "TRIANGLE_HEADED_RIGHTWARDS_ARROW";
        case   0x279E: return "HEAVY_TRIANGLE_HEADED_RIGHTWARDS_ARROW";
        case   0x279F: return "DASHED_TRIANGLE_HEADED_RIGHTWARDS_ARROW";
        case   0x27A0: return "HEAVY_DASHED_TRIANGLE_HEADED_RIGHTWARDS_ARROW";
        case   0x27A1: return "BLACK_RIGHTWARDS_ARROW";
        case   0x27A2: return "THREE_D_TOP_LIGHTED_RIGHTWARDS_ARROWHEAD";
        case   0x27A3: return "THREE_D_BOTTOM_LIGHTED_RIGHTWARDS_ARROWHEAD";
        case   0x27A4: return "BLACK_RIGHTWARDS_ARROWHEAD";
        case   0x27A5: return
                "HEAVY_BLACK_CURVED_DOWNWARDS_AND_RIGHTWARDS_ARROW";
        case   0x27A6: return
                "HEAVY_BLACK_CURVED_UPWARDS_AND_RIGHTWARDS_ARROW";
        case   0x27A7: return "SQUAT_BLACK_RIGHTWARDS_ARROW";
        case   0x27A8: return "HEAVY_CONCAVE_POINTED_BLACK_RIGHTWARDS_ARROW";
        case   0x27A9: return "RIGHT_SHADED_WHITE_RIGHTWARDS_ARROW";
        case   0x27AA: return "LEFT_SHADED_WHITE_RIGHTWARDS_ARROW";
        case   0x27AB: return "BACK_TILTED_SHADOWED_WHITE_RIGHTWARDS_ARROW";
        case   0x27AC: return "FRONT_TILTED_SHADOWED_WHITE_RIGHTWARDS_ARROW";
        case   0x27AD: return
                "HEAVY_LOWER_RIGHT_SHADOWED_WHITE_RIGHTWARDS_ARROW";
        case   0x27AE: return
                "HEAVY_UPPER_RIGHT_SHADOWED_WHITE_RIGHTWARDS_ARROW";
        case   0x27AF: return
                "NOTCHED_LOWER_RIGHT_SHADOWED_WHITE_RIGHTWARDS_ARROW";
        case   0x27B0: return "CURLY_LOOP";
        case   0x27B1: return
                "NOTCHED_UPPER_RIGHT_SHADOWED_WHITE_RIGHTWARDS_ARROW";
        case   0x27B2: return "CIRCLED_HEAVY_WHITE_RIGHTWARDS_ARROW";
        case   0x27B3: return "WHITE_FEATHERED_RIGHTWARDS_ARROW";
        case   0x27B4: return "BLACK_FEATHERED_SOUTH_EAST_ARROW";
        case   0x27B5: return "BLACK_FEATHERED_RIGHTWARDS_ARROW";
        case   0x27B6: return "BLACK_FEATHERED_NORTH_EAST_ARROW";
        case   0x27B7: return "HEAVY_BLACK_FEATHERED_SOUTH_EAST_ARROW";
        case   0x27B8: return "HEAVY_BLACK_FEATHERED_RIGHTWARDS_ARROW";
        case   0x27B9: return "HEAVY_BLACK_FEATHERED_NORTH_EAST_ARROW";
        case   0x27BA: return "TEARDROP_BARBED_RIGHTWARDS_ARROW";
        case   0x27BB: return "HEAVY_TEARDROP_SHANKED_RIGHTWARDS_ARROW";
        case   0x27BC: return "WEDGE_TAILED_RIGHTWARDS_ARROW";
        case   0x27BD: return "HEAVY_WEDGE_TAILED_RIGHTWARDS_ARROW";
        case   0x27BE: return "OPEN_OUTLINED_RIGHTWARDS_ARROW";
        case   0x27BF: return "DOUBLE_CURLY_LOOP";
        case   0x27C0: return "THREE_DIMENSIONAL_ANGLE";
        case   0x27C1: return
                "WHITE_TRIANGLE_CONTAINING_SMALL_WHITE_TRIANGLE";
        case   0x27C2: return "PERPENDICULAR";
        case   0x27C3: return "OPEN_SUBSET";
        case   0x27C4: return "OPEN_SUPERSET";
        case   0x27C5: return "LEFT_S_SHAPED_BAG_DELIMITER";
        case   0x27C6: return "RIGHT_S_SHAPED_BAG_DELIMITER";
        case   0x27C7: return "OR_WITH_DOT_INSIDE";
        case   0x27C8: return "REVERSE_SOLIDUS_PRECEDING_SUBSET";
        case   0x27C9: return "SUPERSET_PRECEDING_SOLIDUS";
        case   0x27CA: return "VERTICAL_BAR_WITH_HORIZONTAL_STROKE";
        case   0x27CB: return "MATHEMATICAL_RISING_DIAGONAL";
        case   0x27CC: return "LONG_DIVISION";
        case   0x27CD: return "MATHEMATICAL_FALLING_DIAGONAL";
        case   0x27CE: return "SQUARED_LOGICAL_AND";
        case   0x27CF: return "SQUARED_LOGICAL_OR";
        case   0x27D0: return "WHITE_DIAMOND_WITH_CENTRED_DOT";
        case   0x27D1: return "AND_WITH_DOT";
        case   0x27D2: return "ELEMENT_OF_OPENING_UPWARDS";
        case   0x27D3: return "LOWER_RIGHT_CORNER_WITH_DOT";
        case   0x27D4: return "UPPER_LEFT_CORNER_WITH_DOT";
        case   0x27D5: return "LEFT_OUTER_JOIN";
        case   0x27D6: return "RIGHT_OUTER_JOIN";
        case   0x27D7: return "FULL_OUTER_JOIN";
        case   0x27D8: return "LARGE_UP_TACK";
        case   0x27D9: return "LARGE_DOWN_TACK";
        case   0x27DA: return "LEFT_AND_RIGHT_DOUBLE_TURNSTILE";
        case   0x27DB: return "LEFT_AND_RIGHT_TACK";
        case   0x27DC: return "LEFT_MULTIMAP";
        case   0x27DD: return "LONG_RIGHT_TACK";
        case   0x27DE: return "LONG_LEFT_TACK";
        case   0x27DF: return "UP_TACK_WITH_CIRCLE_ABOVE";
        case   0x27E0: return "LOZENGE_DIVIDED_BY_HORIZONTAL_RULE";
        case   0x27E1: return "WHITE_CONCAVE_SIDED_DIAMOND";
        case   0x27E2: return
                "WHITE_CONCAVE_SIDED_DIAMOND_WITH_LEFTWARDS_TICK";
        case   0x27E3: return
                "WHITE_CONCAVE_SIDED_DIAMOND_WITH_RIGHTWARDS_TICK";
        case   0x27E4: return "WHITE_SQUARE_WITH_LEFTWARDS_TICK";
        case   0x27E5: return "WHITE_SQUARE_WITH_RIGHTWARDS_TICK";
        case   0x27E6: return "MATHEMATICAL_LEFT_WHITE_SQUARE_BRACKET";
        case   0x27E7: return "MATHEMATICAL_RIGHT_WHITE_SQUARE_BRACKET";
        case   0x27E8: return "MATHEMATICAL_LEFT_ANGLE_BRACKET";
        case   0x27E9: return "MATHEMATICAL_RIGHT_ANGLE_BRACKET";
        case   0x27EA: return "MATHEMATICAL_LEFT_DOUBLE_ANGLE_BRACKET";
        case   0x27EB: return "MATHEMATICAL_RIGHT_DOUBLE_ANGLE_BRACKET";
        case   0x27EC: return
                "MATHEMATICAL_LEFT_WHITE_TORTOISE_SHELL_BRACKET";
        case   0x27ED: return
                "MATHEMATICAL_RIGHT_WHITE_TORTOISE_SHELL_BRACKET";
        case   0x27EE: return "MATHEMATICAL_LEFT_FLATTENED_PARENTHESIS";
        case   0x27EF: return "MATHEMATICAL_RIGHT_FLATTENED_PARENTHESIS";
        case   0x27F0: return "UPWARDS_QUADRUPLE_ARROW";
        case   0x27F1: return "DOWNWARDS_QUADRUPLE_ARROW";
        case   0x27F2: return "ANTICLOCKWISE_GAPPED_CIRCLE_ARROW";
        case   0x27F3: return "CLOCKWISE_GAPPED_CIRCLE_ARROW";
        case   0x27F4: return "RIGHT_ARROW_WITH_CIRCLED_PLUS";
        case   0x27F5: return "LONG_LEFTWARDS_ARROW";
        case   0x27F6: return "LONG_RIGHTWARDS_ARROW";
        case   0x27F7: return "LONG_LEFT_RIGHT_ARROW";
        case   0x27F8: return "LONG_LEFTWARDS_DOUBLE_ARROW";
        case   0x27F9: return "LONG_RIGHTWARDS_DOUBLE_ARROW";
        case   0x27FA: return "LONG_LEFT_RIGHT_DOUBLE_ARROW";
        case   0x27FB: return "LONG_LEFTWARDS_ARROW_FROM_BAR";
        case   0x27FC: return "LONG_RIGHTWARDS_ARROW_FROM_BAR";
        case   0x27FD: return "LONG_LEFTWARDS_DOUBLE_ARROW_FROM_BAR";
        case   0x27FE: return "LONG_RIGHTWARDS_DOUBLE_ARROW_FROM_BAR";
        case   0x27FF: return "LONG_RIGHTWARDS_SQUIGGLE_ARROW";
        case   0x2800: return "BRAILLE_PATTERN_BLANK";
        case   0x2801: return "BRAILLE_PATTERN_DOTS_1";
        case   0x2802: return "BRAILLE_PATTERN_DOTS_2";
        case   0x2803: return "BRAILLE_PATTERN_DOTS_12";
        case   0x2804: return "BRAILLE_PATTERN_DOTS_3";
        case   0x2805: return "BRAILLE_PATTERN_DOTS_13";
        case   0x2806: return "BRAILLE_PATTERN_DOTS_23";
        case   0x2807: return "BRAILLE_PATTERN_DOTS_123";
        case   0x2808: return "BRAILLE_PATTERN_DOTS_4";
        case   0x2809: return "BRAILLE_PATTERN_DOTS_14";
        case   0x280A: return "BRAILLE_PATTERN_DOTS_24";
        case   0x280B: return "BRAILLE_PATTERN_DOTS_124";
        case   0x280C: return "BRAILLE_PATTERN_DOTS_34";
        case   0x280D: return "BRAILLE_PATTERN_DOTS_134";
        case   0x280E: return "BRAILLE_PATTERN_DOTS_234";
        case   0x280F: return "BRAILLE_PATTERN_DOTS_1234";
        case   0x2810: return "BRAILLE_PATTERN_DOTS_5";
        case   0x2811: return "BRAILLE_PATTERN_DOTS_15";
        case   0x2812: return "BRAILLE_PATTERN_DOTS_25";
        case   0x2813: return "BRAILLE_PATTERN_DOTS_125";
        case   0x2814: return "BRAILLE_PATTERN_DOTS_35";
        case   0x2815: return "BRAILLE_PATTERN_DOTS_135";
        case   0x2816: return "BRAILLE_PATTERN_DOTS_235";
        case   0x2817: return "BRAILLE_PATTERN_DOTS_1235";
        case   0x2818: return "BRAILLE_PATTERN_DOTS_45";
        case   0x2819: return "BRAILLE_PATTERN_DOTS_145";
        case   0x281A: return "BRAILLE_PATTERN_DOTS_245";
        case   0x281B: return "BRAILLE_PATTERN_DOTS_1245";
        case   0x281C: return "BRAILLE_PATTERN_DOTS_345";
        case   0x281D: return "BRAILLE_PATTERN_DOTS_1345";
        case   0x281E: return "BRAILLE_PATTERN_DOTS_2345";
        case   0x281F: return "BRAILLE_PATTERN_DOTS_12345";
        case   0x2820: return "BRAILLE_PATTERN_DOTS_6";
        case   0x2821: return "BRAILLE_PATTERN_DOTS_16";
        case   0x2822: return "BRAILLE_PATTERN_DOTS_26";
        case   0x2823: return "BRAILLE_PATTERN_DOTS_126";
        case   0x2824: return "BRAILLE_PATTERN_DOTS_36";
        case   0x2825: return "BRAILLE_PATTERN_DOTS_136";
        case   0x2826: return "BRAILLE_PATTERN_DOTS_236";
        case   0x2827: return "BRAILLE_PATTERN_DOTS_1236";
        case   0x2828: return "BRAILLE_PATTERN_DOTS_46";
        case   0x2829: return "BRAILLE_PATTERN_DOTS_146";
        case   0x282A: return "BRAILLE_PATTERN_DOTS_246";
        case   0x282B: return "BRAILLE_PATTERN_DOTS_1246";
        case   0x282C: return "BRAILLE_PATTERN_DOTS_346";
        case   0x282D: return "BRAILLE_PATTERN_DOTS_1346";
        case   0x282E: return "BRAILLE_PATTERN_DOTS_2346";
        case   0x282F: return "BRAILLE_PATTERN_DOTS_12346";
        case   0x2830: return "BRAILLE_PATTERN_DOTS_56";
        case   0x2831: return "BRAILLE_PATTERN_DOTS_156";
        case   0x2832: return "BRAILLE_PATTERN_DOTS_256";
        case   0x2833: return "BRAILLE_PATTERN_DOTS_1256";
        case   0x2834: return "BRAILLE_PATTERN_DOTS_356";
        case   0x2835: return "BRAILLE_PATTERN_DOTS_1356";
        case   0x2836: return "BRAILLE_PATTERN_DOTS_2356";
        case   0x2837: return "BRAILLE_PATTERN_DOTS_12356";
        case   0x2838: return "BRAILLE_PATTERN_DOTS_456";
        case   0x2839: return "BRAILLE_PATTERN_DOTS_1456";
        case   0x283A: return "BRAILLE_PATTERN_DOTS_2456";
        case   0x283B: return "BRAILLE_PATTERN_DOTS_12456";
        case   0x283C: return "BRAILLE_PATTERN_DOTS_3456";
        case   0x283D: return "BRAILLE_PATTERN_DOTS_13456";
        case   0x283E: return "BRAILLE_PATTERN_DOTS_23456";
        case   0x283F: return "BRAILLE_PATTERN_DOTS_123456";
        case   0x2840: return "BRAILLE_PATTERN_DOTS_7";
        case   0x2841: return "BRAILLE_PATTERN_DOTS_17";
        case   0x2842: return "BRAILLE_PATTERN_DOTS_27";
        case   0x2843: return "BRAILLE_PATTERN_DOTS_127";
        case   0x2844: return "BRAILLE_PATTERN_DOTS_37";
        case   0x2845: return "BRAILLE_PATTERN_DOTS_137";
        case   0x2846: return "BRAILLE_PATTERN_DOTS_237";
        case   0x2847: return "BRAILLE_PATTERN_DOTS_1237";
        case   0x2848: return "BRAILLE_PATTERN_DOTS_47";
        case   0x2849: return "BRAILLE_PATTERN_DOTS_147";
        case   0x284A: return "BRAILLE_PATTERN_DOTS_247";
        case   0x284B: return "BRAILLE_PATTERN_DOTS_1247";
        case   0x284C: return "BRAILLE_PATTERN_DOTS_347";
        case   0x284D: return "BRAILLE_PATTERN_DOTS_1347";
        case   0x284E: return "BRAILLE_PATTERN_DOTS_2347";
        case   0x284F: return "BRAILLE_PATTERN_DOTS_12347";
        case   0x2850: return "BRAILLE_PATTERN_DOTS_57";
        case   0x2851: return "BRAILLE_PATTERN_DOTS_157";
        case   0x2852: return "BRAILLE_PATTERN_DOTS_257";
        case   0x2853: return "BRAILLE_PATTERN_DOTS_1257";
        case   0x2854: return "BRAILLE_PATTERN_DOTS_357";
        case   0x2855: return "BRAILLE_PATTERN_DOTS_1357";
        case   0x2856: return "BRAILLE_PATTERN_DOTS_2357";
        case   0x2857: return "BRAILLE_PATTERN_DOTS_12357";
        case   0x2858: return "BRAILLE_PATTERN_DOTS_457";
        case   0x2859: return "BRAILLE_PATTERN_DOTS_1457";
        case   0x285A: return "BRAILLE_PATTERN_DOTS_2457";
        case   0x285B: return "BRAILLE_PATTERN_DOTS_12457";
        case   0x285C: return "BRAILLE_PATTERN_DOTS_3457";
        case   0x285D: return "BRAILLE_PATTERN_DOTS_13457";
        case   0x285E: return "BRAILLE_PATTERN_DOTS_23457";
        case   0x285F: return "BRAILLE_PATTERN_DOTS_123457";
        case   0x2860: return "BRAILLE_PATTERN_DOTS_67";
        case   0x2861: return "BRAILLE_PATTERN_DOTS_167";
        case   0x2862: return "BRAILLE_PATTERN_DOTS_267";
        case   0x2863: return "BRAILLE_PATTERN_DOTS_1267";
        case   0x2864: return "BRAILLE_PATTERN_DOTS_367";
        case   0x2865: return "BRAILLE_PATTERN_DOTS_1367";
        case   0x2866: return "BRAILLE_PATTERN_DOTS_2367";
        case   0x2867: return "BRAILLE_PATTERN_DOTS_12367";
        case   0x2868: return "BRAILLE_PATTERN_DOTS_467";
        case   0x2869: return "BRAILLE_PATTERN_DOTS_1467";
        case   0x286A: return "BRAILLE_PATTERN_DOTS_2467";
        case   0x286B: return "BRAILLE_PATTERN_DOTS_12467";
        case   0x286C: return "BRAILLE_PATTERN_DOTS_3467";
        case   0x286D: return "BRAILLE_PATTERN_DOTS_13467";
        case   0x286E: return "BRAILLE_PATTERN_DOTS_23467";
        case   0x286F: return "BRAILLE_PATTERN_DOTS_123467";
        case   0x2870: return "BRAILLE_PATTERN_DOTS_567";
        case   0x2871: return "BRAILLE_PATTERN_DOTS_1567";
        case   0x2872: return "BRAILLE_PATTERN_DOTS_2567";
        case   0x2873: return "BRAILLE_PATTERN_DOTS_12567";
        case   0x2874: return "BRAILLE_PATTERN_DOTS_3567";
        case   0x2875: return "BRAILLE_PATTERN_DOTS_13567";
        case   0x2876: return "BRAILLE_PATTERN_DOTS_23567";
        case   0x2877: return "BRAILLE_PATTERN_DOTS_123567";
        case   0x2878: return "BRAILLE_PATTERN_DOTS_4567";
        case   0x2879: return "BRAILLE_PATTERN_DOTS_14567";
        case   0x287A: return "BRAILLE_PATTERN_DOTS_24567";
        case   0x287B: return "BRAILLE_PATTERN_DOTS_124567";
        case   0x287C: return "BRAILLE_PATTERN_DOTS_34567";
        case   0x287D: return "BRAILLE_PATTERN_DOTS_134567";
        case   0x287E: return "BRAILLE_PATTERN_DOTS_234567";
        case   0x287F: return "BRAILLE_PATTERN_DOTS_1234567";
        case   0x2880: return "BRAILLE_PATTERN_DOTS_8";
        case   0x2881: return "BRAILLE_PATTERN_DOTS_18";
        case   0x2882: return "BRAILLE_PATTERN_DOTS_28";
        case   0x2883: return "BRAILLE_PATTERN_DOTS_128";
        case   0x2884: return "BRAILLE_PATTERN_DOTS_38";
        case   0x2885: return "BRAILLE_PATTERN_DOTS_138";
        case   0x2886: return "BRAILLE_PATTERN_DOTS_238";
        case   0x2887: return "BRAILLE_PATTERN_DOTS_1238";
        case   0x2888: return "BRAILLE_PATTERN_DOTS_48";
        case   0x2889: return "BRAILLE_PATTERN_DOTS_148";
        case   0x288A: return "BRAILLE_PATTERN_DOTS_248";
        case   0x288B: return "BRAILLE_PATTERN_DOTS_1248";
        case   0x288C: return "BRAILLE_PATTERN_DOTS_348";
        case   0x288D: return "BRAILLE_PATTERN_DOTS_1348";
        case   0x288E: return "BRAILLE_PATTERN_DOTS_2348";
        case   0x288F: return "BRAILLE_PATTERN_DOTS_12348";
        case   0x2890: return "BRAILLE_PATTERN_DOTS_58";
        case   0x2891: return "BRAILLE_PATTERN_DOTS_158";
        case   0x2892: return "BRAILLE_PATTERN_DOTS_258";
        case   0x2893: return "BRAILLE_PATTERN_DOTS_1258";
        case   0x2894: return "BRAILLE_PATTERN_DOTS_358";
        case   0x2895: return "BRAILLE_PATTERN_DOTS_1358";
        case   0x2896: return "BRAILLE_PATTERN_DOTS_2358";
        case   0x2897: return "BRAILLE_PATTERN_DOTS_12358";
        case   0x2898: return "BRAILLE_PATTERN_DOTS_458";
        case   0x2899: return "BRAILLE_PATTERN_DOTS_1458";
        case   0x289A: return "BRAILLE_PATTERN_DOTS_2458";
        case   0x289B: return "BRAILLE_PATTERN_DOTS_12458";
        case   0x289C: return "BRAILLE_PATTERN_DOTS_3458";
        case   0x289D: return "BRAILLE_PATTERN_DOTS_13458";
        case   0x289E: return "BRAILLE_PATTERN_DOTS_23458";
        case   0x289F: return "BRAILLE_PATTERN_DOTS_123458";
        case   0x28A0: return "BRAILLE_PATTERN_DOTS_68";
        case   0x28A1: return "BRAILLE_PATTERN_DOTS_168";
        case   0x28A2: return "BRAILLE_PATTERN_DOTS_268";
        case   0x28A3: return "BRAILLE_PATTERN_DOTS_1268";
        case   0x28A4: return "BRAILLE_PATTERN_DOTS_368";
        case   0x28A5: return "BRAILLE_PATTERN_DOTS_1368";
        case   0x28A6: return "BRAILLE_PATTERN_DOTS_2368";
        case   0x28A7: return "BRAILLE_PATTERN_DOTS_12368";
        case   0x28A8: return "BRAILLE_PATTERN_DOTS_468";
        case   0x28A9: return "BRAILLE_PATTERN_DOTS_1468";
        case   0x28AA: return "BRAILLE_PATTERN_DOTS_2468";
        case   0x28AB: return "BRAILLE_PATTERN_DOTS_12468";
        case   0x28AC: return "BRAILLE_PATTERN_DOTS_3468";
        case   0x28AD: return "BRAILLE_PATTERN_DOTS_13468";
        case   0x28AE: return "BRAILLE_PATTERN_DOTS_23468";
        case   0x28AF: return "BRAILLE_PATTERN_DOTS_123468";
        case   0x28B0: return "BRAILLE_PATTERN_DOTS_568";
        case   0x28B1: return "BRAILLE_PATTERN_DOTS_1568";
        case   0x28B2: return "BRAILLE_PATTERN_DOTS_2568";
        case   0x28B3: return "BRAILLE_PATTERN_DOTS_12568";
        case   0x28B4: return "BRAILLE_PATTERN_DOTS_3568";
        case   0x28B5: return "BRAILLE_PATTERN_DOTS_13568";
        case   0x28B6: return "BRAILLE_PATTERN_DOTS_23568";
        case   0x28B7: return "BRAILLE_PATTERN_DOTS_123568";
        case   0x28B8: return "BRAILLE_PATTERN_DOTS_4568";
        case   0x28B9: return "BRAILLE_PATTERN_DOTS_14568";
        case   0x28BA: return "BRAILLE_PATTERN_DOTS_24568";
        case   0x28BB: return "BRAILLE_PATTERN_DOTS_124568";
        case   0x28BC: return "BRAILLE_PATTERN_DOTS_34568";
        case   0x28BD: return "BRAILLE_PATTERN_DOTS_134568";
        case   0x28BE: return "BRAILLE_PATTERN_DOTS_234568";
        case   0x28BF: return "BRAILLE_PATTERN_DOTS_1234568";
        case   0x28C0: return "BRAILLE_PATTERN_DOTS_78";
        case   0x28C1: return "BRAILLE_PATTERN_DOTS_178";
        case   0x28C2: return "BRAILLE_PATTERN_DOTS_278";
        case   0x28C3: return "BRAILLE_PATTERN_DOTS_1278";
        case   0x28C4: return "BRAILLE_PATTERN_DOTS_378";
        case   0x28C5: return "BRAILLE_PATTERN_DOTS_1378";
        case   0x28C6: return "BRAILLE_PATTERN_DOTS_2378";
        case   0x28C7: return "BRAILLE_PATTERN_DOTS_12378";
        case   0x28C8: return "BRAILLE_PATTERN_DOTS_478";
        case   0x28C9: return "BRAILLE_PATTERN_DOTS_1478";
        case   0x28CA: return "BRAILLE_PATTERN_DOTS_2478";
        case   0x28CB: return "BRAILLE_PATTERN_DOTS_12478";
        case   0x28CC: return "BRAILLE_PATTERN_DOTS_3478";
        case   0x28CD: return "BRAILLE_PATTERN_DOTS_13478";
        case   0x28CE: return "BRAILLE_PATTERN_DOTS_23478";
        case   0x28CF: return "BRAILLE_PATTERN_DOTS_123478";
        case   0x28D0: return "BRAILLE_PATTERN_DOTS_578";
        case   0x28D1: return "BRAILLE_PATTERN_DOTS_1578";
        case   0x28D2: return "BRAILLE_PATTERN_DOTS_2578";
        case   0x28D3: return "BRAILLE_PATTERN_DOTS_12578";
        case   0x28D4: return "BRAILLE_PATTERN_DOTS_3578";
        case   0x28D5: return "BRAILLE_PATTERN_DOTS_13578";
        case   0x28D6: return "BRAILLE_PATTERN_DOTS_23578";
        case   0x28D7: return "BRAILLE_PATTERN_DOTS_123578";
        case   0x28D8: return "BRAILLE_PATTERN_DOTS_4578";
        case   0x28D9: return "BRAILLE_PATTERN_DOTS_14578";
        case   0x28DA: return "BRAILLE_PATTERN_DOTS_24578";
        case   0x28DB: return "BRAILLE_PATTERN_DOTS_124578";
        case   0x28DC: return "BRAILLE_PATTERN_DOTS_34578";
        case   0x28DD: return "BRAILLE_PATTERN_DOTS_134578";
        case   0x28DE: return "BRAILLE_PATTERN_DOTS_234578";
        case   0x28DF: return "BRAILLE_PATTERN_DOTS_1234578";
        case   0x28E0: return "BRAILLE_PATTERN_DOTS_678";
        case   0x28E1: return "BRAILLE_PATTERN_DOTS_1678";
        case   0x28E2: return "BRAILLE_PATTERN_DOTS_2678";
        case   0x28E3: return "BRAILLE_PATTERN_DOTS_12678";
        case   0x28E4: return "BRAILLE_PATTERN_DOTS_3678";
        case   0x28E5: return "BRAILLE_PATTERN_DOTS_13678";
        case   0x28E6: return "BRAILLE_PATTERN_DOTS_23678";
        case   0x28E7: return "BRAILLE_PATTERN_DOTS_123678";
        case   0x28E8: return "BRAILLE_PATTERN_DOTS_4678";
        case   0x28E9: return "BRAILLE_PATTERN_DOTS_14678";
        case   0x28EA: return "BRAILLE_PATTERN_DOTS_24678";
        case   0x28EB: return "BRAILLE_PATTERN_DOTS_124678";
        case   0x28EC: return "BRAILLE_PATTERN_DOTS_34678";
        case   0x28ED: return "BRAILLE_PATTERN_DOTS_134678";
        case   0x28EE: return "BRAILLE_PATTERN_DOTS_234678";
        case   0x28EF: return "BRAILLE_PATTERN_DOTS_1234678";
        case   0x28F0: return "BRAILLE_PATTERN_DOTS_5678";
        case   0x28F1: return "BRAILLE_PATTERN_DOTS_15678";
        case   0x28F2: return "BRAILLE_PATTERN_DOTS_25678";
        case   0x28F3: return "BRAILLE_PATTERN_DOTS_125678";
        case   0x28F4: return "BRAILLE_PATTERN_DOTS_35678";
        case   0x28F5: return "BRAILLE_PATTERN_DOTS_135678";
        case   0x28F6: return "BRAILLE_PATTERN_DOTS_235678";
        case   0x28F7: return "BRAILLE_PATTERN_DOTS_1235678";
        case   0x28F8: return "BRAILLE_PATTERN_DOTS_45678";
        case   0x28F9: return "BRAILLE_PATTERN_DOTS_145678";
        case   0x28FA: return "BRAILLE_PATTERN_DOTS_245678";
        case   0x28FB: return "BRAILLE_PATTERN_DOTS_1245678";
        case   0x28FC: return "BRAILLE_PATTERN_DOTS_345678";
        case   0x28FD: return "BRAILLE_PATTERN_DOTS_1345678";
        case   0x28FE: return "BRAILLE_PATTERN_DOTS_2345678";
        case   0x28FF: return "BRAILLE_PATTERN_DOTS_12345678";
        case   0x2900: return
                "RIGHTWARDS_TWO_HEADED_ARROW_WITH_VERTICAL_STROKE";
        case   0x2901: return
                "RIGHTWARDS_TWO_HEADED_ARROW_WITH_DOUBLE_VERTICAL_STROKE";
        case   0x2902: return "LEFTWARDS_DOUBLE_ARROW_WITH_VERTICAL_STROKE";
        case   0x2903: return "RIGHTWARDS_DOUBLE_ARROW_WITH_VERTICAL_STROKE";
        case   0x2904: return "LEFT_RIGHT_DOUBLE_ARROW_WITH_VERTICAL_STROKE";
        case   0x2905: return "RIGHTWARDS_TWO_HEADED_ARROW_FROM_BAR";
        case   0x2906: return "LEFTWARDS_DOUBLE_ARROW_FROM_BAR";
        case   0x2907: return "RIGHTWARDS_DOUBLE_ARROW_FROM_BAR";
        case   0x2908: return "DOWNWARDS_ARROW_WITH_HORIZONTAL_STROKE";
        case   0x2909: return "UPWARDS_ARROW_WITH_HORIZONTAL_STROKE";
        case   0x290A: return "UPWARDS_TRIPLE_ARROW";
        case   0x290B: return "DOWNWARDS_TRIPLE_ARROW";
        case   0x290C: return "LEFTWARDS_DOUBLE_DASH_ARROW";
        case   0x290D: return "RIGHTWARDS_DOUBLE_DASH_ARROW";
        case   0x290E: return "LEFTWARDS_TRIPLE_DASH_ARROW";
        case   0x290F: return "RIGHTWARDS_TRIPLE_DASH_ARROW";
        case   0x2910: return "RIGHTWARDS_TWO_HEADED_TRIPLE_DASH_ARROW";
        case   0x2911: return "RIGHTWARDS_ARROW_WITH_DOTTED_STEM";
        case   0x2912: return "UPWARDS_ARROW_TO_BAR";
        case   0x2913: return "DOWNWARDS_ARROW_TO_BAR";
        case   0x2914: return
                "RIGHTWARDS_ARROW_WITH_TAIL_WITH_VERTICAL_STROKE";
        case   0x2915: return
                "RIGHTWARDS_ARROW_WITH_TAIL_WITH_DOUBLE_VERTICAL_STROKE";
        case   0x2916: return "RIGHTWARDS_TWO_HEADED_ARROW_WITH_TAIL";
        case   0x2917: return
                "RIGHTWARDS_TWO_HEADED_ARROW_WITH_TAIL_WITH_VERTICAL_STROKE";
        case   0x2918: return
                "RIGHTWARDS_TWO_HEADED_ARROW_WITH_TAIL_WITH_DOUBLE_VERTICAL_STROKE";
        case   0x2919: return "LEFTWARDS_ARROW_TAIL";
        case   0x291A: return "RIGHTWARDS_ARROW_TAIL";
        case   0x291B: return "LEFTWARDS_DOUBLE_ARROW_TAIL";
        case   0x291C: return "RIGHTWARDS_DOUBLE_ARROW_TAIL";
        case   0x291D: return "LEFTWARDS_ARROW_TO_BLACK_DIAMOND";
        case   0x291E: return "RIGHTWARDS_ARROW_TO_BLACK_DIAMOND";
        case   0x291F: return "LEFTWARDS_ARROW_FROM_BAR_TO_BLACK_DIAMOND";
        case   0x2920: return "RIGHTWARDS_ARROW_FROM_BAR_TO_BLACK_DIAMOND";
        case   0x2921: return "NORTH_WEST_AND_SOUTH_EAST_ARROW";
        case   0x2922: return "NORTH_EAST_AND_SOUTH_WEST_ARROW";
        case   0x2923: return "NORTH_WEST_ARROW_WITH_HOOK";
        case   0x2924: return "NORTH_EAST_ARROW_WITH_HOOK";
        case   0x2925: return "SOUTH_EAST_ARROW_WITH_HOOK";
        case   0x2926: return "SOUTH_WEST_ARROW_WITH_HOOK";
        case   0x2927: return "NORTH_WEST_ARROW_AND_NORTH_EAST_ARROW";
        case   0x2928: return "NORTH_EAST_ARROW_AND_SOUTH_EAST_ARROW";
        case   0x2929: return "SOUTH_EAST_ARROW_AND_SOUTH_WEST_ARROW";
        case   0x292A: return "SOUTH_WEST_ARROW_AND_NORTH_WEST_ARROW";
        case   0x292B: return "RISING_DIAGONAL_CROSSING_FALLING_DIAGONAL";
        case   0x292C: return "FALLING_DIAGONAL_CROSSING_RISING_DIAGONAL";
        case   0x292D: return "SOUTH_EAST_ARROW_CROSSING_NORTH_EAST_ARROW";
        case   0x292E: return "NORTH_EAST_ARROW_CROSSING_SOUTH_EAST_ARROW";
        case   0x292F: return "FALLING_DIAGONAL_CROSSING_NORTH_EAST_ARROW";
        case   0x2930: return "RISING_DIAGONAL_CROSSING_SOUTH_EAST_ARROW";
        case   0x2931: return "NORTH_EAST_ARROW_CROSSING_NORTH_WEST_ARROW";
        case   0x2932: return "NORTH_WEST_ARROW_CROSSING_NORTH_EAST_ARROW";
        case   0x2933: return "WAVE_ARROW_POINTING_DIRECTLY_RIGHT";
        case   0x2934: return
                "ARROW_POINTING_RIGHTWARDS_THEN_CURVING_UPWARDS";
        case   0x2935: return
                "ARROW_POINTING_RIGHTWARDS_THEN_CURVING_DOWNWARDS";
        case   0x2936: return
                "ARROW_POINTING_DOWNWARDS_THEN_CURVING_LEFTWARDS";
        case   0x2937: return
                "ARROW_POINTING_DOWNWARDS_THEN_CURVING_RIGHTWARDS";
        case   0x2938: return "RIGHT_SIDE_ARC_CLOCKWISE_ARROW";
        case   0x2939: return "LEFT_SIDE_ARC_ANTICLOCKWISE_ARROW";
        case   0x293A: return "TOP_ARC_ANTICLOCKWISE_ARROW";
        case   0x293B: return "BOTTOM_ARC_ANTICLOCKWISE_ARROW";
        case   0x293C: return "TOP_ARC_CLOCKWISE_ARROW_WITH_MINUS";
        case   0x293D: return "TOP_ARC_ANTICLOCKWISE_ARROW_WITH_PLUS";
        case   0x293E: return "LOWER_RIGHT_SEMICIRCULAR_CLOCKWISE_ARROW";
        case   0x293F: return "LOWER_LEFT_SEMICIRCULAR_ANTICLOCKWISE_ARROW";
        case   0x2940: return "ANTICLOCKWISE_CLOSED_CIRCLE_ARROW";
        case   0x2941: return "CLOCKWISE_CLOSED_CIRCLE_ARROW";
        case   0x2942: return "RIGHTWARDS_ARROW_ABOVE_SHORT_LEFTWARDS_ARROW";
        case   0x2943: return "LEFTWARDS_ARROW_ABOVE_SHORT_RIGHTWARDS_ARROW";
        case   0x2944: return "SHORT_RIGHTWARDS_ARROW_ABOVE_LEFTWARDS_ARROW";
        case   0x2945: return "RIGHTWARDS_ARROW_WITH_PLUS_BELOW";
        case   0x2946: return "LEFTWARDS_ARROW_WITH_PLUS_BELOW";
        case   0x2947: return "RIGHTWARDS_ARROW_THROUGH_X";
        case   0x2948: return "LEFT_RIGHT_ARROW_THROUGH_SMALL_CIRCLE";
        case   0x2949: return "UPWARDS_TWO_HEADED_ARROW_FROM_SMALL_CIRCLE";
        case   0x294A: return "LEFT_BARB_UP_RIGHT_BARB_DOWN_HARPOON";
        case   0x294B: return "LEFT_BARB_DOWN_RIGHT_BARB_UP_HARPOON";
        case   0x294C: return "UP_BARB_RIGHT_DOWN_BARB_LEFT_HARPOON";
        case   0x294D: return "UP_BARB_LEFT_DOWN_BARB_RIGHT_HARPOON";
        case   0x294E: return "LEFT_BARB_UP_RIGHT_BARB_UP_HARPOON";
        case   0x294F: return "UP_BARB_RIGHT_DOWN_BARB_RIGHT_HARPOON";
        case   0x2950: return "LEFT_BARB_DOWN_RIGHT_BARB_DOWN_HARPOON";
        case   0x2951: return "UP_BARB_LEFT_DOWN_BARB_LEFT_HARPOON";
        case   0x2952: return "LEFTWARDS_HARPOON_WITH_BARB_UP_TO_BAR";
        case   0x2953: return "RIGHTWARDS_HARPOON_WITH_BARB_UP_TO_BAR";
        case   0x2954: return "UPWARDS_HARPOON_WITH_BARB_RIGHT_TO_BAR";
        case   0x2955: return "DOWNWARDS_HARPOON_WITH_BARB_RIGHT_TO_BAR";
        case   0x2956: return "LEFTWARDS_HARPOON_WITH_BARB_DOWN_TO_BAR";
        case   0x2957: return "RIGHTWARDS_HARPOON_WITH_BARB_DOWN_TO_BAR";
        case   0x2958: return "UPWARDS_HARPOON_WITH_BARB_LEFT_TO_BAR";
        case   0x2959: return "DOWNWARDS_HARPOON_WITH_BARB_LEFT_TO_BAR";
        case   0x295A: return "LEFTWARDS_HARPOON_WITH_BARB_UP_FROM_BAR";
        case   0x295B: return "RIGHTWARDS_HARPOON_WITH_BARB_UP_FROM_BAR";
        case   0x295C: return "UPWARDS_HARPOON_WITH_BARB_RIGHT_FROM_BAR";
        case   0x295D: return "DOWNWARDS_HARPOON_WITH_BARB_RIGHT_FROM_BAR";
        case   0x295E: return "LEFTWARDS_HARPOON_WITH_BARB_DOWN_FROM_BAR";
        case   0x295F: return "RIGHTWARDS_HARPOON_WITH_BARB_DOWN_FROM_BAR";
        case   0x2960: return "UPWARDS_HARPOON_WITH_BARB_LEFT_FROM_BAR";
        case   0x2961: return "DOWNWARDS_HARPOON_WITH_BARB_LEFT_FROM_BAR";
        case   0x2962: return
                "LEFTWARDS_HARPOON_WITH_BARB_UP_ABOVE_LEFTWARDS_HARPOON_WITH_BARB_DOWN";
        case   0x2963: return
                "UPWARDS_HARPOON_WITH_BARB_LEFT_BESIDE_UPWARDS_HARPOON_WITH_BARB_RIGHT";
        case   0x2964: return
                "RIGHTWARDS_HARPOON_WITH_BARB_UP_ABOVE_RIGHTWARDS_HARPOON_WITH_BARB_DOWN";
        case   0x2965: return
                "DOWNWARDS_HARPOON_WITH_BARB_LEFT_BESIDE_DOWNWARDS_HARPOON_WITH_BARB_RIGHT";
        case   0x2966: return
                "LEFTWARDS_HARPOON_WITH_BARB_UP_ABOVE_RIGHTWARDS_HARPOON_WITH_BARB_UP";
        case   0x2967: return
                "LEFTWARDS_HARPOON_WITH_BARB_DOWN_ABOVE_RIGHTWARDS_HARPOON_WITH_BARB_DOWN";
        case   0x2968: return
                "RIGHTWARDS_HARPOON_WITH_BARB_UP_ABOVE_LEFTWARDS_HARPOON_WITH_BARB_UP";
        case   0x2969: return
                "RIGHTWARDS_HARPOON_WITH_BARB_DOWN_ABOVE_LEFTWARDS_HARPOON_WITH_BARB_DOWN";
        case   0x296A: return
                "LEFTWARDS_HARPOON_WITH_BARB_UP_ABOVE_LONG_DASH";
        case   0x296B: return
                "LEFTWARDS_HARPOON_WITH_BARB_DOWN_BELOW_LONG_DASH";
        case   0x296C: return
                "RIGHTWARDS_HARPOON_WITH_BARB_UP_ABOVE_LONG_DASH";
        case   0x296D: return
                "RIGHTWARDS_HARPOON_WITH_BARB_DOWN_BELOW_LONG_DASH";
        case   0x296E: return
                "UPWARDS_HARPOON_WITH_BARB_LEFT_BESIDE_DOWNWARDS_HARPOON_WITH_BARB_RIGHT";
        case   0x296F: return
                "DOWNWARDS_HARPOON_WITH_BARB_LEFT_BESIDE_UPWARDS_HARPOON_WITH_BARB_RIGHT";
        case   0x2970: return "RIGHT_DOUBLE_ARROW_WITH_ROUNDED_HEAD";
        case   0x2971: return "EQUALS_SIGN_ABOVE_RIGHTWARDS_ARROW";
        case   0x2972: return "TILDE_OPERATOR_ABOVE_RIGHTWARDS_ARROW";
        case   0x2973: return "LEFTWARDS_ARROW_ABOVE_TILDE_OPERATOR";
        case   0x2974: return "RIGHTWARDS_ARROW_ABOVE_TILDE_OPERATOR";
        case   0x2975: return "RIGHTWARDS_ARROW_ABOVE_ALMOST_EQUAL_TO";
        case   0x2976: return "LESS_THAN_ABOVE_LEFTWARDS_ARROW";
        case   0x2977: return "LEFTWARDS_ARROW_THROUGH_LESS_THAN";
        case   0x2978: return "GREATER_THAN_ABOVE_RIGHTWARDS_ARROW";
        case   0x2979: return "SUBSET_ABOVE_RIGHTWARDS_ARROW";
        case   0x297A: return "LEFTWARDS_ARROW_THROUGH_SUBSET";
        case   0x297B: return "SUPERSET_ABOVE_LEFTWARDS_ARROW";
        case   0x297C: return "LEFT_FISH_TAIL";
        case   0x297D: return "RIGHT_FISH_TAIL";
        case   0x297E: return "UP_FISH_TAIL";
        case   0x297F: return "DOWN_FISH_TAIL";
        case   0x2980: return "TRIPLE_VERTICAL_BAR_DELIMITER";
        case   0x2981: return "Z_NOTATION_SPOT";
        case   0x2982: return "Z_NOTATION_TYPE_COLON";
        case   0x2983: return "LEFT_WHITE_CURLY_BRACKET";
        case   0x2984: return "RIGHT_WHITE_CURLY_BRACKET";
        case   0x2985: return "LEFT_WHITE_PARENTHESIS";
        case   0x2986: return "RIGHT_WHITE_PARENTHESIS";
        case   0x2987: return "Z_NOTATION_LEFT_IMAGE_BRACKET";
        case   0x2988: return "Z_NOTATION_RIGHT_IMAGE_BRACKET";
        case   0x2989: return "Z_NOTATION_LEFT_BINDING_BRACKET";
        case   0x298A: return "Z_NOTATION_RIGHT_BINDING_BRACKET";
        case   0x298B: return "LEFT_SQUARE_BRACKET_WITH_UNDERBAR";
        case   0x298C: return "RIGHT_SQUARE_BRACKET_WITH_UNDERBAR";
        case   0x298D: return "LEFT_SQUARE_BRACKET_WITH_TICK_IN_TOP_CORNER";
        case   0x298E: return
                "RIGHT_SQUARE_BRACKET_WITH_TICK_IN_BOTTOM_CORNER";
        case   0x298F: return
                "LEFT_SQUARE_BRACKET_WITH_TICK_IN_BOTTOM_CORNER";
        case   0x2990: return "RIGHT_SQUARE_BRACKET_WITH_TICK_IN_TOP_CORNER";
        case   0x2991: return "LEFT_ANGLE_BRACKET_WITH_DOT";
        case   0x2992: return "RIGHT_ANGLE_BRACKET_WITH_DOT";
        case   0x2993: return "LEFT_ARC_LESS_THAN_BRACKET";
        case   0x2994: return "RIGHT_ARC_GREATER_THAN_BRACKET";
        case   0x2995: return "DOUBLE_LEFT_ARC_GREATER_THAN_BRACKET";
        case   0x2996: return "DOUBLE_RIGHT_ARC_LESS_THAN_BRACKET";
        case   0x2997: return "LEFT_BLACK_TORTOISE_SHELL_BRACKET";
        case   0x2998: return "RIGHT_BLACK_TORTOISE_SHELL_BRACKET";
        case   0x2999: return "DOTTED_FENCE";
        case   0x299A: return "VERTICAL_ZIGZAG_LINE";
        case   0x299B: return "MEASURED_ANGLE_OPENING_LEFT";
        case   0x299C: return "RIGHT_ANGLE_VARIANT_WITH_SQUARE";
        case   0x299D: return "MEASURED_RIGHT_ANGLE_WITH_DOT";
        case   0x299E: return "ANGLE_WITH_S_INSIDE";
        case   0x299F: return "ACUTE_ANGLE";
        case   0x29A0: return "SPHERICAL_ANGLE_OPENING_LEFT";
        case   0x29A1: return "SPHERICAL_ANGLE_OPENING_UP";
        case   0x29A2: return "TURNED_ANGLE";
        case   0x29A3: return "REVERSED_ANGLE";
        case   0x29A4: return "ANGLE_WITH_UNDERBAR";
        case   0x29A5: return "REVERSED_ANGLE_WITH_UNDERBAR";
        case   0x29A6: return "OBLIQUE_ANGLE_OPENING_UP";
        case   0x29A7: return "OBLIQUE_ANGLE_OPENING_DOWN";
        case   0x29A8: return
                "MEASURED_ANGLE_WITH_OPEN_ARM_ENDING_IN_ARROW_POINTING_UP_AND_RIGHT";
        case   0x29A9: return
                "MEASURED_ANGLE_WITH_OPEN_ARM_ENDING_IN_ARROW_POINTING_UP_AND_LEFT";
        case   0x29AA: return
                "MEASURED_ANGLE_WITH_OPEN_ARM_ENDING_IN_ARROW_POINTING_DOWN_AND_RIGHT";
        case   0x29AB: return
                "MEASURED_ANGLE_WITH_OPEN_ARM_ENDING_IN_ARROW_POINTING_DOWN_AND_LEFT";
        case   0x29AC: return
                "MEASURED_ANGLE_WITH_OPEN_ARM_ENDING_IN_ARROW_POINTING_RIGHT_AND_UP";
        case   0x29AD: return
                "MEASURED_ANGLE_WITH_OPEN_ARM_ENDING_IN_ARROW_POINTING_LEFT_AND_UP";
        case   0x29AE: return
                "MEASURED_ANGLE_WITH_OPEN_ARM_ENDING_IN_ARROW_POINTING_RIGHT_AND_DOWN";
        case   0x29AF: return
                "MEASURED_ANGLE_WITH_OPEN_ARM_ENDING_IN_ARROW_POINTING_LEFT_AND_DOWN";
        case   0x29B0: return "REVERSED_EMPTY_SET";
        case   0x29B1: return "EMPTY_SET_WITH_OVERBAR";
        case   0x29B2: return "EMPTY_SET_WITH_SMALL_CIRCLE_ABOVE";
        case   0x29B3: return "EMPTY_SET_WITH_RIGHT_ARROW_ABOVE";
        case   0x29B4: return "EMPTY_SET_WITH_LEFT_ARROW_ABOVE";
        case   0x29B5: return "CIRCLE_WITH_HORIZONTAL_BAR";
        case   0x29B6: return "CIRCLED_VERTICAL_BAR";
        case   0x29B7: return "CIRCLED_PARALLEL";
        case   0x29B8: return "CIRCLED_REVERSE_SOLIDUS";
        case   0x29B9: return "CIRCLED_PERPENDICULAR";
        case   0x29BA: return
                "CIRCLE_DIVIDED_BY_HORIZONTAL_BAR_AND_TOP_HALF_DIVIDED_BY_VERTICAL_BAR";
        case   0x29BB: return "CIRCLE_WITH_SUPERIMPOSED_X";
        case   0x29BC: return "CIRCLED_ANTICLOCKWISE_ROTATED_DIVISION_SIGN";
        case   0x29BD: return "UP_ARROW_THROUGH_CIRCLE";
        case   0x29BE: return "CIRCLED_WHITE_BULLET";
        case   0x29BF: return "CIRCLED_BULLET";
        case   0x29C0: return "CIRCLED_LESS_THAN";
        case   0x29C1: return "CIRCLED_GREATER_THAN";
        case   0x29C2: return "CIRCLE_WITH_SMALL_CIRCLE_TO_THE_RIGHT";
        case   0x29C3: return
                "CIRCLE_WITH_TWO_HORIZONTAL_STROKES_TO_THE_RIGHT";
        case   0x29C4: return "SQUARED_RISING_DIAGONAL_SLASH";
        case   0x29C5: return "SQUARED_FALLING_DIAGONAL_SLASH";
        case   0x29C6: return "SQUARED_ASTERISK";
        case   0x29C7: return "SQUARED_SMALL_CIRCLE";
        case   0x29C8: return "SQUARED_SQUARE";
        case   0x29C9: return "TWO_JOINED_SQUARES";
        case   0x29CA: return "TRIANGLE_WITH_DOT_ABOVE";
        case   0x29CB: return "TRIANGLE_WITH_UNDERBAR";
        case   0x29CC: return "S_IN_TRIANGLE";
        case   0x29CD: return "TRIANGLE_WITH_SERIFS_AT_BOTTOM";
        case   0x29CE: return "RIGHT_TRIANGLE_ABOVE_LEFT_TRIANGLE";
        case   0x29CF: return "LEFT_TRIANGLE_BESIDE_VERTICAL_BAR";
        case   0x29D0: return "VERTICAL_BAR_BESIDE_RIGHT_TRIANGLE";
        case   0x29D1: return "BOWTIE_WITH_LEFT_HALF_BLACK";
        case   0x29D2: return "BOWTIE_WITH_RIGHT_HALF_BLACK";
        case   0x29D3: return "BLACK_BOWTIE";
        case   0x29D4: return "TIMES_WITH_LEFT_HALF_BLACK";
        case   0x29D5: return "TIMES_WITH_RIGHT_HALF_BLACK";
        case   0x29D6: return "WHITE_HOURGLASS";
        case   0x29D7: return "BLACK_HOURGLASS";
        case   0x29D8: return "LEFT_WIGGLY_FENCE";
        case   0x29D9: return "RIGHT_WIGGLY_FENCE";
        case   0x29DA: return "LEFT_DOUBLE_WIGGLY_FENCE";
        case   0x29DB: return "RIGHT_DOUBLE_WIGGLY_FENCE";
        case   0x29DC: return "INCOMPLETE_INFINITY";
        case   0x29DD: return "TIE_OVER_INFINITY";
        case   0x29DE: return "INFINITY_NEGATED_WITH_VERTICAL_BAR";
        case   0x29DF: return "DOUBLE_ENDED_MULTIMAP";
        case   0x29E0: return "SQUARE_WITH_CONTOURED_OUTLINE";
        case   0x29E1: return "INCREASES_AS";
        case   0x29E2: return "SHUFFLE_PRODUCT";
        case   0x29E3: return "EQUALS_SIGN_AND_SLANTED_PARALLEL";
        case   0x29E4: return
                "EQUALS_SIGN_AND_SLANTED_PARALLEL_WITH_TILDE_ABOVE";
        case   0x29E5: return "IDENTICAL_TO_AND_SLANTED_PARALLEL";
        case   0x29E6: return "GLEICH_STARK";
        case   0x29E7: return "THERMODYNAMIC";
        case   0x29E8: return "DOWN_POINTING_TRIANGLE_WITH_LEFT_HALF_BLACK";
        case   0x29E9: return "DOWN_POINTING_TRIANGLE_WITH_RIGHT_HALF_BLACK";
        case   0x29EA: return "BLACK_DIAMOND_WITH_DOWN_ARROW";
        case   0x29EB: return "BLACK_LOZENGE";
        case   0x29EC: return "WHITE_CIRCLE_WITH_DOWN_ARROW";
        case   0x29ED: return "BLACK_CIRCLE_WITH_DOWN_ARROW";
        case   0x29EE: return "ERROR_BARRED_WHITE_SQUARE";
        case   0x29EF: return "ERROR_BARRED_BLACK_SQUARE";
        case   0x29F0: return "ERROR_BARRED_WHITE_DIAMOND";
        case   0x29F1: return "ERROR_BARRED_BLACK_DIAMOND";
        case   0x29F2: return "ERROR_BARRED_WHITE_CIRCLE";
        case   0x29F3: return "ERROR_BARRED_BLACK_CIRCLE";
        case   0x29F4: return "RULE_DELAYED";
        case   0x29F5: return "REVERSE_SOLIDUS_OPERATOR";
        case   0x29F6: return "SOLIDUS_WITH_OVERBAR";
        case   0x29F7: return "REVERSE_SOLIDUS_WITH_HORIZONTAL_STROKE";
        case   0x29F8: return "BIG_SOLIDUS";
        case   0x29F9: return "BIG_REVERSE_SOLIDUS";
        case   0x29FA: return "DOUBLE_PLUS";
        case   0x29FB: return "TRIPLE_PLUS";
        case   0x29FC: return "LEFT_POINTING_CURVED_ANGLE_BRACKET";
        case   0x29FD: return "RIGHT_POINTING_CURVED_ANGLE_BRACKET";
        case   0x29FE: return "TINY";
        case   0x29FF: return "MINY";
        case   0x2A00: return "N_ARY_CIRCLED_DOT_OPERATOR";
        case   0x2A01: return "N_ARY_CIRCLED_PLUS_OPERATOR";
        case   0x2A02: return "N_ARY_CIRCLED_TIMES_OPERATOR";
        case   0x2A03: return "N_ARY_UNION_OPERATOR_WITH_DOT";
        case   0x2A04: return "N_ARY_UNION_OPERATOR_WITH_PLUS";
        case   0x2A05: return "N_ARY_SQUARE_INTERSECTION_OPERATOR";
        case   0x2A06: return "N_ARY_SQUARE_UNION_OPERATOR";
        case   0x2A07: return "TWO_LOGICAL_AND_OPERATOR";
        case   0x2A08: return "TWO_LOGICAL_OR_OPERATOR";
        case   0x2A09: return "N_ARY_TIMES_OPERATOR";
        case   0x2A0A: return "MODULO_TWO_SUM";
        case   0x2A0B: return "SUMMATION_WITH_INTEGRAL";
        case   0x2A0C: return "QUADRUPLE_INTEGRAL_OPERATOR";
        case   0x2A0D: return "FINITE_PART_INTEGRAL";
        case   0x2A0E: return "INTEGRAL_WITH_DOUBLE_STROKE";
        case   0x2A0F: return "INTEGRAL_AVERAGE_WITH_SLASH";
        case   0x2A10: return "CIRCULATION_FUNCTION";
        case   0x2A11: return "ANTICLOCKWISE_INTEGRATION";
        case   0x2A12: return
                "LINE_INTEGRATION_WITH_RECTANGULAR_PATH_AROUND_POLE";
        case   0x2A13: return
                "LINE_INTEGRATION_WITH_SEMICIRCULAR_PATH_AROUND_POLE";
        case   0x2A14: return "LINE_INTEGRATION_NOT_INCLUDING_THE_POLE";
        case   0x2A15: return "INTEGRAL_AROUND_A_POINT_OPERATOR";
        case   0x2A16: return "QUATERNION_INTEGRAL_OPERATOR";
        case   0x2A17: return "INTEGRAL_WITH_LEFTWARDS_ARROW_WITH_HOOK";
        case   0x2A18: return "INTEGRAL_WITH_TIMES_SIGN";
        case   0x2A19: return "INTEGRAL_WITH_INTERSECTION";
        case   0x2A1A: return "INTEGRAL_WITH_UNION";
        case   0x2A1B: return "INTEGRAL_WITH_OVERBAR";
        case   0x2A1C: return "INTEGRAL_WITH_UNDERBAR";
        case   0x2A1D: return "JOIN";
        case   0x2A1E: return "LARGE_LEFT_TRIANGLE_OPERATOR";
        case   0x2A1F: return "Z_NOTATION_SCHEMA_COMPOSITION";
        case   0x2A20: return "Z_NOTATION_SCHEMA_PIPING";
        case   0x2A21: return "Z_NOTATION_SCHEMA_PROJECTION";
        case   0x2A22: return "PLUS_SIGN_WITH_SMALL_CIRCLE_ABOVE";
        case   0x2A23: return "PLUS_SIGN_WITH_CIRCUMFLEX_ACCENT_ABOVE";
        case   0x2A24: return "PLUS_SIGN_WITH_TILDE_ABOVE";
        case   0x2A25: return "PLUS_SIGN_WITH_DOT_BELOW";
        case   0x2A26: return "PLUS_SIGN_WITH_TILDE_BELOW";
        case   0x2A27: return "PLUS_SIGN_WITH_SUBSCRIPT_TWO";
        case   0x2A28: return "PLUS_SIGN_WITH_BLACK_TRIANGLE";
        case   0x2A29: return "MINUS_SIGN_WITH_COMMA_ABOVE";
        case   0x2A2A: return "MINUS_SIGN_WITH_DOT_BELOW";
        case   0x2A2B: return "MINUS_SIGN_WITH_FALLING_DOTS";
        case   0x2A2C: return "MINUS_SIGN_WITH_RISING_DOTS";
        case   0x2A2D: return "PLUS_SIGN_IN_LEFT_HALF_CIRCLE";
        case   0x2A2E: return "PLUS_SIGN_IN_RIGHT_HALF_CIRCLE";
        case   0x2A2F: return "VECTOR_OR_CROSS_PRODUCT";
        case   0x2A30: return "MULTIPLICATION_SIGN_WITH_DOT_ABOVE";
        case   0x2A31: return "MULTIPLICATION_SIGN_WITH_UNDERBAR";
        case   0x2A32: return "SEMIDIRECT_PRODUCT_WITH_BOTTOM_CLOSED";
        case   0x2A33: return "SMASH_PRODUCT";
        case   0x2A34: return "MULTIPLICATION_SIGN_IN_LEFT_HALF_CIRCLE";
        case   0x2A35: return "MULTIPLICATION_SIGN_IN_RIGHT_HALF_CIRCLE";
        case   0x2A36: return
                "CIRCLED_MULTIPLICATION_SIGN_WITH_CIRCUMFLEX_ACCENT";
        case   0x2A37: return "MULTIPLICATION_SIGN_IN_DOUBLE_CIRCLE";
        case   0x2A38: return "CIRCLED_DIVISION_SIGN";
        case   0x2A39: return "PLUS_SIGN_IN_TRIANGLE";
        case   0x2A3A: return "MINUS_SIGN_IN_TRIANGLE";
        case   0x2A3B: return "MULTIPLICATION_SIGN_IN_TRIANGLE";
        case   0x2A3C: return "INTERIOR_PRODUCT";
        case   0x2A3D: return "RIGHTHAND_INTERIOR_PRODUCT";
        case   0x2A3E: return "Z_NOTATION_RELATIONAL_COMPOSITION";
        case   0x2A3F: return "AMALGAMATION_OR_COPRODUCT";
        case   0x2A40: return "INTERSECTION_WITH_DOT";
        case   0x2A41: return "UNION_WITH_MINUS_SIGN";
        case   0x2A42: return "UNION_WITH_OVERBAR";
        case   0x2A43: return "INTERSECTION_WITH_OVERBAR";
        case   0x2A44: return "INTERSECTION_WITH_LOGICAL_AND";
        case   0x2A45: return "UNION_WITH_LOGICAL_OR";
        case   0x2A46: return "UNION_ABOVE_INTERSECTION";
        case   0x2A47: return "INTERSECTION_ABOVE_UNION";
        case   0x2A48: return "UNION_ABOVE_BAR_ABOVE_INTERSECTION";
        case   0x2A49: return "INTERSECTION_ABOVE_BAR_ABOVE_UNION";
        case   0x2A4A: return "UNION_BESIDE_AND_JOINED_WITH_UNION";
        case   0x2A4B: return
                "INTERSECTION_BESIDE_AND_JOINED_WITH_INTERSECTION";
        case   0x2A4C: return "CLOSED_UNION_WITH_SERIFS";
        case   0x2A4D: return "CLOSED_INTERSECTION_WITH_SERIFS";
        case   0x2A4E: return "DOUBLE_SQUARE_INTERSECTION";
        case   0x2A4F: return "DOUBLE_SQUARE_UNION";
        case   0x2A50: return "CLOSED_UNION_WITH_SERIFS_AND_SMASH_PRODUCT";
        case   0x2A51: return "LOGICAL_AND_WITH_DOT_ABOVE";
        case   0x2A52: return "LOGICAL_OR_WITH_DOT_ABOVE";
        case   0x2A53: return "DOUBLE_LOGICAL_AND";
        case   0x2A54: return "DOUBLE_LOGICAL_OR";
        case   0x2A55: return "TWO_INTERSECTING_LOGICAL_AND";
        case   0x2A56: return "TWO_INTERSECTING_LOGICAL_OR";
        case   0x2A57: return "SLOPING_LARGE_OR";
        case   0x2A58: return "SLOPING_LARGE_AND";
        case   0x2A59: return "LOGICAL_OR_OVERLAPPING_LOGICAL_AND";
        case   0x2A5A: return "LOGICAL_AND_WITH_MIDDLE_STEM";
        case   0x2A5B: return "LOGICAL_OR_WITH_MIDDLE_STEM";
        case   0x2A5C: return "LOGICAL_AND_WITH_HORIZONTAL_DASH";
        case   0x2A5D: return "LOGICAL_OR_WITH_HORIZONTAL_DASH";
        case   0x2A5E: return "LOGICAL_AND_WITH_DOUBLE_OVERBAR";
        case   0x2A5F: return "LOGICAL_AND_WITH_UNDERBAR";
        case   0x2A60: return "LOGICAL_AND_WITH_DOUBLE_UNDERBAR";
        case   0x2A61: return "SMALL_VEE_WITH_UNDERBAR";
        case   0x2A62: return "LOGICAL_OR_WITH_DOUBLE_OVERBAR";
        case   0x2A63: return "LOGICAL_OR_WITH_DOUBLE_UNDERBAR";
        case   0x2A64: return "Z_NOTATION_DOMAIN_ANTIRESTRICTION";
        case   0x2A65: return "Z_NOTATION_RANGE_ANTIRESTRICTION";
        case   0x2A66: return "EQUALS_SIGN_WITH_DOT_BELOW";
        case   0x2A67: return "IDENTICAL_WITH_DOT_ABOVE";
        case   0x2A68: return
                "TRIPLE_HORIZONTAL_BAR_WITH_DOUBLE_VERTICAL_STROKE";
        case   0x2A69: return
                "TRIPLE_HORIZONTAL_BAR_WITH_TRIPLE_VERTICAL_STROKE";
        case   0x2A6A: return "TILDE_OPERATOR_WITH_DOT_ABOVE";
        case   0x2A6B: return "TILDE_OPERATOR_WITH_RISING_DOTS";
        case   0x2A6C: return "SIMILAR_MINUS_SIMILAR";
        case   0x2A6D: return "CONGRUENT_WITH_DOT_ABOVE";
        case   0x2A6E: return "EQUALS_WITH_ASTERISK";
        case   0x2A6F: return "ALMOST_EQUAL_TO_WITH_CIRCUMFLEX_ACCENT";
        case   0x2A70: return "APPROXIMATELY_EQUAL_OR_EQUAL_TO";
        case   0x2A71: return "EQUALS_SIGN_ABOVE_PLUS_SIGN";
        case   0x2A72: return "PLUS_SIGN_ABOVE_EQUALS_SIGN";
        case   0x2A73: return "EQUALS_SIGN_ABOVE_TILDE_OPERATOR";
        case   0x2A74: return "DOUBLE_COLON_EQUAL";
        case   0x2A75: return "TWO_CONSECUTIVE_EQUALS_SIGNS";
        case   0x2A76: return "THREE_CONSECUTIVE_EQUALS_SIGNS";
        case   0x2A77: return
                "EQUALS_SIGN_WITH_TWO_DOTS_ABOVE_AND_TWO_DOTS_BELOW";
        case   0x2A78: return "EQUIVALENT_WITH_FOUR_DOTS_ABOVE";
        case   0x2A79: return "LESS_THAN_WITH_CIRCLE_INSIDE";
        case   0x2A7A: return "GREATER_THAN_WITH_CIRCLE_INSIDE";
        case   0x2A7B: return "LESS_THAN_WITH_QUESTION_MARK_ABOVE";
        case   0x2A7C: return "GREATER_THAN_WITH_QUESTION_MARK_ABOVE";
        case   0x2A7D: return "LESS_THAN_OR_SLANTED_EQUAL_TO";
        case   0x2A7E: return "GREATER_THAN_OR_SLANTED_EQUAL_TO";
        case   0x2A7F: return "LESS_THAN_OR_SLANTED_EQUAL_TO_WITH_DOT_INSIDE";
        case   0x2A80: return
                "GREATER_THAN_OR_SLANTED_EQUAL_TO_WITH_DOT_INSIDE";
        case   0x2A81: return "LESS_THAN_OR_SLANTED_EQUAL_TO_WITH_DOT_ABOVE";
        case   0x2A82: return
                "GREATER_THAN_OR_SLANTED_EQUAL_TO_WITH_DOT_ABOVE";
        case   0x2A83: return
                "LESS_THAN_OR_SLANTED_EQUAL_TO_WITH_DOT_ABOVE_RIGHT";
        case   0x2A84: return
                "GREATER_THAN_OR_SLANTED_EQUAL_TO_WITH_DOT_ABOVE_LEFT";
        case   0x2A85: return "LESS_THAN_OR_APPROXIMATE";
        case   0x2A86: return "GREATER_THAN_OR_APPROXIMATE";
        case   0x2A87: return "LESS_THAN_AND_SINGLE_LINE_NOT_EQUAL_TO";
        case   0x2A88: return "GREATER_THAN_AND_SINGLE_LINE_NOT_EQUAL_TO";
        case   0x2A89: return "LESS_THAN_AND_NOT_APPROXIMATE";
        case   0x2A8A: return "GREATER_THAN_AND_NOT_APPROXIMATE";
        case   0x2A8B: return
                "LESS_THAN_ABOVE_DOUBLE_LINE_EQUAL_ABOVE_GREATER_THAN";
        case   0x2A8C: return
                "GREATER_THAN_ABOVE_DOUBLE_LINE_EQUAL_ABOVE_LESS_THAN";
        case   0x2A8D: return "LESS_THAN_ABOVE_SIMILAR_OR_EQUAL";
        case   0x2A8E: return "GREATER_THAN_ABOVE_SIMILAR_OR_EQUAL";
        case   0x2A8F: return "LESS_THAN_ABOVE_SIMILAR_ABOVE_GREATER_THAN";
        case   0x2A90: return "GREATER_THAN_ABOVE_SIMILAR_ABOVE_LESS_THAN";
        case   0x2A91: return
                "LESS_THAN_ABOVE_GREATER_THAN_ABOVE_DOUBLE_LINE_EQUAL";
        case   0x2A92: return
                "GREATER_THAN_ABOVE_LESS_THAN_ABOVE_DOUBLE_LINE_EQUAL";
        case   0x2A93: return
                "LESS_THAN_ABOVE_SLANTED_EQUAL_ABOVE_GREATER_THAN_ABOVE_SLANTED_EQUAL";
        case   0x2A94: return
                "GREATER_THAN_ABOVE_SLANTED_EQUAL_ABOVE_LESS_THAN_ABOVE_SLANTED_EQUAL";
        case   0x2A95: return "SLANTED_EQUAL_TO_OR_LESS_THAN";
        case   0x2A96: return "SLANTED_EQUAL_TO_OR_GREATER_THAN";
        case   0x2A97: return "SLANTED_EQUAL_TO_OR_LESS_THAN_WITH_DOT_INSIDE";
        case   0x2A98: return
                "SLANTED_EQUAL_TO_OR_GREATER_THAN_WITH_DOT_INSIDE";
        case   0x2A99: return "DOUBLE_LINE_EQUAL_TO_OR_LESS_THAN";
        case   0x2A9A: return "DOUBLE_LINE_EQUAL_TO_OR_GREATER_THAN";
        case   0x2A9B: return "DOUBLE_LINE_SLANTED_EQUAL_TO_OR_LESS_THAN";
        case   0x2A9C: return "DOUBLE_LINE_SLANTED_EQUAL_TO_OR_GREATER_THAN";
        case   0x2A9D: return "SIMILAR_OR_LESS_THAN";
        case   0x2A9E: return "SIMILAR_OR_GREATER_THAN";
        case   0x2A9F: return "SIMILAR_ABOVE_LESS_THAN_ABOVE_EQUALS_SIGN";
        case   0x2AA0: return "SIMILAR_ABOVE_GREATER_THAN_ABOVE_EQUALS_SIGN";
        case   0x2AA1: return "DOUBLE_NESTED_LESS_THAN";
        case   0x2AA2: return "DOUBLE_NESTED_GREATER_THAN";
        case   0x2AA3: return "DOUBLE_NESTED_LESS_THAN_WITH_UNDERBAR";
        case   0x2AA4: return "GREATER_THAN_OVERLAPPING_LESS_THAN";
        case   0x2AA5: return "GREATER_THAN_BESIDE_LESS_THAN";
        case   0x2AA6: return "LESS_THAN_CLOSED_BY_CURVE";
        case   0x2AA7: return "GREATER_THAN_CLOSED_BY_CURVE";
        case   0x2AA8: return "LESS_THAN_CLOSED_BY_CURVE_ABOVE_SLANTED_EQUAL";
        case   0x2AA9: return
                "GREATER_THAN_CLOSED_BY_CURVE_ABOVE_SLANTED_EQUAL";
        case   0x2AAA: return "SMALLER_THAN";
        case   0x2AAB: return "LARGER_THAN";
        case   0x2AAC: return "SMALLER_THAN_OR_EQUAL_TO";
        case   0x2AAD: return "LARGER_THAN_OR_EQUAL_TO";
        case   0x2AAE: return "EQUALS_SIGN_WITH_BUMPY_ABOVE";
        case   0x2AAF: return "PRECEDES_ABOVE_SINGLE_LINE_EQUALS_SIGN";
        case   0x2AB0: return "SUCCEEDS_ABOVE_SINGLE_LINE_EQUALS_SIGN";
        case   0x2AB1: return "PRECEDES_ABOVE_SINGLE_LINE_NOT_EQUAL_TO";
        case   0x2AB2: return "SUCCEEDS_ABOVE_SINGLE_LINE_NOT_EQUAL_TO";
        case   0x2AB3: return "PRECEDES_ABOVE_EQUALS_SIGN";
        case   0x2AB4: return "SUCCEEDS_ABOVE_EQUALS_SIGN";
        case   0x2AB5: return "PRECEDES_ABOVE_NOT_EQUAL_TO";
        case   0x2AB6: return "SUCCEEDS_ABOVE_NOT_EQUAL_TO";
        case   0x2AB7: return "PRECEDES_ABOVE_ALMOST_EQUAL_TO";
        case   0x2AB8: return "SUCCEEDS_ABOVE_ALMOST_EQUAL_TO";
        case   0x2AB9: return "PRECEDES_ABOVE_NOT_ALMOST_EQUAL_TO";
        case   0x2ABA: return "SUCCEEDS_ABOVE_NOT_ALMOST_EQUAL_TO";
        case   0x2ABB: return "DOUBLE_PRECEDES";
        case   0x2ABC: return "DOUBLE_SUCCEEDS";
        case   0x2ABD: return "SUBSET_WITH_DOT";
        case   0x2ABE: return "SUPERSET_WITH_DOT";
        case   0x2ABF: return "SUBSET_WITH_PLUS_SIGN_BELOW";
        case   0x2AC0: return "SUPERSET_WITH_PLUS_SIGN_BELOW";
        case   0x2AC1: return "SUBSET_WITH_MULTIPLICATION_SIGN_BELOW";
        case   0x2AC2: return "SUPERSET_WITH_MULTIPLICATION_SIGN_BELOW";
        case   0x2AC3: return "SUBSET_OF_OR_EQUAL_TO_WITH_DOT_ABOVE";
        case   0x2AC4: return "SUPERSET_OF_OR_EQUAL_TO_WITH_DOT_ABOVE";
        case   0x2AC5: return "SUBSET_OF_ABOVE_EQUALS_SIGN";
        case   0x2AC6: return "SUPERSET_OF_ABOVE_EQUALS_SIGN";
        case   0x2AC7: return "SUBSET_OF_ABOVE_TILDE_OPERATOR";
        case   0x2AC8: return "SUPERSET_OF_ABOVE_TILDE_OPERATOR";
        case   0x2AC9: return "SUBSET_OF_ABOVE_ALMOST_EQUAL_TO";
        case   0x2ACA: return "SUPERSET_OF_ABOVE_ALMOST_EQUAL_TO";
        case   0x2ACB: return "SUBSET_OF_ABOVE_NOT_EQUAL_TO";
        case   0x2ACC: return "SUPERSET_OF_ABOVE_NOT_EQUAL_TO";
        case   0x2ACD: return "SQUARE_LEFT_OPEN_BOX_OPERATOR";
        case   0x2ACE: return "SQUARE_RIGHT_OPEN_BOX_OPERATOR";
        case   0x2ACF: return "CLOSED_SUBSET";
        case   0x2AD0: return "CLOSED_SUPERSET";
        case   0x2AD1: return "CLOSED_SUBSET_OR_EQUAL_TO";
        case   0x2AD2: return "CLOSED_SUPERSET_OR_EQUAL_TO";
        case   0x2AD3: return "SUBSET_ABOVE_SUPERSET";
        case   0x2AD4: return "SUPERSET_ABOVE_SUBSET";
        case   0x2AD5: return "SUBSET_ABOVE_SUBSET";
        case   0x2AD6: return "SUPERSET_ABOVE_SUPERSET";
        case   0x2AD7: return "SUPERSET_BESIDE_SUBSET";
        case   0x2AD8: return
                "SUPERSET_BESIDE_AND_JOINED_BY_DASH_WITH_SUBSET";
        case   0x2AD9: return "ELEMENT_OF_OPENING_DOWNWARDS";
        case   0x2ADA: return "PITCHFORK_WITH_TEE_TOP";
        case   0x2ADB: return "TRANSVERSAL_INTERSECTION";
        case   0x2ADC: return "FORKING";
        case   0x2ADD: return "NONFORKING";
        case   0x2ADE: return "SHORT_LEFT_TACK";
        case   0x2ADF: return "SHORT_DOWN_TACK";
        case   0x2AE0: return "SHORT_UP_TACK";
        case   0x2AE1: return "PERPENDICULAR_WITH_S";
        case   0x2AE2: return "VERTICAL_BAR_TRIPLE_RIGHT_TURNSTILE";
        case   0x2AE3: return "DOUBLE_VERTICAL_BAR_LEFT_TURNSTILE";
        case   0x2AE4: return "VERTICAL_BAR_DOUBLE_LEFT_TURNSTILE";
        case   0x2AE5: return "DOUBLE_VERTICAL_BAR_DOUBLE_LEFT_TURNSTILE";
        case   0x2AE6: return "LONG_DASH_FROM_LEFT_MEMBER_OF_DOUBLE_VERTICAL";
        case   0x2AE7: return "SHORT_DOWN_TACK_WITH_OVERBAR";
        case   0x2AE8: return "SHORT_UP_TACK_WITH_UNDERBAR";
        case   0x2AE9: return "SHORT_UP_TACK_ABOVE_SHORT_DOWN_TACK";
        case   0x2AEA: return "DOUBLE_DOWN_TACK";
        case   0x2AEB: return "DOUBLE_UP_TACK";
        case   0x2AEC: return "DOUBLE_STROKE_NOT_SIGN";
        case   0x2AED: return "REVERSED_DOUBLE_STROKE_NOT_SIGN";
        case   0x2AEE: return "DOES_NOT_DIVIDE_WITH_REVERSED_NEGATION_SLASH";
        case   0x2AEF: return "VERTICAL_LINE_WITH_CIRCLE_ABOVE";
        case   0x2AF0: return "VERTICAL_LINE_WITH_CIRCLE_BELOW";
        case   0x2AF1: return "DOWN_TACK_WITH_CIRCLE_BELOW";
        case   0x2AF2: return "PARALLEL_WITH_HORIZONTAL_STROKE";
        case   0x2AF3: return "PARALLEL_WITH_TILDE_OPERATOR";
        case   0x2AF4: return "TRIPLE_VERTICAL_BAR_BINARY_RELATION";
        case   0x2AF5: return "TRIPLE_VERTICAL_BAR_WITH_HORIZONTAL_STROKE";
        case   0x2AF6: return "TRIPLE_COLON_OPERATOR";
        case   0x2AF7: return "TRIPLE_NESTED_LESS_THAN";
        case   0x2AF8: return "TRIPLE_NESTED_GREATER_THAN";
        case   0x2AF9: return "DOUBLE_LINE_SLANTED_LESS_THAN_OR_EQUAL_TO";
        case   0x2AFA: return "DOUBLE_LINE_SLANTED_GREATER_THAN_OR_EQUAL_TO";
        case   0x2AFB: return "TRIPLE_SOLIDUS_BINARY_RELATION";
        case   0x2AFC: return "LARGE_TRIPLE_VERTICAL_BAR_OPERATOR";
        case   0x2AFD: return "DOUBLE_SOLIDUS_OPERATOR";
        case   0x2AFE: return "WHITE_VERTICAL_BAR";
        case   0x2AFF: return "N_ARY_WHITE_VERTICAL_BAR";
        case   0x2B00: return "NORTH_EAST_WHITE_ARROW";
        case   0x2B01: return "NORTH_WEST_WHITE_ARROW";
        case   0x2B02: return "SOUTH_EAST_WHITE_ARROW";
        case   0x2B03: return "SOUTH_WEST_WHITE_ARROW";
        case   0x2B04: return "LEFT_RIGHT_WHITE_ARROW";
        case   0x2B05: return "LEFTWARDS_BLACK_ARROW";
        case   0x2B06: return "UPWARDS_BLACK_ARROW";
        case   0x2B07: return "DOWNWARDS_BLACK_ARROW";
        case   0x2B08: return "NORTH_EAST_BLACK_ARROW";
        case   0x2B09: return "NORTH_WEST_BLACK_ARROW";
        case   0x2B0A: return "SOUTH_EAST_BLACK_ARROW";
        case   0x2B0B: return "SOUTH_WEST_BLACK_ARROW";
        case   0x2B0C: return "LEFT_RIGHT_BLACK_ARROW";
        case   0x2B0D: return "UP_DOWN_BLACK_ARROW";
        case   0x2B0E: return "RIGHTWARDS_ARROW_WITH_TIP_DOWNWARDS";
        case   0x2B0F: return "RIGHTWARDS_ARROW_WITH_TIP_UPWARDS";
        case   0x2B10: return "LEFTWARDS_ARROW_WITH_TIP_DOWNWARDS";
        case   0x2B11: return "LEFTWARDS_ARROW_WITH_TIP_UPWARDS";
        case   0x2B12: return "SQUARE_WITH_TOP_HALF_BLACK";
        case   0x2B13: return "SQUARE_WITH_BOTTOM_HALF_BLACK";
        case   0x2B14: return "SQUARE_WITH_UPPER_RIGHT_DIAGONAL_HALF_BLACK";
        case   0x2B15: return "SQUARE_WITH_LOWER_LEFT_DIAGONAL_HALF_BLACK";
        case   0x2B16: return "DIAMOND_WITH_LEFT_HALF_BLACK";
        case   0x2B17: return "DIAMOND_WITH_RIGHT_HALF_BLACK";
        case   0x2B18: return "DIAMOND_WITH_TOP_HALF_BLACK";
        case   0x2B19: return "DIAMOND_WITH_BOTTOM_HALF_BLACK";
        case   0x2B1A: return "DOTTED_SQUARE";
        case   0x2B1B: return "BLACK_LARGE_SQUARE";
        case   0x2B1C: return "WHITE_LARGE_SQUARE";
        case   0x2B1D: return "BLACK_VERY_SMALL_SQUARE";
        case   0x2B1E: return "WHITE_VERY_SMALL_SQUARE";
        case   0x2B1F: return "BLACK_PENTAGON";
        case   0x2B20: return "WHITE_PENTAGON";
        case   0x2B21: return "WHITE_HEXAGON";
        case   0x2B22: return "BLACK_HEXAGON";
        case   0x2B23: return "HORIZONTAL_BLACK_HEXAGON";
        case   0x2B24: return "BLACK_LARGE_CIRCLE";
        case   0x2B25: return "BLACK_MEDIUM_DIAMOND";
        case   0x2B26: return "WHITE_MEDIUM_DIAMOND";
        case   0x2B27: return "BLACK_MEDIUM_LOZENGE";
        case   0x2B28: return "WHITE_MEDIUM_LOZENGE";
        case   0x2B29: return "BLACK_SMALL_DIAMOND";
        case   0x2B2A: return "BLACK_SMALL_LOZENGE";
        case   0x2B2B: return "WHITE_SMALL_LOZENGE";
        case   0x2B2C: return "BLACK_HORIZONTAL_ELLIPSE";
        case   0x2B2D: return "WHITE_HORIZONTAL_ELLIPSE";
        case   0x2B2E: return "BLACK_VERTICAL_ELLIPSE";
        case   0x2B2F: return "WHITE_VERTICAL_ELLIPSE";
        case   0x2B30: return "LEFT_ARROW_WITH_SMALL_CIRCLE";
        case   0x2B31: return "THREE_LEFTWARDS_ARROWS";
        case   0x2B32: return "LEFT_ARROW_WITH_CIRCLED_PLUS";
        case   0x2B33: return "LONG_LEFTWARDS_SQUIGGLE_ARROW";
        case   0x2B34: return
                "LEFTWARDS_TWO_HEADED_ARROW_WITH_VERTICAL_STROKE";
        case   0x2B35: return
                "LEFTWARDS_TWO_HEADED_ARROW_WITH_DOUBLE_VERTICAL_STROKE";
        case   0x2B36: return "LEFTWARDS_TWO_HEADED_ARROW_FROM_BAR";
        case   0x2B37: return "LEFTWARDS_TWO_HEADED_TRIPLE_DASH_ARROW";
        case   0x2B38: return "LEFTWARDS_ARROW_WITH_DOTTED_STEM";
        case   0x2B39: return
                "LEFTWARDS_ARROW_WITH_TAIL_WITH_VERTICAL_STROKE";
        case   0x2B3A: return
                "LEFTWARDS_ARROW_WITH_TAIL_WITH_DOUBLE_VERTICAL_STROKE";
        case   0x2B3B: return "LEFTWARDS_TWO_HEADED_ARROW_WITH_TAIL";
        case   0x2B3C: return
                "LEFTWARDS_TWO_HEADED_ARROW_WITH_TAIL_WITH_VERTICAL_STROKE";
        case   0x2B3D: return
                "LEFTWARDS_TWO_HEADED_ARROW_WITH_TAIL_WITH_DOUBLE_VERTICAL_STROKE";
        case   0x2B3E: return "LEFTWARDS_ARROW_THROUGH_X";
        case   0x2B3F: return "WAVE_ARROW_POINTING_DIRECTLY_LEFT";
        case   0x2B40: return "EQUALS_SIGN_ABOVE_LEFTWARDS_ARROW";
        case   0x2B41: return "REVERSE_TILDE_OPERATOR_ABOVE_LEFTWARDS_ARROW";
        case   0x2B42: return "LEFTWARDS_ARROW_ABOVE_REVERSE_ALMOST_EQUAL_TO";
        case   0x2B43: return "RIGHTWARDS_ARROW_THROUGH_GREATER_THAN";
        case   0x2B44: return "RIGHTWARDS_ARROW_THROUGH_SUPERSET";
        case   0x2B45: return "LEFTWARDS_QUADRUPLE_ARROW";
        case   0x2B46: return "RIGHTWARDS_QUADRUPLE_ARROW";
        case   0x2B47: return "REVERSE_TILDE_OPERATOR_ABOVE_RIGHTWARDS_ARROW";
        case   0x2B48: return
                "RIGHTWARDS_ARROW_ABOVE_REVERSE_ALMOST_EQUAL_TO";
        case   0x2B49: return "TILDE_OPERATOR_ABOVE_LEFTWARDS_ARROW";
        case   0x2B4A: return "LEFTWARDS_ARROW_ABOVE_ALMOST_EQUAL_TO";
        case   0x2B4B: return "LEFTWARDS_ARROW_ABOVE_REVERSE_TILDE_OPERATOR";
        case   0x2B4C: return "RIGHTWARDS_ARROW_ABOVE_REVERSE_TILDE_OPERATOR";
        case   0x2B4D: return "DOWNWARDS_TRIANGLE_HEADED_ZIGZAG_ARROW";
        case   0x2B4E: return "SHORT_SLANTED_NORTH_ARROW";
        case   0x2B4F: return "SHORT_BACKSLANTED_SOUTH_ARROW";
        case   0x2B50: return "WHITE_MEDIUM_STAR";
        case   0x2B51: return "BLACK_SMALL_STAR";
        case   0x2B52: return "WHITE_SMALL_STAR";
        case   0x2B53: return "BLACK_RIGHT_POINTING_PENTAGON";
        case   0x2B54: return "WHITE_RIGHT_POINTING_PENTAGON";
        case   0x2B55: return "HEAVY_LARGE_CIRCLE";
        case   0x2B56: return "HEAVY_OVAL_WITH_OVAL_INSIDE";
        case   0x2B57: return "HEAVY_CIRCLE_WITH_CIRCLE_INSIDE";
        case   0x2B58: return "HEAVY_CIRCLE";
        case   0x2B59: return "HEAVY_CIRCLED_SALTIRE";
        case   0x2B5A: return "SLANTED_NORTH_ARROW_WITH_HOOKED_HEAD";
        case   0x2B5B: return "BACKSLANTED_SOUTH_ARROW_WITH_HOOKED_TAIL";
        case   0x2B5C: return "SLANTED_NORTH_ARROW_WITH_HORIZONTAL_TAIL";
        case   0x2B5D: return "BACKSLANTED_SOUTH_ARROW_WITH_HORIZONTAL_TAIL";
        case   0x2B5E: return "BENT_ARROW_POINTING_DOWNWARDS_THEN_NORTH_EAST";
        case   0x2B5F: return
                "SHORT_BENT_ARROW_POINTING_DOWNWARDS_THEN_NORTH_EAST";
        case   0x2B60: return "LEFTWARDS_TRIANGLE_HEADED_ARROW";
        case   0x2B61: return "UPWARDS_TRIANGLE_HEADED_ARROW";
        case   0x2B62: return "RIGHTWARDS_TRIANGLE_HEADED_ARROW";
        case   0x2B63: return "DOWNWARDS_TRIANGLE_HEADED_ARROW";
        case   0x2B64: return "LEFT_RIGHT_TRIANGLE_HEADED_ARROW";
        case   0x2B65: return "UP_DOWN_TRIANGLE_HEADED_ARROW";
        case   0x2B66: return "NORTH_WEST_TRIANGLE_HEADED_ARROW";
        case   0x2B67: return "NORTH_EAST_TRIANGLE_HEADED_ARROW";
        case   0x2B68: return "SOUTH_EAST_TRIANGLE_HEADED_ARROW";
        case   0x2B69: return "SOUTH_WEST_TRIANGLE_HEADED_ARROW";
        case   0x2B6A: return "LEFTWARDS_TRIANGLE_HEADED_DASHED_ARROW";
        case   0x2B6B: return "UPWARDS_TRIANGLE_HEADED_DASHED_ARROW";
        case   0x2B6C: return "RIGHTWARDS_TRIANGLE_HEADED_DASHED_ARROW";
        case   0x2B6D: return "DOWNWARDS_TRIANGLE_HEADED_DASHED_ARROW";
        case   0x2B6E: return "CLOCKWISE_TRIANGLE_HEADED_OPEN_CIRCLE_ARROW";
        case   0x2B6F: return
                "ANTICLOCKWISE_TRIANGLE_HEADED_OPEN_CIRCLE_ARROW";
        case   0x2B70: return "LEFTWARDS_TRIANGLE_HEADED_ARROW_TO_BAR";
        case   0x2B71: return "UPWARDS_TRIANGLE_HEADED_ARROW_TO_BAR";
        case   0x2B72: return "RIGHTWARDS_TRIANGLE_HEADED_ARROW_TO_BAR";
        case   0x2B73: return "DOWNWARDS_TRIANGLE_HEADED_ARROW_TO_BAR";
        case   0x2B76: return "NORTH_WEST_TRIANGLE_HEADED_ARROW_TO_BAR";
        case   0x2B77: return "NORTH_EAST_TRIANGLE_HEADED_ARROW_TO_BAR";
        case   0x2B78: return "SOUTH_EAST_TRIANGLE_HEADED_ARROW_TO_BAR";
        case   0x2B79: return "SOUTH_WEST_TRIANGLE_HEADED_ARROW_TO_BAR";
        case   0x2B7A: return
                "LEFTWARDS_TRIANGLE_HEADED_ARROW_WITH_DOUBLE_HORIZONTAL_STROKE";
        case   0x2B7B: return
                "UPWARDS_TRIANGLE_HEADED_ARROW_WITH_DOUBLE_HORIZONTAL_STROKE";
        case   0x2B7C: return
                "RIGHTWARDS_TRIANGLE_HEADED_ARROW_WITH_DOUBLE_HORIZONTAL_STROKE";
        case   0x2B7D: return
                "DOWNWARDS_TRIANGLE_HEADED_ARROW_WITH_DOUBLE_HORIZONTAL_STROKE";
        case   0x2B7E: return "HORIZONTAL_TAB_KEY";
        case   0x2B7F: return "VERTICAL_TAB_KEY";
        case   0x2B80: return
                "LEFTWARDS_TRIANGLE_HEADED_ARROW_OVER_RIGHTWARDS_TRIANGLE_HEADED_ARROW";
        case   0x2B81: return
                "UPWARDS_TRIANGLE_HEADED_ARROW_LEFTWARDS_OF_DOWNWARDS_TRIANGLE_HEADED_ARROW";
        case   0x2B82: return
                "RIGHTWARDS_TRIANGLE_HEADED_ARROW_OVER_LEFTWARDS_TRIANGLE_HEADED_ARROW";
        case   0x2B83: return
                "DOWNWARDS_TRIANGLE_HEADED_ARROW_LEFTWARDS_OF_UPWARDS_TRIANGLE_HEADED_ARROW";
        case   0x2B84: return "LEFTWARDS_TRIANGLE_HEADED_PAIRED_ARROWS";
        case   0x2B85: return "UPWARDS_TRIANGLE_HEADED_PAIRED_ARROWS";
        case   0x2B86: return "RIGHTWARDS_TRIANGLE_HEADED_PAIRED_ARROWS";
        case   0x2B87: return "DOWNWARDS_TRIANGLE_HEADED_PAIRED_ARROWS";
        case   0x2B88: return "LEFTWARDS_BLACK_CIRCLED_WHITE_ARROW";
        case   0x2B89: return "UPWARDS_BLACK_CIRCLED_WHITE_ARROW";
        case   0x2B8A: return "RIGHTWARDS_BLACK_CIRCLED_WHITE_ARROW";
        case   0x2B8B: return "DOWNWARDS_BLACK_CIRCLED_WHITE_ARROW";
        case   0x2B8C: return
                "ANTICLOCKWISE_TRIANGLE_HEADED_RIGHT_U_SHAPED_ARROW";
        case   0x2B8D: return
                "ANTICLOCKWISE_TRIANGLE_HEADED_BOTTOM_U_SHAPED_ARROW";
        case   0x2B8E: return
                "ANTICLOCKWISE_TRIANGLE_HEADED_LEFT_U_SHAPED_ARROW";
        case   0x2B8F: return
                "ANTICLOCKWISE_TRIANGLE_HEADED_TOP_U_SHAPED_ARROW";
        case   0x2B90: return "RETURN_LEFT";
        case   0x2B91: return "RETURN_RIGHT";
        case   0x2B92: return "NEWLINE_LEFT";
        case   0x2B93: return "NEWLINE_RIGHT";
        case   0x2B94: return "FOUR_CORNER_ARROWS_CIRCLING_ANTICLOCKWISE";
        case   0x2B95: return "RIGHTWARDS_BLACK_ARROW";
        case   0x2B98: return
                "THREE_D_TOP_LIGHTED_LEFTWARDS_EQUILATERAL_ARROWHEAD";
        case   0x2B99: return
                "THREE_D_RIGHT_LIGHTED_UPWARDS_EQUILATERAL_ARROWHEAD";
        case   0x2B9A: return
                "THREE_D_TOP_LIGHTED_RIGHTWARDS_EQUILATERAL_ARROWHEAD";
        case   0x2B9B: return
                "THREE_D_LEFT_LIGHTED_DOWNWARDS_EQUILATERAL_ARROWHEAD";
        case   0x2B9C: return "BLACK_LEFTWARDS_EQUILATERAL_ARROWHEAD";
        case   0x2B9D: return "BLACK_UPWARDS_EQUILATERAL_ARROWHEAD";
        case   0x2B9E: return "BLACK_RIGHTWARDS_EQUILATERAL_ARROWHEAD";
        case   0x2B9F: return "BLACK_DOWNWARDS_EQUILATERAL_ARROWHEAD";
        case   0x2BA0: return
                "DOWNWARDS_TRIANGLE_HEADED_ARROW_WITH_LONG_TIP_LEFTWARDS";
        case   0x2BA1: return
                "DOWNWARDS_TRIANGLE_HEADED_ARROW_WITH_LONG_TIP_RIGHTWARDS";
        case   0x2BA2: return
                "UPWARDS_TRIANGLE_HEADED_ARROW_WITH_LONG_TIP_LEFTWARDS";
        case   0x2BA3: return
                "UPWARDS_TRIANGLE_HEADED_ARROW_WITH_LONG_TIP_RIGHTWARDS";
        case   0x2BA4: return
                "LEFTWARDS_TRIANGLE_HEADED_ARROW_WITH_LONG_TIP_UPWARDS";
        case   0x2BA5: return
                "RIGHTWARDS_TRIANGLE_HEADED_ARROW_WITH_LONG_TIP_UPWARDS";
        case   0x2BA6: return
                "LEFTWARDS_TRIANGLE_HEADED_ARROW_WITH_LONG_TIP_DOWNWARDS";
        case   0x2BA7: return
                "RIGHTWARDS_TRIANGLE_HEADED_ARROW_WITH_LONG_TIP_DOWNWARDS";
        case   0x2BA8: return "BLACK_CURVED_DOWNWARDS_AND_LEFTWARDS_ARROW";
        case   0x2BA9: return "BLACK_CURVED_DOWNWARDS_AND_RIGHTWARDS_ARROW";
        case   0x2BAA: return "BLACK_CURVED_UPWARDS_AND_LEFTWARDS_ARROW";
        case   0x2BAB: return "BLACK_CURVED_UPWARDS_AND_RIGHTWARDS_ARROW";
        case   0x2BAC: return "BLACK_CURVED_LEFTWARDS_AND_UPWARDS_ARROW";
        case   0x2BAD: return "BLACK_CURVED_RIGHTWARDS_AND_UPWARDS_ARROW";
        case   0x2BAE: return "BLACK_CURVED_LEFTWARDS_AND_DOWNWARDS_ARROW";
        case   0x2BAF: return "BLACK_CURVED_RIGHTWARDS_AND_DOWNWARDS_ARROW";
        case   0x2BB0: return "RIBBON_ARROW_DOWN_LEFT";
        case   0x2BB1: return "RIBBON_ARROW_DOWN_RIGHT";
        case   0x2BB2: return "RIBBON_ARROW_UP_LEFT";
        case   0x2BB3: return "RIBBON_ARROW_UP_RIGHT";
        case   0x2BB4: return "RIBBON_ARROW_LEFT_UP";
        case   0x2BB5: return "RIBBON_ARROW_RIGHT_UP";
        case   0x2BB6: return "RIBBON_ARROW_LEFT_DOWN";
        case   0x2BB7: return "RIBBON_ARROW_RIGHT_DOWN";
        case   0x2BB8: return
                "UPWARDS_WHITE_ARROW_FROM_BAR_WITH_HORIZONTAL_BAR";
        case   0x2BB9: return "UP_ARROWHEAD_IN_A_RECTANGLE_BOX";
        case   0x2BBD: return "BALLOT_BOX_WITH_LIGHT_X";
        case   0x2BBE: return "CIRCLED_X";
        case   0x2BBF: return "CIRCLED_BOLD_X";
        case   0x2BC0: return "BLACK_SQUARE_CENTRED";
        case   0x2BC1: return "BLACK_DIAMOND_CENTRED";
        case   0x2BC2: return "TURNED_BLACK_PENTAGON";
        case   0x2BC3: return "HORIZONTAL_BLACK_OCTAGON";
        case   0x2BC4: return "BLACK_OCTAGON";
        case   0x2BC5: return "BLACK_MEDIUM_UP_POINTING_TRIANGLE_CENTRED";
        case   0x2BC6: return "BLACK_MEDIUM_DOWN_POINTING_TRIANGLE_CENTRED";
        case   0x2BC7: return "BLACK_MEDIUM_LEFT_POINTING_TRIANGLE_CENTRED";
        case   0x2BC8: return "BLACK_MEDIUM_RIGHT_POINTING_TRIANGLE_CENTRED";
        case   0x2BCA: return "TOP_HALF_BLACK_CIRCLE";
        case   0x2BCB: return "BOTTOM_HALF_BLACK_CIRCLE";
        case   0x2BCC: return "LIGHT_FOUR_POINTED_BLACK_CUSP";
        case   0x2BCD: return "ROTATED_LIGHT_FOUR_POINTED_BLACK_CUSP";
        case   0x2BCE: return "WHITE_FOUR_POINTED_CUSP";
        case   0x2BCF: return "ROTATED_WHITE_FOUR_POINTED_CUSP";
        case   0x2BD0: return "SQUARE_POSITION_INDICATOR";
        case   0x2BD1: return "UNCERTAINTY_SIGN";
        case   0x2C00: return "GLAGOLITIC_CAPITAL_LETTER_AZU";
        case   0x2C01: return "GLAGOLITIC_CAPITAL_LETTER_BUKY";
        case   0x2C02: return "GLAGOLITIC_CAPITAL_LETTER_VEDE";
        case   0x2C03: return "GLAGOLITIC_CAPITAL_LETTER_GLAGOLI";
        case   0x2C04: return "GLAGOLITIC_CAPITAL_LETTER_DOBRO";
        case   0x2C05: return "GLAGOLITIC_CAPITAL_LETTER_YESTU";
        case   0x2C06: return "GLAGOLITIC_CAPITAL_LETTER_ZHIVETE";
        case   0x2C07: return "GLAGOLITIC_CAPITAL_LETTER_DZELO";
        case   0x2C08: return "GLAGOLITIC_CAPITAL_LETTER_ZEMLJA";
        case   0x2C09: return "GLAGOLITIC_CAPITAL_LETTER_IZHE";
        case   0x2C0A: return "GLAGOLITIC_CAPITAL_LETTER_INITIAL_IZHE";
        case   0x2C0B: return "GLAGOLITIC_CAPITAL_LETTER_I";
        case   0x2C0C: return "GLAGOLITIC_CAPITAL_LETTER_DJERVI";
        case   0x2C0D: return "GLAGOLITIC_CAPITAL_LETTER_KAKO";
        case   0x2C0E: return "GLAGOLITIC_CAPITAL_LETTER_LJUDIJE";
        case   0x2C0F: return "GLAGOLITIC_CAPITAL_LETTER_MYSLITE";
        case   0x2C10: return "GLAGOLITIC_CAPITAL_LETTER_NASHI";
        case   0x2C11: return "GLAGOLITIC_CAPITAL_LETTER_ONU";
        case   0x2C12: return "GLAGOLITIC_CAPITAL_LETTER_POKOJI";
        case   0x2C13: return "GLAGOLITIC_CAPITAL_LETTER_RITSI";
        case   0x2C14: return "GLAGOLITIC_CAPITAL_LETTER_SLOVO";
        case   0x2C15: return "GLAGOLITIC_CAPITAL_LETTER_TVRIDO";
        case   0x2C16: return "GLAGOLITIC_CAPITAL_LETTER_UKU";
        case   0x2C17: return "GLAGOLITIC_CAPITAL_LETTER_FRITU";
        case   0x2C18: return "GLAGOLITIC_CAPITAL_LETTER_HERU";
        case   0x2C19: return "GLAGOLITIC_CAPITAL_LETTER_OTU";
        case   0x2C1A: return "GLAGOLITIC_CAPITAL_LETTER_PE";
        case   0x2C1B: return "GLAGOLITIC_CAPITAL_LETTER_SHTA";
        case   0x2C1C: return "GLAGOLITIC_CAPITAL_LETTER_TSI";
        case   0x2C1D: return "GLAGOLITIC_CAPITAL_LETTER_CHRIVI";
        case   0x2C1E: return "GLAGOLITIC_CAPITAL_LETTER_SHA";
        case   0x2C1F: return "GLAGOLITIC_CAPITAL_LETTER_YERU";
        case   0x2C20: return "GLAGOLITIC_CAPITAL_LETTER_YERI";
        case   0x2C21: return "GLAGOLITIC_CAPITAL_LETTER_YATI";
        case   0x2C22: return "GLAGOLITIC_CAPITAL_LETTER_SPIDERY_HA";
        case   0x2C23: return "GLAGOLITIC_CAPITAL_LETTER_YU";
        case   0x2C24: return "GLAGOLITIC_CAPITAL_LETTER_SMALL_YUS";
        case   0x2C25: return "GLAGOLITIC_CAPITAL_LETTER_SMALL_YUS_WITH_TAIL";
        case   0x2C26: return "GLAGOLITIC_CAPITAL_LETTER_YO";
        case   0x2C27: return "GLAGOLITIC_CAPITAL_LETTER_IOTATED_SMALL_YUS";
        case   0x2C28: return "GLAGOLITIC_CAPITAL_LETTER_BIG_YUS";
        case   0x2C29: return "GLAGOLITIC_CAPITAL_LETTER_IOTATED_BIG_YUS";
        case   0x2C2A: return "GLAGOLITIC_CAPITAL_LETTER_FITA";
        case   0x2C2B: return "GLAGOLITIC_CAPITAL_LETTER_IZHITSA";
        case   0x2C2C: return "GLAGOLITIC_CAPITAL_LETTER_SHTAPIC";
        case   0x2C2D: return "GLAGOLITIC_CAPITAL_LETTER_TROKUTASTI_A";
        case   0x2C2E: return "GLAGOLITIC_CAPITAL_LETTER_LATINATE_MYSLITE";
        case   0x2C30: return "GLAGOLITIC_SMALL_LETTER_AZU";
        case   0x2C31: return "GLAGOLITIC_SMALL_LETTER_BUKY";
        case   0x2C32: return "GLAGOLITIC_SMALL_LETTER_VEDE";
        case   0x2C33: return "GLAGOLITIC_SMALL_LETTER_GLAGOLI";
        case   0x2C34: return "GLAGOLITIC_SMALL_LETTER_DOBRO";
        case   0x2C35: return "GLAGOLITIC_SMALL_LETTER_YESTU";
        case   0x2C36: return "GLAGOLITIC_SMALL_LETTER_ZHIVETE";
        case   0x2C37: return "GLAGOLITIC_SMALL_LETTER_DZELO";
        case   0x2C38: return "GLAGOLITIC_SMALL_LETTER_ZEMLJA";
        case   0x2C39: return "GLAGOLITIC_SMALL_LETTER_IZHE";
        case   0x2C3A: return "GLAGOLITIC_SMALL_LETTER_INITIAL_IZHE";
        case   0x2C3B: return "GLAGOLITIC_SMALL_LETTER_I";
        case   0x2C3C: return "GLAGOLITIC_SMALL_LETTER_DJERVI";
        case   0x2C3D: return "GLAGOLITIC_SMALL_LETTER_KAKO";
        case   0x2C3E: return "GLAGOLITIC_SMALL_LETTER_LJUDIJE";
        case   0x2C3F: return "GLAGOLITIC_SMALL_LETTER_MYSLITE";
        case   0x2C40: return "GLAGOLITIC_SMALL_LETTER_NASHI";
        case   0x2C41: return "GLAGOLITIC_SMALL_LETTER_ONU";
        case   0x2C42: return "GLAGOLITIC_SMALL_LETTER_POKOJI";
        case   0x2C43: return "GLAGOLITIC_SMALL_LETTER_RITSI";
        case   0x2C44: return "GLAGOLITIC_SMALL_LETTER_SLOVO";
        case   0x2C45: return "GLAGOLITIC_SMALL_LETTER_TVRIDO";
        case   0x2C46: return "GLAGOLITIC_SMALL_LETTER_UKU";
        case   0x2C47: return "GLAGOLITIC_SMALL_LETTER_FRITU";
        case   0x2C48: return "GLAGOLITIC_SMALL_LETTER_HERU";
        case   0x2C49: return "GLAGOLITIC_SMALL_LETTER_OTU";
        case   0x2C4A: return "GLAGOLITIC_SMALL_LETTER_PE";
        case   0x2C4B: return "GLAGOLITIC_SMALL_LETTER_SHTA";
        case   0x2C4C: return "GLAGOLITIC_SMALL_LETTER_TSI";
        case   0x2C4D: return "GLAGOLITIC_SMALL_LETTER_CHRIVI";
        case   0x2C4E: return "GLAGOLITIC_SMALL_LETTER_SHA";
        case   0x2C4F: return "GLAGOLITIC_SMALL_LETTER_YERU";
        case   0x2C50: return "GLAGOLITIC_SMALL_LETTER_YERI";
        case   0x2C51: return "GLAGOLITIC_SMALL_LETTER_YATI";
        case   0x2C52: return "GLAGOLITIC_SMALL_LETTER_SPIDERY_HA";
        case   0x2C53: return "GLAGOLITIC_SMALL_LETTER_YU";
        case   0x2C54: return "GLAGOLITIC_SMALL_LETTER_SMALL_YUS";
        case   0x2C55: return "GLAGOLITIC_SMALL_LETTER_SMALL_YUS_WITH_TAIL";
        case   0x2C56: return "GLAGOLITIC_SMALL_LETTER_YO";
        case   0x2C57: return "GLAGOLITIC_SMALL_LETTER_IOTATED_SMALL_YUS";
        case   0x2C58: return "GLAGOLITIC_SMALL_LETTER_BIG_YUS";
        case   0x2C59: return "GLAGOLITIC_SMALL_LETTER_IOTATED_BIG_YUS";
        case   0x2C5A: return "GLAGOLITIC_SMALL_LETTER_FITA";
        case   0x2C5B: return "GLAGOLITIC_SMALL_LETTER_IZHITSA";
        case   0x2C5C: return "GLAGOLITIC_SMALL_LETTER_SHTAPIC";
        case   0x2C5D: return "GLAGOLITIC_SMALL_LETTER_TROKUTASTI_A";
        case   0x2C5E: return "GLAGOLITIC_SMALL_LETTER_LATINATE_MYSLITE";
        case   0x2C60: return "LATIN_CAPITAL_LETTER_L_WITH_DOUBLE_BAR";
        case   0x2C61: return "LATIN_SMALL_LETTER_L_WITH_DOUBLE_BAR";
        case   0x2C62: return "LATIN_CAPITAL_LETTER_L_WITH_MIDDLE_TILDE";
        case   0x2C63: return "LATIN_CAPITAL_LETTER_P_WITH_STROKE";
        case   0x2C64: return "LATIN_CAPITAL_LETTER_R_WITH_TAIL";
        case   0x2C65: return "LATIN_SMALL_LETTER_A_WITH_STROKE";
        case   0x2C66: return "LATIN_SMALL_LETTER_T_WITH_DIAGONAL_STROKE";
        case   0x2C67: return "LATIN_CAPITAL_LETTER_H_WITH_DESCENDER";
        case   0x2C68: return "LATIN_SMALL_LETTER_H_WITH_DESCENDER";
        case   0x2C69: return "LATIN_CAPITAL_LETTER_K_WITH_DESCENDER";
        case   0x2C6A: return "LATIN_SMALL_LETTER_K_WITH_DESCENDER";
        case   0x2C6B: return "LATIN_CAPITAL_LETTER_Z_WITH_DESCENDER";
        case   0x2C6C: return "LATIN_SMALL_LETTER_Z_WITH_DESCENDER";
        case   0x2C6D: return "LATIN_CAPITAL_LETTER_ALPHA";
        case   0x2C6E: return "LATIN_CAPITAL_LETTER_M_WITH_HOOK";
        case   0x2C6F: return "LATIN_CAPITAL_LETTER_TURNED_A";
        case   0x2C70: return "LATIN_CAPITAL_LETTER_TURNED_ALPHA";
        case   0x2C71: return "LATIN_SMALL_LETTER_V_WITH_RIGHT_HOOK";
        case   0x2C72: return "LATIN_CAPITAL_LETTER_W_WITH_HOOK";
        case   0x2C73: return "LATIN_SMALL_LETTER_W_WITH_HOOK";
        case   0x2C74: return "LATIN_SMALL_LETTER_V_WITH_CURL";
        case   0x2C75: return "LATIN_CAPITAL_LETTER_HALF_H";
        case   0x2C76: return "LATIN_SMALL_LETTER_HALF_H";
        case   0x2C77: return "LATIN_SMALL_LETTER_TAILLESS_PHI";
        case   0x2C78: return "LATIN_SMALL_LETTER_E_WITH_NOTCH";
        case   0x2C79: return "LATIN_SMALL_LETTER_TURNED_R_WITH_TAIL";
        case   0x2C7A: return "LATIN_SMALL_LETTER_O_WITH_LOW_RING_INSIDE";
        case   0x2C7B: return "LATIN_LETTER_SMALL_CAPITAL_TURNED_E";
        case   0x2C7C: return "LATIN_SUBSCRIPT_SMALL_LETTER_J";
        case   0x2C7D: return "MODIFIER_LETTER_CAPITAL_V";
        case   0x2C7E: return "LATIN_CAPITAL_LETTER_S_WITH_SWASH_TAIL";
        case   0x2C7F: return "LATIN_CAPITAL_LETTER_Z_WITH_SWASH_TAIL";
        case   0x2C80: return "COPTIC_CAPITAL_LETTER_ALFA";
        case   0x2C81: return "COPTIC_SMALL_LETTER_ALFA";
        case   0x2C82: return "COPTIC_CAPITAL_LETTER_VIDA";
        case   0x2C83: return "COPTIC_SMALL_LETTER_VIDA";
        case   0x2C84: return "COPTIC_CAPITAL_LETTER_GAMMA";
        case   0x2C85: return "COPTIC_SMALL_LETTER_GAMMA";
        case   0x2C86: return "COPTIC_CAPITAL_LETTER_DALDA";
        case   0x2C87: return "COPTIC_SMALL_LETTER_DALDA";
        case   0x2C88: return "COPTIC_CAPITAL_LETTER_EIE";
        case   0x2C89: return "COPTIC_SMALL_LETTER_EIE";
        case   0x2C8A: return "COPTIC_CAPITAL_LETTER_SOU";
        case   0x2C8B: return "COPTIC_SMALL_LETTER_SOU";
        case   0x2C8C: return "COPTIC_CAPITAL_LETTER_ZATA";
        case   0x2C8D: return "COPTIC_SMALL_LETTER_ZATA";
        case   0x2C8E: return "COPTIC_CAPITAL_LETTER_HATE";
        case   0x2C8F: return "COPTIC_SMALL_LETTER_HATE";
        case   0x2C90: return "COPTIC_CAPITAL_LETTER_THETHE";
        case   0x2C91: return "COPTIC_SMALL_LETTER_THETHE";
        case   0x2C92: return "COPTIC_CAPITAL_LETTER_IAUDA";
        case   0x2C93: return "COPTIC_SMALL_LETTER_IAUDA";
        case   0x2C94: return "COPTIC_CAPITAL_LETTER_KAPA";
        case   0x2C95: return "COPTIC_SMALL_LETTER_KAPA";
        case   0x2C96: return "COPTIC_CAPITAL_LETTER_LAULA";
        case   0x2C97: return "COPTIC_SMALL_LETTER_LAULA";
        case   0x2C98: return "COPTIC_CAPITAL_LETTER_MI";
        case   0x2C99: return "COPTIC_SMALL_LETTER_MI";
        case   0x2C9A: return "COPTIC_CAPITAL_LETTER_NI";
        case   0x2C9B: return "COPTIC_SMALL_LETTER_NI";
        case   0x2C9C: return "COPTIC_CAPITAL_LETTER_KSI";
        case   0x2C9D: return "COPTIC_SMALL_LETTER_KSI";
        case   0x2C9E: return "COPTIC_CAPITAL_LETTER_O";
        case   0x2C9F: return "COPTIC_SMALL_LETTER_O";
        case   0x2CA0: return "COPTIC_CAPITAL_LETTER_PI";
        case   0x2CA1: return "COPTIC_SMALL_LETTER_PI";
        case   0x2CA2: return "COPTIC_CAPITAL_LETTER_RO";
        case   0x2CA3: return "COPTIC_SMALL_LETTER_RO";
        case   0x2CA4: return "COPTIC_CAPITAL_LETTER_SIMA";
        case   0x2CA5: return "COPTIC_SMALL_LETTER_SIMA";
        case   0x2CA6: return "COPTIC_CAPITAL_LETTER_TAU";
        case   0x2CA7: return "COPTIC_SMALL_LETTER_TAU";
        case   0x2CA8: return "COPTIC_CAPITAL_LETTER_UA";
        case   0x2CA9: return "COPTIC_SMALL_LETTER_UA";
        case   0x2CAA: return "COPTIC_CAPITAL_LETTER_FI";
        case   0x2CAB: return "COPTIC_SMALL_LETTER_FI";
        case   0x2CAC: return "COPTIC_CAPITAL_LETTER_KHI";
        case   0x2CAD: return "COPTIC_SMALL_LETTER_KHI";
        case   0x2CAE: return "COPTIC_CAPITAL_LETTER_PSI";
        case   0x2CAF: return "COPTIC_SMALL_LETTER_PSI";
        case   0x2CB0: return "COPTIC_CAPITAL_LETTER_OOU";
        case   0x2CB1: return "COPTIC_SMALL_LETTER_OOU";
        case   0x2CB2: return "COPTIC_CAPITAL_LETTER_DIALECT_P_ALEF";
        case   0x2CB3: return "COPTIC_SMALL_LETTER_DIALECT_P_ALEF";
        case   0x2CB4: return "COPTIC_CAPITAL_LETTER_OLD_COPTIC_AIN";
        case   0x2CB5: return "COPTIC_SMALL_LETTER_OLD_COPTIC_AIN";
        case   0x2CB6: return "COPTIC_CAPITAL_LETTER_CRYPTOGRAMMIC_EIE";
        case   0x2CB7: return "COPTIC_SMALL_LETTER_CRYPTOGRAMMIC_EIE";
        case   0x2CB8: return "COPTIC_CAPITAL_LETTER_DIALECT_P_KAPA";
        case   0x2CB9: return "COPTIC_SMALL_LETTER_DIALECT_P_KAPA";
        case   0x2CBA: return "COPTIC_CAPITAL_LETTER_DIALECT_P_NI";
        case   0x2CBB: return "COPTIC_SMALL_LETTER_DIALECT_P_NI";
        case   0x2CBC: return "COPTIC_CAPITAL_LETTER_CRYPTOGRAMMIC_NI";
        case   0x2CBD: return "COPTIC_SMALL_LETTER_CRYPTOGRAMMIC_NI";
        case   0x2CBE: return "COPTIC_CAPITAL_LETTER_OLD_COPTIC_OOU";
        case   0x2CBF: return "COPTIC_SMALL_LETTER_OLD_COPTIC_OOU";
        case   0x2CC0: return "COPTIC_CAPITAL_LETTER_SAMPI";
        case   0x2CC1: return "COPTIC_SMALL_LETTER_SAMPI";
        case   0x2CC2: return "COPTIC_CAPITAL_LETTER_CROSSED_SHEI";
        case   0x2CC3: return "COPTIC_SMALL_LETTER_CROSSED_SHEI";
        case   0x2CC4: return "COPTIC_CAPITAL_LETTER_OLD_COPTIC_SHEI";
        case   0x2CC5: return "COPTIC_SMALL_LETTER_OLD_COPTIC_SHEI";
        case   0x2CC6: return "COPTIC_CAPITAL_LETTER_OLD_COPTIC_ESH";
        case   0x2CC7: return "COPTIC_SMALL_LETTER_OLD_COPTIC_ESH";
        case   0x2CC8: return "COPTIC_CAPITAL_LETTER_AKHMIMIC_KHEI";
        case   0x2CC9: return "COPTIC_SMALL_LETTER_AKHMIMIC_KHEI";
        case   0x2CCA: return "COPTIC_CAPITAL_LETTER_DIALECT_P_HORI";
        case   0x2CCB: return "COPTIC_SMALL_LETTER_DIALECT_P_HORI";
        case   0x2CCC: return "COPTIC_CAPITAL_LETTER_OLD_COPTIC_HORI";
        case   0x2CCD: return "COPTIC_SMALL_LETTER_OLD_COPTIC_HORI";
        case   0x2CCE: return "COPTIC_CAPITAL_LETTER_OLD_COPTIC_HA";
        case   0x2CCF: return "COPTIC_SMALL_LETTER_OLD_COPTIC_HA";
        case   0x2CD0: return "COPTIC_CAPITAL_LETTER_L_SHAPED_HA";
        case   0x2CD1: return "COPTIC_SMALL_LETTER_L_SHAPED_HA";
        case   0x2CD2: return "COPTIC_CAPITAL_LETTER_OLD_COPTIC_HEI";
        case   0x2CD3: return "COPTIC_SMALL_LETTER_OLD_COPTIC_HEI";
        case   0x2CD4: return "COPTIC_CAPITAL_LETTER_OLD_COPTIC_HAT";
        case   0x2CD5: return "COPTIC_SMALL_LETTER_OLD_COPTIC_HAT";
        case   0x2CD6: return "COPTIC_CAPITAL_LETTER_OLD_COPTIC_GANGIA";
        case   0x2CD7: return "COPTIC_SMALL_LETTER_OLD_COPTIC_GANGIA";
        case   0x2CD8: return "COPTIC_CAPITAL_LETTER_OLD_COPTIC_DJA";
        case   0x2CD9: return "COPTIC_SMALL_LETTER_OLD_COPTIC_DJA";
        case   0x2CDA: return "COPTIC_CAPITAL_LETTER_OLD_COPTIC_SHIMA";
        case   0x2CDB: return "COPTIC_SMALL_LETTER_OLD_COPTIC_SHIMA";
        case   0x2CDC: return "COPTIC_CAPITAL_LETTER_OLD_NUBIAN_SHIMA";
        case   0x2CDD: return "COPTIC_SMALL_LETTER_OLD_NUBIAN_SHIMA";
        case   0x2CDE: return "COPTIC_CAPITAL_LETTER_OLD_NUBIAN_NGI";
        case   0x2CDF: return "COPTIC_SMALL_LETTER_OLD_NUBIAN_NGI";
        case   0x2CE0: return "COPTIC_CAPITAL_LETTER_OLD_NUBIAN_NYI";
        case   0x2CE1: return "COPTIC_SMALL_LETTER_OLD_NUBIAN_NYI";
        case   0x2CE2: return "COPTIC_CAPITAL_LETTER_OLD_NUBIAN_WAU";
        case   0x2CE3: return "COPTIC_SMALL_LETTER_OLD_NUBIAN_WAU";
        case   0x2CE4: return "COPTIC_SYMBOL_KAI";
        case   0x2CE5: return "COPTIC_SYMBOL_MI_RO";
        case   0x2CE6: return "COPTIC_SYMBOL_PI_RO";
        case   0x2CE7: return "COPTIC_SYMBOL_STAUROS";
        case   0x2CE8: return "COPTIC_SYMBOL_TAU_RO";
        case   0x2CE9: return "COPTIC_SYMBOL_KHI_RO";
        case   0x2CEA: return "COPTIC_SYMBOL_SHIMA_SIMA";
        case   0x2CEB: return "COPTIC_CAPITAL_LETTER_CRYPTOGRAMMIC_SHEI";
        case   0x2CEC: return "COPTIC_SMALL_LETTER_CRYPTOGRAMMIC_SHEI";
        case   0x2CED: return "COPTIC_CAPITAL_LETTER_CRYPTOGRAMMIC_GANGIA";
        case   0x2CEE: return "COPTIC_SMALL_LETTER_CRYPTOGRAMMIC_GANGIA";
        case   0x2CEF: return "COPTIC_COMBINING_NI_ABOVE";
        case   0x2CF0: return "COPTIC_COMBINING_SPIRITUS_ASPER";
        case   0x2CF1: return "COPTIC_COMBINING_SPIRITUS_LENIS";
        case   0x2CF2: return "COPTIC_CAPITAL_LETTER_BOHAIRIC_KHEI";
        case   0x2CF3: return "COPTIC_SMALL_LETTER_BOHAIRIC_KHEI";
        case   0x2CF9: return "COPTIC_OLD_NUBIAN_FULL_STOP";
        case   0x2CFA: return "COPTIC_OLD_NUBIAN_DIRECT_QUESTION_MARK";
        case   0x2CFB: return "COPTIC_OLD_NUBIAN_INDIRECT_QUESTION_MARK";
        case   0x2CFC: return "COPTIC_OLD_NUBIAN_VERSE_DIVIDER";
        case   0x2CFD: return "COPTIC_FRACTION_ONE_HALF";
        case   0x2CFE: return "COPTIC_FULL_STOP";
        case   0x2CFF: return "COPTIC_MORPHOLOGICAL_DIVIDER";
        case   0x2D00: return "GEORGIAN_SMALL_LETTER_AN";
        case   0x2D01: return "GEORGIAN_SMALL_LETTER_BAN";
        case   0x2D02: return "GEORGIAN_SMALL_LETTER_GAN";
        case   0x2D03: return "GEORGIAN_SMALL_LETTER_DON";
        case   0x2D04: return "GEORGIAN_SMALL_LETTER_EN";
        case   0x2D05: return "GEORGIAN_SMALL_LETTER_VIN";
        case   0x2D06: return "GEORGIAN_SMALL_LETTER_ZEN";
        case   0x2D07: return "GEORGIAN_SMALL_LETTER_TAN";
        case   0x2D08: return "GEORGIAN_SMALL_LETTER_IN";
        case   0x2D09: return "GEORGIAN_SMALL_LETTER_KAN";
        case   0x2D0A: return "GEORGIAN_SMALL_LETTER_LAS";
        case   0x2D0B: return "GEORGIAN_SMALL_LETTER_MAN";
        case   0x2D0C: return "GEORGIAN_SMALL_LETTER_NAR";
        case   0x2D0D: return "GEORGIAN_SMALL_LETTER_ON";
        case   0x2D0E: return "GEORGIAN_SMALL_LETTER_PAR";
        case   0x2D0F: return "GEORGIAN_SMALL_LETTER_ZHAR";
        case   0x2D10: return "GEORGIAN_SMALL_LETTER_RAE";
        case   0x2D11: return "GEORGIAN_SMALL_LETTER_SAN";
        case   0x2D12: return "GEORGIAN_SMALL_LETTER_TAR";
        case   0x2D13: return "GEORGIAN_SMALL_LETTER_UN";
        case   0x2D14: return "GEORGIAN_SMALL_LETTER_PHAR";
        case   0x2D15: return "GEORGIAN_SMALL_LETTER_KHAR";
        case   0x2D16: return "GEORGIAN_SMALL_LETTER_GHAN";
        case   0x2D17: return "GEORGIAN_SMALL_LETTER_QAR";
        case   0x2D18: return "GEORGIAN_SMALL_LETTER_SHIN";
        case   0x2D19: return "GEORGIAN_SMALL_LETTER_CHIN";
        case   0x2D1A: return "GEORGIAN_SMALL_LETTER_CAN";
        case   0x2D1B: return "GEORGIAN_SMALL_LETTER_JIL";
        case   0x2D1C: return "GEORGIAN_SMALL_LETTER_CIL";
        case   0x2D1D: return "GEORGIAN_SMALL_LETTER_CHAR";
        case   0x2D1E: return "GEORGIAN_SMALL_LETTER_XAN";
        case   0x2D1F: return "GEORGIAN_SMALL_LETTER_JHAN";
        case   0x2D20: return "GEORGIAN_SMALL_LETTER_HAE";
        case   0x2D21: return "GEORGIAN_SMALL_LETTER_HE";
        case   0x2D22: return "GEORGIAN_SMALL_LETTER_HIE";
        case   0x2D23: return "GEORGIAN_SMALL_LETTER_WE";
        case   0x2D24: return "GEORGIAN_SMALL_LETTER_HAR";
        case   0x2D25: return "GEORGIAN_SMALL_LETTER_HOE";
        case   0x2D27: return "GEORGIAN_SMALL_LETTER_YN";
        case   0x2D2D: return "GEORGIAN_SMALL_LETTER_AEN";
        case   0x2D30: return "TIFINAGH_LETTER_YA";
        case   0x2D31: return "TIFINAGH_LETTER_YAB";
        case   0x2D32: return "TIFINAGH_LETTER_YABH";
        case   0x2D33: return "TIFINAGH_LETTER_YAG";
        case   0x2D34: return "TIFINAGH_LETTER_YAGHH";
        case   0x2D35: return "TIFINAGH_LETTER_BERBER_ACADEMY_YAJ";
        case   0x2D36: return "TIFINAGH_LETTER_YAJ";
        case   0x2D37: return "TIFINAGH_LETTER_YAD";
        case   0x2D38: return "TIFINAGH_LETTER_YADH";
        case   0x2D39: return "TIFINAGH_LETTER_YADD";
        case   0x2D3A: return "TIFINAGH_LETTER_YADDH";
        case   0x2D3B: return "TIFINAGH_LETTER_YEY";
        case   0x2D3C: return "TIFINAGH_LETTER_YAF";
        case   0x2D3D: return "TIFINAGH_LETTER_YAK";
        case   0x2D3E: return "TIFINAGH_LETTER_TUAREG_YAK";
        case   0x2D3F: return "TIFINAGH_LETTER_YAKHH";
        case   0x2D40: return "TIFINAGH_LETTER_YAH";
        case   0x2D41: return "TIFINAGH_LETTER_BERBER_ACADEMY_YAH";
        case   0x2D42: return "TIFINAGH_LETTER_TUAREG_YAH";
        case   0x2D43: return "TIFINAGH_LETTER_YAHH";
        case   0x2D44: return "TIFINAGH_LETTER_YAA";
        case   0x2D45: return "TIFINAGH_LETTER_YAKH";
        case   0x2D46: return "TIFINAGH_LETTER_TUAREG_YAKH";
        case   0x2D47: return "TIFINAGH_LETTER_YAQ";
        case   0x2D48: return "TIFINAGH_LETTER_TUAREG_YAQ";
        case   0x2D49: return "TIFINAGH_LETTER_YI";
        case   0x2D4A: return "TIFINAGH_LETTER_YAZH";
        case   0x2D4B: return "TIFINAGH_LETTER_AHAGGAR_YAZH";
        case   0x2D4C: return "TIFINAGH_LETTER_TUAREG_YAZH";
        case   0x2D4D: return "TIFINAGH_LETTER_YAL";
        case   0x2D4E: return "TIFINAGH_LETTER_YAM";
        case   0x2D4F: return "TIFINAGH_LETTER_YAN";
        case   0x2D50: return "TIFINAGH_LETTER_TUAREG_YAGN";
        case   0x2D51: return "TIFINAGH_LETTER_TUAREG_YANG";
        case   0x2D52: return "TIFINAGH_LETTER_YAP";
        case   0x2D53: return "TIFINAGH_LETTER_YU";
        case   0x2D54: return "TIFINAGH_LETTER_YAR";
        case   0x2D55: return "TIFINAGH_LETTER_YARR";
        case   0x2D56: return "TIFINAGH_LETTER_YAGH";
        case   0x2D57: return "TIFINAGH_LETTER_TUAREG_YAGH";
        case   0x2D58: return "TIFINAGH_LETTER_AYER_YAGH";
        case   0x2D59: return "TIFINAGH_LETTER_YAS";
        case   0x2D5A: return "TIFINAGH_LETTER_YASS";
        case   0x2D5B: return "TIFINAGH_LETTER_YASH";
        case   0x2D5C: return "TIFINAGH_LETTER_YAT";
        case   0x2D5D: return "TIFINAGH_LETTER_YATH";
        case   0x2D5E: return "TIFINAGH_LETTER_YACH";
        case   0x2D5F: return "TIFINAGH_LETTER_YATT";
        case   0x2D60: return "TIFINAGH_LETTER_YAV";
        case   0x2D61: return "TIFINAGH_LETTER_YAW";
        case   0x2D62: return "TIFINAGH_LETTER_YAY";
        case   0x2D63: return "TIFINAGH_LETTER_YAZ";
        case   0x2D64: return "TIFINAGH_LETTER_TAWELLEMET_YAZ";
        case   0x2D65: return "TIFINAGH_LETTER_YAZZ";
        case   0x2D66: return "TIFINAGH_LETTER_YE";
        case   0x2D67: return "TIFINAGH_LETTER_YO";
        case   0x2D6F: return "TIFINAGH_MODIFIER_LETTER_LABIALIZATION_MARK";
        case   0x2D70: return "TIFINAGH_SEPARATOR_MARK";
        case   0x2D7F: return "TIFINAGH_CONSONANT_JOINER";
        case   0x2D80: return "ETHIOPIC_SYLLABLE_LOA";
        case   0x2D81: return "ETHIOPIC_SYLLABLE_MOA";
        case   0x2D82: return "ETHIOPIC_SYLLABLE_ROA";
        case   0x2D83: return "ETHIOPIC_SYLLABLE_SOA";
        case   0x2D84: return "ETHIOPIC_SYLLABLE_SHOA";
        case   0x2D85: return "ETHIOPIC_SYLLABLE_BOA";
        case   0x2D86: return "ETHIOPIC_SYLLABLE_TOA";
        case   0x2D87: return "ETHIOPIC_SYLLABLE_COA";
        case   0x2D88: return "ETHIOPIC_SYLLABLE_NOA";
        case   0x2D89: return "ETHIOPIC_SYLLABLE_NYOA";
        case   0x2D8A: return "ETHIOPIC_SYLLABLE_GLOTTAL_OA";
        case   0x2D8B: return "ETHIOPIC_SYLLABLE_ZOA";
        case   0x2D8C: return "ETHIOPIC_SYLLABLE_DOA";
        case   0x2D8D: return "ETHIOPIC_SYLLABLE_DDOA";
        case   0x2D8E: return "ETHIOPIC_SYLLABLE_JOA";
        case   0x2D8F: return "ETHIOPIC_SYLLABLE_THOA";
        case   0x2D90: return "ETHIOPIC_SYLLABLE_CHOA";
        case   0x2D91: return "ETHIOPIC_SYLLABLE_PHOA";
        case   0x2D92: return "ETHIOPIC_SYLLABLE_POA";
        case   0x2D93: return "ETHIOPIC_SYLLABLE_GGWA";
        case   0x2D94: return "ETHIOPIC_SYLLABLE_GGWI";
        case   0x2D95: return "ETHIOPIC_SYLLABLE_GGWEE";
        case   0x2D96: return "ETHIOPIC_SYLLABLE_GGWE";
        case   0x2DA0: return "ETHIOPIC_SYLLABLE_SSA";
        case   0x2DA1: return "ETHIOPIC_SYLLABLE_SSU";
        case   0x2DA2: return "ETHIOPIC_SYLLABLE_SSI";
        case   0x2DA3: return "ETHIOPIC_SYLLABLE_SSAA";
        case   0x2DA4: return "ETHIOPIC_SYLLABLE_SSEE";
        case   0x2DA5: return "ETHIOPIC_SYLLABLE_SSE";
        case   0x2DA6: return "ETHIOPIC_SYLLABLE_SSO";
        case   0x2DA8: return "ETHIOPIC_SYLLABLE_CCA";
        case   0x2DA9: return "ETHIOPIC_SYLLABLE_CCU";
        case   0x2DAA: return "ETHIOPIC_SYLLABLE_CCI";
        case   0x2DAB: return "ETHIOPIC_SYLLABLE_CCAA";
        case   0x2DAC: return "ETHIOPIC_SYLLABLE_CCEE";
        case   0x2DAD: return "ETHIOPIC_SYLLABLE_CCE";
        case   0x2DAE: return "ETHIOPIC_SYLLABLE_CCO";
        case   0x2DB0: return "ETHIOPIC_SYLLABLE_ZZA";
        case   0x2DB1: return "ETHIOPIC_SYLLABLE_ZZU";
        case   0x2DB2: return "ETHIOPIC_SYLLABLE_ZZI";
        case   0x2DB3: return "ETHIOPIC_SYLLABLE_ZZAA";
        case   0x2DB4: return "ETHIOPIC_SYLLABLE_ZZEE";
        case   0x2DB5: return "ETHIOPIC_SYLLABLE_ZZE";
        case   0x2DB6: return "ETHIOPIC_SYLLABLE_ZZO";
        case   0x2DB8: return "ETHIOPIC_SYLLABLE_CCHA";
        case   0x2DB9: return "ETHIOPIC_SYLLABLE_CCHU";
        case   0x2DBA: return "ETHIOPIC_SYLLABLE_CCHI";
        case   0x2DBB: return "ETHIOPIC_SYLLABLE_CCHAA";
        case   0x2DBC: return "ETHIOPIC_SYLLABLE_CCHEE";
        case   0x2DBD: return "ETHIOPIC_SYLLABLE_CCHE";
        case   0x2DBE: return "ETHIOPIC_SYLLABLE_CCHO";
        case   0x2DC0: return "ETHIOPIC_SYLLABLE_QYA";
        case   0x2DC1: return "ETHIOPIC_SYLLABLE_QYU";
        case   0x2DC2: return "ETHIOPIC_SYLLABLE_QYI";
        case   0x2DC3: return "ETHIOPIC_SYLLABLE_QYAA";
        case   0x2DC4: return "ETHIOPIC_SYLLABLE_QYEE";
        case   0x2DC5: return "ETHIOPIC_SYLLABLE_QYE";
        case   0x2DC6: return "ETHIOPIC_SYLLABLE_QYO";
        case   0x2DC8: return "ETHIOPIC_SYLLABLE_KYA";
        case   0x2DC9: return "ETHIOPIC_SYLLABLE_KYU";
        case   0x2DCA: return "ETHIOPIC_SYLLABLE_KYI";
        case   0x2DCB: return "ETHIOPIC_SYLLABLE_KYAA";
        case   0x2DCC: return "ETHIOPIC_SYLLABLE_KYEE";
        case   0x2DCD: return "ETHIOPIC_SYLLABLE_KYE";
        case   0x2DCE: return "ETHIOPIC_SYLLABLE_KYO";
        case   0x2DD0: return "ETHIOPIC_SYLLABLE_XYA";
        case   0x2DD1: return "ETHIOPIC_SYLLABLE_XYU";
        case   0x2DD2: return "ETHIOPIC_SYLLABLE_XYI";
        case   0x2DD3: return "ETHIOPIC_SYLLABLE_XYAA";
        case   0x2DD4: return "ETHIOPIC_SYLLABLE_XYEE";
        case   0x2DD5: return "ETHIOPIC_SYLLABLE_XYE";
        case   0x2DD6: return "ETHIOPIC_SYLLABLE_XYO";
        case   0x2DD8: return "ETHIOPIC_SYLLABLE_GYA";
        case   0x2DD9: return "ETHIOPIC_SYLLABLE_GYU";
        case   0x2DDA: return "ETHIOPIC_SYLLABLE_GYI";
        case   0x2DDB: return "ETHIOPIC_SYLLABLE_GYAA";
        case   0x2DDC: return "ETHIOPIC_SYLLABLE_GYEE";
        case   0x2DDD: return "ETHIOPIC_SYLLABLE_GYE";
        case   0x2DDE: return "ETHIOPIC_SYLLABLE_GYO";
        case   0x2DE0: return "COMBINING_CYRILLIC_LETTER_BE";
        case   0x2DE1: return "COMBINING_CYRILLIC_LETTER_VE";
        case   0x2DE2: return "COMBINING_CYRILLIC_LETTER_GHE";
        case   0x2DE3: return "COMBINING_CYRILLIC_LETTER_DE";
        case   0x2DE4: return "COMBINING_CYRILLIC_LETTER_ZHE";
        case   0x2DE5: return "COMBINING_CYRILLIC_LETTER_ZE";
        case   0x2DE6: return "COMBINING_CYRILLIC_LETTER_KA";
        case   0x2DE7: return "COMBINING_CYRILLIC_LETTER_EL";
        case   0x2DE8: return "COMBINING_CYRILLIC_LETTER_EM";
        case   0x2DE9: return "COMBINING_CYRILLIC_LETTER_EN";
        case   0x2DEA: return "COMBINING_CYRILLIC_LETTER_O";
        case   0x2DEB: return "COMBINING_CYRILLIC_LETTER_PE";
        case   0x2DEC: return "COMBINING_CYRILLIC_LETTER_ER";
        case   0x2DED: return "COMBINING_CYRILLIC_LETTER_ES";
        case   0x2DEE: return "COMBINING_CYRILLIC_LETTER_TE";
        case   0x2DEF: return "COMBINING_CYRILLIC_LETTER_HA";
        case   0x2DF0: return "COMBINING_CYRILLIC_LETTER_TSE";
        case   0x2DF1: return "COMBINING_CYRILLIC_LETTER_CHE";
        case   0x2DF2: return "COMBINING_CYRILLIC_LETTER_SHA";
        case   0x2DF3: return "COMBINING_CYRILLIC_LETTER_SHCHA";
        case   0x2DF4: return "COMBINING_CYRILLIC_LETTER_FITA";
        case   0x2DF5: return "COMBINING_CYRILLIC_LETTER_ES_TE";
        case   0x2DF6: return "COMBINING_CYRILLIC_LETTER_A";
        case   0x2DF7: return "COMBINING_CYRILLIC_LETTER_IE";
        case   0x2DF8: return "COMBINING_CYRILLIC_LETTER_DJERV";
        case   0x2DF9: return "COMBINING_CYRILLIC_LETTER_MONOGRAPH_UK";
        case   0x2DFA: return "COMBINING_CYRILLIC_LETTER_YAT";
        case   0x2DFB: return "COMBINING_CYRILLIC_LETTER_YU";
        case   0x2DFC: return "COMBINING_CYRILLIC_LETTER_IOTIFIED_A";
        case   0x2DFD: return "COMBINING_CYRILLIC_LETTER_LITTLE_YUS";
        case   0x2DFE: return "COMBINING_CYRILLIC_LETTER_BIG_YUS";
        case   0x2DFF: return "COMBINING_CYRILLIC_LETTER_IOTIFIED_BIG_YUS";
        case   0x2E00: return "RIGHT_ANGLE_SUBSTITUTION_MARKER";
        case   0x2E01: return "RIGHT_ANGLE_DOTTED_SUBSTITUTION_MARKER";
        case   0x2E02: return "LEFT_SUBSTITUTION_BRACKET";
        case   0x2E03: return "RIGHT_SUBSTITUTION_BRACKET";
        case   0x2E04: return "LEFT_DOTTED_SUBSTITUTION_BRACKET";
        case   0x2E05: return "RIGHT_DOTTED_SUBSTITUTION_BRACKET";
        case   0x2E06: return "RAISED_INTERPOLATION_MARKER";
        case   0x2E07: return "RAISED_DOTTED_INTERPOLATION_MARKER";
        case   0x2E08: return "DOTTED_TRANSPOSITION_MARKER";
        case   0x2E09: return "LEFT_TRANSPOSITION_BRACKET";
        case   0x2E0A: return "RIGHT_TRANSPOSITION_BRACKET";
        case   0x2E0B: return "RAISED_SQUARE";
        case   0x2E0C: return "LEFT_RAISED_OMISSION_BRACKET";
        case   0x2E0D: return "RIGHT_RAISED_OMISSION_BRACKET";
        case   0x2E0E: return "EDITORIAL_CORONIS";
        case   0x2E0F: return "PARAGRAPHOS";
        case   0x2E10: return "FORKED_PARAGRAPHOS";
        case   0x2E11: return "REVERSED_FORKED_PARAGRAPHOS";
        case   0x2E12: return "HYPODIASTOLE";
        case   0x2E13: return "DOTTED_OBELOS";
        case   0x2E14: return "DOWNWARDS_ANCORA";
        case   0x2E15: return "UPWARDS_ANCORA";
        case   0x2E16: return "DOTTED_RIGHT_POINTING_ANGLE";
        case   0x2E17: return "DOUBLE_OBLIQUE_HYPHEN";
        case   0x2E18: return "INVERTED_INTERROBANG";
        case   0x2E19: return "PALM_BRANCH";
        case   0x2E1A: return "HYPHEN_WITH_DIAERESIS";
        case   0x2E1B: return "TILDE_WITH_RING_ABOVE";
        case   0x2E1C: return "LEFT_LOW_PARAPHRASE_BRACKET";
        case   0x2E1D: return "RIGHT_LOW_PARAPHRASE_BRACKET";
        case   0x2E1E: return "TILDE_WITH_DOT_ABOVE";
        case   0x2E1F: return "TILDE_WITH_DOT_BELOW";
        case   0x2E20: return "LEFT_VERTICAL_BAR_WITH_QUILL";
        case   0x2E21: return "RIGHT_VERTICAL_BAR_WITH_QUILL";
        case   0x2E22: return "TOP_LEFT_HALF_BRACKET";
        case   0x2E23: return "TOP_RIGHT_HALF_BRACKET";
        case   0x2E24: return "BOTTOM_LEFT_HALF_BRACKET";
        case   0x2E25: return "BOTTOM_RIGHT_HALF_BRACKET";
        case   0x2E26: return "LEFT_SIDEWAYS_U_BRACKET";
        case   0x2E27: return "RIGHT_SIDEWAYS_U_BRACKET";
        case   0x2E28: return "LEFT_DOUBLE_PARENTHESIS";
        case   0x2E29: return "RIGHT_DOUBLE_PARENTHESIS";
        case   0x2E2A: return "TWO_DOTS_OVER_ONE_DOT_PUNCTUATION";
        case   0x2E2B: return "ONE_DOT_OVER_TWO_DOTS_PUNCTUATION";
        case   0x2E2C: return "SQUARED_FOUR_DOT_PUNCTUATION";
        case   0x2E2D: return "FIVE_DOT_MARK";
        case   0x2E2E: return "REVERSED_QUESTION_MARK";
        case   0x2E2F: return "VERTICAL_TILDE";
        case   0x2E30: return "RING_POINT";
        case   0x2E31: return "WORD_SEPARATOR_MIDDLE_DOT";
        case   0x2E32: return "TURNED_COMMA";
        case   0x2E33: return "RAISED_DOT";
        case   0x2E34: return "RAISED_COMMA";
        case   0x2E35: return "TURNED_SEMICOLON";
        case   0x2E36: return "DAGGER_WITH_LEFT_GUARD";
        case   0x2E37: return "DAGGER_WITH_RIGHT_GUARD";
        case   0x2E38: return "TURNED_DAGGER";
        case   0x2E39: return "TOP_HALF_SECTION_SIGN";
        case   0x2E3A: return "TWO_EM_DASH";
        case   0x2E3B: return "THREE_EM_DASH";
        case   0x2E3C: return "STENOGRAPHIC_FULL_STOP";
        case   0x2E3D: return "VERTICAL_SIX_DOTS";
        case   0x2E3E: return "WIGGLY_VERTICAL_LINE";
        case   0x2E3F: return "CAPITULUM";
        case   0x2E40: return "DOUBLE_HYPHEN";
        case   0x2E41: return "REVERSED_COMMA";
        case   0x2E42: return "DOUBLE_LOW_REVERSED_9_QUOTATION_MARK";
        case   0x2E80: return "CJK_RADICAL_REPEAT";
        case   0x2E81: return "CJK_RADICAL_CLIFF";
        case   0x2E82: return "CJK_RADICAL_SECOND_ONE";
        case   0x2E83: return "CJK_RADICAL_SECOND_TWO";
        case   0x2E84: return "CJK_RADICAL_SECOND_THREE";
        case   0x2E85: return "CJK_RADICAL_PERSON";
        case   0x2E86: return "CJK_RADICAL_BOX";
        case   0x2E87: return "CJK_RADICAL_TABLE";
        case   0x2E88: return "CJK_RADICAL_KNIFE_ONE";
        case   0x2E89: return "CJK_RADICAL_KNIFE_TWO";
        case   0x2E8A: return "CJK_RADICAL_DIVINATION";
        case   0x2E8B: return "CJK_RADICAL_SEAL";
        case   0x2E8C: return "CJK_RADICAL_SMALL_ONE";
        case   0x2E8D: return "CJK_RADICAL_SMALL_TWO";
        case   0x2E8E: return "CJK_RADICAL_LAME_ONE";
        case   0x2E8F: return "CJK_RADICAL_LAME_TWO";
        case   0x2E90: return "CJK_RADICAL_LAME_THREE";
        case   0x2E91: return "CJK_RADICAL_LAME_FOUR";
        case   0x2E92: return "CJK_RADICAL_SNAKE";
        case   0x2E93: return "CJK_RADICAL_THREAD";
        case   0x2E94: return "CJK_RADICAL_SNOUT_ONE";
        case   0x2E95: return "CJK_RADICAL_SNOUT_TWO";
        case   0x2E96: return "CJK_RADICAL_HEART_ONE";
        case   0x2E97: return "CJK_RADICAL_HEART_TWO";
        case   0x2E98: return "CJK_RADICAL_HAND";
        case   0x2E99: return "CJK_RADICAL_RAP";
        case   0x2E9B: return "CJK_RADICAL_CHOKE";
        case   0x2E9C: return "CJK_RADICAL_SUN";
        case   0x2E9D: return "CJK_RADICAL_MOON";
        case   0x2E9E: return "CJK_RADICAL_DEATH";
        case   0x2E9F: return "CJK_RADICAL_MOTHER";
        case   0x2EA0: return "CJK_RADICAL_CIVILIAN";
        case   0x2EA1: return "CJK_RADICAL_WATER_ONE";
        case   0x2EA2: return "CJK_RADICAL_WATER_TWO";
        case   0x2EA3: return "CJK_RADICAL_FIRE";
        case   0x2EA4: return "CJK_RADICAL_PAW_ONE";
        case   0x2EA5: return "CJK_RADICAL_PAW_TWO";
        case   0x2EA6: return "CJK_RADICAL_SIMPLIFIED_HALF_TREE_TRUNK";
        case   0x2EA7: return "CJK_RADICAL_COW";
        case   0x2EA8: return "CJK_RADICAL_DOG";
        case   0x2EA9: return "CJK_RADICAL_JADE";
        case   0x2EAA: return "CJK_RADICAL_BOLT_OF_CLOTH";
        case   0x2EAB: return "CJK_RADICAL_EYE";
        case   0x2EAC: return "CJK_RADICAL_SPIRIT_ONE";
        case   0x2EAD: return "CJK_RADICAL_SPIRIT_TWO";
        case   0x2EAE: return "CJK_RADICAL_BAMBOO";
        case   0x2EAF: return "CJK_RADICAL_SILK";
        case   0x2EB0: return "CJK_RADICAL_C_SIMPLIFIED_SILK";
        case   0x2EB1: return "CJK_RADICAL_NET_ONE";
        case   0x2EB2: return "CJK_RADICAL_NET_TWO";
        case   0x2EB3: return "CJK_RADICAL_NET_THREE";
        case   0x2EB4: return "CJK_RADICAL_NET_FOUR";
        case   0x2EB5: return "CJK_RADICAL_MESH";
        case   0x2EB6: return "CJK_RADICAL_SHEEP";
        case   0x2EB7: return "CJK_RADICAL_RAM";
        case   0x2EB8: return "CJK_RADICAL_EWE";
        case   0x2EB9: return "CJK_RADICAL_OLD";
        case   0x2EBA: return "CJK_RADICAL_BRUSH_ONE";
        case   0x2EBB: return "CJK_RADICAL_BRUSH_TWO";
        case   0x2EBC: return "CJK_RADICAL_MEAT";
        case   0x2EBD: return "CJK_RADICAL_MORTAR";
        case   0x2EBE: return "CJK_RADICAL_GRASS_ONE";
        case   0x2EBF: return "CJK_RADICAL_GRASS_TWO";
        case   0x2EC0: return "CJK_RADICAL_GRASS_THREE";
        case   0x2EC1: return "CJK_RADICAL_TIGER";
        case   0x2EC2: return "CJK_RADICAL_CLOTHES";
        case   0x2EC3: return "CJK_RADICAL_WEST_ONE";
        case   0x2EC4: return "CJK_RADICAL_WEST_TWO";
        case   0x2EC5: return "CJK_RADICAL_C_SIMPLIFIED_SEE";
        case   0x2EC6: return "CJK_RADICAL_SIMPLIFIED_HORN";
        case   0x2EC7: return "CJK_RADICAL_HORN";
        case   0x2EC8: return "CJK_RADICAL_C_SIMPLIFIED_SPEECH";
        case   0x2EC9: return "CJK_RADICAL_C_SIMPLIFIED_SHELL";
        case   0x2ECA: return "CJK_RADICAL_FOOT";
        case   0x2ECB: return "CJK_RADICAL_C_SIMPLIFIED_CART";
        case   0x2ECC: return "CJK_RADICAL_SIMPLIFIED_WALK";
        case   0x2ECD: return "CJK_RADICAL_WALK_ONE";
        case   0x2ECE: return "CJK_RADICAL_WALK_TWO";
        case   0x2ECF: return "CJK_RADICAL_CITY";
        case   0x2ED0: return "CJK_RADICAL_C_SIMPLIFIED_GOLD";
        case   0x2ED1: return "CJK_RADICAL_LONG_ONE";
        case   0x2ED2: return "CJK_RADICAL_LONG_TWO";
        case   0x2ED3: return "CJK_RADICAL_C_SIMPLIFIED_LONG";
        case   0x2ED4: return "CJK_RADICAL_C_SIMPLIFIED_GATE";
        case   0x2ED5: return "CJK_RADICAL_MOUND_ONE";
        case   0x2ED6: return "CJK_RADICAL_MOUND_TWO";
        case   0x2ED7: return "CJK_RADICAL_RAIN";
        case   0x2ED8: return "CJK_RADICAL_BLUE";
        case   0x2ED9: return "CJK_RADICAL_C_SIMPLIFIED_TANNED_LEATHER";
        case   0x2EDA: return "CJK_RADICAL_C_SIMPLIFIED_LEAF";
        case   0x2EDB: return "CJK_RADICAL_C_SIMPLIFIED_WIND";
        case   0x2EDC: return "CJK_RADICAL_C_SIMPLIFIED_FLY";
        case   0x2EDD: return "CJK_RADICAL_EAT_ONE";
        case   0x2EDE: return "CJK_RADICAL_EAT_TWO";
        case   0x2EDF: return "CJK_RADICAL_EAT_THREE";
        case   0x2EE0: return "CJK_RADICAL_C_SIMPLIFIED_EAT";
        case   0x2EE1: return "CJK_RADICAL_HEAD";
        case   0x2EE2: return "CJK_RADICAL_C_SIMPLIFIED_HORSE";
        case   0x2EE3: return "CJK_RADICAL_BONE";
        case   0x2EE4: return "CJK_RADICAL_GHOST";
        case   0x2EE5: return "CJK_RADICAL_C_SIMPLIFIED_FISH";
        case   0x2EE6: return "CJK_RADICAL_C_SIMPLIFIED_BIRD";
        case   0x2EE7: return "CJK_RADICAL_C_SIMPLIFIED_SALT";
        case   0x2EE8: return "CJK_RADICAL_SIMPLIFIED_WHEAT";
        case   0x2EE9: return "CJK_RADICAL_SIMPLIFIED_YELLOW";
        case   0x2EEA: return "CJK_RADICAL_C_SIMPLIFIED_FROG";
        case   0x2EEB: return "CJK_RADICAL_J_SIMPLIFIED_EVEN";
        case   0x2EEC: return "CJK_RADICAL_C_SIMPLIFIED_EVEN";
        case   0x2EED: return "CJK_RADICAL_J_SIMPLIFIED_TOOTH";
        case   0x2EEE: return "CJK_RADICAL_C_SIMPLIFIED_TOOTH";
        case   0x2EEF: return "CJK_RADICAL_J_SIMPLIFIED_DRAGON";
        case   0x2EF0: return "CJK_RADICAL_C_SIMPLIFIED_DRAGON";
        case   0x2EF1: return "CJK_RADICAL_TURTLE";
        case   0x2EF2: return "CJK_RADICAL_J_SIMPLIFIED_TURTLE";
        case   0x2EF3: return "CJK_RADICAL_C_SIMPLIFIED_TURTLE";
        case   0x2F00: return "KANGXI_RADICAL_ONE";
        case   0x2F01: return "KANGXI_RADICAL_LINE";
        case   0x2F02: return "KANGXI_RADICAL_DOT";
        case   0x2F03: return "KANGXI_RADICAL_SLASH";
        case   0x2F04: return "KANGXI_RADICAL_SECOND";
        case   0x2F05: return "KANGXI_RADICAL_HOOK";
        case   0x2F06: return "KANGXI_RADICAL_TWO";
        case   0x2F07: return "KANGXI_RADICAL_LID";
        case   0x2F08: return "KANGXI_RADICAL_MAN";
        case   0x2F09: return "KANGXI_RADICAL_LEGS";
        case   0x2F0A: return "KANGXI_RADICAL_ENTER";
        case   0x2F0B: return "KANGXI_RADICAL_EIGHT";
        case   0x2F0C: return "KANGXI_RADICAL_DOWN_BOX";
        case   0x2F0D: return "KANGXI_RADICAL_COVER";
        case   0x2F0E: return "KANGXI_RADICAL_ICE";
        case   0x2F0F: return "KANGXI_RADICAL_TABLE";
        case   0x2F10: return "KANGXI_RADICAL_OPEN_BOX";
        case   0x2F11: return "KANGXI_RADICAL_KNIFE";
        case   0x2F12: return "KANGXI_RADICAL_POWER";
        case   0x2F13: return "KANGXI_RADICAL_WRAP";
        case   0x2F14: return "KANGXI_RADICAL_SPOON";
        case   0x2F15: return "KANGXI_RADICAL_RIGHT_OPEN_BOX";
        case   0x2F16: return "KANGXI_RADICAL_HIDING_ENCLOSURE";
        case   0x2F17: return "KANGXI_RADICAL_TEN";
        case   0x2F18: return "KANGXI_RADICAL_DIVINATION";
        case   0x2F19: return "KANGXI_RADICAL_SEAL";
        case   0x2F1A: return "KANGXI_RADICAL_CLIFF";
        case   0x2F1B: return "KANGXI_RADICAL_PRIVATE";
        case   0x2F1C: return "KANGXI_RADICAL_AGAIN";
        case   0x2F1D: return "KANGXI_RADICAL_MOUTH";
        case   0x2F1E: return "KANGXI_RADICAL_ENCLOSURE";
        case   0x2F1F: return "KANGXI_RADICAL_EARTH";
        case   0x2F20: return "KANGXI_RADICAL_SCHOLAR";
        case   0x2F21: return "KANGXI_RADICAL_GO";
        case   0x2F22: return "KANGXI_RADICAL_GO_SLOWLY";
        case   0x2F23: return "KANGXI_RADICAL_EVENING";
        case   0x2F24: return "KANGXI_RADICAL_BIG";
        case   0x2F25: return "KANGXI_RADICAL_WOMAN";
        case   0x2F26: return "KANGXI_RADICAL_CHILD";
        case   0x2F27: return "KANGXI_RADICAL_ROOF";
        case   0x2F28: return "KANGXI_RADICAL_INCH";
        case   0x2F29: return "KANGXI_RADICAL_SMALL";
        case   0x2F2A: return "KANGXI_RADICAL_LAME";
        case   0x2F2B: return "KANGXI_RADICAL_CORPSE";
        case   0x2F2C: return "KANGXI_RADICAL_SPROUT";
        case   0x2F2D: return "KANGXI_RADICAL_MOUNTAIN";
        case   0x2F2E: return "KANGXI_RADICAL_RIVER";
        case   0x2F2F: return "KANGXI_RADICAL_WORK";
        case   0x2F30: return "KANGXI_RADICAL_ONESELF";
        case   0x2F31: return "KANGXI_RADICAL_TURBAN";
        case   0x2F32: return "KANGXI_RADICAL_DRY";
        case   0x2F33: return "KANGXI_RADICAL_SHORT_THREAD";
        case   0x2F34: return "KANGXI_RADICAL_DOTTED_CLIFF";
        case   0x2F35: return "KANGXI_RADICAL_LONG_STRIDE";
        case   0x2F36: return "KANGXI_RADICAL_TWO_HANDS";
        case   0x2F37: return "KANGXI_RADICAL_SHOOT";
        case   0x2F38: return "KANGXI_RADICAL_BOW";
        case   0x2F39: return "KANGXI_RADICAL_SNOUT";
        case   0x2F3A: return "KANGXI_RADICAL_BRISTLE";
        case   0x2F3B: return "KANGXI_RADICAL_STEP";
        case   0x2F3C: return "KANGXI_RADICAL_HEART";
        case   0x2F3D: return "KANGXI_RADICAL_HALBERD";
        case   0x2F3E: return "KANGXI_RADICAL_DOOR";
        case   0x2F3F: return "KANGXI_RADICAL_HAND";
        case   0x2F40: return "KANGXI_RADICAL_BRANCH";
        case   0x2F41: return "KANGXI_RADICAL_RAP";
        case   0x2F42: return "KANGXI_RADICAL_SCRIPT";
        case   0x2F43: return "KANGXI_RADICAL_DIPPER";
        case   0x2F44: return "KANGXI_RADICAL_AXE";
        case   0x2F45: return "KANGXI_RADICAL_SQUARE";
        case   0x2F46: return "KANGXI_RADICAL_NOT";
        case   0x2F47: return "KANGXI_RADICAL_SUN";
        case   0x2F48: return "KANGXI_RADICAL_SAY";
        case   0x2F49: return "KANGXI_RADICAL_MOON";
        case   0x2F4A: return "KANGXI_RADICAL_TREE";
        case   0x2F4B: return "KANGXI_RADICAL_LACK";
        case   0x2F4C: return "KANGXI_RADICAL_STOP";
        case   0x2F4D: return "KANGXI_RADICAL_DEATH";
        case   0x2F4E: return "KANGXI_RADICAL_WEAPON";
        case   0x2F4F: return "KANGXI_RADICAL_DO_NOT";
        case   0x2F50: return "KANGXI_RADICAL_COMPARE";
        case   0x2F51: return "KANGXI_RADICAL_FUR";
        case   0x2F52: return "KANGXI_RADICAL_CLAN";
        case   0x2F53: return "KANGXI_RADICAL_STEAM";
        case   0x2F54: return "KANGXI_RADICAL_WATER";
        case   0x2F55: return "KANGXI_RADICAL_FIRE";
        case   0x2F56: return "KANGXI_RADICAL_CLAW";
        case   0x2F57: return "KANGXI_RADICAL_FATHER";
        case   0x2F58: return "KANGXI_RADICAL_DOUBLE_X";
        case   0x2F59: return "KANGXI_RADICAL_HALF_TREE_TRUNK";
        case   0x2F5A: return "KANGXI_RADICAL_SLICE";
        case   0x2F5B: return "KANGXI_RADICAL_FANG";
        case   0x2F5C: return "KANGXI_RADICAL_COW";
        case   0x2F5D: return "KANGXI_RADICAL_DOG";
        case   0x2F5E: return "KANGXI_RADICAL_PROFOUND";
        case   0x2F5F: return "KANGXI_RADICAL_JADE";
        case   0x2F60: return "KANGXI_RADICAL_MELON";
        case   0x2F61: return "KANGXI_RADICAL_TILE";
        case   0x2F62: return "KANGXI_RADICAL_SWEET";
        case   0x2F63: return "KANGXI_RADICAL_LIFE";
        case   0x2F64: return "KANGXI_RADICAL_USE";
        case   0x2F65: return "KANGXI_RADICAL_FIELD";
        case   0x2F66: return "KANGXI_RADICAL_BOLT_OF_CLOTH";
        case   0x2F67: return "KANGXI_RADICAL_SICKNESS";
        case   0x2F68: return "KANGXI_RADICAL_DOTTED_TENT";
        case   0x2F69: return "KANGXI_RADICAL_WHITE";
        case   0x2F6A: return "KANGXI_RADICAL_SKIN";
        case   0x2F6B: return "KANGXI_RADICAL_DISH";
        case   0x2F6C: return "KANGXI_RADICAL_EYE";
        case   0x2F6D: return "KANGXI_RADICAL_SPEAR";
        case   0x2F6E: return "KANGXI_RADICAL_ARROW";
        case   0x2F6F: return "KANGXI_RADICAL_STONE";
        case   0x2F70: return "KANGXI_RADICAL_SPIRIT";
        case   0x2F71: return "KANGXI_RADICAL_TRACK";
        case   0x2F72: return "KANGXI_RADICAL_GRAIN";
        case   0x2F73: return "KANGXI_RADICAL_CAVE";
        case   0x2F74: return "KANGXI_RADICAL_STAND";
        case   0x2F75: return "KANGXI_RADICAL_BAMBOO";
        case   0x2F76: return "KANGXI_RADICAL_RICE";
        case   0x2F77: return "KANGXI_RADICAL_SILK";
        case   0x2F78: return "KANGXI_RADICAL_JAR";
        case   0x2F79: return "KANGXI_RADICAL_NET";
        case   0x2F7A: return "KANGXI_RADICAL_SHEEP";
        case   0x2F7B: return "KANGXI_RADICAL_FEATHER";
        case   0x2F7C: return "KANGXI_RADICAL_OLD";
        case   0x2F7D: return "KANGXI_RADICAL_AND";
        case   0x2F7E: return "KANGXI_RADICAL_PLOW";
        case   0x2F7F: return "KANGXI_RADICAL_EAR";
        case   0x2F80: return "KANGXI_RADICAL_BRUSH";
        case   0x2F81: return "KANGXI_RADICAL_MEAT";
        case   0x2F82: return "KANGXI_RADICAL_MINISTER";
        case   0x2F83: return "KANGXI_RADICAL_SELF";
        case   0x2F84: return "KANGXI_RADICAL_ARRIVE";
        case   0x2F85: return "KANGXI_RADICAL_MORTAR";
        case   0x2F86: return "KANGXI_RADICAL_TONGUE";
        case   0x2F87: return "KANGXI_RADICAL_OPPOSE";
        case   0x2F88: return "KANGXI_RADICAL_BOAT";
        case   0x2F89: return "KANGXI_RADICAL_STOPPING";
        case   0x2F8A: return "KANGXI_RADICAL_COLOR";
        case   0x2F8B: return "KANGXI_RADICAL_GRASS";
        case   0x2F8C: return "KANGXI_RADICAL_TIGER";
        case   0x2F8D: return "KANGXI_RADICAL_INSECT";
        case   0x2F8E: return "KANGXI_RADICAL_BLOOD";
        case   0x2F8F: return "KANGXI_RADICAL_WALK_ENCLOSURE";
        case   0x2F90: return "KANGXI_RADICAL_CLOTHES";
        case   0x2F91: return "KANGXI_RADICAL_WEST";
        case   0x2F92: return "KANGXI_RADICAL_SEE";
        case   0x2F93: return "KANGXI_RADICAL_HORN";
        case   0x2F94: return "KANGXI_RADICAL_SPEECH";
        case   0x2F95: return "KANGXI_RADICAL_VALLEY";
        case   0x2F96: return "KANGXI_RADICAL_BEAN";
        case   0x2F97: return "KANGXI_RADICAL_PIG";
        case   0x2F98: return "KANGXI_RADICAL_BADGER";
        case   0x2F99: return "KANGXI_RADICAL_SHELL";
        case   0x2F9A: return "KANGXI_RADICAL_RED";
        case   0x2F9B: return "KANGXI_RADICAL_RUN";
        case   0x2F9C: return "KANGXI_RADICAL_FOOT";
        case   0x2F9D: return "KANGXI_RADICAL_BODY";
        case   0x2F9E: return "KANGXI_RADICAL_CART";
        case   0x2F9F: return "KANGXI_RADICAL_BITTER";
        case   0x2FA0: return "KANGXI_RADICAL_MORNING";
        case   0x2FA1: return "KANGXI_RADICAL_WALK";
        case   0x2FA2: return "KANGXI_RADICAL_CITY";
        case   0x2FA3: return "KANGXI_RADICAL_WINE";
        case   0x2FA4: return "KANGXI_RADICAL_DISTINGUISH";
        case   0x2FA5: return "KANGXI_RADICAL_VILLAGE";
        case   0x2FA6: return "KANGXI_RADICAL_GOLD";
        case   0x2FA7: return "KANGXI_RADICAL_LONG";
        case   0x2FA8: return "KANGXI_RADICAL_GATE";
        case   0x2FA9: return "KANGXI_RADICAL_MOUND";
        case   0x2FAA: return "KANGXI_RADICAL_SLAVE";
        case   0x2FAB: return "KANGXI_RADICAL_SHORT_TAILED_BIRD";
        case   0x2FAC: return "KANGXI_RADICAL_RAIN";
        case   0x2FAD: return "KANGXI_RADICAL_BLUE";
        case   0x2FAE: return "KANGXI_RADICAL_WRONG";
        case   0x2FAF: return "KANGXI_RADICAL_FACE";
        case   0x2FB0: return "KANGXI_RADICAL_LEATHER";
        case   0x2FB1: return "KANGXI_RADICAL_TANNED_LEATHER";
        case   0x2FB2: return "KANGXI_RADICAL_LEEK";
        case   0x2FB3: return "KANGXI_RADICAL_SOUND";
        case   0x2FB4: return "KANGXI_RADICAL_LEAF";
        case   0x2FB5: return "KANGXI_RADICAL_WIND";
        case   0x2FB6: return "KANGXI_RADICAL_FLY";
        case   0x2FB7: return "KANGXI_RADICAL_EAT";
        case   0x2FB8: return "KANGXI_RADICAL_HEAD";
        case   0x2FB9: return "KANGXI_RADICAL_FRAGRANT";
        case   0x2FBA: return "KANGXI_RADICAL_HORSE";
        case   0x2FBB: return "KANGXI_RADICAL_BONE";
        case   0x2FBC: return "KANGXI_RADICAL_TALL";
        case   0x2FBD: return "KANGXI_RADICAL_HAIR";
        case   0x2FBE: return "KANGXI_RADICAL_FIGHT";
        case   0x2FBF: return "KANGXI_RADICAL_SACRIFICIAL_WINE";
        case   0x2FC0: return "KANGXI_RADICAL_CAULDRON";
        case   0x2FC1: return "KANGXI_RADICAL_GHOST";
        case   0x2FC2: return "KANGXI_RADICAL_FISH";
        case   0x2FC3: return "KANGXI_RADICAL_BIRD";
        case   0x2FC4: return "KANGXI_RADICAL_SALT";
        case   0x2FC5: return "KANGXI_RADICAL_DEER";
        case   0x2FC6: return "KANGXI_RADICAL_WHEAT";
        case   0x2FC7: return "KANGXI_RADICAL_HEMP";
        case   0x2FC8: return "KANGXI_RADICAL_YELLOW";
        case   0x2FC9: return "KANGXI_RADICAL_MILLET";
        case   0x2FCA: return "KANGXI_RADICAL_BLACK";
        case   0x2FCB: return "KANGXI_RADICAL_EMBROIDERY";
        case   0x2FCC: return "KANGXI_RADICAL_FROG";
        case   0x2FCD: return "KANGXI_RADICAL_TRIPOD";
        case   0x2FCE: return "KANGXI_RADICAL_DRUM";
        case   0x2FCF: return "KANGXI_RADICAL_RAT";
        case   0x2FD0: return "KANGXI_RADICAL_NOSE";
        case   0x2FD1: return "KANGXI_RADICAL_EVEN";
        case   0x2FD2: return "KANGXI_RADICAL_TOOTH";
        case   0x2FD3: return "KANGXI_RADICAL_DRAGON";
        case   0x2FD4: return "KANGXI_RADICAL_TURTLE";
        case   0x2FD5: return "KANGXI_RADICAL_FLUTE";
        case   0x2FF0: return
                "IDEOGRAPHIC_DESCRIPTION_CHARACTER_LEFT_TO_RIGHT";
        case   0x2FF1: return
                "IDEOGRAPHIC_DESCRIPTION_CHARACTER_ABOVE_TO_BELOW";
        case   0x2FF2: return
                "IDEOGRAPHIC_DESCRIPTION_CHARACTER_LEFT_TO_MIDDLE_AND_RIGHT";
        case   0x2FF3: return
                "IDEOGRAPHIC_DESCRIPTION_CHARACTER_ABOVE_TO_MIDDLE_AND_BELOW";
        case   0x2FF4: return
                "IDEOGRAPHIC_DESCRIPTION_CHARACTER_FULL_SURROUND";
        case   0x2FF5: return
                "IDEOGRAPHIC_DESCRIPTION_CHARACTER_SURROUND_FROM_ABOVE";
        case   0x2FF6: return
                "IDEOGRAPHIC_DESCRIPTION_CHARACTER_SURROUND_FROM_BELOW";
        case   0x2FF7: return
                "IDEOGRAPHIC_DESCRIPTION_CHARACTER_SURROUND_FROM_LEFT";
        case   0x2FF8: return
                "IDEOGRAPHIC_DESCRIPTION_CHARACTER_SURROUND_FROM_UPPER_LEFT";
        case   0x2FF9: return
                "IDEOGRAPHIC_DESCRIPTION_CHARACTER_SURROUND_FROM_UPPER_RIGHT";
        case   0x2FFA: return
                "IDEOGRAPHIC_DESCRIPTION_CHARACTER_SURROUND_FROM_LOWER_LEFT";
        case   0x2FFB: return "IDEOGRAPHIC_DESCRIPTION_CHARACTER_OVERLAID";
        case   0x3000: return "IDEOGRAPHIC_SPACE";
        case   0x3001: return "IDEOGRAPHIC_COMMA";
        case   0x3002: return "IDEOGRAPHIC_FULL_STOP";
        case   0x3003: return "DITTO_MARK";
        case   0x3004: return "JAPANESE_INDUSTRIAL_STANDARD_SYMBOL";
        case   0x3005: return "IDEOGRAPHIC_ITERATION_MARK";
        case   0x3006: return "IDEOGRAPHIC_CLOSING_MARK";
        case   0x3007: return "IDEOGRAPHIC_NUMBER_ZERO";
        case   0x3008: return "LEFT_ANGLE_BRACKET";
        case   0x3009: return "RIGHT_ANGLE_BRACKET";
        case   0x300A: return "LEFT_DOUBLE_ANGLE_BRACKET";
        case   0x300B: return "RIGHT_DOUBLE_ANGLE_BRACKET";
        case   0x300C: return "LEFT_CORNER_BRACKET";
        case   0x300D: return "RIGHT_CORNER_BRACKET";
        case   0x300E: return "LEFT_WHITE_CORNER_BRACKET";
        case   0x300F: return "RIGHT_WHITE_CORNER_BRACKET";
        case   0x3010: return "LEFT_BLACK_LENTICULAR_BRACKET";
        case   0x3011: return "RIGHT_BLACK_LENTICULAR_BRACKET";
        case   0x3012: return "POSTAL_MARK";
        case   0x3013: return "GETA_MARK";
        case   0x3014: return "LEFT_TORTOISE_SHELL_BRACKET";
        case   0x3015: return "RIGHT_TORTOISE_SHELL_BRACKET";
        case   0x3016: return "LEFT_WHITE_LENTICULAR_BRACKET";
        case   0x3017: return "RIGHT_WHITE_LENTICULAR_BRACKET";
        case   0x3018: return "LEFT_WHITE_TORTOISE_SHELL_BRACKET";
        case   0x3019: return "RIGHT_WHITE_TORTOISE_SHELL_BRACKET";
        case   0x301A: return "LEFT_WHITE_SQUARE_BRACKET";
        case   0x301B: return "RIGHT_WHITE_SQUARE_BRACKET";
        case   0x301C: return "WAVE_DASH";
        case   0x301D: return "REVERSED_DOUBLE_PRIME_QUOTATION_MARK";
        case   0x301E: return "DOUBLE_PRIME_QUOTATION_MARK";
        case   0x301F: return "LOW_DOUBLE_PRIME_QUOTATION_MARK";
        case   0x3020: return "POSTAL_MARK_FACE";
        case   0x3021: return "HANGZHOU_NUMERAL_ONE";
        case   0x3022: return "HANGZHOU_NUMERAL_TWO";
        case   0x3023: return "HANGZHOU_NUMERAL_THREE";
        case   0x3024: return "HANGZHOU_NUMERAL_FOUR";
        case   0x3025: return "HANGZHOU_NUMERAL_FIVE";
        case   0x3026: return "HANGZHOU_NUMERAL_SIX";
        case   0x3027: return "HANGZHOU_NUMERAL_SEVEN";
        case   0x3028: return "HANGZHOU_NUMERAL_EIGHT";
        case   0x3029: return "HANGZHOU_NUMERAL_NINE";
        case   0x302A: return "IDEOGRAPHIC_LEVEL_TONE_MARK";
        case   0x302B: return "IDEOGRAPHIC_RISING_TONE_MARK";
        case   0x302C: return "IDEOGRAPHIC_DEPARTING_TONE_MARK";
        case   0x302D: return "IDEOGRAPHIC_ENTERING_TONE_MARK";
        case   0x302E: return "HANGUL_SINGLE_DOT_TONE_MARK";
        case   0x302F: return "HANGUL_DOUBLE_DOT_TONE_MARK";
        case   0x3030: return "WAVY_DASH";
        case   0x3031: return "VERTICAL_KANA_REPEAT_MARK";
        case   0x3032: return "VERTICAL_KANA_REPEAT_WITH_VOICED_SOUND_MARK";
        case   0x3033: return "VERTICAL_KANA_REPEAT_MARK_UPPER_HALF";
        case   0x3034: return
                "VERTICAL_KANA_REPEAT_WITH_VOICED_SOUND_MARK_UPPER_HALF";
        case   0x3035: return "VERTICAL_KANA_REPEAT_MARK_LOWER_HALF";
        case   0x3036: return "CIRCLED_POSTAL_MARK";
        case   0x3037: return
                "IDEOGRAPHIC_TELEGRAPH_LINE_FEED_SEPARATOR_SYMBOL";
        case   0x3038: return "HANGZHOU_NUMERAL_TEN";
        case   0x3039: return "HANGZHOU_NUMERAL_TWENTY";
        case   0x303A: return "HANGZHOU_NUMERAL_THIRTY";
        case   0x303B: return "VERTICAL_IDEOGRAPHIC_ITERATION_MARK";
        case   0x303C: return "MASU_MARK";
        case   0x303D: return "PART_ALTERNATION_MARK";
        case   0x303E: return "IDEOGRAPHIC_VARIATION_INDICATOR";
        case   0x303F: return "IDEOGRAPHIC_HALF_FILL_SPACE";
        case   0x3041: return "HIRAGANA_LETTER_SMALL_A";
        case   0x3042: return "HIRAGANA_LETTER_A";
        case   0x3043: return "HIRAGANA_LETTER_SMALL_I";
        case   0x3044: return "HIRAGANA_LETTER_I";
        case   0x3045: return "HIRAGANA_LETTER_SMALL_U";
        case   0x3046: return "HIRAGANA_LETTER_U";
        case   0x3047: return "HIRAGANA_LETTER_SMALL_E";
        case   0x3048: return "HIRAGANA_LETTER_E";
        case   0x3049: return "HIRAGANA_LETTER_SMALL_O";
        case   0x304A: return "HIRAGANA_LETTER_O";
        case   0x304B: return "HIRAGANA_LETTER_KA";
        case   0x304C: return "HIRAGANA_LETTER_GA";
        case   0x304D: return "HIRAGANA_LETTER_KI";
        case   0x304E: return "HIRAGANA_LETTER_GI";
        case   0x304F: return "HIRAGANA_LETTER_KU";
        case   0x3050: return "HIRAGANA_LETTER_GU";
        case   0x3051: return "HIRAGANA_LETTER_KE";
        case   0x3052: return "HIRAGANA_LETTER_GE";
        case   0x3053: return "HIRAGANA_LETTER_KO";
        case   0x3054: return "HIRAGANA_LETTER_GO";
        case   0x3055: return "HIRAGANA_LETTER_SA";
        case   0x3056: return "HIRAGANA_LETTER_ZA";
        case   0x3057: return "HIRAGANA_LETTER_SI";
        case   0x3058: return "HIRAGANA_LETTER_ZI";
        case   0x3059: return "HIRAGANA_LETTER_SU";
        case   0x305A: return "HIRAGANA_LETTER_ZU";
        case   0x305B: return "HIRAGANA_LETTER_SE";
        case   0x305C: return "HIRAGANA_LETTER_ZE";
        case   0x305D: return "HIRAGANA_LETTER_SO";
        case   0x305E: return "HIRAGANA_LETTER_ZO";
        case   0x305F: return "HIRAGANA_LETTER_TA";
        case   0x3060: return "HIRAGANA_LETTER_DA";
        case   0x3061: return "HIRAGANA_LETTER_TI";
        case   0x3062: return "HIRAGANA_LETTER_DI";
        case   0x3063: return "HIRAGANA_LETTER_SMALL_TU";
        case   0x3064: return "HIRAGANA_LETTER_TU";
        case   0x3065: return "HIRAGANA_LETTER_DU";
        case   0x3066: return "HIRAGANA_LETTER_TE";
        case   0x3067: return "HIRAGANA_LETTER_DE";
        case   0x3068: return "HIRAGANA_LETTER_TO";
        case   0x3069: return "HIRAGANA_LETTER_DO";
        case   0x306A: return "HIRAGANA_LETTER_NA";
        case   0x306B: return "HIRAGANA_LETTER_NI";
        case   0x306C: return "HIRAGANA_LETTER_NU";
        case   0x306D: return "HIRAGANA_LETTER_NE";
        case   0x306E: return "HIRAGANA_LETTER_NO";
        case   0x306F: return "HIRAGANA_LETTER_HA";
        case   0x3070: return "HIRAGANA_LETTER_BA";
        case   0x3071: return "HIRAGANA_LETTER_PA";
        case   0x3072: return "HIRAGANA_LETTER_HI";
        case   0x3073: return "HIRAGANA_LETTER_BI";
        case   0x3074: return "HIRAGANA_LETTER_PI";
        case   0x3075: return "HIRAGANA_LETTER_HU";
        case   0x3076: return "HIRAGANA_LETTER_BU";
        case   0x3077: return "HIRAGANA_LETTER_PU";
        case   0x3078: return "HIRAGANA_LETTER_HE";
        case   0x3079: return "HIRAGANA_LETTER_BE";
        case   0x307A: return "HIRAGANA_LETTER_PE";
        case   0x307B: return "HIRAGANA_LETTER_HO";
        case   0x307C: return "HIRAGANA_LETTER_BO";
        case   0x307D: return "HIRAGANA_LETTER_PO";
        case   0x307E: return "HIRAGANA_LETTER_MA";
        case   0x307F: return "HIRAGANA_LETTER_MI";
        case   0x3080: return "HIRAGANA_LETTER_MU";
        case   0x3081: return "HIRAGANA_LETTER_ME";
        case   0x3082: return "HIRAGANA_LETTER_MO";
        case   0x3083: return "HIRAGANA_LETTER_SMALL_YA";
        case   0x3084: return "HIRAGANA_LETTER_YA";
        case   0x3085: return "HIRAGANA_LETTER_SMALL_YU";
        case   0x3086: return "HIRAGANA_LETTER_YU";
        case   0x3087: return "HIRAGANA_LETTER_SMALL_YO";
        case   0x3088: return "HIRAGANA_LETTER_YO";
        case   0x3089: return "HIRAGANA_LETTER_RA";
        case   0x308A: return "HIRAGANA_LETTER_RI";
        case   0x308B: return "HIRAGANA_LETTER_RU";
        case   0x308C: return "HIRAGANA_LETTER_RE";
        case   0x308D: return "HIRAGANA_LETTER_RO";
        case   0x308E: return "HIRAGANA_LETTER_SMALL_WA";
        case   0x308F: return "HIRAGANA_LETTER_WA";
        case   0x3090: return "HIRAGANA_LETTER_WI";
        case   0x3091: return "HIRAGANA_LETTER_WE";
        case   0x3092: return "HIRAGANA_LETTER_WO";
        case   0x3093: return "HIRAGANA_LETTER_N";
        case   0x3094: return "HIRAGANA_LETTER_VU";
        case   0x3095: return "HIRAGANA_LETTER_SMALL_KA";
        case   0x3096: return "HIRAGANA_LETTER_SMALL_KE";
        case   0x3099: return "COMBINING_KATAKANA_HIRAGANA_VOICED_SOUND_MARK";
        case   0x309A: return
                "COMBINING_KATAKANA_HIRAGANA_SEMI_VOICED_SOUND_MARK";
        case   0x309B: return "KATAKANA_HIRAGANA_VOICED_SOUND_MARK";
        case   0x309C: return "KATAKANA_HIRAGANA_SEMI_VOICED_SOUND_MARK";
        case   0x309D: return "HIRAGANA_ITERATION_MARK";
        case   0x309E: return "HIRAGANA_VOICED_ITERATION_MARK";
        case   0x309F: return "HIRAGANA_DIGRAPH_YORI";
        case   0x30A0: return "KATAKANA_HIRAGANA_DOUBLE_HYPHEN";
        case   0x30A1: return "KATAKANA_LETTER_SMALL_A";
        case   0x30A2: return "KATAKANA_LETTER_A";
        case   0x30A3: return "KATAKANA_LETTER_SMALL_I";
        case   0x30A4: return "KATAKANA_LETTER_I";
        case   0x30A5: return "KATAKANA_LETTER_SMALL_U";
        case   0x30A6: return "KATAKANA_LETTER_U";
        case   0x30A7: return "KATAKANA_LETTER_SMALL_E";
        case   0x30A8: return "KATAKANA_LETTER_E";
        case   0x30A9: return "KATAKANA_LETTER_SMALL_O";
        case   0x30AA: return "KATAKANA_LETTER_O";
        case   0x30AB: return "KATAKANA_LETTER_KA";
        case   0x30AC: return "KATAKANA_LETTER_GA";
        case   0x30AD: return "KATAKANA_LETTER_KI";
        case   0x30AE: return "KATAKANA_LETTER_GI";
        case   0x30AF: return "KATAKANA_LETTER_KU";
        case   0x30B0: return "KATAKANA_LETTER_GU";
        case   0x30B1: return "KATAKANA_LETTER_KE";
        case   0x30B2: return "KATAKANA_LETTER_GE";
        case   0x30B3: return "KATAKANA_LETTER_KO";
        case   0x30B4: return "KATAKANA_LETTER_GO";
        case   0x30B5: return "KATAKANA_LETTER_SA";
        case   0x30B6: return "KATAKANA_LETTER_ZA";
        case   0x30B7: return "KATAKANA_LETTER_SI";
        case   0x30B8: return "KATAKANA_LETTER_ZI";
        case   0x30B9: return "KATAKANA_LETTER_SU";
        case   0x30BA: return "KATAKANA_LETTER_ZU";
        case   0x30BB: return "KATAKANA_LETTER_SE";
        case   0x30BC: return "KATAKANA_LETTER_ZE";
        case   0x30BD: return "KATAKANA_LETTER_SO";
        case   0x30BE: return "KATAKANA_LETTER_ZO";
        case   0x30BF: return "KATAKANA_LETTER_TA";
        case   0x30C0: return "KATAKANA_LETTER_DA";
        case   0x30C1: return "KATAKANA_LETTER_TI";
        case   0x30C2: return "KATAKANA_LETTER_DI";
        case   0x30C3: return "KATAKANA_LETTER_SMALL_TU";
        case   0x30C4: return "KATAKANA_LETTER_TU";
        case   0x30C5: return "KATAKANA_LETTER_DU";
        case   0x30C6: return "KATAKANA_LETTER_TE";
        case   0x30C7: return "KATAKANA_LETTER_DE";
        case   0x30C8: return "KATAKANA_LETTER_TO";
        case   0x30C9: return "KATAKANA_LETTER_DO";
        case   0x30CA: return "KATAKANA_LETTER_NA";
        case   0x30CB: return "KATAKANA_LETTER_NI";
        case   0x30CC: return "KATAKANA_LETTER_NU";
        case   0x30CD: return "KATAKANA_LETTER_NE";
        case   0x30CE: return "KATAKANA_LETTER_NO";
        case   0x30CF: return "KATAKANA_LETTER_HA";
        case   0x30D0: return "KATAKANA_LETTER_BA";
        case   0x30D1: return "KATAKANA_LETTER_PA";
        case   0x30D2: return "KATAKANA_LETTER_HI";
        case   0x30D3: return "KATAKANA_LETTER_BI";
        case   0x30D4: return "KATAKANA_LETTER_PI";
        case   0x30D5: return "KATAKANA_LETTER_HU";
        case   0x30D6: return "KATAKANA_LETTER_BU";
        case   0x30D7: return "KATAKANA_LETTER_PU";
        case   0x30D8: return "KATAKANA_LETTER_HE";
        case   0x30D9: return "KATAKANA_LETTER_BE";
        case   0x30DA: return "KATAKANA_LETTER_PE";
        case   0x30DB: return "KATAKANA_LETTER_HO";
        case   0x30DC: return "KATAKANA_LETTER_BO";
        case   0x30DD: return "KATAKANA_LETTER_PO";
        case   0x30DE: return "KATAKANA_LETTER_MA";
        case   0x30DF: return "KATAKANA_LETTER_MI";
        case   0x30E0: return "KATAKANA_LETTER_MU";
        case   0x30E1: return "KATAKANA_LETTER_ME";
        case   0x30E2: return "KATAKANA_LETTER_MO";
        case   0x30E3: return "KATAKANA_LETTER_SMALL_YA";
        case   0x30E4: return "KATAKANA_LETTER_YA";
        case   0x30E5: return "KATAKANA_LETTER_SMALL_YU";
        case   0x30E6: return "KATAKANA_LETTER_YU";
        case   0x30E7: return "KATAKANA_LETTER_SMALL_YO";
        case   0x30E8: return "KATAKANA_LETTER_YO";
        case   0x30E9: return "KATAKANA_LETTER_RA";
        case   0x30EA: return "KATAKANA_LETTER_RI";
        case   0x30EB: return "KATAKANA_LETTER_RU";
        case   0x30EC: return "KATAKANA_LETTER_RE";
        case   0x30ED: return "KATAKANA_LETTER_RO";
        case   0x30EE: return "KATAKANA_LETTER_SMALL_WA";
        case   0x30EF: return "KATAKANA_LETTER_WA";
        case   0x30F0: return "KATAKANA_LETTER_WI";
        case   0x30F1: return "KATAKANA_LETTER_WE";
        case   0x30F2: return "KATAKANA_LETTER_WO";
        case   0x30F3: return "KATAKANA_LETTER_N";
        case   0x30F4: return "KATAKANA_LETTER_VU";
        case   0x30F5: return "KATAKANA_LETTER_SMALL_KA";
        case   0x30F6: return "KATAKANA_LETTER_SMALL_KE";
        case   0x30F7: return "KATAKANA_LETTER_VA";
        case   0x30F8: return "KATAKANA_LETTER_VI";
        case   0x30F9: return "KATAKANA_LETTER_VE";
        case   0x30FA: return "KATAKANA_LETTER_VO";
        case   0x30FB: return "KATAKANA_MIDDLE_DOT";
        case   0x30FC: return "KATAKANA_HIRAGANA_PROLONGED_SOUND_MARK";
        case   0x30FD: return "KATAKANA_ITERATION_MARK";
        case   0x30FE: return "KATAKANA_VOICED_ITERATION_MARK";
        case   0x30FF: return "KATAKANA_DIGRAPH_KOTO";
        case   0x3105: return "BOPOMOFO_LETTER_B";
        case   0x3106: return "BOPOMOFO_LETTER_P";
        case   0x3107: return "BOPOMOFO_LETTER_M";
        case   0x3108: return "BOPOMOFO_LETTER_F";
        case   0x3109: return "BOPOMOFO_LETTER_D";
        case   0x310A: return "BOPOMOFO_LETTER_T";
        case   0x310B: return "BOPOMOFO_LETTER_N";
        case   0x310C: return "BOPOMOFO_LETTER_L";
        case   0x310D: return "BOPOMOFO_LETTER_G";
        case   0x310E: return "BOPOMOFO_LETTER_K";
        case   0x310F: return "BOPOMOFO_LETTER_H";
        case   0x3110: return "BOPOMOFO_LETTER_J";
        case   0x3111: return "BOPOMOFO_LETTER_Q";
        case   0x3112: return "BOPOMOFO_LETTER_X";
        case   0x3113: return "BOPOMOFO_LETTER_ZH";
        case   0x3114: return "BOPOMOFO_LETTER_CH";
        case   0x3115: return "BOPOMOFO_LETTER_SH";
        case   0x3116: return "BOPOMOFO_LETTER_R";
        case   0x3117: return "BOPOMOFO_LETTER_Z";
        case   0x3118: return "BOPOMOFO_LETTER_C";
        case   0x3119: return "BOPOMOFO_LETTER_S";
        case   0x311A: return "BOPOMOFO_LETTER_A";
        case   0x311B: return "BOPOMOFO_LETTER_O";
        case   0x311C: return "BOPOMOFO_LETTER_E";
        case   0x311D: return "BOPOMOFO_LETTER_EH";
        case   0x311E: return "BOPOMOFO_LETTER_AI";
        case   0x311F: return "BOPOMOFO_LETTER_EI";
        case   0x3120: return "BOPOMOFO_LETTER_AU";
        case   0x3121: return "BOPOMOFO_LETTER_OU";
        case   0x3122: return "BOPOMOFO_LETTER_AN";
        case   0x3123: return "BOPOMOFO_LETTER_EN";
        case   0x3124: return "BOPOMOFO_LETTER_ANG";
        case   0x3125: return "BOPOMOFO_LETTER_ENG";
        case   0x3126: return "BOPOMOFO_LETTER_ER";
        case   0x3127: return "BOPOMOFO_LETTER_I";
        case   0x3128: return "BOPOMOFO_LETTER_U";
        case   0x3129: return "BOPOMOFO_LETTER_IU";
        case   0x312A: return "BOPOMOFO_LETTER_V";
        case   0x312B: return "BOPOMOFO_LETTER_NG";
        case   0x312C: return "BOPOMOFO_LETTER_GN";
        case   0x312D: return "BOPOMOFO_LETTER_IH";
        case   0x3131: return "HANGUL_LETTER_KIYEOK";
        case   0x3132: return "HANGUL_LETTER_SSANGKIYEOK";
        case   0x3133: return "HANGUL_LETTER_KIYEOK_SIOS";
        case   0x3134: return "HANGUL_LETTER_NIEUN";
        case   0x3135: return "HANGUL_LETTER_NIEUN_CIEUC";
        case   0x3136: return "HANGUL_LETTER_NIEUN_HIEUH";
        case   0x3137: return "HANGUL_LETTER_TIKEUT";
        case   0x3138: return "HANGUL_LETTER_SSANGTIKEUT";
        case   0x3139: return "HANGUL_LETTER_RIEUL";
        case   0x313A: return "HANGUL_LETTER_RIEUL_KIYEOK";
        case   0x313B: return "HANGUL_LETTER_RIEUL_MIEUM";
        case   0x313C: return "HANGUL_LETTER_RIEUL_PIEUP";
        case   0x313D: return "HANGUL_LETTER_RIEUL_SIOS";
        case   0x313E: return "HANGUL_LETTER_RIEUL_THIEUTH";
        case   0x313F: return "HANGUL_LETTER_RIEUL_PHIEUPH";
        case   0x3140: return "HANGUL_LETTER_RIEUL_HIEUH";
        case   0x3141: return "HANGUL_LETTER_MIEUM";
        case   0x3142: return "HANGUL_LETTER_PIEUP";
        case   0x3143: return "HANGUL_LETTER_SSANGPIEUP";
        case   0x3144: return "HANGUL_LETTER_PIEUP_SIOS";
        case   0x3145: return "HANGUL_LETTER_SIOS";
        case   0x3146: return "HANGUL_LETTER_SSANGSIOS";
        case   0x3147: return "HANGUL_LETTER_IEUNG";
        case   0x3148: return "HANGUL_LETTER_CIEUC";
        case   0x3149: return "HANGUL_LETTER_SSANGCIEUC";
        case   0x314A: return "HANGUL_LETTER_CHIEUCH";
        case   0x314B: return "HANGUL_LETTER_KHIEUKH";
        case   0x314C: return "HANGUL_LETTER_THIEUTH";
        case   0x314D: return "HANGUL_LETTER_PHIEUPH";
        case   0x314E: return "HANGUL_LETTER_HIEUH";
        case   0x314F: return "HANGUL_LETTER_A";
        case   0x3150: return "HANGUL_LETTER_AE";
        case   0x3151: return "HANGUL_LETTER_YA";
        case   0x3152: return "HANGUL_LETTER_YAE";
        case   0x3153: return "HANGUL_LETTER_EO";
        case   0x3154: return "HANGUL_LETTER_E";
        case   0x3155: return "HANGUL_LETTER_YEO";
        case   0x3156: return "HANGUL_LETTER_YE";
        case   0x3157: return "HANGUL_LETTER_O";
        case   0x3158: return "HANGUL_LETTER_WA";
        case   0x3159: return "HANGUL_LETTER_WAE";
        case   0x315A: return "HANGUL_LETTER_OE";
        case   0x315B: return "HANGUL_LETTER_YO";
        case   0x315C: return "HANGUL_LETTER_U";
        case   0x315D: return "HANGUL_LETTER_WEO";
        case   0x315E: return "HANGUL_LETTER_WE";
        case   0x315F: return "HANGUL_LETTER_WI";
        case   0x3160: return "HANGUL_LETTER_YU";
        case   0x3161: return "HANGUL_LETTER_EU";
        case   0x3162: return "HANGUL_LETTER_YI";
        case   0x3163: return "HANGUL_LETTER_I";
        case   0x3164: return "HANGUL_FILLER";
        case   0x3165: return "HANGUL_LETTER_SSANGNIEUN";
        case   0x3166: return "HANGUL_LETTER_NIEUN_TIKEUT";
        case   0x3167: return "HANGUL_LETTER_NIEUN_SIOS";
        case   0x3168: return "HANGUL_LETTER_NIEUN_PANSIOS";
        case   0x3169: return "HANGUL_LETTER_RIEUL_KIYEOK_SIOS";
        case   0x316A: return "HANGUL_LETTER_RIEUL_TIKEUT";
        case   0x316B: return "HANGUL_LETTER_RIEUL_PIEUP_SIOS";
        case   0x316C: return "HANGUL_LETTER_RIEUL_PANSIOS";
        case   0x316D: return "HANGUL_LETTER_RIEUL_YEORINHIEUH";
        case   0x316E: return "HANGUL_LETTER_MIEUM_PIEUP";
        case   0x316F: return "HANGUL_LETTER_MIEUM_SIOS";
        case   0x3170: return "HANGUL_LETTER_MIEUM_PANSIOS";
        case   0x3171: return "HANGUL_LETTER_KAPYEOUNMIEUM";
        case   0x3172: return "HANGUL_LETTER_PIEUP_KIYEOK";
        case   0x3173: return "HANGUL_LETTER_PIEUP_TIKEUT";
        case   0x3174: return "HANGUL_LETTER_PIEUP_SIOS_KIYEOK";
        case   0x3175: return "HANGUL_LETTER_PIEUP_SIOS_TIKEUT";
        case   0x3176: return "HANGUL_LETTER_PIEUP_CIEUC";
        case   0x3177: return "HANGUL_LETTER_PIEUP_THIEUTH";
        case   0x3178: return "HANGUL_LETTER_KAPYEOUNPIEUP";
        case   0x3179: return "HANGUL_LETTER_KAPYEOUNSSANGPIEUP";
        case   0x317A: return "HANGUL_LETTER_SIOS_KIYEOK";
        case   0x317B: return "HANGUL_LETTER_SIOS_NIEUN";
        case   0x317C: return "HANGUL_LETTER_SIOS_TIKEUT";
        case   0x317D: return "HANGUL_LETTER_SIOS_PIEUP";
        case   0x317E: return "HANGUL_LETTER_SIOS_CIEUC";
        case   0x317F: return "HANGUL_LETTER_PANSIOS";
        case   0x3180: return "HANGUL_LETTER_SSANGIEUNG";
        case   0x3181: return "HANGUL_LETTER_YESIEUNG";
        case   0x3182: return "HANGUL_LETTER_YESIEUNG_SIOS";
        case   0x3183: return "HANGUL_LETTER_YESIEUNG_PANSIOS";
        case   0x3184: return "HANGUL_LETTER_KAPYEOUNPHIEUPH";
        case   0x3185: return "HANGUL_LETTER_SSANGHIEUH";
        case   0x3186: return "HANGUL_LETTER_YEORINHIEUH";
        case   0x3187: return "HANGUL_LETTER_YO_YA";
        case   0x3188: return "HANGUL_LETTER_YO_YAE";
        case   0x3189: return "HANGUL_LETTER_YO_I";
        case   0x318A: return "HANGUL_LETTER_YU_YEO";
        case   0x318B: return "HANGUL_LETTER_YU_YE";
        case   0x318C: return "HANGUL_LETTER_YU_I";
        case   0x318D: return "HANGUL_LETTER_ARAEA";
        case   0x318E: return "HANGUL_LETTER_ARAEAE";
        case   0x3190: return "IDEOGRAPHIC_ANNOTATION_LINKING_MARK";
        case   0x3191: return "IDEOGRAPHIC_ANNOTATION_REVERSE_MARK";
        case   0x3192: return "IDEOGRAPHIC_ANNOTATION_ONE_MARK";
        case   0x3193: return "IDEOGRAPHIC_ANNOTATION_TWO_MARK";
        case   0x3194: return "IDEOGRAPHIC_ANNOTATION_THREE_MARK";
        case   0x3195: return "IDEOGRAPHIC_ANNOTATION_FOUR_MARK";
        case   0x3196: return "IDEOGRAPHIC_ANNOTATION_TOP_MARK";
        case   0x3197: return "IDEOGRAPHIC_ANNOTATION_MIDDLE_MARK";
        case   0x3198: return "IDEOGRAPHIC_ANNOTATION_BOTTOM_MARK";
        case   0x3199: return "IDEOGRAPHIC_ANNOTATION_FIRST_MARK";
        case   0x319A: return "IDEOGRAPHIC_ANNOTATION_SECOND_MARK";
        case   0x319B: return "IDEOGRAPHIC_ANNOTATION_THIRD_MARK";
        case   0x319C: return "IDEOGRAPHIC_ANNOTATION_FOURTH_MARK";
        case   0x319D: return "IDEOGRAPHIC_ANNOTATION_HEAVEN_MARK";
        case   0x319E: return "IDEOGRAPHIC_ANNOTATION_EARTH_MARK";
        case   0x319F: return "IDEOGRAPHIC_ANNOTATION_MAN_MARK";
        case   0x31A0: return "BOPOMOFO_LETTER_BU";
        case   0x31A1: return "BOPOMOFO_LETTER_ZI";
        case   0x31A2: return "BOPOMOFO_LETTER_JI";
        case   0x31A3: return "BOPOMOFO_LETTER_GU";
        case   0x31A4: return "BOPOMOFO_LETTER_EE";
        case   0x31A5: return "BOPOMOFO_LETTER_ENN";
        case   0x31A6: return "BOPOMOFO_LETTER_OO";
        case   0x31A7: return "BOPOMOFO_LETTER_ONN";
        case   0x31A8: return "BOPOMOFO_LETTER_IR";
        case   0x31A9: return "BOPOMOFO_LETTER_ANN";
        case   0x31AA: return "BOPOMOFO_LETTER_INN";
        case   0x31AB: return "BOPOMOFO_LETTER_UNN";
        case   0x31AC: return "BOPOMOFO_LETTER_IM";
        case   0x31AD: return "BOPOMOFO_LETTER_NGG";
        case   0x31AE: return "BOPOMOFO_LETTER_AINN";
        case   0x31AF: return "BOPOMOFO_LETTER_AUNN";
        case   0x31B0: return "BOPOMOFO_LETTER_AM";
        case   0x31B1: return "BOPOMOFO_LETTER_OM";
        case   0x31B2: return "BOPOMOFO_LETTER_ONG";
        case   0x31B3: return "BOPOMOFO_LETTER_INNN";
        case   0x31B4: return "BOPOMOFO_FINAL_LETTER_P";
        case   0x31B5: return "BOPOMOFO_FINAL_LETTER_T";
        case   0x31B6: return "BOPOMOFO_FINAL_LETTER_K";
        case   0x31B7: return "BOPOMOFO_FINAL_LETTER_H";
        case   0x31B8: return "BOPOMOFO_LETTER_GH";
        case   0x31B9: return "BOPOMOFO_LETTER_LH";
        case   0x31BA: return "BOPOMOFO_LETTER_ZY";
        case   0x31C0: return "CJK_STROKE_T";
        case   0x31C1: return "CJK_STROKE_WG";
        case   0x31C2: return "CJK_STROKE_XG";
        case   0x31C3: return "CJK_STROKE_BXG";
        case   0x31C4: return "CJK_STROKE_SW";
        case   0x31C5: return "CJK_STROKE_HZZ";
        case   0x31C6: return "CJK_STROKE_HZG";
        case   0x31C7: return "CJK_STROKE_HP";
        case   0x31C8: return "CJK_STROKE_HZWG";
        case   0x31C9: return "CJK_STROKE_SZWG";
        case   0x31CA: return "CJK_STROKE_HZT";
        case   0x31CB: return "CJK_STROKE_HZZP";
        case   0x31CC: return "CJK_STROKE_HPWG";
        case   0x31CD: return "CJK_STROKE_HZW";
        case   0x31CE: return "CJK_STROKE_HZZZ";
        case   0x31CF: return "CJK_STROKE_N";
        case   0x31D0: return "CJK_STROKE_H";
        case   0x31D1: return "CJK_STROKE_S";
        case   0x31D2: return "CJK_STROKE_P";
        case   0x31D3: return "CJK_STROKE_SP";
        case   0x31D4: return "CJK_STROKE_D";
        case   0x31D5: return "CJK_STROKE_HZ";
        case   0x31D6: return "CJK_STROKE_HG";
        case   0x31D7: return "CJK_STROKE_SZ";
        case   0x31D8: return "CJK_STROKE_SWZ";
        case   0x31D9: return "CJK_STROKE_ST";
        case   0x31DA: return "CJK_STROKE_SG";
        case   0x31DB: return "CJK_STROKE_PD";
        case   0x31DC: return "CJK_STROKE_PZ";
        case   0x31DD: return "CJK_STROKE_TN";
        case   0x31DE: return "CJK_STROKE_SZZ";
        case   0x31DF: return "CJK_STROKE_SWG";
        case   0x31E0: return "CJK_STROKE_HXWG";
        case   0x31E1: return "CJK_STROKE_HZZZG";
        case   0x31E2: return "CJK_STROKE_PG";
        case   0x31E3: return "CJK_STROKE_Q";
        case   0x31F0: return "KATAKANA_LETTER_SMALL_KU";
        case   0x31F1: return "KATAKANA_LETTER_SMALL_SI";
        case   0x31F2: return "KATAKANA_LETTER_SMALL_SU";
        case   0x31F3: return "KATAKANA_LETTER_SMALL_TO";
        case   0x31F4: return "KATAKANA_LETTER_SMALL_NU";
        case   0x31F5: return "KATAKANA_LETTER_SMALL_HA";
        case   0x31F6: return "KATAKANA_LETTER_SMALL_HI";
        case   0x31F7: return "KATAKANA_LETTER_SMALL_HU";
        case   0x31F8: return "KATAKANA_LETTER_SMALL_HE";
        case   0x31F9: return "KATAKANA_LETTER_SMALL_HO";
        case   0x31FA: return "KATAKANA_LETTER_SMALL_MU";
        case   0x31FB: return "KATAKANA_LETTER_SMALL_RA";
        case   0x31FC: return "KATAKANA_LETTER_SMALL_RI";
        case   0x31FD: return "KATAKANA_LETTER_SMALL_RU";
        case   0x31FE: return "KATAKANA_LETTER_SMALL_RE";
        case   0x31FF: return "KATAKANA_LETTER_SMALL_RO";
        case   0x3200: return "PARENTHESIZED_HANGUL_KIYEOK";
        case   0x3201: return "PARENTHESIZED_HANGUL_NIEUN";
        case   0x3202: return "PARENTHESIZED_HANGUL_TIKEUT";
        case   0x3203: return "PARENTHESIZED_HANGUL_RIEUL";
        case   0x3204: return "PARENTHESIZED_HANGUL_MIEUM";
        case   0x3205: return "PARENTHESIZED_HANGUL_PIEUP";
        case   0x3206: return "PARENTHESIZED_HANGUL_SIOS";
        case   0x3207: return "PARENTHESIZED_HANGUL_IEUNG";
        case   0x3208: return "PARENTHESIZED_HANGUL_CIEUC";
        case   0x3209: return "PARENTHESIZED_HANGUL_CHIEUCH";
        case   0x320A: return "PARENTHESIZED_HANGUL_KHIEUKH";
        case   0x320B: return "PARENTHESIZED_HANGUL_THIEUTH";
        case   0x320C: return "PARENTHESIZED_HANGUL_PHIEUPH";
        case   0x320D: return "PARENTHESIZED_HANGUL_HIEUH";
        case   0x320E: return "PARENTHESIZED_HANGUL_KIYEOK_A";
        case   0x320F: return "PARENTHESIZED_HANGUL_NIEUN_A";
        case   0x3210: return "PARENTHESIZED_HANGUL_TIKEUT_A";
        case   0x3211: return "PARENTHESIZED_HANGUL_RIEUL_A";
        case   0x3212: return "PARENTHESIZED_HANGUL_MIEUM_A";
        case   0x3213: return "PARENTHESIZED_HANGUL_PIEUP_A";
        case   0x3214: return "PARENTHESIZED_HANGUL_SIOS_A";
        case   0x3215: return "PARENTHESIZED_HANGUL_IEUNG_A";
        case   0x3216: return "PARENTHESIZED_HANGUL_CIEUC_A";
        case   0x3217: return "PARENTHESIZED_HANGUL_CHIEUCH_A";
        case   0x3218: return "PARENTHESIZED_HANGUL_KHIEUKH_A";
        case   0x3219: return "PARENTHESIZED_HANGUL_THIEUTH_A";
        case   0x321A: return "PARENTHESIZED_HANGUL_PHIEUPH_A";
        case   0x321B: return "PARENTHESIZED_HANGUL_HIEUH_A";
        case   0x321C: return "PARENTHESIZED_HANGUL_CIEUC_U";
        case   0x321D: return "PARENTHESIZED_KOREAN_CHARACTER_OJEON";
        case   0x321E: return "PARENTHESIZED_KOREAN_CHARACTER_O_HU";
        case   0x3220: return "PARENTHESIZED_IDEOGRAPH_ONE";
        case   0x3221: return "PARENTHESIZED_IDEOGRAPH_TWO";
        case   0x3222: return "PARENTHESIZED_IDEOGRAPH_THREE";
        case   0x3223: return "PARENTHESIZED_IDEOGRAPH_FOUR";
        case   0x3224: return "PARENTHESIZED_IDEOGRAPH_FIVE";
        case   0x3225: return "PARENTHESIZED_IDEOGRAPH_SIX";
        case   0x3226: return "PARENTHESIZED_IDEOGRAPH_SEVEN";
        case   0x3227: return "PARENTHESIZED_IDEOGRAPH_EIGHT";
        case   0x3228: return "PARENTHESIZED_IDEOGRAPH_NINE";
        case   0x3229: return "PARENTHESIZED_IDEOGRAPH_TEN";
        case   0x322A: return "PARENTHESIZED_IDEOGRAPH_MOON";
        case   0x322B: return "PARENTHESIZED_IDEOGRAPH_FIRE";
        case   0x322C: return "PARENTHESIZED_IDEOGRAPH_WATER";
        case   0x322D: return "PARENTHESIZED_IDEOGRAPH_WOOD";
        case   0x322E: return "PARENTHESIZED_IDEOGRAPH_METAL";
        case   0x322F: return "PARENTHESIZED_IDEOGRAPH_EARTH";
        case   0x3230: return "PARENTHESIZED_IDEOGRAPH_SUN";
        case   0x3231: return "PARENTHESIZED_IDEOGRAPH_STOCK";
        case   0x3232: return "PARENTHESIZED_IDEOGRAPH_HAVE";
        case   0x3233: return "PARENTHESIZED_IDEOGRAPH_SOCIETY";
        case   0x3234: return "PARENTHESIZED_IDEOGRAPH_NAME";
        case   0x3235: return "PARENTHESIZED_IDEOGRAPH_SPECIAL";
        case   0x3236: return "PARENTHESIZED_IDEOGRAPH_FINANCIAL";
        case   0x3237: return "PARENTHESIZED_IDEOGRAPH_CONGRATULATION";
        case   0x3238: return "PARENTHESIZED_IDEOGRAPH_LABOR";
        case   0x3239: return "PARENTHESIZED_IDEOGRAPH_REPRESENT";
        case   0x323A: return "PARENTHESIZED_IDEOGRAPH_CALL";
        case   0x323B: return "PARENTHESIZED_IDEOGRAPH_STUDY";
        case   0x323C: return "PARENTHESIZED_IDEOGRAPH_SUPERVISE";
        case   0x323D: return "PARENTHESIZED_IDEOGRAPH_ENTERPRISE";
        case   0x323E: return "PARENTHESIZED_IDEOGRAPH_RESOURCE";
        case   0x323F: return "PARENTHESIZED_IDEOGRAPH_ALLIANCE";
        case   0x3240: return "PARENTHESIZED_IDEOGRAPH_FESTIVAL";
        case   0x3241: return "PARENTHESIZED_IDEOGRAPH_REST";
        case   0x3242: return "PARENTHESIZED_IDEOGRAPH_SELF";
        case   0x3243: return "PARENTHESIZED_IDEOGRAPH_REACH";
        case   0x3244: return "CIRCLED_IDEOGRAPH_QUESTION";
        case   0x3245: return "CIRCLED_IDEOGRAPH_KINDERGARTEN";
        case   0x3246: return "CIRCLED_IDEOGRAPH_SCHOOL";
        case   0x3247: return "CIRCLED_IDEOGRAPH_KOTO";
        case   0x3248: return "CIRCLED_NUMBER_TEN_ON_BLACK_SQUARE";
        case   0x3249: return "CIRCLED_NUMBER_TWENTY_ON_BLACK_SQUARE";
        case   0x324A: return "CIRCLED_NUMBER_THIRTY_ON_BLACK_SQUARE";
        case   0x324B: return "CIRCLED_NUMBER_FORTY_ON_BLACK_SQUARE";
        case   0x324C: return "CIRCLED_NUMBER_FIFTY_ON_BLACK_SQUARE";
        case   0x324D: return "CIRCLED_NUMBER_SIXTY_ON_BLACK_SQUARE";
        case   0x324E: return "CIRCLED_NUMBER_SEVENTY_ON_BLACK_SQUARE";
        case   0x324F: return "CIRCLED_NUMBER_EIGHTY_ON_BLACK_SQUARE";
        case   0x3250: return "PARTNERSHIP_SIGN";
        case   0x3251: return "CIRCLED_NUMBER_TWENTY_ONE";
        case   0x3252: return "CIRCLED_NUMBER_TWENTY_TWO";
        case   0x3253: return "CIRCLED_NUMBER_TWENTY_THREE";
        case   0x3254: return "CIRCLED_NUMBER_TWENTY_FOUR";
        case   0x3255: return "CIRCLED_NUMBER_TWENTY_FIVE";
        case   0x3256: return "CIRCLED_NUMBER_TWENTY_SIX";
        case   0x3257: return "CIRCLED_NUMBER_TWENTY_SEVEN";
        case   0x3258: return "CIRCLED_NUMBER_TWENTY_EIGHT";
        case   0x3259: return "CIRCLED_NUMBER_TWENTY_NINE";
        case   0x325A: return "CIRCLED_NUMBER_THIRTY";
        case   0x325B: return "CIRCLED_NUMBER_THIRTY_ONE";
        case   0x325C: return "CIRCLED_NUMBER_THIRTY_TWO";
        case   0x325D: return "CIRCLED_NUMBER_THIRTY_THREE";
        case   0x325E: return "CIRCLED_NUMBER_THIRTY_FOUR";
        case   0x325F: return "CIRCLED_NUMBER_THIRTY_FIVE";
        case   0x3260: return "CIRCLED_HANGUL_KIYEOK";
        case   0x3261: return "CIRCLED_HANGUL_NIEUN";
        case   0x3262: return "CIRCLED_HANGUL_TIKEUT";
        case   0x3263: return "CIRCLED_HANGUL_RIEUL";
        case   0x3264: return "CIRCLED_HANGUL_MIEUM";
        case   0x3265: return "CIRCLED_HANGUL_PIEUP";
        case   0x3266: return "CIRCLED_HANGUL_SIOS";
        case   0x3267: return "CIRCLED_HANGUL_IEUNG";
        case   0x3268: return "CIRCLED_HANGUL_CIEUC";
        case   0x3269: return "CIRCLED_HANGUL_CHIEUCH";
        case   0x326A: return "CIRCLED_HANGUL_KHIEUKH";
        case   0x326B: return "CIRCLED_HANGUL_THIEUTH";
        case   0x326C: return "CIRCLED_HANGUL_PHIEUPH";
        case   0x326D: return "CIRCLED_HANGUL_HIEUH";
        case   0x326E: return "CIRCLED_HANGUL_KIYEOK_A";
        case   0x326F: return "CIRCLED_HANGUL_NIEUN_A";
        case   0x3270: return "CIRCLED_HANGUL_TIKEUT_A";
        case   0x3271: return "CIRCLED_HANGUL_RIEUL_A";
        case   0x3272: return "CIRCLED_HANGUL_MIEUM_A";
        case   0x3273: return "CIRCLED_HANGUL_PIEUP_A";
        case   0x3274: return "CIRCLED_HANGUL_SIOS_A";
        case   0x3275: return "CIRCLED_HANGUL_IEUNG_A";
        case   0x3276: return "CIRCLED_HANGUL_CIEUC_A";
        case   0x3277: return "CIRCLED_HANGUL_CHIEUCH_A";
        case   0x3278: return "CIRCLED_HANGUL_KHIEUKH_A";
        case   0x3279: return "CIRCLED_HANGUL_THIEUTH_A";
        case   0x327A: return "CIRCLED_HANGUL_PHIEUPH_A";
        case   0x327B: return "CIRCLED_HANGUL_HIEUH_A";
        case   0x327C: return "CIRCLED_KOREAN_CHARACTER_CHAMKO";
        case   0x327D: return "CIRCLED_KOREAN_CHARACTER_JUEUI";
        case   0x327E: return "CIRCLED_HANGUL_IEUNG_U";
        case   0x327F: return "KOREAN_STANDARD_SYMBOL";
        case   0x3280: return "CIRCLED_IDEOGRAPH_ONE";
        case   0x3281: return "CIRCLED_IDEOGRAPH_TWO";
        case   0x3282: return "CIRCLED_IDEOGRAPH_THREE";
        case   0x3283: return "CIRCLED_IDEOGRAPH_FOUR";
        case   0x3284: return "CIRCLED_IDEOGRAPH_FIVE";
        case   0x3285: return "CIRCLED_IDEOGRAPH_SIX";
        case   0x3286: return "CIRCLED_IDEOGRAPH_SEVEN";
        case   0x3287: return "CIRCLED_IDEOGRAPH_EIGHT";
        case   0x3288: return "CIRCLED_IDEOGRAPH_NINE";
        case   0x3289: return "CIRCLED_IDEOGRAPH_TEN";
        case   0x328A: return "CIRCLED_IDEOGRAPH_MOON";
        case   0x328B: return "CIRCLED_IDEOGRAPH_FIRE";
        case   0x328C: return "CIRCLED_IDEOGRAPH_WATER";
        case   0x328D: return "CIRCLED_IDEOGRAPH_WOOD";
        case   0x328E: return "CIRCLED_IDEOGRAPH_METAL";
        case   0x328F: return "CIRCLED_IDEOGRAPH_EARTH";
        case   0x3290: return "CIRCLED_IDEOGRAPH_SUN";
        case   0x3291: return "CIRCLED_IDEOGRAPH_STOCK";
        case   0x3292: return "CIRCLED_IDEOGRAPH_HAVE";
        case   0x3293: return "CIRCLED_IDEOGRAPH_SOCIETY";
        case   0x3294: return "CIRCLED_IDEOGRAPH_NAME";
        case   0x3295: return "CIRCLED_IDEOGRAPH_SPECIAL";
        case   0x3296: return "CIRCLED_IDEOGRAPH_FINANCIAL";
        case   0x3297: return "CIRCLED_IDEOGRAPH_CONGRATULATION";
        case   0x3298: return "CIRCLED_IDEOGRAPH_LABOR";
        case   0x3299: return "CIRCLED_IDEOGRAPH_SECRET";
        case   0x329A: return "CIRCLED_IDEOGRAPH_MALE";
        case   0x329B: return "CIRCLED_IDEOGRAPH_FEMALE";
        case   0x329C: return "CIRCLED_IDEOGRAPH_SUITABLE";
        case   0x329D: return "CIRCLED_IDEOGRAPH_EXCELLENT";
        case   0x329E: return "CIRCLED_IDEOGRAPH_PRINT";
        case   0x329F: return "CIRCLED_IDEOGRAPH_ATTENTION";
        case   0x32A0: return "CIRCLED_IDEOGRAPH_ITEM";
        case   0x32A1: return "CIRCLED_IDEOGRAPH_REST";
        case   0x32A2: return "CIRCLED_IDEOGRAPH_COPY";
        case   0x32A3: return "CIRCLED_IDEOGRAPH_CORRECT";
        case   0x32A4: return "CIRCLED_IDEOGRAPH_HIGH";
        case   0x32A5: return "CIRCLED_IDEOGRAPH_CENTRE";
        case   0x32A6: return "CIRCLED_IDEOGRAPH_LOW";
        case   0x32A7: return "CIRCLED_IDEOGRAPH_LEFT";
        case   0x32A8: return "CIRCLED_IDEOGRAPH_RIGHT";
        case   0x32A9: return "CIRCLED_IDEOGRAPH_MEDICINE";
        case   0x32AA: return "CIRCLED_IDEOGRAPH_RELIGION";
        case   0x32AB: return "CIRCLED_IDEOGRAPH_STUDY";
        case   0x32AC: return "CIRCLED_IDEOGRAPH_SUPERVISE";
        case   0x32AD: return "CIRCLED_IDEOGRAPH_ENTERPRISE";
        case   0x32AE: return "CIRCLED_IDEOGRAPH_RESOURCE";
        case   0x32AF: return "CIRCLED_IDEOGRAPH_ALLIANCE";
        case   0x32B0: return "CIRCLED_IDEOGRAPH_NIGHT";
        case   0x32B1: return "CIRCLED_NUMBER_THIRTY_SIX";
        case   0x32B2: return "CIRCLED_NUMBER_THIRTY_SEVEN";
        case   0x32B3: return "CIRCLED_NUMBER_THIRTY_EIGHT";
        case   0x32B4: return "CIRCLED_NUMBER_THIRTY_NINE";
        case   0x32B5: return "CIRCLED_NUMBER_FORTY";
        case   0x32B6: return "CIRCLED_NUMBER_FORTY_ONE";
        case   0x32B7: return "CIRCLED_NUMBER_FORTY_TWO";
        case   0x32B8: return "CIRCLED_NUMBER_FORTY_THREE";
        case   0x32B9: return "CIRCLED_NUMBER_FORTY_FOUR";
        case   0x32BA: return "CIRCLED_NUMBER_FORTY_FIVE";
        case   0x32BB: return "CIRCLED_NUMBER_FORTY_SIX";
        case   0x32BC: return "CIRCLED_NUMBER_FORTY_SEVEN";
        case   0x32BD: return "CIRCLED_NUMBER_FORTY_EIGHT";
        case   0x32BE: return "CIRCLED_NUMBER_FORTY_NINE";
        case   0x32BF: return "CIRCLED_NUMBER_FIFTY";
        case   0x32C0: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_JANUARY";
        case   0x32C1: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_FEBRUARY";
        case   0x32C2: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_MARCH";
        case   0x32C3: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_APRIL";
        case   0x32C4: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_MAY";
        case   0x32C5: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_JUNE";
        case   0x32C6: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_JULY";
        case   0x32C7: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_AUGUST";
        case   0x32C8: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_SEPTEMBER";
        case   0x32C9: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_OCTOBER";
        case   0x32CA: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_NOVEMBER";
        case   0x32CB: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DECEMBER";
        case   0x32CC: return "SQUARE_HG";
        case   0x32CD: return "SQUARE_ERG";
        case   0x32CE: return "SQUARE_EV";
        case   0x32CF: return "LIMITED_LIABILITY_SIGN";
        case   0x32D0: return "CIRCLED_KATAKANA_A";
        case   0x32D1: return "CIRCLED_KATAKANA_I";
        case   0x32D2: return "CIRCLED_KATAKANA_U";
        case   0x32D3: return "CIRCLED_KATAKANA_E";
        case   0x32D4: return "CIRCLED_KATAKANA_O";
        case   0x32D5: return "CIRCLED_KATAKANA_KA";
        case   0x32D6: return "CIRCLED_KATAKANA_KI";
        case   0x32D7: return "CIRCLED_KATAKANA_KU";
        case   0x32D8: return "CIRCLED_KATAKANA_KE";
        case   0x32D9: return "CIRCLED_KATAKANA_KO";
        case   0x32DA: return "CIRCLED_KATAKANA_SA";
        case   0x32DB: return "CIRCLED_KATAKANA_SI";
        case   0x32DC: return "CIRCLED_KATAKANA_SU";
        case   0x32DD: return "CIRCLED_KATAKANA_SE";
        case   0x32DE: return "CIRCLED_KATAKANA_SO";
        case   0x32DF: return "CIRCLED_KATAKANA_TA";
        case   0x32E0: return "CIRCLED_KATAKANA_TI";
        case   0x32E1: return "CIRCLED_KATAKANA_TU";
        case   0x32E2: return "CIRCLED_KATAKANA_TE";
        case   0x32E3: return "CIRCLED_KATAKANA_TO";
        case   0x32E4: return "CIRCLED_KATAKANA_NA";
        case   0x32E5: return "CIRCLED_KATAKANA_NI";
        case   0x32E6: return "CIRCLED_KATAKANA_NU";
        case   0x32E7: return "CIRCLED_KATAKANA_NE";
        case   0x32E8: return "CIRCLED_KATAKANA_NO";
        case   0x32E9: return "CIRCLED_KATAKANA_HA";
        case   0x32EA: return "CIRCLED_KATAKANA_HI";
        case   0x32EB: return "CIRCLED_KATAKANA_HU";
        case   0x32EC: return "CIRCLED_KATAKANA_HE";
        case   0x32ED: return "CIRCLED_KATAKANA_HO";
        case   0x32EE: return "CIRCLED_KATAKANA_MA";
        case   0x32EF: return "CIRCLED_KATAKANA_MI";
        case   0x32F0: return "CIRCLED_KATAKANA_MU";
        case   0x32F1: return "CIRCLED_KATAKANA_ME";
        case   0x32F2: return "CIRCLED_KATAKANA_MO";
        case   0x32F3: return "CIRCLED_KATAKANA_YA";
        case   0x32F4: return "CIRCLED_KATAKANA_YU";
        case   0x32F5: return "CIRCLED_KATAKANA_YO";
        case   0x32F6: return "CIRCLED_KATAKANA_RA";
        case   0x32F7: return "CIRCLED_KATAKANA_RI";
        case   0x32F8: return "CIRCLED_KATAKANA_RU";
        case   0x32F9: return "CIRCLED_KATAKANA_RE";
        case   0x32FA: return "CIRCLED_KATAKANA_RO";
        case   0x32FB: return "CIRCLED_KATAKANA_WA";
        case   0x32FC: return "CIRCLED_KATAKANA_WI";
        case   0x32FD: return "CIRCLED_KATAKANA_WE";
        case   0x32FE: return "CIRCLED_KATAKANA_WO";
        case   0x3300: return "SQUARE_APAATO";
        case   0x3301: return "SQUARE_ARUHUA";
        case   0x3302: return "SQUARE_ANPEA";
        case   0x3303: return "SQUARE_AARU";
        case   0x3304: return "SQUARE_ININGU";
        case   0x3305: return "SQUARE_INTI";
        case   0x3306: return "SQUARE_UON";
        case   0x3307: return "SQUARE_ESUKUUDO";
        case   0x3308: return "SQUARE_EEKAA";
        case   0x3309: return "SQUARE_ONSU";
        case   0x330A: return "SQUARE_OOMU";
        case   0x330B: return "SQUARE_KAIRI";
        case   0x330C: return "SQUARE_KARATTO";
        case   0x330D: return "SQUARE_KARORII";
        case   0x330E: return "SQUARE_GARON";
        case   0x330F: return "SQUARE_GANMA";
        case   0x3310: return "SQUARE_GIGA";
        case   0x3311: return "SQUARE_GINII";
        case   0x3312: return "SQUARE_KYURII";
        case   0x3313: return "SQUARE_GIRUDAA";
        case   0x3314: return "SQUARE_KIRO";
        case   0x3315: return "SQUARE_KIROGURAMU";
        case   0x3316: return "SQUARE_KIROMEETORU";
        case   0x3317: return "SQUARE_KIROWATTO";
        case   0x3318: return "SQUARE_GURAMU";
        case   0x3319: return "SQUARE_GURAMUTON";
        case   0x331A: return "SQUARE_KURUZEIRO";
        case   0x331B: return "SQUARE_KUROONE";
        case   0x331C: return "SQUARE_KEESU";
        case   0x331D: return "SQUARE_KORUNA";
        case   0x331E: return "SQUARE_KOOPO";
        case   0x331F: return "SQUARE_SAIKURU";
        case   0x3320: return "SQUARE_SANTIIMU";
        case   0x3321: return "SQUARE_SIRINGU";
        case   0x3322: return "SQUARE_SENTI";
        case   0x3323: return "SQUARE_SENTO";
        case   0x3324: return "SQUARE_DAASU";
        case   0x3325: return "SQUARE_DESI";
        case   0x3326: return "SQUARE_DORU";
        case   0x3327: return "SQUARE_TON";
        case   0x3328: return "SQUARE_NANO";
        case   0x3329: return "SQUARE_NOTTO";
        case   0x332A: return "SQUARE_HAITU";
        case   0x332B: return "SQUARE_PAASENTO";
        case   0x332C: return "SQUARE_PAATU";
        case   0x332D: return "SQUARE_BAARERU";
        case   0x332E: return "SQUARE_PIASUTORU";
        case   0x332F: return "SQUARE_PIKURU";
        case   0x3330: return "SQUARE_PIKO";
        case   0x3331: return "SQUARE_BIRU";
        case   0x3332: return "SQUARE_HUARADDO";
        case   0x3333: return "SQUARE_HUIITO";
        case   0x3334: return "SQUARE_BUSSYERU";
        case   0x3335: return "SQUARE_HURAN";
        case   0x3336: return "SQUARE_HEKUTAARU";
        case   0x3337: return "SQUARE_PESO";
        case   0x3338: return "SQUARE_PENIHI";
        case   0x3339: return "SQUARE_HERUTU";
        case   0x333A: return "SQUARE_PENSU";
        case   0x333B: return "SQUARE_PEEZI";
        case   0x333C: return "SQUARE_BEETA";
        case   0x333D: return "SQUARE_POINTO";
        case   0x333E: return "SQUARE_BORUTO";
        case   0x333F: return "SQUARE_HON";
        case   0x3340: return "SQUARE_PONDO";
        case   0x3341: return "SQUARE_HOORU";
        case   0x3342: return "SQUARE_HOON";
        case   0x3343: return "SQUARE_MAIKURO";
        case   0x3344: return "SQUARE_MAIRU";
        case   0x3345: return "SQUARE_MAHHA";
        case   0x3346: return "SQUARE_MARUKU";
        case   0x3347: return "SQUARE_MANSYON";
        case   0x3348: return "SQUARE_MIKURON";
        case   0x3349: return "SQUARE_MIRI";
        case   0x334A: return "SQUARE_MIRIBAARU";
        case   0x334B: return "SQUARE_MEGA";
        case   0x334C: return "SQUARE_MEGATON";
        case   0x334D: return "SQUARE_MEETORU";
        case   0x334E: return "SQUARE_YAADO";
        case   0x334F: return "SQUARE_YAARU";
        case   0x3350: return "SQUARE_YUAN";
        case   0x3351: return "SQUARE_RITTORU";
        case   0x3352: return "SQUARE_RIRA";
        case   0x3353: return "SQUARE_RUPII";
        case   0x3354: return "SQUARE_RUUBURU";
        case   0x3355: return "SQUARE_REMU";
        case   0x3356: return "SQUARE_RENTOGEN";
        case   0x3357: return "SQUARE_WATTO";
        case   0x3358: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_ZERO";
        case   0x3359: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_ONE";
        case   0x335A: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_TWO";
        case   0x335B: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_THREE";
        case   0x335C: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_FOUR";
        case   0x335D: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_FIVE";
        case   0x335E: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_SIX";
        case   0x335F: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_SEVEN";
        case   0x3360: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_EIGHT";
        case   0x3361: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_NINE";
        case   0x3362: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_TEN";
        case   0x3363: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_ELEVEN";
        case   0x3364: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_TWELVE";
        case   0x3365: return
                "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_THIRTEEN";
        case   0x3366: return
                "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_FOURTEEN";
        case   0x3367: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_FIFTEEN";
        case   0x3368: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_SIXTEEN";
        case   0x3369: return
                "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_SEVENTEEN";
        case   0x336A: return
                "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_EIGHTEEN";
        case   0x336B: return
                "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_NINETEEN";
        case   0x336C: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_TWENTY";
        case   0x336D: return
                "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_TWENTY_ONE";
        case   0x336E: return
                "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_TWENTY_TWO";
        case   0x336F: return
                "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_TWENTY_THREE";
        case   0x3370: return
                "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_HOUR_TWENTY_FOUR";
        case   0x3371: return "SQUARE_HPA";
        case   0x3372: return "SQUARE_DA";
        case   0x3373: return "SQUARE_AU";
        case   0x3374: return "SQUARE_BAR";
        case   0x3375: return "SQUARE_OV";
        case   0x3376: return "SQUARE_PC";
        case   0x3377: return "SQUARE_DM";
        case   0x3378: return "SQUARE_DM_SQUARED";
        case   0x3379: return "SQUARE_DM_CUBED";
        case   0x337A: return "SQUARE_IU";
        case   0x337B: return "SQUARE_ERA_NAME_HEISEI";
        case   0x337C: return "SQUARE_ERA_NAME_SYOUWA";
        case   0x337D: return "SQUARE_ERA_NAME_TAISYOU";
        case   0x337E: return "SQUARE_ERA_NAME_MEIZI";
        case   0x337F: return "SQUARE_CORPORATION";
        case   0x3380: return "SQUARE_PA_AMPS";
        case   0x3381: return "SQUARE_NA";
        case   0x3382: return "SQUARE_MU_A";
        case   0x3383: return "SQUARE_MA";
        case   0x3384: return "SQUARE_KA";
        case   0x3385: return "SQUARE_KB";
        case   0x3386: return "SQUARE_MB";
        case   0x3387: return "SQUARE_GB";
        case   0x3388: return "SQUARE_CAL";
        case   0x3389: return "SQUARE_KCAL";
        case   0x338A: return "SQUARE_PF";
        case   0x338B: return "SQUARE_NF";
        case   0x338C: return "SQUARE_MU_F";
        case   0x338D: return "SQUARE_MU_G";
        case   0x338E: return "SQUARE_MG";
        case   0x338F: return "SQUARE_KG";
        case   0x3390: return "SQUARE_HZ";
        case   0x3391: return "SQUARE_KHZ";
        case   0x3392: return "SQUARE_MHZ";
        case   0x3393: return "SQUARE_GHZ";
        case   0x3394: return "SQUARE_THZ";
        case   0x3395: return "SQUARE_MU_L";
        case   0x3396: return "SQUARE_ML";
        case   0x3397: return "SQUARE_DL";
        case   0x3398: return "SQUARE_KL";
        case   0x3399: return "SQUARE_FM";
        case   0x339A: return "SQUARE_NM";
        case   0x339B: return "SQUARE_MU_M";
        case   0x339C: return "SQUARE_MM";
        case   0x339D: return "SQUARE_CM";
        case   0x339E: return "SQUARE_KM";
        case   0x339F: return "SQUARE_MM_SQUARED";
        case   0x33A0: return "SQUARE_CM_SQUARED";
        case   0x33A1: return "SQUARE_M_SQUARED";
        case   0x33A2: return "SQUARE_KM_SQUARED";
        case   0x33A3: return "SQUARE_MM_CUBED";
        case   0x33A4: return "SQUARE_CM_CUBED";
        case   0x33A5: return "SQUARE_M_CUBED";
        case   0x33A6: return "SQUARE_KM_CUBED";
        case   0x33A7: return "SQUARE_M_OVER_S";
        case   0x33A8: return "SQUARE_M_OVER_S_SQUARED";
        case   0x33A9: return "SQUARE_PA";
        case   0x33AA: return "SQUARE_KPA";
        case   0x33AB: return "SQUARE_MPA";
        case   0x33AC: return "SQUARE_GPA";
        case   0x33AD: return "SQUARE_RAD";
        case   0x33AE: return "SQUARE_RAD_OVER_S";
        case   0x33AF: return "SQUARE_RAD_OVER_S_SQUARED";
        case   0x33B0: return "SQUARE_PS";
        case   0x33B1: return "SQUARE_NS";
        case   0x33B2: return "SQUARE_MU_S";
        case   0x33B3: return "SQUARE_MS";
        case   0x33B4: return "SQUARE_PV";
        case   0x33B5: return "SQUARE_NV";
        case   0x33B6: return "SQUARE_MU_V";
        case   0x33B7: return "SQUARE_MV";
        case   0x33B8: return "SQUARE_KV";
        case   0x33B9: return "SQUARE_MV_MEGA";
        case   0x33BA: return "SQUARE_PW";
        case   0x33BB: return "SQUARE_NW";
        case   0x33BC: return "SQUARE_MU_W";
        case   0x33BD: return "SQUARE_MW";
        case   0x33BE: return "SQUARE_KW";
        case   0x33BF: return "SQUARE_MW_MEGA";
        case   0x33C0: return "SQUARE_K_OHM";
        case   0x33C1: return "SQUARE_M_OHM";
        case   0x33C2: return "SQUARE_AM";
        case   0x33C3: return "SQUARE_BQ";
        case   0x33C4: return "SQUARE_CC";
        case   0x33C5: return "SQUARE_CD";
        case   0x33C6: return "SQUARE_C_OVER_KG";
        case   0x33C7: return "SQUARE_CO";
        case   0x33C8: return "SQUARE_DB";
        case   0x33C9: return "SQUARE_GY";
        case   0x33CA: return "SQUARE_HA";
        case   0x33CB: return "SQUARE_HP";
        case   0x33CC: return "SQUARE_IN";
        case   0x33CD: return "SQUARE_KK";
        case   0x33CE: return "SQUARE_KM_CAPITAL";
        case   0x33CF: return "SQUARE_KT";
        case   0x33D0: return "SQUARE_LM";
        case   0x33D1: return "SQUARE_LN";
        case   0x33D2: return "SQUARE_LOG";
        case   0x33D3: return "SQUARE_LX";
        case   0x33D4: return "SQUARE_MB_SMALL";
        case   0x33D5: return "SQUARE_MIL";
        case   0x33D6: return "SQUARE_MOL";
        case   0x33D7: return "SQUARE_PH";
        case   0x33D8: return "SQUARE_PM";
        case   0x33D9: return "SQUARE_PPM";
        case   0x33DA: return "SQUARE_PR";
        case   0x33DB: return "SQUARE_SR";
        case   0x33DC: return "SQUARE_SV";
        case   0x33DD: return "SQUARE_WB";
        case   0x33DE: return "SQUARE_V_OVER_M";
        case   0x33DF: return "SQUARE_A_OVER_M";
        case   0x33E0: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_ONE";
        case   0x33E1: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWO";
        case   0x33E2: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_THREE";
        case   0x33E3: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_FOUR";
        case   0x33E4: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_FIVE";
        case   0x33E5: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_SIX";
        case   0x33E6: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_SEVEN";
        case   0x33E7: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_EIGHT";
        case   0x33E8: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_NINE";
        case   0x33E9: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TEN";
        case   0x33EA: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_ELEVEN";
        case   0x33EB: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWELVE";
        case   0x33EC: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_THIRTEEN";
        case   0x33ED: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_FOURTEEN";
        case   0x33EE: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_FIFTEEN";
        case   0x33EF: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_SIXTEEN";
        case   0x33F0: return
                "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_SEVENTEEN";
        case   0x33F1: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_EIGHTEEN";
        case   0x33F2: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_NINETEEN";
        case   0x33F3: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWENTY";
        case   0x33F4: return
                "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWENTY_ONE";
        case   0x33F5: return
                "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWENTY_TWO";
        case   0x33F6: return
                "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWENTY_THREE";
        case   0x33F7: return
                "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWENTY_FOUR";
        case   0x33F8: return
                "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWENTY_FIVE";
        case   0x33F9: return
                "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWENTY_SIX";
        case   0x33FA: return
                "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWENTY_SEVEN";
        case   0x33FB: return
                "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWENTY_EIGHT";
        case   0x33FC: return
                "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_TWENTY_NINE";
        case   0x33FD: return "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_THIRTY";
        case   0x33FE: return
                "IDEOGRAPHIC_TELEGRAPH_SYMBOL_FOR_DAY_THIRTY_ONE";
        case   0x33FF: return "SQUARE_GAL";
        case   0x3400: return "CJK_Ideograph_Extension_A__First";
        case   0x4DB5: return "CJK_Ideograph_Extension_A__Last";
        case   0x4DC0: return "HEXAGRAM_FOR_THE_CREATIVE_HEAVEN";
        case   0x4DC1: return "HEXAGRAM_FOR_THE_RECEPTIVE_EARTH";
        case   0x4DC2: return "HEXAGRAM_FOR_DIFFICULTY_AT_THE_BEGINNING";
        case   0x4DC3: return "HEXAGRAM_FOR_YOUTHFUL_FOLLY";
        case   0x4DC4: return "HEXAGRAM_FOR_WAITING";
        case   0x4DC5: return "HEXAGRAM_FOR_CONFLICT";
        case   0x4DC6: return "HEXAGRAM_FOR_THE_ARMY";
        case   0x4DC7: return "HEXAGRAM_FOR_HOLDING_TOGETHER";
        case   0x4DC8: return "HEXAGRAM_FOR_SMALL_TAMING";
        case   0x4DC9: return "HEXAGRAM_FOR_TREADING";
        case   0x4DCA: return "HEXAGRAM_FOR_PEACE";
        case   0x4DCB: return "HEXAGRAM_FOR_STANDSTILL";
        case   0x4DCC: return "HEXAGRAM_FOR_FELLOWSHIP";
        case   0x4DCD: return "HEXAGRAM_FOR_GREAT_POSSESSION";
        case   0x4DCE: return "HEXAGRAM_FOR_MODESTY";
        case   0x4DCF: return "HEXAGRAM_FOR_ENTHUSIASM";
        case   0x4DD0: return "HEXAGRAM_FOR_FOLLOWING";
        case   0x4DD1: return "HEXAGRAM_FOR_WORK_ON_THE_DECAYED";
        case   0x4DD2: return "HEXAGRAM_FOR_APPROACH";
        case   0x4DD3: return "HEXAGRAM_FOR_CONTEMPLATION";
        case   0x4DD4: return "HEXAGRAM_FOR_BITING_THROUGH";
        case   0x4DD5: return "HEXAGRAM_FOR_GRACE";
        case   0x4DD6: return "HEXAGRAM_FOR_SPLITTING_APART";
        case   0x4DD7: return "HEXAGRAM_FOR_RETURN";
        case   0x4DD8: return "HEXAGRAM_FOR_INNOCENCE";
        case   0x4DD9: return "HEXAGRAM_FOR_GREAT_TAMING";
        case   0x4DDA: return "HEXAGRAM_FOR_MOUTH_CORNERS";
        case   0x4DDB: return "HEXAGRAM_FOR_GREAT_PREPONDERANCE";
        case   0x4DDC: return "HEXAGRAM_FOR_THE_ABYSMAL_WATER";
        case   0x4DDD: return "HEXAGRAM_FOR_THE_CLINGING_FIRE";
        case   0x4DDE: return "HEXAGRAM_FOR_INFLUENCE";
        case   0x4DDF: return "HEXAGRAM_FOR_DURATION";
        case   0x4DE0: return "HEXAGRAM_FOR_RETREAT";
        case   0x4DE1: return "HEXAGRAM_FOR_GREAT_POWER";
        case   0x4DE2: return "HEXAGRAM_FOR_PROGRESS";
        case   0x4DE3: return "HEXAGRAM_FOR_DARKENING_OF_THE_LIGHT";
        case   0x4DE4: return "HEXAGRAM_FOR_THE_FAMILY";
        case   0x4DE5: return "HEXAGRAM_FOR_OPPOSITION";
        case   0x4DE6: return "HEXAGRAM_FOR_OBSTRUCTION";
        case   0x4DE7: return "HEXAGRAM_FOR_DELIVERANCE";
        case   0x4DE8: return "HEXAGRAM_FOR_DECREASE";
        case   0x4DE9: return "HEXAGRAM_FOR_INCREASE";
        case   0x4DEA: return "HEXAGRAM_FOR_BREAKTHROUGH";
        case   0x4DEB: return "HEXAGRAM_FOR_COMING_TO_MEET";
        case   0x4DEC: return "HEXAGRAM_FOR_GATHERING_TOGETHER";
        case   0x4DED: return "HEXAGRAM_FOR_PUSHING_UPWARD";
        case   0x4DEE: return "HEXAGRAM_FOR_OPPRESSION";
        case   0x4DEF: return "HEXAGRAM_FOR_THE_WELL";
        case   0x4DF0: return "HEXAGRAM_FOR_REVOLUTION";
        case   0x4DF1: return "HEXAGRAM_FOR_THE_CAULDRON";
        case   0x4DF2: return "HEXAGRAM_FOR_THE_AROUSING_THUNDER";
        case   0x4DF3: return "HEXAGRAM_FOR_THE_KEEPING_STILL_MOUNTAIN";
        case   0x4DF4: return "HEXAGRAM_FOR_DEVELOPMENT";
        case   0x4DF5: return "HEXAGRAM_FOR_THE_MARRYING_MAIDEN";
        case   0x4DF6: return "HEXAGRAM_FOR_ABUNDANCE";
        case   0x4DF7: return "HEXAGRAM_FOR_THE_WANDERER";
        case   0x4DF8: return "HEXAGRAM_FOR_THE_GENTLE_WIND";
        case   0x4DF9: return "HEXAGRAM_FOR_THE_JOYOUS_LAKE";
        case   0x4DFA: return "HEXAGRAM_FOR_DISPERSION";
        case   0x4DFB: return "HEXAGRAM_FOR_LIMITATION";
        case   0x4DFC: return "HEXAGRAM_FOR_INNER_TRUTH";
        case   0x4DFD: return "HEXAGRAM_FOR_SMALL_PREPONDERANCE";
        case   0x4DFE: return "HEXAGRAM_FOR_AFTER_COMPLETION";
        case   0x4DFF: return "HEXAGRAM_FOR_BEFORE_COMPLETION";
        case   0x4E00: return "CJK_Ideograph__First";
        case   0x9FCC: return "CJK_Ideograph__Last";
        case   0xA000: return "YI_SYLLABLE_IT";
        case   0xA001: return "YI_SYLLABLE_IX";
        case   0xA002: return "YI_SYLLABLE_I";
        case   0xA003: return "YI_SYLLABLE_IP";
        case   0xA004: return "YI_SYLLABLE_IET";
        case   0xA005: return "YI_SYLLABLE_IEX";
        case   0xA006: return "YI_SYLLABLE_IE";
        case   0xA007: return "YI_SYLLABLE_IEP";
        case   0xA008: return "YI_SYLLABLE_AT";
        case   0xA009: return "YI_SYLLABLE_AX";
        case   0xA00A: return "YI_SYLLABLE_A";
        case   0xA00B: return "YI_SYLLABLE_AP";
        case   0xA00C: return "YI_SYLLABLE_UOX";
        case   0xA00D: return "YI_SYLLABLE_UO";
        case   0xA00E: return "YI_SYLLABLE_UOP";
        case   0xA00F: return "YI_SYLLABLE_OT";
        case   0xA010: return "YI_SYLLABLE_OX";
        case   0xA011: return "YI_SYLLABLE_O";
        case   0xA012: return "YI_SYLLABLE_OP";
        case   0xA013: return "YI_SYLLABLE_EX";
        case   0xA014: return "YI_SYLLABLE_E";
        case   0xA015: return "YI_SYLLABLE_WU";
        case   0xA016: return "YI_SYLLABLE_BIT";
        case   0xA017: return "YI_SYLLABLE_BIX";
        case   0xA018: return "YI_SYLLABLE_BI";
        case   0xA019: return "YI_SYLLABLE_BIP";
        case   0xA01A: return "YI_SYLLABLE_BIET";
        case   0xA01B: return "YI_SYLLABLE_BIEX";
        case   0xA01C: return "YI_SYLLABLE_BIE";
        case   0xA01D: return "YI_SYLLABLE_BIEP";
        case   0xA01E: return "YI_SYLLABLE_BAT";
        case   0xA01F: return "YI_SYLLABLE_BAX";
        case   0xA020: return "YI_SYLLABLE_BA";
        case   0xA021: return "YI_SYLLABLE_BAP";
        case   0xA022: return "YI_SYLLABLE_BUOX";
        case   0xA023: return "YI_SYLLABLE_BUO";
        case   0xA024: return "YI_SYLLABLE_BUOP";
        case   0xA025: return "YI_SYLLABLE_BOT";
        case   0xA026: return "YI_SYLLABLE_BOX";
        case   0xA027: return "YI_SYLLABLE_BO";
        case   0xA028: return "YI_SYLLABLE_BOP";
        case   0xA029: return "YI_SYLLABLE_BEX";
        case   0xA02A: return "YI_SYLLABLE_BE";
        case   0xA02B: return "YI_SYLLABLE_BEP";
        case   0xA02C: return "YI_SYLLABLE_BUT";
        case   0xA02D: return "YI_SYLLABLE_BUX";
        case   0xA02E: return "YI_SYLLABLE_BU";
        case   0xA02F: return "YI_SYLLABLE_BUP";
        case   0xA030: return "YI_SYLLABLE_BURX";
        case   0xA031: return "YI_SYLLABLE_BUR";
        case   0xA032: return "YI_SYLLABLE_BYT";
        case   0xA033: return "YI_SYLLABLE_BYX";
        case   0xA034: return "YI_SYLLABLE_BY";
        case   0xA035: return "YI_SYLLABLE_BYP";
        case   0xA036: return "YI_SYLLABLE_BYRX";
        case   0xA037: return "YI_SYLLABLE_BYR";
        case   0xA038: return "YI_SYLLABLE_PIT";
        case   0xA039: return "YI_SYLLABLE_PIX";
        case   0xA03A: return "YI_SYLLABLE_PI";
        case   0xA03B: return "YI_SYLLABLE_PIP";
        case   0xA03C: return "YI_SYLLABLE_PIEX";
        case   0xA03D: return "YI_SYLLABLE_PIE";
        case   0xA03E: return "YI_SYLLABLE_PIEP";
        case   0xA03F: return "YI_SYLLABLE_PAT";
        case   0xA040: return "YI_SYLLABLE_PAX";
        case   0xA041: return "YI_SYLLABLE_PA";
        case   0xA042: return "YI_SYLLABLE_PAP";
        case   0xA043: return "YI_SYLLABLE_PUOX";
        case   0xA044: return "YI_SYLLABLE_PUO";
        case   0xA045: return "YI_SYLLABLE_PUOP";
        case   0xA046: return "YI_SYLLABLE_POT";
        case   0xA047: return "YI_SYLLABLE_POX";
        case   0xA048: return "YI_SYLLABLE_PO";
        case   0xA049: return "YI_SYLLABLE_POP";
        case   0xA04A: return "YI_SYLLABLE_PUT";
        case   0xA04B: return "YI_SYLLABLE_PUX";
        case   0xA04C: return "YI_SYLLABLE_PU";
        case   0xA04D: return "YI_SYLLABLE_PUP";
        case   0xA04E: return "YI_SYLLABLE_PURX";
        case   0xA04F: return "YI_SYLLABLE_PUR";
        case   0xA050: return "YI_SYLLABLE_PYT";
        case   0xA051: return "YI_SYLLABLE_PYX";
        case   0xA052: return "YI_SYLLABLE_PY";
        case   0xA053: return "YI_SYLLABLE_PYP";
        case   0xA054: return "YI_SYLLABLE_PYRX";
        case   0xA055: return "YI_SYLLABLE_PYR";
        case   0xA056: return "YI_SYLLABLE_BBIT";
        case   0xA057: return "YI_SYLLABLE_BBIX";
        case   0xA058: return "YI_SYLLABLE_BBI";
        case   0xA059: return "YI_SYLLABLE_BBIP";
        case   0xA05A: return "YI_SYLLABLE_BBIET";
        case   0xA05B: return "YI_SYLLABLE_BBIEX";
        case   0xA05C: return "YI_SYLLABLE_BBIE";
        case   0xA05D: return "YI_SYLLABLE_BBIEP";
        case   0xA05E: return "YI_SYLLABLE_BBAT";
        case   0xA05F: return "YI_SYLLABLE_BBAX";
        case   0xA060: return "YI_SYLLABLE_BBA";
        case   0xA061: return "YI_SYLLABLE_BBAP";
        case   0xA062: return "YI_SYLLABLE_BBUOX";
        case   0xA063: return "YI_SYLLABLE_BBUO";
        case   0xA064: return "YI_SYLLABLE_BBUOP";
        case   0xA065: return "YI_SYLLABLE_BBOT";
        case   0xA066: return "YI_SYLLABLE_BBOX";
        case   0xA067: return "YI_SYLLABLE_BBO";
        case   0xA068: return "YI_SYLLABLE_BBOP";
        case   0xA069: return "YI_SYLLABLE_BBEX";
        case   0xA06A: return "YI_SYLLABLE_BBE";
        case   0xA06B: return "YI_SYLLABLE_BBEP";
        case   0xA06C: return "YI_SYLLABLE_BBUT";
        case   0xA06D: return "YI_SYLLABLE_BBUX";
        case   0xA06E: return "YI_SYLLABLE_BBU";
        case   0xA06F: return "YI_SYLLABLE_BBUP";
        case   0xA070: return "YI_SYLLABLE_BBURX";
        case   0xA071: return "YI_SYLLABLE_BBUR";
        case   0xA072: return "YI_SYLLABLE_BBYT";
        case   0xA073: return "YI_SYLLABLE_BBYX";
        case   0xA074: return "YI_SYLLABLE_BBY";
        case   0xA075: return "YI_SYLLABLE_BBYP";
        case   0xA076: return "YI_SYLLABLE_NBIT";
        case   0xA077: return "YI_SYLLABLE_NBIX";
        case   0xA078: return "YI_SYLLABLE_NBI";
        case   0xA079: return "YI_SYLLABLE_NBIP";
        case   0xA07A: return "YI_SYLLABLE_NBIEX";
        case   0xA07B: return "YI_SYLLABLE_NBIE";
        case   0xA07C: return "YI_SYLLABLE_NBIEP";
        case   0xA07D: return "YI_SYLLABLE_NBAT";
        case   0xA07E: return "YI_SYLLABLE_NBAX";
        case   0xA07F: return "YI_SYLLABLE_NBA";
        case   0xA080: return "YI_SYLLABLE_NBAP";
        case   0xA081: return "YI_SYLLABLE_NBOT";
        case   0xA082: return "YI_SYLLABLE_NBOX";
        case   0xA083: return "YI_SYLLABLE_NBO";
        case   0xA084: return "YI_SYLLABLE_NBOP";
        case   0xA085: return "YI_SYLLABLE_NBUT";
        case   0xA086: return "YI_SYLLABLE_NBUX";
        case   0xA087: return "YI_SYLLABLE_NBU";
        case   0xA088: return "YI_SYLLABLE_NBUP";
        case   0xA089: return "YI_SYLLABLE_NBURX";
        case   0xA08A: return "YI_SYLLABLE_NBUR";
        case   0xA08B: return "YI_SYLLABLE_NBYT";
        case   0xA08C: return "YI_SYLLABLE_NBYX";
        case   0xA08D: return "YI_SYLLABLE_NBY";
        case   0xA08E: return "YI_SYLLABLE_NBYP";
        case   0xA08F: return "YI_SYLLABLE_NBYRX";
        case   0xA090: return "YI_SYLLABLE_NBYR";
        case   0xA091: return "YI_SYLLABLE_HMIT";
        case   0xA092: return "YI_SYLLABLE_HMIX";
        case   0xA093: return "YI_SYLLABLE_HMI";
        case   0xA094: return "YI_SYLLABLE_HMIP";
        case   0xA095: return "YI_SYLLABLE_HMIEX";
        case   0xA096: return "YI_SYLLABLE_HMIE";
        case   0xA097: return "YI_SYLLABLE_HMIEP";
        case   0xA098: return "YI_SYLLABLE_HMAT";
        case   0xA099: return "YI_SYLLABLE_HMAX";
        case   0xA09A: return "YI_SYLLABLE_HMA";
        case   0xA09B: return "YI_SYLLABLE_HMAP";
        case   0xA09C: return "YI_SYLLABLE_HMUOX";
        case   0xA09D: return "YI_SYLLABLE_HMUO";
        case   0xA09E: return "YI_SYLLABLE_HMUOP";
        case   0xA09F: return "YI_SYLLABLE_HMOT";
        case   0xA0A0: return "YI_SYLLABLE_HMOX";
        case   0xA0A1: return "YI_SYLLABLE_HMO";
        case   0xA0A2: return "YI_SYLLABLE_HMOP";
        case   0xA0A3: return "YI_SYLLABLE_HMUT";
        case   0xA0A4: return "YI_SYLLABLE_HMUX";
        case   0xA0A5: return "YI_SYLLABLE_HMU";
        case   0xA0A6: return "YI_SYLLABLE_HMUP";
        case   0xA0A7: return "YI_SYLLABLE_HMURX";
        case   0xA0A8: return "YI_SYLLABLE_HMUR";
        case   0xA0A9: return "YI_SYLLABLE_HMYX";
        case   0xA0AA: return "YI_SYLLABLE_HMY";
        case   0xA0AB: return "YI_SYLLABLE_HMYP";
        case   0xA0AC: return "YI_SYLLABLE_HMYRX";
        case   0xA0AD: return "YI_SYLLABLE_HMYR";
        case   0xA0AE: return "YI_SYLLABLE_MIT";
        case   0xA0AF: return "YI_SYLLABLE_MIX";
        case   0xA0B0: return "YI_SYLLABLE_MI";
        case   0xA0B1: return "YI_SYLLABLE_MIP";
        case   0xA0B2: return "YI_SYLLABLE_MIEX";
        case   0xA0B3: return "YI_SYLLABLE_MIE";
        case   0xA0B4: return "YI_SYLLABLE_MIEP";
        case   0xA0B5: return "YI_SYLLABLE_MAT";
        case   0xA0B6: return "YI_SYLLABLE_MAX";
        case   0xA0B7: return "YI_SYLLABLE_MA";
        case   0xA0B8: return "YI_SYLLABLE_MAP";
        case   0xA0B9: return "YI_SYLLABLE_MUOT";
        case   0xA0BA: return "YI_SYLLABLE_MUOX";
        case   0xA0BB: return "YI_SYLLABLE_MUO";
        case   0xA0BC: return "YI_SYLLABLE_MUOP";
        case   0xA0BD: return "YI_SYLLABLE_MOT";
        case   0xA0BE: return "YI_SYLLABLE_MOX";
        case   0xA0BF: return "YI_SYLLABLE_MO";
        case   0xA0C0: return "YI_SYLLABLE_MOP";
        case   0xA0C1: return "YI_SYLLABLE_MEX";
        case   0xA0C2: return "YI_SYLLABLE_ME";
        case   0xA0C3: return "YI_SYLLABLE_MUT";
        case   0xA0C4: return "YI_SYLLABLE_MUX";
        case   0xA0C5: return "YI_SYLLABLE_MU";
        case   0xA0C6: return "YI_SYLLABLE_MUP";
        case   0xA0C7: return "YI_SYLLABLE_MURX";
        case   0xA0C8: return "YI_SYLLABLE_MUR";
        case   0xA0C9: return "YI_SYLLABLE_MYT";
        case   0xA0CA: return "YI_SYLLABLE_MYX";
        case   0xA0CB: return "YI_SYLLABLE_MY";
        case   0xA0CC: return "YI_SYLLABLE_MYP";
        case   0xA0CD: return "YI_SYLLABLE_FIT";
        case   0xA0CE: return "YI_SYLLABLE_FIX";
        case   0xA0CF: return "YI_SYLLABLE_FI";
        case   0xA0D0: return "YI_SYLLABLE_FIP";
        case   0xA0D1: return "YI_SYLLABLE_FAT";
        case   0xA0D2: return "YI_SYLLABLE_FAX";
        case   0xA0D3: return "YI_SYLLABLE_FA";
        case   0xA0D4: return "YI_SYLLABLE_FAP";
        case   0xA0D5: return "YI_SYLLABLE_FOX";
        case   0xA0D6: return "YI_SYLLABLE_FO";
        case   0xA0D7: return "YI_SYLLABLE_FOP";
        case   0xA0D8: return "YI_SYLLABLE_FUT";
        case   0xA0D9: return "YI_SYLLABLE_FUX";
        case   0xA0DA: return "YI_SYLLABLE_FU";
        case   0xA0DB: return "YI_SYLLABLE_FUP";
        case   0xA0DC: return "YI_SYLLABLE_FURX";
        case   0xA0DD: return "YI_SYLLABLE_FUR";
        case   0xA0DE: return "YI_SYLLABLE_FYT";
        case   0xA0DF: return "YI_SYLLABLE_FYX";
        case   0xA0E0: return "YI_SYLLABLE_FY";
        case   0xA0E1: return "YI_SYLLABLE_FYP";
        case   0xA0E2: return "YI_SYLLABLE_VIT";
        case   0xA0E3: return "YI_SYLLABLE_VIX";
        case   0xA0E4: return "YI_SYLLABLE_VI";
        case   0xA0E5: return "YI_SYLLABLE_VIP";
        case   0xA0E6: return "YI_SYLLABLE_VIET";
        case   0xA0E7: return "YI_SYLLABLE_VIEX";
        case   0xA0E8: return "YI_SYLLABLE_VIE";
        case   0xA0E9: return "YI_SYLLABLE_VIEP";
        case   0xA0EA: return "YI_SYLLABLE_VAT";
        case   0xA0EB: return "YI_SYLLABLE_VAX";
        case   0xA0EC: return "YI_SYLLABLE_VA";
        case   0xA0ED: return "YI_SYLLABLE_VAP";
        case   0xA0EE: return "YI_SYLLABLE_VOT";
        case   0xA0EF: return "YI_SYLLABLE_VOX";
        case   0xA0F0: return "YI_SYLLABLE_VO";
        case   0xA0F1: return "YI_SYLLABLE_VOP";
        case   0xA0F2: return "YI_SYLLABLE_VEX";
        case   0xA0F3: return "YI_SYLLABLE_VEP";
        case   0xA0F4: return "YI_SYLLABLE_VUT";
        case   0xA0F5: return "YI_SYLLABLE_VUX";
        case   0xA0F6: return "YI_SYLLABLE_VU";
        case   0xA0F7: return "YI_SYLLABLE_VUP";
        case   0xA0F8: return "YI_SYLLABLE_VURX";
        case   0xA0F9: return "YI_SYLLABLE_VUR";
        case   0xA0FA: return "YI_SYLLABLE_VYT";
        case   0xA0FB: return "YI_SYLLABLE_VYX";
        case   0xA0FC: return "YI_SYLLABLE_VY";
        case   0xA0FD: return "YI_SYLLABLE_VYP";
        case   0xA0FE: return "YI_SYLLABLE_VYRX";
        case   0xA0FF: return "YI_SYLLABLE_VYR";
        case   0xA100: return "YI_SYLLABLE_DIT";
        case   0xA101: return "YI_SYLLABLE_DIX";
        case   0xA102: return "YI_SYLLABLE_DI";
        case   0xA103: return "YI_SYLLABLE_DIP";
        case   0xA104: return "YI_SYLLABLE_DIEX";
        case   0xA105: return "YI_SYLLABLE_DIE";
        case   0xA106: return "YI_SYLLABLE_DIEP";
        case   0xA107: return "YI_SYLLABLE_DAT";
        case   0xA108: return "YI_SYLLABLE_DAX";
        case   0xA109: return "YI_SYLLABLE_DA";
        case   0xA10A: return "YI_SYLLABLE_DAP";
        case   0xA10B: return "YI_SYLLABLE_DUOX";
        case   0xA10C: return "YI_SYLLABLE_DUO";
        case   0xA10D: return "YI_SYLLABLE_DOT";
        case   0xA10E: return "YI_SYLLABLE_DOX";
        case   0xA10F: return "YI_SYLLABLE_DO";
        case   0xA110: return "YI_SYLLABLE_DOP";
        case   0xA111: return "YI_SYLLABLE_DEX";
        case   0xA112: return "YI_SYLLABLE_DE";
        case   0xA113: return "YI_SYLLABLE_DEP";
        case   0xA114: return "YI_SYLLABLE_DUT";
        case   0xA115: return "YI_SYLLABLE_DUX";
        case   0xA116: return "YI_SYLLABLE_DU";
        case   0xA117: return "YI_SYLLABLE_DUP";
        case   0xA118: return "YI_SYLLABLE_DURX";
        case   0xA119: return "YI_SYLLABLE_DUR";
        case   0xA11A: return "YI_SYLLABLE_TIT";
        case   0xA11B: return "YI_SYLLABLE_TIX";
        case   0xA11C: return "YI_SYLLABLE_TI";
        case   0xA11D: return "YI_SYLLABLE_TIP";
        case   0xA11E: return "YI_SYLLABLE_TIEX";
        case   0xA11F: return "YI_SYLLABLE_TIE";
        case   0xA120: return "YI_SYLLABLE_TIEP";
        case   0xA121: return "YI_SYLLABLE_TAT";
        case   0xA122: return "YI_SYLLABLE_TAX";
        case   0xA123: return "YI_SYLLABLE_TA";
        case   0xA124: return "YI_SYLLABLE_TAP";
        case   0xA125: return "YI_SYLLABLE_TUOT";
        case   0xA126: return "YI_SYLLABLE_TUOX";
        case   0xA127: return "YI_SYLLABLE_TUO";
        case   0xA128: return "YI_SYLLABLE_TUOP";
        case   0xA129: return "YI_SYLLABLE_TOT";
        case   0xA12A: return "YI_SYLLABLE_TOX";
        case   0xA12B: return "YI_SYLLABLE_TO";
        case   0xA12C: return "YI_SYLLABLE_TOP";
        case   0xA12D: return "YI_SYLLABLE_TEX";
        case   0xA12E: return "YI_SYLLABLE_TE";
        case   0xA12F: return "YI_SYLLABLE_TEP";
        case   0xA130: return "YI_SYLLABLE_TUT";
        case   0xA131: return "YI_SYLLABLE_TUX";
        case   0xA132: return "YI_SYLLABLE_TU";
        case   0xA133: return "YI_SYLLABLE_TUP";
        case   0xA134: return "YI_SYLLABLE_TURX";
        case   0xA135: return "YI_SYLLABLE_TUR";
        case   0xA136: return "YI_SYLLABLE_DDIT";
        case   0xA137: return "YI_SYLLABLE_DDIX";
        case   0xA138: return "YI_SYLLABLE_DDI";
        case   0xA139: return "YI_SYLLABLE_DDIP";
        case   0xA13A: return "YI_SYLLABLE_DDIEX";
        case   0xA13B: return "YI_SYLLABLE_DDIE";
        case   0xA13C: return "YI_SYLLABLE_DDIEP";
        case   0xA13D: return "YI_SYLLABLE_DDAT";
        case   0xA13E: return "YI_SYLLABLE_DDAX";
        case   0xA13F: return "YI_SYLLABLE_DDA";
        case   0xA140: return "YI_SYLLABLE_DDAP";
        case   0xA141: return "YI_SYLLABLE_DDUOX";
        case   0xA142: return "YI_SYLLABLE_DDUO";
        case   0xA143: return "YI_SYLLABLE_DDUOP";
        case   0xA144: return "YI_SYLLABLE_DDOT";
        case   0xA145: return "YI_SYLLABLE_DDOX";
        case   0xA146: return "YI_SYLLABLE_DDO";
        case   0xA147: return "YI_SYLLABLE_DDOP";
        case   0xA148: return "YI_SYLLABLE_DDEX";
        case   0xA149: return "YI_SYLLABLE_DDE";
        case   0xA14A: return "YI_SYLLABLE_DDEP";
        case   0xA14B: return "YI_SYLLABLE_DDUT";
        case   0xA14C: return "YI_SYLLABLE_DDUX";
        case   0xA14D: return "YI_SYLLABLE_DDU";
        case   0xA14E: return "YI_SYLLABLE_DDUP";
        case   0xA14F: return "YI_SYLLABLE_DDURX";
        case   0xA150: return "YI_SYLLABLE_DDUR";
        case   0xA151: return "YI_SYLLABLE_NDIT";
        case   0xA152: return "YI_SYLLABLE_NDIX";
        case   0xA153: return "YI_SYLLABLE_NDI";
        case   0xA154: return "YI_SYLLABLE_NDIP";
        case   0xA155: return "YI_SYLLABLE_NDIEX";
        case   0xA156: return "YI_SYLLABLE_NDIE";
        case   0xA157: return "YI_SYLLABLE_NDAT";
        case   0xA158: return "YI_SYLLABLE_NDAX";
        case   0xA159: return "YI_SYLLABLE_NDA";
        case   0xA15A: return "YI_SYLLABLE_NDAP";
        case   0xA15B: return "YI_SYLLABLE_NDOT";
        case   0xA15C: return "YI_SYLLABLE_NDOX";
        case   0xA15D: return "YI_SYLLABLE_NDO";
        case   0xA15E: return "YI_SYLLABLE_NDOP";
        case   0xA15F: return "YI_SYLLABLE_NDEX";
        case   0xA160: return "YI_SYLLABLE_NDE";
        case   0xA161: return "YI_SYLLABLE_NDEP";
        case   0xA162: return "YI_SYLLABLE_NDUT";
        case   0xA163: return "YI_SYLLABLE_NDUX";
        case   0xA164: return "YI_SYLLABLE_NDU";
        case   0xA165: return "YI_SYLLABLE_NDUP";
        case   0xA166: return "YI_SYLLABLE_NDURX";
        case   0xA167: return "YI_SYLLABLE_NDUR";
        case   0xA168: return "YI_SYLLABLE_HNIT";
        case   0xA169: return "YI_SYLLABLE_HNIX";
        case   0xA16A: return "YI_SYLLABLE_HNI";
        case   0xA16B: return "YI_SYLLABLE_HNIP";
        case   0xA16C: return "YI_SYLLABLE_HNIET";
        case   0xA16D: return "YI_SYLLABLE_HNIEX";
        case   0xA16E: return "YI_SYLLABLE_HNIE";
        case   0xA16F: return "YI_SYLLABLE_HNIEP";
        case   0xA170: return "YI_SYLLABLE_HNAT";
        case   0xA171: return "YI_SYLLABLE_HNAX";
        case   0xA172: return "YI_SYLLABLE_HNA";
        case   0xA173: return "YI_SYLLABLE_HNAP";
        case   0xA174: return "YI_SYLLABLE_HNUOX";
        case   0xA175: return "YI_SYLLABLE_HNUO";
        case   0xA176: return "YI_SYLLABLE_HNOT";
        case   0xA177: return "YI_SYLLABLE_HNOX";
        case   0xA178: return "YI_SYLLABLE_HNOP";
        case   0xA179: return "YI_SYLLABLE_HNEX";
        case   0xA17A: return "YI_SYLLABLE_HNE";
        case   0xA17B: return "YI_SYLLABLE_HNEP";
        case   0xA17C: return "YI_SYLLABLE_HNUT";
        case   0xA17D: return "YI_SYLLABLE_NIT";
        case   0xA17E: return "YI_SYLLABLE_NIX";
        case   0xA17F: return "YI_SYLLABLE_NI";
        case   0xA180: return "YI_SYLLABLE_NIP";
        case   0xA181: return "YI_SYLLABLE_NIEX";
        case   0xA182: return "YI_SYLLABLE_NIE";
        case   0xA183: return "YI_SYLLABLE_NIEP";
        case   0xA184: return "YI_SYLLABLE_NAX";
        case   0xA185: return "YI_SYLLABLE_NA";
        case   0xA186: return "YI_SYLLABLE_NAP";
        case   0xA187: return "YI_SYLLABLE_NUOX";
        case   0xA188: return "YI_SYLLABLE_NUO";
        case   0xA189: return "YI_SYLLABLE_NUOP";
        case   0xA18A: return "YI_SYLLABLE_NOT";
        case   0xA18B: return "YI_SYLLABLE_NOX";
        case   0xA18C: return "YI_SYLLABLE_NO";
        case   0xA18D: return "YI_SYLLABLE_NOP";
        case   0xA18E: return "YI_SYLLABLE_NEX";
        case   0xA18F: return "YI_SYLLABLE_NE";
        case   0xA190: return "YI_SYLLABLE_NEP";
        case   0xA191: return "YI_SYLLABLE_NUT";
        case   0xA192: return "YI_SYLLABLE_NUX";
        case   0xA193: return "YI_SYLLABLE_NU";
        case   0xA194: return "YI_SYLLABLE_NUP";
        case   0xA195: return "YI_SYLLABLE_NURX";
        case   0xA196: return "YI_SYLLABLE_NUR";
        case   0xA197: return "YI_SYLLABLE_HLIT";
        case   0xA198: return "YI_SYLLABLE_HLIX";
        case   0xA199: return "YI_SYLLABLE_HLI";
        case   0xA19A: return "YI_SYLLABLE_HLIP";
        case   0xA19B: return "YI_SYLLABLE_HLIEX";
        case   0xA19C: return "YI_SYLLABLE_HLIE";
        case   0xA19D: return "YI_SYLLABLE_HLIEP";
        case   0xA19E: return "YI_SYLLABLE_HLAT";
        case   0xA19F: return "YI_SYLLABLE_HLAX";
        case   0xA1A0: return "YI_SYLLABLE_HLA";
        case   0xA1A1: return "YI_SYLLABLE_HLAP";
        case   0xA1A2: return "YI_SYLLABLE_HLUOX";
        case   0xA1A3: return "YI_SYLLABLE_HLUO";
        case   0xA1A4: return "YI_SYLLABLE_HLUOP";
        case   0xA1A5: return "YI_SYLLABLE_HLOX";
        case   0xA1A6: return "YI_SYLLABLE_HLO";
        case   0xA1A7: return "YI_SYLLABLE_HLOP";
        case   0xA1A8: return "YI_SYLLABLE_HLEX";
        case   0xA1A9: return "YI_SYLLABLE_HLE";
        case   0xA1AA: return "YI_SYLLABLE_HLEP";
        case   0xA1AB: return "YI_SYLLABLE_HLUT";
        case   0xA1AC: return "YI_SYLLABLE_HLUX";
        case   0xA1AD: return "YI_SYLLABLE_HLU";
        case   0xA1AE: return "YI_SYLLABLE_HLUP";
        case   0xA1AF: return "YI_SYLLABLE_HLURX";
        case   0xA1B0: return "YI_SYLLABLE_HLUR";
        case   0xA1B1: return "YI_SYLLABLE_HLYT";
        case   0xA1B2: return "YI_SYLLABLE_HLYX";
        case   0xA1B3: return "YI_SYLLABLE_HLY";
        case   0xA1B4: return "YI_SYLLABLE_HLYP";
        case   0xA1B5: return "YI_SYLLABLE_HLYRX";
        case   0xA1B6: return "YI_SYLLABLE_HLYR";
        case   0xA1B7: return "YI_SYLLABLE_LIT";
        case   0xA1B8: return "YI_SYLLABLE_LIX";
        case   0xA1B9: return "YI_SYLLABLE_LI";
        case   0xA1BA: return "YI_SYLLABLE_LIP";
        case   0xA1BB: return "YI_SYLLABLE_LIET";
        case   0xA1BC: return "YI_SYLLABLE_LIEX";
        case   0xA1BD: return "YI_SYLLABLE_LIE";
        case   0xA1BE: return "YI_SYLLABLE_LIEP";
        case   0xA1BF: return "YI_SYLLABLE_LAT";
        case   0xA1C0: return "YI_SYLLABLE_LAX";
        case   0xA1C1: return "YI_SYLLABLE_LA";
        case   0xA1C2: return "YI_SYLLABLE_LAP";
        case   0xA1C3: return "YI_SYLLABLE_LUOT";
        case   0xA1C4: return "YI_SYLLABLE_LUOX";
        case   0xA1C5: return "YI_SYLLABLE_LUO";
        case   0xA1C6: return "YI_SYLLABLE_LUOP";
        case   0xA1C7: return "YI_SYLLABLE_LOT";
        case   0xA1C8: return "YI_SYLLABLE_LOX";
        case   0xA1C9: return "YI_SYLLABLE_LO";
        case   0xA1CA: return "YI_SYLLABLE_LOP";
        case   0xA1CB: return "YI_SYLLABLE_LEX";
        case   0xA1CC: return "YI_SYLLABLE_LE";
        case   0xA1CD: return "YI_SYLLABLE_LEP";
        case   0xA1CE: return "YI_SYLLABLE_LUT";
        case   0xA1CF: return "YI_SYLLABLE_LUX";
        case   0xA1D0: return "YI_SYLLABLE_LU";
        case   0xA1D1: return "YI_SYLLABLE_LUP";
        case   0xA1D2: return "YI_SYLLABLE_LURX";
        case   0xA1D3: return "YI_SYLLABLE_LUR";
        case   0xA1D4: return "YI_SYLLABLE_LYT";
        case   0xA1D5: return "YI_SYLLABLE_LYX";
        case   0xA1D6: return "YI_SYLLABLE_LY";
        case   0xA1D7: return "YI_SYLLABLE_LYP";
        case   0xA1D8: return "YI_SYLLABLE_LYRX";
        case   0xA1D9: return "YI_SYLLABLE_LYR";
        case   0xA1DA: return "YI_SYLLABLE_GIT";
        case   0xA1DB: return "YI_SYLLABLE_GIX";
        case   0xA1DC: return "YI_SYLLABLE_GI";
        case   0xA1DD: return "YI_SYLLABLE_GIP";
        case   0xA1DE: return "YI_SYLLABLE_GIET";
        case   0xA1DF: return "YI_SYLLABLE_GIEX";
        case   0xA1E0: return "YI_SYLLABLE_GIE";
        case   0xA1E1: return "YI_SYLLABLE_GIEP";
        case   0xA1E2: return "YI_SYLLABLE_GAT";
        case   0xA1E3: return "YI_SYLLABLE_GAX";
        case   0xA1E4: return "YI_SYLLABLE_GA";
        case   0xA1E5: return "YI_SYLLABLE_GAP";
        case   0xA1E6: return "YI_SYLLABLE_GUOT";
        case   0xA1E7: return "YI_SYLLABLE_GUOX";
        case   0xA1E8: return "YI_SYLLABLE_GUO";
        case   0xA1E9: return "YI_SYLLABLE_GUOP";
        case   0xA1EA: return "YI_SYLLABLE_GOT";
        case   0xA1EB: return "YI_SYLLABLE_GOX";
        case   0xA1EC: return "YI_SYLLABLE_GO";
        case   0xA1ED: return "YI_SYLLABLE_GOP";
        case   0xA1EE: return "YI_SYLLABLE_GET";
        case   0xA1EF: return "YI_SYLLABLE_GEX";
        case   0xA1F0: return "YI_SYLLABLE_GE";
        case   0xA1F1: return "YI_SYLLABLE_GEP";
        case   0xA1F2: return "YI_SYLLABLE_GUT";
        case   0xA1F3: return "YI_SYLLABLE_GUX";
        case   0xA1F4: return "YI_SYLLABLE_GU";
        case   0xA1F5: return "YI_SYLLABLE_GUP";
        case   0xA1F6: return "YI_SYLLABLE_GURX";
        case   0xA1F7: return "YI_SYLLABLE_GUR";
        case   0xA1F8: return "YI_SYLLABLE_KIT";
        case   0xA1F9: return "YI_SYLLABLE_KIX";
        case   0xA1FA: return "YI_SYLLABLE_KI";
        case   0xA1FB: return "YI_SYLLABLE_KIP";
        case   0xA1FC: return "YI_SYLLABLE_KIEX";
        case   0xA1FD: return "YI_SYLLABLE_KIE";
        case   0xA1FE: return "YI_SYLLABLE_KIEP";
        case   0xA1FF: return "YI_SYLLABLE_KAT";
        case   0xA200: return "YI_SYLLABLE_KAX";
        case   0xA201: return "YI_SYLLABLE_KA";
        case   0xA202: return "YI_SYLLABLE_KAP";
        case   0xA203: return "YI_SYLLABLE_KUOX";
        case   0xA204: return "YI_SYLLABLE_KUO";
        case   0xA205: return "YI_SYLLABLE_KUOP";
        case   0xA206: return "YI_SYLLABLE_KOT";
        case   0xA207: return "YI_SYLLABLE_KOX";
        case   0xA208: return "YI_SYLLABLE_KO";
        case   0xA209: return "YI_SYLLABLE_KOP";
        case   0xA20A: return "YI_SYLLABLE_KET";
        case   0xA20B: return "YI_SYLLABLE_KEX";
        case   0xA20C: return "YI_SYLLABLE_KE";
        case   0xA20D: return "YI_SYLLABLE_KEP";
        case   0xA20E: return "YI_SYLLABLE_KUT";
        case   0xA20F: return "YI_SYLLABLE_KUX";
        case   0xA210: return "YI_SYLLABLE_KU";
        case   0xA211: return "YI_SYLLABLE_KUP";
        case   0xA212: return "YI_SYLLABLE_KURX";
        case   0xA213: return "YI_SYLLABLE_KUR";
        case   0xA214: return "YI_SYLLABLE_GGIT";
        case   0xA215: return "YI_SYLLABLE_GGIX";
        case   0xA216: return "YI_SYLLABLE_GGI";
        case   0xA217: return "YI_SYLLABLE_GGIEX";
        case   0xA218: return "YI_SYLLABLE_GGIE";
        case   0xA219: return "YI_SYLLABLE_GGIEP";
        case   0xA21A: return "YI_SYLLABLE_GGAT";
        case   0xA21B: return "YI_SYLLABLE_GGAX";
        case   0xA21C: return "YI_SYLLABLE_GGA";
        case   0xA21D: return "YI_SYLLABLE_GGAP";
        case   0xA21E: return "YI_SYLLABLE_GGUOT";
        case   0xA21F: return "YI_SYLLABLE_GGUOX";
        case   0xA220: return "YI_SYLLABLE_GGUO";
        case   0xA221: return "YI_SYLLABLE_GGUOP";
        case   0xA222: return "YI_SYLLABLE_GGOT";
        case   0xA223: return "YI_SYLLABLE_GGOX";
        case   0xA224: return "YI_SYLLABLE_GGO";
        case   0xA225: return "YI_SYLLABLE_GGOP";
        case   0xA226: return "YI_SYLLABLE_GGET";
        case   0xA227: return "YI_SYLLABLE_GGEX";
        case   0xA228: return "YI_SYLLABLE_GGE";
        case   0xA229: return "YI_SYLLABLE_GGEP";
        case   0xA22A: return "YI_SYLLABLE_GGUT";
        case   0xA22B: return "YI_SYLLABLE_GGUX";
        case   0xA22C: return "YI_SYLLABLE_GGU";
        case   0xA22D: return "YI_SYLLABLE_GGUP";
        case   0xA22E: return "YI_SYLLABLE_GGURX";
        case   0xA22F: return "YI_SYLLABLE_GGUR";
        case   0xA230: return "YI_SYLLABLE_MGIEX";
        case   0xA231: return "YI_SYLLABLE_MGIE";
        case   0xA232: return "YI_SYLLABLE_MGAT";
        case   0xA233: return "YI_SYLLABLE_MGAX";
        case   0xA234: return "YI_SYLLABLE_MGA";
        case   0xA235: return "YI_SYLLABLE_MGAP";
        case   0xA236: return "YI_SYLLABLE_MGUOX";
        case   0xA237: return "YI_SYLLABLE_MGUO";
        case   0xA238: return "YI_SYLLABLE_MGUOP";
        case   0xA239: return "YI_SYLLABLE_MGOT";
        case   0xA23A: return "YI_SYLLABLE_MGOX";
        case   0xA23B: return "YI_SYLLABLE_MGO";
        case   0xA23C: return "YI_SYLLABLE_MGOP";
        case   0xA23D: return "YI_SYLLABLE_MGEX";
        case   0xA23E: return "YI_SYLLABLE_MGE";
        case   0xA23F: return "YI_SYLLABLE_MGEP";
        case   0xA240: return "YI_SYLLABLE_MGUT";
        case   0xA241: return "YI_SYLLABLE_MGUX";
        case   0xA242: return "YI_SYLLABLE_MGU";
        case   0xA243: return "YI_SYLLABLE_MGUP";
        case   0xA244: return "YI_SYLLABLE_MGURX";
        case   0xA245: return "YI_SYLLABLE_MGUR";
        case   0xA246: return "YI_SYLLABLE_HXIT";
        case   0xA247: return "YI_SYLLABLE_HXIX";
        case   0xA248: return "YI_SYLLABLE_HXI";
        case   0xA249: return "YI_SYLLABLE_HXIP";
        case   0xA24A: return "YI_SYLLABLE_HXIET";
        case   0xA24B: return "YI_SYLLABLE_HXIEX";
        case   0xA24C: return "YI_SYLLABLE_HXIE";
        case   0xA24D: return "YI_SYLLABLE_HXIEP";
        case   0xA24E: return "YI_SYLLABLE_HXAT";
        case   0xA24F: return "YI_SYLLABLE_HXAX";
        case   0xA250: return "YI_SYLLABLE_HXA";
        case   0xA251: return "YI_SYLLABLE_HXAP";
        case   0xA252: return "YI_SYLLABLE_HXUOT";
        case   0xA253: return "YI_SYLLABLE_HXUOX";
        case   0xA254: return "YI_SYLLABLE_HXUO";
        case   0xA255: return "YI_SYLLABLE_HXUOP";
        case   0xA256: return "YI_SYLLABLE_HXOT";
        case   0xA257: return "YI_SYLLABLE_HXOX";
        case   0xA258: return "YI_SYLLABLE_HXO";
        case   0xA259: return "YI_SYLLABLE_HXOP";
        case   0xA25A: return "YI_SYLLABLE_HXEX";
        case   0xA25B: return "YI_SYLLABLE_HXE";
        case   0xA25C: return "YI_SYLLABLE_HXEP";
        case   0xA25D: return "YI_SYLLABLE_NGIEX";
        case   0xA25E: return "YI_SYLLABLE_NGIE";
        case   0xA25F: return "YI_SYLLABLE_NGIEP";
        case   0xA260: return "YI_SYLLABLE_NGAT";
        case   0xA261: return "YI_SYLLABLE_NGAX";
        case   0xA262: return "YI_SYLLABLE_NGA";
        case   0xA263: return "YI_SYLLABLE_NGAP";
        case   0xA264: return "YI_SYLLABLE_NGUOT";
        case   0xA265: return "YI_SYLLABLE_NGUOX";
        case   0xA266: return "YI_SYLLABLE_NGUO";
        case   0xA267: return "YI_SYLLABLE_NGOT";
        case   0xA268: return "YI_SYLLABLE_NGOX";
        case   0xA269: return "YI_SYLLABLE_NGO";
        case   0xA26A: return "YI_SYLLABLE_NGOP";
        case   0xA26B: return "YI_SYLLABLE_NGEX";
        case   0xA26C: return "YI_SYLLABLE_NGE";
        case   0xA26D: return "YI_SYLLABLE_NGEP";
        case   0xA26E: return "YI_SYLLABLE_HIT";
        case   0xA26F: return "YI_SYLLABLE_HIEX";
        case   0xA270: return "YI_SYLLABLE_HIE";
        case   0xA271: return "YI_SYLLABLE_HAT";
        case   0xA272: return "YI_SYLLABLE_HAX";
        case   0xA273: return "YI_SYLLABLE_HA";
        case   0xA274: return "YI_SYLLABLE_HAP";
        case   0xA275: return "YI_SYLLABLE_HUOT";
        case   0xA276: return "YI_SYLLABLE_HUOX";
        case   0xA277: return "YI_SYLLABLE_HUO";
        case   0xA278: return "YI_SYLLABLE_HUOP";
        case   0xA279: return "YI_SYLLABLE_HOT";
        case   0xA27A: return "YI_SYLLABLE_HOX";
        case   0xA27B: return "YI_SYLLABLE_HO";
        case   0xA27C: return "YI_SYLLABLE_HOP";
        case   0xA27D: return "YI_SYLLABLE_HEX";
        case   0xA27E: return "YI_SYLLABLE_HE";
        case   0xA27F: return "YI_SYLLABLE_HEP";
        case   0xA280: return "YI_SYLLABLE_WAT";
        case   0xA281: return "YI_SYLLABLE_WAX";
        case   0xA282: return "YI_SYLLABLE_WA";
        case   0xA283: return "YI_SYLLABLE_WAP";
        case   0xA284: return "YI_SYLLABLE_WUOX";
        case   0xA285: return "YI_SYLLABLE_WUO";
        case   0xA286: return "YI_SYLLABLE_WUOP";
        case   0xA287: return "YI_SYLLABLE_WOX";
        case   0xA288: return "YI_SYLLABLE_WO";
        case   0xA289: return "YI_SYLLABLE_WOP";
        case   0xA28A: return "YI_SYLLABLE_WEX";
        case   0xA28B: return "YI_SYLLABLE_WE";
        case   0xA28C: return "YI_SYLLABLE_WEP";
        case   0xA28D: return "YI_SYLLABLE_ZIT";
        case   0xA28E: return "YI_SYLLABLE_ZIX";
        case   0xA28F: return "YI_SYLLABLE_ZI";
        case   0xA290: return "YI_SYLLABLE_ZIP";
        case   0xA291: return "YI_SYLLABLE_ZIEX";
        case   0xA292: return "YI_SYLLABLE_ZIE";
        case   0xA293: return "YI_SYLLABLE_ZIEP";
        case   0xA294: return "YI_SYLLABLE_ZAT";
        case   0xA295: return "YI_SYLLABLE_ZAX";
        case   0xA296: return "YI_SYLLABLE_ZA";
        case   0xA297: return "YI_SYLLABLE_ZAP";
        case   0xA298: return "YI_SYLLABLE_ZUOX";
        case   0xA299: return "YI_SYLLABLE_ZUO";
        case   0xA29A: return "YI_SYLLABLE_ZUOP";
        case   0xA29B: return "YI_SYLLABLE_ZOT";
        case   0xA29C: return "YI_SYLLABLE_ZOX";
        case   0xA29D: return "YI_SYLLABLE_ZO";
        case   0xA29E: return "YI_SYLLABLE_ZOP";
        case   0xA29F: return "YI_SYLLABLE_ZEX";
        case   0xA2A0: return "YI_SYLLABLE_ZE";
        case   0xA2A1: return "YI_SYLLABLE_ZEP";
        case   0xA2A2: return "YI_SYLLABLE_ZUT";
        case   0xA2A3: return "YI_SYLLABLE_ZUX";
        case   0xA2A4: return "YI_SYLLABLE_ZU";
        case   0xA2A5: return "YI_SYLLABLE_ZUP";
        case   0xA2A6: return "YI_SYLLABLE_ZURX";
        case   0xA2A7: return "YI_SYLLABLE_ZUR";
        case   0xA2A8: return "YI_SYLLABLE_ZYT";
        case   0xA2A9: return "YI_SYLLABLE_ZYX";
        case   0xA2AA: return "YI_SYLLABLE_ZY";
        case   0xA2AB: return "YI_SYLLABLE_ZYP";
        case   0xA2AC: return "YI_SYLLABLE_ZYRX";
        case   0xA2AD: return "YI_SYLLABLE_ZYR";
        case   0xA2AE: return "YI_SYLLABLE_CIT";
        case   0xA2AF: return "YI_SYLLABLE_CIX";
        case   0xA2B0: return "YI_SYLLABLE_CI";
        case   0xA2B1: return "YI_SYLLABLE_CIP";
        case   0xA2B2: return "YI_SYLLABLE_CIET";
        case   0xA2B3: return "YI_SYLLABLE_CIEX";
        case   0xA2B4: return "YI_SYLLABLE_CIE";
        case   0xA2B5: return "YI_SYLLABLE_CIEP";
        case   0xA2B6: return "YI_SYLLABLE_CAT";
        case   0xA2B7: return "YI_SYLLABLE_CAX";
        case   0xA2B8: return "YI_SYLLABLE_CA";
        case   0xA2B9: return "YI_SYLLABLE_CAP";
        case   0xA2BA: return "YI_SYLLABLE_CUOX";
        case   0xA2BB: return "YI_SYLLABLE_CUO";
        case   0xA2BC: return "YI_SYLLABLE_CUOP";
        case   0xA2BD: return "YI_SYLLABLE_COT";
        case   0xA2BE: return "YI_SYLLABLE_COX";
        case   0xA2BF: return "YI_SYLLABLE_CO";
        case   0xA2C0: return "YI_SYLLABLE_COP";
        case   0xA2C1: return "YI_SYLLABLE_CEX";
        case   0xA2C2: return "YI_SYLLABLE_CE";
        case   0xA2C3: return "YI_SYLLABLE_CEP";
        case   0xA2C4: return "YI_SYLLABLE_CUT";
        case   0xA2C5: return "YI_SYLLABLE_CUX";
        case   0xA2C6: return "YI_SYLLABLE_CU";
        case   0xA2C7: return "YI_SYLLABLE_CUP";
        case   0xA2C8: return "YI_SYLLABLE_CURX";
        case   0xA2C9: return "YI_SYLLABLE_CUR";
        case   0xA2CA: return "YI_SYLLABLE_CYT";
        case   0xA2CB: return "YI_SYLLABLE_CYX";
        case   0xA2CC: return "YI_SYLLABLE_CY";
        case   0xA2CD: return "YI_SYLLABLE_CYP";
        case   0xA2CE: return "YI_SYLLABLE_CYRX";
        case   0xA2CF: return "YI_SYLLABLE_CYR";
        case   0xA2D0: return "YI_SYLLABLE_ZZIT";
        case   0xA2D1: return "YI_SYLLABLE_ZZIX";
        case   0xA2D2: return "YI_SYLLABLE_ZZI";
        case   0xA2D3: return "YI_SYLLABLE_ZZIP";
        case   0xA2D4: return "YI_SYLLABLE_ZZIET";
        case   0xA2D5: return "YI_SYLLABLE_ZZIEX";
        case   0xA2D6: return "YI_SYLLABLE_ZZIE";
        case   0xA2D7: return "YI_SYLLABLE_ZZIEP";
        case   0xA2D8: return "YI_SYLLABLE_ZZAT";
        case   0xA2D9: return "YI_SYLLABLE_ZZAX";
        case   0xA2DA: return "YI_SYLLABLE_ZZA";
        case   0xA2DB: return "YI_SYLLABLE_ZZAP";
        case   0xA2DC: return "YI_SYLLABLE_ZZOX";
        case   0xA2DD: return "YI_SYLLABLE_ZZO";
        case   0xA2DE: return "YI_SYLLABLE_ZZOP";
        case   0xA2DF: return "YI_SYLLABLE_ZZEX";
        case   0xA2E0: return "YI_SYLLABLE_ZZE";
        case   0xA2E1: return "YI_SYLLABLE_ZZEP";
        case   0xA2E2: return "YI_SYLLABLE_ZZUX";
        case   0xA2E3: return "YI_SYLLABLE_ZZU";
        case   0xA2E4: return "YI_SYLLABLE_ZZUP";
        case   0xA2E5: return "YI_SYLLABLE_ZZURX";
        case   0xA2E6: return "YI_SYLLABLE_ZZUR";
        case   0xA2E7: return "YI_SYLLABLE_ZZYT";
        case   0xA2E8: return "YI_SYLLABLE_ZZYX";
        case   0xA2E9: return "YI_SYLLABLE_ZZY";
        case   0xA2EA: return "YI_SYLLABLE_ZZYP";
        case   0xA2EB: return "YI_SYLLABLE_ZZYRX";
        case   0xA2EC: return "YI_SYLLABLE_ZZYR";
        case   0xA2ED: return "YI_SYLLABLE_NZIT";
        case   0xA2EE: return "YI_SYLLABLE_NZIX";
        case   0xA2EF: return "YI_SYLLABLE_NZI";
        case   0xA2F0: return "YI_SYLLABLE_NZIP";
        case   0xA2F1: return "YI_SYLLABLE_NZIEX";
        case   0xA2F2: return "YI_SYLLABLE_NZIE";
        case   0xA2F3: return "YI_SYLLABLE_NZIEP";
        case   0xA2F4: return "YI_SYLLABLE_NZAT";
        case   0xA2F5: return "YI_SYLLABLE_NZAX";
        case   0xA2F6: return "YI_SYLLABLE_NZA";
        case   0xA2F7: return "YI_SYLLABLE_NZAP";
        case   0xA2F8: return "YI_SYLLABLE_NZUOX";
        case   0xA2F9: return "YI_SYLLABLE_NZUO";
        case   0xA2FA: return "YI_SYLLABLE_NZOX";
        case   0xA2FB: return "YI_SYLLABLE_NZOP";
        case   0xA2FC: return "YI_SYLLABLE_NZEX";
        case   0xA2FD: return "YI_SYLLABLE_NZE";
        case   0xA2FE: return "YI_SYLLABLE_NZUX";
        case   0xA2FF: return "YI_SYLLABLE_NZU";
        case   0xA300: return "YI_SYLLABLE_NZUP";
        case   0xA301: return "YI_SYLLABLE_NZURX";
        case   0xA302: return "YI_SYLLABLE_NZUR";
        case   0xA303: return "YI_SYLLABLE_NZYT";
        case   0xA304: return "YI_SYLLABLE_NZYX";
        case   0xA305: return "YI_SYLLABLE_NZY";
        case   0xA306: return "YI_SYLLABLE_NZYP";
        case   0xA307: return "YI_SYLLABLE_NZYRX";
        case   0xA308: return "YI_SYLLABLE_NZYR";
        case   0xA309: return "YI_SYLLABLE_SIT";
        case   0xA30A: return "YI_SYLLABLE_SIX";
        case   0xA30B: return "YI_SYLLABLE_SI";
        case   0xA30C: return "YI_SYLLABLE_SIP";
        case   0xA30D: return "YI_SYLLABLE_SIEX";
        case   0xA30E: return "YI_SYLLABLE_SIE";
        case   0xA30F: return "YI_SYLLABLE_SIEP";
        case   0xA310: return "YI_SYLLABLE_SAT";
        case   0xA311: return "YI_SYLLABLE_SAX";
        case   0xA312: return "YI_SYLLABLE_SA";
        case   0xA313: return "YI_SYLLABLE_SAP";
        case   0xA314: return "YI_SYLLABLE_SUOX";
        case   0xA315: return "YI_SYLLABLE_SUO";
        case   0xA316: return "YI_SYLLABLE_SUOP";
        case   0xA317: return "YI_SYLLABLE_SOT";
        case   0xA318: return "YI_SYLLABLE_SOX";
        case   0xA319: return "YI_SYLLABLE_SO";
        case   0xA31A: return "YI_SYLLABLE_SOP";
        case   0xA31B: return "YI_SYLLABLE_SEX";
        case   0xA31C: return "YI_SYLLABLE_SE";
        case   0xA31D: return "YI_SYLLABLE_SEP";
        case   0xA31E: return "YI_SYLLABLE_SUT";
        case   0xA31F: return "YI_SYLLABLE_SUX";
        case   0xA320: return "YI_SYLLABLE_SU";
        case   0xA321: return "YI_SYLLABLE_SUP";
        case   0xA322: return "YI_SYLLABLE_SURX";
        case   0xA323: return "YI_SYLLABLE_SUR";
        case   0xA324: return "YI_SYLLABLE_SYT";
        case   0xA325: return "YI_SYLLABLE_SYX";
        case   0xA326: return "YI_SYLLABLE_SY";
        case   0xA327: return "YI_SYLLABLE_SYP";
        case   0xA328: return "YI_SYLLABLE_SYRX";
        case   0xA329: return "YI_SYLLABLE_SYR";
        case   0xA32A: return "YI_SYLLABLE_SSIT";
        case   0xA32B: return "YI_SYLLABLE_SSIX";
        case   0xA32C: return "YI_SYLLABLE_SSI";
        case   0xA32D: return "YI_SYLLABLE_SSIP";
        case   0xA32E: return "YI_SYLLABLE_SSIEX";
        case   0xA32F: return "YI_SYLLABLE_SSIE";
        case   0xA330: return "YI_SYLLABLE_SSIEP";
        case   0xA331: return "YI_SYLLABLE_SSAT";
        case   0xA332: return "YI_SYLLABLE_SSAX";
        case   0xA333: return "YI_SYLLABLE_SSA";
        case   0xA334: return "YI_SYLLABLE_SSAP";
        case   0xA335: return "YI_SYLLABLE_SSOT";
        case   0xA336: return "YI_SYLLABLE_SSOX";
        case   0xA337: return "YI_SYLLABLE_SSO";
        case   0xA338: return "YI_SYLLABLE_SSOP";
        case   0xA339: return "YI_SYLLABLE_SSEX";
        case   0xA33A: return "YI_SYLLABLE_SSE";
        case   0xA33B: return "YI_SYLLABLE_SSEP";
        case   0xA33C: return "YI_SYLLABLE_SSUT";
        case   0xA33D: return "YI_SYLLABLE_SSUX";
        case   0xA33E: return "YI_SYLLABLE_SSU";
        case   0xA33F: return "YI_SYLLABLE_SSUP";
        case   0xA340: return "YI_SYLLABLE_SSYT";
        case   0xA341: return "YI_SYLLABLE_SSYX";
        case   0xA342: return "YI_SYLLABLE_SSY";
        case   0xA343: return "YI_SYLLABLE_SSYP";
        case   0xA344: return "YI_SYLLABLE_SSYRX";
        case   0xA345: return "YI_SYLLABLE_SSYR";
        case   0xA346: return "YI_SYLLABLE_ZHAT";
        case   0xA347: return "YI_SYLLABLE_ZHAX";
        case   0xA348: return "YI_SYLLABLE_ZHA";
        case   0xA349: return "YI_SYLLABLE_ZHAP";
        case   0xA34A: return "YI_SYLLABLE_ZHUOX";
        case   0xA34B: return "YI_SYLLABLE_ZHUO";
        case   0xA34C: return "YI_SYLLABLE_ZHUOP";
        case   0xA34D: return "YI_SYLLABLE_ZHOT";
        case   0xA34E: return "YI_SYLLABLE_ZHOX";
        case   0xA34F: return "YI_SYLLABLE_ZHO";
        case   0xA350: return "YI_SYLLABLE_ZHOP";
        case   0xA351: return "YI_SYLLABLE_ZHET";
        case   0xA352: return "YI_SYLLABLE_ZHEX";
        case   0xA353: return "YI_SYLLABLE_ZHE";
        case   0xA354: return "YI_SYLLABLE_ZHEP";
        case   0xA355: return "YI_SYLLABLE_ZHUT";
        case   0xA356: return "YI_SYLLABLE_ZHUX";
        case   0xA357: return "YI_SYLLABLE_ZHU";
        case   0xA358: return "YI_SYLLABLE_ZHUP";
        case   0xA359: return "YI_SYLLABLE_ZHURX";
        case   0xA35A: return "YI_SYLLABLE_ZHUR";
        case   0xA35B: return "YI_SYLLABLE_ZHYT";
        case   0xA35C: return "YI_SYLLABLE_ZHYX";
        case   0xA35D: return "YI_SYLLABLE_ZHY";
        case   0xA35E: return "YI_SYLLABLE_ZHYP";
        case   0xA35F: return "YI_SYLLABLE_ZHYRX";
        case   0xA360: return "YI_SYLLABLE_ZHYR";
        case   0xA361: return "YI_SYLLABLE_CHAT";
        case   0xA362: return "YI_SYLLABLE_CHAX";
        case   0xA363: return "YI_SYLLABLE_CHA";
        case   0xA364: return "YI_SYLLABLE_CHAP";
        case   0xA365: return "YI_SYLLABLE_CHUOT";
        case   0xA366: return "YI_SYLLABLE_CHUOX";
        case   0xA367: return "YI_SYLLABLE_CHUO";
        case   0xA368: return "YI_SYLLABLE_CHUOP";
        case   0xA369: return "YI_SYLLABLE_CHOT";
        case   0xA36A: return "YI_SYLLABLE_CHOX";
        case   0xA36B: return "YI_SYLLABLE_CHO";
        case   0xA36C: return "YI_SYLLABLE_CHOP";
        case   0xA36D: return "YI_SYLLABLE_CHET";
        case   0xA36E: return "YI_SYLLABLE_CHEX";
        case   0xA36F: return "YI_SYLLABLE_CHE";
        case   0xA370: return "YI_SYLLABLE_CHEP";
        case   0xA371: return "YI_SYLLABLE_CHUX";
        case   0xA372: return "YI_SYLLABLE_CHU";
        case   0xA373: return "YI_SYLLABLE_CHUP";
        case   0xA374: return "YI_SYLLABLE_CHURX";
        case   0xA375: return "YI_SYLLABLE_CHUR";
        case   0xA376: return "YI_SYLLABLE_CHYT";
        case   0xA377: return "YI_SYLLABLE_CHYX";
        case   0xA378: return "YI_SYLLABLE_CHY";
        case   0xA379: return "YI_SYLLABLE_CHYP";
        case   0xA37A: return "YI_SYLLABLE_CHYRX";
        case   0xA37B: return "YI_SYLLABLE_CHYR";
        case   0xA37C: return "YI_SYLLABLE_RRAX";
        case   0xA37D: return "YI_SYLLABLE_RRA";
        case   0xA37E: return "YI_SYLLABLE_RRUOX";
        case   0xA37F: return "YI_SYLLABLE_RRUO";
        case   0xA380: return "YI_SYLLABLE_RROT";
        case   0xA381: return "YI_SYLLABLE_RROX";
        case   0xA382: return "YI_SYLLABLE_RRO";
        case   0xA383: return "YI_SYLLABLE_RROP";
        case   0xA384: return "YI_SYLLABLE_RRET";
        case   0xA385: return "YI_SYLLABLE_RREX";
        case   0xA386: return "YI_SYLLABLE_RRE";
        case   0xA387: return "YI_SYLLABLE_RREP";
        case   0xA388: return "YI_SYLLABLE_RRUT";
        case   0xA389: return "YI_SYLLABLE_RRUX";
        case   0xA38A: return "YI_SYLLABLE_RRU";
        case   0xA38B: return "YI_SYLLABLE_RRUP";
        case   0xA38C: return "YI_SYLLABLE_RRURX";
        case   0xA38D: return "YI_SYLLABLE_RRUR";
        case   0xA38E: return "YI_SYLLABLE_RRYT";
        case   0xA38F: return "YI_SYLLABLE_RRYX";
        case   0xA390: return "YI_SYLLABLE_RRY";
        case   0xA391: return "YI_SYLLABLE_RRYP";
        case   0xA392: return "YI_SYLLABLE_RRYRX";
        case   0xA393: return "YI_SYLLABLE_RRYR";
        case   0xA394: return "YI_SYLLABLE_NRAT";
        case   0xA395: return "YI_SYLLABLE_NRAX";
        case   0xA396: return "YI_SYLLABLE_NRA";
        case   0xA397: return "YI_SYLLABLE_NRAP";
        case   0xA398: return "YI_SYLLABLE_NROX";
        case   0xA399: return "YI_SYLLABLE_NRO";
        case   0xA39A: return "YI_SYLLABLE_NROP";
        case   0xA39B: return "YI_SYLLABLE_NRET";
        case   0xA39C: return "YI_SYLLABLE_NREX";
        case   0xA39D: return "YI_SYLLABLE_NRE";
        case   0xA39E: return "YI_SYLLABLE_NREP";
        case   0xA39F: return "YI_SYLLABLE_NRUT";
        case   0xA3A0: return "YI_SYLLABLE_NRUX";
        case   0xA3A1: return "YI_SYLLABLE_NRU";
        case   0xA3A2: return "YI_SYLLABLE_NRUP";
        case   0xA3A3: return "YI_SYLLABLE_NRURX";
        case   0xA3A4: return "YI_SYLLABLE_NRUR";
        case   0xA3A5: return "YI_SYLLABLE_NRYT";
        case   0xA3A6: return "YI_SYLLABLE_NRYX";
        case   0xA3A7: return "YI_SYLLABLE_NRY";
        case   0xA3A8: return "YI_SYLLABLE_NRYP";
        case   0xA3A9: return "YI_SYLLABLE_NRYRX";
        case   0xA3AA: return "YI_SYLLABLE_NRYR";
        case   0xA3AB: return "YI_SYLLABLE_SHAT";
        case   0xA3AC: return "YI_SYLLABLE_SHAX";
        case   0xA3AD: return "YI_SYLLABLE_SHA";
        case   0xA3AE: return "YI_SYLLABLE_SHAP";
        case   0xA3AF: return "YI_SYLLABLE_SHUOX";
        case   0xA3B0: return "YI_SYLLABLE_SHUO";
        case   0xA3B1: return "YI_SYLLABLE_SHUOP";
        case   0xA3B2: return "YI_SYLLABLE_SHOT";
        case   0xA3B3: return "YI_SYLLABLE_SHOX";
        case   0xA3B4: return "YI_SYLLABLE_SHO";
        case   0xA3B5: return "YI_SYLLABLE_SHOP";
        case   0xA3B6: return "YI_SYLLABLE_SHET";
        case   0xA3B7: return "YI_SYLLABLE_SHEX";
        case   0xA3B8: return "YI_SYLLABLE_SHE";
        case   0xA3B9: return "YI_SYLLABLE_SHEP";
        case   0xA3BA: return "YI_SYLLABLE_SHUT";
        case   0xA3BB: return "YI_SYLLABLE_SHUX";
        case   0xA3BC: return "YI_SYLLABLE_SHU";
        case   0xA3BD: return "YI_SYLLABLE_SHUP";
        case   0xA3BE: return "YI_SYLLABLE_SHURX";
        case   0xA3BF: return "YI_SYLLABLE_SHUR";
        case   0xA3C0: return "YI_SYLLABLE_SHYT";
        case   0xA3C1: return "YI_SYLLABLE_SHYX";
        case   0xA3C2: return "YI_SYLLABLE_SHY";
        case   0xA3C3: return "YI_SYLLABLE_SHYP";
        case   0xA3C4: return "YI_SYLLABLE_SHYRX";
        case   0xA3C5: return "YI_SYLLABLE_SHYR";
        case   0xA3C6: return "YI_SYLLABLE_RAT";
        case   0xA3C7: return "YI_SYLLABLE_RAX";
        case   0xA3C8: return "YI_SYLLABLE_RA";
        case   0xA3C9: return "YI_SYLLABLE_RAP";
        case   0xA3CA: return "YI_SYLLABLE_RUOX";
        case   0xA3CB: return "YI_SYLLABLE_RUO";
        case   0xA3CC: return "YI_SYLLABLE_RUOP";
        case   0xA3CD: return "YI_SYLLABLE_ROT";
        case   0xA3CE: return "YI_SYLLABLE_ROX";
        case   0xA3CF: return "YI_SYLLABLE_RO";
        case   0xA3D0: return "YI_SYLLABLE_ROP";
        case   0xA3D1: return "YI_SYLLABLE_REX";
        case   0xA3D2: return "YI_SYLLABLE_RE";
        case   0xA3D3: return "YI_SYLLABLE_REP";
        case   0xA3D4: return "YI_SYLLABLE_RUT";
        case   0xA3D5: return "YI_SYLLABLE_RUX";
        case   0xA3D6: return "YI_SYLLABLE_RU";
        case   0xA3D7: return "YI_SYLLABLE_RUP";
        case   0xA3D8: return "YI_SYLLABLE_RURX";
        case   0xA3D9: return "YI_SYLLABLE_RUR";
        case   0xA3DA: return "YI_SYLLABLE_RYT";
        case   0xA3DB: return "YI_SYLLABLE_RYX";
        case   0xA3DC: return "YI_SYLLABLE_RY";
        case   0xA3DD: return "YI_SYLLABLE_RYP";
        case   0xA3DE: return "YI_SYLLABLE_RYRX";
        case   0xA3DF: return "YI_SYLLABLE_RYR";
        case   0xA3E0: return "YI_SYLLABLE_JIT";
        case   0xA3E1: return "YI_SYLLABLE_JIX";
        case   0xA3E2: return "YI_SYLLABLE_JI";
        case   0xA3E3: return "YI_SYLLABLE_JIP";
        case   0xA3E4: return "YI_SYLLABLE_JIET";
        case   0xA3E5: return "YI_SYLLABLE_JIEX";
        case   0xA3E6: return "YI_SYLLABLE_JIE";
        case   0xA3E7: return "YI_SYLLABLE_JIEP";
        case   0xA3E8: return "YI_SYLLABLE_JUOT";
        case   0xA3E9: return "YI_SYLLABLE_JUOX";
        case   0xA3EA: return "YI_SYLLABLE_JUO";
        case   0xA3EB: return "YI_SYLLABLE_JUOP";
        case   0xA3EC: return "YI_SYLLABLE_JOT";
        case   0xA3ED: return "YI_SYLLABLE_JOX";
        case   0xA3EE: return "YI_SYLLABLE_JO";
        case   0xA3EF: return "YI_SYLLABLE_JOP";
        case   0xA3F0: return "YI_SYLLABLE_JUT";
        case   0xA3F1: return "YI_SYLLABLE_JUX";
        case   0xA3F2: return "YI_SYLLABLE_JU";
        case   0xA3F3: return "YI_SYLLABLE_JUP";
        case   0xA3F4: return "YI_SYLLABLE_JURX";
        case   0xA3F5: return "YI_SYLLABLE_JUR";
        case   0xA3F6: return "YI_SYLLABLE_JYT";
        case   0xA3F7: return "YI_SYLLABLE_JYX";
        case   0xA3F8: return "YI_SYLLABLE_JY";
        case   0xA3F9: return "YI_SYLLABLE_JYP";
        case   0xA3FA: return "YI_SYLLABLE_JYRX";
        case   0xA3FB: return "YI_SYLLABLE_JYR";
        case   0xA3FC: return "YI_SYLLABLE_QIT";
        case   0xA3FD: return "YI_SYLLABLE_QIX";
        case   0xA3FE: return "YI_SYLLABLE_QI";
        case   0xA3FF: return "YI_SYLLABLE_QIP";
        case   0xA400: return "YI_SYLLABLE_QIET";
        case   0xA401: return "YI_SYLLABLE_QIEX";
        case   0xA402: return "YI_SYLLABLE_QIE";
        case   0xA403: return "YI_SYLLABLE_QIEP";
        case   0xA404: return "YI_SYLLABLE_QUOT";
        case   0xA405: return "YI_SYLLABLE_QUOX";
        case   0xA406: return "YI_SYLLABLE_QUO";
        case   0xA407: return "YI_SYLLABLE_QUOP";
        case   0xA408: return "YI_SYLLABLE_QOT";
        case   0xA409: return "YI_SYLLABLE_QOX";
        case   0xA40A: return "YI_SYLLABLE_QO";
        case   0xA40B: return "YI_SYLLABLE_QOP";
        case   0xA40C: return "YI_SYLLABLE_QUT";
        case   0xA40D: return "YI_SYLLABLE_QUX";
        case   0xA40E: return "YI_SYLLABLE_QU";
        case   0xA40F: return "YI_SYLLABLE_QUP";
        case   0xA410: return "YI_SYLLABLE_QURX";
        case   0xA411: return "YI_SYLLABLE_QUR";
        case   0xA412: return "YI_SYLLABLE_QYT";
        case   0xA413: return "YI_SYLLABLE_QYX";
        case   0xA414: return "YI_SYLLABLE_QY";
        case   0xA415: return "YI_SYLLABLE_QYP";
        case   0xA416: return "YI_SYLLABLE_QYRX";
        case   0xA417: return "YI_SYLLABLE_QYR";
        case   0xA418: return "YI_SYLLABLE_JJIT";
        case   0xA419: return "YI_SYLLABLE_JJIX";
        case   0xA41A: return "YI_SYLLABLE_JJI";
        case   0xA41B: return "YI_SYLLABLE_JJIP";
        case   0xA41C: return "YI_SYLLABLE_JJIET";
        case   0xA41D: return "YI_SYLLABLE_JJIEX";
        case   0xA41E: return "YI_SYLLABLE_JJIE";
        case   0xA41F: return "YI_SYLLABLE_JJIEP";
        case   0xA420: return "YI_SYLLABLE_JJUOX";
        case   0xA421: return "YI_SYLLABLE_JJUO";
        case   0xA422: return "YI_SYLLABLE_JJUOP";
        case   0xA423: return "YI_SYLLABLE_JJOT";
        case   0xA424: return "YI_SYLLABLE_JJOX";
        case   0xA425: return "YI_SYLLABLE_JJO";
        case   0xA426: return "YI_SYLLABLE_JJOP";
        case   0xA427: return "YI_SYLLABLE_JJUT";
        case   0xA428: return "YI_SYLLABLE_JJUX";
        case   0xA429: return "YI_SYLLABLE_JJU";
        case   0xA42A: return "YI_SYLLABLE_JJUP";
        case   0xA42B: return "YI_SYLLABLE_JJURX";
        case   0xA42C: return "YI_SYLLABLE_JJUR";
        case   0xA42D: return "YI_SYLLABLE_JJYT";
        case   0xA42E: return "YI_SYLLABLE_JJYX";
        case   0xA42F: return "YI_SYLLABLE_JJY";
        case   0xA430: return "YI_SYLLABLE_JJYP";
        case   0xA431: return "YI_SYLLABLE_NJIT";
        case   0xA432: return "YI_SYLLABLE_NJIX";
        case   0xA433: return "YI_SYLLABLE_NJI";
        case   0xA434: return "YI_SYLLABLE_NJIP";
        case   0xA435: return "YI_SYLLABLE_NJIET";
        case   0xA436: return "YI_SYLLABLE_NJIEX";
        case   0xA437: return "YI_SYLLABLE_NJIE";
        case   0xA438: return "YI_SYLLABLE_NJIEP";
        case   0xA439: return "YI_SYLLABLE_NJUOX";
        case   0xA43A: return "YI_SYLLABLE_NJUO";
        case   0xA43B: return "YI_SYLLABLE_NJOT";
        case   0xA43C: return "YI_SYLLABLE_NJOX";
        case   0xA43D: return "YI_SYLLABLE_NJO";
        case   0xA43E: return "YI_SYLLABLE_NJOP";
        case   0xA43F: return "YI_SYLLABLE_NJUX";
        case   0xA440: return "YI_SYLLABLE_NJU";
        case   0xA441: return "YI_SYLLABLE_NJUP";
        case   0xA442: return "YI_SYLLABLE_NJURX";
        case   0xA443: return "YI_SYLLABLE_NJUR";
        case   0xA444: return "YI_SYLLABLE_NJYT";
        case   0xA445: return "YI_SYLLABLE_NJYX";
        case   0xA446: return "YI_SYLLABLE_NJY";
        case   0xA447: return "YI_SYLLABLE_NJYP";
        case   0xA448: return "YI_SYLLABLE_NJYRX";
        case   0xA449: return "YI_SYLLABLE_NJYR";
        case   0xA44A: return "YI_SYLLABLE_NYIT";
        case   0xA44B: return "YI_SYLLABLE_NYIX";
        case   0xA44C: return "YI_SYLLABLE_NYI";
        case   0xA44D: return "YI_SYLLABLE_NYIP";
        case   0xA44E: return "YI_SYLLABLE_NYIET";
        case   0xA44F: return "YI_SYLLABLE_NYIEX";
        case   0xA450: return "YI_SYLLABLE_NYIE";
        case   0xA451: return "YI_SYLLABLE_NYIEP";
        case   0xA452: return "YI_SYLLABLE_NYUOX";
        case   0xA453: return "YI_SYLLABLE_NYUO";
        case   0xA454: return "YI_SYLLABLE_NYUOP";
        case   0xA455: return "YI_SYLLABLE_NYOT";
        case   0xA456: return "YI_SYLLABLE_NYOX";
        case   0xA457: return "YI_SYLLABLE_NYO";
        case   0xA458: return "YI_SYLLABLE_NYOP";
        case   0xA459: return "YI_SYLLABLE_NYUT";
        case   0xA45A: return "YI_SYLLABLE_NYUX";
        case   0xA45B: return "YI_SYLLABLE_NYU";
        case   0xA45C: return "YI_SYLLABLE_NYUP";
        case   0xA45D: return "YI_SYLLABLE_XIT";
        case   0xA45E: return "YI_SYLLABLE_XIX";
        case   0xA45F: return "YI_SYLLABLE_XI";
        case   0xA460: return "YI_SYLLABLE_XIP";
        case   0xA461: return "YI_SYLLABLE_XIET";
        case   0xA462: return "YI_SYLLABLE_XIEX";
        case   0xA463: return "YI_SYLLABLE_XIE";
        case   0xA464: return "YI_SYLLABLE_XIEP";
        case   0xA465: return "YI_SYLLABLE_XUOX";
        case   0xA466: return "YI_SYLLABLE_XUO";
        case   0xA467: return "YI_SYLLABLE_XOT";
        case   0xA468: return "YI_SYLLABLE_XOX";
        case   0xA469: return "YI_SYLLABLE_XO";
        case   0xA46A: return "YI_SYLLABLE_XOP";
        case   0xA46B: return "YI_SYLLABLE_XYT";
        case   0xA46C: return "YI_SYLLABLE_XYX";
        case   0xA46D: return "YI_SYLLABLE_XY";
        case   0xA46E: return "YI_SYLLABLE_XYP";
        case   0xA46F: return "YI_SYLLABLE_XYRX";
        case   0xA470: return "YI_SYLLABLE_XYR";
        case   0xA471: return "YI_SYLLABLE_YIT";
        case   0xA472: return "YI_SYLLABLE_YIX";
        case   0xA473: return "YI_SYLLABLE_YI";
        case   0xA474: return "YI_SYLLABLE_YIP";
        case   0xA475: return "YI_SYLLABLE_YIET";
        case   0xA476: return "YI_SYLLABLE_YIEX";
        case   0xA477: return "YI_SYLLABLE_YIE";
        case   0xA478: return "YI_SYLLABLE_YIEP";
        case   0xA479: return "YI_SYLLABLE_YUOT";
        case   0xA47A: return "YI_SYLLABLE_YUOX";
        case   0xA47B: return "YI_SYLLABLE_YUO";
        case   0xA47C: return "YI_SYLLABLE_YUOP";
        case   0xA47D: return "YI_SYLLABLE_YOT";
        case   0xA47E: return "YI_SYLLABLE_YOX";
        case   0xA47F: return "YI_SYLLABLE_YO";
        case   0xA480: return "YI_SYLLABLE_YOP";
        case   0xA481: return "YI_SYLLABLE_YUT";
        case   0xA482: return "YI_SYLLABLE_YUX";
        case   0xA483: return "YI_SYLLABLE_YU";
        case   0xA484: return "YI_SYLLABLE_YUP";
        case   0xA485: return "YI_SYLLABLE_YURX";
        case   0xA486: return "YI_SYLLABLE_YUR";
        case   0xA487: return "YI_SYLLABLE_YYT";
        case   0xA488: return "YI_SYLLABLE_YYX";
        case   0xA489: return "YI_SYLLABLE_YY";
        case   0xA48A: return "YI_SYLLABLE_YYP";
        case   0xA48B: return "YI_SYLLABLE_YYRX";
        case   0xA48C: return "YI_SYLLABLE_YYR";
        case   0xA490: return "YI_RADICAL_QOT";
        case   0xA491: return "YI_RADICAL_LI";
        case   0xA492: return "YI_RADICAL_KIT";
        case   0xA493: return "YI_RADICAL_NYIP";
        case   0xA494: return "YI_RADICAL_CYP";
        case   0xA495: return "YI_RADICAL_SSI";
        case   0xA496: return "YI_RADICAL_GGOP";
        case   0xA497: return "YI_RADICAL_GEP";
        case   0xA498: return "YI_RADICAL_MI";
        case   0xA499: return "YI_RADICAL_HXIT";
        case   0xA49A: return "YI_RADICAL_LYR";
        case   0xA49B: return "YI_RADICAL_BBUT";
        case   0xA49C: return "YI_RADICAL_MOP";
        case   0xA49D: return "YI_RADICAL_YO";
        case   0xA49E: return "YI_RADICAL_PUT";
        case   0xA49F: return "YI_RADICAL_HXUO";
        case   0xA4A0: return "YI_RADICAL_TAT";
        case   0xA4A1: return "YI_RADICAL_GA";
        case   0xA4A2: return "YI_RADICAL_ZUP";
        case   0xA4A3: return "YI_RADICAL_CYT";
        case   0xA4A4: return "YI_RADICAL_DDUR";
        case   0xA4A5: return "YI_RADICAL_BUR";
        case   0xA4A6: return "YI_RADICAL_GGUO";
        case   0xA4A7: return "YI_RADICAL_NYOP";
        case   0xA4A8: return "YI_RADICAL_TU";
        case   0xA4A9: return "YI_RADICAL_OP";
        case   0xA4AA: return "YI_RADICAL_JJUT";
        case   0xA4AB: return "YI_RADICAL_ZOT";
        case   0xA4AC: return "YI_RADICAL_PYT";
        case   0xA4AD: return "YI_RADICAL_HMO";
        case   0xA4AE: return "YI_RADICAL_YIT";
        case   0xA4AF: return "YI_RADICAL_VUR";
        case   0xA4B0: return "YI_RADICAL_SHY";
        case   0xA4B1: return "YI_RADICAL_VEP";
        case   0xA4B2: return "YI_RADICAL_ZA";
        case   0xA4B3: return "YI_RADICAL_JO";
        case   0xA4B4: return "YI_RADICAL_NZUP";
        case   0xA4B5: return "YI_RADICAL_JJY";
        case   0xA4B6: return "YI_RADICAL_GOT";
        case   0xA4B7: return "YI_RADICAL_JJIE";
        case   0xA4B8: return "YI_RADICAL_WO";
        case   0xA4B9: return "YI_RADICAL_DU";
        case   0xA4BA: return "YI_RADICAL_SHUR";
        case   0xA4BB: return "YI_RADICAL_LIE";
        case   0xA4BC: return "YI_RADICAL_CY";
        case   0xA4BD: return "YI_RADICAL_CUOP";
        case   0xA4BE: return "YI_RADICAL_CIP";
        case   0xA4BF: return "YI_RADICAL_HXOP";
        case   0xA4C0: return "YI_RADICAL_SHAT";
        case   0xA4C1: return "YI_RADICAL_ZUR";
        case   0xA4C2: return "YI_RADICAL_SHOP";
        case   0xA4C3: return "YI_RADICAL_CHE";
        case   0xA4C4: return "YI_RADICAL_ZZIET";
        case   0xA4C5: return "YI_RADICAL_NBIE";
        case   0xA4C6: return "YI_RADICAL_KE";
        case   0xA4D0: return "LISU_LETTER_BA";
        case   0xA4D1: return "LISU_LETTER_PA";
        case   0xA4D2: return "LISU_LETTER_PHA";
        case   0xA4D3: return "LISU_LETTER_DA";
        case   0xA4D4: return "LISU_LETTER_TA";
        case   0xA4D5: return "LISU_LETTER_THA";
        case   0xA4D6: return "LISU_LETTER_GA";
        case   0xA4D7: return "LISU_LETTER_KA";
        case   0xA4D8: return "LISU_LETTER_KHA";
        case   0xA4D9: return "LISU_LETTER_JA";
        case   0xA4DA: return "LISU_LETTER_CA";
        case   0xA4DB: return "LISU_LETTER_CHA";
        case   0xA4DC: return "LISU_LETTER_DZA";
        case   0xA4DD: return "LISU_LETTER_TSA";
        case   0xA4DE: return "LISU_LETTER_TSHA";
        case   0xA4DF: return "LISU_LETTER_MA";
        case   0xA4E0: return "LISU_LETTER_NA";
        case   0xA4E1: return "LISU_LETTER_LA";
        case   0xA4E2: return "LISU_LETTER_SA";
        case   0xA4E3: return "LISU_LETTER_ZHA";
        case   0xA4E4: return "LISU_LETTER_ZA";
        case   0xA4E5: return "LISU_LETTER_NGA";
        case   0xA4E6: return "LISU_LETTER_HA";
        case   0xA4E7: return "LISU_LETTER_XA";
        case   0xA4E8: return "LISU_LETTER_HHA";
        case   0xA4E9: return "LISU_LETTER_FA";
        case   0xA4EA: return "LISU_LETTER_WA";
        case   0xA4EB: return "LISU_LETTER_SHA";
        case   0xA4EC: return "LISU_LETTER_YA";
        case   0xA4ED: return "LISU_LETTER_GHA";
        case   0xA4EE: return "LISU_LETTER_A";
        case   0xA4EF: return "LISU_LETTER_AE";
        case   0xA4F0: return "LISU_LETTER_E";
        case   0xA4F1: return "LISU_LETTER_EU";
        case   0xA4F2: return "LISU_LETTER_I";
        case   0xA4F3: return "LISU_LETTER_O";
        case   0xA4F4: return "LISU_LETTER_U";
        case   0xA4F5: return "LISU_LETTER_UE";
        case   0xA4F6: return "LISU_LETTER_UH";
        case   0xA4F7: return "LISU_LETTER_OE";
        case   0xA4F8: return "LISU_LETTER_TONE_MYA_TI";
        case   0xA4F9: return "LISU_LETTER_TONE_NA_PO";
        case   0xA4FA: return "LISU_LETTER_TONE_MYA_CYA";
        case   0xA4FB: return "LISU_LETTER_TONE_MYA_BO";
        case   0xA4FC: return "LISU_LETTER_TONE_MYA_NA";
        case   0xA4FD: return "LISU_LETTER_TONE_MYA_JEU";
        case   0xA4FE: return "LISU_PUNCTUATION_COMMA";
        case   0xA4FF: return "LISU_PUNCTUATION_FULL_STOP";
        case   0xA500: return "VAI_SYLLABLE_EE";
        case   0xA501: return "VAI_SYLLABLE_EEN";
        case   0xA502: return "VAI_SYLLABLE_HEE";
        case   0xA503: return "VAI_SYLLABLE_WEE";
        case   0xA504: return "VAI_SYLLABLE_WEEN";
        case   0xA505: return "VAI_SYLLABLE_PEE";
        case   0xA506: return "VAI_SYLLABLE_BHEE";
        case   0xA507: return "VAI_SYLLABLE_BEE";
        case   0xA508: return "VAI_SYLLABLE_MBEE";
        case   0xA509: return "VAI_SYLLABLE_KPEE";
        case   0xA50A: return "VAI_SYLLABLE_MGBEE";
        case   0xA50B: return "VAI_SYLLABLE_GBEE";
        case   0xA50C: return "VAI_SYLLABLE_FEE";
        case   0xA50D: return "VAI_SYLLABLE_VEE";
        case   0xA50E: return "VAI_SYLLABLE_TEE";
        case   0xA50F: return "VAI_SYLLABLE_THEE";
        case   0xA510: return "VAI_SYLLABLE_DHEE";
        case   0xA511: return "VAI_SYLLABLE_DHHEE";
        case   0xA512: return "VAI_SYLLABLE_LEE";
        case   0xA513: return "VAI_SYLLABLE_REE";
        case   0xA514: return "VAI_SYLLABLE_DEE";
        case   0xA515: return "VAI_SYLLABLE_NDEE";
        case   0xA516: return "VAI_SYLLABLE_SEE";
        case   0xA517: return "VAI_SYLLABLE_SHEE";
        case   0xA518: return "VAI_SYLLABLE_ZEE";
        case   0xA519: return "VAI_SYLLABLE_ZHEE";
        case   0xA51A: return "VAI_SYLLABLE_CEE";
        case   0xA51B: return "VAI_SYLLABLE_JEE";
        case   0xA51C: return "VAI_SYLLABLE_NJEE";
        case   0xA51D: return "VAI_SYLLABLE_YEE";
        case   0xA51E: return "VAI_SYLLABLE_KEE";
        case   0xA51F: return "VAI_SYLLABLE_NGGEE";
        case   0xA520: return "VAI_SYLLABLE_GEE";
        case   0xA521: return "VAI_SYLLABLE_MEE";
        case   0xA522: return "VAI_SYLLABLE_NEE";
        case   0xA523: return "VAI_SYLLABLE_NYEE";
        case   0xA524: return "VAI_SYLLABLE_I";
        case   0xA525: return "VAI_SYLLABLE_IN";
        case   0xA526: return "VAI_SYLLABLE_HI";
        case   0xA527: return "VAI_SYLLABLE_HIN";
        case   0xA528: return "VAI_SYLLABLE_WI";
        case   0xA529: return "VAI_SYLLABLE_WIN";
        case   0xA52A: return "VAI_SYLLABLE_PI";
        case   0xA52B: return "VAI_SYLLABLE_BHI";
        case   0xA52C: return "VAI_SYLLABLE_BI";
        case   0xA52D: return "VAI_SYLLABLE_MBI";
        case   0xA52E: return "VAI_SYLLABLE_KPI";
        case   0xA52F: return "VAI_SYLLABLE_MGBI";
        case   0xA530: return "VAI_SYLLABLE_GBI";
        case   0xA531: return "VAI_SYLLABLE_FI";
        case   0xA532: return "VAI_SYLLABLE_VI";
        case   0xA533: return "VAI_SYLLABLE_TI";
        case   0xA534: return "VAI_SYLLABLE_THI";
        case   0xA535: return "VAI_SYLLABLE_DHI";
        case   0xA536: return "VAI_SYLLABLE_DHHI";
        case   0xA537: return "VAI_SYLLABLE_LI";
        case   0xA538: return "VAI_SYLLABLE_RI";
        case   0xA539: return "VAI_SYLLABLE_DI";
        case   0xA53A: return "VAI_SYLLABLE_NDI";
        case   0xA53B: return "VAI_SYLLABLE_SI";
        case   0xA53C: return "VAI_SYLLABLE_SHI";
        case   0xA53D: return "VAI_SYLLABLE_ZI";
        case   0xA53E: return "VAI_SYLLABLE_ZHI";
        case   0xA53F: return "VAI_SYLLABLE_CI";
        case   0xA540: return "VAI_SYLLABLE_JI";
        case   0xA541: return "VAI_SYLLABLE_NJI";
        case   0xA542: return "VAI_SYLLABLE_YI";
        case   0xA543: return "VAI_SYLLABLE_KI";
        case   0xA544: return "VAI_SYLLABLE_NGGI";
        case   0xA545: return "VAI_SYLLABLE_GI";
        case   0xA546: return "VAI_SYLLABLE_MI";
        case   0xA547: return "VAI_SYLLABLE_NI";
        case   0xA548: return "VAI_SYLLABLE_NYI";
        case   0xA549: return "VAI_SYLLABLE_A";
        case   0xA54A: return "VAI_SYLLABLE_AN";
        case   0xA54B: return "VAI_SYLLABLE_NGAN";
        case   0xA54C: return "VAI_SYLLABLE_HA";
        case   0xA54D: return "VAI_SYLLABLE_HAN";
        case   0xA54E: return "VAI_SYLLABLE_WA";
        case   0xA54F: return "VAI_SYLLABLE_WAN";
        case   0xA550: return "VAI_SYLLABLE_PA";
        case   0xA551: return "VAI_SYLLABLE_BHA";
        case   0xA552: return "VAI_SYLLABLE_BA";
        case   0xA553: return "VAI_SYLLABLE_MBA";
        case   0xA554: return "VAI_SYLLABLE_KPA";
        case   0xA555: return "VAI_SYLLABLE_KPAN";
        case   0xA556: return "VAI_SYLLABLE_MGBA";
        case   0xA557: return "VAI_SYLLABLE_GBA";
        case   0xA558: return "VAI_SYLLABLE_FA";
        case   0xA559: return "VAI_SYLLABLE_VA";
        case   0xA55A: return "VAI_SYLLABLE_TA";
        case   0xA55B: return "VAI_SYLLABLE_THA";
        case   0xA55C: return "VAI_SYLLABLE_DHA";
        case   0xA55D: return "VAI_SYLLABLE_DHHA";
        case   0xA55E: return "VAI_SYLLABLE_LA";
        case   0xA55F: return "VAI_SYLLABLE_RA";
        case   0xA560: return "VAI_SYLLABLE_DA";
        case   0xA561: return "VAI_SYLLABLE_NDA";
        case   0xA562: return "VAI_SYLLABLE_SA";
        case   0xA563: return "VAI_SYLLABLE_SHA";
        case   0xA564: return "VAI_SYLLABLE_ZA";
        case   0xA565: return "VAI_SYLLABLE_ZHA";
        case   0xA566: return "VAI_SYLLABLE_CA";
        case   0xA567: return "VAI_SYLLABLE_JA";
        case   0xA568: return "VAI_SYLLABLE_NJA";
        case   0xA569: return "VAI_SYLLABLE_YA";
        case   0xA56A: return "VAI_SYLLABLE_KA";
        case   0xA56B: return "VAI_SYLLABLE_KAN";
        case   0xA56C: return "VAI_SYLLABLE_NGGA";
        case   0xA56D: return "VAI_SYLLABLE_GA";
        case   0xA56E: return "VAI_SYLLABLE_MA";
        case   0xA56F: return "VAI_SYLLABLE_NA";
        case   0xA570: return "VAI_SYLLABLE_NYA";
        case   0xA571: return "VAI_SYLLABLE_OO";
        case   0xA572: return "VAI_SYLLABLE_OON";
        case   0xA573: return "VAI_SYLLABLE_HOO";
        case   0xA574: return "VAI_SYLLABLE_WOO";
        case   0xA575: return "VAI_SYLLABLE_WOON";
        case   0xA576: return "VAI_SYLLABLE_POO";
        case   0xA577: return "VAI_SYLLABLE_BHOO";
        case   0xA578: return "VAI_SYLLABLE_BOO";
        case   0xA579: return "VAI_SYLLABLE_MBOO";
        case   0xA57A: return "VAI_SYLLABLE_KPOO";
        case   0xA57B: return "VAI_SYLLABLE_MGBOO";
        case   0xA57C: return "VAI_SYLLABLE_GBOO";
        case   0xA57D: return "VAI_SYLLABLE_FOO";
        case   0xA57E: return "VAI_SYLLABLE_VOO";
        case   0xA57F: return "VAI_SYLLABLE_TOO";
        case   0xA580: return "VAI_SYLLABLE_THOO";
        case   0xA581: return "VAI_SYLLABLE_DHOO";
        case   0xA582: return "VAI_SYLLABLE_DHHOO";
        case   0xA583: return "VAI_SYLLABLE_LOO";
        case   0xA584: return "VAI_SYLLABLE_ROO";
        case   0xA585: return "VAI_SYLLABLE_DOO";
        case   0xA586: return "VAI_SYLLABLE_NDOO";
        case   0xA587: return "VAI_SYLLABLE_SOO";
        case   0xA588: return "VAI_SYLLABLE_SHOO";
        case   0xA589: return "VAI_SYLLABLE_ZOO";
        case   0xA58A: return "VAI_SYLLABLE_ZHOO";
        case   0xA58B: return "VAI_SYLLABLE_COO";
        case   0xA58C: return "VAI_SYLLABLE_JOO";
        case   0xA58D: return "VAI_SYLLABLE_NJOO";
        case   0xA58E: return "VAI_SYLLABLE_YOO";
        case   0xA58F: return "VAI_SYLLABLE_KOO";
        case   0xA590: return "VAI_SYLLABLE_NGGOO";
        case   0xA591: return "VAI_SYLLABLE_GOO";
        case   0xA592: return "VAI_SYLLABLE_MOO";
        case   0xA593: return "VAI_SYLLABLE_NOO";
        case   0xA594: return "VAI_SYLLABLE_NYOO";
        case   0xA595: return "VAI_SYLLABLE_U";
        case   0xA596: return "VAI_SYLLABLE_UN";
        case   0xA597: return "VAI_SYLLABLE_HU";
        case   0xA598: return "VAI_SYLLABLE_HUN";
        case   0xA599: return "VAI_SYLLABLE_WU";
        case   0xA59A: return "VAI_SYLLABLE_WUN";
        case   0xA59B: return "VAI_SYLLABLE_PU";
        case   0xA59C: return "VAI_SYLLABLE_BHU";
        case   0xA59D: return "VAI_SYLLABLE_BU";
        case   0xA59E: return "VAI_SYLLABLE_MBU";
        case   0xA59F: return "VAI_SYLLABLE_KPU";
        case   0xA5A0: return "VAI_SYLLABLE_MGBU";
        case   0xA5A1: return "VAI_SYLLABLE_GBU";
        case   0xA5A2: return "VAI_SYLLABLE_FU";
        case   0xA5A3: return "VAI_SYLLABLE_VU";
        case   0xA5A4: return "VAI_SYLLABLE_TU";
        case   0xA5A5: return "VAI_SYLLABLE_THU";
        case   0xA5A6: return "VAI_SYLLABLE_DHU";
        case   0xA5A7: return "VAI_SYLLABLE_DHHU";
        case   0xA5A8: return "VAI_SYLLABLE_LU";
        case   0xA5A9: return "VAI_SYLLABLE_RU";
        case   0xA5AA: return "VAI_SYLLABLE_DU";
        case   0xA5AB: return "VAI_SYLLABLE_NDU";
        case   0xA5AC: return "VAI_SYLLABLE_SU";
        case   0xA5AD: return "VAI_SYLLABLE_SHU";
        case   0xA5AE: return "VAI_SYLLABLE_ZU";
        case   0xA5AF: return "VAI_SYLLABLE_ZHU";
        case   0xA5B0: return "VAI_SYLLABLE_CU";
        case   0xA5B1: return "VAI_SYLLABLE_JU";
        case   0xA5B2: return "VAI_SYLLABLE_NJU";
        case   0xA5B3: return "VAI_SYLLABLE_YU";
        case   0xA5B4: return "VAI_SYLLABLE_KU";
        case   0xA5B5: return "VAI_SYLLABLE_NGGU";
        case   0xA5B6: return "VAI_SYLLABLE_GU";
        case   0xA5B7: return "VAI_SYLLABLE_MU";
        case   0xA5B8: return "VAI_SYLLABLE_NU";
        case   0xA5B9: return "VAI_SYLLABLE_NYU";
        case   0xA5BA: return "VAI_SYLLABLE_O";
        case   0xA5BB: return "VAI_SYLLABLE_ON";
        case   0xA5BC: return "VAI_SYLLABLE_NGON";
        case   0xA5BD: return "VAI_SYLLABLE_HO";
        case   0xA5BE: return "VAI_SYLLABLE_HON";
        case   0xA5BF: return "VAI_SYLLABLE_WO";
        case   0xA5C0: return "VAI_SYLLABLE_WON";
        case   0xA5C1: return "VAI_SYLLABLE_PO";
        case   0xA5C2: return "VAI_SYLLABLE_BHO";
        case   0xA5C3: return "VAI_SYLLABLE_BO";
        case   0xA5C4: return "VAI_SYLLABLE_MBO";
        case   0xA5C5: return "VAI_SYLLABLE_KPO";
        case   0xA5C6: return "VAI_SYLLABLE_MGBO";
        case   0xA5C7: return "VAI_SYLLABLE_GBO";
        case   0xA5C8: return "VAI_SYLLABLE_GBON";
        case   0xA5C9: return "VAI_SYLLABLE_FO";
        case   0xA5CA: return "VAI_SYLLABLE_VO";
        case   0xA5CB: return "VAI_SYLLABLE_TO";
        case   0xA5CC: return "VAI_SYLLABLE_THO";
        case   0xA5CD: return "VAI_SYLLABLE_DHO";
        case   0xA5CE: return "VAI_SYLLABLE_DHHO";
        case   0xA5CF: return "VAI_SYLLABLE_LO";
        case   0xA5D0: return "VAI_SYLLABLE_RO";
        case   0xA5D1: return "VAI_SYLLABLE_DO";
        case   0xA5D2: return "VAI_SYLLABLE_NDO";
        case   0xA5D3: return "VAI_SYLLABLE_SO";
        case   0xA5D4: return "VAI_SYLLABLE_SHO";
        case   0xA5D5: return "VAI_SYLLABLE_ZO";
        case   0xA5D6: return "VAI_SYLLABLE_ZHO";
        case   0xA5D7: return "VAI_SYLLABLE_CO";
        case   0xA5D8: return "VAI_SYLLABLE_JO";
        case   0xA5D9: return "VAI_SYLLABLE_NJO";
        case   0xA5DA: return "VAI_SYLLABLE_YO";
        case   0xA5DB: return "VAI_SYLLABLE_KO";
        case   0xA5DC: return "VAI_SYLLABLE_NGGO";
        case   0xA5DD: return "VAI_SYLLABLE_GO";
        case   0xA5DE: return "VAI_SYLLABLE_MO";
        case   0xA5DF: return "VAI_SYLLABLE_NO";
        case   0xA5E0: return "VAI_SYLLABLE_NYO";
        case   0xA5E1: return "VAI_SYLLABLE_E";
        case   0xA5E2: return "VAI_SYLLABLE_EN";
        case   0xA5E3: return "VAI_SYLLABLE_NGEN";
        case   0xA5E4: return "VAI_SYLLABLE_HE";
        case   0xA5E5: return "VAI_SYLLABLE_HEN";
        case   0xA5E6: return "VAI_SYLLABLE_WE";
        case   0xA5E7: return "VAI_SYLLABLE_WEN";
        case   0xA5E8: return "VAI_SYLLABLE_PE";
        case   0xA5E9: return "VAI_SYLLABLE_BHE";
        case   0xA5EA: return "VAI_SYLLABLE_BE";
        case   0xA5EB: return "VAI_SYLLABLE_MBE";
        case   0xA5EC: return "VAI_SYLLABLE_KPE";
        case   0xA5ED: return "VAI_SYLLABLE_KPEN";
        case   0xA5EE: return "VAI_SYLLABLE_MGBE";
        case   0xA5EF: return "VAI_SYLLABLE_GBE";
        case   0xA5F0: return "VAI_SYLLABLE_GBEN";
        case   0xA5F1: return "VAI_SYLLABLE_FE";
        case   0xA5F2: return "VAI_SYLLABLE_VE";
        case   0xA5F3: return "VAI_SYLLABLE_TE";
        case   0xA5F4: return "VAI_SYLLABLE_THE";
        case   0xA5F5: return "VAI_SYLLABLE_DHE";
        case   0xA5F6: return "VAI_SYLLABLE_DHHE";
        case   0xA5F7: return "VAI_SYLLABLE_LE";
        case   0xA5F8: return "VAI_SYLLABLE_RE";
        case   0xA5F9: return "VAI_SYLLABLE_DE";
        case   0xA5FA: return "VAI_SYLLABLE_NDE";
        case   0xA5FB: return "VAI_SYLLABLE_SE";
        case   0xA5FC: return "VAI_SYLLABLE_SHE";
        case   0xA5FD: return "VAI_SYLLABLE_ZE";
        case   0xA5FE: return "VAI_SYLLABLE_ZHE";
        case   0xA5FF: return "VAI_SYLLABLE_CE";
        case   0xA600: return "VAI_SYLLABLE_JE";
        case   0xA601: return "VAI_SYLLABLE_NJE";
        case   0xA602: return "VAI_SYLLABLE_YE";
        case   0xA603: return "VAI_SYLLABLE_KE";
        case   0xA604: return "VAI_SYLLABLE_NGGE";
        case   0xA605: return "VAI_SYLLABLE_NGGEN";
        case   0xA606: return "VAI_SYLLABLE_GE";
        case   0xA607: return "VAI_SYLLABLE_GEN";
        case   0xA608: return "VAI_SYLLABLE_ME";
        case   0xA609: return "VAI_SYLLABLE_NE";
        case   0xA60A: return "VAI_SYLLABLE_NYE";
        case   0xA60B: return "VAI_SYLLABLE_NG";
        case   0xA60C: return "VAI_SYLLABLE_LENGTHENER";
        case   0xA60D: return "VAI_COMMA";
        case   0xA60E: return "VAI_FULL_STOP";
        case   0xA60F: return "VAI_QUESTION_MARK";
        case   0xA610: return "VAI_SYLLABLE_NDOLE_FA";
        case   0xA611: return "VAI_SYLLABLE_NDOLE_KA";
        case   0xA612: return "VAI_SYLLABLE_NDOLE_SOO";
        case   0xA613: return "VAI_SYMBOL_FEENG";
        case   0xA614: return "VAI_SYMBOL_KEENG";
        case   0xA615: return "VAI_SYMBOL_TING";
        case   0xA616: return "VAI_SYMBOL_NII";
        case   0xA617: return "VAI_SYMBOL_BANG";
        case   0xA618: return "VAI_SYMBOL_FAA";
        case   0xA619: return "VAI_SYMBOL_TAA";
        case   0xA61A: return "VAI_SYMBOL_DANG";
        case   0xA61B: return "VAI_SYMBOL_DOONG";
        case   0xA61C: return "VAI_SYMBOL_KUNG";
        case   0xA61D: return "VAI_SYMBOL_TONG";
        case   0xA61E: return "VAI_SYMBOL_DO_O";
        case   0xA61F: return "VAI_SYMBOL_JONG";
        case   0xA620: return "VAI_DIGIT_ZERO";
        case   0xA621: return "VAI_DIGIT_ONE";
        case   0xA622: return "VAI_DIGIT_TWO";
        case   0xA623: return "VAI_DIGIT_THREE";
        case   0xA624: return "VAI_DIGIT_FOUR";
        case   0xA625: return "VAI_DIGIT_FIVE";
        case   0xA626: return "VAI_DIGIT_SIX";
        case   0xA627: return "VAI_DIGIT_SEVEN";
        case   0xA628: return "VAI_DIGIT_EIGHT";
        case   0xA629: return "VAI_DIGIT_NINE";
        case   0xA62A: return "VAI_SYLLABLE_NDOLE_MA";
        case   0xA62B: return "VAI_SYLLABLE_NDOLE_DO";
        case   0xA640: return "CYRILLIC_CAPITAL_LETTER_ZEMLYA";
        case   0xA641: return "CYRILLIC_SMALL_LETTER_ZEMLYA";
        case   0xA642: return "CYRILLIC_CAPITAL_LETTER_DZELO";
        case   0xA643: return "CYRILLIC_SMALL_LETTER_DZELO";
        case   0xA644: return "CYRILLIC_CAPITAL_LETTER_REVERSED_DZE";
        case   0xA645: return "CYRILLIC_SMALL_LETTER_REVERSED_DZE";
        case   0xA646: return "CYRILLIC_CAPITAL_LETTER_IOTA";
        case   0xA647: return "CYRILLIC_SMALL_LETTER_IOTA";
        case   0xA648: return "CYRILLIC_CAPITAL_LETTER_DJERV";
        case   0xA649: return "CYRILLIC_SMALL_LETTER_DJERV";
        case   0xA64A: return "CYRILLIC_CAPITAL_LETTER_MONOGRAPH_UK";
        case   0xA64B: return "CYRILLIC_SMALL_LETTER_MONOGRAPH_UK";
        case   0xA64C: return "CYRILLIC_CAPITAL_LETTER_BROAD_OMEGA";
        case   0xA64D: return "CYRILLIC_SMALL_LETTER_BROAD_OMEGA";
        case   0xA64E: return "CYRILLIC_CAPITAL_LETTER_NEUTRAL_YER";
        case   0xA64F: return "CYRILLIC_SMALL_LETTER_NEUTRAL_YER";
        case   0xA650: return "CYRILLIC_CAPITAL_LETTER_YERU_WITH_BACK_YER";
        case   0xA651: return "CYRILLIC_SMALL_LETTER_YERU_WITH_BACK_YER";
        case   0xA652: return "CYRILLIC_CAPITAL_LETTER_IOTIFIED_YAT";
        case   0xA653: return "CYRILLIC_SMALL_LETTER_IOTIFIED_YAT";
        case   0xA654: return "CYRILLIC_CAPITAL_LETTER_REVERSED_YU";
        case   0xA655: return "CYRILLIC_SMALL_LETTER_REVERSED_YU";
        case   0xA656: return "CYRILLIC_CAPITAL_LETTER_IOTIFIED_A";
        case   0xA657: return "CYRILLIC_SMALL_LETTER_IOTIFIED_A";
        case   0xA658: return "CYRILLIC_CAPITAL_LETTER_CLOSED_LITTLE_YUS";
        case   0xA659: return "CYRILLIC_SMALL_LETTER_CLOSED_LITTLE_YUS";
        case   0xA65A: return "CYRILLIC_CAPITAL_LETTER_BLENDED_YUS";
        case   0xA65B: return "CYRILLIC_SMALL_LETTER_BLENDED_YUS";
        case   0xA65C: return
                "CYRILLIC_CAPITAL_LETTER_IOTIFIED_CLOSED_LITTLE_YUS";
        case   0xA65D: return
                "CYRILLIC_SMALL_LETTER_IOTIFIED_CLOSED_LITTLE_YUS";
        case   0xA65E: return "CYRILLIC_CAPITAL_LETTER_YN";
        case   0xA65F: return "CYRILLIC_SMALL_LETTER_YN";
        case   0xA660: return "CYRILLIC_CAPITAL_LETTER_REVERSED_TSE";
        case   0xA661: return "CYRILLIC_SMALL_LETTER_REVERSED_TSE";
        case   0xA662: return "CYRILLIC_CAPITAL_LETTER_SOFT_DE";
        case   0xA663: return "CYRILLIC_SMALL_LETTER_SOFT_DE";
        case   0xA664: return "CYRILLIC_CAPITAL_LETTER_SOFT_EL";
        case   0xA665: return "CYRILLIC_SMALL_LETTER_SOFT_EL";
        case   0xA666: return "CYRILLIC_CAPITAL_LETTER_SOFT_EM";
        case   0xA667: return "CYRILLIC_SMALL_LETTER_SOFT_EM";
        case   0xA668: return "CYRILLIC_CAPITAL_LETTER_MONOCULAR_O";
        case   0xA669: return "CYRILLIC_SMALL_LETTER_MONOCULAR_O";
        case   0xA66A: return "CYRILLIC_CAPITAL_LETTER_BINOCULAR_O";
        case   0xA66B: return "CYRILLIC_SMALL_LETTER_BINOCULAR_O";
        case   0xA66C: return "CYRILLIC_CAPITAL_LETTER_DOUBLE_MONOCULAR_O";
        case   0xA66D: return "CYRILLIC_SMALL_LETTER_DOUBLE_MONOCULAR_O";
        case   0xA66E: return "CYRILLIC_LETTER_MULTIOCULAR_O";
        case   0xA66F: return "COMBINING_CYRILLIC_VZMET";
        case   0xA670: return "COMBINING_CYRILLIC_TEN_MILLIONS_SIGN";
        case   0xA671: return "COMBINING_CYRILLIC_HUNDRED_MILLIONS_SIGN";
        case   0xA672: return "COMBINING_CYRILLIC_THOUSAND_MILLIONS_SIGN";
        case   0xA673: return "SLAVONIC_ASTERISK";
        case   0xA674: return "COMBINING_CYRILLIC_LETTER_UKRAINIAN_IE";
        case   0xA675: return "COMBINING_CYRILLIC_LETTER_I";
        case   0xA676: return "COMBINING_CYRILLIC_LETTER_YI";
        case   0xA677: return "COMBINING_CYRILLIC_LETTER_U";
        case   0xA678: return "COMBINING_CYRILLIC_LETTER_HARD_SIGN";
        case   0xA679: return "COMBINING_CYRILLIC_LETTER_YERU";
        case   0xA67A: return "COMBINING_CYRILLIC_LETTER_SOFT_SIGN";
        case   0xA67B: return "COMBINING_CYRILLIC_LETTER_OMEGA";
        case   0xA67C: return "COMBINING_CYRILLIC_KAVYKA";
        case   0xA67D: return "COMBINING_CYRILLIC_PAYEROK";
        case   0xA67E: return "CYRILLIC_KAVYKA";
        case   0xA67F: return "CYRILLIC_PAYEROK";
        case   0xA680: return "CYRILLIC_CAPITAL_LETTER_DWE";
        case   0xA681: return "CYRILLIC_SMALL_LETTER_DWE";
        case   0xA682: return "CYRILLIC_CAPITAL_LETTER_DZWE";
        case   0xA683: return "CYRILLIC_SMALL_LETTER_DZWE";
        case   0xA684: return "CYRILLIC_CAPITAL_LETTER_ZHWE";
        case   0xA685: return "CYRILLIC_SMALL_LETTER_ZHWE";
        case   0xA686: return "CYRILLIC_CAPITAL_LETTER_CCHE";
        case   0xA687: return "CYRILLIC_SMALL_LETTER_CCHE";
        case   0xA688: return "CYRILLIC_CAPITAL_LETTER_DZZE";
        case   0xA689: return "CYRILLIC_SMALL_LETTER_DZZE";
        case   0xA68A: return "CYRILLIC_CAPITAL_LETTER_TE_WITH_MIDDLE_HOOK";
        case   0xA68B: return "CYRILLIC_SMALL_LETTER_TE_WITH_MIDDLE_HOOK";
        case   0xA68C: return "CYRILLIC_CAPITAL_LETTER_TWE";
        case   0xA68D: return "CYRILLIC_SMALL_LETTER_TWE";
        case   0xA68E: return "CYRILLIC_CAPITAL_LETTER_TSWE";
        case   0xA68F: return "CYRILLIC_SMALL_LETTER_TSWE";
        case   0xA690: return "CYRILLIC_CAPITAL_LETTER_TSSE";
        case   0xA691: return "CYRILLIC_SMALL_LETTER_TSSE";
        case   0xA692: return "CYRILLIC_CAPITAL_LETTER_TCHE";
        case   0xA693: return "CYRILLIC_SMALL_LETTER_TCHE";
        case   0xA694: return "CYRILLIC_CAPITAL_LETTER_HWE";
        case   0xA695: return "CYRILLIC_SMALL_LETTER_HWE";
        case   0xA696: return "CYRILLIC_CAPITAL_LETTER_SHWE";
        case   0xA697: return "CYRILLIC_SMALL_LETTER_SHWE";
        case   0xA698: return "CYRILLIC_CAPITAL_LETTER_DOUBLE_O";
        case   0xA699: return "CYRILLIC_SMALL_LETTER_DOUBLE_O";
        case   0xA69A: return "CYRILLIC_CAPITAL_LETTER_CROSSED_O";
        case   0xA69B: return "CYRILLIC_SMALL_LETTER_CROSSED_O";
        case   0xA69C: return "MODIFIER_LETTER_CYRILLIC_HARD_SIGN";
        case   0xA69D: return "MODIFIER_LETTER_CYRILLIC_SOFT_SIGN";
        case   0xA69F: return "COMBINING_CYRILLIC_LETTER_IOTIFIED_E";
        case   0xA6A0: return "BAMUM_LETTER_A";
        case   0xA6A1: return "BAMUM_LETTER_KA";
        case   0xA6A2: return "BAMUM_LETTER_U";
        case   0xA6A3: return "BAMUM_LETTER_KU";
        case   0xA6A4: return "BAMUM_LETTER_EE";
        case   0xA6A5: return "BAMUM_LETTER_REE";
        case   0xA6A6: return "BAMUM_LETTER_TAE";
        case   0xA6A7: return "BAMUM_LETTER_O";
        case   0xA6A8: return "BAMUM_LETTER_NYI";
        case   0xA6A9: return "BAMUM_LETTER_I";
        case   0xA6AA: return "BAMUM_LETTER_LA";
        case   0xA6AB: return "BAMUM_LETTER_PA";
        case   0xA6AC: return "BAMUM_LETTER_RII";
        case   0xA6AD: return "BAMUM_LETTER_RIEE";
        case   0xA6AE: return "BAMUM_LETTER_LEEEE";
        case   0xA6AF: return "BAMUM_LETTER_MEEEE";
        case   0xA6B0: return "BAMUM_LETTER_TAA";
        case   0xA6B1: return "BAMUM_LETTER_NDAA";
        case   0xA6B2: return "BAMUM_LETTER_NJAEM";
        case   0xA6B3: return "BAMUM_LETTER_M";
        case   0xA6B4: return "BAMUM_LETTER_SUU";
        case   0xA6B5: return "BAMUM_LETTER_MU";
        case   0xA6B6: return "BAMUM_LETTER_SHII";
        case   0xA6B7: return "BAMUM_LETTER_SI";
        case   0xA6B8: return "BAMUM_LETTER_SHEUX";
        case   0xA6B9: return "BAMUM_LETTER_SEUX";
        case   0xA6BA: return "BAMUM_LETTER_KYEE";
        case   0xA6BB: return "BAMUM_LETTER_KET";
        case   0xA6BC: return "BAMUM_LETTER_NUAE";
        case   0xA6BD: return "BAMUM_LETTER_NU";
        case   0xA6BE: return "BAMUM_LETTER_NJUAE";
        case   0xA6BF: return "BAMUM_LETTER_YOQ";
        case   0xA6C0: return "BAMUM_LETTER_SHU";
        case   0xA6C1: return "BAMUM_LETTER_YUQ";
        case   0xA6C2: return "BAMUM_LETTER_YA";
        case   0xA6C3: return "BAMUM_LETTER_NSHA";
        case   0xA6C4: return "BAMUM_LETTER_KEUX";
        case   0xA6C5: return "BAMUM_LETTER_PEUX";
        case   0xA6C6: return "BAMUM_LETTER_NJEE";
        case   0xA6C7: return "BAMUM_LETTER_NTEE";
        case   0xA6C8: return "BAMUM_LETTER_PUE";
        case   0xA6C9: return "BAMUM_LETTER_WUE";
        case   0xA6CA: return "BAMUM_LETTER_PEE";
        case   0xA6CB: return "BAMUM_LETTER_FEE";
        case   0xA6CC: return "BAMUM_LETTER_RU";
        case   0xA6CD: return "BAMUM_LETTER_LU";
        case   0xA6CE: return "BAMUM_LETTER_MI";
        case   0xA6CF: return "BAMUM_LETTER_NI";
        case   0xA6D0: return "BAMUM_LETTER_REUX";
        case   0xA6D1: return "BAMUM_LETTER_RAE";
        case   0xA6D2: return "BAMUM_LETTER_KEN";
        case   0xA6D3: return "BAMUM_LETTER_NGKWAEN";
        case   0xA6D4: return "BAMUM_LETTER_NGGA";
        default:       return nullptr;
    }
}

static const char *uniname2(int codepoint)
{   switch (codepoint)
    {   case   0xA6D5: return "BAMUM_LETTER_NGA";
        case   0xA6D6: return "BAMUM_LETTER_SHO";
        case   0xA6D7: return "BAMUM_LETTER_PUAE";
        case   0xA6D8: return "BAMUM_LETTER_FU";
        case   0xA6D9: return "BAMUM_LETTER_FOM";
        case   0xA6DA: return "BAMUM_LETTER_WA";
        case   0xA6DB: return "BAMUM_LETTER_NA";
        case   0xA6DC: return "BAMUM_LETTER_LI";
        case   0xA6DD: return "BAMUM_LETTER_PI";
        case   0xA6DE: return "BAMUM_LETTER_LOQ";
        case   0xA6DF: return "BAMUM_LETTER_KO";
        case   0xA6E0: return "BAMUM_LETTER_MBEN";
        case   0xA6E1: return "BAMUM_LETTER_REN";
        case   0xA6E2: return "BAMUM_LETTER_MEN";
        case   0xA6E3: return "BAMUM_LETTER_MA";
        case   0xA6E4: return "BAMUM_LETTER_TI";
        case   0xA6E5: return "BAMUM_LETTER_KI";
        case   0xA6E6: return "BAMUM_LETTER_MO";
        case   0xA6E7: return "BAMUM_LETTER_MBAA";
        case   0xA6E8: return "BAMUM_LETTER_TET";
        case   0xA6E9: return "BAMUM_LETTER_KPA";
        case   0xA6EA: return "BAMUM_LETTER_TEN";
        case   0xA6EB: return "BAMUM_LETTER_NTUU";
        case   0xA6EC: return "BAMUM_LETTER_SAMBA";
        case   0xA6ED: return "BAMUM_LETTER_FAAMAE";
        case   0xA6EE: return "BAMUM_LETTER_KOVUU";
        case   0xA6EF: return "BAMUM_LETTER_KOGHOM";
        case   0xA6F0: return "BAMUM_COMBINING_MARK_KOQNDON";
        case   0xA6F1: return "BAMUM_COMBINING_MARK_TUKWENTIS";
        case   0xA6F2: return "BAMUM_NJAEMLI";
        case   0xA6F3: return "BAMUM_FULL_STOP";
        case   0xA6F4: return "BAMUM_COLON";
        case   0xA6F5: return "BAMUM_COMMA";
        case   0xA6F6: return "BAMUM_SEMICOLON";
        case   0xA6F7: return "BAMUM_QUESTION_MARK";
        case   0xA700: return "MODIFIER_LETTER_CHINESE_TONE_YIN_PING";
        case   0xA701: return "MODIFIER_LETTER_CHINESE_TONE_YANG_PING";
        case   0xA702: return "MODIFIER_LETTER_CHINESE_TONE_YIN_SHANG";
        case   0xA703: return "MODIFIER_LETTER_CHINESE_TONE_YANG_SHANG";
        case   0xA704: return "MODIFIER_LETTER_CHINESE_TONE_YIN_QU";
        case   0xA705: return "MODIFIER_LETTER_CHINESE_TONE_YANG_QU";
        case   0xA706: return "MODIFIER_LETTER_CHINESE_TONE_YIN_RU";
        case   0xA707: return "MODIFIER_LETTER_CHINESE_TONE_YANG_RU";
        case   0xA708: return "MODIFIER_LETTER_EXTRA_HIGH_DOTTED_TONE_BAR";
        case   0xA709: return "MODIFIER_LETTER_HIGH_DOTTED_TONE_BAR";
        case   0xA70A: return "MODIFIER_LETTER_MID_DOTTED_TONE_BAR";
        case   0xA70B: return "MODIFIER_LETTER_LOW_DOTTED_TONE_BAR";
        case   0xA70C: return "MODIFIER_LETTER_EXTRA_LOW_DOTTED_TONE_BAR";
        case   0xA70D: return
                "MODIFIER_LETTER_EXTRA_HIGH_DOTTED_LEFT_STEM_TONE_BAR";
        case   0xA70E: return
                "MODIFIER_LETTER_HIGH_DOTTED_LEFT_STEM_TONE_BAR";
        case   0xA70F: return "MODIFIER_LETTER_MID_DOTTED_LEFT_STEM_TONE_BAR";
        case   0xA710: return "MODIFIER_LETTER_LOW_DOTTED_LEFT_STEM_TONE_BAR";
        case   0xA711: return
                "MODIFIER_LETTER_EXTRA_LOW_DOTTED_LEFT_STEM_TONE_BAR";
        case   0xA712: return "MODIFIER_LETTER_EXTRA_HIGH_LEFT_STEM_TONE_BAR";
        case   0xA713: return "MODIFIER_LETTER_HIGH_LEFT_STEM_TONE_BAR";
        case   0xA714: return "MODIFIER_LETTER_MID_LEFT_STEM_TONE_BAR";
        case   0xA715: return "MODIFIER_LETTER_LOW_LEFT_STEM_TONE_BAR";
        case   0xA716: return "MODIFIER_LETTER_EXTRA_LOW_LEFT_STEM_TONE_BAR";
        case   0xA717: return "MODIFIER_LETTER_DOT_VERTICAL_BAR";
        case   0xA718: return "MODIFIER_LETTER_DOT_SLASH";
        case   0xA719: return "MODIFIER_LETTER_DOT_HORIZONTAL_BAR";
        case   0xA71A: return "MODIFIER_LETTER_LOWER_RIGHT_CORNER_ANGLE";
        case   0xA71B: return "MODIFIER_LETTER_RAISED_UP_ARROW";
        case   0xA71C: return "MODIFIER_LETTER_RAISED_DOWN_ARROW";
        case   0xA71D: return "MODIFIER_LETTER_RAISED_EXCLAMATION_MARK";
        case   0xA71E: return
                "MODIFIER_LETTER_RAISED_INVERTED_EXCLAMATION_MARK";
        case   0xA71F: return "MODIFIER_LETTER_LOW_INVERTED_EXCLAMATION_MARK";
        case   0xA720: return "MODIFIER_LETTER_STRESS_AND_HIGH_TONE";
        case   0xA721: return "MODIFIER_LETTER_STRESS_AND_LOW_TONE";
        case   0xA722: return "LATIN_CAPITAL_LETTER_EGYPTOLOGICAL_ALEF";
        case   0xA723: return "LATIN_SMALL_LETTER_EGYPTOLOGICAL_ALEF";
        case   0xA724: return "LATIN_CAPITAL_LETTER_EGYPTOLOGICAL_AIN";
        case   0xA725: return "LATIN_SMALL_LETTER_EGYPTOLOGICAL_AIN";
        case   0xA726: return "LATIN_CAPITAL_LETTER_HENG";
        case   0xA727: return "LATIN_SMALL_LETTER_HENG";
        case   0xA728: return "LATIN_CAPITAL_LETTER_TZ";
        case   0xA729: return "LATIN_SMALL_LETTER_TZ";
        case   0xA72A: return "LATIN_CAPITAL_LETTER_TRESILLO";
        case   0xA72B: return "LATIN_SMALL_LETTER_TRESILLO";
        case   0xA72C: return "LATIN_CAPITAL_LETTER_CUATRILLO";
        case   0xA72D: return "LATIN_SMALL_LETTER_CUATRILLO";
        case   0xA72E: return "LATIN_CAPITAL_LETTER_CUATRILLO_WITH_COMMA";
        case   0xA72F: return "LATIN_SMALL_LETTER_CUATRILLO_WITH_COMMA";
        case   0xA730: return "LATIN_LETTER_SMALL_CAPITAL_F";
        case   0xA731: return "LATIN_LETTER_SMALL_CAPITAL_S";
        case   0xA732: return "LATIN_CAPITAL_LETTER_AA";
        case   0xA733: return "LATIN_SMALL_LETTER_AA";
        case   0xA734: return "LATIN_CAPITAL_LETTER_AO";
        case   0xA735: return "LATIN_SMALL_LETTER_AO";
        case   0xA736: return "LATIN_CAPITAL_LETTER_AU";
        case   0xA737: return "LATIN_SMALL_LETTER_AU";
        case   0xA738: return "LATIN_CAPITAL_LETTER_AV";
        case   0xA739: return "LATIN_SMALL_LETTER_AV";
        case   0xA73A: return "LATIN_CAPITAL_LETTER_AV_WITH_HORIZONTAL_BAR";
        case   0xA73B: return "LATIN_SMALL_LETTER_AV_WITH_HORIZONTAL_BAR";
        case   0xA73C: return "LATIN_CAPITAL_LETTER_AY";
        case   0xA73D: return "LATIN_SMALL_LETTER_AY";
        case   0xA73E: return "LATIN_CAPITAL_LETTER_REVERSED_C_WITH_DOT";
        case   0xA73F: return "LATIN_SMALL_LETTER_REVERSED_C_WITH_DOT";
        case   0xA740: return "LATIN_CAPITAL_LETTER_K_WITH_STROKE";
        case   0xA741: return "LATIN_SMALL_LETTER_K_WITH_STROKE";
        case   0xA742: return "LATIN_CAPITAL_LETTER_K_WITH_DIAGONAL_STROKE";
        case   0xA743: return "LATIN_SMALL_LETTER_K_WITH_DIAGONAL_STROKE";
        case   0xA744: return
                "LATIN_CAPITAL_LETTER_K_WITH_STROKE_AND_DIAGONAL_STROKE";
        case   0xA745: return
                "LATIN_SMALL_LETTER_K_WITH_STROKE_AND_DIAGONAL_STROKE";
        case   0xA746: return "LATIN_CAPITAL_LETTER_BROKEN_L";
        case   0xA747: return "LATIN_SMALL_LETTER_BROKEN_L";
        case   0xA748: return "LATIN_CAPITAL_LETTER_L_WITH_HIGH_STROKE";
        case   0xA749: return "LATIN_SMALL_LETTER_L_WITH_HIGH_STROKE";
        case   0xA74A: return
                "LATIN_CAPITAL_LETTER_O_WITH_LONG_STROKE_OVERLAY";
        case   0xA74B: return "LATIN_SMALL_LETTER_O_WITH_LONG_STROKE_OVERLAY";
        case   0xA74C: return "LATIN_CAPITAL_LETTER_O_WITH_LOOP";
        case   0xA74D: return "LATIN_SMALL_LETTER_O_WITH_LOOP";
        case   0xA74E: return "LATIN_CAPITAL_LETTER_OO";
        case   0xA74F: return "LATIN_SMALL_LETTER_OO";
        case   0xA750: return
                "LATIN_CAPITAL_LETTER_P_WITH_STROKE_THROUGH_DESCENDER";
        case   0xA751: return
                "LATIN_SMALL_LETTER_P_WITH_STROKE_THROUGH_DESCENDER";
        case   0xA752: return "LATIN_CAPITAL_LETTER_P_WITH_FLOURISH";
        case   0xA753: return "LATIN_SMALL_LETTER_P_WITH_FLOURISH";
        case   0xA754: return "LATIN_CAPITAL_LETTER_P_WITH_SQUIRREL_TAIL";
        case   0xA755: return "LATIN_SMALL_LETTER_P_WITH_SQUIRREL_TAIL";
        case   0xA756: return
                "LATIN_CAPITAL_LETTER_Q_WITH_STROKE_THROUGH_DESCENDER";
        case   0xA757: return
                "LATIN_SMALL_LETTER_Q_WITH_STROKE_THROUGH_DESCENDER";
        case   0xA758: return "LATIN_CAPITAL_LETTER_Q_WITH_DIAGONAL_STROKE";
        case   0xA759: return "LATIN_SMALL_LETTER_Q_WITH_DIAGONAL_STROKE";
        case   0xA75A: return "LATIN_CAPITAL_LETTER_R_ROTUNDA";
        case   0xA75B: return "LATIN_SMALL_LETTER_R_ROTUNDA";
        case   0xA75C: return "LATIN_CAPITAL_LETTER_RUM_ROTUNDA";
        case   0xA75D: return "LATIN_SMALL_LETTER_RUM_ROTUNDA";
        case   0xA75E: return "LATIN_CAPITAL_LETTER_V_WITH_DIAGONAL_STROKE";
        case   0xA75F: return "LATIN_SMALL_LETTER_V_WITH_DIAGONAL_STROKE";
        case   0xA760: return "LATIN_CAPITAL_LETTER_VY";
        case   0xA761: return "LATIN_SMALL_LETTER_VY";
        case   0xA762: return "LATIN_CAPITAL_LETTER_VISIGOTHIC_Z";
        case   0xA763: return "LATIN_SMALL_LETTER_VISIGOTHIC_Z";
        case   0xA764: return "LATIN_CAPITAL_LETTER_THORN_WITH_STROKE";
        case   0xA765: return "LATIN_SMALL_LETTER_THORN_WITH_STROKE";
        case   0xA766: return
                "LATIN_CAPITAL_LETTER_THORN_WITH_STROKE_THROUGH_DESCENDER";
        case   0xA767: return
                "LATIN_SMALL_LETTER_THORN_WITH_STROKE_THROUGH_DESCENDER";
        case   0xA768: return "LATIN_CAPITAL_LETTER_VEND";
        case   0xA769: return "LATIN_SMALL_LETTER_VEND";
        case   0xA76A: return "LATIN_CAPITAL_LETTER_ET";
        case   0xA76B: return "LATIN_SMALL_LETTER_ET";
        case   0xA76C: return "LATIN_CAPITAL_LETTER_IS";
        case   0xA76D: return "LATIN_SMALL_LETTER_IS";
        case   0xA76E: return "LATIN_CAPITAL_LETTER_CON";
        case   0xA76F: return "LATIN_SMALL_LETTER_CON";
        case   0xA770: return "MODIFIER_LETTER_US";
        case   0xA771: return "LATIN_SMALL_LETTER_DUM";
        case   0xA772: return "LATIN_SMALL_LETTER_LUM";
        case   0xA773: return "LATIN_SMALL_LETTER_MUM";
        case   0xA774: return "LATIN_SMALL_LETTER_NUM";
        case   0xA775: return "LATIN_SMALL_LETTER_RUM";
        case   0xA776: return "LATIN_LETTER_SMALL_CAPITAL_RUM";
        case   0xA777: return "LATIN_SMALL_LETTER_TUM";
        case   0xA778: return "LATIN_SMALL_LETTER_UM";
        case   0xA779: return "LATIN_CAPITAL_LETTER_INSULAR_D";
        case   0xA77A: return "LATIN_SMALL_LETTER_INSULAR_D";
        case   0xA77B: return "LATIN_CAPITAL_LETTER_INSULAR_F";
        case   0xA77C: return "LATIN_SMALL_LETTER_INSULAR_F";
        case   0xA77D: return "LATIN_CAPITAL_LETTER_INSULAR_G";
        case   0xA77E: return "LATIN_CAPITAL_LETTER_TURNED_INSULAR_G";
        case   0xA77F: return "LATIN_SMALL_LETTER_TURNED_INSULAR_G";
        case   0xA780: return "LATIN_CAPITAL_LETTER_TURNED_L";
        case   0xA781: return "LATIN_SMALL_LETTER_TURNED_L";
        case   0xA782: return "LATIN_CAPITAL_LETTER_INSULAR_R";
        case   0xA783: return "LATIN_SMALL_LETTER_INSULAR_R";
        case   0xA784: return "LATIN_CAPITAL_LETTER_INSULAR_S";
        case   0xA785: return "LATIN_SMALL_LETTER_INSULAR_S";
        case   0xA786: return "LATIN_CAPITAL_LETTER_INSULAR_T";
        case   0xA787: return "LATIN_SMALL_LETTER_INSULAR_T";
        case   0xA788: return "MODIFIER_LETTER_LOW_CIRCUMFLEX_ACCENT";
        case   0xA789: return "MODIFIER_LETTER_COLON";
        case   0xA78A: return "MODIFIER_LETTER_SHORT_EQUALS_SIGN";
        case   0xA78B: return "LATIN_CAPITAL_LETTER_SALTILLO";
        case   0xA78C: return "LATIN_SMALL_LETTER_SALTILLO";
        case   0xA78D: return "LATIN_CAPITAL_LETTER_TURNED_H";
        case   0xA78E: return
                "LATIN_SMALL_LETTER_L_WITH_RETROFLEX_HOOK_AND_BELT";
        case   0xA790: return "LATIN_CAPITAL_LETTER_N_WITH_DESCENDER";
        case   0xA791: return "LATIN_SMALL_LETTER_N_WITH_DESCENDER";
        case   0xA792: return "LATIN_CAPITAL_LETTER_C_WITH_BAR";
        case   0xA793: return "LATIN_SMALL_LETTER_C_WITH_BAR";
        case   0xA794: return "LATIN_SMALL_LETTER_C_WITH_PALATAL_HOOK";
        case   0xA795: return "LATIN_SMALL_LETTER_H_WITH_PALATAL_HOOK";
        case   0xA796: return "LATIN_CAPITAL_LETTER_B_WITH_FLOURISH";
        case   0xA797: return "LATIN_SMALL_LETTER_B_WITH_FLOURISH";
        case   0xA798: return "LATIN_CAPITAL_LETTER_F_WITH_STROKE";
        case   0xA799: return "LATIN_SMALL_LETTER_F_WITH_STROKE";
        case   0xA79A: return "LATIN_CAPITAL_LETTER_VOLAPUK_AE";
        case   0xA79B: return "LATIN_SMALL_LETTER_VOLAPUK_AE";
        case   0xA79C: return "LATIN_CAPITAL_LETTER_VOLAPUK_OE";
        case   0xA79D: return "LATIN_SMALL_LETTER_VOLAPUK_OE";
        case   0xA79E: return "LATIN_CAPITAL_LETTER_VOLAPUK_UE";
        case   0xA79F: return "LATIN_SMALL_LETTER_VOLAPUK_UE";
        case   0xA7A0: return "LATIN_CAPITAL_LETTER_G_WITH_OBLIQUE_STROKE";
        case   0xA7A1: return "LATIN_SMALL_LETTER_G_WITH_OBLIQUE_STROKE";
        case   0xA7A2: return "LATIN_CAPITAL_LETTER_K_WITH_OBLIQUE_STROKE";
        case   0xA7A3: return "LATIN_SMALL_LETTER_K_WITH_OBLIQUE_STROKE";
        case   0xA7A4: return "LATIN_CAPITAL_LETTER_N_WITH_OBLIQUE_STROKE";
        case   0xA7A5: return "LATIN_SMALL_LETTER_N_WITH_OBLIQUE_STROKE";
        case   0xA7A6: return "LATIN_CAPITAL_LETTER_R_WITH_OBLIQUE_STROKE";
        case   0xA7A7: return "LATIN_SMALL_LETTER_R_WITH_OBLIQUE_STROKE";
        case   0xA7A8: return "LATIN_CAPITAL_LETTER_S_WITH_OBLIQUE_STROKE";
        case   0xA7A9: return "LATIN_SMALL_LETTER_S_WITH_OBLIQUE_STROKE";
        case   0xA7AA: return "LATIN_CAPITAL_LETTER_H_WITH_HOOK";
        case   0xA7AB: return "LATIN_CAPITAL_LETTER_REVERSED_OPEN_E";
        case   0xA7AC: return "LATIN_CAPITAL_LETTER_SCRIPT_G";
        case   0xA7AD: return "LATIN_CAPITAL_LETTER_L_WITH_BELT";
        case   0xA7B0: return "LATIN_CAPITAL_LETTER_TURNED_K";
        case   0xA7B1: return "LATIN_CAPITAL_LETTER_TURNED_T";
        case   0xA7F7: return "LATIN_EPIGRAPHIC_LETTER_SIDEWAYS_I";
        case   0xA7F8: return "MODIFIER_LETTER_CAPITAL_H_WITH_STROKE";
        case   0xA7F9: return "MODIFIER_LETTER_SMALL_LIGATURE_OE";
        case   0xA7FA: return "LATIN_LETTER_SMALL_CAPITAL_TURNED_M";
        case   0xA7FB: return "LATIN_EPIGRAPHIC_LETTER_REVERSED_F";
        case   0xA7FC: return "LATIN_EPIGRAPHIC_LETTER_REVERSED_P";
        case   0xA7FD: return "LATIN_EPIGRAPHIC_LETTER_INVERTED_M";
        case   0xA7FE: return "LATIN_EPIGRAPHIC_LETTER_I_LONGA";
        case   0xA7FF: return "LATIN_EPIGRAPHIC_LETTER_ARCHAIC_M";
        case   0xA800: return "SYLOTI_NAGRI_LETTER_A";
        case   0xA801: return "SYLOTI_NAGRI_LETTER_I";
        case   0xA802: return "SYLOTI_NAGRI_SIGN_DVISVARA";
        case   0xA803: return "SYLOTI_NAGRI_LETTER_U";
        case   0xA804: return "SYLOTI_NAGRI_LETTER_E";
        case   0xA805: return "SYLOTI_NAGRI_LETTER_O";
        case   0xA806: return "SYLOTI_NAGRI_SIGN_HASANTA";
        case   0xA807: return "SYLOTI_NAGRI_LETTER_KO";
        case   0xA808: return "SYLOTI_NAGRI_LETTER_KHO";
        case   0xA809: return "SYLOTI_NAGRI_LETTER_GO";
        case   0xA80A: return "SYLOTI_NAGRI_LETTER_GHO";
        case   0xA80B: return "SYLOTI_NAGRI_SIGN_ANUSVARA";
        case   0xA80C: return "SYLOTI_NAGRI_LETTER_CO";
        case   0xA80D: return "SYLOTI_NAGRI_LETTER_CHO";
        case   0xA80E: return "SYLOTI_NAGRI_LETTER_JO";
        case   0xA80F: return "SYLOTI_NAGRI_LETTER_JHO";
        case   0xA810: return "SYLOTI_NAGRI_LETTER_TTO";
        case   0xA811: return "SYLOTI_NAGRI_LETTER_TTHO";
        case   0xA812: return "SYLOTI_NAGRI_LETTER_DDO";
        case   0xA813: return "SYLOTI_NAGRI_LETTER_DDHO";
        case   0xA814: return "SYLOTI_NAGRI_LETTER_TO";
        case   0xA815: return "SYLOTI_NAGRI_LETTER_THO";
        case   0xA816: return "SYLOTI_NAGRI_LETTER_DO";
        case   0xA817: return "SYLOTI_NAGRI_LETTER_DHO";
        case   0xA818: return "SYLOTI_NAGRI_LETTER_NO";
        case   0xA819: return "SYLOTI_NAGRI_LETTER_PO";
        case   0xA81A: return "SYLOTI_NAGRI_LETTER_PHO";
        case   0xA81B: return "SYLOTI_NAGRI_LETTER_BO";
        case   0xA81C: return "SYLOTI_NAGRI_LETTER_BHO";
        case   0xA81D: return "SYLOTI_NAGRI_LETTER_MO";
        case   0xA81E: return "SYLOTI_NAGRI_LETTER_RO";
        case   0xA81F: return "SYLOTI_NAGRI_LETTER_LO";
        case   0xA820: return "SYLOTI_NAGRI_LETTER_RRO";
        case   0xA821: return "SYLOTI_NAGRI_LETTER_SO";
        case   0xA822: return "SYLOTI_NAGRI_LETTER_HO";
        case   0xA823: return "SYLOTI_NAGRI_VOWEL_SIGN_A";
        case   0xA824: return "SYLOTI_NAGRI_VOWEL_SIGN_I";
        case   0xA825: return "SYLOTI_NAGRI_VOWEL_SIGN_U";
        case   0xA826: return "SYLOTI_NAGRI_VOWEL_SIGN_E";
        case   0xA827: return "SYLOTI_NAGRI_VOWEL_SIGN_OO";
        case   0xA828: return "SYLOTI_NAGRI_POETRY_MARK_1";
        case   0xA829: return "SYLOTI_NAGRI_POETRY_MARK_2";
        case   0xA82A: return "SYLOTI_NAGRI_POETRY_MARK_3";
        case   0xA82B: return "SYLOTI_NAGRI_POETRY_MARK_4";
        case   0xA830: return "NORTH_INDIC_FRACTION_ONE_QUARTER";
        case   0xA831: return "NORTH_INDIC_FRACTION_ONE_HALF";
        case   0xA832: return "NORTH_INDIC_FRACTION_THREE_QUARTERS";
        case   0xA833: return "NORTH_INDIC_FRACTION_ONE_SIXTEENTH";
        case   0xA834: return "NORTH_INDIC_FRACTION_ONE_EIGHTH";
        case   0xA835: return "NORTH_INDIC_FRACTION_THREE_SIXTEENTHS";
        case   0xA836: return "NORTH_INDIC_QUARTER_MARK";
        case   0xA837: return "NORTH_INDIC_PLACEHOLDER_MARK";
        case   0xA838: return "NORTH_INDIC_RUPEE_MARK";
        case   0xA839: return "NORTH_INDIC_QUANTITY_MARK";
        case   0xA840: return "PHAGS_PA_LETTER_KA";
        case   0xA841: return "PHAGS_PA_LETTER_KHA";
        case   0xA842: return "PHAGS_PA_LETTER_GA";
        case   0xA843: return "PHAGS_PA_LETTER_NGA";
        case   0xA844: return "PHAGS_PA_LETTER_CA";
        case   0xA845: return "PHAGS_PA_LETTER_CHA";
        case   0xA846: return "PHAGS_PA_LETTER_JA";
        case   0xA847: return "PHAGS_PA_LETTER_NYA";
        case   0xA848: return "PHAGS_PA_LETTER_TA";
        case   0xA849: return "PHAGS_PA_LETTER_THA";
        case   0xA84A: return "PHAGS_PA_LETTER_DA";
        case   0xA84B: return "PHAGS_PA_LETTER_NA";
        case   0xA84C: return "PHAGS_PA_LETTER_PA";
        case   0xA84D: return "PHAGS_PA_LETTER_PHA";
        case   0xA84E: return "PHAGS_PA_LETTER_BA";
        case   0xA84F: return "PHAGS_PA_LETTER_MA";
        case   0xA850: return "PHAGS_PA_LETTER_TSA";
        case   0xA851: return "PHAGS_PA_LETTER_TSHA";
        case   0xA852: return "PHAGS_PA_LETTER_DZA";
        case   0xA853: return "PHAGS_PA_LETTER_WA";
        case   0xA854: return "PHAGS_PA_LETTER_ZHA";
        case   0xA855: return "PHAGS_PA_LETTER_ZA";
        case   0xA856: return "PHAGS_PA_LETTER_SMALL_A";
        case   0xA857: return "PHAGS_PA_LETTER_YA";
        case   0xA858: return "PHAGS_PA_LETTER_RA";
        case   0xA859: return "PHAGS_PA_LETTER_LA";
        case   0xA85A: return "PHAGS_PA_LETTER_SHA";
        case   0xA85B: return "PHAGS_PA_LETTER_SA";
        case   0xA85C: return "PHAGS_PA_LETTER_HA";
        case   0xA85D: return "PHAGS_PA_LETTER_A";
        case   0xA85E: return "PHAGS_PA_LETTER_I";
        case   0xA85F: return "PHAGS_PA_LETTER_U";
        case   0xA860: return "PHAGS_PA_LETTER_E";
        case   0xA861: return "PHAGS_PA_LETTER_O";
        case   0xA862: return "PHAGS_PA_LETTER_QA";
        case   0xA863: return "PHAGS_PA_LETTER_XA";
        case   0xA864: return "PHAGS_PA_LETTER_FA";
        case   0xA865: return "PHAGS_PA_LETTER_GGA";
        case   0xA866: return "PHAGS_PA_LETTER_EE";
        case   0xA867: return "PHAGS_PA_SUBJOINED_LETTER_WA";
        case   0xA868: return "PHAGS_PA_SUBJOINED_LETTER_YA";
        case   0xA869: return "PHAGS_PA_LETTER_TTA";
        case   0xA86A: return "PHAGS_PA_LETTER_TTHA";
        case   0xA86B: return "PHAGS_PA_LETTER_DDA";
        case   0xA86C: return "PHAGS_PA_LETTER_NNA";
        case   0xA86D: return "PHAGS_PA_LETTER_ALTERNATE_YA";
        case   0xA86E: return "PHAGS_PA_LETTER_VOICELESS_SHA";
        case   0xA86F: return "PHAGS_PA_LETTER_VOICED_HA";
        case   0xA870: return "PHAGS_PA_LETTER_ASPIRATED_FA";
        case   0xA871: return "PHAGS_PA_SUBJOINED_LETTER_RA";
        case   0xA872: return "PHAGS_PA_SUPERFIXED_LETTER_RA";
        case   0xA873: return "PHAGS_PA_LETTER_CANDRABINDU";
        case   0xA874: return "PHAGS_PA_SINGLE_HEAD_MARK";
        case   0xA875: return "PHAGS_PA_DOUBLE_HEAD_MARK";
        case   0xA876: return "PHAGS_PA_MARK_SHAD";
        case   0xA877: return "PHAGS_PA_MARK_DOUBLE_SHAD";
        case   0xA880: return "SAURASHTRA_SIGN_ANUSVARA";
        case   0xA881: return "SAURASHTRA_SIGN_VISARGA";
        case   0xA882: return "SAURASHTRA_LETTER_A";
        case   0xA883: return "SAURASHTRA_LETTER_AA";
        case   0xA884: return "SAURASHTRA_LETTER_I";
        case   0xA885: return "SAURASHTRA_LETTER_II";
        case   0xA886: return "SAURASHTRA_LETTER_U";
        case   0xA887: return "SAURASHTRA_LETTER_UU";
        case   0xA888: return "SAURASHTRA_LETTER_VOCALIC_R";
        case   0xA889: return "SAURASHTRA_LETTER_VOCALIC_RR";
        case   0xA88A: return "SAURASHTRA_LETTER_VOCALIC_L";
        case   0xA88B: return "SAURASHTRA_LETTER_VOCALIC_LL";
        case   0xA88C: return "SAURASHTRA_LETTER_E";
        case   0xA88D: return "SAURASHTRA_LETTER_EE";
        case   0xA88E: return "SAURASHTRA_LETTER_AI";
        case   0xA88F: return "SAURASHTRA_LETTER_O";
        case   0xA890: return "SAURASHTRA_LETTER_OO";
        case   0xA891: return "SAURASHTRA_LETTER_AU";
        case   0xA892: return "SAURASHTRA_LETTER_KA";
        case   0xA893: return "SAURASHTRA_LETTER_KHA";
        case   0xA894: return "SAURASHTRA_LETTER_GA";
        case   0xA895: return "SAURASHTRA_LETTER_GHA";
        case   0xA896: return "SAURASHTRA_LETTER_NGA";
        case   0xA897: return "SAURASHTRA_LETTER_CA";
        case   0xA898: return "SAURASHTRA_LETTER_CHA";
        case   0xA899: return "SAURASHTRA_LETTER_JA";
        case   0xA89A: return "SAURASHTRA_LETTER_JHA";
        case   0xA89B: return "SAURASHTRA_LETTER_NYA";
        case   0xA89C: return "SAURASHTRA_LETTER_TTA";
        case   0xA89D: return "SAURASHTRA_LETTER_TTHA";
        case   0xA89E: return "SAURASHTRA_LETTER_DDA";
        case   0xA89F: return "SAURASHTRA_LETTER_DDHA";
        case   0xA8A0: return "SAURASHTRA_LETTER_NNA";
        case   0xA8A1: return "SAURASHTRA_LETTER_TA";
        case   0xA8A2: return "SAURASHTRA_LETTER_THA";
        case   0xA8A3: return "SAURASHTRA_LETTER_DA";
        case   0xA8A4: return "SAURASHTRA_LETTER_DHA";
        case   0xA8A5: return "SAURASHTRA_LETTER_NA";
        case   0xA8A6: return "SAURASHTRA_LETTER_PA";
        case   0xA8A7: return "SAURASHTRA_LETTER_PHA";
        case   0xA8A8: return "SAURASHTRA_LETTER_BA";
        case   0xA8A9: return "SAURASHTRA_LETTER_BHA";
        case   0xA8AA: return "SAURASHTRA_LETTER_MA";
        case   0xA8AB: return "SAURASHTRA_LETTER_YA";
        case   0xA8AC: return "SAURASHTRA_LETTER_RA";
        case   0xA8AD: return "SAURASHTRA_LETTER_LA";
        case   0xA8AE: return "SAURASHTRA_LETTER_VA";
        case   0xA8AF: return "SAURASHTRA_LETTER_SHA";
        case   0xA8B0: return "SAURASHTRA_LETTER_SSA";
        case   0xA8B1: return "SAURASHTRA_LETTER_SA";
        case   0xA8B2: return "SAURASHTRA_LETTER_HA";
        case   0xA8B3: return "SAURASHTRA_LETTER_LLA";
        case   0xA8B4: return "SAURASHTRA_CONSONANT_SIGN_HAARU";
        case   0xA8B5: return "SAURASHTRA_VOWEL_SIGN_AA";
        case   0xA8B6: return "SAURASHTRA_VOWEL_SIGN_I";
        case   0xA8B7: return "SAURASHTRA_VOWEL_SIGN_II";
        case   0xA8B8: return "SAURASHTRA_VOWEL_SIGN_U";
        case   0xA8B9: return "SAURASHTRA_VOWEL_SIGN_UU";
        case   0xA8BA: return "SAURASHTRA_VOWEL_SIGN_VOCALIC_R";
        case   0xA8BB: return "SAURASHTRA_VOWEL_SIGN_VOCALIC_RR";
        case   0xA8BC: return "SAURASHTRA_VOWEL_SIGN_VOCALIC_L";
        case   0xA8BD: return "SAURASHTRA_VOWEL_SIGN_VOCALIC_LL";
        case   0xA8BE: return "SAURASHTRA_VOWEL_SIGN_E";
        case   0xA8BF: return "SAURASHTRA_VOWEL_SIGN_EE";
        case   0xA8C0: return "SAURASHTRA_VOWEL_SIGN_AI";
        case   0xA8C1: return "SAURASHTRA_VOWEL_SIGN_O";
        case   0xA8C2: return "SAURASHTRA_VOWEL_SIGN_OO";
        case   0xA8C3: return "SAURASHTRA_VOWEL_SIGN_AU";
        case   0xA8C4: return "SAURASHTRA_SIGN_VIRAMA";
        case   0xA8CE: return "SAURASHTRA_DANDA";
        case   0xA8CF: return "SAURASHTRA_DOUBLE_DANDA";
        case   0xA8D0: return "SAURASHTRA_DIGIT_ZERO";
        case   0xA8D1: return "SAURASHTRA_DIGIT_ONE";
        case   0xA8D2: return "SAURASHTRA_DIGIT_TWO";
        case   0xA8D3: return "SAURASHTRA_DIGIT_THREE";
        case   0xA8D4: return "SAURASHTRA_DIGIT_FOUR";
        case   0xA8D5: return "SAURASHTRA_DIGIT_FIVE";
        case   0xA8D6: return "SAURASHTRA_DIGIT_SIX";
        case   0xA8D7: return "SAURASHTRA_DIGIT_SEVEN";
        case   0xA8D8: return "SAURASHTRA_DIGIT_EIGHT";
        case   0xA8D9: return "SAURASHTRA_DIGIT_NINE";
        case   0xA8E0: return "COMBINING_DEVANAGARI_DIGIT_ZERO";
        case   0xA8E1: return "COMBINING_DEVANAGARI_DIGIT_ONE";
        case   0xA8E2: return "COMBINING_DEVANAGARI_DIGIT_TWO";
        case   0xA8E3: return "COMBINING_DEVANAGARI_DIGIT_THREE";
        case   0xA8E4: return "COMBINING_DEVANAGARI_DIGIT_FOUR";
        case   0xA8E5: return "COMBINING_DEVANAGARI_DIGIT_FIVE";
        case   0xA8E6: return "COMBINING_DEVANAGARI_DIGIT_SIX";
        case   0xA8E7: return "COMBINING_DEVANAGARI_DIGIT_SEVEN";
        case   0xA8E8: return "COMBINING_DEVANAGARI_DIGIT_EIGHT";
        case   0xA8E9: return "COMBINING_DEVANAGARI_DIGIT_NINE";
        case   0xA8EA: return "COMBINING_DEVANAGARI_LETTER_A";
        case   0xA8EB: return "COMBINING_DEVANAGARI_LETTER_U";
        case   0xA8EC: return "COMBINING_DEVANAGARI_LETTER_KA";
        case   0xA8ED: return "COMBINING_DEVANAGARI_LETTER_NA";
        case   0xA8EE: return "COMBINING_DEVANAGARI_LETTER_PA";
        case   0xA8EF: return "COMBINING_DEVANAGARI_LETTER_RA";
        case   0xA8F0: return "COMBINING_DEVANAGARI_LETTER_VI";
        case   0xA8F1: return "COMBINING_DEVANAGARI_SIGN_AVAGRAHA";
        case   0xA8F2: return "DEVANAGARI_SIGN_SPACING_CANDRABINDU";
        case   0xA8F3: return "DEVANAGARI_SIGN_CANDRABINDU_VIRAMA";
        case   0xA8F4: return "DEVANAGARI_SIGN_DOUBLE_CANDRABINDU_VIRAMA";
        case   0xA8F5: return "DEVANAGARI_SIGN_CANDRABINDU_TWO";
        case   0xA8F6: return "DEVANAGARI_SIGN_CANDRABINDU_THREE";
        case   0xA8F7: return "DEVANAGARI_SIGN_CANDRABINDU_AVAGRAHA";
        case   0xA8F8: return "DEVANAGARI_SIGN_PUSHPIKA";
        case   0xA8F9: return "DEVANAGARI_GAP_FILLER";
        case   0xA8FA: return "DEVANAGARI_CARET";
        case   0xA8FB: return "DEVANAGARI_HEADSTROKE";
        case   0xA900: return "KAYAH_LI_DIGIT_ZERO";
        case   0xA901: return "KAYAH_LI_DIGIT_ONE";
        case   0xA902: return "KAYAH_LI_DIGIT_TWO";
        case   0xA903: return "KAYAH_LI_DIGIT_THREE";
        case   0xA904: return "KAYAH_LI_DIGIT_FOUR";
        case   0xA905: return "KAYAH_LI_DIGIT_FIVE";
        case   0xA906: return "KAYAH_LI_DIGIT_SIX";
        case   0xA907: return "KAYAH_LI_DIGIT_SEVEN";
        case   0xA908: return "KAYAH_LI_DIGIT_EIGHT";
        case   0xA909: return "KAYAH_LI_DIGIT_NINE";
        case   0xA90A: return "KAYAH_LI_LETTER_KA";
        case   0xA90B: return "KAYAH_LI_LETTER_KHA";
        case   0xA90C: return "KAYAH_LI_LETTER_GA";
        case   0xA90D: return "KAYAH_LI_LETTER_NGA";
        case   0xA90E: return "KAYAH_LI_LETTER_SA";
        case   0xA90F: return "KAYAH_LI_LETTER_SHA";
        case   0xA910: return "KAYAH_LI_LETTER_ZA";
        case   0xA911: return "KAYAH_LI_LETTER_NYA";
        case   0xA912: return "KAYAH_LI_LETTER_TA";
        case   0xA913: return "KAYAH_LI_LETTER_HTA";
        case   0xA914: return "KAYAH_LI_LETTER_NA";
        case   0xA915: return "KAYAH_LI_LETTER_PA";
        case   0xA916: return "KAYAH_LI_LETTER_PHA";
        case   0xA917: return "KAYAH_LI_LETTER_MA";
        case   0xA918: return "KAYAH_LI_LETTER_DA";
        case   0xA919: return "KAYAH_LI_LETTER_BA";
        case   0xA91A: return "KAYAH_LI_LETTER_RA";
        case   0xA91B: return "KAYAH_LI_LETTER_YA";
        case   0xA91C: return "KAYAH_LI_LETTER_LA";
        case   0xA91D: return "KAYAH_LI_LETTER_WA";
        case   0xA91E: return "KAYAH_LI_LETTER_THA";
        case   0xA91F: return "KAYAH_LI_LETTER_HA";
        case   0xA920: return "KAYAH_LI_LETTER_VA";
        case   0xA921: return "KAYAH_LI_LETTER_CA";
        case   0xA922: return "KAYAH_LI_LETTER_A";
        case   0xA923: return "KAYAH_LI_LETTER_OE";
        case   0xA924: return "KAYAH_LI_LETTER_I";
        case   0xA925: return "KAYAH_LI_LETTER_OO";
        case   0xA926: return "KAYAH_LI_VOWEL_UE";
        case   0xA927: return "KAYAH_LI_VOWEL_E";
        case   0xA928: return "KAYAH_LI_VOWEL_U";
        case   0xA929: return "KAYAH_LI_VOWEL_EE";
        case   0xA92A: return "KAYAH_LI_VOWEL_O";
        case   0xA92B: return "KAYAH_LI_TONE_PLOPHU";
        case   0xA92C: return "KAYAH_LI_TONE_CALYA";
        case   0xA92D: return "KAYAH_LI_TONE_CALYA_PLOPHU";
        case   0xA92E: return "KAYAH_LI_SIGN_CWI";
        case   0xA92F: return "KAYAH_LI_SIGN_SHYA";
        case   0xA930: return "REJANG_LETTER_KA";
        case   0xA931: return "REJANG_LETTER_GA";
        case   0xA932: return "REJANG_LETTER_NGA";
        case   0xA933: return "REJANG_LETTER_TA";
        case   0xA934: return "REJANG_LETTER_DA";
        case   0xA935: return "REJANG_LETTER_NA";
        case   0xA936: return "REJANG_LETTER_PA";
        case   0xA937: return "REJANG_LETTER_BA";
        case   0xA938: return "REJANG_LETTER_MA";
        case   0xA939: return "REJANG_LETTER_CA";
        case   0xA93A: return "REJANG_LETTER_JA";
        case   0xA93B: return "REJANG_LETTER_NYA";
        case   0xA93C: return "REJANG_LETTER_SA";
        case   0xA93D: return "REJANG_LETTER_RA";
        case   0xA93E: return "REJANG_LETTER_LA";
        case   0xA93F: return "REJANG_LETTER_YA";
        case   0xA940: return "REJANG_LETTER_WA";
        case   0xA941: return "REJANG_LETTER_HA";
        case   0xA942: return "REJANG_LETTER_MBA";
        case   0xA943: return "REJANG_LETTER_NGGA";
        case   0xA944: return "REJANG_LETTER_NDA";
        case   0xA945: return "REJANG_LETTER_NYJA";
        case   0xA946: return "REJANG_LETTER_A";
        case   0xA947: return "REJANG_VOWEL_SIGN_I";
        case   0xA948: return "REJANG_VOWEL_SIGN_U";
        case   0xA949: return "REJANG_VOWEL_SIGN_E";
        case   0xA94A: return "REJANG_VOWEL_SIGN_AI";
        case   0xA94B: return "REJANG_VOWEL_SIGN_O";
        case   0xA94C: return "REJANG_VOWEL_SIGN_AU";
        case   0xA94D: return "REJANG_VOWEL_SIGN_EU";
        case   0xA94E: return "REJANG_VOWEL_SIGN_EA";
        case   0xA94F: return "REJANG_CONSONANT_SIGN_NG";
        case   0xA950: return "REJANG_CONSONANT_SIGN_N";
        case   0xA951: return "REJANG_CONSONANT_SIGN_R";
        case   0xA952: return "REJANG_CONSONANT_SIGN_H";
        case   0xA953: return "REJANG_VIRAMA";
        case   0xA95F: return "REJANG_SECTION_MARK";
        case   0xA960: return "HANGUL_CHOSEONG_TIKEUT_MIEUM";
        case   0xA961: return "HANGUL_CHOSEONG_TIKEUT_PIEUP";
        case   0xA962: return "HANGUL_CHOSEONG_TIKEUT_SIOS";
        case   0xA963: return "HANGUL_CHOSEONG_TIKEUT_CIEUC";
        case   0xA964: return "HANGUL_CHOSEONG_RIEUL_KIYEOK";
        case   0xA965: return "HANGUL_CHOSEONG_RIEUL_SSANGKIYEOK";
        case   0xA966: return "HANGUL_CHOSEONG_RIEUL_TIKEUT";
        case   0xA967: return "HANGUL_CHOSEONG_RIEUL_SSANGTIKEUT";
        case   0xA968: return "HANGUL_CHOSEONG_RIEUL_MIEUM";
        case   0xA969: return "HANGUL_CHOSEONG_RIEUL_PIEUP";
        case   0xA96A: return "HANGUL_CHOSEONG_RIEUL_SSANGPIEUP";
        case   0xA96B: return "HANGUL_CHOSEONG_RIEUL_KAPYEOUNPIEUP";
        case   0xA96C: return "HANGUL_CHOSEONG_RIEUL_SIOS";
        case   0xA96D: return "HANGUL_CHOSEONG_RIEUL_CIEUC";
        case   0xA96E: return "HANGUL_CHOSEONG_RIEUL_KHIEUKH";
        case   0xA96F: return "HANGUL_CHOSEONG_MIEUM_KIYEOK";
        case   0xA970: return "HANGUL_CHOSEONG_MIEUM_TIKEUT";
        case   0xA971: return "HANGUL_CHOSEONG_MIEUM_SIOS";
        case   0xA972: return "HANGUL_CHOSEONG_PIEUP_SIOS_THIEUTH";
        case   0xA973: return "HANGUL_CHOSEONG_PIEUP_KHIEUKH";
        case   0xA974: return "HANGUL_CHOSEONG_PIEUP_HIEUH";
        case   0xA975: return "HANGUL_CHOSEONG_SSANGSIOS_PIEUP";
        case   0xA976: return "HANGUL_CHOSEONG_IEUNG_RIEUL";
        case   0xA977: return "HANGUL_CHOSEONG_IEUNG_HIEUH";
        case   0xA978: return "HANGUL_CHOSEONG_SSANGCIEUC_HIEUH";
        case   0xA979: return "HANGUL_CHOSEONG_SSANGTHIEUTH";
        case   0xA97A: return "HANGUL_CHOSEONG_PHIEUPH_HIEUH";
        case   0xA97B: return "HANGUL_CHOSEONG_HIEUH_SIOS";
        case   0xA97C: return "HANGUL_CHOSEONG_SSANGYEORINHIEUH";
        case   0xA980: return "JAVANESE_SIGN_PANYANGGA";
        case   0xA981: return "JAVANESE_SIGN_CECAK";
        case   0xA982: return "JAVANESE_SIGN_LAYAR";
        case   0xA983: return "JAVANESE_SIGN_WIGNYAN";
        case   0xA984: return "JAVANESE_LETTER_A";
        case   0xA985: return "JAVANESE_LETTER_I_KAWI";
        case   0xA986: return "JAVANESE_LETTER_I";
        case   0xA987: return "JAVANESE_LETTER_II";
        case   0xA988: return "JAVANESE_LETTER_U";
        case   0xA989: return "JAVANESE_LETTER_PA_CEREK";
        case   0xA98A: return "JAVANESE_LETTER_NGA_LELET";
        case   0xA98B: return "JAVANESE_LETTER_NGA_LELET_RASWADI";
        case   0xA98C: return "JAVANESE_LETTER_E";
        case   0xA98D: return "JAVANESE_LETTER_AI";
        case   0xA98E: return "JAVANESE_LETTER_O";
        case   0xA98F: return "JAVANESE_LETTER_KA";
        case   0xA990: return "JAVANESE_LETTER_KA_SASAK";
        case   0xA991: return "JAVANESE_LETTER_KA_MURDA";
        case   0xA992: return "JAVANESE_LETTER_GA";
        case   0xA993: return "JAVANESE_LETTER_GA_MURDA";
        case   0xA994: return "JAVANESE_LETTER_NGA";
        case   0xA995: return "JAVANESE_LETTER_CA";
        case   0xA996: return "JAVANESE_LETTER_CA_MURDA";
        case   0xA997: return "JAVANESE_LETTER_JA";
        case   0xA998: return "JAVANESE_LETTER_NYA_MURDA";
        case   0xA999: return "JAVANESE_LETTER_JA_MAHAPRANA";
        case   0xA99A: return "JAVANESE_LETTER_NYA";
        case   0xA99B: return "JAVANESE_LETTER_TTA";
        case   0xA99C: return "JAVANESE_LETTER_TTA_MAHAPRANA";
        case   0xA99D: return "JAVANESE_LETTER_DDA";
        case   0xA99E: return "JAVANESE_LETTER_DDA_MAHAPRANA";
        case   0xA99F: return "JAVANESE_LETTER_NA_MURDA";
        case   0xA9A0: return "JAVANESE_LETTER_TA";
        case   0xA9A1: return "JAVANESE_LETTER_TA_MURDA";
        case   0xA9A2: return "JAVANESE_LETTER_DA";
        case   0xA9A3: return "JAVANESE_LETTER_DA_MAHAPRANA";
        case   0xA9A4: return "JAVANESE_LETTER_NA";
        case   0xA9A5: return "JAVANESE_LETTER_PA";
        case   0xA9A6: return "JAVANESE_LETTER_PA_MURDA";
        case   0xA9A7: return "JAVANESE_LETTER_BA";
        case   0xA9A8: return "JAVANESE_LETTER_BA_MURDA";
        case   0xA9A9: return "JAVANESE_LETTER_MA";
        case   0xA9AA: return "JAVANESE_LETTER_YA";
        case   0xA9AB: return "JAVANESE_LETTER_RA";
        case   0xA9AC: return "JAVANESE_LETTER_RA_AGUNG";
        case   0xA9AD: return "JAVANESE_LETTER_LA";
        case   0xA9AE: return "JAVANESE_LETTER_WA";
        case   0xA9AF: return "JAVANESE_LETTER_SA_MURDA";
        case   0xA9B0: return "JAVANESE_LETTER_SA_MAHAPRANA";
        case   0xA9B1: return "JAVANESE_LETTER_SA";
        case   0xA9B2: return "JAVANESE_LETTER_HA";
        case   0xA9B3: return "JAVANESE_SIGN_CECAK_TELU";
        case   0xA9B4: return "JAVANESE_VOWEL_SIGN_TARUNG";
        case   0xA9B5: return "JAVANESE_VOWEL_SIGN_TOLONG";
        case   0xA9B6: return "JAVANESE_VOWEL_SIGN_WULU";
        case   0xA9B7: return "JAVANESE_VOWEL_SIGN_WULU_MELIK";
        case   0xA9B8: return "JAVANESE_VOWEL_SIGN_SUKU";
        case   0xA9B9: return "JAVANESE_VOWEL_SIGN_SUKU_MENDUT";
        case   0xA9BA: return "JAVANESE_VOWEL_SIGN_TALING";
        case   0xA9BB: return "JAVANESE_VOWEL_SIGN_DIRGA_MURE";
        case   0xA9BC: return "JAVANESE_VOWEL_SIGN_PEPET";
        case   0xA9BD: return "JAVANESE_CONSONANT_SIGN_KERET";
        case   0xA9BE: return "JAVANESE_CONSONANT_SIGN_PENGKAL";
        case   0xA9BF: return "JAVANESE_CONSONANT_SIGN_CAKRA";
        case   0xA9C0: return "JAVANESE_PANGKON";
        case   0xA9C1: return "JAVANESE_LEFT_RERENGGAN";
        case   0xA9C2: return "JAVANESE_RIGHT_RERENGGAN";
        case   0xA9C3: return "JAVANESE_PADA_ANDAP";
        case   0xA9C4: return "JAVANESE_PADA_MADYA";
        case   0xA9C5: return "JAVANESE_PADA_LUHUR";
        case   0xA9C6: return "JAVANESE_PADA_WINDU";
        case   0xA9C7: return "JAVANESE_PADA_PANGKAT";
        case   0xA9C8: return "JAVANESE_PADA_LINGSA";
        case   0xA9C9: return "JAVANESE_PADA_LUNGSI";
        case   0xA9CA: return "JAVANESE_PADA_ADEG";
        case   0xA9CB: return "JAVANESE_PADA_ADEG_ADEG";
        case   0xA9CC: return "JAVANESE_PADA_PISELEH";
        case   0xA9CD: return "JAVANESE_TURNED_PADA_PISELEH";
        case   0xA9CF: return "JAVANESE_PANGRANGKEP";
        case   0xA9D0: return "JAVANESE_DIGIT_ZERO";
        case   0xA9D1: return "JAVANESE_DIGIT_ONE";
        case   0xA9D2: return "JAVANESE_DIGIT_TWO";
        case   0xA9D3: return "JAVANESE_DIGIT_THREE";
        case   0xA9D4: return "JAVANESE_DIGIT_FOUR";
        case   0xA9D5: return "JAVANESE_DIGIT_FIVE";
        case   0xA9D6: return "JAVANESE_DIGIT_SIX";
        case   0xA9D7: return "JAVANESE_DIGIT_SEVEN";
        case   0xA9D8: return "JAVANESE_DIGIT_EIGHT";
        case   0xA9D9: return "JAVANESE_DIGIT_NINE";
        case   0xA9DE: return "JAVANESE_PADA_TIRTA_TUMETES";
        case   0xA9DF: return "JAVANESE_PADA_ISEN_ISEN";
        case   0xA9E0: return "MYANMAR_LETTER_SHAN_GHA";
        case   0xA9E1: return "MYANMAR_LETTER_SHAN_CHA";
        case   0xA9E2: return "MYANMAR_LETTER_SHAN_JHA";
        case   0xA9E3: return "MYANMAR_LETTER_SHAN_NNA";
        case   0xA9E4: return "MYANMAR_LETTER_SHAN_BHA";
        case   0xA9E5: return "MYANMAR_SIGN_SHAN_SAW";
        case   0xA9E6: return "MYANMAR_MODIFIER_LETTER_SHAN_REDUPLICATION";
        case   0xA9E7: return "MYANMAR_LETTER_TAI_LAING_NYA";
        case   0xA9E8: return "MYANMAR_LETTER_TAI_LAING_FA";
        case   0xA9E9: return "MYANMAR_LETTER_TAI_LAING_GA";
        case   0xA9EA: return "MYANMAR_LETTER_TAI_LAING_GHA";
        case   0xA9EB: return "MYANMAR_LETTER_TAI_LAING_JA";
        case   0xA9EC: return "MYANMAR_LETTER_TAI_LAING_JHA";
        case   0xA9ED: return "MYANMAR_LETTER_TAI_LAING_DDA";
        case   0xA9EE: return "MYANMAR_LETTER_TAI_LAING_DDHA";
        case   0xA9EF: return "MYANMAR_LETTER_TAI_LAING_NNA";
        case   0xA9F0: return "MYANMAR_TAI_LAING_DIGIT_ZERO";
        case   0xA9F1: return "MYANMAR_TAI_LAING_DIGIT_ONE";
        case   0xA9F2: return "MYANMAR_TAI_LAING_DIGIT_TWO";
        case   0xA9F3: return "MYANMAR_TAI_LAING_DIGIT_THREE";
        case   0xA9F4: return "MYANMAR_TAI_LAING_DIGIT_FOUR";
        case   0xA9F5: return "MYANMAR_TAI_LAING_DIGIT_FIVE";
        case   0xA9F6: return "MYANMAR_TAI_LAING_DIGIT_SIX";
        case   0xA9F7: return "MYANMAR_TAI_LAING_DIGIT_SEVEN";
        case   0xA9F8: return "MYANMAR_TAI_LAING_DIGIT_EIGHT";
        case   0xA9F9: return "MYANMAR_TAI_LAING_DIGIT_NINE";
        case   0xA9FA: return "MYANMAR_LETTER_TAI_LAING_LLA";
        case   0xA9FB: return "MYANMAR_LETTER_TAI_LAING_DA";
        case   0xA9FC: return "MYANMAR_LETTER_TAI_LAING_DHA";
        case   0xA9FD: return "MYANMAR_LETTER_TAI_LAING_BA";
        case   0xA9FE: return "MYANMAR_LETTER_TAI_LAING_BHA";
        case   0xAA00: return "CHAM_LETTER_A";
        case   0xAA01: return "CHAM_LETTER_I";
        case   0xAA02: return "CHAM_LETTER_U";
        case   0xAA03: return "CHAM_LETTER_E";
        case   0xAA04: return "CHAM_LETTER_AI";
        case   0xAA05: return "CHAM_LETTER_O";
        case   0xAA06: return "CHAM_LETTER_KA";
        case   0xAA07: return "CHAM_LETTER_KHA";
        case   0xAA08: return "CHAM_LETTER_GA";
        case   0xAA09: return "CHAM_LETTER_GHA";
        case   0xAA0A: return "CHAM_LETTER_NGUE";
        case   0xAA0B: return "CHAM_LETTER_NGA";
        case   0xAA0C: return "CHAM_LETTER_CHA";
        case   0xAA0D: return "CHAM_LETTER_CHHA";
        case   0xAA0E: return "CHAM_LETTER_JA";
        case   0xAA0F: return "CHAM_LETTER_JHA";
        case   0xAA10: return "CHAM_LETTER_NHUE";
        case   0xAA11: return "CHAM_LETTER_NHA";
        case   0xAA12: return "CHAM_LETTER_NHJA";
        case   0xAA13: return "CHAM_LETTER_TA";
        case   0xAA14: return "CHAM_LETTER_THA";
        case   0xAA15: return "CHAM_LETTER_DA";
        case   0xAA16: return "CHAM_LETTER_DHA";
        case   0xAA17: return "CHAM_LETTER_NUE";
        case   0xAA18: return "CHAM_LETTER_NA";
        case   0xAA19: return "CHAM_LETTER_DDA";
        case   0xAA1A: return "CHAM_LETTER_PA";
        case   0xAA1B: return "CHAM_LETTER_PPA";
        case   0xAA1C: return "CHAM_LETTER_PHA";
        case   0xAA1D: return "CHAM_LETTER_BA";
        case   0xAA1E: return "CHAM_LETTER_BHA";
        case   0xAA1F: return "CHAM_LETTER_MUE";
        case   0xAA20: return "CHAM_LETTER_MA";
        case   0xAA21: return "CHAM_LETTER_BBA";
        case   0xAA22: return "CHAM_LETTER_YA";
        case   0xAA23: return "CHAM_LETTER_RA";
        case   0xAA24: return "CHAM_LETTER_LA";
        case   0xAA25: return "CHAM_LETTER_VA";
        case   0xAA26: return "CHAM_LETTER_SSA";
        case   0xAA27: return "CHAM_LETTER_SA";
        case   0xAA28: return "CHAM_LETTER_HA";
        case   0xAA29: return "CHAM_VOWEL_SIGN_AA";
        case   0xAA2A: return "CHAM_VOWEL_SIGN_I";
        case   0xAA2B: return "CHAM_VOWEL_SIGN_II";
        case   0xAA2C: return "CHAM_VOWEL_SIGN_EI";
        case   0xAA2D: return "CHAM_VOWEL_SIGN_U";
        case   0xAA2E: return "CHAM_VOWEL_SIGN_OE";
        case   0xAA2F: return "CHAM_VOWEL_SIGN_O";
        case   0xAA30: return "CHAM_VOWEL_SIGN_AI";
        case   0xAA31: return "CHAM_VOWEL_SIGN_AU";
        case   0xAA32: return "CHAM_VOWEL_SIGN_UE";
        case   0xAA33: return "CHAM_CONSONANT_SIGN_YA";
        case   0xAA34: return "CHAM_CONSONANT_SIGN_RA";
        case   0xAA35: return "CHAM_CONSONANT_SIGN_LA";
        case   0xAA36: return "CHAM_CONSONANT_SIGN_WA";
        case   0xAA40: return "CHAM_LETTER_FINAL_K";
        case   0xAA41: return "CHAM_LETTER_FINAL_G";
        case   0xAA42: return "CHAM_LETTER_FINAL_NG";
        case   0xAA43: return "CHAM_CONSONANT_SIGN_FINAL_NG";
        case   0xAA44: return "CHAM_LETTER_FINAL_CH";
        case   0xAA45: return "CHAM_LETTER_FINAL_T";
        case   0xAA46: return "CHAM_LETTER_FINAL_N";
        case   0xAA47: return "CHAM_LETTER_FINAL_P";
        case   0xAA48: return "CHAM_LETTER_FINAL_Y";
        case   0xAA49: return "CHAM_LETTER_FINAL_R";
        case   0xAA4A: return "CHAM_LETTER_FINAL_L";
        case   0xAA4B: return "CHAM_LETTER_FINAL_SS";
        case   0xAA4C: return "CHAM_CONSONANT_SIGN_FINAL_M";
        case   0xAA4D: return "CHAM_CONSONANT_SIGN_FINAL_H";
        case   0xAA50: return "CHAM_DIGIT_ZERO";
        case   0xAA51: return "CHAM_DIGIT_ONE";
        case   0xAA52: return "CHAM_DIGIT_TWO";
        case   0xAA53: return "CHAM_DIGIT_THREE";
        case   0xAA54: return "CHAM_DIGIT_FOUR";
        case   0xAA55: return "CHAM_DIGIT_FIVE";
        case   0xAA56: return "CHAM_DIGIT_SIX";
        case   0xAA57: return "CHAM_DIGIT_SEVEN";
        case   0xAA58: return "CHAM_DIGIT_EIGHT";
        case   0xAA59: return "CHAM_DIGIT_NINE";
        case   0xAA5C: return "CHAM_PUNCTUATION_SPIRAL";
        case   0xAA5D: return "CHAM_PUNCTUATION_DANDA";
        case   0xAA5E: return "CHAM_PUNCTUATION_DOUBLE_DANDA";
        case   0xAA5F: return "CHAM_PUNCTUATION_TRIPLE_DANDA";
        case   0xAA60: return "MYANMAR_LETTER_KHAMTI_GA";
        case   0xAA61: return "MYANMAR_LETTER_KHAMTI_CA";
        case   0xAA62: return "MYANMAR_LETTER_KHAMTI_CHA";
        case   0xAA63: return "MYANMAR_LETTER_KHAMTI_JA";
        case   0xAA64: return "MYANMAR_LETTER_KHAMTI_JHA";
        case   0xAA65: return "MYANMAR_LETTER_KHAMTI_NYA";
        case   0xAA66: return "MYANMAR_LETTER_KHAMTI_TTA";
        case   0xAA67: return "MYANMAR_LETTER_KHAMTI_TTHA";
        case   0xAA68: return "MYANMAR_LETTER_KHAMTI_DDA";
        case   0xAA69: return "MYANMAR_LETTER_KHAMTI_DDHA";
        case   0xAA6A: return "MYANMAR_LETTER_KHAMTI_DHA";
        case   0xAA6B: return "MYANMAR_LETTER_KHAMTI_NA";
        case   0xAA6C: return "MYANMAR_LETTER_KHAMTI_SA";
        case   0xAA6D: return "MYANMAR_LETTER_KHAMTI_HA";
        case   0xAA6E: return "MYANMAR_LETTER_KHAMTI_HHA";
        case   0xAA6F: return "MYANMAR_LETTER_KHAMTI_FA";
        case   0xAA70: return "MYANMAR_MODIFIER_LETTER_KHAMTI_REDUPLICATION";
        case   0xAA71: return "MYANMAR_LETTER_KHAMTI_XA";
        case   0xAA72: return "MYANMAR_LETTER_KHAMTI_ZA";
        case   0xAA73: return "MYANMAR_LETTER_KHAMTI_RA";
        case   0xAA74: return "MYANMAR_LOGOGRAM_KHAMTI_OAY";
        case   0xAA75: return "MYANMAR_LOGOGRAM_KHAMTI_QN";
        case   0xAA76: return "MYANMAR_LOGOGRAM_KHAMTI_HM";
        case   0xAA77: return "MYANMAR_SYMBOL_AITON_EXCLAMATION";
        case   0xAA78: return "MYANMAR_SYMBOL_AITON_ONE";
        case   0xAA79: return "MYANMAR_SYMBOL_AITON_TWO";
        case   0xAA7A: return "MYANMAR_LETTER_AITON_RA";
        case   0xAA7B: return "MYANMAR_SIGN_PAO_KAREN_TONE";
        case   0xAA7C: return "MYANMAR_SIGN_TAI_LAING_TONE_2";
        case   0xAA7D: return "MYANMAR_SIGN_TAI_LAING_TONE_5";
        case   0xAA7E: return "MYANMAR_LETTER_SHWE_PALAUNG_CHA";
        case   0xAA7F: return "MYANMAR_LETTER_SHWE_PALAUNG_SHA";
        case   0xAA80: return "TAI_VIET_LETTER_LOW_KO";
        case   0xAA81: return "TAI_VIET_LETTER_HIGH_KO";
        case   0xAA82: return "TAI_VIET_LETTER_LOW_KHO";
        case   0xAA83: return "TAI_VIET_LETTER_HIGH_KHO";
        case   0xAA84: return "TAI_VIET_LETTER_LOW_KHHO";
        case   0xAA85: return "TAI_VIET_LETTER_HIGH_KHHO";
        case   0xAA86: return "TAI_VIET_LETTER_LOW_GO";
        case   0xAA87: return "TAI_VIET_LETTER_HIGH_GO";
        case   0xAA88: return "TAI_VIET_LETTER_LOW_NGO";
        case   0xAA89: return "TAI_VIET_LETTER_HIGH_NGO";
        case   0xAA8A: return "TAI_VIET_LETTER_LOW_CO";
        case   0xAA8B: return "TAI_VIET_LETTER_HIGH_CO";
        case   0xAA8C: return "TAI_VIET_LETTER_LOW_CHO";
        case   0xAA8D: return "TAI_VIET_LETTER_HIGH_CHO";
        case   0xAA8E: return "TAI_VIET_LETTER_LOW_SO";
        case   0xAA8F: return "TAI_VIET_LETTER_HIGH_SO";
        case   0xAA90: return "TAI_VIET_LETTER_LOW_NYO";
        case   0xAA91: return "TAI_VIET_LETTER_HIGH_NYO";
        case   0xAA92: return "TAI_VIET_LETTER_LOW_DO";
        case   0xAA93: return "TAI_VIET_LETTER_HIGH_DO";
        case   0xAA94: return "TAI_VIET_LETTER_LOW_TO";
        case   0xAA95: return "TAI_VIET_LETTER_HIGH_TO";
        case   0xAA96: return "TAI_VIET_LETTER_LOW_THO";
        case   0xAA97: return "TAI_VIET_LETTER_HIGH_THO";
        case   0xAA98: return "TAI_VIET_LETTER_LOW_NO";
        case   0xAA99: return "TAI_VIET_LETTER_HIGH_NO";
        case   0xAA9A: return "TAI_VIET_LETTER_LOW_BO";
        case   0xAA9B: return "TAI_VIET_LETTER_HIGH_BO";
        case   0xAA9C: return "TAI_VIET_LETTER_LOW_PO";
        case   0xAA9D: return "TAI_VIET_LETTER_HIGH_PO";
        case   0xAA9E: return "TAI_VIET_LETTER_LOW_PHO";
        case   0xAA9F: return "TAI_VIET_LETTER_HIGH_PHO";
        case   0xAAA0: return "TAI_VIET_LETTER_LOW_FO";
        case   0xAAA1: return "TAI_VIET_LETTER_HIGH_FO";
        case   0xAAA2: return "TAI_VIET_LETTER_LOW_MO";
        case   0xAAA3: return "TAI_VIET_LETTER_HIGH_MO";
        case   0xAAA4: return "TAI_VIET_LETTER_LOW_YO";
        case   0xAAA5: return "TAI_VIET_LETTER_HIGH_YO";
        case   0xAAA6: return "TAI_VIET_LETTER_LOW_RO";
        case   0xAAA7: return "TAI_VIET_LETTER_HIGH_RO";
        case   0xAAA8: return "TAI_VIET_LETTER_LOW_LO";
        case   0xAAA9: return "TAI_VIET_LETTER_HIGH_LO";
        case   0xAAAA: return "TAI_VIET_LETTER_LOW_VO";
        case   0xAAAB: return "TAI_VIET_LETTER_HIGH_VO";
        case   0xAAAC: return "TAI_VIET_LETTER_LOW_HO";
        case   0xAAAD: return "TAI_VIET_LETTER_HIGH_HO";
        case   0xAAAE: return "TAI_VIET_LETTER_LOW_O";
        case   0xAAAF: return "TAI_VIET_LETTER_HIGH_O";
        case   0xAAB0: return "TAI_VIET_MAI_KANG";
        case   0xAAB1: return "TAI_VIET_VOWEL_AA";
        case   0xAAB2: return "TAI_VIET_VOWEL_I";
        case   0xAAB3: return "TAI_VIET_VOWEL_UE";
        case   0xAAB4: return "TAI_VIET_VOWEL_U";
        case   0xAAB5: return "TAI_VIET_VOWEL_E";
        case   0xAAB6: return "TAI_VIET_VOWEL_O";
        case   0xAAB7: return "TAI_VIET_MAI_KHIT";
        case   0xAAB8: return "TAI_VIET_VOWEL_IA";
        case   0xAAB9: return "TAI_VIET_VOWEL_UEA";
        case   0xAABA: return "TAI_VIET_VOWEL_UA";
        case   0xAABB: return "TAI_VIET_VOWEL_AUE";
        case   0xAABC: return "TAI_VIET_VOWEL_AY";
        case   0xAABD: return "TAI_VIET_VOWEL_AN";
        case   0xAABE: return "TAI_VIET_VOWEL_AM";
        case   0xAABF: return "TAI_VIET_TONE_MAI_EK";
        case   0xAAC0: return "TAI_VIET_TONE_MAI_NUENG";
        case   0xAAC1: return "TAI_VIET_TONE_MAI_THO";
        case   0xAAC2: return "TAI_VIET_TONE_MAI_SONG";
        case   0xAADB: return "TAI_VIET_SYMBOL_KON";
        case   0xAADC: return "TAI_VIET_SYMBOL_NUENG";
        case   0xAADD: return "TAI_VIET_SYMBOL_SAM";
        case   0xAADE: return "TAI_VIET_SYMBOL_HO_HOI";
        case   0xAADF: return "TAI_VIET_SYMBOL_KOI_KOI";
        case   0xAAE0: return "MEETEI_MAYEK_LETTER_E";
        case   0xAAE1: return "MEETEI_MAYEK_LETTER_O";
        case   0xAAE2: return "MEETEI_MAYEK_LETTER_CHA";
        case   0xAAE3: return "MEETEI_MAYEK_LETTER_NYA";
        case   0xAAE4: return "MEETEI_MAYEK_LETTER_TTA";
        case   0xAAE5: return "MEETEI_MAYEK_LETTER_TTHA";
        case   0xAAE6: return "MEETEI_MAYEK_LETTER_DDA";
        case   0xAAE7: return "MEETEI_MAYEK_LETTER_DDHA";
        case   0xAAE8: return "MEETEI_MAYEK_LETTER_NNA";
        case   0xAAE9: return "MEETEI_MAYEK_LETTER_SHA";
        case   0xAAEA: return "MEETEI_MAYEK_LETTER_SSA";
        case   0xAAEB: return "MEETEI_MAYEK_VOWEL_SIGN_II";
        case   0xAAEC: return "MEETEI_MAYEK_VOWEL_SIGN_UU";
        case   0xAAED: return "MEETEI_MAYEK_VOWEL_SIGN_AAI";
        case   0xAAEE: return "MEETEI_MAYEK_VOWEL_SIGN_AU";
        case   0xAAEF: return "MEETEI_MAYEK_VOWEL_SIGN_AAU";
        case   0xAAF0: return "MEETEI_MAYEK_CHEIKHAN";
        case   0xAAF1: return "MEETEI_MAYEK_AHANG_KHUDAM";
        case   0xAAF2: return "MEETEI_MAYEK_ANJI";
        case   0xAAF3: return "MEETEI_MAYEK_SYLLABLE_REPETITION_MARK";
        case   0xAAF4: return "MEETEI_MAYEK_WORD_REPETITION_MARK";
        case   0xAAF5: return "MEETEI_MAYEK_VOWEL_SIGN_VISARGA";
        case   0xAAF6: return "MEETEI_MAYEK_VIRAMA";
        case   0xAB01: return "ETHIOPIC_SYLLABLE_TTHU";
        case   0xAB02: return "ETHIOPIC_SYLLABLE_TTHI";
        case   0xAB03: return "ETHIOPIC_SYLLABLE_TTHAA";
        case   0xAB04: return "ETHIOPIC_SYLLABLE_TTHEE";
        case   0xAB05: return "ETHIOPIC_SYLLABLE_TTHE";
        case   0xAB06: return "ETHIOPIC_SYLLABLE_TTHO";
        case   0xAB09: return "ETHIOPIC_SYLLABLE_DDHU";
        case   0xAB0A: return "ETHIOPIC_SYLLABLE_DDHI";
        case   0xAB0B: return "ETHIOPIC_SYLLABLE_DDHAA";
        case   0xAB0C: return "ETHIOPIC_SYLLABLE_DDHEE";
        case   0xAB0D: return "ETHIOPIC_SYLLABLE_DDHE";
        case   0xAB0E: return "ETHIOPIC_SYLLABLE_DDHO";
        case   0xAB11: return "ETHIOPIC_SYLLABLE_DZU";
        case   0xAB12: return "ETHIOPIC_SYLLABLE_DZI";
        case   0xAB13: return "ETHIOPIC_SYLLABLE_DZAA";
        case   0xAB14: return "ETHIOPIC_SYLLABLE_DZEE";
        case   0xAB15: return "ETHIOPIC_SYLLABLE_DZE";
        case   0xAB16: return "ETHIOPIC_SYLLABLE_DZO";
        case   0xAB20: return "ETHIOPIC_SYLLABLE_CCHHA";
        case   0xAB21: return "ETHIOPIC_SYLLABLE_CCHHU";
        case   0xAB22: return "ETHIOPIC_SYLLABLE_CCHHI";
        case   0xAB23: return "ETHIOPIC_SYLLABLE_CCHHAA";
        case   0xAB24: return "ETHIOPIC_SYLLABLE_CCHHEE";
        case   0xAB25: return "ETHIOPIC_SYLLABLE_CCHHE";
        case   0xAB26: return "ETHIOPIC_SYLLABLE_CCHHO";
        case   0xAB28: return "ETHIOPIC_SYLLABLE_BBA";
        case   0xAB29: return "ETHIOPIC_SYLLABLE_BBU";
        case   0xAB2A: return "ETHIOPIC_SYLLABLE_BBI";
        case   0xAB2B: return "ETHIOPIC_SYLLABLE_BBAA";
        case   0xAB2C: return "ETHIOPIC_SYLLABLE_BBEE";
        case   0xAB2D: return "ETHIOPIC_SYLLABLE_BBE";
        case   0xAB2E: return "ETHIOPIC_SYLLABLE_BBO";
        case   0xAB30: return "LATIN_SMALL_LETTER_BARRED_ALPHA";
        case   0xAB31: return "LATIN_SMALL_LETTER_A_REVERSED_SCHWA";
        case   0xAB32: return "LATIN_SMALL_LETTER_BLACKLETTER_E";
        case   0xAB33: return "LATIN_SMALL_LETTER_BARRED_E";
        case   0xAB34: return "LATIN_SMALL_LETTER_E_WITH_FLOURISH";
        case   0xAB35: return "LATIN_SMALL_LETTER_LENIS_F";
        case   0xAB36: return "LATIN_SMALL_LETTER_SCRIPT_G_WITH_CROSSED_TAIL";
        case   0xAB37: return "LATIN_SMALL_LETTER_L_WITH_INVERTED_LAZY_S";
        case   0xAB38: return "LATIN_SMALL_LETTER_L_WITH_DOUBLE_MIDDLE_TILDE";
        case   0xAB39: return "LATIN_SMALL_LETTER_L_WITH_MIDDLE_RING";
        case   0xAB3A: return "LATIN_SMALL_LETTER_M_WITH_CROSSED_TAIL";
        case   0xAB3B: return "LATIN_SMALL_LETTER_N_WITH_CROSSED_TAIL";
        case   0xAB3C: return "LATIN_SMALL_LETTER_ENG_WITH_CROSSED_TAIL";
        case   0xAB3D: return "LATIN_SMALL_LETTER_BLACKLETTER_O";
        case   0xAB3E: return "LATIN_SMALL_LETTER_BLACKLETTER_O_WITH_STROKE";
        case   0xAB3F: return "LATIN_SMALL_LETTER_OPEN_O_WITH_STROKE";
        case   0xAB40: return "LATIN_SMALL_LETTER_INVERTED_OE";
        case   0xAB41: return "LATIN_SMALL_LETTER_TURNED_OE_WITH_STROKE";
        case   0xAB42: return
                "LATIN_SMALL_LETTER_TURNED_OE_WITH_HORIZONTAL_STROKE";
        case   0xAB43: return "LATIN_SMALL_LETTER_TURNED_O_OPEN_O";
        case   0xAB44: return
                "LATIN_SMALL_LETTER_TURNED_O_OPEN_O_WITH_STROKE";
        case   0xAB45: return "LATIN_SMALL_LETTER_STIRRUP_R";
        case   0xAB46: return "LATIN_LETTER_SMALL_CAPITAL_R_WITH_RIGHT_LEG";
        case   0xAB47: return "LATIN_SMALL_LETTER_R_WITHOUT_HANDLE";
        case   0xAB48: return "LATIN_SMALL_LETTER_DOUBLE_R";
        case   0xAB49: return "LATIN_SMALL_LETTER_R_WITH_CROSSED_TAIL";
        case   0xAB4A: return "LATIN_SMALL_LETTER_DOUBLE_R_WITH_CROSSED_TAIL";
        case   0xAB4B: return "LATIN_SMALL_LETTER_SCRIPT_R";
        case   0xAB4C: return "LATIN_SMALL_LETTER_SCRIPT_R_WITH_RING";
        case   0xAB4D: return "LATIN_SMALL_LETTER_BASELINE_ESH";
        case   0xAB4E: return "LATIN_SMALL_LETTER_U_WITH_SHORT_RIGHT_LEG";
        case   0xAB4F: return "LATIN_SMALL_LETTER_U_BAR_WITH_SHORT_RIGHT_LEG";
        case   0xAB50: return "LATIN_SMALL_LETTER_UI";
        case   0xAB51: return "LATIN_SMALL_LETTER_TURNED_UI";
        case   0xAB52: return "LATIN_SMALL_LETTER_U_WITH_LEFT_HOOK";
        case   0xAB53: return "LATIN_SMALL_LETTER_CHI";
        case   0xAB54: return "LATIN_SMALL_LETTER_CHI_WITH_LOW_RIGHT_RING";
        case   0xAB55: return "LATIN_SMALL_LETTER_CHI_WITH_LOW_LEFT_SERIF";
        case   0xAB56: return "LATIN_SMALL_LETTER_X_WITH_LOW_RIGHT_RING";
        case   0xAB57: return "LATIN_SMALL_LETTER_X_WITH_LONG_LEFT_LEG";
        case   0xAB58: return
                "LATIN_SMALL_LETTER_X_WITH_LONG_LEFT_LEG_AND_LOW_RIGHT_RING";
        case   0xAB59: return
                "LATIN_SMALL_LETTER_X_WITH_LONG_LEFT_LEG_WITH_SERIF";
        case   0xAB5A: return "LATIN_SMALL_LETTER_Y_WITH_SHORT_RIGHT_LEG";
        case   0xAB5B: return "MODIFIER_BREVE_WITH_INVERTED_BREVE";
        case   0xAB5C: return "MODIFIER_LETTER_SMALL_HENG";
        case   0xAB5D: return "MODIFIER_LETTER_SMALL_L_WITH_INVERTED_LAZY_S";
        case   0xAB5E: return "MODIFIER_LETTER_SMALL_L_WITH_MIDDLE_TILDE";
        case   0xAB5F: return "MODIFIER_LETTER_SMALL_U_WITH_LEFT_HOOK";
        case   0xAB64: return "LATIN_SMALL_LETTER_INVERTED_ALPHA";
        case   0xAB65: return "GREEK_LETTER_SMALL_CAPITAL_OMEGA";
        case   0xABC0: return "MEETEI_MAYEK_LETTER_KOK";
        case   0xABC1: return "MEETEI_MAYEK_LETTER_SAM";
        case   0xABC2: return "MEETEI_MAYEK_LETTER_LAI";
        case   0xABC3: return "MEETEI_MAYEK_LETTER_MIT";
        case   0xABC4: return "MEETEI_MAYEK_LETTER_PA";
        case   0xABC5: return "MEETEI_MAYEK_LETTER_NA";
        case   0xABC6: return "MEETEI_MAYEK_LETTER_CHIL";
        case   0xABC7: return "MEETEI_MAYEK_LETTER_TIL";
        case   0xABC8: return "MEETEI_MAYEK_LETTER_KHOU";
        case   0xABC9: return "MEETEI_MAYEK_LETTER_NGOU";
        case   0xABCA: return "MEETEI_MAYEK_LETTER_THOU";
        case   0xABCB: return "MEETEI_MAYEK_LETTER_WAI";
        case   0xABCC: return "MEETEI_MAYEK_LETTER_YANG";
        case   0xABCD: return "MEETEI_MAYEK_LETTER_HUK";
        case   0xABCE: return "MEETEI_MAYEK_LETTER_UN";
        case   0xABCF: return "MEETEI_MAYEK_LETTER_I";
        case   0xABD0: return "MEETEI_MAYEK_LETTER_PHAM";
        case   0xABD1: return "MEETEI_MAYEK_LETTER_ATIYA";
        case   0xABD2: return "MEETEI_MAYEK_LETTER_GOK";
        case   0xABD3: return "MEETEI_MAYEK_LETTER_JHAM";
        case   0xABD4: return "MEETEI_MAYEK_LETTER_RAI";
        case   0xABD5: return "MEETEI_MAYEK_LETTER_BA";
        case   0xABD6: return "MEETEI_MAYEK_LETTER_JIL";
        case   0xABD7: return "MEETEI_MAYEK_LETTER_DIL";
        case   0xABD8: return "MEETEI_MAYEK_LETTER_GHOU";
        case   0xABD9: return "MEETEI_MAYEK_LETTER_DHOU";
        case   0xABDA: return "MEETEI_MAYEK_LETTER_BHAM";
        case   0xABDB: return "MEETEI_MAYEK_LETTER_KOK_LONSUM";
        case   0xABDC: return "MEETEI_MAYEK_LETTER_LAI_LONSUM";
        case   0xABDD: return "MEETEI_MAYEK_LETTER_MIT_LONSUM";
        case   0xABDE: return "MEETEI_MAYEK_LETTER_PA_LONSUM";
        case   0xABDF: return "MEETEI_MAYEK_LETTER_NA_LONSUM";
        case   0xABE0: return "MEETEI_MAYEK_LETTER_TIL_LONSUM";
        case   0xABE1: return "MEETEI_MAYEK_LETTER_NGOU_LONSUM";
        case   0xABE2: return "MEETEI_MAYEK_LETTER_I_LONSUM";
        case   0xABE3: return "MEETEI_MAYEK_VOWEL_SIGN_ONAP";
        case   0xABE4: return "MEETEI_MAYEK_VOWEL_SIGN_INAP";
        case   0xABE5: return "MEETEI_MAYEK_VOWEL_SIGN_ANAP";
        case   0xABE6: return "MEETEI_MAYEK_VOWEL_SIGN_YENAP";
        case   0xABE7: return "MEETEI_MAYEK_VOWEL_SIGN_SOUNAP";
        case   0xABE8: return "MEETEI_MAYEK_VOWEL_SIGN_UNAP";
        case   0xABE9: return "MEETEI_MAYEK_VOWEL_SIGN_CHEINAP";
        case   0xABEA: return "MEETEI_MAYEK_VOWEL_SIGN_NUNG";
        case   0xABEB: return "MEETEI_MAYEK_CHEIKHEI";
        case   0xABEC: return "MEETEI_MAYEK_LUM_IYEK";
        case   0xABED: return "MEETEI_MAYEK_APUN_IYEK";
        case   0xABF0: return "MEETEI_MAYEK_DIGIT_ZERO";
        case   0xABF1: return "MEETEI_MAYEK_DIGIT_ONE";
        case   0xABF2: return "MEETEI_MAYEK_DIGIT_TWO";
        case   0xABF3: return "MEETEI_MAYEK_DIGIT_THREE";
        case   0xABF4: return "MEETEI_MAYEK_DIGIT_FOUR";
        case   0xABF5: return "MEETEI_MAYEK_DIGIT_FIVE";
        case   0xABF6: return "MEETEI_MAYEK_DIGIT_SIX";
        case   0xABF7: return "MEETEI_MAYEK_DIGIT_SEVEN";
        case   0xABF8: return "MEETEI_MAYEK_DIGIT_EIGHT";
        case   0xABF9: return "MEETEI_MAYEK_DIGIT_NINE";
        case   0xAC00: return "Hangul_Syllable__First";
        case   0xD7A3: return "Hangul_Syllable__Last";
        case   0xD7B0: return "HANGUL_JUNGSEONG_O_YEO";
        case   0xD7B1: return "HANGUL_JUNGSEONG_O_O_I";
        case   0xD7B2: return "HANGUL_JUNGSEONG_YO_A";
        case   0xD7B3: return "HANGUL_JUNGSEONG_YO_AE";
        case   0xD7B4: return "HANGUL_JUNGSEONG_YO_EO";
        case   0xD7B5: return "HANGUL_JUNGSEONG_U_YEO";
        case   0xD7B6: return "HANGUL_JUNGSEONG_U_I_I";
        case   0xD7B7: return "HANGUL_JUNGSEONG_YU_AE";
        case   0xD7B8: return "HANGUL_JUNGSEONG_YU_O";
        case   0xD7B9: return "HANGUL_JUNGSEONG_EU_A";
        case   0xD7BA: return "HANGUL_JUNGSEONG_EU_EO";
        case   0xD7BB: return "HANGUL_JUNGSEONG_EU_E";
        case   0xD7BC: return "HANGUL_JUNGSEONG_EU_O";
        case   0xD7BD: return "HANGUL_JUNGSEONG_I_YA_O";
        case   0xD7BE: return "HANGUL_JUNGSEONG_I_YAE";
        case   0xD7BF: return "HANGUL_JUNGSEONG_I_YEO";
        case   0xD7C0: return "HANGUL_JUNGSEONG_I_YE";
        case   0xD7C1: return "HANGUL_JUNGSEONG_I_O_I";
        case   0xD7C2: return "HANGUL_JUNGSEONG_I_YO";
        case   0xD7C3: return "HANGUL_JUNGSEONG_I_YU";
        case   0xD7C4: return "HANGUL_JUNGSEONG_I_I";
        case   0xD7C5: return "HANGUL_JUNGSEONG_ARAEA_A";
        case   0xD7C6: return "HANGUL_JUNGSEONG_ARAEA_E";
        case   0xD7CB: return "HANGUL_JONGSEONG_NIEUN_RIEUL";
        case   0xD7CC: return "HANGUL_JONGSEONG_NIEUN_CHIEUCH";
        case   0xD7CD: return "HANGUL_JONGSEONG_SSANGTIKEUT";
        case   0xD7CE: return "HANGUL_JONGSEONG_SSANGTIKEUT_PIEUP";
        case   0xD7CF: return "HANGUL_JONGSEONG_TIKEUT_PIEUP";
        case   0xD7D0: return "HANGUL_JONGSEONG_TIKEUT_SIOS";
        case   0xD7D1: return "HANGUL_JONGSEONG_TIKEUT_SIOS_KIYEOK";
        case   0xD7D2: return "HANGUL_JONGSEONG_TIKEUT_CIEUC";
        case   0xD7D3: return "HANGUL_JONGSEONG_TIKEUT_CHIEUCH";
        case   0xD7D4: return "HANGUL_JONGSEONG_TIKEUT_THIEUTH";
        case   0xD7D5: return "HANGUL_JONGSEONG_RIEUL_SSANGKIYEOK";
        case   0xD7D6: return "HANGUL_JONGSEONG_RIEUL_KIYEOK_HIEUH";
        case   0xD7D7: return "HANGUL_JONGSEONG_SSANGRIEUL_KHIEUKH";
        case   0xD7D8: return "HANGUL_JONGSEONG_RIEUL_MIEUM_HIEUH";
        case   0xD7D9: return "HANGUL_JONGSEONG_RIEUL_PIEUP_TIKEUT";
        case   0xD7DA: return "HANGUL_JONGSEONG_RIEUL_PIEUP_PHIEUPH";
        case   0xD7DB: return "HANGUL_JONGSEONG_RIEUL_YESIEUNG";
        case   0xD7DC: return "HANGUL_JONGSEONG_RIEUL_YEORINHIEUH_HIEUH";
        case   0xD7DD: return "HANGUL_JONGSEONG_KAPYEOUNRIEUL";
        case   0xD7DE: return "HANGUL_JONGSEONG_MIEUM_NIEUN";
        case   0xD7DF: return "HANGUL_JONGSEONG_MIEUM_SSANGNIEUN";
        case   0xD7E0: return "HANGUL_JONGSEONG_SSANGMIEUM";
        case   0xD7E1: return "HANGUL_JONGSEONG_MIEUM_PIEUP_SIOS";
        case   0xD7E2: return "HANGUL_JONGSEONG_MIEUM_CIEUC";
        case   0xD7E3: return "HANGUL_JONGSEONG_PIEUP_TIKEUT";
        case   0xD7E4: return "HANGUL_JONGSEONG_PIEUP_RIEUL_PHIEUPH";
        case   0xD7E5: return "HANGUL_JONGSEONG_PIEUP_MIEUM";
        case   0xD7E6: return "HANGUL_JONGSEONG_SSANGPIEUP";
        case   0xD7E7: return "HANGUL_JONGSEONG_PIEUP_SIOS_TIKEUT";
        case   0xD7E8: return "HANGUL_JONGSEONG_PIEUP_CIEUC";
        case   0xD7E9: return "HANGUL_JONGSEONG_PIEUP_CHIEUCH";
        case   0xD7EA: return "HANGUL_JONGSEONG_SIOS_MIEUM";
        case   0xD7EB: return "HANGUL_JONGSEONG_SIOS_KAPYEOUNPIEUP";
        case   0xD7EC: return "HANGUL_JONGSEONG_SSANGSIOS_KIYEOK";
        case   0xD7ED: return "HANGUL_JONGSEONG_SSANGSIOS_TIKEUT";
        case   0xD7EE: return "HANGUL_JONGSEONG_SIOS_PANSIOS";
        case   0xD7EF: return "HANGUL_JONGSEONG_SIOS_CIEUC";
        case   0xD7F0: return "HANGUL_JONGSEONG_SIOS_CHIEUCH";
        case   0xD7F1: return "HANGUL_JONGSEONG_SIOS_THIEUTH";
        case   0xD7F2: return "HANGUL_JONGSEONG_SIOS_HIEUH";
        case   0xD7F3: return "HANGUL_JONGSEONG_PANSIOS_PIEUP";
        case   0xD7F4: return "HANGUL_JONGSEONG_PANSIOS_KAPYEOUNPIEUP";
        case   0xD7F5: return "HANGUL_JONGSEONG_YESIEUNG_MIEUM";
        case   0xD7F6: return "HANGUL_JONGSEONG_YESIEUNG_HIEUH";
        case   0xD7F7: return "HANGUL_JONGSEONG_CIEUC_PIEUP";
        case   0xD7F8: return "HANGUL_JONGSEONG_CIEUC_SSANGPIEUP";
        case   0xD7F9: return "HANGUL_JONGSEONG_SSANGCIEUC";
        case   0xD7FA: return "HANGUL_JONGSEONG_PHIEUPH_SIOS";
        case   0xD7FB: return "HANGUL_JONGSEONG_PHIEUPH_THIEUTH";
        case   0xD800: return "Non_Private_Use_High_Surrogate__First";
        case   0xDB7F: return "Non_Private_Use_High_Surrogate__Last";
        case   0xDB80: return "Private_Use_High_Surrogate__First";
        case   0xDBFF: return "Private_Use_High_Surrogate__Last";
        case   0xDC00: return "Low_Surrogate__First";
        case   0xDFFF: return "Low_Surrogate__Last";
        case   0xE000: return "Private_Use__First";
        case   0xF8FF: return "Private_Use__Last";
        case   0xF900: return "CJK_COMPATIBILITY_IDEOGRAPH_F900";
        case   0xF901: return "CJK_COMPATIBILITY_IDEOGRAPH_F901";
        case   0xF902: return "CJK_COMPATIBILITY_IDEOGRAPH_F902";
        case   0xF903: return "CJK_COMPATIBILITY_IDEOGRAPH_F903";
        case   0xF904: return "CJK_COMPATIBILITY_IDEOGRAPH_F904";
        case   0xF905: return "CJK_COMPATIBILITY_IDEOGRAPH_F905";
        case   0xF906: return "CJK_COMPATIBILITY_IDEOGRAPH_F906";
        case   0xF907: return "CJK_COMPATIBILITY_IDEOGRAPH_F907";
        case   0xF908: return "CJK_COMPATIBILITY_IDEOGRAPH_F908";
        case   0xF909: return "CJK_COMPATIBILITY_IDEOGRAPH_F909";
        case   0xF90A: return "CJK_COMPATIBILITY_IDEOGRAPH_F90A";
        case   0xF90B: return "CJK_COMPATIBILITY_IDEOGRAPH_F90B";
        case   0xF90C: return "CJK_COMPATIBILITY_IDEOGRAPH_F90C";
        case   0xF90D: return "CJK_COMPATIBILITY_IDEOGRAPH_F90D";
        case   0xF90E: return "CJK_COMPATIBILITY_IDEOGRAPH_F90E";
        case   0xF90F: return "CJK_COMPATIBILITY_IDEOGRAPH_F90F";
        case   0xF910: return "CJK_COMPATIBILITY_IDEOGRAPH_F910";
        case   0xF911: return "CJK_COMPATIBILITY_IDEOGRAPH_F911";
        case   0xF912: return "CJK_COMPATIBILITY_IDEOGRAPH_F912";
        case   0xF913: return "CJK_COMPATIBILITY_IDEOGRAPH_F913";
        case   0xF914: return "CJK_COMPATIBILITY_IDEOGRAPH_F914";
        case   0xF915: return "CJK_COMPATIBILITY_IDEOGRAPH_F915";
        case   0xF916: return "CJK_COMPATIBILITY_IDEOGRAPH_F916";
        case   0xF917: return "CJK_COMPATIBILITY_IDEOGRAPH_F917";
        case   0xF918: return "CJK_COMPATIBILITY_IDEOGRAPH_F918";
        case   0xF919: return "CJK_COMPATIBILITY_IDEOGRAPH_F919";
        case   0xF91A: return "CJK_COMPATIBILITY_IDEOGRAPH_F91A";
        case   0xF91B: return "CJK_COMPATIBILITY_IDEOGRAPH_F91B";
        case   0xF91C: return "CJK_COMPATIBILITY_IDEOGRAPH_F91C";
        case   0xF91D: return "CJK_COMPATIBILITY_IDEOGRAPH_F91D";
        case   0xF91E: return "CJK_COMPATIBILITY_IDEOGRAPH_F91E";
        case   0xF91F: return "CJK_COMPATIBILITY_IDEOGRAPH_F91F";
        case   0xF920: return "CJK_COMPATIBILITY_IDEOGRAPH_F920";
        case   0xF921: return "CJK_COMPATIBILITY_IDEOGRAPH_F921";
        case   0xF922: return "CJK_COMPATIBILITY_IDEOGRAPH_F922";
        case   0xF923: return "CJK_COMPATIBILITY_IDEOGRAPH_F923";
        case   0xF924: return "CJK_COMPATIBILITY_IDEOGRAPH_F924";
        case   0xF925: return "CJK_COMPATIBILITY_IDEOGRAPH_F925";
        case   0xF926: return "CJK_COMPATIBILITY_IDEOGRAPH_F926";
        case   0xF927: return "CJK_COMPATIBILITY_IDEOGRAPH_F927";
        case   0xF928: return "CJK_COMPATIBILITY_IDEOGRAPH_F928";
        case   0xF929: return "CJK_COMPATIBILITY_IDEOGRAPH_F929";
        case   0xF92A: return "CJK_COMPATIBILITY_IDEOGRAPH_F92A";
        case   0xF92B: return "CJK_COMPATIBILITY_IDEOGRAPH_F92B";
        case   0xF92C: return "CJK_COMPATIBILITY_IDEOGRAPH_F92C";
        case   0xF92D: return "CJK_COMPATIBILITY_IDEOGRAPH_F92D";
        case   0xF92E: return "CJK_COMPATIBILITY_IDEOGRAPH_F92E";
        case   0xF92F: return "CJK_COMPATIBILITY_IDEOGRAPH_F92F";
        case   0xF930: return "CJK_COMPATIBILITY_IDEOGRAPH_F930";
        case   0xF931: return "CJK_COMPATIBILITY_IDEOGRAPH_F931";
        case   0xF932: return "CJK_COMPATIBILITY_IDEOGRAPH_F932";
        case   0xF933: return "CJK_COMPATIBILITY_IDEOGRAPH_F933";
        case   0xF934: return "CJK_COMPATIBILITY_IDEOGRAPH_F934";
        case   0xF935: return "CJK_COMPATIBILITY_IDEOGRAPH_F935";
        case   0xF936: return "CJK_COMPATIBILITY_IDEOGRAPH_F936";
        case   0xF937: return "CJK_COMPATIBILITY_IDEOGRAPH_F937";
        case   0xF938: return "CJK_COMPATIBILITY_IDEOGRAPH_F938";
        case   0xF939: return "CJK_COMPATIBILITY_IDEOGRAPH_F939";
        case   0xF93A: return "CJK_COMPATIBILITY_IDEOGRAPH_F93A";
        case   0xF93B: return "CJK_COMPATIBILITY_IDEOGRAPH_F93B";
        case   0xF93C: return "CJK_COMPATIBILITY_IDEOGRAPH_F93C";
        case   0xF93D: return "CJK_COMPATIBILITY_IDEOGRAPH_F93D";
        case   0xF93E: return "CJK_COMPATIBILITY_IDEOGRAPH_F93E";
        case   0xF93F: return "CJK_COMPATIBILITY_IDEOGRAPH_F93F";
        case   0xF940: return "CJK_COMPATIBILITY_IDEOGRAPH_F940";
        case   0xF941: return "CJK_COMPATIBILITY_IDEOGRAPH_F941";
        case   0xF942: return "CJK_COMPATIBILITY_IDEOGRAPH_F942";
        case   0xF943: return "CJK_COMPATIBILITY_IDEOGRAPH_F943";
        case   0xF944: return "CJK_COMPATIBILITY_IDEOGRAPH_F944";
        case   0xF945: return "CJK_COMPATIBILITY_IDEOGRAPH_F945";
        case   0xF946: return "CJK_COMPATIBILITY_IDEOGRAPH_F946";
        case   0xF947: return "CJK_COMPATIBILITY_IDEOGRAPH_F947";
        case   0xF948: return "CJK_COMPATIBILITY_IDEOGRAPH_F948";
        case   0xF949: return "CJK_COMPATIBILITY_IDEOGRAPH_F949";
        case   0xF94A: return "CJK_COMPATIBILITY_IDEOGRAPH_F94A";
        case   0xF94B: return "CJK_COMPATIBILITY_IDEOGRAPH_F94B";
        case   0xF94C: return "CJK_COMPATIBILITY_IDEOGRAPH_F94C";
        case   0xF94D: return "CJK_COMPATIBILITY_IDEOGRAPH_F94D";
        case   0xF94E: return "CJK_COMPATIBILITY_IDEOGRAPH_F94E";
        case   0xF94F: return "CJK_COMPATIBILITY_IDEOGRAPH_F94F";
        case   0xF950: return "CJK_COMPATIBILITY_IDEOGRAPH_F950";
        case   0xF951: return "CJK_COMPATIBILITY_IDEOGRAPH_F951";
        case   0xF952: return "CJK_COMPATIBILITY_IDEOGRAPH_F952";
        case   0xF953: return "CJK_COMPATIBILITY_IDEOGRAPH_F953";
        case   0xF954: return "CJK_COMPATIBILITY_IDEOGRAPH_F954";
        case   0xF955: return "CJK_COMPATIBILITY_IDEOGRAPH_F955";
        case   0xF956: return "CJK_COMPATIBILITY_IDEOGRAPH_F956";
        case   0xF957: return "CJK_COMPATIBILITY_IDEOGRAPH_F957";
        case   0xF958: return "CJK_COMPATIBILITY_IDEOGRAPH_F958";
        case   0xF959: return "CJK_COMPATIBILITY_IDEOGRAPH_F959";
        case   0xF95A: return "CJK_COMPATIBILITY_IDEOGRAPH_F95A";
        case   0xF95B: return "CJK_COMPATIBILITY_IDEOGRAPH_F95B";
        case   0xF95C: return "CJK_COMPATIBILITY_IDEOGRAPH_F95C";
        case   0xF95D: return "CJK_COMPATIBILITY_IDEOGRAPH_F95D";
        case   0xF95E: return "CJK_COMPATIBILITY_IDEOGRAPH_F95E";
        case   0xF95F: return "CJK_COMPATIBILITY_IDEOGRAPH_F95F";
        case   0xF960: return "CJK_COMPATIBILITY_IDEOGRAPH_F960";
        case   0xF961: return "CJK_COMPATIBILITY_IDEOGRAPH_F961";
        case   0xF962: return "CJK_COMPATIBILITY_IDEOGRAPH_F962";
        case   0xF963: return "CJK_COMPATIBILITY_IDEOGRAPH_F963";
        case   0xF964: return "CJK_COMPATIBILITY_IDEOGRAPH_F964";
        case   0xF965: return "CJK_COMPATIBILITY_IDEOGRAPH_F965";
        case   0xF966: return "CJK_COMPATIBILITY_IDEOGRAPH_F966";
        case   0xF967: return "CJK_COMPATIBILITY_IDEOGRAPH_F967";
        case   0xF968: return "CJK_COMPATIBILITY_IDEOGRAPH_F968";
        case   0xF969: return "CJK_COMPATIBILITY_IDEOGRAPH_F969";
        case   0xF96A: return "CJK_COMPATIBILITY_IDEOGRAPH_F96A";
        case   0xF96B: return "CJK_COMPATIBILITY_IDEOGRAPH_F96B";
        case   0xF96C: return "CJK_COMPATIBILITY_IDEOGRAPH_F96C";
        case   0xF96D: return "CJK_COMPATIBILITY_IDEOGRAPH_F96D";
        case   0xF96E: return "CJK_COMPATIBILITY_IDEOGRAPH_F96E";
        case   0xF96F: return "CJK_COMPATIBILITY_IDEOGRAPH_F96F";
        case   0xF970: return "CJK_COMPATIBILITY_IDEOGRAPH_F970";
        case   0xF971: return "CJK_COMPATIBILITY_IDEOGRAPH_F971";
        case   0xF972: return "CJK_COMPATIBILITY_IDEOGRAPH_F972";
        case   0xF973: return "CJK_COMPATIBILITY_IDEOGRAPH_F973";
        case   0xF974: return "CJK_COMPATIBILITY_IDEOGRAPH_F974";
        case   0xF975: return "CJK_COMPATIBILITY_IDEOGRAPH_F975";
        case   0xF976: return "CJK_COMPATIBILITY_IDEOGRAPH_F976";
        case   0xF977: return "CJK_COMPATIBILITY_IDEOGRAPH_F977";
        case   0xF978: return "CJK_COMPATIBILITY_IDEOGRAPH_F978";
        case   0xF979: return "CJK_COMPATIBILITY_IDEOGRAPH_F979";
        case   0xF97A: return "CJK_COMPATIBILITY_IDEOGRAPH_F97A";
        case   0xF97B: return "CJK_COMPATIBILITY_IDEOGRAPH_F97B";
        case   0xF97C: return "CJK_COMPATIBILITY_IDEOGRAPH_F97C";
        case   0xF97D: return "CJK_COMPATIBILITY_IDEOGRAPH_F97D";
        case   0xF97E: return "CJK_COMPATIBILITY_IDEOGRAPH_F97E";
        case   0xF97F: return "CJK_COMPATIBILITY_IDEOGRAPH_F97F";
        case   0xF980: return "CJK_COMPATIBILITY_IDEOGRAPH_F980";
        case   0xF981: return "CJK_COMPATIBILITY_IDEOGRAPH_F981";
        case   0xF982: return "CJK_COMPATIBILITY_IDEOGRAPH_F982";
        case   0xF983: return "CJK_COMPATIBILITY_IDEOGRAPH_F983";
        case   0xF984: return "CJK_COMPATIBILITY_IDEOGRAPH_F984";
        case   0xF985: return "CJK_COMPATIBILITY_IDEOGRAPH_F985";
        case   0xF986: return "CJK_COMPATIBILITY_IDEOGRAPH_F986";
        case   0xF987: return "CJK_COMPATIBILITY_IDEOGRAPH_F987";
        case   0xF988: return "CJK_COMPATIBILITY_IDEOGRAPH_F988";
        case   0xF989: return "CJK_COMPATIBILITY_IDEOGRAPH_F989";
        case   0xF98A: return "CJK_COMPATIBILITY_IDEOGRAPH_F98A";
        case   0xF98B: return "CJK_COMPATIBILITY_IDEOGRAPH_F98B";
        case   0xF98C: return "CJK_COMPATIBILITY_IDEOGRAPH_F98C";
        case   0xF98D: return "CJK_COMPATIBILITY_IDEOGRAPH_F98D";
        case   0xF98E: return "CJK_COMPATIBILITY_IDEOGRAPH_F98E";
        case   0xF98F: return "CJK_COMPATIBILITY_IDEOGRAPH_F98F";
        case   0xF990: return "CJK_COMPATIBILITY_IDEOGRAPH_F990";
        case   0xF991: return "CJK_COMPATIBILITY_IDEOGRAPH_F991";
        case   0xF992: return "CJK_COMPATIBILITY_IDEOGRAPH_F992";
        case   0xF993: return "CJK_COMPATIBILITY_IDEOGRAPH_F993";
        case   0xF994: return "CJK_COMPATIBILITY_IDEOGRAPH_F994";
        case   0xF995: return "CJK_COMPATIBILITY_IDEOGRAPH_F995";
        case   0xF996: return "CJK_COMPATIBILITY_IDEOGRAPH_F996";
        case   0xF997: return "CJK_COMPATIBILITY_IDEOGRAPH_F997";
        case   0xF998: return "CJK_COMPATIBILITY_IDEOGRAPH_F998";
        case   0xF999: return "CJK_COMPATIBILITY_IDEOGRAPH_F999";
        case   0xF99A: return "CJK_COMPATIBILITY_IDEOGRAPH_F99A";
        case   0xF99B: return "CJK_COMPATIBILITY_IDEOGRAPH_F99B";
        case   0xF99C: return "CJK_COMPATIBILITY_IDEOGRAPH_F99C";
        case   0xF99D: return "CJK_COMPATIBILITY_IDEOGRAPH_F99D";
        case   0xF99E: return "CJK_COMPATIBILITY_IDEOGRAPH_F99E";
        case   0xF99F: return "CJK_COMPATIBILITY_IDEOGRAPH_F99F";
        case   0xF9A0: return "CJK_COMPATIBILITY_IDEOGRAPH_F9A0";
        case   0xF9A1: return "CJK_COMPATIBILITY_IDEOGRAPH_F9A1";
        case   0xF9A2: return "CJK_COMPATIBILITY_IDEOGRAPH_F9A2";
        case   0xF9A3: return "CJK_COMPATIBILITY_IDEOGRAPH_F9A3";
        case   0xF9A4: return "CJK_COMPATIBILITY_IDEOGRAPH_F9A4";
        case   0xF9A5: return "CJK_COMPATIBILITY_IDEOGRAPH_F9A5";
        case   0xF9A6: return "CJK_COMPATIBILITY_IDEOGRAPH_F9A6";
        case   0xF9A7: return "CJK_COMPATIBILITY_IDEOGRAPH_F9A7";
        case   0xF9A8: return "CJK_COMPATIBILITY_IDEOGRAPH_F9A8";
        case   0xF9A9: return "CJK_COMPATIBILITY_IDEOGRAPH_F9A9";
        case   0xF9AA: return "CJK_COMPATIBILITY_IDEOGRAPH_F9AA";
        case   0xF9AB: return "CJK_COMPATIBILITY_IDEOGRAPH_F9AB";
        case   0xF9AC: return "CJK_COMPATIBILITY_IDEOGRAPH_F9AC";
        case   0xF9AD: return "CJK_COMPATIBILITY_IDEOGRAPH_F9AD";
        case   0xF9AE: return "CJK_COMPATIBILITY_IDEOGRAPH_F9AE";
        case   0xF9AF: return "CJK_COMPATIBILITY_IDEOGRAPH_F9AF";
        case   0xF9B0: return "CJK_COMPATIBILITY_IDEOGRAPH_F9B0";
        case   0xF9B1: return "CJK_COMPATIBILITY_IDEOGRAPH_F9B1";
        case   0xF9B2: return "CJK_COMPATIBILITY_IDEOGRAPH_F9B2";
        case   0xF9B3: return "CJK_COMPATIBILITY_IDEOGRAPH_F9B3";
        case   0xF9B4: return "CJK_COMPATIBILITY_IDEOGRAPH_F9B4";
        case   0xF9B5: return "CJK_COMPATIBILITY_IDEOGRAPH_F9B5";
        case   0xF9B6: return "CJK_COMPATIBILITY_IDEOGRAPH_F9B6";
        case   0xF9B7: return "CJK_COMPATIBILITY_IDEOGRAPH_F9B7";
        case   0xF9B8: return "CJK_COMPATIBILITY_IDEOGRAPH_F9B8";
        case   0xF9B9: return "CJK_COMPATIBILITY_IDEOGRAPH_F9B9";
        case   0xF9BA: return "CJK_COMPATIBILITY_IDEOGRAPH_F9BA";
        case   0xF9BB: return "CJK_COMPATIBILITY_IDEOGRAPH_F9BB";
        case   0xF9BC: return "CJK_COMPATIBILITY_IDEOGRAPH_F9BC";
        case   0xF9BD: return "CJK_COMPATIBILITY_IDEOGRAPH_F9BD";
        case   0xF9BE: return "CJK_COMPATIBILITY_IDEOGRAPH_F9BE";
        case   0xF9BF: return "CJK_COMPATIBILITY_IDEOGRAPH_F9BF";
        case   0xF9C0: return "CJK_COMPATIBILITY_IDEOGRAPH_F9C0";
        case   0xF9C1: return "CJK_COMPATIBILITY_IDEOGRAPH_F9C1";
        case   0xF9C2: return "CJK_COMPATIBILITY_IDEOGRAPH_F9C2";
        case   0xF9C3: return "CJK_COMPATIBILITY_IDEOGRAPH_F9C3";
        case   0xF9C4: return "CJK_COMPATIBILITY_IDEOGRAPH_F9C4";
        case   0xF9C5: return "CJK_COMPATIBILITY_IDEOGRAPH_F9C5";
        case   0xF9C6: return "CJK_COMPATIBILITY_IDEOGRAPH_F9C6";
        case   0xF9C7: return "CJK_COMPATIBILITY_IDEOGRAPH_F9C7";
        case   0xF9C8: return "CJK_COMPATIBILITY_IDEOGRAPH_F9C8";
        case   0xF9C9: return "CJK_COMPATIBILITY_IDEOGRAPH_F9C9";
        case   0xF9CA: return "CJK_COMPATIBILITY_IDEOGRAPH_F9CA";
        case   0xF9CB: return "CJK_COMPATIBILITY_IDEOGRAPH_F9CB";
        case   0xF9CC: return "CJK_COMPATIBILITY_IDEOGRAPH_F9CC";
        case   0xF9CD: return "CJK_COMPATIBILITY_IDEOGRAPH_F9CD";
        case   0xF9CE: return "CJK_COMPATIBILITY_IDEOGRAPH_F9CE";
        case   0xF9CF: return "CJK_COMPATIBILITY_IDEOGRAPH_F9CF";
        case   0xF9D0: return "CJK_COMPATIBILITY_IDEOGRAPH_F9D0";
        case   0xF9D1: return "CJK_COMPATIBILITY_IDEOGRAPH_F9D1";
        case   0xF9D2: return "CJK_COMPATIBILITY_IDEOGRAPH_F9D2";
        case   0xF9D3: return "CJK_COMPATIBILITY_IDEOGRAPH_F9D3";
        case   0xF9D4: return "CJK_COMPATIBILITY_IDEOGRAPH_F9D4";
        case   0xF9D5: return "CJK_COMPATIBILITY_IDEOGRAPH_F9D5";
        case   0xF9D6: return "CJK_COMPATIBILITY_IDEOGRAPH_F9D6";
        case   0xF9D7: return "CJK_COMPATIBILITY_IDEOGRAPH_F9D7";
        case   0xF9D8: return "CJK_COMPATIBILITY_IDEOGRAPH_F9D8";
        case   0xF9D9: return "CJK_COMPATIBILITY_IDEOGRAPH_F9D9";
        case   0xF9DA: return "CJK_COMPATIBILITY_IDEOGRAPH_F9DA";
        case   0xF9DB: return "CJK_COMPATIBILITY_IDEOGRAPH_F9DB";
        case   0xF9DC: return "CJK_COMPATIBILITY_IDEOGRAPH_F9DC";
        case   0xF9DD: return "CJK_COMPATIBILITY_IDEOGRAPH_F9DD";
        case   0xF9DE: return "CJK_COMPATIBILITY_IDEOGRAPH_F9DE";
        case   0xF9DF: return "CJK_COMPATIBILITY_IDEOGRAPH_F9DF";
        case   0xF9E0: return "CJK_COMPATIBILITY_IDEOGRAPH_F9E0";
        case   0xF9E1: return "CJK_COMPATIBILITY_IDEOGRAPH_F9E1";
        case   0xF9E2: return "CJK_COMPATIBILITY_IDEOGRAPH_F9E2";
        case   0xF9E3: return "CJK_COMPATIBILITY_IDEOGRAPH_F9E3";
        case   0xF9E4: return "CJK_COMPATIBILITY_IDEOGRAPH_F9E4";
        case   0xF9E5: return "CJK_COMPATIBILITY_IDEOGRAPH_F9E5";
        case   0xF9E6: return "CJK_COMPATIBILITY_IDEOGRAPH_F9E6";
        case   0xF9E7: return "CJK_COMPATIBILITY_IDEOGRAPH_F9E7";
        case   0xF9E8: return "CJK_COMPATIBILITY_IDEOGRAPH_F9E8";
        case   0xF9E9: return "CJK_COMPATIBILITY_IDEOGRAPH_F9E9";
        case   0xF9EA: return "CJK_COMPATIBILITY_IDEOGRAPH_F9EA";
        case   0xF9EB: return "CJK_COMPATIBILITY_IDEOGRAPH_F9EB";
        case   0xF9EC: return "CJK_COMPATIBILITY_IDEOGRAPH_F9EC";
        case   0xF9ED: return "CJK_COMPATIBILITY_IDEOGRAPH_F9ED";
        case   0xF9EE: return "CJK_COMPATIBILITY_IDEOGRAPH_F9EE";
        case   0xF9EF: return "CJK_COMPATIBILITY_IDEOGRAPH_F9EF";
        case   0xF9F0: return "CJK_COMPATIBILITY_IDEOGRAPH_F9F0";
        case   0xF9F1: return "CJK_COMPATIBILITY_IDEOGRAPH_F9F1";
        case   0xF9F2: return "CJK_COMPATIBILITY_IDEOGRAPH_F9F2";
        case   0xF9F3: return "CJK_COMPATIBILITY_IDEOGRAPH_F9F3";
        case   0xF9F4: return "CJK_COMPATIBILITY_IDEOGRAPH_F9F4";
        case   0xF9F5: return "CJK_COMPATIBILITY_IDEOGRAPH_F9F5";
        case   0xF9F6: return "CJK_COMPATIBILITY_IDEOGRAPH_F9F6";
        case   0xF9F7: return "CJK_COMPATIBILITY_IDEOGRAPH_F9F7";
        case   0xF9F8: return "CJK_COMPATIBILITY_IDEOGRAPH_F9F8";
        case   0xF9F9: return "CJK_COMPATIBILITY_IDEOGRAPH_F9F9";
        case   0xF9FA: return "CJK_COMPATIBILITY_IDEOGRAPH_F9FA";
        case   0xF9FB: return "CJK_COMPATIBILITY_IDEOGRAPH_F9FB";
        case   0xF9FC: return "CJK_COMPATIBILITY_IDEOGRAPH_F9FC";
        case   0xF9FD: return "CJK_COMPATIBILITY_IDEOGRAPH_F9FD";
        case   0xF9FE: return "CJK_COMPATIBILITY_IDEOGRAPH_F9FE";
        case   0xF9FF: return "CJK_COMPATIBILITY_IDEOGRAPH_F9FF";
        case   0xFA00: return "CJK_COMPATIBILITY_IDEOGRAPH_FA00";
        case   0xFA01: return "CJK_COMPATIBILITY_IDEOGRAPH_FA01";
        case   0xFA02: return "CJK_COMPATIBILITY_IDEOGRAPH_FA02";
        case   0xFA03: return "CJK_COMPATIBILITY_IDEOGRAPH_FA03";
        case   0xFA04: return "CJK_COMPATIBILITY_IDEOGRAPH_FA04";
        case   0xFA05: return "CJK_COMPATIBILITY_IDEOGRAPH_FA05";
        case   0xFA06: return "CJK_COMPATIBILITY_IDEOGRAPH_FA06";
        case   0xFA07: return "CJK_COMPATIBILITY_IDEOGRAPH_FA07";
        case   0xFA08: return "CJK_COMPATIBILITY_IDEOGRAPH_FA08";
        case   0xFA09: return "CJK_COMPATIBILITY_IDEOGRAPH_FA09";
        case   0xFA0A: return "CJK_COMPATIBILITY_IDEOGRAPH_FA0A";
        case   0xFA0B: return "CJK_COMPATIBILITY_IDEOGRAPH_FA0B";
        case   0xFA0C: return "CJK_COMPATIBILITY_IDEOGRAPH_FA0C";
        case   0xFA0D: return "CJK_COMPATIBILITY_IDEOGRAPH_FA0D";
        case   0xFA0E: return "CJK_COMPATIBILITY_IDEOGRAPH_FA0E";
        case   0xFA0F: return "CJK_COMPATIBILITY_IDEOGRAPH_FA0F";
        case   0xFA10: return "CJK_COMPATIBILITY_IDEOGRAPH_FA10";
        case   0xFA11: return "CJK_COMPATIBILITY_IDEOGRAPH_FA11";
        case   0xFA12: return "CJK_COMPATIBILITY_IDEOGRAPH_FA12";
        case   0xFA13: return "CJK_COMPATIBILITY_IDEOGRAPH_FA13";
        case   0xFA14: return "CJK_COMPATIBILITY_IDEOGRAPH_FA14";
        case   0xFA15: return "CJK_COMPATIBILITY_IDEOGRAPH_FA15";
        case   0xFA16: return "CJK_COMPATIBILITY_IDEOGRAPH_FA16";
        case   0xFA17: return "CJK_COMPATIBILITY_IDEOGRAPH_FA17";
        case   0xFA18: return "CJK_COMPATIBILITY_IDEOGRAPH_FA18";
        case   0xFA19: return "CJK_COMPATIBILITY_IDEOGRAPH_FA19";
        case   0xFA1A: return "CJK_COMPATIBILITY_IDEOGRAPH_FA1A";
        case   0xFA1B: return "CJK_COMPATIBILITY_IDEOGRAPH_FA1B";
        case   0xFA1C: return "CJK_COMPATIBILITY_IDEOGRAPH_FA1C";
        case   0xFA1D: return "CJK_COMPATIBILITY_IDEOGRAPH_FA1D";
        case   0xFA1E: return "CJK_COMPATIBILITY_IDEOGRAPH_FA1E";
        case   0xFA1F: return "CJK_COMPATIBILITY_IDEOGRAPH_FA1F";
        case   0xFA20: return "CJK_COMPATIBILITY_IDEOGRAPH_FA20";
        case   0xFA21: return "CJK_COMPATIBILITY_IDEOGRAPH_FA21";
        case   0xFA22: return "CJK_COMPATIBILITY_IDEOGRAPH_FA22";
        case   0xFA23: return "CJK_COMPATIBILITY_IDEOGRAPH_FA23";
        case   0xFA24: return "CJK_COMPATIBILITY_IDEOGRAPH_FA24";
        case   0xFA25: return "CJK_COMPATIBILITY_IDEOGRAPH_FA25";
        case   0xFA26: return "CJK_COMPATIBILITY_IDEOGRAPH_FA26";
        case   0xFA27: return "CJK_COMPATIBILITY_IDEOGRAPH_FA27";
        case   0xFA28: return "CJK_COMPATIBILITY_IDEOGRAPH_FA28";
        case   0xFA29: return "CJK_COMPATIBILITY_IDEOGRAPH_FA29";
        case   0xFA2A: return "CJK_COMPATIBILITY_IDEOGRAPH_FA2A";
        case   0xFA2B: return "CJK_COMPATIBILITY_IDEOGRAPH_FA2B";
        case   0xFA2C: return "CJK_COMPATIBILITY_IDEOGRAPH_FA2C";
        case   0xFA2D: return "CJK_COMPATIBILITY_IDEOGRAPH_FA2D";
        case   0xFA2E: return "CJK_COMPATIBILITY_IDEOGRAPH_FA2E";
        case   0xFA2F: return "CJK_COMPATIBILITY_IDEOGRAPH_FA2F";
        case   0xFA30: return "CJK_COMPATIBILITY_IDEOGRAPH_FA30";
        case   0xFA31: return "CJK_COMPATIBILITY_IDEOGRAPH_FA31";
        case   0xFA32: return "CJK_COMPATIBILITY_IDEOGRAPH_FA32";
        case   0xFA33: return "CJK_COMPATIBILITY_IDEOGRAPH_FA33";
        case   0xFA34: return "CJK_COMPATIBILITY_IDEOGRAPH_FA34";
        case   0xFA35: return "CJK_COMPATIBILITY_IDEOGRAPH_FA35";
        case   0xFA36: return "CJK_COMPATIBILITY_IDEOGRAPH_FA36";
        case   0xFA37: return "CJK_COMPATIBILITY_IDEOGRAPH_FA37";
        case   0xFA38: return "CJK_COMPATIBILITY_IDEOGRAPH_FA38";
        case   0xFA39: return "CJK_COMPATIBILITY_IDEOGRAPH_FA39";
        case   0xFA3A: return "CJK_COMPATIBILITY_IDEOGRAPH_FA3A";
        case   0xFA3B: return "CJK_COMPATIBILITY_IDEOGRAPH_FA3B";
        case   0xFA3C: return "CJK_COMPATIBILITY_IDEOGRAPH_FA3C";
        case   0xFA3D: return "CJK_COMPATIBILITY_IDEOGRAPH_FA3D";
        case   0xFA3E: return "CJK_COMPATIBILITY_IDEOGRAPH_FA3E";
        case   0xFA3F: return "CJK_COMPATIBILITY_IDEOGRAPH_FA3F";
        case   0xFA40: return "CJK_COMPATIBILITY_IDEOGRAPH_FA40";
        case   0xFA41: return "CJK_COMPATIBILITY_IDEOGRAPH_FA41";
        case   0xFA42: return "CJK_COMPATIBILITY_IDEOGRAPH_FA42";
        case   0xFA43: return "CJK_COMPATIBILITY_IDEOGRAPH_FA43";
        case   0xFA44: return "CJK_COMPATIBILITY_IDEOGRAPH_FA44";
        case   0xFA45: return "CJK_COMPATIBILITY_IDEOGRAPH_FA45";
        case   0xFA46: return "CJK_COMPATIBILITY_IDEOGRAPH_FA46";
        case   0xFA47: return "CJK_COMPATIBILITY_IDEOGRAPH_FA47";
        case   0xFA48: return "CJK_COMPATIBILITY_IDEOGRAPH_FA48";
        case   0xFA49: return "CJK_COMPATIBILITY_IDEOGRAPH_FA49";
        case   0xFA4A: return "CJK_COMPATIBILITY_IDEOGRAPH_FA4A";
        case   0xFA4B: return "CJK_COMPATIBILITY_IDEOGRAPH_FA4B";
        case   0xFA4C: return "CJK_COMPATIBILITY_IDEOGRAPH_FA4C";
        case   0xFA4D: return "CJK_COMPATIBILITY_IDEOGRAPH_FA4D";
        case   0xFA4E: return "CJK_COMPATIBILITY_IDEOGRAPH_FA4E";
        case   0xFA4F: return "CJK_COMPATIBILITY_IDEOGRAPH_FA4F";
        case   0xFA50: return "CJK_COMPATIBILITY_IDEOGRAPH_FA50";
        case   0xFA51: return "CJK_COMPATIBILITY_IDEOGRAPH_FA51";
        case   0xFA52: return "CJK_COMPATIBILITY_IDEOGRAPH_FA52";
        case   0xFA53: return "CJK_COMPATIBILITY_IDEOGRAPH_FA53";
        case   0xFA54: return "CJK_COMPATIBILITY_IDEOGRAPH_FA54";
        case   0xFA55: return "CJK_COMPATIBILITY_IDEOGRAPH_FA55";
        case   0xFA56: return "CJK_COMPATIBILITY_IDEOGRAPH_FA56";
        case   0xFA57: return "CJK_COMPATIBILITY_IDEOGRAPH_FA57";
        case   0xFA58: return "CJK_COMPATIBILITY_IDEOGRAPH_FA58";
        case   0xFA59: return "CJK_COMPATIBILITY_IDEOGRAPH_FA59";
        case   0xFA5A: return "CJK_COMPATIBILITY_IDEOGRAPH_FA5A";
        case   0xFA5B: return "CJK_COMPATIBILITY_IDEOGRAPH_FA5B";
        case   0xFA5C: return "CJK_COMPATIBILITY_IDEOGRAPH_FA5C";
        case   0xFA5D: return "CJK_COMPATIBILITY_IDEOGRAPH_FA5D";
        case   0xFA5E: return "CJK_COMPATIBILITY_IDEOGRAPH_FA5E";
        case   0xFA5F: return "CJK_COMPATIBILITY_IDEOGRAPH_FA5F";
        case   0xFA60: return "CJK_COMPATIBILITY_IDEOGRAPH_FA60";
        case   0xFA61: return "CJK_COMPATIBILITY_IDEOGRAPH_FA61";
        case   0xFA62: return "CJK_COMPATIBILITY_IDEOGRAPH_FA62";
        case   0xFA63: return "CJK_COMPATIBILITY_IDEOGRAPH_FA63";
        case   0xFA64: return "CJK_COMPATIBILITY_IDEOGRAPH_FA64";
        case   0xFA65: return "CJK_COMPATIBILITY_IDEOGRAPH_FA65";
        case   0xFA66: return "CJK_COMPATIBILITY_IDEOGRAPH_FA66";
        case   0xFA67: return "CJK_COMPATIBILITY_IDEOGRAPH_FA67";
        case   0xFA68: return "CJK_COMPATIBILITY_IDEOGRAPH_FA68";
        case   0xFA69: return "CJK_COMPATIBILITY_IDEOGRAPH_FA69";
        case   0xFA6A: return "CJK_COMPATIBILITY_IDEOGRAPH_FA6A";
        case   0xFA6B: return "CJK_COMPATIBILITY_IDEOGRAPH_FA6B";
        case   0xFA6C: return "CJK_COMPATIBILITY_IDEOGRAPH_FA6C";
        case   0xFA6D: return "CJK_COMPATIBILITY_IDEOGRAPH_FA6D";
        case   0xFA70: return "CJK_COMPATIBILITY_IDEOGRAPH_FA70";
        case   0xFA71: return "CJK_COMPATIBILITY_IDEOGRAPH_FA71";
        case   0xFA72: return "CJK_COMPATIBILITY_IDEOGRAPH_FA72";
        case   0xFA73: return "CJK_COMPATIBILITY_IDEOGRAPH_FA73";
        case   0xFA74: return "CJK_COMPATIBILITY_IDEOGRAPH_FA74";
        case   0xFA75: return "CJK_COMPATIBILITY_IDEOGRAPH_FA75";
        case   0xFA76: return "CJK_COMPATIBILITY_IDEOGRAPH_FA76";
        case   0xFA77: return "CJK_COMPATIBILITY_IDEOGRAPH_FA77";
        case   0xFA78: return "CJK_COMPATIBILITY_IDEOGRAPH_FA78";
        case   0xFA79: return "CJK_COMPATIBILITY_IDEOGRAPH_FA79";
        case   0xFA7A: return "CJK_COMPATIBILITY_IDEOGRAPH_FA7A";
        case   0xFA7B: return "CJK_COMPATIBILITY_IDEOGRAPH_FA7B";
        case   0xFA7C: return "CJK_COMPATIBILITY_IDEOGRAPH_FA7C";
        case   0xFA7D: return "CJK_COMPATIBILITY_IDEOGRAPH_FA7D";
        case   0xFA7E: return "CJK_COMPATIBILITY_IDEOGRAPH_FA7E";
        case   0xFA7F: return "CJK_COMPATIBILITY_IDEOGRAPH_FA7F";
        case   0xFA80: return "CJK_COMPATIBILITY_IDEOGRAPH_FA80";
        case   0xFA81: return "CJK_COMPATIBILITY_IDEOGRAPH_FA81";
        case   0xFA82: return "CJK_COMPATIBILITY_IDEOGRAPH_FA82";
        case   0xFA83: return "CJK_COMPATIBILITY_IDEOGRAPH_FA83";
        case   0xFA84: return "CJK_COMPATIBILITY_IDEOGRAPH_FA84";
        case   0xFA85: return "CJK_COMPATIBILITY_IDEOGRAPH_FA85";
        case   0xFA86: return "CJK_COMPATIBILITY_IDEOGRAPH_FA86";
        case   0xFA87: return "CJK_COMPATIBILITY_IDEOGRAPH_FA87";
        case   0xFA88: return "CJK_COMPATIBILITY_IDEOGRAPH_FA88";
        case   0xFA89: return "CJK_COMPATIBILITY_IDEOGRAPH_FA89";
        case   0xFA8A: return "CJK_COMPATIBILITY_IDEOGRAPH_FA8A";
        case   0xFA8B: return "CJK_COMPATIBILITY_IDEOGRAPH_FA8B";
        case   0xFA8C: return "CJK_COMPATIBILITY_IDEOGRAPH_FA8C";
        case   0xFA8D: return "CJK_COMPATIBILITY_IDEOGRAPH_FA8D";
        case   0xFA8E: return "CJK_COMPATIBILITY_IDEOGRAPH_FA8E";
        case   0xFA8F: return "CJK_COMPATIBILITY_IDEOGRAPH_FA8F";
        case   0xFA90: return "CJK_COMPATIBILITY_IDEOGRAPH_FA90";
        case   0xFA91: return "CJK_COMPATIBILITY_IDEOGRAPH_FA91";
        case   0xFA92: return "CJK_COMPATIBILITY_IDEOGRAPH_FA92";
        case   0xFA93: return "CJK_COMPATIBILITY_IDEOGRAPH_FA93";
        case   0xFA94: return "CJK_COMPATIBILITY_IDEOGRAPH_FA94";
        case   0xFA95: return "CJK_COMPATIBILITY_IDEOGRAPH_FA95";
        case   0xFA96: return "CJK_COMPATIBILITY_IDEOGRAPH_FA96";
        case   0xFA97: return "CJK_COMPATIBILITY_IDEOGRAPH_FA97";
        case   0xFA98: return "CJK_COMPATIBILITY_IDEOGRAPH_FA98";
        case   0xFA99: return "CJK_COMPATIBILITY_IDEOGRAPH_FA99";
        case   0xFA9A: return "CJK_COMPATIBILITY_IDEOGRAPH_FA9A";
        case   0xFA9B: return "CJK_COMPATIBILITY_IDEOGRAPH_FA9B";
        case   0xFA9C: return "CJK_COMPATIBILITY_IDEOGRAPH_FA9C";
        case   0xFA9D: return "CJK_COMPATIBILITY_IDEOGRAPH_FA9D";
        case   0xFA9E: return "CJK_COMPATIBILITY_IDEOGRAPH_FA9E";
        case   0xFA9F: return "CJK_COMPATIBILITY_IDEOGRAPH_FA9F";
        case   0xFAA0: return "CJK_COMPATIBILITY_IDEOGRAPH_FAA0";
        case   0xFAA1: return "CJK_COMPATIBILITY_IDEOGRAPH_FAA1";
        case   0xFAA2: return "CJK_COMPATIBILITY_IDEOGRAPH_FAA2";
        case   0xFAA3: return "CJK_COMPATIBILITY_IDEOGRAPH_FAA3";
        case   0xFAA4: return "CJK_COMPATIBILITY_IDEOGRAPH_FAA4";
        case   0xFAA5: return "CJK_COMPATIBILITY_IDEOGRAPH_FAA5";
        case   0xFAA6: return "CJK_COMPATIBILITY_IDEOGRAPH_FAA6";
        case   0xFAA7: return "CJK_COMPATIBILITY_IDEOGRAPH_FAA7";
        case   0xFAA8: return "CJK_COMPATIBILITY_IDEOGRAPH_FAA8";
        case   0xFAA9: return "CJK_COMPATIBILITY_IDEOGRAPH_FAA9";
        case   0xFAAA: return "CJK_COMPATIBILITY_IDEOGRAPH_FAAA";
        case   0xFAAB: return "CJK_COMPATIBILITY_IDEOGRAPH_FAAB";
        case   0xFAAC: return "CJK_COMPATIBILITY_IDEOGRAPH_FAAC";
        case   0xFAAD: return "CJK_COMPATIBILITY_IDEOGRAPH_FAAD";
        case   0xFAAE: return "CJK_COMPATIBILITY_IDEOGRAPH_FAAE";
        case   0xFAAF: return "CJK_COMPATIBILITY_IDEOGRAPH_FAAF";
        case   0xFAB0: return "CJK_COMPATIBILITY_IDEOGRAPH_FAB0";
        case   0xFAB1: return "CJK_COMPATIBILITY_IDEOGRAPH_FAB1";
        case   0xFAB2: return "CJK_COMPATIBILITY_IDEOGRAPH_FAB2";
        case   0xFAB3: return "CJK_COMPATIBILITY_IDEOGRAPH_FAB3";
        case   0xFAB4: return "CJK_COMPATIBILITY_IDEOGRAPH_FAB4";
        case   0xFAB5: return "CJK_COMPATIBILITY_IDEOGRAPH_FAB5";
        case   0xFAB6: return "CJK_COMPATIBILITY_IDEOGRAPH_FAB6";
        case   0xFAB7: return "CJK_COMPATIBILITY_IDEOGRAPH_FAB7";
        case   0xFAB8: return "CJK_COMPATIBILITY_IDEOGRAPH_FAB8";
        case   0xFAB9: return "CJK_COMPATIBILITY_IDEOGRAPH_FAB9";
        case   0xFABA: return "CJK_COMPATIBILITY_IDEOGRAPH_FABA";
        case   0xFABB: return "CJK_COMPATIBILITY_IDEOGRAPH_FABB";
        case   0xFABC: return "CJK_COMPATIBILITY_IDEOGRAPH_FABC";
        case   0xFABD: return "CJK_COMPATIBILITY_IDEOGRAPH_FABD";
        case   0xFABE: return "CJK_COMPATIBILITY_IDEOGRAPH_FABE";
        case   0xFABF: return "CJK_COMPATIBILITY_IDEOGRAPH_FABF";
        case   0xFAC0: return "CJK_COMPATIBILITY_IDEOGRAPH_FAC0";
        case   0xFAC1: return "CJK_COMPATIBILITY_IDEOGRAPH_FAC1";
        case   0xFAC2: return "CJK_COMPATIBILITY_IDEOGRAPH_FAC2";
        case   0xFAC3: return "CJK_COMPATIBILITY_IDEOGRAPH_FAC3";
        case   0xFAC4: return "CJK_COMPATIBILITY_IDEOGRAPH_FAC4";
        case   0xFAC5: return "CJK_COMPATIBILITY_IDEOGRAPH_FAC5";
        case   0xFAC6: return "CJK_COMPATIBILITY_IDEOGRAPH_FAC6";
        case   0xFAC7: return "CJK_COMPATIBILITY_IDEOGRAPH_FAC7";
        case   0xFAC8: return "CJK_COMPATIBILITY_IDEOGRAPH_FAC8";
        case   0xFAC9: return "CJK_COMPATIBILITY_IDEOGRAPH_FAC9";
        case   0xFACA: return "CJK_COMPATIBILITY_IDEOGRAPH_FACA";
        case   0xFACB: return "CJK_COMPATIBILITY_IDEOGRAPH_FACB";
        case   0xFACC: return "CJK_COMPATIBILITY_IDEOGRAPH_FACC";
        case   0xFACD: return "CJK_COMPATIBILITY_IDEOGRAPH_FACD";
        case   0xFACE: return "CJK_COMPATIBILITY_IDEOGRAPH_FACE";
        case   0xFACF: return "CJK_COMPATIBILITY_IDEOGRAPH_FACF";
        case   0xFAD0: return "CJK_COMPATIBILITY_IDEOGRAPH_FAD0";
        case   0xFAD1: return "CJK_COMPATIBILITY_IDEOGRAPH_FAD1";
        case   0xFAD2: return "CJK_COMPATIBILITY_IDEOGRAPH_FAD2";
        case   0xFAD3: return "CJK_COMPATIBILITY_IDEOGRAPH_FAD3";
        case   0xFAD4: return "CJK_COMPATIBILITY_IDEOGRAPH_FAD4";
        case   0xFAD5: return "CJK_COMPATIBILITY_IDEOGRAPH_FAD5";
        case   0xFAD6: return "CJK_COMPATIBILITY_IDEOGRAPH_FAD6";
        case   0xFAD7: return "CJK_COMPATIBILITY_IDEOGRAPH_FAD7";
        case   0xFAD8: return "CJK_COMPATIBILITY_IDEOGRAPH_FAD8";
        case   0xFAD9: return "CJK_COMPATIBILITY_IDEOGRAPH_FAD9";
        case   0xFB00: return "LATIN_SMALL_LIGATURE_FF";
        case   0xFB01: return "LATIN_SMALL_LIGATURE_FI";
        case   0xFB02: return "LATIN_SMALL_LIGATURE_FL";
        case   0xFB03: return "LATIN_SMALL_LIGATURE_FFI";
        case   0xFB04: return "LATIN_SMALL_LIGATURE_FFL";
        case   0xFB05: return "LATIN_SMALL_LIGATURE_LONG_S_T";
        case   0xFB06: return "LATIN_SMALL_LIGATURE_ST";
        case   0xFB13: return "ARMENIAN_SMALL_LIGATURE_MEN_NOW";
        case   0xFB14: return "ARMENIAN_SMALL_LIGATURE_MEN_ECH";
        case   0xFB15: return "ARMENIAN_SMALL_LIGATURE_MEN_INI";
        case   0xFB16: return "ARMENIAN_SMALL_LIGATURE_VEW_NOW";
        case   0xFB17: return "ARMENIAN_SMALL_LIGATURE_MEN_XEH";
        case   0xFB1D: return "HEBREW_LETTER_YOD_WITH_HIRIQ";
        case   0xFB1E: return "HEBREW_POINT_JUDEO_SPANISH_VARIKA";
        case   0xFB1F: return "HEBREW_LIGATURE_YIDDISH_YOD_YOD_PATAH";
        case   0xFB20: return "HEBREW_LETTER_ALTERNATIVE_AYIN";
        case   0xFB21: return "HEBREW_LETTER_WIDE_ALEF";
        case   0xFB22: return "HEBREW_LETTER_WIDE_DALET";
        case   0xFB23: return "HEBREW_LETTER_WIDE_HE";
        case   0xFB24: return "HEBREW_LETTER_WIDE_KAF";
        case   0xFB25: return "HEBREW_LETTER_WIDE_LAMED";
        case   0xFB26: return "HEBREW_LETTER_WIDE_FINAL_MEM";
        case   0xFB27: return "HEBREW_LETTER_WIDE_RESH";
        case   0xFB28: return "HEBREW_LETTER_WIDE_TAV";
        case   0xFB29: return "HEBREW_LETTER_ALTERNATIVE_PLUS_SIGN";
        case   0xFB2A: return "HEBREW_LETTER_SHIN_WITH_SHIN_DOT";
        case   0xFB2B: return "HEBREW_LETTER_SHIN_WITH_SIN_DOT";
        case   0xFB2C: return "HEBREW_LETTER_SHIN_WITH_DAGESH_AND_SHIN_DOT";
        case   0xFB2D: return "HEBREW_LETTER_SHIN_WITH_DAGESH_AND_SIN_DOT";
        case   0xFB2E: return "HEBREW_LETTER_ALEF_WITH_PATAH";
        case   0xFB2F: return "HEBREW_LETTER_ALEF_WITH_QAMATS";
        case   0xFB30: return "HEBREW_LETTER_ALEF_WITH_MAPIQ";
        case   0xFB31: return "HEBREW_LETTER_BET_WITH_DAGESH";
        case   0xFB32: return "HEBREW_LETTER_GIMEL_WITH_DAGESH";
        case   0xFB33: return "HEBREW_LETTER_DALET_WITH_DAGESH";
        case   0xFB34: return "HEBREW_LETTER_HE_WITH_MAPIQ";
        case   0xFB35: return "HEBREW_LETTER_VAV_WITH_DAGESH";
        case   0xFB36: return "HEBREW_LETTER_ZAYIN_WITH_DAGESH";
        case   0xFB38: return "HEBREW_LETTER_TET_WITH_DAGESH";
        case   0xFB39: return "HEBREW_LETTER_YOD_WITH_DAGESH";
        case   0xFB3A: return "HEBREW_LETTER_FINAL_KAF_WITH_DAGESH";
        case   0xFB3B: return "HEBREW_LETTER_KAF_WITH_DAGESH";
        case   0xFB3C: return "HEBREW_LETTER_LAMED_WITH_DAGESH";
        case   0xFB3E: return "HEBREW_LETTER_MEM_WITH_DAGESH";
        case   0xFB40: return "HEBREW_LETTER_NUN_WITH_DAGESH";
        case   0xFB41: return "HEBREW_LETTER_SAMEKH_WITH_DAGESH";
        case   0xFB43: return "HEBREW_LETTER_FINAL_PE_WITH_DAGESH";
        case   0xFB44: return "HEBREW_LETTER_PE_WITH_DAGESH";
        case   0xFB46: return "HEBREW_LETTER_TSADI_WITH_DAGESH";
        case   0xFB47: return "HEBREW_LETTER_QOF_WITH_DAGESH";
        case   0xFB48: return "HEBREW_LETTER_RESH_WITH_DAGESH";
        case   0xFB49: return "HEBREW_LETTER_SHIN_WITH_DAGESH";
        case   0xFB4A: return "HEBREW_LETTER_TAV_WITH_DAGESH";
        case   0xFB4B: return "HEBREW_LETTER_VAV_WITH_HOLAM";
        case   0xFB4C: return "HEBREW_LETTER_BET_WITH_RAFE";
        case   0xFB4D: return "HEBREW_LETTER_KAF_WITH_RAFE";
        case   0xFB4E: return "HEBREW_LETTER_PE_WITH_RAFE";
        case   0xFB4F: return "HEBREW_LIGATURE_ALEF_LAMED";
        case   0xFB50: return "ARABIC_LETTER_ALEF_WASLA_ISOLATED_FORM";
        case   0xFB51: return "ARABIC_LETTER_ALEF_WASLA_FINAL_FORM";
        case   0xFB52: return "ARABIC_LETTER_BEEH_ISOLATED_FORM";
        case   0xFB53: return "ARABIC_LETTER_BEEH_FINAL_FORM";
        case   0xFB54: return "ARABIC_LETTER_BEEH_INITIAL_FORM";
        case   0xFB55: return "ARABIC_LETTER_BEEH_MEDIAL_FORM";
        case   0xFB56: return "ARABIC_LETTER_PEH_ISOLATED_FORM";
        case   0xFB57: return "ARABIC_LETTER_PEH_FINAL_FORM";
        case   0xFB58: return "ARABIC_LETTER_PEH_INITIAL_FORM";
        case   0xFB59: return "ARABIC_LETTER_PEH_MEDIAL_FORM";
        case   0xFB5A: return "ARABIC_LETTER_BEHEH_ISOLATED_FORM";
        case   0xFB5B: return "ARABIC_LETTER_BEHEH_FINAL_FORM";
        case   0xFB5C: return "ARABIC_LETTER_BEHEH_INITIAL_FORM";
        case   0xFB5D: return "ARABIC_LETTER_BEHEH_MEDIAL_FORM";
        case   0xFB5E: return "ARABIC_LETTER_TTEHEH_ISOLATED_FORM";
        case   0xFB5F: return "ARABIC_LETTER_TTEHEH_FINAL_FORM";
        case   0xFB60: return "ARABIC_LETTER_TTEHEH_INITIAL_FORM";
        case   0xFB61: return "ARABIC_LETTER_TTEHEH_MEDIAL_FORM";
        case   0xFB62: return "ARABIC_LETTER_TEHEH_ISOLATED_FORM";
        case   0xFB63: return "ARABIC_LETTER_TEHEH_FINAL_FORM";
        case   0xFB64: return "ARABIC_LETTER_TEHEH_INITIAL_FORM";
        case   0xFB65: return "ARABIC_LETTER_TEHEH_MEDIAL_FORM";
        case   0xFB66: return "ARABIC_LETTER_TTEH_ISOLATED_FORM";
        case   0xFB67: return "ARABIC_LETTER_TTEH_FINAL_FORM";
        case   0xFB68: return "ARABIC_LETTER_TTEH_INITIAL_FORM";
        case   0xFB69: return "ARABIC_LETTER_TTEH_MEDIAL_FORM";
        case   0xFB6A: return "ARABIC_LETTER_VEH_ISOLATED_FORM";
        case   0xFB6B: return "ARABIC_LETTER_VEH_FINAL_FORM";
        case   0xFB6C: return "ARABIC_LETTER_VEH_INITIAL_FORM";
        case   0xFB6D: return "ARABIC_LETTER_VEH_MEDIAL_FORM";
        case   0xFB6E: return "ARABIC_LETTER_PEHEH_ISOLATED_FORM";
        case   0xFB6F: return "ARABIC_LETTER_PEHEH_FINAL_FORM";
        case   0xFB70: return "ARABIC_LETTER_PEHEH_INITIAL_FORM";
        case   0xFB71: return "ARABIC_LETTER_PEHEH_MEDIAL_FORM";
        case   0xFB72: return "ARABIC_LETTER_DYEH_ISOLATED_FORM";
        case   0xFB73: return "ARABIC_LETTER_DYEH_FINAL_FORM";
        case   0xFB74: return "ARABIC_LETTER_DYEH_INITIAL_FORM";
        case   0xFB75: return "ARABIC_LETTER_DYEH_MEDIAL_FORM";
        case   0xFB76: return "ARABIC_LETTER_NYEH_ISOLATED_FORM";
        case   0xFB77: return "ARABIC_LETTER_NYEH_FINAL_FORM";
        case   0xFB78: return "ARABIC_LETTER_NYEH_INITIAL_FORM";
        case   0xFB79: return "ARABIC_LETTER_NYEH_MEDIAL_FORM";
        case   0xFB7A: return "ARABIC_LETTER_TCHEH_ISOLATED_FORM";
        case   0xFB7B: return "ARABIC_LETTER_TCHEH_FINAL_FORM";
        case   0xFB7C: return "ARABIC_LETTER_TCHEH_INITIAL_FORM";
        case   0xFB7D: return "ARABIC_LETTER_TCHEH_MEDIAL_FORM";
        case   0xFB7E: return "ARABIC_LETTER_TCHEHEH_ISOLATED_FORM";
        case   0xFB7F: return "ARABIC_LETTER_TCHEHEH_FINAL_FORM";
        case   0xFB80: return "ARABIC_LETTER_TCHEHEH_INITIAL_FORM";
        case   0xFB81: return "ARABIC_LETTER_TCHEHEH_MEDIAL_FORM";
        case   0xFB82: return "ARABIC_LETTER_DDAHAL_ISOLATED_FORM";
        case   0xFB83: return "ARABIC_LETTER_DDAHAL_FINAL_FORM";
        case   0xFB84: return "ARABIC_LETTER_DAHAL_ISOLATED_FORM";
        case   0xFB85: return "ARABIC_LETTER_DAHAL_FINAL_FORM";
        case   0xFB86: return "ARABIC_LETTER_DUL_ISOLATED_FORM";
        case   0xFB87: return "ARABIC_LETTER_DUL_FINAL_FORM";
        case   0xFB88: return "ARABIC_LETTER_DDAL_ISOLATED_FORM";
        case   0xFB89: return "ARABIC_LETTER_DDAL_FINAL_FORM";
        case   0xFB8A: return "ARABIC_LETTER_JEH_ISOLATED_FORM";
        case   0xFB8B: return "ARABIC_LETTER_JEH_FINAL_FORM";
        case   0xFB8C: return "ARABIC_LETTER_RREH_ISOLATED_FORM";
        case   0xFB8D: return "ARABIC_LETTER_RREH_FINAL_FORM";
        case   0xFB8E: return "ARABIC_LETTER_KEHEH_ISOLATED_FORM";
        case   0xFB8F: return "ARABIC_LETTER_KEHEH_FINAL_FORM";
        case   0xFB90: return "ARABIC_LETTER_KEHEH_INITIAL_FORM";
        case   0xFB91: return "ARABIC_LETTER_KEHEH_MEDIAL_FORM";
        case   0xFB92: return "ARABIC_LETTER_GAF_ISOLATED_FORM";
        case   0xFB93: return "ARABIC_LETTER_GAF_FINAL_FORM";
        case   0xFB94: return "ARABIC_LETTER_GAF_INITIAL_FORM";
        case   0xFB95: return "ARABIC_LETTER_GAF_MEDIAL_FORM";
        case   0xFB96: return "ARABIC_LETTER_GUEH_ISOLATED_FORM";
        case   0xFB97: return "ARABIC_LETTER_GUEH_FINAL_FORM";
        case   0xFB98: return "ARABIC_LETTER_GUEH_INITIAL_FORM";
        case   0xFB99: return "ARABIC_LETTER_GUEH_MEDIAL_FORM";
        case   0xFB9A: return "ARABIC_LETTER_NGOEH_ISOLATED_FORM";
        case   0xFB9B: return "ARABIC_LETTER_NGOEH_FINAL_FORM";
        case   0xFB9C: return "ARABIC_LETTER_NGOEH_INITIAL_FORM";
        case   0xFB9D: return "ARABIC_LETTER_NGOEH_MEDIAL_FORM";
        case   0xFB9E: return "ARABIC_LETTER_NOON_GHUNNA_ISOLATED_FORM";
        case   0xFB9F: return "ARABIC_LETTER_NOON_GHUNNA_FINAL_FORM";
        case   0xFBA0: return "ARABIC_LETTER_RNOON_ISOLATED_FORM";
        case   0xFBA1: return "ARABIC_LETTER_RNOON_FINAL_FORM";
        case   0xFBA2: return "ARABIC_LETTER_RNOON_INITIAL_FORM";
        case   0xFBA3: return "ARABIC_LETTER_RNOON_MEDIAL_FORM";
        case   0xFBA4: return
                "ARABIC_LETTER_HEH_WITH_YEH_ABOVE_ISOLATED_FORM";
        case   0xFBA5: return "ARABIC_LETTER_HEH_WITH_YEH_ABOVE_FINAL_FORM";
        case   0xFBA6: return "ARABIC_LETTER_HEH_GOAL_ISOLATED_FORM";
        case   0xFBA7: return "ARABIC_LETTER_HEH_GOAL_FINAL_FORM";
        case   0xFBA8: return "ARABIC_LETTER_HEH_GOAL_INITIAL_FORM";
        case   0xFBA9: return "ARABIC_LETTER_HEH_GOAL_MEDIAL_FORM";
        case   0xFBAA: return "ARABIC_LETTER_HEH_DOACHASHMEE_ISOLATED_FORM";
        case   0xFBAB: return "ARABIC_LETTER_HEH_DOACHASHMEE_FINAL_FORM";
        case   0xFBAC: return "ARABIC_LETTER_HEH_DOACHASHMEE_INITIAL_FORM";
        case   0xFBAD: return "ARABIC_LETTER_HEH_DOACHASHMEE_MEDIAL_FORM";
        case   0xFBAE: return "ARABIC_LETTER_YEH_BARREE_ISOLATED_FORM";
        case   0xFBAF: return "ARABIC_LETTER_YEH_BARREE_FINAL_FORM";
        case   0xFBB0: return
                "ARABIC_LETTER_YEH_BARREE_WITH_HAMZA_ABOVE_ISOLATED_FORM";
        case   0xFBB1: return
                "ARABIC_LETTER_YEH_BARREE_WITH_HAMZA_ABOVE_FINAL_FORM";
        case   0xFBB2: return "ARABIC_SYMBOL_DOT_ABOVE";
        case   0xFBB3: return "ARABIC_SYMBOL_DOT_BELOW";
        case   0xFBB4: return "ARABIC_SYMBOL_TWO_DOTS_ABOVE";
        case   0xFBB5: return "ARABIC_SYMBOL_TWO_DOTS_BELOW";
        case   0xFBB6: return "ARABIC_SYMBOL_THREE_DOTS_ABOVE";
        case   0xFBB7: return "ARABIC_SYMBOL_THREE_DOTS_BELOW";
        case   0xFBB8: return
                "ARABIC_SYMBOL_THREE_DOTS_POINTING_DOWNWARDS_ABOVE";
        case   0xFBB9: return
                "ARABIC_SYMBOL_THREE_DOTS_POINTING_DOWNWARDS_BELOW";
        case   0xFBBA: return "ARABIC_SYMBOL_FOUR_DOTS_ABOVE";
        case   0xFBBB: return "ARABIC_SYMBOL_FOUR_DOTS_BELOW";
        case   0xFBBC: return "ARABIC_SYMBOL_DOUBLE_VERTICAL_BAR_BELOW";
        case   0xFBBD: return "ARABIC_SYMBOL_TWO_DOTS_VERTICALLY_ABOVE";
        case   0xFBBE: return "ARABIC_SYMBOL_TWO_DOTS_VERTICALLY_BELOW";
        case   0xFBBF: return "ARABIC_SYMBOL_RING";
        case   0xFBC0: return "ARABIC_SYMBOL_SMALL_TAH_ABOVE";
        case   0xFBC1: return "ARABIC_SYMBOL_SMALL_TAH_BELOW";
        case   0xFBD3: return "ARABIC_LETTER_NG_ISOLATED_FORM";
        case   0xFBD4: return "ARABIC_LETTER_NG_FINAL_FORM";
        case   0xFBD5: return "ARABIC_LETTER_NG_INITIAL_FORM";
        case   0xFBD6: return "ARABIC_LETTER_NG_MEDIAL_FORM";
        case   0xFBD7: return "ARABIC_LETTER_U_ISOLATED_FORM";
        case   0xFBD8: return "ARABIC_LETTER_U_FINAL_FORM";
        case   0xFBD9: return "ARABIC_LETTER_OE_ISOLATED_FORM";
        case   0xFBDA: return "ARABIC_LETTER_OE_FINAL_FORM";
        case   0xFBDB: return "ARABIC_LETTER_YU_ISOLATED_FORM";
        case   0xFBDC: return "ARABIC_LETTER_YU_FINAL_FORM";
        case   0xFBDD: return
                "ARABIC_LETTER_U_WITH_HAMZA_ABOVE_ISOLATED_FORM";
        case   0xFBDE: return "ARABIC_LETTER_VE_ISOLATED_FORM";
        case   0xFBDF: return "ARABIC_LETTER_VE_FINAL_FORM";
        case   0xFBE0: return "ARABIC_LETTER_KIRGHIZ_OE_ISOLATED_FORM";
        case   0xFBE1: return "ARABIC_LETTER_KIRGHIZ_OE_FINAL_FORM";
        case   0xFBE2: return "ARABIC_LETTER_KIRGHIZ_YU_ISOLATED_FORM";
        case   0xFBE3: return "ARABIC_LETTER_KIRGHIZ_YU_FINAL_FORM";
        case   0xFBE4: return "ARABIC_LETTER_E_ISOLATED_FORM";
        case   0xFBE5: return "ARABIC_LETTER_E_FINAL_FORM";
        case   0xFBE6: return "ARABIC_LETTER_E_INITIAL_FORM";
        case   0xFBE7: return "ARABIC_LETTER_E_MEDIAL_FORM";
        case   0xFBE8: return
                "ARABIC_LETTER_UIGHUR_KAZAKH_KIRGHIZ_ALEF_MAKSURA_INITIAL_FORM";
        case   0xFBE9: return
                "ARABIC_LETTER_UIGHUR_KAZAKH_KIRGHIZ_ALEF_MAKSURA_MEDIAL_FORM";
        case   0xFBEA: return
                "ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_ALEF_ISOLATED_FORM";
        case   0xFBEB: return
                "ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_ALEF_FINAL_FORM";
        case   0xFBEC: return
                "ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_AE_ISOLATED_FORM";
        case   0xFBED: return
                "ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_AE_FINAL_FORM";
        case   0xFBEE: return
                "ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_WAW_ISOLATED_FORM";
        case   0xFBEF: return
                "ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_WAW_FINAL_FORM";
        case   0xFBF0: return
                "ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_U_ISOLATED_FORM";
        case   0xFBF1: return
                "ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_U_FINAL_FORM";
        case   0xFBF2: return
                "ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_OE_ISOLATED_FORM";
        case   0xFBF3: return
                "ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_OE_FINAL_FORM";
        case   0xFBF4: return
                "ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_YU_ISOLATED_FORM";
        case   0xFBF5: return
                "ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_YU_FINAL_FORM";
        case   0xFBF6: return
                "ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_E_ISOLATED_FORM";
        case   0xFBF7: return
                "ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_E_FINAL_FORM";
        case   0xFBF8: return
                "ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_E_INITIAL_FORM";
        case   0xFBF9: return
                "ARABIC_LIGATURE_UIGHUR_KIRGHIZ_YEH_WITH_HAMZA_ABOVE_WITH_ALEF_MAKSURA_ISOLATED_FORM";
        case   0xFBFA: return
                "ARABIC_LIGATURE_UIGHUR_KIRGHIZ_YEH_WITH_HAMZA_ABOVE_WITH_ALEF_MAKSURA_FINAL_FORM";
        case   0xFBFB: return
                "ARABIC_LIGATURE_UIGHUR_KIRGHIZ_YEH_WITH_HAMZA_ABOVE_WITH_ALEF_MAKSURA_INITIAL_FORM";
        case   0xFBFC: return "ARABIC_LETTER_FARSI_YEH_ISOLATED_FORM";
        case   0xFBFD: return "ARABIC_LETTER_FARSI_YEH_FINAL_FORM";
        case   0xFBFE: return "ARABIC_LETTER_FARSI_YEH_INITIAL_FORM";
        case   0xFBFF: return "ARABIC_LETTER_FARSI_YEH_MEDIAL_FORM";
        case   0xFC00: return
                "ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_JEEM_ISOLATED_FORM";
        case   0xFC01: return
                "ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_HAH_ISOLATED_FORM";
        case   0xFC02: return
                "ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_MEEM_ISOLATED_FORM";
        case   0xFC03: return
                "ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_ALEF_MAKSURA_ISOLATED_FORM";
        case   0xFC04: return
                "ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_YEH_ISOLATED_FORM";
        case   0xFC05: return "ARABIC_LIGATURE_BEH_WITH_JEEM_ISOLATED_FORM";
        case   0xFC06: return "ARABIC_LIGATURE_BEH_WITH_HAH_ISOLATED_FORM";
        case   0xFC07: return "ARABIC_LIGATURE_BEH_WITH_KHAH_ISOLATED_FORM";
        case   0xFC08: return "ARABIC_LIGATURE_BEH_WITH_MEEM_ISOLATED_FORM";
        case   0xFC09: return
                "ARABIC_LIGATURE_BEH_WITH_ALEF_MAKSURA_ISOLATED_FORM";
        case   0xFC0A: return "ARABIC_LIGATURE_BEH_WITH_YEH_ISOLATED_FORM";
        case   0xFC0B: return "ARABIC_LIGATURE_TEH_WITH_JEEM_ISOLATED_FORM";
        case   0xFC0C: return "ARABIC_LIGATURE_TEH_WITH_HAH_ISOLATED_FORM";
        case   0xFC0D: return "ARABIC_LIGATURE_TEH_WITH_KHAH_ISOLATED_FORM";
        case   0xFC0E: return "ARABIC_LIGATURE_TEH_WITH_MEEM_ISOLATED_FORM";
        case   0xFC0F: return
                "ARABIC_LIGATURE_TEH_WITH_ALEF_MAKSURA_ISOLATED_FORM";
        case   0xFC10: return "ARABIC_LIGATURE_TEH_WITH_YEH_ISOLATED_FORM";
        case   0xFC11: return "ARABIC_LIGATURE_THEH_WITH_JEEM_ISOLATED_FORM";
        case   0xFC12: return "ARABIC_LIGATURE_THEH_WITH_MEEM_ISOLATED_FORM";
        case   0xFC13: return
                "ARABIC_LIGATURE_THEH_WITH_ALEF_MAKSURA_ISOLATED_FORM";
        case   0xFC14: return "ARABIC_LIGATURE_THEH_WITH_YEH_ISOLATED_FORM";
        case   0xFC15: return "ARABIC_LIGATURE_JEEM_WITH_HAH_ISOLATED_FORM";
        case   0xFC16: return "ARABIC_LIGATURE_JEEM_WITH_MEEM_ISOLATED_FORM";
        case   0xFC17: return "ARABIC_LIGATURE_HAH_WITH_JEEM_ISOLATED_FORM";
        case   0xFC18: return "ARABIC_LIGATURE_HAH_WITH_MEEM_ISOLATED_FORM";
        case   0xFC19: return "ARABIC_LIGATURE_KHAH_WITH_JEEM_ISOLATED_FORM";
        case   0xFC1A: return "ARABIC_LIGATURE_KHAH_WITH_HAH_ISOLATED_FORM";
        case   0xFC1B: return "ARABIC_LIGATURE_KHAH_WITH_MEEM_ISOLATED_FORM";
        case   0xFC1C: return "ARABIC_LIGATURE_SEEN_WITH_JEEM_ISOLATED_FORM";
        case   0xFC1D: return "ARABIC_LIGATURE_SEEN_WITH_HAH_ISOLATED_FORM";
        case   0xFC1E: return "ARABIC_LIGATURE_SEEN_WITH_KHAH_ISOLATED_FORM";
        case   0xFC1F: return "ARABIC_LIGATURE_SEEN_WITH_MEEM_ISOLATED_FORM";
        case   0xFC20: return "ARABIC_LIGATURE_SAD_WITH_HAH_ISOLATED_FORM";
        case   0xFC21: return "ARABIC_LIGATURE_SAD_WITH_MEEM_ISOLATED_FORM";
        case   0xFC22: return "ARABIC_LIGATURE_DAD_WITH_JEEM_ISOLATED_FORM";
        case   0xFC23: return "ARABIC_LIGATURE_DAD_WITH_HAH_ISOLATED_FORM";
        case   0xFC24: return "ARABIC_LIGATURE_DAD_WITH_KHAH_ISOLATED_FORM";
        case   0xFC25: return "ARABIC_LIGATURE_DAD_WITH_MEEM_ISOLATED_FORM";
        case   0xFC26: return "ARABIC_LIGATURE_TAH_WITH_HAH_ISOLATED_FORM";
        case   0xFC27: return "ARABIC_LIGATURE_TAH_WITH_MEEM_ISOLATED_FORM";
        case   0xFC28: return "ARABIC_LIGATURE_ZAH_WITH_MEEM_ISOLATED_FORM";
        case   0xFC29: return "ARABIC_LIGATURE_AIN_WITH_JEEM_ISOLATED_FORM";
        case   0xFC2A: return "ARABIC_LIGATURE_AIN_WITH_MEEM_ISOLATED_FORM";
        case   0xFC2B: return "ARABIC_LIGATURE_GHAIN_WITH_JEEM_ISOLATED_FORM";
        case   0xFC2C: return "ARABIC_LIGATURE_GHAIN_WITH_MEEM_ISOLATED_FORM";
        case   0xFC2D: return "ARABIC_LIGATURE_FEH_WITH_JEEM_ISOLATED_FORM";
        case   0xFC2E: return "ARABIC_LIGATURE_FEH_WITH_HAH_ISOLATED_FORM";
        case   0xFC2F: return "ARABIC_LIGATURE_FEH_WITH_KHAH_ISOLATED_FORM";
        case   0xFC30: return "ARABIC_LIGATURE_FEH_WITH_MEEM_ISOLATED_FORM";
        case   0xFC31: return
                "ARABIC_LIGATURE_FEH_WITH_ALEF_MAKSURA_ISOLATED_FORM";
        case   0xFC32: return "ARABIC_LIGATURE_FEH_WITH_YEH_ISOLATED_FORM";
        case   0xFC33: return "ARABIC_LIGATURE_QAF_WITH_HAH_ISOLATED_FORM";
        case   0xFC34: return "ARABIC_LIGATURE_QAF_WITH_MEEM_ISOLATED_FORM";
        case   0xFC35: return
                "ARABIC_LIGATURE_QAF_WITH_ALEF_MAKSURA_ISOLATED_FORM";
        case   0xFC36: return "ARABIC_LIGATURE_QAF_WITH_YEH_ISOLATED_FORM";
        case   0xFC37: return "ARABIC_LIGATURE_KAF_WITH_ALEF_ISOLATED_FORM";
        case   0xFC38: return "ARABIC_LIGATURE_KAF_WITH_JEEM_ISOLATED_FORM";
        case   0xFC39: return "ARABIC_LIGATURE_KAF_WITH_HAH_ISOLATED_FORM";
        case   0xFC3A: return "ARABIC_LIGATURE_KAF_WITH_KHAH_ISOLATED_FORM";
        case   0xFC3B: return "ARABIC_LIGATURE_KAF_WITH_LAM_ISOLATED_FORM";
        case   0xFC3C: return "ARABIC_LIGATURE_KAF_WITH_MEEM_ISOLATED_FORM";
        case   0xFC3D: return
                "ARABIC_LIGATURE_KAF_WITH_ALEF_MAKSURA_ISOLATED_FORM";
        case   0xFC3E: return "ARABIC_LIGATURE_KAF_WITH_YEH_ISOLATED_FORM";
        case   0xFC3F: return "ARABIC_LIGATURE_LAM_WITH_JEEM_ISOLATED_FORM";
        case   0xFC40: return "ARABIC_LIGATURE_LAM_WITH_HAH_ISOLATED_FORM";
        case   0xFC41: return "ARABIC_LIGATURE_LAM_WITH_KHAH_ISOLATED_FORM";
        case   0xFC42: return "ARABIC_LIGATURE_LAM_WITH_MEEM_ISOLATED_FORM";
        case   0xFC43: return
                "ARABIC_LIGATURE_LAM_WITH_ALEF_MAKSURA_ISOLATED_FORM";
        case   0xFC44: return "ARABIC_LIGATURE_LAM_WITH_YEH_ISOLATED_FORM";
        case   0xFC45: return "ARABIC_LIGATURE_MEEM_WITH_JEEM_ISOLATED_FORM";
        case   0xFC46: return "ARABIC_LIGATURE_MEEM_WITH_HAH_ISOLATED_FORM";
        case   0xFC47: return "ARABIC_LIGATURE_MEEM_WITH_KHAH_ISOLATED_FORM";
        case   0xFC48: return "ARABIC_LIGATURE_MEEM_WITH_MEEM_ISOLATED_FORM";
        case   0xFC49: return
                "ARABIC_LIGATURE_MEEM_WITH_ALEF_MAKSURA_ISOLATED_FORM";
        case   0xFC4A: return "ARABIC_LIGATURE_MEEM_WITH_YEH_ISOLATED_FORM";
        case   0xFC4B: return "ARABIC_LIGATURE_NOON_WITH_JEEM_ISOLATED_FORM";
        case   0xFC4C: return "ARABIC_LIGATURE_NOON_WITH_HAH_ISOLATED_FORM";
        case   0xFC4D: return "ARABIC_LIGATURE_NOON_WITH_KHAH_ISOLATED_FORM";
        case   0xFC4E: return "ARABIC_LIGATURE_NOON_WITH_MEEM_ISOLATED_FORM";
        case   0xFC4F: return
                "ARABIC_LIGATURE_NOON_WITH_ALEF_MAKSURA_ISOLATED_FORM";
        case   0xFC50: return "ARABIC_LIGATURE_NOON_WITH_YEH_ISOLATED_FORM";
        case   0xFC51: return "ARABIC_LIGATURE_HEH_WITH_JEEM_ISOLATED_FORM";
        case   0xFC52: return "ARABIC_LIGATURE_HEH_WITH_MEEM_ISOLATED_FORM";
        case   0xFC53: return
                "ARABIC_LIGATURE_HEH_WITH_ALEF_MAKSURA_ISOLATED_FORM";
        case   0xFC54: return "ARABIC_LIGATURE_HEH_WITH_YEH_ISOLATED_FORM";
        case   0xFC55: return "ARABIC_LIGATURE_YEH_WITH_JEEM_ISOLATED_FORM";
        case   0xFC56: return "ARABIC_LIGATURE_YEH_WITH_HAH_ISOLATED_FORM";
        case   0xFC57: return "ARABIC_LIGATURE_YEH_WITH_KHAH_ISOLATED_FORM";
        case   0xFC58: return "ARABIC_LIGATURE_YEH_WITH_MEEM_ISOLATED_FORM";
        case   0xFC59: return
                "ARABIC_LIGATURE_YEH_WITH_ALEF_MAKSURA_ISOLATED_FORM";
        case   0xFC5A: return "ARABIC_LIGATURE_YEH_WITH_YEH_ISOLATED_FORM";
        case   0xFC5B: return
                "ARABIC_LIGATURE_THAL_WITH_SUPERSCRIPT_ALEF_ISOLATED_FORM";
        case   0xFC5C: return
                "ARABIC_LIGATURE_REH_WITH_SUPERSCRIPT_ALEF_ISOLATED_FORM";
        case   0xFC5D: return
                "ARABIC_LIGATURE_ALEF_MAKSURA_WITH_SUPERSCRIPT_ALEF_ISOLATED_FORM";
        case   0xFC5E: return
                "ARABIC_LIGATURE_SHADDA_WITH_DAMMATAN_ISOLATED_FORM";
        case   0xFC5F: return
                "ARABIC_LIGATURE_SHADDA_WITH_KASRATAN_ISOLATED_FORM";
        case   0xFC60: return
                "ARABIC_LIGATURE_SHADDA_WITH_FATHA_ISOLATED_FORM";
        case   0xFC61: return
                "ARABIC_LIGATURE_SHADDA_WITH_DAMMA_ISOLATED_FORM";
        case   0xFC62: return
                "ARABIC_LIGATURE_SHADDA_WITH_KASRA_ISOLATED_FORM";
        case   0xFC63: return
                "ARABIC_LIGATURE_SHADDA_WITH_SUPERSCRIPT_ALEF_ISOLATED_FORM";
        case   0xFC64: return
                "ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_REH_FINAL_FORM";
        case   0xFC65: return
                "ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_ZAIN_FINAL_FORM";
        case   0xFC66: return
                "ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_MEEM_FINAL_FORM";
        case   0xFC67: return
                "ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_NOON_FINAL_FORM";
        case   0xFC68: return
                "ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_ALEF_MAKSURA_FINAL_FORM";
        case   0xFC69: return
                "ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_YEH_FINAL_FORM";
        case   0xFC6A: return "ARABIC_LIGATURE_BEH_WITH_REH_FINAL_FORM";
        case   0xFC6B: return "ARABIC_LIGATURE_BEH_WITH_ZAIN_FINAL_FORM";
        case   0xFC6C: return "ARABIC_LIGATURE_BEH_WITH_MEEM_FINAL_FORM";
        case   0xFC6D: return "ARABIC_LIGATURE_BEH_WITH_NOON_FINAL_FORM";
        case   0xFC6E: return
                "ARABIC_LIGATURE_BEH_WITH_ALEF_MAKSURA_FINAL_FORM";
        case   0xFC6F: return "ARABIC_LIGATURE_BEH_WITH_YEH_FINAL_FORM";
        case   0xFC70: return "ARABIC_LIGATURE_TEH_WITH_REH_FINAL_FORM";
        case   0xFC71: return "ARABIC_LIGATURE_TEH_WITH_ZAIN_FINAL_FORM";
        case   0xFC72: return "ARABIC_LIGATURE_TEH_WITH_MEEM_FINAL_FORM";
        case   0xFC73: return "ARABIC_LIGATURE_TEH_WITH_NOON_FINAL_FORM";
        case   0xFC74: return
                "ARABIC_LIGATURE_TEH_WITH_ALEF_MAKSURA_FINAL_FORM";
        case   0xFC75: return "ARABIC_LIGATURE_TEH_WITH_YEH_FINAL_FORM";
        case   0xFC76: return "ARABIC_LIGATURE_THEH_WITH_REH_FINAL_FORM";
        case   0xFC77: return "ARABIC_LIGATURE_THEH_WITH_ZAIN_FINAL_FORM";
        case   0xFC78: return "ARABIC_LIGATURE_THEH_WITH_MEEM_FINAL_FORM";
        case   0xFC79: return "ARABIC_LIGATURE_THEH_WITH_NOON_FINAL_FORM";
        case   0xFC7A: return
                "ARABIC_LIGATURE_THEH_WITH_ALEF_MAKSURA_FINAL_FORM";
        case   0xFC7B: return "ARABIC_LIGATURE_THEH_WITH_YEH_FINAL_FORM";
        case   0xFC7C: return
                "ARABIC_LIGATURE_FEH_WITH_ALEF_MAKSURA_FINAL_FORM";
        case   0xFC7D: return "ARABIC_LIGATURE_FEH_WITH_YEH_FINAL_FORM";
        case   0xFC7E: return
                "ARABIC_LIGATURE_QAF_WITH_ALEF_MAKSURA_FINAL_FORM";
        case   0xFC7F: return "ARABIC_LIGATURE_QAF_WITH_YEH_FINAL_FORM";
        case   0xFC80: return "ARABIC_LIGATURE_KAF_WITH_ALEF_FINAL_FORM";
        case   0xFC81: return "ARABIC_LIGATURE_KAF_WITH_LAM_FINAL_FORM";
        case   0xFC82: return "ARABIC_LIGATURE_KAF_WITH_MEEM_FINAL_FORM";
        case   0xFC83: return
                "ARABIC_LIGATURE_KAF_WITH_ALEF_MAKSURA_FINAL_FORM";
        case   0xFC84: return "ARABIC_LIGATURE_KAF_WITH_YEH_FINAL_FORM";
        case   0xFC85: return "ARABIC_LIGATURE_LAM_WITH_MEEM_FINAL_FORM";
        case   0xFC86: return
                "ARABIC_LIGATURE_LAM_WITH_ALEF_MAKSURA_FINAL_FORM";
        case   0xFC87: return "ARABIC_LIGATURE_LAM_WITH_YEH_FINAL_FORM";
        case   0xFC88: return "ARABIC_LIGATURE_MEEM_WITH_ALEF_FINAL_FORM";
        case   0xFC89: return "ARABIC_LIGATURE_MEEM_WITH_MEEM_FINAL_FORM";
        case   0xFC8A: return "ARABIC_LIGATURE_NOON_WITH_REH_FINAL_FORM";
        case   0xFC8B: return "ARABIC_LIGATURE_NOON_WITH_ZAIN_FINAL_FORM";
        case   0xFC8C: return "ARABIC_LIGATURE_NOON_WITH_MEEM_FINAL_FORM";
        case   0xFC8D: return "ARABIC_LIGATURE_NOON_WITH_NOON_FINAL_FORM";
        case   0xFC8E: return
                "ARABIC_LIGATURE_NOON_WITH_ALEF_MAKSURA_FINAL_FORM";
        case   0xFC8F: return "ARABIC_LIGATURE_NOON_WITH_YEH_FINAL_FORM";
        case   0xFC90: return
                "ARABIC_LIGATURE_ALEF_MAKSURA_WITH_SUPERSCRIPT_ALEF_FINAL_FORM";
        case   0xFC91: return "ARABIC_LIGATURE_YEH_WITH_REH_FINAL_FORM";
        case   0xFC92: return "ARABIC_LIGATURE_YEH_WITH_ZAIN_FINAL_FORM";
        case   0xFC93: return "ARABIC_LIGATURE_YEH_WITH_MEEM_FINAL_FORM";
        case   0xFC94: return "ARABIC_LIGATURE_YEH_WITH_NOON_FINAL_FORM";
        case   0xFC95: return
                "ARABIC_LIGATURE_YEH_WITH_ALEF_MAKSURA_FINAL_FORM";
        case   0xFC96: return "ARABIC_LIGATURE_YEH_WITH_YEH_FINAL_FORM";
        case   0xFC97: return
                "ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_JEEM_INITIAL_FORM";
        case   0xFC98: return
                "ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_HAH_INITIAL_FORM";
        case   0xFC99: return
                "ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_KHAH_INITIAL_FORM";
        case   0xFC9A: return
                "ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_MEEM_INITIAL_FORM";
        case   0xFC9B: return
                "ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_HEH_INITIAL_FORM";
        case   0xFC9C: return "ARABIC_LIGATURE_BEH_WITH_JEEM_INITIAL_FORM";
        case   0xFC9D: return "ARABIC_LIGATURE_BEH_WITH_HAH_INITIAL_FORM";
        case   0xFC9E: return "ARABIC_LIGATURE_BEH_WITH_KHAH_INITIAL_FORM";
        case   0xFC9F: return "ARABIC_LIGATURE_BEH_WITH_MEEM_INITIAL_FORM";
        case   0xFCA0: return "ARABIC_LIGATURE_BEH_WITH_HEH_INITIAL_FORM";
        case   0xFCA1: return "ARABIC_LIGATURE_TEH_WITH_JEEM_INITIAL_FORM";
        case   0xFCA2: return "ARABIC_LIGATURE_TEH_WITH_HAH_INITIAL_FORM";
        case   0xFCA3: return "ARABIC_LIGATURE_TEH_WITH_KHAH_INITIAL_FORM";
        case   0xFCA4: return "ARABIC_LIGATURE_TEH_WITH_MEEM_INITIAL_FORM";
        case   0xFCA5: return "ARABIC_LIGATURE_TEH_WITH_HEH_INITIAL_FORM";
        case   0xFCA6: return "ARABIC_LIGATURE_THEH_WITH_MEEM_INITIAL_FORM";
        case   0xFCA7: return "ARABIC_LIGATURE_JEEM_WITH_HAH_INITIAL_FORM";
        case   0xFCA8: return "ARABIC_LIGATURE_JEEM_WITH_MEEM_INITIAL_FORM";
        case   0xFCA9: return "ARABIC_LIGATURE_HAH_WITH_JEEM_INITIAL_FORM";
        case   0xFCAA: return "ARABIC_LIGATURE_HAH_WITH_MEEM_INITIAL_FORM";
        case   0xFCAB: return "ARABIC_LIGATURE_KHAH_WITH_JEEM_INITIAL_FORM";
        case   0xFCAC: return "ARABIC_LIGATURE_KHAH_WITH_MEEM_INITIAL_FORM";
        case   0xFCAD: return "ARABIC_LIGATURE_SEEN_WITH_JEEM_INITIAL_FORM";
        case   0xFCAE: return "ARABIC_LIGATURE_SEEN_WITH_HAH_INITIAL_FORM";
        case   0xFCAF: return "ARABIC_LIGATURE_SEEN_WITH_KHAH_INITIAL_FORM";
        case   0xFCB0: return "ARABIC_LIGATURE_SEEN_WITH_MEEM_INITIAL_FORM";
        case   0xFCB1: return "ARABIC_LIGATURE_SAD_WITH_HAH_INITIAL_FORM";
        case   0xFCB2: return "ARABIC_LIGATURE_SAD_WITH_KHAH_INITIAL_FORM";
        case   0xFCB3: return "ARABIC_LIGATURE_SAD_WITH_MEEM_INITIAL_FORM";
        case   0xFCB4: return "ARABIC_LIGATURE_DAD_WITH_JEEM_INITIAL_FORM";
        case   0xFCB5: return "ARABIC_LIGATURE_DAD_WITH_HAH_INITIAL_FORM";
        case   0xFCB6: return "ARABIC_LIGATURE_DAD_WITH_KHAH_INITIAL_FORM";
        case   0xFCB7: return "ARABIC_LIGATURE_DAD_WITH_MEEM_INITIAL_FORM";
        case   0xFCB8: return "ARABIC_LIGATURE_TAH_WITH_HAH_INITIAL_FORM";
        case   0xFCB9: return "ARABIC_LIGATURE_ZAH_WITH_MEEM_INITIAL_FORM";
        case   0xFCBA: return "ARABIC_LIGATURE_AIN_WITH_JEEM_INITIAL_FORM";
        case   0xFCBB: return "ARABIC_LIGATURE_AIN_WITH_MEEM_INITIAL_FORM";
        case   0xFCBC: return "ARABIC_LIGATURE_GHAIN_WITH_JEEM_INITIAL_FORM";
        case   0xFCBD: return "ARABIC_LIGATURE_GHAIN_WITH_MEEM_INITIAL_FORM";
        case   0xFCBE: return "ARABIC_LIGATURE_FEH_WITH_JEEM_INITIAL_FORM";
        case   0xFCBF: return "ARABIC_LIGATURE_FEH_WITH_HAH_INITIAL_FORM";
        case   0xFCC0: return "ARABIC_LIGATURE_FEH_WITH_KHAH_INITIAL_FORM";
        case   0xFCC1: return "ARABIC_LIGATURE_FEH_WITH_MEEM_INITIAL_FORM";
        case   0xFCC2: return "ARABIC_LIGATURE_QAF_WITH_HAH_INITIAL_FORM";
        case   0xFCC3: return "ARABIC_LIGATURE_QAF_WITH_MEEM_INITIAL_FORM";
        case   0xFCC4: return "ARABIC_LIGATURE_KAF_WITH_JEEM_INITIAL_FORM";
        case   0xFCC5: return "ARABIC_LIGATURE_KAF_WITH_HAH_INITIAL_FORM";
        case   0xFCC6: return "ARABIC_LIGATURE_KAF_WITH_KHAH_INITIAL_FORM";
        case   0xFCC7: return "ARABIC_LIGATURE_KAF_WITH_LAM_INITIAL_FORM";
        case   0xFCC8: return "ARABIC_LIGATURE_KAF_WITH_MEEM_INITIAL_FORM";
        case   0xFCC9: return "ARABIC_LIGATURE_LAM_WITH_JEEM_INITIAL_FORM";
        case   0xFCCA: return "ARABIC_LIGATURE_LAM_WITH_HAH_INITIAL_FORM";
        case   0xFCCB: return "ARABIC_LIGATURE_LAM_WITH_KHAH_INITIAL_FORM";
        case   0xFCCC: return "ARABIC_LIGATURE_LAM_WITH_MEEM_INITIAL_FORM";
        case   0xFCCD: return "ARABIC_LIGATURE_LAM_WITH_HEH_INITIAL_FORM";
        case   0xFCCE: return "ARABIC_LIGATURE_MEEM_WITH_JEEM_INITIAL_FORM";
        case   0xFCCF: return "ARABIC_LIGATURE_MEEM_WITH_HAH_INITIAL_FORM";
        case   0xFCD0: return "ARABIC_LIGATURE_MEEM_WITH_KHAH_INITIAL_FORM";
        case   0xFCD1: return "ARABIC_LIGATURE_MEEM_WITH_MEEM_INITIAL_FORM";
        case   0xFCD2: return "ARABIC_LIGATURE_NOON_WITH_JEEM_INITIAL_FORM";
        case   0xFCD3: return "ARABIC_LIGATURE_NOON_WITH_HAH_INITIAL_FORM";
        case   0xFCD4: return "ARABIC_LIGATURE_NOON_WITH_KHAH_INITIAL_FORM";
        case   0xFCD5: return "ARABIC_LIGATURE_NOON_WITH_MEEM_INITIAL_FORM";
        case   0xFCD6: return "ARABIC_LIGATURE_NOON_WITH_HEH_INITIAL_FORM";
        case   0xFCD7: return "ARABIC_LIGATURE_HEH_WITH_JEEM_INITIAL_FORM";
        case   0xFCD8: return "ARABIC_LIGATURE_HEH_WITH_MEEM_INITIAL_FORM";
        case   0xFCD9: return
                "ARABIC_LIGATURE_HEH_WITH_SUPERSCRIPT_ALEF_INITIAL_FORM";
        case   0xFCDA: return "ARABIC_LIGATURE_YEH_WITH_JEEM_INITIAL_FORM";
        case   0xFCDB: return "ARABIC_LIGATURE_YEH_WITH_HAH_INITIAL_FORM";
        case   0xFCDC: return "ARABIC_LIGATURE_YEH_WITH_KHAH_INITIAL_FORM";
        case   0xFCDD: return "ARABIC_LIGATURE_YEH_WITH_MEEM_INITIAL_FORM";
        case   0xFCDE: return "ARABIC_LIGATURE_YEH_WITH_HEH_INITIAL_FORM";
        case   0xFCDF: return
                "ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_MEEM_MEDIAL_FORM";
        case   0xFCE0: return
                "ARABIC_LIGATURE_YEH_WITH_HAMZA_ABOVE_WITH_HEH_MEDIAL_FORM";
        case   0xFCE1: return "ARABIC_LIGATURE_BEH_WITH_MEEM_MEDIAL_FORM";
        case   0xFCE2: return "ARABIC_LIGATURE_BEH_WITH_HEH_MEDIAL_FORM";
        case   0xFCE3: return "ARABIC_LIGATURE_TEH_WITH_MEEM_MEDIAL_FORM";
        case   0xFCE4: return "ARABIC_LIGATURE_TEH_WITH_HEH_MEDIAL_FORM";
        case   0xFCE5: return "ARABIC_LIGATURE_THEH_WITH_MEEM_MEDIAL_FORM";
        case   0xFCE6: return "ARABIC_LIGATURE_THEH_WITH_HEH_MEDIAL_FORM";
        case   0xFCE7: return "ARABIC_LIGATURE_SEEN_WITH_MEEM_MEDIAL_FORM";
        case   0xFCE8: return "ARABIC_LIGATURE_SEEN_WITH_HEH_MEDIAL_FORM";
        case   0xFCE9: return "ARABIC_LIGATURE_SHEEN_WITH_MEEM_MEDIAL_FORM";
        case   0xFCEA: return "ARABIC_LIGATURE_SHEEN_WITH_HEH_MEDIAL_FORM";
        case   0xFCEB: return "ARABIC_LIGATURE_KAF_WITH_LAM_MEDIAL_FORM";
        case   0xFCEC: return "ARABIC_LIGATURE_KAF_WITH_MEEM_MEDIAL_FORM";
        case   0xFCED: return "ARABIC_LIGATURE_LAM_WITH_MEEM_MEDIAL_FORM";
        case   0xFCEE: return "ARABIC_LIGATURE_NOON_WITH_MEEM_MEDIAL_FORM";
        case   0xFCEF: return "ARABIC_LIGATURE_NOON_WITH_HEH_MEDIAL_FORM";
        case   0xFCF0: return "ARABIC_LIGATURE_YEH_WITH_MEEM_MEDIAL_FORM";
        case   0xFCF1: return "ARABIC_LIGATURE_YEH_WITH_HEH_MEDIAL_FORM";
        case   0xFCF2: return "ARABIC_LIGATURE_SHADDA_WITH_FATHA_MEDIAL_FORM";
        case   0xFCF3: return "ARABIC_LIGATURE_SHADDA_WITH_DAMMA_MEDIAL_FORM";
        case   0xFCF4: return "ARABIC_LIGATURE_SHADDA_WITH_KASRA_MEDIAL_FORM";
        case   0xFCF5: return
                "ARABIC_LIGATURE_TAH_WITH_ALEF_MAKSURA_ISOLATED_FORM";
        case   0xFCF6: return "ARABIC_LIGATURE_TAH_WITH_YEH_ISOLATED_FORM";
        case   0xFCF7: return
                "ARABIC_LIGATURE_AIN_WITH_ALEF_MAKSURA_ISOLATED_FORM";
        case   0xFCF8: return "ARABIC_LIGATURE_AIN_WITH_YEH_ISOLATED_FORM";
        case   0xFCF9: return
                "ARABIC_LIGATURE_GHAIN_WITH_ALEF_MAKSURA_ISOLATED_FORM";
        case   0xFCFA: return "ARABIC_LIGATURE_GHAIN_WITH_YEH_ISOLATED_FORM";
        case   0xFCFB: return
                "ARABIC_LIGATURE_SEEN_WITH_ALEF_MAKSURA_ISOLATED_FORM";
        case   0xFCFC: return "ARABIC_LIGATURE_SEEN_WITH_YEH_ISOLATED_FORM";
        case   0xFCFD: return
                "ARABIC_LIGATURE_SHEEN_WITH_ALEF_MAKSURA_ISOLATED_FORM";
        case   0xFCFE: return "ARABIC_LIGATURE_SHEEN_WITH_YEH_ISOLATED_FORM";
        case   0xFCFF: return
                "ARABIC_LIGATURE_HAH_WITH_ALEF_MAKSURA_ISOLATED_FORM";
        case   0xFD00: return "ARABIC_LIGATURE_HAH_WITH_YEH_ISOLATED_FORM";
        case   0xFD01: return
                "ARABIC_LIGATURE_JEEM_WITH_ALEF_MAKSURA_ISOLATED_FORM";
        case   0xFD02: return "ARABIC_LIGATURE_JEEM_WITH_YEH_ISOLATED_FORM";
        case   0xFD03: return
                "ARABIC_LIGATURE_KHAH_WITH_ALEF_MAKSURA_ISOLATED_FORM";
        case   0xFD04: return "ARABIC_LIGATURE_KHAH_WITH_YEH_ISOLATED_FORM";
        case   0xFD05: return
                "ARABIC_LIGATURE_SAD_WITH_ALEF_MAKSURA_ISOLATED_FORM";
        case   0xFD06: return "ARABIC_LIGATURE_SAD_WITH_YEH_ISOLATED_FORM";
        case   0xFD07: return
                "ARABIC_LIGATURE_DAD_WITH_ALEF_MAKSURA_ISOLATED_FORM";
        case   0xFD08: return "ARABIC_LIGATURE_DAD_WITH_YEH_ISOLATED_FORM";
        case   0xFD09: return "ARABIC_LIGATURE_SHEEN_WITH_JEEM_ISOLATED_FORM";
        case   0xFD0A: return "ARABIC_LIGATURE_SHEEN_WITH_HAH_ISOLATED_FORM";
        case   0xFD0B: return "ARABIC_LIGATURE_SHEEN_WITH_KHAH_ISOLATED_FORM";
        case   0xFD0C: return "ARABIC_LIGATURE_SHEEN_WITH_MEEM_ISOLATED_FORM";
        case   0xFD0D: return "ARABIC_LIGATURE_SHEEN_WITH_REH_ISOLATED_FORM";
        case   0xFD0E: return "ARABIC_LIGATURE_SEEN_WITH_REH_ISOLATED_FORM";
        case   0xFD0F: return "ARABIC_LIGATURE_SAD_WITH_REH_ISOLATED_FORM";
        case   0xFD10: return "ARABIC_LIGATURE_DAD_WITH_REH_ISOLATED_FORM";
        case   0xFD11: return
                "ARABIC_LIGATURE_TAH_WITH_ALEF_MAKSURA_FINAL_FORM";
        case   0xFD12: return "ARABIC_LIGATURE_TAH_WITH_YEH_FINAL_FORM";
        case   0xFD13: return
                "ARABIC_LIGATURE_AIN_WITH_ALEF_MAKSURA_FINAL_FORM";
        case   0xFD14: return "ARABIC_LIGATURE_AIN_WITH_YEH_FINAL_FORM";
        case   0xFD15: return
                "ARABIC_LIGATURE_GHAIN_WITH_ALEF_MAKSURA_FINAL_FORM";
        case   0xFD16: return "ARABIC_LIGATURE_GHAIN_WITH_YEH_FINAL_FORM";
        case   0xFD17: return
                "ARABIC_LIGATURE_SEEN_WITH_ALEF_MAKSURA_FINAL_FORM";
        case   0xFD18: return "ARABIC_LIGATURE_SEEN_WITH_YEH_FINAL_FORM";
        case   0xFD19: return
                "ARABIC_LIGATURE_SHEEN_WITH_ALEF_MAKSURA_FINAL_FORM";
        case   0xFD1A: return "ARABIC_LIGATURE_SHEEN_WITH_YEH_FINAL_FORM";
        case   0xFD1B: return
                "ARABIC_LIGATURE_HAH_WITH_ALEF_MAKSURA_FINAL_FORM";
        case   0xFD1C: return "ARABIC_LIGATURE_HAH_WITH_YEH_FINAL_FORM";
        case   0xFD1D: return
                "ARABIC_LIGATURE_JEEM_WITH_ALEF_MAKSURA_FINAL_FORM";
        case   0xFD1E: return "ARABIC_LIGATURE_JEEM_WITH_YEH_FINAL_FORM";
        case   0xFD1F: return
                "ARABIC_LIGATURE_KHAH_WITH_ALEF_MAKSURA_FINAL_FORM";
        case   0xFD20: return "ARABIC_LIGATURE_KHAH_WITH_YEH_FINAL_FORM";
        case   0xFD21: return
                "ARABIC_LIGATURE_SAD_WITH_ALEF_MAKSURA_FINAL_FORM";
        case   0xFD22: return "ARABIC_LIGATURE_SAD_WITH_YEH_FINAL_FORM";
        case   0xFD23: return
                "ARABIC_LIGATURE_DAD_WITH_ALEF_MAKSURA_FINAL_FORM";
        case   0xFD24: return "ARABIC_LIGATURE_DAD_WITH_YEH_FINAL_FORM";
        case   0xFD25: return "ARABIC_LIGATURE_SHEEN_WITH_JEEM_FINAL_FORM";
        case   0xFD26: return "ARABIC_LIGATURE_SHEEN_WITH_HAH_FINAL_FORM";
        case   0xFD27: return "ARABIC_LIGATURE_SHEEN_WITH_KHAH_FINAL_FORM";
        case   0xFD28: return "ARABIC_LIGATURE_SHEEN_WITH_MEEM_FINAL_FORM";
        case   0xFD29: return "ARABIC_LIGATURE_SHEEN_WITH_REH_FINAL_FORM";
        case   0xFD2A: return "ARABIC_LIGATURE_SEEN_WITH_REH_FINAL_FORM";
        case   0xFD2B: return "ARABIC_LIGATURE_SAD_WITH_REH_FINAL_FORM";
        case   0xFD2C: return "ARABIC_LIGATURE_DAD_WITH_REH_FINAL_FORM";
        case   0xFD2D: return "ARABIC_LIGATURE_SHEEN_WITH_JEEM_INITIAL_FORM";
        case   0xFD2E: return "ARABIC_LIGATURE_SHEEN_WITH_HAH_INITIAL_FORM";
        case   0xFD2F: return "ARABIC_LIGATURE_SHEEN_WITH_KHAH_INITIAL_FORM";
        case   0xFD30: return "ARABIC_LIGATURE_SHEEN_WITH_MEEM_INITIAL_FORM";
        case   0xFD31: return "ARABIC_LIGATURE_SEEN_WITH_HEH_INITIAL_FORM";
        case   0xFD32: return "ARABIC_LIGATURE_SHEEN_WITH_HEH_INITIAL_FORM";
        case   0xFD33: return "ARABIC_LIGATURE_TAH_WITH_MEEM_INITIAL_FORM";
        case   0xFD34: return "ARABIC_LIGATURE_SEEN_WITH_JEEM_MEDIAL_FORM";
        case   0xFD35: return "ARABIC_LIGATURE_SEEN_WITH_HAH_MEDIAL_FORM";
        case   0xFD36: return "ARABIC_LIGATURE_SEEN_WITH_KHAH_MEDIAL_FORM";
        case   0xFD37: return "ARABIC_LIGATURE_SHEEN_WITH_JEEM_MEDIAL_FORM";
        case   0xFD38: return "ARABIC_LIGATURE_SHEEN_WITH_HAH_MEDIAL_FORM";
        case   0xFD39: return "ARABIC_LIGATURE_SHEEN_WITH_KHAH_MEDIAL_FORM";
        case   0xFD3A: return "ARABIC_LIGATURE_TAH_WITH_MEEM_MEDIAL_FORM";
        case   0xFD3B: return "ARABIC_LIGATURE_ZAH_WITH_MEEM_MEDIAL_FORM";
        case   0xFD3C: return "ARABIC_LIGATURE_ALEF_WITH_FATHATAN_FINAL_FORM";
        case   0xFD3D: return
                "ARABIC_LIGATURE_ALEF_WITH_FATHATAN_ISOLATED_FORM";
        case   0xFD3E: return "ORNATE_LEFT_PARENTHESIS";
        case   0xFD3F: return "ORNATE_RIGHT_PARENTHESIS";
        case   0xFD50: return
                "ARABIC_LIGATURE_TEH_WITH_JEEM_WITH_MEEM_INITIAL_FORM";
        case   0xFD51: return
                "ARABIC_LIGATURE_TEH_WITH_HAH_WITH_JEEM_FINAL_FORM";
        case   0xFD52: return
                "ARABIC_LIGATURE_TEH_WITH_HAH_WITH_JEEM_INITIAL_FORM";
        case   0xFD53: return
                "ARABIC_LIGATURE_TEH_WITH_HAH_WITH_MEEM_INITIAL_FORM";
        case   0xFD54: return
                "ARABIC_LIGATURE_TEH_WITH_KHAH_WITH_MEEM_INITIAL_FORM";
        case   0xFD55: return
                "ARABIC_LIGATURE_TEH_WITH_MEEM_WITH_JEEM_INITIAL_FORM";
        case   0xFD56: return
                "ARABIC_LIGATURE_TEH_WITH_MEEM_WITH_HAH_INITIAL_FORM";
        case   0xFD57: return
                "ARABIC_LIGATURE_TEH_WITH_MEEM_WITH_KHAH_INITIAL_FORM";
        case   0xFD58: return
                "ARABIC_LIGATURE_JEEM_WITH_MEEM_WITH_HAH_FINAL_FORM";
        case   0xFD59: return
                "ARABIC_LIGATURE_JEEM_WITH_MEEM_WITH_HAH_INITIAL_FORM";
        case   0xFD5A: return
                "ARABIC_LIGATURE_HAH_WITH_MEEM_WITH_YEH_FINAL_FORM";
        case   0xFD5B: return
                "ARABIC_LIGATURE_HAH_WITH_MEEM_WITH_ALEF_MAKSURA_FINAL_FORM";
        case   0xFD5C: return
                "ARABIC_LIGATURE_SEEN_WITH_HAH_WITH_JEEM_INITIAL_FORM";
        case   0xFD5D: return
                "ARABIC_LIGATURE_SEEN_WITH_JEEM_WITH_HAH_INITIAL_FORM";
        case   0xFD5E: return
                "ARABIC_LIGATURE_SEEN_WITH_JEEM_WITH_ALEF_MAKSURA_FINAL_FORM";
        case   0xFD5F: return
                "ARABIC_LIGATURE_SEEN_WITH_MEEM_WITH_HAH_FINAL_FORM";
        case   0xFD60: return
                "ARABIC_LIGATURE_SEEN_WITH_MEEM_WITH_HAH_INITIAL_FORM";
        case   0xFD61: return
                "ARABIC_LIGATURE_SEEN_WITH_MEEM_WITH_JEEM_INITIAL_FORM";
        case   0xFD62: return
                "ARABIC_LIGATURE_SEEN_WITH_MEEM_WITH_MEEM_FINAL_FORM";
        case   0xFD63: return
                "ARABIC_LIGATURE_SEEN_WITH_MEEM_WITH_MEEM_INITIAL_FORM";
        case   0xFD64: return
                "ARABIC_LIGATURE_SAD_WITH_HAH_WITH_HAH_FINAL_FORM";
        case   0xFD65: return
                "ARABIC_LIGATURE_SAD_WITH_HAH_WITH_HAH_INITIAL_FORM";
        case   0xFD66: return
                "ARABIC_LIGATURE_SAD_WITH_MEEM_WITH_MEEM_FINAL_FORM";
        case   0xFD67: return
                "ARABIC_LIGATURE_SHEEN_WITH_HAH_WITH_MEEM_FINAL_FORM";
        case   0xFD68: return
                "ARABIC_LIGATURE_SHEEN_WITH_HAH_WITH_MEEM_INITIAL_FORM";
        case   0xFD69: return
                "ARABIC_LIGATURE_SHEEN_WITH_JEEM_WITH_YEH_FINAL_FORM";
        case   0xFD6A: return
                "ARABIC_LIGATURE_SHEEN_WITH_MEEM_WITH_KHAH_FINAL_FORM";
        case   0xFD6B: return
                "ARABIC_LIGATURE_SHEEN_WITH_MEEM_WITH_KHAH_INITIAL_FORM";
        case   0xFD6C: return
                "ARABIC_LIGATURE_SHEEN_WITH_MEEM_WITH_MEEM_FINAL_FORM";
        case   0xFD6D: return
                "ARABIC_LIGATURE_SHEEN_WITH_MEEM_WITH_MEEM_INITIAL_FORM";
        case   0xFD6E: return
                "ARABIC_LIGATURE_DAD_WITH_HAH_WITH_ALEF_MAKSURA_FINAL_FORM";
        case   0xFD6F: return
                "ARABIC_LIGATURE_DAD_WITH_KHAH_WITH_MEEM_FINAL_FORM";
        case   0xFD70: return
                "ARABIC_LIGATURE_DAD_WITH_KHAH_WITH_MEEM_INITIAL_FORM";
        case   0xFD71: return
                "ARABIC_LIGATURE_TAH_WITH_MEEM_WITH_HAH_FINAL_FORM";
        case   0xFD72: return
                "ARABIC_LIGATURE_TAH_WITH_MEEM_WITH_HAH_INITIAL_FORM";
        case   0xFD73: return
                "ARABIC_LIGATURE_TAH_WITH_MEEM_WITH_MEEM_INITIAL_FORM";
        case   0xFD74: return
                "ARABIC_LIGATURE_TAH_WITH_MEEM_WITH_YEH_FINAL_FORM";
        case   0xFD75: return
                "ARABIC_LIGATURE_AIN_WITH_JEEM_WITH_MEEM_FINAL_FORM";
        case   0xFD76: return
                "ARABIC_LIGATURE_AIN_WITH_MEEM_WITH_MEEM_FINAL_FORM";
        case   0xFD77: return
                "ARABIC_LIGATURE_AIN_WITH_MEEM_WITH_MEEM_INITIAL_FORM";
        case   0xFD78: return
                "ARABIC_LIGATURE_AIN_WITH_MEEM_WITH_ALEF_MAKSURA_FINAL_FORM";
        case   0xFD79: return
                "ARABIC_LIGATURE_GHAIN_WITH_MEEM_WITH_MEEM_FINAL_FORM";
        case   0xFD7A: return
                "ARABIC_LIGATURE_GHAIN_WITH_MEEM_WITH_YEH_FINAL_FORM";
        case   0xFD7B: return
                "ARABIC_LIGATURE_GHAIN_WITH_MEEM_WITH_ALEF_MAKSURA_FINAL_FORM";
        case   0xFD7C: return
                "ARABIC_LIGATURE_FEH_WITH_KHAH_WITH_MEEM_FINAL_FORM";
        case   0xFD7D: return
                "ARABIC_LIGATURE_FEH_WITH_KHAH_WITH_MEEM_INITIAL_FORM";
        case   0xFD7E: return
                "ARABIC_LIGATURE_QAF_WITH_MEEM_WITH_HAH_FINAL_FORM";
        case   0xFD7F: return
                "ARABIC_LIGATURE_QAF_WITH_MEEM_WITH_MEEM_FINAL_FORM";
        case   0xFD80: return
                "ARABIC_LIGATURE_LAM_WITH_HAH_WITH_MEEM_FINAL_FORM";
        case   0xFD81: return
                "ARABIC_LIGATURE_LAM_WITH_HAH_WITH_YEH_FINAL_FORM";
        case   0xFD82: return
                "ARABIC_LIGATURE_LAM_WITH_HAH_WITH_ALEF_MAKSURA_FINAL_FORM";
        case   0xFD83: return
                "ARABIC_LIGATURE_LAM_WITH_JEEM_WITH_JEEM_INITIAL_FORM";
        case   0xFD84: return
                "ARABIC_LIGATURE_LAM_WITH_JEEM_WITH_JEEM_FINAL_FORM";
        case   0xFD85: return
                "ARABIC_LIGATURE_LAM_WITH_KHAH_WITH_MEEM_FINAL_FORM";
        case   0xFD86: return
                "ARABIC_LIGATURE_LAM_WITH_KHAH_WITH_MEEM_INITIAL_FORM";
        case   0xFD87: return
                "ARABIC_LIGATURE_LAM_WITH_MEEM_WITH_HAH_FINAL_FORM";
        case   0xFD88: return
                "ARABIC_LIGATURE_LAM_WITH_MEEM_WITH_HAH_INITIAL_FORM";
        case   0xFD89: return
                "ARABIC_LIGATURE_MEEM_WITH_HAH_WITH_JEEM_INITIAL_FORM";
        case   0xFD8A: return
                "ARABIC_LIGATURE_MEEM_WITH_HAH_WITH_MEEM_INITIAL_FORM";
        case   0xFD8B: return
                "ARABIC_LIGATURE_MEEM_WITH_HAH_WITH_YEH_FINAL_FORM";
        case   0xFD8C: return
                "ARABIC_LIGATURE_MEEM_WITH_JEEM_WITH_HAH_INITIAL_FORM";
        case   0xFD8D: return
                "ARABIC_LIGATURE_MEEM_WITH_JEEM_WITH_MEEM_INITIAL_FORM";
        case   0xFD8E: return
                "ARABIC_LIGATURE_MEEM_WITH_KHAH_WITH_JEEM_INITIAL_FORM";
        case   0xFD8F: return
                "ARABIC_LIGATURE_MEEM_WITH_KHAH_WITH_MEEM_INITIAL_FORM";
        case   0xFD92: return
                "ARABIC_LIGATURE_MEEM_WITH_JEEM_WITH_KHAH_INITIAL_FORM";
        case   0xFD93: return
                "ARABIC_LIGATURE_HEH_WITH_MEEM_WITH_JEEM_INITIAL_FORM";
        case   0xFD94: return
                "ARABIC_LIGATURE_HEH_WITH_MEEM_WITH_MEEM_INITIAL_FORM";
        case   0xFD95: return
                "ARABIC_LIGATURE_NOON_WITH_HAH_WITH_MEEM_INITIAL_FORM";
        case   0xFD96: return
                "ARABIC_LIGATURE_NOON_WITH_HAH_WITH_ALEF_MAKSURA_FINAL_FORM";
        case   0xFD97: return
                "ARABIC_LIGATURE_NOON_WITH_JEEM_WITH_MEEM_FINAL_FORM";
        case   0xFD98: return
                "ARABIC_LIGATURE_NOON_WITH_JEEM_WITH_MEEM_INITIAL_FORM";
        case   0xFD99: return
                "ARABIC_LIGATURE_NOON_WITH_JEEM_WITH_ALEF_MAKSURA_FINAL_FORM";
        case   0xFD9A: return
                "ARABIC_LIGATURE_NOON_WITH_MEEM_WITH_YEH_FINAL_FORM";
        case   0xFD9B: return
                "ARABIC_LIGATURE_NOON_WITH_MEEM_WITH_ALEF_MAKSURA_FINAL_FORM";
        case   0xFD9C: return
                "ARABIC_LIGATURE_YEH_WITH_MEEM_WITH_MEEM_FINAL_FORM";
        case   0xFD9D: return
                "ARABIC_LIGATURE_YEH_WITH_MEEM_WITH_MEEM_INITIAL_FORM";
        case   0xFD9E: return
                "ARABIC_LIGATURE_BEH_WITH_KHAH_WITH_YEH_FINAL_FORM";
        case   0xFD9F: return
                "ARABIC_LIGATURE_TEH_WITH_JEEM_WITH_YEH_FINAL_FORM";
        case   0xFDA0: return
                "ARABIC_LIGATURE_TEH_WITH_JEEM_WITH_ALEF_MAKSURA_FINAL_FORM";
        case   0xFDA1: return
                "ARABIC_LIGATURE_TEH_WITH_KHAH_WITH_YEH_FINAL_FORM";
        case   0xFDA2: return
                "ARABIC_LIGATURE_TEH_WITH_KHAH_WITH_ALEF_MAKSURA_FINAL_FORM";
        case   0xFDA3: return
                "ARABIC_LIGATURE_TEH_WITH_MEEM_WITH_YEH_FINAL_FORM";
        case   0xFDA4: return
                "ARABIC_LIGATURE_TEH_WITH_MEEM_WITH_ALEF_MAKSURA_FINAL_FORM";
        case   0xFDA5: return
                "ARABIC_LIGATURE_JEEM_WITH_MEEM_WITH_YEH_FINAL_FORM";
        case   0xFDA6: return
                "ARABIC_LIGATURE_JEEM_WITH_HAH_WITH_ALEF_MAKSURA_FINAL_FORM";
        case   0xFDA7: return
                "ARABIC_LIGATURE_JEEM_WITH_MEEM_WITH_ALEF_MAKSURA_FINAL_FORM";
        case   0xFDA8: return
                "ARABIC_LIGATURE_SEEN_WITH_KHAH_WITH_ALEF_MAKSURA_FINAL_FORM";
        case   0xFDA9: return
                "ARABIC_LIGATURE_SAD_WITH_HAH_WITH_YEH_FINAL_FORM";
        case   0xFDAA: return
                "ARABIC_LIGATURE_SHEEN_WITH_HAH_WITH_YEH_FINAL_FORM";
        case   0xFDAB: return
                "ARABIC_LIGATURE_DAD_WITH_HAH_WITH_YEH_FINAL_FORM";
        case   0xFDAC: return
                "ARABIC_LIGATURE_LAM_WITH_JEEM_WITH_YEH_FINAL_FORM";
        case   0xFDAD: return
                "ARABIC_LIGATURE_LAM_WITH_MEEM_WITH_YEH_FINAL_FORM";
        case   0xFDAE: return
                "ARABIC_LIGATURE_YEH_WITH_HAH_WITH_YEH_FINAL_FORM";
        case   0xFDAF: return
                "ARABIC_LIGATURE_YEH_WITH_JEEM_WITH_YEH_FINAL_FORM";
        case   0xFDB0: return
                "ARABIC_LIGATURE_YEH_WITH_MEEM_WITH_YEH_FINAL_FORM";
        case   0xFDB1: return
                "ARABIC_LIGATURE_MEEM_WITH_MEEM_WITH_YEH_FINAL_FORM";
        case   0xFDB2: return
                "ARABIC_LIGATURE_QAF_WITH_MEEM_WITH_YEH_FINAL_FORM";
        case   0xFDB3: return
                "ARABIC_LIGATURE_NOON_WITH_HAH_WITH_YEH_FINAL_FORM";
        case   0xFDB4: return
                "ARABIC_LIGATURE_QAF_WITH_MEEM_WITH_HAH_INITIAL_FORM";
        case   0xFDB5: return
                "ARABIC_LIGATURE_LAM_WITH_HAH_WITH_MEEM_INITIAL_FORM";
        case   0xFDB6: return
                "ARABIC_LIGATURE_AIN_WITH_MEEM_WITH_YEH_FINAL_FORM";
        case   0xFDB7: return
                "ARABIC_LIGATURE_KAF_WITH_MEEM_WITH_YEH_FINAL_FORM";
        case   0xFDB8: return
                "ARABIC_LIGATURE_NOON_WITH_JEEM_WITH_HAH_INITIAL_FORM";
        case   0xFDB9: return
                "ARABIC_LIGATURE_MEEM_WITH_KHAH_WITH_YEH_FINAL_FORM";
        case   0xFDBA: return
                "ARABIC_LIGATURE_LAM_WITH_JEEM_WITH_MEEM_INITIAL_FORM";
        case   0xFDBB: return
                "ARABIC_LIGATURE_KAF_WITH_MEEM_WITH_MEEM_FINAL_FORM";
        case   0xFDBC: return
                "ARABIC_LIGATURE_LAM_WITH_JEEM_WITH_MEEM_FINAL_FORM";
        case   0xFDBD: return
                "ARABIC_LIGATURE_NOON_WITH_JEEM_WITH_HAH_FINAL_FORM";
        case   0xFDBE: return
                "ARABIC_LIGATURE_JEEM_WITH_HAH_WITH_YEH_FINAL_FORM";
        case   0xFDBF: return
                "ARABIC_LIGATURE_HAH_WITH_JEEM_WITH_YEH_FINAL_FORM";
        case   0xFDC0: return
                "ARABIC_LIGATURE_MEEM_WITH_JEEM_WITH_YEH_FINAL_FORM";
        case   0xFDC1: return
                "ARABIC_LIGATURE_FEH_WITH_MEEM_WITH_YEH_FINAL_FORM";
        case   0xFDC2: return
                "ARABIC_LIGATURE_BEH_WITH_HAH_WITH_YEH_FINAL_FORM";
        case   0xFDC3: return
                "ARABIC_LIGATURE_KAF_WITH_MEEM_WITH_MEEM_INITIAL_FORM";
        case   0xFDC4: return
                "ARABIC_LIGATURE_AIN_WITH_JEEM_WITH_MEEM_INITIAL_FORM";
        case   0xFDC5: return
                "ARABIC_LIGATURE_SAD_WITH_MEEM_WITH_MEEM_INITIAL_FORM";
        case   0xFDC6: return
                "ARABIC_LIGATURE_SEEN_WITH_KHAH_WITH_YEH_FINAL_FORM";
        case   0xFDC7: return
                "ARABIC_LIGATURE_NOON_WITH_JEEM_WITH_YEH_FINAL_FORM";
        case   0xFDF0: return
                "ARABIC_LIGATURE_SALLA_USED_AS_KORANIC_STOP_SIGN_ISOLATED_FORM";
        case   0xFDF1: return
                "ARABIC_LIGATURE_QALA_USED_AS_KORANIC_STOP_SIGN_ISOLATED_FORM";
        case   0xFDF2: return "ARABIC_LIGATURE_ALLAH_ISOLATED_FORM";
        case   0xFDF3: return "ARABIC_LIGATURE_AKBAR_ISOLATED_FORM";
        case   0xFDF4: return "ARABIC_LIGATURE_MOHAMMAD_ISOLATED_FORM";
        case   0xFDF5: return "ARABIC_LIGATURE_SALAM_ISOLATED_FORM";
        case   0xFDF6: return "ARABIC_LIGATURE_RASOUL_ISOLATED_FORM";
        case   0xFDF7: return "ARABIC_LIGATURE_ALAYHE_ISOLATED_FORM";
        case   0xFDF8: return "ARABIC_LIGATURE_WASALLAM_ISOLATED_FORM";
        case   0xFDF9: return "ARABIC_LIGATURE_SALLA_ISOLATED_FORM";
        case   0xFDFA: return "ARABIC_LIGATURE_SALLALLAHOU_ALAYHE_WASALLAM";
        case   0xFDFB: return "ARABIC_LIGATURE_JALLAJALALOUHOU";
        case   0xFDFC: return "RIAL_SIGN";
        case   0xFDFD: return "ARABIC_LIGATURE_BISMILLAH_AR_RAHMAN_AR_RAHEEM";
        case   0xFE00: return "VARIATION_SELECTOR_1";
        case   0xFE01: return "VARIATION_SELECTOR_2";
        case   0xFE02: return "VARIATION_SELECTOR_3";
        case   0xFE03: return "VARIATION_SELECTOR_4";
        case   0xFE04: return "VARIATION_SELECTOR_5";
        case   0xFE05: return "VARIATION_SELECTOR_6";
        case   0xFE06: return "VARIATION_SELECTOR_7";
        case   0xFE07: return "VARIATION_SELECTOR_8";
        case   0xFE08: return "VARIATION_SELECTOR_9";
        case   0xFE09: return "VARIATION_SELECTOR_10";
        case   0xFE0A: return "VARIATION_SELECTOR_11";
        case   0xFE0B: return "VARIATION_SELECTOR_12";
        case   0xFE0C: return "VARIATION_SELECTOR_13";
        case   0xFE0D: return "VARIATION_SELECTOR_14";
        case   0xFE0E: return "VARIATION_SELECTOR_15";
        case   0xFE0F: return "VARIATION_SELECTOR_16";
        case   0xFE10: return "PRESENTATION_FORM_FOR_VERTICAL_COMMA";
        case   0xFE11: return
                "PRESENTATION_FORM_FOR_VERTICAL_IDEOGRAPHIC_COMMA";
        case   0xFE12: return
                "PRESENTATION_FORM_FOR_VERTICAL_IDEOGRAPHIC_FULL_STOP";
        case   0xFE13: return "PRESENTATION_FORM_FOR_VERTICAL_COLON";
        case   0xFE14: return "PRESENTATION_FORM_FOR_VERTICAL_SEMICOLON";
        case   0xFE15: return
                "PRESENTATION_FORM_FOR_VERTICAL_EXCLAMATION_MARK";
        case   0xFE16: return "PRESENTATION_FORM_FOR_VERTICAL_QUESTION_MARK";
        case   0xFE17: return
                "PRESENTATION_FORM_FOR_VERTICAL_LEFT_WHITE_LENTICULAR_BRACKET";
        case   0xFE18: return
                "PRESENTATION_FORM_FOR_VERTICAL_RIGHT_WHITE_LENTICULAR_BRAKCET";
        case   0xFE19: return
                "PRESENTATION_FORM_FOR_VERTICAL_HORIZONTAL_ELLIPSIS";
        case   0xFE20: return "COMBINING_LIGATURE_LEFT_HALF";
        case   0xFE21: return "COMBINING_LIGATURE_RIGHT_HALF";
        case   0xFE22: return "COMBINING_DOUBLE_TILDE_LEFT_HALF";
        case   0xFE23: return "COMBINING_DOUBLE_TILDE_RIGHT_HALF";
        case   0xFE24: return "COMBINING_MACRON_LEFT_HALF";
        case   0xFE25: return "COMBINING_MACRON_RIGHT_HALF";
        case   0xFE26: return "COMBINING_CONJOINING_MACRON";
        case   0xFE27: return "COMBINING_LIGATURE_LEFT_HALF_BELOW";
        case   0xFE28: return "COMBINING_LIGATURE_RIGHT_HALF_BELOW";
        case   0xFE29: return "COMBINING_TILDE_LEFT_HALF_BELOW";
        case   0xFE2A: return "COMBINING_TILDE_RIGHT_HALF_BELOW";
        case   0xFE2B: return "COMBINING_MACRON_LEFT_HALF_BELOW";
        case   0xFE2C: return "COMBINING_MACRON_RIGHT_HALF_BELOW";
        case   0xFE2D: return "COMBINING_CONJOINING_MACRON_BELOW";
        case   0xFE30: return "PRESENTATION_FORM_FOR_VERTICAL_TWO_DOT_LEADER";
        case   0xFE31: return "PRESENTATION_FORM_FOR_VERTICAL_EM_DASH";
        case   0xFE32: return "PRESENTATION_FORM_FOR_VERTICAL_EN_DASH";
        case   0xFE33: return "PRESENTATION_FORM_FOR_VERTICAL_LOW_LINE";
        case   0xFE34: return "PRESENTATION_FORM_FOR_VERTICAL_WAVY_LOW_LINE";
        case   0xFE35: return
                "PRESENTATION_FORM_FOR_VERTICAL_LEFT_PARENTHESIS";
        case   0xFE36: return
                "PRESENTATION_FORM_FOR_VERTICAL_RIGHT_PARENTHESIS";
        case   0xFE37: return
                "PRESENTATION_FORM_FOR_VERTICAL_LEFT_CURLY_BRACKET";
        case   0xFE38: return
                "PRESENTATION_FORM_FOR_VERTICAL_RIGHT_CURLY_BRACKET";
        case   0xFE39: return
                "PRESENTATION_FORM_FOR_VERTICAL_LEFT_TORTOISE_SHELL_BRACKET";
        case   0xFE3A: return
                "PRESENTATION_FORM_FOR_VERTICAL_RIGHT_TORTOISE_SHELL_BRACKET";
        case   0xFE3B: return
                "PRESENTATION_FORM_FOR_VERTICAL_LEFT_BLACK_LENTICULAR_BRACKET";
        case   0xFE3C: return
                "PRESENTATION_FORM_FOR_VERTICAL_RIGHT_BLACK_LENTICULAR_BRACKET";
        case   0xFE3D: return
                "PRESENTATION_FORM_FOR_VERTICAL_LEFT_DOUBLE_ANGLE_BRACKET";
        case   0xFE3E: return
                "PRESENTATION_FORM_FOR_VERTICAL_RIGHT_DOUBLE_ANGLE_BRACKET";
        case   0xFE3F: return
                "PRESENTATION_FORM_FOR_VERTICAL_LEFT_ANGLE_BRACKET";
        case   0xFE40: return
                "PRESENTATION_FORM_FOR_VERTICAL_RIGHT_ANGLE_BRACKET";
        case   0xFE41: return
                "PRESENTATION_FORM_FOR_VERTICAL_LEFT_CORNER_BRACKET";
        case   0xFE42: return
                "PRESENTATION_FORM_FOR_VERTICAL_RIGHT_CORNER_BRACKET";
        case   0xFE43: return
                "PRESENTATION_FORM_FOR_VERTICAL_LEFT_WHITE_CORNER_BRACKET";
        case   0xFE44: return
                "PRESENTATION_FORM_FOR_VERTICAL_RIGHT_WHITE_CORNER_BRACKET";
        case   0xFE45: return "SESAME_DOT";
        case   0xFE46: return "WHITE_SESAME_DOT";
        case   0xFE47: return
                "PRESENTATION_FORM_FOR_VERTICAL_LEFT_SQUARE_BRACKET";
        case   0xFE48: return
                "PRESENTATION_FORM_FOR_VERTICAL_RIGHT_SQUARE_BRACKET";
        case   0xFE49: return "DASHED_OVERLINE";
        case   0xFE4A: return "CENTRELINE_OVERLINE";
        case   0xFE4B: return "WAVY_OVERLINE";
        case   0xFE4C: return "DOUBLE_WAVY_OVERLINE";
        case   0xFE4D: return "DASHED_LOW_LINE";
        case   0xFE4E: return "CENTRELINE_LOW_LINE";
        case   0xFE4F: return "WAVY_LOW_LINE";
        case   0xFE50: return "SMALL_COMMA";
        case   0xFE51: return "SMALL_IDEOGRAPHIC_COMMA";
        case   0xFE52: return "SMALL_FULL_STOP";
        case   0xFE54: return "SMALL_SEMICOLON";
        case   0xFE55: return "SMALL_COLON";
        case   0xFE56: return "SMALL_QUESTION_MARK";
        case   0xFE57: return "SMALL_EXCLAMATION_MARK";
        case   0xFE58: return "SMALL_EM_DASH";
        case   0xFE59: return "SMALL_LEFT_PARENTHESIS";
        case   0xFE5A: return "SMALL_RIGHT_PARENTHESIS";
        case   0xFE5B: return "SMALL_LEFT_CURLY_BRACKET";
        case   0xFE5C: return "SMALL_RIGHT_CURLY_BRACKET";
        case   0xFE5D: return "SMALL_LEFT_TORTOISE_SHELL_BRACKET";
        case   0xFE5E: return "SMALL_RIGHT_TORTOISE_SHELL_BRACKET";
        case   0xFE5F: return "SMALL_NUMBER_SIGN";
        case   0xFE60: return "SMALL_AMPERSAND";
        case   0xFE61: return "SMALL_ASTERISK";
        case   0xFE62: return "SMALL_PLUS_SIGN";
        case   0xFE63: return "SMALL_HYPHEN_MINUS";
        case   0xFE64: return "SMALL_LESS_THAN_SIGN";
        case   0xFE65: return "SMALL_GREATER_THAN_SIGN";
        case   0xFE66: return "SMALL_EQUALS_SIGN";
        case   0xFE68: return "SMALL_REVERSE_SOLIDUS";
        case   0xFE69: return "SMALL_DOLLAR_SIGN";
        case   0xFE6A: return "SMALL_PERCENT_SIGN";
        case   0xFE6B: return "SMALL_COMMERCIAL_AT";
        case   0xFE70: return "ARABIC_FATHATAN_ISOLATED_FORM";
        case   0xFE71: return "ARABIC_TATWEEL_WITH_FATHATAN_ABOVE";
        case   0xFE72: return "ARABIC_DAMMATAN_ISOLATED_FORM";
        case   0xFE73: return "ARABIC_TAIL_FRAGMENT";
        case   0xFE74: return "ARABIC_KASRATAN_ISOLATED_FORM";
        case   0xFE76: return "ARABIC_FATHA_ISOLATED_FORM";
        case   0xFE77: return "ARABIC_FATHA_MEDIAL_FORM";
        case   0xFE78: return "ARABIC_DAMMA_ISOLATED_FORM";
        case   0xFE79: return "ARABIC_DAMMA_MEDIAL_FORM";
        case   0xFE7A: return "ARABIC_KASRA_ISOLATED_FORM";
        case   0xFE7B: return "ARABIC_KASRA_MEDIAL_FORM";
        case   0xFE7C: return "ARABIC_SHADDA_ISOLATED_FORM";
        case   0xFE7D: return "ARABIC_SHADDA_MEDIAL_FORM";
        case   0xFE7E: return "ARABIC_SUKUN_ISOLATED_FORM";
        case   0xFE7F: return "ARABIC_SUKUN_MEDIAL_FORM";
        case   0xFE80: return "ARABIC_LETTER_HAMZA_ISOLATED_FORM";
        case   0xFE81: return
                "ARABIC_LETTER_ALEF_WITH_MADDA_ABOVE_ISOLATED_FORM";
        case   0xFE82: return
                "ARABIC_LETTER_ALEF_WITH_MADDA_ABOVE_FINAL_FORM";
        case   0xFE83: return
                "ARABIC_LETTER_ALEF_WITH_HAMZA_ABOVE_ISOLATED_FORM";
        case   0xFE84: return
                "ARABIC_LETTER_ALEF_WITH_HAMZA_ABOVE_FINAL_FORM";
        case   0xFE85: return
                "ARABIC_LETTER_WAW_WITH_HAMZA_ABOVE_ISOLATED_FORM";
        case   0xFE86: return "ARABIC_LETTER_WAW_WITH_HAMZA_ABOVE_FINAL_FORM";
        case   0xFE87: return
                "ARABIC_LETTER_ALEF_WITH_HAMZA_BELOW_ISOLATED_FORM";
        case   0xFE88: return
                "ARABIC_LETTER_ALEF_WITH_HAMZA_BELOW_FINAL_FORM";
        case   0xFE89: return
                "ARABIC_LETTER_YEH_WITH_HAMZA_ABOVE_ISOLATED_FORM";
        case   0xFE8A: return "ARABIC_LETTER_YEH_WITH_HAMZA_ABOVE_FINAL_FORM";
        case   0xFE8B: return
                "ARABIC_LETTER_YEH_WITH_HAMZA_ABOVE_INITIAL_FORM";
        case   0xFE8C: return
                "ARABIC_LETTER_YEH_WITH_HAMZA_ABOVE_MEDIAL_FORM";
        case   0xFE8D: return "ARABIC_LETTER_ALEF_ISOLATED_FORM";
        case   0xFE8E: return "ARABIC_LETTER_ALEF_FINAL_FORM";
        case   0xFE8F: return "ARABIC_LETTER_BEH_ISOLATED_FORM";
        case   0xFE90: return "ARABIC_LETTER_BEH_FINAL_FORM";
        case   0xFE91: return "ARABIC_LETTER_BEH_INITIAL_FORM";
        case   0xFE92: return "ARABIC_LETTER_BEH_MEDIAL_FORM";
        case   0xFE93: return "ARABIC_LETTER_TEH_MARBUTA_ISOLATED_FORM";
        case   0xFE94: return "ARABIC_LETTER_TEH_MARBUTA_FINAL_FORM";
        case   0xFE95: return "ARABIC_LETTER_TEH_ISOLATED_FORM";
        case   0xFE96: return "ARABIC_LETTER_TEH_FINAL_FORM";
        case   0xFE97: return "ARABIC_LETTER_TEH_INITIAL_FORM";
        case   0xFE98: return "ARABIC_LETTER_TEH_MEDIAL_FORM";
        case   0xFE99: return "ARABIC_LETTER_THEH_ISOLATED_FORM";
        case   0xFE9A: return "ARABIC_LETTER_THEH_FINAL_FORM";
        case   0xFE9B: return "ARABIC_LETTER_THEH_INITIAL_FORM";
        case   0xFE9C: return "ARABIC_LETTER_THEH_MEDIAL_FORM";
        case   0xFE9D: return "ARABIC_LETTER_JEEM_ISOLATED_FORM";
        case   0xFE9E: return "ARABIC_LETTER_JEEM_FINAL_FORM";
        case   0xFE9F: return "ARABIC_LETTER_JEEM_INITIAL_FORM";
        case   0xFEA0: return "ARABIC_LETTER_JEEM_MEDIAL_FORM";
        case   0xFEA1: return "ARABIC_LETTER_HAH_ISOLATED_FORM";
        case   0xFEA2: return "ARABIC_LETTER_HAH_FINAL_FORM";
        case   0xFEA3: return "ARABIC_LETTER_HAH_INITIAL_FORM";
        case   0xFEA4: return "ARABIC_LETTER_HAH_MEDIAL_FORM";
        case   0xFEA5: return "ARABIC_LETTER_KHAH_ISOLATED_FORM";
        case   0xFEA6: return "ARABIC_LETTER_KHAH_FINAL_FORM";
        case   0xFEA7: return "ARABIC_LETTER_KHAH_INITIAL_FORM";
        case   0xFEA8: return "ARABIC_LETTER_KHAH_MEDIAL_FORM";
        case   0xFEA9: return "ARABIC_LETTER_DAL_ISOLATED_FORM";
        case   0xFEAA: return "ARABIC_LETTER_DAL_FINAL_FORM";
        case   0xFEAB: return "ARABIC_LETTER_THAL_ISOLATED_FORM";
        case   0xFEAC: return "ARABIC_LETTER_THAL_FINAL_FORM";
        case   0xFEAD: return "ARABIC_LETTER_REH_ISOLATED_FORM";
        case   0xFEAE: return "ARABIC_LETTER_REH_FINAL_FORM";
        case   0xFEAF: return "ARABIC_LETTER_ZAIN_ISOLATED_FORM";
        case   0xFEB0: return "ARABIC_LETTER_ZAIN_FINAL_FORM";
        case   0xFEB1: return "ARABIC_LETTER_SEEN_ISOLATED_FORM";
        case   0xFEB2: return "ARABIC_LETTER_SEEN_FINAL_FORM";
        case   0xFEB3: return "ARABIC_LETTER_SEEN_INITIAL_FORM";
        case   0xFEB4: return "ARABIC_LETTER_SEEN_MEDIAL_FORM";
        case   0xFEB5: return "ARABIC_LETTER_SHEEN_ISOLATED_FORM";
        case   0xFEB6: return "ARABIC_LETTER_SHEEN_FINAL_FORM";
        case   0xFEB7: return "ARABIC_LETTER_SHEEN_INITIAL_FORM";
        case   0xFEB8: return "ARABIC_LETTER_SHEEN_MEDIAL_FORM";
        case   0xFEB9: return "ARABIC_LETTER_SAD_ISOLATED_FORM";
        case   0xFEBA: return "ARABIC_LETTER_SAD_FINAL_FORM";
        case   0xFEBB: return "ARABIC_LETTER_SAD_INITIAL_FORM";
        case   0xFEBC: return "ARABIC_LETTER_SAD_MEDIAL_FORM";
        case   0xFEBD: return "ARABIC_LETTER_DAD_ISOLATED_FORM";
        case   0xFEBE: return "ARABIC_LETTER_DAD_FINAL_FORM";
        case   0xFEBF: return "ARABIC_LETTER_DAD_INITIAL_FORM";
        case   0xFEC0: return "ARABIC_LETTER_DAD_MEDIAL_FORM";
        case   0xFEC1: return "ARABIC_LETTER_TAH_ISOLATED_FORM";
        case   0xFEC2: return "ARABIC_LETTER_TAH_FINAL_FORM";
        case   0xFEC3: return "ARABIC_LETTER_TAH_INITIAL_FORM";
        case   0xFEC4: return "ARABIC_LETTER_TAH_MEDIAL_FORM";
        case   0xFEC5: return "ARABIC_LETTER_ZAH_ISOLATED_FORM";
        case   0xFEC6: return "ARABIC_LETTER_ZAH_FINAL_FORM";
        case   0xFEC7: return "ARABIC_LETTER_ZAH_INITIAL_FORM";
        case   0xFEC8: return "ARABIC_LETTER_ZAH_MEDIAL_FORM";
        case   0xFEC9: return "ARABIC_LETTER_AIN_ISOLATED_FORM";
        case   0xFECA: return "ARABIC_LETTER_AIN_FINAL_FORM";
        case   0xFECB: return "ARABIC_LETTER_AIN_INITIAL_FORM";
        case   0xFECC: return "ARABIC_LETTER_AIN_MEDIAL_FORM";
        case   0xFECD: return "ARABIC_LETTER_GHAIN_ISOLATED_FORM";
        case   0xFECE: return "ARABIC_LETTER_GHAIN_FINAL_FORM";
        case   0xFECF: return "ARABIC_LETTER_GHAIN_INITIAL_FORM";
        case   0xFED0: return "ARABIC_LETTER_GHAIN_MEDIAL_FORM";
        case   0xFED1: return "ARABIC_LETTER_FEH_ISOLATED_FORM";
        case   0xFED2: return "ARABIC_LETTER_FEH_FINAL_FORM";
        case   0xFED3: return "ARABIC_LETTER_FEH_INITIAL_FORM";
        case   0xFED4: return "ARABIC_LETTER_FEH_MEDIAL_FORM";
        case   0xFED5: return "ARABIC_LETTER_QAF_ISOLATED_FORM";
        case   0xFED6: return "ARABIC_LETTER_QAF_FINAL_FORM";
        case   0xFED7: return "ARABIC_LETTER_QAF_INITIAL_FORM";
        case   0xFED8: return "ARABIC_LETTER_QAF_MEDIAL_FORM";
        case   0xFED9: return "ARABIC_LETTER_KAF_ISOLATED_FORM";
        case   0xFEDA: return "ARABIC_LETTER_KAF_FINAL_FORM";
        case   0xFEDB: return "ARABIC_LETTER_KAF_INITIAL_FORM";
        case   0xFEDC: return "ARABIC_LETTER_KAF_MEDIAL_FORM";
        case   0xFEDD: return "ARABIC_LETTER_LAM_ISOLATED_FORM";
        case   0xFEDE: return "ARABIC_LETTER_LAM_FINAL_FORM";
        case   0xFEDF: return "ARABIC_LETTER_LAM_INITIAL_FORM";
        case   0xFEE0: return "ARABIC_LETTER_LAM_MEDIAL_FORM";
        case   0xFEE1: return "ARABIC_LETTER_MEEM_ISOLATED_FORM";
        case   0xFEE2: return "ARABIC_LETTER_MEEM_FINAL_FORM";
        case   0xFEE3: return "ARABIC_LETTER_MEEM_INITIAL_FORM";
        case   0xFEE4: return "ARABIC_LETTER_MEEM_MEDIAL_FORM";
        case   0xFEE5: return "ARABIC_LETTER_NOON_ISOLATED_FORM";
        case   0xFEE6: return "ARABIC_LETTER_NOON_FINAL_FORM";
        case   0xFEE7: return "ARABIC_LETTER_NOON_INITIAL_FORM";
        case   0xFEE8: return "ARABIC_LETTER_NOON_MEDIAL_FORM";
        case   0xFEE9: return "ARABIC_LETTER_HEH_ISOLATED_FORM";
        case   0xFEEA: return "ARABIC_LETTER_HEH_FINAL_FORM";
        case   0xFEEB: return "ARABIC_LETTER_HEH_INITIAL_FORM";
        case   0xFEEC: return "ARABIC_LETTER_HEH_MEDIAL_FORM";
        case   0xFEED: return "ARABIC_LETTER_WAW_ISOLATED_FORM";
        case   0xFEEE: return "ARABIC_LETTER_WAW_FINAL_FORM";
        case   0xFEEF: return "ARABIC_LETTER_ALEF_MAKSURA_ISOLATED_FORM";
        case   0xFEF0: return "ARABIC_LETTER_ALEF_MAKSURA_FINAL_FORM";
        case   0xFEF1: return "ARABIC_LETTER_YEH_ISOLATED_FORM";
        case   0xFEF2: return "ARABIC_LETTER_YEH_FINAL_FORM";
        case   0xFEF3: return "ARABIC_LETTER_YEH_INITIAL_FORM";
        case   0xFEF4: return "ARABIC_LETTER_YEH_MEDIAL_FORM";
        case   0xFEF5: return
                "ARABIC_LIGATURE_LAM_WITH_ALEF_WITH_MADDA_ABOVE_ISOLATED_FORM";
        case   0xFEF6: return
                "ARABIC_LIGATURE_LAM_WITH_ALEF_WITH_MADDA_ABOVE_FINAL_FORM";
        case   0xFEF7: return
                "ARABIC_LIGATURE_LAM_WITH_ALEF_WITH_HAMZA_ABOVE_ISOLATED_FORM";
        case   0xFEF8: return
                "ARABIC_LIGATURE_LAM_WITH_ALEF_WITH_HAMZA_ABOVE_FINAL_FORM";
        case   0xFEF9: return
                "ARABIC_LIGATURE_LAM_WITH_ALEF_WITH_HAMZA_BELOW_ISOLATED_FORM";
        case   0xFEFA: return
                "ARABIC_LIGATURE_LAM_WITH_ALEF_WITH_HAMZA_BELOW_FINAL_FORM";
        case   0xFEFB: return "ARABIC_LIGATURE_LAM_WITH_ALEF_ISOLATED_FORM";
        case   0xFEFC: return "ARABIC_LIGATURE_LAM_WITH_ALEF_FINAL_FORM";
        case   0xFEFF: return "ZERO_WIDTH_NO_BREAK_SPACE";
        case   0xFF01: return "FULLWIDTH_EXCLAMATION_MARK";
        case   0xFF02: return "FULLWIDTH_QUOTATION_MARK";
        case   0xFF03: return "FULLWIDTH_NUMBER_SIGN";
        case   0xFF04: return "FULLWIDTH_DOLLAR_SIGN";
        case   0xFF05: return "FULLWIDTH_PERCENT_SIGN";
        case   0xFF06: return "FULLWIDTH_AMPERSAND";
        case   0xFF07: return "FULLWIDTH_APOSTROPHE";
        case   0xFF08: return "FULLWIDTH_LEFT_PARENTHESIS";
        case   0xFF09: return "FULLWIDTH_RIGHT_PARENTHESIS";
        case   0xFF0A: return "FULLWIDTH_ASTERISK";
        case   0xFF0B: return "FULLWIDTH_PLUS_SIGN";
        case   0xFF0C: return "FULLWIDTH_COMMA";
        case   0xFF0D: return "FULLWIDTH_HYPHEN_MINUS";
        case   0xFF0E: return "FULLWIDTH_FULL_STOP";
        case   0xFF0F: return "FULLWIDTH_SOLIDUS";
        case   0xFF10: return "FULLWIDTH_DIGIT_ZERO";
        case   0xFF11: return "FULLWIDTH_DIGIT_ONE";
        case   0xFF12: return "FULLWIDTH_DIGIT_TWO";
        case   0xFF13: return "FULLWIDTH_DIGIT_THREE";
        case   0xFF14: return "FULLWIDTH_DIGIT_FOUR";
        case   0xFF15: return "FULLWIDTH_DIGIT_FIVE";
        case   0xFF16: return "FULLWIDTH_DIGIT_SIX";
        case   0xFF17: return "FULLWIDTH_DIGIT_SEVEN";
        case   0xFF18: return "FULLWIDTH_DIGIT_EIGHT";
        case   0xFF19: return "FULLWIDTH_DIGIT_NINE";
        case   0xFF1A: return "FULLWIDTH_COLON";
        case   0xFF1B: return "FULLWIDTH_SEMICOLON";
        case   0xFF1C: return "FULLWIDTH_LESS_THAN_SIGN";
        case   0xFF1D: return "FULLWIDTH_EQUALS_SIGN";
        case   0xFF1E: return "FULLWIDTH_GREATER_THAN_SIGN";
        case   0xFF1F: return "FULLWIDTH_QUESTION_MARK";
        case   0xFF20: return "FULLWIDTH_COMMERCIAL_AT";
        case   0xFF21: return "FULLWIDTH_LATIN_CAPITAL_LETTER_A";
        case   0xFF22: return "FULLWIDTH_LATIN_CAPITAL_LETTER_B";
        case   0xFF23: return "FULLWIDTH_LATIN_CAPITAL_LETTER_C";
        case   0xFF24: return "FULLWIDTH_LATIN_CAPITAL_LETTER_D";
        case   0xFF25: return "FULLWIDTH_LATIN_CAPITAL_LETTER_E";
        case   0xFF26: return "FULLWIDTH_LATIN_CAPITAL_LETTER_F";
        case   0xFF27: return "FULLWIDTH_LATIN_CAPITAL_LETTER_G";
        case   0xFF28: return "FULLWIDTH_LATIN_CAPITAL_LETTER_H";
        case   0xFF29: return "FULLWIDTH_LATIN_CAPITAL_LETTER_I";
        case   0xFF2A: return "FULLWIDTH_LATIN_CAPITAL_LETTER_J";
        case   0xFF2B: return "FULLWIDTH_LATIN_CAPITAL_LETTER_K";
        case   0xFF2C: return "FULLWIDTH_LATIN_CAPITAL_LETTER_L";
        case   0xFF2D: return "FULLWIDTH_LATIN_CAPITAL_LETTER_M";
        case   0xFF2E: return "FULLWIDTH_LATIN_CAPITAL_LETTER_N";
        case   0xFF2F: return "FULLWIDTH_LATIN_CAPITAL_LETTER_O";
        case   0xFF30: return "FULLWIDTH_LATIN_CAPITAL_LETTER_P";
        case   0xFF31: return "FULLWIDTH_LATIN_CAPITAL_LETTER_Q";
        case   0xFF32: return "FULLWIDTH_LATIN_CAPITAL_LETTER_R";
        case   0xFF33: return "FULLWIDTH_LATIN_CAPITAL_LETTER_S";
        case   0xFF34: return "FULLWIDTH_LATIN_CAPITAL_LETTER_T";
        case   0xFF35: return "FULLWIDTH_LATIN_CAPITAL_LETTER_U";
        case   0xFF36: return "FULLWIDTH_LATIN_CAPITAL_LETTER_V";
        case   0xFF37: return "FULLWIDTH_LATIN_CAPITAL_LETTER_W";
        case   0xFF38: return "FULLWIDTH_LATIN_CAPITAL_LETTER_X";
        case   0xFF39: return "FULLWIDTH_LATIN_CAPITAL_LETTER_Y";
        case   0xFF3A: return "FULLWIDTH_LATIN_CAPITAL_LETTER_Z";
        case   0xFF3B: return "FULLWIDTH_LEFT_SQUARE_BRACKET";
        case   0xFF3C: return "FULLWIDTH_REVERSE_SOLIDUS";
        case   0xFF3D: return "FULLWIDTH_RIGHT_SQUARE_BRACKET";
        case   0xFF3E: return "FULLWIDTH_CIRCUMFLEX_ACCENT";
        case   0xFF3F: return "FULLWIDTH_LOW_LINE";
        case   0xFF40: return "FULLWIDTH_GRAVE_ACCENT";
        case   0xFF41: return "FULLWIDTH_LATIN_SMALL_LETTER_A";
        case   0xFF42: return "FULLWIDTH_LATIN_SMALL_LETTER_B";
        case   0xFF43: return "FULLWIDTH_LATIN_SMALL_LETTER_C";
        case   0xFF44: return "FULLWIDTH_LATIN_SMALL_LETTER_D";
        case   0xFF45: return "FULLWIDTH_LATIN_SMALL_LETTER_E";
        case   0xFF46: return "FULLWIDTH_LATIN_SMALL_LETTER_F";
        case   0xFF47: return "FULLWIDTH_LATIN_SMALL_LETTER_G";
        case   0xFF48: return "FULLWIDTH_LATIN_SMALL_LETTER_H";
        case   0xFF49: return "FULLWIDTH_LATIN_SMALL_LETTER_I";
        case   0xFF4A: return "FULLWIDTH_LATIN_SMALL_LETTER_J";
        case   0xFF4B: return "FULLWIDTH_LATIN_SMALL_LETTER_K";
        case   0xFF4C: return "FULLWIDTH_LATIN_SMALL_LETTER_L";
        case   0xFF4D: return "FULLWIDTH_LATIN_SMALL_LETTER_M";
        case   0xFF4E: return "FULLWIDTH_LATIN_SMALL_LETTER_N";
        case   0xFF4F: return "FULLWIDTH_LATIN_SMALL_LETTER_O";
        case   0xFF50: return "FULLWIDTH_LATIN_SMALL_LETTER_P";
        case   0xFF51: return "FULLWIDTH_LATIN_SMALL_LETTER_Q";
        case   0xFF52: return "FULLWIDTH_LATIN_SMALL_LETTER_R";
        case   0xFF53: return "FULLWIDTH_LATIN_SMALL_LETTER_S";
        case   0xFF54: return "FULLWIDTH_LATIN_SMALL_LETTER_T";
        case   0xFF55: return "FULLWIDTH_LATIN_SMALL_LETTER_U";
        case   0xFF56: return "FULLWIDTH_LATIN_SMALL_LETTER_V";
        case   0xFF57: return "FULLWIDTH_LATIN_SMALL_LETTER_W";
        case   0xFF58: return "FULLWIDTH_LATIN_SMALL_LETTER_X";
        case   0xFF59: return "FULLWIDTH_LATIN_SMALL_LETTER_Y";
        case   0xFF5A: return "FULLWIDTH_LATIN_SMALL_LETTER_Z";
        case   0xFF5B: return "FULLWIDTH_LEFT_CURLY_BRACKET";
        case   0xFF5C: return "FULLWIDTH_VERTICAL_LINE";
        case   0xFF5D: return "FULLWIDTH_RIGHT_CURLY_BRACKET";
        case   0xFF5E: return "FULLWIDTH_TILDE";
        case   0xFF5F: return "FULLWIDTH_LEFT_WHITE_PARENTHESIS";
        case   0xFF60: return "FULLWIDTH_RIGHT_WHITE_PARENTHESIS";
        case   0xFF61: return "HALFWIDTH_IDEOGRAPHIC_FULL_STOP";
        case   0xFF62: return "HALFWIDTH_LEFT_CORNER_BRACKET";
        case   0xFF63: return "HALFWIDTH_RIGHT_CORNER_BRACKET";
        case   0xFF64: return "HALFWIDTH_IDEOGRAPHIC_COMMA";
        case   0xFF65: return "HALFWIDTH_KATAKANA_MIDDLE_DOT";
        case   0xFF66: return "HALFWIDTH_KATAKANA_LETTER_WO";
        case   0xFF67: return "HALFWIDTH_KATAKANA_LETTER_SMALL_A";
        case   0xFF68: return "HALFWIDTH_KATAKANA_LETTER_SMALL_I";
        case   0xFF69: return "HALFWIDTH_KATAKANA_LETTER_SMALL_U";
        case   0xFF6A: return "HALFWIDTH_KATAKANA_LETTER_SMALL_E";
        case   0xFF6B: return "HALFWIDTH_KATAKANA_LETTER_SMALL_O";
        case   0xFF6C: return "HALFWIDTH_KATAKANA_LETTER_SMALL_YA";
        case   0xFF6D: return "HALFWIDTH_KATAKANA_LETTER_SMALL_YU";
        case   0xFF6E: return "HALFWIDTH_KATAKANA_LETTER_SMALL_YO";
        case   0xFF6F: return "HALFWIDTH_KATAKANA_LETTER_SMALL_TU";
        case   0xFF70: return
                "HALFWIDTH_KATAKANA_HIRAGANA_PROLONGED_SOUND_MARK";
        case   0xFF71: return "HALFWIDTH_KATAKANA_LETTER_A";
        case   0xFF72: return "HALFWIDTH_KATAKANA_LETTER_I";
        case   0xFF73: return "HALFWIDTH_KATAKANA_LETTER_U";
        case   0xFF74: return "HALFWIDTH_KATAKANA_LETTER_E";
        case   0xFF75: return "HALFWIDTH_KATAKANA_LETTER_O";
        case   0xFF76: return "HALFWIDTH_KATAKANA_LETTER_KA";
        case   0xFF77: return "HALFWIDTH_KATAKANA_LETTER_KI";
        case   0xFF78: return "HALFWIDTH_KATAKANA_LETTER_KU";
        case   0xFF79: return "HALFWIDTH_KATAKANA_LETTER_KE";
        case   0xFF7A: return "HALFWIDTH_KATAKANA_LETTER_KO";
        case   0xFF7B: return "HALFWIDTH_KATAKANA_LETTER_SA";
        case   0xFF7C: return "HALFWIDTH_KATAKANA_LETTER_SI";
        case   0xFF7D: return "HALFWIDTH_KATAKANA_LETTER_SU";
        case   0xFF7E: return "HALFWIDTH_KATAKANA_LETTER_SE";
        case   0xFF7F: return "HALFWIDTH_KATAKANA_LETTER_SO";
        case   0xFF80: return "HALFWIDTH_KATAKANA_LETTER_TA";
        case   0xFF81: return "HALFWIDTH_KATAKANA_LETTER_TI";
        case   0xFF82: return "HALFWIDTH_KATAKANA_LETTER_TU";
        case   0xFF83: return "HALFWIDTH_KATAKANA_LETTER_TE";
        case   0xFF84: return "HALFWIDTH_KATAKANA_LETTER_TO";
        case   0xFF85: return "HALFWIDTH_KATAKANA_LETTER_NA";
        case   0xFF86: return "HALFWIDTH_KATAKANA_LETTER_NI";
        case   0xFF87: return "HALFWIDTH_KATAKANA_LETTER_NU";
        case   0xFF88: return "HALFWIDTH_KATAKANA_LETTER_NE";
        case   0xFF89: return "HALFWIDTH_KATAKANA_LETTER_NO";
        case   0xFF8A: return "HALFWIDTH_KATAKANA_LETTER_HA";
        case   0xFF8B: return "HALFWIDTH_KATAKANA_LETTER_HI";
        case   0xFF8C: return "HALFWIDTH_KATAKANA_LETTER_HU";
        case   0xFF8D: return "HALFWIDTH_KATAKANA_LETTER_HE";
        case   0xFF8E: return "HALFWIDTH_KATAKANA_LETTER_HO";
        case   0xFF8F: return "HALFWIDTH_KATAKANA_LETTER_MA";
        case   0xFF90: return "HALFWIDTH_KATAKANA_LETTER_MI";
        case   0xFF91: return "HALFWIDTH_KATAKANA_LETTER_MU";
        case   0xFF92: return "HALFWIDTH_KATAKANA_LETTER_ME";
        case   0xFF93: return "HALFWIDTH_KATAKANA_LETTER_MO";
        case   0xFF94: return "HALFWIDTH_KATAKANA_LETTER_YA";
        case   0xFF95: return "HALFWIDTH_KATAKANA_LETTER_YU";
        case   0xFF96: return "HALFWIDTH_KATAKANA_LETTER_YO";
        case   0xFF97: return "HALFWIDTH_KATAKANA_LETTER_RA";
        case   0xFF98: return "HALFWIDTH_KATAKANA_LETTER_RI";
        case   0xFF99: return "HALFWIDTH_KATAKANA_LETTER_RU";
        case   0xFF9A: return "HALFWIDTH_KATAKANA_LETTER_RE";
        case   0xFF9B: return "HALFWIDTH_KATAKANA_LETTER_RO";
        case   0xFF9C: return "HALFWIDTH_KATAKANA_LETTER_WA";
        case   0xFF9D: return "HALFWIDTH_KATAKANA_LETTER_N";
        case   0xFF9E: return "HALFWIDTH_KATAKANA_VOICED_SOUND_MARK";
        case   0xFF9F: return "HALFWIDTH_KATAKANA_SEMI_VOICED_SOUND_MARK";
        case   0xFFA0: return "HALFWIDTH_HANGUL_FILLER";
        case   0xFFA1: return "HALFWIDTH_HANGUL_LETTER_KIYEOK";
        case   0xFFA2: return "HALFWIDTH_HANGUL_LETTER_SSANGKIYEOK";
        case   0xFFA3: return "HALFWIDTH_HANGUL_LETTER_KIYEOK_SIOS";
        case   0xFFA4: return "HALFWIDTH_HANGUL_LETTER_NIEUN";
        case   0xFFA5: return "HALFWIDTH_HANGUL_LETTER_NIEUN_CIEUC";
        case   0xFFA6: return "HALFWIDTH_HANGUL_LETTER_NIEUN_HIEUH";
        case   0xFFA7: return "HALFWIDTH_HANGUL_LETTER_TIKEUT";
        case   0xFFA8: return "HALFWIDTH_HANGUL_LETTER_SSANGTIKEUT";
        case   0xFFA9: return "HALFWIDTH_HANGUL_LETTER_RIEUL";
        case   0xFFAA: return "HALFWIDTH_HANGUL_LETTER_RIEUL_KIYEOK";
        case   0xFFAB: return "HALFWIDTH_HANGUL_LETTER_RIEUL_MIEUM";
        case   0xFFAC: return "HALFWIDTH_HANGUL_LETTER_RIEUL_PIEUP";
        case   0xFFAD: return "HALFWIDTH_HANGUL_LETTER_RIEUL_SIOS";
        case   0xFFAE: return "HALFWIDTH_HANGUL_LETTER_RIEUL_THIEUTH";
        case   0xFFAF: return "HALFWIDTH_HANGUL_LETTER_RIEUL_PHIEUPH";
        case   0xFFB0: return "HALFWIDTH_HANGUL_LETTER_RIEUL_HIEUH";
        case   0xFFB1: return "HALFWIDTH_HANGUL_LETTER_MIEUM";
        case   0xFFB2: return "HALFWIDTH_HANGUL_LETTER_PIEUP";
        case   0xFFB3: return "HALFWIDTH_HANGUL_LETTER_SSANGPIEUP";
        case   0xFFB4: return "HALFWIDTH_HANGUL_LETTER_PIEUP_SIOS";
        case   0xFFB5: return "HALFWIDTH_HANGUL_LETTER_SIOS";
        case   0xFFB6: return "HALFWIDTH_HANGUL_LETTER_SSANGSIOS";
        case   0xFFB7: return "HALFWIDTH_HANGUL_LETTER_IEUNG";
        case   0xFFB8: return "HALFWIDTH_HANGUL_LETTER_CIEUC";
        case   0xFFB9: return "HALFWIDTH_HANGUL_LETTER_SSANGCIEUC";
        case   0xFFBA: return "HALFWIDTH_HANGUL_LETTER_CHIEUCH";
        case   0xFFBB: return "HALFWIDTH_HANGUL_LETTER_KHIEUKH";
        case   0xFFBC: return "HALFWIDTH_HANGUL_LETTER_THIEUTH";
        case   0xFFBD: return "HALFWIDTH_HANGUL_LETTER_PHIEUPH";
        case   0xFFBE: return "HALFWIDTH_HANGUL_LETTER_HIEUH";
        case   0xFFC2: return "HALFWIDTH_HANGUL_LETTER_A";
        case   0xFFC3: return "HALFWIDTH_HANGUL_LETTER_AE";
        case   0xFFC4: return "HALFWIDTH_HANGUL_LETTER_YA";
        case   0xFFC5: return "HALFWIDTH_HANGUL_LETTER_YAE";
        case   0xFFC6: return "HALFWIDTH_HANGUL_LETTER_EO";
        case   0xFFC7: return "HALFWIDTH_HANGUL_LETTER_E";
        case   0xFFCA: return "HALFWIDTH_HANGUL_LETTER_YEO";
        case   0xFFCB: return "HALFWIDTH_HANGUL_LETTER_YE";
        case   0xFFCC: return "HALFWIDTH_HANGUL_LETTER_O";
        case   0xFFCD: return "HALFWIDTH_HANGUL_LETTER_WA";
        case   0xFFCE: return "HALFWIDTH_HANGUL_LETTER_WAE";
        case   0xFFCF: return "HALFWIDTH_HANGUL_LETTER_OE";
        case   0xFFD2: return "HALFWIDTH_HANGUL_LETTER_YO";
        case   0xFFD3: return "HALFWIDTH_HANGUL_LETTER_U";
        case   0xFFD4: return "HALFWIDTH_HANGUL_LETTER_WEO";
        case   0xFFD5: return "HALFWIDTH_HANGUL_LETTER_WE";
        case   0xFFD6: return "HALFWIDTH_HANGUL_LETTER_WI";
        case   0xFFD7: return "HALFWIDTH_HANGUL_LETTER_YU";
        case   0xFFDA: return "HALFWIDTH_HANGUL_LETTER_EU";
        case   0xFFDB: return "HALFWIDTH_HANGUL_LETTER_YI";
        case   0xFFDC: return "HALFWIDTH_HANGUL_LETTER_I";
        case   0xFFE0: return "FULLWIDTH_CENT_SIGN";
        case   0xFFE1: return "FULLWIDTH_POUND_SIGN";
        case   0xFFE2: return "FULLWIDTH_NOT_SIGN";
        case   0xFFE3: return "FULLWIDTH_MACRON";
        case   0xFFE4: return "FULLWIDTH_BROKEN_BAR";
        case   0xFFE5: return "FULLWIDTH_YEN_SIGN";
        case   0xFFE6: return "FULLWIDTH_WON_SIGN";
        case   0xFFE8: return "HALFWIDTH_FORMS_LIGHT_VERTICAL";
        case   0xFFE9: return "HALFWIDTH_LEFTWARDS_ARROW";
        case   0xFFEA: return "HALFWIDTH_UPWARDS_ARROW";
        case   0xFFEB: return "HALFWIDTH_RIGHTWARDS_ARROW";
        case   0xFFEC: return "HALFWIDTH_DOWNWARDS_ARROW";
        case   0xFFED: return "HALFWIDTH_BLACK_SQUARE";
        case   0xFFEE: return "HALFWIDTH_WHITE_CIRCLE";
        case   0xFFF9: return "INTERLINEAR_ANNOTATION_ANCHOR";
        case   0xFFFA: return "INTERLINEAR_ANNOTATION_SEPARATOR";
        case   0xFFFB: return "INTERLINEAR_ANNOTATION_TERMINATOR";
        case   0xFFFC: return "OBJECT_REPLACEMENT_CHARACTER";
        case   0xFFFD: return "REPLACEMENT_CHARACTER";
        case  0x10000: return "LINEAR_B_SYLLABLE_B008_A";
        case  0x10001: return "LINEAR_B_SYLLABLE_B038_E";
        case  0x10002: return "LINEAR_B_SYLLABLE_B028_I";
        case  0x10003: return "LINEAR_B_SYLLABLE_B061_O";
        case  0x10004: return "LINEAR_B_SYLLABLE_B010_U";
        case  0x10005: return "LINEAR_B_SYLLABLE_B001_DA";
        case  0x10006: return "LINEAR_B_SYLLABLE_B045_DE";
        case  0x10007: return "LINEAR_B_SYLLABLE_B007_DI";
        case  0x10008: return "LINEAR_B_SYLLABLE_B014_DO";
        case  0x10009: return "LINEAR_B_SYLLABLE_B051_DU";
        case  0x1000A: return "LINEAR_B_SYLLABLE_B057_JA";
        case  0x1000B: return "LINEAR_B_SYLLABLE_B046_JE";
        case  0x1000D: return "LINEAR_B_SYLLABLE_B036_JO";
        case  0x1000E: return "LINEAR_B_SYLLABLE_B065_JU";
        case  0x1000F: return "LINEAR_B_SYLLABLE_B077_KA";
        case  0x10010: return "LINEAR_B_SYLLABLE_B044_KE";
        case  0x10011: return "LINEAR_B_SYLLABLE_B067_KI";
        case  0x10012: return "LINEAR_B_SYLLABLE_B070_KO";
        case  0x10013: return "LINEAR_B_SYLLABLE_B081_KU";
        case  0x10014: return "LINEAR_B_SYLLABLE_B080_MA";
        case  0x10015: return "LINEAR_B_SYLLABLE_B013_ME";
        case  0x10016: return "LINEAR_B_SYLLABLE_B073_MI";
        case  0x10017: return "LINEAR_B_SYLLABLE_B015_MO";
        case  0x10018: return "LINEAR_B_SYLLABLE_B023_MU";
        case  0x10019: return "LINEAR_B_SYLLABLE_B006_NA";
        case  0x1001A: return "LINEAR_B_SYLLABLE_B024_NE";
        case  0x1001B: return "LINEAR_B_SYLLABLE_B030_NI";
        case  0x1001C: return "LINEAR_B_SYLLABLE_B052_NO";
        case  0x1001D: return "LINEAR_B_SYLLABLE_B055_NU";
        case  0x1001E: return "LINEAR_B_SYLLABLE_B003_PA";
        case  0x1001F: return "LINEAR_B_SYLLABLE_B072_PE";
        case  0x10020: return "LINEAR_B_SYLLABLE_B039_PI";
        case  0x10021: return "LINEAR_B_SYLLABLE_B011_PO";
        case  0x10022: return "LINEAR_B_SYLLABLE_B050_PU";
        case  0x10023: return "LINEAR_B_SYLLABLE_B016_QA";
        case  0x10024: return "LINEAR_B_SYLLABLE_B078_QE";
        case  0x10025: return "LINEAR_B_SYLLABLE_B021_QI";
        case  0x10026: return "LINEAR_B_SYLLABLE_B032_QO";
        case  0x10028: return "LINEAR_B_SYLLABLE_B060_RA";
        case  0x10029: return "LINEAR_B_SYLLABLE_B027_RE";
        case  0x1002A: return "LINEAR_B_SYLLABLE_B053_RI";
        case  0x1002B: return "LINEAR_B_SYLLABLE_B002_RO";
        case  0x1002C: return "LINEAR_B_SYLLABLE_B026_RU";
        case  0x1002D: return "LINEAR_B_SYLLABLE_B031_SA";
        case  0x1002E: return "LINEAR_B_SYLLABLE_B009_SE";
        case  0x1002F: return "LINEAR_B_SYLLABLE_B041_SI";
        case  0x10030: return "LINEAR_B_SYLLABLE_B012_SO";
        case  0x10031: return "LINEAR_B_SYLLABLE_B058_SU";
        case  0x10032: return "LINEAR_B_SYLLABLE_B059_TA";
        case  0x10033: return "LINEAR_B_SYLLABLE_B004_TE";
        case  0x10034: return "LINEAR_B_SYLLABLE_B037_TI";
        case  0x10035: return "LINEAR_B_SYLLABLE_B005_TO";
        case  0x10036: return "LINEAR_B_SYLLABLE_B069_TU";
        case  0x10037: return "LINEAR_B_SYLLABLE_B054_WA";
        case  0x10038: return "LINEAR_B_SYLLABLE_B075_WE";
        case  0x10039: return "LINEAR_B_SYLLABLE_B040_WI";
        case  0x1003A: return "LINEAR_B_SYLLABLE_B042_WO";
        case  0x1003C: return "LINEAR_B_SYLLABLE_B017_ZA";
        case  0x1003D: return "LINEAR_B_SYLLABLE_B074_ZE";
        case  0x1003F: return "LINEAR_B_SYLLABLE_B020_ZO";
        case  0x10040: return "LINEAR_B_SYLLABLE_B025_A2";
        case  0x10041: return "LINEAR_B_SYLLABLE_B043_A3";
        case  0x10042: return "LINEAR_B_SYLLABLE_B085_AU";
        case  0x10043: return "LINEAR_B_SYLLABLE_B071_DWE";
        case  0x10044: return "LINEAR_B_SYLLABLE_B090_DWO";
        case  0x10045: return "LINEAR_B_SYLLABLE_B048_NWA";
        case  0x10046: return "LINEAR_B_SYLLABLE_B029_PU2";
        case  0x10047: return "LINEAR_B_SYLLABLE_B062_PTE";
        case  0x10048: return "LINEAR_B_SYLLABLE_B076_RA2";
        case  0x10049: return "LINEAR_B_SYLLABLE_B033_RA3";
        case  0x1004A: return "LINEAR_B_SYLLABLE_B068_RO2";
        case  0x1004B: return "LINEAR_B_SYLLABLE_B066_TA2";
        case  0x1004C: return "LINEAR_B_SYLLABLE_B087_TWE";
        case  0x1004D: return "LINEAR_B_SYLLABLE_B091_TWO";
        case  0x10050: return "LINEAR_B_SYMBOL_B018";
        case  0x10051: return "LINEAR_B_SYMBOL_B019";
        case  0x10052: return "LINEAR_B_SYMBOL_B022";
        case  0x10053: return "LINEAR_B_SYMBOL_B034";
        case  0x10054: return "LINEAR_B_SYMBOL_B047";
        case  0x10055: return "LINEAR_B_SYMBOL_B049";
        case  0x10056: return "LINEAR_B_SYMBOL_B056";
        case  0x10057: return "LINEAR_B_SYMBOL_B063";
        case  0x10058: return "LINEAR_B_SYMBOL_B064";
        case  0x10059: return "LINEAR_B_SYMBOL_B079";
        case  0x1005A: return "LINEAR_B_SYMBOL_B082";
        case  0x1005B: return "LINEAR_B_SYMBOL_B083";
        case  0x1005C: return "LINEAR_B_SYMBOL_B086";
        case  0x1005D: return "LINEAR_B_SYMBOL_B089";
        case  0x10080: return "LINEAR_B_IDEOGRAM_B100_MAN";
        case  0x10081: return "LINEAR_B_IDEOGRAM_B102_WOMAN";
        case  0x10082: return "LINEAR_B_IDEOGRAM_B104_DEER";
        case  0x10083: return "LINEAR_B_IDEOGRAM_B105_EQUID";
        case  0x10084: return "LINEAR_B_IDEOGRAM_B105F_MARE";
        case  0x10085: return "LINEAR_B_IDEOGRAM_B105M_STALLION";
        case  0x10086: return "LINEAR_B_IDEOGRAM_B106F_EWE";
        case  0x10087: return "LINEAR_B_IDEOGRAM_B106M_RAM";
        case  0x10088: return "LINEAR_B_IDEOGRAM_B107F_SHE_GOAT";
        case  0x10089: return "LINEAR_B_IDEOGRAM_B107M_HE_GOAT";
        case  0x1008A: return "LINEAR_B_IDEOGRAM_B108F_SOW";
        case  0x1008B: return "LINEAR_B_IDEOGRAM_B108M_BOAR";
        case  0x1008C: return "LINEAR_B_IDEOGRAM_B109F_COW";
        case  0x1008D: return "LINEAR_B_IDEOGRAM_B109M_BULL";
        case  0x1008E: return "LINEAR_B_IDEOGRAM_B120_WHEAT";
        case  0x1008F: return "LINEAR_B_IDEOGRAM_B121_BARLEY";
        case  0x10090: return "LINEAR_B_IDEOGRAM_B122_OLIVE";
        case  0x10091: return "LINEAR_B_IDEOGRAM_B123_SPICE";
        case  0x10092: return "LINEAR_B_IDEOGRAM_B125_CYPERUS";
        case  0x10093: return "LINEAR_B_MONOGRAM_B127_KAPO";
        case  0x10094: return "LINEAR_B_MONOGRAM_B128_KANAKO";
        case  0x10095: return "LINEAR_B_IDEOGRAM_B130_OIL";
        case  0x10096: return "LINEAR_B_IDEOGRAM_B131_WINE";
        case  0x10097: return "LINEAR_B_IDEOGRAM_B132";
        case  0x10098: return "LINEAR_B_MONOGRAM_B133_AREPA";
        case  0x10099: return "LINEAR_B_MONOGRAM_B135_MERI";
        case  0x1009A: return "LINEAR_B_IDEOGRAM_B140_BRONZE";
        case  0x1009B: return "LINEAR_B_IDEOGRAM_B141_GOLD";
        case  0x1009C: return "LINEAR_B_IDEOGRAM_B142";
        case  0x1009D: return "LINEAR_B_IDEOGRAM_B145_WOOL";
        case  0x1009E: return "LINEAR_B_IDEOGRAM_B146";
        case  0x1009F: return "LINEAR_B_IDEOGRAM_B150";
        case  0x100A0: return "LINEAR_B_IDEOGRAM_B151_HORN";
        case  0x100A1: return "LINEAR_B_IDEOGRAM_B152";
        case  0x100A2: return "LINEAR_B_IDEOGRAM_B153";
        case  0x100A3: return "LINEAR_B_IDEOGRAM_B154";
        case  0x100A4: return "LINEAR_B_MONOGRAM_B156_TURO2";
        case  0x100A5: return "LINEAR_B_IDEOGRAM_B157";
        case  0x100A6: return "LINEAR_B_IDEOGRAM_B158";
        case  0x100A7: return "LINEAR_B_IDEOGRAM_B159_CLOTH";
        case  0x100A8: return "LINEAR_B_IDEOGRAM_B160";
        case  0x100A9: return "LINEAR_B_IDEOGRAM_B161";
        case  0x100AA: return "LINEAR_B_IDEOGRAM_B162_GARMENT";
        case  0x100AB: return "LINEAR_B_IDEOGRAM_B163_ARMOUR";
        case  0x100AC: return "LINEAR_B_IDEOGRAM_B164";
        case  0x100AD: return "LINEAR_B_IDEOGRAM_B165";
        case  0x100AE: return "LINEAR_B_IDEOGRAM_B166";
        case  0x100AF: return "LINEAR_B_IDEOGRAM_B167";
        case  0x100B0: return "LINEAR_B_IDEOGRAM_B168";
        case  0x100B1: return "LINEAR_B_IDEOGRAM_B169";
        case  0x100B2: return "LINEAR_B_IDEOGRAM_B170";
        case  0x100B3: return "LINEAR_B_IDEOGRAM_B171";
        case  0x100B4: return "LINEAR_B_IDEOGRAM_B172";
        case  0x100B5: return "LINEAR_B_IDEOGRAM_B173_MONTH";
        case  0x100B6: return "LINEAR_B_IDEOGRAM_B174";
        case  0x100B7: return "LINEAR_B_IDEOGRAM_B176_TREE";
        case  0x100B8: return "LINEAR_B_IDEOGRAM_B177";
        case  0x100B9: return "LINEAR_B_IDEOGRAM_B178";
        case  0x100BA: return "LINEAR_B_IDEOGRAM_B179";
        case  0x100BB: return "LINEAR_B_IDEOGRAM_B180";
        case  0x100BC: return "LINEAR_B_IDEOGRAM_B181";
        case  0x100BD: return "LINEAR_B_IDEOGRAM_B182";
        case  0x100BE: return "LINEAR_B_IDEOGRAM_B183";
        case  0x100BF: return "LINEAR_B_IDEOGRAM_B184";
        case  0x100C0: return "LINEAR_B_IDEOGRAM_B185";
        case  0x100C1: return "LINEAR_B_IDEOGRAM_B189";
        case  0x100C2: return "LINEAR_B_IDEOGRAM_B190";
        case  0x100C3: return "LINEAR_B_IDEOGRAM_B191_HELMET";
        case  0x100C4: return "LINEAR_B_IDEOGRAM_B220_FOOTSTOOL";
        case  0x100C5: return "LINEAR_B_IDEOGRAM_B225_BATHTUB";
        case  0x100C6: return "LINEAR_B_IDEOGRAM_B230_SPEAR";
        case  0x100C7: return "LINEAR_B_IDEOGRAM_B231_ARROW";
        case  0x100C8: return "LINEAR_B_IDEOGRAM_B232";
        case  0x100C9: return "LINEAR_B_IDEOGRAM_B233_SWORD";
        case  0x100CA: return "LINEAR_B_IDEOGRAM_B234";
        case  0x100CB: return "LINEAR_B_IDEOGRAM_B236";
        case  0x100CC: return "LINEAR_B_IDEOGRAM_B240_WHEELED_CHARIOT";
        case  0x100CD: return "LINEAR_B_IDEOGRAM_B241_CHARIOT";
        case  0x100CE: return "LINEAR_B_IDEOGRAM_B242_CHARIOT_FRAME";
        case  0x100CF: return "LINEAR_B_IDEOGRAM_B243_WHEEL";
        case  0