// entries.h                               Copyright (C) Codemist 1991-2021


/**************************************************************************
 * Copyright (C) 2021, Codemist.                         A C Norman       *
 *                                                                        *
 * Redistribution and use in source and binary forms, with or without     *
 * modification, are permitted provided that the following conditions are *
 * met:                                                                   *
 *                                                                        *
 *     * Redistributions of source code must retain the relevant          *
 *       copyright notice, this list of conditions and the following      *
 *       disclaimer.                                                      *
 *     * Redistributions in binary form must reproduce the above          *
 *       copyright notice, this list of conditions and the following      *
 *       disclaimer in the documentation and/or other materials provided  *
 *       with the distribution.                                           *
 *                                                                        *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS    *
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT      *
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS      *
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE         *
 * COPYRIGHT OWNERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,   *
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,   *
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS  *
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND *
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR  *
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF     *
 * THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH   *
 * DAMAGE.                                                                *
 *************************************************************************/
// $Id: entries.h 5836 2021-07-04 20:03:59Z arthurcnorman $

#ifndef header_entries_h
#define header_entries_h 1

//
// things with no args...
//

#ifdef CONSERVATIVE
extern void poll();
#endif

// Use C linkage so that if CSL/Reduce is used as a DLL there is still an
// easy way to access these.

extern LispObject Lbatchp(LispObject env);
extern LispObject Ldate(LispObject env);
extern LispObject Ldatestamp(LispObject env);
extern LispObject Leject(LispObject env);
extern LispObject Lerror_0(LispObject env);
extern LispObject Lall_symbols0(LispObject env);
extern LispObject Lflush(LispObject env);
extern LispObject Lgc(LispObject env);
extern LispObject Lgctime(LispObject env);
extern LispObject Lgensym(LispObject env);
extern LispObject Llist_modules(LispObject env);
extern LispObject Llibrary_members0(LispObject env);
extern LispObject Lload_source0(LispObject env);
extern LispObject Lload_selected_source0(LispObject env);
extern LispObject Lload_spid(LispObject);
extern LispObject Llposn(LispObject env);
extern LispObject Lmapstore0(LispObject env);
extern LispObject Lnext_random(LispObject env);
extern LispObject Lnilfn(LispObject env);
extern LispObject Lposn(LispObject env);
extern LispObject Lread(LispObject env);
extern LispObject Lreadch(LispObject env);
extern LispObject Lrtell(LispObject env);
extern LispObject Lstop(LispObject env);
extern LispObject Lterpri(LispObject env);
extern LispObject Ltime(LispObject env);
extern LispObject Ltmpnam(LispObject env);
extern LispObject Ltyi(LispObject env);
extern LispObject Lunserialize(LispObject env);
extern LispObject autoload_0(LispObject env);
extern LispObject bytecoded_0(LispObject env);
extern LispObject Lbytecounts_0(LispObject env);
extern LispObject byteopt_0(LispObject def);
extern LispObject byteoptrest_0(LispObject def);
extern LispObject funarged_0(LispObject env);
extern LispObject tracefunarged_0(LispObject env);
extern LispObject hardopt_0(LispObject def);
extern LispObject hardoptrest_0(LispObject def);
extern LispObject interpreted_0(LispObject env);
extern LispObject tracebytecoded_0(LispObject env);
extern LispObject tracebyteopt_0(LispObject def);
extern LispObject tracebyteoptrest_0(LispObject def);
extern LispObject tracebytecoded_0(LispObject env);
extern LispObject traceinterpreted_0(LispObject env);
extern LispObject tracehardopt_0(LispObject def);
extern LispObject tracehardoptrest_0(LispObject def);
extern LispObject undefined_0(LispObject env);
extern LispObject f0_as_0(LispObject env);


//
// things with one arg...
//

extern LispObject autoload_1(LispObject env, LispObject a);
extern LispObject bytecoded_1(LispObject env, LispObject a);
extern LispObject Lbytecounts_1(LispObject env, LispObject a);
extern LispObject byteopt_1(LispObject def, LispObject a);
extern LispObject byteoptrest_1(LispObject def, LispObject a);
extern LispObject funarged_1(LispObject env, LispObject a1);
extern LispObject tracefunarged_1(LispObject env, LispObject a1);
extern LispObject hardopt_1(LispObject def, LispObject a);
extern LispObject hardoptrest_1(LispObject def, LispObject a);
extern LispObject interpreted_1(LispObject env, LispObject a1);
extern LispObject tracebytecoded_1(LispObject env, LispObject a);
extern LispObject tracebyteopt_1(LispObject def, LispObject a);
extern LispObject tracebyteoptrest_1(LispObject def, LispObject a);
extern LispObject tracebytecoded_1(LispObject env, LispObject a);
extern LispObject traceinterpreted_1(LispObject env, LispObject a1);
extern LispObject tracehardopt_1(LispObject def, LispObject a);
extern LispObject tracehardoptrest_1(LispObject def, LispObject a);
extern LispObject undefined_1(LispObject env, LispObject a1);
extern LispObject f1_as_0(LispObject env, LispObject a);
extern LispObject f1_as_1(LispObject env, LispObject a);

extern LispObject Labsval(LispObject env, LispObject a);
extern LispObject Ladd1(LispObject env, LispObject a);
extern LispObject Lalpha_char_p(LispObject env, LispObject a);
extern LispObject Lall_symbols(LispObject env, LispObject a1);
extern LispObject Lapply0(LispObject env, LispObject a);
extern LispObject Lapply_1(LispObject env, LispObject fn);
extern LispObject Latan(LispObject env, LispObject a);
extern LispObject Latom(LispObject env, LispObject a);
extern LispObject Lbanner(LispObject env, LispObject a);
extern LispObject Lboundp(LispObject env, LispObject a);
extern LispObject Lbpsp(LispObject env, LispObject a);
extern LispObject Lbpsupbv(LispObject env, LispObject v);
extern LispObject Lcaaaar(LispObject env, LispObject a);
extern LispObject Lcaaadr(LispObject env, LispObject a);
extern LispObject Lcaaar(LispObject env, LispObject a);
extern LispObject Lcaadar(LispObject env, LispObject a);
extern LispObject Lcaaddr(LispObject env, LispObject a);
extern LispObject Lcaadr(LispObject env, LispObject a);
extern LispObject Lcaar(LispObject env, LispObject a);
extern LispObject Lcaar(LispObject env, LispObject a);
extern LispObject Lcadaar(LispObject env, LispObject a);
extern LispObject Lcadadr(LispObject env, LispObject a);
extern LispObject Lcadar(LispObject env, LispObject a);
extern LispObject Lcaddar(LispObject env, LispObject a);
extern LispObject Lcadddr(LispObject env, LispObject a);
extern LispObject Lcaddr(LispObject env, LispObject a);
extern LispObject Lcadr(LispObject env, LispObject a);
extern LispObject Lcadr(LispObject env, LispObject a);
extern LispObject Lcar(LispObject env, LispObject a);
extern LispObject Lcar(LispObject env, LispObject a);
extern LispObject Lcdaaar(LispObject env, LispObject a);
extern LispObject Lcdaadr(LispObject env, LispObject a);
extern LispObject Lcdaar(LispObject env, LispObject a);
extern LispObject Lcdadar(LispObject env, LispObject a);
extern LispObject Lcdaddr(LispObject env, LispObject a);
extern LispObject Lcdadr(LispObject env, LispObject a);
extern LispObject Lcdar(LispObject env, LispObject a);
extern LispObject Lcdar(LispObject env, LispObject a);
extern LispObject Lcddaar(LispObject env, LispObject a);
extern LispObject Lcddadr(LispObject env, LispObject a);
extern LispObject Lcddar(LispObject env, LispObject a);
extern LispObject Lcdddar(LispObject env, LispObject a);
extern LispObject Lcddddr(LispObject env, LispObject a);
extern LispObject Lcdddr(LispObject env, LispObject a);
extern LispObject Lcddr(LispObject env, LispObject a);
extern LispObject Lcddr(LispObject env, LispObject a);
extern LispObject Lcdr(LispObject env, LispObject a);
extern LispObject Lcdr(LispObject env, LispObject a);
extern LispObject Lchar_code(LispObject env, LispObject a);
extern LispObject Lclose(LispObject env, LispObject a);
extern LispObject Lcodep(LispObject env, LispObject a);
extern LispObject Lcompress(LispObject env, LispObject a);
extern LispObject Lconsp(LispObject env, LispObject a);
extern LispObject Lconstantp(LispObject env, LispObject a);
extern LispObject Lcopy_module(LispObject env, LispObject a);
extern LispObject Ldefine_in_module(LispObject env, LispObject a);
extern LispObject Ldelete_module(LispObject env, LispObject a);
extern LispObject Ldigitp(LispObject env, LispObject a);
extern LispObject Lendp(LispObject env, LispObject a);
extern LispObject Lerror_1(LispObject env, LispObject a1);
extern LispObject Lerrorset_1(LispObject env, LispObject form);
extern LispObject Leval(LispObject env, LispObject a);
extern LispObject Levenp(LispObject env, LispObject a);
extern LispObject Levlis(LispObject env, LispObject a);
extern LispObject Lexplode(LispObject env, LispObject a);
extern LispObject Lexplode2lc(LispObject env, LispObject a);
extern LispObject Lexplode2lcn(LispObject env, LispObject a);
extern LispObject Lexplode2n(LispObject env, LispObject a);
extern LispObject Lexplodec(LispObject env, LispObject a);
extern LispObject Lexplodecn(LispObject env, LispObject a);
extern LispObject Lexplodehex(LispObject env, LispObject a);
extern LispObject Lexploden(LispObject env, LispObject a);
extern LispObject Lexplodeoctal(LispObject env, LispObject a);
extern LispObject Lfixp(LispObject env, LispObject a);
extern LispObject Lfloat(LispObject env, LispObject a);
extern LispObject Lfloatp(LispObject env, LispObject a);
extern LispObject Lfrexp(LispObject env, LispObject a);
extern LispObject Lfuncall_1(LispObject env, LispObject fn);
extern LispObject Lgc(LispObject env, LispObject a);
extern LispObject Lgc_forcer1(LispObject env, LispObject a);
extern LispObject Lgensym0(LispObject env, LispObject a,
                           const char *s);
extern LispObject Lgensym1(LispObject env, LispObject a); // OLD name
extern LispObject Lgensym(LispObject env, LispObject a);
extern LispObject Lgensym2(LispObject env, LispObject a);
extern LispObject Lgetd(LispObject env, LispObject a);
extern LispObject Lgetenv(LispObject env, LispObject a);
extern LispObject Lget_bps(LispObject env, LispObject a);
extern LispObject Liadd1(LispObject env, LispObject a);
extern LispObject Lidentity(LispObject env, LispObject a);
extern LispObject Liminus(LispObject env, LispObject a);
extern LispObject Liminusp(LispObject env, LispObject a);
extern LispObject Lindirect(LispObject env, LispObject a);
extern LispObject Lintegerp(LispObject env, LispObject a);
extern LispObject Lintern(LispObject env, LispObject a);
extern LispObject Lionep(LispObject env, LispObject a);
extern LispObject Lis_spid(LispObject env, LispObject a);
extern LispObject Lisub1(LispObject env, LispObject a);
extern LispObject Lizerop(LispObject env, LispObject a);
extern LispObject Llength(LispObject env, LispObject a);
extern LispObject Llengthc(LispObject env, LispObject a);
extern LispObject Llibrary_members(LispObject env, LispObject a);
extern LispObject Llinelength(LispObject env, LispObject a);
extern LispObject Llist_to_string(LispObject env, LispObject a);
extern LispObject Llist_to_vector(LispObject env, LispObject a);
extern LispObject Lload_module(LispObject env, LispObject a);
extern LispObject Lload_source(LispObject env, LispObject a);
extern LispObject Lload_selected_source(LispObject env, LispObject a);
extern LispObject Llognot(LispObject env, LispObject a);
extern LispObject Llog_1(LispObject env, LispObject a);
extern LispObject Llsd(LispObject env, LispObject a);
extern LispObject Lmacroexpand(LispObject env, LispObject a);
extern LispObject Lmacroexpand_1(LispObject env, LispObject a);
extern LispObject Lmacro_function(LispObject env, LispObject a);
extern LispObject Lmake_global(LispObject env, LispObject a);
extern LispObject Lmake_keyword(LispObject env, LispObject a);
extern LispObject Lmake_special(LispObject env, LispObject a);
extern LispObject Lmapstore(LispObject env, LispObject a);
extern LispObject Lmd5(LispObject env, LispObject a1);
extern LispObject Lmd60(LispObject env, LispObject a1);
extern LispObject Lminus(LispObject env, LispObject a);
extern LispObject Lminusp(LispObject env, LispObject a);
extern LispObject Lmkevect(LispObject env, LispObject n);
extern LispObject Lmkhash_1(LispObject env, LispObject a);
extern LispObject Lmkhashset(LispObject env, LispObject a);
extern LispObject Lmkquote(LispObject env, LispObject a);
extern LispObject Lmkvect(LispObject env, LispObject a);
extern LispObject Lmodular_minus(LispObject env, LispObject a);
extern LispObject Lmodular_number(LispObject env, LispObject a);
extern LispObject Lmodular_reciprocal(LispObject env, LispObject a);
extern LispObject Lmodule_exists(LispObject env, LispObject a);
extern LispObject Lmsd(LispObject env, LispObject a);
extern LispObject Lmv_list(LispObject env, LispObject a);
extern LispObject Lncons(LispObject env, LispObject a);
extern LispObject Lnreverse(LispObject env, LispObject a);
extern LispObject Lnull(LispObject env, LispObject a);
extern LispObject Lnumberp(LispObject env, LispObject a);
extern LispObject Loddp(LispObject env, LispObject a);
extern LispObject Lonep(LispObject env, LispObject a);
extern LispObject Lpagelength(LispObject env, LispObject a);
extern LispObject Lplist(LispObject env, LispObject a);
extern LispObject Lplusp(LispObject env, LispObject a);
extern LispObject Lprin(LispObject env, LispObject a);
extern LispObject Lprin(LispObject env, LispObject a);
extern LispObject Lprin2a(LispObject env, LispObject a);
extern LispObject Lprinc(LispObject env, LispObject a);
extern LispObject Lprinc(LispObject env, LispObject a);
extern LispObject Lprint(LispObject env, LispObject a);
extern LispObject Lprintc(LispObject env, LispObject a);
extern LispObject Lrandom_1(LispObject env, LispObject a);
extern LispObject Lrational(LispObject env, LispObject a);
extern LispObject Lrdf1(LispObject env, LispObject a);
extern LispObject Lrds(LispObject env, LispObject a);
extern LispObject Lremd(LispObject env, LispObject a);
extern LispObject Lrepresentation1(LispObject env, LispObject a);
extern LispObject Lreverse(LispObject env, LispObject a);
extern LispObject Lserialize(LispObject env, LispObject a);
extern LispObject Lserialize1(LispObject env, LispObject a);
extern LispObject Lsetpchar(LispObject env, LispObject a);
extern LispObject Lset_small_modulus(LispObject env, LispObject a);
extern LispObject Lsmkvect(LispObject env, LispObject a);
extern LispObject Lspecial_char(LispObject env, LispObject a);
extern LispObject Lspecial_form_p(LispObject env, LispObject a);
extern LispObject Lspid_to_nil(LispObject env, LispObject a);
extern LispObject Lspool(LispObject env, LispObject a);
extern LispObject Lstart_module(LispObject env, LispObject a);
extern LispObject Lstop(LispObject env, LispObject a);
extern LispObject Lstringp(LispObject env, LispObject a);
extern LispObject Lsub1(LispObject env, LispObject a);
extern LispObject Lsymbolp(LispObject env, LispObject a);
extern LispObject Lsymbol_argcount(LispObject env, LispObject a);
extern LispObject Lsymbol_argcode(LispObject env, LispObject a);
extern LispObject Lsymbol_env(LispObject env, LispObject a);
extern LispObject Lsymbol_function(LispObject env, LispObject a);
extern LispObject Lsymbol_globalp(LispObject env, LispObject a);
extern LispObject Lsymbol_name(LispObject env, LispObject a);
extern LispObject Lsymbol_restore_fns(LispObject env, LispObject a);
extern LispObject Lsymbol_specialp(LispObject env, LispObject a);
extern LispObject Lsymbol_value(LispObject env, LispObject a);
extern LispObject Lsystem(LispObject env, LispObject a);
extern LispObject Lthreevectorp(LispObject env, LispObject a);
extern LispObject Lthrow_nil(LispObject env, LispObject a);
extern LispObject Ltrace(LispObject env, LispObject a);
extern LispObject Ltruncate(LispObject env, LispObject a);
extern LispObject Lttab(LispObject env, LispObject a);
extern LispObject Ltyo(LispObject env, LispObject a);
extern LispObject Lunintern(LispObject env, LispObject a);
extern LispObject Lunmake_global(LispObject env, LispObject a);
extern LispObject Lunmake_keyword(LispObject env, LispObject a);
extern LispObject Lunmake_special(LispObject env, LispObject a);
extern LispObject Luntrace(LispObject env, LispObject a);
extern LispObject Lupbv(LispObject env, LispObject a);
extern LispObject Lsimple_vectorp(LispObject env, LispObject a);
extern LispObject Lvectorp(LispObject env, LispObject a);
extern LispObject Lverbos(LispObject env, LispObject a);
extern LispObject Lwhitespace_char_p(LispObject env, LispObject a);
extern LispObject Lwritable_libraryp(LispObject env, LispObject a);
extern LispObject Lwrs(LispObject env, LispObject a);
extern LispObject Lxtab(LispObject env, LispObject a);
extern LispObject Lxtab(LispObject env, LispObject a);
extern LispObject Lzerop(LispObject env, LispObject a);
extern LispObject Lfind_symbol_1(LispObject env, LispObject str);
extern LispObject Llistp(LispObject env, LispObject a);

//
// things with two args ...
//

extern LispObject autoload_2(LispObject env, LispObject a1,
                             LispObject a2);
extern LispObject bytecoded_2(LispObject env, LispObject a,
                              LispObject b);
extern LispObject byteopt_2(LispObject def, LispObject a,
                            LispObject b);
extern LispObject byteoptrest_2(LispObject def, LispObject a,
                                LispObject b);
extern LispObject funarged_2(LispObject env, LispObject a1,
                             LispObject a2);
extern LispObject tracefunarged_2(LispObject env, LispObject a1,
                                  LispObject a2);
extern LispObject hardopt_2(LispObject def, LispObject a,
                            LispObject b);
extern LispObject hardoptrest_2(LispObject def, LispObject a,
                                LispObject b);
extern LispObject interpreted_2(LispObject env, LispObject a1,
                                LispObject a2);
extern LispObject tracebyteopt_2(LispObject def, LispObject a,
                                 LispObject b);
extern LispObject tracebyteoptrest_2(LispObject def, LispObject a,
                                     LispObject b);
extern LispObject tracebytecoded_2(LispObject env, LispObject a,
                                   LispObject b);
extern LispObject traceinterpreted_2(LispObject env, LispObject a1,
                                     LispObject a2);
extern LispObject tracehardopt_2(LispObject def, LispObject a,
                                 LispObject b);
extern LispObject tracehardoptrest_2(LispObject def, LispObject a,
                                     LispObject b);
extern LispObject undefined_2(LispObject env, LispObject a1,
                              LispObject a2);
extern LispObject f2_as_0(LispObject env, LispObject a, LispObject b);
extern LispObject f2_as_1(LispObject env, LispObject a, LispObject b);
extern LispObject f2_as_2(LispObject env, LispObject a, LispObject b);

extern LispObject Lappend_2(LispObject env, LispObject a,
                            LispObject b);
extern LispObject Lapply_2(LispObject env, LispObject fn,
                           LispObject a1);
extern LispObject Lapply1(LispObject env, LispObject a, LispObject b);
extern LispObject Lash(LispObject env, LispObject a, LispObject b);
extern LispObject Lash1(LispObject env, LispObject a, LispObject b);
extern LispObject Lassoc(LispObject env, LispObject a, LispObject b);
extern LispObject Latan2(LispObject env, LispObject a, LispObject b);
extern LispObject Latan2d(LispObject env, LispObject a, LispObject b);
extern LispObject Latsoc(LispObject env, LispObject a, LispObject b);
extern LispObject Lbpsgetv(LispObject env, LispObject v,
                           LispObject n);
extern LispObject Lcons(LispObject env, LispObject a, LispObject b);
extern LispObject Ldeleq(LispObject env, LispObject a, LispObject b);
extern LispObject Ldelete(LispObject env, LispObject a, LispObject b);
extern LispObject Ldifference_2(LispObject env, LispObject a,
                                LispObject b);
extern LispObject Ldivide_2(LispObject env, LispObject a,
                            LispObject b);
extern LispObject Lelt(LispObject env, LispObject a, LispObject b);
extern LispObject Leq(LispObject env, LispObject a, LispObject b);
extern LispObject Leqcar(LispObject env, LispObject a, LispObject b);
extern LispObject Lequalcar(LispObject env, LispObject a,
                            LispObject b);
extern LispObject Leql(LispObject env, LispObject a, LispObject b);
extern LispObject Leqn_2(LispObject env, LispObject a, LispObject b);
extern LispObject Lcl_equal(LispObject env, LispObject a,
                            LispObject b);
extern LispObject Lequal(LispObject env, LispObject a, LispObject b);
extern LispObject Lerror_2(LispObject env, LispObject a1, LispObject a2);
extern LispObject Lerrorset_2(LispObject env, LispObject form,
                              LispObject ffg1);
extern LispObject Lexpt(LispObject env, LispObject a, LispObject b);
extern LispObject Lflag(LispObject env, LispObject a, LispObject b);
extern LispObject Lflagp(LispObject env, LispObject a, LispObject b);
extern LispObject Lflagpcar(LispObject env, LispObject a,
                            LispObject b);
extern LispObject Lfuncall_2(LispObject env, LispObject fn,
                             LispObject a1);
extern LispObject Lgc_forcer(LispObject env, LispObject a,
                             LispObject b);
extern LispObject Lgcd_2(LispObject env, LispObject a, LispObject b);
extern LispObject Lgeq_2(LispObject env, LispObject a, LispObject b);
extern LispObject Lget(LispObject env, LispObject a, LispObject b);
extern LispObject Lget_hash_2(LispObject env, LispObject a,
                              LispObject b);
extern LispObject Lgetv(LispObject env, LispObject a, LispObject b);
extern LispObject Lgreaterp_2(LispObject env, LispObject a,
                              LispObject b);
extern LispObject Lidifference_2(LispObject env, LispObject a,
                                 LispObject b);
extern LispObject Ligeq_2(LispObject env, LispObject a, LispObject b);
extern LispObject Ligreaterp_2(LispObject env, LispObject a,
                               LispObject b);
extern LispObject Lileq_2(LispObject env, LispObject a, LispObject b);
extern LispObject Lilessp_2(LispObject env, LispObject a,
                            LispObject b);
extern LispObject Limax_2(LispObject env, LispObject a, LispObject b);
extern LispObject Limin_2(LispObject env, LispObject a, LispObject b);
extern LispObject Linorm(LispObject env, LispObject a, LispObject k);
extern LispObject Lintersect(LispObject env, LispObject a,
                             LispObject b);
extern LispObject Lintersect_symlist(LispObject env, LispObject a,
                                     LispObject b);
extern LispObject Liplus_2(LispObject env, LispObject a,
                           LispObject b);
extern LispObject Liquotient_2(LispObject env, LispObject a,
                               LispObject b);
extern LispObject Liremainder_2(LispObject env, LispObject a,
                                LispObject b);
extern LispObject Lirightshift(LispObject env, LispObject a,
                               LispObject b);
extern LispObject Litimes_2(LispObject env, LispObject a,
                            LispObject b);
extern LispObject Llcm_2(LispObject env, LispObject a, LispObject b);
extern LispObject Lleq_2(LispObject env, LispObject a, LispObject b);
extern LispObject Llessp_2(LispObject env, LispObject a,
                           LispObject b);
extern LispObject Llist_2(LispObject env, LispObject a, LispObject b);
extern LispObject Llog(LispObject env, LispObject a, LispObject b);
extern LispObject Llog_2(LispObject env, LispObject a, LispObject b);
extern LispObject Lmake_random_state(LispObject env, LispObject a,
                                     LispObject b);
extern LispObject Lmake_random_state(LispObject env, LispObject a,
                                     LispObject b);
extern LispObject Lmax_2(LispObject env, LispObject a, LispObject b);
extern LispObject Lmember(LispObject env, LispObject a, LispObject b);
extern LispObject Lmemq(LispObject env, LispObject a, LispObject b);
extern LispObject Lmin_2(LispObject env, LispObject a, LispObject b);
extern LispObject Lmkhash_2(LispObject env, LispObject a,
                            LispObject b);
extern LispObject Lmod_2(LispObject env, LispObject a, LispObject b);
extern LispObject Lmodular_difference(LispObject env, LispObject a,
                                      LispObject b);
extern LispObject Lmodular_expt(LispObject env, LispObject a,
                                LispObject b);
extern LispObject Lmodular_plus(LispObject env, LispObject a,
                                LispObject b);
extern LispObject Lmodular_quotient(LispObject env, LispObject a,
                                    LispObject b);
extern LispObject Lmodular_times(LispObject env, LispObject a,
                                 LispObject b);
extern LispObject Lnconc(LispObject env, LispObject a, LispObject b);
extern LispObject Lneq_2(LispObject env, LispObject a, LispObject b);
extern LispObject Lnreverse2(LispObject env, LispObject a,
                             LispObject b);
extern LispObject Lorderp(LispObject env, LispObject a, LispObject b);
extern LispObject Lpair(LispObject env, LispObject a, LispObject b);
extern LispObject Lplus_2(LispObject env, LispObject a, LispObject b);
extern LispObject Lquotient_2(LispObject env, LispObject a,
                              LispObject b);
extern LispObject Lrem_2(LispObject env, LispObject a, LispObject b);
extern LispObject Lremflag(LispObject env, LispObject a,
                           LispObject b);
extern LispObject Lremprop(LispObject env, LispObject a,
                           LispObject b);
extern LispObject Lrepresentation2(LispObject env, LispObject a,
                                   LispObject b);
extern LispObject Lresource_limit_2(LispObject env, LispObject a,
                                    LispObject b);
extern LispObject Lrplaca(LispObject env, LispObject a, LispObject b);
extern LispObject Lrplacd(LispObject env, LispObject a, LispObject b);
extern LispObject Lrseek(LispObject env, LispObject a);
extern LispObject Lset(LispObject env, LispObject a, LispObject b);
extern LispObject Lset_help_file(LispObject env, LispObject a,
                                 LispObject b);
extern LispObject Lsgetv(LispObject env, LispObject a, LispObject b);
extern LispObject Lsmemq(LispObject env, LispObject a, LispObject b);
extern LispObject Lsubla(LispObject env, LispObject a, LispObject b);
extern LispObject Lsublis(LispObject env, LispObject a, LispObject b);
extern LispObject Lsymbol_protect(LispObject env, LispObject a,
                                  LispObject b);
extern LispObject Lsymbol_set_definition(LispObject env, LispObject a,
        LispObject b);
extern LispObject Lsymbol_set_env(LispObject env, LispObject a,
                                  LispObject b);
extern LispObject Lthrow_one_value(LispObject env, LispObject a, LispObject b);
extern LispObject Ltimes_2(LispObject env, LispObject a,
                           LispObject b);
extern LispObject Lunion(LispObject env, LispObject a, LispObject b);
extern LispObject Lunion_symlist(LispObject env, LispObject a,
                                 LispObject b);
extern LispObject Lwrite_module(LispObject env, LispObject a,
                                LispObject b);
extern LispObject Lxcons(LispObject env, LispObject a, LispObject b);
extern LispObject Laref_2(LispObject env, LispObject a, LispObject b);
extern LispObject Latan_2(LispObject env, LispObject a, LispObject b);
extern LispObject Lelt(LispObject env, LispObject a, LispObject b);
extern LispObject Lfloat_2(LispObject env, LispObject a,
                           LispObject b);
extern LispObject Lintern_2(LispObject env, LispObject a,
                            LispObject b);
extern LispObject Lmacroexpand_1_2(LispObject env, LispObject a,
                                   LispObject b);
extern LispObject Lmacroexpand_2(LispObject env, LispObject a,
                                 LispObject b);
extern LispObject Lrandom_2(LispObject env, LispObject a,
                            LispObject b);
extern LispObject Ltruncate_2(LispObject env, LispObject a,
                              LispObject b);
extern LispObject Lunintern_2(LispObject env, LispObject a,
                              LispObject b);


//
// Things with exactly three args
//

extern LispObject f3_as_0(LispObject env, LispObject a1,
                          LispObject a2, LispObject a3);
extern LispObject f3_as_1(LispObject env, LispObject a1,
                          LispObject a2, LispObject a3);
extern LispObject f3_as_2(LispObject env, LispObject a1,
                          LispObject a2, LispObject a3);
extern LispObject f3_as_3(LispObject env, LispObject a1,
                          LispObject a2, LispObject a3);
extern LispObject Lapply_3(LispObject env, LispObject fn,
                           LispObject a1, LispObject a2);
extern LispObject Lapply2(LispObject env, LispObject a1,
                          LispObject a2, LispObject a3);
extern LispObject Lacons(LispObject env, LispObject a1, LispObject a2,
                         LispObject a3);
extern LispObject Laref_3(LispObject env, LispObject a1,
                          LispObject a2,
                          LispObject a3);
extern LispObject Laset_3(LispObject env, LispObject a1,
                          LispObject a2,
                          LispObject a3);
extern LispObject Lbpsputv(LispObject env, LispObject a1,
                           LispObject a2, LispObject a3);
extern LispObject Lerror_3(LispObject env, LispObject a1,
                           LispObject a2, LispObject a3);
extern LispObject Lerrorset_3(LispObject env, LispObject a1,
                              LispObject a2,
                              LispObject a3);
extern LispObject Lfuncall_3(LispObject env, LispObject fn,
                             LispObject a1, LispObject a2);
extern LispObject Llist_2star(LispObject env, LispObject a1,
                              LispObject a2, LispObject a3);
extern LispObject Llist_3(LispObject env, LispObject a1,
                          LispObject a2, LispObject a3);
extern LispObject Lput_hash(LispObject env, LispObject a1,
                            LispObject a2, LispObject a3);
extern LispObject Lputprop(LispObject env, LispObject a1,
                           LispObject a2, LispObject a3);
extern LispObject Lputv(LispObject env, LispObject a1, LispObject a2,
                        LispObject a3);
extern LispObject Lresource_limit_3(LispObject env, LispObject a,
                                    LispObject b, LispObject c);
extern LispObject Lsputv(LispObject env, LispObject a1, LispObject a2,
                         LispObject a3);
extern LispObject Lsubst(LispObject env, LispObject a1, LispObject a2,
                         LispObject a3);
extern LispObject Lget_3(LispObject env, LispObject a1, LispObject a2,
                         LispObject a3);
extern LispObject Lmkhash_3(LispObject env, LispObject a,
                            LispObject b, LispObject c);

extern LispObject autoload_3(LispObject env, LispObject, LispObject,
                             LispObject);
extern LispObject bytecoded_3(LispObject env, LispObject, LispObject,
                              LispObject);
extern LispObject byteopt_3(LispObject def, LispObject, LispObject,
                            LispObject);
extern LispObject byteoptrest_3(LispObject def, LispObject,
                                LispObject, LispObject);
extern LispObject funarged_3(LispObject env, LispObject, LispObject,
                             LispObject);
extern LispObject tracefunarged_3(LispObject env, LispObject,
                                  LispObject, LispObject);
extern LispObject hardopt_3(LispObject def, LispObject, LispObject,
                            LispObject);
extern LispObject hardoptrest_3(LispObject def, LispObject,
                                LispObject, LispObject);
extern LispObject interpreted_3(LispObject env, LispObject,
                                LispObject, LispObject);
extern LispObject tracebytecoded_3(LispObject env, LispObject,
                                   LispObject, LispObject);
extern LispObject tracebyteopt_3(LispObject def, LispObject,
                                 LispObject, LispObject);
extern LispObject tracebyteoptrest_3(LispObject def, LispObject,
                                     LispObject, LispObject);
extern LispObject tracebytecoded_3(LispObject env, LispObject,
                                   LispObject, LispObject);
extern LispObject traceinterpreted_3(LispObject env, LispObject,
                                     LispObject, LispObject);
extern LispObject tracehardopt_3(LispObject def, LispObject,
                                 LispObject, LispObject);
extern LispObject tracehardoptrest_3(LispObject def, LispObject,
                                     LispObject, LispObject);
extern LispObject undefined_3(LispObject env, LispObject a1,
                              LispObject a2,
                              LispObject a3);


//
// Things with four args or more args
//

extern LispObject autoload_4up(LispObject env, LispObject a1,
                               LispObject a2,
                               LispObject a3, LispObject a4up);
extern LispObject bytecoded_4up(LispObject env, LispObject a1,
                                LispObject a2,
                                LispObject a3, LispObject a4up);
extern LispObject byteopt_4up(LispObject def, LispObject a1,
                              LispObject a2,
                              LispObject a3, LispObject a4up);
extern LispObject byteoptrest_4up(LispObject def, LispObject a1,
                                  LispObject a2,
                                  LispObject a3, LispObject a4up);
extern LispObject funarged_4up(LispObject env, LispObject a1,
                               LispObject a2,
                               LispObject a3, LispObject a4up);
extern LispObject tracefunarged_4up(LispObject env, LispObject a1,
                                    LispObject a2,
                                    LispObject a3, LispObject a4up);
extern LispObject hardopt_4up(LispObject def, LispObject a1,
                              LispObject a2,
                              LispObject a3, LispObject a4up);
extern LispObject hardoptrest_4up(LispObject def, LispObject a1,
                                  LispObject a2,
                                  LispObject a3, LispObject a4up);
extern LispObject interpreted_4up(LispObject env, LispObject a1,
                                  LispObject a2,
                                  LispObject a3, LispObject a4up);
extern LispObject tracebyteopt_4up(LispObject def, LispObject a1,
                                   LispObject a2,
                                   LispObject a3, LispObject a4up);
extern LispObject tracebyteoptrest_4up(LispObject def, LispObject a1,
                                       LispObject a2,
                                       LispObject a3, LispObject a4up);
extern LispObject tracebytecoded0(LispObject env, LispObject a1,
                                  LispObject a2,
                                  LispObject a3, LispObject a4up);
extern LispObject tracebytecoded_4up(LispObject env, LispObject a1,
                                     LispObject a2,
                                     LispObject a3, LispObject a4up);
extern LispObject traceinterpreted_4up(LispObject env, LispObject a1,
                                       LispObject a2,
                                       LispObject a3, LispObject a4up);
extern LispObject tracehardopt_4up(LispObject def, LispObject a1,
                                   LispObject a2,
                                   LispObject a3, LispObject a4up);
extern LispObject tracehardoptrest_4up(LispObject def, LispObject a1,
                                       LispObject a2,
                                       LispObject a3, LispObject a4up);
extern LispObject undefined_4up(LispObject env, LispObject a1,
                                LispObject a2,
                                LispObject a3, LispObject a4up);

extern LispObject Lapply_4up(LispObject env, LispObject a1,
                             LispObject a2,
                             LispObject a3, LispObject a4up);
extern LispObject Lapply3(LispObject env, LispObject a1,
                          LispObject a2,
                          LispObject a3, LispObject a4up);
extern LispObject Lerror_34up(LispObject env, LispObject a1,
                              LispObject a2, LispObject a3, LispObject a4up);
extern LispObject Lerrorset_4up(LispObject env, LispObject a1,
                                LispObject a2,
                                LispObject a3, LispObject a4up);
extern LispObject Lfuncall_4up(LispObject env, LispObject a1,
                               LispObject a2,
                               LispObject a3, LispObject a4up);
extern LispObject Llist_4up(LispObject env, LispObject a1,
                            LispObject a2,
                            LispObject a3, LispObject a4up);
extern LispObject Lliststar_4up(LispObject env, LispObject a1,
                                LispObject a2,
                                LispObject a3, LispObject a4up);
extern LispObject Llogand_4up(LispObject env, LispObject a1,
                              LispObject a2,
                              LispObject a3, LispObject a4up);
extern LispObject Llogeqv_4up(LispObject env, LispObject a1,
                              LispObject a2,
                              LispObject a3, LispObject a4up);
extern LispObject Llogor_4up(LispObject env, LispObject a1,
                             LispObject a2,
                             LispObject a3, LispObject a4up);
extern LispObject Llogxor_4up(LispObject env, LispObject a1,
                              LispObject a2,
                              LispObject a3, LispObject a4up);
extern LispObject Lmax_4up(LispObject env, LispObject a1,
                           LispObject a2,
                           LispObject a3, LispObject a4up);
extern LispObject Lmin_4up(LispObject env, LispObject a1,
                           LispObject a2,
                           LispObject a3, LispObject a4up);
extern LispObject Lresource_limit_4up(LispObject env, LispObject a1,
                                      LispObject a2,
                                      LispObject a3, LispObject a4up);
extern LispObject Lvalues_4up(LispObject env, LispObject a1,
                              LispObject a2,
                              LispObject a3, LispObject a4up);
extern LispObject Lappend_4up(LispObject env, LispObject a1,
                              LispObject a2,
                              LispObject a3, LispObject a4up);
extern LispObject Laref_4up(LispObject env, LispObject a1,
                            LispObject a2,
                            LispObject a3, LispObject a4up);
extern LispObject Laset_4up(LispObject env, LispObject a1,
                            LispObject a2,
                            LispObject a3, LispObject a4up);
extern LispObject Leqn_4up(LispObject env, LispObject a1,
                           LispObject a2,
                           LispObject a3, LispObject a4up);
extern LispObject Lgcd_4up(LispObject env, LispObject a1,
                           LispObject a2,
                           LispObject a3, LispObject a4up);
extern LispObject Lgeq_4up(LispObject env, LispObject a1,
                           LispObject a2,
                           LispObject a3, LispObject a4up);
extern LispObject Lgreaterp_4up(LispObject env, LispObject a1,
                                LispObject a2,
                                LispObject a3, LispObject a4up);
extern LispObject Llcm_4up(LispObject env, LispObject a1,
                           LispObject a2,
                           LispObject a3, LispObject a4up);
extern LispObject Lleq_4up(LispObject env, LispObject a1,
                           LispObject a2,
                           LispObject a3, LispObject a4up);
extern LispObject Llessp_4up(LispObject env, LispObject a1,
                             LispObject a2,
                             LispObject a3, LispObject a4up);
extern LispObject Lquotient_4up(LispObject env, LispObject a1,
                                LispObject a2,
                                LispObject a3, LispObject a4up);

#ifdef OPENMATH
extern LispObject om_openFileDev(LispObject env, LispObject a1,
                                 LispObject a2,
                                 LispObject a3, LispObject a4up);
extern LispObject om_openStringDev(LispObject env, LispObject lstr,
                                   LispObject lenc);
extern LispObject om_closeDev(LispObject env, LispObject dev);
extern LispObject om_setDevEncoding(LispObject env, LispObject ldev,
                                    LispObject lenc);
extern LispObject om_makeConn(LispObject env, LispObject ltimeout);
extern LispObject om_closeConn(LispObject env, LispObject lconn);
extern LispObject om_getConnInDevice(LispObject env,
                                     LispObject lconn);
extern LispObject om_getConnOutDevice(LispObject env,
                                      LispObject lconn);
extern LispObject om_connectTCP(LispObject env, LispObject a1,
                                LispObject a2,
                                LispObject a3, LispObject a4up);
extern LispObject om_bindTCP(LispObject env, LispObject lconn,
                             LispObject lport);
extern LispObject om_putApp(LispObject env, LispObject ldev);
extern LispObject om_putEndApp(LispObject env, LispObject ldev);
extern LispObject om_putAtp(LispObject env, LispObject ldev);
extern LispObject om_putEndAtp(LispObject env, LispObject ldev);
extern LispObject om_putAttr(LispObject env, LispObject ldev);
extern LispObject om_putEndAttr(LispObject env, LispObject ldev);
extern LispObject om_putBind(LispObject env, LispObject ldev);
extern LispObject om_putEndBind(LispObject env, LispObject ldev);
extern LispObject om_putBVar(LispObject env, LispObject ldev);
extern LispObject om_putEndBVar(LispObject env, LispObject ldev);
extern LispObject om_putError(LispObject env, LispObject ldev);
extern LispObject om_putEndError(LispObject env, LispObject ldev);
extern LispObject om_putObject(LispObject env, LispObject ldev);
extern LispObject om_putEndObject(LispObject env, LispObject ldev);
extern LispObject om_putInt(LispObject env, LispObject ldev,
                            LispObject val);
extern LispObject om_putFloat(LispObject env, LispObject ldev,
                              LispObject val);
extern LispObject om_putByteArray(LispObject env, LispObject ldev,
                                  LispObject val);
extern LispObject om_putVar(LispObject env, LispObject ldev,
                            LispObject val);
extern LispObject om_putString(LispObject env, LispObject ldev,
                               LispObject val);
extern LispObject om_putSymbol(LispObject env, LispObject ldev,
                               LispObject val);
extern LispObject om_putSymbol2(LispObject env, LispObject a1,
                                LispObject a2,
                                LispObject a3, LispObject a4up);
extern LispObject om_getApp(LispObject env, LispObject ldev);
extern LispObject om_getEndApp(LispObject env, LispObject ldev);
extern LispObject om_getAtp(LispObject env, LispObject ldev);
extern LispObject om_getEndAtp(LispObject env, LispObject ldev);
extern LispObject om_getAttr(LispObject env, LispObject ldev);
extern LispObject om_getEndAttr(LispObject env, LispObject ldev);
extern LispObject om_getBind(LispObject env, LispObject ldev);
extern LispObject om_getEndBind(LispObject env, LispObject ldev);
extern LispObject om_getBVar(LispObject env, LispObject ldev);
extern LispObject om_getEndBVar(LispObject env, LispObject ldev);
extern LispObject om_getError(LispObject env, LispObject ldev);
extern LispObject om_getEndError(LispObject env, LispObject ldev);
extern LispObject om_getObject(LispObject env, LispObject ldev);
extern LispObject om_getEndObject(LispObject env, LispObject ldev);
extern LispObject om_getInt(LispObject env, LispObject ldev);
extern LispObject om_getFloat(LispObject env, LispObject ldev);
extern LispObject om_getByteArray(LispObject env, LispObject ldev);
extern LispObject om_getVar(LispObject env, LispObject ldev);
extern LispObject om_getString(LispObject env, LispObject ldev);
extern LispObject om_getSymbol(LispObject env, LispObject ldev);
extern LispObject om_getType(LispObject env, LispObject ldev);

extern LispObject om_stringToStringPtr(LispObject env,
                                       LispObject lstr);
extern LispObject om_stringPtrToString(LispObject env,
                                       LispObject lpstr);

extern LispObject om_read(LispObject env, LispObject dev);
extern LispObject om_supportsCD(LispObject env, LispObject lcd);
extern LispObject om_supportsSymbol(LispObject env, LispObject lcd,
                                    LispObject lsym);
extern LispObject om_listCDs(LispObject env, LispObject a1,
                             LispObject a2,
                             LispObject a3, LispObject a4up);
extern LispObject om_listSymbols(LispObject env, LispObject lcd);
extern LispObject om_whichCDs(LispObject env, LispObject lsym);
#endif
extern LispObject undefined_4up(LispObject env,
                                LispObject a1, LispObject a2, LispObject a3, LispObject a4);

#endif // header_entries_h

// end of entries.h
