(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    250245,       6747]
NotebookOptionsPosition[    223882,       6130]
NotebookOutlinePosition[    224809,       6164]
CellTagsIndexPosition[    224766,       6161]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Special Function Integration Problem 1", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, {3.4821973084456434`*^9, 3.482197309066536*^9}, {
   3.4821982364300194`*^9, 3.482198240976557*^9}, 3.482198357524144*^9, {
   3.4821988021534896`*^9, 3.4821988078316545`*^9}, 3.4821989164378223`*^9, {
   3.482198948964594*^9, 3.4821990020909853`*^9}, 3.4821998658029423`*^9, 
   3.4827166857758894`*^9, {3.4833956514635315`*^9, 3.483395657392056*^9}, {
   3.4899677342970285`*^9, 3.48996773529543*^9}},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"n", ",", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
   3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
   3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.482199478365835*^9, {
   3.4827167285874496`*^9, 3.48271673125128*^9}, {3.489982719504161*^9, 
   3.48998274710061*^9}, 3.4903834581737995`*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " uses reduction rules to integrate all the expressions:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, 3.4899789370019164`*^9, {
   3.4899837231007237`*^9, 3.4899837293407345`*^9}, 3.489983804220866*^9, {
   3.4899838344069195`*^9, 3.489983854281354*^9}, {3.489983888414214*^9, 
   3.4899838889446154`*^9}}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{"Gamma", "[", 
    RowBox[{"n", ",", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]}], "]"}], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4827167569782734`*^9, 3.4899789370019164`*^9, 3.4899827783006644`*^9, 
   3.489983804220866*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"n", ",", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]}], "]"}]}], "b"], "-", 
  FractionBox[
   RowBox[{"Gamma", "[", 
    RowBox[{
     RowBox[{"1", "+", "n"}], ",", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]}], "]"}], "b"]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{3.489983066542371*^9, 3.489983804220866*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"n", ",", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]}], "]"}]}], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4827167569782734`*^9, 3.482716878312744*^9, 3.4899789370019164`*^9, {
   3.4899830788039923`*^9, 3.489983110986849*^9}, 3.489983804220866*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      SuperscriptBox["a", "2"], 
      SuperscriptBox["b", "2"]], "-", 
     SuperscriptBox["x", "2"]}], ")"}], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"n", ",", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]}], "]"}]}], "+", 
  FractionBox[
   RowBox[{"a", " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{
      RowBox[{"1", "+", "n"}], ",", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]}], "]"}]}], 
   SuperscriptBox["b", "2"]], "-", 
  FractionBox[
   RowBox[{"Gamma", "[", 
    RowBox[{
     RowBox[{"2", "+", "n"}], ",", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]}], "]"}], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "2"]}]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4899830828287992`*^9, 3.4899831012368317`*^9}, 
   3.489983804220866*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"n", ",", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]}], "]"}]}], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4827167569782734`*^9, 3.482716897039672*^9, 3.4899789370019164`*^9, {
   3.4899830804887953`*^9, 3.489983114106854*^9}, 3.489983804220866*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      SuperscriptBox["a", "3"], 
      SuperscriptBox["b", "3"]], "+", 
     SuperscriptBox["x", "3"]}], ")"}], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"n", ",", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]}], "]"}]}], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{
      RowBox[{"1", "+", "n"}], ",", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]}], "]"}]}], 
   SuperscriptBox["b", "3"]], "+", 
  FractionBox[
   RowBox[{"a", " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{
      RowBox[{"2", "+", "n"}], ",", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]}], "]"}]}], 
   SuperscriptBox["b", "3"]], "-", 
  FractionBox[
   RowBox[{"Gamma", "[", 
    RowBox[{
     RowBox[{"3", "+", "n"}], ",", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]}], "]"}], 
   RowBox[{"3", " ", 
    SuperscriptBox["b", "3"]}]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4899830874776077`*^9, 3.4899831069308414`*^9}, 
   3.489983804220866*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is able to integrate all the expressions:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, 3.4899789370019164`*^9, 
   3.4899832051798143`*^9, {3.4899837404011545`*^9, 3.489983765470398*^9}, 
   3.489983809259675*^9, {3.4899838840306063`*^9, 3.489983884951008*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Gamma", "[", 
    RowBox[{"n", ",", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4827169692935677`*^9, 3.4899789503711395`*^9, {3.489983135712892*^9, 
   3.4899831518433204`*^9}, {3.489983323537222*^9, 3.4899833674356995`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"a", " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"n", ",", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]}], "]"}]}], "b"], "+", 
  RowBox[{"x", " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"n", ",", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]}], "]"}]}], "-", 
  FractionBox[
   RowBox[{"Gamma", "[", 
    RowBox[{
     RowBox[{"1", "+", "n"}], ",", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]}], "]"}], "b"]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4899831367892942`*^9, 3.4899831467109118`*^9}, {
   3.4899833257056255`*^9, 3.4899833687773013`*^9}, 3.489983809259675*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"x", " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"n", ",", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4827169692935677`*^9, 3.482717024252595*^9, 3.4899789503711395`*^9, 
   3.4899831650877438`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"n", ",", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]}], "]"}]}], "+", 
   RowBox[{"2", " ", "a", " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{
      RowBox[{"1", "+", "n"}], ",", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]}], "]"}]}], "-", 
   RowBox[{"Gamma", "[", 
    RowBox[{
     RowBox[{"2", "+", "n"}], ",", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]}], "]"}]}], 
  RowBox[{"2", " ", 
   SuperscriptBox["b", "2"]}]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.48998316861335*^9, 3.489983809259675*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"n", ",", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4827169692935677`*^9, 3.4827170428293076`*^9, 3.4899789503711395`*^9, 
   3.489983166944147*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"3", " ", 
    SuperscriptBox["b", "3"]}]], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "3"], "+", 
       RowBox[{
        SuperscriptBox["b", "3"], " ", 
        SuperscriptBox["x", "3"]}]}], ")"}], " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{"n", ",", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]}], "]"}]}], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{
       RowBox[{"1", "+", "n"}], ",", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]}], "]"}]}], "+", 
    RowBox[{"3", " ", "a", " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{
       RowBox[{"2", "+", "n"}], ",", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]}], "]"}]}], "-", 
    RowBox[{"Gamma", "[", 
     RowBox[{
      RowBox[{"3", "+", "n"}], ",", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]}], "]"}]}], ")"}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.4899831842757773`*^9, 3.489983809259675*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " is unable to integrate any of the expressions:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, 3.4899789370019164`*^9, 
   3.4899832051798143`*^9, {3.4899837404011545`*^9, 3.4899838137836833`*^9}, {
   3.4899838739997888`*^9, 3.4899838763709927`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"GAMMA", 
      RowBox[{"(", 
       RowBox[{"n", ",", " ", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}]}], ")"}]}], ",", " ", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{
  3.444350078924618*^9, {3.446688034289928*^9, 3.4466880406490717`*^9}, {
   3.4468671345411663`*^9, 3.423171765484375*^9}, {3.48271708175528*^9, 
   3.482717099210379*^9}, {3.482717150333891*^9, 3.4827171689206176`*^9}, 
   3.4899789616499596`*^9, {3.4899833888857365`*^9, 3.489983398744954*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Gamma", "[", 
    RowBox[{"n", ",", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{3.4899838137836833`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"x", "*", "GAMMA", 
      RowBox[{"(", 
       RowBox[{"n", ",", " ", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}]}], ")"}]}], ",", " ", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{
  3.444350078924618*^9, {3.446688034289928*^9, 3.4466880406490717`*^9}, {
   3.4468671345411663`*^9, 3.423171765484375*^9}, {3.48271708175528*^9, 
   3.482717099210379*^9}, {3.482717150333891*^9, 3.4827171689206176`*^9}, 
   3.4899789616499596`*^9, {3.4899833888857365`*^9, 3.489983398744954*^9}, {
   3.4899835472728148`*^9, 3.4899835515628223`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"x", " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"n", ",", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{3.4899838137836833`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "*", "GAMMA", 
      RowBox[{"(", 
       RowBox[{"n", ",", " ", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}]}], ")"}]}], ",", " ", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{
  3.444350078924618*^9, {3.446688034289928*^9, 3.4466880406490717`*^9}, {
   3.4468671345411663`*^9, 3.423171765484375*^9}, {3.48271708175528*^9, 
   3.482717099210379*^9}, {3.482717150333891*^9, 3.4827171689206176`*^9}, 
   3.4899789616499596`*^9, {3.4899833888857365`*^9, 3.489983398744954*^9}, {
   3.4899835472728148`*^9, 3.489983563387643*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"n", ",", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{3.4899838137836833`*^9}]
}, Closed]],

Cell["", "PageBreak",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 PageBreakBelow->True,
 CellChangeTimes->{3.4561670329935665`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Special Function Integration Problem 2", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, {3.4821973084456434`*^9, 3.482197309066536*^9}, {
   3.4821982364300194`*^9, 3.482198240976557*^9}, 3.482198357524144*^9, {
   3.4821988021534896`*^9, 3.4821988078316545`*^9}, 3.4821989164378223`*^9, {
   3.482198948964594*^9, 3.4821990020909853`*^9}, 3.4821998658029423`*^9, 
   3.4827166857758894`*^9, {3.4833956514635315`*^9, 3.483395657392056*^9}, {
   3.4899677342970285`*^9, 3.48996773529543*^9}, 3.4899826929997144`*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   RowBox[{"PolyLog", "[", 
    RowBox[{"n", ",", 
     RowBox[{"c", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
   3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
   3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.482199478365835*^9, {
   3.4827167285874496`*^9, 3.48271673125128*^9}, 3.490383459283801*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " uses integration by parts to reduce the degree of ",
 Cell[BoxData[
  StyleBox[
   SuperscriptBox["x", "m"],
   FontWeight->"Bold"]]],
 ":"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, 3.4899789370019164`*^9, 
   3.489982999571453*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{"PolyLog", "[", 
    RowBox[{"n", ",", 
     RowBox[{"c", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]]}]}], "]"}], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4827167569782734`*^9, 3.4899789370019164`*^9, {3.489982816380331*^9, 
   3.489982818049534*^9}, 3.489982999571453*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{"PolyLog", "[", 
   RowBox[{
    RowBox[{"1", "+", "n"}], ",", 
    RowBox[{"c", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]]}]}], "]"}], "b"]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{3.4899828193755364`*^9, 3.489982999571453*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"n", ",", 
      RowBox[{"c", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}]]}]}], "]"}]}], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4827167569782734`*^9, 3.482716878312744*^9, 3.4899789370019164`*^9, 
   3.489982999571453*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"x", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{
      RowBox[{"1", "+", "n"}], ",", 
      RowBox[{"c", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}]]}]}], "]"}]}], "b"], "-", 
  FractionBox[
   RowBox[{"PolyLog", "[", 
    RowBox[{
     RowBox[{"2", "+", "n"}], ",", 
     RowBox[{"c", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]]}]}], "]"}], 
   SuperscriptBox["b", "2"]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{3.4899828269259496`*^9, 3.489982999571453*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"n", ",", 
      RowBox[{"c", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}]]}]}], "]"}]}], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4827167569782734`*^9, 3.482716897039672*^9, 3.4899789370019164`*^9, 
   3.489982999571453*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{
      RowBox[{"1", "+", "n"}], ",", 
      RowBox[{"c", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}]]}]}], "]"}]}], "b"], "-", 
  FractionBox[
   RowBox[{"2", " ", "x", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{
      RowBox[{"2", "+", "n"}], ",", 
      RowBox[{"c", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}]]}]}], "]"}]}], 
   SuperscriptBox["b", "2"]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{
      RowBox[{"3", "+", "n"}], ",", 
      RowBox[{"c", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}]]}]}], "]"}]}], 
   SuperscriptBox["b", "3"]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{3.4899828312783575`*^9, 3.489982999571453*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does not know to use integration by parts:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500256179667`*^9}, {3.4466836176090527`*^9, 3.446683618790752*^9}, {
   3.4466878172878942`*^9, 3.4466878232364483`*^9}, {3.4466929005572767`*^9, 
   3.4466929190839167`*^9}, {3.446693492157957*^9, 3.4466935036945457`*^9}, {
   3.446694017403222*^9, 3.446694027738083*^9}, {3.446867089436309*^9, 
   3.423171765484375*^9}, {3.4553247161354513`*^9, 3.455324770022938*^9}, 
   3.4821993034543247`*^9, {3.482716933221699*^9, 3.482716957606763*^9}, {
   3.4827169893724403`*^9, 3.482716990974744*^9}, 3.4899789503711395`*^9, 
   3.489983020069889*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"PolyLog", "[", 
    RowBox[{"n", ",", 
     RowBox[{"c", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4827169692935677`*^9, 3.4899789503711395`*^9, 3.489983020069889*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{"PolyLog", "[", 
   RowBox[{
    RowBox[{"1", "+", "n"}], ",", 
    RowBox[{"c", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]]}]}], "]"}], "b"]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{3.4899828363639665`*^9, 3.489983020069889*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"x", " ", 
   RowBox[{"PolyLog", "[", 
    RowBox[{"n", ",", 
     RowBox[{"c", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4827169692935677`*^9, 3.482717024252595*^9, 3.4899789503711395`*^9, 
   3.489983020069889*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"n", ",", 
      RowBox[{"c", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}]]}]}], "]"}]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{3.4899828402327733`*^9, 3.489983020069889*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   RowBox[{"PolyLog", "[", 
    RowBox[{"n", ",", 
     RowBox[{"c", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4827169692935677`*^9, 3.4827170428293076`*^9, 3.4899789503711395`*^9, 
   3.489983020069889*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"n", ",", 
      RowBox[{"c", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}]]}]}], "]"}]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{3.489982843181178*^9, 3.489983020069889*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " does not know to use integration by parts:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500407697535`*^9}, {3.444350203233365*^9, 3.4443502040245028`*^9}, {
   3.444350234528365*^9, 3.4443502387243986`*^9}, {3.4466836227764835`*^9, 
   3.4466836230168285`*^9}, {3.4466839811618156`*^9, 3.4466839896239843`*^9}, 
   3.4466940377124257`*^9, {3.446694106040677*^9, 3.446694127681795*^9}, {
   3.446867106891408*^9, 3.423010833140625*^9}, 3.423171765484375*^9, {
   3.4553247918943872`*^9, 3.4553247949287505`*^9}, 3.4821993237434993`*^9, 
   3.482717127090469*^9, 3.4899789616499596`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"polylog", 
      RowBox[{"(", 
       RowBox[{"n", ",", " ", 
        RowBox[{"c", "*", "exp", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}]}]}], ")"}]}], ",", " ", "x"}], 
    ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{
  3.444350078924618*^9, {3.446688034289928*^9, 3.4466880406490717`*^9}, {
   3.4468671345411663`*^9, 3.423171765484375*^9}, {3.48271708175528*^9, 
   3.482717099210379*^9}, {3.482717150333891*^9, 3.4827171689206176`*^9}, 
   3.4899789616499596`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"PolyLog", "[", 
    RowBox[{"n", ",", 
     RowBox[{"c", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{3.4899830299447064`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"polylog", 
      RowBox[{"(", 
       RowBox[{"n", ",", " ", 
        RowBox[{"exp", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}]}]}], ")"}]}], ",", " ", "x"}], 
    ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{
  3.444350078924618*^9, {3.446688034289928*^9, 3.4466880406490717`*^9}, {
   3.4468671345411663`*^9, 3.423171765484375*^9}, {3.48271708175528*^9, 
   3.482717099210379*^9}, {3.482717150333891*^9, 3.4827171689206176`*^9}, {
   3.4827178589027634`*^9, 3.4827178591330943`*^9}, 3.4899789616499596`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{"PolyLog", "[", 
   RowBox[{
    RowBox[{"n", "+", "1"}], ",", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]]}], "]"}], "b"]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{3.4899830299447064`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"x", "*", "polylog", 
      RowBox[{"(", 
       RowBox[{"n", ",", " ", 
        RowBox[{"exp", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}]}]}], ")"}]}], ",", " ", "x"}], 
    ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{
  3.444350078924618*^9, {3.446688034289928*^9, 3.4466880406490717`*^9}, {
   3.4468671345411663`*^9, 3.423171765484375*^9}, {3.48271708175528*^9, 
   3.482717099210379*^9}, {3.482717150333891*^9, 3.4827171689206176`*^9}, {
   3.482717820527582*^9, 3.482717820898115*^9}, {3.4827180417757215`*^9, 
   3.482718041986024*^9}, 3.4899789616499596`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"x", " ", 
   RowBox[{"PolyLog", "[", 
    RowBox[{"n", ",", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{3.4899830299447064`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "*", "polylog", 
      RowBox[{"(", 
       RowBox[{"n", ",", " ", 
        RowBox[{"exp", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}]}]}], ")"}]}], ",", " ", "x"}], 
    ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{
  3.444350078924618*^9, {3.446688034289928*^9, 3.4466880406490717`*^9}, {
   3.4468671345411663`*^9, 3.423171765484375*^9}, {3.48271708175528*^9, 
   3.482717099210379*^9}, {3.482717150333891*^9, 3.4827171689206176`*^9}, {
   3.482717820527582*^9, 3.482717829951133*^9}, {3.482718044579754*^9, 
   3.4827180447600126`*^9}, 3.4899789616499596`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   RowBox[{"PolyLog", "[", 
    RowBox[{"n", ",", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{3.4899830299447064`*^9}]
}, Closed]],

Cell["", "PageBreak",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 PageBreakBelow->True,
 CellChangeTimes->{3.4561670329935665`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Special Function Integration Problem 3", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, {3.4821973084456434`*^9, 3.482197309066536*^9}, {
   3.4821982364300194`*^9, 3.482198240976557*^9}, 3.482198357524144*^9, {
   3.4821988021534896`*^9, 3.4821988078316545`*^9}, 3.4821989164378223`*^9, {
   3.482198948964594*^9, 3.4821990020909853`*^9}, 3.4821998658029423`*^9, 
   3.4833956795138655`*^9, 3.4899677397414384`*^9, 3.4899826952305183`*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"Log", "[", "x", "]"}], "m"], 
     RowBox[{"PolyLog", "[", 
      RowBox[{"n", ",", 
       RowBox[{"a", " ", "x"}]}], "]"}]}], "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
   3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
   3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.482199478365835*^9, {
   3.489977440080487*^9, 3.4899774898757744`*^9}, 3.4903834605938025`*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " uses integration by parts to reduce the degree of ",
 Cell[BoxData[
  StyleBox[
   SuperscriptBox[
    RowBox[{"Log", "[", "x", "]"}], "m"],
   FontWeight->"Bold"]]],
 ":"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, 3.4899776107915864`*^9, 
   3.4899791261678486`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"Log", "[", "x", "]"}], " ", 
     RowBox[{"PolyLog", "[", 
      RowBox[{"n", ",", 
       RowBox[{"a", " ", "x"}]}], "]"}]}], "x"], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4899791261678486`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Log", "[", "x", "]"}], " ", 
   RowBox[{"PolyLog", "[", 
    RowBox[{
     RowBox[{"1", "+", "n"}], ",", 
     RowBox[{"a", " ", "x"}]}], "]"}]}], "-", 
  RowBox[{"PolyLog", "[", 
   RowBox[{
    RowBox[{"2", "+", "n"}], ",", 
    RowBox[{"a", " ", "x"}]}], "]"}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{
  3.4466934108410287`*^9, {3.4468670553372765`*^9, 3.423171765484375*^9}, 
   3.4899791261678486`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"Log", "[", "x", "]"}], "2"], " ", 
     RowBox[{"PolyLog", "[", 
      RowBox[{"n", ",", 
       RowBox[{"a", " ", "x"}]}], "]"}]}], "x"], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, {
   3.4899776609300747`*^9, 3.4899776711012926`*^9}, 3.4899791261678486`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox[
    RowBox[{"Log", "[", "x", "]"}], "2"], " ", 
   RowBox[{"PolyLog", "[", 
    RowBox[{
     RowBox[{"1", "+", "n"}], ",", 
     RowBox[{"a", " ", "x"}]}], "]"}]}], "-", 
  RowBox[{"2", " ", 
   RowBox[{"Log", "[", "x", "]"}], " ", 
   RowBox[{"PolyLog", "[", 
    RowBox[{
     RowBox[{"2", "+", "n"}], ",", 
     RowBox[{"a", " ", "x"}]}], "]"}]}], "+", 
  RowBox[{"2", " ", 
   RowBox[{"PolyLog", "[", 
    RowBox[{
     RowBox[{"3", "+", "n"}], ",", 
     RowBox[{"a", " ", "x"}]}], "]"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.489977677559704*^9, 3.489977685562518*^9}, 
   3.4899791261678486`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"Log", "[", "x", "]"}], "3"], " ", 
     RowBox[{"PolyLog", "[", 
      RowBox[{"n", ",", 
       RowBox[{"a", " ", "x"}]}], "]"}]}], "x"], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, {
   3.4899776609300747`*^9, 3.489977694111333*^9}, 3.4899791261678486`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox[
    RowBox[{"Log", "[", "x", "]"}], "3"], " ", 
   RowBox[{"PolyLog", "[", 
    RowBox[{
     RowBox[{"1", "+", "n"}], ",", 
     RowBox[{"a", " ", "x"}]}], "]"}]}], "-", 
  RowBox[{"3", " ", 
   SuperscriptBox[
    RowBox[{"Log", "[", "x", "]"}], "2"], " ", 
   RowBox[{"PolyLog", "[", 
    RowBox[{
     RowBox[{"2", "+", "n"}], ",", 
     RowBox[{"a", " ", "x"}]}], "]"}]}], "+", 
  RowBox[{"6", " ", 
   RowBox[{"Log", "[", "x", "]"}], " ", 
   RowBox[{"PolyLog", "[", 
    RowBox[{
     RowBox[{"3", "+", "n"}], ",", 
     RowBox[{"a", " ", "x"}]}], "]"}]}], "-", 
  RowBox[{"6", " ", 
   RowBox[{"PolyLog", "[", 
    RowBox[{
     RowBox[{"4", "+", "n"}], ",", 
     RowBox[{"a", " ", "x"}]}], "]"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{3.489977695000534*^9, 3.4899791261678486`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does not know to use integration by parts:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500256179667`*^9}, {3.4466836176090527`*^9, 3.446683618790752*^9}, {
   3.4466878172878942`*^9, 3.4466878232364483`*^9}, {3.4466929005572767`*^9, 
   3.4466929190839167`*^9}, {3.446693492157957*^9, 3.4466935036945457`*^9}, {
   3.446694017403222*^9, 3.446694027738083*^9}, {3.446867089436309*^9, 
   3.423171765484375*^9}, {3.4553247161354513`*^9, 3.455324770022938*^9}, 
   3.4821993034543247`*^9, {3.482716933221699*^9, 3.482716957606763*^9}, {
   3.4827169893724403`*^9, 3.482716990974744*^9}, 3.489979135356265*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"Log", "[", "x", "]"}], " ", 
     RowBox[{"PolyLog", "[", 
      RowBox[{"n", ",", 
       RowBox[{"a", " ", "x"}]}], "]"}]}], "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.489979135356265*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"Log", "[", "x", "]"}], " ", 
     RowBox[{"PolyLog", "[", 
      RowBox[{"n", ",", 
       RowBox[{"a", " ", "x"}]}], "]"}]}], "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.446693458840048*^9, 3.446693479820216*^9}, {
   3.446867077228755*^9, 3.423171765484375*^9}, 3.489979135356265*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"Log", "[", "x", "]"}], "2"], " ", 
     RowBox[{"PolyLog", "[", 
      RowBox[{"n", ",", 
       RowBox[{"a", " ", "x"}]}], "]"}]}], "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, {
   3.4899777184785757`*^9, 3.489977731785399*^9}, 3.489979135356265*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"Log", "[", "x", "]"}], "2"], " ", 
     RowBox[{"PolyLog", "[", 
      RowBox[{"n", ",", 
       RowBox[{"a", " ", "x"}]}], "]"}]}], "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.4899777358726063`*^9, 3.489979135356265*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"Log", "[", "x", "]"}], "3"], " ", 
     RowBox[{"PolyLog", "[", 
      RowBox[{"n", ",", 
       RowBox[{"a", " ", "x"}]}], "]"}]}], "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, {
   3.4899777184785757`*^9, 3.4899777417070165`*^9}, 3.489979135356265*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"Log", "[", "x", "]"}], "3"], " ", 
     RowBox[{"PolyLog", "[", 
      RowBox[{"n", ",", 
       RowBox[{"a", " ", "x"}]}], "]"}]}], "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.4899777429082184`*^9, 3.489979135356265*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " does not know to use integration by parts:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500407697535`*^9}, {3.444350203233365*^9, 3.4443502040245028`*^9}, {
   3.444350234528365*^9, 3.4443502387243986`*^9}, {3.4466836227764835`*^9, 
   3.4466836230168285`*^9}, {3.4466839811618156`*^9, 3.4466839896239843`*^9}, 
   3.4466940377124257`*^9, {3.446694106040677*^9, 3.446694127681795*^9}, {
   3.446867106891408*^9, 3.423010833140625*^9}, 3.423171765484375*^9, {
   3.4553247918943872`*^9, 3.4553247949287505`*^9}, 3.4821993237434993`*^9, 
   3.482717127090469*^9, 3.4899791422670765`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"log", 
      RowBox[{"(", "x", ")"}], "*", "polylog", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", ",", 
         RowBox[{"a", "*", "x"}]}], ")"}], "/", "x"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{
  3.444350078924618*^9, {3.446688034289928*^9, 3.4466880406490717`*^9}, {
   3.4468671345411663`*^9, 3.423171765484375*^9}, 3.4899791422670765`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"Log", "[", "x", "]"}], " ", 
     RowBox[{"PolyLog", "[", 
      RowBox[{"n", ",", 
       RowBox[{"a", " ", "x"}]}], "]"}]}], "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.446693458840048*^9, 3.446693479820216*^9}, {
   3.446867077228755*^9, 3.423171765484375*^9}, 3.4899791422670765`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"log", 
      RowBox[{
       RowBox[{"(", "x", ")"}], "^", "2"}], "*", "polylog", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", ",", 
         RowBox[{"a", "*", "x"}]}], ")"}], "/", "x"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{
  3.444350078924618*^9, {3.446688034289928*^9, 3.4466880406490717`*^9}, {
   3.4468671345411663`*^9, 3.423171765484375*^9}, {3.4899778018451223`*^9, 
   3.4899778059011292`*^9}, 3.4899791422670765`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"Log", "[", "x", "]"}], "2"], " ", 
     RowBox[{"PolyLog", "[", 
      RowBox[{"n", ",", 
       RowBox[{"a", " ", "x"}]}], "]"}]}], "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{3.4899777358726063`*^9, 3.4899791422670765`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"log", 
      RowBox[{
       RowBox[{"(", "x", ")"}], "^", "3"}], "*", "polylog", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", ",", 
         RowBox[{"a", "*", "x"}]}], ")"}], "/", "x"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{
  3.444350078924618*^9, {3.446688034289928*^9, 3.4466880406490717`*^9}, {
   3.4468671345411663`*^9, 3.423171765484375*^9}, {3.4899778018451223`*^9, 
   3.489977816212747*^9}, 3.4899791422670765`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"Log", "[", "x", "]"}], "3"], " ", 
     RowBox[{"PolyLog", "[", 
      RowBox[{"n", ",", 
       RowBox[{"a", " ", "x"}]}], "]"}]}], "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{3.4899777429082184`*^9, 3.4899791422670765`*^9}]
}, Closed]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Special Function Integration Problem 4", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, {3.4821973084456434`*^9, 3.482197309066536*^9}, {
   3.4821982364300194`*^9, 3.482198240976557*^9}, 3.482198357524144*^9, {
   3.4821988021534896`*^9, 3.4821988078316545`*^9}, 3.4821989164378223`*^9, {
   3.482198948964594*^9, 3.4821990020909853`*^9}, 3.4821998658029423`*^9, 
   3.4827166857758894`*^9, 3.4827184653748274`*^9, {3.4832022784710383`*^9, 
   3.483202289366706*^9}, 3.4833933837627373`*^9, {3.4899677420190425`*^9, 
   3.4899677661990848`*^9}, 3.489982697788923*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   RowBox[{"ProductLog", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
   3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
   3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.482199478365835*^9, {
   3.4827167285874496`*^9, 3.48271673125128*^9}, {3.482718509007568*^9, 
   3.4827185116513696`*^9}, 3.4903834623438053`*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " uses integration by parts to reduce the degree of ",
 Cell[BoxData[
  StyleBox[
   SuperscriptBox["x", "m"],
   FontWeight->"Bold"]]],
 ":"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, 3.489979260094084*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{"ProductLog", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4827167569782734`*^9, 3.4827185240692253`*^9, 3.489979260094084*^9, {
   3.4899806712805634`*^9, 3.4899806875013914`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "x"}], "+", 
  FractionBox[
   RowBox[{"a", "+", 
    RowBox[{"b", " ", "x"}]}], 
   RowBox[{"b", " ", 
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], " ", 
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}], "b"]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{3.4827186279686255`*^9, 3.489979260094084*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4827167569782734`*^9, 3.482716878312744*^9, 3.4827186160014176`*^9, 
   3.489979260094084*^9, {3.4899806728093653`*^9, 3.4899806909957976`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}]}], 
   SuperscriptBox["b", "2"]], "-", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], "2"], 
   RowBox[{"4", " ", 
    SuperscriptBox["b", "2"]}]], "-", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], "2"], 
   RowBox[{"8", " ", 
    SuperscriptBox["b", "2"], " ", 
    SuperscriptBox[
     RowBox[{"ProductLog", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}]], "-", 
  FractionBox[
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}]}], 
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}]], "+", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], "2"], 
   RowBox[{"4", " ", 
    SuperscriptBox["b", "2"], " ", 
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}]], "-", 
  FractionBox[
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], " ", 
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}], 
   SuperscriptBox["b", "2"]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "2"], " ", 
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "2"]}]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{3.4833051440413585`*^9, 3.489979260094084*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4827167569782734`*^9, 3.482716897039672*^9, 3.482718663710019*^9, {
   3.483305193402336*^9, 3.48330519425356*^9}, {3.4833053848576355`*^9, 
   3.483305385738902*^9}, 3.489979260094084*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}]}], 
    SuperscriptBox["b", "3"]]}], "+", 
  FractionBox[
   RowBox[{"a", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "2"]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "3"]}]], "-", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], "3"], 
   RowBox[{"9", " ", 
    SuperscriptBox["b", "3"]}]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "3"]}], 
   RowBox[{"81", " ", 
    SuperscriptBox["b", "3"], " ", 
    SuperscriptBox[
     RowBox[{"ProductLog", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "3"]}]], "+", 
  FractionBox[
   RowBox[{"a", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "2"]}], 
   RowBox[{"4", " ", 
    SuperscriptBox["b", "3"], " ", 
    SuperscriptBox[
     RowBox[{"ProductLog", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "3"]}], 
   RowBox[{"27", " ", 
    SuperscriptBox["b", "3"], " ", 
    SuperscriptBox[
     RowBox[{"ProductLog", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}]}], 
   RowBox[{
    SuperscriptBox["b", "3"], " ", 
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}]], "-", 
  FractionBox[
   RowBox[{"a", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "2"]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "3"], " ", 
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}]], "+", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], "3"], 
   RowBox[{"9", " ", 
    SuperscriptBox["b", "3"], " ", 
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], " ", 
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}], 
   SuperscriptBox["b", "3"]], "-", 
  FractionBox[
   RowBox[{"a", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "2"], " ", 
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}], 
   SuperscriptBox["b", "3"]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "3"], " ", 
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}], 
   RowBox[{"3", " ", 
    SuperscriptBox["b", "3"]}]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{3.482718377899043*^9, 3.483305199160616*^9, 
  3.489979260094084*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does not know to use integration by parts:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500256179667`*^9}, {3.4466836176090527`*^9, 3.446683618790752*^9}, {
   3.4466878172878942`*^9, 3.4466878232364483`*^9}, {3.4466929005572767`*^9, 
   3.4466929190839167`*^9}, {3.446693492157957*^9, 3.4466935036945457`*^9}, {
   3.446694017403222*^9, 3.446694027738083*^9}, {3.446867089436309*^9, 
   3.423171765484375*^9}, {3.4553247161354513`*^9, 3.455324770022938*^9}, 
   3.4821993034543247`*^9, {3.482716933221699*^9, 3.482716957606763*^9}, {
   3.4827169893724403`*^9, 3.482716990974744*^9}, {3.4833056745341697`*^9, 
   3.4833057043270097`*^9}, {3.4899792092535944`*^9, 3.4899792347284393`*^9}, 
   3.489979268206098*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"ProductLog", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4827169692935677`*^9, 3.4827187030265536`*^9, 3.489979268206098*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"ProductLog", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "+", 
     SuperscriptBox[
      RowBox[{"ProductLog", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], ")"}]}], 
  RowBox[{"b", " ", 
   RowBox[{"ProductLog", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}]}]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.4827184044972897`*^9, 3.4833054050566797`*^9, 
  3.489979268206098*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"x", " ", 
   RowBox[{"ProductLog", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4827169692935677`*^9, 3.482717024252595*^9, 3.4827187760014863`*^9, 
   3.489979268206098*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.4827184146318626`*^9, 3.48330540947303*^9, 
  3.489979268206098*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   RowBox[{"ProductLog", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4827169692935677`*^9, 3.4827170428293076`*^9, 3.4827187629527235`*^9, 
   3.489979268206098*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.482718420209883*^9, 3.489979268206098*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " ",
 "uses integration by parts to reduce the degree of ",
 Cell[BoxData[
  StyleBox[
   SuperscriptBox["x", "m"],
   FontWeight->"Bold"]]],
 ":"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500407697535`*^9}, {3.444350203233365*^9, 3.4443502040245028`*^9}, {
   3.444350234528365*^9, 3.4443502387243986`*^9}, {3.4466836227764835`*^9, 
   3.4466836230168285`*^9}, {3.4466839811618156`*^9, 3.4466839896239843`*^9}, 
   3.4466940377124257`*^9, {3.446694106040677*^9, 3.446694127681795*^9}, {
   3.446867106891408*^9, 3.423010833140625*^9}, 3.423171765484375*^9, {
   3.4553247918943872`*^9, 3.4553247949287505`*^9}, 3.4821993237434993`*^9, 
   3.482717127090469*^9, 3.4833056436597743`*^9, 3.4899792753509107`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"LambertW", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}]}], ",", " ", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{
  3.444350078924618*^9, {3.446688034289928*^9, 3.4466880406490717`*^9}, {
   3.4468671345411663`*^9, 3.423171765484375*^9}, {3.48271708175528*^9, 
   3.482717099210379*^9}, {3.482717150333891*^9, 3.4827171689206176`*^9}, {
   3.4827178589027634`*^9, 3.4827178591330943`*^9}, {3.482718940978712*^9, 
   3.4827189474379997`*^9}, 3.4899792753509107`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"LambertW", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}]}], "+", 
     RowBox[{"LambertW", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "2"]}]}], ")"}]}], 
  RowBox[{"b", " ", "LambertW", 
   RowBox[{"(", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], ")"}]}]]], "Output", "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.4833054959273453`*^9, 3.4833054974295053`*^9}, {
   3.483305567740608*^9, 3.4833055698736753`*^9}, 3.4899792753509107`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"x", "*", "LambertW", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}]}], ",", " ", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{
  3.444350078924618*^9, {3.446688034289928*^9, 3.4466880406490717`*^9}, {
   3.4468671345411663`*^9, 3.423171765484375*^9}, {3.48271708175528*^9, 
   3.482717099210379*^9}, {3.482717150333891*^9, 3.4827171689206176`*^9}, {
   3.4827178589027634`*^9, 3.4827178591330943`*^9}, {3.482718940978712*^9, 
   3.4827189474379997`*^9}, {3.482719008575912*^9, 3.482719009196805*^9}, 
   3.4899792753509107`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}]}], 
   SuperscriptBox["b", "2"]], "-", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], "2"], 
   RowBox[{"4", " ", 
    SuperscriptBox["b", "2"]}]], "-", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], "2"], 
   RowBox[{"8", " ", 
    SuperscriptBox["b", "2"], " ", "LambertW", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "2"]}]], "-", 
  FractionBox[
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}]}], 
   RowBox[{
    SuperscriptBox["b", "2"], " ", "LambertW", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}]}]], "+", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], "2"], 
   RowBox[{"4", " ", 
    SuperscriptBox["b", "2"], " ", "LambertW", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}]}]], "-", 
  FractionBox[
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], " ", "LambertW", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}]}], 
   SuperscriptBox["b", "2"]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "2"], " ", "LambertW", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "2"]}]]}]], "Output", "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483305497870139*^9, 3.4833054994323854`*^9}, {
   3.48330557054464*^9, 3.483305572217045*^9}, 3.4899792753509107`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "*", "LambertW", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}]}], ",", " ", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{
  3.444350078924618*^9, {3.446688034289928*^9, 3.4466880406490717`*^9}, {
   3.4468671345411663`*^9, 3.423171765484375*^9}, {3.48271708175528*^9, 
   3.482717099210379*^9}, {3.482717150333891*^9, 3.4827171689206176`*^9}, {
   3.4827178589027634`*^9, 3.4827178591330943`*^9}, {3.482718940978712*^9, 
   3.4827189474379997`*^9}, {3.482719012561643*^9, 3.4827190145044365`*^9}, 
   3.4899792753509107`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}]}], 
    SuperscriptBox["b", "3"]]}], "+", 
  FractionBox[
   RowBox[{"a", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "2"]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "3"]}]], "-", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], "3"], 
   RowBox[{"9", " ", 
    SuperscriptBox["b", "3"]}]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "3"]}], 
   RowBox[{"81", " ", 
    SuperscriptBox["b", "3"], " ", "LambertW", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "3"]}]], "+", 
  FractionBox[
   RowBox[{"a", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "2"]}], 
   RowBox[{"4", " ", 
    SuperscriptBox["b", "3"], " ", "LambertW", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "2"]}]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "3"]}], 
   RowBox[{"27", " ", 
    SuperscriptBox["b", "3"], " ", "LambertW", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "2"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}]}], 
   RowBox[{
    SuperscriptBox["b", "3"], " ", "LambertW", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}]}]], "-", 
  FractionBox[
   RowBox[{"a", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "2"]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "3"], " ", "LambertW", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}]}]], "+", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], "3"], 
   RowBox[{"9", " ", 
    SuperscriptBox["b", "3"], " ", "LambertW", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], " ", "LambertW", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}]}], 
   SuperscriptBox["b", "3"]], "-", 
  FractionBox[
   RowBox[{"a", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "2"], " ", "LambertW", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}]}], 
   SuperscriptBox["b", "3"]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "3"], " ", "LambertW", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}]}], 
   RowBox[{"3", " ", 
    SuperscriptBox["b", "3"]}]]}]], "Output", "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483305499792904*^9, 3.483305504279355*^9}, {
   3.483305572627635*^9, 3.4833055751612787`*^9}, 3.4899792753509107`*^9}]
}, Closed]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Special Function Integration Problem 5", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, {3.4821973084456434`*^9, 3.482197309066536*^9}, {
   3.4821982364300194`*^9, 3.482198240976557*^9}, 3.482198357524144*^9, {
   3.4821988021534896`*^9, 3.4821988078316545`*^9}, 3.4821989164378223`*^9, {
   3.482198948964594*^9, 3.4821990020909853`*^9}, 3.4821998658029423`*^9, 
   3.4827166857758894`*^9, 3.4827184653748274`*^9, {3.4832022784710383`*^9, 
   3.483202289366706*^9}, 3.4833933837627373`*^9, {3.4899677420190425`*^9, 
   3.4899677661990848`*^9}, 3.4899805045630703`*^9, 3.489982700784128*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "2"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
   3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
   3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.482199478365835*^9, {
   3.4827167285874496`*^9, 3.48271673125128*^9}, {3.482718509007568*^9, 
   3.4827185116513696`*^9}, {3.489980541363535*^9, 3.489980548165147*^9}, 
   3.4903834643638077`*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " uses integration by parts to reduce the degree of ",
 Cell[BoxData[
  StyleBox[
   SuperscriptBox["x", "m"],
   FontWeight->"Bold"]]],
 ":"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, 3.489979260094084*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "2"], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4827167569782734`*^9, 3.4827185240692253`*^9, 3.489979260094084*^9, {
   3.4899806385985055`*^9, 3.4899806448697166`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"4", " ", "x"}], "-", 
  FractionBox[
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}]}], 
   RowBox[{"b", " ", 
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], " ", 
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}], "b"], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"ProductLog", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], "b"]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{3.4827186279686255`*^9, 3.489979260094084*^9, 
  3.489980821302827*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"ProductLog", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4827167569782734`*^9, 3.482716878312744*^9, 3.4827186160014176`*^9, 
   3.489979260094084*^9, 3.489980673370967*^9, {3.4899807312750683`*^9, 
   3.489980732523071*^9}, 3.489980791600374*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"4", " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}]}], 
    SuperscriptBox["b", "2"]]}], "+", 
  FractionBox[
   RowBox[{"3", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "2"]}], 
   RowBox[{"4", " ", 
    SuperscriptBox["b", "2"]}]], "+", 
  FractionBox[
   RowBox[{"3", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "2"]}], 
   RowBox[{"8", " ", 
    SuperscriptBox["b", "2"], " ", 
    SuperscriptBox[
     RowBox[{"ProductLog", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}]], "+", 
  FractionBox[
   RowBox[{"4", " ", "a", " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}]}], 
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}]], "-", 
  FractionBox[
   RowBox[{"3", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "2"]}], 
   RowBox[{"4", " ", 
    SuperscriptBox["b", "2"], " ", 
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}]], "+", 
  FractionBox[
   RowBox[{"2", " ", "a", " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], " ", 
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}], 
   SuperscriptBox["b", "2"]], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "2"], " ", 
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "2"]}]], "-", 
  FractionBox[
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"ProductLog", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], 
   SuperscriptBox["b", "2"]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"ProductLog", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "2"]}]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{3.4833051440413585`*^9, 3.489979260094084*^9, 
  3.4899808250780334`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox[
     RowBox[{"ProductLog", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4827167569782734`*^9, 3.482716897039672*^9, 3.482718663710019*^9, {
   3.483305193402336*^9, 3.48330519425356*^9}, {3.4833053848576355`*^9, 
   3.483305385738902*^9}, 3.489979260094084*^9, 3.489980793706378*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"4", " ", 
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}]}], 
   SuperscriptBox["b", "3"]], "-", 
  FractionBox[
   RowBox[{"3", " ", "a", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "2"]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "3"]}]], "+", 
  FractionBox[
   RowBox[{"8", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "3"]}], 
   RowBox[{"27", " ", 
    SuperscriptBox["b", "3"]}]], "-", 
  FractionBox[
   RowBox[{"16", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "3"]}], 
   RowBox[{"243", " ", 
    SuperscriptBox["b", "3"], " ", 
    SuperscriptBox[
     RowBox[{"ProductLog", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "3"]}]], "-", 
  FractionBox[
   RowBox[{"3", " ", "a", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "2"]}], 
   RowBox[{"4", " ", 
    SuperscriptBox["b", "3"], " ", 
    SuperscriptBox[
     RowBox[{"ProductLog", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}]], "+", 
  FractionBox[
   RowBox[{"16", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "3"]}], 
   RowBox[{"81", " ", 
    SuperscriptBox["b", "3"], " ", 
    SuperscriptBox[
     RowBox[{"ProductLog", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}]], "-", 
  FractionBox[
   RowBox[{"4", " ", 
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}]}], 
   RowBox[{
    SuperscriptBox["b", "3"], " ", 
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}]], "+", 
  FractionBox[
   RowBox[{"3", " ", "a", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "2"]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "3"], " ", 
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}]], "-", 
  FractionBox[
   RowBox[{"8", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "3"]}], 
   RowBox[{"27", " ", 
    SuperscriptBox["b", "3"], " ", 
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], " ", 
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}], 
   SuperscriptBox["b", "3"]], "+", 
  FractionBox[
   RowBox[{"a", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "2"], " ", 
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}], 
   SuperscriptBox["b", "3"]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "3"], " ", 
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}], 
   RowBox[{"9", " ", 
    SuperscriptBox["b", "3"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"ProductLog", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], 
   SuperscriptBox["b", "3"]], "-", 
  FractionBox[
   RowBox[{"a", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"ProductLog", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], 
   SuperscriptBox["b", "3"]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "3"], " ", 
    SuperscriptBox[
     RowBox[{"ProductLog", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], 
   RowBox[{"3", " ", 
    SuperscriptBox["b", "3"]}]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{3.482718377899043*^9, 3.483305199160616*^9, 
  3.489979260094084*^9, 3.4899808291340404`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does not know to use integration by parts:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500256179667`*^9}, {3.4466836176090527`*^9, 3.446683618790752*^9}, {
   3.4466878172878942`*^9, 3.4466878232364483`*^9}, {3.4466929005572767`*^9, 
   3.4466929190839167`*^9}, {3.446693492157957*^9, 3.4466935036945457`*^9}, {
   3.446694017403222*^9, 3.446694027738083*^9}, {3.446867089436309*^9, 
   3.423171765484375*^9}, {3.4553247161354513`*^9, 3.455324770022938*^9}, 
   3.4821993034543247`*^9, {3.482716933221699*^9, 3.482716957606763*^9}, {
   3.4827169893724403`*^9, 3.482716990974744*^9}, {3.4833056745341697`*^9, 
   3.4833057043270097`*^9}, {3.4899792092535944`*^9, 3.4899792347284393`*^9}, 
   3.489979268206098*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "2"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4827169692935677`*^9, 3.4827187030265536`*^9, 3.489979268206098*^9, 
   3.489980797091584*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "4"}], "+", 
     RowBox[{"4", " ", 
      RowBox[{"ProductLog", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], "+", 
     SuperscriptBox[
      RowBox[{"ProductLog", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], "3"]}], ")"}]}], 
  RowBox[{"b", " ", 
   RowBox[{"ProductLog", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}]}]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.4827184044972897`*^9, 3.4833054050566797`*^9, 
  3.489979268206098*^9, 3.4899808350932508`*^9, 3.4899809193957987`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"x", " ", 
   SuperscriptBox[
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "2"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4827169692935677`*^9, 3.482717024252595*^9, 3.4827187760014863`*^9, 
   3.489979268206098*^9, 3.4899807995875883`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"ProductLog", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.4827184146318626`*^9, 3.48330540947303*^9, 
  3.489979268206098*^9, 3.489980838946458*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   SuperscriptBox[
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "2"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4827169692935677`*^9, 3.4827170428293076`*^9, 3.4827187629527235`*^9, 
   3.489979268206098*^9, 3.489980802723194*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox[
     RowBox[{"ProductLog", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.482718420209883*^9, 3.489979268206098*^9, 
  3.489980843080465*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " ",
 "uses integration by parts to reduce the degree of ",
 Cell[BoxData[
  StyleBox[
   SuperscriptBox["x", "m"],
   FontWeight->"Bold"]]],
 ":"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500407697535`*^9}, {3.444350203233365*^9, 3.4443502040245028`*^9}, {
   3.444350234528365*^9, 3.4443502387243986`*^9}, {3.4466836227764835`*^9, 
   3.4466836230168285`*^9}, {3.4466839811618156`*^9, 3.4466839896239843`*^9}, 
   3.4466940377124257`*^9, {3.446694106040677*^9, 3.446694127681795*^9}, {
   3.446867106891408*^9, 3.423010833140625*^9}, 3.423171765484375*^9, {
   3.4553247918943872`*^9, 3.4553247949287505`*^9}, 3.4821993237434993`*^9, 
   3.482717127090469*^9, 3.4833056436597743`*^9, 3.4899792753509107`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"LambertW", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}]}], ",", " ", "x"}], 
    ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{
  3.444350078924618*^9, {3.446688034289928*^9, 3.4466880406490717`*^9}, {
   3.4468671345411663`*^9, 3.423171765484375*^9}, {3.48271708175528*^9, 
   3.482717099210379*^9}, {3.482717150333891*^9, 3.4827171689206176`*^9}, {
   3.4827178589027634`*^9, 3.4827178591330943`*^9}, {3.482718940978712*^9, 
   3.4827189474379997`*^9}, 3.4899792753509107`*^9, {3.4899808082144036`*^9, 
   3.4899808086356044`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "4"}], "+", 
     RowBox[{"4", " ", "LambertW", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}]}], "-", 
     RowBox[{"2", " ", "LambertW", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "2"]}], "+", 
     RowBox[{"LambertW", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "3"]}]}], ")"}], 
   RowBox[{"(", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], ")"}]}], 
  RowBox[{"b", " ", "LambertW", 
   RowBox[{"(", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], ")"}]}]]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.4899809588794684`*^9, 3.4899810239939823`*^9}, 
   3.4899813392493362`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"x", "*", "LambertW", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}]}], ",", " ", "x"}], 
    ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{
  3.444350078924618*^9, {3.446688034289928*^9, 3.4466880406490717`*^9}, {
   3.4468671345411663`*^9, 3.423171765484375*^9}, {3.48271708175528*^9, 
   3.482717099210379*^9}, {3.482717150333891*^9, 3.4827171689206176`*^9}, {
   3.4827178589027634`*^9, 3.4827178591330943`*^9}, {3.482718940978712*^9, 
   3.4827189474379997`*^9}, {3.482719008575912*^9, 3.482719009196805*^9}, 
   3.4899792753509107`*^9, {3.4899808118180103`*^9, 3.4899808121300106`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"4", " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}]}], 
    SuperscriptBox["b", "2"]]}], "+", 
  FractionBox[
   RowBox[{"3", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "2"]}], 
   RowBox[{"4", " ", 
    SuperscriptBox["b", "2"]}]], "+", 
  FractionBox[
   RowBox[{"3", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "2"]}], 
   RowBox[{"8", " ", 
    SuperscriptBox["b", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"LambertW", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}]}], ")"}], "2"]}]], "+", 
  FractionBox[
   RowBox[{"4", " ", "a", " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}]}], 
   RowBox[{
    SuperscriptBox["b", "2"], " ", "LambertW", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}]}]], "-", 
  FractionBox[
   RowBox[{"3", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "2"]}], 
   RowBox[{"4", " ", 
    SuperscriptBox["b", "2"], " ", "LambertW", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}]}]], "+", 
  FractionBox[
   RowBox[{"2", " ", "a", " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], " ", "LambertW", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}]}], 
   SuperscriptBox["b", "2"]], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "2"], " ", "LambertW", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "2"]}]], "-", 
  FractionBox[
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"LambertW", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}]}], ")"}], "2"]}], 
   SuperscriptBox["b", "2"]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"LambertW", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}]}], ")"}], "2"]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "2"]}]]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.489981248583177*^9, 3.4899812522647834`*^9}, 
   3.4899813392493362`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "*", "LambertW", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}]}], ",", " ", "x"}], 
    ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{
  3.444350078924618*^9, {3.446688034289928*^9, 3.4466880406490717`*^9}, {
   3.4468671345411663`*^9, 3.423171765484375*^9}, {3.48271708175528*^9, 
   3.482717099210379*^9}, {3.482717150333891*^9, 3.4827171689206176`*^9}, {
   3.4827178589027634`*^9, 3.4827178591330943`*^9}, {3.482718940978712*^9, 
   3.4827189474379997`*^9}, {3.482719012561643*^9, 3.4827190145044365`*^9}, 
   3.4899792753509107`*^9, {3.489980815234416*^9, 3.4899808155776167`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"4", " ", 
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}]}], 
   SuperscriptBox["b", "3"]], "-", 
  FractionBox[
   RowBox[{"3", " ", "a", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "2"]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "3"]}]], "+", 
  FractionBox[
   RowBox[{"8", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "3"]}], 
   RowBox[{"27", " ", 
    SuperscriptBox["b", "3"]}]], "-", 
  FractionBox[
   RowBox[{"16", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "3"]}], 
   RowBox[{"243", " ", 
    SuperscriptBox["b", "3"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"LambertW", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}]}], ")"}], "3"]}]], "-", 
  FractionBox[
   RowBox[{"3", " ", "a", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "2"]}], 
   RowBox[{"4", " ", 
    SuperscriptBox["b", "3"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"LambertW", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}]}], ")"}], "2"]}]], "+", 
  FractionBox[
   RowBox[{"16", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "3"]}], 
   RowBox[{"81", " ", 
    SuperscriptBox["b", "3"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"LambertW", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}]}], ")"}], "2"]}]], "-", 
  FractionBox[
   RowBox[{"4", " ", 
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}]}], 
   RowBox[{
    SuperscriptBox["b", "3"], " ", "LambertW", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}]}]], "+", 
  FractionBox[
   RowBox[{"3", " ", "a", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "2"]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "3"], " ", "LambertW", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}]}]], "-", 
  FractionBox[
   RowBox[{"8", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "3"]}], 
   RowBox[{"27", " ", 
    SuperscriptBox["b", "3"], " ", "LambertW", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}]}]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], " ", "LambertW", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}]}], 
   SuperscriptBox["b", "3"]], "+", 
  FractionBox[
   RowBox[{"a", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "2"], " ", "LambertW", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}]}], 
   SuperscriptBox["b", "3"]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "3"], " ", "LambertW", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}]}], 
   RowBox[{"9", " ", 
    SuperscriptBox["b", "3"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"LambertW", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}]}], ")"}], "2"]}], 
   SuperscriptBox["b", "3"]], "-", 
  FractionBox[
   RowBox[{"a", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"LambertW", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}]}], ")"}], "2"]}], 
   SuperscriptBox["b", "3"]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "3"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"LambertW", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}]}], ")"}], "2"]}], 
   RowBox[{"3", " ", 
    SuperscriptBox["b", "3"]}]]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.4899812529823847`*^9, 3.4899812574751925`*^9}, 
   3.4899813392493362`*^9}]
}, Closed]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Special Function Integration Problem 6", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, {3.4821973084456434`*^9, 3.482197309066536*^9}, {
   3.4821982364300194`*^9, 3.482198240976557*^9}, 3.482198357524144*^9, {
   3.4821988021534896`*^9, 3.4821988078316545`*^9}, 3.4821989164378223`*^9, {
   3.482198948964594*^9, 3.4821990020909853`*^9}, 3.4821998658029423`*^9, 
   3.4827166857758894`*^9, 3.4827184653748274`*^9, {3.4832022784710383`*^9, 
   3.483202289366706*^9}, 3.4832026639753666`*^9, {3.4899677445462465`*^9, 
   3.489967767431487*^9}, 3.4899805089154778`*^9, 3.489982703404933*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   RowBox[{"ProductLog", "[", 
    RowBox[{"a", " ", 
     SuperscriptBox["x", "2"]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
   3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
   3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.482199478365835*^9, {
   3.4827167285874496`*^9, 3.48271673125128*^9}, {3.482718509007568*^9, 
   3.4827185116513696`*^9}, 3.4832032731012464`*^9, 3.490383466533811*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " is able to integrate  ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "2"]}], "]"}]}],
   FontSize->16,
   FontWeight->"Bold"]],
  CellDingbat->None,
  CellChangeTimes->{
   3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
    3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
    3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
    3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
    3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
    3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.482199478365835*^9, {
    3.4827167285874496`*^9, 3.48271673125128*^9}, {3.482718509007568*^9, 
    3.4827185116513696`*^9}, 3.4832032731012464`*^9},
  TextAlignment->Center,
  FontFamily->"Courier New",
  FontSize->20],
 " for all odd m:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832040958843503`*^9, 3.4832041044566765`*^9}, 3.483204218670909*^9, 
   3.489979351323044*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "3"], " ", 
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "2"]}], "]"}]}], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.483203049049075*^9, 3.483203053345253*^9}, 
   3.489979351323044*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    SuperscriptBox["x", "4"], "8"]}], "-", 
  FractionBox[
   SuperscriptBox["x", "4"], 
   RowBox[{"16", " ", 
    SuperscriptBox[
     RowBox[{"ProductLog", "[", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "2"]}], "]"}], "2"]}]], "+", 
  FractionBox[
   SuperscriptBox["x", "4"], 
   RowBox[{"8", " ", 
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "2"]}], "]"}]}]], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   SuperscriptBox["x", "4"], " ", 
   RowBox[{"ProductLog", "[", 
    RowBox[{"a", " ", 
     SuperscriptBox["x", "2"]}], "]"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{3.4832030597244253`*^9, 3.489979351323044*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "2"]}], "]"}]}], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.483203049049075*^9, 3.483203077029309*^9}, 
   3.489979351323044*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"]}], "+", 
  FractionBox[
   SuperscriptBox["x", "2"], 
   RowBox[{"2", " ", 
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "2"]}], "]"}]}]], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox["x", "2"], " ", 
   RowBox[{"ProductLog", "[", 
    RowBox[{"a", " ", 
     SuperscriptBox["x", "2"]}], "]"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{3.4832030778905473`*^9, 3.489979351323044*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "2"]}], "]"}], "x"], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832030956961503`*^9}, 
   3.489979351323044*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"ProductLog", "[", 
    RowBox[{"a", " ", 
     SuperscriptBox["x", "2"]}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   SuperscriptBox[
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "2"]}], "]"}], "2"]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{3.483203101093912*^9, 3.489979351323044*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "2"]}], "]"}], 
    SuperscriptBox["x", "3"]], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832031114387875`*^9}, 
   3.489979351323044*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", "a", " ", 
   RowBox[{"ExpIntegralEi", "[", 
    RowBox[{"-", 
     RowBox[{"ProductLog", "[", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "2"]}], "]"}]}], "]"}]}], "-", 
  FractionBox[
   RowBox[{"ProductLog", "[", 
    RowBox[{"a", " ", 
     SuperscriptBox["x", "2"]}], "]"}], 
   RowBox[{"2", " ", 
    SuperscriptBox["x", "2"]}]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4832031088951297`*^9, 3.4832031141827326`*^9}, 
   3.489979351323044*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "2"]}], "]"}], 
    SuperscriptBox["x", "5"]], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.483203049049075*^9, 3.483203118919544*^9}, 
   3.489979351323044*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], " ", 
   SuperscriptBox["a", "2"], " ", 
   RowBox[{"ExpIntegralEi", "[", 
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     RowBox[{"ProductLog", "[", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "2"]}], "]"}]}], "]"}]}], "-", 
  FractionBox[
   RowBox[{"ProductLog", "[", 
    RowBox[{"a", " ", 
     SuperscriptBox["x", "2"]}], "]"}], 
   RowBox[{"2", " ", 
    SuperscriptBox["x", "4"]}]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{3.483203119900955*^9, 3.489979351323044*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is only able to integrate  ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "2"]}], "]"}]}],
   FontSize->16,
   FontWeight->"Bold"]],
  CellDingbat->None,
  CellChangeTimes->{
   3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
    3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
    3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
    3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
    3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
    3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.482199478365835*^9, {
    3.4827167285874496`*^9, 3.48271673125128*^9}, {3.482718509007568*^9, 
    3.4827185116513696`*^9}, 3.4832032731012464`*^9},
  TextAlignment->Center,
  FontFamily->"Courier New",
  FontSize->20],
 " for odd m greater than -2:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832035785604753`*^9, 3.483203624947176*^9}, {3.483204238259075*^9, 
   3.483204254872965*^9}, {3.483204320557414*^9, 3.4832043261654787`*^9}, {
   3.4833082833554707`*^9, 3.4833083199080305`*^9}, 3.4899793688106747`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "3"], " ", 
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "2"]}], "]"}]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.483203049049075*^9, 3.483203053345253*^9}, {
   3.4832036842925105`*^9, 3.48320368563444*^9}, 3.4899793688106747`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    SuperscriptBox["x", "4"], "8"]}], "-", 
  FractionBox[
   SuperscriptBox["x", "4"], 
   RowBox[{"16", " ", 
    SuperscriptBox[
     RowBox[{"ProductLog", "[", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "2"]}], "]"}], "2"]}]], "+", 
  FractionBox[
   SuperscriptBox["x", "4"], 
   RowBox[{"8", " ", 
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "2"]}], "]"}]}]], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   SuperscriptBox["x", "4"], " ", 
   RowBox[{"ProductLog", "[", 
    RowBox[{"a", " ", 
     SuperscriptBox["x", "2"]}], "]"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.4832030597244253`*^9, 3.4899793688106747`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "2"]}], "]"}]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.483203049049075*^9, 3.483203077029309*^9}, 
   3.4832036903011503`*^9, {3.4832037354360514`*^9, 3.483203751278832*^9}, 
   3.4899793688106747`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"]}], "+", 
  FractionBox[
   SuperscriptBox["x", "2"], 
   RowBox[{"2", " ", 
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "2"]}], "]"}]}]], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox["x", "2"], " ", 
   RowBox[{"ProductLog", "[", 
    RowBox[{"a", " ", 
     SuperscriptBox["x", "2"]}], "]"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{
  3.4832030778905473`*^9, {3.4832037393516817`*^9, 3.483203747002683*^9}, 
   3.4899793688106747`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "2"]}], "]"}], "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832030956961503`*^9}, 
   3.4832036919835696`*^9, 3.4899793688106747`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"ProductLog", "[", 
    RowBox[{"a", " ", 
     SuperscriptBox["x", "2"]}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   SuperscriptBox[
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "2"]}], "]"}], "2"]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.483203101093912*^9, 3.4832037201941347`*^9, 
  3.4899793688106747`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "2"]}], "]"}], 
    SuperscriptBox["x", "3"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832031114387875`*^9}, 
   3.483203693926363*^9, 3.4899793688106747`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "2"]}], "]"}], 
    SuperscriptBox["x", "3"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4832031088951297`*^9, 3.4832031141827326`*^9}, 
   3.483203727314373*^9, 3.4899793688106747`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "2"]}], "]"}], 
    SuperscriptBox["x", "5"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.483203049049075*^9, 3.483203118919544*^9}, 
   3.4832036955887537`*^9, 3.4899793688106747`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "2"]}], "]"}], 
    SuperscriptBox["x", "5"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.483203119900955*^9, 3.483203730278635*^9, 
  3.4899793688106747`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " is only able to integrate  ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    SuperscriptBox["x", "m"], " ", "LambertW", 
    RowBox[{"(", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "2"]}], ")"}]}],
   FontSize->16,
   FontWeight->"Bold"]],
  CellDingbat->None,
  CellChangeTimes->{
   3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
    3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
    3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
    3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
    3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
    3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.482199478365835*^9, {
    3.4827167285874496`*^9, 3.48271673125128*^9}, {3.482718509007568*^9, 
    3.4827185116513696`*^9}, 3.4832032731012464`*^9},
  TextAlignment->Center,
  FontFamily->"Courier New",
  FontSize->20],
 " for m equal 1 or -1:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832035785604753`*^9, 3.483203624947176*^9}, {3.4832037709771566`*^9, 
   3.4832037722690144`*^9}, 3.483204286167965*^9, 3.4832043364602814`*^9, {
   3.4833060149736977`*^9, 3.4833060318679905`*^9}, {3.4833068181486063`*^9, 
   3.48330682844341*^9}, {3.4833082316310945`*^9, 3.4833082318614254`*^9}, 
   3.489979383693101*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "3"}], "*", "LambertW", 
      RowBox[{"(", 
       RowBox[{"a", "*", 
        RowBox[{"x", "^", "2"}]}], ")"}]}], ",", " ", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483203049049075*^9, 3.483203053345253*^9}, {
   3.4832038419191666`*^9, 3.4832038604858637`*^9}, 3.4832038979998064`*^9, 
   3.483307156795557*^9, 3.489979383693101*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "3"], "LambertW", 
   RowBox[{"(", 
    RowBox[{"a", " ", 
     SuperscriptBox["x", "2"]}], ")"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483204013085291*^9, 3.4832040209766383`*^9}, {
   3.483305817229355*^9, 3.4833058209847555`*^9}, 3.489979383693101*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"x", "*", "LambertW", 
      RowBox[{"(", 
       RowBox[{"a", "*", 
        RowBox[{"x", "^", "2"}]}], ")"}]}], ",", " ", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483203049049075*^9, 3.483203077029309*^9}, {
   3.4832038422896996`*^9, 3.483203862919363*^9}, 3.483203903127179*^9, 
   3.483307158307731*^9, 3.489979383693101*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"]}], "+", 
  FractionBox[
   SuperscriptBox["x", "2"], 
   RowBox[{"2", " ", "LambertW", 
    RowBox[{"(", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "2"]}], ")"}]}]], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox["x", "2"], " ", "LambertW", 
   RowBox[{"(", 
    RowBox[{"a", " ", 
     SuperscriptBox["x", "2"]}], ")"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483203903627899*^9, 3.483203919670968*^9}, 
   3.489979383693101*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"LambertW", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "*", 
         RowBox[{"x", "^", "2"}]}], ")"}], "/", "x"}]}], ",", " ", "x"}], 
    ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832030956961503`*^9}, {
   3.4832038426001453`*^9, 3.48320386539292*^9}, 3.483203905901168*^9, 
   3.4833071598399343`*^9, 3.489979383693101*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", "LambertW", 
   RowBox[{"(", 
    RowBox[{"a", " ", 
     SuperscriptBox["x", "2"]}], ")"}]}], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", "LambertW", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "2"]}], ")"}], "2"]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.4832039064119024`*^9, 3.4832039205121775`*^9}, 
   3.489979383693101*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"LambertW", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "*", 
         RowBox[{"x", "^", "2"}]}], ")"}], "/", 
       RowBox[{"x", "^", "3"}]}]}], ",", " ", "x"}], ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832031114387875`*^9}, {
   3.483203843010736*^9, 3.4832038682370095`*^9}, 3.483203907553544*^9, 
   3.483307160981576*^9, 3.489979383693101*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"LambertW", 
     RowBox[{"(", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "2"]}], ")"}]}], 
    SuperscriptBox["x", "3"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483204013085291*^9, 3.4832040209766383`*^9}, 
   3.489979383693101*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"LambertW", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "*", 
         RowBox[{"x", "^", "2"}]}], ")"}], "/", 
       RowBox[{"x", "^", "5"}]}]}], ",", " ", "x"}], ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483203049049075*^9, 3.483203118919544*^9}, 
   3.483203843391283*^9, {3.4832038751970177`*^9, 3.4832038755775647`*^9}, 
   3.483203908935531*^9, 3.483307163054557*^9, 3.489979383693101*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"LambertW", 
     RowBox[{"(", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "2"]}], ")"}]}], 
    SuperscriptBox["x", "5"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483204013085291*^9, 3.483204029148389*^9}, 
   3.489979383693101*^9}]
}, Closed]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Special Function Integration Problem 7", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, {3.4821973084456434`*^9, 3.482197309066536*^9}, {
   3.4821982364300194`*^9, 3.482198240976557*^9}, 3.482198357524144*^9, {
   3.4821988021534896`*^9, 3.4821988078316545`*^9}, 3.4821989164378223`*^9, {
   3.482198948964594*^9, 3.4821990020909853`*^9}, 3.4821998658029423`*^9, 
   3.4827166857758894`*^9, 3.4827184653748274`*^9, {3.4832022784710383`*^9, 
   3.483202289366706*^9}, 3.4832026639753666`*^9, 3.4832052946080303`*^9, {
   3.489967745825449*^9, 3.4899677708322926`*^9}, 3.4899805137514863`*^9, 
   3.489982706758939*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   RowBox[{"ProductLog", "[", 
    FractionBox["a", "x"], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
   3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
   3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.482199478365835*^9, {
   3.4827167285874496`*^9, 3.48271673125128*^9}, {3.482718509007568*^9, 
   3.4827185116513696`*^9}, 3.4832032731012464`*^9, {3.4832052984836035`*^9, 
   3.483205305063064*^9}, 3.4903834682938137`*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " is able to integrate  ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"ProductLog", "[", 
     FractionBox["a", "x"], "]"}]}],
   FontSize->16,
   FontWeight->"Bold"]],
  CellDingbat->None,
  CellChangeTimes->{
   3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
    3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
    3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
    3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
    3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
    3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.482199478365835*^9, {
    3.4827167285874496`*^9, 3.48271673125128*^9}, {3.482718509007568*^9, 
    3.4827185116513696`*^9}, 3.4832032731012464`*^9},
  TextAlignment->Center,
  FontFamily->"Courier New",
  FontSize->20],
 " for all integer m:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832040958843503`*^9, 3.4832041044566765`*^9}, 3.483204218670909*^9, {
   3.483205323038912*^9, 3.483205324060381*^9}, 3.4832055331910963`*^9, 
   3.4899794396191993`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    RowBox[{"ProductLog", "[", 
     FractionBox["a", "x"], "]"}]}], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.483203049049075*^9, 3.483203053345253*^9}, 
   3.48320534351836*^9, {3.483205406258576*^9, 3.4832054104145517`*^9}, 
   3.4899794396191993`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["3", "2"]}], " ", 
   SuperscriptBox["a", "3"], " ", 
   RowBox[{"ExpIntegralEi", "[", 
    RowBox[{
     RowBox[{"-", "3"}], " ", 
     RowBox[{"ProductLog", "[", 
      FractionBox["a", "x"], "]"}]}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox["x", "3"], " ", 
   RowBox[{"ProductLog", "[", 
    FractionBox["a", "x"], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox["x", "3"], " ", 
   SuperscriptBox[
    RowBox[{"ProductLog", "[", 
     FractionBox["a", "x"], "]"}], "2"]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{3.4832054112557616`*^9, 3.4899794396191993`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"ProductLog", "[", 
     FractionBox["a", "x"], "]"}]}], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.483203049049075*^9, 3.483203077029309*^9}, 
   3.4832053490863667`*^9, 3.4899794396191993`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["a", "2"], " ", 
   RowBox[{"ExpIntegralEi", "[", 
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     RowBox[{"ProductLog", "[", 
      FractionBox["a", "x"], "]"}]}], "]"}]}], "+", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   RowBox[{"ProductLog", "[", 
    FractionBox["a", "x"], "]"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{3.4832030778905473`*^9, 3.483205417424632*^9, 
  3.4899794396191993`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{"ProductLog", "[", 
    FractionBox["a", "x"], "]"}], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.483203049049075*^9, 3.483203077029309*^9}, 
   3.4832053490863667`*^9, {3.483205469930131*^9, 3.483205473745618*^9}, 
   3.4899794396191993`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "a"}], " ", 
   RowBox[{"ExpIntegralEi", "[", 
    RowBox[{"-", 
     RowBox[{"ProductLog", "[", 
      FractionBox["a", "x"], "]"}]}], "]"}]}], "+", 
  RowBox[{"x", " ", 
   RowBox[{"ProductLog", "[", 
    FractionBox["a", "x"], "]"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{3.483205474506712*^9, 3.4899794396191993`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"ProductLog", "[", 
     FractionBox["a", "x"], "]"}], "x"], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832030956961503`*^9}, 
   3.4832053529719534`*^9, 3.4899794396191993`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"ProductLog", "[", 
    FractionBox["a", "x"], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox[
    RowBox[{"ProductLog", "[", 
     FractionBox["a", "x"], "]"}], "2"]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{3.483203101093912*^9, 3.4832054372431297`*^9, 
  3.4832055134226704`*^9, 3.4899794396191993`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"ProductLog", "[", 
     FractionBox["a", "x"], "]"}], 
    SuperscriptBox["x", "2"]], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832031114387875`*^9}, 
   3.4832053559963026`*^9, 3.4832054565909505`*^9, 3.4899794396191993`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "x"], "-", 
  FractionBox["1", 
   RowBox[{"x", " ", 
    RowBox[{"ProductLog", "[", 
     FractionBox["a", "x"], "]"}]}]], "-", 
  FractionBox[
   RowBox[{"ProductLog", "[", 
    FractionBox["a", "x"], "]"}], "x"]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4832031088951297`*^9, 3.4832031141827326`*^9}, {
   3.483205443361928*^9, 3.483205458113139*^9}, 3.4832055143339806`*^9, 
   3.4899794396191993`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"ProductLog", "[", 
     FractionBox["a", "x"], "]"}], 
    SuperscriptBox["x", "3"]], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832031114387875`*^9}, 
   3.4832053559963026`*^9, 3.4832054526552916`*^9, 3.4899794396191993`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"4", " ", 
    SuperscriptBox["x", "2"]}]], "+", 
  FractionBox["1", 
   RowBox[{"8", " ", 
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox[
     RowBox[{"ProductLog", "[", 
      FractionBox["a", "x"], "]"}], "2"]}]], "-", 
  FractionBox["1", 
   RowBox[{"4", " ", 
    SuperscriptBox["x", "2"], " ", 
    RowBox[{"ProductLog", "[", 
     FractionBox["a", "x"], "]"}]}]], "-", 
  FractionBox[
   RowBox[{"ProductLog", "[", 
    FractionBox["a", "x"], "]"}], 
   RowBox[{"2", " ", 
    SuperscriptBox["x", "2"]}]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{3.483205453826976*^9, 3.483205515135133*^9, 
  3.4899794396191993`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"ProductLog", "[", 
     FractionBox["a", "x"], "]"}], 
    SuperscriptBox["x", "4"]], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832031114387875`*^9}, 
   3.4832053559963026`*^9, 3.4832054526552916`*^9, 3.4832063191312227`*^9, 
   3.4899794396191993`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"9", " ", 
    SuperscriptBox["x", "3"]}]], "-", 
  FractionBox["2", 
   RowBox[{"81", " ", 
    SuperscriptBox["x", "3"], " ", 
    SuperscriptBox[
     RowBox[{"ProductLog", "[", 
      FractionBox["a", "x"], "]"}], "3"]}]], "+", 
  FractionBox["2", 
   RowBox[{"27", " ", 
    SuperscriptBox["x", "3"], " ", 
    SuperscriptBox[
     RowBox[{"ProductLog", "[", 
      FractionBox["a", "x"], "]"}], "2"]}]], "-", 
  FractionBox["1", 
   RowBox[{"9", " ", 
    SuperscriptBox["x", "3"], " ", 
    RowBox[{"ProductLog", "[", 
     FractionBox["a", "x"], "]"}]}]], "-", 
  FractionBox[
   RowBox[{"ProductLog", "[", 
    FractionBox["a", "x"], "]"}], 
   RowBox[{"3", " ", 
    SuperscriptBox["x", "3"]}]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{3.483205453826976*^9, 3.483205515135133*^9, 
  3.483206320473152*^9, 3.4899794396191993`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is only able to integrate  ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"ProductLog", "[", 
     FractionBox["a", "x"], "]"}]}],
   FontSize->16,
   FontWeight->"Bold"]],
  CellDingbat->None,
  CellChangeTimes->{
   3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
    3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
    3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
    3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
    3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
    3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.482199478365835*^9, {
    3.4827167285874496`*^9, 3.48271673125128*^9}, {3.482718509007568*^9, 
    3.4827185116513696`*^9}, 3.4832032731012464`*^9},
  TextAlignment->Center,
  FontFamily->"Courier New",
  FontSize->20],
 " for m equal -1 or -2:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832035785604753`*^9, 3.483203624947176*^9}, {3.483204238259075*^9, 
   3.483204254872965*^9}, {3.483204320557414*^9, 3.4832043261654787`*^9}, {
   3.483205836056595*^9, 3.4832058589995856`*^9}, 3.4832059847704353`*^9, 
   3.489979448776415*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   RowBox[{"ProductLog", "[", 
    FractionBox["a", "x"], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.483203049049075*^9, 3.483203053345253*^9}, {
   3.4832036842925105`*^9, 3.48320368563444*^9}, {3.4832055970929823`*^9, 
   3.483205609130291*^9}, 3.489979448776415*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    RowBox[{"ProductLog", "[", 
     FractionBox["a", "x"], "]"}]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.483205609911414*^9, 3.489979448776415*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"x", " ", 
   RowBox[{"ProductLog", "[", 
    FractionBox["a", "x"], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.483203049049075*^9, 3.483203077029309*^9}, 
   3.4832036903011503`*^9, {3.4832037354360514`*^9, 3.483203751278832*^9}, 
   3.4832056343565645`*^9, 3.489979448776415*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"ProductLog", "[", 
     FractionBox["a", "x"], "]"}]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{
  3.4832030778905473`*^9, {3.4832037393516817`*^9, 3.483203747002683*^9}, {
   3.483205615078845*^9, 3.4832056352979183`*^9}, 3.489979448776415*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"ProductLog", "[", 
    FractionBox["a", "x"], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.483203049049075*^9, 3.483203077029309*^9}, 
   3.4832036903011503`*^9, {3.4832037354360514`*^9, 3.483203751278832*^9}, 
   3.4832056343565645`*^9, {3.4832057079724193`*^9, 3.4832057111369696`*^9}, 
   3.489979448776415*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"ProductLog", "[", 
    FractionBox["a", "x"], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.4832057116577187`*^9, 3.489979448776415*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"ProductLog", "[", 
     FractionBox["a", "x"], "]"}], "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832030956961503`*^9}, 
   3.4832036919835696`*^9, 3.48320565838111*^9, 3.489979448776415*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"ProductLog", "[", 
    FractionBox["a", "x"], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox[
    RowBox[{"ProductLog", "[", 
     FractionBox["a", "x"], "]"}], "2"]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.483203101093912*^9, 3.4832037201941347`*^9, 
  3.483205669457037*^9, 3.489979448776415*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"ProductLog", "[", 
     FractionBox["a", "x"], "]"}], 
    SuperscriptBox["x", "2"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832031114387875`*^9}, 
   3.483203693926363*^9, {3.483205660414034*^9, 3.483205694262706*^9}, 
   3.483205909752565*^9, 3.489979448776415*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "x"], "-", 
  FractionBox["1", 
   RowBox[{"x", " ", 
    RowBox[{"ProductLog", "[", 
     FractionBox["a", "x"], "]"}]}]], "-", 
  FractionBox[
   RowBox[{"ProductLog", "[", 
    FractionBox["a", "x"], "]"}], "x"]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4832031088951297`*^9, 3.4832031141827326`*^9}, 
   3.483203727314373*^9, {3.48320567073888*^9, 3.4832056897261825`*^9}, 
   3.489979448776415*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"ProductLog", "[", 
     FractionBox["a", "x"], "]"}], 
    SuperscriptBox["x", "3"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.483203049049075*^9, 3.483203118919544*^9}, 
   3.4832036955887537`*^9, {3.4832056627173457`*^9, 3.483205664620082*^9}, 
   3.489979448776415*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"ProductLog", "[", 
     FractionBox["a", "x"], "]"}], 
    SuperscriptBox["x", "3"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.483203119900955*^9, 3.483203730278635*^9, 
  3.4832056726716595`*^9, 3.489979448776415*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"ProductLog", "[", 
     FractionBox["a", "x"], "]"}], 
    SuperscriptBox["x", "4"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.483203049049075*^9, 3.483203118919544*^9}, 
   3.4832036955887537`*^9, {3.4832056627173457`*^9, 3.483205664620082*^9}, 
   3.4832063605007086`*^9, 3.489979448776415*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"ProductLog", "[", 
     FractionBox["a", "x"], "]"}], 
    SuperscriptBox["x", "4"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.4832063664292336`*^9, 3.489979448776415*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " is able to integrate  ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    SuperscriptBox["x", "m"], " ", "LambertW", 
    RowBox[{"(", 
     FractionBox["a", "x"], ")"}]}],
   FontSize->16,
   FontWeight->"Bold"]],
  CellDingbat->None,
  CellChangeTimes->{
   3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
    3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
    3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
    3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
    3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
    3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.482199478365835*^9, {
    3.4827167285874496`*^9, 3.48271673125128*^9}, {3.482718509007568*^9, 
    3.4827185116513696`*^9}, 3.4832032731012464`*^9},
  TextAlignment->Center,
  FontFamily->"Courier New",
  FontSize->20],
 " ",
 "for all integer m:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832035785604753`*^9, 3.483203624947176*^9}, {3.4832037709771566`*^9, 
   3.4832037722690144`*^9}, 3.483204286167965*^9, 3.4832043364602814`*^9, {
   3.4832059265266848`*^9, 3.4832059365811424`*^9}, 3.483205988676051*^9, {
   3.4833067503811617`*^9, 3.48330678729424*^9}, {3.4833070641924*^9, 
   3.4833070832297745`*^9}, 3.4899794592908335`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "*", "LambertW", 
      RowBox[{"(", 
       RowBox[{"a", "/", "x"}], ")"}]}], ",", " ", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483203049049075*^9, 3.483203077029309*^9}, {
   3.4832038422896996`*^9, 3.483203862919363*^9}, 3.483203903127179*^9, 
   3.4832060090653696`*^9, {3.4832061337146063`*^9, 3.4832061340751247`*^9}, 
   3.4833071768543997`*^9, 3.4899794592908335`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["3", "2"], " ", 
   SuperscriptBox["a", "3"], " ", "Ei", 
   RowBox[{"(", 
    RowBox[{"1", ",", 
     RowBox[{"3", " ", "LambertW", 
      RowBox[{"(", 
       FractionBox["a", "x"], ")"}]}]}], ")"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox["x", "3"], " ", "LambertW", 
   RowBox[{"(", 
    FractionBox["a", "x"], ")"}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox["x", "3"], " ", "LambertW", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["a", "x"], ")"}], "2"]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.4833062336180925`*^9, 3.4833062465867405`*^9}, {
   3.4833062898389344`*^9, 3.483306314945035*^9}, {3.483306770490077*^9, 
   3.48330678888653*^9}, 3.4899794592908335`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"x", "*", "LambertW", 
      RowBox[{"(", 
       RowBox[{"a", "/", "x"}], ")"}]}], ",", " ", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483203049049075*^9, 3.483203077029309*^9}, {
   3.4832038422896996`*^9, 3.483203862919363*^9}, 3.483203903127179*^9, 
   3.4832060090653696`*^9, 3.4833071779760127`*^9, 3.4899794592908335`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    SuperscriptBox["a", "2"]}], " ", "Ei", 
   RowBox[{"(", 
    RowBox[{"1", ",", 
     RowBox[{"2", " ", "LambertW", 
      RowBox[{"(", 
       FractionBox["a", "x"], ")"}]}]}], ")"}]}], "+", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", "LambertW", 
   RowBox[{"(", 
    FractionBox["a", "x"], ")"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483306415048978*^9, 3.4833064295398145`*^9}, {
   3.4833067512824574`*^9, 3.483306789587538*^9}, 3.4899794592908335`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"LambertW", 
      RowBox[{"(", 
       RowBox[{"a", "/", "x"}], ")"}]}], ",", " ", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483203049049075*^9, 3.483203077029309*^9}, {
   3.4832038422896996`*^9, 3.483203862919363*^9}, 3.483203903127179*^9, 
   3.4832060090653696`*^9, {3.4832061703172383`*^9, 3.483206170487483*^9}, 
   3.4833071794281006`*^9, 3.4899794592908335`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "Ei", 
   RowBox[{"(", 
    RowBox[{"1", ",", 
     RowBox[{"LambertW", 
      RowBox[{"(", 
       FractionBox["a", "x"], ")"}]}]}], ")"}]}], "+", 
  RowBox[{"x", " ", "LambertW", 
   RowBox[{"(", 
    FractionBox["a", "x"], ")"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483306488083997*^9, 3.483306500201421*^9}, {
   3.4833067521136527`*^9, 3.483306790238474*^9}, 3.4899794592908335`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"LambertW", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "/", "x"}], ")"}], "/", "x"}]}], ",", " ", "x"}], 
    ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832030956961503`*^9}, {
   3.4832038426001453`*^9, 3.48320386539292*^9}, 3.483203905901168*^9, 
   3.4832060116691136`*^9, 3.483307180940275*^9, 3.4899794592908335`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "LambertW"}], 
   RowBox[{"(", 
    FractionBox["a", "x"], ")"}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", "LambertW", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["a", "x"], ")"}], "2"]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483306752764589*^9, 3.483306790649064*^9}, 
   3.4899794592908335`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"LambertW", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "/", "x"}], ")"}], "/", 
       RowBox[{"x", "^", "2"}]}]}], ",", " ", "x"}], ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483203049049075*^9, 3.4832031114387875`*^9}, {
   3.483203843010736*^9, 3.4832038682370095`*^9}, 3.483203907553544*^9, {
   3.483206015053981*^9, 3.48320602199396*^9}, 3.4833071825726223`*^9, 
   3.4899794592908335`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "x"], "-", 
  FractionBox["1", 
   RowBox[{"x", " ", "LambertW", 
    RowBox[{"(", 
     FractionBox["a", "x"], ")"}]}]], "-", 
  FractionBox[
   RowBox[{"LambertW", 
    RowBox[{"(", 
     FractionBox["a", "x"], ")"}]}], "x"]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.4833067534555826`*^9, 3.4833067910796833`*^9}, 
   3.4899794592908335`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"LambertW", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "/", "x"}], ")"}], "/", 
       RowBox[{"x", "^", "3"}]}]}], ",", " ", "x"}], ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483203049049075*^9, 3.483203118919544*^9}, 
   3.483203843391283*^9, {3.4832038751970177`*^9, 3.4832038755775647`*^9}, 
   3.483203908935531*^9, {3.4832060175075088`*^9, 3.4832060237364655`*^9}, 
   3.4833071847657757`*^9, 3.4899794592908335`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"4", " ", 
    SuperscriptBox["x", "2"]}]], "+", 
  FractionBox["1", 
   RowBox[{"8", " ", 
    SuperscriptBox["x", "2"], " ", "LambertW", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["a", "x"], ")"}], "2"]}]], "-", 
  FractionBox["1", 
   RowBox[{"4", " ", 
    SuperscriptBox["x", "2"], " ", "LambertW", 
    RowBox[{"(", 
     FractionBox["a", "x"], ")"}]}]], "-", 
  FractionBox[
   RowBox[{"LambertW", 
    RowBox[{"(", 
     FractionBox["a", "x"], ")"}]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["x", "2"]}]]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483306754326835*^9, 3.483306791780691*^9}, 
   3.4899794592908335`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"LambertW", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "/", "x"}], ")"}], "/", 
       RowBox[{"x", "^", "4"}]}]}], ",", " ", "x"}], ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483203049049075*^9, 3.483203118919544*^9}, 
   3.483203843391283*^9, {3.4832038751970177`*^9, 3.4832038755775647`*^9}, 
   3.483203908935531*^9, {3.4832060175075088`*^9, 3.4832060237364655`*^9}, 
   3.483206428228096*^9, 3.4833071861677923`*^9, 3.4899794592908335`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"9", " ", 
    SuperscriptBox["x", "3"]}]], "-", 
  FractionBox["2", 
   RowBox[{"81", " ", 
    SuperscriptBox["x", "3"], " ", "LambertW", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["a", "x"], ")"}], "3"]}]], "+", 
  FractionBox["2", 
   RowBox[{"27", " ", 
    SuperscriptBox["x", "3"], " ", "LambertW", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["a", "x"], ")"}], "2"]}]], "-", 
  FractionBox["1", 
   RowBox[{"9", " ", 
    SuperscriptBox["x", "3"], " ", "LambertW", 
    RowBox[{"(", 
     FractionBox["a", "x"], ")"}]}]], "-", 
  FractionBox[
   RowBox[{"LambertW", 
    RowBox[{"(", 
     FractionBox["a", "x"], ")"}]}], 
   RowBox[{"3", " ", 
    SuperscriptBox["x", "3"]}]]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.4833067556587505`*^9, 3.483306793112606*^9}, 
   3.4899794592908335`*^9}]
}, Closed]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Special Function Integration Problem 8", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, {3.4821973084456434`*^9, 3.482197309066536*^9}, {
   3.4821982364300194`*^9, 3.482198240976557*^9}, 3.482198357524144*^9, {
   3.4821988021534896`*^9, 3.4821988078316545`*^9}, 3.4821989164378223`*^9, {
   3.482198948964594*^9, 3.4821990020909853`*^9}, 3.4821998658029423`*^9, 
   3.4827166857758894`*^9, 3.4827184653748274`*^9, {3.4832022784710383`*^9, 
   3.483202289366706*^9}, 3.4832026639753666`*^9, 3.4832052946080303`*^9, 
   3.48320731685588*^9, {3.4899677470890512`*^9, 3.489967773000697*^9}, 
   3.489980516621891*^9, 3.4899827093953433`*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"ProductLog", "[", 
     FractionBox["a", 
      SuperscriptBox["x", 
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}]]], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
   3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
   3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.482199478365835*^9, {
   3.4827167285874496`*^9, 3.48271673125128*^9}, {3.482718509007568*^9, 
   3.4827185116513696`*^9}, 3.4832032731012464`*^9, {3.4832052984836035`*^9, 
   3.483205305063064*^9}, 3.4832073543097363`*^9, 3.4832152840247297`*^9, 
   3.490383470053816*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " knows how to integrate  ",
 Cell[BoxData[
  StyleBox[
   SuperscriptBox[
    RowBox[{"ProductLog", "[", 
     FractionBox["a", 
      SuperscriptBox["x", 
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}]]], "]"}], "n"],
   FontSize->16,
   FontWeight->"Bold"]],
  CellDingbat->None,
  CellChangeTimes->{
   3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
    3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
    3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
    3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
    3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
    3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.482199478365835*^9, {
    3.4827167285874496`*^9, 3.48271673125128*^9}, {3.482718509007568*^9, 
    3.4827185116513696`*^9}, 3.4832032731012464`*^9, {3.4832052984836035`*^9, 
    3.483205305063064*^9}, 3.4832073543097363`*^9, 3.4832152840247297`*^9},
  TextAlignment->Center,
  FontFamily->"Courier New",
  FontSize->20],
 " for symbolic and numeric n:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832040958843503`*^9, 3.4832041044566765`*^9}, 3.483204218670909*^9, {
   3.483205323038912*^9, 3.483205324060381*^9}, 3.4832055331910963`*^9, {
   3.4832074394221215`*^9, 3.4832074789189153`*^9}, {3.4832077518914304`*^9, 
   3.4832077777085533`*^9}, {3.483207843763536*^9, 3.4832078439738383`*^9}, {
   3.483215298145034*^9, 3.483215317102293*^9}, 3.4899794981817017`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"ProductLog", "[", 
     FractionBox["a", 
      SuperscriptBox["x", 
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}]]], "]"}], "n"], ",", "x"}], 
  "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.483206987201861*^9, 3.483207022061987*^9}, {
   3.4832070847521315`*^9, 3.4832071479930673`*^9}, {3.483207339127906*^9, 
   3.4832073738778734`*^9}, 3.4832150161094866`*^9, {3.4832151459261537`*^9, 
   3.483215146797406*^9}, {3.483215236085797*^9, 3.483215236796819*^9}, 
   3.4899794981817017`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["n", 
    RowBox[{"n", "-", "1"}]], " ", "x", " ", 
   SuperscriptBox[
    RowBox[{"ProductLog", "[", 
     FractionBox["a", 
      SuperscriptBox["x", 
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}]]], "]"}], 
    RowBox[{"n", "-", "1"}]]}], "+", 
  RowBox[{"x", " ", 
   SuperscriptBox[
    RowBox[{"ProductLog", "[", 
     FractionBox["a", 
      SuperscriptBox["x", 
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}]]], "]"}], "n"]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4832149788659325`*^9, 3.4832149810590863`*^9}, {
   3.483215021567334*^9, 3.48321509165812*^9}, {3.483215171002211*^9, 
   3.4832151717432766`*^9}, {3.483215209197133*^9, 3.48321521032876*^9}, 
   3.4899794981817017`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"ProductLog", "[", 
     FractionBox["a", "x"], "]"}], "2"], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.483206987201861*^9, 3.483207022061987*^9}, {
   3.4832070847521315`*^9, 3.483207167861637*^9}, 3.4899794981817017`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "x", " ", 
   RowBox[{"ProductLog", "[", 
    FractionBox["a", "x"], "]"}]}], "+", 
  RowBox[{"x", " ", 
   SuperscriptBox[
    RowBox[{"ProductLog", "[", 
     FractionBox["a", "x"], "]"}], "2"]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{3.483207168722875*^9, 3.483207386305744*^9, 
  3.4899794981817017`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"ProductLog", "[", 
     FractionBox["a", 
      SuperscriptBox["x", 
       RowBox[{"1", "/", "2"}]]], "]"}], "3"], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.483206987201861*^9, 3.483207022061987*^9}, {
   3.4832070847521315`*^9, 3.4832071990264497`*^9}, {3.483207610407987*^9, 
   3.4832076132420626`*^9}, 3.4899794981817017`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["3", "2"], " ", "x", " ", 
   SuperscriptBox[
    RowBox[{"ProductLog", "[", 
     FractionBox["a", 
      SqrtBox["x"]], "]"}], "2"]}], "+", 
  RowBox[{"x", " ", 
   SuperscriptBox[
    RowBox[{"ProductLog", "[", 
     FractionBox["a", 
      SqrtBox["x"]], "]"}], "3"]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{3.483207203042224*^9, 3.4899794981817017`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"ProductLog", "[", 
     FractionBox["a", 
      SuperscriptBox["x", 
       RowBox[{"1", "/", "3"}]]], "]"}], "4"], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.483206987201861*^9, 3.483207022061987*^9}, {
   3.4832070847521315`*^9, 3.48320721186491*^9}, 3.4899794981817017`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["4", "3"], " ", "x", " ", 
   SuperscriptBox[
    RowBox[{"ProductLog", "[", 
     FractionBox["a", 
      SuperscriptBox["x", 
       RowBox[{"1", "/", "3"}]]], "]"}], "3"]}], "+", 
  RowBox[{"x", " ", 
   SuperscriptBox[
    RowBox[{"ProductLog", "[", 
     FractionBox["a", 
      SuperscriptBox["x", 
       RowBox[{"1", "/", "3"}]]], "]"}], "4"]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{3.4832072131167107`*^9, 3.4899794981817017`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does not know how to ",
 "integrate  ",
 Cell[BoxData[
  StyleBox[
   SuperscriptBox[
    RowBox[{"ProductLog", "[", 
     FractionBox["a", 
      SuperscriptBox["x", 
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}]]], "]"}], "n"],
   FontSize->16,
   FontWeight->"Bold"]],
  CellDingbat->None,
  CellChangeTimes->{
   3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
    3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
    3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
    3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
    3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
    3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.482199478365835*^9, {
    3.4827167285874496`*^9, 3.48271673125128*^9}, {3.482718509007568*^9, 
    3.4827185116513696`*^9}, 3.4832032731012464`*^9, {3.4832052984836035`*^9, 
    3.483205305063064*^9}, 3.4832073543097363`*^9, 3.4832152840247297`*^9},
  TextAlignment->Center,
  FontFamily->"Courier New",
  FontSize->20],
 " for",
 " symbolic or numeric n:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832040958843503`*^9, 3.4832041044566765`*^9}, 3.483204218670909*^9, {
   3.483205323038912*^9, 3.483205324060381*^9}, 3.4832055331910963`*^9, {
   3.4832074394221215`*^9, 3.4832074789189153`*^9}, {3.4832075176045427`*^9, 
   3.483207541008195*^9}, {3.483207794122155*^9, 3.4832078222425904`*^9}, 
   3.4832153592028303`*^9, 3.489979509054921*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"ProductLog", "[", 
     FractionBox["a", 
      SuperscriptBox["x", 
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}]]], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.483206987201861*^9, 3.483207022061987*^9}, {
   3.4832070847521315`*^9, 3.4832071479930673`*^9}, {3.483207339127906*^9, 
   3.4832073738778734`*^9}, {3.4832075474474545`*^9, 3.483207548498966*^9}, {
   3.483208333337509*^9, 3.483208340708107*^9}, 3.489979509054921*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"ProductLog", "[", 
     FractionBox["a", 
      SuperscriptBox["x", 
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}]]], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4832082427973185`*^9, 3.4832082428974624`*^9}, 
   3.4832083468970065`*^9, 3.489979509054921*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"ProductLog", "[", 
     FractionBox["a", "x"], "]"}], "2"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.483206987201861*^9, 3.483207022061987*^9}, {
   3.4832070847521315`*^9, 3.483207167861637*^9}, 3.4832075520340495`*^9, 
   3.489979509054921*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"ProductLog", "[", 
     FractionBox["a", "x"], "]"}], "2"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.483207168722875*^9, 3.483207386305744*^9, 
  3.483307567015424*^9, 3.489979509054921*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"ProductLog", "[", 
     FractionBox["a", 
      SuperscriptBox["x", 
       RowBox[{"1", "/", "2"}]]], "]"}], "3"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.483206987201861*^9, 3.483207022061987*^9}, {
   3.4832070847521315`*^9, 3.4832071990264497`*^9}, 3.4832075538566704`*^9, {
   3.4832076537503104`*^9, 3.483207657065077*^9}, 3.489979509054921*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"ProductLog", "[", 
     FractionBox["a", 
      SqrtBox["x"]], "]"}], "3"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.483207203042224*^9, 3.4832076708549056`*^9, 
  3.489979509054921*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"ProductLog", "[", 
     FractionBox["a", 
      SuperscriptBox["x", 
       RowBox[{"1", "/", "3"}]]], "]"}], "4"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.483206987201861*^9, 3.483207022061987*^9}, {
   3.4832070847521315`*^9, 3.48320721186491*^9}, 3.4832075560498238`*^9, 
   3.489979509054921*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"ProductLog", "[", 
     FractionBox["a", 
      SuperscriptBox["x", 
       RowBox[{"1", "/", "3"}]]], "]"}], "4"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.4832072131167107`*^9, 3.4832076682211185`*^9, 
  3.489979509054921*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " does not know how to integrate  ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"LambertW", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["a", 
       SuperscriptBox["x", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}]}]]], ")"}], "n"]}],
   FontWeight->"Bold"]]],
 " for symbolic n:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832040958843503`*^9, 3.4832041044566765`*^9}, 3.483204218670909*^9, {
   3.483205323038912*^9, 3.483205324060381*^9}, 3.4832055331910963`*^9, {
   3.4832074394221215`*^9, 3.4832074789189153`*^9}, {3.4832075176045427`*^9, 
   3.483207541008195*^9}, {3.483207794122155*^9, 3.4832078222425904`*^9}, {
   3.483207870121437*^9, 3.4832078709826756`*^9}, 3.483215368105632*^9, {
   3.483306895479803*^9, 3.483307013108946*^9}, {3.483307505176504*^9, 
   3.483307506358203*^9}, {3.483308123315344*^9, 3.483308151585995*^9}, 
   3.4899795167613344`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"LambertW", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "/", 
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"1", "/", 
            RowBox[{"(", 
             RowBox[{"n", "-", "1"}], ")"}]}], ")"}]}]}], ")"}], "^", "n"}]}],
      ",", " ", "x"}], ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483206987201861*^9, 3.483207022061987*^9}, {
   3.4832070847521315`*^9, 3.48320721186491*^9}, {3.483207931039032*^9, 
   3.4832079780366116`*^9}, {3.483208033336128*^9, 3.4832080391444798`*^9}, 
   3.483307192426792*^9, 3.4899795167613344`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"LambertW", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["a", 
      SuperscriptBox["x", 
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}]]], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.4832080541460514`*^9, 3.483208054216152*^9}, {
   3.4832081084941998`*^9, 3.4832081747094126`*^9}, 3.4832082583997536`*^9, 
   3.4832083654837327`*^9, 3.4899795167613344`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"LambertW", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "/", "x"}], ")"}], "^", "2"}]}], ",", " ", "x"}], 
    ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483206987201861*^9, 3.483207022061987*^9}, {
   3.4832070847521315`*^9, 3.48320721186491*^9}, {3.483207931039032*^9, 
   3.4832079550435486`*^9}, {3.4832079924873905`*^9, 3.4832079970239134`*^9}, 
   3.4833071935884624`*^9, 3.4899795167613344`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "x", " ", "LambertW", 
   RowBox[{"(", 
    FractionBox["a", "x"], ")"}]}], "+", 
  RowBox[{"x", " ", "LambertW", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["a", "x"], ")"}], "2"]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483307589127219*^9, 3.483307613582384*^9}, 
   3.4899795167613344`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"LambertW", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "/", 
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"1", "/", "2"}], ")"}]}]}], ")"}], "^", "3"}]}], ",", " ", 
     "x"}], ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483206987201861*^9, 3.483207022061987*^9}, {
   3.4832070847521315`*^9, 3.48320721186491*^9}, {3.483207931039032*^9, 
   3.4832079780366116`*^9}, 3.4833071952107954`*^9, 3.4899795167613344`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["3", "2"], " ", "x", " ", "LambertW", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["a", 
      SqrtBox["x"]], ")"}], "2"]}], "+", 
  RowBox[{"x", " ", "LambertW", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["a", 
      SqrtBox["x"]], ")"}], "3"]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483307592071453*^9, 3.4833076140931187`*^9}, 
   3.4899795167613344`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"LambertW", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "/", 
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"1", "/", "3"}], ")"}]}]}], ")"}], "^", "4"}]}], ",", " ", 
     "x"}], ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483206987201861*^9, 3.483207022061987*^9}, {
   3.4832070847521315`*^9, 3.48320721186491*^9}, {3.483207931039032*^9, 
   3.4832079550435486`*^9}, 3.4833071969432864`*^9, 3.4899795167613344`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["4", "3"], " ", "x", " ", "LambertW", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["a", 
      SuperscriptBox["x", 
       RowBox[{"1", "/", "3"}]]], ")"}], "3"]}], "+", 
  RowBox[{"x", " ", "LambertW", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["a", 
      SuperscriptBox["x", 
       RowBox[{"1", "/", "3"}]]], ")"}], "4"]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.4833075949455853`*^9, 3.483307614934328*^9}, 
   3.4899795167613344`*^9}]
}, Closed]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Special Function Integration Problem 9", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, {3.4821973084456434`*^9, 3.482197309066536*^9}, {
   3.4821982364300194`*^9, 3.482198240976557*^9}, 3.482198357524144*^9, {
   3.4821988021534896`*^9, 3.4821988078316545`*^9}, 3.4821989164378223`*^9, {
   3.482198948964594*^9, 3.4821990020909853`*^9}, 3.4821998658029423`*^9, 
   3.4827166857758894`*^9, 3.4827184653748274`*^9, {3.4832022784710383`*^9, 
   3.483202289366706*^9}, 3.4832026639753666`*^9, 3.4832052946080303`*^9, 
   3.48320731685588*^9, 3.4832161804136734`*^9, {3.4899677493666553`*^9, 
   3.4899677749975004`*^9}, 3.4899805304591155`*^9, 3.4899827123125486`*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"ProductLog", "[", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "n"]}], "]"}], "p"], 
    SuperscriptBox["x", 
     RowBox[{
      RowBox[{"n", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], "+", "1"}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
   3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
   3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.482199478365835*^9, {
   3.4827167285874496`*^9, 3.48271673125128*^9}, {3.482718509007568*^9, 
   3.4827185116513696`*^9}, 3.4832032731012464`*^9, {3.4832052984836035`*^9, 
   3.483205305063064*^9}, 3.4832073543097363`*^9, 3.4832152840247297`*^9, {
   3.483216257804957*^9, 3.483216263322891*^9}, 3.4832163848476353`*^9, 
   3.4903834718238187`*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " knows how to integrate ",
 Cell[BoxData[
  StyleBox[
   FractionBox[
    SuperscriptBox[
     RowBox[{"ProductLog", "[", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "n"]}], "]"}], "p"], 
    SuperscriptBox["x", 
     RowBox[{
      RowBox[{"n", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], "+", "1"}]]],
   FontWeight->"Bold"]],
  CellDingbat->None,
  CellChangeTimes->{
   3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
    3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
    3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
    3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
    3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
    3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.482199478365835*^9, {
    3.4827167285874496`*^9, 3.48271673125128*^9}, {3.482718509007568*^9, 
    3.4827185116513696`*^9}, 3.4832032731012464`*^9, {3.4832052984836035`*^9, 
    3.483205305063064*^9}, 3.4832073543097363`*^9, 3.4832152840247297`*^9},
  TextAlignment->Center,
  FontFamily->"Courier New",
  FontSize->20],
 " for symbolic and numeric n and p:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832040958843503`*^9, 3.4832041044566765`*^9}, 3.483204218670909*^9, {
   3.483205323038912*^9, 3.483205324060381*^9}, 3.4832055331910963`*^9, {
   3.4832074394221215`*^9, 3.4832074789189153`*^9}, {3.4832077518914304`*^9, 
   3.4832077777085533`*^9}, {3.483207843763536*^9, 3.4832078439738383`*^9}, {
   3.483215298145034*^9, 3.483215317102293*^9}, {3.483216419247099*^9, 
   3.4832164715823536`*^9}, 3.4899795515181956`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"ProductLog", "[", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "n"]}], "]"}], "p"], 
    SuperscriptBox["x", 
     RowBox[{
      RowBox[{"n", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], "+", "1"}]]], ",", "x"}], 
  "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.483206987201861*^9, 3.483207022061987*^9}, {
   3.4832070847521315`*^9, 3.4832071479930673`*^9}, {3.483207339127906*^9, 
   3.4832073738778734`*^9}, 3.4832150161094866`*^9, {3.4832151459261537`*^9, 
   3.483215146797406*^9}, {3.483215236085797*^9, 3.483215236796819*^9}, 
   3.4832165017256975`*^9, {3.4832165396201873`*^9, 3.4832165495945296`*^9}, 
   3.4899795515181956`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"p", " ", 
     SuperscriptBox[
      RowBox[{"ProductLog", "[", 
       RowBox[{"a", " ", 
        SuperscriptBox["x", "n"]}], "]"}], 
      RowBox[{
       RowBox[{"-", "1"}], "+", "p"}]]}], 
    RowBox[{"n", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"p", "-", "1"}], ")"}], "2"], 
     SuperscriptBox["x", 
      RowBox[{"n", " ", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}]]}]]}], "-", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "n"]}], "]"}], "p"], 
   RowBox[{"n", " ", 
    RowBox[{"(", 
     RowBox[{"p", "-", "1"}], ")"}], 
    SuperscriptBox["x", 
     RowBox[{"n", " ", 
      RowBox[{"(", 
       RowBox[{"p", "-", "1"}], ")"}]}]]}]]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.483216556644667*^9, 3.4832166042030525`*^9}, {
   3.483216657389531*^9, 3.483216712508789*^9}, 3.4899795515181956`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"ProductLog", "[", 
     FractionBox["a", "x"], "]"}], "2"], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.483206987201861*^9, 3.483207022061987*^9}, {
   3.4832070847521315`*^9, 3.483207167861637*^9}, 3.4899795515181956`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "x", " ", 
   RowBox[{"ProductLog", "[", 
    FractionBox["a", "x"], "]"}]}], "+", 
  RowBox[{"x", " ", 
   SuperscriptBox[
    RowBox[{"ProductLog", "[", 
     FractionBox["a", "x"], "]"}], "2"]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4832172603665695`*^9, 3.483217261948845*^9}, 
   3.4899795515181956`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"ProductLog", "[", 
     FractionBox["a", 
      SuperscriptBox["x", 
       RowBox[{"1", "/", "2"}]]], "]"}], "3"], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.483206987201861*^9, 3.483207022061987*^9}, {
   3.4832070847521315`*^9, 3.4832071990264497`*^9}, {3.483207610407987*^9, 
   3.4832076132420626`*^9}, 3.4899795515181956`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["3", "2"], " ", "x", " ", 
   SuperscriptBox[
    RowBox[{"ProductLog", "[", 
     FractionBox["a", 
      SqrtBox["x"]], "]"}], "2"]}], "+", 
  RowBox[{"x", " ", 
   SuperscriptBox[
    RowBox[{"ProductLog", "[", 
     FractionBox["a", 
      SqrtBox["x"]], "]"}], "3"]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.48321726378148*^9, 3.483217264602661*^9}, 
   3.4899795515181956`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"ProductLog", "[", 
     FractionBox["a", 
      SuperscriptBox["x", 
       RowBox[{"1", "/", "3"}]]], "]"}], "4"], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.483206987201861*^9, 3.483207022061987*^9}, {
   3.4832070847521315`*^9, 3.48320721186491*^9}, 3.4899795515181956`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["4", "3"], " ", "x", " ", 
   SuperscriptBox[
    RowBox[{"ProductLog", "[", 
     FractionBox["a", 
      SuperscriptBox["x", 
       RowBox[{"1", "/", "3"}]]], "]"}], "3"]}], "+", 
  RowBox[{"x", " ", 
   SuperscriptBox[
    RowBox[{"ProductLog", "[", 
     FractionBox["a", 
      SuperscriptBox["x", 
       RowBox[{"1", "/", "3"}]]], "]"}], "4"]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.483217266855901*^9, 3.4832172684982624`*^9}, 
   3.4899795515181956`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does not know how to ",
 "integrate ",
 Cell[BoxData[
  StyleBox[
   FractionBox[
    SuperscriptBox[
     RowBox[{"ProductLog", "[", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "n"]}], "]"}], "p"], 
    SuperscriptBox["x", 
     RowBox[{
      RowBox[{"n", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], "+", "1"}]]],
   FontWeight->"Bold"]],
  CellDingbat->None,
  CellChangeTimes->{
   3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
    3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
    3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
    3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
    3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
    3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.482199478365835*^9, {
    3.4827167285874496`*^9, 3.48271673125128*^9}, {3.482718509007568*^9, 
    3.4827185116513696`*^9}, 3.4832032731012464`*^9, {3.4832052984836035`*^9, 
    3.483205305063064*^9}, 3.4832073543097363`*^9, 3.4832152840247297`*^9},
  TextAlignment->Center,
  FontFamily->"Courier New",
  FontSize->20],
 " for",
 " symbolic or numeric n and p:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832040958843503`*^9, 3.4832041044566765`*^9}, 3.483204218670909*^9, {
   3.483205323038912*^9, 3.483205324060381*^9}, 3.4832055331910963`*^9, {
   3.4832074394221215`*^9, 3.4832074789189153`*^9}, {3.4832075176045427`*^9, 
   3.483207541008195*^9}, {3.483207794122155*^9, 3.4832078222425904`*^9}, 
   3.4832153592028303`*^9, 3.4832167848428*^9, {3.483307931038864*^9, 
   3.483307931980218*^9}, 3.489979558538208*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"ProductLog", "[", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "n"]}], "]"}], "p"], 
    SuperscriptBox["x", 
     RowBox[{
      RowBox[{"n", " ", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], "+", "1"}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.483206987201861*^9, 3.483207022061987*^9}, {
   3.4832070847521315`*^9, 3.4832071479930673`*^9}, {3.483207339127906*^9, 
   3.4832073738778734`*^9}, 3.4832150161094866`*^9, {3.4832151459261537`*^9, 
   3.483215146797406*^9}, {3.483215236085797*^9, 3.483215236796819*^9}, 
   3.4832165017256975`*^9, {3.4832165396201873`*^9, 3.4832165495945296`*^9}, {
   3.48321681839104*^9, 3.4832168192022066`*^9}, 3.489979558538208*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"ProductLog", "[", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "n"]}], "]"}], "p"], 
    SuperscriptBox["x", 
     RowBox[{
      RowBox[{"n", " ", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], "+", "1"}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4832082427973185`*^9, 3.4832082428974624`*^9}, 
   3.4832083468970065`*^9, 3.483216842906291*^9, 3.489979558538208*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"ProductLog", "[", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "2"]}], "]"}], "p"], 
    SuperscriptBox["x", 
     RowBox[{
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], "+", "1"}]]], 
   RowBox[{"\[DifferentialD]", "x", " "}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.483216511029075*^9, 3.4832165111192045`*^9}, 
   3.4832169158211374`*^9, {3.483217087377824*^9, 3.4832170945281057`*^9}, 
   3.483217694801256*^9, 3.489979558538208*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"ProductLog", "[", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "2"]}], "]"}], "p"], 
    SuperscriptBox["x", 
     RowBox[{
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], "+", "1"}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4832172217510433`*^9, 3.4832172218612013`*^9}, 
   3.489979558538208*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"ProductLog", "[", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "n"]}], "]"}], "3"], 
    SuperscriptBox["x", 
     RowBox[{
      RowBox[{"n", " ", 
       RowBox[{"(", 
        RowBox[{"3", "-", "1"}], ")"}]}], "+", "1"}]]], 
   RowBox[{"\[DifferentialD]", "x", " "}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.483216511029075*^9, 3.4832165111192045`*^9}, 
   3.4832169158211374`*^9, {3.483217059087144*^9, 3.483217077213208*^9}, 
   3.483217693078779*^9, 3.489979558538208*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"ProductLog", "[", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "n"]}], "]"}], "3"], 
    SuperscriptBox["x", 
     RowBox[{
      RowBox[{"2", "n"}], "+", "1"}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4832172320959187`*^9, 3.4832172321760335`*^9}, {
   3.4832176521999984`*^9, 3.4832176567565503`*^9}, 3.489979558538208*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"ProductLog", "[", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "2"]}], "]"}], "3"], 
    SuperscriptBox["x", 
     RowBox[{
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"3", "-", "1"}], ")"}]}], "+", "1"}]]], 
   RowBox[{"\[DifferentialD]", "x", " "}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.483216511029075*^9, 3.4832165111192045`*^9}, 
   3.4832169158211374`*^9, {3.483217059087144*^9, 3.4832171046827073`*^9}, {
   3.4832175514351053`*^9, 3.483217603620144*^9}, {3.4832176738611455`*^9, 
   3.4832176894535666`*^9}, 3.489979558538208*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"ProductLog", "[", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "2"]}], "]"}], "3"], 
    SuperscriptBox["x", "5"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.483217240127467*^9, 3.4832172402075825`*^9}, 
   3.4832175445652275`*^9, 3.489979558538208*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " does not know how to ",
 "integrate ",
 Cell[BoxData[
  StyleBox[
   FractionBox[
    RowBox[{"LambertW", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", " ", 
        SuperscriptBox["x", "n"]}], ")"}], "p"]}], 
    SuperscriptBox["x", 
     RowBox[{
      RowBox[{"n", " ", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], "+", "1"}]]],
   FontWeight->"Bold"]],
  CellDingbat->None,
  CellChangeTimes->{
   3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
    3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
    3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
    3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
    3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
    3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.482199478365835*^9, {
    3.4827167285874496`*^9, 3.48271673125128*^9}, {3.482718509007568*^9, 
    3.4827185116513696`*^9}, 3.4832032731012464`*^9, {3.4832052984836035`*^9, 
    3.483205305063064*^9}, 3.4832073543097363`*^9, 3.4832152840247297`*^9},
  TextAlignment->Center,
  FontFamily->"Courier New",
  FontSize->20],
 " for",
 " symbolic or numeric n and p:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832040958843503`*^9, 3.4832041044566765`*^9}, 3.483204218670909*^9, {
   3.483205323038912*^9, 3.483205324060381*^9}, 3.4832055331910963`*^9, {
   3.4832074394221215`*^9, 3.4832074789189153`*^9}, {3.4832075176045427`*^9, 
   3.483207541008195*^9}, {3.483207794122155*^9, 3.4832078222425904`*^9}, {
   3.483207870121437*^9, 3.4832078709826756`*^9}, 3.483215368105632*^9, 
   3.4832167906811953`*^9, {3.4833078057787485`*^9, 3.4833078567520447`*^9}, {
   3.48330793619628*^9, 3.483307936967389*^9}, 3.489979564544218*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"LambertW", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "*", 
          RowBox[{"x", "^", "n"}]}], ")"}], "^", "p"}], "/", 
       RowBox[{"x", "^", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"n", "*", 
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}]}], "+", "1"}], ")"}]}]}]}], ",", 
     " ", "x"}], ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483206987201861*^9, 3.483207022061987*^9}, {
   3.4832070847521315`*^9, 3.48320721186491*^9}, {3.483207931039032*^9, 
   3.4832079780366116`*^9}, {3.483208033336128*^9, 3.4832080391444798`*^9}, {
   3.483217361371808*^9, 3.4832173889514656`*^9}, 3.483307209250984*^9, 
   3.489979564544218*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"LambertW", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", " ", 
        SuperscriptBox["x", "n"]}], ")"}], "p"]}], 
    SuperscriptBox["x", 
     RowBox[{
      RowBox[{"n", " ", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], "+", "1"}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.4832082427973185`*^9, 3.4832082428974624`*^9}, 
   3.4832083468970065`*^9, 3.483216842906291*^9, 3.483217339089768*^9, {
   3.4833078401681986`*^9, 3.483307846967976*^9}, 3.489979564544218*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"LambertW", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "*", 
          RowBox[{"x", "^", "2"}]}], ")"}], "^", "p"}], "/", 
       RowBox[{"x", "^", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", 
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}]}], "+", "1"}], ")"}]}]}]}], ",", 
     " ", "x"}], ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483206987201861*^9, 3.483207022061987*^9}, {
   3.4832070847521315`*^9, 3.48320721186491*^9}, {3.483207931039032*^9, 
   3.4832079780366116`*^9}, {3.483208033336128*^9, 3.4832080391444798`*^9}, {
   3.483217361371808*^9, 3.4832173889514656`*^9}, {3.483217430921816*^9, 
   3.4832174327644653`*^9}, 3.483307210302496*^9, 3.489979564544218*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"LambertW", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", " ", 
        SuperscriptBox["x", "2"]}], ")"}], "p"]}], 
    SuperscriptBox["x", 
     RowBox[{
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], "+", "1"}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.4832172217510433`*^9, 3.4832172218612013`*^9}, 
   3.483217342444592*^9, {3.4833078405787888`*^9, 3.4833078471782784`*^9}, 
   3.489979564544218*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"LambertW", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "*", 
          RowBox[{"x", "^", "n"}]}], ")"}], "^", "3"}], "/", 
       RowBox[{"x", "^", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"n", "*", 
           RowBox[{"(", 
            RowBox[{"3", "-", "1"}], ")"}]}], "+", "1"}], ")"}]}]}]}], ",", 
     " ", "x"}], ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483206987201861*^9, 3.483207022061987*^9}, {
   3.4832070847521315`*^9, 3.48320721186491*^9}, {3.483207931039032*^9, 
   3.4832079780366116`*^9}, {3.483208033336128*^9, 3.4832080391444798`*^9}, {
   3.483217361371808*^9, 3.4832173889514656`*^9}, {3.4832174460035024`*^9, 
   3.483217447485634*^9}, 3.483307211674469*^9, 3.489979564544218*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"LambertW", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", " ", 
        SuperscriptBox["x", "n"]}], ")"}], "3"]}], 
    SuperscriptBox["x", 
     RowBox[{
      RowBox[{"2", "n"}], "+", "1"}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.4832172320959187`*^9, 3.4832172321760335`*^9}, 
   3.483217345929603*^9, {3.4832175219226685`*^9, 3.48321752515732*^9}, {
   3.4833078409292927`*^9, 3.483307847398595*^9}, 3.489979564544218*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"LambertW", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "*", 
          RowBox[{"x", "^", "2"}]}], ")"}], "^", "3"}], "/", 
       RowBox[{"x", "^", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", 
           RowBox[{"(", 
            RowBox[{"3", "-", "1"}], ")"}]}], "+", "1"}], ")"}]}]}]}], ",", 
     " ", "x"}], ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483206987201861*^9, 3.483207022061987*^9}, {
   3.4832070847521315`*^9, 3.48320721186491*^9}, {3.483207931039032*^9, 
   3.4832079780366116`*^9}, {3.483208033336128*^9, 3.4832080391444798`*^9}, {
   3.483217361371808*^9, 3.4832173889514656`*^9}, {3.4832174460035024`*^9, 
   3.483217466272648*^9}, 3.483307213226701*^9, 3.489979564544218*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"LambertW", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", " ", 
        SuperscriptBox["x", "2"]}], ")"}], "3"]}], 
    SuperscriptBox["x", "5"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483217240127467*^9, 3.4832172402075825`*^9}, 
   3.4832175030655537`*^9, {3.483307841419998*^9, 3.4833078478392286`*^9}, 
   3.4833079139542975`*^9, 3.489979564544218*^9}]
}, Closed]]
}, Open  ]]
},
AutoGeneratedPackage->None,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  None, None, None}},
PrintingOptions->{"FacingPages"->False,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->28.8},
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 1065, 16, 69, "Title"],
Cell[1635, 40, 951, 22, 68, "Subtitle"],
Cell[CellGroupData[{
Cell[2611, 66, 1460, 23, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[4074, 91, 744, 15, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[4821, 108, 563, 18, 62, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[5387, 128, 818, 16, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[6208, 146, 971, 33, 69, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[7182, 181, 844, 17, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[8029, 200, 1199, 41, 69, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Closed]],
Cell[CellGroupData[{
Cell[9265, 246, 1424, 22, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[10692, 270, 821, 16, 87, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[11516, 288, 711, 21, 62, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[12230, 311, 781, 16, 87, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[13014, 329, 884, 29, 71, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[13901, 360, 806, 17, 87, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[14710, 379, 1149, 37, 64, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Closed]],
Cell[CellGroupData[{
Cell[15896, 421, 1405, 22, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[17304, 445, 666, 17, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[17973, 464, 315, 9, 63, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[18291, 475, 730, 18, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[19024, 495, 325, 9, 63, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[19352, 506, 755, 19, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[20110, 527, 350, 10, 63, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}]
}, Closed]],
Cell[20475, 540, 141, 3, 4, "PageBreak",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[20653, 548, 1089, 16, 69, "Title"],
Cell[21745, 566, 974, 23, 68, "Subtitle"],
Cell[CellGroupData[{
Cell[22744, 593, 1390, 26, 31, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[24137, 621, 840, 17, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[24980, 640, 371, 10, 69, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[25354, 652, 846, 18, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[26203, 672, 689, 21, 70, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[26895, 695, 872, 19, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[27770, 716, 1054, 33, 70, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Closed]],
Cell[CellGroupData[{
Cell[28861, 754, 1218, 20, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[30082, 776, 817, 17, 87, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[30902, 795, 371, 10, 69, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[31276, 807, 853, 18, 87, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[32132, 827, 441, 12, 63, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[32576, 841, 880, 19, 87, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[33459, 862, 465, 13, 63, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Closed]],
Cell[CellGroupData[{
Cell[33961, 880, 1162, 19, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[35126, 901, 692, 19, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[35821, 922, 389, 11, 63, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[36213, 935, 732, 19, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[36948, 956, 321, 9, 69, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[37272, 967, 790, 20, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[38065, 989, 370, 10, 63, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[38438, 1001, 817, 21, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[39258, 1024, 395, 11, 63, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}]
}, Closed]],
Cell[39668, 1038, 141, 3, 4, "PageBreak",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[39846, 1046, 1014, 15, 69, "Title"],
Cell[40863, 1063, 952, 23, 72, "Subtitle"],
Cell[CellGroupData[{
Cell[41840, 1090, 1424, 27, 31, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[43267, 1119, 731, 16, 139, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[44001, 1137, 500, 15, 63, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[44504, 1154, 809, 17, 147, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[45316, 1173, 710, 22, 67, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[46029, 1197, 807, 17, 147, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[46839, 1216, 894, 28, 67, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Closed]],
Cell[CellGroupData[{
Cell[47770, 1249, 1190, 19, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[48963, 1270, 756, 17, 139, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[49722, 1289, 470, 12, 94, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[50195, 1303, 832, 18, 147, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[51030, 1323, 426, 12, 102, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[51459, 1337, 834, 18, 147, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[52296, 1357, 426, 12, 102, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Closed]],
Cell[CellGroupData[{
Cell[52759, 1374, 1162, 19, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[53924, 1395, 553, 16, 100, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[54480, 1413, 472, 12, 94, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[54955, 1427, 635, 18, 100, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[55593, 1447, 428, 12, 102, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[56024, 1461, 633, 18, 100, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[56660, 1481, 428, 12, 102, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}]
}, Closed]],
Cell[57103, 1496, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[57184, 1502, 1142, 17, 69, "Title"],
Cell[58329, 1521, 932, 21, 68, "Subtitle"],
Cell[CellGroupData[{
Cell[59286, 1546, 1362, 25, 31, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[60651, 1573, 748, 14, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[61402, 1589, 598, 19, 65, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[62003, 1610, 797, 15, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[62803, 1627, 1931, 67, 71, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[64737, 1696, 868, 17, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[65608, 1715, 3588, 126, 129, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Closed]],
Cell[CellGroupData[{
Cell[69233, 1846, 1298, 21, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[70534, 1869, 721, 14, 87, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[71258, 1885, 683, 21, 72, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[71944, 1908, 757, 15, 87, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[72704, 1925, 366, 10, 63, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[73073, 1937, 784, 16, 87, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[73860, 1955, 366, 10, 63, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Closed]],
Cell[CellGroupData[{
Cell[74263, 1970, 1287, 25, 31, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[75553, 1997, 688, 17, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[76244, 2016, 778, 23, 79, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[77025, 2041, 748, 18, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[77776, 2061, 2005, 68, 78, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[79784, 2131, 777, 19, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[80564, 2152, 3632, 126, 145, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}]
}, Closed]],
Cell[84211, 2281, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[84292, 2287, 1166, 17, 69, "Title"],
Cell[85461, 2306, 1010, 23, 68, "Subtitle"],
Cell[CellGroupData[{
Cell[86496, 2333, 1362, 25, 31, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[87861, 2360, 776, 15, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[88640, 2377, 945, 31, 70, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[89588, 2410, 872, 17, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[90463, 2429, 2718, 94, 127, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[93184, 2525, 919, 18, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[94106, 2545, 4684, 161, 185, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Closed]],
Cell[CellGroupData[{
Cell[98827, 2711, 1298, 21, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[100128, 2734, 775, 16, 87, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[100906, 2752, 946, 28, 72, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[101855, 2782, 809, 16, 87, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[102667, 2800, 417, 11, 63, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[103087, 2813, 834, 17, 87, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[103924, 2832, 420, 12, 63, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Closed]],
Cell[CellGroupData[{
Cell[104381, 2849, 1287, 25, 31, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[105671, 2876, 774, 19, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[106448, 2897, 909, 29, 79, InheritFromParent,
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[107360, 2928, 830, 19, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[108193, 2949, 2853, 100, 143, InheritFromParent,
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[111049, 3051, 857, 20, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[111909, 3073, 4938, 173, 210, InheritFromParent,
 CellGroupingRules->{GroupTogetherGrouping, 10003.}]
}, Closed]],
Cell[116862, 3249, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[116943, 3255, 1164, 17, 69, "Title"],
Cell[118110, 3274, 955, 21, 68, "Subtitle"],
Cell[CellGroupData[{
Cell[119090, 3299, 2354, 46, 34, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[121447, 3347, 397, 11, 108, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[121847, 3360, 781, 25, 114, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[122631, 3387, 371, 10, 108, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[123005, 3399, 578, 18, 112, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[123586, 3419, 371, 10, 150, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[123960, 3431, 465, 14, 93, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[124428, 3447, 397, 11, 151, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[124828, 3460, 572, 17, 106, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[125403, 3479, 395, 11, 151, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[125801, 3492, 611, 19, 106, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Closed]],
Cell[CellGroupData[{
Cell[126449, 3516, 2504, 47, 34, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[128956, 3565, 473, 12, 130, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[129432, 3579, 783, 25, 114, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[130218, 3606, 476, 12, 130, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[130697, 3620, 635, 20, 112, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[131335, 3642, 424, 11, 150, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[131762, 3655, 494, 15, 93, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[132259, 3672, 448, 12, 151, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[132710, 3686, 421, 11, 105, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[133134, 3699, 448, 12, 151, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[133585, 3713, 392, 11, 105, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Closed]],
Cell[CellGroupData[{
Cell[134014, 3729, 2595, 49, 34, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[136612, 3780, 545, 15, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[137160, 3797, 419, 10, 63, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[137582, 3809, 514, 14, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[138099, 3825, 599, 19, 82, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[138701, 3846, 539, 15, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[139243, 3863, 492, 15, 70, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[139738, 3880, 561, 15, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[140302, 3897, 410, 12, 77, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[140715, 3911, 583, 15, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[141301, 3928, 408, 12, 77, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}]
}, Closed]],
Cell[141724, 3943, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[141805, 3949, 1192, 18, 69, "Title"],
Cell[143000, 3969, 980, 21, 68, "Subtitle"],
Cell[CellGroupData[{
Cell[144005, 3994, 2404, 46, 35, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[146412, 4042, 442, 11, 135, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[146857, 4055, 742, 23, 93, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[147602, 4080, 367, 9, 135, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[147972, 4091, 505, 15, 88, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[148480, 4108, 391, 9, 135, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[148874, 4119, 421, 12, 88, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[149298, 4133, 367, 9, 163, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[149668, 4144, 432, 12, 93, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[150103, 4158, 417, 10, 165, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[150523, 4170, 496, 13, 129, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[151022, 4185, 417, 10, 165, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[151442, 4197, 733, 23, 132, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[152178, 4222, 445, 11, 165, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[152626, 4235, 939, 29, 132, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Closed]],
Cell[CellGroupData[{
Cell[153602, 4269, 2493, 47, 35, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[156098, 4318, 476, 11, 133, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[156577, 4331, 337, 9, 94, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[156917, 4342, 452, 10, 133, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[157372, 4354, 416, 10, 94, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[157791, 4366, 496, 11, 133, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[158290, 4379, 287, 7, 94, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[158580, 4388, 413, 10, 175, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[158996, 4400, 428, 12, 93, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[159427, 4414, 488, 12, 175, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[159918, 4428, 493, 13, 129, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[160414, 4443, 468, 12, 175, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[160885, 4457, 384, 10, 112, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[161272, 4469, 492, 12, 175, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[161767, 4483, 337, 9, 112, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Closed]],
Cell[CellGroupData[{
Cell[162141, 4497, 2583, 49, 35, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[164727, 4548, 594, 15, 100, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[165324, 4565, 838, 24, 105, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[166165, 4591, 513, 13, 100, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[166681, 4606, 567, 16, 97, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[167251, 4624, 555, 14, 100, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[167809, 4640, 485, 13, 97, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[168297, 4655, 533, 14, 100, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[168833, 4671, 418, 13, 105, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[169254, 4686, 584, 15, 100, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[169841, 4703, 433, 13, 151, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[170277, 4718, 611, 15, 100, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[170891, 4735, 745, 24, 154, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[171639, 4761, 633, 15, 100, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[172275, 4778, 929, 30, 154, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}]
}, Closed]],
Cell[173219, 4811, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[173300, 4817, 1213, 18, 69, "Title"],
Cell[174516, 4837, 1137, 26, 70, "Subtitle"],
Cell[CellGroupData[{
Cell[175678, 4867, 2808, 52, 35, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[178489, 4921, 690, 17, 136, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[179182, 4940, 880, 25, 102, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[180065, 4967, 392, 9, 136, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[180460, 4978, 399, 11, 90, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[180862, 4991, 502, 12, 138, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[181367, 5005, 455, 14, 102, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[181825, 5021, 447, 11, 138, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[182275, 5034, 537, 16, 94, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Closed]],
Cell[CellGroupData[{
Cell[182849, 5055, 2806, 54, 35, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[185658, 5111, 684, 16, 136, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[186345, 5129, 482, 13, 100, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[186830, 5144, 445, 11, 136, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[187278, 5157, 359, 9, 94, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[187640, 5168, 551, 13, 138, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[188194, 5183, 355, 10, 102, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[188552, 5195, 500, 13, 138, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[189055, 5210, 397, 11, 94, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Closed]],
Cell[CellGroupData[{
Cell[189489, 5226, 2192, 41, 35, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[191684, 5269, 746, 20, 100, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[192433, 5291, 558, 14, 102, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[192994, 5307, 589, 15, 100, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[193586, 5324, 397, 11, 100, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[193986, 5337, 629, 17, 100, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[194618, 5356, 480, 15, 124, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[195101, 5373, 629, 17, 100, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[195733, 5392, 560, 17, 106, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}]
}, Closed]],
Cell[196308, 5412, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[196389, 5418, 1241, 18, 69, "Title"],
Cell[197633, 5438, 1285, 30, 75, "Subtitle"],
Cell[CellGroupData[{
Cell[198943, 5472, 2920, 55, 41, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[201866, 5529, 840, 21, 144, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[202709, 5552, 1034, 33, 117, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[203746, 5587, 392, 9, 136, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[204141, 5598, 403, 11, 100, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[204547, 5611, 502, 12, 138, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[205052, 5625, 481, 15, 117, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[205536, 5642, 447, 11, 138, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[205986, 5655, 564, 17, 106, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Closed]],
Cell[CellGroupData[{
Cell[206587, 5677, 2936, 57, 41, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[209526, 5736, 914, 21, 144, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[210443, 5759, 581, 16, 108, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[211027, 5777, 666, 18, 151, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[211696, 5797, 535, 16, 115, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[212234, 5815, 664, 18, 148, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[212901, 5835, 523, 14, 112, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[213427, 5851, 746, 19, 153, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[214176, 5872, 447, 12, 117, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Closed]],
Cell[CellGroupData[{
Cell[214660, 5889, 3055, 59, 41, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[217718, 5950, 880, 24, 100, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[218601, 5976, 672, 18, 108, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[219276, 5996, 928, 24, 100, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[220207, 6022, 628, 18, 115, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[220838, 6042, 928, 24, 100, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[221769, 6068, 611, 16, 112, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[222383, 6086, 928, 24, 100, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[223314, 6112, 540, 14, 117, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
