(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     83166,       2111]
NotebookOptionsPosition[     76322,       1926]
NotebookOutlinePosition[     77382,       1964]
CellTagsIndexPosition[     77339,       1961]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Inverse Trig Function Integration Problem 1", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, {3.4821973084456434`*^9, 3.482197309066536*^9}, {
   3.4821982364300194`*^9, 3.482198240976557*^9}, 3.482198357524144*^9, {
   3.4821988021534896`*^9, 3.4821988078316545`*^9}, 3.4821989164378223`*^9, {
   3.482198948964594*^9, 3.4821989513480206`*^9}, 3.482199858161955*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"ArcSec", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
   3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
   3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.48219937864244*^9, 
   3.49007518135998*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " uses the substitution u=a+b x to generalize rule:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443225459641647`*^9, 3.4443225485078225`*^9}, {
   3.4466948911496077`*^9, 3.42301074665625*^9}, 3.42317159478125*^9, {
   3.423174840640625*^9, 3.423174854046875*^9}, {3.4233322945*^9, 
   3.4233323091875*^9}, {3.42333236403125*^9, 3.423332366546875*^9}, {
   3.423332643984375*^9, 3.42333264684375*^9}, {3.423338772921875*^9, 
   3.423338774734375*^9}, 3.423341072796875*^9, {3.423341460375*^9, 
   3.4233414605625*^9}, {3.42335786965625*^9, 3.423357883921875*^9}, {
   3.455347583937736*^9, 3.455347624856574*^9}, 3.4821992623151693`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{"ArcSec", "[", "x", "]"}], ",", " ", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, 3.4553158897136803`*^9, {
   3.455317893494976*^9, 3.455317894065797*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", " ", 
   RowBox[{"ArcSec", "[", "x", "]"}]}], "-", 
  RowBox[{"ArcTanh", "[", 
   SqrtBox[
    RowBox[{"1", "-", 
     FractionBox["1", 
      SuperscriptBox["x", "2"]]}]], "]"}]}]], "Output",
 CellChangeTimes->{3.4553178950371933`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{"ArcSec", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}], ",", " ", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, 3.4553158897136803`*^9, 
   3.455317890901246*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], " ", 
    RowBox[{"ArcSec", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}], "b"], "-", 
  FractionBox[
   RowBox[{"ArcTanh", "[", 
    SqrtBox[
     RowBox[{"1", "-", 
      FractionBox["1", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "2"]]}]], "]"}], "b"]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443499554871235`*^9, 3.4443499625572896`*^9}, {
   3.446683635064152*^9, 3.423171727*^9}, {3.42361697475*^9, 
   3.42361697940625*^9}, 3.4553158954319024`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "does ",
 StyleBox["not",
  FontSlant->"Italic"],
 " use the substitution u=a+b x to generalize rule:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500256179667`*^9}, {3.4466836176090527`*^9, 3.446683618790752*^9}, {
   3.4466950388319645`*^9, 3.423171727*^9}, {3.423617028171875*^9, 
   3.4236170379375*^9}, {3.4553180024816914`*^9, 3.455318021799469*^9}, 
   3.4553477183610272`*^9, 3.4821993033241377`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"ArcSec", "[", "x", "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
   3.4443498869285407`*^9}, {3.444349974083864*^9, 3.423171727*^9}, 
   3.423616899578125*^9, {3.4553158927981153`*^9, 3.455315958021902*^9}, {
   3.4553178494416304`*^9, 3.4553178500224657`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", " ", 
   RowBox[{"ArcSec", "[", "x", "]"}]}], "-", 
  FractionBox[
   RowBox[{
    SqrtBox[
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["x", "2"]}]], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"x", "+", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["x", "2"]}]]}], ")"}]}], "]"}]}], 
   RowBox[{
    SqrtBox[
     RowBox[{"1", "-", 
      FractionBox["1", 
       SuperscriptBox["x", "2"]]}]], " ", "x"}]]}]], "Output",
 CellChangeTimes->{3.455317850933776*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"ArcSec", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
   3.4443498869285407`*^9}, {3.444349974083864*^9, 3.423171727*^9}, 
   3.423616899578125*^9, {3.4553158927981153`*^9, 3.455315958021902*^9}, 
   3.455317846377224*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", " ", 
   RowBox[{"ArcSec", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}]}], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], " ", 
    SqrtBox[
     FractionBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["a", "2"], "+", 
       RowBox[{"2", " ", "a", " ", "b", " ", "x"}], "+", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", 
        SuperscriptBox["x", "2"]}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "2"]]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", " ", 
       RowBox[{"ArcTan", "[", 
        FractionBox["1", 
         SqrtBox[
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["a", "2"], "+", 
           RowBox[{"2", " ", "a", " ", "b", " ", "x"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["x", "2"]}]}]]], "]"}]}], "+", 
      RowBox[{"Log", "[", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}], "+", 
          SqrtBox[
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["a", "2"], "+", 
            RowBox[{"2", " ", "a", " ", "b", " ", "x"}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["x", "2"]}]}]]}], ")"}]}], "]"}]}], ")"}]}], 
   RowBox[{"b", " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["a", "2"], "+", 
      RowBox[{"2", " ", "a", " ", "b", " ", "x"}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["x", "2"]}]}]]}]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.444349997838021*^9, {3.446683614354373*^9, 3.423171727*^9}, 
   3.4236169960625*^9, {3.455315908510709*^9, 3.455315958642795*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " uses the substitution u=a+b x to generalize rule:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500407697535`*^9}, {3.444350203233365*^9, 3.4443502040245028`*^9}, {
   3.444350234528365*^9, 3.4443502387243986`*^9}, {3.4466836227764835`*^9, 
   3.4466836230168285`*^9}, {3.4466839811618156`*^9, 
   3.4466839896239843`*^9}, {3.4466950433384447`*^9, 3.42301083234375*^9}, 
   3.423171727*^9, 3.423617053328125*^9, {3.45531823383436*^9, 
   3.4553182380303936`*^9}, {3.455347750347021*^9, 3.455347754362795*^9}, 
   3.4821993236032977`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"arcsec", 
      RowBox[{"(", "x", ")"}]}], ",", " ", "x"}], ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444350078924618*^9, 3.423171727*^9}, {
  3.4236169183125*^9, 3.423616928921875*^9}, {3.4553159685370226`*^9, 
  3.4553159764283695`*^9}, {3.455318035769557*^9, 3.45531803655068*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", " ", 
   RowBox[{"ArcSec", "[", "x", "]"}]}], "-", 
  RowBox[{"Log", "[", 
   RowBox[{"x", "+", 
    RowBox[{
     SqrtBox[
      RowBox[{"1", "-", 
       FractionBox["1", 
        SuperscriptBox["x", "2"]]}]], " ", "x"}]}], "]"}]}]], "Output",
 CellChangeTimes->{{3.4553181657664833`*^9, 3.4553181718552384`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"arcsec", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}]}], ",", " ", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444350078924618*^9, 3.423171727*^9}, {
   3.4236169183125*^9, 3.423616928921875*^9}, {3.4553159685370226`*^9, 
   3.4553159764283695`*^9}, 3.4553180327552223`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"a", " ", 
    RowBox[{"ArcSec", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}], "b"], "+", 
  RowBox[{"x", " ", 
   RowBox[{"ArcSec", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}]}], "-", 
  FractionBox[
   RowBox[{"Log", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], " ", 
      SqrtBox[
       RowBox[{"1", "-", 
        FractionBox["1", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}], ")"}], "2"]]}]]}]}], "]"}], 
   "b"]}]], "Output",
 CellChangeTimes->{3.4553182682238097`*^9}]
}, Closed]],

Cell["", "Text"],

Cell["\<\
Note that these systems give similar results to the above for the arccosecant \
function.\
\>", "Subsubtitle",
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832040958843503`*^9, 3.4832041044566765`*^9}, 3.483204218670909*^9, 
   3.4833920379275217`*^9, {3.483392125182989*^9, 3.4833921454921923`*^9}, {
   3.48339221312945*^9, 3.483392219528651*^9}, {3.483392987983635*^9, 
   3.4833931408334227`*^9}, {3.4833932165322723`*^9, 3.483393223472251*^9}, {
   3.483395056508027*^9, 3.4833950705081587`*^9}, {3.4833959109166064`*^9, 
   3.483395925577688*^9}, {3.483395964633848*^9, 3.4833959819287167`*^9}, {
   3.4833961127468243`*^9, 3.483396122781253*^9}, 3.490048900827781*^9, 
   3.4900489594451337`*^9, {3.4902128221680546`*^9, 3.4902128464728975`*^9}, {
   3.4902297491741853`*^9, 3.4902297867702513`*^9}, {3.490229840621546*^9, 
   3.490229848187559*^9}, {3.4902325303566685`*^9, 3.4902325411986876`*^9}, {
   3.490232581930359*^9, 3.4902325823827596`*^9}}],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Inverse Trig Function Integration Problem 2", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, {3.4821973084456434`*^9, 3.482197309066536*^9}, {
   3.4821982364300194`*^9, 3.482198240976557*^9}, 3.482198357524144*^9, {
   3.4821988021534896`*^9, 3.4821988078316545`*^9}, 3.4821989164378223`*^9, {
   3.482198948964594*^9, 3.4821989513480206`*^9}, 3.4821998595439425`*^9, 
   3.4900736245999384`*^9, 3.490232108407127*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"ArcSec", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "n"]}], "]"}], "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.482188128485691*^9, 
   3.4900751889714155`*^9, {3.490075487566494*^9, 3.490075490226646*^9}},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " knows and takes advantage of the general rule for arbitrary n:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443225459641647`*^9, 3.4443225485078225`*^9}, {
   3.4466948911496077`*^9, 3.42301074665625*^9}, 3.42317159478125*^9, {
   3.423174840640625*^9, 3.423174854046875*^9}, {3.4233322945*^9, 
   3.4233323091875*^9}, {3.42333236403125*^9, 3.423332366546875*^9}, {
   3.423332643984375*^9, 3.42333264684375*^9}, 3.423341072609375*^9, 
   3.4561670576690483`*^9, 3.4791559290778675`*^9, 3.482175999467106*^9, {
   3.482176939178344*^9, 3.482176943534608*^9}, 3.4821770265840273`*^9, {
   3.4898048224003077`*^9, 3.4898048266603136`*^9}, {3.4898052234408693`*^9, 
   3.489805239230891*^9}, {3.4898052800709486`*^9, 3.4898052802509484`*^9}, 
   3.48987627971564*^9, 3.4898763255641203`*^9, {3.4900724202820554`*^9, 
   3.4900724213881187`*^9}}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"ArcSec", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "n"]}], "]"}], "x"], ",", " ", "x"}], 
  "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, {3.455334181485957*^9, 
   3.455334194264331*^9}, {3.4553471254684896`*^9, 3.455347126660203*^9}, {
   3.455347168590496*^9, 3.455347170423131*^9}, {3.4553474605803566`*^9, 
   3.4553474615517535`*^9}, {3.4553478671349535`*^9, 3.4553479098263407`*^9}, 
   3.4553485173899746`*^9, 3.455394632988637*^9, 3.4561670329935665`*^9, {
   3.490075411405138*^9, 3.4900754121321793`*^9}, {3.4900754457081*^9, 
   3.4900754727856483`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SuperscriptBox[
     RowBox[{"ArcSec", "[", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "n"]}], "]"}], "2"]}], 
   RowBox[{"2", " ", "n"}]], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"ArcSec", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "n"]}], "]"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", 
      FractionBox["1", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SuperscriptBox["x", 
             RowBox[{"-", "n"}]]}], "a"], "+", 
          SqrtBox[
           RowBox[{"1", "-", 
            FractionBox[
             SuperscriptBox["x", 
              RowBox[{
               RowBox[{"-", "2"}], " ", "n"}]], 
             SuperscriptBox["a", "2"]]}]]}], ")"}], "2"]]}], "]"}]}], "n"], 
  "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      FractionBox["1", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SuperscriptBox["x", 
             RowBox[{"-", "n"}]]}], "a"], "+", 
          SqrtBox[
           RowBox[{"1", "-", 
            FractionBox[
             SuperscriptBox["x", 
              RowBox[{
               RowBox[{"-", "2"}], " ", "n"}]], 
             SuperscriptBox["a", "2"]]}]]}], ")"}], "2"]]}], "]"}]}], 
   RowBox[{"2", " ", "n"}]]}]], "Output",
 CellChangeTimes->{3.4900755164501457`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"ArcSec", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "5"]}], "]"}], "x"], ",", " ", "x"}], 
  "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, {
   3.444349991088315*^9, 3.423171727*^9}, {3.42361689675*^9, 
   3.423616909609375*^9}, 3.455334184320032*^9, {3.4553342246880784`*^9, 
   3.4553342261301517`*^9}, {3.4553342969019165`*^9, 3.455334298233832*^9}, {
   3.4553471997953663`*^9, 3.4553472071859937`*^9}, {3.455347873984803*^9, 
   3.4553478754368916`*^9}, {3.4553485285460157`*^9, 
   3.4553485323615026`*^9}, {3.4553946550503597`*^9, 3.455394659106192*^9}, 
   3.4561670329935665`*^9, {3.490075493648842*^9, 3.490075505557523*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "10"], " ", "\[ImaginaryI]", " ", 
   SuperscriptBox[
    RowBox[{"ArcSec", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "5"]}], "]"}], "2"]}], "-", 
  RowBox[{
   FractionBox["1", "5"], " ", 
   RowBox[{"ArcSec", "[", 
    RowBox[{"a", " ", 
     SuperscriptBox["x", "5"]}], "]"}], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", 
     FractionBox["1", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SqrtBox[
          RowBox[{"1", "-", 
           FractionBox["1", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["x", "10"]}]]}]], "+", 
         FractionBox["\[ImaginaryI]", 
          RowBox[{"a", " ", 
           SuperscriptBox["x", "5"]}]]}], ")"}], "2"]]}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "10"], " ", "\[ImaginaryI]", " ", 
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     FractionBox["1", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SqrtBox[
          RowBox[{"1", "-", 
           FractionBox["1", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["x", "10"]}]]}]], "+", 
         FractionBox["\[ImaginaryI]", 
          RowBox[{"a", " ", 
           SuperscriptBox["x", "5"]}]]}], ")"}], "2"]]}], "]"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{
  3.4553468542785378`*^9, {3.4553472025493264`*^9, 3.45534720758657*^9}, 
   3.4553478720920815`*^9, 3.455348533112582*^9, 3.45539466080864*^9, 
   3.4561670329935665`*^9, {3.4900754952689342`*^9, 3.490075502043322*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does not know the elementary form of the general rule, but returns an \
elementary form when n is numeric:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500256179667`*^9}, {3.4466836176090527`*^9, 3.446683618790752*^9}, {
   3.4466950388319645`*^9, 3.423171727*^9}, {3.423617028171875*^9, 
   3.4236170379375*^9}, {3.4553479526979876`*^9, 3.4553479664477587`*^9}, 
   3.4553488631171055`*^9, {3.455349270663128*^9, 3.4553492792855263`*^9}, 
   3.4561670329935665`*^9, 3.4821761074023085`*^9, 3.4821761454470143`*^9, 
   3.482176194828021*^9, {3.4900725066449947`*^9, 3.4900725433870964`*^9}, {
   3.490072582867355*^9, 3.4900726121470294`*^9}, {3.4900726653180704`*^9, 
   3.490072666203121*^9}, {3.4900733944427743`*^9, 3.490073418470148*^9}, {
   3.490075068831544*^9, 3.490075071602702*^9}, {3.4900760760681543`*^9, 
   3.4900760771902184`*^9}, {3.490076225986729*^9, 3.4900762261197367`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"ArcSec", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "n"]}], "]"}], "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
   3.4443498869285407`*^9}, {3.444349974083864*^9, 3.423171727*^9}, 
   3.423616899578125*^9, {3.455334328146845*^9, 3.455334346853744*^9}, {
   3.455347028589184*^9, 3.4553470351786594`*^9}, {3.455347077739859*^9, 
   3.455347084088989*^9}, {3.455347223879998*^9, 3.4553472252820144`*^9}, {
   3.455347418329603*^9, 3.4553474190906973`*^9}, {3.4553479192198477`*^9, 
   3.4553479280225058`*^9}, {3.455348103234448*^9, 3.4553481049168673`*^9}, 
   3.455348542746435*^9, 3.455394686425475*^9, 3.4561670329935665`*^9, {
   3.4900755246766167`*^9, 3.4900755251616445`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    SuperscriptBox["x", 
     RowBox[{"-", "n"}]], " ", 
    RowBox[{"HypergeometricPFQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        FractionBox["1", "2"], ",", 
        FractionBox["1", "2"], ",", 
        FractionBox["1", "2"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["3", "2"], ",", 
        FractionBox["3", "2"]}], "}"}], ",", 
      FractionBox[
       SuperscriptBox["x", 
        RowBox[{
         RowBox[{"-", "2"}], " ", "n"}]], 
       SuperscriptBox["a", "2"]]}], "]"}]}], 
   RowBox[{"a", " ", "n"}]], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"ArcSec", "[", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "n"]}], "]"}], "+", 
     RowBox[{"ArcSin", "[", 
      FractionBox[
       SuperscriptBox["x", 
        RowBox[{"-", "n"}]], "a"], "]"}]}], ")"}], " ", 
   RowBox[{"Log", "[", "x", "]"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.4553492672882752`*^9, 3.455394687366829*^9, 
  3.4561670329935665`*^9, 3.490075526286709*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"ArcSec", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "5"]}], "]"}], "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
   3.4443498869285407`*^9}, {3.4443499715902786`*^9, 3.423171727*^9}, {
   3.423616902765625*^9, 3.423616905984375*^9}, {3.455346949345237*^9, 
   3.4553469519389668`*^9}, {3.455347010242803*^9, 3.455347011544675*^9}, {
   3.4553470654321613`*^9, 3.45534706579268*^9}, {3.4553470967471905`*^9, 
   3.4553470986899843`*^9}, {3.455347239051814*^9, 3.45534724229648*^9}, {
   3.4553474305271425`*^9, 3.4553474314484673`*^9}, {3.455347940029771*^9, 
   3.45534794114137*^9}, {3.455348107600726*^9, 3.4553481090828576`*^9}, 
   3.4553485570770416`*^9, {3.45539469870313*^9, 3.4553947113312883`*^9}, 
   3.4561670329935665`*^9, {3.490075530839969*^9, 3.490075558381544*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "10"], " ", "\[ImaginaryI]", " ", 
   SuperscriptBox[
    RowBox[{"ArcSec", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "5"]}], "]"}], "2"]}], "-", 
  RowBox[{
   FractionBox["1", "5"], " ", 
   RowBox[{"ArcSec", "[", 
    RowBox[{"a", " ", 
     SuperscriptBox["x", "5"]}], "]"}], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       RowBox[{"ArcSec", "[", 
        RowBox[{"a", " ", 
         SuperscriptBox["x", "5"]}], "]"}]}]]}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "10"], " ", "\[ImaginaryI]", " ", 
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     RowBox[{"-", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        RowBox[{"ArcSec", "[", 
         RowBox[{"a", " ", 
          SuperscriptBox["x", "5"]}], "]"}]}]]}]}], "]"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{
  3.44434988769965*^9, {3.4466836278337555`*^9, 3.423171727*^9}, 
   3.4236170036875*^9, 3.455346953070594*^9, 3.455347013477454*^9, 
   3.4553470664336014`*^9, 3.45534709909056*^9, 3.455347243347992*^9, 
   3.4553474328304543`*^9, 3.455347941982579*^9, 3.4553485578681793`*^9, {
   3.45539470002503*^9, 3.4553947048119135`*^9}, 3.4561670329935665`*^9, {
   3.4900755348892007`*^9, 3.4900755540492964`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " knows the general rule for arbitary n, but does not use it when n is \
numeric:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500407697535`*^9}, {3.444350203233365*^9, 3.4443502040245028`*^9}, {
   3.444350234528365*^9, 3.4443502387243986`*^9}, {3.4466836227764835`*^9, 
   3.4466836230168285`*^9}, {3.4466839811618156`*^9, 
   3.4466839896239843`*^9}, {3.4466950433384447`*^9, 3.42301083234375*^9}, 
   3.423171727*^9, 3.423617053328125*^9, {3.4553480765961437`*^9, 
   3.455348092218608*^9}, 3.455349010609189*^9, 3.4561670329935665`*^9, {
   3.4821764906934547`*^9, 3.4821764927263775`*^9}, {3.490075024373001*^9, 
   3.490075137374464*^9}, {3.490075946222728*^9, 3.4900759807967052`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"arcsec", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "*", 
         RowBox[{"x", "^", "n"}]}], ")"}], "/", "x"}]}], ",", " ", "x"}], 
    ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.444350078924618*^9, 3.423171727*^9}, {
   3.4236169183125*^9, 3.423616928921875*^9}, {3.4553480452110147`*^9, 
   3.4553480557261343`*^9}, {3.455348571317518*^9, 3.455348579389125*^9}, {
   3.455348631163573*^9, 3.455348631474019*^9}, {3.455394722427243*^9, 
   3.4553947243399935`*^9}, 3.4561670329935665`*^9, {3.490075666313718*^9, 
   3.4900756680818186`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SuperscriptBox[
     RowBox[{"ArcSec", "[", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "n"]}], "]"}], "2"]}], 
   RowBox[{"2", " ", "n"}]], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"ArcSec", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "n"]}], "]"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          SuperscriptBox["x", 
           RowBox[{"-", "n"}]], "a"], "+", 
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox[
           RowBox[{"1", "-", 
            FractionBox[
             SuperscriptBox["x", 
              RowBox[{
               RowBox[{"-", "2"}], " ", "n"}]], 
             SuperscriptBox["a", "2"]]}]]}]}], ")"}], "2"]}], "]"}]}], "n"], 
  "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox[
           SuperscriptBox["x", 
            RowBox[{"-", "n"}]], "a"], "+", 
          RowBox[{"\[ImaginaryI]", " ", 
           SqrtBox[
            RowBox[{"1", "-", 
             FractionBox[
              SuperscriptBox["x", 
               RowBox[{
                RowBox[{"-", "2"}], " ", "n"}]], 
              SuperscriptBox["a", "2"]]}]]}]}], ")"}], "2"]}]}], "]"}]}], 
   RowBox[{"2", " ", "n"}]]}]], "Output",
 CellChangeTimes->{3.4900758705994024`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"arcsec", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "*", 
         RowBox[{"x", "^", "5"}]}], ")"}], "/", "x"}]}], ",", " ", "x"}], 
    ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.444350078924618*^9, 3.423171727*^9}, {
   3.4236169183125*^9, 3.423616928921875*^9}, {3.4553480452110147`*^9, 
   3.4553480685545807`*^9}, {3.455348699371651*^9, 3.4553487024060144`*^9}, {
   3.4553490858273473`*^9, 3.4553490905841875`*^9}, {3.455394732331485*^9, 
   3.455394734013904*^9}, {3.455395157973528*^9, 3.4553951627503967`*^9}, 
   3.4561670329935665`*^9, {3.4900756705409594`*^9, 3.4900756712249985`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"ArcSec", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "5"]}], "]"}], "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output"]
}, Closed]],

Cell["", "Text"],

Cell["\<\
Note that these systems give similar results to the above for the arccosecant \
function.\
\>", "Subsubtitle",
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832040958843503`*^9, 3.4832041044566765`*^9}, 3.483204218670909*^9, 
   3.4833920379275217`*^9, {3.483392125182989*^9, 3.4833921454921923`*^9}, {
   3.48339221312945*^9, 3.483392219528651*^9}, {3.483392987983635*^9, 
   3.4833931408334227`*^9}, {3.4833932165322723`*^9, 3.483393223472251*^9}, {
   3.483395056508027*^9, 3.4833950705081587`*^9}, {3.4833959109166064`*^9, 
   3.483395925577688*^9}, {3.483395964633848*^9, 3.4833959819287167`*^9}, {
   3.4833961127468243`*^9, 3.483396122781253*^9}, 3.490048900827781*^9, 
   3.4900489594451337`*^9, {3.4902128221680546`*^9, 3.4902128464728975`*^9}, {
   3.4902297491741853`*^9, 3.4902297867702513`*^9}, {3.490229840621546*^9, 
   3.490229848187559*^9}, {3.4902325303566685`*^9, 3.4902325411986876`*^9}, {
   3.490232581930359*^9, 3.4902325823827596`*^9}}],

Cell["", "PageBreak",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 PageBreakBelow->True,
 CellChangeTimes->{3.4561670329935665`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Inverse Trig Function Integration Problem 3", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, {3.4821973084456434`*^9, 3.482197309066536*^9}, {
   3.4821982364300194`*^9, 3.482198240976557*^9}, 3.482198357524144*^9, {
   3.4821988021534896`*^9, 3.4821988078316545`*^9}, 3.4821989164378223`*^9, {
   3.482198948964594*^9, 3.4821989513480206`*^9}, 3.4821998595439425`*^9, 
   3.4900736245999384`*^9, 3.490228394353407*^9, 3.490232110731531*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"ArcTan", "[", "x", "]"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], 
     RowBox[{"m", "/", "2"}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.482188128485691*^9, 
   3.4900751889714155`*^9, {3.490075487566494*^9, 3.490075490226646*^9}, {
   3.490228432495474*^9, 3.4902284441018944`*^9}},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " returns a relatively simple sum of (m+1)/2 terms for odd m>1:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443225459641647`*^9, 3.4443225485078225`*^9}, {
   3.4466948911496077`*^9, 3.42301074665625*^9}, 3.42317159478125*^9, {
   3.423174840640625*^9, 3.423174854046875*^9}, {3.4233322945*^9, 
   3.4233323091875*^9}, {3.42333236403125*^9, 3.423332366546875*^9}, {
   3.423332643984375*^9, 3.42333264684375*^9}, 3.423341072609375*^9, 
   3.4561670576690483`*^9, 3.4791559290778675`*^9, 3.482175999467106*^9, {
   3.482176939178344*^9, 3.482176943534608*^9}, 3.4821770265840273`*^9, {
   3.4898048224003077`*^9, 3.4898048266603136`*^9}, {3.4898052234408693`*^9, 
   3.489805239230891*^9}, {3.4898052800709486`*^9, 3.4898052802509484`*^9}, 
   3.48987627971564*^9, 3.4898763255641203`*^9, {3.4900724202820554`*^9, 
   3.4900724213881187`*^9}, {3.490228589448149*^9, 3.4902286985011406`*^9}, {
   3.4902290371829343`*^9, 3.4902290401625395`*^9}}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"ArcTan", "[", "x", "]"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], 
     RowBox[{"3", "/", "2"}]]], ",", " ", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, {3.455334181485957*^9, 
   3.455334194264331*^9}, {3.4553471254684896`*^9, 3.455347126660203*^9}, {
   3.455347168590496*^9, 3.455347170423131*^9}, {3.4553474605803566`*^9, 
   3.4553474615517535`*^9}, {3.4553478671349535`*^9, 3.4553479098263407`*^9}, 
   3.4553485173899746`*^9, 3.455394632988637*^9, 3.4561670329935665`*^9, {
   3.490075411405138*^9, 3.4900754121321793`*^9}, {3.4900754457081*^9, 
   3.4900754727856483`*^9}, {3.4902284623383265`*^9, 3.490228480172758*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"x", " ", 
    RowBox[{"ArcTan", "[", "x", "]"}]}], 
   RowBox[{"a", " ", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "2"]}]}]]}]], "+", 
  FractionBox[
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     SqrtBox[
      RowBox[{"a", "-", "b"}]]], "]"}], 
   RowBox[{"a", " ", 
    SqrtBox[
     RowBox[{"a", "-", "b"}]]}]]}]], "Output",
 CellChangeTimes->{3.4900755164501457`*^9, 3.4902285006139936`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"ArcTan", "[", "x", "]"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], 
     RowBox[{"5", "/", "2"}]]], ",", " ", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, {
   3.444349991088315*^9, 3.423171727*^9}, {3.42361689675*^9, 
   3.423616909609375*^9}, 3.455334184320032*^9, {3.4553342246880784`*^9, 
   3.4553342261301517`*^9}, {3.4553342969019165`*^9, 3.455334298233832*^9}, {
   3.4553471997953663`*^9, 3.4553472071859937`*^9}, {3.455347873984803*^9, 
   3.4553478754368916`*^9}, {3.4553485285460157`*^9, 
   3.4553485323615026`*^9}, {3.4553946550503597`*^9, 3.455394659106192*^9}, 
   3.4561670329935665`*^9, {3.490075493648842*^9, 3.490075505557523*^9}, {
   3.490228485419567*^9, 3.4902284979619884`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", 
    RowBox[{"3", " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{"a", "-", "b"}], ")"}], " ", 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}]}]]}]]}], "+", 
  FractionBox[
   RowBox[{"x", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"3", " ", "a"}], "+", 
      RowBox[{"2", " ", "b", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], " ", 
    RowBox[{"ArcTan", "[", "x", "]"}]}], 
   RowBox[{"3", " ", 
    SuperscriptBox["a", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], 
     RowBox[{"3", "/", "2"}]]}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"3", " ", "a"}], "-", 
      RowBox[{"2", " ", "b"}]}], ")"}], " ", 
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "2"]}]}]], 
      SqrtBox[
       RowBox[{"a", "-", "b"}]]], "]"}]}], 
   RowBox[{"3", " ", 
    SuperscriptBox["a", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "-", "b"}], ")"}], 
     RowBox[{"3", "/", "2"}]]}]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{
  3.4553468542785378`*^9, {3.4553472025493264`*^9, 3.45534720758657*^9}, 
   3.4553478720920815`*^9, 3.455348533112582*^9, 3.45539466080864*^9, 
   3.4561670329935665`*^9, {3.4900754952689342`*^9, 3.490075502043322*^9}, {
   3.490228490817176*^9, 3.4902284946859827`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " returns more complicated sums involving the imaginary unit:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500256179667`*^9}, {3.4466836176090527`*^9, 3.446683618790752*^9}, {
   3.4466950388319645`*^9, 3.423171727*^9}, {3.423617028171875*^9, 
   3.4236170379375*^9}, {3.4553479526979876`*^9, 3.4553479664477587`*^9}, 
   3.4553488631171055`*^9, {3.455349270663128*^9, 3.4553492792855263`*^9}, 
   3.4561670329935665`*^9, 3.4821761074023085`*^9, 3.4821761454470143`*^9, 
   3.482176194828021*^9, {3.4900725066449947`*^9, 3.4900725433870964`*^9}, {
   3.490072582867355*^9, 3.4900726121470294`*^9}, {3.4900726653180704`*^9, 
   3.490072666203121*^9}, {3.4900733944427743`*^9, 3.490073418470148*^9}, {
   3.490075068831544*^9, 3.490075071602702*^9}, {3.4900760760681543`*^9, 
   3.4900760771902184`*^9}, {3.490076225986729*^9, 3.4900762261197367`*^9}, {
   3.490229051332159*^9, 3.4902290554973664`*^9}, {3.490229613284747*^9, 
   3.4902296202111588`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"ArcTan", "[", "x", "]"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], 
     RowBox[{"3", "/", "2"}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
   3.4443498869285407`*^9}, {3.444349974083864*^9, 3.423171727*^9}, 
   3.423616899578125*^9, {3.455334328146845*^9, 3.455334346853744*^9}, {
   3.455347028589184*^9, 3.4553470351786594`*^9}, {3.455347077739859*^9, 
   3.455347084088989*^9}, {3.455347223879998*^9, 3.4553472252820144`*^9}, {
   3.455347418329603*^9, 3.4553474190906973`*^9}, {3.4553479192198477`*^9, 
   3.4553479280225058`*^9}, {3.455348103234448*^9, 3.4553481049168673`*^9}, 
   3.455348542746435*^9, 3.455394686425475*^9, 3.4561670329935665`*^9, {
   3.4900755246766167`*^9, 3.4900755251616445`*^9}, {3.4902287274703913`*^9, 
   3.490228741931617*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"x", " ", 
    RowBox[{"ArcTan", "[", "x", "]"}]}], 
   RowBox[{"a", " ", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "2"]}]}]]}]], "+", 
  FractionBox[
   RowBox[{"Log", "[", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"4", " ", "a", " ", 
       RowBox[{"(", 
        RowBox[{"a", "-", 
         RowBox[{"\[ImaginaryI]", " ", "b", " ", "x"}], "+", 
         RowBox[{
          SqrtBox[
           RowBox[{"a", "-", "b"}]], " ", 
          SqrtBox[
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox["x", "2"]}]}]]}]}], ")"}]}], 
      RowBox[{
       SqrtBox[
        RowBox[{"a", "-", "b"}]], " ", 
       RowBox[{"(", 
        RowBox[{"\[ImaginaryI]", "+", "x"}], ")"}]}]]}], "]"}], 
   RowBox[{"2", " ", "a", " ", 
    SqrtBox[
     RowBox[{"a", "-", "b"}]]}]], "+", 
  FractionBox[
   RowBox[{"Log", "[", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"4", " ", "a", " ", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"\[ImaginaryI]", " ", "b", " ", "x"}], "+", 
         RowBox[{
          SqrtBox[
           RowBox[{"a", "-", "b"}]], " ", 
          SqrtBox[
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox["x", "2"]}]}]]}]}], ")"}]}], 
      RowBox[{
       SqrtBox[
        RowBox[{"a", "-", "b"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "\[ImaginaryI]"}], "+", "x"}], ")"}]}]]}], "]"}], 
   RowBox[{"2", " ", "a", " ", 
    SqrtBox[
     RowBox[{"a", "-", "b"}]]}]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{
  3.4553492672882752`*^9, 3.455394687366829*^9, 3.4561670329935665`*^9, 
   3.490075526286709*^9, {3.4902287286559935`*^9, 3.4902287385464106`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"ArcTan", "[", "x", "]"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], 
     RowBox[{"5", "/", "2"}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
   3.4443498869285407`*^9}, {3.4443499715902786`*^9, 3.423171727*^9}, {
   3.423616902765625*^9, 3.423616905984375*^9}, {3.455346949345237*^9, 
   3.4553469519389668`*^9}, {3.455347010242803*^9, 3.455347011544675*^9}, {
   3.4553470654321613`*^9, 3.45534706579268*^9}, {3.4553470967471905`*^9, 
   3.4553470986899843`*^9}, {3.455347239051814*^9, 3.45534724229648*^9}, {
   3.4553474305271425`*^9, 3.4553474314484673`*^9}, {3.455347940029771*^9, 
   3.45534794114137*^9}, {3.455348107600726*^9, 3.4553481090828576`*^9}, 
   3.4553485570770416`*^9, {3.45539469870313*^9, 3.4553947113312883`*^9}, 
   3.4561670329935665`*^9, {3.490075530839969*^9, 3.490075558381544*^9}, {
   3.4902287514164333`*^9, 3.490228775861676*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", 
    RowBox[{"3", " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{"a", "-", "b"}], ")"}], " ", 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}]}]]}]]}], "+", 
  FractionBox[
   RowBox[{"x", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"3", " ", "a"}], "+", 
      RowBox[{"2", " ", "b", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], " ", 
    RowBox[{"ArcTan", "[", "x", "]"}]}], 
   RowBox[{"3", " ", 
    SuperscriptBox["a", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], 
     RowBox[{"3", "/", "2"}]]}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"3", " ", "a"}], "-", 
      RowBox[{"2", " ", "b"}]}], ")"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"12", " ", 
        SuperscriptBox["a", "2"], " ", 
        SqrtBox[
         RowBox[{"a", "-", "b"}]], " ", 
        RowBox[{"(", 
         RowBox[{"a", "-", 
          RowBox[{"\[ImaginaryI]", " ", "b", " ", "x"}], "+", 
          RowBox[{
           SqrtBox[
            RowBox[{"a", "-", "b"}]], " ", 
           SqrtBox[
            RowBox[{"a", "+", 
             RowBox[{"b", " ", 
              SuperscriptBox["x", "2"]}]}]]}]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", "a"}], "-", 
          RowBox[{"2", " ", "b"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[ImaginaryI]", "+", "x"}], ")"}]}]]}], "]"}]}], 
   RowBox[{"6", " ", 
    SuperscriptBox["a", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "-", "b"}], ")"}], 
     RowBox[{"3", "/", "2"}]]}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"3", " ", "a"}], "-", 
      RowBox[{"2", " ", "b"}]}], ")"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"12", " ", 
        SuperscriptBox["a", "2"], " ", 
        SqrtBox[
         RowBox[{"a", "-", "b"}]], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"\[ImaginaryI]", " ", "b", " ", "x"}], "+", 
          RowBox[{
           SqrtBox[
            RowBox[{"a", "-", "b"}]], " ", 
           SqrtBox[
            RowBox[{"a", "+", 
             RowBox[{"b", " ", 
              SuperscriptBox["x", "2"]}]}]]}]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", "a"}], "-", 
          RowBox[{"2", " ", "b"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "\[ImaginaryI]"}], "+", "x"}], ")"}]}]]}], "]"}]}], 
   RowBox[{"6", " ", 
    SuperscriptBox["a", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "-", "b"}], ")"}], 
     RowBox[{"3", "/", "2"}]]}]]}]], "Output",
 CellChangeTimes->{3.490228896577888*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " is unable to integrate the expressions:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500407697535`*^9}, {3.444350203233365*^9, 3.4443502040245028`*^9}, {
   3.444350234528365*^9, 3.4443502387243986`*^9}, {3.4466836227764835`*^9, 
   3.4466836230168285`*^9}, {3.4466839811618156`*^9, 
   3.4466839896239843`*^9}, {3.4466950433384447`*^9, 3.42301083234375*^9}, 
   3.423171727*^9, 3.423617053328125*^9, {3.4553480765961437`*^9, 
   3.455348092218608*^9}, 3.455349010609189*^9, 3.4561670329935665`*^9, {
   3.4821764906934547`*^9, 3.4821764927263775`*^9}, {3.490075024373001*^9, 
   3.490075137374464*^9}, {3.490075946222728*^9, 3.4900759807967052`*^9}, {
   3.4902292029912252`*^9, 3.4902292075620337`*^9}, {3.490229560435054*^9, 
   3.4902295689214687`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"arctan", 
      RowBox[{
       RowBox[{"(", "x", ")"}], "/", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"3", "/", "2"}], ")"}]}]}]}], ",", " ", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.444350078924618*^9, 3.423171727*^9}, {
   3.4236169183125*^9, 3.423616928921875*^9}, {3.4553480452110147`*^9, 
   3.4553480557261343`*^9}, {3.455348571317518*^9, 3.455348579389125*^9}, {
   3.455348631163573*^9, 3.455348631474019*^9}, {3.455394722427243*^9, 
   3.4553947243399935`*^9}, 3.4561670329935665`*^9, {3.490075666313718*^9, 
   3.4900756680818186`*^9}, {3.4902290769162045`*^9, 
   3.4902290923134313`*^9}, {3.4902294836673193`*^9, 3.4902294840417194`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"ArcTan", "[", "x", "]"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], 
     RowBox[{"3", "/", "2"}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output"],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"arctan", 
      RowBox[{
       RowBox[{"(", "x", ")"}], "/", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"5", "/", "2"}], ")"}]}]}]}], ",", " ", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.444350078924618*^9, 3.423171727*^9}, {
   3.4236169183125*^9, 3.423616928921875*^9}, {3.4553480452110147`*^9, 
   3.4553480685545807`*^9}, {3.455348699371651*^9, 3.4553487024060144`*^9}, {
   3.4553490858273473`*^9, 3.4553490905841875`*^9}, {3.455394732331485*^9, 
   3.455394734013904*^9}, {3.455395157973528*^9, 3.4553951627503967`*^9}, 
   3.4561670329935665`*^9, {3.4900756705409594`*^9, 3.4900756712249985`*^9}, {
   3.4902292147536464`*^9, 3.4902292175304513`*^9}, {3.4902294863037233`*^9, 
   3.4902294867561245`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"ArcTan", "[", "x", "]"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], 
     RowBox[{"5", "/", "2"}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output"]
}, Closed]],

Cell["", "Text"],

Cell["\<\
Note that these systems give similar results to the above for the \
arccotangent, hyperbolic arctangent and hyperbolic arccotangent functions.\
\>", "Subsubtitle",
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832040958843503`*^9, 3.4832041044566765`*^9}, 3.483204218670909*^9, 
   3.4833920379275217`*^9, {3.483392125182989*^9, 3.4833921454921923`*^9}, {
   3.48339221312945*^9, 3.483392219528651*^9}, {3.483392987983635*^9, 
   3.4833931408334227`*^9}, {3.4833932165322723`*^9, 3.483393223472251*^9}, {
   3.483395056508027*^9, 3.4833950705081587`*^9}, {3.4833959109166064`*^9, 
   3.483395925577688*^9}, {3.483395964633848*^9, 3.4833959819287167`*^9}, {
   3.4833961127468243`*^9, 3.483396122781253*^9}, 3.490048900827781*^9, 
   3.4900489594451337`*^9, {3.4902128221680546`*^9, 3.4902128464728975`*^9}, {
   3.4902297491741853`*^9, 3.4902297867702513`*^9}, {3.490229840621546*^9, 
   3.490229848187559*^9}, {3.490232586485567*^9, 3.4902325869223676`*^9}}],

Cell["", "PageBreak",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 PageBreakBelow->True,
 CellChangeTimes->{3.4561670329935665`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Inverse Trig Function Integration Problem 4", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, {3.4821973084456434`*^9, 3.482197309066536*^9}, {
   3.4821982364300194`*^9, 3.482198240976557*^9}, 3.482198357524144*^9, {
   3.4821988021534896`*^9, 3.4821988078316545`*^9}, 3.4821989164378223`*^9, {
   3.482198948964594*^9, 3.4821989513480206`*^9}, 3.4821998608257856`*^9, 
   3.4900736272220883`*^9, 3.4902283966622114`*^9, 3.490232113133935*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"ArcTan", "[", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
   3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
   3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.4821994219747486`*^9, 
   3.490075195031762*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " result is a relatively simple 2 term sum:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.423010751609375*^9}, 3.423171727*^9, {
   3.423617016203125*^9, 3.423617021953125*^9}, {3.45531791137068*^9, 
   3.4553179588789935`*^9}, {3.4553179909451027`*^9, 
   3.4553179942198114`*^9}, {3.455319201425688*^9, 3.4553192054414625`*^9}, {
   3.455319245589192*^9, 3.455319265838309*^9}, 3.4821997902142515`*^9, 
   3.4826463126839523`*^9, {3.490065942279535*^9, 3.490065956412343*^9}, {
   3.4900661642752323`*^9, 3.4900661670013885`*^9}}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{"ArcTan", "[", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]], "]"}], ",", " ", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, 3.4553158897136803`*^9, {
   3.455317893494976*^9, 3.455317894065797*^9}, {3.455318971945712*^9, 
   3.455319009319453*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}]]}]}], "]"}]}], 
   RowBox[{"2", " ", "b"}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}]]}]}], "]"}]}], 
   RowBox[{"2", " ", "b"}]]}]], "Output",
 CellChangeTimes->{
  3.4553178950371933`*^9, {3.455318998734232*^9, 3.455319003741432*^9}, 
   3.49006614308502*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " result is a 5 term sum, the first 3 of which are superfluous since their \
derivative is 0:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500256179667`*^9}, {3.4466836176090527`*^9, 3.446683618790752*^9}, {
   3.4466950388319645`*^9, 3.423171727*^9}, {3.423617028171875*^9, 
   3.4236170379375*^9}, {3.4553180024816914`*^9, 3.455318021799469*^9}, {
   3.4553191036951585`*^9, 3.4553191654439487`*^9}, {3.4553196444527297`*^9, 
   3.4553196775703506`*^9}, {3.455319760880144*^9, 3.455319781830269*^9}, 
   3.4821993033441668`*^9, {3.4826467354518623`*^9, 3.48264674775956*^9}, {
   3.490065968384028*^9, 3.490065993373457*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"ArcTan", "[", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
   3.4443498869285407`*^9}, {3.444349974083864*^9, 3.423171727*^9}, 
   3.423616899578125*^9, {3.4553158927981153`*^9, 3.455315958021902*^9}, {
   3.4553178494416304`*^9, 3.4553178500224657`*^9}, 3.455318975090234*^9, {
   3.4553190153481216`*^9, 3.4553190165999217`*^9}, {3.4553473965983553`*^9, 
   3.4553473981005154`*^9}, {3.490066126941097*^9, 3.490066135444583*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", " ", 
   RowBox[{"ArcTan", "[", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "x", " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", 
     RowBox[{"\[ImaginaryI]", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]]}]}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "x", " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", 
     RowBox[{"\[ImaginaryI]", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]]}]}], "]"}]}], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}]]}]}], "]"}]}], 
   RowBox[{"2", " ", "b"}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}]]}]}], "]"}]}], 
   RowBox[{"2", " ", "b"}]]}]], "Output",
 CellChangeTimes->{
  3.455317850933776*^9, {3.455319011943226*^9, 3.455319017000498*^9}, 
   3.4553473935039053`*^9, {3.490066121695797*^9, 3.4900661284231815`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Maple",
  FontSlant->"Italic"],
 " result is a complicated 6 term sum:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500407697535`*^9}, {3.444350203233365*^9, 3.4443502040245028`*^9}, {
   3.444350234528365*^9, 3.4443502387243986`*^9}, {3.4466836227764835`*^9, 
   3.4466836230168285`*^9}, {3.4466839811618156`*^9, 
   3.4466839896239843`*^9}, {3.4466950433384447`*^9, 3.42301083234375*^9}, 
   3.423171727*^9, 3.423617053328125*^9, {3.45531823383436*^9, 
   3.4553182380303936`*^9}, {3.4553206405550547`*^9, 
   3.4553206508198147`*^9}, {3.4553207642429085`*^9, 3.455320764993989*^9}, 
   3.4821993236233263`*^9, 3.4826463938206205`*^9, {3.490065905289419*^9, 
   3.490065914963972*^9}, {3.4900661713646374`*^9, 3.490066174041791*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"arctan", 
      RowBox[{"(", 
       RowBox[{"exp", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}]}], ",", " ", "x"}], 
    ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444350078924618*^9, 3.423171727*^9}, {
  3.4236169183125*^9, 3.423616928921875*^9}, {3.4553159685370226`*^9, 
  3.4553159764283695`*^9}, {3.455318035769557*^9, 3.45531803655068*^9}, {
  3.4553189815094643`*^9, 3.4553189864966354`*^9}, {3.4553193016598177`*^9, 
  3.455319303131934*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     RowBox[{"ArcTan", "[", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]], "]"}], " ", 
     RowBox[{"Log", "[", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]"}], 
       RowBox[{"\[ImaginaryI]", "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}]]}]], "]"}]}], "b"]}], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"ArcTan", "[", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]], "]"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", 
      FractionBox[
       RowBox[{"1", "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}]]}]}], 
       SqrtBox[
        RowBox[{"1", "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", " ", "x"}]}], ")"}]}]]}]]]}], "]"}]}], "b"], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"ArcTan", "[", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]], "]"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"1", "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}]]}]}], 
       SqrtBox[
        RowBox[{"1", "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", " ", "x"}]}], ")"}]}]]}]]]}], "]"}]}], "b"], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}]]}], 
       RowBox[{"\[ImaginaryI]", "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}]]}]]}], "]"}]}], 
   RowBox[{"2", " ", "b"}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"1", "+", 
         RowBox[{"\[ImaginaryI]", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}]]}]}], 
        SqrtBox[
         RowBox[{"1", "+", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", " ", "x"}]}], ")"}]}]]}]]]}]}], "]"}]}], "b"], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      FractionBox[
       RowBox[{"1", "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}]]}]}], 
       SqrtBox[
        RowBox[{"1", "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", " ", "x"}]}], ")"}]}]]}]]]}], "]"}]}], 
   "b"]}]], "Output",
 CellChangeTimes->{3.4900660470185256`*^9}]
}, Closed]],

Cell["", "Text"],

Cell["\<\
Note that these systems give similar results to the above for the \
arccotangent function.\
\>", "Subsubtitle",
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832040958843503`*^9, 3.4832041044566765`*^9}, 3.483204218670909*^9, 
   3.4833920379275217`*^9, {3.483392125182989*^9, 3.4833921454921923`*^9}, {
   3.48339221312945*^9, 3.483392219528651*^9}, {3.483392987983635*^9, 
   3.4833931408334227`*^9}, {3.4833932165322723`*^9, 3.483393223472251*^9}, {
   3.483395056508027*^9, 3.4833950705081587`*^9}, {3.4833959109166064`*^9, 
   3.483395925577688*^9}, {3.483395964633848*^9, 3.4833959819287167`*^9}, {
   3.4833961127468243`*^9, 3.483396122781253*^9}, 3.490048900827781*^9, 
   3.4900489594451337`*^9, {3.4902128221680546`*^9, 3.4902128464728975`*^9}, {
   3.4902297491741853`*^9, 3.4902297867702513`*^9}, {3.490229840621546*^9, 
   3.490229848187559*^9}, {3.4902325303566685`*^9, 3.4902325411986876`*^9}, {
   3.490232581930359*^9, 3.4902325823827596`*^9}, {3.4902328812948847`*^9, 
   3.49023288435249*^9}}]
}, Open  ]]
},
AutoGeneratedPackage->None,
CellGrouping->Manual,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  None, None, None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->{{28.8, 28.8}, {14.4, 14.4}}},
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 941, 14, 69, "Title"],
Cell[1511, 38, 790, 19, 68, "Subtitle"],
Cell[CellGroupData[{
Cell[2326, 61, 1243, 20, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[3572, 83, 534, 10, 44, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[4109, 95, 275, 9, 52, "Output"],
Cell[4387, 106, 561, 12, 44, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[4951, 120, 737, 22, 67, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Closed]],
Cell[CellGroupData[{
Cell[5725, 147, 990, 19, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[6718, 168, 565, 11, 59, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[7286, 181, 621, 23, 78, "Output"],
Cell[7910, 206, 588, 13, 59, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[8501, 221, 2030, 62, 67, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Closed]],
Cell[CellGroupData[{
Cell[10568, 288, 1113, 19, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[11684, 309, 459, 11, 44, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[12146, 322, 354, 11, 52, "Output"],
Cell[12503, 335, 500, 14, 44, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[13006, 351, 770, 27, 67, "Output"]
}, Closed]],
Cell[13791, 381, 16, 0, 26, "Text"],
Cell[13810, 383, 2061, 29, 28, "Subsubtitle"],
Cell[15874, 414, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[15955, 420, 993, 15, 69, "Title"],
Cell[16951, 437, 718, 18, 72, "Subtitle"],
Cell[CellGroupData[{
Cell[17694, 459, 1449, 23, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[19146, 484, 968, 19, 59, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[20117, 505, 1577, 52, 84, "Output"],
Cell[21697, 559, 923, 18, 61, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[22623, 579, 1655, 49, 70, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Closed]],
Cell[CellGroupData[{
Cell[24315, 633, 1478, 23, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[25796, 658, 1016, 19, 60, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[26815, 679, 1117, 36, 54, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[27935, 717, 1114, 20, 62, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[29052, 739, 1450, 37, 43, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Closed]],
Cell[CellGroupData[{
Cell[30539, 781, 1268, 21, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[31810, 804, 732, 18, 44, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[32545, 824, 1543, 51, 72, "Output"],
Cell[34091, 877, 786, 18, 44, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[34880, 897, 218, 7, 46, "Output"]
}, Closed]],
Cell[35113, 907, 16, 0, 26, "Text"],
Cell[35132, 909, 2061, 29, 28, "Subsubtitle"],
Cell[37196, 940, 141, 3, 4, "PageBreak",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[37374, 948, 1015, 15, 69, "Title"],
Cell[38392, 965, 879, 23, 93, "Subtitle"],
Cell[CellGroupData[{
Cell[39296, 992, 1550, 24, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[40849, 1018, 1122, 22, 68, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[41974, 1042, 603, 22, 69, "Output"],
Cell[42580, 1066, 1081, 22, 68, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[43664, 1090, 1624, 52, 69, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Closed]],
Cell[CellGroupData[{
Cell[45325, 1147, 1535, 24, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[46863, 1173, 1177, 24, 68, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[48043, 1199, 1847, 60, 77, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[49893, 1261, 1275, 25, 68, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[51171, 1288, 2975, 100, 77, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[54183, 1393, 1334, 22, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[55520, 1417, 984, 24, 45, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[56507, 1443, 327, 11, 47, "Output"],
Cell[56837, 1456, 1042, 25, 45, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[57882, 1483, 327, 11, 47, "Output"]
}, Closed]],
Cell[58224, 1497, 16, 0, 26, "Text"],
Cell[58243, 1499, 2060, 28, 28, "Subsubtitle"],
Cell[60306, 1529, 141, 3, 4, "PageBreak",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[60484, 1537, 1017, 15, 69, "Title"],
Cell[61504, 1554, 836, 20, 68, "Subtitle"],
Cell[CellGroupData[{
Cell[62365, 1578, 1222, 21, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[63590, 1601, 677, 14, 47, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[64270, 1617, 759, 23, 46, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[65066, 1645, 1217, 21, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[66286, 1668, 834, 16, 59, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[67123, 1686, 1528, 44, 46, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[68688, 1735, 1286, 22, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[69977, 1759, 683, 18, 44, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[70663, 1779, 3496, 109, 59, "Output"]
}, Closed]],
Cell[74174, 1891, 16, 0, 26, "Text"],
Cell[74193, 1893, 2113, 30, 28, "Subsubtitle"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
