(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    157287,       4234]
NotebookOptionsPosition[    149667,       4027]
NotebookOutlinePosition[    150727,       4065]
CellTagsIndexPosition[    150684,       4062]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Inverse Hyperbolic Function Integration Problem 1", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, {3.4821973084456434`*^9, 3.482197309066536*^9}, {
   3.4821982364300194`*^9, 3.482198240976557*^9}, 3.482198357524144*^9, {
   3.4821988021534896`*^9, 3.4821988078316545`*^9}, 3.4821989164378223`*^9, {
   3.482198948964594*^9, 3.4821989770249424`*^9}, 3.4821998639402637`*^9, 
   3.4901457521946383`*^9, 3.4901481926733255`*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"ArcTanh", "[", "x", "]"}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
   3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
   3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.482199441332584*^9, {
   3.4834815653163757`*^9, 3.4834815659572973`*^9}, {3.4901457904147053`*^9, 
   3.490145818447955*^9}, {3.490146761836412*^9, 3.490146763115614*^9}, {
   3.4901469062926655`*^9, 3.490146908195869*^9}, 3.490147670977209*^9, 
   3.490148293309102*^9, {3.4902117130873065`*^9, 3.4902117160669117`*^9}},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " integrates the expression by expanding it using the identity arctanh(z) = \
1/2 (log(1+z)-log(1-z)):"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443225459641647`*^9, 3.4443225485078225`*^9}, {
   3.4466948911496077`*^9, 3.42301074665625*^9}, 3.42317159478125*^9, {
   3.423174840640625*^9, 3.423174854046875*^9}, {3.4233322945*^9, 
   3.4233323091875*^9}, {3.42333236403125*^9, 3.423332366546875*^9}, {
   3.423332643984375*^9, 3.42333264684375*^9}, {3.423338772921875*^9, 
   3.423338774734375*^9}, 3.423341072796875*^9, {3.423341460375*^9, 
   3.4233414605625*^9}, {3.42335786965625*^9, 3.423357883921875*^9}, {
   3.455347583937736*^9, 3.455347624856574*^9}, 3.4553489047269373`*^9, 
   3.4821992623552275`*^9, {3.4901462939291897`*^9, 3.4901463311664553`*^9}, {
   3.4901464136906004`*^9, 3.490146448338261*^9}, {3.4901466420282016`*^9, 
   3.4901466446334057`*^9}, {3.490146979175994*^9, 3.490147018896064*^9}, {
   3.49014785956594*^9, 3.4901478680991554`*^9}, {3.490208912008787*^9, 
   3.490208956515665*^9}, {3.4902095456818995`*^9, 3.49020957427675*^9}, {
   3.490209819789981*^9, 3.4902098250471907`*^9}, {3.4902118069994717`*^9, 
   3.490211808996275*^9}, {3.4902121317608423`*^9, 3.4902121356608486`*^9}}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"ArcTanh", "[", "x", "]"}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}]], ",", " ", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, {3.455334181485957*^9, 
   3.455334194264331*^9}, {3.4553471254684896`*^9, 3.455347126660203*^9}, {
   3.455347168590496*^9, 3.455347170423131*^9}, {3.4553474605803566`*^9, 
   3.4553474615517535`*^9}, {3.4553478671349535`*^9, 3.4553479098263407`*^9}, 
   3.4553485173899746`*^9, {3.483481569372208*^9, 3.4834815699029713`*^9}, {
   3.4901458288063726`*^9, 3.4901458649828367`*^9}, {3.4901467652216177`*^9, 
   3.4901467684976234`*^9}, {3.490146910364273*^9, 3.4901469119086757`*^9}, 
   3.4901476752360163`*^9, {3.4902117428521585`*^9, 3.490211745847364*^9}, {
   3.490212063947523*^9, 3.490212065226725*^9}, {3.490212098922784*^9, 
   3.4902120998275857`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "x"}], "]"}], " ", 
    RowBox[{"Log", "[", 
     FractionBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], 
      RowBox[{"a", "-", "b"}]], "]"}]}], 
   RowBox[{"2", " ", "b"}]], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", "x"}], "]"}], " ", 
    RowBox[{"Log", "[", 
     FractionBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], 
      RowBox[{"a", "+", "b"}]], "]"}]}], 
   RowBox[{"2", " ", "b"}]], "-", 
  FractionBox[
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     FractionBox[
      RowBox[{"b", " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", "x"}], ")"}]}], 
      RowBox[{"a", "+", "b"}]]}], "]"}], 
   RowBox[{"2", " ", "b"}]], "+", 
  FractionBox[
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "x"}], ")"}]}], 
       RowBox[{"a", "-", "b"}]]}]}], "]"}], 
   RowBox[{"2", " ", "b"}]]}]], "Output",
 CellChangeTimes->{
  3.4553471757908497`*^9, 3.455347464195555*^9, 3.4553478642307777`*^9, {
   3.4553479001924877`*^9, 3.455347905069501*^9}, 3.455348519012307*^9, 
   3.4834815773737135`*^9, {3.4901458393519917`*^9, 3.4901458654976377`*^9}, {
   3.4901467707752275`*^9, 3.4901467755488358`*^9}, 3.4901469140458794`*^9, 
   3.490147678402822*^9, 3.490211751993775*^9, {3.490212065850726*^9, 
   3.490212070827135*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does ",
 StyleBox["not",
  FontSlant->"Italic"],
 " integrate the expression using the identity since it returns a complicated \
result:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500256179667`*^9}, {3.4466836176090527`*^9, 3.446683618790752*^9}, {
   3.4466950388319645`*^9, 3.423171727*^9}, {3.423617028171875*^9, 
   3.4236170379375*^9}, {3.4553479526979876`*^9, 3.4553479664477587`*^9}, 
   3.4553488631171055`*^9, {3.455349270663128*^9, 3.4553492792855263`*^9}, 
   3.4821993033942385`*^9, {3.4901461922558117`*^9, 3.490146250311514*^9}, {
   3.490146703164709*^9, 3.4901467180783353`*^9}, {3.4901468663877954`*^9, 
   3.4901468754358115`*^9}, {3.4902095985815926`*^9, 
   3.4902096159912233`*^9}, {3.4902096750217266`*^9, 3.4902096759109287`*^9}, 
   3.490209788418326*^9, {3.4902098449840255`*^9, 3.49020987610608*^9}, {
   3.490212150028474*^9, 3.4902121822737303`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"ArcTanh", "[", "x", "]"}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
   3.4443498869285407`*^9}, {3.444349974083864*^9, 3.423171727*^9}, 
   3.423616899578125*^9, {3.455334328146845*^9, 3.455334346853744*^9}, {
   3.455347028589184*^9, 3.4553470351786594`*^9}, {3.455347077739859*^9, 
   3.455347084088989*^9}, {3.455347223879998*^9, 3.4553472252820144`*^9}, {
   3.455347418329603*^9, 3.4553474190906973`*^9}, {3.4553479192198477`*^9, 
   3.4553479280225058`*^9}, {3.455348103234448*^9, 3.4553481049168673`*^9}, 
   3.455348542746435*^9, {3.483481589411022*^9, 3.483481589851656*^9}, 
   3.490146130994504*^9, 3.490146788044458*^9, {3.4901469204886904`*^9, 
   3.4901469227038946`*^9}, 3.4901476840968323`*^9, {3.4902117640681963`*^9, 
   3.490211777141019*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"8", " ", "b"}]], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["\[Pi]", "2"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox[
      RowBox[{"ArcTanh", "[", 
       FractionBox["a", "b"], "]"}], "2"]}], "+", 
    RowBox[{"4", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
     RowBox[{"ArcTanh", "[", "x", "]"}]}], "+", 
    RowBox[{"8", " ", 
     RowBox[{"ArcTanh", "[", 
      FractionBox["a", "b"], "]"}], " ", 
     RowBox[{"ArcTanh", "[", "x", "]"}]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox[
      RowBox[{"ArcTanh", "[", "x", "]"}], "2"]}], "-", 
    RowBox[{"4", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", 
         RowBox[{"ArcTanh", "[", "x", "]"}]}]]}], "]"}]}], "-", 
    RowBox[{"8", " ", 
     RowBox[{"ArcTanh", "[", "x", "]"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", 
         RowBox[{"ArcTanh", "[", "x", "]"}]}]]}], "]"}]}], "+", 
    RowBox[{"8", " ", 
     RowBox[{"ArcTanh", "[", 
      FractionBox["a", "b"], "]"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"ArcTanh", "[", 
            FractionBox["a", "b"], "]"}], "+", 
           RowBox[{"ArcTanh", "[", "x", "]"}]}], ")"}]}]]}], "]"}]}], "+", 
    RowBox[{"8", " ", 
     RowBox[{"ArcTanh", "[", "x", "]"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"ArcTanh", "[", 
            FractionBox["a", "b"], "]"}], "+", 
           RowBox[{"ArcTanh", "[", "x", "]"}]}], ")"}]}]]}], "]"}]}], "+", 
    RowBox[{"4", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
     RowBox[{"Log", "[", 
      FractionBox["2", 
       SqrtBox[
        RowBox[{"1", "-", 
         SuperscriptBox["x", "2"]}]]], "]"}]}], "+", 
    RowBox[{"8", " ", 
     RowBox[{"ArcTanh", "[", "x", "]"}], " ", 
     RowBox[{"Log", "[", 
      FractionBox["2", 
       SqrtBox[
        RowBox[{"1", "-", 
         SuperscriptBox["x", "2"]}]]], "]"}]}], "+", 
    RowBox[{"4", " ", 
     RowBox[{"ArcTanh", "[", "x", "]"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"]}], "]"}]}], "+", 
    RowBox[{"8", " ", 
     RowBox[{"ArcTanh", "[", "x", "]"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{
         RowBox[{"ArcTanh", "[", 
          FractionBox["a", "b"], "]"}], "+", 
         RowBox[{"ArcTanh", "[", "x", "]"}]}], "]"}]}], "]"}]}], "-", 
    RowBox[{"8", " ", 
     RowBox[{"ArcTanh", "[", 
      FractionBox["a", "b"], "]"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{
         RowBox[{"ArcTanh", "[", 
          FractionBox["a", "b"], "]"}], "+", 
         RowBox[{"ArcTanh", "[", "x", "]"}]}], "]"}]}], "]"}]}], "-", 
    RowBox[{"8", " ", 
     RowBox[{"ArcTanh", "[", "x", "]"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{
         RowBox[{"ArcTanh", "[", 
          FractionBox["a", "b"], "]"}], "+", 
         RowBox[{"ArcTanh", "[", "x", "]"}]}], "]"}]}], "]"}]}], "-", 
    RowBox[{"4", " ", 
     RowBox[{"PolyLog", "[", 
      RowBox[{"2", ",", 
       RowBox[{"-", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", 
          RowBox[{"ArcTanh", "[", "x", "]"}]}]]}]}], "]"}]}], "-", 
    RowBox[{"4", " ", 
     RowBox[{"PolyLog", "[", 
      RowBox[{"2", ",", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"ArcTanh", "[", 
            FractionBox["a", "b"], "]"}], "+", 
           RowBox[{"ArcTanh", "[", "x", "]"}]}], ")"}]}]]}], "]"}]}]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{
  3.4553492672882752`*^9, 3.4834815917443776`*^9, 3.4901461331629076`*^9, 
   3.4901467917104645`*^9, 3.490146925355899*^9, 3.490147686343236*^9, {
   3.490211767063401*^9, 3.4902117787010217`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", "x"}], "]"}], "-", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", "x"}], "]"}]}], 
    RowBox[{"2", 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
   3.4443498869285407`*^9}, {3.444349974083864*^9, 3.423171727*^9}, 
   3.423616899578125*^9, {3.455334328146845*^9, 3.455334346853744*^9}, {
   3.455347028589184*^9, 3.4553470351786594`*^9}, {3.455347077739859*^9, 
   3.455347084088989*^9}, {3.455347223879998*^9, 3.4553472252820144`*^9}, {
   3.455347418329603*^9, 3.4553474190906973`*^9}, {3.4553479192198477`*^9, 
   3.4553479280225058`*^9}, {3.455348103234448*^9, 3.4553481049168673`*^9}, 
   3.455348542746435*^9, {3.483481589411022*^9, 3.483481589851656*^9}, 
   3.490146130994504*^9, 3.4901467369699683`*^9, {3.4901468104616976`*^9, 
   3.490146825531324*^9}, {3.490147050252119*^9, 3.4901470877857847`*^9}, {
   3.4901476946736507`*^9, 3.49014770007126*^9}, {3.4902090038305483`*^9, 
   3.4902090160609694`*^9}, {3.4902118368423243`*^9, 3.490211838417927*^9}, {
   3.4902118707567835`*^9, 3.490211876497594*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "x"}], "]"}], " ", 
    RowBox[{"Log", "[", 
     FractionBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], 
      RowBox[{"a", "-", "b"}]], "]"}]}], 
   RowBox[{"2", " ", "b"}]], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", "x"}], "]"}], " ", 
    RowBox[{"Log", "[", 
     FractionBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], 
      RowBox[{"a", "+", "b"}]], "]"}]}], 
   RowBox[{"2", " ", "b"}]], "+", 
  FractionBox[
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     FractionBox[
      RowBox[{"b", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "x"}], ")"}]}], 
      RowBox[{
       RowBox[{"-", "a"}], "+", "b"}]]}], "]"}], 
   RowBox[{"2", " ", "b"}]], "-", 
  FractionBox[
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     FractionBox[
      RowBox[{"b", "-", 
       RowBox[{"b", " ", "x"}]}], 
      RowBox[{"a", "+", "b"}]]}], "]"}], 
   RowBox[{"2", " ", "b"}]]}]], "Output",
 CellChangeTimes->{3.4902118722075863`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " integrates the expression apparently by expanding it using the identity:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443225459641647`*^9, 3.4443225485078225`*^9}, {
   3.4466948911496077`*^9, 3.42301074665625*^9}, 3.42317159478125*^9, {
   3.423174840640625*^9, 3.423174854046875*^9}, {3.4233322945*^9, 
   3.4233323091875*^9}, {3.42333236403125*^9, 3.423332366546875*^9}, {
   3.423332643984375*^9, 3.42333264684375*^9}, {3.423338772921875*^9, 
   3.423338774734375*^9}, 3.423341072796875*^9, {3.423341460375*^9, 
   3.4233414605625*^9}, {3.42335786965625*^9, 3.423357883921875*^9}, {
   3.455347583937736*^9, 3.455347624856574*^9}, 3.4553489047269373`*^9, 
   3.4821992623552275`*^9, {3.4901462939291897`*^9, 3.4901463311664553`*^9}, {
   3.4901464136906004`*^9, 3.490146448338261*^9}, {3.4901466420282016`*^9, 
   3.4901466446334057`*^9}, {3.490146979175994*^9, 3.490147018896064*^9}, {
   3.49014785956594*^9, 3.4901478680991554`*^9}, {3.490208912008787*^9, 
   3.490208956515665*^9}, {3.4902095456818995`*^9, 3.49020957427675*^9}, {
   3.490209819789981*^9, 3.4902098250471907`*^9}, {3.4902118069994717`*^9, 
   3.490211808996275*^9}, {3.4902121317608423`*^9, 3.4902121356608486`*^9}, {
   3.490212322018776*^9, 3.490212338632805*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"arctanh", 
      RowBox[{
       RowBox[{"(", "x", ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}]}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444350078924618*^9, 3.423171727*^9}, {
   3.4236169183125*^9, 3.423616928921875*^9}, {3.4553480452110147`*^9, 
   3.4553480557261343`*^9}, {3.455348571317518*^9, 3.455348579389125*^9}, {
   3.455348631163573*^9, 3.455348631474019*^9}, {3.4834816003868046`*^9, 
   3.4834816024597855`*^9}, {3.4901471509190955`*^9, 3.490147160887513*^9}, 
   3.490147464479646*^9, 3.4901477330809183`*^9, {3.4902122466862435`*^9, 
   3.490212247606645*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "x"}], "]"}], " ", 
    RowBox[{"Log", "[", 
     FractionBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], 
      RowBox[{"a", "-", "b"}]], "]"}]}], 
   RowBox[{"2", " ", "b"}]], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", "x"}], "]"}], " ", 
    RowBox[{"Log", "[", 
     FractionBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], 
      RowBox[{"a", "+", "b"}]], "]"}]}], 
   RowBox[{"2", " ", "b"}]], "-", 
  FractionBox[
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     FractionBox[
      RowBox[{"b", " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", "x"}], ")"}]}], 
      RowBox[{"a", "+", "b"}]]}], "]"}], 
   RowBox[{"2", " ", "b"}]], "+", 
  FractionBox[
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "x"}], ")"}]}], 
       RowBox[{"a", "-", "b"}]]}]}], "]"}], 
   RowBox[{"2", " ", "b"}]]}]], "Output",
 CellChangeTimes->{
  3.4553471757908497`*^9, 3.455347464195555*^9, 3.4553478642307777`*^9, {
   3.4553479001924877`*^9, 3.455347905069501*^9}, 3.455348519012307*^9, 
   3.4834815773737135`*^9, {3.4901458393519917`*^9, 3.4901458654976377`*^9}, {
   3.4901467707752275`*^9, 3.4901467755488358`*^9}, 3.4901469140458794`*^9, 
   3.490147678402822*^9, 3.490211751993775*^9, {3.490212065850726*^9, 
   3.490212070827135*^9}}]
}, Closed]],

Cell["", "Text"],

Cell["\<\
Note that these systems give similar results to the above for the hyperbolic \
arccotangent function.\
\>", "Subsubtitle",
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832040958843503`*^9, 3.4832041044566765`*^9}, 3.483204218670909*^9, 
   3.4833920379275217`*^9, {3.483392125182989*^9, 3.4833921454921923`*^9}, {
   3.48339221312945*^9, 3.483392219528651*^9}, {3.483392987983635*^9, 
   3.4833931408334227`*^9}, {3.4833932165322723`*^9, 3.483393223472251*^9}, {
   3.483395056508027*^9, 3.4833950705081587`*^9}, {3.4833959109166064`*^9, 
   3.483395925577688*^9}, {3.483395964633848*^9, 3.4833959819287167`*^9}, {
   3.4833961127468243`*^9, 3.483396122781253*^9}, 3.490048900827781*^9, 
   3.4900489594451337`*^9, {3.4902128221680546`*^9, 3.4902128464728975`*^9}, {
   3.4902329283869677`*^9, 3.4902329290265684`*^9}}],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Inverse Hyperbolic Function Integration Problem 2", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, {3.4821973084456434`*^9, 3.482197309066536*^9}, {
   3.4821982364300194`*^9, 3.482198240976557*^9}, 3.482198357524144*^9, {
   3.4821988021534896`*^9, 3.4821988078316545`*^9}, 3.4821989164378223`*^9, {
   3.482198948964594*^9, 3.4821989770249424`*^9}, 3.4821998639402637`*^9, 
   3.4901457521946383`*^9, 3.4901481926733255`*^9, 3.4902117030720887`*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"ArcTanh", "[", "x", "]"}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
   3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
   3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.482199441332584*^9, {
   3.4834815653163757`*^9, 3.4834815659572973`*^9}, {3.4901457904147053`*^9, 
   3.490145818447955*^9}, {3.490146761836412*^9, 3.490146763115614*^9}, {
   3.4901469062926655`*^9, 3.490146908195869*^9}, 3.490147670977209*^9, 
   3.490148293309102*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " is able to integrate the expression by expanding it using partial fraction \
expansion and the identity arctanh(z) = 1/2 (log(1+z)-log(1-z)):"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443225459641647`*^9, 3.4443225485078225`*^9}, {
   3.4466948911496077`*^9, 3.42301074665625*^9}, 3.42317159478125*^9, {
   3.423174840640625*^9, 3.423174854046875*^9}, {3.4233322945*^9, 
   3.4233323091875*^9}, {3.42333236403125*^9, 3.423332366546875*^9}, {
   3.423332643984375*^9, 3.42333264684375*^9}, {3.423338772921875*^9, 
   3.423338774734375*^9}, 3.423341072796875*^9, {3.423341460375*^9, 
   3.4233414605625*^9}, {3.42335786965625*^9, 3.423357883921875*^9}, {
   3.455347583937736*^9, 3.455347624856574*^9}, 3.4553489047269373`*^9, 
   3.4821992623552275`*^9, {3.4901462939291897`*^9, 3.4901463311664553`*^9}, {
   3.4901464136906004`*^9, 3.490146448338261*^9}, {3.4901466420282016`*^9, 
   3.4901466446334057`*^9}, {3.490146979175994*^9, 3.490147018896064*^9}, {
   3.49014785956594*^9, 3.4901478680991554`*^9}, {3.490208912008787*^9, 
   3.490208956515665*^9}, {3.4902095456818995`*^9, 3.49020957427675*^9}, {
   3.490209819789981*^9, 3.4902098250471907`*^9}}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"ArcTanh", "[", "x", "]"}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", "2"]}]}]], ",", " ", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, {3.455334181485957*^9, 
   3.455334194264331*^9}, {3.4553471254684896`*^9, 3.455347126660203*^9}, {
   3.455347168590496*^9, 3.455347170423131*^9}, {3.4553474605803566`*^9, 
   3.4553474615517535`*^9}, {3.4553478671349535`*^9, 3.4553479098263407`*^9}, 
   3.4553485173899746`*^9, {3.483481569372208*^9, 3.4834815699029713`*^9}, {
   3.4901458288063726`*^9, 3.4901458649828367`*^9}, {3.4901467652216177`*^9, 
   3.4901467684976234`*^9}, {3.490146910364273*^9, 3.4901469119086757`*^9}, 
   3.4901476752360163`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "x"}], "]"}], " ", 
    RowBox[{"Log", "[", 
     FractionBox[
      RowBox[{"b", "-", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"4", " ", "a", " ", "c"}]}]], "+", 
       RowBox[{"2", " ", "c", " ", "x"}]}], 
      RowBox[{"b", "-", 
       RowBox[{"2", " ", "c"}], "-", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"4", " ", "a", " ", "c"}]}]]}]], "]"}]}], 
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}]]}]], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", "x"}], "]"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"b", "-", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"4", " ", "a", " ", "c"}]}]], "+", 
        RowBox[{"2", " ", "c", " ", "x"}]}], 
       RowBox[{
        RowBox[{"-", "b"}], "-", 
        RowBox[{"2", " ", "c"}], "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"4", " ", "a", " ", "c"}]}]]}]]}], "]"}]}], 
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}]]}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", "x"}], "]"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"b", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"4", " ", "a", " ", "c"}]}]], "+", 
        RowBox[{"2", " ", "c", " ", "x"}]}], 
       RowBox[{
        RowBox[{"-", "b"}], "-", 
        RowBox[{"2", " ", "c"}], "-", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"4", " ", "a", " ", "c"}]}]]}]]}], "]"}]}], 
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}]]}]], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "x"}], "]"}], " ", 
    RowBox[{"Log", "[", 
     FractionBox[
      RowBox[{"b", "+", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"4", " ", "a", " ", "c"}]}]], "+", 
       RowBox[{"2", " ", "c", " ", "x"}]}], 
      RowBox[{"b", "-", 
       RowBox[{"2", " ", "c"}], "+", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"4", " ", "a", " ", "c"}]}]]}]], "]"}]}], 
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}]]}]], "+", 
  FractionBox[
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", "c", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", "x"}], ")"}]}], 
       RowBox[{
        RowBox[{"-", "b"}], "-", 
        RowBox[{"2", " ", "c"}], "-", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"4", " ", "a", " ", "c"}]}]]}]]}]}], "]"}], 
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}]]}]], "-", 
  FractionBox[
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", "c", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", "x"}], ")"}]}], 
       RowBox[{
        RowBox[{"-", "b"}], "-", 
        RowBox[{"2", " ", "c"}], "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"4", " ", "a", " ", "c"}]}]]}]]}]}], "]"}], 
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}]]}]], "+", 
  FractionBox[
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", "c", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "x"}], ")"}]}], 
       RowBox[{"b", "-", 
        RowBox[{"2", " ", "c"}], "-", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"4", " ", "a", " ", "c"}]}]]}]]}]}], "]"}], 
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}]]}]], "-", 
  FractionBox[
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", "c", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "x"}], ")"}]}], 
       RowBox[{"b", "-", 
        RowBox[{"2", " ", "c"}], "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"4", " ", "a", " ", "c"}]}]]}]]}]}], "]"}], 
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}]]}]]}]], "Output",
 CellChangeTimes->{
  3.4553471757908497`*^9, 3.455347464195555*^9, 3.4553478642307777`*^9, {
   3.4553479001924877`*^9, 3.455347905069501*^9}, 3.455348519012307*^9, 
   3.4834815773737135`*^9, {3.4901458393519917`*^9, 3.4901458654976377`*^9}, {
   3.4901467707752275`*^9, 3.4901467755488358`*^9}, 3.4901469140458794`*^9, 
   3.490147678402822*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is unable to integrate the expression since it does ",
 StyleBox["not",
  FontSlant->"Italic"],
 " automatically expand it:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500256179667`*^9}, {3.4466836176090527`*^9, 3.446683618790752*^9}, {
   3.4466950388319645`*^9, 3.423171727*^9}, {3.423617028171875*^9, 
   3.4236170379375*^9}, {3.4553479526979876`*^9, 3.4553479664477587`*^9}, 
   3.4553488631171055`*^9, {3.455349270663128*^9, 3.4553492792855263`*^9}, 
   3.4821993033942385`*^9, {3.4901461922558117`*^9, 3.490146250311514*^9}, {
   3.490146703164709*^9, 3.4901467180783353`*^9}, {3.4901468663877954`*^9, 
   3.4901468754358115`*^9}, {3.4902095985815926`*^9, 
   3.4902096159912233`*^9}, {3.4902096750217266`*^9, 3.4902096759109287`*^9}, 
   3.490209788418326*^9, {3.4902098449840255`*^9, 3.49020987610608*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"ArcTanh", "[", "x", "]"}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
   3.4443498869285407`*^9}, {3.444349974083864*^9, 3.423171727*^9}, 
   3.423616899578125*^9, {3.455334328146845*^9, 3.455334346853744*^9}, {
   3.455347028589184*^9, 3.4553470351786594`*^9}, {3.455347077739859*^9, 
   3.455347084088989*^9}, {3.455347223879998*^9, 3.4553472252820144`*^9}, {
   3.455347418329603*^9, 3.4553474190906973`*^9}, {3.4553479192198477`*^9, 
   3.4553479280225058`*^9}, {3.455348103234448*^9, 3.4553481049168673`*^9}, 
   3.455348542746435*^9, {3.483481589411022*^9, 3.483481589851656*^9}, 
   3.490146130994504*^9, 3.490146788044458*^9, {3.4901469204886904`*^9, 
   3.4901469227038946`*^9}, 3.4901476840968323`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"ArcTanh", "[", "x", "]"}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellChangeTimes->{3.4553492672882752`*^9, 3.4834815917443776`*^9, 
  3.4901461331629076`*^9, 3.4901467917104645`*^9, 3.490146925355899*^9, 
  3.490147686343236*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", "x"}], "]"}], "-", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", "x"}], "]"}]}], 
    RowBox[{"2", 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
   3.4443498869285407`*^9}, {3.444349974083864*^9, 3.423171727*^9}, 
   3.423616899578125*^9, {3.455334328146845*^9, 3.455334346853744*^9}, {
   3.455347028589184*^9, 3.4553470351786594`*^9}, {3.455347077739859*^9, 
   3.455347084088989*^9}, {3.455347223879998*^9, 3.4553472252820144`*^9}, {
   3.455347418329603*^9, 3.4553474190906973`*^9}, {3.4553479192198477`*^9, 
   3.4553479280225058`*^9}, {3.455348103234448*^9, 3.4553481049168673`*^9}, 
   3.455348542746435*^9, {3.483481589411022*^9, 3.483481589851656*^9}, 
   3.490146130994504*^9, 3.4901467369699683`*^9, {3.4901468104616976`*^9, 
   3.490146825531324*^9}, {3.490147050252119*^9, 3.4901470877857847`*^9}, {
   3.4901476946736507`*^9, 3.49014770007126*^9}, {3.4902090038305483`*^9, 
   3.4902090160609694`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       FractionBox[
        RowBox[{"2", " ", "c", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "x"}], ")"}]}], 
        RowBox[{"b", "+", 
         RowBox[{"2", " ", "c"}], "-", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"4", " ", "a", " ", "c"}]}]]}]]}], "]"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", "x"}], "]"}]}], 
    RowBox[{"2", " ", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       RowBox[{"4", " ", "a", " ", "c"}]}]]}]]}], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"2", " ", "c", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "x"}], ")"}]}], 
       RowBox[{"b", "+", 
        RowBox[{"2", " ", "c"}], "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"4", " ", "a", " ", "c"}]}]]}]]}], "]"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", "x"}], "]"}]}], 
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}]]}]], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "x"}], "]"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"2", " ", "c", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "x"}], ")"}]}], 
       RowBox[{"b", "-", 
        RowBox[{"2", " ", "c"}], "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"4", " ", "a", " ", "c"}]}]]}]]}], "]"}]}], 
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}]]}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "x"}], "]"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", 
      FractionBox[
       RowBox[{"2", " ", "c", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "x"}], ")"}]}], 
       RowBox[{
        RowBox[{"-", "b"}], "+", 
        RowBox[{"2", " ", "c"}], "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"4", " ", "a", " ", "c"}]}]]}]]}], "]"}]}], 
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}]]}]], "-", 
  FractionBox[
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", "c", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "x"}], ")"}]}], 
       RowBox[{"b", "+", 
        RowBox[{"2", " ", "c"}], "-", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"4", " ", "a", " ", "c"}]}]]}]]}]}], "]"}], 
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}]]}]], "+", 
  FractionBox[
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", "c", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "x"}], ")"}]}], 
       RowBox[{"b", "+", 
        RowBox[{"2", " ", "c"}], "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"4", " ", "a", " ", "c"}]}]]}]]}]}], "]"}], 
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}]]}]], "-", 
  FractionBox[
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", "c", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "x"}], ")"}]}], 
       RowBox[{"b", "-", 
        RowBox[{"2", " ", "c"}], "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"4", " ", "a", " ", "c"}]}]]}]]}]}], "]"}], 
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}]]}]], "+", 
  FractionBox[
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     FractionBox[
      RowBox[{"2", " ", "c", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "x"}], ")"}]}], 
      RowBox[{
       RowBox[{"-", "b"}], "+", 
       RowBox[{"2", " ", "c"}], "+", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"4", " ", "a", " ", "c"}]}]]}]]}], "]"}], 
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}]]}]]}]], "Output",
 CellChangeTimes->{
  3.490147718931693*^9, {3.490209000507742*^9, 3.490209006451352*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"2", " ", "c", " ", 
      RowBox[{"ArcTanh", "[", "x", "]"}]}], 
     RowBox[{
      SqrtBox[
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"4", " ", "a", " ", "c"}]}]], " ", 
      RowBox[{"(", 
       RowBox[{"b", "-", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"4", " ", "a", " ", "c"}]}]], "+", 
        RowBox[{"2", " ", "c", " ", "x"}]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "-", 
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"2", " ", "c", " ", 
      RowBox[{"ArcTanh", "[", "x", "]"}]}], 
     RowBox[{
      SqrtBox[
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"4", " ", "a", " ", "c"}]}]], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"4", " ", "a", " ", "c"}]}]], "+", 
        RowBox[{"2", " ", "c", " ", "x"}]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
   3.4443498869285407`*^9}, {3.444349974083864*^9, 3.423171727*^9}, 
   3.423616899578125*^9, {3.455334328146845*^9, 3.455334346853744*^9}, {
   3.455347028589184*^9, 3.4553470351786594`*^9}, {3.455347077739859*^9, 
   3.455347084088989*^9}, {3.455347223879998*^9, 3.4553472252820144`*^9}, {
   3.455347418329603*^9, 3.4553474190906973`*^9}, {3.4553479192198477`*^9, 
   3.4553479280225058`*^9}, {3.455348103234448*^9, 3.4553481049168673`*^9}, 
   3.455348542746435*^9, {3.483481589411022*^9, 3.483481589851656*^9}, 
   3.490146130994504*^9, 3.4901467369699683`*^9, {3.4901468104616976`*^9, 
   3.490146825531324*^9}, {3.490147050252119*^9, 3.4901470877857847`*^9}, {
   3.4901476946736507`*^9, 3.49014770007126*^9}, {3.4902090038305483`*^9, 
   3.4902090160609694`*^9}, {3.4902094023020477`*^9, 3.490209439913714*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}]]}]], 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"ArcTanh", "[", 
      FractionBox[
       RowBox[{"b", "-", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"4", " ", "a", " ", "c"}]}]]}], 
       RowBox[{"2", " ", "c"}]], "]"}], "2"], "-", 
    SuperscriptBox[
     RowBox[{"ArcTanh", "[", 
      FractionBox[
       RowBox[{"b", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"4", " ", "a", " ", "c"}]}]]}], 
       RowBox[{"2", " ", "c"}]], "]"}], "2"], "+", 
    RowBox[{"2", " ", 
     RowBox[{"ArcTanh", "[", 
      FractionBox[
       RowBox[{"b", "-", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"4", " ", "a", " ", "c"}]}]]}], 
       RowBox[{"2", " ", "c"}]], "]"}], " ", 
     RowBox[{"ArcTanh", "[", "x", "]"}]}], "-", 
    RowBox[{"2", " ", 
     RowBox[{"ArcTanh", "[", 
      FractionBox[
       RowBox[{"b", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"4", " ", "a", " ", "c"}]}]]}], 
       RowBox[{"2", " ", "c"}]], "]"}], " ", 
     RowBox[{"ArcTanh", "[", "x", "]"}]}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"ArcTanh", "[", 
      FractionBox[
       RowBox[{"b", "-", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"4", " ", "a", " ", "c"}]}]]}], 
       RowBox[{"2", " ", "c"}]], "]"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"ArcTanh", "[", 
            FractionBox[
             RowBox[{"b", "-", 
              SqrtBox[
               RowBox[{
                SuperscriptBox["b", "2"], "-", 
                RowBox[{"4", " ", "a", " ", "c"}]}]]}], 
             RowBox[{"2", " ", "c"}]], "]"}], "+", 
           RowBox[{"ArcTanh", "[", "x", "]"}]}], ")"}]}]]}], "]"}]}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"ArcTanh", "[", "x", "]"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"ArcTanh", "[", 
            FractionBox[
             RowBox[{"b", "-", 
              SqrtBox[
               RowBox[{
                SuperscriptBox["b", "2"], "-", 
                RowBox[{"4", " ", "a", " ", "c"}]}]]}], 
             RowBox[{"2", " ", "c"}]], "]"}], "+", 
           RowBox[{"ArcTanh", "[", "x", "]"}]}], ")"}]}]]}], "]"}]}], "-", 
    RowBox[{"2", " ", 
     RowBox[{"ArcTanh", "[", 
      FractionBox[
       RowBox[{"b", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"4", " ", "a", " ", "c"}]}]]}], 
       RowBox[{"2", " ", "c"}]], "]"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"ArcTanh", "[", 
            FractionBox[
             RowBox[{"b", "+", 
              SqrtBox[
               RowBox[{
                SuperscriptBox["b", "2"], "-", 
                RowBox[{"4", " ", "a", " ", "c"}]}]]}], 
             RowBox[{"2", " ", "c"}]], "]"}], "+", 
           RowBox[{"ArcTanh", "[", "x", "]"}]}], ")"}]}]]}], "]"}]}], "-", 
    RowBox[{"2", " ", 
     RowBox[{"ArcTanh", "[", "x", "]"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"ArcTanh", "[", 
            FractionBox[
             RowBox[{"b", "+", 
              SqrtBox[
               RowBox[{
                SuperscriptBox["b", "2"], "-", 
                RowBox[{"4", " ", "a", " ", "c"}]}]]}], 
             RowBox[{"2", " ", "c"}]], "]"}], "+", 
           RowBox[{"ArcTanh", "[", "x", "]"}]}], ")"}]}]]}], "]"}]}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"ArcTanh", "[", "x", "]"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{
         RowBox[{"ArcTanh", "[", 
          FractionBox[
           RowBox[{"b", "-", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              RowBox[{"4", " ", "a", " ", "c"}]}]]}], 
           RowBox[{"2", " ", "c"}]], "]"}], "+", 
         RowBox[{"ArcTanh", "[", "x", "]"}]}], "]"}]}], "]"}]}], "-", 
    RowBox[{"2", " ", 
     RowBox[{"ArcTanh", "[", 
      FractionBox[
       RowBox[{"b", "-", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"4", " ", "a", " ", "c"}]}]]}], 
       RowBox[{"2", " ", "c"}]], "]"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{
         RowBox[{"ArcTanh", "[", 
          FractionBox[
           RowBox[{"b", "-", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              RowBox[{"4", " ", "a", " ", "c"}]}]]}], 
           RowBox[{"2", " ", "c"}]], "]"}], "+", 
         RowBox[{"ArcTanh", "[", "x", "]"}]}], "]"}]}], "]"}]}], "-", 
    RowBox[{"2", " ", 
     RowBox[{"ArcTanh", "[", "x", "]"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{
         RowBox[{"ArcTanh", "[", 
          FractionBox[
           RowBox[{"b", "-", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              RowBox[{"4", " ", "a", " ", "c"}]}]]}], 
           RowBox[{"2", " ", "c"}]], "]"}], "+", 
         RowBox[{"ArcTanh", "[", "x", "]"}]}], "]"}]}], "]"}]}], "-", 
    RowBox[{"2", " ", 
     RowBox[{"ArcTanh", "[", "x", "]"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{
         RowBox[{"ArcTanh", "[", 
          FractionBox[
           RowBox[{"b", "+", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              RowBox[{"4", " ", "a", " ", "c"}]}]]}], 
           RowBox[{"2", " ", "c"}]], "]"}], "+", 
         RowBox[{"ArcTanh", "[", "x", "]"}]}], "]"}]}], "]"}]}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"ArcTanh", "[", 
      FractionBox[
       RowBox[{"b", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"4", " ", "a", " ", "c"}]}]]}], 
       RowBox[{"2", " ", "c"}]], "]"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{
         RowBox[{"ArcTanh", "[", 
          FractionBox[
           RowBox[{"b", "+", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              RowBox[{"4", " ", "a", " ", "c"}]}]]}], 
           RowBox[{"2", " ", "c"}]], "]"}], "+", 
         RowBox[{"ArcTanh", "[", "x", "]"}]}], "]"}]}], "]"}]}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"ArcTanh", "[", "x", "]"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{
         RowBox[{"ArcTanh", "[", 
          FractionBox[
           RowBox[{"b", "+", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              RowBox[{"4", " ", "a", " ", "c"}]}]]}], 
           RowBox[{"2", " ", "c"}]], "]"}], "+", 
         RowBox[{"ArcTanh", "[", "x", "]"}]}], "]"}]}], "]"}]}], "-", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "2"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"ArcTanh", "[", 
           FractionBox[
            RowBox[{"b", "-", 
             SqrtBox[
              RowBox[{
               SuperscriptBox["b", "2"], "-", 
               RowBox[{"4", " ", "a", " ", "c"}]}]]}], 
            RowBox[{"2", " ", "c"}]], "]"}], "+", 
          RowBox[{"ArcTanh", "[", "x", "]"}]}], ")"}]}]]}], "]"}], "+", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "2"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"ArcTanh", "[", 
           FractionBox[
            RowBox[{"b", "+", 
             SqrtBox[
              RowBox[{
               SuperscriptBox["b", "2"], "-", 
               RowBox[{"4", " ", "a", " ", "c"}]}]]}], 
            RowBox[{"2", " ", "c"}]], "]"}], "+", 
          RowBox[{"ArcTanh", "[", "x", "]"}]}], ")"}]}]]}], "]"}]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{3.4902094306784973`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " is able to integrate the expression:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443225459641647`*^9, 3.4443225485078225`*^9}, {
   3.4466948911496077`*^9, 3.42301074665625*^9}, 3.42317159478125*^9, {
   3.423174840640625*^9, 3.423174854046875*^9}, {3.4233322945*^9, 
   3.4233323091875*^9}, {3.42333236403125*^9, 3.423332366546875*^9}, {
   3.423332643984375*^9, 3.42333264684375*^9}, {3.423338772921875*^9, 
   3.423338774734375*^9}, 3.423341072796875*^9, {3.423341460375*^9, 
   3.4233414605625*^9}, {3.42335786965625*^9, 3.423357883921875*^9}, {
   3.455347583937736*^9, 3.455347624856574*^9}, 3.4553489047269373`*^9, 
   3.4821992623552275`*^9, {3.4901462939291897`*^9, 3.4901463311664553`*^9}, {
   3.4901464136906004`*^9, 3.490146448338261*^9}, {3.4901466420282016`*^9, 
   3.4901466446334057`*^9}, {3.490146979175994*^9, 3.490147018896064*^9}, {
   3.49014785956594*^9, 3.4901478680991554`*^9}, {3.490208912008787*^9, 
   3.490208956515665*^9}, {3.4902095456818995`*^9, 3.49020957427675*^9}, {
   3.4902097140217953`*^9, 3.4902097576862717`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"arctanh", 
      RowBox[{
       RowBox[{"(", "x", ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444350078924618*^9, 3.423171727*^9}, {
   3.4236169183125*^9, 3.423616928921875*^9}, {3.4553480452110147`*^9, 
   3.4553480557261343`*^9}, {3.455348571317518*^9, 3.455348579389125*^9}, {
   3.455348631163573*^9, 3.455348631474019*^9}, {3.4834816003868046`*^9, 
   3.4834816024597855`*^9}, {3.4901471509190955`*^9, 3.490147160887513*^9}, 
   3.490147464479646*^9, 3.4901477330809183`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "x"}], "]"}], " ", 
    RowBox[{"Log", "[", 
     FractionBox[
      RowBox[{"b", "-", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"4", " ", "a", " ", "c"}]}]], "+", 
       RowBox[{"2", " ", "c", " ", "x"}]}], 
      RowBox[{"b", "-", 
       RowBox[{"2", " ", "c"}], "-", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"4", " ", "a", " ", "c"}]}]]}]], "]"}]}], 
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}]]}]], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", "x"}], "]"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"b", "-", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"4", " ", "a", " ", "c"}]}]], "+", 
        RowBox[{"2", " ", "c", " ", "x"}]}], 
       RowBox[{
        RowBox[{"-", "b"}], "-", 
        RowBox[{"2", " ", "c"}], "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"4", " ", "a", " ", "c"}]}]]}]]}], "]"}]}], 
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}]]}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", "x"}], "]"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"b", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"4", " ", "a", " ", "c"}]}]], "+", 
        RowBox[{"2", " ", "c", " ", "x"}]}], 
       RowBox[{
        RowBox[{"-", "b"}], "-", 
        RowBox[{"2", " ", "c"}], "-", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"4", " ", "a", " ", "c"}]}]]}]]}], "]"}]}], 
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}]]}]], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "x"}], "]"}], " ", 
    RowBox[{"Log", "[", 
     FractionBox[
      RowBox[{"b", "+", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"4", " ", "a", " ", "c"}]}]], "+", 
       RowBox[{"2", " ", "c", " ", "x"}]}], 
      RowBox[{"b", "-", 
       RowBox[{"2", " ", "c"}], "+", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"4", " ", "a", " ", "c"}]}]]}]], "]"}]}], 
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}]]}]], "+", 
  FractionBox[
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", "c", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", "x"}], ")"}]}], 
       RowBox[{
        RowBox[{"-", "b"}], "-", 
        RowBox[{"2", " ", "c"}], "-", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"4", " ", "a", " ", "c"}]}]]}]]}]}], "]"}], 
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}]]}]], "-", 
  FractionBox[
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", "c", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", "x"}], ")"}]}], 
       RowBox[{
        RowBox[{"-", "b"}], "-", 
        RowBox[{"2", " ", "c"}], "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"4", " ", "a", " ", "c"}]}]]}]]}]}], "]"}], 
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}]]}]], "+", 
  FractionBox[
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", "c", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "x"}], ")"}]}], 
       RowBox[{"b", "-", 
        RowBox[{"2", " ", "c"}], "-", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"4", " ", "a", " ", "c"}]}]]}]]}]}], "]"}], 
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}]]}]], "-", 
  FractionBox[
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", "c", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "x"}], ")"}]}], 
       RowBox[{"b", "-", 
        RowBox[{"2", " ", "c"}], "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"4", " ", "a", " ", "c"}]}]]}]]}]}], "]"}], 
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}]]}]]}]], "Output",
 CellChangeTimes->{
  3.4553471757908497`*^9, 3.455347464195555*^9, 3.4553478642307777`*^9, {
   3.4553479001924877`*^9, 3.455347905069501*^9}, 3.455348519012307*^9, 
   3.4834815773737135`*^9, {3.4901458393519917`*^9, 3.4901458654976377`*^9}, {
   3.4901467707752275`*^9, 3.4901467755488358`*^9}, 3.4901469140458794`*^9, 
   3.490147678402822*^9}]
}, Closed]],

Cell["", "Text"],

Cell["\<\
Note that these systems give similar results to the above for the hyperbolic \
arccotangent function.\
\>", "Subsubtitle",
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832040958843503`*^9, 3.4832041044566765`*^9}, 3.483204218670909*^9, 
   3.4833920379275217`*^9, {3.483392125182989*^9, 3.4833921454921923`*^9}, {
   3.48339221312945*^9, 3.483392219528651*^9}, {3.483392987983635*^9, 
   3.4833931408334227`*^9}, {3.4833932165322723`*^9, 3.483393223472251*^9}, {
   3.483395056508027*^9, 3.4833950705081587`*^9}, {3.4833959109166064`*^9, 
   3.483395925577688*^9}, {3.483395964633848*^9, 3.4833959819287167`*^9}, {
   3.4833961127468243`*^9, 3.483396122781253*^9}, 3.490048900827781*^9, 
   3.4900489594451337`*^9, {3.4902128221680546`*^9, 3.4902128464728975`*^9}, {
   3.4902329319281735`*^9, 3.490232932520975*^9}}],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Inverse Hyperbolic Function Integration Problem 3", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, {3.4821973084456434`*^9, 3.482197309066536*^9}, {
   3.4821982364300194`*^9, 3.482198240976557*^9}, 3.482198357524144*^9, {
   3.4821988021534896`*^9, 3.4821988078316545`*^9}, 3.4821989164378223`*^9, {
   3.482198948964594*^9, 3.4821989770249424`*^9}, 3.4821998639402637`*^9, 
   3.4902117046320915`*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"ArcTanh", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "n"]}], "]"}], "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
   3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
   3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.482199441332584*^9, {
   3.4834815653163757`*^9, 3.4834815659572973`*^9}, 3.490148296585108*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " returns the polylog form of the rule for all symbolic and numeric n:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443225459641647`*^9, 3.4443225485078225`*^9}, {
   3.4466948911496077`*^9, 3.42301074665625*^9}, 3.42317159478125*^9, {
   3.423174840640625*^9, 3.423174854046875*^9}, {3.4233322945*^9, 
   3.4233323091875*^9}, {3.42333236403125*^9, 3.423332366546875*^9}, {
   3.423332643984375*^9, 3.42333264684375*^9}, 3.423341072609375*^9, 
   3.4561670576690483`*^9, 3.4791559290778675`*^9, 3.482175999467106*^9, {
   3.482176939178344*^9, 3.482176943534608*^9}, 3.4821770265840273`*^9, {
   3.4898048224003077`*^9, 3.4898048266603136`*^9}, {3.4898052234408693`*^9, 
   3.489805239230891*^9}, {3.4898052800709486`*^9, 3.4898052802509484`*^9}, {
   3.489807179413607*^9, 3.489807180423609*^9}, 3.4898795383741636`*^9, 
   3.4901487258354616`*^9, {3.4901490814872866`*^9, 3.4901490825012884`*^9}, {
   3.490150217041281*^9, 3.490150235308913*^9}, {3.490150285229001*^9, 
   3.490150291125811*^9}, {3.4901503339790864`*^9, 3.490150396862797*^9}}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"ArcTanh", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "n"]}], "]"}], "x"], ",", " ", "x"}], 
  "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, {3.455334181485957*^9, 
   3.455334194264331*^9}, {3.4553471254684896`*^9, 3.455347126660203*^9}, {
   3.455347168590496*^9, 3.455347170423131*^9}, {3.4553474605803566`*^9, 
   3.4553474615517535`*^9}, {3.4553478671349535`*^9, 3.4553479098263407`*^9}, 
   3.4553485173899746`*^9, {3.483481569372208*^9, 3.4834815699029713`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      RowBox[{
       RowBox[{"-", "a"}], " ", 
       SuperscriptBox["x", "n"]}]}], "]"}], 
    RowBox[{"2", " ", "n"}]]}], "+", 
  FractionBox[
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "n"]}]}], "]"}], 
   RowBox[{"2", " ", "n"}]]}]], "Output",
 CellChangeTimes->{
  3.4553471757908497`*^9, 3.455347464195555*^9, 3.4553478642307777`*^9, {
   3.4553479001924877`*^9, 3.455347905069501*^9}, 3.455348519012307*^9, 
   3.4834815773737135`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"ArcTanh", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "5"]}], "]"}], "x"], ",", " ", "x"}], 
  "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, {
   3.444349991088315*^9, 3.423171727*^9}, {3.42361689675*^9, 
   3.423616909609375*^9}, 3.455334184320032*^9, {3.4553342246880784`*^9, 
   3.4553342261301517`*^9}, {3.4553342969019165`*^9, 3.455334298233832*^9}, {
   3.4553471997953663`*^9, 3.4553472071859937`*^9}, {3.455347873984803*^9, 
   3.4553478754368916`*^9}, {3.4553485285460157`*^9, 
   3.4553485323615026`*^9}, {3.4834815814896317`*^9, 3.483481581910237*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "10"]}], " ", 
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     RowBox[{
      RowBox[{"-", "a"}], " ", 
      SuperscriptBox["x", "5"]}]}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "10"], " ", 
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "5"]}]}], "]"}]}]}]], "Output",
 CellChangeTimes->{
  3.4553468542785378`*^9, {3.4553472025493264`*^9, 3.45534720758657*^9}, 
   3.4553478720920815`*^9, 3.455348533112582*^9, 3.4834815827814894`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " returns the hypergeometric form of the rule for symbolic n, but the \
polylog form for numeric n:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500256179667`*^9}, {3.4466836176090527`*^9, 3.446683618790752*^9}, {
   3.4466950388319645`*^9, 3.423171727*^9}, {3.423617028171875*^9, 
   3.4236170379375*^9}, {3.4553479526979876`*^9, 3.4553479664477587`*^9}, 
   3.4553488631171055`*^9, {3.455349270663128*^9, 3.4553492792855263`*^9}, 
   3.4821993033942385`*^9, {3.4901499064135356`*^9, 3.4901500044597073`*^9}, {
   3.4901500588102036`*^9, 3.4901500767190347`*^9}, {3.4901501385419436`*^9, 
   3.490150177666812*^9}, {3.490150422587242*^9, 3.490150459262906*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"ArcTanh", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "n"]}], "]"}], "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
   3.4443498869285407`*^9}, {3.444349974083864*^9, 3.423171727*^9}, 
   3.423616899578125*^9, {3.455334328146845*^9, 3.455334346853744*^9}, {
   3.455347028589184*^9, 3.4553470351786594`*^9}, {3.455347077739859*^9, 
   3.455347084088989*^9}, {3.455347223879998*^9, 3.4553472252820144`*^9}, {
   3.455347418329603*^9, 3.4553474190906973`*^9}, {3.4553479192198477`*^9, 
   3.4553479280225058`*^9}, {3.455348103234448*^9, 3.4553481049168673`*^9}, 
   3.455348542746435*^9, {3.483481589411022*^9, 3.483481589851656*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{"a", " ", 
   SuperscriptBox["x", "n"], " ", 
   RowBox[{"HypergeometricPFQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], ",", 
       FractionBox["1", "2"], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["3", "2"], ",", 
       FractionBox["3", "2"]}], "}"}], ",", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["x", 
       RowBox[{"2", " ", "n"}]]}]}], "]"}]}], "n"]], "Output",
 CellChangeTimes->{3.4553492672882752`*^9, 3.4834815917443776`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"ArcTanh", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "5"]}], "]"}], "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
   3.4443498869285407`*^9}, {3.4443499715902786`*^9, 3.423171727*^9}, {
   3.423616902765625*^9, 3.423616905984375*^9}, {3.455346949345237*^9, 
   3.4553469519389668`*^9}, {3.455347010242803*^9, 3.455347011544675*^9}, {
   3.4553470654321613`*^9, 3.45534706579268*^9}, {3.4553470967471905`*^9, 
   3.4553470986899843`*^9}, {3.455347239051814*^9, 3.45534724229648*^9}, {
   3.4553474305271425`*^9, 3.4553474314484673`*^9}, {3.455347940029771*^9, 
   3.45534794114137*^9}, {3.455348107600726*^9, 3.4553481090828576`*^9}, 
   3.4553485570770416`*^9, {3.483481595079173*^9, 3.4834815954396915`*^9}, {
   3.490232023371378*^9, 3.4902320307345905`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "10"]}], " ", 
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     RowBox[{
      RowBox[{"-", "a"}], " ", 
      SuperscriptBox["x", "5"]}]}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "10"], " ", 
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "5"]}]}], "]"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.44434988769965*^9, {3.4466836278337555`*^9, 3.423171727*^9}, 
   3.4236170036875*^9, 3.455346953070594*^9, 3.455347013477454*^9, 
   3.4553470664336014`*^9, 3.45534709909056*^9, 3.455347243347992*^9, 
   3.4553474328304543`*^9, 3.455347941982579*^9, 3.4553485578681793`*^9, 
   3.483481596000498*^9, 3.4902320261949825`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " returns the polylog form of the rule for symbolic n, but an expression not \
in closed-form when n is an integer:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.444322558662424*^9, 3.444322586131923*^9}, {
   3.4466780286625423`*^9, 3.446678029423637*^9}, {3.4466948967576723`*^9, 
   3.42317159478125*^9}, 3.423174910453125*^9, {3.423332331546875*^9, 
   3.423332347125*^9}, {3.423332380203125*^9, 3.42333240928125*^9}, 
   3.423341072625*^9, 3.4561670576790624`*^9, 3.4821759878804445`*^9, 
   3.4821761016640577`*^9, 3.4821761392881584`*^9, 3.482176179285672*^9, 
   3.4821770498975506`*^9, {3.489804505429864*^9, 3.489804512039873*^9}, {
   3.4898045424699154`*^9, 3.4898045431099167`*^9}, {3.4898045772899647`*^9, 
   3.4898046123600135`*^9}, {3.489805011410572*^9, 3.4898050165905795`*^9}, {
   3.489806991903345*^9, 3.4898069937533474`*^9}, 3.489879548982182*^9, {
   3.4901488261904383`*^9, 3.490148828951643*^9}, {3.4901490397416134`*^9, 
   3.4901490518472347`*^9}, {3.4901491110805387`*^9, 3.490149127226567*^9}, {
   3.490150480338544*^9, 3.490150536857443*^9}, {3.4901506089295692`*^9, 
   3.490150621830792*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"arctanh", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "*", 
         RowBox[{"x", "^", "n"}]}], ")"}], "/", "x"}]}], ",", " ", "x"}], 
    ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444350078924618*^9, 3.423171727*^9}, {
  3.4236169183125*^9, 3.423616928921875*^9}, {3.4553480452110147`*^9, 
  3.4553480557261343`*^9}, {3.455348571317518*^9, 3.455348579389125*^9}, {
  3.455348631163573*^9, 3.455348631474019*^9}, {3.4834816003868046`*^9, 
  3.4834816024597855`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"dilog", " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "n"]}]}], ")"}]}], 
   RowBox[{"2", " ", "n"}]], "-", 
  FractionBox[
   RowBox[{"dilog", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "n"]}]}], ")"}]}], 
   RowBox[{"2", " ", "n"}]]}]], "Output",
 CellChangeTimes->{3.490148318191146*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"arctanh", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "*", 
         RowBox[{"x", "^", "5"}]}], ")"}], "/", "x"}]}], ",", " ", "x"}], 
    ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444350078924618*^9, 3.423171727*^9}, {
  3.4236169183125*^9, 3.423616928921875*^9}, {3.4553480452110147`*^9, 
  3.4553480685545807`*^9}, {3.455348699371651*^9, 3.4553487024060144`*^9}, {
  3.4553490858273473`*^9, 3.4553490905841875`*^9}, {3.4834817652138147`*^9, 
  3.4834817657846355`*^9}, {3.4834822204383955`*^9, 3.4834822248146877`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"1", "/", "2"}], "*", "ln", 
   RowBox[{"(", "x", ")"}], "*", "ln", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"a", "*", 
      RowBox[{"x", "^", "5"}]}]}], ")"}]}], "-", 
  RowBox[{
   RowBox[{"5", "/", "2"}], "*", "a", "*", "sum", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"1", "/", "5"}], "/", "a"}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"ln", 
         RowBox[{"(", "x", ")"}], "*", "ln", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"_R1", "-", "x"}], ")"}], "/", "_R1"}], ")"}]}], "+", 
        RowBox[{"dilog", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"_R1", "-", "x"}], ")"}], "/", "_R1"}], ")"}]}]}], 
       ")"}]}], ",", 
     RowBox[{"_R1", "=", 
      RowBox[{"RootOf", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"_Z", "^", "5"}], "*", "a"}], "+", "1"}], ")"}]}]}]}], 
    ")"}]}], "-", 
  RowBox[{
   RowBox[{"1", "/", "2"}], "*", "ln", 
   RowBox[{"(", "x", ")"}], "*", "ln", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"a", "*", 
      RowBox[{"x", "^", "5"}]}]}], ")"}]}], "+", 
  RowBox[{
   RowBox[{"5", "/", "2"}], "*", "a", "*", "sum", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"1", "/", "5"}], "/", "a"}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"ln", 
         RowBox[{"(", "x", ")"}], "*", "ln", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"_R1", "-", "x"}], ")"}], "/", "_R1"}], ")"}]}], "+", 
        RowBox[{"dilog", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"_R1", "-", "x"}], ")"}], "/", "_R1"}], ")"}]}]}], 
       ")"}]}], ",", 
     RowBox[{"_R1", "=", 
      RowBox[{"RootOf", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"_Z", "^", "5"}], "*", "a"}], "-", "1"}], ")"}]}]}]}], 
    ")"}]}]}]], "Output"]
}, Closed]],

Cell["", "Text"],

Cell["\<\
Note that these systems give similar results to the above for the hyperbolic \
arccotangent function.\
\>", "Subsubtitle",
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832040958843503`*^9, 3.4832041044566765`*^9}, 3.483204218670909*^9, 
   3.4833920379275217`*^9, {3.483392125182989*^9, 3.4833921454921923`*^9}, {
   3.48339221312945*^9, 3.483392219528651*^9}, {3.483392987983635*^9, 
   3.4833931408334227`*^9}, {3.4833932165322723`*^9, 3.483393223472251*^9}, {
   3.483395056508027*^9, 3.4833950705081587`*^9}, {3.4833959109166064`*^9, 
   3.483395925577688*^9}, {3.483395964633848*^9, 3.4833959819287167`*^9}, {
   3.4833961127468243`*^9, 3.483396122781253*^9}, 3.490048900827781*^9, 
   3.4900489594451337`*^9, {3.4902128221680546`*^9, 3.4902128464728975`*^9}, {
   3.4902329357189803`*^9, 3.4902329362025814`*^9}}],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Inverse Hyperbolic Function Integration Problem 4", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, {3.4821973084456434`*^9, 3.482197309066536*^9}, {
   3.4821982364300194`*^9, 3.482198240976557*^9}, 3.482198357524144*^9, {
   3.4821988021534896`*^9, 3.4821988078316545`*^9}, 3.4821989164378223`*^9, {
   3.482198948964594*^9, 3.4821989770249424`*^9}, 3.4821998639402637`*^9, 
   3.4901457521946383`*^9, 3.4901481926733255`*^9, 3.4902265806362257`*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"ArcTanh", "[", 
    RowBox[{"a", " ", 
     RowBox[{"Tanh", "[", "x", "]"}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
   3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
   3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.482199441332584*^9, {
   3.4834815653163757`*^9, 3.4834815659572973`*^9}, {3.4901457904147053`*^9, 
   3.490145818447955*^9}, {3.490146761836412*^9, 3.490146763115614*^9}, {
   3.4901469062926655`*^9, 3.490146908195869*^9}, 3.490147670977209*^9, 
   3.490148293309102*^9, {3.4902117130873065`*^9, 3.4902117160669117`*^9}, 
   3.490226617102289*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " returns a 5 term sum free of the imaginary unit:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443225459641647`*^9, 3.4443225485078225`*^9}, {
   3.4466948911496077`*^9, 3.42301074665625*^9}, 3.42317159478125*^9, {
   3.423174840640625*^9, 3.423174854046875*^9}, {3.4233322945*^9, 
   3.4233323091875*^9}, {3.42333236403125*^9, 3.423332366546875*^9}, {
   3.423332643984375*^9, 3.42333264684375*^9}, {3.423338772921875*^9, 
   3.423338774734375*^9}, 3.423341072796875*^9, {3.423341460375*^9, 
   3.4233414605625*^9}, {3.42335786965625*^9, 3.423357883921875*^9}, {
   3.455347583937736*^9, 3.455347624856574*^9}, 3.4553489047269373`*^9, 
   3.4821992623552275`*^9, {3.4901462939291897`*^9, 3.4901463311664553`*^9}, {
   3.4901464136906004`*^9, 3.490146448338261*^9}, {3.4901466420282016`*^9, 
   3.4901466446334057`*^9}, {3.490146979175994*^9, 3.490147018896064*^9}, {
   3.49014785956594*^9, 3.4901478680991554`*^9}, {3.490208912008787*^9, 
   3.490208956515665*^9}, {3.4902095456818995`*^9, 3.49020957427675*^9}, {
   3.490209819789981*^9, 3.4902098250471907`*^9}, {3.4902118069994717`*^9, 
   3.490211808996275*^9}, {3.4902121317608423`*^9, 3.4902121356608486`*^9}, {
   3.4902268166174393`*^9, 3.490226833746269*^9}, {3.490227071847087*^9, 
   3.490227076917096*^9}}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{"ArcTanh", "[", 
    RowBox[{"a", " ", 
     RowBox[{"Tanh", "[", "x", "]"}]}], "]"}], ",", " ", "x"}], 
  "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, {3.455334181485957*^9, 
   3.455334194264331*^9}, {3.4553471254684896`*^9, 3.455347126660203*^9}, {
   3.455347168590496*^9, 3.455347170423131*^9}, {3.4553474605803566`*^9, 
   3.4553474615517535`*^9}, {3.4553478671349535`*^9, 3.4553479098263407`*^9}, 
   3.4553485173899746`*^9, {3.483481569372208*^9, 3.4834815699029713`*^9}, {
   3.4901458288063726`*^9, 3.4901458649828367`*^9}, {3.4901467652216177`*^9, 
   3.4901467684976234`*^9}, {3.490146910364273*^9, 3.4901469119086757`*^9}, 
   3.4901476752360163`*^9, {3.4902117428521585`*^9, 3.490211745847364*^9}, {
   3.490212063947523*^9, 3.490212065226725*^9}, {3.490212098922784*^9, 
   3.4902120998275857`*^9}, {3.4902267360344977`*^9, 
   3.4902267455037146`*^9}, {3.490226895463177*^9, 3.4902269038559923`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", " ", 
   RowBox[{"ArcTanh", "[", 
    RowBox[{"a", " ", 
     RowBox[{"Tanh", "[", "x", "]"}]}], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", "x", " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SuperscriptBox["a", "2"]}], ")"}], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "x"}]]}], 
      RowBox[{"1", "-", 
       RowBox[{"2", " ", "a"}], "+", 
       SuperscriptBox["a", "2"]}]]}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", "x", " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SuperscriptBox["a", "2"]}], ")"}], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "x"}]]}], 
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "a"}], "+", 
       SuperscriptBox["a", "2"]}]]}], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SuperscriptBox["a", "2"]}], ")"}], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", "x"}]]}], 
       RowBox[{"1", "-", 
        RowBox[{"2", " ", "a"}], "+", 
        SuperscriptBox["a", "2"]}]]}]}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SuperscriptBox["a", "2"]}], ")"}], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", "x"}]]}], 
       RowBox[{"1", "+", 
        RowBox[{"2", " ", "a"}], "+", 
        SuperscriptBox["a", "2"]}]]}]}], "]"}]}]}]], "Output",
 CellChangeTimes->{{3.490226892015571*^9, 3.4902268967579794`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " returns a large complicated expression involving the imaginary unit:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500256179667`*^9}, {3.4466836176090527`*^9, 3.446683618790752*^9}, {
   3.4466950388319645`*^9, 3.423171727*^9}, {3.423617028171875*^9, 
   3.4236170379375*^9}, {3.4553479526979876`*^9, 3.4553479664477587`*^9}, 
   3.4553488631171055`*^9, {3.455349270663128*^9, 3.4553492792855263`*^9}, 
   3.4821993033942385`*^9, {3.4901461922558117`*^9, 3.490146250311514*^9}, {
   3.490146703164709*^9, 3.4901467180783353`*^9}, {3.4901468663877954`*^9, 
   3.4901468754358115`*^9}, {3.4902095985815926`*^9, 
   3.4902096159912233`*^9}, {3.4902096750217266`*^9, 3.4902096759109287`*^9}, 
   3.490209788418326*^9, {3.4902098449840255`*^9, 3.49020987610608*^9}, {
   3.490212150028474*^9, 3.4902121822737303`*^9}, {3.4902269254184294`*^9, 
   3.4902269328128424`*^9}, {3.4902270625650706`*^9, 3.4902270670578785`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"ArcTanh", "[", 
    RowBox[{"a", " ", 
     RowBox[{"Tanh", "[", "x", "]"}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
   3.4443498869285407`*^9}, {3.444349974083864*^9, 3.423171727*^9}, 
   3.423616899578125*^9, {3.455334328146845*^9, 3.455334346853744*^9}, {
   3.455347028589184*^9, 3.4553470351786594`*^9}, {3.455347077739859*^9, 
   3.455347084088989*^9}, {3.455347223879998*^9, 3.4553472252820144`*^9}, {
   3.455347418329603*^9, 3.4553474190906973`*^9}, {3.4553479192198477`*^9, 
   3.4553479280225058`*^9}, {3.455348103234448*^9, 3.4553481049168673`*^9}, 
   3.455348542746435*^9, {3.483481589411022*^9, 3.483481589851656*^9}, 
   3.490146130994504*^9, 3.490146788044458*^9, {3.4901469204886904`*^9, 
   3.4901469227038946`*^9}, 3.4901476840968323`*^9, {3.4902117640681963`*^9, 
   3.490211777141019*^9}, {3.49022675445813*^9, 3.490226776422969*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", " ", 
   RowBox[{"ArcTanh", "[", 
    RowBox[{"a", " ", 
     RowBox[{"Tanh", "[", "x", "]"}]}], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"4", " ", 
     SqrtBox[
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}]]}]], 
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "4"}], " ", "x", " ", 
       RowBox[{"ArcTan", "[", 
        FractionBox[
         RowBox[{"Coth", "[", "x", "]"}], 
         SqrtBox[
          RowBox[{"-", 
           SuperscriptBox["a", "2"]}]]], "]"}]}], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       RowBox[{"ArcCos", "[", 
        FractionBox[
         RowBox[{"1", "+", 
          SuperscriptBox["a", "2"]}], 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["a", "2"]}]], "]"}], " ", 
       RowBox[{"ArcTan", "[", 
        RowBox[{
         SqrtBox[
          RowBox[{"-", 
           SuperscriptBox["a", "2"]}]], " ", 
         RowBox[{"Tanh", "[", "x", "]"}]}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"ArcCos", "[", 
          FractionBox[
           RowBox[{"1", "+", 
            SuperscriptBox["a", "2"]}], 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["a", "2"]}]], "]"}], "-", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"ArcTan", "[", 
             FractionBox[
              RowBox[{"Coth", "[", "x", "]"}], 
              SqrtBox[
               RowBox[{"-", 
                SuperscriptBox["a", "2"]}]]], "]"}], "+", 
            RowBox[{"ArcTan", "[", 
             RowBox[{
              SqrtBox[
               RowBox[{"-", 
                SuperscriptBox["a", "2"]}]], " ", 
              RowBox[{"Tanh", "[", "x", "]"}]}], "]"}]}], ")"}]}]}], ")"}], 
       " ", 
       RowBox[{"Log", "[", 
        FractionBox[
         RowBox[{
          SqrtBox["2"], " ", 
          SqrtBox[
           RowBox[{"-", 
            SuperscriptBox["a", "2"]}]], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"-", "x"}]]}], 
         RowBox[{
          SqrtBox[
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["a", "2"]}]], " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"-", "1"}], "-", 
            SuperscriptBox["a", "2"], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["a", "2"]}], ")"}], " ", 
             RowBox[{"Cosh", "[", 
              RowBox[{"2", " ", "x"}], "]"}]}]}]]}]], "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"ArcCos", "[", 
          FractionBox[
           RowBox[{"1", "+", 
            SuperscriptBox["a", "2"]}], 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["a", "2"]}]], "]"}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"ArcTan", "[", 
             FractionBox[
              RowBox[{"Coth", "[", "x", "]"}], 
              SqrtBox[
               RowBox[{"-", 
                SuperscriptBox["a", "2"]}]]], "]"}], "+", 
            RowBox[{"ArcTan", "[", 
             RowBox[{
              SqrtBox[
               RowBox[{"-", 
                SuperscriptBox["a", "2"]}]], " ", 
              RowBox[{"Tanh", "[", "x", "]"}]}], "]"}]}], ")"}]}]}], ")"}], 
       " ", 
       RowBox[{"Log", "[", 
        FractionBox[
         RowBox[{
          SqrtBox["2"], " ", 
          SqrtBox[
           RowBox[{"-", 
            SuperscriptBox["a", "2"]}]], " ", 
          SuperscriptBox["\[ExponentialE]", "x"]}], 
         RowBox[{
          SqrtBox[
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["a", "2"]}]], " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"-", "1"}], "-", 
            SuperscriptBox["a", "2"], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["a", "2"]}], ")"}], " ", 
             RowBox[{"Cosh", "[", 
              RowBox[{"2", " ", "x"}], "]"}]}]}]]}]], "]"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"ArcCos", "[", 
          FractionBox[
           RowBox[{"1", "+", 
            SuperscriptBox["a", "2"]}], 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["a", "2"]}]], "]"}], "-", 
         RowBox[{"2", " ", 
          RowBox[{"ArcTan", "[", 
           RowBox[{
            SqrtBox[
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}]], " ", 
            RowBox[{"Tanh", "[", "x", "]"}]}], "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Log", "[", "2", "]"}], "+", 
         RowBox[{"Log", "[", 
          RowBox[{"-", 
           FractionBox[
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"\[ImaginaryI]", " ", 
                SuperscriptBox["a", "2"]}], "+", 
               SqrtBox[
                RowBox[{"-", 
                 SuperscriptBox["a", "2"]}]]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               RowBox[{"Tanh", "[", "x", "]"}]}], ")"}]}], 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["a", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"\[ImaginaryI]", "+", 
               RowBox[{
                SqrtBox[
                 RowBox[{"-", 
                  SuperscriptBox["a", "2"]}]], " ", 
                RowBox[{"Tanh", "[", "x", "]"}]}]}], ")"}]}]]}], "]"}]}], 
        ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"ArcCos", "[", 
          FractionBox[
           RowBox[{"1", "+", 
            SuperscriptBox["a", "2"]}], 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["a", "2"]}]], "]"}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"ArcTan", "[", 
           RowBox[{
            SqrtBox[
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}]], " ", 
            RowBox[{"Tanh", "[", "x", "]"}]}], "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Log", "[", "2", "]"}], "+", 
         RowBox[{"Log", "[", 
          RowBox[{"-", 
           FractionBox[
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "\[ImaginaryI]"}], " ", 
                SuperscriptBox["a", "2"]}], "+", 
               SqrtBox[
                RowBox[{"-", 
                 SuperscriptBox["a", "2"]}]]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"Tanh", "[", "x", "]"}]}], ")"}]}], 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["a", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"\[ImaginaryI]", "+", 
               RowBox[{
                SqrtBox[
                 RowBox[{"-", 
                  SuperscriptBox["a", "2"]}]], " ", 
                RowBox[{"Tanh", "[", "x", "]"}]}]}], ")"}]}]]}], "]"}]}], 
        ")"}]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"PolyLog", "[", 
           RowBox[{"2", ",", 
            FractionBox[
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "+", 
                SuperscriptBox["a", "2"], "-", 
                RowBox[{"2", " ", "\[ImaginaryI]", " ", 
                 SqrtBox[
                  RowBox[{"-", 
                   SuperscriptBox["a", "2"]}]]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "\[ImaginaryI]"}], "+", 
                RowBox[{
                 SqrtBox[
                  RowBox[{"-", 
                   SuperscriptBox["a", "2"]}]], " ", 
                 RowBox[{"Tanh", "[", "x", "]"}]}]}], ")"}]}], 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                SuperscriptBox["a", "2"]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"\[ImaginaryI]", "+", 
                RowBox[{
                 SqrtBox[
                  RowBox[{"-", 
                   SuperscriptBox["a", "2"]}]], " ", 
                 RowBox[{"Tanh", "[", "x", "]"}]}]}], ")"}]}]]}], "]"}]}], 
         "+", 
         RowBox[{"PolyLog", "[", 
          RowBox[{"2", ",", 
           FractionBox[
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", 
               SuperscriptBox["a", "2"], "+", 
               RowBox[{"2", " ", "\[ImaginaryI]", " ", 
                SqrtBox[
                 RowBox[{"-", 
                  SuperscriptBox["a", "2"]}]]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "\[ImaginaryI]"}], "+", 
               RowBox[{
                SqrtBox[
                 RowBox[{"-", 
                  SuperscriptBox["a", "2"]}]], " ", 
                RowBox[{"Tanh", "[", "x", "]"}]}]}], ")"}]}], 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["a", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"\[ImaginaryI]", "+", 
               RowBox[{
                SqrtBox[
                 RowBox[{"-", 
                  SuperscriptBox["a", "2"]}]], " ", 
                RowBox[{"Tanh", "[", "x", "]"}]}]}], ")"}]}]]}], "]"}]}], 
        ")"}]}]}], ")"}]}]}]}]], "Output",
 CellChangeTimes->{
  3.4553492672882752`*^9, 3.4834815917443776`*^9, 3.4901461331629076`*^9, 
   3.4901467917104645`*^9, 3.490146925355899*^9, 3.490147686343236*^9, {
   3.490211767063401*^9, 3.4902117787010217`*^9}, {3.4902267564861336`*^9, 
   3.4902267768753695`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " returns a large complicated expression involving the imaginary unit:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443225459641647`*^9, 3.4443225485078225`*^9}, {
   3.4466948911496077`*^9, 3.42301074665625*^9}, 3.42317159478125*^9, {
   3.423174840640625*^9, 3.423174854046875*^9}, {3.4233322945*^9, 
   3.4233323091875*^9}, {3.42333236403125*^9, 3.423332366546875*^9}, {
   3.423332643984375*^9, 3.42333264684375*^9}, {3.423338772921875*^9, 
   3.423338774734375*^9}, 3.423341072796875*^9, {3.423341460375*^9, 
   3.4233414605625*^9}, {3.42335786965625*^9, 3.423357883921875*^9}, {
   3.455347583937736*^9, 3.455347624856574*^9}, 3.4553489047269373`*^9, 
   3.4821992623552275`*^9, {3.4901462939291897`*^9, 3.4901463311664553`*^9}, {
   3.4901464136906004`*^9, 3.490146448338261*^9}, {3.4901466420282016`*^9, 
   3.4901466446334057`*^9}, {3.490146979175994*^9, 3.490147018896064*^9}, {
   3.49014785956594*^9, 3.4901478680991554`*^9}, {3.490208912008787*^9, 
   3.490208956515665*^9}, {3.4902095456818995`*^9, 3.49020957427675*^9}, {
   3.490209819789981*^9, 3.4902098250471907`*^9}, {3.4902118069994717`*^9, 
   3.490211808996275*^9}, {3.4902121317608423`*^9, 3.4902121356608486`*^9}, {
   3.490212322018776*^9, 3.490212338632805*^9}, 3.490227047011843*^9, 
   3.4902271051831455`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"arctanh", 
      RowBox[{"(", 
       RowBox[{"a", "*", "tanh", 
        RowBox[{"(", "x", ")"}]}], ")"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444350078924618*^9, 3.423171727*^9}, {
   3.4236169183125*^9, 3.423616928921875*^9}, {3.4553480452110147`*^9, 
   3.4553480557261343`*^9}, {3.455348571317518*^9, 3.455348579389125*^9}, {
   3.455348631163573*^9, 3.455348631474019*^9}, {3.4834816003868046`*^9, 
   3.4834816024597855`*^9}, {3.4901471509190955`*^9, 3.490147160887513*^9}, 
   3.490147464479646*^9, 3.4901477330809183`*^9, {3.4902122466862435`*^9, 
   3.490212247606645*^9}, {3.490226946197666*^9, 3.490226952531277*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"-", "1"}], "/", "2"}], "*", "a", "*", 
   RowBox[{"x", "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", "a"}], ")"}]}], "*", "ln", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "a"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{"a", "-", "1"}], ")"}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "2"}], ")"}]}], "-", 
       RowBox[{"exp", 
        RowBox[{"(", "x", ")"}]}], "-", 
       RowBox[{"a", "*", "exp", 
        RowBox[{"(", "x", ")"}]}]}], ")"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "a"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"a", "-", "1"}], ")"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}]}]}], ")"}]}], "-", 
  RowBox[{
   RowBox[{"1", "/", "2"}], "*", "a", "*", 
   RowBox[{"x", "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", "a"}], ")"}]}], "*", "ln", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "a"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{"a", "-", "1"}], ")"}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "2"}], ")"}]}], "+", 
       RowBox[{"exp", 
        RowBox[{"(", "x", ")"}]}], "+", 
       RowBox[{"a", "*", "exp", 
        RowBox[{"(", "x", ")"}]}]}], ")"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "a"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"a", "-", "1"}], ")"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}]}]}], ")"}]}], "+", 
  RowBox[{
   RowBox[{"1", "/", "2"}], "*", 
   RowBox[{"a", "/", 
    RowBox[{"(", 
     RowBox[{"a", "-", "1"}], ")"}]}], "*", "ln", 
   RowBox[{"(", 
    RowBox[{"exp", 
     RowBox[{"(", "x", ")"}]}], ")"}], "*", "ln", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "a"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{"a", "-", "1"}], ")"}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "2"}], ")"}]}], "+", 
       RowBox[{"exp", 
        RowBox[{"(", "x", ")"}]}], "-", 
       RowBox[{"a", "*", "exp", 
        RowBox[{"(", "x", ")"}]}]}], ")"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "a"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"a", "-", "1"}], ")"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}]}]}], ")"}]}], "+", 
  RowBox[{
   RowBox[{"1", "/", "2"}], "*", 
   RowBox[{"a", "/", 
    RowBox[{"(", 
     RowBox[{"a", "-", "1"}], ")"}]}], "*", "ln", 
   RowBox[{"(", 
    RowBox[{"exp", 
     RowBox[{"(", "x", ")"}]}], ")"}], "*", "ln", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "a"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{"a", "-", "1"}], ")"}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "2"}], ")"}]}], "-", 
       RowBox[{"exp", 
        RowBox[{"(", "x", ")"}]}], "+", 
       RowBox[{"a", "*", "exp", 
        RowBox[{"(", "x", ")"}]}]}], ")"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "a"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"a", "-", "1"}], ")"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}]}]}], ")"}]}], "-", 
  RowBox[{
   RowBox[{"1", "/", "2"}], "*", "I", "*", "Pi", "*", "x"}], "+", 
  RowBox[{
   RowBox[{"1", "/", "2"}], "*", "I", "*", "Pi", "*", "csgn", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"I", "/", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"exp", 
          RowBox[{"(", 
           RowBox[{"2", "*", "x"}], ")"}]}]}], ")"}]}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{"exp", 
            RowBox[{"(", 
             RowBox[{"2", "*", "x"}], ")"}]}]}], ")"}], "*", "a"}], "-", 
        RowBox[{"exp", 
         RowBox[{"(", 
          RowBox[{"2", "*", "x"}], ")"}]}], "-", "1"}], ")"}]}], ")"}], "^", 
    "2"}], "*", "x"}], "-", 
  RowBox[{
   RowBox[{"1", "/", "4"}], "*", "I", "*", "Pi", "*", "csgn", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"I", "/", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"exp", 
          RowBox[{"(", 
           RowBox[{"2", "*", "x"}], ")"}]}]}], ")"}]}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{"exp", 
            RowBox[{"(", 
             RowBox[{"2", "*", "x"}], ")"}]}]}], ")"}], "*", "a"}], "+", 
        RowBox[{"exp", 
         RowBox[{"(", 
          RowBox[{"2", "*", "x"}], ")"}]}], "+", "1"}], ")"}]}], ")"}], "^", 
    "3"}], "*", "x"}], "-", 
  RowBox[{
   RowBox[{"1", "/", "4"}], "*", "I", "*", "Pi", "*", "csgn", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"I", "/", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"exp", 
          RowBox[{"(", 
           RowBox[{"2", "*", "x"}], ")"}]}]}], ")"}]}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{"exp", 
            RowBox[{"(", 
             RowBox[{"2", "*", "x"}], ")"}]}]}], ")"}], "*", "a"}], "-", 
        RowBox[{"exp", 
         RowBox[{"(", 
          RowBox[{"2", "*", "x"}], ")"}]}], "-", "1"}], ")"}]}], ")"}], "^", 
    "3"}], "*", "x"}], "-", 
  RowBox[{
   RowBox[{"1", "/", "4"}], "*", "I", "*", "Pi", "*", "csgn", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"I", "/", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"exp", 
          RowBox[{"(", 
           RowBox[{"2", "*", "x"}], ")"}]}]}], ")"}]}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{"exp", 
            RowBox[{"(", 
             RowBox[{"2", "*", "x"}], ")"}]}]}], ")"}], "*", "a"}], "-", 
        RowBox[{"exp", 
         RowBox[{"(", 
          RowBox[{"2", "*", "x"}], ")"}]}], "-", "1"}], ")"}]}], ")"}], "^", 
    "2"}], "*", "csgn", 
   RowBox[{"(", 
    RowBox[{"I", "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"exp", 
           RowBox[{"(", 
            RowBox[{"2", "*", "x"}], ")"}]}]}], ")"}], "*", "a"}], "-", 
       RowBox[{"exp", 
        RowBox[{"(", 
         RowBox[{"2", "*", "x"}], ")"}]}], "-", "1"}], ")"}]}], ")"}], "*", 
   "x"}], "+", 
  RowBox[{
   RowBox[{"1", "/", "4"}], "*", "I", "*", "Pi", "*", "csgn", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"I", "/", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"exp", 
          RowBox[{"(", 
           RowBox[{"2", "*", "x"}], ")"}]}]}], ")"}]}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{"exp", 
            RowBox[{"(", 
             RowBox[{"2", "*", "x"}], ")"}]}]}], ")"}], "*", "a"}], "+", 
        RowBox[{"exp", 
         RowBox[{"(", 
          RowBox[{"2", "*", "x"}], ")"}]}], "+", "1"}], ")"}]}], ")"}], "^", 
    "2"}], "*", "csgn", 
   RowBox[{"(", 
    RowBox[{"I", "/", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"exp", 
        RowBox[{"(", 
         RowBox[{"2", "*", "x"}], ")"}]}]}], ")"}]}], ")"}], "*", "x"}], "+", 
  RowBox[{
   RowBox[{"1", "/", "4"}], "*", "I", "*", "Pi", "*", "csgn", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"I", "/", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"exp", 
          RowBox[{"(", 
           RowBox[{"2", "*", "x"}], ")"}]}]}], ")"}]}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{"exp", 
            RowBox[{"(", 
             RowBox[{"2", "*", "x"}], ")"}]}]}], ")"}], "*", "a"}], "+", 
        RowBox[{"exp", 
         RowBox[{"(", 
          RowBox[{"2", "*", "x"}], ")"}]}], "+", "1"}], ")"}]}], ")"}], "^", 
    "2"}], "*", "csgn", 
   RowBox[{"(", 
    RowBox[{"I", "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"exp", 
           RowBox[{"(", 
            RowBox[{"2", "*", "x"}], ")"}]}]}], ")"}], "*", "a"}], "+", 
       RowBox[{"exp", 
        RowBox[{"(", 
         RowBox[{"2", "*", "x"}], ")"}]}], "+", "1"}], ")"}]}], ")"}], "*", 
   "x"}], "+", 
  RowBox[{
   RowBox[{"1", "/", "4"}], "*", "I", "*", "Pi", "*", "csgn", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"I", "/", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"exp", 
         RowBox[{"(", 
          RowBox[{"2", "*", "x"}], ")"}]}]}], ")"}]}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"exp", 
           RowBox[{"(", 
            RowBox[{"2", "*", "x"}], ")"}]}]}], ")"}], "*", "a"}], "-", 
       RowBox[{"exp", 
        RowBox[{"(", 
         RowBox[{"2", "*", "x"}], ")"}]}], "-", "1"}], ")"}]}], ")"}], "*", 
   "csgn", 
   RowBox[{"(", 
    RowBox[{"I", "/", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"exp", 
        RowBox[{"(", 
         RowBox[{"2", "*", "x"}], ")"}]}]}], ")"}]}], ")"}], "*", "csgn", 
   RowBox[{"(", 
    RowBox[{"I", "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"exp", 
           RowBox[{"(", 
            RowBox[{"2", "*", "x"}], ")"}]}]}], ")"}], "*", "a"}], "-", 
       RowBox[{"exp", 
        RowBox[{"(", 
         RowBox[{"2", "*", "x"}], ")"}]}], "-", "1"}], ")"}]}], ")"}], "*", 
   "x"}], "-", 
  RowBox[{
   RowBox[{"1", "/", "4"}], "*", "I", "*", "Pi", "*", "csgn", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"I", "/", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"exp", 
          RowBox[{"(", 
           RowBox[{"2", "*", "x"}], ")"}]}]}], ")"}]}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{"exp", 
            RowBox[{"(", 
             RowBox[{"2", "*", "x"}], ")"}]}]}], ")"}], "*", "a"}], "-", 
        RowBox[{"exp", 
         RowBox[{"(", 
          RowBox[{"2", "*", "x"}], ")"}]}], "-", "1"}], ")"}]}], ")"}], "^", 
    "2"}], "*", "csgn", 
   RowBox[{"(", 
    RowBox[{"I", "/", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"exp", 
        RowBox[{"(", 
         RowBox[{"2", "*", "x"}], ")"}]}]}], ")"}]}], ")"}], "*", "x"}], "-", 
  RowBox[{
   RowBox[{"1", "/", "4"}], "*", "I", "*", "Pi", "*", "csgn", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"I", "/", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"exp", 
         RowBox[{"(", 
          RowBox[{"2", "*", "x"}], ")"}]}]}], ")"}]}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"exp", 
           RowBox[{"(", 
            RowBox[{"2", "*", "x"}], ")"}]}]}], ")"}], "*", "a"}], "+", 
       RowBox[{"exp", 
        RowBox[{"(", 
         RowBox[{"2", "*", "x"}], ")"}]}], "+", "1"}], ")"}]}], ")"}], "*", 
   "csgn", 
   RowBox[{"(", 
    RowBox[{"I", "/", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"exp", 
        RowBox[{"(", 
         RowBox[{"2", "*", "x"}], ")"}]}]}], ")"}]}], ")"}], "*", "csgn", 
   RowBox[{"(", 
    RowBox[{"I", "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"exp", 
           RowBox[{"(", 
            RowBox[{"2", "*", "x"}], ")"}]}]}], ")"}], "*", "a"}], "+", 
       RowBox[{"exp", 
        RowBox[{"(", 
         RowBox[{"2", "*", "x"}], ")"}]}], "+", "1"}], ")"}]}], ")"}], "*", 
   "x"}], "+", 
  RowBox[{
   RowBox[{"1", "/", "2"}], "*", 
   RowBox[{"a", "/", 
    RowBox[{"(", 
     RowBox[{"a", "-", "1"}], ")"}]}], "*", "dilog", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "a"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{"a", "-", "1"}], ")"}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "2"}], ")"}]}], "-", 
       RowBox[{"exp", 
        RowBox[{"(", "x", ")"}]}], "+", 
       RowBox[{"a", "*", "exp", 
        RowBox[{"(", "x", ")"}]}]}], ")"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "a"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"a", "-", "1"}], ")"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}]}]}], ")"}]}], "+", 
  RowBox[{
   RowBox[{"1", "/", "2"}], "*", 
   RowBox[{"a", "/", 
    RowBox[{"(", 
     RowBox[{"a", "-", "1"}], ")"}]}], "*", "dilog", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "a"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{"a", "-", "1"}], ")"}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "2"}], ")"}]}], "+", 
       RowBox[{"exp", 
        RowBox[{"(", "x", ")"}]}], "-", 
       RowBox[{"a", "*", "exp", 
        RowBox[{"(", "x", ")"}]}]}], ")"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "a"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"a", "-", "1"}], ")"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}]}]}], ")"}]}], "-", 
  RowBox[{
   RowBox[{"1", "/", "2"}], "*", 
   RowBox[{"a", "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", "a"}], ")"}]}], "*", "dilog", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "a"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{"a", "-", "1"}], ")"}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "2"}], ")"}]}], "-", 
       RowBox[{"exp", 
        RowBox[{"(", "x", ")"}]}], "-", 
       RowBox[{"a", "*", "exp", 
        RowBox[{"(", "x", ")"}]}]}], ")"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "a"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"a", "-", "1"}], ")"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}]}]}], ")"}]}], "-", 
  RowBox[{
   RowBox[{"1", "/", "2"}], "*", 
   RowBox[{"a", "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", "a"}], ")"}]}], "*", "dilog", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "a"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{"a", "-", "1"}], ")"}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "2"}], ")"}]}], "+", 
       RowBox[{"exp", 
        RowBox[{"(", "x", ")"}]}], "+", 
       RowBox[{"a", "*", "exp", 
        RowBox[{"(", "x", ")"}]}]}], ")"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "a"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"a", "-", "1"}], ")"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}]}]}], ")"}]}], "-", 
  RowBox[{
   RowBox[{"1", "/", "2"}], "*", "x", "*", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"ln", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "+", "a"}], ")"}], "*", 
              RowBox[{"(", 
               RowBox[{"a", "-", "1"}], ")"}]}], ")"}], "^", 
            RowBox[{"(", 
             RowBox[{"1", "/", "2"}], ")"}]}], "-", 
           RowBox[{"exp", 
            RowBox[{"(", "x", ")"}]}], "-", 
           RowBox[{"a", "*", "exp", 
            RowBox[{"(", "x", ")"}]}]}], ")"}], "/", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "a"}], ")"}], "*", 
            RowBox[{"(", 
             RowBox[{"a", "-", "1"}], ")"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"1", "/", "2"}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"ln", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "+", "a"}], ")"}], "*", 
              RowBox[{"(", 
               RowBox[{"a", "-", "1"}], ")"}]}], ")"}], "^", 
            RowBox[{"(", 
             RowBox[{"1", "/", "2"}], ")"}]}], "+", 
           RowBox[{"exp", 
            RowBox[{"(", "x", ")"}]}], "+", 
           RowBox[{"a", "*", "exp", 
            RowBox[{"(", "x", ")"}]}]}], ")"}], "/", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "a"}], ")"}], "*", 
            RowBox[{"(", 
             RowBox[{"a", "-", "1"}], ")"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"1", "/", "2"}], ")"}]}]}], ")"}]}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", "a"}], ")"}]}]}], "-", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", "2"}], "/", 
    RowBox[{"(", 
     RowBox[{"a", "-", "1"}], ")"}]}], "*", "ln", 
   RowBox[{"(", 
    RowBox[{"exp", 
     RowBox[{"(", "x", ")"}]}], ")"}], "*", "ln", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "a"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{"a", "-", "1"}], ")"}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "2"}], ")"}]}], "-", 
       RowBox[{"exp", 
        RowBox[{"(", "x", ")"}]}], "+", 
       RowBox[{"a", "*", "exp", 
        RowBox[{"(", "x", ")"}]}]}], ")"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "a"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"a", "-", "1"}], ")"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}]}]}], ")"}]}], "-", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", "2"}], "/", 
    RowBox[{"(", 
     RowBox[{"a", "-", "1"}], ")"}]}], "*", "ln", 
   RowBox[{"(", 
    RowBox[{"exp", 
     RowBox[{"(", "x", ")"}]}], ")"}], "*", "ln", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "a"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{"a", "-", "1"}], ")"}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "2"}], ")"}]}], "+", 
       RowBox[{"exp", 
        RowBox[{"(", "x", ")"}]}], "-", 
       RowBox[{"a", "*", "exp", 
        RowBox[{"(", "x", ")"}]}]}], ")"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "a"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"a", "-", "1"}], ")"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}]}]}], ")"}]}], "+", 
  RowBox[{
   RowBox[{"1", "/", "2"}], "*", "x", "*", "ln", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"exp", 
         RowBox[{"(", 
          RowBox[{"2", "*", "x"}], ")"}]}]}], ")"}], "*", "a"}], "+", 
     RowBox[{"exp", 
      RowBox[{"(", 
       RowBox[{"2", "*", "x"}], ")"}]}], "+", "1"}], ")"}]}], "-", 
  RowBox[{
   RowBox[{"1", "/", "2"}], "*", "ln", 
   RowBox[{"(", 
    RowBox[{"exp", 
     RowBox[{"(", "x", ")"}]}], ")"}], "*", "ln", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "a"}], "+", 
     RowBox[{"a", "*", "exp", 
      RowBox[{"(", 
       RowBox[{"2", "*", "x"}], ")"}]}], "-", "1", "-", 
     RowBox[{"exp", 
      RowBox[{"(", 
       RowBox[{"2", "*", "x"}], ")"}]}]}], ")"}]}], "-", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", "2"}], "/", 
    RowBox[{"(", 
     RowBox[{"a", "-", "1"}], ")"}]}], "*", "dilog", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "a"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{"a", "-", "1"}], ")"}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "2"}], ")"}]}], "+", 
       RowBox[{"exp", 
        RowBox[{"(", "x", ")"}]}], "-", 
       RowBox[{"a", "*", "exp", 
        RowBox[{"(", "x", ")"}]}]}], ")"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "a"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"a", "-", "1"}], ")"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}]}]}], ")"}]}], "-", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", "2"}], "/", 
    RowBox[{"(", 
     RowBox[{"a", "-", "1"}], ")"}]}], "*", "dilog", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "a"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{"a", "-", "1"}], ")"}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "2"}], ")"}]}], "-", 
       RowBox[{"exp", 
        RowBox[{"(", "x", ")"}]}], "+", 
       RowBox[{"a", "*", "exp", 
        RowBox[{"(", "x", ")"}]}]}], ")"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "a"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"a", "-", "1"}], ")"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}]}]}], ")"}]}], "-", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", "2"}], "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", "a"}], ")"}]}], "*", "dilog", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "a"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{"a", "-", "1"}], ")"}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "2"}], ")"}]}], "-", 
       RowBox[{"exp", 
        RowBox[{"(", "x", ")"}]}], "-", 
       RowBox[{"a", "*", "exp", 
        RowBox[{"(", "x", ")"}]}]}], ")"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "a"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"a", "-", "1"}], ")"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}]}]}], ")"}]}], "-", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", "2"}], "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", "a"}], ")"}]}], "*", "dilog", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "a"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{"a", "-", "1"}], ")"}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "2"}], ")"}]}], "+", 
       RowBox[{"exp", 
        RowBox[{"(", "x", ")"}]}], "+", 
       RowBox[{"a", "*", "exp", 
        RowBox[{"(", "x", ")"}]}]}], ")"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "a"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"a", "-", "1"}], ")"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{{3.490227294357878*^9, 3.490227313530312*^9}}]
}, Closed]],

Cell["", "Text"],

Cell["\<\
Note that these systems give similar results to the above for the hyperbolic \
arccotangent function.\
\>", "Subsubtitle",
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832040958843503`*^9, 3.4832041044566765`*^9}, 3.483204218670909*^9, 
   3.4833920379275217`*^9, {3.483392125182989*^9, 3.4833921454921923`*^9}, {
   3.48339221312945*^9, 3.483392219528651*^9}, {3.483392987983635*^9, 
   3.4833931408334227`*^9}, {3.4833932165322723`*^9, 3.483393223472251*^9}, {
   3.483395056508027*^9, 3.4833950705081587`*^9}, {3.4833959109166064`*^9, 
   3.483395925577688*^9}, {3.483395964633848*^9, 3.4833959819287167`*^9}, {
   3.4833961127468243`*^9, 3.483396122781253*^9}, 3.490048900827781*^9, 
   3.4900489594451337`*^9, {3.4902128221680546`*^9, 3.4902128464728975`*^9}, {
   3.4902329392289867`*^9, 3.49023294124139*^9}}],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Inverse Hyperbolic Function Integration Problem 5", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, {3.4821973084456434`*^9, 3.482197309066536*^9}, {
   3.4821982364300194`*^9, 3.482198240976557*^9}, 3.482198357524144*^9, {
   3.4821988021534896`*^9, 3.4821988078316545`*^9}, 3.4821989164378223`*^9, {
   3.482198948964594*^9, 3.4821989770249424`*^9}, 3.4821998630289536`*^9, 
   3.4901481958869305`*^9, 3.4902117069720955`*^9, 3.4902265829606295`*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"ArcSinh", "[", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
   3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
   3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.4821994315485153`*^9, 
   3.4901483010779157`*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " uses the substitution u=a+b x to generalize rule:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443225459641647`*^9, 3.4443225485078225`*^9}, {
   3.4466948911496077`*^9, 3.42301074665625*^9}, 3.42317159478125*^9, {
   3.423174840640625*^9, 3.423174854046875*^9}, {3.4233322945*^9, 
   3.4233323091875*^9}, {3.42333236403125*^9, 3.423332366546875*^9}, {
   3.423332643984375*^9, 3.42333264684375*^9}, {3.423338772921875*^9, 
   3.423338774734375*^9}, 3.423341072796875*^9, {3.423341460375*^9, 
   3.4233414605625*^9}, {3.42335786965625*^9, 3.423357883921875*^9}, {
   3.455347583937736*^9, 3.455347624856574*^9}, 3.4821992623351984`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{"ArcSinh", "[", 
    SuperscriptBox["\[ExponentialE]", "x"], "]"}], ",", " ", "x"}], 
  "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
  3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
  3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
  3.423616874609375*^9, 3.42361688925*^9}, {3.455334181485957*^9, 
  3.455334194264331*^9}, {3.4553471254684896`*^9, 3.455347126660203*^9}, {
  3.455347168590496*^9, 3.455347170423131*^9}, {3.4553474605803566`*^9, 
  3.4553474615517535`*^9}, {3.4553478671349535`*^9, 3.4553479098263407`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox[
    RowBox[{"ArcSinh", "[", 
     SuperscriptBox["\[ExponentialE]", "x"], "]"}], "2"]}], "+", 
  RowBox[{
   RowBox[{"ArcSinh", "[", 
    SuperscriptBox["\[ExponentialE]", "x"], "]"}], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       RowBox[{"ArcSinh", "[", 
        SuperscriptBox["\[ExponentialE]", "x"], "]"}]}]]}], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       RowBox[{"ArcSinh", "[", 
        SuperscriptBox["\[ExponentialE]", "x"], "]"}]}]]}], 
    "]"}]}]}]], "Output",
 CellChangeTimes->{3.4901480204022226`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{"ArcSinh", "[", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]], "]"}], ",", " ", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, {
   3.444349991088315*^9, 3.423171727*^9}, {3.42361689675*^9, 
   3.423616909609375*^9}, 3.455334184320032*^9, {3.4553342246880784`*^9, 
   3.4553342261301517`*^9}, {3.4553342969019165`*^9, 3.455334298233832*^9}, {
   3.4553471997953663`*^9, 3.4553472071859937`*^9}, {3.455347873984803*^9, 
   3.4553478754368916`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SuperscriptBox[
    RowBox[{"ArcSinh", "[", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]], "]"}], "2"], 
   RowBox[{"2", " ", "b"}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"ArcSinh", "[", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]], "]"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "2"}], " ", 
        RowBox[{"ArcSinh", "[", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}]], "]"}]}]]}], "]"}]}], "b"], "-", 
  FractionBox[
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       RowBox[{"ArcSinh", "[", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}]], "]"}]}]]}], "]"}], 
   RowBox[{"2", " ", "b"}]]}]], "Output",
 CellChangeTimes->{
  3.4553468542785378`*^9, {3.4553472025493264`*^9, 3.45534720758657*^9}, 
   3.4553478720920815`*^9, 3.490148028202236*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "does not use the substitution u=a+b x to generalize rule:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500256179667`*^9}, {3.4466836176090527`*^9, 3.446683618790752*^9}, {
   3.4466950388319645`*^9, 3.423171727*^9}, {3.423617028171875*^9, 
   3.4236170379375*^9}, {3.4553479526979876`*^9, 3.4553479664477587`*^9}, 
   3.4821993033742094`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"ArcSinh", "[", 
    SuperscriptBox["\[ExponentialE]", "x"], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
   3.4443498869285407`*^9}, {3.444349974083864*^9, 3.423171727*^9}, 
   3.423616899578125*^9, {3.455334328146845*^9, 3.455334346853744*^9}, {
   3.455347028589184*^9, 3.4553470351786594`*^9}, {3.455347077739859*^9, 
   3.455347084088989*^9}, {3.455347223879998*^9, 3.4553472252820144`*^9}, {
   3.455347418329603*^9, 3.4553474190906973`*^9}, {3.4553479192198477`*^9, 
   3.4553479280225058`*^9}, {3.455348103234448*^9, 3.4553481049168673`*^9}, {
   3.4901480508378763`*^9, 3.4901480567970867`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", " ", 
   RowBox[{"ArcSinh", "[", 
    SuperscriptBox["\[ExponentialE]", "x"], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox[
    RowBox[{"ArcSinh", "[", 
     SuperscriptBox["\[ExponentialE]", "x"], "]"}], "2"]}], "+", 
  RowBox[{
   RowBox[{"ArcSinh", "[", 
    SuperscriptBox["\[ExponentialE]", "x"], "]"}], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       RowBox[{"ArcSinh", "[", 
        SuperscriptBox["\[ExponentialE]", "x"], "]"}]}]]}], "]"}]}], "-", 
  RowBox[{"x", " ", 
   RowBox[{"Log", "[", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", "x"], "+", 
     SqrtBox[
      RowBox[{"1", "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "x"}]]}]]}], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       RowBox[{"ArcSinh", "[", 
        SuperscriptBox["\[ExponentialE]", "x"], "]"}]}]]}], 
    "]"}]}]}]], "Output",
 CellChangeTimes->{{3.4553345133832016`*^9, 3.4553345257509856`*^9}, 
   3.4553345761534605`*^9, {3.4553346108834*^9, 3.4553346169521265`*^9}, 
   3.4553469166181774`*^9, {3.455347029170019*^9, 3.4553470358996964`*^9}, {
   3.455347080593963*^9, 3.4553470845596657`*^9}, 3.4553472273449807`*^9, 
   3.4553474203224688`*^9, {3.4553479224745283`*^9, 3.455347928413067*^9}, {
   3.490148046563469*^9, 3.4901480523198786`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"ArcSinh", "[", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
  3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
  3.4443498869285407`*^9}, {3.4443499715902786`*^9, 3.423171727*^9}, {
  3.423616902765625*^9, 3.423616905984375*^9}, {3.455346949345237*^9, 
  3.4553469519389668`*^9}, {3.455347010242803*^9, 3.455347011544675*^9}, {
  3.4553470654321613`*^9, 3.45534706579268*^9}, {3.4553470967471905`*^9, 
  3.4553470986899843`*^9}, {3.455347239051814*^9, 3.45534724229648*^9}, {
  3.4553474305271425`*^9, 3.4553474314484673`*^9}, {3.455347940029771*^9, 
  3.45534794114137*^9}, {3.455348107600726*^9, 3.4553481090828576`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"ArcSinh", "[", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.44434988769965*^9, {3.4466836278337555`*^9, 3.423171727*^9}, 
   3.4236170036875*^9, 3.455346953070594*^9, 3.455347013477454*^9, 
   3.4553470664336014`*^9, 3.45534709909056*^9, 3.455347243347992*^9, 
   3.4553474328304543`*^9, 3.455347941982579*^9, 3.490148060603493*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " is unable to integrate either expression:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500407697535`*^9}, {3.444350203233365*^9, 3.4443502040245028`*^9}, {
   3.444350234528365*^9, 3.4443502387243986`*^9}, {3.4466836227764835`*^9, 
   3.4466836230168285`*^9}, {3.4466839811618156`*^9, 
   3.4466839896239843`*^9}, {3.4466950433384447`*^9, 3.42301083234375*^9}, 
   3.423171727*^9, 3.423617053328125*^9, {3.4553480765961437`*^9, 
   3.455348092218608*^9}, 3.482199323663384*^9, {3.490150678022091*^9, 
   3.490150723995372*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"arcsinh", 
      RowBox[{"(", 
       RowBox[{"exp", 
        RowBox[{"(", "x", ")"}]}], ")"}]}], ",", " ", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444350078924618*^9, 3.423171727*^9}, {
  3.4236169183125*^9, 3.423616928921875*^9}, {3.4553480452110147`*^9, 
  3.4553480557261343`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"ArcSinh", "[", 
    SuperscriptBox["\[ExponentialE]", "x"], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellChangeTimes->{{3.45534811980828*^9, 3.455348119838323*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"arcsinh", 
      RowBox[{"(", 
       RowBox[{"exp", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}]}], ",", " ", "x"}], 
    ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444350078924618*^9, 3.423171727*^9}, {
  3.4236169183125*^9, 3.423616928921875*^9}, {3.4553480452110147`*^9, 
  3.4553480685545807`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"ArcSinh", "[", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input"]
}, Closed]],

Cell["", "Text"],

Cell["\<\
Note that these systems give similar results to the above for the hyperbolic \
arccosine function.\
\>", "Subsubtitle",
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832040958843503`*^9, 3.4832041044566765`*^9}, 3.483204218670909*^9, 
   3.4833920379275217`*^9, {3.483392125182989*^9, 3.4833921454921923`*^9}, {
   3.48339221312945*^9, 3.483392219528651*^9}, {3.483392987983635*^9, 
   3.4833931408334227`*^9}, {3.4833932165322723`*^9, 3.483393223472251*^9}, {
   3.483395056508027*^9, 3.4833950705081587`*^9}, {3.4833959109166064`*^9, 
   3.483395925577688*^9}, {3.483395964633848*^9, 3.4833959819287167`*^9}, {
   3.4833961127468243`*^9, 3.483396122781253*^9}, 3.490048900827781*^9, 
   3.4900489594451337`*^9, {3.4902128221680546`*^9, 3.4902128464728975`*^9}, {
   3.4902134682243896`*^9, 3.490213470798394*^9}, {3.490232944158595*^9, 
   3.490232944751396*^9}}]
}, Open  ]]
},
AutoGeneratedPackage->None,
CellGrouping->Manual,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  None, None, None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->{{28.8, 28.8}, {14.4, 14.4}}},
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 1001, 15, 69, "Title"],
Cell[1571, 39, 1092, 23, 72, "Subtitle"],
Cell[CellGroupData[{
Cell[2688, 66, 1826, 28, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[4517, 96, 1197, 21, 64, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[5717, 119, 1527, 47, 57, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[7281, 171, 1463, 26, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[8747, 199, 1138, 21, 64, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[9888, 222, 4478, 127, 164, "Output"],
Cell[14369, 351, 1474, 29, 65, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[15846, 382, 1118, 40, 57, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[17001, 427, 1849, 28, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[18853, 457, 830, 20, 47, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[19686, 479, 1527, 47, 57, "Output"]
}, Closed]],
Cell[21228, 529, 16, 0, 26, "Text"],
Cell[21247, 531, 1921, 27, 28, "Subsubtitle"],
Cell[23171, 560, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[23252, 566, 1025, 15, 69, "Title"],
Cell[24280, 583, 1106, 25, 74, "Subtitle"],
Cell[CellGroupData[{
Cell[25411, 612, 1765, 27, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[27179, 641, 1111, 21, 65, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[28293, 664, 5435, 181, 163, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[33765, 850, 1398, 24, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[35166, 876, 1150, 22, 65, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[36319, 900, 446, 12, 48, "Output"],
Cell[36768, 914, 1442, 30, 70, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[38213, 946, 4925, 169, 149, "Output"],
Cell[43141, 1117, 2183, 52, 89, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[45327, 1171, 9108, 271, 379, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[54472, 1447, 1663, 26, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[56138, 1475, 849, 21, 48, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[56990, 1498, 5435, 181, 163, "Output"]
}, Closed]],
Cell[62440, 1682, 16, 0, 26, "Text"],
Cell[62459, 1684, 1919, 27, 28, "Subsubtitle"],
Cell[64381, 1713, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[64462, 1719, 977, 15, 69, "Title"],
Cell[65442, 1736, 869, 20, 72, "Subtitle"],
Cell[CellGroupData[{
Cell[66336, 1760, 1652, 25, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[67991, 1787, 869, 17, 64, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[68863, 1806, 610, 19, 49, "Output"],
Cell[69476, 1827, 850, 17, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[70329, 1846, 580, 18, 47, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[70946, 1869, 1243, 20, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[72192, 1891, 963, 18, 64, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[73158, 1911, 584, 18, 55, "Output"],
Cell[73745, 1931, 1094, 20, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[74842, 1953, 814, 22, 47, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Closed]],
Cell[CellGroupData[{
Cell[75693, 1980, 1731, 27, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[77427, 2009, 655, 17, 47, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[78085, 2028, 452, 16, 49, "Output"],
Cell[78540, 2046, 711, 17, 47, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[79254, 2065, 2050, 71, 30, "Output"]
}, Closed]],
Cell[81319, 2139, 16, 0, 26, "Text"],
Cell[81338, 2141, 1921, 27, 28, "Subsubtitle"],
Cell[83262, 2170, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[83343, 2176, 1025, 15, 69, "Title"],
Cell[84371, 2193, 1103, 23, 68, "Subtitle"],
Cell[CellGroupData[{
Cell[85499, 2220, 1876, 29, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[87378, 2251, 1287, 22, 45, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[88668, 2275, 1979, 64, 47, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[90684, 2344, 1499, 23, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[92186, 2369, 1168, 20, 58, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[93357, 2391, 10257, 306, 277, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[103651, 2702, 1895, 29, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[105549, 2733, 826, 18, 45, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[106378, 2753, 24817, 842, 395, "Output"]
}, Closed]],
Cell[131210, 3598, 16, 0, 26, "Text"],
Cell[131229, 3600, 1918, 27, 28, "Subsubtitle"],
Cell[133150, 3629, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[133231, 3635, 1025, 15, 69, "Title"],
Cell[134259, 3652, 839, 20, 68, "Subtitle"],
Cell[CellGroupData[{
Cell[135123, 3676, 1243, 20, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[136369, 3698, 750, 14, 49, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[137122, 3714, 863, 27, 47, "Output"],
Cell[137988, 3743, 761, 15, 49, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[138752, 3760, 1223, 37, 60, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[140012, 3802, 925, 16, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[140940, 3820, 908, 16, 59, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[141851, 3838, 1595, 43, 46, "Output"],
Cell[143449, 3883, 974, 18, 59, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[144426, 3903, 585, 13, 43, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Closed]],
Cell[CellGroupData[{
Cell[145048, 3921, 1104, 19, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[146155, 3942, 472, 14, 47, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[146630, 3958, 246, 6, 43, "Input"],
Cell[146879, 3966, 535, 16, 47, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[147417, 3984, 234, 7, 43, "Input"]
}, Closed]],
Cell[147666, 3994, 16, 0, 26, "Text"],
Cell[147685, 3996, 1966, 28, 28, "Subsubtitle"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
