(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    221492,       6041]
NotebookOptionsPosition[    206727,       5664]
NotebookOutlinePosition[    207787,       5702]
CellTagsIndexPosition[    207744,       5699]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Hyperbolic Function Integration Problem 1", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, 3.4821972798144736`*^9, {3.483501408417347*^9, 
   3.4835014103501263`*^9}, 3.4835020744450483`*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   RowBox[{"Tanh", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
   3.4821971019086576`*^9, 3.4835014138551664`*^9, {3.490325300967321*^9, 
   3.4903253058573275`*^9}, 3.4903831624133854`*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " returns m+2 term sums for positive integer m:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.423010751609375*^9}, 3.423171727*^9, {
   3.423617016203125*^9, 3.423617021953125*^9}, {3.4551611708178835`*^9, 
   3.4551611938710318`*^9}, {3.455301288367976*^9, 3.455301294927408*^9}, 
   3.4821973766136637`*^9, {3.482646056585701*^9, 3.48264606118231*^9}, {
   3.4835014785582047`*^9, 3.483501501871728*^9}, {3.4903250350169487`*^9, 
   3.4903250464269643`*^9}, {3.490325417767484*^9, 3.490325419857487*^9}, {
   3.4903254679775543`*^9, 3.490325474437564*^9}, {3.4903262912787075`*^9, 
   3.4903262939187107`*^9}, {3.4903265177890244`*^9, 3.490326520599028*^9}, {
   3.4903278924809484`*^9, 3.490327897130955*^9}}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"Tanh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, 3.455160946845827*^9, 
   3.4553005800394497`*^9, {3.4553007283527136`*^9, 3.455300744445854*^9}, 
   3.4835014173001204`*^9, 3.490324918326785*^9, 3.490325238247233*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"]}], "+", 
  FractionBox[
   RowBox[{"x", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"2", " ", "a"}], "+", 
        RowBox[{"2", " ", "b", " ", "x"}]}]]}], "]"}]}], "b"], "+", 
  FractionBox[
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     RowBox[{"-", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"2", " ", "a"}], "+", 
        RowBox[{"2", " ", "b", " ", "x"}]}]]}]}], "]"}], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "2"]}]]}]], "Output",
 CellChangeTimes->{
  3.45516116211537*^9, {3.45530072240416*^9, 3.455300734621728*^9}, 
   3.4835014220769887`*^9, 3.4903253230973516`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    RowBox[{"Tanh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, 3.455160946845827*^9, 
   3.4553005800394497`*^9, {3.4553007283527136`*^9, 3.455300744445854*^9}, 
   3.4835014173001204`*^9, 3.490324918326785*^9, {3.4903252264272165`*^9, 
   3.490325230087221*^9}, 3.490325327527358*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    SuperscriptBox["x", "3"], "3"]}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"2", " ", "a"}], "+", 
        RowBox[{"2", " ", "b", " ", "x"}]}]]}], "]"}]}], "b"], "+", 
  FractionBox[
   RowBox[{"x", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      RowBox[{"-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"2", " ", "a"}], "+", 
         RowBox[{"2", " ", "b", " ", "x"}]}]]}]}], "]"}]}], 
   SuperscriptBox["b", "2"]], "-", 
  FractionBox[
   RowBox[{"PolyLog", "[", 
    RowBox[{"3", ",", 
     RowBox[{"-", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"2", " ", "a"}], "+", 
        RowBox[{"2", " ", "b", " ", "x"}]}]]}]}], "]"}], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "3"]}]]}]], "Output",
 CellChangeTimes->{3.490325231077223*^9, 3.490325329997361*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "3"], " ", 
    RowBox[{"Tanh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, 3.455160946845827*^9, 
   3.4553005800394497`*^9, {3.4553007283527136`*^9, 3.455300744445854*^9}, 
   3.4835014173001204`*^9, 3.490324918326785*^9, {3.4903252264272165`*^9, 
   3.4903252768572865`*^9}, {3.490325339597375*^9, 3.4903253406273766`*^9}, 
   3.4903254861975803`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    SuperscriptBox["x", "4"], "4"]}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["x", "3"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"2", " ", "a"}], "+", 
        RowBox[{"2", " ", "b", " ", "x"}]}]]}], "]"}]}], "b"], "+", 
  FractionBox[
   RowBox[{"3", " ", 
    SuperscriptBox["x", "2"], " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      RowBox[{"-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"2", " ", "a"}], "+", 
         RowBox[{"2", " ", "b", " ", "x"}]}]]}]}], "]"}]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "2"]}]], "-", 
  FractionBox[
   RowBox[{"3", " ", "x", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"3", ",", 
      RowBox[{"-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"2", " ", "a"}], "+", 
         RowBox[{"2", " ", "b", " ", "x"}]}]]}]}], "]"}]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "3"]}]], "+", 
  FractionBox[
   RowBox[{"3", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"4", ",", 
      RowBox[{"-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"2", " ", "a"}], "+", 
         RowBox[{"2", " ", "b", " ", "x"}]}]]}]}], "]"}]}], 
   RowBox[{"4", " ", 
    SuperscriptBox["b", "4"]}]]}]], "Output",
 CellChangeTimes->{{3.490325264037269*^9, 3.4903252803172917`*^9}, 
   3.4903253423573785`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " returns a 10 term sum involving the imaginary unit when m is 1:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500256179667`*^9}, {3.4466836176090527`*^9, 3.446683618790752*^9}, {
   3.4466950388319645`*^9, 3.423171727*^9}, {3.423617028171875*^9, 
   3.4236170379375*^9}, {3.4551611997394705`*^9, 3.455161216653792*^9}, {
   3.4551617691582546`*^9, 3.4551617721625743`*^9}, {3.4553013112408657`*^9, 
   3.4553013170191746`*^9}, 3.482197631430072*^9, {3.482646064727408*^9, 
   3.4826460783369775`*^9}, {3.483501487350848*^9, 3.4835015151508226`*^9}, {
   3.490325053236974*^9, 3.4903250694869967`*^9}, {3.4903255523976727`*^9, 
   3.4903255581676807`*^9}, {3.4903263122587366`*^9, 
   3.4903263171887436`*^9}, {3.4903280257311354`*^9, 3.4903280374411516`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"x", " ", 
   RowBox[{"Tanh", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
   3.4443498869285407`*^9}, {3.444349974083864*^9, 3.423171727*^9}, 
   3.423616899578125*^9, 3.4551609499803343`*^9, 3.455300583524461*^9, {
   3.4553007522871294`*^9, 3.455300752978123*^9}, {3.455300906999595*^9, 
   3.4553009429312625`*^9}, {3.45531384536405*^9, 3.455313846876224*^9}, {
   3.4835014285462914`*^9, 3.4835014572175183`*^9}, {3.490324964336849*^9, 
   3.490324965666851*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "\[Pi]", " ", "x"}], 
   RowBox[{"2", " ", "b"}]], "+", 
  FractionBox[
   RowBox[{"x", " ", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{"Coth", "[", "a", "]"}], "]"}]}], "b"], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "\[Pi]", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "b", " ", "x"}]]}], "]"}]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "2"]}]], "+", 
  FractionBox[
   RowBox[{"x", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "2"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "x"}], "+", 
          RowBox[{"ArcTanh", "[", 
           RowBox[{"Coth", "[", "a", "]"}], "]"}]}], ")"}]}]]}], "]"}]}], 
   "b"], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"ArcTanh", "[", 
     RowBox[{"Coth", "[", "a", "]"}], "]"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "2"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "x"}], "+", 
          RowBox[{"ArcTanh", "[", 
           RowBox[{"Coth", "[", "a", "]"}], "]"}]}], ")"}]}]]}], "]"}]}], 
   SuperscriptBox["b", "2"]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "\[Pi]", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"Cosh", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "]"}]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "2"]}]], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"ArcTanh", "[", 
     RowBox[{"Coth", "[", "a", "]"}], "]"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"Sinh", "[", 
       RowBox[{
        RowBox[{"b", " ", "x"}], "+", 
        RowBox[{"ArcTanh", "[", 
         RowBox[{"Coth", "[", "a", "]"}], "]"}]}], "]"}]}], "]"}]}], 
   SuperscriptBox["b", "2"]], "-", 
  FractionBox[
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", " ", "x"}], "+", 
         RowBox[{"ArcTanh", "[", 
          RowBox[{"Coth", "[", "a", "]"}], "]"}]}], ")"}]}]]}], "]"}], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "2"]}]], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox["x", "2"], " ", 
   RowBox[{"Tanh", "[", "a", "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     RowBox[{"ArcTanh", "[", 
      RowBox[{"Coth", "[", "a", "]"}], "]"}]}]], " ", 
   SuperscriptBox["x", "2"], " ", 
   SqrtBox[
    RowBox[{"-", 
     SuperscriptBox[
      RowBox[{"Csch", "[", "a", "]"}], "2"]}]], " ", 
   RowBox[{"Tanh", "[", "a", "]"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.444349997838021*^9, {3.446683614354373*^9, 3.423171727*^9}, 
   3.4236169960625*^9, 3.4551610636437745`*^9, {3.4553007497534866`*^9, 
   3.455300756983883*^9}, {3.455300917494686*^9, 3.4553009436322703`*^9}, {
   3.483501438059971*^9, 3.483501459170326*^9}, 3.4903249645468493`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   RowBox[{"Tanh", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
   3.4443498869285407`*^9}, {3.444349974083864*^9, 3.423171727*^9}, 
   3.423616899578125*^9, 3.4551609499803343`*^9, 3.455300583524461*^9, {
   3.4553007522871294`*^9, 3.455300752978123*^9}, {3.455300906999595*^9, 
   3.4553009429312625`*^9}, {3.45531384536405*^9, 3.455313846876224*^9}, {
   3.4835014285462914`*^9, 3.4835014572175183`*^9}, {3.490324964336849*^9, 
   3.490324965666851*^9}, {3.490325504107605*^9, 3.4903255235776324`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    SuperscriptBox["x", "3"], "3"]}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}]}]]}], "]"}]}], "b"], "+", 
  FractionBox[
   RowBox[{"x", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      RowBox[{"-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}]}]]}]}], "]"}]}], 
   SuperscriptBox["b", "2"]], "-", 
  FractionBox[
   RowBox[{"PolyLog", "[", 
    RowBox[{"3", ",", 
     RowBox[{"-", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}]}]]}]}], "]"}], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "3"]}]]}]], "Output",
 CellChangeTimes->{{3.4903255132476177`*^9, 3.490325518987626*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "3"], " ", 
   RowBox[{"Tanh", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
   3.4443498869285407`*^9}, {3.444349974083864*^9, 3.423171727*^9}, 
   3.423616899578125*^9, 3.4551609499803343`*^9, 3.455300583524461*^9, {
   3.4553007522871294`*^9, 3.455300752978123*^9}, {3.455300906999595*^9, 
   3.4553009429312625`*^9}, {3.45531384536405*^9, 3.455313846876224*^9}, {
   3.4835014285462914`*^9, 3.4835014572175183`*^9}, {3.490324964336849*^9, 
   3.490324965666851*^9}, {3.490325504107605*^9, 3.4903255388376536`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    SuperscriptBox["x", "4"], "4"]}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["x", "3"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}]}]]}], "]"}]}], "b"], "+", 
  FractionBox[
   RowBox[{"3", " ", 
    SuperscriptBox["x", "2"], " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      RowBox[{"-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}]}]]}]}], "]"}]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "2"]}]], "-", 
  FractionBox[
   RowBox[{"3", " ", "x", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"3", ",", 
      RowBox[{"-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}]}]]}]}], "]"}]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "3"]}]], "+", 
  FractionBox[
   RowBox[{"3", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"4", ",", 
      RowBox[{"-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}]}]]}]}], "]"}]}], 
   RowBox[{"4", " ", 
    SuperscriptBox["b", "4"]}]]}]], "Output",
 CellChangeTimes->{{3.4903255303676414`*^9, 3.4903255344076476`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " returns m+5 term sums, 3 of which are superfluous since their derivative \
is zero:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500407697535`*^9}, {3.444350203233365*^9, 3.4443502040245028`*^9}, {
   3.444350234528365*^9, 3.4443502387243986`*^9}, {3.4466836227764835`*^9, 
   3.4466836230168285`*^9}, {3.4466839811618156`*^9, 
   3.4466839896239843`*^9}, {3.4466950433384447`*^9, 3.42301083234375*^9}, 
   3.423171727*^9, 3.423617053328125*^9, 3.4551612040056047`*^9, {
   3.455161485800806*^9, 3.4551615297640224`*^9}, {3.4551615721750064`*^9, 
   3.4551615749690237`*^9}, {3.4551616579984145`*^9, 
   3.4551617378031683`*^9}, {3.455301326643013*^9, 3.455301334934936*^9}, 
   3.4821976652386866`*^9, {3.4826460834643507`*^9, 3.4826460874000096`*^9}, 
   3.483501586473379*^9, {3.4835019626242576`*^9, 3.4835019701050143`*^9}, {
   3.483502039054158*^9, 3.4835020455134463`*^9}, {3.483585779337654*^9, 
   3.4835857853262653`*^9}, {3.4903250771170073`*^9, 
   3.4903250909970264`*^9}, {3.490326261378665*^9, 3.4903262833286963`*^9}, {
   3.49032640034886*^9, 3.4903264021688623`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"x", "*", "tanh", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444350078924618*^9, 3.423171727*^9}, {
   3.4236169183125*^9, 3.423616928921875*^9}, {3.455160953425288*^9, 
   3.455160953875936*^9}, {3.4553005931683283`*^9, 3.4553006040339518`*^9}, 
   3.4835015373227043`*^9, 3.490324890996747*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    SuperscriptBox["a", "2"], 
    SuperscriptBox["b", "2"]]}], "-", 
  FractionBox[
   RowBox[{"2", " ", "a", " ", "x"}], "b"], "-", 
  FractionBox[
   SuperscriptBox["x", "2"], "2"], "+", 
  FractionBox[
   RowBox[{"2", " ", "a", " ", 
    RowBox[{"Log", "[", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]], "]"}]}], 
   SuperscriptBox["b", "2"]], "+", 
  FractionBox[
   RowBox[{"x", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"2", " ", "a"}], "+", 
        RowBox[{"2", " ", "b", " ", "x"}]}]]}], "]"}]}], "b"], "+", 
  FractionBox[
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     RowBox[{"-", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"2", " ", "a"}], "+", 
        RowBox[{"2", " ", "b", " ", "x"}]}]]}]}], "]"}], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "2"]}]]}]], "Output",
 CellChangeTimes->{{3.490325695247873*^9, 3.490325709227892*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "*", "tanh", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444350078924618*^9, 3.423171727*^9}, {
   3.4236169183125*^9, 3.423616928921875*^9}, {3.455160953425288*^9, 
   3.455160953875936*^9}, {3.4553005931683283`*^9, 3.4553006040339518`*^9}, 
   3.4835015373227043`*^9, 3.490324890996747*^9, {3.4903256074677496`*^9, 
   3.4903256077677503`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"4", " ", 
    SuperscriptBox["a", "3"]}], 
   RowBox[{"3", " ", 
    SuperscriptBox["b", "3"]}]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    SuperscriptBox["a", "2"], " ", "x"}], 
   SuperscriptBox["b", "2"]], "-", 
  FractionBox[
   SuperscriptBox["x", "3"], "3"], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"Log", "[", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]], "]"}]}], 
   SuperscriptBox["b", "3"]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"2", " ", "a"}], "+", 
        RowBox[{"2", " ", "b", " ", "x"}]}]]}], "]"}]}], "b"], "+", 
  FractionBox[
   RowBox[{"x", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      RowBox[{"-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"2", " ", "a"}], "+", 
         RowBox[{"2", " ", "b", " ", "x"}]}]]}]}], "]"}]}], 
   SuperscriptBox["b", "2"]], "-", 
  FractionBox[
   RowBox[{"PolyLog", "[", 
    RowBox[{"3", ",", 
     RowBox[{"-", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"2", " ", "a"}], "+", 
        RowBox[{"2", " ", "b", " ", "x"}]}]]}]}], "]"}], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "3"]}]]}]], "Output",
 CellChangeTimes->{{3.490326041018357*^9, 3.4903260471883655`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "3"}], "*", "tanh", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444350078924618*^9, 3.423171727*^9}, {
   3.4236169183125*^9, 3.423616928921875*^9}, {3.455160953425288*^9, 
   3.455160953875936*^9}, {3.4553005931683283`*^9, 3.4553006040339518`*^9}, 
   3.4835015373227043`*^9, 3.490324890996747*^9, {3.4903256074677496`*^9, 
   3.4903256209477687`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"3", " ", 
    SuperscriptBox["a", "4"]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "4"]}]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    SuperscriptBox["a", "3"], " ", "x"}], 
   SuperscriptBox["b", "3"]], "-", 
  FractionBox[
   SuperscriptBox["x", "4"], "4"], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    SuperscriptBox["a", "3"], " ", 
    RowBox[{"Log", "[", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]], "]"}]}], 
   SuperscriptBox["b", "4"]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["x", "3"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"2", " ", "a"}], "+", 
        RowBox[{"2", " ", "b", " ", "x"}]}]]}], "]"}]}], "b"], "+", 
  FractionBox[
   RowBox[{"3", " ", 
    SuperscriptBox["x", "2"], " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      RowBox[{"-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"2", " ", "a"}], "+", 
         RowBox[{"2", " ", "b", " ", "x"}]}]]}]}], "]"}]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "2"]}]], "-", 
  FractionBox[
   RowBox[{"3", " ", "x", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"3", ",", 
      RowBox[{"-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"2", " ", "a"}], "+", 
         RowBox[{"2", " ", "b", " ", "x"}]}]]}]}], "]"}]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "3"]}]], "+", 
  FractionBox[
   RowBox[{"3", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"4", ",", 
      RowBox[{"-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"2", " ", "a"}], "+", 
         RowBox[{"2", " ", "b", " ", "x"}]}]]}]}], "]"}]}], 
   RowBox[{"4", " ", 
    SuperscriptBox["b", "4"]}]]}]], "Output",
 CellChangeTimes->{{3.4903262215486097`*^9, 3.490326235768629*^9}}]
}, Closed]],

Cell["", "Text"],

Cell["\<\
Note that these systems give similar results to the above for the hyperbolic \
cotangent function.\
\>", "Subsubtitle",
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832040958843503`*^9, 3.4832041044566765`*^9}, 3.483204218670909*^9, 
   3.4833920379275217`*^9, {3.483392125182989*^9, 3.4833921454921923`*^9}, {
   3.48339221312945*^9, 3.483392219528651*^9}, {3.483392987983635*^9, 
   3.4833931408334227`*^9}, {3.4833932165322723`*^9, 3.483393223472251*^9}, {
   3.483395056508027*^9, 3.4833950705081587`*^9}, {3.4833959109166064`*^9, 
   3.483395925577688*^9}, {3.483395964633848*^9, 3.4833959819287167`*^9}, {
   3.4833961127468243`*^9, 3.483396122781253*^9}, 3.490048900827781*^9, 
   3.4900489594451337`*^9, {3.4902128221680546`*^9, 3.4902128464728975`*^9}, {
   3.4902329319281735`*^9, 3.490232932520975*^9}, {3.4903264807789726`*^9, 
   3.490326481278973*^9}}],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Hyperbolic Function Integration Problem 2", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, {3.4821973084456434`*^9, 3.482197309066536*^9}, {
   3.4821982364300194`*^9, 3.482198240976557*^9}, 3.482198357524144*^9, {
   3.483497689619979*^9, 3.4834977132940207`*^9}, 3.4835020852505856`*^9, 
   3.4903282631514673`*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "m"], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sinh", "[", "x", "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
   3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, 
   3.4834977393514895`*^9, {3.483498346584648*^9, 3.4834983502799616`*^9}, 
   3.490383159283381*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " returns 2m+2 term sums for positive integer m:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.423010751609375*^9}, 3.423171727*^9, {
   3.455396142709509*^9, 3.4553962116786814`*^9}, {3.4553963684841566`*^9, 
   3.4553963723697443`*^9}, 3.482198418131293*^9, {3.483498372271584*^9, 
   3.4834984077125454`*^9}, 3.483498459897584*^9, {3.4835843773216543`*^9, 
   3.483584377511928*^9}, {3.490327838380873*^9, 3.4903278596709027`*^9}, {
   3.490327908600971*^9, 3.4903279099409733`*^9}, 3.490330055723977*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox["x", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sinh", "[", "x", "]"}]}]}]], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.455158443195755*^9, 3.4551584443073535`*^9}, {3.4553960913656797`*^9, 
   3.4553961181141424`*^9}, {3.455396270923872*^9, 3.4553962975020895`*^9}, {
   3.483497757207165*^9, 3.483497767151464*^9}, 3.490324895556753*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"x", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"b", " ", 
        SuperscriptBox["\[ExponentialE]", "x"]}], 
       RowBox[{"a", "-", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["b", "2"]}]]}]]}], "]"}]}], 
   SqrtBox[
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]]], "-", 
  FractionBox[
   RowBox[{"x", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"b", " ", 
        SuperscriptBox["\[ExponentialE]", "x"]}], 
       RowBox[{"a", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["b", "2"]}]]}]]}], "]"}]}], 
   SqrtBox[
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]]], "+", 
  FractionBox[
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"b", " ", 
        SuperscriptBox["\[ExponentialE]", "x"]}], 
       RowBox[{"a", "-", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["b", "2"]}]]}]]}]}], "]"}], 
   SqrtBox[
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]]], "-", 
  FractionBox[
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"b", " ", 
        SuperscriptBox["\[ExponentialE]", "x"]}], 
       RowBox[{"a", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["b", "2"]}]]}]]}]}], "]"}], 
   SqrtBox[
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]]]}]], "Output",
 CellChangeTimes->{
  3.4551585987794733`*^9, 3.4553961321443167`*^9, {3.4553962727364783`*^9, 
   3.4553962797966304`*^9}, {3.483497760211485*^9, 3.483497764267317*^9}}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "2"], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sinh", "[", "x", "]"}]}]}]], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.455158443195755*^9, 3.4551584443073535`*^9}, {3.4553960913656797`*^9, 
   3.4553961181141424`*^9}, {3.455396270923872*^9, 3.4553962975020895`*^9}, {
   3.483497757207165*^9, 3.4834977924778814`*^9}, 3.4834978889866543`*^9, {
   3.4834980092896414`*^9, 3.483498010100808*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"b", " ", 
        SuperscriptBox["\[ExponentialE]", "x"]}], 
       RowBox[{"a", "-", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["b", "2"]}]]}]]}], "]"}]}], 
   SqrtBox[
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]]], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"b", " ", 
        SuperscriptBox["\[ExponentialE]", "x"]}], 
       RowBox[{"a", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["b", "2"]}]]}]]}], "]"}]}], 
   SqrtBox[
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]]], "+", 
  FractionBox[
   RowBox[{"2", " ", "x", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", 
         SuperscriptBox["\[ExponentialE]", "x"]}], 
        RowBox[{"a", "-", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["a", "2"], "+", 
           SuperscriptBox["b", "2"]}]]}]]}]}], "]"}]}], 
   SqrtBox[
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]]], "-", 
  FractionBox[
   RowBox[{"2", " ", "x", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", 
         SuperscriptBox["\[ExponentialE]", "x"]}], 
        RowBox[{"a", "+", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["a", "2"], "+", 
           SuperscriptBox["b", "2"]}]]}]]}]}], "]"}]}], 
   SqrtBox[
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"3", ",", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", 
         SuperscriptBox["\[ExponentialE]", "x"]}], 
        RowBox[{"a", "-", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["a", "2"], "+", 
           SuperscriptBox["b", "2"]}]]}]]}]}], "]"}]}], 
   SqrtBox[
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"3", ",", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", 
         SuperscriptBox["\[ExponentialE]", "x"]}], 
        RowBox[{"a", "+", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["a", "2"], "+", 
           SuperscriptBox["b", "2"]}]]}]]}]}], "]"}]}], 
   SqrtBox[
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]]]}]], "Output",
 CellChangeTimes->{{3.4834977868497887`*^9, 3.483497793399206*^9}}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "3"], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sinh", "[", "x", "]"}]}]}]], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.455158443195755*^9, 3.4551584443073535`*^9}, {3.4553960913656797`*^9, 
   3.4553961181141424`*^9}, {3.455396270923872*^9, 3.4553962975020895`*^9}, {
   3.483497757207165*^9, 3.4834977924778814`*^9}, 3.4834978889866543`*^9, {
   3.4834980092896414`*^9, 3.483498010100808*^9}, {3.483498752007618*^9, 
   3.483498761811715*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    SuperscriptBox["x", "3"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"b", " ", 
        SuperscriptBox["\[ExponentialE]", "x"]}], 
       RowBox[{"a", "-", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["b", "2"]}]]}]]}], "]"}]}], 
   SqrtBox[
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]]], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["x", "3"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"b", " ", 
        SuperscriptBox["\[ExponentialE]", "x"]}], 
       RowBox[{"a", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["b", "2"]}]]}]]}], "]"}]}], 
   SqrtBox[
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]]], "+", 
  FractionBox[
   RowBox[{"3", " ", 
    SuperscriptBox["x", "2"], " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", 
         SuperscriptBox["\[ExponentialE]", "x"]}], 
        RowBox[{"a", "-", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["a", "2"], "+", 
           SuperscriptBox["b", "2"]}]]}]]}]}], "]"}]}], 
   SqrtBox[
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]]], "-", 
  FractionBox[
   RowBox[{"3", " ", 
    SuperscriptBox["x", "2"], " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", 
         SuperscriptBox["\[ExponentialE]", "x"]}], 
        RowBox[{"a", "+", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["a", "2"], "+", 
           SuperscriptBox["b", "2"]}]]}]]}]}], "]"}]}], 
   SqrtBox[
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]]], "-", 
  FractionBox[
   RowBox[{"6", " ", "x", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"3", ",", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", 
         SuperscriptBox["\[ExponentialE]", "x"]}], 
        RowBox[{"a", "-", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["a", "2"], "+", 
           SuperscriptBox["b", "2"]}]]}]]}]}], "]"}]}], 
   SqrtBox[
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]]], "+", 
  FractionBox[
   RowBox[{"6", " ", "x", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"3", ",", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", 
         SuperscriptBox["\[ExponentialE]", "x"]}], 
        RowBox[{"a", "+", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["a", "2"], "+", 
           SuperscriptBox["b", "2"]}]]}]]}]}], "]"}]}], 
   SqrtBox[
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]]], "+", 
  FractionBox[
   RowBox[{"6", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"4", ",", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", 
         SuperscriptBox["\[ExponentialE]", "x"]}], 
        RowBox[{"a", "-", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["a", "2"], "+", 
           SuperscriptBox["b", "2"]}]]}]]}]}], "]"}]}], 
   SqrtBox[
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]]], "-", 
  FractionBox[
   RowBox[{"6", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"4", ",", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", 
         SuperscriptBox["\[ExponentialE]", "x"]}], 
        RowBox[{"a", "+", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["a", "2"], "+", 
           SuperscriptBox["b", "2"]}]]}]]}]}], "]"}]}], 
   SqrtBox[
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]]]}]], "Output",
 CellChangeTimes->{3.4834987584468765`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " returns a huge result involving the imaginary unit when m is 1:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500256179667`*^9}, {3.4466836176090527`*^9, 3.446683618790752*^9}, {
   3.4466950388319645`*^9, 3.423171727*^9}, {3.423617028171875*^9, 
   3.4236170379375*^9}, {3.4551611997394705`*^9, 3.455161216653792*^9}, {
   3.4551617691582546`*^9, 3.4551617721625743`*^9}, {3.4553013112408657`*^9, 
   3.4553013170191746`*^9}, 3.482197631430072*^9, {3.482646064727408*^9, 
   3.4826460783369775`*^9}, {3.483501487350848*^9, 3.4835015151508226`*^9}, {
   3.490325053236974*^9, 3.4903250694869967`*^9}, {3.4903255523976727`*^9, 
   3.4903255581676807`*^9}, {3.4903263122587366`*^9, 
   3.4903263171887436`*^9}, {3.4903280027911034`*^9, 3.490328044801162*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["x", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sinh", "[", "x", "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
   3.4443498869285407`*^9}, {3.444349974083864*^9, 3.423171727*^9}, {
   3.4551584047504735`*^9, 3.455158406513008*^9}, {3.455396100008107*^9, 
   3.455396122550522*^9}, {3.455396240430024*^9, 3.4553962505545826`*^9}, {
   3.4553963043719683`*^9, 3.4553963128241215`*^9}, 3.483498073562061*^9, {
   3.4834981255768547`*^9, 3.483498157713064*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", "\[Pi]", " ", 
     RowBox[{"ArcTanh", "[", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "b"}], "+", 
        RowBox[{"a", " ", 
         RowBox[{"Tanh", "[", 
          FractionBox["x", "2"], "]"}]}]}], 
       SqrtBox[
        RowBox[{
         SuperscriptBox["a", "2"], "+", 
         SuperscriptBox["b", "2"]}]]], "]"}]}], 
    SqrtBox[
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"]}]]]}], "-", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], "-", 
      SuperscriptBox["b", "2"]}]]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"ArcCos", "[", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", "a"}], "b"]}], "]"}], " ", 
      RowBox[{"ArcTanh", "[", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"\[ImaginaryI]", " ", "b"}]}], ")"}], " ", 
         RowBox[{"Cot", "[", 
          RowBox[{
           FractionBox["1", "4"], " ", 
           RowBox[{"(", 
            RowBox[{"\[Pi]", "+", 
             RowBox[{"2", " ", "\[ImaginaryI]", " ", "x"}]}], ")"}]}], 
          "]"}]}], 
        SqrtBox[
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "2"]}], "-", 
          SuperscriptBox["b", "2"]}]]], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"\[Pi]", "-", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "x"}]}], ")"}], " ", 
      RowBox[{"ArcTanh", "[", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "-", 
           RowBox[{"\[ImaginaryI]", " ", "b"}]}], ")"}], " ", 
         RowBox[{"Tan", "[", 
          RowBox[{
           FractionBox["1", "4"], " ", 
           RowBox[{"(", 
            RowBox[{"\[Pi]", "+", 
             RowBox[{"2", " ", "\[ImaginaryI]", " ", "x"}]}], ")"}]}], 
          "]"}]}], 
        SqrtBox[
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "2"]}], "-", 
          SuperscriptBox["b", "2"]}]]], "]"}]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"ArcCos", "[", 
         RowBox[{"-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", "a"}], "b"]}], "]"}], "+", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", 
         RowBox[{"ArcTanh", "[", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"\[ImaginaryI]", " ", "b"}]}], ")"}], " ", 
            RowBox[{"Cot", "[", 
             RowBox[{
              FractionBox["1", "4"], " ", 
              RowBox[{"(", 
               RowBox[{"\[Pi]", "+", 
                RowBox[{"2", " ", "\[ImaginaryI]", " ", "x"}]}], ")"}]}], 
             "]"}]}], 
           SqrtBox[
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], "-", 
             SuperscriptBox["b", "2"]}]]], "]"}]}]}], ")"}], " ", 
      RowBox[{"Log", "[", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[ImaginaryI]", " ", "a"}], "+", "b"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"\[ImaginaryI]", " ", 
            RowBox[{"(", 
             RowBox[{"b", "+", 
              SqrtBox[
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["a", "2"]}], "-", 
                SuperscriptBox["b", "2"]}]]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "\[ImaginaryI]"}], "+", 
           RowBox[{"Cot", "[", 
            RowBox[{
             FractionBox["1", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"\[Pi]", "+", 
               RowBox[{"2", " ", "\[ImaginaryI]", " ", "x"}]}], ")"}]}], 
            "]"}]}], ")"}]}], 
        RowBox[{"b", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[ImaginaryI]", " ", "a"}], "+", "b", "+", 
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox[
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["a", "2"]}], "-", 
              SuperscriptBox["b", "2"]}]], " ", 
            RowBox[{"Cot", "[", 
             RowBox[{
              FractionBox["1", "4"], " ", 
              RowBox[{"(", 
               RowBox[{"\[Pi]", "+", 
                RowBox[{"2", " ", "\[ImaginaryI]", " ", "x"}]}], ")"}]}], 
             "]"}]}]}], ")"}]}]], "]"}]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"ArcCos", "[", 
         RowBox[{"-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", "a"}], "b"]}], "]"}], "-", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", 
         RowBox[{"ArcTanh", "[", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"\[ImaginaryI]", " ", "b"}]}], ")"}], " ", 
            RowBox[{"Cot", "[", 
             RowBox[{
              FractionBox["1", "4"], " ", 
              RowBox[{"(", 
               RowBox[{"\[Pi]", "+", 
                RowBox[{"2", " ", "\[ImaginaryI]", " ", "x"}]}], ")"}]}], 
             "]"}]}], 
           SqrtBox[
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], "-", 
             SuperscriptBox["b", "2"]}]]], "]"}]}]}], ")"}], " ", 
      RowBox[{"Log", "[", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[ImaginaryI]", " ", "a"}], "+", "b"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[ImaginaryI]", " ", "a"}], "-", "b", "+", 
           SqrtBox[
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], "-", 
             SuperscriptBox["b", "2"]}]]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"\[ImaginaryI]", "+", 
           RowBox[{"Cot", "[", 
            RowBox[{
             FractionBox["1", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"\[Pi]", "+", 
               RowBox[{"2", " ", "\[ImaginaryI]", " ", "x"}]}], ")"}]}], 
            "]"}]}], ")"}]}], 
        RowBox[{"b", " ", 
         RowBox[{"(", 
          RowBox[{"a", "-", 
           RowBox[{"\[ImaginaryI]", " ", "b"}], "+", 
           RowBox[{
            SqrtBox[
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["a", "2"]}], "-", 
              SuperscriptBox["b", "2"]}]], " ", 
            RowBox[{"Cot", "[", 
             RowBox[{
              FractionBox["1", "4"], " ", 
              RowBox[{"(", 
               RowBox[{"\[Pi]", "+", 
                RowBox[{"2", " ", "\[ImaginaryI]", " ", "x"}]}], ")"}]}], 
             "]"}]}]}], ")"}]}]], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"ArcCos", "[", 
         RowBox[{"-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", "a"}], "b"]}], "]"}], "-", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", 
         RowBox[{"ArcTanh", "[", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"\[ImaginaryI]", " ", "b"}]}], ")"}], " ", 
            RowBox[{"Cot", "[", 
             RowBox[{
              FractionBox["1", "4"], " ", 
              RowBox[{"(", 
               RowBox[{"\[Pi]", "+", 
                RowBox[{"2", " ", "\[ImaginaryI]", " ", "x"}]}], ")"}]}], 
             "]"}]}], 
           SqrtBox[
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], "-", 
             SuperscriptBox["b", "2"]}]]], "]"}]}], "-", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", 
         RowBox[{"ArcTanh", "[", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "-", 
              RowBox[{"\[ImaginaryI]", " ", "b"}]}], ")"}], " ", 
            RowBox[{"Tan", "[", 
             RowBox[{
              FractionBox["1", "4"], " ", 
              RowBox[{"(", 
               RowBox[{"\[Pi]", "+", 
                RowBox[{"2", " ", "\[ImaginaryI]", " ", "x"}]}], ")"}]}], 
             "]"}]}], 
           SqrtBox[
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], "-", 
             SuperscriptBox["b", "2"]}]]], "]"}]}]}], ")"}], " ", 
      RowBox[{"Log", "[", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           FractionBox["1", "2"], "-", 
           FractionBox["\[ImaginaryI]", "2"]}], ")"}], " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["a", "2"]}], "-", 
           SuperscriptBox["b", "2"]}]], " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", "x"}], "/", "2"}]]}], 
        RowBox[{
         SqrtBox[
          RowBox[{
           RowBox[{"-", "\[ImaginaryI]"}], " ", "b"}]], " ", 
         SqrtBox[
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Sinh", "[", "x", "]"}]}]}]]}]], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"ArcCos", "[", 
         RowBox[{"-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", "a"}], "b"]}], "]"}], "+", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"ArcTanh", "[", 
            FractionBox[
             RowBox[{
              RowBox[{"(", 
               RowBox[{"a", "+", 
                RowBox[{"\[ImaginaryI]", " ", "b"}]}], ")"}], " ", 
              RowBox[{"Cot", "[", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{"\[Pi]", "+", 
                  RowBox[{"2", " ", "\[ImaginaryI]", " ", "x"}]}], ")"}]}], 
               "]"}]}], 
             SqrtBox[
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["a", "2"]}], "-", 
               SuperscriptBox["b", "2"]}]]], "]"}], "+", 
           RowBox[{"ArcTanh", "[", 
            FractionBox[
             RowBox[{
              RowBox[{"(", 
               RowBox[{"a", "-", 
                RowBox[{"\[ImaginaryI]", " ", "b"}]}], ")"}], " ", 
              RowBox[{"Tan", "[", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{"\[Pi]", "+", 
                  RowBox[{"2", " ", "\[ImaginaryI]", " ", "x"}]}], ")"}]}], 
               "]"}]}], 
             SqrtBox[
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["a", "2"]}], "-", 
               SuperscriptBox["b", "2"]}]]], "]"}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"Log", "[", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           FractionBox["1", "2"], "+", 
           FractionBox["\[ImaginaryI]", "2"]}], ")"}], " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["a", "2"]}], "-", 
           SuperscriptBox["b", "2"]}]], " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"x", "/", "2"}]]}], 
        RowBox[{
         SqrtBox[
          RowBox[{
           RowBox[{"-", "\[ImaginaryI]"}], " ", "b"}]], " ", 
         SqrtBox[
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Sinh", "[", "x", "]"}]}]}]]}]], "]"}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"PolyLog", "[", 
         RowBox[{"2", ",", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"\[ImaginaryI]", " ", "a"}], "+", 
              SqrtBox[
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["a", "2"]}], "-", 
                SuperscriptBox["b", "2"]}]]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"\[ImaginaryI]", " ", "a"}], "+", "b", "-", 
              RowBox[{"\[ImaginaryI]", " ", 
               SqrtBox[
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["a", "2"]}], "-", 
                 SuperscriptBox["b", "2"]}]], " ", 
               RowBox[{"Cot", "[", 
                RowBox[{
                 FractionBox["1", "4"], " ", 
                 RowBox[{"(", 
                  RowBox[{"\[Pi]", "+", 
                   RowBox[{"2", " ", "\[ImaginaryI]", " ", "x"}]}], ")"}]}], 
                "]"}]}]}], ")"}]}], 
           RowBox[{"b", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"\[ImaginaryI]", " ", "a"}], "+", "b", "+", 
              RowBox[{"\[ImaginaryI]", " ", 
               SqrtBox[
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["a", "2"]}], "-", 
                 SuperscriptBox["b", "2"]}]], " ", 
               RowBox[{"Cot", "[", 
                RowBox[{
                 FractionBox["1", "4"], " ", 
                 RowBox[{"(", 
                  RowBox[{"\[Pi]", "+", 
                   RowBox[{"2", " ", "\[ImaginaryI]", " ", "x"}]}], ")"}]}], 
                "]"}]}]}], ")"}]}]]}], "]"}], "-", 
        RowBox[{"PolyLog", "[", 
         RowBox[{"2", ",", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"\[ImaginaryI]", " ", 
               SqrtBox[
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["a", "2"]}], "-", 
                 SuperscriptBox["b", "2"]}]]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "a"}], "+", 
              RowBox[{"\[ImaginaryI]", " ", "b"}], "+", 
              RowBox[{
               SqrtBox[
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["a", "2"]}], "-", 
                 SuperscriptBox["b", "2"]}]], " ", 
               RowBox[{"Cot", "[", 
                RowBox[{
                 FractionBox["1", "4"], " ", 
                 RowBox[{"(", 
                  RowBox[{"\[Pi]", "+", 
                   RowBox[{"2", " ", "\[ImaginaryI]", " ", "x"}]}], ")"}]}], 
                "]"}]}]}], ")"}]}], 
           RowBox[{"b", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"\[ImaginaryI]", " ", "a"}], "+", "b", "+", 
              RowBox[{"\[ImaginaryI]", " ", 
               SqrtBox[
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["a", "2"]}], "-", 
                 SuperscriptBox["b", "2"]}]], " ", 
               RowBox[{"Cot", "[", 
                RowBox[{
                 FractionBox["1", "4"], " ", 
                 RowBox[{"(", 
                  RowBox[{"\[Pi]", "+", 
                   RowBox[{"2", " ", "\[ImaginaryI]", " ", "x"}]}], ")"}]}], 
                "]"}]}]}], ")"}]}]]}], "]"}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{
  3.4551584071639442`*^9, 3.4551586167753506`*^9, {3.4553962369349985`*^9, 
   3.4553962511854897`*^9}, {3.4553963061945887`*^9, 3.455396313404957*^9}, 
   3.483498084447714*^9, {3.4834981306641693`*^9, 3.483498158894763*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "2"], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sinh", "[", "x", "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
   3.4443498869285407`*^9}, {3.4443499715902786`*^9, 3.423171727*^9}, 
   3.4551584172684736`*^9, {3.4551586243662653`*^9, 3.455158626399189*^9}, {
   3.4551589981737747`*^9, 3.4551590479854*^9}, 3.455396103022442*^9, {
   3.483498096695325*^9, 3.4834981165839233`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"b", " ", 
        SuperscriptBox["\[ExponentialE]", "x"]}], 
       RowBox[{"a", "-", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["b", "2"]}]]}]]}], "]"}]}], 
   SqrtBox[
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]]], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"b", " ", 
        SuperscriptBox["\[ExponentialE]", "x"]}], 
       RowBox[{"a", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["b", "2"]}]]}]]}], "]"}]}], 
   SqrtBox[
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]]], "+", 
  FractionBox[
   RowBox[{"2", " ", "x", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      FractionBox[
       RowBox[{"b", " ", 
        SuperscriptBox["\[ExponentialE]", "x"]}], 
       RowBox[{
        RowBox[{"-", "a"}], "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["b", "2"]}]]}]]}], "]"}]}], 
   SqrtBox[
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]]], "-", 
  FractionBox[
   RowBox[{"2", " ", "x", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", 
         SuperscriptBox["\[ExponentialE]", "x"]}], 
        RowBox[{"a", "+", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["a", "2"], "+", 
           SuperscriptBox["b", "2"]}]]}]]}]}], "]"}]}], 
   SqrtBox[
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"3", ",", 
      FractionBox[
       RowBox[{"b", " ", 
        SuperscriptBox["\[ExponentialE]", "x"]}], 
       RowBox[{
        RowBox[{"-", "a"}], "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["b", "2"]}]]}]]}], "]"}]}], 
   SqrtBox[
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"3", ",", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", 
         SuperscriptBox["\[ExponentialE]", "x"]}], 
        RowBox[{"a", "+", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["a", "2"], "+", 
           SuperscriptBox["b", "2"]}]]}]]}]}], "]"}]}], 
   SqrtBox[
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.44434988769965*^9, {3.4466836278337555`*^9, 3.423171727*^9}, 
   3.4551583932939997`*^9, 3.4551586271102114`*^9, 3.4551589995357327`*^9, {
   3.4551590348565216`*^9, 3.455159049317315*^9}, 3.4553963175809617`*^9, {
   3.4834980995294*^9, 3.4834981103249235`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "3"], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sinh", "[", "x", "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
   3.4443498869285407`*^9}, {3.4443499715902786`*^9, 3.423171727*^9}, 
   3.4551584172684736`*^9, {3.4551586243662653`*^9, 3.455158626399189*^9}, {
   3.4551589981737747`*^9, 3.4551590479854*^9}, 3.455396103022442*^9, {
   3.483498096695325*^9, 3.4834981165839233`*^9}, {3.4834986897480927`*^9, 
   3.4834987231661453`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    SuperscriptBox["x", "3"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"b", " ", 
        SuperscriptBox["\[ExponentialE]", "x"]}], 
       RowBox[{"a", "-", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["b", "2"]}]]}]]}], "]"}]}], 
   SqrtBox[
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]]], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["x", "3"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"b", " ", 
        SuperscriptBox["\[ExponentialE]", "x"]}], 
       RowBox[{"a", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["b", "2"]}]]}]]}], "]"}]}], 
   SqrtBox[
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]]], "+", 
  FractionBox[
   RowBox[{"3", " ", 
    SuperscriptBox["x", "2"], " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      FractionBox[
       RowBox[{"b", " ", 
        SuperscriptBox["\[ExponentialE]", "x"]}], 
       RowBox[{
        RowBox[{"-", "a"}], "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["b", "2"]}]]}]]}], "]"}]}], 
   SqrtBox[
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]]], "-", 
  FractionBox[
   RowBox[{"3", " ", 
    SuperscriptBox["x", "2"], " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", 
         SuperscriptBox["\[ExponentialE]", "x"]}], 
        RowBox[{"a", "+", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["a", "2"], "+", 
           SuperscriptBox["b", "2"]}]]}]]}]}], "]"}]}], 
   SqrtBox[
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]]], "-", 
  FractionBox[
   RowBox[{"6", " ", "x", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"3", ",", 
      FractionBox[
       RowBox[{"b", " ", 
        SuperscriptBox["\[ExponentialE]", "x"]}], 
       RowBox[{
        RowBox[{"-", "a"}], "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["b", "2"]}]]}]]}], "]"}]}], 
   SqrtBox[
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]]], "+", 
  FractionBox[
   RowBox[{"6", " ", "x", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"3", ",", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", 
         SuperscriptBox["\[ExponentialE]", "x"]}], 
        RowBox[{"a", "+", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["a", "2"], "+", 
           SuperscriptBox["b", "2"]}]]}]]}]}], "]"}]}], 
   SqrtBox[
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]]], "+", 
  FractionBox[
   RowBox[{"6", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"4", ",", 
      FractionBox[
       RowBox[{"b", " ", 
        SuperscriptBox["\[ExponentialE]", "x"]}], 
       RowBox[{
        RowBox[{"-", "a"}], "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["b", "2"]}]]}]]}], "]"}]}], 
   SqrtBox[
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]]], "-", 
  FractionBox[
   RowBox[{"6", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"4", ",", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", 
         SuperscriptBox["\[ExponentialE]", "x"]}], 
        RowBox[{"a", "+", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["a", "2"], "+", 
           SuperscriptBox["b", "2"]}]]}]]}]}], "]"}]}], 
   SqrtBox[
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]]]}]], "Output",
 CellChangeTimes->{{3.4834986959570208`*^9, 3.483498718299147*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " is only able to integrate ",
 Cell[BoxData[
  StyleBox[
   FractionBox[
    SuperscriptBox["x", "m"], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sinh", "[", "x", "]"}]}]}]],
   FontSize->18,
   FontWeight->"Bold",
   Background->None]],
  CellGroupingRules->{GroupTogetherGrouping, 10000.},
  CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.455158443195755*^9, 3.4551584443073535`*^9}, {3.4553960913656797`*^9, 
   3.4553961181141424`*^9}, {3.455396270923872*^9, 3.4553962975020895`*^9}, {
   3.483497757207165*^9, 3.483497767151464*^9}}],
 " when m is 1:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500407697535`*^9}, {3.444350203233365*^9, 3.4443502040245028`*^9}, {
   3.444350234528365*^9, 3.4443502387243986`*^9}, {3.4466836227764835`*^9, 
   3.4466836230168285`*^9}, {3.4466839811618156`*^9, 
   3.4466839896239843`*^9}, {3.4466950433384447`*^9, 3.42301083234375*^9}, 
   3.423171727*^9, {3.4553964255061502`*^9, 3.455396438885389*^9}, {
   3.4553965290250034`*^9, 3.4553965545917664`*^9}, {3.455417738392576*^9, 
   3.4554177933315744`*^9}, {3.4554178455366416`*^9, 
   3.4554178850634785`*^9}, {3.45541794028288*^9, 3.455417941684896*^9}, 
   3.4821983700822015`*^9, {3.4834986041450014`*^9, 3.4834986296216354`*^9}, {
   3.4903277147507*^9, 3.4903277157807016`*^9}, {3.490327752350753*^9, 
   3.490327765260771*^9}, {3.490328158901322*^9, 3.4903281614913254`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"x", "/", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "sinh", 
         RowBox[{"(", "x", ")"}]}]}], ")"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444350078924618*^9, 3.423171727*^9}, 
   3.423616943953125*^9, {3.455158633699686*^9, 3.455158635011573*^9}, {
   3.455396398327069*^9, 3.455396405327134*^9}, {3.483498186955112*^9, 
   3.4834981984316144`*^9}, 3.4903248963867545`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"x", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"b", " ", 
        SuperscriptBox["\[ExponentialE]", "x"]}], 
       RowBox[{"a", "-", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["b", "2"]}]]}]]}], "]"}]}], 
   SqrtBox[
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]]], "-", 
  FractionBox[
   RowBox[{"x", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"b", " ", 
        SuperscriptBox["\[ExponentialE]", "x"]}], 
       RowBox[{"a", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["b", "2"]}]]}]]}], "]"}]}], 
   SqrtBox[
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]]], "+", 
  FractionBox[
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"b", " ", 
        SuperscriptBox["\[ExponentialE]", "x"]}], 
       RowBox[{"a", "-", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["b", "2"]}]]}]]}]}], "]"}], 
   SqrtBox[
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]]], "-", 
  FractionBox[
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"b", " ", 
        SuperscriptBox["\[ExponentialE]", "x"]}], 
       RowBox[{"a", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["b", "2"]}]]}]]}]}], "]"}], 
   SqrtBox[
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]]]}]], "Output",
 CellChangeTimes->{
  3.4551585987794733`*^9, 3.4553961321443167`*^9, {3.4553962727364783`*^9, 
   3.4553962797966304`*^9}, {3.483497760211485*^9, 3.483497764267317*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "sinh", 
         RowBox[{"(", "x", ")"}]}]}], ")"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444350133342867*^9, 3.423171727*^9}, 
   3.42361694584375*^9, {3.4551587072254114`*^9, 3.4551587085573263`*^9}, {
   3.455396516647205*^9, 3.455396521363987*^9}, {3.4561665796717215`*^9, 
   3.4561665834371357`*^9}, {3.4834982066934943`*^9, 3.483498209387368*^9}, 
   3.490324896906755*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "2"], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "sinh", 
      RowBox[{"(", "x", ")"}]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellChangeTimes->{{3.4553964496708975`*^9, 3.455396449710955*^9}, {
  3.455396572427413*^9, 3.455396574129861*^9}, {3.4834982754723935`*^9, 
  3.4834982859674845`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "3"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "sinh", 
         RowBox[{"(", "x", ")"}]}]}], ")"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444350133342867*^9, 3.423171727*^9}, 
   3.42361694584375*^9, {3.4551587072254114`*^9, 3.4551587085573263`*^9}, {
   3.455396516647205*^9, 3.455396521363987*^9}, {3.4561665796717215`*^9, 
   3.4561665834371357`*^9}, {3.4834982066934943`*^9, 3.483498209387368*^9}, 
   3.483498735624059*^9, 3.490324897386756*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "3"], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "sinh", 
      RowBox[{"(", "x", ")"}]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellChangeTimes->{{3.4553964496708975`*^9, 3.455396449710955*^9}, {
  3.455396572427413*^9, 3.455396574129861*^9}, {3.4834982754723935`*^9, 
  3.4834982859674845`*^9}, {3.483498727512395*^9, 3.4834987373966084`*^9}}]
}, Closed]],

Cell["", "Text"],

Cell["\<\
Note that these systems give similar results to the above for the hyperbolic \
cosine function.\
\>", "Subsubtitle",
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832040958843503`*^9, 3.4832041044566765`*^9}, 3.483204218670909*^9, 
   3.4833920379275217`*^9, {3.483392125182989*^9, 3.4833921454921923`*^9}, {
   3.48339221312945*^9, 3.483392219528651*^9}, {3.483392987983635*^9, 
   3.4833931408334227`*^9}, {3.4833932165322723`*^9, 3.483393223472251*^9}, {
   3.483395056508027*^9, 3.4833950705081587`*^9}, {3.4833959109166064`*^9, 
   3.483395925577688*^9}, {3.483395964633848*^9, 3.4833959819287167`*^9}, {
   3.4833961127468243`*^9, 3.483396122781253*^9}, 3.490048900827781*^9, 
   3.4900489594451337`*^9, {3.4902128221680546`*^9, 3.4902128464728975`*^9}, {
   3.4902329319281735`*^9, 3.490232932520975*^9}, {3.4903264807789726`*^9, 
   3.490326481278973*^9}, {3.4903284635517483`*^9, 3.49032847905177*^9}}],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Hyperbolic Function Integration Problem 3", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, {3.4821973084456434`*^9, 3.482197309066536*^9}, {
   3.4821982364300194`*^9, 3.482198240976557*^9}, 3.482198357524144*^9, 
   3.4834989560009456`*^9, 3.4835020986798964`*^9, 3.490329999853899*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sech", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "4"], " ", 
   SuperscriptBox[
    RowBox[{"Tanh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
   3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, 
   3.490383156383377*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " maintains the symmetry between the trig and hyperbolic functions:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.423010751609375*^9}, 3.423171727*^9, {
   3.455396142709509*^9, 3.4553962116786814`*^9}, {3.4553963684841566`*^9, 
   3.4553963723697443`*^9}, 3.482198418131293*^9, {3.49032891507238*^9, 
   3.4903289221923904`*^9}}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sec", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "4"], " ", 
    SuperscriptBox[
     RowBox[{"Tan", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "n"]}], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.455158443195755*^9, 3.4551584443073535`*^9}, {3.4553960913656797`*^9, 
   3.4553961181141424`*^9}, {3.455396270923872*^9, 3.4553962975020895`*^9}, 
   3.490324901486761*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SuperscriptBox[
    RowBox[{"Tan", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], 
    RowBox[{"1", "+", "n"}]], 
   RowBox[{"b", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "n"}], ")"}]}]], "+", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"Tan", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], 
    RowBox[{"3", "+", "n"}]], 
   RowBox[{"b", " ", 
    RowBox[{"(", 
     RowBox[{"3", "+", "n"}], ")"}]}]]}]], "Output",
 CellChangeTimes->{
  3.4551585987794733`*^9, 3.4553961321443167`*^9, {3.4553962727364783`*^9, 
   3.4553962797966304`*^9}}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sech", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "4"], " ", 
    SuperscriptBox[
     RowBox[{"Tanh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "n"]}], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, {
   3.444349991088315*^9, 3.423171727*^9}, {3.455158603736602*^9, 
   3.4551586051185884`*^9}, 3.45539609712396*^9, {3.4553962846235714`*^9, 
   3.4553962934863153`*^9}, 3.490324901936762*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SuperscriptBox[
    RowBox[{"Tanh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], 
    RowBox[{"1", "+", "n"}]], 
   RowBox[{"b", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "n"}], ")"}]}]], "-", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"Tanh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], 
    RowBox[{"3", "+", "n"}]], 
   RowBox[{"b", " ", 
    RowBox[{"(", 
     RowBox[{"3", "+", "n"}], ")"}]}]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.4443496028500557`*^9, 3.444349862773808*^9, {3.446683636145707*^9, 
   3.423171727*^9}, 3.4551586062301874`*^9, 3.4553961338467646`*^9, 
   3.455396286726595*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is able to integrate the trig expression but not the corresponding \
hyperbolic one:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500256179667`*^9}, {3.4466836176090527`*^9, 3.446683618790752*^9}, {
   3.4466950388319645`*^9, 3.423171727*^9}, {3.455396328636859*^9, 
   3.4553963505483665`*^9}, {3.455417723651379*^9, 3.45541772897904*^9}, 
   3.455417782946642*^9, {3.4554178162144785`*^9, 3.4554178370945024`*^9}, 
   3.4554178880677986`*^9, 3.4821983999050846`*^9, {3.490329151042711*^9, 
   3.49032919335277*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sec", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "4"], " ", 
   SuperscriptBox[
    RowBox[{"Tan", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
  3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
  3.4443498869285407`*^9}, {3.444349974083864*^9, 3.423171727*^9}, {
  3.4551584047504735`*^9, 3.455158406513008*^9}, {3.455396100008107*^9, 
  3.455396122550522*^9}, {3.455396240430024*^9, 3.4553962505545826`*^9}, {
  3.4553963043719683`*^9, 3.4553963128241215`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"2", "+", "n", "+", 
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}]}], "]"}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"Sec", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "2"], " ", 
   SuperscriptBox[
    RowBox[{"Tan", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], 
    RowBox[{"1", "+", "n"}]]}], 
  RowBox[{"b", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "n"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"3", "+", "n"}], ")"}]}]]], "Output",
 CellChangeTimes->{
  3.4551584071639442`*^9, 3.4551586167753506`*^9, {3.4553962369349985`*^9, 
   3.4553962511854897`*^9}, {3.4553963061945887`*^9, 3.455396313404957*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sech", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "4"], " ", 
   SuperscriptBox[
    RowBox[{"Tanh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
   3.4443498869285407`*^9}, {3.4443499715902786`*^9, 3.423171727*^9}, 
   3.4551584172684736`*^9, {3.4551586243662653`*^9, 3.455158626399189*^9}, {
   3.4551589981737747`*^9, 3.4551590479854*^9}, 3.455396103022442*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sech", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "4"], " ", 
    SuperscriptBox[
     RowBox[{"Tanh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "n"]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.44434988769965*^9, {3.4466836278337555`*^9, 3.423171727*^9}, 
   3.4551583932939997`*^9, 3.4551586271102114`*^9, 3.4551589995357327`*^9, {
   3.4551590348565216`*^9, 3.455159049317315*^9}, 3.4553963175809617`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " is unable to integrate the trig expression and returns a huge result for \
the hyperbolic one:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500407697535`*^9}, {3.444350203233365*^9, 3.4443502040245028`*^9}, {
   3.444350234528365*^9, 3.4443502387243986`*^9}, {3.4466836227764835`*^9, 
   3.4466836230168285`*^9}, {3.4466839811618156`*^9, 
   3.4466839896239843`*^9}, {3.4466950433384447`*^9, 3.42301083234375*^9}, 
   3.423171727*^9, {3.4553964255061502`*^9, 3.455396438885389*^9}, {
   3.4553965290250034`*^9, 3.4553965545917664`*^9}, {3.455417738392576*^9, 
   3.4554177933315744`*^9}, {3.4554178455366416`*^9, 
   3.4554178850634785`*^9}, {3.45541794028288*^9, 3.455417941684896*^9}, 
   3.4821983700822015`*^9, {3.490329220732808*^9, 3.4903292635828686`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"sec", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}], "^", "4"}], "*", "tan", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444350078924618*^9, 3.423171727*^9}, 
   3.423616943953125*^9, {3.455158633699686*^9, 3.455158635011573*^9}, {
   3.455396398327069*^9, 3.455396405327134*^9}, 3.4903249024267626`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sec", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "4"], " ", 
   SuperscriptBox[
    RowBox[{"Tan", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output"],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"sech", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}], "^", "4"}], "*", "tanh", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444350133342867*^9, 3.423171727*^9}, 
   3.42361694584375*^9, {3.4551587072254114`*^9, 3.4551587085573263`*^9}, {
   3.455396516647205*^9, 3.455396521363987*^9}, {3.4561665796717215`*^9, 
   3.4561665834371357`*^9}, 3.4903249030067635`*^9, {3.490329477743168*^9, 
   3.4903294806931725`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"2", "*", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], "*", "exp", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", "a"}], "+", 
           RowBox[{"2", "*", "b", "*", "x"}]}], ")"}]}], "+", 
        RowBox[{"exp", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"6", "*", "a"}], "+", 
           RowBox[{"6", "*", "b", "*", "x"}]}], ")"}]}], "+", 
        RowBox[{"3", "*", "exp", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", "*", "a"}], "+", 
           RowBox[{"4", "*", "b", "*", "x"}]}], ")"}]}], "-", "1", "+", 
        RowBox[{"2", "*", "exp", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", "*", "a"}], "+", 
           RowBox[{"4", "*", "b", "*", "x"}]}], ")"}], "*", "n"}], "-", 
        RowBox[{"2", "*", "n", "*", "exp", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", "a"}], "+", 
           RowBox[{"2", "*", "b", "*", "x"}]}], ")"}]}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"1", "+", "n"}], ")"}]}], "/", "b"}], "/", 
    RowBox[{"(", 
     RowBox[{"3", "+", "n"}], ")"}]}], "/", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"exp", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "*", "a"}], "+", 
         RowBox[{"2", "*", "b", "*", "x"}]}], ")"}]}], "+", "1"}], ")"}], "^",
     "3"}]}], "*", "exp", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "/", "2"}], "*", "n", "*", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], "*", "ln", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"exp", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}]}], "-", "1"}], ")"}]}], "-", 
      RowBox[{"2", "*", "ln", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"exp", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"2", "*", "ln", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"exp", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", "*", "a"}], "+", 
            RowBox[{"2", "*", "b", "*", "x"}]}], ")"}]}], "+", "1"}], ")"}]}],
       "+", 
      RowBox[{"I", "*", "Pi", "*", "csgn", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"I", "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"exp", 
              RowBox[{"(", 
               RowBox[{"a", "+", 
                RowBox[{"b", "*", "x"}]}], ")"}]}]}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"exp", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", "*", "a"}], "+", 
                RowBox[{"2", "*", "b", "*", "x"}]}], ")"}]}], "+", "1"}], 
            ")"}]}]}], ")"}], "^", "3"}]}], "-", 
      RowBox[{"I", "*", "Pi", "*", "csgn", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"I", "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"exp", 
              RowBox[{"(", 
               RowBox[{"a", "+", 
                RowBox[{"b", "*", "x"}]}], ")"}]}]}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"exp", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", "*", "a"}], "+", 
                RowBox[{"2", "*", "b", "*", "x"}]}], ")"}]}], "+", "1"}], 
            ")"}]}]}], ")"}], "^", "2"}], "*", "csgn", 
       RowBox[{"(", 
        RowBox[{"I", "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"exp", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", "*", "a"}], "+", 
              RowBox[{"2", "*", "b", "*", "x"}]}], ")"}]}], "+", "1"}], 
          ")"}]}], ")"}]}], "-", 
      RowBox[{"I", "*", "Pi", "*", "csgn", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"I", "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"exp", 
              RowBox[{"(", 
               RowBox[{"a", "+", 
                RowBox[{"b", "*", "x"}]}], ")"}]}]}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"exp", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", "*", "a"}], "+", 
                RowBox[{"2", "*", "b", "*", "x"}]}], ")"}]}], "+", "1"}], 
            ")"}]}]}], ")"}], "^", "2"}], "*", "csgn", 
       RowBox[{"(", 
        RowBox[{"I", "*", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"exp", 
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", "x"}]}], ")"}]}]}], ")"}]}], ")"}]}], "+", 
      RowBox[{"I", "*", "Pi", "*", "csgn", 
       RowBox[{"(", 
        RowBox[{"I", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"exp", 
             RowBox[{"(", 
              RowBox[{"a", "+", 
               RowBox[{"b", "*", "x"}]}], ")"}]}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"exp", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", "*", "a"}], "+", 
               RowBox[{"2", "*", "b", "*", "x"}]}], ")"}]}], "+", "1"}], 
           ")"}]}]}], ")"}], "*", "csgn", 
       RowBox[{"(", 
        RowBox[{"I", "*", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"exp", 
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", "x"}]}], ")"}]}]}], ")"}]}], ")"}], "*", 
       "csgn", 
       RowBox[{"(", 
        RowBox[{"I", "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"exp", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", "*", "a"}], "+", 
              RowBox[{"2", "*", "b", "*", "x"}]}], ")"}]}], "+", "1"}], 
          ")"}]}], ")"}]}], "+", 
      RowBox[{"I", "*", "Pi", "*", "csgn", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"I", "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"exp", 
              RowBox[{"(", 
               RowBox[{"a", "+", 
                RowBox[{"b", "*", "x"}]}], ")"}]}], "-", "1"}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"exp", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", "*", "a"}], "+", 
                RowBox[{"2", "*", "b", "*", "x"}]}], ")"}]}], "+", "1"}], 
            ")"}]}], "*", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"exp", 
             RowBox[{"(", 
              RowBox[{"a", "+", 
               RowBox[{"b", "*", "x"}]}], ")"}]}]}], ")"}]}], ")"}], "^", 
        "3"}]}], "-", 
      RowBox[{"I", "*", "Pi", "*", "csgn", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"I", "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"exp", 
              RowBox[{"(", 
               RowBox[{"a", "+", 
                RowBox[{"b", "*", "x"}]}], ")"}]}], "-", "1"}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"exp", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", "*", "a"}], "+", 
                RowBox[{"2", "*", "b", "*", "x"}]}], ")"}]}], "+", "1"}], 
            ")"}]}], "*", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"exp", 
             RowBox[{"(", 
              RowBox[{"a", "+", 
               RowBox[{"b", "*", "x"}]}], ")"}]}]}], ")"}]}], ")"}], "^", 
        "2"}], "*", "csgn", 
       RowBox[{"(", 
        RowBox[{"I", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"exp", 
             RowBox[{"(", 
              RowBox[{"a", "+", 
               RowBox[{"b", "*", "x"}]}], ")"}]}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"exp", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", "*", "a"}], "+", 
               RowBox[{"2", "*", "b", "*", "x"}]}], ")"}]}], "+", "1"}], 
           ")"}]}]}], ")"}]}], "-", 
      RowBox[{"I", "*", "Pi", "*", "csgn", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"I", "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"exp", 
              RowBox[{"(", 
               RowBox[{"a", "+", 
                RowBox[{"b", "*", "x"}]}], ")"}]}], "-", "1"}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"exp", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", "*", "a"}], "+", 
                RowBox[{"2", "*", "b", "*", "x"}]}], ")"}]}], "+", "1"}], 
            ")"}]}], "*", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"exp", 
             RowBox[{"(", 
              RowBox[{"a", "+", 
               RowBox[{"b", "*", "x"}]}], ")"}]}]}], ")"}]}], ")"}], "^", 
        "2"}], "*", "csgn", 
       RowBox[{"(", 
        RowBox[{"I", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"exp", 
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", "x"}]}], ")"}]}], "-", "1"}], ")"}]}], 
        ")"}]}], "+", 
      RowBox[{"I", "*", "Pi", "*", "csgn", 
       RowBox[{"(", 
        RowBox[{"I", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"exp", 
             RowBox[{"(", 
              RowBox[{"a", "+", 
               RowBox[{"b", "*", "x"}]}], ")"}]}], "-", "1"}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"exp", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", "*", "a"}], "+", 
               RowBox[{"2", "*", "b", "*", "x"}]}], ")"}]}], "+", "1"}], 
           ")"}]}], "*", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"exp", 
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", "x"}]}], ")"}]}]}], ")"}]}], ")"}], "*", 
       "csgn", 
       RowBox[{"(", 
        RowBox[{"I", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"exp", 
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", "x"}]}], ")"}]}], "-", "1"}], ")"}]}], ")"}], 
       "*", "csgn", 
       RowBox[{"(", 
        RowBox[{"I", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"exp", 
             RowBox[{"(", 
              RowBox[{"a", "+", 
               RowBox[{"b", "*", "x"}]}], ")"}]}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"exp", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", "*", "a"}], "+", 
               RowBox[{"2", "*", "b", "*", "x"}]}], ")"}]}], "+", "1"}], 
           ")"}]}]}], ")"}]}]}], ")"}]}], ")"}]}]], "Output"]
}, Closed]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Hyperbolic Function Integration Problem 4", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, {3.4821973084456434`*^9, 3.482197309066536*^9}, 
   3.4835022553752127`*^9, 3.4835873269430017`*^9, 3.490337661068653*^9, 
   3.4903384735317926`*^9, 3.490338517511854*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Sinh", "[", "x", "]"}], " ", 
   RowBox[{"Sech", "[", 
    RowBox[{"n", " ", "x"}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subsection",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
   3.482197249951533*^9, {3.483502244139056*^9, 3.4835022461419363`*^9}, {
   3.4835873907848015`*^9, 3.4835873929879694`*^9}, {3.490337664058657*^9, 
   3.490337667538662*^9}, 3.490383152763372*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " results are simple, expressed in hyperbolic form and grow modestly with n:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.423010751609375*^9}, 3.423171727*^9, {
   3.423617016203125*^9, 3.423617021953125*^9}, 3.4821973777553053`*^9, 
   3.4826461568498735`*^9, {3.4835879793210754`*^9, 3.4835880026145697`*^9}, {
   3.490337812118864*^9, 3.4903378148488684`*^9}, {3.4903760130333767`*^9, 
   3.4903760288533983`*^9}, {3.490376118933524*^9, 3.490376147593565*^9}, {
   3.490376227323676*^9, 3.4903762290636787`*^9}}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sinh", "[", "x", "]"}], " ", 
    RowBox[{"Sech", "[", "x", "]"}]}], ",", " ", "x"}], "]"}]], "Code",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, 3.423617639828125*^9, 
   3.4236176860625*^9, {3.483587720388749*^9, 3.4835877242543073`*^9}, {
   3.483587764512195*^9, 3.4835877646924543`*^9}, 3.490337679648679*^9, 
   3.4903377124487247`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"Cosh", "[", "x", "]"}], "]"}]], "Output",
 CellChangeTimes->{3.4903377457787714`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sinh", "[", "x", "]"}], " ", 
    RowBox[{"Sech", "[", 
     RowBox[{"2", " ", "x"}], "]"}]}], ",", " ", "x"}], "]"}]], "Code",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, 3.423617639828125*^9, 
   3.4236176860625*^9, {3.483587720388749*^9, 3.4835877242543073`*^9}, 
   3.483587759575096*^9, 3.4903376820986824`*^9, 3.4903377151387286`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"ArcTanh", "[", 
    RowBox[{
     SqrtBox["2"], " ", 
     RowBox[{"Cosh", "[", "x", "]"}]}], "]"}], 
   SqrtBox["2"]]}]], "Output",
 CellChangeTimes->{3.483588346689325*^9, 3.4903377521087804`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sinh", "[", "x", "]"}], " ", 
    RowBox[{"Sech", "[", 
     RowBox[{"3", " ", "x"}], "]"}]}], ",", " ", "x"}], "]"}]], "Code",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, 3.423617639828125*^9, 
   3.4236176860625*^9, {3.483587720388749*^9, 3.4835877344189234`*^9}, {
   3.4835895997811823`*^9, 3.483589604257619*^9}, 3.4903376832786837`*^9, 
   3.4903377165787306`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "3"], " ", 
  RowBox[{"ArcTanh", "[", 
   RowBox[{"1", "-", 
    FractionBox[
     RowBox[{"8", " ", 
      SuperscriptBox[
       RowBox[{"Cosh", "[", "x", "]"}], "2"]}], "3"]}], "]"}]}]], "Output",
 CellChangeTimes->{3.483587735520507*^9, 3.4835896008627377`*^9, 
  3.4903377540487833`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sinh", "[", "x", "]"}], " ", 
    RowBox[{"Sech", "[", 
     RowBox[{"4", " ", "x"}], "]"}]}], ",", " ", "x"}], "]"}]], "Code",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, 3.423617639828125*^9, 
   3.4236176860625*^9, {3.483587720388749*^9, 3.4835877410885134`*^9}, {
   3.4835895903175745`*^9, 3.4835896071718097`*^9}, 3.4903376846086855`*^9, 
   3.490337718478733*^9, {3.4903385333818765`*^9, 3.490338541581888*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "4"], " ", 
   SqrtBox[
    RowBox[{"2", "+", 
     SqrtBox["2"]}]], " ", 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"Cosh", "[", "x", "]"}]}], 
     SqrtBox[
      RowBox[{"2", "-", 
       SqrtBox["2"]}]]], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   SqrtBox[
    RowBox[{"2", "-", 
     SqrtBox["2"]}]], " ", 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"Cosh", "[", "x", "]"}]}], 
     SqrtBox[
      RowBox[{"2", "+", 
       SqrtBox["2"]}]]], "]"}]}]}]], "Output",
 CellChangeTimes->{3.4835877420198526`*^9, 3.483589591459216*^9, 
  3.4903377564287863`*^9, 3.4903385347618785`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " results grow unpredictably and is not in closed-form when n is 4:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.423010751609375*^9}, 3.423171727*^9, {
   3.423617016203125*^9, 3.423617021953125*^9}, 3.4821973777553053`*^9, 
   3.4826461568498735`*^9, 3.483587815936139*^9, {3.4835878875290847`*^9, 
   3.4835879480060463`*^9}, {3.483589935073309*^9, 3.4835899352435536`*^9}, {
   3.490337847088913*^9, 3.4903378545889235`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Sinh", "[", "x", "]"}], " ", 
   RowBox[{"Sech", "[", "x", "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Code",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, 3.423617639828125*^9, 
   3.4236176860625*^9, {3.483587720388749*^9, 3.4835877242543073`*^9}, {
   3.483587764512195*^9, 3.4835877646924543`*^9}, {3.4835878183996816`*^9, 
   3.483587819210848*^9}, 3.4903376868586893`*^9, 3.490337720388736*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"Cosh", "[", "x", "]"}], "]"}]], "Output",
 CellChangeTimes->{3.4835877652232175`*^9, 3.4835878426645727`*^9, 
  3.4903377720188084`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Sinh", "[", "x", "]"}], " ", 
   RowBox[{"Sech", "[", 
    RowBox[{"2", " ", "x"}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Code",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, 3.423617639828125*^9, 
   3.4236176860625*^9, {3.483587720388749*^9, 3.4835877242543073`*^9}, 
   3.483587759575096*^9, {3.483587820833181*^9, 3.4835878215341887`*^9}, 
   3.49033768780869*^9, 3.4903377224687386`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{
       RowBox[{"Cosh", "[", 
        FractionBox["x", "2"], "]"}], "+", 
       RowBox[{"Sinh", "[", 
        FractionBox["x", "2"], "]"}]}], 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SqrtBox["2"]}], ")"}], " ", 
        RowBox[{"Cosh", "[", 
         FractionBox["x", "2"], "]"}]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SqrtBox["2"]}], ")"}], " ", 
        RowBox[{"Sinh", "[", 
         FractionBox["x", "2"], "]"}]}]}]], "]"}]}], "+", 
   RowBox[{"2", " ", "\[ImaginaryI]", " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{
       RowBox[{"Cosh", "[", 
        FractionBox["x", "2"], "]"}], "+", 
       RowBox[{"Sinh", "[", 
        FractionBox["x", "2"], "]"}]}], 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SqrtBox["2"]}], ")"}], " ", 
        RowBox[{"Cosh", "[", 
         FractionBox["x", "2"], "]"}]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SqrtBox["2"]}], ")"}], " ", 
        RowBox[{"Sinh", "[", 
         FractionBox["x", "2"], "]"}]}]}]], "]"}]}], "-", 
   RowBox[{"4", " ", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{
      SqrtBox["2"], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"Tanh", "[", 
        FractionBox["x", "2"], "]"}]}]}], "]"}]}], "-", 
   RowBox[{"Log", "[", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       SqrtBox["2"], "+", 
       RowBox[{"2", " ", 
        RowBox[{"Cosh", "[", "x", "]"}]}]}], ")"}]}], "]"}], "+", 
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SqrtBox["2"]}], "+", 
     RowBox[{"4", " ", 
      RowBox[{"Cosh", "[", "x", "]"}]}]}], "]"}]}], 
  RowBox[{"4", " ", 
   SqrtBox["2"]}]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443499554871235`*^9, 3.4443499625572896`*^9}, {
   3.446683635064152*^9, 3.423171727*^9}, {3.42361697475*^9, 
   3.42361697940625*^9}, 3.42361773425*^9, 3.4835877266177053`*^9, 
   3.483587847601672*^9, 3.490337776098814*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Sinh", "[", "x", "]"}], " ", 
   RowBox[{"Sech", "[", 
    RowBox[{"3", " ", "x"}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Code",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, 3.423617639828125*^9, 
   3.4236176860625*^9, {3.483587720388749*^9, 3.4835877344189234`*^9}, {
   3.4835878233868527`*^9, 3.4835878240778465`*^9}, 3.4903376900786934`*^9, 
   3.490337726678745*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "3"]}], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"Cosh", "[", "x", "]"}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"Cosh", "[", 
       RowBox[{"2", " ", "x"}], "]"}]}]}], "]"}]}]}]], "Output",
 CellChangeTimes->{3.483587735520507*^9, 3.4835878568549776`*^9, 
  3.490337783248824*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Sinh", "[", "x", "]"}], " ", 
   RowBox[{"Sech", "[", 
    RowBox[{"4", " ", "x"}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Code",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, 3.423617639828125*^9, 
   3.4236176860625*^9, {3.483587720388749*^9, 3.4835877410885134`*^9}, {
   3.4835878254598336`*^9, 3.4835878261107693`*^9}, {3.4835878637348704`*^9, 
   3.4835878654873905`*^9}, 3.4903376907986946`*^9, 3.4903377292987485`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "16"], " ", 
  RowBox[{"RootSum", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "+", 
      SuperscriptBox["#1", "8"]}], "&"}], ",", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"-", "x"}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"Log", "[", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"Cosh", "[", 
            FractionBox["x", "2"], "]"}]}], "-", 
          RowBox[{"Sinh", "[", 
           FractionBox["x", "2"], "]"}], "+", 
          RowBox[{
           RowBox[{"Cosh", "[", 
            FractionBox["x", "2"], "]"}], " ", "#1"}], "-", 
          RowBox[{
           RowBox[{"Sinh", "[", 
            FractionBox["x", "2"], "]"}], " ", "#1"}]}], "]"}]}], "+", 
       RowBox[{"x", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"Log", "[", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"Cosh", "[", 
            FractionBox["x", "2"], "]"}]}], "-", 
          RowBox[{"Sinh", "[", 
           FractionBox["x", "2"], "]"}], "+", 
          RowBox[{
           RowBox[{"Cosh", "[", 
            FractionBox["x", "2"], "]"}], " ", "#1"}], "-", 
          RowBox[{
           RowBox[{"Sinh", "[", 
            FractionBox["x", "2"], "]"}], " ", "#1"}]}], "]"}], " ", 
        SuperscriptBox["#1", "2"]}]}], 
      SuperscriptBox["#1", "5"]], "&"}]}], "]"}]}]], "Output",
 CellChangeTimes->{3.4835877420198526`*^9, 3.4835878683715377`*^9, 
  3.4903377891688323`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Maple",
  FontSlant->"Italic"],
 " results are simple, but expressed in exponential form and not in \
closed-form when n is 4:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.423010751609375*^9}, 3.423171727*^9, {
   3.423617016203125*^9, 3.423617021953125*^9}, 3.4821973777553053`*^9, 
   3.4826461568498735`*^9, 3.483587815936139*^9, {3.4835878875290847`*^9, 
   3.4835879480060463`*^9}, 3.483588071994333*^9, 3.483589764728365*^9, {
   3.483589901615198*^9, 3.4835899253292975`*^9}, {3.4903383577416306`*^9, 
   3.4903383904216766`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"sinh", 
      RowBox[{"(", "x", ")"}], "*", "sech", 
      RowBox[{"(", "x", ")"}]}], ",", " ", "x"}], ")"}]}], ";"}]], "Code",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, 3.423617639828125*^9, 
   3.4236176860625*^9, {3.483587720388749*^9, 3.4835877242543073`*^9}, {
   3.483587764512195*^9, 3.4835877646924543`*^9}, {3.4835878183996816`*^9, 
   3.483587819210848*^9}, {3.4835880879873295`*^9, 3.483588108777224*^9}, {
   3.4903378751989527`*^9, 3.490337883978965*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"Cosh", "[", "x", "]"}], "]"}]], "Output",
 CellChangeTimes->{3.4835877652232175`*^9, 3.4835878426645727`*^9, 
  3.4903377720188084`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"sinh", 
      RowBox[{"(", "x", ")"}], "*", "sech", 
      RowBox[{"(", 
       RowBox[{"2", "*", "x"}], ")"}]}], ",", " ", "x"}], ")"}]}], 
  ";"}]], "Code",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, 3.423617639828125*^9, 
   3.4236176860625*^9, {3.483587720388749*^9, 3.4835877242543073`*^9}, {
   3.483587764512195*^9, 3.4835877646924543`*^9}, {3.4835878183996816`*^9, 
   3.483587819210848*^9}, {3.4835880879873295`*^9, 3.4835881272838354`*^9}, {
   3.490337876718955*^9, 3.4903378883889713`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", 
     RowBox[{
      SqrtBox["2"], " ", 
      SuperscriptBox["\[ExponentialE]", "x"]}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"2", " ", "x"}]]}], "]"}], 
   RowBox[{"2", " ", 
    SqrtBox["2"]}]], "-", 
  FractionBox[
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", 
     RowBox[{
      SqrtBox["2"], " ", 
      SuperscriptBox["\[ExponentialE]", "x"]}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"2", " ", "x"}]]}], "]"}], 
   RowBox[{"2", " ", 
    SqrtBox["2"]}]]}]], "Output",
 CellChangeTimes->{{3.4903380947212625`*^9, 3.490338105161277*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"sinh", 
      RowBox[{"(", "x", ")"}], "*", "sech", 
      RowBox[{"(", 
       RowBox[{"3", "*", "x"}], ")"}]}], ",", " ", "x"}], ")"}]}], 
  ";"}]], "Code",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, 3.423617639828125*^9, 
   3.4236176860625*^9, {3.483587720388749*^9, 3.4835877242543073`*^9}, {
   3.483587764512195*^9, 3.4835877646924543`*^9}, {3.4835878183996816`*^9, 
   3.483587819210848*^9}, {3.4835880879873295`*^9, 3.4835881317102003`*^9}, {
   3.490337878148957*^9, 3.490337890208974*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "3"]}], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"2", " ", "x"}]]}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"2", " ", "x"}]], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"4", " ", "x"}]]}], "]"}]}]}]], "Output",
 CellChangeTimes->{{3.4903381913713975`*^9, 3.4903381965214047`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"sinh", 
      RowBox[{"(", "x", ")"}], "*", "sech", 
      RowBox[{"(", 
       RowBox[{"4", "*", "x"}], ")"}]}], ",", " ", "x"}], ")"}]}], 
  ";"}]], "Code",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, 3.423617639828125*^9, 
   3.4236176860625*^9, {3.483587720388749*^9, 3.4835877242543073`*^9}, {
   3.483587764512195*^9, 3.4835877646924543`*^9}, {3.4835878183996816`*^9, 
   3.483587819210848*^9}, {3.4835880879873295`*^9, 3.48358813496488*^9}, {
   3.4903378797389593`*^9, 3.490337891878976*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"2", "*", "sum", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"_R", "*", "ln", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"exp", 
        RowBox[{"(", 
         RowBox[{"2", "*", "x"}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4096", "*", 
           RowBox[{"_R", "^", "3"}]}], "-", 
          RowBox[{"48", "*", "_R"}]}], ")"}], "*", "exp", 
        RowBox[{"(", "x", ")"}]}], "+", "1"}], ")"}]}], ",", 
    RowBox[{"_R", "=", 
     RowBox[{"RootOf", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"32768", "*", 
         RowBox[{"_Z", "^", "4"}]}], "-", 
        RowBox[{"512", "*", 
         RowBox[{"_Z", "^", "2"}]}], "+", "1"}], ")"}]}]}]}], 
   ")"}]}]], "Output"]
}, Closed]],

Cell["", "Text"],

Cell["\<\
Note that these systems give similar results to the above for the hyperbolic \
cosine function.\
\>", "Subsubtitle",
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832040958843503`*^9, 3.4832041044566765`*^9}, 3.483204218670909*^9, 
   3.4833920379275217`*^9, {3.483392125182989*^9, 3.4833921454921923`*^9}, {
   3.48339221312945*^9, 3.483392219528651*^9}, {3.483392987983635*^9, 
   3.4833931408334227`*^9}, {3.4833932165322723`*^9, 3.483393223472251*^9}, {
   3.483395056508027*^9, 3.4833950705081587`*^9}, {3.4833959109166064`*^9, 
   3.483395925577688*^9}, {3.483395964633848*^9, 3.4833959819287167`*^9}, {
   3.4833961127468243`*^9, 3.483396122781253*^9}, 3.490048900827781*^9, 
   3.4900489594451337`*^9, {3.4902128221680546`*^9, 3.4902128464728975`*^9}, {
   3.4902329319281735`*^9, 3.490232932520975*^9}, {3.4903264807789726`*^9, 
   3.490326481278973*^9}, {3.4903284635517483`*^9, 3.49032847905177*^9}}],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Hyperbolic Function Integration Problem 5", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, {3.4821973084456434`*^9, 3.482197309066536*^9}, {
   3.4821982364300194`*^9, 3.482198240976557*^9}, 3.4821983521564255`*^9, 
   3.483502078611038*^9, 3.4903282650814705`*^9, 3.490330027423938*^9, 
   3.490338617491994*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Integral]", 
    RowBox[{
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Tanh", "[", "x", "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], "   ", 
   StyleBox["&",
    FontFamily->"Arial",
    FontSize->24]}], "   ", 
  RowBox[{"\[Integral]", 
   RowBox[{
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Coth", "[", "x", "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
   3.482197249951533*^9, 3.482198265491808*^9, {3.4835853080499763`*^9, 
   3.4835853112545843`*^9}, {3.4903274692903566`*^9, 3.490327489740385*^9}, 
   3.4903831493733673`*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " results are simple and symmetric:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443225459641647`*^9, 3.4443225485078225`*^9}, {
   3.4466948911496077`*^9, 3.42301074665625*^9}, 3.42317159478125*^9, {
   3.423174840640625*^9, 3.423174854046875*^9}, {3.4233322945*^9, 
   3.4233323091875*^9}, {3.42333236403125*^9, 3.423332366546875*^9}, {
   3.423332643984375*^9, 3.42333264684375*^9}, {3.423338772921875*^9, 
   3.423338774734375*^9}, 3.423341072796875*^9, {3.423341460375*^9, 
   3.4233414605625*^9}, {3.42335786965625*^9, 3.423357883921875*^9}, {
   3.455347583937736*^9, 3.455347624856574*^9}, 3.4553489047269373`*^9, {
   3.455420646984926*^9, 3.45542065869176*^9}, {3.48219843077948*^9, 
   3.482198431380344*^9}, 3.4826463120230017`*^9, {3.483585389216688*^9, 
   3.4835853921609216`*^9}, {3.4903270537797747`*^9, 3.4903270559797773`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     SqrtBox[
      RowBox[{"1", "+", 
       RowBox[{"Tanh", "[", "x", "]"}]}]], ",", "x"}], "]"}], ",", " ", 
   RowBox[{"Int", "[", 
    RowBox[{
     SqrtBox[
      RowBox[{"1", "+", 
       RowBox[{"Coth", "[", "x", "]"}]}]], ",", "x"}], "]"}]}], 
  "}"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, {3.455334181485957*^9, 
   3.455334194264331*^9}, {3.4553471254684896`*^9, 3.455347126660203*^9}, {
   3.455347168590496*^9, 3.455347170423131*^9}, {3.4553474605803566`*^9, 
   3.4553474615517535`*^9}, {3.4553478671349535`*^9, 3.4553479098263407`*^9}, 
   3.4553485173899746`*^9, 3.455394632988637*^9, 3.45541853923413*^9, {
   3.4554203765760975`*^9, 3.4554203843572865`*^9}, 3.4835853174234543`*^9, 
   3.4903248929667497`*^9, {3.490327008699712*^9, 3.4903270189997263`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SqrtBox["2"], " ", 
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      SqrtBox[
       RowBox[{"1", "+", 
        RowBox[{"Tanh", "[", "x", "]"}]}]], 
      SqrtBox["2"]], "]"}]}], ",", 
   RowBox[{
    SqrtBox["2"], " ", 
    RowBox[{"ArcCoth", "[", 
     FractionBox[
      SqrtBox[
       RowBox[{"1", "+", 
        RowBox[{"Coth", "[", "x", "]"}]}]], 
      SqrtBox["2"]], "]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.455394642602461*^9, {3.4554185417677727`*^9, 3.4554185696478624`*^9}, {
   3.4554203792499423`*^9, 3.455420392318734*^9}, 3.4903270195397267`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Tanh", "[", "x", "]"}]}]}]], ",", "x"}], "]"}], ",", " ", 
   RowBox[{"Int", "[", 
    RowBox[{
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Coth", "[", "x", "]"}]}]}]], ",", "x"}], "]"}]}], 
  "}"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, {3.455334181485957*^9, 
   3.455334194264331*^9}, {3.4553471254684896`*^9, 3.455347126660203*^9}, {
   3.455347168590496*^9, 3.455347170423131*^9}, {3.4553474605803566`*^9, 
   3.4553474615517535`*^9}, {3.4553478671349535`*^9, 3.4553479098263407`*^9}, 
   3.4553485173899746`*^9, 3.455394632988637*^9, 3.45541853923413*^9, {
   3.4554203765760975`*^9, 3.4554203843572865`*^9}, {3.483585320067256*^9, 
   3.4835853233119216`*^9}, {3.4835854166761727`*^9, 3.483585422344323*^9}, 
   3.490324892326749*^9, {3.490327026049736*^9, 3.4903270460097637`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"a", "-", "b"}]]}], " ", 
     RowBox[{"ArcTanh", "[", 
      FractionBox[
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Tanh", "[", "x", "]"}]}]}]], 
       SqrtBox[
        RowBox[{"a", "-", "b"}]]], "]"}]}], "+", 
    RowBox[{
     SqrtBox[
      RowBox[{"a", "+", "b"}]], " ", 
     RowBox[{"ArcTanh", "[", 
      FractionBox[
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Tanh", "[", "x", "]"}]}]}]], 
       SqrtBox[
        RowBox[{"a", "+", "b"}]]], "]"}]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"a", "-", "b"}]]}], " ", 
     RowBox[{"ArcTanh", "[", 
      FractionBox[
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Coth", "[", "x", "]"}]}]}]], 
       SqrtBox[
        RowBox[{"a", "-", "b"}]]], "]"}]}], "+", 
    RowBox[{
     SqrtBox[
      RowBox[{"a", "+", "b"}]], " ", 
     RowBox[{"ArcTanh", "[", 
      FractionBox[
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Coth", "[", "x", "]"}]}]}]], 
       SqrtBox[
        RowBox[{"a", "+", "b"}]]], "]"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.4903271760399456`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " results are more complicated involving the imaginary unit and",
 StyleBox[" ",
  FontSlant->"Italic"],
 "not symmetric:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500256179667`*^9}, {3.4466836176090527`*^9, 3.446683618790752*^9}, {
   3.4466950388319645`*^9, 3.423171727*^9}, {3.423617028171875*^9, 
   3.4236170379375*^9}, {3.4553479526979876`*^9, 3.4553479664477587`*^9}, 
   3.4553488631171055`*^9, {3.455349270663128*^9, 3.4553492792855263`*^9}, {
   3.455418631356595*^9, 3.455418640579858*^9}, {3.455420667674677*^9, 
   3.455420685630496*^9}, 3.482198398813515*^9, 3.4826463512794495`*^9, {
   3.48358536038523*^9, 3.483585371371027*^9}, {3.4903272271400175`*^9, 
   3.4903272629500675`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Integral]", 
    RowBox[{
     SqrtBox[
      RowBox[{"1", "+", 
       RowBox[{"Tanh", "[", "x", "]"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], ",", " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SqrtBox[
      RowBox[{"1", "+", 
       RowBox[{"Coth", "[", "x", "]"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "}"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
   3.4443498869285407`*^9}, {3.444349974083864*^9, 3.423171727*^9}, 
   3.423616899578125*^9, {3.455334328146845*^9, 3.455334346853744*^9}, {
   3.455347028589184*^9, 3.4553470351786594`*^9}, {3.455347077739859*^9, 
   3.455347084088989*^9}, {3.455347223879998*^9, 3.4553472252820144`*^9}, {
   3.455347418329603*^9, 3.4553474190906973`*^9}, {3.4553479192198477`*^9, 
   3.4553479280225058`*^9}, {3.455348103234448*^9, 3.4553481049168673`*^9}, 
   3.455348542746435*^9, 3.455394686425475*^9, 3.4554185991202416`*^9, {
   3.4554204128182116`*^9, 3.455420415141552*^9}, 3.483585339875739*^9, 
   3.490326780929393*^9, {3.4903271002698393`*^9, 3.490327111839856*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SqrtBox["2"], " ", 
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      SqrtBox[
       RowBox[{"1", "+", 
        RowBox[{"Tanh", "[", "x", "]"}]}]], 
      SqrtBox["2"]], "]"}]}], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], " ", 
     RowBox[{"ArcTan", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         FractionBox["1", "2"], "+", 
         FractionBox["\[ImaginaryI]", "2"]}], ")"}], " ", 
       SqrtBox[
        RowBox[{"\[ImaginaryI]", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"Coth", "[", "x", "]"}]}], ")"}]}]]}], "]"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"Coth", "[", "x", "]"}]}], ")"}], 
      RowBox[{"3", "/", "2"}]]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"Coth", "[", "x", "]"}]}], ")"}]}], ")"}], 
     RowBox[{"3", "/", "2"}]]]}], "}"}]], "Output",
 CellChangeTimes->{3.4553492672882752`*^9, 3.455394687366829*^9, 
  3.4554186004721856`*^9, 3.4554204187367215`*^9, 3.4903271143198595`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Integral]", 
    RowBox[{
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Tanh", "[", "x", "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], ",", " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Coth", "[", "x", "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "}"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
   3.4443498869285407`*^9}, {3.444349974083864*^9, 3.423171727*^9}, 
   3.423616899578125*^9, {3.455334328146845*^9, 3.455334346853744*^9}, {
   3.455347028589184*^9, 3.4553470351786594`*^9}, {3.455347077739859*^9, 
   3.455347084088989*^9}, {3.455347223879998*^9, 3.4553472252820144`*^9}, {
   3.455347418329603*^9, 3.4553474190906973`*^9}, {3.4553479192198477`*^9, 
   3.4553479280225058`*^9}, {3.455348103234448*^9, 3.4553481049168673`*^9}, 
   3.455348542746435*^9, 3.455394686425475*^9, 3.4554185991202416`*^9, {
   3.4554204128182116`*^9, 3.455420415141552*^9}, {3.483585342229123*^9, 
   3.483585343781355*^9}, {3.4835854654463005`*^9, 3.4835854754506865`*^9}, {
   3.4903271263098764`*^9, 3.4903271354198885`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"a", "-", "b"}]]}], " ", 
     RowBox[{"ArcTanh", "[", 
      FractionBox[
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Tanh", "[", "x", "]"}]}]}]], 
       SqrtBox[
        RowBox[{"a", "-", "b"}]]], "]"}]}], "+", 
    RowBox[{
     SqrtBox[
      RowBox[{"a", "+", "b"}]], " ", 
     RowBox[{"ArcTanh", "[", 
      FractionBox[
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Tanh", "[", "x", "]"}]}]}]], 
       SqrtBox[
        RowBox[{"a", "+", "b"}]]], "]"}]}]}], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SqrtBox[
          RowBox[{"\[ImaginaryI]", " ", 
           RowBox[{"(", 
            RowBox[{"a", "-", "b"}], ")"}]}]]}], " ", 
        RowBox[{"ArcTanh", "[", 
         FractionBox[
          SqrtBox[
           RowBox[{"\[ImaginaryI]", " ", 
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", " ", 
               RowBox[{"Coth", "[", "x", "]"}]}]}], ")"}]}]], 
          SqrtBox[
           RowBox[{"\[ImaginaryI]", " ", 
            RowBox[{"(", 
             RowBox[{"a", "-", "b"}], ")"}]}]]], "]"}]}], "+", 
       RowBox[{
        SqrtBox[
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
           RowBox[{"a", "+", "b"}], ")"}]}]], " ", 
        RowBox[{"ArcTanh", "[", 
         FractionBox[
          SqrtBox[
           RowBox[{"\[ImaginaryI]", " ", 
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", " ", 
               RowBox[{"Coth", "[", "x", "]"}]}]}], ")"}]}]], 
          SqrtBox[
           RowBox[{"\[ImaginaryI]", " ", 
            RowBox[{"(", 
             RowBox[{"a", "+", "b"}], ")"}]}]]], "]"}]}]}], ")"}], " ", 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Coth", "[", "x", "]"}]}]}]]}], 
    SqrtBox[
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Coth", "[", "x", "]"}]}]}], ")"}]}]]]}], "}"}]], "Output",
 CellChangeTimes->{
  3.483585344602536*^9, {3.4835854667882304`*^9, 3.4835854762818813`*^9}, 
   3.4903271373298917`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Maple",
  FontSlant->"Italic"],
 " results are simple and symmetric:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500407697535`*^9}, {3.444350203233365*^9, 3.4443502040245028`*^9}, {
   3.444350234528365*^9, 3.4443502387243986`*^9}, {3.4466836227764835`*^9, 
   3.4466836230168285`*^9}, {3.4466839811618156`*^9, 
   3.4466839896239843`*^9}, {3.4466950433384447`*^9, 3.42301083234375*^9}, 
   3.423171727*^9, 3.423617053328125*^9, {3.4553480765961437`*^9, 
   3.455348092218608*^9}, 3.455349010609189*^9, {3.455418938267912*^9, 
   3.4554189625127745`*^9}, {3.4554207208611555`*^9, 3.455420729743928*^9}, 
   3.4821983844829087`*^9, 3.4826463934901457`*^9, {3.483585485425029*^9, 
   3.4835854878485136`*^9}, {3.490327445360323*^9, 3.490327448310327*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"[", 
   RowBox[{
    RowBox[{"int", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"sqrt", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"tanh", 
           RowBox[{"(", "x", ")"}]}]}], ")"}]}], ",", "x"}], ")"}]}], ",", 
    " ", 
    RowBox[{"int", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"sqrt", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"coth", 
           RowBox[{"(", "x", ")"}]}]}], ")"}]}], ",", "x"}], ")"}]}]}], "]"}],
   ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444350078924618*^9, 3.423171727*^9}, {
   3.4236169183125*^9, 3.423616928921875*^9}, {3.4553480452110147`*^9, 
   3.4553480557261343`*^9}, {3.455348571317518*^9, 3.455348579389125*^9}, {
   3.455348631163573*^9, 3.455348631474019*^9}, {3.455394722427243*^9, 
   3.4553947243399935`*^9}, {3.455418730939789*^9, 3.4554187687842064`*^9}, {
   3.455420432816968*^9, 3.455420454728475*^9}, 3.4835854939973555`*^9, 
   3.490324894666752*^9, {3.4903272861900997`*^9, 3.490327299370118*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SqrtBox["2"], " ", 
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      SqrtBox[
       RowBox[{"1", "+", 
        RowBox[{"Tanh", "[", "x", "]"}]}]], 
      SqrtBox["2"]], "]"}]}], ",", 
   RowBox[{
    SqrtBox["2"], " ", 
    RowBox[{"ArcCoth", "[", 
     FractionBox[
      SqrtBox[
       RowBox[{"1", "+", 
        RowBox[{"Coth", "[", "x", "]"}]}]], 
      SqrtBox["2"]], "]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.455394642602461*^9, {3.4554185417677727`*^9, 3.4554185696478624`*^9}, {
   3.4554203792499423`*^9, 3.455420392318734*^9}, 3.4903270195397267`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"[", 
   RowBox[{
    RowBox[{"int", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"sqrt", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "tanh", 
           RowBox[{"(", "x", ")"}]}]}], ")"}]}], ",", "x"}], ")"}]}], ",", 
    " ", 
    RowBox[{"int", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"sqrt", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "coth", 
           RowBox[{"(", "x", ")"}]}]}], ")"}]}], ",", "x"}], ")"}]}]}], "]"}],
   ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444350078924618*^9, 3.423171727*^9}, {
   3.4236169183125*^9, 3.423616928921875*^9}, {3.4553480452110147`*^9, 
   3.4553480557261343`*^9}, {3.455348571317518*^9, 3.455348579389125*^9}, {
   3.455348631163573*^9, 3.455348631474019*^9}, {3.455394722427243*^9, 
   3.4553947243399935`*^9}, {3.455418730939789*^9, 3.4554187687842064`*^9}, {
   3.455420432816968*^9, 3.455420454728475*^9}, {3.4835855027198973`*^9, 
   3.483585505634088*^9}, 3.490324894086751*^9, {3.4903273500601892`*^9, 
   3.490327367620214*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"a", "-", "b"}]]}], " ", 
     RowBox[{"ArcTanh", "[", 
      FractionBox[
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Tanh", "[", "x", "]"}]}]}]], 
       SqrtBox[
        RowBox[{"a", "-", "b"}]]], "]"}]}], "+", 
    RowBox[{
     SqrtBox[
      RowBox[{"a", "+", "b"}]], " ", 
     RowBox[{"ArcTanh", "[", 
      FractionBox[
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Tanh", "[", "x", "]"}]}]}]], 
       SqrtBox[
        RowBox[{"a", "+", "b"}]]], "]"}]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"a", "-", "b"}]]}], " ", 
     RowBox[{"ArcTanh", "[", 
      FractionBox[
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Coth", "[", "x", "]"}]}]}]], 
       SqrtBox[
        RowBox[{"a", "-", "b"}]]], "]"}]}], "+", 
    RowBox[{
     SqrtBox[
      RowBox[{"a", "+", "b"}]], " ", 
     RowBox[{"ArcTanh", "[", 
      FractionBox[
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Coth", "[", "x", "]"}]}]}]], 
       SqrtBox[
        RowBox[{"a", "+", "b"}]]], "]"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.4903271760399456`*^9}]
}, Closed]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Hyperbolic Function Integration Problem 6", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, {3.4821973084456434`*^9, 3.482197309066536*^9}, {
   3.4821982364300194`*^9, 3.482198240976557*^9}, 3.482198354339565*^9, 
   3.483498951304192*^9, 3.4835020922506514`*^9, 3.4903300297139406`*^9, 
   3.4903386205719986`*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"Sech", "[", "x", "]"}], "2"], 
    SqrtBox[
     RowBox[{"a", "-", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Tanh", "[", "x", "]"}], "2"]}]}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
   3.482197249951533*^9, 3.482198265491808*^9, 3.482198302815477*^9, {
   3.483582245576355*^9, 3.483582252356104*^9}, {3.483583120494426*^9, 
   3.483583122427205*^9}, 3.4903831469533634`*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " results are simple for both symbolic and numeric a and b:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443225459641647`*^9, 3.4443225485078225`*^9}, {
   3.4466948911496077`*^9, 3.42301074665625*^9}, 3.42317159478125*^9, {
   3.423174840640625*^9, 3.423174854046875*^9}, {3.4233322945*^9, 
   3.4233323091875*^9}, {3.42333236403125*^9, 3.423332366546875*^9}, {
   3.423332643984375*^9, 3.42333264684375*^9}, {3.423338772921875*^9, 
   3.423338774734375*^9}, 3.423341072796875*^9, {3.423341460375*^9, 
   3.4233414605625*^9}, {3.42335786965625*^9, 3.423357883921875*^9}, {
   3.455347583937736*^9, 3.455347624856574*^9}, 3.4553489047269373`*^9, 
   3.4821984175204144`*^9, {3.4835838717146273`*^9, 3.4835839211657343`*^9}, {
   3.490328604101945*^9, 3.490328627621978*^9}, {3.490328815702241*^9, 
   3.4903288294022603`*^9}}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"Sech", "[", "x", "]"}], "2"], 
    SqrtBox[
     RowBox[{"a", "-", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Tanh", "[", "x", "]"}], "2"]}]}]]], ",", "x"}], 
  "]"}]], "Input",
 CellDingbat->None,
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, {3.455334181485957*^9, 
   3.455334194264331*^9}, {3.4553471254684896`*^9, 3.455347126660203*^9}, {
   3.455347168590496*^9, 3.455347170423131*^9}, {3.4553474605803566`*^9, 
   3.4553474615517535`*^9}, {3.4553478671349535`*^9, 3.4553479098263407`*^9}, 
   3.4553485173899746`*^9, 3.455394632988637*^9, 3.45541853923413*^9, {
   3.4835822610586176`*^9, 3.483582287286331*^9}, {3.483583129747731*^9, 
   3.483583130058178*^9}, 3.4835832605658383`*^9, 3.4903248980267563`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{
      RowBox[{"Coth", "[", "x", "]"}], " ", 
      SqrtBox[
       RowBox[{"a", "-", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Tanh", "[", "x", "]"}], "2"]}]}]]}], 
     SqrtBox["b"]], "]"}], 
   SqrtBox["b"]]}]], "Output",
 CellChangeTimes->{3.48358326304941*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"Sech", "[", "x", "]"}], "2"], 
    SqrtBox[
     RowBox[{"1", "-", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Tanh", "[", "x", "]"}], "2"]}]}]]], ",", "x"}], 
  "]"}]], "Input",
 CellDingbat->None,
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, {3.455334181485957*^9, 
   3.455334194264331*^9}, {3.4553471254684896`*^9, 3.455347126660203*^9}, {
   3.455347168590496*^9, 3.455347170423131*^9}, {3.4553474605803566`*^9, 
   3.4553474615517535`*^9}, {3.4553478671349535`*^9, 3.4553479098263407`*^9}, 
   3.4553485173899746`*^9, 3.455394632988637*^9, 3.45541853923413*^9, {
   3.4835822610586176`*^9, 3.483582287286331*^9}, {3.483583129747731*^9, 
   3.483583130058178*^9}, 3.4835832518032384`*^9, 3.4903248985367575`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{"ArcSin", "[", 
   RowBox[{
    SqrtBox["b"], " ", 
    RowBox[{"Tanh", "[", "x", "]"}]}], "]"}], 
  SqrtBox["b"]]], "Output",
 CellChangeTimes->{
  3.455394642602461*^9, {3.4554185417677727`*^9, 3.4554185696478624`*^9}, 
   3.483582294326454*^9, 3.4835832209288435`*^9, 3.4835832575615187`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"Sech", "[", "x", "]"}], "2"], 
    SqrtBox[
     RowBox[{"1", "-", 
      RowBox[{"4", " ", 
       SuperscriptBox[
        RowBox[{"Tanh", "[", "x", "]"}], "2"]}]}]]], ",", "x"}], 
  "]"}]], "Input",
 CellDingbat->None,
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, {3.455334181485957*^9, 
   3.455334194264331*^9}, {3.4553471254684896`*^9, 3.455347126660203*^9}, {
   3.455347168590496*^9, 3.455347170423131*^9}, {3.4553474605803566`*^9, 
   3.4553474615517535`*^9}, {3.4553478671349535`*^9, 3.4553479098263407`*^9}, 
   3.4553485173899746`*^9, 3.455394632988637*^9, 3.45541853923413*^9, {
   3.4835822610586176`*^9, 3.483582287286331*^9}, {3.483583129747731*^9, 
   3.483583130058178*^9}, {3.4835832335469875`*^9, 3.4835832377129774`*^9}, 
   3.490324899016758*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"ArcSin", "[", 
   RowBox[{"2", " ", 
    RowBox[{"Tanh", "[", "x", "]"}]}], "]"}]}]], "Output",
 CellChangeTimes->{
  3.4553468542785378`*^9, {3.4553472025493264`*^9, 3.45534720758657*^9}, 
   3.4553478720920815`*^9, 3.455348533112582*^9, 3.45539466080864*^9, 
   3.4554185867724867`*^9, 3.483582310169235*^9, 3.4835832394955406`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " apparently uses the hyperbolic tangent theta/2 substitution for the \
numeric case:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500256179667`*^9}, {3.4466836176090527`*^9, 3.446683618790752*^9}, {
   3.4466950388319645`*^9, 3.423171727*^9}, {3.423617028171875*^9, 
   3.4236170379375*^9}, {3.4553479526979876`*^9, 3.4553479664477587`*^9}, 
   3.4553488631171055`*^9, {3.455349270663128*^9, 3.4553492792855263`*^9}, {
   3.455418631356595*^9, 3.455418640579858*^9}, 3.4821983994243937`*^9, {
   3.4835837630383587`*^9, 3.4835838411306496`*^9}, {3.4903287730921817`*^9, 
   3.4903287741421833`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"Sech", "[", "x", "]"}], "2"], 
    SqrtBox[
     RowBox[{"a", "-", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Tanh", "[", "x", "]"}], "2"]}]}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellDingbat->None,
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
   3.4443498869285407`*^9}, {3.444349974083864*^9, 3.423171727*^9}, 
   3.423616899578125*^9, {3.455334328146845*^9, 3.455334346853744*^9}, {
   3.455347028589184*^9, 3.4553470351786594`*^9}, {3.455347077739859*^9, 
   3.455347084088989*^9}, {3.455347223879998*^9, 3.4553472252820144`*^9}, {
   3.455347418329603*^9, 3.4553474190906973`*^9}, {3.4553479192198477`*^9, 
   3.4553479280225058`*^9}, {3.455348103234448*^9, 3.4553481049168673`*^9}, 
   3.455348542746435*^9, 3.455394686425475*^9, 3.4554185991202416`*^9, {
   3.4835822694406705`*^9, 3.4835822731560125`*^9}, {3.4835823250506334`*^9, 
   3.4835823270334845`*^9}, {3.4835833246279554`*^9, 3.4835833281129665`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{
      SqrtBox["2"], " ", 
      SqrtBox["b"], " ", 
      RowBox[{"Sinh", "[", "x", "]"}]}], 
     SqrtBox[
      RowBox[{"a", "+", "b", "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "-", "b"}], ")"}], " ", 
        RowBox[{"Cosh", "[", 
         RowBox[{"2", " ", "x"}], "]"}]}]}]]], "]"}], " ", 
   SqrtBox[
    RowBox[{"a", "+", "b", "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "b"}], ")"}], " ", 
      RowBox[{"Cosh", "[", 
       RowBox[{"2", " ", "x"}], "]"}]}]}]], " ", 
   RowBox[{"Sech", "[", "x", "]"}]}], 
  RowBox[{
   SqrtBox["2"], " ", 
   SqrtBox["b"], " ", 
   SqrtBox[
    RowBox[{"a", "-", 
     RowBox[{"b", " ", 
      SuperscriptBox[
       RowBox[{"Tanh", "[", "x", "]"}], "2"]}]}]]}]]], "Output",
 CellChangeTimes->{3.4553492672882752`*^9, 3.455394687366829*^9, 
  3.4554186004721856`*^9, 3.4835823376387343`*^9, 3.4835833301258607`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"Sech", "[", "x", "]"}], "2"], 
    SqrtBox[
     RowBox[{"1", "-", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Tanh", "[", "x", "]"}], "2"]}]}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellDingbat->None,
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
   3.4443498869285407`*^9}, {3.444349974083864*^9, 3.423171727*^9}, 
   3.423616899578125*^9, {3.455334328146845*^9, 3.455334346853744*^9}, {
   3.455347028589184*^9, 3.4553470351786594`*^9}, {3.455347077739859*^9, 
   3.455347084088989*^9}, {3.455347223879998*^9, 3.4553472252820144`*^9}, {
   3.455347418329603*^9, 3.4553474190906973`*^9}, {3.4553479192198477`*^9, 
   3.4553479280225058`*^9}, {3.455348103234448*^9, 3.4553481049168673`*^9}, 
   3.455348542746435*^9, 3.455394686425475*^9, 3.4554185991202416`*^9, {
   3.4835822694406705`*^9, 3.4835822731560125`*^9}, {3.4835823250506334`*^9, 
   3.4835823270334845`*^9}, {3.4835833246279554`*^9, 3.483583337426358*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{"ArcSin", "[", 
   RowBox[{
    SqrtBox["b"], " ", 
    RowBox[{"Tanh", "[", "x", "]"}]}], "]"}], 
  SqrtBox["b"]]], "Output",
 CellChangeTimes->{3.483583338688173*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"Sech", "[", "x", "]"}], "2"], 
    SqrtBox[
     RowBox[{"1", "-", 
      RowBox[{"4", " ", 
       SuperscriptBox[
        RowBox[{"Tanh", "[", "x", "]"}], "2"]}]}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellDingbat->None,
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
   3.4443498869285407`*^9}, {3.4443499715902786`*^9, 3.423171727*^9}, {
   3.423616902765625*^9, 3.423616905984375*^9}, {3.455346949345237*^9, 
   3.4553469519389668`*^9}, {3.455347010242803*^9, 3.455347011544675*^9}, {
   3.4553470654321613`*^9, 3.45534706579268*^9}, {3.4553470967471905`*^9, 
   3.4553470986899843`*^9}, {3.455347239051814*^9, 3.45534724229648*^9}, {
   3.4553474305271425`*^9, 3.4553474314484673`*^9}, {3.455347940029771*^9, 
   3.45534794114137*^9}, {3.455348107600726*^9, 3.4553481090828576`*^9}, 
   3.4553485570770416`*^9, {3.45539469870313*^9, 3.4553947113312883`*^9}, {
   3.455418608013029*^9, 3.4554186112476797`*^9}, {3.455418664313986*^9, 
   3.455418692063888*^9}, {3.4835822758498864`*^9, 3.4835822787340336`*^9}, {
   3.4835823301579776`*^9, 3.4835823335929165`*^9}, {3.4835833491932783`*^9, 
   3.4835833494736814`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"1", "-", 
      RowBox[{"4", " ", 
       SuperscriptBox[
        RowBox[{"Tanh", "[", "x", "]"}], "2"]}]}]]], 
   RowBox[{"2", " ", 
    SuperscriptBox[
     RowBox[{"Cosh", "[", 
      FractionBox["x", "2"], "]"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"EllipticF", "[", 
       RowBox[{
        RowBox[{"ArcSin", "[", 
         FractionBox[
          RowBox[{"Tanh", "[", 
           FractionBox["x", "2"], "]"}], 
          SqrtBox[
           RowBox[{"7", "-", 
            RowBox[{"4", " ", 
             SqrtBox["3"]}]}]]], "]"}], ",", 
        RowBox[{"97", "-", 
         RowBox[{"56", " ", 
          SqrtBox["3"]}]}]}], "]"}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"EllipticPi", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "7"}], "+", 
          RowBox[{"4", " ", 
           SqrtBox["3"]}]}], ",", 
         RowBox[{"-", 
          RowBox[{"ArcSin", "[", 
           FractionBox[
            RowBox[{"Tanh", "[", 
             FractionBox["x", "2"], "]"}], 
            SqrtBox[
             RowBox[{"7", "-", 
              RowBox[{"4", " ", 
               SqrtBox["3"]}]}]]], "]"}]}], ",", 
         RowBox[{"97", "-", 
          RowBox[{"56", " ", 
           SqrtBox["3"]}]}]}], "]"}]}]}], ")"}], " ", 
    RowBox[{"Sech", "[", "x", "]"}], " ", 
    SqrtBox[
     RowBox[{"7", "-", 
      RowBox[{"4", " ", 
       SqrtBox["3"]}], "-", 
      SuperscriptBox[
       RowBox[{"Tanh", "[", 
        FractionBox["x", "2"], "]"}], "2"]}]], " ", 
    SqrtBox[
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "7"}], "+", 
         RowBox[{"4", " ", 
          SqrtBox["3"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"Tanh", "[", 
         FractionBox["x", "2"], "]"}], "2"]}]}]]}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.44434988769965*^9, {3.4466836278337555`*^9, 3.423171727*^9}, 
   3.4236170036875*^9, 3.455346953070594*^9, 3.455347013477454*^9, 
   3.4553470664336014`*^9, 3.45534709909056*^9, 3.455347243347992*^9, 
   3.4553474328304543`*^9, 3.455347941982579*^9, 3.4553485578681793`*^9, {
   3.45539470002503*^9, 3.4553947048119135`*^9}, 3.4554186321877904`*^9, 
   3.45541868619545*^9, 3.4835823560952735`*^9, 3.4835833643350515`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " is unable to integrate ",
 Cell[BoxData[
  StyleBox[
   FractionBox[
    SuperscriptBox[
     RowBox[{"Sech", "[", "x", "]"}], "2"], 
    SqrtBox[
     RowBox[{"a", "-", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Tanh", "[", "x", "]"}], "2"]}]}]]],
   FontSize->18,
   FontWeight->"Bold"]],
  CellChangeTimes->{{3.4554189087654896`*^9, 3.455418908825576*^9}, {
   3.483582592435114*^9, 3.4835826255026627`*^9}, {3.4835834806022353`*^9, 
   3.483583485829752*^9}}],
 " for symbolic and numeric variables a and b:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500407697535`*^9}, {3.444350203233365*^9, 3.4443502040245028`*^9}, {
   3.444350234528365*^9, 3.4443502387243986`*^9}, {3.4466836227764835`*^9, 
   3.4466836230168285`*^9}, {3.4466839811618156`*^9, 
   3.4466839896239843`*^9}, {3.4466950433384447`*^9, 3.42301083234375*^9}, 
   3.423171727*^9, 3.423617053328125*^9, {3.4553480765961437`*^9, 
   3.455348092218608*^9}, 3.455349010609189*^9, {3.455418938267912*^9, 
   3.4554189625127745`*^9}, 3.4821983694813375`*^9, {3.483583497927147*^9, 
   3.4835835656545343`*^9}, {3.490328709782093*^9, 3.4903287108120947`*^9}, {
   3.490328751832152*^9, 3.490328756892159*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"sech", 
      RowBox[{
       RowBox[{
        RowBox[{"(", "x", ")"}], "^", "2"}], "/", "sqrt"}], 
      RowBox[{"(", 
       RowBox[{"a", "-", 
        RowBox[{"b", "*", "tanh", 
         RowBox[{
          RowBox[{"(", "x", ")"}], "^", "2"}]}]}], ")"}]}], ",", "x"}], 
    ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444350078924618*^9, 3.423171727*^9}, {
   3.4236169183125*^9, 3.423616928921875*^9}, {3.4553480452110147`*^9, 
   3.4553480557261343`*^9}, {3.455348571317518*^9, 3.455348579389125*^9}, {
   3.455348631163573*^9, 3.455348631474019*^9}, {3.455394722427243*^9, 
   3.4553947243399935`*^9}, {3.455418730939789*^9, 3.4554187687842064`*^9}, {
   3.483582575851267*^9, 3.4835825804378624`*^9}, {3.4835828791874433`*^9, 
   3.483582880789747*^9}, {3.483583467152896*^9, 3.483583468805272*^9}, 
   3.490324899816759*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"Sech", "[", "x", "]"}], "2"], 
    SqrtBox[
     RowBox[{"a", "-", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Tanh", "[", "x", "]"}], "2"]}]}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellChangeTimes->{{3.4554189087654896`*^9, 3.455418908825576*^9}, {
  3.483582592435114*^9, 3.4835826255026627`*^9}, {3.4835834806022353`*^9, 
  3.483583485829752*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"sech", 
      RowBox[{
       RowBox[{
        RowBox[{"(", "x", ")"}], "^", "2"}], "/", "sqrt"}], 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"b", "*", "tanh", 
         RowBox[{
          RowBox[{"(", "x", ")"}], "^", "2"}]}]}], ")"}]}], ",", "x"}], 
    ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444350078924618*^9, 3.423171727*^9}, {
   3.4236169183125*^9, 3.423616928921875*^9}, {3.4553480452110147`*^9, 
   3.4553480557261343`*^9}, {3.455348571317518*^9, 3.455348579389125*^9}, {
   3.455348631163573*^9, 3.455348631474019*^9}, {3.455394722427243*^9, 
   3.4553947243399935`*^9}, {3.455418730939789*^9, 3.4554187687842064`*^9}, {
   3.483582575851267*^9, 3.4835825804378624`*^9}, {3.4835828791874433`*^9, 
   3.483582880789747*^9}, {3.4835834733718386`*^9, 3.4835834737623997`*^9}, 
   3.4903249002467594`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"Sech", "[", "x", "]"}], "2"], 
    SqrtBox[
     RowBox[{"1", "-", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Tanh", "[", "x", "]"}], "2"]}]}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellChangeTimes->{{3.4554189087654896`*^9, 3.455418908825576*^9}, {
  3.483582592435114*^9, 3.4835826255026627`*^9}, {3.4835834896953106`*^9, 
  3.4835834899156275`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"sech", 
      RowBox[{
       RowBox[{
        RowBox[{"(", "x", ")"}], "^", "2"}], "/", "sqrt"}], 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"4", "*", "tanh", 
         RowBox[{
          RowBox[{"(", "x", ")"}], "^", "2"}]}]}], ")"}]}], ",", "x"}], 
    ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444350078924618*^9, 3.423171727*^9}, {
   3.4236169183125*^9, 3.423616928921875*^9}, {3.4553480452110147`*^9, 
   3.4553480685545807`*^9}, {3.455348699371651*^9, 3.4553487024060144`*^9}, {
   3.4553490858273473`*^9, 3.4553490905841875`*^9}, {3.455394732331485*^9, 
   3.455394734013904*^9}, {3.455395157973528*^9, 3.4553951627503967`*^9}, {
   3.455418805717314*^9, 3.4554188115657234`*^9}, {3.4835825823706417`*^9, 
   3.483582584583824*^9}, {3.4835828853663282`*^9, 3.4835828888513393`*^9}, {
   3.483583476716648*^9, 3.4835834772474113`*^9}, 3.4903249007467604`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"Sech", "[", "x", "]"}], "2"], 
    SqrtBox[
     RowBox[{"1", "-", 
      RowBox[{"4", " ", 
       SuperscriptBox[
        RowBox[{"Tanh", "[", "x", "]"}], "2"]}]}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellChangeTimes->{{3.4553490926972256`*^9, 3.4553491008289185`*^9}, 
   3.455395176329923*^9, 3.4554189212334175`*^9, {3.483582619544094*^9, 
   3.483582629568509*^9}, {3.4835834927497025`*^9, 3.4835834930301056`*^9}}]
}, Closed]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Hyperbolic Function Integration Problem 7", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, {3.4821973084456434`*^9, 3.482197309066536*^9}, {
   3.4821982364300194`*^9, 3.482198240976557*^9}, 3.482198354339565*^9, 
   3.483498951304192*^9, 3.4835020922506514`*^9, 3.4903300297139406`*^9, 
   3.4903386205719986`*^9, 3.4903393318349967`*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"Tanh", "[", "x", "]"}], 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Tanh", "[", "x", "]"}], "4"]}]}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
   3.482197249951533*^9, 3.482198265491808*^9, 3.482198302815477*^9, {
   3.483582245576355*^9, 3.483582252356104*^9}, {3.483583120494426*^9, 
   3.483583122427205*^9}, {3.490339308054963*^9, 3.4903393173649764`*^9}, 
   3.4903831433033586`*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " is able to integrate the expression:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443225459641647`*^9, 3.4443225485078225`*^9}, {
   3.4466948911496077`*^9, 3.42301074665625*^9}, 3.42317159478125*^9, {
   3.423174840640625*^9, 3.423174854046875*^9}, {3.4233322945*^9, 
   3.4233323091875*^9}, {3.42333236403125*^9, 3.423332366546875*^9}, {
   3.423332643984375*^9, 3.42333264684375*^9}, {3.423338772921875*^9, 
   3.423338774734375*^9}, 3.423341072796875*^9, {3.423341460375*^9, 
   3.4233414605625*^9}, {3.42335786965625*^9, 3.423357883921875*^9}, {
   3.455347583937736*^9, 3.455347624856574*^9}, 3.4553489047269373`*^9, 
   3.4821984175204144`*^9, {3.4835838717146273`*^9, 3.4835839211657343`*^9}, {
   3.490328604101945*^9, 3.490328627621978*^9}, {3.490328815702241*^9, 
   3.4903288294022603`*^9}, {3.490339472105193*^9, 3.4903395069152417`*^9}}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"Tanh", "[", "x", "]"}], 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Tanh", "[", "x", "]"}], "4"]}]}]]], ",", "x"}], 
  "]"}]], "Input",
 CellDingbat->None,
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, {3.455334181485957*^9, 
   3.455334194264331*^9}, {3.4553471254684896`*^9, 3.455347126660203*^9}, {
   3.455347168590496*^9, 3.455347170423131*^9}, {3.4553474605803566`*^9, 
   3.4553474615517535`*^9}, {3.4553478671349535`*^9, 3.4553479098263407`*^9}, 
   3.4553485173899746`*^9, 3.455394632988637*^9, 3.45541853923413*^9, {
   3.4835822610586176`*^9, 3.483582287286331*^9}, {3.483583129747731*^9, 
   3.483583130058178*^9}, 3.4835832605658383`*^9, 3.4903248980267563`*^9, {
   3.4903393552650294`*^9, 3.490339367795047*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{"ArcTanh", "[", 
   FractionBox[
    RowBox[{
     SqrtBox[
      RowBox[{"a", "+", "b"}]], " ", 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Tanh", "[", "x", "]"}], "4"]}]}]]}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox[
       RowBox[{"Tanh", "[", "x", "]"}], "2"]}]}]], "]"}], 
  RowBox[{"2", " ", 
   SqrtBox[
    RowBox[{"a", "+", "b"}]]}]]], "Output",
 CellChangeTimes->{
  3.48358326304941*^9, {3.490339360075036*^9, 3.4903393636850414`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is unable to integrate the expression:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443225459641647`*^9, 3.4443225485078225`*^9}, {
   3.4466948911496077`*^9, 3.42301074665625*^9}, 3.42317159478125*^9, {
   3.423174840640625*^9, 3.423174854046875*^9}, {3.4233322945*^9, 
   3.4233323091875*^9}, {3.42333236403125*^9, 3.423332366546875*^9}, {
   3.423332643984375*^9, 3.42333264684375*^9}, {3.423338772921875*^9, 
   3.423338774734375*^9}, 3.423341072796875*^9, {3.423341460375*^9, 
   3.4233414605625*^9}, {3.42335786965625*^9, 3.423357883921875*^9}, {
   3.455347583937736*^9, 3.455347624856574*^9}, 3.4553489047269373`*^9, 
   3.4821984175204144`*^9, {3.4835838717146273`*^9, 3.4835839211657343`*^9}, {
   3.490328604101945*^9, 3.490328627621978*^9}, {3.490328815702241*^9, 
   3.4903288294022603`*^9}, {3.490339472105193*^9, 3.4903395234352646`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"Tanh", "[", "x", "]"}], 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Tanh", "[", "x", "]"}], "4"]}]}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellDingbat->None,
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
   3.4443498869285407`*^9}, {3.444349974083864*^9, 3.423171727*^9}, 
   3.423616899578125*^9, {3.455334328146845*^9, 3.455334346853744*^9}, {
   3.455347028589184*^9, 3.4553470351786594`*^9}, {3.455347077739859*^9, 
   3.455347084088989*^9}, {3.455347223879998*^9, 3.4553472252820144`*^9}, {
   3.455347418329603*^9, 3.4553474190906973`*^9}, {3.4553479192198477`*^9, 
   3.4553479280225058`*^9}, {3.455348103234448*^9, 3.4553481049168673`*^9}, 
   3.455348542746435*^9, 3.455394686425475*^9, 3.4554185991202416`*^9, {
   3.4835822694406705`*^9, 3.4835822731560125`*^9}, {3.4835823250506334`*^9, 
   3.4835823270334845`*^9}, {3.4835833246279554`*^9, 3.4835833281129665`*^9}, 
   3.490339381725066*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"Tanh", "[", "x", "]"}], 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Tanh", "[", "x", "]"}], "4"]}]}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellChangeTimes->{3.4553492672882752`*^9, 3.455394687366829*^9, 
  3.4554186004721856`*^9, 3.4835823376387343`*^9, 3.4835833301258607`*^9, 
  3.4903394372651443`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " is able to integrate the expression:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500407697535`*^9}, {3.444350203233365*^9, 3.4443502040245028`*^9}, {
   3.444350234528365*^9, 3.4443502387243986`*^9}, {3.4466836227764835`*^9, 
   3.4466836230168285`*^9}, {3.4466839811618156`*^9, 
   3.4466839896239843`*^9}, {3.4466950433384447`*^9, 3.42301083234375*^9}, 
   3.423171727*^9, 3.423617053328125*^9, {3.4553480765961437`*^9, 
   3.455348092218608*^9}, 3.455349010609189*^9, {3.455418938267912*^9, 
   3.4554189625127745`*^9}, 3.4821983694813375`*^9, {3.483583497927147*^9, 
   3.4835835656545343`*^9}, {3.490328709782093*^9, 3.4903287108120947`*^9}, {
   3.490328751832152*^9, 3.490328756892159*^9}, {3.490339586595353*^9, 
   3.490339605085379*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"tanh", 
      RowBox[{
       RowBox[{"(", "x", ")"}], "/", "sqrt"}], 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "tanh", 
         RowBox[{
          RowBox[{"(", "x", ")"}], "^", "4"}]}]}], ")"}]}], ",", "x"}], 
    ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444350078924618*^9, 3.423171727*^9}, {
   3.4236169183125*^9, 3.423616928921875*^9}, {3.4553480452110147`*^9, 
   3.4553480557261343`*^9}, {3.455348571317518*^9, 3.455348579389125*^9}, {
   3.455348631163573*^9, 3.455348631474019*^9}, {3.455394722427243*^9, 
   3.4553947243399935`*^9}, {3.455418730939789*^9, 3.4554187687842064`*^9}, {
   3.483582575851267*^9, 3.4835825804378624`*^9}, {3.4835828791874433`*^9, 
   3.483582880789747*^9}, {3.483583467152896*^9, 3.483583468805272*^9}, 
   3.490324899816759*^9, {3.490339422665124*^9, 3.4903394345251403`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{"ArcTanh", "[", 
   FractionBox[
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox[
       RowBox[{"Tanh", "[", "x", "]"}], "2"]}]}], 
    RowBox[{
     SqrtBox[
      RowBox[{"a", "+", "b"}]], " ", 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Tanh", "[", "x", "]"}], "4"]}]}]]}]], "]"}], 
  RowBox[{"2", " ", 
   SqrtBox[
    RowBox[{"a", "+", "b"}]]}]]], "Output",
 CellChangeTimes->{{3.4903397202455406`*^9, 3.490339730405555*^9}}]
}, Closed]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Hyperbolic Function Integration Problem 8", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, {3.4821973084456434`*^9, 3.482197309066536*^9}, {
   3.4835046470242352`*^9, 3.483504652301824*^9}, 3.4903386241020036`*^9, 
   3.490339334165*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SqrtBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]], 
    SqrtBox[
     RowBox[{"Cosh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
   3.482197249951533*^9, {3.4835034490416207`*^9, 3.4835034607184114`*^9}, 
   3.4903831406833553`*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " results are symmetric and involve only elementary functions:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.423010751609375*^9}, 3.423171727*^9, {
   3.423617016203125*^9, 3.423617021953125*^9}, {3.4551611708178835`*^9, 
   3.4551611938710318`*^9}, {3.455301288367976*^9, 3.455301294927408*^9}, {
   3.4553019711197248`*^9, 3.4553019988596125`*^9}, 3.482197380439165*^9, 
   3.4826461588227105`*^9, {3.483503527504445*^9, 3.4835035293971663`*^9}, {
   3.4835036083707247`*^9, 3.4835036180246067`*^9}}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   SqrtBox[
    FractionBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], 
     RowBox[{"Cosh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]]], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, 3.455160946845827*^9, 
   3.4553005800394497`*^9, {3.4553007283527136`*^9, 3.455300744445854*^9}, 
   3.4553015748298883`*^9, {3.4553016377503633`*^9, 3.455301670367264*^9}, {
   3.4553017622593985`*^9, 3.455301783189494*^9}, {3.4553018971333375`*^9, 
   3.4553019175827427`*^9}, 3.4553131190196176`*^9, {3.4835034750189743`*^9, 
   3.4835034842722797`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"ArcTan", "[", 
     SqrtBox[
      RowBox[{"Tanh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}]], "]"}], "b"]}], "+", 
  FractionBox[
   RowBox[{"ArcTanh", "[", 
    SqrtBox[
     RowBox[{"Tanh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]], "]"}], "b"]}]], "Output",
 CellChangeTimes->{{3.455301647454317*^9, 3.455301666681965*^9}, 
   3.455301765423949*^9, {3.455301907978933*^9, 3.455301913627054*^9}, 
   3.4835034870662975`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    SqrtBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]], 
    SqrtBox[
     RowBox[{"Cosh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]]], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, 3.455160946845827*^9, 
   3.4553005800394497`*^9, {3.4553007283527136`*^9, 3.455300744445854*^9}, 
   3.4553015748298883`*^9, {3.4553016580996237`*^9, 3.455301673852275*^9}, {
   3.4553017723939714`*^9, 3.4553017799548435`*^9}, {3.4835034973510866`*^9, 
   3.4835035084971137`*^9}, 3.490324903856765*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"ArcTan", "[", 
     FractionBox[
      SqrtBox[
       RowBox[{"Sinh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}]], 
      SqrtBox[
       RowBox[{"Cosh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}]]], "]"}], "b"]}], "+", 
  FractionBox[
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     SqrtBox[
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}]], 
     SqrtBox[
      RowBox[{"Cosh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}]]], "]"}], "b"]}]], "Output",
 CellChangeTimes->{3.4553016274655743`*^9, 3.4553016600023603`*^9, 
  3.455301775388277*^9, 3.483503517149555*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " results",
 StyleBox[" ",
  FontSlant->"Italic"],
 "are not symmetric and involve a hypergeometric function:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500256179667`*^9}, {3.4466836176090527`*^9, 3.446683618790752*^9}, {
   3.4466950388319645`*^9, 3.423171727*^9}, {3.423617028171875*^9, 
   3.4236170379375*^9}, {3.4551611997394705`*^9, 3.455161216653792*^9}, {
   3.4551617691582546`*^9, 3.4551617721625743`*^9}, {3.4553013112408657`*^9, 
   3.4553013170191746`*^9}, {3.4553020145722065`*^9, 
   3.4553020149227104`*^9}, {3.455302056842989*^9, 3.45530206132944*^9}, {
   3.455302100235384*^9, 3.455302117209792*^9}, {3.4553097242381616`*^9, 
   3.455309741523016*^9}, 3.4821976362269697`*^9, 3.4826462100563807`*^9, {
   3.4835035624146433`*^9, 3.483503594460723*^9}, 3.4835036351993027`*^9, {
   3.483504692429525*^9, 3.483504698618424*^9}, {3.483504735471416*^9, 
   3.4835047413999405`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SqrtBox[
    FractionBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], 
     RowBox[{"Cosh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
   3.4443498869285407`*^9}, {3.444349974083864*^9, 3.423171727*^9}, 
   3.423616899578125*^9, 3.4551609499803343`*^9, 3.455300583524461*^9, {
   3.4553007522871294`*^9, 3.455300752978123*^9}, {3.455300906999595*^9, 
   3.4553009429312625`*^9}, 3.45530158289148*^9, {3.45530170272379*^9, 
   3.4553017405682077`*^9}, 3.4553018260811696`*^9, {3.455301928558525*^9, 
   3.455301935698792*^9}, 3.4553020283420067`*^9, {3.4835034997946*^9, 
   3.4835035106001377`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"ArcTan", "[", 
     SqrtBox[
      RowBox[{"Tanh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}]], "]"}], "b"]}], "-", 
  FractionBox[
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SqrtBox[
      RowBox[{"Tanh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}]]}], "]"}], 
   RowBox[{"2", " ", "b"}]], "+", 
  FractionBox[
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", 
     SqrtBox[
      RowBox[{"Tanh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}]]}], "]"}], 
   RowBox[{"2", " ", "b"}]]}]], "Output",
 CellChangeTimes->{{3.455301722021539*^9, 3.4553017430617933`*^9}, 
   3.455302024476448*^9, 3.4835035387005444`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SqrtBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]], 
    SqrtBox[
     RowBox[{"Cosh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
   3.4443498869285407`*^9}, {3.444349974083864*^9, 3.423171727*^9}, 
   3.423616899578125*^9, 3.4551609499803343`*^9, 3.455300583524461*^9, {
   3.4553007522871294`*^9, 3.455300752978123*^9}, {3.455300906999595*^9, 
   3.4553009429312625`*^9}, 3.45530158289148*^9, 3.45530170272379*^9, {
   3.4835035026386895`*^9, 3.483503513213896*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{"Cosh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]], " ", 
    RowBox[{"Hypergeometric2F1", "[", 
     RowBox[{
      FractionBox["1", "4"], ",", 
      FractionBox["1", "4"], ",", 
      FractionBox["5", "4"], ",", 
      SuperscriptBox[
       RowBox[{"Cosh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], 
     RowBox[{"3", "/", "2"}]]}], 
   RowBox[{"b", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"Sinh", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], ")"}], 
     RowBox[{"3", "/", "4"}]]}]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.444349997838021*^9, {3.446683614354373*^9, 3.423171727*^9}, 
   3.4236169960625*^9, 3.4551610636437745`*^9, {3.4553007497534866`*^9, 
   3.455300756983883*^9}, {3.455300917494686*^9, 3.4553009436322703`*^9}, {
   3.4553016974862595`*^9, 3.4553017037753024`*^9}, 3.4835035441483774`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " is able to integrate ",
 Cell[BoxData[
  StyleBox[
   SqrtBox[
    RowBox[{"Tanh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]],
   FontSize->14,
   FontWeight->"Bold"]]],
 " but not ",
 Cell[BoxData[
  StyleBox[
   SqrtBox[
    RowBox[{
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "/", 
     RowBox[{"Cosh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}]],
   FontSize->14,
   FontWeight->"Bold"]]],
 ":"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500407697535`*^9}, {3.444350203233365*^9, 3.4443502040245028`*^9}, {
   3.444350234528365*^9, 3.4443502387243986`*^9}, {3.4466836227764835`*^9, 
   3.4466836230168285`*^9}, {3.4466839811618156`*^9, 
   3.4466839896239843`*^9}, {3.4466950433384447`*^9, 3.42301083234375*^9}, 
   3.423171727*^9, 3.423617053328125*^9, 3.4551612040056047`*^9, {
   3.455161485800806*^9, 3.4551615297640224`*^9}, {3.4551615721750064`*^9, 
   3.4551615749690237`*^9}, {3.4551616579984145`*^9, 
   3.4551617378031683`*^9}, {3.455301326643013*^9, 3.455301334934936*^9}, {
   3.4553042375386753`*^9, 3.45530426199384*^9}, {3.4553043019112387`*^9, 
   3.455304368246624*^9}, {3.455309765777893*^9, 3.455309785766635*^9}, 
   3.4821976753532305`*^9, 3.482646243083872*^9, {3.4835042133606577`*^9, 
   3.483504250203635*^9}, {3.483504300025275*^9, 3.4835043764752045`*^9}, {
   3.4835044139190464`*^9, 3.4835044542570496`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"sqrt", 
      RowBox[{"(", 
       RowBox[{"tanh", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444350078924618*^9, 3.423171727*^9}, {
   3.4236169183125*^9, 3.423616928921875*^9}, {3.455160953425288*^9, 
   3.455160953875936*^9}, {3.4553005931683283`*^9, 3.4553006040339518`*^9}, {
   3.455301589290682*^9, 3.4553016048630733`*^9}, {3.4553021560756783`*^9, 
   3.455302160231654*^9}, {3.4553023310472755`*^9, 3.4553023366453247`*^9}, {
   3.4835036787018557`*^9, 3.4835036818463774`*^9}, 3.4903249044267654`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"ArcTan", "[", 
     SqrtBox[
      RowBox[{"Tanh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}]], "]"}], "b"]}], "-", 
  FractionBox[
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SqrtBox[
      RowBox[{"Tanh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}]]}], "]"}], 
   RowBox[{"2", " ", "b"}]], "+", 
  FractionBox[
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", 
     SqrtBox[
      RowBox[{"Tanh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}]]}], "]"}], 
   RowBox[{"2", " ", "b"}]]}]], "Output",
 CellChangeTimes->{{3.455301722021539*^9, 3.4553017430617933`*^9}, 
   3.455302024476448*^9, 3.4835035387005444`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"sqrt", 
      RowBox[{"(", 
       RowBox[{"sinh", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}], "/", "cosh"}], 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444350078924618*^9, 3.423171727*^9}, {
   3.4236169183125*^9, 3.423616928921875*^9}, {3.455160953425288*^9, 
   3.455160953875936*^9}, {3.4553005931683283`*^9, 3.4553006040339518`*^9}, {
   3.455301589290682*^9, 3.4553016048630733`*^9}, {3.4553021560756783`*^9, 
   3.455302160231654*^9}, {3.455304090126707*^9, 3.455304096906456*^9}, {
   3.483503790262272*^9, 3.4835037979032593`*^9}, {3.4835039925431376`*^9, 
   3.483503996308552*^9}, 3.4903249050167665`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SqrtBox[
    FractionBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], 
     RowBox[{"Cosh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellChangeTimes->{{3.4835039853527985`*^9, 3.4835039853728275`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Maple",
  FontSlant->"Italic"],
 " result involves complex exponentials and an elliptic integral function:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500256179667`*^9}, {3.4466836176090527`*^9, 3.446683618790752*^9}, {
   3.4466950388319645`*^9, 3.423171727*^9}, {3.423617028171875*^9, 
   3.4236170379375*^9}, {3.4551611997394705`*^9, 3.455161216653792*^9}, {
   3.4551617691582546`*^9, 3.4551617721625743`*^9}, {3.4553013112408657`*^9, 
   3.4553013170191746`*^9}, {3.4553020145722065`*^9, 
   3.4553020149227104`*^9}, {3.455302056842989*^9, 3.45530206132944*^9}, {
   3.455302100235384*^9, 3.455302117209792*^9}, {3.4553097242381616`*^9, 
   3.455309741523016*^9}, 3.4821976362269697`*^9, 3.4826462100563807`*^9, {
   3.4835035624146433`*^9, 3.483503594460723*^9}, 3.4835036351993027`*^9, {
   3.483504488115736*^9, 3.483504532820018*^9}, {3.4835045644454927`*^9, 
   3.4835045904729185`*^9}, {3.483504715092112*^9, 3.483504746206853*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"sqrt", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"sinh", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "/", "sqrt"}], 
      RowBox[{"(", 
       RowBox[{"cosh", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444350078924618*^9, 3.423171727*^9}, {
   3.4236169183125*^9, 3.423616928921875*^9}, {3.455160953425288*^9, 
   3.455160953875936*^9}, {3.4553005931683283`*^9, 3.4553006040339518`*^9}, {
   3.455301589290682*^9, 3.4553016048630733`*^9}, {3.4553041973909454`*^9, 
   3.455304203960392*^9}, {3.483504054472187*^9, 3.4835040589085665`*^9}, 
   3.490324905616767*^9, {3.490329729553521*^9, 3.4903297327435255`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"2", "/", "3"}], "/", "b"}], "*", "exp", 
   RowBox[{"(", 
    RowBox[{"a", "+", 
     RowBox[{"b", "*", "x"}]}], ")"}], "*", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"exp", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}]}], "+", "1"}], ")"}], 
    "/", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"exp", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}]}], "+", "1"}], 
        ")"}], "*", "exp", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", 
     RowBox[{"(", 
      RowBox[{"1", "/", "2"}], ")"}]}]}]}], "-", 
  RowBox[{
   RowBox[{"4", "/", "3"}], "*", 
   RowBox[{"I", "/", "b"}], "*", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "I"}], "*", 
      RowBox[{"(", 
       RowBox[{"I", "+", 
        RowBox[{"exp", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}]}]}], ")"}]}], ")"}], "^", 
    RowBox[{"(", 
     RowBox[{"1", "/", "2"}], ")"}]}], "*", 
   RowBox[{"2", "^", 
    RowBox[{"(", 
     RowBox[{"1", "/", "2"}], ")"}]}], "*", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"I", "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "I"}], "+", 
        RowBox[{"exp", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}]}]}], ")"}]}], ")"}], "^", 
    RowBox[{"(", 
     RowBox[{"1", "/", "2"}], ")"}]}], "*", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"I", "*", "exp", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", 
     RowBox[{"(", 
      RowBox[{"1", "/", "2"}], ")"}]}], "/", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"exp", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], "+", 
       RowBox[{"exp", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}], "^", "3"}]}]}], ")"}], "^", 
     RowBox[{"(", 
      RowBox[{"1", "/", "2"}], ")"}]}]}], "*", "EllipticF", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "I"}], "*", 
        RowBox[{"(", 
         RowBox[{"I", "+", 
          RowBox[{"exp", 
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", "x"}]}], ")"}]}]}], ")"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"1", "/", "2"}], "*", 
      RowBox[{"2", "^", 
       RowBox[{"(", 
        RowBox[{"1", "/", "2"}], ")"}]}]}]}], ")"}]}]}]], "Output"]
}, Closed]]
}, Open  ]]
},
AutoGeneratedPackage->None,
CellGrouping->Manual,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  None, None, None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->{{28.8, 28.8}, {14.4, 14.4}}},
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 765, 12, 69, "Title"],
Cell[1335, 36, 781, 19, 68, "Subtitle"],
Cell[CellGroupData[{
Cell[2141, 59, 1393, 22, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[3537, 83, 701, 14, 159, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[4241, 99, 798, 25, 165, "Output"],
Cell[5042, 126, 779, 16, 169, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[5824, 144, 1053, 34, 165, "Output"],
Cell[6880, 180, 835, 17, 169, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[7718, 199, 1518, 49, 165, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[9273, 253, 1341, 21, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[10617, 276, 821, 16, 211, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[11441, 294, 3249, 98, 300, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[14693, 394, 894, 17, 211, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[15590, 413, 1124, 37, 165, "Output"],
Cell[16717, 452, 894, 17, 211, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[17614, 471, 1583, 52, 165, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[19234, 528, 1663, 27, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[20900, 557, 575, 15, 159, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[21478, 574, 1088, 35, 165, "Output"],
Cell[22569, 611, 656, 17, 159, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[23228, 630, 1528, 50, 165, "Output"],
Cell[24759, 682, 656, 17, 159, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[25418, 701, 1961, 64, 165, "Output"]
}, Closed]],
Cell[27394, 768, 16, 0, 26, "Text"],
Cell[27413, 770, 1968, 28, 28, "Subsubtitle"],
Cell[29384, 800, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[29465, 806, 891, 14, 69, "Title"],
Cell[30359, 822, 841, 21, 76, "Subtitle"],
Cell[CellGroupData[{
Cell[31225, 847, 1189, 19, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[32417, 868, 709, 14, 136, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[33129, 884, 1967, 68, 145, "Output"],
Cell[35099, 954, 791, 16, 147, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[35893, 972, 2958, 104, 145, "Output"],
Cell[38854, 1078, 841, 17, 147, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[39698, 1097, 3958, 140, 145, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[43693, 1242, 1339, 21, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[45035, 1265, 789, 16, 139, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[45827, 1283, 15352, 443, 712, "Output"],
Cell[61182, 1728, 739, 16, 147, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[61924, 1746, 3219, 109, 145, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[65146, 1857, 793, 17, 147, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[65942, 1876, 3964, 140, 145, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[69943, 2021, 2141, 41, 41, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[72087, 2064, 605, 16, 102, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[72695, 2082, 1967, 68, 145, "Output"],
Cell[74665, 2152, 687, 18, 102, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[75355, 2172, 410, 11, 109, "Input"],
Cell[75768, 2185, 709, 18, 102, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[76480, 2205, 458, 11, 109, "Input"]
}, Closed]],
Cell[76953, 2219, 16, 0, 26, "Text"],
Cell[76972, 2221, 2012, 28, 28, "Subsubtitle"],
Cell[78987, 2251, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[79068, 2257, 861, 13, 69, "Title"],
Cell[79932, 2272, 863, 23, 68, "Subtitle"],
Cell[CellGroupData[{
Cell[80820, 2299, 1011, 17, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[81834, 2318, 807, 19, 70, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[82644, 2339, 637, 22, 70, "Output"],
Cell[83284, 2363, 755, 18, 70, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[84042, 2383, 754, 24, 70, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Closed]],
Cell[CellGroupData[{
Cell[84833, 2412, 1100, 19, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[85936, 2433, 832, 19, 88, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[86771, 2454, 836, 26, 70, "Output"],
Cell[87610, 2482, 785, 18, 88, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[88398, 2502, 652, 17, 64, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Closed]],
Cell[CellGroupData[{
Cell[89087, 2524, 1340, 22, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[90430, 2548, 673, 19, 66, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[91106, 2569, 337, 11, 64, "Output"],
Cell[91446, 2582, 784, 21, 66, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[92233, 2605, 11127, 343, 202, "Output"]
}, Closed]],
Cell[103375, 2951, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[103456, 2957, 837, 13, 69, "Title"],
Cell[104296, 2972, 815, 18, 66, "Subsection"],
Cell[CellGroupData[{
Cell[105136, 2994, 1206, 20, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[106345, 3016, 711, 14, 44, "Code",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[107059, 3032, 132, 3, 28, "Output"],
Cell[107194, 3037, 709, 14, 44, "Code",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[107906, 3053, 254, 8, 53, "Output"],
Cell[108163, 3063, 739, 15, 47, "Code",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[108905, 3080, 335, 10, 50, "Output"],
Cell[109243, 3092, 787, 15, 47, "Code",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[110033, 3109, 739, 27, 57, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[110809, 3141, 1126, 19, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[111938, 3162, 765, 14, 59, "Code",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[112706, 3178, 183, 4, 30, "Output"],
Cell[112892, 3184, 763, 15, 59, "Code",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[113658, 3201, 2345, 75, 78, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[116006, 3278, 744, 15, 59, "Code",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[116753, 3295, 481, 16, 47, "Output"],
Cell[117237, 3313, 796, 15, 59, "Code",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[118036, 3330, 1515, 45, 57, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[119588, 3380, 1196, 21, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[120787, 3403, 853, 17, 47, "Code",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[121643, 3422, 183, 4, 30, "Output"],
Cell[121829, 3428, 886, 19, 47, "Code",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[122718, 3449, 672, 22, 58, "Output"],
Cell[123393, 3473, 884, 19, 47, "Code",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[124280, 3494, 556, 17, 47, "Output"],
Cell[124839, 3513, 883, 19, 47, "Code",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[125725, 3534, 753, 25, 30, "Output"]
}, Closed]],
Cell[126493, 3562, 16, 0, 26, "Text"],
Cell[126512, 3564, 2012, 28, 28, "Subsubtitle"],
Cell[128527, 3594, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[128608, 3600, 887, 14, 69, "Title"],
Cell[129498, 3616, 1117, 32, 68, "Subtitle"],
Cell[CellGroupData[{
Cell[130640, 3652, 1460, 24, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[132103, 3678, 1167, 25, 177, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[133273, 3705, 634, 21, 189, "Output"],
Cell[133910, 3728, 1299, 28, 177, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[135212, 3758, 1371, 51, 189, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[136620, 3814, 1293, 24, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[137916, 3840, 1296, 27, 211, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[139215, 3869, 1236, 39, 199, "Output"],
Cell[140454, 3910, 1412, 30, 211, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[141869, 3942, 2352, 78, 225, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[144258, 4025, 1305, 22, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[145566, 4049, 1135, 30, 159, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[146704, 4081, 634, 21, 189, "Output"],
Cell[147341, 4104, 1183, 31, 159, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[148527, 4137, 1371, 51, 189, "Output"]
}, Closed]],
Cell[149913, 4191, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[149994, 4197, 889, 14, 69, "Title"],
Cell[150886, 4213, 944, 24, 100, "Subtitle"],
Cell[CellGroupData[{
Cell[151855, 4241, 1440, 24, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[153298, 4267, 1132, 24, 135, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[154433, 4293, 396, 14, 120, "Output"],
Cell[154832, 4309, 1132, 24, 135, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[155967, 4335, 333, 9, 99, "Output"],
Cell[156303, 4346, 1160, 25, 135, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[157466, 4373, 400, 9, 79, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[157903, 4387, 1181, 20, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[159087, 4409, 1244, 25, 117, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[160334, 4436, 999, 33, 118, "Output"],
Cell[161336, 4471, 1242, 25, 117, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[162581, 4498, 206, 7, 87, "Output"],
Cell[162790, 4507, 1424, 28, 117, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[164217, 4537, 2407, 73, 243, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Closed]],
Cell[CellGroupData[{
Cell[166661, 4615, 1773, 37, 54, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[168437, 4654, 1004, 24, 82, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[169444, 4680, 491, 14, 111, "Input"],
Cell[169938, 4696, 1010, 24, 82, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[170951, 4722, 493, 14, 111, "Input"],
Cell[171447, 4738, 1062, 24, 82, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[172512, 4764, 541, 14, 111, "Input"]
}, Closed]],
Cell[173068, 4781, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[173149, 4787, 913, 14, 69, "Title"],
Cell[174065, 4803, 969, 24, 100, "Subtitle"],
Cell[CellGroupData[{
Cell[175059, 4831, 1458, 23, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[176520, 4856, 1157, 24, 110, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[177680, 4882, 577, 20, 96, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[178294, 4907, 1467, 23, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[179764, 4932, 1243, 25, 117, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[181010, 4959, 463, 13, 87, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[181510, 4977, 1325, 22, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[182838, 5001, 1023, 23, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[183864, 5026, 553, 19, 96, "Output"]
}, Closed]],
Cell[184432, 5048, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[184513, 5054, 812, 13, 69, "Title"],
Cell[185328, 5069, 867, 24, 90, "Subtitle"],
Cell[CellGroupData[{
Cell[186220, 5097, 1192, 20, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[187415, 5119, 993, 21, 102, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[188411, 5142, 557, 17, 72, "Output"],
Cell[188971, 5161, 953, 21, 102, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[189927, 5184, 779, 26, 82, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[190743, 5215, 1489, 27, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[192235, 5244, 1013, 22, 102, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[193251, 5268, 797, 27, 73, "Output"],
Cell[194051, 5297, 901, 21, 102, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[194955, 5320, 1259, 36, 81, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Closed]],
Cell[CellGroupData[{
Cell[196251, 5361, 2026, 47, 31, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[198280, 5410, 806, 19, 66, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[199089, 5431, 797, 27, 73, "Output"],
Cell[199889, 5460, 982, 24, 66, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[200874, 5486, 391, 12, 76, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[201302, 5503, 1495, 24, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[202800, 5529, 983, 25, 66, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[203786, 5556, 2913, 104, 70, "Output"]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
