(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    493606,      12615]
NotebookOptionsPosition[    477755,      12257]
NotebookOutlinePosition[    478893,      12297]
CellTagsIndexPosition[    478850,      12294]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SqrtBox[
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4977276071672993`*^9, 3.4984069663016233`*^9, 
   3.4984260380938997`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840715643189*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", 
     RowBox[{"Cos", "[", "z", "]"}]}], "+", 
    RowBox[{"b", " ", 
     RowBox[{"Sin", "[", "z", "]"}]}]}], "=", 
   RowBox[{
    SqrtBox[
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"]}]], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"z", "-", 
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", ",", "b"}], "]"}]}], "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840715643189*^9, {
   3.498407308712103*^9, 3.4984073159621134`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    SqrtBox[
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"]}]], ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, {3.498407084381789*^9, 3.4984070858217907`*^9}, {
   3.498407366552184*^9, 3.498407396032225*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SqrtBox[
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"]}], ")"}], 
      RowBox[{"1", "/", "4"}]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SqrtBox[
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}], "-", 
        RowBox[{"ArcTan", "[", 
         RowBox[{"a", ",", "b"}], "]"}]}], "]"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4977277558667603`*^9, 3.4977279564051123`*^9, {3.49799166209334*^9, 
   3.4979917014678087`*^9}, 3.4984069832816477`*^9, {3.498407170311909*^9, 
   3.498407191491939*^9}, 3.498407224301985*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"a_.", "*", 
       RowBox[{"Cos", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}]}], "+", 
      RowBox[{"b_.", "*", 
       RowBox[{"Sin", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "+", 
        RowBox[{"b", "^", "2"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "4"}], ")"}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}], "-", 
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", ",", "b"}], "]"}]}], "]"}], "]"}], ",", "x"}], 
      "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "+", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", 
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "+", 
       RowBox[{"b", "^", "2"}]}], "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.49799144010495*^9, 3.498406936471582*^9, 3.498407148091878*^9, {
   3.4984307091809063`*^9, 3.498430713424114*^9}, {3.498440023541051*^9, 
   3.4984400271210556`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["\<\
Derivation: Piecewise constant extraction and algebraic simplification\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840715643189*^9, {
   3.4984119516486034`*^9, 3.498411961078616*^9}, {3.4984290446615815`*^9, 
   3.498429057750005*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    FractionBox[
     SqrtBox[
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     SqrtBox[
      FractionBox[
       RowBox[{
        RowBox[{"a", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
       SqrtBox[
        RowBox[{
         SuperscriptBox["a", "2"], "+", 
         SuperscriptBox["b", "2"]}]]]]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840715643189*^9, {
   3.498407308712103*^9, 3.4984073159621134`*^9}, 3.4984075375224237`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"Cos", "[", "z", "]"}]}], "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", "z", "]"}]}]}], 
    SqrtBox[
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"]}]]], "=", 
   RowBox[{"Cos", "[", 
    RowBox[{"z", "-", 
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", ",", "b"}], "]"}]}], "]"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840715643189*^9, {
   3.498407308712103*^9, 3.4984073159621134`*^9}, {3.498408123813244*^9, 
   3.4984081404332676`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{
      SqrtBox[
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"]}]], ">", "0"}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, {3.498407084381789*^9, 3.4984070858217907`*^9}, {
   3.498407366552184*^9, 3.498407396032225*^9}, {3.498407665932603*^9, 
   3.498407668742607*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SqrtBox[
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SqrtBox[
       RowBox[{
        RowBox[{"a", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
      SqrtBox[
       FractionBox[
        RowBox[{
         RowBox[{"a", " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["b", "2"]}]]]]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SqrtBox[
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}], "-", 
        RowBox[{"ArcTan", "[", 
         RowBox[{"a", ",", "b"}], "]"}]}], "]"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4977277558667603`*^9, 3.4977279564051123`*^9, {3.49799166209334*^9, 
   3.4979917014678087`*^9}, 3.4984069832816477`*^9, {3.498407170311909*^9, 
   3.498407191491939*^9}, 3.498407224301985*^9, 3.4984076175825357`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"a_.", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}], ",", "x_Symbol"}], 
    "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{
        RowBox[{"a", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{"b", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"Sqrt", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "*", 
           RowBox[{"Cos", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
          RowBox[{"b", "*", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
        RowBox[{"Sqrt", "[", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "+", 
          RowBox[{"b", "^", "2"}]}], "]"}]}], "]"}]}], "*", "\n", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}], "-", 
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", ",", "b"}], "]"}]}], "]"}], "]"}], ",", "x"}], 
      "]"}]}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}],
      " ", "&&", " ", 
     RowBox[{"NonzeroQ", "[", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "+", 
       RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
     RowBox[{"Not", "[", 
      RowBox[{"PositiveQ", "[", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "+", 
         RowBox[{"b", "^", "2"}]}], "]"}], "]"}], "]"}]}]}]}], " ", 
  "*)"}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.49799144010495*^9, 3.498406936471582*^9, 3.498407148091878*^9, 
   3.498407558302452*^9, {3.49840825619343*^9, 3.4984082574634314`*^9}, {
   3.4984307171681204`*^9, 3.4984307208497267`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{
      RowBox[{"a", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4977276071672993`*^9, 3.4984069663016233`*^9, 
   3.498426114097233*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840715643189*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", 
     RowBox[{"Cos", "[", "z", "]"}]}], "+", 
    RowBox[{"b", " ", 
     RowBox[{"Sin", "[", "z", "]"}]}]}], "=", 
   RowBox[{
    SqrtBox[
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"]}]], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"z", "-", 
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", ",", "b"}], "]"}]}], "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840715643189*^9, {
   3.498407308712103*^9, 3.4984073159621134`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    SqrtBox[
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"]}]], ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, {3.498407084381789*^9, 3.4984070858217907`*^9}, {
   3.498407366552184*^9, 3.498407396032225*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{
      RowBox[{"a", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["a", "2"], "+", 
         SuperscriptBox["b", "2"]}], ")"}], 
       RowBox[{"1", "/", "4"}]]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      SqrtBox[
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}], "-", 
         RowBox[{"ArcTan", "[", 
          RowBox[{"a", ",", "b"}], "]"}]}], "]"}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4977277558667603`*^9, 3.4977279564051123`*^9, {3.49799166209334*^9, 
   3.4979917014678087`*^9}, 3.4984069832816477`*^9, {3.498407170311909*^9, 
   3.498407191491939*^9}, 3.498407224301985*^9, {3.498408303283496*^9, 
   3.498408311893508*^9}, 3.498408343353552*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"a_.", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "+", 
         RowBox[{"b", "^", "2"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"1", "/", "4"}], ")"}]}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}], "-", 
           RowBox[{"ArcTan", "[", 
            RowBox[{"a", ",", "b"}], "]"}]}], "]"}], "]"}]}], ",", "x"}], 
      "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "+", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", 
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "+", 
       RowBox[{"b", "^", "2"}]}], "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.49799144010495*^9, 3.498406936471582*^9, 3.498407148091878*^9, 
   3.4984082974134874`*^9, {3.4984307284469404`*^9, 3.498430732144147*^9}, {
   3.4984400463810825`*^9, 3.498440049331087*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["\<\
Derivation: Piecewise constant extraction and algebraic simplification\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840715643189*^9, {
   3.4984119516486034`*^9, 3.498411961078616*^9}, {3.4984290446615815`*^9, 
   3.498429057750005*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    FractionBox[
     SqrtBox[
      FractionBox[
       RowBox[{
        RowBox[{"a", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
       SqrtBox[
        RowBox[{
         SuperscriptBox["a", "2"], "+", 
         SuperscriptBox["b", "2"]}]]]], 
     SqrtBox[
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840715643189*^9, {
   3.498407308712103*^9, 3.4984073159621134`*^9}, 3.4984075375224237`*^9, 
   3.498408444353693*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"Cos", "[", "z", "]"}]}], "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", "z", "]"}]}]}], 
    SqrtBox[
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"]}]]], "=", 
   RowBox[{"Cos", "[", 
    RowBox[{"z", "-", 
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", ",", "b"}], "]"}]}], "]"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840715643189*^9, {
   3.498407308712103*^9, 3.4984073159621134`*^9}, {3.498408123813244*^9, 
   3.4984081404332676`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{
      SqrtBox[
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"]}]], ">", "0"}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, {3.498407084381789*^9, 3.4984070858217907`*^9}, {
   3.498407366552184*^9, 3.498407396032225*^9}, {3.498407665932603*^9, 
   3.498407668742607*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{
      RowBox[{"a", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SqrtBox[
       FractionBox[
        RowBox[{
         RowBox[{"a", " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["b", "2"]}]]]], 
      SqrtBox[
       RowBox[{
        RowBox[{"a", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      SqrtBox[
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}], "-", 
         RowBox[{"ArcTan", "[", 
          RowBox[{"a", ",", "b"}], "]"}]}], "]"}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4977277558667603`*^9, 3.4977279564051123`*^9, {3.49799166209334*^9, 
   3.4979917014678087`*^9}, 3.4984069832816477`*^9, {3.498407170311909*^9, 
   3.498407191491939*^9}, 3.498407224301985*^9, 3.4984076175825357`*^9, 
   3.498408318013516*^9, 3.498408417443655*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"Sqrt", "[", 
       RowBox[{
        RowBox[{"a_.", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}], "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ",", 
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "*", 
           RowBox[{"Cos", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
          RowBox[{"b", "*", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
        RowBox[{"Sqrt", "[", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "+", 
          RowBox[{"b", "^", "2"}]}], "]"}]}], "]"}], "/", 
      RowBox[{"Sqrt", "[", 
       RowBox[{
        RowBox[{"a", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{"b", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], "*", "\n", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}], "-", 
           RowBox[{"ArcTan", "[", 
            RowBox[{"a", ",", "b"}], "]"}]}], "]"}], "]"}]}], ",", "x"}], 
      "]"}]}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}],
      " ", "&&", " ", 
     RowBox[{"NonzeroQ", "[", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "+", 
       RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
     RowBox[{"Not", "[", 
      RowBox[{"PositiveQ", "[", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "+", 
         RowBox[{"b", "^", "2"}]}], "]"}], "]"}], "]"}]}]}]}], " ", 
  "*)"}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.49799144010495*^9, 3.498406936471582*^9, 3.498407148091878*^9, 
   3.498407558302452*^9, {3.49840825619343*^9, 3.4984082574634314`*^9}, 
   3.498408289243476*^9, {3.498408384373609*^9, 3.498408394873624*^9}, {
   3.4984307359349537`*^9, 3.49843073969456*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4977276071672993`*^9, 3.4984069663016233`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    SuperscriptBox["b", "2"]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"a", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", " ", 
           RowBox[{"Cos", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"]}], 
      RowBox[{"b", " ", "d", " ", "n"}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, {3.4984069748816357`*^9, 
   3.498407000051671*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a_.", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"a", "*", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{"b", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
     RowBox[{"(", 
      RowBox[{"b", "*", "d", "*", "n"}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "+", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.557.5b'", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, {3.498407084381789*^9, 3.4984070858217907`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "2"]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"a", " ", "d", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
        ")"}]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4977277558667603`*^9, 3.4977279564051123`*^9, 3.4984069789216413`*^9, {
   3.4984071019718137`*^9, 3.498407129841853*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a_.", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}], "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "2"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", "*", "x"}]}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"a", "*", "d", "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{"b", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}], ")"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "+", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.4984069410415883`*^9, 3.4984070532617455`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.557'", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840715643189*^9, {
   3.4984080275931096`*^9, 3.4984080381531243`*^9}, 3.498408571803871*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840715643189*^9, {
   3.498407308712103*^9, 3.4984073159621134`*^9}, {3.498408123813244*^9, 
   3.4984081404332676`*^9}, 3.4984085798438826`*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"n", "-", "1"}], "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", " ", 
       RowBox[{"Cos", "[", "z", "]"}]}], "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", "z", "]"}]}]}], ")"}], "n"], "=", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "2"], "+", 
       SuperscriptBox["b", "2"], "-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "b"}], " ", 
           RowBox[{"Cos", "[", "z", "]"}]}], "+", 
          RowBox[{"a", " ", 
           RowBox[{"Sin", "[", "z", "]"}]}]}], ")"}], "2"]}], ")"}], 
     FractionBox[
      RowBox[{"n", "-", "1"}], "2"]], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", "z"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "b"}], " ", 
        RowBox[{"Cos", "[", "z", "]"}]}], "+", 
       RowBox[{"a", " ", 
        RowBox[{"Sin", "[", "z", "]"}]}]}], ")"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840715643189*^9, {
   3.498407308712103*^9, 3.4984073159621134`*^9}, 3.4984075375224237`*^9, 
   3.498408444353693*^9, {3.498408614743932*^9, 3.4984087206640797`*^9}}],

Cell[TextData[{
 "Note: Should this rule also be used for odd ",
 Cell[BoxData[
  RowBox[{"n", "<", "0"}]]],
 "?"
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840715643189*^9, {
   3.498407308712103*^9, 3.4984073159621134`*^9}, {3.498408123813244*^9, 
   3.4984081404332676`*^9}, 3.4984085798438826`*^9, {3.4984088766342983`*^9, 
   3.4984089404943876`*^9}, {3.498430516249367*^9, 3.4984305272317867`*^9}, {
   3.498430561255446*^9, 3.4984306247691584`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    FractionBox[
     RowBox[{"n", "-", "1"}], "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}],
    " ", "\[And]", " ", 
   RowBox[{"n", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, {3.498407084381789*^9, 3.4984070858217907`*^9}, {
   3.498407366552184*^9, 3.498407396032225*^9}, {3.498407665932603*^9, 
   3.498407668742607*^9}, {3.4984088091142035`*^9, 3.498408832034236*^9}, {
   3.4984092350248003`*^9, 3.498409243874812*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "d"]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"Int", "[", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["x", "2"]}], ")"}], 
        FractionBox[
         RowBox[{"n", "-", "1"}], "2"]], ",", "x"}], "]"}], ",", "x", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "b"}], " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"a", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4977277558667603`*^9, 3.4977279564051123`*^9, {3.49799166209334*^9, 
   3.4979917014678087`*^9}, 3.4984069832816477`*^9, {3.498407170311909*^9, 
   3.498407191491939*^9}, 3.498407224301985*^9, 3.4984076175825357`*^9, 
   3.498408318013516*^9, 3.498408417443655*^9, {3.4984085291138115`*^9, 
   3.498408550203841*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a_.", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", "d"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", "^", "2"}], "+", 
              RowBox[{"b", "^", "2"}], "-", 
              RowBox[{"x", "^", "2"}]}], ")"}], "^", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"n", "-", "1"}], ")"}], "/", "2"}], ")"}]}], ",", 
           "x"}], "]"}], ",", "x"}], "]"}], ",", "x", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "b"}], "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{"a", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}]}], "]"}]}], "]"}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "+", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"OddQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.49799144010495*^9, 3.498406936471582*^9, 3.498407148091878*^9, 
   3.498407558302452*^9, {3.49840825619343*^9, 3.4984082574634314`*^9}, 
   3.498408289243476*^9, {3.498408384373609*^9, 3.498408394873624*^9}, 
   3.498408503433776*^9, {3.498409179804723*^9, 3.4984091820947256`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts with a double-back flip", \
"Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840715643189*^9, {
   3.498407308712103*^9, 3.4984073159621134`*^9}, {3.498408123813244*^9, 
   3.4984081404332676`*^9}, 3.4984085798438826`*^9, 3.4984090455045347`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{
    FractionBox[
     RowBox[{"n", "-", "1"}], "2"], "\[NotElement]", 
    "\[DoubleStruckCapitalZ]"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, {3.498407084381789*^9, 3.4984070858217907`*^9}, {
   3.498407366552184*^9, 3.498407396032225*^9}, {3.498407665932603*^9, 
   3.498407668742607*^9}, {3.4984088091142035`*^9, 3.498408832034236*^9}, {
   3.498409100964612*^9, 3.4984091377146635`*^9}, {3.4984092061447597`*^9, 
   3.498409224474785*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", " ", 
            RowBox[{"Cos", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}]}], "-", 
           RowBox[{"a", " ", 
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"a", " ", 
             RowBox[{"Cos", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
            RowBox[{"b", " ", 
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
          RowBox[{"n", "-", "1"}]]}], 
        RowBox[{"d", " ", "n"}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "-", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "2"], "+", 
       SuperscriptBox["b", "2"]}], ")"}]}], "n"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4977277558667603`*^9, 3.4977279564051123`*^9, {3.49799166209334*^9, 
   3.4979917014678087`*^9}, 3.4984069832816477`*^9, {3.498407170311909*^9, 
   3.498407191491939*^9}, 3.498407224301985*^9, 3.4984076175825357`*^9, 
   3.498408318013516*^9, 3.498408417443655*^9, {3.4984085291138115`*^9, 
   3.498408550203841*^9}, {3.4984090747245755`*^9, 3.4984090856145906`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a_.", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}], "-", 
        RowBox[{"a", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
         RowBox[{"b", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", "n"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "+", 
          RowBox[{"b", "^", "2"}]}], ")"}], "/", "n"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "*", 
            RowBox[{"Cos", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
           RowBox[{"b", "*", 
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "-", "2"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "+", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"OddQ", "[", "n", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.49799144010495*^9, 3.498406936471582*^9, 3.498407148091878*^9, 
   3.498407558302452*^9, {3.49840825619343*^9, 3.4984082574634314`*^9}, 
   3.498408289243476*^9, {3.498408384373609*^9, 3.498408394873624*^9}, 
   3.498408503433776*^9, 3.498409040004527*^9, {3.4984091896547365`*^9, 
   3.4984091920747395`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts with a double-back flip", \
"Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840715643189*^9, {
   3.498407308712103*^9, 3.4984073159621134`*^9}, {3.498408123813244*^9, 
   3.4984081404332676`*^9}, 3.4984085798438826`*^9, 3.4984090455045347`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"n", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{"n", "\[NotEqual]", 
    RowBox[{"-", "2"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, {3.498407084381789*^9, 3.4984070858217907`*^9}, {
   3.498407366552184*^9, 3.498407396032225*^9}, {3.498407665932603*^9, 
   3.498407668742607*^9}, {3.4984088091142035`*^9, 3.498408832034236*^9}, {
   3.498409100964612*^9, 3.4984091377146635`*^9}, {3.4984092061447597`*^9, 
   3.498409224474785*^9}, {3.498409331944936*^9, 3.4984093558649693`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", 
           RowBox[{"Cos", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}], "-", 
          RowBox[{"a", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", " ", 
            RowBox[{"Cos", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
           RowBox[{"b", " ", 
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"d", " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["b", "2"]}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"n", "+", "2"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "2"], "+", 
       SuperscriptBox["b", "2"]}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "+", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4977277558667603`*^9, 3.4977279564051123`*^9, {3.49799166209334*^9, 
   3.4979917014678087`*^9}, 3.4984069832816477`*^9, {3.498407170311909*^9, 
   3.498407191491939*^9}, 3.498407224301985*^9, 3.4984076175825357`*^9, 
   3.498408318013516*^9, 3.498408417443655*^9, {3.4984085291138115`*^9, 
   3.498408550203841*^9}, {3.4984090747245755`*^9, 3.4984090856145906`*^9}, {
   3.4984094277950697`*^9, 3.4984094332350774`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a_.", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}]}], "-", 
       RowBox[{"a", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
         RowBox[{"b", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "+", 
          RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "+", "2"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "*", 
            RowBox[{"Cos", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
           RowBox[{"b", "*", 
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "+", "2"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "+", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.49799144010495*^9, 3.498406936471582*^9, 3.498407148091878*^9, 
   3.498407558302452*^9, {3.49840825619343*^9, 3.4984082574634314`*^9}, 
   3.498408289243476*^9, {3.498408384373609*^9, 3.498408394873624*^9}, 
   3.498408503433776*^9, 3.498409040004527*^9, {3.4984091896547365`*^9, 
   3.4984091920747395`*^9}, 3.49840932049492*^9, {3.498409367134985*^9, 
   3.4984094068150406`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "n"]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "p"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4977276071672993`*^9, 3.4984069663016233`*^9, 
   3.498410054215947*^9, {3.498411097837408*^9, 3.498411111517427*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, 
   3.4984100946360035`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"Cos", "[", "z", "]"}], " ", 
     RowBox[{"Sin", "[", "z", "]"}]}], 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"Cos", "[", "z", "]"}]}], "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", "z", "]"}]}]}]], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"b", " ", 
      RowBox[{"Cos", "[", "z", "]"}]}], 
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"]}]], "+", 
    FractionBox[
     RowBox[{"a", " ", 
      RowBox[{"Sin", "[", "z", "]"}]}], 
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"]}]], "-", 
    FractionBox[
     RowBox[{"a", " ", "b"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", 
         RowBox[{"Cos", "[", "z", "]"}]}], "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", "z", "]"}]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.4984101039160166`*^9, 3.4984101154860325`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    "m"}], ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"m", ">", "0"}], " ", "\[And]", " ", 
    RowBox[{"n", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, {3.4984102666962442`*^9, 3.4984103177763157`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "m"], " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "n"]}], 
     RowBox[{
      RowBox[{"a", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["b", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"]}]]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "m"], " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"n", "-", "1"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", "                   ", 
  "\[IndentingNewLine]", "                       ", 
  RowBox[{
   FractionBox["a", 
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"m", "-", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", "b"}], 
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"m", "-", "1"}]], " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"n", "-", "1"}]]}], 
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, {3.4984069748816357`*^9, 
   3.498407000051671*^9}, {3.498410167126105*^9, 3.4984101905161376`*^9}, 
   3.4984102469362164`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "m_."}], "*", 
      RowBox[{
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "n_."}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a_.", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}], "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}]}], ",", 
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{"Dist", "[", 
      RowBox[{
       RowBox[{"b", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "+", 
          RowBox[{"b", "^", "2"}]}], ")"}]}], ",", 
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"Cos", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "m"}], "*", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", 
           RowBox[{"(", 
            RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
     " ", "+", "\n", "  ", 
     RowBox[{"Dist", "[", 
      RowBox[{
       RowBox[{"a", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "+", 
          RowBox[{"b", "^", "2"}]}], ")"}]}], ",", 
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"Cos", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", 
           RowBox[{"(", 
            RowBox[{"m", "-", "1"}], ")"}]}], "*", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "n"}]}], ",", "x"}], 
        "]"}]}], "]"}], " ", "-", "\n", "  ", 
     RowBox[{"Dist", "[", 
      RowBox[{
       RowBox[{"a", "*", 
        RowBox[{"b", "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}]}], ")"}]}]}], ",", 
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"Cos", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", 
           RowBox[{"(", 
            RowBox[{"m", "-", "1"}], ")"}]}], "*", 
          RowBox[{
           RowBox[{
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", 
            RowBox[{"(", 
             RowBox[{"n", "-", "1"}], ")"}]}], "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"a", "*", 
              RowBox[{"Cos", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
             RowBox[{"b", "*", 
              RowBox[{"Sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}]}], ",", "x"}], 
        "]"}]}], "]"}]}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}],
      " ", "&&", " ", 
     RowBox[{"NonzeroQ", "[", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "+", 
       RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
     RowBox[{"IntegersQ", "[", 
      RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
     RowBox[{"m", ">", "0"}], " ", "&&", " ", 
     RowBox[{"n", ">", "0"}]}]}]}], " ", "*)"}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.4984100704359694`*^9, {
   3.5171914068643527`*^9, 3.5171914097971582`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, 
   3.4984100946360035`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"Cos", "[", "z", "]"}], " ", 
     RowBox[{"Sin", "[", "z", "]"}]}], 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"Cos", "[", "z", "]"}]}], "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", "z", "]"}]}]}]], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"b", " ", 
      RowBox[{"Cos", "[", "z", "]"}]}], 
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"]}]], "+", 
    FractionBox[
     RowBox[{"a", " ", 
      RowBox[{"Sin", "[", "z", "]"}]}], 
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"]}]], "-", 
    FractionBox[
     RowBox[{"a", " ", "b"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", 
         RowBox[{"Cos", "[", "z", "]"}]}], "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", "z", "]"}]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.4984101039160166`*^9, 3.4984101154860325`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    "m"}], ",", "n", ",", 
   RowBox[{
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"m", ">", "0"}], " ", "\[And]", " ", 
    RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
    RowBox[{"p", "<", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, {3.4984102666962442`*^9, 3.4984103177763157`*^9}, {
   3.4984104860765514`*^9, 3.498410498076568*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], "n"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                        ", "\[IndentingNewLine]", 
      FractionBox["b", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"]}]]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "m"], " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"n", "-", "1"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       RowBox[{"p", "+", "1"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["a", 
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"m", "-", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "n"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"p", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "-", "\[IndentingNewLine]", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", "b"}], 
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"m", "-", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"n", "-", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "p"], 
     RowBox[{"\[DifferentialD]", "x", "    "}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4977277558667603`*^9, 3.4977279564051123`*^9, 3.4984069789216413`*^9, {
   3.4984071019718137`*^9, 3.498407129841853*^9}, {3.498410455476508*^9, 
   3.4984104647165213`*^9}, {3.4984105235166035`*^9, 3.49841057792668*^9}, {
   3.4984106125167284`*^9, 3.498410613026729*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "n_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a_.", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}], "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "p_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "+", 
         RowBox[{"b", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Cos", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"a", "*", 
             RowBox[{"Cos", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
            RowBox[{"b", "*", 
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "+", 
         RowBox[{"b", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Cos", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "n"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"a", "*", 
             RowBox[{"Cos", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
            RowBox[{"b", "*", 
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"b", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "+", 
          RowBox[{"b", "^", "2"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Cos", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"a", "*", 
             RowBox[{"Cos", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
            RowBox[{"b", "*", 
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "p"}]}], ",",
         "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "+", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n", ",", "p"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"p", "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.4984069410415883`*^9, 3.4984070532617455`*^9, 3.4984103491363597`*^9, {
   3.5171914544132366`*^9, 3.517191457158841*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, 
   3.4984100946360035`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"Sin", "[", "z", "]"}], "2"], 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"Cos", "[", "z", "]"}]}], "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", "z", "]"}]}]}]], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", "z", "]"}]}], 
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"]}]], "-", 
    FractionBox[
     RowBox[{"a", " ", 
      RowBox[{"Cos", "[", "z", "]"}]}], 
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"]}]], "+", 
    FractionBox[
     SuperscriptBox["a", "2"], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", 
         RowBox[{"Cos", "[", "z", "]"}]}], "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", "z", "]"}]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.4984101039160166`*^9, 3.4984101154860325`*^9}, 3.498410679376822*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, {3.4984102666962442`*^9, 3.4984103177763157`*^9}, {
   3.4984104860765514`*^9, 3.498410498076568*^9}, {3.498410785486971*^9, 
   3.498410809287004*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"u", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "n"]}], 
     RowBox[{
      RowBox[{"a", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["b", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"]}]]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{"u", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"n", "-", "1"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["a", 
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{"u", " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"n", "-", "2"}]], " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    SuperscriptBox["a", "2"], 
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"u", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"n", "-", "2"}]]}], 
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4977277558667603`*^9, 3.4977279564051123`*^9, 3.4984069789216413`*^9, {
   3.4984071019718137`*^9, 3.498407129841853*^9}, {3.498410455476508*^9, 
   3.4984104647165213`*^9}, {3.4984105235166035`*^9, 3.49841057792668*^9}, {
   3.4984106125167284`*^9, 3.498410613026729*^9}, {3.4984107356169004`*^9, 
   3.498410762106938*^9}, {3.498410847287057*^9, 3.4984108895871162`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "n_."}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a_.", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}], "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "+", 
         RowBox[{"b", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"u", "*", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "+", 
         RowBox[{"b", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"u", "*", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}], "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "+", 
         RowBox[{"b", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"u", "*", 
         RowBox[{
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", 
           RowBox[{"(", 
            RowBox[{"n", "-", "2"}], ")"}]}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"a", "*", 
             RowBox[{"Cos", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
            RowBox[{"b", "*", 
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "+", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", "\n", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", ">", "1"}], " ", "||", " ", 
      RowBox[{"MatchQ", "[", 
       RowBox[{"u", ",", 
        RowBox[{
         RowBox[{"v_.", "*", 
          RowBox[{
           RowBox[{"Tan", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "m_."}]}], " ", "/;", " ", 
         RowBox[{
          RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
          RowBox[{"m", ">", "0"}]}]}]}], "]"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.4984069410415883`*^9, 3.4984070532617455`*^9, 3.4984103491363597`*^9, 
   3.4984106537567863`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, 
   3.4984100946360035`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"Cos", "[", "z", "]"}], "2"], 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"Cos", "[", "z", "]"}]}], "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", "z", "]"}]}]}]], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"a", " ", 
      RowBox[{"Cos", "[", "z", "]"}]}], 
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"]}]], "-", 
    FractionBox[
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", "z", "]"}]}], 
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"]}]], "+", 
    FractionBox[
     SuperscriptBox["b", "2"], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", 
         RowBox[{"Cos", "[", "z", "]"}]}], "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", "z", "]"}]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.4984101039160166`*^9, 3.4984101154860325`*^9}, 3.498410679376822*^9, 
   3.4984109291771717`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, {3.4984102666962442`*^9, 3.4984103177763157`*^9}, {
   3.4984104860765514`*^9, 3.498410498076568*^9}, {3.498410785486971*^9, 
   3.498410809287004*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"u", " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "n"]}], 
     RowBox[{
      RowBox[{"a", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["a", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"]}]]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{"u", " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"n", "-", "1"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["b", 
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{"u", " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"n", "-", "2"}]], " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    SuperscriptBox["b", "2"], 
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"u", " ", 
       SuperscriptBox[
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"n", "-", "2"}]]}], 
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4977277558667603`*^9, 3.4977279564051123`*^9, 3.4984069789216413`*^9, {
   3.4984071019718137`*^9, 3.498407129841853*^9}, {3.498410455476508*^9, 
   3.4984104647165213`*^9}, {3.4984105235166035`*^9, 3.49841057792668*^9}, {
   3.4984106125167284`*^9, 3.498410613026729*^9}, {3.4984107356169004`*^9, 
   3.498410762106938*^9}, {3.498410847287057*^9, 3.4984108895871162`*^9}, {
   3.498410989107256*^9, 3.4984110005472717`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "n_."}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a_.", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}], "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "+", 
         RowBox[{"b", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"u", "*", 
         RowBox[{
          RowBox[{"Cos", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "+", 
         RowBox[{"b", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"u", "*", 
         RowBox[{
          RowBox[{"Cos", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "+", 
         RowBox[{"b", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"u", "*", 
         RowBox[{
          RowBox[{
           RowBox[{"Cos", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", 
           RowBox[{"(", 
            RowBox[{"n", "-", "2"}], ")"}]}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"a", "*", 
             RowBox[{"Cos", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
            RowBox[{"b", "*", 
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "+", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", "\n", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", ">", "1"}], " ", "||", " ", 
      RowBox[{"MatchQ", "[", 
       RowBox[{"u", ",", 
        RowBox[{
         RowBox[{"v_.", "*", 
          RowBox[{
           RowBox[{"Cot", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "m_."}]}], " ", "/;", " ", 
         RowBox[{
          RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
          RowBox[{"m", ">", "0"}]}]}]}], "]"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.4984069410415883`*^9, 3.4984070532617455`*^9, 3.4984103491363597`*^9, 
   3.4984106537567863`*^9, 3.498410935707181*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, 
   3.4984100946360035`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"Sec", "[", "z", "]"}], 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"Cos", "[", "z", "]"}]}], "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", "z", "]"}]}]}]], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"Tan", "[", "z", "]"}], "b"], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"b", " ", 
       RowBox[{"Cos", "[", "z", "]"}]}], "-", 
      RowBox[{"a", " ", 
       RowBox[{"Sin", "[", "z", "]"}]}]}], 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", 
         RowBox[{"Cos", "[", "z", "]"}]}], "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", "z", "]"}]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.4984101039160166`*^9, 3.4984101154860325`*^9}, 3.498410679376822*^9, 
   3.4984109291771717`*^9, 3.498411187087533*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, {3.4984102666962442`*^9, 3.4984103177763157`*^9}, {
   3.4984104860765514`*^9, 3.498410498076568*^9}, {3.498410785486971*^9, 
   3.498410809287004*^9}, 3.4984112418476095`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"u", " ", 
      RowBox[{"Sec", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}], 
     RowBox[{
      RowBox[{"a", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "b"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{"u", " ", 
      RowBox[{"Tan", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", "b"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"u", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}], "-", 
         RowBox[{"a", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}]}], 
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4977277558667603`*^9, 3.4977279564051123`*^9, 3.4984069789216413`*^9, {
   3.4984071019718137`*^9, 3.498407129841853*^9}, {3.498410455476508*^9, 
   3.4984104647165213`*^9}, {3.4984105235166035`*^9, 3.49841057792668*^9}, {
   3.4984106125167284`*^9, 3.498410613026729*^9}, {3.4984107356169004`*^9, 
   3.498410762106938*^9}, {3.498410847287057*^9, 3.4984108895871162`*^9}, {
   3.498410989107256*^9, 3.4984110005472717`*^9}, {3.498411228577591*^9, 
   3.498411254067627*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"u_.", "*", 
      RowBox[{
       RowBox[{"Sec", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a_.", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}], "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}]}], ",", 
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{"Dist", "[", 
      RowBox[{
       RowBox[{"1", "/", "b"}], ",", 
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"u", "*", 
          RowBox[{"Tan", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}], ",", "x"}], "]"}]}], "]"}], 
     " ", "+", " ", "\n", "  ", 
     RowBox[{"Dist", "[", 
      RowBox[{
       RowBox[{"1", "/", "b"}], ",", 
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"u", "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"b", "*", 
              RowBox[{"Cos", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}]}], "-", 
             RowBox[{"a", "*", 
              RowBox[{"Sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"a", "*", 
              RowBox[{"Cos", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
             RowBox[{"b", "*", 
              RowBox[{"Sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}]}], ",", "x"}], 
        "]"}]}], "]"}]}], " ", "/;", "\n", 
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], 
     "]"}]}]}], " ", "*)"}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.4984069410415883`*^9, 3.4984070532617455`*^9, 3.4984103491363597`*^9, 
   3.4984106537567863`*^9, 3.498410935707181*^9, 3.498411194357543*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, 
   3.4984100946360035`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"Csc", "[", "z", "]"}], 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"Cos", "[", "z", "]"}]}], "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", "z", "]"}]}]}]], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"Cot", "[", "z", "]"}], "a"], "-", 
    FractionBox[
     RowBox[{
      RowBox[{"b", " ", 
       RowBox[{"Cos", "[", "z", "]"}]}], "-", 
      RowBox[{"a", " ", 
       RowBox[{"Sin", "[", "z", "]"}]}]}], 
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", 
         RowBox[{"Cos", "[", "z", "]"}]}], "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", "z", "]"}]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.4984101039160166`*^9, 3.4984101154860325`*^9}, 3.498410679376822*^9, 
   3.4984109291771717`*^9, 3.498411187087533*^9, 3.498411310477706*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, {3.4984102666962442`*^9, 3.4984103177763157`*^9}, {
   3.4984104860765514`*^9, 3.498410498076568*^9}, {3.498410785486971*^9, 
   3.498410809287004*^9}, 3.4984112418476095`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"u", " ", 
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}], 
     RowBox[{
      RowBox[{"a", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "a"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{"u", " ", 
      RowBox[{"Cot", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", "a"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"u", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}], "-", 
         RowBox[{"a", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}]}], 
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4977277558667603`*^9, 3.4977279564051123`*^9, 3.4984069789216413`*^9, {
   3.4984071019718137`*^9, 3.498407129841853*^9}, {3.498410455476508*^9, 
   3.4984104647165213`*^9}, {3.4984105235166035`*^9, 3.49841057792668*^9}, {
   3.4984106125167284`*^9, 3.498410613026729*^9}, {3.4984107356169004`*^9, 
   3.498410762106938*^9}, {3.498410847287057*^9, 3.4984108895871162`*^9}, {
   3.498410989107256*^9, 3.4984110005472717`*^9}, {3.498411228577591*^9, 
   3.498411254067627*^9}, {3.498411315587713*^9, 3.4984113456477547`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"u_.", "*", 
      RowBox[{
       RowBox[{"Csc", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a_.", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}], "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}]}], ",", 
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{"Dist", "[", 
      RowBox[{
       RowBox[{"1", "/", "a"}], ",", 
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"u", "*", 
          RowBox[{"Cot", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}], ",", "x"}], "]"}]}], "]"}], 
     " ", "-", " ", "\n", "  ", 
     RowBox[{"Dist", "[", 
      RowBox[{
       RowBox[{"1", "/", "a"}], ",", 
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"u", "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"b", "*", 
              RowBox[{"Cos", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}]}], "-", 
             RowBox[{"a", "*", 
              RowBox[{"Sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"a", "*", 
              RowBox[{"Cos", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
             RowBox[{"b", "*", 
              RowBox[{"Sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}]}], ",", "x"}], 
        "]"}]}], "]"}]}], " ", "/;", "\n", 
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], 
     "]"}]}]}], " ", "*)"}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.4984069410415883`*^9, 3.4984070532617455`*^9, 3.4984103491363597`*^9, 
   3.4984106537567863`*^9, 3.498410935707181*^9, 3.498411194357543*^9, 
   3.4984112987276893`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
     RowBox[{"c", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4977276071672993`*^9, 3.4984069663016233`*^9, 
   3.498411414357851*^9, {3.498412682319626*^9, 3.498412691479639*^9}, {
   3.4984165433450317`*^9, 3.49841654935504*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.558.4c", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "-", "b"}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, 3.498411508837983*^9, {3.4984155639236603`*^9, 
   3.4984155645936613`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
     RowBox[{"c", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      RowBox[{"c", " ", "e"}]]}]}], 
   RowBox[{"Log", "[", 
    RowBox[{"a", "+", 
     RowBox[{"c", " ", 
      RowBox[{"Tan", "[", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], ")"}]}], "]"}]}]}], 
    "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, {3.4984069748816357`*^9, 
   3.498407000051671*^9}, {3.4984115253180065`*^9, 3.4984115658380632`*^9}, 
   3.4984117446983137`*^9, {3.4984157332238975`*^9, 3.49841574918392*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"a", "+", 
      RowBox[{"c", "*", 
       RowBox[{"Tan", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], ")"}], "/", "2"}], "]"}]}]}], "]"}], 
    "/", 
    RowBox[{"(", 
     RowBox[{"c", "*", "e"}], ")"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"a", "-", "b"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.558.4c", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", "b"}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, 3.498411508837983*^9, {3.4984155639236603`*^9, 
   3.4984155645936613`*^9}, {3.4984158511840625`*^9, 3.498415851644063*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
     RowBox[{"c", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox["1", 
       RowBox[{"c", " ", "e"}]]}]}]}], 
   RowBox[{"Log", "[", 
    RowBox[{"a", "+", 
     RowBox[{"c", " ", 
      RowBox[{"Cot", "[", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], ")"}]}], "]"}]}]}], 
    "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, {3.4984069748816357`*^9, 
   3.498407000051671*^9}, {3.4984115253180065`*^9, 3.4984115658380632`*^9}, 
   3.4984117446983137`*^9, {3.4984157332238975`*^9, 3.49841574918392*^9}, 
   3.4984158925641203`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Log", "[", 
      RowBox[{"a", "+", 
       RowBox[{"c", "*", 
        RowBox[{"Cot", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], ")"}], "/", "2"}], "]"}]}]}], "]"}]}], 
    "/", 
    RowBox[{"(", 
     RowBox[{"c", "*", "e"}], ")"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"a", "+", "b"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984158462540555`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.558.4d", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, 
   3.4984115959881053`*^9, 3.4984159939942627`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"], "-", 
    SuperscriptBox["c", "2"]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, {3.498407084381789*^9, 3.4984070858217907`*^9}, {
   3.4984116805382233`*^9, 3.4984117154082727`*^9}, {3.4984160053842783`*^9, 
   3.498416008594283*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
     RowBox[{"c", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "c"}], "+", 
       RowBox[{"a", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}]}], 
      RowBox[{"c", " ", "e", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"c", " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], "]"}]}], "-", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], "]"}]}]}], 
        ")"}]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4977277558667603`*^9, 3.4977279564051123`*^9, 3.4984069789216413`*^9, {
   3.4984071019718137`*^9, 3.498407129841853*^9}, 3.498411666698204*^9, 
   3.49841174926832*^9, 3.49841179187838*^9, {3.498416025714307*^9, 
   3.4984160388143253`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "c"}], "+", 
      RowBox[{"a", "*", 
       RowBox[{"Sin", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"c", "*", "e", "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"c", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}], "-", 
        RowBox[{"b", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}]}], ")"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"c", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.4984069410415883`*^9, 3.4984070532617455`*^9, 3.498411445777895*^9, 
   3.4984115859180913`*^9, 3.498412722729683*^9, 3.498415966424224*^9, 
   3.498416102404414*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.558.4a, CRC 342b", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, 
   3.4984115959881053`*^9, 3.4984159939942627`*^9, 3.498416214164571*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"], "-", 
     SuperscriptBox["c", "2"]}], ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, {3.498407084381789*^9, 3.4984070858217907`*^9}, {
   3.4984116805382233`*^9, 3.4984117154082727`*^9}, {3.4984160053842783`*^9, 
   3.498416008594283*^9}, {3.4984162850246696`*^9, 3.4984162856346707`*^9}, {
   3.4984163213347206`*^9, 3.498416331354735*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
     RowBox[{"c", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["2", 
      RowBox[{"e", " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["a", "2"], "-", 
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}]]}]]}]}], 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{"c", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "-", "b"}], ")"}], " ", 
       RowBox[{"Tan", "[", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], ")"}]}], "]"}]}]}], 
     SqrtBox[
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"], "-", 
       SuperscriptBox["c", "2"]}]]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4977277558667603`*^9, 3.4977279564051123`*^9, 3.4984069789216413`*^9, {
   3.4984071019718137`*^9, 3.498407129841853*^9}, 3.498411666698204*^9, 
   3.49841174926832*^9, 3.49841179187838*^9, {3.498416025714307*^9, 
   3.4984160388143253`*^9}, 3.4984162570246305`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"2", "*", 
    RowBox[{
     RowBox[{"ArcTan", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "-", "b"}], ")"}], "*", 
          RowBox[{"Tan", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], ")"}], "/", "2"}], "]"}]}]}], ")"}], 
       "/", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"c", "^", "2"}]}], ",", "2"}], "]"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"e", "*", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"c", "^", "2"}]}], ",", "2"}], "]"}]}], ")"}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"PosQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"c", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.4984069410415883`*^9, 3.4984070532617455`*^9, 3.498411445777895*^9, 
   3.4984115859180913`*^9, 3.498412722729683*^9, 3.498415966424224*^9, 
   3.498416102404414*^9, 3.49841619951455*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.558.4b', CRC 342b'", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, 
   3.4984115959881053`*^9, 3.4984159939942627`*^9, 3.498416214164571*^9, 
   3.4984164187248573`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"], "-", 
       SuperscriptBox["c", "2"]}], ">", "0"}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, {3.498407084381789*^9, 3.4984070858217907`*^9}, {
   3.4984116805382233`*^9, 3.4984117154082727`*^9}, {3.4984160053842783`*^9, 
   3.498416008594283*^9}, {3.4984162850246696`*^9, 3.4984162856346707`*^9}, {
   3.4984163213347206`*^9, 3.498416331354735*^9}, {3.498416426654868*^9, 
   3.49841642795487*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
     RowBox[{"c", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox["2", 
       RowBox[{"e", " ", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "2"]}], "+", 
          SuperscriptBox["b", "2"], "+", 
          SuperscriptBox["c", "2"]}]]}]]}]}]}], 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     RowBox[{"c", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "-", "b"}], ")"}], " ", 
       RowBox[{"Tan", "[", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], ")"}]}], "]"}]}]}], 
     SqrtBox[
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "2"]}], "+", 
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}]]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4977277558667603`*^9, 3.4977279564051123`*^9, 3.4984069789216413`*^9, {
   3.4984071019718137`*^9, 3.498407129841853*^9}, 3.498411666698204*^9, 
   3.49841174926832*^9, 3.49841179187838*^9, {3.498416025714307*^9, 
   3.4984160388143253`*^9}, 3.4984162570246305`*^9, 3.4984164777649393`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], "*", 
    RowBox[{
     RowBox[{"ArcTanh", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "-", "b"}], ")"}], "*", 
          RowBox[{"Tan", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], ")"}], "/", "2"}], "]"}]}]}], ")"}], 
       "/", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           RowBox[{"a", "^", "2"}]}], "+", 
          RowBox[{"b", "^", "2"}], "+", 
          RowBox[{"c", "^", "2"}]}], ",", "2"}], "]"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"e", "*", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           RowBox[{"a", "^", "2"}]}], "+", 
          RowBox[{"b", "^", "2"}], "+", 
          RowBox[{"c", "^", "2"}]}], ",", "2"}], "]"}]}], ")"}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NegQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"c", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.4984069410415883`*^9, 3.4984070532617455`*^9, 3.498411445777895*^9, 
   3.4984115859180913`*^9, 3.498412722729683*^9, 3.498415966424224*^9, 
   3.498416102404414*^9, 3.49841619951455*^9, 3.4984164374948835`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SqrtBox[
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
     RowBox[{"c", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4977276071672993`*^9, 3.4984069663016233`*^9, 
   3.498411414357851*^9, 3.4984180577971516`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Reference: G&R 2.558.1 inverted ",
 "with",
 "  ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   FractionBox["1", "2"]}]]],
 " and  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"], "-", 
    SuperscriptBox["c", "2"]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984931758198605`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"], "-", 
    SuperscriptBox["c", "2"]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, 3.498411508837983*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SqrtBox[
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
     RowBox[{"c", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "c"}], " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}]}], 
      RowBox[{"e", " ", 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], "]"}]}]}]]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, {3.4984069748816357`*^9, 
   3.498407000051671*^9}, {3.4984115253180065`*^9, 3.4984115658380632`*^9}, 
   3.4984117446983137`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"a_", "+", 
      RowBox[{"b_.", "*", 
       RowBox[{"Cos", "[", 
        RowBox[{"d_.", "+", 
         RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
      RowBox[{"c_.", "*", 
       RowBox[{"Sin", "[", 
        RowBox[{"d_.", "+", 
         RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], "]"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"2", "*", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "c"}], "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
       RowBox[{"b", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"e", "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"c", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, 
   3.4984115959881053`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"b", " ", 
     RowBox[{"Cos", "[", "z", "]"}]}], "+", 
    RowBox[{"c", " ", 
     RowBox[{"Sin", "[", "z", "]"}]}]}], "=", 
   RowBox[{"a", "+", 
    RowBox[{
     SqrtBox[
      RowBox[{
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}]], " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"z", "-", 
       RowBox[{"ArcTan", "[", 
        RowBox[{"b", ",", "c"}], "]"}]}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840715643189*^9, {
   3.498407308712103*^9, 3.4984073159621134`*^9}, 3.498411643758172*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"], "-", 
     SuperscriptBox["c", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"a", "+", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}]]}], ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, {3.498407084381789*^9, 3.4984070858217907`*^9}, {
   3.4984116805382233`*^9, 3.4984117154082727`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SqrtBox[
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
     RowBox[{"c", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{
          SqrtBox[
           RowBox[{
            SuperscriptBox["b", "2"], "+", 
            SuperscriptBox["c", "2"]}]], " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}], "-", 
            RowBox[{"ArcTan", "[", 
             RowBox[{"b", ",", "c"}], "]"}]}], "]"}]}]}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4977277558667603`*^9, 3.4977279564051123`*^9, 3.4984069789216413`*^9, {
   3.4984071019718137`*^9, 3.498407129841853*^9}, 3.498411666698204*^9, 
   3.49841174926832*^9, 3.49841179187838*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"a_", "+", 
      RowBox[{"b_.", "*", 
       RowBox[{"Cos", "[", 
        RowBox[{"d_.", "+", 
         RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
      RowBox[{"c_.", "*", 
       RowBox[{"Sin", "[", 
        RowBox[{"d_.", "+", 
         RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], "]"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"a", "+", 
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "+", 
          RowBox[{"c", "^", "2"}]}], "]"}], "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}], "-", 
          RowBox[{"ArcTan", "[", 
           RowBox[{"b", ",", "c"}], "]"}]}], "]"}]}]}], "]"}], ",", "x"}], 
    "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", 
     RowBox[{"a", "+", 
      RowBox[{"Sqrt", "[", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "+", 
        RowBox[{"c", "^", "2"}]}], "]"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.4984069410415883`*^9, 3.4984070532617455`*^9, 3.498411445777895*^9, 
   3.4984115859180913`*^9, 3.49844101205044*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["\<\
Derivation: Piecewise constant extraction and algebraic simplification\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840715643189*^9, {
   3.4984119516486034`*^9, 3.498411961078616*^9}, {3.4984290446615815`*^9, 
   3.498429057750005*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    FractionBox[
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"c", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}]}]], 
     SqrtBox[
      FractionBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}]}], 
       RowBox[{"a", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "+", 
          SuperscriptBox["c", "2"]}]]}]]]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840715643189*^9, {
   3.498407308712103*^9, 3.4984073159621134`*^9}, 3.498411866578484*^9, {
   3.4984120202986994`*^9, 3.498412023408704*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"b", " ", 
     RowBox[{"Cos", "[", "z", "]"}]}], "+", 
    RowBox[{"c", " ", 
     RowBox[{"Sin", "[", "z", "]"}]}]}], "=", 
   RowBox[{"a", "+", 
    RowBox[{
     SqrtBox[
      RowBox[{
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}]], " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"z", "-", 
       RowBox[{"ArcTan", "[", 
        RowBox[{"b", ",", "c"}], "]"}]}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840715643189*^9, {
   3.498407308712103*^9, 3.4984073159621134`*^9}, 3.498411866578484*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"], "-", 
     SuperscriptBox["c", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", "+", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}]]}], ">", "0"}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, {3.498407084381789*^9, 3.4984070858217907`*^9}, {
   3.498407366552184*^9, 3.498407396032225*^9}, {3.4984118755384965`*^9, 
   3.4984118972785273`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SqrtBox[
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
     RowBox[{"c", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}]}]], 
      SqrtBox[
       FractionBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], "]"}]}]}], 
        RowBox[{"a", "+", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}]]}]]]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SqrtBox[
      RowBox[{
       FractionBox["a", 
        RowBox[{"a", "+", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}]]}]], "+", 
       RowBox[{
        FractionBox[
         SqrtBox[
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}]], 
         RowBox[{"a", "+", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["b", "2"], "+", 
            SuperscriptBox["c", "2"]}]]}]], 
        RowBox[{"Cos", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}], "-", 
          RowBox[{"ArcTan", "[", 
           RowBox[{"b", ",", "c"}], "]"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4977277558667603`*^9, 3.4977279564051123`*^9, {3.49799166209334*^9, 
   3.4979917014678087`*^9}, 3.4984069832816477`*^9, {3.498407170311909*^9, 
   3.498407191491939*^9}, 3.498407224301985*^9, 3.49841194205859*^9, 
   3.4984125081593823`*^9, {3.4984271620006742`*^9, 3.4984271643094783`*^9}, 
   3.498427389683074*^9, 3.4984277936145835`*^9, 3.4984279420956445`*^9, 
   3.498428188747678*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"a_.", "+", 
      RowBox[{"b_.", "*", 
       RowBox[{"Cos", "[", 
        RowBox[{"d_.", "+", 
         RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
      RowBox[{"c_.", "*", 
       RowBox[{"Sin", "[", 
        RowBox[{"d_.", "+", 
         RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], "]"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
       RowBox[{"c", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], "]"}]}], ")"}]}], "]"}]}], "*", "\n", 
    "    ", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{
        RowBox[{"a", "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"Sqrt", "[", 
            RowBox[{
             RowBox[{"b", "^", "2"}], "+", 
             RowBox[{"c", "^", "2"}]}], "]"}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{
          RowBox[{"Sqrt", "[", 
           RowBox[{
            RowBox[{"b", "^", "2"}], "+", 
            RowBox[{"c", "^", "2"}]}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"Sqrt", "[", 
             RowBox[{
              RowBox[{"b", "^", "2"}], "+", 
              RowBox[{"c", "^", "2"}]}], "]"}]}], ")"}]}], "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}], "-", 
           RowBox[{"ArcTan", "[", 
            RowBox[{"b", ",", "c"}], "]"}]}], "]"}]}]}], "]"}], ",", "x"}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"PositiveQ", "[", 
      RowBox[{"a", "+", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "+", 
         RowBox[{"c", "^", "2"}]}], "]"}]}], "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.49799144010495*^9, 3.498406936471582*^9, 3.498407148091878*^9, 
   3.498411443187891*^9, 3.498411840218447*^9, {3.498428687346154*^9, 
   3.4984287108865952`*^9}, {3.498428760213882*^9, 3.4984287629750867`*^9}, {
   3.498428822017991*^9, 3.498428844809631*^9}, {3.498441047540489*^9, 
   3.498441065830515*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"c", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}]}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4977276071672993`*^9, 3.4984069663016233`*^9, 
   3.498411414357851*^9, {3.498412682319626*^9, 3.498412691479639*^9}, 
   3.4984181133672295`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["\<\
Derivation: Algebraic simplification    NonzeroQ[a^2 - b^2 - c^2] ???? \
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, 3.4984169139755507`*^9, {
   3.4984170148056917`*^9, 3.4984170161556935`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"b", " ", 
     RowBox[{"Cos", "[", "z", "]"}]}], "+", 
    RowBox[{"c", " ", 
     RowBox[{"Sin", "[", "z", "]"}]}]}], "=", 
   RowBox[{"a", "+", 
    RowBox[{
     SqrtBox[
      RowBox[{
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}]], " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"z", "-", 
       RowBox[{"ArcTan", "[", 
        RowBox[{"b", ",", "c"}], "]"}]}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, {3.4984169139755507`*^9, 
   3.4984169294355717`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}]]}], ">", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, 3.498411508837983*^9, {3.4984155639236603`*^9, 
   3.4984155645936613`*^9}, {3.4984158511840625`*^9, 3.498415851644063*^9}, {
   3.498416957165611*^9, 3.4984169653256226`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"c", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox["1", 
        SqrtBox[
         RowBox[{"a", "+", 
          RowBox[{
           SqrtBox[
            RowBox[{
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}]], " ", 
           RowBox[{"Cos", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}], "-", 
             RowBox[{"ArcTan", "[", 
              RowBox[{"b", ",", "c"}], "]"}]}], "]"}]}]}]]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, {3.4984069748816357`*^9, 
   3.498407000051671*^9}, {3.4984115253180065`*^9, 3.4984115658380632`*^9}, 
   3.4984117446983137`*^9, {3.4984157332238975`*^9, 3.49841574918392*^9}, 
   3.4984158925641203`*^9, 3.4984170047256775`*^9, {3.4984170427057304`*^9, 
   3.498417061765757*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"a", "+", 
        RowBox[{
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], "]"}], "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}], "-", 
           RowBox[{"ArcTan", "[", 
            RowBox[{"b", ",", "c"}], "]"}]}], "]"}]}]}], "]"}]}], ",", "x"}], 
    "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", 
     RowBox[{"a", "+", 
      RowBox[{"Sqrt", "[", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "+", 
        RowBox[{"c", "^", "2"}]}], "]"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984158462540555`*^9, 
   3.498416698885249*^9, 3.498416908705543*^9, 3.4984413227608747`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["\<\
Derivation: Piecewise constant extraction and algebraic simplification\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840715643189*^9, {
   3.4984119516486034`*^9, 3.498411961078616*^9}, {3.4984290446615815`*^9, 
   3.498429057750005*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    FractionBox[
     SqrtBox[
      FractionBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}]}], 
       RowBox[{"a", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "+", 
          SuperscriptBox["c", "2"]}]]}]]], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"c", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}]}]]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, {3.4984169139755507`*^9, 
   3.4984169294355717`*^9}, {3.4984172041059566`*^9, 3.4984172055859585`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"b", " ", 
     RowBox[{"Cos", "[", "z", "]"}]}], "+", 
    RowBox[{"c", " ", 
     RowBox[{"Sin", "[", "z", "]"}]}]}], "=", 
   RowBox[{"a", "+", 
    RowBox[{
     SqrtBox[
      RowBox[{
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}]], " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"z", "-", 
       RowBox[{"ArcTan", "[", 
        RowBox[{"b", ",", "c"}], "]"}]}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, {3.4984169139755507`*^9, 
   3.4984169294355717`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"a", "+", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}]]}], "\[NotEqual]", "0"}], " ", "\[And]", 
   " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", "+", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}]]}], ">", "0"}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, 3.498411508837983*^9, {3.4984155639236603`*^9, 
   3.4984155645936613`*^9}, {3.4984158511840625`*^9, 3.498415851644063*^9}, {
   3.498416957165611*^9, 3.4984169653256226`*^9}, {3.498417283746068*^9, 
   3.4984173124761086`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"c", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SqrtBox[
       FractionBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], "]"}]}]}], 
        RowBox[{"a", "+", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}]]}]]], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}]}]]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      SqrtBox[
       RowBox[{
        FractionBox["a", 
         RowBox[{"a", "+", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["b", "2"], "+", 
            SuperscriptBox["c", "2"]}]]}]], "+", 
        RowBox[{
         FractionBox[
          SqrtBox[
           RowBox[{
            SuperscriptBox["b", "2"], "+", 
            SuperscriptBox["c", "2"]}]], 
          RowBox[{"a", "+", 
           SqrtBox[
            RowBox[{
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}]]}]], 
         RowBox[{"Cos", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}], "-", 
           RowBox[{"ArcTan", "[", 
            RowBox[{"b", ",", "c"}], "]"}]}], "]"}]}]}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, {3.4984069748816357`*^9, 
   3.498407000051671*^9}, {3.4984115253180065`*^9, 3.4984115658380632`*^9}, 
   3.4984117446983137`*^9, {3.4984157332238975`*^9, 3.49841574918392*^9}, 
   3.4984158925641203`*^9, 3.4984170047256775`*^9, {3.4984170427057304`*^9, 
   3.498417061765757*^9}, 3.498417142815871*^9, {3.4984292473371377`*^9, 
   3.498429274106785*^9}, {3.49842946469832*^9, 3.4984294728415346`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], "]"}]}], ")"}]}], "]"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
       RowBox[{"c", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}]}], "]"}]}], "*", "\n", "    ", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"a", "/", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"Sqrt", "[", 
             RowBox[{
              RowBox[{"b", "^", "2"}], "+", 
              RowBox[{"c", "^", "2"}]}], "]"}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{
           RowBox[{"Sqrt", "[", 
            RowBox[{
             RowBox[{"b", "^", "2"}], "+", 
             RowBox[{"c", "^", "2"}]}], "]"}], "/", 
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"Sqrt", "[", 
              RowBox[{
               RowBox[{"b", "^", "2"}], "+", 
               RowBox[{"c", "^", "2"}]}], "]"}]}], ")"}]}], "*", 
          RowBox[{"Cos", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}], "-", 
            RowBox[{"ArcTan", "[", 
             RowBox[{"b", ",", "c"}], "]"}]}], "]"}]}]}], "]"}]}], ",", "x"}],
      "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"a", "+", 
      RowBox[{"Sqrt", "[", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "+", 
        RowBox[{"c", "^", "2"}]}], "]"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"PositiveQ", "[", 
      RowBox[{"a", "+", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "+", 
         RowBox[{"c", "^", "2"}]}], "]"}]}], "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984158462540555`*^9, 
   3.498416698885249*^9, 3.498416908705543*^9, 3.4984171017058134`*^9, {
   3.498417351646163*^9, 3.4984173769561987`*^9}, {3.498429342575305*^9, 
   3.4984293592673345`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"c", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4977276071672993`*^9, 3.4984069663016233`*^9, 
   3.498411414357851*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Reference: G&R 2.558.1 inverted ",
 "with",
 " ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"], "-", 
    SuperscriptBox["c", "2"]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, 3.498493177988264*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"], "-", 
    SuperscriptBox["c", "2"]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", ">", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, {3.498407084381789*^9, 3.4984070858217907`*^9}, {
   3.4984116805382233`*^9, 3.4984117154082727`*^9}, {3.4984121474088774`*^9, 
   3.498412158138892*^9}, 3.498418845598255*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"c", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
         ", "\[IndentingNewLine]", "                 ", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "c"}], " ", 
           RowBox[{"Cos", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Cos", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
           RowBox[{"c", " ", 
            RowBox[{"Sin", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], 
         RowBox[{"n", "-", "1"}]]}], 
       RowBox[{"e", " ", "n"}]]}]}]}]}], "+", "\[IndentingNewLine]", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "n"}], "-", "1"}], ")"}]}], "n"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{
     "\[DifferentialD]", "x", 
      "                         "}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4977277558667603`*^9, 3.4977279564051123`*^9, 3.4984069789216413`*^9, {
   3.4984071019718137`*^9, 3.498407129841853*^9}, 3.498411666698204*^9, 
   3.49841174926832*^9, 3.49841179187838*^9, {3.498412197028947*^9, 
   3.4984122306389937`*^9}, 3.498412376379198*^9, {3.4984124721293316`*^9, 
   3.4984124753393364`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "c"}], "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
       RowBox[{"b", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"e", "*", "n"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "-", "1"}], ")"}], "/", "n"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Cos", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"Sin", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.4984069410415883`*^9, 3.4984070532617455`*^9, 3.498411445777895*^9, 
   3.4984115859180913`*^9, {3.4984121254088464`*^9, 3.4984121419688697`*^9}, {
   3.4984188240782247`*^9, 3.498418825808227*^9}, {3.498440277731406*^9, 
   3.4984402800214095`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.558.1 inverted", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, 3.498412277469059*^9, {
   3.4984155145035915`*^9, 3.498415517813596*^9}, {3.4984189441483927`*^9, 
   3.4984189522984037`*^9}, 3.498420133760058*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"], "-", 
     SuperscriptBox["c", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, {3.498407084381789*^9, 3.4984070858217907`*^9}, {
   3.4984116805382233`*^9, 3.4984117154082727`*^9}, {3.4984121474088774`*^9, 
   3.498412158138892*^9}, {3.4984122819690657`*^9, 3.498412287439073*^9}, 
   3.4984206691208076`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"c", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
           ", "\[IndentingNewLine]", "                   ", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "c"}], " ", 
           RowBox[{"Cos", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Cos", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
           RowBox[{"c", " ", 
            RowBox[{"Sin", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], 
         RowBox[{"n", "-", "1"}]]}], 
       RowBox[{"e", " ", "n"}]]}]}]}]}], "+", "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["1", "n"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"n", " ", 
        SuperscriptBox["a", "2"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}], 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "+", 
          SuperscriptBox["c", "2"]}], ")"}]}], "+", 
       RowBox[{"a", " ", "b", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "n"}], "-", "1"}], ")"}], " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"a", " ", "c", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "n"}], "-", "1"}], ")"}], 
        RowBox[{"Sin", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4977277558667603`*^9, 3.4977279564051123`*^9, 3.4984069789216413`*^9, {
   3.4984071019718137`*^9, 3.498407129841853*^9}, 3.498411666698204*^9, 
   3.49841174926832*^9, 3.49841179187838*^9, {3.498412197028947*^9, 
   3.4984122306389937`*^9}, {3.4984123290791316`*^9, 
   3.4984123451891537`*^9}, {3.4984123788092012`*^9, 3.4984124018892336`*^9}, 
   3.498420123780044*^9, {3.4984202710002503`*^9, 3.498420305010298*^9}, 
   3.498420414200451*^9, {3.498420487780554*^9, 3.498420488460555*^9}, {
   3.4984207146608715`*^9, 3.498420716610874*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "c"}], "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
       RowBox[{"b", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"e", "*", "n"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "n"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"n", "*", 
            RowBox[{"a", "^", "2"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"n", "-", "1"}], ")"}], "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"b", "^", "2"}], "+", 
              RowBox[{"c", "^", "2"}]}], ")"}]}], "+", 
           RowBox[{"a", "*", "b", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", "*", "n"}], "-", "1"}], ")"}], "*", 
            RowBox[{"Cos", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
           RowBox[{"a", "*", "c", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", "*", "n"}], "-", "1"}], ")"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "*", "\n", "    ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"Cos", "[", 
              RowBox[{"d", "+", 
               RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"Sin", "[", 
              RowBox[{"d", "+", 
               RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.4984069410415883`*^9, 3.4984070532617455`*^9, 3.498411445777895*^9, 
   3.4984115859180913`*^9, {3.4984121254088464`*^9, 3.4984121419688697`*^9}, 
   3.4984122725990524`*^9, {3.4984124118992476`*^9, 3.4984124140692506`*^9}, {
   3.498420597460707*^9, 3.4984206083607225`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"c", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], "n"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4977276071672993`*^9, 3.4984069663016233`*^9, 
   3.498411414357851*^9, {3.498412682319626*^9, 3.498412691479639*^9}, 
   3.4984190002484713`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Reference: G&R 2.558.1 inverted ",
 "with",
 " ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"], "-", 
    SuperscriptBox["c", "2"]}], "=", "0"}]]],
 " inverted"
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, 3.4984169139755507`*^9, {
   3.4984170148056917`*^9, 3.4984170161556935`*^9}, {3.498417209325964*^9, 
   3.4984172183259764`*^9}, 3.498417464166321*^9, 3.4984176249865456`*^9, {
   3.4984190999186106`*^9, 3.4984191011286125`*^9}, 3.4984931794078665`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"], "-", 
    SuperscriptBox["c", "2"]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, 3.498411508837983*^9, {3.4984155639236603`*^9, 
   3.4984155645936613`*^9}, {3.4984168250854263`*^9, 3.498416828835431*^9}, {
   3.4984176812066245`*^9, 3.498417690706638*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"c", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                   ", "\[IndentingNewLine]", 
      "                                   ", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"c", " ", 
           RowBox[{"Cos", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], "]"}]}], "-", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Cos", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
           RowBox[{"c", " ", 
            RowBox[{"Sin", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], "n"]}], 
       RowBox[{"a", " ", "e", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "n"}], "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox[
    RowBox[{"n", "+", "1"}], 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "n"}], "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, {3.4984069748816357`*^9, 
   3.498407000051671*^9}, {3.4984115253180065`*^9, 3.4984115658380632`*^9}, 
   3.4984117446983137`*^9, {3.4984157332238975`*^9, 3.49841574918392*^9}, 
   3.4984158925641203`*^9, 3.4984170047256775`*^9, {3.4984170427057304`*^9, 
   3.498417061765757*^9}, 3.498417142815871*^9, {3.4984174810763445`*^9, 
   3.4984175071063805`*^9}, {3.4984175424564304`*^9, 
   3.4984175583264523`*^9}, {3.4984176607865963`*^9, 3.498417671346611*^9}, {
   3.4984177017366533`*^9, 3.49841770652666*^9}, 3.4984191597086945`*^9, {
   3.4984191954487443`*^9, 3.498419207218761*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"c", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}], "-", 
       RowBox[{"b", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "e", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Cos", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"Sin", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984158462540555`*^9, 
   3.498416698885249*^9, 3.498416908705543*^9, 3.4984171017058134`*^9, {
   3.498417351646163*^9, 3.4984173769561987`*^9}, 3.4984174573863115`*^9, 
   3.4984176196065383`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Reference: G&R 2.558.1 ",
 "with",
 "  ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   RowBox[{"-", "2"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, {3.49841670665526*^9, 
   3.498416730765294*^9}, 3.498493180640269*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"], "-", 
    SuperscriptBox["c", "2"]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, 3.498411508837983*^9, {3.4984155639236603`*^9, 
   3.4984155645936613`*^9}, {3.4984168250854263`*^9, 3.498416828835431*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], "2"]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                            ", 
      "\[IndentingNewLine]", "                        ", 
      FractionBox[
       RowBox[{
        RowBox[{"c", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}], "-", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}]}], 
       RowBox[{"e", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Cos", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
          RowBox[{"c", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox["a", 
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"], "-", 
     SuperscriptBox["c", "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"c", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, {3.4984069748816357`*^9, 
   3.498407000051671*^9}, {3.4984115253180065`*^9, 3.4984115658380632`*^9}, 
   3.4984117446983137`*^9, {3.4984157332238975`*^9, 3.49841574918392*^9}, {
   3.4984167480753183`*^9, 3.4984167773253593`*^9}, {3.4984192598788347`*^9, 
   3.4984192736088543`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "2"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"c", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}], "-", 
       RowBox[{"b", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"e", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "-", 
         RowBox[{"b", "^", "2"}], "-", 
         RowBox[{"c", "^", "2"}]}], ")"}], "*", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}]}], ")"}]}], " ", "+", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "-", 
         RowBox[{"b", "^", "2"}], "-", 
         RowBox[{"c", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Cos", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"Sin", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"c", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984166961352453`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Reference: G&R 2.558.1 ",
 "with",
 " ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   RowBox[{"-", 
    FractionBox["3", "2"]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, 3.4984169139755507`*^9, {
   3.4984170148056917`*^9, 3.4984170161556935`*^9}, {3.498417209325964*^9, 
   3.4984172183259764`*^9}, 3.498417464166321*^9, {3.4984193161589136`*^9, 
   3.498419326428928*^9}, 3.4984931817634706`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"], "-", 
    SuperscriptBox["c", "2"]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, 3.498411508837983*^9, {3.4984155639236603`*^9, 
   3.4984155645936613`*^9}, {3.4984168250854263`*^9, 3.498416828835431*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"3", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                               ", 
      "\[IndentingNewLine]", "            ", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"c", " ", 
           RowBox[{"Cos", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], "]"}]}], "-", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}]}], 
       RowBox[{"e", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], " ", 
        SqrtBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Cos", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
          RowBox[{"c", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], "]"}]}]}]]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"], "-", 
     SuperscriptBox["c", "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"c", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, {3.4984069748816357`*^9, 
   3.498407000051671*^9}, {3.4984115253180065`*^9, 3.4984115658380632`*^9}, 
   3.4984117446983137`*^9, {3.4984157332238975`*^9, 3.49841574918392*^9}, 
   3.4984158925641203`*^9, 3.4984170047256775`*^9, {3.4984170427057304`*^9, 
   3.498417061765757*^9}, 3.498417142815871*^9, {3.4984174810763445`*^9, 
   3.4984175071063805`*^9}, {3.4984175424564304`*^9, 
   3.4984175583264523`*^9}, {3.4984193573489714`*^9, 3.4984193690589876`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"3", "/", "2"}], ")"}]}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"c", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}], "-", 
        RowBox[{"b", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"e", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"c", "^", "2"}]}], ")"}], "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Cos", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
          RowBox[{"c", "*", 
           RowBox[{"Sin", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}]}], " ", 
    "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "-", 
         RowBox[{"b", "^", "2"}], "-", 
         RowBox[{"c", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Cos", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
          RowBox[{"c", "*", 
           RowBox[{"Sin", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", "*", "x"}]}], "]"}]}]}], "]"}], ",", "x"}], "]"}]}],
      "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"c", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984158462540555`*^9, 
   3.498416698885249*^9, 3.498416908705543*^9, 3.4984171017058134`*^9, {
   3.498417351646163*^9, 3.4984173769561987`*^9}, 3.4984174573863115`*^9, {
   3.498419340108947*^9, 3.4984193434289513`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.558.1", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, 3.4984169139755507`*^9, {
   3.4984170148056917`*^9, 3.4984170161556935`*^9}, {3.498417209325964*^9, 
   3.4984172183259764`*^9}, 3.498417464166321*^9, 3.4984176249865456`*^9, 
   3.49841775663673*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"], "-", 
     SuperscriptBox["c", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"n", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{"n", "\[NotEqual]", 
    RowBox[{"-", "2"}]}], " ", "\[And]", " ", 
   RowBox[{"n", "\[NotEqual]", 
    RowBox[{"-", 
     FractionBox["3", "2"]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, 3.498411508837983*^9, {3.4984155639236603`*^9, 
   3.4984155645936613`*^9}, {3.4984168250854263`*^9, 3.498416828835431*^9}, {
   3.4984176812066245`*^9, 3.498417690706638*^9}, {3.4984177620467377`*^9, 
   3.498417781366765*^9}, 3.498419459959115*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"c", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "c"}], " ", 
           RowBox[{"Cos", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Cos", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
           RowBox[{"c", " ", 
            RowBox[{"Sin", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"e", " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}]}]]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"], "-", 
       SuperscriptBox["c", "2"]}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], " ", "a"}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}], " ", "b", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}], " ", "c", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, {3.4984069748816357`*^9, 
   3.498407000051671*^9}, {3.4984115253180065`*^9, 3.4984115658380632`*^9}, 
   3.4984117446983137`*^9, {3.4984157332238975`*^9, 3.49841574918392*^9}, 
   3.4984158925641203`*^9, 3.4984170047256775`*^9, {3.4984170427057304`*^9, 
   3.498417061765757*^9}, 3.498417142815871*^9, {3.4984174810763445`*^9, 
   3.4984175071063805`*^9}, {3.4984175424564304`*^9, 
   3.4984175583264523`*^9}, {3.4984176607865963`*^9, 3.498417671346611*^9}, {
   3.4984177017366533`*^9, 3.49841770652666*^9}, {3.4984178160368133`*^9, 
   3.4984178242268248`*^9}, {3.4984195060891795`*^9, 3.49841950648918*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "c"}], "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
       RowBox[{"b", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"e", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"c", "^", "2"}]}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}], "-", 
           RowBox[{"c", "^", "2"}]}], ")"}]}], ")"}]}], ",", "\n", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}], "*", "a"}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"n", "+", "2"}], ")"}], "*", "b", "*", 
            RowBox[{"Cos", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"n", "+", "2"}], ")"}], "*", "c", "*", 
            RowBox[{"Sin", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"Cos", "[", 
              RowBox[{"d", "+", 
               RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"Sin", "[", 
              RowBox[{"d", "+", 
               RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "2"}]}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{
      RowBox[{"-", "3"}], "/", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984158462540555`*^9, 
   3.498416698885249*^9, 3.498416908705543*^9, 3.4984171017058134`*^9, {
   3.498417351646163*^9, 3.4984173769561987`*^9}, 3.4984174573863115`*^9, 
   3.4984176196065383`*^9, {3.4984177347267*^9, 3.498417745826715*^9}, 
   3.498419466729124*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
     RowBox[{"C", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"c", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4977276071672993`*^9, 3.4984069663016233`*^9, 
   3.498411414357851*^9, {3.498412682319626*^9, 3.498412691479639*^9}, 
   3.4984190002484713`*^9, 3.498431143345269*^9, {3.4984327899409604`*^9, 
   3.498432793669367*^9}, {3.4984336640444965`*^9, 3.498433664559297*^9}, {
   3.5156850815083203`*^9, 3.515685087483131*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Note: Although exactly analogous to G&R 2.451.3 for hyperbolic functions, \
there is no corresponding G&R 2.558.n formula for trig functions.  Apparently \
the authors did not anticipate  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["b", "2"], "+", 
   SuperscriptBox["c", "2"]}]]],
 " could be 0 in the complex plane."
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, 3.4984169139755507`*^9, {
   3.4984170148056917`*^9, 3.4984170161556935`*^9}, {3.498417209325964*^9, 
   3.4984172183259764`*^9}, 3.498417464166321*^9, 3.4984176249865456`*^9, {
   3.4984190999186106`*^9, 3.4984191011286125`*^9}, 3.4984312037641754`*^9, {
   3.498432107096561*^9, 3.4984321210117855`*^9}, 3.498432947626037*^9, 
   3.498433970850235*^9, 3.4984931895946846`*^9, {3.5154366850003614`*^9, 
   3.5154366904003687`*^9}, {3.5162350979982004`*^9, 3.516235104692583*^9}, {
   3.5162357617011623`*^9, 3.516235939893354*^9}, {3.516238492468353*^9, 
   3.516238493039386*^9}, {3.516238760301672*^9, 3.516238960832142*^9}, {
   3.516239008584873*^9, 3.5162390122840843`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["b", "2"], "+", 
    SuperscriptBox["c", "2"]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, 3.498411508837983*^9, {3.4984155639236603`*^9, 
   3.4984155645936613`*^9}, {3.4984168250854263`*^9, 3.498416828835431*^9}, {
   3.4984176812066245`*^9, 3.498417690706638*^9}, {3.4984314419453936`*^9, 
   3.4984314738318496`*^9}, 3.49843175923075*^9, {3.4984328634326897`*^9, 
   3.498432867660297*^9}, {3.4984337769418945`*^9, 3.4984337782366967`*^9}, {
   3.498433846533617*^9, 3.4984338823044796`*^9}, {3.5154366677003365`*^9, 
   3.515436676140349*^9}, {3.516235109827877*^9, 3.5162351198644505`*^9}, 
   3.5162359473787823`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"C", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}]}], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"c", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "a", " ", "A"}], "-", 
          RowBox[{"b", " ", "B"}], "-", 
          RowBox[{"c", " ", "C"}]}], ")"}], " ", "x"}], 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "2"]}]]}]}]}]}], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"b", " ", "B"}], "+", 
      RowBox[{"c", " ", "C"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"b", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}], "-", 
      RowBox[{"c", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}]}], 
   RowBox[{"2", " ", "a", " ", "b", " ", "c", " ", "e"}]], "+", 
  "\[IndentingNewLine]", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", " ", "B"}], "-", 
         RowBox[{"c", " ", "C"}]}], ")"}]}], "-", 
      RowBox[{"2", " ", "a", " ", "A", " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", " ", "B"}], "+", 
         RowBox[{"c", " ", "C"}]}], ")"}]}]}], ")"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"c", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}]}], "]"}]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
    "e"}]]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, {3.4984069748816357`*^9, 
   3.498407000051671*^9}, {3.4984115253180065`*^9, 3.4984115658380632`*^9}, 
   3.4984117446983137`*^9, {3.4984157332238975`*^9, 3.49841574918392*^9}, 
   3.4984158925641203`*^9, 3.4984170047256775`*^9, {3.4984170427057304`*^9, 
   3.498417061765757*^9}, 3.498417142815871*^9, {3.4984174810763445`*^9, 
   3.4984175071063805`*^9}, {3.4984175424564304`*^9, 
   3.4984175583264523`*^9}, {3.4984176607865963`*^9, 3.498417671346611*^9}, {
   3.4984177017366533`*^9, 3.49841770652666*^9}, 3.4984191597086945`*^9, {
   3.4984191954487443`*^9, 3.498419207218761*^9}, {3.4984313788432827`*^9, 
   3.498431411088539*^9}, 3.4984328210318146`*^9, 3.4984329324316106`*^9, 
   3.4984340743564167`*^9, 3.49843416142017*^9, 3.4984345855073156`*^9, {
   3.5154366567603216`*^9, 3.515436659860326*^9}, {3.515436764420472*^9, 
   3.515436789440507*^9}, 3.5154368673506165`*^9, {3.5162351337372446`*^9, 
   3.5162351500331764`*^9}, {3.516235969990075*^9, 3.516235973012248*^9}, {
   3.516238477496496*^9, 3.51623848088369*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "*", "a", "*", "A"}], "-", 
       RowBox[{"b", "*", "B"}], "-", 
       RowBox[{"c", "*", "C"}]}], ")"}], "*", 
     RowBox[{"x", "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", 
        RowBox[{"a", "^", "2"}]}], ")"}]}]}], " ", "-", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", "*", "B"}], "+", 
       RowBox[{"c", "*", "C"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}], "-", 
        RowBox[{"c", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "a", "*", "b", "*", "c", "*", "e"}], ")"}]}]}], " ", 
    "+", " ", "\n", "  ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"a", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "*", "B"}], "-", 
          RowBox[{"c", "*", "C"}]}], ")"}]}], "-", 
       RowBox[{"2", "*", "a", "*", "A", "*", 
        RowBox[{"b", "^", "2"}]}], "+", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "*", "B"}], "+", 
          RowBox[{"c", "*", "C"}]}], ")"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", 
        RowBox[{"a", "^", "2"}], "*", "b", "*", "c", "*", "e"}], ")"}]}]}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "A", ",", "B", ",", 
        "C"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "+", 
      RowBox[{"c", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984158462540555`*^9, 
   3.498416698885249*^9, 3.498416908705543*^9, 3.4984171017058134`*^9, {
   3.498417351646163*^9, 3.4984173769561987`*^9}, 3.4984174573863115`*^9, 
   3.4984176196065383`*^9, 3.4984311835465393`*^9, 3.498431990639157*^9, 
   3.498432773248931*^9, 3.4984328413742504`*^9, {3.498432890405137*^9, 
   3.4984329019179573`*^9}, 3.4984336733577127`*^9, 3.498433726475806*^9, 
   3.4984338188747683`*^9, 3.498433909495328*^9, {3.4984345619824743`*^9, 
   3.4984345685032854`*^9}, {3.515436599220241*^9, 3.5154366441703043`*^9}, {
   3.5154368460105867`*^9, 3.515436853490597*^9}, {3.51623525762333*^9, 
   3.516235309756312*^9}, {3.5162356387001266`*^9, 3.5162356394321685`*^9}, {
   3.516235973791293*^9, 3.5162359770784807`*^9}, 3.516238609417042*^9, 
   3.5162389853685455`*^9, 3.5162485241761336`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "*", "a", "*", "A"}], "-", 
       RowBox[{"c", "*", "C"}]}], ")"}], "*", 
     RowBox[{"x", "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", 
        RowBox[{"a", "^", "2"}]}], ")"}]}]}], " ", "-", " ", 
    RowBox[{"C", "*", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "a", "*", "e"}], ")"}]}]}], " ", "+", " ", 
    RowBox[{"c", "*", "C", "*", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "a", "*", "b", "*", "e"}], ")"}]}]}], " ", "+", " ", 
    "\n", "  ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         RowBox[{"a", "^", "2"}]}], "*", "C"}], "+", 
       RowBox[{"2", "*", "a", "*", "c", "*", "A"}], "+", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", "C"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", 
        RowBox[{"a", "^", "2"}], "*", "b", "*", "e"}], ")"}]}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "A", ",", "C"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "+", 
      RowBox[{"c", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984158462540555`*^9, 
   3.498416698885249*^9, 3.498416908705543*^9, 3.4984171017058134`*^9, {
   3.498417351646163*^9, 3.4984173769561987`*^9}, 3.4984174573863115`*^9, 
   3.4984176196065383`*^9, 3.4984311835465393`*^9, 3.498431990639157*^9, {
   3.4984341919026237`*^9, 3.4984342187818713`*^9}, {3.4984342969224086`*^9, 
   3.4984343035368204`*^9}, {3.5154350163079257`*^9, 
   3.5154350307535505`*^9}, {3.5154350707208214`*^9, 
   3.5154350759156303`*^9}, {3.515442216698106*^9, 3.5154422240481157`*^9}, {
   3.516235370964813*^9, 3.516235405734802*^9}, {3.516235443181944*^9, 
   3.516235483086226*^9}, {3.516235642028317*^9, 3.516235643430397*^9}, {
   3.516235978045536*^9, 3.5162359810937104`*^9}, {3.516238614567336*^9, 
   3.5162386836122856`*^9}, 3.516238988018697*^9, {3.5162399214220843`*^9, 
   3.516239945246447*^9}, {3.5162400410659275`*^9, 3.516240054034669*^9}, 
   3.516240240281322*^9, {3.5162402955874853`*^9, 3.516240298135631*^9}, 
   3.5162485271513042`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "*", "a", "*", "A"}], "-", 
       RowBox[{"b", "*", "B"}]}], ")"}], "*", 
     RowBox[{"x", "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", 
        RowBox[{"a", "^", "2"}]}], ")"}]}]}], " ", "-", " ", 
    RowBox[{"b", "*", "B", "*", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "a", "*", "c", "*", "e"}], ")"}]}]}], " ", "+", " ", 
    RowBox[{"B", "*", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "a", "*", "e"}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"a", "^", "2"}], "*", "B"}], "-", 
       RowBox[{"2", "*", "a", "*", "b", "*", "A"}], "+", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", "B"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", 
        RowBox[{"a", "^", "2"}], "*", "c", "*", "e"}], ")"}]}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "A", ",", "B"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "+", 
      RowBox[{"c", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984158462540555`*^9, 
   3.498416698885249*^9, 3.498416908705543*^9, 3.4984171017058134`*^9, {
   3.498417351646163*^9, 3.4984173769561987`*^9}, 3.4984174573863115`*^9, 
   3.4984176196065383`*^9, 3.4984311835465393`*^9, 3.498431990639157*^9, {
   3.4984341919026237`*^9, 3.4984342187818713`*^9}, {3.4984342969224086`*^9, 
   3.4984343035368204`*^9}, {3.5154350163079257`*^9, 
   3.5154350307535505`*^9}, {3.5154350707208214`*^9, 3.5154350759156303`*^9}, 
   3.5154417266374197`*^9, {3.5154421043679485`*^9, 3.5154421305679846`*^9}, {
   3.515442232748128*^9, 3.515442239278137*^9}, 3.5162353735509605`*^9, {
   3.5162354163284073`*^9, 3.5162354295621643`*^9}, {3.516235484800324*^9, 
   3.5162355360262537`*^9}, {3.5162356460695477`*^9, 3.516235646815591*^9}, {
   3.5162359816407413`*^9, 3.516235983735862*^9}, 3.516238617143484*^9, {
   3.516238695788982*^9, 3.5162387263047276`*^9}, 3.5162389911078734`*^9, {
   3.516239952556865*^9, 3.516239999625557*^9}, {3.5162400913058014`*^9, 
   3.516240096148078*^9}, 3.5162485297424517`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Reference: G&R 2.558.2 ",
 "with",
 "  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"A", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}], ")"}]}], "-", 
    RowBox[{"a", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", " ", "B"}], "+", 
       RowBox[{"c", " ", "C"}]}], ")"}]}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, 3.4984169139755507`*^9, {
   3.4984170148056917`*^9, 3.4984170161556935`*^9}, {3.498417209325964*^9, 
   3.4984172183259764`*^9}, 3.498417464166321*^9, 3.4984176249865456`*^9, {
   3.4984190999186106`*^9, 3.4984191011286125`*^9}, 3.4984312037641754`*^9, {
   3.498432107096561*^9, 3.4984321210117855`*^9}, 3.498432947626037*^9, 
   3.498433970850235*^9, 3.4984931895946846`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"A", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], "-", 
     RowBox[{"a", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", " ", "B"}], "+", 
        RowBox[{"c", " ", "C"}]}], ")"}]}]}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, 3.498411508837983*^9, {3.4984155639236603`*^9, 
   3.4984155645936613`*^9}, {3.4984168250854263`*^9, 3.498416828835431*^9}, {
   3.4984176812066245`*^9, 3.498417690706638*^9}, {3.4984314419453936`*^9, 
   3.4984314738318496`*^9}, 3.49843175923075*^9, {3.4984328634326897`*^9, 
   3.498432867660297*^9}, {3.4984337769418945`*^9, 3.4984337782366967`*^9}, {
   3.498433846533617*^9, 3.4984338823044796`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"C", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}]}], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"c", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "B"}], "+", 
          RowBox[{"c", " ", "C"}]}], ")"}], " ", "x"}], 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}]]}]}]}]}], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"c", " ", "B"}], "-", 
      RowBox[{"b", " ", "C"}]}], ")"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"c", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}]}], "]"}]}], 
   RowBox[{"e", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], ")"}]}]]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, {3.4984069748816357`*^9, 
   3.498407000051671*^9}, {3.4984115253180065`*^9, 3.4984115658380632`*^9}, 
   3.4984117446983137`*^9, {3.4984157332238975`*^9, 3.49841574918392*^9}, 
   3.4984158925641203`*^9, 3.4984170047256775`*^9, {3.4984170427057304`*^9, 
   3.498417061765757*^9}, 3.498417142815871*^9, {3.4984174810763445`*^9, 
   3.4984175071063805`*^9}, {3.4984175424564304`*^9, 
   3.4984175583264523`*^9}, {3.4984176607865963`*^9, 3.498417671346611*^9}, {
   3.4984177017366533`*^9, 3.49841770652666*^9}, 3.4984191597086945`*^9, {
   3.4984191954487443`*^9, 3.498419207218761*^9}, {3.4984313788432827`*^9, 
   3.498431411088539*^9}, 3.4984328210318146`*^9, 3.4984329324316106`*^9, 
   3.4984340743564167`*^9, 3.49843416142017*^9, 3.4984345855073156`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", "*", "B"}], "+", 
       RowBox[{"c", "*", "C"}]}], ")"}], "*", 
     RowBox[{"x", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "+", 
        RowBox[{"c", "^", "2"}]}], ")"}]}]}], " ", "+", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"c", "*", "B"}], "-", 
       RowBox[{"b", "*", "C"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"e", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "+", 
          RowBox[{"c", "^", "2"}]}], ")"}]}], ")"}]}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "A", ",", "B", ",", 
        "C"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "+", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"A", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "+", 
         RowBox[{"c", "^", "2"}]}], ")"}]}], "-", 
      RowBox[{"a", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "B"}], "+", 
         RowBox[{"c", "*", "C"}]}], ")"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984158462540555`*^9, 
   3.498416698885249*^9, 3.498416908705543*^9, 3.4984171017058134`*^9, {
   3.498417351646163*^9, 3.4984173769561987`*^9}, 3.4984174573863115`*^9, 
   3.4984176196065383`*^9, 3.4984311835465393`*^9, 3.498431990639157*^9, 
   3.498432773248931*^9, 3.4984328413742504`*^9, {3.498432890405137*^9, 
   3.4984329019179573`*^9}, 3.4984336733577127`*^9, 3.498433726475806*^9, 
   3.4984338188747683`*^9, 3.498433909495328*^9, {3.4984345619824743`*^9, 
   3.4984345685032854`*^9}},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Reference: G&R 2.558.2 with  ",
 Cell[BoxData[
  RowBox[{"B", "=", "0"}]]],
 "  and  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"A", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}], ")"}]}], "-", 
    RowBox[{"a", " ", "c", " ", "C"}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, 3.4984169139755507`*^9, {
   3.4984170148056917`*^9, 3.4984170161556935`*^9}, {3.498417209325964*^9, 
   3.4984172183259764`*^9}, 3.498417464166321*^9, 3.4984176249865456`*^9, {
   3.4984190999186106`*^9, 3.4984191011286125`*^9}, 3.4984312037641754`*^9, {
   3.498432107096561*^9, 3.4984321210117855`*^9}, 3.498493182871073*^9, {
   3.4984937552524786`*^9, 3.4984937670304995`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"c", "*", "C", "*", 
     RowBox[{"x", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "+", 
        RowBox[{"c", "^", "2"}]}], ")"}]}]}], " ", "-", " ", 
    RowBox[{"b", "*", "C", "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"e", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "+", 
          RowBox[{"c", "^", "2"}]}], ")"}]}], ")"}]}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "A", ",", "C"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "+", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"A", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "+", 
         RowBox[{"c", "^", "2"}]}], ")"}]}], "-", 
      RowBox[{"a", "*", "c", "*", "C"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984158462540555`*^9, 
   3.498416698885249*^9, 3.498416908705543*^9, 3.4984171017058134`*^9, {
   3.498417351646163*^9, 3.4984173769561987`*^9}, 3.4984174573863115`*^9, 
   3.4984176196065383`*^9, 3.4984311835465393`*^9, 3.498431990639157*^9, {
   3.4984341919026237`*^9, 3.4984342187818713`*^9}, {3.4984342969224086`*^9, 
   3.4984343035368204`*^9}},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Reference: G&R 2.558.2 with  ",
 Cell[BoxData[
  RowBox[{"C", "=", "0"}]]],
 "  and  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"A", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}], ")"}]}], "-", 
    RowBox[{"a", " ", "b", " ", "B"}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, 3.4984169139755507`*^9, {
   3.4984170148056917`*^9, 3.4984170161556935`*^9}, {3.498417209325964*^9, 
   3.4984172183259764`*^9}, 3.498417464166321*^9, 3.4984176249865456`*^9, {
   3.4984190999186106`*^9, 3.4984191011286125`*^9}, 3.4984312037641754`*^9, {
   3.498432107096561*^9, 3.4984321210117855`*^9}, 3.498432947626037*^9, 
   3.498493186474679*^9, {3.498493792021743*^9, 3.4984938020837607`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"b", "*", "B", "*", 
     RowBox[{"x", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "+", 
        RowBox[{"c", "^", "2"}]}], ")"}]}]}], " ", "+", " ", 
    RowBox[{"c", "*", "B", "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"e", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "+", 
          RowBox[{"c", "^", "2"}]}], ")"}]}], ")"}]}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "A", ",", "B"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "+", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"A", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "+", 
         RowBox[{"c", "^", "2"}]}], ")"}]}], "-", 
      RowBox[{"a", "*", "b", "*", "B"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984158462540555`*^9, 
   3.498416698885249*^9, 3.498416908705543*^9, 3.4984171017058134`*^9, {
   3.498417351646163*^9, 3.4984173769561987`*^9}, 3.4984174573863115`*^9, 
   3.4984176196065383`*^9, 3.4984311835465393`*^9, 3.498431990639157*^9, 
   3.498432773248931*^9, 3.4984328413742504`*^9, {3.498432890405137*^9, 
   3.4984329019179573`*^9}, {3.4984344060134*^9, 3.4984344380558567`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.558.2", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, {3.49841670665526*^9, 
   3.498416730765294*^9}, 3.4984315342507553`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], "+", 
     SuperscriptBox["c", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"A", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], "-", 
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", " ", "B"}], "+", 
        RowBox[{"c", " ", "C"}]}], ")"}]}]}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, 3.498411508837983*^9, {3.4984155639236603`*^9, 
   3.4984155645936613`*^9}, {3.4984168250854263`*^9, 3.498416828835431*^9}, {
   3.4984176812066245`*^9, 3.498417690706638*^9}, {3.4984314419453936`*^9, 
   3.4984314738318496`*^9}, 3.49843175923075*^9, {3.4984320994837475`*^9, 
   3.4984321010281506`*^9}, 3.4984330519962215`*^9, {3.498434747576*^9, 
   3.4984347506804056`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"C", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}]}], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"c", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "B"}], "+", 
          RowBox[{"c", " ", "C"}]}], ")"}], " ", "x"}], 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}]]}]}]}]}], "+", "\[IndentingNewLine]", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"c", " ", "B"}], "-", 
      RowBox[{"b", " ", "C"}]}], ")"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"c", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}]}], "]"}]}], 
   RowBox[{"e", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], ")"}]}]], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"A", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], "-", 
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", " ", "B"}], "+", 
        RowBox[{"c", " ", "C"}]}], ")"}]}]}], 
    RowBox[{
     SuperscriptBox["b", "2"], "+", 
     SuperscriptBox["c", "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"c", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, {3.4984069748816357`*^9, 
   3.498407000051671*^9}, {3.4984115253180065`*^9, 3.4984115658380632`*^9}, 
   3.4984117446983137`*^9, {3.4984157332238975`*^9, 3.49841574918392*^9}, {
   3.4984167480753183`*^9, 3.4984167773253593`*^9}, {3.4984192598788347`*^9, 
   3.4984192736088543`*^9}, {3.4984317085306616`*^9, 
   3.4984317224926863`*^9}, {3.4984318598565273`*^9, 3.4984319106266165`*^9}, 
   3.498432821499816*^9, {3.4984332348441424`*^9, 3.4984332447501593`*^9}, 
   3.498434076665221*^9, {3.4984346622282505`*^9, 3.4984346847546897`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", "*", "B"}], "+", 
       RowBox[{"c", "*", "C"}]}], ")"}], "*", 
     RowBox[{"x", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "+", 
        RowBox[{"c", "^", "2"}]}], ")"}]}]}], " ", "+", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"c", "*", "B"}], "-", 
       RowBox[{"b", "*", "C"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"e", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "+", 
          RowBox[{"c", "^", "2"}]}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"A", "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"b", "^", "2"}], "+", 
            RowBox[{"c", "^", "2"}]}], ")"}]}], "-", 
         RowBox[{"a", "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"b", "*", "B"}], "+", 
            RowBox[{"c", "*", "C"}]}], ")"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "+", 
         RowBox[{"c", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Cos", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"Sin", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "A", ",", "B", ",", 
        "C"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "+", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"A", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "+", 
         RowBox[{"c", "^", "2"}]}], ")"}]}], "-", 
      RowBox[{"a", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "B"}], "+", 
         RowBox[{"c", "*", "C"}]}], ")"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984166961352453`*^9, 
   3.498431175169325*^9, 3.4984315237831373`*^9, 3.4984318251464663`*^9, 
   3.498431987628351*^9, 3.4984327757761354`*^9, 3.498433033494589*^9, 
   3.4984330656774454`*^9, {3.4984331457211857`*^9, 3.4984331533183994`*^9}, 
   3.498433676228118*^9, {3.498433997510682*^9, 3.498434057913988*^9}, {
   3.4984346049605494`*^9, 3.498434605678151*^9}, {3.4984347246595597`*^9, 
   3.4984347265003633`*^9}},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Reference: G&R 2.558.2 with  ",
 Cell[BoxData[
  RowBox[{"B", "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, {3.49841670665526*^9, 
   3.498416730765294*^9}, 3.4984315342507553`*^9, {3.498493738154848*^9, 
   3.4984937466880636`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"c", "*", "C", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", "*", "x"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"e", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "+", 
          RowBox[{"c", "^", "2"}]}], ")"}]}], ")"}]}]}], " ", "-", " ", 
    RowBox[{"b", "*", "C", "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"e", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "+", 
          RowBox[{"c", "^", "2"}]}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"A", "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"b", "^", "2"}], "+", 
            RowBox[{"c", "^", "2"}]}], ")"}]}], "-", 
         RowBox[{"a", "*", "c", "*", "C"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "+", 
         RowBox[{"c", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Cos", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"Sin", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "A", ",", "C"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "+", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"A", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "+", 
         RowBox[{"c", "^", "2"}]}], ")"}]}], "-", 
      RowBox[{"a", "*", "c", "*", "C"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984166961352453`*^9, 
   3.498431175169325*^9, 3.4984315237831373`*^9, 3.4984318251464663`*^9, 
   3.498431987628351*^9, {3.498434366623331*^9, 3.4984343756713467`*^9}},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Reference: G&R 2.558.2 with  ",
 Cell[BoxData[
  RowBox[{"C", "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, {3.49841670665526*^9, 
   3.498416730765294*^9}, 3.4984315342507553`*^9, {3.498493808744972*^9, 
   3.4984938154997845`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"b", "*", "B", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", "*", "x"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"e", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "+", 
          RowBox[{"c", "^", "2"}]}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"c", "*", "B", "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"e", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "+", 
          RowBox[{"c", "^", "2"}]}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"A", "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"b", "^", "2"}], "+", 
            RowBox[{"c", "^", "2"}]}], ")"}]}], "-", 
         RowBox[{"a", "*", "b", "*", "B"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "+", 
         RowBox[{"c", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Cos", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"Sin", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "A", ",", "B"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "+", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"A", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "+", 
         RowBox[{"c", "^", "2"}]}], ")"}]}], "-", 
      RowBox[{"a", "*", "b", "*", "B"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984166961352453`*^9, 
   3.498431175169325*^9, 3.4984315237831373`*^9, 3.4984318251464663`*^9, 
   3.498431987628351*^9, 3.4984327757761354`*^9, 3.498433033494589*^9, 
   3.4984330656774454`*^9, {3.4984331457211857`*^9, 3.4984331533183994`*^9}, {
   3.4984345127643876`*^9, 3.4984345143399906`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Reference: G&R 2.558.1 ",
 "with",
 "  ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   RowBox[{"-", "2"}]}]]],
 "  and  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "A"}], "-", 
    RowBox[{"b", " ", "B"}], "-", 
    RowBox[{"c", " ", "C"}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, {3.49841670665526*^9, 
   3.498416730765294*^9}, 3.4984315342507553`*^9, 3.498432181820692*^9, {
   3.4984323991446743`*^9, 3.4984324154623027`*^9}, {3.4984326517715178`*^9, 
   3.4984326721139536`*^9}, 3.498433303952264*^9, 3.4984348513785825`*^9, 
   3.4984931905618863`*^9, 3.498493920441169*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"], "-", 
      SuperscriptBox["c", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"a", " ", "A"}], "-", 
     RowBox[{"b", " ", "B"}], "-", 
     RowBox[{"c", " ", "C"}]}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, 3.498411508837983*^9, {3.4984155639236603`*^9, 
   3.4984155645936613`*^9}, {3.4984168250854263`*^9, 3.498416828835431*^9}, {
   3.4984176812066245`*^9, 3.498417690706638*^9}, {3.4984314419453936`*^9, 
   3.4984314738318496`*^9}, 3.49843175923075*^9, {3.4984320994837475`*^9, 
   3.4984321010281506`*^9}, {3.4984322552188215`*^9, 3.4984322841256723`*^9}, 
   3.4984333049662657`*^9, {3.4984348419873657`*^9, 3.4984348444833703`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
     RowBox[{"C", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "]"}]}]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"c", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], "2"]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       RowBox[{"c", " ", "B"}], "-", 
       RowBox[{"b", " ", "C"}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", " ", "C"}], "-", 
          RowBox[{"c", " ", "A"}]}], ")"}], " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", " ", "B"}], "-", 
          RowBox[{"b", " ", "A"}]}], ")"}], " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}]}], 
      RowBox[{"e", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["a", "2"], "-", 
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], "]"}]}]}], 
        ")"}]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, {3.4984069748816357`*^9, 
   3.498407000051671*^9}, {3.4984115253180065`*^9, 3.4984115658380632`*^9}, 
   3.4984117446983137`*^9, {3.4984157332238975`*^9, 3.49841574918392*^9}, {
   3.4984167480753183`*^9, 3.4984167773253593`*^9}, {3.4984192598788347`*^9, 
   3.4984192736088543`*^9}, {3.4984317085306616`*^9, 
   3.4984317224926863`*^9}, {3.4984318598565273`*^9, 
   3.4984319106266165`*^9}, {3.498432204378332*^9, 3.4984322333163824`*^9}, 
   3.498432821999017*^9, 3.4984333425279317`*^9, 3.4984340793016253`*^9, 
   3.4984348259037375`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "2"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"c", "*", "B"}], "-", 
      RowBox[{"b", "*", "C"}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "*", "C"}], "-", 
         RowBox[{"c", "*", "A"}]}], ")"}], "*", 
       RowBox[{"Cos", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "*", "B"}], "-", 
         RowBox[{"b", "*", "A"}]}], ")"}], "*", 
       RowBox[{"Sin", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "/", "\n", "    ", 
    RowBox[{"(", 
     RowBox[{"e", "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "-", 
        RowBox[{"b", "^", "2"}], "-", 
        RowBox[{"c", "^", "2"}]}], ")"}], "*", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}]}], ")"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "A", ",", "B", ",", 
        "C"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "A"}], "-", 
      RowBox[{"b", "*", "B"}], "-", 
      RowBox[{"c", "*", "C"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984166961352453`*^9, 
   3.498431175169325*^9, 3.4984315237831373`*^9, 3.4984318251464663`*^9, 
   3.498431987628351*^9, 3.4984321755026813`*^9, 3.49843277822534*^9, 
   3.4984332805522223`*^9, 3.498433678505722*^9, 3.4984348062477036`*^9},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Reference: G&R 2.558.1 with  ",
 Cell[BoxData[
  RowBox[{"B", "=", "0"}]]],
 ",  ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   RowBox[{"-", "2"}]}]]],
 "  and  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "A"}], "-", 
    RowBox[{"c", " ", "C"}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, {3.49841670665526*^9, 
   3.498416730765294*^9}, 3.4984315342507553`*^9, 3.498432181820692*^9, {
   3.4984323991446743`*^9, 3.4984324154623027`*^9}, {3.4984326517715178`*^9, 
   3.4984326721139536`*^9}, 3.4984931838070745`*^9, {3.498493396621448*^9, 
   3.4984934439207315`*^9}, {3.4984936249610496`*^9, 3.498493630343059*^9}, {
   3.4984936632903166`*^9, 3.4984936800135465`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "2"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", "*", "C"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "*", "C"}], "-", 
          RowBox[{"c", "*", "A"}]}], ")"}], "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
       RowBox[{"b", "*", "A", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}]}], "/", 
    RowBox[{"(", 
     RowBox[{"e", "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "-", 
        RowBox[{"b", "^", "2"}], "-", 
        RowBox[{"c", "^", "2"}]}], ")"}], "*", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}]}], ")"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "A", ",", "C"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "A"}], "-", 
      RowBox[{"c", "*", "C"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984166961352453`*^9, 
   3.498431175169325*^9, 3.4984315237831373`*^9, 3.4984318251464663`*^9, 
   3.498431987628351*^9, 3.4984321755026813`*^9},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Reference: G&R 2.558.1 with  ",
 Cell[BoxData[
  RowBox[{"C", "=", "0"}]]],
 ",  ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   RowBox[{"-", "2"}]}]]],
 "  and  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "A"}], "-", 
    RowBox[{"b", " ", "B"}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, {3.49841670665526*^9, 
   3.498416730765294*^9}, 3.4984315342507553`*^9, 3.498432181820692*^9, {
   3.4984323991446743`*^9, 3.4984324154623027`*^9}, {3.4984326517715178`*^9, 
   3.4984326721139536`*^9}, 3.498433303952264*^9, 3.498493187426281*^9, {
   3.498493823408998*^9, 3.498493836481821*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "2"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"c", "*", "B"}], "+", 
      RowBox[{"c", "*", "A", "*", 
       RowBox[{"Cos", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "*", "B"}], "-", 
         RowBox[{"b", "*", "A"}]}], ")"}], "*", 
       RowBox[{"Sin", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"e", "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "-", 
        RowBox[{"b", "^", "2"}], "-", 
        RowBox[{"c", "^", "2"}]}], ")"}], "*", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}]}], ")"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "A", ",", "B"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "A"}], "-", 
      RowBox[{"b", "*", "B"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984166961352453`*^9, 
   3.498431175169325*^9, 3.4984315237831373`*^9, 3.4984318251464663`*^9, 
   3.498431987628351*^9, 3.4984321755026813`*^9, 3.49843277822534*^9, 
   3.4984332805522223`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Reference: G&R 2.558.1 ",
 "with",
 "  ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   RowBox[{"-", "2"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, {3.49841670665526*^9, 
   3.498416730765294*^9}, 3.4984315342507553`*^9, 3.498432181820692*^9, {
   3.4984323991446743`*^9, 3.4984324154623027`*^9}, 3.498493191591488*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"], "-", 
     SuperscriptBox["c", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", "A"}], "-", 
     RowBox[{"b", " ", "B"}], "-", 
     RowBox[{"c", " ", "C"}]}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, 3.498411508837983*^9, {3.4984155639236603`*^9, 
   3.4984155645936613`*^9}, {3.4984168250854263`*^9, 3.498416828835431*^9}, {
   3.4984176812066245`*^9, 3.498417690706638*^9}, {3.4984314419453936`*^9, 
   3.4984314738318496`*^9}, 3.49843175923075*^9, {3.4984320994837475`*^9, 
   3.4984321010281506`*^9}, {3.4984322552188215`*^9, 
   3.4984322841256723`*^9}, {3.4984323834198465`*^9, 3.4984323866490517`*^9}, 
   3.498433305855467*^9, 3.498434928988719*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"C", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], "2"]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                          ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{
        RowBox[{"c", " ", "B"}], "-", 
        RowBox[{"b", " ", "C"}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", " ", "C"}], "-", 
           RowBox[{"c", " ", "A"}]}], ")"}], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", " ", "B"}], "-", 
           RowBox[{"b", " ", "A"}]}], ")"}], " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}]}], 
       RowBox[{"e", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Cos", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
          RowBox[{"c", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"a", " ", "A"}], "-", 
     RowBox[{"b", " ", "B"}], "-", 
     RowBox[{"c", " ", "C"}]}], 
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"], "-", 
     SuperscriptBox["c", "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"c", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, {3.4984069748816357`*^9, 
   3.498407000051671*^9}, {3.4984115253180065`*^9, 3.4984115658380632`*^9}, 
   3.4984117446983137`*^9, {3.4984157332238975`*^9, 3.49841574918392*^9}, {
   3.4984167480753183`*^9, 3.4984167773253593`*^9}, {3.4984192598788347`*^9, 
   3.4984192736088543`*^9}, {3.4984317085306616`*^9, 
   3.4984317224926863`*^9}, {3.4984318598565273`*^9, 
   3.4984319106266165`*^9}, {3.498432204378332*^9, 3.4984322333163824`*^9}, {
   3.4984323510497894`*^9, 3.4984323629994106`*^9}, 3.498432822467017*^9, 
   3.4984333084606714`*^9, 3.498433413617256*^9, 3.4984340815948296`*^9, 
   3.498434914808294*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "2"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"c", "*", "B"}], "-", 
       RowBox[{"b", "*", "C"}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "*", "C"}], "-", 
          RowBox[{"c", "*", "A"}]}], ")"}], "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "*", "B"}], "-", 
          RowBox[{"b", "*", "A"}]}], ")"}], "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "/", "\n", "    ", 
     RowBox[{"(", 
      RowBox[{"e", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "-", 
         RowBox[{"b", "^", "2"}], "-", 
         RowBox[{"c", "^", "2"}]}], ")"}], "*", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}]}], ")"}]}], " ", "+", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "*", "A"}], "-", 
         RowBox[{"b", "*", "B"}], "-", 
         RowBox[{"c", "*", "C"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "-", 
         RowBox[{"b", "^", "2"}], "-", 
         RowBox[{"c", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Cos", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"Sin", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "A", ",", "B", ",", 
        "C"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "A"}], "-", 
      RowBox[{"b", "*", "B"}], "-", 
      RowBox[{"c", "*", "C"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984166961352453`*^9, 
   3.498431175169325*^9, 3.4984315237831373`*^9, 3.4984318251464663`*^9, 
   3.498431987628351*^9, 3.4984321755026813`*^9, 3.49843232278254*^9, 
   3.4984327810177445`*^9, 3.4984333852876067`*^9, 3.498433681064126*^9, 
   3.498434875028224*^9},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Reference: G&R 2.558.1 with  ",
 Cell[BoxData[
  RowBox[{"B", "=", "0"}]]],
 "  and  ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   RowBox[{"-", "2"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, {3.49841670665526*^9, 
   3.498416730765294*^9}, 3.4984315342507553`*^9, 3.498432181820692*^9, {
   3.4984323991446743`*^9, 3.4984324154623027`*^9}, 3.498493185148677*^9, {
   3.498493360710185*^9, 3.4984933752026105`*^9}, {3.498493569424952*^9, 
   3.4984936181906376`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "2"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "*", "C"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "*", "C"}], "-", 
           RowBox[{"c", "*", "A"}]}], ")"}], "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{"b", "*", "A", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"e", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "-", 
         RowBox[{"b", "^", "2"}], "-", 
         RowBox[{"c", "^", "2"}]}], ")"}], "*", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}]}], ")"}]}], " ", "+", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "*", "A"}], "-", 
         RowBox[{"c", "*", "C"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "-", 
         RowBox[{"b", "^", "2"}], "-", 
         RowBox[{"c", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Cos", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"Sin", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "A", ",", "C"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "A"}], "-", 
      RowBox[{"c", "*", "C"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984166961352453`*^9, 
   3.498431175169325*^9, 3.4984315237831373`*^9, 3.4984318251464663`*^9, 
   3.498431987628351*^9, 3.4984321755026813`*^9, 3.49843232278254*^9},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Reference: G&R 2.558.1 with  ",
 Cell[BoxData[
  RowBox[{"C", "=", "0"}]]],
 "  and  ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   RowBox[{"-", "2"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, {3.49841670665526*^9, 
   3.498416730765294*^9}, 3.4984315342507553`*^9, 3.498432181820692*^9, {
   3.4984323991446743`*^9, 3.4984324154623027`*^9}, 3.4984931882998824`*^9, {
   3.4984938494142437`*^9, 3.4984938583374596`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "2"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"c", "*", "B"}], "+", 
       RowBox[{"c", "*", "A", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "*", "B"}], "-", 
          RowBox[{"b", "*", "A"}]}], ")"}], "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"e", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "-", 
         RowBox[{"b", "^", "2"}], "-", 
         RowBox[{"c", "^", "2"}]}], ")"}], "*", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}]}], ")"}]}], " ", "+", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "*", "A"}], "-", 
         RowBox[{"b", "*", "B"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "-", 
         RowBox[{"b", "^", "2"}], "-", 
         RowBox[{"c", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Cos", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"Sin", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "A", ",", "B"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "A"}], "-", 
      RowBox[{"b", "*", "B"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984166961352453`*^9, 
   3.498431175169325*^9, 3.4984315237831373`*^9, 3.4984318251464663`*^9, 
   3.498431987628351*^9, 3.4984321755026813`*^9, 3.49843232278254*^9, 
   3.4984327810177445`*^9, 3.4984333852876067`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.558.1", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, {3.49841670665526*^9, 
   3.498416730765294*^9}, 3.4984315342507553`*^9, 3.498432181820692*^9, {
   3.4984323991446743`*^9, 3.4984324154623027`*^9}, 3.498432451841566*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"], "-", 
     SuperscriptBox["c", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"n", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{"n", "\[NotEqual]", 
    RowBox[{"-", "2"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, 3.498411508837983*^9, {3.4984155639236603`*^9, 
   3.4984155645936613`*^9}, {3.4984168250854263`*^9, 3.498416828835431*^9}, {
   3.4984176812066245`*^9, 3.498417690706638*^9}, {3.4984314419453936`*^9, 
   3.4984314738318496`*^9}, 3.49843175923075*^9, {3.4984320994837475`*^9, 
   3.4984321010281506`*^9}, {3.4984322552188215`*^9, 
   3.4984322841256723`*^9}, {3.4984323834198465`*^9, 
   3.4984323866490517`*^9}, {3.498432480654817*^9, 3.498432493134839*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"C", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"c", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"c", " ", "B"}], "-", 
           RowBox[{"b", " ", "C"}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", " ", "C"}], "-", 
              RowBox[{"c", " ", "A"}]}], ")"}], " ", 
            RowBox[{"Cos", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", " ", "B"}], "-", 
              RowBox[{"b", " ", "A"}]}], ")"}], " ", 
            RowBox[{"Sin", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             RowBox[{"Cos", "[", 
              RowBox[{"d", "+", 
               RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
            RowBox[{"c", " ", 
             RowBox[{"Sin", "[", 
              RowBox[{"d", "+", 
               RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], 
          RowBox[{"n", "+", "1"}]]}], 
        RowBox[{"e", " ", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}]}]]}]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"], "-", 
       SuperscriptBox["c", "2"]}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", " ", "A"}], "-", 
          RowBox[{"b", " ", "B"}], "-", 
          RowBox[{"c", " ", "C"}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", " ", "B"}], "-", 
          RowBox[{"b", " ", "A"}]}], ")"}], " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", " ", "C"}], "-", 
          RowBox[{"c", " ", "A"}]}], ")"}], " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, {3.4984069748816357`*^9, 
   3.498407000051671*^9}, {3.4984115253180065`*^9, 3.4984115658380632`*^9}, 
   3.4984117446983137`*^9, {3.4984157332238975`*^9, 3.49841574918392*^9}, {
   3.4984167480753183`*^9, 3.4984167773253593`*^9}, {3.4984192598788347`*^9, 
   3.4984192736088543`*^9}, {3.4984317085306616`*^9, 
   3.4984317224926863`*^9}, {3.4984318598565273`*^9, 
   3.4984319106266165`*^9}, {3.498432204378332*^9, 3.4984322333163824`*^9}, {
   3.4984323510497894`*^9, 3.4984323629994106`*^9}, 3.4984325452077303`*^9, 
   3.4984328232938185`*^9, 3.4984333096306734`*^9, {3.4984334826161776`*^9, 
   3.4984334886845884`*^9}, 3.4984335853579583`*^9, 3.4984340846680355`*^9, 
   3.498435053898138*^9, {3.4984353108461895`*^9, 3.4984353292386217`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"c", "*", "B"}], "-", 
        RowBox[{"b", "*", "C"}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "*", "C"}], "-", 
           RowBox[{"c", "*", "A"}]}], ")"}], "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "*", "B"}], "-", 
           RowBox[{"b", "*", "A"}]}], ")"}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", "\n", "    ", 
      RowBox[{"(", 
       RowBox[{"e", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"c", "^", "2"}]}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}], "-", 
           RowBox[{"c", "^", "2"}]}], ")"}]}], ")"}]}], ",", "\n", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}], "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", "*", "A"}], "-", 
              RowBox[{"b", "*", "B"}], "-", 
              RowBox[{"c", "*", "C"}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"n", "+", "2"}], ")"}], "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", "*", "B"}], "-", 
              RowBox[{"b", "*", "A"}]}], ")"}], "*", 
            RowBox[{"Cos", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"n", "+", "2"}], ")"}], "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", "*", "C"}], "-", 
              RowBox[{"c", "*", "A"}]}], ")"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "*", "\n", 
         "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"Cos", "[", 
              RowBox[{"d", "+", 
               RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"Sin", "[", 
              RowBox[{"d", "+", 
               RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "A", ",", "B", ",", 
        "C"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984166961352453`*^9, 
   3.498431175169325*^9, 3.4984315237831373`*^9, 3.4984318251464663`*^9, 
   3.498431987628351*^9, 3.4984321755026813`*^9, 3.49843232278254*^9, {
   3.498432445679556*^9, 3.498432459017579*^9}, {3.498432698712*^9, 
   3.4984326997104015`*^9}, 3.4984327838257494`*^9, {3.4984334339128923`*^9, 
   3.498433453646927*^9}, {3.4984335361242714`*^9, 3.4984335398058777`*^9}, 
   3.4984336840905313`*^9, {3.4984349595179725`*^9, 3.498434974540799*^9}},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Reference: G&R 2.558.1 with  ",
 Cell[BoxData[
  RowBox[{"B", "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, {3.49841670665526*^9, 
   3.498416730765294*^9}, 3.4984315342507553`*^9, 3.498432181820692*^9, {
   3.4984323991446743`*^9, 3.4984324154623027`*^9}, 3.498432451841566*^9, {
   3.4984932863136544`*^9, 3.4984932883104577`*^9}, {3.498493319136112*^9, 
   3.498493325064122*^9}, 3.498493566616947*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", "*", "C"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "*", "C"}], "-", 
          RowBox[{"c", "*", "A"}]}], ")"}], "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
       RowBox[{"b", "*", "A", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", "\n", "    ", 
      RowBox[{"(", 
       RowBox[{"e", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"c", "^", "2"}]}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}], "-", 
           RowBox[{"c", "^", "2"}]}], ")"}]}], ")"}]}], ",", "\n", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}], "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", "*", "A"}], "-", 
              RowBox[{"c", "*", "C"}]}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"n", "+", "2"}], ")"}], "*", "b", "*", "A", "*", 
            RowBox[{"Cos", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"n", "+", "2"}], ")"}], "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", "*", "C"}], "-", 
              RowBox[{"c", "*", "A"}]}], ")"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "*", "\n", 
         "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"Cos", "[", 
              RowBox[{"d", "+", 
               RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"Sin", "[", 
              RowBox[{"d", "+", 
               RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "A", ",", "C"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984166961352453`*^9, 
   3.498431175169325*^9, 3.4984315237831373`*^9, 3.4984318251464663`*^9, 
   3.498431987628351*^9, 3.4984321755026813`*^9, 3.49843232278254*^9, {
   3.498432445679556*^9, 3.498432459017579*^9}, {3.498432698712*^9, 
   3.4984326997104015`*^9}},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Reference: G&R 2.558.1 with  ",
 Cell[BoxData[
  RowBox[{"C", "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, {3.49841670665526*^9, 
   3.498416730765294*^9}, 3.4984315342507553`*^9, 3.498432181820692*^9, {
   3.4984323991446743`*^9, 3.4984324154623027`*^9}, 3.498432451841566*^9, {
   3.498493865825473*^9, 3.4984938710046816`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"c", "*", "B"}], "+", 
        RowBox[{"c", "*", "A", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "*", "B"}], "-", 
           RowBox[{"b", "*", "A"}]}], ")"}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", "\n", "    ", 
      RowBox[{"(", 
       RowBox[{"e", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"c", "^", "2"}]}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}], "-", 
           RowBox[{"c", "^", "2"}]}], ")"}]}], ")"}]}], ",", "\n", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}], "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", "*", "A"}], "-", 
              RowBox[{"b", "*", "B"}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"n", "+", "2"}], ")"}], "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", "*", "B"}], "-", 
              RowBox[{"b", "*", "A"}]}], ")"}], "*", 
            RowBox[{"Cos", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"n", "+", "2"}], ")"}], "*", "c", "*", "A", "*", 
            RowBox[{"Sin", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "*", "\n", 
         "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"Cos", "[", 
              RowBox[{"d", "+", 
               RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"Sin", "[", 
              RowBox[{"d", "+", 
               RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "A", ",", "B"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984166961352453`*^9, 
   3.498431175169325*^9, 3.4984315237831373`*^9, 3.4984318251464663`*^9, 
   3.498431987628351*^9, 3.4984321755026813`*^9, 3.49843232278254*^9, {
   3.498432445679556*^9, 3.498432459017579*^9}, {3.498432698712*^9, 
   3.4984326997104015`*^9}, 3.4984327838257494`*^9, {3.4984334339128923`*^9, 
   3.498433453646927*^9}, {3.4984335361242714`*^9, 3.4984335398058777`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, {3.49841670665526*^9, 
   3.498416730765294*^9}, 3.4984315342507553`*^9, 3.498432181820692*^9, {
   3.4984323991446743`*^9, 3.4984324154623027`*^9}, 3.498432451841566*^9, 
   3.49843515735752*^9, 3.498435501447725*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", "z"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "z"}]}], ")"}], "n"]}], "=", 
   RowBox[{
    RowBox[{
     FractionBox["B", "b"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "z"}]}], ")"}], 
      RowBox[{"n", "+", "1"}]]}], "+", 
    RowBox[{
     FractionBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"A", " ", "b"}], "-", 
        RowBox[{"a", " ", "B"}]}], ")"}], "b"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "z"}]}], ")"}], "n"]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, {3.49841670665526*^9, 
   3.498416730765294*^9}, 3.4984315342507553`*^9, 3.498432181820692*^9, {
   3.4984323991446743`*^9, 3.4984324154623027`*^9}, 3.498432451841566*^9, 
   3.49843515735752*^9, {3.498435501447725*^9, 3.4984355267977695`*^9}, {
   3.4984357590977774`*^9, 3.4984357721082*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"b", " ", "C"}], "-", 
    RowBox[{"c", " ", "B"}]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"b", " ", "A"}], "-", 
      RowBox[{"a", " ", "B"}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{"n", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], " ", "\[Or]", " ", 
        RowBox[{
         SuperscriptBox["a", "2"], "-", 
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}]}], "=", "0"}]}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, 3.498411508837983*^9, {3.4984155639236603`*^9, 
   3.4984155645936613`*^9}, {3.4984168250854263`*^9, 3.498416828835431*^9}, {
   3.4984176812066245`*^9, 3.498417690706638*^9}, {3.4984314419453936`*^9, 
   3.4984314738318496`*^9}, 3.49843175923075*^9, {3.4984320994837475`*^9, 
   3.4984321010281506`*^9}, {3.4984322552188215`*^9, 
   3.4984322841256723`*^9}, {3.4984323834198465`*^9, 
   3.4984323866490517`*^9}, {3.498432480654817*^9, 3.498432493134839*^9}, {
   3.4984351727703466`*^9, 3.498435175422352*^9}, {3.498435264030507*^9, 
   3.498435269162916*^9}, {3.498435620023533*^9, 3.498435704185681*^9}, {
   3.4984952989331894`*^9, 3.4984952989331894`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"C", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"c", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                 ", 
      "\[IndentingNewLine]", "              ", 
      FractionBox["B", "b"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], 
       RowBox[{"n", "+", "1"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"b", " ", "A"}], "-", 
     RowBox[{"a", " ", "B"}]}], "b"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, {3.4984069748816357`*^9, 
   3.498407000051671*^9}, {3.4984115253180065`*^9, 3.4984115658380632`*^9}, 
   3.4984117446983137`*^9, {3.4984157332238975`*^9, 3.49841574918392*^9}, {
   3.4984167480753183`*^9, 3.4984167773253593`*^9}, {3.4984192598788347`*^9, 
   3.4984192736088543`*^9}, {3.4984317085306616`*^9, 
   3.4984317224926863`*^9}, {3.4984318598565273`*^9, 
   3.4984319106266165`*^9}, {3.498432204378332*^9, 3.4984322333163824`*^9}, {
   3.4984323510497894`*^9, 3.4984323629994106`*^9}, 3.4984325452077303`*^9, 
   3.4984328232938185`*^9, 3.4984333096306734`*^9, {3.4984334826161776`*^9, 
   3.4984334886845884`*^9}, 3.4984335853579583`*^9, 3.4984340846680355`*^9, 
   3.498435053898138*^9, 3.4984352319256506`*^9, {3.4984353475374537`*^9, 
   3.4984353561018686`*^9}, {3.4984355852822723`*^9, 
   3.4984356013659005`*^9}, {3.498435731626129*^9, 3.498435733295332*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"B", "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Cos", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"Sin", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}], ",", "x"}], "]"}]}], "]"}], " ", 
    "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "A"}], "-", 
         RowBox[{"a", "*", "B"}]}], ")"}], "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Cos", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"Sin", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], ",", 
        "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "A", ",", "B", ",", 
        "C"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "C"}], "-", 
      RowBox[{"c", "*", "B"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "==", 
       RowBox[{
        RowBox[{"-", "1"}], "/", "2"}]}], " ", "||", " ", 
      RowBox[{"ZeroQ", "[", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "-", 
        RowBox[{"b", "^", "2"}], "-", 
        RowBox[{"c", "^", "2"}]}], "]"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984166961352453`*^9, 
   3.498431175169325*^9, 3.4984315237831373`*^9, 3.4984318251464663`*^9, 
   3.498431987628351*^9, 3.4984321755026813`*^9, 3.49843232278254*^9, {
   3.498432445679556*^9, 3.498432459017579*^9}, {3.498432698712*^9, 
   3.4984326997104015`*^9}, 3.4984327838257494`*^9, {3.4984334339128923`*^9, 
   3.498433453646927*^9}, {3.4984335361242714`*^9, 3.4984335398058777`*^9}, 
   3.4984336840905313`*^9, {3.4984349595179725`*^9, 3.498434974540799*^9}, 
   3.498435149370306*^9, {3.4984351832535653`*^9, 3.49843518598357*^9}, 
   3.498435486861699*^9, {3.4984357147312994`*^9, 3.4984357253393183`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.558.1 inverted", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, {3.49841670665526*^9, 
   3.498416730765294*^9}, 3.4984315342507553`*^9, 3.498432181820692*^9, {
   3.4984323991446743`*^9, 3.4984324154623027`*^9}, 3.498432451841566*^9, 
   3.49843515735752*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"], "-", 
     SuperscriptBox["c", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, 3.498411508837983*^9, {3.4984155639236603`*^9, 
   3.4984155645936613`*^9}, {3.4984168250854263`*^9, 3.498416828835431*^9}, {
   3.4984176812066245`*^9, 3.498417690706638*^9}, {3.4984314419453936`*^9, 
   3.4984314738318496`*^9}, 3.49843175923075*^9, {3.4984320994837475`*^9, 
   3.4984321010281506`*^9}, {3.4984322552188215`*^9, 
   3.4984322841256723`*^9}, {3.4984323834198465`*^9, 
   3.4984323866490517`*^9}, {3.498432480654817*^9, 3.498432493134839*^9}, {
   3.4984351727703466`*^9, 3.498435175422352*^9}, {3.498435264030507*^9, 
   3.498435269162916*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"C", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"c", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"B", " ", "c"}], "-", 
          RowBox[{"b", " ", "C"}], "-", 
          RowBox[{"a", " ", "C", " ", 
           RowBox[{"Cos", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
          RowBox[{"a", " ", "B", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Cos", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
           RowBox[{"c", " ", 
            RowBox[{"Sin", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], "n"]}], 
       RowBox[{"a", " ", "e", " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "B"}], "+", 
          RowBox[{"c", " ", "C"}]}], ")"}], " ", "n"}], "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", "A", " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B", " ", "n"}], "+", 
          RowBox[{"c", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"b", " ", "C"}], "-", 
             RowBox[{"c", " ", "B"}]}], ")"}], " ", "n"}], "+", 
          RowBox[{"a", " ", "b", " ", "A", " ", 
           RowBox[{"(", 
            RowBox[{"n", "+", "1"}], ")"}]}]}], ")"}], " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "C", " ", "n"}], "-", 
          RowBox[{"b", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"b", " ", "C"}], "-", 
             RowBox[{"c", " ", "B"}]}], ")"}], " ", "n"}], "+", 
          RowBox[{"a", " ", "c", " ", "A", " ", 
           RowBox[{"(", 
            RowBox[{"n", "+", "1"}], ")"}]}]}], ")"}], " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, {3.4984069748816357`*^9, 
   3.498407000051671*^9}, {3.4984115253180065`*^9, 3.4984115658380632`*^9}, 
   3.4984117446983137`*^9, {3.4984157332238975`*^9, 3.49841574918392*^9}, {
   3.4984167480753183`*^9, 3.4984167773253593`*^9}, {3.4984192598788347`*^9, 
   3.4984192736088543`*^9}, {3.4984317085306616`*^9, 
   3.4984317224926863`*^9}, {3.4984318598565273`*^9, 
   3.4984319106266165`*^9}, {3.498432204378332*^9, 3.4984322333163824`*^9}, {
   3.4984323510497894`*^9, 3.4984323629994106`*^9}, 3.4984325452077303`*^9, 
   3.4984328232938185`*^9, 3.4984333096306734`*^9, {3.4984334826161776`*^9, 
   3.4984334886845884`*^9}, 3.4984335853579583`*^9, 3.4984340846680355`*^9, 
   3.498435053898138*^9, 3.4984352319256506`*^9, {3.4984353475374537`*^9, 
   3.4984353561018686`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"B", "*", "c"}], "-", 
       RowBox[{"b", "*", "C"}], "-", 
       RowBox[{"a", "*", "C", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
       RowBox[{"a", "*", "B", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "e", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}], ",", "\n", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"b", "*", "B"}], "+", 
              RowBox[{"c", "*", "C"}]}], ")"}], "*", "n"}], " ", "+", " ", 
           RowBox[{
            RowBox[{"a", "^", "2"}], "*", "A", "*", 
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}]}], " ", "+", " ", "\n", 
           "        ", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"a", "^", "2"}], "*", "B", "*", "n"}], " ", "+", " ", 
              RowBox[{"c", "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"b", "*", "C"}], "-", 
                 RowBox[{"c", "*", "B"}]}], ")"}], "*", "n"}], " ", "+", " ", 
              RowBox[{"a", "*", "b", "*", "A", "*", 
               RowBox[{"(", 
                RowBox[{"n", "+", "1"}], ")"}]}]}], ")"}], "*", 
            RowBox[{"Cos", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}], " ", "+", " ", "\n", 
           "        ", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"a", "^", "2"}], "*", "C", "*", "n"}], " ", "-", " ", 
              RowBox[{"b", "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"b", "*", "C"}], "-", 
                 RowBox[{"c", "*", "B"}]}], ")"}], "*", "n"}], " ", "+", " ", 
              RowBox[{"a", "*", "c", "*", "A", "*", 
               RowBox[{"(", 
                RowBox[{"n", "+", "1"}], ")"}]}]}], ")"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "*", "\n", 
         "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"Cos", "[", 
              RowBox[{"d", "+", 
               RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"Sin", "[", 
              RowBox[{"d", "+", 
               RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "A", ",", "B", ",", 
        "C"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984166961352453`*^9, 
   3.498431175169325*^9, 3.4984315237831373`*^9, 3.4984318251464663`*^9, 
   3.498431987628351*^9, 3.4984321755026813`*^9, 3.49843232278254*^9, {
   3.498432445679556*^9, 3.498432459017579*^9}, {3.498432698712*^9, 
   3.4984326997104015`*^9}, 3.4984327838257494`*^9, {3.4984334339128923`*^9, 
   3.498433453646927*^9}, {3.4984335361242714`*^9, 3.4984335398058777`*^9}, 
   3.4984336840905313`*^9, {3.4984349595179725`*^9, 3.498434974540799*^9}, 
   3.498435149370306*^9, {3.4984351832535653`*^9, 3.49843518598357*^9}, {
   3.515685390354463*^9, 3.515685402772085*^9}, 3.5156855096946726`*^9, 
   3.5156855962436247`*^9, 3.5157087316137652`*^9},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Reference: G&R 2.558.1 inverted with ",
 Cell[BoxData[
  RowBox[{"B", "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, {3.49841670665526*^9, 
   3.498416730765294*^9}, 3.4984315342507553`*^9, 3.498432181820692*^9, {
   3.4984323991446743`*^9, 3.4984324154623027`*^9}, 3.498432451841566*^9, 
   3.49843515735752*^9, {3.5156851230667934`*^9, 3.5156851358744164`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "*", "C"}], "+", 
        RowBox[{"a", "*", "C", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "e", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}], ",", "\n", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "*", "c", "*", "C", "*", "n"}], "+", 
           RowBox[{
            RowBox[{"a", "^", "2"}], "*", "A", "*", 
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"c", "*", "b", "*", "C", "*", "n"}], "+", 
              RowBox[{"a", "*", "b", "*", "A", "*", 
               RowBox[{"(", 
                RowBox[{"n", "+", "1"}], ")"}]}]}], ")"}], "*", 
            RowBox[{"Cos", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"a", "^", "2"}], "*", "C", "*", "n"}], "-", 
              RowBox[{
               RowBox[{"b", "^", "2"}], "*", "C", "*", "n"}], "+", 
              RowBox[{"a", "*", "c", "*", "A", "*", 
               RowBox[{"(", 
                RowBox[{"n", "+", "1"}], ")"}]}]}], ")"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "*", "\n", 
         "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"Cos", "[", 
              RowBox[{"d", "+", 
               RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"Sin", "[", 
              RowBox[{"d", "+", 
               RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "A", ",", "C"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984166961352453`*^9, 
   3.498431175169325*^9, 3.4984315237831373`*^9, 3.4984318251464663`*^9, 
   3.498431987628351*^9, 3.4984321755026813`*^9, 3.49843232278254*^9, {
   3.498432445679556*^9, 3.498432459017579*^9}, {3.498432698712*^9, 
   3.4984326997104015`*^9}, 3.4984327838257494`*^9, {3.4984334339128923`*^9, 
   3.498433453646927*^9}, {3.4984335361242714`*^9, 3.4984335398058777`*^9}, 
   3.4984336840905313`*^9, {3.4984349595179725`*^9, 3.498434974540799*^9}, 
   3.498435149370306*^9, {3.4984351832535653`*^9, 3.49843518598357*^9}, {
   3.5156851484636383`*^9, 3.515685200271329*^9}, {3.515685332681162*^9, 
   3.515685383552851*^9}, {3.515685428012929*^9, 3.5156854282157297`*^9}, 
   3.5156855071986685`*^9, 3.5156855938724203`*^9, 3.515708736168973*^9},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Reference: G&R 2.558.1 inverted with ",
 Cell[BoxData[
  RowBox[{"C", "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840706356176*^9, {
   3.49841147078793*^9, 3.498411498977969*^9}, {3.4984125380994244`*^9, 
   3.4984125557694488`*^9}, 3.4984157725339527`*^9, {3.49841670665526*^9, 
   3.498416730765294*^9}, 3.4984315342507553`*^9, 3.498432181820692*^9, {
   3.4984323991446743`*^9, 3.4984324154623027`*^9}, 3.498432451841566*^9, 
   3.49843515735752*^9, {3.5156851230667934`*^9, 3.515685143315629*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"B", "*", "c"}], "+", 
       RowBox[{"a", "*", "B", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "e", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}], ",", "\n", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "*", "b", "*", "B", "*", "n"}], "+", 
           RowBox[{
            RowBox[{"a", "^", "2"}], "*", "A", "*", 
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"a", "^", "2"}], "*", "B", "*", "n"}], "-", 
              RowBox[{
               RowBox[{"c", "^", "2"}], "*", "B", "*", "n"}], "+", 
              RowBox[{"a", "*", "b", "*", "A", "*", 
               RowBox[{"(", 
                RowBox[{"n", "+", "1"}], ")"}]}]}], ")"}], "*", 
            RowBox[{"Cos", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"b", "*", "c", "*", "B", "*", "n"}], "+", 
              RowBox[{"a", "*", "c", "*", "A", "*", 
               RowBox[{"(", 
                RowBox[{"n", "+", "1"}], ")"}]}]}], ")"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "*", "\n", 
         "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"Cos", "[", 
              RowBox[{"d", "+", 
               RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"Sin", "[", 
              RowBox[{"d", "+", 
               RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "A", ",", "B"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.498411453827906*^9, 
   3.4984127269796886`*^9, 3.498415555673649*^9, 3.4984166961352453`*^9, 
   3.498431175169325*^9, 3.4984315237831373`*^9, 3.4984318251464663`*^9, 
   3.498431987628351*^9, 3.4984321755026813`*^9, 3.49843232278254*^9, {
   3.498432445679556*^9, 3.498432459017579*^9}, {3.498432698712*^9, 
   3.4984326997104015`*^9}, 3.4984327838257494`*^9, {3.4984334339128923`*^9, 
   3.498433453646927*^9}, {3.4984335361242714`*^9, 3.4984335398058777`*^9}, 
   3.4984336840905313`*^9, {3.4984349595179725`*^9, 3.498434974540799*^9}, 
   3.498435149370306*^9, {3.4984351832535653`*^9, 3.49843518598357*^9}, {
   3.515685208227343*^9, 3.515685278209066*^9}, {3.5156854646729937`*^9, 
   3.515685505623066*^9}, 3.515685592156418*^9, 3.5157087379005766`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]]
},
AutoGeneratedPackage->Automatic,
CellGrouping->Manual,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  "Integration Rules for Rational Functions of Sines and Cosines", None, 
   None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->28.8},
Magnification->1.399999976158142,
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 1468, 32, 118, "Title"],
Cell[2038, 56, 377, 5, 1409, "Subsubsection"],
Cell[2418, 63, 842, 24, 1409, "Subsubsection"],
Cell[3263, 89, 1414, 29, 1409, "Subsubsection"],
Cell[4680, 120, 2130, 49, 1409, "Subsubtitle"],
Cell[6813, 171, 771, 11, 1409, "Subsubsection"],
Cell[7587, 184, 2042, 57, 1409, "Code"],
Cell[9632, 243, 89, 2, 1409, "Subsubsection"],
Cell[9724, 247, 523, 9, 1409, "Subsubsection"],
Cell[10250, 258, 1285, 38, 1409, "Subsubsection"],
Cell[11538, 298, 893, 25, 1409, "Subsubsection"],
Cell[12434, 325, 1523, 32, 1409, "Subsubsection"],
Cell[13960, 359, 2760, 69, 1409, "Subsubtitle"],
Cell[16723, 430, 771, 11, 1409, "Subsubsection"],
Cell[17497, 443, 2830, 79, 1409, "Code"],
Cell[20330, 524, 44, 1, 1409, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[20411, 530, 1498, 33, 99, "Title"],
Cell[21912, 565, 377, 5, 1409, "Subsubsection"],
Cell[22292, 572, 842, 24, 1409, "Subsubsection"],
Cell[23137, 598, 1414, 29, 1409, "Subsubsection"],
Cell[24554, 629, 2294, 53, 1409, "Subsubtitle"],
Cell[26851, 684, 771, 11, 1409, "Subsubsection"],
Cell[27625, 697, 2168, 60, 1409, "Code"],
Cell[29796, 759, 89, 2, 1409, "Subsubsection"],
Cell[29888, 763, 523, 9, 1409, "Subsubsection"],
Cell[30414, 774, 1311, 39, 1409, "Subsubsection"],
Cell[31728, 815, 893, 25, 1409, "Subsubsection"],
Cell[32624, 842, 1523, 32, 1409, "Subsubsection"],
Cell[34150, 876, 2870, 72, 1409, "Subsubtitle"],
Cell[37023, 950, 771, 11, 1409, "Subsubsection"],
Cell[37797, 963, 2970, 82, 1409, "Code"],
Cell[40770, 1047, 44, 1, 1409, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[40851, 1053, 1486, 32, 80, "Title"],
Cell[42340, 1087, 1144, 22, 510, "Subsubsection"],
Cell[43487, 1111, 1702, 43, 893, "Subsubtitle"],
Cell[45192, 1156, 771, 11, 495, "Subsubsection"],
Cell[45966, 1169, 1635, 47, 1510, "Code"],
Cell[47604, 1218, 89, 2, 495, "Subsubsection"],
Cell[47696, 1222, 365, 5, 340, "Subsubsection"],
Cell[48064, 1229, 1202, 22, 365, "Subsubsection"],
Cell[49269, 1253, 2178, 51, 916, "Subsubtitle"],
Cell[51450, 1306, 771, 11, 495, "Subsubsection"],
Cell[52224, 1319, 1762, 51, 1510, "Code"],
Cell[53989, 1372, 89, 2, 495, "Subsubsection"],
Cell[54081, 1376, 438, 6, 340, "Subsubsection"],
Cell[54522, 1384, 508, 7, 340, "Subsubsection"],
Cell[55033, 1393, 1632, 48, 638, "Subsubsection"],
Cell[56668, 1443, 732, 14, 365, "Subsubsection"],
Cell[57403, 1459, 1601, 31, 551, "Subsubsection"],
Cell[59007, 1492, 2555, 60, 848, "Subsubtitle"],
Cell[61565, 1554, 771, 11, 495, "Subsubsection"],
Cell[62339, 1567, 2524, 68, 1510, "Code"],
Cell[64866, 1637, 89, 2, 495, "Subsubsection"],
Cell[64958, 1641, 551, 8, 340, "Subsubsection"],
Cell[65512, 1651, 1657, 32, 551, "Subsubsection"],
Cell[67172, 1685, 3511, 88, 1693, "Subsubtitle"],
Cell[70686, 1775, 771, 11, 495, "Subsubsection"],
Cell[71460, 1788, 3375, 96, 1882, "Code"],
Cell[74838, 1886, 89, 2, 495, "Subsubsection"],
Cell[74930, 1890, 551, 8, 340, "Subsubsection"],
Cell[75484, 1900, 1667, 31, 495, "Subsubsection"],
Cell[77154, 1933, 3735, 95, 1749, "Subsubtitle"],
Cell[80892, 2030, 771, 11, 495, "Subsubsection"],
Cell[81666, 2043, 3712, 106, 1882, "Code"],
Cell[85381, 2151, 44, 1, 37, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[85462, 2157, 1852, 43, 92, "Title"],
Cell[87317, 2202, 400, 6, 35, "Subsubsection"],
Cell[87720, 2210, 1460, 45, 42, "Subsubsection"],
Cell[89183, 2257, 1454, 30, 35, "Subsubsection"],
Cell[90640, 2289, 3515, 103, 126, "Subsubtitle"],
Cell[94158, 2394, 771, 11, 35, "Subsubsection"],
Cell[94932, 2407, 4310, 125, 154, "Code"],
Cell[99245, 2534, 89, 2, 35, "Subsubsection"],
Cell[99337, 2538, 400, 6, 25, "Subsubsection"],
Cell[99740, 2546, 1460, 45, 42, "Subsubsection"],
Cell[101203, 2593, 1566, 32, 35, "Subsubsection"],
Cell[102772, 2627, 4840, 134, 220, "Subsubtitle"],
Cell[107615, 2763, 771, 11, 35, "Subsubsection"],
Cell[108389, 2776, 5199, 152, 154, "Code"],
Cell[113591, 2930, 89, 2, 35, "Subsubsection"],
Cell[113683, 2934, 400, 6, 25, "Subsubsection"],
Cell[114086, 2942, 1451, 44, 47, "Subsubsection"],
Cell[115540, 2988, 1452, 27, 35, "Subsubsection"],
Cell[116995, 3017, 3628, 95, 126, "Subsubtitle"],
Cell[120626, 3114, 771, 11, 35, "Subsubsection"],
Cell[121400, 3127, 4146, 122, 179, "Code"],
Cell[125549, 3251, 89, 2, 35, "Subsubsection"],
Cell[125641, 3255, 400, 6, 25, "Subsubsection"],
Cell[126044, 3263, 1479, 45, 47, "Subsubsection"],
Cell[127526, 3310, 1452, 27, 35, "Subsubsection"],
Cell[128981, 3339, 3680, 96, 126, "Subsubtitle"],
Cell[132664, 3437, 771, 11, 35, "Subsubsection"],
Cell[133438, 3450, 4168, 122, 179, "Code"],
Cell[137609, 3574, 89, 2, 1409, "Subsubsection"],
Cell[137701, 3578, 400, 6, 1409, "Subsubsection"],
Cell[138104, 3586, 1198, 34, 1409, "Subsubsection"],
Cell[139305, 3622, 1169, 16, 1409, "Subsubsection"],
Cell[140477, 3640, 3125, 76, 1409, "Subsubtitle"],
Cell[143605, 3718, 771, 11, 1409, "Subsubsection"],
Cell[144379, 3731, 2660, 73, 1409, "Code"],
Cell[147042, 3806, 89, 2, 1409, "Subsubsection"],
Cell[147134, 3810, 400, 6, 1409, "Subsubsection"],
Cell[147537, 3818, 1220, 34, 1409, "Subsubsection"],
Cell[148760, 3854, 1169, 16, 1409, "Subsubsection"],
Cell[149932, 3872, 3173, 76, 1409, "Subsubtitle"],
Cell[153108, 3950, 771, 11, 1409, "Subsubsection"],
Cell[153882, 3963, 2688, 74, 1409, "Code"],
Cell[156573, 4039, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[156654, 4045, 1582, 33, 89, "Title"],
Cell[158239, 4080, 491, 7, 1409, "Subsubsection"],
Cell[158733, 4089, 1168, 21, 1409, "Subsubsection"],
Cell[159904, 4112, 1672, 41, 1409, "Subsubtitle"],
Cell[161579, 4155, 771, 11, 1409, "Subsubsection"],
Cell[162353, 4168, 1533, 43, 1409, "Code"],
Cell[163889, 4213, 89, 2, 1409, "Subsubsection"],
Cell[163981, 4217, 491, 7, 1409, "Subsubsection"],
Cell[164475, 4226, 1216, 21, 1409, "Subsubsection"],
Cell[165694, 4249, 1723, 43, 1409, "Subsubtitle"],
Cell[167420, 4294, 771, 11, 1409, "Subsubsection"],
Cell[168194, 4307, 1585, 44, 1409, "Code"],
Cell[169782, 4353, 89, 2, 1409, "Subsubsection"],
Cell[169874, 4357, 416, 6, 1409, "Subsubsection"],
Cell[170293, 4365, 1334, 25, 1409, "Subsubsection"],
Cell[171630, 4392, 2322, 54, 1409, "Subsubtitle"],
Cell[173955, 4448, 771, 11, 1409, "Subsubsection"],
Cell[174729, 4461, 2011, 57, 1409, "Code"],
Cell[176743, 4520, 89, 2, 1409, "Subsubsection"],
Cell[176835, 4524, 448, 6, 1409, "Subsubsection"],
Cell[177286, 4532, 1592, 31, 1409, "Subsubsection"],
Cell[178881, 4565, 2474, 59, 1409, "Subsubtitle"],
Cell[181358, 4626, 771, 11, 1409, "Subsubsection"],
Cell[182132, 4639, 2465, 70, 1409, "Code"],
Cell[184600, 4711, 89, 2, 1409, "Subsubsection"],
Cell[184692, 4715, 478, 7, 1409, "Subsubsection"],
Cell[185173, 4724, 1700, 34, 1409, "Subsubsection"],
Cell[186876, 4760, 2578, 62, 1409, "Subsubtitle"],
Cell[189457, 4824, 771, 11, 1409, "Subsubsection"],
Cell[190231, 4837, 2564, 73, 1409, "Code"],
Cell[192798, 4912, 44, 1, 1409, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[192879, 4918, 1500, 32, 80, "Title"],
Cell[194382, 4952, 764, 21, 1409, "Subsubsection"],
Cell[195149, 4975, 1202, 23, 1409, "Subsubsection"],
Cell[196354, 5000, 2043, 53, 1409, "Subsubtitle"],
Cell[198400, 5055, 771, 11, 1409, "Subsubsection"],
Cell[199174, 5068, 1999, 58, 1409, "Code"],
Cell[201176, 5128, 89, 2, 1409, "Subsubsection"],
Cell[201268, 5132, 405, 6, 1409, "Subsubsection"],
Cell[201676, 5140, 907, 25, 1409, "Subsubsection"],
Cell[202586, 5167, 1484, 31, 1409, "Subsubsection"],
Cell[204073, 5200, 2170, 49, 1409, "Subsubtitle"],
Cell[206246, 5251, 771, 11, 1409, "Subsubsection"],
Cell[207020, 5264, 2007, 55, 1409, "Code"],
Cell[209030, 5321, 89, 2, 1409, "Subsubsection"],
Cell[209122, 5325, 523, 9, 1409, "Subsubsection"],
Cell[209648, 5336, 1387, 40, 1409, "Subsubsection"],
Cell[211038, 5378, 907, 25, 1409, "Subsubsection"],
Cell[211948, 5405, 1595, 34, 1409, "Subsubsection"],
Cell[213546, 5441, 3522, 91, 1409, "Subsubtitle"],
Cell[217071, 5534, 771, 11, 1409, "Subsubsection"],
Cell[217845, 5547, 3701, 104, 1409, "Code"],
Cell[221549, 5653, 44, 1, 1409, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[221630, 5659, 1582, 34, 99, "Title"],
Cell[223215, 5695, 625, 10, 1409, "Subsubsection"],
Cell[223843, 5707, 1014, 27, 1409, "Subsubsection"],
Cell[224860, 5736, 1364, 26, 1409, "Subsubsection"],
Cell[226227, 5764, 1992, 48, 1409, "Subsubtitle"],
Cell[228222, 5814, 771, 11, 1409, "Subsubsection"],
Cell[228996, 5827, 1937, 52, 1409, "Code"],
Cell[230936, 5881, 89, 2, 1409, "Subsubsection"],
Cell[231028, 5885, 523, 9, 1409, "Subsubsection"],
Cell[231554, 5896, 1492, 41, 1409, "Subsubsection"],
Cell[233049, 5939, 1014, 27, 1409, "Subsubsection"],
Cell[234066, 5968, 1684, 37, 1409, "Subsubsection"],
Cell[235753, 6007, 3273, 88, 1409, "Subsubtitle"],
Cell[239029, 6097, 771, 11, 1409, "Subsubsection"],
Cell[239803, 6110, 3756, 105, 1409, "Code"],
Cell[243562, 6217, 44, 1, 1409, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[243643, 6223, 1522, 33, 80, "Title"],
Cell[245168, 6258, 630, 16, 1409, "Subsubsection"],
Cell[245801, 6276, 1506, 29, 1409, "Subsubsection"],
Cell[247310, 6307, 3568, 90, 1409, "Subsubtitle"],
Cell[250881, 6399, 771, 11, 1409, "Subsubsection"],
Cell[251655, 6412, 3210, 91, 1409, "Code"],
Cell[254868, 6505, 89, 2, 1409, "Subsubsection"],
Cell[254960, 6509, 571, 8, 1409, "Subsubsection"],
Cell[255534, 6519, 1567, 29, 1409, "Subsubsection"],
Cell[257104, 6550, 4456, 112, 1409, "Subsubtitle"],
Cell[261563, 6664, 771, 11, 1409, "Subsubsection"],
Cell[262337, 6677, 4085, 113, 1409, "Code"],
Cell[266425, 6792, 44, 1, 1409, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[266506, 6798, 1629, 35, 89, "Title"],
Cell[268138, 6835, 954, 21, 1409, "Subsubsection"],
Cell[269095, 6858, 1441, 28, 1409, "Subsubsection"],
Cell[270539, 6888, 3561, 91, 1409, "Subsubtitle"],
Cell[274103, 6981, 771, 11, 1409, "Subsubsection"],
Cell[274877, 6994, 3347, 96, 1409, "Code"],
Cell[278227, 7092, 89, 2, 1409, "Subsubsection"],
Cell[278319, 7096, 656, 15, 1409, "Subsubsection"],
Cell[278978, 7113, 1314, 24, 1409, "Subsubsection"],
Cell[280295, 7139, 3177, 83, 1409, "Subsubtitle"],
Cell[283475, 7224, 771, 11, 1409, "Subsubsection"],
Cell[284249, 7237, 2988, 87, 1409, "Code"],
Cell[287240, 7326, 89, 2, 1409, "Subsubsection"],
Cell[287332, 7330, 835, 18, 1409, "Subsubsection"],
Cell[288170, 7350, 1314, 24, 1409, "Subsubsection"],
Cell[289487, 7376, 3426, 88, 1409, "Subsubtitle"],
Cell[292916, 7466, 771, 11, 1409, "Subsubsection"],
Cell[293690, 7479, 3269, 92, 1409, "Code"],
Cell[296962, 7573, 89, 2, 1409, "Subsubsection"],
Cell[297054, 7577, 691, 10, 1409, "Subsubsection"],
Cell[297748, 7589, 1709, 34, 1409, "Subsubsection"],
Cell[299460, 7625, 4250, 113, 1409, "Subsubtitle"],
Cell[303713, 7740, 771, 11, 1409, "Subsubsection"],
Cell[304487, 7753, 4548, 128, 1409, "Code"],
Cell[309038, 7883, 44, 1, 1409, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[309119, 7889, 2068, 46, 80, "Title"],
Cell[311190, 7937, 1483, 25, 69, "Subsubsection"],
Cell[312676, 7964, 1677, 29, 50, "Subsubsection"],
Cell[314356, 7995, 4260, 109, 246, "Subsubtitle"],
Cell[318619, 8106, 771, 11, 67, "Subsubsection"],
Cell[319393, 8119, 4373, 117, 251, "Code"],
Cell[323769, 8238, 3983, 103, 271, "Code"],
Cell[327755, 8343, 4014, 102, 271, "Code"],
Cell[331772, 8447, 89, 2, 67, "Subsubsection"],
Cell[331864, 8451, 1228, 29, 55, "Subsubsection"],
Cell[333095, 8482, 1924, 40, 67, "Subsubsection"],
Cell[335022, 8524, 3099, 77, 130, "Subsubtitle"],
Cell[338124, 8603, 771, 11, 67, "Subsubsection"],
Cell[338898, 8616, 3478, 96, 202, "Code"],
Cell[342379, 8714, 1189, 26, 75, "Subsubsection"],
Cell[343571, 8742, 2876, 78, 202, "Code"],
Cell[346450, 8822, 1209, 26, 75, "Subsubsection"],
Cell[347662, 8850, 2916, 78, 202, "Code"],
Cell[350581, 8930, 89, 2, 67, "Subsubsection"],
Cell[350673, 8934, 563, 8, 47, "Subsubsection"],
Cell[351239, 8944, 1913, 40, 67, "Subsubsection"],
Cell[353155, 8986, 3734, 103, 260, "Subsubtitle"],
Cell[356892, 9091, 771, 11, 67, "Subsubsection"],
Cell[357666, 9104, 4466, 128, 251, "Code"],
Cell[362135, 9234, 681, 13, 96, "Subsubsection"],
Cell[362819, 9249, 3782, 109, 351, "Code"],
Cell[366604, 9360, 681, 13, 96, "Subsubsection"],
Cell[367288, 9375, 3919, 111, 419, "Code"],
Cell[371210, 9488, 89, 2, 130, "Subsubsection"],
Cell[371302, 9492, 1049, 25, 96, "Subsubsection"],
Cell[372354, 9519, 1808, 34, 130, "Subsubsection"],
Cell[374165, 9555, 3213, 83, 253, "Subsubtitle"],
Cell[377381, 9640, 771, 11, 130, "Subsubsection"],
Cell[378155, 9653, 3306, 93, 687, "Code"],
Cell[381464, 9748, 1138, 26, 187, "Subsubsection"],
Cell[382605, 9776, 2898, 83, 551, "Code"],
Cell[385506, 9861, 1054, 25, 365, "Subsubsection"],
Cell[386563, 9888, 2912, 83, 1079, "Code"],
Cell[389478, 9973, 89, 2, 354, "Subsubsection"],
Cell[389570, 9977, 756, 16, 261, "Subsubsection"],
Cell[390329, 9995, 1837, 35, 354, "Subsubsection"],
Cell[392169, 10032, 4175, 110, 1320, "Subsubtitle"],
Cell[396347, 10144, 771, 11, 354, "Subsubsection"],
Cell[397121, 10157, 4267, 122, 1605, "Code"],
Cell[401391, 10281, 906, 19, 365, "Subsubsection"],
Cell[402300, 10302, 3810, 110, 1345, "Code"],
Cell[406113, 10414, 858, 18, 365, "Subsubsection"],
Cell[406974, 10434, 3826, 110, 1345, "Code"],
Cell[410803, 10546, 89, 2, 354, "Subsubsection"],
Cell[410895, 10550, 661, 9, 243, "Subsubsection"],
Cell[411559, 10561, 1815, 34, 354, "Subsubsection"],
Cell[413377, 10597, 5508, 148, 1936, "Subsubtitle"],
Cell[418888, 10747, 771, 11, 354, "Subsubsection"],
Cell[419662, 10760, 5881, 163, 2134, "Code"],
Cell[425546, 10925, 853, 15, 365, "Subsubsection"],
Cell[426402, 10942, 5164, 146, 2134, "Code"],
Cell[431569, 11090, 779, 14, 365, "Subsubsection"],
Cell[432351, 11106, 5326, 148, 2134, "Code"],
Cell[437680, 11256, 89, 2, 354, "Subsubsection"],
Cell[437772, 11260, 722, 10, 243, "Subsubsection"],
Cell[438497, 11272, 1511, 41, 377, "Subsubsection"],
Cell[440011, 11315, 2286, 46, 394, "Subsubsection"],
Cell[442300, 11363, 3599, 89, 1114, "Subsubtitle"],
Cell[445902, 11454, 771, 11, 354, "Subsubsection"],
Cell[446676, 11467, 4105, 109, 251, "Code"],
Cell[450784, 11578, 89, 2, 67, "Subsubsection"],
Cell[450876, 11582, 695, 10, 47, "Subsubsection"],
Cell[451574, 11594, 1898, 34, 67, "Subsubsection"],
Cell[453475, 11630, 5414, 142, 331, "Subsubtitle"],
Cell[458892, 11774, 771, 11, 67, "Subsubsection"],
Cell[459666, 11787, 6040, 158, 447, "Code"],
Cell[465709, 11947, 810, 14, 69, "Subsubsection"],
Cell[466522, 11963, 5230, 136, 349, "Code"],
Cell[471755, 12101, 808, 14, 69, "Subsubsection"],
Cell[472566, 12117, 5126, 134, 349, "Code"],
Cell[477695, 12253, 44, 1, 6, "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}
]
*)

(* End of internal cache information *)
