(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    118095,       3060]
NotebookOptionsPosition[    112979,       2927]
NotebookOutlinePosition[    114100,       2966]
CellTagsIndexPosition[    114057,       2963]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"FresnelS", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, 
   3.494271020504171*^9, 3.4942748840295796`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494271052164215*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"FresnelS", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], " ", 
        RowBox[{"FresnelS", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], "]"}]}], "b"]}]}]}]}], "+", 
  FractionBox[
   RowBox[{"Cos", "[", 
    RowBox[{
     FractionBox["\[Pi]", "2"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "2"]}], "]"}], 
   RowBox[{"b", " ", "\[Pi]"}]]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.494271065404234*^9, 3.494271092894272*^9}, {
   3.4942748853695817`*^9, 3.494274885819582*^9}, {3.49427520553003*^9, 
   3.4942752081100335`*^9}, 3.494275282820138*^9, 3.494275620950611*^9, {
   3.494275659070665*^9, 3.494275669300679*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"FresnelS", "[", 
     RowBox[{"a_.", "+", 
      RowBox[{"b_.", "*", "x_"}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"FresnelS", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "/", "b"}]}], " ", "+", " ", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{
       RowBox[{"Pi", "/", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"b", "*", "Pi"}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4942710790942526`*^9, {
   3.494274886279583*^9, 3.494274886619583*^9}, 3.494275237140074*^9, 
   3.494275316250185*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"FresnelC", "[", 
     RowBox[{"a_.", "+", 
      RowBox[{"b_.", "*", "x_"}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"FresnelC", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "/", "b"}]}], " ", "-", " ", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"Pi", "/", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"b", "*", "Pi"}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4942710790942526`*^9, {
   3.494274886279583*^9, 3.494274886619583*^9}, 3.494275237140074*^9, 
   3.494275316250185*^9, {3.4942802052356625`*^9, 3.4942802056100636`*^9}, 
   3.4942802935830173`*^9, 3.494280373998758*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494271179104393*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"FresnelS", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"FresnelS", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], "b"]}]}]}]}], "-", 
  RowBox[{"2", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], " ", 
     RowBox[{"Sin", "[", 
      RowBox[{
       FractionBox["\[Pi]", "2"], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "2"]}], "]"}], " ", 
     RowBox[{"FresnelS", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4942711908644094`*^9, 3.494271193814413*^9}, {
   3.4942712250044575`*^9, 3.49427123430447*^9}, {3.4942748881795855`*^9, 
   3.4942748888195868`*^9}, 3.4942757184607477`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"FresnelS", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "2"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"FresnelS", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", "2"}], "/", "b"}]}], " ", "-",
     "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{"2", ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"Pi", "/", "2"}], "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}]}], "]"}], "*", 
         RowBox[{"FresnelS", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], "]"}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494271202714426*^9, {
   3.4942748891095867`*^9, 3.4942748896095877`*^9}, 3.494275326410199*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"FresnelC", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "2"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"FresnelC", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", "2"}], "/", "b"}]}], " ", "-",
     "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{"2", ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}], "*", 
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{"Pi", "/", "2"}], "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}]}], "]"}], "*", 
         RowBox[{"FresnelC", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], "]"}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494271202714426*^9, {
   3.4942748891095867`*^9, 3.4942748896095877`*^9}, 3.494275326410199*^9, {
   3.4942802085896683`*^9, 3.4942802093228693`*^9}, 3.494280256674553*^9, 
   3.4942803342354884`*^9, 3.4942803838423753`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"FresnelS", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, 
   3.494271020504171*^9, 3.494271272164523*^9, 3.494274889879588*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: ",
 "If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494271052164215*^9, {
   3.494271408804714*^9, 3.494271432974748*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    RowBox[{"FresnelS", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        RowBox[{"FresnelS", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], "]"}]}], 
       RowBox[{"m", "+", "1"}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox["b", 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "1"}]], " ", 
     RowBox[{"Sin", "[", 
      RowBox[{
       FractionBox["\[Pi]", "2"], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "2"]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.494271065404234*^9, 3.494271092894272*^9}, {
   3.4942713522746353`*^9, 3.494271366464655*^9}, {3.4942748901595883`*^9, 
   3.4942748904295883`*^9}, 3.4942752868801436`*^9, 3.4942758036008673`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"FresnelS", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"FresnelS", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "/", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"Pi", "/", "2"}], "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}]}], "]"}]}], ",", 
        "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4942710790942526`*^9, 
   3.4942713187345886`*^9, {3.494274890699589*^9, 3.494274890969589*^9}, 
   3.494275245700086*^9, 3.494275336340213*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"FresnelC", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"FresnelC", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "/", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{"Pi", "/", "2"}], "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}]}], "]"}]}], ",", 
        "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4942710790942526`*^9, 
   3.4942713187345886`*^9, {3.494274890699589*^9, 3.494274890969589*^9}, 
   3.494275245700086*^9, 3.494275336340213*^9, {3.49428020944767*^9, 
   3.49428020947887*^9}, 3.4942802584373555`*^9, 3.4942803361230917`*^9, 
   3.4942803931711917`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9}],

Cell[TextData[{
 "Note: Also apply rule when m mod 4 = 1 when a closed-form antiderivative is \
defined for ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Cos", "[", 
    FractionBox[
     RowBox[{"\[Pi]", " ", 
      SuperscriptBox["x", "2"]}], "2"], "]"}], " ", 
   RowBox[{"FresnelS", "[", "x", "]"}]}]]],
 "."
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494275839400917*^9, 3.494275860030946*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"m", ">", "0"}], " ", "\[And]", "  ", 
       RowBox[{
        FractionBox["m", "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}]}], 
      " ", "\[Or]", " ", 
      RowBox[{"m", " ", "mod", " ", "4"}]}], "=", "3"}], ")"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4942714693347993`*^9, 
   3.4942715340348897`*^9}, {3.4942715837849593`*^9, 
   3.4942715950249753`*^9}, {3.4942716458250465`*^9, 3.494271658445064*^9}, 
   3.494272339896018*^9, {3.4942761159913044`*^9, 3.494276140971339*^9}, 
   3.494276199161421*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"FresnelS", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "2"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"FresnelS", "[", 
          RowBox[{"b", " ", "x"}], "]"}], "2"]}], 
       RowBox[{"m", "+", "1"}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", "b"}], 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "1"}]], " ", 
     RowBox[{"Sin", "[", 
      RowBox[{
       FractionBox["\[Pi]", "2"], 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["x", "2"]}], "]"}], " ", 
     RowBox[{"FresnelS", "[", 
      RowBox[{"b", " ", "x"}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4942717172451463`*^9, {3.494271937915455*^9, 
   3.494271942875462*^9}, {3.4942747320193667`*^9, 3.49427473408937*^9}, {
   3.4942748912295895`*^9, 3.49427489171959*^9}, 3.4942760898712683`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"FresnelS", "[", 
       RowBox[{"b_.", "*", "x_"}], "]"}], "^", "2"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"FresnelS", "[", 
        RowBox[{"b", "*", "x"}], "]"}], "^", "2"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"2", "*", 
       RowBox[{"b", "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"Pi", "/", "2"}], "*", 
           RowBox[{"b", "^", "2"}], "*", 
           RowBox[{"x", "^", "2"}]}], "]"}], "*", 
         RowBox[{"FresnelS", "[", 
          RowBox[{"b", "*", "x"}], "]"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"b", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"m", "+", "1"}], "!=", "0"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"m", ">", "0"}], " ", "&&", " ", 
       RowBox[{"EvenQ", "[", "m", "]"}]}], " ", "||", " ", 
      RowBox[{
       RowBox[{"Mod", "[", 
        RowBox[{"m", ",", "4"}], "]"}], "==", "3"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4942716088849945`*^9, {
   3.494274891959591*^9, 3.494274892499592*^9}, 3.4942753539102373`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"FresnelC", "[", 
       RowBox[{"b_.", "*", "x_"}], "]"}], "^", "2"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"FresnelC", "[", 
        RowBox[{"b", "*", "x"}], "]"}], "^", "2"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"2", "*", 
       RowBox[{"b", "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{"Pi", "/", "2"}], "*", 
           RowBox[{"b", "^", "2"}], "*", 
           RowBox[{"x", "^", "2"}]}], "]"}], "*", 
         RowBox[{"FresnelC", "[", 
          RowBox[{"b", "*", "x"}], "]"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"b", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"m", "+", "1"}], "!=", "0"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"m", ">", "0"}], " ", "&&", " ", 
       RowBox[{"EvenQ", "[", "m", "]"}]}], " ", "||", " ", 
      RowBox[{
       RowBox[{"Mod", "[", 
        RowBox[{"m", ",", "4"}], "]"}], "==", "3"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4942716088849945`*^9, {
   3.494274891959591*^9, 3.494274892499592*^9}, 3.4942753539102373`*^9, {
   3.49428020963487*^9, 3.4942802096972704`*^9}, 3.4942802595605574`*^9, 
   3.4942803402258987`*^9, 3.494280403326809*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9, 3.494271795645256*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"f", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}], "=", 
   RowBox[{
    FractionBox["1", "b"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["a", "b"]}], "+", 
       FractionBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "b"]}], ")"}], "m"], " ", 
    RowBox[{"f", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", "x"], 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}]}]}]}]],
  CellChangeTimes->{{3.4942720460856066`*^9, 3.4942720753556476`*^9}, {
   3.4942721067756915`*^9, 3.4942722060458307`*^9}}]
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4942714693347993`*^9, 
   3.4942715340348897`*^9}, {3.4942715837849593`*^9, 
   3.4942715950249753`*^9}, {3.4942716458250465`*^9, 3.494271658445064*^9}, {
   3.494271809215275*^9, 3.494271810105276*^9}, {3.49427187004536*^9, 
   3.494271874735367*^9}, {3.494272229255863*^9, 3.4942722324458675`*^9}}],

Cell[TextData[{
 "Note: Rule not necessary until a closed-form antiderivative is defined for ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Cos", "[", 
    FractionBox[
     RowBox[{"\[Pi]", " ", 
      SuperscriptBox["x", "2"]}], "2"], "]"}], " ", 
   RowBox[{"FresnelS", "[", "x", "]"}]}]]],
 "."
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494275839400917*^9, 3.494275860030946*^9}, {
   3.494276306391571*^9, 3.494276315151583*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"m", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4942714693347993`*^9, 
   3.4942715340348897`*^9}, {3.4942715837849593`*^9, 
   3.4942715950249753`*^9}, {3.4942716458250465`*^9, 3.494271658445064*^9}, {
   3.494271809215275*^9, 3.494271810105276*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"FresnelS", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "2"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "b"]}]}], " ", 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["a", "b"]}], "+", 
          FractionBox["x", "b"]}], ")"}], "m"], " ", 
       SuperscriptBox[
        RowBox[{"FresnelS", "[", "x", "]"}], "2"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4942717172451463`*^9, 3.4942718450853252`*^9, {
   3.4942719066154113`*^9, 3.4942719115954185`*^9}, {3.494274892749592*^9, 
   3.494274893009592*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x_", "^", "m_."}], "*", 
      RowBox[{
       RowBox[{"FresnelS", "[", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "2"}]}], ",", "x_Symbol"}],
     "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "b"}], ",", 
      RowBox[{"Subst", "[", 
       RowBox[{
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "a"}], "/", "b"}], "+", 
              RowBox[{"x", "/", "b"}]}], ")"}], "^", "m"}], "*", 
           RowBox[{
            RowBox[{"FresnelS", "[", "x", "]"}], "^", "2"}]}], ",", "x"}], 
         "]"}], ",", "x", ",", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}]}], "]"}]}], "]"}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
     RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
     RowBox[{"m", ">", "0"}]}]}]}], " ", "*)"}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4942716088849945`*^9, 
   3.494271801415264*^9, {3.494274893249593*^9, 3.494274893499593*^9}, 
   3.494275449420371*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x_", "^", "m_."}], "*", 
      RowBox[{
       RowBox[{"FresnelC", "[", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "2"}]}], ",", "x_Symbol"}],
     "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "b"}], ",", 
      RowBox[{"Subst", "[", 
       RowBox[{
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "a"}], "/", "b"}], "+", 
              RowBox[{"x", "/", "b"}]}], ")"}], "^", "m"}], "*", 
           RowBox[{
            RowBox[{"FresnelC", "[", "x", "]"}], "^", "2"}]}], ",", "x"}], 
         "]"}], ",", "x", ",", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}]}], "]"}]}], "]"}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
     RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
     RowBox[{"m", ">", "0"}]}]}]}], " ", "*)"}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4942716088849945`*^9, 
   3.494271801415264*^9, {3.494274893249593*^9, 3.494274893499593*^9}, 
   3.494275449420371*^9, {3.49428020982207*^9, 3.4942802098532705`*^9}, 
   3.4942804128740263`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{
     FractionBox["\[Pi]", "2"], "  ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["x", "2"]}], "]"}], " ", 
   RowBox[{"FresnelS", "[", 
    RowBox[{"b", " ", "x"}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, 
   3.494271020504171*^9, 3.494271272164523*^9, 3.4942725289462824`*^9, 
   3.494274893719593*^9, 3.4942755688605385`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts special case", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494272613616401*^9, 3.494272615776404*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494271052164215*^9, {
   3.494271408804714*^9, 3.494271432974748*^9}, 3.494272839336717*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{"x", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{
      FractionBox["\[Pi]", "2"], "  ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["x", "2"]}], "]"}], 
    RowBox[{"FresnelS", "[", 
     RowBox[{"b", " ", "x"}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{
           FractionBox["\[Pi]", "2"], "  ", 
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["x", "2"]}], "]"}], 
         RowBox[{"FresnelS", "[", 
          RowBox[{"b", " ", "x"}], "]"}]}], 
        RowBox[{"\[Pi]", " ", 
         SuperscriptBox["b", "2"]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", "\[Pi]", " ", "b"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"\[Pi]", "  ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["x", "2"]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.494271065404234*^9, 3.494271092894272*^9}, {
   3.4942713522746353`*^9, 3.494271366464655*^9}, {3.494272688416506*^9, 
   3.494272704556528*^9}, 3.4942728202566905`*^9, {3.494274893959594*^9, 
   3.494274894199594*^9}, {3.494276463451791*^9, 3.494276532201887*^9}, {
   3.4942765654319334`*^9, 3.4942765661519346`*^9}, 3.4942768603823466`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"c_.", "*", 
       RowBox[{"x_", "^", "2"}]}], "]"}], "*", 
     RowBox[{"FresnelS", "[", 
      RowBox[{"b_.", "*", "x_"}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Cos", "[", 
       RowBox[{
        RowBox[{"Pi", "/", "2"}], "*", 
        RowBox[{"b", "^", "2"}], "*", 
        RowBox[{"x", "^", "2"}]}], "]"}]}], "*", 
     RowBox[{
      RowBox[{"FresnelS", "[", 
       RowBox[{"b", "*", "x"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"Pi", "*", 
        RowBox[{"b", "^", "2"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "Pi", "*", "b"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"Pi", "*", 
          RowBox[{"b", "^", "2"}], "*", 
          RowBox[{"x", "^", "2"}]}], "]"}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"c", "-", 
      RowBox[{
       RowBox[{"Pi", "/", "2"}], "*", 
       RowBox[{"b", "^", "2"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4942710790942526`*^9, 
   3.4942713187345886`*^9, 3.494272554176318*^9, {3.494273261227308*^9, 
   3.49427326985732*^9}, {3.4942748944395943`*^9, 3.4942748946795945`*^9}, 
   3.4942754811804156`*^9, {3.494276395301696*^9, 3.494276404081708*^9}, 
   3.494276868032357*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c_.", "*", 
       RowBox[{"x_", "^", "2"}]}], "]"}], "*", 
     RowBox[{"FresnelC", "[", 
      RowBox[{"b_.", "*", "x_"}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"Pi", "/", "2"}], "*", 
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"x", "^", "2"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"FresnelC", "[", 
       RowBox[{"b", "*", "x"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"Pi", "*", 
        RowBox[{"b", "^", "2"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "Pi", "*", "b"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"Pi", "*", 
          RowBox[{"b", "^", "2"}], "*", 
          RowBox[{"x", "^", "2"}]}], "]"}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"c", "-", 
      RowBox[{
       RowBox[{"Pi", "/", "2"}], "*", 
       RowBox[{"b", "^", "2"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4942710790942526`*^9, 
   3.4942713187345886`*^9, 3.494272554176318*^9, {3.494273261227308*^9, 
   3.49427326985732*^9}, {3.4942748944395943`*^9, 3.4942748946795945`*^9}, 
   3.4942754811804156`*^9, {3.494276395301696*^9, 3.494276404081708*^9}, 
   3.494276868032357*^9, {3.494280210836072*^9, 3.4942802108672724`*^9}, {
   3.4942802617757616`*^9, 3.4942802621969624`*^9}, 3.4942802960946217`*^9, {
   3.4942803437983055`*^9, 3.4942803441571054`*^9}, 3.4942804261964493`*^9, 
   3.4942805708867035`*^9, 3.494281042085531*^9, 3.5159627614455056`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9}],

Cell[TextData[{
 "Note: Also apply rule when m mod 4 = 2 when a closed-form antiderivative is \
defined for ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Cos", "[", 
    FractionBox[
     RowBox[{"\[Pi]", " ", 
      SuperscriptBox["x", "2"]}], "2"], "]"}], " ", 
   RowBox[{"FresnelS", "[", "x", "]"}]}]]],
 "."
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494275839400917*^9, 3.494275860030946*^9}, {
   3.4942766525420556`*^9, 3.494276657652063*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"m", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"m", " ", "mod", " ", "4"}], "=", "2"}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4942714693347993`*^9, 
   3.4942715340348897`*^9}, {3.4942715837849593`*^9, 
   3.4942715950249753`*^9}, {3.4942716458250465`*^9, 3.494271658445064*^9}, 
   3.494272339896018*^9, {3.4942728903967886`*^9, 3.4942728958867965`*^9}, {
   3.4942768954823956`*^9, 3.4942769039024076`*^9}, {3.4942769616924887`*^9, 
   3.4942769880825253`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{
      FractionBox["\[Pi]", "2"], "  ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["x", "2"]}], "]"}], 
    RowBox[{"FresnelS", "[", 
     RowBox[{"b", " ", "x"}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox["x", 
          RowBox[{"m", "-", "1"}]], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{
           FractionBox["\[Pi]", "2"], "  ", 
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["x", "2"]}], "]"}], 
         RowBox[{"FresnelS", "[", 
          RowBox[{"b", " ", "x"}], "]"}]}], 
        RowBox[{"\[Pi]", " ", 
         SuperscriptBox["b", "2"]}]]}]}]}]}]}], "+", 
  "                                        ", "\[IndentingNewLine]", 
  "                                              ", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", "\[Pi]", " ", "b"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "1"}]], 
     RowBox[{"Sin", "[", 
      RowBox[{"\[Pi]", "  ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["x", "2"]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"m", "-", "1"}], 
    RowBox[{"\[Pi]", " ", 
     SuperscriptBox["b", "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "2"}]], " ", 
     RowBox[{"Cos", "[", 
      RowBox[{
       FractionBox["\[Pi]", "2"], "  ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["x", "2"]}], "]"}], 
     RowBox[{"FresnelS", "[", 
      RowBox[{"b", " ", "x"}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4942717172451463`*^9, {3.494271937915455*^9, 
   3.494271942875462*^9}, 3.4942726926265116`*^9, 3.4942730666870356`*^9, {
   3.494274894939595*^9, 3.4942748954495955`*^9}, {3.4942766716620827`*^9, 
   3.49427667694209*^9}, {3.4942767148221426`*^9, 3.4942768288023024`*^9}, {
   3.494282087559368*^9, 3.494282100507391*^9}, {3.4942825499665804`*^9, 
   3.4942825636790047`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"c_.", "*", 
       RowBox[{"x_", "^", "2"}]}], "]"}], "*", 
     RowBox[{"FresnelS", "[", 
      RowBox[{"b_.", "*", "x_"}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"m", "-", "1"}], ")"}]}]}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{
       RowBox[{"Pi", "/", "2"}], "*", 
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"x", "^", "2"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"FresnelS", "[", 
       RowBox[{"b", "*", "x"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"Pi", "*", 
        RowBox[{"b", "^", "2"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "Pi", "*", "b"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"Pi", "*", 
           RowBox[{"b", "^", "2"}], "*", 
           RowBox[{"x", "^", "2"}]}], "]"}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"Pi", "*", 
         RowBox[{"b", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{"Pi", "/", "2"}], "*", 
           RowBox[{"b", "^", "2"}], "*", 
           RowBox[{"x", "^", "2"}]}], "]"}], "*", 
         RowBox[{"FresnelS", "[", 
          RowBox[{"b", "*", "x"}], "]"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"c", "-", 
      RowBox[{
       RowBox[{"Pi", "/", "2"}], "*", 
       RowBox[{"b", "^", "2"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{"m", ",", "4"}], "]"}], "==", "2"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4942716088849945`*^9, 
   3.49427256278633*^9, 3.49427327726733*^9, {3.4942748957095957`*^9, 
   3.494274896199597*^9}, 3.4942754909404297`*^9, 3.4942764101817164`*^9, {
   3.4942767912722497`*^9, 3.4942767965022573`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c_.", "*", 
       RowBox[{"x_", "^", "2"}]}], "]"}], "*", 
     RowBox[{"FresnelC", "[", 
      RowBox[{"b_.", "*", "x_"}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "1"}], ")"}]}], "*", 
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"Pi", "/", "2"}], "*", 
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"x", "^", "2"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"FresnelC", "[", 
       RowBox[{"b", "*", "x"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"Pi", "*", 
        RowBox[{"b", "^", "2"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "Pi", "*", "b"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"Pi", "*", 
           RowBox[{"b", "^", "2"}], "*", 
           RowBox[{"x", "^", "2"}]}], "]"}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"Pi", "*", 
         RowBox[{"b", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"Pi", "/", "2"}], "*", 
           RowBox[{"b", "^", "2"}], "*", 
           RowBox[{"x", "^", "2"}]}], "]"}], "*", 
         RowBox[{"FresnelC", "[", 
          RowBox[{"b", "*", "x"}], "]"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"c", "-", 
      RowBox[{
       RowBox[{"Pi", "/", "2"}], "*", 
       RowBox[{"b", "^", "2"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{"m", ",", "4"}], "]"}], "==", "2"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4942716088849945`*^9, 
   3.49427256278633*^9, 3.49427327726733*^9, {3.4942748957095957`*^9, 
   3.494274896199597*^9}, 3.4942754909404297`*^9, 3.4942764101817164`*^9, {
   3.4942767912722497`*^9, 3.4942767965022573`*^9}, {3.4942802110388727`*^9, 
   3.4942802111012726`*^9}, {3.4942802634449644`*^9, 3.494280263850565*^9}, {
   3.494280297732624*^9, 3.4942802979978247`*^9}, {3.4942803451867075`*^9, 
   3.494280345529908*^9}, 3.494280453839698*^9, 3.494280579513519*^9, 
   3.494281042943533*^9, 3.5159627686371183`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Inverted integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, 3.494271795645256*^9, {3.4942725825463576`*^9, 
   3.4942725917163706`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "2"}]}], " ", "\[And]", " ", 
    RowBox[{"m", " ", "mod", " ", "4"}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4942714693347993`*^9, 
   3.4942715340348897`*^9}, {3.4942715837849593`*^9, 
   3.4942715950249753`*^9}, {3.4942716458250465`*^9, 3.494271658445064*^9}, {
   3.494271809215275*^9, 3.494271810105276*^9}, {3.4942730894970675`*^9, 
   3.4942731037070875`*^9}, {3.494277060542627*^9, 3.494277088412666*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{
      FractionBox["\[Pi]", "2"], "  ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["x", "2"]}], "]"}], 
    RowBox[{"FresnelS", "[", 
     RowBox[{"b", " ", "x"}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        RowBox[{"Sin", "[", 
         RowBox[{
          FractionBox["\[Pi]", "2"], "  ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["x", "2"]}], "]"}], 
        RowBox[{"FresnelS", "[", 
         RowBox[{"b", " ", "x"}], "]"}]}], 
       RowBox[{"m", "+", "1"}]]}]}]}]}], "-", 
  FractionBox[
   RowBox[{"b", " ", 
    SuperscriptBox["x", 
     RowBox[{"m", "+", "2"}]]}], 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"m", "+", "1"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"m", "+", "2"}], ")"}]}]], "+", "\[IndentingNewLine]", 
  "                                            ", 
  RowBox[{
   FractionBox["b", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "1"}]], 
     RowBox[{"Cos", "[", 
      RowBox[{"\[Pi]", "  ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["x", "2"]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"\[Pi]", " ", 
     SuperscriptBox["b", "2"]}], 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "2"}]], " ", 
     RowBox[{"Cos", "[", 
      RowBox[{
       FractionBox["\[Pi]", "2"], "  ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["x", "2"]}], "]"}], 
     RowBox[{"FresnelS", "[", 
      RowBox[{"b", " ", "x"}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4942717172451463`*^9, 3.4942718450853252`*^9, {
   3.4942719066154113`*^9, 3.4942719115954185`*^9}, 3.4942726963465166`*^9, 
   3.4942731998172216`*^9, {3.4942748964195967`*^9, 3.4942748968695974`*^9}, 
   3.4942771167227054`*^9, {3.494277150572753*^9, 3.4942772565729012`*^9}, {
   3.4942773097129755`*^9, 3.4942773108729773`*^9}, {3.4942821132370133`*^9, 
   3.4942821176674213`*^9}, 3.4942823170897713`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"c_.", "*", 
       RowBox[{"x_", "^", "2"}]}], "]"}], "*", 
     RowBox[{"FresnelS", "[", 
      RowBox[{"b_.", "*", "x_"}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"Pi", "/", "2"}], "*", 
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"x", "^", "2"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"FresnelS", "[", 
       RowBox[{"b", "*", "x"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "-", " ", 
    RowBox[{"b", "*", 
     RowBox[{
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "2"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"Pi", "*", 
           RowBox[{"b", "^", "2"}], "*", 
           RowBox[{"x", "^", "2"}]}], "]"}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"Pi", "*", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{"Pi", "/", "2"}], "*", 
           RowBox[{"b", "^", "2"}], "*", 
           RowBox[{"x", "^", "2"}]}], "]"}], "*", 
         RowBox[{"FresnelS", "[", 
          RowBox[{"b", "*", "x"}], "]"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"c", "-", 
      RowBox[{
       RowBox[{"Pi", "/", "2"}], "*", 
       RowBox[{"b", "^", "2"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "2"}]}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"Mod", "[", 
      RowBox[{"m", ",", "4"}], "]"}], "==", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4942716088849945`*^9, 
   3.494271801415264*^9, 3.494272572126343*^9, 3.4942732811973352`*^9, {
   3.4942748970895977`*^9, 3.4942748975495987`*^9}, 3.4942755026004457`*^9, 
   3.4942764130817204`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c_.", "*", 
       RowBox[{"x_", "^", "2"}]}], "]"}], "*", 
     RowBox[{"FresnelC", "[", 
      RowBox[{"b_.", "*", "x_"}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{
       RowBox[{"Pi", "/", "2"}], "*", 
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"x", "^", "2"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"FresnelC", "[", 
       RowBox[{"b", "*", "x"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "-", " ", 
    RowBox[{"b", "*", 
     RowBox[{
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "2"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"Pi", "*", 
           RowBox[{"b", "^", "2"}], "*", 
           RowBox[{"x", "^", "2"}]}], "]"}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"Pi", "*", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"Pi", "/", "2"}], "*", 
           RowBox[{"b", "^", "2"}], "*", 
           RowBox[{"x", "^", "2"}]}], "]"}], "*", 
         RowBox[{"FresnelC", "[", 
          RowBox[{"b", "*", "x"}], "]"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"c", "-", 
      RowBox[{
       RowBox[{"Pi", "/", "2"}], "*", 
       RowBox[{"b", "^", "2"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "2"}]}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"Mod", "[", 
      RowBox[{"m", ",", "4"}], "]"}], "==", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4942716088849945`*^9, 
   3.494271801415264*^9, 3.494272572126343*^9, 3.4942732811973352`*^9, {
   3.4942748970895977`*^9, 3.4942748975495987`*^9}, 3.4942755026004457`*^9, 
   3.4942764130817204`*^9, {3.494280211226073*^9, 3.494280211288473*^9}, {
   3.494280265114167*^9, 3.494280265535368*^9}, {3.494280298762226*^9, 
   3.4942802990274267`*^9}, {3.4942803464035096`*^9, 3.49428034669991*^9}, 
   3.494280463293315*^9, 3.4942805884211345`*^9, 3.515962777778734*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   RowBox[{"Cos", "[", 
    RowBox[{
     FractionBox["\[Pi]", "2"], "  ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["x", "2"]}], "]"}], " ", 
   RowBox[{"FresnelS", "[", 
    RowBox[{"b", " ", "x"}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, 
   3.494271020504171*^9, 3.494271272164523*^9, 3.4942725289462824`*^9, 
   3.494274893719593*^9, 3.4942755688605385`*^9, 3.494277449473171*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts special case", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494272613616401*^9, 3.494272615776404*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494271052164215*^9, {
   3.494271408804714*^9, 3.494271432974748*^9}, 3.494272839336717*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{"x", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{
      FractionBox["\[Pi]", "2"], "  ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["x", "2"]}], "]"}], 
    RowBox[{"FresnelS", "[", 
     RowBox[{"b", " ", "x"}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{
          FractionBox["\[Pi]", "2"], "  ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["x", "2"]}], "]"}], 
        RowBox[{"FresnelS", "[", 
         RowBox[{"b", " ", "x"}], "]"}]}], 
       RowBox[{"\[Pi]", " ", 
        SuperscriptBox["b", "2"]}]]}]}]}]}], "-", 
  FractionBox["x", 
   RowBox[{"2", " ", "\[Pi]", " ", "b"}]], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", "\[Pi]", " ", "b"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"\[Pi]", "  ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["x", "2"]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.494271065404234*^9, 3.494271092894272*^9}, {
   3.4942713522746353`*^9, 3.494271366464655*^9}, {3.494272688416506*^9, 
   3.494272704556528*^9}, 3.4942728202566905`*^9, {3.494274893959594*^9, 
   3.494274894199594*^9}, {3.494276463451791*^9, 3.494276532201887*^9}, {
   3.4942765654319334`*^9, 3.4942765661519346`*^9}, 3.4942768603823466`*^9, {
   3.494277429323143*^9, 3.494277477843211*^9}, {3.4942775825133576`*^9, 
   3.4942775889533663`*^9}, {3.4942776845535*^9, 3.4942776903435087`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c_.", "*", 
       RowBox[{"x_", "^", "2"}]}], "]"}], "*", 
     RowBox[{"FresnelS", "[", 
      RowBox[{"b_.", "*", "x_"}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"Pi", "/", "2"}], "*", 
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"x", "^", "2"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"FresnelS", "[", 
       RowBox[{"b", "*", "x"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"Pi", "*", 
        RowBox[{"b", "^", "2"}]}], ")"}]}]}], " ", "-", " ", 
    RowBox[{"x", "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", "Pi", "*", "b"}], ")"}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "Pi", "*", "b"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"Cos", "[", 
         RowBox[{"Pi", "*", 
          RowBox[{"b", "^", "2"}], "*", 
          RowBox[{"x", "^", "2"}]}], "]"}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"c", "-", 
      RowBox[{
       RowBox[{"Pi", "/", "2"}], "*", 
       RowBox[{"b", "^", "2"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4942710790942526`*^9, 
   3.4942713187345886`*^9, 3.494272554176318*^9, {3.494273261227308*^9, 
   3.49427326985732*^9}, {3.4942748944395943`*^9, 3.4942748946795945`*^9}, 
   3.4942754811804156`*^9, {3.494276395301696*^9, 3.494276404081708*^9}, 
   3.494276868032357*^9, {3.494277429903144*^9, 3.494277478503212*^9}, 
   3.49427751293326*^9, {3.494277556763322*^9, 3.4942775639233313`*^9}, {
   3.4942776109933977`*^9, 3.494277611503398*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"c_.", "*", 
       RowBox[{"x_", "^", "2"}]}], "]"}], "*", 
     RowBox[{"FresnelC", "[", 
      RowBox[{"b_.", "*", "x_"}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Cos", "[", 
       RowBox[{
        RowBox[{"Pi", "/", "2"}], "*", 
        RowBox[{"b", "^", "2"}], "*", 
        RowBox[{"x", "^", "2"}]}], "]"}]}], "*", 
     RowBox[{
      RowBox[{"FresnelC", "[", 
       RowBox[{"b", "*", "x"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"Pi", "*", 
        RowBox[{"b", "^", "2"}]}], ")"}]}]}], " ", "+", " ", 
    RowBox[{"x", "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", "Pi", "*", "b"}], ")"}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "Pi", "*", "b"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"Cos", "[", 
         RowBox[{"Pi", "*", 
          RowBox[{"b", "^", "2"}], "*", 
          RowBox[{"x", "^", "2"}]}], "]"}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"c", "-", 
      RowBox[{
       RowBox[{"Pi", "/", "2"}], "*", 
       RowBox[{"b", "^", "2"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4942710790942526`*^9, 
   3.4942713187345886`*^9, 3.494272554176318*^9, {3.494273261227308*^9, 
   3.49427326985732*^9}, {3.4942748944395943`*^9, 3.4942748946795945`*^9}, 
   3.4942754811804156`*^9, {3.494276395301696*^9, 3.494276404081708*^9}, 
   3.494276868032357*^9, {3.494277429903144*^9, 3.494277478503212*^9}, 
   3.49427751293326*^9, {3.494277556763322*^9, 3.4942775639233313`*^9}, {
   3.4942776109933977`*^9, 3.494277611503398*^9}, {3.4942802114444733`*^9, 
   3.4942802114756737`*^9}, 3.4942802664557695`*^9, {3.494280299932228*^9, 
   3.4942803001194286`*^9}, 3.494280347277111*^9, 3.4942804745253344`*^9, 
   3.494280544507057*^9, {3.494281039417927*^9, 3.494281040151128*^9}, 
   3.515962861565281*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"m", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"m", " ", "mod", " ", "4"}], "=", "0"}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4942714693347993`*^9, 
   3.4942715340348897`*^9}, {3.4942715837849593`*^9, 
   3.4942715950249753`*^9}, {3.4942716458250465`*^9, 3.494271658445064*^9}, 
   3.494272339896018*^9, {3.4942728903967886`*^9, 3.4942728958867965`*^9}, {
   3.4942768954823956`*^9, 3.4942769039024076`*^9}, {3.4942769616924887`*^9, 
   3.4942769880825253`*^9}, 3.49427774852359*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{
      FractionBox["\[Pi]", "2"], "  ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["x", "2"]}], "]"}], 
    RowBox[{"FresnelS", "[", 
     RowBox[{"b", " ", "x"}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "-", "1"}]], " ", 
        RowBox[{"Sin", "[", 
         RowBox[{
          FractionBox["\[Pi]", "2"], "  ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["x", "2"]}], "]"}], 
        RowBox[{"FresnelS", "[", 
         RowBox[{"b", " ", "x"}], "]"}]}], 
       RowBox[{"\[Pi]", " ", 
        SuperscriptBox["b", "2"]}]]}]}]}]}], "-", " ", 
  FractionBox[
   SuperscriptBox["x", "m"], 
   RowBox[{"2", " ", "b", " ", "m", " ", "\[Pi]"}]], "+", 
  "                                  ", "\[IndentingNewLine]", 
  "                                                  ", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", "\[Pi]", " ", "b"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "1"}]], 
     RowBox[{"Cos", "[", 
      RowBox[{"\[Pi]", "  ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["x", "2"]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"m", "-", "1"}], 
    RowBox[{"\[Pi]", " ", 
     SuperscriptBox["b", "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "2"}]], " ", 
     RowBox[{"Sin", "[", 
      RowBox[{
       FractionBox["\[Pi]", "2"], "  ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["x", "2"]}], "]"}], 
     RowBox[{"FresnelS", "[", 
      RowBox[{"b", " ", "x"}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4942717172451463`*^9, {3.494271937915455*^9, 
   3.494271942875462*^9}, 3.4942726926265116`*^9, 3.4942730666870356`*^9, {
   3.494274894939595*^9, 3.4942748954495955`*^9}, {3.4942766716620827`*^9, 
   3.49427667694209*^9}, {3.4942767148221426`*^9, 3.4942768288023024`*^9}, {
   3.494277431073146*^9, 3.4942774801932144`*^9}, {3.4942778407537193`*^9, 
   3.4942778739737654`*^9}, {3.494282143797467*^9, 3.494282148181075*^9}, {
   3.494282358866645*^9, 3.4942823670254593`*^9}, {3.494282598108265*^9, 
   3.494282601493471*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c_.", "*", 
       RowBox[{"x_", "^", "2"}]}], "]"}], "*", 
     RowBox[{"FresnelS", "[", 
      RowBox[{"b_.", "*", "x_"}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "1"}], ")"}]}], "*", 
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"Pi", "/", "2"}], "*", 
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"x", "^", "2"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"FresnelS", "[", 
       RowBox[{"b", "*", "x"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"Pi", "*", 
        RowBox[{"b", "^", "2"}]}], ")"}]}]}], " ", "-", " ", 
    RowBox[{
     RowBox[{"x", "^", "m"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", "b", "*", "m", "*", "Pi"}], ")"}]}], " ", "+", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "Pi", "*", "b"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"Pi", "*", 
           RowBox[{"b", "^", "2"}], "*", 
           RowBox[{"x", "^", "2"}]}], "]"}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"Pi", "*", 
         RowBox[{"b", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"Pi", "/", "2"}], "*", 
           RowBox[{"b", "^", "2"}], "*", 
           RowBox[{"x", "^", "2"}]}], "]"}], "*", 
         RowBox[{"FresnelS", "[", 
          RowBox[{"b", "*", "x"}], "]"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"c", "-", 
      RowBox[{
       RowBox[{"Pi", "/", "2"}], "*", 
       RowBox[{"b", "^", "2"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{"m", ",", "4"}], "]"}], "==", "0"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4942716088849945`*^9, 
   3.49427256278633*^9, 3.49427327726733*^9, {3.4942748957095957`*^9, 
   3.494274896199597*^9}, 3.4942754909404297`*^9, 3.4942764101817164`*^9, {
   3.4942767912722497`*^9, 3.4942767965022573`*^9}, {3.4942774321531467`*^9, 
   3.4942774810232153`*^9}, 3.4942775239432755`*^9, 3.494277570383341*^9, 
   3.4942776123133993`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"c_.", "*", 
       RowBox[{"x_", "^", "2"}]}], "]"}], "*", 
     RowBox[{"FresnelC", "[", 
      RowBox[{"b_.", "*", "x_"}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"m", "-", "1"}], ")"}]}]}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{
       RowBox[{"Pi", "/", "2"}], "*", 
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"x", "^", "2"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"FresnelC", "[", 
       RowBox[{"b", "*", "x"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"Pi", "*", 
        RowBox[{"b", "^", "2"}]}], ")"}]}]}], " ", "+", " ", 
    RowBox[{
     RowBox[{"x", "^", "m"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", "b", "*", "m", "*", "Pi"}], ")"}]}], " ", "+", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "Pi", "*", "b"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"Pi", "*", 
           RowBox[{"b", "^", "2"}], "*", 
           RowBox[{"x", "^", "2"}]}], "]"}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"Pi", "*", 
         RowBox[{"b", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{"Pi", "/", "2"}], "*", 
           RowBox[{"b", "^", "2"}], "*", 
           RowBox[{"x", "^", "2"}]}], "]"}], "*", 
         RowBox[{"FresnelC", "[", 
          RowBox[{"b", "*", "x"}], "]"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"c", "-", 
      RowBox[{
       RowBox[{"Pi", "/", "2"}], "*", 
       RowBox[{"b", "^", "2"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{"m", ",", "4"}], "]"}], "==", "0"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4942716088849945`*^9, 
   3.49427256278633*^9, 3.49427327726733*^9, {3.4942748957095957`*^9, 
   3.494274896199597*^9}, 3.4942754909404297`*^9, 3.4942764101817164`*^9, {
   3.4942767912722497`*^9, 3.4942767965022573`*^9}, {3.4942774321531467`*^9, 
   3.4942774810232153`*^9}, 3.4942775239432755`*^9, 3.494277570383341*^9, 
   3.4942776123133993`*^9, {3.494280212598875*^9, 3.494280212661276*^9}, {
   3.494280267672572*^9, 3.4942802680781727`*^9}, {3.49428030110223*^9, 
   3.494280301539031*^9}, {3.4942803481195126`*^9, 3.494280348369113*^9}, 
   3.4942804835577507`*^9, 3.4942805530402727`*^9, 3.49428104127433*^9, 
   3.5159628648100867`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Inverted integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, 3.494271795645256*^9, {3.4942725825463576`*^9, 
   3.4942725917163706`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"m", " ", "mod", " ", "4"}]}], "=", "2"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4942714693347993`*^9, 
   3.4942715340348897`*^9}, {3.4942715837849593`*^9, 
   3.4942715950249753`*^9}, {3.4942716458250465`*^9, 3.494271658445064*^9}, {
   3.494271809215275*^9, 3.494271810105276*^9}, {3.4942730894970675`*^9, 
   3.4942731037070875`*^9}, {3.494277060542627*^9, 3.494277088412666*^9}, {
   3.494277921293832*^9, 3.4942779254238377`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{
      FractionBox["\[Pi]", "2"], "  ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["x", "2"]}], "]"}], 
    RowBox[{"FresnelS", "[", 
     RowBox[{"b", " ", "x"}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        RowBox[{"Cos", "[", 
         RowBox[{
          FractionBox["\[Pi]", "2"], "  ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["x", "2"]}], "]"}], 
        RowBox[{"FresnelS", "[", 
         RowBox[{"b", " ", "x"}], "]"}]}], 
       RowBox[{"m", "+", "1"}]]}]}]}]}], "-", 
  "                                            ", "\[IndentingNewLine]", 
  "                                            ", 
  RowBox[{
   FractionBox["b", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "1"}]], 
     RowBox[{"Sin", "[", 
      RowBox[{"\[Pi]", "  ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["x", "2"]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"\[Pi]", " ", 
     SuperscriptBox["b", "2"]}], 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "2"}]], " ", 
     RowBox[{"Sin", "[", 
      RowBox[{
       FractionBox["\[Pi]", "2"], "  ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["x", "2"]}], "]"}], 
     RowBox[{"FresnelS", "[", 
      RowBox[{"b", " ", "x"}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4942717172451463`*^9, 3.4942718450853252`*^9, {
   3.4942719066154113`*^9, 3.4942719115954185`*^9}, 3.4942726963465166`*^9, 
   3.4942731998172216`*^9, {3.4942748964195967`*^9, 3.4942748968695974`*^9}, 
   3.4942771167227054`*^9, {3.494277150572753*^9, 3.4942772565729012`*^9}, {
   3.4942773097129755`*^9, 3.4942773108729773`*^9}, {3.494277433213148*^9, 
   3.494277481943217*^9}, {3.4942779438938637`*^9, 3.494277956323881*^9}, {
   3.494282156433489*^9, 3.4942821595690947`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c_.", "*", 
       RowBox[{"x_", "^", "2"}]}], "]"}], "*", 
     RowBox[{"FresnelS", "[", 
      RowBox[{"b_.", "*", "x_"}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{
       RowBox[{"Pi", "/", "2"}], "*", 
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"x", "^", "2"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"FresnelS", "[", 
       RowBox[{"b", "*", "x"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"Pi", "*", 
           RowBox[{"b", "^", "2"}], "*", 
           RowBox[{"x", "^", "2"}]}], "]"}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"Pi", "*", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"Pi", "/", "2"}], "*", 
           RowBox[{"b", "^", "2"}], "*", 
           RowBox[{"x", "^", "2"}]}], "]"}], "*", 
         RowBox[{"FresnelS", "[", 
          RowBox[{"b", "*", "x"}], "]"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"c", "-", 
      RowBox[{
       RowBox[{"Pi", "/", "2"}], "*", 
       RowBox[{"b", "^", "2"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"Mod", "[", 
      RowBox[{"m", ",", "4"}], "]"}], "==", "2"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4942716088849945`*^9, 
   3.494271801415264*^9, 3.494272572126343*^9, 3.4942732811973352`*^9, {
   3.4942748970895977`*^9, 3.4942748975495987`*^9}, 3.4942755026004457`*^9, 
   3.4942764130817204`*^9, {3.49427743427315*^9, 3.4942774830932183`*^9}, 
   3.494277532863288*^9, 3.4942775731033444`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"c_.", "*", 
       RowBox[{"x_", "^", "2"}]}], "]"}], "*", 
     RowBox[{"FresnelC", "[", 
      RowBox[{"b_.", "*", "x_"}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"Pi", "/", "2"}], "*", 
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"x", "^", "2"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"FresnelC", "[", 
       RowBox[{"b", "*", "x"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"Pi", "*", 
           RowBox[{"b", "^", "2"}], "*", 
           RowBox[{"x", "^", "2"}]}], "]"}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"Pi", "*", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{"Pi", "/", "2"}], "*", 
           RowBox[{"b", "^", "2"}], "*", 
           RowBox[{"x", "^", "2"}]}], "]"}], "*", 
         RowBox[{"FresnelC", "[", 
          RowBox[{"b", "*", "x"}], "]"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"c", "-", 
      RowBox[{
       RowBox[{"Pi", "/", "2"}], "*", 
       RowBox[{"b", "^", "2"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"Mod", "[", 
      RowBox[{"m", ",", "4"}], "]"}], "==", "2"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4942716088849945`*^9, 
   3.494271801415264*^9, 3.494272572126343*^9, 3.4942732811973352`*^9, {
   3.4942748970895977`*^9, 3.4942748975495987`*^9}, 3.4942755026004457`*^9, 
   3.4942764130817204`*^9, {3.49427743427315*^9, 3.4942774830932183`*^9}, 
   3.494277532863288*^9, 3.4942775731033444`*^9, {3.494280212801676*^9, 
   3.4942802128640757`*^9}, {3.4942802692013745`*^9, 
   3.4942802695913754`*^9}, {3.494280302209832*^9, 3.494280302428233*^9}, {
   3.4942803491491146`*^9, 3.494280349398715*^9}, 3.494280494072169*^9, 
   3.4942805621194882`*^9, 3.515962867711692*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]]
},
AutoGeneratedPackage->Automatic,
CellGrouping->Manual,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  "Integration Rules for Fresnel Integral Functions", None, None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->28.8},
Magnification->1.399999976158142,
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 958, 21, 118, "Title"],
Cell[1528, 45, 101, 1, 48, "Subsubsection"],
Cell[1632, 48, 732, 10, 34, "Subsubsection"],
Cell[2367, 60, 1938, 44, 104, "Subsubtitle"],
Cell[4308, 106, 795, 11, 48, "Subsubsection"],
Cell[5106, 119, 1265, 37, 145, "Code"],
Cell[6374, 158, 1365, 38, 159, "Code"],
Cell[7742, 198, 113, 2, 48, "Subsubsection"],
Cell[7858, 202, 101, 1, 34, "Subsubsection"],
Cell[7962, 205, 732, 10, 34, "Subsubsection"],
Cell[8697, 217, 2196, 53, 88, "Subsubtitle"],
Cell[10896, 272, 795, 11, 48, "Subsubsection"],
Cell[11694, 285, 1623, 48, 180, "Code"],
Cell[13320, 335, 1751, 50, 194, "Code"],
Cell[15074, 387, 44, 1, 5, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[15155, 393, 1013, 22, 80, "Title"],
Cell[16171, 417, 101, 1, 48, "Subsubsection"],
Cell[16275, 420, 896, 18, 36, "Subsubsection"],
Cell[17174, 440, 2103, 50, 89, "Subsubtitle"],
Cell[19280, 492, 795, 11, 48, "Subsubsection"],
Cell[20078, 505, 1810, 54, 180, "Code"],
Cell[21891, 561, 1934, 56, 194, "Code"],
Cell[23828, 619, 113, 2, 48, "Subsubsection"],
Cell[23944, 623, 101, 1, 34, "Subsubsection"],
Cell[24048, 626, 421, 13, 58, "Subsubsection"],
Cell[24472, 641, 1487, 31, 54, "Subsubsection"],
Cell[25962, 674, 2155, 51, 89, "Subsubtitle"],
Cell[28120, 727, 795, 11, 48, "Subsubsection"],
Cell[28918, 740, 2063, 60, 180, "Code"],
Cell[30984, 802, 2188, 62, 194, "Code"],
Cell[33175, 866, 113, 2, 48, "Subsubsection"],
Cell[33291, 870, 130, 1, 34, "Subsubsection"],
Cell[33424, 873, 1827, 43, 54, "Subsubsection"],
Cell[35254, 918, 456, 13, 58, "Subsubsection"],
Cell[35713, 933, 1085, 20, 36, "Subsubsection"],
Cell[36801, 955, 1896, 43, 82, "Subsubtitle"],
Cell[38700, 1000, 795, 11, 48, "Subsubsection"],
Cell[39498, 1013, 1580, 44, 145, "Code"],
Cell[41081, 1059, 1655, 45, 159, "Code"],
Cell[42739, 1106, 44, 1, 5, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[42820, 1112, 1170, 26, 82, "Title"],
Cell[43993, 1140, 163, 2, 48, "Subsubsection"],
Cell[44159, 1144, 804, 11, 34, "Subsubsection"],
Cell[44966, 1157, 2379, 54, 113, "Subsubtitle"],
Cell[47348, 1213, 795, 11, 48, "Subsubsection"],
Cell[48146, 1226, 1935, 55, 180, "Code"],
Cell[50084, 1283, 2187, 57, 194, "Code"],
Cell[52274, 1342, 113, 2, 48, "Subsubsection"],
Cell[52390, 1346, 101, 1, 34, "Subsubsection"],
Cell[52494, 1349, 473, 14, 58, "Subsubsection"],
Cell[52970, 1365, 1358, 26, 36, "Subsubsection"],
Cell[54331, 1393, 3201, 79, 195, "Subsubtitle"],
Cell[57535, 1474, 795, 11, 48, "Subsubsection"],
Cell[58333, 1487, 3079, 90, 215, "Code"],
Cell[61415, 1579, 3355, 93, 229, "Code"],
Cell[64773, 1674, 113, 2, 48, "Subsubsection"],
Cell[64889, 1678, 189, 3, 34, "Subsubsection"],
Cell[65081, 1683, 1299, 25, 36, "Subsubsection"],
Cell[66383, 1710, 3403, 87, 204, "Subsubtitle"],
Cell[69789, 1799, 795, 11, 48, "Subsubsection"],
Cell[70587, 1812, 3349, 100, 215, "Code"],
Cell[73939, 1914, 3616, 103, 229, "Code"],
Cell[77558, 2019, 44, 1, 5, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[77639, 2025, 1192, 26, 82, "Title"],
Cell[78834, 2053, 163, 2, 48, "Subsubsection"],
Cell[79000, 2057, 804, 11, 34, "Subsubsection"],
Cell[79807, 2070, 2565, 57, 113, "Subsubtitle"],
Cell[82375, 2129, 795, 11, 48, "Subsubsection"],
Cell[83173, 2142, 2189, 59, 180, "Code"],
Cell[85365, 2203, 2489, 64, 194, "Code"],
Cell[87857, 2269, 113, 2, 48, "Subsubsection"],
Cell[87973, 2273, 101, 1, 34, "Subsubsection"],
Cell[88077, 2276, 1379, 26, 36, "Subsubsection"],
Cell[89459, 2304, 3423, 83, 195, "Subsubtitle"],
Cell[92885, 2389, 795, 11, 48, "Subsubsection"],
Cell[93683, 2402, 3333, 96, 215, "Code"],
Cell[97019, 2500, 3653, 101, 229, "Code"],
Cell[100675, 2603, 113, 2, 48, "Subsubsection"],
Cell[100791, 2607, 189, 3, 34, "Subsubsection"],
Cell[100983, 2612, 1351, 26, 36, "Subsubsection"],
Cell[102337, 2640, 3283, 80, 204, "Subsubtitle"],
Cell[105623, 2722, 795, 11, 48, "Subsubsection"],
Cell[106421, 2735, 3108, 90, 215, "Code"],
Cell[109532, 2827, 3384, 94, 229, "Code"],
Cell[112919, 2923, 44, 1, 5, "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}
]
*)

(* End of internal cache information *)
