(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    340296,       8930]
NotebookOptionsPosition[    326502,       8617]
NotebookOutlinePosition[    327628,       8656]
CellTagsIndexPosition[    327585,       8653]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.124.1a, CRC 60, A&S 3.3.21", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496464724241043*^9}],

Cell["Derivation: Primitive rule", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496464732151495*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["ArcTan", "\[Prime]",
     MultilineFunction->None], "[", "z", "]"}], "=", 
   FractionBox["1", 
    RowBox[{"1", "+", 
     SuperscriptBox["z", "2"]}]]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
   3.4964427205723457`*^9, 3.496442726484756*^9}, {3.4964511572548466`*^9, 
   3.496451196884902*^9}, {3.4964647496374955`*^9, 3.4964647593420506`*^9}, 
   3.496464854901516*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   FractionBox["a", "b"], ">", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.4964646821336346`*^9, 3.4964646836247196`*^9}, {3.4974685108686657`*^9, 
   3.497468517264677*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SqrtBox[
       FractionBox["a", "b"]], "a"]}]}], 
   RowBox[{"ArcTan", "[", 
    FractionBox["x", 
     SqrtBox[
      FractionBox["a", "b"]]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.4964644989841585`*^9, 3.4964645106438255`*^9}, 
   3.496464612803669*^9, {3.4974684782802086`*^9, 3.497468494629037*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Rt", "[", 
      RowBox[{
       RowBox[{"a", "/", "b"}], ",", "2"}], "]"}], "/", "a"}], "*", 
    RowBox[{"ArcTan", "[", 
     RowBox[{"x", "/", 
      RowBox[{"Rt", "[", 
       RowBox[{
        RowBox[{"a", "/", "b"}], ",", "2"}], "]"}]}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"PosQ", "[", 
     RowBox[{"a", "/", "b"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, {
   3.4964643615542984`*^9, 3.496464371474866*^9}, {3.4964646331298313`*^9, 
   3.496464674701209*^9}, {3.497468410248489*^9, 3.497468442712146*^9}, {
   3.497497272228363*^9, 3.4974972766683693`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.124.1b', CRC 61b, A&S 3.3.23", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496464724241043*^9, 3.496464835057381*^9}],

Cell["Derivation: Primitive rule", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496464732151495*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["ArcTanh", "\[Prime]",
     MultilineFunction->None], "[", "z", "]"}], "=", 
   FractionBox["1", 
    RowBox[{"1", "-", 
     SuperscriptBox["z", "2"]}]]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
  3.4964427205723457`*^9, 3.496442726484756*^9}, {3.4964511572548466`*^9, 
  3.496451196884902*^9}, {3.4964647496374955`*^9, 3.4964647593420506`*^9}, {
  3.4964648485541534`*^9, 3.496464850611271*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"\[Not]", 
   RowBox[{"(", 
    RowBox[{
     FractionBox["a", "b"], ">", "0"}], ")"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.4964646821336346`*^9, 3.4964646836247196`*^9}, {3.4964650083112907`*^9, 
   3.496465017058791*^9}, {3.4974686036732283`*^9, 3.4974686036732283`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SqrtBox[
       RowBox[{"-", 
        FractionBox["a", "b"]}]], "a"]}]}], 
   RowBox[{"ArcTanh", "[", 
    FractionBox["x", 
     SqrtBox[
      RowBox[{"-", 
       FractionBox["a", "b"]}]]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.4964644989841585`*^9, 3.4964645106438255`*^9}, 
   3.496464612803669*^9, {3.4974684782802086`*^9, 3.497468494629037*^9}, {
   3.497468554845143*^9, 3.497468564080359*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Rt", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "a"}], "/", "b"}], ",", "2"}], "]"}], "/", "a"}], "*", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{"x", "/", 
      RowBox[{"Rt", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "a"}], "/", "b"}], ",", "2"}], "]"}]}], "]"}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NegQ", "[", 
     RowBox[{"a", "/", "b"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, {
   3.4964643615542984`*^9, 3.496464371474866*^9}, {3.4964646331298313`*^9, 
   3.496464674701209*^9}, {3.4964648742126207`*^9, 3.4964648899195194`*^9}, 
   3.4974684142108955`*^9, {3.497468580585188*^9, 3.4974685869967995`*^9}, {
   3.497497281228376*^9, 3.497497288458386*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.126.1.2, CRC 74", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496464724241043*^9, 3.496464835057381*^9, 3.496465076517192*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496464732151495*^9, 3.4964650841426277`*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   FractionBox["r", "s"], "=", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["a", "b"], ")"}], 
    RowBox[{"1", "/", "3"}]]}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["z", "3"]}]}]], "=", 
   RowBox[{
    FractionBox["r", 
     RowBox[{"3", " ", "a", " ", 
      RowBox[{"(", 
       RowBox[{"r", "+", 
        RowBox[{"s", " ", "z"}]}], ")"}]}]], "+", 
    FractionBox[
     RowBox[{"r", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "r"}], "-", 
        RowBox[{"s", " ", "z"}]}], ")"}]}], 
     RowBox[{"3", " ", "a", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["r", "2"], "-", 
        RowBox[{"r", " ", "s", " ", "z"}], "+", 
        RowBox[{
         SuperscriptBox["s", "2"], 
         SuperscriptBox["z", "2"]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
  3.4964427205723457`*^9, 3.496442726484756*^9}, {3.4964511572548466`*^9, 
  3.496451196884902*^9}, {3.4964647496374955`*^9, 3.4964647593420506`*^9}, {
  3.4964648485541534`*^9, 3.496464850611271*^9}, {3.49646510358774*^9, 
  3.49646514904034*^9}, {3.496465388706048*^9, 3.4964653947943964`*^9}, {
  3.4964654272642536`*^9, 3.496465506310775*^9}, {3.4965119410888863`*^9, 
  3.4965119432288895`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   FractionBox["a", "b"], ">", "0"}]]],
 ", let ",
 Cell[BoxData[
  RowBox[{
   FractionBox["r", "s"], "=", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["a", "b"], ")"}], 
    RowBox[{"1", "/", "3"}]]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.4964646821336346`*^9, 3.4964646836247196`*^9}, {3.4964650083112907`*^9, 
   3.496465017058791*^9}, {3.4964656995018244`*^9, 3.496465714085659*^9}, {
   3.4964667294907365`*^9, 3.496466753485109*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "3"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["r", 
       RowBox[{"3", " ", "a"}]]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"r", "+", 
        RowBox[{"s", " ", "x"}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["r", 
    RowBox[{"3", " ", "a"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"2", " ", "r"}], "-", 
       RowBox[{"s", " ", "x"}]}], 
      RowBox[{
       SuperscriptBox["r", "2"], "-", 
       RowBox[{"r", " ", "s", " ", "x"}], "+", 
       RowBox[{
        SuperscriptBox["s", "2"], " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.4964644989841585`*^9, 3.4964645106438255`*^9}, 
   3.496464612803669*^9, 3.4964649458717194`*^9, {3.4964652217164965`*^9, 
   3.4964652233565903`*^9}, 3.4964653445205207`*^9, 3.4964654227749968`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "3"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", "=", 
        RowBox[{"Numerator", "[", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{"a", "/", "b"}], ",", "3"}], "]"}], "]"}]}], ",", " ", 
       RowBox[{"s", "=", 
        RowBox[{"Denominator", "[", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{"a", "/", "b"}], ",", "3"}], "]"}], "]"}]}]}], "}"}], ",", 
     "\n", "  ", 
     RowBox[{
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"r", "/", 
         RowBox[{"(", 
          RowBox[{"3", "*", "a"}], ")"}]}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{"1", "/", 
           RowBox[{"(", 
            RowBox[{"r", "+", 
             RowBox[{"s", "*", "x"}]}], ")"}]}], ",", "x"}], "]"}]}], "]"}], 
      " ", "+", "\n", "  ", 
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"r", "/", 
         RowBox[{"(", 
          RowBox[{"3", "*", "a"}], ")"}]}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", "*", "r"}], "-", 
             RowBox[{"s", "*", "x"}]}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"r", "^", "2"}], "-", 
             RowBox[{"r", "*", "s", "*", "x"}], "+", 
             RowBox[{
              RowBox[{"s", "^", "2"}], "*", 
              RowBox[{"x", "^", "2"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
       "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"PosQ", "[", 
     RowBox[{"a", "/", "b"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, {
   3.4964643615542984`*^9, 3.496464371474866*^9}, {3.4964646331298313`*^9, 
   3.496464674701209*^9}, {3.4964648742126207`*^9, 3.4964648899195194`*^9}, 
   3.4964651866304903`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496464732151495*^9, 3.4964650841426277`*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   FractionBox["r", "s"], "=", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", 
      FractionBox["a", "b"]}], ")"}], 
    RowBox[{"1", "/", "3"}]]}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["z", "3"]}]}]], "=", 
   RowBox[{
    FractionBox["r", 
     RowBox[{"3", " ", "a", " ", 
      RowBox[{"(", 
       RowBox[{"r", "-", 
        RowBox[{"s", " ", "z"}]}], ")"}]}]], "+", 
    FractionBox[
     RowBox[{"r", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "r"}], "+", 
        RowBox[{"s", " ", "z"}]}], ")"}]}], 
     RowBox[{"3", " ", "a", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["r", "2"], "+", 
        RowBox[{"r", " ", "s", " ", "z"}], "+", 
        RowBox[{
         SuperscriptBox["s", "2"], 
         SuperscriptBox["z", "2"]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
   3.4964427205723457`*^9, 3.496442726484756*^9}, {3.4964511572548466`*^9, 
   3.496451196884902*^9}, {3.4964647496374955`*^9, 3.4964647593420506`*^9}, {
   3.4964648485541534`*^9, 3.496464850611271*^9}, {3.49646510358774*^9, 
   3.49646514904034*^9}, {3.496465388706048*^9, 3.4964653947943964`*^9}, {
   3.4964654272642536`*^9, 3.496465506310775*^9}, 3.496465635184146*^9, {
   3.496465683603915*^9, 3.4964656938304996`*^9}, {3.4965119486088967`*^9, 
   3.496511950488899*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"\[Not]", 
   RowBox[{"(", 
    RowBox[{
     FractionBox["a", "b"], ">", "0"}], ")"}]}]]],
 ", let ",
 Cell[BoxData[
  RowBox[{
   FractionBox["r", "s"], "=", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", 
      FractionBox["a", "b"]}], ")"}], 
    RowBox[{"1", "/", "3"}]]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.4964646821336346`*^9, 3.4964646836247196`*^9}, {3.4964650083112907`*^9, 
   3.496465017058791*^9}, {3.4964656995018244`*^9, 3.496465714085659*^9}, {
   3.4964667294907365`*^9, 3.496466753485109*^9}, {3.4964667868360167`*^9, 
   3.4964667912782707`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "3"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["r", 
       RowBox[{"3", " ", "a"}]]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"r", "-", 
        RowBox[{"s", " ", "x"}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["r", 
    RowBox[{"3", " ", "a"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"2", " ", "r"}], "+", 
       RowBox[{"s", " ", "x"}]}], 
      RowBox[{
       SuperscriptBox["r", "2"], "+", 
       RowBox[{"r", " ", "s", " ", "x"}], "+", 
       RowBox[{
        SuperscriptBox["s", "2"], " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.4964644989841585`*^9, 3.4964645106438255`*^9}, 
   3.496464612803669*^9, 3.4964649458717194`*^9, {3.4964652217164965`*^9, 
   3.4964652233565903`*^9}, 3.4964653445205207`*^9, 3.4964654227749968`*^9, 
   3.4964656745803995`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "3"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", "=", 
        RowBox[{"Numerator", "[", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "a"}], "/", "b"}], ",", "3"}], "]"}], "]"}]}], ",", 
       " ", 
       RowBox[{"s", "=", 
        RowBox[{"Denominator", "[", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "a"}], "/", "b"}], ",", "3"}], "]"}], "]"}]}]}], 
      "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"r", "/", 
         RowBox[{"(", 
          RowBox[{"3", "*", "a"}], ")"}]}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{"1", "/", 
           RowBox[{"(", 
            RowBox[{"r", "-", 
             RowBox[{"s", "*", "x"}]}], ")"}]}], ",", "x"}], "]"}]}], "]"}], 
      " ", "+", "\n", "  ", 
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"r", "/", 
         RowBox[{"(", 
          RowBox[{"3", "*", "a"}], ")"}]}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", "*", "r"}], "+", 
             RowBox[{"s", "*", "x"}]}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"r", "^", "2"}], "+", 
             RowBox[{"r", "*", "s", "*", "x"}], "+", 
             RowBox[{
              RowBox[{"s", "^", "2"}], "*", 
              RowBox[{"x", "^", "2"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
       "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NegQ", "[", 
     RowBox[{"a", "/", "b"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, {
   3.4964643615542984`*^9, 3.496464371474866*^9}, {3.4964646331298313`*^9, 
   3.496464674701209*^9}, {3.4964648742126207`*^9, 3.4964648899195194`*^9}, 
   3.4964651866304903`*^9, 3.4964656304258738`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.132.1.1', CRC 77'", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496464724241043*^9, 3.496464835057381*^9, 3.496465076517192*^9, 
   3.4964658936609297`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496464732151495*^9, 3.4964650841426277`*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   FractionBox["r", "s"], "=", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["a", "b"], ")"}], 
    RowBox[{"1", "/", "4"}]]}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["z", "4"]}]}]], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"r", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SqrtBox["2"], " ", "r"}], "-", 
        RowBox[{"s", " ", "z"}]}], ")"}]}], 
     RowBox[{"2", 
      SqrtBox["2"], "a", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["r", "2"], "-", 
        RowBox[{
         SqrtBox["2"], " ", "r", " ", "s", " ", "z"}], "+", 
        RowBox[{
         SuperscriptBox["s", "2"], " ", 
         SuperscriptBox["z", "2"]}]}], ")"}]}]], "+", 
    FractionBox[
     RowBox[{"r", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SqrtBox["2"], " ", "r"}], "+", 
        RowBox[{"s", " ", "z"}]}], ")"}]}], 
     RowBox[{"2", 
      SqrtBox["2"], "a", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["r", "2"], "+", 
        RowBox[{
         SqrtBox["2"], " ", "r", " ", "s", " ", "z"}], "+", 
        RowBox[{
         SuperscriptBox["s", "2"], " ", 
         SuperscriptBox["z", "2"]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
   3.4964427205723457`*^9, 3.496442726484756*^9}, {3.4964511572548466`*^9, 
   3.496451196884902*^9}, {3.4964647496374955`*^9, 3.4964647593420506`*^9}, {
   3.4964648485541534`*^9, 3.496464850611271*^9}, {3.49646510358774*^9, 
   3.49646514904034*^9}, {3.496465388706048*^9, 3.4964653947943964`*^9}, {
   3.4964654272642536`*^9, 3.496465506310775*^9}, 3.496465635184146*^9, {
   3.496465683603915*^9, 3.4964656938304996`*^9}, {3.4964661605171933`*^9, 
   3.4964661725558815`*^9}, {3.4964662031186295`*^9, 3.496466318316219*^9}, 
   3.49646637288834*^9, {3.4964678366970654`*^9, 3.496467850475853*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    FractionBox["n", "4"], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
   "\[And]", " ", 
   RowBox[{"n", ">", "2"}], " ", "\[And]", " ", 
   RowBox[{
    FractionBox["a", "b"], ">", "0"}]}]]],
 ", let ",
 Cell[BoxData[
  RowBox[{
   FractionBox["r", "s"], "=", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["a", "b"], ")"}], 
    RowBox[{"1", "/", "4"}]]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.4964646821336346`*^9, 3.4964646836247196`*^9}, {3.4964650083112907`*^9, 
   3.496465017058791*^9}, 3.496465725016284*^9, 3.4964663908553677`*^9, {
   3.4964664249763193`*^9, 3.4964664960673857`*^9}, {3.496466820055917*^9, 
   3.4964668354067945`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["r", 
       RowBox[{"2", " ", 
        SqrtBox["2"], " ", "a"}]]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{
         SqrtBox["2"], " ", "r"}], "-", 
        RowBox[{"s", " ", 
         SuperscriptBox["x", 
          RowBox[{"n", "/", "4"}]]}]}], 
       RowBox[{
        SuperscriptBox["r", "2"], "-", 
        RowBox[{
         SqrtBox["2"], " ", "r", " ", "s", " ", 
         SuperscriptBox["x", 
          RowBox[{"n", "/", "4"}]]}], "+", 
        RowBox[{
         SuperscriptBox["s", "2"], " ", 
         SuperscriptBox["x", 
          RowBox[{"n", "/", "2"}]]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["r", 
    RowBox[{"2", " ", 
     SqrtBox["2"], " ", "a"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{
        SqrtBox["2"], " ", "r"}], "+", 
       RowBox[{"s", " ", 
        SuperscriptBox["x", 
         RowBox[{"n", "/", "4"}]]}]}], 
      RowBox[{
       SuperscriptBox["r", "2"], "+", 
       RowBox[{
        SqrtBox["2"], " ", "r", " ", "s", " ", 
        SuperscriptBox["x", 
         RowBox[{"n", "/", "4"}]]}], "+", 
       RowBox[{
        SuperscriptBox["s", "2"], " ", 
        SuperscriptBox["x", 
         RowBox[{"n", "/", "2"}]]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.4964644989841585`*^9, 3.4964645106438255`*^9}, 
   3.496464612803669*^9, 3.4964649458717194`*^9, {3.4964652217164965`*^9, 
   3.4964652233565903`*^9}, 3.4964653445205207`*^9, 3.4964654227749968`*^9, 
   3.4964656745803995`*^9, {3.496466129287407*^9, 3.4964661393309813`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ",
   ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", "=", 
        RowBox[{"Numerator", "[", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{"a", "/", "b"}], ",", "4"}], "]"}], "]"}]}], ",", " ", 
       RowBox[{"s", "=", 
        RowBox[{"Denominator", "[", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{"a", "/", "b"}], ",", "4"}], "]"}], "]"}]}]}], "}"}], ",", 
     "\n", "  ", 
     RowBox[{
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"r", "/", 
         RowBox[{"(", 
          RowBox[{"2", "*", 
           RowBox[{"Sqrt", "[", "2", "]"}], "*", "a"}], ")"}]}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"Sqrt", "[", "2", "]"}], "*", "r"}], "-", 
             RowBox[{"s", "*", 
              RowBox[{"x", "^", 
               RowBox[{"(", 
                RowBox[{"n", "/", "4"}], ")"}]}]}]}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"r", "^", "2"}], "-", 
             RowBox[{
              RowBox[{"Sqrt", "[", "2", "]"}], "*", "r", "*", "s", "*", 
              RowBox[{"x", "^", 
               RowBox[{"(", 
                RowBox[{"n", "/", "4"}], ")"}]}]}], "+", 
             RowBox[{
              RowBox[{"s", "^", "2"}], "*", 
              RowBox[{"x", "^", 
               RowBox[{"(", 
                RowBox[{"n", "/", "2"}], ")"}]}]}]}], ")"}]}], ",", "x"}], 
         "]"}]}], "]"}], " ", "+", "\n", "  ", 
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"r", "/", 
         RowBox[{"(", 
          RowBox[{"2", "*", 
           RowBox[{"Sqrt", "[", "2", "]"}], "*", "a"}], ")"}]}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"Sqrt", "[", "2", "]"}], "*", "r"}], "+", 
             RowBox[{"s", "*", 
              RowBox[{"x", "^", 
               RowBox[{"(", 
                RowBox[{"n", "/", "4"}], ")"}]}]}]}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"r", "^", "2"}], "+", 
             RowBox[{
              RowBox[{"Sqrt", "[", "2", "]"}], "*", "r", "*", "s", "*", 
              RowBox[{"x", "^", 
               RowBox[{"(", 
                RowBox[{"n", "/", "4"}], ")"}]}]}], "+", 
             RowBox[{
              RowBox[{"s", "^", "2"}], "*", 
              RowBox[{"x", "^", 
               RowBox[{"(", 
                RowBox[{"n", "/", "2"}], ")"}]}]}]}], ")"}]}], ",", "x"}], 
         "]"}]}], "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"n", "/", "4"}], "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "2"}], " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", 
     RowBox[{"a", "/", "b"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, {
   3.4964643615542984`*^9, 3.496464371474866*^9}, {3.4964646331298313`*^9, 
   3.496464674701209*^9}, {3.4964648742126207`*^9, 3.4964648899195194`*^9}, 
   3.4964651866304903`*^9, 3.4964656304258738`*^9, 3.4964658849164295`*^9, {
   3.496466500015611*^9, 3.496466503963837*^9}, {3.497497368588498*^9, 
   3.497497369288499*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.132.1.2', CRC 78'", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496464724241043*^9, 3.496464835057381*^9, 3.496465076517192*^9, 
   3.4964658936609297`*^9, 3.496466613476101*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496464732151495*^9, 3.4964650841426277`*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   FractionBox["r", "s"], "=", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", 
      FractionBox["a", "b"]}], ")"}], 
    RowBox[{"1", "/", "2"}]]}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["z", "2"]}]}]], "=", 
   RowBox[{
    FractionBox["r", 
     RowBox[{"2", "a", 
      RowBox[{"(", 
       RowBox[{"r", "-", 
        RowBox[{"s", " ", "z"}]}], ")"}]}]], "+", 
    FractionBox["r", 
     RowBox[{"2", "a", 
      RowBox[{"(", 
       RowBox[{"r", "+", 
        RowBox[{"s", " ", "z"}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
   3.4964427205723457`*^9, 3.496442726484756*^9}, {3.4964511572548466`*^9, 
   3.496451196884902*^9}, {3.4964647496374955`*^9, 3.4964647593420506`*^9}, {
   3.4964648485541534`*^9, 3.496464850611271*^9}, {3.49646510358774*^9, 
   3.49646514904034*^9}, {3.496465388706048*^9, 3.4964653947943964`*^9}, {
   3.4964654272642536`*^9, 3.496465506310775*^9}, 3.496465635184146*^9, {
   3.496465683603915*^9, 3.4964656938304996`*^9}, {3.4964661605171933`*^9, 
   3.4964661725558815`*^9}, {3.4964662031186295`*^9, 3.496466318316219*^9}, 
   3.49646637288834*^9, {3.4964666554985046`*^9, 3.496466712977792*^9}, {
   3.4964668475174875`*^9, 3.4964668531178074`*^9}, {3.4964669199346294`*^9, 
   3.4964669734406896`*^9}, {3.4964677989889083`*^9, 3.4964678214221916`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    FractionBox["n", "4"], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
   "\[And]", " ", 
   RowBox[{"n", ">", "2"}], " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{
      FractionBox["a", "b"], ">", "0"}], ")"}]}]}]]],
 ", ",
 "let ",
 Cell[BoxData[
  RowBox[{
   FractionBox["r", "s"], "=", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", 
      FractionBox["a", "b"]}], ")"}], 
    RowBox[{"1", "/", "2"}]]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.4964646821336346`*^9, 3.4964646836247196`*^9}, {3.4964650083112907`*^9, 
   3.496465017058791*^9}, 3.496465725016284*^9, 3.4964663908553677`*^9, {
   3.4964664249763193`*^9, 3.4964664960673857`*^9}, {3.4964670220844717`*^9, 
   3.496467057769513*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["r", 
       RowBox[{"2", " ", "a"}]]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"r", "-", 
        RowBox[{"s", " ", 
         SuperscriptBox["x", 
          RowBox[{"n", "/", "2"}]]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["r", 
    RowBox[{"2", " ", "a"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"r", "+", 
       RowBox[{"s", " ", 
        SuperscriptBox["x", 
         RowBox[{"n", "/", "2"}]]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.4964644989841585`*^9, 3.4964645106438255`*^9}, 
   3.496464612803669*^9, 3.4964649458717194`*^9, {3.4964652217164965`*^9, 
   3.4964652233565903`*^9}, 3.4964653445205207`*^9, 3.4964654227749968`*^9, 
   3.4964656745803995`*^9, {3.496466129287407*^9, 3.4964661393309813`*^9}, 
   3.4964668963682814`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ",
   ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", "=", 
        RowBox[{"Numerator", "[", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "a"}], "/", "b"}], ",", "2"}], "]"}], "]"}]}], ",", 
       " ", 
       RowBox[{"s", "=", 
        RowBox[{"Denominator", "[", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "a"}], "/", "b"}], ",", "2"}], "]"}], "]"}]}]}], 
      "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"r", "/", 
         RowBox[{"(", 
          RowBox[{"2", "*", "a"}], ")"}]}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{"1", "/", 
           RowBox[{"(", 
            RowBox[{"r", "-", 
             RowBox[{"s", "*", 
              RowBox[{"x", "^", 
               RowBox[{"(", 
                RowBox[{"n", "/", "2"}], ")"}]}]}]}], ")"}]}], ",", "x"}], 
         "]"}]}], "]"}], " ", "+", "\n", "  ", 
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"r", "/", 
         RowBox[{"(", 
          RowBox[{"2", "*", "a"}], ")"}]}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{"1", "/", 
           RowBox[{"(", 
            RowBox[{"r", "+", 
             RowBox[{"s", "*", 
              RowBox[{"x", "^", 
               RowBox[{"(", 
                RowBox[{"n", "/", "2"}], ")"}]}]}]}], ")"}]}], ",", "x"}], 
         "]"}]}], "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"n", "/", "4"}], "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "2"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"PositiveQ", "[", 
      RowBox[{"a", "/", "b"}], "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, {
   3.4964643615542984`*^9, 3.496464371474866*^9}, {3.4964646331298313`*^9, 
   3.496464674701209*^9}, {3.4964648742126207`*^9, 3.4964648899195194`*^9}, 
   3.4964651866304903`*^9, 3.4964656304258738`*^9, 3.4964658849164295`*^9, {
   3.496466500015611*^9, 3.496466503963837*^9}, 3.496466597108165*^9, {
   3.4974973779785113`*^9, 3.497497381278516*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496464732151495*^9, 3.4964650841426277`*^9}],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"n", "-", "2"}], "4"], "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{
   FractionBox["r", "s"], "=", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["a", "b"], ")"}], 
    RowBox[{"2", "/", "n"}]]}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["z", "n"]}]}]], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"2", "r"}], 
     RowBox[{"a", " ", "n", 
      RowBox[{"(", 
       RowBox[{"r", "+", 
        RowBox[{"s", " ", 
         SuperscriptBox["z", "2"]}]}], ")"}]}]], "+", 
    RowBox[{
     FractionBox[
      RowBox[{"4", "r"}], 
      RowBox[{"a", " ", "n"}]], 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"k", "=", "1"}], 
       FractionBox[
        RowBox[{"n", "-", "2"}], "4"]], 
      FractionBox[
       RowBox[{"r", "-", 
        RowBox[{"s", " ", 
         RowBox[{"Cos", "[", 
          FractionBox[
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "k"}], "-", "1"}], ")"}], " ", "\[Pi]"}], 
           "n"], "]"}], " ", 
         SuperscriptBox["z", "2"]}]}], 
       RowBox[{
        SuperscriptBox["r", "2"], "-", 
        RowBox[{"2", " ", "r", " ", "s", " ", 
         RowBox[{"Cos", "[", 
          FractionBox[
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "k"}], "-", "1"}], ")"}], " ", "\[Pi]"}], 
           "n"], "]"}], " ", 
         SuperscriptBox["z", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["s", "2"], " ", 
         SuperscriptBox["z", "4"]}]}]]}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
   3.4964427205723457`*^9, 3.496442726484756*^9}, {3.4964511572548466`*^9, 
   3.496451196884902*^9}, {3.4964647496374955`*^9, 3.4964647593420506`*^9}, {
   3.4964648485541534`*^9, 3.496464850611271*^9}, {3.49646510358774*^9, 
   3.49646514904034*^9}, {3.496465388706048*^9, 3.4964653947943964`*^9}, {
   3.4964654272642536`*^9, 3.496465506310775*^9}, 3.496465635184146*^9, {
   3.496465683603915*^9, 3.4964656938304996`*^9}, {3.4964661605171933`*^9, 
   3.4964661725558815`*^9}, {3.4964662031186295`*^9, 3.496466318316219*^9}, 
   3.49646637288834*^9, {3.4964666554985046`*^9, 3.496466712977792*^9}, {
   3.4964668475174875`*^9, 3.4964668531178074`*^9}, {3.4964669199346294`*^9, 
   3.4964669734406896`*^9}, 3.496467328943023*^9, {3.496467618375578*^9, 
   3.4964676253709784`*^9}, {3.4964677807798667`*^9, 3.496467788602314*^9}, {
   3.496467898612606*^9, 3.496467977559122*^9}, {3.496468036723506*^9, 
   3.49646804064073*^9}, {3.496468137265257*^9, 3.4964682293865256`*^9}, {
   3.496468813145915*^9, 3.496468813864956*^9}, {3.4965147389428034`*^9, 
   3.4965147389428034`*^9}}],

Cell[TextData[{
 "Rule: If ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{"n", "-", "2"}], "4"], "\[Element]", "\[DoubleStruckCapitalZ]"}],
    " ", "\[And]", " ", 
   RowBox[{"n", ">", "2"}], " ", "\[And]", " ", 
   RowBox[{
    FractionBox["a", "b"], ">", "0"}]}]]],
 ", let ",
 Cell[BoxData[
  RowBox[{
   FractionBox["r", "s"], "=", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["a", "b"], ")"}], 
    RowBox[{"2", "/", "n"}]]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.4964646821336346`*^9, 3.4964646836247196`*^9}, {3.4964650083112907`*^9, 
   3.496465017058791*^9}, 3.496465725016284*^9, 3.4964663908553677`*^9, {
   3.4964664249763193`*^9, 3.4964664960673857`*^9}, {3.4964670220844717`*^9, 
   3.496467057769513*^9}, {3.4964675741690493`*^9, 3.496467598274428*^9}, 
   3.4964682381240253`*^9, 3.4964688263306684`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"2", " ", "r"}], 
       RowBox[{"a", " ", "n"}]]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"r", "+", 
        RowBox[{"s", " ", 
         SuperscriptBox["x", "2"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"4", " ", "r"}], 
    RowBox[{"a", " ", "n"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"k", "=", "1"}], 
      FractionBox[
       RowBox[{"n", "-", "2"}], "4"]], 
     RowBox[{
      FractionBox[
       RowBox[{"r", "-", 
        RowBox[{"s", " ", 
         RowBox[{"Cos", "[", 
          FractionBox[
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "k"}], "-", "1"}], ")"}], " ", "\[Pi]"}], 
           "n"], "]"}], " ", 
         SuperscriptBox["x", "2"]}]}], 
       RowBox[{
        SuperscriptBox["r", "2"], "-", 
        RowBox[{"2", " ", "r", " ", "s", " ", 
         RowBox[{"Cos", "[", 
          FractionBox[
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "k"}], "-", "1"}], ")"}], " ", "\[Pi]"}], 
           "n"], "]"}], " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["s", "2"], " ", 
         SuperscriptBox["x", "4"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.4964644989841585`*^9, 3.4964645106438255`*^9}, 
   3.496464612803669*^9, 3.4964649458717194`*^9, {3.4964652217164965`*^9, 
   3.4964652233565903`*^9}, 3.4964653445205207`*^9, 3.4964654227749968`*^9, 
   3.4964656745803995`*^9, {3.496466129287407*^9, 3.4964661393309813`*^9}, 
   3.4964668963682814`*^9, 3.4964672281532583`*^9, 3.496467531557612*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ",
   ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", "=", 
        RowBox[{"Numerator", "[", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{"a", "/", "b"}], ",", 
           RowBox[{"n", "/", "2"}]}], "]"}], "]"}]}], ",", " ", 
       RowBox[{"s", "=", 
        RowBox[{"Denominator", "[", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{"a", "/", "b"}], ",", 
           RowBox[{"n", "/", "2"}]}], "]"}], "]"}]}]}], "}"}], ",", "\n", 
     "  ", 
     RowBox[{
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"2", "*", 
         RowBox[{"r", "/", 
          RowBox[{"(", 
           RowBox[{"a", "*", "n"}], ")"}]}]}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{"1", "/", 
           RowBox[{"(", 
            RowBox[{"r", "+", 
             RowBox[{"s", "*", 
              RowBox[{"x", "^", "2"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
       "]"}], " ", "+", "\n", "  ", 
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"4", "*", 
         RowBox[{"r", "/", 
          RowBox[{"(", 
           RowBox[{"a", "*", "n"}], ")"}]}]}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{"Sum", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"r", "-", 
               RowBox[{"s", "*", 
                RowBox[{"Cos", "[", 
                 RowBox[{"2", "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", "*", "k"}], "-", "1"}], ")"}], "*", 
                  RowBox[{"Pi", "/", "n"}]}], "]"}], "*", 
                RowBox[{"x", "^", "2"}]}]}], ")"}], "/", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"r", "^", "2"}], "-", 
               RowBox[{"2", "*", "r", "*", "s", "*", 
                RowBox[{"Cos", "[", 
                 RowBox[{"2", "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", "*", "k"}], "-", "1"}], ")"}], "*", 
                  RowBox[{"Pi", "/", "n"}]}], "]"}], "*", 
                RowBox[{"x", "^", "2"}]}], "+", 
               RowBox[{
                RowBox[{"s", "^", "2"}], "*", 
                RowBox[{"x", "^", "4"}]}]}], ")"}]}], ",", "\n", "    ", 
            RowBox[{"{", 
             RowBox[{"k", ",", "1", ",", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"n", "-", "2"}], ")"}], "/", "4"}]}], "}"}]}], "]"}], 
          ",", "x"}], "]"}]}], "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"n", "-", "2"}], ")"}], "/", "4"}], "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "2"}], " ", "&&", " ", 
    RowBox[{"PosQ", "[", 
     RowBox[{"a", "/", "b"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, {
   3.4964643615542984`*^9, 3.496464371474866*^9}, {3.4964646331298313`*^9, 
   3.496464674701209*^9}, {3.4964648742126207`*^9, 3.4964648899195194`*^9}, 
   3.4964651866304903`*^9, 3.4964656304258738`*^9, 3.4964658849164295`*^9, {
   3.496466500015611*^9, 3.496466503963837*^9}, 3.496466597108165*^9, 
   3.4964671193880377`*^9, {3.4964674556312695`*^9, 3.496467494522494*^9}, {
   3.4969493584529734`*^9, 3.4969493606829767`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496464732151495*^9, 3.4964650841426277`*^9}],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"n", "-", "2"}], "4"], "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{
   FractionBox["r", "s"], "=", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", 
      FractionBox["a", "b"]}], ")"}], 
    RowBox[{"2", "/", "n"}]]}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["z", "n"]}]}]], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"2", "r"}], 
     RowBox[{"a", " ", "n", 
      RowBox[{"(", 
       RowBox[{"r", "-", 
        RowBox[{"s", " ", 
         SuperscriptBox["z", "2"]}]}], ")"}]}]], "+", 
    RowBox[{
     FractionBox[
      RowBox[{"4", "r"}], 
      RowBox[{"a", " ", "n"}]], 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"k", "=", "1"}], 
       FractionBox[
        RowBox[{"n", "-", "2"}], "4"]], 
      FractionBox[
       RowBox[{"r", "-", 
        RowBox[{"s", " ", 
         RowBox[{"Cos", "[", 
          FractionBox[
           RowBox[{"4", " ", "k", " ", "\[Pi]"}], "n"], "]"}], " ", 
         SuperscriptBox["z", "2"]}]}], 
       RowBox[{
        SuperscriptBox["r", "2"], "-", 
        RowBox[{"2", " ", "r", " ", "s", " ", 
         RowBox[{"Cos", "[", 
          FractionBox[
           RowBox[{"4", " ", "k", " ", "\[Pi]"}], "n"], "]"}], " ", 
         SuperscriptBox["z", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["s", "2"], " ", 
         SuperscriptBox["z", "4"]}]}]]}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
   3.4964427205723457`*^9, 3.496442726484756*^9}, {3.4964511572548466`*^9, 
   3.496451196884902*^9}, {3.4964647496374955`*^9, 3.4964647593420506`*^9}, {
   3.4964648485541534`*^9, 3.496464850611271*^9}, {3.49646510358774*^9, 
   3.49646514904034*^9}, {3.496465388706048*^9, 3.4964653947943964`*^9}, {
   3.4964654272642536`*^9, 3.496465506310775*^9}, 3.496465635184146*^9, {
   3.496465683603915*^9, 3.4964656938304996`*^9}, {3.4964661605171933`*^9, 
   3.4964661725558815`*^9}, {3.4964662031186295`*^9, 3.496466318316219*^9}, 
   3.49646637288834*^9, {3.4964666554985046`*^9, 3.496466712977792*^9}, {
   3.4964668475174875`*^9, 3.4964668531178074`*^9}, {3.4964669199346294`*^9, 
   3.4964669734406896`*^9}, 3.496467328943023*^9, {3.496467618375578*^9, 
   3.4964676253709784`*^9}, {3.4964677807798667`*^9, 3.496467788602314*^9}, {
   3.496467898612606*^9, 3.496467977559122*^9}, {3.496468036723506*^9, 
   3.49646804064073*^9}, {3.496468137265257*^9, 3.4964682293865256`*^9}, 
   3.4964683872925577`*^9, {3.4964685059903464`*^9, 3.496468506484375*^9}, {
   3.4964685516159563`*^9, 3.4964685617155337`*^9}, 3.4964688437766666`*^9, {
   3.496514746142813*^9, 3.496514746142813*^9}}],

Cell[TextData[{
 "Rule: If ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{"n", "-", "2"}], "4"], "\[Element]", "\[DoubleStruckCapitalZ]"}],
    " ", "\[And]", " ", 
   RowBox[{"n", ">", "2"}], " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{
      FractionBox["a", "b"], ">", "0"}], ")"}]}]}]]],
 ", let ",
 Cell[BoxData[
  RowBox[{
   FractionBox["r", "s"], "=", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", 
      FractionBox["a", "b"]}], ")"}], 
    RowBox[{"2", "/", "n"}]]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.4964646821336346`*^9, 3.4964646836247196`*^9}, {3.4964650083112907`*^9, 
   3.496465017058791*^9}, 3.496465725016284*^9, 3.4964663908553677`*^9, {
   3.4964664249763193`*^9, 3.4964664960673857`*^9}, {3.4964670220844717`*^9, 
   3.496467057769513*^9}, {3.4964675741690493`*^9, 3.496467598274428*^9}, 
   3.4964682381240253`*^9, {3.4964683731897507`*^9, 3.49646838208926*^9}, 
   3.4964688463948164`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"2", " ", "r"}], 
       RowBox[{"a", " ", "n"}]]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"r", "-", 
        RowBox[{"s", " ", 
         SuperscriptBox["x", "2"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"4", " ", "r"}], 
    RowBox[{"a", " ", "n"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"k", "=", "1"}], 
      FractionBox[
       RowBox[{"n", "-", "2"}], "4"]], 
     RowBox[{
      FractionBox[
       RowBox[{"r", "-", 
        RowBox[{"s", " ", 
         RowBox[{"Cos", "[", 
          FractionBox[
           RowBox[{"4", " ", "k", " ", "\[Pi]"}], "n"], "]"}], " ", 
         SuperscriptBox["x", "2"]}]}], 
       RowBox[{
        SuperscriptBox["r", "2"], "-", 
        RowBox[{"2", " ", "r", " ", "s", " ", 
         RowBox[{"Cos", "[", 
          FractionBox[
           RowBox[{"4", " ", "k", " ", "\[Pi]"}], "n"], "]"}], " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["s", "2"], " ", 
         SuperscriptBox["x", "4"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.4964644989841585`*^9, 3.4964645106438255`*^9}, 
   3.496464612803669*^9, 3.4964649458717194`*^9, {3.4964652217164965`*^9, 
   3.4964652233565903`*^9}, 3.4964653445205207`*^9, 3.4964654227749968`*^9, 
   3.4964656745803995`*^9, {3.496466129287407*^9, 3.4964661393309813`*^9}, 
   3.4964668963682814`*^9, 3.4964672281532583`*^9, 3.496467531557612*^9, 
   3.496468484045091*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ",
   ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", "=", 
        RowBox[{"Numerator", "[", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "a"}], "/", "b"}], ",", 
           RowBox[{"n", "/", "2"}]}], "]"}], "]"}]}], ",", " ", 
       RowBox[{"s", "=", 
        RowBox[{"Denominator", "[", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "a"}], "/", "b"}], ",", 
           RowBox[{"n", "/", "2"}]}], "]"}], "]"}]}]}], "}"}], ",", "\n", 
     "  ", 
     RowBox[{
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"2", "*", 
         RowBox[{"r", "/", 
          RowBox[{"(", 
           RowBox[{"a", "*", "n"}], ")"}]}]}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{"1", "/", 
           RowBox[{"(", 
            RowBox[{"r", "-", 
             RowBox[{"s", "*", 
              RowBox[{"x", "^", "2"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
       "]"}], " ", "+", "\n", "  ", 
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"4", "*", 
         RowBox[{"r", "/", 
          RowBox[{"(", 
           RowBox[{"a", "*", "n"}], ")"}]}]}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{"Sum", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"r", "-", 
               RowBox[{"s", "*", 
                RowBox[{"Cos", "[", 
                 RowBox[{"4", "*", "k", "*", 
                  RowBox[{"Pi", "/", "n"}]}], "]"}], "*", 
                RowBox[{"x", "^", "2"}]}]}], ")"}], "/", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"r", "^", "2"}], "-", 
               RowBox[{"2", "*", "r", "*", "s", "*", 
                RowBox[{"Cos", "[", 
                 RowBox[{"4", "*", "k", "*", 
                  RowBox[{"Pi", "/", "n"}]}], "]"}], "*", 
                RowBox[{"x", "^", "2"}]}], "+", 
               RowBox[{
                RowBox[{"s", "^", "2"}], "*", 
                RowBox[{"x", "^", "4"}]}]}], ")"}]}], ",", "\n", "    ", 
            RowBox[{"{", 
             RowBox[{"k", ",", "1", ",", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"n", "-", "2"}], ")"}], "/", "4"}]}], "}"}]}], "]"}], 
          ",", "x"}], "]"}]}], "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"n", "-", "2"}], ")"}], "/", "4"}], "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "2"}], " ", "&&", " ", 
    RowBox[{"NegQ", "[", 
     RowBox[{"a", "/", "b"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, {
   3.4964643615542984`*^9, 3.496464371474866*^9}, {3.4964646331298313`*^9, 
   3.496464674701209*^9}, {3.4964648742126207`*^9, 3.4964648899195194`*^9}, 
   3.4964651866304903`*^9, 3.4964656304258738`*^9, 3.4964658849164295`*^9, {
   3.496466500015611*^9, 3.496466503963837*^9}, 3.496466597108165*^9, 
   3.4964671193880377`*^9, {3.4964674556312695`*^9, 3.496467494522494*^9}, 
   3.4964683428550158`*^9, {3.49646845639651*^9, 3.49646847213641*^9}, {
   3.4969493743629956`*^9, 3.496949375612997*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496464732151495*^9, 3.4964650841426277`*^9}],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"n", "-", "1"}], "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{
   FractionBox["r", "s"], "=", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["a", "b"], ")"}], 
    RowBox[{"1", "/", "n"}]]}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["z", "n"]}]}]], "=", 
   RowBox[{
    FractionBox["r", 
     RowBox[{"a", " ", "n", 
      RowBox[{"(", 
       RowBox[{"r", "+", 
        RowBox[{"s", " ", "z"}]}], ")"}]}]], "+", 
    RowBox[{
     FractionBox[
      RowBox[{"2", "r"}], 
      RowBox[{"a", " ", "n"}]], 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"k", "=", "1"}], 
       FractionBox[
        RowBox[{"n", "-", "1"}], "2"]], 
      FractionBox[
       RowBox[{"r", "-", 
        RowBox[{"s", " ", 
         RowBox[{"Cos", "[", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "k"}], "-", "1"}], ")"}], " ", "\[Pi]"}], 
           "n"], "]"}], " ", "z"}]}], 
       RowBox[{
        SuperscriptBox["r", "2"], "-", 
        RowBox[{"2", " ", "r", " ", "s", " ", 
         RowBox[{"Cos", "[", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "k"}], "-", "1"}], ")"}], " ", "\[Pi]"}], 
           "n"], "]"}], " ", "z"}], "+", 
        RowBox[{
         SuperscriptBox["s", "2"], " ", 
         SuperscriptBox["z", "2"]}]}]]}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
   3.4964427205723457`*^9, 3.496442726484756*^9}, {3.4964511572548466`*^9, 
   3.496451196884902*^9}, {3.4964647496374955`*^9, 3.4964647593420506`*^9}, {
   3.4964648485541534`*^9, 3.496464850611271*^9}, {3.49646510358774*^9, 
   3.49646514904034*^9}, {3.496465388706048*^9, 3.4964653947943964`*^9}, {
   3.4964654272642536`*^9, 3.496465506310775*^9}, 3.496465635184146*^9, {
   3.496465683603915*^9, 3.4964656938304996`*^9}, {3.4964661605171933`*^9, 
   3.4964661725558815`*^9}, {3.4964662031186295`*^9, 3.496466318316219*^9}, 
   3.49646637288834*^9, {3.4964666554985046`*^9, 3.496466712977792*^9}, {
   3.4964668475174875`*^9, 3.4964668531178074`*^9}, {3.4964669199346294`*^9, 
   3.4964669734406896`*^9}, 3.496467328943023*^9, {3.496467618375578*^9, 
   3.4964676253709784`*^9}, {3.4964677807798667`*^9, 3.496467788602314*^9}, {
   3.496467898612606*^9, 3.496467977559122*^9}, {3.496468036723506*^9, 
   3.49646804064073*^9}, {3.496468137265257*^9, 3.4964682293865256`*^9}, 
   3.4964683872925577`*^9, {3.4964685059903464`*^9, 3.496468506484375*^9}, {
   3.4964685516159563`*^9, 3.4964685617155337`*^9}, {3.496468864828871*^9, 
   3.4964688651818914`*^9}, {3.496468895907648*^9, 3.496469023703958*^9}}],

Cell[TextData[{
 "Rule: If ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{"n", "-", "1"}], "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}],
    " ", "\[And]", " ", 
   RowBox[{"n", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{
    FractionBox["a", "b"], ">", "0"}]}]]],
 ", let ",
 Cell[BoxData[
  RowBox[{
   FractionBox["r", "s"], "=", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["a", "b"], ")"}], 
    RowBox[{"1", "/", "n"}]]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.4964646821336346`*^9, 3.4964646836247196`*^9}, {3.4964650083112907`*^9, 
   3.496465017058791*^9}, 3.496465725016284*^9, 3.4964663908553677`*^9, {
   3.4964664249763193`*^9, 3.4964664960673857`*^9}, {3.4964670220844717`*^9, 
   3.496467057769513*^9}, {3.4964675741690493`*^9, 3.496467598274428*^9}, 
   3.4964682381240253`*^9, {3.4964683731897507`*^9, 3.49646838208926*^9}, {
   3.4964687695584216`*^9, 3.496468784950302*^9}, {3.496468871479251*^9, 
   3.496468873834386*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         FractionBox["r", 
          RowBox[{"a", " ", "n", " ", 
           RowBox[{"(", 
            RowBox[{"r", "+", 
             RowBox[{"s", " ", "x"}]}], ")"}]}]], "+", 
         RowBox[{
          UnderoverscriptBox["\[Sum]", 
           RowBox[{"k", "=", "1"}], 
           FractionBox[
            RowBox[{"n", "-", "1"}], "2"]], 
          FractionBox[
           RowBox[{"2", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"r", "-", 
              RowBox[{"s", " ", 
               RowBox[{"Cos", "[", 
                FractionBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "k"}], "-", "1"}], ")"}], " ", 
                  "\[Pi]"}], "n"], "]"}], " ", "x"}]}], ")"}]}], 
           RowBox[{"a", " ", "n", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["r", "2"], "-", 
              RowBox[{"2", " ", "r", " ", "s", " ", 
               RowBox[{"Cos", "[", 
                FractionBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "k"}], "-", "1"}], ")"}], " ", 
                  "\[Pi]"}], "n"], "]"}], " ", "x"}], "+", 
              RowBox[{
               SuperscriptBox["s", "2"], " ", 
               SuperscriptBox["x", "2"]}]}], ")"}]}]]}]}], ")"}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.4964644989841585`*^9, 3.4964645106438255`*^9}, 
   3.496464612803669*^9, 3.4964649458717194`*^9, {3.4964652217164965`*^9, 
   3.4964652233565903`*^9}, 3.4964653445205207`*^9, 3.4964654227749968`*^9, 
   3.4964656745803995`*^9, {3.496466129287407*^9, 3.4964661393309813`*^9}, 
   3.4964668963682814`*^9, 3.4964672281532583`*^9, 3.496467531557612*^9, 
   3.496468484045091*^9, 3.4964687521444254`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ",
   ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", "=", 
        RowBox[{"Numerator", "[", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{"a", "/", "b"}], ",", "n"}], "]"}], "]"}]}], ",", " ", 
       RowBox[{"s", "=", 
        RowBox[{"Denominator", "[", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{"a", "/", "b"}], ",", "n"}], "]"}], "]"}]}]}], "}"}], ",", 
     "\n", "  ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"r", "/", 
         RowBox[{"(", 
          RowBox[{"a", "*", "n", "*", 
           RowBox[{"(", 
            RowBox[{"r", "+", 
             RowBox[{"s", "*", "x"}]}], ")"}]}], ")"}]}], " ", "+", "\n", 
        "\t", 
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{"2", "*", "r", "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"r", "-", 
              RowBox[{"s", "*", 
               RowBox[{"Cos", "[", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", "*", "k"}], "-", "1"}], ")"}], "*", 
                 RowBox[{"Pi", "/", "n"}]}], "]"}], "*", "x"}]}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{"a", "*", "n", "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"r", "^", "2"}], "-", 
                RowBox[{"2", "*", "r", "*", "s", "*", 
                 RowBox[{"Cos", "[", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", "*", "k"}], "-", "1"}], ")"}], "*", 
                   RowBox[{"Pi", "/", "n"}]}], "]"}], "*", "x"}], "+", 
                RowBox[{
                 RowBox[{"s", "^", "2"}], "*", 
                 RowBox[{"x", "^", "2"}]}]}], ")"}]}], ")"}]}]}], ",", "\n", 
          "      ", 
          RowBox[{"{", 
           RowBox[{"k", ",", "1", ",", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"n", "-", "1"}], ")"}], "/", "2"}]}], "}"}]}], "]"}]}], 
       ",", "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OddQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}], " ", "&&", " ", 
    RowBox[{"PosQ", "[", 
     RowBox[{"a", "/", "b"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, {
   3.4964643615542984`*^9, 3.496464371474866*^9}, {3.4964646331298313`*^9, 
   3.496464674701209*^9}, {3.4964648742126207`*^9, 3.4964648899195194`*^9}, 
   3.4964651866304903`*^9, 3.4964656304258738`*^9, 3.4964658849164295`*^9, {
   3.496466500015611*^9, 3.496466503963837*^9}, 3.496466597108165*^9, 
   3.4964671193880377`*^9, {3.4964674556312695`*^9, 3.496467494522494*^9}, 
   3.4964683428550158`*^9, {3.49646845639651*^9, 3.49646847213641*^9}, 
   3.4964686890978193`*^9, 3.496469167265169*^9, {3.4969493935130224`*^9, 
   3.496949414683052*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496464732151495*^9, 3.4964650841426277`*^9}],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"n", "-", "1"}], "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{
   FractionBox["r", "s"], "=", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", 
      FractionBox["a", "b"]}], ")"}], 
    RowBox[{"1", "/", "n"}]]}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["z", "n"]}]}]], "=", 
   RowBox[{
    FractionBox["r", 
     RowBox[{"a", " ", "n", 
      RowBox[{"(", 
       RowBox[{"r", "-", 
        RowBox[{"s", " ", "z"}]}], ")"}]}]], "+", 
    RowBox[{
     FractionBox[
      RowBox[{"2", "r"}], 
      RowBox[{"a", " ", "n"}]], 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"k", "=", "1"}], 
       FractionBox[
        RowBox[{"n", "-", "1"}], "2"]], 
      FractionBox[
       RowBox[{"r", "+", 
        RowBox[{"s", " ", 
         RowBox[{"Cos", "[", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "k"}], "-", "1"}], ")"}], " ", "\[Pi]"}], 
           "n"], "]"}], " ", "z"}]}], 
       RowBox[{
        SuperscriptBox["r", "2"], "+", 
        RowBox[{"2", " ", "r", " ", "s", " ", 
         RowBox[{"Cos", "[", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "k"}], "-", "1"}], ")"}], " ", "\[Pi]"}], 
           "n"], "]"}], " ", "z"}], "+", 
        RowBox[{
         SuperscriptBox["s", "2"], " ", 
         SuperscriptBox["z", "2"]}]}]]}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
   3.4964427205723457`*^9, 3.496442726484756*^9}, {3.4964511572548466`*^9, 
   3.496451196884902*^9}, {3.4964647496374955`*^9, 3.4964647593420506`*^9}, {
   3.4964648485541534`*^9, 3.496464850611271*^9}, {3.49646510358774*^9, 
   3.49646514904034*^9}, {3.496465388706048*^9, 3.4964653947943964`*^9}, {
   3.4964654272642536`*^9, 3.496465506310775*^9}, 3.496465635184146*^9, {
   3.496465683603915*^9, 3.4964656938304996`*^9}, {3.4964661605171933`*^9, 
   3.4964661725558815`*^9}, {3.4964662031186295`*^9, 3.496466318316219*^9}, 
   3.49646637288834*^9, {3.4964666554985046`*^9, 3.496466712977792*^9}, {
   3.4964668475174875`*^9, 3.4964668531178074`*^9}, {3.4964669199346294`*^9, 
   3.4964669734406896`*^9}, 3.496467328943023*^9, {3.496467618375578*^9, 
   3.4964676253709784`*^9}, {3.4964677807798667`*^9, 3.496467788602314*^9}, {
   3.496467898612606*^9, 3.496467977559122*^9}, {3.496468036723506*^9, 
   3.49646804064073*^9}, {3.496468137265257*^9, 3.4964682293865256`*^9}, 
   3.4964683872925577`*^9, {3.4964685059903464`*^9, 3.496468506484375*^9}, {
   3.4964685516159563`*^9, 3.4964685617155337`*^9}, {3.496468864828871*^9, 
   3.4964688651818914`*^9}, {3.496468895907648*^9, 3.496469023703958*^9}, 
   3.4964691545554423`*^9, {3.496469194081703*^9, 3.4964692089145517`*^9}}],

Cell[TextData[{
 "Rule: If ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{"n", "-", "1"}], "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}],
    " ", "\[And]", " ", 
   RowBox[{"n", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{
      FractionBox["a", "b"], ">", "0"}], ")"}]}]}]]],
 ", let ",
 Cell[BoxData[
  RowBox[{
   FractionBox["r", "s"], "=", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", 
      FractionBox["a", "b"]}], ")"}], 
    RowBox[{"1", "/", "n"}]]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.4964646821336346`*^9, 3.4964646836247196`*^9}, {3.4964650083112907`*^9, 
   3.496465017058791*^9}, 3.496465725016284*^9, 3.4964663908553677`*^9, {
   3.4964664249763193`*^9, 3.4964664960673857`*^9}, {3.4964670220844717`*^9, 
   3.496467057769513*^9}, {3.4964675741690493`*^9, 3.496467598274428*^9}, 
   3.4964682381240253`*^9, {3.4964683731897507`*^9, 3.49646838208926*^9}, {
   3.4964687695584216`*^9, 3.496468784950302*^9}, {3.496468871479251*^9, 
   3.496468873834386*^9}, {3.4964691389465494`*^9, 3.496469145747938*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         FractionBox["r", 
          RowBox[{"a", " ", "n", " ", 
           RowBox[{"(", 
            RowBox[{"r", "-", 
             RowBox[{"s", " ", "x"}]}], ")"}]}]], "+", 
         RowBox[{
          UnderoverscriptBox["\[Sum]", 
           RowBox[{"k", "=", "1"}], 
           FractionBox[
            RowBox[{"n", "-", "1"}], "2"]], 
          FractionBox[
           RowBox[{"2", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"r", "+", 
              RowBox[{"s", " ", 
               RowBox[{"Cos", "[", 
                FractionBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "k"}], "-", "1"}], ")"}], " ", 
                  "\[Pi]"}], "n"], "]"}], " ", "x"}]}], ")"}]}], 
           RowBox[{"a", " ", "n", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["r", "2"], "+", 
              RowBox[{"2", " ", "r", " ", "s", " ", 
               RowBox[{"Cos", "[", 
                FractionBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "k"}], "-", "1"}], ")"}], " ", 
                  "\[Pi]"}], "n"], "]"}], " ", "x"}], "+", 
              RowBox[{
               SuperscriptBox["s", "2"], " ", 
               SuperscriptBox["x", "2"]}]}], ")"}]}]]}]}], ")"}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.4964644989841585`*^9, 3.4964645106438255`*^9}, 
   3.496464612803669*^9, 3.4964649458717194`*^9, {3.4964652217164965`*^9, 
   3.4964652233565903`*^9}, 3.4964653445205207`*^9, 3.4964654227749968`*^9, 
   3.4964656745803995`*^9, {3.496466129287407*^9, 3.4964661393309813`*^9}, 
   3.4964668963682814`*^9, 3.4964672281532583`*^9, 3.496467531557612*^9, 
   3.496468484045091*^9, 3.4964687521444254`*^9, 3.496469186101247*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ",
   ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", "=", 
        RowBox[{"Numerator", "[", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "a"}], "/", "b"}], ",", "n"}], "]"}], "]"}]}], ",", 
       " ", 
       RowBox[{"s", "=", 
        RowBox[{"Denominator", "[", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "a"}], "/", "b"}], ",", "n"}], "]"}], "]"}]}]}], 
      "}"}], ",", "\n", "  ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"r", "/", 
         RowBox[{"(", 
          RowBox[{"a", "*", "n", "*", 
           RowBox[{"(", 
            RowBox[{"r", "-", 
             RowBox[{"s", "*", "x"}]}], ")"}]}], ")"}]}], " ", "+", "\n", 
        "\t", 
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{"2", "*", "r", "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"r", "+", 
              RowBox[{"s", "*", 
               RowBox[{"Cos", "[", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", "*", "k"}], "-", "1"}], ")"}], "*", 
                 RowBox[{"Pi", "/", "n"}]}], "]"}], "*", "x"}]}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{"a", "*", "n", "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"r", "^", "2"}], "+", 
                RowBox[{"2", "*", "r", "*", "s", "*", 
                 RowBox[{"Cos", "[", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", "*", "k"}], "-", "1"}], ")"}], "*", 
                   RowBox[{"Pi", "/", "n"}]}], "]"}], "*", "x"}], "+", 
                RowBox[{
                 RowBox[{"s", "^", "2"}], "*", 
                 RowBox[{"x", "^", "2"}]}]}], ")"}]}], ")"}]}]}], ",", "\n", 
          "      ", 
          RowBox[{"{", 
           RowBox[{"k", ",", "1", ",", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"n", "-", "1"}], ")"}], "/", "2"}]}], "}"}]}], "]"}]}], 
       ",", "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OddQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}], " ", "&&", " ", 
    RowBox[{"NegQ", "[", 
     RowBox[{"a", "/", "b"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, {
   3.4964643615542984`*^9, 3.496464371474866*^9}, {3.4964646331298313`*^9, 
   3.496464674701209*^9}, {3.4964648742126207`*^9, 3.4964648899195194`*^9}, 
   3.4964651866304903`*^9, 3.4964656304258738`*^9, 3.4964658849164295`*^9, {
   3.496466500015611*^9, 3.496466503963837*^9}, 3.496466597108165*^9, 
   3.4964671193880377`*^9, {3.4964674556312695`*^9, 3.496467494522494*^9}, 
   3.4964683428550158`*^9, {3.49646845639651*^9, 3.49646847213641*^9}, 
   3.4964686890978193`*^9, 3.4964691190174093`*^9, 3.4964691611768208`*^9, {
   3.496949433253078*^9, 3.4969494347730803`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "m"], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.4965117206885777`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.126.2, CRC 75", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496464724241043*^9, 3.496464835057381*^9, 3.496465076517192*^9, 
   3.4965117605686336`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496464732151495*^9, 3.4964650841426277`*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   FractionBox["r", "s"], "=", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["a", "b"], ")"}], 
    RowBox[{"1", "/", "3"}]]}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   FractionBox["z", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["z", "3"]}]}]], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox["r", "2"], 
      RowBox[{"3", " ", "a", " ", "s", 
       RowBox[{"(", 
        RowBox[{"r", "+", 
         RowBox[{"s", " ", "z"}]}], ")"}]}]]}], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["r", "2"], 
      RowBox[{"(", 
       RowBox[{"r", "+", 
        RowBox[{"s", " ", "z"}]}], ")"}]}], 
     RowBox[{"3", " ", "a", " ", "s", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["r", "2"], "-", 
        RowBox[{"r", " ", "s", " ", "z"}], "+", 
        RowBox[{
         SuperscriptBox["s", "2"], 
         SuperscriptBox["z", "2"]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
  3.4964427205723457`*^9, 3.496442726484756*^9}, {3.4964511572548466`*^9, 
  3.496451196884902*^9}, {3.4964647496374955`*^9, 3.4964647593420506`*^9}, {
  3.4964648485541534`*^9, 3.496464850611271*^9}, {3.49646510358774*^9, 
  3.49646514904034*^9}, {3.496465388706048*^9, 3.4964653947943964`*^9}, {
  3.4964654272642536`*^9, 3.496465506310775*^9}, {3.4965118641487784`*^9, 
  3.496511926748866*^9}, {3.4965120018989716`*^9, 3.4965120179489937`*^9}, {
  3.496512068979065*^9, 3.496512138389162*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   FractionBox["a", "b"], ">", "0"}]]],
 ", let ",
 Cell[BoxData[
  RowBox[{
   FractionBox["r", "s"], "=", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["a", "b"], ")"}], 
    RowBox[{"1", "/", "3"}]]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.4964646821336346`*^9, 3.4964646836247196`*^9}, {3.4964650083112907`*^9, 
   3.496465017058791*^9}, {3.4964656995018244`*^9, 3.496465714085659*^9}, {
   3.4964667294907365`*^9, 3.496466753485109*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["x", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "3"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox["r", "2"], 
        RowBox[{"3", " ", "a", " ", "s"}]]}]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"r", "+", 
        RowBox[{"s", " ", "x"}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    SuperscriptBox["r", "2"], 
    RowBox[{"3", " ", "a", " ", "s"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"r", "+", 
       RowBox[{"s", " ", "x"}]}], 
      RowBox[{
       SuperscriptBox["r", "2"], "-", 
       RowBox[{"r", " ", "s", " ", "x"}], "+", 
       RowBox[{
        SuperscriptBox["s", "2"], " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.4964644989841585`*^9, 3.4964645106438255`*^9}, 
   3.496464612803669*^9, 3.4964649458717194`*^9, {3.4964652217164965`*^9, 
   3.4964652233565903`*^9}, 3.4964653445205207`*^9, 3.4964654227749968`*^9, {
   3.496511845698753*^9, 3.49651185111876*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "3"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", "=", 
        RowBox[{"Numerator", "[", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{"a", "/", "b"}], ",", "3"}], "]"}], "]"}]}], ",", " ", 
       RowBox[{"s", "=", 
        RowBox[{"Denominator", "[", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{"a", "/", "b"}], ",", "3"}], "]"}], "]"}]}]}], "}"}], ",", 
     "\n", "  ", 
     RowBox[{
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          RowBox[{"r", "^", "2"}]}], "/", 
         RowBox[{"(", 
          RowBox[{"3", "*", "a", "*", "s"}], ")"}]}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{"1", "/", 
           RowBox[{"(", 
            RowBox[{"r", "+", 
             RowBox[{"s", "*", "x"}]}], ")"}]}], ",", "x"}], "]"}]}], "]"}], 
      " ", "+", "\n", "  ", 
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"r", "^", "2"}], "/", 
         RowBox[{"(", 
          RowBox[{"3", "*", "a", "*", "s"}], ")"}]}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"r", "+", 
             RowBox[{"s", "*", "x"}]}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"r", "^", "2"}], "-", 
             RowBox[{"r", "*", "s", "*", "x"}], "+", 
             RowBox[{
              RowBox[{"s", "^", "2"}], "*", 
              RowBox[{"x", "^", "2"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
       "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"PosQ", "[", 
     RowBox[{"a", "/", "b"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, {
   3.4964643615542984`*^9, 3.496464371474866*^9}, {3.4964646331298313`*^9, 
   3.496464674701209*^9}, {3.4964648742126207`*^9, 3.4964648899195194`*^9}, 
   3.4964651866304903`*^9, {3.496511743098609*^9, 3.496511750418619*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496464732151495*^9, 3.4964650841426277`*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   FractionBox["r", "s"], "=", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", 
      FractionBox["a", "b"]}], ")"}], 
    RowBox[{"1", "/", "3"}]]}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["z", "3"]}]}]], "=", 
   RowBox[{
    FractionBox[
     SuperscriptBox["r", "2"], 
     RowBox[{"3", " ", "a", " ", "s", 
      RowBox[{"(", 
       RowBox[{"r", "-", 
        RowBox[{"s", " ", "z"}]}], ")"}]}]], "-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["r", "2"], 
      RowBox[{"(", 
       RowBox[{"r", "-", 
        RowBox[{"s", " ", "z"}]}], ")"}]}], 
     RowBox[{"3", " ", "a", " ", "s", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["r", "2"], "+", 
        RowBox[{"r", " ", "s", " ", "z"}], "+", 
        RowBox[{
         SuperscriptBox["s", "2"], 
         SuperscriptBox["z", "2"]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
   3.4964427205723457`*^9, 3.496442726484756*^9}, {3.4964511572548466`*^9, 
   3.496451196884902*^9}, {3.4964647496374955`*^9, 3.4964647593420506`*^9}, {
   3.4964648485541534`*^9, 3.496464850611271*^9}, {3.49646510358774*^9, 
   3.49646514904034*^9}, {3.496465388706048*^9, 3.4964653947943964`*^9}, {
   3.4964654272642536`*^9, 3.496465506310775*^9}, 3.496465635184146*^9, {
   3.496465683603915*^9, 3.4964656938304996`*^9}, {3.496512280369361*^9, 
   3.4965122998293886`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"\[Not]", 
   RowBox[{"(", 
    RowBox[{
     FractionBox["a", "b"], ">", "0"}], ")"}]}]]],
 ", let ",
 Cell[BoxData[
  RowBox[{
   FractionBox["r", "s"], "=", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", 
      FractionBox["a", "b"]}], ")"}], 
    RowBox[{"1", "/", "3"}]]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.4964646821336346`*^9, 3.4964646836247196`*^9}, {3.4964650083112907`*^9, 
   3.496465017058791*^9}, {3.4964656995018244`*^9, 3.496465714085659*^9}, {
   3.4964667294907365`*^9, 3.496466753485109*^9}, {3.4964667868360167`*^9, 
   3.4964667912782707`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["x", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "3"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       SuperscriptBox["r", "2"], 
       RowBox[{"3", " ", "a", " ", "s"}]]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"r", "-", 
        RowBox[{"s", " ", "x"}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    SuperscriptBox["r", "2"], 
    RowBox[{"3", " ", "a", " ", "s"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"r", "-", 
       RowBox[{"s", " ", "x"}]}], 
      RowBox[{
       SuperscriptBox["r", "2"], "+", 
       RowBox[{"r", " ", "s", " ", "x"}], "+", 
       RowBox[{
        SuperscriptBox["s", "2"], " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.4964644989841585`*^9, 3.4964645106438255`*^9}, 
   3.496464612803669*^9, 3.4964649458717194`*^9, {3.4964652217164965`*^9, 
   3.4964652233565903`*^9}, 3.4964653445205207`*^9, 3.4964654227749968`*^9, 
   3.4964656745803995`*^9, {3.496512243109309*^9, 3.496512252839323*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "3"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", "=", 
        RowBox[{"Numerator", "[", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "a"}], "/", "b"}], ",", "3"}], "]"}], "]"}]}], ",", 
       " ", 
       RowBox[{"s", "=", 
        RowBox[{"Denominator", "[", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "a"}], "/", "b"}], ",", "3"}], "]"}], "]"}]}]}], 
      "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"r", "^", "2"}], "/", 
         RowBox[{"(", 
          RowBox[{"3", "*", "a", "*", "s"}], ")"}]}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{"1", "/", 
           RowBox[{"(", 
            RowBox[{"r", "-", 
             RowBox[{"s", "*", "x"}]}], ")"}]}], ",", "x"}], "]"}]}], "]"}], 
      " ", "-", "\n", "  ", 
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"r", "^", "2"}], "/", 
         RowBox[{"(", 
          RowBox[{"3", "*", "a", "*", "s"}], ")"}]}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"r", "-", 
             RowBox[{"s", "*", "x"}]}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"r", "^", "2"}], "+", 
             RowBox[{"r", "*", "s", "*", "x"}], "+", 
             RowBox[{
              RowBox[{"s", "^", "2"}], "*", 
              RowBox[{"x", "^", "2"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
       "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NegQ", "[", 
     RowBox[{"a", "/", "b"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, {
   3.4964643615542984`*^9, 3.496464371474866*^9}, {3.4964646331298313`*^9, 
   3.496464674701209*^9}, {3.4964648742126207`*^9, 3.4964648899195194`*^9}, 
   3.4964651866304903`*^9, 3.4964656304258738`*^9, 3.496511738948603*^9, {
   3.496511791658677*^9, 3.4965118092187014`*^9}, 3.4965122073192587`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496464732151495*^9, 3.4964650841426277`*^9, 3.49651235842947*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"0", "<", 
     RowBox[{"m", "+", "1"}], "<", "n"}]}]}]]],
 ", let ",
 Cell[BoxData[
  RowBox[{"g", "=", 
   RowBox[{"GCD", "[", 
    RowBox[{
     RowBox[{"m", "+", "1"}], ",", "n"}], "]"}]}]]],
 ", if  ",
 Cell[BoxData[
  RowBox[{"g", ">", "1"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.4964646821336346`*^9, 3.4964646836247196`*^9}, {3.4964650083112907`*^9, 
   3.496465017058791*^9}, 3.496465725016284*^9, 3.4964663908553677`*^9, {
   3.4964664249763193`*^9, 3.4964664960673857`*^9}, {3.496466820055917*^9, 
   3.4964668354067945`*^9}, {3.4965123933795195`*^9, 3.4965124815096426`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "m"], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "g"]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox[
        SuperscriptBox["x", 
         RowBox[{
          FractionBox[
           RowBox[{"m", "+", "1"}], "g"], "-", "1"}]], 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", 
           RowBox[{"n", "/", "g"}]]}]}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     SuperscriptBox["x", "g"]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.4964644989841585`*^9, 3.4964645106438255`*^9}, 
   3.496464612803669*^9, 3.4964649458717194`*^9, {3.4964652217164965`*^9, 
   3.4964652233565903`*^9}, 3.4964653445205207`*^9, 3.4964654227749968`*^9, 
   3.4964656745803995`*^9, {3.496466129287407*^9, 3.4964661393309813`*^9}, 
   3.4965122654093404`*^9, 3.4965124946996613`*^9, 3.4965125339897165`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ",
   ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"g", "=", 
       RowBox[{"GCD", "[", 
        RowBox[{
         RowBox[{"m", "+", "1"}], ",", "n"}], "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"1", "/", "g"}], ",", 
        RowBox[{"Subst", "[", 
         RowBox[{
          RowBox[{"Int", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"x", "^", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"m", "+", "1"}], ")"}], "/", "g"}], "-", "1"}], 
               ")"}]}], "/", 
             RowBox[{"(", 
              RowBox[{"a", "+", 
               RowBox[{"b", "*", 
                RowBox[{"x", "^", 
                 RowBox[{"(", 
                  RowBox[{"n", "/", "g"}], ")"}]}]}]}], ")"}]}], ",", "x"}], 
           "]"}], ",", "x", ",", 
          RowBox[{"x", "^", "g"}]}], "]"}]}], "]"}], " ", "/;", "\n", " ", 
      RowBox[{"g", ">", "1"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"0", "<", 
     RowBox[{"m", "+", "1"}], "<", "n"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, {
   3.4964643615542984`*^9, 3.496464371474866*^9}, {3.4964646331298313`*^9, 
   3.496464674701209*^9}, {3.4964648742126207`*^9, 3.4964648899195194`*^9}, 
   3.4964651866304903`*^9, 3.4964656304258738`*^9, 3.4964658849164295`*^9, {
   3.496466500015611*^9, 3.496466503963837*^9}, 3.496511735658599*^9, 
   3.496512352829463*^9, 3.5171909852580123`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.132.3.1', CRC 81'", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496464732151495*^9, 3.4964650841426277`*^9, 3.49651235842947*^9, 
   3.496512641739867*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496464732151495*^9, 3.4964650841426277`*^9, 3.49651235842947*^9, 
   3.496512647919876*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   FractionBox["r", "s"], "=", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["a", "b"], ")"}], 
    RowBox[{"1", "/", "4"}]]}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    SuperscriptBox["z", "2"], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["z", "4"]}]}]], "=", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["s", "3"], " ", "z"}], 
     RowBox[{"2", 
      SqrtBox["2"], "b", " ", "r", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["r", "2"], "-", 
        RowBox[{
         SqrtBox["2"], " ", "r", " ", "s", " ", "z"}], "+", 
        RowBox[{
         SuperscriptBox["s", "2"], " ", 
         SuperscriptBox["z", "2"]}]}], ")"}]}]], "-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["s", "3"], " ", "z"}], 
     RowBox[{"2", 
      SqrtBox["2"], "b", " ", "r", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["r", "2"], "+", 
        RowBox[{
         SqrtBox["2"], " ", "r", " ", "s", " ", "z"}], "+", 
        RowBox[{
         SuperscriptBox["s", "2"], " ", 
         SuperscriptBox["z", "2"]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
   3.4964427205723457`*^9, 3.496442726484756*^9}, {3.4964511572548466`*^9, 
   3.496451196884902*^9}, {3.4964647496374955`*^9, 3.4964647593420506`*^9}, {
   3.4964648485541534`*^9, 3.496464850611271*^9}, {3.49646510358774*^9, 
   3.49646514904034*^9}, {3.496465388706048*^9, 3.4964653947943964`*^9}, {
   3.4964654272642536`*^9, 3.496465506310775*^9}, 3.496465635184146*^9, {
   3.496465683603915*^9, 3.4964656938304996`*^9}, {3.4964661605171933`*^9, 
   3.4964661725558815`*^9}, {3.4964662031186295`*^9, 3.496466318316219*^9}, 
   3.49646637288834*^9, {3.4964678366970654`*^9, 3.496467850475853*^9}, {
   3.49651289367022*^9, 3.496512903690234*^9}, {3.496512981950343*^9, 
   3.496513065950461*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    FractionBox["m", "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
   "\[And]", " ", 
   RowBox[{"m", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{
    FractionBox["a", "b"], ">", "0"}]}]]],
 ", let ",
 Cell[BoxData[
  RowBox[{
   FractionBox["r", "s"], "=", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["a", "b"], ")"}], 
    RowBox[{"1", "/", "4"}]]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.4964646821336346`*^9, 3.4964646836247196`*^9}, {3.4964650083112907`*^9, 
   3.496465017058791*^9}, 3.496465725016284*^9, 3.4964663908553677`*^9, {
   3.4964664249763193`*^9, 3.4964664960673857`*^9}, {3.496466820055917*^9, 
   3.4964668354067945`*^9}, {3.496512833800136*^9, 3.4965128426701484`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "m"], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", "m"}]]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       SuperscriptBox["s", "3"], 
       RowBox[{"2", " ", 
        SqrtBox["2"], " ", "b", " ", "r"}]]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       SuperscriptBox["x", 
        RowBox[{"m", "/", "2"}]], 
       RowBox[{
        SuperscriptBox["r", "2"], "-", 
        RowBox[{
         SqrtBox["2"], " ", "r", " ", "s", " ", 
         SuperscriptBox["x", 
          RowBox[{"m", "/", "2"}]]}], "+", 
        RowBox[{
         SuperscriptBox["s", "2"], " ", 
         SuperscriptBox["x", "m"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    SuperscriptBox["s", "3"], 
    RowBox[{"2", " ", 
     SqrtBox["2"], " ", "b", " ", "r"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox["x", 
       RowBox[{"m", "/", "2"}]], 
      RowBox[{
       SuperscriptBox["r", "2"], "+", 
       RowBox[{
        SqrtBox["2"], " ", "r", " ", "s", " ", 
        SuperscriptBox["x", 
         RowBox[{"m", "/", "2"}]]}], "+", 
       RowBox[{
        SuperscriptBox["s", "2"], " ", 
        SuperscriptBox["x", "m"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.4964644989841585`*^9, 3.4964645106438255`*^9}, 
   3.496464612803669*^9, 3.4964649458717194`*^9, {3.4964652217164965`*^9, 
   3.4964652233565903`*^9}, 3.4964653445205207`*^9, 3.4964654227749968`*^9, 
   3.4964656745803995`*^9, {3.496466129287407*^9, 3.4964661393309813`*^9}, 
   3.4965122654093404`*^9, 3.496512673019911*^9, 3.496512715969971*^9, {
   3.496512783140065*^9, 3.4965127842700667`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ",
   ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", "=", 
        RowBox[{"Numerator", "[", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{"a", "/", "b"}], ",", "4"}], "]"}], "]"}]}], ",", " ", 
       RowBox[{"s", "=", 
        RowBox[{"Denominator", "[", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{"a", "/", "b"}], ",", "4"}], "]"}], "]"}]}]}], "}"}], ",", 
     "\n", "  ", 
     RowBox[{
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"s", "^", "3"}], "/", 
         RowBox[{"(", 
          RowBox[{"2", "*", 
           RowBox[{"Sqrt", "[", "2", "]"}], "*", "b", "*", "r"}], ")"}]}], 
        ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", 
            RowBox[{"(", 
             RowBox[{"m", "/", "2"}], ")"}]}], "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"r", "^", "2"}], "-", 
             RowBox[{
              RowBox[{"Sqrt", "[", "2", "]"}], "*", "r", "*", "s", "*", 
              RowBox[{"x", "^", 
               RowBox[{"(", 
                RowBox[{"m", "/", "2"}], ")"}]}]}], "+", 
             RowBox[{
              RowBox[{"s", "^", "2"}], "*", 
              RowBox[{"x", "^", "m"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
       "]"}], " ", "-", "\n", "  ", 
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"s", "^", "3"}], "/", 
         RowBox[{"(", 
          RowBox[{"2", "*", 
           RowBox[{"Sqrt", "[", "2", "]"}], "*", "b", "*", "r"}], ")"}]}], 
        ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", 
            RowBox[{"(", 
             RowBox[{"m", "/", "2"}], ")"}]}], "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"r", "^", "2"}], "+", 
             RowBox[{
              RowBox[{"Sqrt", "[", "2", "]"}], "*", "r", "*", "s", "*", 
              RowBox[{"x", "^", 
               RowBox[{"(", 
                RowBox[{"m", "/", "2"}], ")"}]}]}], "+", 
             RowBox[{
              RowBox[{"s", "^", "2"}], "*", 
              RowBox[{"x", "^", "m"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
       "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"m", "/", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"n", "-", 
      RowBox[{"2", "*", "m"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", 
     RowBox[{"a", "/", "b"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, {
   3.4964643615542984`*^9, 3.496464371474866*^9}, {3.4964646331298313`*^9, 
   3.496464674701209*^9}, {3.4964648742126207`*^9, 3.4964648899195194`*^9}, 
   3.4964651866304903`*^9, 3.4964656304258738`*^9, 3.4964658849164295`*^9, {
   3.496466500015611*^9, 3.496466503963837*^9}, 3.496511735658599*^9, {
   3.496512352829463*^9, 3.4965123807295017`*^9}, 3.496512630389851*^9, {
   3.496512801560091*^9, 3.4965128219601192`*^9}, {3.4974985729701843`*^9, 
   3.4974985740701857`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.132.3.2', CRC 82'", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496464724241043*^9, 3.496464835057381*^9, 3.496465076517192*^9, 
   3.4964658936609297`*^9, 3.496466613476101*^9, 3.4965138778315973`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496464732151495*^9, 3.4964650841426277`*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   FractionBox["r", "s"], "=", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", 
      FractionBox["a", "b"]}], ")"}], 
    RowBox[{"1", "/", "2"}]]}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   FractionBox["z", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["z", "2"]}]}]], "=", 
   RowBox[{
    FractionBox["s", 
     RowBox[{"2", "b", 
      RowBox[{"(", 
       RowBox[{"r", "+", 
        RowBox[{"s", " ", "z"}]}], ")"}]}]], "-", 
    FractionBox["s", 
     RowBox[{"2", "b", 
      RowBox[{"(", 
       RowBox[{"r", "-", 
        RowBox[{"s", " ", "z"}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
   3.4964427205723457`*^9, 3.496442726484756*^9}, {3.4964511572548466`*^9, 
   3.496451196884902*^9}, {3.4964647496374955`*^9, 3.4964647593420506`*^9}, {
   3.4964648485541534`*^9, 3.496464850611271*^9}, {3.49646510358774*^9, 
   3.49646514904034*^9}, {3.496465388706048*^9, 3.4964653947943964`*^9}, {
   3.4964654272642536`*^9, 3.496465506310775*^9}, 3.496465635184146*^9, {
   3.496465683603915*^9, 3.4964656938304996`*^9}, {3.4964661605171933`*^9, 
   3.4964661725558815`*^9}, {3.4964662031186295`*^9, 3.496466318316219*^9}, 
   3.49646637288834*^9, {3.4964666554985046`*^9, 3.496466712977792*^9}, {
   3.4964668475174875`*^9, 3.4964668531178074`*^9}, {3.4964669199346294`*^9, 
   3.4964669734406896`*^9}, {3.4964677989889083`*^9, 3.4964678214221916`*^9}, 
   3.49651391525165*^9, {3.49651399377176*^9, 3.4965140135917873`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    FractionBox["m", "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
   "\[And]", " ", 
   RowBox[{"m", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{
      FractionBox["a", "b"], ">", "0"}], ")"}]}]}]]],
 ", ",
 "let ",
 Cell[BoxData[
  RowBox[{
   FractionBox["r", "s"], "=", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", 
      FractionBox["a", "b"]}], ")"}], 
    RowBox[{"1", "/", "2"}]]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.4964646821336346`*^9, 3.4964646836247196`*^9}, {3.4964650083112907`*^9, 
   3.496465017058791*^9}, 3.496465725016284*^9, 3.4964663908553677`*^9, {
   3.4964664249763193`*^9, 3.4964664960673857`*^9}, {3.4964670220844717`*^9, 
   3.496467057769513*^9}, {3.496514120131937*^9, 3.496514128091948*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "m"], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", "m"}]]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["s", 
       RowBox[{"2", " ", "b"}]]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"r", "+", 
        RowBox[{"s", " ", 
         SuperscriptBox["x", "m"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["s", 
    RowBox[{"2", " ", "b"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"r", "-", 
       RowBox[{"s", " ", 
        SuperscriptBox["x", "m"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.4964644989841585`*^9, 3.4964645106438255`*^9}, 
   3.496464612803669*^9, 3.4964649458717194`*^9, {3.4964652217164965`*^9, 
   3.4964652233565903`*^9}, 3.4964653445205207`*^9, 3.4964654227749968`*^9, 
   3.4964656745803995`*^9, {3.496466129287407*^9, 3.4964661393309813`*^9}, 
   3.4964668963682814`*^9, 3.496513930091671*^9, 3.496513984241747*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ",
   ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", "=", 
        RowBox[{"Numerator", "[", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "a"}], "/", "b"}], ",", "2"}], "]"}], "]"}]}], ",", 
       " ", 
       RowBox[{"s", "=", 
        RowBox[{"Denominator", "[", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "a"}], "/", "b"}], ",", "2"}], "]"}], "]"}]}]}], 
      "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"s", "/", 
         RowBox[{"(", 
          RowBox[{"2", "*", "b"}], ")"}]}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{"1", "/", 
           RowBox[{"(", 
            RowBox[{"r", "+", 
             RowBox[{"s", "*", 
              RowBox[{"x", "^", "m"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
       "]"}], " ", "-", "\n", "  ", 
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"s", "/", 
         RowBox[{"(", 
          RowBox[{"2", "*", "b"}], ")"}]}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{"1", "/", 
           RowBox[{"(", 
            RowBox[{"r", "-", 
             RowBox[{"s", "*", 
              RowBox[{"x", "^", "m"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
       "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"EvenQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"n", "-", 
      RowBox[{"2", "*", "m"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"PositiveQ", "[", 
      RowBox[{"a", "/", "b"}], "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, {
   3.4964643615542984`*^9, 3.496464371474866*^9}, {3.4964646331298313`*^9, 
   3.496464674701209*^9}, {3.4964648742126207`*^9, 3.4964648899195194`*^9}, 
   3.4964651866304903`*^9, 3.4964656304258738`*^9, 3.4964658849164295`*^9, {
   3.496466500015611*^9, 3.496466503963837*^9}, 3.496466597108165*^9, 
   3.4965136519912815`*^9, 3.4965139083616405`*^9, {3.49749859134021*^9, 
   3.4974985930302124`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496464732151495*^9, 3.4964650841426277`*^9}],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"n", "-", "2"}], "4"], ",", 
   RowBox[{
    FractionBox["m", "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}]}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"0", "\[LessEqual]", "m", "<", "n"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{
   FractionBox["r", "s"], "=", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["a", "b"], ")"}], 
    RowBox[{"2", "/", "n"}]]}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    SuperscriptBox["z", "m"], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["z", "n"]}]}]], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "r"}], ")"}], 
        RowBox[{
         FractionBox["m", "2"], "+", "1"}]]}], 
      RowBox[{"a", " ", "n", " ", 
       SuperscriptBox["s", 
        RowBox[{"m", "/", "2"}]], 
       RowBox[{"(", 
        RowBox[{"r", "+", 
         RowBox[{"s", " ", 
          SuperscriptBox["z", "2"]}]}], ")"}]}]]}], "+", 
    RowBox[{
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["r", 
        RowBox[{
         FractionBox["m", "2"], "+", "1"}]]}], 
      RowBox[{"a", " ", "n", " ", 
       SuperscriptBox["s", 
        RowBox[{"m", "/", "2"}]]}]], 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"k", "=", "1"}], 
       FractionBox[
        RowBox[{"n", "-", "2"}], "4"]], 
      FractionBox[
       RowBox[{
        RowBox[{"r", " ", 
         RowBox[{"Cos", "[", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "k"}], "-", "1"}], ")"}], " ", "m", " ", 
            "\[Pi]"}], "n"], "]"}]}], "-", 
        RowBox[{"s", " ", 
         RowBox[{"Cos", "[", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "k"}], "-", "1"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"m", "+", "2"}], ")"}], " ", "\[Pi]"}], "n"], "]"}], " ", 
         SuperscriptBox["z", "2"]}]}], 
       RowBox[{
        SuperscriptBox["r", "2"], "-", 
        RowBox[{"2", " ", "r", " ", "s", " ", 
         RowBox[{"Cos", "[", 
          FractionBox[
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "k"}], "-", "1"}], ")"}], " ", "\[Pi]"}], 
           "n"], "]"}], " ", 
         SuperscriptBox["z", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["s", "2"], " ", 
         SuperscriptBox["z", "4"]}]}]]}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
   3.4964427205723457`*^9, 3.496442726484756*^9}, {3.4964511572548466`*^9, 
   3.496451196884902*^9}, {3.4964647496374955`*^9, 3.4964647593420506`*^9}, {
   3.4964648485541534`*^9, 3.496464850611271*^9}, {3.49646510358774*^9, 
   3.49646514904034*^9}, {3.496465388706048*^9, 3.4964653947943964`*^9}, {
   3.4964654272642536`*^9, 3.496465506310775*^9}, 3.496465635184146*^9, {
   3.496465683603915*^9, 3.4964656938304996`*^9}, {3.4964661605171933`*^9, 
   3.4964661725558815`*^9}, {3.4964662031186295`*^9, 3.496466318316219*^9}, 
   3.49646637288834*^9, {3.4964666554985046`*^9, 3.496466712977792*^9}, {
   3.4964668475174875`*^9, 3.4964668531178074`*^9}, {3.4964669199346294`*^9, 
   3.4964669734406896`*^9}, 3.496467328943023*^9, {3.496467618375578*^9, 
   3.4964676253709784`*^9}, {3.4964677807798667`*^9, 3.496467788602314*^9}, {
   3.496467898612606*^9, 3.496467977559122*^9}, {3.496468036723506*^9, 
   3.49646804064073*^9}, {3.496468137265257*^9, 3.4964682293865256`*^9}, {
   3.496468813145915*^9, 3.496468813864956*^9}, {3.496514571962569*^9, 
   3.4965146071126184`*^9}, {3.4965146384626627`*^9, 
   3.4965146419226675`*^9}, {3.496514674612713*^9, 3.496514696162743*^9}, {
   3.4965147692828455`*^9, 3.4965148093429017`*^9}, {3.4965151889334335`*^9, 
   3.496515190463435*^9}, 3.4965153172936125`*^9, 3.496515468783825*^9}],

Cell[TextData[{
 "Rule: If ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"n", "-", "2"}], "4"], ",", 
   RowBox[{
    RowBox[{
     FractionBox["m", "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
    "\[And]", " ", 
    RowBox[{"0", "<", "m", "<", "n"}], " ", "\[And]", " ", 
    RowBox[{"CoprimeQ", "[", 
     RowBox[{
      RowBox[{"m", "+", "1"}], ",", "n"}], "]"}], " ", "\[And]", " ", 
    RowBox[{
     FractionBox["a", "b"], ">", "0"}]}]}]]],
 ", let ",
 Cell[BoxData[
  RowBox[{
   FractionBox["r", "s"], "=", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["a", "b"], ")"}], 
    RowBox[{"2", "/", "n"}]]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.4964646821336346`*^9, 3.4964646836247196`*^9}, {3.4964650083112907`*^9, 
   3.496465017058791*^9}, 3.496465725016284*^9, 3.4964663908553677`*^9, {
   3.4964664249763193`*^9, 3.4964664960673857`*^9}, {3.4964670220844717`*^9, 
   3.496467057769513*^9}, {3.4964675741690493`*^9, 3.496467598274428*^9}, 
   3.4964682381240253`*^9, 3.4964688263306684`*^9, {3.4965149800531406`*^9, 
   3.4965149968931646`*^9}, 3.4965160783646784`*^9, {3.4965166582154903`*^9, 
   3.496516666765502*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "m"], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "r"}], ")"}], 
          RowBox[{
           FractionBox["m", "2"], "+", "1"}]]}], 
        RowBox[{"a", " ", "n", " ", 
         SuperscriptBox["s", 
          RowBox[{"m", "/", "2"}]]}]]}]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"r", "+", 
        RowBox[{"s", " ", 
         SuperscriptBox["x", "2"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"4", " ", 
     SuperscriptBox["r", 
      RowBox[{
       FractionBox["m", "2"], "+", "1"}]]}], 
    RowBox[{"a", " ", "n", " ", 
     SuperscriptBox["s", 
      RowBox[{"m", "/", "2"}]]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"k", "=", "1"}], 
      FractionBox[
       RowBox[{"n", "-", "2"}], "4"]], 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"r", " ", 
         RowBox[{"Cos", "[", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "k"}], "-", "1"}], ")"}], " ", "m", " ", 
            "\[Pi]"}], "n"], "]"}]}], "-", 
        RowBox[{"s", " ", 
         RowBox[{"Cos", "[", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "k"}], "-", "1"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"m", "+", "2"}], ")"}], " ", "\[Pi]"}], "n"], "]"}], " ", 
         SuperscriptBox["x", "2"]}]}], 
       RowBox[{
        SuperscriptBox["r", "2"], "-", 
        RowBox[{"2", " ", "r", " ", "s", " ", 
         RowBox[{"Cos", "[", 
          FractionBox[
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "k"}], "-", "1"}], ")"}], " ", "\[Pi]"}], 
           "n"], "]"}], " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["s", "2"], " ", 
         SuperscriptBox["x", "4"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.4964644989841585`*^9, 3.4964645106438255`*^9}, 
   3.496464612803669*^9, 3.4964649458717194`*^9, {3.4964652217164965`*^9, 
   3.4964652233565903`*^9}, 3.4964653445205207`*^9, 3.4964654227749968`*^9, 
   3.4964656745803995`*^9, {3.496466129287407*^9, 3.4964661393309813`*^9}, 
   3.4964668963682814`*^9, 3.4964672281532583`*^9, 3.496467531557612*^9, {
   3.496514489212454*^9, 3.4965145030624733`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ",
   ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", "=", 
        RowBox[{"Numerator", "[", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{"a", "/", "b"}], ",", 
           RowBox[{"n", "/", "2"}]}], "]"}], "]"}]}], ",", " ", 
       RowBox[{"s", "=", 
        RowBox[{"Denominator", "[", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{"a", "/", "b"}], ",", 
           RowBox[{"n", "/", "2"}]}], "]"}], "]"}]}]}], "}"}], ",", "\n", 
     "  ", 
     RowBox[{
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], "*", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"-", "r"}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"m", "/", "2"}], "+", "1"}], ")"}]}], "/", 
          RowBox[{"(", 
           RowBox[{"a", "*", "n", "*", 
            RowBox[{"s", "^", 
             RowBox[{"(", 
              RowBox[{"m", "/", "2"}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{"1", "/", 
           RowBox[{"(", 
            RowBox[{"r", "+", 
             RowBox[{"s", "*", 
              RowBox[{"x", "^", "2"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
       "]"}], " ", "+", "\n", "  ", 
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"4", "*", 
         RowBox[{
          RowBox[{"r", "^", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"m", "/", "2"}], "+", "1"}], ")"}]}], "/", 
          RowBox[{"(", 
           RowBox[{"a", "*", "n", "*", 
            RowBox[{"s", "^", 
             RowBox[{"(", 
              RowBox[{"m", "/", "2"}], ")"}]}]}], ")"}]}]}], ",", "\n", "\t", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{"Sum", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"r", "*", 
                RowBox[{"Cos", "[", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", "*", "k"}], "-", "1"}], ")"}], "*", "m", "*", 
                  RowBox[{"Pi", "/", "n"}]}], "]"}]}], "-", 
               RowBox[{"s", "*", 
                RowBox[{"Cos", "[", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", "*", "k"}], "-", "1"}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{"m", "+", "2"}], ")"}], "*", 
                  RowBox[{"Pi", "/", "n"}]}], "]"}], "*", 
                RowBox[{"x", "^", "2"}]}]}], ")"}], "/", "\n", "      ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"r", "^", "2"}], "-", 
               RowBox[{"2", "*", "r", "*", "s", "*", 
                RowBox[{"Cos", "[", 
                 RowBox[{"2", "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", "*", "k"}], "-", "1"}], ")"}], "*", 
                  RowBox[{"Pi", "/", "n"}]}], "]"}], "*", 
                RowBox[{"x", "^", "2"}]}], "+", 
               RowBox[{
                RowBox[{"s", "^", "2"}], "*", 
                RowBox[{"x", "^", "4"}]}]}], ")"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"k", ",", "1", ",", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"n", "-", "2"}], ")"}], "/", "4"}]}], "}"}]}], "]"}], 
          ",", "x"}], "]"}]}], "]"}]}]}], "]"}], " ", "/;", "\n", " ", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "-", "2"}], ")"}], "/", "4"}], ",", 
      RowBox[{"m", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"0", "<", "m", "<", "n"}], " ", "&&", " ", 
    RowBox[{"CoprimeQ", "[", 
     RowBox[{
      RowBox[{"m", "+", "1"}], ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"PosQ", "[", 
     RowBox[{"a", "/", "b"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, {
   3.4964643615542984`*^9, 3.496464371474866*^9}, {3.4964646331298313`*^9, 
   3.496464674701209*^9}, {3.4964648742126207`*^9, 3.4964648899195194`*^9}, 
   3.4964651866304903`*^9, 3.4964656304258738`*^9, 3.4964658849164295`*^9, {
   3.496466500015611*^9, 3.496466503963837*^9}, 3.496466597108165*^9, 
   3.4964671193880377`*^9, {3.4964674556312695`*^9, 3.496467494522494*^9}, 
   3.496514244312111*^9, {3.4965143404022455`*^9, 3.496514342862249*^9}, {
   3.4965143986923265`*^9, 3.4965144172723527`*^9}, {3.496514542262528*^9, 
   3.496514555222546*^9}, {3.4965158299543304`*^9, 3.496515833994336*^9}, 
   3.496516650435479*^9, {3.5171911970595846`*^9, 3.5171911999923897`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496464732151495*^9, 3.4964650841426277`*^9}],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"n", "-", "2"}], "4"], ",", 
   RowBox[{
    FractionBox["m", "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}]}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"0", "\[LessEqual]", "m", "<", "n"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{
   FractionBox["r", "s"], "=", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", 
      FractionBox["a", "b"]}], ")"}], 
    RowBox[{"2", "/", "n"}]]}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    SuperscriptBox["z", "m"], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["z", "n"]}]}]], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["r", 
       RowBox[{
        FractionBox["m", "2"], "+", "1"}]]}], 
     RowBox[{"a", " ", "n", " ", 
      SuperscriptBox["s", 
       RowBox[{"m", "/", "2"}]], 
      RowBox[{"(", 
       RowBox[{"r", "-", 
        RowBox[{"s", " ", 
         SuperscriptBox["z", "2"]}]}], ")"}]}]], "+", 
    RowBox[{
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["r", 
        RowBox[{
         FractionBox["m", "2"], "+", "1"}]]}], 
      RowBox[{"a", " ", "n", " ", 
       SuperscriptBox["s", 
        RowBox[{"m", "/", "2"}]]}]], 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"k", "=", "1"}], 
       FractionBox[
        RowBox[{"n", "-", "2"}], "4"]], 
      FractionBox[
       RowBox[{
        RowBox[{"r", " ", 
         RowBox[{"Cos", "[", 
          FractionBox[
           RowBox[{"2", " ", "k", " ", "m", " ", "\[Pi]"}], "n"], "]"}]}], 
        "-", 
        RowBox[{"s", " ", 
         RowBox[{"Cos", "[", 
          FractionBox[
           RowBox[{"2", " ", "k", " ", 
            RowBox[{"(", 
             RowBox[{"m", "+", "2"}], ")"}], " ", "\[Pi]"}], "n"], "]"}], " ", 
         SuperscriptBox["z", "2"]}]}], 
       RowBox[{
        SuperscriptBox["r", "2"], "-", 
        RowBox[{"2", " ", "r", " ", "s", " ", 
         RowBox[{"Cos", "[", 
          FractionBox[
           RowBox[{"4", " ", "k", " ", "\[Pi]"}], "n"], "]"}], " ", 
         SuperscriptBox["z", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["s", "2"], " ", 
         SuperscriptBox["z", "4"]}]}]]}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
   3.4964427205723457`*^9, 3.496442726484756*^9}, {3.4964511572548466`*^9, 
   3.496451196884902*^9}, {3.4964647496374955`*^9, 3.4964647593420506`*^9}, {
   3.4964648485541534`*^9, 3.496464850611271*^9}, {3.49646510358774*^9, 
   3.49646514904034*^9}, {3.496465388706048*^9, 3.4964653947943964`*^9}, {
   3.4964654272642536`*^9, 3.496465506310775*^9}, 3.496465635184146*^9, {
   3.496465683603915*^9, 3.4964656938304996`*^9}, {3.4964661605171933`*^9, 
   3.4964661725558815`*^9}, {3.4964662031186295`*^9, 3.496466318316219*^9}, 
   3.49646637288834*^9, {3.4964666554985046`*^9, 3.496466712977792*^9}, {
   3.4964668475174875`*^9, 3.4964668531178074`*^9}, {3.4964669199346294`*^9, 
   3.4964669734406896`*^9}, 3.496467328943023*^9, {3.496467618375578*^9, 
   3.4964676253709784`*^9}, {3.4964677807798667`*^9, 3.496467788602314*^9}, {
   3.496467898612606*^9, 3.496467977559122*^9}, {3.496468036723506*^9, 
   3.49646804064073*^9}, {3.496468137265257*^9, 3.4964682293865256`*^9}, {
   3.496468813145915*^9, 3.496468813864956*^9}, {3.496514571962569*^9, 
   3.4965146071126184`*^9}, {3.4965146384626627`*^9, 
   3.4965146419226675`*^9}, {3.496514674612713*^9, 3.496514696162743*^9}, {
   3.4965147692828455`*^9, 3.4965148093429017`*^9}, 3.4965151448733716`*^9, {
   3.4965151819934235`*^9, 3.496515184483427*^9}, {3.4965154553438063`*^9, 
   3.4965154597538123`*^9}, {3.496515659664092*^9, 3.496515716704172*^9}, 
   3.4965157533642235`*^9}],

Cell[TextData[{
 "Rule: If ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"n", "-", "2"}], "4"], ",", 
   RowBox[{
    RowBox[{
     FractionBox["m", "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
    "\[And]", " ", 
    RowBox[{"0", "<", "m", "<", "n"}], " ", "\[And]", " ", 
    RowBox[{"CoprimeQ", "[", 
     RowBox[{
      RowBox[{"m", "+", "1"}], ",", "n"}], "]"}], " ", "\[And]", " ", 
    RowBox[{"\[Not]", 
     RowBox[{"(", 
      RowBox[{
       FractionBox["a", "b"], ">", "0"}], ")"}]}]}]}]]],
 ", let ",
 Cell[BoxData[
  RowBox[{
   FractionBox["r", "s"], "=", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", 
      FractionBox["a", "b"]}], ")"}], 
    RowBox[{"2", "/", "n"}]]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.4964646821336346`*^9, 3.4964646836247196`*^9}, {3.4964650083112907`*^9, 
   3.496465017058791*^9}, 3.496465725016284*^9, 3.4964663908553677`*^9, {
   3.4964664249763193`*^9, 3.4964664960673857`*^9}, {3.4964670220844717`*^9, 
   3.496467057769513*^9}, {3.4964675741690493`*^9, 3.496467598274428*^9}, 
   3.4964682381240253`*^9, 3.4964688263306684`*^9, {3.4965149800531406`*^9, 
   3.4965149968931646`*^9}, 3.4965151073133187`*^9, {3.496515592303998*^9, 
   3.4965156140140285`*^9}, 3.4965166821155233`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "m"], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"2", " ", 
        SuperscriptBox["r", 
         RowBox[{
          FractionBox["m", "2"], "+", "1"}]]}], 
       RowBox[{"a", " ", "n", " ", 
        SuperscriptBox["s", 
         RowBox[{"m", "/", "2"}]]}]]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"r", "-", 
        RowBox[{"s", " ", 
         SuperscriptBox["x", "2"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"4", " ", 
     SuperscriptBox["r", 
      RowBox[{
       FractionBox["m", "2"], "+", "1"}]]}], 
    RowBox[{"a", " ", "n", " ", 
     SuperscriptBox["s", 
      RowBox[{"m", "/", "2"}]]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"k", "=", "1"}], 
      FractionBox[
       RowBox[{"n", "-", "2"}], "4"]], 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"r", " ", 
         RowBox[{"Cos", "[", 
          FractionBox[
           RowBox[{"2", " ", "k", " ", "m", " ", "\[Pi]"}], "n"], "]"}]}], 
        "-", 
        RowBox[{"s", " ", 
         RowBox[{"Cos", "[", 
          FractionBox[
           RowBox[{"2", " ", "k", " ", 
            RowBox[{"(", 
             RowBox[{"m", "+", "2"}], ")"}], " ", "\[Pi]"}], "n"], "]"}], " ", 
         SuperscriptBox["x", "2"]}]}], 
       RowBox[{
        SuperscriptBox["r", "2"], "-", 
        RowBox[{"2", " ", "r", " ", "s", " ", 
         RowBox[{"Cos", "[", 
          FractionBox[
           RowBox[{"4", " ", "k", " ", "\[Pi]"}], "n"], "]"}], " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["s", "2"], " ", 
         SuperscriptBox["x", "4"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.4964644989841585`*^9, 3.4964645106438255`*^9}, 
   3.496464612803669*^9, 3.4964649458717194`*^9, {3.4964652217164965`*^9, 
   3.4964652233565903`*^9}, 3.4964653445205207`*^9, 3.4964654227749968`*^9, 
   3.4964656745803995`*^9, {3.496466129287407*^9, 3.4964661393309813`*^9}, 
   3.4964668963682814`*^9, 3.4964672281532583`*^9, 3.496467531557612*^9, {
   3.496514489212454*^9, 3.4965145030624733`*^9}, {3.4965155433939295`*^9, 
   3.4965155674639635`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ",
   ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", "=", 
        RowBox[{"Numerator", "[", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "a"}], "/", "b"}], ",", 
           RowBox[{"n", "/", "2"}]}], "]"}], "]"}]}], ",", " ", 
       RowBox[{"s", "=", 
        RowBox[{"Denominator", "[", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "a"}], "/", "b"}], ",", 
           RowBox[{"n", "/", "2"}]}], "]"}], "]"}]}]}], "}"}], ",", "\n", 
     "  ", 
     RowBox[{
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"2", "*", 
         RowBox[{
          RowBox[{"r", "^", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"m", "/", "2"}], "+", "1"}], ")"}]}], "/", 
          RowBox[{"(", 
           RowBox[{"a", "*", "n", "*", 
            RowBox[{"s", "^", 
             RowBox[{"(", 
              RowBox[{"m", "/", "2"}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{"1", "/", 
           RowBox[{"(", 
            RowBox[{"r", "-", 
             RowBox[{"s", "*", 
              RowBox[{"x", "^", "2"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
       "]"}], " ", "+", "\n", "  ", 
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"4", "*", 
         RowBox[{
          RowBox[{"r", "^", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"m", "/", "2"}], "+", "1"}], ")"}]}], "/", 
          RowBox[{"(", 
           RowBox[{"a", "*", "n", "*", 
            RowBox[{"s", "^", 
             RowBox[{"(", 
              RowBox[{"m", "/", "2"}], ")"}]}]}], ")"}]}]}], ",", "\n", "\t", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{"Sum", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"r", "*", 
                RowBox[{"Cos", "[", 
                 RowBox[{"2", "*", "k", "*", "m", "*", 
                  RowBox[{"Pi", "/", "n"}]}], "]"}]}], "-", 
               RowBox[{"s", "*", 
                RowBox[{"Cos", "[", 
                 RowBox[{"2", "*", "k", "*", 
                  RowBox[{"(", 
                   RowBox[{"m", "+", "2"}], ")"}], "*", 
                  RowBox[{"Pi", "/", "n"}]}], "]"}], "*", 
                RowBox[{"x", "^", "2"}]}]}], ")"}], "/", "\n", "      ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"r", "^", "2"}], "-", 
               RowBox[{"2", "*", "r", "*", "s", "*", 
                RowBox[{"Cos", "[", 
                 RowBox[{"4", "*", "k", "*", 
                  RowBox[{"Pi", "/", "n"}]}], "]"}], "*", 
                RowBox[{"x", "^", "2"}]}], "+", 
               RowBox[{
                RowBox[{"s", "^", "2"}], "*", 
                RowBox[{"x", "^", "4"}]}]}], ")"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"k", ",", "1", ",", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"n", "-", "2"}], ")"}], "/", "4"}]}], "}"}]}], "]"}], 
          ",", "x"}], "]"}]}], "]"}]}]}], "]"}], " ", "/;", "\n", " ", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "-", "2"}], ")"}], "/", "4"}], ",", 
      RowBox[{"m", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"0", "<", "m", "<", "n"}], " ", "&&", " ", 
    RowBox[{"CoprimeQ", "[", 
     RowBox[{
      RowBox[{"m", "+", "1"}], ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"NegQ", "[", 
     RowBox[{"a", "/", "b"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, {
   3.4964643615542984`*^9, 3.496464371474866*^9}, {3.4964646331298313`*^9, 
   3.496464674701209*^9}, {3.4964648742126207`*^9, 3.4964648899195194`*^9}, 
   3.4964651866304903`*^9, 3.4964656304258738`*^9, 3.4964658849164295`*^9, {
   3.496466500015611*^9, 3.496466503963837*^9}, 3.496466597108165*^9, 
   3.4964671193880377`*^9, {3.4964674556312695`*^9, 3.496467494522494*^9}, 
   3.496514244312111*^9, {3.4965143404022455`*^9, 3.496514342862249*^9}, {
   3.4965143986923265`*^9, 3.4965144172723527`*^9}, {3.496514542262528*^9, 
   3.496514555222546*^9}, {3.4965150545032454`*^9, 3.496515089453294*^9}, {
   3.4965158432443495`*^9, 3.4965158448943515`*^9}, 3.4965166455554724`*^9, {
   3.517191202067193*^9, 3.5171912051871986`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496464732151495*^9, 3.4964650841426277`*^9}],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"n", "-", "1"}], "2"], ",", 
   RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}]}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"0", "\[LessEqual]", "m", "<", "n"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{
   FractionBox["r", "s"], "=", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["a", "b"], ")"}], 
    RowBox[{"1", "/", "n"}]]}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    SuperscriptBox["z", "m"], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["z", "n"]}]}]], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "r"}], ")"}], 
       RowBox[{"m", "+", "1"}]], 
      RowBox[{"a", " ", "n", " ", 
       SuperscriptBox["s", "m"], " ", 
       RowBox[{"(", 
        RowBox[{"r", "+", 
         RowBox[{"s", " ", "z"}]}], ")"}]}]]}], "+", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"k", "=", "1"}], 
      FractionBox[
       RowBox[{"n", "-", "1"}], "2"]], 
     FractionBox[
      RowBox[{"2", " ", 
       SuperscriptBox["r", 
        RowBox[{"m", "+", "1"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"r", " ", 
          RowBox[{"Cos", "[", 
           FractionBox[
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "k"}], "-", "1"}], ")"}], " ", "m", " ", 
             "\[Pi]"}], "n"], "]"}]}], "-", 
         RowBox[{"s", " ", 
          RowBox[{"Cos", "[", 
           FractionBox[
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "k"}], "-", "1"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"m", "+", "1"}], ")"}], " ", "\[Pi]"}], "n"], "]"}], 
          " ", "z"}]}], ")"}]}], 
      RowBox[{"a", " ", "n", " ", 
       SuperscriptBox["s", "m"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["r", "2"], "-", 
         RowBox[{"2", " ", "r", " ", "s", " ", 
          RowBox[{"Cos", "[", 
           FractionBox[
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "k"}], "-", "1"}], ")"}], " ", "\[Pi]"}], 
            "n"], "]"}], " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["s", "2"], " ", 
          SuperscriptBox["z", "2"]}]}], ")"}]}]]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
   3.4964427205723457`*^9, 3.496442726484756*^9}, {3.4964511572548466`*^9, 
   3.496451196884902*^9}, {3.4964647496374955`*^9, 3.4964647593420506`*^9}, {
   3.4964648485541534`*^9, 3.496464850611271*^9}, {3.49646510358774*^9, 
   3.49646514904034*^9}, {3.496465388706048*^9, 3.4964653947943964`*^9}, {
   3.4964654272642536`*^9, 3.496465506310775*^9}, 3.496465635184146*^9, {
   3.496465683603915*^9, 3.4964656938304996`*^9}, {3.4964661605171933`*^9, 
   3.4964661725558815`*^9}, {3.4964662031186295`*^9, 3.496466318316219*^9}, 
   3.49646637288834*^9, {3.4964666554985046`*^9, 3.496466712977792*^9}, {
   3.4964668475174875`*^9, 3.4964668531178074`*^9}, {3.4964669199346294`*^9, 
   3.4964669734406896`*^9}, 3.496467328943023*^9, {3.496467618375578*^9, 
   3.4964676253709784`*^9}, {3.4964677807798667`*^9, 3.496467788602314*^9}, {
   3.496467898612606*^9, 3.496467977559122*^9}, {3.496468036723506*^9, 
   3.49646804064073*^9}, {3.496468137265257*^9, 3.4964682293865256`*^9}, {
   3.496468813145915*^9, 3.496468813864956*^9}, {3.496514571962569*^9, 
   3.4965146071126184`*^9}, {3.4965146384626627`*^9, 
   3.4965146419226675`*^9}, {3.496514674612713*^9, 3.496514696162743*^9}, {
   3.4965147692828455`*^9, 3.4965148093429017`*^9}, {3.4965151889334335`*^9, 
   3.496515190463435*^9}, 3.4965153172936125`*^9, 3.496515468783825*^9, {
   3.4965161241547422`*^9, 3.496516150454779*^9}, {3.496516353175063*^9, 
   3.4965163555850663`*^9}, {3.496516389655114*^9, 3.49651640108513*^9}}],

Cell[TextData[{
 "Rule: If ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"n", "-", "1"}], "2"], ",", 
   RowBox[{
    RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"0", "<", "m", "<", "n"}], " ", "\[And]", " ", 
    RowBox[{"CoprimeQ", "[", 
     RowBox[{
      RowBox[{"m", "+", "1"}], ",", "n"}], "]"}], " ", "\[And]", " ", 
    RowBox[{
     FractionBox["a", "b"], ">", "0"}]}]}]]],
 ", let ",
 Cell[BoxData[
  RowBox[{
   FractionBox["r", "s"], "=", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["a", "b"], ")"}], 
    RowBox[{"1", "/", "n"}]]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.4964646821336346`*^9, 3.4964646836247196`*^9}, {3.4964650083112907`*^9, 
   3.496465017058791*^9}, 3.496465725016284*^9, 3.4964663908553677`*^9, {
   3.4964664249763193`*^9, 3.4964664960673857`*^9}, {3.4964670220844717`*^9, 
   3.496467057769513*^9}, {3.4964675741690493`*^9, 3.496467598274428*^9}, 
   3.4964682381240253`*^9, 3.4964688263306684`*^9, {3.4965149800531406`*^9, 
   3.4965149968931646`*^9}, {3.4965160321846137`*^9, 
   3.4965160434646297`*^9}, {3.4965160899846945`*^9, 3.496516110014723*^9}, 
   3.4965166869655304`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "m"], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"\[Integral]", 
       RowBox[{"-", 
        FractionBox[
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "r"}], ")"}], 
          RowBox[{"m", "+", "1"}]], 
         RowBox[{"a", " ", "n", " ", 
          SuperscriptBox["s", "m"], " ", 
          RowBox[{"(", 
           RowBox[{"r", "+", 
            RowBox[{"s", " ", "x"}]}], ")"}]}]]}]}]}]}]}]}], "+", 
  RowBox[{
   UnderoverscriptBox["\[Sum]", 
    RowBox[{"k", "=", "1"}], 
    FractionBox[
     RowBox[{"n", "-", "1"}], "2"]], 
   RowBox[{
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["r", 
       RowBox[{"m", "+", "1"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"r", " ", 
         RowBox[{"Cos", "[", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "k"}], "-", "1"}], ")"}], " ", "m", " ", 
            "\[Pi]"}], "n"], "]"}]}], "-", 
        RowBox[{"s", " ", 
         RowBox[{"Cos", "[", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "k"}], "-", "1"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"m", "+", "1"}], ")"}], " ", "\[Pi]"}], "n"], "]"}], " ",
          "x"}]}], ")"}]}], 
     RowBox[{"a", " ", "n", " ", 
      SuperscriptBox["s", "m"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["r", "2"], "-", 
        RowBox[{"2", " ", "r", " ", "s", " ", 
         RowBox[{"Cos", "[", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "k"}], "-", "1"}], ")"}], " ", "\[Pi]"}], 
           "n"], "]"}], " ", "x"}], "+", 
        RowBox[{
         SuperscriptBox["s", "2"], " ", 
         SuperscriptBox["x", "2"]}]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.4964644989841585`*^9, 3.4964645106438255`*^9}, 
   3.496464612803669*^9, 3.4964649458717194`*^9, {3.4964652217164965`*^9, 
   3.4964652233565903`*^9}, 3.4964653445205207`*^9, 3.4964654227749968`*^9, 
   3.4964656745803995`*^9, {3.496466129287407*^9, 3.4964661393309813`*^9}, 
   3.4964668963682814`*^9, 3.4964672281532583`*^9, 3.496467531557612*^9, {
   3.496514489212454*^9, 3.4965145030624733`*^9}, 3.496516000204569*^9, {
   3.496516183174825*^9, 3.4965162011448507`*^9}, 3.4965163255250244`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ",
   ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", "=", 
        RowBox[{"Numerator", "[", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{"a", "/", "b"}], ",", "n"}], "]"}], "]"}]}], ",", " ", 
       RowBox[{"s", "=", 
        RowBox[{"Denominator", "[", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{"a", "/", "b"}], ",", "n"}], "]"}], "]"}]}]}], "}"}], ",", 
     "\n", "  ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"-", "r"}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{"m", "+", "1"}], ")"}]}]}], "/", 
         RowBox[{"(", 
          RowBox[{"a", "*", "n", "*", 
           RowBox[{"s", "^", "m"}], "*", 
           RowBox[{"(", 
            RowBox[{"r", "+", 
             RowBox[{"s", "*", "x"}]}], ")"}]}], ")"}]}], " ", "+", "\n", 
        "    ", 
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{"2", "*", 
           RowBox[{"r", "^", 
            RowBox[{"(", 
             RowBox[{"m", "+", "1"}], ")"}]}], "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"r", "*", 
               RowBox[{"Cos", "[", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", "*", "k"}], "-", "1"}], ")"}], "*", "m", "*", 
                 RowBox[{"Pi", "/", "n"}]}], "]"}]}], "-", 
              RowBox[{"s", "*", 
               RowBox[{"Cos", "[", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", "*", "k"}], "-", "1"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"m", "+", "1"}], ")"}], "*", 
                 RowBox[{"Pi", "/", "n"}]}], "]"}], "*", "x"}]}], ")"}], "/", 
            "\n", "      ", 
            RowBox[{"(", 
             RowBox[{"a", "*", "n", "*", 
              RowBox[{"s", "^", "m"}], "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"r", "^", "2"}], "-", 
                RowBox[{"2", "*", "r", "*", "s", "*", 
                 RowBox[{"Cos", "[", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", "*", "k"}], "-", "1"}], ")"}], "*", 
                   RowBox[{"Pi", "/", "n"}]}], "]"}], "*", "x"}], "+", 
                RowBox[{
                 RowBox[{"s", "^", "2"}], "*", 
                 RowBox[{"x", "^", "2"}]}]}], ")"}]}], ")"}]}]}], ",", 
          RowBox[{"{", 
           RowBox[{"k", ",", "1", ",", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"n", "-", "1"}], ")"}], "/", "2"}]}], "}"}]}], "]"}]}], 
       ",", "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}], "/", "2"}], ",", "m"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"0", "<", "m", "<", "n"}], " ", "&&", " ", 
    RowBox[{"CoprimeQ", "[", 
     RowBox[{
      RowBox[{"m", "+", "1"}], ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"PosQ", "[", 
     RowBox[{"a", "/", "b"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, {
   3.4964643615542984`*^9, 3.496464371474866*^9}, {3.4964646331298313`*^9, 
   3.496464674701209*^9}, {3.4964648742126207`*^9, 3.4964648899195194`*^9}, 
   3.4964651866304903`*^9, 3.4964656304258738`*^9, 3.4964658849164295`*^9, {
   3.496466500015611*^9, 3.496466503963837*^9}, 3.496466597108165*^9, 
   3.4964671193880377`*^9, {3.4964674556312695`*^9, 3.496467494522494*^9}, 
   3.496514244312111*^9, {3.4965143404022455`*^9, 3.496514342862249*^9}, {
   3.4965143986923265`*^9, 3.4965144172723527`*^9}, {3.496514542262528*^9, 
   3.496514555222546*^9}, {3.4965158299543304`*^9, 3.496515833994336*^9}, {
   3.4965159320344734`*^9, 3.496515967174523*^9}, {3.4965162432549095`*^9, 
   3.496516276364956*^9}, {3.4965166290954494`*^9, 3.496516635815459*^9}, {
   3.496516723715582*^9, 3.496516738155602*^9}, {3.5171912070592017`*^9, 
   3.5171912095708065`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496464732151495*^9, 3.4964650841426277`*^9}],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"n", "-", "1"}], "2"], ",", 
   RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}]}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"0", "\[LessEqual]", "m", "<", "n"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{
   FractionBox["r", "s"], "=", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", 
      FractionBox["a", "b"]}], ")"}], 
    RowBox[{"1", "/", "n"}]]}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    SuperscriptBox["z", "m"], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["z", "n"]}]}]], "=", 
   RowBox[{
    FractionBox[
     SuperscriptBox["r", 
      RowBox[{"m", "+", "1"}]], 
     RowBox[{"a", " ", "n", " ", 
      SuperscriptBox["s", "m"], " ", 
      RowBox[{"(", 
       RowBox[{"r", "-", 
        RowBox[{"s", " ", "z"}]}], ")"}]}]], "-", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"k", "=", "1"}], 
      FractionBox[
       RowBox[{"n", "-", "1"}], "2"]], 
     FractionBox[
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "r"}], ")"}], 
        RowBox[{"m", "+", "1"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"r", " ", 
          RowBox[{"Cos", "[", 
           FractionBox[
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "k"}], "-", "1"}], ")"}], " ", "m", " ", 
             "\[Pi]"}], "n"], "]"}]}], "+", 
         RowBox[{"s", " ", 
          RowBox[{"Cos", "[", 
           FractionBox[
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "k"}], "-", "1"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"m", "+", "1"}], ")"}], " ", "\[Pi]"}], "n"], "]"}], 
          " ", "z"}]}], ")"}]}], 
      RowBox[{"a", " ", "n", " ", 
       SuperscriptBox["s", "m"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["r", "2"], "+", 
         RowBox[{"2", " ", "r", " ", "s", " ", 
          RowBox[{"Cos", "[", 
           FractionBox[
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "k"}], "-", "1"}], ")"}], " ", "\[Pi]"}], 
            "n"], "]"}], " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["s", "2"], " ", 
          SuperscriptBox["z", "2"]}]}], ")"}]}]]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
   3.4964427205723457`*^9, 3.496442726484756*^9}, {3.4964511572548466`*^9, 
   3.496451196884902*^9}, {3.4964647496374955`*^9, 3.4964647593420506`*^9}, {
   3.4964648485541534`*^9, 3.496464850611271*^9}, {3.49646510358774*^9, 
   3.49646514904034*^9}, {3.496465388706048*^9, 3.4964653947943964`*^9}, {
   3.4964654272642536`*^9, 3.496465506310775*^9}, 3.496465635184146*^9, {
   3.496465683603915*^9, 3.4964656938304996`*^9}, {3.4964661605171933`*^9, 
   3.4964661725558815`*^9}, {3.4964662031186295`*^9, 3.496466318316219*^9}, 
   3.49646637288834*^9, {3.4964666554985046`*^9, 3.496466712977792*^9}, {
   3.4964668475174875`*^9, 3.4964668531178074`*^9}, {3.4964669199346294`*^9, 
   3.4964669734406896`*^9}, 3.496467328943023*^9, {3.496467618375578*^9, 
   3.4964676253709784`*^9}, {3.4964677807798667`*^9, 3.496467788602314*^9}, {
   3.496467898612606*^9, 3.496467977559122*^9}, {3.496468036723506*^9, 
   3.49646804064073*^9}, {3.496468137265257*^9, 3.4964682293865256`*^9}, {
   3.496468813145915*^9, 3.496468813864956*^9}, {3.496514571962569*^9, 
   3.4965146071126184`*^9}, {3.4965146384626627`*^9, 
   3.4965146419226675`*^9}, {3.496514674612713*^9, 3.496514696162743*^9}, {
   3.4965147692828455`*^9, 3.4965148093429017`*^9}, {3.4965151889334335`*^9, 
   3.496515190463435*^9}, 3.4965153172936125`*^9, 3.496515468783825*^9, {
   3.4965161241547422`*^9, 3.496516150454779*^9}, {3.496516353175063*^9, 
   3.4965163555850663`*^9}, {3.496516389655114*^9, 3.49651640108513*^9}, 
   3.4965169255958643`*^9, {3.496517024356003*^9, 3.49651706516606*^9}, 
   3.496517134726157*^9}],

Cell[TextData[{
 "Rule: If ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"n", "-", "1"}], "2"], ",", 
   RowBox[{
    RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"0", "<", "m", "<", "n"}], " ", "\[And]", " ", 
    RowBox[{"CoprimeQ", "[", 
     RowBox[{
      RowBox[{"m", "+", "1"}], ",", "n"}], "]"}], " ", "\[And]", " ", 
    RowBox[{"\[Not]", 
     RowBox[{"(", 
      RowBox[{
       FractionBox["a", "b"], ">", "0"}], ")"}]}]}]}]]],
 ", let ",
 Cell[BoxData[
  RowBox[{
   FractionBox["r", "s"], "=", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", 
      FractionBox["a", "b"]}], ")"}], 
    RowBox[{"1", "/", "n"}]]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.4964646821336346`*^9, 3.4964646836247196`*^9}, {3.4964650083112907`*^9, 
   3.496465017058791*^9}, 3.496465725016284*^9, 3.4964663908553677`*^9, {
   3.4964664249763193`*^9, 3.4964664960673857`*^9}, {3.4964670220844717`*^9, 
   3.496467057769513*^9}, {3.4964675741690493`*^9, 3.496467598274428*^9}, 
   3.4964682381240253`*^9, 3.4964688263306684`*^9, {3.4965149800531406`*^9, 
   3.4965149968931646`*^9}, {3.4965160321846137`*^9, 
   3.4965160434646297`*^9}, {3.4965160899846945`*^9, 3.496516110014723*^9}, 
   3.4965166869655304`*^9, {3.4965169127458467`*^9, 3.4965169220558596`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "m"], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"\[Integral]", 
       FractionBox[
        SuperscriptBox["r", 
         RowBox[{"m", "+", "1"}]], 
        RowBox[{"a", " ", "n", " ", 
         SuperscriptBox["s", "m"], " ", 
         RowBox[{"(", 
          RowBox[{"r", "-", 
           RowBox[{"s", " ", "x"}]}], ")"}]}]]}]}]}]}]}], "-", 
  RowBox[{
   UnderoverscriptBox["\[Sum]", 
    RowBox[{"k", "=", "1"}], 
    FractionBox[
     RowBox[{"n", "-", "1"}], "2"]], 
   RowBox[{
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "r"}], ")"}], 
       RowBox[{"m", "+", "1"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"r", " ", 
         RowBox[{"Cos", "[", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "k"}], "-", "1"}], ")"}], " ", "m", " ", 
            "\[Pi]"}], "n"], "]"}]}], "+", 
        RowBox[{"s", " ", 
         RowBox[{"Cos", "[", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "k"}], "-", "1"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"m", "+", "1"}], ")"}], " ", "\[Pi]"}], "n"], "]"}], " ",
          "x"}]}], ")"}]}], 
     RowBox[{"a", " ", "n", " ", 
      SuperscriptBox["s", "m"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["r", "2"], "+", 
        RowBox[{"2", " ", "r", " ", "s", " ", 
         RowBox[{"Cos", "[", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "k"}], "-", "1"}], ")"}], " ", "\[Pi]"}], 
           "n"], "]"}], " ", "x"}], "+", 
        RowBox[{
         SuperscriptBox["s", "2"], " ", 
         SuperscriptBox["x", "2"]}]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.4964644989841585`*^9, 3.4964645106438255`*^9}, 
   3.496464612803669*^9, 3.4964649458717194`*^9, {3.4964652217164965`*^9, 
   3.4964652233565903`*^9}, 3.4964653445205207`*^9, 3.4964654227749968`*^9, 
   3.4964656745803995`*^9, {3.496466129287407*^9, 3.4964661393309813`*^9}, 
   3.4964668963682814`*^9, 3.4964672281532583`*^9, 3.496467531557612*^9, {
   3.496514489212454*^9, 3.4965145030624733`*^9}, 3.496516000204569*^9, {
   3.496516183174825*^9, 3.4965162011448507`*^9}, 3.4965163255250244`*^9, 
   3.4965169923259583`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ",
   ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", "=", 
        RowBox[{"Numerator", "[", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "a"}], "/", "b"}], ",", "n"}], "]"}], "]"}]}], ",", 
       " ", 
       RowBox[{"s", "=", 
        RowBox[{"Denominator", "[", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "a"}], "/", "b"}], ",", "n"}], "]"}], "]"}]}]}], 
      "}"}], ",", "\n", "  ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"r", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "/", 
         RowBox[{"(", 
          RowBox[{"a", "*", "n", "*", 
           RowBox[{"s", "^", "m"}], "*", 
           RowBox[{"(", 
            RowBox[{"r", "-", 
             RowBox[{"s", "*", "x"}]}], ")"}]}], ")"}]}], " ", "-", "\n", 
        "    ", 
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{"2", "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"-", "r"}], ")"}], "^", 
            RowBox[{"(", 
             RowBox[{"m", "+", "1"}], ")"}]}], "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"r", "*", 
               RowBox[{"Cos", "[", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", "*", "k"}], "-", "1"}], ")"}], "*", "m", "*", 
                 RowBox[{"Pi", "/", "n"}]}], "]"}]}], "+", 
              RowBox[{"s", "*", 
               RowBox[{"Cos", "[", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", "*", "k"}], "-", "1"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"m", "+", "1"}], ")"}], "*", 
                 RowBox[{"Pi", "/", "n"}]}], "]"}], "*", "x"}]}], ")"}], "/", 
            "\n", "      ", 
            RowBox[{"(", 
             RowBox[{"a", "*", "n", "*", 
              RowBox[{"s", "^", "m"}], "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"r", "^", "2"}], "+", 
                RowBox[{"2", "*", "r", "*", "s", "*", 
                 RowBox[{"Cos", "[", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", "*", "k"}], "-", "1"}], ")"}], "*", 
                   RowBox[{"Pi", "/", "n"}]}], "]"}], "*", "x"}], "+", 
                RowBox[{
                 RowBox[{"s", "^", "2"}], "*", 
                 RowBox[{"x", "^", "2"}]}]}], ")"}]}], ")"}]}]}], ",", 
          RowBox[{"{", 
           RowBox[{"k", ",", "1", ",", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"n", "-", "1"}], ")"}], "/", "2"}]}], "}"}]}], "]"}]}], 
       ",", "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}], "/", "2"}], ",", "m"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"0", "<", "m", "<", "n"}], " ", "&&", " ", 
    RowBox[{"CoprimeQ", "[", 
     RowBox[{
      RowBox[{"m", "+", "1"}], ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"NegQ", "[", 
     RowBox[{"a", "/", "b"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, {
   3.4964643615542984`*^9, 3.496464371474866*^9}, {3.4964646331298313`*^9, 
   3.496464674701209*^9}, {3.4964648742126207`*^9, 3.4964648899195194`*^9}, 
   3.4964651866304903`*^9, 3.4964656304258738`*^9, 3.4964658849164295`*^9, {
   3.496466500015611*^9, 3.496466503963837*^9}, 3.496466597108165*^9, 
   3.4964671193880377`*^9, {3.4964674556312695`*^9, 3.496467494522494*^9}, 
   3.496514244312111*^9, {3.4965143404022455`*^9, 3.496514342862249*^9}, {
   3.4965143986923265`*^9, 3.4965144172723527`*^9}, {3.496514542262528*^9, 
   3.496514555222546*^9}, {3.4965158299543304`*^9, 3.496515833994336*^9}, {
   3.4965159320344734`*^9, 3.496515967174523*^9}, {3.4965162432549095`*^9, 
   3.496516276364956*^9}, {3.4965166290954494`*^9, 3.496516635815459*^9}, {
   3.496516723715582*^9, 3.496516738155602*^9}, {3.496516845145752*^9, 
   3.4965168974758253`*^9}, {3.4965169607559137`*^9, 
   3.4965169661759214`*^9}, {3.5171912115364094`*^9, 3.5171912141728144`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Note: An integration rule for the following algebraic expansion is not \
needed since ",
 Cell[BoxData[
  RowBox[{"m", "+", "1"}]]],
 " and ",
 Cell[BoxData["n"]],
 " are not coprime when m is odd and n even:"
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496464732151495*^9, 3.4964650841426277`*^9, {3.496517259026331*^9, 
   3.4965173021163917`*^9}, {3.496518221467679*^9, 3.4965182546777253`*^9}}],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{
   FractionBox["n", "2"], ",", 
   RowBox[{
    FractionBox[
     RowBox[{"m", "+", "1"}], "2"], "\[Element]", 
    "\[DoubleStruckCapitalZ]"}]}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"0", "\[LessEqual]", "m", "<", "n"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{
   FractionBox["r", "s"], "=", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", 
      FractionBox["a", "b"]}], ")"}], 
    RowBox[{"1", "/", "n"}]]}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    SuperscriptBox["z", "m"], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["z", "n"]}]}]], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"2", 
      SuperscriptBox["r", 
       RowBox[{"m", "+", "1"}]], "z"}], 
     RowBox[{"a", " ", "n", " ", 
      SuperscriptBox["s", 
       RowBox[{"m", "-", "1"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["r", "2"], "-", 
        RowBox[{
         SuperscriptBox["s", "2"], " ", 
         SuperscriptBox["z", "2"]}]}], ")"}]}]], "+", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"k", "=", "1"}], 
      RowBox[{
       FractionBox["n", "2"], "-", "1"}]], 
     FractionBox[
      RowBox[{"2", " ", 
       SuperscriptBox["r", 
        RowBox[{"m", "+", "1"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"r", " ", 
          RowBox[{"Cos", "[", 
           FractionBox[
            RowBox[{"2", " ", "k", " ", "m", " ", "\[Pi]"}], "n"], "]"}]}], 
         "-", 
         RowBox[{"s", " ", 
          RowBox[{"Cos", "[", 
           FractionBox[
            RowBox[{"2", " ", "k", " ", 
             RowBox[{"(", 
              RowBox[{"m", "+", "1"}], ")"}], " ", "\[Pi]"}], "n"], "]"}], 
          " ", "z"}]}], ")"}]}], 
      RowBox[{"a", " ", "n", " ", 
       SuperscriptBox["s", "m"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["r", "2"], "-", 
         RowBox[{"2", " ", "r", " ", "s", " ", 
          RowBox[{"Cos", "[", 
           FractionBox[
            RowBox[{"2", " ", "k", " ", "\[Pi]"}], "n"], "]"}], " ", "z"}], 
         "+", 
         RowBox[{
          SuperscriptBox["s", "2"], " ", 
          SuperscriptBox["z", "2"]}]}], ")"}]}]]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
   3.4964427205723457`*^9, 3.496442726484756*^9}, {3.4964511572548466`*^9, 
   3.496451196884902*^9}, {3.4964647496374955`*^9, 3.4964647593420506`*^9}, {
   3.4964648485541534`*^9, 3.496464850611271*^9}, {3.49646510358774*^9, 
   3.49646514904034*^9}, {3.496465388706048*^9, 3.4964653947943964`*^9}, {
   3.4964654272642536`*^9, 3.496465506310775*^9}, 3.496465635184146*^9, {
   3.496465683603915*^9, 3.4964656938304996`*^9}, {3.4964661605171933`*^9, 
   3.4964661725558815`*^9}, {3.4964662031186295`*^9, 3.496466318316219*^9}, 
   3.49646637288834*^9, {3.4964666554985046`*^9, 3.496466712977792*^9}, {
   3.4964668475174875`*^9, 3.4964668531178074`*^9}, {3.4964669199346294`*^9, 
   3.4964669734406896`*^9}, 3.496467328943023*^9, {3.496467618375578*^9, 
   3.4964676253709784`*^9}, {3.4964677807798667`*^9, 3.496467788602314*^9}, {
   3.496467898612606*^9, 3.496467977559122*^9}, {3.496468036723506*^9, 
   3.49646804064073*^9}, {3.496468137265257*^9, 3.4964682293865256`*^9}, {
   3.496468813145915*^9, 3.496468813864956*^9}, {3.496514571962569*^9, 
   3.4965146071126184`*^9}, {3.4965146384626627`*^9, 
   3.4965146419226675`*^9}, {3.496514674612713*^9, 3.496514696162743*^9}, {
   3.4965147692828455`*^9, 3.4965148093429017`*^9}, {3.4965151889334335`*^9, 
   3.496515190463435*^9}, 3.4965153172936125`*^9, 3.496515468783825*^9, {
   3.4965161241547422`*^9, 3.496516150454779*^9}, {3.496516353175063*^9, 
   3.4965163555850663`*^9}, {3.496516389655114*^9, 3.49651640108513*^9}, 
   3.4965169255958643`*^9, {3.496517024356003*^9, 3.49651706516606*^9}, 
   3.496517134726157*^9, {3.4965173408564463`*^9, 3.496517358636471*^9}, {
   3.496517391676517*^9, 3.4965173929765186`*^9}, {3.496517485426648*^9, 
   3.4965175799167805`*^9}, {3.496518080807482*^9, 3.4965181215875387`*^9}}],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "m"]}]}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", 
       RowBox[{"2", "m"}]]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.496521708137803*^9, {
   3.4965218981240697`*^9, 3.49652189838407*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.4965217751638975`*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   FractionBox["r", "s"], "=", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["a", "b"], ")"}], 
    RowBox[{"1", "/", "4"}]]}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["z", "m"]}]}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["z", 
       RowBox[{"2", "m"}]]}]}]], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"r", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SqrtBox["2"], " ", "c", " ", "r", " ", "s"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"c", " ", 
            SuperscriptBox["s", "2"]}], "-", 
           RowBox[{"d", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], " ", 
         SuperscriptBox["z", 
          RowBox[{"m", "/", "2"}]]}]}], ")"}]}], 
     RowBox[{"2", " ", 
      SqrtBox["2"], " ", "a", " ", "s", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["r", "2"], "+", 
        RowBox[{
         SqrtBox["2"], " ", "r", " ", "s", " ", 
         SuperscriptBox["z", 
          RowBox[{"m", "/", "2"}]]}], "+", 
        RowBox[{
         SuperscriptBox["s", "2"], " ", 
         SuperscriptBox["z", "m"]}]}], ")"}]}]], "+", 
    FractionBox[
     RowBox[{"r", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SqrtBox["2"], " ", "c", " ", "r", " ", "s"}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"c", " ", 
            SuperscriptBox["s", "2"]}], "-", 
           RowBox[{"d", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], " ", 
         SuperscriptBox["z", 
          RowBox[{"m", "/", "2"}]]}]}], ")"}]}], 
     RowBox[{"2", " ", 
      SqrtBox["2"], " ", "a", " ", "s", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["r", "2"], "-", 
        RowBox[{
         SqrtBox["2"], " ", "r", " ", "s", " ", 
         SuperscriptBox["z", 
          RowBox[{"m", "/", "2"}]]}], "+", 
        RowBox[{
         SuperscriptBox["s", "2"], " ", 
         SuperscriptBox["z", "m"]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
  3.4964427205723457`*^9, 3.496442726484756*^9}, {3.4964511572548466`*^9, 
  3.496451196884902*^9}, {3.4965222400373573`*^9, 3.4965223544427185`*^9}, {
  3.4965225125049477`*^9, 3.4965225164649534`*^9}, {3.4966143444557953`*^9, 
  3.4966143489658017`*^9}, {3.4966143986158714`*^9, 3.4966143986158714`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    FractionBox["m", "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
   "\[And]", " ", 
   RowBox[{"m", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{
    FractionBox["a", "b"], ">", "0"}]}]]],
 ", let ",
 Cell[BoxData[
  RowBox[{
   FractionBox["r", "s"], "=", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["a", "b"], ")"}], 
    RowBox[{"1", "/", "4"}]]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496522165147252*^9, 3.4965222156073227`*^9}, {3.4966148793165445`*^9, 
   3.496614882766549*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "m"]}]}], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", "m"}]]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["r", 
       RowBox[{"2", " ", 
        SqrtBox["2"], " ", "a", " ", "s"}]]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{
         SqrtBox["2"], " ", "c", " ", "r", " ", "s"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"c", " ", 
            SuperscriptBox["s", "2"]}], "-", 
           RowBox[{"d", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], " ", 
         SuperscriptBox["x", 
          RowBox[{"m", "/", "2"}]]}]}], 
       RowBox[{
        SuperscriptBox["r", "2"], "+", 
        RowBox[{
         SqrtBox["2"], " ", "r", " ", "s", " ", 
         SuperscriptBox["x", 
          RowBox[{"m", "/", "2"}]]}], "+", 
        RowBox[{
         SuperscriptBox["s", "2"], " ", 
         SuperscriptBox["x", "m"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["r", 
    RowBox[{"2", " ", 
     SqrtBox["2"], " ", "a", " ", "s"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{
        SqrtBox["2"], " ", "c", " ", "r", " ", "s"}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"c", " ", 
           SuperscriptBox["s", "2"]}], "-", 
          RowBox[{"d", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], " ", 
        SuperscriptBox["x", 
         RowBox[{"m", "/", "2"}]]}]}], 
      RowBox[{
       SuperscriptBox["r", "2"], "-", 
       RowBox[{
        SqrtBox["2"], " ", "r", " ", "s", " ", 
        SuperscriptBox["x", 
         RowBox[{"m", "/", "2"}]]}], "+", 
       RowBox[{
        SuperscriptBox["s", "2"], " ", 
        SuperscriptBox["x", "m"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, 3.496521754163868*^9, 3.496521905004079*^9, 
   3.4965220047578273`*^9, {3.4966144144158936`*^9, 3.496614489845999*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"c_.", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"x_", "^", "m_"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ",
   ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", "=", 
        RowBox[{"Numerator", "[", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{"a", "/", "b"}], ",", "4"}], "]"}], "]"}]}], ",", " ", 
       RowBox[{"s", "=", 
        RowBox[{"Denominator", "[", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{"a", "/", "b"}], ",", "4"}], "]"}], "]"}]}]}], "}"}], ",", 
     "\n", "  ", 
     RowBox[{
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"r", "/", 
         RowBox[{"(", 
          RowBox[{"2", "*", 
           RowBox[{"Sqrt", "[", "2", "]"}], "*", "a", "*", "s"}], ")"}]}], 
        ",", "\n", "    ", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"Sqrt", "[", "2", "]"}], "*", "c", "*", "r", "*", "s"}],
              "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"c", "*", 
                 RowBox[{"s", "^", "2"}]}], "-", 
                RowBox[{"d", "*", 
                 RowBox[{"r", "^", "2"}]}]}], ")"}], "*", 
              RowBox[{"x", "^", 
               RowBox[{"(", 
                RowBox[{"m", "/", "2"}], ")"}]}]}]}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"r", "^", "2"}], "+", 
             RowBox[{
              RowBox[{"Sqrt", "[", "2", "]"}], "*", "r", "*", "s", "*", 
              RowBox[{"x", "^", 
               RowBox[{"(", 
                RowBox[{"m", "/", "2"}], ")"}]}]}], "+", 
             RowBox[{
              RowBox[{"s", "^", "2"}], "*", 
              RowBox[{"x", "^", "m"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
       "]"}], " ", "+", "\n", "  ", 
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"r", "/", 
         RowBox[{"(", 
          RowBox[{"2", "*", 
           RowBox[{"Sqrt", "[", "2", "]"}], "*", "a", "*", "s"}], ")"}]}], 
        ",", "\n", "    ", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"Sqrt", "[", "2", "]"}], "*", "c", "*", "r", "*", "s"}],
              "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"c", "*", 
                 RowBox[{"s", "^", "2"}]}], "-", 
                RowBox[{"d", "*", 
                 RowBox[{"r", "^", "2"}]}]}], ")"}], "*", 
              RowBox[{"x", "^", 
               RowBox[{"(", 
                RowBox[{"m", "/", "2"}], ")"}]}]}]}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"r", "^", "2"}], "-", 
             RowBox[{
              RowBox[{"Sqrt", "[", "2", "]"}], "*", "r", "*", "s", "*", 
              RowBox[{"x", "^", 
               RowBox[{"(", 
                RowBox[{"m", "/", "2"}], ")"}]}]}], "+", 
             RowBox[{
              RowBox[{"s", "^", "2"}], "*", 
              RowBox[{"x", "^", "m"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
       "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"m", "/", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"n", "-", 
      RowBox[{"2", "*", "m"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"PosQ", "[", 
     RowBox[{"a", "/", "b"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965217351278405`*^9, {3.496521928168912*^9, 3.4965219518489447`*^9}, {
   3.496614562936101*^9, 3.496614648386221*^9}, {3.496949619763339*^9, 
   3.4969496257033477`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.4965217839339094`*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   FractionBox["r", "s"], "=", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", 
      FractionBox["a", "b"]}], ")"}], 
    RowBox[{"1", "/", "2"}]]}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["z", "m"]}]}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["z", 
       RowBox[{"2", "m"}]]}]}]], "=", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"c", " ", "s"}], "+", 
      RowBox[{"d", " ", "r"}]}], 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "s"}], "+", 
        RowBox[{"b", " ", "r", " ", 
         SuperscriptBox["z", "m"]}]}], ")"}]}]], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"c", " ", "s"}], "-", 
      RowBox[{"d", " ", "r"}]}], 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "s"}], "-", 
        RowBox[{"b", " ", "r", " ", 
         SuperscriptBox["z", "m"]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
   3.4964427205723457`*^9, 3.496442726484756*^9}, {3.4964511572548466`*^9, 
   3.496451196884902*^9}, {3.4965222400373573`*^9, 3.4965223544427185`*^9}, 
   3.4965224925349197`*^9, {3.4965225245649643`*^9, 3.496522568575026*^9}, 
   3.496522627835109*^9, {3.496614827066471*^9, 3.4966148355264826`*^9}, {
   3.496615014966734*^9, 3.496615022026744*^9}, {3.4966151190768795`*^9, 
   3.4966151214968834`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    FractionBox["m", "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
   "\[And]", " ", 
   RowBox[{"m", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{
      FractionBox["a", "b"], ">", "0"}], ")"}]}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"b", " ", 
      SuperscriptBox["c", "2"]}], "+", 
     RowBox[{"a", " ", 
      SuperscriptBox["d", "2"]}]}], "\[NotEqual]", "0"}]}]]],
 ", let ",
 Cell[BoxData[
  RowBox[{
   FractionBox["r", "s"], "=", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", 
      FractionBox["a", "b"]}], ")"}], 
    RowBox[{"1", "/", "2"}]]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496522165147252*^9, 3.4965222156073227`*^9}, {3.496522723415243*^9, 
   3.496522765635302*^9}, {3.4966149176365976`*^9, 3.496614929286614*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "m"]}]}], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", "m"}]]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        RowBox[{"c", " ", "s"}], "+", 
        RowBox[{"d", " ", "r"}]}], "2"]}]}], " ", 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox["1", 
       RowBox[{
        RowBox[{"a", " ", "s"}], "+", 
        RowBox[{"b", " ", "r", " ", 
         SuperscriptBox["x", "m"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"c", " ", "s"}], "-", 
     RowBox[{"d", " ", "r"}]}], "2"], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{
       RowBox[{"a", " ", "s"}], "-", 
       RowBox[{"b", " ", "r", " ", 
        SuperscriptBox["x", "m"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, 3.496521757483873*^9, 3.4965219078240833`*^9, 
   3.4965221166879835`*^9, 3.496614999716713*^9, {3.496615115676875*^9, 
   3.4966151429369135`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"c_.", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"x_", "^", "m_"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ",
   ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", "=", 
        RowBox[{"Numerator", "[", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "a"}], "/", "b"}], ",", "2"}], "]"}], "]"}]}], ",", 
       " ", 
       RowBox[{"s", "=", 
        RowBox[{"Denominator", "[", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "a"}], "/", "b"}], ",", "2"}], "]"}], "]"}]}]}], 
      "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"c", "*", "s"}], "+", 
           RowBox[{"d", "*", "r"}]}], ")"}], "/", "2"}], ",", " ", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{"1", "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"a", "*", "s"}], "+", 
             RowBox[{"b", "*", "r", "*", 
              RowBox[{"x", "^", "m"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
       "]"}], " ", "+", "\n", "  ", 
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"c", "*", "s"}], "-", 
           RowBox[{"d", "*", "r"}]}], ")"}], "/", "2"}], ",", " ", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{"1", "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"a", "*", "s"}], "-", 
             RowBox[{"b", "*", "r", "*", 
              RowBox[{"x", "^", "m"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
       "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"m", "/", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"n", "-", 
      RowBox[{"2", "*", "m"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NegQ", "[", 
     RowBox[{"a", "/", "b"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", 
       RowBox[{"c", "^", "2"}]}], "+", 
      RowBox[{"a", "*", 
       RowBox[{"d", "^", "2"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.4965217417978497`*^9, {
   3.496521941868931*^9, 3.496521957218952*^9}, {3.4966149475966396`*^9, 
   3.496614956406652*^9}, {3.4966152005269938`*^9, 3.4966152217870235`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.496521708137803*^9, {
   3.4965218981240697`*^9, 3.49652189838407*^9}, 3.4965229070755*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Reference: G&R 2.110.2, CRC 88d special case when ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"n", " ", 
     RowBox[{"(", 
      RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.4965217751638975`*^9, {3.4965229996756296`*^9, 3.496523039305685*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"n", 
     RowBox[{"(", 
      RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496522165147252*^9, 3.4965222156073227`*^9}, {3.496522954055566*^9, 
   3.496522961435576*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"x", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", "n"]}]}], ")"}], 
        RowBox[{"p", "+", "1"}]]}], "a"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, 3.496521754163868*^9, 3.496521905004079*^9, 
   3.4965220047578273`*^9, {3.4965229323055353`*^9, 3.4965229444355526`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_"}]}]}], ")"}], "^", "p_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"x", "*", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"x", "^", "n"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}], "/", "a"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "n", ",", "p"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"n", "*", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965217351278405`*^9, {3.496521928168912*^9, 3.4965219518489447`*^9}, {
   3.496522894915483*^9, 3.4965229201955185`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.110.2, CRC 88d", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.4965217839339094`*^9, 3.496523066875724*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.4965217839339094`*^9, {3.496523066875724*^9, 3.4965230834557467`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], ")"}], "p"], "=", 
   RowBox[{
    SuperscriptBox["x", 
     RowBox[{
      RowBox[{"n", " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}]], 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}], "p"], 
     SuperscriptBox["x", 
      RowBox[{
       RowBox[{"n", " ", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}]]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
   3.4964427205723457`*^9, 3.496442726484756*^9}, {3.4964511572548466`*^9, 
   3.496451196884902*^9}, {3.4965222400373573`*^9, 3.4965223544427185`*^9}, 
   3.4965224925349197`*^9, {3.4965225245649643`*^9, 3.496522568575026*^9}, 
   3.496522627835109*^9, {3.496523118615796*^9, 3.496523130345813*^9}, 
   3.496523684996589*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "n"]}]}], ")"}], "p"], 
      SuperscriptBox["x", 
       RowBox[{
        RowBox[{"n", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], "=", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}], 
      RowBox[{"p", "+", "1"}]], 
     RowBox[{
      SuperscriptBox["x", 
       RowBox[{"n", " ", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}]], "a", " ", "n", " ", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
   3.4964427205723457`*^9, 3.496442726484756*^9}, {3.4964511572548466`*^9, 
   3.496451196884902*^9}, {3.4965222400373573`*^9, 3.4965223544427185`*^9}, 
   3.4965224925349197`*^9, {3.4965225245649643`*^9, 3.496522568575026*^9}, 
   3.496522627835109*^9, {3.496523118615796*^9, 3.496523130345813*^9}, {
   3.4965233296360917`*^9, 3.4965233614361362`*^9}}],

Cell[TextData[{
 "Note: Requirement that ",
 Cell[BoxData[
  RowBox[{"n", ">", "1"}]]],
 " ensures new term is a proper fraction."
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.4965217839339094`*^9, {3.496523066875724*^9, 3.4965230834557467`*^9}, {
   3.4965232517259827`*^9, 3.496523255755988*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", ",", 
   RowBox[{
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", ">", "1"}], " ", "\[And]", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496522165147252*^9, 3.4965222156073227`*^9}, {3.496522723415243*^9, 
   3.496522765635302*^9}, {3.496523221825941*^9, 3.4965232354159594`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"x", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox["x", "n"]}]}], ")"}], 
          RowBox[{"p", "+", "1"}]]}], 
        RowBox[{"a", " ", "n", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"n", " ", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], 
    RowBox[{"a", " ", "n", " ", 
     RowBox[{"(", 
      RowBox[{"p", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}], 
      RowBox[{"p", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, 3.496521757483873*^9, 3.4965219078240833`*^9, 
   3.4965221166879835`*^9, {3.496523166085863*^9, 3.496523193195901*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_"}]}]}], ")"}], "^", "p_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "x"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "n", "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"n", "*", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", "n", "*", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "^", "n"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"n", ",", "p"}], "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.4965217417978497`*^9, {
   3.496521941868931*^9, 3.496521957218952*^9}, 3.496522897045486*^9, 
   3.4965230531057043`*^9, 3.496523170075868*^9, {3.517191216107218*^9, 
   3.517191218416022*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.496521708137803*^9, {
   3.4965218981240697`*^9, 3.49652189838407*^9}, 3.4965229070755*^9, 
   3.4965234353062396`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Reference: G&R 2.110.6, CRC 88c special case when ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "+", 
    RowBox[{"n", " ", 
     RowBox[{"(", 
      RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.4965217751638975`*^9, {3.4965229996756296`*^9, 3.496523039305685*^9}, 
   3.4965234596762733`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "+", 
    RowBox[{"n", 
     RowBox[{"(", 
      RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{"p", "\[NotEqual]", 
     RowBox[{"-", "2"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496522165147252*^9, 3.4965222156073227`*^9}, {3.496522954055566*^9, 
   3.496522961435576*^9}, {3.4965235043463364`*^9, 3.496523542226389*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"m", "+", "1"}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", "n"]}]}], ")"}], 
        RowBox[{"p", "+", "1"}]]}], 
      RowBox[{"a", " ", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, 3.496521754163868*^9, 3.496521905004079*^9, 
   3.4965220047578273`*^9, {3.4965229323055353`*^9, 3.4965229444355526`*^9}, {
   3.4965234815163045`*^9, 3.4965234935663214`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_"}]}]}], ")"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}], "*", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"x", "^", "n"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"a", "*", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m", ",", "n", ",", "p"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"n", "*", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"p", "+", "2"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965217351278405`*^9, {3.496521928168912*^9, 3.4965219518489447`*^9}, {
   3.496522894915483*^9, 3.4965229201955185`*^9}, 3.4965234393662453`*^9, 
   3.4965234722962914`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.110.4", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.4965217839339094`*^9, 3.496523066875724*^9, 3.4965235738264337`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.4965217839339094`*^9, {3.496523066875724*^9, 3.4965230834557467`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], "p"]}], "=", 
   RowBox[{
    SuperscriptBox["x", 
     RowBox[{"m", "-", "n", "+", "1"}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], "p"], " ", 
    SuperscriptBox["x", 
     RowBox[{"n", "-", "1"}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
   3.4964427205723457`*^9, 3.496442726484756*^9}, {3.4964511572548466`*^9, 
   3.496451196884902*^9}, {3.4965222400373573`*^9, 3.4965223544427185`*^9}, 
   3.4965224925349197`*^9, {3.4965225245649643`*^9, 3.496522568575026*^9}, 
   3.496522627835109*^9, {3.496523118615796*^9, 3.496523130345813*^9}, {
   3.496523637746523*^9, 3.4965236407365274`*^9}, {3.4965240311770735`*^9, 
   3.496524059527114*^9}, 3.4965240924271593`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}], "p"], " ", 
     SuperscriptBox["x", 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], "=", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], 
     RowBox[{"p", "+", "1"}]], 
    RowBox[{"b", " ", "n", " ", 
     RowBox[{"(", 
      RowBox[{"p", "+", "1"}], ")"}]}]]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
   3.4964427205723457`*^9, 3.496442726484756*^9}, {3.4964511572548466`*^9, 
   3.496451196884902*^9}, {3.4965222400373573`*^9, 3.4965223544427185`*^9}, 
   3.4965224925349197`*^9, {3.4965225245649643`*^9, 3.496522568575026*^9}, 
   3.496522627835109*^9, {3.496523118615796*^9, 3.496523130345813*^9}, {
   3.4965233296360917`*^9, 3.4965233614361362`*^9}, 3.496523993837022*^9}],

Cell[TextData[{
 "Note: Requirement that ",
 Cell[BoxData[
  RowBox[{"m", "<", 
   RowBox[{
    RowBox[{"2", " ", "n"}], "-", "1"}]}]]],
 " ensures new term is a proper fraction."
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.4965217839339094`*^9, {3.496523066875724*^9, 3.4965230834557467`*^9}, {
   3.4965232517259827`*^9, 3.496523255755988*^9}, {3.496523946326955*^9, 
   3.4965239515269623`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", "n", ",", 
   RowBox[{
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"1", "<", "n", "\[LessEqual]", "m", "<", 
     RowBox[{
      RowBox[{"2", "n"}], "-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496522165147252*^9, 3.4965222156073227`*^9}, {3.496522723415243*^9, 
   3.496522765635302*^9}, {3.496523221825941*^9, 3.4965232354159594`*^9}, {
   3.496523793466741*^9, 3.4965238105867653`*^9}, {3.496523849186819*^9, 
   3.496523869436847*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "-", "n", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}]}], ")"}], 
         RowBox[{"p", "+", "1"}]]}], 
       RowBox[{"b", " ", "n", " ", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"m", "-", "n", "+", "1"}], 
    RowBox[{"b", " ", "n", " ", 
     RowBox[{"(", 
      RowBox[{"p", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "n"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}], 
      RowBox[{"p", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, 3.496521757483873*^9, 3.4965219078240833`*^9, 
   3.4965221166879835`*^9, {3.496523166085863*^9, 3.496523193195901*^9}, 
   3.496523589126455*^9, 3.4965237789667206`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_"}]}]}], ")"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "n", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "n", "+", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", "n", "*", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "n"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n", ",", "p"}], "]"}], " ", "&&", " ", 
    RowBox[{"1", "<", "n", "<=", "m", "<", 
     RowBox[{
      RowBox[{"2", "*", "n"}], "-", "1"}]}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.4965217417978497`*^9, {
   3.496521941868931*^9, 3.496521957218952*^9}, 3.496522897045486*^9, 
   3.4965230531057043`*^9, 3.496523170075868*^9, 3.4965234419962487`*^9, 
   3.496523568406426*^9, 3.496523756546689*^9, {3.4965238353267994`*^9, 
   3.496523841336808*^9}, {3.4965238744768543`*^9, 3.496523876456857*^9}, 
   3.5171910350533*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.110.2, CRC 88d", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.4965217839339094`*^9, 3.496523066875724*^9, 3.4965235738264337`*^9, 
   3.4965243166874733`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.4965217839339094`*^9, {3.496523066875724*^9, 3.4965230834557467`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], "p"]}], "=", 
   RowBox[{
    SuperscriptBox["x", 
     RowBox[{"m", "+", 
      RowBox[{"n", " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}]], 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}], "p"], 
     SuperscriptBox["x", 
      RowBox[{
       RowBox[{"n", " ", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}]]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
   3.4964427205723457`*^9, 3.496442726484756*^9}, {3.4964511572548466`*^9, 
   3.496451196884902*^9}, {3.4965222400373573`*^9, 3.4965223544427185`*^9}, 
   3.4965224925349197`*^9, {3.4965225245649643`*^9, 3.496522568575026*^9}, 
   3.496522627835109*^9, {3.496523118615796*^9, 3.496523130345813*^9}, {
   3.496523637746523*^9, 3.4965236407365274`*^9}, {3.4965240311770735`*^9, 
   3.496524059527114*^9}, 3.4965240924271593`*^9, {3.4965243499675198`*^9, 
   3.4965243640875397`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "n"]}]}], ")"}], "p"], 
      SuperscriptBox["x", 
       RowBox[{
        RowBox[{"n", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], "=", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}], 
      RowBox[{"p", "+", "1"}]], 
     RowBox[{
      SuperscriptBox["x", 
       RowBox[{"n", " ", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}]], "a", " ", "n", " ", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
   3.4964427205723457`*^9, 3.496442726484756*^9}, {3.4964511572548466`*^9, 
   3.496451196884902*^9}, {3.4965222400373573`*^9, 3.4965223544427185`*^9}, 
   3.4965224925349197`*^9, {3.4965225245649643`*^9, 3.496522568575026*^9}, 
   3.496522627835109*^9, {3.496523118615796*^9, 3.496523130345813*^9}, {
   3.4965233296360917`*^9, 3.4965233614361362`*^9}, 3.496523993837022*^9, {
   3.496524402877594*^9, 3.4965244515976624`*^9}}],

Cell[TextData[{
 "Note: Requirement that ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "+", "1"}], "<", "n"}]]],
 " ensures new term is a proper fraction."
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.4965217839339094`*^9, {3.496523066875724*^9, 3.4965230834557467`*^9}, {
   3.4965232517259827`*^9, 3.496523255755988*^9}, {3.496523946326955*^9, 
   3.4965239515269623`*^9}, {3.49652446425768*^9, 3.4965244692176867`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", "n", ",", 
   RowBox[{
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", ">", "1"}], " ", "\[And]", " ", 
    RowBox[{"0", "<", 
     RowBox[{"m", "+", "1"}], "<", "n"}], " ", "\[And]", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "+", 
      RowBox[{"n", " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], "\[NotEqual]", 
     "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496522165147252*^9, 3.4965222156073227`*^9}, {3.496522723415243*^9, 
   3.496522765635302*^9}, {3.496523221825941*^9, 3.4965232354159594`*^9}, {
   3.496523793466741*^9, 3.4965238105867653`*^9}, {3.496523849186819*^9, 
   3.496523869436847*^9}, {3.496524240927367*^9, 3.4965242872774324`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox["x", 
          RowBox[{"m", "+", "1"}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox["x", "n"]}]}], ")"}], 
          RowBox[{"p", "+", "1"}]]}], 
        RowBox[{"a", " ", "n", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"m", "+", 
     RowBox[{"n", " ", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], 
    RowBox[{"a", " ", "n", " ", 
     RowBox[{"(", 
      RowBox[{"p", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}], 
      RowBox[{"p", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, 3.496521757483873*^9, 3.4965219078240833`*^9, 
   3.4965221166879835`*^9, {3.496523166085863*^9, 3.496523193195901*^9}, 
   3.496523589126455*^9, 3.4965237789667206`*^9, 3.4965241874472923`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_"}]}]}], ")"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "n", "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", 
         RowBox[{"n", "*", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", "n", "*", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n", ",", "p"}], "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}], " ", "&&", " ", 
    RowBox[{"0", "<", 
     RowBox[{"m", "+", "1"}], "<", "n"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"n", "*", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.4965217417978497`*^9, {
   3.496521941868931*^9, 3.496521957218952*^9}, 3.496522897045486*^9, 
   3.4965230531057043`*^9, 3.496523170075868*^9, 3.4965234419962487`*^9, 
   3.496523568406426*^9, 3.496523756546689*^9, {3.4965238353267994`*^9, 
   3.496523841336808*^9}, {3.4965238744768543`*^9, 3.496523876456857*^9}, {
   3.4965241632672586`*^9, 3.496524165447262*^9}, {3.496524224667345*^9, 
   3.4965242301673527`*^9}, 3.5171910350533*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.110.6, CRC 88c", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.4965217839339094`*^9, 3.496523066875724*^9, 3.4965235738264337`*^9, 
   3.4965243166874733`*^9, 3.4965247159180326`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.4965217839339094`*^9, {3.496523066875724*^9, 3.4965230834557467`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], "p"]}], "=", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "m"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}], 
      FractionBox[
       RowBox[{"m", "+", "n", "+", "1"}], "n"]]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], 
     FractionBox[
      RowBox[{"m", "+", 
       RowBox[{"n", " ", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], "n"]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
   3.4964427205723457`*^9, 3.496442726484756*^9}, {3.4964511572548466`*^9, 
   3.496451196884902*^9}, {3.4965222400373573`*^9, 3.4965223544427185`*^9}, 
   3.4965224925349197`*^9, {3.4965225245649643`*^9, 3.496522568575026*^9}, 
   3.496522627835109*^9, {3.496523118615796*^9, 3.496523130345813*^9}, {
   3.496523637746523*^9, 3.4965236407365274`*^9}, {3.4965240311770735`*^9, 
   3.496524059527114*^9}, 3.4965240924271593`*^9, {3.4965243499675198`*^9, 
   3.4965243640875397`*^9}, {3.496524748568078*^9, 3.496524769168107*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox["x", "m"], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "n"]}]}], ")"}], 
       FractionBox[
        RowBox[{"m", "+", "n", "+", "1"}], "n"]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], "=", 
   FractionBox[
    SuperscriptBox["x", 
     RowBox[{"m", "+", "1"}]], 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}], 
      FractionBox[
       RowBox[{"m", "+", "1"}], "n"]], " ", 
     RowBox[{"(", 
      RowBox[{"a", " ", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
   3.4964427205723457`*^9, 3.496442726484756*^9}, {3.4964511572548466`*^9, 
   3.496451196884902*^9}, {3.4965222400373573`*^9, 3.4965223544427185`*^9}, 
   3.4965224925349197`*^9, {3.4965225245649643`*^9, 3.496522568575026*^9}, 
   3.496522627835109*^9, {3.496523118615796*^9, 3.496523130345813*^9}, {
   3.4965233296360917`*^9, 3.4965233614361362`*^9}, 3.496523993837022*^9, {
   3.496524402877594*^9, 3.4965244515976624`*^9}, {3.496524807778161*^9, 
   3.4965248242081842`*^9}}],

Cell[TextData[{
 "Note: Requirement that ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "+", "1"}], "<", "n"}]]],
 " ensures new term is a proper fraction."
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.4965217839339094`*^9, {3.496523066875724*^9, 3.4965230834557467`*^9}, {
   3.4965232517259827`*^9, 3.496523255755988*^9}, {3.496523946326955*^9, 
   3.4965239515269623`*^9}, {3.49652446425768*^9, 3.4965244692176867`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", "n", ",", "p", ",", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"m", "+", 
       RowBox[{"n", " ", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], "n"], "\[Element]", 
     "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
    RowBox[{"0", "<", 
     RowBox[{"n", "-", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"m", "+", 
         RowBox[{"n", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], ")"}]}]}], "<", 
     RowBox[{"n", " ", "p"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496522165147252*^9, 3.4965222156073227`*^9}, {3.496522723415243*^9, 
   3.496522765635302*^9}, {3.496523221825941*^9, 3.4965232354159594`*^9}, {
   3.496523793466741*^9, 3.4965238105867653`*^9}, {3.496523849186819*^9, 
   3.496523869436847*^9}, {3.496524240927367*^9, 3.4965242872774324`*^9}, {
   3.496524601367872*^9, 3.496524684427988*^9}, {3.496525229068751*^9, 
   3.496525236998762*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}]}], ")"}], 
         RowBox[{"p", "+", "1"}]]}], 
       RowBox[{"a", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"b", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", 
       RowBox[{"n", " ", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], ")"}]}], 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "n"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}], "p"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, 3.496521757483873*^9, 3.4965219078240833`*^9, 
   3.4965221166879835`*^9, {3.496523166085863*^9, 3.496523193195901*^9}, 
   3.496523589126455*^9, 3.4965237789667206`*^9, 3.4965241874472923`*^9, 
   3.496524564957821*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_"}]}]}], ")"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"n", "*", 
           RowBox[{"(", 
            RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"a", "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "n"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], ")"}], "^", "p"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n", ",", "p", ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", 
         RowBox[{"n", "*", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], ")"}], "/", "n"}]}], 
     "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", "\n", 
    RowBox[{"0", "<", 
     RowBox[{"n", "-", 
      RowBox[{"2", 
       RowBox[{"(", 
        RowBox[{"m", "+", 
         RowBox[{"n", "*", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], ")"}]}]}], "<", 
     RowBox[{"n", "*", "p"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.4965217417978497`*^9, {
   3.496521941868931*^9, 3.496521957218952*^9}, 3.496522897045486*^9, 
   3.4965230531057043`*^9, 3.496523170075868*^9, 3.4965234419962487`*^9, 
   3.496523568406426*^9, 3.496523756546689*^9, {3.4965238353267994`*^9, 
   3.496523841336808*^9}, {3.4965238744768543`*^9, 3.496523876456857*^9}, {
   3.4965241632672586`*^9, 3.496524165447262*^9}, {3.496524224667345*^9, 
   3.4965242301673527`*^9}, {3.496524538977785*^9, 3.4965245421177893`*^9}, {
   3.496525206278719*^9, 3.4965252146987305`*^9}, {3.496525246928776*^9, 
   3.496525255068787*^9}, {3.517191220584426*^9, 3.517191223673231*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.110.5, CRC 88a", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.4965217839339094`*^9, 3.496523066875724*^9, 3.4965235738264337`*^9, 
   3.4965243166874733`*^9, 3.4965247159180326`*^9, 3.496524889888276*^9}],

Cell["Derivation: Inverted integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.4965217839339094`*^9, {3.496523066875724*^9, 3.4965230834557467`*^9}, {
   3.4965248960482845`*^9, 3.496524904668297*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", "n", ",", "p", ",", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"m", "+", "1"}], "n"], "\[Element]", 
     "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "+", 
      RowBox[{"n", " ", "p"}], "+", "1"}], "\[NotEqual]", "0"}], " ", 
    "\[And]", " ", 
    RowBox[{
     FractionBox[
      RowBox[{"m", "+", "1"}], "n"], ">", "0"}], " ", "\[And]", " ", 
    RowBox[{
     FractionBox[
      RowBox[{"2", " ", "m"}], "n"], "<", 
     RowBox[{"p", "+", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"0", "<", "n", "\[LessEqual]", "m"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496522165147252*^9, 3.4965222156073227`*^9}, {3.496522723415243*^9, 
   3.496522765635302*^9}, {3.496523221825941*^9, 3.4965232354159594`*^9}, {
   3.496523793466741*^9, 3.4965238105867653`*^9}, {3.496523849186819*^9, 
   3.496523869436847*^9}, {3.496524240927367*^9, 3.4965242872774324`*^9}, {
   3.496524601367872*^9, 3.496524684427988*^9}, {3.496524967108384*^9, 
   3.4965249730483923`*^9}, {3.49652505695851*^9, 3.4965251102785845`*^9}, {
   3.496525144828633*^9, 3.4965251931087008`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "-", "n", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}]}], ")"}], 
         RowBox[{"p", "+", "1"}]]}], 
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"n", " ", "p"}], "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{"m", "-", "n", "+", "1"}], ")"}]}], 
    RowBox[{"b", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", 
       RowBox[{"n", " ", "p"}], "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "n"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}], "p"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, 3.496521757483873*^9, 3.4965219078240833`*^9, 
   3.4965221166879835`*^9, {3.496523166085863*^9, 3.496523193195901*^9}, 
   3.496523589126455*^9, 3.4965237789667206`*^9, 3.4965241874472923`*^9, 
   3.496524564957821*^9, 3.496524939858346*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_"}]}]}], ")"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "n", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"n", "*", "p"}], "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "-", "n", "+", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"b", "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", 
            RowBox[{"n", "*", "p"}], "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "n"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], ")"}], "^", "p"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n", ",", "p", ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "/", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"n", "*", "p"}], "+", "1"}], "]"}], " ", "&&", " ", "\n", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}], "/", "n"}], ">", "0"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"2", "*", 
      RowBox[{"m", "/", "n"}]}], "<", 
     RowBox[{"p", "+", "1"}]}], " ", "&&", " ", 
    RowBox[{"0", "<", "n", "<=", "m"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.4965217417978497`*^9, {
   3.496521941868931*^9, 3.496521957218952*^9}, 3.496522897045486*^9, 
   3.4965230531057043`*^9, 3.496523170075868*^9, 3.4965234419962487`*^9, 
   3.496523568406426*^9, 3.496523756546689*^9, {3.4965238353267994`*^9, 
   3.496523841336808*^9}, {3.4965238744768543`*^9, 3.496523876456857*^9}, {
   3.4965241632672586`*^9, 3.496524165447262*^9}, {3.496524224667345*^9, 
   3.4965242301673527`*^9}, {3.496524538977785*^9, 3.4965245421177893`*^9}, 
   3.496524881328264*^9, 3.4965249211883197`*^9, {3.4965250087384424`*^9, 
   3.4965250451984935`*^9}, {3.49652529985885*^9, 3.4965253029988546`*^9}, {
   3.517191226559236*^9, 3.517191229336041*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.4965217839339094`*^9, {3.496523066875724*^9, 3.4965230834557467`*^9}, {
   3.4965248960482845`*^9, 3.496524904668297*^9}, 3.49652539292898*^9}],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], ")"}], "^", "p_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"x", "^", "m"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"x", "^", "n"}]}]}], ")"}], "^", "p"}]}], "]"}], ",", 
     "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "0"}], " ", "&&", " ", 
    RowBox[{"ExpandIntegrandQ", "[", 
     RowBox[{"m", ",", "n", ",", "p"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.4965217417978497`*^9, {
   3.496521941868931*^9, 3.496521957218952*^9}, 3.496522897045486*^9, 
   3.4965230531057043`*^9, 3.496523170075868*^9, 3.4965234419962487`*^9, 
   3.496523568406426*^9, 3.496523756546689*^9, {3.4965238353267994`*^9, 
   3.496523841336808*^9}, {3.4965238744768543`*^9, 3.496523876456857*^9}, {
   3.4965241632672586`*^9, 3.496524165447262*^9}, {3.496524224667345*^9, 
   3.4965242301673527`*^9}, {3.496524538977785*^9, 3.4965245421177893`*^9}, 
   3.496524881328264*^9, 3.4965249211883197`*^9, {3.4965250087384424`*^9, 
   3.4965250451984935`*^9}, {3.49652529985885*^9, 3.4965253029988546`*^9}, 
   3.4965253394889054`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.110.4", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.4965217839339094`*^9, 3.496523066875724*^9, 3.4965235738264337`*^9, 
   3.4965243166874733`*^9, 3.4965247159180326`*^9, 3.496524889888276*^9, 
   3.4965255760192366`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.4965217839339094`*^9, {3.496523066875724*^9, 3.4965230834557467`*^9}, {
   3.4965248960482845`*^9, 3.496524904668297*^9}, 3.496525580459243*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], "p"]}], "=", 
   RowBox[{
    SuperscriptBox["x", 
     RowBox[{"m", "-", "n", "+", "1"}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], "p"], " ", 
    SuperscriptBox["x", 
     RowBox[{"n", "-", "1"}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
   3.4964427205723457`*^9, 3.496442726484756*^9}, {3.4964511572548466`*^9, 
   3.496451196884902*^9}, {3.4965222400373573`*^9, 3.4965223544427185`*^9}, 
   3.4965224925349197`*^9, {3.4965225245649643`*^9, 3.496522568575026*^9}, 
   3.496522627835109*^9, {3.496523118615796*^9, 3.496523130345813*^9}, {
   3.496523637746523*^9, 3.4965236407365274`*^9}, {3.4965240311770735`*^9, 
   3.496524059527114*^9}, 3.4965240924271593`*^9}],

Cell[TextData[{
 "Note: Requirement that ",
 Cell[BoxData[
  RowBox[{"m", "<", 
   RowBox[{
    RowBox[{"2", " ", "n"}], "-", "1"}]}]]],
 " ensures new term is a proper fraction."
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.4965217839339094`*^9, {3.496523066875724*^9, 3.4965230834557467`*^9}, {
   3.4965248960482845`*^9, 3.496524904668297*^9}, 3.496525580459243*^9, {
   3.496525653709345*^9, 3.4965256589493527`*^9}}],

Cell[TextData[{
 "Note: Unfortunately this rule is necessary to prevent the \
Ostrogradskiy-Hermite method from being applied instead of substituting for ",
 Cell[BoxData[
  RowBox[{"c", "+", 
   RowBox[{"d", " ", "x"}]}]]],
 "."
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.4965217839339094`*^9, {3.496523066875724*^9, 3.4965230834557467`*^9}, {
   3.4965248960482845`*^9, 3.496524904668297*^9}, 3.496525580459243*^9, {
   3.496525653709345*^9, 3.496525680379383*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", "n", ",", 
   RowBox[{
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", ">", "1"}], " ", "\[And]", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"n", "\[LessEqual]", "m", "<", 
     RowBox[{
      RowBox[{"2", "n"}], "-", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496522165147252*^9, 3.4965222156073227`*^9}, {3.496522723415243*^9, 
   3.496522765635302*^9}, {3.496523221825941*^9, 3.4965232354159594`*^9}, {
   3.496523793466741*^9, 3.4965238105867653`*^9}, {3.496523849186819*^9, 
   3.496523869436847*^9}, {3.496524240927367*^9, 3.4965242872774324`*^9}, {
   3.496524601367872*^9, 3.496524684427988*^9}, {3.496524967108384*^9, 
   3.4965249730483923`*^9}, {3.49652505695851*^9, 3.4965251102785845`*^9}, {
   3.496525144828633*^9, 3.4965251931087008`*^9}, {3.4965255331391764`*^9, 
   3.4965255569692097`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], ")"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], ")"}], "n"]}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                     ", "\[IndentingNewLine]", "                ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], ")"}], 
         RowBox[{"m", "-", "n", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], ")"}], "n"]}]}], ")"}], 
         RowBox[{"p", "+", "1"}]]}], 
       RowBox[{"b", " ", "d", " ", "n", " ", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"m", "-", "n", "+", "1"}], 
    RowBox[{"b", " ", "n", " ", 
     RowBox[{"(", 
      RowBox[{"p", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}], 
      RowBox[{"m", "-", "n"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], ")"}], "n"]}]}], ")"}], 
      RowBox[{"p", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, 3.496521757483873*^9, 3.4965219078240833`*^9, 
   3.4965221166879835`*^9, {3.496523166085863*^9, 3.496523193195901*^9}, 
   3.496523589126455*^9, 3.4965237789667206`*^9, 3.4965241874472923`*^9, 
   3.496524564957821*^9, 3.496524939858346*^9, 3.496525444269052*^9, 
   3.4965255033991346`*^9, {3.4965257130194283`*^9, 3.4965257266594477`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c_", "+", 
            RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "n_"}]}]}], ")"}], "^", 
      "p_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "n", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], ")"}], "^", "n"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "d", "*", "n", "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "n", "+", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", "n", "*", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "n"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], ")"}], "^", "n"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n", ",", "p"}], "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", "<=", "m", "<", 
     RowBox[{
      RowBox[{"2", "*", "n"}], "-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.4965217417978497`*^9, {
   3.496521941868931*^9, 3.496521957218952*^9}, 3.496522897045486*^9, 
   3.4965230531057043`*^9, 3.496523170075868*^9, 3.4965234419962487`*^9, 
   3.496523568406426*^9, 3.496523756546689*^9, {3.4965238353267994`*^9, 
   3.496523841336808*^9}, {3.4965238744768543`*^9, 3.496523876456857*^9}, {
   3.4965241632672586`*^9, 3.496524165447262*^9}, {3.496524224667345*^9, 
   3.4965242301673527`*^9}, {3.496524538977785*^9, 3.4965245421177893`*^9}, 
   3.496524881328264*^9, 3.4965249211883197`*^9, {3.4965250087384424`*^9, 
   3.4965250451984935`*^9}, {3.49652529985885*^9, 3.4965253029988546`*^9}, {
   3.496525417889015*^9, 3.4965254223490214`*^9}, 3.5171910350688996`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], "m"], 
    RowBox[{"b", "+", 
     FractionBox["a", 
      SuperscriptBox["x", "n"]]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965257872295322`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.4965258054095573`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}]}], 
    RowBox[{"b", "+", 
     FractionBox["a", 
      SuperscriptBox["x", "n"]]}]], "=", 
   SuperscriptBox["x", "n"]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
  3.4964427205723457`*^9, 3.496442726484756*^9}, {3.4964511572548466`*^9, 
  3.496451196884902*^9}, {3.4965258211995797`*^9, 3.4965258286395903`*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496525937619743*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], "m"], 
    RowBox[{"b", "+", 
     FractionBox["a", 
      SuperscriptBox["x", "n"]]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox["x", "n"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", "n"]}]}], ")"}], 
        RowBox[{"m", "-", "1"}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496525857769631*^9, 3.4965258745996547`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], ")"}], "^", "m_"}], "/", 
     RowBox[{"(", 
      RowBox[{"b_", "+", 
       RowBox[{"a_.", "*", 
        RowBox[{"x_", "^", "p_."}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "n"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "-", "1"}], ")"}]}]}], ",", " ", "x"}], "]"}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m", ",", "n", ",", "p"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"n", "+", "p"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965257980895476`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", " ", 
       SuperscriptBox["x", "p"]}], "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "q"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.496521708137803*^9, {
   3.4965218981240697`*^9, 3.49652189838407*^9}, 3.4965229070755*^9, 
   3.4965259876098127`*^9, 3.4965266792607813`*^9, {3.496526936871142*^9, 
   3.4965269509611616`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.4965217751638975`*^9, {3.4965229996756296`*^9, 3.496523039305685*^9}, 
   3.4965260317698746`*^9, 3.4965267111508255`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", 
     SuperscriptBox["z", "p"]}], "+", 
    RowBox[{"b", " ", 
     SuperscriptBox["z", "q"]}]}], "=", 
   RowBox[{
    SuperscriptBox["z", "p"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["z", 
        RowBox[{"q", "-", "p"}]]}]}], ")"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
   3.4964427205723457`*^9, 3.496442726484756*^9}, {3.4964511572548466`*^9, 
   3.496451196884902*^9}, {3.4965222400373573`*^9, 3.4965223544427185`*^9}, 
   3.4965224925349197`*^9, {3.4965225245649643`*^9, 3.496522568575026*^9}, 
   3.496522627835109*^9, {3.496523118615796*^9, 3.496523130345813*^9}, 
   3.496523684996589*^9, {3.4965261008999715`*^9, 3.4965261760600767`*^9}, {
   3.4965267311208534`*^9, 3.4965267396008654`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496522165147252*^9, 3.4965222156073227`*^9}, {3.496522954055566*^9, 
   3.496522961435576*^9}, {3.496526282580226*^9, 3.496526289210235*^9}, 
   3.4965268254809856`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", " ", 
       SuperscriptBox["x", "p"]}], "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "q"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"n", " ", "p"}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", 
            RowBox[{"q", "-", "p"}]]}]}], ")"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, 3.496521754163868*^9, 3.496521905004079*^9, 
   3.4965220047578273`*^9, {3.4965229323055353`*^9, 3.4965229444355526`*^9}, 
   3.49652620710012*^9, {3.496526244980173*^9, 3.4965262625401974`*^9}, {
   3.4965267878709335`*^9, 3.49652680698096*^9}, 3.4965269672711844`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a_.", "*", 
        RowBox[{"x_", "^", "p_."}]}], "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "q_."}]}]}], ")"}], "^", "n_"}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"n", "*", "p"}], ")"}]}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", 
           RowBox[{"(", 
            RowBox[{"q", "-", "p"}], ")"}]}]}]}], ")"}], "^", "n"}]}], ",", 
     "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "p", ",", "q"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"FractionQ", "[", "p", "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"FractionQ", "[", "q", "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"NegativeQ", "[", 
      RowBox[{"q", "-", "p"}], "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965217351278405`*^9, {3.496521928168912*^9, 3.4965219518489447`*^9}, {
   3.496522894915483*^9, 3.4965229201955185`*^9}, 3.496525998979829*^9, 
   3.4965266929808006`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.4965217751638975`*^9, {3.4965229996756296`*^9, 3.496523039305685*^9}, 
   3.4965260317698746`*^9, 3.4965267083408217`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", 
     SuperscriptBox["z", "p"]}], "+", 
    RowBox[{"b", " ", 
     SuperscriptBox["z", "q"]}]}], "=", 
   RowBox[{
    SuperscriptBox["z", "p"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["z", 
        RowBox[{"q", "-", "p"}]]}]}], ")"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
   3.4964427205723457`*^9, 3.496442726484756*^9}, {3.4964511572548466`*^9, 
   3.496451196884902*^9}, {3.4965222400373573`*^9, 3.4965223544427185`*^9}, 
   3.4965224925349197`*^9, {3.4965225245649643`*^9, 3.496522568575026*^9}, 
   3.496522627835109*^9, {3.496523118615796*^9, 3.496523130345813*^9}, 
   3.496523684996589*^9, {3.4965261008999715`*^9, 3.4965261760600767`*^9}, {
   3.4965267311208534`*^9, 3.4965267396008654`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496522165147252*^9, 3.4965222156073227`*^9}, {3.496522954055566*^9, 
   3.496522961435576*^9}, {3.496526282580226*^9, 3.496526289210235*^9}, 
   3.4965268254809856`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", " ", 
       SuperscriptBox["x", "p"]}], "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "q"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"m", "+", 
         RowBox[{"n", " ", "p"}]}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", 
            RowBox[{"q", "-", "p"}]]}]}], ")"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, 3.496521754163868*^9, 3.496521905004079*^9, 
   3.4965220047578273`*^9, {3.4965229323055353`*^9, 3.4965229444355526`*^9}, 
   3.49652620710012*^9, {3.496526244980173*^9, 3.4965262625401974`*^9}, {
   3.4965267878709335`*^9, 3.49652680698096*^9}, {3.4965268753910556`*^9, 
   3.496526898581088*^9}, 3.4965269731011925`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a_.", "*", 
         RowBox[{"x_", "^", "p_."}]}], "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "q_."}]}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", 
         RowBox[{"n", "*", "p"}]}], ")"}]}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", 
           RowBox[{"(", 
            RowBox[{"q", "-", "p"}], ")"}]}]}]}], ")"}], "^", "n"}]}], ",", 
     "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m", ",", "p", ",", "q"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", "\n", 
    RowBox[{"Not", "[", 
     RowBox[{"FractionQ", "[", "p", "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"FractionQ", "[", "q", "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"FractionQ", "[", "m", "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"NegativeQ", "[", 
      RowBox[{"q", "-", "p"}], "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.4965217417978497`*^9, {
   3.496521941868931*^9, 3.496521957218952*^9}, 3.496522897045486*^9, 
   3.4965230531057043`*^9, 3.496523170075868*^9, 3.496526009779844*^9, 
   3.4965267000708103`*^9, 3.4969497921335807`*^9},
 Background->GrayLevel[0.85]]
}, Closed]]
},
AutoGeneratedPackage->Automatic,
CellGrouping->Manual,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  "Integration Rules for Rational Functions of Binomials", None, None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->28.8},
Magnification->1.399999976158142,
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 970, 21, 123, "Title"],
Cell[1540, 45, 262, 4, 130, "Subsubsection"],
Cell[1805, 51, 245, 4, 90, "Subsubsection"],
Cell[2053, 57, 510, 14, 144, "Subsubsection"],
Cell[2566, 73, 940, 18, 130, "Subsubsection"],
Cell[3509, 93, 951, 25, 501, "Subsubtitle"],
Cell[4463, 120, 771, 11, 130, "Subsubsection"],
Cell[5237, 133, 1182, 34, 394, "Code"],
Cell[6422, 169, 89, 2, 130, "Subsubsection"],
Cell[6514, 173, 286, 4, 90, "Subsubsection"],
Cell[6803, 179, 245, 4, 90, "Subsubsection"],
Cell[7051, 185, 534, 14, 144, "Subsubsection"],
Cell[7588, 201, 1041, 20, 145, "Subsubsection"],
Cell[8632, 223, 1049, 28, 501, "Subsubtitle"],
Cell[9684, 253, 771, 11, 130, "Subsubsection"],
Cell[10458, 266, 1310, 37, 394, "Code"],
Cell[11771, 305, 89, 2, 130, "Subsubsection"],
Cell[11863, 309, 295, 4, 90, "Subsubsection"],
Cell[12161, 315, 274, 4, 90, "Subsubsection"],
Cell[12438, 321, 1423, 43, 167, "Subsubsection"],
Cell[13864, 366, 1216, 27, 148, "Subsubsection"],
Cell[15083, 395, 1568, 44, 230, "Subsubtitle"],
Cell[16654, 441, 771, 11, 130, "Subsubsection"],
Cell[17428, 454, 2393, 71, 586, "Code"],
Cell[19824, 527, 89, 2, 130, "Subsubsection"],
Cell[19916, 531, 274, 4, 90, "Subsubsection"],
Cell[20193, 537, 1523, 45, 167, "Subsubsection"],
Cell[21719, 584, 1343, 31, 148, "Subsubsection"],
Cell[23065, 617, 1596, 45, 230, "Subsubtitle"],
Cell[24664, 664, 771, 11, 130, "Subsubsection"],
Cell[25438, 677, 2482, 74, 586, "Code"],
Cell[27923, 753, 89, 2, 130, "Subsubsection"],
Cell[28015, 757, 325, 5, 90, "Subsubsection"],
Cell[28343, 764, 274, 4, 90, "Subsubsection"],
Cell[28620, 770, 2032, 60, 221, "Subsubsection"],
Cell[30655, 832, 1439, 33, 148, "Subsubsection"],
Cell[32097, 867, 2323, 68, 281, "Subsubtitle"],
Cell[34423, 937, 771, 11, 130, "Subsubsection"],
Cell[35197, 950, 3843, 106, 586, "Code"],
Cell[39043, 1058, 89, 2, 181, "Subsubsection"],
Cell[39135, 1062, 347, 5, 125, "Subsubsection"],
Cell[39485, 1069, 274, 4, 125, "Subsubsection"],
Cell[39762, 1075, 1514, 39, 221, "Subsubsection"],
Cell[41279, 1116, 1519, 37, 207, "Subsubsection"],
Cell[42801, 1155, 1574, 43, 321, "Subsubtitle"],
Cell[44378, 1200, 771, 11, 181, "Subsubsection"],
Cell[45152, 1213, 2730, 78, 820, "Code"],
Cell[47885, 1293, 89, 2, 181, "Subsubsection"],
Cell[47977, 1297, 274, 4, 125, "Subsubsection"],
Cell[48254, 1303, 2933, 79, 309, "Subsubsection"],
Cell[51190, 1384, 1564, 35, 207, "Subsubsection"],
Cell[52757, 1421, 2470, 69, 482, "Subsubtitle"],
Cell[55230, 1492, 771, 11, 181, "Subsubsection"],
Cell[56004, 1505, 3861, 104, 956, "Code"],
Cell[59868, 1611, 89, 2, 181, "Subsubsection"],
Cell[59960, 1615, 274, 4, 125, "Subsubsection"],
Cell[60237, 1621, 2827, 73, 309, "Subsubsection"],
Cell[63067, 1696, 1690, 39, 207, "Subsubsection"],
Cell[64760, 1737, 2268, 62, 482, "Subsubtitle"],
Cell[67031, 1801, 771, 11, 130, "Subsubsection"],
Cell[67805, 1814, 3747, 101, 683, "Code"],
Cell[71555, 1917, 89, 2, 130, "Subsubsection"],
Cell[71647, 1921, 274, 4, 90, "Subsubsection"],
Cell[71924, 1927, 2923, 76, 221, "Subsubsection"],
Cell[74850, 2005, 1689, 37, 148, "Subsubsection"],
Cell[76542, 2044, 2573, 64, 345, "Subsubtitle"],
Cell[79118, 2110, 771, 11, 130, "Subsubsection"],
Cell[79892, 2123, 3449, 90, 683, "Code"],
Cell[83344, 2215, 89, 2, 130, "Subsubsection"],
Cell[83436, 2219, 274, 4, 90, "Subsubsection"],
Cell[83713, 2225, 3021, 78, 221, "Subsubsection"],
Cell[86737, 2305, 1812, 40, 148, "Subsubsection"],
Cell[88552, 2347, 2595, 64, 345, "Subsubtitle"],
Cell[91150, 2413, 771, 11, 130, "Subsubsection"],
Cell[91924, 2426, 3540, 93, 683, "Code"],
Cell[95467, 2521, 44, 1, 11, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[95548, 2527, 1024, 23, 88, "Title"],
Cell[96575, 2552, 321, 5, 35, "Subsubsection"],
Cell[96899, 2559, 274, 4, 25, "Subsubsection"],
Cell[97176, 2565, 1582, 46, 47, "Subsubsection"],
Cell[98761, 2613, 1216, 27, 40, "Subsubsection"],
Cell[99980, 2642, 1689, 47, 65, "Subsubtitle"],
Cell[101672, 2691, 771, 11, 35, "Subsubsection"],
Cell[102446, 2704, 2512, 73, 154, "Code"],
Cell[104961, 2779, 89, 2, 35, "Subsubsection"],
Cell[105053, 2783, 274, 4, 25, "Subsubsection"],
Cell[105330, 2789, 1559, 46, 47, "Subsubsection"],
Cell[106892, 2837, 1343, 31, 40, "Subsubsection"],
Cell[108238, 2870, 1689, 46, 65, "Subsubtitle"],
Cell[109930, 2918, 771, 11, 35, "Subsubsection"],
Cell[110704, 2931, 2627, 76, 154, "Code"],
Cell[113334, 3009, 89, 2, 35, "Subsubsection"],
Cell[113426, 3013, 303, 4, 25, "Subsubsection"],
Cell[113732, 3019, 1473, 33, 96, "Subsubsection"],
Cell[115208, 3054, 1524, 38, 309, "Subsubtitle"],
Cell[116735, 3094, 771, 11, 130, "Subsubsection"],
Cell[117509, 3107, 2216, 60, 586, "Code"],
Cell[119728, 3169, 89, 2, 130, "Subsubsection"],
Cell[119820, 3173, 324, 5, 90, "Subsubsection"],
Cell[120147, 3180, 321, 5, 90, "Subsubsection"],
Cell[120471, 3187, 1969, 55, 194, "Subsubsection"],
Cell[122443, 3244, 1487, 33, 40, "Subsubsection"],
Cell[123933, 3279, 2298, 64, 70, "Subsubtitle"],
Cell[126234, 3345, 771, 11, 35, "Subsubsection"],
Cell[127008, 3358, 3709, 102, 154, "Code"],
Cell[130720, 3462, 89, 2, 35, "Subsubsection"],
Cell[130812, 3466, 371, 5, 25, "Subsubsection"],
Cell[131186, 3473, 274, 4, 25, "Subsubsection"],
Cell[131463, 3479, 1586, 40, 42, "Subsubsection"],
Cell[133052, 3521, 1565, 37, 40, "Subsubsection"],
Cell[134620, 3560, 1608, 43, 63, "Subsubtitle"],
Cell[136231, 3605, 771, 11, 35, "Subsubsection"],
Cell[137005, 3618, 2738, 78, 154, "Code"],
Cell[139746, 3698, 89, 2, 35, "Subsubsection"],
Cell[139838, 3702, 274, 4, 25, "Subsubsection"],
Cell[140115, 3708, 4038, 110, 59, "Subsubsection"],
Cell[144156, 3820, 1870, 42, 40, "Subsubsection"],
Cell[146029, 3864, 3251, 93, 91, "Subsubtitle"],
Cell[149283, 3959, 771, 11, 35, "Subsubsection"],
Cell[150057, 3972, 5271, 139, 204, "Code"],
Cell[155331, 4113, 89, 2, 35, "Subsubsection"],
Cell[155423, 4117, 274, 4, 25, "Subsubsection"],
Cell[155700, 4123, 3778, 100, 60, "Subsubsection"],
Cell[159481, 4225, 1971, 45, 40, "Subsubsection"],
Cell[161455, 4272, 2915, 81, 91, "Subsubtitle"],
Cell[164373, 4355, 771, 11, 35, "Subsubsection"],
Cell[165147, 4368, 4956, 130, 204, "Code"],
Cell[170106, 4500, 89, 2, 35, "Subsubsection"],
Cell[170198, 4504, 274, 4, 25, "Subsubsection"],
Cell[170475, 4510, 3988, 104, 58, "Subsubsection"],
Cell[174466, 4616, 1900, 42, 40, "Subsubsection"],
Cell[176369, 4660, 3074, 84, 91, "Subsubtitle"],
Cell[179446, 4746, 771, 11, 35, "Subsubsection"],
Cell[180220, 4759, 4766, 123, 179, "Code"],
Cell[184989, 4884, 89, 2, 35, "Subsubsection"],
Cell[185081, 4888, 274, 4, 25, "Subsubsection"],
Cell[185358, 4894, 4083, 106, 58, "Subsubsection"],
Cell[189444, 5002, 2027, 45, 40, "Subsubsection"],
Cell[191474, 5049, 3065, 84, 91, "Subsubtitle"],
Cell[194542, 5135, 771, 11, 35, "Subsubsection"],
Cell[195316, 5148, 4907, 126, 179, "Code"],
Cell[200226, 5276, 89, 2, 35, "Subsubsection"],
Cell[200318, 5280, 566, 13, 26, "Subsubsection"],
Cell[200887, 5295, 4114, 104, 58, "Subsubsection"],
Cell[205004, 5401, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[205085, 5407, 1121, 26, 91, "Title"],
Cell[206209, 5435, 252, 4, 354, "Subsubsection"],
Cell[206464, 5441, 2563, 80, 604, "Subsubsection"],
Cell[209030, 5523, 1285, 31, 404, "Subsubsection"],
Cell[210318, 5556, 2650, 80, 796, "Subsubtitle"],
Cell[212971, 5638, 771, 11, 354, "Subsubsection"],
Cell[213745, 5651, 4361, 124, 2134, "Code"],
Cell[218109, 5777, 89, 2, 354, "Subsubsection"],
Cell[218201, 5781, 179, 3, 243, "Subsubsection"],
Cell[218383, 5786, 1563, 49, 456, "Subsubsection"],
Cell[219949, 5837, 1598, 40, 404, "Subsubsection"],
Cell[221550, 5879, 2120, 55, 655, "Subsubtitle"],
Cell[223673, 5936, 771, 11, 354, "Subsubsection"],
Cell[224447, 5949, 3000, 90, 1605, "Code"],
Cell[227450, 6041, 44, 1, 27, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[227531, 6047, 1070, 23, 80, "Title"],
Cell[228604, 6072, 480, 12, 36, "Subsubsection"],
Cell[229087, 6086, 1011, 21, 26, "Subsubsection"],
Cell[230101, 6109, 1044, 27, 66, "Subsubtitle"],
Cell[231148, 6138, 771, 11, 35, "Subsubsection"],
Cell[231922, 6151, 1174, 35, 104, "Code"],
Cell[233099, 6188, 89, 2, 35, "Subsubsection"],
Cell[233191, 6192, 201, 3, 25, "Subsubsection"],
Cell[233395, 6197, 228, 3, 25, "Subsubsection"],
Cell[233626, 6202, 1080, 32, 43, "Subsubsection"],
Cell[234709, 6236, 1339, 39, 48, "Subsubsection"],
Cell[236051, 6277, 374, 9, 26, "Subsubsection"],
Cell[236428, 6288, 1158, 23, 26, "Subsubsection"],
Cell[237589, 6313, 2161, 56, 69, "Subsubtitle"],
Cell[239753, 6371, 771, 11, 35, "Subsubsection"],
Cell[240527, 6384, 2059, 63, 129, "Code"],
Cell[242589, 6449, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[242670, 6455, 1133, 25, 80, "Title"],
Cell[243806, 6482, 518, 13, 36, "Subsubsection"],
Cell[244327, 6497, 1250, 26, 26, "Subsubsection"],
Cell[245580, 6525, 1270, 34, 69, "Subsubtitle"],
Cell[246853, 6561, 771, 11, 35, "Subsubsection"],
Cell[247627, 6574, 1664, 49, 104, "Code"],
Cell[249294, 6625, 89, 2, 35, "Subsubsection"],
Cell[249386, 6629, 216, 3, 25, "Subsubsection"],
Cell[249605, 6634, 228, 3, 25, "Subsubsection"],
Cell[249836, 6639, 1051, 28, 29, "Subsubsection"],
Cell[250890, 6669, 1101, 30, 47, "Subsubsection"],
Cell[251994, 6701, 475, 12, 26, "Subsubsection"],
Cell[252472, 6715, 1349, 27, 26, "Subsubsection"],
Cell[253824, 6744, 2272, 58, 69, "Subsubtitle"],
Cell[256099, 6804, 771, 11, 35, "Subsubsection"],
Cell[256873, 6817, 2465, 72, 129, "Code"],
Cell[259341, 6891, 89, 2, 35, "Subsubsection"],
Cell[259433, 6895, 253, 4, 25, "Subsubsection"],
Cell[259689, 6901, 228, 3, 25, "Subsubsection"],
Cell[259920, 6906, 1301, 36, 43, "Subsubsection"],
Cell[261224, 6944, 1413, 40, 48, "Subsubsection"],
Cell[262640, 6986, 497, 11, 26, "Subsubsection"],
Cell[263140, 6999, 1590, 33, 26, "Subsubsection"],
Cell[264733, 7034, 2375, 61, 69, "Subsubtitle"],
Cell[267111, 7097, 771, 11, 35, "Subsubsection"],
Cell[267885, 7110, 2795, 80, 129, "Code"],
Cell[270683, 7192, 89, 2, 35, "Subsubsection"],
Cell[270775, 7196, 277, 4, 25, "Subsubsection"],
Cell[271055, 7202, 228, 3, 25, "Subsubsection"],
Cell[271286, 7207, 1435, 39, 60, "Subsubsection"],
Cell[272724, 7248, 1394, 39, 67, "Subsubsection"],
Cell[274121, 7289, 497, 11, 26, "Subsubsection"],
Cell[274621, 7302, 1876, 41, 39, "Subsubsection"],
Cell[276500, 7345, 2405, 63, 69, "Subsubtitle"],
Cell[278908, 7410, 771, 11, 35, "Subsubsection"],
Cell[279682, 7423, 3202, 91, 154, "Code"],
Cell[282887, 7516, 89, 2, 35, "Subsubsection"],
Cell[282979, 7520, 299, 4, 25, "Subsubsection"],
Cell[283281, 7526, 289, 4, 25, "Subsubsection"],
Cell[283573, 7532, 1887, 39, 39, "Subsubsection"],
Cell[285463, 7573, 2429, 62, 69, "Subsubtitle"],
Cell[287895, 7637, 771, 11, 35, "Subsubsection"],
Cell[288669, 7650, 3181, 88, 154, "Code"],
Cell[291853, 7740, 89, 2, 35, "Subsubsection"],
Cell[291945, 7744, 300, 4, 25, "Subsubsection"],
Cell[292248, 7750, 771, 11, 25, "Subsubsection"],
Cell[293022, 7763, 1825, 45, 104, "Code"],
Cell[294850, 7810, 89, 2, 35, "Subsubsection"],
Cell[294942, 7814, 318, 5, 25, "Subsubsection"],
Cell[295263, 7821, 302, 4, 25, "Subsubsection"],
Cell[295568, 7827, 1051, 28, 29, "Subsubsection"],
Cell[296622, 7857, 497, 12, 26, "Subsubsection"],
Cell[297122, 7871, 545, 12, 26, "Subsubsection"],
Cell[297670, 7885, 1692, 32, 26, "Subsubsection"],
Cell[299365, 7919, 3159, 81, 119, "Subsubtitle"],
Cell[302527, 8002, 771, 11, 35, "Subsubsection"],
Cell[303301, 8015, 3466, 96, 129, "Code"],
Cell[306770, 8113, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[306851, 8119, 1105, 26, 102, "Title"],
Cell[307959, 8147, 257, 4, 7610, "Subsubsection"],
Cell[308219, 8153, 514, 15, 9469, "Subsubsection"],
Cell[308736, 8170, 763, 11, 5310, "Subsubsection"],
Cell[309502, 8183, 1153, 32, 15761, "Subsubtitle"],
Cell[310658, 8217, 771, 11, 7610, "Subsubsection"],
Cell[311432, 8230, 1224, 39, 21839, "Code"],
Cell[312659, 8271, 44, 1, 818, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[312740, 8277, 1230, 27, 80, "Title"],
Cell[313973, 8306, 357, 5, 354, "Subsubsection"],
Cell[314333, 8313, 905, 23, 289, "Subsubsection"],
Cell[315241, 8338, 1019, 18, 261, "Subsubsection"],
Cell[316263, 8358, 1360, 34, 550, "Subsubtitle"],
Cell[317626, 8394, 771, 11, 354, "Subsubsection"],
Cell[318400, 8407, 1620, 46, 1079, "Code"],
Cell[320023, 8455, 89, 2, 354, "Subsubsection"],
Cell[320115, 8459, 357, 5, 243, "Subsubsection"],
Cell[320475, 8466, 905, 23, 289, "Subsubsection"],
Cell[321383, 8491, 1019, 18, 261, "Subsubsection"],
Cell[322405, 8511, 1472, 37, 550, "Subsubtitle"],
Cell[323880, 8550, 771, 11, 354, "Subsubsection"],
Cell[324654, 8563, 1832, 51, 1345, "Code"]
}, Closed]]
}
]
*)

(* End of internal cache information *)
