(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    325378,       9027]
NotebookOptionsPosition[    300736,       8424]
NotebookOutlinePosition[    301796,       8462]
CellTagsIndexPosition[    301753,       8459]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Rational Function Integration Problem 1", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
  3.4821876372994003`*^9, 3.4821876389718046`*^9}, {3.4821882097225037`*^9, 
  3.482188210493613*^9}, {3.4821886738498864`*^9, 3.482188675492248*^9}, {
  3.4898037822288513`*^9, 3.489803784058854*^9}, {3.489805127990735*^9, 
  3.4898051282007356`*^9}, {3.4898054665212092`*^9, 3.489805467661211*^9}},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", 
    RowBox[{"n", "-", "1"}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], ")"}], "m"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.482188206147363*^9, {
   3.489804778500246*^9, 3.4898047820202513`*^9}, {3.4898052545009127`*^9, 
   3.4898052555309143`*^9}, 3.489861714912547*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " knows and takes advantage of the general rule for arbitrary m and n:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443225459641647`*^9, 3.4443225485078225`*^9}, {
   3.4466948911496077`*^9, 3.42301074665625*^9}, 3.42317159478125*^9, {
   3.423174840640625*^9, 3.423174854046875*^9}, {3.4233322945*^9, 
   3.4233323091875*^9}, {3.42333236403125*^9, 3.423332366546875*^9}, {
   3.423332643984375*^9, 3.42333264684375*^9}, 3.423341072609375*^9, 
   3.4561670576690483`*^9, 3.4791559290778675`*^9, 3.482175999467106*^9, {
   3.482176939178344*^9, 3.482176943534608*^9}, 3.4821770265840273`*^9, {
   3.4898048224003077`*^9, 3.4898048266603136`*^9}, {3.4898052234408693`*^9, 
   3.489805239230891*^9}, {3.4898052800709486`*^9, 3.4898052802509484`*^9}, 
   3.48987627971564*^9, 3.4898763255641203`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", 
     RowBox[{"n", "-", "1"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], "m"]}], ",", " ", "x"}], 
  "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794213586063`*^9}, {3.4442805438526735`*^9, 3.42301101521875*^9}, 
   3.42317151703125*^9, 3.423175055046875*^9, {3.455314373743822*^9, 
   3.4553143875937376`*^9}, 3.489804786560257*^9, 3.48987627971564*^9, 
   3.4898763255641203`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}]}], ")"}], 
   RowBox[{"1", "+", "m"}]], 
  RowBox[{"b", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "m"}], ")"}], " ", "n"}]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.4553143612258224`*^9, {3.455314395865632*^9, 3.4553144011632495`*^9}, 
   3.4898052907609634`*^9, 3.4898763255641203`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", 
     RowBox[{"n", "-", "1"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], "16"]}], ",", " ", "x"}], 
  "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794213586063`*^9}, {3.4442805438526735`*^9, 3.42301101521875*^9}, 
   3.42317151703125*^9, 3.423175055046875*^9, {3.455314373743822*^9, 
   3.4553143875937376`*^9}, 3.489804786560257*^9, {3.4898051854308157`*^9, 
   3.4898051973908324`*^9}, {3.4898076099142103`*^9, 3.4898076104942107`*^9}, 
   3.48987627971564*^9, 3.4898763255641203`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}]}], ")"}], "17"], 
  RowBox[{"17", " ", "b", " ", "n"}]]], "Input",
 CellChangeTimes->{{3.5207997126239204`*^9, 3.5207997126395206`*^9}}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "3"]}]}], ")"}], "16"]}], ",", " ", "x"}], 
  "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794213586063`*^9}, {3.4442805438526735`*^9, 3.42301101521875*^9}, 
   3.42317151703125*^9, 3.423175055046875*^9, {3.4898076130142145`*^9, 
   3.489807613704215*^9}, 3.4898762620252085`*^9, 3.4898763255641203`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "3"]}]}], ")"}], "17"], 
  RowBox[{"51", " ", "b"}]]], "Input",
 CellChangeTimes->{{3.520799735805561*^9, 3.5207997358211613`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " knows the rule for arbitrary m and n, but needlessly expands the integrand \
when m is a positive integer:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.444322558662424*^9, 3.444322586131923*^9}, {
   3.4466780286625423`*^9, 3.446678029423637*^9}, {3.4466948967576723`*^9, 
   3.42317159478125*^9}, 3.423174910453125*^9, {3.423332331546875*^9, 
   3.423332347125*^9}, {3.423332380203125*^9, 3.42333240928125*^9}, 
   3.423341072625*^9, 3.4561670576790624`*^9, 3.4821759878804445`*^9, 
   3.4821761016640577`*^9, 3.4821761392881584`*^9, 3.482176179285672*^9, 
   3.4821770498975506`*^9, {3.489804505429864*^9, 3.489804512039873*^9}, {
   3.4898045424699154`*^9, 3.4898045431099167`*^9}, {3.4898045772899647`*^9, 
   3.4898046123600135`*^9}, {3.4898048582503576`*^9, 3.489804864160366*^9}, {
   3.4898049421404753`*^9, 3.4898049903205423`*^9}, {3.4898052429608965`*^9, 
   3.489805244530898*^9}, {3.489805282760952*^9, 3.4898052829509525`*^9}, 
   3.48987627971564*^9, 3.4898763360473385`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", 
     RowBox[{"n", "-", "1"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], "m"]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794213586063`*^9}, {3.4442805438526735`*^9, 3.42301101521875*^9}, 
   3.42317151703125*^9, 3.423175055046875*^9, {3.455314373743822*^9, 
   3.4553143875937376`*^9}, {3.4553144686903486`*^9, 3.4553144881082706`*^9}, 
   3.489804884140394*^9, 3.48987627971564*^9, 3.4898763360473385`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}]}], ")"}], 
   RowBox[{"1", "+", "m"}]], 
  RowBox[{
   RowBox[{"b", " ", "n"}], "+", 
   RowBox[{"b", " ", "m", " ", "n"}]}]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{{3.455314473997981*^9, 3.4553144881082706`*^9}, 
   3.489804889830402*^9, 3.4898763360473385`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", 
     RowBox[{"n", "-", "1"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], "16"]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794581114545`*^9}, {3.4442806909341664`*^9, 3.423010973765625*^9}, 
   3.42317151703125*^9, {3.4898049133204346`*^9, 3.489804918510442*^9}, {
   3.489807272043737*^9, 3.489807272573738*^9}, 3.48987627971564*^9, 
   3.4898763360473385`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"17", " ", "n"}]], 
  RowBox[{
   SuperscriptBox["x", "n"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"17", " ", 
      SuperscriptBox["a", "16"]}], "+", 
     RowBox[{"136", " ", 
      SuperscriptBox["a", "15"], " ", "b", " ", 
      SuperscriptBox["x", "n"]}], "+", 
     RowBox[{"680", " ", 
      SuperscriptBox["a", "14"], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["x", 
       RowBox[{"2", " ", "n"}]]}], "+", 
     RowBox[{"2380", " ", 
      SuperscriptBox["a", "13"], " ", 
      SuperscriptBox["b", "3"], " ", 
      SuperscriptBox["x", 
       RowBox[{"3", " ", "n"}]]}], "+", 
     RowBox[{"6188", " ", 
      SuperscriptBox["a", "12"], " ", 
      SuperscriptBox["b", "4"], " ", 
      SuperscriptBox["x", 
       RowBox[{"4", " ", "n"}]]}], "+", 
     RowBox[{"12376", " ", 
      SuperscriptBox["a", "11"], " ", 
      SuperscriptBox["b", "5"], " ", 
      SuperscriptBox["x", 
       RowBox[{"5", " ", "n"}]]}], "+", 
     RowBox[{"19448", " ", 
      SuperscriptBox["a", "10"], " ", 
      SuperscriptBox["b", "6"], " ", 
      SuperscriptBox["x", 
       RowBox[{"6", " ", "n"}]]}], "+", 
     RowBox[{"24310", " ", 
      SuperscriptBox["a", "9"], " ", 
      SuperscriptBox["b", "7"], " ", 
      SuperscriptBox["x", 
       RowBox[{"7", " ", "n"}]]}], "+", 
     RowBox[{"24310", " ", 
      SuperscriptBox["a", "8"], " ", 
      SuperscriptBox["b", "8"], " ", 
      SuperscriptBox["x", 
       RowBox[{"8", " ", "n"}]]}], "+", 
     RowBox[{"19448", " ", 
      SuperscriptBox["a", "7"], " ", 
      SuperscriptBox["b", "9"], " ", 
      SuperscriptBox["x", 
       RowBox[{"9", " ", "n"}]]}], "+", 
     RowBox[{"12376", " ", 
      SuperscriptBox["a", "6"], " ", 
      SuperscriptBox["b", "10"], " ", 
      SuperscriptBox["x", 
       RowBox[{"10", " ", "n"}]]}], "+", 
     RowBox[{"6188", " ", 
      SuperscriptBox["a", "5"], " ", 
      SuperscriptBox["b", "11"], " ", 
      SuperscriptBox["x", 
       RowBox[{"11", " ", "n"}]]}], "+", 
     RowBox[{"2380", " ", 
      SuperscriptBox["a", "4"], " ", 
      SuperscriptBox["b", "12"], " ", 
      SuperscriptBox["x", 
       RowBox[{"12", " ", "n"}]]}], "+", 
     RowBox[{"680", " ", 
      SuperscriptBox["a", "3"], " ", 
      SuperscriptBox["b", "13"], " ", 
      SuperscriptBox["x", 
       RowBox[{"13", " ", "n"}]]}], "+", 
     RowBox[{"136", " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["b", "14"], " ", 
      SuperscriptBox["x", 
       RowBox[{"14", " ", "n"}]]}], "+", 
     RowBox[{"17", " ", "a", " ", 
      SuperscriptBox["b", "15"], " ", 
      SuperscriptBox["x", 
       RowBox[{"15", " ", "n"}]]}], "+", 
     RowBox[{
      SuperscriptBox["b", "16"], " ", 
      SuperscriptBox["x", 
       RowBox[{"16", " ", "n"}]]}]}], ")"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{3.4898049194304433`*^9, 3.489805393661107*^9, 
  3.4898072735437393`*^9, 3.4898763360473385`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "3"]}]}], ")"}], "16"]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794581114545`*^9}, {3.4442806909341664`*^9, 3.423010973765625*^9}, 
   3.42317151703125*^9, 3.489804903310421*^9, {3.4898072780737457`*^9, 
   3.489807278493746*^9}, 3.48987627971564*^9, 3.4898763360473385`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    SuperscriptBox["a", "16"], " ", 
    SuperscriptBox["x", "3"]}], "3"], "+", 
  RowBox[{
   FractionBox["8", "3"], " ", 
   SuperscriptBox["a", "15"], " ", "b", " ", 
   SuperscriptBox["x", "6"]}], "+", 
  RowBox[{
   FractionBox["40", "3"], " ", 
   SuperscriptBox["a", "14"], " ", 
   SuperscriptBox["b", "2"], " ", 
   SuperscriptBox["x", "9"]}], "+", 
  RowBox[{
   FractionBox["140", "3"], " ", 
   SuperscriptBox["a", "13"], " ", 
   SuperscriptBox["b", "3"], " ", 
   SuperscriptBox["x", "12"]}], "+", 
  RowBox[{
   FractionBox["364", "3"], " ", 
   SuperscriptBox["a", "12"], " ", 
   SuperscriptBox["b", "4"], " ", 
   SuperscriptBox["x", "15"]}], "+", 
  RowBox[{
   FractionBox["728", "3"], " ", 
   SuperscriptBox["a", "11"], " ", 
   SuperscriptBox["b", "5"], " ", 
   SuperscriptBox["x", "18"]}], "+", 
  RowBox[{
   FractionBox["1144", "3"], " ", 
   SuperscriptBox["a", "10"], " ", 
   SuperscriptBox["b", "6"], " ", 
   SuperscriptBox["x", "21"]}], "+", 
  RowBox[{
   FractionBox["1430", "3"], " ", 
   SuperscriptBox["a", "9"], " ", 
   SuperscriptBox["b", "7"], " ", 
   SuperscriptBox["x", "24"]}], "+", 
  RowBox[{
   FractionBox["1430", "3"], " ", 
   SuperscriptBox["a", "8"], " ", 
   SuperscriptBox["b", "8"], " ", 
   SuperscriptBox["x", "27"]}], "+", 
  RowBox[{
   FractionBox["1144", "3"], " ", 
   SuperscriptBox["a", "7"], " ", 
   SuperscriptBox["b", "9"], " ", 
   SuperscriptBox["x", "30"]}], "+", 
  RowBox[{
   FractionBox["728", "3"], " ", 
   SuperscriptBox["a", "6"], " ", 
   SuperscriptBox["b", "10"], " ", 
   SuperscriptBox["x", "33"]}], "+", 
  RowBox[{
   FractionBox["364", "3"], " ", 
   SuperscriptBox["a", "5"], " ", 
   SuperscriptBox["b", "11"], " ", 
   SuperscriptBox["x", "36"]}], "+", 
  RowBox[{
   FractionBox["140", "3"], " ", 
   SuperscriptBox["a", "4"], " ", 
   SuperscriptBox["b", "12"], " ", 
   SuperscriptBox["x", "39"]}], "+", 
  RowBox[{
   FractionBox["40", "3"], " ", 
   SuperscriptBox["a", "3"], " ", 
   SuperscriptBox["b", "13"], " ", 
   SuperscriptBox["x", "42"]}], "+", 
  RowBox[{
   FractionBox["8", "3"], " ", 
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["b", "14"], " ", 
   SuperscriptBox["x", "45"]}], "+", 
  RowBox[{
   FractionBox["1", "3"], " ", "a", " ", 
   SuperscriptBox["b", "15"], " ", 
   SuperscriptBox["x", "48"]}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["b", "16"], " ", 
    SuperscriptBox["x", "51"]}], "51"]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{
  3.4442796668616223`*^9, 3.4442806956910067`*^9, {3.4466848665950065`*^9, 
   3.423010974265625*^9}, 3.42317151703125*^9, 3.4898053975311127`*^9, 
   3.489807279093747*^9, 3.48987627971564*^9, 3.4898763360473385`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " knows the rule for arbitrary m and n, but needlessly expands the integrand \
when m is a positive integer:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.444322558662424*^9, 3.444322586131923*^9}, {
   3.4466780286625423`*^9, 3.446678029423637*^9}, {3.4466948967576723`*^9, 
   3.42317159478125*^9}, 3.423174910453125*^9, {3.423332331546875*^9, 
   3.423332347125*^9}, {3.423332380203125*^9, 3.42333240928125*^9}, 
   3.423341072625*^9, 3.4561670576790624`*^9, 3.4821759878804445`*^9, 
   3.4821761016640577`*^9, 3.4821761392881584`*^9, 3.482176179285672*^9, 
   3.4821770498975506`*^9, {3.489804505429864*^9, 3.489804512039873*^9}, {
   3.4898045424699154`*^9, 3.4898045431099167`*^9}, {3.4898045772899647`*^9, 
   3.4898046123600135`*^9}, {3.4898048582503576`*^9, 3.489804864160366*^9}, {
   3.4898049421404753`*^9, 3.4898049903205423`*^9}, {3.4898052429608965`*^9, 
   3.489805244530898*^9}, {3.489805282760952*^9, 3.4898052829509525`*^9}, 
   3.4898058438317375`*^9, 3.48987627971564*^9, 3.4898763415385485`*^9, 
   3.489877780422676*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], ")"}], "^", "m"}]}], ",", " ", "x"}], 
    ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794581114545`*^9}, {3.4442806909341664`*^9, 
   3.4442806946094513`*^9}, {3.446684899001605*^9, 3.423011009453125*^9}, 
   3.42317151703125*^9, 3.423175051171875*^9, {3.455314596093546*^9, 
   3.4553146068490114`*^9}, 3.4898054991512547`*^9, 3.48987627971564*^9, 
   3.4898763415385485`*^9, 3.489877780422676*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], ")"}], "m"]}], 
  RowBox[{"b", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "m"}], ")"}], " ", "n"}]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{3.4898763415385485`*^9, 3.489877780422676*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], ")"}], "^", "16"}]}], ",", " ", "x"}], 
    ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794581114545`*^9}, {3.4442806909341664`*^9, 
   3.4442806946094513`*^9}, {3.446684899001605*^9, 3.423011009453125*^9}, 
   3.42317151703125*^9, 3.423175051171875*^9, {3.455314596093546*^9, 
   3.4553146068490114`*^9}, 3.4898054991512547`*^9, {3.489805761361622*^9, 
   3.4898057616916227`*^9}, {3.4898072924437656`*^9, 3.489807292903766*^9}, 
   3.48987627971564*^9, 3.4898763415385485`*^9, 3.489877780422676*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"17", " ", "n"}]], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"17", " ", 
     SuperscriptBox["a", "16"], " ", 
     SuperscriptBox["x", "n"]}], "+", 
    RowBox[{"136", " ", 
     SuperscriptBox["a", "15"], " ", "b", " ", 
     SuperscriptBox["x", 
      RowBox[{"2", " ", "n"}]]}], "+", 
    RowBox[{"680", " ", 
     SuperscriptBox["a", "14"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["x", 
      RowBox[{"3", " ", "n"}]]}], "+", 
    RowBox[{"2380", " ", 
     SuperscriptBox["a", "13"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["x", 
      RowBox[{"4", " ", "n"}]]}], "+", 
    RowBox[{"6188", " ", 
     SuperscriptBox["a", "12"], " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["x", 
      RowBox[{"5", " ", "n"}]]}], "+", 
    RowBox[{"12376", " ", 
     SuperscriptBox["a", "11"], " ", 
     SuperscriptBox["b", "5"], " ", 
     SuperscriptBox["x", 
      RowBox[{"6", " ", "n"}]]}], "+", 
    RowBox[{"19448", " ", 
     SuperscriptBox["a", "10"], " ", 
     SuperscriptBox["b", "6"], " ", 
     SuperscriptBox["x", 
      RowBox[{"7", " ", "n"}]]}], "+", 
    RowBox[{"24310", " ", 
     SuperscriptBox["a", "9"], " ", 
     SuperscriptBox["b", "7"], " ", 
     SuperscriptBox["x", 
      RowBox[{"8", " ", "n"}]]}], "+", 
    RowBox[{"24310", " ", 
     SuperscriptBox["a", "8"], " ", 
     SuperscriptBox["b", "8"], " ", 
     SuperscriptBox["x", 
      RowBox[{"9", " ", "n"}]]}], "+", 
    RowBox[{"19448", " ", 
     SuperscriptBox["a", "7"], " ", 
     SuperscriptBox["b", "9"], " ", 
     SuperscriptBox["x", 
      RowBox[{"10", " ", "n"}]]}], "+", 
    RowBox[{"12376", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["b", "10"], " ", 
     SuperscriptBox["x", 
      RowBox[{"11", " ", "n"}]]}], "+", 
    RowBox[{"6188", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "11"], " ", 
     SuperscriptBox["x", 
      RowBox[{"12", " ", "n"}]]}], "+", 
    RowBox[{"2380", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "12"], " ", 
     SuperscriptBox["x", 
      RowBox[{"13", " ", "n"}]]}], "+", 
    RowBox[{"680", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "13"], " ", 
     SuperscriptBox["x", 
      RowBox[{"14", " ", "n"}]]}], "+", 
    RowBox[{"136", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "14"], " ", 
     SuperscriptBox["x", 
      RowBox[{"15", " ", "n"}]]}], "+", 
    RowBox[{"17", " ", "a", " ", 
     SuperscriptBox["b", "15"], " ", 
     SuperscriptBox["x", 
      RowBox[{"16", " ", "n"}]]}], "+", 
    RowBox[{
     SuperscriptBox["b", "16"], " ", 
     SuperscriptBox["x", 
      RowBox[{"17", " ", "n"}]]}]}], ")"}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{3.489876503888034*^9, 3.489877780422676*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "3"}]}]}], ")"}], "^", "16"}]}], ",", " ", "x"}], 
    ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794581114545`*^9}, {3.4442806909341664`*^9, 
   3.4442806946094513`*^9}, {3.446684899001605*^9, 3.423011009453125*^9}, 
   3.42317151703125*^9, 3.423175051171875*^9, 3.489805677601505*^9, {
   3.489807294383768*^9, 3.4898072948937693`*^9}, 3.48987627971564*^9, 
   3.4898763415385485`*^9, 3.489877780422676*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    SuperscriptBox["a", "16"], " ", 
    SuperscriptBox["x", "3"]}], "3"], "+", 
  RowBox[{
   FractionBox["8", "3"], " ", 
   SuperscriptBox["a", "15"], " ", "b", " ", 
   SuperscriptBox["x", "6"]}], "+", 
  RowBox[{
   FractionBox["40", "3"], " ", 
   SuperscriptBox["a", "14"], " ", 
   SuperscriptBox["b", "2"], " ", 
   SuperscriptBox["x", "9"]}], "+", 
  RowBox[{
   FractionBox["140", "3"], " ", 
   SuperscriptBox["a", "13"], " ", 
   SuperscriptBox["b", "3"], " ", 
   SuperscriptBox["x", "12"]}], "+", 
  RowBox[{
   FractionBox["364", "3"], " ", 
   SuperscriptBox["a", "12"], " ", 
   SuperscriptBox["b", "4"], " ", 
   SuperscriptBox["x", "15"]}], "+", 
  RowBox[{
   FractionBox["728", "3"], " ", 
   SuperscriptBox["a", "11"], " ", 
   SuperscriptBox["b", "5"], " ", 
   SuperscriptBox["x", "18"]}], "+", 
  RowBox[{
   FractionBox["1144", "3"], " ", 
   SuperscriptBox["a", "10"], " ", 
   SuperscriptBox["b", "6"], " ", 
   SuperscriptBox["x", "21"]}], "+", 
  RowBox[{
   FractionBox["1430", "3"], " ", 
   SuperscriptBox["a", "9"], " ", 
   SuperscriptBox["b", "7"], " ", 
   SuperscriptBox["x", "24"]}], "+", 
  RowBox[{
   FractionBox["1430", "3"], " ", 
   SuperscriptBox["a", "8"], " ", 
   SuperscriptBox["b", "8"], " ", 
   SuperscriptBox["x", "27"]}], "+", 
  RowBox[{
   FractionBox["1144", "3"], " ", 
   SuperscriptBox["a", "7"], " ", 
   SuperscriptBox["b", "9"], " ", 
   SuperscriptBox["x", "30"]}], "+", 
  RowBox[{
   FractionBox["728", "3"], " ", 
   SuperscriptBox["a", "6"], " ", 
   SuperscriptBox["b", "10"], " ", 
   SuperscriptBox["x", "33"]}], "+", 
  RowBox[{
   FractionBox["364", "3"], " ", 
   SuperscriptBox["a", "5"], " ", 
   SuperscriptBox["b", "11"], " ", 
   SuperscriptBox["x", "36"]}], "+", 
  RowBox[{
   FractionBox["140", "3"], " ", 
   SuperscriptBox["a", "4"], " ", 
   SuperscriptBox["b", "12"], " ", 
   SuperscriptBox["x", "39"]}], "+", 
  RowBox[{
   FractionBox["40", "3"], " ", 
   SuperscriptBox["a", "3"], " ", 
   SuperscriptBox["b", "13"], " ", 
   SuperscriptBox["x", "42"]}], "+", 
  RowBox[{
   FractionBox["8", "3"], " ", 
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["b", "14"], " ", 
   SuperscriptBox["x", "45"]}], "+", 
  RowBox[{
   FractionBox["1", "3"], " ", "a", " ", 
   SuperscriptBox["b", "15"], " ", 
   SuperscriptBox["x", "48"]}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["b", "16"], " ", 
    SuperscriptBox["x", "51"]}], "51"]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{
  3.4442796668616223`*^9, 3.4442806956910067`*^9, {3.4466848665950065`*^9, 
   3.423010974265625*^9}, 3.42317151703125*^9, 3.4898053975311127`*^9, 
   3.489807279093747*^9, 3.48987627971564*^9, 3.4898763360473385`*^9, 
   3.489877780422676*^9}]
}, Closed]],

Cell["", "PageBreak",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 PageBreakBelow->True,
 CellChangeTimes->{3.4898763415385485`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Rational Function Integration Problem 2", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821876372994003`*^9, 3.4821876389718046`*^9}, {3.4821882097225037`*^9, 
   3.482188210493613*^9}, {3.4821886738498864`*^9, 3.482188675492248*^9}, {
   3.4898037822288513`*^9, 3.489803784058854*^9}, {3.489805127990735*^9, 
   3.4898051282007356`*^9}, {3.4898054665212092`*^9, 3.489805467661211*^9}, 
   3.4898760910333085`*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "p"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", 
        RowBox[{
         RowBox[{"m", " ", "n"}], "+", "n", "+", "p", "+", "1"}]]}]}], ")"}], 
    "m"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.482188189313157*^9, {
   3.489867118711646*^9, 3.489867148507698*^9}, 3.4898696086548195`*^9, {
   3.489869679572544*^9, 3.489869704033387*^9}},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " knows and takes advantage of the general rule for arbitrary m, n and p:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443225459641647`*^9, 3.4443225485078225`*^9}, {
   3.4466948911496077`*^9, 3.42301074665625*^9}, 3.42317159478125*^9, {
   3.423174840640625*^9, 3.423174854046875*^9}, {3.4233322945*^9, 
   3.4233323091875*^9}, {3.42333236403125*^9, 3.423332366546875*^9}, {
   3.423332643984375*^9, 3.42333264684375*^9}, 3.423341072609375*^9, 
   3.4561670576690483`*^9, 3.4791559290778675`*^9, 3.482175999467106*^9, {
   3.482176939178344*^9, 3.482176943534608*^9}, 3.4821770265840273`*^9, {
   3.4898048224003077`*^9, 3.4898048266603136`*^9}, {3.4898052234408693`*^9, 
   3.489805239230891*^9}, {3.4898052800709486`*^9, 3.4898052802509484`*^9}, {
   3.4898697506930695`*^9, 3.489869759819085*^9}, 3.4898765588313303`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "p"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", 
        SuperscriptBox["x", "n"]}], "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", 
         RowBox[{
          RowBox[{"m", " ", "n"}], "+", "n", "+", "p", "+", "1"}]]}]}], ")"}],
      "m"]}], ",", " ", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794213586063`*^9}, {3.4442805438526735`*^9, 3.42301101521875*^9}, 
   3.42317151703125*^9, 3.423175055046875*^9, {3.423176000796875*^9, 
   3.4231760043125*^9}, {3.423176044578125*^9, 3.423176093671875*^9}, 
   3.423176130421875*^9, 3.455314762813277*^9, {3.4898087279757752`*^9, 
   3.4898087452157993`*^9}, {3.489808846235941*^9, 3.4898088560159545`*^9}, {
   3.489867292215151*^9, 3.4898673161455927`*^9}, {3.4898697281822295`*^9, 
   3.489869743080256*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["x", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{"1", "+", "m"}], ")"}]}], " ", "n"}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "n"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", 
          RowBox[{"1", "+", 
           RowBox[{"m", " ", "n"}], "+", "p"}]]}]}], ")"}]}], ")"}], 
    RowBox[{"1", "+", "m"}]]}], 
  RowBox[{"b", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "m"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"m", " ", "n"}], "+", "p"}], ")"}]}]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.489867303603171*^9, 3.4898673123859863`*^9}, {
   3.4898697336266394`*^9, 3.4898697389462485`*^9}, 3.4898765588313303`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "p"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", 
        SuperscriptBox["x", "n"]}], "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", 
         RowBox[{
          RowBox[{"12", " ", "n"}], "+", "n", "+", "p", "+", "1"}]]}]}], 
      ")"}], "12"]}], ",", " ", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794213586063`*^9}, {3.4442805438526735`*^9, 3.42301101521875*^9}, 
   3.42317151703125*^9, 3.423175055046875*^9, {3.423176000796875*^9, 
   3.4231760043125*^9}, {3.423176044578125*^9, 3.423176093671875*^9}, 
   3.423176130421875*^9, 3.455314762813277*^9, {3.4898087279757752`*^9, 
   3.4898087452157993`*^9}, {3.489808846235941*^9, 3.4898088560159545`*^9}, {
   3.489867292215151*^9, 3.4898673161455927`*^9}, {3.4898697281822295`*^9, 
   3.489869777244316*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", 
       RowBox[{"1", "+", 
        RowBox[{"12", " ", "n"}], "+", "p"}]]}]}], ")"}], "13"], 
  RowBox[{"13", " ", "b", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"12", " ", "n"}], "+", "p"}], ")"}]}]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{3.489869781830724*^9, 3.489875822556837*^9, 
  3.4898765588313303`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "24"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", "x"}], "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "38"]}]}], ")"}], "12"]}], ",", " ", "x"}], 
  "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794213586063`*^9}, {3.4442805438526735`*^9, 3.42301101521875*^9}, 
   3.42317151703125*^9, 3.423175055046875*^9, {3.423176000796875*^9, 
   3.4231760043125*^9}, {3.423176044578125*^9, 3.423176093671875*^9}, 
   3.423176130421875*^9, 3.455314762813277*^9, {3.489869844558434*^9, 
   3.489869848396041*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "37"]}]}], ")"}], "13"], 
  RowBox[{"481", " ", "b"}]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{3.4231761208125*^9, 3.4898088616559625`*^9, 
  3.4898673886233206`*^9, 3.4898698521244473`*^9, 3.4898765662413435`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " knows the rule for arbitrary m, n and p, but needlessly expands the \
integrand when m is a positive integer:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.444322558662424*^9, 3.444322586131923*^9}, {
   3.4466780286625423`*^9, 3.446678029423637*^9}, {3.4466948967576723`*^9, 
   3.42317159478125*^9}, 3.423174910453125*^9, {3.423332331546875*^9, 
   3.423332347125*^9}, {3.423332380203125*^9, 3.42333240928125*^9}, 
   3.423341072625*^9, 3.4561670576790624`*^9, 3.4821759878804445`*^9, 
   3.4821761016640577`*^9, 3.4821761392881584`*^9, 3.482176179285672*^9, 
   3.4821770498975506`*^9, {3.489804505429864*^9, 3.489804512039873*^9}, {
   3.4898045424699154`*^9, 3.4898045431099167`*^9}, {3.4898045772899647`*^9, 
   3.4898046123600135`*^9}, {3.4898048582503576`*^9, 3.489804864160366*^9}, {
   3.4898049421404753`*^9, 3.4898049903205423`*^9}, {3.4898052429608965`*^9, 
   3.489805244530898*^9}, {3.489805282760952*^9, 3.4898052829509525`*^9}, {
   3.4898759963099422`*^9, 3.4898760016607513`*^9}, 3.4898765748993587`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "p"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", 
        RowBox[{
         RowBox[{"m", " ", "n"}], "+", "n", "+", "p", "+", "1"}]]}]}], ")"}], 
    "m"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794581114545`*^9}, {3.4442806909341664`*^9, 3.423010973765625*^9}, 
   3.42317151703125*^9, {3.423176171453125*^9, 3.4231761745*^9}, 
   3.4898089082360277`*^9, {3.4898089724861174`*^9, 3.4898089881061397`*^9}, 
   3.48986741127456*^9, 3.4898765748993587`*^9, 3.489876947630813*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["x", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{"1", "+", "m"}], ")"}]}], " ", "n"}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "n"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", 
          RowBox[{"1", "+", 
           RowBox[{"m", " ", "n"}], "+", "p"}]]}]}], ")"}]}], ")"}], 
    RowBox[{"1", "+", "m"}]]}], 
  RowBox[{"b", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "m"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"m", " ", "n"}], "+", "p"}], ")"}]}]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{
  3.4442796668616223`*^9, 3.4442806956910067`*^9, {3.4466848665950065`*^9, 
   3.423010974265625*^9}, 3.42317151703125*^9, 3.423176180328125*^9, 
   3.4898089325460615`*^9, {3.489808974936121*^9, 3.489809001476158*^9}, 
   3.4898674124289618`*^9, 3.4898765748993587`*^9, 3.4898769488632154`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "p"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", 
        RowBox[{
         RowBox[{"12", " ", "n"}], "+", "n", "+", "p", "+", "1"}]]}]}], ")"}],
     "12"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794581114545`*^9}, {3.4442806909341664`*^9, 3.423010973765625*^9}, 
   3.42317151703125*^9, {3.423176171453125*^9, 3.4231761745*^9}, 
   3.4898089082360277`*^9, {3.4898089724861174`*^9, 3.4898089881061397`*^9}, {
   3.48986741127456*^9, 3.4898674303689938`*^9}, 3.4898765748993587`*^9, 
   3.4898769979877014`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"13", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"12", " ", "n"}], "+", "p"}], ")"}]}]], 
  RowBox[{
   SuperscriptBox["x", 
    RowBox[{"1", "+", 
     RowBox[{"12", " ", "n"}], "+", "p"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"13", " ", 
      SuperscriptBox["a", "12"]}], "+", 
     RowBox[{"78", " ", 
      SuperscriptBox["a", "11"], " ", "b", " ", 
      SuperscriptBox["x", 
       RowBox[{"1", "+", 
        RowBox[{"12", " ", "n"}], "+", "p"}]]}], "+", 
     RowBox[{"286", " ", 
      SuperscriptBox["a", "3"], " ", 
      SuperscriptBox["b", "9"], " ", 
      SuperscriptBox["x", 
       RowBox[{"9", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"12", " ", "n"}], "+", "p"}], ")"}]}]]}], "+", 
     RowBox[{"78", " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["b", "10"], " ", 
      SuperscriptBox["x", 
       RowBox[{"10", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"12", " ", "n"}], "+", "p"}], ")"}]}]]}], "+", 
     RowBox[{"13", " ", "a", " ", 
      SuperscriptBox["b", "11"], " ", 
      SuperscriptBox["x", 
       RowBox[{"11", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"12", " ", "n"}], "+", "p"}], ")"}]}]]}], "+", 
     RowBox[{
      SuperscriptBox["b", "12"], " ", 
      SuperscriptBox["x", 
       RowBox[{"12", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"12", " ", "n"}], "+", "p"}], ")"}]}]]}], "+", 
     RowBox[{"286", " ", 
      SuperscriptBox["a", "10"], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["x", 
       RowBox[{"2", "+", 
        RowBox[{"24", " ", "n"}], "+", 
        RowBox[{"2", " ", "p"}]}]]}], "+", 
     RowBox[{"715", " ", 
      SuperscriptBox["a", "9"], " ", 
      SuperscriptBox["b", "3"], " ", 
      SuperscriptBox["x", 
       RowBox[{"3", "+", 
        RowBox[{"36", " ", "n"}], "+", 
        RowBox[{"3", " ", "p"}]}]]}], "+", 
     RowBox[{"1287", " ", 
      SuperscriptBox["a", "8"], " ", 
      SuperscriptBox["b", "4"], " ", 
      SuperscriptBox["x", 
       RowBox[{"4", "+", 
        RowBox[{"48", " ", "n"}], "+", 
        RowBox[{"4", " ", "p"}]}]]}], "+", 
     RowBox[{"1716", " ", 
      SuperscriptBox["a", "7"], " ", 
      SuperscriptBox["b", "5"], " ", 
      SuperscriptBox["x", 
       RowBox[{"5", "+", 
        RowBox[{"60", " ", "n"}], "+", 
        RowBox[{"5", " ", "p"}]}]]}], "+", 
     RowBox[{"1716", " ", 
      SuperscriptBox["a", "6"], " ", 
      SuperscriptBox["b", "6"], " ", 
      SuperscriptBox["x", 
       RowBox[{"6", "+", 
        RowBox[{"72", " ", "n"}], "+", 
        RowBox[{"6", " ", "p"}]}]]}], "+", 
     RowBox[{"1287", " ", 
      SuperscriptBox["a", "5"], " ", 
      SuperscriptBox["b", "7"], " ", 
      SuperscriptBox["x", 
       RowBox[{"7", "+", 
        RowBox[{"84", " ", "n"}], "+", 
        RowBox[{"7", " ", "p"}]}]]}], "+", 
     RowBox[{"715", " ", 
      SuperscriptBox["a", "4"], " ", 
      SuperscriptBox["b", "8"], " ", 
      SuperscriptBox["x", 
       RowBox[{"8", "+", 
        RowBox[{"96", " ", "n"}], "+", 
        RowBox[{"8", " ", "p"}]}]]}]}], ")"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{3.4898674317261963`*^9, 3.4898765748993587`*^9, 
  3.4898770010141068`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "24"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", " ", "x"}], "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "38"]}]}], ")"}], "12"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794581114545`*^9}, {3.4442806909341664`*^9, 3.423010973765625*^9}, 
   3.42317151703125*^9, {3.423176171453125*^9, 3.4231761745*^9}, {
   3.489808892686006*^9, 3.489808925636052*^9}, 3.4898765748993587`*^9, 
   3.4898770155065327`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    SuperscriptBox["a", "12"], " ", 
    SuperscriptBox["x", "37"]}], "37"], "+", 
  RowBox[{
   FractionBox["6", "37"], " ", 
   SuperscriptBox["a", "11"], " ", "b", " ", 
   SuperscriptBox["x", "74"]}], "+", 
  RowBox[{
   FractionBox["22", "37"], " ", 
   SuperscriptBox["a", "10"], " ", 
   SuperscriptBox["b", "2"], " ", 
   SuperscriptBox["x", "111"]}], "+", 
  RowBox[{
   FractionBox["55", "37"], " ", 
   SuperscriptBox["a", "9"], " ", 
   SuperscriptBox["b", "3"], " ", 
   SuperscriptBox["x", "148"]}], "+", 
  RowBox[{
   FractionBox["99", "37"], " ", 
   SuperscriptBox["a", "8"], " ", 
   SuperscriptBox["b", "4"], " ", 
   SuperscriptBox["x", "185"]}], "+", 
  RowBox[{
   FractionBox["132", "37"], " ", 
   SuperscriptBox["a", "7"], " ", 
   SuperscriptBox["b", "5"], " ", 
   SuperscriptBox["x", "222"]}], "+", 
  RowBox[{
   FractionBox["132", "37"], " ", 
   SuperscriptBox["a", "6"], " ", 
   SuperscriptBox["b", "6"], " ", 
   SuperscriptBox["x", "259"]}], "+", 
  RowBox[{
   FractionBox["99", "37"], " ", 
   SuperscriptBox["a", "5"], " ", 
   SuperscriptBox["b", "7"], " ", 
   SuperscriptBox["x", "296"]}], "+", 
  RowBox[{
   FractionBox["55", "37"], " ", 
   SuperscriptBox["a", "4"], " ", 
   SuperscriptBox["b", "8"], " ", 
   SuperscriptBox["x", "333"]}], "+", 
  RowBox[{
   FractionBox["22", "37"], " ", 
   SuperscriptBox["a", "3"], " ", 
   SuperscriptBox["b", "9"], " ", 
   SuperscriptBox["x", "370"]}], "+", 
  RowBox[{
   FractionBox["6", "37"], " ", 
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["b", "10"], " ", 
   SuperscriptBox["x", "407"]}], "+", 
  RowBox[{
   FractionBox["1", "37"], " ", "a", " ", 
   SuperscriptBox["b", "11"], " ", 
   SuperscriptBox["x", "444"]}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["b", "12"], " ", 
    SuperscriptBox["x", "481"]}], "481"]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{
  3.489808927136054*^9, 3.489867469915063*^9, 3.4898765748993587`*^9, {
   3.489877017191335*^9, 3.4898770230101457`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " does ",
 StyleBox["not",
  FontSlant->"Italic"],
 " ",
 "know",
 " the rule for arbitrary m, n and p, and needlessly expands the integrand \
when m is a positive integer:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.444322558662424*^9, 3.444322586131923*^9}, {
   3.4466780286625423`*^9, 3.446678029423637*^9}, {3.4466948967576723`*^9, 
   3.42317159478125*^9}, 3.423174910453125*^9, {3.423332331546875*^9, 
   3.423332347125*^9}, {3.423332380203125*^9, 3.42333240928125*^9}, 
   3.423341072625*^9, 3.4561670576790624`*^9, 3.4821759878804445`*^9, 
   3.4821761016640577`*^9, 3.4821761392881584`*^9, 3.482176179285672*^9, 
   3.4821770498975506`*^9, {3.489804505429864*^9, 3.489804512039873*^9}, {
   3.4898045424699154`*^9, 3.4898045431099167`*^9}, {3.4898045772899647`*^9, 
   3.4898046123600135`*^9}, {3.4898048582503576`*^9, 3.489804864160366*^9}, {
   3.4898049421404753`*^9, 3.4898049903205423`*^9}, {3.4898052429608965`*^9, 
   3.489805244530898*^9}, {3.489805282760952*^9, 3.4898052829509525`*^9}, 
   3.489867577243252*^9, {3.4898681378842363`*^9, 3.4898681491006565`*^9}, 
   3.489868184575118*^9, {3.489876050754038*^9, 3.4898760546852446`*^9}, 
   3.489876584789776*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "p"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "*", 
          RowBox[{"x", "^", "n"}]}], "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"m", "*", "n"}], "+", "n", "+", "p", "+", "1"}], 
            ")"}]}]}]}], ")"}], "^", "m"}]}], ",", " ", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794581114545`*^9}, {3.4442806909341664`*^9, 
   3.4442806946094513`*^9}, {3.446684899001605*^9, 3.423011009453125*^9}, 
   3.42317151703125*^9, 3.423175051171875*^9, {3.4231761981875*^9, 
   3.4231762248125*^9}, {3.4898095364769073`*^9, 3.489809557166936*^9}, {
   3.489867636835356*^9, 3.489867654354187*^9}, 3.489876584789776*^9, {
   3.4898770596546097`*^9, 3.4898770684998255`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "p"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", 
        RowBox[{
         RowBox[{"m", " ", "n"}], "+", "n", "+", "p", "+", "1"}]]}]}], ")"}], 
    "m"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.489877802247114*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "p"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "*", 
          RowBox[{"x", "^", "n"}]}], "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"12", "*", "n"}], "+", "n", "+", "p", "+", "1"}], 
            ")"}]}]}]}], ")"}], "^", "12"}]}], ",", " ", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794581114545`*^9}, {3.4442806909341664`*^9, 
   3.4442806946094513`*^9}, {3.446684899001605*^9, 3.423011009453125*^9}, 
   3.42317151703125*^9, 3.423175051171875*^9, {3.4231761981875*^9, 
   3.4231762248125*^9}, {3.4898095364769073`*^9, 3.489809557166936*^9}, {
   3.489867636835356*^9, 3.489867654354187*^9}, 3.489876584789776*^9, {
   3.4898770596546097`*^9, 3.4898770684998255`*^9}, {3.489877154268776*^9, 
   3.4898771619283895`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"13", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"12", " ", "n"}], "+", "p"}], ")"}]}]], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"13", " ", 
     SuperscriptBox["a", "12"], " ", 
     SuperscriptBox["x", 
      RowBox[{"1", "+", 
       RowBox[{"12", " ", "n"}], "+", "p"}]]}], "+", 
    RowBox[{"78", " ", 
     SuperscriptBox["a", "11"], " ", "b", " ", 
     SuperscriptBox["x", 
      RowBox[{"2", "+", 
       RowBox[{"24", " ", "n"}], "+", 
       RowBox[{"2", " ", "p"}]}]]}], "+", 
    RowBox[{"286", " ", 
     SuperscriptBox["a", "10"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["x", 
      RowBox[{"3", "+", 
       RowBox[{"36", " ", "n"}], "+", 
       RowBox[{"3", " ", "p"}]}]]}], "+", 
    RowBox[{"715", " ", 
     SuperscriptBox["a", "9"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["x", 
      RowBox[{"4", "+", 
       RowBox[{"48", " ", "n"}], "+", 
       RowBox[{"4", " ", "p"}]}]]}], "+", 
    RowBox[{"1287", " ", 
     SuperscriptBox["a", "8"], " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["x", 
      RowBox[{"5", "+", 
       RowBox[{"60", " ", "n"}], "+", 
       RowBox[{"5", " ", "p"}]}]]}], "+", 
    RowBox[{"1716", " ", 
     SuperscriptBox["a", "7"], " ", 
     SuperscriptBox["b", "5"], " ", 
     SuperscriptBox["x", 
      RowBox[{"6", "+", 
       RowBox[{"72", " ", "n"}], "+", 
       RowBox[{"6", " ", "p"}]}]]}], "+", 
    RowBox[{"1716", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["b", "6"], " ", 
     SuperscriptBox["x", 
      RowBox[{"7", "+", 
       RowBox[{"84", " ", "n"}], "+", 
       RowBox[{"7", " ", "p"}]}]]}], "+", 
    RowBox[{"1287", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "7"], " ", 
     SuperscriptBox["x", 
      RowBox[{"8", "+", 
       RowBox[{"96", " ", "n"}], "+", 
       RowBox[{"8", " ", "p"}]}]]}], "+", 
    RowBox[{"715", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "8"], " ", 
     SuperscriptBox["x", 
      RowBox[{"9", "+", 
       RowBox[{"108", " ", "n"}], "+", 
       RowBox[{"9", " ", "p"}]}]]}], "+", 
    RowBox[{"286", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "9"], " ", 
     SuperscriptBox["x", 
      RowBox[{"10", "+", 
       RowBox[{"120", " ", "n"}], "+", 
       RowBox[{"10", " ", "p"}]}]]}], "+", 
    RowBox[{"78", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "10"], " ", 
     SuperscriptBox["x", 
      RowBox[{"11", "+", 
       RowBox[{"132", " ", "n"}], "+", 
       RowBox[{"11", " ", "p"}]}]]}], "+", 
    RowBox[{"13", " ", "a", " ", 
     SuperscriptBox["b", "11"], " ", 
     SuperscriptBox["x", 
      RowBox[{"12", "+", 
       RowBox[{"144", " ", "n"}], "+", 
       RowBox[{"12", " ", "p"}]}]]}], "+", 
    RowBox[{
     SuperscriptBox["b", "12"], " ", 
     SuperscriptBox["x", 
      RowBox[{"13", "+", 
       RowBox[{"156", " ", "n"}], "+", 
       RowBox[{"13", " ", "p"}]}]]}]}], ")"}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.489877802247114*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "24"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "*", "x"}], "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "38"}]}]}], ")"}], "^", "12"}]}], ",", " ", "x"}],
     ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794581114545`*^9}, {3.4442806909341664`*^9, 
   3.4442806946094513`*^9}, {3.446684899001605*^9, 3.423011009453125*^9}, 
   3.42317151703125*^9, 3.423175051171875*^9, {3.4231761981875*^9, 
   3.4231762248125*^9}, 3.4898095153568773`*^9, 3.489876584789776*^9, {
   3.489877195624449*^9, 3.489877208369671*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    SuperscriptBox["a", "12"], " ", 
    SuperscriptBox["x", "37"]}], "37"], "+", 
  RowBox[{
   FractionBox["6", "37"], " ", 
   SuperscriptBox["a", "11"], " ", "b", " ", 
   SuperscriptBox["x", "74"]}], "+", 
  RowBox[{
   FractionBox["22", "37"], " ", 
   SuperscriptBox["a", "10"], " ", 
   SuperscriptBox["b", "2"], " ", 
   SuperscriptBox["x", "111"]}], "+", 
  RowBox[{
   FractionBox["55", "37"], " ", 
   SuperscriptBox["a", "9"], " ", 
   SuperscriptBox["b", "3"], " ", 
   SuperscriptBox["x", "148"]}], "+", 
  RowBox[{
   FractionBox["99", "37"], " ", 
   SuperscriptBox["a", "8"], " ", 
   SuperscriptBox["b", "4"], " ", 
   SuperscriptBox["x", "185"]}], "+", 
  RowBox[{
   FractionBox["132", "37"], " ", 
   SuperscriptBox["a", "7"], " ", 
   SuperscriptBox["b", "5"], " ", 
   SuperscriptBox["x", "222"]}], "+", 
  RowBox[{
   FractionBox["132", "37"], " ", 
   SuperscriptBox["a", "6"], " ", 
   SuperscriptBox["b", "6"], " ", 
   SuperscriptBox["x", "259"]}], "+", 
  RowBox[{
   FractionBox["99", "37"], " ", 
   SuperscriptBox["a", "5"], " ", 
   SuperscriptBox["b", "7"], " ", 
   SuperscriptBox["x", "296"]}], "+", 
  RowBox[{
   FractionBox["55", "37"], " ", 
   SuperscriptBox["a", "4"], " ", 
   SuperscriptBox["b", "8"], " ", 
   SuperscriptBox["x", "333"]}], "+", 
  RowBox[{
   FractionBox["22", "37"], " ", 
   SuperscriptBox["a", "3"], " ", 
   SuperscriptBox["b", "9"], " ", 
   SuperscriptBox["x", "370"]}], "+", 
  RowBox[{
   FractionBox["6", "37"], " ", 
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["b", "10"], " ", 
   SuperscriptBox["x", "407"]}], "+", 
  RowBox[{
   FractionBox["1", "37"], " ", "a", " ", 
   SuperscriptBox["b", "11"], " ", 
   SuperscriptBox["x", "444"]}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["b", "12"], " ", 
    SuperscriptBox["x", "481"]}], "481"]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{
  3.489808927136054*^9, 3.489867469915063*^9, 3.4898765748993587`*^9, {
   3.489877017191335*^9, 3.4898770230101457`*^9}, 3.489877802247114*^9}]
}, Closed]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Rational Function Integration Problem 3", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821876372994003`*^9, 3.4821876389718046`*^9}, {3.4821882097225037`*^9, 
   3.4821882312534637`*^9}, 3.482188699757139*^9, {3.489804151269368*^9, 
   3.4898041872394185`*^9}, {3.4898764178694825`*^9, 3.4898764349515123`*^9}, 
   3.4898765960997953`*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"b", "+", 
     RowBox[{"2", " ", "c", " ", "x"}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "m"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.482188189313157*^9, 
   3.489804201579438*^9, 3.489804247789503*^9, 3.489806844603139*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " knows and takes advantage of the general rule for arbitrary m:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443225459641647`*^9, 3.4443225485078225`*^9}, {
   3.4466948911496077`*^9, 3.42301074665625*^9}, 3.42317159478125*^9, {
   3.423174840640625*^9, 3.423174854046875*^9}, {3.4233322945*^9, 
   3.4233323091875*^9}, {3.42333236403125*^9, 3.423332366546875*^9}, {
   3.423332643984375*^9, 3.42333264684375*^9}, 3.423341072609375*^9, 
   3.4561670576690483`*^9, 3.4791559290778675`*^9, 3.482175999467106*^9, {
   3.482176939178344*^9, 3.482176943534608*^9}, 3.4821770265840273`*^9, {
   3.4898048224003077`*^9, 3.4898048266603136`*^9}, {3.4898052234408693`*^9, 
   3.489805239230891*^9}, {3.4898052800709486`*^9, 3.4898052802509484`*^9}, {
   3.489807179413607*^9, 3.489807180423609*^9}, 3.4898795383741636`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"b", "+", 
      RowBox[{"2", " ", "c", " ", "x"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "m"]}], ",", " ", "x"}], 
  "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794213586063`*^9}, {3.4442805438526735`*^9, 3.42301101521875*^9}, 
   3.42317151703125*^9, 3.423175055046875*^9, {3.423176000796875*^9, 
   3.4231760043125*^9}, {3.423176044578125*^9, 3.423176093671875*^9}, 
   3.423176130421875*^9, 3.455314762813277*^9, 3.4898042186094623`*^9, 
   3.4898042925195656`*^9, 3.489806848493144*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", "2"]}]}], ")"}], 
   RowBox[{"1", "+", "m"}]], 
  RowBox[{"1", "+", "m"}]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{3.4898068562431545`*^9, 3.4898795383741636`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"b", "+", 
      RowBox[{"2", " ", "c", " ", "x"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "12"]}], ",", " ", "x"}], 
  "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794213586063`*^9}, {3.4442805438526735`*^9, 3.42301101521875*^9}, 
   3.42317151703125*^9, 3.423175055046875*^9, {3.423176000796875*^9, 
   3.4231760043125*^9}, {3.423176044578125*^9, 3.423176093671875*^9}, 
   3.423176130421875*^9, 3.455314762813277*^9, 3.4898042186094623`*^9, {
   3.4898042925195656`*^9, 3.4898043220896072`*^9}, {3.489804445049779*^9, 
   3.4898044452397795`*^9}, {3.489862567550448*^9, 3.4898625678000484`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "13"], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", "2"]}]}], ")"}], "13"]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.4898043259496126`*^9, 3.489804451399788*^9, 3.489807148393564*^9, {
   3.489862576239663*^9, 3.4898625924324913`*^9}, 3.4898795383741636`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " knows the rule for arbitrary m, but needlessly expands the integrand when \
m is a positive integer:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.444322558662424*^9, 3.444322586131923*^9}, {
   3.4466780286625423`*^9, 3.446678029423637*^9}, {3.4466948967576723`*^9, 
   3.42317159478125*^9}, 3.423174910453125*^9, {3.423332331546875*^9, 
   3.423332347125*^9}, {3.423332380203125*^9, 3.42333240928125*^9}, 
   3.423341072625*^9, 3.4561670576790624`*^9, 3.4821759878804445`*^9, 
   3.4821761016640577`*^9, 3.4821761392881584`*^9, 3.482176179285672*^9, 
   3.4821770498975506`*^9, {3.489804505429864*^9, 3.489804512039873*^9}, {
   3.4898045424699154`*^9, 3.4898045431099167`*^9}, {3.4898045772899647`*^9, 
   3.4898046123600135`*^9}, {3.489805011410572*^9, 3.4898050165905795`*^9}, {
   3.489806991903345*^9, 3.4898069937533474`*^9}, 3.489879548982182*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"b", "+", 
     RowBox[{"2", " ", "c", " ", "x"}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "m"], " ", 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794581114545`*^9}, {3.4442806909341664`*^9, 3.423010973765625*^9}, 
   3.42317151703125*^9, {3.423176171453125*^9, 3.4231761745*^9}, {
   3.4898043594996595`*^9, 3.489804361389662*^9}, {3.489804636640047*^9, 
   3.4898046471400623`*^9}, 3.4898077997044754`*^9, 3.489879548982182*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"a", "+", 
     RowBox[{"x", " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{"c", " ", "x"}]}], ")"}]}]}], ")"}], 
   RowBox[{"1", "+", "m"}]], 
  RowBox[{"1", "+", "m"}]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{3.4898046745301003`*^9, 3.4898078024244795`*^9, 
  3.489879548982182*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"b", "+", 
     RowBox[{"2", " ", "c", " ", "x"}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "12"], " ", 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794581114545`*^9}, {3.4442806909341664`*^9, 3.423010973765625*^9}, 
   3.42317151703125*^9, {3.423176171453125*^9, 3.4231761745*^9}, {
   3.4898043594996595`*^9, 3.489804383259693*^9}, {3.489804425209751*^9, 
   3.4898044253797517`*^9}, {3.489807329273817*^9, 3.4898073295738173`*^9}, 
   3.489879548982182*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["a", "12"], " ", "x", " ", 
   RowBox[{"(", 
    RowBox[{"b", "+", 
     RowBox[{"c", " ", "x"}]}], ")"}]}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["a", "11"], " ", 
   SuperscriptBox["x", "2"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"b", "+", 
      RowBox[{"c", " ", "x"}]}], ")"}], "2"]}], "+", 
  RowBox[{"22", " ", 
   SuperscriptBox["a", "10"], " ", 
   SuperscriptBox["x", "3"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"b", "+", 
      RowBox[{"c", " ", "x"}]}], ")"}], "3"]}], "+", 
  RowBox[{"55", " ", 
   SuperscriptBox["a", "9"], " ", 
   SuperscriptBox["x", "4"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"b", "+", 
      RowBox[{"c", " ", "x"}]}], ")"}], "4"]}], "+", 
  RowBox[{"99", " ", 
   SuperscriptBox["a", "8"], " ", 
   SuperscriptBox["x", "5"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"b", "+", 
      RowBox[{"c", " ", "x"}]}], ")"}], "5"]}], "+", 
  RowBox[{"132", " ", 
   SuperscriptBox["a", "7"], " ", 
   SuperscriptBox["x", "6"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"b", "+", 
      RowBox[{"c", " ", "x"}]}], ")"}], "6"]}], "+", 
  RowBox[{"132", " ", 
   SuperscriptBox["a", "6"], " ", 
   SuperscriptBox["x", "7"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"b", "+", 
      RowBox[{"c", " ", "x"}]}], ")"}], "7"]}], "+", 
  RowBox[{"99", " ", 
   SuperscriptBox["a", "5"], " ", 
   SuperscriptBox["x", "8"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"b", "+", 
      RowBox[{"c", " ", "x"}]}], ")"}], "8"]}], "+", 
  RowBox[{"55", " ", 
   SuperscriptBox["a", "4"], " ", 
   SuperscriptBox["x", "9"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"b", "+", 
      RowBox[{"c", " ", "x"}]}], ")"}], "9"]}], "+", 
  RowBox[{"22", " ", 
   SuperscriptBox["a", "3"], " ", 
   SuperscriptBox["x", "10"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"b", "+", 
      RowBox[{"c", " ", "x"}]}], ")"}], "10"]}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["x", "11"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"b", "+", 
      RowBox[{"c", " ", "x"}]}], ")"}], "11"]}], "+", 
  RowBox[{"a", " ", 
   SuperscriptBox["x", "12"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"b", "+", 
      RowBox[{"c", " ", "x"}]}], ")"}], "12"]}], "+", 
  RowBox[{
   FractionBox["1", "13"], " ", 
   SuperscriptBox["x", "13"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"b", "+", 
      RowBox[{"c", " ", "x"}]}], ")"}], "13"]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{3.489804384079694*^9, 3.4898044262697525`*^9, 
  3.4898073303338184`*^9, 3.489879548982182*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " knows the rule for arbitrary m, but needlessly expands the integrand when \
m is a positive integer:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.444322558662424*^9, 3.444322586131923*^9}, {
   3.4466780286625423`*^9, 3.446678029423637*^9}, {3.4466948967576723`*^9, 
   3.42317159478125*^9}, 3.423174910453125*^9, {3.423332331546875*^9, 
   3.423332347125*^9}, {3.423332380203125*^9, 3.42333240928125*^9}, 
   3.423341072625*^9, 3.4561670576790624`*^9, 3.4821759878804445`*^9, 
   3.4821761016640577`*^9, 3.4821761392881584`*^9, 3.482176179285672*^9, 
   3.4821770498975506`*^9, {3.489804505429864*^9, 3.489804512039873*^9}, {
   3.4898045424699154`*^9, 3.4898045431099167`*^9}, {3.4898045772899647`*^9, 
   3.4898046123600135`*^9}, {3.489805011410572*^9, 3.4898050165905795`*^9}, {
   3.489806991903345*^9, 3.4898069937533474`*^9}, 3.4898657287424035`*^9, 
   3.489879558669799*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{"2", "*", "c", "*", "x"}]}], ")"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "m"}]}], ",", " ", "x"}], 
    ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794581114545`*^9}, {3.4442806909341664`*^9, 
   3.4442806946094513`*^9}, {3.446684899001605*^9, 3.423011009453125*^9}, 
   3.42317151703125*^9, 3.423175051171875*^9, {3.4231761981875*^9, 
   3.4231762248125*^9}, {3.489807746364401*^9, 3.489807766264429*^9}, 
   3.489807823224509*^9, {3.4898648724644985`*^9, 3.4898648854437213`*^9}, {
   3.489865022287162*^9, 3.489865023191963*^9}, 3.489879558669799*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", "2"]}]}], ")"}], 
   RowBox[{"m", "+", "1"}]], 
  RowBox[{"m", "+", "1"}]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.489879558669799*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{"2", "*", "c", "*", "x"}]}], ")"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "12"}]}], ",", " ", "x"}], 
    ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794581114545`*^9}, {3.4442806909341664`*^9, 
   3.4442806946094513`*^9}, {3.446684899001605*^9, 3.423011009453125*^9}, 
   3.42317151703125*^9, 3.423175051171875*^9, {3.4231761981875*^9, 
   3.4231762248125*^9}, {3.489807746364401*^9, 3.489807766264429*^9}, 
   3.489807823224509*^9, {3.4898648724644985`*^9, 3.4898648854437213`*^9}, {
   3.4898649209025836`*^9, 3.4898649211365843`*^9}, {3.489865030336776*^9, 
   3.489865030789177*^9}, {3.4898653414325223`*^9, 3.4898653484369345`*^9}, {
   3.489877861964019*^9, 3.4898778649748244`*^9}, 3.489879558669799*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["a", "12"], " ", "b", " ", "x"}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["a", "11"], " ", 
   SuperscriptBox["b", "2"], " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{
   SuperscriptBox["a", "12"], " ", "c", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"22", " ", 
   SuperscriptBox["a", "10"], " ", 
   SuperscriptBox["b", "3"], " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"12", " ", 
   SuperscriptBox["a", "11"], " ", "b", " ", "c", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"55", " ", 
   SuperscriptBox["a", "9"], " ", 
   SuperscriptBox["b", "4"], " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"66", " ", 
   SuperscriptBox["a", "10"], " ", 
   SuperscriptBox["b", "2"], " ", "c", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["a", "11"], " ", 
   SuperscriptBox["c", "2"], " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"99", " ", 
   SuperscriptBox["a", "8"], " ", 
   SuperscriptBox["b", "5"], " ", 
   SuperscriptBox["x", "5"]}], "+", 
  RowBox[{"220", " ", 
   SuperscriptBox["a", "9"], " ", 
   SuperscriptBox["b", "3"], " ", "c", " ", 
   SuperscriptBox["x", "5"]}], "+", 
  RowBox[{"66", " ", 
   SuperscriptBox["a", "10"], " ", "b", " ", 
   SuperscriptBox["c", "2"], " ", 
   SuperscriptBox["x", "5"]}], "+", 
  RowBox[{"132", " ", 
   SuperscriptBox["a", "7"], " ", 
   SuperscriptBox["b", "6"], " ", 
   SuperscriptBox["x", "6"]}], "+", 
  RowBox[{"495", " ", 
   SuperscriptBox["a", "8"], " ", 
   SuperscriptBox["b", "4"], " ", "c", " ", 
   SuperscriptBox["x", "6"]}], "+", 
  RowBox[{"330", " ", 
   SuperscriptBox["a", "9"], " ", 
   SuperscriptBox["b", "2"], " ", 
   SuperscriptBox["c", "2"], " ", 
   SuperscriptBox["x", "6"]}], "+", 
  RowBox[{"22", " ", 
   SuperscriptBox["a", "10"], " ", 
   SuperscriptBox["c", "3"], " ", 
   SuperscriptBox["x", "6"]}], "+", 
  RowBox[{"132", " ", 
   SuperscriptBox["a", "6"], " ", 
   SuperscriptBox["b", "7"], " ", 
   SuperscriptBox["x", "7"]}], "+", 
  RowBox[{"792", " ", 
   SuperscriptBox["a", "7"], " ", 
   SuperscriptBox["b", "5"], " ", "c", " ", 
   SuperscriptBox["x", "7"]}], "+", 
  RowBox[{"990", " ", 
   SuperscriptBox["a", "8"], " ", 
   SuperscriptBox["b", "3"], " ", 
   SuperscriptBox["c", "2"], " ", 
   SuperscriptBox["x", "7"]}], "+", 
  RowBox[{"220", " ", 
   SuperscriptBox["a", "9"], " ", "b", " ", 
   SuperscriptBox["c", "3"], " ", 
   SuperscriptBox["x", "7"]}], "+", 
  RowBox[{"99", " ", 
   SuperscriptBox["a", "5"], " ", 
   SuperscriptBox["b", "8"], " ", 
   SuperscriptBox["x", "8"]}], "+", 
  RowBox[{"924", " ", 
   SuperscriptBox["a", "6"], " ", 
   SuperscriptBox["b", "6"], " ", "c", " ", 
   SuperscriptBox["x", "8"]}], "+", 
  RowBox[{"1980", " ", 
   SuperscriptBox["a", "7"], " ", 
   SuperscriptBox["b", "4"], " ", 
   SuperscriptBox["c", "2"], " ", 
   SuperscriptBox["x", "8"]}], "+", 
  RowBox[{"990", " ", 
   SuperscriptBox["a", "8"], " ", 
   SuperscriptBox["b", "2"], " ", 
   SuperscriptBox["c", "3"], " ", 
   SuperscriptBox["x", "8"]}], "+", 
  RowBox[{"55", " ", 
   SuperscriptBox["a", "9"], " ", 
   SuperscriptBox["c", "4"], " ", 
   SuperscriptBox["x", "8"]}], "+", 
  RowBox[{"55", " ", 
   SuperscriptBox["a", "4"], " ", 
   SuperscriptBox["b", "9"], " ", 
   SuperscriptBox["x", "9"]}], "+", 
  RowBox[{"792", " ", 
   SuperscriptBox["a", "5"], " ", 
   SuperscriptBox["b", "7"], " ", "c", " ", 
   SuperscriptBox["x", "9"]}], "+", 
  RowBox[{"2772", " ", 
   SuperscriptBox["a", "6"], " ", 
   SuperscriptBox["b", "5"], " ", 
   SuperscriptBox["c", "2"], " ", 
   SuperscriptBox["x", "9"]}], "+", 
  RowBox[{"2640", " ", 
   SuperscriptBox["a", "7"], " ", 
   SuperscriptBox["b", "3"], " ", 
   SuperscriptBox["c", "3"], " ", 
   SuperscriptBox["x", "9"]}], "+", 
  RowBox[{"495", " ", 
   SuperscriptBox["a", "8"], " ", "b", " ", 
   SuperscriptBox["c", "4"], " ", 
   SuperscriptBox["x", "9"]}], "+", 
  RowBox[{"22", " ", 
   SuperscriptBox["a", "3"], " ", 
   SuperscriptBox["b", "10"], " ", 
   SuperscriptBox["x", "10"]}], "+", 
  RowBox[{"495", " ", 
   SuperscriptBox["a", "4"], " ", 
   SuperscriptBox["b", "8"], " ", "c", " ", 
   SuperscriptBox["x", "10"]}], "+", 
  RowBox[{"2772", " ", 
   SuperscriptBox["a", "5"], " ", 
   SuperscriptBox["b", "6"], " ", 
   SuperscriptBox["c", "2"], " ", 
   SuperscriptBox["x", "10"]}], "+", 
  RowBox[{"4620", " ", 
   SuperscriptBox["a", "6"], " ", 
   SuperscriptBox["b", "4"], " ", 
   SuperscriptBox["c", "3"], " ", 
   SuperscriptBox["x", "10"]}], "+", 
  RowBox[{"1980", " ", 
   SuperscriptBox["a", "7"], " ", 
   SuperscriptBox["b", "2"], " ", 
   SuperscriptBox["c", "4"], " ", 
   SuperscriptBox["x", "10"]}], "+", 
  RowBox[{"99", " ", 
   SuperscriptBox["a", "8"], " ", 
   SuperscriptBox["c", "5"], " ", 
   SuperscriptBox["x", "10"]}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["b", "11"], " ", 
   SuperscriptBox["x", "11"]}], "+", 
  RowBox[{"220", " ", 
   SuperscriptBox["a", "3"], " ", 
   SuperscriptBox["b", "9"], " ", "c", " ", 
   SuperscriptBox["x", "11"]}], "+", 
  RowBox[{"1980", " ", 
   SuperscriptBox["a", "4"], " ", 
   SuperscriptBox["b", "7"], " ", 
   SuperscriptBox["c", "2"], " ", 
   SuperscriptBox["x", "11"]}], "+", 
  RowBox[{"5544", " ", 
   SuperscriptBox["a", "5"], " ", 
   SuperscriptBox["b", "5"], " ", 
   SuperscriptBox["c", "3"], " ", 
   SuperscriptBox["x", "11"]}], "+", 
  RowBox[{"4620", " ", 
   SuperscriptBox["a", "6"], " ", 
   SuperscriptBox["b", "3"], " ", 
   SuperscriptBox["c", "4"], " ", 
   SuperscriptBox["x", "11"]}], "+", 
  RowBox[{"792", " ", 
   SuperscriptBox["a", "7"], " ", "b", " ", 
   SuperscriptBox["c", "5"], " ", 
   SuperscriptBox["x", "11"]}], "+", 
  RowBox[{"a", " ", 
   SuperscriptBox["b", "12"], " ", 
   SuperscriptBox["x", "12"]}], "+", 
  RowBox[{"66", " ", 
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["b", "10"], " ", "c", " ", 
   SuperscriptBox["x", "12"]}], "+", 
  RowBox[{"990", " ", 
   SuperscriptBox["a", "3"], " ", 
   SuperscriptBox["b", "8"], " ", 
   SuperscriptBox["c", "2"], " ", 
   SuperscriptBox["x", "12"]}], "+", 
  RowBox[{"4620", " ", 
   SuperscriptBox["a", "4"], " ", 
   SuperscriptBox["b", "6"], " ", 
   SuperscriptBox["c", "3"], " ", 
   SuperscriptBox["x", "12"]}], "+", 
  RowBox[{"6930", " ", 
   SuperscriptBox["a", "5"], " ", 
   SuperscriptBox["b", "4"], " ", 
   SuperscriptBox["c", "4"], " ", 
   SuperscriptBox["x", "12"]}], "+", 
  RowBox[{"2772", " ", 
   SuperscriptBox["a", "6"], " ", 
   SuperscriptBox["b", "2"], " ", 
   SuperscriptBox["c", "5"], " ", 
   SuperscriptBox["x", "12"]}], "+", 
  RowBox[{"132", " ", 
   SuperscriptBox["a", "7"], " ", 
   SuperscriptBox["c", "6"], " ", 
   SuperscriptBox["x", "12"]}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["b", "13"], " ", 
    SuperscriptBox["x", "13"]}], "13"], "+", 
  RowBox[{"12", " ", "a", " ", 
   SuperscriptBox["b", "11"], " ", "c", " ", 
   SuperscriptBox["x", "13"]}], "+", 
  RowBox[{"330", " ", 
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["b", "9"], " ", 
   SuperscriptBox["c", "2"], " ", 
   SuperscriptBox["x", "13"]}], "+", 
  RowBox[{"2640", " ", 
   SuperscriptBox["a", "3"], " ", 
   SuperscriptBox["b", "7"], " ", 
   SuperscriptBox["c", "3"], " ", 
   SuperscriptBox["x", "13"]}], "+", 
  RowBox[{"6930", " ", 
   SuperscriptBox["a", "4"], " ", 
   SuperscriptBox["b", "5"], " ", 
   SuperscriptBox["c", "4"], " ", 
   SuperscriptBox["x", "13"]}], "+", 
  RowBox[{"5544", " ", 
   SuperscriptBox["a", "5"], " ", 
   SuperscriptBox["b", "3"], " ", 
   SuperscriptBox["c", "5"], " ", 
   SuperscriptBox["x", "13"]}], "+", 
  RowBox[{"924", " ", 
   SuperscriptBox["a", "6"], " ", "b", " ", 
   SuperscriptBox["c", "6"], " ", 
   SuperscriptBox["x", "13"]}], "+", 
  RowBox[{
   SuperscriptBox["b", "12"], " ", "c", " ", 
   SuperscriptBox["x", "14"]}], "+", 
  RowBox[{"66", " ", "a", " ", 
   SuperscriptBox["b", "10"], " ", 
   SuperscriptBox["c", "2"], " ", 
   SuperscriptBox["x", "14"]}], "+", 
  RowBox[{"990", " ", 
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["b", "8"], " ", 
   SuperscriptBox["c", "3"], " ", 
   SuperscriptBox["x", "14"]}], "+", 
  RowBox[{"4620", " ", 
   SuperscriptBox["a", "3"], " ", 
   SuperscriptBox["b", "6"], " ", 
   SuperscriptBox["c", "4"], " ", 
   SuperscriptBox["x", "14"]}], "+", 
  RowBox[{"6930", " ", 
   SuperscriptBox["a", "4"], " ", 
   SuperscriptBox["b", "4"], " ", 
   SuperscriptBox["c", "5"], " ", 
   SuperscriptBox["x", "14"]}], "+", 
  RowBox[{"2772", " ", 
   SuperscriptBox["a", "5"], " ", 
   SuperscriptBox["b", "2"], " ", 
   SuperscriptBox["c", "6"], " ", 
   SuperscriptBox["x", "14"]}], "+", 
  RowBox[{"132", " ", 
   SuperscriptBox["a", "6"], " ", 
   SuperscriptBox["c", "7"], " ", 
   SuperscriptBox["x", "14"]}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["b", "11"], " ", 
   SuperscriptBox["c", "2"], " ", 
   SuperscriptBox["x", "15"]}], "+", 
  RowBox[{"220", " ", "a", " ", 
   SuperscriptBox["b", "9"], " ", 
   SuperscriptBox["c", "3"], " ", 
   SuperscriptBox["x", "15"]}], "+", 
  RowBox[{"1980", " ", 
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["b", "7"], " ", 
   SuperscriptBox["c", "4"], " ", 
   SuperscriptBox["x", "15"]}], "+", 
  RowBox[{"5544", " ", 
   SuperscriptBox["a", "3"], " ", 
   SuperscriptBox["b", "5"], " ", 
   SuperscriptBox["c", "5"], " ", 
   SuperscriptBox["x", "15"]}], "+", 
  RowBox[{"4620", " ", 
   SuperscriptBox["a", "4"], " ", 
   SuperscriptBox["b", "3"], " ", 
   SuperscriptBox["c", "6"], " ", 
   SuperscriptBox["x", "15"]}], "+", 
  RowBox[{"792", " ", 
   SuperscriptBox["a", "5"], " ", "b", " ", 
   SuperscriptBox["c", "7"], " ", 
   SuperscriptBox["x", "15"]}], "+", 
  RowBox[{"22", " ", 
   SuperscriptBox["b", "10"], " ", 
   SuperscriptBox["c", "3"], " ", 
   SuperscriptBox["x", "16"]}], "+", 
  RowBox[{"495", " ", "a", " ", 
   SuperscriptBox["b", "8"], " ", 
   SuperscriptBox["c", "4"], " ", 
   SuperscriptBox["x", "16"]}], "+", 
  RowBox[{"2772", " ", 
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["b", "6"], " ", 
   SuperscriptBox["c", "5"], " ", 
   SuperscriptBox["x", "16"]}], "+", 
  RowBox[{"4620", " ", 
   SuperscriptBox["a", "3"], " ", 
   SuperscriptBox["b", "4"], " ", 
   SuperscriptBox["c", "6"], " ", 
   SuperscriptBox["x", "16"]}], "+", 
  RowBox[{"1980", " ", 
   SuperscriptBox["a", "4"], " ", 
   SuperscriptBox["b", "2"], " ", 
   SuperscriptBox["c", "7"], " ", 
   SuperscriptBox["x", "16"]}], "+", 
  RowBox[{"99", " ", 
   SuperscriptBox["a", "5"], " ", 
   SuperscriptBox["c", "8"], " ", 
   SuperscriptBox["x", "16"]}], "+", 
  RowBox[{"55", " ", 
   SuperscriptBox["b", "9"], " ", 
   SuperscriptBox["c", "4"], " ", 
   SuperscriptBox["x", "17"]}], "+", 
  RowBox[{"792", " ", "a", " ", 
   SuperscriptBox["b", "7"], " ", 
   SuperscriptBox["c", "5"], " ", 
   SuperscriptBox["x", "17"]}], "+", 
  RowBox[{"2772", " ", 
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["b", "5"], " ", 
   SuperscriptBox["c", "6"], " ", 
   SuperscriptBox["x", "17"]}], "+", 
  RowBox[{"2640", " ", 
   SuperscriptBox["a", "3"], " ", 
   SuperscriptBox["b", "3"], " ", 
   SuperscriptBox["c", "7"], " ", 
   SuperscriptBox["x", "17"]}], "+", 
  RowBox[{"495", " ", 
   SuperscriptBox["a", "4"], " ", "b", " ", 
   SuperscriptBox["c", "8"], " ", 
   SuperscriptBox["x", "17"]}], "+", 
  RowBox[{"99", " ", 
   SuperscriptBox["b", "8"], " ", 
   SuperscriptBox["c", "5"], " ", 
   SuperscriptBox["x", "18"]}], "+", 
  RowBox[{"924", " ", "a", " ", 
   SuperscriptBox["b", "6"], " ", 
   SuperscriptBox["c", "6"], " ", 
   SuperscriptBox["x", "18"]}], "+", 
  RowBox[{"1980", " ", 
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["b", "4"], " ", 
   SuperscriptBox["c", "7"], " ", 
   SuperscriptBox["x", "18"]}], "+", 
  RowBox[{"990", " ", 
   SuperscriptBox["a", "3"], " ", 
   SuperscriptBox["b", "2"], " ", 
   SuperscriptBox["c", "8"], " ", 
   SuperscriptBox["x", "18"]}], "+", 
  RowBox[{"55", " ", 
   SuperscriptBox["a", "4"], " ", 
   SuperscriptBox["c", "9"], " ", 
   SuperscriptBox["x", "18"]}], "+", 
  RowBox[{"132", " ", 
   SuperscriptBox["b", "7"], " ", 
   SuperscriptBox["c", "6"], " ", 
   SuperscriptBox["x", "19"]}], "+", 
  RowBox[{"792", " ", "a", " ", 
   SuperscriptBox["b", "5"], " ", 
   SuperscriptBox["c", "7"], " ", 
   SuperscriptBox["x", "19"]}], "+", 
  RowBox[{"990", " ", 
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["b", "3"], " ", 
   SuperscriptBox["c", "8"], " ", 
   SuperscriptBox["x", "19"]}], "+", 
  RowBox[{"220", " ", 
   SuperscriptBox["a", "3"], " ", "b", " ", 
   SuperscriptBox["c", "9"], " ", 
   SuperscriptBox["x", "19"]}], "+", 
  RowBox[{"132", " ", 
   SuperscriptBox["b", "6"], " ", 
   SuperscriptBox["c", "7"], " ", 
   SuperscriptBox["x", "20"]}], "+", 
  RowBox[{"495", " ", "a", " ", 
   SuperscriptBox["b", "4"], " ", 
   SuperscriptBox["c", "8"], " ", 
   SuperscriptBox["x", "20"]}], "+", 
  RowBox[{"330", " ", 
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["b", "2"], " ", 
   SuperscriptBox["c", "9"], " ", 
   SuperscriptBox["x", "20"]}], "+", 
  RowBox[{"22", " ", 
   SuperscriptBox["a", "3"], " ", 
   SuperscriptBox["c", "10"], " ", 
   SuperscriptBox["x", "20"]}], "+", 
  RowBox[{"99", " ", 
   SuperscriptBox["b", "5"], " ", 
   SuperscriptBox["c", "8"], " ", 
   SuperscriptBox["x", "21"]}], "+", 
  RowBox[{"220", " ", "a", " ", 
   SuperscriptBox["b", "3"], " ", 
   SuperscriptBox["c", "9"], " ", 
   SuperscriptBox["x", "21"]}], "+", 
  RowBox[{"66", " ", 
   SuperscriptBox["a", "2"], " ", "b", " ", 
   SuperscriptBox["c", "10"], " ", 
   SuperscriptBox["x", "21"]}], "+", 
  RowBox[{"55", " ", 
   SuperscriptBox["b", "4"], " ", 
   SuperscriptBox["c", "9"], " ", 
   SuperscriptBox["x", "22"]}], "+", 
  RowBox[{"66", " ", "a", " ", 
   SuperscriptBox["b", "2"], " ", 
   SuperscriptBox["c", "10"], " ", 
   SuperscriptBox["x", "22"]}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["c", "11"], " ", 
   SuperscriptBox["x", "22"]}], "+", 
  RowBox[{"22", " ", 
   SuperscriptBox["b", "3"], " ", 
   SuperscriptBox["c", "10"], " ", 
   SuperscriptBox["x", "23"]}], "+", 
  RowBox[{"12", " ", "a", " ", "b", " ", 
   SuperscriptBox["c", "11"], " ", 
   SuperscriptBox["x", "23"]}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["b", "2"], " ", 
   SuperscriptBox["c", "11"], " ", 
   SuperscriptBox["x", "24"]}], "+", 
  RowBox[{"a", " ", 
   SuperscriptBox["c", "12"], " ", 
   SuperscriptBox["x", "24"]}], "+", 
  RowBox[{"b", " ", 
   SuperscriptBox["c", "12"], " ", 
   SuperscriptBox["x", "25"]}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["c", "13"], " ", 
    SuperscriptBox["x", "26"]}], "13"]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.4898653802141905`*^9, 3.489879558669799*^9}]
}, Closed]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Rational Function Integration Problem 4", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821876372994003`*^9, 3.4821876389718046`*^9}, {3.4821882097225037`*^9, 
   3.482188239184869*^9}, 3.482188702621258*^9, {3.4898041565793753`*^9, 
   3.4898041665693893`*^9}, 3.489865975316437*^9, 3.489888397413977*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], 
    RowBox[{"n", "-", "1"}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "n"]}]}], ")"}], "m"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881769654016`*^9, {
   3.489877972537013*^9, 3.489877996093055*^9}, 3.4898781923101993`*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " knows and takes advantage of the general rule for arbitrary m and n:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443225459641647`*^9, 3.4443225485078225`*^9}, {
   3.4466948911496077`*^9, 3.42301074665625*^9}, 3.42317159478125*^9, {
   3.423174840640625*^9, 3.423174854046875*^9}, {3.4233322945*^9, 
   3.4233323091875*^9}, {3.42333236403125*^9, 3.423332366546875*^9}, {
   3.423332643984375*^9, 3.42333264684375*^9}, 3.423341072609375*^9, 
   3.4561670576690483`*^9, 3.4791559290778675`*^9, 3.482175999467106*^9, {
   3.482176939178344*^9, 3.482176943534608*^9}, 3.4821770265840273`*^9, {
   3.4898048224003077`*^9, 3.4898048266603136`*^9}, {3.4898052234408693`*^9, 
   3.489805239230891*^9}, {3.4898052800709486`*^9, 3.4898052802509484`*^9}, 
   3.48987627971564*^9, 3.4898763255641203`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], 
     RowBox[{"n", "-", "1"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}], "n"]}]}], ")"}], "m"]}], ",", 
   " ", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794213586063`*^9}, {3.4442805438526735`*^9, 3.42301101521875*^9}, 
   3.42317151703125*^9, 3.423175055046875*^9, {3.423176000796875*^9, 
   3.4231760043125*^9}, {3.423176044578125*^9, 3.423176093671875*^9}, 
   3.423176130421875*^9, {3.423176981671875*^9, 3.4231769880625*^9}, 
   3.4898780169346914`*^9, 3.489878228861064*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "n"]}]}], ")"}], 
   RowBox[{"1", "+", "m"}]], 
  RowBox[{"b", " ", "d", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "m"}], ")"}], " ", "n"}]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{3.4898780180422935`*^9, 3.4898782861443644`*^9, 
  3.489879597841468*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], 
     RowBox[{"n", "-", "1"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}], "n"]}]}], ")"}], "8"]}], ",", 
   " ", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794213586063`*^9}, {3.4442805438526735`*^9, 3.42301101521875*^9}, 
   3.42317151703125*^9, 3.423175055046875*^9, {3.423176000796875*^9, 
   3.4231760043125*^9}, {3.423176044578125*^9, 3.423176093671875*^9}, 
   3.423176130421875*^9, {3.423176981671875*^9, 3.4231769880625*^9}, 
   3.4898780169346914`*^9, 3.489878228861064*^9, {3.4898782999815884`*^9, 
   3.4898783040375957`*^9}, {3.4898784401322346`*^9, 3.489878440428635*^9}, 
   3.489878560221246*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "n"]}]}], ")"}], "9"], 
  RowBox[{"9", " ", "b", " ", "d", " ", "n"}]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{3.4898783048331966`*^9, 3.4898784410838366`*^9, 
  3.4898785658372555`*^9, 3.489879597841468*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}], "3"]}]}], ")"}], "8"]}], ",", 
   " ", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794213586063`*^9}, {3.4442805438526735`*^9, 3.42301101521875*^9}, 
   3.42317151703125*^9, 3.423175055046875*^9, {3.423176000796875*^9, 
   3.4231760043125*^9}, {3.423176044578125*^9, 3.423176093671875*^9}, 
   3.423176130421875*^9, {3.423176981671875*^9, 3.4231769880625*^9}, 
   3.4898780169346914`*^9, 3.489878228861064*^9, {3.4898782999815884`*^9, 
   3.4898783206048245`*^9}, {3.4898784441414413`*^9, 3.489878444406642*^9}, 
   3.4898785617968483`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "3"]}]}], ")"}], "9"], 
  RowBox[{"27", " ", "b", " ", "d"}]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{3.4898783216500263`*^9, 3.4898784450306435`*^9, 
  3.489878563372451*^9, 3.489879597841468*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " knows the rule for arbitrary m and n, but needlessly expands the integrand \
when m is a positive integer:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.444322558662424*^9, 3.444322586131923*^9}, {
   3.4466780286625423`*^9, 3.446678029423637*^9}, {3.4466948967576723`*^9, 
   3.42317159478125*^9}, 3.423174910453125*^9, {3.423332331546875*^9, 
   3.423332347125*^9}, {3.423332380203125*^9, 3.42333240928125*^9}, 
   3.423341072625*^9, 3.4561670576790624`*^9, 3.4821759878804445`*^9, 
   3.4821761016640577`*^9, 3.4821761392881584`*^9, 3.482176179285672*^9, 
   3.4821770498975506`*^9, {3.489804505429864*^9, 3.489804512039873*^9}, {
   3.4898045424699154`*^9, 3.4898045431099167`*^9}, {3.4898045772899647`*^9, 
   3.4898046123600135`*^9}, {3.4898048582503576`*^9, 3.489804864160366*^9}, {
   3.4898049421404753`*^9, 3.4898049903205423`*^9}, {3.4898052429608965`*^9, 
   3.489805244530898*^9}, {3.489805282760952*^9, 3.4898052829509525`*^9}, 
   3.48987627971564*^9, 3.4898763360473385`*^9, 3.4898801008955517`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], 
    RowBox[{"n", "-", "1"}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "n"]}]}], ")"}], "m"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794581114545`*^9}, {3.4442806909341664`*^9, 3.423010973765625*^9}, 
   3.42317151703125*^9, {3.423176171453125*^9, 3.4231761745*^9}, {
   3.423177021875*^9, 3.42317702465625*^9}, {3.489808032144801*^9, 
   3.4898081031949005`*^9}, 3.4898783820533323`*^9, 3.4898796056258817`*^9, 
   3.4898801008955517`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "n"]}]}], ")"}], 
   RowBox[{"1", "+", "m"}]], 
  RowBox[{
   RowBox[{"b", " ", "d", " ", "n"}], "+", 
   RowBox[{"b", " ", "d", " ", "m", " ", "n"}]}]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.489808036084807*^9, 3.4898081095049095`*^9}, 
   3.4898783838005357`*^9, 3.4898796056258817`*^9, 3.4898801008955517`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], 
    RowBox[{"n", "-", "1"}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "n"]}]}], ")"}], "8"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794581114545`*^9}, {3.4442806909341664`*^9, 3.423010973765625*^9}, 
   3.42317151703125*^9, {3.423176171453125*^9, 3.4231761745*^9}, {
   3.423177021875*^9, 3.42317702465625*^9}, {3.489808032144801*^9, 
   3.4898081031949005`*^9}, {3.4898783820533323`*^9, 3.48987839755976*^9}, {
   3.489878429118615*^9, 3.4898784294462156`*^9}, 3.489878540690011*^9, 
   3.4898796056258817`*^9, 3.4898801008955517`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"9", " ", 
      SuperscriptBox["c", "8"]}], "+", 
     RowBox[{"36", " ", 
      SuperscriptBox["c", "7"], " ", "d", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], "+", 
     RowBox[{"84", " ", 
      SuperscriptBox["c", "6"], " ", 
      SuperscriptBox["d", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], 
       RowBox[{"2", " ", "n"}]]}], "+", 
     RowBox[{"126", " ", 
      SuperscriptBox["c", "5"], " ", 
      SuperscriptBox["d", "3"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], 
       RowBox[{"3", " ", "n"}]]}], "+", 
     RowBox[{"126", " ", 
      SuperscriptBox["c", "4"], " ", 
      SuperscriptBox["d", "4"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], 
       RowBox[{"4", " ", "n"}]]}], "+", 
     RowBox[{"84", " ", 
      SuperscriptBox["c", "3"], " ", 
      SuperscriptBox["d", "5"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], 
       RowBox[{"5", " ", "n"}]]}], "+", 
     RowBox[{"36", " ", 
      SuperscriptBox["c", "2"], " ", 
      SuperscriptBox["d", "6"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], 
       RowBox[{"6", " ", "n"}]]}], "+", 
     RowBox[{"9", " ", "c", " ", 
      SuperscriptBox["d", "7"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], 
       RowBox[{"7", " ", "n"}]]}], "+", 
     RowBox[{
      SuperscriptBox["d", "8"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], 
       RowBox[{"8", " ", "n"}]]}]}], ")"}]}], 
  RowBox[{"9", " ", "b", " ", "n"}]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.489878398214961*^9, 3.4898784302418175`*^9, 
  3.4898785414544125`*^9, 3.4898796056258817`*^9, 3.4898801008955517`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], "2"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "3"]}]}], ")"}], "8"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794581114545`*^9}, {3.4442806909341664`*^9, 3.423010973765625*^9}, 
   3.42317151703125*^9, {3.423176171453125*^9, 3.4231761745*^9}, {
   3.423177021875*^9, 3.42317702465625*^9}, {3.489808032144801*^9, 
   3.4898081031949005`*^9}, {3.4898783820533323`*^9, 3.48987839755976*^9}, {
   3.489878429118615*^9, 3.489878481519107*^9}, {3.489878524637583*^9, 
   3.489878535932003*^9}, {3.489878582092484*^9, 3.489878582872485*^9}, 
   3.4898796056258817`*^9, 3.4898801008955517`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", "d"}]}], ")"}], "8"], " ", "x"}], "+", 
  RowBox[{"a", " ", "b", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", "d"}]}], ")"}], "7"], " ", 
   RowBox[{"(", 
    RowBox[{"c", "+", 
     RowBox[{"13", " ", 
      SuperscriptBox["a", "3"], " ", "d"}]}], ")"}], " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{
   FractionBox["1", "3"], " ", 
   SuperscriptBox["b", "2"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", "d"}]}], ")"}], "6"], " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["c", "2"], "+", 
     RowBox[{"74", " ", 
      SuperscriptBox["a", "3"], " ", "c", " ", "d"}], "+", 
     RowBox[{"325", " ", 
      SuperscriptBox["a", "6"], " ", 
      SuperscriptBox["d", "2"]}]}], ")"}], " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["b", "3"], " ", "d", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", "d"}]}], ")"}], "5"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"10", " ", 
      SuperscriptBox["c", "2"]}], "+", 
     RowBox[{"146", " ", 
      SuperscriptBox["a", "3"], " ", "c", " ", "d"}], "+", 
     RowBox[{"325", " ", 
      SuperscriptBox["a", "6"], " ", 
      SuperscriptBox["d", "2"]}]}], ")"}], " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"2", " ", "a", " ", 
   SuperscriptBox["b", "4"], " ", "d", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", "d"}]}], ")"}], "4"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"4", " ", 
      SuperscriptBox["c", "3"]}], "+", 
     RowBox[{"180", " ", 
      SuperscriptBox["a", "3"], " ", 
      SuperscriptBox["c", "2"], " ", "d"}], "+", 
     RowBox[{"1104", " ", 
      SuperscriptBox["a", "6"], " ", "c", " ", 
      SuperscriptBox["d", "2"]}], "+", 
     RowBox[{"1495", " ", 
      SuperscriptBox["a", "9"], " ", 
      SuperscriptBox["d", "3"]}]}], ")"}], " ", 
   SuperscriptBox["x", "5"]}], "+", 
  RowBox[{
   FractionBox["2", "3"], " ", 
   SuperscriptBox["b", "5"], " ", "d", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", "d"}]}], ")"}], "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["c", "4"]}], "+", 
     RowBox[{"386", " ", 
      SuperscriptBox["a", "3"], " ", 
      SuperscriptBox["c", "3"], " ", "d"}], "+", 
     RowBox[{"5304", " ", 
      SuperscriptBox["a", "6"], " ", 
      SuperscriptBox["c", "2"], " ", 
      SuperscriptBox["d", "2"]}], "+", 
     RowBox[{"17963", " ", 
      SuperscriptBox["a", "9"], " ", "c", " ", 
      SuperscriptBox["d", "3"]}], "+", 
     RowBox[{"16445", " ", 
      SuperscriptBox["a", "12"], " ", 
      SuperscriptBox["d", "4"]}]}], ")"}], " ", 
   SuperscriptBox["x", "6"]}], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["b", "6"], " ", 
   SuperscriptBox["d", "2"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", "d"}]}], ")"}], "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"56", " ", 
      SuperscriptBox["c", "4"]}], "+", 
     RowBox[{"1736", " ", 
      SuperscriptBox["a", "3"], " ", 
      SuperscriptBox["c", "3"], " ", "d"}], "+", 
     RowBox[{"11487", " ", 
      SuperscriptBox["a", "6"], " ", 
      SuperscriptBox["c", "2"], " ", 
      SuperscriptBox["d", "2"]}], "+", 
     RowBox[{"24794", " ", 
      SuperscriptBox["a", "9"], " ", "c", " ", 
      SuperscriptBox["d", "3"]}], "+", 
     RowBox[{"16445", " ", 
      SuperscriptBox["a", "12"], " ", 
      SuperscriptBox["d", "4"]}]}], ")"}], " ", 
   SuperscriptBox["x", "7"]}], "+", 
  RowBox[{"a", " ", 
   SuperscriptBox["b", "7"], " ", 
   SuperscriptBox["d", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"28", " ", 
      SuperscriptBox["c", "6"]}], "+", 
     RowBox[{"2310", " ", 
      SuperscriptBox["a", "3"], " ", 
      SuperscriptBox["c", "5"], " ", "d"}], "+", 
     RowBox[{"30030", " ", 
      SuperscriptBox["a", "6"], " ", 
      SuperscriptBox["c", "4"], " ", 
      SuperscriptBox["d", "2"]}], "+", 
     RowBox[{"136136", " ", 
      SuperscriptBox["a", "9"], " ", 
      SuperscriptBox["c", "3"], " ", 
      SuperscriptBox["d", "3"]}], "+", 
     RowBox[{"271320", " ", 
      SuperscriptBox["a", "12"], " ", 
      SuperscriptBox["c", "2"], " ", 
      SuperscriptBox["d", "4"]}], "+", 
     RowBox[{"245157", " ", 
      SuperscriptBox["a", "15"], " ", "c", " ", 
      SuperscriptBox["d", "5"]}], "+", 
     RowBox[{"82225", " ", 
      SuperscriptBox["a", "18"], " ", 
      SuperscriptBox["d", "6"]}]}], ")"}], " ", 
   SuperscriptBox["x", "8"]}], "+", 
  RowBox[{
   FractionBox["1", "9"], " ", 
   SuperscriptBox["b", "8"], " ", 
   SuperscriptBox["d", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"28", " ", 
      SuperscriptBox["c", "6"]}], "+", 
     RowBox[{"9240", " ", 
      SuperscriptBox["a", "3"], " ", 
      SuperscriptBox["c", "5"], " ", "d"}], "+", 
     RowBox[{"210210", " ", 
      SuperscriptBox["a", "6"], " ", 
      SuperscriptBox["c", "4"], " ", 
      SuperscriptBox["d", "2"]}], "+", 
     RowBox[{"1361360", " ", 
      SuperscriptBox["a", "9"], " ", 
      SuperscriptBox["c", "3"], " ", 
      SuperscriptBox["d", "3"]}], "+", 
     RowBox[{"3527160", " ", 
      SuperscriptBox["a", "12"], " ", 
      SuperscriptBox["c", "2"], " ", 
      SuperscriptBox["d", "4"]}], "+", 
     RowBox[{"3922512", " ", 
      SuperscriptBox["a", "15"], " ", "c", " ", 
      SuperscriptBox["d", "5"]}], "+", 
     RowBox[{"1562275", " ", 
      SuperscriptBox["a", "18"], " ", 
      SuperscriptBox["d", "6"]}]}], ")"}], " ", 
   SuperscriptBox["x", "9"]}], "+", 
  RowBox[{
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["b", "9"], " ", 
   SuperscriptBox["d", "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"308", " ", 
      SuperscriptBox["c", "5"]}], "+", 
     RowBox[{"14014", " ", 
      SuperscriptBox["a", "3"], " ", 
      SuperscriptBox["c", "4"], " ", "d"}], "+", 
     RowBox[{"136136", " ", 
      SuperscriptBox["a", "6"], " ", 
      SuperscriptBox["c", "3"], " ", 
      SuperscriptBox["d", "2"]}], "+", 
     RowBox[{"470288", " ", 
      SuperscriptBox["a", "9"], " ", 
      SuperscriptBox["c", "2"], " ", 
      SuperscriptBox["d", "3"]}], "+", 
     RowBox[{"653752", " ", 
      SuperscriptBox["a", "12"], " ", "c", " ", 
      SuperscriptBox["d", "4"]}], "+", 
     RowBox[{"312455", " ", 
      SuperscriptBox["a", "15"], " ", 
      SuperscriptBox["d", "5"]}]}], ")"}], " ", 
   SuperscriptBox["x", "10"]}], "+", 
  RowBox[{"a", " ", 
   SuperscriptBox["b", "10"], " ", 
   SuperscriptBox["d", "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"56", " ", 
      SuperscriptBox["c", "5"]}], "+", 
     RowBox[{"6370", " ", 
      SuperscriptBox["a", "3"], " ", 
      SuperscriptBox["c", "4"], " ", "d"}], "+", 
     RowBox[{"99008", " ", 
      SuperscriptBox["a", "6"], " ", 
      SuperscriptBox["c", "3"], " ", 
      SuperscriptBox["d", "2"]}], "+", 
     RowBox[{"470288", " ", 
      SuperscriptBox["a", "9"], " ", 
      SuperscriptBox["c", "2"], " ", 
      SuperscriptBox["d", "3"]}], "+", 
     RowBox[{"832048", " ", 
      SuperscriptBox["a", "12"], " ", "c", " ", 
      SuperscriptBox["d", "4"]}], "+", 
     RowBox[{"482885", " ", 
      SuperscriptBox["a", "15"], " ", 
      SuperscriptBox["d", "5"]}]}], ")"}], " ", 
   SuperscriptBox["x", "11"]}], "+", 
  RowBox[{
   FractionBox["2", "3"], " ", 
   SuperscriptBox["b", "11"], " ", 
   SuperscriptBox["d", "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"7", " ", 
      SuperscriptBox["c", "5"]}], "+", 
     RowBox[{"3185", " ", 
      SuperscriptBox["a", "3"], " ", 
      SuperscriptBox["c", "4"], " ", "d"}], "+", 
     RowBox[{"86632", " ", 
      SuperscriptBox["a", "6"], " ", 
      SuperscriptBox["c", "3"], " ", 
      SuperscriptBox["d", "2"]}], "+", 
     RowBox[{"587860", " ", 
      SuperscriptBox["a", "9"], " ", 
      SuperscriptBox["c", "2"], " ", 
      SuperscriptBox["d", "3"]}], "+", 
     RowBox[{"1352078", " ", 
      SuperscriptBox["a", "12"], " ", "c", " ", 
      SuperscriptBox["d", "4"]}], "+", 
     RowBox[{"965770", " ", 
      SuperscriptBox["a", "15"], " ", 
      SuperscriptBox["d", "5"]}]}], ")"}], " ", 
   SuperscriptBox["x", "12"]}], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["b", "12"], " ", 
   SuperscriptBox["d", "4"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"245", " ", 
      SuperscriptBox["c", "4"]}], "+", 
     RowBox[{"13328", " ", 
      SuperscriptBox["a", "3"], " ", 
      SuperscriptBox["c", "3"], " ", "d"}], "+", 
     RowBox[{"135660", " ", 
      SuperscriptBox["a", "6"], " ", 
      SuperscriptBox["c", "2"], " ", 
      SuperscriptBox["d", "2"]}], "+", 
     RowBox[{"416024", " ", 
      SuperscriptBox["a", "9"], " ", "c", " ", 
      SuperscriptBox["d", "3"]}], "+", 
     RowBox[{"371450", " ", 
      SuperscriptBox["a", "12"], " ", 
      SuperscriptBox["d", "4"]}]}], ")"}], " ", 
   SuperscriptBox["x", "13"]}], "+", 
  RowBox[{"2", " ", "a", " ", 
   SuperscriptBox["b", "13"], " ", 
   SuperscriptBox["d", "4"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"35", " ", 
      SuperscriptBox["c", "4"]}], "+", 
     RowBox[{"4760", " ", 
      SuperscriptBox["a", "3"], " ", 
      SuperscriptBox["c", "3"], " ", "d"}], "+", 
     RowBox[{"77520", " ", 
      SuperscriptBox["a", "6"], " ", 
      SuperscriptBox["c", "2"], " ", 
      SuperscriptBox["d", "2"]}], "+", 
     RowBox[{"326876", " ", 
      SuperscriptBox["a", "9"], " ", "c", " ", 
      SuperscriptBox["d", "3"]}], "+", 
     RowBox[{"371450", " ", 
      SuperscriptBox["a", "12"], " ", 
      SuperscriptBox["d", "4"]}]}], ")"}], " ", 
   SuperscriptBox["x", "14"]}], "+", 
  RowBox[{
   FractionBox["2", "3"], " ", 
   SuperscriptBox["b", "14"], " ", 
   SuperscriptBox["d", "4"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"7", " ", 
      SuperscriptBox["c", "4"]}], "+", 
     RowBox[{"3808", " ", 
      SuperscriptBox["a", "3"], " ", 
      SuperscriptBox["c", "3"], " ", "d"}], "+", 
     RowBox[{"108528", " ", 
      SuperscriptBox["a", "6"], " ", 
      SuperscriptBox["c", "2"], " ", 
      SuperscriptBox["d", "2"]}], "+", 
     RowBox[{"653752", " ", 
      SuperscriptBox["a", "9"], " ", "c", " ", 
      SuperscriptBox["d", "3"]}], "+", 
     RowBox[{"965770", " ", 
      SuperscriptBox["a", "12"], " ", 
      SuperscriptBox["d", "4"]}]}], ")"}], " ", 
   SuperscriptBox["x", "15"]}], "+", 
  RowBox[{"17", " ", 
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["b", "15"], " ", 
   SuperscriptBox["d", "5"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"28", " ", 
      SuperscriptBox["c", "3"]}], "+", 
     RowBox[{"1596", " ", 
      SuperscriptBox["a", "3"], " ", 
      SuperscriptBox["c", "2"], " ", "d"}], "+", 
     RowBox[{"14421", " ", 
      SuperscriptBox["a", "6"], " ", "c", " ", 
      SuperscriptBox["d", "2"]}], "+", 
     RowBox[{"28405", " ", 
      SuperscriptBox["a", "9"], " ", 
      SuperscriptBox["d", "3"]}]}], ")"}], " ", 
   SuperscriptBox["x", "16"]}], "+", 
  RowBox[{"a", " ", 
   SuperscriptBox["b", "16"], " ", 
   SuperscriptBox["d", "5"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"56", " ", 
      SuperscriptBox["c", "3"]}], "+", 
     RowBox[{"7980", " ", 
      SuperscriptBox["a", "3"], " ", 
      SuperscriptBox["c", "2"], " ", "d"}], "+", 
     RowBox[{"115368", " ", 
      SuperscriptBox["a", "6"], " ", "c", " ", 
      SuperscriptBox["d", "2"]}], "+", 
     RowBox[{"312455", " ", 
      SuperscriptBox["a", "9"], " ", 
      SuperscriptBox["d", "3"]}]}], ")"}], " ", 
   SuperscriptBox["x", "17"]}], "+", 
  RowBox[{
   FractionBox["1", "9"], " ", 
   SuperscriptBox["b", "17"], " ", 
   SuperscriptBox["d", "5"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"28", " ", 
      SuperscriptBox["c", "3"]}], "+", 
     RowBox[{"15960", " ", 
      SuperscriptBox["a", "3"], " ", 
      SuperscriptBox["c", "2"], " ", "d"}], "+", 
     RowBox[{"403788", " ", 
      SuperscriptBox["a", "6"], " ", "c", " ", 
      SuperscriptBox["d", "2"]}], "+", 
     RowBox[{"1562275", " ", 
      SuperscriptBox["a", "9"], " ", 
      SuperscriptBox["d", "3"]}]}], ")"}], " ", 
   SuperscriptBox["x", "18"]}], "+", 
  RowBox[{
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["b", "18"], " ", 
   SuperscriptBox["d", "6"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"280", " ", 
      SuperscriptBox["c", "2"]}], "+", 
     RowBox[{"14168", " ", 
      SuperscriptBox["a", "3"], " ", "c", " ", "d"}], "+", 
     RowBox[{"82225", " ", 
      SuperscriptBox["a", "6"], " ", 
      SuperscriptBox["d", "2"]}]}], ")"}], " ", 
   SuperscriptBox["x", "19"]}], "+", 
  RowBox[{"2", " ", "a", " ", 
   SuperscriptBox["b", "19"], " ", 
   SuperscriptBox["d", "6"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"14", " ", 
      SuperscriptBox["c", "2"]}], "+", 
     RowBox[{"1771", " ", 
      SuperscriptBox["a", "3"], " ", "c", " ", "d"}], "+", 
     RowBox[{"16445", " ", 
      SuperscriptBox["a", "6"], " ", 
      SuperscriptBox["d", "2"]}]}], ")"}], " ", 
   SuperscriptBox["x", "20"]}], "+", 
  RowBox[{
   FractionBox["2", "3"], " ", 
   SuperscriptBox["b", "20"], " ", 
   SuperscriptBox["d", "6"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["c", "2"]}], "+", 
     RowBox[{"1012", " ", 
      SuperscriptBox["a", "3"], " ", "c", " ", "d"}], "+", 
     RowBox[{"16445", " ", 
      SuperscriptBox["a", "6"], " ", 
      SuperscriptBox["d", "2"]}]}], ")"}], " ", 
   SuperscriptBox["x", "21"]}], "+", 
  RowBox[{"46", " ", 
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["b", "21"], " ", 
   SuperscriptBox["d", "7"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", "c"}], "+", 
     RowBox[{"65", " ", 
      SuperscriptBox["a", "3"], " ", "d"}]}], ")"}], " ", 
   SuperscriptBox["x", "22"]}], "+", 
  RowBox[{"2", " ", "a", " ", 
   SuperscriptBox["b", "22"], " ", 
   SuperscriptBox["d", "7"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"4", " ", "c"}], "+", 
     RowBox[{"325", " ", 
      SuperscriptBox["a", "3"], " ", "d"}]}], ")"}], " ", 
   SuperscriptBox["x", "23"]}], "+", 
  RowBox[{
   FractionBox["1", "3"], " ", 
   SuperscriptBox["b", "23"], " ", 
   SuperscriptBox["d", "7"], " ", 
   RowBox[{"(", 
    RowBox[{"c", "+", 
     RowBox[{"325", " ", 
      SuperscriptBox["a", "3"], " ", "d"}]}], ")"}], " ", 
   SuperscriptBox["x", "24"]}], "+", 
  RowBox[{"13", " ", 
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["b", "24"], " ", 
   SuperscriptBox["d", "8"], " ", 
   SuperscriptBox["x", "25"]}], "+", 
  RowBox[{"a", " ", 
   SuperscriptBox["b", "25"], " ", 
   SuperscriptBox["d", "8"], " ", 
   SuperscriptBox["x", "26"]}], "+", 
  RowBox[{
   FractionBox["1", "27"], " ", 
   SuperscriptBox["b", "26"], " ", 
   SuperscriptBox["d", "8"], " ", 
   SuperscriptBox["x", "27"]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4898784664962807`*^9, 3.489878482267908*^9}, {
   3.489878526322386*^9, 3.489878537086405*^9}, 3.48987858572729*^9, 
   3.4898796056258817`*^9, 3.4898801008955517`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " knows the rule for arbitrary m and n, but needlessly expands the integrand \
when m is a positive integer:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.444322558662424*^9, 3.444322586131923*^9}, {
   3.4466780286625423`*^9, 3.446678029423637*^9}, {3.4466948967576723`*^9, 
   3.42317159478125*^9}, 3.423174910453125*^9, {3.423332331546875*^9, 
   3.423332347125*^9}, {3.423332380203125*^9, 3.42333240928125*^9}, 
   3.423341072625*^9, 3.4561670576790624`*^9, 3.4821759878804445`*^9, 
   3.4821761016640577`*^9, 3.4821761392881584`*^9, 3.482176179285672*^9, 
   3.4821770498975506`*^9, {3.489804505429864*^9, 3.489804512039873*^9}, {
   3.4898045424699154`*^9, 3.4898045431099167`*^9}, {3.4898045772899647`*^9, 
   3.4898046123600135`*^9}, {3.4898048582503576`*^9, 3.489804864160366*^9}, {
   3.4898049421404753`*^9, 3.4898049903205423`*^9}, {3.4898052429608965`*^9, 
   3.489805244530898*^9}, {3.489805282760952*^9, 3.4898052829509525`*^9}, 
   3.48987627971564*^9, 3.4898763360473385`*^9, 3.4898800132389975`*^9, 
   3.4898801103959684`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}]}]}], ")"}], "^", 
       "m"}]}], ",", "x"}], ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794581114545`*^9}, {3.4442806909341664`*^9, 
   3.4442806946094513`*^9}, {3.446684899001605*^9, 3.423011009453125*^9}, 
   3.42317151703125*^9, 3.423175051171875*^9, {3.4231761981875*^9, 
   3.4231762248125*^9}, {3.423177059765625*^9, 3.42317707634375*^9}, {
   3.489878637566181*^9, 3.4898786552254124`*^9}, 3.4898796106490903`*^9, 
   3.4898801103959684`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "n"]}]}], ")"}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "n"]}]}], ")"}], "m"]}], 
  RowBox[{"b", " ", "n", " ", "d", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "m"}], ")"}]}]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{3.4898796106490903`*^9, 3.4898801103959684`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}]}]}], ")"}], "^", 
       "8"}]}], ",", "x"}], ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794581114545`*^9}, {3.4442806909341664`*^9, 
   3.4442806946094513`*^9}, {3.446684899001605*^9, 3.423011009453125*^9}, 
   3.42317151703125*^9, 3.423175051171875*^9, {3.4231761981875*^9, 
   3.4231762248125*^9}, {3.423177059765625*^9, 3.42317707634375*^9}, {
   3.489878637566181*^9, 3.4898786552254124`*^9}, {3.489878787654045*^9, 
   3.489878799728466*^9}, 3.4898796106490903`*^9, 3.4898801103959684`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    SuperscriptBox["c", "8"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], 
   RowBox[{"b", " ", "n"}]], "+", 
  FractionBox[
   RowBox[{"4", " ", 
    SuperscriptBox["c", "7"], " ", "d", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], 
     RowBox[{"2", " ", "n"}]]}], 
   RowBox[{"b", " ", "n"}]], "+", 
  FractionBox[
   RowBox[{"28", " ", 
    SuperscriptBox["c", "6"], " ", 
    SuperscriptBox["d", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], 
     RowBox[{"3", " ", "n"}]]}], 
   RowBox[{"3", " ", "b", " ", "n"}]], "+", 
  FractionBox[
   RowBox[{"14", " ", 
    SuperscriptBox["c", "5"], " ", 
    SuperscriptBox["d", "3"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], 
     RowBox[{"4", " ", "n"}]]}], 
   RowBox[{"b", " ", "n"}]], "+", 
  FractionBox[
   RowBox[{"14", " ", 
    SuperscriptBox["c", "4"], " ", 
    SuperscriptBox["d", "4"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], 
     RowBox[{"5", " ", "n"}]]}], 
   RowBox[{"b", " ", "n"}]], "+", 
  FractionBox[
   RowBox[{"28", " ", 
    SuperscriptBox["c", "3"], " ", 
    SuperscriptBox["d", "5"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], 
     RowBox[{"6", " ", "n"}]]}], 
   RowBox[{"3", " ", "b", " ", "n"}]], "+", 
  FractionBox[
   RowBox[{"4", " ", 
    SuperscriptBox["c", "2"], " ", 
    SuperscriptBox["d", "6"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], 
     RowBox[{"7", " ", "n"}]]}], 
   RowBox[{"b", " ", "n"}]], "+", 
  FractionBox[
   RowBox[{"c", " ", 
    SuperscriptBox["d", "7"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], 
     RowBox[{"8", " ", "n"}]]}], 
   RowBox[{"b", " ", "n"}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["d", "8"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], 
     RowBox[{"9", " ", "n"}]]}], 
   RowBox[{"9", " ", "b", " ", "n"}]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{3.489878843424143*^9, 3.4898796106490903`*^9, 
  3.4898801103959684`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", "x"}]}], ")"}], "^", "3"}]}]}], ")"}], "^", 
       "8"}]}], ",", "x"}], ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794581114545`*^9}, {3.4442806909341664`*^9, 
   3.4442806946094513`*^9}, {3.446684899001605*^9, 3.423011009453125*^9}, 
   3.42317151703125*^9, 3.423175051171875*^9, {3.4231761981875*^9, 
   3.4231762248125*^9}, {3.423177059765625*^9, 3.42317707634375*^9}, {
   3.489878637566181*^9, 3.4898786552254124`*^9}, {3.489878787654045*^9, 
   3.489878799728466*^9}, {3.489878866090983*^9, 3.489878871566592*^9}, 
   3.4898796106490903`*^9, 3.4898801103959684`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["c", "8"], " ", "x"}], "+", 
  RowBox[{"8", " ", 
   SuperscriptBox["a", "5"], " ", 
   SuperscriptBox["c", "7"], " ", "d", " ", "x"}], "+", 
  RowBox[{"28", " ", 
   SuperscriptBox["a", "8"], " ", 
   SuperscriptBox["c", "6"], " ", 
   SuperscriptBox["d", "2"], " ", "x"}], "+", 
  RowBox[{"56", " ", 
   SuperscriptBox["a", "11"], " ", 
   SuperscriptBox["c", "5"], " ", 
   SuperscriptBox["d", "3"], " ", "x"}], "+", 
  RowBox[{"70", " ", 
   SuperscriptBox["a", "14"], " ", 
   SuperscriptBox["c", "4"], " ", 
   SuperscriptBox["d", "4"], " ", "x"}], "+", 
  RowBox[{"56", " ", 
   SuperscriptBox["a", "17"], " ", 
   SuperscriptBox["c", "3"], " ", 
   SuperscriptBox["d", "5"], " ", "x"}], "+", 
  RowBox[{"28", " ", 
   SuperscriptBox["a", "20"], " ", 
   SuperscriptBox["c", "2"], " ", 
   SuperscriptBox["d", "6"], " ", "x"}], "+", 
  RowBox[{"8", " ", 
   SuperscriptBox["a", "23"], " ", "c", " ", 
   SuperscriptBox["d", "7"], " ", "x"}], "+", 
  RowBox[{
   SuperscriptBox["a", "26"], " ", 
   SuperscriptBox["d", "8"], " ", "x"}], "+", 
  RowBox[{"a", " ", "b", " ", 
   SuperscriptBox["c", "8"], " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"20", " ", 
   SuperscriptBox["a", "4"], " ", "b", " ", 
   SuperscriptBox["c", "7"], " ", "d", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"112", " ", 
   SuperscriptBox["a", "7"], " ", "b", " ", 
   SuperscriptBox["c", "6"], " ", 
   SuperscriptBox["d", "2"], " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"308", " ", 
   SuperscriptBox["a", "10"], " ", "b", " ", 
   SuperscriptBox["c", "5"], " ", 
   SuperscriptBox["d", "3"], " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"490", " ", 
   SuperscriptBox["a", "13"], " ", "b", " ", 
   SuperscriptBox["c", "4"], " ", 
   SuperscriptBox["d", "4"], " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"476", " ", 
   SuperscriptBox["a", "16"], " ", "b", " ", 
   SuperscriptBox["c", "3"], " ", 
   SuperscriptBox["d", "5"], " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"280", " ", 
   SuperscriptBox["a", "19"], " ", "b", " ", 
   SuperscriptBox["c", "2"], " ", 
   SuperscriptBox["d", "6"], " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"92", " ", 
   SuperscriptBox["a", "22"], " ", "b", " ", "c", " ", 
   SuperscriptBox["d", "7"], " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"13", " ", 
   SuperscriptBox["a", "25"], " ", "b", " ", 
   SuperscriptBox["d", "8"], " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{
   FractionBox["1", "3"], " ", 
   SuperscriptBox["b", "2"], " ", 
   SuperscriptBox["c", "8"], " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{
   FractionBox["80", "3"], " ", 
   SuperscriptBox["a", "3"], " ", 
   SuperscriptBox["b", "2"], " ", 
   SuperscriptBox["c", "7"], " ", "d", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{
   FractionBox["784", "3"], " ", 
   SuperscriptBox["a", "6"], " ", 
   SuperscriptBox["b", "2"], " ", 
   SuperscriptBox["c", "6"], " ", 
   SuperscriptBox["d", "2"], " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{
   FractionBox["3080", "3"], " ", 
   SuperscriptBox["a", "9"], " ", 
   SuperscriptBox["b", "2"], " ", 
   SuperscriptBox["c", "5"], " ", 
   SuperscriptBox["d", "3"], " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{
   FractionBox["6370", "3"], " ", 
   SuperscriptBox["a", "12"], " ", 
   SuperscriptBox["b", "2"], " ", 
   SuperscriptBox["c", "4"], " ", 
   SuperscriptBox["d", "4"], " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{
   FractionBox["7616", "3"], " ", 
   SuperscriptBox["a", "15"], " ", 
   SuperscriptBox["b", "2"], " ", 
   SuperscriptBox["c", "3"], " ", 
   SuperscriptBox["d", "5"], " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{
   FractionBox["5320", "3"], " ", 
   SuperscriptBox["a", "18"], " ", 
   SuperscriptBox["b", "2"], " ", 
   SuperscriptBox["c", "2"], " ", 
   SuperscriptBox["d", "6"], " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{
   FractionBox["2024", "3"], " ", 
   SuperscriptBox["a", "21"], " ", 
   SuperscriptBox["b", "2"], " ", "c", " ", 
   SuperscriptBox["d", "7"], " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{
   FractionBox["325", "3"], " ", 
   SuperscriptBox["a", "24"], " ", 
   SuperscriptBox["b", "2"], " ", 
   SuperscriptBox["d", "8"], " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"20", " ", 
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["b", "3"], " ", 
   SuperscriptBox["c", "7"], " ", "d", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"392", " ", 
   SuperscriptBox["a", "5"], " ", 
   SuperscriptBox["b", "3"], " ", 
   SuperscriptBox["c", "6"], " ", 
   SuperscriptBox["d", "2"], " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"2310", " ", 
   SuperscriptBox["a", "8"], " ", 
   SuperscriptBox["b", "3"], " ", 
   SuperscriptBox["c", "5"], " ", 
   SuperscriptBox["d", "3"], " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"6370", " ", 
   SuperscriptBox["a", "11"], " ", 
   SuperscriptBox["b", "3"], " ", 
   SuperscriptBox["c", "4"], " ", 
   SuperscriptBox["d", "4"], " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"9520", " ", 
   SuperscriptBox["a", "14"], " ", 
   SuperscriptBox["b", "3"], " ", 
   SuperscriptBox["c", "3"], " ", 
   SuperscriptBox["d", "5"], " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"7980", " ", 
   SuperscriptBox["a", "17"], " ", 
   SuperscriptBox["b", "3"], " ", 
   SuperscriptBox["c", "2"], " ", 
   SuperscriptBox["d", "6"], " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"3542", " ", 
   SuperscriptBox["a", "20"], " ", 
   SuperscriptBox["b", "3"], " ", "c", " ", 
   SuperscriptBox["d", "7"], " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"650", " ", 
   SuperscriptBox["a", "23"], " ", 
   SuperscriptBox["b", "3"], " ", 
   SuperscriptBox["d", "8"], " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"8", " ", "a", " ", 
   SuperscriptBox["b", "4"], " ", 
   SuperscriptBox["c", "7"], " ", "d", " ", 
   SuperscriptBox["x", "5"]}], "+", 
  RowBox[{"392", " ", 
   SuperscriptBox["a", "4"], " ", 
   SuperscriptBox["b", "4"], " ", 
   SuperscriptBox["c", "6"], " ", 
   SuperscriptBox["d", "2"], " ", 
   SuperscriptBox["x", "5"]}], "+", 
  RowBox[{"3696", " ", 
   SuperscriptBox["a", "7"], " ", 
   SuperscriptBox["b", "4"], " ", 
   SuperscriptBox["c", "5"], " ", 
   SuperscriptBox["d", "3"], " ", 
   SuperscriptBox["x", "5"]}], "+", 
  RowBox[{"14014", " ", 
   SuperscriptBox["a", "10"], " ", 
   SuperscriptBox["b", "4"], " ", 
   SuperscriptBox["c", "4"], " ", 
   SuperscriptBox["d", "4"], " ", 
   SuperscriptBox["x", "5"]}], "+", 
  RowBox[{"26656", " ", 
   SuperscriptBox["a", "13"], " ", 
   SuperscriptBox["b", "4"], " ", 
   SuperscriptBox["c", "3"], " ", 
   SuperscriptBox["d", "5"], " ", 
   SuperscriptBox["x", "5"]}], "+", 
  RowBox[{"27132", " ", 
   SuperscriptBox["a", "16"], " ", 
   SuperscriptBox["b", "4"], " ", 
   SuperscriptBox["c", "2"], " ", 
   SuperscriptBox["d", "6"], " ", 
   SuperscriptBox["x", "5"]}], "+", 
  RowBox[{"14168", " ", 
   SuperscriptBox["a", "19"], " ", 
   SuperscriptBox["b", "4"], " ", "c", " ", 
   SuperscriptBox["d", "7"], " ", 
   SuperscriptBox["x", "5"]}], "+", 
  RowBox[{"2990", " ", 
   SuperscriptBox["a", "22"], " ", 
   SuperscriptBox["b", "4"], " ", 
   SuperscriptBox["d", "8"], " ", 
   SuperscriptBox["x", "5"]}], "+", 
  RowBox[{
   FractionBox["4", "3"], " ", 
   SuperscriptBox["b", "5"], " ", 
   SuperscriptBox["c", "7"], " ", "d", " ", 
   SuperscriptBox["x", "6"]}], "+", 
  RowBox[{
   FractionBox["784", "3"], " ", 
   SuperscriptBox["a", "3"], " ", 
   SuperscriptBox["b", "5"], " ", 
   SuperscriptBox["c", "6"], " ", 
   SuperscriptBox["d", "2"], " ", 
   SuperscriptBox["x", "6"]}], "+", 
  RowBox[{"4312", " ", 
   SuperscriptBox["a", "6"], " ", 
   SuperscriptBox["b", "5"], " ", 
   SuperscriptBox["c", "5"], " ", 
   SuperscriptBox["d", "3"], " ", 
   SuperscriptBox["x", "6"]}], "+", 
  RowBox[{
   FractionBox["70070", "3"], " ", 
   SuperscriptBox["a", "9"], " ", 
   SuperscriptBox["b", "5"], " ", 
   SuperscriptBox["c", "4"], " ", 
   SuperscriptBox["d", "4"], " ", 
   SuperscriptBox["x", "6"]}], "+", 
  RowBox[{
   FractionBox["173264", "3"], " ", 
   SuperscriptBox["a", "12"], " ", 
   SuperscriptBox["b", "5"], " ", 
   SuperscriptBox["c", "3"], " ", 
   SuperscriptBox["d", "5"], " ", 
   SuperscriptBox["x", "6"]}], "+", 
  RowBox[{"72352", " ", 
   SuperscriptBox["a", "15"], " ", 
   SuperscriptBox["b", "5"], " ", 
   SuperscriptBox["c", "2"], " ", 
   SuperscriptBox["d", "6"], " ", 
   SuperscriptBox["x", "6"]}], "+", 
  RowBox[{
   FractionBox["134596", "3"], " ", 
   SuperscriptBox["a", "18"], " ", 
   SuperscriptBox["b", "5"], " ", "c", " ", 
   SuperscriptBox["d", "7"], " ", 
   SuperscriptBox["x", "6"]}], "+", 
  RowBox[{
   FractionBox["32890", "3"], " ", 
   SuperscriptBox["a", "21"], " ", 
   SuperscriptBox["b", "5"], " ", 
   SuperscriptBox["d", "8"], " ", 
   SuperscriptBox["x", "6"]}], "+", 
  RowBox[{"112", " ", 
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["b", "6"], " ", 
   SuperscriptBox["c", "6"], " ", 
   SuperscriptBox["d", "2"], " ", 
   SuperscriptBox["x", "7"]}], "+", 
  RowBox[{"3696", " ", 
   SuperscriptBox["a", "5"], " ", 
   SuperscriptBox["b", "6"], " ", 
   SuperscriptBox["c", "5"], " ", 
   SuperscriptBox["d", "3"], " ", 
   SuperscriptBox["x", "7"]}], "+", 
  RowBox[{"30030", " ", 
   SuperscriptBox["a", "8"], " ", 
   SuperscriptBox["b", "6"], " ", 
   SuperscriptBox["c", "4"], " ", 
   SuperscriptBox["d", "4"], " ", 
   SuperscriptBox["x", "7"]}], "+", 
  RowBox[{"99008", " ", 
   SuperscriptBox["a", "11"], " ", 
   SuperscriptBox["b", "6"], " ", 
   SuperscriptBox["c", "3"], " ", 
   SuperscriptBox["d", "5"], " ", 
   SuperscriptBox["x", "7"]}], "+", 
  RowBox[{"155040", " ", 
   SuperscriptBox["a", "14"], " ", 
   SuperscriptBox["b", "6"], " ", 
   SuperscriptBox["c", "2"], " ", 
   SuperscriptBox["d", "6"], " ", 
   SuperscriptBox["x", "7"]}], "+", 
  RowBox[{"115368", " ", 
   SuperscriptBox["a", "17"], " ", 
   SuperscriptBox["b", "6"], " ", "c", " ", 
   SuperscriptBox["d", "7"], " ", 
   SuperscriptBox["x", "7"]}], "+", 
  RowBox[{"32890", " ", 
   SuperscriptBox["a", "20"], " ", 
   SuperscriptBox["b", "6"], " ", 
   SuperscriptBox["d", "8"], " ", 
   SuperscriptBox["x", "7"]}], "+", 
  RowBox[{"28", " ", "a", " ", 
   SuperscriptBox["b", "7"], " ", 
   SuperscriptBox["c", "6"], " ", 
   SuperscriptBox["d", "2"], " ", 
   SuperscriptBox["x", "8"]}], "+", 
  RowBox[{"2310", " ", 
   SuperscriptBox["a", "4"], " ", 
   SuperscriptBox["b", "7"], " ", 
   SuperscriptBox["c", "5"], " ", 
   SuperscriptBox["d", "3"], " ", 
   SuperscriptBox["x", "8"]}], "+", 
  RowBox[{"30030", " ", 
   SuperscriptBox["a", "7"], " ", 
   SuperscriptBox["b", "7"], " ", 
   SuperscriptBox["c", "4"], " ", 
   SuperscriptBox["d", "4"], " ", 
   SuperscriptBox["x", "8"]}], "+", 
  RowBox[{"136136", " ", 
   SuperscriptBox["a", "10"], " ", 
   SuperscriptBox["b", "7"], " ", 
   SuperscriptBox["c", "3"], " ", 
   SuperscriptBox["d", "5"], " ", 
   SuperscriptBox["x", "8"]}], "+", 
  RowBox[{"271320", " ", 
   SuperscriptBox["a", "13"], " ", 
   SuperscriptBox["b", "7"], " ", 
   SuperscriptBox["c", "2"], " ", 
   SuperscriptBox["d", "6"], " ", 
   SuperscriptBox["x", "8"]}], "+", 
  RowBox[{"245157", " ", 
   SuperscriptBox["a", "16"], " ", 
   SuperscriptBox["b", "7"], " ", "c", " ", 
   SuperscriptBox["d", "7"], " ", 
   SuperscriptBox["x", "8"]}], "+", 
  RowBox[{"82225", " ", 
   SuperscriptBox["a", "19"], " ", 
   SuperscriptBox["b", "7"], " ", 
   SuperscriptBox["d", "8"], " ", 
   SuperscriptBox["x", "8"]}], "+", 
  RowBox[{
   FractionBox["28", "9"], " ", 
   SuperscriptBox["b", "8"], " ", 
   SuperscriptBox["c", "6"], " ", 
   SuperscriptBox["d", "2"], " ", 
   SuperscriptBox["x", "9"]}], "+", 
  RowBox[{
   FractionBox["3080", "3"], " ", 
   SuperscriptBox["a", "3"], " ", 
   SuperscriptBox["b", "8"], " ", 
   SuperscriptBox["c", "5"], " ", 
   SuperscriptBox["d", "3"], " ", 
   SuperscriptBox["x", "9"]}], "+", 
  RowBox[{
   FractionBox["70070", "3"], " ", 
   SuperscriptBox["a", "6"], " ", 
   SuperscriptBox["b", "8"], " ", 
   SuperscriptBox["c", "4"], " ", 
   SuperscriptBox["d", "4"], " ", 
   SuperscriptBox["x", "9"]}], "+", 
  RowBox[{
   FractionBox["1361360", "9"], " ", 
   SuperscriptBox["a", "9"], " ", 
   SuperscriptBox["b", "8"], " ", 
   SuperscriptBox["c", "3"], " ", 
   SuperscriptBox["d", "5"], " ", 
   SuperscriptBox["x", "9"]}], "+", 
  RowBox[{
   FractionBox["1175720", "3"], " ", 
   SuperscriptBox["a", "12"], " ", 
   SuperscriptBox["b", "8"], " ", 
   SuperscriptBox["c", "2"], " ", 
   SuperscriptBox["d", "6"], " ", 
   SuperscriptBox["x", "9"]}], "+", 
  RowBox[{
   FractionBox["1307504", "3"], " ", 
   SuperscriptBox["a", "15"], " ", 
   SuperscriptBox["b", "8"], " ", "c", " ", 
   SuperscriptBox["d", "7"], " ", 
   SuperscriptBox["x", "9"]}], "+", 
  RowBox[{
   FractionBox["1562275", "9"], " ", 
   SuperscriptBox["a", "18"], " ", 
   SuperscriptBox["b", "8"], " ", 
   SuperscriptBox["d", "8"], " ", 
   SuperscriptBox["x", "9"]}], "+", 
  RowBox[{"308", " ", 
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["b", "9"], " ", 
   SuperscriptBox["c", "5"], " ", 
   SuperscriptBox["d", "3"], " ", 
   SuperscriptBox["x", "10"]}], "+", 
  RowBox[{"14014", " ", 
   SuperscriptBox["a", "5"], " ", 
   SuperscriptBox["b", "9"], " ", 
   SuperscriptBox["c", "4"], " ", 
   SuperscriptBox["d", "4"], " ", 
   SuperscriptBox["x", "10"]}], "+", 
  RowBox[{"136136", " ", 
   SuperscriptBox["a", "8"], " ", 
   SuperscriptBox["b", "9"], " ", 
   SuperscriptBox["c", "3"], " ", 
   SuperscriptBox["d", "5"], " ", 
   SuperscriptBox["x", "10"]}], "+", 
  RowBox[{"470288", " ", 
   SuperscriptBox["a", "11"], " ", 
   SuperscriptBox["b", "9"], " ", 
   SuperscriptBox["c", "2"], " ", 
   SuperscriptBox["d", "6"], " ", 
   SuperscriptBox["x", "10"]}], "+", 
  RowBox[{"653752", " ", 
   SuperscriptBox["a", "14"], " ", 
   SuperscriptBox["b", "9"], " ", "c", " ", 
   SuperscriptBox["d", "7"], " ", 
   SuperscriptBox["x", "10"]}], "+", 
  RowBox[{"312455", " ", 
   SuperscriptBox["a", "17"], " ", 
   SuperscriptBox["b", "9"], " ", 
   SuperscriptBox["d", "8"], " ", 
   SuperscriptBox["x", "10"]}], "+", 
  RowBox[{"56", " ", "a", " ", 
   SuperscriptBox["b", "10"], " ", 
   SuperscriptBox["c", "5"], " ", 
   SuperscriptBox["d", "3"], " ", 
   SuperscriptBox["x", "11"]}], "+", 
  RowBox[{"6370", " ", 
   SuperscriptBox["a", "4"], " ", 
   SuperscriptBox["b", "10"], " ", 
   SuperscriptBox["c", "4"], " ", 
   SuperscriptBox["d", "4"], " ", 
   SuperscriptBox["x", "11"]}], "+", 
  RowBox[{"99008", " ", 
   SuperscriptBox["a", "7"], " ", 
   SuperscriptBox["b", "10"], " ", 
   SuperscriptBox["c", "3"], " ", 
   SuperscriptBox["d", "5"], " ", 
   SuperscriptBox["x", "11"]}], "+", 
  RowBox[{"470288", " ", 
   SuperscriptBox["a", "10"], " ", 
   SuperscriptBox["b", "10"], " ", 
   SuperscriptBox["c", "2"], " ", 
   SuperscriptBox["d", "6"], " ", 
   SuperscriptBox["x", "11"]}], "+", 
  RowBox[{"832048", " ", 
   SuperscriptBox["a", "13"], " ", 
   SuperscriptBox["b", "10"], " ", "c", " ", 
   SuperscriptBox["d", "7"], " ", 
   SuperscriptBox["x", "11"]}], "+", 
  RowBox[{"482885", " ", 
   SuperscriptBox["a", "16"], " ", 
   SuperscriptBox["b", "10"], " ", 
   SuperscriptBox["d", "8"], " ", 
   SuperscriptBox["x", "11"]}], "+", 
  RowBox[{
   FractionBox["14", "3"], " ", 
   SuperscriptBox["b", "11"], " ", 
   SuperscriptBox["c", "5"], " ", 
   SuperscriptBox["d", "3"], " ", 
   SuperscriptBox["x", "12"]}], "+", 
  RowBox[{
   FractionBox["6370", "3"], " ", 
   SuperscriptBox["a", "3"], " ", 
   SuperscriptBox["b", "11"], " ", 
   SuperscriptBox["c", "4"], " ", 
   SuperscriptBox["d", "4"], " ", 
   SuperscriptBox["x", "12"]}], "+", 
  RowBox[{
   FractionBox["173264", "3"], " ", 
   SuperscriptBox["a", "6"], " ", 
   SuperscriptBox["b", "11"], " ", 
   SuperscriptBox["c", "3"], " ", 
   SuperscriptBox["d", "5"], " ", 
   SuperscriptBox["x", "12"]}], "+", 
  RowBox[{
   FractionBox["1175720", "3"], " ", 
   SuperscriptBox["a", "9"], " ", 
   SuperscriptBox["b", "11"], " ", 
   SuperscriptBox["c", "2"], " ", 
   SuperscriptBox["d", "6"], " ", 
   SuperscriptBox["x", "12"]}], "+", 
  RowBox[{
   FractionBox["2704156", "3"], " ", 
   SuperscriptBox["a", "12"], " ", 
   SuperscriptBox["b", "11"], " ", "c", " ", 
   SuperscriptBox["d", "7"], " ", 
   SuperscriptBox["x", "12"]}], "+", 
  RowBox[{
   FractionBox["1931540", "3"], " ", 
   SuperscriptBox["a", "15"], " ", 
   SuperscriptBox["b", "11"], " ", 
   SuperscriptBox["d", "8"], " ", 
   SuperscriptBox["x", "12"]}], "+", 
  RowBox[{"490", " ", 
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["b", "12"], " ", 
   SuperscriptBox["c", "4"], " ", 
   SuperscriptBox["d", "4"], " ", 
   SuperscriptBox["x", "13"]}], "+", 
  RowBox[{"26656", " ", 
   SuperscriptBox["a", "5"], " ", 
   SuperscriptBox["b", "12"], " ", 
   SuperscriptBox["c", "3"], " ", 
   SuperscriptBox["d", "5"], " ", 
   SuperscriptBox["x", "13"]}], "+", 
  RowBox[{"271320", " ", 
   SuperscriptBox["a", "8"], " ", 
   SuperscriptBox["b", "12"], " ", 
   SuperscriptBox["c", "2"], " ", 
   SuperscriptBox["d", "6"], " ", 
   SuperscriptBox["x", "13"]}], "+", 
  RowBox[{"832048", " ", 
   SuperscriptBox["a", "11"], " ", 
   SuperscriptBox["b", "12"], " ", "c", " ", 
   SuperscriptBox["d", "7"], " ", 
   SuperscriptBox["x", "13"]}], "+", 
  RowBox[{"742900", " ", 
   SuperscriptBox["a", "14"], " ", 
   SuperscriptBox["b", "12"], " ", 
   SuperscriptBox["d", "8"], " ", 
   SuperscriptBox["x", "13"]}], "+", 
  RowBox[{"70", " ", "a", " ", 
   SuperscriptBox["b", "13"], " ", 
   SuperscriptBox["c", "4"], " ", 
   SuperscriptBox["d", "4"], " ", 
   SuperscriptBox["x", "14"]}], "+", 
  RowBox[{"9520", " ", 
   SuperscriptBox["a", "4"], " ", 
   SuperscriptBox["b", "13"], " ", 
   SuperscriptBox["c", "3"], " ", 
   SuperscriptBox["d", "5"], " ", 
   SuperscriptBox["x", "14"]}], "+", 
  RowBox[{"155040", " ", 
   SuperscriptBox["a", "7"], " ", 
   SuperscriptBox["b", "13"], " ", 
   SuperscriptBox["c", "2"], " ", 
   SuperscriptBox["d", "6"], " ", 
   SuperscriptBox["x", "14"]}], "+", 
  RowBox[{"653752", " ", 
   SuperscriptBox["a", "10"], " ", 
   SuperscriptBox["b", "13"], " ", "c", " ", 
   SuperscriptBox["d", "7"], " ", 
   SuperscriptBox["x", "14"]}], "+", 
  RowBox[{"742900", " ", 
   SuperscriptBox["a", "13"], " ", 
   SuperscriptBox["b", "13"], " ", 
   SuperscriptBox["d", "8"], " ", 
   SuperscriptBox["x", "14"]}], "+", 
  RowBox[{
   FractionBox["14", "3"], " ", 
   SuperscriptBox["b", "14"], " ", 
   SuperscriptBox["c", "4"], " ", 
   SuperscriptBox["d", "4"], " ", 
   SuperscriptBox["x", "15"]}], "+", 
  RowBox[{
   FractionBox["7616", "3"], " ", 
   SuperscriptBox["a", "3"], " ", 
   SuperscriptBox["b", "14"], " ", 
   SuperscriptBox["c", "3"], " ", 
   SuperscriptBox["d", "5"], " ", 
   SuperscriptBox["x", "15"]}], "+", 
  RowBox[{"72352", " ", 
   SuperscriptBox["a", "6"], " ", 
   SuperscriptBox["b", "14"], " ", 
   SuperscriptBox["c", "2"], " ", 
   SuperscriptBox["d", "6"], " ", 
   SuperscriptBox["x", "15"]}], "+", 
  RowBox[{
   FractionBox["1307504", "3"], " ", 
   SuperscriptBox["a", "9"], " ", 
   SuperscriptBox["b", "14"], " ", "c", " ", 
   SuperscriptBox["d", "7"], " ", 
   SuperscriptBox["x", "15"]}], "+", 
  RowBox[{
   FractionBox["1931540", "3"], " ", 
   SuperscriptBox["a", "12"], " ", 
   SuperscriptBox["b", "14"], " ", 
   SuperscriptBox["d", "8"], " ", 
   SuperscriptBox["x", "15"]}], "+", 
  RowBox[{"476", " ", 
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["b", "15"], " ", 
   SuperscriptBox["c", "3"], " ", 
   SuperscriptBox["d", "5"], " ", 
   SuperscriptBox["x", "16"]}], "+", 
  RowBox[{"27132", " ", 
   SuperscriptBox["a", "5"], " ", 
   SuperscriptBox["b", "15"], " ", 
   SuperscriptBox["c", "2"], " ", 
   SuperscriptBox["d", "6"], " ", 
   SuperscriptBox["x", "16"]}], "+", 
  RowBox[{"245157", " ", 
   SuperscriptBox["a", "8"], " ", 
   SuperscriptBox["b", "15"], " ", "c", " ", 
   SuperscriptBox["d", "7"], " ", 
   SuperscriptBox["x", "16"]}], "+", 
  RowBox[{"482885", " ", 
   SuperscriptBox["a", "11"], " ", 
   SuperscriptBox["b", "15"], " ", 
   SuperscriptBox["d", "8"], " ", 
   SuperscriptBox["x", "16"]}], "+", 
  RowBox[{"56", " ", "a", " ", 
   SuperscriptBox["b", "16"], " ", 
   SuperscriptBox["c", "3"], " ", 
   SuperscriptBox["d", "5"], " ", 
   SuperscriptBox["x", "17"]}], "+", 
  RowBox[{"7980", " ", 
   SuperscriptBox["a", "4"], " ", 
   SuperscriptBox["b", "16"], " ", 
   SuperscriptBox["c", "2"], " ", 
   SuperscriptBox["d", "6"], " ", 
   SuperscriptBox["x", "17"]}], "+", 
  RowBox[{"115368", " ", 
   SuperscriptBox["a", "7"], " ", 
   SuperscriptBox["b", "16"], " ", "c", " ", 
   SuperscriptBox["d", "7"], " ", 
   SuperscriptBox["x", "17"]}], "+", 
  RowBox[{"312455", " ", 
   SuperscriptBox["a", "10"], " ", 
   SuperscriptBox["b", "16"], " ", 
   SuperscriptBox["d", "8"], " ", 
   SuperscriptBox["x", "17"]}], "+", 
  RowBox[{
   FractionBox["28", "9"], " ", 
   SuperscriptBox["b", "17"], " ", 
   SuperscriptBox["c", "3"], " ", 
   SuperscriptBox["d", "5"], " ", 
   SuperscriptBox["x", "18"]}], "+", 
  RowBox[{
   FractionBox["5320", "3"], " ", 
   SuperscriptBox["a", "3"], " ", 
   SuperscriptBox["b", "17"], " ", 
   SuperscriptBox["c", "2"], " ", 
   SuperscriptBox["d", "6"], " ", 
   SuperscriptBox["x", "18"]}], "+", 
  RowBox[{
   FractionBox["134596", "3"], " ", 
   SuperscriptBox["a", "6"], " ", 
   SuperscriptBox["b", "17"], " ", "c", " ", 
   SuperscriptBox["d", "7"], " ", 
   SuperscriptBox["x", "18"]}], "+", 
  RowBox[{
   FractionBox["1562275", "9"], " ", 
   SuperscriptBox["a", "9"], " ", 
   SuperscriptBox["b", "17"], " ", 
   SuperscriptBox["d", "8"], " ", 
   SuperscriptBox["x", "18"]}], "+", 
  RowBox[{"280", " ", 
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["b", "18"], " ", 
   SuperscriptBox["c", "2"], " ", 
   SuperscriptBox["d", "6"], " ", 
   SuperscriptBox["x", "19"]}], "+", 
  RowBox[{"14168", " ", 
   SuperscriptBox["a", "5"], " ", 
   SuperscriptBox["b", "18"], " ", "c", " ", 
   SuperscriptBox["d", "7"], " ", 
   SuperscriptBox["x", "19"]}], "+", 
  RowBox[{"82225", " ", 
   SuperscriptBox["a", "8"], " ", 
   SuperscriptBox["b", "18"], " ", 
   SuperscriptBox["d", "8"], " ", 
   SuperscriptBox["x", "19"]}], "+", 
  RowBox[{"28", " ", "a", " ", 
   SuperscriptBox["b", "19"], " ", 
   SuperscriptBox["c", "2"], " ", 
   SuperscriptBox["d", "6"], " ", 
   SuperscriptBox["x", "20"]}], "+", 
  RowBox[{"3542", " ", 
   SuperscriptBox["a", "4"], " ", 
   SuperscriptBox["b", "19"], " ", "c", " ", 
   SuperscriptBox["d", "7"], " ", 
   SuperscriptBox["x", "20"]}], "+", 
  RowBox[{"32890", " ", 
   SuperscriptBox["a", "7"], " ", 
   SuperscriptBox["b", "19"], " ", 
   SuperscriptBox["d", "8"], " ", 
   SuperscriptBox["x", "20"]}], "+", 
  RowBox[{
   FractionBox["4", "3"], " ", 
   SuperscriptBox["b", "20"], " ", 
   SuperscriptBox["c", "2"], " ", 
   SuperscriptBox["d", "6"], " ", 
   SuperscriptBox["x", "21"]}], "+", 
  RowBox[{
   FractionBox["2024", "3"], " ", 
   SuperscriptBox["a", "3"], " ", 
   SuperscriptBox["b", "20"], " ", "c", " ", 
   SuperscriptBox["d", "7"], " ", 
   SuperscriptBox["x", "21"]}], "+", 
  RowBox[{
   FractionBox["32890", "3"], " ", 
   SuperscriptBox["a", "6"], " ", 
   SuperscriptBox["b", "20"], " ", 
   SuperscriptBox["d", "8"], " ", 
   SuperscriptBox["x", "21"]}], "+", 
  RowBox[{"92", " ", 
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["b", "21"], " ", "c", " ", 
   SuperscriptBox["d", "7"], " ", 
   SuperscriptBox["x", "22"]}], "+", 
  RowBox[{"2990", " ", 
   SuperscriptBox["a", "5"], " ", 
   SuperscriptBox["b", "21"], " ", 
   SuperscriptBox["d", "8"], " ", 
   SuperscriptBox["x", "22"]}], "+", 
  RowBox[{"8", " ", "a", " ", 
   SuperscriptBox["b", "22"], " ", "c", " ", 
   SuperscriptBox["d", "7"], " ", 
   SuperscriptBox["x", "23"]}], "+", 
  RowBox[{"650", " ", 
   SuperscriptBox["a", "4"], " ", 
   SuperscriptBox["b", "22"], " ", 
   SuperscriptBox["d", "8"], " ", 
   SuperscriptBox["x", "23"]}], "+", 
  RowBox[{
   FractionBox["1", "3"], " ", 
   SuperscriptBox["b", "23"], " ", "c", " ", 
   SuperscriptBox["d", "7"], " ", 
   SuperscriptBox["x", "24"]}], "+", 
  RowBox[{
   FractionBox["325", "3"], " ", 
   SuperscriptBox["a", "3"], " ", 
   SuperscriptBox["b", "23"], " ", 
   SuperscriptBox["d", "8"], " ", 
   SuperscriptBox["x", "24"]}], "+", 
  RowBox[{"13", " ", 
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["b", "24"], " ", 
   SuperscriptBox["d", "8"], " ", 
   SuperscriptBox["x", "25"]}], "+", 
  RowBox[{"a", " ", 
   SuperscriptBox["b", "25"], " ", 
   SuperscriptBox["d", "8"], " ", 
   SuperscriptBox["x", "26"]}], "+", 
  RowBox[{
   FractionBox["1", "27"], " ", 
   SuperscriptBox["b", "26"], " ", 
   SuperscriptBox["d", "8"], " ", 
   SuperscriptBox["x", "27"]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{3.489878946399924*^9, 3.4898796106490903`*^9, 
  3.4898801103959684`*^9}]
}, Closed]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Rational Function Integration Problem 5", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.482188248027584*^9}, 3.482188706516859*^9, 
   3.4898791143810186`*^9, 3.4898884003339815`*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "18"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "20"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4903833167736015`*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " knows and takes advantage of the general rule for arbitrary n:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443225459641647`*^9, 3.4443225485078225`*^9}, {
   3.4466948911496077`*^9, 3.42301074665625*^9}, 3.42317159478125*^9, {
   3.423174840640625*^9, 3.423174854046875*^9}, {3.4233322945*^9, 
   3.4233323091875*^9}, {3.42333236403125*^9, 3.423332366546875*^9}, {
   3.423332643984375*^9, 3.42333264684375*^9}, 3.423341072609375*^9, 
   3.4561670576690483`*^9, 3.4791559290778675`*^9, 3.482175999467106*^9, {
   3.482176939178344*^9, 3.482176943534608*^9}, 3.4821770265840273`*^9, 
   3.4898796407415433`*^9, {3.4898801760096836`*^9, 3.4898801822808943`*^9}}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", 
     RowBox[{"n", "-", "2"}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "n"]], ",", " ", "x"}], 
  "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.446686303711478*^9, 3.423013182015625*^9}, 
   3.423171538015625*^9, 3.42317763434375*^9, 3.4561670576790624`*^9, 
   3.4821746501468782`*^9, 3.4898796407415433`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["x", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "n"}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], 
    RowBox[{"1", "-", "n"}]]}], 
  RowBox[{"a", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "n"}], ")"}]}]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{3.4557529593469653`*^9, 3.4561670576690483`*^9, 
  3.489879640757143*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "18"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "20"]], ",", " ", "x"}], 
  "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.446686303711478*^9, 3.423013182015625*^9}, 
   3.423171538015625*^9, 3.42317763434375*^9, 3.4561670576790624`*^9, 
   3.489879640757143*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["x", "19"], 
  RowBox[{"19", " ", "a", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], "19"]}]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4466863419063997`*^9, 3.42301318265625*^9}, 
   3.423171538015625*^9, 3.4561670576790624`*^9, 3.489879640757143*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " knows the rule for arbitrary n, but needlessly expands the integrand when \
n is an integer:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.444322558662424*^9, 3.444322586131923*^9}, {
   3.4466780286625423`*^9, 3.446678029423637*^9}, {3.4466948967576723`*^9, 
   3.42317159478125*^9}, 3.423174910453125*^9, {3.423332331546875*^9, 
   3.423332347125*^9}, {3.423332380203125*^9, 3.42333240928125*^9}, 
   3.423341072625*^9, 3.4561670576790624`*^9, 3.4821759878804445`*^9, 
   3.4821761016640577`*^9, 3.4821761392881584`*^9, 3.482176179285672*^9, 
   3.4821770498975506`*^9, {3.489804505429864*^9, 3.489804512039873*^9}, {
   3.4898045424699154`*^9, 3.4898045431099167`*^9}, {3.4898045772899647`*^9, 
   3.4898046123600135`*^9}, {3.4898048582503576`*^9, 3.489804864160366*^9}, {
   3.4898049421404753`*^9, 3.4898049903205423`*^9}, {3.4898052429608965`*^9, 
   3.489805244530898*^9}, {3.489805282760952*^9, 3.4898052829509525`*^9}, 
   3.48987627971564*^9, 3.4898763360473385`*^9, 3.4898801008955517`*^9, {
   3.489880232138582*^9, 3.489880256724225*^9}, 3.4898802978146973`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", 
     RowBox[{"n", "-", "2"}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "n"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.446686303711478*^9, 3.446686355045293*^9}, {
   3.446686541142888*^9, 3.42301314003125*^9}, 3.423171538015625*^9, 
   3.455753003919055*^9, 3.4561670576790624`*^9, 3.489879646123553*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["x", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "n"}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], 
    RowBox[{"1", "-", "n"}]]}], 
  RowBox[{"a", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "n"}], ")"}]}]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{3.4557530051911125`*^9, 3.4561670576790624`*^9, 
  3.489879646123553*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "18"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "20"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.446686303711478*^9, 3.446686355045293*^9}, {
   3.446686541142888*^9, 3.42301314003125*^9}, 3.423171538015625*^9, 
   3.4561670576790624`*^9, 3.489879646123553*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"19", " ", 
     SuperscriptBox["b", "19"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "19"]}]], 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["a", "18"], "+", 
     RowBox[{"19", " ", 
      SuperscriptBox["a", "17"], " ", "b", " ", "x"}], "+", 
     RowBox[{"171", " ", 
      SuperscriptBox["a", "16"], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"969", " ", 
      SuperscriptBox["a", "15"], " ", 
      SuperscriptBox["b", "3"], " ", 
      SuperscriptBox["x", "3"]}], "+", 
     RowBox[{"3876", " ", 
      SuperscriptBox["a", "14"], " ", 
      SuperscriptBox["b", "4"], " ", 
      SuperscriptBox["x", "4"]}], "+", 
     RowBox[{"11628", " ", 
      SuperscriptBox["a", "13"], " ", 
      SuperscriptBox["b", "5"], " ", 
      SuperscriptBox["x", "5"]}], "+", 
     RowBox[{"27132", " ", 
      SuperscriptBox["a", "12"], " ", 
      SuperscriptBox["b", "6"], " ", 
      SuperscriptBox["x", "6"]}], "+", 
     RowBox[{"50388", " ", 
      SuperscriptBox["a", "11"], " ", 
      SuperscriptBox["b", "7"], " ", 
      SuperscriptBox["x", "7"]}], "+", 
     RowBox[{"75582", " ", 
      SuperscriptBox["a", "10"], " ", 
      SuperscriptBox["b", "8"], " ", 
      SuperscriptBox["x", "8"]}], "+", 
     RowBox[{"92378", " ", 
      SuperscriptBox["a", "9"], " ", 
      SuperscriptBox["b", "9"], " ", 
      SuperscriptBox["x", "9"]}], "+", 
     RowBox[{"92378", " ", 
      SuperscriptBox["a", "8"], " ", 
      SuperscriptBox["b", "10"], " ", 
      SuperscriptBox["x", "10"]}], "+", 
     RowBox[{"75582", " ", 
      SuperscriptBox["a", "7"], " ", 
      SuperscriptBox["b", "11"], " ", 
      SuperscriptBox["x", "11"]}], "+", 
     RowBox[{"50388", " ", 
      SuperscriptBox["a", "6"], " ", 
      SuperscriptBox["b", "12"], " ", 
      SuperscriptBox["x", "12"]}], "+", 
     RowBox[{"27132", " ", 
      SuperscriptBox["a", "5"], " ", 
      SuperscriptBox["b", "13"], " ", 
      SuperscriptBox["x", "13"]}], "+", 
     RowBox[{"11628", " ", 
      SuperscriptBox["a", "4"], " ", 
      SuperscriptBox["b", "14"], " ", 
      SuperscriptBox["x", "14"]}], "+", 
     RowBox[{"3876", " ", 
      SuperscriptBox["a", "3"], " ", 
      SuperscriptBox["b", "15"], " ", 
      SuperscriptBox["x", "15"]}], "+", 
     RowBox[{"969", " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["b", "16"], " ", 
      SuperscriptBox["x", "16"]}], "+", 
     RowBox[{"171", " ", "a", " ", 
      SuperscriptBox["b", "17"], " ", 
      SuperscriptBox["x", "17"]}], "+", 
     RowBox[{"19", " ", 
      SuperscriptBox["b", "18"], " ", 
      SuperscriptBox["x", "18"]}]}], ")"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4466865425449038`*^9, 3.423013141796875*^9}, 
   3.423171538015625*^9, 3.4561670576790624`*^9, 3.489879646123553*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " knows the rule for arbitrary n, but needlessly expands the integrand when \
n is an integer:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.444322558662424*^9, 3.444322586131923*^9}, {
   3.4466780286625423`*^9, 3.446678029423637*^9}, {3.4466948967576723`*^9, 
   3.42317159478125*^9}, 3.423174910453125*^9, {3.423332331546875*^9, 
   3.423332347125*^9}, {3.423332380203125*^9, 3.42333240928125*^9}, 
   3.423341072625*^9, 3.4561670576790624`*^9, 3.4821759878804445`*^9, 
   3.4821761016640577`*^9, 3.4821761392881584`*^9, 3.482176179285672*^9, 
   3.4821770498975506`*^9, {3.489804505429864*^9, 3.489804512039873*^9}, {
   3.4898045424699154`*^9, 3.4898045431099167`*^9}, {3.4898045772899647`*^9, 
   3.4898046123600135`*^9}, {3.4898048582503576`*^9, 3.489804864160366*^9}, {
   3.4898049421404753`*^9, 3.4898049903205423`*^9}, {3.4898052429608965`*^9, 
   3.489805244530898*^9}, {3.489805282760952*^9, 3.4898052829509525`*^9}, 
   3.48987627971564*^9, 3.4898763360473385`*^9, 3.4898801008955517`*^9, {
   3.489880232138582*^9, 3.489880277363062*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "2"}], ")"}]}], "/", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}]}], ",", " ", "x"}], 
    ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.446686597634118*^9, 3.423013158640625*^9}, 
   3.423171538015625*^9, 3.423177651234375*^9, {3.4557531060742793`*^9, 
   3.4557531121040316`*^9}, 3.4561670576790624`*^9, 3.456167213613285*^9, 
   3.489879658806375*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["x", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "n"}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], 
    RowBox[{"1", "-", "n"}]]}], 
  RowBox[{"a", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "n"}], ")"}]}]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.4557530051911125`*^9, 3.4561670576790624`*^9, 
  3.456167213613285*^9, 3.489879658806375*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "18"}], "/", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}], "^", "20"}]}], ",", " ", "x"}], 
    ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.446686597634118*^9, 3.423013158640625*^9}, 
   3.423171538015625*^9, 3.423177651234375*^9, 3.4561670576790624`*^9, 
   3.456167213613285*^9, 3.489879658806375*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    SuperscriptBox["a", "18"], 
    RowBox[{"19", " ", 
     SuperscriptBox["b", "19"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "19"]}]]}], "+", 
  FractionBox[
   SuperscriptBox["a", "17"], 
   RowBox[{
    SuperscriptBox["b", "19"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "18"]}]], "-", 
  FractionBox[
   RowBox[{"9", " ", 
    SuperscriptBox["a", "16"]}], 
   RowBox[{
    SuperscriptBox["b", "19"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "17"]}]], "+", 
  FractionBox[
   RowBox[{"51", " ", 
    SuperscriptBox["a", "15"]}], 
   RowBox[{
    SuperscriptBox["b", "19"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "16"]}]], "-", 
  FractionBox[
   RowBox[{"204", " ", 
    SuperscriptBox["a", "14"]}], 
   RowBox[{
    SuperscriptBox["b", "19"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "15"]}]], "+", 
  FractionBox[
   RowBox[{"612", " ", 
    SuperscriptBox["a", "13"]}], 
   RowBox[{
    SuperscriptBox["b", "19"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "14"]}]], "-", 
  FractionBox[
   RowBox[{"1428", " ", 
    SuperscriptBox["a", "12"]}], 
   RowBox[{
    SuperscriptBox["b", "19"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "13"]}]], "+", 
  FractionBox[
   RowBox[{"2652", " ", 
    SuperscriptBox["a", "11"]}], 
   RowBox[{
    SuperscriptBox["b", "19"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "12"]}]], "-", 
  FractionBox[
   RowBox[{"3978", " ", 
    SuperscriptBox["a", "10"]}], 
   RowBox[{
    SuperscriptBox["b", "19"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "11"]}]], "+", 
  FractionBox[
   RowBox[{"4862", " ", 
    SuperscriptBox["a", "9"]}], 
   RowBox[{
    SuperscriptBox["b", "19"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "10"]}]], "-", 
  FractionBox[
   RowBox[{"4862", " ", 
    SuperscriptBox["a", "8"]}], 
   RowBox[{
    SuperscriptBox["b", "19"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "9"]}]], "+", 
  FractionBox[
   RowBox[{"3978", " ", 
    SuperscriptBox["a", "7"]}], 
   RowBox[{
    SuperscriptBox["b", "19"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "8"]}]], "-", 
  FractionBox[
   RowBox[{"2652", " ", 
    SuperscriptBox["a", "6"]}], 
   RowBox[{
    SuperscriptBox["b", "19"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "7"]}]], "+", 
  FractionBox[
   RowBox[{"1428", " ", 
    SuperscriptBox["a", "5"]}], 
   RowBox[{
    SuperscriptBox["b", "19"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "6"]}]], "-", 
  FractionBox[
   RowBox[{"612", " ", 
    SuperscriptBox["a", "4"]}], 
   RowBox[{
    SuperscriptBox["b", "19"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "5"]}]], "+", 
  FractionBox[
   RowBox[{"204", " ", 
    SuperscriptBox["a", "3"]}], 
   RowBox[{
    SuperscriptBox["b", "19"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "4"]}]], "-", 
  FractionBox[
   RowBox[{"51", " ", 
    SuperscriptBox["a", "2"]}], 
   RowBox[{
    SuperscriptBox["b", "19"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "3"]}]], "+", 
  FractionBox[
   RowBox[{"9", " ", "a"}], 
   RowBox[{
    SuperscriptBox["b", "19"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "2"]}]], "-", 
  FractionBox["1", 
   RowBox[{
    SuperscriptBox["b", "19"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}]}]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.42301709309375*^9, 3.423171538015625*^9, 
  3.4561670576790624`*^9, 3.456167213613285*^9, 3.489879658806375*^9}]
}, Closed]],

Cell["", "PageBreak",
 CellGroupingRules->{GroupTogetherGrouping, 10004.},
 PageBreakBelow->True,
 CellChangeTimes->{3.4561670576790624`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Rational Function Integration Problem 6", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, 3.4821887134568386`*^9, 
   3.489879301830948*^9, 3.489891423911021*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "17"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "20"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881630453854`*^9, 
   3.4903833188536043`*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " knows and takes advantage of the general rule for arbitrary n:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443225459641647`*^9, 3.4443225485078225`*^9}, {
   3.4466948911496077`*^9, 3.42301074665625*^9}, 3.42317159478125*^9, {
   3.423174840640625*^9, 3.423174854046875*^9}, {3.4233322945*^9, 
   3.4233323091875*^9}, {3.42333236403125*^9, 3.423332366546875*^9}, {
   3.423332643984375*^9, 3.42333264684375*^9}, 3.423341072609375*^9, 
   3.4561670576690483`*^9, 3.4791559290778675`*^9, 3.482175999467106*^9, {
   3.482176939178344*^9, 3.482176943534608*^9}, 3.4821770265840273`*^9, 
   3.4898796407415433`*^9, {3.4898801760096836`*^9, 3.4898801822808943`*^9}}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", 
     RowBox[{"n", "-", "3"}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "n"]], ",", " ", "x"}], 
  "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.446686303711478*^9, 3.423013182015625*^9}, 
   3.423171538015625*^9, 3.42317763434375*^9, {3.4557529403662663`*^9, 
   3.455752945244156*^9}, 3.4561670576690483`*^9, 3.4791561846753983`*^9, 
   3.4898796679791913`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{
       RowBox[{"-", "2"}], "+", "n"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], 
      RowBox[{"1", "-", "n"}]]}], 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", "n"}], ")"}]}]]}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["x", 
     RowBox[{
      RowBox[{"-", "2"}], "+", "n"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], 
     RowBox[{"2", "-", "n"}]]}], 
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", "n"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"2", "-", "n"}], ")"}]}]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{3.479156188100323*^9, 3.4898796679791913`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "17"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "20"]], ",", " ", "x"}], 
  "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.446686303711478*^9, 3.423013182015625*^9}, 
   3.423171538015625*^9, {3.423177606828125*^9, 3.423177628796875*^9}, 
   3.456167069265723*^9, 3.4898796679791913`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SuperscriptBox["x", "18"], 
   RowBox[{"19", " ", "a", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "19"]}]], "+", 
  FractionBox[
   SuperscriptBox["x", "18"], 
   RowBox[{"342", " ", 
    SuperscriptBox["a", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "18"]}]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4466863419063997`*^9, 3.42301318265625*^9}, 
   3.423171538015625*^9, 3.42317766846875*^9, 3.456167069265723*^9, 
   3.4898796679791913`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " knows the rule for arbitrary n, but needlessly expands the integrand when \
n is an integer:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.444322558662424*^9, 3.444322586131923*^9}, {
   3.4466780286625423`*^9, 3.446678029423637*^9}, {3.4466948967576723`*^9, 
   3.42317159478125*^9}, 3.423174910453125*^9, {3.423332331546875*^9, 
   3.423332347125*^9}, {3.423332380203125*^9, 3.42333240928125*^9}, 
   3.423341072625*^9, 3.4561670576790624`*^9, 3.4821759878804445`*^9, 
   3.4821761016640577`*^9, 3.4821761392881584`*^9, 3.482176179285672*^9, 
   3.4821770498975506`*^9, {3.489804505429864*^9, 3.489804512039873*^9}, {
   3.4898045424699154`*^9, 3.4898045431099167`*^9}, {3.4898045772899647`*^9, 
   3.4898046123600135`*^9}, {3.4898048582503576`*^9, 3.489804864160366*^9}, {
   3.4898049421404753`*^9, 3.4898049903205423`*^9}, {3.4898052429608965`*^9, 
   3.489805244530898*^9}, {3.489805282760952*^9, 3.4898052829509525`*^9}, 
   3.48987627971564*^9, 3.4898763360473385`*^9, 3.4898801008955517`*^9, {
   3.489880232138582*^9, 3.489880256724225*^9}, 3.4898802978146973`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", 
     RowBox[{"n", "-", "3"}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "n"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.446686303711478*^9, 3.446686355045293*^9}, {
   3.446686541142888*^9, 3.42301314003125*^9}, 3.423171538015625*^9, 
   3.455753003919055*^9, 3.4561670576790624`*^9, 3.4791562299505005`*^9, 
   3.4898796721131983`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["x", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "n"}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], 
    RowBox[{"1", "-", "n"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "n"}], ")"}]}], "+", 
     RowBox[{"b", " ", "x"}]}], ")"}]}], 
  RowBox[{
   SuperscriptBox["a", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "n"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "n"}], ")"}]}]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{3.479156231332488*^9, 3.4898796721131983`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "17"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "20"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.446686303711478*^9, 3.446686355045293*^9}, {
   3.446686541142888*^9, 3.42301314003125*^9}, 3.423171538015625*^9, {
   3.4231776153125*^9, 3.4231776161875*^9}, 3.456167069265723*^9, 
   3.4898796721131983`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"342", " ", 
     SuperscriptBox["b", "18"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "19"]}]], 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["a", "17"], "+", 
     RowBox[{"19", " ", 
      SuperscriptBox["a", "16"], " ", "b", " ", "x"}], "+", 
     RowBox[{"171", " ", 
      SuperscriptBox["a", "15"], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"969", " ", 
      SuperscriptBox["a", "14"], " ", 
      SuperscriptBox["b", "3"], " ", 
      SuperscriptBox["x", "3"]}], "+", 
     RowBox[{"3876", " ", 
      SuperscriptBox["a", "13"], " ", 
      SuperscriptBox["b", "4"], " ", 
      SuperscriptBox["x", "4"]}], "+", 
     RowBox[{"11628", " ", 
      SuperscriptBox["a", "12"], " ", 
      SuperscriptBox["b", "5"], " ", 
      SuperscriptBox["x", "5"]}], "+", 
     RowBox[{"27132", " ", 
      SuperscriptBox["a", "11"], " ", 
      SuperscriptBox["b", "6"], " ", 
      SuperscriptBox["x", "6"]}], "+", 
     RowBox[{"50388", " ", 
      SuperscriptBox["a", "10"], " ", 
      SuperscriptBox["b", "7"], " ", 
      SuperscriptBox["x", "7"]}], "+", 
     RowBox[{"75582", " ", 
      SuperscriptBox["a", "9"], " ", 
      SuperscriptBox["b", "8"], " ", 
      SuperscriptBox["x", "8"]}], "+", 
     RowBox[{"92378", " ", 
      SuperscriptBox["a", "8"], " ", 
      SuperscriptBox["b", "9"], " ", 
      SuperscriptBox["x", "9"]}], "+", 
     RowBox[{"92378", " ", 
      SuperscriptBox["a", "7"], " ", 
      SuperscriptBox["b", "10"], " ", 
      SuperscriptBox["x", "10"]}], "+", 
     RowBox[{"75582", " ", 
      SuperscriptBox["a", "6"], " ", 
      SuperscriptBox["b", "11"], " ", 
      SuperscriptBox["x", "11"]}], "+", 
     RowBox[{"50388", " ", 
      SuperscriptBox["a", "5"], " ", 
      SuperscriptBox["b", "12"], " ", 
      SuperscriptBox["x", "12"]}], "+", 
     RowBox[{"27132", " ", 
      SuperscriptBox["a", "4"], " ", 
      SuperscriptBox["b", "13"], " ", 
      SuperscriptBox["x", "13"]}], "+", 
     RowBox[{"11628", " ", 
      SuperscriptBox["a", "3"], " ", 
      SuperscriptBox["b", "14"], " ", 
      SuperscriptBox["x", "14"]}], "+", 
     RowBox[{"3876", " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["b", "15"], " ", 
      SuperscriptBox["x", "15"]}], "+", 
     RowBox[{"969", " ", "a", " ", 
      SuperscriptBox["b", "16"], " ", 
      SuperscriptBox["x", "16"]}], "+", 
     RowBox[{"171", " ", 
      SuperscriptBox["b", "17"], " ", 
      SuperscriptBox["x", "17"]}]}], ")"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4466865425449038`*^9, 3.423013141796875*^9}, 
   3.423171538015625*^9, 3.423177675796875*^9, 3.456167069265723*^9, 
   3.4898796721131983`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " knows the rule for arbitrary n, but needlessly expands the integrand when \
n is an integer:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.444322558662424*^9, 3.444322586131923*^9}, {
   3.4466780286625423`*^9, 3.446678029423637*^9}, {3.4466948967576723`*^9, 
   3.42317159478125*^9}, 3.423174910453125*^9, {3.423332331546875*^9, 
   3.423332347125*^9}, {3.423332380203125*^9, 3.42333240928125*^9}, 
   3.423341072625*^9, 3.4561670576790624`*^9, 3.4821759878804445`*^9, 
   3.4821761016640577`*^9, 3.4821761392881584`*^9, 3.482176179285672*^9, 
   3.4821770498975506`*^9, {3.489804505429864*^9, 3.489804512039873*^9}, {
   3.4898045424699154`*^9, 3.4898045431099167`*^9}, {3.4898045772899647`*^9, 
   3.4898046123600135`*^9}, {3.4898048582503576`*^9, 3.489804864160366*^9}, {
   3.4898049421404753`*^9, 3.4898049903205423`*^9}, {3.4898052429608965`*^9, 
   3.489805244530898*^9}, {3.489805282760952*^9, 3.4898052829509525`*^9}, 
   3.48987627971564*^9, 3.4898763360473385`*^9, 3.4898801008955517`*^9, {
   3.489880232138582*^9, 3.489880277363062*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "2"}], ")"}]}], "/", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}]}], ",", " ", "x"}], 
    ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.446686597634118*^9, 3.423013158640625*^9}, 
   3.423171538015625*^9, 3.423177651234375*^9, {3.4557531060742793`*^9, 
   3.4557531121040316`*^9}, 3.4561670576790624`*^9, 3.456167213613285*^9, 
   3.48987967871201*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["x", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "n"}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], 
    RowBox[{"1", "-", "n"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "n"}], ")"}]}], "+", 
     RowBox[{"b", " ", "x"}]}], ")"}]}], 
  RowBox[{
   SuperscriptBox["a", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "n"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "n"}], ")"}]}]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.479156231332488*^9, 3.48987967871201*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "17"}], "/", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}], "^", "20"}]}], ",", " ", "x"}], 
    ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.446686597634118*^9, 3.423013158640625*^9}, 
   3.423171538015625*^9, {3.42317762090625*^9, 3.42317762525*^9}, 
   3.456167069265723*^9, 3.48987967871201*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SuperscriptBox["a", "17"], 
   RowBox[{"19", " ", 
    SuperscriptBox["b", "18"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "19"]}]], "-", 
  FractionBox[
   RowBox[{"17", " ", 
    SuperscriptBox["a", "16"]}], 
   RowBox[{"18", " ", 
    SuperscriptBox["b", "18"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "18"]}]], "+", 
  FractionBox[
   RowBox[{"8", " ", 
    SuperscriptBox["a", "15"]}], 
   RowBox[{
    SuperscriptBox["b", "18"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "17"]}]], "-", 
  FractionBox[
   RowBox[{"85", " ", 
    SuperscriptBox["a", "14"]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "18"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "16"]}]], "+", 
  FractionBox[
   RowBox[{"476", " ", 
    SuperscriptBox["a", "13"]}], 
   RowBox[{"3", " ", 
    SuperscriptBox["b", "18"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "15"]}]], "-", 
  FractionBox[
   RowBox[{"442", " ", 
    SuperscriptBox["a", "12"]}], 
   RowBox[{
    SuperscriptBox["b", "18"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "14"]}]], "+", 
  FractionBox[
   RowBox[{"952", " ", 
    SuperscriptBox["a", "11"]}], 
   RowBox[{
    SuperscriptBox["b", "18"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "13"]}]], "-", 
  FractionBox[
   RowBox[{"4862", " ", 
    SuperscriptBox["a", "10"]}], 
   RowBox[{"3", " ", 
    SuperscriptBox["b", "18"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "12"]}]], "+", 
  FractionBox[
   RowBox[{"2210", " ", 
    SuperscriptBox["a", "9"]}], 
   RowBox[{
    SuperscriptBox["b", "18"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "11"]}]], "-", 
  FractionBox[
   RowBox[{"2431", " ", 
    SuperscriptBox["a", "8"]}], 
   RowBox[{
    SuperscriptBox["b", "18"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "10"]}]], "+", 
  FractionBox[
   RowBox[{"19448", " ", 
    SuperscriptBox["a", "7"]}], 
   RowBox[{"9", " ", 
    SuperscriptBox["b", "18"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "9"]}]], "-", 
  FractionBox[
   RowBox[{"1547", " ", 
    SuperscriptBox["a", "6"]}], 
   RowBox[{
    SuperscriptBox["b", "18"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "8"]}]], "+", 
  FractionBox[
   RowBox[{"884", " ", 
    SuperscriptBox["a", "5"]}], 
   RowBox[{
    SuperscriptBox["b", "18"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "7"]}]], "-", 
  FractionBox[
   RowBox[{"1190", " ", 
    SuperscriptBox["a", "4"]}], 
   RowBox[{"3", " ", 
    SuperscriptBox["b", "18"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "6"]}]], "+", 
  FractionBox[
   RowBox[{"136", " ", 
    SuperscriptBox["a", "3"]}], 
   RowBox[{
    SuperscriptBox["b", "18"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "5"]}]], "-", 
  FractionBox[
   RowBox[{"34", " ", 
    SuperscriptBox["a", "2"]}], 
   RowBox[{
    SuperscriptBox["b", "18"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "4"]}]], "+", 
  FractionBox[
   RowBox[{"17", " ", "a"}], 
   RowBox[{"3", " ", 
    SuperscriptBox["b", "18"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "3"]}]], "-", 
  FractionBox["1", 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "18"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "2"]}]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4231782581875*^9, 3.423178262859375*^9}, 
   3.456167069265723*^9, 3.48987967871201*^9}]
}, Closed]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Rational Function Integration Problem 7", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4898793056217546`*^9, 
   3.4898914266810246`*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881630453854`*^9, 
   3.4821891543207693`*^9, 3.490383320653607*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " knows and always uses the symmetric rules:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443225459641647`*^9, 3.4443225485078225`*^9}, {
   3.4466948911496077`*^9, 3.42301074665625*^9}, 3.42317159478125*^9, {
   3.423174840640625*^9, 3.423174854046875*^9}, {3.4233322945*^9, 
   3.4233323091875*^9}, {3.42333236403125*^9, 3.423332366546875*^9}, {
   3.423332643984375*^9, 3.42333264684375*^9}, 3.423341072609375*^9, 
   3.4561670576690483`*^9, 3.4791559290778675`*^9, 3.4821760103727875`*^9, {
   3.4821769533286915`*^9, 3.4821769582657905`*^9}, 3.48217705875028*^9, 
   3.482189249267296*^9, 3.489879689522829*^9, {3.4898804807406187`*^9, 
   3.489880480912219*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}]}]], ",", "x"}], "]"}], ",", " ", 
   RowBox[{"Int", "[", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"a", "-", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}]}]], ",", "x"}], "]"}]}], "}"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794213586063`*^9}, 3.444281211863226*^9, {3.4442813416698785`*^9, 
   3.4442813421705985`*^9}, {3.444281398571699*^9, 3.42317152809375*^9}, {
   3.423188296984375*^9, 3.423188301421875*^9}, {3.4557537359530325`*^9, 
   3.455753770589052*^9}, 3.489879689522829*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{
       SqrtBox["b"], " ", "x"}], 
      SqrtBox["a"]], "]"}], 
    RowBox[{
     SqrtBox["a"], " ", 
     SqrtBox["b"]}]], ",", 
   FractionBox[
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      RowBox[{
       SqrtBox["b"], " ", "x"}], 
      SqrtBox["a"]], "]"}], 
    RowBox[{
     SqrtBox["a"], " ", 
     SqrtBox["b"]}]]}], "}"}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.45575373956888*^9, 3.4557537718110285`*^9}, 
   3.489879689522829*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"4", "+", 
       SuperscriptBox["x", "2"]}]], ",", "x"}], "]"}], ",", " ", 
   RowBox[{"Int", "[", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"4", "-", 
       SuperscriptBox["x", "2"]}]], ",", "x"}], "]"}]}], "}"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794213586063`*^9}, 3.444281211863226*^9, {3.4442813416698785`*^9, 
   3.4442813421705985`*^9}, {3.444281398571699*^9, 3.42317152809375*^9}, {
   3.423188296984375*^9, 3.423188301421875*^9}, {3.45575386664441*^9, 
   3.455753884903942*^9}, 3.489879689522829*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox["x", "2"], "]"}]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"ArcTanh", "[", 
     FractionBox["x", "2"], "]"}]}]}], "}"}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.4442796635368414`*^9, 3.4442812266344657`*^9, 3.444281343242139*^9, {
   3.444281405071045*^9, 3.42317152809375*^9}, 3.423188307125*^9, 
   3.4557538893411193`*^9, 3.489879689522829*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " knows the symmetric rules but does not always use them:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.444322558662424*^9, 3.444322586131923*^9}, {
   3.4466780286625423`*^9, 3.446678029423637*^9}, {3.4466948967576723`*^9, 
   3.42317159478125*^9}, 3.423174910453125*^9, {3.423332331546875*^9, 
   3.423332347125*^9}, {3.423332380203125*^9, 3.42333240928125*^9}, 
   3.423341072625*^9, 3.4561670576790624`*^9, 3.4821760138077264`*^9, 
   3.4821761053794003`*^9, 3.4821761433439903`*^9, 3.4821761882786036`*^9, 
   3.482177065079381*^9, 3.4821892817239666`*^9, 3.4898796942964373`*^9, {
   3.489880483611024*^9, 3.4898804837826242`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], ",", " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"a", "-", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "}"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794213586063`*^9}, 3.444281211863226*^9, {3.4442813416698785`*^9, 
   3.4442813421705985`*^9}, {3.444281398571699*^9, 3.42317152809375*^9}, {
   3.423188296984375*^9, 3.423188301421875*^9}, {3.4557537359530325`*^9, 
   3.455753802480633*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{
       SqrtBox["b"], " ", "x"}], 
      SqrtBox["a"]], "]"}], 
    RowBox[{
     SqrtBox["a"], " ", 
     SqrtBox["b"]}]], ",", 
   FractionBox[
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      RowBox[{
       SqrtBox["b"], " ", "x"}], 
      SqrtBox["a"]], "]"}], 
    RowBox[{
     SqrtBox["a"], " ", 
     SqrtBox["b"]}]]}], "}"}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{3.4557538041333055`*^9, 3.4898796942964373`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"4", "+", 
       SuperscriptBox["x", "2"]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], ",", " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"4", "-", 
       SuperscriptBox["x", "2"]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "}"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
  3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
  3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
  3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
  3.4442794581114545`*^9}, {3.444281528728856*^9, 3.42317152809375*^9}, {
  3.423188342609375*^9, 3.423188345859375*^9}, {3.4557539034238963`*^9, 
  3.455753912889205*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox["x", "2"], "]"}]}], ",", 
   RowBox[{
    RowBox[{
     FractionBox["1", "4"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"-", "2"}], "-", "x"}], "]"}]}], "-", 
    RowBox[{
     FractionBox["1", "4"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"-", "2"}], "+", "x"}], "]"}]}]}]}], "}"}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{
  3.4442796668616223`*^9, 3.444281548757656*^9, {3.4466830253474226`*^9, 
   3.42317152809375*^9}, 3.42318834725*^9, 3.4557539175667706`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " knows the symmetric rules but does not always use them:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.444322558662424*^9, 3.444322612239464*^9}, {
   3.444322789243984*^9, 3.444322790265453*^9}, {3.4443228380341406`*^9, 
   3.444322843231614*^9}, {3.444322931999256*^9, 3.444322937186715*^9}, {
   3.4466780338700304`*^9, 3.4466780349716144`*^9}, 3.446679270337984*^9, {
   3.4466793247562337`*^9, 3.4466793254271984`*^9}, {3.446694901734829*^9, 
   3.423010829046875*^9}, 3.42317159478125*^9, 3.42317494815625*^9, {
   3.42333242146875*^9, 3.42333243090625*^9}, 3.42334107265625*^9, 
   3.4561670576790624`*^9, 3.456167213613285*^9, 3.482176015900736*^9, {
   3.482176395426467*^9, 3.482176398120341*^9}, 3.482177069005026*^9, 
   3.4821893036555023`*^9, 3.4898797465097294`*^9, {3.4898804873082304`*^9, 
   3.4898804874798307`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"[", 
   RowBox[{
    RowBox[{"int", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"x", "^", "2"}]}]}], ")"}]}], ",", "x"}], ")"}]}], ",", 
    " ", 
    RowBox[{"int", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"a", "-", 
          RowBox[{"b", "*", 
           RowBox[{"x", "^", "2"}]}]}], ")"}]}], ",", "x"}], ")"}]}]}], "]"}],
   ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794581114545`*^9}, 3.444281528728856*^9, {3.446683220447963*^9, 
   3.4466832311533566`*^9}, {3.4466833507853794`*^9, 3.42317152809375*^9}, 
   3.423177640953125*^9, {3.42318836565625*^9, 3.42318837009375*^9}, {
   3.455753980625945*^9, 3.4557540004370003`*^9}, {3.4557541656760187`*^9, 
   3.455754176402833*^9}, 3.4898797465097294`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"b", " ", "x"}], 
      SqrtBox[
       RowBox[{"a", " ", "b"}]]], "]"}], 
    SqrtBox[
     RowBox[{"a", " ", "b"}]]], ",", 
   FractionBox[
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      RowBox[{"b", " ", "x"}], 
      SqrtBox[
       RowBox[{"a", " ", "b"}]]], "]"}], 
    SqrtBox[
     RowBox[{"a", " ", "b"}]]]}], "}"}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.455754360130834*^9, 3.4898797465097294`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"[", 
   RowBox[{
    RowBox[{"int", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"4", "+", 
          RowBox[{"x", "^", "2"}]}], ")"}]}], ",", "x"}], ")"}]}], ",", " ", 
    RowBox[{"int", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"4", "-", 
          RowBox[{"x", "^", "2"}]}], ")"}]}], ",", "x"}], ")"}]}]}], "]"}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794581114545`*^9}, 3.444281528728856*^9, {3.446683220447963*^9, 
   3.4466832311533566`*^9}, {3.4466833507853794`*^9, 3.42317152809375*^9}, 
   3.423177640953125*^9, {3.42318836565625*^9, 3.42318837009375*^9}, {
   3.455753980625945*^9, 3.4557540004370003`*^9}, 3.4898797465097294`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox["x", "2"], "]"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "4"]}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"-", "2"}], "+", "x"}], "]"}]}], "+", 
    RowBox[{
     FractionBox["1", "4"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"2", "+", "x"}], "]"}]}]}]}], "}"}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.4557543720294857`*^9, 3.4898797465097294`*^9}]
}, Closed]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Rational Function Integration Problem 8", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.482189925890232*^9, 
   3.489879310785364*^9, 3.489891429431029*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881630453854`*^9, 
   3.4821891658573585`*^9, 3.4903833227136097`*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " results are symmetric:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443225459641647`*^9, 3.4443225485078225`*^9}, {
   3.4466948911496077`*^9, 3.42301074665625*^9}, 3.42317159478125*^9, {
   3.423174840640625*^9, 3.423174854046875*^9}, {3.4233322945*^9, 
   3.4233323091875*^9}, {3.42333236403125*^9, 3.423332366546875*^9}, {
   3.423332643984375*^9, 3.42333264684375*^9}, 3.423341072609375*^9, 
   3.4561670576690483`*^9, 3.4791559290778675`*^9, 3.4821760103727875`*^9, {
   3.4821769533286915`*^9, 3.4821769582657905`*^9}, 3.48217705875028*^9, 
   3.4821893863844604`*^9, 3.4826461392445583`*^9, 3.4898797548713436`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"3", "+", 
     RowBox[{"5", " ", "x"}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["x", "2"]}]}]], ",", " ", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794213586063`*^9}, 3.444281211863226*^9, {3.4442813416698785`*^9, 
   3.4442813421705985`*^9}, {3.444281398571699*^9, 3.42317152809375*^9}, 
   3.4898797548713436`*^9, 3.4898806322792845`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{"5", "+", 
      RowBox[{"8", " ", "x"}]}], 
     SqrtBox["23"]], "]"}]}], 
  SqrtBox["23"]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.4442796635368414`*^9, 3.4442812266344657`*^9, 3.444281343242139*^9, {
   3.444281405071045*^9, 3.42317152809375*^9}, 3.4898797548713436`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"3", "+", 
     RowBox[{"5", " ", "x"}], "-", 
     RowBox[{"4", " ", 
      SuperscriptBox["x", "2"]}]}]], ",", " ", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794271269007`*^9}, {3.444281234095194*^9, 3.44428124041428*^9}, {
   3.4442813318557663`*^9, 3.444281332166213*^9}, {3.444281496101941*^9, 
   3.42317152809375*^9}, 3.4898797548713436`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      RowBox[{"5", "-", 
       RowBox[{"8", " ", "x"}]}], 
      SqrtBox["73"]], "]"}]}], 
   SqrtBox["73"]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.4442796653394337`*^9, 3.444281241716152*^9, 3.444281333498128*^9, {
   3.444281503212165*^9, 3.42317152809375*^9}, 3.4898797548713436`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " results are ",
 StyleBox["not",
  FontSlant->"Italic"],
 " symmetric:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443225459641647`*^9, 3.4443225485078225`*^9}, {
   3.4466948911496077`*^9, 3.42301074665625*^9}, 3.42317159478125*^9, {
   3.423174840640625*^9, 3.423174854046875*^9}, {3.4233322945*^9, 
   3.4233323091875*^9}, {3.42333236403125*^9, 3.423332366546875*^9}, {
   3.423332643984375*^9, 3.42333264684375*^9}, 3.423341072609375*^9, 
   3.4561670576690483`*^9, 3.4791559290778675`*^9, 3.4821760103727875`*^9, {
   3.4821769533286915`*^9, 3.4821769582657905`*^9}, 3.48217705875028*^9, {
   3.4821893863844604`*^9, 3.4821894157867393`*^9}, 3.482646199250843*^9, 
   3.489879759613752*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"3", "+", 
     RowBox[{"5", " ", "x"}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
  3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
  3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
  3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
  3.4442794581114545`*^9}, {3.444281528728856*^9, 3.42317152809375*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{"5", "+", 
      RowBox[{"8", " ", "x"}]}], 
     SqrtBox["23"]], "]"}]}], 
  SqrtBox["23"]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{
  3.4442796668616223`*^9, 3.444281548757656*^9, {3.4466830253474226`*^9, 
   3.42317152809375*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"3", "+", 
     RowBox[{"5", " ", "x"}], "-", 
     RowBox[{"4", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
  3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
  3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
  3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
  3.4442794621672864`*^9}, {3.444281539193904*^9, 3.42317152809375*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Log", "[", 
     RowBox[{"5", "+", 
      SqrtBox["73"], "-", 
      RowBox[{"8", " ", "x"}]}], "]"}]}], "+", 
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"-", "5"}], "+", 
     SqrtBox["73"], "+", 
     RowBox[{"8", " ", "x"}]}], "]"}]}], 
  SqrtBox["73"]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{
  3.4442796678931055`*^9, 3.444281551872134*^9, {3.446683027039856*^9, 
   3.42317152809375*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Maple",
  FontSlant->"Italic"],
 " results are symmetric:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443225459641647`*^9, 3.4443225485078225`*^9}, {
   3.4466948911496077`*^9, 3.42301074665625*^9}, 3.42317159478125*^9, {
   3.423174840640625*^9, 3.423174854046875*^9}, {3.4233322945*^9, 
   3.4233323091875*^9}, {3.42333236403125*^9, 3.423332366546875*^9}, {
   3.423332643984375*^9, 3.42333264684375*^9}, 3.423341072609375*^9, 
   3.4561670576690483`*^9, 3.4791559290778675`*^9, 3.4821760103727875`*^9, {
   3.4821769533286915`*^9, 3.4821769582657905`*^9}, 3.48217705875028*^9, {
   3.4821893863844604`*^9, 3.4821894388799458`*^9}, {3.482425061714336*^9, 
   3.4824250618845806`*^9}, 3.4826462349321504`*^9, 3.48987976382576*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"3", "+", 
        RowBox[{"5", "*", "x"}], "+", 
        RowBox[{"4", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}]}], ",", " ", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794581114545`*^9}, 3.444281528728856*^9, {3.446683220447963*^9, 
   3.4466832311533566`*^9}, {3.4466833507853794`*^9, 3.42317152809375*^9}, 
   3.423177640953125*^9, 3.48987976382576*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{"5", "+", 
      RowBox[{"8", " ", "x"}]}], 
     SqrtBox["23"]], "]"}]}], 
  SqrtBox["23"]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4466835453451424`*^9, 3.42317152809375*^9}, 
   3.48987976382576*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"3", "+", 
        RowBox[{"5", "*", "x"}], "-", 
        RowBox[{"4", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}]}], ",", " ", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4442790537299824`*^9, 3.444279074249488*^9}, {
   3.444279149978381*^9, 3.4442791757254033`*^9}, {3.444279216774429*^9, 
   3.444279225126438*^9}, {3.444279258995139*^9, 3.4442792620395164`*^9}, {
   3.444279293494747*^9, 3.4442793499959917`*^9}, {3.4442794173027744`*^9, 
   3.4442794581114545`*^9}, 3.444281528728856*^9, {3.446683220447963*^9, 
   3.4466832311533566`*^9}, {3.4466833507853794`*^9, 3.42317152809375*^9}, 
   3.423177642359375*^9, 3.48987976382576*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "5"}], "+", 
      RowBox[{"8", " ", "x"}]}], 
     SqrtBox["73"]], "]"}]}], 
  SqrtBox["73"]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4466835472178354`*^9, 3.42317152809375*^9}, 
   3.48987976382576*^9}]
}, Closed]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Rational Function Integration Problem 9", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.482189930476827*^9, {
   3.48987931421737*^9, 3.489879314872571*^9}, 3.489891432271033*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "n"], 
    RowBox[{"1", "-", 
     SuperscriptBox["x", "6"]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881630453854`*^9, 
   3.482189177033429*^9, {3.48988213841513*^9, 3.4898821441715403`*^9}, 
   3.490383324403612*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " results are relatively simple 3 term sums:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443225459641647`*^9, 3.4443225485078225`*^9}, {
   3.4466948911496077`*^9, 3.42301074665625*^9}, 3.42317159478125*^9, {
   3.423174840640625*^9, 3.423174854046875*^9}, {3.4233322945*^9, 
   3.4233323091875*^9}, {3.42333236403125*^9, 3.423332366546875*^9}, {
   3.423332643984375*^9, 3.42333264684375*^9}, 3.423341072609375*^9, 
   3.4561670576690483`*^9, 3.4791559290778675`*^9, 3.4821760103727875`*^9, {
   3.4821769533286915`*^9, 3.4821769582657905`*^9}, 3.48217705875028*^9, 
   3.4821893863844604`*^9, 3.4821894796585827`*^9, {3.482189612239224*^9, 
   3.4821896263495135`*^9}, 3.4826462979727983`*^9, 3.4898797779905844`*^9, {
   3.489881055133628*^9, 3.489881092916894*^9}, {3.48988120480029*^9, 
   3.489881225673127*^9}, {3.4898812711004066`*^9, 3.489881319819292*^9}, {
   3.4898814389567013`*^9, 3.4898814408599052`*^9}, {3.489881497207204*^9, 
   3.489881505740419*^9}, {3.489881821703374*^9, 3.4898818363361998`*^9}, {
   3.4898821546391587`*^9, 3.489882169552785*^9}, {3.4898829692125893`*^9, 
   3.489882972145395*^9}}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"1", "-", 
     SuperscriptBox["x", "6"]}]], ",", " ", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.446686303711478*^9, 3.423013182015625*^9}, 
   3.423171538015625*^9, 3.42317763434375*^9, {3.42318906584375*^9, 
   3.423189082625*^9}, 3.4898797779905844`*^9, {3.489881363452569*^9, 
   3.4898813653245726`*^9}, {3.489881645906665*^9, 3.489881648121869*^9}, {
   3.4898817220347986`*^9, 3.4898817227368*^9}, {3.489881792500123*^9, 
   3.48988180243734*^9}, 3.4898818641822486`*^9, {3.4898819029951167`*^9, 
   3.4898819032291174`*^9}, {3.489881950996401*^9, 3.4898819779220486`*^9}, {
   3.4898820115089073`*^9, 3.489882011992508*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{
      SqrtBox["3"], " ", "x"}], 
     RowBox[{"1", "-", 
      SuperscriptBox["x", "2"]}]], "]"}], 
   RowBox[{"2", " ", 
    SqrtBox["3"]}]], "+", 
  FractionBox[
   RowBox[{"ArcTanh", "[", "x", "]"}], "3"], "+", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   RowBox[{"ArcTanh", "[", 
    FractionBox["x", 
     RowBox[{"1", "+", 
      SuperscriptBox["x", "2"]}]], "]"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.4898818647594495`*^9, 3.4898819036035175`*^9, {3.489881951916803*^9, 
   3.4898819784212494`*^9}, 3.489882012429309*^9, 3.4898830647003574`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox["x", 
    RowBox[{"1", "-", 
     SuperscriptBox["x", "6"]}]], ",", " ", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.446686303711478*^9, 3.423013182015625*^9}, 
   3.423171538015625*^9, 3.42317763434375*^9, {3.42318906584375*^9, 
   3.423189082625*^9}, 3.4898797779905844`*^9, {3.489881363452569*^9, 
   3.4898813653245726`*^9}, {3.489881645906665*^9, 3.489881648121869*^9}, {
   3.4898817220347986`*^9, 3.4898817227368*^9}, {3.489881792500123*^9, 
   3.48988180243734*^9}, 3.4898818641822486`*^9, {3.4898819029951167`*^9, 
   3.4898819032291174`*^9}, {3.489881950996401*^9, 3.4898819779220486`*^9}, {
   3.4898820115089073`*^9, 3.489882011992508*^9}, {3.4898820451425667`*^9, 
   3.489882048621372*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{"1", "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["x", "2"]}]}], 
     SqrtBox["3"]], "]"}], 
   RowBox[{"2", " ", 
    SqrtBox["3"]}]], "-", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", 
     SuperscriptBox["x", "2"]}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "12"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", 
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["x", "4"]}], "]"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{3.4898820498069744`*^9, 3.4898830647003574`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "3"], 
    RowBox[{"1", "-", 
     SuperscriptBox["x", "6"]}]], ",", " ", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.446686303711478*^9, 3.423013182015625*^9}, 
   3.423171538015625*^9, 3.42317763434375*^9, {3.42318906584375*^9, 
   3.423189082625*^9}, 3.4898797779905844`*^9, {3.489881363452569*^9, 
   3.4898813653245726`*^9}, {3.489881645906665*^9, 3.489881648121869*^9}, {
   3.4898817220347986`*^9, 3.4898817227368*^9}, {3.489881792500123*^9, 
   3.48988180243734*^9}, 3.4898818641822486`*^9, {3.4898819029951167`*^9, 
   3.4898819032291174`*^9}, {3.489881950996401*^9, 3.4898819779220486`*^9}, {
   3.4898820115089073`*^9, 3.489882011992508*^9}, {3.4898820451425667`*^9, 
   3.489882075235019*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"1", "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["x", "2"]}]}], 
      SqrtBox["3"]], "]"}], 
    RowBox[{"2", " ", 
     SqrtBox["3"]}]]}], "-", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", 
     SuperscriptBox["x", "2"]}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "12"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", 
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["x", "4"]}], "]"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{3.489882076155421*^9, 3.4898830647003574`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "4"], 
    RowBox[{"1", "-", 
     SuperscriptBox["x", "6"]}]], ",", " ", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.446686303711478*^9, 3.423013182015625*^9}, 
   3.423171538015625*^9, 3.42317763434375*^9, {3.42318906584375*^9, 
   3.423189082625*^9}, 3.4898797779905844`*^9, {3.489881363452569*^9, 
   3.4898813653245726`*^9}, {3.489881645906665*^9, 3.489881648121869*^9}, {
   3.4898817220347986`*^9, 3.4898817227368*^9}, {3.489881792500123*^9, 
   3.48988180243734*^9}, 3.4898818641822486`*^9, {3.4898819029951167`*^9, 
   3.4898819032291174`*^9}, {3.489881950996401*^9, 3.4898819779220486`*^9}, {
   3.4898820115089073`*^9, 3.489882011992508*^9}, {3.4898820451425667`*^9, 
   3.4898820855934377`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{
       SqrtBox["3"], " ", "x"}], 
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"]}]], "]"}], 
    RowBox[{"2", " ", 
     SqrtBox["3"]}]]}], "+", 
  FractionBox[
   RowBox[{"ArcTanh", "[", "x", "]"}], "3"], "+", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   RowBox[{"ArcTanh", "[", 
    FractionBox["x", 
     RowBox[{"1", "+", 
      SuperscriptBox["x", "2"]}]], "]"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{3.4898820864358387`*^9, 3.4898830647003574`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " results are more complicated 6 term sums:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443225459641647`*^9, 3.4443225485078225`*^9}, {
   3.4466948911496077`*^9, 3.42301074665625*^9}, 3.42317159478125*^9, {
   3.423174840640625*^9, 3.423174854046875*^9}, {3.4233322945*^9, 
   3.4233323091875*^9}, {3.42333236403125*^9, 3.423332366546875*^9}, {
   3.423332643984375*^9, 3.42333264684375*^9}, 3.423341072609375*^9, 
   3.4561670576690483`*^9, 3.4791559290778675`*^9, 3.4821760103727875`*^9, {
   3.4821769533286915`*^9, 3.4821769582657905`*^9}, 3.48217705875028*^9, 
   3.4821893863844604`*^9, 3.4821894796585827`*^9, {3.482189612239224*^9, 
   3.4821896263495135`*^9}, {3.4821897134447503`*^9, 3.482189727484939*^9}, 
   3.4826463395626016`*^9, 3.489879783013793*^9, {3.4898828232587333`*^9, 
   3.4898828598251977`*^9}, {3.4898829533161616`*^9, 3.4898829619897766`*^9}, 
   3.4898830135166674`*^9, 3.489883073592373*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"1", "-", 
     SuperscriptBox["x", "6"]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.446686303711478*^9, 3.446686355045293*^9}, {
   3.446686541142888*^9, 3.42301314003125*^9}, 3.423171538015625*^9, 
   3.423189156828125*^9, 3.489879783013793*^9, 3.4898815241172514`*^9, 
   3.4898817631564713`*^9, 3.489882214356064*^9, 3.489883073592373*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "12"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"2", " ", 
     SqrtBox["3"], " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"2", " ", "x"}]}], 
       SqrtBox["3"]], "]"}]}], "+", 
    RowBox[{"2", " ", 
     SqrtBox["3"], " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{"1", "+", 
        RowBox[{"2", " ", "x"}]}], 
       SqrtBox["3"]], "]"}]}], "-", 
    RowBox[{"2", " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}], "]"}]}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", "x"}], "]"}]}], "-", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", "x", "+", 
      SuperscriptBox["x", "2"]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "x", "+", 
      SuperscriptBox["x", "2"]}], "]"}]}], ")"}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.489882232732896*^9, 3.489883073592373*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["x", 
    RowBox[{"1", "-", 
     SuperscriptBox["x", "6"]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.446686303711478*^9, 3.446686355045293*^9}, {
   3.446686541142888*^9, 3.42301314003125*^9}, 3.423171538015625*^9, 
   3.423189156828125*^9, 3.489879783013793*^9, 3.4898815241172514`*^9, 
   3.4898817631564713`*^9, {3.4898822016108413`*^9, 3.489882217491669*^9}, 
   3.489883073592373*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "12"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"2", " ", 
     SqrtBox["3"], " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"2", " ", "x"}]}], 
       SqrtBox["3"]], "]"}]}], "-", 
    RowBox[{"2", " ", 
     SqrtBox["3"], " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{"1", "+", 
        RowBox[{"2", " ", "x"}]}], 
       SqrtBox["3"]], "]"}]}], "-", 
    RowBox[{"2", " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}], "]"}]}], "-", 
    RowBox[{"2", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", "x"}], "]"}]}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", "x", "+", 
      SuperscriptBox["x", "2"]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "x", "+", 
      SuperscriptBox["x", "2"]}], "]"}]}], ")"}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.489882234511299*^9, 3.489883073592373*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "3"], 
    RowBox[{"1", "-", 
     SuperscriptBox["x", "6"]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.446686303711478*^9, 3.446686355045293*^9}, {
   3.446686541142888*^9, 3.42301314003125*^9}, 3.423171538015625*^9, 
   3.423189156828125*^9, 3.489879783013793*^9, 3.4898815241172514`*^9, 
   3.4898817631564713`*^9, {3.4898822016108413`*^9, 3.4898822064000497`*^9}, 
   3.489883073592373*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "12"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     SqrtBox["3"], " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"2", " ", "x"}]}], 
       SqrtBox["3"]], "]"}]}], "+", 
    RowBox[{"2", " ", 
     SqrtBox["3"], " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{"1", "+", 
        RowBox[{"2", " ", "x"}]}], 
       SqrtBox["3"]], "]"}]}], "-", 
    RowBox[{"2", " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}], "]"}]}], "-", 
    RowBox[{"2", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", "x"}], "]"}]}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", "x", "+", 
      SuperscriptBox["x", "2"]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "x", "+", 
      SuperscriptBox["x", "2"]}], "]"}]}], ")"}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.489882236258502*^9, 3.489883073592373*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "4"], 
    RowBox[{"1", "-", 
     SuperscriptBox["x", "6"]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.446686303711478*^9, 3.446686355045293*^9}, {
   3.446686541142888*^9, 3.42301314003125*^9}, 3.423171538015625*^9, 
   3.423189156828125*^9, 3.489879783013793*^9, 3.4898815241172514`*^9, 
   3.4898817631564713`*^9, {3.4898822016108413`*^9, 3.489882227226086*^9}, 
   3.489883073592373*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "12"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     SqrtBox["3"], " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"2", " ", "x"}]}], 
       SqrtBox["3"]], "]"}]}], "-", 
    RowBox[{"2", " ", 
     SqrtBox["3"], " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{"1", "+", 
        RowBox[{"2", " ", "x"}]}], 
       SqrtBox["3"]], "]"}]}], "-", 
    RowBox[{"2", " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}], "]"}]}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", "x"}], "]"}]}], "-", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", "x", "+", 
      SuperscriptBox["x", "2"]}], "]"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "x", "+", 
      SuperscriptBox["x", "2"]}], "]"}]}], ")"}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.4898822371165037`*^9, 3.489883073592373*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Maple",
  FontSlant->"Italic"],
 " results are more complicated 6 term sums:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443225459641647`*^9, 3.4443225485078225`*^9}, {
   3.4466948911496077`*^9, 3.42301074665625*^9}, 3.42317159478125*^9, {
   3.423174840640625*^9, 3.423174854046875*^9}, {3.4233322945*^9, 
   3.4233323091875*^9}, {3.42333236403125*^9, 3.423332366546875*^9}, {
   3.423332643984375*^9, 3.42333264684375*^9}, 3.423341072609375*^9, 
   3.4561670576690483`*^9, 3.4791559290778675`*^9, 3.4821760103727875`*^9, {
   3.4821769533286915`*^9, 3.4821769582657905`*^9}, 3.48217705875028*^9, 
   3.4821893863844604`*^9, 3.4821894796585827`*^9, {3.482189612239224*^9, 
   3.4821896263495135`*^9}, {3.4821897134447503`*^9, 3.482189727484939*^9}, 
   3.4826463395626016`*^9, 3.489879783013793*^9, {3.4898828232587333`*^9, 
   3.4898828598251977`*^9}, {3.4898829533161616`*^9, 
   3.4898829619897766`*^9}, {3.489883000833845*^9, 3.489883003173849*^9}, 
   3.489883079301983*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"x", "^", "6"}]}], ")"}]}], ",", " ", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.446686597634118*^9, 3.423013158640625*^9}, 
   3.423171538015625*^9, 3.423177651234375*^9, {3.423189203640625*^9, 
   3.423189215375*^9}, {3.489881813372959*^9, 3.48988181371616*^9}, 
   3.489882312386636*^9, 3.489883079301983*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "x"}]}], 
     SqrtBox["3"]], "]"}], 
   RowBox[{"2", " ", 
    SqrtBox["3"]}]], "+", 
  FractionBox[
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "x"}]}], 
     SqrtBox["3"]], "]"}], 
   RowBox[{"2", " ", 
    SqrtBox["3"]}]], "-", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", "x"}], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "12"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", "x", "+", 
     SuperscriptBox["x", "2"]}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "12"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", "x", "+", 
     SuperscriptBox["x", "2"]}], "]"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{3.489882366565531*^9, 3.489883079301983*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"x", "/", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"x", "^", "6"}]}], ")"}]}], ",", " ", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.446686597634118*^9, 3.423013158640625*^9}, 
   3.423171538015625*^9, 3.423177651234375*^9, {3.423189203640625*^9, 
   3.423189215375*^9}, {3.489881813372959*^9, 3.48988181371616*^9}, {
   3.489882292839802*^9, 3.4898823094226303`*^9}, 3.489883079301983*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "x"}]}], 
     SqrtBox["3"]], "]"}], 
   RowBox[{"2", " ", 
    SqrtBox["3"]}]], "-", 
  FractionBox[
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "x"}]}], 
     SqrtBox["3"]], "]"}], 
   RowBox[{"2", " ", 
    SqrtBox["3"]}]], "-", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", "x"}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "12"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", "x", "+", 
     SuperscriptBox["x", "2"]}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "12"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", "x", "+", 
     SuperscriptBox["x", "2"]}], "]"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{3.489882429886042*^9, 3.489883079301983*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "3"}], "/", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"x", "^", "6"}]}], ")"}]}], ",", " ", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.446686597634118*^9, 3.423013158640625*^9}, 
   3.423171538015625*^9, 3.423177651234375*^9, {3.423189203640625*^9, 
   3.423189215375*^9}, {3.489881813372959*^9, 3.48988181371616*^9}, {
   3.489882292839802*^9, 3.489882296817808*^9}, 3.489883079301983*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"2", " ", "x"}]}], 
      SqrtBox["3"]], "]"}], 
    RowBox[{"2", " ", 
     SqrtBox["3"]}]]}], "+", 
  FractionBox[
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "x"}]}], 
     SqrtBox["3"]], "]"}], 
   RowBox[{"2", " ", 
    SqrtBox["3"]}]], "-", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", "x"}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "12"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", "x", "+", 
     SuperscriptBox["x", "2"]}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "12"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", "x", "+", 
     SuperscriptBox["x", "2"]}], "]"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{3.4898825634222765`*^9, 3.489883079301983*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "4"}], "/", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"x", "^", "6"}]}], ")"}]}], ",", " ", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.446686597634118*^9, 3.423013158640625*^9}, 
   3.423171538015625*^9, 3.423177651234375*^9, {3.423189203640625*^9, 
   3.423189215375*^9}, {3.489881813372959*^9, 3.48988181371616*^9}, {
   3.489882292839802*^9, 3.4898823048830223`*^9}, 3.489883079301983*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"2", " ", "x"}]}], 
      SqrtBox["3"]], "]"}], 
    RowBox[{"2", " ", 
     SqrtBox["3"]}]]}], "-", 
  FractionBox[
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "x"}]}], 
     SqrtBox["3"]], "]"}], 
   RowBox[{"2", " ", 
    SqrtBox["3"]}]], "-", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", "x"}], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "12"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", "x", "+", 
     SuperscriptBox["x", "2"]}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "12"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", "x", "+", 
     SuperscriptBox["x", "2"]}], "]"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{3.489882615354768*^9, 3.489883079301983*^9}]
}, Closed]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Rational Function Integration Problem 10", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.482189930476827*^9, {
   3.48987931421737*^9, 3.489879314872571*^9}},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"1", "+", 
     SuperscriptBox["x", "8"]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881630453854`*^9, 
   3.482189177033429*^9, {3.48988213841513*^9, 3.4898821441715403`*^9}, {
   3.4898884719840813`*^9, 3.489888481594095*^9}, 3.4903833270436163`*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " result is a 4 term sum:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443225459641647`*^9, 3.4443225485078225`*^9}, {
   3.4466948911496077`*^9, 3.42301074665625*^9}, 3.42317159478125*^9, {
   3.423174840640625*^9, 3.423174854046875*^9}, {3.4233322945*^9, 
   3.4233323091875*^9}, {3.42333236403125*^9, 3.423332366546875*^9}, {
   3.423332643984375*^9, 3.42333264684375*^9}, 3.423341072609375*^9, 
   3.4561670576690483`*^9, 3.4791559290778675`*^9, 3.4821760103727875`*^9, {
   3.4821769533286915`*^9, 3.4821769582657905`*^9}, 3.48217705875028*^9, 
   3.4821893863844604`*^9, 3.4821894796585827`*^9, {3.482189612239224*^9, 
   3.4821896263495135`*^9}, 3.4826462979727983`*^9, 3.4898797779905844`*^9, {
   3.489881055133628*^9, 3.489881092916894*^9}, {3.48988120480029*^9, 
   3.489881225673127*^9}, {3.4898812711004066`*^9, 3.489881319819292*^9}, {
   3.4898814389567013`*^9, 3.4898814408599052`*^9}, {3.489881497207204*^9, 
   3.489881505740419*^9}, {3.489881821703374*^9, 3.4898818363361998`*^9}, {
   3.4898821546391587`*^9, 3.489882169552785*^9}, {3.4898829692125893`*^9, 
   3.489882972145395*^9}, {3.4898885289641614`*^9, 3.489888545264184*^9}, {
   3.4898891038925705`*^9, 3.489889105632573*^9}}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"1", "+", 
     SuperscriptBox["x", "8"]}]], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.446686303711478*^9, 3.423013182015625*^9}, 
   3.423171538015625*^9, 3.42317763434375*^9, {3.42318906584375*^9, 
   3.423189082625*^9}, 3.4898797779905844`*^9, {3.489881363452569*^9, 
   3.4898813653245726`*^9}, {3.489881645906665*^9, 3.489881648121869*^9}, {
   3.4898817220347986`*^9, 3.4898817227368*^9}, {3.489881792500123*^9, 
   3.48988180243734*^9}, 3.4898818641822486`*^9, {3.4898819029951167`*^9, 
   3.4898819032291174`*^9}, {3.489881950996401*^9, 3.4898819779220486`*^9}, {
   3.4898820115089073`*^9, 3.489882011992508*^9}, {3.489888487314103*^9, 
   3.489888490904108*^9}, 3.4898891838426824`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SqrtBox["2"]}], ")"}], " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{
       SqrtBox[
        RowBox[{"2", "-", 
         SqrtBox["2"]}]], " ", "x"}], 
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"]}]], "]"}]}], 
   RowBox[{"4", " ", 
    SqrtBox[
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"2", "-", 
        SqrtBox["2"]}], ")"}]}]]}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SqrtBox["2"]}], ")"}], " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{
       SqrtBox[
        RowBox[{"2", "+", 
         SqrtBox["2"]}]], " ", "x"}], 
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"]}]], "]"}]}], 
   RowBox[{"4", " ", 
    SqrtBox[
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", 
        SqrtBox["2"]}], ")"}]}]]}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SqrtBox["2"]}], ")"}], " ", 
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      RowBox[{
       SqrtBox[
        RowBox[{"2", "-", 
         SqrtBox["2"]}]], " ", "x"}], 
      RowBox[{"1", "+", 
       SuperscriptBox["x", "2"]}]], "]"}]}], 
   RowBox[{"4", " ", 
    SqrtBox[
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"2", "-", 
        SqrtBox["2"]}], ")"}]}]]}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SqrtBox["2"]}], ")"}], " ", 
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      RowBox[{
       SqrtBox[
        RowBox[{"2", "+", 
         SqrtBox["2"]}]], " ", "x"}], 
      RowBox[{"1", "+", 
       SuperscriptBox["x", "2"]}]], "]"}]}], 
   RowBox[{"4", " ", 
    SqrtBox[
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", 
        SqrtBox["2"]}], ")"}]}]]}]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.4898818647594495`*^9, 3.4898819036035175`*^9, {3.489881951916803*^9, 
   3.4898819784212494`*^9}, 3.489882012429309*^9, 3.4898830647003574`*^9, 
   3.489888494304113*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " result is an 8 term sum:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443225459641647`*^9, 3.4443225485078225`*^9}, {
   3.4466948911496077`*^9, 3.42301074665625*^9}, 3.42317159478125*^9, {
   3.423174840640625*^9, 3.423174854046875*^9}, {3.4233322945*^9, 
   3.4233323091875*^9}, {3.42333236403125*^9, 3.423332366546875*^9}, {
   3.423332643984375*^9, 3.42333264684375*^9}, 3.423341072609375*^9, 
   3.4561670576690483`*^9, 3.4791559290778675`*^9, 3.4821760103727875`*^9, {
   3.4821769533286915`*^9, 3.4821769582657905`*^9}, 3.48217705875028*^9, 
   3.4821893863844604`*^9, 3.4821894796585827`*^9, {3.482189612239224*^9, 
   3.4821896263495135`*^9}, {3.4821897134447503`*^9, 3.482189727484939*^9}, 
   3.4826463395626016`*^9, 3.489879783013793*^9, {3.4898828232587333`*^9, 
   3.4898828598251977`*^9}, {3.4898829533161616`*^9, 3.4898829619897766`*^9}, 
   3.4898830135166674`*^9, 3.489883073592373*^9, {3.4898885874042435`*^9, 
   3.4898885998142605`*^9}, 3.489889006946432*^9, {3.4898891094925785`*^9, 
   3.4898891146425858`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"1", "+", 
     SuperscriptBox["x", "8"]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.446686303711478*^9, 3.446686355045293*^9}, {
   3.446686541142888*^9, 3.42301314003125*^9}, 3.423171538015625*^9, 
   3.423189156828125*^9, 3.489879783013793*^9, 3.4898815241172514`*^9, 
   3.4898817631564713`*^9, 3.489882214356064*^9, 3.489883073592373*^9, 
   3.4898885105041356`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "4"], " ", 
   RowBox[{"ArcTan", "[", 
    RowBox[{
     RowBox[{"Sec", "[", 
      FractionBox["\[Pi]", "8"], "]"}], " ", 
     RowBox[{"(", 
      RowBox[{"x", "-", 
       RowBox[{"Sin", "[", 
        FractionBox["\[Pi]", "8"], "]"}]}], ")"}]}], "]"}], " ", 
   RowBox[{"Cos", "[", 
    FractionBox["\[Pi]", "8"], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   RowBox[{"ArcTan", "[", 
    RowBox[{
     RowBox[{"Sec", "[", 
      FractionBox["\[Pi]", "8"], "]"}], " ", 
     RowBox[{"(", 
      RowBox[{"x", "+", 
       RowBox[{"Sin", "[", 
        FractionBox["\[Pi]", "8"], "]"}]}], ")"}]}], "]"}], " ", 
   RowBox[{"Cos", "[", 
    FractionBox["\[Pi]", "8"], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "8"], " ", 
   RowBox[{"Cos", "[", 
    FractionBox["\[Pi]", "8"], "]"}], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", 
     SuperscriptBox["x", "2"], "-", 
     RowBox[{"2", " ", "x", " ", 
      RowBox[{"Cos", "[", 
       FractionBox["\[Pi]", "8"], "]"}]}]}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "8"], " ", 
   RowBox[{"Cos", "[", 
    FractionBox["\[Pi]", "8"], "]"}], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", 
     SuperscriptBox["x", "2"], "+", 
     RowBox[{"2", " ", "x", " ", 
      RowBox[{"Cos", "[", 
       FractionBox["\[Pi]", "8"], "]"}]}]}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   RowBox[{"ArcTan", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", 
       RowBox[{"Cos", "[", 
        FractionBox["\[Pi]", "8"], "]"}]}], ")"}], " ", 
     RowBox[{"Csc", "[", 
      FractionBox["\[Pi]", "8"], "]"}]}], "]"}], " ", 
   RowBox[{"Sin", "[", 
    FractionBox["\[Pi]", "8"], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   RowBox[{"ArcTan", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "+", 
       RowBox[{"Cos", "[", 
        FractionBox["\[Pi]", "8"], "]"}]}], ")"}], " ", 
     RowBox[{"Csc", "[", 
      FractionBox["\[Pi]", "8"], "]"}]}], "]"}], " ", 
   RowBox[{"Sin", "[", 
    FractionBox["\[Pi]", "8"], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "8"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", 
     SuperscriptBox["x", "2"], "-", 
     RowBox[{"2", " ", "x", " ", 
      RowBox[{"Sin", "[", 
       FractionBox["\[Pi]", "8"], "]"}]}]}], "]"}], " ", 
   RowBox[{"Sin", "[", 
    FractionBox["\[Pi]", "8"], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "8"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", 
     SuperscriptBox["x", "2"], "+", 
     RowBox[{"2", " ", "x", " ", 
      RowBox[{"Sin", "[", 
       FractionBox["\[Pi]", "8"], "]"}]}]}], "]"}], " ", 
   RowBox[{"Sin", "[", 
    FractionBox["\[Pi]", "8"], "]"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.489882232732896*^9, 3.489883073592373*^9, 
  3.489888512154138*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Maple",
  FontSlant->"Italic"],
 " result is ",
 StyleBox["not",
  FontSlant->"Italic"],
 " in closed-form:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443225459641647`*^9, 3.4443225485078225`*^9}, {
   3.4466948911496077`*^9, 3.42301074665625*^9}, 3.42317159478125*^9, {
   3.423174840640625*^9, 3.423174854046875*^9}, {3.4233322945*^9, 
   3.4233323091875*^9}, {3.42333236403125*^9, 3.423332366546875*^9}, {
   3.423332643984375*^9, 3.42333264684375*^9}, 3.423341072609375*^9, 
   3.4561670576690483`*^9, 3.4791559290778675`*^9, 3.4821760103727875`*^9, {
   3.4821769533286915`*^9, 3.4821769582657905`*^9}, 3.48217705875028*^9, 
   3.4821893863844604`*^9, 3.4821894796585827`*^9, {3.482189612239224*^9, 
   3.4821896263495135`*^9}, {3.4821897134447503`*^9, 3.482189727484939*^9}, 
   3.4826463395626016`*^9, 3.489879783013793*^9, {3.4898828232587333`*^9, 
   3.4898828598251977`*^9}, {3.4898829533161616`*^9, 
   3.4898829619897766`*^9}, {3.489883000833845*^9, 3.489883003173849*^9}, 
   3.489883079301983*^9, {3.4898890527264967`*^9, 3.489889076590932*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"x", "^", "8"}]}], ")"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.446686597634118*^9, 3.423013158640625*^9}, 
   3.423171538015625*^9, 3.423177651234375*^9, {3.423189203640625*^9, 
   3.423189215375*^9}, {3.489881813372959*^9, 3.48988181371616*^9}, 
   3.489882312386636*^9, 3.489883079301983*^9, {3.4898886518843336`*^9, 
   3.489888654914338*^9}, 3.4898891882926884`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"sum", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"_R", "*", "ln", 
     RowBox[{"(", 
      RowBox[{"x", "+", 
       RowBox[{"8", "*", "_R"}]}], ")"}]}], ",", 
    RowBox[{"_R", "=", 
     RowBox[{"RootOf", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"16777216", "*", 
         RowBox[{"_Z", "^", "8"}]}], "+", "1"}], ")"}]}]}]}], 
   ")"}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{3.4898891522926383`*^9}]
}, Closed]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Rational Function Integration Problem 11", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899348631344`*^9, {
   3.4898793179301767`*^9, 3.4898793181173763`*^9}},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"1", "+", 
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["x", "4"]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881630453854`*^9, 
   3.482189185455539*^9, 3.4903833296036196`*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " result is free of the imaginary unit:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443225459641647`*^9, 3.4443225485078225`*^9}, {
   3.4466948911496077`*^9, 3.42301074665625*^9}, 3.42317159478125*^9, {
   3.423174840640625*^9, 3.423174854046875*^9}, {3.4233322945*^9, 
   3.4233323091875*^9}, {3.42333236403125*^9, 3.423332366546875*^9}, {
   3.423332643984375*^9, 3.42333264684375*^9}, 3.423341072609375*^9, 
   3.4561670576690483`*^9, 3.4791559290778675`*^9, 3.4821760103727875`*^9, {
   3.4821769533286915`*^9, 3.4821769582657905`*^9}, 3.48217705875028*^9, 
   3.4821893863844604`*^9, 3.4821894796585827`*^9, {3.482189612239224*^9, 
   3.4821896263495135`*^9}, 3.4821897976458254`*^9, 3.482646304141669*^9, 
   3.48987979837982*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"1", "+", 
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["x", "4"]}]], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.446696016868312*^9, 3.4466960342733393`*^9}, 
   3.4466965162063246`*^9, {3.446697275728464*^9, 3.423171546859375*^9}, {
   3.4231909709375*^9, 3.4231909823125*^9}, 3.48987979837982*^9, 
   3.489889247022771*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{"ArcTan", "[", 
       FractionBox[
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", "x"}]}], 
        SqrtBox["3"]], "]"}], 
      SqrtBox["3"]], "-", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"Log", "[", 
       RowBox[{"1", "-", "x", "+", 
        SuperscriptBox["x", "2"]}], "]"}]}]}], ")"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{"ArcTan", "[", 
       FractionBox[
        RowBox[{"1", "+", 
         RowBox[{"2", " ", "x"}]}], 
        SqrtBox["3"]], "]"}], 
      SqrtBox["3"]], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"Log", "[", 
       RowBox[{"1", "+", "x", "+", 
        SuperscriptBox["x", "2"]}], "]"}]}]}], ")"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.4466965228558865`*^9, 3.4466972798443823`*^9, {3.44669747441416*^9, 
   3.423171546859375*^9}, 3.42319100490625*^9, 3.48987979837982*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " result",
 StyleBox[" ",
  FontSlant->"Italic"],
 "is not free of the imaginary unit:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.4466846121791744`*^9, 3.423171546859375*^9}, {3.4231911113125*^9, 
   3.423191120578125*^9}, {3.482189812877728*^9, 3.482189815161011*^9}, 
   3.482646344379528*^9, 3.4898798026074276`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"1", "+", 
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["x", "4"]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.446696016868312*^9, 3.44669606454687*^9}, 
   3.4466965195210915`*^9, {3.4466967519653296`*^9, 3.446696777812496*^9}, {
   3.4466972498512545`*^9, 3.4466972566710606`*^9}, {3.446697465120797*^9, 
   3.423171546859375*^9}, 3.42319102034375*^9, 3.4898798026074276`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "6"], " ", "\[ImaginaryI]", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     SqrtBox[
      RowBox[{"6", "-", 
       RowBox[{"6", " ", "\[ImaginaryI]", " ", 
        SqrtBox["3"]}]}]], " ", 
     RowBox[{"ArcTan", "[", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "\[ImaginaryI]"}], "+", 
         SqrtBox["3"]}], ")"}], " ", "x"}], "]"}]}], "-", 
    RowBox[{
     SqrtBox[
      RowBox[{"6", "+", 
       RowBox[{"6", " ", "\[ImaginaryI]", " ", 
        SqrtBox["3"]}]}]], " ", 
     RowBox[{"ArcTan", "[", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"\[ImaginaryI]", "+", 
         SqrtBox["3"]}], ")"}], " ", "x"}], "]"}]}]}], ")"}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{
  3.446697257582371*^9, {3.4466974702181263`*^9, 3.423171546859375*^9}, 
   3.42319102378125*^9, 3.4898798026074276`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Maple",
  FontSlant->"Italic"],
 " result is free of the imaginary unit:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797708010798`*^9}, {
   3.4442801182306595`*^9, 3.444280119762862*^9}, {3.444280702741144*^9, 
   3.444280708429323*^9}, {3.4466846154839263`*^9, 3.4466846164052515`*^9}, 
   3.4466847804711666`*^9, {3.4466966906972303`*^9, 3.423010828765625*^9}, 
   3.423171546859375*^9, 3.42319113028125*^9, {3.4821898178448706`*^9, 
   3.482189820238312*^9}, 3.482646387271203*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"x", "^", "4"}]}], ")"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.446696016868312*^9, 3.44669606454687*^9}, {
   3.4466962995748243`*^9, 3.4466963105706353`*^9}, {3.446696540100683*^9, 
   3.446696548322506*^9}, {3.446697302547027*^9, 3.423171546859375*^9}, {
   3.4231910385625*^9, 3.423191045296875*^9}, 3.4898892507327757`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{"ArcTan", "[", 
       FractionBox[
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", "x"}]}], 
        SqrtBox["3"]], "]"}], 
      SqrtBox["3"]], "-", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"Log", "[", 
       RowBox[{"1", "-", "x", "+", 
        SuperscriptBox["x", "2"]}], "]"}]}]}], ")"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{"ArcTan", "[", 
       FractionBox[
        RowBox[{"1", "+", 
         RowBox[{"2", " ", "x"}]}], 
        SqrtBox["3"]], "]"}], 
      SqrtBox["3"]], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"Log", "[", 
       RowBox[{"1", "+", "x", "+", 
        SuperscriptBox["x", "2"]}], "]"}]}]}], ")"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{
  3.4466965228558865`*^9, 3.4466972798443823`*^9, {3.44669747441416*^9, 
   3.423171546859375*^9}, 3.42319100490625*^9}]
}, Closed]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Rational Function Integration Problem 12", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899348631344`*^9, {
   3.4898793179301767`*^9, 3.4898793181173763`*^9}, {3.489891436941039*^9, 
   3.4898914372410393`*^9}},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"1", "+", 
     SuperscriptBox["x", "2"]}], 
    RowBox[{"1", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     SuperscriptBox["x", "4"]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881630453854`*^9, 
   3.482189185455539*^9, {3.489889282962821*^9, 3.4898892964728403`*^9}, 
   3.4903833322336235`*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " results are simple single terms:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443225459641647`*^9, 3.4443225485078225`*^9}, {
   3.4466948911496077`*^9, 3.42301074665625*^9}, 3.42317159478125*^9, {
   3.423174840640625*^9, 3.423174854046875*^9}, {3.4233322945*^9, 
   3.4233323091875*^9}, {3.42333236403125*^9, 3.423332366546875*^9}, {
   3.423332643984375*^9, 3.42333264684375*^9}, 3.423341072609375*^9, 
   3.4561670576690483`*^9, 3.4791559290778675`*^9, 3.4821760103727875`*^9, {
   3.4821769533286915`*^9, 3.4821769582657905`*^9}, 3.48217705875028*^9, 
   3.4821893863844604`*^9, 3.4821894796585827`*^9, {3.482189612239224*^9, 
   3.4821896263495135`*^9}, 3.4821897976458254`*^9, 3.482646304141669*^9, 
   3.48987979837982*^9, {3.489889793415536*^9, 3.4898898005355463`*^9}, {
   3.4898901332564135`*^9, 3.4898901500664377`*^9}}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"1", "+", 
     SuperscriptBox["x", "2"]}], 
    RowBox[{"1", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     SuperscriptBox["x", "4"]}]], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.446696016868312*^9, 3.4466960342733393`*^9}, 
   3.4466965162063246`*^9, {3.446697275728464*^9, 3.423171546859375*^9}, {
   3.4231909709375*^9, 3.4231909823125*^9}, 3.48987979837982*^9, 
   3.489889247022771*^9, {3.4898893054428525`*^9, 3.489889321642875*^9}, {
   3.4898899396429415`*^9, 3.489890022912658*^9}, {3.4898901091163797`*^9, 
   3.4898901095063806`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{"ArcTan", "[", 
   FractionBox[
    RowBox[{
     SqrtBox[
      RowBox[{"2", "+", "b"}]], " ", "x"}], 
    RowBox[{"1", "-", 
     SuperscriptBox["x", "2"]}]], "]"}], 
  SqrtBox[
   RowBox[{"2", "+", "b"}]]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{3.4898901101563816`*^9, 3.4898905978298645`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"1", "+", 
     SuperscriptBox["x", "2"]}], 
    RowBox[{"1", "+", 
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["x", "4"]}]], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.446696016868312*^9, 3.4466960342733393`*^9}, 
   3.4466965162063246`*^9, {3.446697275728464*^9, 3.423171546859375*^9}, {
   3.4231909709375*^9, 3.4231909823125*^9}, 3.48987979837982*^9, 
   3.489889247022771*^9, {3.4898893054428525`*^9, 3.489889321642875*^9}, {
   3.4898899396429415`*^9, 3.489890022912658*^9}, 3.4898901064363766`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{"ArcTan", "[", 
   FractionBox[
    RowBox[{
     SqrtBox["3"], " ", "x"}], 
    RowBox[{"1", "-", 
     SuperscriptBox["x", "2"]}]], "]"}], 
  SqrtBox["3"]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.4466965228558865`*^9, 3.4466972798443823`*^9, {3.44669747441416*^9, 
   3.423171546859375*^9}, 3.42319100490625*^9, 3.48987979837982*^9, 
   3.4898893083528566`*^9, {3.4898899417229443`*^9, 3.489890032082671*^9}, 
   3.48989055932981*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " results are more complicated 2 term sums and can include the imaginary \
unit:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.4466846121791744`*^9, 3.423171546859375*^9}, {3.4231911113125*^9, 
   3.423191120578125*^9}, {3.482189812877728*^9, 3.482189815161011*^9}, 
   3.482646344379528*^9, 3.4898798026074276`*^9, {3.4898898101855593`*^9, 
   3.489889821535576*^9}, 3.4898898572856255`*^9, {3.4898901595064507`*^9, 
   3.489890167026461*^9}, {3.489890536779779*^9, 3.48989054460979*^9}, 
   3.4898906065498767`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"1", "+", 
     SuperscriptBox["x", "2"]}], 
    RowBox[{"1", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     SuperscriptBox["x", "4"]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.446696016868312*^9, 3.44669606454687*^9}, 
   3.4466965195210915`*^9, {3.4466967519653296`*^9, 3.446696777812496*^9}, {
   3.4466972498512545`*^9, 3.4466972566710606`*^9}, {3.446697465120797*^9, 
   3.423171546859375*^9}, 3.42319102034375*^9, 3.4898798026074276`*^9, {
   3.489889354742922*^9, 3.489889367292939*^9}, 3.4898898572856255`*^9, {
   3.4898899128629036`*^9, 3.489889922322917*^9}, {3.4898901244064016`*^9, 
   3.489890124906402*^9}, 3.4898906065498767`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", "-", "b", "+", 
       SqrtBox[
        RowBox[{
         RowBox[{"-", "4"}], "+", 
         SuperscriptBox["b", "2"]}]]}], ")"}], " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{
        SqrtBox["2"], " ", "x"}], 
       SqrtBox[
        RowBox[{"b", "-", 
         SqrtBox[
          RowBox[{
           RowBox[{"-", "4"}], "+", 
           SuperscriptBox["b", "2"]}]]}]]], "]"}]}], 
    SqrtBox[
     RowBox[{"b", "-", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "4"}], "+", 
        SuperscriptBox["b", "2"]}]]}]]], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", "b", "+", 
       SqrtBox[
        RowBox[{
         RowBox[{"-", "4"}], "+", 
         SuperscriptBox["b", "2"]}]]}], ")"}], " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{
        SqrtBox["2"], " ", "x"}], 
       SqrtBox[
        RowBox[{"b", "+", 
         SqrtBox[
          RowBox[{
           RowBox[{"-", "4"}], "+", 
           SuperscriptBox["b", "2"]}]]}]]], "]"}]}], 
    SqrtBox[
     RowBox[{"b", "+", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "4"}], "+", 
        SuperscriptBox["b", "2"]}]]}]]]}], 
  RowBox[{
   SqrtBox["2"], " ", 
   SqrtBox[
    RowBox[{
     RowBox[{"-", "4"}], "+", 
     SuperscriptBox["b", "2"]}]]}]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.489889913562905*^9, 3.4898899233229184`*^9}, 
   3.4898900416626844`*^9, 3.489890125506403*^9, 3.4898906065498767`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"1", "+", 
     SuperscriptBox["x", "2"]}], 
    RowBox[{"1", "+", 
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["x", "4"]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.446696016868312*^9, 3.44669606454687*^9}, 
   3.4466965195210915`*^9, {3.4466967519653296`*^9, 3.446696777812496*^9}, {
   3.4466972498512545`*^9, 3.4466972566710606`*^9}, {3.446697465120797*^9, 
   3.423171546859375*^9}, 3.42319102034375*^9, 3.4898798026074276`*^9, {
   3.489889354742922*^9, 3.489889367292939*^9}, 3.4898898572856255`*^9, {
   3.4898899128629036`*^9, 3.489889922322917*^9}, 3.489890119116394*^9, 
   3.4898906065498767`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"\[ImaginaryI]", "+", 
      SqrtBox["3"]}], ")"}], " ", 
    RowBox[{"ArcTan", "[", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], "+", 
        SqrtBox["3"]}], ")"}], " ", "x"}], "]"}]}], 
   SqrtBox[
    RowBox[{"6", "+", 
     RowBox[{"6", " ", "\[ImaginaryI]", " ", 
      SqrtBox["3"]}]}]]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], "+", 
      SqrtBox["3"]}], ")"}], " ", 
    RowBox[{"ArcTan", "[", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"\[ImaginaryI]", "+", 
        SqrtBox["3"]}], ")"}], " ", "x"}], "]"}]}], 
   SqrtBox[
    RowBox[{"6", "-", 
     RowBox[{"6", " ", "\[ImaginaryI]", " ", 
      SqrtBox["3"]}]}]]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{3.489890121326397*^9, 3.4898906065498767`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Maple",
  FontSlant->"Italic"],
 " results are more complicated 2 term sums:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.4466846121791744`*^9, 3.423171546859375*^9}, {3.4231911113125*^9, 
   3.423191120578125*^9}, {3.482189812877728*^9, 3.482189815161011*^9}, 
   3.482646344379528*^9, 3.4898798026074276`*^9, {3.4898898101855593`*^9, 
   3.489889821535576*^9}, 3.4898898572856255`*^9, {3.4898901595064507`*^9, 
   3.4898901919164963`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"x", "^", "2"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"b", "*", 
         RowBox[{"x", "^", "2"}]}], "+", 
        RowBox[{"x", "^", "4"}]}], ")"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.446696016868312*^9, 3.44669606454687*^9}, {
   3.4466962995748243`*^9, 3.4466963105706353`*^9}, {3.446696540100683*^9, 
   3.446696548322506*^9}, {3.446697302547027*^9, 3.423171546859375*^9}, {
   3.4231910385625*^9, 3.423191045296875*^9}, 3.4898892507327757`*^9, {
   3.4898893802629576`*^9, 3.4898893887829695`*^9}, 3.4898906155398893`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"2", "-", "b", "+", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "4"}], "+", 
        SuperscriptBox["b", "2"]}]]}], ")"}], " ", 
    SqrtBox[
     RowBox[{"b", "+", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "4"}], "+", 
        SuperscriptBox["b", "2"]}]]}]], " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"2", " ", "x"}], 
      SqrtBox[
       RowBox[{
        RowBox[{"2", " ", "b"}], "-", 
        RowBox[{"2", " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"-", "4"}], "+", 
           SuperscriptBox["b", "2"]}]]}]}]]], "]"}]}], "+", 
   RowBox[{
    SqrtBox[
     RowBox[{"b", "-", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "4"}], "+", 
        SuperscriptBox["b", "2"]}]]}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "+", "b", "+", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "4"}], "+", 
        SuperscriptBox["b", "2"]}]]}], ")"}], " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{
       SqrtBox["2"], " ", "x"}], 
      SqrtBox[
       RowBox[{"b", "+", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", "4"}], "+", 
          SuperscriptBox["b", "2"]}]]}]]], "]"}]}]}], 
  RowBox[{
   SqrtBox["2"], " ", 
   SqrtBox[
    RowBox[{
     RowBox[{"-", "4"}], "+", 
     SuperscriptBox["b", "2"]}]], " ", 
   SqrtBox[
    RowBox[{"b", "-", 
     SqrtBox[
      RowBox[{
       RowBox[{"-", "4"}], "+", 
       SuperscriptBox["b", "2"]}]]}]], " ", 
   SqrtBox[
    RowBox[{"b", "+", 
     SqrtBox[
      RowBox[{
       RowBox[{"-", "4"}], "+", 
       SuperscriptBox["b", "2"]}]]}]]}]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.489889685105385*^9, 3.4898897033854103`*^9}, 
   3.4898898630556335`*^9, 3.4898906155398893`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"x", "^", "2"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"x", "^", "4"}]}], ")"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.446696016868312*^9, 3.44669606454687*^9}, {
   3.4466962995748243`*^9, 3.4466963105706353`*^9}, {3.446696540100683*^9, 
   3.446696548322506*^9}, {3.446697302547027*^9, 3.423171546859375*^9}, {
   3.4231910385625*^9, 3.423191045296875*^9}, 3.4898892507327757`*^9, {
   3.4898893802629576`*^9, 3.4898893887829695`*^9}, {3.489890241466565*^9, 
   3.489890246316572*^9}, 3.4898906155398893`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "x"}]}], 
     SqrtBox["3"]], "]"}], 
   SqrtBox["3"]], "+", 
  FractionBox[
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "x"}]}], 
     SqrtBox["3"]], "]"}], 
   SqrtBox["3"]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.489890508269739*^9, 3.4898906155398893`*^9}]
}, Closed]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Rational Function Integration Problem 13", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.4898793213465824`*^9, 3.489879321674183*^9}, {3.489891439561043*^9, 
   3.4898914399310436`*^9}},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"x", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["x", "5"], "+", 
       SuperscriptBox["x", "10"]}], ")"}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881630453854`*^9, 
   3.482189194338312*^9, {3.489890836110198*^9, 3.4898908519202204`*^9}, 
   3.490383334183626*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " result is in elementary form and simple:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4466966975370655`*^9, 
   3.42301074603125*^9}, 3.423171546859375*^9, 3.482189771217824*^9, 
   3.482646305764002*^9, 3.4898798144790487`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"x", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["x", "5"], "+", 
       SuperscriptBox["x", "10"]}], ")"}]}]], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.446696016868312*^9, 3.4466960342733393`*^9}, 
   3.4466965162063246`*^9, {3.446697275728464*^9, 3.423171546859375*^9}, {
   3.455755028114745*^9, 3.455755038470565*^9}, 3.4898798144790487`*^9, 
   3.489890864540238*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"1", "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["x", "5"]}]}], 
      SqrtBox["3"]], "]"}], 
    RowBox[{"5", " ", 
     SqrtBox["3"]}]]}], "+", 
  RowBox[{"Log", "[", "x", "]"}], "-", 
  RowBox[{
   FractionBox["1", "10"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", 
     SuperscriptBox["x", "5"], "+", 
     SuperscriptBox["x", "10"]}], "]"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.4466965228558865`*^9, 3.4466972798443823`*^9, {3.44669747441416*^9, 
   3.423171546859375*^9}, 3.4557550308088603`*^9, 3.4898798144790487`*^9, 
   3.489890865430239*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " result",
 StyleBox[" ",
  FontSlant->"Italic"],
 "is not in closed-form:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.4466846121791744`*^9, 3.423171546859375*^9}, 3.482189862879627*^9, 
   3.4826463449603634`*^9, 3.489879817879854*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"x", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["x", "5"], "+", 
       SuperscriptBox["x", "10"]}], ")"}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.446696016868312*^9, 3.44669606454687*^9}, 
   3.4466965195210915`*^9, {3.4466967519653296`*^9, 3.446696777812496*^9}, {
   3.4466972498512545`*^9, 3.4466972566710606`*^9}, {3.446697465120797*^9, 
   3.423171546859375*^9}, 3.489879817879854*^9, 3.4898908757702537`*^9, 
   3.489891171980668*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "x"}]}], 
     SqrtBox["3"]], "]"}], 
   RowBox[{"5", " ", 
    SqrtBox["3"]}]], "+", 
  RowBox[{"Log", "[", "x", "]"}], "-", 
  RowBox[{
   FractionBox["1", "10"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", "x", "+", 
     SuperscriptBox["x", "2"]}], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "5"], " ", 
   RowBox[{"RootSum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", "#1", "+", 
       SuperscriptBox["#1", "3"], "-", 
       SuperscriptBox["#1", "4"], "+", 
       SuperscriptBox["#1", "5"], "-", 
       SuperscriptBox["#1", "7"], "+", 
       SuperscriptBox["#1", "8"]}], "&"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          RowBox[{"Log", "[", 
           RowBox[{"x", "-", "#1"}], "]"}]}], " ", "#1"}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"Log", "[", 
          RowBox[{"x", "-", "#1"}], "]"}], " ", 
         SuperscriptBox["#1", "2"]}], "-", 
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"x", "-", "#1"}], "]"}], " ", 
         SuperscriptBox["#1", "3"]}], "+", 
        RowBox[{"3", " ", 
         RowBox[{"Log", "[", 
          RowBox[{"x", "-", "#1"}], "]"}], " ", 
         SuperscriptBox["#1", "4"]}], "-", 
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"x", "-", "#1"}], "]"}], " ", 
         SuperscriptBox["#1", "5"]}], "-", 
        RowBox[{"3", " ", 
         RowBox[{"Log", "[", 
          RowBox[{"x", "-", "#1"}], "]"}], " ", 
         SuperscriptBox["#1", "6"]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{"Log", "[", 
          RowBox[{"x", "-", "#1"}], "]"}], " ", 
         SuperscriptBox["#1", "7"]}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["#1", "2"]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["#1", "3"]}], "+", 
        RowBox[{"5", " ", 
         SuperscriptBox["#1", "4"]}], "-", 
        RowBox[{"7", " ", 
         SuperscriptBox["#1", "6"]}], "+", 
        RowBox[{"8", " ", 
         SuperscriptBox["#1", "7"]}]}]], "&"}]}], "]"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{
  3.446697257582371*^9, {3.4466974702181263`*^9, 3.423171546859375*^9}, 
   3.489879817879854*^9, 3.489890878480257*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Maple",
  FontSlant->"Italic"],
 " result is in elementary form but not as simple:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797708010798`*^9}, {
   3.4442801182306595`*^9, 3.444280119762862*^9}, {3.444280702741144*^9, 
   3.444280708429323*^9}, {3.4466846154839263`*^9, 3.4466846164052515`*^9}, 
   3.4466847804711666`*^9, {3.4466966906972303`*^9, 3.423010828765625*^9}, 
   3.423171546859375*^9, {3.48218986700556*^9, 3.4821898674962654`*^9}, 
   3.4826463877218513`*^9, 3.4898914614410734`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"x", "*", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"x", "^", "5"}], "+", 
          RowBox[{"x", "^", "10"}]}], ")"}]}], ")"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.446696016868312*^9, 3.44669606454687*^9}, {
   3.4466962995748243`*^9, 3.4466963105706353`*^9}, {3.446696540100683*^9, 
   3.446696548322506*^9}, {3.446697302547027*^9, 3.423171546859375*^9}, {
   3.48989092285032*^9, 3.4898909316903315`*^9}, 3.4898914614410734`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"1", "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["x", "5"]}]}], 
      SqrtBox["3"]], "]"}], 
    RowBox[{"5", " ", 
     SqrtBox["3"]}]]}], "+", 
  RowBox[{"Log", "[", "x", "]"}], "-", 
  RowBox[{
   FractionBox["1", "10"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", "x", "+", 
     SuperscriptBox["x", "2"]}], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "10"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", "x", "+", 
     SuperscriptBox["x", "3"], "-", 
     SuperscriptBox["x", "4"], "+", 
     SuperscriptBox["x", "5"], "-", 
     SuperscriptBox["x", "7"], "+", 
     SuperscriptBox["x", "8"]}], "]"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4898911410706253`*^9, 3.4898911497606373`*^9}, 
   3.4898914614410734`*^9}]
}, Closed]]
}, Open  ]]
},
AutoGeneratedPackage->None,
CellGrouping->Manual,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  None, None, None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->{{28.8, 28.8}, {14.4, 14.4}}},
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 489, 8, 69, "Title"],
Cell[1059, 32, 853, 22, 68, "Subtitle"],
Cell[CellGroupData[{
Cell[1937, 58, 1401, 22, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[3341, 82, 924, 21, 49, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[4268, 105, 481, 14, 52, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[4752, 121, 1029, 22, 49, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[5784, 145, 279, 8, 51, InheritFromParent],
Cell[6066, 155, 876, 19, 54, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[6945, 176, 267, 8, 53, InheritFromParent]
}, Closed]],
Cell[CellGroupData[{
Cell[7249, 189, 1603, 25, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[8855, 216, 993, 21, 59, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[9851, 239, 501, 15, 51, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[10355, 256, 947, 21, 59, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[11305, 279, 3025, 88, 48, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[14333, 369, 893, 19, 59, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[15229, 390, 2791, 87, 50, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Closed]],
Cell[CellGroupData[{
Cell[18057, 482, 1647, 26, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[19707, 510, 1079, 25, 105, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[20789, 537, 507, 16, 112, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[21299, 555, 1180, 26, 105, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[22482, 583, 2909, 87, 108, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[25394, 672, 1021, 23, 105, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[26418, 697, 2817, 88, 112, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}]
}, Closed]],
Cell[29250, 788, 141, 3, 4, "PageBreak",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[29428, 796, 521, 9, 69, "Title"],
Cell[29952, 807, 964, 26, 68, "Subtitle"],
Cell[CellGroupData[{
Cell[30941, 837, 1431, 22, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[32375, 861, 1265, 27, 109, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[33643, 890, 880, 27, 121, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[34526, 919, 1268, 27, 121, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[35797, 948, 508, 15, 121, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[36308, 965, 998, 22, 121, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[37309, 989, 394, 10, 118, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Closed]],
Cell[CellGroupData[{
Cell[37740, 1004, 1635, 25, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[39378, 1031, 1083, 24, 132, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[40464, 1057, 1050, 30, 121, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[41517, 1089, 1117, 25, 132, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[42637, 1116, 3403, 101, 109, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[46043, 1219, 926, 20, 132, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[46972, 1241, 2094, 66, 112, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Closed]],
Cell[CellGroupData[{
Cell[49103, 1312, 1788, 32, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[50894, 1346, 1286, 30, 105, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[52183, 1378, 509, 16, 96, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[52695, 1396, 1340, 31, 105, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[54038, 1429, 3169, 96, 109, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[57210, 1527, 1050, 24, 105, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[58263, 1553, 2116, 66, 112, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Closed]],
Cell[60394, 1622, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[60475, 1628, 447, 8, 69, "Title"],
Cell[60925, 1638, 867, 23, 68, "Subtitle"],
Cell[CellGroupData[{
Cell[61817, 1665, 1420, 22, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[63240, 1689, 1091, 24, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[64334, 1715, 379, 11, 70, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[64716, 1728, 1196, 25, 73, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[65915, 1755, 456, 12, 62, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Closed]],
Cell[CellGroupData[{
Cell[66408, 1772, 1468, 23, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[67879, 1797, 1046, 22, 87, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[68928, 1821, 424, 13, 67, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[69355, 1836, 1075, 23, 87, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[70433, 1861, 2787, 92, 91, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Closed]],
Cell[CellGroupData[{
Cell[73257, 1958, 1490, 24, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[74750, 1984, 1222, 27, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[75975, 2013, 353, 11, 70, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[76331, 2026, 1379, 29, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[77713, 2057, 14955, 445, 346, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Closed]],
Cell[92683, 2505, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[92764, 2511, 413, 7, 69, "Title"],
Cell[93180, 2520, 964, 27, 68, "Subtitle"],
Cell[CellGroupData[{
Cell[94169, 2551, 1401, 22, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[95573, 2575, 1185, 28, 106, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[96761, 2605, 524, 16, 106, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[97288, 2623, 1313, 30, 106, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[98604, 2655, 475, 13, 103, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[99082, 2670, 1289, 29, 108, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[100374, 2701, 464, 13, 105, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Closed]],
Cell[CellGroupData[{
Cell[100875, 2719, 1627, 25, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[102505, 2746, 1156, 27, 132, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[103664, 2775, 584, 16, 103, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[104251, 2793, 1253, 28, 132, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[105507, 2823, 2410, 74, 103, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[107920, 2899, 1300, 28, 132, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[109223, 2929, 15693, 469, 654, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Closed]],
Cell[CellGroupData[{
Cell[124953, 3403, 1649, 26, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[126605, 3431, 1311, 32, 99, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[127919, 3465, 691, 22, 103, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[128613, 3489, 1357, 32, 99, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[129973, 3523, 2586, 89, 103, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[132562, 3614, 1350, 31, 99, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[133915, 3647, 25273, 751, 921, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}]
}, Closed]],
Cell[159203, 4401, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[159284, 4407, 313, 6, 69, "Title"],
Cell[159600, 4415, 692, 19, 81, "Subtitle"],
Cell[CellGroupData[{
Cell[160317, 4438, 1268, 20, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[161588, 4460, 540, 15, 101, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[162131, 4477, 509, 17, 70, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[162643, 4496, 490, 14, 102, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[163136, 4512, 403, 10, 71, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Closed]],
Cell[CellGroupData[{
Cell[163576, 4527, 1687, 26, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[165266, 4555, 579, 15, 101, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[165848, 4572, 509, 17, 70, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[166360, 4591, 533, 14, 102, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[166896, 4607, 3001, 83, 99, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Closed]],
Cell[CellGroupData[{
Cell[169934, 4695, 1657, 26, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[171594, 4723, 670, 19, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[172267, 4744, 531, 17, 70, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[172801, 4763, 561, 16, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[173365, 4781, 4693, 170, 129, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Closed]],
Cell[178073, 4954, 141, 3, 4, "PageBreak",
 CellGroupingRules->{GroupTogetherGrouping, 10004.},
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[178251, 4962, 313, 6, 69, "Title"],
Cell[178567, 4970, 720, 20, 81, "Subtitle"],
Cell[CellGroupData[{
Cell[179312, 4994, 1268, 20, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[180583, 5016, 592, 16, 101, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[181178, 5034, 941, 33, 71, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[182122, 5069, 515, 14, 102, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[182640, 5085, 674, 20, 71, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Closed]],
Cell[CellGroupData[{
Cell[183351, 5110, 1687, 26, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[185041, 5138, 609, 16, 101, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[185653, 5156, 777, 27, 71, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[186433, 5185, 579, 15, 102, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[187015, 5202, 2884, 80, 99, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Closed]],
Cell[CellGroupData[{
Cell[189936, 5287, 1657, 26, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[191596, 5315, 669, 19, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[192268, 5336, 774, 27, 71, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[193045, 5365, 555, 16, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[193603, 5383, 4538, 162, 129, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Closed]],
Cell[198156, 5548, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[198237, 5554, 367, 7, 69, "Title"],
Cell[198607, 5563, 686, 18, 74, "Subtitle"],
Cell[CellGroupData[{
Cell[199318, 5585, 1273, 21, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[200594, 5608, 1059, 24, 133, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[201656, 5634, 612, 23, 135, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[202271, 5659, 998, 22, 132, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[203272, 5683, 550, 15, 96, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Closed]],
Cell[CellGroupData[{
Cell[203859, 5703, 1247, 20, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[205109, 5725, 1095, 26, 133, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[206207, 5753, 587, 22, 135, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[206797, 5777, 955, 23, 133, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[207755, 5802, 682, 21, 96, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Closed]],
Cell[CellGroupData[{
Cell[208474, 5828, 1440, 23, 28, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[209917, 5853, 1280, 32, 99, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[211200, 5887, 577, 20, 132, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[211780, 5909, 1159, 28, 99, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[212942, 5939, 587, 19, 96, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Closed]],
Cell[213544, 5961, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[213625, 5967, 385, 7, 68, "Title"],
Cell[214013, 5976, 724, 19, 72, "Subtitle"],
Cell[CellGroupData[{
Cell[214762, 5999, 1238, 21, 28, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[216003, 6022, 801, 16, 133, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[216807, 6040, 429, 12, 129, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[217239, 6054, 798, 16, 133, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[218040, 6072, 453, 13, 129, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Closed]],
Cell[CellGroupData[{
Cell[218530, 6090, 1318, 25, 28, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[219851, 6117, 691, 15, 133, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[220545, 6134, 383, 12, 129, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[220931, 6148, 691, 15, 133, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[221625, 6165, 515, 17, 120, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Closed]],
Cell[CellGroupData[{
Cell[222177, 6187, 1314, 22, 28, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[223494, 6211, 875, 20, 99, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[224372, 6233, 355, 11, 129, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[224730, 6246, 875, 20, 99, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[225608, 6268, 378, 12, 129, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Closed]],
Cell[226001, 6283, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[226082, 6289, 408, 7, 68, "Title"],
Cell[226493, 6298, 734, 19, 72, "Subtitle"],
Cell[CellGroupData[{
Cell[227252, 6321, 1737, 28, 28, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[228992, 6351, 799, 15, 142, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[229794, 6368, 707, 22, 129, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[230504, 6392, 851, 16, 136, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[231358, 6410, 688, 23, 132, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[232049, 6435, 877, 17, 148, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[232929, 6454, 713, 24, 132, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[233645, 6480, 879, 17, 148, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[234527, 6499, 633, 21, 129, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Closed]],
Cell[CellGroupData[{
Cell[235197, 6525, 1544, 25, 28, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[236744, 6552, 544, 12, 142, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[237291, 6566, 1055, 34, 106, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[238349, 6602, 574, 13, 136, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[238926, 6617, 1055, 34, 106, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[239984, 6653, 602, 14, 148, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[240589, 6669, 1076, 35, 106, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[241668, 6706, 600, 14, 148, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[242271, 6722, 1078, 35, 106, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Closed]],
Cell[CellGroupData[{
Cell[243386, 6762, 1564, 26, 28, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[244953, 6790, 568, 15, 100, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[245524, 6807, 1098, 39, 124, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[246625, 6848, 594, 15, 100, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[247222, 6865, 1098, 39, 124, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[248323, 6906, 619, 16, 100, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[248945, 6924, 1127, 40, 124, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[250075, 6966, 621, 16, 100, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[250699, 6984, 1125, 40, 124, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}]
}, Closed]],
Cell[251839, 7027, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[251920, 7033, 387, 7, 68, "Title"],
Cell[252310, 7042, 758, 18, 71, "Subtitle"],
Cell[CellGroupData[{
Cell[253093, 7064, 1818, 29, 28, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[254914, 7095, 868, 16, 95, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[255785, 7113, 2188, 84, 125, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Closed]],
Cell[CellGroupData[{
Cell[258010, 7202, 1657, 27, 28, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[259670, 7231, 572, 13, 95, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[260245, 7246, 2888, 92, 108, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Closed]],
Cell[CellGroupData[{
Cell[263170, 7343, 1643, 29, 28, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[264816, 7374, 639, 16, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[265458, 7392, 483, 16, 42, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}]
}, Closed]],
Cell[265956, 7411, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[266037, 7417, 394, 7, 68, "Title"],
Cell[266434, 7426, 696, 18, 71, "Subtitle"],
Cell[CellGroupData[{
Cell[267155, 7448, 1352, 23, 28, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[268510, 7473, 508, 12, 95, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[269021, 7487, 1144, 38, 90, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Closed]],
Cell[CellGroupData[{
Cell[270202, 7530, 833, 18, 28, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[271038, 7550, 590, 13, 95, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[271631, 7565, 1004, 31, 65, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Closed]],
Cell[CellGroupData[{
Cell[272672, 7601, 786, 15, 28, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[273461, 7618, 635, 16, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[274099, 7636, 1123, 38, 90, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}]
}, Closed]],
Cell[275237, 7677, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[275318, 7683, 446, 8, 69, "Title"],
Cell[275767, 7693, 827, 22, 78, "Subtitle"],
Cell[CellGroupData[{
Cell[276619, 7719, 1449, 24, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[278071, 7745, 741, 17, 100, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[278815, 7764, 379, 12, 86, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[279197, 7778, 684, 15, 99, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[279884, 7795, 523, 14, 86, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Closed]],
Cell[CellGroupData[{
Cell[280444, 7814, 1028, 19, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[281475, 7835, 871, 19, 100, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[282349, 7856, 1637, 60, 159, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[283989, 7918, 818, 18, 99, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[284810, 7938, 1029, 35, 91, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Closed]],
Cell[CellGroupData[{
Cell[285876, 7978, 914, 17, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[286793, 7997, 827, 21, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[287623, 8020, 1885, 71, 127, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[289511, 8093, 847, 21, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[290361, 8116, 509, 18, 83, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Closed]],
Cell[290885, 8137, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[290966, 8143, 444, 8, 69, "Title"],
Cell[291413, 8153, 799, 21, 81, "Subtitle"],
Cell[CellGroupData[{
Cell[292237, 8178, 791, 15, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[293031, 8195, 568, 14, 102, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[293602, 8211, 744, 23, 88, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Closed]],
Cell[CellGroupData[{
Cell[294383, 8239, 749, 17, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[295135, 8258, 670, 16, 102, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[295808, 8276, 2438, 73, 141, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Closed]],
Cell[CellGroupData[{
Cell[298283, 8354, 800, 15, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[299086, 8371, 702, 18, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[299791, 8391, 917, 29, 88, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
