(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    137050,       3435]
NotebookOptionsPosition[    126042,       3167]
NotebookOutlinePosition[    126969,       3201]
CellTagsIndexPosition[    126926,       3198]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Integral Function Integration Problem 1", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, {3.4821973084456434`*^9, 3.482197309066536*^9}, {
   3.4821982364300194`*^9, 3.482198240976557*^9}, 3.482198357524144*^9, {
   3.4821988021534896`*^9, 3.4821988078316545`*^9}, 3.4821989164378223`*^9, {
   3.482198948964594*^9, 3.4821990020909853`*^9}, 3.482199864941704*^9, {
   3.482716663183403*^9, 3.4827166643250446`*^9}, {3.483395721684504*^9, 
   3.4833957223654833`*^9}, {3.48996737228399*^9, 3.4899673724867897`*^9}},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"ExpIntegralEi", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "2"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
   3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
   3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.4821994592383313`*^9, {
   3.483228685917283*^9, 3.483228689622611*^9}, {3.4900535844506693`*^9, 
   3.4900535893069468`*^9}, 3.490383440753775*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " is able integrate ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"ExpIntegralEi", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}],
   FontSize->16]],
  CellDingbat->None,
  CellChangeTimes->{
   3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
    3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
    3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
    3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
    3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
    3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.4821994592383313`*^9, {
    3.483228685917283*^9, 3.483228689622611*^9}, {3.4900535844506693`*^9, 
    3.4900535893069468`*^9}},
  TextAlignment->Center,
  FontFamily->"Courier New",
  FontSize->20,
  FontWeight->"Bold"],
 " for integer ",
 Cell[BoxData[
  RowBox[{"m", "\[GreaterEqual]", "0"}]],
  FontWeight->"Bold"],
 ":"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, 3.4899789370019164`*^9, {
   3.4899837231007237`*^9, 3.4899837293407345`*^9}, 3.489983804220866*^9, {
   3.4899838344069195`*^9, 3.489983854281354*^9}, {3.489983888414214*^9, 
   3.4899838889446154`*^9}, {3.490054027872031*^9, 3.4900541084246387`*^9}, {
   3.4900542452264633`*^9, 3.490054281299526*^9}, {3.490054314988453*^9, 
   3.490054333568516*^9}, 3.490055706116021*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"ExpIntegralEi", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "2"], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4553246789720125`*^9, {3.4553317886151776`*^9, 3.4553318062905936`*^9}, {
   3.4553318574741917`*^9, 3.455331867168131*^9}, 3.4832287131163936`*^9, {
   3.4832291355438147`*^9, 3.4832291553723264`*^9}, {3.490048825920497*^9, 
   3.4900488383822093`*^9}, {3.490053683318324*^9, 3.490053710846898*^9}, {
   3.4900537410046234`*^9, 3.4900537488320713`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]], " ", 
     RowBox[{"ExpIntegralEi", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}], "b"]}], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"ExpIntegralEi", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], "b"], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"ExpIntegralEi", "[", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}]}], "]"}]}], "b"]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.483228049021472*^9, 3.4832281137345247`*^9}, {
   3.4832281515789423`*^9, 3.4832281741514*^9}, {3.4832282938234797`*^9, 
   3.483228308214173*^9}, 3.4832291553723264`*^9, {3.490048825920497*^9, 
   3.4900488383822093`*^9}, {3.490053711876957*^9, 3.490053742296697*^9}}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"ExpIntegralEi", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4553246789720125`*^9, {3.4553317886151776`*^9, 3.4553318062905936`*^9}, {
   3.4553318574741917`*^9, 3.455331867168131*^9}, 3.4832287131163936`*^9, {
   3.4832291355438147`*^9, 3.4832291553723264`*^9}, {3.490048825920497*^9, 
   3.4900488383822093`*^9}, {3.490053683318324*^9, 3.490053692197832*^9}, {
   3.490053752680291*^9, 3.490053791386505*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"2", " ", "a"}], "+", 
     RowBox[{"2", " ", "b", " ", "x"}]}]], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "2"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "a", "-", 
      RowBox[{"b", " ", "x"}]}], ")"}], " ", 
    RowBox[{"ExpIntegralEi", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}], 
   SuperscriptBox["b", "2"]], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      SuperscriptBox["a", "2"], 
      SuperscriptBox["b", "2"]], "-", 
     SuperscriptBox["x", "2"]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"ExpIntegralEi", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "a"}]}], ")"}], " ", 
    RowBox[{"ExpIntegralEi", "[", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}]}], "]"}]}], 
   SuperscriptBox["b", "2"]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.490053753607344*^9, 3.4900537608557587`*^9}, 
   3.490055706116021*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox[
     RowBox[{"ExpIntegralEi", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4553246789720125`*^9, {3.4553317886151776`*^9, 3.4553318062905936`*^9}, {
   3.4553318574741917`*^9, 3.455331867168131*^9}, 3.4832287131163936`*^9, {
   3.4832291355438147`*^9, 3.4832291553723264`*^9}, {3.490048825920497*^9, 
   3.4900488383822093`*^9}, {3.490053683318324*^9, 3.490053695860041*^9}, {
   3.490053766844101*^9, 3.4900537720734005`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"5", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"2", " ", "a"}], "+", 
       RowBox[{"2", " ", "b", " ", "x"}]}]]}], 
    RowBox[{"6", " ", 
     SuperscriptBox["b", "3"]}]]}], "-", 
  FractionBox[
   RowBox[{"2", " ", "a", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"2", " ", "a"}], "+", 
      RowBox[{"2", " ", "b", " ", "x"}]}]]}], 
   RowBox[{"3", " ", 
    SuperscriptBox["b", "3"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"2", " ", "a"}], "+", 
      RowBox[{"2", " ", "b", " ", "x"}]}]], " ", "x"}], 
   RowBox[{"3", " ", 
    SuperscriptBox["b", "2"]}]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]], " ", 
    RowBox[{"(", 
     RowBox[{"2", "+", "a", "+", 
      SuperscriptBox["a", "2"], "-", 
      RowBox[{"2", " ", "b", " ", "x"}], "-", 
      RowBox[{"a", " ", "b", " ", "x"}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], " ", 
    RowBox[{"ExpIntegralEi", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}], 
   RowBox[{"3", " ", 
    SuperscriptBox["b", "3"]}]], "+", 
  RowBox[{
   FractionBox["1", "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      SuperscriptBox["a", "3"], 
      SuperscriptBox["b", "3"]], "+", 
     SuperscriptBox["x", "3"]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"ExpIntegralEi", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"2", "+", 
      RowBox[{"3", " ", "a"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "2"]}]}], ")"}], " ", 
    RowBox[{"ExpIntegralEi", "[", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}]}], "]"}]}], 
   RowBox[{"3", " ", 
    SuperscriptBox["b", "3"]}]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.490053764358959*^9, 3.490053768537198*^9}, 
   3.490055706116021*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is unable integrate ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"ExpIntegralEi", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}],
   FontSize->16]],
  CellDingbat->None,
  CellChangeTimes->{
   3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
    3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
    3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
    3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
    3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
    3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.4821994592383313`*^9, {
    3.483228685917283*^9, 3.483228689622611*^9}, {3.4900535844506693`*^9, 
    3.4900535893069468`*^9}},
  TextAlignment->Center,
  FontFamily->"Courier New",
  FontSize->20,
  FontWeight->"Bold"],
 " for integer ",
 Cell[BoxData[
  RowBox[{"m", ">", "0"}]],
  FontWeight->"Bold"],
 ":"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, 3.4899789370019164`*^9, {
   3.4899837231007237`*^9, 3.4899837293407345`*^9}, 3.489983804220866*^9, {
   3.4899838344069195`*^9, 3.489983854281354*^9}, {3.489983888414214*^9, 
   3.4899838889446154`*^9}, {3.490054027872031*^9, 3.4900541084246387`*^9}, {
   3.490054142789604*^9, 3.490054153418212*^9}, 3.4900543874285965`*^9, 
   3.490055712142366*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"ExpIntegralEi", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "2"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4553246789720125`*^9, {3.4553317886151776`*^9, 3.4553318062905936`*^9}, {
   3.4553318574741917`*^9, 3.455331867168131*^9}, 3.4832287131163936`*^9, {
   3.4832291355438147`*^9, 3.4832291553723264`*^9}, {3.483309061274062*^9, 
   3.483309062235445*^9}, 3.490048854912155*^9, 3.4900538967875338`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]], " ", 
    RowBox[{"ExpIntegralEi", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"ExpIntegralEi", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], "+", 
   RowBox[{"2", " ", 
    RowBox[{"ExpIntegralEi", "[", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}]}], "]"}]}]}], "b"]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.446693458840048*^9, 3.446693479820216*^9}, {
   3.446867077228755*^9, 3.423171765484375*^9}, 3.455324693893469*^9, {
   3.455331915287323*^9, 3.4553319516696386`*^9}, {3.4553320230522814`*^9, 
   3.455332032726192*^9}, 3.4832292115030384`*^9, 3.4833090693256397`*^9, 
   3.4900539248111362`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"x", " ", 
   SuperscriptBox[
    RowBox[{"ExpIntegralEi", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "2"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4553246789720125`*^9, {3.4553317886151776`*^9, 3.4553318062905936`*^9}, {
   3.4553318574741917`*^9, 3.455331867168131*^9}, 3.4832287131163936`*^9, {
   3.4832291355438147`*^9, 3.4832291553723264`*^9}, {3.483309061274062*^9, 
   3.4833090879123664`*^9}, 3.490048854912155*^9, {3.4900539133794823`*^9, 
   3.490053921687958*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"ExpIntegralEi", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.4833090890139503`*^9, 3.490048854912155*^9, 
  3.490053926551236*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   SuperscriptBox[
    RowBox[{"ExpIntegralEi", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "2"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4553246789720125`*^9, {3.4553317886151776`*^9, 3.4553318062905936`*^9}, {
   3.4553318574741917`*^9, 3.455331867168131*^9}, 3.4832287131163936`*^9, {
   3.4832291355438147`*^9, 3.4832291553723264`*^9}, {3.483309061274062*^9, 
   3.4833090955032816`*^9}, 3.490048854912155*^9, 3.490053918103753*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox[
     RowBox[{"ExpIntegralEi", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.4833090966749663`*^9, 3.490048854912155*^9, 
  3.4900539277053022`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " is unable integrate ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"ExpIntegralEi", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}],
   FontSize->16]],
  CellDingbat->None,
  CellChangeTimes->{
   3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
    3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
    3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
    3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
    3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
    3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.4821994592383313`*^9, {
    3.483228685917283*^9, 3.483228689622611*^9}, {3.4900535844506693`*^9, 
    3.4900535893069468`*^9}},
  TextAlignment->Center,
  FontFamily->"Courier New",
  FontSize->20,
  FontWeight->"Bold"],
 " for integer ",
 Cell[BoxData[
  RowBox[{"m", ">", "1"}]],
  FontWeight->"Bold"],
 ":"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, 3.4899789370019164`*^9, {
   3.4899837231007237`*^9, 3.4899837293407345`*^9}, 3.489983804220866*^9, {
   3.4899838344069195`*^9, 3.489983854281354*^9}, {3.489983888414214*^9, 
   3.4899838889446154`*^9}, {3.490054027872031*^9, 3.4900541084246387`*^9}, {
   3.490054142789604*^9, 3.490054153418212*^9}, 3.4900543874285965`*^9, 
   3.490054464714017*^9, 3.4900556216571903`*^9, 3.4900557171266513`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Ei", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4553246789720125`*^9, {3.4553317886151776`*^9, 3.4553318062905936`*^9}, {
   3.4553318574741917`*^9, 3.455331867168131*^9}, 3.4832287131163936`*^9, {
   3.4832291355438147`*^9, 3.4832291553723264`*^9}, {3.4833093515915184`*^9, 
   3.4833094164147296`*^9}, 3.490048866159798*^9, {3.490054575448351*^9, 
   3.49005458416885*^9}, {3.490054673634967*^9, 3.490054673938984*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]], " ", 
    RowBox[{"Ei", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"Ei", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], "-", 
   RowBox[{"2", " ", 
    RowBox[{"Ei", "[", 
     RowBox[{"1", ",", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "a"}], "-", 
       RowBox[{"2", " ", "b", " ", "x"}]}]}], "]"}]}]}], "b"]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{3.490055302990964*^9, 3.4900557171266513`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"x", "*", "Ei", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4553246789720125`*^9, {3.4553317886151776`*^9, 3.4553318062905936`*^9}, {
   3.4553318574741917`*^9, 3.455331867168131*^9}, 3.4832287131163936`*^9, {
   3.4832291355438147`*^9, 3.4832291553723264`*^9}, {3.4833093515915184`*^9, 
   3.4833094164147296`*^9}, 3.490048866159798*^9, {3.490054575448351*^9, 
   3.49005458416885*^9}, {3.490054673634967*^9, 3.490054673938984*^9}, {
   3.4900551787808595`*^9, 3.4900551800189304`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"2", " ", "a"}], "+", 
     RowBox[{"2", " ", "b", " ", "x"}]}]], "+", 
   RowBox[{"2", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]], " ", 
    RowBox[{"Ei", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}], "+", 
   RowBox[{"2", " ", "a", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]], " ", 
    RowBox[{"Ei", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}], "-", 
   RowBox[{"2", " ", "b", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]], " ", "x", " ", 
    RowBox[{"Ei", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}], "-", 
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    SuperscriptBox[
     RowBox[{"Ei", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], "+", 
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox[
     RowBox[{"Ei", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], "-", 
   RowBox[{"2", " ", 
    RowBox[{"Ei", "[", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}]}], "]"}]}], "+", 
   RowBox[{"4", " ", "a", " ", 
    RowBox[{"Ei", "[", 
     RowBox[{"1", ",", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "a"}], "-", 
       RowBox[{"2", " ", "b", " ", "x"}]}]}], "]"}]}]}], 
  RowBox[{"2", " ", 
   SuperscriptBox["b", "2"]}]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.4900554904246845`*^9, 3.4900555054785457`*^9}, 
   3.4900555416266127`*^9, 3.4900557171266513`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "*", "Ei", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4553246789720125`*^9, {3.4553317886151776`*^9, 3.4553318062905936`*^9}, {
   3.4553318574741917`*^9, 3.455331867168131*^9}, 3.4832287131163936`*^9, {
   3.4832291355438147`*^9, 3.4832291553723264`*^9}, {3.4833093515915184`*^9, 
   3.4833094164147296`*^9}, 3.490048866159798*^9, {3.490054575448351*^9, 
   3.49005458416885*^9}, {3.490054673634967*^9, 3.490054673938984*^9}, {
   3.4900551787808595`*^9, 3.4900551800189304`*^9}, {3.4900555690141797`*^9, 
   3.490055569322197*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox[
     RowBox[{"Ei", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{3.4900556115136104`*^9, 3.4900557171266513`*^9}]
}, Closed]],

Cell["", "PageBreak",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 PageBreakBelow->True,
 CellChangeTimes->{3.4561670329935665`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Integral Function Integration Problem 2", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, {3.4821973084456434`*^9, 3.482197309066536*^9}, {
   3.4821982364300194`*^9, 3.482198240976557*^9}, 3.482198357524144*^9, {
   3.4821988021534896`*^9, 3.4821988078316545`*^9}, 3.4821989164378223`*^9, {
   3.482198948964594*^9, 3.4821990020909853`*^9}, 3.482199864941704*^9, {
   3.482716663183403*^9, 3.4827166643250446`*^9}, {3.483395721684504*^9, 
   3.4833957223654833`*^9}, {3.48996737228399*^9, 3.4899673724867897`*^9}, 
   3.4900560733930283`*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"SinIntegral", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "2"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
   3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
   3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.4821994592383313`*^9, {
   3.483228685917283*^9, 3.483228689622611*^9}, {3.4900535844506693`*^9, 
   3.4900535893069468`*^9}, {3.4900560144516573`*^9, 3.4900560162357593`*^9}, 
   3.4903834420837765`*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " is able integrate ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"SinIntegral", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}],
   FontSize->16]],
  CellDingbat->None,
  CellChangeTimes->{
   3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
    3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
    3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
    3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
    3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
    3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.4821994592383313`*^9, {
    3.483228685917283*^9, 3.483228689622611*^9}, {3.4900535844506693`*^9, 
    3.4900535893069468`*^9}, {3.4900560144516573`*^9, 3.4900560162357593`*^9}},
  TextAlignment->Center,
  FontFamily->"Courier New",
  FontSize->20,
  FontWeight->"Bold"],
 " for integer ",
 Cell[BoxData[
  RowBox[{"m", "\[GreaterEqual]", "0"}]],
  FontWeight->"Bold"],
 ":"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, 3.4899789370019164`*^9, {
   3.4899837231007237`*^9, 3.4899837293407345`*^9}, 3.489983804220866*^9, {
   3.4899838344069195`*^9, 3.489983854281354*^9}, {3.489983888414214*^9, 
   3.4899838889446154`*^9}, {3.490054027872031*^9, 3.4900541084246387`*^9}, {
   3.4900542452264633`*^9, 3.490054281299526*^9}, {3.490054314988453*^9, 
   3.490054333568516*^9}, 3.490055706116021*^9, {3.4900559829688563`*^9, 
   3.4900559889471984`*^9}, {3.4900560230661497`*^9, 3.4900560461754713`*^9}}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"SinIntegral", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "2"], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4553246789720125`*^9, {3.4553317886151776`*^9, 3.4553318062905936`*^9}, {
   3.4553318574741917`*^9, 3.455331867168131*^9}, 3.4832287131163936`*^9, {
   3.4832291355438147`*^9, 3.4832291553723264`*^9}, {3.490048825920497*^9, 
   3.4900488383822093`*^9}, {3.490053683318324*^9, 3.490053710846898*^9}, {
   3.4900537410046234`*^9, 3.4900537488320713`*^9}, 3.490056114560383*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], " ", 
    RowBox[{"SinIntegral", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}], "b"], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"SinIntegral", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], "b"], "-", 
  FractionBox[
   RowBox[{"SinIntegral", "[", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}]}], "]"}], "b"]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.483228049021472*^9, 3.4832281137345247`*^9}, {
   3.4832281515789423`*^9, 3.4832281741514*^9}, {3.4832282938234797`*^9, 
   3.483228308214173*^9}, 3.4832291553723264`*^9, {3.490048825920497*^9, 
   3.4900488383822093`*^9}, {3.490053711876957*^9, 3.490053742296697*^9}, 
   3.490056139723822*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"SinIntegral", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4553246789720125`*^9, {3.4553317886151776`*^9, 3.4553318062905936`*^9}, {
   3.4553318574741917`*^9, 3.455331867168131*^9}, 3.4832287131163936`*^9, {
   3.4832291355438147`*^9, 3.4832291553723264`*^9}, {3.490048825920497*^9, 
   3.4900488383822093`*^9}, {3.490053683318324*^9, 3.490053692197832*^9}, {
   3.490053752680291*^9, 3.490053791386505*^9}, {3.4900561163714867`*^9, 
   3.4900561509024615`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"Cos", "[", 
    RowBox[{
     RowBox[{"2", " ", "a"}], "+", 
     RowBox[{"2", " ", "b", " ", "x"}]}], "]"}], 
   RowBox[{"4", " ", 
    SuperscriptBox["b", "2"]}]], "-", 
  FractionBox[
   RowBox[{"CosIntegral", "[", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}]}], "]"}], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "2"]}]], "+", 
  FractionBox[
   RowBox[{"Log", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "2"]}]], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "-", 
         RowBox[{"b", " ", "x"}]}], ")"}], " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"Sin", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}]}], ")"}], " ", 
    RowBox[{"SinIntegral", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}], 
   SuperscriptBox["b", "2"]], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      SuperscriptBox["a", "2"], 
      SuperscriptBox["b", "2"]], "-", 
     SuperscriptBox["x", "2"]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"SinIntegral", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], "+", 
  FractionBox[
   RowBox[{"a", " ", 
    RowBox[{"SinIntegral", "[", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}]}], "]"}]}], 
   SuperscriptBox["b", "2"]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.490053753607344*^9, 3.4900537608557587`*^9}, 
   3.490055706116021*^9, {3.490056143998067*^9, 3.4900561476182737`*^9}}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox[
     RowBox[{"SinIntegral", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4553246789720125`*^9, {3.4553317886151776`*^9, 3.4553318062905936`*^9}, {
   3.4553318574741917`*^9, 3.455331867168131*^9}, 3.4832287131163936`*^9, {
   3.4832291355438147`*^9, 3.4832291553723264`*^9}, {3.490048825920497*^9, 
   3.4900488383822093`*^9}, {3.490053683318324*^9, 3.490053695860041*^9}, {
   3.490053766844101*^9, 3.4900537720734005`*^9}, 3.490056117810569*^9, {
   3.4900561560287547`*^9, 3.4900561620050964`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"2", " ", "x"}], 
   RowBox[{"3", " ", 
    SuperscriptBox["b", "2"]}]], "-", 
  FractionBox[
   RowBox[{"a", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{
      RowBox[{"2", " ", "a"}], "+", 
      RowBox[{"2", " ", "b", " ", "x"}]}], "]"}]}], 
   RowBox[{"3", " ", 
    SuperscriptBox["b", "3"]}]], "+", 
  FractionBox[
   RowBox[{"x", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{
      RowBox[{"2", " ", "a"}], "+", 
      RowBox[{"2", " ", "b", " ", "x"}]}], "]"}]}], 
   RowBox[{"6", " ", 
    SuperscriptBox["b", "2"]}]], "+", 
  FractionBox[
   RowBox[{"a", " ", 
    RowBox[{"CosIntegral", "[", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}]}], "]"}]}], 
   SuperscriptBox["b", "3"]], "-", 
  FractionBox[
   RowBox[{"a", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}], 
   SuperscriptBox["b", "3"]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}], 
   RowBox[{"3", " ", 
    SuperscriptBox["b", "3"]}]], "-", 
  FractionBox[
   RowBox[{"Sin", "[", 
    RowBox[{
     RowBox[{"2", " ", "a"}], "+", 
     RowBox[{"2", " ", "b", " ", "x"}]}], "]"}], 
   RowBox[{"12", " ", 
    SuperscriptBox["b", "3"]}]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "-", 
         SuperscriptBox["a", "2"], "+", 
         RowBox[{"a", " ", "b", " ", "x"}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "-", 
         RowBox[{"2", " ", "b", " ", "x"}]}], ")"}], " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
    RowBox[{"SinIntegral", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}], 
   RowBox[{"3", " ", 
    SuperscriptBox["b", "3"]}]], "+", 
  RowBox[{
   FractionBox["1", "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      SuperscriptBox["a", "3"], 
      SuperscriptBox["b", "3"]], "+", 
     SuperscriptBox["x", "3"]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"SinIntegral", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"2", "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "2"]}]}], ")"}], " ", 
    RowBox[{"SinIntegral", "[", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}]}], "]"}]}], 
   RowBox[{"3", " ", 
    SuperscriptBox["b", "3"]}]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.490053764358959*^9, 3.490053768537198*^9}, 
   3.490055706116021*^9, {3.490056153829629*^9, 3.490056158159877*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is unable integrate ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"SinIntegral", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}],
   FontSize->16]],
  CellDingbat->None,
  CellChangeTimes->{
   3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
    3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
    3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
    3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
    3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
    3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.4821994592383313`*^9, {
    3.483228685917283*^9, 3.483228689622611*^9}, {3.4900535844506693`*^9, 
    3.4900535893069468`*^9}},
  TextAlignment->Center,
  FontFamily->"Courier New",
  FontSize->20,
  FontWeight->"Bold"],
 " for integer ",
 Cell[BoxData[
  RowBox[{"m", ">", "0"}]],
  FontWeight->"Bold"],
 ":"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, 3.4899789370019164`*^9, {
   3.4899837231007237`*^9, 3.4899837293407345`*^9}, 3.489983804220866*^9, {
   3.4899838344069195`*^9, 3.489983854281354*^9}, {3.489983888414214*^9, 
   3.4899838889446154`*^9}, {3.490054027872031*^9, 3.4900541084246387`*^9}, {
   3.490054142789604*^9, 3.490054153418212*^9}, 3.4900543874285965`*^9, 
   3.490055712142366*^9, 3.49005606118033*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"SinIntegral", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "2"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4553246789720125`*^9, {3.4553317886151776`*^9, 3.4553318062905936`*^9}, {
   3.4553318574741917`*^9, 3.455331867168131*^9}, 3.4832287131163936`*^9, {
   3.4832291355438147`*^9, 3.4832291553723264`*^9}, {3.483309061274062*^9, 
   3.483309062235445*^9}, 3.490048854912155*^9, 3.4900538967875338`*^9, 
   3.490056119631673*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"2", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], " ", 
    RowBox[{"SinIntegral", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"SinIntegral", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], "-", 
   RowBox[{"SinIntegral", "[", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}]}], "]"}]}], "b"]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.446693458840048*^9, 3.446693479820216*^9}, {
   3.446867077228755*^9, 3.423171765484375*^9}, 3.455324693893469*^9, {
   3.455331915287323*^9, 3.4553319516696386`*^9}, {3.4553320230522814`*^9, 
   3.455332032726192*^9}, 3.4832292115030384`*^9, 3.4833090693256397`*^9, 
   3.4900539248111362`*^9, 3.490056166246339*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"x", " ", 
   SuperscriptBox[
    RowBox[{"SinIntegral", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "2"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4553246789720125`*^9, {3.4553317886151776`*^9, 3.4553318062905936`*^9}, {
   3.4553318574741917`*^9, 3.455331867168131*^9}, 3.4832287131163936`*^9, {
   3.4832291355438147`*^9, 3.4832291553723264`*^9}, {3.483309061274062*^9, 
   3.4833090879123664`*^9}, 3.490048854912155*^9, {3.4900539133794823`*^9, 
   3.490053921687958*^9}, 3.490056121583785*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"SinIntegral", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.4833090890139503`*^9, 3.490048854912155*^9, 
  3.490053926551236*^9, 3.4900561691655064`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   SuperscriptBox[
    RowBox[{"SinIntegral", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "2"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4553246789720125`*^9, {3.4553317886151776`*^9, 3.4553318062905936`*^9}, {
   3.4553318574741917`*^9, 3.455331867168131*^9}, 3.4832287131163936`*^9, {
   3.4832291355438147`*^9, 3.4832291553723264`*^9}, {3.483309061274062*^9, 
   3.4833090955032816`*^9}, 3.490048854912155*^9, 3.490053918103753*^9, 
   3.490056123568898*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox[
     RowBox[{"SinIntegral", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.4833090966749663`*^9, 3.490048854912155*^9, 
  3.4900539277053022`*^9, 3.4900561724246926`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " is unable integrate ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"SinIntegral", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}],
   FontSize->16]],
  CellDingbat->None,
  CellChangeTimes->{
   3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
    3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
    3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
    3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
    3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
    3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.4821994592383313`*^9, {
    3.483228685917283*^9, 3.483228689622611*^9}, {3.4900535844506693`*^9, 
    3.4900535893069468`*^9}},
  TextAlignment->Center,
  FontFamily->"Courier New",
  FontSize->20,
  FontWeight->"Bold"],
 " for integer ",
 Cell[BoxData[
  RowBox[{"m", ">", "1"}]],
  FontWeight->"Bold"],
 ":"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, 3.4899789370019164`*^9, {
   3.4899837231007237`*^9, 3.4899837293407345`*^9}, 3.489983804220866*^9, {
   3.4899838344069195`*^9, 3.489983854281354*^9}, {3.489983888414214*^9, 
   3.4899838889446154`*^9}, {3.490054027872031*^9, 3.4900541084246387`*^9}, {
   3.490054142789604*^9, 3.490054153418212*^9}, 3.4900543874285965`*^9, 
   3.490054464714017*^9, 3.4900556216571903`*^9, 3.4900557171266513`*^9, 
   3.490056063768478*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Si", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4553246789720125`*^9, {3.4553317886151776`*^9, 3.4553318062905936`*^9}, {
   3.4553318574741917`*^9, 3.455331867168131*^9}, 3.4832287131163936`*^9, {
   3.4832291355438147`*^9, 3.4832291553723264`*^9}, {3.4833093515915184`*^9, 
   3.4833094164147296`*^9}, 3.490048866159798*^9, {3.490054575448351*^9, 
   3.49005458416885*^9}, {3.490054673634967*^9, 3.490054673938984*^9}, {
   3.490056127640131*^9, 3.490056128007152*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"2", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], " ", 
    RowBox[{"Si", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"Si", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], "-", 
   RowBox[{"Si", "[", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}]}], "]"}]}], "b"]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.4900563242353754`*^9, 3.490056330382727*^9}, 
   3.4900564324015627`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"x", "*", "Si", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4553246789720125`*^9, {3.4553317886151776`*^9, 3.4553318062905936`*^9}, {
   3.4553318574741917`*^9, 3.455331867168131*^9}, 3.4832287131163936`*^9, {
   3.4832291355438147`*^9, 3.4832291553723264`*^9}, {3.4833093515915184`*^9, 
   3.4833094164147296`*^9}, 3.490048866159798*^9, {3.490054575448351*^9, 
   3.49005458416885*^9}, {3.490054673634967*^9, 3.490054673938984*^9}, {
   3.4900551787808595`*^9, 3.4900551800189304`*^9}, {3.4900561317483664`*^9, 
   3.490056132048383*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"Ci", "[", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}]}], "]"}], 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "2"]}]]}], "+", 
  FractionBox[
   RowBox[{"Cos", "[", 
    RowBox[{
     RowBox[{"2", " ", "a"}], "+", 
     RowBox[{"2", " ", "b", " ", "x"}]}], "]"}], 
   RowBox[{"4", " ", 
    SuperscriptBox["b", "2"]}]], "+", 
  FractionBox[
   RowBox[{"Log", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "2"]}]], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      SuperscriptBox["a", "2"], 
      SuperscriptBox["b", "2"]], "-", 
     SuperscriptBox["x", "2"]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"Si", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], "+", 
  FractionBox[
   RowBox[{"a", " ", 
    RowBox[{"Si", "[", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}]}], "]"}]}], 
   SuperscriptBox["b", "2"]], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"Si", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "-", 
         RowBox[{"b", " ", "x"}]}], ")"}], " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"Sin", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}]}], ")"}]}], 
   SuperscriptBox["b", "2"]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{3.490056350932903*^9, 3.4900564324015627`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "*", "Si", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4553246789720125`*^9, {3.4553317886151776`*^9, 3.4553318062905936`*^9}, {
   3.4553318574741917`*^9, 3.455331867168131*^9}, 3.4832287131163936`*^9, {
   3.4832291355438147`*^9, 3.4832291553723264`*^9}, {3.4833093515915184`*^9, 
   3.4833094164147296`*^9}, 3.490048866159798*^9, {3.490054575448351*^9, 
   3.49005458416885*^9}, {3.490054673634967*^9, 3.490054673938984*^9}, {
   3.4900551787808595`*^9, 3.4900551800189304`*^9}, {3.4900555690141797`*^9, 
   3.490055569322197*^9}, {3.490056134715536*^9, 3.4900561351435604`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox[
     RowBox[{"Ei", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{3.4900556115136104`*^9, 3.4900557171266513`*^9}]
}, Closed]],

Cell["", "Text"],

Cell["\<\
Note that these systems give similar results to the above for the cosine \
integral, hyperbolic sine integral and hyperbolic cosine integral functions.\
\>", "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832040958843503`*^9, 3.4832041044566765`*^9}, 3.483204218670909*^9, 
   3.4833920379275217`*^9, {3.483392125182989*^9, 3.4833921454921923`*^9}, {
   3.48339221312945*^9, 3.483392219528651*^9}, {3.483392987983635*^9, 
   3.4833931408334227`*^9}, {3.4833932165322723`*^9, 3.483393223472251*^9}, {
   3.483395056508027*^9, 3.4833950705081587`*^9}, {3.4833959109166064`*^9, 
   3.483395925577688*^9}, {3.483395964633848*^9, 3.4833959819287167`*^9}, 
   3.490233013186316*^9}],

Cell["", "PageBreak",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 PageBreakBelow->True,
 CellChangeTimes->{3.4561670329935665`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Integral Function Integration Problem 3", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, {3.4821973084456434`*^9, 3.482197309066536*^9}, {
   3.4821982364300194`*^9, 3.482198240976557*^9}, 3.482198357524144*^9, {
   3.4821988021534896`*^9, 3.4821988078316545`*^9}, 3.4821989164378223`*^9, {
   3.482198948964594*^9, 3.4821990020909853`*^9}, 3.482199864941704*^9, {
   3.482716663183403*^9, 3.4827166643250446`*^9}, {3.483395721684504*^9, 
   3.4833957223654833`*^9}, {3.48996737228399*^9, 3.4899673724867897`*^9}, 
   3.4900556790034704`*^9, 3.4900560824015436`*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"b", " ", "x"}], "]"}], " ", 
   RowBox[{"SinIntegral", "[", 
    RowBox[{"b", " ", "x"}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
   3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
   3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.4821994592383313`*^9, {
   3.483228685917283*^9, 3.483228689622611*^9}, 3.490383443653779*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " is able to integrate  ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"b", " ", "x"}], "]"}], " ", 
    RowBox[{"SinIntegral", "[", 
     RowBox[{"b", " ", "x"}], "]"}]}],
   FontSize->16,
   FontWeight->"Bold"]],
  CellDingbat->None,
  CellChangeTimes->{
   3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
    3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
    3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
    3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
    3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
    3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.482199478365835*^9, {
    3.4827167285874496`*^9, 3.48271673125128*^9}, {3.482718509007568*^9, 
    3.4827185116513696`*^9}, 3.4832032731012464`*^9},
  TextAlignment->Center,
  FontFamily->"Courier New",
  FontSize->20],
 " for all integer m except -1:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832040958843503`*^9, 3.4832041044566765`*^9}, 3.483204218670909*^9, {
   3.4832297658601646`*^9, 3.4832297813023696`*^9}, 3.4900488383822093`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"b", " ", "x"}], "]"}], " ", 
    RowBox[{"SinIntegral", "[", 
     RowBox[{"b", " ", "x"}], "]"}]}], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4553246789720125`*^9, {3.4553317886151776`*^9, 3.4553318062905936`*^9}, {
   3.4553318574741917`*^9, 3.455331867168131*^9}, 3.4832287131163936`*^9, {
   3.4832291355438147`*^9, 3.4832291553723264`*^9}, {3.490048825920497*^9, 
   3.4900488383822093`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    SuperscriptBox["x", "2"], 
    RowBox[{"4", " ", "b"}]]}], "-", 
  FractionBox[
   RowBox[{"CosIntegral", "[", 
    RowBox[{"2", " ", "b", " ", "x"}], "]"}], 
   SuperscriptBox["b", "3"]], "+", 
  FractionBox[
   RowBox[{"Log", "[", "x", "]"}], 
   SuperscriptBox["b", "3"]], "+", 
  FractionBox[
   RowBox[{"x", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"b", " ", "x"}], "]"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"b", " ", "x"}], "]"}]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "2"]}]], "-", 
  FractionBox[
   RowBox[{"5", " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "2"]}], 
   RowBox[{"4", " ", 
    SuperscriptBox["b", "3"]}]], "+", 
  FractionBox[
   RowBox[{"2", " ", "x", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"b", " ", "x"}], "]"}], " ", 
    RowBox[{"SinIntegral", "[", 
     RowBox[{"b", " ", "x"}], "]"}]}], 
   SuperscriptBox["b", "2"]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"b", " ", "x"}], "]"}], " ", 
    RowBox[{"SinIntegral", "[", 
     RowBox[{"b", " ", "x"}], "]"}]}], 
   SuperscriptBox["b", "3"]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"b", " ", "x"}], "]"}], " ", 
    RowBox[{"SinIntegral", "[", 
     RowBox[{"b", " ", "x"}], "]"}]}], "b"]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.483228049021472*^9, 3.4832281137345247`*^9}, {
   3.4832281515789423`*^9, 3.4832281741514*^9}, {3.4832282938234797`*^9, 
   3.483228308214173*^9}, 3.4832291553723264`*^9, {3.490048825920497*^9, 
   3.4900488383822093`*^9}}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"b", " ", "x"}], "]"}], " ", 
    RowBox[{"SinIntegral", "[", 
     RowBox[{"b", " ", "x"}], "]"}]}], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4553246789720125`*^9, {3.4553317886151776`*^9, 3.4553318062905936`*^9}, {
   3.4553318574741917`*^9, 3.455331867168131*^9}, 3.4832287131163936`*^9, {
   3.4832291355438147`*^9, 3.4832291553723264`*^9}, {3.483229471617064*^9, 
   3.483229471957554*^9}, {3.490048825920497*^9, 3.4900488383822093`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["x", 
    RowBox[{"2", " ", "b"}]]}], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"b", " ", "x"}], "]"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"b", " ", "x"}], "]"}]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "2"]}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"b", " ", "x"}], "]"}], " ", 
    RowBox[{"SinIntegral", "[", 
     RowBox[{"b", " ", "x"}], "]"}]}], 
   SuperscriptBox["b", "2"]], "+", 
  FractionBox[
   RowBox[{"x", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"b", " ", "x"}], "]"}], " ", 
    RowBox[{"SinIntegral", "[", 
     RowBox[{"b", " ", "x"}], "]"}]}], "b"], "-", 
  FractionBox[
   RowBox[{"SinIntegral", "[", 
    RowBox[{"2", " ", "b", " ", "x"}], "]"}], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "2"]}]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{3.4832283139924817`*^9, 3.4900488383822093`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"b", " ", "x"}], "]"}], " ", 
    RowBox[{"SinIntegral", "[", 
     RowBox[{"b", " ", "x"}], "]"}]}], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4553246789720125`*^9, {3.4553317886151776`*^9, 3.4553318062905936`*^9}, {
   3.4553318574741917`*^9, 3.455331867168131*^9}, 3.4832287131163936`*^9, {
   3.4832291355438147`*^9, 3.4832291553723264`*^9}, {3.483229475642853*^9, 
   3.483229477575632*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"CosIntegral", "[", 
    RowBox[{"2", " ", "b", " ", "x"}], "]"}], 
   RowBox[{"2", " ", "b"}]], "-", 
  FractionBox[
   RowBox[{"Log", "[", "x", "]"}], 
   RowBox[{"2", " ", "b"}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"b", " ", "x"}], "]"}], " ", 
    RowBox[{"SinIntegral", "[", 
     RowBox[{"b", " ", "x"}], "]"}]}], "b"]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{3.4832283326392946`*^9, 3.4900488383822093`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"b", " ", "x"}], "]"}], " ", 
     RowBox[{"SinIntegral", "[", 
      RowBox[{"b", " ", "x"}], "]"}]}], "x"], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4553246789720125`*^9, {3.4553317886151776`*^9, 3.4553318062905936`*^9}, {
   3.4553318574741917`*^9, 3.455331867168131*^9}, 3.4832287131163936`*^9, {
   3.4832291355438147`*^9, 3.4832291553723264`*^9}, {3.4832295037532735`*^9, 
   3.483229508049451*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"b", " ", "x"}], "]"}], " ", 
     RowBox[{"SinIntegral", "[", 
      RowBox[{"b", " ", "x"}], "]"}]}], "x"], ",", "x"}], "]"}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{3.4832283548111763`*^9, 3.4900488383822093`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"b", " ", "x"}], "]"}], " ", 
     RowBox[{"SinIntegral", "[", 
      RowBox[{"b", " ", "x"}], "]"}]}], 
    SuperscriptBox["x", "2"]], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4553246789720125`*^9, {3.4553317886151776`*^9, 3.4553318062905936`*^9}, {
   3.4553318574741917`*^9, 3.455331867168131*^9}, 3.4832287131163936`*^9, {
   3.4832291355438147`*^9, 3.4832291553723264`*^9}, {3.4832295037532735`*^9, 
   3.483229529249936*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"b", " ", 
   RowBox[{"CosIntegral", "[", 
    RowBox[{"2", " ", "b", " ", "x"}], "]"}]}], "-", 
  FractionBox[
   RowBox[{"Sin", "[", 
    RowBox[{"2", " ", "b", " ", "x"}], "]"}], 
   RowBox[{"2", " ", "x"}]], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"b", " ", "x"}], "]"}], " ", 
    RowBox[{"SinIntegral", "[", 
     RowBox[{"b", " ", "x"}], "]"}]}], "x"], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", "b", " ", 
   SuperscriptBox[
    RowBox[{"SinIntegral", "[", 
     RowBox[{"b", " ", "x"}], "]"}], "2"]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{3.4832283645151296`*^9, 3.4900488383822093`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"b", " ", "x"}], "]"}], " ", 
     RowBox[{"SinIntegral", "[", 
      RowBox[{"b", " ", "x"}], "]"}]}], 
    SuperscriptBox["x", "3"]], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4553246789720125`*^9, {3.4553317886151776`*^9, 3.4553318062905936`*^9}, {
   3.4553318574741917`*^9, 3.455331867168131*^9}, 3.4832287131163936`*^9, {
   3.4832291355438147`*^9, 3.4832291553723264`*^9}, {3.4832295037532735`*^9, 
   3.4832295399252863`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox["b", 
   RowBox[{"4", " ", "x"}]], "-", 
  FractionBox[
   RowBox[{"b", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", "b", " ", "x"}], "]"}]}], 
   RowBox[{"2", " ", "x"}]], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox["b", "2"], " ", 
   RowBox[{"Int", "[", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"b", " ", "x"}], "]"}], " ", 
       RowBox[{"SinIntegral", "[", 
        RowBox[{"b", " ", "x"}], "]"}]}], "x"], ",", "x"}], "]"}]}], "-", 
  FractionBox[
   RowBox[{"Sin", "[", 
    RowBox[{"2", " ", "b", " ", "x"}], "]"}], 
   RowBox[{"8", " ", 
    SuperscriptBox["x", "2"]}]], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"b", " ", "x"}], "]"}], " ", 
    RowBox[{"SinIntegral", "[", 
     RowBox[{"b", " ", "x"}], "]"}]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["x", "2"]}]], "+", 
  FractionBox[
   RowBox[{"b", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"b", " ", "x"}], "]"}], " ", 
    RowBox[{"SinIntegral", "[", 
     RowBox[{"b", " ", "x"}], "]"}]}], 
   RowBox[{"2", " ", "x"}]], "-", 
  RowBox[{
   SuperscriptBox["b", "2"], " ", 
   RowBox[{"SinIntegral", "[", 
    RowBox[{"2", " ", "b", " ", "x"}], "]"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{3.4832283750703073`*^9, 3.4900488383822093`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is not able to integrate  ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"b", " ", "x"}], "]"}], " ", 
    RowBox[{"SinIntegral", "[", 
     RowBox[{"b", " ", "x"}], "]"}]}],
   FontSize->16,
   FontWeight->"Bold"]],
  CellDingbat->None,
  CellChangeTimes->{
   3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
    3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
    3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
    3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
    3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
    3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.482199478365835*^9, {
    3.4827167285874496`*^9, 3.48271673125128*^9}, {3.482718509007568*^9, 
    3.4827185116513696`*^9}, 3.4832032731012464`*^9},
  TextAlignment->Center,
  FontFamily->"Courier New",
  FontSize->20],
 " for negative integer m:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832040958843503`*^9, 3.4832041044566765`*^9}, 3.483204218670909*^9, {
   3.4832297658601646`*^9, 3.4832297813023696`*^9}, {3.483309153346456*^9, 
   3.4833092533202114`*^9}, {3.483309951924755*^9, 3.4833099563411055`*^9}, 
   3.490048854912155*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"b", " ", "x"}], "]"}], " ", 
    RowBox[{"SinIntegral", "[", 
     RowBox[{"b", " ", "x"}], "]"}]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4553246789720125`*^9, {3.4553317886151776`*^9, 3.4553318062905936`*^9}, {
   3.4553318574741917`*^9, 3.455331867168131*^9}, 3.4832287131163936`*^9, {
   3.4832291355438147`*^9, 3.4832291553723264`*^9}, {3.483309061274062*^9, 
   3.483309062235445*^9}, 3.490048854912155*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"8", " ", 
    SuperscriptBox["b", "3"]}]], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"5", " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", "b", " ", "x"}], "]"}]}], "-", 
    RowBox[{"8", " ", 
     RowBox[{"CosIntegral", "[", 
      RowBox[{"2", " ", "b", " ", "x"}], "]"}]}], "+", 
    RowBox[{"8", " ", 
     RowBox[{"Log", "[", "x", "]"}]}], "+", 
    RowBox[{"2", " ", "b", " ", "x", " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"2", " ", "b", " ", "x"}], "]"}]}], "+", 
    RowBox[{"8", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "b", " ", "x", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"b", " ", "x"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["x", "2"]}]}], ")"}], " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"b", " ", "x"}], "]"}]}]}], ")"}], " ", 
     RowBox[{"SinIntegral", "[", 
      RowBox[{"b", " ", "x"}], "]"}]}]}], ")"}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.446693458840048*^9, 3.446693479820216*^9}, {
   3.446867077228755*^9, 3.423171765484375*^9}, 3.455324693893469*^9, {
   3.455331915287323*^9, 3.4553319516696386`*^9}, {3.4553320230522814`*^9, 
   3.455332032726192*^9}, 3.4832292115030384`*^9, 3.4833090693256397`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"x", " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"b", " ", "x"}], "]"}], " ", 
   RowBox[{"SinIntegral", "[", 
    RowBox[{"b", " ", "x"}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4553246789720125`*^9, {3.4553317886151776`*^9, 3.4553318062905936`*^9}, {
   3.4553318574741917`*^9, 3.455331867168131*^9}, 3.4832287131163936`*^9, {
   3.4832291355438147`*^9, 3.4832291553723264`*^9}, {3.483309061274062*^9, 
   3.4833090879123664`*^9}, 3.490048854912155*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], " ", "b", " ", "x"}], "+", 
   RowBox[{"Sin", "[", 
    RowBox[{"2", " ", "b", " ", "x"}], "]"}], "+", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"b", " ", "x"}], "]"}], "+", 
      RowBox[{"b", " ", "x", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"b", " ", "x"}], "]"}]}]}], ")"}], " ", 
    RowBox[{"SinIntegral", "[", 
     RowBox[{"b", " ", "x"}], "]"}]}], "-", 
   RowBox[{"2", " ", 
    RowBox[{"SinIntegral", "[", 
     RowBox[{"2", " ", "b", " ", "x"}], "]"}]}]}], 
  RowBox[{"4", " ", 
   SuperscriptBox["b", "2"]}]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.4833090890139503`*^9, 3.490048854912155*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"b", " ", "x"}], "]"}], " ", 
   RowBox[{"SinIntegral", "[", 
    RowBox[{"b", " ", "x"}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4553246789720125`*^9, {3.4553317886151776`*^9, 3.4553318062905936`*^9}, {
   3.4553318574741917`*^9, 3.455331867168131*^9}, 3.4832287131163936`*^9, {
   3.4832291355438147`*^9, 3.4832291553723264`*^9}, {3.483309061274062*^9, 
   3.4833090955032816`*^9}, 3.490048854912155*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"CosIntegral", "[", 
    RowBox[{"2", " ", "b", " ", "x"}], "]"}], 
   RowBox[{"2", " ", "b"}]], "-", 
  FractionBox[
   RowBox[{"Log", "[", 
    RowBox[{"b", " ", "x"}], "]"}], 
   RowBox[{"2", " ", "b"}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"b", " ", "x"}], "]"}], " ", 
    RowBox[{"SinIntegral", "[", 
     RowBox[{"b", " ", "x"}], "]"}]}], "b"]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.4833090966749663`*^9, 3.490048854912155*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"b", " ", "x"}], "]"}], " ", 
     RowBox[{"SinIntegral", "[", 
      RowBox[{"b", " ", "x"}], "]"}]}], "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4553246789720125`*^9, {3.4553317886151776`*^9, 3.4553318062905936`*^9}, {
   3.4553318574741917`*^9, 3.455331867168131*^9}, 3.4832287131163936`*^9, {
   3.4832291355438147`*^9, 3.4832291553723264`*^9}, {3.483309061274062*^9, 
   3.4833091087122755`*^9}, 3.490048854912155*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"b", " ", "x"}], "]"}], " ", 
     RowBox[{"SinIntegral", "[", 
      RowBox[{"b", " ", "x"}], "]"}]}], "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.4833091161629887`*^9, 3.490048854912155*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"b", " ", "x"}], "]"}], " ", 
     RowBox[{"SinIntegral", "[", 
      RowBox[{"b", " ", "x"}], "]"}]}], 
    SuperscriptBox["x", "2"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4553246789720125`*^9, {3.4553317886151776`*^9, 3.4553318062905936`*^9}, {
   3.4553318574741917`*^9, 3.455331867168131*^9}, 3.4832287131163936`*^9, {
   3.4832291355438147`*^9, 3.4832291553723264`*^9}, {3.483309061274062*^9, 
   3.483309121470621*^9}, 3.490048854912155*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"b", " ", "x"}], "]"}], " ", 
     RowBox[{"SinIntegral", "[", 
      RowBox[{"b", " ", "x"}], "]"}]}], 
    SuperscriptBox["x", "2"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.4833091239642067`*^9, 3.490048854912155*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"b", " ", "x"}], "]"}], " ", 
     RowBox[{"SinIntegral", "[", 
      RowBox[{"b", " ", "x"}], "]"}]}], 
    SuperscriptBox["x", "3"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4553246789720125`*^9, {3.4553317886151776`*^9, 3.4553318062905936`*^9}, {
   3.4553318574741917`*^9, 3.455331867168131*^9}, 3.4832287131163936`*^9, {
   3.4832291355438147`*^9, 3.4832291553723264`*^9}, {3.483309061274062*^9, 
   3.483309129742515*^9}, 3.490048854912155*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"b", " ", "x"}], "]"}], " ", 
     RowBox[{"SinIntegral", "[", 
      RowBox[{"b", " ", "x"}], "]"}]}], 
    SuperscriptBox["x", "3"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{3.4833091309843006`*^9, 3.490048854912155*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " is not able to integrate  ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    SuperscriptBox["x", "m"], " ", "Cos", 
    RowBox[{"(", 
     RowBox[{"b", " ", "x"}], ")"}], " ", "Si", 
    RowBox[{"(", 
     RowBox[{"b", " ", "x"}], ")"}]}],
   FontSize->16,
   FontWeight->"Bold"]],
  CellDingbat->None,
  CellChangeTimes->{
   3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
    3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
    3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
    3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
    3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
    3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.482199478365835*^9, {
    3.4827167285874496`*^9, 3.48271673125128*^9}, {3.482718509007568*^9, 
    3.4827185116513696`*^9}, 3.4832032731012464`*^9},
  TextAlignment->Center,
  FontFamily->"Courier New",
  FontSize->20],
 " for negative integer m:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832040958843503`*^9, 3.4832041044566765`*^9}, 3.483204218670909*^9, {
   3.4832297658601646`*^9, 3.4832297813023696`*^9}, {3.483309153346456*^9, 
   3.4833093099316144`*^9}, {3.483309882865453*^9, 3.483309944163595*^9}, 
   3.490048866159798*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "*", "cos", 
      RowBox[{"(", 
       RowBox[{"b", "*", "x"}], ")"}], "*", "Si", 
      RowBox[{"(", 
       RowBox[{"b", "*", "x"}], ")"}]}], ",", "x"}], ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4553246789720125`*^9, {3.4553317886151776`*^9, 3.4553318062905936`*^9}, {
   3.4553318574741917`*^9, 3.455331867168131*^9}, 3.4832287131163936`*^9, {
   3.4832291355438147`*^9, 3.4832291553723264`*^9}, {3.4833093515915184`*^9, 
   3.4833094164147296`*^9}, 3.490048866159798*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    SuperscriptBox["x", "2"], 
    RowBox[{"4", " ", "b"}]]}], "-", 
  FractionBox[
   RowBox[{"Ci", "[", 
    RowBox[{"2", " ", "b", " ", "x"}], "]"}], 
   SuperscriptBox["b", "3"]], "+", 
  FractionBox[
   RowBox[{"Log", "[", "x", "]"}], 
   SuperscriptBox["b", "3"]], "+", 
  FractionBox[
   RowBox[{"x", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"b", " ", "x"}], "]"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"b", " ", "x"}], "]"}]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "2"]}]], "-", 
  FractionBox[
   RowBox[{"5", " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "2"]}], 
   RowBox[{"4", " ", 
    SuperscriptBox["b", "3"]}]], "+", 
  FractionBox[
   RowBox[{"2", " ", "x", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"b", " ", "x"}], "]"}], " ", 
    RowBox[{"Si", "[", 
     RowBox[{"b", " ", "x"}], "]"}]}], 
   SuperscriptBox["b", "2"]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"b", " ", "x"}], "]"}], " ", 
    RowBox[{"Si", "[", 
     RowBox[{"b", " ", "x"}], "]"}]}], 
   SuperscriptBox["b", "3"]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"b", " ", "x"}], "]"}], " ", 
    RowBox[{"Si", "[", 
     RowBox[{"b", " ", "x"}], "]"}]}], "b"]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483309847544664*^9, 3.4833098618452272`*^9}, 
   3.490048866159798*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"x", "*", "cos", 
      RowBox[{"(", 
       RowBox[{"b", "*", "x"}], ")"}], "*", "Si", 
      RowBox[{"(", 
       RowBox[{"b", "*", "x"}], ")"}]}], ",", "x"}], ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4553246789720125`*^9, {3.4553317886151776`*^9, 3.4553318062905936`*^9}, {
   3.4553318574741917`*^9, 3.455331867168131*^9}, 3.4832287131163936`*^9, {
   3.4832291355438147`*^9, 3.4832291553723264`*^9}, {3.4833093515915184`*^9, 
   3.4833094164147296`*^9}, {3.48330959942789*^9, 3.4833096041847296`*^9}, 
   3.490048866159798*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["x", 
    RowBox[{"2", " ", "b"}]]}], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"b", " ", "x"}], "]"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"b", " ", "x"}], "]"}]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "2"]}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"b", " ", "x"}], "]"}], " ", 
    RowBox[{"Si", "[", 
     RowBox[{"b", " ", "x"}], "]"}]}], 
   SuperscriptBox["b", "2"]], "+", 
  FractionBox[
   RowBox[{"x", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"b", " ", "x"}], "]"}], " ", 
    RowBox[{"Si", "[", 
     RowBox[{"b", " ", "x"}], "]"}]}], "b"], "-", 
  FractionBox[
   RowBox[{"Si", "[", 
    RowBox[{"2", " ", "b", " ", "x"}], "]"}], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "2"]}]]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483309862195731*^9, 3.483309863046955*^9}, 
   3.490048866160798*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"cos", 
      RowBox[{"(", 
       RowBox[{"b", "*", "x"}], ")"}], "*", "Si", 
      RowBox[{"(", 
       RowBox[{"b", "*", "x"}], ")"}]}], ",", "x"}], ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4553246789720125`*^9, {3.4553317886151776`*^9, 3.4553318062905936`*^9}, {
   3.4553318574741917`*^9, 3.455331867168131*^9}, 3.4832287131163936`*^9, {
   3.4832291355438147`*^9, 3.4832291553723264`*^9}, {3.4833093515915184`*^9, 
   3.4833094164147296`*^9}, {3.48330959942789*^9, 3.4833096041847296`*^9}, {
   3.483309667305493*^9, 3.483309670860605*^9}, 3.490048866160798*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"Ci", "[", 
    RowBox[{"2", " ", "b", " ", "x"}], "]"}], 
   RowBox[{"2", " ", "b"}]], "-", 
  FractionBox[
   RowBox[{"Log", "[", "x", "]"}], 
   RowBox[{"2", " ", "b"}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"b", " ", "x"}], "]"}], " ", 
    RowBox[{"Si", "[", 
     RowBox[{"b", " ", "x"}], "]"}]}], "b"]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.4833098484059024`*^9, 3.4833098639482512`*^9}, 
   3.490048866160798*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"cos", 
      RowBox[{"(", 
       RowBox[{"b", "*", "x"}], ")"}], "*", "Si", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "*", "x"}], ")"}], "/", "x"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4553246789720125`*^9, {3.4553317886151776`*^9, 3.4553318062905936`*^9}, {
   3.4553318574741917`*^9, 3.455331867168131*^9}, 3.4832287131163936`*^9, {
   3.4832291355438147`*^9, 3.4832291553723264`*^9}, {3.4833093515915184`*^9, 
   3.4833094164147296`*^9}, {3.48330959942789*^9, 3.4833096041847296`*^9}, {
   3.483309667305493*^9, 3.483309670860605*^9}, {3.4833097094260592`*^9, 
   3.4833097143130865`*^9}, 3.490048866160798*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"b", " ", "x"}], "]"}], " ", 
     RowBox[{"Si", "[", 
      RowBox[{"b", " ", "x"}], "]"}]}], "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.4833098645791583`*^9, 3.483309864599187*^9}, 
   3.490048866160798*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"cos", 
      RowBox[{"(", 
       RowBox[{"b", "*", "x"}], ")"}], "*", "Si", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "*", "x"}], ")"}], "/", 
       RowBox[{"x", "^", "2"}]}]}], ",", "x"}], ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4553246789720125`*^9, {3.4553317886151776`*^9, 3.4553318062905936`*^9}, {
   3.4553318574741917`*^9, 3.455331867168131*^9}, 3.4832287131163936`*^9, {
   3.4832291355438147`*^9, 3.4832291553723264`*^9}, {3.4833093515915184`*^9, 
   3.4833094164147296`*^9}, {3.48330959942789*^9, 3.4833096041847296`*^9}, {
   3.483309667305493*^9, 3.483309670860605*^9}, {3.4833097094260592`*^9, 
   3.4833097143130865`*^9}, {3.483309789691475*^9, 3.483309790031965*^9}, 
   3.490048866160798*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"b", " ", "x"}], "]"}], " ", 
     RowBox[{"Si", "[", 
      RowBox[{"b", " ", "x"}], "]"}]}], 
    SuperscriptBox["x", "2"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.4833098651700077`*^9, 3.483309865190037*^9}, 
   3.490048866160798*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"cos", 
      RowBox[{"(", 
       RowBox[{"b", "*", "x"}], ")"}], "*", "Si", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "*", "x"}], ")"}], "/", 
       RowBox[{"x", "^", "3"}]}]}], ",", "x"}], ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4553246789720125`*^9, {3.4553317886151776`*^9, 3.4553318062905936`*^9}, {
   3.4553318574741917`*^9, 3.455331867168131*^9}, 3.4832287131163936`*^9, {
   3.4832291355438147`*^9, 3.4832291553723264`*^9}, {3.4833093515915184`*^9, 
   3.4833094164147296`*^9}, {3.48330959942789*^9, 3.4833096041847296`*^9}, {
   3.483309667305493*^9, 3.483309670860605*^9}, {3.4833097094260592`*^9, 
   3.4833097143130865`*^9}, {3.4833097920148163`*^9, 3.4833097923553057`*^9}, 
   3.490048866160798*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"b", " ", "x"}], "]"}], " ", 
     RowBox[{"Si", "[", 
      RowBox[{"b", " ", "x"}], "]"}]}], 
    SuperscriptBox["x", "3"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.483309824461472*^9, 3.4833098244815006`*^9}, 
   3.4833098660212317`*^9, 3.490048866160798*^9}]
}, Closed]],

Cell["", "Text"],

Cell["\<\
Note that these systems give similar results to the above for the cosine \
integral, hyperbolic sine integral and hyperbolic cosine integral functions.\
\>", "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832040958843503`*^9, 3.4832041044566765`*^9}, 3.483204218670909*^9, 
   3.4833920379275217`*^9, {3.483392125182989*^9, 3.4833921454921923`*^9}, {
   3.48339221312945*^9, 3.483392219528651*^9}, {3.483392987983635*^9, 
   3.4833931408334227`*^9}, {3.4833932165322723`*^9, 3.483393223472251*^9}, {
   3.483395056508027*^9, 3.4833950705081587`*^9}, {3.4833959109166064`*^9, 
   3.483395925577688*^9}, {3.483395964633848*^9, 3.4833959819287167`*^9}, 
   3.490233013888317*^9}],

Cell["", "PageBreak",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 PageBreakBelow->True,
 CellChangeTimes->{3.4561670329935665`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Integral Function Integration Problem 4", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, {3.4821973084456434`*^9, 3.482197309066536*^9}, {
   3.4821982364300194`*^9, 3.482198240976557*^9}, 3.482198357524144*^9, {
   3.4821988021534896`*^9, 3.4821988078316545`*^9}, 3.4821989164378223`*^9, {
   3.482198948964594*^9, 3.4821990020909853`*^9}, 3.482199864941704*^9, {
   3.482716663183403*^9, 3.4827166643250446`*^9}, 3.4832286567052784`*^9, {
   3.4833957250293136`*^9, 3.483395725660221*^9}, {3.489967375357195*^9, 
   3.4899673755443954`*^9}, 3.4900556822056537`*^9, 3.4900560852697077`*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"CosIntegral", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", "x"}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
   3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
   3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.4821994592383313`*^9, 
   3.490383445573782*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " result is in terms of trig integral functions:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.45533208641339*^9, 3.455332109807029*^9}, 3.482199791185648*^9, 
   3.482646313174658*^9, 3.490048879895584*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"CosIntegral", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}]}], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4553246789720125`*^9, {3.4553317886151776`*^9, 3.4553318062905936`*^9}, {
   3.4553318574741917`*^9, 3.455331867168131*^9}, 3.490048879895584*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], " ", 
     RowBox[{"CosIntegral", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}], "d"]}], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"c", "-", 
      FractionBox[
       RowBox[{"a", " ", "d"}], "b"]}], "]"}], " ", 
    RowBox[{"CosIntegral", "[", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "-", "d"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}]}], "b"], "]"}]}], 
   RowBox[{"2", " ", "d"}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"c", "-", 
      FractionBox[
       RowBox[{"a", " ", "d"}], "b"]}], "]"}], " ", 
    RowBox[{"CosIntegral", "[", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "+", "d"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}]}], "b"], "]"}]}], 
   RowBox[{"2", " ", "d"}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"c", "-", 
      FractionBox[
       RowBox[{"a", " ", "d"}], "b"]}], "]"}], " ", 
    RowBox[{"SinIntegral", "[", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "-", "d"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}]}], "b"], "]"}]}], 
   RowBox[{"2", " ", "d"}]], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"c", "-", 
      FractionBox[
       RowBox[{"a", " ", "d"}], "b"]}], "]"}], " ", 
    RowBox[{"SinIntegral", "[", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "+", "d"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}]}], "b"], "]"}]}], 
   RowBox[{"2", " ", "d"}]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.455331781344723*^9, 3.4553318068714285`*^9}, 
   3.490048879895584*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " result",
 StyleBox[" ",
  FontSlant->"Italic"],
 "is in terms of exponential integral functions:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500256179667`*^9}, {3.4466836176090527`*^9, 3.446683618790752*^9}, {
   3.4466878172878942`*^9, 3.4466878232364483`*^9}, {3.4466929005572767`*^9, 
   3.4466929190839167`*^9}, {3.446693492157957*^9, 3.4466935036945457`*^9}, {
   3.446694017403222*^9, 3.446694027738083*^9}, {3.446867089436309*^9, 
   3.423171765484375*^9}, {3.4553321208829556`*^9, 3.455332137526888*^9}, 
   3.4821993034242816`*^9, 3.482646351880314*^9, 3.4900488886520844`*^9, 
   3.490048942018137*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"CosIntegral", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", "x"}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.44669341032028*^9}, {3.4468670319035807`*^9, 3.423171765484375*^9}, 
   3.4553246873240223`*^9, 3.4553248399034204`*^9, {3.455331919032709*^9, 
   3.4553319496166863`*^9}, {3.4553319882422276`*^9, 3.455331990305194*^9}, {
   3.455332028570216*^9, 3.4553320464058623`*^9}, 3.4900488886520844`*^9, {
   3.490048925859213*^9, 3.4900489420191374`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], " ", 
     RowBox[{"CosIntegral", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}], "d"]}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{"c", "-", 
        FractionBox[
         RowBox[{"a", " ", "d"}], "b"]}], ")"}]}]], " ", 
    RowBox[{"ExpIntegralEi", "[", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{"b", "-", "d"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}]}], "b"]}], "]"}]}], 
   RowBox[{"4", " ", "d"}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", 
      RowBox[{"(", 
       RowBox[{"c", "-", 
        FractionBox[
         RowBox[{"a", " ", "d"}], "b"]}], ")"}]}]], " ", 
    RowBox[{"ExpIntegralEi", "[", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{"b", "-", "d"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}]}], "b"], "]"}]}], 
   RowBox[{"4", " ", "d"}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", 
      RowBox[{"(", 
       RowBox[{"c", "-", 
        FractionBox[
         RowBox[{"a", " ", "d"}], "b"]}], ")"}]}]], " ", 
    RowBox[{"ExpIntegralEi", "[", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{"b", "+", "d"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}]}], "b"]}], "]"}]}], 
   RowBox[{"4", " ", "d"}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{"c", "-", 
        FractionBox[
         RowBox[{"a", " ", "d"}], "b"]}], ")"}]}]], " ", 
    RowBox[{"ExpIntegralEi", "[", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{"b", "+", "d"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}]}], "b"], "]"}]}], 
   RowBox[{"4", " ", "d"}]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.446693458840048*^9, 3.446693479820216*^9}, {
   3.446867077228755*^9, 3.423171765484375*^9}, 3.455324693893469*^9, {
   3.455331915287323*^9, 3.4553319516696386`*^9}, {3.4553320230522814`*^9, 
   3.455332032726192*^9}, 3.4900488886520844`*^9, {3.490048925859213*^9, 
   3.4900489420191374`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Maple",
  FontSlant->"Italic"],
 " result is in terms of trig integral functions:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500407697535`*^9}, {3.444350203233365*^9, 3.4443502040245028`*^9}, {
   3.444350234528365*^9, 3.4443502387243986`*^9}, {3.4466836227764835`*^9, 
   3.4466836230168285`*^9}, {3.4466839811618156`*^9, 3.4466839896239843`*^9}, 
   3.4466940377124257`*^9, {3.446694106040677*^9, 3.446694127681795*^9}, {
   3.446867106891408*^9, 3.423010833140625*^9}, 3.423171765484375*^9, 
   3.4553326995951023`*^9, 3.482199323713456*^9, 3.4826463942111826`*^9, 
   3.4900488886520844`*^9, 3.490048990360902*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Ci", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}], "*", "sin", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], ")"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{
  3.444350078924618*^9, {3.446688034289928*^9, 3.4466880406490717`*^9}, {
   3.4468671345411663`*^9, 3.423171765484375*^9}, {3.4553321841038623`*^9, 
   3.45533219499953*^9}, 3.4900488886520844`*^9, 3.490048990360902*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], " ", 
     RowBox[{"Ci", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}], "d"]}], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"c", "-", 
      FractionBox[
       RowBox[{"a", " ", "d"}], "b"]}], "]"}], " ", 
    RowBox[{"Ci", "[", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "-", "d"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}]}], "b"], "]"}]}], 
   RowBox[{"2", " ", "d"}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"c", "-", 
      FractionBox[
       RowBox[{"a", " ", "d"}], "b"]}], "]"}], " ", 
    RowBox[{"Ci", "[", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "+", "d"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}]}], "b"], "]"}]}], 
   RowBox[{"2", " ", "d"}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"c", "-", 
      FractionBox[
       RowBox[{"a", " ", "d"}], "b"]}], "]"}], " ", 
    RowBox[{"Si", "[", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "-", "d"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}]}], "b"], "]"}]}], 
   RowBox[{"2", " ", "d"}]], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"c", "-", 
      FractionBox[
       RowBox[{"a", " ", "d"}], "b"]}], "]"}], " ", 
    RowBox[{"Si", "[", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "+", "d"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}]}], "b"], "]"}]}], 
   RowBox[{"2", " ", "d"}]]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.4833100011555457`*^9, 3.48331001393392*^9}, 
   3.490048990360902*^9}]
}, Closed]],

Cell["", "Text"],

Cell["\<\
Note that these systems give similar results to the above for the sine \
integral function.\
\>", "Subsubtitle",
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832040958843503`*^9, 3.4832041044566765`*^9}, 3.483204218670909*^9, 
   3.4833920379275217`*^9, {3.483392125182989*^9, 3.4833921454921923`*^9}, {
   3.48339221312945*^9, 3.483392219528651*^9}, {3.483392987983635*^9, 
   3.4833931408334227`*^9}, {3.4833932165322723`*^9, 3.483393223472251*^9}, {
   3.483395056508027*^9, 3.4833950705081587`*^9}, {3.4833959109166064`*^9, 
   3.483395925577688*^9}, {3.483395964633848*^9, 3.4833959819287167`*^9}, {
   3.4833961127468243`*^9, 3.483396122781253*^9}, 3.490048900827781*^9, 
   3.4900489594451337`*^9, 3.4902330146215186`*^9}]
}, Open  ]]
},
AutoGeneratedPackage->None,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  None, None, None}},
PrintingOptions->{"FacingPages"->False,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->28.8},
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 1088, 16, 69, "Title"],
Cell[1658, 40, 964, 22, 68, "Subtitle"],
Cell[CellGroupData[{
Cell[2647, 66, 2617, 53, 31, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[5267, 121, 1011, 18, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[6281, 141, 1118, 31, 67, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[7402, 174, 1035, 19, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[8440, 195, 1401, 46, 69, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[9844, 243, 1063, 20, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[10910, 265, 2259, 73, 130, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Closed]],
Cell[CellGroupData[{
Cell[13206, 343, 2588, 53, 31, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[15797, 398, 982, 18, 87, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[16782, 418, 1096, 30, 67, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[17881, 450, 1022, 19, 87, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[18906, 471, 399, 11, 63, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[19308, 484, 1017, 19, 87, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[20328, 505, 427, 12, 63, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Closed]],
Cell[CellGroupData[{
Cell[20792, 522, 2630, 53, 31, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[23425, 577, 1083, 22, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[24511, 601, 844, 27, 67, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[25358, 630, 1147, 23, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[26508, 655, 1878, 58, 69, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[28389, 715, 1226, 25, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[29618, 742, 391, 11, 63, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}]
}, Closed]],
Cell[30024, 756, 141, 3, 4, "PageBreak",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[30202, 764, 1116, 17, 69, "Title"],
Cell[31321, 783, 1018, 23, 68, "Subtitle"],
Cell[CellGroupData[{
Cell[32364, 810, 2769, 54, 31, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[35136, 866, 1031, 18, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[36170, 886, 1075, 30, 67, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[37248, 918, 1087, 20, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[38338, 940, 1905, 63, 118, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[40246, 1005, 1137, 21, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[41386, 1028, 3201, 107, 123, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Closed]],
Cell[CellGroupData[{
Cell[44624, 1140, 2607, 53, 31, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[47234, 1195, 1006, 19, 87, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[48243, 1216, 1055, 28, 67, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[49301, 1246, 1042, 19, 87, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[50346, 1267, 421, 11, 63, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[50770, 1280, 1041, 20, 87, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[51814, 1302, 449, 12, 63, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Closed]],
Cell[CellGroupData[{
Cell[52300, 1319, 2654, 54, 31, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[54957, 1375, 1133, 23, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[56093, 1400, 783, 25, 74, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[56879, 1427, 1199, 24, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[58081, 1453, 1819, 63, 69, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[59903, 1518, 1274, 25, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[61180, 1545, 391, 11, 63, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}]
}, Closed]],
Cell[61586, 1559, 16, 0, 26, "Text"],
Cell[61605, 1561, 1844, 26, 28, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[63452, 1589, 141, 3, 4, "PageBreak",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[63630, 1597, 1140, 17, 69, "Title"],
Cell[64773, 1616, 920, 21, 68, "Subtitle"],
Cell[CellGroupData[{
Cell[65718, 1641, 2461, 47, 31, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[68182, 1690, 975, 19, 87, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[69160, 1711, 1722, 53, 85, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[70885, 1766, 995, 18, 79, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[71883, 1786, 995, 32, 81, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[72881, 1820, 937, 18, 79, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[73821, 1840, 545, 16, 79, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[74369, 1858, 966, 19, 106, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[75338, 1879, 376, 10, 78, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[75717, 1891, 992, 20, 108, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[76712, 1913, 714, 21, 79, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[77429, 1936, 994, 20, 108, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[78426, 1958, 1407, 45, 81, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Closed]],
Cell[CellGroupData[{
Cell[79870, 2008, 2569, 49, 31, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[82442, 2059, 1022, 20, 105, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[83467, 2081, 1573, 43, 81, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[85043, 2126, 980, 18, 105, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[86026, 2146, 792, 23, 81, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[86821, 2171, 970, 18, 105, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[87794, 2191, 568, 17, 79, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[88365, 2210, 1015, 20, 108, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[89383, 2232, 401, 11, 79, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[89787, 2245, 1039, 21, 108, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[90829, 2268, 427, 12, 79, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[91259, 2282, 1039, 21, 108, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[92301, 2305, 427, 12, 79, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Closed]],
Cell[CellGroupData[{
Cell[92765, 2322, 2552, 49, 31, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[95320, 2373, 1035, 21, 79, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[96358, 2396, 1533, 51, 85, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[97894, 2449, 1059, 21, 79, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[98956, 2472, 991, 33, 81, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[99950, 2507, 1095, 21, 79, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[101048, 2530, 554, 17, 79, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[101605, 2549, 1181, 24, 79, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[102789, 2575, 419, 12, 79, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[103211, 2589, 1256, 25, 79, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[104470, 2616, 445, 13, 79, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[104918, 2631, 1260, 25, 79, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[106181, 2658, 469, 13, 79, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}]
}, Closed]],
Cell[106665, 2674, 16, 0, 26, "Text"],
Cell[106684, 2676, 1844, 26, 28, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[108531, 2704, 141, 3, 4, "PageBreak",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[108709, 2712, 1165, 17, 69, "Title"],
Cell[109877, 2731, 891, 22, 68, "Subtitle"],
Cell[CellGroupData[{
Cell[110793, 2757, 1250, 21, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[112046, 2780, 885, 18, 79, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[112934, 2800, 2136, 73, 96, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Closed]],
Cell[CellGroupData[{
Cell[115107, 2878, 1205, 23, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[116315, 2903, 1020, 20, 105, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[117338, 2925, 2872, 88, 105, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Closed]],
Cell[CellGroupData[{
Cell[120247, 3018, 1171, 20, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[121421, 3040, 648, 18, 79, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[122072, 3060, 2089, 73, 96, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}]
}, Closed]],
Cell[124176, 3136, 16, 0, 26, "Text"],
Cell[124195, 3138, 1831, 26, 28, "Subsubtitle"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
