(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    575181,      14963]
NotebookOptionsPosition[    552709,      14464]
NotebookOutlinePosition[    553818,      14503]
CellTagsIndexPosition[    553775,      14500]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976622401126223`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.497662072225127*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", "0"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"b", " ", 
     RowBox[{"Sin", "[", "z", "]"}]}]}], "=", 
   RowBox[{"2", " ", "a", " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"\[Pi]", " ", "a"}], 
         RowBox[{"4", " ", "b"}]]}], "+", 
       FractionBox["z", "2"]}], "]"}], "2"]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.497662667553373*^9, {3.4982405233131886`*^9, 3.498240529443197*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", "<", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.497662273761881*^9, 3.497662314743153*^9}, {
   3.4976627174890604`*^9, 3.4976627219194684`*^9}, {3.498240539593211*^9, 
   3.498240539593211*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", " ", "a"}], ")"}], "n"]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", 
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          RowBox[{"\[Pi]", " ", "a"}], 
          RowBox[{"4", " ", "b"}]]}], "+", 
        FractionBox["c", "2"], "+", 
        FractionBox[
         RowBox[{"d", " ", "x"}], "2"]}], "]"}], 
      RowBox[{"2", " ", "n"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.497662217242982*^9, 3.497662244168629*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "*", "a"}], ")"}], "^", "n"}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "m"}], "*", 
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "Pi"}], "*", 
            RowBox[{"a", "/", 
             RowBox[{"(", 
              RowBox[{"4", "*", "b"}], ")"}]}]}], "+", 
           RowBox[{"c", "/", "2"}], "+", 
           RowBox[{"d", "*", 
            RowBox[{"x", "/", "2"}]}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"2", "*", "n"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.4976620538794947`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["\<\
Derivation: Algebraic simplification and piecewise constant extraction\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, {3.497662620893691*^9, 3.497662652733347*^9}}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", "0"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"b", " ", 
     RowBox[{"Sin", "[", "z", "]"}]}]}], "=", 
   RowBox[{"2", " ", "a", " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"\[Pi]", " ", "a"}], 
         RowBox[{"4", " ", "b"}]]}], "+", 
       FractionBox["z", "2"]}], "]"}], "2"]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.4976625130975018`*^9, {3.497662579023217*^9, 3.4976625841556263`*^9}, {
   3.498240554503232*^9, 3.498240554503232*^9}}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", "0"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    FractionBox[
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", "z", "]"}]}]}]], 
     RowBox[{"Cos", "[", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"\[Pi]", " ", "a"}], 
         RowBox[{"4", " ", "b"}]]}], "+", 
       FractionBox["z", "2"]}], "]"}]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, {
   3.4976625130975018`*^9, 3.4976625346879396`*^9}, 3.497662595840047*^9, {
   3.498240558183237*^9, 3.498240558183237*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{
     RowBox[{"n", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.497662273761881*^9, 3.497662314743153*^9}, {
   3.49766243823297*^9, 3.4976624525849953`*^9}, {3.4982405631832438`*^9, 
   3.4982405631832438`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"2", " ", "a"}], ")"}], 
        RowBox[{"n", "-", 
         FractionBox["1", "2"]}]], " ", 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}], 
      RowBox[{"Cos", "[", 
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          RowBox[{"\[Pi]", " ", "a"}], 
          RowBox[{"4", " ", "b"}]]}], "+", 
        FractionBox["c", "2"], "+", 
        FractionBox[
         RowBox[{"d", " ", "x"}], "2"]}], "]"}]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", 
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          RowBox[{"\[Pi]", " ", "a"}], 
          RowBox[{"4", " ", "b"}]]}], "+", 
        FractionBox["c", "2"], "+", 
        FractionBox[
         RowBox[{"d", " ", "x"}], "2"]}], "]"}], 
      RowBox[{"2", " ", "n"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, {
   3.4976623833052735`*^9, 3.4976624037569094`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "*", "a"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", 
         RowBox[{"1", "/", "2"}]}], ")"}]}], "*", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
       RowBox[{"Cos", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "Pi"}], "*", 
          RowBox[{"a", "/", 
           RowBox[{"(", 
            RowBox[{"4", "*", "b"}], ")"}]}]}], "+", 
         RowBox[{"c", "/", "2"}], "+", 
         RowBox[{"d", "*", 
          RowBox[{"x", "/", "2"}]}]}], "]"}]}]}], ",", "\n", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "m"}], "*", 
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "Pi"}], "*", 
            RowBox[{"a", "/", 
             RowBox[{"(", 
              RowBox[{"4", "*", "b"}], ")"}]}]}], "+", 
           RowBox[{"c", "/", "2"}], "+", 
           RowBox[{"d", "*", 
            RowBox[{"x", "/", "2"}]}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"2", "*", "n"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"n", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976620452370796`*^9, 3.497662356878827*^9, {
   3.497662464394216*^9, 3.497662468965024*^9}, {3.497844840747451*^9, 
   3.4978448419874525`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, {3.497662620893691*^9, 3.497662652733347*^9}, 
   3.497662905609791*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "z"}]}], ")"}], "2"]], "=", 
   RowBox[{
    FractionBox["a", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "z"}]}], ")"}]}]], "-", 
    FractionBox[
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{"a", " ", "z"}]}], ")"}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "z"}]}], ")"}], "2"]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.4976625130975018`*^9, {3.497662579023217*^9, 3.4976625841556263`*^9}, {
   3.497662923331422*^9, 3.497662936139045*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.497662273761881*^9, 3.497662314743153*^9}, {
   3.49766243823297*^9, 3.4976624525849953`*^9}, {3.4976629473554645`*^9, 
   3.49766295624748*^9}, {3.4982405753732615`*^9, 3.4982405793132668`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["x", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "2"]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["a", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"]}]]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox["x", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["b", 
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"x", " ", 
       RowBox[{"(", 
        RowBox[{"b", "+", 
         RowBox[{"a", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "2"]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, {
   3.4976623833052735`*^9, 3.4976624037569094`*^9}, {3.497663070736081*^9, 
   3.4976631028721375`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "2"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "-", 
         RowBox[{"b", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"x", "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "-", 
         RowBox[{"b", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"x", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"a", "*", 
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"Sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "2"}]}]}], 
        ",", "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976620452370796`*^9, 3.497662356878827*^9, {
   3.497662464394216*^9, 3.497662468965024*^9}, 3.497662899853381*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, {3.497662620893691*^9, 3.497662652733347*^9}, 
   3.497662905609791*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"b", " ", 
     RowBox[{"Sin", "[", "z", "]"}]}]}], "=", 
   FractionBox[
    RowBox[{
     RowBox[{"\[ImaginaryI]", " ", "b"}], "+", 
     RowBox[{"2", " ", "a", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "z"}]]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "b", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", "z"}]]}]}], 
    RowBox[{"2", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[ImaginaryI]", " ", "z"}]]}]]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.4976625130975018`*^9, {3.497662579023217*^9, 3.4976625841556263`*^9}, {
   3.497662923331422*^9, 3.497662936139045*^9}, 3.497663013827181*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"m", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", "<", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.497662273761881*^9, 3.497662314743153*^9}, {
   3.49766243823297*^9, 3.4976624525849953`*^9}, {3.4976629473554645`*^9, 
   3.49766295624748*^9}, {3.497663154773429*^9, 3.497663222165547*^9}, {
   3.498240592533285*^9, 3.498240592533285*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      SuperscriptBox["2", "n"]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", "m"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[ImaginaryI]", " ", "b"}], "+", 
          RowBox[{"2", " ", "a", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"\[ImaginaryI]", " ", "c"}], "+", 
             RowBox[{"\[ImaginaryI]", " ", "d", " ", "x"}]}]]}], "-", 
          RowBox[{"\[ImaginaryI]", " ", "b", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"\[ImaginaryI]", " ", "c"}], "+", 
               RowBox[{"\[ImaginaryI]", " ", "d", " ", "x"}]}], ")"}]}]]}]}], 
         ")"}], "n"]}], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"n", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[ImaginaryI]", " ", "c"}], "+", 
          RowBox[{"\[ImaginaryI]", " ", "d", " ", "x"}]}], ")"}]}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, {
   3.4976623833052735`*^9, 3.4976624037569094`*^9}, 3.4976631413262053`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"2", "^", "n"}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "m"}], "*", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"I", "*", "b"}], "+", 
            RowBox[{"2", "*", "a", "*", 
             RowBox[{"E", "^", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"I", "*", "c"}], "+", 
                RowBox[{"I", "*", "d", "*", "x"}]}], ")"}]}]}], "-", 
            RowBox[{"I", "*", "b", "*", 
             RowBox[{"E", "^", 
              RowBox[{"(", 
               RowBox[{"2", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"I", "*", "c"}], "+", 
                  RowBox[{"I", "*", "d", "*", "x"}]}], ")"}]}], ")"}]}]}]}], 
           ")"}], "^", "n"}], "/", 
         RowBox[{"E", "^", 
          RowBox[{"(", 
           RowBox[{"n", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"I", "*", "c"}], "+", 
              RowBox[{"I", "*", "d", "*", "x"}]}], ")"}]}], ")"}]}]}]}], ",", 
       "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976620452370796`*^9, 3.497662356878827*^9, {
   3.497662464394216*^9, 3.497662468965024*^9}, 3.497662899853381*^9, 
   3.497662998897955*^9, {3.4976631971431026`*^9, 3.4976631991087065`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976622401126223`*^9, 3.4979216299710093`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.497662072225127*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", "0"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"b", " ", 
     RowBox[{"Cos", "[", "z", "]"}]}]}], "=", 
   RowBox[{"2", " ", "a", " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "4"]}], " ", "\[Pi]", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          FractionBox["a", "b"]}], ")"}]}], "+", 
       FractionBox["z", "2"]}], "]"}], "2"]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.497662667553373*^9, {3.4979216146361823`*^9, 3.4979216448534355`*^9}, {
   3.4979279638121567`*^9, 3.497927983762184*^9}, {3.4982415086845675`*^9, 
   3.4982415086845675`*^9}}],

Cell["\<\
Note: This rule unifies the following two rules, but superficially appears \
more complicated.\
\>", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.497662072225127*^9, {3.4979280063010197`*^9, 
   3.4979280173458385`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", "<", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.497662273761881*^9, 3.497662314743153*^9}, {
   3.4976627174890604`*^9, 3.4976627219194684`*^9}, {3.4982415137045746`*^9, 
   3.4982415137045746`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", " ", "a"}], ")"}], "n"]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", 
       RowBox[{
        RowBox[{
         FractionBox["1", "4"], " ", 
         RowBox[{"(", 
          RowBox[{"-", "\[Pi]"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox["a", "b"]}], ")"}]}], "+", 
        FractionBox["c", "2"], "+", 
        FractionBox[
         RowBox[{"d", " ", "x"}], "2"]}], "]"}], 
      RowBox[{"2", " ", "n"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.497662217242982*^9, 3.497662244168629*^9}, {
   3.4979216146361823`*^9, 3.4979216448534355`*^9}, 3.4979280562211075`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x_", "^", "m_."}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], 
     ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "*", "a"}], ")"}], "^", "n"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Cos", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"-", "Pi"}], "/", "4"}], "*", 
             RowBox[{"(", 
              RowBox[{"1", "-", 
               RowBox[{"a", "/", "b"}]}], ")"}]}], "+", 
            RowBox[{"c", "/", "2"}], "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "/", "2"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"2", "*", "n"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}],
      " ", "&&", " ", 
     RowBox[{"ZeroQ", "[", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "-", 
       RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
     RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
     RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
     RowBox[{"n", "<", "0"}]}]}]}], " ", "*)"}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.4976620538794947`*^9, {
   3.4979216146361823`*^9, 3.4979216448534355`*^9}, 3.497927925752103*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.497662072225127*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"Cos", "[", "z", "]"}]}], "=", 
   RowBox[{"2", " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", 
      FractionBox["z", "2"], "]"}], "2"]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.497662667553373*^9, {3.4979216146361823`*^9, 3.4979216448534355`*^9}, {
   3.4979279638121567`*^9, 3.497927983762184*^9}, {3.4979281528008766`*^9, 
   3.4979281663573003`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "-", "b"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", "<", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.497662273761881*^9, 3.497662314743153*^9}, {
   3.4976627174890604`*^9, 3.4976627219194684`*^9}, {3.4979281972297544`*^9, 
   3.4979281999909596`*^9}, {3.4979283710608597`*^9, 3.497928375538068*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", " ", "a"}], ")"}], "n"]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", 
       RowBox[{
        FractionBox["c", "2"], "+", 
        FractionBox[
         RowBox[{"d", " ", "x"}], "2"]}], "]"}], 
      RowBox[{"2", " ", "n"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.497662217242982*^9, 3.497662244168629*^9}, {
   3.4979216146361823`*^9, 3.4979216448534355`*^9}, 3.4979280562211075`*^9, 
   3.497928234825821*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "*", "a"}], ")"}], "^", "n"}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "m"}], "*", 
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{"c", "/", "2"}], "+", 
           RowBox[{"d", "*", 
            RowBox[{"x", "/", "2"}]}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"2", "*", "n"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"a", "-", "b"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.4976620538794947`*^9, {
   3.4979216146361823`*^9, 3.4979216448534355`*^9}, 3.497927925752103*^9, 
   3.497928134611245*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.497662072225127*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"1", "-", 
    RowBox[{"Cos", "[", "z", "]"}]}], "=", 
   RowBox[{"2", " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      FractionBox["z", "2"], "]"}], "2"]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.497662667553373*^9, {3.4979216146361823`*^9, 3.4979216448534355`*^9}, {
   3.4979279638121567`*^9, 3.497927983762184*^9}, {3.4979281528008766`*^9, 
   3.4979281663573003`*^9}, {3.4979283066171465`*^9, 3.4979283096903524`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", "b"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", "<", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.497662273761881*^9, 3.497662314743153*^9}, {
   3.4976627174890604`*^9, 3.4976627219194684`*^9}, {3.4979281972297544`*^9, 
   3.4979281999909596`*^9}, 3.4979282874291134`*^9, {3.497928355351632*^9, 
   3.4979283602812414`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", " ", "a"}], ")"}], "n"]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{
        FractionBox["c", "2"], "+", 
        FractionBox[
         RowBox[{"d", " ", "x"}], "2"]}], "]"}], 
      RowBox[{"2", " ", "n"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.497662217242982*^9, 3.497662244168629*^9}, {
   3.4979216146361823`*^9, 3.4979216448534355`*^9}, 3.4979280562211075`*^9, 
   3.497928234825821*^9, 3.4979283422632093`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "*", "a"}], ")"}], "^", "n"}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "m"}], "*", 
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"c", "/", "2"}], "+", 
           RowBox[{"d", "*", 
            RowBox[{"x", "/", "2"}]}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"2", "*", "n"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"a", "+", "b"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.4976620538794947`*^9, {
   3.4979216146361823`*^9, 3.4979216448534355`*^9}, 3.497927925752103*^9, 
   3.497928134611245*^9, 3.4979282680382795`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["\<\
Derivation: Algebraic simplification and piecewise constant extraction\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, {3.497662620893691*^9, 3.497662652733347*^9}}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", "0"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"b", " ", 
     RowBox[{"Cos", "[", "z", "]"}]}]}], "=", 
   RowBox[{"2", " ", "a", " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", 
      RowBox[{
       FractionBox["z", "2"], "-", 
       RowBox[{
        FractionBox["1", "4"], " ", "\[Pi]", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          FractionBox["a", "b"]}], ")"}]}]}], "]"}], "2"]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.4976625130975018`*^9, {3.497662579023217*^9, 3.4976625841556263`*^9}, {
   3.4979216146517825`*^9, 3.4979216448534355`*^9}, {3.4979284733034396`*^9, 
   3.4979284733034396`*^9}, {3.4982415690346527`*^9, 3.4982415690346527`*^9}}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", "0"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    FractionBox[
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Cos", "[", "z", "]"}]}]}]], 
     RowBox[{"Cos", "[", 
      RowBox[{
       FractionBox["z", "2"], "-", 
       RowBox[{
        FractionBox["1", "4"], " ", "\[Pi]", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          FractionBox["a", "b"]}], ")"}]}]}], "]"}]]}], "\[Equal]", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, {
   3.4976625130975018`*^9, 3.4976625346879396`*^9}, 3.497662595840047*^9, {
   3.4979216146517825`*^9, 3.4979216448534355`*^9}, {3.497928515033513*^9, 
   3.497928515033513*^9}, {3.498241570884655*^9, 3.498241570884655*^9}}],

Cell["\<\
Note: This rule unifies the following two rules, but superficially appears \
more complicated.\
\>", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.497662072225127*^9, {3.4979280063010197`*^9, 
   3.4979280173458385`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{
     RowBox[{"n", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.497662273761881*^9, 3.497662314743153*^9}, {
   3.49766243823297*^9, 3.4976624525849953`*^9}, {3.4982415751246605`*^9, 
   3.4982415751246605`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"2", " ", "a"}], ")"}], 
        RowBox[{"n", "-", 
         FractionBox["1", "2"]}]], " ", 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}], 
      RowBox[{"Cos", "[", 
       RowBox[{
        RowBox[{
         FractionBox["1", "4"], " ", 
         RowBox[{"(", 
          RowBox[{"-", "\[Pi]"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox["a", "b"]}], ")"}]}], "+", 
        FractionBox["c", "2"], "+", 
        FractionBox[
         RowBox[{"d", " ", "x"}], "2"]}], "]"}]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", 
       RowBox[{
        RowBox[{
         FractionBox["1", "4"], " ", 
         RowBox[{"(", 
          RowBox[{"-", "\[Pi]"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox["a", "b"]}], ")"}]}], "+", 
        FractionBox["c", "2"], "+", 
        FractionBox[
         RowBox[{"d", " ", "x"}], "2"]}], "]"}], 
      RowBox[{"2", " ", "n"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, {
   3.4976623833052735`*^9, 3.4976624037569094`*^9}, {3.4979216146517825`*^9, 
   3.4979216448534355`*^9}, 3.4979287555703354`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x_", "^", "m_."}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], 
     ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", "*", "a"}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"n", "-", 
          RowBox[{"1", "/", "2"}]}], ")"}]}], "*", 
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Cos", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
        RowBox[{"Cos", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"-", "Pi"}], "/", "4"}], "*", 
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"a", "/", "b"}]}], ")"}]}], "+", 
          RowBox[{"c", "/", "2"}], "+", 
          RowBox[{"d", "*", 
           RowBox[{"x", "/", "2"}]}]}], "]"}]}]}], ",", "\n", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Cos", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"-", "Pi"}], "/", "4"}], "*", 
             RowBox[{"(", 
              RowBox[{"1", "-", 
               RowBox[{"a", "/", "b"}]}], ")"}]}], "+", 
            RowBox[{"c", "/", "2"}], "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "/", "2"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"2", "*", "n"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}],
      " ", "&&", " ", 
     RowBox[{"ZeroQ", "[", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "-", 
       RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
     RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
     RowBox[{"IntegerQ", "[", 
      RowBox[{"n", "-", 
       RowBox[{"1", "/", "2"}]}], "]"}]}]}]}], " ", "*)"}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976620452370796`*^9, 3.497662356878827*^9, {
   3.497662464394216*^9, 3.497662468965024*^9}, {3.497844840747451*^9, 
   3.4978448419874525`*^9}, {3.4979216146673827`*^9, 
   3.4979216448690357`*^9}, {3.497928561240794*^9, 3.4979285693528085`*^9}, 
   3.4982415970446916`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.497662072225127*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"Cos", "[", "z", "]"}]}], "=", 
   RowBox[{"2", " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", 
      FractionBox["z", "2"], "]"}], "2"]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.497662667553373*^9, {3.4979216146361823`*^9, 3.4979216448534355`*^9}, {
   3.4979279638121567`*^9, 3.497927983762184*^9}, {3.4979281528008766`*^9, 
   3.4979281663573003`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    FractionBox[
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"a", " ", 
        RowBox[{"Cos", "[", "z", "]"}]}]}]], 
     RowBox[{"Cos", "[", 
      FractionBox["z", "2"], "]"}]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.497662667553373*^9, {3.4979216146361823`*^9, 3.4979216448534355`*^9}, {
   3.4979279638121567`*^9, 3.497927983762184*^9}, {3.4979281528008766`*^9, 
   3.4979281663573003`*^9}, 3.4979286748245935`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "-", "b"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{
     RowBox[{"n", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.497662273761881*^9, 3.497662314743153*^9}, {
   3.4976627174890604`*^9, 3.4976627219194684`*^9}, {3.4979281972297544`*^9, 
   3.4979281999909596`*^9}, {3.4979283710608597`*^9, 3.497928375538068*^9}, {
   3.497928704776646*^9, 3.4979287078810515`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"2", " ", "a"}], ")"}], 
        RowBox[{"n", "-", 
         FractionBox["1", "2"]}]], " ", 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}], 
      RowBox[{"Cos", "[", 
       RowBox[{
        FractionBox["c", "2"], "+", 
        FractionBox[
         RowBox[{"d", " ", "x"}], "2"]}], "]"}]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", 
       RowBox[{
        FractionBox["c", "2"], "+", 
        FractionBox[
         RowBox[{"d", " ", "x"}], "2"]}], "]"}], 
      RowBox[{"2", " ", "n"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.497662217242982*^9, 3.497662244168629*^9}, {
   3.4979216146361823`*^9, 3.4979216448534355`*^9}, 3.4979280562211075`*^9, 
   3.497928234825821*^9, 3.497928825302458*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "*", "a"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", 
         RowBox[{"1", "/", "2"}]}], ")"}]}], "*", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
       RowBox[{"Cos", "[", 
        RowBox[{
         RowBox[{"c", "/", "2"}], "+", 
         RowBox[{"d", "*", 
          RowBox[{"x", "/", "2"}]}]}], "]"}]}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "m"}], "*", 
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{"c", "/", "2"}], "+", 
           RowBox[{"d", "*", 
            RowBox[{"x", "/", "2"}]}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"2", "*", "n"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"a", "-", "b"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"n", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.4976620538794947`*^9, {
   3.4979216146361823`*^9, 3.4979216448534355`*^9}, 3.497927925752103*^9, 
   3.497928134611245*^9, 3.497928643749339*^9, 3.4982416290347366`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.497662072225127*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"1", "-", 
    RowBox[{"Cos", "[", "z", "]"}]}], "=", 
   RowBox[{"2", " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      FractionBox["z", "2"], "]"}], "2"]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.497662667553373*^9, {3.4979216146361823`*^9, 3.4979216448534355`*^9}, {
   3.4979279638121567`*^9, 3.497927983762184*^9}, {3.4979281528008766`*^9, 
   3.4979281663573003`*^9}, 3.4979288984821863`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    FractionBox[
     SqrtBox[
      RowBox[{"a", "-", 
       RowBox[{"a", " ", 
        RowBox[{"Cos", "[", "z", "]"}]}]}]], 
     RowBox[{"Sin", "[", 
      FractionBox["z", "2"], "]"}]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.497662667553373*^9, {3.4979216146361823`*^9, 3.4979216448534355`*^9}, {
   3.4979279638121567`*^9, 3.497927983762184*^9}, {3.4979281528008766`*^9, 
   3.4979281663573003`*^9}, 3.4979286748245935`*^9, 3.4979289148466153`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", "b"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{
     RowBox[{"n", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.497662273761881*^9, 3.497662314743153*^9}, {
   3.4976627174890604`*^9, 3.4976627219194684`*^9}, {3.4979281972297544`*^9, 
   3.4979281999909596`*^9}, {3.4979283710608597`*^9, 3.497928375538068*^9}, {
   3.497928704776646*^9, 3.4979287078810515`*^9}, {3.4979289196514235`*^9, 
   3.4979289199478245`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"2", " ", "a"}], ")"}], 
        RowBox[{"n", "-", 
         FractionBox["1", "2"]}]], " ", 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}], 
      RowBox[{"Sin", "[", 
       RowBox[{
        FractionBox["c", "2"], "+", 
        FractionBox[
         RowBox[{"d", " ", "x"}], "2"]}], "]"}]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{
        FractionBox["c", "2"], "+", 
        FractionBox[
         RowBox[{"d", " ", "x"}], "2"]}], "]"}], 
      RowBox[{"2", " ", "n"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.497662217242982*^9, 3.497662244168629*^9}, {
   3.4979216146361823`*^9, 3.4979216448534355`*^9}, 3.4979280562211075`*^9, 
   3.497928234825821*^9, 3.497928825302458*^9, 3.4979289563270884`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "*", "a"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", 
         RowBox[{"1", "/", "2"}]}], ")"}]}], "*", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
       RowBox[{"Sin", "[", 
        RowBox[{
         RowBox[{"c", "/", "2"}], "+", 
         RowBox[{"d", "*", 
          RowBox[{"x", "/", "2"}]}]}], "]"}]}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "m"}], "*", 
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"c", "/", "2"}], "+", 
           RowBox[{"d", "*", 
            RowBox[{"x", "/", "2"}]}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"2", "*", "n"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"a", "+", "b"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"n", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.4976620538794947`*^9, {
   3.4979216146361823`*^9, 3.4979216448534355`*^9}, 3.497927925752103*^9, 
   3.497928134611245*^9, 3.497928643749339*^9, 3.497928879652953*^9, 
   3.498241633184742*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, {3.497662620893691*^9, 3.497662652733347*^9}, 
   3.497662905609791*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "z"}]}], ")"}], "2"]], "=", 
   RowBox[{
    FractionBox["a", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "z"}]}], ")"}]}]], "-", 
    FractionBox[
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{"a", " ", "z"}]}], ")"}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "z"}]}], ")"}], "2"]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.4976625130975018`*^9, {3.497662579023217*^9, 3.4976625841556263`*^9}, {
   3.497662923331422*^9, 3.497662936139045*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.497662273761881*^9, 3.497662314743153*^9}, {
   3.49766243823297*^9, 3.4976624525849953`*^9}, {3.4976629473554645`*^9, 
   3.49766295624748*^9}, {3.4982416592347784`*^9, 3.4982416592347784`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["x", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "2"]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["a", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"]}]]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox["x", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["b", 
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"x", " ", 
       RowBox[{"(", 
        RowBox[{"b", "+", 
         RowBox[{"a", " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "2"]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, {
   3.4976623833052735`*^9, 3.4976624037569094`*^9}, {3.497663070736081*^9, 
   3.4976631028721375`*^9}, {3.4979216300022097`*^9, 3.4979216300022097`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "2"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "-", 
         RowBox[{"b", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"x", "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Cos", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "-", 
         RowBox[{"b", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"x", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"a", "*", 
             RowBox[{"Cos", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"Cos", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "2"}]}]}], 
        ",", "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976620452370796`*^9, 3.497662356878827*^9, {
   3.497662464394216*^9, 3.497662468965024*^9}, 3.497662899853381*^9, {
   3.4979216300022097`*^9, 3.4979216300022097`*^9}, 3.4979289906939487`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, {3.497662620893691*^9, 3.497662652733347*^9}, 
   3.497662905609791*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"b", " ", 
     RowBox[{"Cos", "[", "z", "]"}]}]}], "=", 
   FractionBox[
    RowBox[{"b", "+", 
     RowBox[{"2", " ", "a", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "z"}]]}], "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", "z"}]]}]}], 
    RowBox[{"2", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[ImaginaryI]", " ", "z"}]]}]]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.4976625130975018`*^9, {3.497662579023217*^9, 3.4976625841556263`*^9}, {
   3.497662923331422*^9, 3.497662936139045*^9}, 3.497663013827181*^9, {
   3.49792163001781*^9, 3.49792163001781*^9}, {3.4979291056193504`*^9, 
   3.4979291056193504`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"m", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", "<", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.497662273761881*^9, 3.497662314743153*^9}, {
   3.49766243823297*^9, 3.4976624525849953`*^9}, {3.4976629473554645`*^9, 
   3.49766295624748*^9}, {3.497663154773429*^9, 3.497663222165547*^9}, {
   3.4979292038059225`*^9, 3.4979292475639997`*^9}, {3.4982416701947937`*^9, 
   3.4982416701947937`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      SuperscriptBox["2", "n"]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", "m"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"b", "+", 
          RowBox[{"2", " ", "a", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"\[ImaginaryI]", " ", "c"}], "+", 
             RowBox[{"\[ImaginaryI]", " ", "d", " ", "x"}]}]]}], "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"\[ImaginaryI]", " ", "c"}], "+", 
               RowBox[{"\[ImaginaryI]", " ", "d", " ", "x"}]}], ")"}]}]]}]}], 
         ")"}], "n"]}], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"n", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[ImaginaryI]", " ", "c"}], "+", 
          RowBox[{"\[ImaginaryI]", " ", "d", " ", "x"}]}], ")"}]}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, {
   3.4976623833052735`*^9, 3.4976624037569094`*^9}, 3.4976631413262053`*^9, 
   3.49792163001781*^9, 3.4979291310317945`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"2", "^", "n"}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "m"}], "*", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"2", "*", "a", "*", 
             RowBox[{"E", "^", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"I", "*", "c"}], "+", 
                RowBox[{"I", "*", "d", "*", "x"}]}], ")"}]}]}], "+", 
            RowBox[{"b", "*", 
             RowBox[{"E", "^", 
              RowBox[{"(", 
               RowBox[{"2", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"I", "*", "c"}], "+", 
                  RowBox[{"I", "*", "d", "*", "x"}]}], ")"}]}], ")"}]}]}]}], 
           ")"}], "^", "n"}], "/", 
         RowBox[{"E", "^", 
          RowBox[{"(", 
           RowBox[{"n", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"I", "*", "c"}], "+", 
              RowBox[{"I", "*", "d", "*", "x"}]}], ")"}]}], ")"}]}]}]}], ",", 
       "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976620452370796`*^9, 3.497662356878827*^9, {
   3.497662464394216*^9, 3.497662468965024*^9}, 3.497662899853381*^9, 
   3.497662998897955*^9, {3.4976631971431026`*^9, 3.4976631991087065`*^9}, 
   3.49792163001781*^9, 3.4979290679920845`*^9, {3.497929153324234*^9, 
   3.497929156023039*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978201697549086`*^9, 3.4978201707449093`*^9}, 
   3.4980702555322742`*^9, 3.498070723969897*^9, 3.4980719389556313`*^9, 
   3.4980726319200497`*^9, {3.4988884107361507`*^9, 3.498888431017311*^9}, 
   3.4988895614289665`*^9, 3.515695574987311*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.497676524239994*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sin", "[", "z", "]"}], "2"], "=", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"Cos", "[", 
       RowBox[{"2", " ", "z"}], "]"}]}], ")"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.497582725161008*^9, 3.497582728721012*^9}, 
   3.497582802891116*^9, 3.497676213204204*^9}],

Cell["\<\
Note: This rule should be replaced with rules that directly reduce the \
integrand rather than transforming it using trig power expansion!\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.497676524239994*^9, {
   3.5157017406219645`*^9, 3.515702053622402*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"a", "+", "b"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"n", "\[NotEqual]", 
    RowBox[{"-", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4976762514733925`*^9, 3.497676285304328*^9}, {
   3.4976766874213276`*^9, 3.497676700561079*^9}, {3.498889824763029*^9, 
   3.4988898331305075`*^9}, {3.515699219868435*^9, 3.5156992204884357`*^9}, {
   3.5157021049424744`*^9, 3.5157021680525627`*^9}, {3.5157026987153068`*^9, 
   3.5157026987153068`*^9}, {3.51570290099559*^9, 3.51570290099559*^9}, {
   3.5157031385159225`*^9, 3.515703141685927*^9}, {3.515703858778932*^9, 
   3.5157038673789444`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      SuperscriptBox["2", "n"]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "a"}], "+", "b", "-", 
        RowBox[{"b", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{"2", " ", "c"}], "+", 
           RowBox[{"2", " ", "d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.4976765781900797`*^9, 3.4976765810842457`*^9}, {
   3.497676622091591*^9, 3.497676634969328*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "2"}]}]}], ")"}], "^", 
     "n_"}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"2", "^", "n"}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "a"}], "+", "b", "-", 
          RowBox[{"b", "*", 
           RowBox[{"Cos", "[", 
            RowBox[{
             RowBox[{"2", "*", "c"}], "+", 
             RowBox[{"2", "*", "d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
        "n"}], ",", "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"a", "+", "b"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.497676050505898*^9, 
   3.4976765187576804`*^9, {3.497676670817378*^9, 3.4976766725164747`*^9}, {
   3.498241733094882*^9, 3.4982417375148883`*^9}, {3.4988898120363007`*^9, 
   3.4988898148264604`*^9}, {3.5156991993584065`*^9, 
   3.5156992031484118`*^9}, {3.515701568001723*^9, 3.515701588171751*^9}, 
   3.5157017257519436`*^9, 3.515702694475301*^9, 3.515702897155585*^9, {
   3.515703094495861*^9, 3.5157030969858646`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "2"}]}]}], ")"}], "^", 
     "n_"}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"2", "^", "n"}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "a"}], "+", "b", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Cos", "[", 
            RowBox[{
             RowBox[{"2", "*", "c"}], "+", 
             RowBox[{"2", "*", "d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
        "n"}], ",", "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"a", "+", "b"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.497676050505898*^9, 
   3.4976765187576804`*^9, {3.497676670817378*^9, 3.4976766725164747`*^9}, {
   3.4979216146829824`*^9, 3.4979216448690357`*^9}, 3.4979823318357525`*^9, {
   3.497982405249481*^9, 3.4979824071682844`*^9}, {3.4982417232448683`*^9, 
   3.4982417291148767`*^9}, {3.4991156324239902`*^9, 3.499115634963994*^9}, 
   3.51569920901842*^9, 3.5157015949717607`*^9, 3.5157017271219454`*^9, 
   3.515702695965303*^9, 3.515702898895587*^9, 3.515703103645874*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.497676151127653*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sin", "[", "z", "]"}], "2"], "=", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"Cos", "[", 
       RowBox[{"2", " ", "z"}], "]"}]}], ")"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.497582725161008*^9, 3.497582728721012*^9}, 
   3.497582802891116*^9, 3.497676213204204*^9}],

Cell["\<\
Note: This rule should be replaced with rules that directly reduce the \
integrand rather than transforming it using trig power expansion!\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.497676524239994*^9, {
   3.5157017406219645`*^9, 3.515702053622402*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"a", "+", "b"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"m", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4976762514733925`*^9, 3.497676285304328*^9}, {
   3.4991161788247557`*^9, 3.4991161846547637`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      SuperscriptBox["2", "n"]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "a"}], "+", "b", "-", 
        RowBox[{"b", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{"2", " ", "c"}], "+", 
           RowBox[{"2", " ", "d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, 3.4976760887800875`*^9, 3.49767613463171*^9, {
   3.5157037495887794`*^9, 3.515703793948841*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "2"}]}]}], ")"}], "^", 
      "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"2", "^", "n"}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "m"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", "a"}], "+", "b", "-", 
           RowBox[{"b", "*", 
            RowBox[{"Cos", "[", 
             RowBox[{
              RowBox[{"2", "*", "c"}], "+", 
              RowBox[{"2", "*", "d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
         "n"}]}], ",", "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"a", "+", "b"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"m", ">", "0"}], " ", "&&", " ", 
       RowBox[{"n", "\[Equal]", 
        RowBox[{"-", "1"}]}]}], " ", "||", " ", 
      RowBox[{
       RowBox[{"m", "\[Equal]", "1"}], " ", "&&", " ", 
       RowBox[{"n", "\[Equal]", 
        RowBox[{"-", "2"}]}]}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.4976760612205105`*^9, {
   3.4991161724447465`*^9, 3.4991161752347507`*^9}, {3.5157038171888742`*^9, 
   3.5157038202888784`*^9}, {3.5157039231390224`*^9, 
   3.5157039613090754`*^9}, {3.5157043179195747`*^9, 
   3.5157043225595818`*^9}, {3.515704932430435*^9, 3.5157049740604935`*^9}, 
   3.5171906797970753`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"Cos", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "2"}]}]}], ")"}], "^", 
      "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"2", "^", "n"}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "m"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", "a"}], "+", "b", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Cos", "[", 
             RowBox[{
              RowBox[{"2", "*", "c"}], "+", 
              RowBox[{"2", "*", "d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
         "n"}]}], ",", "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"a", "+", "b"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"m", ">", "0"}], " ", "&&", " ", 
       RowBox[{"n", "\[Equal]", 
        RowBox[{"-", "1"}]}]}], " ", "||", " ", 
      RowBox[{
       RowBox[{"m", "\[Equal]", "1"}], " ", "&&", " ", 
       RowBox[{"n", "\[Equal]", 
        RowBox[{"-", "2"}]}]}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.4976760612205105`*^9, {
   3.4979216146673827`*^9, 3.4979216448690357`*^9}, 3.497982323006137*^9, {
   3.497982386981849*^9, 3.497982393877061*^9}, {3.499116123264678*^9, 
   3.4991161253346806`*^9}, {3.5157038432289104`*^9, 3.515703845608914*^9}, {
   3.51570392863903*^9, 3.5157039586090717`*^9}, {3.515704333809597*^9, 
   3.5157043374196024`*^9}, 3.515704986320511*^9, 3.5171906797970753`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978099162653446`*^9, 3.49780992018535*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Primitive rule", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["FresnelS", "\[Prime]",
     MultilineFunction->None], "[", "z", "]"}], "=", 
   RowBox[{"Sin", "[", 
    FractionBox[
     RowBox[{"\[Pi]", " ", 
      SuperscriptBox["z", "2"]}], "2"], "]"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"b", " ", 
     SuperscriptBox["x", "2"]}], "]"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SqrtBox[
       FractionBox["\[Pi]", "2"]], 
      SqrtBox["b"]]}]}], 
   RowBox[{"FresnelS", "[", 
    FractionBox[
     RowBox[{
      SqrtBox["b"], " ", "x"}], 
     SqrtBox[
      FractionBox["\[Pi]", "2"]]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"b_.", "*", 
      RowBox[{"x_", "^", "2"}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=", 
  "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"Pi", "/", "2"}], "]"}], "*", 
    RowBox[{
     RowBox[{"FresnelS", "[", 
      RowBox[{
       RowBox[{"Rt", "[", 
        RowBox[{"b", ",", "2"}], "]"}], "*", 
       RowBox[{"x", "/", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"Pi", "/", "2"}], "]"}]}]}], "]"}], "/", 
     RowBox[{"Rt", "[", 
      RowBox[{"b", ",", "2"}], "]"}]}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{"b", ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"b_.", "*", 
      RowBox[{"x_", "^", "2"}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=", 
  "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"Pi", "/", "2"}], "]"}], "*", 
    RowBox[{
     RowBox[{"FresnelC", "[", 
      RowBox[{
       RowBox[{"Rt", "[", 
        RowBox[{"b", ",", "2"}], "]"}], "*", 
       RowBox[{"x", "/", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"Pi", "/", "2"}], "]"}]}]}], "]"}], "/", 
     RowBox[{"Rt", "[", 
      RowBox[{"b", ",", "2"}], "]"}]}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{"b", ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.4979216300646095`*^9, 3.497982495152439*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.497810067935557*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"w", "+", "z"}], "]"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "w", "]"}], " ", 
     RowBox[{"Cos", "[", "z", "]"}]}], "+", 
    RowBox[{
     RowBox[{"Cos", "[", "w", "]"}], " ", 
     RowBox[{"Sin", "[", "z", "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, 3.4978100933655925`*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "2"]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"Sin", "[", "a", "]"}]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}], "]"}], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   RowBox[{"Cos", "[", "a", "]"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "2"]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"a_", "+", 
      RowBox[{"b_.", "*", 
       RowBox[{"x_", "^", "2"}]}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"Sin", "[", "a", "]"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"Cos", "[", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "2"}]}], "]"}], ",", "x"}], "]"}]}], "]"}], " ", 
    "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"Cos", "[", "a", "]"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "2"}]}], "]"}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"a_", "+", 
      RowBox[{"b_.", "*", 
       RowBox[{"x_", "^", "2"}]}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"Cos", "[", "a", "]"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"Cos", "[", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "2"}]}], "]"}], ",", "x"}], "]"}]}], "]"}], " ", 
    "-", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"Sin", "[", "a", "]"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "2"}]}], "]"}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, {3.4979216146829824`*^9, 
   3.497921644884636*^9}, 3.4979825028744526`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.497810067935557*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Sin", "[", "z", "]"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", "z"}]]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[ImaginaryI]", " ", "z"}]]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, 3.4978100933655925`*^9, 3.497810195205735*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"\[Not]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[Or]", 
     " ", 
     RowBox[{"n", "<", "0"}]}], ")"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9, {
   3.4978102518358145`*^9, 3.4978103941360135`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["\[ImaginaryI]", "2"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "a"}], " ", "\[ImaginaryI]"}], "-", 
        RowBox[{"b", " ", "\[ImaginaryI]", " ", 
         SuperscriptBox["x", "n"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["\[ImaginaryI]", "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"a", " ", "\[ImaginaryI]"}], "+", 
       RowBox[{"b", " ", "\[ImaginaryI]", " ", 
        SuperscriptBox["x", "n"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, {3.497810228295781*^9, 3.497810232715788*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"a_.", "+", 
      RowBox[{"b_.", "*", 
       RowBox[{"x_", "^", "n_"}]}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"I", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"E", "^", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "a"}], "*", "I"}], "-", 
           RowBox[{"b", "*", "I", "*", 
            RowBox[{"x", "^", "n"}]}]}], ")"}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"I", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"E", "^", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "*", "I"}], "+", 
           RowBox[{"b", "*", "I", "*", 
            RowBox[{"x", "^", "n"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"Not", "[", 
     RowBox[{"FractionOrNegativeQ", "[", "n", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978101813857155`*^9},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Cos", "[", "z", "]"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", "z"}]]}], "+", 
    RowBox[{
     FractionBox["1", "2"], 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[ImaginaryI]", " ", "z"}]]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, 3.4978100933655925`*^9, 3.497810195205735*^9, {
   3.4979216300802097`*^9, 3.4979216300802097`*^9}, {3.4979826071450357`*^9, 
   3.4979826365198874`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"a_.", "+", 
      RowBox[{"b_.", "*", 
       RowBox[{"x_", "^", "n_"}]}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"E", "^", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "a"}], "*", "I"}], "-", 
           RowBox[{"b", "*", "I", "*", 
            RowBox[{"x", "^", "n"}]}]}], ")"}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"E", "^", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "*", "I"}], "+", 
           RowBox[{"b", "*", "I", "*", 
            RowBox[{"x", "^", "n"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"Not", "[", 
     RowBox[{"FractionOrNegativeQ", "[", "n", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978101813857155`*^9, 
   3.49792163009581*^9, 3.4979825117976685`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.497810067935557*^9, 
   3.497810452426095*^9}],

Cell["\<\
Note: Although resulting integrand looks more complicated than the original, \
rules for improper binomials rectify it.\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, 3.4978100933655925`*^9, 3.497810195205735*^9, {
   3.497810459466105*^9, 3.497810511846178*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[Or]", " ", 
   RowBox[{"n", "<", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9, {
   3.4978102518358145`*^9, 3.4978103941360135`*^9}, {3.4978105556962395`*^9, 
   3.4978105670162554`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "x"}]}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}]}]}], "-", 
  RowBox[{"b", " ", "n", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "n"], " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, {3.497810228295781*^9, 3.497810232715788*^9}, 
   3.497810535736212*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"a_.", "+", 
      RowBox[{"b_.", "*", 
       RowBox[{"x_", "^", "n_"}]}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"x", "^", "n"}]}]}], "]"}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", "n"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "n"}], "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "^", "n"}]}]}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978101813857155`*^9, 
   3.497810442686082*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"a_.", "+", 
      RowBox[{"b_.", "*", 
       RowBox[{"x_", "^", "n_"}]}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"x", "^", "n"}]}]}], "]"}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", "n"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "n"}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "^", "n"}]}]}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978101813857155`*^9, 
   3.497810442686082*^9, {3.4979216146985826`*^9, 3.497921644884636*^9}, 
   3.4979825181780796`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978099162653446`*^9, 3.49780992018535*^9}, 
   3.49781110611701*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Primitive rule", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["SinIntegral", "\[Prime]",
     MultilineFunction->None], "[", "z", "]"}], "=", 
   FractionBox[
    RowBox[{"Sin", "[", "z", "]"}], "z"]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, 3.497811178197111*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"Sin", "[", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}], "]"}], "x"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"SinIntegral", "[", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "]"}], "n"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, {3.497811202387145*^9, 3.497811226367179*^9}, {
   3.4978114144974422`*^9, 3.4978114162574444`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"b_.", "*", 
       RowBox[{"x_", "^", "n_."}]}], "]"}], "/", "x_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"SinIntegral", "[", 
     RowBox[{"b", "*", 
      RowBox[{"x", "^", "n"}]}], "]"}], "/", "n"}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"b", ",", "n"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497811159337085*^9, {3.4978114183274474`*^9, 3.4978114203574505`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"b_.", "*", 
       RowBox[{"x_", "^", "n_."}]}], "]"}], "/", "x_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"CosIntegral", "[", 
     RowBox[{"b", "*", 
      RowBox[{"x", "^", "n"}]}], "]"}], "/", "n"}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"b", ",", "n"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497811159337085*^9, {3.4978114183274474`*^9, 3.4978114203574505`*^9}, {
   3.4979216301270094`*^9, 3.4979216301270094`*^9}, 3.4979829847748995`*^9, {
   3.497983175906435*^9, 3.497983177825238*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.497810067935557*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"w", "+", "z"}], "]"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "w", "]"}], " ", 
     RowBox[{"Cos", "[", "z", "]"}]}], "+", 
    RowBox[{
     RowBox[{"Cos", "[", "w", "]"}], " ", 
     RowBox[{"Sin", "[", "z", "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, 3.4978100933655925`*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], "]"}], "x"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"Sin", "[", "a", "]"}]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{"Cos", "[", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}], "]"}], "x"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   RowBox[{"Cos", "[", "a", "]"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"Sin", "[", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "]"}], "x"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, 3.497811321977312*^9, {3.4978113726473837`*^9, 
   3.4978113760773883`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], "]"}], "/", "x_"}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"Sin", "[", "a", "]"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"b", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}], "/", "x"}], ",", "x"}], "]"}]}], 
     "]"}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"Cos", "[", "a", "]"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"b", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}], "/", "x"}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978111332070484`*^9, 
   3.4978112789772525`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], "]"}], "/", "x_"}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"Cos", "[", "a", "]"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"b", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}], "/", "x"}], ",", "x"}], "]"}]}], 
     "]"}], " ", "-", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"Sin", "[", "a", "]"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"b", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}], "/", "x"}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978111332070484`*^9, 
   3.4978112789772525`*^9, {3.4979216146985826`*^9, 3.4979216449002357`*^9}, 
   3.497982995180117*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: CRC 392, A&S 4.3.119", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.497810067935557*^9, 
   3.497811532897608*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.497810067935557*^9, 
   3.497810452426095*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}]}], "=", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["x", 
       RowBox[{"m", "-", "n", "+", "1"}]], " ", 
      RowBox[{
       SubscriptBox["\[PartialD]", "x"], 
       RowBox[{"Cos", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "n"]}]}], "]"}]}]}], 
     RowBox[{"b", " ", "n"}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, 3.4978100933655925`*^9, 3.497810195205735*^9, 
   3.497811560037646*^9, 3.497811810187996*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"0", "<", "n", "\[LessEqual]", "m"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9, {
   3.4978102518358145`*^9, 3.4978103941360135`*^9}, {3.4978119614426117`*^9, 
   3.4978119879026484`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    RowBox[{"Sin", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox["x", 
          RowBox[{"m", "-", "n", "+", "1"}]], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}]}], "]"}]}], 
        RowBox[{"b", " ", "n"}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"m", "-", "n", "+", "1"}], 
    RowBox[{"b", " ", "n"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "n"}]], " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, {3.497810228295781*^9, 3.497810232715788*^9}, {
   3.4978114755275273`*^9, 3.4978114885575457`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"m", "-", "n", "+", "1"}], ")"}]}]}], "*", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"x", "^", "n"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "n", "+", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", "n"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "n"}], ")"}]}], "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "^", "n"}]}]}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"0", "<", "n", "<=", "m"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978101813857155`*^9, 
   3.497811129647043*^9, 3.497811455437499*^9},
 Background->GrayLevel[0.85]],

Cell["Reference: CRC 396, A&S 4.3.123", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.497810067935557*^9, 
   3.497811532897608*^9, 3.4979832743894076`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "n", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"x", "^", "n"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "n", "+", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", "n"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "n"}], ")"}]}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "^", "n"}]}]}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"0", "<", "n", "<=", "m"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978101813857155`*^9, 
   3.497811129647043*^9, 3.497811455437499*^9, {3.497921614714183*^9, 
   3.4979216449158354`*^9}, 3.49798300226253*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: CRC 405, A&S 4.3.120", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.497810067935557*^9, 
   3.497810452426095*^9, 3.4978120457827296`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, 3.4978100933655925`*^9, 3.497810195205735*^9, {
   3.497810459466105*^9, 3.497810511846178*^9}, 3.4978120506627364`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "+", "n", "+", "1"}], "=", 
   RowBox[{"0", " ", "\[Or]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
      " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
          RowBox[{"m", "<", 
           RowBox[{"-", "1"}]}]}], ")"}], " ", "\[Or]", " ", 
        RowBox[{"0", "<", 
         RowBox[{"-", "n"}], "<", 
         RowBox[{"m", "+", "1"}]}]}], ")"}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9, {
   3.4978102518358145`*^9, 3.4978103941360135`*^9}, {3.4978105556962395`*^9, 
   3.4978105670162554`*^9}, {3.4978121595028887`*^9, 
   3.4978121713129053`*^9}, {3.497812202812949*^9, 3.497812241873004*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    RowBox[{"Sin", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", "n"]}]}], "]"}]}], 
       RowBox[{"m", "+", "1"}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"b", " ", "n"}], 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "n"}]], " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, {3.497810228295781*^9, 3.497810232715788*^9}, 
   3.497810535736212*^9, {3.497812078252775*^9, 3.497812093972797*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"x", "^", "n"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", 
       RowBox[{"n", "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "n"}], ")"}]}], "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "^", "n"}]}]}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"ZeroQ", "[", 
       RowBox[{"m", "+", "n", "+", "1"}], "]"}], " ", "||", " ", 
      RowBox[{
       RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
       RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"n", ">", "0"}], " ", "&&", " ", 
          RowBox[{"m", "<", 
           RowBox[{"-", "1"}]}]}], " ", "||", " ", 
         RowBox[{"0", "<", 
          RowBox[{"-", "n"}], "<", 
          RowBox[{"m", "+", "1"}]}]}], ")"}]}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978101813857155`*^9, 
   3.497810442686082*^9, 3.49781112699704*^9, 3.497812038232719*^9},
 Background->GrayLevel[0.85]],

Cell["Reference: CRC 406, A&S 4.3.124", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.497810067935557*^9, 
   3.497810452426095*^9, 3.4978120457827296`*^9, 3.497983283827424*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"x", "^", "n"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", 
       RowBox[{"n", "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "n"}], ")"}]}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "^", "n"}]}]}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"ZeroQ", "[", 
       RowBox[{"m", "+", "n", "+", "1"}], "]"}], " ", "||", " ", 
      RowBox[{
       RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
       RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"n", ">", "0"}], " ", "&&", " ", 
          RowBox[{"m", "<", 
           RowBox[{"-", "1"}]}]}], " ", "||", " ", 
         RowBox[{"0", "<", 
          RowBox[{"-", "n"}], "<", 
          RowBox[{"m", "+", "1"}]}]}], ")"}]}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978101813857155`*^9, 
   3.497810442686082*^9, 3.49781112699704*^9, 3.497812038232719*^9, {
   3.497921614714183*^9, 3.4979216449158354`*^9}, 3.497983126719548*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.497810067935557*^9, 
   3.497810452426095*^9, 3.4978120457827296`*^9, 3.497812291653074*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Sin", "[", "z", "]"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", "z"}]]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[ImaginaryI]", " ", "z"}]]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, 3.4978100933655925`*^9, 3.497810195205735*^9, 
   3.497811560037646*^9, 3.497811810187996*^9, 3.4978123204031143`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"m", "-", "n", "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", 
   " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[Or]", 
      " ", 
      RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[Or]", 
      " ", 
      RowBox[{"n", "<", "0"}]}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9, {
   3.4978102518358145`*^9, 3.4978103941360135`*^9}, {3.4978105556962395`*^9, 
   3.4978105670162554`*^9}, {3.4978121595028887`*^9, 
   3.4978121713129053`*^9}, {3.497812202812949*^9, 3.497812241873004*^9}, {
   3.4978123720231867`*^9, 3.4978124858333454`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    RowBox[{"Sin", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["\[ImaginaryI]", "2"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox["x", "m"], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "a"}], " ", "\[ImaginaryI]"}], "-", 
        RowBox[{"b", " ", "\[ImaginaryI]", " ", 
         SuperscriptBox["x", "n"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["\[ImaginaryI]", "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"a", " ", "\[ImaginaryI]"}], "+", 
       RowBox[{"b", " ", "\[ImaginaryI]", " ", 
        SuperscriptBox["x", "n"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, {3.497810228295781*^9, 3.497810232715788*^9}, 
   3.497810535736212*^9, {3.497812078252775*^9, 3.497812093972797*^9}, 
   3.4978123593031683`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"I", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{"E", "^", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "a"}], "*", "I"}], "-", 
            RowBox[{"b", "*", "I", "*", 
             RowBox[{"x", "^", "n"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "-", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"I", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{"E", "^", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"a", "*", "I"}], "+", 
            RowBox[{"b", "*", "I", "*", 
             RowBox[{"x", "^", "n"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "-", "n", "+", "1"}], "]"}], " ", "&&", " ", "\n", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"FractionQ", "[", "m", "]"}], " ", "||", " ", 
      RowBox[{"FractionOrNegativeQ", "[", "n", "]"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978101813857155`*^9, 
   3.497810442686082*^9, 3.49781112699704*^9, 3.497812038232719*^9, 
   3.4978123314331293`*^9, 3.4978449628776217`*^9},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Cos", "[", "z", "]"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", "z"}]]}], "+", 
    RowBox[{
     FractionBox["1", "2"], 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[ImaginaryI]", " ", "z"}]]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, 3.4978100933655925`*^9, 3.497810195205735*^9, 
   3.497811560037646*^9, 3.497811810187996*^9, 3.4978123204031143`*^9, {
   3.49792163015821*^9, 3.49792163015821*^9}, {3.4979835810547466`*^9, 
   3.4979835810547466`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{"E", "^", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "a"}], "*", "I"}], "-", 
            RowBox[{"b", "*", "I", "*", 
             RowBox[{"x", "^", "n"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{"E", "^", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"a", "*", "I"}], "+", 
            RowBox[{"b", "*", "I", "*", 
             RowBox[{"x", "^", "n"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "-", "n", "+", "1"}], "]"}], " ", "&&", " ", "\n", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"FractionQ", "[", "m", "]"}], " ", "||", " ", 
      RowBox[{"FractionOrNegativeQ", "[", "n", "]"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978101813857155`*^9, 
   3.497810442686082*^9, 3.49781112699704*^9, 3.497812038232719*^9, 
   3.4978123314331293`*^9, 3.4978449628776217`*^9, 3.49792163015821*^9, 
   3.497983137748768*^9, 3.497983659538484*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}], "p"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978099162653446`*^9, 3.49780992018535*^9}, 
   3.49781110611701*^9, 3.497812987564048*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, 3.4978130316141095`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", ",", 
   RowBox[{
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"p", ">", "1"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"n", "-", "1"}], "\[NotEqual]", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4978130900441914`*^9, 3.4978131572642856`*^9}, {
   3.497813348754554*^9, 3.49781336751458*^9}, {3.497814099895605*^9, 
   3.497814106035614*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], "]"}], "p"], 
     SuperscriptBox["x", "n"]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}]}], "]"}], "p"], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}], 
         SuperscriptBox["x", 
          RowBox[{"n", "-", "1"}]]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"b", " ", "n", " ", "p"}], 
    RowBox[{"n", "-", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], "]"}], 
      RowBox[{"p", "-", "1"}]], " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, {3.497811202387145*^9, 3.497811226367179*^9}, {
   3.4978114144974422`*^9, 3.4978114162574444`*^9}, {3.497813065384157*^9, 
   3.4978130749041705`*^9}, {3.4978133280245247`*^9, 
   3.4978133437345467`*^9}, {3.497813396744621*^9, 3.4978134492246943`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], "]"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", "p"}]}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}], "*", 
       RowBox[{"x", "^", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}]}], ")"}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", "n", "*", 
       RowBox[{"p", "/", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}]}], "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "^", "n"}]}]}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"n", ",", "p"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "1"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"n", "-", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497811159337085*^9, {3.4978114183274474`*^9, 3.4978114203574505`*^9}, 
   3.4978130235240984`*^9, {3.4978134985547633`*^9, 3.497813609294918*^9}, 
   3.5171907120579324`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], "]"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", "p"}]}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}], "*", 
       RowBox[{"x", "^", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}]}], ")"}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", "n", "*", 
       RowBox[{"p", "/", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Cos", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}]}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "^", "n"}]}]}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"n", ",", "p"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "1"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"n", "-", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497811159337085*^9, {3.4978114183274474`*^9, 3.4978114203574505`*^9}, 
   3.4978130235240984`*^9, {3.4978134985547633`*^9, 3.497813609294918*^9}, {
   3.497921614729783*^9, 3.4979216449314356`*^9}, 3.497984037433548*^9, 
   3.5171907120579324`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Reference: G&R 2.631.2' special case ",
 "when",
 " ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "-", 
    RowBox[{"2", "n"}], "+", "1"}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.497810067935557*^9, {
   3.497813680335018*^9, 3.497813696825041*^9}, 3.497814297695882*^9, {
   3.4978143293659267`*^9, 3.4978143308159285`*^9}, 3.498239516771779*^9, {
   3.4990388058462014`*^9, 3.4990388139270153`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"p", ">", "1"}], " ", "\[And]", " ", 
    RowBox[{"m", "-", 
     RowBox[{"2", "n"}], "+", "1"}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4978130900441914`*^9, 3.4978131572642856`*^9}, {
   3.497813348754554*^9, 3.49781336751458*^9}, {3.4978140642655554`*^9, 
   3.4978140956655993`*^9}, {3.4978144116260414`*^9, 
   3.4978144242060595`*^9}, {3.4990388217738295`*^9, 3.4990388217738295`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], "]"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"n", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}]}], "]"}], "p"]}], 
       RowBox[{
        SuperscriptBox["b", "2"], " ", 
        SuperscriptBox["n", "2"], " ", 
        SuperscriptBox["p", "2"]}]]}]}]}]}], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["x", "n"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], "]"}], 
     RowBox[{"p", "-", "1"}]]}], 
   RowBox[{"b", " ", "n", " ", "p"}]], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"p", "-", "1"}], "p"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], "]"}], 
      RowBox[{"p", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, 3.497811321977312*^9, {3.4978113726473837`*^9, 
   3.4978113760773883`*^9}, 3.497813732595091*^9, {3.4978138007251863`*^9, 
   3.4978138363652363`*^9}, {3.4978143913860135`*^9, 3.4978144039060307`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], "]"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"n", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", "p"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", 
        RowBox[{"n", "^", "2"}], "*", 
        RowBox[{"p", "^", "2"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{
     RowBox[{"x", "^", "n"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"x", "^", "n"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", "p"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}], "/", "p"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "1"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "-", 
      RowBox[{"2", "*", "n"}], "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978111332070484`*^9, 
   3.4978112789772525`*^9, 3.497812999004064*^9, 3.4978136658049974`*^9, {
   3.4978138617452717`*^9, 3.4978138643252754`*^9}},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Reference: G&R 2.631.3' special case with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "-", 
    RowBox[{"2", "n"}], "+", "1"}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.497810067935557*^9, {
   3.497813680335018*^9, 3.497813696825041*^9}, 3.497814297695882*^9, {
   3.4978143293659267`*^9, 3.4978143308159285`*^9}, {3.4979841931998215`*^9, 
   3.4979841936366224`*^9}, {3.4990389647480803`*^9, 3.4990389647480803`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], "]"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"n", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", "p"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", 
        RowBox[{"n", "^", "2"}], "*", 
        RowBox[{"p", "^", "2"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{
     RowBox[{"x", "^", "n"}], "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"x", "^", "n"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", "p"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}], "/", "p"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Cos", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "1"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "-", 
      RowBox[{"2", "*", "n"}], "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978111332070484`*^9, 
   3.4978112789772525`*^9, 3.497812999004064*^9, 3.4978136658049974`*^9, {
   3.4978138617452717`*^9, 3.4978138643252754`*^9}, {3.497921614745383*^9, 
   3.497921644947036*^9}, 3.497984114263683*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.631.2'", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.497810067935557*^9, 
   3.497811532897608*^9, 3.49781393901538*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"p", ">", "1"}], " ", "\[And]", " ", 
    RowBox[{"0", "<", 
     RowBox[{"2", "n"}], "<", 
     RowBox[{"m", "+", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9, {
   3.4978102518358145`*^9, 3.4978103941360135`*^9}, {3.4978119614426117`*^9, 
   3.4978119879026484`*^9}, {3.4978142081057568`*^9, 
   3.4978142300257874`*^9}, {3.4978148508166566`*^9, 3.49781485307666*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], "]"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "-", "n", "+", "1"}], ")"}], " ", 
        SuperscriptBox["x", 
         RowBox[{"m", "-", 
          RowBox[{"2", " ", "n"}], "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}]}], "]"}], "p"]}], 
       RowBox[{
        SuperscriptBox["b", "2"], " ", 
        SuperscriptBox["n", "2"], " ", 
        SuperscriptBox["p", "2"]}]]}]}]}]}], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["x", 
     RowBox[{"m", "-", "n", "+", "1"}]], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], "]"}], 
     RowBox[{"p", "-", "1"}]]}], 
   RowBox[{"b", " ", "n", " ", "p"}]], "+", "     ", "\[IndentingNewLine]", 
  "                                           ", 
  RowBox[{
   FractionBox[
    RowBox[{"p", "-", "1"}], "p"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], "]"}], 
      RowBox[{"p", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "-", "n", "+", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"m", "-", 
       RowBox[{"2", " ", "n"}], "+", "1"}], ")"}]}], 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["n", "2"], " ", 
     SuperscriptBox["p", "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", 
       RowBox[{"2", " ", "n"}]}]], " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], "]"}], "p"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, {3.497810228295781*^9, 3.497810232715788*^9}, {
   3.4978114755275273`*^9, 3.4978114885575457`*^9}, {3.4978139885554495`*^9, 
   3.49781400341547*^9}, 3.4978141842457237`*^9, {3.4978450113076897`*^9, 
   3.497845040857731*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], "]"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "-", "n", "+", "1"}], ")"}], "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", 
        RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", "p"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", 
        RowBox[{"n", "^", "2"}], "*", 
        RowBox[{"p", "^", "2"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "n", "+", "1"}], ")"}]}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"x", "^", "n"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", "p"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}], "/", "p"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "n", "+", "1"}], ")"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "-", 
          RowBox[{"2", "*", "n"}], "+", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "*", 
          RowBox[{"n", "^", "2"}], "*", 
          RowBox[{"p", "^", "2"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", 
            RowBox[{"2", "*", "n"}]}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "^", "p"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "1"}], " ", "&&", " ", 
    RowBox[{"0", "<", 
     RowBox[{"2", "*", "n"}], "<", 
     RowBox[{"m", "+", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978101813857155`*^9, 
   3.497811129647043*^9, 3.497811455437499*^9, 3.4978130018340683`*^9, 
   3.4978139290053663`*^9, 3.5171906797970753`*^9},
 Background->GrayLevel[0.85]],

Cell["Reference: G&R 2.631.3'", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.497810067935557*^9, 
   3.497811532897608*^9, 3.49781393901538*^9, {3.49798426068554*^9, 
   3.497984261184741*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], "]"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "-", "n", "+", "1"}], ")"}], "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", 
        RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", "p"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", 
        RowBox[{"n", "^", "2"}], "*", 
        RowBox[{"p", "^", "2"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "n", "+", "1"}], ")"}]}], "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"x", "^", "n"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", "p"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}], "/", "p"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Cos", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "n", "+", "1"}], ")"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "-", 
          RowBox[{"2", "*", "n"}], "+", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "*", 
          RowBox[{"n", "^", "2"}], "*", 
          RowBox[{"p", "^", "2"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", 
            RowBox[{"2", "*", "n"}]}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Cos", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "^", "p"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "1"}], " ", "&&", " ", 
    RowBox[{"0", "<", 
     RowBox[{"2", "*", "n"}], "<", 
     RowBox[{"m", "+", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978101813857155`*^9, 
   3.497811129647043*^9, 3.497811455437499*^9, 3.4978130018340683`*^9, 
   3.4978139290053663`*^9, {3.4979216147765827`*^9, 3.497921644962636*^9}, 
   3.4979841249029016`*^9, 3.5171906798126755`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Reference: G&R 2.643.1' special case ",
 "when",
 " ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "-", 
    RowBox[{"2", "n"}], "+", "1"}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.497810067935557*^9, 
   3.497810452426095*^9, 3.4978120457827296`*^9, 3.497814519586193*^9, 
   3.4978151296270466`*^9, {3.4978151984471436`*^9, 3.497815198947144*^9}, {
   3.497815245177209*^9, 3.4978152639572353`*^9}, 3.498239518301781*^9, {
   3.4990388321634474`*^9, 3.4990388321634474`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"p", "\[NotEqual]", 
     RowBox[{"-", "2"}]}], " ", "\[And]", " ", 
    RowBox[{"m", "-", 
     RowBox[{"2", "n"}], "+", "1"}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9, {
   3.4978102518358145`*^9, 3.4978103941360135`*^9}, {3.4978119614426117`*^9, 
   3.4978119879026484`*^9}, {3.4978142081057568`*^9, 
   3.4978142300257874`*^9}, {3.497814551106237*^9, 3.4978145682762613`*^9}, {
   3.4978146024663086`*^9, 3.4978146072663155`*^9}, {3.4990388354706535`*^9, 
   3.4990388354706535`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], "]"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                    ", "\[IndentingNewLine]", 
      "                           ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", "n"], " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", "n"]}]}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}]}], "]"}], 
         RowBox[{"p", "+", "1"}]]}], 
       RowBox[{"b", " ", "n", " ", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  FractionBox[
   RowBox[{"n", " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], "]"}], 
     RowBox[{"p", "+", "2"}]]}], 
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    SuperscriptBox["n", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"p", "+", "1"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"p", "+", "2"}], ")"}]}]], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"p", "+", "2"}], 
    RowBox[{"p", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], "]"}], 
      RowBox[{"p", "+", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, {3.497810228295781*^9, 3.497810232715788*^9}, 
   3.497810535736212*^9, {3.497812078252775*^9, 3.497812093972797*^9}, 
   3.497814621316335*^9, 3.497814652296379*^9, {3.4978450924378033`*^9, 
   3.4978451139778337`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], "]"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "n"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"x", "^", "n"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", " ", "\n", 
    "  ", 
    RowBox[{"n", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", 
        RowBox[{"n", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "2"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"p", "\[NotEqual]", 
     RowBox[{"-", "2"}]}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "-", 
      RowBox[{"2", "*", "n"}], "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978101813857155`*^9, 
   3.497810442686082*^9, 3.49781112699704*^9, 3.497812038232719*^9, 
   3.497813004784072*^9, 3.4978145150861864`*^9, {3.4990387195000496`*^9, 
   3.499038720732452*^9}},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Reference: G&R 2.643.2' special case with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "-", 
    RowBox[{"2", "n"}], "+", "1"}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.497810067935557*^9, 
   3.497810452426095*^9, 3.4978120457827296`*^9, 3.497814519586193*^9, 
   3.4978151296270466`*^9, {3.4978151984471436`*^9, 3.497815198947144*^9}, {
   3.497815245177209*^9, 3.4978152639572353`*^9}, {3.4979843469224916`*^9, 
   3.4979843472656918`*^9}, {3.4990389749348984`*^9, 3.4990389749348984`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], "]"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"x", "^", "n"}]}], "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"x", "^", "n"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", " ", "\n", 
    "  ", 
    RowBox[{"n", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", 
        RowBox[{"n", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "2"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Cos", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"p", "\[NotEqual]", 
     RowBox[{"-", "2"}]}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "-", 
      RowBox[{"2", "*", "n"}], "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978101813857155`*^9, 
   3.497810442686082*^9, 3.49781112699704*^9, 3.497812038232719*^9, 
   3.497813004784072*^9, 3.4978145150861864`*^9, {3.497921614792183*^9, 
   3.4979216449782357`*^9}, 3.497984133248916*^9, {3.499038912690789*^9, 
   3.4990389136735907`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.643.1'", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.497810067935557*^9, 
   3.497810452426095*^9, 3.4978120457827296`*^9, 3.497814519586193*^9, 
   3.4978147490865145`*^9, 3.497815269747243*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"p", "\[NotEqual]", 
     RowBox[{"-", "2"}]}], " ", "\[And]", " ", 
    RowBox[{"0", "<", 
     RowBox[{"2", "n"}], "<", 
     RowBox[{"m", "+", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9, {
   3.4978102518358145`*^9, 3.4978103941360135`*^9}, {3.4978119614426117`*^9, 
   3.4978119879026484`*^9}, {3.4978142081057568`*^9, 
   3.4978142300257874`*^9}, {3.497814551106237*^9, 3.4978145682762613`*^9}, {
   3.4978146024663086`*^9, 3.4978146072663155`*^9}, {3.497814842496645*^9, 
   3.4978148883467093`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], "]"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "-", "n", "+", "1"}]], " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", "n"]}]}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}]}], "]"}], 
         RowBox[{"p", "+", "1"}]]}], 
       RowBox[{"b", " ", "n", " ", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"m", "-", "n", "+", "1"}], ")"}], " ", 
    SuperscriptBox["x", 
     RowBox[{"m", "-", 
      RowBox[{"2", " ", "n"}], "+", "1"}]], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], "]"}], 
     RowBox[{"p", "+", "2"}]]}], 
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    SuperscriptBox["n", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"p", "+", "1"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"p", "+", "2"}], ")"}]}]], "+", "  ", "\[IndentingNewLine]", 
  "                                      ", 
  RowBox[{
   FractionBox[
    RowBox[{"p", "+", "2"}], 
    RowBox[{"p", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], "]"}], 
      RowBox[{"p", "+", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "-", "n", "+", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"m", "-", 
       RowBox[{"2", " ", "n"}], "+", "1"}], ")"}]}], 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["n", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"p", "+", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"p", "+", "2"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", 
       RowBox[{"2", " ", "n"}]}]], " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], "]"}], 
      RowBox[{"p", "+", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, {3.497810228295781*^9, 3.497810232715788*^9}, 
   3.497810535736212*^9, {3.497812078252775*^9, 3.497812093972797*^9}, 
   3.497814621316335*^9, 3.497814652296379*^9, {3.4978148058565936`*^9, 
   3.4978148214266157`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], "]"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "n", "+", "1"}], ")"}]}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"x", "^", "n"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "-", "n", "+", "1"}], ")"}], "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", 
        RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", 
        RowBox[{"n", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "2"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "n", "+", "1"}], ")"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "-", 
          RowBox[{"2", "*", "n"}], "+", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "*", 
          RowBox[{"n", "^", "2"}], "*", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{"p", "+", "2"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", 
            RowBox[{"2", "*", "n"}]}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"p", "\[NotEqual]", 
     RowBox[{"-", "2"}]}], " ", "&&", " ", 
    RowBox[{"0", "<", 
     RowBox[{"2", "*", "n"}], "<", 
     RowBox[{"m", "+", "1", " "}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978101813857155`*^9, 
   3.497810442686082*^9, 3.49781112699704*^9, 3.497812038232719*^9, 
   3.497813004784072*^9, 3.4978145150861864`*^9, 3.497814742666505*^9, {
   3.4990387261924615`*^9, 3.499038727643264*^9}, 3.5171906798126755`*^9},
 Background->GrayLevel[0.85]],

Cell["Reference: G&R 2.643.2", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.497810067935557*^9, 
   3.497810452426095*^9, 3.4978120457827296`*^9, 3.497814519586193*^9, 
   3.4978147490865145`*^9, 3.497815269747243*^9, {3.4979844049389935`*^9, 
   3.4979844059685955`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], "]"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"m", "-", "n", "+", "1"}], ")"}]}]}], "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"x", "^", "n"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "-", "n", "+", "1"}], ")"}], "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", 
        RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", 
        RowBox[{"n", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "2"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Cos", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "n", "+", "1"}], ")"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "-", 
          RowBox[{"2", "*", "n"}], "+", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "*", 
          RowBox[{"n", "^", "2"}], "*", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{"p", "+", "2"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", 
            RowBox[{"2", "*", "n"}]}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Cos", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"p", "\[NotEqual]", 
     RowBox[{"-", "2"}]}], " ", "&&", " ", 
    RowBox[{"0", "<", 
     RowBox[{"2", "*", "n"}], "<", 
     RowBox[{"m", "+", "1", " "}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978101813857155`*^9, 
   3.497810442686082*^9, 3.49781112699704*^9, 3.497812038232719*^9, 
   3.497813004784072*^9, 3.4978145150861864`*^9, 3.497814742666505*^9, {
   3.497921614823383*^9, 3.4979216450094357`*^9}, 3.4979841440597353`*^9, {
   3.4990389176671977`*^9, 3.4990389197420015`*^9}, 3.5171906798126755`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.638.1'", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.497810067935557*^9, 
   3.497810452426095*^9, 3.4978120457827296`*^9, 3.497814519586193*^9, 
   3.4978147490865145`*^9, 3.497815269747243*^9, 3.4978154214374557`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"p", ">", "1"}], " ", "\[And]", " ", 
    RowBox[{"0", "<", 
     RowBox[{"2", "n"}], "<", 
     RowBox[{"1", "-", "m"}]}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "+", "n", "+", "1"}], "\[NotEqual]", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9, {
   3.4978102518358145`*^9, 3.4978103941360135`*^9}, {3.4978119614426117`*^9, 
   3.4978119879026484`*^9}, {3.4978142081057568`*^9, 
   3.4978142300257874`*^9}, {3.497814551106237*^9, 3.4978145682762613`*^9}, {
   3.4978146024663086`*^9, 3.4978146072663155`*^9}, {3.497814842496645*^9, 
   3.4978148883467093`*^9}, {3.4978154312274694`*^9, 3.4978154608075104`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], "]"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}]}], "]"}], "p"]}], 
       RowBox[{"m", "+", "1"}]]}]}]}]}], "-", 
  FractionBox[
   RowBox[{"b", " ", "n", " ", "p", " ", 
    SuperscriptBox["x", 
     RowBox[{"m", "+", "n", "+", "1"}]], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], "]"}], 
     RowBox[{"p", "-", "1"}]]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"m", "+", "1"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"m", "+", "n", "+", "1"}], ")"}]}]], "-", "          ", 
  "\[IndentingNewLine]", "          ", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["n", "2"], " ", 
     SuperscriptBox["p", "2"]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "n", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", 
       RowBox[{"2", " ", "n"}]}]], " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], "]"}], "p"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["n", "2"], " ", "p", " ", 
     RowBox[{"(", 
      RowBox[{"p", "-", "1"}], ")"}]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "n", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", 
       RowBox[{"2", " ", "n"}]}]], " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], "]"}], 
      RowBox[{"p", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, {3.497810228295781*^9, 3.497810232715788*^9}, 
   3.497810535736212*^9, {3.497812078252775*^9, 3.497812093972797*^9}, 
   3.497814621316335*^9, 3.497814652296379*^9, {3.4978148058565936`*^9, 
   3.4978148214266157`*^9}, {3.497815400257426*^9, 3.4978154119374423`*^9}, {
   3.497845142277873*^9, 3.4978451542978897`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], "]"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", "p"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "-", " ", "\n", "  ", 
    RowBox[{"b", "*", "n", "*", "p", "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "n", "+", "1"}], ")"}]}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"x", "^", "n"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", " ",
     "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"p", "^", "2"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "n", "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", 
            RowBox[{"2", "*", "n"}]}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "^", "p"}]}], ",", "x"}], 
       "]"}]}], "]"}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", "p", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "-", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "n", "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", 
            RowBox[{"2", "*", "n"}]}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "1"}], " ", "&&", " ", 
    RowBox[{"0", "<", 
     RowBox[{"2", "*", "n"}], "<", 
     RowBox[{"1", "-", "m"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "n", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978101813857155`*^9, 
   3.497810442686082*^9, 3.49781112699704*^9, 3.497812038232719*^9, 
   3.497813004784072*^9, 3.4978145150861864`*^9, 3.497814742666505*^9, 
   3.4978153515773573`*^9, 3.5171906798282757`*^9},
 Background->GrayLevel[0.85]],

Cell["Reference: G&R 2.638.2'", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.497810067935557*^9, 
   3.497810452426095*^9, 3.4978120457827296`*^9, 3.497814519586193*^9, 
   3.4978147490865145`*^9, 3.497815269747243*^9, 3.4978154214374557`*^9, {
   3.4979844118186054`*^9, 3.497984412083806*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], "]"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", "p"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{"b", "*", "n", "*", "p", "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "n", "+", "1"}], ")"}]}], "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"x", "^", "n"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", " ",
     "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"p", "^", "2"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "n", "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", 
            RowBox[{"2", "*", "n"}]}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Cos", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "^", "p"}]}], ",", "x"}], 
       "]"}]}], "]"}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", "p", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "-", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "n", "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", 
            RowBox[{"2", "*", "n"}]}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Cos", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "1"}], " ", "&&", " ", 
    RowBox[{"0", "<", 
     RowBox[{"2", "*", "n"}], "<", 
     RowBox[{"1", "-", "m"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "n", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978101813857155`*^9, 
   3.497810442686082*^9, 3.49781112699704*^9, 3.497812038232719*^9, 
   3.497813004784072*^9, 3.4978145150861864`*^9, 3.497814742666505*^9, 
   3.4978153515773573`*^9, {3.4979216148389826`*^9, 3.497921645025036*^9}, 
   3.4979841554789553`*^9, 3.5171906798282757`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.497810067935557*^9, 
   3.497810452426095*^9, 3.4978120457827296`*^9, 3.497814519586193*^9, 
   3.4978147490865145`*^9, 3.497815269747243*^9, 3.4978154214374557`*^9, 
   3.497815549677635*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Sin", "[", "z", "]"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", "z"}]]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[ImaginaryI]", " ", "z"}]]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, 3.4978100933655925`*^9, 3.497810195205735*^9, 
   3.497811560037646*^9, 3.497811810187996*^9, 3.4978123204031143`*^9}],

Cell["Note: Not sure if this is useful or necessary.", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.497810067935557*^9, 
   3.497810452426095*^9, 3.4978120457827296`*^9, 3.497814519586193*^9, 
   3.4978147490865145`*^9, 3.497815269747243*^9, 3.4978154214374557`*^9, 
   3.497815549677635*^9, {3.497815598457703*^9, 3.497815626807743*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"p", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"m", "-", "n", "+", "1"}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9, {
   3.4978102518358145`*^9, 3.4978103941360135`*^9}, {3.4978119614426117`*^9, 
   3.4978119879026484`*^9}, {3.4978142081057568`*^9, 
   3.4978142300257874`*^9}, {3.497814551106237*^9, 3.4978145682762613`*^9}, {
   3.4978146024663086`*^9, 3.4978146072663155`*^9}, {3.497814842496645*^9, 
   3.4978148883467093`*^9}, {3.4978154312274694`*^9, 
   3.4978154608075104`*^9}, {3.4978157279078846`*^9, 3.4978157608579307`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], 
   SuperscriptBox[
    RowBox[{"Sin", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["\[ImaginaryI]", "2"], ")"}], "p"]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "a"}], " ", "\[ImaginaryI]"}], "-", 
          RowBox[{"b", " ", "\[ImaginaryI]", " ", 
           SuperscriptBox["x", "n"]}]}]], "-", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"a", " ", "\[ImaginaryI]"}], "+", 
          RowBox[{"b", " ", "\[ImaginaryI]", " ", 
           SuperscriptBox["x", "n"]}]}]]}], ")"}], "p"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, {3.497810228295781*^9, 3.497810232715788*^9}, 
   3.497810535736212*^9, {3.497812078252775*^9, 3.497812093972797*^9}, 
   3.497814621316335*^9, 3.497814652296379*^9, {3.4978148058565936`*^9, 
   3.4978148214266157`*^9}, {3.497815400257426*^9, 3.4978154119374423`*^9}, 
   3.4978156594677887`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x_", "^", "m_."}], "*", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"x_", "^", "n_."}]}]}], "]"}], "^", "p_"}]}], ",", 
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"I", "/", "2"}], ")"}], "^", "p"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"E", "^", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "a"}], "*", "I"}], "-", 
               RowBox[{"b", "*", "I", "*", 
                RowBox[{"x", "^", "n"}]}]}], ")"}]}], "-", 
            RowBox[{"E", "^", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a", "*", "I"}], "+", 
               RowBox[{"b", "*", "I", "*", 
                RowBox[{"x", "^", "n"}]}]}], ")"}]}]}], ")"}], "^", "p"}]}], 
        ",", "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "m", ",", "n"}], "}"}], ",", "x"}], "]"}],
      " ", "&&", " ", 
     RowBox[{"IntegerQ", "[", "p", "]"}], " ", "&&", " ", 
     RowBox[{"p", ">", "0"}], " ", "&&", " ", 
     RowBox[{"NonzeroQ", "[", 
      RowBox[{"m", "+", "1"}], "]"}], " ", "&&", " ", 
     RowBox[{"NonzeroQ", "[", 
      RowBox[{"m", "-", "n", "+", "1"}], "]"}], " ", "&&", " ", 
     RowBox[{"Not", "[", 
      RowBox[{
       RowBox[{"FractionQ", "[", "m", "]"}], " ", "||", " ", 
       RowBox[{"FractionOrNegativeQ", "[", "n", "]"}]}], "]"}]}]}]}], " ", 
  "*)"}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978101813857155`*^9, 
   3.497810442686082*^9, 3.49781112699704*^9, 3.497812038232719*^9, 
   3.497813004784072*^9, 3.4978145150861864`*^9, 3.497814742666505*^9, 
   3.4978153515773573`*^9, 3.4978155440176272`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], ")"}], "n"]}]}], "]"}], "p"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978099162653446`*^9, 3.49780992018535*^9}, 
   3.49781110611701*^9, 3.497812987564048*^9, 3.4978161062384143`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by linear substitution", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, 3.4978130316141095`*^9, 
   3.497816126028442*^9, {3.497816232328591*^9, 3.4978162335785923`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"m", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalQ]"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4978130900441914`*^9, 3.4978131572642856`*^9}, {
   3.497813348754554*^9, 3.49781336751458*^9}, {3.497814099895605*^9, 
   3.497814106035614*^9}, {3.497816281168659*^9, 3.49781629615868*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], ")"}], "n"]}]}], "]"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "d"]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["c", "d"]}], "+", 
          FractionBox["x", "d"]}], ")"}], "m"], " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", "n"]}]}], "]"}], "p"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, {3.497811202387145*^9, 3.497811226367179*^9}, {
   3.4978114144974422`*^9, 3.4978114162574444`*^9}, {3.497813065384157*^9, 
   3.4978130749041705`*^9}, {3.4978133280245247`*^9, 
   3.4978133437345467`*^9}, {3.497813396744621*^9, 3.4978134492246943`*^9}, {
   3.4978162571586256`*^9, 3.497816269458643*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c_", "+", 
            RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "n_"}]}]}], "]"}], "^", 
      "p_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", "d"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "c"}], "/", "d"}], "+", 
             RowBox[{"x", "/", "d"}]}], ")"}], "^", "m"}], "*", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"x", "^", "n"}]}]}], "]"}], "^", "p"}]}], ",", "x"}], 
        "]"}], ",", "x", ",", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497811159337085*^9, {3.4978114183274474`*^9, 3.4978114203574505`*^9}, 
   3.4978130235240984`*^9, {3.4978134985547633`*^9, 3.497813609294918*^9}, 
   3.497816116228428*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c_", "+", 
            RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "n_"}]}]}], "]"}], "^", 
      "p_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", "d"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "c"}], "/", "d"}], "+", 
             RowBox[{"x", "/", "d"}]}], ")"}], "^", "m"}], "*", 
          RowBox[{
           RowBox[{"Cos", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"x", "^", "n"}]}]}], "]"}], "^", "p"}]}], ",", "x"}], 
        "]"}], ",", "x", ",", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497811159337085*^9, {3.4978114183274474`*^9, 3.4978114203574505`*^9}, 
   3.4978130235240984`*^9, {3.4978134985547633`*^9, 3.497813609294918*^9}, 
   3.497816116228428*^9, {3.4979216304390106`*^9, 3.4979216304390106`*^9}, 
   3.4979845428120356`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", "2"]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978099162653446`*^9, 3.49780992018535*^9}, 
   3.497816868100286*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, {3.4978169434003916`*^9, 
   3.497816948440398*^9}}],

Cell[TextData[{
 "Basis: ",
 "If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["b", "2"], "-", 
    RowBox[{"4", " ", "a", " ", "c"}]}], "=", "0"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"b", " ", "x"}], "+", 
    RowBox[{"c", " ", 
     SuperscriptBox["x", "2"]}]}], "=", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"2", " ", "c", " ", "x"}]}], ")"}], "2"], 
    RowBox[{"4", " ", "c"}]]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, {3.497816982770447*^9, 3.4978170004804716`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["b", "2"], "-", 
    RowBox[{"4", " ", "a", " ", "c"}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", "2"]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       RowBox[{"Sin", "[", 
        FractionBox[
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"2", " ", "c", " ", "x"}]}], ")"}], "2"], 
         RowBox[{"4", " ", "c"}]], "]"}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, 3.4978168734802933`*^9, 3.497816906020339*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"a_.", "+", 
      RowBox[{"b_.", "*", "x_"}], "+", 
      RowBox[{"c_.", "*", 
       RowBox[{"x_", "^", "2"}]}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b", "+", 
          RowBox[{"2", "*", "c", "*", "x"}]}], ")"}], "^", "2"}], "/", 
       RowBox[{"(", 
        RowBox[{"4", "*", "c"}], ")"}]}], "]"}], ",", "x"}], "]"}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"a_.", "+", 
      RowBox[{"b_.", "*", "x_"}], "+", 
      RowBox[{"c_.", "*", 
       RowBox[{"x_", "^", "2"}]}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b", "+", 
          RowBox[{"2", "*", "c", "*", "x"}]}], ")"}], "^", "2"}], "/", 
       RowBox[{"(", 
        RowBox[{"4", "*", "c"}], ")"}]}], "]"}], ",", "x"}], "]"}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, {3.49792163047021*^9, 3.49792163047021*^9}, 
   3.497984621592174*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.497810067935557*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"b", " ", "x"}], "+", 
    RowBox[{"c", " ", 
     SuperscriptBox["x", "2"]}]}], "=", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{"2", " ", "c", " ", "x"}]}], ")"}], "2"], 
     RowBox[{"4", " ", "c"}]], "-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}], 
     RowBox[{"4", " ", "c"}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, 3.4978100933655925`*^9, {3.497817065230562*^9, 
   3.4978170909905977`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"z", "-", "w"}], "]"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Cos", "[", "w", "]"}], " ", 
     RowBox[{"Sin", "[", "z", "]"}]}], "-", 
    RowBox[{
     RowBox[{"Sin", "[", "w", "]"}], " ", 
     RowBox[{"Cos", "[", "z", "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, 3.4978100933655925`*^9, {3.497817065230562*^9, 
   3.4978170672105646`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["b", "2"], "-", 
    RowBox[{"4", " ", "a", " ", "c"}]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817041950529*^9, 3.4978170441505327`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"Cos", "[", 
       FractionBox[
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"4", " ", "a", " ", "c"}]}], 
        RowBox[{"4", " ", "c"}]], "]"}]}]}], " ", 
    RowBox[{"\[Integral]", 
     RowBox[{
      RowBox[{"Sin", "[", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"b", "+", 
           RowBox[{"2", " ", "c", " ", "x"}]}], ")"}], "2"], 
        RowBox[{"4", " ", "c"}]], "]"}], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   RowBox[{"Sin", "[", 
    FractionBox[
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}], 
     RowBox[{"4", " ", "c"}]], "]"}], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"Cos", "[", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"b", "+", 
          RowBox[{"2", " ", "c", " ", "x"}]}], ")"}], "2"], 
       RowBox[{"4", " ", "c"}]], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, 3.497816875700297*^9, 3.497816927160369*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"a_.", "+", 
      RowBox[{"b_.", "*", "x_"}], "+", 
      RowBox[{"c_.", "*", 
       RowBox[{"x_", "^", "2"}]}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "-", 
         RowBox[{"4", "*", "a", "*", "c"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"4", "*", "c"}], ")"}]}], "]"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"2", "*", "c", "*", "x"}]}], ")"}], "^", "2"}], "/", 
         RowBox[{"(", 
          RowBox[{"4", "*", "c"}], ")"}]}], "]"}], ",", "x"}], "]"}]}], " ", 
    "-", " ", "\n", "  ", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "-", 
         RowBox[{"4", "*", "a", "*", "c"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"4", "*", "c"}], ")"}]}], "]"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"2", "*", "c", "*", "x"}]}], ")"}], "^", "2"}], "/", 
         RowBox[{"(", 
          RowBox[{"4", "*", "c"}], ")"}]}], "]"}], ",", "x"}], "]"}]}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"a_.", "+", 
      RowBox[{"b_.", "*", "x_"}], "+", 
      RowBox[{"c_.", "*", 
       RowBox[{"x_", "^", "2"}]}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "-", 
         RowBox[{"4", "*", "a", "*", "c"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"4", "*", "c"}], ")"}]}], "]"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"2", "*", "c", "*", "x"}]}], ")"}], "^", "2"}], "/", 
         RowBox[{"(", 
          RowBox[{"4", "*", "c"}], ")"}]}], "]"}], ",", "x"}], "]"}]}], " ", 
    "+", " ", "\n", "  ", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "-", 
         RowBox[{"4", "*", "a", "*", "c"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"4", "*", "c"}], ")"}]}], "]"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"2", "*", "c", "*", "x"}]}], ")"}], "^", "2"}], "/", 
         RowBox[{"(", 
          RowBox[{"4", "*", "c"}], ")"}]}], "]"}], ",", "x"}], "]"}]}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, {
   3.497921614870183*^9, 3.4979216450562363`*^9}, 3.4979846288461866`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"d", "+", 
      RowBox[{"e", " ", "x"}]}], ")"}], "m"], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", "2"]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978099162653446`*^9, 3.49780992018535*^9}, 
   3.497816868100286*^9, 3.4978172180407763`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"b", " ", "e"}], "-", 
    RowBox[{"2", "c", " ", "d"}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.4978172319407954`*^9, 3.4978172425808105`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"d", "+", 
     RowBox[{"e", " ", "x"}]}], ")"}], 
   RowBox[{"Sin", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", "2"]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"e", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}], "+", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", "2"]}]}], "]"}]}], 
       RowBox[{"2", " ", "c"}]]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, 3.4978168734802933`*^9, 3.497816906020339*^9, {
   3.4978172634508395`*^9, 3.4978172755208564`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d_.", "+", 
       RowBox[{"e_.", "*", "x_"}]}], ")"}], "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "e"}], "*", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}], "+", 
       RowBox[{"c", "*", 
        RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", "c"}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "e"}], "-", 
      RowBox[{"2", "*", "c", "*", "d"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817209510764*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d_.", "+", 
       RowBox[{"e_.", "*", "x_"}]}], ")"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"e", "*", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}], "+", 
       RowBox[{"c", "*", 
        RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", "c"}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "e"}], "-", 
      RowBox[{"2", "*", "c", "*", "d"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817209510764*^9, {3.497921614885783*^9, 
   3.497921645071836*^9}, 3.4979847657676272`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"b", " ", "e"}], "-", 
    RowBox[{"2", "c", " ", "d"}]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817041950529*^9, 3.4978170441505327`*^9}, {3.497817345560954*^9, 
   3.497817350040961*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"d", "+", 
      RowBox[{"e", " ", "x"}]}], ")"}], 
    RowBox[{"Sin", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"e", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}], "+", 
           RowBox[{"c", " ", 
            SuperscriptBox["x", "2"]}]}], "]"}]}], 
        RowBox[{"2", " ", "c"}]]}]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"b", " ", "e"}], "-", 
     RowBox[{"2", " ", "c", " ", "d"}]}], 
    RowBox[{"2", " ", "c"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, 3.497816875700297*^9, 3.497816927160369*^9, {
   3.49781732084092*^9, 3.4978173345809393`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d_.", "+", 
       RowBox[{"e_.", "*", "x_"}]}], ")"}], "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "e"}], "*", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "c"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "e"}], "-", 
         RowBox[{"2", "*", "c", "*", "d"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "c"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}], "+", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "2"}]}]}], "]"}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "e"}], "-", 
      RowBox[{"2", "*", "c", "*", "d"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978172025607543`*^9, 3.4978172990008893`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d_.", "+", 
       RowBox[{"e_.", "*", "x_"}]}], ")"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"e", "*", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "c"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "e"}], "-", 
         RowBox[{"2", "*", "c", "*", "d"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "c"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"Cos", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}], "+", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "2"}]}]}], "]"}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "e"}], "-", 
      RowBox[{"2", "*", "c", "*", "d"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978172025607543`*^9, 3.4978172990008893`*^9, {3.497921614901383*^9, 
   3.4979216450874357`*^9}, 3.497984772569239*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"m", ">", "1"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"b", " ", "e"}], "-", 
     RowBox[{"2", "c", " ", "d"}]}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817041950529*^9, 3.4978170441505327`*^9}, {3.497817345560954*^9, 
   3.497817350040961*^9}, 3.497817472421132*^9, {3.497817508601183*^9, 
   3.497817518021196*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"e", " ", "x"}]}], ")"}], "m"], 
    RowBox[{"Sin", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                          ", "\[IndentingNewLine]", "                       ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"e", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], ")"}], 
          RowBox[{"m", "-", "1"}]], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}], "+", 
           RowBox[{"c", " ", 
            SuperscriptBox["x", "2"]}]}], "]"}]}], 
        RowBox[{"2", " ", "c"}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["e", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"m", "-", "1"}], ")"}]}], 
    RowBox[{"2", " ", "c"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], ")"}], 
      RowBox[{"m", "-", "2"}]], " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, 3.497816875700297*^9, 3.497816927160369*^9, {
   3.49781732084092*^9, 3.4978173345809393`*^9}, {3.4978174657811227`*^9, 
   3.4978174870611525`*^9}, {3.4978452139579735`*^9, 3.497845227327992*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d_.", "+", 
        RowBox[{"e_.", "*", "x_"}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "e"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "c"}], ")"}]}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"e", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "-", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", "*", "c"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "e"}], "-", 
      RowBox[{"2", "*", "c", "*", "d"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978172025607543`*^9, 3.4978172990008893`*^9, 3.497817445141094*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d_.", "+", 
        RowBox[{"e_.", "*", "x_"}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"e", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "c"}], ")"}]}]}], " ", "-", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"e", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "-", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", "*", "c"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "e"}], "-", 
      RowBox[{"2", "*", "c", "*", "d"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978172025607543`*^9, 3.4978172990008893`*^9, 3.497817445141094*^9, {
   3.497921614932583*^9, 3.497921645118636*^9}, 3.497984780150852*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"b", " ", "e"}], "-", 
     RowBox[{"2", "c", " ", "d"}]}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817041950529*^9, 3.4978170441505327`*^9}, {3.497817345560954*^9, 
   3.497817350040961*^9}, 3.497817472421132*^9, {3.497817508601183*^9, 
   3.497817518021196*^9}, {3.497817607271321*^9, 3.4978176097513247`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"e", " ", "x"}]}], ")"}], "m"], 
    RowBox[{"Sin", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"e", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], ")"}], 
          RowBox[{"m", "-", "1"}]], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}], "+", 
           RowBox[{"c", " ", 
            SuperscriptBox["x", "2"]}]}], "]"}]}], 
        RowBox[{"2", " ", "c"}]]}]}]}]}]}], "-", 
  "                                                ", "\[IndentingNewLine]", 
  "                ", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"b", " ", "e"}], "-", 
     RowBox[{"2", " ", "c", " ", "d"}]}], 
    RowBox[{"2", " ", "c"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], ")"}], 
      RowBox[{"m", "-", "1"}]], " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["e", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"m", "-", "1"}], ")"}]}], 
    RowBox[{"2", " ", "c"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], ")"}], 
      RowBox[{"m", "-", "2"}]], " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, 3.497816875700297*^9, 3.497816927160369*^9, {
   3.49781732084092*^9, 3.4978173345809393`*^9}, {3.4978174657811227`*^9, 
   3.4978174870611525`*^9}, {3.497817584611289*^9, 3.497817597891308*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d_.", "+", 
        RowBox[{"e_.", "*", "x_"}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "e"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "c"}], ")"}]}]}], " ", "-", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "e"}], "-", 
         RowBox[{"2", "*", "c", "*", "d"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "c"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], "]"}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"e", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "-", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", "*", "c"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "e"}], "-", 
      RowBox[{"2", "*", "c", "*", "d"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978172025607543`*^9, 3.4978172990008893`*^9, 3.497817445141094*^9, 
   3.497817548651239*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d_.", "+", 
        RowBox[{"e_.", "*", "x_"}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"e", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "c"}], ")"}]}]}], " ", "-", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "e"}], "-", 
         RowBox[{"2", "*", "c", "*", "d"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "c"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], "]"}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"e", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "-", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", "*", "c"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "e"}], "-", 
      RowBox[{"2", "*", "c", "*", "d"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978172025607543`*^9, 3.4978172990008893`*^9, 3.497817445141094*^9, 
   3.497817548651239*^9, {3.497921614948183*^9, 3.4979216451342363`*^9}, 
   3.49798479001007*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"b", " ", "e"}], "-", 
     RowBox[{"2", "c", " ", "d"}]}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817041950529*^9, 3.4978170441505327`*^9}, {3.497817345560954*^9, 
   3.497817350040961*^9}, 3.497817472421132*^9, {3.497817508601183*^9, 
   3.497817518021196*^9}, {3.4978176606313953`*^9, 3.497817661711397*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"e", " ", "x"}]}], ")"}], "m"], 
    RowBox[{"Sin", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                         ", "\[IndentingNewLine]", 
      "                               ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], ")"}], 
         RowBox[{"m", "+", "1"}]], " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}], "+", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", "2"]}]}], "]"}]}], 
       RowBox[{"e", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", "c"}], 
    RowBox[{
     SuperscriptBox["e", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], ")"}], 
      RowBox[{"m", "+", "2"}]], " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, 3.497816875700297*^9, 3.497816927160369*^9, {
   3.49781732084092*^9, 3.4978173345809393`*^9}, {3.4978174657811227`*^9, 
   3.4978174870611525`*^9}, 3.497817687031432*^9, {3.4978452447580166`*^9, 
   3.497845253888029*^9}, {3.497845336788145*^9, 3.497845345858158*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d_.", "+", 
        RowBox[{"e_.", "*", "x_"}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"e", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"2", "*", 
       RowBox[{"c", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"e", "^", "2"}], "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "e"}], "-", 
      RowBox[{"2", "*", "c", "*", "d"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978172025607543`*^9, 3.4978172990008893`*^9, 3.497817445141094*^9, 
   3.497817656111389*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d_.", "+", 
        RowBox[{"e_.", "*", "x_"}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"e", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"2", "*", 
       RowBox[{"c", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"e", "^", "2"}], "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "e"}], "-", 
      RowBox[{"2", "*", "c", "*", "d"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978172025607543`*^9, 3.4978172990008893`*^9, 3.497817445141094*^9, 
   3.497817656111389*^9, {3.4979216149793835`*^9, 3.497921645149836*^9}, 
   3.497984798652485*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"b", " ", "e"}], "-", 
     RowBox[{"2", "c", " ", "d"}]}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817041950529*^9, 3.4978170441505327`*^9}, {3.497817345560954*^9, 
   3.497817350040961*^9}, 3.497817472421132*^9, {3.497817508601183*^9, 
   3.497817518021196*^9}, {3.497817607271321*^9, 3.4978176097513247`*^9}, {
   3.497817752511524*^9, 3.497817753781526*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"e", " ", "x"}]}], ")"}], "m"], 
    RowBox[{"Sin", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], ")"}], 
         RowBox[{"m", "+", "1"}]], " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}], "+", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", "2"]}]}], "]"}]}], 
       RowBox[{"e", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  "                                                ", "\[IndentingNewLine]", 
  "           ", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"b", " ", "e"}], "-", 
     RowBox[{"2", " ", "c", " ", "d"}]}], 
    RowBox[{
     SuperscriptBox["e", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], ")"}], 
      RowBox[{"m", "+", "1"}]], " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", "c"}], 
    RowBox[{
     SuperscriptBox["e", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], ")"}], 
      RowBox[{"m", "+", "2"}]], " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, 3.497816875700297*^9, 3.497816927160369*^9, {
   3.49781732084092*^9, 3.4978173345809393`*^9}, {3.4978174657811227`*^9, 
   3.4978174870611525`*^9}, {3.497817584611289*^9, 3.497817597891308*^9}, {
   3.497817735711501*^9, 3.4978177468615165`*^9}, {3.4978453784582033`*^9, 
   3.497845389358219*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d_.", "+", 
        RowBox[{"e_.", "*", "x_"}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"e", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "e"}], "-", 
         RowBox[{"2", "*", "c", "*", "d"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"e", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], "]"}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"2", "*", 
       RowBox[{"c", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"e", "^", "2"}], "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "e"}], "-", 
      RowBox[{"2", "*", "c", "*", "d"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978172025607543`*^9, 3.4978172990008893`*^9, 3.497817445141094*^9, 
   3.497817548651239*^9, 3.497817648381378*^9, 3.497817703281455*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d_.", "+", 
        RowBox[{"e_.", "*", "x_"}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"e", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "e"}], "-", 
         RowBox[{"2", "*", "c", "*", "d"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"e", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], "]"}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"2", "*", 
       RowBox[{"c", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"e", "^", "2"}], "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "e"}], "-", 
      RowBox[{"2", "*", "c", "*", "d"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978172025607543`*^9, 3.4978172990008893`*^9, 3.497817445141094*^9, 
   3.497817548651239*^9, 3.497817648381378*^9, 3.497817703281455*^9, {
   3.497921614994983*^9, 3.497921645181036*^9}, 3.4979848055788975`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sin", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Log", "[", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], "p"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978099162653446`*^9, 3.49780992018535*^9}, 
   3.497816868100286*^9, 3.4978178569916706`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["n", "2"]}]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Log", "[", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"x", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Log", "[", 
            RowBox[{"c", " ", 
             SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}]}], 
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["n", "2"]}]}]]}]}]}]}], "-", 
  FractionBox[
   RowBox[{"b", " ", "n", " ", "x", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Log", "[", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}]}], 
   RowBox[{"1", "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["n", "2"]}]}]]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, 3.4978168734802933`*^9, 3.497816906020339*^9, {
   3.49781786362168*^9, 3.4978178842317085`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"a_.", "+", 
      RowBox[{"b_.", "*", 
       RowBox[{"Log", "[", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}]}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"b", "*", "n", "*", "x", "*", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}]}]}], ")"}]}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817840791648*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"a_.", "+", 
      RowBox[{"b_.", "*", 
       RowBox[{"Log", "[", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}]}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"b", "*", "n", "*", "x", "*", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}]}]}], ")"}]}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817840791648*^9, {3.497921615010583*^9, 
   3.497921645196636*^9}, 3.497985161961523*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"p", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["n", "2"], " ", 
      SuperscriptBox["p", "2"]}]}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4978180135518894`*^9, 
   3.4978180349019194`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"x", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Log", "[", 
             RowBox[{"c", " ", 
              SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], "p"]}], 
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["n", "2"], " ", 
         SuperscriptBox["p", "2"]}]}]]}]}]}]}], "-", 
  "                                                                           \
     ", "\[IndentingNewLine]", "   ", 
  FractionBox[
   RowBox[{"b", " ", "n", " ", "p", " ", "x", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Log", "[", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], 
     RowBox[{"p", "-", "1"}]]}], 
   RowBox[{"1", "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["n", "2"], " ", 
     SuperscriptBox["p", "2"]}]}]], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["n", "2"], " ", "p", " ", 
     RowBox[{"(", 
      RowBox[{"p", "-", "1"}], ")"}]}], 
    RowBox[{"1", "+", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["n", "2"], " ", 
      SuperscriptBox["p", "2"]}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Log", "[", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], 
      RowBox[{"p", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, 3.497816875700297*^9, 3.497816927160369*^9, {
   3.497817967231825*^9, 3.4978179825118465`*^9}, {3.4978454312782774`*^9, 
   3.497845444918297*^9}, {3.49784591148895*^9, 3.4978459126289515`*^9}, {
   3.497846040609131*^9, 3.497846045799138*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}], "^", "p_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", "p"}], "/", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}], "*", 
         RowBox[{"p", "^", "2"}]}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"b", "*", "n", "*", "p", "*", "x", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}], "*", 
         RowBox[{"p", "^", "2"}]}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", "p", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "-", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{
           RowBox[{"b", "^", "2"}], "*", 
           RowBox[{"n", "^", "2"}], "*", 
           RowBox[{"p", "^", "2"}]}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Log", "[", 
             RowBox[{"c", "*", 
              RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"p", "-", "2"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "1"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", 
       RowBox[{"p", "^", "2"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978178331616373`*^9, 3.497817943721792*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}], "^", "p_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", "p"}], "/", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}], "*", 
         RowBox[{"p", "^", "2"}]}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"b", "*", "n", "*", "p", "*", "x", "*", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"p", "-", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}], "*", 
         RowBox[{"p", "^", "2"}]}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", "p", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "-", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{
           RowBox[{"b", "^", "2"}], "*", 
           RowBox[{"n", "^", "2"}], "*", 
           RowBox[{"p", "^", "2"}]}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Log", "[", 
             RowBox[{"c", "*", 
              RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"p", "-", "2"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "1"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", 
       RowBox[{"p", "^", "2"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978178331616373`*^9, 3.497817943721792*^9, {3.4979216150417833`*^9, 
   3.4979216452122364`*^9}, 3.4979851724603415`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"p", "\[NotEqual]", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"p", "\[NotEqual]", 
     RowBox[{"-", "2"}]}], " ", "\[And]", " ", 
    RowBox[{"1", "+", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["n", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}], "2"]}]}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4978180135518894`*^9, 
   3.4978180349019194`*^9}, {3.4978181090720234`*^9, 3.497818144362073*^9}, {
   3.4990409864002314`*^9, 3.4990409982718525`*^9}, {3.499041545815615*^9, 
   3.499041545815615*^9}, {3.499124360002801*^9, 3.4991243619528036`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"x", " ", 
        RowBox[{"Cot", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Log", "[", 
            RowBox[{"c", " ", 
             SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Log", "[", 
             RowBox[{"c", " ", 
              SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], 
         RowBox[{"p", "+", "2"}]]}], 
       RowBox[{"b", " ", "n", " ", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  FractionBox[
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], 
     RowBox[{"p", "+", "2"}]]}], 
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    SuperscriptBox["n", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"p", "+", "1"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"p", "+", "2"}], ")"}]}]]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, 3.497816875700297*^9, 3.497816927160369*^9, {
   3.497817967231825*^9, 3.4978179825118465`*^9}, {3.4978180869619923`*^9, 
   3.497818100362011*^9}, {3.497845459618317*^9, 3.4978454619083204`*^9}, {
   3.49904154854562*^9, 3.499041556813635*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}], "^", "p_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{"Cot", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", 
        RowBox[{"n", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "2"}], ")"}]}], ")"}]}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "n", ",", "p"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"p", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"p", "+", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "+", "2"}], ")"}], "^", "2"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978178331616373`*^9, 3.497817943721792*^9, 3.4978180612919564`*^9, {
   3.499038735958079*^9, 3.4990387372996807`*^9}, {3.499040971892206*^9, 
   3.4990409767594147`*^9}, {3.499041561119242*^9, 3.499041572772463*^9}, {
   3.499124340662774*^9, 3.4991243557227945`*^9}, {3.4991245095730104`*^9, 
   3.499124514033016*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}], "^", "p_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "x"}], "*", 
     RowBox[{"Tan", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", 
        RowBox[{"n", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "2"}], ")"}]}], ")"}]}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "n", ",", "p"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"p", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"p", "+", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "+", "2"}], ")"}], "^", "2"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978178331616373`*^9, 3.497817943721792*^9, 3.4978180612919564`*^9, {
   3.497921630751011*^9, 3.497921630751011*^9}, 3.4979851806035557`*^9, {
   3.4990389242348094`*^9, 3.4990389253268113`*^9}, 3.4990410904992146`*^9, {
   3.499041644064588*^9, 3.4990416507101994`*^9}, {3.499124407432867*^9, 
   3.4991244229228888`*^9}, {3.499124540903054*^9, 3.499124546123061*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"p", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{"p", "\[NotEqual]", 
    RowBox[{"-", "2"}]}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["n", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}], "2"]}]}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4978180135518894`*^9, 
   3.4978180349019194`*^9}, {3.4978181090720234`*^9, 3.497818144362073*^9}, {
   3.4990409864002314`*^9, 3.4990409982718525`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"x", " ", 
        RowBox[{"Cot", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Log", "[", 
            RowBox[{"c", " ", 
             SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Log", "[", 
             RowBox[{"c", " ", 
              SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], 
         RowBox[{"p", "+", "2"}]]}], 
       RowBox[{"b", " ", "n", " ", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}]]}]}]}]}], "-", "                  ",
   "\[IndentingNewLine]", "                      ", 
  FractionBox[
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], 
     RowBox[{"p", "+", "2"}]]}], 
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    SuperscriptBox["n", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"p", "+", "1"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"p", "+", "2"}], ")"}]}]], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"1", "+", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["n", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}], "2"]}]}], 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["n", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"p", "+", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"p", "+", "2"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Log", "[", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], 
      RowBox[{"p", "+", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, 3.497816875700297*^9, 3.497816927160369*^9, {
   3.497817967231825*^9, 3.4978179825118465`*^9}, {3.4978180869619923`*^9, 
   3.497818100362011*^9}, {3.497845459618317*^9, 3.4978454619083204`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}], "^", "p_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{"Cot", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", 
        RowBox[{"n", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "2"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "*", 
          RowBox[{"n", "^", "2"}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "+", "2"}], ")"}], "^", "2"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{"p", "+", "2"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Log", "[", 
             RowBox[{"c", "*", 
              RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"p", "+", "2"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"p", "\[NotEqual]", 
     RowBox[{"-", "2"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "+", "2"}], ")"}], "^", "2"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978178331616373`*^9, 3.497817943721792*^9, 3.4978180612919564`*^9, {
   3.499038735958079*^9, 3.4990387372996807`*^9}, {3.499040971892206*^9, 
   3.4990409767594147`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}], "^", "p_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "x"}], "*", 
     RowBox[{"Tan", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", 
        RowBox[{"n", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "2"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "*", 
          RowBox[{"n", "^", "2"}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "+", "2"}], ")"}], "^", "2"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{"p", "+", "2"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Log", "[", 
             RowBox[{"c", "*", 
              RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"p", "+", "2"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"p", "\[NotEqual]", 
     RowBox[{"-", "2"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "+", "2"}], ")"}], "^", "2"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978178331616373`*^9, 3.497817943721792*^9, 3.4978180612919564`*^9, {
   3.497921630751011*^9, 3.497921630751011*^9}, 3.4979851806035557`*^9, {
   3.4990389242348094`*^9, 3.4990389253268113`*^9}, 3.4990410904992146`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], 
   SuperscriptBox[
    RowBox[{"Sin", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Log", "[", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], "p"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978099162653446`*^9, 3.49780992018535*^9}, 
   3.497816868100286*^9, 3.4978178569916706`*^9, 3.4978181977321477`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["n", "2"]}], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}], "2"]}], "\[NotEqual]", "0"}], " ", 
   "\[And]", " ", 
   RowBox[{
    RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4978182572522306`*^9, 
   3.497818281002264*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    RowBox[{"Sin", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Log", "[", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], " ", 
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Log", "[", 
            RowBox[{"c", " ", 
             SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}]}], 
       RowBox[{
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["n", "2"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], "2"]}]]}]}]}]}], "-", 
  FractionBox[
   RowBox[{"b", " ", "n", " ", 
    SuperscriptBox["x", 
     RowBox[{"m", "+", "1"}]], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Log", "[", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}]}], 
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["n", "2"]}], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}], "2"]}]]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, 3.4978168734802933`*^9, 3.497816906020339*^9, {
   3.49781786362168*^9, 3.4978178842317085`*^9}, 3.497818243732212*^9, 
   3.497818386462412*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}], "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], "^", "2"}]}], ")"}]}]}], " ", "-", 
    "\n", "  ", 
    RowBox[{"b", "*", "n", "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], "^", "2"}]}], ")"}]}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "m", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817840791648*^9, 3.497818221872181*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}], "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], "^", "2"}]}], ")"}]}]}], " ", "+", 
    "\n", "  ", 
    RowBox[{"b", "*", "n", "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], "^", "2"}]}], ")"}]}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "m", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817840791648*^9, 3.497818221872181*^9, {
   3.4979216150573835`*^9, 3.4979216452434363`*^9}, 3.4979853429218407`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"p", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["n", "2"], " ", 
      SuperscriptBox["p", "2"]}], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}], "2"]}], "\[NotEqual]", "0"}], " ", 
   "\[And]", " ", 
   RowBox[{
    RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4978182572522306`*^9, 
   3.497818281002264*^9}, {3.4978183492423596`*^9, 3.4978183713523903`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], " ", 
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Log", "[", 
             RowBox[{"c", " ", 
              SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], "p"]}], 
       RowBox[{
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["n", "2"], " ", 
         SuperscriptBox["p", "2"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], "2"]}]]}]}]}]}], "-", 
  "                                                                     ", 
  "\[IndentingNewLine]", " ", 
  FractionBox[
   RowBox[{"b", " ", "n", " ", "p", " ", 
    SuperscriptBox["x", 
     RowBox[{"m", "+", "1"}]], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Log", "[", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], 
     RowBox[{"p", "-", "1"}]]}], 
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["n", "2"], " ", 
     SuperscriptBox["p", "2"]}], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}], "2"]}]], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["n", "2"], " ", "p", " ", 
     RowBox[{"(", 
      RowBox[{"p", "-", "1"}], ")"}]}], 
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["n", "2"], " ", 
      SuperscriptBox["p", "2"]}], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}], "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Log", "[", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], 
      RowBox[{"p", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, 3.497816875700297*^9, 3.497816927160369*^9, {
   3.497817967231825*^9, 3.4978179825118465`*^9}, {3.4978183229423227`*^9, 
   3.4978183297523327`*^9}, 3.4978183882424145`*^9, {3.4978454955383673`*^9, 
   3.497845510118388*^9}, {3.4978459385889883`*^9, 3.4978459422389927`*^9}, {
   3.497846083829191*^9, 3.4978460897591996`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c_.", "*", 
           RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}], "^", "p_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}], "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", "p"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}], "*", 
         RowBox[{"p", "^", "2"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], "^", "2"}]}], ")"}]}]}], " ", "-", 
    "\n", "  ", 
    RowBox[{"b", "*", "n", "*", "p", "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}], "*", 
         RowBox[{"p", "^", "2"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], "^", "2"}]}], ")"}]}]}], " ", "+", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", "p", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "-", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"b", "^", "2"}], "*", 
           RowBox[{"n", "^", "2"}], "*", 
           RowBox[{"p", "^", "2"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"m", "+", "1"}], ")"}], "^", "2"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"Log", "[", 
              RowBox[{"c", "*", 
               RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "m", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "1"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", 
       RowBox[{"p", "^", "2"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978178331616373`*^9, 3.497817943721792*^9, 3.497818214522171*^9, 
   3.4978182978122873`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c_.", "*", 
           RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}], "^", "p_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}], "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", "p"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}], "*", 
         RowBox[{"p", "^", "2"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], "^", "2"}]}], ")"}]}]}], " ", "+", 
    "\n", "  ", 
    RowBox[{"b", "*", "n", "*", "p", "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}], "*", 
         RowBox[{"p", "^", "2"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], "^", "2"}]}], ")"}]}]}], " ", "+", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", "p", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "-", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"b", "^", "2"}], "*", 
           RowBox[{"n", "^", "2"}], "*", 
           RowBox[{"p", "^", "2"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"m", "+", "1"}], ")"}], "^", "2"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Cos", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"Log", "[", 
              RowBox[{"c", "*", 
               RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "m", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "1"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", 
       RowBox[{"p", "^", "2"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978178331616373`*^9, 3.497817943721792*^9, 3.497818214522171*^9, 
   3.4978182978122873`*^9, {3.4979216150729833`*^9, 3.497921645259036*^9}, 
   3.4979853494270525`*^9, {3.4979854617472496`*^9, 3.49798546776886*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"p", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{"p", "\[NotEqual]", 
    RowBox[{"-", "2"}]}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4978180135518894`*^9, 
   3.4978180349019194`*^9}, {3.4978181090720234`*^9, 3.497818144362073*^9}, {
   3.4978184547825074`*^9, 3.497818462092518*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        RowBox[{"Cot", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Log", "[", 
            RowBox[{"c", " ", 
             SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Log", "[", 
             RowBox[{"c", " ", 
              SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], 
         RowBox[{"p", "+", "2"}]]}], 
       RowBox[{"b", " ", "n", " ", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  "                           ", "\[IndentingNewLine]", "        ", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"m", "+", "1"}], ")"}], " ", 
    SuperscriptBox["x", 
     RowBox[{"m", "+", "1"}]], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], 
     RowBox[{"p", "+", "2"}]]}], 
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    SuperscriptBox["n", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"p", "+", "1"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"p", "+", "2"}], ")"}]}]], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["n", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}], "2"]}], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}], "2"]}], 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["n", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"p", "+", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"p", "+", "2"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Log", "[", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], 
      RowBox[{"p", "+", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, 3.497816875700297*^9, 3.497816927160369*^9, {
   3.497817967231825*^9, 3.4978179825118465`*^9}, {3.4978180869619923`*^9, 
   3.497818100362011*^9}, 3.497818391632419*^9, {3.4978184390724854`*^9, 
   3.4978184412724886`*^9}, {3.497845520178402*^9, 3.4978455282384133`*^9}, {
   3.497846105079221*^9, 3.497846105589222*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c_.", "*", 
           RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}], "^", "p_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{"Cot", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}], "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", 
        RowBox[{"n", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "2"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"b", "^", "2"}], "*", 
          RowBox[{"n", "^", "2"}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "+", "2"}], ")"}], "^", "2"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}], "^", "2"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{"p", "+", "2"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"Log", "[", 
              RowBox[{"c", "*", 
               RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "m", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"p", "\[NotEqual]", 
     RowBox[{"-", "2"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978178331616373`*^9, 3.497817943721792*^9, 3.4978180612919564`*^9, 
   3.497818211422167*^9, 3.4978184091424437`*^9, {3.499038741854889*^9, 
   3.4990387432276917`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c_.", "*", 
           RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}], "^", "p_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}]}], "*", 
     RowBox[{"Tan", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}], "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", 
        RowBox[{"n", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "2"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"b", "^", "2"}], "*", 
          RowBox[{"n", "^", "2"}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "+", "2"}], ")"}], "^", "2"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}], "^", "2"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{"p", "+", "2"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Cos", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"Log", "[", 
              RowBox[{"c", "*", 
               RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "m", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"p", "\[NotEqual]", 
     RowBox[{"-", "2"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978178331616373`*^9, 3.497817943721792*^9, 3.4978180612919564`*^9, 
   3.497818211422167*^9, 3.4978184091424437`*^9, {3.497921630844611*^9, 
   3.497921630860211*^9}, 3.497985357897867*^9, {3.499038934889628*^9, 
   3.49903893579443*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"a", " ", 
     SuperscriptBox["x", "n"], " ", 
     SuperscriptBox[
      RowBox[{"Log", "[", 
       RowBox[{"b", " ", "x"}], "]"}], "p"]}], "]"}], " ", 
   SuperscriptBox[
    RowBox[{"Log", "[", 
     RowBox[{"b", " ", "x"}], "]"}], "p"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978099162653446`*^9, 3.49780992018535*^9}, 
   3.497816868100286*^9, 3.4978178569916706`*^9, 3.4978181977321477`*^9, {
   3.497818713152869*^9, 3.4978187170428743`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"p", ">", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4978182572522306`*^9, 
   3.497818281002264*^9}, {3.4978188033329954`*^9, 3.497818805922999*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"a", " ", "x", " ", 
      SuperscriptBox[
       RowBox[{"Log", "[", 
        RowBox[{"b", " ", "x"}], "]"}], "p"]}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Log", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"Cos", "[", 
         RowBox[{"a", " ", "x", " ", 
          SuperscriptBox[
           RowBox[{"Log", "[", 
            RowBox[{"b", " ", "x"}], "]"}], "p"]}], "]"}], "a"]}]}]}]}]}], 
  "-", 
  RowBox[{"p", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"a", " ", "x", " ", 
       SuperscriptBox[
        RowBox[{"Log", "[", 
         RowBox[{"b", " ", "x"}], "]"}], "p"]}], "]"}], " ", 
     SuperscriptBox[
      RowBox[{"Log", "[", 
       RowBox[{"b", " ", "x"}], "]"}], 
      RowBox[{"p", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, 3.4978168734802933`*^9, 3.497816906020339*^9, {
   3.49781786362168*^9, 3.4978178842317085`*^9}, 3.497818243732212*^9, 
   3.497818386462412*^9, {3.497818766582944*^9, 3.4978187902229767`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"a_.", "*", "x_", "*", 
       RowBox[{
        RowBox[{"Log", "[", 
         RowBox[{"b_.", "*", "x_"}], "]"}], "^", "p_."}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"b_.", "*", "x_"}], "]"}], "^", "p_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Cos", "[", 
       RowBox[{"a", "*", "x", "*", 
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"b", "*", "x"}], "]"}], "^", "p"}]}], "]"}]}], "/", "a"}], 
    " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{"p", ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"a", "*", "x", "*", 
           RowBox[{
            RowBox[{"Log", "[", 
             RowBox[{"b", "*", "x"}], "]"}], "^", "p"}]}], "]"}], "*", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"b", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817840791648*^9, 3.497818221872181*^9, 
   3.4978187399329066`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"a_.", "*", "x_", "*", 
       RowBox[{
        RowBox[{"Log", "[", 
         RowBox[{"b_.", "*", "x_"}], "]"}], "^", "p_."}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"b_.", "*", "x_"}], "]"}], "^", "p_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"a", "*", "x", "*", 
       RowBox[{
        RowBox[{"Log", "[", 
         RowBox[{"b", "*", "x"}], "]"}], "^", "p"}]}], "]"}], "/", "a"}], " ",
     "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{"p", ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"a", "*", "x", "*", 
           RowBox[{
            RowBox[{"Log", "[", 
             RowBox[{"b", "*", "x"}], "]"}], "^", "p"}]}], "]"}], "*", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"b", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817840791648*^9, 3.497818221872181*^9, 
   3.4978187399329066`*^9, {3.497921615088583*^9, 3.4979216452746363`*^9}, 
   3.497985551837408*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"p", ">", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4978182572522306`*^9, 
   3.497818281002264*^9}, {3.4978183492423596`*^9, 3.4978183713523903`*^9}, {
   3.497818911663147*^9, 3.497818912483148*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "n"], " ", 
      SuperscriptBox[
       RowBox[{"Log", "[", 
        RowBox[{"b", " ", "x"}], "]"}], "p"]}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Log", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"Cos", "[", 
         RowBox[{"a", " ", 
          SuperscriptBox["x", "n"], " ", 
          SuperscriptBox[
           RowBox[{"Log", "[", 
            RowBox[{"b", " ", "x"}], "]"}], "p"]}], "]"}], 
        RowBox[{"a", " ", "n", " ", 
         SuperscriptBox["x", 
          RowBox[{"n", "-", "1"}]]}]]}]}]}]}]}], "-", 
  "                              ", "\[IndentingNewLine]", 
  "                       ", 
  RowBox[{
   FractionBox["p", "n"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "n"], " ", 
       SuperscriptBox[
        RowBox[{"Log", "[", 
         RowBox[{"b", " ", "x"}], "]"}], "p"]}], "]"}], " ", 
     SuperscriptBox[
      RowBox[{"Log", "[", 
       RowBox[{"b", " ", "x"}], "]"}], 
      RowBox[{"p", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"n", "-", "1"}], 
    RowBox[{"a", " ", "n"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"Cos", "[", 
       RowBox[{"a", " ", 
        SuperscriptBox["x", "n"], " ", 
        SuperscriptBox[
         RowBox[{"Log", "[", 
          RowBox[{"b", " ", "x"}], "]"}], "p"]}], "]"}], 
      SuperscriptBox["x", "n"]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, 3.497816875700297*^9, 3.497816927160369*^9, {
   3.497817967231825*^9, 3.4978179825118465`*^9}, {3.4978183229423227`*^9, 
   3.4978183297523327`*^9}, 3.4978183882424145`*^9, 3.497818842933051*^9, {
   3.4978188819031053`*^9, 3.497818893043121*^9}, {3.4978455965785093`*^9, 
   3.497845617398538*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"a_.", "*", 
       RowBox[{"x_", "^", "n_"}], "*", 
       RowBox[{
        RowBox[{"Log", "[", 
         RowBox[{"b_.", "*", "x_"}], "]"}], "^", "p_."}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"b_.", "*", "x_"}], "]"}], "^", "p_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Cos", "[", 
       RowBox[{"a", "*", 
        RowBox[{"x", "^", "n"}], "*", 
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"b", "*", "x"}], "]"}], "^", "p"}]}], "]"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"a", "*", "n", "*", 
       RowBox[{"x", "^", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}]}], ")"}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"p", "/", "n"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"a", "*", 
           RowBox[{"x", "^", "n"}], "*", 
           RowBox[{
            RowBox[{"Log", "[", 
             RowBox[{"b", "*", "x"}], "]"}], "^", "p"}]}], "]"}], "*", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"b", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", "n"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"a", "*", 
           RowBox[{"x", "^", "n"}], "*", 
           RowBox[{
            RowBox[{"Log", "[", 
             RowBox[{"b", "*", "x"}], "]"}], "^", "p"}]}], "]"}], "/", 
         RowBox[{"x", "^", "n"}]}], ",", "x"}], "]"}]}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"n", ",", "p"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978178331616373`*^9, 3.497817943721792*^9, 3.497818214522171*^9, 
   3.4978182978122873`*^9, 3.497818743032911*^9, 3.4978188281930304`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"a_.", "*", 
       RowBox[{"x_", "^", "n_"}], "*", 
       RowBox[{
        RowBox[{"Log", "[", 
         RowBox[{"b_.", "*", "x_"}], "]"}], "^", "p_."}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"b_.", "*", "x_"}], "]"}], "^", "p_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"a", "*", 
       RowBox[{"x", "^", "n"}], "*", 
       RowBox[{
        RowBox[{"Log", "[", 
         RowBox[{"b", "*", "x"}], "]"}], "^", "p"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"a", "*", "n", "*", 
       RowBox[{"x", "^", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}]}], ")"}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"p", "/", "n"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"a", "*", 
           RowBox[{"x", "^", "n"}], "*", 
           RowBox[{
            RowBox[{"Log", "[", 
             RowBox[{"b", "*", "x"}], "]"}], "^", "p"}]}], "]"}], "*", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"b", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", "n"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"a", "*", 
           RowBox[{"x", "^", "n"}], "*", 
           RowBox[{
            RowBox[{"Log", "[", 
             RowBox[{"b", "*", "x"}], "]"}], "^", "p"}]}], "]"}], "/", 
         RowBox[{"x", "^", "n"}]}], ",", "x"}], "]"}]}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"n", ",", "p"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978178331616373`*^9, 3.497817943721792*^9, 3.497818214522171*^9, 
   3.4978182978122873`*^9, 3.497818743032911*^9, 3.4978188281930304`*^9, {
   3.497921615104183*^9, 3.4979216453058367`*^9}, 3.49798557554945*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], 
   RowBox[{"Sin", "[", 
    RowBox[{"a", " ", 
     SuperscriptBox["x", "n"], " ", 
     SuperscriptBox[
      RowBox[{"Log", "[", 
       RowBox[{"b", " ", "x"}], "]"}], "p"]}], "]"}], " ", 
   SuperscriptBox[
    RowBox[{"Log", "[", 
     RowBox[{"b", " ", "x"}], "]"}], "p"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978099162653446`*^9, 3.49780992018535*^9}, 
   3.497816868100286*^9, 3.4978178569916706`*^9, 3.4978181977321477`*^9, {
   3.497818713152869*^9, 3.4978187170428743`*^9}, 3.4978189740632343`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"p", ">", "0"}], " ", "\[And]", " ", 
    RowBox[{"m", "-", "n", "+", "1"}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4978182572522306`*^9, 
   3.497818281002264*^9}, {3.4978188033329954`*^9, 3.497818805922999*^9}, {
   3.497819708564263*^9, 3.497819716594274*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    RowBox[{"Sin", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "n"], " ", 
      SuperscriptBox[
       RowBox[{"Log", "[", 
        RowBox[{"b", " ", "x"}], "]"}], "p"]}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Log", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"Cos", "[", 
         RowBox[{"a", " ", 
          SuperscriptBox["x", "n"], " ", 
          SuperscriptBox[
           RowBox[{"Log", "[", 
            RowBox[{"b", " ", "x"}], "]"}], "p"]}], "]"}], 
        RowBox[{"a", " ", "n"}]]}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["p", "n"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "n"], " ", 
       SuperscriptBox[
        RowBox[{"Log", "[", 
         RowBox[{"b", " ", "x"}], "]"}], "p"]}], "]"}], " ", 
     SuperscriptBox[
      RowBox[{"Log", "[", 
       RowBox[{"b", " ", "x"}], "]"}], 
      RowBox[{"p", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, 3.4978168734802933`*^9, 3.497816906020339*^9, {
   3.49781786362168*^9, 3.4978178842317085`*^9}, 3.497818243732212*^9, 
   3.497818386462412*^9, {3.497818766582944*^9, 3.4978187902229767`*^9}, 
   3.497819037943324*^9, {3.497819072503372*^9, 3.4978190856033907`*^9}, 
   3.497819761524337*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"a_.", "*", 
       RowBox[{"x_", "^", "n_."}], "*", 
       RowBox[{
        RowBox[{"Log", "[", 
         RowBox[{"b_.", "*", "x_"}], "]"}], "^", "p_."}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"b_.", "*", "x_"}], "]"}], "^", "p_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Cos", "[", 
       RowBox[{"a", "*", 
        RowBox[{"x", "^", "n"}], "*", 
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"b", "*", "x"}], "]"}], "^", "p"}]}], "]"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"a", "*", "n"}], ")"}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"p", "/", "n"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"a", "*", 
           RowBox[{"x", "^", "n"}], "*", 
           RowBox[{
            RowBox[{"Log", "[", 
             RowBox[{"b", "*", "x"}], "]"}], "^", "p"}]}], "]"}], "*", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"b", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n", ",", "p"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "-", "n", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978178331616373`*^9, 3.497817943721792*^9, 3.497818214522171*^9, 
   3.4978182978122873`*^9, 3.497818743032911*^9, 3.4978188281930304`*^9, 
   3.497845658198595*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"a_.", "*", 
       RowBox[{"x_", "^", "n_."}], "*", 
       RowBox[{
        RowBox[{"Log", "[", 
         RowBox[{"b_.", "*", "x_"}], "]"}], "^", "p_."}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"b_.", "*", "x_"}], "]"}], "^", "p_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"a", "*", 
       RowBox[{"x", "^", "n"}], "*", 
       RowBox[{
        RowBox[{"Log", "[", 
         RowBox[{"b", "*", "x"}], "]"}], "^", "p"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"a", "*", "n"}], ")"}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"p", "/", "n"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"a", "*", 
           RowBox[{"x", "^", "n"}], "*", 
           RowBox[{
            RowBox[{"Log", "[", 
             RowBox[{"b", "*", "x"}], "]"}], "^", "p"}]}], "]"}], "*", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"b", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n", ",", "p"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "-", "n", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978178331616373`*^9, 3.497817943721792*^9, 3.497818214522171*^9, 
   3.4978182978122873`*^9, 3.497818743032911*^9, 3.4978188281930304`*^9, 
   3.497845658198595*^9, {3.4979216151197834`*^9, 3.4979216453214364`*^9}, 
   3.497985809830661*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"p", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"m", "-", "n", "+", "1"}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4978182572522306`*^9, 
   3.497818281002264*^9}, {3.4978188033329954`*^9, 3.497818805922999*^9}, {
   3.497819648964179*^9, 3.4978196804042234`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    RowBox[{"Sin", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "n"], " ", 
      SuperscriptBox[
       RowBox[{"Log", "[", 
        RowBox[{"b", " ", "x"}], "]"}], "p"]}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Log", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox["x", 
          RowBox[{"m", "-", "n", "+", "1"}]], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"a", " ", 
           SuperscriptBox["x", "n"], " ", 
           SuperscriptBox[
            RowBox[{"Log", "[", 
             RowBox[{"b", " ", "x"}], "]"}], "p"]}], "]"}]}], 
        RowBox[{"a", " ", "n"}]]}]}]}]}]}], "-", 
  "                                ", "\[IndentingNewLine]", "           ", 
  RowBox[{
   FractionBox["p", "n"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "n"], " ", 
       SuperscriptBox[
        RowBox[{"Log", "[", 
         RowBox[{"b", " ", "x"}], "]"}], "p"]}], "]"}], " ", 
     SuperscriptBox[
      RowBox[{"Log", "[", 
       RowBox[{"b", " ", "x"}], "]"}], 
      RowBox[{"p", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"m", "-", "n", "+", "1"}], 
    RowBox[{"a", " ", "n"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "n"}]], " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "n"], " ", 
       SuperscriptBox[
        RowBox[{"Log", "[", 
         RowBox[{"b", " ", "x"}], "]"}], "p"]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, 3.4978168734802933`*^9, 3.497816906020339*^9, {
   3.49781786362168*^9, 3.4978178842317085`*^9}, 3.497818243732212*^9, 
   3.497818386462412*^9, {3.497818766582944*^9, 3.4978187902229767`*^9}, 
   3.497819037943324*^9, {3.497819072503372*^9, 3.4978190856033907`*^9}, {
   3.4978457040786595`*^9, 3.497845706958664*^9}, {3.497846135109263*^9, 
   3.497846147789281*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"a_.", "*", 
       RowBox[{"x_", "^", "n_."}], "*", 
       RowBox[{
        RowBox[{"Log", "[", 
         RowBox[{"b_.", "*", "x_"}], "]"}], "^", "p_."}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"b_.", "*", "x_"}], "]"}], "^", "p_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"m", "-", "n", "+", "1"}], ")"}]}]}], "*", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"a", "*", 
        RowBox[{"x", "^", "n"}], "*", 
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"b", "*", "x"}], "]"}], "^", "p"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "n"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"p", "/", "n"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"a", "*", 
           RowBox[{"x", "^", "n"}], "*", 
           RowBox[{
            RowBox[{"Log", "[", 
             RowBox[{"b", "*", "x"}], "]"}], "^", "p"}]}], "]"}], "*", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"b", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "n", "+", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", "n"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "n"}], ")"}]}], "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"a", "*", 
           RowBox[{"x", "^", "n"}], "*", 
           RowBox[{
            RowBox[{"Log", "[", 
             RowBox[{"b", "*", "x"}], "]"}], "^", "p"}]}], "]"}]}], ",", 
        "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n", ",", "p"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "0"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "-", "n", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978178331616373`*^9, 3.497817943721792*^9, 3.497818214522171*^9, 
   3.4978182978122873`*^9, 3.497818743032911*^9, 3.4978188281930304`*^9, {
   3.497845658198595*^9, 3.497845675068619*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"a_.", "*", 
       RowBox[{"x_", "^", "n_."}], "*", 
       RowBox[{
        RowBox[{"Log", "[", 
         RowBox[{"b_.", "*", "x_"}], "]"}], "^", "p_."}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"b_.", "*", "x_"}], "]"}], "^", "p_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "n", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"a", "*", 
        RowBox[{"x", "^", "n"}], "*", 
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"b", "*", "x"}], "]"}], "^", "p"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "n"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"p", "/", "n"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"a", "*", 
           RowBox[{"x", "^", "n"}], "*", 
           RowBox[{
            RowBox[{"Log", "[", 
             RowBox[{"b", "*", "x"}], "]"}], "^", "p"}]}], "]"}], "*", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"b", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "n", "+", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", "n"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "n"}], ")"}]}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"a", "*", 
           RowBox[{"x", "^", "n"}], "*", 
           RowBox[{
            RowBox[{"Log", "[", 
             RowBox[{"b", "*", "x"}], "]"}], "^", "p"}]}], "]"}]}], ",", 
        "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n", ",", "p"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "0"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "-", "n", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978178331616373`*^9, 3.497817943721792*^9, 3.497818214522171*^9, 
   3.4978182978122873`*^9, 3.497818743032911*^9, 3.4978188281930304`*^9, {
   3.497845658198595*^9, 3.497845675068619*^9}, {3.4979216151509833`*^9, 
   3.497921645337036*^9}, {3.497985717369299*^9, 3.4979857479453526`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, 3.5000652014948616`*^9, 
   3.500071919760484*^9, 3.5000742351937256`*^9, {3.5000764530668306`*^9, 
   3.5000764698568544`*^9}, {3.5156061721620646`*^9, 3.515606175192069*^9}, {
   3.515784590296414*^9, 3.5157845913564153`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, {3.4978169434003916`*^9, 
   3.497816948440398*^9}, 3.497820003054675*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sin", "[", "z", "]"}], "2"], "=", 
   RowBox[{
    FractionBox["1", "2"], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", "z"}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, {3.497816982770447*^9, 3.4978170004804716`*^9}, {
   3.4978200170946946`*^9, 3.497820027074709*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"n", "-", "1"}], "2"], "\[NotElement]", 
   "\[DoubleStruckCapitalZ]"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, 3.497639786159789*^9, {3.4976636687943316`*^9, 
   3.497663674238741*^9}, 3.500065336645051*^9, {3.5000653831351156`*^9, 
   3.5000653931651297`*^9}, {3.5000654310051827`*^9, 3.500065453315214*^9}, {
   3.500069687963237*^9, 3.5000696889460382`*^9}, 3.5000699834433556`*^9, {
   3.500073956083335*^9, 3.5000740306834393`*^9}, {3.500074095863531*^9, 
   3.5000741212435665`*^9}, {3.5000741522836094`*^9, 
   3.5000741751536417`*^9}, {3.500074221103706*^9, 3.500074221103706*^9}, 
   3.500074503914102*^9, {3.500089709186855*^9, 3.5000897361468925`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{
       FractionBox["a", "2"], "+", 
       FractionBox[
        RowBox[{"b", " ", "x"}], "2"]}], "]"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "2"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, 3.4978168734802933`*^9, 3.497816906020339*^9, {
   3.49781786362168*^9, 3.4978178842317085`*^9}, {3.4978200683047667`*^9, 
   3.4978200791447816`*^9}, {3.500079530261139*^9, 3.500079575451202*^9}, {
   3.5000796205012655`*^9, 3.500079671061336*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "2"}], "*", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], "]"}], "^", "n"}], ",", "x"}], "]"}]}], 
     "]"}], " ", "-", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], "]"}], "*", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", "n"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"c", "-", 
      RowBox[{"a", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{"b", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"OddQ", "[", "n", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817840791648*^9, 3.497819954544607*^9, {
   3.500077639438492*^9, 3.5000776443384986`*^9}, {3.500079737691429*^9, 
   3.500079771871477*^9}, {3.500079835841567*^9, 3.5000799106916714`*^9}, {
   3.5000799437417173`*^9, 3.500079972731758*^9}, {3.5000800254818325`*^9, 
   3.5000800531018705`*^9}, {3.500080550942568*^9, 3.500080551872569*^9}, {
   3.5000896569567814`*^9, 3.50008966290679*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, {3.4978169434003916`*^9, 
   3.497816948440398*^9}, 3.497820003054675*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox[
    RowBox[{"Cos", "[", "z", "]"}], "2"], "=", 
   RowBox[{
    FractionBox["1", "2"], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", "z"}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, {3.497816982770447*^9, 3.4978170004804716`*^9}, {
   3.4978200170946946`*^9, 3.497820027074709*^9}, {3.5000813814137306`*^9, 
   3.5000813899437428`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"n", "-", "1"}], "2"], "\[NotElement]", 
   "\[DoubleStruckCapitalZ]"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, 3.497639786159789*^9, {3.4976636687943316`*^9, 
   3.497663674238741*^9}, 3.500065336645051*^9, {3.5000653831351156`*^9, 
   3.5000653931651297`*^9}, {3.5000654310051827`*^9, 3.500065453315214*^9}, {
   3.500069687963237*^9, 3.5000696889460382`*^9}, 3.5000699834433556`*^9, {
   3.500073956083335*^9, 3.5000740306834393`*^9}, {3.500074095863531*^9, 
   3.5000741212435665`*^9}, {3.5000741522836094`*^9, 
   3.5000741751536417`*^9}, {3.500074221103706*^9, 3.500074221103706*^9}, 
   3.500074503914102*^9, {3.500089709186855*^9, 3.5000897361468925`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Cos", "[", 
      RowBox[{
       FractionBox["a", "2"], "+", 
       FractionBox[
        RowBox[{"b", " ", "x"}], "2"]}], "]"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "2"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, 3.4978168734802933`*^9, 3.497816906020339*^9, {
   3.49781786362168*^9, 3.4978178842317085`*^9}, {3.4978200683047667`*^9, 
   3.4978200791447816`*^9}, {3.500079530261139*^9, 3.500079575451202*^9}, {
   3.5000796205012655`*^9, 3.500079671061336*^9}, {3.5000813766037235`*^9, 
   3.500081376903724*^9}, 3.5000814134937754`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "2"}], "*", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], "]"}], "^", "n"}], ",", "x"}], "]"}]}], 
     "]"}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], "]"}], "*", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", "n"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"c", "-", 
      RowBox[{"a", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{"b", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"OddQ", "[", "n", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817840791648*^9, 3.497819954544607*^9, {
   3.500077639438492*^9, 3.5000776443384986`*^9}, {3.500079737691429*^9, 
   3.500079771871477*^9}, {3.500079835841567*^9, 3.5000799106916714`*^9}, {
   3.5000799437417173`*^9, 3.500079972731758*^9}, {3.5000800254818325`*^9, 
   3.5000800531018705`*^9}, {3.500080550942568*^9, 3.500080551872569*^9}, {
   3.500081409033769*^9, 3.500081449713826*^9}, {3.5000816225140676`*^9, 
   3.50008162382407*^9}, 3.5000896736668053`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.4978080875027843`*^9, {
   3.500071601450039*^9, 3.500071603130041*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"2", " ", "z"}], "]"}], "=", 
   RowBox[{"2", " ", 
    RowBox[{"Sin", "[", "z", "]"}], " ", 
    RowBox[{"Cos", "[", "z", "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.4978080875027843`*^9, {
   3.500071601450039*^9, 3.5000716499501066`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 " and ",
 Cell[BoxData["u"]],
 " is a function of trig functions of ",
 Cell[BoxData[
  RowBox[{
   FractionBox["a", "2"], "+", 
   FractionBox[
    RowBox[{"b", " ", "x"}], "2"]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, 3.497639786159789*^9, {3.4976636687943316`*^9, 
   3.497663674238741*^9}, 3.500065336645051*^9, {3.5000653831351156`*^9, 
   3.5000653931651297`*^9}, {3.5000654310051827`*^9, 3.500065453315214*^9}, {
   3.500069687963237*^9, 3.5000696889460382`*^9}, 3.5000699834433556`*^9, {
   3.500073956083335*^9, 3.5000740306834393`*^9}, {3.500074095863531*^9, 
   3.5000741212435665`*^9}, {3.5000741522836094`*^9, 
   3.5000741751536417`*^9}, {3.500074221103706*^9, 3.500074221103706*^9}, 
   3.500074503914102*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     SuperscriptBox["2", "n"]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{"u", " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", 
       RowBox[{
        FractionBox["a", "2"], "+", 
        FractionBox[
         RowBox[{"b", " ", "x"}], "2"]}], "]"}], "n"], " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{
        FractionBox["a", "2"], "+", 
        FractionBox[
         RowBox[{"b", " ", "x"}], "2"]}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, {
   3.4976637183712187`*^9, 3.4976637616924944`*^9}, {3.5000653173450236`*^9, 
   3.500065324625034*^9}, {3.5000653616850853`*^9, 3.500065367505094*^9}, 
   3.5000654791452503`*^9, {3.5000694620376396`*^9, 3.5000695288585577`*^9}, {
   3.500069754013753*^9, 3.500069772031784*^9}, {3.500069828737884*^9, 
   3.500069930574863*^9}, {3.5000700029901905`*^9, 3.500070007950999*^9}, {
   3.500070067407891*^9, 3.5000700989979353`*^9}, 3.5000701914680643`*^9, {
   3.500073895743251*^9, 3.5000739445333185`*^9}, {3.500074199563676*^9, 
   3.500074208003688*^9}, {3.5000744727540584`*^9, 3.500074501224098*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"2", "^", "n"}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{"a", "/", "2"}], "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "/", "2"}]}]}], "]"}], "^", "n"}], "*", 
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"a", "/", "2"}], "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "/", "2"}]}]}], "]"}], "^", "n"}]}], ",", "x"}], 
      "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "/", "2"}], "+", 
      RowBox[{"b", "*", 
       RowBox[{"x", "/", "2"}]}], "-", 
      RowBox[{"FunctionOfTrig", "[", 
       RowBox[{"u", ",", "x"}], "]"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497663376917819*^9, 3.4976636476250944`*^9, 
   3.500065332175044*^9, 3.500065376815107*^9, 3.500065423255172*^9, {
   3.500069566860224*^9, 3.500069658276385*^9}, {3.5000697782405953`*^9, 
   3.5000697862434096`*^9}, {3.500069950168497*^9, 3.500069992132571*^9}, {
   3.5000701293779774`*^9, 3.5000701415479946`*^9}, 3.5000701855880566`*^9, {
   3.5000702333881235`*^9, 3.5000702407681336`*^9}, 3.500070898259054*^9, {
   3.5000740600034804`*^9, 3.5000740914935246`*^9}, {3.5000742130736947`*^9, 
   3.5000742163036995`*^9}, {3.500074399503956*^9, 3.500074433484003*^9}, {
   3.5000745170941205`*^9, 3.500074525404132*^9}, {3.500074568174192*^9, 
   3.500074670514335*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["\<\
Derivation: Algebraic simplification and piecewise constant extraction\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.4978080875027843`*^9, {
   3.500071601450039*^9, 3.500071603130041*^9}, {3.50008290223586*^9, 
   3.5000829156258783`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"2", " ", "z"}], "]"}], "=", 
   RowBox[{"2", " ", 
    RowBox[{"Sin", "[", "z", "]"}], " ", 
    RowBox[{"Cos", "[", "z", "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.4978080875027843`*^9, {
   3.500071601450039*^9, 3.5000716499501066`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[Cell[TextData[Cell[BoxData[
   RowBox[{
    RowBox[{
     SubscriptBox["\[PartialD]", "x"], 
     FractionBox[
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{
          FractionBox["a", "2"], "+", 
          FractionBox[
           RowBox[{"b", " ", "x"}], "2"]}], "]"}], "n"], " ", 
       SuperscriptBox[
        RowBox[{"Cos", "[", 
         RowBox[{
          FractionBox["a", "2"], "+", 
          FractionBox[
           RowBox[{"b", " ", "x"}], "2"]}], "]"}], "n"]}]]}], "=", "0"}]],
   CellDingbat->None,
   CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
     3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
     3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
     3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
     3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
     3.4796622450654173`*^9}, {3.479686720424531*^9, 
     3.4796867204345455`*^9}, {3.4796874646646957`*^9, 
     3.4796874745589232`*^9}, {3.492826573513727*^9, 3.492826578630536*^9}, {
     3.4928267070863624`*^9, 3.492826707460763*^9}, 3.4928267903497095`*^9, {
     3.492829799151373*^9, 3.4928299617216005`*^9}, {3.4940972077187414`*^9, 
     3.4940972347887793`*^9}, {3.496441851501421*^9, 3.496441872881451*^9}, {
     3.496528916553913*^9, 3.4965289272239285`*^9}, {3.497576165747217*^9, 
     3.4975761801372375`*^9}, {3.497577761382057*^9, 3.4975777938921027`*^9}, 
     3.49763959300025*^9, 3.497639634480723*^9, {3.4976637183712187`*^9, 
     3.4976637616924944`*^9}, {3.5000653173450236`*^9, 
     3.500065324625034*^9}, {3.5000653616850853`*^9, 3.500065367505094*^9}, 
     3.5000654791452503`*^9, {3.5000694620376396`*^9, 
     3.5000695288585577`*^9}, {3.500069754013753*^9, 3.500069772031784*^9}, {
     3.500069828737884*^9, 3.500069930574863*^9}, {3.5000700029901905`*^9, 
     3.500070007950999*^9}, {3.500070067407891*^9, 3.5000700989979353`*^9}, 
     3.5000701914680643`*^9, {3.500073895743251*^9, 3.5000739445333185`*^9}, {
     3.500074199563676*^9, 3.500074208003688*^9}, {3.5000744727540584`*^9, 
     3.500074501224098*^9}, 3.500082863385805*^9},
   TextAlignment->Center,
   FontSize->12,
   FontWeight->"Bold"]], "Subsubsection",
   CellChangeTimes->{
    3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
     3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
     3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
     3.497639710530856*^9, 3.497727769376384*^9, 3.4978080875027843`*^9, {
     3.500071601450039*^9, 3.5000716499501066`*^9}}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.4978080875027843`*^9, {
   3.500071601450039*^9, 3.5000716499501066`*^9}, {3.500083019276024*^9, 
   3.500083048196064*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 " and ",
 Cell[BoxData["u"]],
 " is a function of trig functions of ",
 Cell[BoxData[
  RowBox[{
   FractionBox["a", "2"], "+", 
   FractionBox[
    RowBox[{"b", " ", "x"}], "2"]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, 3.497639786159789*^9, {3.4976636687943316`*^9, 
   3.497663674238741*^9}, 3.500065336645051*^9, {3.5000653831351156`*^9, 
   3.5000653931651297`*^9}, {3.5000654310051827`*^9, 3.500065453315214*^9}, {
   3.500069687963237*^9, 3.5000696889460382`*^9}, 3.5000699834433556`*^9, {
   3.500073956083335*^9, 3.5000740306834393`*^9}, {3.500074095863531*^9, 
   3.5000741212435665`*^9}, {3.5000741522836094`*^9, 
   3.5000741751536417`*^9}, {3.500074221103706*^9, 3.500074221103706*^9}, 
   3.500074503914102*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{
          FractionBox["a", "2"], "+", 
          FractionBox[
           RowBox[{"b", " ", "x"}], "2"]}], "]"}], "n"], " ", 
       SuperscriptBox[
        RowBox[{"Cos", "[", 
         RowBox[{
          FractionBox["a", "2"], "+", 
          FractionBox[
           RowBox[{"b", " ", "x"}], "2"]}], "]"}], "n"]}]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{"u", " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", 
       RowBox[{
        FractionBox["a", "2"], "+", 
        FractionBox[
         RowBox[{"b", " ", "x"}], "2"]}], "]"}], "n"], " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{
        FractionBox["a", "2"], "+", 
        FractionBox[
         RowBox[{"b", " ", "x"}], "2"]}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, {
   3.4976637183712187`*^9, 3.4976637616924944`*^9}, {3.5000653173450236`*^9, 
   3.500065324625034*^9}, {3.5000653616850853`*^9, 3.500065367505094*^9}, 
   3.5000654791452503`*^9, {3.5000694620376396`*^9, 3.5000695288585577`*^9}, {
   3.500069754013753*^9, 3.500069772031784*^9}, {3.500069828737884*^9, 
   3.500069930574863*^9}, {3.5000700029901905`*^9, 3.500070007950999*^9}, {
   3.500070067407891*^9, 3.5000700989979353`*^9}, 3.5000701914680643`*^9, {
   3.500073895743251*^9, 3.5000739445333185`*^9}, {3.500074199563676*^9, 
   3.500074208003688*^9}, {3.5000744727540584`*^9, 3.500074501224098*^9}, 
   3.500082863385805*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"u_", "*", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", 
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"a", "/", "2"}], "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "/", "2"}]}]}], "]"}], "^", "n"}], "*", 
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{"a", "/", "2"}], "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "/", "2"}]}]}], "]"}], "^", "n"}]}], ")"}]}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{"a", "/", "2"}], "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "/", "2"}]}]}], "]"}], "^", "n"}], "*", 
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"a", "/", "2"}], "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "/", "2"}]}]}], "]"}], "^", "n"}]}], ",", "x"}], 
      "]"}]}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
     RowBox[{"FractionQ", "[", "n", "]"}], " ", "&&", " ", 
     RowBox[{"ZeroQ", "[", 
      RowBox[{
       RowBox[{"a", "/", "2"}], "+", 
       RowBox[{"b", "*", 
        RowBox[{"x", "/", "2"}]}], "-", 
       RowBox[{"FunctionOfTrig", "[", 
        RowBox[{"u", ",", "x"}], "]"}]}], "]"}]}]}]}], " ", "*)"}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497663376917819*^9, 3.4976636476250944`*^9, 
   3.500065332175044*^9, 3.500065376815107*^9, 3.500065423255172*^9, {
   3.500069566860224*^9, 3.500069658276385*^9}, {3.5000697782405953`*^9, 
   3.5000697862434096`*^9}, {3.500069950168497*^9, 3.500069992132571*^9}, {
   3.5000701293779774`*^9, 3.5000701415479946`*^9}, 3.5000701855880566`*^9, {
   3.5000702333881235`*^9, 3.5000702407681336`*^9}, 3.500070898259054*^9, {
   3.5000740600034804`*^9, 3.5000740914935246`*^9}, {3.5000742130736947`*^9, 
   3.5000742163036995`*^9}, {3.500074399503956*^9, 3.500074433484003*^9}, {
   3.5000745170941205`*^9, 3.500074525404132*^9}, {3.500074568174192*^9, 
   3.500074670514335*^9}, {3.500082744745639*^9, 3.5000827461456413`*^9}, 
   3.5000831099761505`*^9, {3.5000836307068796`*^9, 3.5000836393968916`*^9}, 
   3.5000843495178857`*^9, {3.5000888540856576`*^9, 3.500088866275675*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", "v", "]"}], "2"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978099162653446`*^9, 3.49780992018535*^9}, 
   3.497816868100286*^9, 3.4978178569916706`*^9, 3.497819935984581*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, {3.4978169434003916`*^9, 
   3.497816948440398*^9}, 3.497820003054675*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sin", "[", "z", "]"}], "2"], "=", 
   RowBox[{
    FractionBox["1", "2"], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", "z"}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, {3.497816982770447*^9, 3.4978170004804716`*^9}, {
   3.4978200170946946`*^9, 3.497820027074709*^9}}],

Cell[TextData[{
 "Rule: If ",
 Cell[BoxData["u"]],
 " is a function of trig functions of ",
 Cell[BoxData[
  RowBox[{"2", " ", "v"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4978200878947935`*^9, 
   3.497820134594859*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{"u", " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "v", "]"}], "2"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "2"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{"u", 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{"u", " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", "v"}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, 3.4978168734802933`*^9, 3.497816906020339*^9, {
   3.49781786362168*^9, 3.4978178842317085`*^9}, {3.4978200683047667`*^9, 
   3.4978200791447816`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"u_", "*", 
      RowBox[{
       RowBox[{"Sin", "[", "v_", "]"}], "^", "2"}]}], ",", "x_Symbol"}], 
    "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{"Dist", "[", 
      RowBox[{
       RowBox[{"1", "/", "2"}], ",", 
       RowBox[{"Int", "[", 
        RowBox[{"u", ",", "x"}], "]"}]}], "]"}], " ", "-", " ", "\n", "  ", 
     RowBox[{"Dist", "[", 
      RowBox[{
       RowBox[{"1", "/", "2"}], ",", 
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"u", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{"2", "*", "v"}], "]"}]}], ",", "x"}], "]"}]}], "]"}]}], 
    " ", "/;", "\n", 
    RowBox[{"FunctionOfTrigQ", "[", 
     RowBox[{"u", ",", 
      RowBox[{"2", "*", "v"}], ",", "x"}], "]"}]}]}], " ", "*)"}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817840791648*^9, 3.497819954544607*^9, {
   3.500077639438492*^9, 3.5000776443384986`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"u_", "*", 
      RowBox[{
       RowBox[{"Cos", "[", "v_", "]"}], "^", "2"}]}], ",", "x_Symbol"}], 
    "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{"Dist", "[", 
      RowBox[{
       RowBox[{"1", "/", "2"}], ",", 
       RowBox[{"Int", "[", 
        RowBox[{"u", ",", "x"}], "]"}]}], "]"}], " ", "+", " ", "\n", "  ", 
     RowBox[{"Dist", "[", 
      RowBox[{
       RowBox[{"1", "/", "2"}], ",", 
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"u", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{"2", "*", "v"}], "]"}]}], ",", "x"}], "]"}]}], "]"}]}], 
    " ", "/;", "\n", 
    RowBox[{"FunctionOfTrigQ", "[", 
     RowBox[{"u", ",", 
      RowBox[{"2", "*", "v"}], ",", "x"}], "]"}]}]}], " ", "*)"}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817840791648*^9, 3.497819954544607*^9, {
   3.4979216151821833`*^9, 3.4979216453682365`*^9}, 3.4979859877957735`*^9, {
   3.500077969128953*^9, 3.500077973058959*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]]
},
AutoGeneratedPackage->Automatic,
CellGrouping->Manual,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  "Integration Rules for Sine Functions", None, None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->28.8},
Magnification->1.399999976158142,
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 1376, 29, 118, "Title"],
Cell[1946, 53, 349, 5, 5200, "Subsubsection"],
Cell[2298, 60, 955, 28, 6150, "Subsubsection"],
Cell[3256, 90, 1378, 28, 3830, "Subsubsection"],
Cell[4637, 120, 1597, 42, 9249, "Subsubtitle"],
Cell[6237, 164, 771, 11, 5200, "Subsubsection"],
Cell[7011, 177, 1902, 55, 15903, "Code"],
Cell[8916, 234, 89, 2, 5200, "Subsubsection"],
Cell[9008, 238, 422, 7, 3564, "Subsubsection"],
Cell[9433, 247, 1007, 29, 6150, "Subsubsection"],
Cell[10443, 278, 1047, 31, 8096, "Subsubsection"],
Cell[11493, 311, 1375, 28, 5797, "Subsubsection"],
Cell[12871, 341, 2605, 67, 13648, "Subsubtitle"],
Cell[15479, 410, 771, 11, 5200, "Subsubsection"],
Cell[16253, 423, 2747, 80, 19822, "Code"],
Cell[19003, 505, 89, 2, 5200, "Subsubsection"],
Cell[19095, 509, 401, 6, 3564, "Subsubsection"],
Cell[19499, 517, 1319, 40, 6348, "Subsubsection"],
Cell[20821, 559, 1200, 22, 3830, "Subsubsection"],
Cell[22024, 583, 2632, 68, 9641, "Subsubtitle"],
Cell[24659, 653, 771, 11, 5200, "Subsubsection"],
Cell[25433, 666, 2492, 73, 19822, "Code"],
Cell[27928, 741, 89, 2, 5200, "Subsubsection"],
Cell[28020, 745, 401, 6, 3564, "Subsubsection"],
Cell[28424, 753, 1091, 26, 6964, "Subsubsection"],
Cell[29518, 781, 1441, 27, 5200, "Subsubsection"],
Cell[30962, 810, 2654, 61, 10337, "Subsubtitle"],
Cell[33619, 873, 771, 11, 5200, "Subsubsection"],
Cell[34393, 886, 2670, 72, 15903, "Code"],
Cell[37066, 960, 44, 1, 377, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[37147, 966, 1400, 29, 80, "Title"],
Cell[38550, 997, 349, 5, 5200, "Subsubsection"],
Cell[38902, 1004, 1131, 32, 5935, "Subsubsection"],
Cell[40036, 1038, 469, 9, 3564, "Subsubsection"],
Cell[40508, 1049, 1382, 28, 3830, "Subsubsection"],
Cell[41893, 1079, 1775, 46, 9099, "Subsubtitle"],
Cell[43671, 1127, 771, 11, 5200, "Subsubsection"],
Cell[44445, 1140, 2097, 58, 15903, "Code"],
Cell[46545, 1200, 89, 2, 5200, "Subsubsection"],
Cell[46637, 1204, 349, 5, 3564, "Subsubsection"],
Cell[46989, 1211, 749, 18, 5935, "Subsubsection"],
Cell[47741, 1231, 1378, 26, 3830, "Subsubsection"],
Cell[49122, 1259, 1573, 40, 9099, "Subsubtitle"],
Cell[50698, 1301, 771, 11, 5200, "Subsubsection"],
Cell[51472, 1314, 1777, 50, 15903, "Code"],
Cell[53252, 1366, 89, 2, 5200, "Subsubsection"],
Cell[53344, 1370, 349, 5, 3564, "Subsubsection"],
Cell[53696, 1377, 799, 18, 5935, "Subsubsection"],
Cell[54498, 1397, 1406, 27, 3830, "Subsubsection"],
Cell[55907, 1426, 1597, 40, 9099, "Subsubtitle"],
Cell[57507, 1468, 771, 11, 5200, "Subsubsection"],
Cell[58281, 1481, 1801, 50, 15903, "Code"],
Cell[60085, 1533, 89, 2, 5200, "Subsubsection"],
Cell[60177, 1537, 422, 7, 3564, "Subsubsection"],
Cell[60602, 1546, 1158, 31, 5935, "Subsubsection"],
Cell[61763, 1579, 1197, 33, 7799, "Subsubsection"],
Cell[62963, 1614, 469, 9, 3564, "Subsubsection"],
Cell[63435, 1625, 1375, 28, 5797, "Subsubsection"],
Cell[64813, 1655, 2883, 74, 13497, "Subsubtitle"],
Cell[67699, 1731, 771, 11, 5200, "Subsubsection"],
Cell[68473, 1744, 3051, 85, 19822, "Code"],
Cell[71527, 1831, 89, 2, 5200, "Subsubsection"],
Cell[71619, 1835, 349, 5, 3564, "Subsubsection"],
Cell[71971, 1842, 749, 18, 5935, "Subsubsection"],
Cell[72723, 1862, 849, 21, 7505, "Subsubsection"],
Cell[73575, 1885, 1426, 27, 5797, "Subsubsection"],
Cell[75004, 1914, 2034, 55, 13497, "Subsubtitle"],
Cell[77041, 1971, 771, 11, 5200, "Subsubsection"],
Cell[77815, 1984, 2326, 67, 15903, "Code"],
Cell[80144, 2053, 89, 2, 5200, "Subsubsection"],
Cell[80236, 2057, 349, 5, 3564, "Subsubsection"],
Cell[80588, 2064, 773, 18, 5935, "Subsubsection"],
Cell[81364, 2084, 873, 21, 7505, "Subsubsection"],
Cell[82240, 2107, 1480, 28, 5797, "Subsubsection"],
Cell[83723, 2137, 2058, 55, 13497, "Subsubtitle"],
Cell[85784, 2194, 771, 11, 5200, "Subsubsection"],
Cell[86558, 2207, 2350, 68, 15903, "Code"],
Cell[88911, 2277, 89, 2, 5200, "Subsubsection"],
Cell[89003, 2281, 401, 6, 3564, "Subsubsection"],
Cell[89407, 2289, 1319, 40, 6348, "Subsubsection"],
Cell[90729, 2331, 1200, 22, 3830, "Subsubsection"],
Cell[91932, 2355, 2682, 68, 9641, "Subsubtitle"],
Cell[94617, 2425, 771, 11, 5200, "Subsubsection"],
Cell[95391, 2438, 2570, 74, 19822, "Code"],
Cell[97964, 2514, 89, 2, 5200, "Subsubsection"],
Cell[98056, 2518, 401, 6, 3564, "Subsubsection"],
Cell[98460, 2526, 1133, 27, 6964, "Subsubsection"],
Cell[99596, 2555, 1499, 28, 5200, "Subsubsection"],
Cell[101098, 2585, 2638, 61, 10337, "Subsubtitle"],
Cell[103739, 2648, 771, 11, 5200, "Subsubsection"],
Cell[104513, 2661, 2726, 73, 15903, "Code"],
Cell[107242, 2736, 44, 1, 377, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[107323, 2742, 1459, 30, 80, "Title"],
Cell[108785, 2774, 380, 5, 93, "Subsubsection"],
Cell[109168, 2781, 599, 17, 99, "Subsubsection"],
Cell[109770, 2800, 542, 9, 65, "Subsubsection"],
Cell[110315, 2811, 1500, 27, 69, "Subsubsection"],
Cell[111818, 2840, 2006, 45, 159, "Subsubtitle"],
Cell[113827, 2887, 771, 11, 93, "Subsubsection"],
Cell[114601, 2900, 2066, 52, 282, "Code"],
Cell[116670, 2954, 2111, 52, 310, "Code"],
Cell[118784, 3008, 89, 2, 93, "Subsubsection"],
Cell[118876, 3012, 349, 5, 65, "Subsubsection"],
Cell[119228, 3019, 599, 17, 99, "Subsubsection"],
Cell[119830, 3038, 542, 9, 65, "Subsubsection"],
Cell[120375, 3049, 1196, 22, 69, "Subsubsection"],
Cell[121574, 3073, 1604, 41, 159, "Subsubtitle"],
Cell[123181, 3116, 771, 11, 93, "Subsubsection"],
Cell[123955, 3129, 2308, 63, 282, "Code"],
Cell[126266, 3194, 2391, 63, 310, "Code"],
Cell[128660, 3259, 44, 1, 8, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[128741, 3265, 1132, 23, 80, "Title"],
Cell[129876, 3290, 194, 3, 5200, "Subsubsection"],
Cell[130073, 3295, 497, 15, 6348, "Subsubsection"],
Cell[130573, 3312, 763, 11, 3564, "Subsubsection"],
Cell[131339, 3325, 1023, 28, 20239, "Subsubtitle"],
Cell[132365, 3355, 771, 11, 5200, "Subsubsection"],
Cell[133139, 3368, 952, 27, 15903, "Code"],
Cell[134094, 3397, 1002, 28, 17494, "Code"],
Cell[135099, 3427, 89, 2, 5200, "Subsubsection"],
Cell[135191, 3431, 223, 3, 3564, "Subsubsection"],
Cell[135417, 3436, 572, 17, 3830, "Subsubsection"],
Cell[135992, 3455, 815, 11, 3564, "Subsubsection"],
Cell[136810, 3468, 1756, 41, 8096, "Subsubtitle"],
Cell[138569, 3511, 771, 11, 5200, "Subsubsection"],
Cell[139343, 3524, 1240, 37, 19822, "Code"],
Cell[140586, 3563, 1316, 38, 21398, "Code"],
Cell[141905, 3603, 89, 2, 5200, "Subsubsection"],
Cell[141997, 3607, 223, 3, 3564, "Subsubsection"],
Cell[142223, 3612, 712, 19, 5539, "Subsubsection"],
Cell[142938, 3633, 1096, 22, 3830, "Subsubsection"],
Cell[144037, 3657, 2033, 46, 9099, "Subsubtitle"],
Cell[146073, 3705, 771, 11, 5200, "Subsubsection"],
Cell[146847, 3718, 1617, 48, 19822, "Code"],
Cell[148467, 3768, 766, 21, 6984, "Subsubsection"],
Cell[149236, 3791, 1666, 49, 19822, "Code"],
Cell[150905, 3842, 89, 2, 5200, "Subsubsection"],
Cell[150997, 3846, 250, 4, 3564, "Subsubsection"],
Cell[151250, 3852, 443, 8, 3564, "Subsubsection"],
Cell[151696, 3862, 1091, 20, 3830, "Subsubsection"],
Cell[152790, 3884, 1778, 40, 8096, "Subsubtitle"],
Cell[154571, 3926, 771, 11, 5200, "Subsubsection"],
Cell[155345, 3939, 1384, 40, 19822, "Code"],
Cell[156732, 3981, 1465, 41, 21398, "Code"],
Cell[158200, 4024, 44, 1, 377, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[158281, 4030, 1192, 25, 80, "Title"],
Cell[159476, 4057, 194, 3, 5200, "Subsubsection"],
Cell[159673, 4062, 464, 13, 5539, "Subsubsection"],
Cell[160140, 4077, 763, 11, 3564, "Subsubsection"],
Cell[160906, 4090, 1036, 24, 9777, "Subsubtitle"],
Cell[161945, 4116, 771, 11, 5200, "Subsubsection"],
Cell[162719, 4129, 838, 22, 15903, "Code"],
Cell[163560, 4153, 966, 24, 17494, "Code"],
Cell[164529, 4179, 89, 2, 5200, "Subsubsection"],
Cell[164621, 4183, 223, 3, 3564, "Subsubsection"],
Cell[164847, 4188, 572, 17, 3830, "Subsubsection"],
Cell[165422, 4207, 815, 11, 3564, "Subsubsection"],
Cell[166240, 4220, 1914, 45, 9777, "Subsubtitle"],
Cell[168157, 4267, 771, 11, 5200, "Subsubsection"],
Cell[168931, 4280, 1402, 41, 19822, "Code"],
Cell[170336, 4323, 1478, 42, 21398, "Code"],
Cell[171817, 4367, 89, 2, 5200, "Subsubsection"],
Cell[171909, 4371, 249, 4, 3564, "Subsubsection"],
Cell[172161, 4377, 250, 4, 3564, "Subsubsection"],
Cell[172414, 4383, 889, 27, 6964, "Subsubsection"],
Cell[173306, 4412, 1113, 20, 3830, "Subsubsection"],
Cell[174422, 4434, 2124, 51, 10067, "Subsubtitle"],
Cell[176549, 4487, 771, 11, 5200, "Subsubsection"],
Cell[177323, 4500, 1922, 56, 19822, "Code"],
Cell[179248, 4558, 273, 4, 5200, "Subsubsection"],
Cell[179524, 4564, 1971, 56, 19822, "Code"],
Cell[181498, 4622, 89, 2, 5200, "Subsubsection"],
Cell[181590, 4626, 273, 4, 3564, "Subsubsection"],
Cell[181866, 4632, 372, 5, 3564, "Subsubsection"],
Cell[182241, 4639, 1622, 35, 3830, "Subsubsection"],
Cell[183866, 4676, 2091, 50, 10067, "Subsubtitle"],
Cell[185960, 4728, 771, 11, 5200, "Subsubsection"],
Cell[186734, 4741, 2315, 68, 19822, "Code"],
Cell[189052, 4811, 295, 4, 5200, "Subsubsection"],
Cell[189350, 4817, 2389, 69, 19822, "Code"],
Cell[191742, 4888, 89, 2, 5200, "Subsubsection"],
Cell[191834, 4892, 295, 4, 3564, "Subsubsection"],
Cell[192132, 4898, 784, 20, 5539, "Subsubsection"],
Cell[192919, 4920, 1594, 33, 3830, "Subsubsection"],
Cell[194516, 4955, 2239, 51, 9099, "Subsubtitle"],
Cell[196758, 5008, 771, 11, 5200, "Subsubsection"],
Cell[197532, 5021, 2201, 62, 23664, "Code"],
Cell[199736, 5085, 832, 22, 6984, "Subsubsection"],
Cell[200571, 5109, 2270, 63, 23664, "Code"],
Cell[202844, 5174, 44, 1, 377, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[202925, 5180, 1243, 26, 80, "Title"],
Cell[204171, 5208, 224, 3, 5200, "Subsubsection"],
Cell[204398, 5213, 1198, 24, 3830, "Subsubsection"],
Cell[205599, 5239, 2031, 55, 10506, "Subsubtitle"],
Cell[207633, 5296, 771, 11, 5200, "Subsubsection"],
Cell[208407, 5309, 2309, 67, 19822, "Code"],
Cell[210719, 5378, 2383, 68, 21398, "Code"],
Cell[213105, 5448, 89, 2, 5200, "Subsubsection"],
Cell[213197, 5452, 559, 14, 3830, "Subsubsection"],
Cell[213759, 5468, 1215, 23, 3830, "Subsubsection"],
Cell[214977, 5493, 2689, 68, 10599, "Subsubtitle"],
Cell[217669, 5563, 771, 11, 5200, "Subsubsection"],
Cell[218443, 5576, 2592, 76, 23664, "Code"],
Cell[221038, 5654, 577, 12, 5361, "Subsubsection"],
Cell[221618, 5668, 2664, 77, 23664, "Code"],
Cell[224285, 5747, 89, 2, 5200, "Subsubsection"],
Cell[224377, 5751, 262, 4, 3564, "Subsubsection"],
Cell[224642, 5757, 1331, 26, 3830, "Subsubsection"],
Cell[225976, 5785, 3688, 99, 19970, "Subsubtitle"],
Cell[229667, 5886, 771, 11, 5200, "Subsubsection"],
Cell[230441, 5899, 3759, 112, 27621, "Code"],
Cell[234203, 6013, 311, 5, 5200, "Subsubsection"],
Cell[234517, 6020, 3835, 113, 27621, "Code"],
Cell[238355, 6135, 89, 2, 5200, "Subsubsection"],
Cell[238447, 6139, 633, 15, 3830, "Subsubsection"],
Cell[239083, 6156, 1430, 28, 3830, "Subsubsection"],
Cell[240516, 6186, 3117, 80, 18422, "Subsubtitle"],
Cell[243636, 6268, 771, 11, 5200, "Subsubsection"],
Cell[244410, 6281, 3025, 91, 23664, "Code"],
Cell[247438, 6374, 651, 13, 5361, "Subsubsection"],
Cell[248092, 6389, 3121, 93, 23664, "Code"],
Cell[251216, 6484, 89, 2, 5200, "Subsubsection"],
Cell[251308, 6488, 337, 5, 3564, "Subsubsection"],
Cell[251648, 6495, 1540, 31, 3830, "Subsubsection"],
Cell[253191, 6528, 3981, 110, 19970, "Subsubtitle"],
Cell[257175, 6640, 771, 11, 5200, "Subsubsection"],
Cell[257949, 6653, 4391, 130, 27621, "Code"],
Cell[262343, 6785, 390, 6, 5200, "Subsubsection"],
Cell[262736, 6793, 4493, 132, 27621, "Code"],
Cell[267232, 6927, 89, 2, 5200, "Subsubsection"],
Cell[267324, 6931, 361, 5, 3564, "Subsubsection"],
Cell[267688, 6938, 1584, 30, 3830, "Subsubsection"],
Cell[269275, 6970, 3950, 108, 20259, "Subsubtitle"],
Cell[273228, 7080, 771, 11, 5200, "Subsubsection"],
Cell[274002, 7093, 4238, 125, 27621, "Code"],
Cell[278243, 7220, 413, 6, 5200, "Subsubsection"],
Cell[278659, 7228, 4314, 126, 27621, "Code"],
Cell[282976, 7356, 89, 2, 5200, "Subsubsection"],
Cell[283068, 7360, 395, 6, 3564, "Subsubsection"],
Cell[283466, 7368, 784, 20, 5539, "Subsubsection"],
Cell[284253, 7390, 456, 6, 3564, "Subsubsection"],
Cell[284712, 7398, 1582, 28, 3830, "Subsubsection"],
Cell[286297, 7428, 2373, 52, 9099, "Subsubtitle"],
Cell[288673, 7482, 771, 11, 5200, "Subsubsection"],
Cell[289447, 7495, 2402, 64, 15903, "Code"],
Cell[291852, 7561, 44, 1, 377, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[291933, 7567, 1357, 29, 80, "Title"],
Cell[293293, 7598, 312, 4, 5200, "Subsubsection"],
Cell[293608, 7604, 1206, 21, 3830, "Subsubsection"],
Cell[294817, 7627, 1857, 47, 8926, "Subsubtitle"],
Cell[296677, 7676, 771, 11, 5200, "Subsubsection"],
Cell[297451, 7689, 1914, 53, 15903, "Code"],
Cell[299368, 7744, 1992, 54, 17494, "Code"],
Cell[301363, 7800, 44, 1, 377, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[301444, 7806, 1194, 25, 80, "Title"],
Cell[302641, 7833, 256, 4, 5200, "Subsubsection"],
Cell[302900, 7839, 759, 25, 6500, "Subsubsection"],
Cell[303662, 7866, 968, 19, 3830, "Subsubsection"],
Cell[304633, 7887, 1216, 30, 9749, "Subsubtitle"],
Cell[305852, 7919, 771, 11, 5200, "Subsubsection"],
Cell[306626, 7932, 1192, 36, 15903, "Code"],
Cell[307821, 7970, 1262, 37, 17494, "Code"],
Cell[309086, 8009, 89, 2, 5200, "Subsubsection"],
Cell[309178, 8013, 223, 3, 3564, "Subsubsection"],
Cell[309404, 8018, 807, 25, 6500, "Subsubsection"],
Cell[310214, 8045, 624, 18, 3830, "Subsubsection"],
Cell[310841, 8065, 1030, 20, 3830, "Subsubsection"],
Cell[311874, 8087, 2398, 60, 9749, "Subsubtitle"],
Cell[314275, 8149, 771, 11, 5200, "Subsubsection"],
Cell[315049, 8162, 2162, 66, 19822, "Code"],
Cell[317214, 8230, 2238, 67, 21398, "Code"],
Cell[319455, 8299, 44, 1, 377, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[319536, 8305, 1331, 29, 80, "Title"],
Cell[320870, 8336, 1016, 20, 5361, "Subsubsection"],
Cell[321889, 8358, 1303, 33, 10067, "Subsubtitle"],
Cell[323195, 8393, 771, 11, 5200, "Subsubsection"],
Cell[323969, 8406, 1324, 39, 15903, "Code"],
Cell[325296, 8447, 1378, 39, 17494, "Code"],
Cell[326677, 8488, 89, 2, 5200, "Subsubsection"],
Cell[326769, 8492, 1074, 21, 3830, "Subsubsection"],
Cell[327846, 8515, 2204, 54, 10067, "Subsubtitle"],
Cell[330053, 8571, 771, 11, 5200, "Subsubsection"],
Cell[330827, 8584, 1951, 58, 19822, "Code"],
Cell[332781, 8644, 2004, 58, 21398, "Code"],
Cell[334788, 8704, 89, 2, 5200, "Subsubsection"],
Cell[334880, 8708, 1203, 24, 3830, "Subsubsection"],
Cell[336086, 8734, 2829, 70, 17833, "Subsubtitle"],
Cell[338918, 8806, 771, 11, 5200, "Subsubsection"],
Cell[339692, 8819, 2500, 74, 19822, "Code"],
Cell[342195, 8895, 2551, 74, 21398, "Code"],
Cell[344749, 8971, 89, 2, 5200, "Subsubsection"],
Cell[344841, 8975, 1260, 24, 3830, "Subsubsection"],
Cell[346104, 9001, 3319, 88, 19430, "Subsubtitle"],
Cell[349426, 9091, 771, 11, 5200, "Subsubsection"],
Cell[350200, 9104, 3291, 99, 23664, "Code"],
Cell[353494, 9205, 3343, 99, 25241, "Code"],
Cell[356840, 9306, 89, 2, 5200, "Subsubsection"],
Cell[356932, 9310, 1272, 25, 3830, "Subsubsection"],
Cell[358207, 9337, 2945, 73, 18297, "Subsubtitle"],
Cell[361155, 9412, 771, 11, 5200, "Subsubsection"],
Cell[361929, 9425, 2577, 77, 19822, "Code"],
Cell[364509, 9504, 2661, 79, 21398, "Code"],
Cell[367173, 9585, 89, 2, 5200, "Subsubsection"],
Cell[367265, 9589, 1330, 26, 3830, "Subsubsection"],
Cell[368598, 9617, 3512, 94, 19451, "Subsubtitle"],
Cell[372113, 9713, 771, 11, 5200, "Subsubsection"],
Cell[372887, 9726, 3472, 104, 23664, "Code"],
Cell[376362, 9832, 3556, 106, 25241, "Code"],
Cell[379921, 9940, 44, 1, 377, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[380002, 9946, 1277, 27, 80, "Title"],
Cell[381282, 9975, 1048, 21, 5361, "Subsubsection"],
Cell[382333, 9998, 1731, 47, 10190, "Subsubtitle"],
Cell[384067, 10047, 771, 11, 5200, "Subsubsection"],
Cell[384841, 10060, 1805, 54, 19822, "Code"],
Cell[386649, 10116, 1877, 55, 21398, "Code"],
Cell[388529, 10173, 89, 2, 5200, "Subsubsection"],
Cell[388621, 10177, 1207, 25, 5200, "Subsubsection"],
Cell[389831, 10204, 3550, 92, 21274, "Subsubtitle"],
Cell[393384, 10298, 771, 11, 5200, "Subsubsection"],
Cell[394158, 10311, 3291, 97, 23664, "Code"],
Cell[397452, 10410, 3366, 98, 25241, "Code"],
Cell[400821, 10510, 89, 2, 5200, "Subsubsection"],
Cell[400913, 10514, 1567, 32, 5200, "Subsubsection"],
Cell[402483, 10548, 2772, 68, 10599, "Subsubtitle"],
Cell[405258, 10618, 771, 11, 5200, "Subsubsection"],
Cell[406032, 10631, 2897, 81, 19822, "Code"],
Cell[408932, 10714, 2966, 82, 21398, "Code"],
Cell[411901, 10798, 89, 2, 5200, "Subsubsection"],
Cell[411993, 10802, 1465, 31, 5200, "Subsubsection"],
Cell[413461, 10835, 3585, 95, 21067, "Subsubtitle"],
Cell[417049, 10932, 771, 11, 5200, "Subsubsection"],
Cell[417823, 10945, 3765, 111, 23664, "Code"],
Cell[421591, 11058, 3834, 112, 25241, "Code"],
Cell[425428, 11172, 44, 1, 377, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[425509, 11178, 1331, 28, 80, "Title"],
Cell[426843, 11208, 1288, 29, 6715, "Subsubsection"],
Cell[428134, 11239, 2161, 61, 10506, "Subsubtitle"],
Cell[430298, 11302, 771, 11, 5200, "Subsubsection"],
Cell[431072, 11315, 2481, 77, 19822, "Code"],
Cell[433556, 11394, 2559, 78, 21398, "Code"],
Cell[436118, 11474, 89, 2, 5200, "Subsubsection"],
Cell[436210, 11478, 1425, 31, 5200, "Subsubsection"],
Cell[437638, 11511, 4122, 110, 21274, "Subsubtitle"],
Cell[441763, 11623, 771, 11, 5200, "Subsubsection"],
Cell[442537, 11636, 4161, 126, 23664, "Code"],
Cell[446701, 11764, 4284, 127, 25241, "Code"],
Cell[450988, 11893, 89, 2, 5200, "Subsubsection"],
Cell[451080, 11897, 1286, 25, 3830, "Subsubsection"],
Cell[452369, 11924, 4029, 108, 21067, "Subsubtitle"],
Cell[456401, 12034, 771, 11, 5200, "Subsubsection"],
Cell[457175, 12047, 4042, 120, 23664, "Code"],
Cell[461220, 12169, 4135, 122, 25241, "Code"],
Cell[465358, 12293, 44, 1, 377, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[465439, 12299, 1423, 30, 80, "Title"],
Cell[466865, 12331, 1035, 18, 5361, "Subsubsection"],
Cell[467903, 12351, 1804, 47, 9777, "Subsubtitle"],
Cell[469710, 12400, 771, 11, 5200, "Subsubsection"],
Cell[470484, 12413, 1799, 52, 19822, "Code"],
Cell[472286, 12467, 1847, 52, 21398, "Code"],
Cell[474136, 12521, 89, 2, 5200, "Subsubsection"],
Cell[474228, 12525, 1087, 19, 3830, "Subsubsection"],
Cell[475318, 12546, 3117, 78, 20239, "Subsubtitle"],
Cell[478438, 12626, 771, 11, 5200, "Subsubsection"],
Cell[479212, 12639, 2794, 81, 23664, "Code"],
Cell[482009, 12722, 2840, 81, 25241, "Code"],
Cell[484852, 12805, 44, 1, 377, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[484933, 12811, 1477, 31, 80, "Title"],
Cell[486413, 12844, 1184, 22, 5361, "Subsubsection"],
Cell[487600, 12868, 2109, 55, 10067, "Subsubtitle"],
Cell[489712, 12925, 771, 11, 5200, "Subsubsection"],
Cell[490486, 12938, 2335, 65, 19822, "Code"],
Cell[492824, 13005, 2384, 65, 21398, "Code"],
Cell[495211, 13072, 89, 2, 5200, "Subsubsection"],
Cell[495303, 13076, 1195, 22, 3830, "Subsubsection"],
Cell[496501, 13100, 2822, 75, 18709, "Subsubtitle"],
Cell[499326, 13177, 771, 11, 5200, "Subsubsection"],
Cell[500100, 13190, 3131, 89, 23664, "Code"],
Cell[503234, 13281, 3206, 89, 25241, "Code"],
Cell[506443, 13372, 44, 1, 377, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[506524, 13378, 1643, 30, 80, "Title"],
Cell[508170, 13410, 273, 4, 67, "Subsubsection"],
Cell[508446, 13416, 599, 17, 71, "Subsubsection"],
Cell[509048, 13435, 1630, 28, 71, "Subsubsection"],
Cell[510681, 13465, 1846, 49, 116, "Subsubtitle"],
Cell[512530, 13516, 771, 11, 67, "Subsubsection"],
Cell[513304, 13529, 2314, 63, 251, "Code"],
Cell[515621, 13594, 89, 2, 67, "Subsubsection"],
Cell[515713, 13598, 273, 4, 47, "Subsubsection"],
Cell[515989, 13604, 653, 18, 71, "Subsubsection"],
Cell[516645, 13624, 1630, 28, 71, "Subsubsection"],
Cell[518278, 13654, 1922, 50, 116, "Subsubtitle"],
Cell[520203, 13706, 771, 11, 67, "Subsubsection"],
Cell[520977, 13719, 2388, 64, 251, "Code"],
Cell[523368, 13785, 89, 2, 67, "Subsubsection"],
Cell[523460, 13789, 430, 6, 47, "Subsubsection"],
Cell[523893, 13797, 616, 15, 50, "Subsubsection"],
Cell[524512, 13814, 1713, 33, 71, "Subsubsection"],
Cell[526228, 13849, 2424, 49, 114, "Subsubtitle"],
Cell[528655, 13900, 771, 11, 67, "Subsubsection"],
Cell[529429, 13913, 2342, 57, 202, "Code"],
Cell[531774, 13972, 89, 2, 67, "Subsubsection"],
Cell[531866, 13976, 523, 9, 47, "Subsubsection"],
Cell[532392, 13987, 616, 15, 50, "Subsubsection"],
Cell[533011, 14004, 3282, 64, 99, "Subsubsection"],
Cell[536296, 14070, 1713, 33, 71, "Subsubsection"],
Cell[538012, 14105, 2966, 67, 158, "Subsubtitle"],
Cell[540981, 14174, 771, 11, 67, "Subsubsection"],
Cell[541755, 14187, 3133, 77, 202, "Code"],
Cell[544891, 14266, 44, 1, 6, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[544972, 14272, 1161, 22, 80, "Title"],
Cell[546136, 14296, 273, 4, 5200, "Subsubsection"],
Cell[546412, 14302, 599, 17, 5539, "Subsubsection"],
Cell[547014, 14321, 1048, 20, 3830, "Subsubsection"],
Cell[548065, 14343, 1263, 31, 8926, "Subsubtitle"],
Cell[549331, 14376, 771, 11, 5200, "Subsubsection"],
Cell[550105, 14389, 1231, 33, 19822, "Code"],
Cell[551339, 14424, 1307, 34, 21398, "Code"],
Cell[552649, 14460, 44, 1, 377, "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}
]
*)

(* End of internal cache information *)
