(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     33911,        852]
NotebookOptionsPosition[     31213,        775]
NotebookOutlinePosition[     32322,        814]
CellTagsIndexPosition[     32279,        811]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Zeta", "[", 
    RowBox[{"s", ",", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, 
   3.4944391510732927`*^9, 3.494439343783562*^9, 3.494440144604683*^9, 
   3.494440314964922*^9, 3.4944407784755707`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494439616563944*^9, 3.4944396188039474`*^9}, 
   3.494440828745641*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    TemplateBox[{"2","z"},
     "Zeta2"], "=", 
    TemplateBox[{"1","z"},
     "PolyGamma2"]}], TraditionalForm]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494439616563944*^9, 3.494439653543996*^9}, 
   3.494440010294495*^9, {3.4944404285250807`*^9, 3.4944404324350863`*^9}, 
   3.4944408181856265`*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.49444016365471*^9, 3.494440166564714*^9}, 
   3.4944406703654194`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Zeta", "[", 
    RowBox[{"2", ",", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       RowBox[{"PolyGamma", "[", 
        RowBox[{"1", ",", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}]}], "]"}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944391698033185`*^9, {3.4944393463335657`*^9, 
   3.4944393633235893`*^9}, 3.4944394680437365`*^9, 3.4944402029647655`*^9, 
   3.4944402360048113`*^9, 3.4944403327949467`*^9, 3.494440636445372*^9, {
   3.494440871455701*^9, 3.4944409024857445`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Zeta", "[", 
     RowBox[{"2", ",", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"PolyGamma", "[", 
      RowBox[{"1", ",", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}]}], "]"}], ",", "x"}], "]"}], " ", "/;", 
   "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4944391618433075`*^9, 
   3.494439288643485*^9, 3.494440114764642*^9, 3.4944404118050575`*^9, 
   3.4944407868855824`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Primitive rule", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494439616563944*^9, 3.4944396188039474`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox[
     RowBox[{"\[PartialD]", 
      TemplateBox[{"s","z"},
       "Zeta2"]}], 
     RowBox[{"\[PartialD]", "z"}],
     MultilineFunction->None], "=", 
    RowBox[{
     RowBox[{"-", "s"}], " ", 
     TemplateBox[{RowBox[{"s", "+", "1"}],"z"},
      "Zeta2"]}]}], TraditionalForm]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494439616563944*^9, 3.494439653543996*^9}, 
   3.494440010294495*^9, {3.4944404285250807`*^9, 3.4944404324350863`*^9}, {
   3.494440468745137*^9, 3.49444047076514*^9}, 3.494440852155674*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"s", "\[NotEqual]", "1"}], " ", "\[And]", " ", 
   RowBox[{"s", "\[NotEqual]", "2"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.49444016365471*^9, 3.494440185694741*^9}, {
   3.494440950745812*^9, 3.4944409704958396`*^9}, {3.494441001285883*^9, 
   3.4944410095858946`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Zeta", "[", 
    RowBox[{"s", ",", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"Zeta", "[", 
        RowBox[{
         RowBox[{"s", "-", "1"}], ",", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}]}], "]"}], 
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{"s", "-", "1"}], ")"}]}]]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4944393492135696`*^9, 3.494439366993595*^9}, 
   3.4944395044737873`*^9, 3.494440205154768*^9, 3.494440258444843*^9, 
   3.4944403380849543`*^9, 3.494440511185197*^9, {3.4944406020953236`*^9, 
   3.4944406032253256`*^9}, 3.494440650915392*^9, 3.4944408824057164`*^9, 
   3.494440923525774*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Zeta", "[", 
     RowBox[{"s_", ",", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Zeta", "[", 
      RowBox[{
       RowBox[{"s", "-", "1"}], ",", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}]}], "]"}]}], "/", 
    RowBox[{"(", 
     RowBox[{"b", "*", 
      RowBox[{"(", 
       RowBox[{"s", "-", "1"}], ")"}]}], ")"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "s"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"s", "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"s", "-", "2"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494439298133498*^9, 
   3.494440123504654*^9, 3.4944404180850663`*^9, {3.4944405683652763`*^9, 
   3.4944405833952975`*^9}, 3.4944407934755917`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   RowBox[{"Zeta", "[", 
    RowBox[{"s", ",", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, 
   3.4944391510732927`*^9, 3.494439343783562*^9, 3.494441172446122*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494441191516149*^9, 3.4944411920661497`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    TemplateBox[{"2","z"},
     "Zeta2"], "=", 
    TemplateBox[{"1","z"},
     "PolyGamma2"]}], TraditionalForm]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494439616563944*^9, 3.494439653543996*^9}, 
   3.494440010294495*^9, {3.4944404285250807`*^9, 3.4944404324350863`*^9}, {
   3.494440468745137*^9, 3.49444047076514*^9}, 3.494440852155674*^9, {
   3.494441154266097*^9, 3.494441157946102*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalQ]"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.4944412114461765`*^9, 3.49444121338618*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   RowBox[{"Zeta", "[", 
    RowBox[{"2", ",", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox["x", "m"], " ", 
       RowBox[{"PolyGamma", "[", 
        RowBox[{"1", ",", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}]}], "]"}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944391698033185`*^9, {3.4944393463335657`*^9, 
   3.4944393633235893`*^9}, 3.4944394680437365`*^9, {3.4944412518762336`*^9, 
   3.494441273186263*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"Zeta", "[", 
      RowBox[{"2", ",", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "m"}], "*", 
      RowBox[{"PolyGamma", "[", 
       RowBox[{"1", ",", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}]}], "]"}]}], ",", "x"}], "]"}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4944391618433075`*^9, 
   3.494439288643485*^9, 3.4944410948660135`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"s", "\[NotEqual]", "1"}], " ", "\[And]", " ", 
   RowBox[{"s", "\[NotEqual]", "2"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.49444016365471*^9, 3.494440185694741*^9}, {
   3.494440950745812*^9, 3.4944409704958396`*^9}, {3.494441001285883*^9, 
   3.4944410095858946`*^9}, {3.4944413528063745`*^9, 3.4944413704964*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"Zeta", "[", 
     RowBox[{"s", ",", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox["x", "m"], " ", 
         RowBox[{"Zeta", "[", 
          RowBox[{
           RowBox[{"s", "-", "1"}], ",", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}]}], "]"}]}], 
        RowBox[{"b", " ", 
         RowBox[{"(", 
          RowBox[{"s", "-", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["m", 
    RowBox[{"b", " ", 
     RowBox[{"(", 
      RowBox[{"s", "-", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "1"}]], " ", 
     RowBox[{"Zeta", "[", 
      RowBox[{
       RowBox[{"s", "-", "1"}], ",", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4944393492135696`*^9, 3.494439366993595*^9}, 
   3.4944395044737873`*^9, {3.4944412966462965`*^9, 3.4944413255163364`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"Zeta", "[", 
      RowBox[{"s_", ",", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"x", "^", "m"}]}], "*", 
     RowBox[{
      RowBox[{"Zeta", "[", 
       RowBox[{
        RowBox[{"s", "-", "1"}], ",", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"s", "-", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"m", "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{"(", 
          RowBox[{"s", "-", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{"Zeta", "[", 
          RowBox[{
           RowBox[{"s", "-", "1"}], ",", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}]}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "s"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"s", "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"s", "-", "2"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494439298133498*^9, 
   3.4944411032260256`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Inverted integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.4944413869064226`*^9, 3.4944413884864244`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{"s", "\[NotEqual]", "1"}], " ", "\[And]", " ", 
   RowBox[{"s", "\[NotEqual]", "2"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.49444016365471*^9, 3.494440185694741*^9}, {
   3.494440950745812*^9, 3.4944409704958396`*^9}, {3.494441001285883*^9, 
   3.4944410095858946`*^9}, {3.4944413528063745`*^9, 3.4944413704964*^9}, {
   3.4944414508265123`*^9, 3.4944414523765144`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"Zeta", "[", 
     RowBox[{"s", ",", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        RowBox[{"Zeta", "[", 
         RowBox[{"s", ",", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}]}], "]"}]}], 
       RowBox[{"m", "+", "1"}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"b", " ", "s"}], 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "1"}]], " ", 
     RowBox[{"Zeta", "[", 
      RowBox[{
       RowBox[{"s", "+", "1"}], ",", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944393519535737`*^9, {3.4944398753843064`*^9, 
   3.494439898614339*^9}, 3.494441298476299*^9, 3.494441429966483*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"Zeta", "[", 
      RowBox[{"s_", ",", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Zeta", "[", 
       RowBox[{"s", ",", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", 
       RowBox[{"s", "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{"Zeta", "[", 
          RowBox[{
           RowBox[{"s", "+", "1"}], ",", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}]}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "s"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"s", "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"s", "-", "2"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, {3.494439298133498*^9, 
   3.4944393224735327`*^9}, 3.494441111366037*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]]
},
AutoGeneratedPackage->Automatic,
CellGrouping->Manual,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  "Integration Rules for Zeta Functions", None, None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->28.8},
Magnification->1.399999976158142,
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 1025, 22, 118, "Title"],
Cell[1595, 46, 182, 3, 130, "Subsubsection"],
Cell[1780, 51, 399, 13, 99, "Subsubsection"],
Cell[2182, 66, 837, 12, 90, "Subsubsection"],
Cell[3022, 80, 1679, 34, 201, "Subsubtitle"],
Cell[4704, 116, 795, 11, 130, "Subsubsection"],
Cell[5502, 129, 926, 26, 394, "Code"],
Cell[6431, 157, 113, 2, 130, "Subsubsection"],
Cell[6547, 161, 146, 2, 90, "Subsubsection"],
Cell[6696, 165, 624, 19, 153, "Subsubsection"],
Cell[7323, 186, 1071, 20, 96, "Subsubsection"],
Cell[8397, 208, 1790, 38, 233, "Subsubtitle"],
Cell[10190, 248, 795, 11, 130, "Subsubsection"],
Cell[10988, 261, 1267, 36, 394, "Code"],
Cell[12258, 299, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[12339, 305, 1010, 22, 80, "Title"],
Cell[13352, 329, 156, 2, 130, "Subsubsection"],
Cell[13511, 333, 492, 14, 99, "Subsubsection"],
Cell[14006, 349, 917, 16, 96, "Subsubsection"],
Cell[14926, 367, 1655, 35, 201, "Subsubtitle"],
Cell[16584, 404, 795, 11, 130, "Subsubsection"],
Cell[17382, 417, 1068, 31, 394, "Code"],
Cell[18453, 450, 113, 2, 130, "Subsubsection"],
Cell[18569, 454, 101, 1, 90, "Subsubsection"],
Cell[18673, 457, 1166, 21, 96, "Subsubsection"],
Cell[19842, 480, 2174, 54, 242, "Subsubtitle"],
Cell[22019, 536, 795, 11, 130, "Subsubsection"],
Cell[22817, 549, 1999, 61, 491, "Code"],
Cell[24819, 612, 113, 2, 130, "Subsubsection"],
Cell[24935, 616, 163, 2, 90, "Subsubsection"],
Cell[25101, 620, 1240, 23, 96, "Subsubsection"],
Cell[26344, 645, 2047, 50, 242, "Subsubtitle"],
Cell[28394, 697, 795, 11, 130, "Subsubsection"],
Cell[29192, 710, 1958, 59, 491, "Code"],
Cell[31153, 771, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}
]
*)

(* End of internal cache information *)
