(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    251205,       6457]
NotebookOptionsPosition[    237364,       6143]
NotebookOutlinePosition[    238488,       6182]
CellTagsIndexPosition[    238445,       6179]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"a", " ", "u", 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: CRC 1", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"a", 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "a"}]}], " ", 
   "x"}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{"a_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "   ", 
  RowBox[{
   RowBox[{"a", "*", "x"}], " ", "/;", "\n", 
   RowBox[{"IndependentQ", "[", 
    RowBox[{"a", ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Power rule for integration", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"c", " ", 
   RowBox[{"(", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], ")"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"c", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "2"]}], 
      RowBox[{"2", " ", "b"}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"c_", "*", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", "x_"}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{"c", "*", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", "b"}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.02.1, CRC 2", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4965289702339883`*^9}],

Cell["Derivation: Constant extraction", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4965289702339883`*^9, {3.496529469454687*^9, 
   3.496529480824703*^9}, {3.4965297180850353`*^9, 3.496529730605053*^9}, {
   3.4965300124054475`*^9, 3.496530013255449*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "+", "1"}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9, {
   3.4965292823344254`*^9, 3.4965293014844522`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"c", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "c"}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.496529223484343*^9, 3.4965292427943697`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"c_", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{"c", ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}], ",", "x"}], "]"}]}], 
    "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"n", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.4965289767239976`*^9, {3.4965292607543955`*^9, 
   3.4965292659744024`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.02.1, CRC 2", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4965289702339883`*^9}],

Cell["Derivation: Constant extraction", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4965289702339883`*^9, {3.496529469454687*^9, 
   3.496529480824703*^9}, {3.4965297180850353`*^9, 3.496529730605053*^9}, {
   3.4965300124054475`*^9, 3.496530013255449*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"a", " ", "u", 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "a"}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{"u", 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.496528988494014*^9, 3.4965290052040377`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"a_", "*", "u_"}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
    "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"lst", "=", 
         RowBox[{"ConstantFactor", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{"ShowStep", "[", 
        RowBox[{
        "\"\<\>\"", ",", "\"\<Int[a*u,x]\>\"", ",", "\"\<a*Int[u,x]\>\"", ",", 
         RowBox[{"Hold", "[", "\n", "  ", 
          RowBox[{"Dist", "[", 
           RowBox[{
            RowBox[{"a", "*", 
             RowBox[{"lst", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], ",", 
            RowBox[{"Int", "[", 
             RowBox[{
              RowBox[{"lst", "[", 
               RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}]}], "]"}], 
          "]"}]}], "]"}]}], "]"}], " ", "/;", "\n", 
     RowBox[{"SimplifyFlag", " ", "&&", " ", 
      RowBox[{"FreeQ", "[", 
       RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
      RowBox[{"Not", "[", 
       RowBox[{"MatchQ", "[", 
        RowBox[{"u", ",", 
         RowBox[{
          RowBox[{"b_", "*", "v_"}], " ", "/;", " ", 
          RowBox[{"FreeQ", "[", 
           RowBox[{"b", ",", "x"}], "]"}]}]}], "]"}], "]"}]}]}]}], ",", "\n", 
   "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"a_", "*", "u_"}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
    "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"lst", "=", 
         RowBox[{"ConstantFactor", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{"Dist", "[", 
        RowBox[{
         RowBox[{"a", "*", 
          RowBox[{"lst", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ",", 
         RowBox[{"Int", "[", 
          RowBox[{
           RowBox[{"lst", "[", 
            RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}]}], "]"}]}], 
      "]"}], " ", "/;", "\n", 
     RowBox[{
      RowBox[{"FreeQ", "[", 
       RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
      RowBox[{"Not", "[", 
       RowBox[{"MatchQ", "[", 
        RowBox[{"u", ",", 
         RowBox[{
          RowBox[{"b_", "*", "v_"}], " ", "/;", " ", 
          RowBox[{"FreeQ", "[", 
           RowBox[{"b", ",", "x"}], "]"}]}]}], "]"}], "]"}]}]}]}]}], 
  "]"}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.4965289767239976`*^9, 3.4965290568841095`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Constant extraction", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4965289702339883`*^9, {3.496529469454687*^9, 
   3.496529480824703*^9}, {3.4965297180850353`*^9, 3.496529730605053*^9}, {
   3.4965300124054475`*^9, 3.496530013255449*^9}}],

Cell["\<\
Note: Constant factors in denominators are aggressively factored out to \
prevent them occurring unnecessarily in logarithm terms of antiderivatives!\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4965289702339883`*^9, {3.496529469454687*^9, 
   3.496529480824703*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"a", " ", "u", 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "a"}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{"u", 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.496528988494014*^9, 3.4965290052040377`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"lst", "=", 
         RowBox[{"ConstantFactor", "[", 
          RowBox[{
           RowBox[{"Simplify", "[", 
            RowBox[{"Denominator", "[", "u", "]"}], "]"}], ",", "x"}], 
          "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"ShowStep", "[", 
         RowBox[{
         "\"\<\>\"", ",", "\"\<Int[a*u,x]\>\"", ",", "\"\<a*Int[u,x]\>\"", 
          ",", 
          RowBox[{"Hold", "[", "\n", "  ", 
           RowBox[{"Dist", "[", 
            RowBox[{
             RowBox[{"1", "/", 
              RowBox[{"lst", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], ",", 
             RowBox[{"Int", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"Numerator", "[", "u", "]"}], "/", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}], ",", "x"}], "]"}]}], "]"}],
            "]"}]}], "]"}], " ", "/;", "\n", " ", 
        RowBox[{
         RowBox[{"lst", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "=!=", "1"}]}]}], "]"}], " ", "/;", 
     "\n", 
     RowBox[{"SimplifyFlag", " ", "&&", " ", 
      RowBox[{"(", "\n", "\t", 
       RowBox[{
        RowBox[{"MatchQ", "[", 
         RowBox[{"u", ",", 
          RowBox[{
           RowBox[{"1", "/", 
            RowBox[{"(", 
             RowBox[{"a_", "+", 
              RowBox[{"b_.", "*", "x"}]}], ")"}]}], " ", "/;", " ", 
           RowBox[{"FreeQ", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}], "]"}], 
        " ", "||", "\n", "\t", 
        RowBox[{"MatchQ", "[", 
         RowBox[{"u", ",", 
          RowBox[{
           RowBox[{
            RowBox[{"x", "^", "m_."}], "/", 
            RowBox[{"(", 
             RowBox[{"a_", "+", 
              RowBox[{"b_.", "*", 
               RowBox[{"x", "^", "n_"}]}]}], ")"}]}], " ", "/;", " ", 
           RowBox[{
            RowBox[{"FreeQ", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"a", ",", "b", ",", "m", ",", "n"}], "}"}], ",", "x"}],
              "]"}], " ", "&&", " ", 
            RowBox[{"ZeroQ", "[", 
             RowBox[{"m", "-", "n", "+", "1"}], "]"}]}]}]}], "]"}], " ", "||",
         "\n", "\t", 
        RowBox[{"MatchQ", "[", 
         RowBox[{"u", ",", 
          RowBox[{
           RowBox[{"1", "/", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"a_.", "+", 
                RowBox[{"b_.", "*", "x"}]}], ")"}], "*", 
              RowBox[{"(", 
               RowBox[{"c_", "+", 
                RowBox[{"d_.", "*", "x"}]}], ")"}]}], ")"}]}], " ", "/;", " ", 
           RowBox[{"FreeQ", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], 
            "]"}]}]}], "]"}], " ", "||", "\n", "\t", 
        RowBox[{"MatchQ", "[", 
         RowBox[{"u", ",", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"d_.", "+", 
              RowBox[{"e_.", "*", "x"}]}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{"a_", "+", 
              RowBox[{"b_.", "*", "x"}], "+", 
              RowBox[{"c_.", "*", 
               RowBox[{"x", "^", "2"}]}]}], ")"}]}], " ", "/;", " ", 
           RowBox[{"FreeQ", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], 
             ",", "x"}], "]"}]}]}], "]"}], " ", "||", "\n", "\t", 
        RowBox[{"MatchQ", "[", 
         RowBox[{"u", ",", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"c_.", "*", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"a_.", "+", 
                 RowBox[{"b_.", "*", "x"}]}], ")"}], "^", "n_"}]}], ")"}], 
            "^", "m_"}], " ", "/;", " ", 
           RowBox[{
            RowBox[{"FreeQ", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"a", ",", "b", ",", "c", ",", "m", ",", "n"}], "}"}], 
              ",", "x"}], "]"}], " ", "&&", " ", 
            RowBox[{"ZeroQ", "[", 
             RowBox[{
              RowBox[{"m", "*", "n"}], "+", "1"}], "]"}]}]}]}], "]"}]}], 
       ")"}]}]}]}], ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"lst", "=", 
         RowBox[{"ConstantFactor", "[", 
          RowBox[{
           RowBox[{"Simplify", "[", 
            RowBox[{"Denominator", "[", "u", "]"}], "]"}], ",", "x"}], 
          "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"Dist", "[", 
         RowBox[{
          RowBox[{"1", "/", 
           RowBox[{"lst", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], ",", 
          RowBox[{"Int", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Numerator", "[", "u", "]"}], "/", 
             RowBox[{"lst", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], ",", "x"}], "]"}]}], "]"}], 
        " ", "/;", "\n", " ", 
        RowBox[{
         RowBox[{"lst", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "=!=", "1"}]}]}], "]"}], " ", "/;", 
     "\n", "\t", 
     RowBox[{
      RowBox[{"MatchQ", "[", 
       RowBox[{"u", ",", 
        RowBox[{
         RowBox[{"1", "/", 
          RowBox[{"(", 
           RowBox[{"a_", "+", 
            RowBox[{"b_.", "*", "x"}]}], ")"}]}], " ", "/;", " ", 
         RowBox[{"FreeQ", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}], "]"}], " ",
       "||", "\n", "\t", 
      RowBox[{"MatchQ", "[", 
       RowBox[{"u", ",", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", "m_."}], "/", 
          RowBox[{"(", 
           RowBox[{"a_", "+", 
            RowBox[{"b_.", "*", 
             RowBox[{"x", "^", "n_"}]}]}], ")"}]}], " ", "/;", " ", 
         RowBox[{
          RowBox[{"FreeQ", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"a", ",", "b", ",", "m", ",", "n"}], "}"}], ",", "x"}], 
           "]"}], " ", "&&", " ", 
          RowBox[{"ZeroQ", "[", 
           RowBox[{"m", "-", "n", "+", "1"}], "]"}]}]}]}], "]"}], " ", "||", 
      "\n", "\t", 
      RowBox[{"MatchQ", "[", 
       RowBox[{"u", ",", 
        RowBox[{
         RowBox[{"1", "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a_.", "+", 
              RowBox[{"b_.", "*", "x"}]}], ")"}], "*", 
            RowBox[{"(", 
             RowBox[{"c_", "+", 
              RowBox[{"d_.", "*", "x"}]}], ")"}]}], ")"}]}], " ", "/;", " ", 
         RowBox[{"FreeQ", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], 
          "]"}]}]}], "]"}], " ", "||", "\n", "\t", 
      RowBox[{"MatchQ", "[", 
       RowBox[{"u", ",", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d_.", "+", 
            RowBox[{"e_.", "*", "x"}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"a_", "+", 
            RowBox[{"b_.", "*", "x"}], "+", 
            RowBox[{"c_.", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}], " ", "/;", " ", 
         RowBox[{"FreeQ", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",",
            "x"}], "]"}]}]}], "]"}], " ", "||", "\n", "\t", 
      RowBox[{"MatchQ", "[", 
       RowBox[{"u", ",", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c_.", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"a_.", "+", 
               RowBox[{"b_.", "*", "x"}]}], ")"}], "^", "n_"}]}], ")"}], "^", 
          "m_"}], " ", "/;", " ", 
         RowBox[{
          RowBox[{"FreeQ", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"a", ",", "b", ",", "c", ",", "m", ",", "n"}], "}"}], 
            ",", "x"}], "]"}], " ", "&&", " ", 
          RowBox[{"ZeroQ", "[", 
           RowBox[{
            RowBox[{"m", "*", "n"}], "+", "1"}], "]"}]}]}]}], "]"}]}]}]}]}], 
  "]"}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.4965289767239976`*^9, 3.4965290568841095`*^9, 
   3.4965294545946665`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Constant extraction", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4965289702339883`*^9, {3.496529469454687*^9, 
   3.496529480824703*^9}, {3.4965297180850353`*^9, 3.496529730605053*^9}, {
   3.4965300124054475`*^9, 3.496530013255449*^9}}],

Cell["\<\
Note: Constant factors in denominators are aggressively factored out to \
prevent them occurring unnecessarily in logarithm terms of antiderivatives!\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4965289702339883`*^9, {3.496529469454687*^9, 
   3.496529480824703*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"a", " ", "u", 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "a"}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{"u", 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.496528988494014*^9, 3.4965290052040377`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"u_", "/", "v_"}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
    "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"lst", "=", 
         RowBox[{"ConstantFactor", "[", 
          RowBox[{"v", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"ShowStep", "[", 
         RowBox[{
         "\"\<\>\"", ",", "\"\<Int[a*u,x]\>\"", ",", "\"\<a*Int[u,x]\>\"", 
          ",", 
          RowBox[{"Hold", "[", "\n", "  ", 
           RowBox[{"Dist", "[", 
            RowBox[{
             RowBox[{"1", "/", 
              RowBox[{"lst", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], ",", 
             RowBox[{"Int", "[", 
              RowBox[{
               RowBox[{"u", "/", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}], ",", "x"}], "]"}]}], "]"}],
            "]"}]}], "]"}], " ", "/;", "\n", " ", 
        RowBox[{
         RowBox[{"lst", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "=!=", "1"}]}]}], "]"}], " ", "/;", 
     "\n", 
     RowBox[{"SimplifyFlag", " ", "&&", " ", 
      RowBox[{"Not", "[", 
       RowBox[{"FalseQ", "[", 
        RowBox[{"DerivativeDivides", "[", 
         RowBox[{"v", ",", "u", ",", "x"}], "]"}], "]"}], "]"}]}]}]}], ",", 
   "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"u_", "/", "v_"}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
    "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"lst", "=", 
         RowBox[{"ConstantFactor", "[", 
          RowBox[{"v", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"Dist", "[", 
         RowBox[{
          RowBox[{"1", "/", 
           RowBox[{"lst", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], ",", 
          RowBox[{"Int", "[", 
           RowBox[{
            RowBox[{"u", "/", 
             RowBox[{"lst", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], ",", "x"}], "]"}]}], "]"}], 
        " ", "/;", "\n", " ", 
        RowBox[{
         RowBox[{"lst", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "=!=", "1"}]}]}], "]"}], " ", "/;", 
     "\n", 
     RowBox[{"Not", "[", 
      RowBox[{"FalseQ", "[", 
       RowBox[{"DerivativeDivides", "[", 
        RowBox[{"v", ",", "u", ",", "x"}], "]"}], "]"}], "]"}]}]}]}], 
  "]"}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.4965289767239976`*^9, 3.4965290568841095`*^9, 
   3.4965294545946665`*^9, 3.496529532054775*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4965289702339883`*^9, {3.496529469454687*^9, 
   3.496529480824703*^9}, {3.4965297180850353`*^9, 3.496529730605053*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    FractionBox[
     SuperscriptBox[
      RowBox[{"f", "[", "x", "]"}], "m"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", 
        RowBox[{"f", "[", "x", "]"}]}], ")"}], "m"]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4965289702339883`*^9, {3.496529469454687*^9, 
   3.496529480824703*^9}, {3.4965297180850353`*^9, 3.496529759975094*^9}}],

Cell[TextData[{
 "Rule: If ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "+", "n"}], "=", 
   RowBox[{
    RowBox[{"0", " ", "\[And]", " ", 
     RowBox[{"v", "+", "w"}]}], "=", "0"}]}]]]
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9, {
   3.496529645574934*^9, 3.4965296688349667`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox["v", "m"], " ", 
   SuperscriptBox["w", "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     SuperscriptBox["v", "m"]}]}], " ", 
   SuperscriptBox["w", "n"], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{"u", 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.496528988494014*^9, 3.4965290052040377`*^9}, {3.496529598604868*^9, 
   3.4965296210348997`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{"v_", "^", "m_"}], "*", 
     RowBox[{"w_", "^", "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
  "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"v", "^", "m"}], "*", 
      RowBox[{"w", "^", "n"}]}], ")"}], "*", 
    RowBox[{"Int", "[", 
     RowBox[{"u", ",", "x"}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"m", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"v", "+", "w"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.4965289767239976`*^9, 3.4965290568841095`*^9, 
   3.4965294545946665`*^9, 3.496529532054775*^9, 3.4965295743648343`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4965289702339883`*^9, {3.496529469454687*^9, 
   3.496529480824703*^9}, {3.4965297180850353`*^9, 3.496529730605053*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "m"]}]}], ")"}], "p"], 
     RowBox[{
      SuperscriptBox["x", 
       RowBox[{"m", " ", "p"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "b"}], "-", 
         FractionBox["a", 
          SuperscriptBox["x", "m"]]}], ")"}], "p"]}]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4965289702339883`*^9, {3.496529469454687*^9, 
   3.496529480824703*^9}, {3.4965297180850353`*^9, 3.496529759975094*^9}, 
   3.496529895705284*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", "d"}], "=", 
   RowBox[{
    RowBox[{"0", " ", "\[And]", " ", 
     RowBox[{"b", "+", "c"}]}], "=", 
    RowBox[{
     RowBox[{"0", " ", "\[And]", " ", 
      RowBox[{"m", "+", "n"}]}], "=", 
     RowBox[{
      RowBox[{"0", " ", "\[And]", " ", 
       RowBox[{"p", "+", "q"}]}], "=", "0"}]}]}]}]]]
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9, {
   3.496529645574934*^9, 3.4965296688349667`*^9}, {3.496529939925346*^9, 
   3.496529975715396*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "m"]}]}], ")"}], "p"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "n"]}]}], ")"}], "q"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", "m"]}]}], ")"}], "p"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", 
           SuperscriptBox["x", "n"]}]}], ")"}], "q"]}], 
      SuperscriptBox["x", 
       RowBox[{"m", " ", "p"}]]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{"u", " ", 
     SuperscriptBox["x", 
      RowBox[{"m", " ", "p"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.496528988494014*^9, 3.4965290052040377`*^9}, {3.496529598604868*^9, 
   3.4965296210348997`*^9}, {3.4965298452352133`*^9, 
   3.4965298650052414`*^9}, {3.496529919375317*^9, 3.4965299204053187`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "m_."}]}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], ")"}], "^", "q_."}]}], ",", " ", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"x", "^", "m"}]}]}], ")"}], "^", "p"}], "*", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "n"}]}]}], ")"}], "^", "q"}], "/", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "*", "p"}], ")"}]}]}], "*", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"u", "*", 
       RowBox[{"x", "^", 
        RowBox[{"(", 
         RowBox[{"m", "*", "p"}], ")"}]}]}], ",", "x"}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "m", ",", "n", ",", "p", ",", 
        "q"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"a", "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"b", "+", "c"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "q"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.4965289767239976`*^9, 3.4965290568841095`*^9, 
   3.4965294545946665`*^9, 3.496529532054775*^9, 3.4965295743648343`*^9, 
   3.4965298187251763`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.496527314841671*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.01.2, CRC 27, A&S 3.3.15", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496527241881569*^9}],

Cell["Derivation: Reciprocal rule for integration", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496527248491578*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.4965273487817183`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"-", "a"}], "+", 
     RowBox[{"b", " ", "x"}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"Log", "[", 
       RowBox[{"a", "-", 
        RowBox[{"b", " ", "x"}]}], "]"}], "b"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.4965272660216026`*^9, 3.4965272896916356`*^9}, {
   3.496527324581684*^9, 3.4965273395617056`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", "x_"}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{"-", "a"}], "-", 
      RowBox[{"b", "*", "x"}]}], "]"}], "/", "b"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NegativeCoefficientQ", "[", "a", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.496527222171541*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.01.2, CRC 27, A&S 3.3.15", "Subsubsection",
 CellChangeTimes->{3.496441803031353*^9, 3.4965273732217526`*^9}],

Cell["Derivation: Reciprocal rule for integration", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.49652737814176*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965273860117702`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"Log", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], "b"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496527397831787*^9, 3.4965274052017975`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", "*", "x"}]}], "]"}], "/", "b"}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496527216151533*^9, 
   3.496527365061741*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.01.1, CRC 7", "Subsubsection",
 CellChangeTimes->{3.496441803031353*^9, 3.4965273732217526`*^9, 
  3.4965274344418383`*^9}],

Cell["Derivation: Power rule for integration", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.49652737814176*^9, 3.4965274394218454`*^9}],

Cell[TextData[{
 "Rule: If ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "+", "1"}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965273860117702`*^9, {
   3.496527505001937*^9, 3.496527517081954*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SuperscriptBox["x", 
       RowBox[{"n", "+", "1"}]], 
      RowBox[{"n", "+", "1"}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496527397831787*^9, 3.4965274052017975`*^9}, {
   3.4965274586418724`*^9, 3.4965274787619004`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "^", "n_."}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
  "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}]}], "/", 
    RowBox[{"(", 
     RowBox[{"n", "+", "1"}], ")"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"IndependentQ", "[", 
     RowBox[{"n", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"n", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496527216151533*^9, 
   3.496527365061741*^9, 3.4965274971219263`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.01.1, CRC 23, A&S 3.3.14", "Subsubsection",
 CellChangeTimes->{3.496441803031353*^9, 3.4965273732217526`*^9, 
  3.4965274344418383`*^9, 3.4965275468219957`*^9}],

Cell["Derivation: Power rule for integration", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.49652737814176*^9, 3.4965274394218454`*^9}],

Cell[TextData[{
 "Rule: If ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "+", "1"}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965273860117702`*^9, {
   3.496527505001937*^9, 3.496527517081954*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], 
       RowBox[{"n", "+", "1"}]], 
      RowBox[{"b", " ", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496527397831787*^9, 3.4965274052017975`*^9}, {
   3.4965274586418724`*^9, 3.4965274787619004`*^9}, {3.4965275648620205`*^9, 
   3.4965275752520356`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "n_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], ")"}], "^", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}]}], "/", 
    RowBox[{"(", 
     RowBox[{"b", "*", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"n", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496527216151533*^9, 
   3.496527365061741*^9, 3.4965274971219263`*^9, 3.496527553692005*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{"a", " ", 
    SuperscriptBox["x", "m"]}]}], "+", 
  RowBox[{"b", " ", 
   SuperscriptBox["x", "n"]}], "+", 
  RowBox[{"\[CenterEllipsis]", 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.496527314841671*^9, 
   3.496527657662151*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: CRC 1,2,4,7,9", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496527241881569*^9, 3.496527701892213*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.4965273487817183`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", "a"}], "+", 
  RowBox[{"b", " ", "x"}], "+", 
  RowBox[{"c", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"\[CenterEllipsis]", 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "a"}]}], " ", "x"}], "+", 
  FractionBox[
   RowBox[{"b", " ", 
    SuperscriptBox["x", "2"]}], "2"], "+", 
  FractionBox[
   RowBox[{"c", " ", 
    SuperscriptBox["x", "3"]}], "3"], "+", 
  "\[CenterEllipsis]"}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.4965272660216026`*^9, 3.4965272896916356`*^9}, {
   3.496527324581684*^9, 3.4965273395617056`*^9}, {3.4965277565922894`*^9, 
   3.496527769922308*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"PolynomialQ", "[", 
        RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", 
       RowBox[{"ShowStep", "[", 
        RowBox[{
        "\"\<\>\"", ",", "\"\<Int[a+b*x+c*x^2+\[CenterEllipsis],x]\>\"", ",", 
         "\"\<a*x+b*x^2/2+c*x^3/3+\[CenterEllipsis]\>\"", ",", 
         RowBox[{"Hold", "[", "\n", "    ", 
          RowBox[{"IntegrateMonomialSum", "[", 
           RowBox[{"u", ",", "x"}], "]"}], "]"}]}], "]"}], ",", "\n", "  ", 
       RowBox[{"ShowStep", "[", 
        RowBox[{
        "\"\<\>\"", ",", "\"\<Int[a+b/x+c*x^m+\[CenterEllipsis],x]\>\"", ",", 
         "\"\<a*x+b*Log[x]+c*x^(m+1)/(m+1)+\[CenterEllipsis]\>\"", ",", 
         RowBox[{"Hold", "[", "\n", "  ", 
          RowBox[{"IntegrateMonomialSum", "[", 
           RowBox[{"u", ",", "x"}], "]"}], "]"}]}], "]"}]}], "]"}], " ", "/;",
      "\n", 
     RowBox[{"SimplifyFlag", " ", "&&", " ", 
      RowBox[{"MonomialSumQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}]}]}]}], ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"IntegrateMonomialSum", "[", 
      RowBox[{"u", ",", "x"}], "]"}], " ", "/;", "\n", 
     RowBox[{"MonomialSumQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}]}]}]}], "]"}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.496527222171541*^9, 3.496528172182871*^9, 3.496528629123511*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.02.2, CRC 2,4", "Subsubsection",
 CellChangeTimes->{3.496441803031353*^9, 3.4965273732217526`*^9, 
  3.496528032622676*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965273860117702`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{"a", " ", "u"}]}], "+", 
  RowBox[{"b", " ", "v"}], "+", 
  RowBox[{"\[CenterEllipsis]", 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "a"}]}], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{"u", 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "+", 
  RowBox[{"b", " ", 
   RowBox[{"\[Integral]", 
    RowBox[{"v", 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "+", 
  "\[CenterEllipsis]"}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.4965272660216026`*^9, 3.4965272896916356`*^9}, {
   3.496527324581684*^9, 3.4965273395617056`*^9}, {3.4965277565922894`*^9, 
   3.496527769922308*^9}, {3.496528083562747*^9, 3.4965280952427635`*^9}, 
   3.4965281273228083`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"lst", "=", 
         RowBox[{"SplitMonomialTerms", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"ShowStep", "[", 
         RowBox[{
         "\"\<\>\"", ",", "\"\<Int[a*u+b*v+\[CenterEllipsis],x]\>\"", ",", 
          "\"\<a*Int[u,x]+b*Int[v,x]+\[CenterEllipsis]\>\"", ",", 
          RowBox[{"Hold", "[", "\n", "  ", 
           RowBox[{
            RowBox[{"Int", "[", 
             RowBox[{
              RowBox[{"lst", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], " ", "+", 
            " ", 
            RowBox[{"SplitFreeIntegrate", "[", 
             RowBox[{
              RowBox[{"lst", "[", 
               RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}]}], "]"}]}], 
         "]"}], " ", "/;", "\n", " ", 
        RowBox[{
         RowBox[{"SumQ", "[", 
          RowBox[{"lst", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "&&", " ", 
         RowBox[{"Not", "[", 
          RowBox[{"FreeQ", "[", 
           RowBox[{
            RowBox[{"lst", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], "]"}], " ", "&&",
          " ", 
         RowBox[{
          RowBox[{"lst", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "=!=", "0"}]}]}]}], "]"}], " ", "/;",
      "\n", 
     RowBox[{"SimplifyFlag", " ", "&&", " ", 
      RowBox[{"SumQ", "[", "u", "]"}]}]}]}], ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"lst", "=", 
         RowBox[{"SplitMonomialTerms", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{
         RowBox[{"Int", "[", 
          RowBox[{
           RowBox[{"lst", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], " ", "+", " ", 
         RowBox[{"SplitFreeIntegrate", "[", 
          RowBox[{
           RowBox[{"lst", "[", 
            RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}]}], " ", "/;", 
        "\n", " ", 
        RowBox[{
         RowBox[{"SumQ", "[", 
          RowBox[{"lst", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "&&", " ", 
         RowBox[{"Not", "[", 
          RowBox[{"FreeQ", "[", 
           RowBox[{
            RowBox[{"lst", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], "]"}], " ", "&&",
          " ", 
         RowBox[{
          RowBox[{"lst", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "=!=", "0"}]}]}]}], "]"}], " ", "/;",
      "\n", 
     RowBox[{"SumQ", "[", "u", "]"}]}]}]}], "]"}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.496527222171541*^9, 3.4965276880821934`*^9, 3.4965280203426585`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965273732217526`*^9, 3.496528032622676*^9, {
   3.496528211282926*^9, 3.4965282261029468`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"z", 
    RowBox[{"(", 
     RowBox[{"u", "+", "v", "+", "\[CenterEllipsis]"}], ")"}]}], "=", 
   RowBox[{
    RowBox[{"z", " ", "u"}], "+", 
    RowBox[{"z", " ", "v"}], "+", "\[CenterEllipsis]"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965273732217526`*^9, 3.496528032622676*^9, {
   3.496528211282926*^9, 3.4965282261029468`*^9}, {3.4965283147830706`*^9, 
   3.496528365823142*^9}, {3.4965285137533493`*^9, 3.4965285243033643`*^9}}],

Cell[TextData[{
 "Rule: If ",
 Cell[BoxData[
  RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965273860117702`*^9, {
   3.4965284531732645`*^9, 3.4965284859633102`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"(", 
     RowBox[{"u", "+", "v", "+", "\[CenterEllipsis]"}], ")"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"\[Integral]", 
       RowBox[{
        SuperscriptBox["x", "m"], " ", "u"}]}]}]}]}]}], "+", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", "v"}], "+", 
  RowBox[{"\[CenterEllipsis]", 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.4965272660216026`*^9, 3.4965272896916356`*^9}, {
   3.496527324581684*^9, 3.4965273395617056`*^9}, {3.4965277565922894`*^9, 
   3.496527769922308*^9}, {3.496528083562747*^9, 3.4965280952427635`*^9}, 
   3.4965281273228083`*^9, {3.4965282508929815`*^9, 3.4965282783130198`*^9}, {
   3.4965284156832123`*^9, 3.4965284306632333`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x_", "^", "m_."}], "*", "u_"}], ",", "x_Symbol"}], "]"}], " ",
     ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"ShowStep", "[", 
      RowBox[{
      "\"\<\>\"", ",", 
       "\"\<Int[\!\(\*SuperscriptBox[\(x\), \
\(m\)]\)*(u+v+\[CenterEllipsis]),x]\>\"", ",", 
       "\"\<Int[\!\(\*SuperscriptBox[\(x\), \
\(m\)]\)*u+\!\(\*SuperscriptBox[\(x\), \(m\)]\)*v+\[CenterEllipsis],x]\>\"", 
       ",", 
       RowBox[{"Hold", "[", "\n", "  ", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{"Map", "[", 
           RowBox[{
            RowBox[{"Function", "[", 
             RowBox[{
              RowBox[{"x", "^", "m"}], "*", "#"}], "]"}], ",", "u"}], "]"}], 
          ",", "x"}], "]"}], "]"}]}], "]"}], " ", "/;", "\n", 
     RowBox[{"SimplifyFlag", " ", "&&", " ", 
      RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
      RowBox[{"SumQ", "[", "u", "]"}]}]}]}], ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x_", "^", "m_."}], "*", "u_"}], ",", "x_Symbol"}], "]"}], " ",
     ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"Map", "[", 
        RowBox[{
         RowBox[{"Function", "[", 
          RowBox[{
           RowBox[{"x", "^", "m"}], "*", "#"}], "]"}], ",", "u"}], "]"}], ",",
        "x"}], "]"}], " ", "/;", "\n", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
      RowBox[{"SumQ", "[", "u", "]"}]}]}]}]}], "]"}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.496527222171541*^9, 3.4965276880821934`*^9, 3.4965280203426585`*^9, 
   3.4965282038029156`*^9, {3.496528439283245*^9, 3.496528443953252*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"x", " ", 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{"u", "=", 
   RowBox[{"1", "+", 
    FractionBox[
     RowBox[{"2", " ", "b", " ", 
      SuperscriptBox["x", "n"]}], "a"]}]}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"x", " ", 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}]}]], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["2", 
      RowBox[{"a", " ", "n"}]]}], 
    FractionBox["1", 
     RowBox[{"1", "-", 
      SuperscriptBox["u", "2"]}]], 
    RowBox[{
     SubscriptBox["\[PartialD]", "x"], "u"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
  3.4964427205723457`*^9, 3.496442726484756*^9}, {3.4964511572548466`*^9, 
  3.496451196884902*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"a", "\[Element]", "\[DoubleStruckCapitalQ]"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"x", " ", 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox["2", 
       RowBox[{"a", " ", "n"}]]}]}]}], 
   RowBox[{"ArcTanh", "[", 
    RowBox[{"1", "+", 
     FractionBox[
      RowBox[{"2", " ", "b", " ", 
       SuperscriptBox["x", "n"]}], "a"]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"x_", "*", 
       RowBox[{"(", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"x_", "^", "n_."}]}]}], ")"}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], "*", 
    RowBox[{
     RowBox[{"ArcTanh", "[", 
      RowBox[{"1", "+", 
       RowBox[{"2", "*", "b", "*", 
        RowBox[{
         RowBox[{"x", "^", "n"}], "/", "a"}]}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"a", "*", "n"}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"PosQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"RationalQ", "[", "a", "]"}], " ", "||", " ", 
      RowBox[{"RationalQ", "[", 
       RowBox[{"b", "/", "a"}], "]"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.118.1, CRC 84", "Subsubsection",
 CellChangeTimes->{3.496441803031353*^9}],

Cell["\<\
Derivation: Algebraic expansion and reciprocal rule for integration\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"x", " ", 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}]}]], "=", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"a", " ", "x"}]], "-", 
    FractionBox[
     RowBox[{"b", " ", 
      SuperscriptBox["x", 
       RowBox[{"n", "-", "1"}]]}], 
     RowBox[{"a", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
   3.4964420168116527`*^9, 3.496442019391656*^9}, 3.496442294082041*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{"a", "\[Element]", "\[DoubleStruckCapitalQ]"}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"x", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"Log", "[", "x", "]"}], "a"]}]}]}]}], "-", 
  FractionBox[
   RowBox[{"Log", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}]}], "]"}], 
   RowBox[{"a", " ", "n"}]]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"x_", "*", 
       RowBox[{"(", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"x_", "^", "n_."}]}]}], ")"}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Log", "[", "x", "]"}], "/", "a"}], " ", "-", " ", 
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"x", "^", "n"}]}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"a", "*", "n"}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"PosQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"RationalQ", "[", "a", "]"}], " ", "||", " ", 
      RowBox[{"RationalQ", "[", 
       RowBox[{"b", "/", "a"}], "]"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Reciprocal rule for integration", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.4964451169563904`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"x", " ", 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}]}]], "=", 
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"n", "+", "1"}]], " ", 
     RowBox[{"(", 
      RowBox[{"b", "+", 
       FractionBox["a", 
        SuperscriptBox["x", "n"]]}], ")"}]}]]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
   3.4964420168116527`*^9, 3.496442019391656*^9}, 3.496442294082041*^9, 
   3.4964451682664623`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"\[Not]", 
   RowBox[{"(", 
    RowBox[{"n", ">", "0"}], ")"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, {3.4964452237165394`*^9, 3.496445227576545*^9}, 
   3.496452436736638*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"x", " ", 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"Log", "[", 
        RowBox[{"b", "+", 
         RowBox[{"a", " ", 
          SuperscriptBox["x", 
           RowBox[{"-", "n"}]]}]}], "]"}], 
       RowBox[{"a", " ", "n"}]]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, 3.496445204816513*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"x_", "*", 
       RowBox[{"(", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"x_", "^", "n_."}]}]}], ")"}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Log", "[", 
      RowBox[{"b", "+", 
       RowBox[{"a", "*", 
        RowBox[{"x", "^", 
         RowBox[{"(", 
          RowBox[{"-", "n"}], ")"}]}]}]}], "]"}]}], "/", 
    RowBox[{"(", 
     RowBox[{"a", "*", "n"}], ")"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"NegQ", "[", "n", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496445181986481*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.4964451169563904`*^9, 3.496445371246746*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "x"}], "+", 
    RowBox[{"b", " ", 
     SuperscriptBox["x", "n"]}]}], "=", 
   RowBox[{"x", " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", 
        RowBox[{"n", "-", "1"}]]}]}], ")"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
   3.4964420168116527`*^9, 3.496442019391656*^9}, 3.496442294082041*^9, 
   3.4964451682664623`*^9, {3.4964453823667617`*^9, 3.496445384486765*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, {3.4964452237165394`*^9, 3.496445227576545*^9}, 
   3.4964454614368725`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"a", " ", "x"}], "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"x", " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["x", 
             RowBox[{"n", "-", "1"}]]}]}], ")"}]}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, 3.496445204816513*^9, {3.496445407316797*^9, 
   3.496445427536825*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a_.", "*", "x_"}], "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ",
   ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"x", "*", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"x", "^", 
            RowBox[{"(", 
             RowBox[{"n", "-", "1"}], ")"}]}]}]}], ")"}]}], ")"}]}], ",", 
     "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496445181986481*^9, 
   3.4964454511268578`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.496445612017083*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Reference: G&R 2.110.2, CRC 26b special case with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "+", "n", "+", "2"}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4964478407902036`*^9, 3.4964483691709433`*^9, {
   3.4964548228299785`*^9, 3.4964548427400064`*^9}}],

Cell[TextData[{
 "Rule: If ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "+", "n", "+", "2"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"n", "+", "1"}], "\[NotEqual]", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, {3.4964481375106187`*^9, 
   3.4964481388906207`*^9}, {3.496448178260676*^9, 3.496448200430707*^9}, {
   3.496448348650914*^9, 3.496448353260921*^9}, {3.49645485254002*^9, 
   3.496454868040042*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"a", " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, 3.4964478866102676`*^9, 3.496447920350315*^9, 
   3.4964483401309023`*^9, 3.4964548057299547`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], "*", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"a", "*", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", "n", "+", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"n", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496447831820191*^9, 
   3.4964483218708773`*^9, 3.496454792569936*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.110.2, CRC 26b", "Subsubsection",
 CellChangeTimes->{3.496441803031353*^9, 3.4964478407902036`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4964478407902036`*^9, 3.4964483691709433`*^9, {
   3.4964484199210143`*^9, 3.4964484415510445`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], "=", 
   RowBox[{
    SuperscriptBox["x", 
     RowBox[{"m", "+", "n", "+", "2"}]], 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "n"], 
     SuperscriptBox["x", 
      RowBox[{"n", "+", "2"}]]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4964478407902036`*^9, 3.4964483691709433`*^9, 
   3.4964484199210143`*^9, {3.496448510631141*^9, 3.4964485113411427`*^9}, {
   3.4964485725412283`*^9, 3.4964485892612514`*^9}, {3.4964486341713142`*^9, 
   3.4964486375613194`*^9}, {3.4964488520916195`*^9, 3.4964488620316334`*^9}}],

Cell[TextData[{
 "Rule: If ",
 Cell[BoxData[
  RowBox[{"m", ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"0", "<", "m", "<", 
     RowBox[{
      RowBox[{"-", "n"}], "-", "2"}]}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "m"}], "+", "n", "+", "1"}], ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, {3.4964481375106187`*^9, 
   3.4964481388906207`*^9}, {3.496448178260676*^9, 3.496448200430707*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox["x", 
          RowBox[{"m", "+", "1"}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}], ")"}], 
          RowBox[{"n", "+", "1"}]]}], 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"m", "+", "n", "+", "2"}], 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, 3.4964478866102676`*^9, 3.496447920350315*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "n", "+", "2"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"0", "<", "m", "<", 
     RowBox[{
      RowBox[{"-", "n"}], "-", "2"}]}], " ", "&&", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "*", "m"}], "+", "n", "+", "1"}], ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496447831820191*^9, 
   3.517190973589192*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.110.1, CRC 26a", "Subsubsection",
 CellChangeTimes->{3.496441803031353*^9, 3.4964478407902036`*^9, 
  3.4964483691709433`*^9}],

Cell["Derivation: Inverted integration by parts", "Subsubsection",
 CellChangeTimes->{3.496441803031353*^9, 3.4964478407902036`*^9, 
  3.4964483691709433`*^9, 3.4964484199210143`*^9}],

Cell[TextData[{
 "Rule: If ",
 Cell[BoxData[
  RowBox[{"m", ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"0", "<", "n", "<", 
     RowBox[{"m", "/", "2"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, {3.4964481375106187`*^9, 
   3.4964481388906207`*^9}, {3.496448178260676*^9, 3.496448200430707*^9}, {
   3.496448348650914*^9, 3.496448353260921*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], 
       RowBox[{"m", "+", "n", "+", "1"}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", "n"}], 
    RowBox[{"m", "+", "n", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, 3.4964478866102676`*^9, 3.496447920350315*^9, 
   3.4964483401309023`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "n", "+", "1"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"n", "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "n", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"0", "<", "n", "<", 
     RowBox[{"m", "/", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496447831820191*^9, 
   3.4964483218708773`*^9, 3.517190973620392*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.110.6, CRC 88c", "Subsubsection",
 CellChangeTimes->{3.496441803031353*^9, 3.4964478407902036`*^9, 
  3.4964483691709433`*^9, 3.496448506131135*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4964478407902036`*^9, 3.4964483691709433`*^9, 
   3.4964484199210143`*^9, {3.496448510631141*^9, 3.4964485113411427`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], "=", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "m"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], 
      RowBox[{"m", "+", "2"}]]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], 
     RowBox[{"m", "+", "n", "+", "2"}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4964478407902036`*^9, 3.4964483691709433`*^9, 
   3.4964484199210143`*^9, {3.496448510631141*^9, 3.4964485113411427`*^9}, {
   3.4964485725412283`*^9, 3.4964485892612514`*^9}, {3.4964486341713142`*^9, 
   3.4964486375613194`*^9}}],

Cell[TextData[{
 "Rule: If ",
 Cell[BoxData[
  RowBox[{"m", ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"0", "<", "n", "<", 
     RowBox[{
      RowBox[{"-", "m"}], "-", "2"}]}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "+", 
      RowBox[{"2", "n"}], "-", "1"}], ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, {3.4964481375106187`*^9, 
   3.4964481388906207`*^9}, {3.496448178260676*^9, 3.496448200430707*^9}, {
   3.496448348650914*^9, 3.496448353260921*^9}, {3.4964485307511697`*^9, 
   3.496448543411187*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"a", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"b", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "n", "+", "2"}], ")"}]}], 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, 3.4964478866102676`*^9, 3.496447920350315*^9, 
   3.4964483401309023`*^9, 3.496448712961425*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "n", "+", "2"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"a", "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"0", "<", "n", "<", 
     RowBox[{
      RowBox[{"-", "m"}], "-", "2"}]}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"m", "+", 
      RowBox[{"2", "*", "n"}], "-", "1"}], ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496447831820191*^9, 
   3.4964483218708773`*^9, 3.4964484972511225`*^9, 3.5171909736515923`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.110.5, CRC 26c", "Subsubsection",
 CellChangeTimes->{3.496441803031353*^9, 3.4964478407902036`*^9, 
  3.4964483691709433`*^9, 3.496448506131135*^9, 3.4964489630617747`*^9}],

Cell["Derivation: Inverted integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4964478407902036`*^9, 3.4964483691709433`*^9, 
   3.4964484199210143`*^9, {3.496448510631141*^9, 3.4964485113411427`*^9}, 
   3.4964489693517838`*^9}],

Cell[TextData[{
 "Rule: If ",
 Cell[BoxData[
  RowBox[{"m", ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"0", "<", "m", "<", 
     RowBox[{"n", "/", "2"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, {3.4964481375106187`*^9, 
   3.4964481388906207`*^9}, {3.496448178260676*^9, 3.496448200430707*^9}, {
   3.496448348650914*^9, 3.496448353260921*^9}, {3.4964485307511697`*^9, 
   3.496448543411187*^9}, {3.4964490077818375`*^9, 3.496449010851842*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", "m"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "n", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", "m"}], 
    RowBox[{"b", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "n", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, 3.4964478866102676`*^9, 3.496447920350315*^9, 
   3.4964483401309023`*^9, 3.496448712961425*^9, 3.49644899548182*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "m"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"m", "/", 
        RowBox[{"(", 
         RowBox[{"b", "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "n", "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"0", "<", "m", "<", 
     RowBox[{"n", "/", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496447831820191*^9, 
   3.4964483218708773`*^9, 3.4964484972511225`*^9, 3.4964489759917927`*^9, 
   3.517190973667192*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.496449093121957*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496449271012206*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"b", " ", "c"}], "+", 
    RowBox[{"a", " ", "d"}]}], "=", "0"}]]],
 ",",
 " then",
 " ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], ")"}]}], "=", 
   RowBox[{
    RowBox[{"a", " ", "c"}], "+", 
    RowBox[{"b", " ", "d", " ", 
     SuperscriptBox["x", "2"]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
   3.4964427205723457`*^9, 3.496442726484756*^9}, {3.4964491280420055`*^9, 
   3.496449157712047*^9}, 3.496961513558815*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{
     RowBox[{"b", " ", "c"}], "+", 
     RowBox[{"a", " ", "d"}]}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496449227252145*^9, 
   3.496449249722176*^9}, 3.496961536758847*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", " ", "c"}], "+", 
          RowBox[{"b", " ", "d", " ", 
           SuperscriptBox["x", "2"]}]}], ")"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496449181922081*^9, 3.4964492149121275`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "n_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "*", "c"}], "+", 
        RowBox[{"b", "*", "d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "n"}], ",", "x"}], "]"}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "c"}], "+", 
      RowBox[{"a", "*", "d"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.496449106581976*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.4964493315022907`*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"b", " ", "c"}], "-", 
    RowBox[{"a", " ", "d"}]}], "=", "0"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ",",
 " then",
 " ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], ")"}], "n"]}], "=", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["d", "b"], ")"}], "n"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], 
     RowBox[{"m", "+", "n"}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
   3.4964420168116527`*^9, 3.496442019391656*^9}, 3.496442294082041*^9, {
   3.4964502280635457`*^9, 3.496450274943611*^9}, {3.496961525638832*^9, 
   3.496961530068838*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"b", " ", "c"}], "-", 
    RowBox[{"a", " ", "d"}]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, {3.49645029529364*^9, 3.4964502998236465`*^9}, 
   3.4969615317088404`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["d", "b"], ")"}], "n"]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], 
      RowBox[{"m", "+", "n"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.4964493534423213`*^9, 3.496449378302356*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "/", "b"}], ")"}], "^", "n"}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"m", "+", "n"}], ")"}]}], ",", "x"}], "]"}]}], "]"}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "m"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "c"}], "-", 
      RowBox[{"a", "*", "d"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", "\n", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Not", "[", 
       RowBox[{"IntegerQ", "[", "m", "]"}], "]"}], " ", "||", " ", 
      RowBox[{
       RowBox[{"LeafCount", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "<=", 
       RowBox[{"LeafCount", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.49644932365228*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.4964493315022907`*^9, 3.4964503408037033`*^9, {3.496450597264063*^9, 
   3.4964506003840666`*^9}}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{"u", "=", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"b", " ", "c"}], "+", 
      RowBox[{"a", " ", "d"}]}], 
     RowBox[{
      RowBox[{"b", " ", "c"}], "-", 
      RowBox[{"a", " ", "d"}]}]], "+", 
    FractionBox[
     RowBox[{"2", " ", "b", " ", "d", " ", "x"}], 
     RowBox[{
      RowBox[{"b", " ", "c"}], "-", 
      RowBox[{"a", " ", "d"}]}]]}]}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], ")"}]}]], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["2", 
      RowBox[{
       RowBox[{"b", " ", "c"}], "-", 
       RowBox[{"a", " ", "d"}]}]]}], 
    FractionBox["1", 
     RowBox[{"1", "-", 
      SuperscriptBox["u", "2"]}]], 
    RowBox[{
     SubscriptBox["\[PartialD]", "x"], "u"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
   3.4964420168116527`*^9, 3.496442019391656*^9}, 3.496442294082041*^9, {
   3.4964502280635457`*^9, 3.496450274943611*^9}, {3.4964505451039896`*^9, 
   3.4964505785040364`*^9}, {3.496450648824135*^9, 3.496450730264249*^9}}],

Cell[TextData[{
 "Note: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"b", " ", "c"}], "-", 
    RowBox[{"a", " ", "d"}]}], "\[NotElement]", "\[DoubleStruckCapitalQ]"}]]],
 ", partial fraction expansion produces two nicer looking log terms."
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.4964493315022907`*^9, 3.4964503408037033`*^9, {3.496450597264063*^9, 
   3.4964506003840666`*^9}, {3.496451012954644*^9, 3.4964510939947577`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"b", " ", "c"}], "-", 
     RowBox[{"a", " ", "d"}]}], "\[Element]", "\[DoubleStruckCapitalQ]"}], 
   " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"b", " ", "c"}], "-", 
     RowBox[{"a", " ", "d"}]}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, {3.49645029529364*^9, 3.4964502998236465`*^9}, {
   3.496450923204519*^9, 3.4964509431445465`*^9}, 3.496451043044687*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], ")"}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox["2", 
       RowBox[{
        RowBox[{"b", " ", "c"}], "-", 
        RowBox[{"a", " ", "d"}]}]]}]}]}], 
   RowBox[{"ArcTanh", "[", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"b", " ", "c"}], "+", 
       RowBox[{"a", " ", "d"}]}], 
      RowBox[{
       RowBox[{"b", " ", "c"}], "-", 
       RowBox[{"a", " ", "d"}]}]], "+", 
     FractionBox[
      RowBox[{"2", " ", "b", " ", "d", " ", "x"}], 
      RowBox[{
       RowBox[{"b", " ", "c"}], "-", 
       RowBox[{"a", " ", "d"}]}]]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.4964493534423213`*^9, 3.496449378302356*^9}, 
   3.496450375513752*^9, {3.4964504795438976`*^9, 3.496450504703933*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", "x_"}]}], ")"}], "*", 
       RowBox[{"(", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", "x_"}]}], ")"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], "*", 
    RowBox[{
     RowBox[{"ArcTanh", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "*", "c"}], "+", 
          RowBox[{"a", "*", "d"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "*", "c"}], "-", 
          RowBox[{"a", "*", "d"}]}], ")"}]}], " ", "+", " ", 
       RowBox[{"2", "*", "b", "*", "d", "*", 
        RowBox[{"x", "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", "*", "c"}], "-", 
           RowBox[{"a", "*", "d"}]}], ")"}]}]}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", "*", "c"}], "-", 
       RowBox[{"a", "*", "d"}]}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "c"}], "-", 
      RowBox[{"a", "*", "d"}]}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"b", "*", "c"}], "-", 
      RowBox[{"a", "*", "d"}]}], "!=", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.49644932365228*^9, 
   3.4964503461137114`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Reference: G&R 2.155, CRC 59a special case when ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "+", "n", "+", "2"}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.4964493315022907`*^9, 3.4964513080550575`*^9, {3.4964514809452996`*^9, 
   3.496451481865301*^9}, {3.4964515963254614`*^9, 3.4964516058354745`*^9}}],

Cell[TextData[{
 "Rule: If ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "+", "n", "+", "2"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"b", " ", "c"}], "-", 
      RowBox[{"a", " ", "d"}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"n", "+", "1"}], "\[NotEqual]", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, {3.49645029529364*^9, 3.4964502998236465`*^9}, {
   3.4964514009851875`*^9, 3.4964514300852284`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}], 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], ")"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "c"}], "-", 
          RowBox[{"a", " ", "d"}]}], ")"}]}]]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.4964493534423213`*^9, 3.496449378302356*^9}, 
   3.496451326205083*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], "*", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}], "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "c"}], "-", 
         RowBox[{"a", "*", "d"}]}], ")"}]}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "m", ",", "n"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", "n", "+", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "c"}], "-", 
      RowBox[{"a", "*", "d"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"n", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.49644932365228*^9, 
   3.4964513009550476`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.155, CRC 59a", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.4964493315022907`*^9, 3.496451842475806*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.4964493315022907`*^9, 3.496451849815816*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], ")"}], "n"]}], "=", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], 
     RowBox[{"m", "+", "n", "+", "2"}]], " ", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}], "n"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], 
      RowBox[{"n", "+", "2"}]]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
   3.4964420168116527`*^9, 3.496442019391656*^9}, 3.496442294082041*^9, {
   3.4964502280635457`*^9, 3.496450274943611*^9}, {3.496451862475834*^9, 
   3.496451900615887*^9}}],

Cell[TextData[{
 "Rule: If ",
 Cell[BoxData[
  RowBox[{"m", ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{
     RowBox[{
      RowBox[{"b", " ", "c"}], "-", 
      RowBox[{"a", " ", "d"}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{"0", "<", "m", "<", 
     RowBox[{
      RowBox[{"-", "n"}], "-", "2"}]}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "m"}], "+", "n", "+", "1"}], ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, {3.4964481375106187`*^9, 
   3.4964481388906207`*^9}, {3.496448178260676*^9, 3.496448200430707*^9}, {
   3.4964517844857244`*^9, 3.496451810525761*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}], ")"}], 
          RowBox[{"m", "+", "1"}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], ")"}], 
          RowBox[{"n", "+", "1"}]]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", " ", "c"}], "-", 
           RowBox[{"a", " ", "d"}]}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"b", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "n", "+", "2"}], ")"}]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", " ", "c"}], "-", 
       RowBox[{"a", " ", "d"}]}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "m"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.4964493534423213`*^9, 3.496449378302356*^9}, 
   3.4964516834955835`*^9, 3.4964517193856335`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "*", "c"}], "-", 
          RowBox[{"a", "*", "d"}]}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "n", "+", "2"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"b", "*", "c"}], "-", 
            RowBox[{"a", "*", "d"}]}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "^", "m"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "c"}], "-", 
      RowBox[{"a", "*", "d"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"0", "<", "m", "<", 
     RowBox[{
      RowBox[{"-", "n"}], "-", "2"}]}], " ", "&&", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "*", "m"}], "+", "n", "+", "1"}], ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.49644932365228*^9, 
   3.4964516648155575`*^9, 3.517190973776392*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.151, CRC 59b", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.4964493315022907`*^9, 3.496451842475806*^9, 3.496451944465949*^9}],

Cell["Derivation: Inverted integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.4964493315022907`*^9, 3.496451849815816*^9, 3.4964519519959593`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{
     RowBox[{
      RowBox[{"b", " ", "c"}], "-", 
      RowBox[{"a", " ", "d"}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{"0", "<", "n", "\[LessEqual]", "m"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, {3.4964481375106187`*^9, 
   3.4964481388906207`*^9}, {3.496448178260676*^9, 3.496448200430707*^9}, {
   3.4964517844857244`*^9, 3.496451810525761*^9}, {3.4964519995860257`*^9, 
   3.4964520042560325`*^9}, 3.4969615560488744`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}], 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], ")"}], "n"]}], 
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "n", "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"n", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", " ", "c"}], "-", 
       RowBox[{"a", " ", "d"}]}], ")"}]}], 
    RowBox[{"b", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "n", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "m"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.4964493534423213`*^9, 3.496449378302356*^9}, 
   3.4964516834955835`*^9, 3.4964517193856335`*^9, 3.496451976855994*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], ")"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "*", "c"}], "-", 
          RowBox[{"a", "*", "d"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"b", "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "n", "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "^", "m"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "c"}], "-", 
      RowBox[{"a", "*", "d"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"0", "<", "n", "<=", "m"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.49644932365228*^9, 
   3.4964516648155575`*^9, 3.496451958785969*^9, 3.517190973807592*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.496452079636138*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496449271012206*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"b", " ", "c"}], "+", 
    RowBox[{"a", " ", "d"}]}], "=", "0"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], ")"}]}], "=", 
   RowBox[{
    RowBox[{"a", " ", "c"}], "+", 
    RowBox[{"b", " ", "d", " ", 
     SuperscriptBox["x", "2"]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
  3.4964427205723457`*^9, 3.496442726484756*^9}, {3.4964491280420055`*^9, 
  3.496449157712047*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{
     RowBox[{"b", " ", "c"}], "+", 
     RowBox[{"a", " ", "d"}]}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.4964521079161777`*^9, 3.496452138926221*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox["x", "m"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", " ", "c"}], "+", 
          RowBox[{"b", " ", "d", " ", 
           SuperscriptBox["x", "2"]}]}], ")"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.4964521507262373`*^9, 3.496452189666292*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "n_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "m"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "*", "c"}], "+", 
         RowBox[{"b", "*", "d", "*", 
          RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "n"}]}], ",", "x"}], "]"}],
    " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "m"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "c"}], "+", 
      RowBox[{"a", "*", "d"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.496452093256157*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496449271012206*^9, 3.49645257397683*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    RowBox[{"(", 
     RowBox[{"x", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "n"]}]}], ")"}], 
       RowBox[{"p", "+", "1"}]]}], ")"}]}], "=", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], "p"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"n", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], ")"}], " ", 
       SuperscriptBox["x", "n"]}]}], ")"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
   3.4964420168116527`*^9, 3.496442019391656*^9}, 3.496442294082041*^9, {
   3.4964522741864104`*^9, 3.4964522767164135`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "d"}], "-", 
    RowBox[{"b", " ", "c", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"n", " ", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], ")"}]}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, {3.49645240274659*^9, 3.4964524185566125`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], ")"}], "p"], " ", 
   RowBox[{"(", 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "n"]}]}], ")"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"c", " ", "x", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", "n"]}]}], ")"}], 
        RowBox[{"p", "+", "1"}]]}], "a"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.4964523392765017`*^9, 3.4964523790865574`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{"(", 
      RowBox[{"c_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], ")"}]}], ",", " ", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"c", "*", "x", "*", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"x", "^", "n"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}], "/", "a"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "n", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "d"}], "-", 
      RowBox[{"b", "*", "c", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"n", "*", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], ")"}]}]}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496452257776387*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496449271012206*^9, 3.49645257397683*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", 
       RowBox[{"m", "+", "1"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "n"]}]}], ")"}], 
       RowBox[{"p", "+", "1"}]]}], ")"}]}], "=", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], "p"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", " ", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}], "+", 
      RowBox[{"b", " ", 
       RowBox[{"(", 
        RowBox[{"m", "+", 
         RowBox[{"n", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], ")"}], " ", 
       SuperscriptBox["x", "n"]}]}], ")"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
   3.4964420168116527`*^9, 3.496442019391656*^9}, 3.496442294082041*^9, {
   3.4964522741864104`*^9, 3.4964522767164135`*^9}, {3.496452621296896*^9, 
   3.4964526238969*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"a", " ", "d", " ", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "-", 
     RowBox[{"b", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{"m", "+", 
        RowBox[{"n", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], ")"}]}]}]}], "=", 
   "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, {3.49645240274659*^9, 3.4964524185566125`*^9}, {
   3.496452642586926*^9, 3.496452678376976*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], ")"}], "p"], " ", 
   RowBox[{"(", 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "n"]}]}], ")"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"c", " ", 
       SuperscriptBox["x", 
        RowBox[{"m", "+", "1"}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", "n"]}]}], ")"}], 
        RowBox[{"p", "+", "1"}]]}], 
      RowBox[{"a", " ", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.4964523392765017`*^9, 3.4964523790865574`*^9}, {
   3.4964527120370235`*^9, 3.496452734707055*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{"(", 
      RowBox[{"c_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], ")"}]}], ",", " ", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"c", "*", 
    RowBox[{"x", "^", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}], "*", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"x", "^", "n"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"a", "*", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "m", ",", "n", ",", "p"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "d", "*", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}], "-", 
      RowBox[{"b", "*", "c", "*", 
       RowBox[{"(", 
        RowBox[{"m", "+", 
         RowBox[{"n", "*", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], ")"}]}]}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496452257776387*^9, 
   3.4964526617269526`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496449271012206*^9, 3.49645257397683*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", 
       RowBox[{"m", "+", "1"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "n"]}]}], ")"}], 
       RowBox[{"p", "+", "1"}]]}], ")"}]}], "=", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], "p"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", " ", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}], "+", 
      RowBox[{"b", " ", 
       RowBox[{"(", 
        RowBox[{"m", "+", 
         RowBox[{"n", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], ")"}], " ", 
       SuperscriptBox["x", "n"]}]}], ")"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
   3.4964420168116527`*^9, 3.496442019391656*^9}, 3.496442294082041*^9, {
   3.4964522741864104`*^9, 3.4964522767164135`*^9}, {3.496452621296896*^9, 
   3.4964526238969*^9}, {3.496452778417116*^9, 3.4964527799371185`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"m", "+", "q", "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", 
    " ", 
    RowBox[{
     RowBox[{"a", " ", "d", " ", 
      RowBox[{"(", 
       RowBox[{"m", "+", "q", "+", "1"}], ")"}]}], "-", 
     RowBox[{"b", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{"m", "+", "q", "+", 
        RowBox[{"n", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], ")"}]}]}]}], "=", 
   "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, {3.49645240274659*^9, 3.4964524185566125`*^9}, {
   3.496452642586926*^9, 3.496452678376976*^9}, {3.4964528128571644`*^9, 
   3.496452857057226*^9}, {3.4964529936274176`*^9, 3.496452997117422*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], ")"}], "p"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"c", " ", 
      SuperscriptBox["x", "q"]}], "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", 
       RowBox[{"n", "+", "q"}]]}]}], ")"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"c", " ", 
       SuperscriptBox["x", 
        RowBox[{"m", "+", "q", "+", "1"}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", "n"]}]}], ")"}], 
        RowBox[{"p", "+", "1"}]]}], 
      RowBox[{"a", " ", 
       RowBox[{"(", 
        RowBox[{"m", "+", "q", "+", "1"}], ")"}]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.4964523392765017`*^9, 3.4964523790865574`*^9}, {
   3.4964527120370235`*^9, 3.496452734707055*^9}, 3.496452802107149*^9, {
   3.4964529143673067`*^9, 3.496452946467352*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "q_."}]}], "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"x_", "^", "r_."}]}]}], ")"}]}], ",", " ", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"c", "*", 
    RowBox[{"x", "^", 
     RowBox[{"(", 
      RowBox[{"m", "+", "q", "+", "1"}], ")"}]}], "*", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"x", "^", "n"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"a", "*", 
       RowBox[{"(", 
        RowBox[{"m", "+", "q", "+", "1"}], ")"}]}], ")"}]}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "m", ",", "n", ",", "p", ",", 
        "q", ",", "r"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"r", "-", "n", "-", "q"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "q", "+", "1"}], "]"}], " ", "&&", " ", "\n", "\t", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "d", "*", 
       RowBox[{"(", 
        RowBox[{"m", "+", "q", "+", "1"}], ")"}]}], "-", 
      RowBox[{"b", "*", "c", "*", 
       RowBox[{"(", 
        RowBox[{"m", "+", "q", "+", 
         RowBox[{"n", "*", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], ")"}]}]}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496452257776387*^9, 
   3.4964526617269526`*^9, 3.496452764157096*^9, {3.496452873107249*^9, 
   3.496452902017289*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"m", "+", "n", "+", "2"}], "\[NotEqual]", "0"}], " ", "\[And]", 
    " ", 
    RowBox[{
     RowBox[{"f", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", " ", "c", " ", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], "+", 
        RowBox[{"a", " ", "d", " ", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}]}], ")"}]}], "-", 
     RowBox[{"b", " ", "d", " ", "e", " ", 
      RowBox[{"(", 
       RowBox[{"m", "+", "n", "+", "2"}], ")"}]}]}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, {3.49645240274659*^9, 3.4964524185566125`*^9}, {
   3.496452642586926*^9, 3.496452678376976*^9}, {3.4964528128571644`*^9, 
   3.496452857057226*^9}, {3.4964529936274176`*^9, 3.496452997117422*^9}, {
   3.4964531234075994`*^9, 3.496453141847625*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], ")"}], "n"], " ", 
   RowBox[{"(", 
    RowBox[{"e", "+", 
     RowBox[{"f", " ", "x"}]}], ")"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"f", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], 
        RowBox[{"m", "+", "1"}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], ")"}], 
        RowBox[{"n", "+", "1"}]]}], 
      RowBox[{"b", " ", "d", " ", 
       RowBox[{"(", 
        RowBox[{"m", "+", "n", "+", "2"}], ")"}]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.4964523392765017`*^9, 3.4964523790865574`*^9}, {
   3.4964527120370235`*^9, 3.496452734707055*^9}, 3.496452802107149*^9, {
   3.4964529143673067`*^9, 3.496452946467352*^9}, {3.4964530415274844`*^9, 
   3.496453101707569*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "n_."}], "*", 
     RowBox[{"(", 
      RowBox[{"e_", "+", 
       RowBox[{"f_.", "*", "x_"}]}], ")"}]}], ",", " ", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"f", "*", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], ")"}], "^", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}], "*", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"b", "*", "d", "*", 
       RowBox[{"(", 
        RowBox[{"m", "+", "n", "+", "2"}], ")"}]}], ")"}]}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "m", ",", 
        "n"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "n", "+", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"f", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "c", "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "+", 
         RowBox[{"a", "*", "d", "*", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{"b", "*", "d", "*", "e", "*", 
       RowBox[{"(", 
        RowBox[{"m", "+", "n", "+", "2"}], ")"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496452257776387*^9, 
   3.4964526617269526`*^9, 3.496452764157096*^9, {3.496452873107249*^9, 
   3.496452902017289*^9}, 3.4964530320774713`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", ",", 
   RowBox[{
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"0", "<", "n", "\[LessEqual]", "2"}], " ", "\[And]", " ", 
    RowBox[{"p", ">", "5"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, {3.49645240274659*^9, 3.4964524185566125`*^9}, {
   3.496452642586926*^9, 3.496452678376976*^9}, {3.4964528128571644`*^9, 
   3.496452857057226*^9}, {3.4964529936274176`*^9, 3.496452997117422*^9}, {
   3.4964531234075994`*^9, 3.496453141847625*^9}, {3.49645327385781*^9, 
   3.4964533147778673`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{"x", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}], 
         RowBox[{"n", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], ")"}], 
         RowBox[{"p", "+", "1"}]]}], 
       RowBox[{"b", " ", "d", " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "n", "+", "p"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"b", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}], "+", 
     RowBox[{"a", " ", "d", " ", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}]}], 
    RowBox[{"b", " ", "d", " ", 
     RowBox[{"(", 
      RowBox[{"2", "+", "n", "+", "p"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}], "p"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.4964523392765017`*^9, 3.4964523790865574`*^9}, {
   3.4964527120370235`*^9, 3.496452734707055*^9}, 3.496452802107149*^9, {
   3.4964529143673067`*^9, 3.496452946467352*^9}, {3.4964530415274844`*^9, 
   3.496453101707569*^9}, {3.49645320941772*^9, 3.4964532368477583`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "n_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "p_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{"2", "+", "n", "+", "p"}], ")"}]}], ")"}]}]}], " ", "-", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "c", "*", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}], "+", 
         RowBox[{"a", "*", "d", "*", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", "d", "*", 
         RowBox[{"(", 
          RowBox[{"2", "+", "n", "+", "p"}], ")"}]}], ")"}]}], ",", " ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}], "^", "p"}]}], ",", " ", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "n", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"n", ",", "p"}], "]"}], " ", "&&", " ", 
    RowBox[{"0", "<", "n", "<=", "2"}], " ", "&&", " ", 
    RowBox[{"p", ">", "5"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496452257776387*^9, 
   3.4964526617269526`*^9, 3.496452764157096*^9, {3.496452873107249*^9, 
   3.496452902017289*^9}, 3.4964530320774713`*^9, {3.4964531814176807`*^9, 
   3.496453187697689*^9}, {3.5171911762647476`*^9, 3.517191178776352*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", "n", ",", 
   RowBox[{
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"0", "<", "m", "\[LessEqual]", "2"}], " ", "\[And]", " ", 
    RowBox[{"0", "<", "n", "\[LessEqual]", "2"}], " ", "\[And]", " ", 
    RowBox[{"p", ">", "5"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, {3.49645240274659*^9, 3.4964524185566125`*^9}, {
   3.496452642586926*^9, 3.496452678376976*^9}, {3.4964528128571644`*^9, 
   3.496452857057226*^9}, {3.4964529936274176`*^9, 3.496452997117422*^9}, {
   3.4964531234075994`*^9, 3.496453141847625*^9}, {3.49645327385781*^9, 
   3.4964533147778673`*^9}, {3.4964533490479155`*^9, 3.496453374767951*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "-", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}], 
         RowBox[{"n", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], ")"}], 
         RowBox[{"p", "+", "1"}]]}], 
       RowBox[{"b", " ", "d", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "m", "+", "n", "+", "p"}], ")"}]}]]}]}]}]}], "-", 
  "                                                                           \
           ", "\[IndentingNewLine]", "   ", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", "c", " ", 
     RowBox[{"(", 
      RowBox[{"m", "-", "1"}], ")"}]}], 
    RowBox[{"b", " ", "d", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "m", "+", "n", "+", "p"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}], "p"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"b", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{"m", "+", "n"}], ")"}]}], "+", 
     RowBox[{"a", " ", "d", " ", 
      RowBox[{"(", 
       RowBox[{"m", "+", "p"}], ")"}]}]}], 
    RowBox[{"b", " ", "d", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "m", "+", "n", "+", "p"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}], "p"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.4964523392765017`*^9, 3.4964523790865574`*^9}, {
   3.4964527120370235`*^9, 3.496452734707055*^9}, 3.496452802107149*^9, {
   3.4964529143673067`*^9, 3.496452946467352*^9}, {3.4964530415274844`*^9, 
   3.496453101707569*^9}, {3.49645320941772*^9, 3.4964532368477583`*^9}, {
   3.49645342386802*^9, 3.4964534794980974`*^9}, {3.4969489214923615`*^9, 
   3.496948925702368*^9}, {3.4969490257625074`*^9, 3.49694902737251*^9}, {
   3.4969491312826557`*^9, 3.496949131762656*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "n_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "p_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{"1", "+", "m", "+", "n", "+", "p"}], ")"}]}], ")"}]}]}], " ",
     "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", "c", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "-", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"b", "*", "d", "*", 
          RowBox[{"(", 
           RowBox[{"1", "+", "m", "+", "n", "+", "p"}], ")"}]}], ")"}]}]}], 
      ",", " ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}], "^", "p"}]}], ",", " ", "x"}], 
       "]"}]}], "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "c", "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "n"}], ")"}]}], "+", 
         RowBox[{"a", "*", "d", "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "p"}], ")"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", "d", "*", 
         RowBox[{"(", 
          RowBox[{"1", "+", "m", "+", "n", "+", "p"}], ")"}]}], ")"}]}], ",", 
      " ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}], "^", "p"}]}], ",", " ", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "n", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n", ",", "p"}], "]"}], " ", "&&", " ", 
    RowBox[{"0", "<", "m", "<=", "2"}], " ", "&&", " ", 
    RowBox[{"0", "<", "n", "<=", "2"}], " ", "&&", " ", 
    RowBox[{"p", ">", "5"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496452257776387*^9, 
   3.4964526617269526`*^9, 3.496452764157096*^9, {3.496452873107249*^9, 
   3.496452902017289*^9}, 3.4964530320774713`*^9, {3.4964531814176807`*^9, 
   3.496453187697689*^9}, 3.4964533573679266`*^9, {3.4964533874779687`*^9, 
   3.4964533908979735`*^9}, 3.5171910518857293`*^9},
 Background->GrayLevel[0.85]]
}, Closed]]
},
AutoGeneratedPackage->Automatic,
CellGrouping->Manual,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  "Integration Rules for Rational Functions of Linears", None, None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->28.8},
Magnification->1.399999976158142,
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 879, 17, 118, "Title"],
Cell[1449, 41, 235, 4, 354, "Subsubsection"],
Cell[1687, 47, 763, 11, 243, "Subsubsection"],
Cell[2453, 60, 620, 14, 550, "Subsubtitle"],
Cell[3076, 76, 771, 11, 354, "Subsubsection"],
Cell[3850, 89, 457, 11, 1079, "Code"],
Cell[4310, 102, 89, 2, 354, "Subsubsection"],
Cell[4402, 106, 184, 3, 243, "Subsubsection"],
Cell[4589, 111, 815, 11, 243, "Subsubsection"],
Cell[5407, 124, 1350, 29, 662, "Subsubtitle"],
Cell[6760, 155, 771, 11, 354, "Subsubsection"],
Cell[7534, 168, 801, 25, 1079, "Code"],
Cell[8338, 195, 89, 2, 354, "Subsubsection"],
Cell[8430, 199, 198, 3, 243, "Subsubsection"],
Cell[8631, 204, 351, 5, 243, "Subsubsection"],
Cell[8985, 211, 978, 18, 261, "Subsubsection"],
Cell[9966, 231, 1434, 31, 550, "Subsubtitle"],
Cell[11403, 264, 771, 11, 354, "Subsubsection"],
Cell[12177, 277, 1055, 32, 1079, "Code"],
Cell[13235, 311, 89, 2, 354, "Subsubsection"],
Cell[13327, 315, 198, 3, 243, "Subsubsection"],
Cell[13528, 320, 351, 5, 243, "Subsubsection"],
Cell[13882, 327, 815, 11, 926, "Subsubsection"],
Cell[14700, 340, 1220, 23, 1955, "Subsubtitle"],
Cell[15923, 365, 771, 11, 1300, "Subsubsection"],
Cell[16697, 378, 2720, 76, 12129, "Code"],
Cell[19420, 456, 89, 2, 1300, "Subsubsection"],
Cell[19512, 460, 351, 5, 926, "Subsubsection"],
Cell[19866, 467, 377, 7, 926, "Subsubsection"],
Cell[20246, 476, 815, 11, 926, "Subsubsection"],
Cell[21064, 489, 1220, 23, 1955, "Subsubtitle"],
Cell[22287, 514, 771, 11, 1300, "Subsubsection"],
Cell[23061, 527, 8843, 246, 22311, "Code"],
Cell[31907, 775, 89, 2, 1300, "Subsubsection"],
Cell[31999, 779, 351, 5, 926, "Subsubsection"],
Cell[32353, 786, 377, 7, 926, "Subsubsection"],
Cell[32733, 795, 815, 11, 926, "Subsubsection"],
Cell[33551, 808, 1220, 23, 1955, "Subsubtitle"],
Cell[34774, 833, 771, 11, 1300, "Subsubsection"],
Cell[35548, 846, 2819, 79, 13987, "Code"],
Cell[38370, 927, 89, 2, 1300, "Subsubsection"],
Cell[38462, 931, 309, 4, 926, "Subsubsection"],
Cell[38774, 937, 580, 17, 1482, "Subsubsection"],
Cell[39357, 956, 1044, 20, 968, "Subsubsection"],
Cell[40404, 978, 1399, 28, 1955, "Subsubtitle"],
Cell[41806, 1008, 771, 11, 1300, "Subsubsection"],
Cell[42580, 1021, 1050, 29, 3793, "Code"],
Cell[43633, 1052, 89, 2, 1300, "Subsubsection"],
Cell[43725, 1056, 309, 4, 926, "Subsubsection"],
Cell[44037, 1062, 830, 26, 1710, "Subsubsection"],
Cell[44870, 1090, 1284, 27, 968, "Subsubsection"],
Cell[46157, 1119, 2123, 51, 2182, "Subsubtitle"],
Cell[48283, 1172, 771, 11, 1300, "Subsubsection"],
Cell[49057, 1185, 1970, 59, 3793, "Code"],
Cell[51030, 1246, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[51111, 1252, 970, 21, 80, "Title"],
Cell[52084, 1275, 260, 4, 1300, "Subsubsection"],
Cell[52347, 1281, 262, 4, 926, "Subsubsection"],
Cell[52612, 1287, 765, 11, 926, "Subsubsection"],
Cell[53380, 1300, 869, 22, 2134, "Subsubtitle"],
Cell[54252, 1324, 771, 11, 1300, "Subsubsection"],
Cell[55026, 1337, 807, 24, 3793, "Code"],
Cell[55836, 1363, 89, 2, 1300, "Subsubsection"],
Cell[55928, 1367, 132, 1, 926, "Subsubsection"],
Cell[56063, 1370, 188, 3, 926, "Subsubsection"],
Cell[56254, 1375, 815, 11, 926, "Subsubsection"],
Cell[57072, 1388, 1256, 26, 2134, "Subsubtitle"],
Cell[58331, 1416, 771, 11, 1300, "Subsubsection"],
Cell[59105, 1429, 688, 21, 3793, "Code"],
Cell[59796, 1452, 89, 2, 1300, "Subsubsection"],
Cell[59888, 1456, 146, 2, 926, "Subsubsection"],
Cell[60037, 1460, 207, 3, 926, "Subsubsection"],
Cell[60247, 1465, 973, 18, 968, "Subsubsection"],
Cell[61223, 1485, 1254, 25, 2286, "Subsubtitle"],
Cell[62480, 1512, 771, 11, 1300, "Subsubsection"],
Cell[63254, 1525, 727, 21, 3793, "Code"],
Cell[63984, 1548, 89, 2, 1300, "Subsubsection"],
Cell[64076, 1552, 183, 2, 926, "Subsubsection"],
Cell[64262, 1556, 207, 3, 926, "Subsubsection"],
Cell[64472, 1561, 973, 18, 968, "Subsubsection"],
Cell[65448, 1581, 1530, 34, 2409, "Subsubtitle"],
Cell[66981, 1617, 771, 11, 1300, "Subsubsection"],
Cell[67755, 1630, 1033, 32, 3793, "Code"],
Cell[68791, 1664, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[68872, 1670, 1040, 23, 80, "Title"],
Cell[69915, 1695, 265, 4, 1300, "Subsubsection"],
Cell[70183, 1701, 765, 11, 926, "Subsubsection"],
Cell[70951, 1714, 1043, 26, 2286, "Subsubtitle"],
Cell[71997, 1742, 771, 11, 1300, "Subsubsection"],
Cell[72771, 1755, 1782, 40, 13054, "Code"],
Cell[74556, 1797, 89, 2, 1300, "Subsubsection"],
Cell[74648, 1801, 146, 2, 926, "Subsubsection"],
Cell[74797, 1805, 815, 11, 926, "Subsubsection"],
Cell[75615, 1818, 1126, 27, 1955, "Subsubtitle"],
Cell[76744, 1847, 771, 11, 1300, "Subsubsection"],
Cell[77518, 1860, 3222, 85, 13987, "Code"],
Cell[80743, 1947, 89, 2, 1300, "Subsubsection"],
Cell[80835, 1951, 199, 3, 926, "Subsubsection"],
Cell[81037, 1956, 532, 14, 968, "Subsubsection"],
Cell[81572, 1972, 974, 17, 968, "Subsubsection"],
Cell[82549, 1991, 1247, 28, 1955, "Subsubtitle"],
Cell[83799, 2021, 771, 11, 1300, "Subsubsection"],
Cell[84573, 2034, 1969, 52, 10285, "Code"],
Cell[86545, 2088, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[86626, 2094, 1003, 23, 89, "Title"],
Cell[87632, 2119, 232, 3, 130, "Subsubsection"],
Cell[87867, 2124, 817, 29, 167, "Subsubsection"],
Cell[88687, 2155, 906, 17, 96, "Subsubsection"],
Cell[89596, 2174, 945, 27, 261, "Subsubtitle"],
Cell[90544, 2203, 771, 11, 130, "Subsubsection"],
Cell[91318, 2216, 1217, 37, 394, "Code"],
Cell[92538, 2255, 89, 2, 130, "Subsubsection"],
Cell[92630, 2259, 97, 1, 90, "Subsubsection"],
Cell[92730, 2262, 195, 4, 90, "Subsubsection"],
Cell[92928, 2268, 705, 24, 174, "Subsubsection"],
Cell[93636, 2294, 1011, 20, 96, "Subsubsection"],
Cell[94650, 2316, 1425, 34, 277, "Subsubtitle"],
Cell[96078, 2352, 771, 11, 130, "Subsubsection"],
Cell[96852, 2365, 1196, 37, 394, "Code"],
Cell[98051, 2404, 89, 2, 130, "Subsubsection"],
Cell[98143, 2408, 191, 3, 90, "Subsubsection"],
Cell[98337, 2413, 629, 21, 184, "Subsubsection"],
Cell[98969, 2436, 965, 19, 96, "Subsubsection"],
Cell[99937, 2457, 1427, 33, 277, "Subsubtitle"],
Cell[101367, 2492, 771, 11, 130, "Subsubsection"],
Cell[102141, 2505, 1001, 32, 394, "Code"],
Cell[103145, 2539, 89, 2, 130, "Subsubsection"],
Cell[103237, 2543, 206, 3, 90, "Subsubsection"],
Cell[103446, 2548, 570, 17, 106, "Subsubsection"],
Cell[104019, 2567, 843, 12, 90, "Subsubsection"],
Cell[104865, 2581, 1526, 35, 253, "Subsubtitle"],
Cell[106394, 2618, 771, 11, 130, "Subsubsection"],
Cell[107168, 2631, 982, 31, 394, "Code"],
Cell[108153, 2664, 44, 1, 11, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[108234, 2670, 1005, 22, 80, "Title"],
Cell[109242, 2694, 315, 8, 365, "Subsubsection"],
Cell[109560, 2704, 1174, 23, 261, "Subsubsection"],
Cell[110737, 2729, 1630, 38, 683, "Subsubtitle"],
Cell[112370, 2769, 771, 11, 354, "Subsubsection"],
Cell[113144, 2782, 1305, 41, 1079, "Code"],
Cell[114452, 2825, 89, 2, 354, "Subsubsection"],
Cell[114544, 2829, 122, 1, 243, "Subsubsection"],
Cell[114669, 2832, 204, 3, 243, "Subsubsection"],
Cell[114876, 2837, 844, 25, 404, "Subsubsection"],
Cell[115723, 2864, 1232, 26, 261, "Subsubsection"],
Cell[116958, 2892, 2035, 53, 683, "Subsubtitle"],
Cell[118996, 2947, 771, 11, 354, "Subsubsection"],
Cell[119770, 2960, 2021, 65, 1345, "Code"],
Cell[121794, 3027, 89, 2, 354, "Subsubsection"],
Cell[121886, 3031, 149, 2, 243, "Subsubsection"],
Cell[122038, 3035, 183, 2, 243, "Subsubsection"],
Cell[122224, 3039, 1152, 23, 261, "Subsubsection"],
Cell[123379, 3064, 1897, 48, 662, "Subsubtitle"],
Cell[125279, 3114, 771, 11, 354, "Subsubsection"],
Cell[126053, 3127, 1698, 53, 1345, "Code"],
Cell[127754, 3182, 89, 2, 16020, "Subsubsection"],
Cell[127846, 3186, 171, 2, 11366, "Subsubsection"],
Cell[128020, 3190, 226, 3, 11366, "Subsubsection"],
Cell[128249, 3195, 875, 28, 19479, "Subsubsection"],
Cell[129127, 3225, 1334, 28, 11878, "Subsubsection"],
Cell[130464, 3255, 2104, 55, 29706, "Subsubtitle"],
Cell[132571, 3312, 771, 11, 16020, "Subsubsection"],
Cell[133345, 3325, 2087, 65, 58934, "Code"],
Cell[135435, 3392, 89, 2, 16020, "Subsubsection"],
Cell[135527, 3396, 195, 2, 11366, "Subsubsection"],
Cell[135725, 3400, 263, 4, 11366, "Subsubsection"],
Cell[135991, 3406, 1252, 24, 11878, "Subsubsection"],
Cell[137246, 3432, 2052, 52, 29706, "Subsubtitle"],
Cell[139301, 3486, 771, 11, 16020, "Subsubsection"],
Cell[140075, 3499, 1882, 59, 58934, "Code"],
Cell[141960, 3560, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[142041, 3566, 1083, 25, 80, "Title"],
Cell[143127, 3593, 255, 4, 130, "Subsubsection"],
Cell[143385, 3599, 720, 26, 96, "Subsubsection"],
Cell[144108, 3627, 1039, 22, 96, "Subsubsection"],
Cell[145150, 3651, 1106, 30, 201, "Subsubtitle"],
Cell[146259, 3683, 771, 11, 130, "Subsubsection"],
Cell[147033, 3696, 1212, 38, 394, "Code"],
Cell[148248, 3736, 89, 2, 130, "Subsubsection"],
Cell[148340, 3740, 184, 3, 90, "Subsubsection"],
Cell[148527, 3745, 1036, 37, 145, "Subsubsection"],
Cell[149566, 3784, 1086, 22, 96, "Subsubsection"],
Cell[150655, 3808, 1592, 38, 222, "Subsubtitle"],
Cell[152250, 3848, 771, 11, 130, "Subsubsection"],
Cell[153024, 3861, 1718, 53, 491, "Code"],
Cell[154745, 3916, 89, 2, 130, "Subsubsection"],
Cell[154837, 3920, 263, 4, 90, "Subsubsection"],
Cell[155103, 3926, 1293, 43, 145, "Subsubsection"],
Cell[156399, 3971, 520, 12, 96, "Subsubsection"],
Cell[156922, 3985, 1225, 26, 96, "Subsubsection"],
Cell[158150, 4013, 1892, 47, 233, "Subsubtitle"],
Cell[160045, 4062, 771, 11, 130, "Subsubsection"],
Cell[160819, 4075, 1763, 56, 394, "Code"],
Cell[162585, 4133, 89, 2, 130, "Subsubsection"],
Cell[162677, 4137, 415, 9, 96, "Subsubsection"],
Cell[163095, 4148, 1216, 25, 96, "Subsubsection"],
Cell[164314, 4175, 1898, 48, 250, "Subsubtitle"],
Cell[166215, 4225, 771, 11, 130, "Subsubsection"],
Cell[166989, 4238, 1730, 55, 394, "Code"],
Cell[168722, 4295, 89, 2, 130, "Subsubsection"],
Cell[168814, 4299, 199, 3, 90, "Subsubsection"],
Cell[169016, 4304, 202, 3, 90, "Subsubsection"],
Cell[169221, 4309, 1012, 33, 158, "Subsubsection"],
Cell[170236, 4344, 1424, 31, 96, "Subsubsection"],
Cell[171663, 4377, 2637, 73, 250, "Subsubtitle"],
Cell[174303, 4452, 771, 11, 130, "Subsubsection"],
Cell[175077, 4465, 2761, 88, 491, "Code"],
Cell[177841, 4555, 89, 2, 130, "Subsubsection"],
Cell[177933, 4559, 221, 3, 90, "Subsubsection"],
Cell[178157, 4564, 235, 3, 90, "Subsubsection"],
Cell[178395, 4569, 1358, 27, 96, "Subsubsection"],
Cell[179756, 4598, 2424, 65, 250, "Subsubtitle"],
Cell[182183, 4665, 771, 11, 130, "Subsubsection"],
Cell[182957, 4678, 2371, 75, 491, "Code"],
Cell[185331, 4755, 44, 1, 11, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[185412, 4761, 1118, 26, 80, "Title"],
Cell[186533, 4789, 255, 4, 35, "Subsubsection"],
Cell[186791, 4795, 681, 24, 26, "Subsubsection"],
Cell[187475, 4821, 1041, 22, 26, "Subsubsection"],
Cell[188519, 4845, 1180, 32, 53, "Subsubtitle"],
Cell[189702, 4879, 771, 11, 35, "Subsubsection"],
Cell[190476, 4892, 1322, 41, 104, "Code"],
Cell[191801, 4935, 89, 2, 35, "Subsubsection"],
Cell[191893, 4939, 279, 4, 25, "Subsubsection"],
Cell[192175, 4945, 994, 32, 31, "Subsubsection"],
Cell[193172, 4979, 1113, 24, 26, "Subsubsection"],
Cell[194288, 5005, 1557, 36, 66, "Subsubtitle"],
Cell[195848, 5043, 771, 11, 130, "Subsubsection"],
Cell[196622, 5056, 1357, 43, 394, "Code"],
Cell[197982, 5101, 89, 2, 130, "Subsubsection"],
Cell[198074, 5105, 279, 4, 90, "Subsubsection"],
Cell[198356, 5111, 1228, 39, 116, "Subsubsection"],
Cell[199587, 5152, 1350, 31, 26, "Subsubsection"],
Cell[200940, 5185, 1781, 43, 69, "Subsubtitle"],
Cell[202724, 5230, 771, 11, 35, "Subsubsection"],
Cell[203498, 5243, 1792, 57, 104, "Code"],
Cell[205293, 5302, 89, 2, 35, "Subsubsection"],
Cell[205385, 5306, 279, 4, 25, "Subsubsection"],
Cell[205667, 5312, 1276, 39, 31, "Subsubsection"],
Cell[206946, 5353, 1485, 33, 26, "Subsubsection"],
Cell[208434, 5388, 1957, 47, 69, "Subsubtitle"],
Cell[210394, 5437, 771, 11, 35, "Subsubsection"],
Cell[211168, 5450, 2103, 63, 129, "Code"],
Cell[213274, 5515, 89, 2, 35, "Subsubsection"],
Cell[213366, 5519, 1623, 36, 26, "Subsubsection"],
Cell[214992, 5557, 2010, 48, 66, "Subsubtitle"],
Cell[217005, 5607, 771, 11, 35, "Subsubsection"],
Cell[217779, 5620, 2114, 64, 104, "Code"],
Cell[219896, 5686, 89, 2, 35, "Subsubsection"],
Cell[219988, 5690, 1338, 25, 26, "Subsubsection"],
Cell[221329, 5717, 2678, 69, 66, "Subsubtitle"],
Cell[224010, 5788, 771, 11, 35, "Subsubsection"],
Cell[224784, 5801, 2604, 77, 129, "Code"],
Cell[227391, 5880, 89, 2, 35, "Subsubsection"],
Cell[227483, 5884, 1467, 26, 26, "Subsubsection"],
Cell[228953, 5912, 3812, 100, 124, "Subsubtitle"],
Cell[232768, 6014, 771, 11, 35, "Subsubsection"],
Cell[233542, 6027, 3806, 113, 154, "Code"]
}, Closed]]
}
]
*)

(* End of internal cache information *)
