(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    574465,      14363]
NotebookOptionsPosition[    549604,      13802]
NotebookOutlinePosition[    550724,      13841]
CellTagsIndexPosition[    550681,      13838]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"ArcTan", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.822.1, CRC 443, A&S 4.4.60", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4940010628073196`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"ArcTan", "[", 
     RowBox[{"a", " ", "x"}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "x"}]}], " ", 
    RowBox[{"ArcTan", "[", 
     RowBox[{"a", " ", "x"}], "]"}]}]}], "-", 
  FractionBox[
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", 
     RowBox[{
      SuperscriptBox["a", "2"], 
      SuperscriptBox["x", "2"]}]}], "]"}], 
   RowBox[{"2", "a"}]]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, {3.4940996615821767`*^9, 
   3.4940996620021772`*^9}, {3.4940997033322353`*^9, 3.494099726292267*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"ArcTan", "[", 
     RowBox[{"a_.", "*", "x_"}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=", 
  "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", "*", "x"}], "]"}]}], " ", "-", " ", 
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "*", 
        RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", "a"}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{"a", ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
  3.4940972668388243`*^9, 3.4940972723188314`*^9}, {3.494099663052179*^9, 
  3.494099663452179*^9}, {3.494099710492245*^9, 3.494099729802272*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "x"}]}], " ", 
    SuperscriptBox[
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"]}]}], "-", 
  RowBox[{"a", " ", "n", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"x", " ", 
       SuperscriptBox[
        RowBox[{"ArcTan", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "-", "1"}]]}], 
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["a", "2"], 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ArcTan", "[", 
      RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", "n"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"x", "*", 
         RowBox[{
          RowBox[{
           RowBox[{"ArcTan", "[", 
            RowBox[{"a", "*", "x"}], "]"}], "^", 
           RowBox[{"(", 
            RowBox[{"n", "-", "1"}], ")"}]}], "/", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             RowBox[{"a", "^", "2"}], "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
  3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
  3.494099719662258*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"ArcTan", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.492802747642827*^9, 
   3.492802751137233*^9}, 3.4928222777249804`*^9, 3.492825819138003*^9, {
   3.492830644352556*^9, 3.492830644712557*^9}, 3.494000871198538*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Iterated integration by parts", "Subsubsection",
 CellChangeTimes->{{3.493099207935931*^9, 3.4930992149659414`*^9}, {
  3.4940052861338797`*^9, 3.4940052928402634`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.493098879405472*^9, 3.493098884745479*^9}, {3.493099207935931*^9, 
   3.4930992149659414`*^9}, 3.4930996737265835`*^9, 3.493099827186798*^9, {
   3.4932434943005557`*^9, 3.493243522320595*^9}, {3.494005203823172*^9, 
   3.494005223116276*^9}, {3.4940055732323008`*^9, 3.4940055743073626`*^9}, 
   3.4940057909347525`*^9, 3.494006120923627*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"ArcTan", "[", 
         RowBox[{"a", " ", "x"}], "]"}], "n"], 
       RowBox[{"2", 
        SuperscriptBox["a", "2"]}]]}]}]}]}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["x", "2"], 
    SuperscriptBox[
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"]}], "2"], "-", 
  RowBox[{
   FractionBox["n", 
    RowBox[{"2", "a"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493098332554706*^9, 3.4930984922049294`*^9}, {
   3.4930985835950575`*^9, 3.4930986777351894`*^9}, {3.4930988533254347`*^9, 
   3.4930988578754416`*^9}, {3.493099207935931*^9, 3.4930992149659414`*^9}, {
   3.4930993574561405`*^9, 3.493099400886202*^9}, {3.493099526816378*^9, 
   3.49309953534639*^9}, 3.4931705981281786`*^9, {3.493170768098417*^9, 
   3.4931708122284784`*^9}, {3.4940050446890697`*^9, 
   3.4940051357132764`*^9}, {3.494005409976963*^9, 3.494005469155348*^9}, {
   3.4940101517571774`*^9, 3.494010179840784*^9}, {3.494010370766704*^9, 
   3.4940103752849627`*^9}, {3.4940162937814813`*^9, 
   3.4940162949895506`*^9}, {3.4940163653905773`*^9, 3.4940163811714797`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.4940053078671227`*^9, 3.494005310026246*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "*", 
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", 
       RowBox[{"a", "^", "2"}]}], ")"}]}], " ", "+", " ", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", "2"}]}], " ", "-", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "a"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"ArcTan", "[", 
          RowBox[{"a", "*", "x"}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4928302625720215`*^9, 3.4928303000920744`*^9}, {
   3.4928305645624447`*^9, 3.4928305746224585`*^9}, {3.4930994731463027`*^9, 
   3.4930995793864517`*^9}, {3.4931708257484975`*^9, 3.493170933088648*^9}, {
   3.493170964658692*^9, 3.4931709750387063`*^9}, {3.493171201919024*^9, 
   3.493171205079028*^9}, {3.493171366199254*^9, 3.4931713665792546`*^9}, {
   3.4931715056494493`*^9, 3.49317150626945*^9}, {3.4932434733805265`*^9, 
   3.4932434776305323`*^9}, 3.4932442598016276`*^9, 3.4932444119118404`*^9, {
   3.494004039303565*^9, 3.4940040800098934`*^9}, {3.4940049144956236`*^9, 
   3.4940049151486607`*^9}, {3.4940049727389545`*^9, 
   3.4940049792463264`*^9}, {3.4940054842162094`*^9, 3.494005590086265*^9}, 
   3.494005794311946*^9, {3.494006124318821*^9, 3.494006126234931*^9}, 
   3.4940095020830183`*^9, {3.494010209237465*^9, 3.494010224615345*^9}, {
   3.4940103892347603`*^9, 3.4940104095319214`*^9}, {3.494016295469578*^9, 
   3.4940162965656404`*^9}, 3.4940163483986053`*^9, {3.4940163845786743`*^9, 
   3.4940163849816976`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Iterated integration by parts", "Subsubsection",
 CellChangeTimes->{{3.493099207935931*^9, 3.4930992149659414`*^9}, {
  3.4940052861338797`*^9, 3.4940052928402634`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"m", ">", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.493098879405472*^9, 3.493098884745479*^9}, {3.493099207935931*^9, 
   3.4930992149659414`*^9}, 3.4930996737265835`*^9, 3.493099827186798*^9, {
   3.4932434943005557`*^9, 3.493243522320595*^9}, {3.494005203823172*^9, 
   3.494005223116276*^9}, {3.494005912167687*^9, 3.494005912167687*^9}, {
   3.494005996704522*^9, 3.494006005111003*^9}, {3.4940120035220923`*^9, 
   3.4940120062372475`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "-", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"ArcTan", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["x", 
     RowBox[{"m", "+", "1"}]], 
    SuperscriptBox[
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
   RowBox[{"m", "+", "1"}]], "-", 
  "                                                ", "\[IndentingNewLine]", 
  "                                                ", 
  RowBox[{
   FractionBox["n", 
    RowBox[{"a", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"m", "-", "1"}], 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493098332554706*^9, 3.4930984922049294`*^9}, {
   3.4930985835950575`*^9, 3.4930986777351894`*^9}, {3.4930988533254347`*^9, 
   3.4930988578754416`*^9}, {3.493099207935931*^9, 3.4930992149659414`*^9}, {
   3.4930993574561405`*^9, 3.493099400886202*^9}, {3.493099526816378*^9, 
   3.49309953534639*^9}, 3.4931705981281786`*^9, {3.493170768098417*^9, 
   3.4931708122284784`*^9}, {3.4940050446890697`*^9, 
   3.4940051357132764`*^9}, {3.494010254898077*^9, 3.4940102990006*^9}, {
   3.494010355515832*^9, 3.4940103650133753`*^9}, {3.4940156306725535`*^9, 
   3.494015641501173*^9}, {3.494015829505926*^9, 3.494015853240284*^9}, {
   3.4940162969736643`*^9, 3.494016298606757*^9}, {3.4940165403365836`*^9, 
   3.494016550208148*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.4940053078671227`*^9, 3.494005310026246*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", 
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4928302625720215`*^9, 3.4928303000920744`*^9}, {
   3.4928305645624447`*^9, 3.4928305746224585`*^9}, {3.4930994731463027`*^9, 
   3.4930995793864517`*^9}, {3.4931708257484975`*^9, 3.493170933088648*^9}, {
   3.493170964658692*^9, 3.4931709750387063`*^9}, {3.493171201919024*^9, 
   3.493171205079028*^9}, {3.493171366199254*^9, 3.4931713665792546`*^9}, {
   3.4931715056494493`*^9, 3.49317150626945*^9}, {3.4932434733805265`*^9, 
   3.4932434776305323`*^9}, 3.4932442598016276`*^9, 3.4932444119118404`*^9, {
   3.494004039303565*^9, 3.4940040800098934`*^9}, {3.4940049144956236`*^9, 
   3.4940049151486607`*^9}, {3.4940049727389545`*^9, 3.4940049792463264`*^9}, 
   3.4940059089755044`*^9, {3.494006032487569*^9, 3.4940060554328814`*^9}, 
   3.4940094923844633`*^9, {3.4940103280942636`*^9, 3.4940103492304726`*^9}, {
   3.4940104554925504`*^9, 3.4940104824550924`*^9}, {3.4940119781816435`*^9, 
   3.494011987537178*^9}, {3.4940162991437883`*^9, 3.494016304527096*^9}, 
   3.4940164856854577`*^9, {3.4940165324881344`*^9, 3.4940165351962895`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{{3.493099207935931*^9, 3.4930992149659414`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.493098879405472*^9, 3.493098884745479*^9}, {3.493099207935931*^9, 
   3.4930992149659414`*^9}, 3.4930996737265835`*^9, 3.493099827186798*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], "x"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "2"}]}], " ", 
    SuperscriptBox[
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{"1", "-", 
      FractionBox[
       RowBox[{"2", "I"}], 
       RowBox[{"I", "-", 
        RowBox[{"a", " ", "x"}]}]]}], "]"}]}]}], "-", 
  RowBox[{"2", "a", " ", "n", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"ArcTan", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "-", "1"}]], " ", 
       RowBox[{"ArcTanh", "[", 
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{"2", "I"}], 
          RowBox[{"I", "-", 
           RowBox[{"a", " ", "x"}]}]]}], "]"}]}], 
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 PageWidth->Infinity,
 CellChangeTimes->{{3.493098332554706*^9, 3.4930984922049294`*^9}, {
   3.4930985835950575`*^9, 3.4930986777351894`*^9}, {3.4930988533254347`*^9, 
   3.4930988578754416`*^9}, {3.493099207935931*^9, 3.4930992149659414`*^9}, {
   3.4930993574561405`*^9, 3.493099400886202*^9}, {3.493099526816378*^9, 
   3.49309953534639*^9}, 3.4931705981281786`*^9, {3.494000871274542*^9, 
   3.4940008712805424`*^9}, {3.4940172663621097`*^9, 3.494017296684844*^9}, {
   3.494017348959834*^9, 3.494017350127901*^9}, {3.49401774681359*^9, 
   3.4940177739541426`*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}], "/", "x_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "*", 
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "*", 
     RowBox[{"ArcTanh", "[", 
      RowBox[{"1", "-", 
       RowBox[{"2", "*", 
        RowBox[{"I", "/", 
         RowBox[{"(", 
          RowBox[{"I", "-", 
           RowBox[{"a", "*", "x"}]}], ")"}]}]}]}], "]"}]}], " ", "-", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"2", "*", "a", "*", "n"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcTanh", "[", 
           RowBox[{"1", "-", 
            RowBox[{"2", "*", 
             RowBox[{"I", "/", 
              RowBox[{"(", 
               RowBox[{"I", "-", 
                RowBox[{"a", "*", "x"}]}], ")"}]}]}]}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             RowBox[{"a", "^", "2"}], "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4928302625720215`*^9, 3.4928303000920744`*^9}, {
  3.4928305645624447`*^9, 3.4928305746224585`*^9}, {3.4930994731463027`*^9, 
  3.4930995793864517`*^9}, {3.494000871289543*^9, 3.494000871296543*^9}, {
  3.4940178019527435`*^9, 3.4940178274122*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{{3.493099207935931*^9, 3.4930992149659414`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.493098879405472*^9, 3.493098884745479*^9}, {3.493099207935931*^9, 
   3.4930992149659414`*^9}, 3.4930996737265835`*^9, 3.493099827186798*^9, {
   3.4932434943005557`*^9, 3.493243522320595*^9}, {3.4940131571360755`*^9, 
   3.494013161549328*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     SuperscriptBox["x", "2"]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"ArcTan", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"], "x"]}]}]}]}]}], "+", 
  RowBox[{"a", " ", "n", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", " ", "x"}], "]"}], 
       RowBox[{"n", "-", "1"}]], 
      RowBox[{"x", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["x", "2"]}]}], ")"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493098332554706*^9, 3.4930984922049294`*^9}, {
   3.4930985835950575`*^9, 3.4930986777351894`*^9}, {3.4930988533254347`*^9, 
   3.4930988578754416`*^9}, {3.493099207935931*^9, 3.4930992149659414`*^9}, {
   3.4930993574561405`*^9, 3.493099400886202*^9}, {3.493099526816378*^9, 
   3.49309953534639*^9}, 3.4931705981281786`*^9, {3.493170768098417*^9, 
   3.4931708122284784`*^9}, {3.494013179298343*^9, 3.4940132717176294`*^9}, {
   3.4940167360667787`*^9, 3.494016736987831*^9}, {3.494016997482731*^9, 
   3.4940169979477572`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
     RowBox[{"x_", "^", "2"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
  "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], "/", "x"}], " ", "+", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", "n"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "/", 
         RowBox[{"(", 
          RowBox[{"x", "*", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              RowBox[{"a", "^", "2"}], "*", 
              RowBox[{"x", "^", "2"}]}]}], ")"}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4928302625720215`*^9, 3.4928303000920744`*^9}, {
   3.4928305645624447`*^9, 3.4928305746224585`*^9}, {3.4930994731463027`*^9, 
   3.4930995793864517`*^9}, {3.4931708257484975`*^9, 3.493170933088648*^9}, {
   3.493170964658692*^9, 3.4931709750387063`*^9}, {3.493171201919024*^9, 
   3.493171205079028*^9}, {3.493171366199254*^9, 3.4931713665792546`*^9}, {
   3.4931715056494493`*^9, 3.49317150626945*^9}, {3.4932434733805265`*^9, 
   3.4932434776305323`*^9}, 3.4932442598016276`*^9, 3.4932444119118404`*^9, {
   3.4940040426067543`*^9, 3.494004046872998*^9}, {3.494009552628909*^9, 
   3.494009555663083*^9}, {3.4940116323648634`*^9, 3.4940116363310905`*^9}, {
   3.494013128108415*^9, 3.494013131212593*^9}, {3.4940133353222675`*^9, 
   3.494013406482337*^9}, {3.4940167378098783`*^9, 3.49401673854792*^9}, {
   3.4940170167108307`*^9, 3.4940170178968983`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["\<\
Derivation: Inverted iterated integration by parts special case\
\>", "Subsubsection",
 CellChangeTimes->{{3.493099207935931*^9, 3.4930992149659414`*^9}, {
  3.4940052861338797`*^9, 3.4940052928402634`*^9}, {3.494011690737202*^9, 
  3.494011693788377*^9}, {3.4940168132141914`*^9, 3.494016815887344*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.493098879405472*^9, 3.493098884745479*^9}, {3.493099207935931*^9, 
   3.4930992149659414`*^9}, 3.4930996737265835`*^9, 3.493099827186798*^9, {
   3.4932434943005557`*^9, 3.493243522320595*^9}, {3.494005203823172*^9, 
   3.494005223116276*^9}, {3.494005912167687*^9, 3.494005912167687*^9}, {
   3.494005996704522*^9, 3.494006005111003*^9}, {3.4940117189798174`*^9, 
   3.494011721274949*^9}, {3.494011926169668*^9, 3.4940119289428267`*^9}, {
   3.4940120348468843`*^9, 3.494012036980006*^9}, {3.494012573744707*^9, 
   3.4940125763308554`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     SuperscriptBox["x", "3"]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox["a", "2"], 
         SuperscriptBox[
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", " ", "x"}], "]"}], "n"]}], "2"]}]}]}]}]}], "-", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"ArcTan", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"2", 
    SuperscriptBox["x", "2"]}]], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", "n"}], "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", " ", "x"}], "]"}], 
       RowBox[{"n", "-", "1"}]], 
      SuperscriptBox["x", "2"]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493098332554706*^9, 3.4930984922049294`*^9}, {
   3.4930985835950575`*^9, 3.4930986777351894`*^9}, {3.4930988533254347`*^9, 
   3.4930988578754416`*^9}, {3.493099207935931*^9, 3.4930992149659414`*^9}, {
   3.4930993574561405`*^9, 3.493099400886202*^9}, {3.493099526816378*^9, 
   3.49309953534639*^9}, 3.4931705981281786`*^9, {3.493170768098417*^9, 
   3.4931708122284784`*^9}, {3.4940050446890697`*^9, 
   3.4940051357132764`*^9}, {3.494010254898077*^9, 3.4940102990006*^9}, {
   3.494010355515832*^9, 3.4940103650133753`*^9}, 3.4940116760473623`*^9, {
   3.4940120899150343`*^9, 3.494012256009534*^9}, 3.494012321413275*^9, 
   3.494012355001196*^9, 3.4940166927783027`*^9, {3.494016739009947*^9, 
   3.4940167402410173`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.4940053078671227`*^9, 3.494005310026246*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
     RowBox[{"x_", "^", "3"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
  "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"a", "^", "2"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", "2"}]}], " ", "-", 
    " ", 
    RowBox[{
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", 
       RowBox[{"x", "^", "2"}]}], ")"}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"n", "/", "2"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "/", 
         RowBox[{"x", "^", "2"}]}], ",", "x"}], "]"}]}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4928302625720215`*^9, 3.4928303000920744`*^9}, {
   3.4928305645624447`*^9, 3.4928305746224585`*^9}, {3.4930994731463027`*^9, 
   3.4930995793864517`*^9}, {3.4931708257484975`*^9, 3.493170933088648*^9}, {
   3.493170964658692*^9, 3.4931709750387063`*^9}, {3.493171201919024*^9, 
   3.493171205079028*^9}, {3.493171366199254*^9, 3.4931713665792546`*^9}, {
   3.4931715056494493`*^9, 3.49317150626945*^9}, {3.4932434733805265`*^9, 
   3.4932434776305323`*^9}, 3.4932442598016276`*^9, 3.4932444119118404`*^9, {
   3.494004039303565*^9, 3.4940040800098934`*^9}, {3.4940049144956236`*^9, 
   3.4940049151486607`*^9}, {3.4940049727389545`*^9, 3.4940049792463264`*^9}, 
   3.4940059089755044`*^9, {3.494006032487569*^9, 3.4940060554328814`*^9}, 
   3.4940094923844633`*^9, {3.4940103280942636`*^9, 3.4940103492304726`*^9}, {
   3.4940104554925504`*^9, 3.4940104824550924`*^9}, {3.4940117336926594`*^9, 
   3.494011876094804*^9}, {3.4940120191709876`*^9, 3.4940120264064016`*^9}, {
   3.494012388532114*^9, 3.4940124429682274`*^9}, {3.4940125561557016`*^9, 
   3.4940125689854355`*^9}, {3.4940167439892316`*^9, 3.4940167473774257`*^9}, 
   3.4940167855246077`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Inverted iterated integration by parts", "Subsubsection",
 CellChangeTimes->{{3.493099207935931*^9, 3.4930992149659414`*^9}, {
  3.4940052861338797`*^9, 3.4940052928402634`*^9}, {3.494011690737202*^9, 
  3.494011693788377*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"m", "<", 
    RowBox[{"-", "3"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.493098879405472*^9, 3.493098884745479*^9}, {3.493099207935931*^9, 
   3.4930992149659414`*^9}, 3.4930996737265835`*^9, 3.493099827186798*^9, {
   3.4932434943005557`*^9, 3.493243522320595*^9}, {3.494005203823172*^9, 
   3.494005223116276*^9}, {3.494005912167687*^9, 3.494005912167687*^9}, {
   3.494005996704522*^9, 3.494006005111003*^9}, {3.4940117189798174`*^9, 
   3.494011721274949*^9}, {3.494011926169668*^9, 3.4940119289428267`*^9}, {
   3.4940120348468843`*^9, 3.494012036980006*^9}, {3.494013442081373*^9, 
   3.494013450779871*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"ArcTan", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
       RowBox[{"m", "+", "1"}]]}]}]}]}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    SuperscriptBox["x", 
     RowBox[{"m", "+", "3"}]], " ", 
    SuperscriptBox[
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
   RowBox[{"m", "+", "1"}]], "-", 
  "                                                ", "\[IndentingNewLine]", 
  "                                                ", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", "n"}], 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["a", "2"], 
     RowBox[{"(", 
      RowBox[{"m", "+", "3"}], ")"}]}], 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493098332554706*^9, 3.4930984922049294`*^9}, {
   3.4930985835950575`*^9, 3.4930986777351894`*^9}, {3.4930988533254347`*^9, 
   3.4930988578754416`*^9}, {3.493099207935931*^9, 3.4930992149659414`*^9}, {
   3.4930993574561405`*^9, 3.493099400886202*^9}, {3.493099526816378*^9, 
   3.49309953534639*^9}, 3.4931705981281786`*^9, {3.493170768098417*^9, 
   3.4931708122284784`*^9}, {3.4940050446890697`*^9, 
   3.4940051357132764`*^9}, {3.494010254898077*^9, 3.4940102990006*^9}, {
   3.494010355515832*^9, 3.4940103650133753`*^9}, 3.4940116760473623`*^9, {
   3.4940156538678803`*^9, 3.494015661870338*^9}, {3.494015862381807*^9, 
   3.4940158673580914`*^9}, {3.4940167491765285`*^9, 3.494016750724617*^9}, {
   3.4940168803370304`*^9, 3.4940168889155207`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.4940053078671227`*^9, 3.494005310026246*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "+", " ", 
    RowBox[{
     RowBox[{"a", "^", "2"}], "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "3"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"n", "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "3"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "3"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.4928302625720215`*^9, 3.4928303000920744`*^9}, {
   3.4928305645624447`*^9, 3.4928305746224585`*^9}, {3.4930994731463027`*^9, 
   3.4930995793864517`*^9}, {3.4931708257484975`*^9, 3.493170933088648*^9}, {
   3.493170964658692*^9, 3.4931709750387063`*^9}, {3.493171201919024*^9, 
   3.493171205079028*^9}, {3.493171366199254*^9, 3.4931713665792546`*^9}, {
   3.4931715056494493`*^9, 3.49317150626945*^9}, {3.4932434733805265`*^9, 
   3.4932434776305323`*^9}, 3.4932442598016276`*^9, 3.4932444119118404`*^9, {
   3.494004039303565*^9, 3.4940040800098934`*^9}, {3.4940049144956236`*^9, 
   3.4940049151486607`*^9}, {3.4940049727389545`*^9, 3.4940049792463264`*^9}, 
   3.4940059089755044`*^9, {3.494006032487569*^9, 3.4940060554328814`*^9}, 
   3.4940094923844633`*^9, {3.4940103280942636`*^9, 3.4940103492304726`*^9}, {
   3.4940104554925504`*^9, 3.4940104824550924`*^9}, {3.4940117336926594`*^9, 
   3.494011876094804*^9}, {3.4940120191709876`*^9, 3.4940120264064016`*^9}, {
   3.4940134559001637`*^9, 3.4940134576452637`*^9}, {3.494016751700673*^9, 
   3.4940167559439154`*^9}, {3.49401691075677*^9, 3.4940169159970703`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", "x"}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.492802747642827*^9, 
   3.492802751137233*^9}, 3.4928222777249804`*^9, 3.492825819138003*^9, {
   3.492830644352556*^9, 3.492830644712557*^9}, {3.4928404670121565`*^9, 
   3.492840467502157*^9}, 3.492913326383937*^9, {3.4931451285332985`*^9, 
   3.4931451299433002`*^9}, 3.4940008713405457`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{3.4931456018039613`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    SuperscriptBox["d", "2"]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.492907662576008*^9, 3.4929076635660095`*^9}, {3.4930735907627287`*^9, 
   3.4930736091827545`*^9}, {3.4931451699433565`*^9, 3.493145207453409*^9}, {
   3.4931452956835327`*^9, 3.4931453218235693`*^9}, {3.4931453713536386`*^9, 
   3.4931453747436433`*^9}, 3.4931456018039613`*^9, {3.493146996085913*^9, 
   3.4931470125759363`*^9}, {3.493581126911767*^9, 3.493581143581791*^9}, {
   3.4940337767420216`*^9, 3.494033781042267*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
         RowBox[{"Log", "[", 
          FractionBox[
           RowBox[{"2", " ", "c"}], 
           RowBox[{"c", " ", "+", 
            RowBox[{"d", " ", "x"}]}]], "]"}]}], "d"]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", "n"}], "d"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"ArcTan", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "-", "1"}]], " ", 
       RowBox[{"Log", "[", 
        FractionBox[
         RowBox[{"2", " ", "c"}], 
         RowBox[{"c", " ", "+", 
          RowBox[{"d", " ", "x"}]}]], "]"}]}], 
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["a", "2"], 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4927459475946445`*^9, 3.49274596552767*^9}, {
   3.4927470791633663`*^9, 3.492747100502587*^9}, {3.492838456185856*^9, 
   3.492838468151077*^9}, {3.4928389429535108`*^9, 3.492838996648805*^9}, {
   3.492839156730687*^9, 3.4928391643123*^9}, 3.4928403497119923`*^9, {
   3.492908275826866*^9, 3.4929083226469316`*^9}, 3.492910391739828*^9, {
   3.4931446954326925`*^9, 3.493144762932787*^9}, 3.4931448959029727`*^9, {
   3.493144975223084*^9, 3.4931449799230905`*^9}, {3.4931453401435947`*^9, 
   3.4931453627536263`*^9}, 3.4931456018039613`*^9, {3.4931469777458878`*^9, 
   3.4931469799558907`*^9}, {3.4940008713645473`*^9, 
   3.4940008713685474`*^9}, {3.4940233075696473`*^9, 3.494023307900666*^9}, {
   3.4940340310215654`*^9, 3.4940340485815697`*^9}, {3.494034864796254*^9, 
   3.4940348686954775`*^9}, {3.4940376218759503`*^9, 3.4940376263072042`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
     RowBox[{"(", 
      RowBox[{"c_", "+", 
       RowBox[{"d_.", "*", "x_"}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"2", "*", 
        RowBox[{"c", "/", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], ")"}]}]}], "]"}], "/", "d"}]}], " ", 
    "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"n", "/", "d"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"2", "*", 
            RowBox[{"c", "/", 
             RowBox[{"(", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], ")"}]}]}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             RowBox[{"a", "^", "2"}], "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", 
       RowBox[{"c", "^", "2"}]}], "+", 
      RowBox[{"d", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.4928379334601374`*^9, 
   3.492837939216548*^9}, {3.4928380301959076`*^9, 3.4928380706935787`*^9}, {
   3.4928381256836753`*^9, 3.492838126026876*^9}, {3.492838194448596*^9, 
   3.492838214806632*^9}, {3.4928386496573954`*^9, 3.4928386538382025`*^9}, {
   3.4928387393419533`*^9, 3.4928388738453894`*^9}, {3.4928392099891806`*^9, 
   3.4928392282724123`*^9}, {3.4928392656204743`*^9, 3.492839265890475*^9}, {
   3.4928393374405746`*^9, 3.492839337970576*^9}, 3.4928413413933806`*^9, {
   3.4930740306333447`*^9, 3.4930740321133466`*^9}, {3.493144462352366*^9, 
   3.493144468172374*^9}, {3.493144540822476*^9, 3.4931445433324795`*^9}, {
   3.4931445892825437`*^9, 3.4931445898425446`*^9}, {3.493145449723748*^9, 
   3.493145475833785*^9}, {3.49358106455168*^9, 3.493581066611683*^9}, {
   3.493748575803213*^9, 3.4937486011688576`*^9}, {3.4940008713785477`*^9, 
   3.4940008713835483`*^9}, {3.49402332003436*^9, 3.4940233203603783`*^9}, {
   3.4940349261607647`*^9, 3.494034948444039*^9}, {3.494037644559248*^9, 
   3.494037647619423*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", "x"}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.492802747642827*^9, 
   3.492802751137233*^9}, 3.4928222777249804`*^9, 3.492825819138003*^9, {
   3.492830644352556*^9, 3.492830644712557*^9}, {3.4928404670121565`*^9, 
   3.492840467502157*^9}, 3.492913326383937*^9, {3.4929975742692375`*^9, 
   3.492997579510846*^9}, {3.4931465961853533`*^9, 3.493146597295355*^9}, 
   3.4940008713975487`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{3.4931456018039613`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    SuperscriptBox["d", "2"]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.492907662576008*^9, 3.4929076635660095`*^9}, {3.4930735907627287`*^9, 
   3.4930736091827545`*^9}, {3.4931451699433565`*^9, 3.493145207453409*^9}, {
   3.4931452956835327`*^9, 3.4931453218235693`*^9}, {3.4931453713536386`*^9, 
   3.4931453747436433`*^9}, 3.4931456018039613`*^9, {3.493146996085913*^9, 
   3.4931470125759363`*^9}, {3.4935811541318054`*^9, 
   3.4935811541318054`*^9}, {3.493581238921924*^9, 3.493581239361925*^9}, {
   3.4940350410063334`*^9, 3.4940350410063334`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"x", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"ArcTan", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
        RowBox[{"Log", "[", 
         RowBox[{"2", "-", 
          FractionBox[
           RowBox[{"2", " ", "c"}], 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}]]}], "]"}]}], "c"]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", "n"}], "c"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"ArcTan", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "-", "1"}]], " ", 
       RowBox[{"Log", "[", 
        RowBox[{"2", "-", 
         FractionBox[
          RowBox[{"2", " ", "c"}], 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}]]}], "]"}]}], 
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["a", "2"], 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4927459475946445`*^9, 3.49274596552767*^9}, {
   3.4927470791633663`*^9, 3.492747100502587*^9}, {3.492838456185856*^9, 
   3.492838468151077*^9}, {3.4928389429535108`*^9, 3.492838996648805*^9}, {
   3.492839156730687*^9, 3.4928391643123*^9}, 3.4928403497119923`*^9, {
   3.492908275826866*^9, 3.4929083226469316`*^9}, 3.492910391739828*^9, {
   3.4931446954326925`*^9, 3.493144762932787*^9}, 3.4931448959029727`*^9, {
   3.493144975223084*^9, 3.4931449799230905`*^9}, {3.4931453401435947`*^9, 
   3.4931453627536263`*^9}, 3.4931456018039613`*^9, {3.4931466620154457`*^9, 
   3.493146720405527*^9}, {3.493146762375586*^9, 3.4931467629255867`*^9}, {
   3.4931574816798153`*^9, 3.4931574860698223`*^9}, {3.4940008714095497`*^9, 
   3.49400087141255*^9}, {3.4940233469749007`*^9, 3.4940233473049197`*^9}, {
   3.4940351028428698`*^9, 3.49403510668709*^9}, {3.4940351860366287`*^9, 
   3.494035189296815*^9}, {3.4940382334609313`*^9, 3.4940382496008544`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
     RowBox[{"(", 
      RowBox[{"x_", "*", 
       RowBox[{"(", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", "x_"}]}], ")"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"2", "-", 
        RowBox[{"2", "*", 
         RowBox[{"c", "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}]}]}]}], "]"}], "/", "c"}]}], " ", 
    "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"n", "/", "c"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"2", "-", 
            RowBox[{"2", "*", 
             RowBox[{"c", "/", 
              RowBox[{"(", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], ")"}]}]}]}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             RowBox[{"a", "^", "2"}], "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", 
       RowBox[{"c", "^", "2"}]}], "+", 
      RowBox[{"d", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.4928379334601374`*^9, 
   3.492837939216548*^9}, {3.4928380301959076`*^9, 3.4928380706935787`*^9}, {
   3.4928381256836753`*^9, 3.492838126026876*^9}, {3.492838194448596*^9, 
   3.492838214806632*^9}, {3.4928386496573954`*^9, 3.4928386538382025`*^9}, {
   3.4928387393419533`*^9, 3.4928388738453894`*^9}, {3.4928392099891806`*^9, 
   3.4928392282724123`*^9}, {3.4928392656204743`*^9, 3.492839265890475*^9}, {
   3.4928393374405746`*^9, 3.492839337970576*^9}, 3.4928413413933806`*^9, {
   3.4930740306333447`*^9, 3.4930740321133466`*^9}, {3.493144462352366*^9, 
   3.493144468172374*^9}, {3.493144540822476*^9, 3.4931445433324795`*^9}, {
   3.4931445892825437`*^9, 3.4931445898425446`*^9}, {3.493145449723748*^9, 
   3.493145475833785*^9}, {3.493146638085412*^9, 3.4931466465254235`*^9}, {
   3.4931467543555746`*^9, 3.4931467820656137`*^9}, {3.493146817405663*^9, 
   3.493146854555715*^9}, {3.493147492576608*^9, 3.493147492956609*^9}, {
   3.4931575219698725`*^9, 3.4931575367198925`*^9}, 3.4931584323211465`*^9, {
   3.4935810314016333`*^9, 3.493581033811637*^9}, {3.49400087142255*^9, 
   3.494000871427551*^9}, {3.494023351261146*^9, 3.494023351590165*^9}, 
   3.4940350772864084`*^9, {3.494035234439397*^9, 3.494035246645095*^9}, {
   3.494038279684575*^9, 3.4940382928623285`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{3.4931456018039613`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    SuperscriptBox["d", "2"]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.492907662576008*^9, 3.4929076635660095`*^9}, {3.4930735907627287`*^9, 
   3.4930736091827545`*^9}, {3.4931451699433565`*^9, 3.493145207453409*^9}, {
   3.4931452956835327`*^9, 3.4931453218235693`*^9}, {3.4931453713536386`*^9, 
   3.4931453747436433`*^9}, 3.4931456018039613`*^9, {3.493146996085913*^9, 
   3.4931470125759363`*^9}, {3.493581162211817*^9, 3.493581162211817*^9}, {
   3.493581231631914*^9, 3.4935812320219145`*^9}, {3.494035044948559*^9, 
   3.494035044948559*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{
      RowBox[{"c", " ", "x"}], "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"ArcTan", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
        RowBox[{"Log", "[", 
         RowBox[{"2", "-", 
          FractionBox[
           RowBox[{"2", " ", "c"}], 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}]]}], "]"}]}], "c"]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", "n"}], "c"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"ArcTan", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "-", "1"}]], " ", 
       RowBox[{"Log", "[", 
        RowBox[{"2", "-", 
         FractionBox[
          RowBox[{"2", " ", "c"}], 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}]]}], "]"}]}], 
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["a", "2"], 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4927459475946445`*^9, 3.49274596552767*^9}, {
   3.4927470791633663`*^9, 3.492747100502587*^9}, {3.492838456185856*^9, 
   3.492838468151077*^9}, {3.4928389429535108`*^9, 3.492838996648805*^9}, {
   3.492839156730687*^9, 3.4928391643123*^9}, 3.4928403497119923`*^9, {
   3.492908275826866*^9, 3.4929083226469316`*^9}, 3.492910391739828*^9, {
   3.4931446954326925`*^9, 3.493144762932787*^9}, 3.4931448959029727`*^9, {
   3.493144975223084*^9, 3.4931449799230905`*^9}, {3.4931453401435947`*^9, 
   3.4931453627536263`*^9}, 3.4931456018039613`*^9, {3.4931466620154457`*^9, 
   3.493146720405527*^9}, {3.493146762375586*^9, 3.4931467629255867`*^9}, {
   3.4931574816798153`*^9, 3.4931574860698223`*^9}, {3.493158351951034*^9, 
   3.4931583622410483`*^9}, {3.4940008714415517`*^9, 
   3.4940008714445515`*^9}, {3.4940233564294415`*^9, 3.494023356785462*^9}, {
   3.494035300428171*^9, 3.494035302343281*^9}, 3.4940383033989315`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"c_.", "*", "x_"}], "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"2", "-", 
        RowBox[{"2", "*", 
         RowBox[{"c", "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}]}]}]}], "]"}], "/", "c"}]}], " ", 
    "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"n", "/", "c"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"2", "-", 
            RowBox[{"2", "*", 
             RowBox[{"c", "/", 
              RowBox[{"(", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], ")"}]}]}]}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             RowBox[{"a", "^", "2"}], "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", 
       RowBox[{"c", "^", "2"}]}], "+", 
      RowBox[{"d", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.4928379334601374`*^9, 
   3.492837939216548*^9}, {3.4928380301959076`*^9, 3.4928380706935787`*^9}, {
   3.4928381256836753`*^9, 3.492838126026876*^9}, {3.492838194448596*^9, 
   3.492838214806632*^9}, {3.4928386496573954`*^9, 3.4928386538382025`*^9}, {
   3.4928387393419533`*^9, 3.4928388738453894`*^9}, {3.4928392099891806`*^9, 
   3.4928392282724123`*^9}, {3.4928392656204743`*^9, 3.492839265890475*^9}, {
   3.4928393374405746`*^9, 3.492839337970576*^9}, 3.4928413413933806`*^9, {
   3.4930740306333447`*^9, 3.4930740321133466`*^9}, {3.493144462352366*^9, 
   3.493144468172374*^9}, {3.493144540822476*^9, 3.4931445433324795`*^9}, {
   3.4931445892825437`*^9, 3.4931445898425446`*^9}, {3.493145449723748*^9, 
   3.493145475833785*^9}, {3.493146638085412*^9, 3.4931466465254235`*^9}, {
   3.4931467543555746`*^9, 3.4931467820656137`*^9}, {3.493146817405663*^9, 
   3.493146854555715*^9}, {3.493147492576608*^9, 3.493147492956609*^9}, {
   3.4931575219698725`*^9, 3.4931575367198925`*^9}, {3.493158449661171*^9, 
   3.4931584772112093`*^9}, {3.4935810370816417`*^9, 
   3.4935810386816435`*^9}, {3.4940008714545527`*^9, 
   3.4940008714585524`*^9}, {3.494023359340608*^9, 3.494023359702629*^9}, 
   3.4940350808336115`*^9, 3.4940353133719115`*^9, 3.4940383116564035`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["x", 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", "x"}]}]], "\[Equal]", 
   RowBox[{
    FractionBox["1", "d"], "-", 
    FractionBox["c", 
     RowBox[{"d", " ", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664443126074*^9, 3.479664484795992*^9, {3.479686720494632*^9, 
   3.479686740223*^9}, {3.4929978496877213`*^9, 3.4929978567233334`*^9}, {
   3.4929979016982126`*^9, 3.492997933194668*^9}, 3.4929979741135397`*^9, {
   3.4932342226975756`*^9, 3.4932342226975756`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    SuperscriptBox["d", "2"]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"m", ">", "0"}], " ", "\[And]", " ", 
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.492907662576008*^9, 3.4929076635660095`*^9}, {3.4930735907627287`*^9, 
   3.4930736091827545`*^9}, {3.4931451699433565`*^9, 3.493145207453409*^9}, {
   3.4931452956835327`*^9, 3.4931453218235693`*^9}, {3.4931453713536386`*^9, 
   3.4931453747436433`*^9}, 3.4931456018039613`*^9, {3.493146996085913*^9, 
   3.4931470125759363`*^9}, {3.4932344140978436`*^9, 3.493234436457875*^9}, 
   3.4932344713679237`*^9, 3.493234764358334*^9, {3.493581169571827*^9, 
   3.4935812149118905`*^9}, {3.494035048904785*^9, 3.494035048904785*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "m"], " ", 
      SuperscriptBox[
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "d"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox["x", 
       RowBox[{"m", "-", "1"}]], " ", 
      SuperscriptBox[
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["c", "d"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"m", "-", "1"}]], " ", 
       SuperscriptBox[
        RowBox[{"ArcTan", "[", 
         RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.4927459475946445`*^9, 3.49274596552767*^9}, {
   3.4927470791633663`*^9, 3.492747100502587*^9}, {3.492838456185856*^9, 
   3.492838468151077*^9}, {3.4928389429535108`*^9, 3.492838996648805*^9}, {
   3.492839156730687*^9, 3.4928391643123*^9}, 3.4928403497119923`*^9, {
   3.492908275826866*^9, 3.4929083226469316`*^9}, 3.492910391739828*^9, {
   3.49299802556243*^9, 3.492998081316928*^9}, {3.4932341813675175`*^9, 
   3.4932341825075192`*^9}, {3.4932342504576144`*^9, 3.493234254887621*^9}, {
   3.4932342987776823`*^9, 3.493234348687752*^9}, {3.4940008714755535`*^9, 
   3.494000871478554*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTan", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", "x_"}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "d"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"c", "/", "d"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{
           RowBox[{"ArcTan", "[", 
            RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", 
       RowBox[{"c", "^", "2"}]}], "+", 
      RowBox[{"d", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.4928379334601374`*^9, 
   3.492837939216548*^9}, {3.4928380301959076`*^9, 3.4928380706935787`*^9}, {
   3.4928381256836753`*^9, 3.492838126026876*^9}, {3.492838194448596*^9, 
   3.492838214806632*^9}, {3.4928386496573954`*^9, 3.4928386538382025`*^9}, {
   3.4928387393419533`*^9, 3.4928388738453894`*^9}, {3.4928392099891806`*^9, 
   3.4928392282724123`*^9}, {3.4928392656204743`*^9, 3.492839265890475*^9}, {
   3.4928393374405746`*^9, 3.492839337970576*^9}, 3.4928413413933806`*^9, {
   3.4929976285885324`*^9, 3.492997657401783*^9}, {3.4929982343063965`*^9, 
   3.492998284850485*^9}, {3.4929983307925663`*^9, 3.4929983346145725`*^9}, {
   3.4929983685134325`*^9, 3.492998380915454*^9}, {3.4929985595281687`*^9, 
   3.492998559886969*^9}, {3.4929986169674697`*^9, 3.4929986552187366`*^9}, {
   3.493145648214026*^9, 3.493145651704031*^9}, {3.493174757504002*^9, 
   3.4931747608840065`*^9}, {3.4932344939779553`*^9, 3.493234517877989*^9}, {
   3.4932345822880793`*^9, 3.4932345974581003`*^9}, {3.493234635668154*^9, 
   3.4932346995382433`*^9}, {3.4935810433816504`*^9, 3.493581045391653*^9}, {
   3.494000871488554*^9, 3.4940008714925547`*^9}, 3.4940350820826826`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", "x"}]}]], "\[Equal]", 
   RowBox[{
    FractionBox["1", "c"], "-", 
    FractionBox[
     RowBox[{"d", " ", "x"}], 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664443126074*^9, 3.479664484795992*^9, {3.479686720494632*^9, 
   3.479686740223*^9}, {3.4929978496877213`*^9, 3.4929978567233334`*^9}, {
   3.4929979016982126`*^9, 3.492997933194668*^9}, 3.4929979741135397`*^9, {
   3.4932342226975756`*^9, 3.4932342226975756`*^9}, {3.4932349492985926`*^9, 
   3.493234969438621*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    SuperscriptBox["d", "2"]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.492907662576008*^9, 3.4929076635660095`*^9}, {3.4930735907627287`*^9, 
   3.4930736091827545`*^9}, {3.4931451699433565`*^9, 3.493145207453409*^9}, {
   3.4931452956835327`*^9, 3.4931453218235693`*^9}, {3.4931453713536386`*^9, 
   3.4931453747436433`*^9}, 3.4931456018039613`*^9, {3.493146996085913*^9, 
   3.4931470125759363`*^9}, {3.4932344140978436`*^9, 3.493234436457875*^9}, 
   3.4932344713679237`*^9, 3.493234764358334*^9, {3.493234813308402*^9, 
   3.4932348147484045`*^9}, {3.4932350526787376`*^9, 3.493235052938738*^9}, {
   3.493581174131833*^9, 3.493581183231846*^9}, {3.494035052924015*^9, 
   3.494035052924015*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "m"], " ", 
      SuperscriptBox[
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "c"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox["x", "m"], " ", 
      SuperscriptBox[
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["d", "c"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"m", "+", "1"}]], " ", 
       SuperscriptBox[
        RowBox[{"ArcTan", "[", 
         RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.4927459475946445`*^9, 3.49274596552767*^9}, {
   3.4927470791633663`*^9, 3.492747100502587*^9}, {3.492838456185856*^9, 
   3.492838468151077*^9}, {3.4928389429535108`*^9, 3.492838996648805*^9}, {
   3.492839156730687*^9, 3.4928391643123*^9}, 3.4928403497119923`*^9, {
   3.492908275826866*^9, 3.4929083226469316`*^9}, 3.492910391739828*^9, {
   3.49299802556243*^9, 3.492998081316928*^9}, {3.4932341813675175`*^9, 
   3.4932341825075192`*^9}, {3.4932342504576144`*^9, 3.493234254887621*^9}, {
   3.4932342987776823`*^9, 3.493234348687752*^9}, {3.4932348327784295`*^9, 
   3.4932348796784954`*^9}, 3.4932349106485386`*^9, {3.4940008715085554`*^9, 
   3.4940008715115557`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTan", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", "x_"}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "c"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"d", "/", "c"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{
           RowBox[{"ArcTan", "[", 
            RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", 
       RowBox[{"c", "^", "2"}]}], "+", 
      RowBox[{"d", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.4928379334601374`*^9, 
   3.492837939216548*^9}, {3.4928380301959076`*^9, 3.4928380706935787`*^9}, {
   3.4928381256836753`*^9, 3.492838126026876*^9}, {3.492838194448596*^9, 
   3.492838214806632*^9}, {3.4928386496573954`*^9, 3.4928386538382025`*^9}, {
   3.4928387393419533`*^9, 3.4928388738453894`*^9}, {3.4928392099891806`*^9, 
   3.4928392282724123`*^9}, {3.4928392656204743`*^9, 3.492839265890475*^9}, {
   3.4928393374405746`*^9, 3.492839337970576*^9}, 3.4928413413933806`*^9, {
   3.4929976285885324`*^9, 3.492997657401783*^9}, {3.4929982343063965`*^9, 
   3.492998284850485*^9}, {3.4929983307925663`*^9, 3.4929983346145725`*^9}, {
   3.4929983685134325`*^9, 3.492998380915454*^9}, {3.4929985595281687`*^9, 
   3.492998559886969*^9}, {3.4929986169674697`*^9, 3.4929986552187366`*^9}, {
   3.493145648214026*^9, 3.493145651704031*^9}, {3.493174757504002*^9, 
   3.4931747608840065`*^9}, {3.4932344939779553`*^9, 3.493234517877989*^9}, {
   3.4932345822880793`*^9, 3.4932345974581003`*^9}, {3.493234635668154*^9, 
   3.4932346995382433`*^9}, {3.4932349951286573`*^9, 3.493235049278733*^9}, {
   3.4935810501216593`*^9, 3.4935810521316624`*^9}, {3.494000871521556*^9, 
   3.4940008715255566`*^9}, 3.494035083106741*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.479616001935333*^9, 3.4796867203444157`*^9, {3.479687071148848*^9, 
   3.479687071399208*^9}, 3.4928222618129525`*^9, 3.4928258304168224`*^9, {
   3.4929226804037867`*^9, 3.4929226942254105`*^9}, {3.492979990624321*^9, 
   3.4929799910143223`*^9}, {3.493060035696517*^9, 3.4930600483865347`*^9}, 
   3.493253406025427*^9, 3.493274216811039*^9, 3.4940008715395575`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Reciprocal rule for integration", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.49652737814176*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    SuperscriptBox["a", "2"], " ", "c"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.492907662576008*^9, 3.4929076635660095`*^9}, {3.4930735907627287`*^9, 
   3.4930736091827545`*^9}, {3.4931451699433565`*^9, 3.493145207453409*^9}, {
   3.4931452956835327`*^9, 3.4931453218235693`*^9}, {3.4931453713536386`*^9, 
   3.4931453747436433`*^9}, 3.4931456018039613`*^9, {3.493146996085913*^9, 
   3.4931470125759363`*^9}, {3.493251623431094*^9, 3.493251640965525*^9}, {
   3.4932516789671917`*^9, 3.4932517129752517`*^9}, {3.4932533772433767`*^9, 
   3.4932533782729783`*^9}, {3.4940219715662317`*^9, 3.494021976495514*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], 
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"Log", "[", 
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "]"}], 
      RowBox[{"a", " ", "c"}]]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.4927459475946445`*^9, 3.49274596552767*^9}, {
   3.4927470791633663`*^9, 3.492747100502587*^9}, {3.492838456185856*^9, 
   3.492838468151077*^9}, {3.4928389429535108`*^9, 3.492838996648805*^9}, {
   3.492839156730687*^9, 3.4928391643123*^9}, 3.4928403497119923`*^9, {
   3.492908275826866*^9, 3.4929083226469316`*^9}, 3.492910391739828*^9, {
   3.49299802556243*^9, 3.492998081316928*^9}, {3.4932341813675175`*^9, 
   3.4932341825075192`*^9}, {3.4932342504576144`*^9, 3.493234254887621*^9}, {
   3.4932342987776823`*^9, 3.493234348687752*^9}, {3.4932348327784295`*^9, 
   3.4932348796784954`*^9}, 3.4932349106485386`*^9, 3.4933189471337347`*^9, {
   3.4940008715485573`*^9, 3.4940008715495577`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], ")"}], "*", 
       RowBox[{"ArcTan", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", "*", "x"}], "]"}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"a", "*", "c"}], ")"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.492924584761531*^9, 
   3.4929246531208515`*^9}, {3.4929246982205305`*^9, 3.4929247046789417`*^9}, 
   3.492924739529403*^9, {3.492985420001458*^9, 3.492985475178755*^9}, {
   3.493059939356382*^9, 3.493059968846423*^9}, {3.4930601293866477`*^9, 
   3.493060137446659*^9}, 3.4930603905470133`*^9, {3.4930623946218204`*^9, 
   3.49306243701188*^9}, {3.4940008715585585`*^9, 3.4940008715605583`*^9}, 
   3.4940219156060314`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Power rule for integration", "Subsubsection",
 CellChangeTimes->{3.4937489112350025`*^9}],

Cell[TextData[{
 "Rule:",
 " If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, 3.4929244021788106`*^9, {
   3.493060093566598*^9, 3.4930601027066107`*^9}, {3.4932563547390933`*^9, 
   3.493256358729099*^9}, {3.4932563891491413`*^9, 3.4932563891491413`*^9}, {
   3.493581280781983*^9, 3.4935812915719976`*^9}, {3.494021983568918*^9, 
   3.494021986848106*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", " ", "x"}], "]"}], 
       RowBox[{"n", "+", "1"}]], 
      RowBox[{"a", " ", "c", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.4927459475946445`*^9, 3.49274596552767*^9}, {
   3.4927470791633663`*^9, 3.492747100502587*^9}, {3.492838456185856*^9, 
   3.492838468151077*^9}, {3.4928389429535108`*^9, 3.492838996648805*^9}, {
   3.492839156730687*^9, 3.4928391643123*^9}, 3.4928403497119923`*^9, {
   3.492908275826866*^9, 3.4929083226469316`*^9}, 3.492910391739828*^9, {
   3.49299802556243*^9, 3.492998081316928*^9}, {3.4932341813675175`*^9, 
   3.4932341825075192`*^9}, {3.4932342504576144`*^9, 3.493234254887621*^9}, {
   3.4932342987776823`*^9, 3.493234348687752*^9}, {3.4932348327784295`*^9, 
   3.4932348796784954`*^9}, 3.4932349106485386`*^9, {3.4933189471337347`*^9, 
   3.4933189614337544`*^9}, {3.494000871574559*^9, 3.494000871575559*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
     RowBox[{"(", 
      RowBox[{"c_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", "*", "x"}], "]"}], "^", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}]}], "/", 
    RowBox[{"(", 
     RowBox[{"a", "*", "c", "*", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"n", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.492924584761531*^9, 
   3.4929246531208515`*^9}, {3.4929246982205305`*^9, 3.4929247046789417`*^9}, 
   3.492924739529403*^9, {3.492985420001458*^9, 3.492985475178755*^9}, {
   3.493059939356382*^9, 3.493059968846423*^9}, {3.4930601293866477`*^9, 
   3.493060137446659*^9}, 3.4930603905470133`*^9, {3.4935810024215927`*^9, 
   3.4935810041415954`*^9}, {3.4940008715845594`*^9, 3.49400087158656*^9}, 
   3.4940219205923166`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.492802747642827*^9, 
   3.492802751137233*^9}, 3.4928222777249804`*^9, 3.492825819138003*^9, {
   3.492830644352556*^9, 3.492830644712557*^9}, {3.4928404670121565`*^9, 
   3.492840467502157*^9}, 3.4929133195939274`*^9, 3.4931664671723957`*^9, 
   3.493251887352358*^9, 3.4940008716005607`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["x", 
    RowBox[{"1", "+", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["x", "2"]}]}]], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["I", 
      RowBox[{"a", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["x", "2"]}]}], ")"}]}]]}], "-", 
    FractionBox["1", 
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{"I", "-", 
        RowBox[{"a", " ", "x"}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664431619528*^9, 3.4796644842351856`*^9, {3.4796867203243876`*^9, 
   3.4796867203243876`*^9}, {3.479686900964134*^9, 3.479686904699506*^9}, 
   3.49290371904314*^9, {3.493790149041623*^9, 3.493790149041623*^9}, {
   3.4940237466747627`*^9, 3.494023752087072*^9}, {3.4940238629374123`*^9, 
   3.4940238730189886`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", 
    RowBox[{"n", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.492907662576008*^9, 3.4929076635660095`*^9}, {3.4930735907627287`*^9, 
   3.4930736091827545`*^9}, {3.4931451699433565`*^9, 3.493145207453409*^9}, {
   3.4931452956835327`*^9, 3.4931453218235693`*^9}, {3.4931453713536386`*^9, 
   3.4931453747436433`*^9}, 3.4931456018039613`*^9, {3.493146996085913*^9, 
   3.4931470125759363`*^9}, {3.493251623431094*^9, 3.493251640965525*^9}, {
   3.4932516789671917`*^9, 3.4932517129752517`*^9}, {3.4935813034320145`*^9, 
   3.4935813034320145`*^9}, {3.493581363142098*^9, 3.493581363142098*^9}, {
   3.4940219944315395`*^9, 3.494021997654724*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"x", " ", 
      SuperscriptBox[
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"I", " ", 
         SuperscriptBox[
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", " ", "x"}], "]"}], 
          RowBox[{"n", "+", "1"}]]}], 
        RowBox[{"d", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", " ", "c"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], 
      RowBox[{"I", "-", 
       RowBox[{"a", " ", "x"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.4927426625007477`*^9, 3.492742662695759*^9}, {
   3.4927427022060184`*^9, 3.4927427689718375`*^9}, {3.49274284243804*^9, 
   3.492742899943329*^9}, {3.4927429432068033`*^9, 3.49274296955731*^9}, 
   3.4927430042452946`*^9, {3.4927431140225735`*^9, 3.4927431953072224`*^9}, {
   3.492743302802371*^9, 3.492743321909464*^9}, {3.49274365403046*^9, 
   3.492743699403055*^9}, {3.4927438451893935`*^9, 3.4927438547469406`*^9}, {
   3.492743907312947*^9, 3.4927439763068933`*^9}, {3.4927441805245733`*^9, 
   3.4927442303734245`*^9}, {3.492744267490548*^9, 3.4927442920949554`*^9}, {
   3.492744353045441*^9, 3.492744384969267*^9}, {3.492744450696027*^9, 
   3.4927444509000387`*^9}, {3.492744509440387*^9, 3.4927445278794413`*^9}, {
   3.4927446880156*^9, 3.492744707778731*^9}, {3.492745634407731*^9, 
   3.492745768275388*^9}, 3.492746696296468*^9, {3.4927468384145966`*^9, 
   3.492746872356538*^9}, {3.492839388040646*^9, 3.4928394598207464`*^9}, 
   3.4928397046810894`*^9, {3.492908081426594*^9, 3.4929081433866806`*^9}, 
   3.492910389019825*^9, {3.493251753613323*^9, 3.493251782301773*^9}, {
   3.4932518158262324`*^9, 3.493251846137086*^9}, {3.493412510259725*^9, 
   3.4934125193197374`*^9}, {3.4940008716155615`*^9, 
   3.4940008716185617`*^9}, {3.494023891486045*^9, 3.494023893895183*^9}, {
   3.4940239293812127`*^9, 3.4940239473162384`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTan", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "I"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", "c"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
         RowBox[{"(", 
          RowBox[{"I", "-", 
           RowBox[{"a", "*", "x"}]}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.4928379334601374`*^9, 
   3.492837939216548*^9}, {3.4928380301959076`*^9, 3.4928380706935787`*^9}, {
   3.4928381256836753`*^9, 3.492838126026876*^9}, {3.492838194448596*^9, 
   3.492838214806632*^9}, {3.4928394899907885`*^9, 3.492839600870944*^9}, {
   3.492839660371027*^9, 3.492839670511041*^9}, {3.492839872431324*^9, 
   3.492839876241329*^9}, 3.4928399970514984`*^9, 3.49284133392337*^9, {
   3.492841789364008*^9, 3.492841792164012*^9}, {3.4934125901798368`*^9, 
   3.4934125945498433`*^9}, {3.493580989441575*^9, 3.493580991871578*^9}, {
   3.4940008716275625`*^9, 3.494000871631562*^9}, 3.4940219210953455`*^9, {
   3.494023971873643*^9, 3.494023986116458*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"x", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["x", "2"]}]}], ")"}]}]], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"a", " ", "I"}], 
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["x", "2"]}]}]]}], "+", 
    FractionBox["I", 
     RowBox[{"x", 
      RowBox[{"(", 
       RowBox[{"I", "+", 
        RowBox[{"a", " ", "x"}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664431619528*^9, 3.4796644842351856`*^9, {3.4796867203243876`*^9, 
   3.4796867203243876`*^9}, {3.479686900964134*^9, 3.479686904699506*^9}, 
   3.49290371904314*^9, {3.49316782040429*^9, 3.4931678273342996`*^9}, {
   3.4931678584343433`*^9, 3.4931678962243958`*^9}, {3.4931679645244913`*^9, 
   3.493167967024495*^9}, {3.4931679986345396`*^9, 3.4931680026345453`*^9}, {
   3.4937901559116325`*^9, 3.4937901559116325`*^9}, {3.494024158969344*^9, 
   3.4940241742382174`*^9}, {3.4940242255331516`*^9, 3.4940242255331516`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", 
    RowBox[{"n", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.492907662576008*^9, 3.4929076635660095`*^9}, {3.4930735907627287`*^9, 
   3.4930736091827545`*^9}, {3.4931451699433565`*^9, 3.493145207453409*^9}, {
   3.4931452956835327`*^9, 3.4931453218235693`*^9}, {3.4931453713536386`*^9, 
   3.4931453747436433`*^9}, 3.4931456018039613`*^9, {3.493146996085913*^9, 
   3.4931470125759363`*^9}, {3.4931675717539415`*^9, 3.493167580513954*^9}, {
   3.493251958004882*^9, 3.493251958004882*^9}, {3.493581307982021*^9, 
   3.493581307982021*^9}, {3.493581358752092*^9, 3.493581358752092*^9}, {
   3.4937489859591336`*^9, 3.493748987300736*^9}, {3.494022002343992*^9, 
   3.4940220045351176`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"x", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"I", " ", 
         SuperscriptBox[
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", " ", "x"}], "]"}], 
          RowBox[{"n", "+", "1"}]]}], 
        RowBox[{"c", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["I", "c"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], 
      RowBox[{"x", 
       RowBox[{"(", 
        RowBox[{"I", "+", 
         RowBox[{"a", " ", "x"}]}], ")"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.4927426625007477`*^9, 3.492742662695759*^9}, {
   3.4927427022060184`*^9, 3.4927427689718375`*^9}, {3.49274284243804*^9, 
   3.492742899943329*^9}, {3.4927429432068033`*^9, 3.49274296955731*^9}, 
   3.4927430042452946`*^9, {3.4927431140225735`*^9, 3.4927431953072224`*^9}, {
   3.492743302802371*^9, 3.492743321909464*^9}, {3.49274365403046*^9, 
   3.492743699403055*^9}, {3.4927438451893935`*^9, 3.4927438547469406`*^9}, {
   3.492743907312947*^9, 3.4927439763068933`*^9}, {3.4927441805245733`*^9, 
   3.4927442303734245`*^9}, {3.492744267490548*^9, 3.4927442920949554`*^9}, {
   3.492744353045441*^9, 3.492744384969267*^9}, {3.492744450696027*^9, 
   3.4927444509000387`*^9}, {3.492744509440387*^9, 3.4927445278794413`*^9}, {
   3.4927446880156*^9, 3.492744707778731*^9}, {3.492745634407731*^9, 
   3.492745768275388*^9}, 3.492746696296468*^9, {3.4927468384145966`*^9, 
   3.492746872356538*^9}, {3.492839388040646*^9, 3.4928394598207464`*^9}, 
   3.4928397046810894`*^9, {3.492908081426594*^9, 3.4929081433866806`*^9}, 
   3.492910389019825*^9, {3.4931674144637213`*^9, 3.493167425813738*^9}, {
   3.493167688434105*^9, 3.4931676930941114`*^9}, {3.4932519872549334`*^9, 
   3.4932520116689763`*^9}, {3.4940008716485634`*^9, 
   3.4940008716515636`*^9}, {3.4940242549068317`*^9, 3.4940242739639215`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
     RowBox[{"(", 
      RowBox[{"x_", "*", 
       RowBox[{"(", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], ")"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "I"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"I", "/", "c"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
         RowBox[{"(", 
          RowBox[{"x", "*", 
           RowBox[{"(", 
            RowBox[{"I", "+", 
             RowBox[{"a", "*", "x"}]}], ")"}]}], ")"}]}], ",", "x"}], "]"}]}],
      "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.4928379334601374`*^9, 
   3.492837939216548*^9}, {3.4928380301959076`*^9, 3.4928380706935787`*^9}, {
   3.4928381256836753`*^9, 3.492838126026876*^9}, {3.492838194448596*^9, 
   3.492838214806632*^9}, {3.4928394899907885`*^9, 3.492839600870944*^9}, {
   3.492839660371027*^9, 3.492839670511041*^9}, {3.492839872431324*^9, 
   3.492839876241329*^9}, 3.4928399970514984`*^9, 3.49284133392337*^9, {
   3.492841789364008*^9, 3.492841792164012*^9}, {3.4931675895939665`*^9, 
   3.49316759898398*^9}, 3.4931676669740753`*^9, {3.4931677271841593`*^9, 
   3.493167763914211*^9}, {3.493580981641564*^9, 3.493580983581567*^9}, {
   3.494000871660564*^9, 3.494000871664564*^9}, 3.494021921125347*^9, {
   3.4940242996993933`*^9, 3.4940243140632153`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"x", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["x", "2"]}]}], ")"}]}]], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"a", " ", "I"}], 
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["x", "2"]}]}]]}], "+", 
    FractionBox["I", 
     RowBox[{"x", 
      RowBox[{"(", 
       RowBox[{"I", "+", 
        RowBox[{"a", " ", "x"}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664431619528*^9, 3.4796644842351856`*^9, {3.4796867203243876`*^9, 
   3.4796867203243876`*^9}, {3.479686900964134*^9, 3.479686904699506*^9}, 
   3.49290371904314*^9, {3.49316782040429*^9, 3.4931678273342996`*^9}, {
   3.4931678584343433`*^9, 3.4931678962243958`*^9}, {3.4931679645244913`*^9, 
   3.493167967024495*^9}, {3.4931679986345396`*^9, 3.4931680026345453`*^9}, {
   3.4937901612916403`*^9, 3.4937901612916403`*^9}, {3.4940243596738243`*^9, 
   3.4940243596738243`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", 
    RowBox[{"n", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.492907662576008*^9, 3.4929076635660095`*^9}, {3.4930735907627287`*^9, 
   3.4930736091827545`*^9}, {3.4931451699433565`*^9, 3.493145207453409*^9}, {
   3.4931452956835327`*^9, 3.4931453218235693`*^9}, {3.4931453713536386`*^9, 
   3.4931453747436433`*^9}, 3.4931456018039613`*^9, {3.493146996085913*^9, 
   3.4931470125759363`*^9}, {3.4931675717539415`*^9, 3.493167580513954*^9}, {
   3.493251958004882*^9, 3.493251958004882*^9}, {3.493581312932028*^9, 
   3.493581312932028*^9}, {3.4935813544820857`*^9, 3.4935813544820857`*^9}, {
   3.4937490542092533`*^9, 3.4937490549580545`*^9}, {3.494022007704299*^9, 
   3.494022010672469*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{
      RowBox[{"c", " ", "x"}], "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "3"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"I", " ", 
         SuperscriptBox[
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", " ", "x"}], "]"}], 
          RowBox[{"n", "+", "1"}]]}], 
        RowBox[{"c", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["I", "c"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], 
      RowBox[{"x", 
       RowBox[{"(", 
        RowBox[{"I", "+", 
         RowBox[{"a", " ", "x"}]}], ")"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.4927426625007477`*^9, 3.492742662695759*^9}, {
   3.4927427022060184`*^9, 3.4927427689718375`*^9}, {3.49274284243804*^9, 
   3.492742899943329*^9}, {3.4927429432068033`*^9, 3.49274296955731*^9}, 
   3.4927430042452946`*^9, {3.4927431140225735`*^9, 3.4927431953072224`*^9}, {
   3.492743302802371*^9, 3.492743321909464*^9}, {3.49274365403046*^9, 
   3.492743699403055*^9}, {3.4927438451893935`*^9, 3.4927438547469406`*^9}, {
   3.492743907312947*^9, 3.4927439763068933`*^9}, {3.4927441805245733`*^9, 
   3.4927442303734245`*^9}, {3.492744267490548*^9, 3.4927442920949554`*^9}, {
   3.492744353045441*^9, 3.492744384969267*^9}, {3.492744450696027*^9, 
   3.4927444509000387`*^9}, {3.492744509440387*^9, 3.4927445278794413`*^9}, {
   3.4927446880156*^9, 3.492744707778731*^9}, {3.492745634407731*^9, 
   3.492745768275388*^9}, 3.492746696296468*^9, {3.4927468384145966`*^9, 
   3.492746872356538*^9}, {3.492839388040646*^9, 3.4928394598207464`*^9}, 
   3.4928397046810894`*^9, {3.492908081426594*^9, 3.4929081433866806`*^9}, 
   3.492910389019825*^9, {3.4931674144637213`*^9, 3.493167425813738*^9}, {
   3.493167688434105*^9, 3.4931676930941114`*^9}, {3.4932519872549334`*^9, 
   3.4932520116689763`*^9}, 3.493252152092824*^9, {3.4940008716815653`*^9, 
   3.4940008716845655`*^9}, 3.4940243519153805`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"c_.", "*", "x_"}], "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"x_", "^", "3"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "I"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"I", "/", "c"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
         RowBox[{"(", 
          RowBox[{"x", "*", 
           RowBox[{"(", 
            RowBox[{"I", "+", 
             RowBox[{"a", "*", "x"}]}], ")"}]}], ")"}]}], ",", "x"}], "]"}]}],
      "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.4928379334601374`*^9, 
   3.492837939216548*^9}, {3.4928380301959076`*^9, 3.4928380706935787`*^9}, {
   3.4928381256836753`*^9, 3.492838126026876*^9}, {3.492838194448596*^9, 
   3.492838214806632*^9}, {3.4928394899907885`*^9, 3.492839600870944*^9}, {
   3.492839660371027*^9, 3.492839670511041*^9}, {3.492839872431324*^9, 
   3.492839876241329*^9}, 3.4928399970514984`*^9, 3.49284133392337*^9, {
   3.492841789364008*^9, 3.492841792164012*^9}, {3.4931675895939665`*^9, 
   3.49316759898398*^9}, 3.4931676669740753`*^9, {3.4931677271841593`*^9, 
   3.493167763914211*^9}, {3.4931684204151297`*^9, 3.4931684392651567`*^9}, {
   3.4935809755915556`*^9, 3.4935809770915575`*^9}, {3.493789934431322*^9, 
   3.493789945661338*^9}, {3.4940008716935663`*^9, 3.494000871697566*^9}, 
   3.494021921155349*^9, 3.4940243686493373`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "2"], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], "=", 
   RowBox[{
    FractionBox["1", "d"], "-", 
    FractionBox["c", 
     RowBox[{"d", " ", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664431619528*^9, 3.4796644842351856`*^9, {3.4796867203243876`*^9, 
   3.4796867203243876`*^9}, {3.479686900964134*^9, 3.479686904699506*^9}, 
   3.49290371904314*^9, {3.49316782040429*^9, 3.4931678273342996`*^9}, {
   3.4931678584343433`*^9, 3.4931678962243958`*^9}, {3.4931679645244913`*^9, 
   3.493167967024495*^9}, {3.4931679986345396`*^9, 3.4931680026345453`*^9}, 
   3.493790063331503*^9, 3.4937901678516493`*^9, {3.4937902960118284`*^9, 
   3.4937902973518305`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", 
    RowBox[{"m", ">", "1"}], " ", "\[And]", " ", 
    RowBox[{"n", ">", "0", " "}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, 
   3.4929827292027316`*^9, {3.493165973371704*^9, 3.493166003201746*^9}, {
   3.4931661009618826`*^9, 3.493166101641884*^9}, {3.4932522145709333`*^9, 
   3.4932522145709333`*^9}, {3.493581315932032*^9, 3.493581315932032*^9}, {
   3.493581349432079*^9, 3.493581349432079*^9}, {3.494022013786647*^9, 
   3.49402201593677*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "m"], 
      SuperscriptBox[
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "d"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox["x", 
       RowBox[{"m", "-", "2"}]], 
      SuperscriptBox[
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["c", "d"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"m", "-", "2"}]], 
       SuperscriptBox[
        RowBox[{"ArcTan", "[", 
         RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493166154681958*^9, 3.4931662030820255`*^9}, 
   3.4931666207326107`*^9, {3.4932522463481894`*^9, 3.49325228099585*^9}, {
   3.4933158052693357`*^9, 3.4933158328693743`*^9}, {3.4933190308138514`*^9, 
   3.493319134053996*^9}, {3.4933192438441496`*^9, 3.4933192445541506`*^9}, {
   3.4933193363142796`*^9, 3.4933193414042864`*^9}, {3.493412534339759*^9, 
   3.493412536469762*^9}, {3.493789994101406*^9, 3.493790017041438*^9}, {
   3.4937903432618947`*^9, 3.4937903499119043`*^9}, {3.493791019842842*^9, 
   3.4937910517128863`*^9}, 3.493791106992964*^9, 3.49379132604327*^9, {
   3.494000871714567*^9, 3.4940008717175674`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTan", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "d"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"c", "/", "d"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{
           RowBox[{"ArcTan", "[", 
            RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929236652023163`*^9, 3.49292366743312*^9}, 
   3.4929802336571484`*^9, {3.492982933672291*^9, 3.4929829505983205`*^9}, {
   3.4929832472016416`*^9, 3.4929833842790823`*^9}, {3.4929834529036026`*^9, 
   3.4929834542764053`*^9}, {3.493166117311906*^9, 3.493166138981936*^9}, {
   3.4931662751621265`*^9, 3.4931663186221876`*^9}, {3.4934126182898765`*^9, 
   3.493412622519882*^9}, {3.4935809700815477`*^9, 3.4935809719615507`*^9}, {
   3.493791136533005*^9, 3.4937911896730795`*^9}, 3.4937912549331713`*^9, {
   3.4938402453864017`*^9, 3.4938402484908075`*^9}, {3.4940008717265677`*^9, 
   3.4940008717315683`*^9}, 3.4940032500454226`*^9, 3.4940219211853504`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], "=", 
   RowBox[{
    FractionBox["1", "c"], "-", 
    FractionBox[
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}], 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664431619528*^9, 3.4796644842351856`*^9, {3.4796867203243876`*^9, 
   3.4796867203243876`*^9}, {3.479686900964134*^9, 3.479686904699506*^9}, 
   3.49290371904314*^9, {3.49316782040429*^9, 3.4931678273342996`*^9}, {
   3.4931678584343433`*^9, 3.4931678962243958`*^9}, {3.4931679645244913`*^9, 
   3.493167967024495*^9}, {3.4931679986345396`*^9, 3.4931680026345453`*^9}, 
   3.493790063331503*^9, 3.4937901678516493`*^9, {3.4937902960118284`*^9, 
   3.4937902973518305`*^9}, {3.493857825015731*^9, 3.4938578494057655`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"n", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.4929828355013185`*^9, 3.492982837903723*^9}, {
   3.493165951941674*^9, 3.493165958321683*^9}, 3.4931660117517576`*^9, {
   3.493252219687742*^9, 3.493252219687742*^9}, {3.4935813186420355`*^9, 
   3.493581344402072*^9}, {3.4940220183729095`*^9, 3.4940220212800756`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "m"], 
      SuperscriptBox[
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "c"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox["x", "m"], 
      SuperscriptBox[
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["d", "c"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"m", "+", "2"}]], 
       SuperscriptBox[
        RowBox[{"ArcTan", "[", 
         RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493166154681958*^9, 3.4931662030820255`*^9}, 
   3.4931666207326107`*^9, {3.4932522463481894`*^9, 3.49325228099585*^9}, {
   3.4933158052693357`*^9, 3.4933158328693743`*^9}, {3.4933190308138514`*^9, 
   3.493319134053996*^9}, {3.4933192438441496`*^9, 3.4933192445541506`*^9}, {
   3.4933193363142796`*^9, 3.4933193414042864`*^9}, {3.493412534339759*^9, 
   3.493412536469762*^9}, {3.493789994101406*^9, 3.493790017041438*^9}, {
   3.4937903432618947`*^9, 3.4937903499119043`*^9}, {3.493791019842842*^9, 
   3.4937910517128863`*^9}, 3.493791106992964*^9, 3.49379132604327*^9, {
   3.4937915274235525`*^9, 3.493791535933564*^9}, {3.4937916827437696`*^9, 
   3.4937916869037757`*^9}, {3.494000871747569*^9, 3.4940008717505693`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTan", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "c"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"d", "/", "c"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{
           RowBox[{"ArcTan", "[", 
            RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929236652023163`*^9, 3.49292366743312*^9}, 
   3.4929802336571484`*^9, {3.492982933672291*^9, 3.4929829505983205`*^9}, {
   3.4929832472016416`*^9, 3.4929833842790823`*^9}, {3.4929834529036026`*^9, 
   3.4929834542764053`*^9}, {3.493166117311906*^9, 3.493166138981936*^9}, {
   3.4931662751621265`*^9, 3.4931663186221876`*^9}, {3.4934126182898765`*^9, 
   3.493412622519882*^9}, {3.4935809700815477`*^9, 3.4935809719615507`*^9}, {
   3.493791136533005*^9, 3.4937911896730795`*^9}, 3.4937912549331713`*^9, {
   3.4938403406557693`*^9, 3.4938403671446157`*^9}, {3.4940008717605696`*^9, 
   3.49400087176457*^9}, 3.4940219212193527`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection"],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 " or ",
 Cell[BoxData[
  RowBox[{"a", ">", "0"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
    RowBox[{"1", "+", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["x", "2"]}]}]], "=", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"Tan", "[", 
        RowBox[{"ArcTan", "[", 
         RowBox[{"a", " ", "x"}], "]"}], "]"}], "m"], " ", 
      SuperscriptBox[
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], " "}], 
     SuperscriptBox["a", 
      RowBox[{"m", "+", "1"}]]], 
    RowBox[{
     SubscriptBox["\[PartialD]", "x"], 
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}]}]}]], "Input",
  CellChangeTimes->{{3.4935757447002296`*^9, 3.493575793020297*^9}}]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664448654022*^9, 3.479664485386842*^9, {3.4796905699999485`*^9, 
   3.4796905930330687`*^9}, {3.493066205237155*^9, 3.493066233807195*^9}, {
   3.493067002288271*^9, 3.493067007218278*^9}, {3.4930671665685015`*^9, 
   3.4930671719285088`*^9}, {3.493575564069977*^9, 3.4935756424400864`*^9}, {
   3.4935756959401617`*^9, 3.49357570903018*^9}, {3.4935758049403143`*^9, 
   3.493575809750321*^9}, {3.493575842110366*^9, 3.4935758494003763`*^9}, {
   3.494000871803572*^9, 3.494000871814573*^9}, {3.494024500651888*^9, 
   3.494024500984906*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"d", "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", "m"}]}], ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "\[Or]", " ", 
      RowBox[{"n", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}], ")"}], " ",
     "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[Or]", 
      " ", 
      RowBox[{"a", ">", "0"}]}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055117607107`*^9, {3.4930655124161854`*^9, 3.4930655280062075`*^9}, {
   3.493066033556915*^9, 3.49306607975698*^9}, {3.4930669874082503`*^9, 
   3.4930669888982525`*^9}, {3.4932562746689816`*^9, 
   3.4932562746689816`*^9}, {3.493256683249553*^9, 3.4932567141395965`*^9}, {
   3.493484196390273*^9, 3.493484198590276*^9}, {3.4934849126412754`*^9, 
   3.493484912921276*^9}, {3.4934858273225565`*^9, 3.4934858277825565`*^9}, {
   3.4934858606226025`*^9, 3.493485878442628*^9}, {3.493485980752771*^9, 
   3.493486013532817*^9}, 3.4934861613430243`*^9, {3.4935745424185467`*^9, 
   3.4935745428285475`*^9}, {3.4935745924186163`*^9, 3.493574622528659*^9}, {
   3.4935750227192187`*^9, 3.4935750542492633`*^9}, {3.493576012220604*^9, 
   3.493576016990611*^9}, {3.4935813225620413`*^9, 3.4935813359920597`*^9}, {
   3.493584208106081*^9, 3.4935842115060854`*^9}, {3.4940220237122145`*^9, 
   3.494022026042348*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      RowBox[{
       SuperscriptBox["a", 
        RowBox[{"m", "+", "1"}]], "c"}]]}]}], " ", 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox["x", "n"], 
       SuperscriptBox[
        RowBox[{"Tan", "[", "x", "]"}], "m"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579733429823`*^9, 3.4796580025249443`*^9}, {
   3.4796580760106115`*^9, 3.479658076961979*^9}, {3.479658170546547*^9, 
   3.47965817467248*^9}, {3.4796583692823153`*^9, 3.4796583839634256`*^9}, {
   3.4796584934408464`*^9, 3.479658497486664*^9}, {3.479661194084181*^9, 
   3.47966122030188*^9}, 3.479661392649704*^9, {3.4796614543984947`*^9, 
   3.4796614565015182`*^9}, {3.4796616029320755`*^9, 3.47966160861024*^9}, 
   3.479661772305622*^9, 3.47966185512471*^9, {3.4796624643307056`*^9, 
   3.4796624837586412`*^9}, {3.4796684805015345`*^9, 3.479668482213997*^9}, {
   3.47968672053469*^9, 3.479686720544704*^9}, {3.4796906638949633`*^9, 
   3.479690664315568*^9}, {3.479690714507741*^9, 3.4796907460130434`*^9}, 
   3.480705514654872*^9, {3.4930650337755156`*^9, 3.493065049545537*^9}, {
   3.4930657623365355`*^9, 3.4930657881965714`*^9}, {3.4930663212373176`*^9, 
   3.493066363577377*^9}, {3.493066963568217*^9, 3.493066975738234*^9}, 
   3.4932537469796257`*^9, 3.493256113988756*^9, {3.4932567461396413`*^9, 
   3.4932567491696453`*^9}, 3.493484110810153*^9, {3.4934842003402786`*^9, 
   3.4934842033302827`*^9}, {3.4934849452513213`*^9, 3.493484979331369*^9}, {
   3.493574446028412*^9, 3.493574506118496*^9}, {3.4935746795187387`*^9, 
   3.493574682028742*^9}, {3.4940008718335743`*^9, 3.494000871837574*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTan", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "^", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], "*", "c"}], ")"}]}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", "n"}], "*", 
          RowBox[{
           RowBox[{"Tan", "[", "x", "]"}], "^", "m"}]}], ",", "x"}], "]"}], 
       ",", "x", ",", 
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", "*", "x"}], "]"}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "||", " ", 
      RowBox[{"Not", "[", 
       RowBox[{"IntegerQ", "[", "n", "]"}], "]"}]}], ")"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "m", "]"}], " ", "||", " ", 
      RowBox[{"PositiveQ", "[", "a", "]"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.493065103075612*^9, 3.493065290765875*^9}, {
   3.493065714046468*^9, 3.493065729586489*^9}, {3.4930658063465967`*^9, 
   3.4930658068865976`*^9}, {3.493067047288334*^9, 3.493067049548337*^9}, {
   3.4930670867783895`*^9, 3.493067112388425*^9}, {3.4930674070088377`*^9, 
   3.4930674148588486`*^9}, {3.4930676846992264`*^9, 
   3.4930676962292423`*^9}, {3.493484206670287*^9, 3.4934842155203*^9}, 
   3.4934861347329865`*^9, {3.49348619445307*^9, 3.493486231663122*^9}, {
   3.4934862761831846`*^9, 3.4934862874732003`*^9}, {3.4935748506089783`*^9, 
   3.4935750140392065`*^9}, {3.4935759916505756`*^9, 3.493575995420581*^9}, 
   3.4935766556615047`*^9, 3.493576706471576*^9, {3.493580958311531*^9, 
   3.493580960351534*^9}, {3.4935842485261374`*^9, 3.4935842501161394`*^9}, {
   3.4940008718475747`*^9, 3.494000871851575*^9}, 3.494021921249354*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
    RowBox[{"1", "+", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["x", "2"]}]}]], "=", 
   RowBox[{
    FractionBox["1", "a"], 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox[
       RowBox[{"Tan", "[", 
        RowBox[{"ArcTan", "[", 
         RowBox[{"a", " ", "x"}], "]"}], "]"}], "a"], ")"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", "x"], 
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}]}]}]], "Input",
  CellChangeTimes->{{3.4935757447002296`*^9, 3.493575793020297*^9}}]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664448654022*^9, 3.479664485386842*^9, {3.4796905699999485`*^9, 
   3.4796905930330687`*^9}, {3.493066205237155*^9, 3.493066233807195*^9}, {
   3.493067002288271*^9, 3.493067007218278*^9}, {3.4930671665685015`*^9, 
   3.4930671719285088`*^9}, {3.493575564069977*^9, 3.4935756424400864`*^9}, {
   3.4935756959401617`*^9, 3.49357570903018*^9}, {3.4935758049403143`*^9, 
   3.493575809750321*^9}, {3.493575842110366*^9, 3.4935758494003763`*^9}, {
   3.4935761209707565`*^9, 3.493576167880822*^9}, {3.493576511191303*^9, 
   3.493576539971343*^9}, {3.494000871873576*^9, 3.494000871884577*^9}, {
   3.494024607733012*^9, 3.4940246082850437`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"d", "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", "m"}]}], ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "\[Or]", " ", 
      RowBox[{"n", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}], ")"}], " ",
     "\[And]", " ", 
    RowBox[{"\[Not]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[Or]", 
       " ", 
       RowBox[{"a", ">", "0"}]}], ")"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055117607107`*^9, {3.4930655124161854`*^9, 3.4930655280062075`*^9}, {
   3.493066033556915*^9, 3.49306607975698*^9}, {3.4930669874082503`*^9, 
   3.4930669888982525`*^9}, {3.4932562746689816`*^9, 
   3.4932562746689816`*^9}, {3.493256683249553*^9, 3.4932567141395965`*^9}, {
   3.493484196390273*^9, 3.493484198590276*^9}, {3.4934849126412754`*^9, 
   3.493484912921276*^9}, {3.4934858273225565`*^9, 3.4934858277825565`*^9}, {
   3.4934858606226025`*^9, 3.493485878442628*^9}, {3.493485980752771*^9, 
   3.493486013532817*^9}, 3.4934861613430243`*^9, {3.4935745424185467`*^9, 
   3.4935745428285475`*^9}, {3.4935745924186163`*^9, 3.493574622528659*^9}, {
   3.4935750227192187`*^9, 3.4935750542492633`*^9}, {3.493576012220604*^9, 
   3.493576016990611*^9}, 3.493576288350991*^9, {3.493581325842046*^9, 
   3.4935813317720537`*^9}, {3.4935842190960965`*^9, 
   3.4935842227961016`*^9}, {3.4940220284994884`*^9, 3.49402203184468*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      RowBox[{"a", " ", "c"}]]}]}], " ", 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox["x", "n"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox[
          RowBox[{"Tan", "[", "x", "]"}], "a"], ")"}], "m"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579733429823`*^9, 3.4796580025249443`*^9}, {
   3.4796580760106115`*^9, 3.479658076961979*^9}, {3.479658170546547*^9, 
   3.47965817467248*^9}, {3.4796583692823153`*^9, 3.4796583839634256`*^9}, {
   3.4796584934408464`*^9, 3.479658497486664*^9}, {3.479661194084181*^9, 
   3.47966122030188*^9}, 3.479661392649704*^9, {3.4796614543984947`*^9, 
   3.4796614565015182`*^9}, {3.4796616029320755`*^9, 3.47966160861024*^9}, 
   3.479661772305622*^9, 3.47966185512471*^9, {3.4796624643307056`*^9, 
   3.4796624837586412`*^9}, {3.4796684805015345`*^9, 3.479668482213997*^9}, {
   3.47968672053469*^9, 3.479686720544704*^9}, {3.4796906638949633`*^9, 
   3.479690664315568*^9}, {3.479690714507741*^9, 3.4796907460130434`*^9}, 
   3.480705514654872*^9, {3.4930650337755156`*^9, 3.493065049545537*^9}, {
   3.4930657623365355`*^9, 3.4930657881965714`*^9}, {3.4930663212373176`*^9, 
   3.493066363577377*^9}, {3.493066963568217*^9, 3.493066975738234*^9}, 
   3.4932537469796257`*^9, 3.493256113988756*^9, {3.4932567461396413`*^9, 
   3.4932567491696453`*^9}, 3.493484110810153*^9, {3.4934842003402786`*^9, 
   3.4934842033302827`*^9}, {3.4934849452513213`*^9, 3.493484979331369*^9}, {
   3.493574446028412*^9, 3.493574506118496*^9}, {3.4935746795187387`*^9, 
   3.493574682028742*^9}, {3.4935764123011646`*^9, 3.493576431451191*^9}, {
   3.4935764737712507`*^9, 3.493576478761257*^9}, {3.494000871906578*^9, 
   3.4940008719105787`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTan", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "c"}], ")"}]}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", "n"}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Tan", "[", "x", "]"}], "/", "a"}], ")"}], "^", "m"}]}], 
         ",", "x"}], "]"}], ",", "x", ",", 
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", "*", "x"}], "]"}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "||", " ", 
      RowBox[{"Not", "[", 
       RowBox[{"IntegerQ", "[", "n", "]"}], "]"}]}], ")"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "m", "]"}], " ", "||", " ", 
      RowBox[{"PositiveQ", "[", "a", "]"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.493065103075612*^9, 3.493065290765875*^9}, {
   3.493065714046468*^9, 3.493065729586489*^9}, {3.4930658063465967`*^9, 
   3.4930658068865976`*^9}, {3.493067047288334*^9, 3.493067049548337*^9}, {
   3.4930670867783895`*^9, 3.493067112388425*^9}, {3.4930674070088377`*^9, 
   3.4930674148588486`*^9}, {3.4930676846992264`*^9, 
   3.4930676962292423`*^9}, {3.493484206670287*^9, 3.4934842155203*^9}, 
   3.4934861304629803`*^9, 3.4934861903430643`*^9, {3.4934862534031525`*^9, 
   3.493486262273165*^9}, {3.4934862996232176`*^9, 3.4934863089332304`*^9}, {
   3.493575978670557*^9, 3.4935759803305597`*^9}, {3.4935766168214507`*^9, 
   3.4935766805915403`*^9}, 3.493576722851599*^9, {3.493580952391523*^9, 
   3.493580954621526*^9}, {3.493584242456129*^9, 3.493584244676132*^9}, {
   3.494000871920579*^9, 3.494000871924579*^9}, 3.494021921279356*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
     RowBox[{"ArcTanh", "[", "u", "]"}]}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.492802747642827*^9, 
   3.492802751137233*^9}, 3.4928222777249804`*^9, 3.492825819138003*^9, {
   3.492830644352556*^9, 3.492830644712557*^9}, {3.4928404670121565`*^9, 
   3.492840467502157*^9}, {3.492913336613951*^9, 3.492913339753956*^9}, {
   3.4931386203491883`*^9, 3.493138625887198*^9}, {3.4931387252593727`*^9, 
   3.493138727848977*^9}, 3.493143725971335*^9, 3.493252609984828*^9, {
   3.49400087193858*^9, 3.49400087193958*^9}, {3.494025017019422*^9, 
   3.494025020512622*^9}, {3.494029404352363*^9, 3.494029407256529*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"ArcTanh", "[", "z", "]"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", "z"}], "]"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", "z"}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664431619528*^9, 3.4796644842351856`*^9, {3.4796867203243876`*^9, 
   3.4796867203243876`*^9}, {3.479686900964134*^9, 3.479686904699506*^9}, {
   3.49400087124254*^9, 3.49400087124254*^9}, {3.4940013166188364`*^9, 
   3.4940013166188364`*^9}, {3.4940295388630567`*^9, 3.4940295615233526`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", 
    RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["u", "2"], "=", 
      RowBox[{
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox[
            RowBox[{"2", "I"}], 
            RowBox[{"I", "+", 
             RowBox[{"a", " ", "x"}]}]]}], ")"}], "2"], " ", "\[Or]", "  ", 
        SuperscriptBox["u", "2"]}], "=", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          FractionBox[
           RowBox[{"2", "I"}], 
           RowBox[{"I", "-", 
            RowBox[{"a", " ", "x"}]}]]}], ")"}], "2"]}]}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4930957381510735`*^9, 3.493095777731129*^9}, {3.4930962548817973`*^9, 
   3.493096255481798*^9}, {3.493139493669922*^9, 3.493139531063188*^9}, {
   3.493252668562931*^9, 3.493252668562931*^9}, {3.4935814042921553`*^9, 
   3.493581413882169*^9}, {3.494022034263818*^9, 3.49402203622193*^9}, {
   3.4940294570023746`*^9, 3.494029477803564*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
      RowBox[{"ArcTanh", "[", "u", "]"}]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "2"]}]}], " ", 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"ArcTan", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
        RowBox[{"Log", "[", 
         RowBox[{"1", "+", "u"}], "]"}]}], 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"ArcTan", "[", 
         RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
       RowBox[{"Log", "[", 
        RowBox[{"1", "-", "u"}], "]"}]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.492982817124486*^9, 3.4929828178576875`*^9}, 
   3.4931655191410685`*^9, 3.493166624072615*^9, {3.493252259202612*^9, 
   3.4932522639918203`*^9}, {3.493252361117591*^9, 3.493252364440397*^9}, 
   3.4933156800291605`*^9, {3.494000871977582*^9, 3.494000871982582*^9}, {
   3.494024788598357*^9, 3.494024837206137*^9}, 3.494029492169386*^9, {
   3.4940295938662024`*^9, 3.494029611453209*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "*", 
     RowBox[{
      RowBox[{"ArcTanh", "[", "u_", "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "*", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"1", "+", "u"}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "*", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"1", "-", "u"}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"ZeroQ", "[", 
       RowBox[{
        RowBox[{"u", "^", "2"}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2", "*", 
            RowBox[{"I", "/", 
             RowBox[{"(", 
              RowBox[{"I", "+", 
               RowBox[{"a", "*", "x"}]}], ")"}]}]}]}], ")"}], "^", "2"}]}], 
       "]"}], " ", "||", " ", 
      RowBox[{"ZeroQ", "[", 
       RowBox[{
        RowBox[{"u", "^", "2"}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2", "*", 
            RowBox[{"I", "/", 
             RowBox[{"(", 
              RowBox[{"I", "-", 
               RowBox[{"a", "*", "x"}]}], ")"}]}]}]}], ")"}], "^", "2"}]}], 
       "]"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.4928379334601374`*^9, 
   3.492837939216548*^9}, {3.4928380301959076`*^9, 3.4928380706935787`*^9}, {
   3.4928381256836753`*^9, 3.492838126026876*^9}, {3.4928381673513484`*^9, 
   3.4928381717973566`*^9}, {3.492838221982644*^9, 3.492838250608695*^9}, {
   3.492840280811896*^9, 3.492840287331905*^9}, 3.4928413614234085`*^9, {
   3.493138538807845*^9, 3.4931385448294554`*^9}, {3.493139257267107*^9, 
   3.4931393087783976`*^9}, 3.4931393776681185`*^9, {3.493139438976226*^9, 
   3.4931394493814445`*^9}, {3.4935814251121845`*^9, 3.493581427492188*^9}, {
   3.494000871994583*^9, 3.4940008720015836`*^9}, 3.4940219213103576`*^9, {
   3.4940248230103254`*^9, 3.494024843757512*^9}, {3.494024928333349*^9, 
   3.494024931642539*^9}, 3.4940295845926723`*^9, {3.4940296573848352`*^9, 
   3.4940296697735443`*^9}, {3.4940297053725805`*^9, 3.4940297260467625`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
     RowBox[{"Log", "[", "u", "]"}]}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.492802747642827*^9, 
   3.492802751137233*^9}, 3.4928222777249804`*^9, 3.492825819138003*^9, {
   3.492830644352556*^9, 3.492830644712557*^9}, {3.4928404670121565`*^9, 
   3.492840467502157*^9}, {3.492913336613951*^9, 3.492913339753956*^9}, 
   3.4931436949112916`*^9, 3.493252774143916*^9, 3.4940008720145845`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", 
     RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", "u"}], ")"}], "2"]}], "=", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       FractionBox[
        RowBox[{"2", "I"}], 
        RowBox[{"I", "+", 
         RowBox[{"a", " ", "x"}]}]]}], ")"}], "2"]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4930957381510735`*^9, 3.493095777731129*^9}, {3.4930962548817973`*^9, 
   3.493096255481798*^9}, {3.4930966874724026`*^9, 3.493096711762437*^9}, {
   3.4930967471324863`*^9, 3.493096747642487*^9}, {3.4932527496362734`*^9, 
   3.4932527496362734`*^9}, {3.493581449742219*^9, 3.493581458802232*^9}, {
   3.493581496762285*^9, 3.4935815094423027`*^9}, {3.494022037951029*^9, 
   3.4940220399331427`*^9}, {3.4940298224392767`*^9, 3.4940298294536777`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
      RowBox[{"Log", "[", "u", "]"}]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{" ", 
        RowBox[{"I", " ", 
         SuperscriptBox[
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
         RowBox[{"PolyLog", "[", 
          RowBox[{"2", ",", 
           RowBox[{"1", "-", "u"}]}], "]"}]}]}], 
       RowBox[{"2", "a", " ", "c"}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"n", " ", "I"}], "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"ArcTan", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "-", "1"}]], " ", 
       RowBox[{"PolyLog", "[", 
        RowBox[{"2", ",", 
         RowBox[{"1", "-", "u"}]}], "]"}]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 PageWidth->Infinity,
 CellChangeTimes->{{3.492982817124486*^9, 3.4929828178576875`*^9}, 
   3.4931655191410685`*^9, 3.493166624072615*^9, {3.493252259202612*^9, 
   3.4932522639918203`*^9}, {3.493252361117591*^9, 3.493252364440397*^9}, 
   3.4933156800291605`*^9, 3.4933160671297026`*^9, {3.494000872027585*^9, 
   3.4940008720305853`*^9}, {3.494029933733642*^9, 3.4940299402480145`*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "*", 
     RowBox[{
      RowBox[{"Log", "[", "u_", "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"I", "*", 
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "*", 
     RowBox[{
      RowBox[{"PolyLog", "[", 
       RowBox[{"2", ",", 
        RowBox[{"1", "-", "u"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "a", "*", "c"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "*", 
       RowBox[{"I", "/", "2"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"PolyLog", "[", 
           RowBox[{"2", ",", 
            RowBox[{"1", "-", "u"}]}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "u"}], ")"}], "^", "2"}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"2", "*", 
          RowBox[{"I", "/", 
           RowBox[{"(", 
            RowBox[{"I", "+", 
             RowBox[{"a", "*", "x"}]}], ")"}]}]}]}], ")"}], "^", "2"}]}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.4928379334601374`*^9, 
   3.492837939216548*^9}, {3.4928380301959076`*^9, 3.4928380706935787`*^9}, {
   3.4928381256836753`*^9, 3.492838126026876*^9}, {3.4928381673513484`*^9, 
   3.4928381717973566`*^9}, {3.492838221982644*^9, 3.492838250608695*^9}, {
   3.492840280811896*^9, 3.492840287331905*^9}, 3.4928413614234085`*^9, {
   3.493138538807845*^9, 3.4931385448294554`*^9}, {3.4935814687422457`*^9, 
   3.4935814707822485`*^9}, {3.4940008720405855`*^9, 3.494000872044586*^9}, 
   3.49402192134536*^9, {3.494030114164962*^9, 3.494030137468295*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", 
     RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", "u"}], ")"}], "2"]}], "=", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       FractionBox[
        RowBox[{"2", "I"}], 
        RowBox[{"I", "-", 
         RowBox[{"a", " ", "x"}]}]]}], ")"}], "2"]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4930957381510735`*^9, 3.493095777731129*^9}, {3.4930962548817973`*^9, 
   3.493096255481798*^9}, {3.4930966874724026`*^9, 3.493096711762437*^9}, {
   3.4932527647214994`*^9, 3.4932527647214994`*^9}, {3.493581521182319*^9, 
   3.493581538282343*^9}, {3.4940220416442404`*^9, 3.494022043545349*^9}, {
   3.4940301995118437`*^9, 3.4940302035320735`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
      RowBox[{"Log", "[", "u", "]"}]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"I", " ", 
         SuperscriptBox[
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
         RowBox[{"PolyLog", "[", 
          RowBox[{"2", ",", 
           RowBox[{"1", "-", "u"}]}], "]"}]}], 
        RowBox[{"2", "a", " ", "c"}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"n", " ", "I"}], "2"], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"ArcTan", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "-", "1"}]], " ", 
       RowBox[{"PolyLog", "[", 
        RowBox[{"2", ",", 
         RowBox[{"1", "-", "u"}]}], "]"}]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 PageWidth->Infinity,
 CellChangeTimes->{{3.492982817124486*^9, 3.4929828178576875`*^9}, 
   3.4931655191410685`*^9, 3.493166624072615*^9, {3.493252259202612*^9, 
   3.4932522639918203`*^9}, {3.493252361117591*^9, 3.493252364440397*^9}, 
   3.4933156800291605`*^9, 3.4933160764997153`*^9, {3.494000872058587*^9, 
   3.4940008720615873`*^9}, {3.494030195205597*^9, 3.494030196178653*^9}, {
   3.4940302302145996`*^9, 3.4940302305686197`*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "*", 
     RowBox[{
      RowBox[{"Log", "[", "u_", "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "I"}], "*", 
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "*", 
     RowBox[{
      RowBox[{"PolyLog", "[", 
       RowBox[{"2", ",", 
        RowBox[{"1", "-", "u"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "a", "*", "c"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "*", 
       RowBox[{"I", "/", "2"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"PolyLog", "[", 
           RowBox[{"2", ",", 
            RowBox[{"1", "-", "u"}]}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "u"}], ")"}], "^", "2"}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"2", "*", 
          RowBox[{"I", "/", 
           RowBox[{"(", 
            RowBox[{"I", "-", 
             RowBox[{"a", "*", "x"}]}], ")"}]}]}]}], ")"}], "^", "2"}]}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.4928379334601374`*^9, 
   3.492837939216548*^9}, {3.4928380301959076`*^9, 3.4928380706935787`*^9}, {
   3.4928381256836753`*^9, 3.492838126026876*^9}, {3.492838194448596*^9, 
   3.492838214806632*^9}, {3.492840292461912*^9, 3.492840299431922*^9}, 
   3.4928413656434145`*^9, {3.4930965007921414`*^9, 3.4930965332721868`*^9}, {
   3.4935814756022553`*^9, 3.4935814775622582`*^9}, {3.4940008720715876`*^9, 
   3.4940008720765877`*^9}, 3.4940219213753614`*^9, {3.4940302923321524`*^9, 
   3.494030309884156*^9}, {3.494030515261904*^9, 3.494030519732159*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
     RowBox[{"PolyLog", "[", 
      RowBox[{"p", ",", "u"}], "]"}]}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.492802747642827*^9, 
   3.492802751137233*^9}, 3.4928222777249804`*^9, 3.492825819138003*^9, {
   3.492830644352556*^9, 3.492830644712557*^9}, {3.4928404670121565`*^9, 
   3.492840467502157*^9}, 3.492913349043969*^9, 3.4931388908692636`*^9, 
   3.493143703721304*^9, 3.4932529661958537`*^9, 3.4940008720905886`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", 
     RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
     SuperscriptBox["u", "2"]}], "=", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       FractionBox[
        RowBox[{"2", "I"}], 
        RowBox[{"I", "+", 
         RowBox[{"a", " ", "x"}]}]]}], ")"}], "2"]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4930957381510735`*^9, 3.493095777731129*^9}, {3.4930962548817973`*^9, 
   3.493096255481798*^9}, {3.4932531421173625`*^9, 3.4932531421173625`*^9}, {
   3.4935817370726213`*^9, 3.493581749462639*^9}, {3.494022045101438*^9, 
   3.4940220526068673`*^9}, {3.4940303588919597`*^9, 3.4940303624561634`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
      RowBox[{"PolyLog", "[", 
       RowBox[{"p", ",", "u"}], "]"}]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                           ", 
      "\[IndentingNewLine]", "                                             ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"I", " ", 
         SuperscriptBox[
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
         RowBox[{"PolyLog", "[", 
          RowBox[{
           RowBox[{"p", "+", "1"}], ",", "u"}], "]"}]}], 
        RowBox[{"2", "a", " ", "c"}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"n", " ", "I"}], "2"], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"ArcTan", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "-", "1"}]], " ", 
       RowBox[{"PolyLog", "[", 
        RowBox[{
         RowBox[{"p", "+", "1"}], ",", "u"}], "]"}]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.492982817124486*^9, 3.4929828178576875`*^9}, 
   3.4931655191410685`*^9, 3.493166624072615*^9, {3.493252259202612*^9, 
   3.4932522639918203`*^9}, {3.493252361117591*^9, 3.493252364440397*^9}, 
   3.4933156800291605`*^9, 3.4933161350697975`*^9, {3.493320303475633*^9, 
   3.493320336085679*^9}, {3.49332038699575*^9, 3.493320391165756*^9}, {
   3.4933205094659214`*^9, 3.4933205100859222`*^9}, {3.494000872102589*^9, 
   3.4940008721065893`*^9}, {3.49403037306177*^9, 3.494030377681034*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "*", 
     RowBox[{
      RowBox[{"PolyLog", "[", 
       RowBox[{"p_", ",", "u_"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "I"}], "*", 
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "*", 
     RowBox[{
      RowBox[{"PolyLog", "[", 
       RowBox[{
        RowBox[{"p", "+", "1"}], ",", "u"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "a", "*", "c"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "*", 
       RowBox[{"I", "/", "2"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"PolyLog", "[", 
           RowBox[{
            RowBox[{"p", "+", "1"}], ",", "u"}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d", ",", "p"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"u", "^", "2"}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"2", "*", 
          RowBox[{"I", "/", 
           RowBox[{"(", 
            RowBox[{"I", "+", 
             RowBox[{"a", "*", "x"}]}], ")"}]}]}]}], ")"}], "^", "2"}]}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997359719353`*^9, 3.492799760261178*^9}, {
   3.4928403040619287`*^9, 3.492840308581935*^9}, 3.492841369963421*^9, {
   3.4928426836352596`*^9, 3.492842700155283*^9}, {3.493096333451907*^9, 
   3.4930963718219604`*^9}, {3.4935817628926573`*^9, 
   3.4935817654026613`*^9}, {3.49400087211659*^9, 3.49400087212059*^9}, 
   3.494021921405363*^9, {3.4940304483700776`*^9, 3.4940304651570377`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", 
     RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
     SuperscriptBox["u", "2"]}], "=", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       FractionBox[
        RowBox[{"2", "I"}], 
        RowBox[{"I", "-", 
         RowBox[{"a", " ", "x"}]}]]}], ")"}], "2"]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4930957381510735`*^9, 3.493095777731129*^9}, {3.4932531464697704`*^9, 
   3.4932531464697704`*^9}, {3.4935817416826277`*^9, 3.493581754482646*^9}, {
   3.4940220557920494`*^9, 3.494022058517205*^9}, {3.4940305794955773`*^9, 
   3.4940305825537524`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
      RowBox[{"PolyLog", "[", 
       RowBox[{"p", ",", "u"}], "]"}]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                          ", 
      "\[IndentingNewLine]", 
      "                                                ", 
      FractionBox[
       RowBox[{"I", " ", 
        SuperscriptBox[
         RowBox[{"ArcTan", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
        RowBox[{"PolyLog", "[", 
         RowBox[{
          RowBox[{"p", "+", "1"}], ",", "u"}], "]"}]}], 
       RowBox[{"2", "a", " ", "c"}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"n", " ", "I"}], "2"], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"ArcTan", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "-", "1"}]], " ", 
       RowBox[{"PolyLog", "[", 
        RowBox[{
         RowBox[{"p", "+", "1"}], ",", "u"}], "]"}]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.492982817124486*^9, 3.4929828178576875`*^9}, 
   3.4931655191410685`*^9, 3.493166624072615*^9, {3.493252259202612*^9, 
   3.4932522639918203`*^9}, {3.493252361117591*^9, 3.493252364440397*^9}, 
   3.4933156800291605`*^9, 3.4933161430898085`*^9, {3.493320319155655*^9, 
   3.493320327755667*^9}, {3.4933203993557673`*^9, 3.493320454915845*^9}, {
   3.4933205128259263`*^9, 3.493320513405927*^9}, {3.494000872134591*^9, 
   3.4940008721385913`*^9}, {3.494030570257049*^9, 3.4940305742852793`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "*", 
     RowBox[{
      RowBox[{"PolyLog", "[", 
       RowBox[{"p_", ",", "u_"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"I", "*", 
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "*", 
     RowBox[{
      RowBox[{"PolyLog", "[", 
       RowBox[{
        RowBox[{"p", "+", "1"}], ",", "u"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "a", "*", "c"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "*", 
       RowBox[{"I", "/", "2"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"PolyLog", "[", 
           RowBox[{
            RowBox[{"p", "+", "1"}], ",", "u"}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d", ",", "p"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"u", "^", "2"}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"2", "*", 
          RowBox[{"I", "/", 
           RowBox[{"(", 
            RowBox[{"I", "-", 
             RowBox[{"a", "*", "x"}]}], ")"}]}]}]}], ")"}], "^", "2"}]}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.49284031232194*^9, 
   3.4928403176719475`*^9}, {3.4928413736734257`*^9, 
   3.4928413764134293`*^9}, {3.4928427124753*^9, 3.4928427180953083`*^9}, {
   3.4930958623412476`*^9, 3.493095867661255*^9}, {3.493096011861457*^9, 
   3.4930960123514576`*^9}, {3.493581770142668*^9, 3.4935817729726715`*^9}, {
   3.494000872148592*^9, 3.494000872152592*^9}, 3.4940219214353647`*^9, {
   3.4940305873440266`*^9, 3.494030601114814*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "m"], " ", 
     SuperscriptBox[
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.479616025649432*^9, {3.4796162596058445`*^9, 3.479616276069518*^9}, {
   3.4796867203644447`*^9, 3.4796867380098176`*^9}, {3.4796961372252254`*^9, 
   3.4796961375256577`*^9}, 3.492822267896963*^9, 3.4928258267508163`*^9, {
   3.4932577931811075`*^9, 3.4932577998811164`*^9}, 3.493258386041937*^9, 
   3.493258450902028*^9, 3.494000872166593*^9, 3.4940009309599557`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    SuperscriptBox["a", "2"], " ", "c"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4930957381510735`*^9, 3.493095777731129*^9}, {3.4930962548817973`*^9, 
   3.493096255481798*^9}, {3.4932531421173625`*^9, 3.4932531421173625`*^9}, {
   3.493257575370802*^9, 3.493257592210826*^9}, {3.4940216653477173`*^9, 
   3.4940216740232134`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], " ", 
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}], " ", 
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       RowBox[{"-", 
        RowBox[{"Log", "[", 
         RowBox[{"ArcCot", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "]"}]}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"ArcTan", "[", 
         RowBox[{"a", " ", "x"}], "]"}], "]"}]}], 
      RowBox[{
       RowBox[{"a", " ", "c", " ", 
        RowBox[{"ArcCot", "[", 
         RowBox[{"a", " ", "x"}], "]"}]}], "+", 
       RowBox[{"a", " ", "c", " ", 
        RowBox[{"ArcTan", "[", 
         RowBox[{"a", " ", "x"}], "]"}]}]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, {
   3.4940008721755934`*^9, 3.4940008721795936`*^9}, {3.4940009309729567`*^9, 
   3.494000930976957*^9}, {3.494021439744814*^9, 3.4940214402118406`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"ArcCot", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "*", 
       RowBox[{"ArcTan", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "*", 
       RowBox[{"(", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], ")"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Log", "[", 
        RowBox[{"ArcCot", "[", 
         RowBox[{"a", "*", "x"}], "]"}], "]"}]}], "+", 
      RowBox[{"Log", "[", 
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "]"}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", "*", "c", "*", 
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", "*", "x"}], "]"}]}], "+", 
      RowBox[{"a", "*", "c", "*", 
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", "*", "x"}], "]"}]}]}], ")"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.493257632750882*^9, 3.4932576963209715`*^9}, {
   3.4932577508610477`*^9, 3.493257763981066*^9}, {3.493258241061734*^9, 
   3.4932582473017426`*^9}, {3.494000872188594*^9, 3.4940008721925945`*^9}, {
   3.4940009309799566`*^9, 3.4940009309839573`*^9}, {3.4940215058855963`*^9, 
   3.4940215064366283`*^9}, 3.4940219214643664`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"d", "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", "m"}]}], ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"0", "<", "n", "\[LessEqual]", "m"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.49325840970197*^9, 3.493258411811973*^9}, {
   3.4932584532120314`*^9, 3.4932584537520323`*^9}, {3.4935818687928057`*^9, 
   3.4935818687928057`*^9}, {3.494021686811945*^9, 3.494021686811945*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "m"], " ", 
      SuperscriptBox[
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                        ", 
      "\[IndentingNewLine]", 
      "                                               ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", " ", "x"}], "]"}], 
          RowBox[{"m", "+", "1"}]], " ", 
         SuperscriptBox[
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
        RowBox[{"a", " ", "c", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["n", 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"ArcCot", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"m", "+", "1"}]], " ", 
       SuperscriptBox[
        RowBox[{"ArcTan", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "-", "1"}]]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731727376`*^9, 3.4796580024348145`*^9}, {
   3.4796585662054768`*^9, 3.4796585704015102`*^9}, {3.4796611938738785`*^9, 
   3.479661220251808*^9}, 3.4796613924594307`*^9, {3.479661432957664*^9, 
   3.479661435531365*^9}, {3.4796615599302416`*^9, 3.4796615651577587`*^9}, {
   3.4796617677991424`*^9, 3.4796617978824*^9}, 3.4796618436281796`*^9, {
   3.479662183256541*^9, 3.4796621957945695`*^9}, {3.4796867203944883`*^9, 
   3.4796867402029715`*^9}, {3.4796872323406305`*^9, 3.479687270064875*^9}, {
   3.492826073390849*^9, 3.4928261527013884`*^9}, {3.492826334973708*^9, 
   3.4928263351453085`*^9}, {3.492826679349514*^9, 3.4928266798955145`*^9}, 
   3.4928267967457204`*^9, {3.4932578278611555`*^9, 3.493257905011264*^9}, {
   3.493257942631316*^9, 3.493257944461319*^9}, {3.4932580838015137`*^9, 
   3.4932580841315145`*^9}, {3.4932584146419773`*^9, 
   3.4932584213319864`*^9}, {3.4932584544720325`*^9, 3.493258456582036*^9}, {
   3.493320843336389*^9, 3.4933208585764103`*^9}, {3.4933209087264805`*^9, 
   3.4933209157664905`*^9}, {3.4940008722065954`*^9, 
   3.4940008722105956`*^9}, {3.494000930985957*^9, 3.4940009309889574`*^9}, {
   3.494021744336235*^9, 3.4940217506485963`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTan", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "c", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "/", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{
           RowBox[{"ArcTan", "[", 
            RowBox[{"a", "*", "x"}], "]"}], "^", 
           RowBox[{"(", 
            RowBox[{"n", "-", "1"}], ")"}]}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"0", "<", "n", "\[LessEqual]", "m"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4932581278315754`*^9, 3.4932581781516457`*^9}, {
   3.493258211041692*^9, 3.4932582126516943`*^9}, {3.493258319821844*^9, 
   3.4932583217718472`*^9}, {3.493258425361992*^9, 3.4932584627520447`*^9}, 
   3.4935818049827166`*^9, {3.4940008722205963`*^9, 3.4940008722245965`*^9}, {
   3.4940009309919577`*^9, 3.494000930996958*^9}, {3.4940217925259914`*^9, 
   3.494021796929243*^9}, 3.494021921500368*^9, 3.5171884655371866`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "m"], " ", 
   SuperscriptBox[
    RowBox[{"ArcTan", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.479616001935333*^9, 3.4796867203444157`*^9, {3.479687071148848*^9, 
   3.479687071399208*^9}, 3.4928222618129525`*^9, 3.4928258304168224`*^9, {
   3.4929226804037867`*^9, 3.4929226942254105`*^9}, {3.492979990624321*^9, 
   3.4929799910143223`*^9}, {3.493060035696517*^9, 3.4930600483865347`*^9}, 
   3.493253406025427*^9, 3.494000872238597*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", 
    RowBox[{"c", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055117607107`*^9, {3.4930655124161854`*^9, 3.4930655280062075`*^9}, {
   3.493066033556915*^9, 3.49306607975698*^9}, {3.4930680892297926`*^9, 
   3.4930681267098455`*^9}, {3.4930771831577578`*^9, 
   3.4930771985577793`*^9}, {3.493256297489013*^9, 3.493256308149028*^9}, {
   3.4932563410290737`*^9, 3.4932563441690784`*^9}, {3.494022060840338*^9, 
   3.494022062863454*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}], 
     SqrtBox[
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", " ", "I", " ", 
         RowBox[{"ArcTan", "[", 
          RowBox[{"a", " ", "x"}], "]"}], 
         RowBox[{"ArcTan", "[", 
          FractionBox[
           SqrtBox[
            RowBox[{"1", "+", 
             RowBox[{"I", " ", "a", " ", "x"}]}]], 
           SqrtBox[
            RowBox[{"1", "-", 
             RowBox[{"I", " ", "a", " ", "x"}]}]]], "]"}]}], 
        RowBox[{"a", 
         SqrtBox["c"]}]]}]}]}]}]}], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox[
          RowBox[{"1", "+", 
           RowBox[{"I", " ", "a", " ", "x"}]}]]}], 
        SqrtBox[
         RowBox[{"1", "-", 
          RowBox[{"I", " ", "a", " ", "x"}]}]]]}]}], "]"}]}], 
   RowBox[{"a", 
    SqrtBox["c"]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox[
         RowBox[{"1", "+", 
          RowBox[{"I", " ", "a", " ", "x"}]}]]}], 
       SqrtBox[
        RowBox[{"1", "-", 
         RowBox[{"I", " ", "a", " ", "x"}]}]]]}], "]"}]}], 
   RowBox[{"a", 
    SqrtBox["c"]}]]}]], "Subsubtitle",
 PageWidth->Infinity,
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.4933211646668386`*^9, {3.494000872251598*^9, 
   3.494000872253598*^9}, {3.4940251960636625`*^9, 3.494025196753702*^9}, {
   3.4940252312186737`*^9, 3.4940252356359262`*^9}, {3.494025387160593*^9, 
   3.494025409001842*^9}, {3.4940254453259196`*^9, 3.4940254740545626`*^9}, {
   3.4940255093365808`*^9, 3.494025509863611*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ArcTan", "[", 
      RowBox[{"a_.", "*", "x_"}], "]"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"c_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "*", "I", "*", 
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", "*", "x"}], "]"}], "*", 
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{"1", "+", 
          RowBox[{"I", "*", "a", "*", "x"}]}], "]"}], "/", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"1", "-", 
          RowBox[{"I", "*", "a", "*", "x"}]}], "]"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", 
        RowBox[{"Sqrt", "[", "c", "]"}]}], ")"}]}]}], " ", "+", " ", 
    "\[IndentingNewLine]", "  ", 
    RowBox[{"I", "*", 
     RowBox[{
      RowBox[{"PolyLog", "[", 
       RowBox[{"2", ",", 
        RowBox[{
         RowBox[{"-", "I"}], "*", 
         RowBox[{
          RowBox[{"Sqrt", "[", 
           RowBox[{"1", "+", 
            RowBox[{"I", "*", "a", "*", "x"}]}], "]"}], "/", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"1", "-", 
            RowBox[{"I", "*", "a", "*", "x"}]}], "]"}]}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", 
        RowBox[{"Sqrt", "[", "c", "]"}]}], ")"}]}]}], " ", "-", 
    "\[IndentingNewLine]", "  ", 
    RowBox[{"I", "*", 
     RowBox[{
      RowBox[{"PolyLog", "[", 
       RowBox[{"2", ",", 
        RowBox[{"I", "*", 
         RowBox[{
          RowBox[{"Sqrt", "[", 
           RowBox[{"1", "+", 
            RowBox[{"I", "*", "a", "*", "x"}]}], "]"}], "/", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"1", "-", 
            RowBox[{"I", "*", "a", "*", "x"}]}], "]"}]}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", 
        RowBox[{"Sqrt", "[", "c", "]"}]}], ")"}]}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", "c", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.492924584761531*^9, 
   3.4929246531208515`*^9}, {3.4929246982205305`*^9, 3.4929247046789417`*^9}, 
   3.492924739529403*^9, {3.493076725417117*^9, 3.493076780277194*^9}, {
   3.4930770153775234`*^9, 3.4930770237775345`*^9}, {3.4930770970076375`*^9, 
   3.4930771129476595`*^9}, {3.4940008722635984`*^9, 3.4940008722665987`*^9}, 
   3.4940219215303698`*^9, {3.4940252446504416`*^9, 3.4940252521838727`*^9}, {
   3.494025522765349*^9, 3.494025579877616*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    FractionBox[
     SqrtBox[
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["x", "2"]}]}]], 
     SqrtBox[
      RowBox[{"c", " ", "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["x", "2"]}]}]]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664448654022*^9, 3.479664485386842*^9, {3.4796905699999485`*^9, 
   3.4796905930330687`*^9}, {3.493066205237155*^9, 3.493066233807195*^9}, {
   3.493067002288271*^9, 3.493067007218278*^9}, {3.4930671665685015`*^9, 
   3.4930671719285088`*^9}, {3.493078825992059*^9, 3.493078849422092*^9}, 
   3.4930790976224394`*^9, {3.4932536079989815`*^9, 3.4932536186070004`*^9}, {
   3.494025618559828*^9, 3.4940256224620514`*^9}, {3.4940256642174397`*^9, 
   3.4940256642174397`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", 
    RowBox[{"\[Not]", 
     RowBox[{"(", 
      RowBox[{"c", ">", "0"}], ")"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055117607107`*^9, {3.4930655124161854`*^9, 3.4930655280062075`*^9}, {
   3.493066033556915*^9, 3.49306607975698*^9}, {3.4930680892297926`*^9, 
   3.4930681267098455`*^9}, {3.4930771831577578`*^9, 
   3.4930771985577793`*^9}, {3.493256297489013*^9, 3.493256308149028*^9}, {
   3.494022065313594*^9, 3.4940220678847413`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"ArcTan", "[", 
     RowBox[{"a", " ", "x"}], "]"}], 
    SqrtBox[
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SqrtBox[
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["x", "2"]}]}]], 
      SqrtBox[
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}]]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      SqrtBox[
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["x", "2"]}]}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.4933211695768456`*^9, {3.4940008722805996`*^9, 
   3.4940008722815995`*^9}, {3.4940256785832615`*^9, 3.4940256899229097`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ArcTan", "[", 
      RowBox[{"a_.", "*", "x_"}], "]"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"c_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "+", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "*", 
        RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", 
        RowBox[{"x", "^", "2"}]}]}], "]"}]}], "*", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "/", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"1", "+", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "*", 
          RowBox[{"x", "^", "2"}]}]}], "]"}]}], ",", "x"}], "]"}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"PositiveQ", "[", "c", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.492924584761531*^9, 
   3.4929246531208515`*^9}, {3.4929246982205305`*^9, 3.4929247046789417`*^9}, 
   3.492924739529403*^9, {3.493076725417117*^9, 3.493076780277194*^9}, {
   3.493077825308657*^9, 3.493077828358661*^9}, {3.4930778668687153`*^9, 
   3.493077913738781*^9}, {3.493077978808872*^9, 3.493077978948872*^9}, {
   3.493079137962496*^9, 3.4930791537525177`*^9}, {3.4930802573560643`*^9, 
   3.4930802674060783`*^9}, {3.4940008722906*^9, 3.4940008722926*^9}, 
   3.4940219215633717`*^9, {3.494025757953801*^9, 3.494025763072094*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    SuperscriptBox["a", "2"], " ", "c"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055117607107`*^9, {3.4930655124161854`*^9, 3.4930655280062075`*^9}, {
   3.493066033556915*^9, 3.49306607975698*^9}, {3.4930680892297926`*^9, 
   3.4930681267098455`*^9}, {3.4930771831577578`*^9, 
   3.4930771985577793`*^9}, {3.493256297489013*^9, 3.493256308149028*^9}, {
   3.4932565037393017`*^9, 3.4932565054493046`*^9}, {3.494022071569952*^9, 
   3.494022073954088*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], 
      RowBox[{"3", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", 
       RowBox[{"a", " ", "c", " ", 
        SqrtBox[
         RowBox[{"c", "+", 
          RowBox[{"d", " ", 
           SuperscriptBox["x", "2"]}]}]]}]]}]}]}]}], "+", 
  FractionBox[
   RowBox[{"x", " ", 
    RowBox[{"ArcTan", "[", 
     RowBox[{"a", " ", "x"}], "]"}]}], 
   RowBox[{"c", 
    SqrtBox[
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]]}]]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.493321175446854*^9, {3.494000872303601*^9, 
   3.494000872305601*^9}, 3.4940259253943777`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ArcTan", "[", 
      RowBox[{"a_.", "*", "x_"}], "]"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"3", "/", "2"}], ")"}]}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a", "*", "c", "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", 
          RowBox[{"x", "^", "2"}]}]}], "]"}]}], ")"}]}], " ", "+", "\n", "  ", 
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", 
           RowBox[{"x", "^", "2"}]}]}], "]"}]}], ")"}]}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.492924584761531*^9, 
   3.4929246531208515`*^9}, {3.4929246982205305`*^9, 3.4929247046789417`*^9}, 
   3.492924739529403*^9, {3.494000872314602*^9, 3.4940008723166018`*^9}, 
   3.4940219215873737`*^9, 3.4940259535489883`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", 
    RowBox[{"n", ">", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.493057857853468*^9, 3.4930578807234993`*^9}, {3.4930589528050003`*^9, 
   3.4930589841650443`*^9}, {3.493256250928948*^9, 3.493256250928948*^9}, {
   3.493493532773344*^9, 3.493493535913348*^9}, {3.493494121514168*^9, 
   3.493494130844181*^9}, {3.4935821227231617`*^9, 3.4935821407331867`*^9}, {
   3.494022075719189*^9, 3.49402207782931*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], 
      RowBox[{"3", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"n", " ", 
        SuperscriptBox[
         RowBox[{"ArcTan", "[", 
          RowBox[{"a", " ", "x"}], "]"}], 
         RowBox[{"n", "-", "1"}]]}], 
       RowBox[{"a", " ", "c", 
        SqrtBox[
         RowBox[{"c", "+", 
          RowBox[{"d", " ", 
           SuperscriptBox["x", "2"]}]}]]}]]}]}]}]}], "+", 
  FractionBox[
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
   RowBox[{"c", 
    SqrtBox[
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]]}]], "-", 
  RowBox[{"n", 
   RowBox[{"(", 
    RowBox[{"n", "-", "1"}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", " ", "x"}], "]"}], 
       RowBox[{"n", "-", "2"}]], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], 
       RowBox[{"3", "/", "2"}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493058932894973*^9, 3.4930589343449745`*^9}, {
   3.4930590036150713`*^9, 3.493059030475109*^9}, {3.493059071585167*^9, 
   3.4930590795551777`*^9}, {3.4930628403524446`*^9, 3.49306285140246*^9}, {
   3.4932501056192265`*^9, 3.4932501067580285`*^9}, {3.493250146257298*^9, 
   3.493250186942169*^9}, {3.493256078498707*^9, 3.4932560906487236`*^9}, {
   3.4932568685898128`*^9, 3.4932568826798325`*^9}, {3.4933216732775507`*^9, 
   3.4933216957475824`*^9}, {3.4933217278376274`*^9, 3.493321760587673*^9}, 
   3.493321813507747*^9, 3.4933218644878187`*^9, {3.493321906837878*^9, 
   3.493321919617896*^9}, {3.4933220427280684`*^9, 3.493322042928068*^9}, {
   3.4934927094121914`*^9, 3.4934927441222396`*^9}, 3.493492777272286*^9, 
   3.493493493413289*^9, 3.4934935635433865`*^9, 3.493494110054152*^9, {
   3.4940008723276024`*^9, 3.4940008723326025`*^9}, {3.494026757555975*^9, 
   3.4940267773411064`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"3", "/", "2"}], ")"}]}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"n", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "c", "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", 
           RowBox[{"x", "^", "2"}]}]}], "]"}]}], ")"}]}]}], " ", "+", "\n", 
    "  ", 
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", 
           RowBox[{"x", "^", "2"}]}]}], "]"}]}], ")"}]}]}], " ", "-", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "*", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}], "/", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"3", "/", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.4929244782757444`*^9, 
   3.4929244935793715`*^9}, {3.493058294184078*^9, 3.493058321094116*^9}, {
   3.493058376614194*^9, 3.4930583929842167`*^9}, {3.4930584278042655`*^9, 
   3.4930584671043205`*^9}, {3.493058560144451*^9, 3.493058565344458*^9}, {
   3.493058608014518*^9, 3.493058608604519*^9}, {3.4930607207894773`*^9, 
   3.4930607253094835`*^9}, {3.49306140171043*^9, 3.4930614057704363`*^9}, {
   3.4930627552623253`*^9, 3.4930629395125833`*^9}, {3.493063111452824*^9, 
   3.4930631116128244`*^9}, {3.4930631532528825`*^9, 
   3.4930631552828856`*^9}, {3.4930631929229383`*^9, 
   3.4930631974729443`*^9}, {3.4934926396120934`*^9, 
   3.4934926491221066`*^9}, {3.4934935949134307`*^9, 
   3.4934937034035826`*^9}, {3.4934941442142*^9, 3.4934941989742765`*^9}, {
   3.493494240614335*^9, 3.493494240974335*^9}, {3.493580930901493*^9, 
   3.493580933131496*^9}, {3.494000872342603*^9, 3.4940008723496037`*^9}, 
   3.4940219216243753`*^9, {3.4940267912139*^9, 3.494026794236073*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "2"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.493057857853468*^9, 3.4930578807234993`*^9}, {3.4930589528050003`*^9, 
   3.4930589841650443`*^9}, {3.493256250928948*^9, 3.493256250928948*^9}, {
   3.493493532773344*^9, 3.493493535913348*^9}, {3.493582160473214*^9, 
   3.493582160473214*^9}, {3.493582259573353*^9, 3.493582259573353*^9}, {
   3.494022079667415*^9, 3.494022081728533*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], 
      RowBox[{"3", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                                              \
  ", "\[IndentingNewLine]", "                        ", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"ArcTan", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "+", "1"}]], 
       RowBox[{"a", " ", "c", " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], " ", 
        SqrtBox[
         RowBox[{"c", "+", 
          RowBox[{"d", " ", 
           SuperscriptBox["x", "2"]}]}]]}]]}]}]}]}], "+", 
  FractionBox[
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}], 
     RowBox[{"n", "+", "2"}]]}], 
   RowBox[{"c", " ", 
    RowBox[{"(", 
     RowBox[{"n", "+", "1"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"n", "+", "2"}], ")"}], " ", 
    SqrtBox[
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]]}]], "-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"n", "+", "2"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", " ", "x"}], "]"}], 
       RowBox[{"n", "+", "2"}]], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], 
       RowBox[{"3", "/", "2"}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493058932894973*^9, 3.4930589343449745`*^9}, {
   3.4930590036150713`*^9, 3.493059030475109*^9}, {3.493059071585167*^9, 
   3.4930590795551777`*^9}, {3.4930628403524446`*^9, 3.49306285140246*^9}, {
   3.4932501056192265`*^9, 3.4932501067580285`*^9}, {3.493250146257298*^9, 
   3.493250186942169*^9}, {3.493256078498707*^9, 3.4932560906487236`*^9}, {
   3.4932568685898128`*^9, 3.4932568826798325`*^9}, {3.4933216732775507`*^9, 
   3.4933216957475824`*^9}, {3.4933217278376274`*^9, 3.493321760587673*^9}, 
   3.493321813507747*^9, 3.4933218644878187`*^9, {3.493321906837878*^9, 
   3.493321919617896*^9}, {3.4933220427280684`*^9, 3.493322042928068*^9}, {
   3.4934927094121914`*^9, 3.4934927441222396`*^9}, 3.493492777272286*^9, 
   3.493493493413289*^9, 3.4934935635433865`*^9, {3.4935896515237017`*^9, 
   3.4935897029137735`*^9}, {3.4935902147344904`*^9, 
   3.4935902271545076`*^9}, {3.4940008723616037`*^9, 
   3.4940008723656044`*^9}, {3.494026900415146*^9, 3.494026904582384*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"3", "/", "2"}], ")"}]}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"a", "*", "c", "*", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", 
          RowBox[{"x", "^", "2"}]}]}], "]"}]}], ")"}]}], " ", "+", "\n", "  ", 
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}], "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", 
           RowBox[{"x", "^", "2"}]}]}], "]"}]}], ")"}]}]}], " ", "-", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "2"}], ")"}]}], "/", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"3", "/", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.4929244782757444`*^9, 
   3.4929244935793715`*^9}, {3.493058294184078*^9, 3.493058321094116*^9}, {
   3.493058376614194*^9, 3.4930583929842167`*^9}, {3.4930584278042655`*^9, 
   3.4930584671043205`*^9}, {3.493058560144451*^9, 3.493058565344458*^9}, {
   3.493058608014518*^9, 3.493058608604519*^9}, {3.4930607207894773`*^9, 
   3.4930607253094835`*^9}, {3.49306140171043*^9, 3.4930614057704363`*^9}, {
   3.4930627552623253`*^9, 3.4930629395125833`*^9}, {3.493063111452824*^9, 
   3.4930631116128244`*^9}, {3.4930631532528825`*^9, 
   3.4930631552828856`*^9}, {3.4930631929229383`*^9, 
   3.4930631974729443`*^9}, {3.4934926396120934`*^9, 
   3.4934926491221066`*^9}, {3.4934935949134307`*^9, 
   3.4934937034035826`*^9}, {3.493580924681484*^9, 3.493580926611487*^9}, {
   3.494000872376605*^9, 3.4940008723846054`*^9}, 3.4940219216553774`*^9, {
   3.4940269176121297`*^9, 3.4940269206853056`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", 
    RowBox[{"m", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.493256289109001*^9, 3.493256289109001*^9}, {3.4935821637032185`*^9, 
   3.4935821637032185`*^9}, {3.4935822523333426`*^9, 
   3.4935822523333426`*^9}, {3.494022083496634*^9, 3.4940220854777474`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "m"], " ", 
    RowBox[{"ArcTan", "[", 
     RowBox[{"a", " ", "x"}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                             ", 
      "\[IndentingNewLine]", "                                      ", 
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", 
            SuperscriptBox["x", "2"]}]}], ")"}], "m"], 
        RowBox[{"2", " ", "a", " ", "m", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "m"}], "+", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  FractionBox[
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "m"], " ", 
    RowBox[{"ArcTan", "[", 
     RowBox[{"a", " ", "x"}], "]"}]}], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", "m"}], "+", "1"}], ")"}]], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", "c", " ", "m"}], 
    RowBox[{
     RowBox[{"2", " ", "m"}], "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], 
      RowBox[{"m", "-", "1"}]], " ", 
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.4933211866068697`*^9, {3.4933213613371143`*^9, 
   3.493321413107187*^9}, {3.493590253834545*^9, 3.4935902541945457`*^9}, {
   3.494000872396606*^9, 3.4940008723996067`*^9}, 3.4940269937464848`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "m_."}], "*", 
     RowBox[{"ArcTan", "[", 
      RowBox[{"a_.", "*", "x_"}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", 
          RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "m"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", "a", "*", "m", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "*", "m"}], "+", "1"}], ")"}]}], ")"}]}], " ", "+", 
    "\n", "  ", 
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "m"}], "*", 
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", "*", "m"}], "+", "1"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"2", "*", "c", "*", 
       RowBox[{"m", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "m"}], "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{"ArcTan", "[", 
          RowBox[{"a", "*", "x"}], "]"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929236652023163`*^9, 3.49292366743312*^9}, 
   3.4929802336571484`*^9, {3.4935809181814747`*^9, 3.4935809199314775`*^9}, {
   3.494000872409607*^9, 3.494000872414607*^9}, 3.4940219216843786`*^9, 
   3.4940270107094545`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"m", "\[NotEqual]", 
     RowBox[{"-", 
      FractionBox["3", "2"]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4932562829889927`*^9, 3.4932562829889927`*^9}, {3.493582169323227*^9, 
   3.493582169323227*^9}, {3.4935822423333287`*^9, 3.4935822423333287`*^9}, {
   3.4940220872288475`*^9, 3.494022089098954*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "m"], " ", 
    RowBox[{"ArcTan", "[", 
     RowBox[{"a", " ", "x"}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                            ", 
      "\[IndentingNewLine]", "                            ", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", 
           SuperscriptBox["x", "2"]}]}], ")"}], 
        RowBox[{"m", "+", "1"}]], 
       RowBox[{"4", " ", "a", " ", "c", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], "2"]}]]}]}]}]}], "-", 
  FractionBox[
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], 
     RowBox[{"m", "+", "1"}]], " ", 
    RowBox[{"ArcTan", "[", 
     RowBox[{"a", " ", "x"}], "]"}]}], 
   RowBox[{"2", "c", 
    RowBox[{"(", 
     RowBox[{"m", "+", "1"}], ")"}]}]], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"2", "m"}], "+", "3"}], 
    RowBox[{"2", " ", "c", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], 
      RowBox[{"m", "+", "1"}]], " ", 
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.49332119396688*^9, {3.4933214175471926`*^9, 
   3.4933214366372194`*^9}, {3.4933214780072775`*^9, 
   3.4933214840172863`*^9}, {3.4935902637145586`*^9, 3.493590263914559*^9}, {
   3.4940008724256077`*^9, 3.494000872428608*^9}, 3.4940270694718156`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{"ArcTan", "[", 
      RowBox[{"a_.", "*", "x_"}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"4", "*", "a", "*", "c", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "^", "2"}]}], ")"}]}], " ", "-", 
    "\n", "  ", 
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "c", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "*", "m"}], "+", "3"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "c", "*", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{"ArcTan", "[", 
          RowBox[{"a", "*", "x"}], "]"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"m", "\[NotEqual]", 
     RowBox[{
      RowBox[{"-", "3"}], "/", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.4929244782757444`*^9, 
   3.4929244935793715`*^9}, {3.493580912351467*^9, 3.4935809141414695`*^9}, {
   3.4940008724396086`*^9, 3.4940008724446087`*^9}, 3.4940219217143807`*^9, 
   3.4940270857437468`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"m", "\[NotEqual]", 
     RowBox[{"-", 
      FractionBox["3", "2"]}]}], " ", "\[And]", " ", 
    RowBox[{"n", ">", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.493057857853468*^9, 3.4930578807234993`*^9}, {3.4932562444189386`*^9, 
   3.4932562444189386`*^9}, {3.4935821752432346`*^9, 
   3.4935821752432346`*^9}, {3.493582235473319*^9, 3.493582235473319*^9}, {
   3.4940220905450373`*^9, 3.494022092415144*^9}}],

Cell[BoxData[
 RowBox[{"\t", 
  RowBox[{
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "m"], " ", 
     SuperscriptBox[
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", 
      RowBox[{
      "x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", "\t", 
       FractionBox[
        RowBox[{"n", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", 
             SuperscriptBox["x", "2"]}]}], ")"}], 
          RowBox[{"m", "+", "1"}]], " ", 
         SuperscriptBox[
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", " ", "x"}], "]"}], 
          RowBox[{"n", "-", "1"}]]}], 
        RowBox[{"4", " ", "a", " ", "c", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}], "2"]}]]}]}]}]}], "-", 
   FractionBox[
    RowBox[{"x", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], 
      RowBox[{"m", "+", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
    RowBox[{"2", " ", "c", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], "+", "\[IndentingNewLine]", "\t\t", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"2", " ", "m"}], "+", "3"}], 
     RowBox[{"2", " ", "c", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], 
       RowBox[{"m", "+", "1"}]], " ", 
      SuperscriptBox[
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}], "-", 
   RowBox[{
    FractionBox[
     RowBox[{"n", 
      RowBox[{"(", 
       RowBox[{"n", "-", "1"}], ")"}]}], 
     RowBox[{"4", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "2"]}]], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], "m"], " ", 
      SuperscriptBox[
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", " ", "x"}], "]"}], 
       RowBox[{"n", "-", "2"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493057986293648*^9, 3.4930579935736575`*^9}, {
  3.493058073023769*^9, 3.4930581370938587`*^9}, {3.493058203013951*^9, 
  3.4930582589840293`*^9}, {3.4930583663841796`*^9, 3.4930583693341837`*^9}, {
  3.493058675794613*^9, 3.4930586798646183`*^9}, {3.4932494353148484`*^9, 
  3.4932495464338436`*^9}, {3.493256213058895*^9, 3.493256222448908*^9}, {
  3.4932569792699676`*^9, 3.4932569886099806`*^9}, {3.493322039288063*^9, 
  3.493322069838106*^9}, {3.4933221617682347`*^9, 3.49332216517824*^9}, {
  3.4940008724566097`*^9, 3.4940008724626102`*^9}, {3.494027345933628*^9, 
  3.4940273517789626`*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"n", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"4", "*", "a", "*", "c", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], "^", "2"}]}], ")"}]}]}], " ", "-", 
    "\n", "  ", 
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "c", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "*", "m"}], "+", "3"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "c", "*", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"4", "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"m", "+", "1"}], ")"}], "^", "2"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "m"}], "*", 
         RowBox[{
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"m", "\[NotEqual]", 
     RowBox[{
      RowBox[{"-", "3"}], "/", "2"}]}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.4929244782757444`*^9, 
   3.4929244935793715`*^9}, {3.493058294184078*^9, 3.493058321094116*^9}, {
   3.493058376614194*^9, 3.4930583929842167`*^9}, {3.4930584278042655`*^9, 
   3.4930584671043205`*^9}, {3.493058560144451*^9, 3.493058565344458*^9}, {
   3.493058608014518*^9, 3.493058608604519*^9}, {3.4930607207894773`*^9, 
   3.4930607253094835`*^9}, {3.49306140171043*^9, 3.4930614057704363`*^9}, {
   3.4935809070514593`*^9, 3.493580908721462*^9}, {3.4940008724746103`*^9, 
   3.494000872485611*^9}, 3.494021921751383*^9, {3.4940273675488644`*^9, 
   3.494027380461603*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{" ", 
   RowBox[{"d", "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", 
     RowBox[{"m", "<", 
      RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
     RowBox[{"n", "<", 
      RowBox[{"-", "1"}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.493057857853468*^9, 3.4930578807234993`*^9}, {3.4930589528050003`*^9, 
   3.4930589841650443`*^9}, {3.493256250928948*^9, 3.493256250928948*^9}, {
   3.493493532773344*^9, 3.493493535913348*^9}, {3.493498461430244*^9, 
   3.493498462750246*^9}, {3.4934986627805257`*^9, 3.4934986654705296`*^9}, {
   3.493500262062765*^9, 3.493500278262788*^9}, {3.4935009224036894`*^9, 
   3.4935009269736958`*^9}, {3.4935024446458206`*^9, 
   3.4935024539658337`*^9}, {3.4935821786732397`*^9, 
   3.4935821786732397`*^9}, {3.4935822229233017`*^9, 
   3.4935822229233017`*^9}, {3.493749489450018*^9, 3.4937494905732203`*^9}, {
   3.494022094284251*^9, 3.4940220963833714`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                           ", 
      "\[IndentingNewLine]", "                                  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", 
            SuperscriptBox["x", "2"]}]}], ")"}], 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"ArcTan", "[", 
          RowBox[{"a", " ", "x"}], "]"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"a", " ", "c", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}], 
    RowBox[{"n", "+", "1"}]], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{"x", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "m"], " ", 
     SuperscriptBox[
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493058932894973*^9, 3.4930589343449745`*^9}, {
   3.4930590036150713`*^9, 3.493059030475109*^9}, {3.493059071585167*^9, 
   3.4930590795551777`*^9}, {3.4930628403524446`*^9, 3.49306285140246*^9}, {
   3.4932501056192265`*^9, 3.4932501067580285`*^9}, {3.493250146257298*^9, 
   3.493250186942169*^9}, {3.493256078498707*^9, 3.4932560906487236`*^9}, {
   3.4932568685898128`*^9, 3.4932568826798325`*^9}, {3.4933216732775507`*^9, 
   3.4933216957475824`*^9}, {3.4933217278376274`*^9, 3.493321760587673*^9}, 
   3.493321813507747*^9, 3.4933218644878187`*^9, {3.493321906837878*^9, 
   3.493321919617896*^9}, {3.4933220427280684`*^9, 3.493322042928068*^9}, {
   3.4934927094121914`*^9, 3.4934927441222396`*^9}, 3.493492777272286*^9, 
   3.493493493413289*^9, 3.4934935635433865`*^9, {3.4934984296601996`*^9, 
   3.4934984470202236`*^9}, {3.4934985399803543`*^9, 3.493498542300357*^9}, {
   3.4935897542938457`*^9, 3.4935897803338823`*^9}, {3.493590315164631*^9, 
   3.4935903239546432`*^9}, {3.494000872499612*^9, 3.4940008725036125`*^9}, {
   3.494027453089757*^9, 3.4940274536517897`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "c", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"2", "*", "a", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"x", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "m"}], "*", 
         RowBox[{
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.4929244782757444`*^9, 
   3.4929244935793715`*^9}, {3.493058294184078*^9, 3.493058321094116*^9}, {
   3.493058376614194*^9, 3.4930583929842167`*^9}, {3.4930584278042655`*^9, 
   3.4930584671043205`*^9}, {3.493058560144451*^9, 3.493058565344458*^9}, {
   3.493058608014518*^9, 3.493058608604519*^9}, {3.4930607207894773`*^9, 
   3.4930607253094835`*^9}, {3.49306140171043*^9, 3.4930614057704363`*^9}, {
   3.4930627552623253`*^9, 3.4930629395125833`*^9}, {3.493063111452824*^9, 
   3.4930631116128244`*^9}, {3.4930631532528825`*^9, 
   3.4930631552828856`*^9}, {3.4930631929229383`*^9, 
   3.4930631974729443`*^9}, {3.4934926396120934`*^9, 
   3.4934926491221066`*^9}, {3.4934935949134307`*^9, 
   3.4934937034035826`*^9}, {3.4934984698502555`*^9, 3.493498508170309*^9}, 
   3.4934985697303953`*^9, {3.4934986248104725`*^9, 3.493498645260501*^9}, {
   3.4934987095205913`*^9, 3.4934987697006755`*^9}, {3.4935001781326475`*^9, 
   3.493500210632693*^9}, {3.493500590983225*^9, 3.4935005923432274`*^9}, {
   3.4935009097536716`*^9, 3.4935009104136724`*^9}, {3.4935015174045224`*^9, 
   3.4935015211545277`*^9}, {3.4935022843455963`*^9, 3.493502302285621*^9}, {
   3.493502998526596*^9, 3.493502999946598*^9}, {3.493515736345019*^9, 
   3.4935157392850227`*^9}, {3.4935809012014513`*^9, 
   3.4935809031414537`*^9}, {3.4940008725136127`*^9, 3.4940008725176134`*^9}, 
   3.494021921778384*^9, {3.494027462266282*^9, 3.4940274625572987`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"]}], "=", 
   RowBox[{
    FractionBox["1", "a"], " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", 
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "]"}], 
     RowBox[{"2", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]], " ", 
    SuperscriptBox[
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{
     SubscriptBox["\[PartialD]", "x"], 
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664448654022*^9, 3.479664485386842*^9, {3.4796905699999485`*^9, 
   3.4796905930330687`*^9}, {3.493066205237155*^9, 3.493066233807195*^9}, {
   3.493067002288271*^9, 3.493067007218278*^9}, {3.4930671665685015`*^9, 
   3.4930671719285088`*^9}, {3.49357941453937*^9, 3.4935794178593745`*^9}, {
   3.4935794530694237`*^9, 3.4935794623694367`*^9}, {3.493579591189617*^9, 
   3.4935795950296226`*^9}, {3.4935796369196815`*^9, 3.493579680229742*^9}, {
   3.4935798057299175`*^9, 3.493579823249942*^9}, {3.493580013000208*^9, 
   3.4935800183302155`*^9}, {3.4940008725436144`*^9, 
   3.4940008725506153`*^9}, {3.4940009604166403`*^9, 
   3.4940009604166403`*^9}, {3.4940275109330654`*^9, 3.4940275114480953`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"d", "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", "m"}]}], ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "\[Or]", " ", 
      RowBox[{"n", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}], ")"}], " ",
     "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[Or]", 
      " ", 
      RowBox[{"c", ">", "0"}]}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055117607107`*^9, {3.4930655124161854`*^9, 3.4930655280062075`*^9}, {
   3.493066033556915*^9, 3.49306607975698*^9}, {3.4930669874082503`*^9, 
   3.4930669888982525`*^9}, {3.4932562746689816`*^9, 
   3.4932562746689816`*^9}, {3.493256683249553*^9, 3.4932567141395965`*^9}, 
   3.4935791292589703`*^9, 3.4935800548602667`*^9, {3.4935803350706587`*^9, 
   3.4935803371806617`*^9}, {3.493580465490841*^9, 3.4935804699908476`*^9}, {
   3.493580624611064*^9, 3.4935806402710857`*^9}, 3.493582183493246*^9, 
   3.49358221460329*^9, {3.493582721734*^9, 3.4935827257140055`*^9}, {
   3.4940220978504553`*^9, 3.4940220998345685`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "m"], " ", 
   SuperscriptBox[
    RowBox[{"ArcTan", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SuperscriptBox["c", "m"], "a"]}]}], " ", 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox["x", "n"], 
       SuperscriptBox[
        RowBox[{"Sec", "[", "x", "]"}], 
        RowBox[{"2", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579733429823`*^9, 3.4796580025249443`*^9}, {
   3.4796580760106115`*^9, 3.479658076961979*^9}, {3.479658170546547*^9, 
   3.47965817467248*^9}, {3.4796583692823153`*^9, 3.4796583839634256`*^9}, {
   3.4796584934408464`*^9, 3.479658497486664*^9}, {3.479661194084181*^9, 
   3.47966122030188*^9}, 3.479661392649704*^9, {3.4796614543984947`*^9, 
   3.4796614565015182`*^9}, {3.4796616029320755`*^9, 3.47966160861024*^9}, 
   3.479661772305622*^9, 3.47966185512471*^9, {3.4796624643307056`*^9, 
   3.4796624837586412`*^9}, {3.4796684805015345`*^9, 3.479668482213997*^9}, {
   3.47968672053469*^9, 3.479686720544704*^9}, {3.4796906638949633`*^9, 
   3.479690664315568*^9}, {3.479690714507741*^9, 3.4796907460130434`*^9}, 
   3.480705514654872*^9, {3.4930650337755156`*^9, 3.493065049545537*^9}, {
   3.4930657623365355`*^9, 3.4930657881965714`*^9}, {3.4930663212373176`*^9, 
   3.493066363577377*^9}, {3.493066963568217*^9, 3.493066975738234*^9}, 
   3.4932537469796257`*^9, 3.493256113988756*^9, {3.4932567461396413`*^9, 
   3.4932567491696453`*^9}, 3.493579009488803*^9, {3.4935790490588584`*^9, 
   3.4935790516388617`*^9}, {3.4935801113403454`*^9, 3.49358011445035*^9}, {
   3.4940008725696163`*^9, 3.494000872570616*^9}, 3.4940009614627004`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"c", "^", "m"}], "/", "a"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", "n"}], "*", 
          RowBox[{
           RowBox[{"Sec", "[", "x", "]"}], "^", 
           RowBox[{"(", 
            RowBox[{"2", "*", 
             RowBox[{"(", 
              RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], ",", "x"}], "]"}], 
       ",", "x", ",", 
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", "*", "x"}], "]"}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "||", " ", 
      RowBox[{"Not", "[", 
       RowBox[{"IntegerQ", "[", "n", "]"}], "]"}]}], ")"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "m", "]"}], " ", "||", " ", 
      RowBox[{"PositiveQ", "[", "c", "]"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.493065103075612*^9, 3.493065290765875*^9}, {
   3.493065714046468*^9, 3.493065729586489*^9}, {3.4930658063465967`*^9, 
   3.4930658068865976`*^9}, {3.493067047288334*^9, 3.493067049548337*^9}, {
   3.4930670867783895`*^9, 3.493067112388425*^9}, {3.4930674070088377`*^9, 
   3.4930674148588486`*^9}, {3.4930676846992264`*^9, 
   3.4930676962292423`*^9}, {3.4935801866504507`*^9, 3.493580239560525*^9}, {
   3.493580375290715*^9, 3.4935803824807253`*^9}, {3.493580473120852*^9, 
   3.4935804871108713`*^9}, {3.493580711731186*^9, 3.493580717491194*^9}, {
   3.4935808945314417`*^9, 3.4935808963414445`*^9}, {3.493582837424162*^9, 
   3.4935828401941657`*^9}, {3.494000872581617*^9, 3.4940008725836167`*^9}, 
   3.4940009627607746`*^9, 3.494021921807386*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    SuperscriptBox["a", "2"], " ", "c"}]}]]],
 ", ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["c", 
        RowBox[{"m", "-", 
         FractionBox["1", "2"]}]], 
       SqrtBox[
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}]]}], 
      SqrtBox[
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["x", "2"]}]}]]], ",", "x"}], "]"}], "=", "0"}]],
  CellChangeTimes->{{3.4937498379858303`*^9, 3.4937499017587423`*^9}, {
   3.4937499674816575`*^9, 3.493750029569767*^9}}]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664448654022*^9, 3.479664485386842*^9, {3.4796905699999485`*^9, 
   3.4796905930330687`*^9}, {3.493066205237155*^9, 3.493066233807195*^9}, {
   3.493067002288271*^9, 3.493067007218278*^9}, {3.4930671665685015`*^9, 
   3.4930671719285088`*^9}, {3.49357941453937*^9, 3.4935794178593745`*^9}, {
   3.4935794530694237`*^9, 3.4935794623694367`*^9}, {3.493579591189617*^9, 
   3.4935795950296226`*^9}, {3.4935796369196815`*^9, 3.493579680229742*^9}, {
   3.4935798057299175`*^9, 3.493579823249942*^9}, {3.493580013000208*^9, 
   3.4935800183302155`*^9}, {3.4937499298855915`*^9, 
   3.4937499486524243`*^9}, {3.4937500390389833`*^9, 
   3.4937500431885905`*^9}, {3.494022102011693*^9, 3.4940221040618105`*^9}, {
   3.494027568786375*^9, 3.494027569121394*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"d", "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", "m"}]}], ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "\[Or]", " ", 
      RowBox[{"n", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}], ")"}], " ",
     "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ",
     "\[And]", " ", 
    RowBox[{"\[Not]", 
     RowBox[{"(", 
      RowBox[{"c", ">", "0"}], ")"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055117607107`*^9, {3.4930655124161854`*^9, 3.4930655280062075`*^9}, {
   3.493066033556915*^9, 3.49306607975698*^9}, {3.4930680892297926`*^9, 
   3.4930681267098455`*^9}, {3.4930801578959255`*^9, 
   3.4930801961259785`*^9}, {3.493256255798955*^9, 3.4932562676389713`*^9}, {
   3.493582187523252*^9, 3.493582201173271*^9}, {3.4935826492138987`*^9, 
   3.4935826803839417`*^9}, {3.4935827341640177`*^9, 
   3.4935827808740826`*^9}, {3.4935831190745564`*^9, 3.49358317149463*^9}, {
   3.4940221136913614`*^9, 3.4940221203557425`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "m"], 
   SuperscriptBox[
    RowBox[{"ArcTan", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SuperscriptBox["c", 
        RowBox[{"m", "-", 
         FractionBox["1", "2"]}]], 
       SqrtBox[
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}]]}], 
      SqrtBox[
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["x", "2"]}]}]]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "m"], 
     SuperscriptBox[
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579733429823`*^9, 3.4796580025249443`*^9}, {
   3.4796580760106115`*^9, 3.479658076961979*^9}, {3.479658170546547*^9, 
   3.47965817467248*^9}, {3.4796583692823153`*^9, 3.4796583839634256`*^9}, {
   3.4796584934408464`*^9, 3.479658497486664*^9}, {3.479661194084181*^9, 
   3.47966122030188*^9}, 3.479661392649704*^9, {3.4796614543984947`*^9, 
   3.4796614565015182`*^9}, {3.4796616029320755`*^9, 3.47966160861024*^9}, 
   3.479661772305622*^9, 3.47966185512471*^9, {3.4796624643307056`*^9, 
   3.4796624837586412`*^9}, {3.4796684805015345`*^9, 3.479668482213997*^9}, {
   3.47968672053469*^9, 3.479686720544704*^9}, {3.4796906638949633`*^9, 
   3.479690664315568*^9}, {3.479690714507741*^9, 3.4796907460130434`*^9}, 
   3.480705514654872*^9, {3.4930650337755156`*^9, 3.493065049545537*^9}, {
   3.4930657623365355`*^9, 3.4930657881965714`*^9}, {3.493077421798092*^9, 
   3.4930774294181027`*^9}, {3.49307964724521*^9, 3.493079659035227*^9}, {
   3.4930797467153497`*^9, 3.493079763295373*^9}, {3.493079973595667*^9, 
   3.4930800012057056`*^9}, {3.4932537598652487`*^9, 3.4932537660740595`*^9}, 
   3.493256110328751*^9, {3.4935825897438154`*^9, 3.4935826029438334`*^9}, {
   3.4940008725976176`*^9, 3.494000872599618*^9}, {3.494027611105795*^9, 
   3.494027622568451*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"c", "^", 
     RowBox[{"(", 
      RowBox[{"m", "-", 
       RowBox[{"1", "/", "2"}]}], ")"}]}], "*", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", 
        RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "+", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "*", 
        RowBox[{"x", "^", "2"}]}]}], "]"}]}], "*", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "*", 
           RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "m"}], "*", 
       RowBox[{
        RowBox[{"ArcTan", "[", 
         RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "||", " ", 
      RowBox[{"Not", "[", 
       RowBox[{"IntegerQ", "[", "n", "]"}], "]"}]}], ")"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"m", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"PositiveQ", "[", "c", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.493065103075612*^9, 3.493065290765875*^9}, {
   3.493065714046468*^9, 3.493065729586489*^9}, {3.4930658063465967`*^9, 
   3.4930658068865976`*^9}, {3.493067423888861*^9, 3.4930674284788675`*^9}, 
   3.493068077149776*^9, {3.493080071975805*^9, 3.493080131335888*^9}, {
   3.4930802396760397`*^9, 3.4930802468960495`*^9}, {3.4932538772710547`*^9, 
   3.4932538805314603`*^9}, {3.4935808882514334`*^9, 3.493580890111436*^9}, {
   3.493582859644193*^9, 3.493582867944205*^9}, {3.4935830452044525`*^9, 
   3.4935830783744993`*^9}, {3.4935832217946997`*^9, 3.493583225184705*^9}, {
   3.494000872609618*^9, 3.4940008726116185`*^9}, 3.4940219218383875`*^9, {
   3.4940276302598906`*^9, 3.49402763374209*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
   SuperscriptBox[
    RowBox[{"ArcTan", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.479616001935333*^9, 3.4796867203444157`*^9, {3.479687071148848*^9, 
   3.479687071399208*^9}, 3.4928222618129525`*^9, 3.4928258304168224`*^9, {
   3.4929226804037867`*^9, 3.4929226942254105`*^9}, {3.492979990624321*^9, 
   3.4929799910143223`*^9}, {3.493060035696517*^9, 3.4930600483865347`*^9}, 
   3.493253406025427*^9, {3.493354142567293*^9, 3.493354158680215*^9}, 
   3.494000872625619*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.493099207935931*^9, 3.4930992149659414`*^9}, {
  3.4935738213175373`*^9, 3.493573838477561*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", 
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
    RowBox[{"p", "\[NotEqual]", 
     RowBox[{"-", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4932562829889927`*^9, 3.4932562829889927`*^9}, {3.4933543405726185`*^9, 
   3.493354354743429*^9}, {3.493354669307421*^9, 3.493354670200472*^9}, {
   3.4933549046238804`*^9, 3.493354922498903*^9}, {3.493415722490226*^9, 
   3.493415730810238*^9}, {3.4935738213175373`*^9, 3.493573838477561*^9}, {
   3.4935823105834246`*^9, 3.4935823105834246`*^9}, {3.4935823762035165`*^9, 
   3.4935823762035165`*^9}, {3.49402212346492*^9, 3.4940221262390785`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", 
            SuperscriptBox["x", "2"]}]}], ")"}], 
         RowBox[{"p", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"ArcTan", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
       RowBox[{"2", " ", "d", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox["n", 
    RowBox[{"2", " ", "a", 
     RowBox[{"(", 
      RowBox[{"p", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
     SuperscriptBox[
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.49332119396688*^9, {3.4933214175471926`*^9, 
   3.4933214366372194`*^9}, {3.4933214780072775`*^9, 
   3.4933214840172863`*^9}, {3.493354278495068*^9, 3.493354294476982*^9}, {
   3.4933546277870464`*^9, 3.4933546449460278`*^9}, {3.493354790721366*^9, 
   3.4933547931895065`*^9}, {3.4933563805813007`*^9, 3.493356384480523*^9}, {
   3.4935738213175373`*^9, 3.493573838477561*^9}, {3.49400087263862*^9, 
   3.49400087264162*^9}, {3.4940277807875004`*^9, 3.494027781184523*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "a", "*", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"n", ",", "p"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"p", "\[NotEqual]", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.4929244782757444`*^9, 
   3.4929244935793715`*^9}, {3.4933546901676145`*^9, 3.493354852357891*^9}, {
   3.493354994220005*^9, 3.4933549944920206`*^9}, 3.493356145801872*^9, 
   3.4933562876739864`*^9, {3.493356396607217*^9, 3.493356401341488*^9}, {
   3.493415708300206*^9, 3.493415712490212*^9}, {3.493580788181293*^9, 
   3.493580790631296*^9}, {3.494000872651621*^9, 3.494000872655621*^9}, 
   3.4940219218733897`*^9, {3.494027787020857*^9, 3.494027787336875*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", 
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalQ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4932562829889927`*^9, 3.4932562829889927`*^9}, {3.4933543405726185`*^9, 
   3.493354354743429*^9}, {3.493354669307421*^9, 3.493354670200472*^9}, {
   3.4933549046238804`*^9, 3.493354922498903*^9}, {3.493415722490226*^9, 
   3.493415730810238*^9}, {3.4935159619553347`*^9, 3.49351600154539*^9}, {
   3.493582316753433*^9, 3.493582316753433*^9}, {3.493582369383507*^9, 
   3.493582369383507*^9}, {3.4949679439187803`*^9, 3.494967944658781*^9}, {
   3.4949694620709057`*^9, 3.4949694620709057`*^9}, 3.495158646225856*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"x", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], "p"]}], 
     SuperscriptBox[
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "2"]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"x", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", 
             SuperscriptBox["x", "2"]}]}], ")"}], 
          RowBox[{"p", "+", "1"}]]}], 
        RowBox[{"a", " ", "c", " ", 
         RowBox[{"ArcTan", "[", 
          RowBox[{"a", " ", "x"}], "]"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", "a"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "3"}], ")"}], " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", 
           SuperscriptBox["x", "2"]}]}], ")"}], "p"]}], 
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.49332119396688*^9, {3.4933214175471926`*^9, 
   3.4933214366372194`*^9}, {3.4933214780072775`*^9, 
   3.4933214840172863`*^9}, {3.493354278495068*^9, 3.493354294476982*^9}, {
   3.4933546277870464`*^9, 3.4933546449460278`*^9}, {3.493354790721366*^9, 
   3.4933547931895065`*^9}, {3.4933563805813007`*^9, 3.493356384480523*^9}, {
   3.4935159055452557`*^9, 3.4935159469853134`*^9}, {3.4935898317039537`*^9, 
   3.493589853353984*^9}, {3.4935903822847247`*^9, 3.4935904229047813`*^9}, {
   3.493590752655243*^9, 3.493590763525258*^9}, {3.4935908715154095`*^9, 
   3.4935908771554174`*^9}, {3.4935909258054857`*^9, 3.493590926785487*^9}, {
   3.493591021125619*^9, 3.493591039645645*^9}, {3.493591125495765*^9, 
   3.493591126025766*^9}, {3.4935912357559195`*^9, 3.49359123615592*^9}, {
   3.494967953858794*^9, 3.4949680122488756`*^9}, {3.4949693812107925`*^9, 
   3.494969427310857*^9}, {3.4951584608195295`*^9, 3.4951584619271317`*^9}, {
   3.4951588232549667`*^9, 3.495158823582567*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_."}], "/", 
      RowBox[{
       RowBox[{"ArcTan", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "^", "2"}]}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "x"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", 
          RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "c", "*", 
        RowBox[{"ArcTan", "[", 
         RowBox[{"a", "*", "x"}], "]"}]}], ")"}]}]}], " ", "+", 
    "\[IndentingNewLine]", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "a"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", "*", "p"}], "+", "3"}], ")"}], "*", 
            RowBox[{"a", "^", "2"}], "*", 
            RowBox[{"x", "^", "2"}]}]}], ")"}], "*", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", 
              RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], "/", 
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", "*", "x"}], "]"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.4929244782757444`*^9, 
   3.4929244935793715`*^9}, {3.4933546901676145`*^9, 3.493354852357891*^9}, {
   3.493354994220005*^9, 3.4933549944920206`*^9}, 3.493356145801872*^9, 
   3.4933562876739864`*^9, {3.493356396607217*^9, 3.493356401341488*^9}, {
   3.493415708300206*^9, 3.493415712490212*^9}, {3.4935159552553253`*^9, 
   3.493515974425352*^9}, {3.493516011355404*^9, 3.4935160426754475`*^9}, {
   3.493516152975602*^9, 3.4935161582156096`*^9}, {3.4935807957313037`*^9, 
   3.4935807976813064`*^9}, {3.494969533241005*^9, 3.4949695405110154`*^9}, {
   3.494969605621106*^9, 3.494969728921279*^9}, 3.4949697639513283`*^9, {
   3.4951584623951325`*^9, 3.495158463253134*^9}, 3.4951586298770266`*^9, {
   3.4951588411013975`*^9, 3.4951588414133987`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "2"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4932562829889927`*^9, 3.4932562829889927`*^9}, {3.4933543405726185`*^9, 
   3.493354354743429*^9}, {3.493354669307421*^9, 3.493354670200472*^9}, {
   3.4933549046238804`*^9, 3.493354922498903*^9}, {3.493415722490226*^9, 
   3.493415730810238*^9}, {3.4935159619553347`*^9, 3.49351600154539*^9}, {
   3.493582316753433*^9, 3.493582316753433*^9}, {3.493582369383507*^9, 
   3.493582369383507*^9}, {3.494022136427662*^9, 3.49402213937683*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"x", " ", 
      SuperscriptBox[
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "2"]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                                              \
     ", "\[IndentingNewLine]", "                ", 
      FractionBox[
       RowBox[{"x", " ", 
        SuperscriptBox[
         RowBox[{"ArcTan", "[", 
          RowBox[{"a", " ", "x"}], "]"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"a", " ", "c", " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", 
           SuperscriptBox["x", "2"]}]}], ")"}]}]]}]}]}]}], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}], 
     RowBox[{"n", "+", "2"}]]}], 
   RowBox[{"d", " ", 
    RowBox[{"(", 
     RowBox[{"n", "+", "1"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"n", "+", "2"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}]}]], "-", 
  RowBox[{
   FractionBox["4", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"n", "+", "2"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"x", " ", 
       SuperscriptBox[
        RowBox[{"ArcTan", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "+", "2"}]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], "2"]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.49332119396688*^9, {3.4933214175471926`*^9, 
   3.4933214366372194`*^9}, {3.4933214780072775`*^9, 
   3.4933214840172863`*^9}, {3.493354278495068*^9, 3.493354294476982*^9}, {
   3.4933546277870464`*^9, 3.4933546449460278`*^9}, {3.493354790721366*^9, 
   3.4933547931895065`*^9}, {3.4933563805813007`*^9, 3.493356384480523*^9}, {
   3.4935159055452557`*^9, 3.4935159469853134`*^9}, {3.4935898317039537`*^9, 
   3.493589853353984*^9}, {3.4935903822847247`*^9, 3.4935904229047813`*^9}, {
   3.493590752655243*^9, 3.493590763525258*^9}, {3.4935908715154095`*^9, 
   3.4935908771554174`*^9}, {3.4935909258054857`*^9, 3.493590926785487*^9}, {
   3.493591021125619*^9, 3.493591039645645*^9}, {3.493591125495765*^9, 
   3.493591126025766*^9}, {3.4935912357559195`*^9, 3.49359123615592*^9}, {
   3.4940008727176247`*^9, 3.494000872722625*^9}, {3.4940282162174053`*^9, 
   3.494028224476878*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTan", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}], "/", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "2"}]}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "c", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", 
           RowBox[{"x", "^", "2"}]}]}], ")"}]}], ")"}]}]}], " ", "-", 
    "\[IndentingNewLine]", "  ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "*", 
        RowBox[{"x", "^", "2"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", 
           RowBox[{"x", "^", "2"}]}]}], ")"}]}], ")"}]}]}], " ", "-", 
    "\[IndentingNewLine]", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"4", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"x", "*", 
         RowBox[{
          RowBox[{
           RowBox[{"ArcTan", "[", 
            RowBox[{"a", "*", "x"}], "]"}], "^", 
           RowBox[{"(", 
            RowBox[{"n", "+", "2"}], ")"}]}], "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", 
              RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "2"}]}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.4929244782757444`*^9, 
   3.4929244935793715`*^9}, {3.4933546901676145`*^9, 3.493354852357891*^9}, {
   3.493354994220005*^9, 3.4933549944920206`*^9}, 3.493356145801872*^9, 
   3.4933562876739864`*^9, {3.493356396607217*^9, 3.493356401341488*^9}, {
   3.493415708300206*^9, 3.493415712490212*^9}, {3.4935159552553253`*^9, 
   3.493515974425352*^9}, {3.493516011355404*^9, 3.4935160426754475`*^9}, {
   3.493516152975602*^9, 3.4935161582156096`*^9}, {3.4935807957313037`*^9, 
   3.4935807976813064`*^9}, {3.4940008727336254`*^9, 3.494000872740626*^9}, 
   3.494021921964395*^9, {3.494028236381559*^9, 3.494028244686034*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{{3.493099207935931*^9, 3.4930992149659414`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"d", "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", "m"}]}], ",", 
   "n", ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"2", "p"}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
     "\[And]", " ", 
     RowBox[{"m", "<", 
      RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
     RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
     RowBox[{"m", "+", 
      RowBox[{"2", "p"}], "+", "3"}]}], "=", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4932562829889927`*^9, 3.4932562829889927`*^9}, {3.4933543405726185`*^9, 
   3.493354354743429*^9}, {3.493354669307421*^9, 3.493354670200472*^9}, {
   3.4933549046238804`*^9, 3.493354922498903*^9}, {3.493356182221955*^9, 
   3.4933562049342537`*^9}, {3.4933938872666245`*^9, 
   3.4933939122734685`*^9}, {3.493394021941661*^9, 3.493394030412476*^9}, {
   3.493395008824994*^9, 3.493395011601799*^9}, {3.4933950592130823`*^9, 
   3.4933950626138887`*^9}, {3.4933958282120333`*^9, 
   3.4933958335004425`*^9}, {3.4933958648876977`*^9, 3.493395891672944*^9}, {
   3.493406394401163*^9, 3.4934063956011643`*^9}, {3.493414300772232*^9, 
   3.4934143075622416`*^9}, {3.4935055200960126`*^9, 
   3.4935055200960126`*^9}, {3.4935057649384427`*^9, 
   3.4935057649384427`*^9}, {3.493505853515398*^9, 3.493505853515398*^9}, {
   3.493582326893447*^9, 3.4935823540334854`*^9}, {3.4940221411059294`*^9, 
   3.4940221431790476`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                             ", 
      "\[IndentingNewLine]", "                                      ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", 
            SuperscriptBox["x", "2"]}]}], ")"}], 
         RowBox[{"p", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"ArcTan", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
       RowBox[{"c", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", "n"}], 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
     SuperscriptBox[
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.49332119396688*^9, {3.4933214175471926`*^9, 
   3.4933214366372194`*^9}, {3.4933214780072775`*^9, 
   3.4933214840172863`*^9}, {3.493354278495068*^9, 3.493354294476982*^9}, {
   3.4933546277870464`*^9, 3.4933546449460278`*^9}, {3.493354790721366*^9, 
   3.4933547931895065`*^9}, {3.4933560394157867`*^9, 
   3.4933561011583185`*^9}, {3.4933561738414755`*^9, 
   3.4933561751395497`*^9}, {3.4933562501758413`*^9, 
   3.4933562530870085`*^9}, {3.493356410270999*^9, 3.4933564233687477`*^9}, {
   3.493394874820759*^9, 3.4933949021052065`*^9}, {3.493395751163498*^9, 
   3.4933957978543797`*^9}, {3.493406138010804*^9, 3.4934061641108403`*^9}, {
   3.4934062369309425`*^9, 3.4934062462209554`*^9}, {3.49340655671139*^9, 
   3.4934065590813932`*^9}, {3.4934141473620167`*^9, 
   3.4934141575120316`*^9}, {3.493589928364089*^9, 3.4935899505341206`*^9}, {
   3.4940008727556267`*^9, 3.494000872758627*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"n", "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n", ",", 
      RowBox[{"2", "*", "p"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"2", "*", "p"}], "+", "3"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.4929244782757444`*^9, 
   3.4929244935793715`*^9}, {3.4933546901676145`*^9, 3.493354852357891*^9}, {
   3.493354994220005*^9, 3.4933549944920206`*^9}, {3.4933561282218666`*^9, 
   3.493356154267356*^9}, {3.4933562088824797`*^9, 3.493356243066435*^9}, {
   3.4933562812016163`*^9, 3.4933563433891735`*^9}, {3.4933564509923277`*^9, 
   3.4933564967799463`*^9}, {3.4933565518720975`*^9, 3.493356556926387*^9}, {
   3.493356683297615*^9, 3.493356683651635*^9}, {3.493393781030438*^9, 
   3.4933937826528406`*^9}, {3.49339383350893*^9, 3.4933938341173315`*^9}, {
   3.4933938692017927`*^9, 3.4933938715417967`*^9}, {3.4933939716159725`*^9, 
   3.4933939737687764`*^9}, {3.4933951036263604`*^9, 
   3.4933952261489754`*^9}, {3.4933952605626364`*^9, 3.493395282199874*^9}, {
   3.4933959219993978`*^9, 3.493396038968403*^9}, 3.4933965390584817`*^9, {
   3.4934062197609186`*^9, 3.49340622120092*^9}, {3.4934064692212677`*^9, 
   3.49340657783142*^9}, {3.49341417825206*^9, 3.4934141863320713`*^9}, {
   3.4934142170121145`*^9, 3.4934142188021173`*^9}, {3.493505515821605*^9, 
   3.493505516788807*^9}, 3.493505760539235*^9, {3.4935058497401915`*^9, 
   3.4935058506137934`*^9}, {3.493580815391331*^9, 3.4935808179213347`*^9}, {
   3.4940008727696276`*^9, 3.4940008727736273`*^9}, 3.494021921998397*^9, 
   3.517188547680131*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{{3.493099207935931*^9, 3.4930992149659414`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"d", "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", "m"}]}], ",", 
   "n", ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"2", "p"}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
     "\[And]", " ", 
     RowBox[{"n", "<", 
      RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
     RowBox[{"m", "+", 
      RowBox[{"2", "p"}], "+", "2"}]}], "=", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4932562829889927`*^9, 3.4932562829889927`*^9}, {3.4933543405726185`*^9, 
   3.493354354743429*^9}, {3.493354669307421*^9, 3.493354670200472*^9}, {
   3.4933549046238804`*^9, 3.493354922498903*^9}, {3.493356182221955*^9, 
   3.4933562049342537`*^9}, {3.4933938872666245`*^9, 
   3.4933939122734685`*^9}, {3.493394021941661*^9, 3.493394030412476*^9}, {
   3.493395008824994*^9, 3.493395011601799*^9}, {3.4933950592130823`*^9, 
   3.4933950626138887`*^9}, {3.493444320208996*^9, 3.493444321758998*^9}, {
   3.4934444078191185`*^9, 3.4934444112891235`*^9}, {3.493444627119426*^9, 
   3.493444628299427*^9}, {3.4935055051355867`*^9, 3.4935055051355867`*^9}, {
   3.4935057857020793`*^9, 3.4935057857020793`*^9}, {3.493505835918567*^9, 
   3.493505835918567*^9}, {3.493582332753455*^9, 3.4935823464234743`*^9}, {
   3.4940221447601385`*^9, 3.4940221466862483`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", " ", "\[LongRightArrow]", 
      "                                                                       \
                                                              ", 
      "\[IndentingNewLine]", "                                   ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", "m"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", 
            SuperscriptBox["x", "2"]}]}], ")"}], 
         RowBox[{"p", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"ArcTan", "[", 
          RowBox[{"a", " ", "x"}], "]"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"a", " ", "c", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox["m", 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
     SuperscriptBox[
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.49332119396688*^9, {3.4933214175471926`*^9, 
   3.4933214366372194`*^9}, {3.4933214780072775`*^9, 
   3.4933214840172863`*^9}, {3.493354278495068*^9, 3.493354294476982*^9}, {
   3.4933546277870464`*^9, 3.4933546449460278`*^9}, {3.493354790721366*^9, 
   3.4933547931895065`*^9}, {3.4933560394157867`*^9, 
   3.4933561011583185`*^9}, {3.4933561738414755`*^9, 
   3.4933561751395497`*^9}, {3.4933562501758413`*^9, 
   3.4933562530870085`*^9}, {3.493356410270999*^9, 3.4933564233687477`*^9}, {
   3.493394874820759*^9, 3.4933949021052065`*^9}, {3.493444143068748*^9, 
   3.493444163808777*^9}, {3.4934446369894395`*^9, 3.493444646849453*^9}, {
   3.49358997156415*^9, 3.493589988114173*^9}, {3.493590469004846*^9, 
   3.493590474204853*^9}, {3.4940008727886286`*^9, 3.494000872791629*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "m"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "c", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"m", "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n", ",", 
      RowBox[{"2", "*", "p"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"2", "*", "p"}], "+", "2"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.4929244782757444`*^9, 
   3.4929244935793715`*^9}, {3.4933546901676145`*^9, 3.493354852357891*^9}, {
   3.493354994220005*^9, 3.4933549944920206`*^9}, {3.4933561282218666`*^9, 
   3.493356154267356*^9}, {3.4933562088824797`*^9, 3.493356243066435*^9}, {
   3.4933562812016163`*^9, 3.4933563433891735`*^9}, {3.4933564509923277`*^9, 
   3.4933564967799463`*^9}, {3.4933565518720975`*^9, 3.493356556926387*^9}, {
   3.493356683297615*^9, 3.493356683651635*^9}, {3.493393781030438*^9, 
   3.4933937826528406`*^9}, {3.49339383350893*^9, 3.4933938341173315`*^9}, {
   3.4933938692017927`*^9, 3.4933938715417967`*^9}, {3.4933939716159725`*^9, 
   3.4933939737687764`*^9}, {3.4933951036263604`*^9, 
   3.4933952261489754`*^9}, {3.4933952605626364`*^9, 3.493395282199874*^9}, 
   3.4933965801177535`*^9, {3.4933967072423773`*^9, 3.4933967295972166`*^9}, {
   3.4933967622168736`*^9, 3.493396766506881*^9}, {3.4934444505191784`*^9, 
   3.4934444533991823`*^9}, {3.4934444856092277`*^9, 3.493444554759324*^9}, {
   3.493444656619467*^9, 3.493444664049477*^9}, {3.493505499691177*^9, 
   3.493505500330778*^9}, 3.4935057823168736`*^9, {3.4935058303025575`*^9, 
   3.4935058307705584`*^9}, {3.493580826771347*^9, 3.49358082920135*^9}, {
   3.494000872801629*^9, 3.4940008728066297`*^9}, 3.4940219220283985`*^9, 
   3.517188547680131*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "2"], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], "=", 
   RowBox[{
    FractionBox["1", "d"], "-", 
    FractionBox["c", 
     RowBox[{"d", " ", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664431619528*^9, 3.4796644842351856`*^9, {3.4796867203243876`*^9, 
   3.4796867203243876`*^9}, {3.479686900964134*^9, 3.479686904699506*^9}, 
   3.49290371904314*^9, {3.49316782040429*^9, 3.4931678273342996`*^9}, {
   3.4931678584343433`*^9, 3.4931678962243958`*^9}, {3.4931679645244913`*^9, 
   3.493167967024495*^9}, {3.4931679986345396`*^9, 3.4931680026345453`*^9}, 
   3.493790063331503*^9, 3.4937901678516493`*^9, {3.4937902960118284`*^9, 
   3.4937902973518305`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"d", "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", "m"}]}], ",", 
   "n", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "p"}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
    "\[And]", " ", 
    RowBox[{"m", ">", "1"}], " ", "\[And]", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4932562829889927`*^9, 3.4932562829889927`*^9}, {3.4933543405726185`*^9, 
   3.493354354743429*^9}, {3.493354669307421*^9, 3.493354670200472*^9}, {
   3.4933549046238804`*^9, 3.493354922498903*^9}, {3.493356182221955*^9, 
   3.4933562049342537`*^9}, {3.4933938872666245`*^9, 
   3.4933939122734685`*^9}, {3.493394021941661*^9, 3.493394030412476*^9}, {
   3.493582323023442*^9, 3.493582323023442*^9}, {3.4935823597934933`*^9, 
   3.4935823597934933`*^9}, {3.493857373585099*^9, 3.493857373585099*^9}, {
   3.4938623384460526`*^9, 3.4938623392360535`*^9}, {3.49386578680088*^9, 
   3.49386578680088*^9}, {3.493866462471826*^9, 3.493866466731832*^9}, {
   3.4940221484583497`*^9, 3.494022150644475*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "d"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox["x", 
       RowBox[{"m", "-", "2"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], 
       RowBox[{"p", "+", "1"}]], " ", 
      SuperscriptBox[
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["c", "d"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
     SuperscriptBox[
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.49332119396688*^9, {3.4933214175471926`*^9, 
   3.4933214366372194`*^9}, {3.4933214780072775`*^9, 
   3.4933214840172863`*^9}, {3.493354278495068*^9, 3.493354294476982*^9}, {
   3.4933546277870464`*^9, 3.4933546449460278`*^9}, {3.493354790721366*^9, 
   3.4933547931895065`*^9}, {3.4933560394157867`*^9, 
   3.4933561011583185`*^9}, {3.4933561738414755`*^9, 
   3.4933561751395497`*^9}, {3.4933562501758413`*^9, 
   3.4933562530870085`*^9}, {3.493356410270999*^9, 3.4933564233687477`*^9}, 
   3.49385258804259*^9, {3.493852620612636*^9, 3.4938526898507333`*^9}, {
   3.4940008728236303`*^9, 3.4940008728266306`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_"}], "*", 
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "d"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"c", "/", "d"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n", ",", 
      RowBox[{"2", "*", "p"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.4929244782757444`*^9, 
   3.4929244935793715`*^9}, {3.4933546901676145`*^9, 3.493354852357891*^9}, {
   3.493354994220005*^9, 3.4933549944920206`*^9}, {3.4933561282218666`*^9, 
   3.493356154267356*^9}, {3.4933562088824797`*^9, 3.493356243066435*^9}, {
   3.4933562812016163`*^9, 3.4933563433891735`*^9}, {3.4933564509923277`*^9, 
   3.4933564967799463`*^9}, {3.4933565518720975`*^9, 3.493356556926387*^9}, {
   3.493356683297615*^9, 3.493356683651635*^9}, {3.493393781030438*^9, 
   3.4933937826528406`*^9}, {3.49339383350893*^9, 3.4933938341173315`*^9}, {
   3.4933938692017927`*^9, 3.4933938715417967`*^9}, {3.4933939716159725`*^9, 
   3.4933939737687764`*^9}, 3.493396573690542*^9, {3.4935808076513205`*^9, 
   3.493580810011324*^9}, {3.4938563531736703`*^9, 3.493856396943732*^9}, 
   3.4938565202739043`*^9, {3.493857377865105*^9, 3.4938573787451067`*^9}, {
   3.493862320526027*^9, 3.493862321776029*^9}, {3.493865803070903*^9, 
   3.4938658047609053`*^9}, {3.493866443151799*^9, 3.4938664464618034`*^9}, {
   3.4940008728366313`*^9, 3.494000872841632*^9}, 3.4940219220574007`*^9, 
   3.5171885476957307`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], "=", 
   RowBox[{
    FractionBox["1", "c"], "-", 
    FractionBox[
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}], 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664431619528*^9, 3.4796644842351856`*^9, {3.4796867203243876`*^9, 
   3.4796867203243876`*^9}, {3.479686900964134*^9, 3.479686904699506*^9}, 
   3.49290371904314*^9, {3.49316782040429*^9, 3.4931678273342996`*^9}, {
   3.4931678584343433`*^9, 3.4931678962243958`*^9}, {3.4931679645244913`*^9, 
   3.493167967024495*^9}, {3.4931679986345396`*^9, 3.4931680026345453`*^9}, 
   3.493790063331503*^9, 3.4937901678516493`*^9, {3.4937902960118284`*^9, 
   3.4937902973518305`*^9}, {3.493857825015731*^9, 3.4938578494057655`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"d", "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", "m"}]}], ",", 
   "n", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "p"}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
    "\[And]", " ", 
    RowBox[{"m", "<", "0"}], " ", "\[And]", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4932562829889927`*^9, 3.4932562829889927`*^9}, {3.4933543405726185`*^9, 
   3.493354354743429*^9}, {3.493354669307421*^9, 3.493354670200472*^9}, {
   3.4933549046238804`*^9, 3.493354922498903*^9}, {3.493356182221955*^9, 
   3.4933562049342537`*^9}, {3.4933938872666245`*^9, 
   3.4933939122734685`*^9}, {3.493394021941661*^9, 3.493394030412476*^9}, {
   3.493582323023442*^9, 3.493582323023442*^9}, {3.4935823597934933`*^9, 
   3.4935823597934933`*^9}, {3.493857373585099*^9, 3.493857373585099*^9}, {
   3.4938574226851683`*^9, 3.4938574248351707`*^9}, {3.493861363812687*^9, 
   3.493861363812687*^9}, {3.493861896375434*^9, 3.4938618973254347`*^9}, {
   3.493862147205785*^9, 3.493862147205785*^9}, {3.493862334036046*^9, 
   3.4938623346860476`*^9}, {3.4938657907508855`*^9, 
   3.4938657907508855`*^9}, {3.493866473221841*^9, 3.493866473221841*^9}, {
   3.4940221525615845`*^9, 3.494022154445692*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "c"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox["x", "m"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], 
       RowBox[{"p", "+", "1"}]], " ", 
      SuperscriptBox[
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["d", "c"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
     SuperscriptBox[
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493166154681958*^9, 3.4931662030820255`*^9}, 
   3.4931666207326107`*^9, {3.4932522463481894`*^9, 3.49325228099585*^9}, {
   3.4933158052693357`*^9, 3.4933158328693743`*^9}, {3.4933190308138514`*^9, 
   3.493319134053996*^9}, {3.4933192438441496`*^9, 3.4933192445541506`*^9}, {
   3.4933193363142796`*^9, 3.4933193414042864`*^9}, {3.493412534339759*^9, 
   3.493412536469762*^9}, {3.493789994101406*^9, 3.493790017041438*^9}, {
   3.4937903432618947`*^9, 3.4937903499119043`*^9}, {3.493791019842842*^9, 
   3.4937910517128863`*^9}, 3.493791106992964*^9, 3.49379132604327*^9, {
   3.4937915274235525`*^9, 3.493791535933564*^9}, {3.4937916827437696`*^9, 
   3.4937916869037757`*^9}, {3.4938571031547203`*^9, 3.493857152184789*^9}, {
   3.4940008728586326`*^9, 3.494000872861633*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_"}], "*", 
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "c"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"d", "/", "c"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n", ",", 
      RowBox[{"2", "*", "p"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", "0"}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929236652023163`*^9, 3.49292366743312*^9}, 
   3.4929802336571484`*^9, {3.492982933672291*^9, 3.4929829505983205`*^9}, {
   3.4929832472016416`*^9, 3.4929833842790823`*^9}, {3.4929834529036026`*^9, 
   3.4929834542764053`*^9}, {3.493166117311906*^9, 3.493166138981936*^9}, {
   3.4931662751621265`*^9, 3.4931663186221876`*^9}, {3.4934126182898765`*^9, 
   3.493412622519882*^9}, {3.4935809700815477`*^9, 3.4935809719615507`*^9}, {
   3.493791136533005*^9, 3.4937911896730795`*^9}, 3.4937912549331713`*^9, {
   3.4938403406557693`*^9, 3.4938403671446157`*^9}, {3.4938574572652164`*^9, 
   3.493857469385233*^9}, {3.493857542505336*^9, 3.493857549915346*^9}, {
   3.493857663025504*^9, 3.4938576691055126`*^9}, 3.4938621399657745`*^9, {
   3.4938623256060343`*^9, 3.4938623265160356`*^9}, {3.49386579402089*^9, 
   3.493865798890897*^9}, 3.4938664556718163`*^9, {3.4940008728716335`*^9, 
   3.4940008728756337`*^9}, 3.4940219220874023`*^9, 3.5171885476957307`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{{3.493099207935931*^9, 3.4930992149659414`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"d", "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", "m"}]}], ",", 
   "n", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "p"}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
    "\[And]", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "+", 
      RowBox[{"2", "p"}], "+", "3"}], "\[NotEqual]", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4932562829889927`*^9, 3.4932562829889927`*^9}, {3.4933543405726185`*^9, 
   3.493354354743429*^9}, {3.493354669307421*^9, 3.493354670200472*^9}, {
   3.4933549046238804`*^9, 3.493354922498903*^9}, {3.493356182221955*^9, 
   3.4933562049342537`*^9}, {3.4933938872666245`*^9, 
   3.4933939122734685`*^9}, {3.493394021941661*^9, 3.493394030412476*^9}, {
   3.493395008824994*^9, 3.493395011601799*^9}, {3.4933950592130823`*^9, 
   3.4933950626138887`*^9}, {3.4933958282120333`*^9, 
   3.4933958335004425`*^9}, {3.4933958648876977`*^9, 3.493395891672944*^9}, {
   3.493406394401163*^9, 3.4934063956011643`*^9}, {3.4934443505890384`*^9, 
   3.493444358119049*^9}, {3.4935053801481667`*^9, 3.4935053801481667`*^9}, {
   3.4935057769504633`*^9, 3.4935057769504633`*^9}, {3.493505844997783*^9, 
   3.493505844997783*^9}, {3.493582329573451*^9, 3.4935823505034804`*^9}, {
   3.4940221595009813`*^9, 3.494022161594101*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", 
            SuperscriptBox["x", "2"]}]}], ")"}], 
         RowBox[{"p", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"ArcTan", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
       RowBox[{"c", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  "                                                                ", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", "n"}], 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
     SuperscriptBox[
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", 
       RowBox[{"2", "p"}], "+", "3"}], ")"}]}], 
    RowBox[{" ", 
     RowBox[{"m", "+", "1"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
     SuperscriptBox[
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.49332119396688*^9, {3.4933214175471926`*^9, 
   3.4933214366372194`*^9}, {3.4933214780072775`*^9, 
   3.4933214840172863`*^9}, {3.493354278495068*^9, 3.493354294476982*^9}, {
   3.4933546277870464`*^9, 3.4933546449460278`*^9}, {3.493354790721366*^9, 
   3.4933547931895065`*^9}, {3.4933560394157867`*^9, 
   3.4933561011583185`*^9}, {3.4933561738414755`*^9, 
   3.4933561751395497`*^9}, {3.4933562501758413`*^9, 
   3.4933562530870085`*^9}, {3.493356410270999*^9, 3.4933564233687477`*^9}, {
   3.493394874820759*^9, 3.4933949021052065`*^9}, {3.493395751163498*^9, 
   3.4933957978543797`*^9}, {3.493406138010804*^9, 3.4934061641108403`*^9}, {
   3.4934062369309425`*^9, 3.4934062462209554`*^9}, {3.49340655671139*^9, 
   3.4934065590813932`*^9}, {3.4940008728906345`*^9, 
   3.4940008728956347`*^9}, {3.4940285760279856`*^9, 3.494028576547015*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"n", "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"2", "*", "p"}], "+", "3"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n", ",", 
      RowBox[{"2", "*", "p"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"2", "*", "p"}], "+", "3"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.4929244782757444`*^9, 
   3.4929244935793715`*^9}, {3.4933546901676145`*^9, 3.493354852357891*^9}, {
   3.493354994220005*^9, 3.4933549944920206`*^9}, {3.4933561282218666`*^9, 
   3.493356154267356*^9}, {3.4933562088824797`*^9, 3.493356243066435*^9}, {
   3.4933562812016163`*^9, 3.4933563433891735`*^9}, {3.4933564509923277`*^9, 
   3.4933564967799463`*^9}, {3.4933565518720975`*^9, 3.493356556926387*^9}, {
   3.493356683297615*^9, 3.493356683651635*^9}, {3.493393781030438*^9, 
   3.4933937826528406`*^9}, {3.49339383350893*^9, 3.4933938341173315`*^9}, {
   3.4933938692017927`*^9, 3.4933938715417967`*^9}, {3.4933939716159725`*^9, 
   3.4933939737687764`*^9}, {3.4933951036263604`*^9, 
   3.4933952261489754`*^9}, {3.4933952605626364`*^9, 3.493395282199874*^9}, {
   3.4933959219993978`*^9, 3.493396038968403*^9}, 3.4933965390584817`*^9, {
   3.4934062197609186`*^9, 3.49340622120092*^9}, {3.4934064692212677`*^9, 
   3.49340657783142*^9}, {3.4934442542789035`*^9, 3.493444261298914*^9}, {
   3.4935053828469715`*^9, 3.4935053837985735`*^9}, 3.493505773830458*^9, {
   3.4935058411913767`*^9, 3.493505841986978*^9}, {3.493580821131339*^9, 
   3.493580823141342*^9}, {3.4938648637095876`*^9, 3.493864868009594*^9}, {
   3.4938653914803267`*^9, 3.493865394630331*^9}, {3.4940008729066353`*^9, 
   3.4940008729146357`*^9}, 3.4940219221254044`*^9, {3.4940285863885784`*^9, 
   3.4940285866645937`*^9}, 3.5171885476957307`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{{3.493099207935931*^9, 3.4930992149659414`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"d", "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", "m"}]}], ",", 
   "n", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "p"}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
    "\[And]", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "+", 
      RowBox[{"2", "p"}], "+", "2"}], "\[NotEqual]", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4932562829889927`*^9, 3.4932562829889927`*^9}, {3.4933543405726185`*^9, 
   3.493354354743429*^9}, {3.493354669307421*^9, 3.493354670200472*^9}, {
   3.4933549046238804`*^9, 3.493354922498903*^9}, {3.493356182221955*^9, 
   3.4933562049342537`*^9}, {3.4933938872666245`*^9, 
   3.4933939122734685`*^9}, {3.493394021941661*^9, 3.493394030412476*^9}, {
   3.493395008824994*^9, 3.493395011601799*^9}, {3.4933950592130823`*^9, 
   3.4933950626138887`*^9}, {3.493444320208996*^9, 3.493444321758998*^9}, {
   3.4934444078191185`*^9, 3.4934444112891235`*^9}, {3.4935053527545185`*^9, 
   3.4935053527545185`*^9}, {3.4935057932368927`*^9, 
   3.4935057932368927`*^9}, {3.4935058259189496`*^9, 
   3.4935058259189496`*^9}, {3.493582335173459*^9, 3.493582342413469*^9}, {
   3.4940221631801915`*^9, 3.4940221650502987`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", " ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", "m"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", 
            SuperscriptBox["x", "2"]}]}], ")"}], 
         RowBox[{"p", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"ArcTan", "[", 
          RowBox[{"a", " ", "x"}], "]"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"a", " ", "c", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  "                                                                       ", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["m", 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
     SuperscriptBox[
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"a", 
     RowBox[{"(", 
      RowBox[{"m", "+", 
       RowBox[{"2", "p"}], "+", "2"}], ")"}]}], 
    RowBox[{"n", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
     SuperscriptBox[
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.49332119396688*^9, {3.4933214175471926`*^9, 
   3.4933214366372194`*^9}, {3.4933214780072775`*^9, 
   3.4933214840172863`*^9}, {3.493354278495068*^9, 3.493354294476982*^9}, {
   3.4933546277870464`*^9, 3.4933546449460278`*^9}, {3.493354790721366*^9, 
   3.4933547931895065`*^9}, {3.4933560394157867`*^9, 
   3.4933561011583185`*^9}, {3.4933561738414755`*^9, 
   3.4933561751395497`*^9}, {3.4933562501758413`*^9, 
   3.4933562530870085`*^9}, {3.493356410270999*^9, 3.4933564233687477`*^9}, {
   3.493394874820759*^9, 3.4933949021052065`*^9}, {3.493444143068748*^9, 
   3.493444163808777*^9}, {3.494000872929637*^9, 3.494000872934637*^9}, {
   3.4940286415867357`*^9, 3.4940286418847523`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "m"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "c", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"m", "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"2", "*", "p"}], "+", "2"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n", ",", 
      RowBox[{"2", "*", "p"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"2", "*", "p"}], "+", "2"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.4929244782757444`*^9, 
   3.4929244935793715`*^9}, {3.4933546901676145`*^9, 3.493354852357891*^9}, {
   3.493354994220005*^9, 3.4933549944920206`*^9}, {3.4933561282218666`*^9, 
   3.493356154267356*^9}, {3.4933562088824797`*^9, 3.493356243066435*^9}, {
   3.4933562812016163`*^9, 3.4933563433891735`*^9}, {3.4933564509923277`*^9, 
   3.4933564967799463`*^9}, {3.4933565518720975`*^9, 3.493356556926387*^9}, {
   3.493356683297615*^9, 3.493356683651635*^9}, {3.493393781030438*^9, 
   3.4933937826528406`*^9}, {3.49339383350893*^9, 3.4933938341173315`*^9}, {
   3.4933938692017927`*^9, 3.4933938715417967`*^9}, {3.4933939716159725`*^9, 
   3.4933939737687764`*^9}, {3.4933951036263604`*^9, 
   3.4933952261489754`*^9}, {3.4933952605626364`*^9, 3.493395282199874*^9}, 
   3.4933965801177535`*^9, {3.4933967072423773`*^9, 3.4933967295972166`*^9}, {
   3.4933967622168736`*^9, 3.493396766506881*^9}, {3.4934444505191784`*^9, 
   3.4934444533991823`*^9}, {3.4934444856092277`*^9, 3.493444554759324*^9}, 
   3.4934449081898193`*^9, {3.4935053477937098`*^9, 3.4935053483397107`*^9}, 
   3.493505790023287*^9, {3.4935058218473425`*^9, 3.4935058223465433`*^9}, {
   3.4935808341413574`*^9, 3.4935808367413607`*^9}, {3.493864871779599*^9, 
   3.493864875919605*^9}, {3.4938653985703363`*^9, 3.4938654013003407`*^9}, {
   3.4940008729456377`*^9, 3.494000872953638*^9}, 3.4940219221544056`*^9, {
   3.49402863660445*^9, 3.494028636917468*^9}, 3.517188547711331*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection"],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 " or ",
 Cell[BoxData[
  RowBox[{"a", ">", "0"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"e", "+", 
      RowBox[{"f", " ", 
       SuperscriptBox["x", "m"]}]}], ")"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"]}], "=", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox["a", 
      RowBox[{"m", "+", "1"}]]], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"e", " ", 
       SuperscriptBox["a", "m"]}], "+", 
      RowBox[{"f", " ", 
       SuperscriptBox[
        RowBox[{"Tan", "[", 
         RowBox[{"ArcTan", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "]"}], "m"]}]}], ")"}], 
    SuperscriptBox[
     RowBox[{"Sec", "[", 
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "]"}], 
     RowBox[{"2", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}]], " ", 
    SuperscriptBox[
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{
     SubscriptBox["\[PartialD]", "x"], 
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664448654022*^9, 3.479664485386842*^9, {3.4796905699999485`*^9, 
   3.4796905930330687`*^9}, {3.493066205237155*^9, 3.493066233807195*^9}, {
   3.493067002288271*^9, 3.493067007218278*^9}, {3.4930671665685015`*^9, 
   3.4930671719285088`*^9}, {3.49357941453937*^9, 3.4935794178593745`*^9}, {
   3.4935794530694237`*^9, 3.4935794623694367`*^9}, {3.493579591189617*^9, 
   3.4935795950296226`*^9}, {3.4935796369196815`*^9, 3.493579680229742*^9}, {
   3.4935798057299175`*^9, 3.493579823249942*^9}, {3.493580013000208*^9, 
   3.4935800183302155`*^9}, {3.4935837156853914`*^9, 
   3.4935837306154127`*^9}, {3.493583770785469*^9, 3.4935837932255*^9}, 
   3.493583845935574*^9, {3.49497090133292*^9, 3.4949709217329493`*^9}, {
   3.4949709668630123`*^9, 3.4949710356931086`*^9}, {3.494971138883253*^9, 
   3.494971138883253*^9}, {3.495158987656456*^9, 3.495159021461715*^9}, {
   3.495159252919322*^9, 3.4951592532469225`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"d", "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", "m"}]}], ",", 
   "n", ",", 
   RowBox[{
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "\[Or]", " ", 
      RowBox[{"n", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}], ")"}], " ",
     "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[Or]", 
      " ", 
      RowBox[{"c", ">", "0"}]}], ")"}], " ", "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[Or]", 
      " ", 
      RowBox[{"a", ">", "0"}]}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055117607107`*^9, {3.4930655124161854`*^9, 3.4930655280062075`*^9}, {
   3.493066033556915*^9, 3.49306607975698*^9}, {3.4930669874082503`*^9, 
   3.4930669888982525`*^9}, {3.4932562746689816`*^9, 
   3.4932562746689816`*^9}, {3.493256683249553*^9, 3.4932567141395965`*^9}, {
   3.493484196390273*^9, 3.493484198590276*^9}, {3.4934849126412754`*^9, 
   3.493484912921276*^9}, {3.4934858273225565`*^9, 3.4934858277825565`*^9}, {
   3.4934858606226025`*^9, 3.493485878442628*^9}, {3.493485980752771*^9, 
   3.493486013532817*^9}, 3.4934861613430243`*^9, {3.493582299533409*^9, 
   3.493582299533409*^9}, {3.49358240752356*^9, 3.49358240752356*^9}, {
   3.493584403266354*^9, 3.4935844505964203`*^9}, {3.493584685416749*^9, 
   3.4935846881867533`*^9}, {3.4935847277768087`*^9, 
   3.4935847301168118`*^9}, {3.4935855704579883`*^9, 3.4935855725279913`*^9}, 
   3.495159180644395*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"e", "+", 
     RowBox[{"f", " ", 
      SuperscriptBox["x", "m"]}]}], ")"}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
   SuperscriptBox[
    RowBox[{"ArcTan", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SuperscriptBox["c", "p"], 
      SuperscriptBox["a", 
       RowBox[{"m", "+", "1"}]]]}]}], " ", 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox["x", "n"], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"e", " ", 
          SuperscriptBox["a", "m"]}], "+", 
         RowBox[{"f", " ", 
          SuperscriptBox[
           RowBox[{"Tan", "[", "x", "]"}], "m"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"Sec", "[", "x", "]"}], 
        RowBox[{"2", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}]}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579733429823`*^9, 3.4796580025249443`*^9}, {
   3.4796580760106115`*^9, 3.479658076961979*^9}, {3.479658170546547*^9, 
   3.47965817467248*^9}, {3.4796583692823153`*^9, 3.4796583839634256`*^9}, {
   3.4796584934408464`*^9, 3.479658497486664*^9}, {3.479661194084181*^9, 
   3.47966122030188*^9}, 3.479661392649704*^9, {3.4796614543984947`*^9, 
   3.4796614565015182`*^9}, {3.4796616029320755`*^9, 3.47966160861024*^9}, 
   3.479661772305622*^9, 3.47966185512471*^9, {3.4796624643307056`*^9, 
   3.4796624837586412`*^9}, {3.4796684805015345`*^9, 3.479668482213997*^9}, {
   3.47968672053469*^9, 3.479686720544704*^9}, {3.4796906638949633`*^9, 
   3.479690664315568*^9}, {3.479690714507741*^9, 3.4796907460130434`*^9}, 
   3.480705514654872*^9, {3.4930650337755156`*^9, 3.493065049545537*^9}, {
   3.4930657623365355`*^9, 3.4930657881965714`*^9}, {3.4930663212373176`*^9, 
   3.493066363577377*^9}, {3.493066963568217*^9, 3.493066975738234*^9}, 
   3.4932537469796257`*^9, 3.493256113988756*^9, {3.4932567461396413`*^9, 
   3.4932567491696453`*^9}, 3.493484110810153*^9, {3.4934842003402786`*^9, 
   3.4934842033302827`*^9}, {3.4934849452513213`*^9, 3.493484979331369*^9}, {
   3.493583483165066*^9, 3.4935834997850895`*^9}, {3.4935840350458384`*^9, 
   3.493584038155843*^9}, {3.4949712212333684`*^9, 3.494971230293381*^9}, {
   3.4949712621134253`*^9, 3.4949712970934744`*^9}, {3.495158991603263*^9, 
   3.4951590177801085`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"e_.", "+", 
       RowBox[{"f_.", "*", 
        RowBox[{"x_", "^", "m_."}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_"}], "*", 
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"c", "^", "p"}], "/", 
      RowBox[{"a", "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Expand", "[", 
          RowBox[{
           RowBox[{"x", "^", "n"}], "*", 
           RowBox[{"TrigReduce", "[", 
            RowBox[{"Regularize", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"e", "*", 
                  RowBox[{"a", "^", "m"}]}], "+", 
                 RowBox[{"f", "*", 
                  RowBox[{
                   RowBox[{"Tan", "[", "x", "]"}], "^", "m"}]}]}], ")"}], "*", 
               RowBox[{
                RowBox[{"Sec", "[", "x", "]"}], "^", 
                RowBox[{"(", 
                 RowBox[{"2", "*", 
                  RowBox[{"(", 
                   RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], ",", "x"}], 
             "]"}], "]"}]}], "]"}], ",", "x"}], "]"}], ",", "x", ",", 
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", "*", "x"}], "]"}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n", ",", "p"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "||", " ", 
      RowBox[{"Not", "[", 
       RowBox[{"IntegerQ", "[", "n", "]"}], "]"}]}], ")"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "p", "]"}], " ", "||", " ", 
      RowBox[{"PositiveQ", "[", "c", "]"}]}], ")"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "m", "]"}], " ", "||", " ", 
      RowBox[{"PositiveQ", "[", "a", "]"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.493065103075612*^9, 3.493065290765875*^9}, {
   3.493065714046468*^9, 3.493065729586489*^9}, {3.4930658063465967`*^9, 
   3.4930658068865976`*^9}, {3.493067047288334*^9, 3.493067049548337*^9}, {
   3.4930670867783895`*^9, 3.493067112388425*^9}, {3.4930674070088377`*^9, 
   3.4930674148588486`*^9}, {3.4930676846992264`*^9, 
   3.4930676962292423`*^9}, {3.493484206670287*^9, 3.4934842155203*^9}, 
   3.4934861347329865`*^9, {3.49348619445307*^9, 3.493486231663122*^9}, {
   3.4934862761831846`*^9, 3.4934862874732003`*^9}, {3.493580741261227*^9, 
   3.4935807428812294`*^9}, {3.4935808762114162`*^9, 3.493580878411419*^9}, {
   3.4935841108559446`*^9, 3.4935841493659987`*^9}, {3.493584751096841*^9, 
   3.4935847734468727`*^9}, 3.4935848245769444`*^9, {3.493584859686993*^9, 
   3.493584861126995*^9}, 3.493585344727672*^9, 3.4935853768577175`*^9, {
   3.4935856376880827`*^9, 3.4935856399880857`*^9}, {3.4949713407035356`*^9, 
   3.494971373883582*^9}, {3.494971426013655*^9, 3.4949714378836718`*^9}, {
   3.494972220994768*^9, 3.49497223640479*^9}, {3.4949725116251745`*^9, 
   3.494972523895192*^9}, {3.4951589947388687`*^9, 3.495159028715728*^9}, 
   3.495159213872453*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"]}], "=", 
   RowBox[{
    FractionBox["1", "a"], 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox[
       RowBox[{"Tan", "[", 
        RowBox[{"ArcTan", "[", 
         RowBox[{"a", " ", "x"}], "]"}], "]"}], "a"], ")"}], "m"], 
    SuperscriptBox[
     RowBox[{"Sec", "[", 
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "]"}], 
     RowBox[{"2", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}]], " ", 
    SuperscriptBox[
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{
     SubscriptBox["\[PartialD]", "x"], 
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664448654022*^9, 3.479664485386842*^9, {3.4796905699999485`*^9, 
   3.4796905930330687`*^9}, {3.493066205237155*^9, 3.493066233807195*^9}, {
   3.493067002288271*^9, 3.493067007218278*^9}, {3.4930671665685015`*^9, 
   3.4930671719285088`*^9}, {3.49357941453937*^9, 3.4935794178593745`*^9}, {
   3.4935794530694237`*^9, 3.4935794623694367`*^9}, {3.493579591189617*^9, 
   3.4935795950296226`*^9}, {3.4935796369196815`*^9, 3.493579680229742*^9}, {
   3.4935798057299175`*^9, 3.493579823249942*^9}, {3.493580013000208*^9, 
   3.4935800183302155`*^9}, {3.4935837156853914`*^9, 
   3.4935837306154127`*^9}, {3.493583770785469*^9, 3.4935837932255*^9}, 
   3.493583845935574*^9, {3.493585128467369*^9, 3.493585152037402*^9}, {
   3.4940008730496435`*^9, 3.4940008730636444`*^9}, {3.4940009671060233`*^9, 
   3.4940009671060233`*^9}, {3.494028684350181*^9, 3.4940286847392035`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"d", "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", "m"}]}], ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "\[Or]", " ", 
      RowBox[{"n", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}], ")"}], " ",
     "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[Or]", 
      " ", 
      RowBox[{"c", ">", "0"}]}], ")"}], " ", "\[And]", " ", 
    RowBox[{"\[Not]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[Or]", 
       " ", 
       RowBox[{"a", ">", "0"}]}], ")"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055117607107`*^9, {3.4930655124161854`*^9, 3.4930655280062075`*^9}, {
   3.493066033556915*^9, 3.49306607975698*^9}, {3.4930669874082503`*^9, 
   3.4930669888982525`*^9}, {3.4932562746689816`*^9, 
   3.4932562746689816`*^9}, {3.493256683249553*^9, 3.4932567141395965`*^9}, {
   3.493484196390273*^9, 3.493484198590276*^9}, {3.4934849126412754`*^9, 
   3.493484912921276*^9}, {3.4934858273225565`*^9, 3.4934858277825565`*^9}, {
   3.4934858606226025`*^9, 3.493485878442628*^9}, {3.493485980752771*^9, 
   3.493486013532817*^9}, 3.4934860446528606`*^9, 3.493486166643031*^9, {
   3.493582304453416*^9, 3.493582304453416*^9}, {3.4935823991735487`*^9, 
   3.4935823991735487`*^9}, {3.49358546440784*^9, 3.4935854739178534`*^9}, 
   3.4935855059178977`*^9, {3.4937503523187337`*^9, 3.4937503527399344`*^9}, {
   3.4940221756839066`*^9, 3.4940221776450195`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
   SuperscriptBox[
    RowBox[{"ArcTan", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SuperscriptBox["c", "p"], "a"]}]}], " ", 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox["x", "n"], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Tan", "[", "x", "]"}], "/", "a"}], ")"}], "m"], " ", 
       SuperscriptBox[
        RowBox[{"Sec", "[", "x", "]"}], 
        RowBox[{"2", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}]}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579733429823`*^9, 3.4796580025249443`*^9}, {
   3.4796580760106115`*^9, 3.479658076961979*^9}, {3.479658170546547*^9, 
   3.47965817467248*^9}, {3.4796583692823153`*^9, 3.4796583839634256`*^9}, {
   3.4796584934408464`*^9, 3.479658497486664*^9}, {3.479661194084181*^9, 
   3.47966122030188*^9}, 3.479661392649704*^9, {3.4796614543984947`*^9, 
   3.4796614565015182`*^9}, {3.4796616029320755`*^9, 3.47966160861024*^9}, 
   3.479661772305622*^9, 3.47966185512471*^9, {3.4796624643307056`*^9, 
   3.4796624837586412`*^9}, {3.4796684805015345`*^9, 3.479668482213997*^9}, {
   3.47968672053469*^9, 3.479686720544704*^9}, {3.4796906638949633`*^9, 
   3.479690664315568*^9}, {3.479690714507741*^9, 3.4796907460130434`*^9}, 
   3.480705514654872*^9, {3.4930650337755156`*^9, 3.493065049545537*^9}, {
   3.4930657623365355`*^9, 3.4930657881965714`*^9}, {3.4930663212373176`*^9, 
   3.493066363577377*^9}, {3.493066963568217*^9, 3.493066975738234*^9}, 
   3.4932537469796257`*^9, 3.493256113988756*^9, {3.4932567461396413`*^9, 
   3.4932567491696453`*^9}, 3.493484110810153*^9, {3.4934842003402786`*^9, 
   3.4934842033302827`*^9}, {3.4934849452513213`*^9, 3.493484979331369*^9}, {
   3.493486071912899*^9, 3.493486082822914*^9}, {3.4935835296251307`*^9, 
   3.4935835407851467`*^9}, {3.493585265387561*^9, 3.4935852691475663`*^9}, {
   3.4940008730846453`*^9, 3.4940008730876455`*^9}, 3.4940009681030803`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_"}], "*", 
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"c", "^", "p"}], "/", "a"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", "n"}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Tan", "[", "x", "]"}], "/", "a"}], ")"}], "^", "m"}], 
          "*", 
          RowBox[{
           RowBox[{"Sec", "[", "x", "]"}], "^", 
           RowBox[{"(", 
            RowBox[{"2", "*", 
             RowBox[{"(", 
              RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], ",", "x"}], "]"}], 
       ",", "x", ",", 
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", "*", "x"}], "]"}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n", ",", "p"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "||", " ", 
      RowBox[{"Not", "[", 
       RowBox[{"IntegerQ", "[", "n", "]"}], "]"}]}], ")"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "p", "]"}], " ", "||", " ", 
      RowBox[{"PositiveQ", "[", "c", "]"}]}], ")"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "m", "]"}], " ", "||", " ", 
      RowBox[{"PositiveQ", "[", "a", "]"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.493065103075612*^9, 3.493065290765875*^9}, {
   3.493065714046468*^9, 3.493065729586489*^9}, {3.4930658063465967`*^9, 
   3.4930658068865976`*^9}, {3.493067047288334*^9, 3.493067049548337*^9}, {
   3.4930670867783895`*^9, 3.493067112388425*^9}, {3.4930674070088377`*^9, 
   3.4930674148588486`*^9}, {3.4930676846992264`*^9, 
   3.4930676962292423`*^9}, {3.493484206670287*^9, 3.4934842155203*^9}, 
   3.4934861304629803`*^9, 3.4934861903430643`*^9, {3.4934862534031525`*^9, 
   3.493486262273165*^9}, {3.4934862996232176`*^9, 3.4934863089332304`*^9}, {
   3.4935808677814045`*^9, 3.493580870141408*^9}, {3.4935853052876167`*^9, 
   3.493585373757713*^9}, {3.4935856061680384`*^9, 3.493585615798052*^9}, 
   3.493585663598119*^9, {3.494000873097646*^9, 3.4940008731026464`*^9}, 
   3.4940009687371163`*^9, 3.494021922212409*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    SuperscriptBox["a", "2"], " ", "c"}]}]]],
 ", ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["c", 
        RowBox[{"p", "-", 
         FractionBox["1", "2"]}]], 
       SqrtBox[
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}]]}], 
      SqrtBox[
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["x", "2"]}]}]]], ",", "x"}], "]"}], "=", "0"}]],
  CellChangeTimes->{{3.4937498379858303`*^9, 3.4937499017587423`*^9}, {
   3.4937499674816575`*^9, 3.493750029569767*^9}}]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664448654022*^9, 3.479664485386842*^9, {3.4796905699999485`*^9, 
   3.4796905930330687`*^9}, {3.493066205237155*^9, 3.493066233807195*^9}, {
   3.493067002288271*^9, 3.493067007218278*^9}, {3.4930671665685015`*^9, 
   3.4930671719285088`*^9}, {3.49357941453937*^9, 3.4935794178593745`*^9}, {
   3.4935794530694237`*^9, 3.4935794623694367`*^9}, {3.493579591189617*^9, 
   3.4935795950296226`*^9}, {3.4935796369196815`*^9, 3.493579680229742*^9}, {
   3.4935798057299175`*^9, 3.493579823249942*^9}, {3.493580013000208*^9, 
   3.4935800183302155`*^9}, {3.4937499298855915`*^9, 
   3.4937499486524243`*^9}, {3.4937500390389833`*^9, 3.4937500431885905`*^9}, 
   3.4937501538707848`*^9, {3.494022180342173*^9, 3.4940221826333046`*^9}, {
   3.494028827004341*^9, 3.494028827554372*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"d", "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", "m"}]}], ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "\[Or]", " ", 
      RowBox[{"n", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}], ")"}], " ",
     "\[And]", " ", 
    RowBox[{
     RowBox[{"p", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ",
     "\[And]", " ", 
    RowBox[{"\[Not]", 
     RowBox[{"(", 
      RowBox[{"c", ">", "0"}], ")"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055117607107`*^9, {3.4930655124161854`*^9, 3.4930655280062075`*^9}, {
   3.493066033556915*^9, 3.49306607975698*^9}, {3.4930680892297926`*^9, 
   3.4930681267098455`*^9}, {3.4930801578959255`*^9, 
   3.4930801961259785`*^9}, {3.493256255798955*^9, 3.4932562676389713`*^9}, {
   3.4934842169503016`*^9, 3.4934842179803033`*^9}, {3.4934855092121105`*^9, 
   3.4934855137621174`*^9}, {3.49358230776342*^9, 3.49358230776342*^9}, {
   3.4935823874135323`*^9, 3.4935823874135323`*^9}, {3.493586084528708*^9, 
   3.4935861150187507`*^9}, {3.493750356390341*^9, 3.493750356561941*^9}, {
   3.4940221861375046`*^9, 3.4940221880396137`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
   SuperscriptBox[
    RowBox[{"ArcTan", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SuperscriptBox["c", 
        RowBox[{"p", "-", 
         FractionBox["1", "2"]}]], 
       SqrtBox[
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}]]}], 
      SqrtBox[
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["x", "2"]}]}]]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "p"], 
     SuperscriptBox[
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579733429823`*^9, 3.4796580025249443`*^9}, {
   3.4796580760106115`*^9, 3.479658076961979*^9}, {3.479658170546547*^9, 
   3.47965817467248*^9}, {3.4796583692823153`*^9, 3.4796583839634256`*^9}, {
   3.4796584934408464`*^9, 3.479658497486664*^9}, {3.479661194084181*^9, 
   3.47966122030188*^9}, 3.479661392649704*^9, {3.4796614543984947`*^9, 
   3.4796614565015182`*^9}, {3.4796616029320755`*^9, 3.47966160861024*^9}, 
   3.479661772305622*^9, 3.47966185512471*^9, {3.4796624643307056`*^9, 
   3.4796624837586412`*^9}, {3.4796684805015345`*^9, 3.479668482213997*^9}, {
   3.47968672053469*^9, 3.479686720544704*^9}, {3.4796906638949633`*^9, 
   3.479690664315568*^9}, {3.479690714507741*^9, 3.4796907460130434`*^9}, 
   3.480705514654872*^9, {3.4930650337755156`*^9, 3.493065049545537*^9}, {
   3.4930657623365355`*^9, 3.4930657881965714`*^9}, {3.493077421798092*^9, 
   3.4930774294181027`*^9}, {3.49307964724521*^9, 3.493079659035227*^9}, {
   3.4930797467153497`*^9, 3.493079763295373*^9}, {3.493079973595667*^9, 
   3.4930800012057056`*^9}, {3.4932537598652487`*^9, 3.4932537660740595`*^9}, 
   3.493256110328751*^9, 3.4934841140101576`*^9, {3.4934842214303083`*^9, 
   3.49348422304031*^9}, 3.493485244821741*^9, 3.4934853226618495`*^9, {
   3.49358577884828*^9, 3.493585797488306*^9}, {3.4940008731186476`*^9, 
   3.4940008731196475`*^9}, {3.4940288304975405`*^9, 3.4940288342037525`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_"}], "*", 
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"c", "^", 
     RowBox[{"(", 
      RowBox[{"p", "-", 
       RowBox[{"1", "/", "2"}]}], ")"}]}], "*", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", 
        RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "+", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "*", 
        RowBox[{"x", "^", "2"}]}]}], "]"}]}], "*", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "m"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "*", 
           RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], "*", 
       RowBox[{
        RowBox[{"ArcTan", "[", 
         RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n", ",", "p"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "||", " ", 
      RowBox[{"Not", "[", 
       RowBox[{"IntegerQ", "[", "n", "]"}], "]"}]}], ")"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"p", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"PositiveQ", "[", "c", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.493065103075612*^9, 3.493065290765875*^9}, {
   3.493065714046468*^9, 3.493065729586489*^9}, {3.4930658063465967`*^9, 
   3.4930658068865976`*^9}, {3.493067423888861*^9, 3.4930674284788675`*^9}, 
   3.493068077149776*^9, {3.493080071975805*^9, 3.493080131335888*^9}, {
   3.4930802396760397`*^9, 3.4930802468960495`*^9}, {3.4932538772710547`*^9, 
   3.4932538805314603`*^9}, {3.493484225600314*^9, 3.493484231900323*^9}, {
   3.4934853924419475`*^9, 3.4934853982519555`*^9}, {3.493485439292013*^9, 
   3.4934854647520485`*^9}, {3.493580855471387*^9, 3.4935808593213925`*^9}, {
   3.4935858177883344`*^9, 3.4935858468983755`*^9}, 3.493585879718421*^9, 
   3.493586196118864*^9, {3.4935862626189575`*^9, 3.493586266048962*^9}, {
   3.494000873129648*^9, 3.4940008731326485`*^9}, 3.4940219222474113`*^9, {
   3.4940288374769397`*^9, 3.494028840943138*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"ArcTan", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, {
   3.4796161531027007`*^9, 3.4796161533330317`*^9}, 3.4796867035102096`*^9, {
   3.4928216890767465`*^9, 3.4928216998095655`*^9}, {3.4928217819749093`*^9, 
   3.492821789587723*^9}, {3.4928219276815653`*^9, 3.492821955418414*^9}, {
   3.492821987970072*^9, 3.4928219896860743`*^9}, {3.4928221957624364`*^9, 
   3.4928222365253077`*^9}, {3.492825657442519*^9, 3.4928256592053223`*^9}, 
   3.4940008732746563`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.822.1, CRC 443, A&S 4.4.60", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4940010628073196`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070527384861*^9, 3.494109939029312*^9, 3.494112226023958*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"ArcTan", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], " ", 
        RowBox[{"ArcTan", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], "]"}]}], "b"]}]}]}]}], "-", 
  FractionBox[
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "2"]}], "]"}], 
   RowBox[{"2", " ", "b"}]]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579729524207`*^9, 3.479658002354699*^9}, {
   3.479658032958706*^9, 3.479658033819944*^9}, {3.479658266604672*^9, 
   3.479658270990979*^9}, 3.4796611918409553`*^9, {3.4796613913478317`*^9, 
   3.47966140315481*^9}, {3.479661508025606*^9, 3.47966151197128*^9}, {
   3.4796618227781982`*^9, 3.4796618235292788`*^9}, 3.479666675846568*^9, {
   3.4796867202542863`*^9, 3.479686720274315*^9}, {3.4796868616776433`*^9, 
   3.479686861938018*^9}, 3.480705278835781*^9, 3.4941093719059157`*^9, {
   3.494111977016321*^9, 3.4941119773283215`*^9}, {3.494112096481331*^9, 
   3.494112145325017*^9}, {3.4941131688636217`*^9, 3.494113179643241*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"ArcTan", "[", 
     RowBox[{"a_", "+", 
      RowBox[{"b_.", "*", "x_"}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "/", "b"}]}], " ", "-", " ", 
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", "b"}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494109908110058*^9, 3.4941099093268595`*^9}, 
   3.49411043303938*^9, 3.494110873053753*^9, {3.4941120188555946`*^9, 
   3.494112019183195*^9}, {3.4941122005335135`*^9, 3.494112205135522*^9}, {
   3.4941131707668257`*^9, 3.4941131952744684`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.822.1, CRC 443, A&S 4.4.60", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4940010628073196`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalQ]"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070527384861*^9, 3.4941132250237207`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"ArcTan", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "x"}]}], " ", 
    RowBox[{"ArcTan", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}]}]}], "-", 
  RowBox[{"b", " ", "n", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox["x", "n"], 
      RowBox[{"1", "+", 
       SuperscriptBox["a", "2"], "+", 
       RowBox[{"2", " ", "a", " ", "b", " ", 
        SuperscriptBox["x", "n"]}], "+", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", 
        SuperscriptBox["x", 
         RowBox[{"2", " ", "n"}]]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579729524207`*^9, 3.479658002354699*^9}, {
   3.479658032958706*^9, 3.479658033819944*^9}, {3.479658266604672*^9, 
   3.479658270990979*^9}, 3.4796611918409553`*^9, {3.4796613913478317`*^9, 
   3.47966140315481*^9}, {3.479661508025606*^9, 3.47966151197128*^9}, {
   3.4796618227781982`*^9, 3.4796618235292788`*^9}, 3.479666675846568*^9, {
   3.4796867202542863`*^9, 3.479686720274315*^9}, {3.4796868616776433`*^9, 
   3.479686861938018*^9}, 3.480705278835781*^9, {3.494000873285657*^9, 
   3.4940008732866573`*^9}, {3.4940020470996175`*^9, 3.4940020476156473`*^9}, 
   3.4941132810902195`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"ArcTan", "[", 
     RowBox[{"a_", "+", 
      RowBox[{"b_.", "*", 
       RowBox[{"x_", "^", "n_"}]}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"x", "^", "n"}]}]}], "]"}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", "n"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "n"}], "/", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"2", "*", "a", "*", "b", "*", 
            RowBox[{"x", "^", "n"}]}], "+", 
           RowBox[{
            RowBox[{"b", "^", "2"}], "*", 
            RowBox[{"x", "^", 
             RowBox[{"(", 
              RowBox[{"2", "*", "n"}], ")"}]}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4940008732956576`*^9, 3.4940008732976575`*^9}, 
   3.4940020232142515`*^9, {3.4941132306553307`*^9, 3.49411323588134*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   RowBox[{"ArcTan", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796867203043585`*^9, {3.4928222468993263`*^9, 3.492822253420138*^9}, {
   3.4928256632301292`*^9, 3.4928256645561314`*^9}, 3.494000873304658*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"ArcTan", "[", "z", "]"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", 
       RowBox[{"\[ImaginaryI]", " ", "z"}]}], "]"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       RowBox[{"\[ImaginaryI]", " ", "z"}]}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664431619528*^9, 3.4796644842351856`*^9, {3.4796867203243876`*^9, 
   3.4796867203243876`*^9}, {3.479686900964134*^9, 3.479686904699506*^9}, {
   3.494000873321659*^9, 3.494000873321659*^9}, {3.4940016544041567`*^9, 
   3.4940016544041567`*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050798897104`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], "]"}], "x"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["I", "2"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{"Log", "[", 
        RowBox[{"1", "-", 
         RowBox[{"I", " ", "a"}], "-", 
         RowBox[{"I", " ", "b", " ", 
          SuperscriptBox["x", "n"]}]}], "]"}], "x"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["I", "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"Log", "[", 
       RowBox[{"1", "+", 
        RowBox[{"I", " ", "a"}], "+", 
        RowBox[{"I", " ", "b", " ", 
         SuperscriptBox["x", "n"]}]}], "]"}], "x"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579730125074`*^9, 3.479658002374728*^9}, 
   3.479658039448037*^9, 3.479661193793763*^9, {3.4796615158368387`*^9, 
   3.479661531599504*^9}, 3.4796867203243876`*^9, {3.4796869232261457`*^9, 
   3.4796869451176243`*^9}, 3.49400087334066*^9, {3.494001703554968*^9, 
   3.4940017521417475`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ArcTan", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], "]"}], "/", "x_"}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"I", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"1", "-", 
           RowBox[{"I", "*", "a"}], "-", 
           RowBox[{"I", "*", "b", "*", 
            RowBox[{"x", "^", "n"}]}]}], "]"}], "/", "x"}], ",", "x"}], 
       "]"}]}], "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"I", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"1", "+", 
           RowBox[{"I", "*", "a"}], "+", 
           RowBox[{"I", "*", "b", "*", 
            RowBox[{"x", "^", "n"}]}]}], "]"}], "/", "x"}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{3.494000873350661*^9, 3.4940016721911745`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.851, CRC 456, A&S 4.4.69", "Subsubsection",
 CellChangeTimes->{3.479686957936056*^9, 3.4940019256886735`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{
     RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "+", "1"}], "\[NotEqual]", "n"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.480705286316538*^9, {3.4941088512110004`*^9, 3.494108875297443*^9}, {
   3.4941089257323313`*^9, 3.494108953812381*^9}, {3.494109011158081*^9, 
   3.4941090265241084`*^9}, {3.4941099489353294`*^9, 3.494109954473339*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"ArcTan", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        RowBox[{"ArcTan", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", "n"]}]}], "]"}]}], 
       RowBox[{"m", "+", "1"}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"b", " ", "n"}], 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox["x", 
       RowBox[{"m", "+", "n"}]], 
      RowBox[{"1", "+", 
       SuperscriptBox["a", "2"], "+", 
       RowBox[{"2", " ", "a", " ", "b", " ", 
        SuperscriptBox["x", "n"]}], "+", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", 
        SuperscriptBox["x", 
         RowBox[{"2", " ", "n"}]]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.47965797304255*^9, 3.4796580023847427`*^9}, {
   3.479658043163379*^9, 3.47965804398456*^9}, 3.479658468995696*^9, {
   3.479658610368981*^9, 3.479658625961402*^9}, {3.479661193843835*^9, 
   3.4796612201817074`*^9}, {3.47966139238933*^9, 3.479661423644272*^9}, {
   3.479661536146042*^9, 3.4796615416739902`*^9}, 3.4796617640337276`*^9, 
   3.4796618325222096`*^9, 3.4796668662303267`*^9, {3.4796867203344016`*^9, 
   3.4796867203344016`*^9}, {3.4796869701135664`*^9, 3.4796869707144303`*^9}, 
   3.480705289451045*^9, {3.4940008733676615`*^9, 3.494000873369662*^9}, {
   3.4940018654752293`*^9, 3.494001865993259*^9}, 3.494113356375952*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"ArcTan", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"x", "^", "n"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", 
       RowBox[{"n", "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "n"}], ")"}]}], "/", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"2", "*", "a", "*", "b", "*", 
            RowBox[{"x", "^", "n"}]}], "+", 
           RowBox[{
            RowBox[{"b", "^", "2"}], "*", 
            RowBox[{"x", "^", 
             RowBox[{"(", 
              RowBox[{"2", "*", "n"}], ")"}]}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"m", "+", "1"}], "\[NotEqual]", "n"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494000873378662*^9, 3.4940008733806624`*^9}, 
   3.4940018465581474`*^9, {3.4941133864372044`*^9, 3.494113393800417*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"ArcTan", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, 
   3.494000868172364*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by substitution", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.49283103988311*^9, 3.492831064713145*^9}, {3.4928318015941763`*^9, 
   3.492831805684182*^9}, {3.494096886328291*^9, 3.4940968902482967`*^9}, {
   3.494105704216672*^9, 3.4941057076330776`*^9}, {3.494113513203027*^9, 
   3.494113513203027*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"ArcTan", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "b"]}]}], " ", 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"ArcTan", "[", "x", "]"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732428384`*^9, 3.479658002484886*^9}, {
   3.4796580646743107`*^9, 3.479658065695779*^9}, 3.4796611938939075`*^9, {
   3.4796867205046463`*^9, 3.479686740233014*^9}, 3.479694163016453*^9, 
   3.479694241058672*^9, {3.4928308514228463`*^9, 3.4928309174229383`*^9}, {
   3.4928311838033113`*^9, 3.4928311994833336`*^9}, 3.492831236813386*^9, {
   3.494096850808242*^9, 3.4940968754382763`*^9}, {3.494099829842412*^9, 
   3.494099830252413*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ArcTan", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", "b"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"ArcTan", "[", "x", "]"}], "^", "n"}], ",", "x"}], "]"}], 
       ",", "x", ",", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4928312031533384`*^9, 3.4928312054633417`*^9}, {
  3.4940968956183043`*^9, 3.494096916128333*^9}, {3.4940998310224137`*^9, 
  3.494099832012415*^9}, {3.4941057107686834`*^9, 3.4941057177262955`*^9}, {
  3.4941135147630296`*^9, 3.494113524559847*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"ArcTan", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.492802747642827*^9, 
   3.492802751137233*^9}, 3.4928222777249804`*^9, 3.492825819138003*^9, 
   3.4940008731396484`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by substitution", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"m", ">", "0"}], " ", "\[And]", " ", 
    RowBox[{"n", ">", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.49283103988311*^9, 3.492831064713145*^9}, {3.4928318015941763`*^9, 
   3.492831805684182*^9}, {3.4941057503927526`*^9, 3.494105764682378*^9}, {
   3.4941135521562953`*^9, 3.4941135521562953`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"ArcTan", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      SuperscriptBox["b", 
       RowBox[{"m", "+", "1"}]]]}]}], " ", 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "-", "a"}], ")"}], "m"], " ", 
       SuperscriptBox[
        RowBox[{"ArcTan", "[", "x", "]"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732428384`*^9, 3.479658002484886*^9}, {
   3.4796580646743107`*^9, 3.479658065695779*^9}, 3.4796611938939075`*^9, {
   3.4796867205046463`*^9, 3.479686740233014*^9}, 3.479694163016453*^9, 
   3.479694241058672*^9, {3.4928308514228463`*^9, 3.4928309174229383`*^9}, {
   3.4928311838033113`*^9, 3.4928311994833336`*^9}, 3.492831236813386*^9, {
   3.494000873149649*^9, 3.4940008731516495`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"b", "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"x", "-", "a"}], ")"}], "^", "m"}], "*", 
          RowBox[{
           RowBox[{"ArcTan", "[", "x", "]"}], "^", "n"}]}], ",", "x"}], "]"}],
        ",", "x", ",", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4928312031533384`*^9, 3.4928312054633417`*^9}, {
   3.49400087316065*^9, 3.49400087316265*^9}, {3.4941057270083113`*^9, 
   3.494105747069947*^9}, {3.494113554215499*^9, 3.494113565057518*^9}, 
   3.5171884666291885`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"ArcTan", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "n"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, 3.4802882652733135`*^9, 3.480288373839424*^9, {
   3.480299236238787*^9, 3.480299238211624*^9}, {3.4803010920372944`*^9, 
   3.480301103143264*^9}, {3.4928037993654737`*^9, 3.49280383115833*^9}, 
   3.4928257757543263`*^9, 3.49400087316965*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"ArcTan", "[", "z", "]"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", 
       RowBox[{"\[ImaginaryI]", " ", "z"}]}], "]"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       RowBox[{"\[ImaginaryI]", " ", "z"}]}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.48030057193943*^9, 3.4803006163232512`*^9, {3.494000873188651*^9, 
   3.494000873188651*^9}, {3.4940227517628565`*^9, 3.4940227517628565`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{"n", "=", 
      RowBox[{
       RowBox[{"2", "\[And]", "d"}], "=", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", "c"}]}]}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055445578704`*^9, 3.49282853967961*^9, {3.4928286506197653`*^9, 
   3.4928286988398323`*^9}, {3.493751094490037*^9, 3.4937510948176374`*^9}, {
   3.49402290217846*^9, 3.494022907042738*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"ArcTan", "[", 
      RowBox[{"b", " ", "x"}], "]"}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "n"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["I", "2"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{"Log", "[", 
        RowBox[{"1", "-", 
         RowBox[{"I", " ", "b", " ", "x"}]}], "]"}], 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "n"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["I", "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"Log", "[", 
       RowBox[{"1", "+", 
        RowBox[{"I", " ", "b", " ", "x"}]}], "]"}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "n"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732428384`*^9, 3.479658002484886*^9}, {
   3.4796580646743107`*^9, 3.479658065695779*^9}, 3.4796611938939075`*^9, {
   3.4796867205046463`*^9, 3.479686740233014*^9}, 3.479694163016453*^9, 
   3.479694241058672*^9, {3.4928288741700783`*^9, 3.4928289166801376`*^9}, {
   3.492828963480203*^9, 3.4928290377203074`*^9}, 3.492829172840496*^9, 
   3.4940008732066526`*^9, {3.494022797217457*^9, 3.4940228313764105`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ArcTan", "[", 
      RowBox[{"b_.", "*", "x_"}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"c_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"I", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"1", "-", 
           RowBox[{"I", "*", "b", "*", "x"}]}], "]"}], "/", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", 
            RowBox[{"x", "^", "n"}]}]}], ")"}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"I", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"1", "+", 
           RowBox[{"I", "*", "b", "*", "x"}]}], "]"}], "/", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", 
            RowBox[{"x", "^", "n"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"n", "==", "2"}], " ", "&&", " ", 
      RowBox[{"ZeroQ", "[", 
       RowBox[{"d", "-", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", "c"}]}], "]"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{
  3.4940008732176533`*^9, 3.4940227865048437`*^9, {3.494022913232092*^9, 
   3.494022916547282*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"ArcTan", "[", "z", "]"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", 
       RowBox[{"\[ImaginaryI]", " ", "z"}]}], "]"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       RowBox[{"\[ImaginaryI]", " ", "z"}]}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.48030057193943*^9, 3.4803006163232512`*^9, {3.494000873237654*^9, 
   3.494000873237654*^9}, {3.494022960157776*^9, 3.494022960157776*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{"n", "=", 
      RowBox[{
       RowBox[{"1", "\[And]", 
        RowBox[{
         RowBox[{"a", " ", "d"}], "-", 
         RowBox[{"b", " ", "c"}]}]}], "=", "0"}]}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055445578704`*^9, 3.49282853967961*^9, {3.4928286506197653`*^9, 
   3.4928286988398323`*^9}, {3.492828783319951*^9, 3.492828794439966*^9}, {
   3.4937511084520617`*^9, 3.4937511087484617`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "n"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["I", "2"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{"Log", "[", 
        RowBox[{"1", "-", 
         RowBox[{"I", " ", "a"}], "-", 
         RowBox[{"I", " ", "b", " ", "x"}]}], "]"}], 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "n"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["I", "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"Log", "[", 
       RowBox[{"1", "+", 
        RowBox[{"I", " ", "a"}], "+", 
        RowBox[{"I", " ", "b", " ", "x"}]}], "]"}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "n"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732428384`*^9, 3.479658002484886*^9}, {
   3.4796580646743107`*^9, 3.479658065695779*^9}, 3.4796611938939075`*^9, {
   3.4796867205046463`*^9, 3.479686740233014*^9}, 3.479694163016453*^9, 
   3.479694241058672*^9, {3.4928288741700783`*^9, 3.4928289166801376`*^9}, {
   3.492828963480203*^9, 3.4928290377203074`*^9}, {3.4928290833603706`*^9, 
   3.4928291010103955`*^9}, 3.492829178180504*^9, 3.494000873256655*^9, {
   3.4940229747036085`*^9, 3.4940230032782426`*^9}, {3.4940230591534386`*^9, 
   3.494023069729043*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ArcTan", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"c_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"I", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"1", "-", 
           RowBox[{"I", "*", "a"}], "-", 
           RowBox[{"I", "*", "b", "*", "x"}]}], "]"}], "/", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", 
            RowBox[{"x", "^", "n"}]}]}], ")"}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"I", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"1", "+", 
           RowBox[{"I", "*", "a"}], "+", 
           RowBox[{"I", "*", "b", "*", "x"}]}], "]"}], "/", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", 
            RowBox[{"x", "^", "n"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"n", "==", "1"}], " ", "&&", " ", 
      RowBox[{"ZeroQ", "[", 
       RowBox[{
        RowBox[{"a", "*", "d"}], "-", 
        RowBox[{"b", "*", "c"}]}], "]"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{3.4940008732676563`*^9, 3.494023022748356*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox[
    RowBox[{"ArcTan", "[", 
     FractionBox["c", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}]], "]"}], "m"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.479616049603877*^9, {3.479616359880032*^9, 3.479616363935864*^9}, 
   3.47968672044456*^9, 3.4928223678463387`*^9, 3.4928258146763945`*^9, 
   3.494000873388663*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"ArcTan", "[", "z", "]"}], "=", 
   RowBox[{"ArcCot", "[", 
    FractionBox["1", "z"], "]"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664443126074*^9, 3.479664484795992*^9, {3.479686720494632*^9, 
   3.479686740223*^9}, {3.4940008734086637`*^9, 3.4940008734086637`*^9}, {
   3.4940009310099583`*^9, 3.4940009310099583`*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807051268772755`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox[
    RowBox[{"ArcTan", "[", 
     FractionBox["c", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}]], "]"}], "m"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{"u", " ", 
       SuperscriptBox[
        RowBox[{"ArcCot", "[", 
         RowBox[{
          FractionBox["a", "c"], "+", 
          FractionBox[
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}], "c"]}], "]"}], "m"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732428384`*^9, 3.479658002484886*^9}, {
   3.4796580646743107`*^9, 3.479658065695779*^9}, 3.4796611938939075`*^9, {
   3.4796867205046463`*^9, 3.479686740233014*^9}, 3.479694163016453*^9, 
   3.479694241058672*^9, {3.4928308514228463`*^9, 3.4928309174229383`*^9}, {
   3.4928311838033113`*^9, 3.4928311994833336`*^9}, 3.492831236813386*^9, {
   3.493250536928784*^9, 3.4932505561012177`*^9}, 3.4940008734266653`*^9, 
   3.4940009310229597`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"c_.", "/", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", 
           RowBox[{"x_", "^", "n_."}]}]}], ")"}]}], "]"}], "^", "m_."}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"u", "*", 
      RowBox[{
       RowBox[{"ArcCot", "[", 
        RowBox[{
         RowBox[{"a", "/", "c"}], "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"x", "^", "n"}], "/", "c"}]}]}], "]"}], "^", "m"}]}], ",", 
     "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "n", ",", "m"}], "}"}], ",", 
     "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{3.4940008734366655`*^9, 3.49400093103496*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"f", "[", 
     RowBox[{"x", ",", 
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}]}], "]"}], 
    RowBox[{"1", "-", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "2"]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.479616049603877*^9, {3.479616359880032*^9, 3.479616363935864*^9}, 
   3.47968672044456*^9, 3.4796940040278387`*^9, 3.492822371293945*^9, 
   3.492825811400389*^9, 3.494000873443666*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by substitution", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"f", "[", "z", "]"}], 
    RowBox[{"1", "+", 
     SuperscriptBox["z", "2"]}]], "=", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"Tan", "[", 
      RowBox[{"ArcTan", "[", "z", "]"}], "]"}], "]"}], " ", 
    RowBox[{
     SuperscriptBox["ArcTan", "\[Prime]",
      MultilineFunction->None], "[", "z", "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4796941282865133`*^9, {3.4799455651493073`*^9, 3.4799455651493073`*^9}, {
   3.4940008734626675`*^9, 3.4940008734686675`*^9}, {3.494042612778313*^9, 
   3.494042613308344*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"r", "+", 
    RowBox[{"s", " ", "x"}], "+", 
    RowBox[{"t", " ", 
     SuperscriptBox["x", "2"]}]}], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       SuperscriptBox["s", "2"], "-", 
       RowBox[{"4", " ", "r", " ", "t"}]}], 
      RowBox[{"4", " ", "t"}]]}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"s", "+", 
          RowBox[{"2", " ", "t", " ", "x"}]}], ")"}], "2"], 
       RowBox[{
        SuperscriptBox["s", "2"], "-", 
        RowBox[{"4", " ", "r", " ", "t"}]}]]}], ")"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4796941282865133`*^9, {3.4799455651493073`*^9, 3.4799455651493073`*^9}, {
   3.492803054651366*^9, 3.492803093277034*^9}, 3.4928031261930914`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"1", "+", 
    SuperscriptBox[
     RowBox[{"Tan", "[", "z", "]"}], "2"]}], "=", 
   SuperscriptBox[
    RowBox[{"Sec", "[", "z", "]"}], "2"]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4796941282865133`*^9, {3.4799455651493073`*^9, 3.4799455651493073`*^9}, {
   3.492803054651366*^9, 3.492803093277034*^9}, {3.4928031381427126`*^9, 
   3.4928031451783247`*^9}, {3.4940008734866686`*^9, 
   3.4940008734866686`*^9}, {3.494000970399212*^9, 3.494000970399212*^9}, {
   3.4940426210097837`*^9, 3.494042621302801*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.480705133626981*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"f", "[", 
     RowBox[{"x", ",", 
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}]}], "]"}], 
    RowBox[{"1", "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "2"]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "b"]}]}], " ", 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           FractionBox["a", "b"]}], "+", 
          FractionBox[
           RowBox[{"Tan", "[", "x", "]"}], "b"]}], ",", "x"}], "]"}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732428384`*^9, 3.479658002484886*^9}, {
   3.4796580646743107`*^9, 3.479658065695779*^9}, 3.4796611938939075`*^9, {
   3.4796867205046463`*^9, 3.479686740233014*^9}, 3.479694163016453*^9, 
   3.479694241058672*^9, {3.4940008735056696`*^9, 3.49400087350967*^9}, {
   3.4940427804809055`*^9, 3.4940427808229246`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"u_", "*", 
       RowBox[{"v_", "^", "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", 
    "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"tmp", "=", 
         RowBox[{"InverseFunctionOfLinear", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"ShowStep", "[", 
         RowBox[{
         "\"\<\>\"", ",", "\"\<Int[f[x,ArcTan[a+b*x]]/(1+(a+b*x)^2),x]\>\"", 
          ",", "\n", "\t\t   ", 
          "\"\<Subst[Int[f[-a/b+Tan[x]/b,x],x],x,ArcTan[a+b*x]]/b\>\"", ",", 
          RowBox[{"Hold", "[", "\n", "  ", 
           RowBox[{"Dist", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  RowBox[{"Discriminant", "[", 
                   RowBox[{"v", ",", "x"}], "]"}]}], "/", 
                 RowBox[{"(", 
                  RowBox[{"4", "*", 
                   RowBox[{"Coefficient", "[", 
                    RowBox[{"v", ",", "x", ",", "2"}], "]"}]}], ")"}]}], 
                ")"}], "^", "n"}], "/", 
              RowBox[{"Coefficient", "[", 
               RowBox[{
                RowBox[{"tmp", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], ",", "x", ",", "1"}], 
               "]"}]}], ",", "\n", "\t", 
             RowBox[{"Subst", "[", 
              RowBox[{
               RowBox[{"Int", "[", 
                RowBox[{
                 RowBox[{"Regularize", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"SubstForInverseFunction", "[", 
                    RowBox[{"u", ",", "tmp", ",", "x"}], "]"}], "*", 
                    RowBox[{
                    RowBox[{"Sec", "[", "x", "]"}], "^", 
                    RowBox[{"(", 
                    RowBox[{"2", "*", 
                    RowBox[{"(", 
                    RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], ",", "x"}], 
                  "]"}], ",", "x"}], "]"}], ",", " ", "x", ",", " ", "tmp"}], 
              "]"}]}], "]"}], "]"}]}], "]"}], " ", "/;", "\n", " ", 
        RowBox[{
         RowBox[{"NotFalseQ", "[", "tmp", "]"}], " ", "&&", " ", 
         RowBox[{
          RowBox[{"Head", "[", "tmp", "]"}], "===", "ArcTan"}], " ", "&&", 
         " ", 
         RowBox[{"ZeroQ", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Discriminant", "[", 
             RowBox[{"v", ",", "x"}], "]"}], "*", 
            RowBox[{
             RowBox[{"tmp", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "^", "2"}]}], "+", 
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{"v", ",", "x"}], "]"}], "^", "2"}]}], "]"}]}]}]}], "]"}],
      " ", "/;", "\n", 
     RowBox[{"SimplifyFlag", " ", "&&", " ", 
      RowBox[{"QuadraticQ", "[", 
       RowBox[{"v", ",", "x"}], "]"}], " ", "&&", " ", 
      RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
      RowBox[{"n", "<", "0"}], " ", "&&", " ", 
      RowBox[{"NegQ", "[", 
       RowBox[{"Discriminant", "[", 
        RowBox[{"v", ",", "x"}], "]"}], "]"}], " ", "&&", " ", 
      RowBox[{"MatchQ", "[", 
       RowBox[{"u", ",", 
        RowBox[{
         RowBox[{"r_.", "*", 
          RowBox[{"f_", "^", "w_"}]}], " ", "/;", " ", 
         RowBox[{"FreeQ", "[", 
          RowBox[{"f", ",", "x"}], "]"}]}]}], "]"}]}]}]}], ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"u_", "*", 
       RowBox[{"v_", "^", "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", 
    "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"tmp", "=", 
         RowBox[{"InverseFunctionOfLinear", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"Dist", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"Discriminant", "[", 
                RowBox[{"v", ",", "x"}], "]"}]}], "/", 
              RowBox[{"(", 
               RowBox[{"4", "*", 
                RowBox[{"Coefficient", "[", 
                 RowBox[{"v", ",", "x", ",", "2"}], "]"}]}], ")"}]}], ")"}], 
            "^", "n"}], "/", 
           RowBox[{"Coefficient", "[", 
            RowBox[{
             RowBox[{"tmp", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", "x", ",", "1"}], "]"}]}], 
          ",", "\n", "\t", 
          RowBox[{"Subst", "[", 
           RowBox[{
            RowBox[{"Int", "[", 
             RowBox[{
              RowBox[{"Regularize", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"SubstForInverseFunction", "[", 
                  RowBox[{"u", ",", "tmp", ",", "x"}], "]"}], "*", 
                 RowBox[{
                  RowBox[{"Sec", "[", "x", "]"}], "^", 
                  RowBox[{"(", 
                   RowBox[{"2", "*", 
                    RowBox[{"(", 
                    RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], ",", "x"}], 
               "]"}], ",", "x"}], "]"}], ",", " ", "x", ",", " ", "tmp"}], 
           "]"}]}], "]"}], " ", "/;", "\n", " ", 
        RowBox[{
         RowBox[{"NotFalseQ", "[", "tmp", "]"}], " ", "&&", " ", 
         RowBox[{
          RowBox[{"Head", "[", "tmp", "]"}], "===", "ArcTan"}], " ", "&&", 
         " ", 
         RowBox[{"ZeroQ", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Discriminant", "[", 
             RowBox[{"v", ",", "x"}], "]"}], "*", 
            RowBox[{
             RowBox[{"tmp", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "^", "2"}]}], "+", 
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{"v", ",", "x"}], "]"}], "^", "2"}]}], "]"}]}]}]}], "]"}],
      " ", "/;", "\n", 
     RowBox[{
      RowBox[{"QuadraticQ", "[", 
       RowBox[{"v", ",", "x"}], "]"}], " ", "&&", " ", 
      RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
      RowBox[{"n", "<", "0"}], " ", "&&", " ", 
      RowBox[{"NegQ", "[", 
       RowBox[{"Discriminant", "[", 
        RowBox[{"v", ",", "x"}], "]"}], "]"}], " ", "&&", " ", 
      RowBox[{"MatchQ", "[", 
       RowBox[{"u", ",", 
        RowBox[{
         RowBox[{"r_.", "*", 
          RowBox[{"f_", "^", "w_"}]}], " ", "/;", " ", 
         RowBox[{"FreeQ", "[", 
          RowBox[{"f", ",", "x"}], "]"}]}]}], "]"}]}]}]}]}], "]"}]], "Code",
 CellChangeTimes->{{3.4929838760355463`*^9, 3.492983880777954*^9}, {
   3.4929851720078225`*^9, 3.4929851812586384`*^9}, {3.4933231933196793`*^9, 
   3.4933231981696854`*^9}, {3.4933585331104183`*^9, 3.493358537618676*^9}, {
   3.4935714241857576`*^9, 3.493571428319765*^9}, {3.493588410361964*^9, 
   3.4935884965820847`*^9}, {3.4935885685121856`*^9, 
   3.4935886868223515`*^9}, {3.493588810472524*^9, 3.4935888483625774`*^9}, {
   3.494000873525671*^9, 3.4940008735436716`*^9}, {3.49400097247033*^9, 
   3.494000973146369*^9}, 3.4940427661900883`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"ArcTan", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["f", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}]]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, 3.4802882652733135`*^9, 3.480288373839424*^9, {
   3.480299236238787*^9, 3.480299238211624*^9}, {3.4803010920372944`*^9, 
   3.480301103143264*^9}, 3.492825791291954*^9, 3.4933227311790323`*^9, 
   3.494000874095703*^9, {3.494368993034052*^9, 3.4943689936040525`*^9}, {
   3.495386012163619*^9, 3.495386012463619*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"ArcTan", "[", "z", "]"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", 
       RowBox[{"\[ImaginaryI]", " ", "z"}]}], "]"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       RowBox[{"\[ImaginaryI]", " ", "z"}]}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.480300575514571*^9, 3.4803006163032227`*^9, {3.494000874114704*^9, 
   3.494000874114704*^9}, {3.494043137312315*^9, 3.494043137312315*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070519364328*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"ArcTan", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["f", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}]]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["I", "2"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"1", "-", 
        RowBox[{"I", " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["f", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}]]}]}], ")"}]}]}], "]"}], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["I", "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       RowBox[{"I", " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["f", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}]]}]}], ")"}]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.48029928226497*^9, 3.4802993300937443`*^9}, 
   3.4802995783907776`*^9, {3.480299703450605*^9, 3.480299715728259*^9}, 
   3.4940008741337056`*^9, {3.4940431424186068`*^9, 3.4940431752074823`*^9}, {
   3.494369000234062*^9, 3.4943690425441217`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"ArcTan", "[", 
     RowBox[{"a_.", "+", 
      RowBox[{"b_.", "*", 
       RowBox[{"f_", "^", 
        RowBox[{"(", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], ")"}]}]}]}], "]"}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"I", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"Log", "[", 
         RowBox[{"1", "-", 
          RowBox[{"I", "*", "a"}], "-", 
          RowBox[{"I", "*", "b", "*", 
           RowBox[{"f", "^", 
            RowBox[{"(", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], ")"}]}]}]}], "]"}], ",", "x"}], 
       "]"}]}], "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"I", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"Log", "[", 
         RowBox[{"1", "+", 
          RowBox[{"I", "*", "a"}], "+", 
          RowBox[{"I", "*", "b", "*", 
           RowBox[{"f", "^", 
            RowBox[{"(", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], ")"}]}]}]}], "]"}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "f"}], "}"}], ",", 
     "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{
  3.494000874144706*^9, {3.494043192703483*^9, 3.4940432117585726`*^9}, {
   3.4943679741526256`*^9, 3.4943679786926317`*^9}, {3.4943690611941476`*^9, 
   3.494369133684249*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   RowBox[{"ArcTan", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["f", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}]]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, 3.4802882652733135`*^9, 3.480288373839424*^9, {
   3.480299236238787*^9, 3.480299238211624*^9}, {3.4803010920372944`*^9, 
   3.480301103143264*^9}, 3.492825791291954*^9, 3.4933227311790323`*^9, 
   3.494000874095703*^9, {3.494368993034052*^9, 3.4943689936040525`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"ArcTan", "[", "z", "]"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", 
       RowBox[{"\[ImaginaryI]", " ", "z"}]}], "]"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       RowBox[{"\[ImaginaryI]", " ", "z"}]}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.480300575514571*^9, 3.4803006163032227`*^9, {3.494000874114704*^9, 
   3.494000874114704*^9}, {3.494043137312315*^9, 3.494043137312315*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"m", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055445578704`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"ArcTan", "[", 
     RowBox[{"b", " ", 
      SuperscriptBox["f", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}]]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["I", "2"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox["x", "m"], " ", 
      RowBox[{"Log", "[", 
       RowBox[{"1", "-", 
        RowBox[{"I", " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["f", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}]]}]}], ")"}]}]}], "]"}], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["I", "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       RowBox[{"I", " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["f", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}]]}]}], ")"}]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.480299282274984*^9, 3.4802993007415376`*^9}, {
   3.480299332717517*^9, 3.4802993335386972`*^9}, {3.48029943364264*^9, 
   3.480299444237875*^9}, 3.480299578400792*^9, 3.480299657564624*^9, {
   3.480299717951456*^9, 3.480299731180478*^9}, 3.4803000540747776`*^9, {
   3.480300090066531*^9, 3.480300092169555*^9}, 3.480300126899494*^9, 
   3.480705548133011*^9, 3.494000874183708*^9, {3.494043260041334*^9, 
   3.4940432729970756`*^9}, {3.4943691433242626`*^9, 3.494369147484268*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"ArcTan", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"f_", "^", 
         RowBox[{"(", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], ")"}]}]}]}], "]"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"I", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{"Log", "[", 
          RowBox[{"1", "-", 
           RowBox[{"I", "*", "a"}], "-", 
           RowBox[{"I", "*", "b", "*", 
            RowBox[{"f", "^", 
             RowBox[{"(", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], ")"}]}]}]}], "]"}]}], ",", "x"}], 
       "]"}]}], "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"I", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{"Log", "[", 
          RowBox[{"1", "+", 
           RowBox[{"I", "*", "a"}], "+", 
           RowBox[{"I", "*", "b", "*", 
            RowBox[{"f", "^", 
             RowBox[{"(", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], ")"}]}]}]}], "]"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "f"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{
  3.494000874193709*^9, {3.494043287958931*^9, 3.4940433030517945`*^9}, {
   3.49436916272429*^9, 3.4943691788343124`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"v", " ", 
   RowBox[{"ArcTan", "[", "u", "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160783652334`*^9, 3.4796867206047907`*^9, 3.492825781557537*^9, 
   3.4940008742017097`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell["Rule: If u is free of inverse functions, then", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703531363038*^9, 
   3.4807035352686543`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"ArcTan", "[", "u", "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "x"}]}], " ", 
    RowBox[{"ArcTan", "[", "u", "]"}]}]}], "-", 
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"x", " ", 
      RowBox[{
       SubscriptBox["\[PartialD]", "x"], "u"}]}], 
     RowBox[{"1", "+", 
      SuperscriptBox["u", "2"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579734230976`*^9, 3.4796580026851745`*^9}, {
   3.479658101347043*^9, 3.479658102348483*^9}, {3.4796582237129965`*^9, 
   3.4796582279090304`*^9}, {3.4796611944647284`*^9, 3.4796612203719807`*^9}, 
   3.4796613933206687`*^9, {3.4796614761798143`*^9, 3.4796614777420607`*^9}, 
   3.4796618658000607`*^9, {3.4796619856624146`*^9, 3.4796619866938972`*^9}, {
   3.4796645712002354`*^9, 3.4796645805536847`*^9}, 3.4796646283424015`*^9, {
   3.4796867206148047`*^9, 3.4796867206148047`*^9}, {3.479687667676613*^9, 
   3.479687667926973*^9}, 3.480705232098576*^9, {3.49400087421271*^9, 
   3.49400087421371*^9}, {3.494022456770984*^9, 3.4940224580430565`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"ArcTan", "[", "u_", "]"}], ",", "x_Symbol"}], "]"}], " ", ":=", 
  "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{"ArcTan", "[", "u", "]"}]}], " ", "-", "\n", "  ", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"Regularize", "[", 
       RowBox[{
        RowBox[{"x", "*", 
         RowBox[{
          RowBox[{"D", "[", 
           RowBox[{"u", ",", "x"}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"u", "^", "2"}]}], ")"}]}]}], ",", "x"}], "]"}], ",", 
      "x"}], "]"}]}], " ", "/;", "\n", 
   RowBox[{"InverseFunctionFreeQ", "[", 
    RowBox[{"u", ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.49400087422171*^9, 3.4940008742237105`*^9}, {
   3.494022461285242*^9, 3.4940224616042604`*^9}, {3.4943679225725536`*^9, 
   3.494367962262609*^9}, 3.4943692604044266`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}], "\[And]"}]]],
 " u is free of inverse functions, then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.4807035587524223`*^9, 
   3.4807036202508526`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"ArcTan", "[", "u", "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        RowBox[{"ArcTan", "[", "u", "]"}]}], 
       RowBox[{"m", "+", "1"}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"m", "+", "1"}]], " ", 
       RowBox[{
        SubscriptBox["\[PartialD]", "x"], "u"}]}], 
      RowBox[{"1", "+", 
       SuperscriptBox["u", "2"]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.479657973433112*^9, 3.4796580026951885`*^9}, {
   3.479658110380032*^9, 3.479658111381472*^9}, {3.47965823109361*^9, 
   3.4796582349191103`*^9}, {3.479658630027248*^9, 3.4796586331817837`*^9}, {
   3.4796611944747424`*^9, 3.479661220542226*^9}, 3.479661393330683*^9, {
   3.4796614834602833`*^9, 3.4796614855532928`*^9}, {3.4796616350883136`*^9, 
   3.4796616397950816`*^9}, 3.4796618737314653`*^9, 3.479662021574053*^9, 
   3.4796645886853776`*^9, {3.4796867206248193`*^9, 3.4796867206248193`*^9}, {
   3.479687711189181*^9, 3.479687711749987*^9}, 3.480705245037181*^9, {
   3.4940008742367115`*^9, 3.4940008742387114`*^9}, {3.49402252295177*^9, 
   3.494022523868822*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"ArcTan", "[", "u_", "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"ArcTan", "[", "u", "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"Regularize", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", 
            RowBox[{"(", 
             RowBox[{"m", "+", "1"}], ")"}]}], "*", 
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{"u", ",", "x"}], "]"}], "/", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"u", "^", "2"}]}], ")"}]}]}], ",", "x"}], "]"}], ",", 
        "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"m", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"InverseFunctionFreeQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", "\n", "\t", 
    RowBox[{"Not", "[", 
     RowBox[{"FunctionOfQ", "[", 
      RowBox[{
       RowBox[{"x", "^", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ",", "u", ",", "x"}], "]"}], "]"}],
     " ", "&&", " ", "\n", "\t", 
    RowBox[{"FalseQ", "[", 
     RowBox[{"PowerVariableExpn", "[", 
      RowBox[{"u", ",", 
       RowBox[{"m", "+", "1"}], ",", "x"}], "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494000874248712*^9, 3.4940008742507124`*^9}, {
  3.4940225275160303`*^9, 3.4940225278660507`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell[TextData[{
 "Rule: If u is free of inverse functions, let  ",
 Cell[BoxData[
  RowBox[{"w", "=", 
   RowBox[{"\[Integral]", 
    RowBox[{"v", 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]]],
 ", if w is free of inverse functions, then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703639939163*^9, 
   3.4807036911227617`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{"v", " ", 
    RowBox[{"ArcTan", "[", "u", "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "w"}]}], " ", 
    RowBox[{"ArcTan", "[", "u", "]"}]}]}], "-", 
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"w", " ", 
      RowBox[{
       SubscriptBox["\[PartialD]", "x"], "u"}]}], 
     RowBox[{"1", "+", 
      SuperscriptBox["u", "2"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579734531407`*^9, 3.479658002705203*^9}, {
   3.479658122026779*^9, 3.479658123318637*^9}, {3.4796582402567854`*^9, 
   3.479658243621624*^9}, {3.479658719025221*^9, 3.479658746965397*^9}, {
   3.4796611944747424`*^9, 3.4796612207224846`*^9}, 3.4796613933406973`*^9, {
   3.4796614896692114`*^9, 3.479661491792264*^9}, {3.479661879599904*^9, 
   3.479661922882141*^9}, 3.4796620342622976`*^9, {3.4796645916195965`*^9, 
   3.4796646241063104`*^9}, {3.4796867206348333`*^9, 
   3.4796867206348333`*^9}, {3.4796877839337826`*^9, 3.479687784174128*^9}, 
   3.480705260379242*^9, {3.494000874263713*^9, 3.4940008742657127`*^9}, {
   3.4940225319442835`*^9, 3.4940225328513355`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"v_", "*", 
     RowBox[{"ArcTan", "[", "u_", "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"w", "=", 
       RowBox[{"Block", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ShowSteps", "=", "False"}], ",", 
           RowBox[{"StepCounter", "=", "Null"}]}], "}"}], ",", " ", 
         RowBox[{"Int", "[", 
          RowBox[{"v", ",", "x"}], "]"}]}], "]"}]}], "}"}], ",", "  ", "\n", 
     "  ", 
     RowBox[{
      RowBox[{
       RowBox[{"w", "*", 
        RowBox[{"ArcTan", "[", "u", "]"}]}], " ", "-", "\n", "  ", 
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{"w", "*", 
            RowBox[{
             RowBox[{"D", "[", 
              RowBox[{"u", ",", "x"}], "]"}], "/", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"u", "^", "2"}]}], ")"}]}]}], ",", "x"}], "]"}], ",", 
         "x"}], "]"}]}], " ", "/;", "\n", " ", 
      RowBox[{"InverseFunctionFreeQ", "[", 
       RowBox[{"w", ",", "x"}], "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"InverseFunctionFreeQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", "\n", "\t", 
    RowBox[{"Not", "[", 
     RowBox[{"MatchQ", "[", 
      RowBox[{"v", ",", " ", 
       RowBox[{
        RowBox[{"x", "^", "m_."}], " ", "/;", " ", 
        RowBox[{"FreeQ", "[", 
         RowBox[{"m", ",", "x"}], "]"}]}]}], "]"}], "]"}], " ", "&&", "\n", 
    "\t", 
    RowBox[{"FalseQ", "[", 
     RowBox[{"FunctionOfLinear", "[", 
      RowBox[{
       RowBox[{"v", "*", 
        RowBox[{"ArcTan", "[", "u", "]"}]}], ",", "x"}], "]"}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494000874275714*^9, 3.4940008742797136`*^9}, {
   3.49402253624553*^9, 3.4940225365725484`*^9}, 3.494022633611099*^9},
 Background->GrayLevel[0.85]]
}, Closed]]
},
AutoGeneratedPackage->Automatic,
CellGrouping->Manual,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  "Integration Rules for Inverse Tangent Functions", None, None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->28.8},
Magnification->1.399999976158142,
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 879, 19, 118, "Title"],
Cell[1449, 43, 186, 3, 495, "Subsubsection"],
Cell[1638, 48, 57, 0, 340, "Subsubsection"],
Cell[1698, 50, 613, 9, 340, "Subsubsection"],
Cell[2314, 61, 944, 25, 956, "Subsubtitle"],
Cell[3261, 88, 771, 11, 495, "Subsubsection"],
Cell[4035, 101, 879, 25, 1510, "Code"],
Cell[4917, 128, 89, 2, 495, "Subsubsection"],
Cell[5009, 132, 57, 0, 340, "Subsubsection"],
Cell[5069, 134, 827, 16, 365, "Subsubsection"],
Cell[5899, 152, 1682, 40, 929, "Subsubtitle"],
Cell[7584, 194, 771, 11, 495, "Subsubsection"],
Cell[8358, 207, 1339, 40, 1882, "Code"],
Cell[9700, 249, 44, 1, 37, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[9781, 255, 912, 20, 80, "Title"],
Cell[10696, 277, 187, 2, 354, "Subsubsection"],
Cell[10886, 281, 1104, 20, 261, "Subsubsection"],
Cell[11993, 303, 1664, 43, 664, "Subsubtitle"],
Cell[13660, 348, 819, 11, 354, "Subsubsection"],
Cell[14482, 361, 2367, 58, 1345, "Code"],
Cell[16852, 421, 89, 2, 354, "Subsubsection"],
Cell[16944, 425, 187, 2, 243, "Subsubsection"],
Cell[17134, 429, 1203, 22, 261, "Subsubsection"],
Cell[18340, 453, 2610, 73, 1320, "Subsubtitle"],
Cell[20953, 528, 819, 11, 354, "Subsubsection"],
Cell[21775, 541, 3580, 95, 1605, "Code"],
Cell[25358, 638, 89, 2, 354, "Subsubsection"],
Cell[25450, 642, 125, 1, 243, "Subsubsection"],
Cell[25578, 645, 902, 17, 261, "Subsubsection"],
Cell[26483, 664, 1786, 49, 848, "Subsubtitle"],
Cell[28272, 715, 771, 11, 354, "Subsubsection"],
Cell[29046, 728, 1955, 57, 1345, "Code"],
Cell[31004, 787, 89, 2, 354, "Subsubsection"],
Cell[31096, 791, 125, 1, 243, "Subsubsection"],
Cell[31224, 794, 1006, 19, 261, "Subsubsection"],
Cell[32233, 815, 1528, 41, 737, "Subsubtitle"],
Cell[33764, 858, 771, 11, 354, "Subsubsection"],
Cell[34538, 871, 2172, 54, 1345, "Code"],
Cell[36713, 927, 89, 2, 354, "Subsubsection"],
Cell[36805, 931, 314, 5, 243, "Subsubsection"],
Cell[37122, 938, 1304, 23, 261, "Subsubsection"],
Cell[38429, 963, 1838, 49, 664, "Subsubtitle"],
Cell[40270, 1014, 819, 11, 354, "Subsubsection"],
Cell[41092, 1027, 2561, 62, 1345, "Code"],
Cell[43656, 1091, 89, 2, 354, "Subsubsection"],
Cell[43748, 1095, 245, 3, 243, "Subsubsection"],
Cell[43996, 1100, 1371, 25, 261, "Subsubsection"],
Cell[45370, 1127, 2562, 70, 1296, "Subsubtitle"],
Cell[47935, 1199, 819, 11, 354, "Subsubsection"],
Cell[48757, 1212, 3564, 93, 1605, "Code"],
Cell[52324, 1307, 44, 1, 27, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[52405, 1313, 1083, 24, 88, "Title"],
Cell[53491, 1339, 154, 2, 1896, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[53648, 1343, 1428, 29, 1955, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[55079, 1374, 2298, 59, 4555, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[57380, 1435, 771, 11, 1896, "Subsubsection"],
Cell[58154, 1448, 3693, 89, 7225, "Code"],
Cell[61850, 1539, 44, 1, 138, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[61931, 1545, 1188, 27, 88, "Title"],
Cell[63122, 1574, 154, 2, 1896, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[63279, 1578, 1484, 30, 1955, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[64766, 1610, 2471, 63, 4555, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[67240, 1675, 771, 11, 1896, "Subsubsection"],
Cell[68014, 1688, 4049, 95, 7225, "Code"],
Cell[72066, 1785, 89, 2, 1896, "Subsubsection"],
Cell[72158, 1789, 154, 2, 1300, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[72315, 1793, 1478, 30, 1955, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[73796, 1825, 2449, 63, 4555, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[76248, 1890, 771, 11, 1896, "Subsubsection"],
Cell[77022, 1903, 4032, 95, 7225, "Code"],
Cell[81057, 2000, 89, 2, 1896, "Subsubsection"],
Cell[81149, 2004, 61, 0, 1300, "Subsubsection"],
Cell[81213, 2006, 645, 19, 2113, "Subsubsection"],
Cell[81861, 2027, 1576, 31, 1397, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[83440, 2060, 1760, 48, 3554, "Subsubtitle"],
Cell[85203, 2110, 771, 11, 1896, "Subsubsection"],
Cell[85977, 2123, 3744, 86, 7225, "Code"],
Cell[89724, 2211, 89, 2, 1896, "Subsubsection"],
Cell[89816, 2215, 61, 0, 1300, "Subsubsection"],
Cell[89880, 2217, 723, 21, 2113, "Subsubsection"],
Cell[90606, 2240, 1699, 34, 1397, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[92308, 2276, 1812, 48, 3554, "Subsubtitle"],
Cell[94123, 2326, 771, 11, 1896, "Subsubsection"],
Cell[94897, 2339, 3753, 86, 7225, "Code"],
Cell[98653, 2427, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[98734, 2433, 1135, 25, 91, "Title"],
Cell[99872, 2460, 188, 3, 67, "Subsubsection"],
Cell[100063, 2465, 1303, 23, 50, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[101369, 2490, 1315, 30, 130, "Subsubtitle"],
Cell[102687, 2522, 771, 11, 67, "Subsubsection"],
Cell[103461, 2535, 1822, 44, 202, "Code"],
Cell[105286, 2581, 89, 2, 67, "Subsubsection"],
Cell[105378, 2585, 107, 1, 47, "Subsubsection"],
Cell[105488, 2588, 1366, 27, 67, "Subsubsection"],
Cell[106857, 2617, 1395, 32, 128, "Subsubtitle"],
Cell[108255, 2651, 771, 11, 67, "Subsubsection"],
Cell[109029, 2664, 1991, 49, 202, "Code"],
Cell[111023, 2715, 44, 1, 6, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[111104, 2721, 1164, 27, 91, "Title"],
Cell[112271, 2750, 56, 0, 10190, "Subsubsection"],
Cell[112330, 2752, 945, 29, 12738, "Subsubsection"],
Cell[113278, 2783, 1419, 26, 10190, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[114700, 2811, 2473, 57, 19730, "Subsubtitle"],
Cell[117176, 2870, 771, 11, 10190, "Subsubsection"],
Cell[117950, 2883, 2970, 73, 38849, "Code"],
Cell[120923, 2958, 89, 2, 10190, "Subsubsection"],
Cell[121015, 2962, 56, 0, 6984, "Subsubsection"],
Cell[121074, 2964, 1165, 32, 12738, "Subsubsection"],
Cell[122242, 2998, 1465, 27, 10190, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[123710, 3027, 2481, 58, 21274, "Subsubtitle"],
Cell[126194, 3087, 771, 11, 10190, "Subsubsection"],
Cell[126968, 3100, 3084, 75, 38849, "Code"],
Cell[130055, 3177, 89, 2, 10190, "Subsubsection"],
Cell[130147, 3181, 56, 0, 6984, "Subsubsection"],
Cell[130206, 3183, 1117, 32, 12738, "Subsubsection"],
Cell[131326, 3217, 1469, 27, 10190, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[132798, 3246, 2450, 57, 19730, "Subsubtitle"],
Cell[135251, 3305, 771, 11, 10190, "Subsubsection"],
Cell[136025, 3318, 3131, 75, 38849, "Code"],
Cell[139159, 3395, 89, 2, 10190, "Subsubsection"],
Cell[139251, 3399, 56, 0, 6984, "Subsubsection"],
Cell[139310, 3401, 930, 25, 14265, "Subsubsection"],
Cell[140243, 3428, 1378, 26, 10190, "Subsubsection"],
Cell[141624, 3456, 1836, 50, 19161, "Subsubtitle"],
Cell[143463, 3508, 771, 11, 10190, "Subsubsection"],
Cell[144237, 3521, 2926, 76, 38849, "Code"],
Cell[147166, 3599, 89, 2, 10190, "Subsubsection"],
Cell[147258, 3603, 56, 0, 6984, "Subsubsection"],
Cell[147317, 3605, 1006, 26, 14265, "Subsubsection"],
Cell[148326, 3633, 1449, 27, 10190, "Subsubsection"],
Cell[149778, 3662, 1910, 50, 19161, "Subsubtitle"],
Cell[151691, 3714, 771, 11, 10190, "Subsubsection"],
Cell[152465, 3727, 2857, 75, 38849, "Code"],
Cell[155325, 3804, 89, 2, 10190, "Subsubsection"],
Cell[155417, 3808, 64, 0, 6984, "Subsubsection"],
Cell[155484, 3810, 1622, 46, 12052, "Subsubsection"],
Cell[157109, 3858, 2139, 43, 10190, "Subsubsection"],
Cell[159251, 3903, 2272, 49, 18895, "Subsubtitle"],
Cell[161526, 3954, 771, 11, 10190, "Subsubsection"],
Cell[162300, 3967, 2672, 69, 31169, "Code"],
Cell[164975, 4038, 89, 2, 10190, "Subsubsection"],
Cell[165067, 4042, 64, 0, 6984, "Subsubsection"],
Cell[165134, 4044, 1562, 40, 12052, "Subsubsection"],
Cell[166699, 4086, 2190, 44, 10190, "Subsubsection"],
Cell[168892, 4132, 2387, 51, 18895, "Subsubtitle"],
Cell[171282, 4185, 771, 11, 10190, "Subsubsection"],
Cell[172056, 4198, 2655, 68, 31169, "Code"],
Cell[174714, 4268, 44, 1, 737, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[174795, 4274, 1414, 30, 91, "Title"],
Cell[176212, 4306, 61, 0, 7279, "Subsubsection"],
Cell[176276, 4308, 689, 19, 7754, "Subsubsection"],
Cell[176968, 4329, 2128, 47, 8609, "Subsubsection"],
Cell[179099, 4378, 1788, 52, 13497, "Subsubtitle"],
Cell[180890, 4432, 771, 11, 7279, "Subsubsection"],
Cell[181664, 4445, 4260, 109, 27750, "Code"],
Cell[185927, 4556, 44, 1, 527, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[186008, 4562, 1192, 27, 91, "Title"],
Cell[187203, 4591, 57, 0, 5200, "Subsubsection"],
Cell[187263, 4593, 1931, 39, 6150, "Subsubsection"],
Cell[189197, 4634, 1716, 50, 9777, "Subsubtitle"],
Cell[190916, 4686, 771, 11, 5200, "Subsubsection"],
Cell[191690, 4699, 3481, 90, 19822, "Code"],
Cell[195174, 4791, 89, 2, 5200, "Subsubsection"],
Cell[195266, 4795, 57, 0, 3564, "Subsubsection"],
Cell[195326, 4797, 1831, 38, 6150, "Subsubsection"],
Cell[197160, 4837, 1774, 51, 9777, "Subsubtitle"],
Cell[198937, 4890, 771, 11, 5200, "Subsubsection"],
Cell[199711, 4903, 3507, 91, 19822, "Code"],
Cell[203221, 4996, 44, 1, 377, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[203302, 5002, 1223, 28, 91, "Title"],
Cell[204528, 5032, 57, 0, 7279, "Subsubsection"],
Cell[204588, 5034, 1726, 35, 8609, "Subsubsection"],
Cell[206317, 5071, 2124, 57, 26825, "Subsubtitle"],
Cell[208444, 5130, 771, 11, 7279, "Subsubsection"],
Cell[209218, 5143, 3231, 87, 27750, "Code"],
Cell[212452, 5232, 89, 2, 7279, "Subsubsection"],
Cell[212544, 5236, 57, 0, 4989, "Subsubsection"],
Cell[212604, 5238, 1678, 35, 8609, "Subsubsection"],
Cell[214285, 5275, 2106, 57, 26825, "Subsubtitle"],
Cell[216394, 5334, 771, 11, 7279, "Subsubsection"],
Cell[217168, 5347, 3343, 88, 27750, "Code"],
Cell[220514, 5437, 44, 1, 527, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[220595, 5443, 1257, 29, 91, "Title"],
Cell[221855, 5474, 1342, 24, 36, "Subsubsection"],
Cell[223200, 5500, 1511, 40, 67, "Subsubtitle"],
Cell[224714, 5542, 771, 11, 35, "Subsubsection"],
Cell[225488, 5555, 1739, 50, 104, "Code"],
Cell[227230, 5607, 89, 2, 35, "Subsubsection"],
Cell[227322, 5611, 57, 0, 25, "Subsubsection"],
Cell[227382, 5613, 1148, 24, 35, "Subsubsection"],
Cell[228533, 5639, 2993, 74, 126, "Subsubtitle"],
Cell[231529, 5715, 771, 11, 35, "Subsubsection"],
Cell[232303, 5728, 2660, 77, 129, "Code"],
Cell[234966, 5807, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[235047, 5813, 1149, 26, 80, "Title"],
Cell[236199, 5841, 89, 2, 1896, "Subsubsection"],
Cell[236291, 5845, 1161, 23, 1896, "Subsubsection"],
Cell[237455, 5870, 2396, 69, 5408, "Subsubtitle"],
Cell[239854, 5941, 771, 11, 1896, "Subsubsection"],
Cell[240628, 5954, 3346, 87, 8625, "Code"],
Cell[243977, 6043, 89, 2, 1896, "Subsubsection"],
Cell[244069, 6047, 943, 25, 3317, "Subsubsection"],
Cell[245015, 6074, 1162, 24, 1896, "Subsubsection"],
Cell[246180, 6100, 1447, 42, 4975, "Subsubtitle"],
Cell[247630, 6144, 771, 11, 1896, "Subsubsection"],
Cell[248404, 6157, 2428, 61, 5797, "Code"],
Cell[250835, 6220, 89, 2, 1896, "Subsubsection"],
Cell[250927, 6224, 1095, 21, 1397, "Subsubsection"],
Cell[252025, 6247, 1336, 39, 4428, "Subsubtitle"],
Cell[253364, 6288, 771, 11, 1896, "Subsubsection"],
Cell[254138, 6301, 2026, 54, 7225, "Code"],
Cell[256167, 6357, 89, 2, 1896, "Subsubsection"],
Cell[256259, 6361, 1501, 27, 1896, "Subsubsection"],
Cell[257763, 6390, 2531, 69, 4428, "Subsubtitle"],
Cell[260297, 6461, 771, 11, 1896, "Subsubsection"],
Cell[261071, 6474, 3799, 98, 8625, "Code"],
Cell[264873, 6574, 89, 2, 1896, "Subsubsection"],
Cell[264965, 6578, 1600, 30, 1896, "Subsubsection"],
Cell[266568, 6610, 3117, 84, 13026, "Subsubtitle"],
Cell[269688, 6696, 771, 11, 1896, "Subsubsection"],
Cell[270462, 6709, 4149, 110, 8625, "Code"],
Cell[274614, 6821, 89, 2, 1896, "Subsubsection"],
Cell[274706, 6825, 1204, 23, 1896, "Subsubsection"],
Cell[275913, 6850, 2337, 66, 10337, "Subsubtitle"],
Cell[278253, 6918, 771, 11, 1896, "Subsubsection"],
Cell[279027, 6931, 2745, 80, 8625, "Code"],
Cell[281775, 7013, 89, 2, 1896, "Subsubsection"],
Cell[281867, 7017, 1483, 29, 11360, "Subsubsection"],
Cell[283353, 7048, 2461, 70, 36105, "Subsubtitle"],
Cell[285817, 7120, 771, 11, 10190, "Subsubsection"],
Cell[286591, 7133, 3214, 93, 46380, "Code"],
Cell[289808, 7228, 89, 2, 10190, "Subsubsection"],
Cell[289900, 7232, 1585, 31, 11360, "Subsubsection"],
Cell[291488, 7265, 3277, 96, 54388, "Subsubtitle"],
Cell[294768, 7363, 771, 11, 10190, "Subsubsection"],
Cell[295542, 7376, 4747, 135, 54136, "Code"],
Cell[300292, 7513, 89, 2, 10190, "Subsubsection"],
Cell[300384, 7517, 57, 0, 6984, "Subsubsection"],
Cell[300444, 7519, 1936, 36, 1896, "Subsubsection"],
Cell[302383, 7557, 2795, 68, 6669, "Subsubtitle"],
Cell[305181, 7627, 771, 11, 1896, "Subsubsection"],
Cell[305955, 7640, 4138, 100, 7225, "Code"],
Cell[310096, 7742, 89, 2, 1896, "Subsubsection"],
Cell[310188, 7746, 64, 0, 1300, "Subsubsection"],
Cell[310255, 7748, 1574, 41, 2020, "Subsubsection"],
Cell[311832, 7791, 1924, 41, 1896, "Subsubsection"],
Cell[313759, 7834, 2213, 48, 3372, "Subsubtitle"],
Cell[315975, 7884, 771, 11, 1896, "Subsubsection"],
Cell[316749, 7897, 2630, 69, 5797, "Code"],
Cell[319382, 7968, 89, 2, 1896, "Subsubsection"],
Cell[319474, 7972, 1529, 39, 3554, "Subsubsection"],
Cell[321006, 8013, 1889, 42, 2113, "Subsubsection"],
Cell[322898, 8057, 2503, 60, 4975, "Subsubtitle"],
Cell[325404, 8119, 771, 11, 1896, "Subsubsection"],
Cell[326178, 8132, 2830, 78, 5797, "Code"],
Cell[329011, 8212, 44, 1, 138, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[329092, 8218, 1229, 28, 80, "Title"],
Cell[330324, 8248, 229, 3, 130, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[330556, 8253, 1827, 33, 167, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[332386, 8288, 2277, 60, 261, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[334666, 8350, 771, 11, 130, "Subsubsection"],
Cell[335440, 8363, 3076, 82, 491, "Code"],
Cell[338519, 8447, 89, 2, 130, "Subsubsection"],
Cell[338611, 8451, 1706, 29, 130, "Subsubsection"],
Cell[340320, 8482, 2892, 71, 263, "Subsubtitle"],
Cell[343215, 8555, 771, 11, 130, "Subsubsection"],
Cell[343989, 8568, 3261, 83, 491, "Code"],
Cell[347253, 8653, 89, 2, 130, "Subsubsection"],
Cell[347345, 8657, 1698, 31, 130, "Subsubsection"],
Cell[349046, 8690, 3524, 94, 550, "Subsubtitle"],
Cell[352573, 8786, 771, 11, 130, "Subsubsection"],
Cell[353347, 8799, 4038, 110, 586, "Code"],
Cell[357388, 8911, 89, 2, 130, "Subsubsection"],
Cell[357480, 8915, 125, 1, 90, "Subsubsection"],
Cell[357608, 8918, 2423, 47, 130, "Subsubsection"],
Cell[360034, 8967, 2983, 74, 453, "Subsubtitle"],
Cell[363020, 9043, 771, 11, 130, "Subsubsection"],
Cell[363794, 9056, 4218, 103, 491, "Code"],
Cell[368015, 9161, 89, 2, 130, "Subsubsection"],
Cell[368107, 9165, 125, 1, 90, "Subsubsection"],
Cell[368235, 9168, 2312, 44, 130, "Subsubsection"],
Cell[370550, 9214, 2904, 73, 453, "Subsubtitle"],
Cell[373457, 9289, 771, 11, 130, "Subsubsection"],
Cell[374231, 9302, 4217, 103, 491, "Code"],
Cell[378451, 9407, 89, 2, 130, "Subsubsection"],
Cell[378543, 9411, 56, 0, 90, "Subsubsection"],
Cell[378602, 9413, 930, 25, 181, "Subsubsection"],
Cell[379535, 9440, 2170, 42, 130, "Subsubsection"],
Cell[381708, 9484, 2376, 62, 222, "Subsubtitle"],
Cell[384087, 9548, 771, 11, 130, "Subsubsection"],
Cell[384861, 9561, 3890, 95, 491, "Code"],
Cell[388754, 9658, 89, 2, 130, "Subsubsection"],
Cell[388846, 9662, 56, 0, 90, "Subsubsection"],
Cell[388905, 9664, 1006, 26, 181, "Subsubsection"],
Cell[389914, 9692, 2376, 45, 130, "Subsubsection"],
Cell[392293, 9739, 2196, 57, 222, "Subsubtitle"],
Cell[394492, 9798, 771, 11, 130, "Subsubsection"],
Cell[395266, 9811, 3521, 88, 491, "Code"],
Cell[398790, 9901, 89, 2, 130, "Subsubsection"],
Cell[398882, 9905, 125, 1, 90, "Subsubsection"],
Cell[399010, 9908, 2421, 46, 130, "Subsubsection"],
Cell[401434, 9956, 3438, 93, 495, "Subsubtitle"],
Cell[404875, 10051, 771, 11, 130, "Subsubsection"],
Cell[405649, 10064, 5118, 129, 586, "Code"],
Cell[410770, 10195, 89, 2, 130, "Subsubsection"],
Cell[410862, 10199, 125, 1, 90, "Subsubsection"],
Cell[410990, 10202, 2273, 44, 130, "Subsubsection"],
Cell[413266, 10248, 3299, 91, 482, "Subsubtitle"],
Cell[416568, 10341, 771, 11, 130, "Subsubsection"],
Cell[417342, 10354, 5176, 130, 586, "Code"],
Cell[422521, 10486, 89, 2, 130, "Subsubsection"],
Cell[422613, 10490, 64, 0, 90, "Subsubsection"],
Cell[422680, 10492, 2363, 65, 144, "Subsubsection"],
Cell[425046, 10559, 2374, 51, 130, "Subsubsection"],
Cell[427423, 10612, 2790, 64, 233, "Subsubtitle"],
Cell[430216, 10678, 771, 11, 130, "Subsubsection"],
Cell[430990, 10691, 3973, 98, 394, "Code"],
Cell[434966, 10791, 89, 2, 130, "Subsubsection"],
Cell[435058, 10795, 64, 0, 90, "Subsubsection"],
Cell[435125, 10797, 1954, 50, 145, "Subsubsection"],
Cell[437082, 10849, 2367, 50, 130, "Subsubsection"],
Cell[439452, 10901, 2539, 55, 230, "Subsubtitle"],
Cell[441994, 10958, 771, 11, 130, "Subsubsection"],
Cell[442768, 10971, 3078, 80, 394, "Code"],
Cell[445849, 11053, 89, 2, 130, "Subsubsection"],
Cell[445941, 11057, 1553, 39, 242, "Subsubsection"],
Cell[447497, 11098, 1988, 43, 145, "Subsubsection"],
Cell[449488, 11143, 2697, 63, 338, "Subsubtitle"],
Cell[452188, 11208, 771, 11, 130, "Subsubsection"],
Cell[452962, 11221, 3068, 82, 394, "Code"],
Cell[456033, 11305, 44, 1, 11, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[456114, 11311, 1098, 23, 80, "Title"],
Cell[457215, 11336, 186, 3, 495, "Subsubsection"],
Cell[457404, 11341, 57, 0, 340, "Subsubsection"],
Cell[457464, 11343, 654, 9, 340, "Subsubsection"],
Cell[458121, 11354, 1478, 37, 956, "Subsubtitle"],
Cell[459602, 11393, 771, 11, 495, "Subsubsection"],
Cell[460376, 11406, 1183, 35, 1510, "Code"],
Cell[461562, 11443, 89, 2, 495, "Subsubsection"],
Cell[461654, 11447, 186, 3, 340, "Subsubsection"],
Cell[461843, 11452, 57, 0, 340, "Subsubsection"],
Cell[461903, 11454, 740, 14, 365, "Subsubsection"],
Cell[462646, 11470, 1572, 40, 916, "Subsubtitle"],
Cell[464221, 11512, 771, 11, 495, "Subsubsection"],
Cell[464995, 11525, 1415, 42, 1882, "Code"],
Cell[466413, 11569, 44, 1, 37, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[466494, 11575, 871, 20, 80, "Title"],
Cell[467368, 11597, 56, 0, 495, "Subsubsection"],
Cell[467427, 11599, 764, 21, 527, "Subsubsection"],
Cell[468194, 11622, 613, 9, 340, "Subsubsection"],
Cell[468810, 11633, 1373, 40, 929, "Subsubtitle"],
Cell[470186, 11675, 771, 11, 495, "Subsubsection"],
Cell[470960, 11688, 1317, 41, 1882, "Code"],
Cell[472280, 11731, 89, 2, 495, "Subsubsection"],
Cell[472372, 11735, 132, 1, 340, "Subsubsection"],
Cell[472507, 11738, 57, 0, 340, "Subsubsection"],
Cell[472567, 11740, 1133, 23, 365, "Subsubsection"],
Cell[473703, 11765, 1890, 50, 968, "Subsubtitle"],
Cell[475596, 11817, 771, 11, 495, "Subsubsection"],
Cell[476370, 11830, 2006, 61, 1882, "Code"],
Cell[478379, 11893, 44, 1, 37, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[478460, 11899, 858, 20, 80, "Title"],
Cell[479321, 11921, 64, 0, 495, "Subsubsection"],
Cell[479388, 11923, 1078, 20, 365, "Subsubsection"],
Cell[480469, 11945, 1144, 29, 848, "Subsubtitle"],
Cell[481616, 11976, 771, 11, 495, "Subsubsection"],
Cell[482390, 11989, 1178, 33, 1510, "Code"],
Cell[483571, 12024, 44, 1, 37, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[483652, 12030, 895, 21, 80, "Title"],
Cell[484550, 12053, 64, 0, 35, "Subsubsection"],
Cell[484617, 12055, 1111, 22, 26, "Subsubsection"],
Cell[485731, 12079, 1283, 34, 60, "Subsubtitle"],
Cell[487017, 12115, 771, 11, 35, "Subsubsection"],
Cell[487791, 12128, 1492, 44, 104, "Code"],
Cell[489286, 12174, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[489367, 12180, 880, 22, 86, "Title"],
Cell[490250, 12204, 61, 0, 1355, "Subsubsection"],
Cell[490314, 12206, 659, 19, 1443, "Subsubsection"],
Cell[490976, 12227, 1123, 24, 1355, "Subsubsection"],
Cell[492102, 12253, 1553, 44, 2370, "Subsubtitle"],
Cell[493658, 12299, 771, 11, 1355, "Subsubsection"],
Cell[494432, 12312, 1844, 59, 5161, "Code"],
Cell[496279, 12373, 89, 2, 1355, "Subsubsection"],
Cell[496371, 12377, 61, 0, 929, "Subsubsection"],
Cell[496435, 12379, 655, 19, 1443, "Subsubsection"],
Cell[497093, 12400, 1157, 25, 998, "Subsubsection"],
Cell[498253, 12427, 1766, 49, 2370, "Subsubtitle"],
Cell[500022, 12478, 771, 11, 1355, "Subsubsection"],
Cell[500796, 12491, 1911, 60, 5161, "Code"],
Cell[502710, 12553, 44, 1, 99, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[502791, 12559, 921, 22, 83, "Title"],
Cell[503715, 12583, 61, 0, 1355, "Subsubsection"],
Cell[503779, 12585, 400, 11, 1510, "Subsubsection"],
Cell[504182, 12598, 613, 9, 929, "Subsubsection"],
Cell[504798, 12609, 1221, 31, 2448, "Subsubtitle"],
Cell[506022, 12642, 771, 11, 1355, "Subsubsection"],
Cell[506796, 12655, 965, 31, 4141, "Code"],
Cell[507764, 12688, 44, 1, 99, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[507845, 12694, 1070, 27, 93, "Title"],
Cell[508918, 12723, 64, 0, 1896, "Subsubsection"],
Cell[508985, 12725, 620, 19, 2020, "Subsubsection"],
Cell[509608, 12746, 864, 28, 2370, "Subsubsection"],
Cell[510475, 12776, 584, 15, 1397, "Subsubsection"],
Cell[511062, 12793, 611, 9, 1300, "Subsubsection"],
Cell[511676, 12804, 1398, 40, 3515, "Subsubtitle"],
Cell[513077, 12846, 771, 11, 1896, "Subsubsection"],
Cell[513851, 12859, 7185, 181, 25653, "Code"],
Cell[521039, 13042, 44, 1, 138, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[521120, 13048, 935, 22, 80, "Title"],
Cell[522058, 13072, 61, 0, 93, "Subsubsection"],
Cell[522122, 13074, 656, 19, 99, "Subsubsection"],
Cell[522781, 13095, 610, 9, 65, "Subsubsection"],
Cell[523394, 13106, 1526, 46, 158, "Subsubtitle"],
Cell[524923, 13154, 771, 11, 93, "Subsubsection"],
Cell[525697, 13167, 1675, 51, 351, "Code"],
Cell[527375, 13220, 44, 1, 8, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[527456, 13226, 920, 22, 80, "Title"],
Cell[528379, 13250, 61, 0, 93, "Subsubsection"],
Cell[528443, 13252, 656, 19, 99, "Subsubsection"],
Cell[529102, 13273, 782, 16, 69, "Subsubsection"],
Cell[529887, 13291, 1840, 51, 202, "Subtitle"],
Cell[531730, 13344, 771, 11, 93, "Subsubsection"],
Cell[532504, 13357, 1939, 59, 351, "Code"],
Cell[534446, 13418, 44, 1, 8, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[534527, 13424, 717, 16, 80, "Title"],
Cell[535247, 13442, 57, 0, 181, "Subsubsection"],
Cell[535307, 13444, 729, 10, 125, "Subsubsection"],
Cell[536039, 13456, 1275, 29, 321, "Subsubtitle"],
Cell[537317, 13487, 771, 11, 181, "Subsubsection"],
Cell[538091, 13500, 958, 27, 687, "Code"],
Cell[539052, 13529, 89, 2, 181, "Subsubsection"],
Cell[539144, 13533, 57, 0, 125, "Subsubsection"],
Cell[539204, 13535, 856, 17, 134, "Subsubsection"],
Cell[540063, 13554, 1596, 41, 340, "Subsubtitle"],
Cell[541662, 13597, 771, 11, 181, "Subsubsection"],
Cell[542436, 13610, 1964, 58, 956, "Code"],
Cell[544403, 13670, 89, 2, 181, "Subsubsection"],
Cell[544495, 13674, 57, 0, 125, "Subsubsection"],
Cell[544555, 13676, 920, 18, 153, "Subsubsection"],
Cell[545478, 13696, 1309, 30, 321, "Subsubtitle"],
Cell[546790, 13728, 771, 11, 181, "Subsubsection"],
Cell[547564, 13741, 2024, 58, 1223, "Code"]
}, Closed]]
}
]
*)

(* End of internal cache information *)
