(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    202311,       4905]
NotebookOptionsPosition[    193235,       4683]
NotebookOutlinePosition[    194340,       4722]
CellTagsIndexPosition[    194297,       4719]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"ArcCos", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, {
   3.494172650949109*^9, 3.494172665319129*^9}, 3.495070702275299*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.814.1, CRC 442, A&S 4.4.59", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4940010628073196`*^9, 3.4941723607787027`*^9, 3.4941724567488375`*^9, 
   3.494172696119172*^9, 3.495070776435403*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"ArcCos", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], " ", 
        RowBox[{"ArcCos", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], "]"}]}], "b"]}]}]}]}], "-", 
  FractionBox[
   SqrtBox[
    RowBox[{"1", "-", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "2"]}]], "b"]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.4950707022852993`*^9, 3.4950707022852993`*^9}, {3.49507078838542*^9, 
   3.495070789065421*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"ArcCos", "[", 
     RowBox[{"a_.", "+", 
      RowBox[{"b_.", "*", "x_"}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"ArcCos", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "/", "b"}]}], " ", "-", " ", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}]}], "]"}], "/", "b"}]}],
    " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, {
   3.4950707022852993`*^9, 3.4950707022852993`*^9}, {3.495070794375428*^9, 
   3.495070794945429*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Reference: CRC 466", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4940010628073196`*^9, 3.4941723607787027`*^9, 3.4941724567488375`*^9, 
   3.494172696119172*^9, 3.4941735657303896`*^9, {3.4950715230064483`*^9, 
   3.495071523436449*^9}}],

Cell["Derivation: Iterated integration by parts", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9, 3.494173557270378*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", ">", "1"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"ArcCos", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"ArcCos", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], "n"]}], "b"]}]}]}]}], "-", 
  "                                                                ", 
  "\[IndentingNewLine]", "                                          ", 
  FractionBox[
   RowBox[{"n", " ", 
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "2"]}]], " ", 
    SuperscriptBox[
     RowBox[{"ArcCos", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], 
     RowBox[{"n", "-", "1"}]]}], "b"], "-", 
  RowBox[{"n", 
   RowBox[{"(", 
    RowBox[{"n", "-", "1"}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"ArcCos", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], 
      RowBox[{"n", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, 
   3.494173593500429*^9, 3.494173663970527*^9, {3.49506971727392*^9, 
   3.4950697391039505`*^9}, {3.4950707022852993`*^9, 3.4950707022952995`*^9}, 
   3.4950715631165047`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ArcCos", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCos", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", "n"}], "/", "b"}]}], " ", "-",
     "\n", "  ", 
    RowBox[{"n", "*", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCos", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", "b"}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "*", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"ArcCos", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "-", "2"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.4941735463003626`*^9, {3.4950707022952995`*^9, 3.4950707022952995`*^9}, 
   3.4950715368964677`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9, 3.494172818179343*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"ArcCos", "[", "z", "]"}]], "\[Equal]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"ArcCos", "[", "z", "]"}], "]"}], " "}], 
      RowBox[{"ArcCos", "[", "z", "]"}]]}], 
    RowBox[{
     SuperscriptBox["ArcCos", "\[Prime]",
      MultilineFunction->None], "[", "z", "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494172818179343*^9, 3.494172835289367*^9}, 
   3.4941728817394323`*^9, {3.4950707023252993`*^9, 3.4950707023352995`*^9}, {
   3.495070979235687*^9, 3.4950709881056995`*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.4941731234697704`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"ArcCos", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"SinIntegral", "[", 
        RowBox[{"ArcCos", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], "]"}], "]"}], 
       "b"]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941729903395844`*^9, 3.4941730236996307`*^9}, {
   3.4950707023352995`*^9, 3.4950707023352995`*^9}, {3.4950710211357455`*^9, 
   3.4950710251157513`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"ArcCos", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"SinIntegral", "[", 
      RowBox[{"ArcCos", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "]"}]}], "/", "b"}], " ", "/;", 
   "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4941729700395555`*^9, {
   3.4950707023352995`*^9, 3.4950707023352995`*^9}, 3.4950710120757327`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, 3.494172818179343*^9, {3.4941730525796714`*^9, 
   3.4941730534496727`*^9}, {3.494186609668625*^9, 3.494186614208233*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    SuperscriptBox[
     RowBox[{"ArcCos", "[", "z", "]"}], "2"]], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"Sin", "[", 
       RowBox[{"ArcCos", "[", "z", "]"}], "]"}], 
      SuperscriptBox[
       RowBox[{"ArcCos", "[", "z", "]"}], "2"]]}], 
    RowBox[{
     SuperscriptBox["ArcCos", "\[Prime]",
      MultilineFunction->None], "[", "z", "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494172818179343*^9, 3.494172835289367*^9}, 
   3.4941728817394323`*^9, {3.494186649883896*^9, 3.4941866757175417`*^9}, {
   3.4950707023452992`*^9, 3.4950707023452992`*^9}, {3.4950711067758656`*^9, 
   3.4950711067758656`*^9}, {3.495071162355943*^9, 3.495071162895944*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494173118559764*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"ArcCos", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], "2"]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       SqrtBox[
        RowBox[{"1", "-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}], ")"}], "2"]}]], 
       RowBox[{"b", " ", 
        RowBox[{"ArcCos", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], "]"}]}]]}]}]}]}], "-", 
  FractionBox[
   RowBox[{"CosIntegral", "[", 
    RowBox[{"ArcCos", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "]"}], "b"]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941729903395844`*^9, 3.4941730236996307`*^9}, {
   3.494173087849721*^9, 3.494173106499747*^9}, {3.4950707023452992`*^9, 
   3.495070702355299*^9}, {3.495071193785987*^9, 3.4950712003059964`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{
      RowBox[{"ArcCos", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "2"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"b", "*", 
       RowBox[{"ArcCos", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}]}], ")"}]}], " ", "-", " ", 
    RowBox[{
     RowBox[{"CosIntegral", "[", 
      RowBox[{"ArcCos", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "]"}], "/", "b"}]}], " ", "/;", 
   "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4941729700395555`*^9, 
   3.4941730673496923`*^9, {3.495070702355299*^9, 3.495070702355299*^9}, 
   3.49507118882598*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, 3.494172818179343*^9, {3.4941730525796714`*^9, 
   3.4941730534496727`*^9}, {3.494186609668625*^9, 3.494186614208233*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"ArcCos", "[", "z", "]"}]]], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"ArcCos", "[", "z", "]"}], "]"}], " "}], 
      SqrtBox[
       RowBox[{"ArcCos", "[", "z", "]"}]]]}], 
    RowBox[{
     SuperscriptBox["ArcCos", "\[Prime]",
      MultilineFunction->None], "[", "z", "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494172818179343*^9, 3.494172835289367*^9}, 
   3.4941728817394323`*^9, {3.494186649883896*^9, 3.4941866757175417`*^9}, 
   3.4943029610250635`*^9, {3.495070702355299*^9, 3.495070702365299*^9}, {
   3.495071378906246*^9, 3.495071378906246*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494173118559764*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"ArcCos", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox["1", "b"]}]}]}], " ", 
   SqrtBox[
    RowBox[{"2", " ", "\[Pi]"}]], " ", 
   RowBox[{"FresnelS", "[", 
    RowBox[{
     SqrtBox[
      FractionBox["2", "\[Pi]"]], " ", 
     SqrtBox[
      RowBox[{"ArcCos", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}]]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941729903395844`*^9, 3.4941730236996307`*^9}, {
   3.494173087849721*^9, 3.494173106499747*^9}, {3.4943029955011234`*^9, 
   3.494303005953142*^9}, 3.494303036809996*^9, {3.494303151782198*^9, 
   3.494303159332611*^9}, {3.495070702365299*^9, 3.495070702365299*^9}, {
   3.4950714048662825`*^9, 3.4950714103962903`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"ArcCos", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "]"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"2", "*", "Pi"}], "]"}]}], "*", 
    RowBox[{
     RowBox[{"FresnelS", "[", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"2", "/", "Pi"}], "]"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"ArcCos", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], "]"}], "]"}]}], "]"}], "/", "b"}]}], " ",
    "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4941729700395555`*^9, 
   3.4941730673496923`*^9, 3.494302978575094*^9, {3.4950707023752995`*^9, 
   3.4950707023752995`*^9}, 3.495071393416267*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, 3.494172818179343*^9, {3.4941730525796714`*^9, 
   3.4941730534496727`*^9}, {3.494186609668625*^9, 3.494186614208233*^9}, {
   3.4943030859188824`*^9, 3.494303086683284*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494173118559764*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SqrtBox[
     RowBox[{"ArcCos", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], " ", 
        SqrtBox[
         RowBox[{"ArcCos", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}]]}], "b"]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", "b"], " ", 
   SqrtBox[
    FractionBox["\[Pi]", "2"]], " ", 
   RowBox[{"FresnelC", "[", 
    RowBox[{
     SqrtBox[
      FractionBox["2", "\[Pi]"]], " ", 
     SqrtBox[
      RowBox[{"ArcCos", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}]]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941729903395844`*^9, 3.4941730236996307`*^9}, {
   3.494173087849721*^9, 3.494173106499747*^9}, {3.4943029955011234`*^9, 
   3.494303005953142*^9}, 3.494303036809996*^9, {3.4943031359481707`*^9, 
   3.4943031717190332`*^9}, {3.4950707023752995`*^9, 
   3.4950707023752995`*^9}, {3.4950714762863827`*^9, 3.4950714878463993`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"ArcCos", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}], "]"}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"ArcCos", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "]"}], "/", "b"}]}], " ", "-", " ", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"Pi", "/", "2"}], "]"}], "*", 
     RowBox[{
      RowBox[{"FresnelC", "[", 
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{"2", "/", "Pi"}], "]"}], "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"ArcCos", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], "]"}], "]"}]}], "]"}], "/", "b"}]}]}], 
   " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4941729700395555`*^9, 
   3.4941730673496923`*^9, 3.494302978575094*^9, 3.4943030824868765`*^9, {
   3.4950707023752995`*^9, 3.495070702385299*^9}, 3.495071466326369*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Inverted iterated integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, 3.494173557270378*^9, {3.494173842880778*^9, 
   3.4941738518907905`*^9}, {3.4941739400709143`*^9, 3.4941739564209366`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{"n", "\[NotEqual]", 
    RowBox[{"-", "2"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}, {3.494173966810951*^9, 3.494174007671008*^9}, {
   3.4950697761340027`*^9, 3.4950697798340077`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"ArcCos", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"ArcCos", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], 
         RowBox[{"n", "+", "2"}]]}], 
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}]}]]}]}]}]}], "-", 
  "                                                                           \
        ", "\[IndentingNewLine]", 
  "                                             ", 
  FractionBox[
   RowBox[{
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "2"]}]], " ", 
    SuperscriptBox[
     RowBox[{"ArcCos", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], 
     RowBox[{"n", "+", "1"}]]}], 
   RowBox[{"b", " ", 
    RowBox[{"(", 
     RowBox[{"n", "+", "1"}], ")"}]}]], "-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"n", "+", "2"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"ArcCos", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], 
      RowBox[{"n", "+", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, 
   3.494173593500429*^9, 3.494173663970527*^9, 3.4941739141808777`*^9, {
   3.495069756433975*^9, 3.4950697840940137`*^9}, {3.495070702385299*^9, 
   3.495070702385299*^9}, {3.4950716431866164`*^9, 3.495071643486617*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ArcCos", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCos", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCos", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"ArcCos", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "+", "2"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", "!=", 
     RowBox[{"-", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.4941735463003626`*^9, 3.494173866490811*^9, {3.495070702395299*^9, 
   3.495070702395299*^9}, 3.4950716383166094`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[NotElement]", "\[DoubleStruckCapitalQ]"}], " ", "\[Or]", 
   " ", 
   RowBox[{
    RowBox[{"-", "1"}], "<", "n", "<", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}, {3.494173966810951*^9, 3.494174007671008*^9}, {
   3.4941741326011834`*^9, 3.4941741425911975`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"ArcCos", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"ArcCos", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
      RowBox[{"2", " ", "b"}]]}]}], 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{"\[CapitalGamma]", "[", 
       RowBox[{
        RowBox[{"n", "+", "1"}], ",", 
        RowBox[{"\[ImaginaryI]", " ", 
         RowBox[{"ArcCos", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}]}]}], "]"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[ImaginaryI]", " ", 
         RowBox[{"ArcCos", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}]}], ")"}], "n"]], "+", 
     FractionBox[
      RowBox[{"\[CapitalGamma]", "[", 
       RowBox[{
        RowBox[{"n", "+", "1"}], ",", 
        RowBox[{
         RowBox[{"-", "\[ImaginaryI]"}], " ", 
         RowBox[{"ArcCos", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}]}]}], "]"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "\[ImaginaryI]"}], " ", 
         RowBox[{"ArcCos", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}]}], ")"}], "n"]]}], 
    ")"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, 
   3.494173593500429*^9, 3.494173663970527*^9, 3.4941739141808777`*^9, 
   3.494174420251586*^9, {3.495069820004064*^9, 3.4950698617141223`*^9}, {
   3.495070702395299*^9, 3.495070702405299*^9}, {3.495071778576806*^9, 
   3.4950718074868464`*^9}, {3.4950755924821453`*^9, 3.495075613442175*^9}, {
   3.4950756973922925`*^9, 3.4950757065123053`*^9}, 3.495126786555883*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ArcCos", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCos", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "^", "n"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", "b"}], ")"}]}], "*", "\n", "    ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Gamma", "[", 
        RowBox[{
         RowBox[{"n", "+", "1"}], ",", 
         RowBox[{"I", "*", 
          RowBox[{"ArcCos", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"I", "*", 
          RowBox[{"ArcCos", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}]}], ")"}], "^", "n"}]}], " ", "+",
       " ", "\n", "     ", 
      RowBox[{
       RowBox[{"Gamma", "[", 
        RowBox[{
         RowBox[{"n", "+", "1"}], ",", 
         RowBox[{
          RowBox[{"-", "I"}], "*", 
          RowBox[{"ArcCos", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "I"}], "*", 
          RowBox[{"ArcCos", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}]}], ")"}], "^", "n"}]}]}], 
     ")"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Not", "[", 
       RowBox[{"RationalQ", "[", "n", "]"}], "]"}], " ", "||", " ", 
      RowBox[{
       RowBox[{"-", "1"}], "<", "n", "<", "1"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.4941735463003626`*^9, 3.494173866490811*^9, 3.494174071121097*^9, {
   3.494186988544891*^9, 3.494187016016539*^9}, {3.4941901282297506`*^9, 
   3.4941901326913586`*^9}, {3.495070702405299*^9, 3.4950707024152994`*^9}, 
   3.495071734386744*^9, {3.495071935057025*^9, 3.495071962097063*^9}, {
   3.495075769632394*^9, 3.4950758022624393`*^9}, {3.4951268227479467`*^9, 
   3.4951268588152103`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   RowBox[{"ArcCos", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, {
   3.494172650949109*^9, 3.494172665319129*^9}, {3.494176335919876*^9, 
   3.494176356549905*^9}, 3.4950707024152994`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.832, CRC 454, A&S 4.4.67", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4940010628073196`*^9, 3.4941723607787027`*^9, 3.4941724567488375`*^9, 
   3.494172696119172*^9, 3.4941735657303896`*^9, 3.494176826510563*^9, 
   3.495075904902583*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, 3.494173557270378*^9, {3.494176834460574*^9, 
   3.4941768354805756`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}, {3.494173966810951*^9, 3.494174007671008*^9}, {
   3.4941741326011834`*^9, 3.4941741425911975`*^9}, {3.4941767936905165`*^9, 
   3.494176809630539*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"ArcCos", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        RowBox[{"ArcCos", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], "]"}]}], 
       RowBox[{"m", "+", "1"}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox["b", 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox["x", 
       RowBox[{"m", "+", "1"}]], 
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["a", "2"], "-", 
        RowBox[{"2", " ", "a", " ", "b", " ", "x"}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["x", "2"]}]}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, 
   3.494173593500429*^9, 3.494173663970527*^9, 3.4941739141808777`*^9, 
   3.494174420251586*^9, 3.494176720380414*^9, {3.4941767533004603`*^9, 
   3.4941767774904943`*^9}, {3.4950707024252996`*^9, 
   3.4950707024252996`*^9}, {3.4950759244426103`*^9, 3.4950759249226108`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"ArcCos", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"ArcCos", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "/", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "/", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"1", "-", 
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"2", "*", "a", "*", "b", "*", "x"}], "-", 
           RowBox[{
            RowBox[{"b", "^", "2"}], "*", 
            RowBox[{"x", "^", "2"}]}]}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.4941735463003626`*^9, 3.494173866490811*^9, 3.494174071121097*^9, 
   3.494176683980363*^9, 3.4949886304357595`*^9, 3.4949909267385945`*^9, {
   3.4950707024252996`*^9, 3.4950707024252996`*^9}, 3.4950759192526026`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"ArcCos", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, {
   3.494172650949109*^9, 3.494172665319129*^9}, {3.494176335919876*^9, 
   3.494176356549905*^9}, {3.49498868743826*^9, 3.4949887071566944`*^9}, 
   3.4950707024252996`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}, {3.494173966810951*^9, 3.494174007671008*^9}, {
   3.4941741326011834`*^9, 3.4941741425911975`*^9}, {3.4941767936905165`*^9, 
   3.494176809630539*^9}, {3.494983386725746*^9, 3.4949833909065533`*^9}, 
   3.494983497719941*^9, {3.4949854524501743`*^9, 3.4949854564749813`*^9}, {
   3.4949859589098663`*^9, 3.4949859602514687`*^9}, {3.4949879786538143`*^9, 
   3.494987984191824*^9}, 3.4949884255606003`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["x", 
    SqrtBox[
     RowBox[{"ArcCos", "[", 
      RowBox[{"a", " ", "x"}], "]"}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       SqrtBox["\[Pi]"], 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "2"]}]]}]}]}], "  ", 
   RowBox[{"FresnelS", "[", 
    FractionBox[
     RowBox[{"2", " ", 
      SqrtBox[
       RowBox[{"ArcCos", "[", 
        RowBox[{"a", " ", "x"}], "]"}]]}], 
     SqrtBox["\[Pi]"]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.4941763955899596`*^9, 3.4941764290900064`*^9}, {3.4941764605500507`*^9, 
   3.4941764930400963`*^9}, {3.4941882372412295`*^9, 3.49418823769363*^9}, {
   3.4949829455725713`*^9, 3.494982982560236*^9}, {3.4949831515865326`*^9, 
   3.4949831587937455`*^9}, {3.4949833118456144`*^9, 3.494983321252431*^9}, {
   3.494985141635228*^9, 3.4949851587796583`*^9}, {3.4949859461490436`*^9, 
   3.4949860122619596`*^9}, 3.4949879537093706`*^9, {3.494988429117406*^9, 
   3.4949884838423023`*^9}, {3.494989403195918*^9, 3.494989447031995*^9}, {
   3.4950707024352994`*^9, 3.4950707024352994`*^9}, 3.4950772002643967`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"ArcCos", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "]"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Sqrt", "[", "Pi", "]"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", 
       RowBox[{"a", "^", "2"}]}], ")"}]}], "*", 
    RowBox[{"FresnelS", "[", 
     RowBox[{"2", "*", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"ArcCos", "[", 
         RowBox[{"a", "*", "x"}], "]"}], "]"}], "/", 
       RowBox[{"Sqrt", "[", "Pi", "]"}]}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{"a", ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, {
   3.4941763709899254`*^9, 3.49417638178994*^9}, {3.4949830204059024`*^9, 
   3.494983029282318*^9}, {3.4949830779076033`*^9, 3.4949831399333124`*^9}, {
   3.494983175407775*^9, 3.494983200321018*^9}, {3.4949832337830772`*^9, 
   3.4949832374490833`*^9}, {3.4949833261976395`*^9, 3.494983340034864*^9}, {
   3.4949834012961717`*^9, 3.4949834200630045`*^9}, {3.4949835020723486`*^9, 
   3.4949835143807697`*^9}, {3.494985256061429*^9, 3.494985357180807*^9}, {
   3.4949854103457003`*^9, 3.4949854160709105`*^9}, {3.4949856987014093`*^9, 
   3.4949857491362977`*^9}, {3.494986058968442*^9, 3.494986124207756*^9}, {
   3.4949879612285833`*^9, 3.494987968810197*^9}, {3.494988015376279*^9, 
   3.494988070145176*^9}, {3.4949885021567345`*^9, 3.4949885279123797`*^9}, {
   3.494988571389656*^9, 3.494988577099266*^9}, {3.4949894518368034`*^9, 
   3.4949894852832623`*^9}, {3.4950707024352994`*^9, 3.4950707024352994`*^9}, 
   3.4950772224844275`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}, {3.494173966810951*^9, 3.494174007671008*^9}, {
   3.4941741326011834`*^9, 3.4941741425911975`*^9}, {3.4941767936905165`*^9, 
   3.494176809630539*^9}, {3.494983386725746*^9, 3.4949833909065533`*^9}, 
   3.494983497719941*^9, {3.4949854524501743`*^9, 3.4949854564749813`*^9}, {
   3.4949859589098663`*^9, 3.4949859602514687`*^9}, {3.4949879786538143`*^9, 
   3.494987984191824*^9}, 3.4949884255606003`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["x", 
     SuperscriptBox[
      RowBox[{"ArcCos", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"3", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"2", " ", "x", " ", 
        SqrtBox[
         RowBox[{"1", "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["x", "2"]}]}]]}], 
       RowBox[{"a", " ", 
        SqrtBox[
         RowBox[{"ArcCos", "[", 
          RowBox[{"a", " ", "x"}], "]"}]]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", 
     SqrtBox["\[Pi]"]}], 
    SuperscriptBox["a", "2"]], "  ", 
   RowBox[{"FresnelC", "[", 
    FractionBox[
     RowBox[{"2", " ", 
      SqrtBox[
       RowBox[{"ArcCos", "[", 
        RowBox[{"a", " ", "x"}], "]"}]]}], 
     SqrtBox["\[Pi]"]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.4941763955899596`*^9, 3.4941764290900064`*^9}, {3.4941764605500507`*^9, 
   3.4941764930400963`*^9}, {3.4941882372412295`*^9, 3.49418823769363*^9}, {
   3.4949829455725713`*^9, 3.494982982560236*^9}, {3.4949831515865326`*^9, 
   3.4949831587937455`*^9}, {3.4949833118456144`*^9, 3.494983321252431*^9}, {
   3.494985141635228*^9, 3.4949851587796583`*^9}, {3.4949859461490436`*^9, 
   3.4949860122619596`*^9}, 3.4949879537093706`*^9, {3.494988429117406*^9, 
   3.4949884838423023`*^9}, {3.494989403195918*^9, 3.494989447031995*^9}, {
   3.4949896090226793`*^9, 3.494989620005099*^9}, 3.4949897250088835`*^9, {
   3.4950707024352994`*^9, 3.495070702445299*^9}, {3.4950772844245143`*^9, 
   3.4950772890545206`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "/", 
     RowBox[{
      RowBox[{"ArcCos", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"3", "/", "2"}], ")"}]}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "*", "x", "*", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"1", "-", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "*", 
         RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"ArcCos", "[", 
          RowBox[{"a", "*", "x"}], "]"}], "]"}]}], ")"}]}]}], " ", "-", " ", 
    RowBox[{"2", "*", 
     RowBox[{
      RowBox[{"Sqrt", "[", "Pi", "]"}], "/", 
      RowBox[{"a", "^", "2"}]}], "*", 
     RowBox[{"FresnelC", "[", 
      RowBox[{"2", "*", 
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{"ArcCos", "[", 
          RowBox[{"a", "*", "x"}], "]"}], "]"}], "/", 
        RowBox[{"Sqrt", "[", "Pi", "]"}]}]}], "]"}]}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{"a", ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, {
   3.4941763709899254`*^9, 3.49417638178994*^9}, {3.4949830204059024`*^9, 
   3.494983029282318*^9}, {3.4949830779076033`*^9, 3.4949831399333124`*^9}, {
   3.494983175407775*^9, 3.494983200321018*^9}, {3.4949832337830772`*^9, 
   3.4949832374490833`*^9}, {3.4949833261976395`*^9, 3.494983340034864*^9}, {
   3.4949834012961717`*^9, 3.4949834200630045`*^9}, {3.4949835020723486`*^9, 
   3.4949835143807697`*^9}, {3.494985256061429*^9, 3.494985357180807*^9}, {
   3.4949854103457003`*^9, 3.4949854160709105`*^9}, {3.4949856987014093`*^9, 
   3.4949857491362977`*^9}, {3.494986058968442*^9, 3.494986124207756*^9}, {
   3.4949879612285833`*^9, 3.494987968810197*^9}, {3.494988015376279*^9, 
   3.494988070145176*^9}, {3.4949885021567345`*^9, 3.4949885279123797`*^9}, {
   3.494988571389656*^9, 3.494988577099266*^9}, {3.4949894518368034`*^9, 
   3.4949894852832623`*^9}, {3.494989775490572*^9, 3.494989784491788*^9}, {
   3.495070702445299*^9, 3.495070702445299*^9}, {3.4950772997145357`*^9, 
   3.49507730290454*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", ">", "1"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}, {3.494173966810951*^9, 3.494174007671008*^9}, {
   3.4941741326011834`*^9, 3.4941741425911975`*^9}, {3.4941767936905165`*^9, 
   3.494176809630539*^9}, {3.494983386725746*^9, 3.4949833909065533`*^9}, 
   3.494983497719941*^9, {3.4949854524501743`*^9, 3.4949854564749813`*^9}, {
   3.4949859589098663`*^9, 3.4949859602514687`*^9}, {3.4949879786538143`*^9, 
   3.494987984191824*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"ArcCos", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"n", " ", "x", " ", 
         SqrtBox[
          RowBox[{"1", "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["x", "2"]}]}]], 
         SuperscriptBox[
          RowBox[{"ArcCos", "[", 
           RowBox[{"a", " ", "x"}], "]"}], 
          RowBox[{"n", "-", "1"}]]}], 
        RowBox[{"4", " ", "a"}]]}]}]}]}]}], "-", 
  "                                                                     ", 
  "\[IndentingNewLine]", 
  "                                                        ", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"ArcCos", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"4", " ", 
    SuperscriptBox["a", "2"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox[
     RowBox[{"ArcCos", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"]}], "2"], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"n", " ", 
     RowBox[{"(", 
      RowBox[{"n", "-", "1"}], ")"}]}], "4"], 
   RowBox[{"\[Integral]", 
    RowBox[{"x", " ", 
     SuperscriptBox[
      RowBox[{"ArcCos", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.4941763955899596`*^9, 3.4941764290900064`*^9}, {3.4941764605500507`*^9, 
   3.4941764930400963`*^9}, {3.4941882372412295`*^9, 3.49418823769363*^9}, {
   3.4949829455725713`*^9, 3.494982982560236*^9}, {3.4949831515865326`*^9, 
   3.4949831587937455`*^9}, {3.4949833118456144`*^9, 3.494983321252431*^9}, {
   3.494985141635228*^9, 3.4949851587796583`*^9}, {3.4949859461490436`*^9, 
   3.4949860122619596`*^9}, 3.4949879537093706`*^9, {3.4949901773940773`*^9, 
   3.4949902293265686`*^9}, {3.495069905044183*^9, 3.495069912404193*^9}, {
   3.495070702445299*^9, 3.4950707024552994`*^9}, 3.4950773482946033`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "*", 
     RowBox[{
      RowBox[{"ArcCos", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "n"}], "*", "x", "*", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "-", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "*", 
        RowBox[{"x", "^", "2"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCos", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"4", "*", "a"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"ArcCos", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
     RowBox[{"(", 
      RowBox[{"4", "*", 
       RowBox[{"a", "^", "2"}]}], ")"}]}], " ", "+", " ", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCos", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", "2"}]}], " ", "-", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}], "/", "4"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"x", "*", 
         RowBox[{
          RowBox[{"ArcCos", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, {
   3.4941763709899254`*^9, 3.49417638178994*^9}, {3.4949830204059024`*^9, 
   3.494983029282318*^9}, {3.4949830779076033`*^9, 3.4949831399333124`*^9}, {
   3.494983175407775*^9, 3.494983200321018*^9}, {3.4949832337830772`*^9, 
   3.4949832374490833`*^9}, {3.4949833261976395`*^9, 3.494983340034864*^9}, {
   3.4949834012961717`*^9, 3.4949834200630045`*^9}, {3.4949835020723486`*^9, 
   3.4949835143807697`*^9}, {3.494985256061429*^9, 3.494985357180807*^9}, {
   3.4949854103457003`*^9, 3.4949854160709105`*^9}, {3.4949856987014093`*^9, 
   3.4949857491362977`*^9}, {3.494986058968442*^9, 3.494986124207756*^9}, {
   3.4949879612285833`*^9, 3.494987968810197*^9}, {3.494988015376279*^9, 
   3.494988070145176*^9}, {3.494989820949052*^9, 3.4949898213234525`*^9}, {
   3.4949902637870293`*^9, 3.4949902976078887`*^9}, {3.4950707024552994`*^9, 
   3.4950707024652996`*^9}, 3.495077353504611*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{"n", "\[NotEqual]", 
    RowBox[{"-", "2"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}, {3.494173966810951*^9, 3.494174007671008*^9}, {
   3.4941741326011834`*^9, 3.4941741425911975`*^9}, {3.4941767936905165`*^9, 
   3.494176809630539*^9}, {3.494983386725746*^9, 3.4949833909065533`*^9}, 
   3.494983497719941*^9, {3.4949854524501743`*^9, 3.4949854564749813`*^9}, {
   3.4949859589098663`*^9, 3.4949859602514687`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"ArcCos", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"x", " ", 
         SqrtBox[
          RowBox[{"1", "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["x", "2"]}]}]], 
         SuperscriptBox[
          RowBox[{"ArcCos", "[", 
           RowBox[{"a", " ", "x"}], "]"}], 
          RowBox[{"n", "+", "1"}]]}], 
        RowBox[{"a", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}]}], "-", 
  "                                                                        ", 
  "\[IndentingNewLine]", "                                ", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"ArcCos", "[", 
     RowBox[{"a", " ", "x"}], "]"}], 
    RowBox[{"n", "+", "2"}]], 
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"n", "+", "1"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"n", "+", "2"}], ")"}]}]], "+", 
  FractionBox[
   RowBox[{"2", 
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox[
     RowBox[{"ArcCos", "[", 
      RowBox[{"a", " ", "x"}], "]"}], 
     RowBox[{"n", "+", "2"}]]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"n", "+", "1"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"n", "+", "2"}], ")"}]}]], "-", 
  RowBox[{
   FractionBox["4", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"n", "+", "2"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{"x", " ", 
     SuperscriptBox[
      RowBox[{"ArcCos", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "+", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.4941763955899596`*^9, 3.4941764290900064`*^9}, {3.4941764605500507`*^9, 
   3.4941764930400963`*^9}, {3.4941882372412295`*^9, 3.49418823769363*^9}, {
   3.4949829455725713`*^9, 3.494982982560236*^9}, {3.4949831515865326`*^9, 
   3.4949831587937455`*^9}, {3.4949833118456144`*^9, 3.494983321252431*^9}, {
   3.494985141635228*^9, 3.4949851587796583`*^9}, {3.4949859461490436`*^9, 
   3.4949860122619596`*^9}, {3.494990326155939*^9, 3.4949903720356197`*^9}, {
   3.495069916004198*^9, 3.495069925284211*^9}, {3.4950707024652996`*^9, 
   3.4950707024752994`*^9}, 3.4950774102646904`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "*", 
     RowBox[{
      RowBox[{"ArcCos", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "x"}], "*", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "-", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "*", 
        RowBox[{"x", "^", "2"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCos", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"ArcCos", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "+", "2"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}], "*", 
       RowBox[{"(", 
        RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}], " ", "+", "\n", "  ", 
    RowBox[{"2", "*", 
     RowBox[{"x", "^", "2"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCos", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"4", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"x", "*", 
         RowBox[{
          RowBox[{"ArcCos", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, {
   3.4941763709899254`*^9, 3.49417638178994*^9}, {3.4949830204059024`*^9, 
   3.494983029282318*^9}, {3.4949830779076033`*^9, 3.4949831399333124`*^9}, {
   3.494983175407775*^9, 3.494983200321018*^9}, {3.4949832337830772`*^9, 
   3.4949832374490833`*^9}, {3.4949833261976395`*^9, 3.494983340034864*^9}, {
   3.4949834012961717`*^9, 3.4949834200630045`*^9}, {3.4949835020723486`*^9, 
   3.4949835143807697`*^9}, {3.494985256061429*^9, 3.494985357180807*^9}, {
   3.4949854103457003`*^9, 3.4949854160709105`*^9}, {3.4949856987014093`*^9, 
   3.4949857491362977`*^9}, {3.494986058968442*^9, 3.494986124207756*^9}, {
   3.494990390365652*^9, 3.4949904107236876`*^9}, {3.4950707024752994`*^9, 
   3.4950707024852996`*^9}, 3.4950774221847067`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", ">", "1"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}, {3.494173966810951*^9, 3.494174007671008*^9}, {
   3.4941741326011834`*^9, 3.4941741425911975`*^9}, {3.4941767936905165`*^9, 
   3.494176809630539*^9}, {3.494983386725746*^9, 3.4949833909065533`*^9}, 
   3.494983497719941*^9, {3.4949854524501743`*^9, 3.4949854564749813`*^9}, {
   3.4950397197364063`*^9, 3.4950397291164193`*^9}, {3.4950398309665623`*^9, 
   3.4950398647066092`*^9}, {3.4950400859069185`*^9, 3.4950400899869246`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcCos", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     SuperscriptBox["x", "3"]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"a", " ", "n", " ", 
        SqrtBox[
         RowBox[{"1", "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["x", "2"]}]}]], " ", 
        SuperscriptBox[
         RowBox[{"ArcCos", "[", 
          RowBox[{"a", " ", "x"}], "]"}], 
         RowBox[{"n", "-", "1"}]]}], 
       RowBox[{"2", " ", "x"}]]}]}]}]}], "-", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"ArcCos", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"2", " ", 
    SuperscriptBox["x", "2"]}]], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["a", "2"], "n", 
     RowBox[{"(", 
      RowBox[{"n", "-", "1"}], ")"}]}], "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"ArcCos", "[", 
        RowBox[{"a", " ", "x"}], "]"}], 
       RowBox[{"n", "-", "2"}]], "x"], " ", 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.4941763955899596`*^9, 3.4941764290900064`*^9}, {3.4941764605500507`*^9, 
   3.4941764930400963`*^9}, {3.4941882372412295`*^9, 3.49418823769363*^9}, {
   3.4949829455725713`*^9, 3.494982982560236*^9}, {3.4949831515865326`*^9, 
   3.4949831587937455`*^9}, {3.4949833118456144`*^9, 3.494983321252431*^9}, {
   3.494985141635228*^9, 3.4949851587796583`*^9}, 3.4949950434132323`*^9, 
   3.4950392553857565`*^9, {3.495039916116681*^9, 3.4950399215966887`*^9}, {
   3.495039974776763*^9, 3.4950400725169*^9}, {3.4950707024852996`*^9, 
   3.4950707024852996`*^9}, 3.4950774540447516`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCos", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}], "/", 
     RowBox[{"x_", "^", "3"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
  "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "*", "n", "*", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "-", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "*", 
        RowBox[{"x", "^", "2"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCos", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "x"}], ")"}]}]}], " ", "-", "\[IndentingNewLine]", 
    "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"ArcCos", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", 
       RowBox[{"x", "^", "2"}]}], ")"}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "n", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}], "/", "2"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcCos", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}], "/", "x"}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, {
   3.4941763709899254`*^9, 3.49417638178994*^9}, {3.4949830204059024`*^9, 
   3.494983029282318*^9}, {3.4949830779076033`*^9, 3.4949831399333124`*^9}, {
   3.494983175407775*^9, 3.494983200321018*^9}, {3.4949832337830772`*^9, 
   3.4949832374490833`*^9}, {3.4949833261976395`*^9, 3.494983340034864*^9}, {
   3.4949834012961717`*^9, 3.4949834200630045`*^9}, {3.4949835020723486`*^9, 
   3.4949835143807697`*^9}, {3.494985256061429*^9, 3.494985357180807*^9}, {
   3.4949854103457003`*^9, 3.4949854160709105`*^9}, {3.4949856987014093`*^9, 
   3.4949857491362977`*^9}, 3.4949859360870256`*^9, 3.49498608094888*^9, {
   3.4949950655340714`*^9, 3.494995107841346*^9}, {3.494995146779014*^9, 
   3.494995147184615*^9}, {3.495039504486105*^9, 3.4950396079162493`*^9}, {
   3.49503969381637*^9, 3.4950396987763767`*^9}, {3.495039814736539*^9, 
   3.4950398163765416`*^9}, {3.495039850066589*^9, 3.495039856076597*^9}, {
   3.495040113876958*^9, 3.4950402176871033`*^9}, {3.4950707024952993`*^9, 
   3.4950707024952993`*^9}, 3.49507746006476*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"m", "<", 
    RowBox[{"-", "3"}]}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}, {3.494173966810951*^9, 3.494174007671008*^9}, {
   3.4941741326011834`*^9, 3.4941741425911975`*^9}, {3.4941767936905165`*^9, 
   3.494176809630539*^9}, {3.494983386725746*^9, 3.4949833909065533`*^9}, 
   3.494983497719941*^9, {3.4949854524501743`*^9, 3.4949854564749813`*^9}, {
   3.4950397197364063`*^9, 3.4950397291164193`*^9}, {3.4950398309665623`*^9, 
   3.4950398647066092`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"ArcCos", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"a", " ", "n", " ", 
        SuperscriptBox["x", 
         RowBox[{"m", "+", "2"}]], " ", 
        SqrtBox[
         RowBox[{"1", "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["x", "2"]}]}]], 
        SuperscriptBox[
         RowBox[{"ArcCos", "[", 
          RowBox[{"a", " ", "x"}], "]"}], 
         RowBox[{"n", "-", "1"}]]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], 
        RowBox[{"(", 
         RowBox[{"m", "+", "2"}], ")"}]}]]}]}]}]}], "+", 
  "                                                                           \
", "\[IndentingNewLine]", "                  ", 
  FractionBox[
   RowBox[{
    SuperscriptBox["x", 
     RowBox[{"m", "+", "1"}]], 
    SuperscriptBox[
     RowBox[{"ArcCos", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
   RowBox[{"(", 
    RowBox[{"m", "+", "1"}], ")"}]], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["a", "2"], 
    RowBox[{"(", 
     RowBox[{"m", "+", "3"}], ")"}], 
    SuperscriptBox["x", 
     RowBox[{"m", "+", "3"}]], 
    SuperscriptBox[
     RowBox[{"ArcCos", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"m", "+", "1"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"m", "+", "2"}], ")"}]}]], "+", "                   ", 
  "\[IndentingNewLine]", 
  "                                                      ", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["a", "2"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"m", "+", "3"}], ")"}], "2"]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"m", "+", "2"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"ArcCos", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["a", "2"], "n", 
     RowBox[{"(", 
      RowBox[{"n", "-", "1"}], ")"}]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"m", "+", "2"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "2"}]], 
     SuperscriptBox[
      RowBox[{"ArcCos", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.4941763955899596`*^9, 3.4941764290900064`*^9}, {3.4941764605500507`*^9, 
   3.4941764930400963`*^9}, {3.4941882372412295`*^9, 3.49418823769363*^9}, {
   3.4949829455725713`*^9, 3.494982982560236*^9}, {3.4949831515865326`*^9, 
   3.4949831587937455`*^9}, {3.4949833118456144`*^9, 3.494983321252431*^9}, {
   3.494985141635228*^9, 3.4949851587796583`*^9}, 3.4949950434132323`*^9, 
   3.4950392553857565`*^9, {3.495039916116681*^9, 3.4950399215966887`*^9}, {
   3.4950699761042824`*^9, 3.495070027284354*^9}, {3.4950707024952993`*^9, 
   3.4950707025052996`*^9}, 3.495077478524786*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"ArcCos", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "*", "n", "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "2"}], ")"}]}], "*", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "-", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "*", 
        RowBox[{"x", "^", "2"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCos", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "2"}], ")"}]}], ")"}]}]}], " ", "+", 
    "\[IndentingNewLine]", "  ", 
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCos", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{
     RowBox[{"a", "^", "2"}], "*", 
     RowBox[{"(", 
      RowBox[{"m", "+", "3"}], ")"}], "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "3"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCos", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "2"}], ")"}]}], ")"}]}]}], " ", "+", 
    "\[IndentingNewLine]", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"m", "+", "3"}], ")"}], "^", "2"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcCos", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "+", "\[IndentingNewLine]", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "n", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcCos", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "3"}]}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, {
   3.4941763709899254`*^9, 3.49417638178994*^9}, {3.4949830204059024`*^9, 
   3.494983029282318*^9}, {3.4949830779076033`*^9, 3.4949831399333124`*^9}, {
   3.494983175407775*^9, 3.494983200321018*^9}, {3.4949832337830772`*^9, 
   3.4949832374490833`*^9}, {3.4949833261976395`*^9, 3.494983340034864*^9}, {
   3.4949834012961717`*^9, 3.4949834200630045`*^9}, {3.4949835020723486`*^9, 
   3.4949835143807697`*^9}, {3.494985256061429*^9, 3.494985357180807*^9}, {
   3.4949854103457003`*^9, 3.4949854160709105`*^9}, {3.4949856987014093`*^9, 
   3.4949857491362977`*^9}, 3.4949859360870256`*^9, 3.49498608094888*^9, {
   3.4949950655340714`*^9, 3.494995107841346*^9}, {3.494995146779014*^9, 
   3.494995147184615*^9}, {3.495039504486105*^9, 3.4950396079162493`*^9}, {
   3.49503969381637*^9, 3.4950396987763767`*^9}, {3.495039814736539*^9, 
   3.4950398163765416`*^9}, {3.495039850066589*^9, 3.495039856076597*^9}, {
   3.4950707025153*^9, 3.4950707025252995`*^9}, 3.495077498454814*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"m", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{"n", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{"n", "\[NotEqual]", 
    RowBox[{"-", "2"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}, {3.494173966810951*^9, 3.494174007671008*^9}, {
   3.4941741326011834`*^9, 3.4941741425911975`*^9}, {3.4941767936905165`*^9, 
   3.494176809630539*^9}, {3.494983386725746*^9, 3.4949833909065533`*^9}, 
   3.494983497719941*^9, {3.4949854524501743`*^9, 3.4949854564749813`*^9}, {
   3.495039788036502*^9, 3.4950397900365047`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"ArcCos", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox["x", "m"], " ", 
         SqrtBox[
          RowBox[{"1", "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["x", "2"]}]}]], 
         SuperscriptBox[
          RowBox[{"ArcCos", "[", 
           RowBox[{"a", " ", "x"}], "]"}], 
          RowBox[{"n", "+", "1"}]]}], 
        RowBox[{"a", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}]}], "-", 
  "                                                                           \
             ", "\[IndentingNewLine]", 
  FractionBox[
   RowBox[{"m", " ", 
    SuperscriptBox["x", 
     RowBox[{"m", "-", "1"}]], 
    SuperscriptBox[
     RowBox[{"ArcCos", "[", 
      RowBox[{"a", " ", "x"}], "]"}], 
     RowBox[{"n", "+", "2"}]]}], 
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"n", "+", "1"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"n", "+", "2"}], ")"}]}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"m", "+", "1"}], ")"}], 
    SuperscriptBox["x", 
     RowBox[{"m", "+", "1"}]], 
    SuperscriptBox[
     RowBox[{"ArcCos", "[", 
      RowBox[{"a", " ", "x"}], "]"}], 
     RowBox[{"n", "+", "2"}]]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"n", "+", "1"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"n", "+", "2"}], ")"}]}]], "-", "      ", "\[IndentingNewLine]", 
  "                                               ", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}], "2"], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"n", "+", "2"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"ArcCos", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "+", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"m", " ", 
     RowBox[{"(", 
      RowBox[{"m", "-", "1"}], ")"}]}], 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"n", "+", "2"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "2"}]], 
     SuperscriptBox[
      RowBox[{"ArcCos", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "+", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.4941763955899596`*^9, 3.4941764290900064`*^9}, {3.4941764605500507`*^9, 
   3.4941764930400963`*^9}, {3.4941882372412295`*^9, 3.49418823769363*^9}, {
   3.4949829455725713`*^9, 3.494982982560236*^9}, {3.4949831515865326`*^9, 
   3.4949831587937455`*^9}, {3.4949833118456144`*^9, 3.494983321252431*^9}, {
   3.494985141635228*^9, 3.4949851587796583`*^9}, 3.4949950434132323`*^9, {
   3.495070054224392*^9, 3.4950700747544203`*^9}, {3.4950703426847954`*^9, 
   3.4950703572848163`*^9}, {3.4950707025252995`*^9, 3.4950707025352993`*^9}, 
   3.4950775390548706`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"ArcCos", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"x", "^", "m"}]}], "*", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "-", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "*", 
        RowBox[{"x", "^", "2"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCos", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"m", "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCos", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}], "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCos", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "^", "2"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"ArcCos", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"m", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "-", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "*", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcCos", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, {
   3.4941763709899254`*^9, 3.49417638178994*^9}, {3.4949830204059024`*^9, 
   3.494983029282318*^9}, {3.4949830779076033`*^9, 3.4949831399333124`*^9}, {
   3.494983175407775*^9, 3.494983200321018*^9}, {3.4949832337830772`*^9, 
   3.4949832374490833`*^9}, {3.4949833261976395`*^9, 3.494983340034864*^9}, {
   3.4949834012961717`*^9, 3.4949834200630045`*^9}, {3.4949835020723486`*^9, 
   3.4949835143807697`*^9}, {3.494985256061429*^9, 3.494985357180807*^9}, {
   3.4949854103457003`*^9, 3.4949854160709105`*^9}, {3.4949856987014093`*^9, 
   3.4949857491362977`*^9}, 3.4949859360870256`*^9, 3.49498608094888*^9, {
   3.4949950655340714`*^9, 3.494995107841346*^9}, {3.494995146779014*^9, 
   3.494995147184615*^9}, {3.4950397717164793`*^9, 3.4950397741964827`*^9}, {
   3.4950707025352993`*^9, 3.4950707025552998`*^9}, 3.495077543494877*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9, 3.494172818179343*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[Cell[TextData[Cell[BoxData[
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcCos", "[", 
       RowBox[{"a", " ", 
        SuperscriptBox["x", "p"]}], "]"}], "n"], "x"], "=", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "p"]}], " ", 
     SuperscriptBox[
      RowBox[{"ArcCos", "[", 
       RowBox[{"a", " ", 
        SuperscriptBox["x", "p"]}], "]"}], "n"], " ", 
     RowBox[{"Tan", "[", 
      RowBox[{"ArcCos", "[", 
       RowBox[{"a", " ", 
        SuperscriptBox["x", "p"]}], "]"}], "]"}], " ", 
     RowBox[{
      SubscriptBox["\[PartialD]", "x"], 
      RowBox[{"ArcCos", "[", 
       RowBox[{"a", " ", 
        SuperscriptBox["x", "p"]}], "]"}]}]}]}]]]], "Subsubsection",
   CellChangeTimes->{
    3.4941724567488375`*^9, {3.494172818179343*^9, 3.494172835289367*^9}, 
     3.4941728817394323`*^9, {3.4941732517099504`*^9, 
     3.4941732592199607`*^9}}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494172818179343*^9, 3.494172835289367*^9}, 
   3.4941728817394323`*^9, {3.4941732517099504`*^9, 3.4941732592199607`*^9}, {
   3.4941867403328547`*^9, 3.494186750597673*^9}, {3.494188482910461*^9, 
   3.494188485702866*^9}, 3.494188591549052*^9, {3.49418864176554*^9, 
   3.49418864750635*^9}, {3.4941887057880526`*^9, 3.494188733883702*^9}, {
   3.494189069767892*^9, 3.4941891152419715`*^9}, {3.494198042823061*^9, 
   3.494198045428265*^9}, {3.494198409922906*^9, 3.4941984537277822`*^9}, {
   3.495042116619762*^9, 3.495042147729806*^9}, {3.4950465577559795`*^9, 
   3.495046587316021*^9}, {3.495077577854925*^9, 3.495077601044957*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}, {3.494173966810951*^9, 3.494174007671008*^9}, {
   3.4941741326011834`*^9, 3.4941741425911975`*^9}, {3.4941767936905165`*^9, 
   3.494176809630539*^9}, {3.4941773316412697`*^9, 3.494177333751273*^9}, {
   3.4941891756608777`*^9, 3.494189178765283*^9}, {3.4942004775317707`*^9, 
   3.494200477881771*^9}, {3.4950424099901724`*^9, 3.495042435550208*^9}, {
   3.4950458089749312`*^9, 3.4950458106049337`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"ArcCos", "[", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "p"]}], "]"}], "n"], "x"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox["1", "p"]}]}]}], " ", 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox["x", "n"], " ", 
       RowBox[{"Tan", "[", "x", "]"}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"ArcCos", "[", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "p"]}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.4941763955899596`*^9, 3.4941764290900064`*^9}, {3.4941764605500507`*^9, 
   3.4941764930400963`*^9}, {3.4941882372412295`*^9, 3.49418823769363*^9}, {
   3.4950421850198574`*^9, 3.4950422389399333`*^9}, {3.4950457701448765`*^9, 
   3.495045776854886*^9}, {3.495045811494935*^9, 3.495045812534936*^9}, {
   3.495046607366049*^9, 3.495046608966051*^9}, {3.4950707025752993`*^9, 
   3.4950707025752993`*^9}, {3.4950776161949787`*^9, 3.4950776192849827`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCos", "[", 
       RowBox[{"a_.", "*", 
        RowBox[{"x_", "^", "p_."}]}], "]"}], "^", "n_."}], "/", "x_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "p"}], ",", 
      RowBox[{"Subst", "[", 
       RowBox[{
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", "n"}], "*", 
           RowBox[{"Tan", "[", "x", "]"}]}], ",", "x"}], "]"}], ",", "x", ",", 
        RowBox[{"ArcCos", "[", 
         RowBox[{"a", "*", 
          RowBox[{"x", "^", "p"}]}], "]"}]}], "]"}]}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, {
   3.4941763709899254`*^9, 3.49417638178994*^9}, {3.4950424525902324`*^9, 
   3.4950425131303167`*^9}, {3.4950457818848934`*^9, 3.495045815844941*^9}, {
   3.495046610586054*^9, 3.4950466137560577`*^9}, {3.4950707025752993`*^9, 
   3.4950707025752993`*^9}, {3.4950776230349884`*^9, 3.4950776262549925`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Integration by parts and substitution", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, 3.494172818179343*^9, {3.495045874395023*^9, 
   3.495045875835025*^9}, {3.4950462556855564`*^9, 3.495046257635559*^9}}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", ",
 Cell[BoxData[Cell[TextData[Cell[BoxData[
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", 
       RowBox[{"m", "+", "1"}]], " ", 
      SuperscriptBox[
       RowBox[{"ArcCos", "[", 
        RowBox[{"a", " ", "x"}], "]"}], 
       RowBox[{"n", "-", "1"}]]}], 
     SqrtBox[
      RowBox[{"1", "-", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["x", "2"]}]}]]], "=", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", 
       SuperscriptBox["a", 
        RowBox[{"m", "+", "2"}]]]}], " ", 
     SuperscriptBox[
      RowBox[{"ArcCos", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "-", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", 
       RowBox[{"ArcCos", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "]"}], 
      RowBox[{"m", "+", "1"}]], " ", 
     RowBox[{
      SubscriptBox["\[PartialD]", "x"], 
      RowBox[{"ArcCos", "[", 
       RowBox[{"a", " ", "x"}], "]"}]}]}]}]]]], "Subsubsection",
   CellChangeTimes->{
    3.4941724567488375`*^9, {3.494172818179343*^9, 3.494172835289367*^9}, 
     3.4941728817394323`*^9, {3.4941732517099504`*^9, 
     3.4941732592199607`*^9}}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494172818179343*^9, 3.494172835289367*^9}, 
   3.4941728817394323`*^9, {3.4941732517099504`*^9, 3.4941732592199607`*^9}, {
   3.4941867403328547`*^9, 3.494186750597673*^9}, {3.494188482910461*^9, 
   3.494188485702866*^9}, 3.494188591549052*^9, {3.49418864176554*^9, 
   3.49418864750635*^9}, {3.4941887057880526`*^9, 3.494188733883702*^9}, {
   3.494189069767892*^9, 3.4941891152419715`*^9}, {3.494198042823061*^9, 
   3.494198045428265*^9}, {3.494198409922906*^9, 3.4941984537277822`*^9}, {
   3.495042116619762*^9, 3.495042147729806*^9}, {3.4950461207753677`*^9, 
   3.4950461572454185`*^9}, {3.4950462414355364`*^9, 
   3.4950462442055407`*^9}, {3.495046290525605*^9, 3.4950463293056593`*^9}, 
   3.4950463656257105`*^9, {3.4950776504850264`*^9, 3.4950776769450636`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"m", "\[NotEqual]", 
    RowBox[{"-", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}, {3.494173966810951*^9, 3.494174007671008*^9}, {
   3.4941741326011834`*^9, 3.4941741425911975`*^9}, {3.4941767936905165`*^9, 
   3.494176809630539*^9}, {3.4941773316412697`*^9, 3.494177333751273*^9}, {
   3.4941891756608777`*^9, 3.494189178765283*^9}, {3.4942004775317707`*^9, 
   3.494200477881771*^9}, {3.4950424099901724`*^9, 3.495042435550208*^9}, {
   3.495045573264601*^9, 3.4950455868746204`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"ArcCos", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], 
        SuperscriptBox[
         RowBox[{"ArcCos", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
       RowBox[{"m", "+", "1"}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox["n", 
    RowBox[{
     SuperscriptBox["a", 
      RowBox[{"m", "+", "1"}]], 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"n", "-", "1"}]], 
       SuperscriptBox[
        RowBox[{"Cos", "[", "x", "]"}], 
        RowBox[{"m", "+", "1"}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"ArcCos", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.4941763955899596`*^9, 3.4941764290900064`*^9}, {3.4941764605500507`*^9, 
   3.4941764930400963`*^9}, {3.4941882372412295`*^9, 3.49418823769363*^9}, {
   3.4950421850198574`*^9, 3.4950422389399333`*^9}, {3.495045295774213*^9, 
   3.495045310274233*^9}, {3.4950453750643234`*^9, 3.4950453777743273`*^9}, {
   3.495045490884486*^9, 3.4950454957944927`*^9}, {3.4950707025852995`*^9, 
   3.4950707025852995`*^9}, {3.4950777379451494`*^9, 3.4950777502951665`*^9}, 
   3.4961222685611076`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"ArcCos", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCos", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Subst", "[", 
       RowBox[{
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", 
            RowBox[{"(", 
             RowBox[{"n", "-", "1"}], ")"}]}], "*", 
           RowBox[{
            RowBox[{"Cos", "[", "x", "]"}], "^", 
            RowBox[{"(", 
             RowBox[{"m", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}], ",", "x", 
        ",", 
        RowBox[{"ArcCos", "[", 
         RowBox[{"a", "*", "x"}], "]"}]}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "\[NotEqual]", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, {
   3.4941763709899254`*^9, 3.49417638178994*^9}, {3.4950424525902324`*^9, 
   3.4950425131303167`*^9}, {3.495045395254352*^9, 3.4950455421745577`*^9}, {
   3.495045613344657*^9, 3.495045623144671*^9}, 3.495046501655901*^9, 
   3.495047583047415*^9, 3.4950476263774757`*^9, {3.4950707025852995`*^9, 
   3.4950707025952997`*^9}, {3.495077785835216*^9, 3.495077791625224*^9}, 
   3.4961222724455147`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"ArcCos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, {
   3.494172650949109*^9, 3.494172665319129*^9}, {3.494176335919876*^9, 
   3.494176356549905*^9}, {3.4941768991306643`*^9, 3.4941769105806804`*^9}, 
   3.4950707026152997`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9, 3.494172818179343*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[Cell[TextData[Cell[BoxData[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"ArcCos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], "=", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "d"]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"ArcCos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"Sin", "[", 
      RowBox[{"ArcCos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "]"}], 
     RowBox[{
      SubscriptBox["\[PartialD]", "x"], 
      RowBox[{"ArcCos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]}]}]]]], "Subsubsection",
   CellChangeTimes->{
    3.4941724567488375`*^9, {3.494172818179343*^9, 3.494172835289367*^9}, 
     3.4941728817394323`*^9, {3.4941732517099504`*^9, 
     3.4941732592199607`*^9}}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494172818179343*^9, 3.494172835289367*^9}, 
   3.4941728817394323`*^9, {3.4941732517099504`*^9, 3.4941732592199607`*^9}, {
   3.4941867403328547`*^9, 3.494186750597673*^9}, {3.494188482910461*^9, 
   3.494188485702866*^9}, 3.494188591549052*^9, {3.49418864176554*^9, 
   3.49418864750635*^9}, {3.4941887057880526`*^9, 3.494188733883702*^9}, {
   3.494189069767892*^9, 3.4941891152419715`*^9}, {3.494198042823061*^9, 
   3.494198045428265*^9}, {3.494198409922906*^9, 3.4941984537277822`*^9}, {
   3.495076159522939*^9, 3.495076162812944*^9}, {3.495076204703003*^9, 
   3.495076208293008*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}, {3.494173966810951*^9, 3.494174007671008*^9}, {
   3.4941741326011834`*^9, 3.4941741425911975`*^9}, {3.4941767936905165`*^9, 
   3.494176809630539*^9}, {3.4941773316412697`*^9, 3.494177333751273*^9}, {
   3.4941891756608777`*^9, 3.494189178765283*^9}, {3.4942004775317707`*^9, 
   3.494200477881771*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"ArcCos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox["1", "d"]}]}]}], " ", 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
       RowBox[{"Sin", "[", "x", "]"}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"ArcCos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.4941763955899596`*^9, 3.4941764290900064`*^9}, {3.4941764605500507`*^9, 
   3.4941764930400963`*^9}, 3.4941770641708956`*^9, 3.494177118590972*^9, {
   3.4941890257602143`*^9, 3.4941890417814426`*^9}, {3.494189320351132*^9, 
   3.4941893689764175`*^9}, {3.4950707026152997`*^9, 
   3.4950707026252995`*^9}, {3.495076223713029*^9, 3.4950762334830427`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"ArcCos", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "d"}], ",", 
      RowBox[{"Subst", "[", 
       RowBox[{
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}], "*", 
           RowBox[{"Sin", "[", "x", "]"}]}], ",", "x"}], "]"}], ",", "x", ",", 
        RowBox[{"ArcCos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}]}], "]"}]}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", "n", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, {
   3.4941763709899254`*^9, 3.49417638178994*^9}, 3.494176933060712*^9, {
   3.4941891975165157`*^9, 3.494189292692283*^9}, 3.4941894111744914`*^9, 
   3.494197834437895*^9, {3.494200502431805*^9, 3.4942005083118134`*^9}, {
   3.4950707026252995`*^9, 3.4950707026252995`*^9}, {3.4950762374930487`*^9, 
   3.4950762411430535`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"ArcCos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, {
   3.494172650949109*^9, 3.494172665319129*^9}, {3.494176335919876*^9, 
   3.494176356549905*^9}, {3.4941768991306643`*^9, 3.4941769105806804`*^9}, {
   3.4941962550059195`*^9, 3.49419626093393*^9}, 3.4950707026252995`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9, 3.494172818179343*^9}],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", ",
 Cell[BoxData[Cell[TextData[Cell[BoxData[
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "m"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"ArcCos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"]}], "=", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", 
       SuperscriptBox["d", 
        RowBox[{"m", "+", "1"}]]]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"ArcCos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Cos", "[", 
         RowBox[{"ArcCos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "]"}], "-", "c"}], ")"}], "m"], 
     " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"ArcCos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "]"}], 
     RowBox[{
      SubscriptBox["\[PartialD]", "x"], 
      RowBox[{"ArcCos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]}]}]]]], "Subsubsection",
   CellChangeTimes->{
    3.4941724567488375`*^9, {3.494172818179343*^9, 3.494172835289367*^9}, 
     3.4941728817394323`*^9, {3.4941732517099504`*^9, 
     3.4941732592199607`*^9}}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494172818179343*^9, 3.494172835289367*^9}, 
   3.4941728817394323`*^9, {3.4941732517099504`*^9, 3.4941732592199607`*^9}, {
   3.4941867403328547`*^9, 3.494186750597673*^9}, {3.494188482910461*^9, 
   3.494188485702866*^9}, 3.494188591549052*^9, {3.49418864176554*^9, 
   3.49418864750635*^9}, {3.4941887057880526`*^9, 3.494188733883702*^9}, {
   3.494189069767892*^9, 3.4941891152419715`*^9}, {3.494198042823061*^9, 
   3.494198045428265*^9}, {3.494198409922906*^9, 3.4941984537277822`*^9}, 
   3.494198500746265*^9, {3.494198552556757*^9, 3.4941985875008183`*^9}, {
   3.4941986433645163`*^9, 3.4941986981050124`*^9}, {3.494198728727866*^9, 
   3.4941987591167192`*^9}, {3.4950767210737257`*^9, 3.495076723223728*^9}, {
   3.495076787903819*^9, 3.4950768014238377`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", "\[NotElement]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
   " ", 
   RowBox[{"m", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}, {3.494173966810951*^9, 3.494174007671008*^9}, {
   3.4941741326011834`*^9, 3.4941741425911975`*^9}, {3.4941767936905165`*^9, 
   3.494176809630539*^9}, {3.4941773316412697`*^9, 3.494177333751273*^9}, {
   3.4941891756608777`*^9, 3.494189178765283*^9}, {3.494196711119521*^9, 
   3.4941967113535213`*^9}, {3.4941972738717093`*^9, 
   3.4941972799089203`*^9}, {3.49420053403185*^9, 3.494200549361871*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"ArcCos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox["1", 
       SuperscriptBox["d", 
        RowBox[{"m", "+", "1"}]]]}]}]}], " ", 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Cos", "[", "x", "]"}], "-", "c"}], ")"}], "m"], 
       RowBox[{"Sin", "[", "x", "]"}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"ArcCos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.4941763955899596`*^9, 3.4941764290900064`*^9}, {3.4941764605500507`*^9, 
   3.4941764930400963`*^9}, 3.4941770641708956`*^9, 3.494177118590972*^9, {
   3.4941890257602143`*^9, 3.4941890417814426`*^9}, {3.494189320351132*^9, 
   3.4941893689764175`*^9}, {3.4941960634447823`*^9, 3.494196109948464*^9}, {
   3.494196492625537*^9, 3.4941965253075943`*^9}, {3.4941967717568274`*^9, 
   3.4941967891820583`*^9}, {3.494198824027233*^9, 3.4941988799065313`*^9}, {
   3.4950707026352997`*^9, 3.4950707026352997`*^9}, {3.4950768357738857`*^9, 
   3.4950768477039027`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"ArcCos", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"d", "^", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Subst", "[", 
       RowBox[{
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}], "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Cos", "[", "x", "]"}], "-", "c"}], ")"}], "^", "m"}], 
           "*", 
           RowBox[{"Sin", "[", "x", "]"}]}], ",", "x"}], "]"}], ",", "x", ",", 
        RowBox[{"ArcCos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}]}], "]"}]}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", "n", "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, {
   3.4941763709899254`*^9, 3.49417638178994*^9}, 3.494176933060712*^9, {
   3.4941891975165157`*^9, 3.494189292692283*^9}, 3.4941894111744914`*^9, {
   3.4941961386609154`*^9, 3.494196199048621*^9}, 3.4941962310130777`*^9, {
   3.494196685551076*^9, 3.494196749355188*^9}, {3.494196855996975*^9, 
   3.494196887758631*^9}, {3.494197244138057*^9, 3.494197246946062*^9}, {
   3.494197819524268*^9, 3.4941978307718887`*^9}, {3.4941989675474854`*^9, 
   3.4941989999331427`*^9}, {3.494200557901883*^9, 3.4942005644018917`*^9}, {
   3.4950707026352997`*^9, 3.4950707026352997`*^9}, {3.495076870883935*^9, 
   3.4950768790039463`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"x", " ", 
     SuperscriptBox[
      RowBox[{"ArcCos", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], "n"]}], 
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "2"]}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, {
   3.494172650949109*^9, 3.494172665319129*^9}, {3.494176335919876*^9, 
   3.494176356549905*^9}, {3.4941768991306643`*^9, 3.4941769105806804`*^9}, {
   3.4941776449217086`*^9, 3.49417766022173*^9}, 3.4941785320029507`*^9, 
   3.4950707026453*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, 3.494173557270378*^9, {3.494176834460574*^9, 
   3.4941768354805756`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", ">", "1"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}, {3.494173966810951*^9, 3.494174007671008*^9}, {
   3.4941741326011834`*^9, 3.4941741425911975`*^9}, {3.4941767936905165`*^9, 
   3.494176809630539*^9}, {3.4941773316412697`*^9, 3.494177333751273*^9}, {
   3.4941781299723873`*^9, 3.494178211092501*^9}, {3.494178252592559*^9, 
   3.4941782798925977`*^9}, {3.49417832450266*^9, 3.494178365332717*^9}, {
   3.4941785870814295`*^9, 3.4941785879394307`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"x", " ", 
      SuperscriptBox[
       RowBox[{"ArcCos", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}], "n"]}], 
     SqrtBox[
      RowBox[{"1", "-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "2"]}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                          ", 
      "\[IndentingNewLine]", "               ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SqrtBox[
          RowBox[{"1", "-", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", " ", "x"}]}], ")"}], "2"]}]], " ", 
         SuperscriptBox[
          RowBox[{"ArcCos", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}], "]"}], "n"]}], 
        SuperscriptBox["b", "2"]]}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["n", "b"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"ArcCos", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "-", 
  RowBox[{
   FractionBox["a", "b"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"ArcCos", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}], "2"]}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.4941763955899596`*^9, 3.4941764290900064`*^9}, {3.4941764605500507`*^9, 
   3.4941764930400963`*^9}, 3.4941770641708956`*^9, 3.494177118590972*^9, 
   3.494177684591764*^9, {3.4941779313321095`*^9, 3.4941779814621797`*^9}, 
   3.494178084342324*^9, 3.4941786065034637`*^9, 3.494178689183609*^9, {
   3.495070117564481*^9, 3.495070133574503*^9}, {3.4950704193149033`*^9, 
   3.4950704526549497`*^9}, {3.4950705124550333`*^9, 3.495070521315046*^9}, {
   3.4950707026552997`*^9, 3.4950707026552997`*^9}, {3.4950763506032066`*^9, 
   3.4950763511032076`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCos", "[", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}], "/", 
      RowBox[{"Sqrt", "[", "u_", "]"}]}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Sqrt", "[", "u", "]"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCos", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", "n"}], "/", 
      RowBox[{"b", "^", "2"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"ArcCos", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}]}], ",", "x"}], "]"}]}], "]"}], " ", 
    "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcCos", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", "n"}], "/", 
         RowBox[{"Sqrt", "[", "u", "]"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"u", "-", "1", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}]}], "]"}], " ", "&&", 
    " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, {
   3.4941763709899254`*^9, 3.49417638178994*^9}, 3.494176933060712*^9, {
   3.4941774426614256`*^9, 3.494177546511571*^9}, {3.494177592181635*^9, 
   3.494177592971636*^9}, {3.4941776926217756`*^9, 3.4941777113818016`*^9}, {
   3.4941777916119137`*^9, 3.494177794051917*^9}, 3.494178543602967*^9, {
   3.4950707026552997`*^9, 3.4950707026652994`*^9}, 3.4950763075331464`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox[
    RowBox[{"ArcCos", "[", 
     FractionBox["c", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}]], "]"}], "m"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, {
   3.494172650949109*^9, 3.494172665319129*^9}, {3.494176335919876*^9, 
   3.494176356549905*^9}, {3.4941768991306643`*^9, 3.4941769105806804`*^9}, {
   3.4941776449217086`*^9, 3.49417766022173*^9}, 3.4941785320029507`*^9, 
   3.4941787397900977`*^9, 3.4950707026752996`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation:  Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, 3.494173557270378*^9, {3.494176834460574*^9, 
   3.4941768354805756`*^9}, 3.4941787608189344`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"ArcCos", "[", "z", "]"}], "=", 
   RowBox[{"ArcSec", "[", 
    FractionBox["1", "z"], "]"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, 3.494173557270378*^9, {3.494176834460574*^9, 
   3.4941768354805756`*^9}, {3.4941787608189344`*^9, 3.494178801550606*^9}, {
   3.4950707026853*^9, 3.4950707026853*^9}, {3.4950764103432903`*^9, 
   3.4950764116932926`*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}, {3.494173966810951*^9, 3.494174007671008*^9}, {
   3.4941741326011834`*^9, 3.4941741425911975`*^9}, {3.4941767936905165`*^9, 
   3.494176809630539*^9}, {3.4941773316412697`*^9, 3.494177333751273*^9}, {
   3.4941781299723873`*^9, 3.494178211092501*^9}, {3.494178252592559*^9, 
   3.4941782798925977`*^9}, {3.49417832450266*^9, 3.494178365332717*^9}, {
   3.4941785870814295`*^9, 3.4941785879394307`*^9}, 3.4941788167606325`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox[
    RowBox[{"ArcCos", "[", 
     FractionBox["c", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}]], "]"}], "m"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{"u", " ", 
       SuperscriptBox[
        RowBox[{"ArcSec", "[", 
         RowBox[{
          FractionBox["a", "c"], "+", 
          FractionBox[
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}], "c"]}], "]"}], "m"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.4941763955899596`*^9, 3.4941764290900064`*^9}, {3.4941764605500507`*^9, 
   3.4941764930400963`*^9}, 3.4941770641708956`*^9, 3.494177118590972*^9, 
   3.494177684591764*^9, {3.4941779313321095`*^9, 3.4941779814621797`*^9}, 
   3.494178084342324*^9, 3.4941786065034637`*^9, 3.494178689183609*^9, {
   3.4941788294122553`*^9, 3.4941788693171253`*^9}, 3.4950707026853*^9, {
   3.495076422903308*^9, 3.495076423833309*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{
      RowBox[{"ArcCos", "[", 
       RowBox[{"c_.", "/", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", 
           RowBox[{"x_", "^", "n_."}]}]}], ")"}]}], "]"}], "^", "m_."}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"u", "*", 
      RowBox[{
       RowBox[{"ArcSec", "[", 
        RowBox[{
         RowBox[{"a", "/", "c"}], "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"x", "^", "n"}], "/", "c"}]}]}], "]"}], "^", "m"}]}], ",", 
     "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "n", ",", "m"}], "}"}], ",", 
     "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, {
   3.4941763709899254`*^9, 3.49417638178994*^9}, 3.494176933060712*^9, {
   3.4941774426614256`*^9, 3.494177546511571*^9}, {3.494177592181635*^9, 
   3.494177592971636*^9}, {3.4941776926217756`*^9, 3.4941777113818016`*^9}, {
   3.4941777916119137`*^9, 3.494177794051917*^9}, 3.494178543602967*^9, 
   3.4941789047135873`*^9, 3.4950707026853*^9, 3.4950764031132803`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["f", 
    RowBox[{"c", " ", 
     RowBox[{"ArcCos", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, 3.4802882652733135`*^9, 3.480288373839424*^9, {
   3.480299236238787*^9, 3.480299238211624*^9}, {3.4803010920372944`*^9, 
   3.480301103143264*^9}, 3.492825791291954*^9, 3.4933227311790323`*^9, 
   3.494000874095703*^9, {3.4941793324039383`*^9, 3.494179370184005*^9}, 
   3.4941794677465763`*^9, 3.4950707026953*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox[
      RowBox[{"Log", "[", "f", "]"}], "2"]}]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4941737492506466`*^9, 
   3.4941737506706486`*^9}, {3.494173966810951*^9, 3.494174007671008*^9}, {
   3.4941741326011834`*^9, 3.4941741425911975`*^9}, {3.4941767936905165`*^9, 
   3.494176809630539*^9}, {3.4941773316412697`*^9, 3.494177333751273*^9}, {
   3.4941781299723873`*^9, 3.494178211092501*^9}, {3.494178252592559*^9, 
   3.4941782798925977`*^9}, {3.49417832450266*^9, 3.494178365332717*^9}, {
   3.4941785870814295`*^9, 3.4941785879394307`*^9}, {3.4941796318276644`*^9, 
   3.4941796418116817`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["f", 
    RowBox[{"c", " ", 
     RowBox[{"ArcCos", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "-", 
       RowBox[{"c", " ", 
        SqrtBox[
         RowBox[{"1", "-", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", " ", "x"}]}], ")"}], "2"]}]], " ", 
        RowBox[{"Log", "[", "f", "]"}]}]}], 
      RowBox[{"b", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox[
           RowBox[{"Log", "[", "f", "]"}], "2"]}]}], ")"}]}]]}]}], 
   SuperscriptBox["f", 
    RowBox[{"c", " ", 
     RowBox[{"ArcCos", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}]]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.48029928226497*^9, 3.4802993300937443`*^9}, 
   3.4802995783907776`*^9, {3.480299703450605*^9, 3.480299715728259*^9}, 
   3.4940008741337056`*^9, {3.4940431424186068`*^9, 3.4940431752074823`*^9}, 
   3.494179334790743*^9, 3.494179491443018*^9, 3.4941795557463307`*^9, {
   3.4950707027053*^9, 3.4950707027053*^9}, {3.4950766229035883`*^9, 
   3.4950766232135887`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"f_", "^", 
     RowBox[{"(", 
      RowBox[{"c_.", "*", 
       RowBox[{"ArcCos", "[", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", "x_"}]}], "]"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "^", 
     RowBox[{"(", 
      RowBox[{"c", "*", 
       RowBox[{"ArcCos", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}]}], ")"}]}], "*", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}], "-", 
       RowBox[{"c", "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"1", "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}]}], "]"}], "*", 
        RowBox[{"Log", "[", "f", "]"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"b", "*", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          RowBox[{"c", "^", "2"}], "*", 
          RowBox[{
           RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}]}], ")"}]}], ")"}]}]}],
    " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "f"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"c", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{
  3.494000874144706*^9, {3.494043192703483*^9, 3.4940432117585726`*^9}, 
   3.4941793362103453`*^9, 3.4941795951988*^9, {3.4950707027053*^9, 
   3.4950707027053*^9}, 3.4950765767435236`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"v", " ", 
   RowBox[{"ArcCos", "[", "u", "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160783652334`*^9, 3.4796867206047907`*^9, 3.492825781557537*^9, 
   3.4940008742017097`*^9, {3.494179192846093*^9, 3.4941791992265043`*^9}, 
   3.4950707027152996`*^9, {3.4961210983182535`*^9, 3.4961210986146536`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell["Rule: If u is free of inverse functions, then", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703531363038*^9, 
   3.4807035352686543`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"ArcCos", "[", "u", "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "x"}]}], " ", 
    RowBox[{"ArcCos", "[", "u", "]"}]}]}], "+", 
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"x", " ", 
      RowBox[{
       SubscriptBox["\[PartialD]", "x"], "u"}]}], 
     SqrtBox[
      RowBox[{"1", "-", 
       SuperscriptBox["u", "2"]}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579734230976`*^9, 3.4796580026851745`*^9}, {
   3.479658101347043*^9, 3.479658102348483*^9}, {3.4796582237129965`*^9, 
   3.4796582279090304`*^9}, {3.4796611944647284`*^9, 3.4796612203719807`*^9}, 
   3.4796613933206687`*^9, {3.4796614761798143`*^9, 3.4796614777420607`*^9}, 
   3.4796618658000607`*^9, {3.4796619856624146`*^9, 3.4796619866938972`*^9}, {
   3.4796645712002354`*^9, 3.4796645805536847`*^9}, 3.4796646283424015`*^9, {
   3.4796867206148047`*^9, 3.4796867206148047`*^9}, {3.479687667676613*^9, 
   3.479687667926973*^9}, 3.480705232098576*^9, {3.49400087421271*^9, 
   3.49400087421371*^9}, {3.494022456770984*^9, 3.4940224580430565`*^9}, {
   3.494179204577314*^9, 3.4941792454181857`*^9}, {3.4950707027253*^9, 
   3.4950707027253*^9}, {3.495076530383458*^9, 3.495076530783459*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"ArcCos", "[", "u_", "]"}], ",", "x_Symbol"}], "]"}], " ", ":=", 
  "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{"ArcCos", "[", "u", "]"}]}], " ", "+", "\n", "  ", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"Regularize", "[", 
       RowBox[{
        RowBox[{"x", "*", 
         RowBox[{
          RowBox[{"D", "[", 
           RowBox[{"u", ",", "x"}], "]"}], "/", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"1", "-", 
            RowBox[{"u", "^", "2"}]}], "]"}]}]}], ",", "x"}], "]"}], ",", 
      "x"}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"InverseFunctionFreeQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"FunctionOfExponentialOfLinear", "[", 
      RowBox[{"u", ",", "x"}], "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.49400087422171*^9, 3.4940008742237105`*^9}, {
   3.494022461285242*^9, 3.4940224616042604`*^9}, 3.4941791634400415`*^9, 
   3.494179261657814*^9, {3.4943677210722713`*^9, 3.494367728102281*^9}, {
   3.4950707027353*^9, 3.4950707027353*^9}, {3.495076515833438*^9, 
   3.4950765162834387`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}], "\[And]"}]]],
 " u is free of inverse functions, then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.4807035587524223`*^9, 
   3.4807036202508526`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    RowBox[{"ArcCos", "[", "u", "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        RowBox[{"ArcCos", "[", "u", "]"}]}], 
       RowBox[{"m", "+", "1"}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"m", "+", "1"}]], " ", 
       RowBox[{
        SubscriptBox["\[PartialD]", "x"], "u"}]}], 
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["u", "2"]}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579734230976`*^9, 3.4796580026851745`*^9}, {
   3.479658101347043*^9, 3.479658102348483*^9}, {3.4796582237129965`*^9, 
   3.4796582279090304`*^9}, {3.4796611944647284`*^9, 3.4796612203719807`*^9}, 
   3.4796613933206687`*^9, {3.4796614761798143`*^9, 3.4796614777420607`*^9}, 
   3.4796618658000607`*^9, {3.4796619856624146`*^9, 3.4796619866938972`*^9}, {
   3.4796645712002354`*^9, 3.4796645805536847`*^9}, 3.4796646283424015`*^9, {
   3.4796867206148047`*^9, 3.4796867206148047`*^9}, {3.479687667676613*^9, 
   3.479687667926973*^9}, 3.480705232098576*^9, {3.49400087421271*^9, 
   3.49400087421371*^9}, {3.494022456770984*^9, 3.4940224580430565`*^9}, {
   3.494179204577314*^9, 3.4941792454181857`*^9}, {3.4960892166318407`*^9, 
   3.4960892496218863`*^9}, {3.4961211057438664`*^9, 3.496121106196267*^9}, {
   3.496121138485124*^9, 3.4961211387971244`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"ArcCos", "[", "u_", "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"ArcCos", "[", "u", "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"Regularize", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", 
            RowBox[{"(", 
             RowBox[{"m", "+", "1"}], ")"}]}], "*", 
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{"u", ",", "x"}], "]"}], "/", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"1", "-", 
              RowBox[{"u", "^", "2"}]}], "]"}]}]}], ",", "x"}], "]"}], ",", 
        "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"m", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"InverseFunctionFreeQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", "\n", "\t", 
    RowBox[{"Not", "[", 
     RowBox[{"FunctionOfQ", "[", 
      RowBox[{
       RowBox[{"x", "^", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ",", "u", ",", "x"}], "]"}], "]"}],
     " ", "&&", " ", "\n", "\t", 
    RowBox[{"Not", "[", 
     RowBox[{"FunctionOfExponentialOfLinear", "[", 
      RowBox[{"u", ",", "x"}], "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494000874248712*^9, 3.4940008742507124`*^9}, {
   3.4940225275160303`*^9, 3.4940225278660507`*^9}, {3.4960893203419857`*^9, 
   3.4960893431620173`*^9}, 3.4960894094721107`*^9, {3.4961211070854683`*^9, 
   3.4961211075378695`*^9}, {3.4961211416987295`*^9, 3.49612114204193*^9}},
 Background->GrayLevel[0.85]]
}, Closed]]
},
AutoGeneratedPackage->Automatic,
CellGrouping->Manual,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  "Integration Rules for Inverse Cosine Functions", None, None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->28.8},
Magnification->1.5,
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 978, 21, 128, "Title"],
Cell[1548, 45, 282, 4, 190, "Subsubsection"],
Cell[1833, 51, 101, 1, 135, "Subsubsection"],
Cell[1937, 54, 732, 10, 135, "Subsubsection"],
Cell[2672, 66, 1773, 41, 393, "Subsubtitle"],
Cell[4448, 109, 795, 11, 190, "Subsubsection"],
Cell[5246, 122, 1187, 35, 559, "Code"],
Cell[6436, 159, 113, 2, 190, "Subsubsection"],
Cell[6552, 163, 311, 5, 135, "Subsubsection"],
Cell[6866, 170, 132, 1, 135, "Subsubsection"],
Cell[7001, 173, 839, 16, 141, "Subsubsection"],
Cell[7843, 191, 2550, 63, 697, "Subsubtitle"],
Cell[10396, 256, 795, 11, 190, "Subsubsection"],
Cell[11194, 269, 2026, 61, 832, "Code"],
Cell[13223, 332, 113, 2, 190, "Subsubsection"],
Cell[13339, 336, 130, 1, 135, "Subsubsection"],
Cell[13472, 339, 674, 20, 222, "Subsubsection"],
Cell[14149, 361, 734, 10, 135, "Subsubsection"],
Cell[14886, 373, 1560, 33, 333, "Subsubtitle"],
Cell[16449, 408, 795, 11, 190, "Subsubsection"],
Cell[17247, 421, 906, 25, 559, "Code"],
Cell[18156, 448, 113, 2, 190, "Subsubsection"],
Cell[18272, 452, 233, 3, 135, "Subsubsection"],
Cell[18508, 457, 799, 22, 222, "Subsubsection"],
Cell[19310, 481, 732, 10, 135, "Subsubsection"],
Cell[20045, 493, 1939, 44, 433, "Subsubtitle"],
Cell[21987, 539, 795, 11, 190, "Subsubsection"],
Cell[22785, 552, 1326, 39, 559, "Code"],
Cell[24114, 593, 113, 2, 190, "Subsubsection"],
Cell[24230, 597, 233, 3, 135, "Subsubsection"],
Cell[24466, 602, 769, 23, 225, "Subsubsection"],
Cell[25238, 627, 732, 10, 135, "Subsubsection"],
Cell[25973, 639, 1868, 41, 405, "Subsubtitle"],
Cell[27844, 682, 795, 11, 190, "Subsubsection"],
Cell[28642, 695, 1211, 34, 559, "Code"],
Cell[29856, 731, 113, 2, 190, "Subsubsection"],
Cell[29972, 735, 278, 4, 135, "Subsubsection"],
Cell[30253, 741, 732, 10, 135, "Subsubsection"],
Cell[30988, 753, 2131, 50, 405, "Subsubtitle"],
Cell[33122, 805, 795, 11, 190, "Subsubsection"],
Cell[33920, 818, 1491, 42, 559, "Code"],
Cell[35414, 862, 113, 2, 190, "Subsubsection"],
Cell[35530, 866, 246, 3, 135, "Subsubsection"],
Cell[35779, 871, 1052, 21, 141, "Subsubsection"],
Cell[36834, 894, 2969, 77, 748, "Subsubtitle"],
Cell[39806, 973, 795, 11, 190, "Subsubsection"],
Cell[40604, 986, 2594, 79, 832, "Code"],
Cell[43201, 1067, 113, 2, 190, "Subsubsection"],
Cell[43317, 1071, 1069, 21, 141, "Subsubsection"],
Cell[44389, 1094, 2855, 68, 337, "Subsubtitle"],
Cell[47247, 1164, 795, 11, 190, "Subsubsection"],
Cell[48045, 1177, 2579, 73, 832, "Code"],
Cell[50627, 1252, 44, 1, 22, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[50708, 1258, 1037, 22, 87, "Title"],
Cell[51748, 1282, 330, 5, 427, "Subsubsection"],
Cell[52081, 1289, 178, 3, 303, "Subsubsection"],
Cell[52262, 1294, 1025, 19, 316, "Subsubsection"],
Cell[53290, 1315, 2276, 53, 973, "Subsubtitle"],
Cell[55569, 1370, 795, 11, 427, "Subsubsection"],
Cell[56367, 1383, 1939, 55, 1567, "Code"],
Cell[58309, 1440, 44, 1, 49, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[58390, 1446, 1089, 23, 87, "Title"],
Cell[59482, 1471, 1170, 16, 85, "Subsubsection"],
Cell[60655, 1489, 2180, 44, 181, "Subsubtitle"],
Cell[62838, 1535, 795, 11, 85, "Subsubsection"],
Cell[63636, 1548, 1963, 42, 249, "Code"],
Cell[65602, 1592, 113, 2, 85, "Subsubsection"],
Cell[65718, 1596, 1170, 16, 60, "Subsubsection"],
Cell[66891, 1614, 2658, 59, 195, "Subsubtitle"],
Cell[69552, 1675, 795, 11, 85, "Subsubsection"],
Cell[70350, 1688, 2433, 55, 249, "Code"],
Cell[72786, 1745, 113, 2, 85, "Subsubsection"],
Cell[72902, 1749, 1221, 21, 63, "Subsubsection"],
Cell[74126, 1772, 3123, 72, 342, "Subsubtitle"],
Cell[77252, 1846, 795, 11, 85, "Subsubsection"],
Cell[78050, 1859, 2945, 75, 370, "Code"],
Cell[80998, 1936, 113, 2, 85, "Subsubsection"],
Cell[81114, 1940, 1282, 24, 63, "Subsubsection"],
Cell[82399, 1966, 3463, 86, 346, "Subsubtitle"],
Cell[85865, 2054, 795, 11, 85, "Subsubsection"],
Cell[86663, 2067, 3455, 94, 432, "Code"],
Cell[90121, 2163, 113, 2, 85, "Subsubsection"],
Cell[90237, 2167, 1273, 21, 63, "Subsubsection"],
Cell[91513, 2190, 2824, 66, 193, "Subsubtitle"],
Cell[94340, 2258, 795, 11, 85, "Subsubsection"],
Cell[95138, 2271, 2960, 72, 370, "Code"],
Cell[98101, 2345, 113, 2, 85, "Subsubsection"],
Cell[98217, 2349, 1386, 25, 63, "Subsubsection"],
Cell[99606, 2376, 4391, 119, 490, "Subsubtitle"],
Cell[104000, 2497, 795, 11, 85, "Subsubsection"],
Cell[104798, 2510, 4902, 135, 492, "Code"],
Cell[109703, 2647, 113, 2, 85, "Subsubsection"],
Cell[109819, 2651, 1409, 26, 63, "Subsubsection"],
Cell[111231, 2679, 4386, 119, 496, "Subsubtitle"],
Cell[115620, 2800, 795, 11, 85, "Subsubsection"],
Cell[116418, 2813, 4845, 136, 492, "Code"],
Cell[121266, 2951, 113, 2, 85, "Subsubsection"],
Cell[121382, 2955, 130, 1, 60, "Subsubsection"],
Cell[121515, 2958, 1650, 39, 108, "Subsubsection"],
Cell[123168, 2999, 1339, 23, 63, "Subsubsection"],
Cell[124510, 3024, 2125, 43, 150, "Subsubtitle"],
Cell[126638, 3069, 795, 11, 85, "Subsubsection"],
Cell[127436, 3082, 1559, 40, 249, "Code"],
Cell[128998, 3124, 113, 2, 85, "Subsubsection"],
Cell[129114, 3128, 241, 3, 60, "Subsubsection"],
Cell[129358, 3133, 2137, 54, 130, "Subsubsection"],
Cell[131498, 3189, 1367, 24, 63, "Subsubsection"],
Cell[132868, 3215, 2565, 59, 159, "Subsubtitle"],
Cell[135436, 3276, 795, 11, 85, "Subsubsection"],
Cell[136234, 3289, 2334, 64, 310, "Code"],
Cell[138571, 3355, 44, 1, 10, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[138652, 3361, 1171, 26, 87, "Title"],
Cell[139826, 3389, 130, 1, 640, "Subsubsection"],
Cell[139959, 3392, 1739, 44, 729, "Subsubsection"],
Cell[141701, 3438, 1177, 20, 474, "Subsubsection"],
Cell[142881, 3460, 2175, 47, 1066, "Subsubtitle"],
Cell[145059, 3509, 795, 11, 640, "Subsubsection"],
Cell[145857, 3522, 1757, 47, 1885, "Code"],
Cell[147617, 3571, 44, 1, 73, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[147698, 3577, 1248, 27, 87, "Title"],
Cell[148949, 3606, 130, 1, 640, "Subsubsection"],
Cell[149082, 3609, 2353, 61, 729, "Subsubsection"],
Cell[151438, 3672, 1423, 25, 474, "Subsubsection"],
Cell[152864, 3699, 2602, 57, 1093, "Subsubtitle"],
Cell[155469, 3758, 795, 11, 640, "Subsubsection"],
Cell[156267, 3771, 2472, 63, 1885, "Code"],
Cell[158742, 3836, 44, 1, 73, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[158823, 3842, 1365, 32, 134, "Title"],
Cell[160191, 3876, 178, 3, 640, "Subsubsection"],
Cell[160372, 3881, 1242, 21, 474, "Subsubsection"],
Cell[161617, 3904, 3410, 85, 3118, "Subsubtitle"],
Cell[165030, 3991, 795, 11, 640, "Subsubsection"],
Cell[165828, 4004, 2477, 69, 2808, "Code"],
Cell[168308, 4075, 44, 1, 73, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[168389, 4081, 1249, 26, 88, "Title"],
Cell[169641, 4109, 207, 3, 640, "Subsubsection"],
Cell[169851, 4114, 451, 12, 688, "Subsubsection"],
Cell[170305, 4128, 1191, 16, 454, "Subsubsection"],
Cell[171499, 4146, 2071, 42, 1095, "Subsubtitle"],
Cell[173573, 4190, 795, 11, 640, "Subsubsection"],
Cell[174371, 4203, 1487, 38, 1885, "Code"],
Cell[175861, 4243, 44, 1, 73, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[175942, 4249, 904, 21, 87, "Title"],
Cell[176849, 4272, 1443, 27, 657, "Subsubsection"],
Cell[178295, 4301, 1482, 42, 1459, "Subsubtitle"],
Cell[179780, 4345, 771, 11, 640, "Subsubsection"],
Cell[180554, 4358, 1778, 56, 1885, "Code"],
Cell[182335, 4416, 44, 1, 73, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[182416, 4422, 843, 17, 87, "Title"],
Cell[183262, 4441, 57, 0, 127, "Subsubsection"],
Cell[183322, 4443, 729, 10, 90, "Subsubsection"],
Cell[184054, 4455, 1436, 32, 289, "Subsubtitle"],
Cell[185493, 4489, 771, 11, 127, "Subsubsection"],
Cell[186267, 4502, 1241, 33, 465, "Code"],
Cell[187511, 4537, 89, 2, 127, "Subsubsection"],
Cell[187603, 4541, 57, 0, 90, "Subsubsection"],
Cell[187663, 4543, 856, 17, 94, "Subsubsection"],
Cell[188522, 4562, 1797, 44, 289, "Subsubtitle"],
Cell[190322, 4608, 771, 11, 127, "Subsubsection"],
Cell[191096, 4621, 2123, 59, 648, "Code"]
}, Closed]]
}
]
*)

(* End of internal cache information *)
