(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    624326,      15932]
NotebookOptionsPosition[    595702,      15296]
NotebookOutlinePosition[    596835,      15335]
CellTagsIndexPosition[    596792,      15332]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"ArcCoth", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099030301293*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: CRC 586, A&S 4.6.48", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4940991200114183`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"ArcCoth", "[", 
     RowBox[{"a", " ", "x"}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "x"}]}], " ", 
    RowBox[{"ArcCoth", "[", 
     RowBox[{"a", " ", "x"}], "]"}]}]}], "+", 
  FractionBox[
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", 
     RowBox[{
      SuperscriptBox["a", "2"], 
      SuperscriptBox["x", "2"]}]}], "]"}], 
   RowBox[{"2", "a"}]]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, {3.494099031241294*^9, 
   3.494099031701295*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"ArcCoth", "[", 
     RowBox[{"a_.", "*", "x_"}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=", 
  "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", "*", "x"}], "]"}]}], " ", "+", " ", 
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "*", 
        RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", "a"}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{"a", ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
  3.4940972668388243`*^9, 3.4940972723188314`*^9}, {3.4940990327812967`*^9, 
  3.4940990335712976`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "x"}]}], " ", 
    SuperscriptBox[
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"]}]}], "-", 
  RowBox[{"a", " ", "n", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"x", " ", 
       SuperscriptBox[
        RowBox[{"ArcCoth", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "-", "1"}]]}], 
      RowBox[{"1", "-", 
       RowBox[{
        SuperscriptBox["a", "2"], 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.4940990342812986`*^9, 
   3.494099036381301*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", "n"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"x", "*", 
         RowBox[{
          RowBox[{
           RowBox[{"ArcCoth", "[", 
            RowBox[{"a", "*", "x"}], "]"}], "^", 
           RowBox[{"(", 
            RowBox[{"n", "-", "1"}], ")"}]}], "/", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{
             RowBox[{"a", "^", "2"}], "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
  3.494099037591303*^9, 3.4940990393713055`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"ArcCoth", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.492802747642827*^9, 
   3.492802751137233*^9}, 3.4928222777249804`*^9, 3.492825819138003*^9, {
   3.492830644352556*^9, 3.492830644712557*^9}, 3.493766716965833*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Iterated integration by parts", "Subsubsection",
 CellChangeTimes->{{3.493099207935931*^9, 3.4930992149659414`*^9}, {
  3.4940052861338797`*^9, 3.4940052928402634`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.493098879405472*^9, 3.493098884745479*^9}, {3.493099207935931*^9, 
   3.4930992149659414`*^9}, 3.4930996737265835`*^9, 3.493099827186798*^9, {
   3.4932434943005557`*^9, 3.493243522320595*^9}, {3.494005203823172*^9, 
   3.494005223116276*^9}, {3.4940055732323008`*^9, 3.4940055743073626`*^9}, 
   3.4940057909347525`*^9, 3.494006120923627*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"ArcCoth", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"], 
        RowBox[{"2", 
         SuperscriptBox["a", "2"]}]]}]}]}]}]}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["x", "2"], 
    SuperscriptBox[
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"]}], "2"], "+", 
  RowBox[{
   FractionBox["n", 
    RowBox[{"2", "a"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493098332554706*^9, 3.4930984922049294`*^9}, {
   3.4930985835950575`*^9, 3.4930986777351894`*^9}, {3.4930988533254347`*^9, 
   3.4930988578754416`*^9}, {3.493099207935931*^9, 3.4930992149659414`*^9}, {
   3.4930993574561405`*^9, 3.493099400886202*^9}, {3.493099526816378*^9, 
   3.49309953534639*^9}, 3.4931705981281786`*^9, {3.493170768098417*^9, 
   3.4931708122284784`*^9}, {3.4940050446890697`*^9, 
   3.4940051357132764`*^9}, {3.494005409976963*^9, 3.494005469155348*^9}, {
   3.4940101517571774`*^9, 3.494010179840784*^9}, {3.494010370766704*^9, 
   3.4940103752849627`*^9}, {3.494014352962473*^9, 3.4940143541175385`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.4940053078671227`*^9, 3.494005310026246*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "*", 
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", 
       RowBox[{"a", "^", "2"}]}], ")"}]}], " ", "+", " ", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", "2"}]}], " ", "+", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "a"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"ArcCoth", "[", 
          RowBox[{"a", "*", "x"}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4928302625720215`*^9, 3.4928303000920744`*^9}, {
   3.4928305645624447`*^9, 3.4928305746224585`*^9}, {3.4930994731463027`*^9, 
   3.4930995793864517`*^9}, {3.4931708257484975`*^9, 3.493170933088648*^9}, {
   3.493170964658692*^9, 3.4931709750387063`*^9}, {3.493171201919024*^9, 
   3.493171205079028*^9}, {3.493171366199254*^9, 3.4931713665792546`*^9}, {
   3.4931715056494493`*^9, 3.49317150626945*^9}, {3.4932434733805265`*^9, 
   3.4932434776305323`*^9}, 3.4932442598016276`*^9, 3.4932444119118404`*^9, {
   3.494004039303565*^9, 3.4940040800098934`*^9}, {3.4940049144956236`*^9, 
   3.4940049151486607`*^9}, {3.4940049727389545`*^9, 
   3.4940049792463264`*^9}, {3.4940054842162094`*^9, 3.494005590086265*^9}, 
   3.494005794311946*^9, {3.494006124318821*^9, 3.494006126234931*^9}, 
   3.4940095020830183`*^9, {3.494010209237465*^9, 3.494010224615345*^9}, {
   3.4940103892347603`*^9, 3.4940104095319214`*^9}, {3.4940143551876*^9, 
   3.494014356326665*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Iterated integration by parts", "Subsubsection",
 CellChangeTimes->{{3.493099207935931*^9, 3.4930992149659414`*^9}, {
  3.4940052861338797`*^9, 3.4940052928402634`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"m", ">", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.493098879405472*^9, 3.493098884745479*^9}, {3.493099207935931*^9, 
   3.4930992149659414`*^9}, 3.4930996737265835`*^9, 3.493099827186798*^9, {
   3.4932434943005557`*^9, 3.493243522320595*^9}, {3.494005203823172*^9, 
   3.494005223116276*^9}, {3.494005912167687*^9, 3.494005912167687*^9}, {
   3.494005996704522*^9, 3.494006005111003*^9}, {3.4940120035220923`*^9, 
   3.4940120062372475`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox["x", 
          RowBox[{"m", "-", "1"}]], " ", 
         SuperscriptBox[
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["x", 
     RowBox[{"m", "+", "1"}]], 
    SuperscriptBox[
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
   RowBox[{"m", "+", "1"}]], "+", 
  "                                                ", "\[IndentingNewLine]", 
  "                                                ", 
  RowBox[{
   FractionBox["n", 
    RowBox[{"a", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"m", "-", "1"}], 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493098332554706*^9, 3.4930984922049294`*^9}, {
   3.4930985835950575`*^9, 3.4930986777351894`*^9}, {3.4930988533254347`*^9, 
   3.4930988578754416`*^9}, {3.493099207935931*^9, 3.4930992149659414`*^9}, {
   3.4930993574561405`*^9, 3.493099400886202*^9}, {3.493099526816378*^9, 
   3.49309953534639*^9}, 3.4931705981281786`*^9, {3.493170768098417*^9, 
   3.4931708122284784`*^9}, {3.4940050446890697`*^9, 
   3.4940051357132764`*^9}, {3.494010254898077*^9, 3.4940102990006*^9}, {
   3.494010355515832*^9, 3.4940103650133753`*^9}, {3.494014356960702*^9, 
   3.4940143583747826`*^9}, {3.4940159690999107`*^9, 3.494015973514163*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.4940053078671227`*^9, 3.494005310026246*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"m", "-", "1"}], ")"}]}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", 
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4928302625720215`*^9, 3.4928303000920744`*^9}, {
   3.4928305645624447`*^9, 3.4928305746224585`*^9}, {3.4930994731463027`*^9, 
   3.4930995793864517`*^9}, {3.4931708257484975`*^9, 3.493170933088648*^9}, {
   3.493170964658692*^9, 3.4931709750387063`*^9}, {3.493171201919024*^9, 
   3.493171205079028*^9}, {3.493171366199254*^9, 3.4931713665792546`*^9}, {
   3.4931715056494493`*^9, 3.49317150626945*^9}, {3.4932434733805265`*^9, 
   3.4932434776305323`*^9}, 3.4932442598016276`*^9, 3.4932444119118404`*^9, {
   3.494004039303565*^9, 3.4940040800098934`*^9}, {3.4940049144956236`*^9, 
   3.4940049151486607`*^9}, {3.4940049727389545`*^9, 3.4940049792463264`*^9}, 
   3.4940059089755044`*^9, {3.494006032487569*^9, 3.4940060554328814`*^9}, 
   3.4940094923844633`*^9, {3.4940103280942636`*^9, 3.4940103492304726`*^9}, {
   3.4940104554925504`*^9, 3.4940104824550924`*^9}, {3.4940119781816435`*^9, 
   3.494011987537178*^9}, {3.4940143591158247`*^9, 3.4940143622250023`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{{3.493099207935931*^9, 3.4930992149659414`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.493098879405472*^9, 3.493098884745479*^9}, {3.493099207935931*^9, 
   3.4930992149659414`*^9}, 3.4930996737265835`*^9, 3.493099827186798*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], "x"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "2"}]}], " ", 
    SuperscriptBox[
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
    RowBox[{"ArcCoth", "[", 
     RowBox[{"1", "-", 
      FractionBox["2", 
       RowBox[{"1", "-", 
        RowBox[{"a", " ", "x"}]}]]}], "]"}]}]}], "-", 
  RowBox[{"2", "a", " ", "n", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"ArcCoth", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "-", "1"}]], " ", 
       RowBox[{"ArcCoth", "[", 
        RowBox[{"1", "-", 
         FractionBox["2", 
          RowBox[{"1", "-", 
           RowBox[{"a", " ", "x"}]}]]}], "]"}]}], 
      RowBox[{"1", "-", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 PageWidth->Infinity,
 CellChangeTimes->{{3.493098332554706*^9, 3.4930984922049294`*^9}, {
   3.4930985835950575`*^9, 3.4930986777351894`*^9}, {3.4930988533254347`*^9, 
   3.4930988578754416`*^9}, {3.493099207935931*^9, 3.4930992149659414`*^9}, {
   3.4930993574561405`*^9, 3.493099400886202*^9}, {3.493099526816378*^9, 
   3.49309953534639*^9}, 3.4931705981281786`*^9, {3.4937667169958334`*^9, 
   3.493766717005833*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}], "/", "x_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "*", 
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "*", 
     RowBox[{"ArcCoth", "[", 
      RowBox[{"1", "-", 
       RowBox[{"2", "/", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"a", "*", "x"}]}], ")"}]}]}], "]"}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"2", "*", "a", "*", "n"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcCoth", "[", 
           RowBox[{"1", "-", 
            RowBox[{"2", "/", 
             RowBox[{"(", 
              RowBox[{"1", "-", 
               RowBox[{"a", "*", "x"}]}], ")"}]}]}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{
             RowBox[{"a", "^", "2"}], "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4928302625720215`*^9, 3.4928303000920744`*^9}, {
  3.4928305645624447`*^9, 3.4928305746224585`*^9}, {3.4930994731463027`*^9, 
  3.4930995793864517`*^9}, {3.493766717005833*^9, 3.4937667170158334`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{{3.493099207935931*^9, 3.4930992149659414`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.493098879405472*^9, 3.493098884745479*^9}, {3.493099207935931*^9, 
   3.4930992149659414`*^9}, 3.4930996737265835`*^9, 3.493099827186798*^9, {
   3.4932434943005557`*^9, 3.493243522320595*^9}, {3.4940131571360755`*^9, 
   3.494013161549328*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     SuperscriptBox["x", "2"]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"ArcCoth", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"], "x"]}]}]}]}]}], "+", 
  RowBox[{"a", " ", "n", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", " ", "x"}], "]"}], 
       RowBox[{"n", "-", "1"}]], 
      RowBox[{"x", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["x", "2"]}]}], ")"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493098332554706*^9, 3.4930984922049294`*^9}, {
   3.4930985835950575`*^9, 3.4930986777351894`*^9}, {3.4930988533254347`*^9, 
   3.4930988578754416`*^9}, {3.493099207935931*^9, 3.4930992149659414`*^9}, {
   3.4930993574561405`*^9, 3.493099400886202*^9}, {3.493099526816378*^9, 
   3.49309953534639*^9}, 3.4931705981281786`*^9, {3.493170768098417*^9, 
   3.4931708122284784`*^9}, {3.494013179298343*^9, 3.4940132717176294`*^9}, {
   3.4940145278084736`*^9, 3.4940145284565105`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
     RowBox[{"x_", "^", "2"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
  "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], "/", "x"}], " ", "+", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", "n"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "/", 
         RowBox[{"(", 
          RowBox[{"x", "*", 
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{
              RowBox[{"a", "^", "2"}], "*", 
              RowBox[{"x", "^", "2"}]}]}], ")"}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4928302625720215`*^9, 3.4928303000920744`*^9}, {
   3.4928305645624447`*^9, 3.4928305746224585`*^9}, {3.4930994731463027`*^9, 
   3.4930995793864517`*^9}, {3.4931708257484975`*^9, 3.493170933088648*^9}, {
   3.493170964658692*^9, 3.4931709750387063`*^9}, {3.493171201919024*^9, 
   3.493171205079028*^9}, {3.493171366199254*^9, 3.4931713665792546`*^9}, {
   3.4931715056494493`*^9, 3.49317150626945*^9}, {3.4932434733805265`*^9, 
   3.4932434776305323`*^9}, 3.4932442598016276`*^9, 3.4932444119118404`*^9, {
   3.4940040426067543`*^9, 3.494004046872998*^9}, {3.494009552628909*^9, 
   3.494009555663083*^9}, {3.4940116323648634`*^9, 3.4940116363310905`*^9}, {
   3.494013128108415*^9, 3.494013131212593*^9}, {3.4940133353222675`*^9, 
   3.494013406482337*^9}, {3.4940145291595507`*^9, 3.4940145297975874`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Inverted iterated integration by parts", "Subsubsection",
 CellChangeTimes->{{3.493099207935931*^9, 3.4930992149659414`*^9}, {
  3.4940052861338797`*^9, 3.4940052928402634`*^9}, {3.494011690737202*^9, 
  3.494011693788377*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.493098879405472*^9, 3.493098884745479*^9}, {3.493099207935931*^9, 
   3.4930992149659414`*^9}, 3.4930996737265835`*^9, 3.493099827186798*^9, {
   3.4932434943005557`*^9, 3.493243522320595*^9}, {3.494005203823172*^9, 
   3.494005223116276*^9}, {3.494005912167687*^9, 3.494005912167687*^9}, {
   3.494005996704522*^9, 3.494006005111003*^9}, {3.4940117189798174`*^9, 
   3.494011721274949*^9}, {3.494011926169668*^9, 3.4940119289428267`*^9}, {
   3.4940120348468843`*^9, 3.494012036980006*^9}, {3.494012573744707*^9, 
   3.4940125763308554`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     SuperscriptBox["x", "3"]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["a", "2"], 
        SuperscriptBox[
         RowBox[{"ArcCoth", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"]}], "2"]}]}]}]}], "-", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"ArcCoth", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"2", 
    SuperscriptBox["x", "2"]}]], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", "n"}], "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", " ", "x"}], "]"}], 
       RowBox[{"n", "-", "1"}]], 
      SuperscriptBox["x", "2"]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493098332554706*^9, 3.4930984922049294`*^9}, {
   3.4930985835950575`*^9, 3.4930986777351894`*^9}, {3.4930988533254347`*^9, 
   3.4930988578754416`*^9}, {3.493099207935931*^9, 3.4930992149659414`*^9}, {
   3.4930993574561405`*^9, 3.493099400886202*^9}, {3.493099526816378*^9, 
   3.49309953534639*^9}, 3.4931705981281786`*^9, {3.493170768098417*^9, 
   3.4931708122284784`*^9}, {3.4940050446890697`*^9, 
   3.4940051357132764`*^9}, {3.494010254898077*^9, 3.4940102990006*^9}, {
   3.494010355515832*^9, 3.4940103650133753`*^9}, 3.4940116760473623`*^9, {
   3.4940120899150343`*^9, 3.494012256009534*^9}, 3.494012321413275*^9, 
   3.494012355001196*^9, {3.494014530083604*^9, 3.494014531108662*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.4940053078671227`*^9, 3.494005310026246*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
     RowBox[{"x_", "^", "3"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
  "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", "^", "2"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", "2"}]}], " ", "-", 
    " ", 
    RowBox[{
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", 
       RowBox[{"x", "^", "2"}]}], ")"}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"n", "/", "2"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "/", 
         RowBox[{"x", "^", "2"}]}], ",", "x"}], "]"}]}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4928302625720215`*^9, 3.4928303000920744`*^9}, {
   3.4928305645624447`*^9, 3.4928305746224585`*^9}, {3.4930994731463027`*^9, 
   3.4930995793864517`*^9}, {3.4931708257484975`*^9, 3.493170933088648*^9}, {
   3.493170964658692*^9, 3.4931709750387063`*^9}, {3.493171201919024*^9, 
   3.493171205079028*^9}, {3.493171366199254*^9, 3.4931713665792546`*^9}, {
   3.4931715056494493`*^9, 3.49317150626945*^9}, {3.4932434733805265`*^9, 
   3.4932434776305323`*^9}, 3.4932442598016276`*^9, 3.4932444119118404`*^9, {
   3.494004039303565*^9, 3.4940040800098934`*^9}, {3.4940049144956236`*^9, 
   3.4940049151486607`*^9}, {3.4940049727389545`*^9, 3.4940049792463264`*^9}, 
   3.4940059089755044`*^9, {3.494006032487569*^9, 3.4940060554328814`*^9}, 
   3.4940094923844633`*^9, {3.4940103280942636`*^9, 3.4940103492304726`*^9}, {
   3.4940104554925504`*^9, 3.4940104824550924`*^9}, {3.4940117336926594`*^9, 
   3.494011876094804*^9}, {3.4940120191709876`*^9, 3.4940120264064016`*^9}, {
   3.494012388532114*^9, 3.4940124429682274`*^9}, {3.4940125561557016`*^9, 
   3.4940125689854355`*^9}, {3.494014531817703*^9, 3.4940145327277546`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Inverted iterated integration by parts", "Subsubsection",
 CellChangeTimes->{{3.493099207935931*^9, 3.4930992149659414`*^9}, {
  3.4940052861338797`*^9, 3.4940052928402634`*^9}, {3.494011690737202*^9, 
  3.494011693788377*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"m", "<", 
    RowBox[{"-", "3"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.493098879405472*^9, 3.493098884745479*^9}, {3.493099207935931*^9, 
   3.4930992149659414`*^9}, 3.4930996737265835`*^9, 3.493099827186798*^9, {
   3.4932434943005557`*^9, 3.493243522320595*^9}, {3.494005203823172*^9, 
   3.494005223116276*^9}, {3.494005912167687*^9, 3.494005912167687*^9}, {
   3.494005996704522*^9, 3.494006005111003*^9}, {3.4940117189798174`*^9, 
   3.494011721274949*^9}, {3.494011926169668*^9, 3.4940119289428267`*^9}, {
   3.4940120348468843`*^9, 3.494012036980006*^9}, {3.494013442081373*^9, 
   3.494013450779871*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"ArcCoth", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
       RowBox[{"m", "+", "1"}]]}]}]}]}], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    SuperscriptBox["x", 
     RowBox[{"m", "+", "3"}]], " ", 
    SuperscriptBox[
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
   RowBox[{"m", "+", "1"}]], "-", 
  "                                                ", "\[IndentingNewLine]", 
  "                                                ", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", "n"}], 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["a", "2"], 
     RowBox[{"(", 
      RowBox[{"m", "+", "3"}], ")"}]}], 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493098332554706*^9, 3.4930984922049294`*^9}, {
   3.4930985835950575`*^9, 3.4930986777351894`*^9}, {3.4930988533254347`*^9, 
   3.4930988578754416`*^9}, {3.493099207935931*^9, 3.4930992149659414`*^9}, {
   3.4930993574561405`*^9, 3.493099400886202*^9}, {3.493099526816378*^9, 
   3.49309953534639*^9}, 3.4931705981281786`*^9, {3.493170768098417*^9, 
   3.4931708122284784`*^9}, {3.4940050446890697`*^9, 
   3.4940051357132764`*^9}, {3.494010254898077*^9, 3.4940102990006*^9}, {
   3.494010355515832*^9, 3.4940103650133753`*^9}, 3.4940116760473623`*^9, {
   3.494014533400793*^9, 3.494014534479855*^9}, {3.4940159815466223`*^9, 
   3.4940159853218384`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.4940053078671227`*^9, 3.494005310026246*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "-", " ", 
    RowBox[{
     RowBox[{"a", "^", "2"}], "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "3"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"n", "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "3"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "3"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.4928302625720215`*^9, 3.4928303000920744`*^9}, {
   3.4928305645624447`*^9, 3.4928305746224585`*^9}, {3.4930994731463027`*^9, 
   3.4930995793864517`*^9}, {3.4931708257484975`*^9, 3.493170933088648*^9}, {
   3.493170964658692*^9, 3.4931709750387063`*^9}, {3.493171201919024*^9, 
   3.493171205079028*^9}, {3.493171366199254*^9, 3.4931713665792546`*^9}, {
   3.4931715056494493`*^9, 3.49317150626945*^9}, {3.4932434733805265`*^9, 
   3.4932434776305323`*^9}, 3.4932442598016276`*^9, 3.4932444119118404`*^9, {
   3.494004039303565*^9, 3.4940040800098934`*^9}, {3.4940049144956236`*^9, 
   3.4940049151486607`*^9}, {3.4940049727389545`*^9, 3.4940049792463264`*^9}, 
   3.4940059089755044`*^9, {3.494006032487569*^9, 3.4940060554328814`*^9}, 
   3.4940094923844633`*^9, {3.4940103280942636`*^9, 3.4940103492304726`*^9}, {
   3.4940104554925504`*^9, 3.4940104824550924`*^9}, {3.4940117336926594`*^9, 
   3.494011876094804*^9}, {3.4940120191709876`*^9, 3.4940120264064016`*^9}, {
   3.4940134559001637`*^9, 3.4940134576452637`*^9}, {3.4940145350658884`*^9, 
   3.494014538013057*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", "x"}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.492802747642827*^9, 
   3.492802751137233*^9}, 3.4928222777249804`*^9, 3.492825819138003*^9, {
   3.492830644352556*^9, 3.492830644712557*^9}, {3.4928404670121565`*^9, 
   3.492840467502157*^9}, 3.492913326383937*^9, {3.4931451285332985`*^9, 
   3.4931451299433002`*^9}, 3.4937667170458336`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{3.4931456018039613`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    SuperscriptBox["c", "2"]}], "=", 
   RowBox[{
    SuperscriptBox["d", "2"], " ", "\[And]", " ", 
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.492907662576008*^9, 3.4929076635660095`*^9}, {3.4930735907627287`*^9, 
   3.4930736091827545`*^9}, {3.4931451699433565`*^9, 3.493145207453409*^9}, {
   3.4931452956835327`*^9, 3.4931453218235693`*^9}, {3.4931453713536386`*^9, 
   3.4931453747436433`*^9}, 3.4931456018039613`*^9, {3.493146996085913*^9, 
   3.4931470125759363`*^9}, {3.493581126911767*^9, 3.493581143581791*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
         RowBox[{"Log", "[", 
          FractionBox[
           RowBox[{"2", " ", "c"}], 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}]], "]"}]}], "d"]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", "n"}], "d"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"ArcCoth", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "-", "1"}]], " ", 
       RowBox[{"Log", "[", 
        FractionBox[
         RowBox[{"2", " ", "c"}], 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}]], "]"}]}], 
      RowBox[{"1", "-", 
       RowBox[{
        SuperscriptBox["a", "2"], 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4927459475946445`*^9, 3.49274596552767*^9}, {
   3.4927470791633663`*^9, 3.492747100502587*^9}, {3.492838456185856*^9, 
   3.492838468151077*^9}, {3.4928389429535108`*^9, 3.492838996648805*^9}, {
   3.492839156730687*^9, 3.4928391643123*^9}, 3.4928403497119923`*^9, {
   3.492908275826866*^9, 3.4929083226469316`*^9}, 3.492910391739828*^9, {
   3.4931446954326925`*^9, 3.493144762932787*^9}, 3.4931448959029727`*^9, {
   3.493144975223084*^9, 3.4931449799230905`*^9}, {3.4931453401435947`*^9, 
   3.4931453627536263`*^9}, 3.4931456018039613`*^9, {3.4931469777458878`*^9, 
   3.4931469799558907`*^9}, {3.4937667170558333`*^9, 3.493766717065833*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
     RowBox[{"(", 
      RowBox[{"c_", "+", 
       RowBox[{"d_.", "*", "x_"}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"2", "*", 
        RowBox[{"c", "/", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], ")"}]}]}], "]"}], "/", "d"}]}], " ", 
    "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"n", "/", "d"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"2", "*", 
            RowBox[{"c", "/", 
             RowBox[{"(", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], ")"}]}]}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{
             RowBox[{"a", "^", "2"}], "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", 
       RowBox[{"c", "^", "2"}]}], "-", 
      RowBox[{"d", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.4928379334601374`*^9, 
   3.492837939216548*^9}, {3.4928380301959076`*^9, 3.4928380706935787`*^9}, {
   3.4928381256836753`*^9, 3.492838126026876*^9}, {3.492838194448596*^9, 
   3.492838214806632*^9}, {3.4928386496573954`*^9, 3.4928386538382025`*^9}, {
   3.4928387393419533`*^9, 3.4928388738453894`*^9}, {3.4928392099891806`*^9, 
   3.4928392282724123`*^9}, {3.4928392656204743`*^9, 3.492839265890475*^9}, {
   3.4928393374405746`*^9, 3.492839337970576*^9}, 3.4928413413933806`*^9, {
   3.4930740306333447`*^9, 3.4930740321133466`*^9}, {3.493144462352366*^9, 
   3.493144468172374*^9}, {3.493144540822476*^9, 3.4931445433324795`*^9}, {
   3.4931445892825437`*^9, 3.4931445898425446`*^9}, {3.493145449723748*^9, 
   3.493145475833785*^9}, {3.49358106455168*^9, 3.493581066611683*^9}, {
   3.493748575803213*^9, 3.4937486011688576`*^9}, {3.493766717065833*^9, 
   3.4937667170758333`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", "x"}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.492802747642827*^9, 
   3.492802751137233*^9}, 3.4928222777249804`*^9, 3.492825819138003*^9, {
   3.492830644352556*^9, 3.492830644712557*^9}, {3.4928404670121565`*^9, 
   3.492840467502157*^9}, 3.492913326383937*^9, {3.4929975742692375`*^9, 
   3.492997579510846*^9}, {3.4931465961853533`*^9, 3.493146597295355*^9}, 
   3.4937667170758333`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{3.4931456018039613`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    SuperscriptBox["c", "2"]}], "=", 
   RowBox[{
    SuperscriptBox["d", "2"], " ", "\[And]", " ", 
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.492907662576008*^9, 3.4929076635660095`*^9}, {3.4930735907627287`*^9, 
   3.4930736091827545`*^9}, {3.4931451699433565`*^9, 3.493145207453409*^9}, {
   3.4931452956835327`*^9, 3.4931453218235693`*^9}, {3.4931453713536386`*^9, 
   3.4931453747436433`*^9}, 3.4931456018039613`*^9, {3.493146996085913*^9, 
   3.4931470125759363`*^9}, {3.4935811541318054`*^9, 
   3.4935811541318054`*^9}, {3.493581238921924*^9, 3.493581239361925*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"x", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"ArcCoth", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
        RowBox[{"Log", "[", 
         RowBox[{"2", "-", 
          FractionBox[
           RowBox[{"2", " ", "c"}], 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}]]}], "]"}]}], "c"]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", "n"}], "c"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"ArcCoth", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "-", "1"}]], " ", 
       RowBox[{"Log", "[", 
        RowBox[{"2", "-", 
         FractionBox[
          RowBox[{"2", " ", "c"}], 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}]]}], "]"}]}], 
      RowBox[{"1", "-", 
       RowBox[{
        SuperscriptBox["a", "2"], 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4927459475946445`*^9, 3.49274596552767*^9}, {
   3.4927470791633663`*^9, 3.492747100502587*^9}, {3.492838456185856*^9, 
   3.492838468151077*^9}, {3.4928389429535108`*^9, 3.492838996648805*^9}, {
   3.492839156730687*^9, 3.4928391643123*^9}, 3.4928403497119923`*^9, {
   3.492908275826866*^9, 3.4929083226469316`*^9}, 3.492910391739828*^9, {
   3.4931446954326925`*^9, 3.493144762932787*^9}, 3.4931448959029727`*^9, {
   3.493144975223084*^9, 3.4931449799230905`*^9}, {3.4931453401435947`*^9, 
   3.4931453627536263`*^9}, 3.4931456018039613`*^9, {3.4931466620154457`*^9, 
   3.493146720405527*^9}, {3.493146762375586*^9, 3.4931467629255867`*^9}, {
   3.4931574816798153`*^9, 3.4931574860698223`*^9}, {3.4937667170858335`*^9, 
   3.493766717095834*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
     RowBox[{"(", 
      RowBox[{"x_", "*", 
       RowBox[{"(", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", "x_"}]}], ")"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"2", "-", 
        RowBox[{"2", "*", 
         RowBox[{"c", "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}]}]}]}], "]"}], "/", "c"}]}], " ", 
    "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"n", "/", "c"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"2", "-", 
            RowBox[{"2", "*", 
             RowBox[{"c", "/", 
              RowBox[{"(", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], ")"}]}]}]}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{
             RowBox[{"a", "^", "2"}], "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", 
       RowBox[{"c", "^", "2"}]}], "-", 
      RowBox[{"d", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.4928379334601374`*^9, 
   3.492837939216548*^9}, {3.4928380301959076`*^9, 3.4928380706935787`*^9}, {
   3.4928381256836753`*^9, 3.492838126026876*^9}, {3.492838194448596*^9, 
   3.492838214806632*^9}, {3.4928386496573954`*^9, 3.4928386538382025`*^9}, {
   3.4928387393419533`*^9, 3.4928388738453894`*^9}, {3.4928392099891806`*^9, 
   3.4928392282724123`*^9}, {3.4928392656204743`*^9, 3.492839265890475*^9}, {
   3.4928393374405746`*^9, 3.492839337970576*^9}, 3.4928413413933806`*^9, {
   3.4930740306333447`*^9, 3.4930740321133466`*^9}, {3.493144462352366*^9, 
   3.493144468172374*^9}, {3.493144540822476*^9, 3.4931445433324795`*^9}, {
   3.4931445892825437`*^9, 3.4931445898425446`*^9}, {3.493145449723748*^9, 
   3.493145475833785*^9}, {3.493146638085412*^9, 3.4931466465254235`*^9}, {
   3.4931467543555746`*^9, 3.4931467820656137`*^9}, {3.493146817405663*^9, 
   3.493146854555715*^9}, {3.493147492576608*^9, 3.493147492956609*^9}, {
   3.4931575219698725`*^9, 3.4931575367198925`*^9}, 3.4931584323211465`*^9, {
   3.4935810314016333`*^9, 3.493581033811637*^9}, {3.4937667171058335`*^9, 
   3.4937667171058335`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{3.4931456018039613`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    SuperscriptBox["c", "2"]}], "=", 
   RowBox[{
    SuperscriptBox["d", "2"], " ", "\[And]", " ", 
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.492907662576008*^9, 3.4929076635660095`*^9}, {3.4930735907627287`*^9, 
   3.4930736091827545`*^9}, {3.4931451699433565`*^9, 3.493145207453409*^9}, {
   3.4931452956835327`*^9, 3.4931453218235693`*^9}, {3.4931453713536386`*^9, 
   3.4931453747436433`*^9}, 3.4931456018039613`*^9, {3.493146996085913*^9, 
   3.4931470125759363`*^9}, {3.493581162211817*^9, 3.493581162211817*^9}, {
   3.493581231631914*^9, 3.4935812320219145`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{
      RowBox[{"c", " ", "x"}], "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"ArcCoth", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
        RowBox[{"Log", "[", 
         RowBox[{"2", "-", 
          FractionBox[
           RowBox[{"2", " ", "c"}], 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}]]}], "]"}]}], "c"]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", "n"}], "c"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"ArcCoth", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "-", "1"}]], " ", 
       RowBox[{"Log", "[", 
        RowBox[{"2", "-", 
         FractionBox[
          RowBox[{"2", " ", "c"}], 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}]]}], "]"}]}], 
      RowBox[{"1", "-", 
       RowBox[{
        SuperscriptBox["a", "2"], 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4927459475946445`*^9, 3.49274596552767*^9}, {
   3.4927470791633663`*^9, 3.492747100502587*^9}, {3.492838456185856*^9, 
   3.492838468151077*^9}, {3.4928389429535108`*^9, 3.492838996648805*^9}, {
   3.492839156730687*^9, 3.4928391643123*^9}, 3.4928403497119923`*^9, {
   3.492908275826866*^9, 3.4929083226469316`*^9}, 3.492910391739828*^9, {
   3.4931446954326925`*^9, 3.493144762932787*^9}, 3.4931448959029727`*^9, {
   3.493144975223084*^9, 3.4931449799230905`*^9}, {3.4931453401435947`*^9, 
   3.4931453627536263`*^9}, 3.4931456018039613`*^9, {3.4931466620154457`*^9, 
   3.493146720405527*^9}, {3.493146762375586*^9, 3.4931467629255867`*^9}, {
   3.4931574816798153`*^9, 3.4931574860698223`*^9}, {3.493158351951034*^9, 
   3.4931583622410483`*^9}, {3.4937667171158333`*^9, 3.4937667171158333`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"c_.", "*", "x_"}], "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"2", "-", 
        RowBox[{"2", "*", 
         RowBox[{"c", "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}]}]}]}], "]"}], "/", "c"}]}], " ", 
    "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"n", "/", "c"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"2", "-", 
            RowBox[{"2", "*", 
             RowBox[{"c", "/", 
              RowBox[{"(", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], ")"}]}]}]}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{
             RowBox[{"a", "^", "2"}], "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", 
       RowBox[{"c", "^", "2"}]}], "-", 
      RowBox[{"d", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.4928379334601374`*^9, 
   3.492837939216548*^9}, {3.4928380301959076`*^9, 3.4928380706935787`*^9}, {
   3.4928381256836753`*^9, 3.492838126026876*^9}, {3.492838194448596*^9, 
   3.492838214806632*^9}, {3.4928386496573954`*^9, 3.4928386538382025`*^9}, {
   3.4928387393419533`*^9, 3.4928388738453894`*^9}, {3.4928392099891806`*^9, 
   3.4928392282724123`*^9}, {3.4928392656204743`*^9, 3.492839265890475*^9}, {
   3.4928393374405746`*^9, 3.492839337970576*^9}, 3.4928413413933806`*^9, {
   3.4930740306333447`*^9, 3.4930740321133466`*^9}, {3.493144462352366*^9, 
   3.493144468172374*^9}, {3.493144540822476*^9, 3.4931445433324795`*^9}, {
   3.4931445892825437`*^9, 3.4931445898425446`*^9}, {3.493145449723748*^9, 
   3.493145475833785*^9}, {3.493146638085412*^9, 3.4931466465254235`*^9}, {
   3.4931467543555746`*^9, 3.4931467820656137`*^9}, {3.493146817405663*^9, 
   3.493146854555715*^9}, {3.493147492576608*^9, 3.493147492956609*^9}, {
   3.4931575219698725`*^9, 3.4931575367198925`*^9}, {3.493158449661171*^9, 
   3.4931584772112093`*^9}, {3.4935810370816417`*^9, 
   3.4935810386816435`*^9}, {3.4937667171258335`*^9, 3.4937667171358337`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["x", 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", "x"}]}]], "\[Equal]", 
   RowBox[{
    FractionBox["1", "d"], "-", 
    FractionBox["c", 
     RowBox[{"d", " ", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664443126074*^9, 3.479664484795992*^9, {3.479686720494632*^9, 
   3.479686740223*^9}, {3.4929978496877213`*^9, 3.4929978567233334`*^9}, {
   3.4929979016982126`*^9, 3.492997933194668*^9}, 3.4929979741135397`*^9, {
   3.4932342226975756`*^9, 3.4932342226975756`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    SuperscriptBox["c", "2"]}], "=", 
   RowBox[{
    SuperscriptBox["d", "2"], " ", "\[And]", " ", 
    RowBox[{"m", ">", "0"}], " ", "\[And]", " ", 
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.492907662576008*^9, 3.4929076635660095`*^9}, {3.4930735907627287`*^9, 
   3.4930736091827545`*^9}, {3.4931451699433565`*^9, 3.493145207453409*^9}, {
   3.4931452956835327`*^9, 3.4931453218235693`*^9}, {3.4931453713536386`*^9, 
   3.4931453747436433`*^9}, 3.4931456018039613`*^9, {3.493146996085913*^9, 
   3.4931470125759363`*^9}, {3.4932344140978436`*^9, 3.493234436457875*^9}, 
   3.4932344713679237`*^9, 3.493234764358334*^9, {3.493581169571827*^9, 
   3.4935812149118905`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "m"], " ", 
      SuperscriptBox[
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "d"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox["x", 
       RowBox[{"m", "-", "1"}]], " ", 
      SuperscriptBox[
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["c", "d"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"m", "-", "1"}]], " ", 
       SuperscriptBox[
        RowBox[{"ArcCoth", "[", 
         RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.4927459475946445`*^9, 3.49274596552767*^9}, {
   3.4927470791633663`*^9, 3.492747100502587*^9}, {3.492838456185856*^9, 
   3.492838468151077*^9}, {3.4928389429535108`*^9, 3.492838996648805*^9}, {
   3.492839156730687*^9, 3.4928391643123*^9}, 3.4928403497119923`*^9, {
   3.492908275826866*^9, 3.4929083226469316`*^9}, 3.492910391739828*^9, {
   3.49299802556243*^9, 3.492998081316928*^9}, {3.4932341813675175`*^9, 
   3.4932341825075192`*^9}, {3.4932342504576144`*^9, 3.493234254887621*^9}, {
   3.4932342987776823`*^9, 3.493234348687752*^9}, {3.4937667171558332`*^9, 
   3.4937667171558332`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", "x_"}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "d"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"c", "/", "d"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{
           RowBox[{"ArcCoth", "[", 
            RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", 
       RowBox[{"c", "^", "2"}]}], "-", 
      RowBox[{"d", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.4928379334601374`*^9, 
   3.492837939216548*^9}, {3.4928380301959076`*^9, 3.4928380706935787`*^9}, {
   3.4928381256836753`*^9, 3.492838126026876*^9}, {3.492838194448596*^9, 
   3.492838214806632*^9}, {3.4928386496573954`*^9, 3.4928386538382025`*^9}, {
   3.4928387393419533`*^9, 3.4928388738453894`*^9}, {3.4928392099891806`*^9, 
   3.4928392282724123`*^9}, {3.4928392656204743`*^9, 3.492839265890475*^9}, {
   3.4928393374405746`*^9, 3.492839337970576*^9}, 3.4928413413933806`*^9, {
   3.4929976285885324`*^9, 3.492997657401783*^9}, {3.4929982343063965`*^9, 
   3.492998284850485*^9}, {3.4929983307925663`*^9, 3.4929983346145725`*^9}, {
   3.4929983685134325`*^9, 3.492998380915454*^9}, {3.4929985595281687`*^9, 
   3.492998559886969*^9}, {3.4929986169674697`*^9, 3.4929986552187366`*^9}, {
   3.493145648214026*^9, 3.493145651704031*^9}, {3.493174757504002*^9, 
   3.4931747608840065`*^9}, {3.4932344939779553`*^9, 3.493234517877989*^9}, {
   3.4932345822880793`*^9, 3.4932345974581003`*^9}, {3.493234635668154*^9, 
   3.4932346995382433`*^9}, {3.4935810433816504`*^9, 3.493581045391653*^9}, {
   3.4937667171658335`*^9, 3.4937667171658335`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", "x"}]}]], "\[Equal]", 
   RowBox[{
    FractionBox["1", "c"], "-", 
    FractionBox[
     RowBox[{"d", " ", "x"}], 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664443126074*^9, 3.479664484795992*^9, {3.479686720494632*^9, 
   3.479686740223*^9}, {3.4929978496877213`*^9, 3.4929978567233334`*^9}, {
   3.4929979016982126`*^9, 3.492997933194668*^9}, 3.4929979741135397`*^9, {
   3.4932342226975756`*^9, 3.4932342226975756`*^9}, {3.4932349492985926`*^9, 
   3.493234969438621*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    SuperscriptBox["c", "2"]}], "=", 
   RowBox[{
    SuperscriptBox["d", "2"], " ", "\[And]", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.492907662576008*^9, 3.4929076635660095`*^9}, {3.4930735907627287`*^9, 
   3.4930736091827545`*^9}, {3.4931451699433565`*^9, 3.493145207453409*^9}, {
   3.4931452956835327`*^9, 3.4931453218235693`*^9}, {3.4931453713536386`*^9, 
   3.4931453747436433`*^9}, 3.4931456018039613`*^9, {3.493146996085913*^9, 
   3.4931470125759363`*^9}, {3.4932344140978436`*^9, 3.493234436457875*^9}, 
   3.4932344713679237`*^9, 3.493234764358334*^9, {3.493234813308402*^9, 
   3.4932348147484045`*^9}, {3.4932350526787376`*^9, 3.493235052938738*^9}, {
   3.493581174131833*^9, 3.493581183231846*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "m"], " ", 
      SuperscriptBox[
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "c"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox["x", "m"], " ", 
      SuperscriptBox[
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["d", "c"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"m", "+", "1"}]], " ", 
       SuperscriptBox[
        RowBox[{"ArcCoth", "[", 
         RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.4927459475946445`*^9, 3.49274596552767*^9}, {
   3.4927470791633663`*^9, 3.492747100502587*^9}, {3.492838456185856*^9, 
   3.492838468151077*^9}, {3.4928389429535108`*^9, 3.492838996648805*^9}, {
   3.492839156730687*^9, 3.4928391643123*^9}, 3.4928403497119923`*^9, {
   3.492908275826866*^9, 3.4929083226469316`*^9}, 3.492910391739828*^9, {
   3.49299802556243*^9, 3.492998081316928*^9}, {3.4932341813675175`*^9, 
   3.4932341825075192`*^9}, {3.4932342504576144`*^9, 3.493234254887621*^9}, {
   3.4932342987776823`*^9, 3.493234348687752*^9}, {3.4932348327784295`*^9, 
   3.4932348796784954`*^9}, 3.4932349106485386`*^9, {3.493766717185834*^9, 
   3.493766717185834*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", "x_"}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "c"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"d", "/", "c"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{
           RowBox[{"ArcCoth", "[", 
            RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", 
       RowBox[{"c", "^", "2"}]}], "-", 
      RowBox[{"d", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.4928379334601374`*^9, 
   3.492837939216548*^9}, {3.4928380301959076`*^9, 3.4928380706935787`*^9}, {
   3.4928381256836753`*^9, 3.492838126026876*^9}, {3.492838194448596*^9, 
   3.492838214806632*^9}, {3.4928386496573954`*^9, 3.4928386538382025`*^9}, {
   3.4928387393419533`*^9, 3.4928388738453894`*^9}, {3.4928392099891806`*^9, 
   3.4928392282724123`*^9}, {3.4928392656204743`*^9, 3.492839265890475*^9}, {
   3.4928393374405746`*^9, 3.492839337970576*^9}, 3.4928413413933806`*^9, {
   3.4929976285885324`*^9, 3.492997657401783*^9}, {3.4929982343063965`*^9, 
   3.492998284850485*^9}, {3.4929983307925663`*^9, 3.4929983346145725`*^9}, {
   3.4929983685134325`*^9, 3.492998380915454*^9}, {3.4929985595281687`*^9, 
   3.492998559886969*^9}, {3.4929986169674697`*^9, 3.4929986552187366`*^9}, {
   3.493145648214026*^9, 3.493145651704031*^9}, {3.493174757504002*^9, 
   3.4931747608840065`*^9}, {3.4932344939779553`*^9, 3.493234517877989*^9}, {
   3.4932345822880793`*^9, 3.4932345974581003`*^9}, {3.493234635668154*^9, 
   3.4932346995382433`*^9}, {3.4932349951286573`*^9, 3.493235049278733*^9}, {
   3.4935810501216593`*^9, 3.4935810521316624`*^9}, {3.4937667171958337`*^9, 
   3.4937667171958337`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.479616001935333*^9, 3.4796867203444157`*^9, {3.479687071148848*^9, 
   3.479687071399208*^9}, 3.4928222618129525`*^9, 3.4928258304168224`*^9, {
   3.4929226804037867`*^9, 3.4929226942254105`*^9}, {3.492979990624321*^9, 
   3.4929799910143223`*^9}, {3.493060035696517*^9, 3.4930600483865347`*^9}, 
   3.493253406025427*^9, 3.493274216811039*^9, 3.4937667172058334`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Reciprocal rule for integration", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.49652737814176*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.492907662576008*^9, 3.4929076635660095`*^9}, {3.4930735907627287`*^9, 
   3.4930736091827545`*^9}, {3.4931451699433565`*^9, 3.493145207453409*^9}, {
   3.4931452956835327`*^9, 3.4931453218235693`*^9}, {3.4931453713536386`*^9, 
   3.4931453747436433`*^9}, 3.4931456018039613`*^9, {3.493146996085913*^9, 
   3.4931470125759363`*^9}, {3.493251623431094*^9, 3.493251640965525*^9}, {
   3.4932516789671917`*^9, 3.4932517129752517`*^9}, {3.4932533772433767`*^9, 
   3.4932533782729783`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], 
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"Log", "[", 
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "]"}], 
      RowBox[{"a", " ", "c"}]]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.4927459475946445`*^9, 3.49274596552767*^9}, {
   3.4927470791633663`*^9, 3.492747100502587*^9}, {3.492838456185856*^9, 
   3.492838468151077*^9}, {3.4928389429535108`*^9, 3.492838996648805*^9}, {
   3.492839156730687*^9, 3.4928391643123*^9}, 3.4928403497119923`*^9, {
   3.492908275826866*^9, 3.4929083226469316`*^9}, 3.492910391739828*^9, {
   3.49299802556243*^9, 3.492998081316928*^9}, {3.4932341813675175`*^9, 
   3.4932341825075192`*^9}, {3.4932342504576144`*^9, 3.493234254887621*^9}, {
   3.4932342987776823`*^9, 3.493234348687752*^9}, {3.4932348327784295`*^9, 
   3.4932348796784954`*^9}, 3.4932349106485386`*^9, 3.4933189471337347`*^9, {
   3.4937667172058334`*^9, 3.4937667172158337`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], ")"}], "*", 
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", "*", "x"}], "]"}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"a", "*", "c"}], ")"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.492924584761531*^9, 
   3.4929246531208515`*^9}, {3.4929246982205305`*^9, 3.4929247046789417`*^9}, 
   3.492924739529403*^9, {3.492985420001458*^9, 3.492985475178755*^9}, {
   3.493059939356382*^9, 3.493059968846423*^9}, {3.4930601293866477`*^9, 
   3.493060137446659*^9}, 3.4930603905470133`*^9, {3.4930623946218204`*^9, 
   3.49306243701188*^9}, {3.4937667172158337`*^9, 3.493766717225834*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Power rule for integration", "Subsubsection",
 CellChangeTimes->{3.4937489112350025`*^9}],

Cell[TextData[{
 "Rule:",
 " If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, 3.4929244021788106`*^9, {
   3.493060093566598*^9, 3.4930601027066107`*^9}, {3.4932563547390933`*^9, 
   3.493256358729099*^9}, {3.4932563891491413`*^9, 3.4932563891491413`*^9}, {
   3.493581280781983*^9, 3.4935812915719976`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", " ", "x"}], "]"}], 
       RowBox[{"n", "+", "1"}]], 
      RowBox[{"a", " ", "c", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.4927459475946445`*^9, 3.49274596552767*^9}, {
   3.4927470791633663`*^9, 3.492747100502587*^9}, {3.492838456185856*^9, 
   3.492838468151077*^9}, {3.4928389429535108`*^9, 3.492838996648805*^9}, {
   3.492839156730687*^9, 3.4928391643123*^9}, 3.4928403497119923`*^9, {
   3.492908275826866*^9, 3.4929083226469316`*^9}, 3.492910391739828*^9, {
   3.49299802556243*^9, 3.492998081316928*^9}, {3.4932341813675175`*^9, 
   3.4932341825075192`*^9}, {3.4932342504576144`*^9, 3.493234254887621*^9}, {
   3.4932342987776823`*^9, 3.493234348687752*^9}, {3.4932348327784295`*^9, 
   3.4932348796784954`*^9}, 3.4932349106485386`*^9, {3.4933189471337347`*^9, 
   3.4933189614337544`*^9}, {3.4937667172358336`*^9, 3.4937667172358336`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
     RowBox[{"(", 
      RowBox[{"c_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", "*", "x"}], "]"}], "^", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}]}], "/", 
    RowBox[{"(", 
     RowBox[{"a", "*", "c", "*", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"n", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.492924584761531*^9, 
   3.4929246531208515`*^9}, {3.4929246982205305`*^9, 3.4929247046789417`*^9}, 
   3.492924739529403*^9, {3.492985420001458*^9, 3.492985475178755*^9}, {
   3.493059939356382*^9, 3.493059968846423*^9}, {3.4930601293866477`*^9, 
   3.493060137446659*^9}, 3.4930603905470133`*^9, {3.4935810024215927`*^9, 
   3.4935810041415954`*^9}, {3.4937667172458334`*^9, 3.4937667172458334`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.492802747642827*^9, 
   3.492802751137233*^9}, 3.4928222777249804`*^9, 3.492825819138003*^9, {
   3.492830644352556*^9, 3.492830644712557*^9}, {3.4928404670121565`*^9, 
   3.492840467502157*^9}, 3.4929133195939274`*^9, 3.4931664671723957`*^9, 
   3.493251887352358*^9, 3.4937667172458334`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["x", 
    RowBox[{"1", "-", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["x", "2"]}]}]], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", 
      RowBox[{"a", " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["x", "2"]}]}], ")"}]}]]}], "+", 
    FractionBox["1", 
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"a", " ", "x"}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664431619528*^9, 3.4796644842351856`*^9, {3.4796867203243876`*^9, 
   3.4796867203243876`*^9}, {3.479686900964134*^9, 3.479686904699506*^9}, 
   3.49290371904314*^9, {3.493839415433744*^9, 3.493839415433744*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"n", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.492907662576008*^9, 3.4929076635660095`*^9}, {3.4930735907627287`*^9, 
   3.4930736091827545`*^9}, {3.4931451699433565`*^9, 3.493145207453409*^9}, {
   3.4931452956835327`*^9, 3.4931453218235693`*^9}, {3.4931453713536386`*^9, 
   3.4931453747436433`*^9}, 3.4931456018039613`*^9, {3.493146996085913*^9, 
   3.4931470125759363`*^9}, {3.493251623431094*^9, 3.493251640965525*^9}, {
   3.4932516789671917`*^9, 3.4932517129752517`*^9}, {3.4935813034320145`*^9, 
   3.4935813034320145`*^9}, {3.493581363142098*^9, 3.493581363142098*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"x", " ", 
      SuperscriptBox[
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"ArcCoth", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "+", "1"}]], 
       RowBox[{"d", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", " ", "c"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], 
      RowBox[{"1", "-", 
       RowBox[{"a", " ", "x"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.4927426625007477`*^9, 3.492742662695759*^9}, {
   3.4927427022060184`*^9, 3.4927427689718375`*^9}, {3.49274284243804*^9, 
   3.492742899943329*^9}, {3.4927429432068033`*^9, 3.49274296955731*^9}, 
   3.4927430042452946`*^9, {3.4927431140225735`*^9, 3.4927431953072224`*^9}, {
   3.492743302802371*^9, 3.492743321909464*^9}, {3.49274365403046*^9, 
   3.492743699403055*^9}, {3.4927438451893935`*^9, 3.4927438547469406`*^9}, {
   3.492743907312947*^9, 3.4927439763068933`*^9}, {3.4927441805245733`*^9, 
   3.4927442303734245`*^9}, {3.492744267490548*^9, 3.4927442920949554`*^9}, {
   3.492744353045441*^9, 3.492744384969267*^9}, {3.492744450696027*^9, 
   3.4927444509000387`*^9}, {3.492744509440387*^9, 3.4927445278794413`*^9}, {
   3.4927446880156*^9, 3.492744707778731*^9}, {3.492745634407731*^9, 
   3.492745768275388*^9}, 3.492746696296468*^9, {3.4927468384145966`*^9, 
   3.492746872356538*^9}, {3.492839388040646*^9, 3.4928394598207464`*^9}, 
   3.4928397046810894`*^9, {3.492908081426594*^9, 3.4929081433866806`*^9}, 
   3.492910389019825*^9, {3.493251753613323*^9, 3.493251782301773*^9}, {
   3.4932518158262324`*^9, 3.493251846137086*^9}, {3.493412510259725*^9, 
   3.4934125193197374`*^9}, {3.493766717265834*^9, 3.493766717265834*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", "c"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"a", "*", "x"}]}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.4928379334601374`*^9, 
   3.492837939216548*^9}, {3.4928380301959076`*^9, 3.4928380706935787`*^9}, {
   3.4928381256836753`*^9, 3.492838126026876*^9}, {3.492838194448596*^9, 
   3.492838214806632*^9}, {3.4928394899907885`*^9, 3.492839600870944*^9}, {
   3.492839660371027*^9, 3.492839670511041*^9}, {3.492839872431324*^9, 
   3.492839876241329*^9}, 3.4928399970514984`*^9, 3.49284133392337*^9, {
   3.492841789364008*^9, 3.492841792164012*^9}, {3.4934125901798368`*^9, 
   3.4934125945498433`*^9}, {3.493580989441575*^9, 3.493580991871578*^9}, {
   3.4937667172758336`*^9, 3.4937667172758336`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"x", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["x", "2"]}]}], ")"}]}]], "=", 
   RowBox[{
    FractionBox["a", 
     RowBox[{"1", "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["x", "2"]}]}]], "+", 
    FractionBox["1", 
     RowBox[{"x", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"a", " ", "x"}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664431619528*^9, 3.4796644842351856`*^9, {3.4796867203243876`*^9, 
   3.4796867203243876`*^9}, {3.479686900964134*^9, 3.479686904699506*^9}, 
   3.49290371904314*^9, {3.49316782040429*^9, 3.4931678273342996`*^9}, {
   3.4931678584343433`*^9, 3.4931678962243958`*^9}, {3.4931679645244913`*^9, 
   3.493167967024495*^9}, {3.4931679986345396`*^9, 3.4931680026345453`*^9}, {
   3.493839420176152*^9, 3.493839420176152*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"n", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.492907662576008*^9, 3.4929076635660095`*^9}, {3.4930735907627287`*^9, 
   3.4930736091827545`*^9}, {3.4931451699433565`*^9, 3.493145207453409*^9}, {
   3.4931452956835327`*^9, 3.4931453218235693`*^9}, {3.4931453713536386`*^9, 
   3.4931453747436433`*^9}, 3.4931456018039613`*^9, {3.493146996085913*^9, 
   3.4931470125759363`*^9}, {3.4931675717539415`*^9, 3.493167580513954*^9}, {
   3.493251958004882*^9, 3.493251958004882*^9}, {3.493581307982021*^9, 
   3.493581307982021*^9}, {3.493581358752092*^9, 3.493581358752092*^9}, {
   3.4937489859591336`*^9, 3.493748987300736*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"x", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"ArcCoth", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "+", "1"}]], 
       RowBox[{"c", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", "c"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], 
      RowBox[{"x", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"a", " ", "x"}]}], ")"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.4927426625007477`*^9, 3.492742662695759*^9}, {
   3.4927427022060184`*^9, 3.4927427689718375`*^9}, {3.49274284243804*^9, 
   3.492742899943329*^9}, {3.4927429432068033`*^9, 3.49274296955731*^9}, 
   3.4927430042452946`*^9, {3.4927431140225735`*^9, 3.4927431953072224`*^9}, {
   3.492743302802371*^9, 3.492743321909464*^9}, {3.49274365403046*^9, 
   3.492743699403055*^9}, {3.4927438451893935`*^9, 3.4927438547469406`*^9}, {
   3.492743907312947*^9, 3.4927439763068933`*^9}, {3.4927441805245733`*^9, 
   3.4927442303734245`*^9}, {3.492744267490548*^9, 3.4927442920949554`*^9}, {
   3.492744353045441*^9, 3.492744384969267*^9}, {3.492744450696027*^9, 
   3.4927444509000387`*^9}, {3.492744509440387*^9, 3.4927445278794413`*^9}, {
   3.4927446880156*^9, 3.492744707778731*^9}, {3.492745634407731*^9, 
   3.492745768275388*^9}, 3.492746696296468*^9, {3.4927468384145966`*^9, 
   3.492746872356538*^9}, {3.492839388040646*^9, 3.4928394598207464`*^9}, 
   3.4928397046810894`*^9, {3.492908081426594*^9, 3.4929081433866806`*^9}, 
   3.492910389019825*^9, {3.4931674144637213`*^9, 3.493167425813738*^9}, {
   3.493167688434105*^9, 3.4931676930941114`*^9}, {3.4932519872549334`*^9, 
   3.4932520116689763`*^9}, {3.4937667172958336`*^9, 3.4937667172958336`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
     RowBox[{"(", 
      RowBox[{"x_", "*", 
       RowBox[{"(", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], ")"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"c", "*", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "c"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
         RowBox[{"(", 
          RowBox[{"x", "*", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"a", "*", "x"}]}], ")"}]}], ")"}]}], ",", "x"}], "]"}]}],
      "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.4928379334601374`*^9, 
   3.492837939216548*^9}, {3.4928380301959076`*^9, 3.4928380706935787`*^9}, {
   3.4928381256836753`*^9, 3.492838126026876*^9}, {3.492838194448596*^9, 
   3.492838214806632*^9}, {3.4928394899907885`*^9, 3.492839600870944*^9}, {
   3.492839660371027*^9, 3.492839670511041*^9}, {3.492839872431324*^9, 
   3.492839876241329*^9}, 3.4928399970514984`*^9, 3.49284133392337*^9, {
   3.492841789364008*^9, 3.492841792164012*^9}, {3.4931675895939665`*^9, 
   3.49316759898398*^9}, 3.4931676669740753`*^9, {3.4931677271841593`*^9, 
   3.493167763914211*^9}, {3.493580981641564*^9, 3.493580983581567*^9}, {
   3.493766717305834*^9, 3.493766717305834*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"x", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["x", "2"]}]}], ")"}]}]], "=", 
   RowBox[{
    FractionBox["a", 
     RowBox[{"1", "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["x", "2"]}]}]], "+", 
    FractionBox["1", 
     RowBox[{"x", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"a", " ", "x"}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664431619528*^9, 3.4796644842351856`*^9, {3.4796867203243876`*^9, 
   3.4796867203243876`*^9}, {3.479686900964134*^9, 3.479686904699506*^9}, 
   3.49290371904314*^9, {3.49316782040429*^9, 3.4931678273342996`*^9}, {
   3.4931678584343433`*^9, 3.4931678962243958`*^9}, {3.4931679645244913`*^9, 
   3.493167967024495*^9}, {3.4931679986345396`*^9, 3.4931680026345453`*^9}, {
   3.4938394236705585`*^9, 3.4938394236705585`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"n", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.492907662576008*^9, 3.4929076635660095`*^9}, {3.4930735907627287`*^9, 
   3.4930736091827545`*^9}, {3.4931451699433565`*^9, 3.493145207453409*^9}, {
   3.4931452956835327`*^9, 3.4931453218235693`*^9}, {3.4931453713536386`*^9, 
   3.4931453747436433`*^9}, 3.4931456018039613`*^9, {3.493146996085913*^9, 
   3.4931470125759363`*^9}, {3.4931675717539415`*^9, 3.493167580513954*^9}, {
   3.493251958004882*^9, 3.493251958004882*^9}, {3.493581312932028*^9, 
   3.493581312932028*^9}, {3.4935813544820857`*^9, 3.4935813544820857`*^9}, {
   3.4937490542092533`*^9, 3.4937490549580545`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{
      RowBox[{"c", " ", "x"}], "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "3"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"ArcCoth", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "+", "1"}]], 
       RowBox[{"c", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", "c"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], 
      RowBox[{"x", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"a", " ", "x"}]}], ")"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.4927426625007477`*^9, 3.492742662695759*^9}, {
   3.4927427022060184`*^9, 3.4927427689718375`*^9}, {3.49274284243804*^9, 
   3.492742899943329*^9}, {3.4927429432068033`*^9, 3.49274296955731*^9}, 
   3.4927430042452946`*^9, {3.4927431140225735`*^9, 3.4927431953072224`*^9}, {
   3.492743302802371*^9, 3.492743321909464*^9}, {3.49274365403046*^9, 
   3.492743699403055*^9}, {3.4927438451893935`*^9, 3.4927438547469406`*^9}, {
   3.492743907312947*^9, 3.4927439763068933`*^9}, {3.4927441805245733`*^9, 
   3.4927442303734245`*^9}, {3.492744267490548*^9, 3.4927442920949554`*^9}, {
   3.492744353045441*^9, 3.492744384969267*^9}, {3.492744450696027*^9, 
   3.4927444509000387`*^9}, {3.492744509440387*^9, 3.4927445278794413`*^9}, {
   3.4927446880156*^9, 3.492744707778731*^9}, {3.492745634407731*^9, 
   3.492745768275388*^9}, 3.492746696296468*^9, {3.4927468384145966`*^9, 
   3.492746872356538*^9}, {3.492839388040646*^9, 3.4928394598207464`*^9}, 
   3.4928397046810894`*^9, {3.492908081426594*^9, 3.4929081433866806`*^9}, 
   3.492910389019825*^9, {3.4931674144637213`*^9, 3.493167425813738*^9}, {
   3.493167688434105*^9, 3.4931676930941114`*^9}, {3.4932519872549334`*^9, 
   3.4932520116689763`*^9}, 3.493252152092824*^9, {3.493766717325834*^9, 
   3.493766717325834*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"c_.", "*", "x_"}], "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"x_", "^", "3"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"c", "*", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "c"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
         RowBox[{"(", 
          RowBox[{"x", "*", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"a", "*", "x"}]}], ")"}]}], ")"}]}], ",", "x"}], "]"}]}],
      "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.4928379334601374`*^9, 
   3.492837939216548*^9}, {3.4928380301959076`*^9, 3.4928380706935787`*^9}, {
   3.4928381256836753`*^9, 3.492838126026876*^9}, {3.492838194448596*^9, 
   3.492838214806632*^9}, {3.4928394899907885`*^9, 3.492839600870944*^9}, {
   3.492839660371027*^9, 3.492839670511041*^9}, {3.492839872431324*^9, 
   3.492839876241329*^9}, 3.4928399970514984`*^9, 3.49284133392337*^9, {
   3.492841789364008*^9, 3.492841792164012*^9}, {3.4931675895939665`*^9, 
   3.49316759898398*^9}, 3.4931676669740753`*^9, {3.4931677271841593`*^9, 
   3.493167763914211*^9}, {3.4931684204151297`*^9, 3.4931684392651567`*^9}, {
   3.4935809755915556`*^9, 3.4935809770915575`*^9}, {3.4937667173358335`*^9, 
   3.4937667173358335`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "2"], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], "=", 
   RowBox[{
    FractionBox["1", "d"], "-", 
    FractionBox["c", 
     RowBox[{"d", " ", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664431619528*^9, 3.4796644842351856`*^9, {3.4796867203243876`*^9, 
   3.4796867203243876`*^9}, {3.479686900964134*^9, 3.479686904699506*^9}, 
   3.49290371904314*^9, {3.49316782040429*^9, 3.4931678273342996`*^9}, {
   3.4931678584343433`*^9, 3.4931678962243958`*^9}, {3.4931679645244913`*^9, 
   3.493167967024495*^9}, {3.4931679986345396`*^9, 3.4931680026345453`*^9}, 
   3.493790063331503*^9, 3.4937901678516493`*^9, {3.4937902960118284`*^9, 
   3.4937902973518305`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"m", ">", "1"}], " ", "\[And]", " ", 
    RowBox[{"n", ">", "0", " "}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, 
   3.4929827292027316`*^9, {3.493165973371704*^9, 3.493166003201746*^9}, {
   3.4931661009618826`*^9, 3.493166101641884*^9}, {3.4932522145709333`*^9, 
   3.4932522145709333`*^9}, {3.493581315932032*^9, 3.493581315932032*^9}, {
   3.493581349432079*^9, 3.493581349432079*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "m"], 
      SuperscriptBox[
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "d"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox["x", 
       RowBox[{"m", "-", "2"}]], 
      SuperscriptBox[
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["c", "d"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"m", "-", "2"}]], 
       SuperscriptBox[
        RowBox[{"ArcCoth", "[", 
         RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493166154681958*^9, 3.4931662030820255`*^9}, 
   3.4931666207326107`*^9, {3.4932522463481894`*^9, 3.49325228099585*^9}, {
   3.4933158052693357`*^9, 3.4933158328693743`*^9}, {3.4933190308138514`*^9, 
   3.493319134053996*^9}, {3.4933192438441496`*^9, 3.4933192445541506`*^9}, {
   3.4933193363142796`*^9, 3.4933193414042864`*^9}, {3.493412534339759*^9, 
   3.493412536469762*^9}, {3.493789994101406*^9, 3.493790017041438*^9}, {
   3.4937903432618947`*^9, 3.4937903499119043`*^9}, {3.493791019842842*^9, 
   3.4937910517128863`*^9}, 3.493791106992964*^9, 3.49379132604327*^9, {
   3.4938396435217447`*^9, 3.493839644426546*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "d"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"c", "/", "d"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{
           RowBox[{"ArcCoth", "[", 
            RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929236652023163`*^9, 3.49292366743312*^9}, 
   3.4929802336571484`*^9, {3.492982933672291*^9, 3.4929829505983205`*^9}, {
   3.4929832472016416`*^9, 3.4929833842790823`*^9}, {3.4929834529036026`*^9, 
   3.4929834542764053`*^9}, {3.493166117311906*^9, 3.493166138981936*^9}, {
   3.4931662751621265`*^9, 3.4931663186221876`*^9}, {3.4934126182898765`*^9, 
   3.493412622519882*^9}, {3.4935809700815477`*^9, 3.4935809719615507`*^9}, {
   3.493791136533005*^9, 3.4937911896730795`*^9}, 3.4937912549331713`*^9, {
   3.4938396449881473`*^9, 3.4938396456589484`*^9}, 3.493839782720789*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], "=", 
   RowBox[{
    FractionBox["1", "c"], "-", 
    FractionBox[
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}], 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664431619528*^9, 3.4796644842351856`*^9, {3.4796867203243876`*^9, 
   3.4796867203243876`*^9}, {3.479686900964134*^9, 3.479686904699506*^9}, 
   3.49290371904314*^9, {3.49316782040429*^9, 3.4931678273342996`*^9}, {
   3.4931678584343433`*^9, 3.4931678962243958`*^9}, {3.4931679645244913`*^9, 
   3.493167967024495*^9}, {3.4931679986345396`*^9, 3.4931680026345453`*^9}, 
   3.493790063331503*^9, 3.4937901678516493`*^9, {3.4937902960118284`*^9, 
   3.4937902973518305`*^9}, {3.49386717978283*^9, 3.49386717978283*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"n", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.4929828355013185`*^9, 3.492982837903723*^9}, {
   3.493165951941674*^9, 3.493165958321683*^9}, 3.4931660117517576`*^9, {
   3.493252219687742*^9, 3.493252219687742*^9}, {3.4935813186420355`*^9, 
   3.493581344402072*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "m"], 
      SuperscriptBox[
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "c"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox["x", "m"], 
      SuperscriptBox[
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["d", "c"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"m", "+", "2"}]], 
       SuperscriptBox[
        RowBox[{"ArcCoth", "[", 
         RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493166154681958*^9, 3.4931662030820255`*^9}, 
   3.4931666207326107`*^9, {3.4932522463481894`*^9, 3.49325228099585*^9}, {
   3.4933158052693357`*^9, 3.4933158328693743`*^9}, {3.4933190308138514`*^9, 
   3.493319134053996*^9}, {3.4933192438441496`*^9, 3.4933192445541506`*^9}, {
   3.4933193363142796`*^9, 3.4933193414042864`*^9}, {3.493412534339759*^9, 
   3.493412536469762*^9}, {3.493789994101406*^9, 3.493790017041438*^9}, {
   3.4937903432618947`*^9, 3.4937903499119043`*^9}, {3.493791019842842*^9, 
   3.4937910517128863`*^9}, 3.493791106992964*^9, 3.49379132604327*^9, {
   3.4937915274235525`*^9, 3.493791535933564*^9}, {3.4937916827437696`*^9, 
   3.4937916869037757`*^9}, {3.4938396475465517`*^9, 3.493839648139353*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "c"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"d", "/", "c"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{
           RowBox[{"ArcCoth", "[", 
            RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929236652023163`*^9, 3.49292366743312*^9}, 
   3.4929802336571484`*^9, {3.492982933672291*^9, 3.4929829505983205`*^9}, {
   3.4929832472016416`*^9, 3.4929833842790823`*^9}, {3.4929834529036026`*^9, 
   3.4929834542764053`*^9}, {3.493166117311906*^9, 3.493166138981936*^9}, {
   3.4931662751621265`*^9, 3.4931663186221876`*^9}, {3.4934126182898765`*^9, 
   3.493412622519882*^9}, {3.4935809700815477`*^9, 3.4935809719615507`*^9}, {
   3.493791136533005*^9, 3.4937911896730795`*^9}, 3.4937912549331713`*^9, {
   3.493839648950554*^9, 3.4938396494965553`*^9}, {3.4938396923966303`*^9, 
   3.4938396940502334`*^9}, 3.4938397847331924`*^9, {3.4938400426484456`*^9, 
   3.49384006785809*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection"],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 " or ",
 Cell[BoxData[
  RowBox[{"a", ">", "0"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
    RowBox[{"1", "-", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["x", "2"]}]}]], "=", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"Coth", "[", 
        RowBox[{"ArcCoth", "[", 
         RowBox[{"a", " ", "x"}], "]"}], "]"}], "m"], " ", 
      SuperscriptBox[
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], " "}], 
     SuperscriptBox["a", 
      RowBox[{"m", "+", "1"}]]], 
    RowBox[{
     SubscriptBox["\[PartialD]", "x"], 
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}]}]}]], "Input",
  CellChangeTimes->{{3.4935757447002296`*^9, 3.493575793020297*^9}}]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664448654022*^9, 3.479664485386842*^9, {3.4796905699999485`*^9, 
   3.4796905930330687`*^9}, {3.493066205237155*^9, 3.493066233807195*^9}, {
   3.493067002288271*^9, 3.493067007218278*^9}, {3.4930671665685015`*^9, 
   3.4930671719285088`*^9}, {3.493575564069977*^9, 3.4935756424400864`*^9}, {
   3.4935756959401617`*^9, 3.49357570903018*^9}, {3.4935758049403143`*^9, 
   3.493575809750321*^9}, {3.493575842110366*^9, 3.4935758494003763`*^9}, {
   3.4937667174258337`*^9, 3.4937667174258337`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
    RowBox[{"0", " ", "\[And]", " ", "m"}]}], ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "\[Or]", " ", 
      RowBox[{"n", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}], ")"}], " ",
     "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[Or]", 
      " ", 
      RowBox[{"a", ">", "0"}]}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055117607107`*^9, {3.4930655124161854`*^9, 3.4930655280062075`*^9}, {
   3.493066033556915*^9, 3.49306607975698*^9}, {3.4930669874082503`*^9, 
   3.4930669888982525`*^9}, {3.4932562746689816`*^9, 
   3.4932562746689816`*^9}, {3.493256683249553*^9, 3.4932567141395965`*^9}, {
   3.493484196390273*^9, 3.493484198590276*^9}, {3.4934849126412754`*^9, 
   3.493484912921276*^9}, {3.4934858273225565`*^9, 3.4934858277825565`*^9}, {
   3.4934858606226025`*^9, 3.493485878442628*^9}, {3.493485980752771*^9, 
   3.493486013532817*^9}, 3.4934861613430243`*^9, {3.4935745424185467`*^9, 
   3.4935745428285475`*^9}, {3.4935745924186163`*^9, 3.493574622528659*^9}, {
   3.4935750227192187`*^9, 3.4935750542492633`*^9}, {3.493576012220604*^9, 
   3.493576016990611*^9}, {3.4935813225620413`*^9, 3.4935813359920597`*^9}, {
   3.493584208106081*^9, 3.4935842115060854`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      RowBox[{
       SuperscriptBox["a", 
        RowBox[{"m", "+", "1"}]], "c"}]]}]}], " ", 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox["x", "n"], 
       SuperscriptBox[
        RowBox[{"Coth", "[", "x", "]"}], "m"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579733429823`*^9, 3.4796580025249443`*^9}, {
   3.4796580760106115`*^9, 3.479658076961979*^9}, {3.479658170546547*^9, 
   3.47965817467248*^9}, {3.4796583692823153`*^9, 3.4796583839634256`*^9}, {
   3.4796584934408464`*^9, 3.479658497486664*^9}, {3.479661194084181*^9, 
   3.47966122030188*^9}, 3.479661392649704*^9, {3.4796614543984947`*^9, 
   3.4796614565015182`*^9}, {3.4796616029320755`*^9, 3.47966160861024*^9}, 
   3.479661772305622*^9, 3.47966185512471*^9, {3.4796624643307056`*^9, 
   3.4796624837586412`*^9}, {3.4796684805015345`*^9, 3.479668482213997*^9}, {
   3.47968672053469*^9, 3.479686720544704*^9}, {3.4796906638949633`*^9, 
   3.479690664315568*^9}, {3.479690714507741*^9, 3.4796907460130434`*^9}, 
   3.480705514654872*^9, {3.4930650337755156`*^9, 3.493065049545537*^9}, {
   3.4930657623365355`*^9, 3.4930657881965714`*^9}, {3.4930663212373176`*^9, 
   3.493066363577377*^9}, {3.493066963568217*^9, 3.493066975738234*^9}, 
   3.4932537469796257`*^9, 3.493256113988756*^9, {3.4932567461396413`*^9, 
   3.4932567491696453`*^9}, 3.493484110810153*^9, {3.4934842003402786`*^9, 
   3.4934842033302827`*^9}, {3.4934849452513213`*^9, 3.493484979331369*^9}, {
   3.493574446028412*^9, 3.493574506118496*^9}, {3.4935746795187387`*^9, 
   3.493574682028742*^9}, {3.493766717435834*^9, 3.493766717435834*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "^", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], "*", "c"}], ")"}]}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", "n"}], "*", 
          RowBox[{
           RowBox[{"Coth", "[", "x", "]"}], "^", "m"}]}], ",", "x"}], "]"}], 
       ",", "x", ",", 
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", "*", "x"}], "]"}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "||", " ", 
      RowBox[{"Not", "[", 
       RowBox[{"IntegerQ", "[", "n", "]"}], "]"}]}], ")"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "m", "]"}], " ", "||", " ", 
      RowBox[{"PositiveQ", "[", "a", "]"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.493065103075612*^9, 3.493065290765875*^9}, {
   3.493065714046468*^9, 3.493065729586489*^9}, {3.4930658063465967`*^9, 
   3.4930658068865976`*^9}, {3.493067047288334*^9, 3.493067049548337*^9}, {
   3.4930670867783895`*^9, 3.493067112388425*^9}, {3.4930674070088377`*^9, 
   3.4930674148588486`*^9}, {3.4930676846992264`*^9, 
   3.4930676962292423`*^9}, {3.493484206670287*^9, 3.4934842155203*^9}, 
   3.4934861347329865`*^9, {3.49348619445307*^9, 3.493486231663122*^9}, {
   3.4934862761831846`*^9, 3.4934862874732003`*^9}, {3.4935748506089783`*^9, 
   3.4935750140392065`*^9}, {3.4935759916505756`*^9, 3.493575995420581*^9}, 
   3.4935766556615047`*^9, 3.493576706471576*^9, {3.493580958311531*^9, 
   3.493580960351534*^9}, {3.4935842485261374`*^9, 3.4935842501161394`*^9}, {
   3.493766717445834*^9, 3.493766717455834*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
    RowBox[{"1", "-", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["x", "2"]}]}]], "=", 
   RowBox[{
    FractionBox["1", "a"], 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox[
       RowBox[{"Coth", "[", 
        RowBox[{"ArcCoth", "[", 
         RowBox[{"a", " ", "x"}], "]"}], "]"}], "a"], ")"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", "x"], 
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}]}]}]], "Input",
  CellChangeTimes->{{3.4935757447002296`*^9, 3.493575793020297*^9}}]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664448654022*^9, 3.479664485386842*^9, {3.4796905699999485`*^9, 
   3.4796905930330687`*^9}, {3.493066205237155*^9, 3.493066233807195*^9}, {
   3.493067002288271*^9, 3.493067007218278*^9}, {3.4930671665685015`*^9, 
   3.4930671719285088`*^9}, {3.493575564069977*^9, 3.4935756424400864`*^9}, {
   3.4935756959401617`*^9, 3.49357570903018*^9}, {3.4935758049403143`*^9, 
   3.493575809750321*^9}, {3.493575842110366*^9, 3.4935758494003763`*^9}, {
   3.4935761209707565`*^9, 3.493576167880822*^9}, {3.493576511191303*^9, 
   3.493576539971343*^9}, {3.4937667174658337`*^9, 3.4937667174658337`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
    RowBox[{"0", " ", "\[And]", " ", "m"}]}], ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "\[Or]", " ", 
      RowBox[{"n", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}], ")"}], " ",
     "\[And]", " ", 
    RowBox[{"\[Not]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[Or]", 
       " ", 
       RowBox[{"a", ">", "0"}]}], ")"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055117607107`*^9, {3.4930655124161854`*^9, 3.4930655280062075`*^9}, {
   3.493066033556915*^9, 3.49306607975698*^9}, {3.4930669874082503`*^9, 
   3.4930669888982525`*^9}, {3.4932562746689816`*^9, 
   3.4932562746689816`*^9}, {3.493256683249553*^9, 3.4932567141395965`*^9}, {
   3.493484196390273*^9, 3.493484198590276*^9}, {3.4934849126412754`*^9, 
   3.493484912921276*^9}, {3.4934858273225565`*^9, 3.4934858277825565`*^9}, {
   3.4934858606226025`*^9, 3.493485878442628*^9}, {3.493485980752771*^9, 
   3.493486013532817*^9}, 3.4934861613430243`*^9, {3.4935745424185467`*^9, 
   3.4935745428285475`*^9}, {3.4935745924186163`*^9, 3.493574622528659*^9}, {
   3.4935750227192187`*^9, 3.4935750542492633`*^9}, {3.493576012220604*^9, 
   3.493576016990611*^9}, 3.493576288350991*^9, {3.493581325842046*^9, 
   3.4935813317720537`*^9}, {3.4935842190960965`*^9, 3.4935842227961016`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      RowBox[{"a", " ", "c"}]]}]}], " ", 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox["x", "n"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox[
          RowBox[{"Coth", "[", "x", "]"}], "a"], ")"}], "m"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579733429823`*^9, 3.4796580025249443`*^9}, {
   3.4796580760106115`*^9, 3.479658076961979*^9}, {3.479658170546547*^9, 
   3.47965817467248*^9}, {3.4796583692823153`*^9, 3.4796583839634256`*^9}, {
   3.4796584934408464`*^9, 3.479658497486664*^9}, {3.479661194084181*^9, 
   3.47966122030188*^9}, 3.479661392649704*^9, {3.4796614543984947`*^9, 
   3.4796614565015182`*^9}, {3.4796616029320755`*^9, 3.47966160861024*^9}, 
   3.479661772305622*^9, 3.47966185512471*^9, {3.4796624643307056`*^9, 
   3.4796624837586412`*^9}, {3.4796684805015345`*^9, 3.479668482213997*^9}, {
   3.47968672053469*^9, 3.479686720544704*^9}, {3.4796906638949633`*^9, 
   3.479690664315568*^9}, {3.479690714507741*^9, 3.4796907460130434`*^9}, 
   3.480705514654872*^9, {3.4930650337755156`*^9, 3.493065049545537*^9}, {
   3.4930657623365355`*^9, 3.4930657881965714`*^9}, {3.4930663212373176`*^9, 
   3.493066363577377*^9}, {3.493066963568217*^9, 3.493066975738234*^9}, 
   3.4932537469796257`*^9, 3.493256113988756*^9, {3.4932567461396413`*^9, 
   3.4932567491696453`*^9}, 3.493484110810153*^9, {3.4934842003402786`*^9, 
   3.4934842033302827`*^9}, {3.4934849452513213`*^9, 3.493484979331369*^9}, {
   3.493574446028412*^9, 3.493574506118496*^9}, {3.4935746795187387`*^9, 
   3.493574682028742*^9}, {3.4935764123011646`*^9, 3.493576431451191*^9}, {
   3.4935764737712507`*^9, 3.493576478761257*^9}, {3.493766717475834*^9, 
   3.493766717475834*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "c"}], ")"}]}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", "n"}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Coth", "[", "x", "]"}], "/", "a"}], ")"}], "^", "m"}]}],
          ",", "x"}], "]"}], ",", "x", ",", 
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", "*", "x"}], "]"}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "||", " ", 
      RowBox[{"Not", "[", 
       RowBox[{"IntegerQ", "[", "n", "]"}], "]"}]}], ")"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "m", "]"}], " ", "||", " ", 
      RowBox[{"PositiveQ", "[", "a", "]"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.493065103075612*^9, 3.493065290765875*^9}, {
   3.493065714046468*^9, 3.493065729586489*^9}, {3.4930658063465967`*^9, 
   3.4930658068865976`*^9}, {3.493067047288334*^9, 3.493067049548337*^9}, {
   3.4930670867783895`*^9, 3.493067112388425*^9}, {3.4930674070088377`*^9, 
   3.4930674148588486`*^9}, {3.4930676846992264`*^9, 
   3.4930676962292423`*^9}, {3.493484206670287*^9, 3.4934842155203*^9}, 
   3.4934861304629803`*^9, 3.4934861903430643`*^9, {3.4934862534031525`*^9, 
   3.493486262273165*^9}, {3.4934862996232176`*^9, 3.4934863089332304`*^9}, {
   3.493575978670557*^9, 3.4935759803305597`*^9}, {3.4935766168214507`*^9, 
   3.4935766805915403`*^9}, 3.493576722851599*^9, {3.493580952391523*^9, 
   3.493580954621526*^9}, {3.493584242456129*^9, 3.493584244676132*^9}, {
   3.493766717485834*^9, 3.493766717485834*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
     RowBox[{"ArcCoth", "[", "u", "]"}]}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.492802747642827*^9, 
   3.492802751137233*^9}, 3.4928222777249804`*^9, 3.492825819138003*^9, {
   3.492830644352556*^9, 3.492830644712557*^9}, {3.4928404670121565`*^9, 
   3.492840467502157*^9}, {3.492913336613951*^9, 3.492913339753956*^9}, {
   3.4931386203491883`*^9, 3.493138625887198*^9}, {3.4931387252593727`*^9, 
   3.493138727848977*^9}, 3.493143725971335*^9, 3.493252609984828*^9, {
   3.4937667174958344`*^9, 3.4937667174958344`*^9}, {3.493768882668865*^9, 
   3.493768885098869*^9}, 3.4937691132591877`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"ArcCoth", "[", "z", "]"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       FractionBox["1", "z"]}], "]"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", 
       FractionBox["1", "z"]}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664431619528*^9, 3.4796644842351856`*^9, {3.4796867203243876`*^9, 
   3.4796867203243876`*^9}, {3.479686900964134*^9, 3.479686904699506*^9}, {
   3.493766716975833*^9, 3.493766716975833*^9}, {3.493767547466996*^9, 
   3.493767553017004*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["u", "2"], "=", 
      RowBox[{
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox["2", 
            RowBox[{"1", "+", 
             RowBox[{"a", " ", "x"}]}]]}], ")"}], "2"], " ", "\[Or]", "  ", 
        SuperscriptBox["u", "2"]}], "=", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          FractionBox["2", 
           RowBox[{"1", "-", 
            RowBox[{"a", " ", "x"}]}]]}], ")"}], "2"]}]}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4930957381510735`*^9, 3.493095777731129*^9}, {3.4930962548817973`*^9, 
   3.493096255481798*^9}, {3.493139493669922*^9, 3.493139531063188*^9}, {
   3.493252668562931*^9, 3.493252668562931*^9}, {3.4935814042921553`*^9, 
   3.493581413882169*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
      RowBox[{"ArcCoth", "[", "u", "]"}]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "2"]}]}], " ", 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"ArcCoth", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
        RowBox[{"Log", "[", 
         RowBox[{"1", "+", 
          FractionBox["1", "u"]}], "]"}]}], 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"ArcCoth", "[", 
         RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
       RowBox[{"Log", "[", 
        RowBox[{"1", "-", 
         FractionBox["1", "u"]}], "]"}]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.492982817124486*^9, 3.4929828178576875`*^9}, 
   3.4931655191410685`*^9, 3.493166624072615*^9, {3.493252259202612*^9, 
   3.4932522639918203`*^9}, {3.493252361117591*^9, 3.493252364440397*^9}, 
   3.4933156800291605`*^9, {3.493766717525834*^9, 3.493766717525834*^9}, {
   3.493768888878874*^9, 3.4937689420289483`*^9}, {3.4937691141791897`*^9, 
   3.493769115969192*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "*", 
     RowBox[{
      RowBox[{"ArcCoth", "[", "u_", "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "*", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"Regularize", "[", 
            RowBox[{
             RowBox[{"1", "+", 
              RowBox[{"1", "/", "u"}]}], ",", "x"}], "]"}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "*", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"Regularize", "[", 
            RowBox[{
             RowBox[{"1", "-", 
              RowBox[{"1", "/", "u"}]}], ",", "x"}], "]"}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"ZeroQ", "[", 
       RowBox[{
        RowBox[{"u", "^", "2"}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2", "/", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"a", "*", "x"}]}], ")"}]}]}], ")"}], "^", "2"}]}], 
       "]"}], " ", "||", " ", 
      RowBox[{"ZeroQ", "[", 
       RowBox[{
        RowBox[{"u", "^", "2"}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2", "/", 
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{"a", "*", "x"}]}], ")"}]}]}], ")"}], "^", "2"}]}], 
       "]"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.4928379334601374`*^9, 
   3.492837939216548*^9}, {3.4928380301959076`*^9, 3.4928380706935787`*^9}, {
   3.4928381256836753`*^9, 3.492838126026876*^9}, {3.4928381673513484`*^9, 
   3.4928381717973566`*^9}, {3.492838221982644*^9, 3.492838250608695*^9}, {
   3.492840280811896*^9, 3.492840287331905*^9}, 3.4928413614234085`*^9, {
   3.493138538807845*^9, 3.4931385448294554`*^9}, {3.493139257267107*^9, 
   3.4931393087783976`*^9}, 3.4931393776681185`*^9, {3.493139438976226*^9, 
   3.4931394493814445`*^9}, {3.4935814251121845`*^9, 3.493581427492188*^9}, {
   3.4937667175358343`*^9, 3.4937667175358343`*^9}, {3.493768969158986*^9, 
   3.4937689730989923`*^9}, {3.493843498571052*^9, 3.493843527791093*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
     RowBox[{"Log", "[", "u", "]"}]}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.492802747642827*^9, 
   3.492802751137233*^9}, 3.4928222777249804`*^9, 3.492825819138003*^9, {
   3.492830644352556*^9, 3.492830644712557*^9}, {3.4928404670121565`*^9, 
   3.492840467502157*^9}, {3.492913336613951*^9, 3.492913339753956*^9}, 
   3.4931436949112916`*^9, 3.493252774143916*^9, 3.493766717545834*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
   RowBox[{
    RowBox[{"0", " ", "\[And]", " ", 
     RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", "u"}], ")"}], "2"]}], "=", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       FractionBox["2", 
        RowBox[{"1", "+", 
         RowBox[{"a", " ", "x"}]}]]}], ")"}], "2"]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4930957381510735`*^9, 3.493095777731129*^9}, {3.4930962548817973`*^9, 
   3.493096255481798*^9}, {3.4930966874724026`*^9, 3.493096711762437*^9}, {
   3.4930967471324863`*^9, 3.493096747642487*^9}, {3.4932527496362734`*^9, 
   3.4932527496362734`*^9}, {3.493581449742219*^9, 3.493581458802232*^9}, {
   3.493581496762285*^9, 3.4935815094423027`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
      RowBox[{"Log", "[", "u", "]"}]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{" ", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
         RowBox[{"PolyLog", "[", 
          RowBox[{"2", ",", 
           RowBox[{"1", "-", "u"}]}], "]"}]}]}], 
       RowBox[{"2", "a", " ", "c"}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox["n", "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"ArcCoth", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "-", "1"}]], " ", 
       RowBox[{"PolyLog", "[", 
        RowBox[{"2", ",", 
         RowBox[{"1", "-", "u"}]}], "]"}]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 PageWidth->Infinity,
 CellChangeTimes->{{3.492982817124486*^9, 3.4929828178576875`*^9}, 
   3.4931655191410685`*^9, 3.493166624072615*^9, {3.493252259202612*^9, 
   3.4932522639918203`*^9}, {3.493252361117591*^9, 3.493252364440397*^9}, 
   3.4933156800291605`*^9, 3.4933160671297026`*^9, {3.493766717555834*^9, 
   3.493766717555834*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "*", 
     RowBox[{
      RowBox[{"Log", "[", "u_", "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "*", 
     RowBox[{
      RowBox[{"PolyLog", "[", 
       RowBox[{"2", ",", 
        RowBox[{"1", "-", "u"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "a", "*", "c"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"PolyLog", "[", 
           RowBox[{"2", ",", 
            RowBox[{"1", "-", "u"}]}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "u"}], ")"}], "^", "2"}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"2", "/", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"a", "*", "x"}]}], ")"}]}]}], ")"}], "^", "2"}]}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.4928379334601374`*^9, 
   3.492837939216548*^9}, {3.4928380301959076`*^9, 3.4928380706935787`*^9}, {
   3.4928381256836753`*^9, 3.492838126026876*^9}, {3.4928381673513484`*^9, 
   3.4928381717973566`*^9}, {3.492838221982644*^9, 3.492838250608695*^9}, {
   3.492840280811896*^9, 3.492840287331905*^9}, 3.4928413614234085`*^9, {
   3.493138538807845*^9, 3.4931385448294554`*^9}, {3.4935814687422457`*^9, 
   3.4935814707822485`*^9}, {3.493766717565834*^9, 3.4937667175758343`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
   RowBox[{
    RowBox[{"0", " ", "\[And]", " ", 
     RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", "u"}], ")"}], "2"]}], "=", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       FractionBox["2", 
        RowBox[{"1", "-", 
         RowBox[{"a", " ", "x"}]}]]}], ")"}], "2"]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4930957381510735`*^9, 3.493095777731129*^9}, {3.4930962548817973`*^9, 
   3.493096255481798*^9}, {3.4930966874724026`*^9, 3.493096711762437*^9}, {
   3.4932527647214994`*^9, 3.4932527647214994`*^9}, {3.493581521182319*^9, 
   3.493581538282343*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
      RowBox[{"Log", "[", "u", "]"}]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
         RowBox[{"PolyLog", "[", 
          RowBox[{"2", ",", 
           RowBox[{"1", "-", "u"}]}], "]"}]}], 
        RowBox[{"2", "a", " ", "c"}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["n", "2"], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"ArcCoth", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "-", "1"}]], " ", 
       RowBox[{"PolyLog", "[", 
        RowBox[{"2", ",", 
         RowBox[{"1", "-", "u"}]}], "]"}]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 PageWidth->Infinity,
 CellChangeTimes->{{3.492982817124486*^9, 3.4929828178576875`*^9}, 
   3.4931655191410685`*^9, 3.493166624072615*^9, {3.493252259202612*^9, 
   3.4932522639918203`*^9}, {3.493252361117591*^9, 3.493252364440397*^9}, 
   3.4933156800291605`*^9, 3.4933160764997153`*^9, {3.4937667175858345`*^9, 
   3.4937667175858345`*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "*", 
     RowBox[{
      RowBox[{"Log", "[", "u_", "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], "*", 
     RowBox[{
      RowBox[{"PolyLog", "[", 
       RowBox[{"2", ",", 
        RowBox[{"1", "-", "u"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "a", "*", "c"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"PolyLog", "[", 
           RowBox[{"2", ",", 
            RowBox[{"1", "-", "u"}]}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "u"}], ")"}], "^", "2"}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"2", "/", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"a", "*", "x"}]}], ")"}]}]}], ")"}], "^", "2"}]}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.4928379334601374`*^9, 
   3.492837939216548*^9}, {3.4928380301959076`*^9, 3.4928380706935787`*^9}, {
   3.4928381256836753`*^9, 3.492838126026876*^9}, {3.492838194448596*^9, 
   3.492838214806632*^9}, {3.492840292461912*^9, 3.492840299431922*^9}, 
   3.4928413656434145`*^9, {3.4930965007921414`*^9, 3.4930965332721868`*^9}, {
   3.4935814756022553`*^9, 3.4935814775622582`*^9}, {3.4937667175958343`*^9, 
   3.4937667175958343`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
     RowBox[{"PolyLog", "[", 
      RowBox[{"p", ",", "u"}], "]"}]}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.492802747642827*^9, 
   3.492802751137233*^9}, 3.4928222777249804`*^9, 3.492825819138003*^9, {
   3.492830644352556*^9, 3.492830644712557*^9}, {3.4928404670121565`*^9, 
   3.492840467502157*^9}, 3.492913349043969*^9, 3.4931388908692636`*^9, 
   3.493143703721304*^9, 3.4932529661958537`*^9, 3.493766717605834*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
   RowBox[{
    RowBox[{"0", " ", "\[And]", " ", 
     RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
     SuperscriptBox["u", "2"]}], "=", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       FractionBox["2", 
        RowBox[{"1", "+", 
         RowBox[{"a", " ", "x"}]}]]}], ")"}], "2"]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4930957381510735`*^9, 3.493095777731129*^9}, {3.4930962548817973`*^9, 
   3.493096255481798*^9}, {3.4932531421173625`*^9, 3.4932531421173625`*^9}, {
   3.4935817370726213`*^9, 3.493581749462639*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
      RowBox[{"PolyLog", "[", 
       RowBox[{"p", ",", "u"}], "]"}]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                           ", 
      "\[IndentingNewLine]", "                                             ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
         RowBox[{"PolyLog", "[", 
          RowBox[{
           RowBox[{"p", "+", "1"}], ",", "u"}], "]"}]}], 
        RowBox[{"2", "a", " ", "c"}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["n", "2"], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"ArcCoth", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "-", "1"}]], " ", 
       RowBox[{"PolyLog", "[", 
        RowBox[{
         RowBox[{"p", "+", "1"}], ",", "u"}], "]"}]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.492982817124486*^9, 3.4929828178576875`*^9}, 
   3.4931655191410685`*^9, 3.493166624072615*^9, {3.493252259202612*^9, 
   3.4932522639918203`*^9}, {3.493252361117591*^9, 3.493252364440397*^9}, 
   3.4933156800291605`*^9, 3.4933161350697975`*^9, {3.493320303475633*^9, 
   3.493320336085679*^9}, {3.49332038699575*^9, 3.493320391165756*^9}, {
   3.4933205094659214`*^9, 3.4933205100859222`*^9}, {3.493766717615834*^9, 
   3.493766717615834*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "*", 
     RowBox[{
      RowBox[{"PolyLog", "[", 
       RowBox[{"p_", ",", "u_"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], "*", 
     RowBox[{
      RowBox[{"PolyLog", "[", 
       RowBox[{
        RowBox[{"p", "+", "1"}], ",", "u"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "a", "*", "c"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"PolyLog", "[", 
           RowBox[{
            RowBox[{"p", "+", "1"}], ",", "u"}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d", ",", "p"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"u", "^", "2"}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"2", "/", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"a", "*", "x"}]}], ")"}]}]}], ")"}], "^", "2"}]}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997359719353`*^9, 3.492799760261178*^9}, {
   3.4928403040619287`*^9, 3.492840308581935*^9}, 3.492841369963421*^9, {
   3.4928426836352596`*^9, 3.492842700155283*^9}, {3.493096333451907*^9, 
   3.4930963718219604`*^9}, {3.4935817628926573`*^9, 
   3.4935817654026613`*^9}, {3.4937667176258345`*^9, 3.493766717635834*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
   RowBox[{
    RowBox[{"0", " ", "\[And]", " ", 
     RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
     SuperscriptBox["u", "2"]}], "=", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       FractionBox["2", 
        RowBox[{"1", "-", 
         RowBox[{"a", " ", "x"}]}]]}], ")"}], "2"]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4930957381510735`*^9, 3.493095777731129*^9}, {3.4932531464697704`*^9, 
   3.4932531464697704`*^9}, {3.4935817416826277`*^9, 3.493581754482646*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
      RowBox[{"PolyLog", "[", 
       RowBox[{"p", ",", "u"}], "]"}]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                          ", 
      "\[IndentingNewLine]", 
      "                                                ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"ArcCoth", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
        RowBox[{"PolyLog", "[", 
         RowBox[{
          RowBox[{"p", "+", "1"}], ",", "u"}], "]"}]}], 
       RowBox[{"2", "a", " ", "c"}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox["n", "2"], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"ArcCoth", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "-", "1"}]], " ", 
       RowBox[{"PolyLog", "[", 
        RowBox[{
         RowBox[{"p", "+", "1"}], ",", "u"}], "]"}]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.492982817124486*^9, 3.4929828178576875`*^9}, 
   3.4931655191410685`*^9, 3.493166624072615*^9, {3.493252259202612*^9, 
   3.4932522639918203`*^9}, {3.493252361117591*^9, 3.493252364440397*^9}, 
   3.4933156800291605`*^9, 3.4933161430898085`*^9, {3.493320319155655*^9, 
   3.493320327755667*^9}, {3.4933203993557673`*^9, 3.493320454915845*^9}, {
   3.4933205128259263`*^9, 3.493320513405927*^9}, {3.493766717645834*^9, 
   3.493766717645834*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "*", 
     RowBox[{
      RowBox[{"PolyLog", "[", 
       RowBox[{"p_", ",", "u_"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "*", 
     RowBox[{
      RowBox[{"PolyLog", "[", 
       RowBox[{
        RowBox[{"p", "+", "1"}], ",", "u"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "a", "*", "c"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"PolyLog", "[", 
           RowBox[{
            RowBox[{"p", "+", "1"}], ",", "u"}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d", ",", "p"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"u", "^", "2"}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"2", "/", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"a", "*", "x"}]}], ")"}]}]}], ")"}], "^", "2"}]}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQBmIQXfc6RuEx6yvHpZzatiD6UP1iFxC97L6rO4i+oqbm
C6LNYl8FgWix2zHRIJpvRVMSiN7sfCYbRC/YdgdMr7CcHv0HSL+qZ00E0TMU
pqeC6KMLS7NAtIdFbiOIDnFrbgLRtVk87SA659L2ThD9bKfrRBAtVtU1FUT7
LNg+F0R37nw1H0TffGa3EkQzKKisBtGhvlz5AmxAexq2guktPVs/g+gLVrxf
QPQKU/7ZgkD6CM9hMN3w+pRZL5Bm0Cw1B9F8E6s9QbSKfTeY3jPBpbKK/ZWj
gsJ8MD3jz5bjV5BoAKYElAM=
  "],
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "m"], " ", 
     SuperscriptBox[
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.479616025649432*^9, {3.4796162596058445`*^9, 3.479616276069518*^9}, {
   3.4796867203644447`*^9, 3.4796867380098176`*^9}, {3.4796961372252254`*^9, 
   3.4796961375256577`*^9}, 3.492822267896963*^9, 3.4928258267508163`*^9, {
   3.4932577931811075`*^9, 3.4932577998811164`*^9}, 3.493258386041937*^9, 
   3.493258450902028*^9, 3.4937667176658344`*^9, {3.493772471759041*^9, 
   3.4937724723090415`*^9}, {3.4937725618391666`*^9, 3.493772576359187*^9}, {
   3.493772666449313*^9, 3.493772674189324*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
    RowBox[{"0", " ", "\[And]", " ", "m"}]}], ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"0", "<", "n", "<", "m"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.49325840970197*^9, 3.493258411811973*^9}, {
   3.4932584532120314`*^9, 3.4932584537520323`*^9}, {3.4935818687928057`*^9, 
   3.4935818687928057`*^9}, {3.4937727324894056`*^9, 3.493772733719407*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "m"], " ", 
      SuperscriptBox[
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                        ", 
      "\[IndentingNewLine]", 
      "                                               ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"ArcTanh", "[", 
          RowBox[{"a", " ", "x"}], "]"}], 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"ArcCoth", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
       RowBox[{"a", " ", "c", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox["n", 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"ArcTanh", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"m", "+", "1"}]], " ", 
       SuperscriptBox[
        RowBox[{"ArcCoth", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "-", "1"}]]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731727376`*^9, 3.4796580024348145`*^9}, {
   3.4796585662054768`*^9, 3.4796585704015102`*^9}, {3.4796611938738785`*^9, 
   3.479661220251808*^9}, 3.4796613924594307`*^9, {3.479661432957664*^9, 
   3.479661435531365*^9}, {3.4796615599302416`*^9, 3.4796615651577587`*^9}, {
   3.4796617677991424`*^9, 3.4796617978824*^9}, 3.4796618436281796`*^9, {
   3.479662183256541*^9, 3.4796621957945695`*^9}, {3.4796867203944883`*^9, 
   3.4796867402029715`*^9}, {3.4796872323406305`*^9, 3.479687270064875*^9}, {
   3.492826073390849*^9, 3.4928261527013884`*^9}, {3.492826334973708*^9, 
   3.4928263351453085`*^9}, {3.492826679349514*^9, 3.4928266798955145`*^9}, 
   3.4928267967457204`*^9, {3.4932578278611555`*^9, 3.493257905011264*^9}, {
   3.493257942631316*^9, 3.493257944461319*^9}, {3.4932580838015137`*^9, 
   3.4932580841315145`*^9}, {3.4932584146419773`*^9, 
   3.4932584213319864`*^9}, {3.4932584544720325`*^9, 3.493258456582036*^9}, {
   3.493320843336389*^9, 3.4933208585764103`*^9}, {3.4933209087264805`*^9, 
   3.4933209157664905`*^9}, {3.493766717695834*^9, 3.4937667177058344`*^9}, {
   3.4937725963792152`*^9, 3.493772622479252*^9}, {3.493772660549305*^9, 
   3.493772662639308*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "c", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "/", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcTanh", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{
           RowBox[{"ArcCoth", "[", 
            RowBox[{"a", "*", "x"}], "]"}], "^", 
           RowBox[{"(", 
            RowBox[{"n", "-", "1"}], ")"}]}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"0", "<", "n", "<", "m"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4932581278315754`*^9, 3.4932581781516457`*^9}, {
   3.493258211041692*^9, 3.4932582126516943`*^9}, {3.493258319821844*^9, 
   3.4932583217718472`*^9}, {3.493258425361992*^9, 3.4932584627520447`*^9}, 
   3.4935818049827166`*^9, {3.4937667177158346`*^9, 3.4937667177158346`*^9}, {
   3.4937727180293856`*^9, 3.493772718579386*^9}, {3.493773260540145*^9, 
   3.4937732786201706`*^9}, 3.517188622404262*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "m"], " ", 
   SuperscriptBox[
    RowBox[{"ArcCoth", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.479616001935333*^9, 3.4796867203444157`*^9, {3.479687071148848*^9, 
   3.479687071399208*^9}, 3.4928222618129525`*^9, 3.4928258304168224`*^9, {
   3.4929226804037867`*^9, 3.4929226942254105`*^9}, {3.492979990624321*^9, 
   3.4929799910143223`*^9}, {3.493060035696517*^9, 3.4930600483865347`*^9}, 
   3.493253406025427*^9, 3.4937667177158346`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"c", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055117607107`*^9, {3.4930655124161854`*^9, 3.4930655280062075`*^9}, {
   3.493066033556915*^9, 3.49306607975698*^9}, {3.4930680892297926`*^9, 
   3.4930681267098455`*^9}, {3.4930771831577578`*^9, 
   3.4930771985577793`*^9}, {3.493256297489013*^9, 3.493256308149028*^9}, {
   3.4932563410290737`*^9, 3.4932563441690784`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}], 
     SqrtBox[
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", " ", 
         RowBox[{"ArcCoth", "[", 
          RowBox[{"a", " ", "x"}], "]"}], 
         RowBox[{"ArcTan", "[", 
          FractionBox[
           SqrtBox[
            RowBox[{"1", "-", 
             RowBox[{"a", " ", "x"}]}]], 
           SqrtBox[
            RowBox[{"1", "+", 
             RowBox[{"a", " ", "x"}]}]]], "]"}]}], 
        RowBox[{"a", 
         SqrtBox["c"]}]]}]}]}]}]}], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox[
          RowBox[{"1", "-", 
           RowBox[{"a", " ", "x"}]}]]}], 
        SqrtBox[
         RowBox[{"1", "+", 
          RowBox[{"a", " ", "x"}]}]]]}]}], "]"}]}], 
   RowBox[{"a", 
    SqrtBox["c"]}]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox[
         RowBox[{"1", "-", 
          RowBox[{"a", " ", "x"}]}]]}], 
       SqrtBox[
        RowBox[{"1", "+", 
         RowBox[{"a", " ", "x"}]}]]]}], "]"}]}], 
   RowBox[{"a", 
    SqrtBox["c"]}]]}]], "Subsubtitle",
 PageWidth->Infinity,
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.4933211646668386`*^9, {3.493766717735834*^9, 
   3.493766717735834*^9}, {3.494025277100298*^9, 3.4940252814815483`*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a_.", "*", "x_"}], "]"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"c_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "*", 
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", "*", "x"}], "]"}], "*", 
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{"1", "-", 
          RowBox[{"a", "*", "x"}]}], "]"}], "/", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"1", "+", 
          RowBox[{"a", "*", "x"}]}], "]"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", 
        RowBox[{"Sqrt", "[", "c", "]"}]}], ")"}]}]}], " ", "-", " ", 
    "\[IndentingNewLine]", "  ", 
    RowBox[{"I", "*", 
     RowBox[{
      RowBox[{"PolyLog", "[", 
       RowBox[{"2", ",", 
        RowBox[{
         RowBox[{"-", "I"}], "*", 
         RowBox[{
          RowBox[{"Sqrt", "[", 
           RowBox[{"1", "-", 
            RowBox[{"a", "*", "x"}]}], "]"}], "/", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"1", "+", 
            RowBox[{"a", "*", "x"}]}], "]"}]}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", 
        RowBox[{"Sqrt", "[", "c", "]"}]}], ")"}]}]}], " ", "+", " ", 
    "\[IndentingNewLine]", "  ", 
    RowBox[{"I", "*", 
     RowBox[{
      RowBox[{"PolyLog", "[", 
       RowBox[{"2", ",", 
        RowBox[{"I", "*", 
         RowBox[{
          RowBox[{"Sqrt", "[", 
           RowBox[{"1", "-", 
            RowBox[{"a", "*", "x"}]}], "]"}], "/", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"1", "+", 
            RowBox[{"a", "*", "x"}]}], "]"}]}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", 
        RowBox[{"Sqrt", "[", "c", "]"}]}], ")"}]}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", "c", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.492924584761531*^9, 
   3.4929246531208515`*^9}, {3.4929246982205305`*^9, 3.4929247046789417`*^9}, 
   3.492924739529403*^9, {3.493076725417117*^9, 3.493076780277194*^9}, {
   3.4930770153775234`*^9, 3.4930770237775345`*^9}, {3.4930770970076375`*^9, 
   3.4930771129476595`*^9}, {3.4937667177458344`*^9, 
   3.4937667177458344`*^9}, {3.494025286648844*^9, 3.494025292039152*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    FractionBox[
     SqrtBox[
      RowBox[{"1", "-", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["x", "2"]}]}]], 
     SqrtBox[
      RowBox[{"c", " ", "-", 
       RowBox[{"c", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["x", "2"]}]}]]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664448654022*^9, 3.479664485386842*^9, {3.4796905699999485`*^9, 
   3.4796905930330687`*^9}, {3.493066205237155*^9, 3.493066233807195*^9}, {
   3.493067002288271*^9, 3.493067007218278*^9}, {3.4930671665685015`*^9, 
   3.4930671719285088`*^9}, {3.493078825992059*^9, 3.493078849422092*^9}, 
   3.4930790976224394`*^9, {3.4932536079989815`*^9, 3.4932536186070004`*^9}, {
   3.49402584046052*^9, 3.49402584046052*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"\[Not]", 
     RowBox[{"(", 
      RowBox[{"c", ">", "0"}], ")"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055117607107`*^9, {3.4930655124161854`*^9, 3.4930655280062075`*^9}, {
   3.493066033556915*^9, 3.49306607975698*^9}, {3.4930680892297926`*^9, 
   3.4930681267098455`*^9}, {3.4930771831577578`*^9, 
   3.4930771985577793`*^9}, {3.493256297489013*^9, 3.493256308149028*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"ArcCoth", "[", 
     RowBox[{"a", " ", "x"}], "]"}], 
    SqrtBox[
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["x", "2"]}]}]], 
      SqrtBox[
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}]]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["x", "2"]}]}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.4933211695768456`*^9, {3.4937667177558346`*^9, 
   3.4937667177558346`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a_.", "*", "x_"}], "]"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"c_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "-", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "*", 
        RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", 
        RowBox[{"x", "^", "2"}]}]}], "]"}]}], "*", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "/", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"1", "-", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "*", 
          RowBox[{"x", "^", "2"}]}]}], "]"}]}], ",", "x"}], "]"}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"PositiveQ", "[", "c", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.492924584761531*^9, 
   3.4929246531208515`*^9}, {3.4929246982205305`*^9, 3.4929247046789417`*^9}, 
   3.492924739529403*^9, {3.493076725417117*^9, 3.493076780277194*^9}, {
   3.493077825308657*^9, 3.493077828358661*^9}, {3.4930778668687153`*^9, 
   3.493077913738781*^9}, {3.493077978808872*^9, 3.493077978948872*^9}, {
   3.493079137962496*^9, 3.4930791537525177`*^9}, {3.4930802573560643`*^9, 
   3.4930802674060783`*^9}, {3.4937667177658343`*^9, 3.4937667177658343`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055117607107`*^9, {3.4930655124161854`*^9, 3.4930655280062075`*^9}, {
   3.493066033556915*^9, 3.49306607975698*^9}, {3.4930680892297926`*^9, 
   3.4930681267098455`*^9}, {3.4930771831577578`*^9, 
   3.4930771985577793`*^9}, {3.493256297489013*^9, 3.493256308149028*^9}, {
   3.4932565037393017`*^9, 3.4932565054493046`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], 
      RowBox[{"3", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox["1", 
        RowBox[{"a", " ", "c", " ", 
         SqrtBox[
          RowBox[{"c", "+", 
           RowBox[{"d", " ", 
            SuperscriptBox["x", "2"]}]}]]}]]}]}]}]}]}], "+", 
  FractionBox[
   RowBox[{"x", " ", 
    RowBox[{"ArcCoth", "[", 
     RowBox[{"a", " ", "x"}], "]"}]}], 
   RowBox[{"c", 
    SqrtBox[
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]]}]]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.493321175446854*^9, {3.493766717775834*^9, 
   3.4937667177858343`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a_.", "*", "x_"}], "]"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"3", "/", "2"}], ")"}]}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "/", 
     RowBox[{"(", 
      RowBox[{"a", "*", "c", "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", 
          RowBox[{"x", "^", "2"}]}]}], "]"}]}], ")"}]}], " ", "+", "\n", "  ", 
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", 
           RowBox[{"x", "^", "2"}]}]}], "]"}]}], ")"}]}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.492924584761531*^9, 
   3.4929246531208515`*^9}, {3.4929246982205305`*^9, 3.4929247046789417`*^9}, 
   3.492924739529403*^9, {3.4937667177858343`*^9, 3.4937667177958345`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"n", ">", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.493057857853468*^9, 3.4930578807234993`*^9}, {3.4930589528050003`*^9, 
   3.4930589841650443`*^9}, {3.493256250928948*^9, 3.493256250928948*^9}, {
   3.493493532773344*^9, 3.493493535913348*^9}, {3.493494121514168*^9, 
   3.493494130844181*^9}, {3.4935821227231617`*^9, 3.4935821407331867`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], 
      RowBox[{"3", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"n", " ", 
         SuperscriptBox[
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", " ", "x"}], "]"}], 
          RowBox[{"n", "-", "1"}]]}], 
        RowBox[{"a", " ", "c", 
         SqrtBox[
          RowBox[{"c", "+", 
           RowBox[{"d", " ", 
            SuperscriptBox["x", "2"]}]}]]}]]}]}]}]}]}], "+", 
  FractionBox[
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
   RowBox[{"c", 
    SqrtBox[
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]]}]], "+", 
  RowBox[{"n", 
   RowBox[{"(", 
    RowBox[{"n", "-", "1"}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", " ", "x"}], "]"}], 
       RowBox[{"n", "-", "2"}]], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], 
       RowBox[{"3", "/", "2"}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493058932894973*^9, 3.4930589343449745`*^9}, {
   3.4930590036150713`*^9, 3.493059030475109*^9}, {3.493059071585167*^9, 
   3.4930590795551777`*^9}, {3.4930628403524446`*^9, 3.49306285140246*^9}, {
   3.4932501056192265`*^9, 3.4932501067580285`*^9}, {3.493250146257298*^9, 
   3.493250186942169*^9}, {3.493256078498707*^9, 3.4932560906487236`*^9}, {
   3.4932568685898128`*^9, 3.4932568826798325`*^9}, {3.4933216732775507`*^9, 
   3.4933216957475824`*^9}, {3.4933217278376274`*^9, 3.493321760587673*^9}, 
   3.493321813507747*^9, 3.4933218644878187`*^9, {3.493321906837878*^9, 
   3.493321919617896*^9}, {3.4933220427280684`*^9, 3.493322042928068*^9}, {
   3.4934927094121914`*^9, 3.4934927441222396`*^9}, 3.493492777272286*^9, 
   3.493493493413289*^9, 3.4934935635433865`*^9, 3.493494110054152*^9, {
   3.4937667178058343`*^9, 3.4937667178058343`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"3", "/", "2"}], ")"}]}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "n"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "c", "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", 
           RowBox[{"x", "^", "2"}]}]}], "]"}]}], ")"}]}]}], " ", "+", "\n", 
    "  ", 
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", 
           RowBox[{"x", "^", "2"}]}]}], "]"}]}], ")"}]}]}], " ", "+", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "*", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}], "/", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"3", "/", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGCQBmIQLZPyfKkF2yvHor2uy0C0gJTrKhC9aGLmMRDdo3j2
HIjmN+W7CKK/r8+5AaLT3lfdBtEvpr5nsATSehP+gunYb8c4QfSvlI9g2qfZ
WwJE52hNUAPR85i4dUF0h94NMB3z8ZMjiObY1uwEop9dOtEOos26NnWC6B+P
j96rAtIMzMqPQHTVcuGXIHpLnfxrEN29p/I9iJ4RlvwFREfMZ2GoBtJnWVeD
6XdlDGwg2iJCGEynOUvy1QBpr+crwfSN3WbJIDpr+Q4w/SMlg6cWSIumFyiD
6M7adxYg2mnOZzA9V1zDDkSn8WaC6W0dss4gOkZpPZh2nfb5sx870N8vlL+C
6MtWsdn+QFrt1ZsKEL3rFtsGEO2me38biF60QngPiD6oKw+mOW7GCFQBaXPT
JWA6QHrX8StINAB7jrsz
  "],
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "2"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.493057857853468*^9, 3.4930578807234993`*^9}, {3.4930589528050003`*^9, 
   3.4930589841650443`*^9}, {3.493256250928948*^9, 3.493256250928948*^9}, {
   3.493493532773344*^9, 3.493493535913348*^9}, {3.493582160473214*^9, 
   3.493582160473214*^9}, {3.493582259573353*^9, 3.493582259573353*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], 
      RowBox[{"3", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                                              \
  ", "\[IndentingNewLine]", "                        ", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"ArcCoth", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "+", "1"}]], 
       RowBox[{"a", " ", "c", " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], " ", 
        SqrtBox[
         RowBox[{"c", "+", 
          RowBox[{"d", " ", 
           SuperscriptBox["x", "2"]}]}]]}]]}]}]}]}], "-", 
  FractionBox[
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}], 
     RowBox[{"n", "+", "2"}]]}], 
   RowBox[{"c", " ", 
    RowBox[{"(", 
     RowBox[{"n", "+", "1"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"n", "+", "2"}], ")"}], " ", 
    SqrtBox[
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]]}]], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"n", "+", "2"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", " ", "x"}], "]"}], 
       RowBox[{"n", "+", "2"}]], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], 
       RowBox[{"3", "/", "2"}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493058932894973*^9, 3.4930589343449745`*^9}, {
   3.4930590036150713`*^9, 3.493059030475109*^9}, {3.493059071585167*^9, 
   3.4930590795551777`*^9}, {3.4930628403524446`*^9, 3.49306285140246*^9}, {
   3.4932501056192265`*^9, 3.4932501067580285`*^9}, {3.493250146257298*^9, 
   3.493250186942169*^9}, {3.493256078498707*^9, 3.4932560906487236`*^9}, {
   3.4932568685898128`*^9, 3.4932568826798325`*^9}, {3.4933216732775507`*^9, 
   3.4933216957475824`*^9}, {3.4933217278376274`*^9, 3.493321760587673*^9}, 
   3.493321813507747*^9, 3.4933218644878187`*^9, {3.493321906837878*^9, 
   3.493321919617896*^9}, {3.4933220427280684`*^9, 3.493322042928068*^9}, {
   3.4934927094121914`*^9, 3.4934927441222396`*^9}, 3.493492777272286*^9, 
   3.493493493413289*^9, 3.4934935635433865`*^9, {3.4935896515237017`*^9, 
   3.4935897029137735`*^9}, {3.4935902147344904`*^9, 
   3.4935902271545076`*^9}, {3.4937667178358345`*^9, 3.4937667178358345`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"3", "/", "2"}], ")"}]}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"a", "*", "c", "*", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", 
          RowBox[{"x", "^", "2"}]}]}], "]"}]}], ")"}]}], " ", "-", "\n", "  ", 
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}], "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", 
           RowBox[{"x", "^", "2"}]}]}], "]"}]}], ")"}]}]}], " ", "+", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "2"}], ")"}]}], "/", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"3", "/", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGCQBGIQLZPyfKkF2yvHor2uy0C0gJTrKhC9aGLmMRDdo3j2
HIjmN+W7CKK/r8+5AaLT3lfdBtEvpr5nsATSehP+gunYb8c4QfSvlI9g2qfZ
WwJE52hNUAPR85i4dUF0h94NMB3z8ZMjiObY1uwEop9dOtEOos26NnWC6B+P
j96rAtIMzMqPQHTVcuGXIHpLnfxrEN29p/I9iJ4RlvwFREfMZ2GoBtJnWVeD
6XdlDGwg2iJCGEynOUvy1QBpr+crwfSN3WbJIDpr+Q4w/SMlg6cWSIumFyiD
6M7adxYg2mnOZzA9V1zDDkSn8WaC6W0dss4gOkZpPZh2nfb5sx870N8vlL+C
6MtWsdn+QFrt1ZsKEL3j3FT+KiDtO/EymBYR3H38CpD+nwShAf91ryg=
  "],
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"m", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.493256289109001*^9, 3.493256289109001*^9}, {3.4935821637032185`*^9, 
   3.4935821637032185`*^9}, {3.4935822523333426`*^9, 3.4935822523333426`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "m"], " ", 
    RowBox[{"ArcCoth", "[", 
     RowBox[{"a", " ", "x"}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                             ", 
      "\[IndentingNewLine]", "                                      ", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", 
           SuperscriptBox["x", "2"]}]}], ")"}], "m"], 
       RowBox[{"2", " ", "a", " ", "m", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "m"}], "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  FractionBox[
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "m"], " ", 
    RowBox[{"ArcCoth", "[", 
     RowBox[{"a", " ", "x"}], "]"}]}], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", "m"}], "+", "1"}], ")"}]], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", "c", " ", "m"}], 
    RowBox[{
     RowBox[{"2", " ", "m"}], "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], 
      RowBox[{"m", "-", "1"}]], " ", 
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.4933211866068697`*^9, {3.4933213613371143`*^9, 
   3.493321413107187*^9}, {3.493590253834545*^9, 3.4935902541945457`*^9}, {
   3.493766717865834*^9, 3.493766717865834*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "m_."}], "*", 
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a_.", "*", "x_"}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "m"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", "a", "*", "m", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "*", "m"}], "+", "1"}], ")"}]}], ")"}]}], " ", "+", 
    "\n", "  ", 
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "m"}], "*", 
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", "*", "m"}], "+", "1"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"2", "*", "c", "*", 
       RowBox[{"m", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "m"}], "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{"ArcCoth", "[", 
          RowBox[{"a", "*", "x"}], "]"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929236652023163`*^9, 3.49292366743312*^9}, 
   3.4929802336571484`*^9, {3.4935809181814747`*^9, 3.4935809199314775`*^9}, {
   3.4937667178758345`*^9, 3.4937667178758345`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"m", "\[NotEqual]", 
     RowBox[{"-", 
      FractionBox["3", "2"]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4932562829889927`*^9, 3.4932562829889927`*^9}, {3.493582169323227*^9, 
   3.493582169323227*^9}, {3.4935822423333287`*^9, 3.4935822423333287`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "m"], " ", 
    RowBox[{"ArcCoth", "[", 
     RowBox[{"a", " ", "x"}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                            ", 
      "\[IndentingNewLine]", "                            ", 
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", 
            SuperscriptBox["x", "2"]}]}], ")"}], 
         RowBox[{"m", "+", "1"}]], 
        RowBox[{"4", " ", "a", " ", "c", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}], "2"]}]]}]}]}]}]}], "-", 
  FractionBox[
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], 
     RowBox[{"m", "+", "1"}]], " ", 
    RowBox[{"ArcCoth", "[", 
     RowBox[{"a", " ", "x"}], "]"}]}], 
   RowBox[{"2", "c", 
    RowBox[{"(", 
     RowBox[{"m", "+", "1"}], ")"}]}]], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"2", "m"}], "+", "3"}], 
    RowBox[{"2", " ", "c", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], 
      RowBox[{"m", "+", "1"}]], " ", 
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.49332119396688*^9, {3.4933214175471926`*^9, 
   3.4933214366372194`*^9}, {3.4933214780072775`*^9, 
   3.4933214840172863`*^9}, {3.4935902637145586`*^9, 3.493590263914559*^9}, {
   3.4937667178858347`*^9, 3.493766717895835*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a_.", "*", "x_"}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", 
          RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}]}], "/", 
     RowBox[{"(", 
      RowBox[{"4", "*", "a", "*", "c", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "^", "2"}]}], ")"}]}], " ", "-", 
    "\n", "  ", 
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "c", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "*", "m"}], "+", "3"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "c", "*", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{"ArcCoth", "[", 
          RowBox[{"a", "*", "x"}], "]"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"m", "\[NotEqual]", 
     RowBox[{
      RowBox[{"-", "3"}], "/", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
  3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
  3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
  3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
  3.4929234715435762`*^9}, {3.4929235863597775`*^9, 3.4929237005051785`*^9}, {
  3.4929237523440695`*^9, 3.49292375875568*^9}, {3.492923919591963*^9, 
  3.4929239241159706`*^9}, {3.4929244782757444`*^9, 3.4929244935793715`*^9}, {
  3.493580912351467*^9, 3.4935809141414695`*^9}, {3.493766717895835*^9, 
  3.4937667179058347`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"m", "\[NotEqual]", 
     RowBox[{"-", 
      FractionBox["3", "2"]}]}], " ", "\[And]", " ", 
    RowBox[{"n", ">", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.493057857853468*^9, 3.4930578807234993`*^9}, {3.4932562444189386`*^9, 
   3.4932562444189386`*^9}, {3.4935821752432346`*^9, 
   3.4935821752432346`*^9}, {3.493582235473319*^9, 3.493582235473319*^9}}],

Cell[BoxData[
 RowBox[{"\t", 
  RowBox[{
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "m"], " ", 
     SuperscriptBox[
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", 
      RowBox[{
      "x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", "\t", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"n", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", 
              SuperscriptBox["x", "2"]}]}], ")"}], 
           RowBox[{"m", "+", "1"}]], " ", 
          SuperscriptBox[
           RowBox[{"ArcCoth", "[", 
            RowBox[{"a", " ", "x"}], "]"}], 
           RowBox[{"n", "-", "1"}]]}], 
         RowBox[{"4", " ", "a", " ", "c", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"m", "+", "1"}], ")"}], "2"]}]]}]}]}]}]}], "-", 
   FractionBox[
    RowBox[{"x", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], 
      RowBox[{"m", "+", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
    RowBox[{"2", " ", "c", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], "+", "\[IndentingNewLine]", "\t\t", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"2", " ", "m"}], "+", "3"}], 
     RowBox[{"2", " ", "c", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], 
       RowBox[{"m", "+", "1"}]], " ", 
      SuperscriptBox[
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}], "+", 
   RowBox[{
    FractionBox[
     RowBox[{"n", 
      RowBox[{"(", 
       RowBox[{"n", "-", "1"}], ")"}]}], 
     RowBox[{"4", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "2"]}]], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], "m"], " ", 
      SuperscriptBox[
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", " ", "x"}], "]"}], 
       RowBox[{"n", "-", "2"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493057986293648*^9, 3.4930579935736575`*^9}, {
  3.493058073023769*^9, 3.4930581370938587`*^9}, {3.493058203013951*^9, 
  3.4930582589840293`*^9}, {3.4930583663841796`*^9, 3.4930583693341837`*^9}, {
  3.493058675794613*^9, 3.4930586798646183`*^9}, {3.4932494353148484`*^9, 
  3.4932495464338436`*^9}, {3.493256213058895*^9, 3.493256222448908*^9}, {
  3.4932569792699676`*^9, 3.4932569886099806`*^9}, {3.493322039288063*^9, 
  3.493322069838106*^9}, {3.4933221617682347`*^9, 3.49332216517824*^9}, {
  3.4937667179158344`*^9, 3.4937667179158344`*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "n"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"4", "*", "a", "*", "c", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], "^", "2"}]}], ")"}]}]}], " ", "-", 
    "\n", "  ", 
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "c", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "*", "m"}], "+", "3"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "c", "*", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"4", "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"m", "+", "1"}], ")"}], "^", "2"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "m"}], "*", 
         RowBox[{
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"m", "\[NotEqual]", 
     RowBox[{
      RowBox[{"-", "3"}], "/", "2"}]}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQBmIQLZPyfKkF2yvHor2uy0C0gJTrKhC9aGLmMRDdo3j2
HIjmN+W7CKK/r8+5AaLT3lfdBtEvpr5nsATSehP+gunYb8c4QfSvlI9g2qfZ
WwJE52hNUAPR85i4dUF0h94NMB3z8ZMjiObY1uwEop9dOtEOos26NnWC6B+P
j96rAtIMzMqPQHTVcuGXIHpLnfxrEN29p/I9iJ4RlvwFREfMZ2GoBtJnWVeD
6XdlDGwg2iJCGEynOUvy1QBpr+crwfSN3WbJIDpr+Q4w3bc0kbeK/ZWjudh0
MB3zae/xK0g0ANfnhcY=
  "],
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{" ", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
    RowBox[{"0", " ", "\[And]", " ", 
     RowBox[{"m", "<", 
      RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
     RowBox[{"n", "<", 
      RowBox[{"-", "1"}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.493057857853468*^9, 3.4930578807234993`*^9}, {3.4930589528050003`*^9, 
   3.4930589841650443`*^9}, {3.493256250928948*^9, 3.493256250928948*^9}, {
   3.493493532773344*^9, 3.493493535913348*^9}, {3.493498461430244*^9, 
   3.493498462750246*^9}, {3.4934986627805257`*^9, 3.4934986654705296`*^9}, {
   3.493500262062765*^9, 3.493500278262788*^9}, {3.4935009224036894`*^9, 
   3.4935009269736958`*^9}, {3.4935024446458206`*^9, 
   3.4935024539658337`*^9}, {3.4935821786732397`*^9, 
   3.4935821786732397`*^9}, {3.4935822229233017`*^9, 
   3.4935822229233017`*^9}, {3.493749489450018*^9, 3.4937494905732203`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                           ", 
      "\[IndentingNewLine]", "                                  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", 
            SuperscriptBox["x", "2"]}]}], ")"}], 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"ArcCoth", "[", 
          RowBox[{"a", " ", "x"}], "]"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"a", " ", "c", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}], 
    RowBox[{"n", "+", "1"}]], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{"x", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "m"], " ", 
     SuperscriptBox[
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493058932894973*^9, 3.4930589343449745`*^9}, {
   3.4930590036150713`*^9, 3.493059030475109*^9}, {3.493059071585167*^9, 
   3.4930590795551777`*^9}, {3.4930628403524446`*^9, 3.49306285140246*^9}, {
   3.4932501056192265`*^9, 3.4932501067580285`*^9}, {3.493250146257298*^9, 
   3.493250186942169*^9}, {3.493256078498707*^9, 3.4932560906487236`*^9}, {
   3.4932568685898128`*^9, 3.4932568826798325`*^9}, {3.4933216732775507`*^9, 
   3.4933216957475824`*^9}, {3.4933217278376274`*^9, 3.493321760587673*^9}, 
   3.493321813507747*^9, 3.4933218644878187`*^9, {3.493321906837878*^9, 
   3.493321919617896*^9}, {3.4933220427280684`*^9, 3.493322042928068*^9}, {
   3.4934927094121914`*^9, 3.4934927441222396`*^9}, 3.493492777272286*^9, 
   3.493493493413289*^9, 3.4934935635433865`*^9, {3.4934984296601996`*^9, 
   3.4934984470202236`*^9}, {3.4934985399803543`*^9, 3.493498542300357*^9}, {
   3.4935897542938457`*^9, 3.4935897803338823`*^9}, {3.493590315164631*^9, 
   3.4935903239546432`*^9}, {3.493766717955835*^9, 3.493766717955835*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "c", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"2", "*", "a", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"x", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "m"}], "*", 
         RowBox[{
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.4929244782757444`*^9, 
   3.4929244935793715`*^9}, {3.493058294184078*^9, 3.493058321094116*^9}, {
   3.493058376614194*^9, 3.4930583929842167`*^9}, {3.4930584278042655`*^9, 
   3.4930584671043205`*^9}, {3.493058560144451*^9, 3.493058565344458*^9}, {
   3.493058608014518*^9, 3.493058608604519*^9}, {3.4930607207894773`*^9, 
   3.4930607253094835`*^9}, {3.49306140171043*^9, 3.4930614057704363`*^9}, {
   3.4930627552623253`*^9, 3.4930629395125833`*^9}, {3.493063111452824*^9, 
   3.4930631116128244`*^9}, {3.4930631532528825`*^9, 
   3.4930631552828856`*^9}, {3.4930631929229383`*^9, 
   3.4930631974729443`*^9}, {3.4934926396120934`*^9, 
   3.4934926491221066`*^9}, {3.4934935949134307`*^9, 
   3.4934937034035826`*^9}, {3.4934984698502555`*^9, 3.493498508170309*^9}, 
   3.4934985697303953`*^9, {3.4934986248104725`*^9, 3.493498645260501*^9}, {
   3.4934987095205913`*^9, 3.4934987697006755`*^9}, {3.4935001781326475`*^9, 
   3.493500210632693*^9}, {3.493500590983225*^9, 3.4935005923432274`*^9}, {
   3.4935009097536716`*^9, 3.4935009104136724`*^9}, {3.4935015174045224`*^9, 
   3.4935015211545277`*^9}, {3.4935022843455963`*^9, 3.493502302285621*^9}, {
   3.493502998526596*^9, 3.493502999946598*^9}, {3.493515736345019*^9, 
   3.4935157392850227`*^9}, {3.4935809012014513`*^9, 
   3.4935809031414537`*^9}, {3.4937667179658346`*^9, 3.4937667179658346`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection"],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"]}], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "m"], "a"]}], " ", 
    SuperscriptBox[
     RowBox[{"Csch", "[", 
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "]"}], 
     RowBox[{"2", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]], " ", 
    SuperscriptBox[
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{
     SubscriptBox["\[PartialD]", "x"], 
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664448654022*^9, 3.479664485386842*^9, {3.4796905699999485`*^9, 
   3.4796905930330687`*^9}, {3.493066205237155*^9, 3.493066233807195*^9}, {
   3.493067002288271*^9, 3.493067007218278*^9}, {3.4930671665685015`*^9, 
   3.4930671719285088`*^9}, {3.49357941453937*^9, 3.4935794178593745`*^9}, {
   3.4935794530694237`*^9, 3.4935794623694367`*^9}, {3.493579591189617*^9, 
   3.4935795950296226`*^9}, {3.4935796369196815`*^9, 3.493579680229742*^9}, {
   3.4935798057299175`*^9, 3.493579823249942*^9}, {3.493580013000208*^9, 
   3.4935800183302155`*^9}, {3.493766717985835*^9, 3.493766717985835*^9}, {
   3.4937747472122264`*^9, 3.493774749012229*^9}, {3.4937753358730507`*^9, 
   3.493775379253111*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "\[Or]", " ", 
      RowBox[{"n", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055117607107`*^9, {3.4930655124161854`*^9, 3.4930655280062075`*^9}, {
   3.493066033556915*^9, 3.49306607975698*^9}, {3.4930669874082503`*^9, 
   3.4930669888982525`*^9}, {3.4932562746689816`*^9, 
   3.4932562746689816`*^9}, {3.493256683249553*^9, 3.4932567141395965`*^9}, 
   3.4935791292589703`*^9, 3.4935800548602667`*^9, {3.4935803350706587`*^9, 
   3.4935803371806617`*^9}, {3.493580465490841*^9, 3.4935804699908476`*^9}, {
   3.493580624611064*^9, 3.4935806402710857`*^9}, 3.493582183493246*^9, 
   3.49358221460329*^9, {3.493582721734*^9, 3.4935827257140055`*^9}, {
   3.493775458523222*^9, 3.49377548522326*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "m"], " ", 
   SuperscriptBox[
    RowBox[{"ArcCoth", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "c"}], ")"}], "m"], "a"]}]}]}], " ", 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox["x", "n"], 
       SuperscriptBox[
        RowBox[{"Csch", "[", "x", "]"}], 
        RowBox[{"2", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579733429823`*^9, 3.4796580025249443`*^9}, {
   3.4796580760106115`*^9, 3.479658076961979*^9}, {3.479658170546547*^9, 
   3.47965817467248*^9}, {3.4796583692823153`*^9, 3.4796583839634256`*^9}, {
   3.4796584934408464`*^9, 3.479658497486664*^9}, {3.479661194084181*^9, 
   3.47966122030188*^9}, 3.479661392649704*^9, {3.4796614543984947`*^9, 
   3.4796614565015182`*^9}, {3.4796616029320755`*^9, 3.47966160861024*^9}, 
   3.479661772305622*^9, 3.47966185512471*^9, {3.4796624643307056`*^9, 
   3.4796624837586412`*^9}, {3.4796684805015345`*^9, 3.479668482213997*^9}, {
   3.47968672053469*^9, 3.479686720544704*^9}, {3.4796906638949633`*^9, 
   3.479690664315568*^9}, {3.479690714507741*^9, 3.4796907460130434`*^9}, 
   3.480705514654872*^9, {3.4930650337755156`*^9, 3.493065049545537*^9}, {
   3.4930657623365355`*^9, 3.4930657881965714`*^9}, {3.4930663212373176`*^9, 
   3.493066363577377*^9}, {3.493066963568217*^9, 3.493066975738234*^9}, 
   3.4932537469796257`*^9, 3.493256113988756*^9, {3.4932567461396413`*^9, 
   3.4932567491696453`*^9}, 3.493579009488803*^9, {3.4935790490588584`*^9, 
   3.4935790516388617`*^9}, {3.4935801113403454`*^9, 3.49358011445035*^9}, {
   3.493766717995835*^9, 3.493766717995835*^9}, {3.493774737892213*^9, 
   3.493774739922216*^9}, {3.4937755187333064`*^9, 3.493775526023317*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"-", "c"}], ")"}], "^", "m"}], "/", "a"}], ",", 
      RowBox[{"Subst", "[", 
       RowBox[{
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", "n"}], "*", 
           RowBox[{
            RowBox[{"Csch", "[", "x", "]"}], "^", 
            RowBox[{"(", 
             RowBox[{"2", "*", 
              RowBox[{"(", 
               RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], ",", "x"}], "]"}],
         ",", "x", ",", 
        RowBox[{"ArcCoth", "[", 
         RowBox[{"a", "*", "x"}], "]"}]}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "||", " ", 
      RowBox[{"Not", "[", 
       RowBox[{"IntegerQ", "[", "n", "]"}], "]"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.493065103075612*^9, 3.493065290765875*^9}, {
  3.493065714046468*^9, 3.493065729586489*^9}, {3.4930658063465967`*^9, 
  3.4930658068865976`*^9}, {3.493067047288334*^9, 3.493067049548337*^9}, {
  3.4930670867783895`*^9, 3.493067112388425*^9}, {3.4930674070088377`*^9, 
  3.4930674148588486`*^9}, {3.4930676846992264`*^9, 3.4930676962292423`*^9}, {
  3.4935801866504507`*^9, 3.493580239560525*^9}, {3.493580375290715*^9, 
  3.4935803824807253`*^9}, {3.493580473120852*^9, 3.4935804871108713`*^9}, {
  3.493580711731186*^9, 3.493580717491194*^9}, {3.4935808945314417`*^9, 
  3.4935808963414445`*^9}, {3.493582837424162*^9, 3.4935828401941657`*^9}, {
  3.4937667180058346`*^9, 3.4937667180058346`*^9}, {3.4937756044734263`*^9, 
  3.4937756315134645`*^9}, {3.4937756678035154`*^9, 3.4937757008935614`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", "0"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["c", 
        RowBox[{"m", "-", 
         FractionBox["1", "2"]}]], 
       SqrtBox[
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}]]}], 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["x", "2"]}]}]]], ",", "x"}], "]"}], "=", "0"}]],
  CellChangeTimes->{{3.4937498379858303`*^9, 3.4937499017587423`*^9}, {
   3.4937499674816575`*^9, 3.493750029569767*^9}}]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664448654022*^9, 3.479664485386842*^9, {3.4796905699999485`*^9, 
   3.4796905930330687`*^9}, {3.493066205237155*^9, 3.493066233807195*^9}, {
   3.493067002288271*^9, 3.493067007218278*^9}, {3.4930671665685015`*^9, 
   3.4930671719285088`*^9}, {3.49357941453937*^9, 3.4935794178593745`*^9}, {
   3.4935794530694237`*^9, 3.4935794623694367`*^9}, {3.493579591189617*^9, 
   3.4935795950296226`*^9}, {3.4935796369196815`*^9, 3.493579680229742*^9}, {
   3.4935798057299175`*^9, 3.493579823249942*^9}, {3.493580013000208*^9, 
   3.4935800183302155`*^9}, {3.4937499298855915`*^9, 
   3.4937499486524243`*^9}, {3.4937500390389833`*^9, 3.4937500431885905`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
    RowBox[{"0", " ", "\[And]", " ", "m"}]}], ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "\[Or]", " ", 
      RowBox[{"n", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}], ")"}], " ",
     "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ",
     "\[And]", " ", 
    RowBox[{"\[Not]", 
     RowBox[{"(", 
      RowBox[{"c", ">", "0"}], ")"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055117607107`*^9, {3.4930655124161854`*^9, 3.4930655280062075`*^9}, {
   3.493066033556915*^9, 3.49306607975698*^9}, {3.4930680892297926`*^9, 
   3.4930681267098455`*^9}, {3.4930801578959255`*^9, 
   3.4930801961259785`*^9}, {3.493256255798955*^9, 3.4932562676389713`*^9}, {
   3.493582187523252*^9, 3.493582201173271*^9}, {3.4935826492138987`*^9, 
   3.4935826803839417`*^9}, {3.4935827341640177`*^9, 
   3.4935827808740826`*^9}, {3.4935831190745564`*^9, 3.49358317149463*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "m"], 
   SuperscriptBox[
    RowBox[{"ArcCoth", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SuperscriptBox["c", 
        RowBox[{"m", "-", 
         FractionBox["1", "2"]}]], 
       SqrtBox[
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}]]}], 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["x", "2"]}]}]]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "m"], 
     SuperscriptBox[
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579733429823`*^9, 3.4796580025249443`*^9}, {
   3.4796580760106115`*^9, 3.479658076961979*^9}, {3.479658170546547*^9, 
   3.47965817467248*^9}, {3.4796583692823153`*^9, 3.4796583839634256`*^9}, {
   3.4796584934408464`*^9, 3.479658497486664*^9}, {3.479661194084181*^9, 
   3.47966122030188*^9}, 3.479661392649704*^9, {3.4796614543984947`*^9, 
   3.4796614565015182`*^9}, {3.4796616029320755`*^9, 3.47966160861024*^9}, 
   3.479661772305622*^9, 3.47966185512471*^9, {3.4796624643307056`*^9, 
   3.4796624837586412`*^9}, {3.4796684805015345`*^9, 3.479668482213997*^9}, {
   3.47968672053469*^9, 3.479686720544704*^9}, {3.4796906638949633`*^9, 
   3.479690664315568*^9}, {3.479690714507741*^9, 3.4796907460130434`*^9}, 
   3.480705514654872*^9, {3.4930650337755156`*^9, 3.493065049545537*^9}, {
   3.4930657623365355`*^9, 3.4930657881965714`*^9}, {3.493077421798092*^9, 
   3.4930774294181027`*^9}, {3.49307964724521*^9, 3.493079659035227*^9}, {
   3.4930797467153497`*^9, 3.493079763295373*^9}, {3.493079973595667*^9, 
   3.4930800012057056`*^9}, {3.4932537598652487`*^9, 3.4932537660740595`*^9}, 
   3.493256110328751*^9, {3.4935825897438154`*^9, 3.4935826029438334`*^9}, {
   3.493766718025835*^9, 3.493766718025835*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "m_"}], "*", 
      RowBox[{
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}], 
    "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{"c", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", 
        RowBox[{"1", "/", "2"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"1", "-", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "*", 
         RowBox[{"x", "^", "2"}]}]}], "]"}]}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{
            RowBox[{"a", "^", "2"}], "*", 
            RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "m"}], "*", 
        RowBox[{
         RowBox[{"ArcCoth", "[", 
          RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
    " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
      " ", 
     RowBox[{"ZeroQ", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", 
     " ", 
     RowBox[{"RationalQ", "[", 
      RowBox[{"{", 
       RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
     RowBox[{"m", "<", 
      RowBox[{"-", "1"}]}], " ", "&&", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"n", "<", "0"}], " ", "||", " ", 
       RowBox[{"Not", "[", 
        RowBox[{"IntegerQ", "[", "n", "]"}], "]"}]}], ")"}], " ", "&&", " ", 
     RowBox[{"IntegerQ", "[", 
      RowBox[{"m", "-", 
       RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
     RowBox[{"Not", "[", 
      RowBox[{"PositiveQ", "[", "c", "]"}], "]"}]}]}]}], " ", "*)"}]], "Code",
 CellChangeTimes->{{3.493065103075612*^9, 3.493065290765875*^9}, {
   3.493065714046468*^9, 3.493065729586489*^9}, {3.4930658063465967`*^9, 
   3.4930658068865976`*^9}, {3.493067423888861*^9, 3.4930674284788675`*^9}, 
   3.493068077149776*^9, {3.493080071975805*^9, 3.493080131335888*^9}, {
   3.4930802396760397`*^9, 3.4930802468960495`*^9}, {3.4932538772710547`*^9, 
   3.4932538805314603`*^9}, {3.4935808882514334`*^9, 3.493580890111436*^9}, {
   3.493582859644193*^9, 3.493582867944205*^9}, {3.4935830452044525`*^9, 
   3.4935830783744993`*^9}, {3.4935832217946997`*^9, 3.493583225184705*^9}, {
   3.493766718035835*^9, 3.493766718035835*^9}, {3.4937760036239853`*^9, 
   3.4937760079539914`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
   SuperscriptBox[
    RowBox[{"ArcCoth", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.479616001935333*^9, 3.4796867203444157`*^9, {3.479687071148848*^9, 
   3.479687071399208*^9}, 3.4928222618129525`*^9, 3.4928258304168224`*^9, {
   3.4929226804037867`*^9, 3.4929226942254105`*^9}, {3.492979990624321*^9, 
   3.4929799910143223`*^9}, {3.493060035696517*^9, 3.4930600483865347`*^9}, 
   3.493253406025427*^9, {3.493354142567293*^9, 3.493354158680215*^9}, 
   3.493766718035835*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.493099207935931*^9, 3.4930992149659414`*^9}, {
  3.4935738213175373`*^9, 3.493573838477561*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
    RowBox[{"p", "\[NotEqual]", 
     RowBox[{"-", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4932562829889927`*^9, 3.4932562829889927`*^9}, {3.4933543405726185`*^9, 
   3.493354354743429*^9}, {3.493354669307421*^9, 3.493354670200472*^9}, {
   3.4933549046238804`*^9, 3.493354922498903*^9}, {3.493415722490226*^9, 
   3.493415730810238*^9}, {3.4935738213175373`*^9, 3.493573838477561*^9}, {
   3.4935823105834246`*^9, 3.4935823105834246`*^9}, {3.4935823762035165`*^9, 
   3.4935823762035165`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", 
            SuperscriptBox["x", "2"]}]}], ")"}], 
         RowBox[{"p", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"ArcCoth", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
       RowBox[{"2", " ", "d", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox["n", 
    RowBox[{"2", " ", "a", 
     RowBox[{"(", 
      RowBox[{"p", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
     SuperscriptBox[
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.49332119396688*^9, {3.4933214175471926`*^9, 
   3.4933214366372194`*^9}, {3.4933214780072775`*^9, 
   3.4933214840172863`*^9}, {3.493354278495068*^9, 3.493354294476982*^9}, {
   3.4933546277870464`*^9, 3.4933546449460278`*^9}, {3.493354790721366*^9, 
   3.4933547931895065`*^9}, {3.4933563805813007`*^9, 3.493356384480523*^9}, {
   3.4935738213175373`*^9, 3.493573838477561*^9}, {3.4937667180458345`*^9, 
   3.493766718055835*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "a", "*", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"n", ",", "p"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"p", "\[NotEqual]", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.4929244782757444`*^9, 
   3.4929244935793715`*^9}, {3.4933546901676145`*^9, 3.493354852357891*^9}, {
   3.493354994220005*^9, 3.4933549944920206`*^9}, 3.493356145801872*^9, 
   3.4933562876739864`*^9, {3.493356396607217*^9, 3.493356401341488*^9}, {
   3.493415708300206*^9, 3.493415712490212*^9}, {3.493580788181293*^9, 
   3.493580790631296*^9}, {3.493766718065835*^9, 3.493766718065835*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalQ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4932562829889927`*^9, 3.4932562829889927`*^9}, {3.4933543405726185`*^9, 
   3.493354354743429*^9}, {3.493354669307421*^9, 3.493354670200472*^9}, {
   3.4933549046238804`*^9, 3.493354922498903*^9}, {3.493415722490226*^9, 
   3.493415730810238*^9}, {3.4935159619553347`*^9, 3.49351600154539*^9}, {
   3.493582316753433*^9, 3.493582316753433*^9}, {3.493582369383507*^9, 
   3.493582369383507*^9}, {3.4949679439187803`*^9, 3.494967944658781*^9}, {
   3.4949694620709057`*^9, 3.4949694620709057`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"x", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], "p"]}], 
     SuperscriptBox[
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "2"]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"x", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", 
             SuperscriptBox["x", "2"]}]}], ")"}], 
          RowBox[{"p", "+", "1"}]]}], 
        RowBox[{"a", " ", "c", " ", 
         RowBox[{"ArcCoth", "[", 
          RowBox[{"a", " ", "x"}], "]"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", "a"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "3"}], ")"}], " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", 
           SuperscriptBox["x", "2"]}]}], ")"}], "p"]}], 
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.49332119396688*^9, {3.4933214175471926`*^9, 
   3.4933214366372194`*^9}, {3.4933214780072775`*^9, 
   3.4933214840172863`*^9}, {3.493354278495068*^9, 3.493354294476982*^9}, {
   3.4933546277870464`*^9, 3.4933546449460278`*^9}, {3.493354790721366*^9, 
   3.4933547931895065`*^9}, {3.4933563805813007`*^9, 3.493356384480523*^9}, {
   3.4935159055452557`*^9, 3.4935159469853134`*^9}, {3.4935898317039537`*^9, 
   3.493589853353984*^9}, {3.4935903822847247`*^9, 3.4935904229047813`*^9}, {
   3.493590752655243*^9, 3.493590763525258*^9}, {3.4935908715154095`*^9, 
   3.4935908771554174`*^9}, {3.4935909258054857`*^9, 3.493590926785487*^9}, {
   3.493591021125619*^9, 3.493591039645645*^9}, {3.493591125495765*^9, 
   3.493591126025766*^9}, {3.4935912357559195`*^9, 3.49359123615592*^9}, {
   3.494967953858794*^9, 3.4949680122488756`*^9}, {3.4949693812107925`*^9, 
   3.494969427310857*^9}, {3.4951573292531414`*^9, 3.495157330329543*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_."}], "/", 
      RowBox[{
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "^", "2"}]}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "x"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", 
          RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "c", "*", 
        RowBox[{"ArcCoth", "[", 
         RowBox[{"a", "*", "x"}], "]"}]}], ")"}]}]}], " ", "+", 
    "\[IndentingNewLine]", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "a"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", "*", "p"}], "+", "3"}], ")"}], "*", 
            RowBox[{"a", "^", "2"}], "*", 
            RowBox[{"x", "^", "2"}]}]}], ")"}], "*", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", 
              RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], "/", 
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", "*", "x"}], "]"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.4929244782757444`*^9, 
   3.4929244935793715`*^9}, {3.4933546901676145`*^9, 3.493354852357891*^9}, {
   3.493354994220005*^9, 3.4933549944920206`*^9}, 3.493356145801872*^9, 
   3.4933562876739864`*^9, {3.493356396607217*^9, 3.493356401341488*^9}, {
   3.493415708300206*^9, 3.493415712490212*^9}, {3.4935159552553253`*^9, 
   3.493515974425352*^9}, {3.493516011355404*^9, 3.4935160426754475`*^9}, {
   3.493516152975602*^9, 3.4935161582156096`*^9}, {3.4935807957313037`*^9, 
   3.4935807976813064`*^9}, {3.494969533241005*^9, 3.4949695405110154`*^9}, {
   3.494969605621106*^9, 3.494969728921279*^9}, 3.4949697639513283`*^9, {
   3.495157330766344*^9, 3.4951573325603476`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "2"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4932562829889927`*^9, 3.4932562829889927`*^9}, {3.4933543405726185`*^9, 
   3.493354354743429*^9}, {3.493354669307421*^9, 3.493354670200472*^9}, {
   3.4933549046238804`*^9, 3.493354922498903*^9}, {3.493415722490226*^9, 
   3.493415730810238*^9}, {3.4935159619553347`*^9, 3.49351600154539*^9}, {
   3.493582316753433*^9, 3.493582316753433*^9}, {3.493582369383507*^9, 
   3.493582369383507*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"x", " ", 
      SuperscriptBox[
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "2"]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                                              \
     ", "\[IndentingNewLine]", "                ", 
      FractionBox[
       RowBox[{"x", " ", 
        SuperscriptBox[
         RowBox[{"ArcCoth", "[", 
          RowBox[{"a", " ", "x"}], "]"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"a", " ", "c", " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", 
           SuperscriptBox["x", "2"]}]}], ")"}]}]]}]}]}]}], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}], 
     RowBox[{"n", "+", "2"}]]}], 
   RowBox[{"d", " ", 
    RowBox[{"(", 
     RowBox[{"n", "+", "1"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"n", "+", "2"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}]}]], "+", 
  RowBox[{
   FractionBox["4", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"n", "+", "2"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"x", " ", 
       SuperscriptBox[
        RowBox[{"ArcCoth", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "+", "2"}]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], "2"]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.49332119396688*^9, {3.4933214175471926`*^9, 
   3.4933214366372194`*^9}, {3.4933214780072775`*^9, 
   3.4933214840172863`*^9}, {3.493354278495068*^9, 3.493354294476982*^9}, {
   3.4933546277870464`*^9, 3.4933546449460278`*^9}, {3.493354790721366*^9, 
   3.4933547931895065`*^9}, {3.4933563805813007`*^9, 3.493356384480523*^9}, {
   3.4935159055452557`*^9, 3.4935159469853134`*^9}, {3.4935898317039537`*^9, 
   3.493589853353984*^9}, {3.4935903822847247`*^9, 3.4935904229047813`*^9}, {
   3.493590752655243*^9, 3.493590763525258*^9}, {3.4935908715154095`*^9, 
   3.4935908771554174`*^9}, {3.4935909258054857`*^9, 3.493590926785487*^9}, {
   3.493591021125619*^9, 3.493591039645645*^9}, {3.493591125495765*^9, 
   3.493591126025766*^9}, {3.4935912357559195`*^9, 3.49359123615592*^9}, {
   3.4937667181258345`*^9, 3.4937667181258345`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}], "/", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "2"}]}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "c", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", 
           RowBox[{"x", "^", "2"}]}]}], ")"}]}], ")"}]}]}], " ", "+", 
    "\[IndentingNewLine]", "  ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "*", 
        RowBox[{"x", "^", "2"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", 
           RowBox[{"x", "^", "2"}]}]}], ")"}]}], ")"}]}]}], " ", "+", 
    "\[IndentingNewLine]", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"4", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"x", "*", 
         RowBox[{
          RowBox[{
           RowBox[{"ArcCoth", "[", 
            RowBox[{"a", "*", "x"}], "]"}], "^", 
           RowBox[{"(", 
            RowBox[{"n", "+", "2"}], ")"}]}], "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", 
              RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "2"}]}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.4929244782757444`*^9, 
   3.4929244935793715`*^9}, {3.4933546901676145`*^9, 3.493354852357891*^9}, {
   3.493354994220005*^9, 3.4933549944920206`*^9}, 3.493356145801872*^9, 
   3.4933562876739864`*^9, {3.493356396607217*^9, 3.493356401341488*^9}, {
   3.493415708300206*^9, 3.493415712490212*^9}, {3.4935159552553253`*^9, 
   3.493515974425352*^9}, {3.493516011355404*^9, 3.4935160426754475`*^9}, {
   3.493516152975602*^9, 3.4935161582156096`*^9}, {3.4935807957313037`*^9, 
   3.4935807976813064`*^9}, {3.4937667181358347`*^9, 3.493766718145835*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{{3.493099207935931*^9, 3.4930992149659414`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
    RowBox[{"0", " ", "\[And]", " ", "m"}]}], ",", "n", ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"2", "p"}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
     "\[And]", " ", 
     RowBox[{"m", "<", 
      RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
     RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
     RowBox[{"m", "+", 
      RowBox[{"2", "p"}], "+", "3"}]}], "=", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4932562829889927`*^9, 3.4932562829889927`*^9}, {3.4933543405726185`*^9, 
   3.493354354743429*^9}, {3.493354669307421*^9, 3.493354670200472*^9}, {
   3.4933549046238804`*^9, 3.493354922498903*^9}, {3.493356182221955*^9, 
   3.4933562049342537`*^9}, {3.4933938872666245`*^9, 
   3.4933939122734685`*^9}, {3.493394021941661*^9, 3.493394030412476*^9}, {
   3.493395008824994*^9, 3.493395011601799*^9}, {3.4933950592130823`*^9, 
   3.4933950626138887`*^9}, {3.4933958282120333`*^9, 
   3.4933958335004425`*^9}, {3.4933958648876977`*^9, 3.493395891672944*^9}, {
   3.493406394401163*^9, 3.4934063956011643`*^9}, {3.493414300772232*^9, 
   3.4934143075622416`*^9}, {3.4935055200960126`*^9, 
   3.4935055200960126`*^9}, {3.4935057649384427`*^9, 
   3.4935057649384427`*^9}, {3.493505853515398*^9, 3.493505853515398*^9}, {
   3.493582326893447*^9, 3.4935823540334854`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                             ", 
      "\[IndentingNewLine]", "                                      ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", 
            SuperscriptBox["x", "2"]}]}], ")"}], 
         RowBox[{"p", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"ArcCoth", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
       RowBox[{"c", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", "n"}], 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
     SuperscriptBox[
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.49332119396688*^9, {3.4933214175471926`*^9, 
   3.4933214366372194`*^9}, {3.4933214780072775`*^9, 
   3.4933214840172863`*^9}, {3.493354278495068*^9, 3.493354294476982*^9}, {
   3.4933546277870464`*^9, 3.4933546449460278`*^9}, {3.493354790721366*^9, 
   3.4933547931895065`*^9}, {3.4933560394157867`*^9, 
   3.4933561011583185`*^9}, {3.4933561738414755`*^9, 
   3.4933561751395497`*^9}, {3.4933562501758413`*^9, 
   3.4933562530870085`*^9}, {3.493356410270999*^9, 3.4933564233687477`*^9}, {
   3.493394874820759*^9, 3.4933949021052065`*^9}, {3.493395751163498*^9, 
   3.4933957978543797`*^9}, {3.493406138010804*^9, 3.4934061641108403`*^9}, {
   3.4934062369309425`*^9, 3.4934062462209554`*^9}, {3.49340655671139*^9, 
   3.4934065590813932`*^9}, {3.4934141473620167`*^9, 
   3.4934141575120316`*^9}, {3.493589928364089*^9, 3.4935899505341206`*^9}, {
   3.493766718225835*^9, 3.493766718225835*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"n", "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n", ",", 
      RowBox[{"2", "*", "p"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"2", "*", "p"}], "+", "3"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.4929244782757444`*^9, 
   3.4929244935793715`*^9}, {3.4933546901676145`*^9, 3.493354852357891*^9}, {
   3.493354994220005*^9, 3.4933549944920206`*^9}, {3.4933561282218666`*^9, 
   3.493356154267356*^9}, {3.4933562088824797`*^9, 3.493356243066435*^9}, {
   3.4933562812016163`*^9, 3.4933563433891735`*^9}, {3.4933564509923277`*^9, 
   3.4933564967799463`*^9}, {3.4933565518720975`*^9, 3.493356556926387*^9}, {
   3.493356683297615*^9, 3.493356683651635*^9}, {3.493393781030438*^9, 
   3.4933937826528406`*^9}, {3.49339383350893*^9, 3.4933938341173315`*^9}, {
   3.4933938692017927`*^9, 3.4933938715417967`*^9}, {3.4933939716159725`*^9, 
   3.4933939737687764`*^9}, {3.4933951036263604`*^9, 
   3.4933952261489754`*^9}, {3.4933952605626364`*^9, 3.493395282199874*^9}, {
   3.4933959219993978`*^9, 3.493396038968403*^9}, 3.4933965390584817`*^9, {
   3.4934062197609186`*^9, 3.49340622120092*^9}, {3.4934064692212677`*^9, 
   3.49340657783142*^9}, {3.49341417825206*^9, 3.4934141863320713`*^9}, {
   3.4934142170121145`*^9, 3.4934142188021173`*^9}, {3.493505515821605*^9, 
   3.493505516788807*^9}, 3.493505760539235*^9, {3.4935058497401915`*^9, 
   3.4935058506137934`*^9}, {3.493580815391331*^9, 3.4935808179213347`*^9}, {
   3.493766718235835*^9, 3.493766718235835*^9}, 3.5171886043862305`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{{3.493099207935931*^9, 3.4930992149659414`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
    RowBox[{"0", " ", "\[And]", " ", "m"}]}], ",", "n", ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"2", "p"}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
     "\[And]", " ", 
     RowBox[{"n", "<", 
      RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
     RowBox[{"m", "+", 
      RowBox[{"2", "p"}], "+", "2"}]}], "=", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4932562829889927`*^9, 3.4932562829889927`*^9}, {3.4933543405726185`*^9, 
   3.493354354743429*^9}, {3.493354669307421*^9, 3.493354670200472*^9}, {
   3.4933549046238804`*^9, 3.493354922498903*^9}, {3.493356182221955*^9, 
   3.4933562049342537`*^9}, {3.4933938872666245`*^9, 
   3.4933939122734685`*^9}, {3.493394021941661*^9, 3.493394030412476*^9}, {
   3.493395008824994*^9, 3.493395011601799*^9}, {3.4933950592130823`*^9, 
   3.4933950626138887`*^9}, {3.493444320208996*^9, 3.493444321758998*^9}, {
   3.4934444078191185`*^9, 3.4934444112891235`*^9}, {3.493444627119426*^9, 
   3.493444628299427*^9}, {3.4935055051355867`*^9, 3.4935055051355867`*^9}, {
   3.4935057857020793`*^9, 3.4935057857020793`*^9}, {3.493505835918567*^9, 
   3.493505835918567*^9}, {3.493582332753455*^9, 3.4935823464234743`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", " ", "\[LongRightArrow]", 
      "                                                                       \
                                                              ", 
      "\[IndentingNewLine]", "                                   ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", "m"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", 
            SuperscriptBox["x", "2"]}]}], ")"}], 
         RowBox[{"p", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"ArcCoth", "[", 
          RowBox[{"a", " ", "x"}], "]"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"a", " ", "c", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox["m", 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
     SuperscriptBox[
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.49332119396688*^9, {3.4933214175471926`*^9, 
   3.4933214366372194`*^9}, {3.4933214780072775`*^9, 
   3.4933214840172863`*^9}, {3.493354278495068*^9, 3.493354294476982*^9}, {
   3.4933546277870464`*^9, 3.4933546449460278`*^9}, {3.493354790721366*^9, 
   3.4933547931895065`*^9}, {3.4933560394157867`*^9, 
   3.4933561011583185`*^9}, {3.4933561738414755`*^9, 
   3.4933561751395497`*^9}, {3.4933562501758413`*^9, 
   3.4933562530870085`*^9}, {3.493356410270999*^9, 3.4933564233687477`*^9}, {
   3.493394874820759*^9, 3.4933949021052065`*^9}, {3.493444143068748*^9, 
   3.493444163808777*^9}, {3.4934446369894395`*^9, 3.493444646849453*^9}, {
   3.49358997156415*^9, 3.493589988114173*^9}, {3.493590469004846*^9, 
   3.493590474204853*^9}, {3.4937667182858353`*^9, 3.4937667182858353`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "m"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "c", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"m", "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n", ",", 
      RowBox[{"2", "*", "p"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"2", "*", "p"}], "+", "2"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.4929244782757444`*^9, 
   3.4929244935793715`*^9}, {3.4933546901676145`*^9, 3.493354852357891*^9}, {
   3.493354994220005*^9, 3.4933549944920206`*^9}, {3.4933561282218666`*^9, 
   3.493356154267356*^9}, {3.4933562088824797`*^9, 3.493356243066435*^9}, {
   3.4933562812016163`*^9, 3.4933563433891735`*^9}, {3.4933564509923277`*^9, 
   3.4933564967799463`*^9}, {3.4933565518720975`*^9, 3.493356556926387*^9}, {
   3.493356683297615*^9, 3.493356683651635*^9}, {3.493393781030438*^9, 
   3.4933937826528406`*^9}, {3.49339383350893*^9, 3.4933938341173315`*^9}, {
   3.4933938692017927`*^9, 3.4933938715417967`*^9}, {3.4933939716159725`*^9, 
   3.4933939737687764`*^9}, {3.4933951036263604`*^9, 
   3.4933952261489754`*^9}, {3.4933952605626364`*^9, 3.493395282199874*^9}, 
   3.4933965801177535`*^9, {3.4933967072423773`*^9, 3.4933967295972166`*^9}, {
   3.4933967622168736`*^9, 3.493396766506881*^9}, {3.4934444505191784`*^9, 
   3.4934444533991823`*^9}, {3.4934444856092277`*^9, 3.493444554759324*^9}, {
   3.493444656619467*^9, 3.493444664049477*^9}, {3.493505499691177*^9, 
   3.493505500330778*^9}, 3.4935057823168736`*^9, {3.4935058303025575`*^9, 
   3.4935058307705584`*^9}, {3.493580826771347*^9, 3.49358082920135*^9}, {
   3.4937667182958355`*^9, 3.4937667183058352`*^9}, 3.5171886044174304`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "2"], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], "=", 
   RowBox[{
    FractionBox["1", "d"], "-", 
    FractionBox["c", 
     RowBox[{"d", " ", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664431619528*^9, 3.4796644842351856`*^9, {3.4796867203243876`*^9, 
   3.4796867203243876`*^9}, {3.479686900964134*^9, 3.479686904699506*^9}, 
   3.49290371904314*^9, {3.49316782040429*^9, 3.4931678273342996`*^9}, {
   3.4931678584343433`*^9, 3.4931678962243958`*^9}, {3.4931679645244913`*^9, 
   3.493167967024495*^9}, {3.4931679986345396`*^9, 3.4931680026345453`*^9}, 
   3.493790063331503*^9, 3.4937901678516493`*^9, {3.4937902960118284`*^9, 
   3.4937902973518305`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
    RowBox[{"0", " ", "\[And]", " ", "m"}]}], ",", "n", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "p"}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
    "\[And]", " ", 
    RowBox[{"m", ">", "1"}], " ", "\[And]", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4932562829889927`*^9, 3.4932562829889927`*^9}, {3.4933543405726185`*^9, 
   3.493354354743429*^9}, {3.493354669307421*^9, 3.493354670200472*^9}, {
   3.4933549046238804`*^9, 3.493354922498903*^9}, {3.493356182221955*^9, 
   3.4933562049342537`*^9}, {3.4933938872666245`*^9, 
   3.4933939122734685`*^9}, {3.493394021941661*^9, 3.493394030412476*^9}, {
   3.493582323023442*^9, 3.493582323023442*^9}, {3.4935823597934933`*^9, 
   3.4935823597934933`*^9}, {3.493857373585099*^9, 3.493857373585099*^9}, {
   3.4938623384460526`*^9, 3.4938623392360535`*^9}, {3.49386578680088*^9, 
   3.49386578680088*^9}, {3.493866462471826*^9, 3.493866466731832*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "d"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox["x", 
       RowBox[{"m", "-", "2"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], 
       RowBox[{"p", "+", "1"}]], " ", 
      SuperscriptBox[
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["c", "d"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
     SuperscriptBox[
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.49332119396688*^9, {3.4933214175471926`*^9, 
   3.4933214366372194`*^9}, {3.4933214780072775`*^9, 
   3.4933214840172863`*^9}, {3.493354278495068*^9, 3.493354294476982*^9}, {
   3.4933546277870464`*^9, 3.4933546449460278`*^9}, {3.493354790721366*^9, 
   3.4933547931895065`*^9}, {3.4933560394157867`*^9, 
   3.4933561011583185`*^9}, {3.4933561738414755`*^9, 
   3.4933561751395497`*^9}, {3.4933562501758413`*^9, 
   3.4933562530870085`*^9}, {3.493356410270999*^9, 3.4933564233687477`*^9}, 
   3.49385258804259*^9, {3.493852620612636*^9, 3.4938526898507333`*^9}, {
   3.4938675919634075`*^9, 3.493867595373412*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_"}], "*", 
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "d"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"c", "/", "d"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n", ",", 
      RowBox[{"2", "*", "p"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.4929244782757444`*^9, 
   3.4929244935793715`*^9}, {3.4933546901676145`*^9, 3.493354852357891*^9}, {
   3.493354994220005*^9, 3.4933549944920206`*^9}, {3.4933561282218666`*^9, 
   3.493356154267356*^9}, {3.4933562088824797`*^9, 3.493356243066435*^9}, {
   3.4933562812016163`*^9, 3.4933563433891735`*^9}, {3.4933564509923277`*^9, 
   3.4933564967799463`*^9}, {3.4933565518720975`*^9, 3.493356556926387*^9}, {
   3.493356683297615*^9, 3.493356683651635*^9}, {3.493393781030438*^9, 
   3.4933937826528406`*^9}, {3.49339383350893*^9, 3.4933938341173315`*^9}, {
   3.4933938692017927`*^9, 3.4933938715417967`*^9}, {3.4933939716159725`*^9, 
   3.4933939737687764`*^9}, 3.493396573690542*^9, {3.4935808076513205`*^9, 
   3.493580810011324*^9}, {3.4938563531736703`*^9, 3.493856396943732*^9}, 
   3.4938565202739043`*^9, {3.493857377865105*^9, 3.4938573787451067`*^9}, {
   3.493862320526027*^9, 3.493862321776029*^9}, {3.493865803070903*^9, 
   3.4938658047609053`*^9}, {3.493866443151799*^9, 3.4938664464618034`*^9}, {
   3.4938675963034134`*^9, 3.4938675970134144`*^9}, 3.5171886044486303`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], "=", 
   RowBox[{
    FractionBox["1", "c"], "-", 
    FractionBox[
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}], 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664431619528*^9, 3.4796644842351856`*^9, {3.4796867203243876`*^9, 
   3.4796867203243876`*^9}, {3.479686900964134*^9, 3.479686904699506*^9}, 
   3.49290371904314*^9, {3.49316782040429*^9, 3.4931678273342996`*^9}, {
   3.4931678584343433`*^9, 3.4931678962243958`*^9}, {3.4931679645244913`*^9, 
   3.493167967024495*^9}, {3.4931679986345396`*^9, 3.4931680026345453`*^9}, 
   3.493790063331503*^9, 3.4937901678516493`*^9, {3.4937902960118284`*^9, 
   3.4937902973518305`*^9}, {3.493857825015731*^9, 3.4938578494057655`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
    RowBox[{"0", " ", "\[And]", " ", "m"}]}], ",", "n", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "p"}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
    "\[And]", " ", 
    RowBox[{"m", "<", "0"}], " ", "\[And]", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4932562829889927`*^9, 3.4932562829889927`*^9}, {3.4933543405726185`*^9, 
   3.493354354743429*^9}, {3.493354669307421*^9, 3.493354670200472*^9}, {
   3.4933549046238804`*^9, 3.493354922498903*^9}, {3.493356182221955*^9, 
   3.4933562049342537`*^9}, {3.4933938872666245`*^9, 
   3.4933939122734685`*^9}, {3.493394021941661*^9, 3.493394030412476*^9}, {
   3.493582323023442*^9, 3.493582323023442*^9}, {3.4935823597934933`*^9, 
   3.4935823597934933`*^9}, {3.493857373585099*^9, 3.493857373585099*^9}, {
   3.4938574226851683`*^9, 3.4938574248351707`*^9}, {3.493861363812687*^9, 
   3.493861363812687*^9}, {3.493861896375434*^9, 3.4938618973254347`*^9}, {
   3.493862147205785*^9, 3.493862147205785*^9}, {3.493862334036046*^9, 
   3.4938623346860476`*^9}, {3.4938657907508855`*^9, 
   3.4938657907508855`*^9}, {3.493866473221841*^9, 3.493866473221841*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "c"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox["x", "m"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], 
       RowBox[{"p", "+", "1"}]], " ", 
      SuperscriptBox[
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["d", "c"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
     SuperscriptBox[
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493166154681958*^9, 3.4931662030820255`*^9}, 
   3.4931666207326107`*^9, {3.4932522463481894`*^9, 3.49325228099585*^9}, {
   3.4933158052693357`*^9, 3.4933158328693743`*^9}, {3.4933190308138514`*^9, 
   3.493319134053996*^9}, {3.4933192438441496`*^9, 3.4933192445541506`*^9}, {
   3.4933193363142796`*^9, 3.4933193414042864`*^9}, {3.493412534339759*^9, 
   3.493412536469762*^9}, {3.493789994101406*^9, 3.493790017041438*^9}, {
   3.4937903432618947`*^9, 3.4937903499119043`*^9}, {3.493791019842842*^9, 
   3.4937910517128863`*^9}, 3.493791106992964*^9, 3.49379132604327*^9, {
   3.4937915274235525`*^9, 3.493791535933564*^9}, {3.4937916827437696`*^9, 
   3.4937916869037757`*^9}, {3.4938571031547203`*^9, 3.493857152184789*^9}, {
   3.4938675980634155`*^9, 3.4938675998234186`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_"}], "*", 
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "c"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"d", "/", "c"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n", ",", 
      RowBox[{"2", "*", "p"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", "0"}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929236652023163`*^9, 3.49292366743312*^9}, 
   3.4929802336571484`*^9, {3.492982933672291*^9, 3.4929829505983205`*^9}, {
   3.4929832472016416`*^9, 3.4929833842790823`*^9}, {3.4929834529036026`*^9, 
   3.4929834542764053`*^9}, {3.493166117311906*^9, 3.493166138981936*^9}, {
   3.4931662751621265`*^9, 3.4931663186221876`*^9}, {3.4934126182898765`*^9, 
   3.493412622519882*^9}, {3.4935809700815477`*^9, 3.4935809719615507`*^9}, {
   3.493791136533005*^9, 3.4937911896730795`*^9}, 3.4937912549331713`*^9, {
   3.4938403406557693`*^9, 3.4938403671446157`*^9}, {3.4938574572652164`*^9, 
   3.493857469385233*^9}, {3.493857542505336*^9, 3.493857549915346*^9}, {
   3.493857663025504*^9, 3.4938576691055126`*^9}, 3.4938621399657745`*^9, {
   3.4938623256060343`*^9, 3.4938623265160356`*^9}, {3.49386579402089*^9, 
   3.493865798890897*^9}, 3.4938664556718163`*^9, {3.493867600343419*^9, 
   3.493867601723421*^9}, 3.5171886044798307`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{{3.493099207935931*^9, 3.4930992149659414`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
    RowBox[{"0", " ", "\[And]", " ", "m"}]}], ",", "n", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "p"}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
    "\[And]", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "+", 
      RowBox[{"2", "p"}], "+", "3"}], "\[NotEqual]", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4932562829889927`*^9, 3.4932562829889927`*^9}, {3.4933543405726185`*^9, 
   3.493354354743429*^9}, {3.493354669307421*^9, 3.493354670200472*^9}, {
   3.4933549046238804`*^9, 3.493354922498903*^9}, {3.493356182221955*^9, 
   3.4933562049342537`*^9}, {3.4933938872666245`*^9, 
   3.4933939122734685`*^9}, {3.493394021941661*^9, 3.493394030412476*^9}, {
   3.493395008824994*^9, 3.493395011601799*^9}, {3.4933950592130823`*^9, 
   3.4933950626138887`*^9}, {3.4933958282120333`*^9, 
   3.4933958335004425`*^9}, {3.4933958648876977`*^9, 3.493395891672944*^9}, {
   3.493406394401163*^9, 3.4934063956011643`*^9}, {3.4934443505890384`*^9, 
   3.493444358119049*^9}, {3.4935053801481667`*^9, 3.4935053801481667`*^9}, {
   3.4935057769504633`*^9, 3.4935057769504633`*^9}, {3.493505844997783*^9, 
   3.493505844997783*^9}, {3.493582329573451*^9, 3.4935823505034804`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", 
            SuperscriptBox["x", "2"]}]}], ")"}], 
         RowBox[{"p", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"ArcCoth", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
       RowBox[{"c", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  "                                                                ", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", "n"}], 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
     SuperscriptBox[
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", 
       RowBox[{"2", "p"}], "+", "3"}], ")"}]}], 
    RowBox[{" ", 
     RowBox[{"m", "+", "1"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
     SuperscriptBox[
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.49332119396688*^9, {3.4933214175471926`*^9, 
   3.4933214366372194`*^9}, {3.4933214780072775`*^9, 
   3.4933214840172863`*^9}, {3.493354278495068*^9, 3.493354294476982*^9}, {
   3.4933546277870464`*^9, 3.4933546449460278`*^9}, {3.493354790721366*^9, 
   3.4933547931895065`*^9}, {3.4933560394157867`*^9, 
   3.4933561011583185`*^9}, {3.4933561738414755`*^9, 
   3.4933561751395497`*^9}, {3.4933562501758413`*^9, 
   3.4933562530870085`*^9}, {3.493356410270999*^9, 3.4933564233687477`*^9}, {
   3.493394874820759*^9, 3.4933949021052065`*^9}, {3.493395751163498*^9, 
   3.4933957978543797`*^9}, {3.493406138010804*^9, 3.4934061641108403`*^9}, {
   3.4934062369309425`*^9, 3.4934062462209554`*^9}, {3.49340655671139*^9, 
   3.4934065590813932`*^9}, {3.4937667182558355`*^9, 3.4937667182558355`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"n", "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"2", "*", "p"}], "+", "3"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n", ",", 
      RowBox[{"2", "*", "p"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"2", "*", "p"}], "+", "3"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.4929244782757444`*^9, 
   3.4929244935793715`*^9}, {3.4933546901676145`*^9, 3.493354852357891*^9}, {
   3.493354994220005*^9, 3.4933549944920206`*^9}, {3.4933561282218666`*^9, 
   3.493356154267356*^9}, {3.4933562088824797`*^9, 3.493356243066435*^9}, {
   3.4933562812016163`*^9, 3.4933563433891735`*^9}, {3.4933564509923277`*^9, 
   3.4933564967799463`*^9}, {3.4933565518720975`*^9, 3.493356556926387*^9}, {
   3.493356683297615*^9, 3.493356683651635*^9}, {3.493393781030438*^9, 
   3.4933937826528406`*^9}, {3.49339383350893*^9, 3.4933938341173315`*^9}, {
   3.4933938692017927`*^9, 3.4933938715417967`*^9}, {3.4933939716159725`*^9, 
   3.4933939737687764`*^9}, {3.4933951036263604`*^9, 
   3.4933952261489754`*^9}, {3.4933952605626364`*^9, 3.493395282199874*^9}, {
   3.4933959219993978`*^9, 3.493396038968403*^9}, 3.4933965390584817`*^9, {
   3.4934062197609186`*^9, 3.49340622120092*^9}, {3.4934064692212677`*^9, 
   3.49340657783142*^9}, {3.4934442542789035`*^9, 3.493444261298914*^9}, {
   3.4935053828469715`*^9, 3.4935053837985735`*^9}, 3.493505773830458*^9, {
   3.4935058411913767`*^9, 3.493505841986978*^9}, {3.493580821131339*^9, 
   3.493580823141342*^9}, {3.4937667182658353`*^9, 3.493766718275835*^9}, 
   3.517188604495431*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{{3.493099207935931*^9, 3.4930992149659414`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
    RowBox[{"0", " ", "\[And]", " ", "m"}]}], ",", "n", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "p"}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
    "\[And]", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "+", 
      RowBox[{"2", "p"}], "+", "2"}], "\[NotEqual]", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4932562829889927`*^9, 3.4932562829889927`*^9}, {3.4933543405726185`*^9, 
   3.493354354743429*^9}, {3.493354669307421*^9, 3.493354670200472*^9}, {
   3.4933549046238804`*^9, 3.493354922498903*^9}, {3.493356182221955*^9, 
   3.4933562049342537`*^9}, {3.4933938872666245`*^9, 
   3.4933939122734685`*^9}, {3.493394021941661*^9, 3.493394030412476*^9}, {
   3.493395008824994*^9, 3.493395011601799*^9}, {3.4933950592130823`*^9, 
   3.4933950626138887`*^9}, {3.493444320208996*^9, 3.493444321758998*^9}, {
   3.4934444078191185`*^9, 3.4934444112891235`*^9}, {3.4935053527545185`*^9, 
   3.4935053527545185`*^9}, {3.4935057932368927`*^9, 
   3.4935057932368927`*^9}, {3.4935058259189496`*^9, 
   3.4935058259189496`*^9}, {3.493582335173459*^9, 3.493582342413469*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", " ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", "m"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", 
            SuperscriptBox["x", "2"]}]}], ")"}], 
         RowBox[{"p", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"ArcCoth", "[", 
          RowBox[{"a", " ", "x"}], "]"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"a", " ", "c", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  "                                                                       ", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["m", 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
     SuperscriptBox[
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"a", 
     RowBox[{"(", 
      RowBox[{"m", "+", 
       RowBox[{"2", "p"}], "+", "2"}], ")"}]}], 
    RowBox[{"n", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
     SuperscriptBox[
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.49332119396688*^9, {3.4933214175471926`*^9, 
   3.4933214366372194`*^9}, {3.4933214780072775`*^9, 
   3.4933214840172863`*^9}, {3.493354278495068*^9, 3.493354294476982*^9}, {
   3.4933546277870464`*^9, 3.4933546449460278`*^9}, {3.493354790721366*^9, 
   3.4933547931895065`*^9}, {3.4933560394157867`*^9, 
   3.4933561011583185`*^9}, {3.4933561738414755`*^9, 
   3.4933561751395497`*^9}, {3.4933562501758413`*^9, 
   3.4933562530870085`*^9}, {3.493356410270999*^9, 3.4933564233687477`*^9}, {
   3.493394874820759*^9, 3.4933949021052065`*^9}, {3.493444143068748*^9, 
   3.493444163808777*^9}, {3.493766718315835*^9, 3.493766718325835*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "m"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "c", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"m", "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"2", "*", "p"}], "+", "2"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n", ",", 
      RowBox[{"2", "*", "p"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"2", "*", "p"}], "+", "2"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.4929244782757444`*^9, 
   3.4929244935793715`*^9}, {3.4933546901676145`*^9, 3.493354852357891*^9}, {
   3.493354994220005*^9, 3.4933549944920206`*^9}, {3.4933561282218666`*^9, 
   3.493356154267356*^9}, {3.4933562088824797`*^9, 3.493356243066435*^9}, {
   3.4933562812016163`*^9, 3.4933563433891735`*^9}, {3.4933564509923277`*^9, 
   3.4933564967799463`*^9}, {3.4933565518720975`*^9, 3.493356556926387*^9}, {
   3.493356683297615*^9, 3.493356683651635*^9}, {3.493393781030438*^9, 
   3.4933937826528406`*^9}, {3.49339383350893*^9, 3.4933938341173315`*^9}, {
   3.4933938692017927`*^9, 3.4933938715417967`*^9}, {3.4933939716159725`*^9, 
   3.4933939737687764`*^9}, {3.4933951036263604`*^9, 
   3.4933952261489754`*^9}, {3.4933952605626364`*^9, 3.493395282199874*^9}, 
   3.4933965801177535`*^9, {3.4933967072423773`*^9, 3.4933967295972166`*^9}, {
   3.4933967622168736`*^9, 3.493396766506881*^9}, {3.4934444505191784`*^9, 
   3.4934444533991823`*^9}, {3.4934444856092277`*^9, 3.493444554759324*^9}, 
   3.4934449081898193`*^9, {3.4935053477937098`*^9, 3.4935053483397107`*^9}, 
   3.493505790023287*^9, {3.4935058218473425`*^9, 3.4935058223465433`*^9}, {
   3.4935808341413574`*^9, 3.4935808367413607`*^9}, {3.4937667183358355`*^9, 
   3.4937667183358355`*^9}, 3.517188604526631*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection"],

Cell[TextData[{
 "Basis:",
 " If ",
 Cell[BoxData[
  RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 " and (",
 Cell[BoxData[
  RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 " or ",
 Cell[BoxData[
  RowBox[{"a", ">", "0"}]]],
 "),",
 " ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"e", "+", 
      RowBox[{"f", " ", 
       SuperscriptBox["x", "m"]}]}], ")"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"]}], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "p"], 
      SuperscriptBox["a", 
       RowBox[{"m", "+", "1"}]]]}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"e", " ", 
       SuperscriptBox["a", "m"]}], "+", 
      RowBox[{"f", " ", 
       SuperscriptBox[
        RowBox[{"Coth", "[", 
         RowBox[{"ArcCoth", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "]"}], "m"]}]}], ")"}], 
    SuperscriptBox[
     RowBox[{"Csch", "[", 
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "]"}], 
     RowBox[{"2", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}]], " ", 
    SuperscriptBox[
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{
     SubscriptBox["\[PartialD]", "x"], 
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664448654022*^9, 3.479664485386842*^9, {3.4796905699999485`*^9, 
   3.4796905930330687`*^9}, {3.493066205237155*^9, 3.493066233807195*^9}, {
   3.493067002288271*^9, 3.493067007218278*^9}, {3.4930671665685015`*^9, 
   3.4930671719285088`*^9}, {3.49357941453937*^9, 3.4935794178593745`*^9}, {
   3.4935794530694237`*^9, 3.4935794623694367`*^9}, {3.493579591189617*^9, 
   3.4935795950296226`*^9}, {3.4935796369196815`*^9, 3.493579680229742*^9}, {
   3.4935798057299175`*^9, 3.493579823249942*^9}, {3.493580013000208*^9, 
   3.4935800183302155`*^9}, {3.4935837156853914`*^9, 
   3.4935837306154127`*^9}, {3.493583770785469*^9, 3.4935837932255*^9}, 
   3.493583845935574*^9, {3.49497090133292*^9, 3.4949709217329493`*^9}, {
   3.4949709668630123`*^9, 3.4949710356931086`*^9}, {3.494971138883253*^9, 
   3.494971138883253*^9}, {3.4951576509725065`*^9, 3.49515765306291*^9}, {
   3.4951577021093965`*^9, 3.4951577073822055`*^9}, 3.495157784558342*^9, {
   3.49515782876882*^9, 3.495157831873225*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
    RowBox[{"0", " ", "\[And]", " ", "m"}]}], ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "\[Or]", " ", 
      RowBox[{"n", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}], ")"}], " ",
     "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[Or]", 
      " ", 
      RowBox[{"a", ">", "0"}]}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055117607107`*^9, {3.4930655124161854`*^9, 3.4930655280062075`*^9}, {
   3.493066033556915*^9, 3.49306607975698*^9}, {3.4930669874082503`*^9, 
   3.4930669888982525`*^9}, {3.4932562746689816`*^9, 
   3.4932562746689816`*^9}, {3.493256683249553*^9, 3.4932567141395965`*^9}, {
   3.493484196390273*^9, 3.493484198590276*^9}, {3.4934849126412754`*^9, 
   3.493484912921276*^9}, {3.4934858273225565`*^9, 3.4934858277825565`*^9}, {
   3.4934858606226025`*^9, 3.493485878442628*^9}, {3.493485980752771*^9, 
   3.493486013532817*^9}, 3.4934861613430243`*^9, {3.493582299533409*^9, 
   3.493582299533409*^9}, {3.49358240752356*^9, 3.49358240752356*^9}, {
   3.493584403266354*^9, 3.4935844505964203`*^9}, {3.493584685416749*^9, 
   3.4935846881867533`*^9}, {3.4935847277768087`*^9, 
   3.4935847301168118`*^9}, {3.4935855704579883`*^9, 
   3.4935855725279913`*^9}, {3.4951580589940243`*^9, 3.495158090225279*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"e", "+", 
     RowBox[{"f", " ", 
      SuperscriptBox["x", "m"]}]}], ")"}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
   SuperscriptBox[
    RowBox[{"ArcCoth", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "c"}], ")"}], "p"], 
       SuperscriptBox["a", 
        RowBox[{"m", "+", "1"}]]]}]}]}], " ", 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox["x", "n"], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"e", " ", 
          SuperscriptBox["a", "m"]}], "+", 
         RowBox[{"f", " ", 
          SuperscriptBox[
           RowBox[{"Coth", "[", "x", "]"}], "m"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"Csch", "[", "x", "]"}], 
        RowBox[{"2", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}]}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579733429823`*^9, 3.4796580025249443`*^9}, {
   3.4796580760106115`*^9, 3.479658076961979*^9}, {3.479658170546547*^9, 
   3.47965817467248*^9}, {3.4796583692823153`*^9, 3.4796583839634256`*^9}, {
   3.4796584934408464`*^9, 3.479658497486664*^9}, {3.479661194084181*^9, 
   3.47966122030188*^9}, 3.479661392649704*^9, {3.4796614543984947`*^9, 
   3.4796614565015182`*^9}, {3.4796616029320755`*^9, 3.47966160861024*^9}, 
   3.479661772305622*^9, 3.47966185512471*^9, {3.4796624643307056`*^9, 
   3.4796624837586412`*^9}, {3.4796684805015345`*^9, 3.479668482213997*^9}, {
   3.47968672053469*^9, 3.479686720544704*^9}, {3.4796906638949633`*^9, 
   3.479690664315568*^9}, {3.479690714507741*^9, 3.4796907460130434`*^9}, 
   3.480705514654872*^9, {3.4930650337755156`*^9, 3.493065049545537*^9}, {
   3.4930657623365355`*^9, 3.4930657881965714`*^9}, {3.4930663212373176`*^9, 
   3.493066363577377*^9}, {3.493066963568217*^9, 3.493066975738234*^9}, 
   3.4932537469796257`*^9, 3.493256113988756*^9, {3.4932567461396413`*^9, 
   3.4932567491696453`*^9}, 3.493484110810153*^9, {3.4934842003402786`*^9, 
   3.4934842033302827`*^9}, {3.4934849452513213`*^9, 3.493484979331369*^9}, {
   3.493583483165066*^9, 3.4935834997850895`*^9}, {3.4935840350458384`*^9, 
   3.493584038155843*^9}, {3.4949712212333684`*^9, 3.494971230293381*^9}, {
   3.4949712621134253`*^9, 3.4949712970934744`*^9}, {3.49515766434173*^9, 
   3.4951576691309385`*^9}, {3.4951579443182225`*^9, 3.495157973178273*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"e_.", "+", 
       RowBox[{"f_.", "*", 
        RowBox[{"x_", "^", "m_."}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_"}], "*", 
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"-", "c"}], ")"}], "^", "p"}], "/", 
       RowBox[{"a", "^", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Subst", "[", 
       RowBox[{
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{"Expand", "[", 
           RowBox[{
            RowBox[{"x", "^", "n"}], "*", 
            RowBox[{"TrigReduce", "[", 
             RowBox[{"Regularize", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"e", "*", 
                   RowBox[{"a", "^", "m"}]}], "+", 
                  RowBox[{"f", "*", 
                   RowBox[{
                    RowBox[{"Coth", "[", "x", "]"}], "^", "m"}]}]}], ")"}], 
                "*", 
                RowBox[{
                 RowBox[{"Csch", "[", "x", "]"}], "^", 
                 RowBox[{"(", 
                  RowBox[{"2", "*", 
                   RowBox[{"(", 
                    RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], ",", "x"}], 
              "]"}], "]"}]}], "]"}], ",", "x"}], "]"}], ",", "x", ",", 
        RowBox[{"ArcCoth", "[", 
         RowBox[{"a", "*", "x"}], "]"}]}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "||", " ", 
      RowBox[{"Not", "[", 
       RowBox[{"IntegerQ", "[", "n", "]"}], "]"}]}], ")"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "m", "]"}], " ", "||", " ", 
      RowBox[{"PositiveQ", "[", "a", "]"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.493065103075612*^9, 3.493065290765875*^9}, {
   3.493065714046468*^9, 3.493065729586489*^9}, {3.4930658063465967`*^9, 
   3.4930658068865976`*^9}, {3.493067047288334*^9, 3.493067049548337*^9}, {
   3.4930670867783895`*^9, 3.493067112388425*^9}, {3.4930674070088377`*^9, 
   3.4930674148588486`*^9}, {3.4930676846992264`*^9, 
   3.4930676962292423`*^9}, {3.493484206670287*^9, 3.4934842155203*^9}, 
   3.4934861347329865`*^9, {3.49348619445307*^9, 3.493486231663122*^9}, {
   3.4934862761831846`*^9, 3.4934862874732003`*^9}, {3.493580741261227*^9, 
   3.4935807428812294`*^9}, {3.4935808762114162`*^9, 3.493580878411419*^9}, {
   3.4935841108559446`*^9, 3.4935841493659987`*^9}, {3.493584751096841*^9, 
   3.4935847734468727`*^9}, 3.4935848245769444`*^9, {3.493584859686993*^9, 
   3.493584861126995*^9}, 3.493585344727672*^9, 3.4935853768577175`*^9, {
   3.4935856376880827`*^9, 3.4935856399880857`*^9}, {3.4949713407035356`*^9, 
   3.494971373883582*^9}, {3.494971426013655*^9, 3.4949714378836718`*^9}, {
   3.494972220994768*^9, 3.49497223640479*^9}, {3.4949725116251745`*^9, 
   3.494972523895192*^9}, {3.495157673108946*^9, 3.495157676260151*^9}, {
   3.495158126417342*^9, 3.495158147196579*^9}, {3.495158213387495*^9, 
   3.495158219892707*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection"],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"]}], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "p"], "a"]}], 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox[
       RowBox[{"Coth", "[", 
        RowBox[{"ArcCoth", "[", 
         RowBox[{"a", " ", "x"}], "]"}], "]"}], "a"], ")"}], "m"], 
    SuperscriptBox[
     RowBox[{"Csch", "[", 
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "]"}], 
     RowBox[{"2", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}]], " ", 
    SuperscriptBox[
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{
     SubscriptBox["\[PartialD]", "x"], 
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664448654022*^9, 3.479664485386842*^9, {3.4796905699999485`*^9, 
   3.4796905930330687`*^9}, {3.493066205237155*^9, 3.493066233807195*^9}, {
   3.493067002288271*^9, 3.493067007218278*^9}, {3.4930671665685015`*^9, 
   3.4930671719285088`*^9}, {3.49357941453937*^9, 3.4935794178593745`*^9}, {
   3.4935794530694237`*^9, 3.4935794623694367`*^9}, {3.493579591189617*^9, 
   3.4935795950296226`*^9}, {3.4935796369196815`*^9, 3.493579680229742*^9}, {
   3.4935798057299175`*^9, 3.493579823249942*^9}, {3.493580013000208*^9, 
   3.4935800183302155`*^9}, {3.4935837156853914`*^9, 
   3.4935837306154127`*^9}, {3.493583770785469*^9, 3.4935837932255*^9}, 
   3.493583845935574*^9, {3.493585128467369*^9, 3.493585152037402*^9}, {
   3.493766718395835*^9, 3.493766718395835*^9}, {3.493777009455394*^9, 
   3.493777009455394*^9}, {3.49377761443624*^9, 3.4937776567862997`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
    RowBox[{"0", " ", "\[And]", " ", "m"}]}], ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "\[Or]", " ", 
      RowBox[{"n", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}], ")"}], " ",
     "\[And]", " ", 
    RowBox[{"\[Not]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[Or]", 
       " ", 
       RowBox[{"a", ">", "0"}]}], ")"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055117607107`*^9, {3.4930655124161854`*^9, 3.4930655280062075`*^9}, {
   3.493066033556915*^9, 3.49306607975698*^9}, {3.4930669874082503`*^9, 
   3.4930669888982525`*^9}, {3.4932562746689816`*^9, 
   3.4932562746689816`*^9}, {3.493256683249553*^9, 3.4932567141395965`*^9}, {
   3.493484196390273*^9, 3.493484198590276*^9}, {3.4934849126412754`*^9, 
   3.493484912921276*^9}, {3.4934858273225565`*^9, 3.4934858277825565`*^9}, {
   3.4934858606226025`*^9, 3.493485878442628*^9}, {3.493485980752771*^9, 
   3.493486013532817*^9}, 3.4934860446528606`*^9, 3.493486166643031*^9, {
   3.493582304453416*^9, 3.493582304453416*^9}, {3.4935823991735487`*^9, 
   3.4935823991735487`*^9}, {3.49358546440784*^9, 3.4935854739178534`*^9}, 
   3.4935855059178977`*^9, {3.4937503523187337`*^9, 3.4937503527399344`*^9}, {
   3.493777727926399*^9, 3.4937777429164205`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
   SuperscriptBox[
    RowBox[{"ArcCoth", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "c"}], ")"}], "p"], "a"]}]}]}], " ", 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox["x", "n"], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Coth", "[", "x", "]"}], "/", "a"}], ")"}], "m"], " ", 
       SuperscriptBox[
        RowBox[{"Csch", "[", "x", "]"}], 
        RowBox[{"2", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}]}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579733429823`*^9, 3.4796580025249443`*^9}, {
   3.4796580760106115`*^9, 3.479658076961979*^9}, {3.479658170546547*^9, 
   3.47965817467248*^9}, {3.4796583692823153`*^9, 3.4796583839634256`*^9}, {
   3.4796584934408464`*^9, 3.479658497486664*^9}, {3.479661194084181*^9, 
   3.47966122030188*^9}, 3.479661392649704*^9, {3.4796614543984947`*^9, 
   3.4796614565015182`*^9}, {3.4796616029320755`*^9, 3.47966160861024*^9}, 
   3.479661772305622*^9, 3.47966185512471*^9, {3.4796624643307056`*^9, 
   3.4796624837586412`*^9}, {3.4796684805015345`*^9, 3.479668482213997*^9}, {
   3.47968672053469*^9, 3.479686720544704*^9}, {3.4796906638949633`*^9, 
   3.479690664315568*^9}, {3.479690714507741*^9, 3.4796907460130434`*^9}, 
   3.480705514654872*^9, {3.4930650337755156`*^9, 3.493065049545537*^9}, {
   3.4930657623365355`*^9, 3.4930657881965714`*^9}, {3.4930663212373176`*^9, 
   3.493066363577377*^9}, {3.493066963568217*^9, 3.493066975738234*^9}, 
   3.4932537469796257`*^9, 3.493256113988756*^9, {3.4932567461396413`*^9, 
   3.4932567491696453`*^9}, 3.493484110810153*^9, {3.4934842003402786`*^9, 
   3.4934842033302827`*^9}, {3.4934849452513213`*^9, 3.493484979331369*^9}, {
   3.493486071912899*^9, 3.493486082822914*^9}, {3.4935835296251307`*^9, 
   3.4935835407851467`*^9}, {3.493585265387561*^9, 3.4935852691475663`*^9}, {
   3.493766718405835*^9, 3.493766718405835*^9}, 3.493777010505395*^9, {
   3.49377778559648*^9, 3.493777788456484*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_"}], "*", 
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"-", "c"}], ")"}], "^", "p"}], "/", "a"}], ",", 
      RowBox[{"Subst", "[", 
       RowBox[{
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", "n"}], "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Coth", "[", "x", "]"}], "/", "a"}], ")"}], "^", "m"}], 
           "*", 
           RowBox[{
            RowBox[{"Csch", "[", "x", "]"}], "^", 
            RowBox[{"(", 
             RowBox[{"2", "*", 
              RowBox[{"(", 
               RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], ",", "x"}], "]"}],
         ",", "x", ",", 
        RowBox[{"ArcCoth", "[", 
         RowBox[{"a", "*", "x"}], "]"}]}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "||", " ", 
      RowBox[{"Not", "[", 
       RowBox[{"IntegerQ", "[", "n", "]"}], "]"}]}], ")"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "m", "]"}], " ", "||", " ", 
      RowBox[{"PositiveQ", "[", "a", "]"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.493065103075612*^9, 3.493065290765875*^9}, {
   3.493065714046468*^9, 3.493065729586489*^9}, {3.4930658063465967`*^9, 
   3.4930658068865976`*^9}, {3.493067047288334*^9, 3.493067049548337*^9}, {
   3.4930670867783895`*^9, 3.493067112388425*^9}, {3.4930674070088377`*^9, 
   3.4930674148588486`*^9}, {3.4930676846992264`*^9, 
   3.4930676962292423`*^9}, {3.493484206670287*^9, 3.4934842155203*^9}, 
   3.4934861304629803`*^9, 3.4934861903430643`*^9, {3.4934862534031525`*^9, 
   3.493486262273165*^9}, {3.4934862996232176`*^9, 3.4934863089332304`*^9}, {
   3.4935808677814045`*^9, 3.493580870141408*^9}, {3.4935853052876167`*^9, 
   3.493585373757713*^9}, {3.4935856061680384`*^9, 3.493585615798052*^9}, 
   3.493585663598119*^9, {3.4937667184158354`*^9, 3.493766718425835*^9}, 
   3.4937770124153976`*^9, {3.493777796116495*^9, 3.493777800386501*^9}, {
   3.493777839066555*^9, 3.4937778559165783`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", "0"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["c", 
        RowBox[{"p", "-", 
         FractionBox["1", "2"]}]], 
       SqrtBox[
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}]]}], 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["x", "2"]}]}]]], ",", "x"}], "]"}], "=", "0"}]],
  CellChangeTimes->{{3.4937498379858303`*^9, 3.4937499017587423`*^9}, {
   3.4937499674816575`*^9, 3.493750029569767*^9}}]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664448654022*^9, 3.479664485386842*^9, {3.4796905699999485`*^9, 
   3.4796905930330687`*^9}, {3.493066205237155*^9, 3.493066233807195*^9}, {
   3.493067002288271*^9, 3.493067007218278*^9}, {3.4930671665685015`*^9, 
   3.4930671719285088`*^9}, {3.49357941453937*^9, 3.4935794178593745`*^9}, {
   3.4935794530694237`*^9, 3.4935794623694367`*^9}, {3.493579591189617*^9, 
   3.4935795950296226`*^9}, {3.4935796369196815`*^9, 3.493579680229742*^9}, {
   3.4935798057299175`*^9, 3.493579823249942*^9}, {3.493580013000208*^9, 
   3.4935800183302155`*^9}, {3.4937499298855915`*^9, 
   3.4937499486524243`*^9}, {3.4937500390389833`*^9, 3.4937500431885905`*^9}, 
   3.4937501538707848`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], "+", "d"}], "=", 
    RowBox[{"0", " ", "\[And]", " ", "m"}]}], ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "\[Or]", " ", 
      RowBox[{"n", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}], ")"}], " ",
     "\[And]", " ", 
    RowBox[{
     RowBox[{"p", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ",
     "\[And]", " ", 
    RowBox[{"\[Not]", 
     RowBox[{"(", 
      RowBox[{"c", ">", "0"}], ")"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055117607107`*^9, {3.4930655124161854`*^9, 3.4930655280062075`*^9}, {
   3.493066033556915*^9, 3.49306607975698*^9}, {3.4930680892297926`*^9, 
   3.4930681267098455`*^9}, {3.4930801578959255`*^9, 
   3.4930801961259785`*^9}, {3.493256255798955*^9, 3.4932562676389713`*^9}, {
   3.4934842169503016`*^9, 3.4934842179803033`*^9}, {3.4934855092121105`*^9, 
   3.4934855137621174`*^9}, {3.49358230776342*^9, 3.49358230776342*^9}, {
   3.4935823874135323`*^9, 3.4935823874135323`*^9}, {3.493586084528708*^9, 
   3.4935861150187507`*^9}, {3.493750356390341*^9, 3.493750356561941*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
   SuperscriptBox[
    RowBox[{"ArcCoth", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SuperscriptBox["c", 
        RowBox[{"p", "-", 
         FractionBox["1", "2"]}]], 
       SqrtBox[
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}]]}], 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["x", "2"]}]}]]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "p"], 
     SuperscriptBox[
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579733429823`*^9, 3.4796580025249443`*^9}, {
   3.4796580760106115`*^9, 3.479658076961979*^9}, {3.479658170546547*^9, 
   3.47965817467248*^9}, {3.4796583692823153`*^9, 3.4796583839634256`*^9}, {
   3.4796584934408464`*^9, 3.479658497486664*^9}, {3.479661194084181*^9, 
   3.47966122030188*^9}, 3.479661392649704*^9, {3.4796614543984947`*^9, 
   3.4796614565015182`*^9}, {3.4796616029320755`*^9, 3.47966160861024*^9}, 
   3.479661772305622*^9, 3.47966185512471*^9, {3.4796624643307056`*^9, 
   3.4796624837586412`*^9}, {3.4796684805015345`*^9, 3.479668482213997*^9}, {
   3.47968672053469*^9, 3.479686720544704*^9}, {3.4796906638949633`*^9, 
   3.479690664315568*^9}, {3.479690714507741*^9, 3.4796907460130434`*^9}, 
   3.480705514654872*^9, {3.4930650337755156`*^9, 3.493065049545537*^9}, {
   3.4930657623365355`*^9, 3.4930657881965714`*^9}, {3.493077421798092*^9, 
   3.4930774294181027`*^9}, {3.49307964724521*^9, 3.493079659035227*^9}, {
   3.4930797467153497`*^9, 3.493079763295373*^9}, {3.493079973595667*^9, 
   3.4930800012057056`*^9}, {3.4932537598652487`*^9, 3.4932537660740595`*^9}, 
   3.493256110328751*^9, 3.4934841140101576`*^9, {3.4934842214303083`*^9, 
   3.49348422304031*^9}, 3.493485244821741*^9, 3.4934853226618495`*^9, {
   3.49358577884828*^9, 3.493585797488306*^9}, {3.493766718435835*^9, 
   3.493766718435835*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x_", "^", "m_."}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_"}], "*", 
      RowBox[{
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}], 
    "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{"c", "^", 
      RowBox[{"(", 
       RowBox[{"p", "-", 
        RowBox[{"1", "/", "2"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"1", "-", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "*", 
         RowBox[{"x", "^", "2"}]}]}], "]"}]}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "m"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{
            RowBox[{"a", "^", "2"}], "*", 
            RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], "*", 
        RowBox[{
         RowBox[{"ArcCoth", "[", 
          RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
    " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
      " ", 
     RowBox[{"ZeroQ", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"a", "^", "2"}], "*", "c"}], "+", "d"}], "]"}], " ", "&&", 
     " ", 
     RowBox[{"RationalQ", "[", 
      RowBox[{"{", 
       RowBox[{"m", ",", "n", ",", "p"}], "}"}], "]"}], " ", "&&", " ", 
     RowBox[{"p", "<", 
      RowBox[{"-", "1"}]}], " ", "&&", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"n", "<", "0"}], " ", "||", " ", 
       RowBox[{"Not", "[", 
        RowBox[{"IntegerQ", "[", "n", "]"}], "]"}]}], ")"}], " ", "&&", " ", 
     RowBox[{"IntegerQ", "[", 
      RowBox[{"p", "-", 
       RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
     RowBox[{"Not", "[", 
      RowBox[{"PositiveQ", "[", "c", "]"}], "]"}]}]}]}], " ", "*)"}]], "Code",
 CellChangeTimes->{{3.493065103075612*^9, 3.493065290765875*^9}, {
   3.493065714046468*^9, 3.493065729586489*^9}, {3.4930658063465967`*^9, 
   3.4930658068865976`*^9}, {3.493067423888861*^9, 3.4930674284788675`*^9}, 
   3.493068077149776*^9, {3.493080071975805*^9, 3.493080131335888*^9}, {
   3.4930802396760397`*^9, 3.4930802468960495`*^9}, {3.4932538772710547`*^9, 
   3.4932538805314603`*^9}, {3.493484225600314*^9, 3.493484231900323*^9}, {
   3.4934853924419475`*^9, 3.4934853982519555`*^9}, {3.493485439292013*^9, 
   3.4934854647520485`*^9}, {3.493580855471387*^9, 3.4935808593213925`*^9}, {
   3.4935858177883344`*^9, 3.4935858468983755`*^9}, 3.493585879718421*^9, 
   3.493586196118864*^9, {3.4935862626189575`*^9, 3.493586266048962*^9}, {
   3.493766718445835*^9, 3.493766718445835*^9}, {3.4937778842066183`*^9, 
   3.493777888626624*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"ArcCoth", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, {
   3.4796161531027007`*^9, 3.4796161533330317`*^9}, 3.4796867035102096`*^9, {
   3.4928216890767465`*^9, 3.4928216998095655`*^9}, {3.4928217819749093`*^9, 
   3.492821789587723*^9}, {3.4928219276815653`*^9, 3.492821955418414*^9}, {
   3.492821987970072*^9, 3.4928219896860743`*^9}, {3.4928221957624364`*^9, 
   3.4928222365253077`*^9}, {3.492825657442519*^9, 3.4928256592053223`*^9}, 
   3.493766718605836*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: CRC 586, A&S 4.6.48", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4940991200114183`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070527384861*^9, 3.494109939029312*^9, 3.494112226023958*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"ArcCoth", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], " ", 
        RowBox[{"ArcCoth", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], "]"}]}], "b"]}]}]}]}], "+", 
  FractionBox[
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "2"]}], "]"}], 
   RowBox[{"2", " ", "b"}]]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579729524207`*^9, 3.479658002354699*^9}, {
   3.479658032958706*^9, 3.479658033819944*^9}, {3.479658266604672*^9, 
   3.479658270990979*^9}, 3.4796611918409553`*^9, {3.4796613913478317`*^9, 
   3.47966140315481*^9}, {3.479661508025606*^9, 3.47966151197128*^9}, {
   3.4796618227781982`*^9, 3.4796618235292788`*^9}, 3.479666675846568*^9, {
   3.4796867202542863`*^9, 3.479686720274315*^9}, {3.4796868616776433`*^9, 
   3.479686861938018*^9}, 3.480705278835781*^9, 3.4941093719059157`*^9, {
   3.494111977016321*^9, 3.4941119773283215`*^9}, {3.494112096481331*^9, 
   3.494112145325017*^9}, {3.4941123915090494`*^9, 3.49411239191465*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"ArcCoth", "[", 
     RowBox[{"a_", "+", 
      RowBox[{"b_.", "*", "x_"}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "/", "b"}]}], " ", "+", " ", 
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", "b"}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494109908110058*^9, 3.4941099093268595`*^9}, 
   3.49411043303938*^9, 3.494110873053753*^9, {3.4941120188555946`*^9, 
   3.494112019183195*^9}, {3.4941122005335135`*^9, 3.494112205135522*^9}, {
   3.4941123936150527`*^9, 3.4941123947382545`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: CRC 586, A&S 4.6.48", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4940991200114183`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalQ]"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070527384861*^9, 3.4941102884231253`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"ArcCoth", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "x"}]}], " ", 
    RowBox[{"ArcCoth", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}]}]}], "-", 
  RowBox[{"b", " ", "n", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox["x", "n"], 
      RowBox[{"1", "-", 
       SuperscriptBox["a", "2"], "-", 
       RowBox[{"2", " ", "a", " ", "b", " ", 
        SuperscriptBox["x", "n"]}], "-", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", 
        SuperscriptBox["x", 
         RowBox[{"2", " ", "n"}]]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579729524207`*^9, 3.479658002354699*^9}, {
   3.479658032958706*^9, 3.479658033819944*^9}, {3.479658266604672*^9, 
   3.479658270990979*^9}, 3.4796611918409553`*^9, {3.4796613913478317`*^9, 
   3.47966140315481*^9}, {3.479661508025606*^9, 3.47966151197128*^9}, {
   3.4796618227781982`*^9, 3.4796618235292788`*^9}, 3.479666675846568*^9, {
   3.4796867202542863`*^9, 3.479686720274315*^9}, {3.4796868616776433`*^9, 
   3.479686861938018*^9}, 3.480705278835781*^9, {3.4937667186158357`*^9, 
   3.4937667186158357`*^9}, 3.494110276832305*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"ArcCoth", "[", 
     RowBox[{"a_", "+", 
      RowBox[{"b_.", "*", 
       RowBox[{"x_", "^", "n_"}]}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"x", "^", "n"}]}]}], "]"}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", "n"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "n"}], "/", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"2", "*", "a", "*", "b", "*", 
            RowBox[{"x", "^", "n"}]}], "-", 
           RowBox[{
            RowBox[{"b", "^", "2"}], "*", 
            RowBox[{"x", "^", 
             RowBox[{"(", 
              RowBox[{"2", "*", "n"}], ")"}]}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4937667186258354`*^9, 3.4937667186258354`*^9}, {
   3.4941105094171143`*^9, 3.4941105234415393`*^9}, 3.49411087664176*^9, 
   3.4941124146282897`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   RowBox[{"ArcCoth", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796867203043585`*^9, {3.4928222468993263`*^9, 3.492822253420138*^9}, {
   3.4928256632301292`*^9, 3.4928256645561314`*^9}, 3.4937667186358356`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"ArcCoth", "[", "z", "]"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       FractionBox["1", "z"]}], "]"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", 
       FractionBox["1", "z"]}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664431619528*^9, 3.4796644842351856`*^9, {3.4796867203243876`*^9, 
   3.4796867203243876`*^9}, {3.479686900964134*^9, 3.479686904699506*^9}, {
   3.493766716975833*^9, 3.493766716975833*^9}, {3.493767547466996*^9, 
   3.493767553017004*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050798897104`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], "]"}], "x"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "2"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{"Log", "[", 
        RowBox[{"1", "+", 
         FractionBox["1", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}]}]]}], "]"}], "x"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"Log", "[", 
       RowBox[{"1", "-", 
        FractionBox["1", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", "n"]}]}]]}], "]"}], "x"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579730125074`*^9, 3.479658002374728*^9}, 
   3.479658039448037*^9, 3.479661193793763*^9, {3.4796615158368387`*^9, 
   3.479661531599504*^9}, 3.4796867203243876`*^9, {3.4796869232261457`*^9, 
   3.4796869451176243`*^9}, 3.4937667186558356`*^9, {3.4937783549672775`*^9, 
   3.4937783809873133`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], "]"}], "/", "x_"}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"1", "+", 
           RowBox[{"1", "/", 
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", 
               RowBox[{"x", "^", "n"}]}]}], ")"}]}]}], "]"}], "/", "x"}], ",",
         "x"}], "]"}]}], "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"1", "-", 
           RowBox[{"1", "/", 
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", 
               RowBox[{"x", "^", "n"}]}]}], ")"}]}]}], "]"}], "/", "x"}], ",",
         "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{
  3.4937667186558356`*^9, {3.4937783958873343`*^9, 3.4937784079173512`*^9}, 
   3.494110547465581*^9, 3.494111558935587*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: CRC 590, A&S 4.6.60", "Subsubsection",
 CellChangeTimes->{
  3.479686957936056*^9, {3.49377874991783*^9, 3.493778751777833*^9}, {
   3.4937788801180124`*^9, 3.493778881218014*^9}}],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{
     RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "+", "1"}], "\[NotEqual]", "n"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.480705286316538*^9, {3.4941088512110004`*^9, 3.494108875297443*^9}, {
   3.4941089257323313`*^9, 3.494108953812381*^9}, {3.494109011158081*^9, 
   3.4941090265241084`*^9}, {3.4941099489353294`*^9, 3.494109954473339*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"ArcCoth", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        RowBox[{"ArcCoth", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", "n"]}]}], "]"}]}], 
       RowBox[{"m", "+", "1"}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"b", " ", "n"}], 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox["x", 
       RowBox[{"m", "+", "n"}]], 
      RowBox[{"1", "-", 
       SuperscriptBox["a", "2"], "-", 
       RowBox[{"2", " ", "a", " ", "b", " ", 
        SuperscriptBox["x", "n"]}], "-", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", 
        SuperscriptBox["x", 
         RowBox[{"2", " ", "n"}]]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.47965797304255*^9, 3.4796580023847427`*^9}, {
   3.479658043163379*^9, 3.47965804398456*^9}, 3.479658468995696*^9, {
   3.479658610368981*^9, 3.479658625961402*^9}, {3.479661193843835*^9, 
   3.4796612201817074`*^9}, {3.47966139238933*^9, 3.479661423644272*^9}, {
   3.479661536146042*^9, 3.4796615416739902`*^9}, 3.4796617640337276`*^9, 
   3.4796618325222096`*^9, 3.4796668662303267`*^9, {3.4796867203344016`*^9, 
   3.4796867203344016`*^9}, {3.4796869701135664`*^9, 3.4796869707144303`*^9}, 
   3.480705289451045*^9, {3.4937667186758356`*^9, 3.4937667186758356`*^9}, 
   3.494110649598961*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"x", "^", "n"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", 
       RowBox[{"n", "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "n"}], ")"}]}], "/", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"2", "*", "a", "*", "b", "*", 
            RowBox[{"x", "^", "n"}]}], "-", 
           RowBox[{
            RowBox[{"b", "^", "2"}], "*", 
            RowBox[{"x", "^", 
             RowBox[{"(", 
              RowBox[{"2", "*", "n"}], ")"}]}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"m", "+", "1"}], "\[NotEqual]", "n"}]}]}]}]], "Code",
 CellChangeTimes->{{3.493766718685836*^9, 3.493766718685836*^9}, 
   3.4941106288665247`*^9, 3.4941106719694*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"ArcCoth", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, 
   3.4937667184558353`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by substitution", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.49283103988311*^9, 3.492831064713145*^9}, {3.4928318015941763`*^9, 
   3.492831805684182*^9}, {3.494096886328291*^9, 3.4940968902482967`*^9}, {
   3.494105511315132*^9, 3.494105511315132*^9}, {3.4941056617845974`*^9, 
   3.4941056617845974`*^9}, {3.494110963877113*^9, 3.494110963877113*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"ArcCoth", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "b"]}]}], " ", 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"ArcCoth", "[", "x", "]"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732428384`*^9, 3.479658002484886*^9}, {
   3.4796580646743107`*^9, 3.479658065695779*^9}, 3.4796611938939075`*^9, {
   3.4796867205046463`*^9, 3.479686740233014*^9}, 3.479694163016453*^9, 
   3.479694241058672*^9, {3.4928308514228463`*^9, 3.4928309174229383`*^9}, {
   3.4928311838033113`*^9, 3.4928311994833336`*^9}, 3.492831236813386*^9, {
   3.494096850808242*^9, 3.4940968754382763`*^9}, {3.4940991931415205`*^9, 
   3.4940991935915213`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_."}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", "b"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"ArcCoth", "[", "x", "]"}], "^", "n"}], ",", "x"}], "]"}], 
       ",", "x", ",", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4928312031533384`*^9, 3.4928312054633417`*^9}, {
  3.4940968956183043`*^9, 3.494096916128333*^9}, {3.494099194101522*^9, 
  3.4940991951915236`*^9}, {3.4941054454362164`*^9, 3.4941054487434225`*^9}, {
  3.494110953113094*^9, 3.494110953378294*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"ArcCoth", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.492802747642827*^9, 
   3.492802751137233*^9}, 3.4928222777249804`*^9, 3.492825819138003*^9, 
   3.493766718515836*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by substitution", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"m", ">", "0"}], " ", "\[And]", " ", 
    RowBox[{"n", ">", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.49283103988311*^9, 3.492831064713145*^9}, {3.4928318015941763`*^9, 
   3.492831805684182*^9}, {3.494105500395113*^9, 3.4941055043731203`*^9}, {
   3.494110987339554*^9, 3.494110987339554*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"ArcCoth", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      SuperscriptBox["b", 
       RowBox[{"m", "+", "1"}]]]}]}], " ", 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "-", "a"}], ")"}], "m"], " ", 
       SuperscriptBox[
        RowBox[{"ArcCoth", "[", "x", "]"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732428384`*^9, 3.479658002484886*^9}, {
   3.4796580646743107`*^9, 3.479658065695779*^9}, 3.4796611938939075`*^9, {
   3.4796867205046463`*^9, 3.479686740233014*^9}, 3.479694163016453*^9, 
   3.479694241058672*^9, {3.4928308514228463`*^9, 3.4928309174229383`*^9}, {
   3.4928311838033113`*^9, 3.4928311994833336`*^9}, 3.492831236813386*^9, {
   3.4937667185258355`*^9, 3.4937667185258355`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"b", "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"x", "-", "a"}], ")"}], "^", "m"}], "*", 
          RowBox[{
           RowBox[{"ArcCoth", "[", "x", "]"}], "^", "n"}]}], ",", "x"}], 
        "]"}], ",", "x", ",", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4928312031533384`*^9, 3.4928312054633417`*^9}, {
   3.4937667185358353`*^9, 3.4937667185358353`*^9}, {3.494105465092251*^9, 
   3.4941054954031043`*^9}, {3.494110984578349*^9, 3.4941110005683775`*^9}, 
   3.5171886223886623`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"ArcCoth", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "n"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, 3.4802882652733135`*^9, 3.480288373839424*^9, {
   3.480299236238787*^9, 3.480299238211624*^9}, {3.4803010920372944`*^9, 
   3.480301103143264*^9}, {3.4928037993654737`*^9, 3.49280383115833*^9}, 
   3.4928257757543263`*^9, 3.4937667185458355`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"ArcCoth", "[", "z", "]"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       FractionBox["1", "z"]}], "]"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", 
       FractionBox["1", "z"]}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664431619528*^9, 3.4796644842351856`*^9, {3.4796867203243876`*^9, 
   3.4796867203243876`*^9}, {3.479686900964134*^9, 3.479686904699506*^9}, {
   3.493766716975833*^9, 3.493766716975833*^9}, {3.493767547466996*^9, 
   3.493767553017004*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{"n", "=", 
      RowBox[{
       RowBox[{"2", "\[And]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "c"}], "+", "d"}]}], "=", "0"}]}], 
     ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055445578704`*^9, 3.49282853967961*^9, {3.4928286506197653`*^9, 
   3.4928286988398323`*^9}, {3.493751094490037*^9, 3.4937510948176374`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"ArcCoth", "[", 
      RowBox[{"b", " ", "x"}], "]"}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "n"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "2"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{"Log", "[", 
        RowBox[{"1", "+", 
         FractionBox["1", 
          RowBox[{"b", " ", "x"}]]}], "]"}], 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "n"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"Log", "[", 
       RowBox[{"1", "-", 
        FractionBox["1", 
         RowBox[{"b", " ", "x"}]]}], "]"}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "n"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732428384`*^9, 3.479658002484886*^9}, {
   3.4796580646743107`*^9, 3.479658065695779*^9}, 3.4796611938939075`*^9, {
   3.4796867205046463`*^9, 3.479686740233014*^9}, 3.479694163016453*^9, 
   3.479694241058672*^9, {3.4928288741700783`*^9, 3.4928289166801376`*^9}, {
   3.492828963480203*^9, 3.4928290377203074`*^9}, 3.492829172840496*^9, 
   3.4937667185558357`*^9, {3.4937780410368376`*^9, 3.4937780615168667`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ArcCoth", "[", 
      RowBox[{"b_.", "*", "x_"}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"c_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"1", "+", 
           RowBox[{"1", "/", 
            RowBox[{"(", 
             RowBox[{"b", "*", "x"}], ")"}]}]}], "]"}], "/", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", 
            RowBox[{"x", "^", "n"}]}]}], ")"}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"1", "-", 
           RowBox[{"1", "/", 
            RowBox[{"(", 
             RowBox[{"b", "*", "x"}], ")"}]}]}], "]"}], "/", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", 
            RowBox[{"x", "^", "n"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"n", "==", "2"}], " ", "&&", " ", 
      RowBox[{"ZeroQ", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", "c"}], "+", "d"}], "]"}]}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{
  3.493766718565836*^9, {3.4937781386769743`*^9, 3.493778149126989*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"ArcCoth", "[", "z", "]"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       FractionBox["1", "z"]}], "]"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", 
       FractionBox["1", "z"]}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664431619528*^9, 3.4796644842351856`*^9, {3.4796867203243876`*^9, 
   3.4796867203243876`*^9}, {3.479686900964134*^9, 3.479686904699506*^9}, {
   3.493766716975833*^9, 3.493766716975833*^9}, {3.493767547466996*^9, 
   3.493767553017004*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{"n", "=", 
      RowBox[{
       RowBox[{"1", "\[And]", 
        RowBox[{
         RowBox[{"a", " ", "d"}], "-", 
         RowBox[{"b", " ", "c"}]}]}], "=", "0"}]}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055445578704`*^9, 3.49282853967961*^9, {3.4928286506197653`*^9, 
   3.4928286988398323`*^9}, {3.492828783319951*^9, 3.492828794439966*^9}, {
   3.4937511084520617`*^9, 3.4937511087484617`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "n"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "2"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{"Log", "[", 
        RowBox[{"1", "+", 
         FractionBox["1", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}]]}], "]"}], 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "n"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"Log", "[", 
       RowBox[{"1", "-", 
        FractionBox["1", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}]]}], "]"}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "n"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732428384`*^9, 3.479658002484886*^9}, {
   3.4796580646743107`*^9, 3.479658065695779*^9}, 3.4796611938939075`*^9, {
   3.4796867205046463`*^9, 3.479686740233014*^9}, 3.479694163016453*^9, 
   3.479694241058672*^9, {3.4928288741700783`*^9, 3.4928289166801376`*^9}, {
   3.492828963480203*^9, 3.4928290377203074`*^9}, {3.4928290833603706`*^9, 
   3.4928291010103955`*^9}, 3.492829178180504*^9, 3.4937667185858355`*^9, {
   3.493778181417034*^9, 3.493778204597067*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"c_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"1", "+", 
           RowBox[{"1", "/", 
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", "x"}]}], ")"}]}]}], "]"}], "/", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", 
            RowBox[{"x", "^", "n"}]}]}], ")"}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"1", "-", 
           RowBox[{"1", "/", 
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", "x"}]}], ")"}]}]}], "]"}], "/", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", 
            RowBox[{"x", "^", "n"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"n", "==", "1"}], " ", "&&", " ", 
      RowBox[{"ZeroQ", "[", 
       RowBox[{
        RowBox[{"a", "*", "d"}], "-", 
        RowBox[{"b", "*", "c"}]}], "]"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{
  3.4937667185958357`*^9, {3.4937782301571026`*^9, 3.493778240907118*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox[
    RowBox[{"ArcCoth", "[", 
     FractionBox["c", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}]], "]"}], "m"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.479616049603877*^9, {3.479616359880032*^9, 3.479616363935864*^9}, 
   3.47968672044456*^9, 3.4928223678463387`*^9, 3.4928258146763945`*^9, 
   3.4937667186958356`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"ArcCoth", "[", "z", "]"}], "=", 
   RowBox[{"ArcTanh", "[", 
    FractionBox["1", "z"], "]"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664443126074*^9, 3.479664484795992*^9, {3.479686720494632*^9, 
   3.479686740223*^9}, {3.4937667187058353`*^9, 3.4937667187058353`*^9}, {
   3.493779234988509*^9, 3.4937792368085117`*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807051268772755`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox[
    RowBox[{"ArcCoth", "[", 
     FractionBox["c", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}]], "]"}], "m"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{"u", " ", 
       SuperscriptBox[
        RowBox[{"ArcTanh", "[", 
         RowBox[{
          FractionBox["a", "c"], "+", 
          FractionBox[
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}], "c"]}], "]"}], "m"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732428384`*^9, 3.479658002484886*^9}, {
   3.4796580646743107`*^9, 3.479658065695779*^9}, 3.4796611938939075`*^9, {
   3.4796867205046463`*^9, 3.479686740233014*^9}, 3.479694163016453*^9, 
   3.479694241058672*^9, {3.4928308514228463`*^9, 3.4928309174229383`*^9}, {
   3.4928311838033113`*^9, 3.4928311994833336`*^9}, 3.492831236813386*^9, {
   3.493250536928784*^9, 3.4932505561012177`*^9}, 3.4937667187158356`*^9, {
   3.493779227678499*^9, 3.493779230178502*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"c_.", "/", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", 
           RowBox[{"x_", "^", "n_."}]}]}], ")"}]}], "]"}], "^", "m_."}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"u", "*", 
      RowBox[{
       RowBox[{"ArcTanh", "[", 
        RowBox[{
         RowBox[{"a", "/", "c"}], "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"x", "^", "n"}], "/", "c"}]}]}], "]"}], "^", "m"}]}], ",", 
     "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "n", ",", "m"}], "}"}], ",", 
     "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{
  3.4937667187158356`*^9, {3.4937792645185504`*^9, 3.4937792660085526`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"f", "[", 
     RowBox[{"x", ",", 
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}]}], "]"}], 
    RowBox[{"1", "-", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "2"]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.479616049603877*^9, {3.479616359880032*^9, 3.479616363935864*^9}, 
   3.47968672044456*^9, 3.4796940040278387`*^9, 3.492822371293945*^9, 
   3.492825811400389*^9, 3.493766718725836*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by substitution", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"f", "[", "z", "]"}], 
    RowBox[{"1", "-", 
     SuperscriptBox["z", "2"]}]], "=", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"Coth", "[", 
      RowBox[{"ArcCoth", "[", "z", "]"}], "]"}], "]"}], " ", 
    RowBox[{
     SuperscriptBox["ArcCoth", "\[Prime]",
      MultilineFunction->None], "[", "z", "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4796941282865133`*^9, {3.4799455651493073`*^9, 3.4799455651493073`*^9}, {
   3.493766718735836*^9, 3.493766718735836*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"r", "+", 
    RowBox[{"s", " ", "x"}], "+", 
    RowBox[{"t", " ", 
     SuperscriptBox["x", "2"]}]}], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       SuperscriptBox["s", "2"], "-", 
       RowBox[{"4", " ", "r", " ", "t"}]}], 
      RowBox[{"4", " ", "t"}]]}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"s", "+", 
          RowBox[{"2", " ", "t", " ", "x"}]}], ")"}], "2"], 
       RowBox[{
        SuperscriptBox["s", "2"], "-", 
        RowBox[{"4", " ", "r", " ", "t"}]}]]}], ")"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4796941282865133`*^9, {3.4799455651493073`*^9, 3.4799455651493073`*^9}, {
   3.492803054651366*^9, 3.492803093277034*^9}, 3.4928031261930914`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"1", "-", 
    SuperscriptBox[
     RowBox[{"Coth", "[", "z", "]"}], "2"]}], "=", 
   RowBox[{"-", 
    SuperscriptBox[
     RowBox[{"Csch", "[", "z", "]"}], "2"]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4796941282865133`*^9, {3.4799455651493073`*^9, 3.4799455651493073`*^9}, {
   3.492803054651366*^9, 3.492803093277034*^9}, {3.4928031381427126`*^9, 
   3.4928031451783247`*^9}, {3.493766718745836*^9, 3.493766718745836*^9}, {
   3.4937770263554173`*^9, 3.4937770294254217`*^9}, {3.493779316668624*^9, 
   3.49377934988867*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.480705133626981*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"f", "[", 
     RowBox[{"x", ",", 
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}]}], "]"}], 
    RowBox[{"1", "-", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "2"]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "b"]}]}], " ", 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           FractionBox["a", "b"]}], "+", 
          FractionBox[
           RowBox[{"Coth", "[", "x", "]"}], "b"]}], ",", "x"}], "]"}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"ArcCoth", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732428384`*^9, 3.479658002484886*^9}, {
   3.4796580646743107`*^9, 3.479658065695779*^9}, 3.4796611938939075`*^9, {
   3.4796867205046463`*^9, 3.479686740233014*^9}, 3.479694163016453*^9, 
   3.479694241058672*^9, {3.4937667187558355`*^9, 3.4937667187558355`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"u_", "*", 
       RowBox[{"v_", "^", "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", 
    "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"tmp", "=", 
         RowBox[{"InverseFunctionOfLinear", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"ShowStep", "[", 
         RowBox[{
         "\"\<\>\"", ",", "\"\<Int[f[x,ArcCoth[a+b*x]]/(1-(a+b*x)^2),x]\>\"", 
          ",", "\n", "\t\t   ", 
          "\"\<Subst[Int[f[-a/b+Coth[x]/b,x],x],x,ArcCoth[a+b*x]]/b\>\"", ",", 
          RowBox[{"Hold", "[", "\n", "  ", 
           RowBox[{"Dist", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  RowBox[{"Discriminant", "[", 
                   RowBox[{"v", ",", "x"}], "]"}]}], "/", 
                 RowBox[{"(", 
                  RowBox[{"4", "*", 
                   RowBox[{"Coefficient", "[", 
                    RowBox[{"v", ",", "x", ",", "2"}], "]"}]}], ")"}]}], 
                ")"}], "^", "n"}], "/", 
              RowBox[{"Coefficient", "[", 
               RowBox[{
                RowBox[{"tmp", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], ",", "x", ",", "1"}], 
               "]"}]}], ",", "\n", "\t", 
             RowBox[{"Subst", "[", 
              RowBox[{
               RowBox[{"Int", "[", 
                RowBox[{
                 RowBox[{"Regularize", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"SubstForInverseFunction", "[", 
                    RowBox[{"u", ",", "tmp", ",", "x"}], "]"}], "*", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"-", 
                    RowBox[{
                    RowBox[{"Csch", "[", "x", "]"}], "^", "2"}]}], ")"}], "^", 
                    RowBox[{"(", 
                    RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}], 
                 ",", "x"}], "]"}], ",", " ", "x", ",", " ", "tmp"}], "]"}]}],
             "]"}], "]"}]}], "]"}], " ", "/;", "\n", " ", 
        RowBox[{
         RowBox[{"NotFalseQ", "[", "tmp", "]"}], " ", "&&", " ", 
         RowBox[{
          RowBox[{"Head", "[", "tmp", "]"}], "===", "ArcCoth"}], " ", "&&", 
         " ", 
         RowBox[{"ZeroQ", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Discriminant", "[", 
             RowBox[{"v", ",", "x"}], "]"}], "*", 
            RowBox[{
             RowBox[{"tmp", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "^", "2"}]}], "-", 
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{"v", ",", "x"}], "]"}], "^", "2"}]}], "]"}]}]}]}], "]"}],
      " ", "/;", "\n", 
     RowBox[{"SimplifyFlag", " ", "&&", " ", 
      RowBox[{"QuadraticQ", "[", 
       RowBox[{"v", ",", "x"}], "]"}], " ", "&&", " ", 
      RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
      RowBox[{"n", "<", "0"}], " ", "&&", " ", 
      RowBox[{"PosQ", "[", 
       RowBox[{"Discriminant", "[", 
        RowBox[{"v", ",", "x"}], "]"}], "]"}], " ", "&&", " ", 
      RowBox[{"MatchQ", "[", 
       RowBox[{"u", ",", 
        RowBox[{
         RowBox[{"r_.", "*", 
          RowBox[{"f_", "^", "w_"}]}], " ", "/;", " ", 
         RowBox[{"FreeQ", "[", 
          RowBox[{"f", ",", "x"}], "]"}]}]}], "]"}]}]}]}], ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"u_", "*", 
       RowBox[{"v_", "^", "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", 
    "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"tmp", "=", 
         RowBox[{"InverseFunctionOfLinear", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"Dist", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"Discriminant", "[", 
                RowBox[{"v", ",", "x"}], "]"}]}], "/", 
              RowBox[{"(", 
               RowBox[{"4", "*", 
                RowBox[{"Coefficient", "[", 
                 RowBox[{"v", ",", "x", ",", "2"}], "]"}]}], ")"}]}], ")"}], 
            "^", "n"}], "/", 
           RowBox[{"Coefficient", "[", 
            RowBox[{
             RowBox[{"tmp", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", "x", ",", "1"}], "]"}]}], 
          ",", "\n", "\t", 
          RowBox[{"Subst", "[", 
           RowBox[{
            RowBox[{"Int", "[", 
             RowBox[{
              RowBox[{"Regularize", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"SubstForInverseFunction", "[", 
                  RowBox[{"u", ",", "tmp", ",", "x"}], "]"}], "*", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"-", 
                    RowBox[{
                    RowBox[{"Csch", "[", "x", "]"}], "^", "2"}]}], ")"}], "^", 
                  RowBox[{"(", 
                   RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}], ",",
               "x"}], "]"}], ",", " ", "x", ",", " ", "tmp"}], "]"}]}], "]"}],
         " ", "/;", "\n", " ", 
        RowBox[{
         RowBox[{"NotFalseQ", "[", "tmp", "]"}], " ", "&&", " ", 
         RowBox[{
          RowBox[{"Head", "[", "tmp", "]"}], "===", "ArcCoth"}], " ", "&&", 
         " ", 
         RowBox[{"ZeroQ", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Discriminant", "[", 
             RowBox[{"v", ",", "x"}], "]"}], "*", 
            RowBox[{
             RowBox[{"tmp", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "^", "2"}]}], "-", 
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{"v", ",", "x"}], "]"}], "^", "2"}]}], "]"}]}]}]}], "]"}],
      " ", "/;", "\n", 
     RowBox[{
      RowBox[{"QuadraticQ", "[", 
       RowBox[{"v", ",", "x"}], "]"}], " ", "&&", " ", 
      RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
      RowBox[{"n", "<", "0"}], " ", "&&", " ", 
      RowBox[{"PosQ", "[", 
       RowBox[{"Discriminant", "[", 
        RowBox[{"v", ",", "x"}], "]"}], "]"}], " ", "&&", " ", 
      RowBox[{"MatchQ", "[", 
       RowBox[{"u", ",", 
        RowBox[{
         RowBox[{"r_.", "*", 
          RowBox[{"f_", "^", "w_"}]}], " ", "/;", " ", 
         RowBox[{"FreeQ", "[", 
          RowBox[{"f", ",", "x"}], "]"}]}]}], "]"}]}]}]}]}], "]"}]], "Code",
 CellChangeTimes->{{3.493779624469054*^9, 3.493779669759118*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"n", " ", 
     RowBox[{"ArcCoth", "[", "v", "]"}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.479616049603877*^9, {3.479616359880032*^9, 3.479616363935864*^9}, 
   3.47968672044456*^9, 3.479691629904016*^9, 3.4928258059403796`*^9, 
   3.4937667187958355`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{
   FractionBox["n", "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"n", " ", 
     RowBox[{"ArcCoth", "[", "z", "]"}]}]], "=", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "z"}], ")"}], 
     RowBox[{"n", "/", "2"}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "z"}], ")"}], 
     RowBox[{"n", "/", "2"}]]]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479691863570011*^9, 3.479691931137168*^9, {3.4937667188058357`*^9, 
   3.4937667188058357`*^9}, {3.4937798857994204`*^9, 
   3.4937798965894356`*^9}, {3.493846092614684*^9, 3.493846127424732*^9}}],

Cell[TextData[{
 "Rule: If ",
 Cell[BoxData[
  RowBox[{
   FractionBox["n", "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807053790799246`*^9, 3.4938461312747383`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"n", " ", 
     RowBox[{"ArcCoth", "[", "v", "]"}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox[
        RowBox[{"u", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", "v"}], ")"}], 
          RowBox[{"n", "/", "2"}]]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "v"}], ")"}], 
         RowBox[{"n", "/", "2"}]]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796917199334717`*^9, 3.479691773630685*^9}, {
   3.47969236314837*^9, 3.4796923678050656`*^9}, 3.4796927595483646`*^9, {
   3.4796928103113585`*^9, 3.47969282922856*^9}, {3.4796928900259824`*^9, 
   3.4796928913578978`*^9}, 3.4807053815234385`*^9, 3.493766718815836*^9, {
   3.4937799531595144`*^9, 3.4937799681595354`*^9}, {3.4938462008948355`*^9, 
   3.493846216924858*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{"E", "^", 
      RowBox[{"(", 
       RowBox[{"n_.", "*", 
        RowBox[{"ArcCoth", "[", "v_", "]"}]}], ")"}]}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"u", "*", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "v"}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"n", "/", "2"}], ")"}]}], "/", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "v"}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"n", "/", "2"}], ")"}]}]}]}], ",", "x"}], "]"}], " ", "/;", 
   "\n", 
   RowBox[{"EvenQ", "[", "n", "]"}]}]}]], "Code",
 CellChangeTimes->{
  3.493766718825836*^9, {3.4937799755095463`*^9, 3.4937799792795515`*^9}, 
   3.493846187544817*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796932346515293`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"n", " ", 
     RowBox[{"ArcCoth", "[", "z", "]"}]}]], "=", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      FractionBox["1", 
       SqrtBox[
        RowBox[{"1", "-", 
         FractionBox["1", 
          SuperscriptBox["z", "2"]]}]]], "+", 
      FractionBox["1", 
       RowBox[{"z", " ", 
        SqrtBox[
         RowBox[{"1", "-", 
          FractionBox["1", 
           SuperscriptBox["z", "2"]]}]]}]]}], ")"}], "n"]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479691863570011*^9, 3.479691931137168*^9, {3.4937667188058357`*^9, 
   3.4937667188058357`*^9}, {3.4937798857994204`*^9, 
   3.4937798965894356`*^9}, {3.49384644698518*^9, 3.49384644698518*^9}, {
   3.493846709945548*^9, 3.493846709945548*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"n", "-", "1"}], "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.480705387221632*^9, {3.4938464803652267`*^9, 3.4938464897852397`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"n", " ", 
     RowBox[{"ArcCoth", "[", "v", "]"}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox["1", 
           SqrtBox[
            RowBox[{"1", "-", 
             FractionBox["1", 
              SuperscriptBox["v", "2"]]}]]], "+", 
          FractionBox["1", 
           RowBox[{"x", " ", 
            SqrtBox[
             RowBox[{"1", "-", 
              FractionBox["1", 
               SuperscriptBox["v", "2"]]}]]}]]}], ")"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796917210550847`*^9, 3.479691774171462*^9}, {
   3.47969221768921*^9, 3.4796922222357473`*^9}, 3.4796927603194733`*^9, {
   3.4796928116132307`*^9, 3.4796928349267535`*^9}, 3.4796928967055874`*^9, 
   3.48070538951493*^9, 3.4937667188458357`*^9, {3.493780008919593*^9, 
   3.49378002115961*^9}, 3.493846424935149*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"E", "^", 
     RowBox[{"(", 
      RowBox[{"n_.", "*", 
       RowBox[{"ArcCoth", "[", "v_", "]"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"1", "/", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"1", "-", 
            RowBox[{"1", "/", 
             RowBox[{"v", "^", "2"}]}]}], "]"}]}], " ", "+", " ", 
         RowBox[{"1", "/", 
          RowBox[{"(", 
           RowBox[{"x", "*", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"1", "-", 
              RowBox[{"1", "/", 
               RowBox[{"v", "^", "2"}]}]}], "]"}]}], ")"}]}]}], ")"}], "^", 
       "n"}], "]"}], ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{"OddQ", "[", "n", "]"}]}]}]], "Code",
 CellChangeTimes->{
  3.493766718855836*^9, {3.493780039809636*^9, 3.4937800432096405`*^9}, 
   3.493846356435053*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796932346515293`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{{3.493780071909681*^9, 3.493780073269683*^9}, {
  3.4938467165355573`*^9, 3.493846717305558*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"n", " ", 
     RowBox[{"ArcCoth", "[", "z", "]"}]}]], "=", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      FractionBox["1", 
       SqrtBox[
        RowBox[{"1", "-", 
         FractionBox["1", 
          SuperscriptBox["z", "2"]]}]]], "+", 
      FractionBox["1", 
       RowBox[{"z", " ", 
        SqrtBox[
         RowBox[{"1", "-", 
          FractionBox["1", 
           SuperscriptBox["z", "2"]]}]]}]]}], ")"}], "n"]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479691871501416*^9, 3.4796919322788095`*^9, {3.493766718865836*^9, 
   3.493766718865836*^9}, {3.49384669673553*^9, 3.493846706505543*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", " ", 
   RowBox[{
    FractionBox[
     RowBox[{"n", "-", "1"}], "2"], "\[Element]", 
    "\[DoubleStruckCapitalZ]"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807054045565586`*^9, 3.480705417234789*^9}, {3.4938467605656185`*^9, 
   3.4938467652556257`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"n", " ", 
     RowBox[{"ArcCoth", "[", "v", "]"}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox["x", "m"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox["1", 
           SqrtBox[
            RowBox[{"1", "-", 
             FractionBox["1", 
              SuperscriptBox["v", "2"]]}]]], "+", 
          FractionBox["1", 
           RowBox[{"x", " ", 
            SqrtBox[
             RowBox[{"1", "-", 
              FractionBox["1", 
               SuperscriptBox["v", "2"]]}]]}]]}], ")"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796917216960063`*^9, 3.479691774231549*^9}, {
   3.4796923906078544`*^9, 3.479692416084488*^9}, {3.4796927607701216`*^9, 
   3.4796928421371217`*^9}, 3.4796928983179054`*^9, 3.4796931033126736`*^9, 
   3.479693145283024*^9, {3.4796931984494734`*^9, 3.479693210827272*^9}, 
   3.4807054266182814`*^9, 3.493766718875836*^9, 3.493846805755682*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"E", "^", 
      RowBox[{"(", 
       RowBox[{"n_.", "*", 
        RowBox[{"ArcCoth", "[", "v_", "]"}]}], ")"}]}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"x", "^", "m"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"1", "/", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"1", "-", 
             RowBox[{"1", "/", 
              RowBox[{"v", "^", "2"}]}]}], "]"}]}], " ", "+", " ", 
          RowBox[{"1", "/", 
           RowBox[{"(", 
            RowBox[{"x", "*", 
             RowBox[{"Sqrt", "[", 
              RowBox[{"1", "-", 
               RowBox[{"1", "/", 
                RowBox[{"v", "^", "2"}]}]}], "]"}]}], ")"}]}]}], ")"}], "^", 
        "n"}]}], "]"}], ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"OddQ", "[", "n", "]"}]}]}]}]], "Code",
 CellChangeTimes->{3.4937667188858356`*^9, 3.493846659425477*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796932346515293`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{{3.493846937255866*^9, 3.493846945485878*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807054353007665`*^9, 3.4938469615459003`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], "/", "2"}]], " ", 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "x"}]}], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], "/", "2"}]]}]}], "-", 
  RowBox[{
   FractionBox["b", "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"x", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"ArcCoth", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], "/", "2"}]]}], 
      RowBox[{"1", "-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "2"]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796917222768416`*^9, 3.479691774261592*^9}, {
   3.4796924406097536`*^9, 3.479692445126248*^9}, {3.47969249049148*^9, 
   3.4796924960094147`*^9}, 3.47969259154679*^9, {3.4796927611807117`*^9, 
   3.479692812774901*^9}, {3.4796928477752285`*^9, 3.4796928500685263`*^9}, 
   3.479692900881592*^9, {3.4796931059264317`*^9, 3.4796931079994125`*^9}, 
   3.479693147466163*^9, 3.479693333673917*^9, 3.480705437794352*^9, 
   3.493766718905836*^9, {3.4938469696159115`*^9, 3.493847003405959*^9}, {
   3.4938470968560896`*^9, 3.493847127716133*^9}, {3.493847158586176*^9, 
   3.493847194266226*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"E", "^", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", "x_"}]}], "]"}], "/", "2"}], ")"}]}], ",", " ", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{"E", "^", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"ArcCoth", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], "]"}], "/", "2"}], ")"}]}]}], " ", "-", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"x", "*", 
         RowBox[{
          RowBox[{"E", "^", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"ArcCoth", "[", 
              RowBox[{"a", "+", 
               RowBox[{"b", "*", "x"}]}], "]"}], "/", "2"}], ")"}]}], "/", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"a", "+", 
               RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}]}], ")"}]}]}], ",",
         "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{3.4937667189158363`*^9, 3.4938470196159816`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796932346515293`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{{3.493846937255866*^9, 3.493846945485878*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"m", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807054045565586`*^9, 3.480705417234789*^9}, {3.4938467605656185`*^9, 
   3.4938467652556257`*^9}, {3.4938481611275797`*^9, 3.4938481693875914`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"ArcCoth", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], "/", "2"}]], " ", 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"ArcCoth", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}], "]"}], "/", "2"}]]}], 
       RowBox[{"m", "+", "1"}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox["b", 
    RowBox[{"2", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"m", "+", "1"}]], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"ArcCoth", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], "/", "2"}]]}], 
      RowBox[{"1", "-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "2"]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796917222768416`*^9, 3.479691774261592*^9}, {
   3.4796924406097536`*^9, 3.479692445126248*^9}, {3.47969249049148*^9, 
   3.4796924960094147`*^9}, 3.47969259154679*^9, {3.4796927611807117`*^9, 
   3.479692812774901*^9}, {3.4796928477752285`*^9, 3.4796928500685263`*^9}, 
   3.479692900881592*^9, {3.4796931059264317`*^9, 3.4796931079994125`*^9}, 
   3.479693147466163*^9, 3.479693333673917*^9, 3.480705437794352*^9, 
   3.493766718905836*^9, {3.4938469696159115`*^9, 3.493847003405959*^9}, {
   3.4938470968560896`*^9, 3.493847127716133*^9}, {3.493847158586176*^9, 
   3.493847194266226*^9}, 3.4938472654663258`*^9, {3.4938472961363688`*^9, 
   3.493847382166489*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"E", "^", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"ArcCoth", "[", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], "]"}], "/", "2"}], ")"}]}]}], ",", 
    " ", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"E", "^", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"ArcCoth", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], "]"}], "/", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"E", "^", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"ArcCoth", "[", 
              RowBox[{"a", "+", 
               RowBox[{"b", "*", "x"}]}], "]"}], "/", "2"}], ")"}]}], "/", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"a", "+", 
               RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}]}], ")"}]}]}], ",",
         "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{3.4937667189158363`*^9, 3.4938470196159816`*^9, 
  3.493847276756342*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796932346515293`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"n", "-", "1"}], "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"n", " ", 
      RowBox[{"ArcCoth", "[", "z", "]"}]}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["z", "2"]}], ")"}], "m"]}], "=", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], 
       FractionBox[
        RowBox[{"n", "-", "1"}], "2"]], " ", "z", " ", 
      SqrtBox[
       RowBox[{"1", "-", 
        FractionBox["1", 
         SuperscriptBox["z", "2"]]}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", "z"}], ")"}], 
       RowBox[{"m", "-", 
        FractionBox["n", "2"]}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", "z"}], ")"}], 
       RowBox[{"m", "+", 
        FractionBox["n", "2"]}]]}], 
     SqrtBox[
      RowBox[{"1", "-", 
       SuperscriptBox["z", "2"]}]]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479691863570011*^9, 3.479691931137168*^9, {3.4937667188058357`*^9, 
   3.4937667188058357`*^9}, {3.4937798857994204`*^9, 
   3.4937798965894356`*^9}, {3.493846092614684*^9, 3.493846127424732*^9}, {
   3.4938479953573475`*^9, 3.4938480047473607`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    FractionBox[
     RowBox[{
      RowBox[{"f", "[", "x", "]"}], " ", 
      SqrtBox[
       RowBox[{"a", "-", 
        FractionBox["a", 
         SuperscriptBox[
          RowBox[{"f", "[", "x", "]"}], "2"]]}]]}], 
     SqrtBox[
      RowBox[{"1", "-", 
       SuperscriptBox[
        RowBox[{"f", "[", "x", "]"}], "2"]}]]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4796918758576803`*^9, 3.479691932769515*^9, {3.493766718895836*^9, 
   3.493766718895836*^9}, {3.4938477706470327`*^9, 3.4938477720170345`*^9}, {
   3.493848015387376*^9, 3.49384801848738*^9}}],

Cell[TextData[{
 "Rule: If ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{"n", "-", "1"}], "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}],
    " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"m", "-", 
     FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807054353007665`*^9, 3.493847784137052*^9, 3.4938480568574333`*^9, {
   3.4938482130376525`*^9, 3.4938482496677036`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"n", " ", 
     RowBox[{"ArcCoth", "[", "v", "]"}]}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox["v", "2"]}], ")"}], "m"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         FractionBox[
          RowBox[{"n", "-", "1"}], "2"]], " ", "v", " ", 
        SqrtBox[
         RowBox[{"1", "-", 
          FractionBox["1", 
           SuperscriptBox["v", "2"]]}]]}], 
       SqrtBox[
        RowBox[{"1", "-", 
         SuperscriptBox["v", "2"]}]]]}]}]}], 
   RowBox[{"\[Integral]", " ", 
    RowBox[{"u", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", "v"}], ")"}], 
      RowBox[{"m", "-", 
       FractionBox["n", "2"]}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", "v"}], ")"}], 
      RowBox[{"m", "+", 
       FractionBox["n", "2"]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796917222768416`*^9, 3.479691774261592*^9}, {
   3.4796924406097536`*^9, 3.479692445126248*^9}, {3.47969249049148*^9, 
   3.4796924960094147`*^9}, 3.47969259154679*^9, {3.4796927611807117`*^9, 
   3.479692812774901*^9}, {3.4796928477752285`*^9, 3.4796928500685263`*^9}, 
   3.479692900881592*^9, {3.4796931059264317`*^9, 3.4796931079994125`*^9}, 
   3.479693147466163*^9, 3.479693333673917*^9, 3.480705437794352*^9, 
   3.493766718905836*^9, {3.4938478028470783`*^9, 3.493847810147088*^9}, {
   3.4938483043277802`*^9, 3.493848312867792*^9}, {3.493848387077896*^9, 
   3.4938484013079157`*^9}, {3.4938484715880146`*^9, 3.493848547618121*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{"E", "^", 
      RowBox[{"(", 
       RowBox[{"n_.", "*", 
        RowBox[{"ArcCoth", "[", "v_", "]"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"v_", "^", "2"}]}], ")"}], "^", "m_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}], "/", "2"}], ")"}]}]}], "*", "v", "*", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "-", 
       RowBox[{"1", "/", 
        RowBox[{"v", "^", "2"}]}]}], "]"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "-", 
       RowBox[{"v", "^", "2"}]}], "]"}]}], "*", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"u", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "v"}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"m", "-", 
          RowBox[{"n", "/", "2"}]}], ")"}]}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "v"}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"n", "/", "2"}]}], ")"}]}]}], ",", "x"}], "]"}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"OddQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"m", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{
  3.4937667189158363`*^9, 3.4938478304371166`*^9, 3.493848037667407*^9, {
   3.5158138757957177`*^9, 3.515813881130927*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796932346515293`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"ArcCoth", "[", "z", "]"}]], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox["z", "2"]}], ")"}]}], "=", 
   RowBox[{
    RowBox[{"-", "z"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "z"}], ")"}], " ", 
    SqrtBox[
     RowBox[{"1", "-", 
      FractionBox["1", 
       SuperscriptBox["z", "2"]]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4796918758576803`*^9, 3.479691932769515*^9, {3.493766718895836*^9, 
   3.493766718895836*^9}, {3.4938477706470327`*^9, 3.4938477720170345`*^9}, 
   3.493848651388266*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"m", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807054353007665`*^9, 3.493847784137052*^9, 3.4938480568574333`*^9, {
   3.4938482130376525`*^9, 3.4938482496677036`*^9}, {3.493848670028292*^9, 
   3.493848680578307*^9}, 3.515813945980241*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"ArcCoth", "[", "v", "]"}]], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "-", 
      RowBox[{"a", " ", 
       SuperscriptBox["v", "2"]}]}], ")"}], "m"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      SuperscriptBox["a", "m"]}]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{"u", " ", "v", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "v"}], ")"}], " ", 
     SqrtBox[
      RowBox[{"1", "-", 
       FractionBox["1", 
        SuperscriptBox["v", "2"]]}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["v", "2"]}], ")"}], 
      RowBox[{"m", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796917222768416`*^9, 3.479691774261592*^9}, {
   3.4796924406097536`*^9, 3.479692445126248*^9}, {3.47969249049148*^9, 
   3.4796924960094147`*^9}, 3.47969259154679*^9, {3.4796927611807117`*^9, 
   3.479692812774901*^9}, {3.4796928477752285`*^9, 3.4796928500685263`*^9}, 
   3.479692900881592*^9, {3.4796931059264317`*^9, 3.4796931079994125`*^9}, 
   3.479693147466163*^9, 3.479693333673917*^9, 3.480705437794352*^9, 
   3.493766718905836*^9, {3.4938478028470783`*^9, 3.493847810147088*^9}, {
   3.493848722478366*^9, 3.493848732288379*^9}, {3.4938487648184247`*^9, 
   3.493848795528468*^9}, {3.5158139202713957`*^9, 3.5158139315346155`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{"E", "^", 
      RowBox[{"ArcCoth", "[", "v_", "]"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"v_", "^", "2"}]}]}], ")"}], "^", "m_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "^", "m"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"Expand", "[", 
         RowBox[{
          RowBox[{"u", "*", "v", "*", 
           RowBox[{"(", 
            RowBox[{"1", "+", "v"}], ")"}], "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"1", "-", 
             RowBox[{"1", "/", 
              RowBox[{"v", "^", "2"}]}]}], "]"}], "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{"v", "^", "2"}]}], ")"}], "^", 
            RowBox[{"(", 
             RowBox[{"m", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}], ",", 
        "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"a", "+", "b"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{
  3.4937667189158363`*^9, 3.4938478304371166`*^9, 3.4938486949983273`*^9, {
   3.515813952516652*^9, 3.5158140059155464`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796932346515293`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "-", 
        RowBox[{"a", " ", 
         SuperscriptBox[
          RowBox[{"f", "[", "x", "]"}], "2"]}]}], ")"}], "m"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox[
         RowBox[{"f", "[", "x", "]"}], "2"]}], ")"}], "m"]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4796918758576803`*^9, 3.479691932769515*^9, {3.493766718895836*^9, 
   3.493766718895836*^9}, {3.4938477706470327`*^9, 3.4938477720170345`*^9}, 
   3.4938488513585463`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"a", "\[NotEqual]", "1"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807054353007665`*^9, 3.493847784137052*^9, {3.493849005998762*^9, 
   3.493849008588766*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"ArcCoth", "[", "v", "]"}]], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "-", 
      RowBox[{"a", " ", 
       SuperscriptBox["v", "2"]}]}], ")"}], "m"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "-", 
         RowBox[{"a", " ", 
          SuperscriptBox["v", "2"]}]}], ")"}], "m"], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SuperscriptBox["v", "2"]}], ")"}], "m"]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{"u", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"ArcCoth", "[", "v", "]"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["v", "2"]}], ")"}], "m"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796917222768416`*^9, 3.479691774261592*^9}, {
   3.4796924406097536`*^9, 3.479692445126248*^9}, {3.47969249049148*^9, 
   3.4796924960094147`*^9}, 3.47969259154679*^9, {3.4796927611807117`*^9, 
   3.479692812774901*^9}, {3.4796928477752285`*^9, 3.4796928500685263`*^9}, 
   3.479692900881592*^9, {3.4796931059264317`*^9, 3.4796931079994125`*^9}, 
   3.479693147466163*^9, 3.479693333673917*^9, 3.480705437794352*^9, 
   3.493766718905836*^9, {3.4938478028470783`*^9, 3.493847810147088*^9}, {
   3.4938489058686223`*^9, 3.493848979098725*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{"E", "^", 
      RowBox[{"ArcCoth", "[", "v_", "]"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"v_", "^", "2"}]}]}], ")"}], "^", "m_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"v", "^", "2"}]}]}], ")"}], "^", "m"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"v", "^", "2"}]}], ")"}], "^", "m"}]}], "*", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"u", "*", 
       RowBox[{"E", "^", 
        RowBox[{"ArcCoth", "[", "v", "]"}]}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"v", "^", "2"}]}], ")"}], "^", "m"}]}], ",", "x"}], "]"}]}],
    " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"a", "+", "b"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"a", "-", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{3.4937667189158363`*^9, 3.4938478304371166`*^9, 
  3.493848865548566*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796932346515293`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"n", " ", 
     RowBox[{"ArcCoth", "[", "z", "]"}]}]], "=", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       FractionBox["1", "z"]}], ")"}], "n"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       FractionBox["1", 
        SuperscriptBox["z", "2"]]}], ")"}], 
     RowBox[{"n", "/", "2"}]]]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4796918758576803`*^9, 3.479691932769515*^9, {3.493766718895836*^9, 
   3.493766718895836*^9}, {3.4938477706470327`*^9, 3.4938477720170345`*^9}, 
   3.4938491437389555`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"m", "-", 
     FractionBox["n", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807054353007665`*^9, 3.493847784137052*^9, {3.493849086968876*^9, 
   3.493849109998908*^9}, 3.493849300839175*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"n", " ", 
     RowBox[{"ArcCoth", "[", "v", "]"}]}]], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", 
      FractionBox["1", 
       SuperscriptBox["v", "2"]]}], ")"}], "m"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox[
        RowBox[{"u", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", "v"}], ")"}], 
          RowBox[{"m", "+", 
           FractionBox["n", "2"]}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "v"}], ")"}], 
          RowBox[{"m", "-", 
           FractionBox["n", "2"]}]]}], 
        SuperscriptBox["v", 
         RowBox[{"2", " ", "m"}]]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796917222768416`*^9, 3.479691774261592*^9}, {
   3.4796924406097536`*^9, 3.479692445126248*^9}, {3.47969249049148*^9, 
   3.4796924960094147`*^9}, 3.47969259154679*^9, {3.4796927611807117`*^9, 
   3.479692812774901*^9}, {3.4796928477752285`*^9, 3.4796928500685263`*^9}, 
   3.479692900881592*^9, {3.4796931059264317`*^9, 3.4796931079994125`*^9}, 
   3.479693147466163*^9, 3.479693333673917*^9, 3.480705437794352*^9, 
   3.493766718905836*^9, {3.4938478028470783`*^9, 3.493847810147088*^9}, {
   3.493849166658987*^9, 3.4938492184990597`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{"E", "^", 
      RowBox[{"(", 
       RowBox[{"n_.", "*", 
        RowBox[{"ArcCoth", "[", "v_", "]"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"1", "/", 
         RowBox[{"v_", "^", "2"}]}]}], ")"}], "^", "m_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"u", "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "v"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", 
         RowBox[{"n", "/", "2"}]}], ")"}]}], "*", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "v"}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"m", "-", 
          RowBox[{"n", "/", "2"}]}], ")"}]}], "/", 
       RowBox[{"v", "^", 
        RowBox[{"(", 
         RowBox[{"2", "*", "m"}], ")"}]}]}]}], ",", "x"}], "]"}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"m", "-", 
      RowBox[{"n", "/", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{3.4937667189158363`*^9, 3.4938478304371166`*^9, 
  3.4938490693988514`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796932346515293`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"n", " ", 
     RowBox[{"ArcCoth", "[", "z", "]"}]}]], "=", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       FractionBox["1", "z"]}], ")"}], "n"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       FractionBox["1", 
        SuperscriptBox["z", "2"]]}], ")"}], 
     RowBox[{"n", "/", "2"}]]]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4796918758576803`*^9, 3.479691932769515*^9, {3.493766718895836*^9, 
   3.493766718895836*^9}, {3.4938477706470327`*^9, 3.4938477720170345`*^9}, 
   3.493849291009162*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"2", "m"}], "\[Element]", "\[DoubleStruckCapitalZ]"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807054353007665`*^9, 3.493847784137052*^9, {3.493849345789238*^9, 
   3.4938493807792873`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"n", " ", 
     RowBox[{"ArcCoth", "[", "v", "]"}]}]], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", 
      FractionBox["1", 
       SuperscriptBox["v", "2"]]}], ")"}], "m"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{"u", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          FractionBox["1", "v"]}], ")"}], "n"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          FractionBox["1", 
           SuperscriptBox["v", "2"]]}], ")"}], 
        RowBox[{"m", "-", 
         FractionBox["n", "2"]}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796917222768416`*^9, 3.479691774261592*^9}, {
   3.4796924406097536`*^9, 3.479692445126248*^9}, {3.47969249049148*^9, 
   3.4796924960094147`*^9}, 3.47969259154679*^9, {3.4796927611807117`*^9, 
   3.479692812774901*^9}, {3.4796928477752285`*^9, 3.4796928500685263`*^9}, 
   3.479692900881592*^9, {3.4796931059264317`*^9, 3.4796931079994125`*^9}, 
   3.479693147466163*^9, 3.479693333673917*^9, 3.480705437794352*^9, 
   3.493766718905836*^9, {3.4938478028470783`*^9, 3.493847810147088*^9}, 
   3.4938493231192064`*^9, 3.4938494184693403`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{"E", "^", 
      RowBox[{"(", 
       RowBox[{"n_.", "*", 
        RowBox[{"ArcCoth", "[", "v_", "]"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"1", "/", 
         RowBox[{"v_", "^", "2"}]}]}], ")"}], "^", "m_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"1", "/", "v"}]}], ")"}], "^", "n"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"1", "/", 
            RowBox[{"v", "^", "2"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"m", "-", 
           RowBox[{"n", "/", "2"}]}], ")"}]}]}], ",", "x"}], "]"}], ",", 
     "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"2", "*", "m"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{3.4937667189158363`*^9, 3.4938478304371166`*^9, 
  3.4938493342692223`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796932346515293`*^9}],

Cell["\<\
Derivation: Piecewise constant extraction and algebraic simplification\
\>", "Subsubsection",
 CellChangeTimes->{{3.5158140928232985`*^9, 3.5158141057869215`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"ArcCoth", "[", "z", "]"}]], "=", 
   FractionBox[
    RowBox[{"1", "+", 
     FractionBox["1", "z"]}], 
    SqrtBox[
     RowBox[{"1", "-", 
      FractionBox["1", 
       SuperscriptBox["z", "2"]]}]]]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4796918758576803`*^9, 3.479691932769515*^9, {3.493766718895836*^9, 
   3.493766718895836*^9}, {3.4938477706470327`*^9, 3.4938477720170345`*^9}, 
   3.4938494667994075`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "-", 
        FractionBox["a", 
         SuperscriptBox[
          RowBox[{"f", "[", "x", "]"}], "2"]]}], ")"}], "m"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        FractionBox["1", 
         SuperscriptBox[
          RowBox[{"f", "[", "x", "]"}], "2"]]}], ")"}], "m"]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4796918758576803`*^9, 3.479691932769515*^9, {3.493766718895836*^9, 
   3.493766718895836*^9}, {3.4938477706470327`*^9, 3.4938477720170345`*^9}, {
   3.4938494667994075`*^9, 3.4938494931794443`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"2", "m"}], "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807054353007665`*^9, 3.493847784137052*^9, 3.493849802109877*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"ArcCoth", "[", "v", "]"}]], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "-", 
      FractionBox["a", 
       SuperscriptBox["v", "2"]]}], ")"}], "m"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "-", 
         FractionBox["a", 
          SuperscriptBox["v", "2"]]}], ")"}], "m"], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         FractionBox["1", 
          SuperscriptBox["v", "2"]]}], ")"}], "m"]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{"u", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       FractionBox["1", "v"]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        FractionBox["1", 
         SuperscriptBox["v", "2"]]}], ")"}], 
      RowBox[{"m", "-", 
       FractionBox["1", "2"]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796917222768416`*^9, 3.479691774261592*^9}, {
   3.4796924406097536`*^9, 3.479692445126248*^9}, {3.47969249049148*^9, 
   3.4796924960094147`*^9}, 3.47969259154679*^9, {3.4796927611807117`*^9, 
   3.479692812774901*^9}, {3.4796928477752285`*^9, 3.4796928500685263`*^9}, 
   3.479692900881592*^9, {3.4796931059264317`*^9, 3.4796931079994125`*^9}, 
   3.479693147466163*^9, 3.479693333673917*^9, 3.480705437794352*^9, 
   3.493766718905836*^9, {3.4938478028470783`*^9, 3.493847810147088*^9}, {
   3.4938495186694803`*^9, 3.493849521879485*^9}, {3.49384956123954*^9, 
   3.49384956143954*^9}, {3.4938495930595846`*^9, 3.4938496203796225`*^9}, {
   3.493849754879811*^9, 3.4938497574698143`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{"E", "^", 
      RowBox[{"ArcCoth", "[", "v_", "]"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "/", 
         RowBox[{"v_", "^", "2"}]}]}], ")"}], "^", "m_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "/", 
         RowBox[{"v", "^", "2"}]}]}], ")"}], "^", "m"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"1", "/", 
         RowBox[{"v", "^", "2"}]}]}], ")"}], "^", "m"}]}], "*", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"u", "*", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"1", "/", "v"}]}], ")"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"1", "/", 
           RowBox[{"v", "^", "2"}]}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"m", "-", 
          RowBox[{"1", "/", "2"}]}], ")"}]}]}], ",", "x"}], "]"}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"a", "+", "b"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"2", "*", "m"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{
  3.4937667189158363`*^9, 3.4938478304371166`*^9, 3.4938494481893816`*^9, {
   3.493849675019699*^9, 3.4938497295497756`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"ArcCoth", "[", 
    RowBox[{"b", " ", 
     SuperscriptBox["f", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}]]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, 3.4802882652733135`*^9, 3.480288373839424*^9, {
   3.480299236238787*^9, 3.480299238211624*^9}, {3.4803010920372944`*^9, 
   3.480301103143264*^9}, 3.492825791291954*^9, 3.4933227311790323`*^9, 
   3.4937667191258364`*^9, {3.495385899723461*^9, 3.495385899923462*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"ArcCoth", "[", "z", "]"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       FractionBox["1", "z"]}], "]"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", 
       FractionBox["1", "z"]}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664431619528*^9, 3.4796644842351856`*^9, {3.4796867203243876`*^9, 
   3.4796867203243876`*^9}, {3.479686900964134*^9, 3.479686904699506*^9}, {
   3.493766716975833*^9, 3.493766716975833*^9}, {3.493767547466996*^9, 
   3.493767553017004*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070519364328*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"ArcCoth", "[", 
     RowBox[{"b", " ", 
      SuperscriptBox["f", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}]]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "2"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"1", "+", 
        FractionBox["1", 
         RowBox[{"b", " ", 
          SuperscriptBox["f", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}]]}]]}], "]"}], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", 
       FractionBox["1", 
        RowBox[{"b", " ", 
         SuperscriptBox["f", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}]]}]]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.48029928226497*^9, 3.4802993300937443`*^9}, 
   3.4802995783907776`*^9, {3.480299703450605*^9, 3.480299715728259*^9}, 
   3.4937667191458364`*^9, {3.49378018556984*^9, 3.493780245079923*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"ArcCoth", "[", 
     RowBox[{"b_.", "*", 
      RowBox[{"f_", "^", 
       RowBox[{"(", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], ")"}]}]}], "]"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"Log", "[", 
         RowBox[{"1", "+", 
          RowBox[{"1", "/", 
           RowBox[{"(", 
            RowBox[{"b", "*", 
             RowBox[{"f", "^", 
              RowBox[{"(", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], ")"}]}]}], ")"}]}]}], "]"}], ",", 
        "x"}], "]"}]}], "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"Log", "[", 
         RowBox[{"1", "-", 
          RowBox[{"1", "/", 
           RowBox[{"(", 
            RowBox[{"b", "*", 
             RowBox[{"f", "^", 
              RowBox[{"(", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], ")"}]}]}], ")"}]}]}], "]"}], ",", 
        "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"b", ",", "c", ",", "d", ",", "f"}], "}"}], ",", "x"}], "]"}], 
   " "}]}]], "Code",
 CellChangeTimes->{
  3.493766719155836*^9, {3.493780216599883*^9, 3.4937802286099005`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   RowBox[{"ArcCoth", "[", 
    RowBox[{"b", " ", 
     SuperscriptBox["f", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}]]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, 3.4802882652733135`*^9, 3.480288373839424*^9, {
   3.480299236238787*^9, 3.480299238211624*^9}, {3.4803010920372944`*^9, 
   3.480301103143264*^9}, 3.492825791291954*^9, 3.4933227311790323`*^9, 
   3.4937667191258364`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"ArcCoth", "[", "z", "]"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       FractionBox["1", "z"]}], "]"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", 
       FractionBox["1", "z"]}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664431619528*^9, 3.4796644842351856`*^9, {3.4796867203243876`*^9, 
   3.4796867203243876`*^9}, {3.479686900964134*^9, 3.479686904699506*^9}, {
   3.493766716975833*^9, 3.493766716975833*^9}, {3.493767547466996*^9, 
   3.493767553017004*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"m", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055445578704`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"ArcCoth", "[", 
     RowBox[{"b", " ", 
      SuperscriptBox["f", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}]]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "2"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox["x", "m"], " ", 
      RowBox[{"Log", "[", 
       RowBox[{"1", "+", 
        FractionBox["1", 
         RowBox[{"b", " ", 
          SuperscriptBox["f", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}]]}]]}], "]"}], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", 
       FractionBox["1", 
        RowBox[{"b", " ", 
         SuperscriptBox["f", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}]]}]]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.480299282274984*^9, 3.4802993007415376`*^9}, {
   3.480299332717517*^9, 3.4802993335386972`*^9}, {3.48029943364264*^9, 
   3.480299444237875*^9}, 3.480299578400792*^9, 3.480299657564624*^9, {
   3.480299717951456*^9, 3.480299731180478*^9}, 3.4803000540747776`*^9, {
   3.480300090066531*^9, 3.480300092169555*^9}, 3.480300126899494*^9, 
   3.480705548133011*^9, 3.4937667191758366`*^9, {3.4937802394399157`*^9, 
   3.493780249309929*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"ArcCoth", "[", 
      RowBox[{"b_.", "*", 
       RowBox[{"f_", "^", 
        RowBox[{"(", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], ")"}]}]}], "]"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{"Log", "[", 
          RowBox[{"1", "+", 
           RowBox[{"1", "/", 
            RowBox[{"(", 
             RowBox[{"b", "*", 
              RowBox[{"f", "^", 
               RowBox[{"(", 
                RowBox[{"c", "+", 
                 RowBox[{"d", "*", "x"}]}], ")"}]}]}], ")"}]}]}], "]"}]}], 
        ",", "x"}], "]"}]}], "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{"Log", "[", 
          RowBox[{"1", "-", 
           RowBox[{"1", "/", 
            RowBox[{"(", 
             RowBox[{"b", "*", 
              RowBox[{"f", "^", 
               RowBox[{"(", 
                RowBox[{"c", "+", 
                 RowBox[{"d", "*", "x"}]}], ")"}]}]}], ")"}]}]}], "]"}]}], 
        ",", "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c", ",", "d", ",", "f"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{
  3.4937667191858363`*^9, {3.493780261289946*^9, 3.4937802652199516`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"v", " ", 
   RowBox[{"ArcCoth", "[", "u", "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160783652334`*^9, 3.4796867206047907`*^9, 3.492825781557537*^9, 
   3.4937667191858363`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell["Rule: If u is free of inverse functions, then", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703531363038*^9, 
   3.4807035352686543`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"ArcCoth", "[", "u", "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "x"}]}], " ", 
    RowBox[{"ArcCoth", "[", "u", "]"}]}]}], "-", 
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"x", " ", 
      RowBox[{
       SubscriptBox["\[PartialD]", "x"], "u"}]}], 
     RowBox[{"1", "-", 
      SuperscriptBox["u", "2"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579734230976`*^9, 3.4796580026851745`*^9}, {
   3.479658101347043*^9, 3.479658102348483*^9}, {3.4796582237129965`*^9, 
   3.4796582279090304`*^9}, {3.4796611944647284`*^9, 3.4796612203719807`*^9}, 
   3.4796613933206687`*^9, {3.4796614761798143`*^9, 3.4796614777420607`*^9}, 
   3.4796618658000607`*^9, {3.4796619856624146`*^9, 3.4796619866938972`*^9}, {
   3.4796645712002354`*^9, 3.4796645805536847`*^9}, 3.4796646283424015`*^9, {
   3.4796867206148047`*^9, 3.4796867206148047`*^9}, {3.479687667676613*^9, 
   3.479687667926973*^9}, 3.480705232098576*^9, {3.4937667191858363`*^9, 
   3.4937667191858363`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"ArcCoth", "[", "u_", "]"}], ",", "x_Symbol"}], "]"}], " ", ":=", 
  "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{"ArcCoth", "[", "u", "]"}]}], " ", "-", "\n", "  ", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"Regularize", "[", 
       RowBox[{
        RowBox[{"x", "*", 
         RowBox[{
          RowBox[{"D", "[", 
           RowBox[{"u", ",", "x"}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"u", "^", "2"}]}], ")"}]}]}], ",", "x"}], "]"}], ",", 
      "x"}], "]"}]}], " ", "/;", "\n", 
   RowBox[{"InverseFunctionFreeQ", "[", 
    RowBox[{"u", ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.4937667191858363`*^9, 3.493766719195836*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}], "\[And]"}]]],
 " u is free of inverse functions, then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.4807035587524223`*^9, 
   3.4807036202508526`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"ArcCoth", "[", "u", "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        RowBox[{"ArcCoth", "[", "u", "]"}]}], 
       RowBox[{"m", "+", "1"}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"m", "+", "1"}]], " ", 
       RowBox[{
        SubscriptBox["\[PartialD]", "x"], "u"}]}], 
      RowBox[{"1", "-", 
       SuperscriptBox["u", "2"]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.479657973433112*^9, 3.4796580026951885`*^9}, {
   3.479658110380032*^9, 3.479658111381472*^9}, {3.47965823109361*^9, 
   3.4796582349191103`*^9}, {3.479658630027248*^9, 3.4796586331817837`*^9}, {
   3.4796611944747424`*^9, 3.479661220542226*^9}, 3.479661393330683*^9, {
   3.4796614834602833`*^9, 3.4796614855532928`*^9}, {3.4796616350883136`*^9, 
   3.4796616397950816`*^9}, 3.4796618737314653`*^9, 3.479662021574053*^9, 
   3.4796645886853776`*^9, {3.4796867206248193`*^9, 3.4796867206248193`*^9}, {
   3.479687711189181*^9, 3.479687711749987*^9}, 3.480705245037181*^9, {
   3.493766719195836*^9, 3.493766719195836*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"ArcCoth", "[", "u_", "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"ArcCoth", "[", "u", "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"Regularize", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", 
            RowBox[{"(", 
             RowBox[{"m", "+", "1"}], ")"}]}], "*", 
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{"u", ",", "x"}], "]"}], "/", 
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{"u", "^", "2"}]}], ")"}]}]}], ",", "x"}], "]"}], ",", 
        "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"m", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"InverseFunctionFreeQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", "\n", "\t", 
    RowBox[{"Not", "[", 
     RowBox[{"FunctionOfQ", "[", 
      RowBox[{
       RowBox[{"x", "^", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ",", "u", ",", "x"}], "]"}], "]"}],
     " ", "&&", " ", "\n", "\t", 
    RowBox[{"FalseQ", "[", 
     RowBox[{"PowerVariableExpn", "[", 
      RowBox[{"u", ",", 
       RowBox[{"m", "+", "1"}], ",", "x"}], "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.493766719195836*^9, 3.493766719195836*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell[TextData[{
 "Rule: If u is free of inverse functions, let  ",
 Cell[BoxData[
  RowBox[{"w", "=", 
   RowBox[{"\[Integral]", 
    RowBox[{"v", 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]]],
 ", if w is free of inverse functions, then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703639939163*^9, 
   3.4807036911227617`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{"v", " ", 
    RowBox[{"ArcCoth", "[", "u", "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "w"}]}], " ", 
    RowBox[{"ArcCoth", "[", "u", "]"}]}]}], "-", 
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"w", " ", 
      RowBox[{
       SubscriptBox["\[PartialD]", "x"], "u"}]}], 
     RowBox[{"1", "-", 
      SuperscriptBox["u", "2"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579734531407`*^9, 3.479658002705203*^9}, {
   3.479658122026779*^9, 3.479658123318637*^9}, {3.4796582402567854`*^9, 
   3.479658243621624*^9}, {3.479658719025221*^9, 3.479658746965397*^9}, {
   3.4796611944747424`*^9, 3.4796612207224846`*^9}, 3.4796613933406973`*^9, {
   3.4796614896692114`*^9, 3.479661491792264*^9}, {3.479661879599904*^9, 
   3.479661922882141*^9}, 3.4796620342622976`*^9, {3.4796645916195965`*^9, 
   3.4796646241063104`*^9}, {3.4796867206348333`*^9, 
   3.4796867206348333`*^9}, {3.4796877839337826`*^9, 3.479687784174128*^9}, 
   3.480705260379242*^9, {3.493766719195836*^9, 3.4937667192058363`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"v_", "*", 
     RowBox[{"ArcCoth", "[", "u_", "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"w", "=", 
       RowBox[{"Block", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ShowSteps", "=", "False"}], ",", 
           RowBox[{"StepCounter", "=", "Null"}]}], "}"}], ",", " ", 
         RowBox[{"Int", "[", 
          RowBox[{"v", ",", "x"}], "]"}]}], "]"}]}], "}"}], ",", "  ", "\n", 
     "  ", 
     RowBox[{
      RowBox[{
       RowBox[{"w", "*", 
        RowBox[{"ArcCoth", "[", "u", "]"}]}], " ", "-", "\n", "  ", 
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{"w", "*", 
            RowBox[{
             RowBox[{"D", "[", 
              RowBox[{"u", ",", "x"}], "]"}], "/", 
             RowBox[{"(", 
              RowBox[{"1", "-", 
               RowBox[{"u", "^", "2"}]}], ")"}]}]}], ",", "x"}], "]"}], ",", 
         "x"}], "]"}]}], " ", "/;", "\n", " ", 
      RowBox[{"InverseFunctionFreeQ", "[", 
       RowBox[{"w", ",", "x"}], "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"InverseFunctionFreeQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", "\n", "\t", 
    RowBox[{"Not", "[", 
     RowBox[{"MatchQ", "[", 
      RowBox[{"v", ",", " ", 
       RowBox[{
        RowBox[{"x", "^", "m_."}], " ", "/;", " ", 
        RowBox[{"FreeQ", "[", 
         RowBox[{"m", ",", "x"}], "]"}]}]}], "]"}], "]"}], " ", "&&", "\n", 
    "\t", 
    RowBox[{"FalseQ", "[", 
     RowBox[{"FunctionOfLinear", "[", 
      RowBox[{
       RowBox[{"v", "*", 
        RowBox[{"ArcCoth", "[", "u", "]"}]}], ",", "x"}], "]"}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4937667192058363`*^9, 3.4937667192058363`*^9}},
 Background->GrayLevel[0.85]]
}, Closed]]
},
AutoGeneratedPackage->Automatic,
CellGrouping->Manual,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  "Integration Rules for Inverse Hyperbolic Cotangent Functions", None, None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->28.8},
Magnification->1.399999976158142,
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 880, 19, 118, "Title"],
Cell[1450, 43, 173, 3, 495, "Subsubsection"],
Cell[1626, 48, 57, 0, 340, "Subsubsection"],
Cell[1686, 50, 613, 9, 340, "Subsubsection"],
Cell[2302, 61, 894, 25, 956, "Subsubtitle"],
Cell[3199, 88, 771, 11, 495, "Subsubsection"],
Cell[3973, 101, 839, 25, 1510, "Code"],
Cell[4815, 128, 89, 2, 495, "Subsubsection"],
Cell[4907, 132, 57, 0, 340, "Subsubsection"],
Cell[4967, 134, 827, 16, 365, "Subsubsection"],
Cell[5797, 152, 1640, 40, 929, "Subsubtitle"],
Cell[7440, 194, 771, 11, 495, "Subsubsection"],
Cell[8214, 207, 1291, 39, 1882, "Code"],
Cell[9508, 248, 44, 1, 37, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[9589, 254, 913, 20, 80, "Title"],
Cell[10505, 276, 187, 2, 354, "Subsubsection"],
Cell[10695, 280, 1104, 20, 261, "Subsubsection"],
Cell[11802, 302, 1640, 43, 664, "Subsubtitle"],
Cell[13445, 347, 819, 11, 354, "Subsubsection"],
Cell[14267, 360, 2313, 58, 1345, "Code"],
Cell[16583, 420, 89, 2, 354, "Subsubsection"],
Cell[16675, 424, 187, 2, 243, "Subsubsection"],
Cell[16865, 428, 1203, 22, 261, "Subsubsection"],
Cell[18071, 452, 2546, 72, 1320, "Subsubtitle"],
Cell[20620, 526, 819, 11, 354, "Subsubsection"],
Cell[21442, 539, 3533, 95, 1605, "Code"],
Cell[24978, 636, 89, 2, 354, "Subsubsection"],
Cell[25070, 640, 125, 1, 243, "Subsubsection"],
Cell[25198, 643, 902, 17, 261, "Subsubsection"],
Cell[26103, 662, 1591, 45, 848, "Subsubtitle"],
Cell[27697, 709, 771, 11, 354, "Subsubsection"],
Cell[28471, 722, 1837, 53, 1345, "Code"],
Cell[30311, 777, 89, 2, 354, "Subsubsection"],
Cell[30403, 781, 125, 1, 243, "Subsubsection"],
Cell[30531, 784, 1006, 19, 261, "Subsubsection"],
Cell[31540, 805, 1481, 40, 737, "Subsubtitle"],
Cell[33024, 847, 771, 11, 354, "Subsubsection"],
Cell[33798, 860, 2124, 53, 1345, "Code"],
Cell[35925, 915, 89, 2, 354, "Subsubsection"],
Cell[36017, 919, 245, 3, 243, "Subsubsection"],
Cell[36265, 924, 1304, 23, 261, "Subsubsection"],
Cell[37572, 949, 1784, 47, 664, "Subsubtitle"],
Cell[39359, 998, 819, 11, 354, "Subsubsection"],
Cell[40181, 1011, 2513, 60, 1345, "Code"],
Cell[42697, 1073, 89, 2, 354, "Subsubsection"],
Cell[42789, 1077, 245, 3, 243, "Subsubsection"],
Cell[43037, 1082, 1371, 25, 261, "Subsubsection"],
Cell[44411, 1109, 2465, 69, 1296, "Subsubtitle"],
Cell[46879, 1180, 819, 11, 354, "Subsubsection"],
Cell[47701, 1193, 3522, 93, 1605, "Code"],
Cell[51226, 1288, 44, 1, 27, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[51307, 1294, 1084, 24, 88, "Title"],
Cell[52394, 1320, 154, 2, 5200, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[52551, 1324, 1349, 27, 6715, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[53903, 1353, 2081, 56, 12496, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[55987, 1411, 771, 11, 5200, "Subsubsection"],
Cell[56761, 1424, 3545, 87, 19822, "Code"],
Cell[60309, 1513, 44, 1, 377, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[60390, 1519, 1189, 27, 88, "Title"],
Cell[61582, 1548, 154, 2, 27957, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[61739, 1552, 1403, 28, 36105, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[63145, 1582, 2272, 61, 67201, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[65420, 1645, 771, 11, 27957, "Subsubsection"],
Cell[66194, 1658, 3885, 93, 106600, "Code"],
Cell[70082, 1753, 89, 2, 27957, "Subsubsection"],
Cell[70174, 1757, 154, 2, 19161, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[70331, 1761, 1401, 28, 36105, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[71735, 1791, 2326, 61, 67201, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[74064, 1854, 771, 11, 27957, "Subsubsection"],
Cell[74838, 1867, 3909, 93, 106600, "Code"],
Cell[78750, 1962, 89, 2, 27957, "Subsubsection"],
Cell[78842, 1966, 61, 0, 19161, "Subsubsection"],
Cell[78906, 1968, 645, 19, 31169, "Subsubsection"],
Cell[79554, 1989, 1503, 30, 27957, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[81060, 2021, 1765, 48, 52427, "Subsubtitle"],
Cell[82828, 2071, 771, 11, 27957, "Subsubsection"],
Cell[83602, 2084, 3725, 86, 106600, "Code"],
Cell[87330, 2172, 89, 2, 27957, "Subsubsection"],
Cell[87422, 2176, 61, 0, 19161, "Subsubsection"],
Cell[87486, 2178, 723, 21, 31169, "Subsubsection"],
Cell[88212, 2201, 1622, 32, 27957, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[89837, 2235, 1811, 48, 52427, "Subsubtitle"],
Cell[91651, 2285, 771, 11, 27957, "Subsubsection"],
Cell[92425, 2298, 3736, 86, 106600, "Code"],
Cell[96164, 2386, 44, 1, 2020, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[96245, 2392, 1136, 25, 91, "Title"],
Cell[97384, 2419, 188, 3, 93, "Subsubsection"],
Cell[97575, 2424, 1281, 24, 69, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[98859, 2450, 1317, 30, 181, "Subsubtitle"],
Cell[100179, 2482, 771, 11, 93, "Subsubsection"],
Cell[100953, 2495, 1794, 43, 282, "Code"],
Cell[102750, 2540, 89, 2, 93, "Subsubsection"],
Cell[102842, 2544, 107, 1, 65, "Subsubsection"],
Cell[102952, 2547, 1340, 27, 69, "Subsubsection"],
Cell[104295, 2576, 1401, 32, 179, "Subsubtitle"],
Cell[105699, 2610, 771, 11, 93, "Subsubsection"],
Cell[106473, 2623, 1968, 48, 282, "Code"],
Cell[108444, 2673, 44, 1, 8, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[108525, 2679, 1165, 27, 91, "Title"],
Cell[109693, 2708, 56, 0, 5200, "Subsubsection"],
Cell[109752, 2710, 839, 27, 6500, "Subsubsection"],
Cell[110594, 2739, 1391, 26, 3830, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[111988, 2767, 2305, 53, 10067, "Subsubtitle"],
Cell[114296, 2822, 771, 11, 5200, "Subsubsection"],
Cell[115070, 2835, 2845, 70, 19822, "Code"],
Cell[117918, 2907, 89, 2, 5200, "Subsubsection"],
Cell[118010, 2911, 56, 0, 3564, "Subsubsection"],
Cell[118069, 2913, 1007, 29, 6500, "Subsubsection"],
Cell[119079, 2944, 1437, 27, 3830, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[120519, 2973, 2367, 55, 10855, "Subsubtitle"],
Cell[122889, 3030, 771, 11, 5200, "Subsubsection"],
Cell[123663, 3043, 2955, 72, 19822, "Code"],
Cell[126621, 3117, 89, 2, 5200, "Subsubsection"],
Cell[126713, 3121, 56, 0, 3564, "Subsubsection"],
Cell[126772, 3123, 1011, 29, 6500, "Subsubsection"],
Cell[127786, 3154, 1443, 27, 3830, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[129232, 3183, 2362, 55, 10067, "Subsubtitle"],
Cell[131597, 3240, 771, 11, 5200, "Subsubsection"],
Cell[132371, 3253, 2984, 72, 19822, "Code"],
Cell[135358, 3327, 89, 2, 5200, "Subsubsection"],
Cell[135450, 3331, 56, 0, 3564, "Subsubsection"],
Cell[135509, 3333, 930, 25, 7279, "Subsubsection"],
Cell[136442, 3360, 1353, 26, 3830, "Subsubsection"],
Cell[137798, 3388, 1839, 50, 9777, "Subsubtitle"],
Cell[139640, 3440, 771, 11, 5200, "Subsubsection"],
Cell[140414, 3453, 2849, 75, 19822, "Code"],
Cell[143266, 3530, 89, 2, 5200, "Subsubsection"],
Cell[143358, 3534, 56, 0, 3564, "Subsubsection"],
Cell[143417, 3536, 1002, 26, 7279, "Subsubsection"],
Cell[144422, 3564, 1423, 28, 3830, "Subsubsection"],
Cell[145848, 3594, 1913, 50, 9777, "Subsubtitle"],
Cell[147764, 3646, 771, 11, 5200, "Subsubsection"],
Cell[148538, 3659, 2912, 76, 19822, "Code"],
Cell[151453, 3737, 89, 2, 5200, "Subsubsection"],
Cell[151545, 3741, 64, 0, 3564, "Subsubsection"],
Cell[151612, 3743, 1581, 45, 6150, "Subsubsection"],
Cell[153196, 3790, 2112, 43, 3830, "Subsubsection"],
Cell[155311, 3835, 2273, 49, 9641, "Subsubtitle"],
Cell[157587, 3886, 771, 11, 5200, "Subsubsection"],
Cell[158361, 3899, 2651, 69, 15903, "Code"],
Cell[161015, 3970, 89, 2, 5200, "Subsubsection"],
Cell[161107, 3974, 64, 0, 3564, "Subsubsection"],
Cell[161174, 3976, 1519, 39, 6150, "Subsubsection"],
Cell[162696, 4017, 2164, 44, 3830, "Subsubsection"],
Cell[164863, 4063, 2388, 51, 9641, "Subsubtitle"],
Cell[167254, 4116, 771, 11, 5200, "Subsubsection"],
Cell[168028, 4129, 2636, 68, 15903, "Code"],
Cell[170667, 4199, 44, 1, 377, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[170748, 4205, 1399, 30, 91, "Title"],
Cell[172150, 4237, 61, 0, 10190, "Subsubsection"],
Cell[172214, 4239, 689, 21, 11360, "Subsubsection"],
Cell[172906, 4262, 2000, 45, 12052, "Subsubsection"],
Cell[174909, 4309, 1828, 54, 24383, "Subsubtitle"],
Cell[176740, 4365, 771, 11, 10190, "Subsubsection"],
Cell[177514, 4378, 4269, 111, 38849, "Code"],
Cell[181786, 4491, 44, 1, 737, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[181867, 4497, 1191, 27, 91, "Title"],
Cell[183061, 4526, 57, 0, 27957, "Subsubsection"],
Cell[183121, 4528, 1827, 38, 33067, "Subsubsection"],
Cell[184951, 4568, 1634, 49, 52575, "Subsubtitle"],
Cell[186588, 4619, 771, 11, 27957, "Subsubsection"],
Cell[187362, 4632, 3341, 87, 106600, "Code"],
Cell[190706, 4721, 89, 2, 27957, "Subsubsection"],
Cell[190798, 4725, 57, 0, 19161, "Subsubsection"],
Cell[190858, 4727, 1727, 37, 33067, "Subsubsection"],
Cell[192588, 4766, 1644, 49, 52575, "Subsubtitle"],
Cell[194235, 4817, 771, 11, 27957, "Subsubsection"],
Cell[195009, 4830, 3319, 88, 106600, "Code"],
Cell[198331, 4920, 44, 1, 2020, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[198412, 4926, 1222, 28, 91, "Title"],
Cell[199637, 4956, 57, 0, 27957, "Subsubsection"],
Cell[199697, 4958, 1622, 34, 33067, "Subsubsection"],
Cell[201322, 4994, 2045, 56, 103045, "Subsubtitle"],
Cell[203370, 5052, 771, 11, 27957, "Subsubsection"],
Cell[204144, 5065, 3093, 84, 106600, "Code"],
Cell[207240, 5151, 89, 2, 27957, "Subsubsection"],
Cell[207332, 5155, 57, 0, 19161, "Subsubsection"],
Cell[207392, 5157, 1570, 33, 33067, "Subsubsection"],
Cell[208965, 5192, 2024, 56, 103045, "Subsubtitle"],
Cell[210992, 5250, 771, 11, 27957, "Subsubsection"],
Cell[211766, 5263, 2582, 79, 106600, "Code"],
Cell[214351, 5344, 44, 1, 2020, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[214432, 5350, 1387, 31, 91, "Title"],
Cell[215822, 5383, 57, 0, 27957, "Subsubsection"],
Cell[215882, 5385, 1164, 25, 20591, "Subsubsection"],
Cell[217049, 5412, 2961, 73, 104493, "Subsubtitle"],
Cell[220013, 5487, 771, 11, 27957, "Subsubsection"],
Cell[220787, 5500, 2605, 76, 106600, "Code"],
Cell[223395, 5578, 44, 1, 2020, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[223476, 5584, 1152, 26, 80, "Title"],
Cell[224631, 5612, 89, 2, 1355, "Subsubsection"],
Cell[224723, 5616, 1135, 23, 998, "Subsubsection"],
Cell[225861, 5641, 2122, 66, 3863, "Subsubtitle"],
Cell[227986, 5709, 771, 11, 1355, "Subsubsection"],
Cell[228760, 5722, 3205, 86, 6161, "Code"],
Cell[231968, 5810, 89, 2, 1355, "Subsubsection"],
Cell[232060, 5814, 885, 24, 2370, "Subsubsection"],
Cell[232948, 5840, 1134, 24, 998, "Subsubsection"],
Cell[234085, 5866, 1399, 42, 3554, "Subsubtitle"],
Cell[235487, 5910, 771, 11, 1355, "Subsubsection"],
Cell[236261, 5923, 2364, 60, 4141, "Code"],
Cell[238628, 5985, 89, 2, 1355, "Subsubsection"],
Cell[238720, 5989, 1071, 21, 998, "Subsubsection"],
Cell[239794, 6012, 1344, 40, 3163, "Subsubtitle"],
Cell[241141, 6054, 771, 11, 1355, "Subsubsection"],
Cell[241915, 6067, 1999, 54, 5161, "Code"],
Cell[243917, 6123, 89, 2, 1355, "Subsubsection"],
Cell[244009, 6127, 1476, 27, 998, "Subsubsection"],
Cell[245488, 6156, 2516, 69, 3163, "Subsubtitle"],
Cell[248007, 6227, 771, 11, 1355, "Subsubsection"],
Cell[248781, 6240, 2847, 88, 6161, "Code"],
Cell[251631, 6330, 89, 2, 1355, "Subsubsection"],
Cell[251723, 6334, 1574, 30, 998, "Subsubsection"],
Cell[253300, 6366, 3071, 83, 6088, "Subsubtitle"],
Cell[256374, 6451, 771, 11, 1355, "Subsubsection"],
Cell[257148, 6464, 3241, 99, 6161, "Code"],
Cell[260392, 6565, 89, 2, 1355, "Subsubsection"],
Cell[260484, 6569, 1176, 23, 998, "Subsubsection"],
Cell[261663, 6594, 2282, 65, 97483, "Subsubtitle"],
Cell[263948, 6661, 771, 11, 27957, "Subsubsection"],
Cell[264722, 6674, 2674, 78, 127264, "Code"],
Cell[267399, 6754, 89, 2, 27957, "Subsubsection"],
Cell[267491, 6758, 1455, 29, 31169, "Subsubsection"],
Cell[268949, 6789, 2473, 71, 99069, "Subsubtitle"],
Cell[271425, 6862, 771, 11, 27957, "Subsubsection"],
Cell[272199, 6875, 3183, 93, 127264, "Code"],
Cell[275385, 6970, 89, 2, 27957, "Subsubsection"],
Cell[275477, 6974, 1557, 31, 31169, "Subsubsection"],
Cell[277037, 7007, 3270, 96, 149239, "Subsubtitle"],
Cell[280310, 7105, 771, 11, 27957, "Subsubsection"],
Cell[281084, 7118, 4084, 129, 148546, "Code"],
Cell[285171, 7249, 89, 2, 27957, "Subsubsection"],
Cell[285263, 7253, 57, 0, 19161, "Subsubsection"],
Cell[285323, 7255, 1909, 36, 998, "Subsubsection"],
Cell[287235, 7293, 2744, 67, 4764, "Subsubtitle"],
Cell[289982, 7362, 771, 11, 1355, "Subsubsection"],
Cell[290756, 7375, 4067, 99, 5161, "Code"],
Cell[294826, 7476, 89, 2, 1355, "Subsubsection"],
Cell[294918, 7480, 64, 0, 929, "Subsubsection"],
Cell[294985, 7482, 1757, 48, 1546, "Subsubsection"],
Cell[296745, 7532, 1801, 36, 998, "Subsubsection"],
Cell[298549, 7570, 2365, 52, 2409, "Subsubtitle"],
Cell[300917, 7624, 771, 11, 1355, "Subsubsection"],
Cell[301691, 7637, 2614, 67, 4141, "Code"],
Cell[304308, 7706, 89, 2, 1355, "Subsubsection"],
Cell[304400, 7710, 1453, 38, 2539, "Subsubsection"],
Cell[305856, 7750, 1860, 42, 1510, "Subsubsection"],
Cell[307719, 7794, 2453, 59, 3554, "Subsubtitle"],
Cell[310175, 7855, 771, 11, 1355, "Subsubsection"],
Cell[310949, 7868, 2916, 80, 4141, "Code"],
Cell[313868, 7950, 44, 1, 99, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[313949, 7956, 1230, 28, 80, "Title"],
Cell[315182, 7986, 229, 3, 181, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[315414, 7991, 1804, 34, 187, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[317221, 8027, 2236, 60, 365, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[319460, 8089, 771, 11, 181, "Subsubsection"],
Cell[320234, 8102, 3005, 81, 687, "Code"],
Cell[323242, 8185, 89, 2, 181, "Subsubsection"],
Cell[323334, 8189, 1708, 30, 134, "Subsubsection"],
Cell[325045, 8221, 2841, 70, 368, "Subsubtitle"],
Cell[327889, 8293, 771, 11, 181, "Subsubsection"],
Cell[328663, 8306, 3186, 82, 687, "Code"],
Cell[331852, 8390, 89, 2, 181, "Subsubsection"],
Cell[331944, 8394, 1677, 32, 134, "Subsubsection"],
Cell[333624, 8428, 3478, 93, 769, "Subsubtitle"],
Cell[337105, 8523, 771, 11, 181, "Subsubsection"],
Cell[337879, 8536, 3970, 109, 820, "Code"],
Cell[341852, 8647, 89, 2, 181, "Subsubsection"],
Cell[341944, 8651, 125, 1, 125, "Subsubsection"],
Cell[342072, 8654, 2390, 46, 134, "Subsubsection"],
Cell[344465, 8702, 2984, 74, 634, "Subsubtitle"],
Cell[347452, 8778, 771, 11, 181, "Subsubsection"],
Cell[348226, 8791, 4193, 102, 687, "Code"],
Cell[352422, 8895, 89, 2, 181, "Subsubsection"],
Cell[352514, 8899, 125, 1, 125, "Subsubsection"],
Cell[352642, 8902, 2279, 43, 134, "Subsubsection"],
Cell[354924, 8947, 2909, 73, 634, "Subsubtitle"],
Cell[357836, 9022, 771, 11, 181, "Subsubsection"],
Cell[358610, 9035, 4196, 102, 687, "Code"],
Cell[362809, 9139, 89, 2, 181, "Subsubsection"],
Cell[362901, 9143, 56, 0, 125, "Subsubsection"],
Cell[362960, 9145, 930, 25, 253, "Subsubsection"],
Cell[363893, 9172, 2139, 41, 134, "Subsubsection"],
Cell[366035, 9215, 2377, 62, 310, "Subsubtitle"],
Cell[368415, 9279, 771, 11, 181, "Subsubsection"],
Cell[369189, 9292, 3867, 94, 687, "Code"],
Cell[373059, 9388, 89, 2, 181, "Subsubsection"],
Cell[373151, 9392, 56, 0, 125, "Subsubsection"],
Cell[373210, 9394, 1006, 26, 253, "Subsubsection"],
Cell[374219, 9422, 2345, 44, 134, "Subsubsection"],
Cell[376567, 9468, 2201, 57, 310, "Subsubtitle"],
Cell[378771, 9527, 771, 11, 181, "Subsubsection"],
Cell[379545, 9540, 3496, 88, 687, "Code"],
Cell[383044, 9630, 89, 2, 181, "Subsubsection"],
Cell[383136, 9634, 125, 1, 125, "Subsubsection"],
Cell[383264, 9637, 2390, 45, 134, "Subsubsection"],
Cell[385657, 9684, 3390, 92, 692, "Subsubtitle"],
Cell[389050, 9778, 771, 11, 181, "Subsubsection"],
Cell[389824, 9791, 4940, 127, 820, "Code"],
Cell[394767, 9920, 89, 2, 181, "Subsubsection"],
Cell[394859, 9924, 125, 1, 125, "Subsubsection"],
Cell[394987, 9927, 2240, 43, 134, "Subsubsection"],
Cell[397230, 9972, 3249, 90, 674, "Subsubtitle"],
Cell[400482, 10064, 771, 11, 181, "Subsubsection"],
Cell[401256, 10077, 5009, 128, 820, "Code"],
Cell[406268, 10207, 89, 2, 181, "Subsubsection"],
Cell[406360, 10211, 64, 0, 125, "Subsubsection"],
Cell[406427, 10213, 2644, 75, 207, "Subsubsection"],
Cell[409074, 10290, 2315, 48, 134, "Subsubsection"],
Cell[411392, 10340, 2920, 67, 326, "Subsubtitle"],
Cell[414315, 10409, 771, 11, 181, "Subsubsection"],
Cell[415089, 10422, 4059, 100, 551, "Code"],
Cell[419151, 10524, 89, 2, 181, "Subsubsection"],
Cell[419243, 10528, 64, 0, 125, "Subsubsection"],
Cell[419310, 10530, 2138, 57, 207, "Subsubsection"],
Cell[421451, 10589, 2294, 48, 134, "Subsubsection"],
Cell[423748, 10639, 2663, 59, 321, "Subsubtitle"],
Cell[426414, 10700, 771, 11, 181, "Subsubsection"],
Cell[427188, 10713, 3141, 81, 551, "Code"],
Cell[430332, 10796, 89, 2, 181, "Subsubsection"],
Cell[430424, 10800, 1481, 39, 338, "Subsubsection"],
Cell[431908, 10841, 1959, 43, 202, "Subsubsection"],
Cell[433870, 10886, 2645, 63, 473, "Subsubtitle"],
Cell[436518, 10951, 771, 11, 181, "Subsubsection"],
Cell[437292, 10964, 3153, 84, 551, "Code"],
Cell[440448, 11050, 44, 1, 15, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[440529, 11056, 1097, 23, 80, "Title"],
Cell[441629, 11081, 173, 3, 253, "Subsubsection"],
Cell[441805, 11086, 57, 0, 174, "Subsubsection"],
Cell[441865, 11088, 654, 9, 174, "Subsubsection"],
Cell[442522, 11099, 1479, 37, 488, "Subsubtitle"],
Cell[444004, 11138, 771, 11, 253, "Subsubsection"],
Cell[444778, 11151, 1185, 35, 771, "Code"],
Cell[445966, 11188, 89, 2, 253, "Subsubsection"],
Cell[446058, 11192, 173, 3, 174, "Subsubsection"],
Cell[446234, 11197, 57, 0, 174, "Subsubsection"],
Cell[446294, 11199, 740, 14, 187, "Subsubsection"],
Cell[447037, 11215, 1520, 39, 468, "Subsubtitle"],
Cell[448560, 11256, 771, 11, 253, "Subsubsection"],
Cell[449334, 11269, 1445, 43, 961, "Code"],
Cell[450782, 11314, 44, 1, 20, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[450863, 11320, 874, 20, 80, "Title"],
Cell[451740, 11342, 56, 0, 354, "Subsubsection"],
Cell[451799, 11344, 689, 21, 394, "Subsubsection"],
Cell[452491, 11367, 613, 9, 243, "Subsubsection"],
Cell[453107, 11378, 1404, 42, 848, "Subsubtitle"],
Cell[454514, 11422, 771, 11, 354, "Subsubsection"],
Cell[455288, 11435, 1505, 47, 1345, "Code"],
Cell[456796, 11484, 89, 2, 354, "Subsubsection"],
Cell[456888, 11488, 197, 3, 243, "Subsubsection"],
Cell[457088, 11493, 57, 0, 243, "Subsubsection"],
Cell[457148, 11495, 1133, 23, 261, "Subsubsection"],
Cell[458284, 11520, 1846, 50, 692, "Subsubtitle"],
Cell[460133, 11572, 771, 11, 354, "Subsubsection"],
Cell[460907, 11585, 1978, 61, 1345, "Code"],
Cell[462888, 11648, 44, 1, 27, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[462969, 11654, 861, 20, 80, "Title"],
Cell[463833, 11676, 64, 0, 253, "Subsubsection"],
Cell[463900, 11678, 1126, 20, 187, "Subsubsection"],
Cell[465029, 11700, 1150, 29, 433, "Subsubtitle"],
Cell[466182, 11731, 771, 11, 253, "Subsubsection"],
Cell[466956, 11744, 1179, 33, 771, "Code"],
Cell[468138, 11779, 44, 1, 20, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[468219, 11785, 894, 21, 80, "Title"],
Cell[469116, 11808, 64, 0, 495, "Subsubsection"],
Cell[469183, 11810, 1107, 22, 365, "Subsubsection"],
Cell[470293, 11834, 1287, 34, 865, "Subsubtitle"],
Cell[471583, 11870, 771, 11, 495, "Subsubsection"],
Cell[472357, 11883, 1503, 44, 1510, "Code"],
Cell[473863, 11929, 44, 1, 37, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[473944, 11935, 884, 22, 86, "Title"],
Cell[474831, 11959, 61, 0, 27957, "Subsubsection"],
Cell[474895, 11961, 689, 21, 31169, "Subsubsection"],
Cell[475587, 11984, 1113, 25, 29783, "Subsubsection"],
Cell[476703, 12011, 1593, 46, 67201, "Subsubtitle"],
Cell[478299, 12059, 771, 11, 27957, "Subsubsection"],
Cell[479073, 12072, 1937, 63, 106600, "Code"],
Cell[481013, 12137, 89, 2, 27957, "Subsubsection"],
Cell[481105, 12141, 61, 0, 19161, "Subsubsection"],
Cell[481169, 12143, 689, 21, 31169, "Subsubsection"],
Cell[481861, 12166, 1157, 25, 20591, "Subsubsection"],
Cell[483021, 12193, 1734, 50, 67201, "Subsubtitle"],
Cell[484758, 12245, 771, 11, 27957, "Subsubsection"],
Cell[485532, 12258, 2041, 65, 106600, "Code"],
Cell[487576, 12325, 44, 1, 2020, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[487657, 12331, 924, 22, 83, "Title"],
Cell[488584, 12355, 61, 0, 27957, "Subsubsection"],
Cell[488648, 12357, 400, 11, 31169, "Subsubsection"],
Cell[489051, 12370, 613, 9, 19161, "Subsubsection"],
Cell[489667, 12381, 1245, 31, 50546, "Subsubtitle"],
Cell[490915, 12414, 771, 11, 27957, "Subsubsection"],
Cell[491689, 12427, 999, 32, 85525, "Code"],
Cell[492691, 12461, 44, 1, 2020, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[492772, 12467, 1071, 27, 93, "Title"],
Cell[493846, 12496, 64, 0, 27957, "Subsubsection"],
Cell[493913, 12498, 569, 18, 29783, "Subsubsection"],
Cell[494485, 12518, 864, 28, 34952, "Subsubsection"],
Cell[495352, 12548, 604, 16, 20591, "Subsubsection"],
Cell[495959, 12566, 611, 9, 19161, "Subsubsection"],
Cell[496573, 12577, 1350, 39, 51844, "Subsubtitle"],
Cell[497926, 12618, 771, 11, 27957, "Subsubsection"],
Cell[498700, 12631, 6767, 176, 378565, "Code"],
Cell[505470, 12809, 44, 1, 2020, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[505551, 12815, 853, 19, 80, "Title"],
Cell[506407, 12836, 61, 0, 67, "Subsubsection"],
Cell[506471, 12838, 775, 25, 85, "Subsubsection"],
Cell[507249, 12865, 764, 15, 67, "Subsubsection"],
Cell[508016, 12882, 1175, 31, 130, "Subsubtitle"],
Cell[509194, 12915, 771, 11, 67, "Subsubsection"],
Cell[509968, 12928, 932, 31, 202, "Code"],
Cell[510903, 12961, 89, 2, 67, "Subsubsection"],
Cell[510995, 12965, 61, 0, 47, "Subsubsection"],
Cell[511059, 12967, 831, 26, 172, "Subsubsection"],
Cell[511893, 12995, 814, 16, 71, "Subsubsection"],
Cell[512710, 13013, 1204, 33, 253, "Subsubtitle"],
Cell[513917, 13048, 771, 11, 67, "Subsubsection"],
Cell[514691, 13061, 1068, 33, 202, "Code"],
Cell[515762, 13096, 89, 2, 67, "Subsubsection"],
Cell[515854, 13100, 178, 2, 47, "Subsubsection"],
Cell[516035, 13104, 726, 24, 172, "Subsubsection"],
Cell[516764, 13130, 945, 20, 75, "Subsubsection"],
Cell[517712, 13152, 1305, 35, 253, "Subsubtitle"],
Cell[519020, 13189, 771, 11, 67, "Subsubsection"],
Cell[519794, 13202, 1218, 37, 202, "Code"],
Cell[521015, 13241, 89, 2, 67, "Subsubsection"],
Cell[521107, 13245, 123, 1, 47, "Subsubsection"],
Cell[521233, 13248, 637, 9, 47, "Subsubsection"],
Cell[521873, 13259, 1722, 45, 130, "Subsubtitle"],
Cell[523598, 13306, 771, 11, 67, "Subsubsection"],
Cell[524372, 13319, 1444, 46, 251, "Code"],
Cell[525819, 13367, 89, 2, 67, "Subsubsection"],
Cell[525911, 13371, 123, 1, 47, "Subsubsection"],
Cell[526037, 13374, 910, 17, 50, "Subsubsection"],
Cell[526950, 13393, 2111, 57, 130, "Subsubtitle"],
Cell[529064, 13452, 771, 11, 67, "Subsubsection"],
Cell[529838, 13465, 2025, 64, 251, "Code"],
Cell[531866, 13531, 89, 2, 67, "Subsubsection"],
Cell[531958, 13535, 61, 0, 47, "Subsubsection"],
Cell[532022, 13537, 1420, 47, 149, "Subsubsection"],
Cell[533445, 13586, 686, 22, 145, "Subsubsection"],
Cell[534134, 13610, 1014, 22, 75, "Subsubsection"],
Cell[535151, 13634, 1932, 52, 214, "Subsubtitle"],
Cell[537086, 13688, 771, 11, 67, "Subsubsection"],
Cell[537860, 13701, 1712, 56, 202, "Code"],
Cell[539575, 13759, 89, 2, 67, "Subsubsection"],
Cell[539667, 13763, 61, 0, 47, "Subsubsection"],
Cell[539731, 13765, 665, 22, 114, "Subsubsection"],
Cell[540399, 13789, 954, 18, 50, "Subsubsection"],
Cell[541356, 13809, 1602, 40, 159, "Subsubtitle"],
Cell[542961, 13851, 771, 11, 67, "Subsubsection"],
Cell[543735, 13864, 1620, 48, 202, "Code"],
Cell[545358, 13914, 89, 2, 67, "Subsubsection"],
Cell[545450, 13918, 689, 22, 96, "Subsubsection"],
Cell[546142, 13942, 770, 15, 50, "Subsubsection"],
Cell[546915, 13959, 1621, 42, 142, "Subsubtitle"],
Cell[548539, 14003, 771, 11, 67, "Subsubsection"],
Cell[549313, 14016, 1416, 46, 202, "Code"],
Cell[550732, 14064, 89, 2, 67, "Subsubsection"],
Cell[550824, 14068, 61, 0, 47, "Subsubsection"],
Cell[550888, 14070, 677, 22, 125, "Subsubsection"],
Cell[551568, 14094, 956, 19, 75, "Subsubsection"],
Cell[552527, 14115, 1611, 42, 149, "Subsubtitle"],
Cell[554141, 14159, 771, 11, 67, "Subsubsection"],
Cell[554915, 14172, 1342, 44, 202, "Code"],
Cell[556260, 14218, 89, 2, 67, "Subsubsection"],
Cell[556352, 14222, 61, 0, 47, "Subsubsection"],
Cell[556416, 14224, 675, 22, 125, "Subsubsection"],
Cell[557094, 14248, 907, 18, 50, "Subsubsection"],
Cell[558004, 14268, 1492, 38, 124, "Subsubtitle"],
Cell[559499, 14308, 771, 11, 67, "Subsubsection"],
Cell[560273, 14321, 1265, 40, 202, "Code"],
Cell[561541, 14363, 89, 2, 67, "Subsubsection"],
Cell[561633, 14367, 173, 3, 47, "Subsubsection"],
Cell[561809, 14372, 528, 17, 144, "Subsubsection"],
Cell[562340, 14391, 742, 23, 152, "Subsubsection"],
Cell[563085, 14416, 782, 15, 50, "Subsubsection"],
Cell[563870, 14433, 1877, 49, 177, "Subsubtitle"],
Cell[565750, 14484, 771, 11, 67, "Subsubsection"],
Cell[566524, 14497, 1641, 53, 202, "Code"],
Cell[568168, 14552, 44, 1, 6, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[568249, 14558, 857, 20, 80, "Title"],
Cell[569109, 14580, 61, 0, 130, "Subsubsection"],
Cell[569173, 14582, 689, 21, 145, "Subsubsection"],
Cell[569865, 14605, 610, 9, 90, "Subsubsection"],
Cell[570478, 14616, 1300, 40, 230, "Subsubtitle"],
Cell[571781, 14658, 771, 11, 130, "Subsubsection"],
Cell[572555, 14671, 1576, 50, 491, "Code"],
Cell[574134, 14723, 44, 1, 11, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[574215, 14729, 846, 21, 80, "Title"],
Cell[575064, 14752, 61, 0, 130, "Subsubsection"],
Cell[575128, 14754, 689, 21, 145, "Subsubsection"],
Cell[575820, 14777, 782, 16, 96, "Subsubsection"],
Cell[576605, 14795, 1655, 47, 296, "Subtitle"],
Cell[578263, 14844, 771, 11, 130, "Subsubsection"],
Cell[579037, 14857, 1892, 59, 491, "Code"],
Cell[580932, 14918, 44, 1, 11, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[581013, 14924, 718, 16, 80, "Title"],
Cell[581734, 14942, 57, 0, 27957, "Subsubsection"],
Cell[581794, 14944, 729, 10, 19161, "Subsubsection"],
Cell[582526, 14956, 1235, 29, 48932, "Subsubtitle"],
Cell[583764, 14987, 771, 11, 27957, "Subsubsection"],
Cell[584538, 15000, 833, 25, 106600, "Code"],
Cell[585374, 15027, 89, 2, 27957, "Subsubsection"],
Cell[585466, 15031, 57, 0, 19161, "Subsubsection"],
Cell[585526, 15033, 856, 17, 20591, "Subsubsection"],
Cell[586385, 15052, 1545, 40, 52427, "Subsubtitle"],
Cell[587933, 15094, 771, 11, 27957, "Subsubsection"],
Cell[588707, 15107, 1911, 57, 148546, "Code"],
Cell[590621, 15166, 89, 2, 27957, "Subsubsection"],
Cell[590713, 15170, 57, 0, 19161, "Subsubsection"],
Cell[590773, 15172, 920, 18, 23620, "Subsubsection"],
Cell[591696, 15192, 1257, 29, 48932, "Subsubtitle"],
Cell[592956, 15223, 771, 11, 27957, "Subsubsection"],
Cell[593730, 15236, 1956, 57, 190044, "Code"]
}, Closed]]
}
]
*)

(* End of internal cache information *)
