(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    219476,       5553]
NotebookOptionsPosition[    210192,       5327]
NotebookOutlinePosition[    211315,       5366]
CellTagsIndexPosition[    211272,       5363]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Tanh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978201697549086`*^9, 3.4978201707449093`*^9}, 
   3.4980702555322742`*^9, 3.5154522562626915`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.243.17, CRC 556, A&S 4.5.79", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.498070277840313*^9, 
   3.5154518793521643`*^9}],

Cell["Derivation: Reciprocal rule", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, 3.4980702864359283`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Tanh", "[", "z", "]"}], "=", 
   FractionBox[
    RowBox[{"Sinh", "[", "z", "]"}], 
    RowBox[{"Cosh", "[", "z", "]"}]]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, {
   3.4980703053275614`*^9, 3.4980703053275614`*^9}, {3.515451911012208*^9, 
   3.515451914372213*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Tanh", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"Log", "[", 
       RowBox[{"Cosh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}], "]"}], "b"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.498070321988391*^9, 
   3.498070327557601*^9}, {3.5154519262822294`*^9, 3.5154519320322375`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Tanh", "[", 
     RowBox[{"a_.", "+", 
      RowBox[{"b_.", "*", "x_"}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"Cosh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], "]"}], "]"}], "/", "b"}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.498070271459902*^9, 
   3.5154518875221753`*^9},
 Background->GrayLevel[0.85]],

Cell["Reference: G&R 2.423.33, CRC 557, A&S 4.5.82", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.498070277840313*^9, 
   3.5154518793521643`*^9, 3.515468077263712*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Coth", "[", 
     RowBox[{"a_.", "+", 
      RowBox[{"b_.", "*", "x_"}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], "]"}], "]"}], "/", "b"}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.498070271459902*^9, 
   3.5154518875221753`*^9, 3.515468003678383*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.423.22, CRC 569", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761332771716`*^9, 3.4980704159005556`*^9, 
   3.5154519810423064`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.4980704231233683`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox[
    RowBox[{"Tanh", "[", "z", "]"}], "2"], "=", 
   RowBox[{"1", "-", 
    SuperscriptBox[
     RowBox[{"Sech", "[", "z", "]"}], "2"]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, {
   3.4980703053275614`*^9, 3.4980703053275614`*^9}, 3.4980704431694036`*^9, {
   3.5154519875023155`*^9, 3.5154519946023254`*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Tanh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "x"}]}]}]}], "-", 
  FractionBox[
   RowBox[{"Tanh", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}], "b"]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4980703789284906`*^9, 
   3.4980703957921205`*^9}, {3.5154519618022795`*^9, 3.515451965922285*^9}, 
   3.5154520067723427`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Tanh", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "2"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"x", " ", "-", " ", 
    RowBox[{
     RowBox[{"Tanh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], "]"}], "/", "b"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.515451958622275*^9},
 Background->GrayLevel[0.85]],

Cell["Reference: G&R 2.423.38, CRC 573", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761332771716`*^9, 3.4980704159005556`*^9, 
   3.5154519810423064`*^9, 3.515468106201763*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Coth", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "2"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"x", " ", "-", " ", 
    RowBox[{
     RowBox[{"Coth", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], "]"}], "/", "b"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.515451958622275*^9, 
   3.5154681004921527`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.411.3, CRC 570, A&S 4.5.87", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761332771716`*^9, 3.4980704159005556`*^9, 
   3.4980705234471445`*^9, 3.5154520511524043`*^9}],

Cell["Derivation: Integration by parts with a double-back flip", \
"Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.4980704231233683`*^9, 
   3.4980705306387577`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox[
    RowBox[{"Tanh", "[", "z", "]"}], "n"], "=", 
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"Tanh", "[", "z", "]"}], 
      RowBox[{"n", "-", "1"}]], " ", 
     RowBox[{"Sinh", "[", "z", "]"}]}], 
    RowBox[{"Cosh", "[", "z", "]"}]]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, {
   3.4980703053275614`*^9, 3.4980703053275614`*^9}, 3.4980704431694036`*^9, 
   3.4980705505911922`*^9, {3.5154520563224115`*^9, 3.515452061602419*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", ">", "1"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9, {
   3.498070579139242*^9, 3.49807059487967*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", " ", 
       RowBox[{"Tanh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"c", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"c", " ", 
            RowBox[{"Tanh", "[", 
             RowBox[{"a", "+", 
              RowBox[{"b", " ", "x"}]}], "]"}]}], ")"}], 
          RowBox[{"n", "-", "1"}]]}], 
        RowBox[{"b", " ", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   SuperscriptBox["c", "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", " ", 
        RowBox[{"Tanh", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], "]"}]}], ")"}], 
      RowBox[{"n", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4980703789284906`*^9, 
   3.4980703957921205`*^9}, {3.4980704970362988`*^9, 3.498070514508329*^9}, {
   3.515452173602576*^9, 3.515452194482605*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"c_.", "*", 
       RowBox[{"Tanh", "[", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", "x_"}]}], "]"}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "c"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "*", 
         RowBox[{"Tanh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], "]"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"c", "^", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"c", "*", 
           RowBox[{"Tanh", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", "x"}]}], "]"}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "-", "2"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.498070474665859*^9, 
   3.515452039762388*^9},
 Background->GrayLevel[0.85]],

Cell["Reference: G&R 2.411.4, CRC 574, A&S 4.5.88", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761332771716`*^9, 3.4980704159005556`*^9, 
   3.4980705234471445`*^9, 3.5154520511524043`*^9, 3.5154681428462267`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"c_.", "*", 
       RowBox[{"Coth", "[", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", "x_"}]}], "]"}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "c"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "*", 
         RowBox[{"Coth", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], "]"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"c", "^", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"c", "*", 
           RowBox[{"Coth", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", "x"}]}], "]"}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "-", "2"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.498070474665859*^9, 
   3.515452039762388*^9, 3.5154681283538017`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.411.4, CRC 574'", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761332771716`*^9, 3.4980704159005556`*^9, 
   3.4980705234471445`*^9, 3.4980706229285192`*^9, 3.5154520971024685`*^9}],

Cell["\<\
Derivation: Inverted integration by parts with a double-back flip\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.4980704231233683`*^9, 
   3.4980705306387577`*^9, 3.498070631992135*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", "<", 
   RowBox[{"-", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9, {
   3.498070579139242*^9, 3.49807059487967*^9}, {3.4980707881328096`*^9, 
   3.4980707891624117`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", " ", 
       RowBox[{"Tanh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", " ", 
          RowBox[{"Tanh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}], "]"}]}], ")"}], 
        RowBox[{"n", "+", "1"}]], 
       RowBox[{"b", " ", "c", " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    SuperscriptBox["c", "2"]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", " ", 
        RowBox[{"Tanh", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], "]"}]}], ")"}], 
      RowBox[{"n", "+", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4980703789284906`*^9, 
   3.4980703957921205`*^9}, {3.4980704970362988`*^9, 3.498070514508329*^9}, 
   3.498070660243785*^9, {3.515452175202578*^9, 3.5154522068326225`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"c_.", "*", 
       RowBox[{"Tanh", "[", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", "x_"}]}], "]"}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{"Tanh", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], "]"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"b", "*", "c", "*", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"c", "^", "2"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"c", "*", 
           RowBox[{"Tanh", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", "x"}]}], "]"}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "+", "2"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.498070474665859*^9, 
   3.4980706418045526`*^9, 3.515452148892541*^9},
 Background->GrayLevel[0.85]],

Cell["Reference: G&R 2.411.3, CRC 570'", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761332771716`*^9, 3.4980704159005556`*^9, 
   3.4980705234471445`*^9, 3.4980706229285192`*^9, 3.5154520971024685`*^9, 
   3.515468168570672*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"c_.", "*", 
       RowBox[{"Coth", "[", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", "x_"}]}], "]"}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{"Coth", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], "]"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"b", "*", "c", "*", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"c", "^", "2"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"c", "*", 
           RowBox[{"Coth", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", "x"}]}], "]"}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "+", "2"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.498070474665859*^9, 
   3.4980706418045526`*^9, 3.515452148892541*^9, 3.5154681608954587`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Tanh", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", "when", "  ", 
     SuperscriptBox["a", "2"]}]}], "-", 
   SuperscriptBox["b", "2"]}], "=", "0"}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978201697549086`*^9, 3.4978201707449093`*^9}, 
   3.4980702555322742`*^9, 3.498070723969897*^9, {3.4981051466535454`*^9, 
   3.498105191173608*^9}, 3.5154511318611174`*^9, {3.5154513178613777`*^9, 
   3.515451329961395*^9}, 3.5154518164820757`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.498070802032434*^9, 3.498070811704451*^9}, {
   3.4980708419217043`*^9, 3.498070859549735*^9}, {3.498071345530589*^9, 
   3.4980713485569944`*^9}, {3.4980714878184395`*^9, 3.498071509518077*^9}, {
   3.498071549142147*^9, 3.498071550234149*^9}, {3.515451490121619*^9, 
   3.515451490121619*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Tanh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["x", 
       RowBox[{"2", " ", "a"}]]}]}]}]}], "-", 
  FractionBox["a", 
   RowBox[{"2", " ", "b", " ", "d", " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Tanh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}]}]]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4980703789284906`*^9, 
   3.4980703957921205`*^9}, {3.4980704970362988`*^9, 3.498070514508329*^9}, 
   3.498070660243785*^9, {3.4980715799210005`*^9, 3.498071607267849*^9}, {
   3.515451132771119*^9, 3.515451133171119*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Tanh", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", "a"}], ")"}]}], " ", "-", " ", 
    RowBox[{"a", "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", "b", "*", "d", "*", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Tanh", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}], ")"}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.498070474665859*^9, 
   3.4980706418045526`*^9, 3.498070751347945*^9, 3.498071523433302*^9, 
   3.515451100691074*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Coth", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", "a"}], ")"}]}], " ", "-", " ", 
    RowBox[{"a", "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", "b", "*", "d", "*", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Coth", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}], ")"}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.498070474665859*^9, 
   3.4980706418045526`*^9, 3.498070751347945*^9, 3.498071523433302*^9, 
   3.515451100691074*^9, 3.5154679321210566`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"a", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.498070802032434*^9, 3.498070811704451*^9}, {
   3.4980708419217043`*^9, 3.498070859549735*^9}, {3.5154514934716234`*^9, 
   3.5154514934716234`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SqrtBox[
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Tanh", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SqrtBox["2"], " ", "b"}], 
      RowBox[{"d", " ", 
       SqrtBox["a"]}]]}]}], 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Tanh", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{
      SqrtBox["2"], " ", 
      SqrtBox["a"]}]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.498070321988391*^9, 
   3.498070327557601*^9}, 3.4980709163338346`*^9, {3.4980711071777706`*^9, 
   3.498071117738989*^9}, {3.51545113364112*^9, 3.5154511340311203`*^9}, 
   3.51545165504185*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"a_", "+", 
      RowBox[{"b_.", "*", 
       RowBox[{"Tanh", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Sqrt", "[", "2", "]"}], "*", 
    RowBox[{"b", "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"Rt", "[", 
        RowBox[{"a", ",", "2"}], "]"}]}], ")"}]}], "*", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Tanh", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sqrt", "[", "2", "]"}], "*", 
        RowBox[{"Rt", "[", 
         RowBox[{"a", ",", "2"}], "]"}]}], ")"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"PosQ", "[", "a", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.498070271459902*^9, 
   3.4980707653567696`*^9, {3.498070972259933*^9, 3.4980709751771383`*^9}, {
   3.498076659212607*^9, 3.4980766634826126`*^9}, {3.4980966277916193`*^9, 
   3.498096630541623*^9}, 3.515451008660945*^9, {3.515451181591187*^9, 
   3.5154512280912523`*^9}, 3.515451695751907*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"a_", "+", 
      RowBox[{"b_.", "*", 
       RowBox[{"Coth", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Sqrt", "[", "2", "]"}], "*", 
     RowBox[{"b", "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"Rt", "[", 
         RowBox[{"a", ",", "2"}], "]"}]}], ")"}]}], "*", 
     RowBox[{"ArcCoth", "[", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Coth", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Sqrt", "[", "2", "]"}], "*", 
         RowBox[{"Rt", "[", 
          RowBox[{"a", ",", "2"}], "]"}]}], ")"}]}], "]"}]}], ")"}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"PosQ", "[", "a", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.498070271459902*^9, 
   3.4980707653567696`*^9, {3.498070972259933*^9, 3.4980709751771383`*^9}, {
   3.498076659212607*^9, 3.4980766634826126`*^9}, {3.4980966277916193`*^9, 
   3.498096630541623*^9}, 3.515451008660945*^9, {3.515451181591187*^9, 
   3.5154512280912523`*^9}, 3.515451695751907*^9, {3.5154679022314043`*^9, 
   3.515467909828618*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"\[Not]", 
     RowBox[{"(", 
      RowBox[{"a", ">", "0"}], ")"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.498070802032434*^9, 3.498070811704451*^9}, {
   3.4980708419217043`*^9, 3.498070859549735*^9}, {3.498071345530589*^9, 
   3.4980713485569944`*^9}, {3.5154514958516273`*^9, 3.5154514958516273`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SqrtBox[
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Tanh", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SqrtBox["2"], " ", "b"}], 
       RowBox[{"d", " ", 
        SqrtBox[
         RowBox[{"-", "a"}]]}]]}]}]}], 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Tanh", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{
      SqrtBox["2"], " ", 
      SqrtBox[
       RowBox[{"-", "a"}]]}]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4980703789284906`*^9, 
   3.4980703957921205`*^9}, {3.49807131180333*^9, 3.4980713271225567`*^9}, {
   3.5154511350311217`*^9, 3.5154511364111238`*^9}, 3.5154515203816614`*^9, 
   3.515451592961763*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"a_", "+", 
      RowBox[{"b_.", "*", 
       RowBox[{"Tanh", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Sqrt", "[", "2", "]"}]}], "*", 
    RowBox[{"b", "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{"-", "a"}], ",", "2"}], "]"}]}], ")"}]}], "*", 
    RowBox[{"ArcTan", "[", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Tanh", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sqrt", "[", "2", "]"}], "*", 
        RowBox[{"Rt", "[", 
         RowBox[{
          RowBox[{"-", "a"}], ",", "2"}], "]"}]}], ")"}]}], "]"}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NegQ", "[", "a", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.4980707567767544`*^9, {
   3.4980712506044226`*^9, 3.4980712683260536`*^9}, {3.498076667432618*^9, 
   3.498076671182624*^9}, {3.498096633201627*^9, 3.49809663552163*^9}, 
   3.5154510247609673`*^9, {3.5154511982412105`*^9, 3.515451201051214*^9}, {
   3.515451242361272*^9, 3.5154512447712755`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"a_", "+", 
      RowBox[{"b_.", "*", 
       RowBox[{"Coth", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Sqrt", "[", "2", "]"}], "*", 
    RowBox[{"b", "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{"-", "a"}], ",", "2"}], "]"}]}], ")"}]}], "*", 
    RowBox[{"ArcCot", "[", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Coth", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sqrt", "[", "2", "]"}], "*", 
        RowBox[{"Rt", "[", 
         RowBox[{
          RowBox[{"-", "a"}], ",", "2"}], "]"}]}], ")"}]}], "]"}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NegQ", "[", "a", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.4980707567767544`*^9, {
   3.4980712506044226`*^9, 3.4980712683260536`*^9}, {3.498076667432618*^9, 
   3.498076671182624*^9}, {3.498096633201627*^9, 3.49809663552163*^9}, 
   3.5154510247609673`*^9, {3.5154511982412105`*^9, 3.515451201051214*^9}, {
   3.515451242361272*^9, 3.5154512447712755`*^9}, {3.5154678494409113`*^9, 
   3.5154678737769547`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", ">", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.498070802032434*^9, 3.498070811704451*^9}, {
   3.4980708419217043`*^9, 3.498070859549735*^9}, {3.498071345530589*^9, 
   3.4980713485569944`*^9}, {3.4980714878184395`*^9, 3.498071509518077*^9}, {
   3.5154514987516313`*^9, 3.5154514987516313`*^9}, {3.515451721511943*^9, 
   3.515451722311944*^9}, {3.5156412805019484`*^9, 3.5156412805019484`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Tanh", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             RowBox[{"Tanh", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
          RowBox[{"n", "-", "1"}]]}], 
        RowBox[{"b", " ", "d", " ", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{"2", " ", "a", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Tanh", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4980703789284906`*^9, 
   3.4980703957921205`*^9}, {3.4980704970362988`*^9, 3.498070514508329*^9}, {
   3.498071392034271*^9, 3.4980714173687153`*^9}, {3.515451141471131*^9, 
   3.515451142251132*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Tanh", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"a", "^", "2"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Tanh", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"2", "*", "a"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Tanh", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.498070474665859*^9, 
   3.4980707537347493`*^9, 3.4980713809270515`*^9, {3.4980714760872183`*^9, 
   3.4980714779280214`*^9}, {3.4980766748526287`*^9, 3.498076678512634*^9}, {
   3.4980767946527967`*^9, 3.4980768297628455`*^9}, {3.4980966387016344`*^9, 
   3.498096641271638*^9}, {3.5154510532610073`*^9, 3.5154510592010155`*^9}, {
   3.51545172670195*^9, 3.515451728001952*^9}, 3.515641261237847*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Coth", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"a", "^", "2"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Coth", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"2", "*", "a"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Coth", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.498070474665859*^9, 
   3.4980707537347493`*^9, 3.4980713809270515`*^9, {3.4980714760872183`*^9, 
   3.4980714779280214`*^9}, {3.4980766748526287`*^9, 3.498076678512634*^9}, {
   3.4980767946527967`*^9, 3.4980768297628455`*^9}, {3.4980966387016344`*^9, 
   3.498096641271638*^9}, {3.5154510532610073`*^9, 3.5154510592010155`*^9}, {
   3.51545172670195*^9, 3.515451728001952*^9}, {3.515467793733214*^9, 
   3.515467805854435*^9}, 3.515641262623926*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"n", "<", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.498070802032434*^9, 3.498070811704451*^9}, {
   3.4980708419217043`*^9, 3.498070859549735*^9}, {3.498071345530589*^9, 
   3.4980713485569944`*^9}, {3.4980714878184395`*^9, 3.498071509518077*^9}, {
   3.498071686453588*^9, 3.4980716921787977`*^9}, {3.498082510550128*^9, 
   3.498082538970168*^9}, {3.4980967683718157`*^9, 3.4980967747218246`*^9}, {
   3.515451501261635*^9, 3.515451501261635*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Tanh", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"a", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Tanh", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"]}], 
       RowBox[{"2", " ", "b", " ", "d", " ", "n"}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", " ", "a"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Tanh", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4980703789284906`*^9, 
   3.4980703957921205`*^9}, {3.4980704970362988`*^9, 3.498070514508329*^9}, 
   3.498070660243785*^9, {3.4980715799210005`*^9, 3.498071607267849*^9}, {
   3.498071646517518*^9, 3.4980716657211514`*^9}, {3.5154511467011385`*^9, 
   3.515451147301139*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Tanh", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Tanh", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "b", "*", "d", "*", "n"}], ")"}]}]}], " ", "+", " ", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "a"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Tanh", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.498070474665859*^9, 
   3.4980706418045526`*^9, 3.498070751347945*^9, 3.498071523433302*^9, {
   3.4980716301530895`*^9, 3.4980716358002987`*^9}, {3.4980766822826395`*^9, 
   3.498076685822644*^9}, {3.4980768335128508`*^9, 3.498076848172871*^9}, {
   3.498096752071793*^9, 3.4980967586218023`*^9}, {3.5154510808810463`*^9, 
   3.5154510855510526`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Coth", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Coth", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "b", "*", "d", "*", "n"}], ")"}]}]}], " ", "+", " ", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "a"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Coth", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.498070474665859*^9, 
   3.4980706418045526`*^9, 3.498070751347945*^9, 3.498071523433302*^9, {
   3.4980716301530895`*^9, 3.4980716358002987`*^9}, {3.4980766822826395`*^9, 
   3.498076685822644*^9}, {3.4980768335128508`*^9, 3.498076848172871*^9}, {
   3.498096752071793*^9, 3.4980967586218023`*^9}, {3.5154510808810463`*^9, 
   3.5154510855510526`*^9}, {3.515467751207539*^9, 3.515467760832756*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Tanh", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", "when", "  ", 
     SuperscriptBox["a", "2"]}]}], "+", 
   SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978201697549086`*^9, 3.4978201707449093`*^9}, 
   3.4980702555322742`*^9, 3.498070723969897*^9, {3.4981051466535454`*^9, 
   3.498105191173608*^9}, {3.4981052342736683`*^9, 3.498105236463671*^9}, {
   3.515624505896999*^9, 3.5156245156405563`*^9}, 3.515624873957051*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["\<\
Derivation: Algebraic expansion and integration by substitution\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, 3.4980702864359283`*^9, 
   3.4980719947257295`*^9, {3.498072604386001*^9, 3.4980726091908092`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Tanh", "[", "z", "]"}]}]}]], "=", 
   RowBox[{
    FractionBox["a", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}]], "-", 
    RowBox[{
     FractionBox["b", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["a", "2"], "-", 
         SuperscriptBox["b", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", " ", 
          RowBox[{"Cosh", "[", "z", "]"}]}], "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sinh", "[", "z", "]"}]}]}], ")"}]}]], 
     RowBox[{
      SubscriptBox["\[PartialD]", "z"], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", 
         RowBox[{"Cosh", "[", "z", "]"}]}], "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sinh", "[", "z", "]"}]}]}], ")"}]}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, {
   3.4980703053275614`*^9, 3.4980703053275614`*^9}, 3.4980720108405576`*^9, 
   3.4980725492711043`*^9, {3.498075132450469*^9, 3.4980751696205215`*^9}, {
   3.5156247271626544`*^9, 3.5156247271626544`*^9}, {3.515624776478475*^9, 
   3.5156248010308795`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.498070802032434*^9, 3.498070811704451*^9}, {
   3.4980708419217043`*^9, 3.498070859549735*^9}, {3.498071345530589*^9, 
   3.4980713485569944`*^9}, {3.4980714878184395`*^9, 3.498071509518077*^9}, {
   3.498071549142147*^9, 3.498071550234149*^9}, {3.498072028640189*^9, 
   3.4980720307929926`*^9}, {3.5156248238671856`*^9, 3.5156248238671856`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Tanh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"a", " ", "x"}], 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"]}]]}]}]}]}], "-", 
  FractionBox[
   RowBox[{"b", " ", 
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{"a", " ", 
       RowBox[{"Cosh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], "]"}]}], 
   RowBox[{"d", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}], ")"}]}]]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4980703789284906`*^9, 
   3.4980703957921205`*^9}, {3.4980704970362988`*^9, 3.498070514508329*^9}, 
   3.498070660243785*^9, {3.4980715799210005`*^9, 3.498071607267849*^9}, 
   3.498072121460352*^9, {3.5156247316689124`*^9, 3.515624745465701*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Tanh", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "*", 
     RowBox[{"x", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "-", 
        RowBox[{"b", "^", "2"}]}], ")"}]}]}], " ", "-", " ", 
    RowBox[{"b", "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{
        RowBox[{"a", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{"b", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.498070474665859*^9, 
   3.4980706418045526`*^9, 3.498070751347945*^9, 3.498071523433302*^9, 
   3.4980719583152657`*^9, 3.515624671628478*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Coth", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "*", 
     RowBox[{"x", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "-", 
        RowBox[{"b", "^", "2"}]}], ")"}]}]}], " ", "-", " ", 
    RowBox[{"b", "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{
        RowBox[{"b", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{"a", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.498070474665859*^9, 
   3.4980706418045526`*^9, 3.498070751347945*^9, 3.498071523433302*^9, 
   3.4980719583152657`*^9, {3.515624671628478*^9, 3.515624690559561*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      RowBox[{"Tanh", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Tanh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978201697549086`*^9, 3.4978201707449093`*^9}, 
   3.4980702555322742`*^9, 3.498070723969897*^9, 3.498080806427742*^9, {
   3.515472821700045*^9, 3.5154728232288475`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.4976636252234545`*^9, {3.4979864214265356`*^9, 
   3.497986422409337*^9}, {3.4979866389377174`*^9, 3.49798665193254*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"A", "+", 
     RowBox[{"B", " ", "z"}]}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "z"}]}]], "=", 
   RowBox[{
    FractionBox["B", "b"], "+", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"b", " ", "A"}], "-", 
       RowBox[{"a", " ", "B"}]}], "b"], 
     FractionBox["1", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "z"}]}]]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.497662667553373*^9, {3.4976642890046206`*^9, 3.497664308286255*^9}, {
   3.497664560788298*^9, 3.4976645733775206`*^9}, {3.4979867025546293`*^9, 
   3.4979867054094343`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"b", " ", "A"}], "-", 
    RowBox[{"a", " ", "B"}]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.497663553088928*^9, 3.4976635622149444`*^9}, {
   3.497989506094753*^9, 3.497989506094753*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Tanh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Tanh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"B", " ", "x"}], "b"]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"b", " ", "A"}], "-", 
     RowBox[{"a", " ", "B"}]}], "b"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Tanh", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.49766342891271*^9, 3.497663457772761*^9}, {
   3.497663580747777*^9, 3.497663583134581*^9}, {3.4979870210135884`*^9, 
   3.497987022604791*^9}, {3.4980814701286716`*^9, 3.4980814716686735`*^9}, {
   3.515472392980092*^9, 3.515472394150094*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"Tanh", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Tanh", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"B", "*", 
     RowBox[{"x", "/", "b"}]}], " ", "+", " ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "A"}], "-", 
         RowBox[{"a", "*", "B"}]}], ")"}], "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Tanh", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, {3.4979870291256027`*^9, 
   3.4979870422296257`*^9}, {3.497987678082342*^9, 3.497987689735563*^9}, {
   3.4979879183851643`*^9, 3.4979879218639708`*^9}, 3.497988073511837*^9, {
   3.4980814722486744`*^9, 3.4980814745386777`*^9}, {3.5154723954604964`*^9, 
   3.515472396848899*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"Coth", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Coth", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"B", "*", 
     RowBox[{"x", "/", "b"}]}], " ", "+", " ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "A"}], "-", 
         RowBox[{"a", "*", "B"}]}], ")"}], "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Coth", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, {3.4979870291256027`*^9, 
   3.4979870422296257`*^9}, {3.497987678082342*^9, 3.497987689735563*^9}, {
   3.4979879183851643`*^9, 3.4979879218639708`*^9}, 3.497988073511837*^9, {
   3.4980814722486744`*^9, 3.4980814745386777`*^9}, {3.5154723954604964`*^9, 
   3.515472396848899*^9}, {3.5154724659258204`*^9, 3.5154724671114225`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["\<\
Note: This rule does not appear in published integral tables.\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, 3.4980702864359283`*^9, 
   3.4980719947257295`*^9, {3.498072604386001*^9, 3.4980726091908092`*^9}, 
   3.4980731625081816`*^9, {3.4980735583132772`*^9, 3.498073601915354*^9}, {
   3.498268440932452*^9, 3.4982684501676683`*^9}, {3.5154725009166813`*^9, 
   3.5154725121955013`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["A", "2"], "-", 
    SuperscriptBox["B", "2"]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"b", " ", "A"}], "+", 
      RowBox[{"a", " ", "B"}]}], "\[NotEqual]", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.497663553088928*^9, 3.4976635622149444`*^9}, {
   3.497989506094753*^9, 3.497989506094753*^9}, {3.4981003938968916`*^9, 
   3.498100447736967*^9}, {3.515471915369653*^9, 3.515471915369653*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      RowBox[{"Tanh", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Tanh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"2", " ", "B"}], 
      RowBox[{"d", 
       SqrtBox[
        FractionBox[
         RowBox[{
          RowBox[{"b", " ", "A"}], "+", 
          RowBox[{"a", " ", "B"}]}], "B"]]}]]}]}], 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Tanh", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     SqrtBox[
      FractionBox[
       RowBox[{
        RowBox[{"b", " ", "A"}], "+", 
        RowBox[{"a", " ", "B"}]}], "B"]]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.49766342891271*^9, 3.497663457772761*^9}, {
   3.497663580747777*^9, 3.497663583134581*^9}, {3.4979870210135884`*^9, 
   3.497987022604791*^9}, {3.4980814701286716`*^9, 3.4980814716686735`*^9}, {
   3.498088567610335*^9, 3.498088569030337*^9}, {3.498099944956263*^9, 
   3.4980999588462825`*^9}, 3.4981003177167845`*^9, {3.498100574597144*^9, 
   3.498100575767146*^9}, 3.4981006307272234`*^9, {3.4981024279097395`*^9, 
   3.498102433119746*^9}, {3.5154717872154284`*^9, 3.5154718416751237`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"Tanh", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Tanh", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"2", "*", 
    RowBox[{"B", "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", "*", "A"}], "+", 
           RowBox[{"a", "*", "B"}]}], ")"}], "/", "B"}], "]"}]}], ")"}]}], 
    "*", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Tanh", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"Sqrt", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "*", "A"}], "+", 
          RowBox[{"a", "*", "B"}]}], ")"}], "/", "B"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"A", "^", "2"}], "-", 
      RowBox[{"B", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "+", 
      RowBox[{"a", "*", "B"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, {3.4979870291256027`*^9, 
   3.4979870422296257`*^9}, {3.497987678082342*^9, 3.497987689735563*^9}, {
   3.4979879183851643`*^9, 3.4979879218639708`*^9}, 3.497988073511837*^9, {
   3.4980814722486744`*^9, 3.4980814745386777`*^9}, {3.4980885717903404`*^9, 
   3.4980885727603416`*^9}, 3.4980999141262197`*^9, {3.498099969096297*^9, 
   3.4980999725163016`*^9}, 3.4981002818167343`*^9, {3.498100453306975*^9, 
   3.498100470426999*^9}, {3.498100576217147*^9, 3.4981006172772045`*^9}, {
   3.4981025330998864`*^9, 3.4981025471699057`*^9}, {3.4981026049199867`*^9, 
   3.498102616510003*^9}, 3.5154717701801977`*^9, {3.5154718090710664`*^9, 
   3.515471811785471*^9}, 3.5154719869581785`*^9, {3.515472211926174*^9, 
   3.515472248898239*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"Coth", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Coth", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"2", "*", 
    RowBox[{"B", "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", "*", "A"}], "+", 
           RowBox[{"a", "*", "B"}]}], ")"}], "/", "B"}], "]"}]}], ")"}]}], 
    "*", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Coth", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"Sqrt", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "*", "A"}], "+", 
          RowBox[{"a", "*", "B"}]}], ")"}], "/", "B"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"A", "^", "2"}], "-", 
      RowBox[{"B", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "+", 
      RowBox[{"a", "*", "B"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, {3.4979870291256027`*^9, 
   3.4979870422296257`*^9}, {3.497987678082342*^9, 3.497987689735563*^9}, {
   3.4979879183851643`*^9, 3.4979879218639708`*^9}, 3.497988073511837*^9, {
   3.4980814722486744`*^9, 3.4980814745386777`*^9}, {3.4980885717903404`*^9, 
   3.4980885727603416`*^9}, 3.4980999141262197`*^9, {3.498099969096297*^9, 
   3.4980999725163016`*^9}, 3.4981002818167343`*^9, {3.498100453306975*^9, 
   3.498100470426999*^9}, {3.498100576217147*^9, 3.4981006172772045`*^9}, {
   3.4981025330998864`*^9, 3.4981025471699057`*^9}, {3.4981026049199867`*^9, 
   3.498102616510003*^9}, 3.5154717701801977`*^9, {3.5154718090710664`*^9, 
   3.515471811785471*^9}, 3.5154719869581785`*^9, {3.515472211926174*^9, 
   3.515472248898239*^9}, {3.5154722862135043`*^9, 3.5154722892087097`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.4976636252234545`*^9, {3.4979864214265356`*^9, 
   3.497986422409337*^9}, {3.4979866389377174`*^9, 3.49798665193254*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"A", "+", 
    RowBox[{"B", " ", "z"}]}], "=", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"A", "+", "B"}], "2"], 
     RowBox[{"(", 
      RowBox[{"1", "+", "z"}], ")"}]}], "+", 
    RowBox[{
     FractionBox[
      RowBox[{"A", "-", "B"}], "2"], 
     RowBox[{"(", 
      RowBox[{"1", "-", "z"}], ")"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.497662667553373*^9, {3.4976642890046206`*^9, 3.497664308286255*^9}, {
   3.497664560788298*^9, 3.4976645733775206`*^9}, {3.4979867025546293`*^9, 
   3.4979867054094343`*^9}, {3.498101324428194*^9, 3.4981013957682943`*^9}, {
   3.498101979199111*^9, 3.4981019924691296`*^9}, {3.4981020789292507`*^9, 
   3.4981020825392556`*^9}, {3.515472589431237*^9, 3.5154726013964577`*^9}, 
   3.515472632736913*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["A", "2"], "-", 
     SuperscriptBox["B", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.497663553088928*^9, 3.4976635622149444`*^9}, {
   3.497989506094753*^9, 3.497989506094753*^9}, {3.4981003938968916`*^9, 
   3.498100447736967*^9}, {3.498101272608122*^9, 3.498101274498124*^9}, {
   3.49810677153582*^9, 3.498106773915824*^9}, {3.498107237646473*^9, 
   3.498107255636498*^9}, {3.515472653048149*^9, 3.515472653048149*^9}, {
   3.515718154996721*^9, 3.515718164122737*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Tanh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Tanh", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"A", "+", "B"}], "2"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{"1", "+", 
        RowBox[{"Tanh", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Tanh", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"A", "-", "B"}], "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"1", "-", 
       RowBox[{"Tanh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Tanh", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.49766342891271*^9, 3.497663457772761*^9}, {
   3.497663580747777*^9, 3.497663583134581*^9}, {3.4979870210135884`*^9, 
   3.497987022604791*^9}, {3.4980814701286716`*^9, 3.4980814716686735`*^9}, {
   3.498088567610335*^9, 3.498088569030337*^9}, {3.498099944956263*^9, 
   3.4980999588462825`*^9}, 3.4981003177167845`*^9, {3.498100574597144*^9, 
   3.498100575767146*^9}, 3.4981006307272234`*^9, 3.4981015477985067`*^9, {
   3.4981020562392187`*^9, 3.498102108559292*^9}, {3.515472672704183*^9, 
   3.515472700987033*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"Tanh", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Tanh", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"A", "+", "B"}], ")"}], "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"Tanh", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}], "/", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Tanh", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ",", "x"}], 
       "]"}]}], "]"}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"A", "-", "B"}], ")"}], "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"Tanh", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}], "/", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Tanh", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"A", "^", "2"}], "-", 
      RowBox[{"B", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, {3.4979870291256027`*^9, 
   3.4979870422296257`*^9}, {3.497987678082342*^9, 3.497987689735563*^9}, {
   3.4979879183851643`*^9, 3.4979879218639708`*^9}, 3.497988073511837*^9, {
   3.4980814722486744`*^9, 3.4980814745386777`*^9}, {3.4980885717903404`*^9, 
   3.4980885727603416`*^9}, 3.4980999141262197`*^9, {3.498099969096297*^9, 
   3.4980999725163016`*^9}, 3.4981002818167343`*^9, {3.498100453306975*^9, 
   3.498100470426999*^9}, {3.498100576217147*^9, 3.4981006172772045`*^9}, {
   3.49810127884813*^9, 3.498101282508136*^9}, {3.498101437188352*^9, 
   3.4981015039784455`*^9}, {3.4981020126791577`*^9, 3.4981020467392054`*^9}, 
   3.4981067630058084`*^9, 3.4982737682830124`*^9, {3.515472675886589*^9, 
   3.5154726776181917`*^9}, {3.515472726695878*^9, 3.5154727507355204`*^9}, {
   3.515472784166379*^9, 3.5154727946183977`*^9}, {3.5157182786581383`*^9, 
   3.515718283915347*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"Coth", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Coth", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"A", "+", "B"}], ")"}], "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"Coth", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}], "/", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Coth", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ",", "x"}], 
       "]"}]}], "]"}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"A", "-", "B"}], ")"}], "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"Coth", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}], "/", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Coth", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"A", "^", "2"}], "-", 
      RowBox[{"B", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, {3.4979870291256027`*^9, 
   3.4979870422296257`*^9}, {3.497987678082342*^9, 3.497987689735563*^9}, {
   3.4979879183851643`*^9, 3.4979879218639708`*^9}, 3.497988073511837*^9, {
   3.4980814722486744`*^9, 3.4980814745386777`*^9}, {3.4980885717903404`*^9, 
   3.4980885727603416`*^9}, 3.4980999141262197`*^9, {3.498099969096297*^9, 
   3.4980999725163016`*^9}, 3.4981002818167343`*^9, {3.498100453306975*^9, 
   3.498100470426999*^9}, {3.498100576217147*^9, 3.4981006172772045`*^9}, {
   3.49810127884813*^9, 3.498101282508136*^9}, {3.498101437188352*^9, 
   3.4981015039784455`*^9}, {3.4981020126791577`*^9, 3.4981020467392054`*^9}, 
   3.4981067630058084`*^9, 3.4982737682830124`*^9, {3.515472675886589*^9, 
   3.5154726776181917`*^9}, {3.515472726695878*^9, 3.5154727507355204`*^9}, {
   3.515472784166379*^9, 3.5154727946183977`*^9}, {3.5157182786581383`*^9, 
   3.515718283915347*^9}, {3.5157184496636386`*^9, 3.515718452658844*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["\<\
Note: This rule does not appear in published integral tables.\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, 3.4980702864359283`*^9, 
   3.4980719947257295`*^9, {3.498072604386001*^9, 3.4980726091908092`*^9}, 
   3.4980731625081816`*^9, {3.4980735583132772`*^9, 3.498073601915354*^9}, {
   3.498268440932452*^9, 3.4982684501676683`*^9}, {3.5154725009166813`*^9, 
   3.5154725121955013`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", ">", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.498070802032434*^9, 3.498070811704451*^9}, {
   3.4980708419217043`*^9, 3.498070859549735*^9}, {3.498071345530589*^9, 
   3.4980713485569944`*^9}, {3.4980714878184395`*^9, 3.498071509518077*^9}, {
   3.498071549142147*^9, 3.498071550234149*^9}, {3.4980808830178494`*^9, 
   3.49808089042786*^9}, {3.498081862709221*^9, 3.4980819102692876`*^9}, {
   3.498081960409358*^9, 3.4980819728493752`*^9}, {3.4980821660196457`*^9, 
   3.4980821794396644`*^9}, {3.498092226315457*^9, 3.4980922280854597`*^9}, {
   3.4980923940856915`*^9, 3.498092394385692*^9}, {3.498268054332573*^9, 
   3.4982680551905746`*^9}, {3.4982686482256165`*^9, 3.498268649224018*^9}, {
   3.4982690163654633`*^9, 3.498269021841073*^9}, {3.5154700493879757`*^9, 
   3.5154700532723827`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Tanh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Tanh", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"B", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             RowBox[{"Tanh", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"]}], 
        RowBox[{"d", " ", "n"}]]}]}]}]}]}], "+", 
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", " ", "A"}], "+", 
      RowBox[{"b", " ", "B"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", " ", "A"}], "+", 
         RowBox[{"a", " ", "B"}]}], ")"}], " ", 
       RowBox[{"Tanh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Tanh", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     RowBox[{"n", "-", "1"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4980703789284906`*^9, 
   3.4980703957921205`*^9}, {3.4980704970362988`*^9, 3.498070514508329*^9}, 
   3.498070660243785*^9, {3.4980715799210005`*^9, 3.498071607267849*^9}, {
   3.4980808337377806`*^9, 3.498080874807838*^9}, {3.4980885732403426`*^9, 
   3.498088575040345*^9}, {3.498088682050495*^9, 3.4980886848104987`*^9}, {
   3.498092099145279*^9, 3.4980921196753073`*^9}, {3.498092352165633*^9, 
   3.4980923544556365`*^9}, {3.498097017792165*^9, 3.4980970259621763`*^9}, {
   3.5154700816020327`*^9, 3.5154700864224405`*^9}, {3.5154701620981736`*^9, 
   3.5154701685877852`*^9}, {3.515470212252262*^9, 3.5154702227510805`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"Tanh", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Tanh", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_."}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "B"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Tanh", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", "n"}], ")"}]}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "*", "A"}], "+", 
         RowBox[{"b", "*", "B"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"b", "*", "A"}], "+", 
            RowBox[{"a", "*", "B"}]}], ")"}], "*", 
          RowBox[{"Tanh", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Tanh", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.498070474665859*^9, 
   3.4980706418045526`*^9, 3.498070751347945*^9, 3.498071523433302*^9, {
   3.4980809095578866`*^9, 3.498080941807932*^9}, {3.4980810458480773`*^9, 
   3.4980810932281437`*^9}, {3.4980811276581917`*^9, 3.498081149448222*^9}, {
   3.498081555788791*^9, 3.498081557508794*^9}, 3.498082148569621*^9, {
   3.498086507241523*^9, 3.498086508364725*^9}, {3.4980885755203457`*^9, 
   3.4980885784703503`*^9}, 3.4980886918505087`*^9, {3.4980923635756493`*^9, 
   3.4980923774756684`*^9}, {3.4980924075357103`*^9, 3.498092408975713*^9}, {
   3.498092511735856*^9, 3.4980925149858613`*^9}, {3.4980970201821685`*^9, 
   3.4980970218021708`*^9}, 3.49809706448223*^9, {3.4981066332956266`*^9, 
   3.4981066355556297`*^9}, {3.498267968594823*^9, 3.498267969452824*^9}, {
   3.498268676336866*^9, 3.498268678224469*^9}, {3.515470058092791*^9, 
   3.515470062710399*^9}, {3.5154706794262824`*^9, 3.515470721983157*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"Coth", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Coth", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_."}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "B"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Coth", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", "n"}], ")"}]}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "*", "A"}], "+", 
         RowBox[{"b", "*", "B"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"b", "*", "A"}], "+", 
            RowBox[{"a", "*", "B"}]}], ")"}], "*", 
          RowBox[{"Coth", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Coth", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.498070474665859*^9, 
   3.4980706418045526`*^9, 3.498070751347945*^9, 3.498071523433302*^9, {
   3.4980809095578866`*^9, 3.498080941807932*^9}, {3.4980810458480773`*^9, 
   3.4980810932281437`*^9}, {3.4980811276581917`*^9, 3.498081149448222*^9}, {
   3.498081555788791*^9, 3.498081557508794*^9}, 3.498082148569621*^9, {
   3.498086507241523*^9, 3.498086508364725*^9}, {3.4980885755203457`*^9, 
   3.4980885784703503`*^9}, 3.4980886918505087`*^9, {3.4980923635756493`*^9, 
   3.4980923774756684`*^9}, {3.4980924075357103`*^9, 3.498092408975713*^9}, {
   3.498092511735856*^9, 3.4980925149858613`*^9}, {3.4980970201821685`*^9, 
   3.4980970218021708`*^9}, 3.49809706448223*^9, {3.4981066332956266`*^9, 
   3.4981066355556297`*^9}, {3.498267968594823*^9, 3.498267969452824*^9}, {
   3.498268676336866*^9, 3.498268678224469*^9}, {3.515470058092791*^9, 
   3.515470062710399*^9}, {3.5154706794262824`*^9, 3.515470721983157*^9}, {
   3.515470806909706*^9, 3.515470808734909*^9}, {3.515470855098191*^9, 
   3.5154708848318434`*^9}, {3.5154709241751122`*^9, 3.5154709299471226`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["\<\
Note: This rule does not appear in published integral tables.\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, 3.4980702864359283`*^9, 
   3.4980719947257295`*^9, {3.498072604386001*^9, 3.4980726091908092`*^9}, 
   3.4980731625081816`*^9, {3.4980735583132772`*^9, 3.498073601915354*^9}, {
   3.498268440932452*^9, 3.4982684501676683`*^9}, {3.5154725009166813`*^9, 
   3.5154725121955013`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"n", "<", 
    RowBox[{"-", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.498070802032434*^9, 3.498070811704451*^9}, {
   3.4980708419217043`*^9, 3.498070859549735*^9}, {3.498071345530589*^9, 
   3.4980713485569944`*^9}, {3.4980714878184395`*^9, 3.498071509518077*^9}, {
   3.498071549142147*^9, 3.498071550234149*^9}, {3.4980808830178494`*^9, 
   3.49808089042786*^9}, {3.498081862709221*^9, 3.4980819102692876`*^9}, {
   3.498081960409358*^9, 3.4980819728493752`*^9}, {3.4980821660196457`*^9, 
   3.4980821794396644`*^9}, {3.498096948612068*^9, 3.498096949272069*^9}, {
   3.4982682211748667`*^9, 3.49826822337447*^9}, {3.498268256852129*^9, 
   3.4982682583965316`*^9}, {3.5154702835755873`*^9, 
   3.5154702835755873`*^9}, {3.515471578877062*^9, 3.515471579407463*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Tanh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Tanh", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", " ", "A"}], "-", 
           RowBox[{"a", " ", "B"}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             RowBox[{"Tanh", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
          RowBox[{"n", "+", "1"}]]}], 
        RowBox[{"d", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["b", "2"]}], ")"}], 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", "A"}], "-", 
       RowBox[{"b", " ", "B"}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "A"}], "-", 
          RowBox[{"a", " ", "B"}]}], ")"}], " ", 
        RowBox[{"Tanh", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Tanh", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4980703789284906`*^9, 
   3.4980703957921205`*^9}, {3.4980704970362988`*^9, 3.498070514508329*^9}, 
   3.498070660243785*^9, {3.4980715799210005`*^9, 3.498071607267849*^9}, {
   3.4980808337377806`*^9, 3.498080874807838*^9}, {3.4980885732403426`*^9, 
   3.498088575040345*^9}, {3.498088682050495*^9, 3.4980886848104987`*^9}, {
   3.498092099145279*^9, 3.4980921196753073`*^9}, {3.498092352165633*^9, 
   3.4980923544556365`*^9}, {3.498097017792165*^9, 3.4980970259621763`*^9}, {
   3.5154700816020327`*^9, 3.5154700864224405`*^9}, {3.5154701620981736`*^9, 
   3.5154701685877852`*^9}, {3.515470212252262*^9, 3.5154702227510805`*^9}, {
   3.5154710131108685`*^9, 3.5154710366201096`*^9}, {3.515471081953789*^9, 
   3.515471138566289*^9}, {3.5154712288124475`*^9, 3.5154714038291545`*^9}, {
   3.5154715363201876`*^9, 3.51547153805179*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"Tanh", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Tanh", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "*", "A"}], "-", 
        RowBox[{"a", "*", "B"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Tanh", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}]}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "-", 
         RowBox[{"b", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "*", "A"}], "-", 
           RowBox[{"b", "*", "B"}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"b", "*", "A"}], "-", 
              RowBox[{"a", "*", "B"}]}], ")"}], "*", 
            RowBox[{"Tanh", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"Tanh", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.498070474665859*^9, 
   3.4980706418045526`*^9, 3.498070751347945*^9, 3.498071523433302*^9, {
   3.4980809095578866`*^9, 3.498080941807932*^9}, {3.4980810458480773`*^9, 
   3.4980810932281437`*^9}, {3.4980811276581917`*^9, 3.498081149448222*^9}, {
   3.498081555788791*^9, 3.498081557508794*^9}, 3.498082148569621*^9, {
   3.498086507241523*^9, 3.498086508364725*^9}, {3.4980969246820345`*^9, 
   3.4980969259820366`*^9}, {3.4981065724855413`*^9, 
   3.4981065748355446`*^9}, {3.498268245042908*^9, 3.4982682472893124`*^9}, 
   3.5154714443736258`*^9, {3.5154715095349407`*^9, 3.515471527069371*^9}, 
   3.5154715750394554`*^9, {3.515471610779118*^9, 3.5154716125263214`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"Coth", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Coth", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "*", "A"}], "-", 
        RowBox[{"a", "*", "B"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Coth", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}]}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "-", 
         RowBox[{"b", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "*", "A"}], "-", 
           RowBox[{"b", "*", "B"}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"b", "*", "A"}], "-", 
              RowBox[{"a", "*", "B"}]}], ")"}], "*", 
            RowBox[{"Coth", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"Coth", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.498070474665859*^9, 
   3.4980706418045526`*^9, 3.498070751347945*^9, 3.498071523433302*^9, {
   3.4980809095578866`*^9, 3.498080941807932*^9}, {3.4980810458480773`*^9, 
   3.4980810932281437`*^9}, {3.4980811276581917`*^9, 3.498081149448222*^9}, {
   3.498081555788791*^9, 3.498081557508794*^9}, 3.498082148569621*^9, {
   3.498086507241523*^9, 3.498086508364725*^9}, {3.4980969246820345`*^9, 
   3.4980969259820366`*^9}, {3.4981065724855413`*^9, 
   3.4981065748355446`*^9}, {3.498268245042908*^9, 3.4982682472893124`*^9}, 
   3.5154714443736258`*^9, {3.5154715095349407`*^9, 3.515471527069371*^9}, 
   3.5154715750394554`*^9, {3.515471610779118*^9, 3.5154716125263214`*^9}, {
   3.51547164601958*^9, 3.515471648312784*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Tan", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978201697549086`*^9, 3.4978201707449093`*^9}, 
   3.4980702555322742`*^9, 3.498070723969897*^9, 3.4980719389556313`*^9, 
   3.4980726319200497`*^9, {3.4988884107361507`*^9, 3.498888431017311*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, 3.4980702864359283`*^9, 
   3.4983206021865325`*^9, 3.498336379671563*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "-", "b"}], "=", "0"}]]],
 ", then  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"b", " ", 
     SuperscriptBox[
      RowBox[{"Tan", "[", "z", "]"}], "2"]}]}], "=", 
   RowBox[{"b", " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", "z", "]"}], "2"]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, {
   3.4980703053275614`*^9, 3.4980703053275614`*^9}, {3.4983206471458116`*^9, 
   3.4983206654446435`*^9}, {3.4983363975959945`*^9, 3.4983364187184315`*^9}, 
   3.498336544688653*^9, {3.4988871530692167`*^9, 3.498887164755885*^9}, {
   3.498887228386524*^9, 3.4988872314487*^9}, {3.49888727673629*^9, 
   3.4988872791254263`*^9}, 3.498888444581087*^9, {3.4988884854944267`*^9, 
   3.498888510459855*^9}}],

Cell[TextData[{
 "Rule: ",
 "If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "-", "b"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4983365404610453`*^9, 3.498336572612702*^9}, {
   3.4988873903157864`*^9, 3.498887396069115*^9}, 3.49888851388105*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Tan", "[", "v", "]"}], "2"]}]}], ")"}], "m"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     SuperscriptBox["b", "m"]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{"u", " ", 
     SuperscriptBox[
      RowBox[{"Sec", "[", "v", "]"}], 
      RowBox[{"2", "m"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.498070321988391*^9, 
   3.498070327557601*^9}, {3.4983205558700514`*^9, 3.4983205610648603`*^9}, 
   3.498336457110099*^9, {3.498336504112982*^9, 3.498336507076987*^9}, 
   3.4988870875554695`*^9, {3.498887425032772*^9, 3.4988874530183725`*^9}, {
   3.498887531861882*^9, 3.498887558849426*^9}, {3.4988877813521523`*^9, 
   3.498887783848295*^9}, 3.4988884450641146`*^9, {3.49888854306172*^9, 
   3.4988885437797604`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"Tan", "[", "v_", "]"}], "^", "2"}]}]}], ")"}], "^", 
      "m_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"b", "^", "m"}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{
         RowBox[{"Sec", "[", "v", "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"2", "*", "m"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"a", "-", "b"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.498070271459902*^9, 
   3.4983205373216186`*^9, 3.4983363703739467`*^9, {3.4988870949248905`*^9, 
   3.4988871260116687`*^9}, {3.4988873078350687`*^9, 
   3.4988873773550453`*^9}, {3.4988875045363193`*^9, 
   3.4988875061614122`*^9}, {3.4988876000257807`*^9, 3.498887611762452*^9}, {
   3.498887747166197*^9, 3.498887757063763*^9}, 3.4988884462561827`*^9, {
   3.4988885024593973`*^9, 3.498888503021429*^9}, {3.4988885620278044`*^9, 
   3.498888562848851*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, 3.4980702864359283`*^9, 
   3.4983206021865325`*^9, 3.498336379671563*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "-", "b"}], "=", "0"}]]],
 ", then  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"b", " ", 
     SuperscriptBox[
      RowBox[{"Tan", "[", "z", "]"}], "2"]}]}], "=", 
   RowBox[{"b", " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", "z", "]"}], "2"]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, {
   3.4980703053275614`*^9, 3.4980703053275614`*^9}, {3.4983206471458116`*^9, 
   3.4983206654446435`*^9}, {3.4983363975959945`*^9, 3.4983364187184315`*^9}, 
   3.498336544688653*^9, {3.4988871530692167`*^9, 3.498887164755885*^9}, {
   3.498887228386524*^9, 3.4988872314487*^9}, {3.49888727673629*^9, 
   3.4988872791254263`*^9}, 3.4988884469612226`*^9, {3.498888576149612*^9, 
   3.498888590346424*^9}}],

Cell[TextData[{
 "Rule: ",
 "If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "-", "b"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"m", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4983365404610453`*^9, 3.498336572612702*^9}, {
   3.4988873903157864`*^9, 3.498887396069115*^9}, 3.4988885920735226`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Tan", "[", "v", "]"}], "2"]}]}], ")"}], "m"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{"u", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"b", " ", 
          SuperscriptBox[
           RowBox[{"Sec", "[", "v", "]"}], "2"]}], ")"}], "m"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.498070321988391*^9, 
   3.498070327557601*^9}, {3.4983205558700514`*^9, 3.4983205610648603`*^9}, 
   3.498336457110099*^9, {3.498336504112982*^9, 3.498336507076987*^9}, 
   3.4988870875554695`*^9, {3.498887425032772*^9, 3.4988874530183725`*^9}, 
   3.4988884475612574`*^9, {3.4988886245833826`*^9, 3.4988886250654097`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"Tan", "[", "v_", "]"}], "^", "2"}]}]}], ")"}], "^", 
      "m_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"u", "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{
          RowBox[{"Sec", "[", "v", "]"}], "^", "2"}]}], ")"}], "^", "m"}]}], 
     ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"a", "-", "b"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", "m", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.498070271459902*^9, 
   3.4983205373216186`*^9, 3.4983363703739467`*^9, {3.4988870949248905`*^9, 
   3.4988871260116687`*^9}, {3.4988873078350687`*^9, 3.4988873773550453`*^9}, 
   3.4988884489453363`*^9, {3.4988885945216627`*^9, 3.498888603148156*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", "b"}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.498070802032434*^9, 3.498070811704451*^9}, {
   3.4980708419217043`*^9, 3.498070859549735*^9}, {3.498072042274613*^9, 
   3.498072055285036*^9}, {3.515468498058851*^9, 3.515468498058851*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Tanh", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["x", 
       RowBox[{"a", "+", "b"}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    SqrtBox["b"], 
    RowBox[{
     SqrtBox["a"], " ", "d", " ", 
     RowBox[{"(", 
      RowBox[{"a", "+", "b"}], ")"}]}]], 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{
      SqrtBox["b"], " ", 
      RowBox[{"Tanh", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}], 
     SqrtBox["a"]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.498070321988391*^9, 
   3.498070327557601*^9}, 3.4980709163338346`*^9, {3.4980711071777706`*^9, 
   3.498071117738989*^9}, {3.498072713788993*^9, 3.4980727224158087`*^9}, {
   3.5154683902938614`*^9, 3.515468395691471*^9}, {3.5154684711488037`*^9, 
   3.5154684797912188`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"Tanh", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "2"}]}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "/", 
     RowBox[{"(", 
      RowBox[{"a", "+", "b"}], ")"}]}], " ", "+", " ", 
    RowBox[{
     RowBox[{"Sqrt", "[", "b", "]"}], "*", 
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{
        RowBox[{"Sqrt", "[", "b", "]"}], "*", 
        RowBox[{
         RowBox[{"Tanh", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "/", 
         RowBox[{"Sqrt", "[", "a", "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sqrt", "[", "a", "]"}], "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{"a", "+", "b"}], ")"}]}], ")"}]}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"a", "+", "b"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.498070271459902*^9, 
   3.4980707653567696`*^9, {3.498070972259933*^9, 3.4980709751771383`*^9}, 
   3.4980719640716753`*^9, {3.515468379015042*^9, 3.515468402415083*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"Coth", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "2"}]}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "/", 
     RowBox[{"(", 
      RowBox[{"a", "+", "b"}], ")"}]}], " ", "+", " ", 
    RowBox[{
     RowBox[{"Sqrt", "[", "b", "]"}], "*", 
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{
        RowBox[{"Sqrt", "[", "b", "]"}], "*", 
        RowBox[{
         RowBox[{"Coth", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "/", 
         RowBox[{"Sqrt", "[", "a", "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sqrt", "[", "a", "]"}], "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{"a", "+", "b"}], ")"}]}], ")"}]}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"a", "+", "b"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.498070271459902*^9, 
   3.4980707653567696`*^9, {3.498070972259933*^9, 3.4980709751771383`*^9}, 
   3.4980719640716753`*^9, {3.515468379015042*^9, 3.515468402415083*^9}, {
   3.515468566995372*^9, 3.5154685786017923`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"Tanh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}], "p"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978201697549086`*^9, 3.4978201707449093`*^9}, 
   3.4980702555322742`*^9, 3.498070723969897*^9, 3.4980719389556313`*^9, 
   3.4980726319200497`*^9, 3.498072984699069*^9, 3.515469532512268*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, 3.4980702864359283`*^9, 
   3.4980719947257295`*^9, {3.498072604386001*^9, 3.4980726091908092`*^9}, 
   3.4980731625081816`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Tanh", "[", "z", "]"}], "=", 
   RowBox[{"1", "-", 
    FractionBox["2", 
     RowBox[{"1", "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", "z"}]]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, {
   3.4980703053275614`*^9, 3.4980703053275614`*^9}, 3.4980720108405576`*^9, 
   3.4980725492711043`*^9, 3.498073175128604*^9, {3.5154687086436205`*^9, 
   3.515468723619647*^9}, {3.5154688600730867`*^9, 3.5154688600730867`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"m", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"m", "-", "n", "+", "1"}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.498070802032434*^9, 3.498070811704451*^9}, {
   3.4980708419217043`*^9, 3.498070859549735*^9}, {3.498072042274613*^9, 
   3.498072055285036*^9}, {3.498073052465588*^9, 3.498073079297635*^9}, {
   3.4980732240814896`*^9, 3.4980732251890917`*^9}, {3.515468845970662*^9, 
   3.515468853879876*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"Tanh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       SuperscriptBox["x", 
        RowBox[{"m", "+", "1"}]], 
       RowBox[{"m", "+", "1"}]]}]}]}]}], "-", 
  RowBox[{"2", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox["x", "m"], 
      RowBox[{"1", "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"2", "a"}], "+", 
         RowBox[{"2", "b", " ", 
          SuperscriptBox["x", "n"]}]}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.498070321988391*^9, 
   3.498070327557601*^9}, 3.4980709163338346`*^9, {3.4980711071777706`*^9, 
   3.498071117738989*^9}, {3.498072713788993*^9, 3.4980727224158087`*^9}, 
   3.498072987569474*^9, {3.498073018332728*^9, 3.4980730264915423`*^9}, {
   3.498073130278525*^9, 3.4980731356917343`*^9}, {3.515468881023924*^9, 
   3.5154689567776566`*^9}, 3.5154690565086317`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"Tanh", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}], " ", "-", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{"2", ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "/", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"E", "^", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", "*", "a"}], "+", 
              RowBox[{"2", "*", "b", "*", 
               RowBox[{"x", "^", "n"}]}]}], ")"}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "-", "n", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.498070271459902*^9, 
   3.4980707653567696`*^9, {3.498070972259933*^9, 3.4980709751771383`*^9}, 
   3.4980719640716753`*^9, 3.4980729980058928`*^9, {3.498073376212957*^9, 
   3.4980733779913597`*^9}, {3.5154687911209655`*^9, 
   3.5154688077193947`*^9}, {3.5154688378118477`*^9, 3.51546883901305*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"Coth", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}], " ", "-", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{"2", ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "/", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"E", "^", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", "*", "a"}], "+", 
              RowBox[{"2", "*", "b", "*", 
               RowBox[{"x", "^", "n"}]}]}], ")"}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "-", "n", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.498070271459902*^9, 
   3.4980707653567696`*^9, {3.498070972259933*^9, 3.4980709751771383`*^9}, 
   3.4980719640716753`*^9, 3.4980729980058928`*^9, {3.498073376212957*^9, 
   3.4980733779913597`*^9}, {3.5154687911209655`*^9, 
   3.5154688077193947`*^9}, {3.5154688378118477`*^9, 3.51546883901305*^9}, 
   3.515469471890561*^9, {3.5154695112806306`*^9, 3.515469519470645*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["\<\
Note: This rule does not appear in published integral tables.\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, 3.4980702864359283`*^9, 
   3.4980719947257295`*^9, {3.498072604386001*^9, 3.4980726091908092`*^9}, 
   3.4980731625081816`*^9, {3.4980735583132772`*^9, 3.498073601915354*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"p", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"m", "-", "n", "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", 
   " ", 
   RowBox[{"0", "<", "n", "\[LessEqual]", "m"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.498070802032434*^9, 3.498070811704451*^9}, {
   3.4980708419217043`*^9, 3.498070859549735*^9}, {3.498072042274613*^9, 
   3.498072055285036*^9}, {3.498073052465588*^9, 3.498073079297635*^9}, {
   3.4980732240814896`*^9, 3.4980732251890917`*^9}, {3.498073490999159*^9, 
   3.498073513135598*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"Tanh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], "]"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox["x", 
          RowBox[{"m", "-", "n", "+", "1"}]], " ", 
         SuperscriptBox[
          RowBox[{"Tanh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox["x", "n"]}]}], "]"}], 
          RowBox[{"p", "-", "1"}]]}], 
        RowBox[{"b", " ", "n", " ", 
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox[
    RowBox[{"m", "-", "n", "+", "1"}], 
    RowBox[{"b", " ", "n", " ", 
     RowBox[{"(", 
      RowBox[{"p", "-", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "n"}]], " ", 
     SuperscriptBox[
      RowBox[{"Tanh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], "]"}], 
      RowBox[{"p", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "+", 
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"Tanh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], "]"}], 
     RowBox[{"p", "-", "2"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.498070321988391*^9, 
   3.498070327557601*^9}, 3.4980709163338346`*^9, {3.4980711071777706`*^9, 
   3.498071117738989*^9}, {3.498072713788993*^9, 3.4980727224158087`*^9}, 
   3.498072987569474*^9, {3.498073018332728*^9, 3.4980730264915423`*^9}, {
   3.498073130278525*^9, 3.4980731356917343`*^9}, 3.4980734706411233`*^9, 
   3.498073536410839*^9, {3.4980741369390755`*^9, 3.4980741506490946`*^9}, {
   3.4980742559992423`*^9, 3.498074256429243*^9}, {3.5154691527764006`*^9, 
   3.5154691581428103`*^9}, {3.515469225737729*^9, 3.515469258388586*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Tanh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], "]"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"m", "-", "n", "+", "1"}], ")"}]}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Tanh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", 
        RowBox[{"(", 
         RowBox[{"p", "-", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "n", "+", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", "n", "*", 
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "n"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Tanh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "+", " ", "\n", "  ", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "m"}], "*", 
       RowBox[{
        RowBox[{"Tanh", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
        RowBox[{"(", 
         RowBox[{"p", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n", ",", "p"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "1"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "-", "n", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"0", "<", "n", "<=", "m"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.498070271459902*^9, 
   3.4980707653567696`*^9, {3.498070972259933*^9, 3.4980709751771383`*^9}, 
   3.4980719640716753`*^9, 3.4980729980058928`*^9, {3.498073376212957*^9, 
   3.4980733779913597`*^9}, 3.4980734370230646`*^9, 3.5154692072984962`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Coth", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], "]"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"m", "-", "n", "+", "1"}], ")"}]}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Coth", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", 
        RowBox[{"(", 
         RowBox[{"p", "-", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "n", "+", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", "n", "*", 
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "n"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Coth", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "+", " ", "\n", "  ", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "m"}], "*", 
       RowBox[{
        RowBox[{"Coth", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
        RowBox[{"(", 
         RowBox[{"p", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n", ",", "p"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "1"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "-", "n", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"0", "<", "n", "<=", "m"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.498070271459902*^9, 
   3.4980707653567696`*^9, {3.498070972259933*^9, 3.4980709751771383`*^9}, 
   3.4980719640716753`*^9, 3.4980729980058928`*^9, {3.498073376212957*^9, 
   3.4980733779913597`*^9}, 3.4980734370230646`*^9, 3.5154692072984962`*^9, 
   3.5154694827481804`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   RowBox[{"Tanh", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", "2"]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978201697549086`*^9, 3.4978201707449093`*^9}, 
   3.4980702555322742`*^9, 3.498070723969897*^9, 3.4980719389556313`*^9, 
   3.4980726319200497`*^9, 3.498072984699069*^9, 3.498073709555543*^9, 
   3.5154699024357176`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.498070802032434*^9, 3.498070811704451*^9}, {
   3.4980708419217043`*^9, 3.498070859549735*^9}, {3.498072042274613*^9, 
   3.498072055285036*^9}, {3.498073052465588*^9, 3.498073079297635*^9}, {
   3.4980732240814896`*^9, 3.4980732251890917`*^9}, 3.498073933150736*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{"x", " ", 
    RowBox[{"Tanh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"Log", "[", 
        RowBox[{"Cosh", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}], "+", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", "2"]}]}], "]"}], "]"}], 
       RowBox[{"2", " ", "c"}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox["b", 
    RowBox[{"2", " ", "c"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"Tanh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.498070321988391*^9, 
   3.498070327557601*^9}, 3.4980709163338346`*^9, {3.4980711071777706`*^9, 
   3.498071117738989*^9}, {3.498072713788993*^9, 3.4980727224158087`*^9}, 
   3.498072987569474*^9, {3.498073018332728*^9, 3.4980730264915423`*^9}, {
   3.498073130278525*^9, 3.4980731356917343`*^9}, {3.49807390709869*^9, 
   3.4980739228859177`*^9}, {3.5154697100561795`*^9, 3.5154697469190445`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "*", 
     RowBox[{"Tanh", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"Cosh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"x", "^", "2"}]}]}], "]"}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", "c"}], ")"}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "c"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"Tanh", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}], "+", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "2"}]}]}], "]"}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.498070271459902*^9, 
   3.4980707653567696`*^9, {3.498070972259933*^9, 3.4980709751771383`*^9}, 
   3.4980719640716753`*^9, 3.4980729980058928`*^9, {3.498073376212957*^9, 
   3.4980733779913597`*^9}, 3.4980737201323614`*^9, 3.5154695856927614`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "*", 
     RowBox[{"Coth", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"x", "^", "2"}]}]}], "]"}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", "c"}], ")"}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "c"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"Coth", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}], "+", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "2"}]}]}], "]"}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.498070271459902*^9, 
   3.4980707653567696`*^9, {3.498070972259933*^9, 3.4980709751771383`*^9}, 
   3.4980719640716753`*^9, 3.4980729980058928`*^9, {3.498073376212957*^9, 
   3.4980733779913597`*^9}, 3.4980737201323614`*^9, 3.5154695856927614`*^9, 
   3.5154696611188936`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Note: This rule is valid, but to be useful need a rule for reducing \
integrands of the form ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"Cosh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}]}], "]"}], "]"}]}]]],
 "."
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, 3.4980702864359283`*^9, 
   3.4980719947257295`*^9, {3.498072604386001*^9, 3.4980726091908092`*^9}, 
   3.4980731625081816`*^9, {3.4980735583132772`*^9, 3.498073601915354*^9}, {
   3.4980737457008066`*^9, 3.4980737939360914`*^9}, {3.498073971589203*^9, 
   3.498074013475277*^9}, {3.5154697867615147`*^9, 3.5154697867615147`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ">", "1"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.498070802032434*^9, 3.498070811704451*^9}, {
   3.4980708419217043`*^9, 3.498070859549735*^9}, {3.498072042274613*^9, 
   3.498072055285036*^9}, {3.498073052465588*^9, 3.498073079297635*^9}, {
   3.4980732240814896`*^9, 3.4980732251890917`*^9}, {3.498073490999159*^9, 
   3.498073513135598*^9}, {3.4980738492381887`*^9, 3.4980738534813957`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"Tanh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "-", "1"}]], " ", 
        RowBox[{"Log", "[", 
         RowBox[{"Cosh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}], "+", 
           RowBox[{"c", " ", 
            SuperscriptBox["x", "2"]}]}], "]"}], "]"}]}], 
       RowBox[{"2", " ", "c"}]]}]}]}]}], "-", "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["b", 
    RowBox[{"2", " ", "c"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "1"}]], " ", 
     RowBox[{"Tanh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"m", "-", "1"}], 
    RowBox[{"2", " ", "c"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "2"}]], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"Cosh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}], "]"}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.498070321988391*^9, 
   3.498070327557601*^9}, 3.4980709163338346`*^9, {3.4980711071777706`*^9, 
   3.498071117738989*^9}, {3.498072713788993*^9, 3.4980727224158087`*^9}, 
   3.498072987569474*^9, {3.498073018332728*^9, 3.4980730264915423`*^9}, {
   3.498073130278525*^9, 3.4980731356917343`*^9}, 3.4980734706411233`*^9, 
   3.498073536410839*^9, {3.4980738391137705`*^9, 3.4980738651970167`*^9}, {
   3.4980741722891254`*^9, 3.4980741792291346`*^9}, {3.4980742619192505`*^9, 
   3.4980742623292513`*^9}, {3.5154697213037996`*^9, 3.515469734719823*^9}, {
   3.5154697935943265`*^9, 3.515469804280345*^9}, {3.515469845199217*^9, 
   3.515469848490823*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x_", "^", "m_"}], "*", 
      RowBox[{"Tanh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ",
    ":=", "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"m", "-", "1"}], ")"}]}], "*", 
      RowBox[{
       RowBox[{"Log", "[", 
        RowBox[{"Cosh", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}], "+", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "2"}]}]}], "]"}], "]"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "c"}], ")"}]}]}], " ", "-", "\n", "  ", 
     RowBox[{"Dist", "[", 
      RowBox[{
       RowBox[{"b", "/", 
        RowBox[{"(", 
         RowBox[{"2", "*", "c"}], ")"}]}], ",", 
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", 
           RowBox[{"(", 
            RowBox[{"m", "-", "1"}], ")"}]}], "*", 
          RowBox[{"Tanh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", "2"}]}]}], "]"}]}], ",", "x"}], "]"}]}], "]"}],
      " ", "-", "\n", "  ", 
     RowBox[{"Dist", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "-", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", "*", "c"}], ")"}]}], ",", 
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", 
           RowBox[{"(", 
            RowBox[{"m", "-", "2"}], ")"}]}], "*", 
          RowBox[{"Log", "[", 
           RowBox[{"Cosh", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", "x"}], "+", 
             RowBox[{"c", "*", 
              RowBox[{"x", "^", "2"}]}]}], "]"}], "]"}]}], ",", "x"}], 
        "]"}]}], "]"}]}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
      " ", 
     RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
     RowBox[{"m", ">", "1"}]}]}]}], " ", "*)"}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.498070271459902*^9, 
   3.4980707653567696`*^9, {3.498070972259933*^9, 3.4980709751771383`*^9}, 
   3.4980719640716753`*^9, 3.4980729980058928`*^9, {3.498073376212957*^9, 
   3.4980733779913597`*^9}, 3.4980734370230646`*^9, 3.4980737273395743`*^9, 
   3.5154696070023985`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x_", "^", "m_"}], "*", 
      RowBox[{"Coth", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ",
    ":=", "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"m", "-", "1"}], ")"}]}], "*", 
      RowBox[{
       RowBox[{"Log", "[", 
        RowBox[{"Sinh", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}], "+", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "2"}]}]}], "]"}], "]"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "c"}], ")"}]}]}], " ", "-", "\n", "  ", 
     RowBox[{"Dist", "[", 
      RowBox[{
       RowBox[{"b", "/", 
        RowBox[{"(", 
         RowBox[{"2", "*", "c"}], ")"}]}], ",", 
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", 
           RowBox[{"(", 
            RowBox[{"m", "-", "1"}], ")"}]}], "*", 
          RowBox[{"Coth", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", "2"}]}]}], "]"}]}], ",", "x"}], "]"}]}], "]"}],
      " ", "-", "\n", "  ", 
     RowBox[{"Dist", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "-", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", "*", "c"}], ")"}]}], ",", 
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", 
           RowBox[{"(", 
            RowBox[{"m", "-", "2"}], ")"}]}], "*", 
          RowBox[{"Log", "[", 
           RowBox[{"Sinh", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", "x"}], "+", 
             RowBox[{"c", "*", 
              RowBox[{"x", "^", "2"}]}]}], "]"}], "]"}]}], ",", "x"}], 
        "]"}]}], "]"}]}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
      " ", 
     RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
     RowBox[{"m", ">", "1"}]}]}]}], " ", "*)"}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.498070271459902*^9, 
   3.4980707653567696`*^9, {3.498070972259933*^9, 3.4980709751771383`*^9}, 
   3.4980719640716753`*^9, 3.4980729980058928`*^9, {3.498073376212957*^9, 
   3.4980733779913597`*^9}, 3.4980734370230646`*^9, 3.4980737273395743`*^9, 
   3.5154696070023985`*^9, 3.515469680088527*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]]
},
AutoGeneratedPackage->Automatic,
CellGrouping->Manual,
WindowSize->{1916, 965},
WindowMargins->{{Automatic, 0}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  "Integration Rules for Hyperbolic Tangent Functions", None, None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->28.8},
Magnification->1.399999976158142,
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 1188, 24, 118, "Title"],
Cell[1758, 48, 335, 5, 130, "Subsubsection"],
Cell[2096, 55, 219, 3, 90, "Subsubsection"],
Cell[2318, 60, 484, 13, 145, "Subsubsection"],
Cell[2805, 75, 763, 11, 90, "Subsubsection"],
Cell[3571, 88, 990, 23, 222, "Subsubtitle"],
Cell[4564, 113, 771, 11, 130, "Subsubsection"],
Cell[5338, 126, 790, 22, 394, "Code"],
Cell[6131, 150, 357, 5, 130, "Subsubsection"],
Cell[6491, 157, 812, 22, 394, "Code"],
Cell[7306, 181, 89, 2, 130, "Subsubsection"],
Cell[7398, 185, 254, 4, 90, "Subsubsection"],
Cell[7655, 191, 225, 3, 90, "Subsubsection"],
Cell[7883, 196, 534, 14, 96, "Subsubsection"],
Cell[8420, 212, 815, 11, 90, "Subsubsection"],
Cell[9238, 225, 1495, 31, 222, "Subsubtitle"],
Cell[10736, 258, 771, 11, 130, "Subsubsection"],
Cell[11510, 271, 852, 23, 394, "Code"],
Cell[12365, 296, 276, 4, 130, "Subsubsection"],
Cell[12644, 302, 880, 24, 394, "Code"],
Cell[13527, 328, 89, 2, 130, "Subsubsection"],
Cell[13619, 332, 289, 4, 90, "Subsubsection"],
Cell[13911, 338, 280, 5, 90, "Subsubsection"],
Cell[14194, 345, 675, 18, 165, "Subsubsection"],
Cell[14872, 365, 939, 17, 96, "Subsubsection"],
Cell[15814, 384, 2209, 54, 250, "Subsubtitle"],
Cell[18026, 440, 771, 11, 130, "Subsubsection"],
Cell[18800, 453, 1820, 56, 491, "Code"],
Cell[20623, 511, 313, 4, 130, "Subsubsection"],
Cell[20939, 517, 1844, 56, 491, "Code"],
Cell[22786, 575, 89, 2, 130, "Subsubsection"],
Cell[22878, 579, 302, 4, 90, "Subsubsection"],
Cell[23183, 585, 317, 6, 90, "Subsubsection"],
Cell[23503, 593, 1012, 19, 96, "Subsubsection"],
Cell[24518, 614, 2197, 53, 250, "Subsubtitle"],
Cell[26718, 669, 771, 11, 130, "Subsubsection"],
Cell[27492, 682, 1839, 55, 491, "Code"],
Cell[29334, 739, 328, 5, 130, "Subsubsection"],
Cell[29665, 746, 1863, 55, 491, "Code"],
Cell[31531, 803, 44, 1, 11, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[31612, 809, 1567, 33, 80, "Title"],
Cell[33182, 844, 1212, 23, 69, "Subsubsection"],
Cell[34397, 869, 1834, 40, 120, "Subsubtitle"],
Cell[36234, 911, 771, 11, 67, "Subsubsection"],
Cell[37008, 924, 1478, 43, 202, "Code"],
Cell[38489, 969, 1502, 43, 222, "Code"],
Cell[39994, 1014, 89, 2, 67, "Subsubsection"],
Cell[40086, 1018, 1130, 23, 50, "Subsubsection"],
Cell[41219, 1043, 1409, 39, 144, "Subsubtitle"],
Cell[42631, 1084, 771, 11, 67, "Subsubsection"],
Cell[43405, 1097, 1844, 50, 202, "Code"],
Cell[45252, 1149, 1944, 53, 222, "Code"],
Cell[47199, 1204, 89, 2, 67, "Subsubsection"],
Cell[47291, 1208, 1231, 25, 50, "Subsubsection"],
Cell[48525, 1235, 1955, 48, 144, "Subsubtitle"],
Cell[50483, 1285, 771, 11, 67, "Subsubsection"],
Cell[51257, 1298, 1980, 55, 202, "Code"],
Cell[53240, 1355, 2013, 55, 222, "Code"],
Cell[55256, 1412, 89, 2, 67, "Subsubsection"],
Cell[55348, 1416, 1416, 27, 50, "Subsubsection"],
Cell[56767, 1445, 2386, 58, 128, "Subsubtitle"],
Cell[59156, 1505, 771, 11, 67, "Subsubsection"],
Cell[59930, 1518, 2457, 68, 251, "Code"],
Cell[62390, 1588, 2507, 69, 271, "Code"],
Cell[64900, 1659, 89, 2, 67, "Subsubsection"],
Cell[64992, 1663, 1378, 26, 50, "Subsubsection"],
Cell[66373, 1691, 2354, 56, 120, "Subsubtitle"],
Cell[68730, 1749, 771, 11, 67, "Subsubsection"],
Cell[69504, 1762, 2311, 64, 251, "Code"],
Cell[71818, 1828, 2357, 64, 271, "Code"],
Cell[74178, 1894, 44, 1, 6, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[74259, 1900, 1599, 33, 80, "Title"],
Cell[75861, 1935, 339, 6, 93, "Subsubsection"],
Cell[76203, 1943, 1388, 41, 116, "Subsubsection"],
Cell[77594, 1986, 1274, 23, 69, "Subsubsection"],
Cell[78871, 2011, 2186, 52, 181, "Subsubtitle"],
Cell[81060, 2065, 771, 11, 93, "Subsubsection"],
Cell[81834, 2078, 1847, 54, 282, "Code"],
Cell[83684, 2134, 1871, 54, 310, "Code"],
Cell[85558, 2190, 44, 1, 8, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[85639, 2196, 1519, 34, 80, "Title"],
Cell[87161, 2232, 445, 6, 35, "Subsubsection"],
Cell[87609, 2240, 960, 27, 38, "Subsubsection"],
Cell[88572, 2269, 1098, 21, 26, "Subsubsection"],
Cell[89673, 2292, 1806, 47, 62, "Subsubtitle"],
Cell[91482, 2341, 771, 11, 35, "Subsubsection"],
Cell[92256, 2354, 2126, 58, 104, "Code"],
Cell[94385, 2414, 2176, 58, 114, "Code"],
Cell[96564, 2474, 89, 2, 35, "Subsubsection"],
Cell[96656, 2478, 519, 9, 25, "Subsubsection"],
Cell[97178, 2489, 1342, 27, 26, "Subsubsection"],
Cell[98523, 2518, 2174, 55, 104, "Subsubtitle"],
Cell[100700, 2575, 771, 11, 35, "Subsubsection"],
Cell[101474, 2588, 2884, 74, 104, "Code"],
Cell[104361, 2664, 2934, 74, 114, "Code"],
Cell[107298, 2740, 89, 2, 35, "Subsubsection"],
Cell[107390, 2744, 445, 6, 25, "Subsubsection"],
Cell[107838, 2752, 1132, 28, 37, "Subsubsection"],
Cell[108973, 2782, 1548, 30, 35, "Subsubsection"],
Cell[110524, 2814, 2617, 69, 68, "Subsubtitle"],
Cell[113144, 2885, 771, 11, 35, "Subsubsection"],
Cell[113918, 2898, 3572, 91, 129, "Code"],
Cell[117493, 2991, 3620, 91, 139, "Code"],
Cell[121116, 3084, 89, 2, 35, "Subsubsection"],
Cell[121208, 3088, 519, 9, 25, "Subsubsection"],
Cell[121730, 3099, 1597, 26, 26, "Subsubsection"],
Cell[123330, 3127, 3206, 76, 110, "Subsubtitle"],
Cell[126539, 3205, 771, 11, 35, "Subsubsection"],
Cell[127313, 3218, 3247, 82, 129, "Code"],
Cell[130563, 3302, 3399, 84, 139, "Code"],
Cell[133965, 3388, 89, 2, 35, "Subsubsection"],
Cell[134057, 3392, 519, 9, 25, "Subsubsection"],
Cell[134579, 3403, 1712, 31, 35, "Subsubsection"],
Cell[136294, 3436, 3897, 95, 120, "Subsubtitle"],
Cell[140194, 3533, 771, 11, 35, "Subsubsection"],
Cell[140968, 3546, 3774, 104, 129, "Code"],
Cell[144745, 3652, 3823, 105, 139, "Code"],
Cell[148571, 3759, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[148652, 3765, 1404, 29, 80, "Title"],
Cell[150059, 3796, 278, 4, 130, "Subsubsection"],
Cell[150340, 3802, 943, 24, 96, "Subsubsection"],
Cell[151286, 3828, 1083, 21, 96, "Subsubsection"],
Cell[152372, 3851, 1462, 33, 201, "Subsubtitle"],
Cell[153837, 3886, 771, 11, 130, "Subsubsection"],
Cell[154611, 3899, 1654, 43, 394, "Code"],
Cell[156268, 3944, 89, 2, 130, "Subsubsection"],
Cell[156360, 3948, 278, 4, 90, "Subsubsection"],
Cell[156641, 3954, 943, 24, 96, "Subsubsection"],
Cell[157587, 3980, 1089, 21, 96, "Subsubsection"],
Cell[158679, 4003, 1408, 32, 201, "Subsubtitle"],
Cell[160090, 4037, 771, 11, 130, "Subsubsection"],
Cell[160864, 4050, 1417, 38, 394, "Code"],
Cell[162284, 4090, 89, 2, 130, "Subsubsection"],
Cell[162376, 4094, 1066, 19, 96, "Subsubsection"],
Cell[163445, 4115, 1579, 43, 282, "Subsubtitle"],
Cell[165027, 4160, 771, 11, 130, "Subsubsection"],
Cell[165801, 4173, 1677, 47, 394, "Code"],
Cell[167481, 4222, 1729, 48, 433, "Code"],
Cell[169213, 4272, 44, 1, 11, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[169294, 4278, 1346, 27, 80, "Title"],
Cell[170643, 4307, 327, 5, 130, "Subsubsection"],
Cell[170973, 4314, 660, 16, 144, "Subsubsection"],
Cell[171636, 4332, 1324, 24, 96, "Subsubsection"],
Cell[172963, 4358, 1664, 41, 257, "Subsubtitle"],
Cell[174630, 4401, 771, 11, 130, "Subsubsection"],
Cell[175404, 4414, 1886, 51, 491, "Code"],
Cell[177293, 4467, 1960, 52, 530, "Code"],
Cell[179256, 4521, 89, 2, 130, "Subsubsection"],
Cell[179348, 4525, 413, 7, 90, "Subsubsection"],
Cell[179764, 4534, 1318, 25, 96, "Subsubsection"],
Cell[181085, 4561, 2677, 70, 482, "Subsubtitle"],
Cell[183765, 4633, 771, 11, 130, "Subsubsection"],
Cell[184539, 4646, 2921, 85, 586, "Code"],
Cell[187463, 4733, 2949, 86, 625, "Code"],
Cell[190415, 4821, 44, 1, 11, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[190496, 4827, 1381, 28, 80, "Title"],
Cell[191880, 4857, 1033, 14, 130, "Subsubsection"],
Cell[192916, 4873, 1810, 44, 250, "Subsubtitle"],
Cell[194729, 4919, 771, 11, 130, "Subsubsection"],
Cell[195503, 4932, 1647, 45, 491, "Code"],
Cell[197153, 4979, 1675, 46, 530, "Code"],
Cell[198831, 5027, 89, 2, 130, "Subsubsection"],
Cell[198923, 5031, 864, 20, 106, "Subsubsection"],
Cell[199790, 5053, 1186, 20, 96, "Subsubsection"],
Cell[200979, 5075, 2718, 69, 463, "Subsubtitle"],
Cell[203700, 5146, 771, 11, 130, "Subsubsection"],
Cell[204474, 5159, 2815, 80, 586, "Code"],
Cell[207292, 5241, 2837, 80, 625, "Code"],
Cell[210132, 5323, 44, 1, 11, "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}
]
*)

(* End of internal cache information *)
