(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    126691,       3384]
NotebookOptionsPosition[    121821,       3257]
NotebookOutlinePosition[    122968,       3297]
CellTagsIndexPosition[    122925,       3294]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox["f", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]], ")"}], "p"], " ", 
   SuperscriptBox[
    RowBox[{"Sinh", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.4953219782293406`*^9, 
   3.495333683275055*^9, 3.498508933670944*^9, 3.498509588381861*^9, 
   3.49850963055192*^9, {3.4985098202421856`*^9, 3.4985098240321913`*^9}, 
   3.498519909479803*^9, 3.5157742499026403`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: CRC 533h", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4985097118120337`*^9, {3.515774504482997*^9, 
   3.5157745173330145`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["d", "2"], "-", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["p", "2"], " ", 
     SuperscriptBox[
      RowBox[{"Log", "[", "f", "]"}], "2"]}]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.4985099493323665`*^9, 3.498509964632388*^9}, {3.498519911258206*^9, 
   3.498519911258206*^9}, {3.515773710458272*^9, 3.515773714576679*^9}, {
   3.5157740432823515`*^9, 3.5157740472523565`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox["f", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]], ")"}], "p"], " ", 
    RowBox[{"Sinh", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", "p", " ", 
         RowBox[{"Log", "[", "f", "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox["f", 
            RowBox[{"a", "+", 
             RowBox[{"b", " ", "x"}]}]], ")"}], "p"], 
         RowBox[{"Sinh", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], 
        RowBox[{
         SuperscriptBox["d", "2"], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox[
           RowBox[{"Log", "[", "f", "]"}], "2"]}]}]]}]}]}]}]}], "+", 
  FractionBox[
   RowBox[{"d", 
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox["f", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]], ")"}], "p"], " ", 
    RowBox[{"Cosh", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}]}], 
   RowBox[{
    SuperscriptBox["d", "2"], "-", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["p", "2"], " ", 
     SuperscriptBox[
      RowBox[{"Log", "[", "f", "]"}], "2"]}]}]]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.498509792342147*^9, 3.498509805332165*^9}, {
   3.4985105306831803`*^9, 3.4985105663032303`*^9}, {3.4985107615335035`*^9, 
   3.4985107704235163`*^9}, {3.4985199122878075`*^9, 
   3.4985199160474143`*^9}, {3.5157740930124207`*^9, 3.5157741842125483`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f_", "^", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{"Sinh", "[", 
      RowBox[{"c_.", "+", 
       RowBox[{"d_.", "*", "x_"}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "b"}], "*", "p", "*", 
     RowBox[{"Log", "[", "f", "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"d", "^", "2"}], "-", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"p", "^", "2"}], "*", 
         RowBox[{
          RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}]}], ")"}]}]}], " ", "+",
     " ", "\n", "  ", 
    RowBox[{"d", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"d", "^", "2"}], "-", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"p", "^", "2"}], "*", 
         RowBox[{
          RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}]}], ")"}]}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "f", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"d", "^", "2"}], "-", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"p", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49532208483949*^9, {
   3.498509743462078*^9, 3.4985097607521024`*^9}, {3.498509900942299*^9, 
   3.498509942602357*^9}, {3.4985100235024705`*^9, 3.4985100592425203`*^9}, {
   3.4985100907525644`*^9, 3.49851009459257*^9}, {3.4985108985836954`*^9, 
   3.4985109165837207`*^9}, {3.498511195214111*^9, 3.498511199044116*^9}, {
   3.498511452804471*^9, 3.498511464874488*^9}, {3.498519935282248*^9, 
   3.4985199425362606`*^9}, 3.5157709058097577`*^9, {3.5157734816838703`*^9, 
   3.5157734914338875`*^9}, {3.515773546611184*^9, 3.515773644844557*^9}, {
   3.5157737748519754`*^9, 3.515773793862002*^9}, {3.5157738373120627`*^9, 
   3.5157738396120663`*^9}, {3.5157742707926693`*^9, 
   3.5157743091927233`*^9}, {3.5157743402127666`*^9, 3.5157743404127674`*^9}},
 Background->GrayLevel[0.85]],

Cell["Reference: CRC 538h", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4985097118120337`*^9, 3.498511370354356*^9, {
   3.5157745068830004`*^9, 3.515774513053009*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f_", "^", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{"Cosh", "[", 
      RowBox[{"c_.", "+", 
       RowBox[{"d_.", "*", "x_"}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "b"}], "*", "p", "*", 
     RowBox[{"Log", "[", "f", "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"d", "^", "2"}], "-", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"p", "^", "2"}], "*", 
         RowBox[{
          RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}]}], ")"}]}]}], " ", "+",
     " ", "\n", "  ", 
    RowBox[{"d", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"d", "^", "2"}], "-", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"p", "^", "2"}], "*", 
         RowBox[{
          RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}]}], ")"}]}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "f", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"d", "^", "2"}], "-", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"p", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49532208483949*^9, {
   3.498509743462078*^9, 3.4985097607521024`*^9}, {3.498509900942299*^9, 
   3.498509942602357*^9}, {3.4985100235024705`*^9, 3.4985100592425203`*^9}, {
   3.4985100907525644`*^9, 3.49851009459257*^9}, {3.4985108985836954`*^9, 
   3.4985109165837207`*^9}, {3.498511195214111*^9, 3.498511199044116*^9}, {
   3.498511452804471*^9, 3.498511464874488*^9}, {3.498519935282248*^9, 
   3.4985199425362606`*^9}, 3.5157709058097577`*^9, {3.5157734816838703`*^9, 
   3.5157734914338875`*^9}, {3.515773546611184*^9, 3.515773644844557*^9}, {
   3.5157737748519754`*^9, 3.515773793862002*^9}, {3.5157738373120627`*^9, 
   3.5157738396120663`*^9}, {3.515773884002128*^9, 3.5157738962921457`*^9}, 
   3.515773929432192*^9, {3.515774436192901*^9, 3.5157744712029505`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: CRC 542h", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4985097118120337`*^9, 3.498510147452644*^9, {
   3.515774600473131*^9, 3.515774602253134*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["d", "2"], " ", 
      SuperscriptBox["n", "2"]}], "-", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["p", "2"], " ", 
      SuperscriptBox[
       RowBox[{"Log", "[", "f", "]"}], "2"]}]}], "\[NotEqual]", "0"}], " ", 
   "\[And]", " ", 
   RowBox[{"n", ">", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.4985099493323665`*^9, 3.498509964632388*^9}, {3.498510953243772*^9, 
   3.498510971053797*^9}, {3.4985199257506313`*^9, 3.4985199257506313`*^9}, {
   3.515773704514662*^9, 3.515773704514662*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox["f", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", "p", " ", 
         RowBox[{"Log", "[", "f", "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox["f", 
            RowBox[{"a", "+", 
             RowBox[{"b", " ", "x"}]}]], ")"}], "p"], 
         SuperscriptBox[
          RowBox[{"Sinh", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "n"]}], 
        RowBox[{
         RowBox[{
          SuperscriptBox["d", "2"], " ", 
          SuperscriptBox["n", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox[
           RowBox[{"Log", "[", "f", "]"}], "2"]}]}]]}]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  FractionBox[
   RowBox[{"d", " ", "n", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox["f", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]], ")"}], "p"], " ", 
    RowBox[{"Cosh", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     RowBox[{"n", "-", "1"}]]}], 
   RowBox[{
    RowBox[{
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["n", "2"]}], "-", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["p", "2"], " ", 
     SuperscriptBox[
      RowBox[{"Log", "[", "f", "]"}], "2"]}]}]], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"n", " ", 
     RowBox[{"(", 
      RowBox[{"n", "-", "1"}], ")"}], " ", 
     SuperscriptBox["d", "2"]}], 
    RowBox[{
     RowBox[{
      SuperscriptBox["d", "2"], " ", 
      SuperscriptBox["n", "2"]}], "-", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["p", "2"], " ", 
      SuperscriptBox[
       RowBox[{"Log", "[", "f", "]"}], "2"]}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox["f", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}]], ")"}], "p"], " ", 
     SuperscriptBox[
      RowBox[{"Sinh", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"n", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.498509792342147*^9, 3.498509805332165*^9}, 
   3.498510125202613*^9, {3.4985107226434493`*^9, 3.498510741933476*^9}, {
   3.4985108499436274`*^9, 3.4985108652736487`*^9}, {3.498519928293436*^9, 
   3.4985199332230444`*^9}, {3.5157732715515013`*^9, 
   3.5157732899439335`*^9}, {3.5157733966169205`*^9, 
   3.5157734133713503`*^9}, {3.5157735013867044`*^9, 
   3.5157735067687144`*^9}, {3.515774116812454*^9, 3.51577412112246*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f_", "^", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "b"}], "*", "p", "*", 
     RowBox[{"Log", "[", "f", "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sinh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"d", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}]}], "-", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"p", "^", "2"}], "*", 
         RowBox[{
          RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}]}], ")"}]}]}], " ", "+",
     " ", "\n", "  ", 
    RowBox[{"d", "*", "n", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{"Cosh", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sinh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"d", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}]}], "-", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"p", "^", "2"}], "*", 
         RowBox[{
          RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}]}], ")"}]}]}], " ", "-",
     " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "*", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}], "*", 
       RowBox[{
        RowBox[{"d", "^", "2"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"d", "^", "2"}], "*", 
           RowBox[{"n", "^", "2"}]}], "-", 
          RowBox[{
           RowBox[{"b", "^", "2"}], "*", 
           RowBox[{"p", "^", "2"}], "*", 
           RowBox[{
            RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"f", "^", 
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"Sinh", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "f", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"d", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}]}], "-", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"p", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49532208483949*^9, {
   3.498509743462078*^9, 3.4985097607521024`*^9}, {3.498509900942299*^9, 
   3.498509942602357*^9}, {3.4985100235024705`*^9, 3.4985100592425203`*^9}, {
   3.4985100907525644`*^9, 3.49851009459257*^9}, {3.4985108985836954`*^9, 
   3.4985109165837207`*^9}, {3.498511195214111*^9, 3.498511199044116*^9}, {
   3.498511452804471*^9, 3.498511464874488*^9}, {3.498519935282248*^9, 
   3.4985199425362606`*^9}, 3.5157709058097577`*^9, {3.5157734816838703`*^9, 
   3.5157734914338875`*^9}, {3.515773546611184*^9, 3.515773644844557*^9}, {
   3.5157737748519754`*^9, 3.515773793862002*^9}, {3.5157738373120627`*^9, 
   3.5157738396120663`*^9}},
 Background->GrayLevel[0.85]],

Cell["Reference: CRC 543h", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4985097118120337`*^9, 3.498510147452644*^9, 
   3.4985113788643675`*^9, {3.5157746070631404`*^9, 3.5157746083331423`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f_", "^", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "b"}], "*", "p", "*", 
     RowBox[{"Log", "[", "f", "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"d", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}]}], "-", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"p", "^", "2"}], "*", 
         RowBox[{
          RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}]}], ")"}]}]}], " ", "+",
     " ", "\n", "  ", 
    RowBox[{"d", "*", "n", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{"Sinh", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"d", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}]}], "-", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"p", "^", "2"}], "*", 
         RowBox[{
          RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}]}], ")"}]}]}], " ", "+",
     " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "*", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}], "*", 
       RowBox[{
        RowBox[{"d", "^", "2"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"d", "^", "2"}], "*", 
           RowBox[{"n", "^", "2"}]}], "-", 
          RowBox[{
           RowBox[{"b", "^", "2"}], "*", 
           RowBox[{"p", "^", "2"}], "*", 
           RowBox[{
            RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"f", "^", 
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"Cosh", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "f", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"d", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}]}], "-", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"p", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49532208483949*^9, {
   3.498509743462078*^9, 3.4985097607521024`*^9}, {3.498509900942299*^9, 
   3.498509942602357*^9}, {3.4985100235024705`*^9, 3.4985100592425203`*^9}, {
   3.4985100907525644`*^9, 3.49851009459257*^9}, {3.4985108985836954`*^9, 
   3.4985109165837207`*^9}, {3.498511195214111*^9, 3.498511199044116*^9}, {
   3.498511452804471*^9, 3.498511464874488*^9}, {3.498519935282248*^9, 
   3.4985199425362606`*^9}, 3.5157709058097577`*^9, {3.5157734816838703`*^9, 
   3.5157734914338875`*^9}, {3.515773546611184*^9, 3.515773644844557*^9}, {
   3.5157737748519754`*^9, 3.515773793862002*^9}, {3.5157738373120627`*^9, 
   3.5157738396120663`*^9}, {3.515773884002128*^9, 3.5157738962921457`*^9}, 
   3.515773929432192*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Reference: CRC 551h when ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["d", "2"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"n", "+", "2"}], ")"}], "2"]}], "-", 
    RowBox[{
     SuperscriptBox["b", "2"], 
     SuperscriptBox["p", "2"], 
     SuperscriptBox[
      RowBox[{"Log", "[", "f", "]"}], "2"]}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4985097118120337`*^9, 3.4985123465257225`*^9, 
   3.498517253116337*^9, {3.498529076972989*^9, 3.4985290819961977`*^9}, {
   3.498530131014841*^9, 3.498530144056464*^9}, 3.515774612543148*^9, {
   3.5157753348641596`*^9, 3.5157753348641596`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"n", "+", "2"}], ")"}], "2"]}], "-", 
    RowBox[{
     SuperscriptBox["b", "2"], 
     SuperscriptBox["p", "2"], 
     SuperscriptBox[
      RowBox[{"Log", "[", "f", "]"}], "2"]}]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"n", "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"n", "+", "2"}], "\[NotEqual]", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.4985099493323665`*^9, 3.498509964632388*^9}, {3.4985127051562243`*^9, 
   3.498512749316286*^9}, {3.4985128464164224`*^9, 3.498512849936427*^9}, {
   3.498529097908226*^9, 3.498529112541052*^9}, {3.4985297959418526`*^9, 
   3.498529800497061*^9}, 3.4985298682791796`*^9, 3.49853002780506*^9, {
   3.498530068817532*^9, 3.4985300851195602`*^9}, {3.5157753262941475`*^9, 
   3.5157753262941475`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox["f", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", "p", " ", 
         RowBox[{"Log", "[", "f", "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox["f", 
            RowBox[{"a", "+", 
             RowBox[{"b", " ", "x"}]}]], ")"}], "p"], " ", 
         SuperscriptBox[
          RowBox[{"Sinh", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], 
          RowBox[{"n", "+", "2"}]]}], 
        RowBox[{
         SuperscriptBox["d", "2"], 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"n", "+", "2"}], ")"}]}]]}]}]}]}]}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox["f", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]], ")"}], "p"], 
    RowBox[{"Cosh", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], 
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     RowBox[{"n", "+", "1"}]]}], 
   RowBox[{"d", " ", 
    RowBox[{"(", 
     RowBox[{"n", "+", "1"}], ")"}]}]]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.498509792342147*^9, 3.498509805332165*^9}, {
   3.4985105306831803`*^9, 3.4985105663032303`*^9}, {3.4985107615335035`*^9, 
   3.4985107704235163`*^9}, 3.4985121452454405`*^9, {3.4985125704460363`*^9, 
   3.498512583846055*^9}, 3.4985127801963296`*^9, {3.4985172169086733`*^9, 
   3.498517246423925*^9}, {3.4985285286424255`*^9, 3.4985285338372345`*^9}, 
   3.4985286012137527`*^9, {3.4985286793230896`*^9, 3.498528732129183*^9}, {
   3.498529809810277*^9, 3.4985298394971294`*^9}, {3.4985298729747877`*^9, 
   3.4985298797452*^9}, {3.498530028990662*^9, 3.4985300314866667`*^9}, {
   3.5157753785942206`*^9, 3.515775389914236*^9}, 3.5159561512803354`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f_", "^", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "b"}], "*", "p", "*", 
     RowBox[{"Log", "[", "f", "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sinh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"d", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{"Cosh", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sinh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "f", ",", "n", ",", "p"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"d", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}], "^", "2"}]}], "-", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"p", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"n", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"n", "+", "2"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49532208483949*^9, {
   3.498509743462078*^9, 3.4985097607521024`*^9}, {3.498509900942299*^9, 
   3.498509942602357*^9}, {3.4985107807535305`*^9, 3.4985107993935566`*^9}, {
   3.4985114194044247`*^9, 3.4985114217844276`*^9}, 3.4985119359051476`*^9, {
   3.498512231895562*^9, 3.4985122557455955`*^9}, {3.4985123585657396`*^9, 
   3.4985124093458104`*^9}, {3.498512731886262*^9, 3.4985127326962633`*^9}, {
   3.4985172189522767`*^9, 3.4985172320562997`*^9}, {3.498517333955679*^9, 
   3.498517334252079*^9}, {3.498528644706629*^9, 3.4985286531930437`*^9}, {
   3.4985289509403677`*^9, 3.498528961875987*^9}, {3.4985290024516582`*^9, 
   3.498529012186075*^9}, {3.4985298170174894`*^9, 3.4985298295443115`*^9}, {
   3.498529886827612*^9, 3.498529888606015*^9}, {3.498530033109069*^9, 
   3.4985300381478777`*^9}, {3.4985300929819746`*^9, 3.498530114400812*^9}, {
   3.4985301644456997`*^9, 3.4985301667857037`*^9}, {3.5157754000142508`*^9, 
   3.515775403314255*^9}, 3.515775519534418*^9},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Reference: CRC 552h when ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["d", "2"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"n", "+", "2"}], ")"}], "2"]}], "-", 
    RowBox[{
     SuperscriptBox["b", "2"], 
     SuperscriptBox["p", "2"], 
     SuperscriptBox[
      RowBox[{"Log", "[", "f", "]"}], "2"]}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4985097118120337`*^9, 3.4985123465257225`*^9, 
   3.498517253116337*^9, {3.498529076972989*^9, 3.4985290819961977`*^9}, {
   3.498530131014841*^9, 3.498530144056464*^9}, {3.4985304948978806`*^9, 
   3.498530495178681*^9}, 3.5157746183831563`*^9, 3.515775338914165*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f_", "^", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"b", "*", "p", "*", 
     RowBox[{"Log", "[", "f", "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"d", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}]}], " ", "-", " ", "\n", 
    "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{"Sinh", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "f", ",", "n", ",", "p"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"d", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}], "^", "2"}]}], "-", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"p", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"n", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"n", "+", "2"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49532208483949*^9, {
   3.498509743462078*^9, 3.4985097607521024`*^9}, {3.498509900942299*^9, 
   3.498509942602357*^9}, {3.4985107807535305`*^9, 3.4985107993935566`*^9}, {
   3.4985114194044247`*^9, 3.4985114217844276`*^9}, 3.4985119359051476`*^9, {
   3.498512231895562*^9, 3.4985122557455955`*^9}, {3.4985123585657396`*^9, 
   3.4985124093458104`*^9}, {3.498512731886262*^9, 3.4985127326962633`*^9}, {
   3.4985172189522767`*^9, 3.4985172320562997`*^9}, {3.498517333955679*^9, 
   3.498517334252079*^9}, {3.498528644706629*^9, 3.4985286531930437`*^9}, {
   3.4985289509403677`*^9, 3.498528961875987*^9}, {3.4985290024516582`*^9, 
   3.498529012186075*^9}, {3.4985298170174894`*^9, 3.4985298295443115`*^9}, {
   3.498529886827612*^9, 3.498529888606015*^9}, {3.498530033109069*^9, 
   3.4985300381478777`*^9}, {3.4985300929819746`*^9, 3.498530114400812*^9}, {
   3.4985301644456997`*^9, 3.4985301667857037`*^9}, 3.498530317185568*^9, {
   3.4985303486508236`*^9, 3.4985303656236534`*^9}, {3.4985305177519207`*^9, 
   3.4985305180327215`*^9}, {3.515775411984267*^9, 3.515775414904271*^9}, {
   3.5157754920943794`*^9, 3.5157755170844145`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: CRC 551h, CRC 542h inverted", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4985097118120337`*^9, 3.4985123465257225`*^9, 
   3.498517253116337*^9, {3.498529076972989*^9, 3.4985290819961977`*^9}, {
   3.5157746255731664`*^9, 3.51577462815317*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["d", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"n", "+", "2"}], ")"}], "2"]}], "-", 
     RowBox[{
      SuperscriptBox["b", "2"], 
      SuperscriptBox["p", "2"], 
      SuperscriptBox[
       RowBox[{"Log", "[", "f", "]"}], "2"]}]}], "\[NotEqual]", "0"}], " ", 
   "\[And]", " ", 
   RowBox[{"n", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{"n", "\[NotEqual]", 
    RowBox[{"-", "2"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.4985099493323665`*^9, 3.498509964632388*^9}, {3.4985127051562243`*^9, 
   3.498512749316286*^9}, {3.4985128464164224`*^9, 3.498512849936427*^9}, {
   3.498529097908226*^9, 3.498529112541052*^9}, {3.4985297959418526`*^9, 
   3.498529800497061*^9}, 3.49853003927108*^9, {3.515775275344076*^9, 
   3.515775275344076*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox["f", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", "p", " ", 
         RowBox[{"Log", "[", "f", "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox["f", 
            RowBox[{"a", "+", 
             RowBox[{"b", " ", "x"}]}]], ")"}], "p"], " ", 
         SuperscriptBox[
          RowBox[{"Sinh", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], 
          RowBox[{"n", "+", "2"}]]}], 
        RowBox[{
         SuperscriptBox["d", "2"], 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"n", "+", "2"}], ")"}]}]]}]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox["f", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]], ")"}], "p"], 
    RowBox[{"Cosh", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], 
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     RowBox[{"n", "+", "1"}]]}], 
   RowBox[{"d", " ", 
    RowBox[{"(", 
     RowBox[{"n", "+", "1"}], ")"}]}]], "-", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{
      SuperscriptBox["d", "2"], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"n", "+", "2"}], ")"}], "2"]}], "-", 
     RowBox[{
      SuperscriptBox["b", "2"], 
      SuperscriptBox["p", "2"], 
      SuperscriptBox[
       RowBox[{"Log", "[", "f", "]"}], "2"]}]}], 
    RowBox[{
     SuperscriptBox["d", "2"], 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"n", "+", "2"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox["f", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}]], ")"}], "p"], " ", 
     SuperscriptBox[
      RowBox[{"Sinh", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"n", "+", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.498509792342147*^9, 3.498509805332165*^9}, {
   3.4985105306831803`*^9, 3.4985105663032303`*^9}, {3.4985107615335035`*^9, 
   3.4985107704235163`*^9}, 3.4985121452454405`*^9, {3.4985125704460363`*^9, 
   3.498512583846055*^9}, 3.4985127801963296`*^9, {3.4985172169086733`*^9, 
   3.498517246423925*^9}, {3.4985285286424255`*^9, 3.4985285338372345`*^9}, 
   3.4985286012137527`*^9, {3.4985286793230896`*^9, 3.498528732129183*^9}, {
   3.498529809810277*^9, 3.4985298394971294`*^9}, {3.4985300405658827`*^9, 
   3.49853004482469*^9}, {3.5157747572733507`*^9, 3.5157747791633816`*^9}, {
   3.515774873733514*^9, 3.5157748771035185`*^9}, 3.515774962233638*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f_", "^", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "b"}], "*", "p", "*", 
     RowBox[{"Log", "[", "f", "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sinh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"d", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{"Cosh", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sinh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"d", "^", "2"}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"n", "+", "2"}], ")"}], "^", "2"}]}], "-", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "*", 
          RowBox[{"p", "^", "2"}], "*", 
          RowBox[{
           RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"d", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"f", "^", 
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"Sinh", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "f", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"d", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}], "^", "2"}]}], "-", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"p", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49532208483949*^9, {
   3.498509743462078*^9, 3.4985097607521024`*^9}, {3.498509900942299*^9, 
   3.498509942602357*^9}, {3.4985107807535305`*^9, 3.4985107993935566`*^9}, {
   3.4985114194044247`*^9, 3.4985114217844276`*^9}, 3.4985119359051476`*^9, {
   3.498512231895562*^9, 3.4985122557455955`*^9}, {3.4985123585657396`*^9, 
   3.4985124093458104`*^9}, {3.498512731886262*^9, 3.4985127326962633`*^9}, {
   3.4985172189522767`*^9, 3.4985172320562997`*^9}, {3.498517333955679*^9, 
   3.498517334252079*^9}, {3.498528644706629*^9, 3.4985286531930437`*^9}, {
   3.4985289509403677`*^9, 3.498528961875987*^9}, {3.4985290024516582`*^9, 
   3.498529012186075*^9}, {3.4985298170174894`*^9, 3.4985298295443115`*^9}, {
   3.498530046181892*^9, 3.4985300505655*^9}, {3.5157750054236984`*^9, 
   3.515775060343775*^9}, 3.5157752979641075`*^9},
 Background->GrayLevel[0.85]],

Cell["Reference: CRC 552h, CRC 543h inverted", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4985097118120337`*^9, 3.4985123465257225`*^9, 
   3.498517253116337*^9, {3.498529076972989*^9, 3.4985290819961977`*^9}, {
   3.4985304726990414`*^9, 3.4985304833070602`*^9}, {3.515774689093255*^9, 
   3.515774690543257*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f_", "^", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"b", "*", "p", "*", 
     RowBox[{"Log", "[", "f", "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"d", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}]}], " ", "-", " ", "\n", 
    "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{"Sinh", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"d", "^", "2"}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"n", "+", "2"}], ")"}], "^", "2"}]}], "-", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "*", 
          RowBox[{"p", "^", "2"}], "*", 
          RowBox[{
           RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"d", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"f", "^", 
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"Cosh", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "f", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"d", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}], "^", "2"}]}], "-", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"p", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49532208483949*^9, {
   3.498509743462078*^9, 3.4985097607521024`*^9}, {3.498509900942299*^9, 
   3.498509942602357*^9}, {3.4985107807535305`*^9, 3.4985107993935566`*^9}, {
   3.4985114194044247`*^9, 3.4985114217844276`*^9}, 3.4985119359051476`*^9, {
   3.498512231895562*^9, 3.4985122557455955`*^9}, {3.4985123585657396`*^9, 
   3.4985124093458104`*^9}, {3.498512731886262*^9, 3.4985127326962633`*^9}, {
   3.4985172189522767`*^9, 3.4985172320562997`*^9}, {3.498517333955679*^9, 
   3.498517334252079*^9}, {3.498528644706629*^9, 3.4985286531930437`*^9}, {
   3.4985289509403677`*^9, 3.498528961875987*^9}, {3.4985290024516582`*^9, 
   3.498529012186075*^9}, {3.4985298170174894`*^9, 3.4985298295443115`*^9}, {
   3.498530046181892*^9, 3.4985300505655*^9}, 3.4985303218811765`*^9, {
   3.4985303527068305`*^9, 3.498530367043256*^9}, {3.4985304448685923`*^9, 
   3.4985304452429934`*^9}, {3.515775026503728*^9, 3.5157750544837666`*^9}, 
   3.515775228844011*^9, 3.51577529962411*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox["f", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]], ")"}], "p"], " ", 
   SuperscriptBox[
    RowBox[{"Sech", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.4953219782293406`*^9, 
   3.495333683275055*^9, 3.498508933670944*^9, 3.498509588381861*^9, 
   3.49850963055192*^9, {3.4985098202421856`*^9, 3.4985098240321913`*^9}, {
   3.498511917245122*^9, 3.498511917745122*^9}, 3.498529946310517*^9, 
   3.5157732131293983`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Reference: CRC 552h with  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], 
     SuperscriptBox["p", "2"], 
     SuperscriptBox[
      RowBox[{"Log", "[", "f", "]"}], "2"]}], "-", 
    RowBox[{
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"n", "-", "2"}], ")"}], "2"]}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4985097118120337`*^9, 3.4985123465257225`*^9, {
   3.4985124381158504`*^9, 3.4985124580358787`*^9}, 3.4985128378264103`*^9, {
   3.4985299474181185`*^9, 3.4985299474181185`*^9}, {3.515772850803162*^9, 
   3.515772850803162*^9}, 3.515774636193181*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], 
     SuperscriptBox["p", "2"], 
     SuperscriptBox[
      RowBox[{"Log", "[", "f", "]"}], "2"]}], "-", 
    RowBox[{
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"n", "-", "2"}], ")"}], "2"]}]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"n", "-", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"n", "-", "2"}], "\[NotEqual]", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.4985099493323665`*^9, 3.498509964632388*^9}, {3.4985127051562243`*^9, 
   3.498512749316286*^9}, {3.4985128464164224`*^9, 3.498512849936427*^9}, {
   3.4985128850264764`*^9, 3.498512909816511*^9}, {3.498512957606578*^9, 
   3.498512970856597*^9}, {3.49852994830732*^9, 3.49852994830732*^9}, {
   3.5157730830251703`*^9, 3.5157730830251703`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox["f", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"Sech", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{"b", " ", "p", " ", 
        RowBox[{"Log", "[", "f", "]"}], 
        SuperscriptBox[
         RowBox[{"(", 
          SuperscriptBox["f", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}]], ")"}], "p"], " ", 
        SuperscriptBox[
         RowBox[{"Sech", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"n", "-", "2"}]]}], 
       RowBox[{
        SuperscriptBox["d", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"n", "-", "2"}], ")"}]}]]}]}]}]}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox["f", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"Sech", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     RowBox[{"n", "-", "1"}]], " ", 
    RowBox[{"Sinh", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}]}], 
   RowBox[{"d", " ", 
    RowBox[{"(", 
     RowBox[{"n", "-", "1"}], ")"}]}]]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.498509792342147*^9, 3.498509805332165*^9}, {
   3.4985105306831803`*^9, 3.4985105663032303`*^9}, {3.4985107615335035`*^9, 
   3.4985107704235163`*^9}, 3.4985121452454405`*^9, 3.4985125664160304`*^9, 
   3.4985127828463335`*^9, {3.4985299493369217`*^9, 3.498529951786126*^9}, {
   3.5157728755448055`*^9, 3.515772894030838*^9}, 3.515772924716092*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f_", "^", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"Sech", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"b", "*", "p", "*", 
     RowBox[{"Log", "[", "f", "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sech", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"d", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "2"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{
      RowBox[{"Sech", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "-", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}], ")"}]}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "f", ",", "p", ",", "n"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"p", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}], "-", 
      RowBox[{
       RowBox[{"d", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "-", "2"}], ")"}], "^", "2"}]}]}], "]"}], " ", "&&", 
    " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"n", "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"n", "-", "2"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49532208483949*^9, {
   3.498509743462078*^9, 3.4985097607521024`*^9}, {3.498509900942299*^9, 
   3.498509942602357*^9}, {3.4985107807535305`*^9, 3.4985107993935566`*^9}, {
   3.4985114194044247`*^9, 3.4985114217844276`*^9}, 3.4985119359051476`*^9, {
   3.498512231895562*^9, 3.4985122557455955`*^9}, {3.4985123585657396`*^9, 
   3.4985124093458104`*^9}, {3.498512543315998*^9, 3.49851255915602*^9}, {
   3.4985128145563774`*^9, 3.498512814766378*^9}, {3.49851293019654*^9, 
   3.4985129449465604`*^9}, {3.498529954422531*^9, 3.4985299580261374`*^9}, {
   3.515772952452941*^9, 3.5157729876310024`*^9}},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Reference: CRC 551h with  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], 
     SuperscriptBox["p", "2"], 
     SuperscriptBox[
      RowBox[{"Log", "[", "f", "]"}], "2"]}], "-", 
    RowBox[{
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"n", "-", "2"}], ")"}], "2"]}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4985097118120337`*^9, 3.4985123465257225`*^9, {
   3.4985124381158504`*^9, 3.4985124580358787`*^9}, 3.4985128378264103`*^9, {
   3.4985172552379403`*^9, 3.4985172559555416`*^9}, {3.4985299780097723`*^9, 
   3.4985299780097723`*^9}, 3.515773004135832*^9, 3.515774639643186*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f_", "^", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"Csch", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "b"}], "*", "p", "*", 
     RowBox[{"Log", "[", "f", "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Csch", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"d", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "2"}], ")"}]}], ")"}]}]}], " ", "-", " ", "\n", 
    "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{
      RowBox[{"Csch", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "-", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}], ")"}]}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "f", ",", "p", ",", "n"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"p", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}], "-", 
      RowBox[{
       RowBox[{"d", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "-", "2"}], ")"}], "^", "2"}]}]}], "]"}], " ", "&&", 
    " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"n", "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"n", "-", "2"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49532208483949*^9, {
   3.498509743462078*^9, 3.4985097607521024`*^9}, {3.498509900942299*^9, 
   3.498509942602357*^9}, {3.4985107807535305`*^9, 3.4985107993935566`*^9}, {
   3.4985114194044247`*^9, 3.4985114217844276`*^9}, 3.4985119359051476`*^9, {
   3.498512231895562*^9, 3.4985122557455955`*^9}, {3.4985123585657396`*^9, 
   3.4985124093458104`*^9}, {3.498512543315998*^9, 3.49851255915602*^9}, {
   3.4985128145563774`*^9, 3.498512814766378*^9}, {3.49851293019654*^9, 
   3.4985129449465604`*^9}, {3.49851721542667*^9, 3.4985172290766945`*^9}, {
   3.498529984592984*^9, 3.498529988368191*^9}, {3.5157730285966744`*^9, 
   3.5157730639931364`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: CRC 552h", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4985097118120337`*^9, 3.4985123465257225`*^9, 
   3.51577464267319*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], 
      SuperscriptBox["p", "2"], 
      SuperscriptBox[
       RowBox[{"Log", "[", "f", "]"}], "2"]}], "-", 
     RowBox[{
      SuperscriptBox["d", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"n", "-", "2"}], ")"}], "2"]}]}], "\[NotEqual]", "0"}], " ", 
   "\[And]", " ", 
   RowBox[{"n", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{"n", "\[NotEqual]", "2"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.4985099493323665`*^9, 3.498509964632388*^9}, {3.4985127051562243`*^9, 
   3.498512749316286*^9}, {3.4985128464164224`*^9, 3.498512849936427*^9}, {
   3.49852995966414*^9, 3.49852995966414*^9}, {3.5157731070024123`*^9, 
   3.5157731070024123`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox["f", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"Sech", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"b", " ", "p", " ", 
        RowBox[{"Log", "[", "f", "]"}], 
        SuperscriptBox[
         RowBox[{"(", 
          SuperscriptBox["f", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}]], ")"}], "p"], " ", 
        SuperscriptBox[
         RowBox[{"Sech", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"n", "-", "2"}]]}], 
       RowBox[{
        SuperscriptBox["d", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"n", "-", "2"}], ")"}]}]]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox["f", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"Sech", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     RowBox[{"n", "-", "1"}]], " ", 
    RowBox[{"Sinh", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}]}], 
   RowBox[{"d", " ", 
    RowBox[{"(", 
     RowBox[{"n", "-", "1"}], ")"}]}]], "-", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], 
      SuperscriptBox["p", "2"], 
      SuperscriptBox[
       RowBox[{"Log", "[", "f", "]"}], "2"]}], "-", 
     RowBox[{
      SuperscriptBox["d", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"n", "-", "2"}], ")"}], "2"]}]}], 
    RowBox[{
     SuperscriptBox["d", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"n", "-", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"n", "-", "2"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox["f", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}]], ")"}], "p"], " ", 
     SuperscriptBox[
      RowBox[{"Sech", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"n", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.498509792342147*^9, 3.498509805332165*^9}, {
   3.4985105306831803`*^9, 3.4985105663032303`*^9}, {3.4985107615335035`*^9, 
   3.4985107704235163`*^9}, 3.4985121452454405`*^9, {3.4985125704460363`*^9, 
   3.498512583846055*^9}, 3.4985127801963296`*^9, {3.498529961208543*^9, 
   3.4985299659353514`*^9}, {3.5157720924498296`*^9, 3.5157720981126394`*^9}, 
   3.515772225408863*^9, {3.5157722764053526`*^9, 3.5157722864205704`*^9}, {
   3.5157729005672493`*^9, 3.5157729032816544`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f_", "^", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"Sech", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"b", "*", "p", "*", 
     RowBox[{"Log", "[", "f", "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sech", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"d", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "2"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{
      RowBox[{"Sech", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "-", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"b", "^", "2"}], "*", 
          RowBox[{"p", "^", "2"}], "*", 
          RowBox[{
           RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}], "-", 
         RowBox[{
          RowBox[{"d", "^", "2"}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"n", "-", "2"}], ")"}], "^", "2"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"d", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{"n", "-", "2"}], ")"}]}], ")"}]}], ",", "\n", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"f", "^", 
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"Sech", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "f", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"p", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}], "-", 
      RowBox[{
       RowBox[{"d", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "-", "2"}], ")"}], "^", "2"}]}]}], "]"}], " ", "&&", 
    " ", "\n", "  ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", "2"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49532208483949*^9, {
   3.498509743462078*^9, 3.4985097607521024`*^9}, {3.498509900942299*^9, 
   3.498509942602357*^9}, {3.4985107807535305`*^9, 3.4985107993935566`*^9}, {
   3.4985114194044247`*^9, 3.4985114217844276`*^9}, 3.4985119359051476`*^9, {
   3.498512231895562*^9, 3.4985122557455955`*^9}, {3.4985123585657396`*^9, 
   3.4985124093458104`*^9}, {3.498512731886262*^9, 3.4985127326962633`*^9}, {
   3.4985299677293544`*^9, 3.4985299748741665`*^9}, {3.5157710204999185`*^9, 
   3.515771022259921*^9}, {3.5157721528687353`*^9, 3.5157722102144365`*^9}, {
   3.515772246858901*^9, 3.5157722506809072`*^9}, {3.5157723616439023`*^9, 
   3.5157724023911743`*^9}, {3.51577244594645*^9, 3.515772464229683*^9}, {
   3.5157725089549613`*^9, 3.5157725336234055`*^9}, {3.51577313980927*^9, 
   3.515773159995705*^9}},
 Background->GrayLevel[0.85]],

Cell["Reference: CRC 551h", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4985097118120337`*^9, 3.4985123465257225`*^9, 
   3.498517253116337*^9, 3.515774645333194*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f_", "^", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"Csch", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "b"}], "*", "p", "*", 
     RowBox[{"Log", "[", "f", "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Csch", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"d", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "2"}], ")"}]}], ")"}]}]}], " ", "-", " ", "\n", 
    "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{
      RowBox[{"Csch", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "-", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"b", "^", "2"}], "*", 
          RowBox[{"p", "^", "2"}], "*", 
          RowBox[{
           RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}], "-", 
         RowBox[{
          RowBox[{"d", "^", "2"}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"n", "-", "2"}], ")"}], "^", "2"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"d", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{"n", "-", "2"}], ")"}]}], ")"}]}], ",", "\n", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"f", "^", 
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"Csch", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "f", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"p", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}], "-", 
      RowBox[{
       RowBox[{"d", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "-", "2"}], ")"}], "^", "2"}]}]}], "]"}], " ", "&&", 
    " ", "\n", "  ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", "2"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49532208483949*^9, {
   3.498509743462078*^9, 3.4985097607521024`*^9}, {3.498509900942299*^9, 
   3.498509942602357*^9}, {3.4985107807535305`*^9, 3.4985107993935566`*^9}, {
   3.4985114194044247`*^9, 3.4985114217844276`*^9}, 3.4985119359051476`*^9, {
   3.498512231895562*^9, 3.4985122557455955`*^9}, {3.4985123585657396`*^9, 
   3.4985124093458104`*^9}, {3.498512731886262*^9, 3.4985127326962633`*^9}, {
   3.4985172189522767`*^9, 3.4985172320562997`*^9}, {3.498517333955679*^9, 
   3.498517334252079*^9}, {3.4985299952478027`*^9, 3.498530000146211*^9}, {
   3.515771035299939*^9, 3.515771036599941*^9}, {3.515772554215441*^9, 
   3.5157725632790575`*^9}, {3.5157726168183513`*^9, 
   3.5157726473476048`*^9}, {3.5157727638954096`*^9, 
   3.5157727643634105`*^9}, {3.5157731669377174`*^9, 3.5157731750029316`*^9}, 
   3.515778241038228*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], 
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox["f", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]], ")"}], "p"], " ", 
   SuperscriptBox[
    RowBox[{"Sinh", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.4953219782293406`*^9, 
   3.495333683275055*^9, 3.498508933670944*^9, 3.498509588381861*^9, 
   3.49850963055192*^9, {3.4985098202421856`*^9, 3.4985098240321913`*^9}, 
   3.498517502123974*^9, 3.498517558908074*^9, 3.5157758750649157`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4985097118120337`*^9, 3.498517997518444*^9}],

Cell[TextData[{
 "Note: Each term of the sum  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["x", 
    RowBox[{"m", "-", "1"}]], " ", "u"}]],
  CellDingbat->None,
  CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
    3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
    3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
    3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
    3.495322146199576*^9, {3.498509792342147*^9, 3.498509805332165*^9}, {
    3.4985105306831803`*^9, 3.4985105663032303`*^9}, {3.4985107615335035`*^9, 
    3.4985107704235163`*^9}, {3.498517644380624*^9, 3.498517680884688*^9}, 
    3.4985177881660767`*^9, {3.4985179631983843`*^9, 3.4985179714975986`*^9}},
  TextAlignment->Center,
  FontSize->12,
  FontWeight->"Bold"],
 " will be similar in form to the original integrand, but the degree of the \
monomial will be smaller by one. "
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4985097118120337`*^9, {3.498517997518444*^9, 
   3.4985180058956585`*^9}, {3.498518086906601*^9, 3.49851810891824*^9}, {
   3.4985181635027356`*^9, 3.4985182415028725`*^9}, {3.498518295946968*^9, 
   3.498518443538828*^9}, 3.5157755871145124`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "0"}]}]]],
 ", let  ",
 Cell[BoxData[
  RowBox[{"u", "=", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox["f", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}]], ")"}], "p"], " ", 
     RowBox[{"Sinh", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.4985099493323665`*^9, 3.498509964632388*^9}, {3.49851785306219*^9, 
   3.49851794940796*^9}, {3.515775931154994*^9, 3.515775931154994*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox["f", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      SuperscriptBox["x", "m"]}]}], "u"}]}], "-", 
  RowBox[{"m", " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "1"}]], " ", "u", 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.498509792342147*^9, 3.498509805332165*^9}, {
   3.4985105306831803`*^9, 3.4985105663032303`*^9}, {3.4985107615335035`*^9, 
   3.4985107704235163`*^9}, {3.498517644380624*^9, 3.498517680884688*^9}, 
   3.4985177881660767`*^9, {3.4985179631983843`*^9, 3.4985179714975986`*^9}, 
   3.515775876664918*^9, 3.515775967255045*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f_", "^", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"u", "=", 
       RowBox[{"Block", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ShowSteps", "=", "False"}], ",", 
           RowBox[{"StepCounter", "=", "Null"}]}], "}"}], ",", " ", 
         RowBox[{"Int", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"f", "^", 
               RowBox[{"(", 
                RowBox[{"a", "+", 
                 RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
            RowBox[{
             RowBox[{"Sinh", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "n"}]}], ",", "x"}], 
          "]"}]}], "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "m"}], "*", "u"}], " ", "-", " ", 
      RowBox[{"Dist", "[", 
       RowBox[{"m", ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", 
            RowBox[{"(", 
             RowBox[{"m", "-", "1"}], ")"}]}], "*", "u"}], ",", "x"}], 
         "]"}]}], "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "f", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49532208483949*^9, {
   3.498509743462078*^9, 3.4985097607521024`*^9}, {3.498509900942299*^9, 
   3.498509942602357*^9}, {3.4985107807535305`*^9, 3.4985107993935566`*^9}, {
   3.4985114194044247`*^9, 3.4985114217844276`*^9}, {3.498517526163616*^9, 
   3.498517584632519*^9}, {3.498517615395773*^9, 3.4985176162381744`*^9}, {
   3.4985178263393435`*^9, 3.498517828226947*^9}, 3.5157756676746254`*^9, {
   3.5157757506547413`*^9, 3.515775798454808*^9}, 3.515775841474869*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f_", "^", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"u", "=", 
       RowBox[{"Block", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ShowSteps", "=", "False"}], ",", 
           RowBox[{"StepCounter", "=", "Null"}]}], "}"}], ",", " ", 
         RowBox[{"Int", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"f", "^", 
               RowBox[{"(", 
                RowBox[{"a", "+", 
                 RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
            RowBox[{
             RowBox[{"Cosh", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "n"}]}], ",", "x"}], 
          "]"}]}], "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "m"}], "*", "u"}], " ", "-", " ", 
      RowBox[{"Dist", "[", 
       RowBox[{"m", ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", 
            RowBox[{"(", 
             RowBox[{"m", "-", "1"}], ")"}]}], "*", "u"}], ",", "x"}], 
         "]"}]}], "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "f", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49532208483949*^9, {
   3.498509743462078*^9, 3.4985097607521024`*^9}, {3.498509900942299*^9, 
   3.498509942602357*^9}, {3.4985107807535305`*^9, 3.4985107993935566`*^9}, {
   3.4985114194044247`*^9, 3.4985114217844276`*^9}, {3.498517526163616*^9, 
   3.498517584632519*^9}, {3.498517615395773*^9, 3.4985176162381744`*^9}, {
   3.4985178263393435`*^9, 3.498517828226947*^9}, {3.498518520493763*^9, 
   3.4985185215701647`*^9}, 3.5157756947146635`*^9, {3.5157757536147456`*^9, 
   3.515775802204814*^9}, 3.5157758441148725`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["f", "v"], " ", 
   SuperscriptBox[
    RowBox[{"Sinh", "[", "w", "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.4953219782293406`*^9, 
   3.495333683275055*^9, 3.498508933670944*^9, 3.498509588381861*^9, 
   3.49850963055192*^9, {3.4985098202421856`*^9, 3.4985098240321913`*^9}, 
   3.498517502123974*^9, 3.498517558908074*^9, 3.498518518294159*^9, 
   3.498705778387356*^9, 3.515771858751092*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4985097118120337`*^9, 3.498517997518444*^9, 
   3.498705797434989*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Sinh", "[", "z", "]"}], "=", 
   RowBox[{
    FractionBox[
     SuperscriptBox["\[ExponentialE]", "z"], "2"], "-", 
    FractionBox["1", 
     RowBox[{"2", 
      SuperscriptBox["\[ExponentialE]", "z"]}]]}]}]]],
 " "
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4985097118120337`*^9, {3.498517997518444*^9, 
   3.4985180058956585`*^9}, {3.498518086906601*^9, 3.49851810891824*^9}, {
   3.4985181635027356`*^9, 3.4985182415028725`*^9}, {3.498518295946968*^9, 
   3.498518443538828*^9}, {3.498705805484603*^9, 3.4987058338610525`*^9}, {
   3.498705925573614*^9, 3.498705938864837*^9}, {3.498706631593254*^9, 
   3.498706644837678*^9}, {3.51577130736032*^9, 3.5157713110903254`*^9}, {
   3.515771356830389*^9, 3.515771356830389*^9}, {3.5157717647309604`*^9, 
   3.5157717669509635`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
  "v", " ", "and", " ", "w", " ", "are", " ", "quadratic", " ", "polynomials",
    " ", "in", " ", "x"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.4985099493323665`*^9, 3.498509964632388*^9}, {3.49851785306219*^9, 
   3.49851794940796*^9}, 3.49851851912096*^9, {3.4987059704860926`*^9, 
   3.4987059967097387`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["f", "v"], " ", 
    RowBox[{"Sinh", "[", "w", "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "2"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox["f", "v"], 
      SuperscriptBox["\[ExponentialE]", "w"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox["f", "v"], 
      SuperscriptBox["\[ExponentialE]", "w"]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.498509792342147*^9, 3.498509805332165*^9}, {
   3.4985105306831803`*^9, 3.4985105663032303`*^9}, {3.4985107615335035`*^9, 
   3.4985107704235163`*^9}, {3.498517644380624*^9, 3.498517680884688*^9}, 
   3.4985177881660767`*^9, {3.4985179631983843`*^9, 3.4985179714975986`*^9}, 
   3.498518519542161*^9, {3.498705884498742*^9, 3.4987058980707655`*^9}, {
   3.515771860471094*^9, 3.515771923641183*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"f_", "^", "v_"}], "*", 
     RowBox[{"Sinh", "[", "w_", "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", 
  "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"f", "^", "v"}], "*", 
         RowBox[{"E", "^", "w"}]}], ",", "x"}], "]"}]}], "]"}], " ", "-", " ",
     "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"f", "^", "v"}], "/", 
         RowBox[{"E", "^", "w"}]}], ",", "x"}], "]"}]}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"f", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"PolynomialQ", "[", 
     RowBox[{"v", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"Exponent", "[", 
      RowBox[{"v", ",", "x"}], "]"}], "\[LessEqual]", "2"}], " ", "&&", " ", 
    RowBox[{"PolynomialQ", "[", 
     RowBox[{"w", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"Exponent", "[", 
      RowBox[{"w", ",", "x"}], "]"}], "\[LessEqual]", "2"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49532208483949*^9, {
   3.498509743462078*^9, 3.4985097607521024`*^9}, {3.498509900942299*^9, 
   3.498509942602357*^9}, {3.4985107807535305`*^9, 3.4985107993935566`*^9}, {
   3.4985114194044247`*^9, 3.4985114217844276`*^9}, {3.498517526163616*^9, 
   3.498517584632519*^9}, {3.498517615395773*^9, 3.4985176162381744`*^9}, {
   3.4985178263393435`*^9, 3.498517828226947*^9}, {3.498518520493763*^9, 
   3.4985185215701647`*^9}, 3.49870579216218*^9, {3.5157711155100517`*^9, 
   3.5157711218600607`*^9}},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Cosh", "[", "z", "]"}], "=", 
   RowBox[{
    FractionBox[
     SuperscriptBox["\[ExponentialE]", "z"], "2"], "+", 
    FractionBox["1", 
     RowBox[{"2", 
      SuperscriptBox["\[ExponentialE]", "z"]}]]}]}]]],
 " "
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4985097118120337`*^9, {3.498517997518444*^9, 
   3.4985180058956585`*^9}, {3.498518086906601*^9, 3.49851810891824*^9}, {
   3.4985181635027356`*^9, 3.4985182415028725`*^9}, {3.498518295946968*^9, 
   3.498518443538828*^9}, {3.498705805484603*^9, 3.4987058338610525`*^9}, {
   3.498705925573614*^9, 3.498705938864837*^9}, 3.4987063008946733`*^9, {
   3.498706342044346*^9, 3.498706347207955*^9}, {3.4987064659209633`*^9, 
   3.4987064983534203`*^9}, 3.515770643569391*^9, 3.5157714756305556`*^9, {
   3.5157718010810113`*^9, 3.5157718058410177`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"f_", "^", "v_"}], "*", 
     RowBox[{"Cosh", "[", "w_", "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", 
  "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"f", "^", "v"}], "*", 
         RowBox[{"E", "^", "w"}]}], ",", "x"}], "]"}]}], "]"}], " ", "+", " ",
     "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"f", "^", "v"}], "/", 
         RowBox[{"E", "^", "w"}]}], ",", "x"}], "]"}]}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"f", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"PolynomialQ", "[", 
     RowBox[{"v", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"Exponent", "[", 
      RowBox[{"v", ",", "x"}], "]"}], "\[LessEqual]", "2"}], " ", "&&", " ", 
    RowBox[{"PolynomialQ", "[", 
     RowBox[{"w", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"Exponent", "[", 
      RowBox[{"w", ",", "x"}], "]"}], "\[LessEqual]", "2"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49532208483949*^9, {
   3.498509743462078*^9, 3.4985097607521024`*^9}, {3.498509900942299*^9, 
   3.498509942602357*^9}, {3.4985107807535305`*^9, 3.4985107993935566`*^9}, {
   3.4985114194044247`*^9, 3.4985114217844276`*^9}, {3.498517526163616*^9, 
   3.498517584632519*^9}, {3.498517615395773*^9, 3.4985176162381744`*^9}, {
   3.4985178263393435`*^9, 3.498517828226947*^9}, {3.498518520493763*^9, 
   3.4985185215701647`*^9}, 3.49870579216218*^9, {3.498706302329876*^9, 
   3.4987063146350975`*^9}, 3.5157715103206043`*^9, {3.515771562410677*^9, 
   3.515771565770682*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4985097118120337`*^9, 3.498517997518444*^9, 
   3.498705797434989*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Sinh", "[", "z", "]"}], "=", 
   RowBox[{
    FractionBox["1", "2"], 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "z"], "-", 
      FractionBox["1", 
       SuperscriptBox["\[ExponentialE]", "z"]]}], ")"}]}]}]]],
 " "
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4985097118120337`*^9, {3.498517997518444*^9, 
   3.4985180058956585`*^9}, {3.498518086906601*^9, 3.49851810891824*^9}, {
   3.4985181635027356`*^9, 3.4985182415028725`*^9}, {3.498518295946968*^9, 
   3.498518443538828*^9}, {3.498705805484603*^9, 3.4987058338610525`*^9}, {
   3.498705925573614*^9, 3.498705938864837*^9}, 3.4987061267203674`*^9, {
   3.515771445940514*^9, 3.515771445940514*^9}, {3.515771645830794*^9, 
   3.515771663150818*^9}, {3.515771818311035*^9, 3.5157718203710384`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{
   "v", " ", "and", " ", "w", " ", "are", " ", "quadratic", " ", 
    "polynomials", " ", "in", " ", "x"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.4985099493323665`*^9, 3.498509964632388*^9}, {3.49851785306219*^9, 
   3.49851794940796*^9}, 3.49851851912096*^9, {3.4987059704860926`*^9, 
   3.4987059967097387`*^9}, {3.4987061790740595`*^9, 3.4987062076221094`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["f", "v"], " ", 
   SuperscriptBox[
    RowBox[{"Sinh", "[", "w", "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      SuperscriptBox["2", "n"]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["f", "v"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", "w"], "-", 
        FractionBox["1", 
         SuperscriptBox["\[ExponentialE]", "w"]]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.498509792342147*^9, 3.498509805332165*^9}, {
   3.4985105306831803`*^9, 3.4985105663032303`*^9}, {3.4985107615335035`*^9, 
   3.4985107704235163`*^9}, {3.498517644380624*^9, 3.498517680884688*^9}, 
   3.4985177881660767`*^9, {3.4985179631983843`*^9, 3.4985179714975986`*^9}, 
   3.498518519542161*^9, {3.498705884498742*^9, 3.4987058980707655`*^9}, 
   3.49870616241323*^9, 3.4987062656386113`*^9, {3.5157717057208776`*^9, 
   3.5157717237309027`*^9}, 3.515771863101098*^9, {3.5157719693812466`*^9, 
   3.515771980881263*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"f_", "^", "v_"}], "*", 
     RowBox[{
      RowBox[{"Sinh", "[", "w_", "]"}], "^", "n_"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"2", "^", "n"}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"f", "^", "v"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"E", "^", "w"}], "-", 
           RowBox[{"1", "/", 
            RowBox[{"E", "^", "w"}]}]}], ")"}], "^", "n"}]}], ",", "x"}], 
      "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"f", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"PolynomialQ", "[", 
     RowBox[{"v", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"Exponent", "[", 
      RowBox[{"v", ",", "x"}], "]"}], "\[LessEqual]", "2"}], " ", "&&", " ", 
    "\n", "  ", 
    RowBox[{"PolynomialQ", "[", 
     RowBox[{"w", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"Exponent", "[", 
      RowBox[{"w", ",", "x"}], "]"}], "\[LessEqual]", "2"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49532208483949*^9, {
   3.498509743462078*^9, 3.4985097607521024`*^9}, {3.498509900942299*^9, 
   3.498509942602357*^9}, {3.4985107807535305`*^9, 3.4985107993935566`*^9}, {
   3.4985114194044247`*^9, 3.4985114217844276`*^9}, {3.498517526163616*^9, 
   3.498517584632519*^9}, {3.498517615395773*^9, 3.4985176162381744`*^9}, {
   3.4985178263393435`*^9, 3.498517828226947*^9}, {3.498518520493763*^9, 
   3.4985185215701647`*^9}, 3.49870579216218*^9, 3.4987060814958878`*^9, 
   3.5157714967405853`*^9, {3.515771551850662*^9, 3.51577155744067*^9}, {
   3.5159562105292397`*^9, 3.5159562156304483`*^9}},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Cosh", "[", "z", "]"}], "=", 
   RowBox[{
    FractionBox["1", "2"], 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "z"], "+", 
      FractionBox["1", 
       SuperscriptBox["\[ExponentialE]", "z"]]}], ")"}]}]}]]],
 " "
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4985097118120337`*^9, {3.498517997518444*^9, 
   3.4985180058956585`*^9}, {3.498518086906601*^9, 3.49851810891824*^9}, {
   3.4985181635027356`*^9, 3.4985182415028725`*^9}, {3.498518295946968*^9, 
   3.498518443538828*^9}, {3.498705805484603*^9, 3.4987058338610525`*^9}, {
   3.498705925573614*^9, 3.498705938864837*^9}, 3.4987061267203674`*^9, 
   3.498706303047477*^9, 3.498706334868333*^9, {3.5157714597805333`*^9, 
   3.5157714680905447`*^9}, {3.515771832601055*^9, 3.5157718353010592`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"f_", "^", "v_"}], "*", 
     RowBox[{
      RowBox[{"Cosh", "[", "w_", "]"}], "^", "n_"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"2", "^", "n"}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"f", "^", "v"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"E", "^", "w"}], "+", 
           RowBox[{"1", "/", 
            RowBox[{"E", "^", "w"}]}]}], ")"}], "^", "n"}]}], ",", "x"}], 
      "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"f", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"PolynomialQ", "[", 
     RowBox[{"v", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"Exponent", "[", 
      RowBox[{"v", ",", "x"}], "]"}], "\[LessEqual]", "2"}], " ", "&&", " ", 
    "\n", "  ", 
    RowBox[{"PolynomialQ", "[", 
     RowBox[{"w", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"Exponent", "[", 
      RowBox[{"w", ",", "x"}], "]"}], "\[LessEqual]", "2"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49532208483949*^9, {
   3.498509743462078*^9, 3.4985097607521024`*^9}, {3.498509900942299*^9, 
   3.498509942602357*^9}, {3.4985107807535305`*^9, 3.4985107993935566`*^9}, {
   3.4985114194044247`*^9, 3.4985114217844276`*^9}, {3.498517526163616*^9, 
   3.498517584632519*^9}, {3.498517615395773*^9, 3.4985176162381744`*^9}, {
   3.4985178263393435`*^9, 3.498517828226947*^9}, {3.498518520493763*^9, 
   3.4985185215701647`*^9}, 3.49870579216218*^9, 3.4987060814958878`*^9, {
   3.49870630473228*^9, 3.498706321062309*^9}, 3.5157715213006196`*^9, {
   3.5157715546306663`*^9, 3.515771559740673*^9}, {3.5159562204976573`*^9, 
   3.5159562213400583`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]]
},
AutoGeneratedPackage->Automatic,
CellGrouping->Manual,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  "Integration Rules for Products of Exponential and Hyperbolic Functions", 
   None, None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->28.8},
Magnification->1.600000023841858,
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 1243, 28, 136, "Title"],
Cell[1813, 52, 236, 4, 41, "Subsubsection"],
Cell[2052, 58, 1146, 24, 31, "Subsubsection"],
Cell[3201, 84, 2206, 61, 133, "Subsubtitle"],
Cell[5410, 147, 771, 11, 41, "Subsubsection"],
Cell[6184, 160, 3098, 85, 144, "Code"],
Cell[9285, 247, 258, 4, 41, "Subsubsection"],
Cell[9546, 253, 3116, 85, 144, "Code"],
Cell[12665, 340, 89, 2, 41, "Subsubsection"],
Cell[12757, 344, 256, 4, 29, "Subsubsection"],
Cell[13016, 350, 1275, 29, 31, "Subsubsection"],
Cell[14294, 381, 3539, 104, 153, "Subsubtitle"],
Cell[17836, 487, 771, 11, 41, "Subsubsection"],
Cell[18610, 500, 4593, 133, 172, "Code"],
Cell[23206, 635, 284, 4, 41, "Subsubsection"],
Cell[23493, 641, 4667, 134, 172, "Code"],
Cell[28163, 777, 89, 2, 41, "Subsubsection"],
Cell[28255, 781, 766, 21, 31, "Subsubsection"],
Cell[29024, 804, 1623, 36, 31, "Subsubsection"],
Cell[30650, 842, 2668, 69, 133, "Subsubtitle"],
Cell[33321, 913, 771, 11, 41, "Subsubsection"],
Cell[34095, 926, 3740, 101, 144, "Code"],
Cell[37838, 1029, 788, 21, 43, "Subsubsection"],
Cell[38629, 1052, 3875, 102, 144, "Code"],
Cell[42507, 1156, 89, 2, 41, "Subsubsection"],
Cell[42599, 1160, 352, 5, 29, "Subsubsection"],
Cell[42954, 1167, 1544, 36, 31, "Subsubsection"],
Cell[44501, 1205, 3572, 102, 153, "Subsubtitle"],
Cell[48076, 1309, 771, 11, 41, "Subsubsection"],
Cell[48850, 1322, 4820, 138, 172, "Code"],
Cell[53673, 1462, 405, 6, 41, "Subsubsection"],
Cell[54081, 1470, 4948, 139, 172, "Code"],
Cell[59032, 1611, 44, 1, 5, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[59113, 1617, 1293, 29, 92, "Title"],
Cell[60409, 1648, 776, 21, 43, "Subsubsection"],
Cell[61188, 1671, 1570, 35, 31, "Subsubsection"],
Cell[62761, 1708, 2336, 64, 133, "Subsubtitle"],
Cell[65100, 1774, 771, 11, 41, "Subsubsection"],
Cell[65874, 1787, 3337, 96, 144, "Code"],
Cell[69214, 1885, 802, 21, 43, "Subsubsection"],
Cell[70019, 1908, 3409, 98, 144, "Code"],
Cell[73431, 2008, 89, 2, 41, "Subsubsection"],
Cell[73523, 2012, 233, 4, 29, "Subsubsection"],
Cell[73759, 2018, 1433, 33, 31, "Subsubsection"],
Cell[75195, 2053, 3383, 99, 153, "Subsubtitle"],
Cell[78581, 2154, 771, 11, 41, "Subsubsection"],
Cell[79355, 2167, 4755, 135, 228, "Code"],
Cell[84113, 2304, 256, 4, 41, "Subsubsection"],
Cell[84372, 2310, 4804, 137, 228, "Code"],
Cell[89179, 2449, 44, 1, 5, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[89260, 2455, 1295, 29, 92, "Title"],
Cell[90558, 2486, 219, 3, 166, "Subsubsection"],
Cell[90780, 2491, 1327, 26, 124, "Subsubsection"],
Cell[92110, 2519, 1405, 33, 137, "Subsubsection"],
Cell[93518, 2554, 1411, 35, 244, "Subsubtitle"],
Cell[94932, 2591, 771, 11, 166, "Subsubsection"],
Cell[95706, 2604, 2722, 72, 588, "Code"],
Cell[98431, 2678, 2776, 73, 636, "Code"],
Cell[101210, 2753, 44, 1, 19, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[101291, 2759, 1151, 23, 92, "Title"],
Cell[102445, 2784, 244, 4, 41, "Subsubsection"],
Cell[102692, 2790, 943, 22, 43, "Subsubsection"],
Cell[103638, 2814, 999, 19, 30, "Subsubsection"],
Cell[104640, 2835, 1470, 35, 67, "Subsubtitle"],
Cell[106113, 2872, 771, 11, 41, "Subsubsection"],
Cell[106887, 2885, 1930, 50, 144, "Code"],
Cell[108820, 2937, 970, 22, 55, "Subsubsection"],
Cell[109793, 2961, 2002, 51, 144, "Code"],
Cell[111798, 3014, 89, 2, 41, "Subsubsection"],
Cell[111890, 3018, 244, 4, 29, "Subsubsection"],
Cell[112137, 3024, 943, 22, 42, "Subsubsection"],
Cell[113083, 3048, 1194, 22, 30, "Subsubsection"],
Cell[114280, 3072, 1560, 35, 65, "Subsubtitle"],
Cell[115843, 3109, 771, 11, 41, "Subsubsection"],
Cell[116617, 3122, 2069, 51, 144, "Code"],
Cell[118689, 3175, 945, 22, 54, "Subsubsection"],
Cell[119637, 3199, 2121, 52, 144, "Code"],
Cell[121761, 3253, 44, 1, 5, "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}
]
*)

(* End of internal cache information *)
