(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    424723,      10464]
NotebookOptionsPosition[    406656,      10050]
NotebookOutlinePosition[    407770,      10089]
CellTagsIndexPosition[    407727,      10086]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"c", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], ")"}], "n"]}]}], ")"}], "p"]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, {
   3.494172650949109*^9, 3.494172665319129*^9}, 3.4951614288955455`*^9, 
   3.4951617140016465`*^9, {3.495162187524878*^9, 3.495162197867696*^9}, 
   3.495162421681289*^9, 3.495163536311648*^9, 3.495310969848205*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.728.1, CRC 499, A&S 4.1.49", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4940010628073196`*^9, 3.4941723607787027`*^9, 3.4941724567488375`*^9, 
   3.494172696119172*^9, 3.4951614417343683`*^9, {3.495311424688842*^9, 
   3.495311425778844*^9}}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9, 3.495161586221822*^9, 
  3.4951636037349663`*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, 3.4951636244830027`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"c", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], ")"}], "n"]}], ")"}], "p"]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], ")"}], " ", 
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"b", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"d", "+", 
                RowBox[{"e", " ", "x"}]}], ")"}], "n"]}], ")"}], "p"]}], 
         "]"}]}], "e"]}]}]}]}], "-", 
  RowBox[{"n", " ", "p", " ", "x"}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, {3.495161845931078*^9, 
   3.4951618787379355`*^9}, {3.495163638398227*^9, 3.495163646853442*^9}, 
   3.49516370254554*^9, {3.495310853108042*^9, 3.4953108742780714`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"c_.", "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d_.", "+", 
            RowBox[{"e_.", "*", "x_"}]}], ")"}], "^", "n_."}]}], ")"}], "^", 
       "p_."}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"e", "*", "x"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"c", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"b", "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], ")"}], "^", "n"}]}], ")"}], "^", 
         "p"}]}], "]"}], "/", "e"}]}], " ", "-", " ", 
    RowBox[{"n", "*", "p", "*", "x"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"b", ",", "c", ",", "d", ",", "e", ",", "n", ",", "p"}], "}"}], 
     ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4951616675135646`*^9, 3.495163619631394*^9, {
   3.4953109063281164`*^9, 3.495310938248161*^9}, 3.4953114494188766`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Reference: G&R 2.728.1", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4940010628073196`*^9, 3.4941723607787027`*^9, 3.4941724567488375`*^9, 
   3.494172696119172*^9, 3.4951614417343683`*^9, 3.495161553867365*^9, 
   3.49516358311173*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", "<", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, {3.495162264932214*^9, 
   3.495162277318636*^9}, {3.4951637747120676`*^9, 3.495163775320469*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"c", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], ")"}], "n"]}]}], ")"}], "p"]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], ")"}], " ", 
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"d", "+", 
                 RowBox[{"e", " ", "x"}]}], ")"}], "n"]}]}], ")"}], "p"]}], 
         "]"}]}], "e"]}]}]}]}], "-", 
  RowBox[{"b", " ", "n", " ", "p", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"b", "+", 
       RowBox[{"a", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], ")"}], 
         RowBox[{"-", "n"}]]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, 3.4951622258697453`*^9, 
   3.4951623402647467`*^9, {3.4951637900936947`*^9, 3.4951638150849385`*^9}, {
   3.4953106019576902`*^9, 3.4953106292577286`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"c_.", "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"d_.", "+", 
             RowBox[{"e_.", "*", "x_"}]}], ")"}], "^", "n_"}]}]}], ")"}], "^",
        "p_."}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"e", "*", "x"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"c", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"d", "+", 
               RowBox[{"e", "*", "x"}]}], ")"}], "^", "n"}]}]}], ")"}], "^", 
         "p"}]}], "]"}], "/", "e"}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", "n", "*", "p"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"b", "+", 
           RowBox[{"a", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"d", "+", 
               RowBox[{"e", "*", "x"}]}], ")"}], "^", 
             RowBox[{"(", 
              RowBox[{"-", "n"}], ")"}]}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4951616878092003`*^9, 3.495162292263462*^9, 
   3.495163765133651*^9, 3.4951638729766407`*^9, {3.495310699757827*^9, 
   3.495310720997857*^9}, {3.4953129624209948`*^9, 3.495312984921026*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Reference: G&R 2.728.1", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4940010628073196`*^9, 3.4941723607787027`*^9, 3.4941724567488375`*^9, 
   3.494172696119172*^9, 3.4951614417343683`*^9, 3.495161553867365*^9, 
   3.49516358311173*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"\[Not]", 
   RowBox[{"(", 
    RowBox[{"n", "<", "0"}], ")"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, {3.495162264932214*^9, 
   3.495162277318636*^9}, {3.4951637747120676`*^9, 3.495163775320469*^9}, {
   3.4953130432311077`*^9, 3.4953130467311125`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"c", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], ")"}], "n"]}]}], ")"}], "p"]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], ")"}], " ", 
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"d", "+", 
                 RowBox[{"e", " ", "x"}]}], ")"}], "n"]}]}], ")"}], "p"]}], 
         "]"}]}], "e"]}]}]}]}], "-", 
  RowBox[{"n", " ", "p", " ", "x"}], "+", 
  RowBox[{"a", " ", "n", " ", "p", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], ")"}], "n"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, 3.4951622258697453`*^9, 
   3.4951623402647467`*^9, {3.4951637900936947`*^9, 3.4951638150849385`*^9}, 
   3.4951639089035034`*^9, {3.495310296257262*^9, 3.4953103712673674`*^9}, {
   3.495310414297427*^9, 3.495310414497428*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"c_.", "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"d_.", "+", 
             RowBox[{"e_.", "*", "x_"}]}], ")"}], "^", "n_."}]}]}], ")"}], 
       "^", "p_."}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"e", "*", "x"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"c", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"d", "+", 
               RowBox[{"e", "*", "x"}]}], ")"}], "^", "n"}]}]}], ")"}], "^", 
         "p"}]}], "]"}], "/", "e"}]}], " ", "-", " ", 
    RowBox[{"n", "*", "p", "*", "x"}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", "n", "*", "p"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"d", "+", 
               RowBox[{"e", "*", "x"}]}], ")"}], "^", "n"}]}]}], ")"}]}], ",",
         "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "n", ",", "p"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
      RowBox[{"n", "<", "0"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4951616878092003`*^9, 3.495162292263462*^9, 
   3.495163765133651*^9, {3.495163853055405*^9, 3.4951638701998353`*^9}, {
   3.4953104344474554`*^9, 3.4953105032775517`*^9}, {3.495310535597597*^9, 
   3.4953105443776093`*^9}, {3.495312989961033*^9, 3.495313015421069*^9}},
 Background->GrayLevel[0.85]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Log", "[", 
        RowBox[{"c", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], ")"}], "n"]}], "]"}]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, {
   3.494172650949109*^9, 3.494172665319129*^9}, 3.4951614288955455`*^9, 
   3.4951617140016465`*^9, {3.495162187524878*^9, 3.495162197867696*^9}, 
   3.495162421681289*^9, 3.495163536311648*^9, 3.4951639784796257`*^9, 
   3.495199809276436*^9, {3.4953116365991383`*^9, 3.495311642609147*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: CRC 492", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4940010628073196`*^9, 3.4941723607787027`*^9, 3.4941724567488375`*^9, 
   3.494172696119172*^9, 3.4951614417343683`*^9, 3.495161553867365*^9, 
   3.49516358311173*^9, 3.4951639989000616`*^9, 3.495199830136465*^9}],

Cell["Derivation: Primitive rule", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4940010628073196`*^9, 3.4941723607787027`*^9, 3.4941724567488375`*^9, 
   3.494172696119172*^9, 3.4951614417343683`*^9, 3.495161553867365*^9, 
   3.49516358311173*^9, 3.4951639989000616`*^9, 3.4951647977306643`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    RowBox[{"LogIntegral", "[", "x", "]"}]}], "=", 
   FractionBox["1", 
    RowBox[{"Log", "[", "x", "]"}]]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4940010628073196`*^9, 3.4941723607787027`*^9, 3.4941724567488375`*^9, 
   3.494172696119172*^9, 3.4951614417343683`*^9, 3.495161553867365*^9, 
   3.49516358311173*^9, 3.4951639989000616`*^9, {3.4951648090562844`*^9, 
   3.495164816591098*^9}, 3.4951998608665075`*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, 3.4951636244830027`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"Log", "[", 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], ")"}]}], "]"}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"LogIntegral", "[", 
       RowBox[{"c", " ", 
        RowBox[{"(", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], ")"}]}], "]"}], 
      RowBox[{"c", " ", "e"}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, {3.495161845931078*^9, 
   3.4951618787379355`*^9}, {3.495163638398227*^9, 3.495163646853442*^9}, 
   3.49516370254554*^9, {3.495164038477331*^9, 3.4951640737177925`*^9}, 
   3.495199899876562*^9, 3.49519994111662*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Log", "[", 
      RowBox[{"c_.", "*", 
       RowBox[{"(", 
        RowBox[{"d_.", "+", 
         RowBox[{"e_.", "*", "x_"}]}], ")"}]}], "]"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"LogIntegral", "[", 
     RowBox[{"c", "*", 
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", "*", "x"}]}], ")"}]}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"c", "*", "e"}], ")"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", "d", ",", "e"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4951616675135646`*^9, 3.495163619631394*^9, 
   3.495164018025695*^9, 3.495199875426528*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Primitive rule", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4940010628073196`*^9, 3.4941723607787027`*^9, 3.4941724567488375`*^9, 
   3.494172696119172*^9, 3.4951614417343683`*^9, 3.495161553867365*^9, 
   3.49516358311173*^9, 3.4951639989000616`*^9, 3.4951647977306643`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    RowBox[{"ExpIntegralEi", "[", "x", "]"}]}], "=", 
   FractionBox[
    SuperscriptBox["\[ExponentialE]", "x"], "x"]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4940010628073196`*^9, 3.4941723607787027`*^9, 3.4941724567488375`*^9, 
   3.494172696119172*^9, 3.4951614417343683`*^9, 3.495161553867365*^9, 
   3.49516358311173*^9, 3.4951639989000616`*^9, {3.4951648090562844`*^9, 
   3.495164816591098*^9}, 3.4951998608665075`*^9, 3.4951999947566953`*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, 3.4951636244830027`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Log", "[", 
       RowBox[{"c", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], ")"}], "n"]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], ")"}], " ", 
       RowBox[{"ExpIntegralEi", "[", 
        FractionBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Log", "[", 
            RowBox[{"c", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"d", "+", 
                RowBox[{"e", " ", "x"}]}], ")"}], "n"]}], "]"}]}]}], 
         RowBox[{"b", " ", "n"}]], "]"}]}], 
      RowBox[{"b", " ", "e", " ", "n", " ", 
       SuperscriptBox["\[ExponentialE]", 
        FractionBox["a", 
         RowBox[{"b", " ", "n"}]]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], ")"}], "n"]}], ")"}], 
        RowBox[{"1", "/", "n"}]]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, {3.495161845931078*^9, 
   3.4951618787379355`*^9}, {3.495163638398227*^9, 3.495163646853442*^9}, 
   3.49516370254554*^9, {3.495164038477331*^9, 3.4951640737177925`*^9}, 
   3.495199899876562*^9, 3.49519994111662*^9, {3.4952000649467936`*^9, 
   3.495200075966809*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c_.", "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"d_.", "+", 
             RowBox[{"e_.", "*", "x_"}]}], ")"}], "^", "n_."}]}], "]"}]}]}], 
      ")"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"d", "+", 
      RowBox[{"e", "*", "x"}]}], ")"}], "*", 
    RowBox[{
     RowBox[{"ExpIntegralEi", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"d", "+", 
               RowBox[{"e", "*", "x"}]}], ")"}], "^", "n"}]}], "]"}]}]}], 
        ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", "n"}], ")"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"b", "*", "e", "*", "n", "*", 
       RowBox[{"E", "^", 
        RowBox[{"(", 
         RowBox[{"a", "/", 
          RowBox[{"(", 
           RowBox[{"b", "*", "n"}], ")"}]}], ")"}]}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"c", "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"d", "+", 
             RowBox[{"e", "*", "x"}]}], ")"}], "^", "n"}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "n"}], ")"}]}]}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "n"}], "}"}], 
     ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4951616675135646`*^9, 3.495163619631394*^9, 
   3.495164018025695*^9, 3.495199875426528*^9, 3.4952000136967216`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"b", " ", "n"}], ">", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, {3.495162264932214*^9, 
   3.495162277318636*^9}, {3.4951637747120676`*^9, 3.495163775320469*^9}, {
   3.4951642488437004`*^9, 3.4951642509653044`*^9}, {3.495200116396866*^9, 
   3.4952001199668703`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Log", "[", 
        RowBox[{"c", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], ")"}], "n"]}], "]"}]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SqrtBox["\[Pi]"], " ", 
       SqrtBox[
        RowBox[{"b", " ", "n"}]], 
       RowBox[{"(", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], ")"}], " ", 
       RowBox[{"Erfi", "[", 
        FractionBox[
         SqrtBox[
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Log", "[", 
             RowBox[{"c", " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"d", "+", 
                 RowBox[{"e", " ", "x"}]}], ")"}], "n"]}], "]"}]}]}]], 
         SqrtBox[
          RowBox[{"b", " ", "n"}]]], "]"}]}], 
      RowBox[{"b", " ", "e", " ", "n", " ", 
       SuperscriptBox["\[ExponentialE]", 
        FractionBox["a", 
         RowBox[{"b", " ", "n"}]]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], ")"}], "n"]}], ")"}], 
        RowBox[{"1", "/", "n"}]]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, 3.4951622258697453`*^9, 
   3.4951623402647467`*^9, {3.4951637900936947`*^9, 3.4951638150849385`*^9}, {
   3.495164178986778*^9, 3.4951642244608574`*^9}, 3.495200200566983*^9, {
   3.495200231817027*^9, 3.4952002386470366`*^9}, 3.4952002942571144`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c_.", "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"d_.", "+", 
             RowBox[{"e_.", "*", "x_"}]}], ")"}], "^", "n_."}]}], "]"}]}]}], 
      "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Sqrt", "[", "Pi", "]"}], "*", 
    RowBox[{"Rt", "[", 
     RowBox[{
      RowBox[{"b", "*", "n"}], ",", "2"}], "]"}], "*", 
    RowBox[{"(", 
     RowBox[{"d", "+", 
      RowBox[{"e", "*", "x"}]}], ")"}], "*", 
    RowBox[{
     RowBox[{"Erfi", "[", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"d", "+", 
               RowBox[{"e", "*", "x"}]}], ")"}], "^", "n"}]}], "]"}]}]}], 
        "]"}], "/", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{"b", "*", "n"}], ",", "2"}], "]"}]}], "]"}], "/", "\n", 
     "    ", 
     RowBox[{"(", 
      RowBox[{"b", "*", "e", "*", "n", "*", 
       RowBox[{"E", "^", 
        RowBox[{"(", 
         RowBox[{"a", "/", 
          RowBox[{"(", 
           RowBox[{"b", "*", "n"}], ")"}]}], ")"}]}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"c", "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"d", "+", 
             RowBox[{"e", "*", "x"}]}], ")"}], "^", "n"}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "n"}], ")"}]}]}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "n"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"PosQ", "[", 
     RowBox[{"b", "*", "n"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4951616878092003`*^9, 3.495162292263462*^9, 
   3.495163765133651*^9, 3.4951638729766407`*^9, 3.4951641424515133`*^9, 
   3.4952001065568514`*^9, {3.4952002534270573`*^9, 3.4952002646770735`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"\[Not]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"b", " ", "n"}], ">", "0"}], ")"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, {3.495162264932214*^9, 
   3.495162277318636*^9}, {3.4951637747120676`*^9, 3.495163775320469*^9}, {
   3.4951642488437004`*^9, 3.4951642509653044`*^9}, {3.495200116396866*^9, 
   3.4952001199668703`*^9}, {3.49520041937729*^9, 3.495200429777304*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Log", "[", 
        RowBox[{"c", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], ")"}], "n"]}], "]"}]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SqrtBox["\[Pi]"], " ", 
       SqrtBox[
        RowBox[{
         RowBox[{"-", "b"}], " ", "n"}]], " ", 
       RowBox[{"(", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], ")"}], " ", 
       RowBox[{"Erf", "[", 
        FractionBox[
         SqrtBox[
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Log", "[", 
             RowBox[{"c", " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"d", "+", 
                 RowBox[{"e", " ", "x"}]}], ")"}], "n"]}], "]"}]}]}]], 
         SqrtBox[
          RowBox[{
           RowBox[{"-", "b"}], " ", "n"}]]], "]"}]}], 
      RowBox[{"b", " ", "e", " ", "n", " ", 
       SuperscriptBox["\[ExponentialE]", 
        FractionBox["a", 
         RowBox[{"b", " ", "n"}]]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], ")"}], "n"]}], ")"}], 
        RowBox[{"1", "/", "n"}]]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, 3.4951622258697453`*^9, 
   3.4951623402647467`*^9, {3.4951637900936947`*^9, 3.4951638150849385`*^9}, {
   3.495164178986778*^9, 3.4951642244608574`*^9}, 3.495200200566983*^9, {
   3.495200231817027*^9, 3.4952002386470366`*^9}, 3.4952002942571144`*^9, 
   3.4952003893672476`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c_.", "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"d_.", "+", 
             RowBox[{"e_.", "*", "x_"}]}], ")"}], "^", "n_."}]}], "]"}]}]}], 
      "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Sqrt", "[", "Pi", "]"}], "*", 
    RowBox[{"Rt", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "b"}], "*", "n"}], ",", "2"}], "]"}], "*", 
    RowBox[{"(", 
     RowBox[{"d", "+", 
      RowBox[{"e", "*", "x"}]}], ")"}], "*", 
    RowBox[{
     RowBox[{"Erf", "[", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"d", "+", 
               RowBox[{"e", "*", "x"}]}], ")"}], "^", "n"}]}], "]"}]}]}], 
        "]"}], "/", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "b"}], "*", "n"}], ",", "2"}], "]"}]}], "]"}], "/", 
     "\n", "    ", 
     RowBox[{"(", 
      RowBox[{"b", "*", "e", "*", "n", "*", 
       RowBox[{"E", "^", 
        RowBox[{"(", 
         RowBox[{"a", "/", 
          RowBox[{"(", 
           RowBox[{"b", "*", "n"}], ")"}]}], ")"}]}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"c", "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"d", "+", 
             RowBox[{"e", "*", "x"}]}], ")"}], "^", "n"}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "n"}], ")"}]}]}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "n"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NegQ", "[", 
     RowBox[{"b", "*", "n"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4951616878092003`*^9, 3.495162292263462*^9, 
   3.495163765133651*^9, 3.4951638729766407`*^9, 3.4951641424515133`*^9, 
   3.4952001065568514`*^9, {3.4952002534270573`*^9, 3.4952002646770735`*^9}, {
   3.495200332257168*^9, 3.495200346767188*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Reference: G&R 2.711.1, CRC 490", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4940010628073196`*^9, 3.4941723607787027`*^9, 3.4941724567488375`*^9, 
   3.494172696119172*^9, 3.4951614417343683`*^9, 3.495161553867365*^9, 
   3.49516358311173*^9, 3.4951639989000616`*^9, 3.495199830136465*^9, 
   3.495200499707402*^9, {3.495200628267582*^9, 3.495200628827583*^9}}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4940010628073196`*^9, 3.4941723607787027`*^9, 3.4941724567488375`*^9, 
   3.494172696119172*^9, 3.4951614417343683`*^9, 3.495161553867365*^9, 
   3.49516358311173*^9, 3.4951639989000616`*^9, 3.4951647977306643`*^9, 
   3.4952005105874176`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"p", ">", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, {3.495162264932214*^9, 
   3.495162277318636*^9}, {3.4951637747120676`*^9, 3.495163775320469*^9}, {
   3.4951642488437004`*^9, 3.4951642509653044`*^9}, {3.495200116396866*^9, 
   3.4952001199668703`*^9}, {3.49520041937729*^9, 3.495200429777304*^9}, {
   3.4952005880875263`*^9, 3.4952005951475353`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], ")"}], "n"]}], "]"}]}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Log", "[", 
             RowBox[{"c", " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"d", "+", 
                 RowBox[{"e", " ", "x"}]}], ")"}], "n"]}], "]"}]}]}], ")"}], 
         "p"]}], "e"]}]}]}]}], "-", 
  RowBox[{"b", " ", "n", " ", "p", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Log", "[", 
          RowBox[{"c", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"d", "+", 
              RowBox[{"e", " ", "x"}]}], ")"}], "n"]}], "]"}]}]}], ")"}], 
      RowBox[{"p", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, {3.495161845931078*^9, 
   3.4951618787379355`*^9}, {3.495163638398227*^9, 3.495163646853442*^9}, 
   3.49516370254554*^9, {3.495164038477331*^9, 3.4951640737177925`*^9}, 
   3.495199899876562*^9, 3.49519994111662*^9, {3.495200546157467*^9, 
   3.495200561087488*^9}, {3.4952006648976336`*^9, 3.495200687447665*^9}, {
   3.4952007863978033`*^9, 3.4952007948178153`*^9}, 3.4953076870777617`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c_.", "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"d_.", "+", 
             RowBox[{"e_.", "*", "x_"}]}], ")"}], "^", "n_."}]}], "]"}]}]}], 
      ")"}], "^", "p_"}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"e", "*", "x"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"d", "+", 
               RowBox[{"e", "*", "x"}]}], ")"}], "^", "n"}]}], "]"}]}]}], 
        ")"}], "^", "p"}], "/", "e"}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", "n", "*", "p"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Log", "[", 
             RowBox[{"c", "*", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"d", "+", 
                 RowBox[{"e", "*", "x"}]}], ")"}], "^", "n"}]}], "]"}]}]}], 
          ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "n"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4951616675135646`*^9, 3.495163619631394*^9, 
   3.495164018025695*^9, 3.495199875426528*^9, 3.495200523437435*^9, 
   3.495200639177597*^9, 3.495200753047757*^9, {3.495256737368163*^9, 
   3.495256741879421*^9}, {3.49530752664708*^9, 3.4953075299074855`*^9}, {
   3.4953077120222054`*^9, 3.4953077470442667`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Inverted integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4940010628073196`*^9, 3.4941723607787027`*^9, 3.4941724567488375`*^9, 
   3.494172696119172*^9, 3.4951614417343683`*^9, 3.495161553867365*^9, 
   3.49516358311173*^9, 3.4951639989000616`*^9, 3.4951647977306643`*^9, 
   3.4952005105874176`*^9, 3.4952010271481404`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"p", "<", 
   RowBox[{"-", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, {3.495162264932214*^9, 
   3.495162277318636*^9}, {3.4951637747120676`*^9, 3.495163775320469*^9}, {
   3.4951642488437004`*^9, 3.4951642509653044`*^9}, {3.495200116396866*^9, 
   3.4952001199668703`*^9}, {3.49520041937729*^9, 3.495200429777304*^9}, {
   3.4952005880875263`*^9, 3.4952005951475353`*^9}, {3.4952010952482357`*^9, 
   3.4952010970482388`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], ")"}], "n"]}], "]"}]}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                            ", 
      "\[IndentingNewLine]", "                              ", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Log", "[", 
             RowBox[{"c", " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"d", "+", 
                 RowBox[{"e", " ", "x"}]}], ")"}], "n"]}], "]"}]}]}], ")"}], 
         RowBox[{"p", "+", "1"}]]}], 
       RowBox[{"b", " ", "e", " ", "n", " ", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"b", " ", "n", " ", 
     RowBox[{"(", 
      RowBox[{"p", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Log", "[", 
          RowBox[{"c", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"d", "+", 
              RowBox[{"e", " ", "x"}]}], ")"}], "n"]}], "]"}]}]}], ")"}], 
      RowBox[{"p", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, {3.495161845931078*^9, 
   3.4951618787379355`*^9}, {3.495163638398227*^9, 3.495163646853442*^9}, 
   3.49516370254554*^9, {3.495164038477331*^9, 3.4951640737177925`*^9}, 
   3.495199899876562*^9, 3.49519994111662*^9, {3.495200546157467*^9, 
   3.495200561087488*^9}, {3.4952006648976336`*^9, 3.495200687447665*^9}, {
   3.4952007863978033`*^9, 3.4952007948178153`*^9}, {3.49520106256819*^9, 
   3.4952010804382153`*^9}, {3.495307781738728*^9, 3.4953078088983755`*^9}, 
   3.4953078793324995`*^9, {3.4953183125742087`*^9, 3.4953183518842635`*^9}, {
   3.4953191217853413`*^9, 3.4953191445653734`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c_.", "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"d_.", "+", 
             RowBox[{"e_.", "*", "x_"}]}], ")"}], "^", "n_."}]}], "]"}]}]}], 
      ")"}], "^", "p_"}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"e", "*", "x"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"d", "+", 
               RowBox[{"e", "*", "x"}]}], ")"}], "^", "n"}]}], "]"}]}]}], 
        ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "e", "*", "n", "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", "n", "*", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Log", "[", 
             RowBox[{"c", "*", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"d", "+", 
                 RowBox[{"e", "*", "x"}]}], ")"}], "^", "n"}]}], "]"}]}]}], 
          ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "n"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4951616675135646`*^9, 3.495163619631394*^9, 
   3.495164018025695*^9, 3.495199875426528*^9, 3.495200523437435*^9, 
   3.495200639177597*^9, 3.495200753047757*^9, 3.4952010407881594`*^9, {
   3.4953079012349377`*^9, 3.4953079472082186`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Inverted integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4940010628073196`*^9, 3.4941723607787027`*^9, 3.4941724567488375`*^9, 
   3.494172696119172*^9, 3.4951614417343683`*^9, 3.495161553867365*^9, 
   3.49516358311173*^9, 3.4951639989000616`*^9, 3.4951647977306643`*^9, 
   3.4952005105874176`*^9, 3.4952010271481404`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"2", "p"}], "\[NotElement]", "\[DoubleStruckCapitalZ]"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, {3.495162264932214*^9, 
   3.495162277318636*^9}, {3.4951637747120676`*^9, 3.495163775320469*^9}, {
   3.4951642488437004`*^9, 3.4951642509653044`*^9}, {3.495200116396866*^9, 
   3.4952001199668703`*^9}, {3.49520041937729*^9, 3.495200429777304*^9}, {
   3.4952005880875263`*^9, 3.4952005951475353`*^9}, {3.4952010952482357`*^9, 
   3.4952010970482388`*^9}, {3.495259125616763*^9, 3.495259125616763*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Log", "[", 
        RowBox[{"c", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], ")"}], "n"]}], "]"}]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], ")"}], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{
         RowBox[{"p", "+", "1"}], ",", 
         RowBox[{"-", 
          FractionBox[
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             RowBox[{"Log", "[", 
              RowBox[{"c", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"d", "+", 
                  RowBox[{"e", " ", "x"}]}], ")"}], "n"]}], "]"}]}]}], 
           RowBox[{"b", " ", "n"}]]}]}], "]"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Log", "[", 
            RowBox[{"c", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"d", "+", 
                RowBox[{"e", " ", "x"}]}], ")"}], "n"]}], "]"}]}]}], ")"}], 
        "p"]}], 
      RowBox[{"e", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", 
          FractionBox[
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             RowBox[{"Log", "[", 
              RowBox[{"c", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"d", "+", 
                  RowBox[{"e", " ", "x"}]}], ")"}], "n"]}], "]"}]}]}], 
           RowBox[{"b", " ", "n"}]]}], ")"}], "p"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        FractionBox["a", 
         RowBox[{"b", " ", "n"}]]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], ")"}], "n"]}], ")"}], 
        RowBox[{"1", "/", "n"}]]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, {3.495161845931078*^9, 
   3.4951618787379355`*^9}, {3.495163638398227*^9, 3.495163646853442*^9}, 
   3.49516370254554*^9, {3.495164038477331*^9, 3.4951640737177925`*^9}, 
   3.495199899876562*^9, 3.49519994111662*^9, {3.495200546157467*^9, 
   3.495200561087488*^9}, {3.4952006648976336`*^9, 3.495200687447665*^9}, {
   3.4952007863978033`*^9, 3.4952007948178153`*^9}, {3.49520106256819*^9, 
   3.4952010804382153`*^9}, {3.4952013676786175`*^9, 3.4952013763386297`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c_.", "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"d_.", "+", 
             RowBox[{"e_.", "*", "x_"}]}], ")"}], "^", "n_."}]}], "]"}]}]}], 
      ")"}], "^", "p_"}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"d", "+", 
      RowBox[{"e", "*", "x"}]}], ")"}], "*", 
    RowBox[{"Gamma", "[", 
     RowBox[{
      RowBox[{"p", "+", "1"}], ",", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Log", "[", 
            RowBox[{"c", "*", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"d", "+", 
                RowBox[{"e", "*", "x"}]}], ")"}], "^", "n"}]}], "]"}]}]}], 
         ")"}]}], "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", "n"}], ")"}]}]}], "]"}], "*", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c", "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], ")"}], "^", "n"}]}], "]"}]}]}], 
       ")"}], "^", "p"}], "/", "\n", "    ", 
     RowBox[{"(", 
      RowBox[{"e", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"Log", "[", 
               RowBox[{"c", "*", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"d", "+", 
                   RowBox[{"e", "*", "x"}]}], ")"}], "^", "n"}]}], "]"}]}]}], 
            ")"}]}], "/", 
          RowBox[{"(", 
           RowBox[{"b", "*", "n"}], ")"}]}], ")"}], "^", "p"}], "*", 
       RowBox[{"E", "^", 
        RowBox[{"(", 
         RowBox[{"a", "/", 
          RowBox[{"(", 
           RowBox[{"b", "*", "n"}], ")"}]}], ")"}]}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"c", "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"d", "+", 
             RowBox[{"e", "*", "x"}]}], ")"}], "^", "n"}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "n"}], ")"}]}]}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "n", ",", "p"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", 
      RowBox[{"2", "*", "p"}], "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4951616675135646`*^9, 3.495163619631394*^9, 
   3.495164018025695*^9, 3.495199875426528*^9, 3.495200523437435*^9, 
   3.495200639177597*^9, 3.495200753047757*^9, 3.4952010407881594`*^9, 
   3.4952013363585734`*^9, {3.4952570835699644`*^9, 3.495257087673199*^9}, {
   3.4952590667663965`*^9, 3.495259071698679*^9}, {3.495259155129451*^9, 
   3.4952591595397034`*^9}, {3.4952592284316435`*^9, 3.495259233363926*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"c", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}], "p"]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, {
   3.494172650949109*^9, 3.494172665319129*^9}, 3.4951614288955455`*^9, 
   3.4951617140016465`*^9, {3.495162187524878*^9, 3.495162197867696*^9}, 
   3.495162421681289*^9, 3.495163536311648*^9, 3.4951639784796257`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.728.2", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4940010628073196`*^9, 3.4941723607787027`*^9, 3.4941724567488375`*^9, 
   3.494172696119172*^9, 3.4951614417343683`*^9, 3.495161553867365*^9, 
   3.49516358311173*^9, 3.4951639989000616`*^9}],

Cell["Derivation: Primitive rule", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4940010628073196`*^9, 3.4941723607787027`*^9, 3.4941724567488375`*^9, 
   3.494172696119172*^9, 3.4951614417343683`*^9, 3.495161553867365*^9, 
   3.49516358311173*^9, 3.4951639989000616`*^9, 3.4951647977306643`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      RowBox[{"-", "x"}]}], "]"}]}], "=", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", "x"}], "]"}], "x"]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4940010628073196`*^9, 3.4941723607787027`*^9, 3.4941724567488375`*^9, 
   3.494172696119172*^9, 3.4951614417343683`*^9, 3.495161553867365*^9, 
   3.49516358311173*^9, 3.4951639989000616`*^9, {3.4951648090562844`*^9, 
   3.495164816591098*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, 3.4951636244830027`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}], "x"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"PolyLog", "[", 
        RowBox[{"2", ",", 
         RowBox[{
          RowBox[{"-", "b"}], " ", 
          SuperscriptBox["x", "n"]}]}], "]"}], "n"]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, {3.495161845931078*^9, 
   3.4951618787379355`*^9}, {3.495163638398227*^9, 3.495163646853442*^9}, 
   3.49516370254554*^9, {3.495164038477331*^9, 3.4951640737177925`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], "]"}], "/", "x_"}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"PolyLog", "[", 
      RowBox[{"2", ",", 
       RowBox[{
        RowBox[{"-", "b"}], "*", 
        RowBox[{"x", "^", "n"}]}]}], "]"}]}], "/", "n"}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"b", ",", "n"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4951616675135646`*^9, 3.495163619631394*^9, 
   3.495164018025695*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9, 3.4951641222026777`*^9}],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{"a", ">", "0"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"a", " ", "z"}], "]"}], "=", 
   RowBox[{
    RowBox[{"Log", "[", "a", "]"}], "+", 
    RowBox[{"Log", "[", "z", "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, 3.4951641222026777`*^9, {3.49516486329758*^9, 
   3.495164878882007*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", " ", "c"}], ">", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, {3.495162264932214*^9, 
   3.495162277318636*^9}, {3.4951637747120676`*^9, 3.495163775320469*^9}, {
   3.4951642488437004`*^9, 3.4951642509653044`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"Log", "[", 
      RowBox[{"c", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "n"]}]}], ")"}]}], "]"}], "x"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"Log", "[", 
       RowBox[{"a", " ", "c"}], "]"}]}]}], " ", 
    RowBox[{"Log", "[", "x", "]"}]}]}], "+", 
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       FractionBox[
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}], "a"]}], "]"}], "x"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, 3.4951622258697453`*^9, 
   3.4951623402647467`*^9, {3.4951637900936947`*^9, 3.4951638150849385`*^9}, {
   3.495164178986778*^9, 3.4951642244608574`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"c_.", "*", 
       RowBox[{"(", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"x_", "^", "n_."}]}]}], ")"}]}], "]"}], "/", "x_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"a", "*", "c"}], "]"}], "*", 
     RowBox[{"Log", "[", "x", "]"}]}], " ", "+", "\n", "  ", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Log", "[", 
        RowBox[{"1", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"x", "^", "n"}], "/", "a"}]}]}], "]"}], "/", "x"}], ",", 
      "x"}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", 
     RowBox[{"a", "*", "c"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4951616878092003`*^9, 3.495162292263462*^9, 
   3.495163765133651*^9, 3.4951638729766407`*^9, 3.4951641424515133`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, {3.495162264932214*^9, 
   3.495162277318636*^9}, {3.4951637747120676`*^9, 3.495163775320469*^9}, 
   3.4951642867205667`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"Log", "[", 
      RowBox[{"c", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", "n"]}]}], ")"}], "p"]}], "]"}], "x"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", " ", 
              SuperscriptBox["x", "n"]}]}], ")"}], "p"]}], "]"}], " ", 
        RowBox[{"Log", "[", 
         RowBox[{"-", 
          FractionBox[
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}], "a"]}], "]"}]}], "n"]}]}]}]}], "-", 
  RowBox[{"b", " ", "p", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"n", "-", "1"}]], " ", 
       RowBox[{"Log", "[", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"b", " ", 
           SuperscriptBox["x", "n"]}], "a"]}], "]"}]}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, 3.4951622258697453`*^9, 
   3.4951623402647467`*^9, {3.4951637900936947`*^9, 3.4951638150849385`*^9}, 
   3.4951639089035034`*^9, {3.495164349058276*^9, 3.4951643831911364`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"c_.", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a_", "+", 
          RowBox[{"b_.", "*", 
           RowBox[{"x_", "^", "n_."}]}]}], ")"}], "^", "p_."}]}], "]"}], "/", 
     "x_"}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"c", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"x", "^", "n"}]}]}], ")"}], "^", "p"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{
        RowBox[{"-", "b"}], "*", 
        RowBox[{
         RowBox[{"x", "^", "n"}], "/", "a"}]}], "]"}], "/", "n"}]}], " ", "-",
     "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", "p"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{
            RowBox[{"-", "b"}], "*", 
            RowBox[{
             RowBox[{"x", "^", "n"}], "/", "a"}]}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "n", ",", "p"}], "}"}], ",", 
     "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4951616878092003`*^9, 3.495162292263462*^9, 
   3.495163765133651*^9, {3.495163853055405*^9, 3.4951638701998353`*^9}, 
   3.4951642938185797`*^9, 3.49516433400425*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Reference: G&R 2.728.1, CRC 501, A&S 4.1.50'", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4940010628073196`*^9, 3.4941723607787027`*^9, 3.4941724567488375`*^9, 
   3.494172696119172*^9, 3.4951614417343683`*^9, 3.495161553867365*^9, 
   3.49516358311173*^9, 3.4951639989000616`*^9, 3.495164440568037*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, {3.495162264932214*^9, 
   3.495162277318636*^9}, {3.4951637747120676`*^9, 3.495163775320469*^9}, {
   3.4951642488437004`*^9, 3.4951642509653044`*^9}, {3.4951644844509144`*^9, 
   3.495164494481732*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"c", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}], ")"}], "p"]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"b", " ", 
             SuperscriptBox["x", "n"]}], ")"}], "p"]}], "]"}]}], 
       RowBox[{"m", "+", "1"}]]}]}]}]}], "-", 
  FractionBox[
   RowBox[{"n", " ", "p", " ", 
    SuperscriptBox["x", 
     RowBox[{"m", "+", "1"}]]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"m", "+", "1"}], ")"}], "2"]]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, 3.4951622258697453`*^9, 
   3.4951623402647467`*^9, {3.4951637900936947`*^9, 3.4951638150849385`*^9}, 
   3.4951639089035034`*^9, {3.495164349058276*^9, 3.4951643831911364`*^9}, {
   3.4951645253853865`*^9, 3.495164530689396*^9}, 3.495164568098261*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"Log", "[", 
      RowBox[{"c_.", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], ")"}], "^", "p_."}]}], "]"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"c", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"b", "*", 
           RowBox[{"x", "^", "n"}]}], ")"}], "^", "p"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "-", " ", 
    RowBox[{"n", "*", "p", "*", 
     RowBox[{
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}], "/", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "^", "2"}]}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c", ",", "m", ",", "n", ",", "p"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4951616878092003`*^9, 3.495162292263462*^9, 
   3.495163765133651*^9, {3.495163853055405*^9, 3.4951638701998353`*^9}, 
   3.4951642938185797`*^9, 3.49516433400425*^9, 3.4951644553100634`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Reference: G&R 2.728.1, CRC 501, A&S 4.1.50'", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4940010628073196`*^9, 3.4941723607787027`*^9, 3.4941724567488375`*^9, 
   3.494172696119172*^9, 3.4951614417343683`*^9, 3.495161553867365*^9, 
   3.49516358311173*^9, 3.4951639989000616`*^9, 3.495164440568037*^9, 
   3.4951646048051257`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"m", "-", "n", "+", "1"}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, {3.495162264932214*^9, 
   3.495162277318636*^9}, {3.4951637747120676`*^9, 3.495163775320469*^9}, {
   3.4951642488437004`*^9, 3.4951642509653044`*^9}, {3.4951644844509144`*^9, 
   3.495164494481732*^9}, {3.4951646256467624`*^9, 3.4951646518548083`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"c", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "n"]}]}], ")"}], "p"]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", " ", 
              SuperscriptBox["x", "n"]}]}], ")"}], "p"]}], "]"}]}], 
       RowBox[{"m", "+", "1"}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"b", " ", "n", " ", "p"}], 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox["x", 
       RowBox[{"m", "+", "n"}]], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, 3.4951622258697453`*^9, 
   3.4951623402647467`*^9, {3.4951637900936947`*^9, 3.4951638150849385`*^9}, 
   3.4951639089035034`*^9, {3.495164349058276*^9, 3.4951643831911364`*^9}, {
   3.4951645253853865`*^9, 3.495164530689396*^9}, 3.495164568098261*^9, {
   3.495164667642036*^9, 3.495164668484438*^9}, 3.4951647039433*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"Log", "[", 
      RowBox[{"c_.", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a_", "+", 
          RowBox[{"b_.", "*", 
           RowBox[{"x_", "^", "n_."}]}]}], ")"}], "^", "p_."}]}], "]"}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"c", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "^", "n"}]}]}], ")"}], "^", "p"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", "n", "*", 
       RowBox[{"p", "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "n"}], ")"}]}], "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "^", "n"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "m", ",", "n", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "-", "n", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4951616878092003`*^9, 3.495162292263462*^9, 
   3.495163765133651*^9, {3.495163853055405*^9, 3.4951638701998353`*^9}, 
   3.4951642938185797`*^9, 3.49516433400425*^9, 3.4951644553100634`*^9, 
   3.4951646197499523`*^9, 3.4951646811204596`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}]}], ")"}], "p"]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, {
   3.494172650949109*^9, 3.494172665319129*^9}, 3.4951614288955455`*^9, 
   3.4951617140016465`*^9, {3.495162187524878*^9, 3.495162197867696*^9}, 
   3.495162421681289*^9, 3.495163536311648*^9, 3.4951639784796257`*^9, 
   3.495199809276436*^9, 3.495201743419143*^9, {3.4953116253991227`*^9, 
   3.495311630859131*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, {3.495162264932214*^9, 
   3.495162277318636*^9}, {3.4951637747120676`*^9, 3.495163775320469*^9}, {
   3.4951642488437004`*^9, 3.4951642509653044`*^9}, {3.495200116396866*^9, 
   3.4952001199668703`*^9}, {3.495201853289297*^9, 3.4952018648993134`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "m"], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Log", "[", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "n"]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"m", "+", "1"}]], " ", 
       RowBox[{"ExpIntegralEi", "[", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             RowBox[{"Log", "[", 
              RowBox[{"c", " ", 
               SuperscriptBox["x", "n"]}], "]"}]}]}], ")"}]}], 
         RowBox[{"b", " ", "n"}]], "]"}]}], 
      RowBox[{"b", " ", "n", " ", 
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"a", " ", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], 
         RowBox[{"b", " ", "n"}]]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "n"]}], ")"}], 
        FractionBox[
         RowBox[{"m", "+", "1"}], "n"]]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, {3.495161845931078*^9, 
   3.4951618787379355`*^9}, {3.495163638398227*^9, 3.495163646853442*^9}, 
   3.49516370254554*^9, {3.495164038477331*^9, 3.4951640737177925`*^9}, 
   3.495199899876562*^9, 3.49519994111662*^9, {3.4952018813793364`*^9, 
   3.4952018971393585`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "/", 
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}], "*", 
    RowBox[{
     RowBox[{"ExpIntegralEi", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Log", "[", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", "n"}]}], "]"}]}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"b", "*", "n"}], ")"}]}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"b", "*", "n", "*", 
       RowBox[{"E", "^", 
        RowBox[{"(", 
         RowBox[{"a", "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"m", "+", "1"}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{"b", "*", "n"}], ")"}]}]}], ")"}]}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "n"}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}], "/", "n"}], ")"}]}]}], ")"}]}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "m", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4951616675135646`*^9, 3.495163619631394*^9, 
   3.495164018025695*^9, 3.495199875426528*^9, 3.4952017849792013`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    FractionBox[
     RowBox[{"m", "+", "1"}], 
     RowBox[{"b", " ", "n"}]], ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, {3.495162264932214*^9, 
   3.495162277318636*^9}, {3.4951637747120676`*^9, 3.495163775320469*^9}, {
   3.4951642488437004`*^9, 3.4951642509653044`*^9}, {3.495200116396866*^9, 
   3.4952001199668703`*^9}, {3.495201853289297*^9, 3.4952018648993134`*^9}, {
   3.495202034479551*^9, 3.495202075309608*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "m"], 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Log", "[", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SqrtBox["\[Pi]"], " ", 
       SuperscriptBox["x", 
        RowBox[{"m", "+", "1"}]], " ", 
       RowBox[{"Erfi", "[", 
        RowBox[{
         SqrtBox[
          FractionBox[
           RowBox[{"m", "+", "1"}], 
           RowBox[{"b", " ", "n"}]]], " ", 
         SqrtBox[
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Log", "[", 
             RowBox[{"c", " ", 
              SuperscriptBox["x", "n"]}], "]"}]}]}]]}], "]"}]}], 
      RowBox[{"b", " ", "n", " ", 
       SqrtBox[
        FractionBox[
         RowBox[{"m", "+", "1"}], 
         RowBox[{"b", " ", "n"}]]], " ", 
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"a", " ", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], 
         RowBox[{"b", " ", "n"}]]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "n"]}], ")"}], 
        FractionBox[
         RowBox[{"m", "+", "1"}], "n"]]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, {3.495161845931078*^9, 
   3.4951618787379355`*^9}, {3.495163638398227*^9, 3.495163646853442*^9}, 
   3.49516370254554*^9, {3.495164038477331*^9, 3.4951640737177925`*^9}, 
   3.495199899876562*^9, 3.49519994111662*^9, {3.4952000649467936`*^9, 
   3.495200075966809*^9}, {3.4952019860094833`*^9, 3.4952019978094997`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Sqrt", "[", "Pi", "]"}], "*", 
    RowBox[{"x", "^", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}], "*", 
    RowBox[{
     RowBox[{"Erfi", "[", 
      RowBox[{
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"b", "*", "n"}], ")"}]}], ",", "2"}], "]"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}]}], "]"}], "/", "\n", 
     "    ", 
     RowBox[{"(", 
      RowBox[{"b", "*", "n", "*", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"b", "*", "n"}], ")"}]}], ",", "2"}], "]"}], "*", 
       RowBox[{"E", "^", 
        RowBox[{"(", 
         RowBox[{"a", "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"m", "+", "1"}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{"b", "*", "n"}], ")"}]}]}], ")"}]}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "n"}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}], "/", "n"}], ")"}]}]}], ")"}]}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "m", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"PosQ", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n"}], ")"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4951616675135646`*^9, 3.495163619631394*^9, 
   3.495164018025695*^9, 3.495199875426528*^9, 3.4952000136967216`*^9, 
   3.495201805939231*^9, 3.4952019420094213`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"m", "+", "1"}], 
       RowBox[{"b", " ", "n"}]], ">", "0"}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, {3.495162264932214*^9, 
   3.495162277318636*^9}, {3.4951637747120676`*^9, 3.495163775320469*^9}, {
   3.4951642488437004`*^9, 3.4951642509653044`*^9}, {3.495200116396866*^9, 
   3.4952001199668703`*^9}, {3.495201853289297*^9, 3.4952018648993134`*^9}, {
   3.495202034479551*^9, 3.495202075309608*^9}, {3.4952022052197895`*^9, 
   3.495202209799796*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "m"], 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Log", "[", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SqrtBox["\[Pi]"], " ", 
       SuperscriptBox["x", 
        RowBox[{"m", "+", "1"}]], " ", 
       RowBox[{"Erf", "[", 
        RowBox[{
         SqrtBox[
          RowBox[{"-", 
           FractionBox[
            RowBox[{"m", "+", "1"}], 
            RowBox[{"b", " ", "n"}]]}]], " ", 
         SqrtBox[
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Log", "[", 
             RowBox[{"c", " ", 
              SuperscriptBox["x", "n"]}], "]"}]}]}]]}], "]"}]}], 
      RowBox[{"b", " ", "n", " ", 
       SqrtBox[
        RowBox[{"-", 
         FractionBox[
          RowBox[{"m", "+", "1"}], 
          RowBox[{"b", " ", "n"}]]}]], " ", 
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"a", " ", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], 
         RowBox[{"b", " ", "n"}]]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "n"]}], ")"}], 
        FractionBox[
         RowBox[{"m", "+", "1"}], "n"]]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, {3.495161845931078*^9, 
   3.4951618787379355`*^9}, {3.495163638398227*^9, 3.495163646853442*^9}, 
   3.49516370254554*^9, {3.495164038477331*^9, 3.4951640737177925`*^9}, 
   3.495199899876562*^9, 3.49519994111662*^9, {3.4952000649467936`*^9, 
   3.495200075966809*^9}, {3.4952019860094833`*^9, 3.4952019978094997`*^9}, 
   3.495202186849764*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Sqrt", "[", "Pi", "]"}], "*", 
    RowBox[{"x", "^", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}], "*", 
    RowBox[{
     RowBox[{"Erf", "[", 
      RowBox[{
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"m", "+", "1"}], ")"}]}], "/", 
          RowBox[{"(", 
           RowBox[{"b", "*", "n"}], ")"}]}], ",", "2"}], "]"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}]}], "]"}], "/", "\n", 
     "    ", 
     RowBox[{"(", 
      RowBox[{"b", "*", "n", "*", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"m", "+", "1"}], ")"}]}], "/", 
          RowBox[{"(", 
           RowBox[{"b", "*", "n"}], ")"}]}], ",", "2"}], "]"}], "*", 
       RowBox[{"E", "^", 
        RowBox[{"(", 
         RowBox[{"a", "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"m", "+", "1"}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{"b", "*", "n"}], ")"}]}]}], ")"}]}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "n"}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}], "/", "n"}], ")"}]}]}], ")"}]}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "m", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"NegQ", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n"}], ")"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4951616675135646`*^9, 3.495163619631394*^9, 
   3.495164018025695*^9, 3.495199875426528*^9, 3.4952000136967216`*^9, 
   3.495201805939231*^9, 3.4952019420094213`*^9, 3.4952021430497026`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Reference: G&R 2.721.1, CRC 496, A&S 4.1.51", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4940010628073196`*^9, 3.4941723607787027`*^9, 3.4941724567488375`*^9, 
   3.494172696119172*^9, 3.4951614417343683`*^9, 3.495161553867365*^9, 
   3.49516358311173*^9, 3.4951639989000616`*^9, 3.495199830136465*^9, 
   3.495200499707402*^9, {3.495200628267582*^9, 3.495200628827583*^9}, 
   3.4952022999899225`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4940010628073196`*^9, 3.4941723607787027`*^9, 3.4941724567488375`*^9, 
   3.494172696119172*^9, 3.4951614417343683`*^9, 3.495161553867365*^9, 
   3.49516358311173*^9, 3.4951639989000616`*^9, 3.4951647977306643`*^9, 
   3.4952005105874176`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"p", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, {3.495162264932214*^9, 
   3.495162277318636*^9}, {3.4951637747120676`*^9, 3.495163775320469*^9}, {
   3.4951642488437004`*^9, 3.4951642509653044`*^9}, {3.495200116396866*^9, 
   3.4952001199668703`*^9}, {3.495201853289297*^9, 3.4952018648993134`*^9}, {
   3.495202034479551*^9, 3.495202075309608*^9}, {3.4952022052197895`*^9, 
   3.495202209799796*^9}, {3.49520236235001*^9, 3.495202364530013*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Log", "[", 
             RowBox[{"c", " ", 
              SuperscriptBox["x", "n"]}], "]"}]}]}], ")"}], "p"]}], 
       RowBox[{"m", "+", "1"}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"b", " ", "n", " ", "p"}], 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Log", "[", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", "n"]}], "]"}]}]}], ")"}], 
      RowBox[{"p", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, {3.495161845931078*^9, 
   3.4951618787379355`*^9}, {3.495163638398227*^9, 3.495163646853442*^9}, 
   3.49516370254554*^9, {3.495164038477331*^9, 3.4951640737177925`*^9}, 
   3.495199899876562*^9, 3.49519994111662*^9, {3.4952000649467936`*^9, 
   3.495200075966809*^9}, {3.4952019860094833`*^9, 3.4952019978094997`*^9}, 
   3.495202186849764*^9, {3.495202396160057*^9, 3.495202406320071*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c_.", "*", 
           RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], ")"}], "^", "p_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], ")"}], "^", "p"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", "n", "*", 
       RowBox[{"p", "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"Log", "[", 
              RowBox[{"c", "*", 
               RowBox[{"x", "^", "n"}]}], "]"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "m", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4951616675135646`*^9, 3.495163619631394*^9, 
   3.495164018025695*^9, 3.495199875426528*^9, 3.4952000136967216`*^9, 
   3.495201805939231*^9, 3.4952019420094213`*^9, 3.4952021430497026`*^9, {
   3.4952023111099377`*^9, 3.4952023425599823`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Reference: G&R 2.724.1, CRC 495", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4940010628073196`*^9, 3.4941723607787027`*^9, 3.4941724567488375`*^9, 
   3.494172696119172*^9, 3.4951614417343683`*^9, 3.495161553867365*^9, 
   3.49516358311173*^9, 3.4951639989000616`*^9, 3.495199830136465*^9, 
   3.495200499707402*^9, {3.495200628267582*^9, 3.495200628827583*^9}, 
   3.4952022999899225`*^9, 3.4952024370101147`*^9}],

Cell["Derivation: Inverted integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4940010628073196`*^9, 3.4941723607787027`*^9, 3.4941724567488375`*^9, 
   3.494172696119172*^9, 3.4951614417343683`*^9, 3.495161553867365*^9, 
   3.49516358311173*^9, 3.4951639989000616`*^9, 3.4951647977306643`*^9, 
   3.4952005105874176`*^9, 3.495202446820128*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"p", "<", 
    RowBox[{"-", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, {3.495162264932214*^9, 
   3.495162277318636*^9}, {3.4951637747120676`*^9, 3.495163775320469*^9}, {
   3.4951642488437004`*^9, 3.4951642509653044`*^9}, {3.495200116396866*^9, 
   3.4952001199668703`*^9}, {3.495201853289297*^9, 3.4952018648993134`*^9}, {
   3.495202034479551*^9, 3.495202075309608*^9}, {3.4952022052197895`*^9, 
   3.495202209799796*^9}, {3.49520236235001*^9, 3.495202364530013*^9}, {
   3.4952024627101507`*^9, 3.495202466110155*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Log", "[", 
             RowBox[{"c", " ", 
              SuperscriptBox["x", "n"]}], "]"}]}]}], ")"}], "p"]}], 
       RowBox[{"m", "+", "1"}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"b", " ", "n", " ", "p"}], 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Log", "[", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", "n"]}], "]"}]}]}], ")"}], 
      RowBox[{"p", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, {3.495161845931078*^9, 
   3.4951618787379355`*^9}, {3.495163638398227*^9, 3.495163646853442*^9}, 
   3.49516370254554*^9, {3.495164038477331*^9, 3.4951640737177925`*^9}, 
   3.495199899876562*^9, 3.49519994111662*^9, {3.4952000649467936`*^9, 
   3.495200075966809*^9}, {3.4952019860094833`*^9, 3.4952019978094997`*^9}, 
   3.495202186849764*^9, {3.495202396160057*^9, 3.495202406320071*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c_.", "*", 
           RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], ")"}], "^", "p_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", "n", "*", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"Log", "[", 
              RowBox[{"c", "*", 
               RowBox[{"x", "^", "n"}]}], "]"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "m", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4951616675135646`*^9, 3.495163619631394*^9, 
   3.495164018025695*^9, 3.495199875426528*^9, 3.4952000136967216`*^9, 
   3.495201805939231*^9, 3.4952019420094213`*^9, 3.4952021430497026`*^9, {
   3.4952023111099377`*^9, 3.4952023425599823`*^9}, {3.4952024566001415`*^9, 
   3.495202471920163*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, {3.495162264932214*^9, 
   3.495162277318636*^9}, {3.4951637747120676`*^9, 3.495163775320469*^9}, {
   3.4951642488437004`*^9, 3.4951642509653044`*^9}, {3.495200116396866*^9, 
   3.4952001199668703`*^9}, {3.495201853289297*^9, 3.4952018648993134`*^9}, {
   3.495202034479551*^9, 3.495202075309608*^9}, {3.4952022052197895`*^9, 
   3.495202209799796*^9}, {3.49520236235001*^9, 3.495202364530013*^9}, {
   3.4952024627101507`*^9, 3.495202466110155*^9}, {3.4952025192402296`*^9, 
   3.495202520900232*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Log", "[", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"m", "+", "1"}]], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{
         RowBox[{"p", "+", "1"}], ",", 
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"m", "+", "1"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", " ", 
               RowBox[{"Log", "[", 
                RowBox[{"c", " ", 
                 SuperscriptBox["x", "n"]}], "]"}]}]}], ")"}]}], 
           RowBox[{"b", " ", "n"}]]}]}], "]"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Log", "[", 
            RowBox[{"c", " ", 
             SuperscriptBox["x", "n"]}], "]"}]}]}], ")"}], "p"]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], " ", 
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"a", " ", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], 
         RowBox[{"b", " ", "n"}]]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "n"]}], ")"}], 
        FractionBox[
         RowBox[{"m", "+", "1"}], "n"]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"m", "+", "1"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", " ", 
               RowBox[{"Log", "[", 
                RowBox[{"c", " ", 
                 SuperscriptBox["x", "n"]}], "]"}]}]}], ")"}]}], 
           RowBox[{"b", " ", "n"}]]}], ")"}], "p"]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, {3.495161845931078*^9, 
   3.4951618787379355`*^9}, {3.495163638398227*^9, 3.495163646853442*^9}, 
   3.49516370254554*^9, {3.495164038477331*^9, 3.4951640737177925`*^9}, 
   3.495199899876562*^9, 3.49519994111662*^9, {3.4952000649467936`*^9, 
   3.495200075966809*^9}, {3.4952019860094833`*^9, 3.4952019978094997`*^9}, 
   3.495202186849764*^9, {3.495202396160057*^9, 3.495202406320071*^9}, {
   3.495202538720257*^9, 3.4952025534702773`*^9}, 3.495202978900873*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c_.", "*", 
           RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], ")"}], "^", "p_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}], "*", 
    RowBox[{"Gamma", "[", 
     RowBox[{
      RowBox[{"p", "+", "1"}], ",", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Log", "[", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", "n"}]}], "]"}]}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"b", "*", "n"}], ")"}]}]}]}], "]"}], "*", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}]}]}], ")"}], "^", "p"}], "/", "\n",
      "    ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "*", 
       RowBox[{"E", "^", 
        RowBox[{"(", 
         RowBox[{"a", "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"m", "+", "1"}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{"b", "*", "n"}], ")"}]}]}], ")"}]}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "n"}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}], "/", "n"}], ")"}]}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"m", "+", "1"}], ")"}]}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"Log", "[", 
               RowBox[{"c", "*", 
                RowBox[{"x", "^", "n"}]}], "]"}]}]}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{"b", "*", "n"}], ")"}]}]}], ")"}], "^", "p"}]}], 
      ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "m", ",", "n", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4951616675135646`*^9, 3.495163619631394*^9, 
   3.495164018025695*^9, 3.495199875426528*^9, 3.4952000136967216`*^9, 
   3.495201805939231*^9, 3.4952019420094213`*^9, 3.4952021430497026`*^9, {
   3.4952023111099377`*^9, 3.4952023425599823`*^9}, {3.4952024566001415`*^9, 
   3.495202471920163*^9}, 3.495202513800222*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Note: Need a rule for arbitrarily deep nesting of powers!", \
"Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, {3.495162264932214*^9, 
   3.495162277318636*^9}, {3.4951637747120676`*^9, 3.495163775320469*^9}, {
   3.4951642488437004`*^9, 3.4951642509653044`*^9}, {3.495200116396866*^9, 
   3.4952001199668703`*^9}, {3.495201853289297*^9, 3.4952018648993134`*^9}, {
   3.495202034479551*^9, 3.495202075309608*^9}, {3.4952022052197895`*^9, 
   3.495202209799796*^9}, {3.49520236235001*^9, 3.495202364530013*^9}, {
   3.4952024627101507`*^9, 3.495202466110155*^9}, {3.4952025192402296`*^9, 
   3.495202520900232*^9}, {3.4952025955103364`*^9, 3.4952026033603473`*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, {3.495162264932214*^9, 
   3.495162277318636*^9}, {3.4951637747120676`*^9, 3.495163775320469*^9}, {
   3.4951642488437004`*^9, 3.4951642509653044`*^9}, {3.495200116396866*^9, 
   3.4952001199668703`*^9}, {3.495201853289297*^9, 3.4952018648993134`*^9}, {
   3.495202034479551*^9, 3.495202075309608*^9}, {3.4952022052197895`*^9, 
   3.495202209799796*^9}, {3.49520236235001*^9, 3.495202364530013*^9}, {
   3.4952024627101507`*^9, 3.495202466110155*^9}, {3.4952025192402296`*^9, 
   3.495202520900232*^9}, 3.495202784710601*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Log", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}], ")"}], "p"]}], "]"}], "q"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"\[Integral]", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"Log", "[", 
           SuperscriptBox["x", 
            RowBox[{"n", " ", "p"}]], "]"}], "q"], 
         RowBox[{"\[DifferentialD]", "x"}]}]}], ",", 
       SuperscriptBox["x", 
        RowBox[{"n", " ", "p"}]], ",", 
       RowBox[{"a", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", "n"]}], ")"}], "p"]}]}], 
      "]"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, {3.495161845931078*^9, 
   3.4951618787379355`*^9}, {3.495163638398227*^9, 3.495163646853442*^9}, 
   3.49516370254554*^9, {3.495164038477331*^9, 3.4951640737177925`*^9}, 
   3.495199899876562*^9, 3.49519994111662*^9, {3.4952000649467936`*^9, 
   3.495200075966809*^9}, {3.4952019860094833`*^9, 3.4952019978094997`*^9}, 
   3.495202186849764*^9, {3.495202396160057*^9, 3.495202406320071*^9}, {
   3.495202538720257*^9, 3.4952025534702773`*^9}, 3.4952026366403937`*^9, {
   3.495202693010473*^9, 3.4952027377005353`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"a_.", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], ")"}], "^", "p_"}]}], "]"}], "^", 
     "q_."}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Log", "[", 
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"n", "*", "p"}], ")"}]}], "]"}], "^", "q"}], ",", "x"}], 
      "]"}], ",", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"n", "*", "p"}], ")"}]}], ",", 
     RowBox[{"a", "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{"x", "^", "n"}]}], ")"}], "^", "p"}]}]}], "]"}], " ", "/;", 
   "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "n", ",", "p", ",", "q"}], "}"}], ",", 
     "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4951616675135646`*^9, 3.495163619631394*^9, 
   3.495164018025695*^9, 3.495199875426528*^9, 3.4952000136967216`*^9, 
   3.495201805939231*^9, 3.4952019420094213`*^9, 3.4952021430497026`*^9, {
   3.4952023111099377`*^9, 3.4952023425599823`*^9}, {3.4952024566001415`*^9, 
   3.495202471920163*^9}, 3.495202513800222*^9, 3.495202581400316*^9, 
   3.495202613140361*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, {3.495162264932214*^9, 
   3.495162277318636*^9}, {3.4951637747120676`*^9, 3.495163775320469*^9}, {
   3.4951642488437004`*^9, 3.4951642509653044`*^9}, {3.495200116396866*^9, 
   3.4952001199668703`*^9}, {3.495201853289297*^9, 3.4952018648993134`*^9}, {
   3.495202034479551*^9, 3.495202075309608*^9}, {3.4952022052197895`*^9, 
   3.495202209799796*^9}, {3.49520236235001*^9, 3.495202364530013*^9}, {
   3.4952024627101507`*^9, 3.495202466110155*^9}, {3.4952025192402296`*^9, 
   3.495202520900232*^9}, 3.495202789990608*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Log", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"c", " ", 
            SuperscriptBox["x", "n"]}], ")"}], "p"]}], ")"}], "q"]}], "]"}], 
    "r"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"\[Integral]", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"Log", "[", 
           SuperscriptBox["x", 
            RowBox[{"n", " ", "p", " ", "q"}]], "]"}], "r"], 
         RowBox[{"\[DifferentialD]", "x"}]}]}], ",", 
       SuperscriptBox["x", 
        RowBox[{"n", " ", "p", " ", "q"}]], ",", 
       RowBox[{"a", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"b", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"c", " ", 
              SuperscriptBox["x", "n"]}], ")"}], "p"]}], ")"}], "q"]}]}], 
      "]"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, {3.495161845931078*^9, 
   3.4951618787379355`*^9}, {3.495163638398227*^9, 3.495163646853442*^9}, 
   3.49516370254554*^9, {3.495164038477331*^9, 3.4951640737177925`*^9}, 
   3.495199899876562*^9, 3.49519994111662*^9, {3.4952000649467936`*^9, 
   3.495200075966809*^9}, {3.4952019860094833`*^9, 3.4952019978094997`*^9}, 
   3.495202186849764*^9, {3.495202396160057*^9, 3.495202406320071*^9}, {
   3.495202538720257*^9, 3.4952025534702773`*^9}, 3.4952026366403937`*^9, {
   3.495202693010473*^9, 3.4952027377005353`*^9}, {3.495202830430665*^9, 
   3.4952028787207327`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"a_.", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b_.", "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"c_.", "*", 
             RowBox[{"x_", "^", "n_."}]}], ")"}], "^", "p_"}]}], ")"}], "^", 
        "q_"}]}], "]"}], "^", "r_."}], ",", "x_Symbol"}], "]"}], " ", ":=", 
  "\n", "  ", 
  RowBox[{
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Log", "[", 
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"n", "*", "p", "*", "q"}], ")"}]}], "]"}], "^", "r"}], ",",
        "x"}], "]"}], ",", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"n", "*", "p", "*", "q"}], ")"}]}], ",", 
     RowBox[{"a", "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], ")"}], "^", "p"}]}], ")"}], "^", 
       "q"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "a", ",", "b", ",", "c", ",", "n", ",", "p", ",", "q", ",", "r"}], 
      "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4951616675135646`*^9, 3.495163619631394*^9, 
   3.495164018025695*^9, 3.495199875426528*^9, 3.4952000136967216`*^9, 
   3.495201805939231*^9, 3.4952019420094213`*^9, 3.4952021430497026`*^9, {
   3.4952023111099377`*^9, 3.4952023425599823`*^9}, {3.4952024566001415`*^9, 
   3.495202471920163*^9}, 3.495202513800222*^9, 3.495202581400316*^9, 
   3.495202613140361*^9, 3.4952028098606367`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, {3.495162264932214*^9, 
   3.495162277318636*^9}, {3.4951637747120676`*^9, 3.495163775320469*^9}, {
   3.4951642488437004`*^9, 3.4951642509653044`*^9}, {3.495200116396866*^9, 
   3.4952001199668703`*^9}, {3.495201853289297*^9, 3.4952018648993134`*^9}, {
   3.495202034479551*^9, 3.495202075309608*^9}, {3.4952022052197895`*^9, 
   3.495202209799796*^9}, {3.49520236235001*^9, 3.495202364530013*^9}, {
   3.4952024627101507`*^9, 3.495202466110155*^9}, {3.4952025192402296`*^9, 
   3.495202520900232*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], 
   SuperscriptBox[
    RowBox[{"Log", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}], ")"}], "p"]}], "]"}], "q"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"\[Integral]", 
        RowBox[{
         SuperscriptBox["x", "m"], " ", 
         SuperscriptBox[
          RowBox[{"Log", "[", 
           SuperscriptBox["x", 
            RowBox[{"n", " ", "p"}]], "]"}], "q"], 
         RowBox[{"\[DifferentialD]", "x"}]}]}], ",", 
       SuperscriptBox["x", 
        RowBox[{"n", " ", "p"}]], ",", 
       RowBox[{"a", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", "n"]}], ")"}], "p"]}]}], 
      "]"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, {3.495161845931078*^9, 
   3.4951618787379355`*^9}, {3.495163638398227*^9, 3.495163646853442*^9}, 
   3.49516370254554*^9, {3.495164038477331*^9, 3.4951640737177925`*^9}, 
   3.495199899876562*^9, 3.49519994111662*^9, {3.4952000649467936`*^9, 
   3.495200075966809*^9}, {3.4952019860094833`*^9, 3.4952019978094997`*^9}, 
   3.495202186849764*^9, {3.495202396160057*^9, 3.495202406320071*^9}, {
   3.495202538720257*^9, 3.4952025534702773`*^9}, 3.4952026366403937`*^9, {
   3.495202693010473*^9, 3.4952027377005353`*^9}, {3.495202830430665*^9, 
   3.4952028787207327`*^9}, {3.4952029512308345`*^9, 3.4952029834808793`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"a_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"b_.", "*", 
           RowBox[{"x_", "^", "n_."}]}], ")"}], "^", "p_"}]}], "]"}], "^", 
      "q_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "m"}], "*", 
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"x", "^", 
           RowBox[{"(", 
            RowBox[{"n", "*", "p"}], ")"}]}], "]"}], "^", "q"}]}], ",", "x"}],
       "]"}], ",", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"n", "*", "p"}], ")"}]}], ",", 
     RowBox[{"a", "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{"x", "^", "n"}]}], ")"}], "^", "p"}]}]}], "]"}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m", ",", "n", ",", "p", ",", "q"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"n", "*", "p"}], ")"}]}], "===", 
      RowBox[{"a", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}], ")"}], "^", "p"}]}]}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4951616675135646`*^9, 3.495163619631394*^9, 
   3.495164018025695*^9, 3.495199875426528*^9, 3.4952000136967216`*^9, 
   3.495201805939231*^9, 3.4952019420094213`*^9, 3.4952021430497026`*^9, {
   3.4952023111099377`*^9, 3.4952023425599823`*^9}, {3.4952024566001415`*^9, 
   3.495202471920163*^9}, 3.495202513800222*^9, 3.495202581400316*^9, 
   3.495202613140361*^9, 3.4952028098606367`*^9, 3.495202934390811*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, {3.495162264932214*^9, 
   3.495162277318636*^9}, {3.4951637747120676`*^9, 3.495163775320469*^9}, {
   3.4951642488437004`*^9, 3.4951642509653044`*^9}, {3.495200116396866*^9, 
   3.4952001199668703`*^9}, {3.495201853289297*^9, 3.4952018648993134`*^9}, {
   3.495202034479551*^9, 3.495202075309608*^9}, {3.4952022052197895`*^9, 
   3.495202209799796*^9}, {3.49520236235001*^9, 3.495202364530013*^9}, {
   3.4952024627101507`*^9, 3.495202466110155*^9}, {3.4952025192402296`*^9, 
   3.495202520900232*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], 
   SuperscriptBox[
    RowBox[{"Log", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"c", " ", 
            SuperscriptBox["x", "n"]}], ")"}], "p"]}], ")"}], "q"]}], "]"}], 
    "r"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"\[Integral]", 
        RowBox[{
         SuperscriptBox["x", "m"], " ", 
         SuperscriptBox[
          RowBox[{"Log", "[", 
           SuperscriptBox["x", 
            RowBox[{"n", " ", "p", " ", "q"}]], "]"}], "r"], 
         RowBox[{"\[DifferentialD]", "x"}]}]}], ",", 
       SuperscriptBox["x", 
        RowBox[{"n", " ", "p", " ", "q"}]], ",", 
       RowBox[{"a", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"b", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"c", " ", 
              SuperscriptBox["x", "n"]}], ")"}], "p"]}], ")"}], "q"]}]}], 
      "]"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, {3.495161845931078*^9, 
   3.4951618787379355`*^9}, {3.495163638398227*^9, 3.495163646853442*^9}, 
   3.49516370254554*^9, {3.495164038477331*^9, 3.4951640737177925`*^9}, 
   3.495199899876562*^9, 3.49519994111662*^9, {3.4952000649467936`*^9, 
   3.495200075966809*^9}, {3.4952019860094833`*^9, 3.4952019978094997`*^9}, 
   3.495202186849764*^9, {3.495202396160057*^9, 3.495202406320071*^9}, {
   3.495202538720257*^9, 3.4952025534702773`*^9}, 3.4952026366403937`*^9, {
   3.495202693010473*^9, 3.4952027377005353`*^9}, {3.495202830430665*^9, 
   3.4952028787207327`*^9}, {3.4952029512308345`*^9, 
   3.4952029834808793`*^9}, {3.4952030903910294`*^9, 3.4952031038410482`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"a_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"b_.", "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"c_.", "*", 
              RowBox[{"x_", "^", "n_."}]}], ")"}], "^", "p_"}]}], ")"}], "^", 
         "q_"}]}], "]"}], "^", "r_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "m"}], "*", 
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"x", "^", 
           RowBox[{"(", 
            RowBox[{"n", "*", "p", "*", "q"}], ")"}]}], "]"}], "^", "r"}]}], 
       ",", "x"}], "]"}], ",", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"n", "*", "p", "*", "q"}], ")"}]}], ",", 
     RowBox[{"a", "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], ")"}], "^", "p"}]}], ")"}], "^", 
       "q"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "m", ",", "n", ",", "p", ",", "q", ",", 
        "r"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"n", "*", "p", "*", "q"}], ")"}]}], "===", 
      RowBox[{"a", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", "n"}]}], ")"}], "^", "p"}]}], ")"}], "^", 
        "q"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4951616675135646`*^9, 3.495163619631394*^9, 
   3.495164018025695*^9, 3.495199875426528*^9, 3.4952000136967216`*^9, 
   3.495201805939231*^9, 3.4952019420094213`*^9, 3.4952021430497026`*^9, {
   3.4952023111099377`*^9, 3.4952023425599823`*^9}, {3.4952024566001415`*^9, 
   3.495202471920163*^9}, 3.495202513800222*^9, 3.495202581400316*^9, 
   3.495202613140361*^9, 3.4952028098606367`*^9, 3.495202934390811*^9, 
   3.49520301989093*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"Log", "[", 
     RowBox[{"c", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], "]"}], "p"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, {
   3.494172650949109*^9, 3.494172665319129*^9}, 3.4951614288955455`*^9, 
   3.4951617140016465`*^9, {3.495162187524878*^9, 3.495162197867696*^9}, 
   3.495162421681289*^9, 3.495163536311648*^9, 3.4951639784796257`*^9, 
   3.4952358966570516`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"p", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, {3.495162264932214*^9, 
   3.495162277318636*^9}, {3.4951637747120676`*^9, 3.495163775320469*^9}, {
   3.4951642488437004`*^9, 3.4951642509653044`*^9}, {3.4952359429371166`*^9, 
   3.495235964997147*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, 3.4951636244830027`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"Log", "[", 
      RowBox[{"c", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], "]"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", "m"], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"Log", "[", 
          RowBox[{"c", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], "]"}], "p"]}], 
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  "                                                 ", "\[IndentingNewLine]", 
  "                        ", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", "m"}], 
    RowBox[{"b", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"Log", "[", 
       RowBox[{"c", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], "]"}], "p"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"n", " ", "p"}], 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"Log", "[", 
       RowBox[{"c", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], "]"}], 
      RowBox[{"p", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, {3.495161845931078*^9, 
   3.4951618787379355`*^9}, {3.495163638398227*^9, 3.495163646853442*^9}, 
   3.49516370254554*^9, {3.495164038477331*^9, 3.4951640737177925`*^9}, {
   3.495236000747197*^9, 3.4952360315472403`*^9}, 3.495236073317299*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"c_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a_", "+", 
           RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "n_."}]}], "]"}], "^", 
      "p_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "m"}], "*", 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Log", "[", 
        RowBox[{"c", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}]}], "]"}], "^", "p"}],
       "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"m", "/", 
        RowBox[{"(", 
         RowBox[{"b", "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"a", "+", 
               RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}]}], "]"}], "^", 
          "p"}]}], ",", "x"}], "]"}]}], "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "*", 
       RowBox[{"p", "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"a", "+", 
               RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "p"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}], " ", "&&", " ", 
    RowBox[{"p", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4951616675135646`*^9, 3.495163619631394*^9, 
   3.495164018025695*^9, 3.4952359113970723`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"p", ">", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, {3.495162264932214*^9, 
   3.495162277318636*^9}, {3.4951637747120676`*^9, 3.495163775320469*^9}, {
   3.4951642488437004`*^9, 3.4951642509653044`*^9}, {3.4952360986673346`*^9, 
   3.4952361002073364`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"Log", "[", 
       RowBox[{"c", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], "]"}], "p"], 
     SuperscriptBox["x", "2"]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"Log", "[", 
           RowBox[{"c", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"a", "+", 
               RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], "]"}], "p"]}], 
        RowBox[{"a", " ", "x"}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"b", " ", "n", " ", "p"}], "a"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"Log", "[", 
        RowBox[{"c", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], "]"}], 
       RowBox[{"p", "-", "1"}]], "x"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, 3.4951622258697453`*^9, 
   3.4951623402647467`*^9, {3.4951637900936947`*^9, 3.4951638150849385`*^9}, {
   3.495164178986778*^9, 3.4951642244608574`*^9}, {3.4952361349873853`*^9, 
   3.4952361437173977`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"c_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a_", "+", 
           RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "n_."}]}], "]"}], "^", 
      "p_"}], "/", 
     RowBox[{"x_", "^", "2"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
  "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Log", "[", 
        RowBox[{"c", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}]}], "]"}], "^", "p"}],
       "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "x"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", "n", "*", 
       RowBox[{"p", "/", "a"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"a", "+", 
               RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}]}], "/", "x"}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4951616878092003`*^9, 3.495162292263462*^9, 
   3.495163765133651*^9, 3.4951638729766407`*^9, 3.4951641424515133`*^9, 
   3.495236092757326*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{"m", "\[NotEqual]", 
    RowBox[{"-", "2"}]}], " ", "\[And]", " ", 
   RowBox[{"p", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, {3.495162264932214*^9, 
   3.495162277318636*^9}, {3.4951637747120676`*^9, 3.495163775320469*^9}, {
   3.4951642488437004`*^9, 3.4951642509653044`*^9}, {3.4952359429371166`*^9, 
   3.495235964997147*^9}, {3.4952361839874535`*^9, 3.4952362099374905`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"Log", "[", 
      RowBox[{"c", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], "]"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"Log", "[", 
          RowBox[{"c", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], "]"}], "p"]}], 
       RowBox[{"a", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  "                                                                  ", 
  "\[IndentingNewLine]", "                                             ", 
  RowBox[{
   FractionBox[
    RowBox[{"b", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "2"}], ")"}]}], 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"Log", "[", 
       RowBox[{"c", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], "]"}], "p"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"b", " ", "n", " ", "p"}], 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"Log", "[", 
       RowBox[{"c", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], "]"}], 
      RowBox[{"p", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, 3.4951622258697453`*^9, 
   3.4951623402647467`*^9, {3.4951637900936947`*^9, 3.4951638150849385`*^9}, {
   3.495164178986778*^9, 3.4951642244608574`*^9}, {3.4952361349873853`*^9, 
   3.4952361437173977`*^9}, {3.495236246957542*^9, 3.4952362639675655`*^9}, {
   3.4953184493143997`*^9, 3.4953184761844378`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"c_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a_", "+", 
           RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "n_."}]}], "]"}], "^", 
      "p_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Log", "[", 
        RowBox[{"c", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}]}], "]"}], "^", "p"}],
       "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{"(", 
          RowBox[{"m", "+", "2"}], ")"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"a", "+", 
               RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}]}], "]"}], "^", 
          "p"}]}], ",", "x"}], "]"}]}], "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", "n", "*", 
       RowBox[{"p", "/", 
        RowBox[{"(", 
         RowBox[{"a", "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"a", "+", 
               RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "p"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"m", "!=", 
     RowBox[{"-", "2"}]}], " ", "&&", " ", 
    RowBox[{"p", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4951616878092003`*^9, 3.495162292263462*^9, 
   3.495163765133651*^9, 3.4951638729766407`*^9, 3.4951641424515133`*^9, 
   3.495236092757326*^9, 3.495236163997426*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"m", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
      " ", 
      RowBox[{"p", ">", "0"}]}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, {3.495162264932214*^9, 
   3.495162277318636*^9}, {3.4951637747120676`*^9, 3.495163775320469*^9}, {
   3.4951642488437004`*^9, 3.4951642509653044`*^9}, {3.4952359429371166`*^9, 
   3.495235964997147*^9}, {3.4952361839874535`*^9, 3.4952362099374905`*^9}, {
   3.495236384457734*^9, 3.4952364449378195`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"Log", "[", 
     RowBox[{"c", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], "]"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "b"]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["a", "b"]}], "+", 
          FractionBox["x", "b"]}], ")"}], "m"], " ", 
       SuperscriptBox[
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "n"]}], "]"}], "p"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, 3.4951622258697453`*^9, 
   3.4951623402647467`*^9, {3.4951637900936947`*^9, 3.4951638150849385`*^9}, {
   3.495164178986778*^9, 3.4951642244608574`*^9}, {3.4952361349873853`*^9, 
   3.4952361437173977`*^9}, {3.495236246957542*^9, 3.4952362639675655`*^9}, 
   3.495236321187646*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"c_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a_", "+", 
           RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "n_."}]}], "]"}], "^", 
      "p_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", "b"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "a"}], "/", "b"}], "+", 
             RowBox[{"x", "/", "b"}]}], ")"}], "^", "m"}], "*", 
          RowBox[{
           RowBox[{"Log", "[", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", "n"}]}], "]"}], "^", "p"}]}], ",", "x"}], 
        "]"}], ",", "x", ",", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "n", ",", "p"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
      RowBox[{"p", ">", "0"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4951616878092003`*^9, 3.495162292263462*^9, 
   3.495163765133651*^9, 3.4951638729766407`*^9, 3.4951641424515133`*^9, 
   3.495236092757326*^9, 3.495236163997426*^9, 3.4952362884776*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"Log", "[", 
      RowBox[{"c", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], "]"}], "p"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"e", " ", "x"}]}], ")"}], "m"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, {
   3.494172650949109*^9, 3.494172665319129*^9}, 3.4951614288955455`*^9, 
   3.4951617140016465`*^9, {3.495162187524878*^9, 3.495162197867696*^9}, 
   3.495162421681289*^9, 3.515952281115533*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.728.2", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4940010628073196`*^9, 3.4941723607787027`*^9, 3.4941724567488375`*^9, 
   3.494172696119172*^9, 3.4951614417343683`*^9, 3.495161553867365*^9}],

Cell["Derivation: Primitive rule", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9, 3.495161586221822*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    RowBox[{"(", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"PolyLog", "[", 
        RowBox[{"2", ",", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}]}], "]"}], "e"]}], ")"}]}], "=", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", "d", "-", 
      RowBox[{"e", " ", "x"}]}], "]"}], 
    RowBox[{"d", "+", 
     RowBox[{"e", " ", "x"}]}]]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, 3.495161586221822*^9, {3.4951616240362883`*^9, 
   3.4951616313215013`*^9}}],

Cell[TextData[{
 "Rule: If ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "c", " ", "e"}], "-", 
    RowBox[{"b", " ", "c", " ", "d"}], "-", "e"}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}]}], "]"}], 
    RowBox[{"d", "+", 
     RowBox[{"e", " ", "x"}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"PolyLog", "[", 
        RowBox[{"2", ",", 
         RowBox[{"1", "-", 
          RowBox[{"a", " ", "c"}], "-", 
          RowBox[{"b", " ", "c", " ", "x"}]}]}], "]"}], 
       "e"]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, {3.495161845931078*^9, 
   3.4951618787379355`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"c_.", "*", 
       RowBox[{"(", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", "x_"}]}], ")"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"d_", "+", 
       RowBox[{"e_.", "*", "x_"}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"PolyLog", "[", 
      RowBox[{"2", ",", 
       RowBox[{"1", "-", 
        RowBox[{"a", "*", "c"}], "-", 
        RowBox[{"b", "*", "c", "*", "x"}]}]}], "]"}]}], "/", "e"}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "c", "*", "e"}], "-", 
      RowBox[{"b", "*", "c", "*", "d"}], "-", "e"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4951616675135646`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"b", " ", "d"}], "-", 
    RowBox[{"a", " ", "e"}]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, {3.495162264932214*^9, 
   3.495162277318636*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"Log", "[", 
      RowBox[{"c", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], "]"}], 
     RowBox[{"d", "+", 
      RowBox[{"e", " ", "x"}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "e"]}]}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"c", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], "]"}], " ", 
    RowBox[{"Log", "[", 
     FractionBox[
      RowBox[{"b", " ", 
       RowBox[{"(", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], ")"}]}], 
      RowBox[{
       RowBox[{"b", " ", "d"}], "-", 
       RowBox[{"a", " ", "e"}]}]], "]"}]}]}], "+", 
  RowBox[{
   FractionBox["n", "e"], " ", 
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"e", " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}]}], 
       RowBox[{
        RowBox[{"b", " ", "d"}], "-", 
        RowBox[{"a", " ", "e"}]}]]}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, 3.4951622258697453`*^9, 
   3.4951623402647467`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"c_.", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "n_."}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"d_", "+", 
       RowBox[{"e_.", "*", "x_"}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"c", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"b", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", "*", "d"}], "-", 
           RowBox[{"a", "*", "e"}]}], ")"}]}]}], "]"}], "/", "e"}]}], " ", 
    "+", "\n", "  ", 
    RowBox[{"n", "*", 
     RowBox[{
      RowBox[{"PolyLog", "[", 
       RowBox[{"2", ",", 
        RowBox[{
         RowBox[{"-", "e"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"b", "*", "d"}], "-", 
            RowBox[{"a", "*", "e"}]}], ")"}]}]}]}], "]"}], "/", "e"}]}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "n"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "d"}], "-", 
      RowBox[{"a", "*", "e"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4951616878092003`*^9, 3.495162292263462*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"p", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"b", " ", "d"}], "-", 
     RowBox[{"a", " ", "e"}]}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, {3.495162264932214*^9, 
   3.495162277318636*^9}, {3.4951624969202213`*^9, 3.495162512208248*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"Log", "[", 
       RowBox[{"c", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], "]"}], "p"], 
     RowBox[{"d", "+", 
      RowBox[{"e", " ", "x"}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox["1", "e"]}]}], " ", 
    SuperscriptBox[
     RowBox[{"Log", "[", 
      RowBox[{"c", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], "]"}], "p"], " ", 
    RowBox[{"Log", "[", 
     FractionBox[
      RowBox[{"b", " ", 
       RowBox[{"(", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], ")"}]}], 
      RowBox[{
       RowBox[{"b", " ", "d"}], "-", 
       RowBox[{"a", " ", "e"}]}]], "]"}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"b", " ", "n", " ", "p"}], "e"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], "]"}], 
        RowBox[{"p", "-", "1"}]], " ", 
       RowBox[{"Log", "[", 
        FractionBox[
         RowBox[{"b", " ", 
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], ")"}]}], 
         RowBox[{
          RowBox[{"b", " ", "d"}], "-", 
          RowBox[{"a", " ", "e"}]}]], "]"}]}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, 3.4951622258697453`*^9, 
   3.4951623402647467`*^9, 3.4951624589029546`*^9, {3.4951625764731617`*^9, 
   3.4951626064252143`*^9}, {3.4953186283146505`*^9, 3.495318647014677*^9}, {
   3.515955273396394*^9, 3.515955281040407*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"c_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a_", "+", 
           RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "n_."}]}], "]"}], "^", 
      "p_."}], "/", 
     RowBox[{"(", 
      RowBox[{"d_.", "+", 
       RowBox[{"e_.", "*", "x_"}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"c", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}]}], "]"}], "^", "p"}], 
     "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"b", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", "*", "d"}], "-", 
           RowBox[{"a", "*", "e"}]}], ")"}]}]}], "]"}], "/", "e"}]}], " ", 
    "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", "n", "*", 
       RowBox[{"p", "/", "e"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"a", "+", 
               RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"b", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"d", "+", 
               RowBox[{"e", "*", "x"}]}], ")"}], "/", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"b", "*", "d"}], "-", 
               RowBox[{"a", "*", "e"}]}], ")"}]}]}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "n"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "0"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "d"}], "-", 
      RowBox[{"a", "*", "e"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4951616878092003`*^9, 3.495162292263462*^9, 
   3.49516247887099*^9, 3.4951651027064013`*^9, 3.495165649947362*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[TextData[{
 "Note: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Log", "[", "z", "]"}], "=", 
   RowBox[{"-", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"1", ",", 
      RowBox[{"1", "-", "z"}]}], "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.4951626597149076`*^9, 3.4951626813677464`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"p", ">", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"b", " ", "d"}], "-", 
     RowBox[{"a", " ", "e"}]}]}], "=", 
   RowBox[{
    RowBox[{"0", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"a", " ", "g", " ", "h"}], "-", 
      RowBox[{"b", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"f", " ", "h"}], "-", "1"}], ")"}]}]}]}], "=", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, {3.495162264932214*^9, 
   3.495162277318636*^9}, {3.4951624969202213`*^9, 3.495162512208248*^9}, {
   3.4951627568718786`*^9, 3.4951627903339376`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"Log", "[", 
        RowBox[{"c", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], "]"}], "p"], 
      RowBox[{"Log", "[", 
       RowBox[{"h", 
        RowBox[{"(", 
         RowBox[{"f", "+", 
          RowBox[{"g", " ", "x"}]}], ")"}]}], "]"}]}], 
     RowBox[{"d", "+", 
      RowBox[{"e", " ", "x"}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"Log", "[", 
           RowBox[{"c", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"a", "+", 
               RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], "]"}], "p"], " ", 
         RowBox[{"PolyLog", "[", 
          RowBox[{"2", ",", 
           RowBox[{"1", "-", 
            RowBox[{"h", " ", 
             RowBox[{"(", 
              RowBox[{"f", "+", 
               RowBox[{"g", " ", "x"}]}], ")"}]}]}]}], "]"}]}], 
        "e"]}]}]}]}]}], "+", "\[IndentingNewLine]", 
  RowBox[{
   FractionBox[
    RowBox[{"b", " ", "n", " ", "p"}], "e"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], "]"}], 
        RowBox[{"p", "-", "1"}]], " ", 
       RowBox[{"PolyLog", "[", 
        RowBox[{"2", ",", 
         RowBox[{"1", "-", 
          RowBox[{"h", " ", 
           RowBox[{"(", 
            RowBox[{"f", "+", 
             RowBox[{"g", " ", "x"}]}], ")"}]}]}]}], "]"}]}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, 3.4951622258697453`*^9, 
   3.4951623402647467`*^9, 3.4951624589029546`*^9, {3.4951625764731617`*^9, 
   3.4951626064252143`*^9}, {3.4951628369780197`*^9, 
   3.4951628486156397`*^9}, {3.495162963603442*^9, 3.495162975147462*^9}, {
   3.4953186997347507`*^9, 3.49531874939482*^9}, {3.51595528804482*^9, 
   3.515955297467236*^9}, {3.5159554395714855`*^9, 3.5159554418334894`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"c_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a_", "+", 
           RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "n_."}]}], "]"}], "^", 
      "p_."}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"h_.", "*", 
        RowBox[{"(", 
         RowBox[{"f_.", "+", 
          RowBox[{"g_.", "*", "x_"}]}], ")"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"d_", "+", 
        RowBox[{"e_.", "*", "x_"}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"q", "=", 
       RowBox[{"Simplify", "[", 
        RowBox[{"1", "-", 
         RowBox[{"h", "*", 
          RowBox[{"(", 
           RowBox[{"f", "+", 
            RowBox[{"g", "*", "x"}]}], ")"}]}]}], "]"}]}], "}"}], ",", "\n", 
     "  ", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"c", "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}]}], "]"}], "^", 
         "p"}]}], "*", 
       RowBox[{
        RowBox[{"PolyLog", "[", 
         RowBox[{"2", ",", "q"}], "]"}], "/", "e"}]}], " ", "+", "\n", "  ", 
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"b", "*", "n", "*", 
         RowBox[{"p", "/", "e"}]}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"Log", "[", 
             RowBox[{"c", "*", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"a", "+", 
                 RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}]}], "]"}], "^", 
            RowBox[{"(", 
             RowBox[{"p", "-", "1"}], ")"}]}], "*", 
           RowBox[{
            RowBox[{"PolyLog", "[", 
             RowBox[{"2", ",", "q"}], "]"}], "/", 
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", "x"}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
       "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", 
        "h", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "d"}], "-", 
      RowBox[{"a", "*", "e"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "g", "*", "h"}], "-", 
      RowBox[{"b", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"f", "*", "h"}], "-", "1"}], ")"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4951616878092003`*^9, 3.495162292263462*^9, 
   3.49516247887099*^9, 3.4951626919289646`*^9, 3.4951627504134674`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"p", ">", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"b", " ", "d"}], "-", 
     RowBox[{"a", " ", "e"}]}]}], "=", 
   RowBox[{
    RowBox[{"0", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"a", " ", "g"}], " ", "-", 
      RowBox[{"b", " ", "f"}]}]}], "=", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, {3.495162264932214*^9, 
   3.495162277318636*^9}, {3.4951624969202213`*^9, 3.495162512208248*^9}, {
   3.4951627568718786`*^9, 3.4951627903339376`*^9}, {3.495163243077933*^9, 
   3.4951632483507423`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"Log", "[", 
        RowBox[{"c", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], "]"}], "p"], 
      RowBox[{"PolyLog", "[", 
       RowBox[{"m", ",", 
        RowBox[{"h", 
         RowBox[{"(", 
          RowBox[{"f", "+", 
           RowBox[{"g", " ", "x"}]}], ")"}]}]}], "]"}]}], 
     RowBox[{"d", "+", 
      RowBox[{"e", " ", "x"}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"Log", "[", 
          RowBox[{"c", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], "]"}], "p"], " ", 
        RowBox[{"PolyLog", "[", 
         RowBox[{
          RowBox[{"m", "+", "1"}], ",", 
          RowBox[{"h", " ", 
           RowBox[{"(", 
            RowBox[{"f", "+", 
             RowBox[{"g", " ", "x"}]}], ")"}]}]}], "]"}]}], "e"]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"b", " ", "n", " ", "p"}], "e"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], "]"}], 
        RowBox[{"p", "-", "1"}]], " ", 
       RowBox[{"PolyLog", "[", 
        RowBox[{
         RowBox[{"m", "+", "1"}], ",", 
         RowBox[{"h", " ", 
          RowBox[{"(", 
           RowBox[{"f", "+", 
            RowBox[{"g", " ", "x"}]}], ")"}]}]}], "]"}]}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, 3.4951622258697453`*^9, 
   3.4951623402647467`*^9, 3.4951624589029546`*^9, {3.4951625764731617`*^9, 
   3.4951626064252143`*^9}, {3.4951628369780197`*^9, 
   3.4951628486156397`*^9}, {3.495162963603442*^9, 3.495162975147462*^9}, {
   3.495163280611599*^9, 3.4951633306096864`*^9}, {3.4953187738248544`*^9, 
   3.4953187951648846`*^9}, {3.5159553096820574`*^9, 3.515955317216871*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"c_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a_", "+", 
           RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "n_."}]}], "]"}], "^", 
      "p_."}], "*", 
     RowBox[{
      RowBox[{"PolyLog", "[", 
       RowBox[{"m_", ",", 
        RowBox[{"h_.", "*", 
         RowBox[{"(", 
          RowBox[{"f_.", "+", 
           RowBox[{"g_.", "*", "x_"}]}], ")"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"d_", "+", 
        RowBox[{"e_.", "*", "x_"}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"c", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}]}], "]"}], "^", "p"}], 
     "*", 
     RowBox[{
      RowBox[{"PolyLog", "[", 
       RowBox[{
        RowBox[{"m", "+", "1"}], ",", 
        RowBox[{"h", "*", 
         RowBox[{"(", 
          RowBox[{"f", "+", 
           RowBox[{"g", "*", "x"}]}], ")"}]}]}], "]"}], "/", "e"}]}], " ", 
    "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", "n", "*", 
       RowBox[{"p", "/", "e"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"a", "+", 
               RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"PolyLog", "[", 
           RowBox[{
            RowBox[{"m", "+", "1"}], ",", 
            RowBox[{"h", "*", 
             RowBox[{"(", 
              RowBox[{"f", "+", 
               RowBox[{"g", "*", "x"}]}], ")"}]}]}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", 
        "h", ",", "m", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "d"}], "-", 
      RowBox[{"a", "*", "e"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "g"}], "-", 
      RowBox[{"b", "*", "f"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4951616878092003`*^9, 3.495162292263462*^9, 
   3.49516247887099*^9, 3.4951626919289646`*^9, 3.4951627504134674`*^9, 
   3.4951631046744895`*^9, 3.4951632325323143`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", 
   RowBox[{
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"p", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, {3.495162264932214*^9, 
   3.495162277318636*^9}, {3.4951624969202213`*^9, 3.495162512208248*^9}, {
   3.515952187031768*^9, 3.5159522248930345`*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"e", " ", "x"}]}], ")"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"Log", "[", 
      RowBox[{"c", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], "]"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], ")"}], 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"Log", "[", 
          RowBox[{"c", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], "]"}], "p"]}], 
       RowBox[{"e", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"b", " ", "n", " ", "p"}], 
    RowBox[{"e", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], ")"}], 
        RowBox[{"m", "+", "1"}]], " ", 
       SuperscriptBox[
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], "]"}], 
        RowBox[{"p", "-", "1"}]]}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, {3.495239339251871*^9, 
   3.495239350531887*^9}, {3.5159516795928783`*^9, 3.515951774023044*^9}, {
   3.5159518103375072`*^9, 3.5159518622051983`*^9}, {3.515951923864106*^9, 
   3.515951927140112*^9}, {3.5159519768105993`*^9, 3.515952009882657*^9}, 
   3.5159553233944817`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d_.", "+", 
        RowBox[{"e_.", "*", "x_"}]}], ")"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"c_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a_.", "+", 
           RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "n_."}]}], "]"}], "^", 
      "p_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Log", "[", 
        RowBox[{"c", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}]}], "]"}], "^", "p"}],
       "/", 
      RowBox[{"(", 
       RowBox[{"e", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", "n", "*", 
       RowBox[{"p", "/", 
        RowBox[{"(", 
         RowBox[{"e", "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"Regularize", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], ")"}], "^", 
            RowBox[{"(", 
             RowBox[{"m", "+", "1"}], ")"}]}], "*", 
           RowBox[{
            RowBox[{
             RowBox[{"Log", "[", 
              RowBox[{"c", "*", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"a", "+", 
                  RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}]}], "]"}], "^", 
             RowBox[{"(", 
              RowBox[{"p", "-", "1"}], ")"}]}], "/", 
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", "x"}]}], ")"}]}]}], ",", "x"}], "]"}], ",", 
        "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "n"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "p"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"p", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4952393044318223`*^9, {3.5159516835396852`*^9, 
   3.515951781430657*^9}, {3.5159519314301195`*^9, 3.515951950571353*^9}, {
   3.5159520705075636`*^9, 3.5159521203104506`*^9}, {3.5159523780997033`*^9, 
   3.515952378520904*^9}, {3.5171893526703444`*^9, 3.517189354994748*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Log", "[", 
     RowBox[{"c", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "m"]}]}], ")"}], "n"]}], "]"}], "p"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, {
   3.494172650949109*^9, 3.494172665319129*^9}, 3.4951614288955455`*^9, 
   3.4951617140016465`*^9, {3.495162187524878*^9, 3.495162197867696*^9}, 
   3.495162421681289*^9, 3.495163536311648*^9, 3.4951639784796257`*^9, 
   3.4952358966570516`*^9, 3.4952365244079304`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Note: The b/x in the resulting integrand will be transformed to b x by the \
rule ",
 Cell[BoxData[
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"f", "[", 
      SuperscriptBox["x", "n"], "]"}], "x"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", " ", "\[LongRightArrow]", " ", 
      FractionBox[
       RowBox[{"Subst", "[", 
        RowBox[{
         RowBox[{"\[Integral]", 
          RowBox[{
           FractionBox[
            RowBox[{"f", "[", "x", "]"}], "x"], 
           RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
         SuperscriptBox["x", "n"]}], "]"}], "n"]}]}]}]}]],
  CellChangeTimes->{{3.4952367803782887`*^9, 3.495236791318304*^9}}]
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9, {3.4952366559181147`*^9, 
   3.4952367668382697`*^9}, {3.4952368035383215`*^9, 
   3.4952368658184085`*^9}, {3.495236946928522*^9, 3.495236947508523*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"p", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, {3.495162264932214*^9, 
   3.495162277318636*^9}, {3.4951637747120676`*^9, 3.495163775320469*^9}, {
   3.4951642488437004`*^9, 3.4951642509653044`*^9}, {3.4952359429371166`*^9, 
   3.495235964997147*^9}, {3.4952365823680115`*^9, 3.495236585548016*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Log", "[", 
      RowBox[{"c", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          FractionBox["b", "x"]}], ")"}], "n"]}], "]"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b", "+", 
          RowBox[{"a", " ", "x"}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"Log", "[", 
          RowBox[{"c", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"a", "+", 
              FractionBox["b", "x"]}], ")"}], "n"]}], "]"}], "p"]}], 
       "a"]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"b", " ", "n", " ", "p"}], "a"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"Log", "[", 
        RowBox[{"c", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            FractionBox["b", "x"]}], ")"}], "n"]}], "]"}], 
       RowBox[{"p", "-", "1"}]], "x"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, {3.495161845931078*^9, 
   3.4951618787379355`*^9}, {3.495163638398227*^9, 3.495163646853442*^9}, 
   3.49516370254554*^9, {3.495164038477331*^9, 3.4951640737177925`*^9}, {
   3.495236000747197*^9, 3.4952360315472403`*^9}, 3.495236073317299*^9, {
   3.495236616168059*^9, 3.495236626388073*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"c_.", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a_", "+", 
          RowBox[{"b_.", "/", "x_"}]}], ")"}], "^", "n_."}]}], "]"}], "^", 
     "p_"}], ",", " ", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"a", "*", "x"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Log", "[", 
        RowBox[{"c", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "/", "x"}]}], ")"}], "^", "n"}]}], "]"}], "^", "p"}],
       "/", "a"}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "/", "a"}], "*", "n", "*", "p"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"a", "+", 
               RowBox[{"b", "/", "x"}]}], ")"}], "^", "n"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}]}], "/", "x"}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4951616675135646`*^9, 3.495163619631394*^9, 
   3.495164018025695*^9, 3.4952359113970723`*^9, 3.4952365393879514`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, {3.495162264932214*^9, 
   3.495162277318636*^9}, {3.4951637747120676`*^9, 3.495163775320469*^9}, {
   3.4951642488437004`*^9, 3.4951642509653044`*^9}, {3.4952360986673346`*^9, 
   3.4952361002073364`*^9}, 3.4952369731885586`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Log", "[", 
      RowBox[{"c", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", "2"]}]}], ")"}], "n"]}], "]"}], "2"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "x"}]}], " ", 
    SuperscriptBox[
     RowBox[{"Log", "[", 
      RowBox[{"c", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", "2"]}]}], ")"}], "n"]}], "]"}], "2"]}]}], "+", 
  RowBox[{"8", " ", 
   SuperscriptBox["n", "2"], " ", "x"}], "-", 
  RowBox[{"4", " ", "n", " ", "x", " ", 
   RowBox[{"Log", "[", 
    RowBox[{"c", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "n"]}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"-", "b"}]]], 
   RowBox[{"(", 
    RowBox[{"n", " ", 
     SqrtBox["a"]}], ")"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"             ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"4", " ", "n", " ", 
     RowBox[{"Log", "[", 
      FractionBox[
       RowBox[{
        RowBox[{"-", 
         SqrtBox["a"]}], "+", 
        RowBox[{
         SqrtBox[
          RowBox[{"-", "b"}]], " ", "x"}]}], 
       RowBox[{
        SqrtBox["a"], "+", 
        RowBox[{
         SqrtBox[
          RowBox[{"-", "b"}]], " ", "x"}]}]], "]"}]}], "-", 
    RowBox[{"4", " ", "n", " ", 
     RowBox[{"ArcTanh", "[", 
      FractionBox[
       RowBox[{
        SqrtBox[
         RowBox[{"-", "b"}]], " ", "x"}], 
       SqrtBox["a"]], "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Log", "[", 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           SqrtBox["a"], 
           SqrtBox[
            RowBox[{"-", "b"}]]]}], "+", "x"}], "]"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{
         FractionBox[
          SqrtBox["a"], 
          SqrtBox[
           RowBox[{"-", "b"}]]], "+", "x"}], "]"}]}], ")"}]}], "-", 
    "\[IndentingNewLine]", "   ", 
    RowBox[{"n", " ", 
     SuperscriptBox[
      RowBox[{"Log", "[", 
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          SqrtBox["a"], 
          SqrtBox[
           RowBox[{"-", "b"}]]]}], "+", "x"}], "]"}], "2"]}], "+", 
    RowBox[{"n", " ", 
     SuperscriptBox[
      RowBox[{"Log", "[", 
       RowBox[{
        FractionBox[
         SqrtBox["a"], 
         SqrtBox[
          RowBox[{"-", "b"}]]], "+", "x"}], "]"}], "2"]}], "-", 
    RowBox[{"2", " ", "n", " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       FractionBox[
        SqrtBox["a"], 
        SqrtBox[
         RowBox[{"-", "b"}]]], "+", "x"}], "]"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       FractionBox["1", "2"], "-", 
       FractionBox[
        RowBox[{
         SqrtBox[
          RowBox[{"-", "b"}]], " ", "x"}], 
        RowBox[{"2", " ", 
         SqrtBox["a"]}]]}], "]"}]}], "+", "\[IndentingNewLine]", 
    "            ", 
    RowBox[{"2", " ", "n", " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         SqrtBox["a"], 
         SqrtBox[
          RowBox[{"-", "b"}]]]}], "+", "x"}], "]"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         FractionBox[
          RowBox[{
           SqrtBox[
            RowBox[{"-", "b"}]], " ", "x"}], 
          SqrtBox["a"]]}], ")"}]}], "]"}]}], "+", 
    RowBox[{"4", " ", 
     RowBox[{"ArcTanh", "[", 
      FractionBox[
       RowBox[{
        SqrtBox[
         RowBox[{"-", "b"}]], " ", "x"}], 
       SqrtBox["a"]], "]"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"c", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", "2"]}]}], ")"}], "n"]}], "]"}]}], "+", 
    "\[IndentingNewLine]", 
    RowBox[{"2", " ", "n", " ", 
     RowBox[{"PolyLog", "[", 
      RowBox[{"2", ",", 
       RowBox[{
        FractionBox["1", "2"], "-", 
        FractionBox[
         RowBox[{
          SqrtBox[
           RowBox[{"-", "b"}]], " ", "x"}], 
         RowBox[{"2", " ", 
          SqrtBox["a"]}]]}]}], "]"}]}], "-", 
    RowBox[{"2", " ", "n", " ", 
     RowBox[{"PolyLog", "[", 
      RowBox[{"2", ",", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          FractionBox[
           RowBox[{
            SqrtBox[
             RowBox[{"-", "b"}]], " ", "x"}], 
           SqrtBox["a"]]}], ")"}]}]}], "]"}]}]}], ")"}], 
  "                          "}]}], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, 3.4951622258697453`*^9, 
   3.4951623402647467`*^9, {3.4951637900936947`*^9, 3.4951638150849385`*^9}, {
   3.495164178986778*^9, 3.4951642244608574`*^9}, {3.4952361349873853`*^9, 
   3.4952361437173977`*^9}, {3.495237006628606*^9, 3.49523702420863*^9}, {
   3.495237059028679*^9, 3.4952370679486914`*^9}, {3.495237099748736*^9, 
   3.495237124758771*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"c_.", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a_", "+", 
          RowBox[{"b_.", "*", 
           RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "n_."}]}], "]"}], "^", 
     "2"}], ",", " ", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"c", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "n"}]}], "]"}], "^", 
      "2"}]}], " ", "+", " ", "\n", "    ", 
    RowBox[{"8", "*", 
     RowBox[{"n", "^", "2"}], "*", "x"}], " ", "-", "\n", "    ", 
    RowBox[{"4", "*", "n", "*", "x", "*", 
     RowBox[{"Log", "[", 
      RowBox[{"c", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "n"}]}], "]"}]}], " ", 
    "+", " ", "\n", "    ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "*", 
       RowBox[{
        RowBox[{"Sqrt", "[", "a", "]"}], "/", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"-", "b"}], "]"}]}]}], ")"}], "*", 
     RowBox[{"(", " ", "\n", "      ", 
      RowBox[{
       RowBox[{"4", "*", "n", "*", 
        RowBox[{"Log", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"Sqrt", "[", "a", "]"}]}], "+", 
            RowBox[{
             RowBox[{"Sqrt", "[", 
              RowBox[{"-", "b"}], "]"}], "*", "x"}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Sqrt", "[", "a", "]"}], "+", 
            RowBox[{
             RowBox[{"Sqrt", "[", 
              RowBox[{"-", "b"}], "]"}], "*", "x"}]}], ")"}]}], "]"}]}], " ", 
       "-", " ", "\n", "      ", 
       RowBox[{"4", "*", "n", "*", 
        RowBox[{"ArcTanh", "[", 
         RowBox[{
          RowBox[{"Sqrt", "[", 
           RowBox[{"-", "b"}], "]"}], "*", 
          RowBox[{"x", "/", 
           RowBox[{"Sqrt", "[", "a", "]"}]}]}], "]"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              RowBox[{"Sqrt", "[", "a", "]"}]}], "/", 
             RowBox[{"Sqrt", "[", 
              RowBox[{"-", "b"}], "]"}]}], "+", "x"}], "]"}], " ", "+", " ", 
          RowBox[{"Log", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Sqrt", "[", "a", "]"}], "/", 
             RowBox[{"Sqrt", "[", 
              RowBox[{"-", "b"}], "]"}]}], "+", "x"}], "]"}]}], ")"}]}], " ", 
       "-", "\n", "      ", 
       RowBox[{"n", "*", 
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             RowBox[{"Sqrt", "[", "a", "]"}]}], "/", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"-", "b"}], "]"}]}], "+", "x"}], "]"}], "^", "2"}]}], 
       " ", "+", " ", "\n", "      ", 
       RowBox[{"n", "*", 
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Sqrt", "[", "a", "]"}], "/", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"-", "b"}], "]"}]}], "+", "x"}], "]"}], "^", "2"}]}], 
       " ", "-", " ", "\n", "      ", 
       RowBox[{"2", "*", "n", "*", 
        RowBox[{"Log", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Sqrt", "[", "a", "]"}], "/", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"-", "b"}], "]"}]}], "+", "x"}], "]"}], "*", 
        RowBox[{"Log", "[", 
         RowBox[{
          RowBox[{"1", "/", "2"}], "-", 
          RowBox[{
           RowBox[{"Sqrt", "[", 
            RowBox[{"-", "b"}], "]"}], "*", 
           RowBox[{"x", "/", 
            RowBox[{"(", 
             RowBox[{"2", "*", 
              RowBox[{"Sqrt", "[", "a", "]"}]}], ")"}]}]}]}], "]"}]}], " ", 
       "+", " ", "\n", "      ", 
       RowBox[{"2", "*", "n", "*", 
        RowBox[{"Log", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            RowBox[{"Sqrt", "[", "a", "]"}]}], "/", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"-", "b"}], "]"}]}], "+", "x"}], "]"}], "*", 
        RowBox[{"Log", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             RowBox[{"Sqrt", "[", 
              RowBox[{"-", "b"}], "]"}], "*", 
             RowBox[{"x", "/", 
              RowBox[{"Sqrt", "[", "a", "]"}]}]}]}], ")"}], "/", "2"}], 
         "]"}]}], " ", "+", " ", "\n", "      ", 
       RowBox[{"4", "*", 
        RowBox[{"ArcTanh", "[", 
         RowBox[{
          RowBox[{"Sqrt", "[", 
           RowBox[{"-", "b"}], "]"}], "*", 
          RowBox[{"x", "/", 
           RowBox[{"Sqrt", "[", "a", "]"}]}]}], "]"}], "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c", "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "n"}]}], "]"}]}], " ", 
       "+", " ", "\n", "      ", 
       RowBox[{"2", "*", "n", "*", 
        RowBox[{"PolyLog", "[", 
         RowBox[{"2", ",", 
          RowBox[{
           RowBox[{"1", "/", "2"}], "-", 
           RowBox[{
            RowBox[{"Sqrt", "[", 
             RowBox[{"-", "b"}], "]"}], "*", 
            RowBox[{"x", "/", 
             RowBox[{"(", 
              RowBox[{"2", "*", 
               RowBox[{"Sqrt", "[", "a", "]"}]}], ")"}]}]}]}]}], "]"}]}], " ",
        "-", " ", "\n", "      ", 
       RowBox[{"2", "*", "n", "*", 
        RowBox[{"PolyLog", "[", 
         RowBox[{"2", ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              RowBox[{"Sqrt", "[", 
               RowBox[{"-", "b"}], "]"}], "*", 
              RowBox[{"x", "/", 
               RowBox[{"Sqrt", "[", "a", "]"}]}]}]}], ")"}], "/", "2"}]}], 
         "]"}]}]}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "n"}], "}"}], ",", "x"}], 
    "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4951616878092003`*^9, 3.495162292263462*^9, 
   3.495163765133651*^9, 3.4951638729766407`*^9, 3.4951641424515133`*^9, 
   3.495236092757326*^9, 3.4952369652685475`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Log", "[", 
     RowBox[{"d", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}], "+", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], "n"]}], "]"}], "p"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, {
   3.494172650949109*^9, 3.494172665319129*^9}, 3.4951614288955455`*^9, 
   3.4951617140016465`*^9, {3.495162187524878*^9, 3.495162197867696*^9}, 
   3.495162421681289*^9, 3.495163536311648*^9, 3.495237223218909*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9, 3.495161586221822*^9, 
  3.4951636037349663`*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, 3.4951636244830027`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Log", "[", 
      RowBox[{"d", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"x", " ", 
           RowBox[{"(", 
            RowBox[{"b", "+", 
             RowBox[{"c", " ", "x"}]}], ")"}]}]}], ")"}], "n"]}], "]"}], "2"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "x"}]}], " ", 
    SuperscriptBox[
     RowBox[{"Log", "[", 
      RowBox[{"d", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}], "+", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", "2"]}]}], ")"}], "n"]}], "]"}], "2"]}]}], "-", 
  "                                 ", "\[IndentingNewLine]", 
  "                      ", 
  RowBox[{"2", " ", "b", " ", "n", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"x", " ", 
       RowBox[{"Log", "[", 
        RowBox[{"d", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}], "+", 
            RowBox[{"c", " ", 
             SuperscriptBox["x", "2"]}]}], ")"}], "n"]}], "]"}]}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "-", 
  RowBox[{"4", " ", "c", " ", "n", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", "2"], " ", 
       RowBox[{"Log", "[", 
        RowBox[{"d", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}], "+", 
            RowBox[{"c", " ", 
             SuperscriptBox["x", "2"]}]}], ")"}], "n"]}], "]"}]}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, {3.495161845931078*^9, 
   3.4951618787379355`*^9}, {3.495163638398227*^9, 3.495163646853442*^9}, 
   3.49516370254554*^9, {3.4952372597089596`*^9, 3.495237275898982*^9}, {
   3.49531884176495*^9, 3.49531888459501*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"d_.", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}], "+", 
          RowBox[{"c_.", "*", 
           RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "n_."}]}], "]"}], "^", 
     "2"}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"d", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "n"}]}], "]"}], "^", 
      "2"}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"2", "*", "b", "*", "n"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"x", "*", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"d", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"a", "+", 
               RowBox[{"b", "*", "x"}], "+", 
               RowBox[{"c", "*", 
                RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "n"}]}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "-", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"4", "*", "c", "*", "n"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "2"}], "*", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"d", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"a", "+", 
               RowBox[{"b", "*", "x"}], "+", 
               RowBox[{"c", "*", 
                RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "n"}]}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "n"}], "}"}], ",", 
     "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4951616675135646`*^9, 3.495163619631394*^9, 
   3.4952372087988887`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"a", " ", 
     SuperscriptBox[
      RowBox[{"Log", "[", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "]"}], "p"]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, {
   3.494172650949109*^9, 3.494172665319129*^9}, 3.4951614288955455`*^9, 
   3.4951617140016465`*^9, {3.495162187524878*^9, 3.495162197867696*^9}, 
   3.495162421681289*^9, 3.495163536311648*^9, 3.495237223218909*^9, 
   3.495237324859051*^9, 3.4952376151694574`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9, 3.495161586221822*^9, 
  3.4951636037349663`*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, 3.4951636244830027`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox[
       RowBox[{"Log", "[", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}], "]"}], "p"]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "x"}]}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox[
       RowBox[{"Log", "[", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}], "]"}], "p"]}], "]"}]}]}], "-", 
  RowBox[{"n", " ", "p", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"Log", "[", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "]"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, {3.495161845931078*^9, 
   3.4951618787379355`*^9}, {3.495163638398227*^9, 3.495163646853442*^9}, 
   3.49516370254554*^9, {3.4952372597089596`*^9, 3.495237275898982*^9}, {
   3.4952373570290956`*^9, 3.4952373664991093`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"a_.", "*", 
      RowBox[{
       RowBox[{"Log", "[", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}], "]"}], "^", "p_."}]}], "]"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{"Log", "[", 
      RowBox[{"a", "*", 
       RowBox[{
        RowBox[{"Log", "[", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}], "]"}], "^", "p"}]}], "]"}]}], " ", "-", 
    " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "*", "p"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"Log", "[", 
          RowBox[{"b", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "n", ",", "p"}], "}"}], ",", "x"}], 
    "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4951616675135646`*^9, 3.495163619631394*^9, 
   3.4952372087988887`*^9, 3.4952373332790627`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9, 3.495161586221822*^9, 
  3.4951636037349663`*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, 3.4951636244830027`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox[
       RowBox[{"Log", "[", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}], "]"}], "p"]}], "]"}], "x"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       RowBox[{"Log", "[", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "p"}], "+", 
         RowBox[{"Log", "[", 
          RowBox[{"a", " ", 
           SuperscriptBox[
            RowBox[{"Log", "[", 
             RowBox[{"b", " ", 
              SuperscriptBox["x", "n"]}], "]"}], "p"]}], "]"}]}], ")"}]}], 
      "n"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, {3.495161845931078*^9, 
   3.4951618787379355`*^9}, {3.495163638398227*^9, 3.495163646853442*^9}, 
   3.49516370254554*^9, {3.4952372597089596`*^9, 3.495237275898982*^9}, {
   3.4952373570290956`*^9, 3.4952373664991093`*^9}, {3.495237414719177*^9, 
   3.495237426199193*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"a_.", "*", 
       RowBox[{
        RowBox[{"Log", "[", 
         RowBox[{"b_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "]"}], "^", "p_."}]}], "]"}], "/", 
     "x_"}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"b", "*", 
      RowBox[{"x", "^", "n"}]}], "]"}], "*", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "p"}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"a", "*", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"b", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}], "^", "p"}]}], "]"}]}], ")"}], 
     "/", "n"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "n", ",", "p"}], "}"}], ",", "x"}], 
    "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4951616675135646`*^9, 3.495163619631394*^9, 
   3.4952372087988887`*^9, 3.4952373332790627`*^9, 3.4952374023491597`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9, 3.495161586221822*^9, 
  3.4951636037349663`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, {3.495162264932214*^9, 
   3.495162277318636*^9}, {3.4951637747120676`*^9, 3.495163775320469*^9}, {
   3.4951642488437004`*^9, 3.4951642509653044`*^9}, {3.4952359429371166`*^9, 
   3.495235964997147*^9}, {3.4952375126393137`*^9, 3.495237523179329*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox[
       RowBox[{"Log", "[", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}], "]"}], "p"]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        RowBox[{"Log", "[", 
         RowBox[{"a", " ", 
          SuperscriptBox[
           RowBox[{"Log", "[", 
            RowBox[{"b", " ", 
             SuperscriptBox["x", "n"]}], "]"}], "p"]}], "]"}]}], 
       RowBox[{"m", "+", "1"}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"n", " ", "p"}], 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox["x", "m"], 
      RowBox[{"Log", "[", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "]"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, {3.495161845931078*^9, 
   3.4951618787379355`*^9}, {3.495163638398227*^9, 3.495163646853442*^9}, 
   3.49516370254554*^9, {3.4952372597089596`*^9, 3.495237275898982*^9}, {
   3.4952373570290956`*^9, 3.4952373664991093`*^9}, {3.495237414719177*^9, 
   3.495237426199193*^9}, {3.4952374708892555`*^9, 3.4952374808392696`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"Log", "[", 
      RowBox[{"a_.", "*", 
       RowBox[{
        RowBox[{"Log", "[", 
         RowBox[{"b_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "]"}], "^", "p_."}]}], "]"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"a", "*", 
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"b", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}], "^", "p"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "-", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "*", 
       RowBox[{"p", "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "/", 
         RowBox[{"Log", "[", 
          RowBox[{"b", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m", ",", "n", ",", "p"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4951616675135646`*^9, 3.495163619631394*^9, 
   3.4952372087988887`*^9, 3.4952373332790627`*^9, 3.4952374023491597`*^9, 
   3.495237449129225*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"Log", "[", 
      FractionBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}]], "]"}], "m"], "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, {
   3.494172650949109*^9, 3.494172665319129*^9}, 3.4951614288955455`*^9, 
   3.4951617140016465`*^9, {3.495162187524878*^9, 3.495162197867696*^9}, 
   3.495162421681289*^9, 3.495163536311648*^9, 3.495237223218909*^9, 
   3.495237324859051*^9, 3.4952376151694574`*^9, 3.4952377964297113`*^9, 
   3.495237887909839*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"f", "[", 
     FractionBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}]], "]"}], "x"], "=", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"f", "[", 
       RowBox[{
        FractionBox["a", "c"], "+", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"b", " ", "c"}], "-", 
            RowBox[{"a", " ", "d"}]}], ")"}], " ", "x"}], 
         RowBox[{"c", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], ")"}]}]]}], "]"}], 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "c"}], "-", 
          RowBox[{"a", " ", "d"}]}], ")"}], " ", "x"}], 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}]]], 
     RowBox[{
      SubscriptBox["\[PartialD]", "x"], 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "c"}], "-", 
          RowBox[{"a", " ", "d"}]}], ")"}], " ", "x"}], 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}]]}]}], "-", 
    RowBox[{
     FractionBox[
      RowBox[{"f", "[", 
       RowBox[{
        FractionBox["b", "d"], "-", 
        FractionBox[
         RowBox[{
          RowBox[{"b", " ", "c"}], "-", 
          RowBox[{"a", " ", "d"}]}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], ")"}], " ", "d"}]]}], "]"}], 
      FractionBox[
       RowBox[{
        RowBox[{"b", " ", "c"}], "-", 
        RowBox[{"a", " ", "d"}]}], 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}]]], 
     RowBox[{
      SubscriptBox["\[PartialD]", "x"], 
      RowBox[{"(", 
       FractionBox[
        RowBox[{
         RowBox[{"b", " ", "c"}], "-", 
         RowBox[{"a", " ", "d"}]}], 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}]], ")"}]}]}]}]}]]]
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, {3.495162264932214*^9, 
   3.495162277318636*^9}, {3.4951637747120676`*^9, 3.495163775320469*^9}, {
   3.4951642488437004`*^9, 3.4951642509653044`*^9}, {3.4952359429371166`*^9, 
   3.495235964997147*^9}, {3.4952361839874535`*^9, 3.4952362099374905`*^9}, {
   3.495236384457734*^9, 3.4952364449378195`*^9}, {3.4952380492900653`*^9, 
   3.4952380558700743`*^9}, {3.4952387445210385`*^9, 3.4952387765610833`*^9}}],

Cell[TextData[{
 "Note: This linearizing substitution is valid for any function of ",
 Cell[BoxData[
  FractionBox[
   RowBox[{"a", "+", 
    RowBox[{"b", " ", "x"}]}], 
   RowBox[{"c", "+", 
    RowBox[{"d", " ", "x"}]}]]]],
 " over ",
 Cell[BoxData["x"]],
 "."
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, 3.495161586221822*^9, 3.4951636037349663`*^9, {
   3.4952378229197483`*^9, 3.495237858879799*^9}, {3.495237907669867*^9, 
   3.4952379355899057`*^9}, 3.4952379659499483`*^9, {3.495238084620115*^9, 
   3.4952380902201223`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"m", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"b", " ", "c"}], "-", 
     RowBox[{"a", " ", "d"}]}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, {3.495162264932214*^9, 
   3.495162277318636*^9}, {3.4951637747120676`*^9, 3.495163775320469*^9}, {
   3.4951642488437004`*^9, 3.4951642509653044`*^9}, {3.4952359429371166`*^9, 
   3.495235964997147*^9}, {3.4952361839874535`*^9, 3.4952362099374905`*^9}, {
   3.495236384457734*^9, 3.4952364449378195`*^9}, {3.4952380492900653`*^9, 
   3.4952380558700743`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"Log", "[", 
       FractionBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}]], "]"}], "m"], "x"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"Subst", "[", 
       RowBox[{
        RowBox[{"\[Integral]", 
         RowBox[{
          FractionBox[
           SuperscriptBox[
            RowBox[{"Log", "[", 
             RowBox[{
              FractionBox["a", "c"], "+", 
              FractionBox["x", "c"]}], "]"}], "m"], "x"], 
          RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"b", " ", "c"}], "-", 
            RowBox[{"a", " ", "d"}]}], ")"}], " ", "x"}], 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}]]}], "]"}]}]}]}]}], "-", 
  RowBox[{"Subst", "[", 
   RowBox[{
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       SuperscriptBox[
        RowBox[{"Log", "[", 
         RowBox[{
          FractionBox["b", "d"], "-", 
          FractionBox["x", "d"]}], "]"}], "m"], "x"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
    FractionBox[
     RowBox[{
      RowBox[{"b", " ", "c"}], "-", 
      RowBox[{"a", " ", "d"}]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}]]}], "]"}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, {3.495161845931078*^9, 
   3.4951618787379355`*^9}, {3.495163638398227*^9, 3.495163646853442*^9}, 
   3.49516370254554*^9, {3.4952372597089596`*^9, 3.495237275898982*^9}, {
   3.4952373570290956`*^9, 3.4952373664991093`*^9}, {3.495237741409634*^9, 
   3.495237787939699*^9}, {3.49523787421982*^9, 3.495237881949831*^9}, {
   3.4952388430911765`*^9, 3.495238851691189*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"c_", "+", 
          RowBox[{"d_.", "*", "x_"}]}], ")"}]}], "]"}], "^", "m_."}], "/", 
     "x_"}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Subst", "[", 
     RowBox[{
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{
            RowBox[{"a", "/", "c"}], "+", 
            RowBox[{"x", "/", "c"}]}], "]"}], "^", "m"}], "/", "x"}], ",", 
        "x"}], "]"}], ",", "x", ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "c"}], "-", 
         RowBox[{"a", "*", "d"}]}], ")"}], "*", 
       RowBox[{"x", "/", 
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], ")"}]}]}]}], "]"}], " ", "-", " ", "\n", 
    "  ", 
    RowBox[{"Subst", "[", 
     RowBox[{
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{
            RowBox[{"b", "/", "d"}], "-", 
            RowBox[{"x", "/", "d"}]}], "]"}], "^", "m"}], "/", "x"}], ",", 
        "x"}], "]"}], ",", "x", ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "c"}], "-", 
         RowBox[{"a", "*", "d"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], ")"}]}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "c"}], "-", 
      RowBox[{"a", "*", "d"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4951616675135646`*^9, 3.495163619631394*^9, 
   3.4952372087988887`*^9, 3.4952373332790627`*^9, 3.495237685579556*^9, {
   3.495238880421229*^9, 3.4952388851512356`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      RowBox[{"Log", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Log", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, {
   3.494172650949109*^9, 3.494172665319129*^9}, 3.4951614288955455`*^9, 
   3.4951617140016465`*^9, {3.495162187524878*^9, 3.495162197867696*^9}, 
   3.495162421681289*^9, 3.495163536311648*^9, 3.495237223218909*^9, 
   3.495237324859051*^9, 3.4952376151694574`*^9, 3.4952377964297113`*^9, 
   3.495237887909839*^9, 3.4952390066614056`*^9, 3.495239136751588*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.4952391970416718`*^9, 3.495239205041683*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"A", "+", 
     RowBox[{"B", " ", "z"}]}], 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "z"}]}]]], "=", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"b", " ", "A"}], "-", 
      RowBox[{"a", " ", "B"}]}], 
     RowBox[{"b", " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "z"}]}]]}]], "+", 
    FractionBox[
     RowBox[{"B", " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "z"}]}]]}], "b"]}]}]]]
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, {3.495162264932214*^9, 
   3.495162277318636*^9}, {3.4951637747120676`*^9, 3.495163775320469*^9}, {
   3.4951642488437004`*^9, 3.4951642509653044`*^9}, {3.4952359429371166`*^9, 
   3.495235964997147*^9}, {3.4952361839874535`*^9, 3.4952362099374905`*^9}, {
   3.495236384457734*^9, 3.4952364449378195`*^9}, {3.4952380492900653`*^9, 
   3.4952380558700743`*^9}, {3.4952387445210385`*^9, 3.4952387765610833`*^9}, 
   3.4952390250414314`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"b", " ", "A"}], "-", 
    RowBox[{"a", " ", "B"}]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, {3.495162264932214*^9, 
   3.495162277318636*^9}, {3.4951637747120676`*^9, 3.495163775320469*^9}, {
   3.4951642488437004`*^9, 3.4951642509653044`*^9}, {3.4952359429371166`*^9, 
   3.495235964997147*^9}, {3.4952361839874535`*^9, 3.4952362099374905`*^9}, {
   3.495236384457734*^9, 3.4952364449378195`*^9}, {3.4952380492900653`*^9, 
   3.4952380558700743`*^9}, {3.495239054151472*^9, 3.495239064841487*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Log", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        RowBox[{"b", " ", "A"}], "-", 
        RowBox[{"a", " ", "B"}]}], "b"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox["1", 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["B", "b"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, {3.495161845931078*^9, 
   3.4951618787379355`*^9}, {3.495163638398227*^9, 3.495163646853442*^9}, 
   3.49516370254554*^9, {3.4952372597089596`*^9, 3.495237275898982*^9}, {
   3.4952373570290956`*^9, 3.4952373664991093`*^9}, {3.495237741409634*^9, 
   3.495237787939699*^9}, {3.49523787421982*^9, 3.495237881949831*^9}, {
   3.4952388430911765`*^9, 3.495238851691189*^9}, {3.4952391074015465`*^9, 
   3.495239123391569*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "A"}], "-", 
         RowBox[{"a", "*", "B"}]}], ")"}], "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Log", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ",", "x"}], 
       "]"}]}], "]"}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"B", "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Log", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], ",", "x"}], "]"}]}],
      "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4951616675135646`*^9, 3.495163619631394*^9, 
   3.4952372087988887`*^9, 3.4952373332790627`*^9, 3.495237685579556*^9, {
   3.495238880421229*^9, 3.4952388851512356`*^9}, 3.495239034391444*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["f", 
    RowBox[{"a", " ", 
     RowBox[{"Log", "[", "u", "]"}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, {
   3.494172650949109*^9, 3.494172665319129*^9}, 3.4951614288955455`*^9, 
   3.4952392902418027`*^9, 3.4952394072719665`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9, 3.495239463392045*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["f", 
    RowBox[{"a", " ", 
     RowBox[{"Log", "[", "g", "]"}]}]], "=", 
   SuperscriptBox["g", 
    RowBox[{"a", " ", 
     RowBox[{"Log", "[", "f", "]"}]}]]}]]]
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, {3.495162264932214*^9, 
   3.495162277318636*^9}, {3.4951637747120676`*^9, 3.495163775320469*^9}, {
   3.4951642488437004`*^9, 3.4951642509653044`*^9}, {3.4952359429371166`*^9, 
   3.495235964997147*^9}, {3.4952361839874535`*^9, 3.4952362099374905`*^9}, {
   3.495236384457734*^9, 3.4952364449378195`*^9}, {3.4952380492900653`*^9, 
   3.4952380558700743`*^9}, {3.4952387445210385`*^9, 3.4952387765610833`*^9}, 
   3.4952390250414314`*^9, 3.4952394962920914`*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["f", 
    RowBox[{"a", " ", 
     RowBox[{"Log", "[", "u", "]"}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox["u", 
        RowBox[{"a", " ", 
         RowBox[{"Log", "[", "f", "]"}]}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, {3.495239339251871*^9, 
   3.495239350531887*^9}, {3.4952394302419987`*^9, 3.495239454572033*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"f_", "^", 
     RowBox[{"(", 
      RowBox[{"a_.", "*", 
       RowBox[{"Log", "[", "u_", "]"}]}], ")"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"u", "^", 
      RowBox[{"(", 
       RowBox[{"a", "*", 
        RowBox[{"Log", "[", "f", "]"}]}], ")"}]}], ",", "x"}], "]"}], " ", "/;",
    "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "f"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4952393044318223`*^9, 3.4952394143619766`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"f", "[", 
     RowBox[{"Log", "[", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "n"]}], "]"}], "]"}], "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, {
   3.494172650949109*^9, 3.494172665319129*^9}, 3.4951614288955455`*^9, 
   3.4952392902418027`*^9, 3.4952394072719665`*^9, 3.4952395982522335`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9, 3.495239463392045*^9, 
  3.4952396299322777`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"f", "[", 
     RowBox[{"Log", "[", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "n"]}], "]"}], "]"}], "x"], "=", 
   RowBox[{
    FractionBox["1", "n"], " ", 
    RowBox[{"f", "[", 
     RowBox[{"Log", "[", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "n"]}], "]"}], "]"}], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", "x"], 
     RowBox[{"Log", "[", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "n"]}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, {3.495162264932214*^9, 
   3.495162277318636*^9}, {3.4951637747120676`*^9, 3.495163775320469*^9}, {
   3.4951642488437004`*^9, 3.4951642509653044`*^9}, {3.4952359429371166`*^9, 
   3.495235964997147*^9}, {3.4952361839874535`*^9, 3.4952362099374905`*^9}, {
   3.495236384457734*^9, 3.4952364449378195`*^9}, {3.4952380492900653`*^9, 
   3.4952380558700743`*^9}, {3.4952387445210385`*^9, 3.4952387765610833`*^9}, 
   3.4952390250414314`*^9, 3.4952394962920914`*^9, {3.4952399483627243`*^9, 
   3.495239951952729*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"f", "[", 
     RowBox[{"Log", "[", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "n"]}], "]"}], "]"}], "x"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "n"]}]}], " ", 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       RowBox[{"f", "[", "x", "]"}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"Log", "[", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "n"]}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, {3.495239339251871*^9, 
   3.495239350531887*^9}, {3.4952394302419987`*^9, 3.495239454572033*^9}, 
   3.495239646122301*^9, 3.495239704912383*^9, {3.495239871962617*^9, 
   3.4952398794526277`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"u_", "/", "x_"}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
    "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"lst", "=", 
         RowBox[{"FunctionOfLog", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"ShowStep", "[", 
         RowBox[{
         "\"\<\>\"", ",", "\"\<Int[f[Log[a*x^n]]/x,x]\>\"", ",", 
          "\"\<Subst[Int[f[x],x],x,Log[a*x^n]]/n\>\"", ",", 
          RowBox[{"Hold", "[", "\n", "  ", 
           RowBox[{"Dist", "[", 
            RowBox[{
             RowBox[{"1", "/", 
              RowBox[{"lst", "[", 
               RowBox[{"[", "3", "]"}], "]"}]}], ",", 
             RowBox[{"Subst", "[", 
              RowBox[{
               RowBox[{"Int", "[", 
                RowBox[{
                 RowBox[{"lst", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", "x",
                ",", 
               RowBox[{"Log", "[", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "]"}]}], "]"}], 
           "]"}]}], "]"}], " ", "/;", "\n", " ", 
        RowBox[{"Not", "[", 
         RowBox[{"FalseQ", "[", "lst", "]"}], "]"}]}]}], "]"}], " ", "/;", 
     "\n", 
     RowBox[{"SimplifyFlag", " ", "&&", " ", 
      RowBox[{"NonsumQ", "[", "u", "]"}]}]}]}], ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"u_", "/", "x_"}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
    "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"lst", "=", 
         RowBox[{"FunctionOfLog", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"Dist", "[", 
         RowBox[{
          RowBox[{"1", "/", 
           RowBox[{"lst", "[", 
            RowBox[{"[", "3", "]"}], "]"}]}], ",", 
          RowBox[{"Subst", "[", 
           RowBox[{
            RowBox[{"Int", "[", 
             RowBox[{
              RowBox[{"lst", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", "x", 
            ",", 
            RowBox[{"Log", "[", 
             RowBox[{"lst", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "]"}]}], "]"}], " ", "/;",
         "\n", " ", 
        RowBox[{"Not", "[", 
         RowBox[{"FalseQ", "[", "lst", "]"}], "]"}]}]}], "]"}], " ", "/;", 
     "\n", 
     RowBox[{"NonsumQ", "[", "u", "]"}]}]}]}], "]"}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4952393044318223`*^9, 3.4952394143619766`*^9, 
   3.495239617532261*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, 3.495239463392045*^9, 3.4952396299322777`*^9, {
   3.4952421411757936`*^9, 3.495242146505801*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"a", " ", "x"}], "+", 
     RowBox[{"b", " ", "x", " ", "z"}]}]], "=", 
   FractionBox["1", 
    RowBox[{"x", " ", 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "z"}]}], ")"}]}]]}]]]
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495162076203082*^9, 3.495162102707529*^9}, {3.495162264932214*^9, 
   3.495162277318636*^9}, {3.4951637747120676`*^9, 3.495163775320469*^9}, {
   3.4951642488437004`*^9, 3.4951642509653044`*^9}, {3.4952359429371166`*^9, 
   3.495235964997147*^9}, {3.4952361839874535`*^9, 3.4952362099374905`*^9}, {
   3.495236384457734*^9, 3.4952364449378195`*^9}, {3.4952380492900653`*^9, 
   3.4952380558700743`*^9}, {3.4952387445210385`*^9, 3.4952387765610833`*^9}, 
   3.4952390250414314`*^9, 3.4952394962920914`*^9, {3.4952399483627243`*^9, 
   3.495239951952729*^9}, {3.495242154015812*^9, 3.495242208345888*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"a", " ", "x"}], "+", 
     RowBox[{"b", " ", "x", " ", 
      SuperscriptBox[
       RowBox[{"Log", "[", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "n"]}], "]"}], "m"]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"x", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox[
             RowBox[{"Log", "[", 
              RowBox[{"c", " ", 
               SuperscriptBox["x", "n"]}], "]"}], "m"]}]}], ")"}]}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, {3.495239339251871*^9, 
   3.495239350531887*^9}, {3.4952394302419987`*^9, 3.495239454572033*^9}, 
   3.495239646122301*^9, 3.495239704912383*^9, {3.495239871962617*^9, 
   3.4952398794526277`*^9}, {3.4952422523659496`*^9, 3.4952423349660654`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a_.", "*", "x_"}], "+", 
       RowBox[{"b_.", "*", "x_", "*", 
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"c_.", "*", 
           RowBox[{"x_", "^", "n_."}]}], "]"}], "^", "m_."}]}]}], ")"}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"x", "*", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{
            RowBox[{"Log", "[", 
             RowBox[{"c", "*", 
              RowBox[{"x", "^", "n"}]}], "]"}], "^", "m"}]}]}], ")"}]}], 
       ")"}]}], ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "m", ",", "n"}], "}"}], ",", 
     "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4952393044318223`*^9, 3.4952394143619766`*^9, 
   3.495239617532261*^9, {3.49524011701296*^9, 3.49524020274308*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["f", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, {
   3.494172650949109*^9, 3.494172665319129*^9}, 3.4951614288955455`*^9, 
   3.4952392902418027`*^9, 3.4952394072719665`*^9, 3.4953868024247255`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Primitive rule", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, 3.495239463392045*^9, 3.4953865477243686`*^9, {
   3.4953908555803995`*^9, 3.495390858110403*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      RowBox[{
       RowBox[{"-", "c"}], " ", 
       SuperscriptBox["\[ExponentialE]", "x"]}]}], "]"}]}], "=", 
   RowBox[{"-", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["\[ExponentialE]", "x"]}]}], "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, 3.495239463392045*^9, 3.4953865477243686`*^9, {
   3.4953908555803995`*^9, 3.495390858110403*^9}, {3.4953909569505415`*^9, 
   3.495391006480611*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["f", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"PolyLog", "[", 
        RowBox[{"2", ",", 
         RowBox[{
          RowBox[{"-", "c"}], " ", 
          SuperscriptBox["f", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}]]}]}], "]"}], 
       RowBox[{"b", " ", 
        RowBox[{"Log", "[", "f", "]"}]}]]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, {3.495239339251871*^9, 
   3.495239350531887*^9}, {3.4952394302419987`*^9, 3.495239454572033*^9}, {
   3.4953865698143997`*^9, 3.495386581114415*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      RowBox[{"c_.", "*", 
       RowBox[{"f_", "^", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}]}]}]}], "]"}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"PolyLog", "[", 
      RowBox[{"2", ",", 
       RowBox[{
        RowBox[{"-", "c"}], "*", 
        RowBox[{"f", "^", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}]}]}]}], "]"}]}], "/", 
    RowBox[{"(", 
     RowBox[{"b", "*", 
      RowBox[{"Log", "[", "f", "]"}]}], ")"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "f"}], "}"}], ",", "x"}], 
    "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4952393044318223`*^9, 3.4952394143619766`*^9, 
   3.4953865426843615`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9, 3.495239463392045*^9, 
  3.4953865477243686`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    RowBox[{"Log", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       RowBox[{"g", "[", "x", "]"}]}]}], "]"}]}], "=", 
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"d", " ", 
        RowBox[{"g", "[", "x", "]"}]}], "c"]}], "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, 3.495239463392045*^9, 3.4953865477243686`*^9, {
   3.495386769544679*^9, 3.4953867761846886`*^9}}],

Cell[TextData[{
 "Rule: If ",
 Cell[BoxData[
  RowBox[{"c", "\[NotEqual]", "1"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.4953866418245*^9, 3.495386663524531*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["f", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}]]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "x"}]}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["f", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}]]}]}], "]"}]}]}], "-", 
  RowBox[{"x", " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", 
     FractionBox[
      RowBox[{"d", " ", 
       SuperscriptBox["f", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}]]}], "c"]}], "]"}]}], "+", 
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"d", " ", 
        SuperscriptBox["f", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}]]}], "c"]}], "]"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, {3.495239339251871*^9, 
   3.495239350531887*^9}, {3.4952394302419987`*^9, 3.495239454572033*^9}, {
   3.4953865698143997`*^9, 3.495386581114415*^9}, {3.495386717414606*^9, 
   3.4953867297146235`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"c_", "+", 
      RowBox[{"d_.", "*", 
       RowBox[{"f_", "^", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}]}]}]}], "]"}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{"Log", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", 
        RowBox[{"f", "^", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}]}]}]}], "]"}]}], " ", "-", " ", 
    RowBox[{"x", "*", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       RowBox[{
        RowBox[{"d", "/", "c"}], "*", 
        RowBox[{"f", "^", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}]}]}]}], "]"}]}], " ", "+", "\n", 
    "  ", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"1", "+", 
        RowBox[{
         RowBox[{"d", "/", "c"}], "*", 
         RowBox[{"f", "^", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}]}]}]}], "]"}], ",", "x"}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "f"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"c", "-", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4952393044318223`*^9, 3.4952394143619766`*^9, 
   3.4953865426843615`*^9, 3.495386629754483*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["f", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, {
   3.494172650949109*^9, 3.494172665319129*^9}, 3.4951614288955455`*^9, 
   3.4952392902418027`*^9, 3.4952394072719665`*^9, 3.4953868024247255`*^9, 
   3.495386974644966*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9, 3.495239463392045*^9, 
  3.4953865477243686`*^9}],

Cell[TextData[{
 "Rule: If ",
 Cell[BoxData[
  RowBox[{"m", ">", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.4953866418245*^9, 3.495386663524531*^9}, {3.495386858794804*^9, 
   3.495386859444805*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["f", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}]]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox["x", "m"], " ", 
         RowBox[{"PolyLog", "[", 
          RowBox[{"2", ",", 
           RowBox[{
            RowBox[{"-", "c"}], " ", 
            SuperscriptBox["f", 
             RowBox[{"a", "+", 
              RowBox[{"b", " ", "x"}]}]]}]}], "]"}]}], 
        RowBox[{"b", " ", 
         RowBox[{"Log", "[", "f", "]"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["m", 
    RowBox[{"b", " ", 
     RowBox[{"Log", "[", "f", "]"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "1"}]], " ", 
     RowBox[{"PolyLog", "[", 
      RowBox[{"2", ",", 
       RowBox[{
        RowBox[{"-", "c"}], " ", 
        SuperscriptBox["f", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}]]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, {3.495239339251871*^9, 
   3.495239350531887*^9}, {3.4952394302419987`*^9, 3.495239454572033*^9}, {
   3.4953865698143997`*^9, 3.495386581114415*^9}, {3.4953868847048407`*^9, 
   3.4953868929348516`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"f_", "^", 
         RowBox[{"(", 
          RowBox[{"a_.", "+", 
           RowBox[{"b_.", "*", "x_"}]}], ")"}]}]}]}], "]"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"x", "^", "m"}]}], "*", 
     RowBox[{
      RowBox[{"PolyLog", "[", 
       RowBox[{"2", ",", 
        RowBox[{
         RowBox[{"-", "c"}], "*", 
         RowBox[{"f", "^", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}]}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"Log", "[", "f", "]"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"m", "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{"Log", "[", "f", "]"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{"PolyLog", "[", 
          RowBox[{"2", ",", 
           RowBox[{
            RowBox[{"-", "c"}], "*", 
            RowBox[{"f", "^", 
             RowBox[{"(", 
              RowBox[{"a", "+", 
               RowBox[{"b", "*", "x"}]}], ")"}]}]}]}], "]"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "f"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4952393044318223`*^9, 3.4952394143619766`*^9, 
   3.4953865426843615`*^9, 3.495386839394777*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9, 3.495239463392045*^9, 
  3.4953865477243686`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    RowBox[{"Log", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       RowBox[{"g", "[", "x", "]"}]}]}], "]"}]}], "=", 
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"d", " ", 
        RowBox[{"g", "[", "x", "]"}]}], "c"]}], "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, 3.495239463392045*^9, 3.4953865477243686`*^9, {
   3.495386769544679*^9, 3.4953867761846886`*^9}}],

Cell[TextData[{
 "Rule: If ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"c", "\[NotEqual]", "1"}], " ", "\[And]", " ", 
   RowBox[{"m", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.4953866418245*^9, 3.495386663524531*^9}, {3.495386929314903*^9, 
   3.49538694154492*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["f", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}]]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        RowBox[{"Log", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", 
           SuperscriptBox["f", 
            RowBox[{"a", "+", 
             RowBox[{"b", " ", "x"}]}]]}]}], "]"}]}], 
       RowBox[{"m", "+", "1"}]]}]}]}]}], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["x", 
     RowBox[{"m", "+", "1"}]], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"d", " ", 
        SuperscriptBox["f", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}]]}], "c"]}], "]"}]}], 
   RowBox[{"m", "+", "1"}]], "+", 
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"d", " ", 
        SuperscriptBox["f", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}]]}], "c"]}], "]"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, {3.495239339251871*^9, 
   3.495239350531887*^9}, {3.4952394302419987`*^9, 3.495239454572033*^9}, {
   3.4953865698143997`*^9, 3.495386581114415*^9}, {3.495386717414606*^9, 
   3.4953867297146235`*^9}, {3.495386961664948*^9, 3.4953869697949595`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"Log", "[", 
      RowBox[{"c_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"f_", "^", 
         RowBox[{"(", 
          RowBox[{"a_.", "+", 
           RowBox[{"b_.", "*", "x_"}]}], ")"}]}]}]}], "]"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"f", "^", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}]}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "-", " ", 
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"1", "+", 
        RowBox[{
         RowBox[{"d", "/", "c"}], "*", 
         RowBox[{"f", "^", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}]}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "m"}], "*", 
       RowBox[{"Log", "[", 
        RowBox[{"1", "+", 
         RowBox[{
          RowBox[{"d", "/", "c"}], "*", 
          RowBox[{"f", "^", 
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", "x"}]}], ")"}]}]}]}], "]"}]}], ",", "x"}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "f"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"c", "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.4952393044318223`*^9, 3.4952394143619766`*^9, 
   3.4953865426843615`*^9, 3.495386629754483*^9, 3.4953869214048915`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Log", "[", "u", "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, {
   3.494172650949109*^9, 3.494172665319129*^9}, 3.4951614288955455`*^9, 
   3.4952392902418027`*^9, 3.4952394072719665`*^9, 3.4952424378562093`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: A&S 4.1.53", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4940010628073196`*^9, 3.4941723607787027`*^9, 3.4941724567488375`*^9, 
   3.494172696119172*^9, 3.4951614417343683`*^9, 3.4952424973362923`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If ",
 Cell[BoxData["u"]],
 " is an algebraic function of ",
 Cell[BoxData["x"]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494172783029294*^9, {
   3.495242532336342*^9, 3.4952425579363775`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"Log", "[", "u", "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "x"}]}], " ", 
    RowBox[{"Log", "[", "u", "]"}]}]}], "-", 
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"x", " ", 
      RowBox[{
       SubscriptBox["\[PartialD]", "x"], "u"}]}], "u"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4941727384192314`*^9, 3.494172760679263*^9}, {
   3.495161485476845*^9, 3.4951615041032777`*^9}, {3.4952425698763943`*^9, 
   3.495242590506423*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Log", "[", "u_", "]"}], ",", "x_Symbol"}], "]"}], " ", ":=", 
  "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{"Log", "[", "u", "]"}]}], " ", "-", "\n", "  ", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"Regularize", "[", 
       RowBox[{
        RowBox[{"x", "*", 
         RowBox[{
          RowBox[{"D", "[", 
           RowBox[{"u", ",", "x"}], "]"}], "/", "u"}]}], ",", "x"}], "]"}], 
      ",", "x"}], "]"}]}], " ", "/;", "\n", 
   RowBox[{"AlgebraicFunctionQ", "[", 
    RowBox[{"u", ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494172717389202*^9, 
   3.495161451843186*^9, 3.495242525276332*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]]
},
AutoGeneratedPackage->Automatic,
CellGrouping->Manual,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  "Integration Rules for Logarithm Functions", None, None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->28.8},
Magnification->1.399999976158142,
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 1305, 29, 118, "Title"],
Cell[1875, 53, 334, 5, 692, "Subsubsection"],
Cell[2212, 60, 150, 2, 475, "Subsubsection"],
Cell[2365, 64, 806, 11, 475, "Subsubsection"],
Cell[3174, 77, 2154, 49, 1300, "Subsubtitle"],
Cell[5331, 128, 795, 11, 692, "Subsubsection"],
Cell[6129, 141, 1499, 42, 2113, "Code"],
Cell[7631, 185, 113, 2, 692, "Subsubsection"],
Cell[7747, 189, 310, 5, 475, "Subsubsection"],
Cell[8060, 196, 101, 1, 475, "Subsubsection"],
Cell[8164, 199, 955, 17, 510, "Subsubsection"],
Cell[9122, 218, 2528, 62, 1374, "Subsubtitle"],
Cell[11653, 282, 795, 11, 692, "Subsubsection"],
Cell[12451, 295, 2225, 63, 2634, "Code"],
Cell[14679, 360, 113, 2, 692, "Subsubsection"],
Cell[14795, 364, 310, 5, 475, "Subsubsection"],
Cell[15108, 371, 101, 1, 475, "Subsubsection"],
Cell[15212, 374, 1058, 20, 510, "Subsubsection"],
Cell[16273, 396, 2618, 63, 1374, "Subsubtitle"],
Cell[18894, 461, 795, 11, 692, "Subsubsection"],
Cell[19692, 474, 2369, 66, 2634, "Code"]
}, Closed]],
Cell[CellGroupData[{
Cell[22098, 545, 1381, 30, 80, "Title"],
Cell[23482, 577, 352, 5, 692, "Subsubsection"],
Cell[23837, 584, 362, 5, 475, "Subsubsection"],
Cell[24202, 591, 601, 15, 771, "Subsubsection"],
Cell[24806, 608, 806, 11, 475, "Subsubsection"],
Cell[25615, 621, 1788, 37, 1250, "Subsubtitle"],
Cell[27406, 660, 795, 11, 692, "Subsubsection"],
Cell[28204, 673, 1057, 29, 2113, "Code"],
Cell[29264, 704, 113, 2, 692, "Subsubsection"],
Cell[29380, 708, 362, 5, 475, "Subsubsection"],
Cell[29745, 715, 635, 15, 790, "Subsubsection"],
Cell[30383, 732, 806, 11, 475, "Subsubsection"],
Cell[31192, 745, 2644, 62, 1923, "Subsubtitle"],
Cell[33839, 809, 795, 11, 692, "Subsubsection"],
Cell[34637, 822, 2098, 61, 2113, "Code"],
Cell[36738, 885, 113, 2, 692, "Subsubsection"],
Cell[36854, 889, 1085, 20, 510, "Subsubsection"],
Cell[37942, 911, 2768, 67, 2113, "Subsubtitle"],
Cell[40713, 980, 795, 11, 692, "Subsubsection"],
Cell[41511, 993, 2478, 71, 2634, "Code"],
Cell[43992, 1066, 113, 2, 692, "Subsubsection"],
Cell[44108, 1070, 1181, 22, 510, "Subsubsection"],
Cell[45292, 1094, 2852, 70, 2113, "Subsubtitle"],
Cell[48147, 1166, 795, 11, 692, "Subsubsection"],
Cell[48945, 1179, 2576, 74, 2634, "Code"],
Cell[51524, 1255, 113, 2, 692, "Subsubsection"],
Cell[51640, 1259, 437, 6, 475, "Subsubsection"],
Cell[52080, 1267, 396, 6, 475, "Subsubsection"],
Cell[52479, 1275, 1160, 20, 510, "Subsubsection"],
Cell[53642, 1297, 2880, 68, 1300, "Subsubtitle"],
Cell[56525, 1367, 795, 11, 692, "Subsubsection"],
Cell[57323, 1380, 2433, 68, 2634, "Code"],
Cell[59759, 1450, 113, 2, 692, "Subsubsection"],
Cell[59875, 1454, 429, 6, 475, "Subsubsection"],
Cell[60307, 1462, 1233, 22, 510, "Subsubsection"],
Cell[61543, 1486, 3512, 82, 2431, "Subsubtitle"],
Cell[65058, 1570, 795, 11, 692, "Subsubsection"],
Cell[65856, 1583, 2690, 78, 2634, "Code"],
Cell[68549, 1663, 113, 2, 692, "Subsubsection"],
Cell[68665, 1667, 429, 6, 475, "Subsubsection"],
Cell[69097, 1675, 1313, 22, 510, "Subsubsection"],
Cell[70413, 1699, 3756, 92, 2074, "Subsubtitle"],
Cell[74172, 1793, 795, 11, 692, "Subsubsection"],
Cell[74970, 1806, 3484, 100, 2634, "Code"],
Cell[78457, 1908, 44, 1, 51, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[78538, 1914, 1246, 27, 80, "Title"],
Cell[79787, 1943, 334, 5, 1896, "Subsubsection"],
Cell[80124, 1950, 362, 5, 1300, "Subsubsection"],
Cell[80489, 1957, 669, 19, 2020, "Subsubsection"],
Cell[81161, 1978, 806, 11, 1300, "Subsubsection"],
Cell[81970, 1991, 1704, 35, 3564, "Subsubtitle"],
Cell[83677, 2028, 795, 11, 1896, "Subsubsection"],
Cell[84475, 2041, 958, 27, 5797, "Code"],
Cell[85436, 2070, 113, 2, 1896, "Subsubsection"],
Cell[85552, 2074, 136, 1, 1300, "Subsubsection"],
Cell[85691, 2077, 409, 15, 1397, "Subsubsection"],
Cell[86103, 2094, 1033, 19, 1397, "Subsubsection"],
Cell[87139, 2115, 1927, 43, 4555, "Subsubtitle"],
Cell[89069, 2160, 795, 11, 1896, "Subsubsection"],
Cell[89867, 2173, 1418, 40, 7225, "Code"],
Cell[91288, 2215, 113, 2, 1896, "Subsubsection"],
Cell[91404, 2219, 101, 1, 1300, "Subsubsection"],
Cell[91508, 2222, 908, 13, 1300, "Subsubsection"],
Cell[92419, 2237, 2534, 62, 4555, "Subsubtitle"],
Cell[94956, 2301, 795, 11, 1896, "Subsubsection"],
Cell[95754, 2314, 2055, 61, 7225, "Code"],
Cell[97812, 2377, 113, 2, 1896, "Subsubsection"],
Cell[97928, 2381, 378, 5, 1300, "Subsubsection"],
Cell[98309, 2388, 1095, 20, 1397, "Subsubsection"],
Cell[99407, 2410, 2205, 50, 3830, "Subsubtitle"],
Cell[101615, 2462, 795, 11, 1896, "Subsubsection"],
Cell[102413, 2475, 1757, 50, 5797, "Code"],
Cell[104173, 2527, 113, 2, 1896, "Subsubsection"],
Cell[104289, 2531, 406, 6, 1300, "Subsubsection"],
Cell[104698, 2539, 1254, 23, 1397, "Subsubsection"],
Cell[105955, 2564, 2508, 59, 3670, "Subsubtitle"],
Cell[108466, 2625, 795, 11, 1896, "Subsubsection"],
Cell[109264, 2638, 2256, 64, 7225, "Code"],
Cell[111523, 2704, 44, 1, 138, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[111604, 2710, 1368, 30, 80, "Title"],
Cell[112975, 2742, 1143, 20, 28827, "Subsubsection"],
Cell[114121, 2764, 2588, 61, 73604, "Subsubtitle"],
Cell[116712, 2827, 795, 11, 27957, "Subsubsection"],
Cell[117510, 2840, 2149, 64, 85525, "Code"],
Cell[119662, 2906, 113, 2, 27957, "Subsubsection"],
Cell[119778, 2910, 1332, 26, 31169, "Subsubsection"],
Cell[121113, 2938, 2765, 67, 106600, "Subsubtitle"],
Cell[123881, 3007, 795, 11, 27957, "Subsubsection"],
Cell[124679, 3020, 2758, 82, 106600, "Code"],
Cell[127440, 3104, 113, 2, 27957, "Subsubsection"],
Cell[127556, 3108, 1441, 29, 31169, "Subsubsection"],
Cell[129000, 3139, 2846, 70, 106600, "Subsubtitle"],
Cell[131849, 3211, 795, 11, 27957, "Subsubsection"],
Cell[132647, 3224, 2837, 84, 106600, "Code"],
Cell[135487, 3310, 113, 2, 27957, "Subsubsection"],
Cell[135603, 3314, 477, 7, 19161, "Subsubsection"],
Cell[136083, 3323, 396, 6, 19161, "Subsubsection"],
Cell[136482, 3331, 1354, 24, 20591, "Subsubsection"],
Cell[137839, 3357, 2689, 63, 50546, "Subsubtitle"],
Cell[140531, 3422, 795, 11, 27957, "Subsubsection"],
Cell[141329, 3435, 2368, 67, 106600, "Code"],
Cell[143700, 3504, 113, 2, 27957, "Subsubsection"],
Cell[143816, 3508, 489, 7, 19161, "Subsubsection"],
Cell[144308, 3517, 427, 6, 19161, "Subsubsection"],
Cell[144738, 3525, 1426, 26, 20591, "Subsubsection"],
Cell[146167, 3553, 2689, 63, 50546, "Subsubtitle"],
Cell[148859, 3618, 795, 11, 27957, "Subsubsection"],
Cell[149657, 3631, 2655, 76, 106600, "Code"],
Cell[152315, 3709, 113, 2, 27957, "Subsubsection"],
Cell[152431, 3713, 1394, 24, 20591, "Subsubsection"],
Cell[153828, 3739, 3674, 90, 82199, "Subsubtitle"],
Cell[157505, 3831, 795, 11, 27957, "Subsubsection"],
Cell[158303, 3844, 3252, 96, 106600, "Code"],
Cell[161558, 3942, 113, 2, 27957, "Subsubsection"],
Cell[161674, 3946, 1389, 19, 19161, "Subsubsection"],
Cell[163066, 3967, 1307, 18, 19161, "Subsubsection"],
Cell[164376, 3987, 2435, 52, 41939, "Subsubtitle"],
Cell[166814, 4041, 795, 11, 27957, "Subsubsection"],
Cell[167612, 4054, 1685, 46, 85525, "Code"],
Cell[169300, 4102, 113, 2, 27957, "Subsubsection"],
Cell[169416, 4106, 1307, 18, 19161, "Subsubsection"],
Cell[170726, 4126, 2712, 60, 41939, "Subsubtitle"],
Cell[173441, 4188, 795, 11, 27957, "Subsubsection"],
Cell[174239, 4201, 1966, 54, 85525, "Code"],
Cell[176208, 4257, 113, 2, 27957, "Subsubsection"],
Cell[176324, 4261, 1394, 24, 20591, "Subsubsection"],
Cell[177721, 4287, 2608, 55, 41939, "Subsubtitle"],
Cell[180332, 4344, 795, 11, 27957, "Subsubsection"],
Cell[181130, 4357, 2284, 64, 85525, "Code"],
Cell[183417, 4423, 113, 2, 27957, "Subsubsection"],
Cell[183533, 4427, 1394, 24, 20591, "Subsubsection"],
Cell[184930, 4453, 2887, 63, 41939, "Subsubtitle"],
Cell[187820, 4518, 795, 11, 27957, "Subsubsection"],
Cell[188618, 4531, 2683, 76, 85525, "Code"],
Cell[191304, 4609, 44, 1, 2020, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[191385, 4615, 1274, 28, 80, "Title"],
Cell[192662, 4645, 1124, 21, 187, "Subsubsection"],
Cell[193789, 4668, 806, 11, 125, "Subsubsection"],
Cell[194598, 4681, 3285, 85, 655, "Subsubtitle"],
Cell[197886, 4768, 795, 11, 181, "Subsubsection"],
Cell[198684, 4781, 3010, 92, 820, "Code"],
Cell[201697, 4875, 113, 2, 181, "Subsubsection"],
Cell[201813, 4879, 1063, 19, 134, "Subsubsection"],
Cell[202879, 4900, 2561, 63, 354, "Subsubtitle"],
Cell[205443, 4965, 795, 11, 181, "Subsubsection"],
Cell[206241, 4978, 2118, 64, 687, "Code"],
Cell[208362, 5044, 113, 2, 181, "Subsubsection"],
Cell[208478, 5048, 1273, 24, 134, "Subsubsection"],
Cell[209754, 5074, 3561, 92, 673, "Subsubtitle"],
Cell[213318, 5168, 795, 11, 181, "Subsubsection"],
Cell[214116, 5181, 3448, 105, 820, "Code"],
Cell[217567, 5288, 113, 2, 181, "Subsubsection"],
Cell[217683, 5292, 1464, 28, 134, "Subsubsection"],
Cell[219150, 5322, 2261, 51, 310, "Subsubtitle"],
Cell[221414, 5375, 795, 11, 181, "Subsubsection"],
Cell[222212, 5388, 1975, 54, 551, "Code"],
Cell[224190, 5444, 44, 1, 15, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[224271, 5450, 1323, 31, 93, "Title"],
Cell[225597, 5483, 285, 4, 35, "Subsubsection"],
Cell[225885, 5489, 117, 1, 25, "Subsubsection"],
Cell[226005, 5492, 635, 22, 40, "Subsubsection"],
Cell[226643, 5516, 960, 19, 26, "Subsubsection"],
Cell[227606, 5537, 1696, 38, 60, "Subsubtitle"],
Cell[229305, 5577, 795, 11, 35, "Subsubsection"],
Cell[230103, 5590, 1274, 37, 104, "Code"],
Cell[231380, 5629, 113, 2, 35, "Subsubsection"],
Cell[231496, 5633, 101, 1, 25, "Subsubsection"],
Cell[231600, 5636, 991, 20, 26, "Subsubsection"],
Cell[232594, 5658, 2354, 61, 66, "Subsubtitle"],
Cell[234951, 5721, 795, 11, 35, "Subsubsection"],
Cell[235749, 5734, 2108, 65, 129, "Code"],
Cell[237860, 5801, 113, 2, 67, "Subsubsection"],
Cell[237976, 5805, 101, 1, 47, "Subsubsection"],
Cell[238080, 5808, 1105, 22, 50, "Subsubsection"],
Cell[239188, 5832, 3064, 79, 285, "Subsubtitle"],
Cell[242255, 5913, 795, 11, 67, "Subsubsection"],
Cell[243053, 5926, 2930, 88, 251, "Code"],
Cell[245986, 6016, 113, 2, 67, "Subsubsection"],
Cell[246102, 6020, 326, 11, 50, "Subsubsection"],
Cell[246431, 6033, 1391, 31, 26, "Subsubsection"],
Cell[247825, 6066, 3404, 86, 130, "Subsubtitle"],
Cell[251232, 6154, 795, 11, 35, "Subsubsection"],
Cell[252030, 6167, 3294, 97, 154, "Code"],
Cell[255327, 6266, 113, 2, 35, "Subsubsection"],
Cell[255443, 6270, 1351, 29, 26, "Subsubsection"],
Cell[256797, 6301, 3389, 85, 130, "Subsubtitle"],
Cell[260189, 6388, 795, 11, 35, "Subsubsection"],
Cell[260987, 6401, 3194, 95, 129, "Code"],
Cell[264184, 6498, 113, 2, 35, "Subsubsection"],
Cell[264300, 6502, 101, 1, 25, "Subsubsection"],
Cell[264404, 6505, 1203, 24, 26, "Subsubsection"],
Cell[265610, 6531, 732, 10, 25, "Subsubsection"],
Cell[266345, 6543, 3117, 80, 119, "Subsubtitle"],
Cell[269465, 6625, 795, 11, 35, "Subsubsection"],
Cell[270263, 6638, 3134, 90, 129, "Code"],
Cell[273400, 6730, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[273481, 6736, 1295, 28, 80, "Title"],
Cell[274779, 6766, 1642, 34, 326, "Subsubsection"],
Cell[276424, 6802, 1203, 21, 134, "Subsubsection"],
Cell[277630, 6825, 2530, 61, 433, "Subsubtitle"],
Cell[280163, 6888, 795, 11, 181, "Subsubsection"],
Cell[280961, 6901, 1959, 57, 687, "Code"],
Cell[282923, 6960, 113, 2, 181, "Subsubsection"],
Cell[283039, 6964, 1012, 14, 125, "Subsubsection"],
Cell[284054, 6980, 6194, 191, 1968, "Subsubtitle"],
Cell[290251, 7173, 795, 11, 181, "Subsubsection"],
Cell[291049, 7186, 6702, 191, 2164, "Code"],
Cell[297754, 7379, 44, 1, 15, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[297835, 7385, 1281, 28, 80, "Title"],
Cell[299119, 7415, 150, 2, 181, "Subsubsection"],
Cell[299272, 7419, 806, 11, 125, "Subsubsection"],
Cell[300081, 7432, 3296, 83, 624, "Subsubtitle"],
Cell[303380, 7517, 795, 11, 181, "Subsubsection"],
Cell[304178, 7530, 2743, 80, 820, "Code"],
Cell[306924, 7612, 44, 1, 15, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[307005, 7618, 1271, 27, 80, "Title"],
Cell[308279, 7647, 150, 2, 27957, "Subsubsection"],
Cell[308432, 7651, 806, 11, 19161, "Subsubsection"],
Cell[309241, 7664, 2047, 45, 54794, "Subsubtitle"],
Cell[311291, 7711, 795, 11, 27957, "Subsubsection"],
Cell[312089, 7724, 1403, 41, 106600, "Code"],
Cell[313495, 7767, 113, 2, 27957, "Subsubsection"],
Cell[313611, 7771, 150, 2, 19161, "Subsubsection"],
Cell[313764, 7775, 806, 11, 19161, "Subsubsection"],
Cell[314573, 7788, 2119, 47, 52575, "Subsubtitle"],
Cell[316695, 7837, 795, 11, 27957, "Subsubsection"],
Cell[317493, 7850, 1331, 38, 85525, "Code"],
Cell[318827, 7890, 113, 2, 27957, "Subsubsection"],
Cell[318943, 7894, 150, 2, 19161, "Subsubsection"],
Cell[319096, 7898, 1143, 20, 20591, "Subsubsection"],
Cell[320242, 7920, 2428, 56, 59957, "Subsubtitle"],
Cell[322673, 7978, 795, 11, 27957, "Subsubsection"],
Cell[323471, 7991, 1907, 56, 106600, "Code"],
Cell[325381, 8049, 44, 1, 2020, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[325462, 8055, 1331, 29, 117, "Title"],
Cell[326796, 8086, 3222, 89, 97, "Subsubsection"],
Cell[330021, 8177, 556, 16, 53, "Subsubsection"],
Cell[330580, 8195, 1447, 27, 36, "Subsubsection"],
Cell[332030, 8224, 2932, 71, 114, "Subsubtitle"],
Cell[334965, 8297, 795, 11, 48, "Subsubsection"],
Cell[335763, 8310, 2529, 75, 180, "Code"],
Cell[338295, 8387, 44, 1, 5, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[338376, 8393, 1482, 33, 100, "Title"],
Cell[339861, 8428, 151, 2, 27957, "Subsubsection"],
Cell[340015, 8432, 1769, 41, 37448, "Subsubsection"],
Cell[341787, 8475, 1347, 24, 20591, "Subsubsection"],
Cell[343137, 8501, 2682, 65, 55588, "Subsubtitle"],
Cell[345822, 8568, 795, 11, 27957, "Subsubsection"],
Cell[346620, 8581, 2263, 65, 106600, "Code"],
Cell[348886, 8648, 44, 1, 2020, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[348967, 8654, 1002, 21, 80, "Title"],
Cell[349972, 8677, 127, 1, 495, "Subsubsection"],
Cell[350102, 8680, 1471, 27, 365, "Subsubsection"],
Cell[351576, 8709, 732, 10, 340, "Subsubsection"],
Cell[352311, 8721, 1562, 31, 769, "Subsubtitle"],
Cell[353876, 8754, 795, 11, 495, "Subsubsection"],
Cell[354674, 8767, 890, 25, 1510, "Code"],
Cell[355567, 8794, 44, 1, 37, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[355648, 8800, 1084, 23, 87, "Title"],
Cell[356735, 8825, 157, 2, 495, "Subsubsection"],
Cell[356895, 8829, 1818, 38, 618, "Subsubsection"],
Cell[358716, 8869, 732, 10, 340, "Subsubsection"],
Cell[359451, 8881, 1849, 39, 929, "Subsubtitle"],
Cell[361303, 8922, 795, 11, 495, "Subsubsection"],
Cell[362101, 8935, 2997, 80, 5571, "Code"],
Cell[365101, 9017, 113, 2, 495, "Subsubsection"],
Cell[365217, 9021, 206, 3, 340, "Subsubsection"],
Cell[365426, 9026, 1640, 31, 551, "Subsubsection"],
Cell[367069, 9059, 732, 10, 340, "Subsubsection"],
Cell[367804, 9071, 2056, 44, 968, "Subsubtitle"],
Cell[369863, 9117, 795, 11, 495, "Subsubsection"],
Cell[370661, 9130, 1366, 38, 1510, "Code"],
Cell[372030, 9170, 44, 1, 37, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[372111, 9176, 1110, 24, 80, "Title"],
Cell[373224, 9202, 196, 3, 354, "Subsubsection"],
Cell[373423, 9207, 643, 20, 289, "Subsubsection"],
Cell[374069, 9229, 732, 10, 243, "Subsubsection"],
Cell[374804, 9241, 1843, 40, 702, "Subsubtitle"],
Cell[376650, 9283, 795, 11, 354, "Subsubsection"],
Cell[377448, 9296, 1228, 36, 1079, "Code"],
Cell[378679, 9334, 113, 2, 354, "Subsubsection"],
Cell[378795, 9338, 150, 2, 243, "Subsubsection"],
Cell[378948, 9342, 605, 20, 394, "Subsubsection"],
Cell[379556, 9364, 864, 16, 261, "Subsubsection"],
Cell[380423, 9382, 2291, 55, 655, "Subsubtitle"],
Cell[382717, 9439, 795, 11, 354, "Subsubsection"],
Cell[383515, 9452, 1874, 56, 1345, "Code"],
Cell[385392, 9510, 44, 1, 27, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[385473, 9516, 1171, 26, 80, "Title"],
Cell[386647, 9544, 150, 2, 495, "Subsubsection"],
Cell[386800, 9548, 904, 17, 365, "Subsubsection"],
Cell[387707, 9567, 2497, 61, 982, "Subsubtitle"],
Cell[390207, 9630, 795, 11, 495, "Subsubsection"],
Cell[391005, 9643, 2187, 65, 1882, "Code"],
Cell[393195, 9710, 113, 2, 495, "Subsubsection"],
Cell[393311, 9714, 150, 2, 340, "Subsubsection"],
Cell[393464, 9718, 605, 20, 551, "Subsubsection"],
Cell[394072, 9740, 976, 19, 365, "Subsubsection"],
Cell[395051, 9761, 2671, 66, 1133, "Subsubtitle"],
Cell[397725, 9829, 795, 11, 495, "Subsubsection"],
Cell[398523, 9842, 2462, 73, 1882, "Code"],
Cell[400988, 9917, 44, 1, 37, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[401069, 9923, 974, 19, 80, "Title"],
Cell[402046, 9944, 286, 4, 495, "Subsubsection"],
Cell[402335, 9950, 101, 1, 340, "Subsubsection"],
Cell[402439, 9953, 890, 17, 365, "Subsubsection"],
Cell[403332, 9972, 1537, 32, 848, "Subsubtitle"],
Cell[404872, 10006, 795, 11, 495, "Subsubsection"],
Cell[405670, 10019, 923, 25, 1882, "Code"],
Cell[406596, 10046, 44, 1, 37, "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}
]
*)

(* End of internal cache information *)
