(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    606666,      15677]
NotebookOptionsPosition[    578644,      15062]
NotebookOutlinePosition[    579771,      15101]
CellTagsIndexPosition[    579728,      15098]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, {
   3.495662009356209*^9, 3.495662018116221*^9}, 3.495664050989067*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4956612341427097`*^9, 3.4956612366427135`*^9}, {
   3.495661466643035*^9, 3.4956615179331074`*^9}, {3.495662078776306*^9, 
   3.4956620926663256`*^9}, {3.495662256946555*^9, 3.495662259396559*^9}, {
   3.4956625025768995`*^9, 3.4956625261869326`*^9}, {3.4956632462279406`*^9, 
   3.4956633094980288`*^9}, 3.495663998918994*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["z", "n"]}]}]], "=", 
   RowBox[{
    FractionBox["1", "a"], "-", 
    FractionBox["b", 
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["z", 
          RowBox[{"-", "n"}]]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, {
   3.495661733765823*^9, 3.4956617391558304`*^9}, 3.4956640248490305`*^9, {
   3.4956641862392564`*^9, 3.495664192349265*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", " ", 
   RowBox[{"n", "<", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4956612341427097`*^9, 3.4956612366427135`*^9}, {
   3.4956628524073887`*^9, 3.495662852597389*^9}, {3.495662895317449*^9, 
   3.4956629260174923`*^9}, {3.4956640934691267`*^9, 3.495664094529128*^9}, {
   3.4956805100871115`*^9, 3.4956805310671406`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["x", "a"]}]}]}]}], "-", 
  RowBox[{
   FractionBox["b", "a"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"b", "+", 
       RowBox[{"a", " ", 
        SuperscriptBox["x", 
         RowBox[{"-", "n"}]]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.495661218692688*^9, 3.495661221952693*^9}, 
   3.4956616963357706`*^9, 3.495661805075923*^9, {3.49566277463728*^9, 
   3.4956628145773363`*^9}, {3.4956640726590977`*^9, 
   3.4956640828891115`*^9}, {3.4956641434291964`*^9, 3.49566416025922*^9}, {
   3.495664214419296*^9, 3.4956642214993057`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ",
   ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "/", "a"}], " ", "-", " ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "/", "a"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"b", "+", 
           RowBox[{"a", "*", 
            RowBox[{"x", "^", 
             RowBox[{"(", 
              RowBox[{"-", "n"}], ")"}]}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4956611267125597`*^9, {3.495661897346052*^9, 3.495661964276146*^9}, {
   3.49566298892758*^9, 3.4956630698976936`*^9}, 3.4956639921189847`*^9, {
   3.495664122139167*^9, 3.4956641261291723`*^9}, {3.495664227899315*^9, 
   3.4956642321893206`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, {
   3.495662009356209*^9, 3.495662018116221*^9}, 3.495664050989067*^9, 
   3.4956643341694636`*^9, 3.495664600549836*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: CRC 278", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4956612341427097`*^9, 3.4956612366427135`*^9}, {
   3.495661466643035*^9, 3.4956615179331074`*^9}, {3.495662078776306*^9, 
   3.4956620926663256`*^9}, {3.495662256946555*^9, 3.495662259396559*^9}, {
   3.4956625025768995`*^9, 3.4956625261869326`*^9}, {3.4956632462279406`*^9, 
   3.4956633094980288`*^9}, 3.495663998918994*^9, {3.4956644892796803`*^9, 
   3.4956645035697007`*^9}, {3.4956650435704565`*^9, 3.495665047230462*^9}, {
   3.4956652669107695`*^9, 3.4956652686707716`*^9}}],

Cell["Derivation: Primitive rule", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4956612341427097`*^9, 3.4956612366427135`*^9}, {
   3.495661466643035*^9, 3.4956615179331074`*^9}, {3.495662078776306*^9, 
   3.4956620926663256`*^9}, {3.495662256946555*^9, 3.495662259396559*^9}, {
   3.4956625025768995`*^9, 3.4956625261869326`*^9}, {3.4956632462279406`*^9, 
   3.4956633094980288`*^9}, 3.495663998918994*^9, 3.4956644892796803`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["ArcSinh", "\[Prime]",
     MultilineFunction->None], "[", "z", "]"}], "=", 
   FractionBox["1", 
    SqrtBox[
     RowBox[{"1", "+", 
      SuperscriptBox["z", "2"]}]]]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, {
   3.495661733765823*^9, 3.4956617391558304`*^9}, 3.4956640248490305`*^9, {
   3.4956641862392564`*^9, 3.495664192349265*^9}, 3.495664521809726*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"b", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4956612341427097`*^9, 3.4956612366427135`*^9}, {
   3.4956628524073887`*^9, 3.495662852597389*^9}, {3.495662895317449*^9, 
   3.4956629260174923`*^9}, {3.4956640934691267`*^9, 3.495664094529128*^9}, {
   3.4956644356696053`*^9, 3.495664438289609*^9}, {3.495664469619653*^9, 
   3.4956644730296583`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "2"]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "   ", 
     RowBox[{"ArcSinh", "[", 
      FractionBox[
       RowBox[{
        SqrtBox["b"], " ", "x"}], 
       SqrtBox["a"]], "]"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.495661218692688*^9, 3.495661221952693*^9}, 
   3.4956616963357706`*^9, 3.495661805075923*^9, {3.49566277463728*^9, 
   3.4956628145773363`*^9}, {3.4956640726590977`*^9, 
   3.4956640828891115`*^9}, {3.4956641434291964`*^9, 3.49566416025922*^9}, {
   3.495664214419296*^9, 3.4956642214993057`*^9}, {3.4956644076995664`*^9, 
   3.495664423959589*^9}, {3.4956800967165327`*^9, 3.495680107766548*^9}, 
   3.4956801608166227`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcSinh", "[", 
     RowBox[{
      RowBox[{"Rt", "[", 
       RowBox[{"b", ",", "2"}], "]"}], "*", 
      RowBox[{"x", "/", 
       RowBox[{"Sqrt", "[", "a", "]"}]}]}], "]"}], "/", 
    RowBox[{"Rt", "[", 
     RowBox[{"b", ",", "2"}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", "a", "]"}], " ", "&&", " ", 
    RowBox[{"PosQ", "[", "b", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4956611267125597`*^9, {3.495661897346052*^9, 3.495661964276146*^9}, {
   3.49566298892758*^9, 3.4956630698976936`*^9}, 3.4956639921189847`*^9, {
   3.495664122139167*^9, 3.4956641261291723`*^9}, {3.495664227899315*^9, 
   3.4956642321893206`*^9}, 3.495664348619484*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.271.4b, CRC 279, A&S 3.3.44", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4956612341427097`*^9, 3.4956612366427135`*^9}, {
   3.495661466643035*^9, 3.4956615179331074`*^9}, {3.495662078776306*^9, 
   3.4956620926663256`*^9}, {3.495662256946555*^9, 3.495662259396559*^9}, {
   3.4956625025768995`*^9, 3.4956625261869326`*^9}, {3.4956632462279406`*^9, 
   3.4956633094980288`*^9}, 3.495663998918994*^9, {3.4956644892796803`*^9, 
   3.4956645035697007`*^9}, 3.495664644999899*^9, {3.4956649976003923`*^9, 
   3.4956650260304317`*^9}}],

Cell["Derivation: Primitive rule", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4956612341427097`*^9, 3.4956612366427135`*^9}, {
   3.495661466643035*^9, 3.4956615179331074`*^9}, {3.495662078776306*^9, 
   3.4956620926663256`*^9}, {3.495662256946555*^9, 3.495662259396559*^9}, {
   3.4956625025768995`*^9, 3.4956625261869326`*^9}, {3.4956632462279406`*^9, 
   3.4956633094980288`*^9}, 3.495663998918994*^9, 3.4956644892796803`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["ArcSin", "\[Prime]",
     MultilineFunction->None], "[", "z", "]"}], "=", 
   FractionBox["1", 
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox["z", "2"]}]]]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, {
   3.495661733765823*^9, 3.4956617391558304`*^9}, 3.4956640248490305`*^9, {
   3.4956641862392564`*^9, 3.495664192349265*^9}, 3.495664521809726*^9, 
   3.4956646755199413`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{"b", ">", "0"}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4956612341427097`*^9, 3.4956612366427135`*^9}, {
   3.4956628524073887`*^9, 3.495662852597389*^9}, {3.495662895317449*^9, 
   3.4956629260174923`*^9}, {3.4956640934691267`*^9, 3.495664094529128*^9}, {
   3.4956644356696053`*^9, 3.495664438289609*^9}, {3.495664469619653*^9, 
   3.4956644730296583`*^9}, {3.4956647033499804`*^9, 3.4956647070199857`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "2"]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      SqrtBox[
       RowBox[{"-", "b"}]]]}]}], " ", 
   RowBox[{"ArcSin", "[", 
    FractionBox[
     RowBox[{
      SqrtBox[
       RowBox[{"-", "b"}]], " ", "x"}], 
     SqrtBox["a"]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.495661218692688*^9, 3.495661221952693*^9}, 
   3.4956616963357706`*^9, 3.495661805075923*^9, {3.49566277463728*^9, 
   3.4956628145773363`*^9}, {3.4956640726590977`*^9, 
   3.4956640828891115`*^9}, {3.4956641434291964`*^9, 3.49566416025922*^9}, {
   3.495664214419296*^9, 3.4956642214993057`*^9}, {3.4956644076995664`*^9, 
   3.495664423959589*^9}, 3.4956647769900837`*^9, {3.4956801122865543`*^9, 
   3.495680121096567*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcSin", "[", 
     RowBox[{
      RowBox[{"Rt", "[", 
       RowBox[{
        RowBox[{"-", "b"}], ",", "2"}], "]"}], "*", 
      RowBox[{"x", "/", 
       RowBox[{"Sqrt", "[", "a", "]"}]}]}], "]"}], "/", 
    RowBox[{"Rt", "[", 
     RowBox[{
      RowBox[{"-", "b"}], ",", "2"}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", "a", "]"}], " ", "&&", " ", 
    RowBox[{"NegQ", "[", "b", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4956611267125597`*^9, {3.495661897346052*^9, 3.495661964276146*^9}, {
   3.49566298892758*^9, 3.4956630698976936`*^9}, 3.4956639921189847`*^9, {
   3.495664122139167*^9, 3.4956641261291723`*^9}, {3.495664227899315*^9, 
   3.4956642321893206`*^9}, 3.495664348619484*^9, 3.495664751510048*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: CRC 278'", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4956612341427097`*^9, 3.4956612366427135`*^9}, {
   3.495661466643035*^9, 3.4956615179331074`*^9}, {3.495662078776306*^9, 
   3.4956620926663256`*^9}, {3.495662256946555*^9, 3.495662259396559*^9}, {
   3.4956625025768995`*^9, 3.4956625261869326`*^9}, {3.4956632462279406`*^9, 
   3.4956633094980288`*^9}, 3.495663998918994*^9, {3.4956644892796803`*^9, 
   3.4956645035697007`*^9}, 3.495664644999899*^9, {3.4956649976003923`*^9, 
   3.4956650260304317`*^9}, 3.495665112520553*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{"a", ">", "0"}], ")"}]}], " ", "\[And]", " ", 
   RowBox[{"b", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4956612341427097`*^9, 3.4956612366427135`*^9}, {
   3.4956628524073887`*^9, 3.495662852597389*^9}, {3.495662895317449*^9, 
   3.4956629260174923`*^9}, {3.4956640934691267`*^9, 3.495664094529128*^9}, {
   3.4956644356696053`*^9, 3.495664438289609*^9}, {3.495664469619653*^9, 
   3.4956644730296583`*^9}, {3.4956647033499804`*^9, 
   3.4956647070199857`*^9}, {3.495665402310959*^9, 3.4956654218409863`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "2"]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      SqrtBox["b"]]}]}], 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     RowBox[{
      SqrtBox["b"], " ", "x"}], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}]}]]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.495661218692688*^9, 3.495661221952693*^9}, 
   3.4956616963357706`*^9, 3.495661805075923*^9, {3.49566277463728*^9, 
   3.4956628145773363`*^9}, {3.4956640726590977`*^9, 
   3.4956640828891115`*^9}, {3.4956641434291964`*^9, 3.49566416025922*^9}, {
   3.495664214419296*^9, 3.4956642214993057`*^9}, {3.4956644076995664`*^9, 
   3.495664423959589*^9}, 3.4956647769900837`*^9, 3.495665338330869*^9, {
   3.4956801663966303`*^9, 3.495680169676635*^9}, {3.4998215854459844`*^9, 
   3.499821591529995*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcTanh", "[", 
     RowBox[{
      RowBox[{"Rt", "[", 
       RowBox[{"b", ",", "2"}], "]"}], "*", 
      RowBox[{"x", "/", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "2"}]}]}], "]"}]}]}], "]"}], "/", 
    RowBox[{"Rt", "[", 
     RowBox[{"b", ",", "2"}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"PositiveQ", "[", "a", "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"PosQ", "[", "b", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4956611267125597`*^9, {3.495661897346052*^9, 3.495661964276146*^9}, {
   3.49566298892758*^9, 3.4956630698976936`*^9}, 3.4956639921189847`*^9, {
   3.495664122139167*^9, 3.4956641261291723`*^9}, {3.495664227899315*^9, 
   3.4956642321893206`*^9}, 3.495664348619484*^9, 3.495664751510048*^9, 
   3.4956651190505624`*^9, {3.4998216370880756`*^9, 3.499821646292092*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: CRC 279'", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4956612341427097`*^9, 3.4956612366427135`*^9}, {
   3.495661466643035*^9, 3.4956615179331074`*^9}, {3.495662078776306*^9, 
   3.4956620926663256`*^9}, {3.495662256946555*^9, 3.495662259396559*^9}, {
   3.4956625025768995`*^9, 3.4956625261869326`*^9}, {3.4956632462279406`*^9, 
   3.4956633094980288`*^9}, 3.495663998918994*^9, {3.4956644892796803`*^9, 
   3.4956645035697007`*^9}, 3.495664644999899*^9, {3.4956649976003923`*^9, 
   3.4956650260304317`*^9}, 3.495665112520553*^9, 3.495665461771042*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{"a", ">", "0"}], ")"}]}], " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{"b", ">", "0"}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4956612341427097`*^9, 3.4956612366427135`*^9}, {
   3.4956628524073887`*^9, 3.495662852597389*^9}, {3.495662895317449*^9, 
   3.4956629260174923`*^9}, {3.4956640934691267`*^9, 3.495664094529128*^9}, {
   3.4956644356696053`*^9, 3.495664438289609*^9}, {3.495664469619653*^9, 
   3.4956644730296583`*^9}, {3.4956647033499804`*^9, 
   3.4956647070199857`*^9}, {3.495665402310959*^9, 3.4956654218409863`*^9}, {
   3.4956654826810713`*^9, 3.495665486521077*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "2"]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      SqrtBox[
       RowBox[{"-", "b"}]]]}]}], 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{
      SqrtBox[
       RowBox[{"-", "b"}]], " ", "x"}], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}]}]]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.495661218692688*^9, 3.495661221952693*^9}, 
   3.4956616963357706`*^9, 3.495661805075923*^9, {3.49566277463728*^9, 
   3.4956628145773363`*^9}, {3.4956640726590977`*^9, 
   3.4956640828891115`*^9}, {3.4956641434291964`*^9, 3.49566416025922*^9}, {
   3.495664214419296*^9, 3.4956642214993057`*^9}, {3.4956644076995664`*^9, 
   3.495664423959589*^9}, 3.4956647769900837`*^9, 3.495665338330869*^9, 
   3.4956655234711285`*^9, {3.4956801799366493`*^9, 3.4956801831066537`*^9}, {
   3.499821602393615*^9, 3.4998216118784313`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcTan", "[", 
     RowBox[{
      RowBox[{"Rt", "[", 
       RowBox[{
        RowBox[{"-", "b"}], ",", "2"}], "]"}], "*", 
      RowBox[{"x", "/", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "2"}]}]}], "]"}]}]}], "]"}], "/", 
    RowBox[{"Rt", "[", 
     RowBox[{
      RowBox[{"-", "b"}], ",", "2"}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"PositiveQ", "[", "a", "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"NegQ", "[", "b", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4956611267125597`*^9, {3.495661897346052*^9, 3.495661964276146*^9}, {
   3.49566298892758*^9, 3.4956630698976936`*^9}, 3.4956639921189847`*^9, {
   3.495664122139167*^9, 3.4956641261291723`*^9}, {3.495664227899315*^9, 
   3.4956642321893206`*^9}, 3.495664348619484*^9, 3.495664751510048*^9, 
   3.4956651190505624`*^9, 3.4956654734310584`*^9, 3.4998216160280385`*^9, {
   3.4998216546693068`*^9, 3.499821665370925*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"a", ">", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4956612341427097`*^9, 3.4956612366427135`*^9}, {
   3.4956628524073887`*^9, 3.495662852597389*^9}, {3.495662895317449*^9, 
   3.4956629260174923`*^9}, {3.4956640934691267`*^9, 3.495664094529128*^9}, {
   3.4956644356696053`*^9, 3.495664438289609*^9}, {3.495664469619653*^9, 
   3.4956644730296583`*^9}, {3.4956647033499804`*^9, 
   3.4956647070199857`*^9}, {3.495665402310959*^9, 3.4956654218409863`*^9}, {
   3.4956654826810713`*^9, 3.495665486521077*^9}, 3.495665822291547*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "4"]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      RowBox[{
       SqrtBox["a"], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", 
          FractionBox["b", "a"]}], ")"}], 
        RowBox[{"1", "/", "4"}]]}]]}]}], " ", 
   RowBox[{"EllipticF", "[", 
    RowBox[{
     RowBox[{"ArcSin", "[", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", 
          FractionBox["b", "a"]}], ")"}], 
        RowBox[{"1", "/", "4"}]], " ", "x"}], "]"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.495661218692688*^9, 3.495661221952693*^9}, 
   3.4956616963357706`*^9, 3.495661805075923*^9, {3.49566277463728*^9, 
   3.4956628145773363`*^9}, {3.4956640726590977`*^9, 
   3.4956640828891115`*^9}, {3.4956641434291964`*^9, 3.49566416025922*^9}, {
   3.495664214419296*^9, 3.4956642214993057`*^9}, {3.4956644076995664`*^9, 
   3.495664423959589*^9}, 3.4956647769900837`*^9, 3.495665338330869*^9, 
   3.4956655234711285`*^9, 3.4956657843614936`*^9, 3.495665831201559*^9, {
   3.4956802515667496`*^9, 3.495680271596778*^9}, {3.497047349075227*^9, 
   3.4970473927085037`*^9}, {3.4970474331125746`*^9, 3.4970474365445805`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "4"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"EllipticF", "[", 
     RowBox[{
      RowBox[{"ArcSin", "[", 
       RowBox[{
        RowBox[{"Rt", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "b"}], "/", "a"}], ",", "4"}], "]"}], "*", "x"}], 
       "]"}], ",", 
      RowBox[{"-", "1"}]}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Sqrt", "[", "a", "]"}], "*", 
      RowBox[{"Rt", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "b"}], "/", "a"}], ",", "4"}], "]"}]}], ")"}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", "a", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4956611267125597`*^9, {3.495661897346052*^9, 3.495661964276146*^9}, {
   3.49566298892758*^9, 3.4956630698976936`*^9}, 3.4956639921189847`*^9, {
   3.495664122139167*^9, 3.4956641261291723`*^9}, {3.495664227899315*^9, 
   3.4956642321893206`*^9}, 3.495664348619484*^9, 3.495664751510048*^9, 
   3.4956651190505624`*^9, 3.4956654734310584`*^9, 3.4956655721311965`*^9, {
   3.495665973641759*^9, 3.4956660042318015`*^9}, {3.4970474666962347`*^9, 
   3.4970474975998883`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    FractionBox[
     RowBox[{
      SqrtBox["a"], " ", 
      SqrtBox[
       FractionBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "4"]}]}], "a"]]}], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "4"]}]}]]]}], "=", "0"}]]]
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4956612341427097`*^9, 3.4956612366427135`*^9}, {
   3.495661466643035*^9, 3.4956615179331074`*^9}, {3.495662078776306*^9, 
   3.4956620926663256`*^9}, {3.495662256946555*^9, 3.495662259396559*^9}, {
   3.4956625025768995`*^9, 3.4956625261869326`*^9}, {3.4956632462279406`*^9, 
   3.4956633094980288`*^9}, 3.495663998918994*^9, {3.4956644892796803`*^9, 
   3.4956645035697007`*^9}, 3.495664644999899*^9, {3.4956649976003923`*^9, 
   3.4956650260304317`*^9}, 3.495665112520553*^9, 3.495665461771042*^9, {
   3.495666875785483*^9, 3.4956668919003115`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"\[Not]", 
   RowBox[{"(", 
    RowBox[{"a", ">", "0"}], ")"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4956612341427097`*^9, 3.4956612366427135`*^9}, {
   3.4956628524073887`*^9, 3.495662852597389*^9}, {3.495662895317449*^9, 
   3.4956629260174923`*^9}, {3.4956640934691267`*^9, 3.495664094529128*^9}, {
   3.4956644356696053`*^9, 3.495664438289609*^9}, {3.495664469619653*^9, 
   3.4956644730296583`*^9}, {3.4956647033499804`*^9, 
   3.4956647070199857`*^9}, {3.495665402310959*^9, 3.4956654218409863`*^9}, {
   3.4956654826810713`*^9, 3.495665486521077*^9}, 3.495665822291547*^9, {
   3.49566588892164*^9, 3.4956658918816442`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "4"]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SqrtBox[
        FractionBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", "4"]}]}], "a"]], " "}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", 
          FractionBox["b", "a"]}], ")"}], 
        RowBox[{"1", "/", "4"}]], " ", 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "4"]}]}]]}]]}]}], 
   RowBox[{"EllipticF", "[", 
    RowBox[{
     RowBox[{"ArcSin", "[", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", 
          FractionBox["b", "a"]}], ")"}], 
        RowBox[{"1", "/", "4"}]], " ", "x"}], "]"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.495661218692688*^9, 3.495661221952693*^9}, 
   3.4956616963357706`*^9, 3.495661805075923*^9, {3.49566277463728*^9, 
   3.4956628145773363`*^9}, {3.4956640726590977`*^9, 
   3.4956640828891115`*^9}, {3.4956641434291964`*^9, 3.49566416025922*^9}, {
   3.495664214419296*^9, 3.4956642214993057`*^9}, {3.4956644076995664`*^9, 
   3.495664423959589*^9}, 3.4956647769900837`*^9, 3.495665338330869*^9, 
   3.4956655234711285`*^9, 3.4956657843614936`*^9, 3.495665831201559*^9, 
   3.49566683408661*^9, {3.495680295666811*^9, 3.4956803141568375`*^9}, {
   3.496091997815734*^9, 3.496092003465742*^9}, 3.497047328701591*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "4"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "4"}]}]}], ")"}], "/", "a"}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "b"}], "/", "a"}], ",", "4"}], "]"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "4"}]}]}], "]"}]}], ")"}]}], "*", 
    RowBox[{"EllipticF", "[", 
     RowBox[{
      RowBox[{"ArcSin", "[", 
       RowBox[{
        RowBox[{"Rt", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "b"}], "/", "a"}], ",", "4"}], "]"}], "*", "x"}], 
       "]"}], ",", 
      RowBox[{"-", "1"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"PositiveQ", "[", "a", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4956611267125597`*^9, {3.495661897346052*^9, 3.495661964276146*^9}, {
   3.49566298892758*^9, 3.4956630698976936`*^9}, 3.4956639921189847`*^9, {
   3.495664122139167*^9, 3.4956641261291723`*^9}, {3.495664227899315*^9, 
   3.4956642321893206`*^9}, 3.495664348619484*^9, 3.495664751510048*^9, 
   3.4956651190505624`*^9, 3.4956654734310584`*^9, 3.4956655721311965`*^9, 
   3.4956659014816575`*^9, {3.4956669544876213`*^9, 3.4956669733012543`*^9}, {
   3.495680355436895*^9, 3.4956803674769115`*^9}, {3.4960924785364065`*^9, 
   3.496092488676421*^9}, {3.4970471370864544`*^9, 3.4970471525928817`*^9}, {
   3.4970471841049376`*^9, 3.4970471916241503`*^9}, {3.4970472523394566`*^9, 
   3.4970472533690586`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "m"], 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, {
   3.495662009356209*^9, 3.495662018116221*^9}, 3.495664050989067*^9, 
   3.4956643341694636`*^9, 3.495664600549836*^9, {3.496091657905258*^9, 
   3.4960916628052645`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"a", ">", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4956612341427097`*^9, 3.4956612366427135`*^9}, {
   3.4956628524073887`*^9, 3.495662852597389*^9}, {3.495662895317449*^9, 
   3.4956629260174923`*^9}, {3.4956640934691267`*^9, 3.495664094529128*^9}, {
   3.4956644356696053`*^9, 3.495664438289609*^9}, {3.495664469619653*^9, 
   3.4956644730296583`*^9}, {3.4956647033499804`*^9, 
   3.4956647070199857`*^9}, {3.495665402310959*^9, 3.4956654218409863`*^9}, {
   3.4956654826810713`*^9, 3.495665486521077*^9}, 3.495665822291547*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "2"], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "4"]}]}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", 
       RowBox[{
        SqrtBox["a"], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", 
           FractionBox["b", "a"]}], ")"}], 
         RowBox[{"3", "/", "4"}]]}]]}]}], 
    RowBox[{"EllipticE", "[", 
     RowBox[{
      RowBox[{"ArcSin", "[", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", 
           FractionBox["b", "a"]}], ")"}], 
         RowBox[{"1", "/", "4"}]], " ", "x"}], "]"}], ",", 
      RowBox[{"-", "1"}]}], "]"}]}]}], "-", "\[IndentingNewLine]", 
  "                                       ", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SqrtBox["a"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", 
        FractionBox["b", "a"]}], ")"}], 
      RowBox[{"3", "/", "4"}]]}]], 
   RowBox[{"EllipticF", "[", 
    RowBox[{
     RowBox[{"ArcSin", "[", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", 
          FractionBox["b", "a"]}], ")"}], 
        RowBox[{"1", "/", "4"}]], " ", "x"}], "]"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.495661218692688*^9, 3.495661221952693*^9}, 
   3.4956616963357706`*^9, 3.495661805075923*^9, {3.49566277463728*^9, 
   3.4956628145773363`*^9}, {3.4956640726590977`*^9, 
   3.4956640828891115`*^9}, {3.4956641434291964`*^9, 3.49566416025922*^9}, {
   3.495664214419296*^9, 3.4956642214993057`*^9}, {3.4956644076995664`*^9, 
   3.495664423959589*^9}, 3.4956647769900837`*^9, 3.495665338330869*^9, 
   3.4956655234711285`*^9, 3.4956657843614936`*^9, 3.495665831201559*^9, {
   3.4956802515667496`*^9, 3.495680271596778*^9}, {3.4960916968853126`*^9, 
   3.4960917397753725`*^9}, {3.4962847586218166`*^9, 3.49628477524184*^9}, {
   3.496285007512165*^9, 3.496285014732175*^9}, {3.496285194282427*^9, 
   3.4962851944324265`*^9}, {3.497048997330923*^9, 3.4970490393105974`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "2"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "4"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sqrt", "[", "a", "]"}], "*", 
        RowBox[{
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "b"}], "/", "a"}], ",", "4"}], "]"}], "^", "3"}]}], 
       ")"}]}], "*", 
     RowBox[{"EllipticE", "[", 
      RowBox[{
       RowBox[{"ArcSin", "[", 
        RowBox[{
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "b"}], "/", "a"}], ",", "4"}], "]"}], "*", "x"}], 
        "]"}], ",", 
       RowBox[{"-", "1"}]}], "]"}]}], " ", "-", "\[IndentingNewLine]", "  ", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sqrt", "[", "a", "]"}], "*", 
        RowBox[{
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "b"}], "/", "a"}], ",", "4"}], "]"}], "^", "3"}]}], 
       ")"}]}], "*", 
     RowBox[{"EllipticF", "[", 
      RowBox[{
       RowBox[{"ArcSin", "[", 
        RowBox[{
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "b"}], "/", "a"}], ",", "4"}], "]"}], "*", "x"}], 
        "]"}], ",", 
       RowBox[{"-", "1"}]}], "]"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", "a", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4956611267125597`*^9, {3.495661897346052*^9, 3.495661964276146*^9}, {
   3.49566298892758*^9, 3.4956630698976936`*^9}, 3.4956639921189847`*^9, {
   3.495664122139167*^9, 3.4956641261291723`*^9}, {3.495664227899315*^9, 
   3.4956642321893206`*^9}, 3.495664348619484*^9, 3.495664751510048*^9, 
   3.4956651190505624`*^9, 3.4956654734310584`*^9, 3.4956655721311965`*^9, {
   3.495665973641759*^9, 3.4956660042318015`*^9}, {3.496091890105583*^9, 
   3.4960918947855897`*^9}, {3.4960929267970343`*^9, 
   3.4960929290670376`*^9}, {3.497049069013049*^9, 3.497049070697852*^9}, {
   3.497049120040739*^9, 3.4970491432067795`*^9}, {3.4970492011764812`*^9, 
   3.4970492377741456`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    FractionBox[
     RowBox[{
      SqrtBox["a"], " ", 
      SqrtBox[
       FractionBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "4"]}]}], "a"]]}], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "4"]}]}]]]}], "=", "0"}]]]
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4956612341427097`*^9, 3.4956612366427135`*^9}, {
   3.495661466643035*^9, 3.4956615179331074`*^9}, {3.495662078776306*^9, 
   3.4956620926663256`*^9}, {3.495662256946555*^9, 3.495662259396559*^9}, {
   3.4956625025768995`*^9, 3.4956625261869326`*^9}, {3.4956632462279406`*^9, 
   3.4956633094980288`*^9}, 3.495663998918994*^9, {3.4956644892796803`*^9, 
   3.4956645035697007`*^9}, 3.495664644999899*^9, {3.4956649976003923`*^9, 
   3.4956650260304317`*^9}, 3.495665112520553*^9, 3.495665461771042*^9, {
   3.495666875785483*^9, 3.4956668919003115`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"\[Not]", 
   RowBox[{"(", 
    RowBox[{"a", ">", "0"}], ")"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4956612341427097`*^9, 3.4956612366427135`*^9}, {
   3.4956628524073887`*^9, 3.495662852597389*^9}, {3.495662895317449*^9, 
   3.4956629260174923`*^9}, {3.4956640934691267`*^9, 3.495664094529128*^9}, {
   3.4956644356696053`*^9, 3.495664438289609*^9}, {3.495664469619653*^9, 
   3.4956644730296583`*^9}, {3.4956647033499804`*^9, 
   3.4956647070199857`*^9}, {3.495665402310959*^9, 3.4956654218409863`*^9}, {
   3.4956654826810713`*^9, 3.495665486521077*^9}, 3.495665822291547*^9, {
   3.49566588892164*^9, 3.4956658918816442`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "2"], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "4"]}]}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       SqrtBox[
        FractionBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", "4"]}]}], "a"]], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", 
           FractionBox["b", "a"]}], ")"}], 
         RowBox[{"3", "/", "4"}]], 
        SqrtBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", "4"]}]}]]}]]}]}], 
    RowBox[{"EllipticE", "[", 
     RowBox[{
      RowBox[{"ArcSin", "[", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", 
           FractionBox["b", "a"]}], ")"}], 
         RowBox[{"1", "/", "4"}]], " ", "x"}], "]"}], ",", 
      RowBox[{"-", "1"}]}], "]"}]}]}], "-", "\[IndentingNewLine]", 
  "                                       ", 
  RowBox[{
   FractionBox[
    SqrtBox[
     FractionBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "4"]}]}], "a"]], 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", 
        FractionBox["b", "a"]}], ")"}], 
      RowBox[{"3", "/", "4"}]], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "4"]}]}]]}]], 
   RowBox[{"EllipticF", "[", 
    RowBox[{
     RowBox[{"ArcSin", "[", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", 
          FractionBox["b", "a"]}], ")"}], 
        RowBox[{"1", "/", "4"}]], " ", "x"}], "]"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.495661218692688*^9, 3.495661221952693*^9}, 
   3.4956616963357706`*^9, 3.495661805075923*^9, {3.49566277463728*^9, 
   3.4956628145773363`*^9}, {3.4956640726590977`*^9, 
   3.4956640828891115`*^9}, {3.4956641434291964`*^9, 3.49566416025922*^9}, {
   3.495664214419296*^9, 3.4956642214993057`*^9}, {3.4956644076995664`*^9, 
   3.495664423959589*^9}, 3.4956647769900837`*^9, 3.495665338330869*^9, 
   3.4956655234711285`*^9, 3.4956657843614936`*^9, 3.495665831201559*^9, 
   3.49566683408661*^9, {3.495680295666811*^9, 3.4956803141568375`*^9}, 
   3.496091958835679*^9, {3.4960920240457706`*^9, 3.4960920290957775`*^9}, {
   3.496092155895955*^9, 3.4960921711559763`*^9}, {3.496092225866053*^9, 
   3.496092264276107*^9}, {3.497048820426613*^9, 3.497048826885024*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "2"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "4"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"x", "^", "4"}]}]}], ")"}], "/", "a"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "b"}], "/", "a"}], ",", "4"}], "]"}], "^", "3"}], 
        "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"x", "^", "4"}]}]}], "]"}]}], ")"}]}], "*", 
     RowBox[{"EllipticE", "[", 
      RowBox[{
       RowBox[{"ArcSin", "[", 
        RowBox[{
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "b"}], "/", "a"}], ",", "4"}], "]"}], "*", "x"}], 
        "]"}], ",", 
       RowBox[{"-", "1"}]}], "]"}]}], " ", "-", "\[IndentingNewLine]", "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"x", "^", "4"}]}]}], ")"}], "/", "a"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "b"}], "/", "a"}], ",", "4"}], "]"}], "^", "3"}], 
        "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"x", "^", "4"}]}]}], "]"}]}], ")"}]}], "*", 
     RowBox[{"EllipticF", "[", 
      RowBox[{
       RowBox[{"ArcSin", "[", 
        RowBox[{
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "b"}], "/", "a"}], ",", "4"}], "]"}], "*", "x"}], 
        "]"}], ",", 
       RowBox[{"-", "1"}]}], "]"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"PositiveQ", "[", "a", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4956611267125597`*^9, {3.495661897346052*^9, 3.495661964276146*^9}, {
   3.49566298892758*^9, 3.4956630698976936`*^9}, 3.4956639921189847`*^9, {
   3.495664122139167*^9, 3.4956641261291723`*^9}, {3.495664227899315*^9, 
   3.4956642321893206`*^9}, 3.495664348619484*^9, 3.495664751510048*^9, 
   3.4956651190505624`*^9, 3.4956654734310584`*^9, 3.4956655721311965`*^9, 
   3.4956659014816575`*^9, {3.4956669544876213`*^9, 3.4956669733012543`*^9}, {
   3.495680355436895*^9, 3.4956803674769115`*^9}, {3.496092291986146*^9, 
   3.4960922931061473`*^9}, {3.496092362946245*^9, 3.496092420026325*^9}, {
   3.4960929373770494`*^9, 3.4960929390870514`*^9}, {3.4962837716204348`*^9, 
   3.496283772720436*^9}, {3.497048937395618*^9, 3.4970489449928317`*^9}, {
   3.497049220926116*^9, 3.4970492427661543`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, 
   3.4956785874344196`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{3.4953915070313115`*^9, 3.4956785976344337`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   SqrtBox[
    RowBox[{"a", "+", 
     FractionBox["b", 
      SuperscriptBox["z", "2"]]}]], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            FractionBox["1", "z"], ")"}], "2"]}]}]], " "}], 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["1", "z"], ")"}], "2"]]}], 
    RowBox[{
     SubscriptBox["\[PartialD]", "z"], 
     FractionBox["1", "z"]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, 
   3.495678654704514*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, 3.495678749054646*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SqrtBox[
    RowBox[{"a", "+", 
     FractionBox["b", 
      SuperscriptBox["x", "2"]]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      RowBox[{"Subst", "[", 
       RowBox[{
        RowBox[{"\[Integral]", 
         RowBox[{
          FractionBox[
           SqrtBox[
            RowBox[{"a", "+", 
             RowBox[{"b", " ", 
              SuperscriptBox["x", "2"]}]}]], 
           SuperscriptBox["x", "2"]], 
          RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
        FractionBox["1", "x"]}], "]"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.4956786837845545`*^9, 3.495678713054596*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"a_.", "+", 
      RowBox[{"b_.", "/", 
       RowBox[{"x_", "^", "2"}]}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Subst", "[", 
     RowBox[{
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
         RowBox[{"x", "^", "2"}]}], ",", "x"}], "]"}], ",", "x", ",", 
      RowBox[{"1", "/", "x"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4956786068244467`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.110.2', CRC 88d'", "Subsubsection",
 CellChangeTimes->{3.49539151296132*^9, 3.495678787084699*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"n", " ", 
     RowBox[{"(", 
      RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.495678797624714*^9, 
   3.4956788080547285`*^9}, 3.4956788502147875`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"x", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", "n"]}]}], ")"}], 
        RowBox[{"p", "+", "1"}]]}], "a"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.495678825124752*^9, 3.495678868624813*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_"}]}]}], ")"}], "^", "p_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"x", "*", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"x", "^", "n"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}], "/", "a"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "n", ",", "p"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"n", "*", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.495678779164688*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.110.1, CRC 88b", "Subsubsection",
 CellChangeTimes->{3.49539151296132*^9, 3.495678787084699*^9, 
  3.4956789080048685`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", " ", 
   RowBox[{"p", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"n", " ", "p"}], "+", "1"}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.495678797624714*^9, 
   3.4956788080547285`*^9}, 3.4956788502147875`*^9, {3.4956789897249827`*^9, 
   3.495679002425001*^9}, {3.4956807791874886`*^9, 3.4956807835674944`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"x", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}]}], ")"}], "p"]}], 
       RowBox[{
        RowBox[{"n", " ", "p"}], "+", "1"}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", "n", " ", "p"}], 
    RowBox[{
     RowBox[{"n", " ", "p"}], "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}], 
      RowBox[{"p", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.495678825124752*^9, 3.495678868624813*^9, 
   3.495678953284932*^9, {3.495680696297372*^9, 3.495680698977376*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_"}]}]}], ")"}], "^", "p_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], ")"}], "^", "p"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"n", "*", "p"}], "+", "1"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", "n", "*", 
       RowBox[{"p", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"n", "*", "p"}], "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "^", "n"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"FractionQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "0"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"n", "*", "p"}], "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.495678779164688*^9, 3.495678914664878*^9, {
   3.49568070164738*^9, 3.495680704527384*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.110.2, CRC 88d", "Subsubsection",
 CellChangeTimes->{3.49539151296132*^9, 3.495678787084699*^9, 
  3.4956789080048685`*^9, 3.4956790295250387`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", " ", 
   RowBox[{"p", "<", 
    RowBox[{"-", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.495678797624714*^9, 
   3.4956788080547285`*^9}, 3.4956788502147875`*^9, {3.4956789897249827`*^9, 
   3.495679002425001*^9}, {3.495679072285098*^9, 3.4956790738051004`*^9}, {
   3.49568081616754*^9, 3.49568081616754*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"x", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox["x", "n"]}]}], ")"}], 
          RowBox[{"p", "+", "1"}]]}], 
        RowBox[{"a", " ", "n", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"n", " ", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], 
    RowBox[{"a", " ", "n", " ", 
     RowBox[{"(", 
      RowBox[{"p", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}], 
      RowBox[{"p", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.495678825124752*^9, 3.495678868624813*^9, 
   3.495678953284932*^9, 3.4956790561650763`*^9, {3.495680713187396*^9, 
   3.49568072371741*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_"}]}]}], ")"}], "^", "p_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "x"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"n", "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}], "*", "a"}], ")"}]}]}], " ", "+", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"n", "*", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", "n", "*", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "^", "n"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"FractionQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.495678779164688*^9, 3.495678914664878*^9, 
   3.4956790358650475`*^9, {3.4956807316374216`*^9, 3.495680734747426*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.110.6, CRC 88c", "Subsubsection",
 CellChangeTimes->{3.49539151296132*^9, 3.495678787084699*^9, 
  3.4956789080048685`*^9, 3.4956790295250387`*^9, 3.495679129075178*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"p", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.495678797624714*^9, 
   3.4956788080547285`*^9}, 3.4956788502147875`*^9, {3.4956789897249827`*^9, 
   3.495679002425001*^9}, {3.495679072285098*^9, 3.4956790738051004`*^9}, {
   3.495679236085328*^9, 3.495679236315328*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       FractionBox["b", "x"]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"x", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           FractionBox["b", "x"]}], ")"}], 
         RowBox[{"p", "+", "1"}]]}], "a"]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"b", " ", "p"}], "a"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         FractionBox["b", "x"]}], ")"}], "p"], "x"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.495678825124752*^9, 3.495678868624813*^9, 
   3.495678953284932*^9, 3.4956790561650763`*^9, {3.495679179585249*^9, 
   3.495679198215275*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "/", "x_"}]}], ")"}], "^", "p_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "/", "x"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "/", "a"}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", 
       RowBox[{"p", "/", "a"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "/", "x"}]}], ")"}], "^", "p"}], "/", "x"}], ",", 
        "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", "p", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.495678779164688*^9, 3.495678914664878*^9, 
   3.4956790358650475`*^9, 3.4956791378551903`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.49539151296132*^9, 3.495678787084699*^9, 3.4956789080048685`*^9, 
   3.4956790295250387`*^9, 3.495679129075178*^9, {3.495679335075466*^9, 
   3.4956793607555027`*^9}, {3.495679674485942*^9, 3.4956796884659615`*^9}}],

Cell[TextData[{
 "Note: Transforms ",
 Cell[BoxData["p"]],
 " into an integer."
}], "Subsubsection",
 CellChangeTimes->{
  3.49539151296132*^9, 3.495678787084699*^9, 3.4956789080048685`*^9, 
   3.4956790295250387`*^9, 3.495679129075178*^9, {3.495679335075466*^9, 
   3.4956793607555027`*^9}, 3.4957366510709305`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"-", "1"}], "<", "p", "<", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"p", "+", 
     FractionBox["1", "n"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}]}]]],
 ", let ",
 Cell[BoxData[
  RowBox[{"q", "=", 
   RowBox[{"Denominator", "[", "p", "]"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.495678797624714*^9, 
   3.4956788080547285`*^9}, 3.4956788502147875`*^9, {3.4956789897249827`*^9, 
   3.495679002425001*^9}, {3.495679072285098*^9, 3.4956790738051004`*^9}, {
   3.495679236085328*^9, 3.495679236315328*^9}, {3.49567937329552*^9, 
   3.4956794246455917`*^9}, {3.495679535505747*^9, 3.495679554085773*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"q", " ", 
       SuperscriptBox["a", 
        RowBox[{"p", "+", 
         FractionBox["1", "n"]}]]}], "n"]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox[
        SuperscriptBox["x", 
         RowBox[{
          FractionBox["q", "n"], "-", "1"}]], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"b", " ", 
            SuperscriptBox["x", "q"]}]}], ")"}], 
         RowBox[{"p", "+", 
          FractionBox["1", "n"], "+", "1"}]]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     FractionBox[
      SuperscriptBox["x", 
       RowBox[{"n", "/", "q"}]], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "n"]}]}], ")"}], 
       RowBox[{"1", "/", "q"}]]]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.495678825124752*^9, 3.495678868624813*^9, 
   3.495678953284932*^9, 3.4956790561650763`*^9, {3.495679179585249*^9, 
   3.495679198215275*^9}, 3.4956794688056536`*^9, 3.495679563895787*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_"}]}]}], ")"}], "^", "p_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"q", "=", 
       RowBox[{"Denominator", "[", "p", "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{"Dist", "[", 
      RowBox[{
       RowBox[{"q", "*", 
        RowBox[{
         RowBox[{"a", "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"1", "/", "n"}]}], ")"}]}], "/", "n"}]}], ",", "\n", "\t", 
       RowBox[{"Subst", "[", 
        RowBox[{
         RowBox[{"Int", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"x", "^", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"q", "/", "n"}], "-", "1"}], ")"}]}], "/", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", 
               RowBox[{"b", "*", 
                RowBox[{"x", "^", "q"}]}]}], ")"}], "^", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"1", "/", "n"}], "+", "1"}], ")"}]}]}], ",", "x"}], 
          "]"}], ",", "x", ",", 
         RowBox[{
          RowBox[{"x", "^", 
           RowBox[{"(", 
            RowBox[{"n", "/", "q"}], ")"}]}], "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"x", "^", "n"}]}]}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{"1", "/", "q"}], ")"}]}]}]}], "]"}]}], "]"}]}], "]"}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"p", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"-", "1"}], "<", "p", "<", "0"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"p", "+", 
      RowBox[{"1", "/", "n"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.495678779164688*^9, 3.495678914664878*^9, 
   3.4956790358650475`*^9, 3.4956791378551903`*^9, 3.495679302665421*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "n"]}], ")"}], "m"]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, {
   3.495662009356209*^9, 3.495662018116221*^9}, {3.4956636612985215`*^9, 
   3.495663661698522*^9}, {3.4960750939600673`*^9, 3.4960751275501146`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.4954017382007885`*^9, 3.495489330658207*^9, 
   3.4954897113087397`*^9, 3.495494213539898*^9, {3.4954956544916067`*^9, 
   3.495495657128011*^9}, {3.495496267806684*^9, 3.495496280957507*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"f", "[", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "n"]}], ")"}], 
     RowBox[{"1", "/", "n"}]], "]"}], "=", 
   RowBox[{
    FractionBox["x", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "n"]}], ")"}], 
      RowBox[{"1", "/", "n"}]]], 
    RowBox[{"f", "[", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "n"]}], ")"}], 
      RowBox[{"1", "/", "n"}]], "]"}], 
    RowBox[{
     SubscriptBox["\[PartialD]", "x"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "n"]}], ")"}], 
      RowBox[{"1", "/", "n"}]]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, {
   3.495661733765823*^9, 3.4956617391558304`*^9}, {3.49566371027859*^9, 
   3.495663710948591*^9}, {3.4957633223685727`*^9, 3.4957633466186066`*^9}, {
   3.495763442538741*^9, 3.4957634435487423`*^9}, {3.4957635096288347`*^9, 
   3.495763524898856*^9}, {3.4957641622597485`*^9, 3.495764193169792*^9}, {
   3.4957643869900637`*^9, 3.4957643979100785`*^9}, 3.495766296257539*^9, {
   3.495947305200283*^9, 3.495947311705495*^9}, {3.4960751633901644`*^9, 
   3.496075166800169*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    FractionBox["x", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "n"]}], ")"}], 
      RowBox[{"1", "/", "n"}]]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, {
   3.495661733765823*^9, 3.4956617391558304`*^9}, {3.49566371027859*^9, 
   3.495663710948591*^9}, {3.49607516764017*^9, 3.4960751684401717`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", " ", "n"}], "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4956612341427097`*^9, 3.4956612366427135`*^9}, {
   3.4956628524073887`*^9, 3.495662852597389*^9}, {3.495662895317449*^9, 
   3.4956629260174923`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "n"]}], ")"}], "m"]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["x", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "n"]}], ")"}], 
       RowBox[{"1", "/", "n"}]]]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", 
            RowBox[{"m", " ", "n"}]]}]}], ")"}], "p"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "n"]}], ")"}], 
      RowBox[{"1", "/", "n"}]]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.495661218692688*^9, 3.495661221952693*^9}, 
   3.4956616963357706`*^9, 3.495661805075923*^9, {3.49566277463728*^9, 
   3.4956628145773363`*^9}, {3.4956637162785983`*^9, 3.495663722058606*^9}, {
   3.4960752027002196`*^9, 3.496075221240246*^9}, {3.49607527448032*^9, 
   3.4960753048303623`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"c_.", "*", 
           RowBox[{"x_", "^", "n_"}]}], ")"}], "^", "m_"}]}]}], ")"}], "^", 
     "p_."}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"x", "/", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "*", 
         RowBox[{"x", "^", "n"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"1", "/", "n"}], ")"}]}]}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", 
              RowBox[{"(", 
               RowBox[{"m", "*", "n"}], ")"}]}]}]}], ")"}], "^", "p"}], ",", 
         "x"}], "]"}], ",", "x", ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "n"}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "n"}], ")"}]}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "m", ",", "n", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"m", "*", "n"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4956611267125597`*^9, {3.495661897346052*^9, 3.495661964276146*^9}, {
   3.49566298892758*^9, 3.4956630698976936`*^9}, {3.4956638069387255`*^9, 
   3.4956638277087545`*^9}, {3.495948283326002*^9, 3.4959482886144114`*^9}, {
   3.496062774686449*^9, 3.496062778711256*^9}, {3.496075328800396*^9, 
   3.4960754037505007`*^9}, {3.4960758369211073`*^9, 3.4960758480811234`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.4954017382007885`*^9, 3.495489330658207*^9, 
   3.4954897113087397`*^9, 3.495494213539898*^9, {3.4954956544916067`*^9, 
   3.495495657128011*^9}, {3.495496267806684*^9, 3.495496280957507*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"f", "[", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "n"]}], ")"}], 
     RowBox[{"1", "/", "n"}]], "]"}], "=", 
   RowBox[{
    FractionBox["x", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "n"]}], ")"}], 
      RowBox[{"1", "/", "n"}]]], 
    RowBox[{"f", "[", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "n"]}], ")"}], 
      RowBox[{"1", "/", "n"}]], "]"}], 
    RowBox[{
     SubscriptBox["\[PartialD]", "x"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "n"]}], ")"}], 
      RowBox[{"1", "/", "n"}]]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, {
   3.495661733765823*^9, 3.4956617391558304`*^9}, {3.49566371027859*^9, 
   3.495663710948591*^9}, {3.4957633223685727`*^9, 3.4957633466186066`*^9}, {
   3.495763442538741*^9, 3.4957634435487423`*^9}, {3.4957635096288347`*^9, 
   3.495763524898856*^9}, {3.4957641622597485`*^9, 3.495764193169792*^9}, {
   3.4957643869900637`*^9, 3.4957643979100785`*^9}, 3.495766296257539*^9, {
   3.495947305200283*^9, 3.495947311705495*^9}, {3.4960751633901644`*^9, 
   3.496075166800169*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    FractionBox["x", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "n"]}], ")"}], 
      RowBox[{"1", "/", "n"}]]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, {
   3.495661733765823*^9, 3.4956617391558304`*^9}, {3.49566371027859*^9, 
   3.495663710948591*^9}, {3.49607516764017*^9, 3.4960751684401717`*^9}}],

Cell["Note: This previously unknown rule not yet implemented.", \
"Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.4954017382007885`*^9, 3.495489330658207*^9, 
   3.4954897113087397`*^9, 3.495494213539898*^9, {3.4954956544916067`*^9, 
   3.495495657128011*^9}, {3.495496267806684*^9, 3.495496280957507*^9}, {
   3.4969598991665545`*^9, 3.496959928666596*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4956612341427097`*^9, 3.4956612366427135`*^9}, {
   3.4956628524073887`*^9, 3.495662852597389*^9}, {3.495662895317449*^9, 
   3.4956629260174923`*^9}, 3.4957644927802114`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"f", "[", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "n"]}], ")"}], 
     RowBox[{"1", "/", "n"}]], "]"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["x", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "n"]}], ")"}], 
       RowBox[{"1", "/", "n"}]]]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       RowBox[{"f", "[", "x", "]"}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "n"]}], ")"}], 
      RowBox[{"1", "/", "n"}]]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.495661218692688*^9, 3.495661221952693*^9}, 
   3.4956616963357706`*^9, 3.495661805075923*^9, {3.49566277463728*^9, 
   3.4956628145773363`*^9}, {3.4956637162785983`*^9, 3.495663722058606*^9}, 
   3.4957638670393353`*^9, {3.495763933719429*^9, 3.495763947379448*^9}, {
   3.4957640219195523`*^9, 3.4957640222695527`*^9}, {3.4957642170798254`*^9, 
   3.495764231989846*^9}, {3.495764375370047*^9, 3.4957643792100525`*^9}, {
   3.4960751704301744`*^9, 3.4960751733201785`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, 
   3.49573324342616*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{3.4953915070313115`*^9, 3.495733269136196*^9}],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{
   FractionBox["n", 
    RowBox[{"m", "+", "1"}]], "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ",",
 " then",
 "  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], "p"]}], "=", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"m", "+", "1"}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          SuperscriptBox["x", 
           RowBox[{"m", "+", "1"}]], ")"}], 
         FractionBox["n", 
          RowBox[{"m", "+", "1"}]]]}]}], ")"}], "p"], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", "x"], 
     SuperscriptBox["x", 
      RowBox[{"m", "+", "1"}]]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, {
   3.495733647226725*^9, 3.4957337067668085`*^9}, {3.4957337504668703`*^9, 
   3.4957337673368936`*^9}, 3.4969608942479477`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    FractionBox["n", 
     RowBox[{"m", "+", "1"}]], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ",
    "\[And]", " ", 
   RowBox[{
    FractionBox["n", 
     RowBox[{"m", "+", "1"}]], ">", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4957333722063403`*^9, 3.495733468226475*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      RowBox[{"m", "+", "1"}]]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", 
            FractionBox["n", 
             RowBox[{"m", "+", "1"}]]]}]}], ")"}], "p"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     SuperscriptBox["x", 
      RowBox[{"m", "+", "1"}]]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.4957333101362534`*^9, 3.495733483146496*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_"}]}]}], ")"}], "^", "p_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", 
              RowBox[{"(", 
               RowBox[{"n", "/", 
                RowBox[{"(", 
                 RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}]}], ")"}], "^", 
          "p"}], ",", "x"}], "]"}], ",", "x", ",", 
       RowBox[{"x", "^", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m", ",", "n", ",", "p"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"n", "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"n", "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], ">", "1"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegersQ", "[", 
      RowBox[{"m", ",", "n", ",", "p"}], "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4957332604661837`*^9, {3.517189172396428*^9, 3.5171891763900347`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{3.49539151296132*^9, 3.495733819106966*^9}],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ",",
 " then",
 "  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], "p"]}], "=", 
   RowBox[{
    SuperscriptBox["x", 
     RowBox[{"m", "+", 
      RowBox[{"n", " ", "p"}]}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", "+", 
       FractionBox["a", 
        SuperscriptBox["x", "n"]]}], ")"}], "p"]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, {
   3.495733647226725*^9, 3.4957337067668085`*^9}, {3.4957337504668703`*^9, 
   3.4957337673368936`*^9}, {3.4957340231072516`*^9, 3.4957340415672774`*^9}, 
   3.495734076117326*^9, 3.4969609041779613`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"p", "<", "0"}], " ", "\[And]", " ", 
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", " ", 
   RowBox[{"n", "<", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.4957339078770905`*^9, 
   3.495733966267172*^9}, {3.495734148157427*^9, 3.4957341584974413`*^9}, {
   3.4957346698781567`*^9, 3.495734670108157*^9}, {3.495769697044301*^9, 
   3.4957696992543044`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"m", "+", 
         RowBox[{"n", " ", "p"}]}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"b", "+", 
          FractionBox["a", 
           SuperscriptBox["x", "n"]]}], ")"}], "p"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, {3.495733875467045*^9, 3.4957338981670766`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_"}]}]}], ")"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", 
         RowBox[{"n", "*", "p"}]}], ")"}]}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "+", 
         RowBox[{"a", "/", 
          RowBox[{"x", "^", "n"}]}]}], ")"}], "^", "p"}]}], ",", "x"}], "]"}],
    " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"IntegerQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", "0"}], " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4957338140769587`*^9, {3.495734137617412*^9, 
   3.4957341399074154`*^9}, {3.495734511017935*^9, 3.495734528517959*^9}, {
   3.4957696751742706`*^9, 3.495769684294283*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.110.3", "Subsubsection",
 CellChangeTimes->{3.49539151296132*^9, 3.495733819106966*^9, 
  3.4957347179982243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{3.49539151296132*^9, 3.495733819106966*^9, 
  3.4957347179982243`*^9, 3.495735008808632*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", 
    " ", 
    RowBox[{"p", ">", "0"}], " ", "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
        RowBox[{"m", "<", 
         RowBox[{"-", "1"}]}]}], ")"}], " ", "\[Or]", " ", 
      RowBox[{"0", "<", 
       RowBox[{"-", "n"}], "\[LessEqual]", 
       RowBox[{"m", "+", "1"}]}]}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.4957339078770905`*^9, 
   3.495733966267172*^9}, {3.495734148157427*^9, 3.4957341584974413`*^9}, {
   3.4957346698781567`*^9, 3.495734670108157*^9}, {3.4957347778783083`*^9, 
   3.4957348688784356`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}]}], ")"}], "p"]}], 
       RowBox[{"m", "+", "1"}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"b", " ", "n", " ", "p"}], 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "n"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}], 
      RowBox[{"p", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, {3.495733875467045*^9, 3.4957338981670766`*^9}, 
   3.4957347552282763`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_"}]}]}], ")"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], ")"}], "^", "p"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", "n", "*", 
       RowBox[{"p", "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "n"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "0"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"n", ">", "0"}], " ", "&&", " ", 
       RowBox[{"m", "<", 
        RowBox[{"-", "1"}]}]}], " ", "||", " ", 
      RowBox[{"0", "<", 
       RowBox[{"-", "n"}], "<=", 
       RowBox[{"m", "+", "1"}]}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4957338140769587`*^9, {3.495734137617412*^9, 
   3.4957341399074154`*^9}, {3.495734511017935*^9, 3.495734528517959*^9}, 
   3.4957347273482375`*^9, 3.517189127515149*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.110.4", "Subsubsection",
 CellChangeTimes->{3.49539151296132*^9, 3.495733819106966*^9, 
  3.4957347179982243`*^9, 3.4957350576387*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{3.49539151296132*^9, 3.495733819106966*^9, 
  3.4957347179982243`*^9, 3.495735008808632*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], "p"]}], "=", 
   RowBox[{
    SuperscriptBox["x", 
     RowBox[{"m", "-", "n", "+", "1"}]], 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "n"]}]}], ")"}], "p"], " ", 
      SuperscriptBox["x", 
       RowBox[{"n", "-", "1"}]]}], ")"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.49539151296132*^9, 3.495733819106966*^9, 3.4957347179982243`*^9, 
   3.495735008808632*^9, {3.4957350825087347`*^9, 3.4957351094187727`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", 
    " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"0", "<", "n", "\[LessEqual]", "m"}], " ", "\[Or]", " ", 
      RowBox[{"m", "\[LessEqual]", "n", "<", "0"}]}], ")"}], " ", "\[And]", 
    " ", 
    RowBox[{
     RowBox[{"m", "-", "n", "+", "1"}], "\[NotEqual]", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.4957339078770905`*^9, 
   3.495733966267172*^9}, {3.495734148157427*^9, 3.4957341584974413`*^9}, {
   3.4957346698781567`*^9, 3.495734670108157*^9}, {3.4957347778783083`*^9, 
   3.4957348688784356`*^9}, {3.4957353058790474`*^9, 
   3.4957353764991465`*^9}, {3.495735447019245*^9, 3.4957354738692827`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "-", "n", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}]}], ")"}], 
         RowBox[{"p", "+", "1"}]]}], 
       RowBox[{"b", " ", "n", " ", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"m", "-", "n", "+", "1"}], 
    RowBox[{"b", " ", "n", " ", 
     RowBox[{"(", 
      RowBox[{"p", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "n"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}], 
      RowBox[{"p", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, {3.495733875467045*^9, 3.4957338981670766`*^9}, 
   3.4957347552282763`*^9, 3.4957352122989163`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_"}]}]}], ")"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "n", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "n", "+", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", "n", "*", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "n"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"0", "<", "n", "<=", "m"}], " ", "||", " ", 
      RowBox[{"m", "<=", "n", "<", "0"}]}], ")"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "-", "n", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4957338140769587`*^9, {3.495734137617412*^9, 
   3.4957341399074154`*^9}, {3.495734511017935*^9, 3.495734528517959*^9}, 
   3.4957347273482375`*^9, 3.495735153298834*^9, {3.495735298589037*^9, 
   3.4957353008290405`*^9}, 3.5171891275463495`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.110.1, CRC 88b", "Subsubsection",
 CellChangeTimes->{3.49539151296132*^9, 3.495733819106966*^9, 
  3.4957347179982243`*^9, 3.4957350576387*^9, 3.495735590709446*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", " ", 
   RowBox[{"p", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"m", "+", 
     RowBox[{"n", " ", "p"}], "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]",
    " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{"m", "+", "1"}], "n"], "\[Element]", 
       "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
      RowBox[{
       FractionBox[
        RowBox[{"m", "+", "1"}], "n"], ">", "0"}]}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.4957339078770905`*^9, 
   3.495733966267172*^9}, {3.495734148157427*^9, 3.4957341584974413`*^9}, {
   3.4957346698781567`*^9, 3.495734670108157*^9}, {3.4957347778783083`*^9, 
   3.4957348688784356`*^9}, {3.4957353058790474`*^9, 
   3.4957353764991465`*^9}, {3.495735447019245*^9, 3.4957354738692827`*^9}, {
   3.495735673029561*^9, 3.495735708249611*^9}, {3.495735761689686*^9, 
   3.495735816759763*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}]}], ")"}], "p"]}], 
       RowBox[{"m", "+", 
        RowBox[{"n", " ", "p"}], "+", "1"}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"n", " ", "p", " ", "a"}], 
    RowBox[{"m", "+", 
     RowBox[{"n", " ", "p"}], "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}], 
      RowBox[{"p", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, {3.495733875467045*^9, 3.4957338981670766`*^9}, 
   3.4957347552282763`*^9, 3.4957352122989163`*^9, 3.495735613359478*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_"}]}]}], ")"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], ")"}], "^", "p"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", 
        RowBox[{"n", "*", "p"}], "+", "1"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "*", "p", "*", 
       RowBox[{"a", "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"n", "*", "p"}], "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m", ",", "n", ",", "p"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "0"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"n", "*", "p"}], "+", "1"}], "]"}], " ", "&&", "\n", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"IntegerQ", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "/", "n"}], "]"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "/", "n"}], ">", "0"}]}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4957338140769587`*^9, {3.495734137617412*^9, 
   3.4957341399074154`*^9}, {3.495734511017935*^9, 3.495734528517959*^9}, 
   3.4957347273482375`*^9, 3.495735153298834*^9, {3.495735298589037*^9, 
   3.4957353008290405`*^9}, 3.4957355751594243`*^9, {3.4957356510695305`*^9, 
   3.4957356533595343`*^9}, {3.495735877319847*^9, 3.495735880499852*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.110.2, CRC 88d", "Subsubsection",
 CellChangeTimes->{3.49539151296132*^9, 3.495733819106966*^9, 
  3.4957347179982243`*^9, 3.4957350576387*^9, 3.495735590709446*^9, 
  3.495735911829896*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", " ", 
   RowBox[{"p", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"m", "+", 
     RowBox[{"n", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], "\[NotEqual]", "0"}], 
   " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"m", "-", "n", "+", "1"}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.4957339078770905`*^9, 
   3.495733966267172*^9}, {3.495734148157427*^9, 3.4957341584974413`*^9}, {
   3.4957346698781567`*^9, 3.495734670108157*^9}, {3.4957347778783083`*^9, 
   3.4957348688784356`*^9}, {3.4957353058790474`*^9, 
   3.4957353764991465`*^9}, {3.495735447019245*^9, 3.4957354738692827`*^9}, {
   3.495735673029561*^9, 3.495735708249611*^9}, {3.495735761689686*^9, 
   3.495735816759763*^9}, {3.495735946519944*^9, 3.49573597169998*^9}, {
   3.495736053550094*^9, 3.4957360601001034`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox["x", 
          RowBox[{"m", "+", "1"}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox["x", "n"]}]}], ")"}], 
          RowBox[{"p", "+", "1"}]]}], 
        RowBox[{"a", " ", "n", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"m", "+", 
     RowBox[{"n", " ", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], 
    RowBox[{"a", " ", "n", " ", 
     RowBox[{"(", 
      RowBox[{"p", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}], 
      RowBox[{"p", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, {3.495733875467045*^9, 3.4957338981670766`*^9}, 
   3.4957347552282763`*^9, 3.4957352122989163`*^9, 3.495735613359478*^9, 
   3.495735935019928*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_"}]}]}], ")"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "n", "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", 
         RowBox[{"n", "*", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", "n", "*", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"n", "*", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "-", "n", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4957338140769587`*^9, {3.495734137617412*^9, 
   3.4957341399074154`*^9}, {3.495734511017935*^9, 3.495734528517959*^9}, 
   3.4957347273482375`*^9, 3.495735153298834*^9, {3.495735298589037*^9, 
   3.4957353008290405`*^9}, 3.4957355751594243`*^9, {3.4957356510695305`*^9, 
   3.4957356533595343`*^9}, {3.495735877319847*^9, 3.495735906059888*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.110.5, CRC 88a", "Subsubsection",
 CellChangeTimes->{3.49539151296132*^9, 3.495733819106966*^9, 
  3.4957347179982243`*^9, 3.4957350576387*^9, 3.495735590709446*^9, 
  3.495735911829896*^9, 3.495736224930334*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"m", "+", 
     RowBox[{"n", " ", "p"}], "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]",
    " ", 
   RowBox[{
    RowBox[{"m", "-", "n", "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", 
   " ", 
   RowBox[{
    RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.4957339078770905`*^9, 
   3.495733966267172*^9}, {3.495734148157427*^9, 3.4957341584974413`*^9}, {
   3.4957346698781567`*^9, 3.495734670108157*^9}, {3.4957347778783083`*^9, 
   3.4957348688784356`*^9}, {3.4957353058790474`*^9, 
   3.4957353764991465`*^9}, {3.495735447019245*^9, 3.4957354738692827`*^9}, {
   3.495735673029561*^9, 3.495735708249611*^9}, {3.495735761689686*^9, 
   3.495735816759763*^9}, {3.495735946519944*^9, 3.49573597169998*^9}, {
   3.495736053550094*^9, 3.4957360601001034`*^9}, {3.495736299670439*^9, 
   3.495736339970495*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "-", "n", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}]}], ")"}], 
         RowBox[{"p", "+", "1"}]]}], 
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"n", " ", "p"}], "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{"m", "-", "n", "+", "1"}], ")"}]}], 
    RowBox[{"b", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", 
       RowBox[{"n", " ", "p"}], "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "n"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}], "p"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, {3.495733875467045*^9, 3.4957338981670766`*^9}, 
   3.4957347552282763`*^9, 3.4957352122989163`*^9, 3.495735613359478*^9, 
   3.495735935019928*^9, 3.495736249160368*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], ")"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "n", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"n", "*", "p"}], "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "-", "n", "+", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"b", "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", 
            RowBox[{"n", "*", "p"}], "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "n"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], ")"}], "^", "p"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m", ",", "n", ",", "p"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"n", "*", "p"}], "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "-", "n", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}], " ", "&&", "\n", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegersQ", "[", 
      RowBox[{"m", ",", "n", ",", "p"}], "]"}], "]"}], " ", "&&", " ", "\n", 
    "\t", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"IntegersQ", "[", 
        RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"0", "<", "n", "<=", "m"}], " ", "||", " ", 
         RowBox[{"m", "<=", "n", "<", "0"}]}], ")"}], " ", "&&", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Not", "[", 
          RowBox[{"RationalQ", "[", "p", "]"}], "]"}], " ", "||", " ", 
         RowBox[{
          RowBox[{"-", "1"}], "<", "p", "<", "0"}]}], ")"}]}], " ", "||", " ",
       "\n", " \t", 
      RowBox[{
       RowBox[{"IntegerQ", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], "/", "n"}], "]"}], " ", "&&", " ", 
       RowBox[{"0", "<", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], "/", "n"}]}], " ", "&&", " ", 
       RowBox[{"Not", "[", 
        RowBox[{"FractionQ", "[", "n", "]"}], "]"}]}], " ", "||", " ", "\n", 
      "     ", 
      RowBox[{
       RowBox[{"Not", "[", 
        RowBox[{"RationalQ", "[", "m", "]"}], "]"}], " ", "&&", " ", 
       RowBox[{"RationalQ", "[", 
        RowBox[{"m", "-", "n"}], "]"}]}], " ", "||", " ", "\n", "     ", 
      RowBox[{
       RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
       RowBox[{"MatchQ", "[", 
        RowBox[{"m", ",", 
         RowBox[{
          RowBox[{"u_", "+", "q_"}], " ", "/;", " ", 
          RowBox[{
           RowBox[{"RationalQ", "[", "q", "]"}], " ", "&&", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"0", "<", "n", "<=", "q"}], " ", "||", " ", 
             RowBox[{
              RowBox[{"n", "<", "0"}], " ", "&&", " ", 
              RowBox[{"q", "<", "0"}]}]}], ")"}]}]}]}], "]"}]}], " ", "||", 
      " ", "\n", "     ", 
      RowBox[{"MatchQ", "[", 
       RowBox[{"m", ",", 
        RowBox[{
         RowBox[{"u_", "+", 
          RowBox[{"q_.", "*", "n"}]}], " ", "/;", " ", 
         RowBox[{
          RowBox[{"RationalQ", "[", "q", "]"}], " ", "&&", " ", 
          RowBox[{"q", ">=", "1"}]}]}]}], "]"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4957338140769587`*^9, {3.495734137617412*^9, 
   3.4957341399074154`*^9}, {3.495734511017935*^9, 3.495734528517959*^9}, 
   3.4957347273482375`*^9, 3.495735153298834*^9, {3.495735298589037*^9, 
   3.4957353008290405`*^9}, 3.4957355751594243`*^9, {3.4957356510695305`*^9, 
   3.4957356533595343`*^9}, {3.495735877319847*^9, 3.495735906059888*^9}, 
   3.495736215550321*^9, 3.517189127624349*^9, {3.5171891809920425`*^9, 
   3.517189184268049*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.110.6, CRC 88c", "Subsubsection",
 CellChangeTimes->{3.49539151296132*^9, 3.495733819106966*^9, 
  3.4957347179982243`*^9, 3.4957350576387*^9, 3.495735590709446*^9, 
  3.495735911829896*^9, 3.495736224930334*^9, 3.495736405400587*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"m", "+", 
     RowBox[{"n", " ", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.4957339078770905`*^9, 
   3.495733966267172*^9}, {3.495734148157427*^9, 3.4957341584974413`*^9}, {
   3.4957346698781567`*^9, 3.495734670108157*^9}, {3.4957347778783083`*^9, 
   3.4957348688784356`*^9}, {3.4957353058790474`*^9, 
   3.4957353764991465`*^9}, {3.495735447019245*^9, 3.4957354738692827`*^9}, {
   3.495735673029561*^9, 3.495735708249611*^9}, {3.495735761689686*^9, 
   3.495735816759763*^9}, {3.495735946519944*^9, 3.49573597169998*^9}, {
   3.495736053550094*^9, 3.4957360601001034`*^9}, {3.495736299670439*^9, 
   3.495736339970495*^9}, {3.495736448520647*^9, 3.4957364521006517`*^9}, {
   3.495736535060768*^9, 3.4957365497007885`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}]}], ")"}], 
         RowBox[{"p", "+", "1"}]]}], 
       RowBox[{"a", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"b", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", 
       RowBox[{"n", " ", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], ")"}]}], 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "n"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}], "p"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, {3.495733875467045*^9, 3.4957338981670766`*^9}, 
   3.4957347552282763`*^9, 3.4957352122989163`*^9, 3.495735613359478*^9, 
   3.495735935019928*^9, 3.495736249160368*^9, 3.49573642947062*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], ")"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"n", "*", 
           RowBox[{"(", 
            RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"a", "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "n"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], ")"}], "^", "p"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m", ",", "n", ",", "p"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"n", "*", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegersQ", "[", 
      RowBox[{"m", ",", "n", ",", "p"}], "]"}], "]"}], " ", "&&", " ", "\n", 
    "\t", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"IntegersQ", "[", 
        RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"n", ">", "0"}], " ", "&&", " ", 
          RowBox[{"m", "<", 
           RowBox[{"-", "1"}]}]}], " ", "||", " ", 
         RowBox[{"0", "<", 
          RowBox[{"-", "n"}], "<=", 
          RowBox[{"m", "+", "1"}]}]}], ")"}]}], " ", "||", "\n", "     ", 
      RowBox[{
       RowBox[{"Not", "[", 
        RowBox[{"RationalQ", "[", "m", "]"}], "]"}], " ", "&&", " ", 
       RowBox[{"RationalQ", "[", 
        RowBox[{"m", "+", "n"}], "]"}]}], " ", "||", "\n", "     ", 
      RowBox[{
       RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
       RowBox[{"MatchQ", "[", 
        RowBox[{"m", ",", 
         RowBox[{
          RowBox[{"u_", "+", "q_"}], " ", "/;", " ", 
          RowBox[{
           RowBox[{"RationalQ", "[", "q", "]"}], " ", "&&", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"n", ">", "0"}], " ", "&&", " ", 
              RowBox[{"q", "<", "0"}]}], " ", "||", " ", 
             RowBox[{"0", "<", 
              RowBox[{"-", "n"}], "<=", "q"}]}], ")"}]}]}]}], "]"}]}], " ", "||",
       " ", "\n", "     ", 
      RowBox[{"MatchQ", "[", 
       RowBox[{"m", ",", 
        RowBox[{
         RowBox[{"u_", "+", 
          RowBox[{"q_", "*", "n"}]}], " ", "/;", " ", 
         RowBox[{
          RowBox[{"RationalQ", "[", "q", "]"}], " ", "&&", " ", 
          RowBox[{"q", "<", "0"}]}]}]}], "]"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4957338140769587`*^9, {3.495734137617412*^9, 
   3.4957341399074154`*^9}, {3.495734511017935*^9, 3.495734528517959*^9}, 
   3.4957347273482375`*^9, 3.495735153298834*^9, {3.495735298589037*^9, 
   3.4957353008290405`*^9}, 3.4957355751594243`*^9, {3.4957356510695305`*^9, 
   3.4957356533595343`*^9}, {3.495735877319847*^9, 3.495735906059888*^9}, 
   3.495736215550321*^9, 3.4957363975705757`*^9, {3.4957365122607365`*^9, 
   3.4957365162407417`*^9}, 3.517189127655549*^9, {3.5171891882772555`*^9, 
   3.5171891915532618`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.49539151296132*^9, 3.495678787084699*^9, 3.4956789080048685`*^9, 
   3.4956790295250387`*^9, 3.495679129075178*^9, {3.495679335075466*^9, 
   3.4956793607555027`*^9}, {3.495679674485942*^9, 3.4956796884659615`*^9}}],

Cell[TextData[{
 "Note: Transforms ",
 Cell[BoxData["p"]],
 " into an integer."
}], "Subsubsection",
 CellChangeTimes->{
  3.49539151296132*^9, 3.495733819106966*^9, 3.4957347179982243`*^9, 
   3.4957350576387*^9, 3.495735590709446*^9, 3.495735911829896*^9, 
   3.495736224930334*^9, 3.495736405400587*^9, {3.495736598320857*^9, 
   3.495736626100896*^9}, 3.4957366611509447`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "<", "p", "<", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"p", "+", 
      FractionBox[
       RowBox[{"m", "+", "1"}], "n"]}], "\[Element]", 
     "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
    RowBox[{"gcd", "[", 
     RowBox[{
      RowBox[{"m", "+", "1"}], ",", "n"}], "]"}]}], "=", "1"}]]],
 ", let ",
 Cell[BoxData[
  RowBox[{"q", "=", 
   RowBox[{"Denominator", "[", "p", "]"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.495678797624714*^9, 
   3.4956788080547285`*^9}, 3.4956788502147875`*^9, {3.4956789897249827`*^9, 
   3.495679002425001*^9}, {3.495679072285098*^9, 3.4956790738051004`*^9}, {
   3.495679236085328*^9, 3.495679236315328*^9}, {3.49567937329552*^9, 
   3.4956794246455917`*^9}, {3.495679535505747*^9, 3.495679554085773*^9}, {
   3.4957367923611283`*^9, 3.495736827891178*^9}, {3.495736877611248*^9, 
   3.495736878151249*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"q", " ", 
       SuperscriptBox["a", 
        RowBox[{"p", "+", 
         FractionBox[
          RowBox[{"m", "+", "1"}], "n"]}]]}], "n"]}]}], " ", 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox[
        SuperscriptBox["x", 
         RowBox[{
          FractionBox[
           RowBox[{"q", " ", 
            RowBox[{"(", 
             RowBox[{"m", "+", "1"}], ")"}]}], "n"], "-", "1"}]], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"b", " ", 
            SuperscriptBox["x", "q"]}]}], ")"}], 
         RowBox[{"p", "+", 
          FractionBox[
           RowBox[{"m", "+", "1"}], "n"], "+", "1"}]]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     FractionBox[
      SuperscriptBox["x", 
       RowBox[{"n", "/", "q"}]], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "n"]}]}], ")"}], 
       RowBox[{"1", "/", "q"}]]]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, {3.495733875467045*^9, 3.4957338981670766`*^9}, 
   3.4957347552282763`*^9, 3.4957352122989163`*^9, 3.495735613359478*^9, 
   3.495735935019928*^9, 3.495736249160368*^9, 3.49573642947062*^9, 
   3.4957367601410837`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_"}]}]}], ")"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"q", "=", 
       RowBox[{"Denominator", "[", "p", "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{"q", "*", 
      RowBox[{
       RowBox[{"a", "^", 
        RowBox[{"(", 
         RowBox[{"p", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"m", "+", "1"}], ")"}], "/", "n"}]}], ")"}]}], "/", "n"}],
       "*", "\n", "\t", 
      RowBox[{"Subst", "[", 
       RowBox[{
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"q", "*", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"m", "+", "1"}], ")"}], "/", "n"}]}], "-", "1"}], 
             ")"}]}], "/", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{"b", "*", 
               RowBox[{"x", "^", "q"}]}]}], ")"}], "^", 
            RowBox[{"(", 
             RowBox[{"p", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"m", "+", "1"}], ")"}], "/", "n"}], "+", "1"}], 
             ")"}]}]}], ",", "x"}], "]"}], ",", "x", ",", 
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"n", "/", "q"}], ")"}]}], "/", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"1", "/", "q"}], ")"}]}]}]}], "]"}]}]}], "]"}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n", ",", "p"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"-", "1"}], "<", "p", "<", "0"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"p", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "/", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"GCD", "[", 
      RowBox[{
       RowBox[{"m", "+", "1"}], ",", "n"}], "]"}], "==", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4957338140769587`*^9, {3.495734137617412*^9, 
   3.4957341399074154`*^9}, {3.495734511017935*^9, 3.495734528517959*^9}, 
   3.4957347273482375`*^9, 3.495735153298834*^9, {3.495735298589037*^9, 
   3.4957353008290405`*^9}, 3.4957355751594243`*^9, {3.4957356510695305`*^9, 
   3.4957356533595343`*^9}, {3.495735877319847*^9, 3.495735906059888*^9}, 
   3.495736215550321*^9, 3.4957363975705757`*^9, {3.4957365122607365`*^9, 
   3.4957365162407417`*^9}, 3.4957365909208465`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "m"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, 
   3.4957666675480585`*^9, {3.4957667950782375`*^9, 3.495766797728241*^9}, {
   3.49576734745901*^9, 3.495767347909011*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"m", " ", "p"}], "-", "n", "+", "1"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"p", "+", "1"}], "\[NotEqual]", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4957668520783167`*^9, 3.4957668817383585`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "m"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "m"], " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}]}], ")"}]}], ")"}], 
       RowBox[{"p", "+", "1"}]], 
      RowBox[{"b", " ", "n", " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}], " ", 
       SuperscriptBox["x", 
        RowBox[{"m", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}]}]]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.4957667021881075`*^9, 3.495766731718148*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x_", "^", "m_."}], "*", 
       RowBox[{"(", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"x_", "^", "n_."}]}]}], ")"}]}], ")"}], "^", "p_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "m"}], "*", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], ")"}]}], ")"}], "^", 
     RowBox[{"(", 
      RowBox[{"p", "+", "1"}], ")"}]}], "/", 
    RowBox[{"(", 
     RowBox[{"b", "*", "n", "*", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}], "*", 
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"m", "*", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], ")"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m", ",", "n", ",", "p"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"m", "*", "p"}], "-", "n", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"p", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.49576668266808*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"m", " ", "p"}], "+", 
    RowBox[{"n", " ", 
     RowBox[{"(", 
      RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"p", "+", "1"}], "\[NotEqual]", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.4957669003183846`*^9, 
   3.495766906158393*^9}, {3.4957671335887113`*^9, 3.4957671409787216`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "m"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "m"], " ", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox["x", "n"]}]}], ")"}]}], ")"}], 
        RowBox[{"p", "+", "1"}]], 
       RowBox[{"a", " ", "n", " ", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}], " ", 
        SuperscriptBox["x", 
         RowBox[{"m", "-", "1"}]]}]]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4957667772682123`*^9, 3.495766807868255*^9, 
   3.4957671159886866`*^9, 3.4957671665887575`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x_", "^", "m_."}], "*", 
       RowBox[{"(", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"x_", "^", "n_."}]}]}], ")"}]}], ")"}], "^", "p_."}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "m"}], "*", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"x", "^", "n"}]}]}], ")"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}]}], "/", 
    RowBox[{"(", 
     RowBox[{"a", "*", "n", "*", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}], "*", 
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"m", "-", "1"}], ")"}]}]}], ")"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m", ",", "n", ",", "p"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"m", "*", "p"}], "+", 
      RowBox[{"n", "*", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"p", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4957666893580894`*^9, {3.4957669395384398`*^9, 
   3.49576696833848*^9}, 3.4957671007786655`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "q"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "m"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, 
   3.4957666675480585`*^9, {3.4957667950782375`*^9, 3.495766797728241*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"q", "+", 
    RowBox[{"m", " ", "p"}], "-", "n", "+", "1"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"p", "+", "1"}], "\[NotEqual]", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.4957669003183846`*^9, 
   3.495766906158393*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "q"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "m"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "m"], " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}]}], ")"}]}], ")"}], 
       RowBox[{"p", "+", "1"}]], 
      RowBox[{"b", " ", "n", " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}], " ", 
       SuperscriptBox["x", 
        RowBox[{"m", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}]}]]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4957667772682123`*^9, 3.495766807868255*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "q_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x_", "^", "m_."}], "*", 
        RowBox[{"(", 
         RowBox[{"a_", "+", 
          RowBox[{"b_.", "*", 
           RowBox[{"x_", "^", "n_."}]}]}], ")"}]}], ")"}], "^", "p_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "m"}], "*", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], ")"}]}], ")"}], "^", 
     RowBox[{"(", 
      RowBox[{"p", "+", "1"}], ")"}]}], "/", 
    RowBox[{"(", 
     RowBox[{"b", "*", "n", "*", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}], "*", 
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"m", "*", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], ")"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m", ",", "n", ",", "p"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"q", "+", 
      RowBox[{"m", "*", "p"}], "-", "n", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"p", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4957666893580894`*^9, {3.4957669395384398`*^9, 
   3.49576696833848*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"q", "+", 
    RowBox[{"m", " ", "p"}], "+", 
    RowBox[{"n", " ", 
     RowBox[{"(", 
      RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"p", "+", "1"}], "\[NotEqual]", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.4957669003183846`*^9, 
   3.495766906158393*^9}, {3.495767224988839*^9, 3.495767228668844*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "q"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "m"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "m"], " ", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox["x", "n"]}]}], ")"}]}], ")"}], 
        RowBox[{"p", "+", "1"}]], 
       RowBox[{"a", " ", "n", " ", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}], " ", 
        SuperscriptBox["x", 
         RowBox[{"m", "-", "1", "-", "q"}]]}]]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4957667772682123`*^9, 3.495766807868255*^9, 
   3.495767272608906*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "q_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x_", "^", "m_."}], "*", 
        RowBox[{"(", 
         RowBox[{"a_", "+", 
          RowBox[{"b_.", "*", 
           RowBox[{"x_", "^", "n_."}]}]}], ")"}]}], ")"}], "^", "p_."}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "m"}], "*", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"x", "^", "n"}]}]}], ")"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}]}], "/", 
    RowBox[{"(", 
     RowBox[{"a", "*", "n", "*", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}], "*", 
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"m", "-", "1", "-", "q"}], ")"}]}]}], ")"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m", ",", "n", ",", "p", ",", "q"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"q", "+", 
      RowBox[{"m", "*", "p"}], "+", 
      RowBox[{"n", "*", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"p", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4957666893580894`*^9, {3.4957669395384398`*^9, 
   3.49576696833848*^9}, {3.495767191798793*^9, 3.495767213748823*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "m"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, 
   3.4957666675480585`*^9, {3.4957667950782375`*^9, 3.495766797728241*^9}, 
   3.495817767811921*^9, {3.4958215712950325`*^9, 3.495821600825885*^9}, {
   3.498606011544393*^9, 3.4986060154444*^9}, 3.498791825045905*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495733269136196*^9, 3.4958180204322743`*^9, {
   3.498790415276228*^9, 3.498790427132249*^9}}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"b", " ", "c"}], "-", 
    RowBox[{"a", " ", "d"}]}], "=", "0"}]]],
 " and  ",
 Cell[BoxData[
  RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "m"], "=", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["b", "d"], ")"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "m"]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495733269136196*^9, 3.4958180204322743`*^9, {
   3.498790415276228*^9, 3.498790427132249*^9}, {3.498790625383397*^9, 
   3.4987906379882193`*^9}, {3.49879077484726*^9, 3.498790863190215*^9}, {
   3.498790896340273*^9, 3.4987909105986986`*^9}, {3.498790950597169*^9, 
   3.498790974777211*^9}, {3.4987918281347103`*^9, 3.4987918299755135`*^9}, 
   3.498791908272051*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"b", " ", "c"}], "-", 
    RowBox[{"a", " ", "d"}]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.4957669003183846`*^9, 
   3.495766906158393*^9}, {3.4958177882919493`*^9, 3.495817793751957*^9}, {
   3.498790486521553*^9, 3.498790535090439*^9}, {3.4987918303811145`*^9, 
   3.4987918303811145`*^9}, {3.498791909878854*^9, 3.498791909878854*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "m"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["b", "d"], ")"}], "m"]}]}], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], 
      RowBox[{"n", "+", "m"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4957667772682123`*^9, 3.495766807868255*^9, 
   3.4958178099519796`*^9, {3.4958178912220936`*^9, 3.49581790991212*^9}, 
   3.4986070768034644`*^9, {3.4987905501288652`*^9, 3.498790570533701*^9}, {
   3.4987909985360527`*^9, 3.4987910184104877`*^9}, {3.4987918310675154`*^9, 
   3.498791833064319*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b", "/", "d"}], ")"}], "^", "m"}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", 
           RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"n", "+", "m"}], ")"}]}], ",", "x"}], "]"}]}], "]"}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "c"}], "-", 
      RowBox[{"a", "*", "d"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4957666893580894`*^9, {3.4957669395384398`*^9, 
   3.49576696833848*^9}, 3.4958177798619375`*^9, {3.4986070917482905`*^9, 
   3.498607096490699*^9}, {3.4987910745081863`*^9, 3.4987911015274334`*^9}, {
   3.4987911322594876`*^9, 3.498791177343567*^9}, 3.4987912538929014`*^9, {
   3.498791834203121*^9, 3.498791836231125*^9}, 3.498791957396538*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: CRC 232, A&S 3.3.50'", "Subsubsection",
 CellChangeTimes->{3.4953915070313115`*^9, 3.495733269136196*^9, 
  3.4958180204322743`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"a", " ", "d"}], "-", 
     RowBox[{"b", " ", "c"}]}], "a"], ">", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.4957669003183846`*^9, 
   3.495766906158393*^9}, {3.495767224988839*^9, 3.495767228668844*^9}, {
   3.4958181947725186`*^9, 3.495818206722535*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], " ", 
     SqrtBox[
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      RowBox[{"a", " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          RowBox[{"a", " ", "d"}], "-", 
          RowBox[{"b", " ", "c"}]}], "a"]]}]]}]}], 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     RowBox[{"x", " ", 
      SqrtBox[
       FractionBox[
        RowBox[{
         RowBox[{"a", " ", "d"}], "-", 
         RowBox[{"b", " ", "c"}]}], "a"]]}], 
     SqrtBox[
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4957667772682123`*^9, 3.495766807868255*^9, 
   3.495767272608906*^9, {3.4958181493724546`*^9, 3.495818158032467*^9}, {
   3.4962838446005373`*^9, 3.496283848290542*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], ")"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcTanh", "[", 
     RowBox[{"x", "*", 
      RowBox[{
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"a", "*", "d"}], "-", 
            RowBox[{"b", "*", "c"}]}], ")"}], "/", "a"}], ",", "2"}], "]"}], 
       "/", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", 
          RowBox[{"x", "^", "2"}]}]}], "]"}]}]}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"a", "*", 
      RowBox[{"Rt", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "*", "d"}], "-", 
           RowBox[{"b", "*", "c"}]}], ")"}], "/", "a"}], ",", "2"}], "]"}]}], 
     ")"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"PosQ", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "*", "d"}], "-", 
        RowBox[{"b", "*", "c"}]}], ")"}], "/", "a"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4957666893580894`*^9, {3.4957669395384398`*^9, 
   3.49576696833848*^9}, {3.495767191798793*^9, 3.495767213748823*^9}, 
   3.4958180273522844`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: CRC 233, A&S 3.3.49", "Subsubsection",
 CellChangeTimes->{3.4953915070313115`*^9, 3.495733269136196*^9, 
  3.4958180204322743`*^9, 3.4958182231325583`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"\[Not]", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"a", " ", "d"}], "-", 
       RowBox[{"b", " ", "c"}]}], "a"], ">", "0"}], ")"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.4957669003183846`*^9, 
   3.495766906158393*^9}, {3.495767224988839*^9, 3.495767228668844*^9}, {
   3.4958181947725186`*^9, 3.495818206722535*^9}, {3.4958183089026785`*^9, 
   3.4958183132526846`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], " ", 
     SqrtBox[
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      RowBox[{"a", " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          RowBox[{"b", " ", "c"}], "-", 
          RowBox[{"a", " ", "d"}]}], "a"]]}]]}]}], 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{"x", " ", 
      SqrtBox[
       FractionBox[
        RowBox[{
         RowBox[{"b", " ", "c"}], "-", 
         RowBox[{"a", " ", "d"}]}], "a"]]}], 
     SqrtBox[
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4957667772682123`*^9, 3.495766807868255*^9, 
   3.495767272608906*^9, {3.4958181493724546`*^9, 3.495818158032467*^9}, 
   3.495818276792633*^9, {3.4962838549105515`*^9, 3.4962838575105553`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], ")"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcTan", "[", 
     RowBox[{"x", "*", 
      RowBox[{
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"b", "*", "c"}], "-", 
            RowBox[{"a", "*", "d"}]}], ")"}], "/", "a"}], ",", "2"}], "]"}], 
       "/", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", 
          RowBox[{"x", "^", "2"}]}]}], "]"}]}]}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"a", "*", 
      RowBox[{"Rt", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", "*", "c"}], "-", 
           RowBox[{"a", "*", "d"}]}], ")"}], "/", "a"}], ",", "2"}], "]"}]}], 
     ")"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NegQ", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "*", "d"}], "-", 
        RowBox[{"b", "*", "c"}]}], ")"}], "/", "a"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4957666893580894`*^9, {3.4957669395384398`*^9, 
   3.49576696833848*^9}, {3.495767191798793*^9, 3.495767213748823*^9}, 
   3.4958180273522844`*^9, 3.495818229532567*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"c", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.4957669003183846`*^9, 
   3.495766906158393*^9}, {3.495767224988839*^9, 3.495767228668844*^9}, {
   3.4958181947725186`*^9, 3.495818206722535*^9}, {3.4958183089026785`*^9, 
   3.4958183132526846`*^9}, {3.495819008440531*^9, 3.495819027129363*^9}, {
   3.495819632691227*^9, 3.495819633830029*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}]}]], " ", 
     SqrtBox[
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      RowBox[{
       SqrtBox["a"], 
       SqrtBox["c"], " ", 
       SqrtBox[
        RowBox[{"-", 
         FractionBox["d", "c"]}]]}]]}]}], "  ", 
   RowBox[{"EllipticF", "[", 
    RowBox[{
     RowBox[{"ArcSin", "[", 
      RowBox[{
       SqrtBox[
        RowBox[{"-", 
         FractionBox["d", "c"]}]], " ", "x"}], "]"}], ",", 
     FractionBox[
      RowBox[{"b", " ", "c"}], 
      RowBox[{"a", " ", "d"}]]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4957667772682123`*^9, 3.495766807868255*^9, 
   3.495767272608906*^9, {3.4958181493724546`*^9, 3.495818158032467*^9}, 
   3.495818276792633*^9, {3.49581880288337*^9, 3.4958188220418024`*^9}, {
   3.495819743810222*^9, 3.495819760174651*^9}, 3.497050448761874*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], "]"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", "a", "]"}], "*", 
       RowBox[{"Sqrt", "[", "c", "]"}], "*", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "d"}], "/", "c"}], ",", "2"}], "]"}]}], ")"}]}], "*", 
    RowBox[{"EllipticF", "[", 
     RowBox[{
      RowBox[{"ArcSin", "[", 
       RowBox[{
        RowBox[{"Rt", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "d"}], "/", "c"}], ",", "2"}], "]"}], "*", "x"}], 
       "]"}], ",", " ", 
      RowBox[{"b", "*", 
       RowBox[{"c", "/", 
        RowBox[{"(", 
         RowBox[{"a", "*", "d"}], ")"}]}]}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", "a", "]"}], " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", "c", "]"}], " ", "&&", "\n", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"PosQ", "[", 
        RowBox[{
         RowBox[{"-", "c"}], "*", "d"}], "]"}], " ", "&&", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"NegQ", "[", 
          RowBox[{
           RowBox[{"-", "a"}], "*", "b"}], "]"}], " ", "||", " ", 
         RowBox[{"Not", "[", 
          RowBox[{"RationalQ", "[", 
           RowBox[{"Rt", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "a"}], "*", "b"}], ",", "2"}], "]"}], "]"}], 
          "]"}]}], ")"}]}], " ", "||", " ", 
      RowBox[{
       RowBox[{"NegQ", "[", 
        RowBox[{
         RowBox[{"-", "c"}], "*", "d"}], "]"}], " ", "&&", " ", 
       RowBox[{"NegQ", "[", 
        RowBox[{
         RowBox[{"-", "a"}], "*", "b"}], "]"}], " ", "&&", "\n", 
       RowBox[{"Not", "[", 
        RowBox[{"RationalQ", "[", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{"a", "*", "b"}], ",", "2"}], "]"}], "]"}], "]"}]}]}], 
     ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4957666893580894`*^9, {3.4957669395384398`*^9, 
   3.49576696833848*^9}, {3.495767191798793*^9, 3.495767213748823*^9}, 
   3.4958180273522844`*^9, 3.495818229532567*^9, 3.495818362412753*^9, {
   3.4958188945759306`*^9, 3.4958189716088657`*^9}, {3.495819620601206*^9, 
   3.4958196243140125`*^9}, {3.495820259266328*^9, 3.4958202890155797`*^9}, {
   3.495820793555667*^9, 3.4958207946164684`*^9}, {3.495822898430165*^9, 
   3.495822940659439*^9}, {3.4958229910475273`*^9, 3.4958230106255617`*^9}, {
   3.4958233002508717`*^9, 3.495823300718872*^9}, {3.4958258068236427`*^9, 
   3.4958258326436787`*^9}, {3.4958559306044483`*^9, 
   3.4958559349856987`*^9}, {3.496081042290396*^9, 3.4960810455504007`*^9}, {
   3.4960810761204433`*^9, 3.4960810806504498`*^9}, {3.496081119330504*^9, 
   3.4960811386405315`*^9}, {3.496283891640603*^9, 3.4962838926806045`*^9}, {
   3.4970505188371973`*^9, 3.497050547120047*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495733269136196*^9, 3.4958180204322743`*^9, 
   3.4958182231325583`*^9, {3.4986075703883314`*^9, 3.4986075816671515`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    FractionBox[
     SqrtBox[
      FractionBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "2"]}]}], "a"]], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}]}]]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495733269136196*^9, 3.4958180204322743`*^9, 
   3.4958182231325583`*^9, {3.4986075703883314`*^9, 3.4986075816671515`*^9}, {
   3.498607739013028*^9, 3.498607796421129*^9}, 3.498608168143383*^9, {
   3.498609058962948*^9, 3.498609058962948*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"\[Not]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"a", ">", "0"}], " ", "\[And]", " ", 
     RowBox[{"c", ">", "0"}]}], ")"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.4957669003183846`*^9, 
   3.495766906158393*^9}, {3.495767224988839*^9, 3.495767228668844*^9}, {
   3.4958181947725186`*^9, 3.495818206722535*^9}, {3.4958183089026785`*^9, 
   3.4958183132526846`*^9}, {3.495819008440531*^9, 3.495819027129363*^9}, {
   3.4958196672920876`*^9, 3.495819677884506*^9}, {3.4958208928966413`*^9, 
   3.4958208987310514`*^9}, {3.4960821228019085`*^9, 3.4960821228019085`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}]}]], " ", 
     SqrtBox[
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SqrtBox[
        FractionBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", "2"]}]}], "a"]], " ", 
       SqrtBox[
        FractionBox[
         RowBox[{"c", "+", 
          RowBox[{"d", " ", 
           SuperscriptBox["x", "2"]}]}], "c"]]}], 
      RowBox[{
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "2"]}]}]], " ", 
       SqrtBox[
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}]]}]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{
       SqrtBox[
        RowBox[{"1", "+", 
         RowBox[{
          FractionBox["b", "a"], " ", 
          SuperscriptBox["x", "2"]}]}]], " ", 
       SqrtBox[
        RowBox[{"1", "+", 
         RowBox[{
          FractionBox["d", "c"], " ", 
          SuperscriptBox["x", "2"]}]}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4957667772682123`*^9, 3.495766807868255*^9, 
   3.495767272608906*^9, {3.4958181493724546`*^9, 3.495818158032467*^9}, 
   3.495818276792633*^9, {3.49581880288337*^9, 3.4958188220418024`*^9}, 
   3.49581971997338*^9, {3.4958197713130703`*^9, 3.4958197881455*^9}, {
   3.4970505668696814`*^9, 3.4970505873525176`*^9}, {3.4986075356470704`*^9, 
   3.498607542199082*^9}, {3.4986076252848277`*^9, 3.4986076662661*^9}, {
   3.498607708546175*^9, 3.498607715441387*^9}, 3.498609055172141*^9, 
   3.4986090988210173`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], "]"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "/", "a"}], "]"}], "*", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", 
          RowBox[{"x", "^", "2"}]}]}], ")"}], "/", "c"}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "2"}]}]}], "]"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", 
          RowBox[{"x", "^", "2"}]}]}], "]"}]}], ")"}]}], "*", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Sqrt", "[", 
          RowBox[{"1", "+", 
           RowBox[{
            RowBox[{"b", "/", "a"}], "*", 
            RowBox[{"x", "^", "2"}]}]}], "]"}], "*", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"1", "+", 
           RowBox[{
            RowBox[{"d", "/", "c"}], "*", 
            RowBox[{"x", "^", "2"}]}]}], "]"}]}], ")"}]}], ",", "x"}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"PositiveQ", "[", "a", "]"}], " ", "&&", " ", 
      RowBox[{"PositiveQ", "[", "c", "]"}]}], "]"}], " ", "&&", "\n", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"PosQ", "[", 
        RowBox[{
         RowBox[{"-", "c"}], "*", "d"}], "]"}], " ", "&&", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"NegQ", "[", 
          RowBox[{
           RowBox[{"-", "a"}], "*", "b"}], "]"}], " ", "||", " ", 
         RowBox[{"Not", "[", 
          RowBox[{"RationalQ", "[", 
           RowBox[{"Rt", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "a"}], "*", "b"}], ",", "2"}], "]"}], "]"}], 
          "]"}]}], ")"}]}], " ", "||", " ", 
      RowBox[{
       RowBox[{"NegQ", "[", 
        RowBox[{
         RowBox[{"-", "c"}], "*", "d"}], "]"}], " ", "&&", " ", 
       RowBox[{"NegQ", "[", 
        RowBox[{
         RowBox[{"-", "a"}], "*", "b"}], "]"}], " ", "&&", "\n", 
       RowBox[{"Not", "[", 
        RowBox[{"RationalQ", "[", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{"a", "*", "b"}], ",", "2"}], "]"}], "]"}], "]"}]}]}], 
     ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4957666893580894`*^9, {3.4957669395384398`*^9, 
   3.49576696833848*^9}, {3.495767191798793*^9, 3.495767213748823*^9}, 
   3.4958180273522844`*^9, 3.495818229532567*^9, 3.495818362412753*^9, {
   3.4958188945759306`*^9, 3.4958189716088657`*^9}, 3.4958191437239685`*^9, {
   3.4958198431667967`*^9, 3.495819854804417*^9}, {3.4958201761025815`*^9, 
   3.495820242012697*^9}, {3.495820957667955*^9, 3.4958209643447666`*^9}, {
   3.4958258670737267`*^9, 3.4958258735937357`*^9}, {3.49608170914133*^9, 
   3.4960817119813337`*^9}, {3.4960817601514015`*^9, 
   3.4960817652814083`*^9}, {3.4962838962906094`*^9, 3.49628389678061*^9}, {
   3.497050609083356*^9, 3.4970506528102326`*^9}, {3.4986012814628825`*^9, 
   3.498601281681283*^9}, {3.4986079222509503`*^9, 3.4986079713958373`*^9}, {
   3.4986091738539495`*^9, 3.498609189984378*^9}, 3.498609239561265*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"c", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.4957669003183846`*^9, 
   3.495766906158393*^9}, {3.495767224988839*^9, 3.495767228668844*^9}, {
   3.4958181947725186`*^9, 3.495818206722535*^9}, {3.4958183089026785`*^9, 
   3.4958183132526846`*^9}, {3.495819008440531*^9, 3.495819027129363*^9}, {
   3.495819632691227*^9, 3.495819633830029*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    SqrtBox[
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SqrtBox["a"], 
      RowBox[{
       SqrtBox["c"], 
       SqrtBox[
        RowBox[{"-", 
         FractionBox["d", "c"]}]]}]]}]}], 
   RowBox[{"EllipticE", "[", 
    RowBox[{
     RowBox[{"ArcSin", "[", 
      RowBox[{
       SqrtBox[
        RowBox[{"-", 
         FractionBox["d", "c"]}]], " ", "x"}], "]"}], ",", 
     FractionBox[
      RowBox[{"b", " ", "c"}], 
      RowBox[{"a", " ", "d"}]]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4957667772682123`*^9, 3.495766807868255*^9, 
   3.495767272608906*^9, {3.4958181493724546`*^9, 3.495818158032467*^9}, 
   3.495818276792633*^9, {3.49581880288337*^9, 3.4958188220418024`*^9}, {
   3.495819743810222*^9, 3.495819760174651*^9}, 3.4958206555890245`*^9, {
   3.4958208241317205`*^9, 3.4958208282969275`*^9}, {3.4970506844470882`*^9, 
   3.497050730467169*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"c_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", "a", "]"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", "c", "]"}], "*", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "d"}], "/", "c"}], ",", "2"}], "]"}]}], ")"}]}], "*", 
    RowBox[{"EllipticE", "[", 
     RowBox[{
      RowBox[{"ArcSin", "[", 
       RowBox[{
        RowBox[{"Rt", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "d"}], "/", "c"}], ",", "2"}], "]"}], "*", "x"}], 
       "]"}], ",", " ", 
      RowBox[{"b", "*", 
       RowBox[{"c", "/", 
        RowBox[{"(", 
         RowBox[{"a", "*", "d"}], ")"}]}]}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", "a", "]"}], " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", "c", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4957666893580894`*^9, {3.4957669395384398`*^9, 
   3.49576696833848*^9}, {3.495767191798793*^9, 3.495767213748823*^9}, 
   3.4958180273522844`*^9, 3.495818229532567*^9, 3.495818362412753*^9, {
   3.4958188945759306`*^9, 3.4958189716088657`*^9}, {3.495819620601206*^9, 
   3.4958196243140125`*^9}, {3.495820259266328*^9, 3.4958202890155797`*^9}, 
   3.495820517353181*^9, {3.4958206819530706`*^9, 3.4958207279107513`*^9}, {
   3.497050788390071*^9, 3.4970508202765265`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495733269136196*^9, 3.4958180204322743`*^9, 
   3.4958182231325583`*^9, {3.4986075703883314`*^9, 3.4986075816671515`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    FractionBox[
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     SqrtBox[
      FractionBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "2"]}]}], "a"]]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495733269136196*^9, 3.4958180204322743`*^9, 
   3.4958182231325583`*^9, {3.4986075703883314`*^9, 3.4986075816671515`*^9}, {
   3.498607739013028*^9, 3.498607796421129*^9}, {3.498608131171318*^9, 
   3.4986081521221547`*^9}, {3.49860818360301*^9, 3.498608199109437*^9}, {
   3.498609081099386*^9, 3.498609081099386*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"\[Not]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"a", ">", "0"}], " ", "\[And]", " ", 
     RowBox[{"c", ">", "0"}]}], ")"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.4957669003183846`*^9, 
   3.495766906158393*^9}, {3.495767224988839*^9, 3.495767228668844*^9}, {
   3.4958181947725186`*^9, 3.495818206722535*^9}, {3.4958183089026785`*^9, 
   3.4958183132526846`*^9}, {3.495819008440531*^9, 3.495819027129363*^9}, {
   3.4958196672920876`*^9, 3.495819677884506*^9}, {3.4958208928966413`*^9, 
   3.4958208987310514`*^9}, {3.4958243048162394`*^9, 3.495824306750643*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    SqrtBox[
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "2"]}]}]], 
       SqrtBox[
        FractionBox[
         RowBox[{"c", "+", 
          RowBox[{"d", " ", 
           SuperscriptBox["x", "2"]}]}], "c"]], " "}], 
      RowBox[{
       SqrtBox[
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}]], 
       SqrtBox[
        FractionBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", "2"]}]}], "a"]]}]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SqrtBox[
       RowBox[{"1", "+", 
        RowBox[{
         FractionBox["b", "a"], " ", 
         SuperscriptBox["x", "2"]}]}]], 
      SqrtBox[
       RowBox[{"1", "+", 
        RowBox[{
         FractionBox["d", "c"], " ", 
         SuperscriptBox["x", "2"]}]}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4957667772682123`*^9, 3.495766807868255*^9, 
   3.495767272608906*^9, {3.4958181493724546`*^9, 3.495818158032467*^9}, 
   3.495818276792633*^9, {3.49581880288337*^9, 3.4958188220418024`*^9}, 
   3.49581971997338*^9, {3.4958197713130703`*^9, 3.4958197881455*^9}, 
   3.495820844286956*^9, 3.4958212590604844`*^9, {3.49582133075821*^9, 
   3.4958213396190257`*^9}, 3.4970506868650923`*^9, {3.497050762618826*^9, 
   3.4970507655984306`*^9}, {3.498608065120802*^9, 3.4986080971632586`*^9}, {
   3.4986082300910916`*^9, 3.498608238639907*^9}, {3.498608351474905*^9, 
   3.498608355998913*^9}, 3.498609070896969*^9, 3.498609104577428*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"c_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", "*", 
       RowBox[{"x", "^", "2"}]}]}], "]"}], "*", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", 
          RowBox[{"x", "^", "2"}]}]}], ")"}], "/", "c"}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", 
          RowBox[{"x", "^", "2"}]}]}], "]"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "^", "2"}]}]}], ")"}], "/", "a"}], "]"}]}], ")"}]}], 
    "*", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"1", "+", 
         RowBox[{
          RowBox[{"b", "/", "a"}], "*", 
          RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"1", "+", 
         RowBox[{
          RowBox[{"d", "/", "c"}], "*", 
          RowBox[{"x", "^", "2"}]}]}], "]"}]}], ",", "x"}], "]"}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"PositiveQ", "[", "a", "]"}], " ", "&&", " ", 
      RowBox[{"PositiveQ", "[", "c", "]"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4957666893580894`*^9, {3.4957669395384398`*^9, 
   3.49576696833848*^9}, {3.495767191798793*^9, 3.495767213748823*^9}, 
   3.4958180273522844`*^9, 3.495818229532567*^9, 3.495818362412753*^9, {
   3.4958188945759306`*^9, 3.4958189716088657`*^9}, 3.4958191437239685`*^9, {
   3.4958198431667967`*^9, 3.495819854804417*^9}, {3.4958201761025815`*^9, 
   3.495820242012697*^9}, {3.495821042266904*^9, 3.4958210604721355`*^9}, {
   3.4958211831195507`*^9, 3.4958211869103575`*^9}, {3.4958243174834623`*^9, 
   3.4958243218826694`*^9}, 3.497050791915677*^9, {3.4970508370465565`*^9, 
   3.4970508451741705`*^9}, {3.4986012990597134`*^9, 3.498601299293714*^9}, {
   3.4986082915551996`*^9, 3.498608326436861*^9}, {3.4986092054752054`*^9, 
   3.4986092215900335`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.4957669003183846`*^9, 
   3.495766906158393*^9}, {3.495767224988839*^9, 3.495767228668844*^9}, {
   3.4958181947725186`*^9, 3.495818206722535*^9}, {3.4958183089026785`*^9, 
   3.4958183132526846`*^9}, {3.495819008440531*^9, 3.495819027129363*^9}, {
   3.495819632691227*^9, 3.495819633830029*^9}, 3.4986117449152665`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "2"]}]}]], " ", 
    SqrtBox[
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                                           ", 
      "\[IndentingNewLine]", "          ", 
      FractionBox["x", "3"]}]}], " ", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "2"]}]}]], " ", 
    SqrtBox[
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"c", " ", "b"}], "+", 
     RowBox[{"a", " ", "d"}]}], 
    RowBox[{"3", " ", "d"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SqrtBox[
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}]], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "2"]}]}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"c", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"c", " ", "b"}], "-", 
       RowBox[{"a", " ", "d"}]}], ")"}]}], 
    RowBox[{"3", "d"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "2"]}]}]], " ", 
       SqrtBox[
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4957667772682123`*^9, 3.495766807868255*^9, 
   3.495767272608906*^9, {3.4958181493724546`*^9, 3.495818158032467*^9}, 
   3.495818276792633*^9, {3.49581880288337*^9, 3.4958188220418024`*^9}, {
   3.495819743810222*^9, 3.495819760174651*^9}, 3.497050448761874*^9, {
   3.4986114945924263`*^9, 3.4986114949044266`*^9}, 3.4986115368529005`*^9, {
   3.4986115930646*^9, 3.498611601129814*^9}, {3.498611783322534*^9, 
   3.498611812416585*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}], "*", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"c_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "/", "3"}], "*", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"x", "^", "2"}]}]}], "]"}], "*", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", 
        RowBox[{"x", "^", "2"}]}]}], "]"}]}], " ", "+", " ", 
    "\[IndentingNewLine]", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"c", "*", "b"}], "+", 
         RowBox[{"a", "*", "d"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"3", "*", "d"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sqrt", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", 
            RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "^", "2"}]}]}], "]"}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", " ", "\[IndentingNewLine]", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"c", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"c", "*", "b"}], "-", 
          RowBox[{"a", "*", "d"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"3", "*", "d"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sqrt", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"x", "^", "2"}]}]}], "]"}], "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", 
              RowBox[{"x", "^", "2"}]}]}], "]"}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"c", "*", "b"}], "+", 
      RowBox[{"a", "*", "d"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"c", "*", "b"}], "-", 
      RowBox[{"a", "*", "d"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4957666893580894`*^9, {3.4957669395384398`*^9, 
   3.49576696833848*^9}, {3.495767191798793*^9, 3.495767213748823*^9}, 
   3.4958180273522844`*^9, 3.495818229532567*^9, 3.495818362412753*^9, {
   3.4958188945759306`*^9, 3.4958189716088657`*^9}, {3.495819620601206*^9, 
   3.4958196243140125`*^9}, {3.495820259266328*^9, 3.4958202890155797`*^9}, {
   3.495820793555667*^9, 3.4958207946164684`*^9}, {3.495822898430165*^9, 
   3.495822940659439*^9}, {3.4958229910475273`*^9, 3.4958230106255617`*^9}, {
   3.4958233002508717`*^9, 3.495823300718872*^9}, {3.4958258068236427`*^9, 
   3.4958258326436787`*^9}, {3.4958559306044483`*^9, 
   3.4958559349856987`*^9}, {3.496081042290396*^9, 3.4960810455504007`*^9}, {
   3.4960810761204433`*^9, 3.4960810806504498`*^9}, {3.496081119330504*^9, 
   3.4960811386405315`*^9}, {3.496283891640603*^9, 3.4962838926806045`*^9}, {
   3.4970505188371973`*^9, 3.497050547120047*^9}, 3.4986116998623877`*^9, {
   3.498611732466445*^9, 3.498611738129255*^9}, {3.4986118198889985`*^9, 
   3.498611823773405*^9}, {3.4986122555977635`*^9, 3.4986122896682234`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "m"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "n"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"e", "+", 
      RowBox[{"f", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, 
   3.4957666675480585`*^9, {3.4957667950782375`*^9, 3.495766797728241*^9}, 
   3.495817767811921*^9, {3.4958215712950325`*^9, 3.495821600825885*^9}, {
   3.4986003644404716`*^9, 3.4986003699316807`*^9}, {3.498604062418168*^9, 
   3.498604134615095*^9}, {3.498605967411916*^9, 3.498605988690353*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495733269136196*^9, 3.4958180204322743`*^9, {
   3.498790415276228*^9, 3.498790427132249*^9}}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"b", " ", "c"}], "-", 
    RowBox[{"a", " ", "d"}]}], "=", "0"}]]],
 " and  ",
 Cell[BoxData[
  RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "m"], "=", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["b", "d"], ")"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "m"]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495733269136196*^9, 3.4958180204322743`*^9, {
   3.498790415276228*^9, 3.498790427132249*^9}, {3.498790625383397*^9, 
   3.4987906379882193`*^9}, {3.49879077484726*^9, 3.498790863190215*^9}, {
   3.498790896340273*^9, 3.4987909105986986`*^9}, {3.498790950597169*^9, 
   3.498790974777211*^9}, 3.498791540637005*^9, {3.498791675702042*^9, 
   3.498791683330456*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"b", " ", "c"}], "-", 
    RowBox[{"a", " ", "d"}]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.4957669003183846`*^9, 
   3.495766906158393*^9}, {3.4958177882919493`*^9, 3.495817793751957*^9}, {
   3.498790486521553*^9, 3.498790535090439*^9}, {3.49879152622258*^9, 
   3.498791530262987*^9}, 3.498791677355645*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "m"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "n"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"e", "+", 
      RowBox[{"f", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["b", "d"], ")"}], "m"]}]}], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], 
      RowBox[{"m", "+", "n"}]], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"e", "+", 
        RowBox[{"f", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "p"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4957667772682123`*^9, 3.495766807868255*^9, 
   3.4958178099519796`*^9, {3.4958178912220936`*^9, 3.49581790991212*^9}, 
   3.4986070768034644`*^9, {3.4987905501288652`*^9, 3.498790570533701*^9}, {
   3.4987909985360527`*^9, 3.4987910184104877`*^9}, {3.4987913081653967`*^9, 
   3.498791352422674*^9}, 3.498791726094931*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "n_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"e_", "+", 
        RowBox[{"f_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b", "/", "d"}], ")"}], "^", "m"}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", 
            RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"m", "+", "n"}], ")"}]}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"e", "+", 
           RowBox[{"f", "*", 
            RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}]}], ",", "x"}], 
      "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "n", ",", 
        "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "c"}], "-", 
      RowBox[{"a", "*", "d"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4957666893580894`*^9, {3.4957669395384398`*^9, 
   3.49576696833848*^9}, 3.4958177798619375`*^9, {3.4986070917482905`*^9, 
   3.498607096490699*^9}, {3.4987910745081863`*^9, 3.4987911015274334`*^9}, {
   3.4987911322594876`*^9, 3.498791177343567*^9}, 3.4987912538929014`*^9, 
   3.4987914725428853`*^9, {3.4987915831626797`*^9, 3.4987916601800146`*^9}, {
   3.498791752630578*^9, 3.4987917734878144`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"c", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"e", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.4957669003183846`*^9, 
   3.495766906158393*^9}, {3.495767224988839*^9, 3.495767228668844*^9}, {
   3.4958181947725186`*^9, 3.495818206722535*^9}, {3.4958183089026785`*^9, 
   3.4958183132526846`*^9}, {3.495819008440531*^9, 3.495819027129363*^9}, {
   3.495819632691227*^9, 3.495819633830029*^9}, {3.4986005364931736`*^9, 
   3.4986005387239776`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], 
     SqrtBox[
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     SqrtBox[
      RowBox[{"e", "+", 
       RowBox[{"f", " ", 
        SuperscriptBox["x", "2"]}]}]]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      RowBox[{"a", "  ", 
       SqrtBox["c"], 
       SqrtBox["e"], 
       SqrtBox[
        RowBox[{"-", 
         FractionBox["d", "c"]}]]}]]}]}], 
   RowBox[{"EllipticPi", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"b", " ", "c"}], 
      RowBox[{"a", " ", "d"}]], ",", 
     RowBox[{"ArcSin", "[", 
      RowBox[{
       SqrtBox[
        RowBox[{"-", 
         FractionBox["d", "c"]}]], " ", "x"}], "]"}], ",", 
     FractionBox[
      RowBox[{"c", " ", "f"}], 
      RowBox[{"e", " ", "d"}]]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4957667772682123`*^9, 3.495766807868255*^9, 
   3.495767272608906*^9, {3.4958181493724546`*^9, 3.495818158032467*^9}, 
   3.495818276792633*^9, {3.49581880288337*^9, 3.4958188220418024`*^9}, {
   3.495819743810222*^9, 3.495819760174651*^9}, 3.497050448761874*^9, 
   3.498600422425773*^9, 3.4986005126719313`*^9, 3.4986006063968964`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], ")"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], "]"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"e_", "+", 
         RowBox[{"f_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a", "*", 
       RowBox[{"Sqrt", "[", "c", "]"}], "*", 
       RowBox[{"Sqrt", "[", "e", "]"}], "*", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "d"}], "/", "c"}], ",", "2"}], "]"}]}], ")"}]}], "*", 
    RowBox[{"EllipticPi", "[", 
     RowBox[{
      RowBox[{"b", "*", 
       RowBox[{"c", "/", 
        RowBox[{"(", 
         RowBox[{"a", "*", "d"}], ")"}]}]}], ",", " ", 
      RowBox[{"ArcSin", "[", 
       RowBox[{
        RowBox[{"Rt", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "d"}], "/", "c"}], ",", "2"}], "]"}], "*", "x"}], 
       "]"}], ",", " ", 
      RowBox[{"c", "*", 
       RowBox[{"f", "/", 
        RowBox[{"(", 
         RowBox[{"e", "*", "d"}], ")"}]}]}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", "c", "]"}], " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", "e", "]"}], " ", "&&", "\n", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"PosQ", "[", 
        RowBox[{
         RowBox[{"-", "e"}], "*", "f"}], "]"}], " ", "&&", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"NegQ", "[", 
          RowBox[{
           RowBox[{"-", "c"}], "*", "d"}], "]"}], " ", "||", " ", 
         RowBox[{"Not", "[", 
          RowBox[{"RationalQ", "[", 
           RowBox[{"Rt", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "c"}], "*", "d"}], ",", "2"}], "]"}], "]"}], 
          "]"}]}], ")"}]}], " ", "||", " ", 
      RowBox[{
       RowBox[{"NegQ", "[", 
        RowBox[{
         RowBox[{"-", "e"}], "*", "f"}], "]"}], " ", "&&", " ", 
       RowBox[{"NegQ", "[", 
        RowBox[{
         RowBox[{"-", "c"}], "*", "d"}], "]"}], " ", "&&", "\n", 
       RowBox[{"Not", "[", 
        RowBox[{"RationalQ", "[", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{"c", "*", "d"}], ",", "2"}], "]"}], "]"}], "]"}]}]}], 
     ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4957666893580894`*^9, {3.4957669395384398`*^9, 
   3.49576696833848*^9}, {3.495767191798793*^9, 3.495767213748823*^9}, 
   3.4958180273522844`*^9, 3.495818229532567*^9, 3.495818362412753*^9, {
   3.4958188945759306`*^9, 3.4958189716088657`*^9}, {3.495819620601206*^9, 
   3.4958196243140125`*^9}, {3.495820259266328*^9, 3.4958202890155797`*^9}, {
   3.495820793555667*^9, 3.4958207946164684`*^9}, {3.495822898430165*^9, 
   3.495822940659439*^9}, {3.4958229910475273`*^9, 3.4958230106255617`*^9}, {
   3.4958233002508717`*^9, 3.495823300718872*^9}, {3.4958258068236427`*^9, 
   3.4958258326436787`*^9}, {3.4958559306044483`*^9, 
   3.4958559349856987`*^9}, {3.496081042290396*^9, 3.4960810455504007`*^9}, {
   3.4960810761204433`*^9, 3.4960810806504498`*^9}, {3.496081119330504*^9, 
   3.4960811386405315`*^9}, {3.496283891640603*^9, 3.4962838926806045`*^9}, {
   3.4970505188371973`*^9, 3.497050547120047*^9}, {3.4986005290831604`*^9, 
   3.4986005870372624`*^9}, {3.4986006356937475`*^9, 3.498600682868231*^9}, {
   3.498600791466022*^9, 3.4986008497321243`*^9}, {3.498600949119899*^9, 
   3.4986009502743006`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495733269136196*^9, 3.4958180204322743`*^9, 
   3.4958182231325583`*^9, {3.4986075703883314`*^9, 3.4986075816671515`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    FractionBox[
     SqrtBox[
      FractionBox[
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], "c"]], 
     SqrtBox[
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495733269136196*^9, 3.4958180204322743`*^9, 
   3.4958182231325583`*^9, {3.4986075703883314`*^9, 3.4986075816671515`*^9}, {
   3.498607739013028*^9, 3.498607796421129*^9}, 3.498608168143383*^9, {
   3.498608549829253*^9, 3.4986085568024654`*^9}, {3.498609119537854*^9, 
   3.498609119537854*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"\[Not]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"c", ">", "0"}], " ", "\[And]", " ", 
     RowBox[{"e", ">", "0"}]}], ")"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.4957669003183846`*^9, 
   3.495766906158393*^9}, {3.495767224988839*^9, 3.495767228668844*^9}, {
   3.4958181947725186`*^9, 3.495818206722535*^9}, {3.4958183089026785`*^9, 
   3.4958183132526846`*^9}, {3.495819008440531*^9, 3.495819027129363*^9}, {
   3.4958196672920876`*^9, 3.495819677884506*^9}, {3.4958208928966413`*^9, 
   3.4958208987310514`*^9}, {3.4960821228019085`*^9, 
   3.4960821228019085`*^9}, {3.4986009824883575`*^9, 3.4986009840171604`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], 
     SqrtBox[
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     SqrtBox[
      RowBox[{"e", "+", 
       RowBox[{"f", " ", 
        SuperscriptBox["x", "2"]}]}]]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SqrtBox[
        FractionBox[
         RowBox[{"c", "+", 
          RowBox[{"d", " ", 
           SuperscriptBox["x", "2"]}]}], "c"]], " ", 
       SqrtBox[
        FractionBox[
         RowBox[{"e", "+", 
          RowBox[{"f", " ", 
           SuperscriptBox["x", "2"]}]}], "e"]]}], 
      RowBox[{
       SqrtBox[
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}]], " ", 
       SqrtBox[
        RowBox[{"e", "+", 
         RowBox[{"f", " ", 
          SuperscriptBox["x", "2"]}]}]]}]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], 
       SqrtBox[
        RowBox[{"1", "+", 
         RowBox[{
          FractionBox["d", "c"], " ", 
          SuperscriptBox["x", "2"]}]}]], 
       SqrtBox[
        RowBox[{"1", "+", 
         RowBox[{
          FractionBox["f", "e"], " ", 
          SuperscriptBox["x", "2"]}]}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4957667772682123`*^9, 3.495766807868255*^9, 
   3.495767272608906*^9, {3.4958181493724546`*^9, 3.495818158032467*^9}, 
   3.495818276792633*^9, {3.49581880288337*^9, 3.4958188220418024`*^9}, 
   3.49581971997338*^9, {3.4958197713130703`*^9, 3.4958197881455*^9}, {
   3.4970505668696814`*^9, 3.4970505873525176`*^9}, 3.4986009733155413`*^9, 
   3.4986011372874293`*^9, {3.4986012039151464`*^9, 3.498601207066352*^9}, {
   3.4986085233248067`*^9, 3.4986085402196364`*^9}, {3.498608574929697*^9, 
   3.4986085881897206`*^9}, {3.498609114748646*^9, 3.498609133640279*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], ")"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], "]"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"e_", "+", 
         RowBox[{"f_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "/", "c"}], "]"}], "*", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"e", "+", 
         RowBox[{"f", "*", 
          RowBox[{"x", "^", "2"}]}]}], ")"}], "/", "e"}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", 
          RowBox[{"x", "^", "2"}]}]}], "]"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"e", "+", 
         RowBox[{"f", "*", 
          RowBox[{"x", "^", "2"}]}]}], "]"}]}], ")"}]}], "*", "\n", "    ", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "^", "2"}]}]}], ")"}], "*", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"1", "+", 
           RowBox[{
            RowBox[{"d", "/", "c"}], "*", 
            RowBox[{"x", "^", "2"}]}]}], "]"}], "*", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"1", "+", 
           RowBox[{
            RowBox[{"f", "/", "e"}], "*", 
            RowBox[{"x", "^", "2"}]}]}], "]"}]}], ")"}]}], ",", "x"}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"PositiveQ", "[", "c", "]"}], " ", "&&", " ", 
      RowBox[{"PositiveQ", "[", "e", "]"}]}], "]"}], " ", "&&", "\n", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"PosQ", "[", 
        RowBox[{
         RowBox[{"-", "e"}], "*", "f"}], "]"}], " ", "&&", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"NegQ", "[", 
          RowBox[{
           RowBox[{"-", "c"}], "*", "d"}], "]"}], " ", "||", " ", 
         RowBox[{"Not", "[", 
          RowBox[{"RationalQ", "[", 
           RowBox[{"Rt", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "c"}], "*", "d"}], ",", "2"}], "]"}], "]"}], 
          "]"}]}], ")"}]}], " ", "||", " ", 
      RowBox[{
       RowBox[{"NegQ", "[", 
        RowBox[{
         RowBox[{"-", "e"}], "*", "f"}], "]"}], " ", "&&", " ", 
       RowBox[{"NegQ", "[", 
        RowBox[{
         RowBox[{"-", "c"}], "*", "d"}], "]"}], " ", "&&", "\n", 
       RowBox[{"Not", "[", 
        RowBox[{"RationalQ", "[", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{"c", "*", "d"}], ",", "2"}], "]"}], "]"}], "]"}]}]}], 
     ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4957666893580894`*^9, {3.4957669395384398`*^9, 
   3.49576696833848*^9}, {3.495767191798793*^9, 3.495767213748823*^9}, 
   3.4958180273522844`*^9, 3.495818229532567*^9, 3.495818362412753*^9, {
   3.4958188945759306`*^9, 3.4958189716088657`*^9}, 3.4958191437239685`*^9, {
   3.4958198431667967`*^9, 3.495819854804417*^9}, {3.4958201761025815`*^9, 
   3.495820242012697*^9}, {3.495820957667955*^9, 3.4958209643447666`*^9}, {
   3.4958258670737267`*^9, 3.4958258735937357`*^9}, {3.49608170914133*^9, 
   3.4960817119813337`*^9}, {3.4960817601514015`*^9, 
   3.4960817652814083`*^9}, {3.4962838962906094`*^9, 3.49628389678061*^9}, {
   3.497050609083356*^9, 3.4970506528102326`*^9}, {3.4986009592911167`*^9, 
   3.4986009627855225`*^9}, {3.4986010102252064`*^9, 
   3.4986010198192234`*^9}, {3.498601269170061*^9, 3.49860127399047*^9}, {
   3.498608708122731*^9, 3.4986087136919413`*^9}, {3.498609262852106*^9, 
   3.498609277765732*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.4957669003183846`*^9, 
   3.495766906158393*^9}, {3.495767224988839*^9, 3.495767228668844*^9}, {
   3.4958181947725186`*^9, 3.495818206722535*^9}, {3.4958183089026785`*^9, 
   3.4958183132526846`*^9}, {3.495819008440531*^9, 3.495819027129363*^9}, {
   3.4958196672920876`*^9, 3.495819677884506*^9}, {3.4958208928966413`*^9, 
   3.4958208987310514`*^9}, {3.4960821228019085`*^9, 
   3.4960821228019085`*^9}, {3.4986009824883575`*^9, 
   3.4986009840171604`*^9}, {3.4986018947623596`*^9, 3.498601901127171*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    SqrtBox[
     RowBox[{"e", "+", 
      RowBox[{"f", " ", "z"}]}]], 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "z"}]}], ")"}]], "=", 
   RowBox[{
    FractionBox["f", 
     RowBox[{"b", " ", 
      SqrtBox[
       RowBox[{"e", "+", 
        RowBox[{"f", " ", "z"}]}]]}]], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"b", " ", "e"}], "-", 
      RowBox[{"a", " ", "f"}]}], 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "z"}]}], ")"}], " ", 
      SqrtBox[
       RowBox[{"e", "+", 
        RowBox[{"f", " ", "z"}]}]]}]]}]}]], "Input",
  CellChangeTimes->{{3.498602000353746*^9, 3.4986020148461714`*^9}}]
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.4957669003183846`*^9, 
   3.495766906158393*^9}, {3.495767224988839*^9, 3.495767228668844*^9}, {
   3.4958181947725186`*^9, 3.495818206722535*^9}, {3.4958183089026785`*^9, 
   3.4958183132526846`*^9}, {3.495819008440531*^9, 3.495819027129363*^9}, {
   3.4958196672920876`*^9, 3.495819677884506*^9}, {3.4958208928966413`*^9, 
   3.4958208987310514`*^9}, {3.4960821228019085`*^9, 
   3.4960821228019085`*^9}, {3.4986009824883575`*^9, 
   3.4986009840171604`*^9}, {3.4986018947623596`*^9, 3.498601901127171*^9}, {
   3.498601992491332*^9, 3.4986020222561846`*^9}, {3.4986054900918765`*^9, 
   3.4986055665848117`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"b", " ", "e"}], "-", 
    RowBox[{"a", " ", "f"}]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.4957669003183846`*^9, 
   3.495766906158393*^9}, {3.4958177882919493`*^9, 3.495817793751957*^9}, {
   3.498790486521553*^9, 3.498790535090439*^9}, {3.49879152622258*^9, 
   3.498791530262987*^9}, 3.498791677355645*^9, {3.4987920758319454`*^9, 
   3.498792081837956*^9}, 3.49879211849802*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SqrtBox[
      RowBox[{"e", "+", 
       RowBox[{"f", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], 
      SqrtBox[
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}]]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["f", "b"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox["1", 
       RowBox[{
        SqrtBox[
         RowBox[{"c", "+", 
          RowBox[{"d", " ", 
           SuperscriptBox["x", "2"]}]}]], 
        SqrtBox[
         RowBox[{"e", "+", 
          RowBox[{"f", " ", 
           SuperscriptBox["x", "2"]}]}]]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"b", " ", "e"}], "-", 
     RowBox[{"a", " ", "f"}]}], "b"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], " ", 
       SqrtBox[
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}]], " ", 
       SqrtBox[
        RowBox[{"e", "+", 
         RowBox[{"f", " ", 
          SuperscriptBox["x", "2"]}]}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4957667772682123`*^9, 3.495766807868255*^9, 
   3.495767272608906*^9, {3.4958181493724546`*^9, 3.495818158032467*^9}, 
   3.495818276792633*^9, {3.49581880288337*^9, 3.4958188220418024`*^9}, 
   3.49581971997338*^9, {3.4958197713130703`*^9, 3.4958197881455*^9}, {
   3.4970505668696814`*^9, 3.4970505873525176`*^9}, 3.4986009733155413`*^9, 
   3.4986011372874293`*^9, {3.4986012039151464`*^9, 3.498601207066352*^9}, {
   3.4986018785851316`*^9, 3.4986018803791347`*^9}, {3.4986020515530357`*^9, 
   3.4986021253879657`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"e_", "+", 
       RowBox[{"f_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], ")"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"f", "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sqrt", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", 
              RowBox[{"x", "^", "2"}]}]}], "]"}], "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"e", "+", 
             RowBox[{"f", "*", 
              RowBox[{"x", "^", "2"}]}]}], "]"}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "e"}], "-", 
         RowBox[{"a", "*", "f"}]}], ")"}], "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"x", "^", "2"}]}]}], ")"}], "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", 
              RowBox[{"x", "^", "2"}]}]}], "]"}], "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"e", "+", 
             RowBox[{"f", "*", 
              RowBox[{"x", "^", "2"}]}]}], "]"}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "e"}], "-", 
      RowBox[{"a", "*", "f"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4957666893580894`*^9, {3.4957669395384398`*^9, 
   3.49576696833848*^9}, {3.495767191798793*^9, 3.495767213748823*^9}, 
   3.4958180273522844`*^9, 3.495818229532567*^9, 3.495818362412753*^9, {
   3.4958188945759306`*^9, 3.4958189716088657`*^9}, 3.4958191437239685`*^9, {
   3.4958198431667967`*^9, 3.495819854804417*^9}, {3.4958201761025815`*^9, 
   3.495820242012697*^9}, {3.495820957667955*^9, 3.4958209643447666`*^9}, {
   3.4958258670737267`*^9, 3.4958258735937357`*^9}, {3.49608170914133*^9, 
   3.4960817119813337`*^9}, {3.4960817601514015`*^9, 
   3.4960817652814083`*^9}, {3.4962838962906094`*^9, 3.49628389678061*^9}, {
   3.497050609083356*^9, 3.4970506528102326`*^9}, {3.4986009592911167`*^9, 
   3.4986009627855225`*^9}, {3.4986010102252064`*^9, 
   3.4986010198192234`*^9}, {3.498601269170061*^9, 3.49860127399047*^9}, {
   3.498602159037225*^9, 3.498602163732833*^9}, {3.498602246865379*^9, 
   3.498602256927397*^9}, {3.498789941284995*^9, 3.498789952111414*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.4957669003183846`*^9, 
   3.495766906158393*^9}, {3.495767224988839*^9, 3.495767228668844*^9}, {
   3.4958181947725186`*^9, 3.495818206722535*^9}, {3.4958183089026785`*^9, 
   3.4958183132526846`*^9}, {3.495819008440531*^9, 3.495819027129363*^9}, {
   3.4958196672920876`*^9, 3.495819677884506*^9}, {3.4958208928966413`*^9, 
   3.4958208987310514`*^9}, {3.4960821228019085`*^9, 
   3.4960821228019085`*^9}, {3.4986009824883575`*^9, 
   3.4986009840171604`*^9}, {3.4986018947623596`*^9, 3.498601901127171*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{
     SqrtBox[
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     SqrtBox[
      RowBox[{"e", "+", 
       RowBox[{"f", " ", 
        SuperscriptBox["x", "2"]}]}]]}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "2"]}]}]], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"d", " ", 
      SqrtBox[
       RowBox[{"e", "+", 
        RowBox[{"f", " ", 
         SuperscriptBox["x", "2"]}]}]]}], 
     RowBox[{"b", " ", 
      SqrtBox[
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}]]}]], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", " ", "c"}], "-", 
        RowBox[{"a", " ", "d"}]}], ")"}], " ", 
      SqrtBox[
       RowBox[{"e", "+", 
        RowBox[{"f", " ", 
         SuperscriptBox["x", "2"]}]}]]}], 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], " ", 
      SqrtBox[
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}]]}]]}]}]], "Input",
  CellChangeTimes->{{3.498602000353746*^9, 3.4986020148461714`*^9}}]
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.4957669003183846`*^9, 
   3.495766906158393*^9}, {3.495767224988839*^9, 3.495767228668844*^9}, {
   3.4958181947725186`*^9, 3.495818206722535*^9}, {3.4958183089026785`*^9, 
   3.4958183132526846`*^9}, {3.495819008440531*^9, 3.495819027129363*^9}, {
   3.4958196672920876`*^9, 3.495819677884506*^9}, {3.4958208928966413`*^9, 
   3.4958208987310514`*^9}, {3.4960821228019085`*^9, 
   3.4960821228019085`*^9}, {3.4986009824883575`*^9, 
   3.4986009840171604`*^9}, {3.4986018947623596`*^9, 3.498601901127171*^9}, {
   3.498601992491332*^9, 3.4986020222561846`*^9}, {3.498603760635638*^9, 
   3.4986037636620436`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"b", " ", "c"}], "-", 
    RowBox[{"a", " ", "d"}]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.4957669003183846`*^9, 
   3.495766906158393*^9}, {3.4958177882919493`*^9, 3.495817793751957*^9}, {
   3.498790486521553*^9, 3.498790535090439*^9}, {3.49879152622258*^9, 
   3.498791530262987*^9}, 3.498791677355645*^9, {3.4987920758319454`*^9, 
   3.498792081837956*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SqrtBox[
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}]], 
      SqrtBox[
       RowBox[{"e", "+", 
        RowBox[{"f", " ", 
         SuperscriptBox["x", "2"]}]}]]}], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["d", "b"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       SqrtBox[
        RowBox[{"e", "+", 
         RowBox[{"f", " ", 
          SuperscriptBox["x", "2"]}]}]], 
       SqrtBox[
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}]]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"b", " ", "c"}], "-", 
     RowBox[{"a", " ", "d"}]}], "b"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SqrtBox[
       RowBox[{"e", "+", 
        RowBox[{"f", " ", 
         SuperscriptBox["x", "2"]}]}]], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], " ", 
       SqrtBox[
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}]], " "}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4957667772682123`*^9, 3.495766807868255*^9, 
   3.495767272608906*^9, {3.4958181493724546`*^9, 3.495818158032467*^9}, 
   3.495818276792633*^9, {3.49581880288337*^9, 3.4958188220418024`*^9}, 
   3.49581971997338*^9, {3.4958197713130703`*^9, 3.4958197881455*^9}, {
   3.4970505668696814`*^9, 3.4970505873525176`*^9}, 3.4986009733155413`*^9, 
   3.4986011372874293`*^9, {3.4986012039151464`*^9, 3.498601207066352*^9}, {
   3.4986018785851316`*^9, 3.4986018803791347`*^9}, {3.4986020515530357`*^9, 
   3.4986021253879657`*^9}, {3.4986037423524065`*^9, 
   3.4986037495284185`*^9}, {3.498603805704118*^9, 3.4986038403361783`*^9}, {
   3.498609785889825*^9, 3.4986097892594304`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"c_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"e_", "+", 
        RowBox[{"f_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"d", "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sqrt", "[", 
          RowBox[{"e", "+", 
           RowBox[{"f", "*", 
            RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", 
            RowBox[{"x", "^", "2"}]}]}], "]"}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "c"}], "-", 
         RowBox[{"a", "*", "d"}]}], ")"}], "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sqrt", "[", 
          RowBox[{"e", "+", 
           RowBox[{"f", "*", 
            RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"x", "^", "2"}]}]}], ")"}], "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", 
              RowBox[{"x", "^", "2"}]}]}], "]"}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "c"}], "-", 
      RowBox[{"a", "*", "d"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4957666893580894`*^9, {3.4957669395384398`*^9, 
   3.49576696833848*^9}, {3.495767191798793*^9, 3.495767213748823*^9}, 
   3.4958180273522844`*^9, 3.495818229532567*^9, 3.495818362412753*^9, {
   3.4958188945759306`*^9, 3.4958189716088657`*^9}, 3.4958191437239685`*^9, {
   3.4958198431667967`*^9, 3.495819854804417*^9}, {3.4958201761025815`*^9, 
   3.495820242012697*^9}, {3.495820957667955*^9, 3.4958209643447666`*^9}, {
   3.4958258670737267`*^9, 3.4958258735937357`*^9}, {3.49608170914133*^9, 
   3.4960817119813337`*^9}, {3.4960817601514015`*^9, 
   3.4960817652814083`*^9}, {3.4962838962906094`*^9, 3.49628389678061*^9}, {
   3.497050609083356*^9, 3.4970506528102326`*^9}, {3.4986009592911167`*^9, 
   3.4986009627855225`*^9}, {3.4986010102252064`*^9, 
   3.4986010198192234`*^9}, {3.498601269170061*^9, 3.49860127399047*^9}, {
   3.498602159037225*^9, 3.498602163732833*^9}, {3.498602246865379*^9, 
   3.498602256927397*^9}, {3.498603944466361*^9, 3.4986039475083666`*^9}, {
   3.4986097575445747`*^9, 3.498609771334999*^9}, {3.4987914521692495`*^9, 
   3.4987914587524614`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{3.49539151296132*^9, 3.49582215565486*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"e", "+", 
     RowBox[{"f", " ", "z"}]}], 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "z"}]}]]], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"f", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "z"}]}]]}], "b"], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"b", " ", "e"}], "-", 
      RowBox[{"a", " ", "f"}]}], 
     RowBox[{"b", " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "z"}]}]]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, 
   3.4958221765120964`*^9, {3.4958222304725914`*^9, 3.4958222342321978`*^9}, 
   3.4958261715141525`*^9, {3.4967272310657845`*^9, 3.496727295943099*^9}, {
   3.4967273380631733`*^9, 3.496727339810376*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"b", " ", "e"}], "-", 
    RowBox[{"a", " ", "f"}]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.4957669003183846`*^9, 
   3.495766906158393*^9}, {3.4958177882919493`*^9, 3.495817793751957*^9}, {
   3.498790486521553*^9, 3.498790535090439*^9}, {3.49879152622258*^9, 
   3.498791530262987*^9}, 3.498791677355645*^9, {3.4987920758319454`*^9, 
   3.498792081837956*^9}, 3.49879211849802*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"e", "+", 
      RowBox[{"f", " ", 
       SuperscriptBox["x", "2"]}]}], 
     RowBox[{
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "2"]}]}]], " ", 
      SqrtBox[
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}]]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["f", "b"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "2"]}]}]], 
       SqrtBox[
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}]]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"b", " ", "e"}], "-", 
     RowBox[{"a", " ", "f"}]}], "b"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "2"]}]}]], " ", 
       SqrtBox[
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.495821746826541*^9, 3.4958221281208115`*^9, 
   3.495826096984049*^9, 3.4958261331240993`*^9, {3.496727360589613*^9, 
   3.49672739330287*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"e_.", "+", 
       RowBox[{"f_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], "]"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"f", "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", 
            RowBox[{"x", "^", "2"}]}]}], "]"}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "e"}], "-", 
         RowBox[{"a", "*", "f"}]}], ")"}], "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sqrt", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"x", "^", "2"}]}]}], "]"}], "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", 
              RowBox[{"x", "^", "2"}]}]}], "]"}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "e"}], "-", 
      RowBox[{"a", "*", "f"}]}], "]"}], " ", "&&", "\n", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"PosQ", "[", 
        RowBox[{
         RowBox[{"-", "c"}], "*", "d"}], "]"}], " ", "&&", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"NegQ", "[", 
          RowBox[{
           RowBox[{"-", "a"}], "*", "b"}], "]"}], " ", "||", " ", 
         RowBox[{"Not", "[", 
          RowBox[{"RationalQ", "[", 
           RowBox[{"Rt", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "a"}], "*", "b"}], ",", "2"}], "]"}], "]"}], 
          "]"}]}], ")"}]}], " ", "||", " ", 
      RowBox[{
       RowBox[{"NegQ", "[", 
        RowBox[{
         RowBox[{"-", "c"}], "*", "d"}], "]"}], " ", "&&", " ", 
       RowBox[{"NegQ", "[", 
        RowBox[{
         RowBox[{"-", "a"}], "*", "b"}], "]"}], " ", "&&", "\n", 
       RowBox[{"Not", "[", 
        RowBox[{"RationalQ", "[", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{"a", "*", "b"}], ",", "2"}], "]"}], "]"}], "]"}]}]}], 
     ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4958220678423057`*^9, {3.4958223249151573`*^9, 
   3.4958223275047617`*^9}, 3.4958260647740035`*^9, 3.4960822003220177`*^9, {
   3.496283938160668*^9, 3.4962839385206685`*^9}, {3.496727420524918*^9, 
   3.4967274493069687`*^9}, {3.4967274926906447`*^9, 
   3.4967275032518635`*^9}, {3.4967279760574937`*^9, 3.4967279810495024`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4958219316384664`*^9, 3.4958219817613544`*^9}, {
   3.4958222711262627`*^9, 3.49582231511834*^9}, {3.4958224322277455`*^9, 
   3.49582243441175*^9}, 3.4958262198642206`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "2"], " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "2"]}]}]]}], 
     SqrtBox[
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"x", " ", 
        SqrtBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", "2"]}]}]], " ", 
        SqrtBox[
         RowBox[{"c", "+", 
          RowBox[{"d", " ", 
           SuperscriptBox["x", "2"]}]}]]}], 
       RowBox[{"3", " ", "d"}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"3", " ", "d"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"a", " ", "c"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "b", " ", "c"}], "-", 
          RowBox[{"a", " ", "d"}]}], ")"}], " ", 
        SuperscriptBox["x", "2"]}]}], 
      RowBox[{
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "2"]}]}]], " ", 
       SqrtBox[
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.495821746826541*^9, 3.4958221281208115`*^9, 
   3.495822496109858*^9, {3.495826246564258*^9, 3.4958262551742697`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "2"}], "*", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], "]"}], "/", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], "]"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"x", "^", "2"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"3", "*", "d"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"3", "*", "d"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "*", "c"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", "*", "b", "*", "c"}], "-", 
              RowBox[{"a", "*", "d"}]}], ")"}], "*", 
            RowBox[{"x", "^", "2"}]}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sqrt", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"x", "^", "2"}]}]}], "]"}], "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", 
              RowBox[{"x", "^", "2"}]}]}], "]"}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], 
    "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4958220678423057`*^9, {3.4958223249151573`*^9, 
   3.4958223275047617`*^9}, 3.495822370124037*^9, {3.4958224023380933`*^9, 
   3.4958224041788964`*^9}, 3.495826214624213*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], ")"}], "p"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "n"]}]}], ")"}], "q"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, 
   3.4958216891532397`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.4958217152052855`*^9, {3.4958220131174097`*^9, 
   3.4958220145058117`*^9}}],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "d"}], "-", 
    RowBox[{"b", " ", "c"}]}], " ", "=", "0"}]]],
 ",",
 " then",
 " ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "z"}]}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", "z"}]}]], "=", 
   FractionBox["b", "d"]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, 
   3.495821731616514*^9, {3.4958219673469296`*^9, 3.4958219943193765`*^9}, {
   3.495822220862974*^9, 3.4958222232185783`*^9}, 3.496960914417976*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "d"}], "-", 
    RowBox[{"b", " ", "c"}]}], " ", "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"p", ">", "0"}], " ", "\[And]", " ", 
    RowBox[{"q", "<", 
     RowBox[{"-", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4958219316384664`*^9, 3.4958219817613544`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], ")"}], "p"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "n"]}]}], ")"}], "q"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["b", "d"]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}], 
      RowBox[{"p", "-", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}], 
      RowBox[{"q", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.495821744330537*^9, 3.4958217818642025`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_"}]}]}], ")"}], "^", "p_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "n_"}]}]}], ")"}], "^", "q_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"b", "/", "d"}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "^", "n"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}]}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", 
            RowBox[{"x", "^", "n"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"q", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "d"}], "-", 
      RowBox[{"b", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"p", ",", "q"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "0"}], " ", "&&", " ", 
    RowBox[{"q", "<=", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4958217052212677`*^9, {3.4958219175672417`*^9, 3.495821919891646*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{3.49539151296132*^9, 3.49582215565486*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "z"}]}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", "z"}]}]], "=", 
   RowBox[{
    FractionBox["b", "d"], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"a", " ", "d"}], "-", 
      RowBox[{"b", " ", "c"}]}], 
     RowBox[{"d", " ", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "z"}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, 
   3.4958221765120964`*^9, {3.4958222304725914`*^9, 3.4958222342321978`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", "d"}], "-", 
     RowBox[{"b", " ", "c"}]}], " ", "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"p", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"q", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4958219316384664`*^9, 3.4958219817613544`*^9}, {
   3.4958222711262627`*^9, 3.49582231511834*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], "q"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        RowBox[{"a", " ", "d"}], "-", 
        RowBox[{"b", " ", "c"}]}], "d"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "n"]}]}], ")"}], 
       RowBox[{"p", "-", "1"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "n"]}]}], ")"}], "q"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["b", "d"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}], 
      RowBox[{"p", "-", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}], 
      RowBox[{"q", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.495821746826541*^9, 3.4958221281208115`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_"}]}]}], ")"}], "^", "p_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "n_"}]}]}], ")"}], "^", "q_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "*", "d"}], "-", 
         RowBox[{"b", "*", "c"}]}], ")"}], "/", "d"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "n"}]}]}], ")"}], "^", "q"}]}], ",", "x"}], 
       "]"}]}], "]"}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "/", "d"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "n"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"q", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "d"}], "-", 
      RowBox[{"b", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"p", ",", "q"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "0"}], " ", "&&", " ", 
    RowBox[{"q", "<=", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", "\n", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4958220678423057`*^9, {3.4958223249151573`*^9, 
   3.4958223275047617`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{3.49539151296132*^9, 3.49582215565486*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "z"}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "z"}]}], ")"}]}]], "=", 
   RowBox[{
    FractionBox["b", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", " ", "c"}], "-", 
        RowBox[{"a", " ", "d"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "z"}]}], ")"}]}]], "-", 
    FractionBox["d", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", " ", "c"}], "-", 
        RowBox[{"a", " ", "d"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "z"}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, 
   3.4958221765120964`*^9, {3.4958222304725914`*^9, 3.4958222342321978`*^9}, 
   3.4958223934616776`*^9, {3.49582251414349*^9, 3.4958225209919014`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", "d"}], "-", 
     RowBox[{"b", " ", "c"}]}], " ", "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"p", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{"q", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4958219316384664`*^9, 3.4958219817613544`*^9}, {
   3.4958222711262627`*^9, 3.49582231511834*^9}, {3.4958224322277455`*^9, 
   3.49582243441175*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], "q"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                              ", 
      "\[IndentingNewLine]", "                            ", 
      FractionBox["b", 
       RowBox[{
        RowBox[{"b", " ", "c"}], "-", 
        RowBox[{"a", " ", "d"}]}]]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "n"]}]}], ")"}], "p"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "n"]}]}], ")"}], 
       RowBox[{"q", "+", "1"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["d", 
    RowBox[{
     RowBox[{"b", " ", "c"}], "-", 
     RowBox[{"a", " ", "d"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}], 
      RowBox[{"p", "+", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}], "q"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.495821746826541*^9, 3.4958221281208115`*^9, 
   3.495822496109858*^9, {3.4962839751007195`*^9, 3.496283992940745*^9}, {
   3.4969603086971283`*^9, 3.496960309357129*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_"}]}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "n_"}]}]}], ")"}], "^", "q_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "c"}], "-", 
         RowBox[{"a", "*", "d"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "n"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"q", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"d", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "c"}], "-", 
         RowBox[{"a", "*", "d"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "n"}]}]}], ")"}], "^", "q"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "c"}], "-", 
      RowBox[{"a", "*", "d"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"p", ",", "q"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"q", "<=", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", "\n", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4958220678423057`*^9, {3.4958223249151573`*^9, 
   3.4958223275047617`*^9}, 3.495822370124037*^9, {3.4958224023380933`*^9, 
   3.4958224041788964`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}]}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "p"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, 
   3.4958216891532397`*^9, 3.4958323633864603`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{3.4953915070313115`*^9, 3.49565374201346*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}]}], 
    RowBox[{"x", 
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "p"]}]}], ")"}]}]], "=", 
   RowBox[{
    FractionBox["a", 
     RowBox[{"c", " ", "x"}]], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["x", 
       RowBox[{"n", "-", "1"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", " ", "c"}], "-", 
        RowBox[{"a", " ", "d", " ", 
         SuperscriptBox["x", 
          RowBox[{"p", "-", "n"}]]}]}], ")"}]}], 
     RowBox[{"c", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "p"]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, 
   3.4956537598910923`*^9, {3.495833466298004*^9, 3.495833481458026*^9}, 
   3.495833533098098*^9, {3.4958336476682587`*^9, 3.495833656638271*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", ",", 
   RowBox[{
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", 
    " ", 
    RowBox[{"0", "<", "n", "\[LessEqual]", "p"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4958219316384664`*^9, 3.4958219817613544`*^9}, {
   3.4958324842466297`*^9, 3.4958325169966755`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], 
     RowBox[{"x", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "p"]}]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"a", " ", 
        RowBox[{"Log", "[", "x", "]"}]}], "c"]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", "c"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"n", "-", "1"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", " ", "c"}], "-", 
         RowBox[{"a", " ", "d", " ", 
          SuperscriptBox["x", 
           RowBox[{"p", "-", "n"}]]}]}], ")"}]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "p"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.495821744330537*^9, 3.4958217818642025`*^9, {
   3.495832431946556*^9, 3.49583245583659*^9}, {3.4958326509168625`*^9, 
   3.495832653186866*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"x_", "*", 
       RowBox[{"(", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", 
          RowBox[{"x_", "^", "p_."}]}]}], ")"}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "*", 
     RowBox[{
      RowBox[{"Log", "[", "x", "]"}], "/", "c"}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "c"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"b", "*", "c"}], "-", 
            RowBox[{"a", "*", "d", "*", 
             RowBox[{"x", "^", 
              RowBox[{"(", 
               RowBox[{"p", "-", "n"}], ")"}]}]}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "p"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"FractionQ", "[", 
     RowBox[{"{", 
      RowBox[{"n", ",", "p"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"0", "<", "n", "<=", "p"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4958217052212677`*^9, {3.4958219175672417`*^9, 3.495821919891646*^9}, 
   3.4958323917665*^9, 3.4958326113568077`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{3.4953915070313115`*^9, 3.49565374201346*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}]}], 
    RowBox[{"x", 
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "p"]}]}], ")"}]}]], "=", 
   RowBox[{
    FractionBox["a", 
     RowBox[{"c", " ", "x"}]], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["x", 
       RowBox[{"p", "-", "1"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "a"}], " ", "d"}], "+", 
        RowBox[{"b", " ", "c", " ", 
         SuperscriptBox["x", 
          RowBox[{"n", "-", "p"}]]}]}], ")"}]}], 
     RowBox[{"c", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "p"]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, 
   3.4956537598910923`*^9, {3.495833466298004*^9, 3.495833481458026*^9}, 
   3.495833533098098*^9, {3.4958336476682587`*^9, 3.495833656638271*^9}, {
   3.495833698028329*^9, 3.4958337078783426`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", ",", 
   RowBox[{
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", 
    " ", 
    RowBox[{"0", "<", "p", "<", "n"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4958219316384664`*^9, 3.4958219817613544`*^9}, {
   3.4958324842466297`*^9, 3.4958325169966755`*^9}, {3.495832673036894*^9, 
   3.495832675546897*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], 
     RowBox[{"x", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "p"]}]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"a", " ", 
        RowBox[{"Log", "[", "x", "]"}]}], "c"]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", "c"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"p", "-", "1"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "a"}], " ", "d"}], "+", 
         RowBox[{"b", " ", "c", " ", 
          SuperscriptBox["x", 
           RowBox[{"n", "-", "p"}]]}]}], ")"}]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "p"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.495821744330537*^9, 3.4958217818642025`*^9, {
   3.495832431946556*^9, 3.49583245583659*^9}, {3.495832633076838*^9, 
   3.4958326471968575`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"x_", "*", 
       RowBox[{"(", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", 
          RowBox[{"x_", "^", "p_."}]}]}], ")"}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "*", 
     RowBox[{
      RowBox[{"Log", "[", "x", "]"}], "/", "c"}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "c"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "a"}], "*", "d"}], "+", 
            RowBox[{"b", "*", "c", "*", 
             RowBox[{"x", "^", 
              RowBox[{"(", 
               RowBox[{"n", "-", "p"}], ")"}]}]}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "p"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"FractionQ", "[", 
     RowBox[{"{", 
      RowBox[{"n", ",", "p"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"0", "<", "p", "<", "n"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4958220678423057`*^9, {3.4958223249151573`*^9, 
   3.4958223275047617`*^9}, 3.495832538936706*^9, 3.4958326082168036`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{3.4953915070313115`*^9, 3.49565374201346*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}]}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "p"]}]}]], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"a", " ", 
      SuperscriptBox["x", "m"]}], "c"], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["x", 
       RowBox[{"m", "+", "n"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", " ", "c"}], "-", 
        RowBox[{"a", " ", "d", " ", 
         SuperscriptBox["x", 
          RowBox[{"p", "-", "n"}]]}]}], ")"}]}], 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "p"]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, 
   3.4956537598910923`*^9, {3.495833466298004*^9, 3.495833481458026*^9}, 
   3.495833533098098*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", "n", ",", 
   RowBox[{
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", 
    " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"0", "<", "n", "\[LessEqual]", "p"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4958219316384664`*^9, 3.4958219817613544`*^9}, {
   3.4958324842466297`*^9, 3.4958325169966755`*^9}, {3.495832673036894*^9, 
   3.495832675546897*^9}, {3.4958328812071853`*^9, 3.495832910797227*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "m"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "p"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"a", " ", 
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]]}], 
       RowBox[{"c", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", "c"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"m", "+", "n"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", " ", "c"}], "-", 
         RowBox[{"a", " ", "d", " ", 
          SuperscriptBox["x", 
           RowBox[{"p", "-", "n"}]]}]}], ")"}]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "p"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.495821744330537*^9, 3.4958217818642025`*^9, {
   3.495832431946556*^9, 3.49583245583659*^9}, {3.495832633076838*^9, 
   3.4958326471968575`*^9}, {3.4958327900870576`*^9, 3.495832805227079*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "p_."}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "*", 
     RowBox[{
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "c"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "n"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"b", "*", "c"}], "-", 
            RowBox[{"a", "*", "d", "*", 
             RowBox[{"x", "^", 
              RowBox[{"(", 
               RowBox[{"p", "-", "n"}], ")"}]}]}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "p"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"FractionQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n", ",", "p"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"0", "<", "n", "<=", "p"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4958220678423057`*^9, {3.4958223249151573`*^9, 
   3.4958223275047617`*^9}, 3.495832538936706*^9, 3.4958326082168036`*^9, {
   3.495832764717022*^9, 3.495832766137024*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{3.4953915070313115`*^9, 3.49565374201346*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}]}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "p"]}]}]], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"a", " ", 
      SuperscriptBox["x", "m"]}], "c"], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["x", 
       RowBox[{"m", "+", "p"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "a"}], " ", "d"}], "+", 
        RowBox[{"b", " ", "c", " ", 
         SuperscriptBox["x", 
          RowBox[{"n", "-", "p"}]]}]}], ")"}]}], 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "p"]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, 
   3.4956537598910923`*^9, {3.495833466298004*^9, 3.495833481458026*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", "n", ",", 
   RowBox[{
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", 
    " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"0", "<", "p", "<", "n"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4958219316384664`*^9, 3.4958219817613544`*^9}, {
   3.4958324842466297`*^9, 3.4958325169966755`*^9}, {3.495832673036894*^9, 
   3.495832675546897*^9}, 3.495832933217258*^9, {3.4958329964673467`*^9, 
   3.4958330022973547`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "m"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "p"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"a", " ", 
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]]}], 
       RowBox[{"c", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", "c"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"m", "+", "p"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "a"}], " ", "d"}], "+", 
         RowBox[{"b", " ", "c", " ", 
          SuperscriptBox["x", 
           RowBox[{"n", "-", "p"}]]}]}], ")"}]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "p"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.495821744330537*^9, 3.4958217818642025`*^9, {
   3.495832431946556*^9, 3.49583245583659*^9}, {3.495832633076838*^9, 
   3.4958326471968575`*^9}, {3.4958327900870576`*^9, 3.495832805227079*^9}, 
   3.495832855397149*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "p_."}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "*", 
     RowBox[{
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "c"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "p"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "a"}], "*", "d"}], "+", 
            RowBox[{"b", "*", "c", "*", 
             RowBox[{"x", "^", 
              RowBox[{"(", 
               RowBox[{"n", "-", "p"}], ")"}]}]}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "p"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"FractionQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n", ",", "p"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"0", "<", "p", "<", "n"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4958220678423057`*^9, {3.4958223249151573`*^9, 
   3.4958223275047617`*^9}, 3.495832538936706*^9, 3.4958326082168036`*^9, {
   3.495832764717022*^9, 3.495832766137024*^9}, 3.49583283483712*^9, 
   3.495833007387362*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"c", " ", 
      SuperscriptBox["x", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}]}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, 
   3.495737346831905*^9, {3.495737663592348*^9, 3.495737664152349*^9}, 
   3.496060915740384*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.4958402261046853`*^9, {3.496023509288479*^9, 
   3.4960235133288865`*^9}, {3.4960246848481445`*^9, 3.496024709340188*^9}}],

Cell[TextData[{
 "Note: If ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["b", "2"], " ", "c"}], "a"], "<", "0"}]]],
 ", antiderivative can be expressed more simply as the arcsine or hyperbolic \
arcsine of a linear term"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4957378295025806`*^9, 3.495737851822612*^9}, {
   3.495741934528328*^9, 3.495741939508334*^9}, {3.496024357430769*^9, 
   3.4960243633587794`*^9}, {3.4960244100652614`*^9, 
   3.4960244100652614`*^9}, {3.496024453745338*^9, 3.496024453745338*^9}, {
   3.496024729355023*^9, 3.4960248634528584`*^9}, {3.49602490424693*^9, 
   3.496024935462585*^9}, {3.4960249739322524`*^9, 3.4960250600600038`*^9}}],

Cell[TextData[{
 "Rule: If ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["b", "2"], " ", "c"}], "a"], "<", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4957378295025806`*^9, 3.495737851822612*^9}, {
   3.495741934528328*^9, 3.495741939508334*^9}, {3.496024357430769*^9, 
   3.4960243633587794`*^9}, {3.4960244100652614`*^9, 
   3.4960244100652614`*^9}, {3.496024453745338*^9, 3.496024453745338*^9}, 
   3.496024729355023*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"c", " ", 
      SuperscriptBox["x", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        FractionBox["b", "x"]}], ")"}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox["1", 
        SqrtBox[
         RowBox[{
          RowBox[{"b", " ", "c", " ", "x"}], "+", 
          RowBox[{"a", " ", "c", " ", 
           SuperscriptBox["x", "2"]}]}]]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.4957376870823812`*^9, 3.495737694712392*^9}, 
   3.495741604927866*^9, 3.495741758498081*^9, {3.496024160558423*^9, 
   3.496024182304861*^9}, {3.4960242138325167`*^9, 3.4960242633002033`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"c_.", "*", 
       RowBox[{"x_", "^", "2"}], "*", 
       RowBox[{"(", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "/", "x_"}]}], ")"}]}], "]"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"Sqrt", "[", 
       RowBox[{
        RowBox[{"b", "*", "c", "*", "x"}], "+", 
        RowBox[{"a", "*", "c", "*", 
         RowBox[{"x", "^", "2"}]}]}], "]"}]}], ",", "x"}], "]"}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"NegativeQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "*", 
      RowBox[{"c", "/", "a"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.495737360941924*^9, {3.495737704152405*^9, 3.4957377301824417`*^9}, {
   3.4957418580882206`*^9, 3.495741880038251*^9}, {3.495741911058295*^9, 
   3.4957419161683016`*^9}, {3.4960239988641396`*^9, 3.496024010127359*^9}, {
   3.496024041951415*^9, 3.4960240758970747`*^9}, {3.49602410747153*^9, 
   3.4960241093435335`*^9}, {3.496024298774666*^9, 3.4960243189611015`*^9}, {
   3.4960244129824667`*^9, 3.4960244146360693`*^9}, {3.4960244579261456`*^9, 
   3.4960245022770233`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", " ", "c"}], ">", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4957378295025806`*^9, 3.495737851822612*^9}, {
   3.495741934528328*^9, 3.495741939508334*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"c", " ", 
      SuperscriptBox["x", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox["2", 
       RowBox[{"n", " ", 
        SqrtBox[
         RowBox[{"a", " ", "c"}]]}]]}]}]}], "  ", 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     RowBox[{
      SqrtBox[
       RowBox[{"a", " ", "c"}]], " ", "x"}], 
     SqrtBox[
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "n"]}]}], ")"}]}]]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.4957376870823812`*^9, 3.495737694712392*^9}, 
   3.495741604927866*^9, 3.495741758498081*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"c_.", "*", 
       RowBox[{"x_", "^", "2"}], "*", 
       RowBox[{"(", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"x_", "^", "n_."}]}]}], ")"}]}], "]"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "/", 
     RowBox[{"(", 
      RowBox[{"n", "*", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{"a", "*", "c"}], ",", "2"}], "]"}]}], ")"}]}], "*", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{
      RowBox[{"Rt", "[", 
       RowBox[{
        RowBox[{"a", "*", "c"}], ",", "2"}], "]"}], "*", 
      RowBox[{"x", "/", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"c", "*", 
         RowBox[{"x", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "^", "n"}]}]}], ")"}]}], "]"}]}]}], "]"}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"PosQ", "[", 
     RowBox[{"a", "*", "c"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.495737360941924*^9, {3.495737704152405*^9, 3.4957377301824417`*^9}, {
   3.4957418580882206`*^9, 3.495741880038251*^9}, {3.495741911058295*^9, 
   3.4957419161683016`*^9}, {3.4960239988641396`*^9, 3.496024010127359*^9}, {
   3.496024041951415*^9, 3.4960240758970747`*^9}, {3.49602410747153*^9, 
   3.4960241093435335`*^9}, {3.496060363998615*^9, 3.496060380737444*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"\[Not]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"a", " ", "c"}], ">", "0"}], ")"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4957378295025806`*^9, 3.495737851822612*^9}, {
   3.495741934528328*^9, 3.4957419680783744`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"c", " ", 
      SuperscriptBox["x", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox["2", 
       RowBox[{"n", " ", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", "a"}], " ", "c"}]]}]]}]}]}], " ", 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{
      SqrtBox[
       RowBox[{
        RowBox[{"-", "a"}], " ", "c"}]], " ", "x"}], 
     SqrtBox[
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "n"]}]}], ")"}]}]]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.4957376870823812`*^9, 3.495737694712392*^9}, 
   3.495741604927866*^9, 3.495741758498081*^9, 3.49574199310841*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"c_.", "*", 
       RowBox[{"x_", "^", "2"}], "*", 
       RowBox[{"(", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"x_", "^", "n_."}]}]}], ")"}]}], "]"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "/", 
     RowBox[{"(", 
      RowBox[{"n", "*", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "a"}], "*", "c"}], ",", "2"}], "]"}]}], ")"}]}], "*", 
    RowBox[{"ArcTan", "[", 
     RowBox[{
      RowBox[{"Rt", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "a"}], "*", "c"}], ",", "2"}], "]"}], "*", 
      RowBox[{"x", "/", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"c", "*", 
         RowBox[{"x", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "^", "n"}]}]}], ")"}]}], "]"}]}]}], "]"}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NegQ", "[", 
     RowBox[{"a", "*", "c"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.495737360941924*^9, {3.495737704152405*^9, 3.4957377301824417`*^9}, {
   3.4957418580882206`*^9, 3.495741880038251*^9}, {3.495741911058295*^9, 
   3.4957419161683016`*^9}, {3.495742016388442*^9, 3.4957420263184557`*^9}},
 Background->GrayLevel[0.85]]
}, Open  ]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.496027220845801*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495840214754669*^9, 3.495840507285079*^9, 
   3.495841665776701*^9, {3.4960165944385605`*^9, 3.4960166050585756`*^9}, 
   3.496027220845801*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "+", "n"}], "=", "2"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4957378295025806`*^9, 3.495737851822612*^9}, {
   3.495741934528328*^9, 3.495741939508334*^9}, 3.496016533838476*^9, {
   3.496017611649985*^9, 3.4960176335000153`*^9}, 3.4960178382503023`*^9, 
   3.496027220845801*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"c", " ", 
      SuperscriptBox["x", "m"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox["1", 
        SqrtBox[
         RowBox[{"c", " ", 
          SuperscriptBox["x", "2"], 
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"a", " ", 
             SuperscriptBox["x", 
              RowBox[{"m", "-", "2"}]]}]}], ")"}]}]]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.4957376870823812`*^9, 3.495737694712392*^9}, 
   3.495741604927866*^9, 3.495741758498081*^9, {3.496016547998496*^9, 
   3.4960165629385166`*^9}, {3.4960175515599008`*^9, 3.4960175956299624`*^9}, 
   3.496017713780128*^9, 3.496017772900211*^9, 3.496027220845801*^9, {
   3.496060704219612*^9, 3.4960607207868414`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.496027220845801*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"c_.", "*", 
       RowBox[{"x_", "^", "m_."}], "*", 
       RowBox[{"(", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"x_", "^", "n_."}]}]}], ")"}]}], "]"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"c", "*", 
        RowBox[{"x", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"b", "+", 
          RowBox[{"a", "*", 
           RowBox[{"x", "^", 
            RowBox[{"(", 
             RowBox[{"m", "-", "2"}], ")"}]}]}]}], ")"}]}], "]"}]}], ",", 
     "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "m", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", "n", "-", "2"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.495737360941924*^9, {3.495737704152405*^9, 3.4957377301824417`*^9}, {
   3.4957418580882206`*^9, 3.495741880038251*^9}, {3.495741911058295*^9, 
   3.4957419161683016`*^9}, {3.496016620108597*^9, 3.4960166449586315`*^9}, {
   3.4960176377400217`*^9, 3.4960176665700617`*^9}, {3.4960176974801054`*^9, 
   3.496017705350116*^9}, {3.496017824380283*^9, 3.4960178246302834`*^9}, 
   3.496027220845801*^9, {3.496060821360218*^9, 3.4960608362894444`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.49539151296132*^9, 3.495401154999972*^9, 3.495401305830183*^9, 
   3.4954013713302746`*^9, {3.4957423632589273`*^9, 3.495742374988944*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4957378295025806`*^9, 3.495737851822612*^9}, {
   3.4957422843288174`*^9, 3.49574228614882*^9}, {3.495742326848877*^9, 
   3.4957423329688854`*^9}, {3.4957425703992176`*^9, 
   3.4957425732192216`*^9}, {3.49601892956183*^9, 3.496018933711836*^9}, 
   3.4960615445618887`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"c", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", 
         SuperscriptBox["x", "p"]}], "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox["1", 
        SqrtBox[
         RowBox[{"c", " ", 
          SuperscriptBox["x", "2"], 
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"a", " ", 
             SuperscriptBox["x", 
              RowBox[{"p", "-", "2"}]]}]}], ")"}]}]]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, {3.495737937852732*^9, 3.4957379608027644`*^9}, {
   3.495743066449912*^9, 3.4957431396800146`*^9}, {3.495743191950088*^9, 
   3.495743240980157*^9}, {3.4960194950726213`*^9, 3.4960195113326445`*^9}, {
   3.4960195730127306`*^9, 3.4960196440028305`*^9}, {3.4960197591329913`*^9, 
   3.4960197617029953`*^9}, {3.496027314867166*^9, 3.4960273508096294`*^9}, {
   3.4960607519244957`*^9, 3.496060764903719*^9}, {3.496061476514569*^9, 
   3.496061533719869*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"c_.", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a_.", "*", 
          RowBox[{"x_", "^", "p_"}]}], "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], ")"}]}], "]"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"c", "*", 
        RowBox[{"x", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"b", "+", 
          RowBox[{"a", "*", 
           RowBox[{"x", "^", 
            RowBox[{"(", 
             RowBox[{"p", "-", "2"}], ")"}]}]}]}], ")"}]}], "]"}]}], ",", 
     "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "p"}], "}"}], ",", "x"}], 
    "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4957373679919343`*^9, {3.4957378728826413`*^9, 
   3.4957378965526743`*^9}, {3.4957433258302755`*^9, 3.495743388330363*^9}, 
   3.4957442352015486`*^9, {3.495746345124502*^9, 3.4957463525445127`*^9}, {
   3.4960191411521263`*^9, 3.4960191626121564`*^9}, {3.496019812313066*^9, 
   3.4960198681731443`*^9}, {3.49602742531536*^9, 3.4960274625838256`*^9}, {
   3.4960608443234587`*^9, 3.496060856132679*^9}, {3.4960616379748526`*^9, 
   3.4960616815457287`*^9}, 3.4960617463170424`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.49539151296132*^9, 3.495401154999972*^9, 3.495401305830183*^9, 
   3.4954013713302746`*^9, {3.4957423632589273`*^9, 3.495742374988944*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", " ", 
       SuperscriptBox["x", "p"]}], "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", "-", "m"}]]}]}], ")"}]}], "=", 
   RowBox[{
    SuperscriptBox["x", "2"], 
    RowBox[{"(", 
     RowBox[{"b", "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", 
        RowBox[{"m", "+", "p", "-", "2"}]]}]}], ")"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.49539151296132*^9, 3.495401154999972*^9, 3.495401305830183*^9, 
   3.4954013713302746`*^9, {3.4957423632589273`*^9, 3.4957424597090626`*^9}, {
   3.4957425785792294`*^9, 3.495742606329268*^9}, {3.4960190463919935`*^9, 
   3.4960190735420313`*^9}, {3.496019739482964*^9, 3.496019784343027*^9}, {
   3.4960273803872814`*^9, 3.496027396361709*^9}, {3.4960615970559807`*^9, 
   3.496061609738803*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "+", "n"}], "=", "2"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4957378295025806`*^9, 3.495737851822612*^9}, {
   3.4957422843288174`*^9, 3.49574228614882*^9}, {3.495742326848877*^9, 
   3.4957423329688854`*^9}, {3.4957425703992176`*^9, 
   3.4957425732192216`*^9}, {3.49601892956183*^9, 3.496018933711836*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"c", " ", 
      SuperscriptBox["x", "m"], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", 
         SuperscriptBox["x", "p"]}], "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox["1", 
        SqrtBox[
         RowBox[{"c", " ", 
          SuperscriptBox["x", "2"], 
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"a", " ", 
             SuperscriptBox["x", 
              RowBox[{"m", "+", "p", "-", "2"}]]}]}], ")"}]}]]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, {3.495737937852732*^9, 3.4957379608027644`*^9}, {
   3.495743066449912*^9, 3.4957431396800146`*^9}, {3.495743191950088*^9, 
   3.495743240980157*^9}, {3.4960194950726213`*^9, 3.4960195113326445`*^9}, {
   3.4960195730127306`*^9, 3.4960196440028305`*^9}, {3.4960197591329913`*^9, 
   3.4960197617029953`*^9}, {3.496027314867166*^9, 3.4960273508096294`*^9}, {
   3.4960607519244957`*^9, 3.496060764903719*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"c_.", "*", 
       RowBox[{"x_", "^", "m_."}], "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a_.", "*", 
          RowBox[{"x_", "^", "p_."}]}], "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"x_", "^", "n_."}]}]}], ")"}]}], "]"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"c", "*", 
        RowBox[{"x", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"b", "+", 
          RowBox[{"a", "*", 
           RowBox[{"x", "^", 
            RowBox[{"(", 
             RowBox[{"m", "+", "p", "-", "2"}], ")"}]}]}]}], ")"}]}], "]"}]}],
      ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "m", ",", "n", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", "n", "-", "2"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4957373679919343`*^9, {3.4957378728826413`*^9, 
   3.4957378965526743`*^9}, {3.4957433258302755`*^9, 3.495743388330363*^9}, 
   3.4957442352015486`*^9, {3.495746345124502*^9, 3.4957463525445127`*^9}, {
   3.4960191411521263`*^9, 3.4960191626121564`*^9}, {3.496019812313066*^9, 
   3.4960198681731443`*^9}, {3.49602742531536*^9, 3.4960274625838256`*^9}, {
   3.4960608443234587`*^9, 3.496060856132679*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}]], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, 
   3.496260584257001*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"e_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a_.", "+", 
           RowBox[{"b_.", "*", "x_"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], ")"}]}]}], ")"}], "^", "n_"}], ",", 
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"e", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "c"}], "-", 
         RowBox[{"a", "*", "d"}]}], ")"}]}], ",", 
      RowBox[{"Subst", "[", 
       RowBox[{
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", "n"}], "/", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"b", "*", "e"}], "-", 
              RowBox[{"d", "*", "x"}]}], ")"}], "^", "2"}]}], ",", "x"}], 
         "]"}], ",", "x", ",", 
        RowBox[{"e", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}]}]}]}], "]"}]}], "]"}], " ", "/;",
     "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
       "x"}], "]"}], " ", "&&", " ", 
     RowBox[{"FractionQ", "[", "n", "]"}], " ", "&&", " ", 
     RowBox[{"NonzeroQ", "[", 
      RowBox[{
       RowBox[{"b", "*", "c"}], "-", 
       RowBox[{"a", "*", "d"}]}], "]"}]}]}]}], " ", "*)"}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4962605923570123`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x_", "^", "m_."}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"e_.", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a_.", "+", 
            RowBox[{"b_.", "*", "x_"}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], ")"}]}]}], ")"}], "^", "n_"}]}], 
     ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"e", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "c"}], "-", 
         RowBox[{"a", "*", "d"}]}], ")"}]}], ",", 
      RowBox[{"Subst", "[", 
       RowBox[{
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", "n"}], "*", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "a"}], "*", "e"}], "+", 
               RowBox[{"c", "*", "x"}]}], ")"}], "^", "m"}], "/", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"b", "*", "e"}], "-", 
               RowBox[{"d", "*", "x"}]}], ")"}], "^", 
             RowBox[{"(", 
              RowBox[{"m", "+", "2"}], ")"}]}]}]}], ",", "x"}], "]"}], ",", 
        "x", ",", 
        RowBox[{"e", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}]}]}]}], "]"}]}], "]"}], " ", "/;",
     "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
       "x"}], "]"}], " ", "&&", " ", 
     RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
     RowBox[{"FractionQ", "[", "n", "]"}], " ", "&&", " ", 
     RowBox[{"NonzeroQ", "[", 
      RowBox[{
       RowBox[{"b", "*", "c"}], "-", 
       RowBox[{"a", "*", "d"}]}], "]"}]}]}]}], " ", "*)"}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4962606167870464`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"f_", "+", 
         RowBox[{"g_.", "*", "x_"}]}], ")"}], "^", "m_"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"e_.", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a_.", "+", 
            RowBox[{"b_.", "*", "x_"}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], ")"}]}]}], ")"}], "^", "n_"}]}], 
     ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "g"}], ",", 
      RowBox[{"Subst", "[", 
       RowBox[{
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", "m"}], "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"e", "*", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"a", "-", 
                 RowBox[{"b", "*", 
                  RowBox[{"f", "/", "g"}]}], "+", 
                 RowBox[{
                  RowBox[{"b", "/", "g"}], "*", "x"}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"c", "-", 
                 RowBox[{"d", "*", 
                  RowBox[{"f", "/", "g"}]}], "+", 
                 RowBox[{
                  RowBox[{"d", "/", "g"}], "*", "x"}]}], ")"}]}]}], ")"}], 
            "^", "n"}]}], ",", "x"}], "]"}], ",", "x", ",", 
        RowBox[{"f", "+", 
         RowBox[{"g", "*", "x"}]}]}], "]"}]}], "]"}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}], 
        "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
     RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
     RowBox[{"m", "<", "0"}], " ", "&&", " ", 
     RowBox[{"FractionQ", "[", "n", "]"}], " ", "&&", " ", 
     RowBox[{"NonzeroQ", "[", 
      RowBox[{
       RowBox[{"b", "*", "c"}], "-", 
       RowBox[{"a", "*", "d"}]}], "]"}]}]}]}], " ", "*)"}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, {3.4962606167870464`*^9, 3.496260630037065*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SqrtBox[
    RowBox[{
     RowBox[{"a", " ", "x"}], "+", 
     SqrtBox[
      RowBox[{"b", "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["x", "2"]}]}]]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, 
   3.4962533533568773`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, 3.4962535418071413`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SqrtBox[
    RowBox[{
     RowBox[{"a", " ", "x"}], "+", 
     SqrtBox[
      RowBox[{"b", "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["x", "2"]}]}]]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["2", 
      RowBox[{"3", " ", "a"}]]}]}], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", "a", " ", "x"}], "-", 
     SqrtBox[
      RowBox[{"b", "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}]]}], ")"}], " ", 
   SqrtBox[
    RowBox[{
     RowBox[{"a", " ", "x"}], "+", 
     SqrtBox[
      RowBox[{"b", "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}]]}]]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.4962533765969105`*^9, 3.496253489017068*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"a_.", "*", "x_"}], "+", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"b_", "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], "]"}]}], "]"}], ",", " ", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"2", "*", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", "*", "a", "*", "x"}], "-", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"b", "+", 
        RowBox[{"c", "*", 
         RowBox[{"x", "^", "2"}]}]}], "]"}]}], ")"}], "*", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"a", "*", "x"}], "+", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"b", "+", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "2"}]}]}], "]"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"3", "*", "a"}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"c", "-", 
      RowBox[{"a", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4962533638568926`*^9, {3.4962537903574896`*^9, 3.4962537978075*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, 3.4962536550172997`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SqrtBox[
    RowBox[{
     RowBox[{"a", " ", "x"}], "-", 
     SqrtBox[
      RowBox[{"b", "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["x", "2"]}]}]]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["2", 
      RowBox[{"3", " ", "a"}]]}]}], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", "a", " ", "x"}], "+", 
     SqrtBox[
      RowBox[{"b", "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}]]}], ")"}], " ", 
   SqrtBox[
    RowBox[{
     RowBox[{"a", " ", "x"}], "-", 
     SqrtBox[
      RowBox[{"b", "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}]]}]]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, {3.496253594947216*^9, 3.496253600337223*^9}, 
   3.4962536331072693`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"a_.", "*", "x_"}], "-", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"b_", "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], "]"}]}], "]"}], ",", " ", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"2", "*", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", "*", "a", "*", "x"}], "+", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"b", "+", 
        RowBox[{"c", "*", 
         RowBox[{"x", "^", "2"}]}]}], "]"}]}], ")"}], "*", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"a", "*", "x"}], "-", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"b", "+", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "2"}]}]}], "]"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"3", "*", "a"}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"c", "-", 
      RowBox[{"a", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4962535722271843`*^9, 3.496253803367508*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SqrtBox[
    RowBox[{"a", "+", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["a", "2"], "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}]}]]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, 
   3.4962533533568773`*^9, 3.4962538524075766`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, 3.4962535418071413`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SqrtBox[
    RowBox[{"a", "+", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["a", "2"], "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}]}]]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["2", 
      RowBox[{"3", " ", "b", " ", "x"}]]}]}], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["a", "2"]}], "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"a", " ", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "2"]}]}]]}]}], ")"}], 
   SqrtBox[
    RowBox[{"a", "+", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["a", "2"], "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}]}]]}]]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.4962533765969105`*^9, 3.496253489017068*^9, 
   3.4962539191876698`*^9, 3.4962539975677795`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"a_", "+", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"c_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], "]"}]}], "]"}], ",", " ", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"2", "*", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"a", "^", "2"}]}], "+", 
      RowBox[{"b", "*", 
       RowBox[{"x", "^", "2"}]}], "+", 
      RowBox[{"a", "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "2"}]}]}], "]"}]}]}], ")"}], "*", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"a", "+", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "2"}]}]}], "]"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"3", "*", "b", "*", "x"}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"c", "-", 
      RowBox[{"a", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4962533638568926`*^9, {3.4962537903574896`*^9, 3.4962537978075*^9}, {
   3.4962538754076085`*^9, 3.4962538994876423`*^9}, {3.4962540190678096`*^9, 
   3.4962540243578167`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, 3.4962536550172997`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SqrtBox[
    RowBox[{"a", "-", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["a", "2"], "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}]}]]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["2", 
      RowBox[{"3", " ", "b", " ", "x"}]]}]}], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["a", "2"]}], "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "2"]}], "-", 
     RowBox[{"a", " ", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "2"]}]}]]}]}], ")"}], " ", 
   SqrtBox[
    RowBox[{"a", "-", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["a", "2"], "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}]}]]}]]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, {3.496253594947216*^9, 3.496253600337223*^9}, 
   3.4962536331072693`*^9, {3.496253920957672*^9, 3.496253924367677*^9}, 
   3.4962541041579285`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"a_", "-", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"c_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], "]"}]}], "]"}], ",", " ", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"2", "*", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"a", "^", "2"}]}], "+", 
      RowBox[{"b", "*", 
       RowBox[{"x", "^", "2"}]}], "-", 
      RowBox[{"a", "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "2"}]}]}], "]"}]}]}], ")"}], "*", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"a", "-", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "2"}]}]}], "]"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"3", "*", "b", "*", "x"}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"c", "-", 
      RowBox[{"a", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4962535722271843`*^9, 3.496253803367508*^9, {
   3.4962538819376173`*^9, 3.496253902937647*^9}, {3.496254056327862*^9, 
   3.49625406214787*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["u", 
    RowBox[{"v", "+", 
     SqrtBox["w"]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, 
   3.496254209828077*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.49539151296132*^9, {3.4962543737983065`*^9, 3.496254377418311*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"z", "+", "w"}]], "=", 
   FractionBox[
    RowBox[{"z", "-", "w"}], 
    RowBox[{
     SuperscriptBox["z", "2"], "-", 
     SuperscriptBox["w", "2"]}]]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, {
   3.496254445358406*^9, 3.4962544474684095`*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, 3.496254247248129*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["u", 
    RowBox[{
     RowBox[{"a", " ", 
      SuperscriptBox["x", "m"]}], "+", 
     RowBox[{"b", " ", 
      SqrtBox[
       RowBox[{"c", " ", 
        SuperscriptBox["x", "n"]}]]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox[
        RowBox[{"u", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", " ", 
            SuperscriptBox["x", "m"]}], "-", 
           RowBox[{"b", " ", 
            SqrtBox[
             RowBox[{"c", " ", 
              SuperscriptBox["x", "n"]}]]}]}], ")"}]}], 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["x", 
           RowBox[{"2", " ", "m"}]]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", "c", " ", 
          SuperscriptBox["x", "n"]}]}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.4962542869781847`*^9, {3.4962543213682327`*^9, 
   3.496254340168259*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a_.", "*", 
        RowBox[{"x_", "^", "m_."}]}], "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"c_.", "*", 
          RowBox[{"x_", "^", "n_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"u", "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "*", 
          RowBox[{"x", "^", "m"}]}], "-", 
         RowBox[{"b", "*", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"a", "^", "2"}], "*", 
          RowBox[{"x", "^", 
           RowBox[{"(", 
            RowBox[{"2", "*", "m"}], ")"}]}]}], "-", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "*", "c", "*", 
          RowBox[{"x", "^", "n"}]}]}], ")"}]}]}], ",", "x"}], "]"}], " ", "/;",
    "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "m", ",", "n"}], "}"}], ",", 
     "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.496254220688092*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{3.49539151296132*^9, 3.496254544498545*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"b", " ", 
    SuperscriptBox["e", "2"]}], "=", 
   RowBox[{"d", " ", 
    SuperscriptBox["f", "2"]}]}]]],
 ",",
 " then",
 " ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"e", " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "z"}]}]]}], "+", 
     RowBox[{"f", " ", 
      SqrtBox[
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "z"}]}]]}]}]], "=", 
   FractionBox[
    RowBox[{
     RowBox[{"e", " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "z"}]}]]}], "-", 
     RowBox[{"f", " ", 
      SqrtBox[
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "z"}]}]]}]}], 
    RowBox[{
     RowBox[{"a", " ", 
      SuperscriptBox["e", "2"]}], "-", 
     RowBox[{"c", " ", 
      SuperscriptBox["f", "2"]}]}]]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, {
   3.496254503088487*^9, 3.4962545521285563`*^9}, {3.4962578206431317`*^9, 
   3.496257828163142*^9}, 3.496960922297987*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"m", "<", "0"}], " ", "\[And]", " ", 
    RowBox[{"b", " ", 
     SuperscriptBox["e", "2"]}]}], "=", 
   RowBox[{"d", " ", 
    SuperscriptBox["f", "2"]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.496254584788602*^9, 
   3.496254666328716*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"e", " ", 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "n"]}]}]]}], "+", 
      RowBox[{"f", " ", 
       SqrtBox[
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "n"]}]}]]}]}], ")"}], "m"], " ", 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", 
         SuperscriptBox["e", "2"]}], "-", 
        RowBox[{"c", " ", 
         SuperscriptBox["f", "2"]}]}], ")"}], "m"]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["u", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"e", " ", 
          SqrtBox[
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox["x", "n"]}]}]]}], "-", 
         RowBox[{"f", " ", 
          SqrtBox[
           RowBox[{"c", "+", 
            RowBox[{"d", " ", 
             SuperscriptBox["x", "n"]}]}]]}]}], ")"}], "m"]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4962546968087587`*^9, {3.4962548323089485`*^9, 
   3.4962549058190513`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"e_.", "*", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"a_.", "+", 
           RowBox[{"b_.", "*", 
            RowBox[{"x_", "^", "n_."}]}]}], "]"}]}], "+", 
        RowBox[{"f_.", "*", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", 
            RowBox[{"x_", "^", "n_."}]}]}], "]"}]}]}], ")"}], "^", "m_"}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "*", 
         RowBox[{"e", "^", "2"}]}], "-", 
        RowBox[{"c", "*", 
         RowBox[{"f", "^", "2"}]}]}], ")"}], "^", "m"}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"e", "*", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", 
               RowBox[{"x", "^", "n"}]}]}], "]"}]}], "-", 
           RowBox[{"f", "*", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", 
               RowBox[{"x", "^", "n"}]}]}], "]"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "m"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "n"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", 
       RowBox[{"e", "^", "2"}]}], "-", 
      RowBox[{"d", "*", 
       RowBox[{"f", "^", "2"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4962544854184628`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{3.49539151296132*^9, 3.496254544498545*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", " ", 
    SuperscriptBox["e", "2"]}], "=", 
   RowBox[{"c", " ", 
    SuperscriptBox["f", "2"]}]}]]],
 ",",
 " then",
 " ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"e", " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "z"}]}]]}], "+", 
     RowBox[{"f", " ", 
      SqrtBox[
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "z"}]}]]}]}]], "=", 
   FractionBox[
    RowBox[{
     RowBox[{"e", " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "z"}]}]]}], "-", 
     RowBox[{"f", " ", 
      SqrtBox[
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "z"}]}]]}]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", " ", 
        SuperscriptBox["e", "2"]}], "-", 
       RowBox[{"d", " ", 
        SuperscriptBox["f", "2"]}]}], ")"}], " ", "z"}]]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, {
   3.496254503088487*^9, 3.4962545521285563`*^9}, {3.4962550867993045`*^9, 
   3.496255099169322*^9}, {3.4962578501931734`*^9, 3.496257859403186*^9}, 
   3.496960928647996*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"m", "<", "0"}], " ", "\[And]", " ", 
    RowBox[{"a", " ", 
     SuperscriptBox["e", "2"]}]}], "=", 
   RowBox[{"c", " ", 
    SuperscriptBox["f", "2"]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.496254584788602*^9, 
   3.496254666328716*^9}, 3.4962551196793504`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"e", " ", 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "n"]}]}]]}], "+", 
      RowBox[{"f", " ", 
       SqrtBox[
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "n"]}]}]]}]}], ")"}], "m"], " ", 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", " ", 
         SuperscriptBox["e", "2"]}], "-", 
        RowBox[{"d", " ", 
         SuperscriptBox["f", "2"]}]}], ")"}], "m"]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"u", " ", 
       SuperscriptBox["x", 
        RowBox[{"m", " ", "n"}]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"e", " ", 
          SqrtBox[
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox["x", "n"]}]}]]}], "-", 
         RowBox[{"f", " ", 
          SqrtBox[
           RowBox[{"c", "+", 
            RowBox[{"d", " ", 
             SuperscriptBox["x", "n"]}]}]]}]}], ")"}], "m"]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4962546968087587`*^9, {3.4962548323089485`*^9, 
   3.4962549058190513`*^9}, 3.4962552252294984`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"e_.", "*", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"a_.", "+", 
           RowBox[{"b_.", "*", 
            RowBox[{"x_", "^", "n_."}]}]}], "]"}]}], "+", 
        RowBox[{"f_.", "*", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", 
            RowBox[{"x_", "^", "n_."}]}]}], "]"}]}]}], ")"}], "^", "m_"}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "*", 
         RowBox[{"e", "^", "2"}]}], "-", 
        RowBox[{"d", "*", 
         RowBox[{"f", "^", "2"}]}]}], ")"}], "^", "m"}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{"x", "^", 
         RowBox[{"(", 
          RowBox[{"m", "*", "n"}], ")"}]}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"e", "*", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", 
               RowBox[{"x", "^", "n"}]}]}], "]"}]}], "-", 
           RowBox[{"f", "*", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", 
               RowBox[{"x", "^", "n"}]}]}], "]"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "m"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "n"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"e", "^", "2"}]}], "-", 
      RowBox[{"c", "*", 
       RowBox[{"f", "^", "2"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4962544854184628`*^9, 3.4962550675192776`*^9, {
   3.496255180479436*^9, 3.4962551897694483`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{3.49539151296132*^9, 3.496254544498545*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["a", "2"], "=", 
   RowBox[{
    SuperscriptBox["b", "2"], " ", "c"}]}]]],
 ",",
 " then",
 " ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SqrtBox[
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "z"}]}]]}]}]], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["a", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", "d", " ", "z"}]]}], "+", 
    FractionBox[
     SqrtBox[
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "z"}]}]], 
     RowBox[{"b", " ", "d", " ", "z"}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, {
   3.496254503088487*^9, 3.4962545521285563`*^9}, {3.4962550867993045`*^9, 
   3.496255099169322*^9}, {3.4962563485310707`*^9, 3.4962563691811*^9}, 
   3.496256430231185*^9, {3.4962565636413717`*^9, 3.496256578721393*^9}, 
   3.4969609376180086`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["a", "2"], "=", 
   RowBox[{
    SuperscriptBox["b", "2"], " ", "c"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.496254584788602*^9, 
   3.496254666328716*^9}, 3.4962551196793504`*^9, {3.4962555159499054`*^9, 
   3.4962555362599335`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["u", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SqrtBox[
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "n"]}]}]]}]}]], " ", 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox["a", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "d"}]]}]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox["u", 
       SuperscriptBox["x", "n"]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"b", " ", "d"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"u", " ", 
       SqrtBox[
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "n"]}]}]]}], 
      SuperscriptBox["x", "n"]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4962546968087587`*^9, {3.4962548323089485`*^9, 
   3.4962549058190513`*^9}, 3.4962552252294984`*^9, {3.496255308179614*^9, 
   3.4962553130796213`*^9}, {3.496255354359679*^9, 3.4962553856297226`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"c_", "+", 
          RowBox[{"d_.", "*", 
           RowBox[{"x_", "^", "n_"}]}]}], "]"}]}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "a"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", "d"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"u", "/", 
         RowBox[{"x", "^", "n"}]}], ",", "x"}], "]"}]}], "]"}], " ", "+", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", "d"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"u", "*", 
         RowBox[{
          RowBox[{"Sqrt", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "/", 
          RowBox[{"x", "^", "n"}]}]}], ",", "x"}], "]"}]}], "]"}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", "c"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4962544854184628`*^9, 3.4962550675192776`*^9, {
   3.496255180479436*^9, 3.4962551897694483`*^9}, 3.4962553035096083`*^9, {
   3.496255407829754*^9, 3.496255437329795*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{3.49539151296132*^9, 3.496254544498545*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["a", "2"], "=", 
   RowBox[{
    SuperscriptBox["b", "2"], " ", "d"}]}]]],
 ",",
 " then",
 " ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"a", " ", "z"}], "+", 
     RowBox[{"b", " ", 
      SqrtBox[
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["z", "2"]}]}]]}]}]], "=", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "a"}], " ", "z"}], "+", 
     RowBox[{"b", " ", 
      SqrtBox[
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["z", "2"]}]}]]}]}], 
    RowBox[{
     SuperscriptBox["b", "2"], " ", "c"}]]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, {
   3.496254503088487*^9, 3.4962545521285563`*^9}, {3.4962550867993045`*^9, 
   3.496255099169322*^9}, {3.4962563485310707`*^9, 3.4962563691811*^9}, 
   3.4969609433880167`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["a", "2"], "=", 
   RowBox[{
    SuperscriptBox["b", "2"], " ", "d"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.496254584788602*^9, 
   3.496254666328716*^9}, 3.4962551196793504`*^9, {3.4962555159499054`*^9, 
   3.4962555362599335`*^9}, 3.4962557234601955`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["u", 
     RowBox[{
      RowBox[{"a", " ", 
       SuperscriptBox["x", "m"]}], "+", 
      RowBox[{"b", " ", 
       SqrtBox[
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", 
           RowBox[{"2", " ", "m"}]]}]}]]}]}]], " ", 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox["a", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}]]}]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{"u", " ", 
      SuperscriptBox["x", "m"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"b", " ", "c"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{"u", " ", 
     SqrtBox[
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", 
         RowBox[{"2", " ", "m"}]]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4962546968087587`*^9, {3.4962548323089485`*^9, 
   3.4962549058190513`*^9}, 3.4962552252294984`*^9, {3.496255308179614*^9, 
   3.4962553130796213`*^9}, {3.496255354359679*^9, 3.4962553856297226`*^9}, {
   3.4962556577101035`*^9, 3.496255684110141*^9}, 3.496255767150257*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a_.", "*", 
        RowBox[{"x_", "^", "m_."}]}], "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"c_", "+", 
          RowBox[{"d_.", "*", 
           RowBox[{"x_", "^", "n_"}]}]}], "]"}]}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "a"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", "c"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"u", "*", 
         RowBox[{"x", "^", "m"}]}], ",", "x"}], "]"}]}], "]"}], " ", "+", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", "c"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"u", "*", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", 
            RowBox[{"x", "^", "n"}]}]}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "m", ",", "n"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"n", "-", 
      RowBox[{"2", "*", "m"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", "d"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4962544854184628`*^9, 3.4962550675192776`*^9, {
   3.496255180479436*^9, 3.4962551897694483`*^9}, 3.4962553035096083`*^9, {
   3.496255407829754*^9, 3.496255437329795*^9}, 3.496255607880034*^9, {
   3.4962557140201826`*^9, 3.49625574091022*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{3.49539151296132*^9, 3.496254544498545*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["a", "2"], "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["c", "2"], " ", "d"}], " ", "\[And]", " ", 
     SuperscriptBox["b", "2"]}], "=", 
    RowBox[{
     SuperscriptBox["c", "2"], " ", "e"}]}]}]]],
 ",",
 " then",
 " ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "z"}], "+", 
     RowBox[{"c", " ", 
      SqrtBox[
       RowBox[{"d", "+", 
        RowBox[{"e", " ", 
         SuperscriptBox["z", "2"]}]}]]}]}]], "=", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", " ", "a"}]], "+", 
    FractionBox["1", 
     RowBox[{"2", " ", "b", " ", "z"}]], "-", 
    FractionBox[
     RowBox[{"c", " ", 
      SqrtBox[
       RowBox[{"d", "+", 
        RowBox[{"e", " ", 
         SuperscriptBox["z", "2"]}]}]]}], 
     RowBox[{"2", " ", "a", " ", "b", " ", "z"}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, {
   3.496254503088487*^9, 3.4962545521285563`*^9}, {3.4962550867993045`*^9, 
   3.496255099169322*^9}, {3.4962563485310707`*^9, 3.4962563691811*^9}, {
   3.496256966521936*^9, 3.496257009251996*^9}, {3.496257086172104*^9, 
   3.4962570980221205`*^9}, {3.4962578825032187`*^9, 3.4962579112432585`*^9}, 
   3.496960950748027*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["a", "2"], "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["c", "2"], " ", "d"}], " ", "\[And]", " ", 
     SuperscriptBox["b", "2"]}], "=", 
    RowBox[{
     SuperscriptBox["c", "2"], " ", "e"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.496254584788602*^9, 
   3.496254666328716*^9}, 3.4962551196793504`*^9, {3.4962555159499054`*^9, 
   3.4962555362599335`*^9}, 3.4962557234601955`*^9, 3.4962570252820187`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["u", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "m"]}], "+", 
      RowBox[{"c", " ", 
       SqrtBox[
        RowBox[{"d", "+", 
         RowBox[{"e", " ", 
          SuperscriptBox["x", 
           RowBox[{"2", " ", "m"}]]}]}]]}]}]], " ", 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", 
       RowBox[{"2", " ", "a"}]]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{"u", 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", " ", "b"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["u", 
      SuperscriptBox["x", "m"]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "-", 
  RowBox[{
   FractionBox["c", 
    RowBox[{"2", " ", "a", " ", "b"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"u", " ", 
       SqrtBox[
        RowBox[{"d", "+", 
         RowBox[{"e", " ", 
          SuperscriptBox["x", 
           RowBox[{"2", "m"}]]}]}]]}], 
      SuperscriptBox["x", "m"]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4962546968087587`*^9, {3.4962548323089485`*^9, 
   3.4962549058190513`*^9}, 3.4962552252294984`*^9, {3.496255308179614*^9, 
   3.4962553130796213`*^9}, {3.496255354359679*^9, 3.4962553856297226`*^9}, {
   3.4962556577101035`*^9, 3.496255684110141*^9}, 3.496255767150257*^9, 
   3.4962566701015215`*^9, {3.4962567166415863`*^9, 3.496256731391607*^9}, 
   3.4962567837516804`*^9, {3.4962571054521303`*^9, 3.496257113882142*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "m_."}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"d_", "+", 
          RowBox[{"e_.", "*", 
           RowBox[{"x_", "^", "n_"}]}]}], "]"}]}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "a"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{"u", ",", "x"}], "]"}]}], "]"}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "b"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"u", "/", 
         RowBox[{"x", "^", "m"}]}], ",", "x"}], "]"}]}], "]"}], " ", "-", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"c", "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "a", "*", "b"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"u", "*", 
         RowBox[{
          RowBox[{"Sqrt", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "/", 
          RowBox[{"x", "^", "m"}]}]}], ",", "x"}], "]"}]}], "]"}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "m", ",", "n"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"n", "-", 
      RowBox[{"2", "*", "m"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{
       RowBox[{"c", "^", "2"}], "*", "d"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{
       RowBox[{"c", "^", "2"}], "*", "e"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4962544854184628`*^9, 3.4962550675192776`*^9, {
   3.496255180479436*^9, 3.4962551897694483`*^9}, 3.4962553035096083`*^9, {
   3.496255407829754*^9, 3.496255437329795*^9}, 3.496255607880034*^9, {
   3.4962557140201826`*^9, 3.49625574091022*^9}, 3.496256630001465*^9, {
   3.4962568309317465`*^9, 3.4962568551617804`*^9}, {3.4962571234221554`*^9, 
   3.4962571309921665`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{3.49539151296132*^9, 3.496254544498545*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["a", "2"], "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["c", "2"], " ", "d"}], " ", "\[And]", " ", 
     RowBox[{"2", "a", " ", "b"}]}], "=", 
    RowBox[{
     SuperscriptBox["c", "2"], " ", "e"}]}]}]]],
 ",",
 " then",
 " ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "z"}], "+", 
     RowBox[{"c", " ", 
      SqrtBox[
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "z"}]}]]}]}]], "=", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"b", " ", "z"}]], "+", 
    FractionBox["a", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["z", "2"]}]], "-", 
    FractionBox[
     RowBox[{"c", " ", 
      SqrtBox[
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "z"}]}]]}], 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["z", "2"]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, {
   3.496254503088487*^9, 3.4962545521285563`*^9}, {3.4962550867993045`*^9, 
   3.496255099169322*^9}, {3.4962563485310707`*^9, 3.4962563691811*^9}, {
   3.496256966521936*^9, 3.496257009251996*^9}, {3.496257086172104*^9, 
   3.4962570980221205`*^9}, 3.4962575746527877`*^9, {3.4962577106029778`*^9, 
   3.4962577125629807`*^9}, {3.496257920853272*^9, 3.496257943193303*^9}, 
   3.4969609562780347`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["a", "2"], "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["c", "2"], " ", "d"}], " ", "\[And]", " ", 
     RowBox[{"2", "a", " ", "b"}]}], "=", 
    RowBox[{
     SuperscriptBox["c", "2"], " ", "e"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.496254584788602*^9, 
   3.496254666328716*^9}, 3.4962551196793504`*^9, {3.4962555159499054`*^9, 
   3.4962555362599335`*^9}, 3.4962557234601955`*^9, 3.4962570252820187`*^9, {
   3.4962575537627583`*^9, 3.4962575559427614`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["u", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"c", " ", 
       SqrtBox[
        RowBox[{"d", "+", 
         RowBox[{"e", " ", 
          SuperscriptBox["x", "n"]}]}]]}]}]], " ", 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "b"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox["u", 
       SuperscriptBox["x", "n"]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["a", 
    SuperscriptBox["b", "2"]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["u", 
      SuperscriptBox["x", 
       RowBox[{"2", " ", "n"}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "-", 
  RowBox[{
   FractionBox["c", 
    SuperscriptBox["b", "2"]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"u", " ", 
       SqrtBox[
        RowBox[{"d", "+", 
         RowBox[{"e", " ", 
          SuperscriptBox["x", "n"]}]}]]}], 
      SuperscriptBox["x", 
       RowBox[{"2", " ", "n"}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4962546968087587`*^9, {3.4962548323089485`*^9, 
   3.4962549058190513`*^9}, 3.4962552252294984`*^9, {3.496255308179614*^9, 
   3.4962553130796213`*^9}, {3.496255354359679*^9, 3.4962553856297226`*^9}, {
   3.4962556577101035`*^9, 3.496255684110141*^9}, 3.496255767150257*^9, 
   3.4962566701015215`*^9, {3.4962567166415863`*^9, 3.496256731391607*^9}, 
   3.4962567837516804`*^9, {3.4962571054521303`*^9, 3.496257113882142*^9}, {
   3.496257412852561*^9, 3.496257441732601*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_."}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"d_", "+", 
          RowBox[{"e_.", "*", 
           RowBox[{"x_", "^", "n_."}]}]}], "]"}]}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"u", "/", 
         RowBox[{"x", "^", "n"}]}], ",", "x"}], "]"}]}], "]"}], " ", "+", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "/", 
       RowBox[{"b", "^", "2"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"u", "/", 
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"2", "*", "n"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"c", "/", 
       RowBox[{"b", "^", "2"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"u", "*", 
         RowBox[{
          RowBox[{"Sqrt", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "/", 
          RowBox[{"x", "^", 
           RowBox[{"(", 
            RowBox[{"2", "*", "n"}], ")"}]}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{
       RowBox[{"c", "^", "2"}], "*", "d"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"2", "*", "a", "*", "b"}], "-", 
      RowBox[{
       RowBox[{"c", "^", "2"}], "*", "e"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4962544854184628`*^9, 3.4962550675192776`*^9, {
   3.496255180479436*^9, 3.4962551897694483`*^9}, 3.4962553035096083`*^9, {
   3.496255407829754*^9, 3.496255437329795*^9}, 3.496255607880034*^9, {
   3.4962557140201826`*^9, 3.49625574091022*^9}, 3.496256630001465*^9, {
   3.4962568309317465`*^9, 3.4962568551617804`*^9}, {3.4962571234221554`*^9, 
   3.4962571309921665`*^9}, {3.496257191642251*^9, 3.496257214382283*^9}, {
   3.4962572589123454`*^9, 3.4962573175424275`*^9}, 3.4962573561624813`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"u_.", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"e_.", "*", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"a_.", "+", 
           RowBox[{"b_.", "*", "x_"}]}], "]"}]}], "+", 
        RowBox[{"f_.", "*", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", 
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"u", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"e", "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", "x"}]}], "]"}]}], "-", 
          RowBox[{"f", "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "*", 
           RowBox[{"e", "^", "2"}]}], "-", 
          RowBox[{"c", "*", 
           RowBox[{"f", "^", "2"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"b", "*", 
              RowBox[{"e", "^", "2"}]}], "-", 
             RowBox[{"d", "*", 
              RowBox[{"f", "^", "2"}]}]}], ")"}], "*", "x"}]}], ")"}]}]}], 
      ",", "x"}], "]"}], " ", "/;", "\n", 
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}],
       ",", "x"}], "]"}]}]}], " ", "*)"}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4962544854184628`*^9, 3.4962550675192776`*^9, {
   3.496255180479436*^9, 3.4962551897694483`*^9}, 3.4962553035096083`*^9, {
   3.496255407829754*^9, 3.496255437329795*^9}, 3.496255607880034*^9, {
   3.4962557140201826`*^9, 3.49625574091022*^9}, 3.496256630001465*^9, {
   3.4962568309317465`*^9, 3.4962568551617804`*^9}, {3.4962571234221554`*^9, 
   3.4962571309921665`*^9}, {3.496257191642251*^9, 3.496257214382283*^9}, {
   3.4962572589123454`*^9, 3.4962573175424275`*^9}, 3.4962573561624813`*^9, 
   3.4962580884435067`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{3.49539151296132*^9, 3.496254544498545*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"a", " ", "x"}], "+", 
     RowBox[{"b", " ", 
      SqrtBox[
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}]]}]}]], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"a", " ", "x"}], 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["b", "2"]}], " ", "c"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["a", "2"], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", "d"}]}], ")"}], " ", 
       SuperscriptBox["x", "2"]}]}]], "-", 
    FractionBox[
     RowBox[{"b", " ", 
      SqrtBox[
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}]]}], 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["b", "2"]}], " ", "c"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["a", "2"], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", "d"}]}], ")"}], " ", 
       SuperscriptBox["x", "2"]}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, {
   3.496254503088487*^9, 3.4962545521285563`*^9}, {3.4962550867993045`*^9, 
   3.496255099169322*^9}, {3.4962563485310707`*^9, 3.4962563691811*^9}, {
   3.496256966521936*^9, 3.496257009251996*^9}, {3.496257086172104*^9, 
   3.4962570980221205`*^9}, 3.4962575746527877`*^9, {3.4962577106029778`*^9, 
   3.4962577125629807`*^9}, {3.496257920853272*^9, 3.496257943193303*^9}, {
   3.4962582897037888`*^9, 3.4962583025738063`*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.496254584788602*^9, 
   3.496254666328716*^9}, 3.4962551196793504`*^9, {3.4962555159499054`*^9, 
   3.4962555362599335`*^9}, 3.4962557234601955`*^9, 3.4962570252820187`*^9, {
   3.4962575537627583`*^9, 3.4962575559427614`*^9}, 3.4962581854436426`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["u", 
     RowBox[{
      RowBox[{"a", " ", "x"}], "+", 
      RowBox[{"b", " ", 
       SqrtBox[
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}]]}]}]], " ", 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "a"}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{"x", " ", "u"}], 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["b", "2"]}], " ", "c"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "d"}]}], ")"}], " ", 
         SuperscriptBox["x", "2"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{"b", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"u", " ", 
       SqrtBox[
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}]]}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["b", "2"]}], " ", "c"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", "d"}]}], ")"}], " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4962546968087587`*^9, {3.4962548323089485`*^9, 
   3.4962549058190513`*^9}, 3.4962552252294984`*^9, {3.496255308179614*^9, 
   3.4962553130796213`*^9}, {3.496255354359679*^9, 3.4962553856297226`*^9}, {
   3.4962556577101035`*^9, 3.496255684110141*^9}, 3.496255767150257*^9, 
   3.4962566701015215`*^9, {3.4962567166415863`*^9, 3.496256731391607*^9}, 
   3.4962567837516804`*^9, {3.4962571054521303`*^9, 3.496257113882142*^9}, {
   3.496257412852561*^9, 3.496257441732601*^9}, {3.4962581647636137`*^9, 
   3.4962581705436215`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a_.", "*", "x_"}], "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", 
           RowBox[{"x_", "^", "2"}]}]}], "]"}]}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{"a", ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"x", "*", 
         RowBox[{"u", "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              RowBox[{"b", "^", "2"}]}], "*", "c"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a", "^", "2"}], "-", 
               RowBox[{
                RowBox[{"b", "^", "2"}], "*", "d"}]}], ")"}], "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{"b", ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"u", "*", 
         RowBox[{
          RowBox[{"Sqrt", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              RowBox[{"b", "^", "2"}]}], "*", "c"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a", "^", "2"}], "-", 
               RowBox[{
                RowBox[{"b", "^", "2"}], "*", "d"}]}], ")"}], "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], 
    "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4962544854184628`*^9, 3.4962550675192776`*^9, {
   3.496255180479436*^9, 3.4962551897694483`*^9}, 3.4962553035096083`*^9, {
   3.496255407829754*^9, 3.496255437329795*^9}, 3.496255607880034*^9, {
   3.4962557140201826`*^9, 3.49625574091022*^9}, 3.496256630001465*^9, {
   3.4962568309317465`*^9, 3.4962568551617804`*^9}, {3.4962571234221554`*^9, 
   3.4962571309921665`*^9}, {3.496257191642251*^9, 3.496257214382283*^9}, {
   3.4962572589123454`*^9, 3.4962573175424275`*^9}, 3.4962573561624813`*^9, 
   3.496258124953558*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{3.49539151296132*^9, 3.496254544498545*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"z", "+", "w"}]], "=", 
   FractionBox[
    RowBox[{"z", "-", "w"}], 
    RowBox[{
     SuperscriptBox["z", "2"], "-", 
     SuperscriptBox["w", "2"]}]]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, {
   3.496254503088487*^9, 3.4962545521285563`*^9}, {3.4962550867993045`*^9, 
   3.496255099169322*^9}, {3.4962563485310707`*^9, 3.4962563691811*^9}, {
   3.496256966521936*^9, 3.496257009251996*^9}, {3.496257086172104*^9, 
   3.4962570980221205`*^9}, 3.4962575746527877`*^9, {3.4962577106029778`*^9, 
   3.4962577125629807`*^9}, {3.496257920853272*^9, 3.496257943193303*^9}, {
   3.4962582897037888`*^9, 3.4962583025738063`*^9}, {3.49625842685398*^9, 
   3.4962584405339994`*^9}, {3.496258540204139*^9, 3.4962585425341425`*^9}, 
   3.496258587354205*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.496254584788602*^9, 
   3.496254666328716*^9}, 3.4962551196793504`*^9, {3.4962555159499054`*^9, 
   3.4962555362599335`*^9}, 3.4962557234601955`*^9, 3.4962570252820187`*^9, {
   3.4962575537627583`*^9, 3.4962575559427614`*^9}, 3.4962581854436426`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["u", 
    RowBox[{
     RowBox[{"e", " ", 
      SqrtBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", "n"]}]}], ")"}], "p"]]}], "+", 
     RowBox[{"f", " ", 
      SqrtBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", "n"]}]}], ")"}], "q"]]}]}]], " ", 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox[
        RowBox[{"u", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"e", " ", 
            SqrtBox[
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"a", "+", 
                RowBox[{"b", " ", 
                 SuperscriptBox["x", "n"]}]}], ")"}], "p"]]}], "-", 
           RowBox[{"f", " ", 
            SqrtBox[
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"a", "+", 
                RowBox[{"b", " ", 
                 SuperscriptBox["x", "n"]}]}], ")"}], "q"]]}]}], ")"}]}], 
        RowBox[{
         RowBox[{
          SuperscriptBox["e", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", " ", 
              SuperscriptBox["x", "n"]}]}], ")"}], "p"]}], "-", 
         RowBox[{
          SuperscriptBox["f", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", " ", 
              SuperscriptBox["x", "n"]}]}], ")"}], "q"]}]}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4962546968087587`*^9, {3.4962548323089485`*^9, 
   3.4962549058190513`*^9}, 3.4962552252294984`*^9, {3.496255308179614*^9, 
   3.4962553130796213`*^9}, {3.496255354359679*^9, 3.4962553856297226`*^9}, {
   3.4962556577101035`*^9, 3.496255684110141*^9}, 3.496255767150257*^9, 
   3.4962566701015215`*^9, {3.4962567166415863`*^9, 3.496256731391607*^9}, 
   3.4962567837516804`*^9, {3.4962571054521303`*^9, 3.496257113882142*^9}, {
   3.496257412852561*^9, 3.496257441732601*^9}, {3.4962581647636137`*^9, 
   3.4962581705436215`*^9}, {3.496258374363907*^9, 3.4962583941439347`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"e_.", "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a_.", "+", 
            RowBox[{"b_.", "*", 
             RowBox[{"x_", "^", "n_."}]}]}], ")"}], "^", "p_."}], "]"}]}], 
       "+", 
       RowBox[{"f_.", "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a_.", "+", 
            RowBox[{"b_.", "*", 
             RowBox[{"x_", "^", "n_."}]}]}], ")"}], "^", "q_."}], "]"}]}]}], 
      ")"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"u", "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"e", "*", 
          RowBox[{"Sqrt", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", 
               RowBox[{"x", "^", "n"}]}]}], ")"}], "^", "p"}], "]"}]}], "-", 
         RowBox[{"f", "*", 
          RowBox[{"Sqrt", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", 
               RowBox[{"x", "^", "n"}]}]}], ")"}], "^", "q"}], "]"}]}]}], 
        ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"e", "^", "2"}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"x", "^", "n"}]}]}], ")"}], "^", "p"}]}], "-", 
         RowBox[{
          RowBox[{"f", "^", "2"}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"x", "^", "n"}]}]}], ")"}], "^", "q"}]}]}], ")"}]}]}], 
     ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "e", ",", "f"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"n", ",", "p", ",", "q"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4962544854184628`*^9, 3.4962550675192776`*^9, {
   3.496255180479436*^9, 3.4962551897694483`*^9}, 3.4962553035096083`*^9, {
   3.496255407829754*^9, 3.496255437329795*^9}, 3.496255607880034*^9, {
   3.4962557140201826`*^9, 3.49625574091022*^9}, 3.496256630001465*^9, {
   3.4962568309317465`*^9, 3.4962568551617804`*^9}, {3.4962571234221554`*^9, 
   3.4962571309921665`*^9}, {3.496257191642251*^9, 3.496257214382283*^9}, {
   3.4962572589123454`*^9, 3.4962573175424275`*^9}, 3.4962573561624813`*^9, 
   3.496258124953558*^9, 3.4962583269538407`*^9, {3.517189194782467*^9, 
   3.517189197543672*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"u_.", "/", 
      RowBox[{"(", 
       RowBox[{"v_", "+", 
        RowBox[{"a_.", "*", 
         RowBox[{"Sqrt", "[", "w_", "]"}]}]}], ")"}]}], ",", "x_Symbol"}], 
    "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{"v", "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"v", "^", "2"}], "-", 
           RowBox[{
            RowBox[{"a", "^", "2"}], "*", "w"}]}], ")"}]}]}], ",", "x"}], 
      "]"}], " ", "-", "\n", "  ", 
     RowBox[{"Dist", "[", 
      RowBox[{"a", ",", 
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"u", "*", 
          RowBox[{
           RowBox[{"Sqrt", "[", "w", "]"}], "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"v", "^", "2"}], "-", 
             RowBox[{
              RowBox[{"a", "^", "2"}], "*", "w"}]}], ")"}]}]}], ",", "x"}], 
        "]"}]}], "]"}]}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
     RowBox[{"PolynomialQ", "[", 
      RowBox[{"v", ",", "x"}], "]"}]}]}]}], " ", "*)"}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4962544854184628`*^9, 3.4962550675192776`*^9, {
   3.496255180479436*^9, 3.4962551897694483`*^9}, 3.4962553035096083`*^9, {
   3.496255407829754*^9, 3.496255437329795*^9}, 3.496255607880034*^9, {
   3.4962557140201826`*^9, 3.49625574091022*^9}, 3.496256630001465*^9, {
   3.4962568309317465`*^9, 3.4962568551617804`*^9}, {3.4962571234221554`*^9, 
   3.4962571309921665`*^9}, {3.496257191642251*^9, 3.496257214382283*^9}, {
   3.4962572589123454`*^9, 3.4962573175424275`*^9}, 3.4962573561624813`*^9, 
   3.496258124953558*^9, 3.4962583269538407`*^9, 3.49625861919425*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"u_.", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a_.", "*", "x_"}], "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"c_", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", 
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "*", "x", "*", "u"}], "-", 
         RowBox[{"b", "*", "u", "*", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           RowBox[{"b", "^", "2"}]}], "*", "c"}], "-", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "*", "d", "*", "x"}], "+", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "*", 
          RowBox[{"x", "^", "2"}]}]}], ")"}]}], ",", "x"}], "]"}], " ", "/;", 
    "\n", 
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], 
     "]"}]}]}], " ", "*)"}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4962544854184628`*^9, 3.4962550675192776`*^9, {
   3.496255180479436*^9, 3.4962551897694483`*^9}, 3.4962553035096083`*^9, {
   3.496255407829754*^9, 3.496255437329795*^9}, 3.496255607880034*^9, {
   3.4962557140201826`*^9, 3.49625574091022*^9}, 3.496256630001465*^9, {
   3.4962568309317465`*^9, 3.4962568551617804`*^9}, {3.4962571234221554`*^9, 
   3.4962571309921665`*^9}, {3.496257191642251*^9, 3.496257214382283*^9}, {
   3.4962572589123454`*^9, 3.4962573175424275`*^9}, 3.4962573561624813`*^9, 
   3.496258124953558*^9, 3.4962583269538407`*^9, 3.496258625594259*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"u", " ", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", 
        SuperscriptBox["x", "2"]}]}]]}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, 
   3.496258732264408*^9, 3.496258901254645*^9, {3.4962591199649506`*^9, 
   3.4962591310349665`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.4962588288445435`*^9, 3.4962588411445603`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    SqrtBox[
     RowBox[{
      SuperscriptBox["z", "2"], "-", 
      SuperscriptBox["w", "2"]}]], 
    RowBox[{"z", "+", "w"}]], "=", 
   RowBox[{
    FractionBox["z", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["z", "2"], "-", 
       SuperscriptBox["w", "2"]}]]], "-", 
    FractionBox["w", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["z", "2"], "-", 
       SuperscriptBox["w", "2"]}]]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, 
   3.4962592272151012`*^9, {3.4962593411452603`*^9, 3.496259343405264*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"m", " ", "n"}], "+", "1"}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"u", " ", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["x", "2"]}]}]]}], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "a"}]}], " ", 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox["u", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["a", "2"], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["x", "2"]}]}]]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{"b", " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"x", " ", "u"}], 
      SqrtBox[
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["x", "2"]}]}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.4962587561344414`*^9, 3.496258793574494*^9, {
   3.496258872094604*^9, 3.4962588885446267`*^9}, {3.4962589619347296`*^9, 
   3.4962589641347327`*^9}, {3.49625914092498*^9, 3.4962591499749928`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"u", "/", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", 
           RowBox[{"x", "^", "2"}]}]}], "]"}]}], ",", "x"}], "]"}]}], " ", 
    "-", "\n", "  ", 
    RowBox[{"b", "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"x", "*", 
        RowBox[{"u", "/", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", 
            RowBox[{"x", "^", "2"}]}]}], "]"}]}]}], ",", "x"}], "]"}]}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"c", "-", 
      RowBox[{"a", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "+", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, {
   3.496258744204425*^9, 3.4962587646544533`*^9}, {3.496258910164657*^9, 
   3.4962589307946863`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SqrtBox[
     RowBox[{
      RowBox[{"b", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["x", "4"]}]}]]}]], 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["x", "4"]}]}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, 
   3.4962594367353945`*^9, 3.4962601872364454`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"b", ">", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.496259601395625*^9, 3.4962596077156334`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SqrtBox[
     RowBox[{
      RowBox[{"b", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["x", "4"]}]}]]}]], 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["x", "4"]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      SqrtBox[
       RowBox[{"2", " ", "b"}]]]}]}], 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     RowBox[{
      SqrtBox[
       RowBox[{"2", " ", "b"}]], " ", "x"}], 
     SqrtBox[
      RowBox[{
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}], "+", 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["x", "4"]}]}]]}]]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.496259570925582*^9, 3.496259575945589*^9}, {
   3.4962597097657766`*^9, 3.496259711655779*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "2"}]}], "+", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_", "+", 
         RowBox[{"c_.", "*", 
          RowBox[{"x_", "^", "4"}]}]}], "]"}]}], "]"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "4"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcTanh", "[", 
     RowBox[{
      RowBox[{"Rt", "[", 
       RowBox[{
        RowBox[{"2", "*", "b"}], ",", "2"}], "]"}], "*", 
      RowBox[{"x", "/", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "2"}]}], "+", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "4"}]}]}], "]"}]}], "]"}]}]}], "]"}], "/", 
    RowBox[{"Rt", "[", 
     RowBox[{
      RowBox[{"2", "*", "b"}], ",", "2"}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"c", "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"PosQ", "[", "b", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4962594454254065`*^9, {3.496259510795498*^9, 3.496259513725502*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"\[Not]", 
   RowBox[{"(", 
    RowBox[{"b", ">", "0"}], ")"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.4962596278256617`*^9, 
   3.4962596295756645`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SqrtBox[
     RowBox[{
      RowBox[{"b", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["x", "4"]}]}]]}]], 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["x", "4"]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "2"}], " ", "b"}]]]}]}], 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{
      SqrtBox[
       RowBox[{
        RowBox[{"-", "2"}], " ", "b"}]], " ", "x"}], 
     SqrtBox[
      RowBox[{
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}], "+", 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["x", "4"]}]}]]}]]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, {3.4962596776657314`*^9, 3.496259698675761*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "2"}]}], "+", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_", "+", 
         RowBox[{"c_.", "*", 
          RowBox[{"x_", "^", "4"}]}]}], "]"}]}], "]"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "4"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcTan", "[", 
     RowBox[{
      RowBox[{"Rt", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], "*", "b"}], ",", "2"}], "]"}], "*", 
      RowBox[{"x", "/", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "2"}]}], "+", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "4"}]}]}], "]"}]}], "]"}]}]}], "]"}], "/", 
    RowBox[{"Rt", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], "*", "b"}], ",", "2"}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"c", "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NegQ", "[", "b", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4962596367656746`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"u", " ", 
     SqrtBox[
      RowBox[{"v", "+", 
       SqrtBox[
        RowBox[{"a", "+", 
         SuperscriptBox["v", "2"]}]]}]]}], 
    SqrtBox[
     RowBox[{"a", "+", 
      SuperscriptBox["v", "2"]}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, 
   3.4962594367353945`*^9, 3.4962601872364454`*^9, 3.496260236476514*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Author: Martin", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.4962596278256617`*^9, 
   3.4962596295756645`*^9}, {3.4962597487558312`*^9, 3.4962597564658422`*^9}}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.4962596278256617`*^9, 
   3.4962596295756645`*^9}, {3.4962597487558312`*^9, 3.4962597564658422`*^9}, 
   3.4962600546562595`*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{"a", ">", "0"}]]],
 ",",
 " then",
 " ",
 Cell[BoxData[
  RowBox[{
   SqrtBox[
    RowBox[{"a", "+", 
     SuperscriptBox["z", "2"]}]], "=", 
   RowBox[{
    SqrtBox[
     RowBox[{
      SqrtBox["a"], "+", 
      RowBox[{"\[ImaginaryI]", " ", "z"}]}]], " ", 
    SqrtBox[
     RowBox[{
      SqrtBox["a"], "-", 
      RowBox[{"\[ImaginaryI]", " ", "z"}]}]]}]}]]]
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.4962596278256617`*^9, 
   3.4962596295756645`*^9}, {3.4962597487558312`*^9, 
   3.4962597564658422`*^9}, {3.4962600590062656`*^9, 3.496260105566331*^9}, 
   3.4969609627980437`*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{"a", ">", "0"}]]],
 ",",
 " then",
 " ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    SqrtBox[
     RowBox[{"z", "+", 
      SqrtBox[
       RowBox[{"a", "+", 
        SuperscriptBox["z", "2"]}]]}]], 
    SqrtBox[
     RowBox[{"a", "+", 
      SuperscriptBox["z", "2"]}]]], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"1", "-", "\[ImaginaryI]"}], 
     RowBox[{"2", " ", 
      SqrtBox[
       RowBox[{
        SqrtBox["a"], "-", 
        RowBox[{"\[ImaginaryI]", " ", "z"}]}]]}]], "+", 
    FractionBox[
     RowBox[{"1", "+", "\[ImaginaryI]"}], 
     RowBox[{"2", " ", 
      SqrtBox[
       RowBox[{
        SqrtBox["a"], "+", 
        RowBox[{"\[ImaginaryI]", " ", "z"}]}]]}]]}]}]]]
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.4962596278256617`*^9, 
   3.4962596295756645`*^9}, {3.4962597487558312`*^9, 
   3.4962597564658422`*^9}, {3.4962600590062656`*^9, 3.496260105566331*^9}, 
   3.496260148626391*^9, 3.4969609665680494`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"a", ">", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.4962596278256617`*^9, 
   3.4962596295756645`*^9}, {3.4962599760561495`*^9, 3.49625997657615*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"u", " ", 
      SqrtBox[
       RowBox[{"v", "+", 
        SqrtBox[
         RowBox[{"a", "+", 
          SuperscriptBox["v", "2"]}]]}]]}], 
     SqrtBox[
      RowBox[{"a", "+", 
       SuperscriptBox["v", "2"]}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"1", "-", "\[ImaginaryI]"}], "2"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox["u", 
       SqrtBox[
        RowBox[{
         SqrtBox["a"], "-", 
         RowBox[{"\[ImaginaryI]", " ", "v"}]}]]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"1", "+", "\[ImaginaryI]"}], "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["u", 
      SqrtBox[
       RowBox[{
        SqrtBox["a"], "+", 
        RowBox[{"\[ImaginaryI]", " ", "v"}]}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, {3.4962596776657314`*^9, 3.496259698675761*^9}, 
   3.4962597997659025`*^9, 3.4962599161260653`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"v_", "+", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"a_", "+", "w_"}], "]"}]}], "]"}], "/", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"a_", "+", "w_"}], "]"}]}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "I"}], ")"}], "/", "2"}], ",", " ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"u", "/", 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{"Sqrt", "[", "a", "]"}], "-", 
           RowBox[{"I", "*", "v"}]}], "]"}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "I"}], ")"}], "/", "2"}], ",", " ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"u", "/", 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{"Sqrt", "[", "a", "]"}], "+", 
           RowBox[{"I", "*", "v"}]}], "]"}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"w", "-", 
      RowBox[{"v", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", "a", "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"LinearQ", "[", 
      RowBox[{"v", ",", "x"}], "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4962596367656746`*^9, 3.4962597657858553`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"a", " ", "c"}], "+", 
     RowBox[{"b", " ", "c", " ", "u"}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, 
   3.4962594367353945`*^9, 3.4962601872364454`*^9, 3.496260236476514*^9, {
   3.4962602897865887`*^9, 3.4962603116766195`*^9}, {3.4962603909567304`*^9, 
   3.4962603959167376`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["\<\
Note: Constant factors in denominator are aggressively factored out to \
prevent them occurring unnecessarily in logarithm of antiderivative!\
\>", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.4962596278256617`*^9, 
   3.4962596295756645`*^9}, {3.4962597487558312`*^9, 
   3.4962597564658422`*^9}, {3.4962603339166503`*^9, 3.4962603546466794`*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.4962596278256617`*^9, 
   3.4962596295756645`*^9}, {3.4962599760561495`*^9, 3.49625997657615*^9}, 
   3.496260493716874*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"a", " ", "c"}], "+", 
     RowBox[{"b", " ", "c", " ", "u"}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "c"]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "u"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, {3.4962596776657314`*^9, 3.496259698675761*^9}, 
   3.4962597997659025`*^9, 3.4962599161260653`*^9, {3.496260402826747*^9, 
   3.4962604210167723`*^9}, {3.4962604540868187`*^9, 3.4962604596768265`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", "u_"}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ",
     ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"lst", "=", 
         RowBox[{"ConstantFactor", "[", 
          RowBox[{
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "u"}]}], ",", "x"}], "]"}]}], "}"}], ",", "\n", 
       "  ", 
       RowBox[{
        RowBox[{"ShowStep", "[", 
         RowBox[{
         "\"\<\>\"", ",", "\"\<Int[1/(a*c+b*c*u),x]\>\"", ",", 
          "\"\<Int[1/(a+b*u),x]/c\>\"", ",", 
          RowBox[{"Hold", "[", "\n", "  ", 
           RowBox[{"Dist", "[", 
            RowBox[{
             RowBox[{"1", "/", 
              RowBox[{"lst", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], ",", 
             RowBox[{"Int", "[", 
              RowBox[{
               RowBox[{"1", "/", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}], ",", "x"}], "]"}]}], "]"}],
            "]"}]}], "]"}], " ", "/;", "\n", " ", 
        RowBox[{
         RowBox[{"lst", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "=!=", "1"}]}]}], "]"}], " ", "/;", 
     "\n", 
     RowBox[{"SimplifyFlag", " ", "&&", " ", 
      RowBox[{"FreeQ", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
      RowBox[{"(", "\n", "\t", 
       RowBox[{
        RowBox[{"MatchQ", "[", 
         RowBox[{"u", ",", 
          RowBox[{
           RowBox[{"f_", "^", 
            RowBox[{"(", 
             RowBox[{"c_.", "+", 
              RowBox[{"d_.", "*", "x"}]}], ")"}]}], " ", "/;", " ", 
           RowBox[{"FreeQ", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"c", ",", "d", ",", "f"}], "}"}], ",", "x"}], "]"}]}]}],
          "]"}], " ", "||", "\n", "\t", 
        RowBox[{"MatchQ", "[", 
         RowBox[{"u", ",", 
          RowBox[{
           RowBox[{"f_", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x"}]}], "]"}], " ", "/;", " ", 
           RowBox[{
            RowBox[{"FreeQ", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&", 
            " ", 
            RowBox[{"MemberQ", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"Tan", ",", "Cot", ",", "Tanh", ",", "Coth"}], "}"}], 
              ",", "f"}], "]"}]}]}]}], "]"}]}], ")"}]}]}]}], ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", "u_"}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ",
     ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"lst", "=", 
         RowBox[{"ConstantFactor", "[", 
          RowBox[{
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "u"}]}], ",", "x"}], "]"}]}], "}"}], ",", "\n", 
       "  ", 
       RowBox[{
        RowBox[{"Dist", "[", 
         RowBox[{
          RowBox[{"1", "/", 
           RowBox[{"lst", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], ",", 
          RowBox[{"Int", "[", 
           RowBox[{
            RowBox[{"1", "/", 
             RowBox[{"lst", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], ",", "x"}], "]"}]}], "]"}], 
        " ", "/;", "\n", " ", 
        RowBox[{
         RowBox[{"lst", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "=!=", "1"}]}]}], "]"}], " ", "/;", 
     "\n", 
     RowBox[{
      RowBox[{"FreeQ", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
      RowBox[{"(", "\n", "\t", 
       RowBox[{
        RowBox[{"MatchQ", "[", 
         RowBox[{"u", ",", 
          RowBox[{
           RowBox[{"f_", "^", 
            RowBox[{"(", 
             RowBox[{"c_.", "+", 
              RowBox[{"d_.", "*", "x"}]}], ")"}]}], " ", "/;", " ", 
           RowBox[{"FreeQ", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"c", ",", "d", ",", "f"}], "}"}], ",", "x"}], "]"}]}]}],
          "]"}], " ", "||", "\n", "\t", 
        RowBox[{"MatchQ", "[", 
         RowBox[{"u", ",", 
          RowBox[{
           RowBox[{"f_", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x"}]}], "]"}], " ", "/;", " ", 
           RowBox[{
            RowBox[{"FreeQ", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&", 
            " ", 
            RowBox[{"MemberQ", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"Tan", ",", "Cot", ",", "Tanh", ",", "Coth"}], "}"}], 
              ",", "f"}], "]"}]}]}]}], "]"}]}], ")"}]}]}]}]}], "]"}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4962596367656746`*^9, 3.4962597657858553`*^9, 
   3.4962603703567014`*^9, {3.4962604668668365`*^9, 3.496260470016841*^9}},
 Background->GrayLevel[0.85]]
}, Closed]]
},
AutoGeneratedPackage->Automatic,
CellGrouping->Manual,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  "Integration Rules for Algebraic Functions of Binomials", None, None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->28.8},
Magnification->1.399999737739563,
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 966, 21, 123, "Title"],
Cell[1536, 45, 1043, 14, 5200, "Subsubsection"],
Cell[2582, 61, 650, 21, 6348, "Subsubsection"],
Cell[3235, 84, 1112, 20, 3830, "Subsubsection"],
Cell[4350, 106, 1276, 33, 9099, "Subsubtitle"],
Cell[5629, 141, 771, 11, 5200, "Subsubsection"],
Cell[6403, 154, 1397, 39, 15903, "Code"],
Cell[7803, 195, 44, 1, 377, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[7884, 201, 1033, 23, 98, "Title"],
Cell[8920, 226, 1186, 16, 130, "Subsubsection"],
Cell[10109, 244, 1062, 14, 90, "Subsubsection"],
Cell[11174, 260, 522, 15, 181, "Subsubsection"],
Cell[11699, 277, 1131, 21, 96, "Subsubsection"],
Cell[12833, 300, 1233, 29, 316, "Subsubtitle"],
Cell[14069, 331, 771, 11, 130, "Subsubsection"],
Cell[14843, 344, 1269, 33, 394, "Code"],
Cell[16115, 379, 89, 2, 130, "Subsubsection"],
Cell[16207, 383, 1186, 16, 90, "Subsubsection"],
Cell[17396, 401, 1062, 14, 90, "Subsubsection"],
Cell[18461, 417, 549, 16, 181, "Subsubsection"],
Cell[19013, 435, 1232, 23, 96, "Subsubsection"],
Cell[20248, 460, 1317, 33, 316, "Subsubtitle"],
Cell[21568, 495, 771, 11, 130, "Subsubsection"],
Cell[22342, 508, 1336, 35, 394, "Code"],
Cell[23681, 545, 89, 2, 130, "Subsubsection"],
Cell[23773, 549, 1183, 16, 90, "Subsubsection"],
Cell[24959, 567, 1284, 24, 96, "Subsubsection"],
Cell[26246, 593, 1426, 35, 316, "Subsubtitle"],
Cell[27675, 630, 771, 11, 130, "Subsubsection"],
Cell[28449, 643, 1490, 38, 394, "Code"],
Cell[29942, 683, 89, 2, 130, "Subsubsection"],
Cell[30034, 687, 1205, 16, 90, "Subsubsection"],
Cell[31242, 705, 1387, 27, 96, "Subsubsection"],
Cell[32632, 734, 1497, 37, 316, "Subsubtitle"],
Cell[34132, 773, 771, 11, 130, "Subsubsection"],
Cell[34906, 786, 1587, 41, 394, "Code"],
Cell[36496, 829, 89, 2, 130, "Subsubsection"],
Cell[36588, 833, 1244, 21, 96, "Subsubsection"],
Cell[37835, 856, 1806, 44, 316, "Subsubtitle"],
Cell[39644, 902, 771, 11, 130, "Subsubsection"],
Cell[40418, 915, 1663, 45, 394, "Code"],
Cell[42084, 962, 89, 2, 130, "Subsubsection"],
Cell[42176, 966, 1655, 35, 282, "Subsubsection"],
Cell[43834, 1003, 1344, 24, 96, "Subsubsection"],
Cell[45181, 1029, 2048, 53, 453, "Subsubtitle"],
Cell[47232, 1084, 771, 11, 130, "Subsubsection"],
Cell[48006, 1097, 2227, 58, 394, "Code"],
Cell[50236, 1157, 44, 1, 11, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[50317, 1163, 1111, 25, 101, "Title"],
Cell[51431, 1190, 1244, 21, 1955, "Subsubsection"],
Cell[52678, 1213, 2588, 68, 9189, "Subsubtitle"],
Cell[55269, 1283, 771, 11, 1896, "Subsubsection"],
Cell[56043, 1296, 2639, 73, 7225, "Code"],
Cell[58685, 1371, 89, 2, 1896, "Subsubsection"],
Cell[58777, 1375, 1655, 35, 4141, "Subsubsection"],
Cell[60435, 1412, 1344, 24, 1397, "Subsubsection"],
Cell[61782, 1438, 3022, 84, 14050, "Subsubtitle"],
Cell[64807, 1524, 771, 11, 1896, "Subsubsection"],
Cell[65581, 1537, 3354, 93, 7225, "Code"],
Cell[68938, 1632, 44, 1, 138, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[69019, 1638, 953, 22, 80, "Title"],
Cell[69975, 1662, 132, 1, 2147483647, "Subsubsection"],
Cell[70110, 1665, 718, 27, 2147483647, "Subsubsection"],
Cell[70831, 1694, 709, 10, 2147483647, "Subsubsection"],
Cell[71543, 1706, 1107, 30, 2147483647, "Subsubtitle"],
Cell[72653, 1738, 771, 11, 2147483647, "Subsubsection"],
Cell[73427, 1751, 967, 29, 2147483647, "Code"],
Cell[74397, 1782, 89, 2, 2147483647, "Subsubsection"],
Cell[74489, 1786, 121, 1, 2147483647, "Subsubsection"],
Cell[74613, 1789, 961, 20, 2147483647, "Subsubsection"],
Cell[75577, 1811, 1426, 32, 2147483647, "Subsubtitle"],
Cell[77006, 1845, 771, 11, 2147483647, "Subsubsection"],
Cell[77780, 1858, 1014, 33, 2147483647, "Code"],
Cell[78797, 1893, 89, 2, 2147483647, "Subsubsection"],
Cell[78889, 1897, 146, 2, 2147483647, "Subsubsection"],
Cell[79038, 1901, 1165, 22, 2147483647, "Subsubsection"],
Cell[80206, 1925, 1944, 49, 2147483647, "Subsubtitle"],
Cell[82153, 1976, 771, 11, 2147483647, "Subsubsection"],
Cell[82927, 1989, 1699, 53, 2147483647, "Code"],
Cell[84629, 2044, 89, 2, 2147483647, "Subsubsection"],
Cell[84721, 2048, 170, 2, 2147483647, "Subsubsection"],
Cell[84894, 2052, 1121, 21, 2147483647, "Subsubsection"],
Cell[86018, 2075, 2182, 57, 2147483647, "Subsubtitle"],
Cell[88203, 2134, 771, 11, 2147483647, "Subsubsection"],
Cell[88977, 2147, 1909, 61, 2147483647, "Code"],
Cell[90889, 2210, 89, 2, 2147483647, "Subsubsection"],
Cell[90981, 2214, 192, 2, 2147483647, "Subsubsection"],
Cell[91176, 2218, 1043, 18, 2147483647, "Subsubsection"],
Cell[92222, 2238, 1784, 44, 2147483647, "Subsubtitle"],
Cell[94009, 2284, 771, 11, 2147483647, "Subsubsection"],
Cell[94783, 2297, 1333, 42, 2147483647, "Code"],
Cell[96119, 2341, 89, 2, 2147483647, "Subsubsection"],
Cell[96211, 2345, 304, 4, 2147483647, "Subsubsection"],
Cell[96518, 2351, 316, 8, 2147483647, "Subsubsection"],
Cell[96837, 2361, 1373, 28, 2147483647, "Subsubsection"],
Cell[98213, 2391, 2237, 56, 2147483647, "Subsubtitle"],
Cell[100453, 2449, 771, 11, 2147483647, "Subsubsection"],
Cell[101227, 2462, 2374, 70, 2147483647, "Code"],
Cell[103604, 2534, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[103685, 2540, 1168, 26, 80, "Title"],
Cell[104856, 2568, 305, 4, 7279, "Subsubsection"],
Cell[105164, 2574, 1377, 39, 8887, "Subsubsection"],
Cell[106544, 2615, 547, 16, 8308, "Subsubsection"],
Cell[107094, 2633, 971, 18, 5361, "Subsubsection"],
Cell[108068, 2653, 1738, 47, 13687, "Subsubtitle"],
Cell[109809, 2702, 771, 11, 7279, "Subsubsection"],
Cell[110583, 2715, 2026, 56, 22264, "Code"],
Cell[112612, 2773, 89, 2, 7279, "Subsubsection"],
Cell[112704, 2777, 305, 4, 4989, "Subsubsection"],
Cell[113012, 2783, 1377, 39, 8887, "Subsubsection"],
Cell[114392, 2824, 547, 16, 8308, "Subsubsection"],
Cell[114942, 2842, 375, 6, 4989, "Subsubsection"],
Cell[115320, 2850, 865, 12, 4989, "Subsubsection"],
Cell[116188, 2864, 1705, 42, 13687, "Subsubtitle"],
Cell[117896, 2908, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[117977, 2914, 985, 23, 80, "Title"],
Cell[118965, 2939, 130, 1, 35, "Subsubsection"],
Cell[119098, 2942, 1214, 43, 44, "Subsubsection"],
Cell[120315, 2987, 1090, 24, 39, "Subsubsection"],
Cell[121408, 3013, 1260, 35, 60, "Subsubtitle"],
Cell[122671, 3050, 771, 11, 35, "Subsubsection"],
Cell[123445, 3063, 1941, 57, 104, "Code"],
Cell[125389, 3122, 89, 2, 35, "Subsubsection"],
Cell[125481, 3126, 124, 1, 25, "Subsubsection"],
Cell[125608, 3129, 916, 30, 39, "Subsubsection"],
Cell[126527, 3161, 1210, 22, 26, "Subsubsection"],
Cell[127740, 3185, 1572, 36, 56, "Subsubtitle"],
Cell[129315, 3223, 771, 11, 35, "Subsubsection"],
Cell[130089, 3236, 1361, 40, 104, "Code"],
Cell[131453, 3278, 89, 2, 35, "Subsubsection"],
Cell[131545, 3282, 137, 2, 25, "Subsubsection"],
Cell[131685, 3286, 169, 2, 25, "Subsubsection"],
Cell[131857, 3290, 1542, 34, 26, "Subsubsection"],
Cell[133402, 3326, 2009, 52, 66, "Subsubtitle"],
Cell[135414, 3380, 771, 11, 35, "Subsubsection"],
Cell[136188, 3393, 2237, 68, 129, "Code"],
Cell[138428, 3463, 89, 2, 35, "Subsubsection"],
Cell[138520, 3467, 157, 2, 25, "Subsubsection"],
Cell[138680, 3471, 169, 2, 25, "Subsubsection"],
Cell[138852, 3475, 774, 26, 29, "Subsubsection"],
Cell[139629, 3503, 1610, 33, 26, "Subsubsection"],
Cell[141242, 3538, 2205, 57, 69, "Subsubtitle"],
Cell[143450, 3597, 771, 11, 35, "Subsubsection"],
Cell[144224, 3610, 2531, 74, 129, "Code"],
Cell[146758, 3686, 89, 2, 35, "Subsubsection"],
Cell[146850, 3690, 188, 2, 25, "Subsubsection"],
Cell[147041, 3694, 1727, 37, 39, "Subsubsection"],
Cell[148771, 3733, 2103, 53, 68, "Subsubtitle"],
Cell[150877, 3788, 771, 11, 35, "Subsubsection"],
Cell[151651, 3801, 2550, 74, 154, "Code"],
Cell[154204, 3877, 89, 2, 35, "Subsubsection"],
Cell[154296, 3881, 213, 3, 25, "Subsubsection"],
Cell[154512, 3886, 1670, 33, 26, "Subsubsection"],
Cell[156185, 3921, 2332, 61, 69, "Subsubtitle"],
Cell[158520, 3984, 771, 11, 35, "Subsubsection"],
Cell[159294, 3997, 2634, 77, 129, "Code"],
Cell[161931, 4076, 89, 2, 35, "Subsubsection"],
Cell[162023, 4080, 235, 3, 25, "Subsubsection"],
Cell[162261, 4085, 1609, 32, 26, "Subsubsection"],
Cell[163873, 4119, 2360, 61, 69, "Subsubtitle"],
Cell[166236, 4182, 771, 11, 35, "Subsubsection"],
Cell[167010, 4195, 4912, 136, 279, "Code"],
Cell[171925, 4333, 89, 2, 35, "Subsubsection"],
Cell[172017, 4337, 257, 3, 25, "Subsubsection"],
Cell[172277, 4342, 1662, 31, 26, "Subsubsection"],
Cell[173942, 4375, 2379, 62, 69, "Subsubtitle"],
Cell[176324, 4439, 771, 11, 35, "Subsubsection"],
Cell[177098, 4452, 4447, 124, 229, "Code"],
Cell[181548, 4578, 89, 2, 35, "Subsubsection"],
Cell[181640, 4582, 304, 4, 25, "Subsubsection"],
Cell[181947, 4588, 380, 9, 26, "Subsubsection"],
Cell[182330, 4599, 1648, 36, 39, "Subsubsection"],
Cell[183981, 4637, 2468, 63, 89, "Subsubtitle"],
Cell[186452, 4702, 771, 11, 35, "Subsubsection"],
Cell[187226, 4715, 3176, 90, 154, "Code"],
Cell[190405, 4807, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[190486, 4813, 1137, 26, 80, "Title"],
Cell[191626, 4841, 971, 20, 2147483647, "Subsubsection"],
Cell[192600, 4863, 1346, 38, 2147483647, "Subsubtitle"],
Cell[193949, 4903, 771, 11, 2147483647, "Subsubsection"],
Cell[194723, 4916, 1543, 49, 2147483647, "Code"],
Cell[196269, 4967, 89, 2, 2147483647, "Subsubsection"],
Cell[196361, 4971, 1122, 24, 2147483647, "Subsubsection"],
Cell[197486, 4997, 1828, 44, 2147483647, "Subsubtitle"],
Cell[199317, 5043, 771, 11, 2147483647, "Subsubsection"],
Cell[200091, 5056, 1616, 50, 2147483647, "Code"],
Cell[201710, 5108, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[201791, 5114, 1123, 26, 80, "Title"],
Cell[202917, 5142, 1004, 21, 2147483647, "Subsubsection"],
Cell[203924, 5165, 1836, 45, 2147483647, "Subsubtitle"],
Cell[205763, 5212, 771, 11, 2147483647, "Subsubsection"],
Cell[206537, 5225, 1614, 51, 2147483647, "Code"],
Cell[208154, 5278, 89, 2, 2147483647, "Subsubsection"],
Cell[208246, 5282, 1128, 24, 2147483647, "Subsubsection"],
Cell[209377, 5308, 1847, 45, 2147483647, "Subsubtitle"],
Cell[211227, 5355, 771, 11, 2147483647, "Subsubsection"],
Cell[212001, 5368, 1734, 53, 2147483647, "Code"],
Cell[213738, 5423, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[213819, 5429, 1282, 29, 80, "Title"],
Cell[215104, 5460, 204, 3, 130, "Subsubsection"],
Cell[215311, 5465, 1099, 34, 145, "Subsubsection"],
Cell[216413, 5501, 1202, 23, 96, "Subsubsection"],
Cell[217618, 5526, 1933, 45, 222, "Subsubtitle"],
Cell[219554, 5573, 771, 11, 130, "Subsubsection"],
Cell[220328, 5586, 1724, 49, 394, "Code"],
Cell[222055, 5637, 89, 2, 130, "Subsubsection"],
Cell[222147, 5641, 149, 2, 90, "Subsubsection"],
Cell[222299, 5645, 1032, 21, 138, "Subsubsection"],
Cell[223334, 5668, 1955, 50, 501, "Subsubtitle"],
Cell[225292, 5720, 771, 11, 130, "Subsubsection"],
Cell[226066, 5733, 1855, 59, 394, "Code"],
Cell[227924, 5794, 89, 2, 130, "Subsubsection"],
Cell[228016, 5798, 172, 2, 90, "Subsubsection"],
Cell[228191, 5802, 1143, 24, 145, "Subsubsection"],
Cell[229337, 5828, 1978, 50, 501, "Subsubtitle"],
Cell[231318, 5880, 771, 11, 130, "Subsubsection"],
Cell[232092, 5893, 1876, 59, 394, "Code"],
Cell[233971, 5954, 89, 2, 130, "Subsubsection"],
Cell[234063, 5958, 1146, 21, 96, "Subsubsection"],
Cell[235212, 5981, 1972, 49, 394, "Subsubtitle"],
Cell[237187, 6032, 771, 11, 130, "Subsubsection"],
Cell[237961, 6045, 3518, 93, 586, "Code"],
Cell[241482, 6140, 89, 2, 130, "Subsubsection"],
Cell[241574, 6144, 237, 3, 90, "Subsubsection"],
Cell[241814, 6149, 688, 21, 282, "Subsubsection"],
Cell[242505, 6172, 1305, 24, 96, "Subsubsection"],
Cell[243813, 6198, 2766, 72, 501, "Subsubtitle"],
Cell[246582, 6272, 771, 11, 130, "Subsubsection"],
Cell[247356, 6285, 4030, 111, 586, "Code"],
Cell[251389, 6398, 89, 2, 130, "Subsubsection"],
Cell[251481, 6402, 1146, 21, 96, "Subsubsection"],
Cell[252630, 6425, 2030, 50, 418, "Subsubtitle"],
Cell[254663, 6477, 771, 11, 130, "Subsubsection"],
Cell[255437, 6490, 1973, 54, 394, "Code"],
Cell[257413, 6546, 89, 2, 130, "Subsubsection"],
Cell[257505, 6550, 237, 3, 90, "Subsubsection"],
Cell[257745, 6555, 763, 22, 282, "Subsubsection"],
Cell[258511, 6579, 1303, 24, 96, "Subsubsection"],
Cell[259817, 6605, 2810, 71, 501, "Subsubtitle"],
Cell[262630, 6678, 771, 11, 130, "Subsubsection"],
Cell[263404, 6691, 2771, 76, 394, "Code"],
Cell[266178, 6769, 89, 2, 130, "Subsubsection"],
Cell[266270, 6773, 1032, 14, 90, "Subsubsection"],
Cell[267305, 6789, 3137, 86, 559, "Subsubtitle"],
Cell[270445, 6877, 771, 11, 130, "Subsubsection"],
Cell[271219, 6890, 3851, 102, 586, "Code"],
Cell[275073, 6994, 44, 1, 11, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[275154, 7000, 1499, 35, 80, "Title"],
Cell[276656, 7037, 204, 3, 181, "Subsubsection"],
Cell[276863, 7042, 1095, 34, 202, "Subsubsection"],
Cell[277961, 7078, 1173, 23, 134, "Subsubsection"],
Cell[279137, 7103, 2239, 55, 310, "Subsubtitle"],
Cell[281379, 7160, 771, 11, 181, "Subsubsection"],
Cell[282153, 7173, 2170, 62, 551, "Code"],
Cell[284326, 7237, 89, 2, 181, "Subsubsection"],
Cell[284418, 7241, 1200, 22, 134, "Subsubsection"],
Cell[285621, 7265, 2246, 57, 551, "Subsubtitle"],
Cell[287870, 7324, 771, 11, 181, "Subsubsection"],
Cell[288644, 7337, 4018, 104, 820, "Code"],
Cell[292665, 7443, 89, 2, 181, "Subsubsection"],
Cell[292757, 7447, 237, 3, 125, "Subsubsection"],
Cell[292997, 7452, 740, 22, 394, "Subsubsection"],
Cell[293740, 7476, 1359, 25, 134, "Subsubsection"],
Cell[295102, 7503, 3050, 80, 701, "Subsubtitle"],
Cell[298155, 7585, 771, 11, 181, "Subsubsection"],
Cell[298929, 7598, 4413, 121, 956, "Code"],
Cell[303345, 7721, 89, 2, 181, "Subsubsection"],
Cell[303437, 7725, 1246, 17, 125, "Subsubsection"],
Cell[304686, 7744, 2074, 48, 242, "Subsubsection"],
Cell[306763, 7794, 1161, 22, 134, "Subsubsection"],
Cell[307927, 7818, 2921, 77, 488, "Subsubtitle"],
Cell[310851, 7897, 771, 11, 181, "Subsubsection"],
Cell[311625, 7910, 3401, 89, 687, "Code"],
Cell[315029, 8001, 89, 2, 181, "Subsubsection"],
Cell[315121, 8005, 1246, 17, 125, "Subsubsection"],
Cell[316370, 8024, 2612, 68, 326, "Subsubsection"],
Cell[318985, 8094, 1140, 22, 134, "Subsubsection"],
Cell[320128, 8118, 3006, 77, 488, "Subsubtitle"],
Cell[323137, 8197, 771, 11, 181, "Subsubsection"],
Cell[323911, 8210, 3375, 88, 687, "Code"],
Cell[327289, 8300, 89, 2, 181, "Subsubsection"],
Cell[327381, 8304, 118, 1, 125, "Subsubsection"],
Cell[327502, 8307, 873, 29, 242, "Subsubsection"],
Cell[328378, 8338, 1161, 22, 134, "Subsubsection"],
Cell[329542, 8362, 2356, 66, 473, "Subsubtitle"],
Cell[331901, 8430, 771, 11, 181, "Subsubsection"],
Cell[332675, 8443, 3552, 105, 956, "Code"],
Cell[336230, 8550, 89, 2, 181, "Subsubsection"],
Cell[336322, 8554, 863, 12, 125, "Subsubsection"],
Cell[337188, 8568, 2421, 67, 473, "Subsubtitle"],
Cell[339612, 8637, 771, 11, 181, "Subsubsection"],
Cell[340386, 8650, 2218, 67, 687, "Code"],
Cell[342607, 8719, 44, 1, 15, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[342688, 8725, 1095, 27, 80, "Title"],
Cell[343786, 8754, 186, 3, 1355, "Subsubsection"],
Cell[343975, 8759, 628, 22, 1506, "Subsubsection"],
Cell[344606, 8783, 1026, 22, 998, "Subsubsection"],
Cell[345635, 8807, 1343, 39, 2325, "Subsubtitle"],
Cell[346981, 8848, 771, 11, 1355, "Subsubsection"],
Cell[347755, 8861, 1870, 57, 4141, "Code"],
Cell[349628, 8920, 89, 2, 1355, "Subsubsection"],
Cell[349720, 8924, 118, 1, 929, "Subsubsection"],
Cell[349841, 8927, 646, 22, 1510, "Subsubsection"],
Cell[350490, 8951, 1216, 25, 998, "Subsubsection"],
Cell[351709, 8978, 2383, 65, 2325, "Subsubtitle"],
Cell[354095, 9045, 771, 11, 1355, "Subsubsection"],
Cell[354869, 9058, 2680, 83, 6161, "Code"],
Cell[357552, 9143, 89, 2, 1355, "Subsubsection"],
Cell[357644, 9147, 118, 1, 929, "Subsubsection"],
Cell[357765, 9150, 1062, 35, 1510, "Subsubsection"],
Cell[358830, 9187, 1287, 27, 998, "Subsubsection"],
Cell[360120, 9216, 2767, 73, 4330, "Subsubtitle"],
Cell[362890, 9291, 771, 11, 1355, "Subsubsection"],
Cell[363664, 9304, 2833, 87, 6161, "Code"],
Cell[366500, 9393, 44, 1, 99, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[366581, 9399, 1109, 27, 88, "Title"],
Cell[367693, 9428, 121, 1, 2147483647, "Subsubsection"],
Cell[367817, 9431, 1063, 35, 2147483647, "Subsubsection"],
Cell[368883, 9468, 1012, 20, 2147483647, "Subsubsection"],
Cell[369898, 9490, 1574, 46, 2147483647, "Subsubtitle"],
Cell[371475, 9538, 771, 11, 2147483647, "Subsubsection"],
Cell[372249, 9551, 1912, 57, 2147483647, "Code"],
Cell[374164, 9610, 89, 2, 2147483647, "Subsubsection"],
Cell[374256, 9614, 121, 1, 2147483647, "Subsubsection"],
Cell[374380, 9617, 1140, 37, 2147483647, "Subsubsection"],
Cell[375523, 9656, 1051, 21, 2147483647, "Subsubsection"],
Cell[376577, 9679, 1600, 47, 2147483647, "Subsubtitle"],
Cell[378180, 9728, 771, 11, 2147483647, "Subsubsection"],
Cell[378954, 9741, 1889, 57, 2147483647, "Code"],
Cell[380846, 9800, 89, 2, 2147483647, "Subsubsection"],
Cell[380938, 9804, 121, 1, 2147483647, "Subsubsection"],
Cell[381062, 9807, 1080, 37, 2147483647, "Subsubsection"],
Cell[382145, 9846, 1191, 23, 2147483647, "Subsubsection"],
Cell[383339, 9871, 1766, 51, 2147483647, "Subsubtitle"],
Cell[385108, 9924, 771, 11, 2147483647, "Subsubsection"],
Cell[385882, 9937, 2151, 65, 2147483647, "Code"],
Cell[388036, 10004, 89, 2, 2147483647, "Subsubsection"],
Cell[388128, 10008, 121, 1, 2147483647, "Subsubsection"],
Cell[388252, 10011, 1079, 37, 2147483647, "Subsubsection"],
Cell[389334, 10050, 1208, 24, 2147483647, "Subsubsection"],
Cell[390545, 10076, 1818, 53, 2147483647, "Subsubtitle"],
Cell[392366, 10131, 771, 11, 2147483647, "Subsubsection"],
Cell[393140, 10144, 2226, 67, 2147483647, "Code"],
Cell[395369, 10213, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[395450, 10219, 1106, 26, 126, "Title"],
Cell[396559, 10247, 232, 3, 130, "Subsubsection"],
Cell[396794, 10252, 1331, 24, 158, "Subsubsection"],
Cell[398128, 10278, 1111, 22, 158, "Subsubsection"],
Cell[399242, 10302, 1219, 31, 384, "Subsubtitle"],
Cell[400464, 10335, 771, 11, 130, "Subsubsection"],
Cell[401238, 10348, 1583, 41, 394, "Code"],
Cell[402824, 10391, 89, 2, 130, "Subsubsection"],
Cell[402916, 10395, 884, 17, 96, "Subsubsection"],
Cell[403803, 10414, 1333, 39, 316, "Subsubtitle"],
Cell[405139, 10455, 771, 11, 130, "Subsubsection"],
Cell[405913, 10468, 1830, 51, 394, "Code"],
Cell[407746, 10521, 89, 2, 130, "Subsubsection"],
Cell[407838, 10525, 937, 19, 96, "Subsubsection"],
Cell[408778, 10546, 1402, 41, 316, "Subsubtitle"],
Cell[CellGroupData[{
Cell[410205, 10591, 771, 11, 130, "Subsubsection"],
Cell[410979, 10604, 1731, 51, 433, "Code"]
}, Open  ]],
Cell[412725, 10658, 111, 2, 130, "Subsubsection"],
Cell[412839, 10662, 254, 4, 90, "Subsubsection"],
Cell[413096, 10668, 1008, 19, 96, "Subsubsection"],
Cell[414107, 10689, 1464, 37, 302, "Subsubtitle"],
Cell[415574, 10728, 793, 11, 130, "Subsubsection"],
Cell[416370, 10741, 1683, 43, 394, "Code"],
Cell[418056, 10786, 89, 2, 130, "Subsubsection"],
Cell[418148, 10790, 225, 3, 90, "Subsubsection"],
Cell[418376, 10795, 965, 14, 90, "Subsubsection"],
Cell[419344, 10811, 2076, 46, 302, "Subsubtitle"],
Cell[421423, 10859, 771, 11, 130, "Subsubsection"],
Cell[422197, 10872, 1562, 41, 394, "Code"],
Cell[423762, 10915, 89, 2, 130, "Subsubsection"],
Cell[423854, 10919, 225, 3, 90, "Subsubsection"],
Cell[424082, 10924, 946, 27, 106, "Subsubsection"],
Cell[425031, 10953, 1036, 19, 96, "Subsubsection"],
Cell[426070, 10974, 2074, 46, 302, "Subsubtitle"],
Cell[428147, 11022, 771, 11, 130, "Subsubsection"],
Cell[428921, 11035, 1669, 44, 394, "Code"],
Cell[430593, 11081, 44, 1, 11, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[430674, 11087, 1038, 25, 87, "Title"],
Cell[431715, 11114, 771, 11, 1132071, "Subsubsection"],
Cell[432489, 11127, 1931, 59, 3463308, "Code"],
Cell[434423, 11188, 89, 2, 1132071, "Subsubsection"],
Cell[434515, 11192, 771, 11, 775868, "Subsubsection"],
Cell[435289, 11205, 2312, 70, 3463308, "Code"],
Cell[437604, 11277, 89, 2, 1132071, "Subsubsection"],
Cell[437696, 11281, 771, 11, 775868, "Subsubsection"],
Cell[438470, 11294, 2319, 66, 3463308, "Code"],
Cell[440792, 11362, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[440873, 11368, 1015, 25, 125, "Title"],
Cell[441891, 11395, 711, 10, 1132071, "Subsubsection"],
Cell[442605, 11407, 1216, 37, 2721306, "Subsubtitle"],
Cell[443824, 11446, 771, 11, 1132071, "Subsubsection"],
Cell[444598, 11459, 1422, 43, 3463308, "Code"],
Cell[446023, 11504, 89, 2, 1132071, "Subsubsection"],
Cell[446115, 11508, 732, 10, 775868, "Subsubsection"],
Cell[446850, 11520, 1701, 44, 2721306, "Subsubtitle"],
Cell[448554, 11566, 771, 11, 1132071, "Subsubsection"],
Cell[449328, 11579, 1343, 42, 3463308, "Code"],
Cell[450674, 11623, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[450755, 11629, 1012, 24, 125, "Title"],
Cell[451770, 11655, 711, 10, 1132071, "Subsubsection"],
Cell[452484, 11667, 1386, 42, 2721306, "Subsubtitle"],
Cell[453873, 11711, 771, 11, 1132071, "Subsubsection"],
Cell[454647, 11724, 1652, 49, 3463308, "Code"],
Cell[456302, 11775, 89, 2, 1132071, "Subsubsection"],
Cell[456394, 11779, 732, 10, 775868, "Subsubsection"],
Cell[457129, 11791, 1898, 49, 2721306, "Subsubtitle"],
Cell[459030, 11842, 771, 11, 1132071, "Subsubsection"],
Cell[459804, 11855, 1566, 48, 3463308, "Code"],
Cell[461373, 11905, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[461454, 11911, 881, 20, 95, "Title"],
Cell[462338, 11933, 153, 2, 35, "Subsubsection"],
Cell[462494, 11937, 409, 14, 38, "Subsubsection"],
Cell[462906, 11953, 709, 10, 25, "Subsubsection"],
Cell[463618, 11965, 1494, 43, 81, "Subsubtitle"],
Cell[465115, 12010, 771, 11, 35, "Subsubsection"],
Cell[465889, 12023, 1467, 46, 104, "Code"],
Cell[467359, 12071, 89, 2, 35, "Subsubsection"],
Cell[467451, 12075, 124, 1, 25, "Subsubsection"],
Cell[467578, 12078, 1103, 42, 46, "Subsubsection"],
Cell[468684, 12122, 1085, 24, 35, "Subsubsection"],
Cell[469772, 12148, 2158, 57, 81, "Subsubtitle"],
Cell[471933, 12207, 771, 11, 35, "Subsubsection"],
Cell[472707, 12220, 2106, 65, 104, "Code"],
Cell[474816, 12287, 89, 2, 35, "Subsubsection"],
Cell[474908, 12291, 124, 1, 25, "Subsubsection"],
Cell[475035, 12294, 1216, 45, 48, "Subsubsection"],
Cell[476254, 12341, 1109, 24, 35, "Subsubsection"],
Cell[477366, 12367, 2267, 60, 81, "Subsubtitle"],
Cell[479636, 12429, 771, 11, 35, "Subsubsection"],
Cell[480410, 12442, 2282, 69, 104, "Code"],
Cell[482695, 12513, 89, 2, 35, "Subsubsection"],
Cell[482787, 12517, 124, 1, 25, "Subsubsection"],
Cell[482914, 12520, 990, 34, 46, "Subsubsection"],
Cell[483907, 12556, 986, 20, 26, "Subsubsection"],
Cell[484896, 12578, 2027, 51, 75, "Subsubtitle"],
Cell[486926, 12631, 771, 11, 35, "Subsubsection"],
Cell[487700, 12644, 1838, 57, 129, "Code"],
Cell[489541, 12703, 89, 2, 5200, "Subsubsection"],
Cell[489633, 12707, 124, 1, 3564, "Subsubsection"],
Cell[489760, 12710, 987, 36, 9099, "Subsubsection"],
Cell[490750, 12748, 1010, 20, 3830, "Subsubsection"],
Cell[491763, 12770, 2126, 52, 12149, "Subsubtitle"],
Cell[493892, 12824, 771, 11, 5200, "Subsubsection"],
Cell[494666, 12837, 2027, 61, 19822, "Code"],
Cell[496696, 12900, 89, 2, 5200, "Subsubsection"],
Cell[496788, 12904, 124, 1, 3564, "Subsubsection"],
Cell[496915, 12907, 1358, 44, 9099, "Subsubsection"],
Cell[498276, 12953, 1181, 25, 5200, "Subsubsection"],
Cell[499460, 12980, 2491, 62, 13648, "Subsubtitle"],
Cell[501954, 13044, 771, 11, 5200, "Subsubsection"],
Cell[502728, 13057, 2583, 75, 23664, "Code"],
Cell[505314, 13134, 89, 2, 5200, "Subsubsection"],
Cell[505406, 13138, 124, 1, 3564, "Subsubsection"],
Cell[505533, 13141, 1458, 47, 6964, "Subsubsection"],
Cell[506994, 13190, 1239, 26, 5200, "Subsubsection"],
Cell[508236, 13218, 2556, 64, 75, "Subsubtitle"],
Cell[510795, 13284, 771, 11, 35, "Subsubsection"],
Cell[511569, 13297, 2669, 76, 154, "Code"],
Cell[514241, 13375, 2260, 60, 114, "Code"],
Cell[516504, 13437, 89, 2, 35, "Subsubsection"],
Cell[516596, 13441, 124, 1, 25, "Subsubsection"],
Cell[516723, 13444, 1667, 51, 60, "Subsubsection"],
Cell[518393, 13497, 962, 13, 25, "Subsubsection"],
Cell[519358, 13512, 2857, 72, 89, "Subsubtitle"],
Cell[522218, 13586, 771, 11, 35, "Subsubsection"],
Cell[522992, 13599, 2589, 72, 129, "Code"],
Cell[525584, 13673, 89, 2, 35, "Subsubsection"],
Cell[525676, 13677, 124, 1, 25, "Subsubsection"],
Cell[525803, 13680, 912, 21, 38, "Subsubsection"],
Cell[526718, 13703, 962, 13, 25, "Subsubsection"],
Cell[527683, 13718, 3204, 78, 96, "Subsubtitle"],
Cell[530890, 13798, 771, 11, 35, "Subsubsection"],
Cell[531664, 13811, 2869, 80, 104, "Code"],
Cell[534536, 13893, 1946, 50, 139, "Code"],
Cell[536485, 13945, 1942, 50, 114, "Code"],
Cell[538430, 13997, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[538511, 14003, 1152, 28, 126, "Title"],
Cell[539666, 14033, 158, 2, 5200, "Subsubsection"],
Cell[539827, 14037, 673, 24, 9099, "Subsubsection"],
Cell[540503, 14063, 811, 17, 3830, "Subsubsection"],
Cell[541317, 14082, 1671, 48, 13648, "Subsubtitle"],
Cell[542991, 14132, 771, 11, 5200, "Subsubsection"],
Cell[543765, 14145, 1648, 51, 19822, "Code"],
Cell[545416, 14198, 44, 1, 377, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[545497, 14204, 1223, 32, 173, "Title"],
Cell[546723, 14238, 810, 15, 134, "Subsubsection"],
Cell[547536, 14255, 1478, 46, 501, "Subsubtitle"],
Cell[549017, 14303, 771, 11, 130, "Subsubsection"],
Cell[549791, 14316, 1663, 50, 394, "Code"],
Cell[551457, 14368, 89, 2, 130, "Subsubsection"],
Cell[551549, 14372, 886, 18, 96, "Subsubsection"],
Cell[552438, 14392, 1932, 53, 501, "Subsubtitle"],
Cell[554373, 14447, 771, 11, 130, "Subsubsection"],
Cell[555147, 14460, 1609, 51, 394, "Code"],
Cell[556759, 14513, 44, 1, 11, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[556840, 14519, 1101, 27, 173, "Title"],
Cell[557944, 14548, 821, 11, 5200, "Subsubsection"],
Cell[558768, 14561, 866, 12, 3564, "Subsubsection"],
Cell[559637, 14575, 1302, 34, 6150, "Subsubsection"],
Cell[560942, 14611, 1653, 46, 11360, "Subsubsection"],
Cell[562598, 14659, 884, 16, 3830, "Subsubsection"],
Cell[563485, 14677, 1967, 52, 16872, "Subsubtitle"],
Cell[565455, 14731, 771, 11, 5200, "Subsubsection"],
Cell[566229, 14744, 1754, 53, 19822, "Code"],
Cell[567986, 14799, 44, 1, 377, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[568067, 14805, 1084, 23, 85, "Title"],
Cell[569154, 14830, 1010, 15, 5200, "Subsubsection"],
Cell[570167, 14847, 835, 12, 3564, "Subsubsection"],
Cell[571005, 14861, 1522, 32, 9099, "Subsubtitle"],
Cell[572530, 14895, 771, 11, 5200, "Subsubsection"],
Cell[573304, 14908, 5324, 151, 74240, "Code"]
}, Closed]]
}
]
*)

(* End of internal cache information *)
