// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAddTags = "AddTags"

// AddTagsRequest generates a "aws/request.Request" representing the
// client's request for the AddTags operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddTags for more information on using the AddTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddTagsRequest method.
//    req, resp := client.AddTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AddTags
func (c *SageMaker) AddTagsRequest(input *AddTagsInput) (req *request.Request, output *AddTagsOutput) {
	op := &request.Operation{
		Name:       opAddTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddTagsInput{}
	}

	output = &AddTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddTags API operation for Amazon SageMaker Service.
//
// Adds or overwrites one or more tags for the specified Amazon SageMaker resource.
// You can add tags to notebook instances, training jobs, models, endpoint configurations,
// and endpoints.
//
// Each tag consists of a key and an optional value. Tag keys must be unique
// per resource. For more information about tags, see Using Cost Allocation
// Tags (http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what)
// in the AWS Billing and Cost Management User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation AddTags for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AddTags
func (c *SageMaker) AddTags(input *AddTagsInput) (*AddTagsOutput, error) {
	req, out := c.AddTagsRequest(input)
	return out, req.Send()
}

// AddTagsWithContext is the same as AddTags with the addition of
// the ability to pass a context and additional request options.
//
// See AddTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) AddTagsWithContext(ctx aws.Context, input *AddTagsInput, opts ...request.Option) (*AddTagsOutput, error) {
	req, out := c.AddTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEndpoint = "CreateEndpoint"

// CreateEndpointRequest generates a "aws/request.Request" representing the
// client's request for the CreateEndpoint operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEndpoint for more information on using the CreateEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateEndpointRequest method.
//    req, resp := client.CreateEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEndpoint
func (c *SageMaker) CreateEndpointRequest(input *CreateEndpointInput) (req *request.Request, output *CreateEndpointOutput) {
	op := &request.Operation{
		Name:       opCreateEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEndpointInput{}
	}

	output = &CreateEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEndpoint API operation for Amazon SageMaker Service.
//
// Creates an endpoint using the endpoint configuration specified in the request.
// Amazon SageMaker uses the endpoint to provision resources and deploy models.
// You create the endpoint configuration with the CreateEndpointConfig (http://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html)
// API.
//
// Use this API only for hosting models using Amazon SageMaker hosting services.
//
// The endpoint name must be unique within an AWS Region in your AWS account.
//
// When it receives the request, Amazon SageMaker creates the endpoint, launches
// the resources (ML compute instances), and deploys the model(s) on them.
//
// When Amazon SageMaker receives the request, it sets the endpoint status to
// Creating. After it creates the endpoint, it sets the status to InService.
// Amazon SageMaker can then process incoming requests for inferences. To check
// the status of an endpoint, use the DescribeEndpoint (http://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeEndpoint.html)
// API.
//
// For an example, see Exercise 1: Using the K-Means Algorithm Provided by Amazon
// SageMaker (http://docs.aws.amazon.com/sagemaker/latest/dg/ex1.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateEndpoint for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceLimitExceeded "ResourceLimitExceeded"
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEndpoint
func (c *SageMaker) CreateEndpoint(input *CreateEndpointInput) (*CreateEndpointOutput, error) {
	req, out := c.CreateEndpointRequest(input)
	return out, req.Send()
}

// CreateEndpointWithContext is the same as CreateEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateEndpointWithContext(ctx aws.Context, input *CreateEndpointInput, opts ...request.Option) (*CreateEndpointOutput, error) {
	req, out := c.CreateEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEndpointConfig = "CreateEndpointConfig"

// CreateEndpointConfigRequest generates a "aws/request.Request" representing the
// client's request for the CreateEndpointConfig operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEndpointConfig for more information on using the CreateEndpointConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateEndpointConfigRequest method.
//    req, resp := client.CreateEndpointConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEndpointConfig
func (c *SageMaker) CreateEndpointConfigRequest(input *CreateEndpointConfigInput) (req *request.Request, output *CreateEndpointConfigOutput) {
	op := &request.Operation{
		Name:       opCreateEndpointConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEndpointConfigInput{}
	}

	output = &CreateEndpointConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEndpointConfig API operation for Amazon SageMaker Service.
//
// Creates an endpoint configuration that Amazon SageMaker hosting services
// uses to deploy models. In the configuration, you identify one or more models,
// created using the CreateModel API, to deploy and the resources that you want
// Amazon SageMaker to provision. Then you call the CreateEndpoint (http://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpoint.html)
// API.
//
// Use this API only if you want to use Amazon SageMaker hosting services to
// deploy models into production.
//
// In the request, you define one or more ProductionVariants, each of which
// identifies a model. Each ProductionVariant parameter also describes the resources
// that you want Amazon SageMaker to provision. This includes the number and
// type of ML compute instances to deploy.
//
// If you are hosting multiple models, you also assign a VariantWeight to specify
// how much traffic you want to allocate to each model. For example, suppose
// that you want to host two models, A and B, and you assign traffic weight
// 2 for model A and 1 for model B. Amazon SageMaker distributes two-thirds
// of the traffic to Model A, and one-third to model B.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateEndpointConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceLimitExceeded "ResourceLimitExceeded"
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEndpointConfig
func (c *SageMaker) CreateEndpointConfig(input *CreateEndpointConfigInput) (*CreateEndpointConfigOutput, error) {
	req, out := c.CreateEndpointConfigRequest(input)
	return out, req.Send()
}

// CreateEndpointConfigWithContext is the same as CreateEndpointConfig with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEndpointConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateEndpointConfigWithContext(ctx aws.Context, input *CreateEndpointConfigInput, opts ...request.Option) (*CreateEndpointConfigOutput, error) {
	req, out := c.CreateEndpointConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateModel = "CreateModel"

// CreateModelRequest generates a "aws/request.Request" representing the
// client's request for the CreateModel operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateModel for more information on using the CreateModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateModelRequest method.
//    req, resp := client.CreateModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModel
func (c *SageMaker) CreateModelRequest(input *CreateModelInput) (req *request.Request, output *CreateModelOutput) {
	op := &request.Operation{
		Name:       opCreateModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateModelInput{}
	}

	output = &CreateModelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateModel API operation for Amazon SageMaker Service.
//
// Creates a model in Amazon SageMaker. In the request, you name the model and
// describe one or more containers. For each container, you specify the docker
// image containing inference code, artifacts (from prior training), and custom
// environment map that the inference code uses when you deploy the model into
// production.
//
// Use this API to create a model only if you want to use Amazon SageMaker hosting
// services. To host your model, you create an endpoint configuration with the
// CreateEndpointConfig API, and then create an endpoint with the CreateEndpoint
// API.
//
// Amazon SageMaker then deploys all of the containers that you defined for
// the model in the hosting environment.
//
// In the CreateModel request, you must define a container with the PrimaryContainer
// parameter.
//
// In the request, you also provide an IAM role that Amazon SageMaker can assume
// to access model artifacts and docker image for deployment on ML compute hosting
// instances. In addition, you also use the IAM role to manage permissions the
// inference code needs. For example, if the inference code access any other
// AWS resources, you grant necessary permissions via this role.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateModel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceLimitExceeded "ResourceLimitExceeded"
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModel
func (c *SageMaker) CreateModel(input *CreateModelInput) (*CreateModelOutput, error) {
	req, out := c.CreateModelRequest(input)
	return out, req.Send()
}

// CreateModelWithContext is the same as CreateModel with the addition of
// the ability to pass a context and additional request options.
//
// See CreateModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateModelWithContext(ctx aws.Context, input *CreateModelInput, opts ...request.Option) (*CreateModelOutput, error) {
	req, out := c.CreateModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNotebookInstance = "CreateNotebookInstance"

// CreateNotebookInstanceRequest generates a "aws/request.Request" representing the
// client's request for the CreateNotebookInstance operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateNotebookInstance for more information on using the CreateNotebookInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateNotebookInstanceRequest method.
//    req, resp := client.CreateNotebookInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateNotebookInstance
func (c *SageMaker) CreateNotebookInstanceRequest(input *CreateNotebookInstanceInput) (req *request.Request, output *CreateNotebookInstanceOutput) {
	op := &request.Operation{
		Name:       opCreateNotebookInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateNotebookInstanceInput{}
	}

	output = &CreateNotebookInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateNotebookInstance API operation for Amazon SageMaker Service.
//
// Creates an Amazon SageMaker notebook instance. A notebook instance is a machine
// learning (ML) compute instance running on a Jupyter notebook.
//
// In a CreateNotebookInstance request, specify the type of ML compute instance
// that you want to run. Amazon SageMaker launches the instance, installs common
// libraries that you can use to explore datasets for model training, and attaches
// an ML storage volume to the notebook instance.
//
// Amazon SageMaker also provides a set of example notebooks. Each notebook
// demonstrates how to use Amazon SageMaker with a specific algorithm or with
// a machine learning framework.
//
// After receiving the request, Amazon SageMaker does the following:
//
// Creates a network interface in the Amazon SageMaker VPC.
//
// (Option) If you specified SubnetId, Amazon SageMaker creates a network interface
// in your own VPC, which is inferred from the subnet ID that you provide in
// the input. When creating this network interface, Amazon SageMaker attaches
// the security group that you specified in the request to the network interface
// that it creates in your VPC.
//
// Launches an EC2 instance of the type specified in the request in the Amazon
// SageMaker VPC. If you specified SubnetId of your VPC, Amazon SageMaker specifies
// both network interfaces when launching this instance. This enables inbound
// traffic from your own VPC to the notebook instance, assuming that the security
// groups allow it.
//
// After creating the notebook instance, Amazon SageMaker returns its Amazon
// Resource Name (ARN).
//
// After Amazon SageMaker creates the notebook instance, you can connect to
// the Jupyter server and work in Jupyter notebooks. For example, you can write
// code to explore a dataset that you can use for model training, train a model,
// host models by creating Amazon SageMaker endpoints, and validate hosted models.
//
// For more information, see How It Works (http://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateNotebookInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceLimitExceeded "ResourceLimitExceeded"
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateNotebookInstance
func (c *SageMaker) CreateNotebookInstance(input *CreateNotebookInstanceInput) (*CreateNotebookInstanceOutput, error) {
	req, out := c.CreateNotebookInstanceRequest(input)
	return out, req.Send()
}

// CreateNotebookInstanceWithContext is the same as CreateNotebookInstance with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNotebookInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateNotebookInstanceWithContext(ctx aws.Context, input *CreateNotebookInstanceInput, opts ...request.Option) (*CreateNotebookInstanceOutput, error) {
	req, out := c.CreateNotebookInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNotebookInstanceLifecycleConfig = "CreateNotebookInstanceLifecycleConfig"

// CreateNotebookInstanceLifecycleConfigRequest generates a "aws/request.Request" representing the
// client's request for the CreateNotebookInstanceLifecycleConfig operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateNotebookInstanceLifecycleConfig for more information on using the CreateNotebookInstanceLifecycleConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateNotebookInstanceLifecycleConfigRequest method.
//    req, resp := client.CreateNotebookInstanceLifecycleConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateNotebookInstanceLifecycleConfig
func (c *SageMaker) CreateNotebookInstanceLifecycleConfigRequest(input *CreateNotebookInstanceLifecycleConfigInput) (req *request.Request, output *CreateNotebookInstanceLifecycleConfigOutput) {
	op := &request.Operation{
		Name:       opCreateNotebookInstanceLifecycleConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateNotebookInstanceLifecycleConfigInput{}
	}

	output = &CreateNotebookInstanceLifecycleConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateNotebookInstanceLifecycleConfig API operation for Amazon SageMaker Service.
//
// Creates a lifecycle configuration that you can associate with a notebook
// instance. A lifecycle configuration is a collection of shell scripts that
// run when you create or start a notebook instance.
//
// For information about notebook instance lifestyle configurations, see notebook-lifecycle-config.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateNotebookInstanceLifecycleConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceLimitExceeded "ResourceLimitExceeded"
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateNotebookInstanceLifecycleConfig
func (c *SageMaker) CreateNotebookInstanceLifecycleConfig(input *CreateNotebookInstanceLifecycleConfigInput) (*CreateNotebookInstanceLifecycleConfigOutput, error) {
	req, out := c.CreateNotebookInstanceLifecycleConfigRequest(input)
	return out, req.Send()
}

// CreateNotebookInstanceLifecycleConfigWithContext is the same as CreateNotebookInstanceLifecycleConfig with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNotebookInstanceLifecycleConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateNotebookInstanceLifecycleConfigWithContext(ctx aws.Context, input *CreateNotebookInstanceLifecycleConfigInput, opts ...request.Option) (*CreateNotebookInstanceLifecycleConfigOutput, error) {
	req, out := c.CreateNotebookInstanceLifecycleConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePresignedNotebookInstanceUrl = "CreatePresignedNotebookInstanceUrl"

// CreatePresignedNotebookInstanceUrlRequest generates a "aws/request.Request" representing the
// client's request for the CreatePresignedNotebookInstanceUrl operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePresignedNotebookInstanceUrl for more information on using the CreatePresignedNotebookInstanceUrl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePresignedNotebookInstanceUrlRequest method.
//    req, resp := client.CreatePresignedNotebookInstanceUrlRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePresignedNotebookInstanceUrl
func (c *SageMaker) CreatePresignedNotebookInstanceUrlRequest(input *CreatePresignedNotebookInstanceUrlInput) (req *request.Request, output *CreatePresignedNotebookInstanceUrlOutput) {
	op := &request.Operation{
		Name:       opCreatePresignedNotebookInstanceUrl,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePresignedNotebookInstanceUrlInput{}
	}

	output = &CreatePresignedNotebookInstanceUrlOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePresignedNotebookInstanceUrl API operation for Amazon SageMaker Service.
//
// Returns a URL that you can use to connect to the Juypter server from a notebook
// instance. In the Amazon SageMaker console, when you choose Open next to a
// notebook instance, Amazon SageMaker opens a new tab showing the Jupyter server
// home page from the notebook instance. The console uses this API to get the
// URL and show the page.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreatePresignedNotebookInstanceUrl for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePresignedNotebookInstanceUrl
func (c *SageMaker) CreatePresignedNotebookInstanceUrl(input *CreatePresignedNotebookInstanceUrlInput) (*CreatePresignedNotebookInstanceUrlOutput, error) {
	req, out := c.CreatePresignedNotebookInstanceUrlRequest(input)
	return out, req.Send()
}

// CreatePresignedNotebookInstanceUrlWithContext is the same as CreatePresignedNotebookInstanceUrl with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePresignedNotebookInstanceUrl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreatePresignedNotebookInstanceUrlWithContext(ctx aws.Context, input *CreatePresignedNotebookInstanceUrlInput, opts ...request.Option) (*CreatePresignedNotebookInstanceUrlOutput, error) {
	req, out := c.CreatePresignedNotebookInstanceUrlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTrainingJob = "CreateTrainingJob"

// CreateTrainingJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateTrainingJob operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTrainingJob for more information on using the CreateTrainingJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTrainingJobRequest method.
//    req, resp := client.CreateTrainingJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTrainingJob
func (c *SageMaker) CreateTrainingJobRequest(input *CreateTrainingJobInput) (req *request.Request, output *CreateTrainingJobOutput) {
	op := &request.Operation{
		Name:       opCreateTrainingJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTrainingJobInput{}
	}

	output = &CreateTrainingJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTrainingJob API operation for Amazon SageMaker Service.
//
// Starts a model training job. After training completes, Amazon SageMaker saves
// the resulting model artifacts to an Amazon S3 location that you specify.
//
// If you choose to host your model using Amazon SageMaker hosting services,
// you can use the resulting model artifacts as part of the model. You can also
// use the artifacts in a deep learning service other than Amazon SageMaker,
// provided that you know how to use them for inferences.
//
// In the request body, you provide the following:
//
//    * AlgorithmSpecification - Identifies the training algorithm to use.
//
//    * HyperParameters - Specify these algorithm-specific parameters to influence
//    the quality of the final model. For a list of hyperparameters for each
//    training algorithm provided by Amazon SageMaker, see Algorithms (http://docs.aws.amazon.com/sagemaker/latest/dg/algos.html).
//
//
//    * InputDataConfig - Describes the training dataset and the Amazon S3 location
//    where it is stored.
//
//    * OutputDataConfig - Identifies the Amazon S3 location where you want
//    Amazon SageMaker to save the results of model training.
//
//    * ResourceConfig - Identifies the resources, ML compute instances, and
//    ML storage volumes to deploy for model training. In distributed training,
//    you specify more than one instance.
//
//    * RoleARN - The Amazon Resource Number (ARN) that Amazon SageMaker assumes
//    to perform tasks on your behalf during model training. You must grant
//    this role the necessary permissions so that Amazon SageMaker can successfully
//    complete model training.
//
//    * StoppingCondition - Sets a duration for training. Use this parameter
//    to cap model training costs.
//
//  For more information about Amazon SageMaker, see How It Works (http://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateTrainingJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceInUse "ResourceInUse"
//   Resource being accessed is in use.
//
//   * ErrCodeResourceLimitExceeded "ResourceLimitExceeded"
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTrainingJob
func (c *SageMaker) CreateTrainingJob(input *CreateTrainingJobInput) (*CreateTrainingJobOutput, error) {
	req, out := c.CreateTrainingJobRequest(input)
	return out, req.Send()
}

// CreateTrainingJobWithContext is the same as CreateTrainingJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTrainingJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateTrainingJobWithContext(ctx aws.Context, input *CreateTrainingJobInput, opts ...request.Option) (*CreateTrainingJobOutput, error) {
	req, out := c.CreateTrainingJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEndpoint = "DeleteEndpoint"

// DeleteEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEndpoint operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEndpoint for more information on using the DeleteEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEndpointRequest method.
//    req, resp := client.DeleteEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteEndpoint
func (c *SageMaker) DeleteEndpointRequest(input *DeleteEndpointInput) (req *request.Request, output *DeleteEndpointOutput) {
	op := &request.Operation{
		Name:       opDeleteEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEndpointInput{}
	}

	output = &DeleteEndpointOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEndpoint API operation for Amazon SageMaker Service.
//
// Deletes an endpoint. Amazon SageMaker frees up all of the resources that
// were deployed when the endpoint was created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteEndpoint for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteEndpoint
func (c *SageMaker) DeleteEndpoint(input *DeleteEndpointInput) (*DeleteEndpointOutput, error) {
	req, out := c.DeleteEndpointRequest(input)
	return out, req.Send()
}

// DeleteEndpointWithContext is the same as DeleteEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteEndpointWithContext(ctx aws.Context, input *DeleteEndpointInput, opts ...request.Option) (*DeleteEndpointOutput, error) {
	req, out := c.DeleteEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEndpointConfig = "DeleteEndpointConfig"

// DeleteEndpointConfigRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEndpointConfig operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEndpointConfig for more information on using the DeleteEndpointConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEndpointConfigRequest method.
//    req, resp := client.DeleteEndpointConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteEndpointConfig
func (c *SageMaker) DeleteEndpointConfigRequest(input *DeleteEndpointConfigInput) (req *request.Request, output *DeleteEndpointConfigOutput) {
	op := &request.Operation{
		Name:       opDeleteEndpointConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEndpointConfigInput{}
	}

	output = &DeleteEndpointConfigOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEndpointConfig API operation for Amazon SageMaker Service.
//
// Deletes an endpoint configuration. The DeleteEndpoingConfig API deletes only
// the specified configuration. It does not delete endpoints created using the
// configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteEndpointConfig for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteEndpointConfig
func (c *SageMaker) DeleteEndpointConfig(input *DeleteEndpointConfigInput) (*DeleteEndpointConfigOutput, error) {
	req, out := c.DeleteEndpointConfigRequest(input)
	return out, req.Send()
}

// DeleteEndpointConfigWithContext is the same as DeleteEndpointConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEndpointConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteEndpointConfigWithContext(ctx aws.Context, input *DeleteEndpointConfigInput, opts ...request.Option) (*DeleteEndpointConfigOutput, error) {
	req, out := c.DeleteEndpointConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteModel = "DeleteModel"

// DeleteModelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteModel operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteModel for more information on using the DeleteModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteModelRequest method.
//    req, resp := client.DeleteModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModel
func (c *SageMaker) DeleteModelRequest(input *DeleteModelInput) (req *request.Request, output *DeleteModelOutput) {
	op := &request.Operation{
		Name:       opDeleteModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteModelInput{}
	}

	output = &DeleteModelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteModel API operation for Amazon SageMaker Service.
//
// Deletes a model. The DeleteModel API deletes only the model entry that was
// created in Amazon SageMaker when you called the CreateModel (http://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateModel.html)
// API. It does not delete model artifacts, inference code, or the IAM role
// that you specified when creating the model.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteModel for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModel
func (c *SageMaker) DeleteModel(input *DeleteModelInput) (*DeleteModelOutput, error) {
	req, out := c.DeleteModelRequest(input)
	return out, req.Send()
}

// DeleteModelWithContext is the same as DeleteModel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteModelWithContext(ctx aws.Context, input *DeleteModelInput, opts ...request.Option) (*DeleteModelOutput, error) {
	req, out := c.DeleteModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNotebookInstance = "DeleteNotebookInstance"

// DeleteNotebookInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNotebookInstance operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNotebookInstance for more information on using the DeleteNotebookInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteNotebookInstanceRequest method.
//    req, resp := client.DeleteNotebookInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteNotebookInstance
func (c *SageMaker) DeleteNotebookInstanceRequest(input *DeleteNotebookInstanceInput) (req *request.Request, output *DeleteNotebookInstanceOutput) {
	op := &request.Operation{
		Name:       opDeleteNotebookInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNotebookInstanceInput{}
	}

	output = &DeleteNotebookInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteNotebookInstance API operation for Amazon SageMaker Service.
//
// Deletes an Amazon SageMaker notebook instance. Before you can delete a notebook
// instance, you must call the StopNotebookInstance API.
//
// When you delete a notebook instance, you lose all of your data. Amazon SageMaker
// removes the ML compute instance, and deletes the ML storage volume and the
// network interface associated with the notebook instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteNotebookInstance for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteNotebookInstance
func (c *SageMaker) DeleteNotebookInstance(input *DeleteNotebookInstanceInput) (*DeleteNotebookInstanceOutput, error) {
	req, out := c.DeleteNotebookInstanceRequest(input)
	return out, req.Send()
}

// DeleteNotebookInstanceWithContext is the same as DeleteNotebookInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNotebookInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteNotebookInstanceWithContext(ctx aws.Context, input *DeleteNotebookInstanceInput, opts ...request.Option) (*DeleteNotebookInstanceOutput, error) {
	req, out := c.DeleteNotebookInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNotebookInstanceLifecycleConfig = "DeleteNotebookInstanceLifecycleConfig"

// DeleteNotebookInstanceLifecycleConfigRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNotebookInstanceLifecycleConfig operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNotebookInstanceLifecycleConfig for more information on using the DeleteNotebookInstanceLifecycleConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteNotebookInstanceLifecycleConfigRequest method.
//    req, resp := client.DeleteNotebookInstanceLifecycleConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteNotebookInstanceLifecycleConfig
func (c *SageMaker) DeleteNotebookInstanceLifecycleConfigRequest(input *DeleteNotebookInstanceLifecycleConfigInput) (req *request.Request, output *DeleteNotebookInstanceLifecycleConfigOutput) {
	op := &request.Operation{
		Name:       opDeleteNotebookInstanceLifecycleConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNotebookInstanceLifecycleConfigInput{}
	}

	output = &DeleteNotebookInstanceLifecycleConfigOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteNotebookInstanceLifecycleConfig API operation for Amazon SageMaker Service.
//
// Deletes a notebook instance lifecycle configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteNotebookInstanceLifecycleConfig for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteNotebookInstanceLifecycleConfig
func (c *SageMaker) DeleteNotebookInstanceLifecycleConfig(input *DeleteNotebookInstanceLifecycleConfigInput) (*DeleteNotebookInstanceLifecycleConfigOutput, error) {
	req, out := c.DeleteNotebookInstanceLifecycleConfigRequest(input)
	return out, req.Send()
}

// DeleteNotebookInstanceLifecycleConfigWithContext is the same as DeleteNotebookInstanceLifecycleConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNotebookInstanceLifecycleConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteNotebookInstanceLifecycleConfigWithContext(ctx aws.Context, input *DeleteNotebookInstanceLifecycleConfigInput, opts ...request.Option) (*DeleteNotebookInstanceLifecycleConfigOutput, error) {
	req, out := c.DeleteNotebookInstanceLifecycleConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTags = "DeleteTags"

// DeleteTagsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTags operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTags for more information on using the DeleteTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTagsRequest method.
//    req, resp := client.DeleteTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteTags
func (c *SageMaker) DeleteTagsRequest(input *DeleteTagsInput) (req *request.Request, output *DeleteTagsOutput) {
	op := &request.Operation{
		Name:       opDeleteTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTagsInput{}
	}

	output = &DeleteTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTags API operation for Amazon SageMaker Service.
//
// Deletes the specified tags from an Amazon SageMaker resource.
//
// To list a resource's tags, use the ListTags API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteTags for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteTags
func (c *SageMaker) DeleteTags(input *DeleteTagsInput) (*DeleteTagsOutput, error) {
	req, out := c.DeleteTagsRequest(input)
	return out, req.Send()
}

// DeleteTagsWithContext is the same as DeleteTags with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteTagsWithContext(ctx aws.Context, input *DeleteTagsInput, opts ...request.Option) (*DeleteTagsOutput, error) {
	req, out := c.DeleteTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEndpoint = "DescribeEndpoint"

// DescribeEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEndpoint operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEndpoint for more information on using the DescribeEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEndpointRequest method.
//    req, resp := client.DescribeEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEndpoint
func (c *SageMaker) DescribeEndpointRequest(input *DescribeEndpointInput) (req *request.Request, output *DescribeEndpointOutput) {
	op := &request.Operation{
		Name:       opDescribeEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEndpointInput{}
	}

	output = &DescribeEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEndpoint API operation for Amazon SageMaker Service.
//
// Returns the description of an endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeEndpoint for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEndpoint
func (c *SageMaker) DescribeEndpoint(input *DescribeEndpointInput) (*DescribeEndpointOutput, error) {
	req, out := c.DescribeEndpointRequest(input)
	return out, req.Send()
}

// DescribeEndpointWithContext is the same as DescribeEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeEndpointWithContext(ctx aws.Context, input *DescribeEndpointInput, opts ...request.Option) (*DescribeEndpointOutput, error) {
	req, out := c.DescribeEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEndpointConfig = "DescribeEndpointConfig"

// DescribeEndpointConfigRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEndpointConfig operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEndpointConfig for more information on using the DescribeEndpointConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEndpointConfigRequest method.
//    req, resp := client.DescribeEndpointConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEndpointConfig
func (c *SageMaker) DescribeEndpointConfigRequest(input *DescribeEndpointConfigInput) (req *request.Request, output *DescribeEndpointConfigOutput) {
	op := &request.Operation{
		Name:       opDescribeEndpointConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEndpointConfigInput{}
	}

	output = &DescribeEndpointConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEndpointConfig API operation for Amazon SageMaker Service.
//
// Returns the description of an endpoint configuration created using the CreateEndpointConfig
// API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeEndpointConfig for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEndpointConfig
func (c *SageMaker) DescribeEndpointConfig(input *DescribeEndpointConfigInput) (*DescribeEndpointConfigOutput, error) {
	req, out := c.DescribeEndpointConfigRequest(input)
	return out, req.Send()
}

// DescribeEndpointConfigWithContext is the same as DescribeEndpointConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEndpointConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeEndpointConfigWithContext(ctx aws.Context, input *DescribeEndpointConfigInput, opts ...request.Option) (*DescribeEndpointConfigOutput, error) {
	req, out := c.DescribeEndpointConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeModel = "DescribeModel"

// DescribeModelRequest generates a "aws/request.Request" representing the
// client's request for the DescribeModel operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeModel for more information on using the DescribeModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeModelRequest method.
//    req, resp := client.DescribeModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModel
func (c *SageMaker) DescribeModelRequest(input *DescribeModelInput) (req *request.Request, output *DescribeModelOutput) {
	op := &request.Operation{
		Name:       opDescribeModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeModelInput{}
	}

	output = &DescribeModelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeModel API operation for Amazon SageMaker Service.
//
// Describes a model that you created using the CreateModel API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeModel for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModel
func (c *SageMaker) DescribeModel(input *DescribeModelInput) (*DescribeModelOutput, error) {
	req, out := c.DescribeModelRequest(input)
	return out, req.Send()
}

// DescribeModelWithContext is the same as DescribeModel with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeModelWithContext(ctx aws.Context, input *DescribeModelInput, opts ...request.Option) (*DescribeModelOutput, error) {
	req, out := c.DescribeModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeNotebookInstance = "DescribeNotebookInstance"

// DescribeNotebookInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeNotebookInstance operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeNotebookInstance for more information on using the DescribeNotebookInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeNotebookInstanceRequest method.
//    req, resp := client.DescribeNotebookInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeNotebookInstance
func (c *SageMaker) DescribeNotebookInstanceRequest(input *DescribeNotebookInstanceInput) (req *request.Request, output *DescribeNotebookInstanceOutput) {
	op := &request.Operation{
		Name:       opDescribeNotebookInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeNotebookInstanceInput{}
	}

	output = &DescribeNotebookInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeNotebookInstance API operation for Amazon SageMaker Service.
//
// Returns information about a notebook instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeNotebookInstance for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeNotebookInstance
func (c *SageMaker) DescribeNotebookInstance(input *DescribeNotebookInstanceInput) (*DescribeNotebookInstanceOutput, error) {
	req, out := c.DescribeNotebookInstanceRequest(input)
	return out, req.Send()
}

// DescribeNotebookInstanceWithContext is the same as DescribeNotebookInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeNotebookInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeNotebookInstanceWithContext(ctx aws.Context, input *DescribeNotebookInstanceInput, opts ...request.Option) (*DescribeNotebookInstanceOutput, error) {
	req, out := c.DescribeNotebookInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeNotebookInstanceLifecycleConfig = "DescribeNotebookInstanceLifecycleConfig"

// DescribeNotebookInstanceLifecycleConfigRequest generates a "aws/request.Request" representing the
// client's request for the DescribeNotebookInstanceLifecycleConfig operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeNotebookInstanceLifecycleConfig for more information on using the DescribeNotebookInstanceLifecycleConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeNotebookInstanceLifecycleConfigRequest method.
//    req, resp := client.DescribeNotebookInstanceLifecycleConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeNotebookInstanceLifecycleConfig
func (c *SageMaker) DescribeNotebookInstanceLifecycleConfigRequest(input *DescribeNotebookInstanceLifecycleConfigInput) (req *request.Request, output *DescribeNotebookInstanceLifecycleConfigOutput) {
	op := &request.Operation{
		Name:       opDescribeNotebookInstanceLifecycleConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeNotebookInstanceLifecycleConfigInput{}
	}

	output = &DescribeNotebookInstanceLifecycleConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeNotebookInstanceLifecycleConfig API operation for Amazon SageMaker Service.
//
// Returns a description of a notebook instance lifecycle configuration.
//
// For information about notebook instance lifestyle configurations, see notebook-lifecycle-config.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeNotebookInstanceLifecycleConfig for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeNotebookInstanceLifecycleConfig
func (c *SageMaker) DescribeNotebookInstanceLifecycleConfig(input *DescribeNotebookInstanceLifecycleConfigInput) (*DescribeNotebookInstanceLifecycleConfigOutput, error) {
	req, out := c.DescribeNotebookInstanceLifecycleConfigRequest(input)
	return out, req.Send()
}

// DescribeNotebookInstanceLifecycleConfigWithContext is the same as DescribeNotebookInstanceLifecycleConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeNotebookInstanceLifecycleConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeNotebookInstanceLifecycleConfigWithContext(ctx aws.Context, input *DescribeNotebookInstanceLifecycleConfigInput, opts ...request.Option) (*DescribeNotebookInstanceLifecycleConfigOutput, error) {
	req, out := c.DescribeNotebookInstanceLifecycleConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTrainingJob = "DescribeTrainingJob"

// DescribeTrainingJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTrainingJob operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTrainingJob for more information on using the DescribeTrainingJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTrainingJobRequest method.
//    req, resp := client.DescribeTrainingJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTrainingJob
func (c *SageMaker) DescribeTrainingJobRequest(input *DescribeTrainingJobInput) (req *request.Request, output *DescribeTrainingJobOutput) {
	op := &request.Operation{
		Name:       opDescribeTrainingJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTrainingJobInput{}
	}

	output = &DescribeTrainingJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTrainingJob API operation for Amazon SageMaker Service.
//
// Returns information about a training job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeTrainingJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFound "ResourceNotFound"
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTrainingJob
func (c *SageMaker) DescribeTrainingJob(input *DescribeTrainingJobInput) (*DescribeTrainingJobOutput, error) {
	req, out := c.DescribeTrainingJobRequest(input)
	return out, req.Send()
}

// DescribeTrainingJobWithContext is the same as DescribeTrainingJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTrainingJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeTrainingJobWithContext(ctx aws.Context, input *DescribeTrainingJobInput, opts ...request.Option) (*DescribeTrainingJobOutput, error) {
	req, out := c.DescribeTrainingJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListEndpointConfigs = "ListEndpointConfigs"

// ListEndpointConfigsRequest generates a "aws/request.Request" representing the
// client's request for the ListEndpointConfigs operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEndpointConfigs for more information on using the ListEndpointConfigs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListEndpointConfigsRequest method.
//    req, resp := client.ListEndpointConfigsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListEndpointConfigs
func (c *SageMaker) ListEndpointConfigsRequest(input *ListEndpointConfigsInput) (req *request.Request, output *ListEndpointConfigsOutput) {
	op := &request.Operation{
		Name:       opListEndpointConfigs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEndpointConfigsInput{}
	}

	output = &ListEndpointConfigsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEndpointConfigs API operation for Amazon SageMaker Service.
//
// Lists endpoint configurations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListEndpointConfigs for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListEndpointConfigs
func (c *SageMaker) ListEndpointConfigs(input *ListEndpointConfigsInput) (*ListEndpointConfigsOutput, error) {
	req, out := c.ListEndpointConfigsRequest(input)
	return out, req.Send()
}

// ListEndpointConfigsWithContext is the same as ListEndpointConfigs with the addition of
// the ability to pass a context and additional request options.
//
// See ListEndpointConfigs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListEndpointConfigsWithContext(ctx aws.Context, input *ListEndpointConfigsInput, opts ...request.Option) (*ListEndpointConfigsOutput, error) {
	req, out := c.ListEndpointConfigsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEndpointConfigsPages iterates over the pages of a ListEndpointConfigs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEndpointConfigs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListEndpointConfigs operation.
//    pageNum := 0
//    err := client.ListEndpointConfigsPages(params,
//        func(page *ListEndpointConfigsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListEndpointConfigsPages(input *ListEndpointConfigsInput, fn func(*ListEndpointConfigsOutput, bool) bool) error {
	return c.ListEndpointConfigsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEndpointConfigsPagesWithContext same as ListEndpointConfigsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListEndpointConfigsPagesWithContext(ctx aws.Context, input *ListEndpointConfigsInput, fn func(*ListEndpointConfigsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEndpointConfigsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEndpointConfigsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListEndpointConfigsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListEndpoints = "ListEndpoints"

// ListEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the ListEndpoints operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEndpoints for more information on using the ListEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListEndpointsRequest method.
//    req, resp := client.ListEndpointsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListEndpoints
func (c *SageMaker) ListEndpointsRequest(input *ListEndpointsInput) (req *request.Request, output *ListEndpointsOutput) {
	op := &request.Operation{
		Name:       opListEndpoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEndpointsInput{}
	}

	output = &ListEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEndpoints API operation for Amazon SageMaker Service.
//
// Lists endpoints.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListEndpoints for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListEndpoints
func (c *SageMaker) ListEndpoints(input *ListEndpointsInput) (*ListEndpointsOutput, error) {
	req, out := c.ListEndpointsRequest(input)
	return out, req.Send()
}

// ListEndpointsWithContext is the same as ListEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See ListEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListEndpointsWithContext(ctx aws.Context, input *ListEndpointsInput, opts ...request.Option) (*ListEndpointsOutput, error) {
	req, out := c.ListEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEndpointsPages iterates over the pages of a ListEndpoints operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEndpoints method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListEndpoints operation.
//    pageNum := 0
//    err := client.ListEndpointsPages(params,
//        func(page *ListEndpointsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListEndpointsPages(input *ListEndpointsInput, fn func(*ListEndpointsOutput, bool) bool) error {
	return c.ListEndpointsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEndpointsPagesWithContext same as ListEndpointsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListEndpointsPagesWithContext(ctx aws.Context, input *ListEndpointsInput, fn func(*ListEndpointsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEndpointsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEndpointsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListEndpointsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListModels = "ListModels"

// ListModelsRequest generates a "aws/request.Request" representing the
// client's request for the ListModels operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListModels for more information on using the ListModels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListModelsRequest method.
//    req, resp := client.ListModelsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModels
func (c *SageMaker) ListModelsRequest(input *ListModelsInput) (req *request.Request, output *ListModelsOutput) {
	op := &request.Operation{
		Name:       opListModels,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListModelsInput{}
	}

	output = &ListModelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListModels API operation for Amazon SageMaker Service.
//
// Lists models created with the CreateModel (http://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateModel.html)
// API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListModels for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModels
func (c *SageMaker) ListModels(input *ListModelsInput) (*ListModelsOutput, error) {
	req, out := c.ListModelsRequest(input)
	return out, req.Send()
}

// ListModelsWithContext is the same as ListModels with the addition of
// the ability to pass a context and additional request options.
//
// See ListModels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListModelsWithContext(ctx aws.Context, input *ListModelsInput, opts ...request.Option) (*ListModelsOutput, error) {
	req, out := c.ListModelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListModelsPages iterates over the pages of a ListModels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListModels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListModels operation.
//    pageNum := 0
//    err := client.ListModelsPages(params,
//        func(page *ListModelsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListModelsPages(input *ListModelsInput, fn func(*ListModelsOutput, bool) bool) error {
	return c.ListModelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListModelsPagesWithContext same as ListModelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListModelsPagesWithContext(ctx aws.Context, input *ListModelsInput, fn func(*ListModelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListModelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListModelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListModelsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListNotebookInstanceLifecycleConfigs = "ListNotebookInstanceLifecycleConfigs"

// ListNotebookInstanceLifecycleConfigsRequest generates a "aws/request.Request" representing the
// client's request for the ListNotebookInstanceLifecycleConfigs operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListNotebookInstanceLifecycleConfigs for more information on using the ListNotebookInstanceLifecycleConfigs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListNotebookInstanceLifecycleConfigsRequest method.
//    req, resp := client.ListNotebookInstanceLifecycleConfigsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListNotebookInstanceLifecycleConfigs
func (c *SageMaker) ListNotebookInstanceLifecycleConfigsRequest(input *ListNotebookInstanceLifecycleConfigsInput) (req *request.Request, output *ListNotebookInstanceLifecycleConfigsOutput) {
	op := &request.Operation{
		Name:       opListNotebookInstanceLifecycleConfigs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListNotebookInstanceLifecycleConfigsInput{}
	}

	output = &ListNotebookInstanceLifecycleConfigsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListNotebookInstanceLifecycleConfigs API operation for Amazon SageMaker Service.
//
// Lists notebook instance lifestyle configurations created with the API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListNotebookInstanceLifecycleConfigs for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListNotebookInstanceLifecycleConfigs
func (c *SageMaker) ListNotebookInstanceLifecycleConfigs(input *ListNotebookInstanceLifecycleConfigsInput) (*ListNotebookInstanceLifecycleConfigsOutput, error) {
	req, out := c.ListNotebookInstanceLifecycleConfigsRequest(input)
	return out, req.Send()
}

// ListNotebookInstanceLifecycleConfigsWithContext is the same as ListNotebookInstanceLifecycleConfigs with the addition of
// the ability to pass a context and additional request options.
//
// See ListNotebookInstanceLifecycleConfigs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListNotebookInstanceLifecycleConfigsWithContext(ctx aws.Context, input *ListNotebookInstanceLifecycleConfigsInput, opts ...request.Option) (*ListNotebookInstanceLifecycleConfigsOutput, error) {
	req, out := c.ListNotebookInstanceLifecycleConfigsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListNotebookInstanceLifecycleConfigsPages iterates over the pages of a ListNotebookInstanceLifecycleConfigs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListNotebookInstanceLifecycleConfigs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListNotebookInstanceLifecycleConfigs operation.
//    pageNum := 0
//    err := client.ListNotebookInstanceLifecycleConfigsPages(params,
//        func(page *ListNotebookInstanceLifecycleConfigsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListNotebookInstanceLifecycleConfigsPages(input *ListNotebookInstanceLifecycleConfigsInput, fn func(*ListNotebookInstanceLifecycleConfigsOutput, bool) bool) error {
	return c.ListNotebookInstanceLifecycleConfigsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListNotebookInstanceLifecycleConfigsPagesWithContext same as ListNotebookInstanceLifecycleConfigsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListNotebookInstanceLifecycleConfigsPagesWithContext(ctx aws.Context, input *ListNotebookInstanceLifecycleConfigsInput, fn func(*ListNotebookInstanceLifecycleConfigsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListNotebookInstanceLifecycleConfigsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListNotebookInstanceLifecycleConfigsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListNotebookInstanceLifecycleConfigsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListNotebookInstances = "ListNotebookInstances"

// ListNotebookInstancesRequest generates a "aws/request.Request" representing the
// client's request for the ListNotebookInstances operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListNotebookInstances for more information on using the ListNotebookInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListNotebookInstancesRequest method.
//    req, resp := client.ListNotebookInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListNotebookInstances
func (c *SageMaker) ListNotebookInstancesRequest(input *ListNotebookInstancesInput) (req *request.Request, output *ListNotebookInstancesOutput) {
	op := &request.Operation{
		Name:       opListNotebookInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListNotebookInstancesInput{}
	}

	output = &ListNotebookInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListNotebookInstances API operation for Amazon SageMaker Service.
//
// Returns a list of the Amazon SageMaker notebook instances in the requester's
// account in an AWS Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListNotebookInstances for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListNotebookInstances
func (c *SageMaker) ListNotebookInstances(input *ListNotebookInstancesInput) (*ListNotebookInstancesOutput, error) {
	req, out := c.ListNotebookInstancesRequest(input)
	return out, req.Send()
}

// ListNotebookInstancesWithContext is the same as ListNotebookInstances with the addition of
// the ability to pass a context and additional request options.
//
// See ListNotebookInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListNotebookInstancesWithContext(ctx aws.Context, input *ListNotebookInstancesInput, opts ...request.Option) (*ListNotebookInstancesOutput, error) {
	req, out := c.ListNotebookInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListNotebookInstancesPages iterates over the pages of a ListNotebookInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListNotebookInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListNotebookInstances operation.
//    pageNum := 0
//    err := client.ListNotebookInstancesPages(params,
//        func(page *ListNotebookInstancesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListNotebookInstancesPages(input *ListNotebookInstancesInput, fn func(*ListNotebookInstancesOutput, bool) bool) error {
	return c.ListNotebookInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListNotebookInstancesPagesWithContext same as ListNotebookInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListNotebookInstancesPagesWithContext(ctx aws.Context, input *ListNotebookInstancesInput, fn func(*ListNotebookInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListNotebookInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListNotebookInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListNotebookInstancesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListTags = "ListTags"

// ListTagsRequest generates a "aws/request.Request" representing the
// client's request for the ListTags operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTags for more information on using the ListTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsRequest method.
//    req, resp := client.ListTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTags
func (c *SageMaker) ListTagsRequest(input *ListTagsInput) (req *request.Request, output *ListTagsOutput) {
	op := &request.Operation{
		Name:       opListTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTagsInput{}
	}

	output = &ListTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTags API operation for Amazon SageMaker Service.
//
// Returns the tags for the specified Amazon SageMaker resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListTags for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTags
func (c *SageMaker) ListTags(input *ListTagsInput) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	return out, req.Send()
}

// ListTagsWithContext is the same as ListTags with the addition of
// the ability to pass a context and additional request options.
//
// See ListTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListTagsWithContext(ctx aws.Context, input *ListTagsInput, opts ...request.Option) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTagsPages iterates over the pages of a ListTags operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTags method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTags operation.
//    pageNum := 0
//    err := client.ListTagsPages(params,
//        func(page *ListTagsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListTagsPages(input *ListTagsInput, fn func(*ListTagsOutput, bool) bool) error {
	return c.ListTagsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTagsPagesWithContext same as ListTagsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListTagsPagesWithContext(ctx aws.Context, input *ListTagsInput, fn func(*ListTagsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTagsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTagsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListTagsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListTrainingJobs = "ListTrainingJobs"

// ListTrainingJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListTrainingJobs operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTrainingJobs for more information on using the ListTrainingJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTrainingJobsRequest method.
//    req, resp := client.ListTrainingJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTrainingJobs
func (c *SageMaker) ListTrainingJobsRequest(input *ListTrainingJobsInput) (req *request.Request, output *ListTrainingJobsOutput) {
	op := &request.Operation{
		Name:       opListTrainingJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTrainingJobsInput{}
	}

	output = &ListTrainingJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTrainingJobs API operation for Amazon SageMaker Service.
//
// Lists training jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListTrainingJobs for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTrainingJobs
func (c *SageMaker) ListTrainingJobs(input *ListTrainingJobsInput) (*ListTrainingJobsOutput, error) {
	req, out := c.ListTrainingJobsRequest(input)
	return out, req.Send()
}

// ListTrainingJobsWithContext is the same as ListTrainingJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListTrainingJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListTrainingJobsWithContext(ctx aws.Context, input *ListTrainingJobsInput, opts ...request.Option) (*ListTrainingJobsOutput, error) {
	req, out := c.ListTrainingJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTrainingJobsPages iterates over the pages of a ListTrainingJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTrainingJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTrainingJobs operation.
//    pageNum := 0
//    err := client.ListTrainingJobsPages(params,
//        func(page *ListTrainingJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListTrainingJobsPages(input *ListTrainingJobsInput, fn func(*ListTrainingJobsOutput, bool) bool) error {
	return c.ListTrainingJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTrainingJobsPagesWithContext same as ListTrainingJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListTrainingJobsPagesWithContext(ctx aws.Context, input *ListTrainingJobsInput, fn func(*ListTrainingJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTrainingJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTrainingJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListTrainingJobsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opStartNotebookInstance = "StartNotebookInstance"

// StartNotebookInstanceRequest generates a "aws/request.Request" representing the
// client's request for the StartNotebookInstance operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartNotebookInstance for more information on using the StartNotebookInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartNotebookInstanceRequest method.
//    req, resp := client.StartNotebookInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StartNotebookInstance
func (c *SageMaker) StartNotebookInstanceRequest(input *StartNotebookInstanceInput) (req *request.Request, output *StartNotebookInstanceOutput) {
	op := &request.Operation{
		Name:       opStartNotebookInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartNotebookInstanceInput{}
	}

	output = &StartNotebookInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartNotebookInstance API operation for Amazon SageMaker Service.
//
// Launches an ML compute instance with the latest version of the libraries
// and attaches your ML storage volume. After configuring the notebook instance,
// Amazon SageMaker sets the notebook instance status to InService. A notebook
// instance's status must be InService before you can connect to your Jupyter
// notebook.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation StartNotebookInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceLimitExceeded "ResourceLimitExceeded"
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StartNotebookInstance
func (c *SageMaker) StartNotebookInstance(input *StartNotebookInstanceInput) (*StartNotebookInstanceOutput, error) {
	req, out := c.StartNotebookInstanceRequest(input)
	return out, req.Send()
}

// StartNotebookInstanceWithContext is the same as StartNotebookInstance with the addition of
// the ability to pass a context and additional request options.
//
// See StartNotebookInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) StartNotebookInstanceWithContext(ctx aws.Context, input *StartNotebookInstanceInput, opts ...request.Option) (*StartNotebookInstanceOutput, error) {
	req, out := c.StartNotebookInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopNotebookInstance = "StopNotebookInstance"

// StopNotebookInstanceRequest generates a "aws/request.Request" representing the
// client's request for the StopNotebookInstance operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopNotebookInstance for more information on using the StopNotebookInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopNotebookInstanceRequest method.
//    req, resp := client.StopNotebookInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopNotebookInstance
func (c *SageMaker) StopNotebookInstanceRequest(input *StopNotebookInstanceInput) (req *request.Request, output *StopNotebookInstanceOutput) {
	op := &request.Operation{
		Name:       opStopNotebookInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopNotebookInstanceInput{}
	}

	output = &StopNotebookInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopNotebookInstance API operation for Amazon SageMaker Service.
//
// Terminates the ML compute instance. Before terminating the instance, Amazon
// SageMaker disconnects the ML storage volume from it. Amazon SageMaker preserves
// the ML storage volume.
//
// To access data on the ML storage volume for a notebook instance that has
// been terminated, call the StartNotebookInstance API. StartNotebookInstance
// launches another ML compute instance, configures it, and attaches the preserved
// ML storage volume so you can continue your work.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation StopNotebookInstance for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopNotebookInstance
func (c *SageMaker) StopNotebookInstance(input *StopNotebookInstanceInput) (*StopNotebookInstanceOutput, error) {
	req, out := c.StopNotebookInstanceRequest(input)
	return out, req.Send()
}

// StopNotebookInstanceWithContext is the same as StopNotebookInstance with the addition of
// the ability to pass a context and additional request options.
//
// See StopNotebookInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) StopNotebookInstanceWithContext(ctx aws.Context, input *StopNotebookInstanceInput, opts ...request.Option) (*StopNotebookInstanceOutput, error) {
	req, out := c.StopNotebookInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopTrainingJob = "StopTrainingJob"

// StopTrainingJobRequest generates a "aws/request.Request" representing the
// client's request for the StopTrainingJob operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopTrainingJob for more information on using the StopTrainingJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopTrainingJobRequest method.
//    req, resp := client.StopTrainingJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopTrainingJob
func (c *SageMaker) StopTrainingJobRequest(input *StopTrainingJobInput) (req *request.Request, output *StopTrainingJobOutput) {
	op := &request.Operation{
		Name:       opStopTrainingJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopTrainingJobInput{}
	}

	output = &StopTrainingJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopTrainingJob API operation for Amazon SageMaker Service.
//
// Stops a training job. To stop a job, Amazon SageMaker sends the algorithm
// the SIGTERM signal, which delays job termination for 120 seconds. Algorithms
// might use this 120-second window to save the model artifacts, so the results
// of the training is not lost.
//
// Training algorithms provided by Amazon SageMaker save the intermediate results
// of a model training job. This intermediate data is a valid model artifact.
// You can use the model artifacts that are saved when Amazon SageMaker stops
// a training job to create a model.
//
// When it receives a StopTrainingJob request, Amazon SageMaker changes the
// status of the job to Stopping. After Amazon SageMaker stops the job, it sets
// the status to Stopped.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation StopTrainingJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFound "ResourceNotFound"
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopTrainingJob
func (c *SageMaker) StopTrainingJob(input *StopTrainingJobInput) (*StopTrainingJobOutput, error) {
	req, out := c.StopTrainingJobRequest(input)
	return out, req.Send()
}

// StopTrainingJobWithContext is the same as StopTrainingJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopTrainingJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) StopTrainingJobWithContext(ctx aws.Context, input *StopTrainingJobInput, opts ...request.Option) (*StopTrainingJobOutput, error) {
	req, out := c.StopTrainingJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEndpoint = "UpdateEndpoint"

// UpdateEndpointRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEndpoint operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEndpoint for more information on using the UpdateEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateEndpointRequest method.
//    req, resp := client.UpdateEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateEndpoint
func (c *SageMaker) UpdateEndpointRequest(input *UpdateEndpointInput) (req *request.Request, output *UpdateEndpointOutput) {
	op := &request.Operation{
		Name:       opUpdateEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateEndpointInput{}
	}

	output = &UpdateEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEndpoint API operation for Amazon SageMaker Service.
//
// Deploys the new EndpointConfig specified in the request, switches to using
// newly created endpoint, and then deletes resources provisioned for the endpoint
// using the previous EndpointConfig (there is no availability loss).
//
// When Amazon SageMaker receives the request, it sets the endpoint status to
// Updating. After updating the endpoint, it sets the status to InService. To
// check the status of an endpoint, use the DescribeEndpoint (http://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeEndpoint.html)
// API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation UpdateEndpoint for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceLimitExceeded "ResourceLimitExceeded"
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateEndpoint
func (c *SageMaker) UpdateEndpoint(input *UpdateEndpointInput) (*UpdateEndpointOutput, error) {
	req, out := c.UpdateEndpointRequest(input)
	return out, req.Send()
}

// UpdateEndpointWithContext is the same as UpdateEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) UpdateEndpointWithContext(ctx aws.Context, input *UpdateEndpointInput, opts ...request.Option) (*UpdateEndpointOutput, error) {
	req, out := c.UpdateEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEndpointWeightsAndCapacities = "UpdateEndpointWeightsAndCapacities"

// UpdateEndpointWeightsAndCapacitiesRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEndpointWeightsAndCapacities operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEndpointWeightsAndCapacities for more information on using the UpdateEndpointWeightsAndCapacities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateEndpointWeightsAndCapacitiesRequest method.
//    req, resp := client.UpdateEndpointWeightsAndCapacitiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateEndpointWeightsAndCapacities
func (c *SageMaker) UpdateEndpointWeightsAndCapacitiesRequest(input *UpdateEndpointWeightsAndCapacitiesInput) (req *request.Request, output *UpdateEndpointWeightsAndCapacitiesOutput) {
	op := &request.Operation{
		Name:       opUpdateEndpointWeightsAndCapacities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateEndpointWeightsAndCapacitiesInput{}
	}

	output = &UpdateEndpointWeightsAndCapacitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEndpointWeightsAndCapacities API operation for Amazon SageMaker Service.
//
// Updates variant weight of one or more variants associated with an existing
// endpoint, or capacity of one variant associated with an existing endpoint.
// When it receives the request, Amazon SageMaker sets the endpoint status to
// Updating. After updating the endpoint, it sets the status to InService. To
// check the status of an endpoint, use the DescribeEndpoint (http://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeEndpoint.html)
// API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation UpdateEndpointWeightsAndCapacities for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceLimitExceeded "ResourceLimitExceeded"
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateEndpointWeightsAndCapacities
func (c *SageMaker) UpdateEndpointWeightsAndCapacities(input *UpdateEndpointWeightsAndCapacitiesInput) (*UpdateEndpointWeightsAndCapacitiesOutput, error) {
	req, out := c.UpdateEndpointWeightsAndCapacitiesRequest(input)
	return out, req.Send()
}

// UpdateEndpointWeightsAndCapacitiesWithContext is the same as UpdateEndpointWeightsAndCapacities with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEndpointWeightsAndCapacities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) UpdateEndpointWeightsAndCapacitiesWithContext(ctx aws.Context, input *UpdateEndpointWeightsAndCapacitiesInput, opts ...request.Option) (*UpdateEndpointWeightsAndCapacitiesOutput, error) {
	req, out := c.UpdateEndpointWeightsAndCapacitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateNotebookInstance = "UpdateNotebookInstance"

// UpdateNotebookInstanceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateNotebookInstance operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateNotebookInstance for more information on using the UpdateNotebookInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateNotebookInstanceRequest method.
//    req, resp := client.UpdateNotebookInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateNotebookInstance
func (c *SageMaker) UpdateNotebookInstanceRequest(input *UpdateNotebookInstanceInput) (req *request.Request, output *UpdateNotebookInstanceOutput) {
	op := &request.Operation{
		Name:       opUpdateNotebookInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateNotebookInstanceInput{}
	}

	output = &UpdateNotebookInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateNotebookInstance API operation for Amazon SageMaker Service.
//
// Updates a notebook instance. NotebookInstance updates include upgrading or
// downgrading the ML compute instance used for your notebook instance to accommodate
// changes in your workload requirements. You can also update the VPC security
// groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation UpdateNotebookInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceLimitExceeded "ResourceLimitExceeded"
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateNotebookInstance
func (c *SageMaker) UpdateNotebookInstance(input *UpdateNotebookInstanceInput) (*UpdateNotebookInstanceOutput, error) {
	req, out := c.UpdateNotebookInstanceRequest(input)
	return out, req.Send()
}

// UpdateNotebookInstanceWithContext is the same as UpdateNotebookInstance with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateNotebookInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) UpdateNotebookInstanceWithContext(ctx aws.Context, input *UpdateNotebookInstanceInput, opts ...request.Option) (*UpdateNotebookInstanceOutput, error) {
	req, out := c.UpdateNotebookInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateNotebookInstanceLifecycleConfig = "UpdateNotebookInstanceLifecycleConfig"

// UpdateNotebookInstanceLifecycleConfigRequest generates a "aws/request.Request" representing the
// client's request for the UpdateNotebookInstanceLifecycleConfig operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateNotebookInstanceLifecycleConfig for more information on using the UpdateNotebookInstanceLifecycleConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateNotebookInstanceLifecycleConfigRequest method.
//    req, resp := client.UpdateNotebookInstanceLifecycleConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateNotebookInstanceLifecycleConfig
func (c *SageMaker) UpdateNotebookInstanceLifecycleConfigRequest(input *UpdateNotebookInstanceLifecycleConfigInput) (req *request.Request, output *UpdateNotebookInstanceLifecycleConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateNotebookInstanceLifecycleConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateNotebookInstanceLifecycleConfigInput{}
	}

	output = &UpdateNotebookInstanceLifecycleConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateNotebookInstanceLifecycleConfig API operation for Amazon SageMaker Service.
//
// Updates a notebook instance lifecycle configuration created with the API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation UpdateNotebookInstanceLifecycleConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceLimitExceeded "ResourceLimitExceeded"
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateNotebookInstanceLifecycleConfig
func (c *SageMaker) UpdateNotebookInstanceLifecycleConfig(input *UpdateNotebookInstanceLifecycleConfigInput) (*UpdateNotebookInstanceLifecycleConfigOutput, error) {
	req, out := c.UpdateNotebookInstanceLifecycleConfigRequest(input)
	return out, req.Send()
}

// UpdateNotebookInstanceLifecycleConfigWithContext is the same as UpdateNotebookInstanceLifecycleConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateNotebookInstanceLifecycleConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) UpdateNotebookInstanceLifecycleConfigWithContext(ctx aws.Context, input *UpdateNotebookInstanceLifecycleConfigInput, opts ...request.Option) (*UpdateNotebookInstanceLifecycleConfigOutput, error) {
	req, out := c.UpdateNotebookInstanceLifecycleConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AddTagsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource that you want to tag.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	// An array of Tag objects. Each tag is a key-value pair. Only the key parameter
	// is required. If you don't specify a value, Amazon SageMaker sets the value
	// to an empty string.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s AddTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddTagsInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *AddTagsInput) SetResourceArn(v string) *AddTagsInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AddTagsInput) SetTags(v []*Tag) *AddTagsInput {
	s.Tags = v
	return s
}

type AddTagsOutput struct {
	_ struct{} `type:"structure"`

	// A list of tags associated with the Amazon SageMaker resource.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s AddTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *AddTagsOutput) SetTags(v []*Tag) *AddTagsOutput {
	s.Tags = v
	return s
}

// Specifies the training algorithm to use in a CreateTrainingJob (http://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateTrainingJob.html)
// request.
//
// For more information about algorithms provided by Amazon SageMaker, see Algorithms
// (http://docs.aws.amazon.com/sagemaker/latest/dg/algos.html). For information
// about using your own algorithms, see Bring Your Own Algorithms  (http://docs.aws.amazon.com/sagemaker/latest/dg/adv-topics-own-algo.html).
type AlgorithmSpecification struct {
	_ struct{} `type:"structure"`

	// The registry path of the Docker image that contains the training algorithm.
	// For information about using your own algorithms, see Docker Registry Paths
	// for Algorithms Provided by Amazon SageMaker  (http://docs.aws.amazon.com/sagemaker/latest/dg/algos-docker-registry-paths.html).
	//
	// TrainingImage is a required field
	TrainingImage *string `type:"string" required:"true"`

	// The input mode that the algorithm supports. For the input modes that Amazon
	// SageMaker algorithms support, see Algorithms (http://docs.aws.amazon.com/sagemaker/latest/dg/algos.html).
	// If an algorithm supports the File input mode, Amazon SageMaker downloads
	// the training data from S3 to the provisioned ML storage Volume, and mounts
	// the directory to docker volume for training container. If an algorithm supports
	// the Pipe input mode, Amazon SageMaker streams data directly from S3 to the
	// container.
	//
	// In File mode, make sure you provision ML storage volume with sufficient capacity
	// to accommodate the data download from S3. In addition to the training data,
	// the ML storage volume also stores the output model. The algorithm container
	// use ML storage volume to also store intermediate information, if any.
	//
	// For distributed algorithms using File mode, training data is distributed
	// uniformly, and your training duration is predictable if the input data objects
	// size is approximately same. Amazon SageMaker does not split the files any
	// further for model training. If the object sizes are skewed, training won't
	// be optimal as the data distribution is also skewed where one host in a training
	// cluster is overloaded, thus becoming bottleneck in training.
	//
	// TrainingInputMode is a required field
	TrainingInputMode *string `type:"string" required:"true" enum:"TrainingInputMode"`
}

// String returns the string representation
func (s AlgorithmSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AlgorithmSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AlgorithmSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AlgorithmSpecification"}
	if s.TrainingImage == nil {
		invalidParams.Add(request.NewErrParamRequired("TrainingImage"))
	}
	if s.TrainingInputMode == nil {
		invalidParams.Add(request.NewErrParamRequired("TrainingInputMode"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTrainingImage sets the TrainingImage field's value.
func (s *AlgorithmSpecification) SetTrainingImage(v string) *AlgorithmSpecification {
	s.TrainingImage = &v
	return s
}

// SetTrainingInputMode sets the TrainingInputMode field's value.
func (s *AlgorithmSpecification) SetTrainingInputMode(v string) *AlgorithmSpecification {
	s.TrainingInputMode = &v
	return s
}

// A channel is a named input source that training algorithms can consume.
type Channel struct {
	_ struct{} `type:"structure"`

	// The name of the channel.
	//
	// ChannelName is a required field
	ChannelName *string `min:"1" type:"string" required:"true"`

	// If training data is compressed, the compression type. The default value is
	// None. CompressionType is used only in PIPE input mode. In FILE mode, leave
	// this field unset or set it to None.
	CompressionType *string `type:"string" enum:"CompressionType"`

	// The MIME type of the data.
	ContentType *string `type:"string"`

	// The location of the channel data.
	//
	// DataSource is a required field
	DataSource *DataSource `type:"structure" required:"true"`

	// Specify RecordIO as the value when input data is in raw format but the training
	// algorithm requires the RecordIO format, in which caseAmazon SageMaker wraps
	// each individual S3 object in a RecordIO record. If the input data is already
	// in RecordIO format, you don't need to set this attribute. For more information,
	// see Create a Dataset Using RecordIO (https://mxnet.incubator.apache.org/how_to/recordio.html?highlight=im2rec)
	RecordWrapperType *string `type:"string" enum:"RecordWrapper"`
}

// String returns the string representation
func (s Channel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Channel) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Channel) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Channel"}
	if s.ChannelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelName"))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelName", 1))
	}
	if s.DataSource == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSource"))
	}
	if s.DataSource != nil {
		if err := s.DataSource.Validate(); err != nil {
			invalidParams.AddNested("DataSource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelName sets the ChannelName field's value.
func (s *Channel) SetChannelName(v string) *Channel {
	s.ChannelName = &v
	return s
}

// SetCompressionType sets the CompressionType field's value.
func (s *Channel) SetCompressionType(v string) *Channel {
	s.CompressionType = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *Channel) SetContentType(v string) *Channel {
	s.ContentType = &v
	return s
}

// SetDataSource sets the DataSource field's value.
func (s *Channel) SetDataSource(v *DataSource) *Channel {
	s.DataSource = v
	return s
}

// SetRecordWrapperType sets the RecordWrapperType field's value.
func (s *Channel) SetRecordWrapperType(v string) *Channel {
	s.RecordWrapperType = &v
	return s
}

// Describes the container, as part of model definition.
type ContainerDefinition struct {
	_ struct{} `type:"structure"`

	// The DNS host name for the container after Amazon SageMaker deploys it.
	ContainerHostname *string `type:"string"`

	// The environment variables to set in the Docker container. Each key and value
	// in the Environment string to string map can have length of up to 1024. We
	// support up to 16 entries in the map.
	Environment map[string]*string `type:"map"`

	// The Amazon EC2 Container Registry (Amazon ECR) path where inference code
	// is stored. If you are using your own custom algorithm instead of an algorithm
	// provided by Amazon SageMaker, the inference code must meet Amazon SageMaker
	// requirements. For more information, see Using Your Own Algorithms with Amazon
	// SageMaker (http://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html)
	//
	// Image is a required field
	Image *string `type:"string" required:"true"`

	// The S3 path where the model artifacts, which result from model training,
	// are stored. This path must point to a single gzip compressed tar archive
	// (.tar.gz suffix).
	ModelDataUrl *string `type:"string"`
}

// String returns the string representation
func (s ContainerDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContainerDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContainerDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContainerDefinition"}
	if s.Image == nil {
		invalidParams.Add(request.NewErrParamRequired("Image"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerHostname sets the ContainerHostname field's value.
func (s *ContainerDefinition) SetContainerHostname(v string) *ContainerDefinition {
	s.ContainerHostname = &v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *ContainerDefinition) SetEnvironment(v map[string]*string) *ContainerDefinition {
	s.Environment = v
	return s
}

// SetImage sets the Image field's value.
func (s *ContainerDefinition) SetImage(v string) *ContainerDefinition {
	s.Image = &v
	return s
}

// SetModelDataUrl sets the ModelDataUrl field's value.
func (s *ContainerDefinition) SetModelDataUrl(v string) *ContainerDefinition {
	s.ModelDataUrl = &v
	return s
}

type CreateEndpointConfigInput struct {
	_ struct{} `type:"structure"`

	// The name of the endpoint configuration. You specify this name in a CreateEndpoint
	// (http://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpoint.html)
	// request.
	//
	// EndpointConfigName is a required field
	EndpointConfigName *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of a AWS Key Management Service key that Amazon
	// SageMaker uses to encrypt data on the storage volume attached to the ML compute
	// instance that hosts the endpoint.
	KmsKeyId *string `type:"string"`

	// An array of ProductionVariant objects, one for each model that you want to
	// host at this endpoint.
	//
	// ProductionVariants is a required field
	ProductionVariants []*ProductionVariant `min:"1" type:"list" required:"true"`

	// An array of key-value pairs. For more information, see Using Cost Allocation
	// Tags (http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what)
	// in the AWS Billing and Cost Management User Guide.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateEndpointConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEndpointConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEndpointConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEndpointConfigInput"}
	if s.EndpointConfigName == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointConfigName"))
	}
	if s.ProductionVariants == nil {
		invalidParams.Add(request.NewErrParamRequired("ProductionVariants"))
	}
	if s.ProductionVariants != nil && len(s.ProductionVariants) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProductionVariants", 1))
	}
	if s.ProductionVariants != nil {
		for i, v := range s.ProductionVariants {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ProductionVariants", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointConfigName sets the EndpointConfigName field's value.
func (s *CreateEndpointConfigInput) SetEndpointConfigName(v string) *CreateEndpointConfigInput {
	s.EndpointConfigName = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateEndpointConfigInput) SetKmsKeyId(v string) *CreateEndpointConfigInput {
	s.KmsKeyId = &v
	return s
}

// SetProductionVariants sets the ProductionVariants field's value.
func (s *CreateEndpointConfigInput) SetProductionVariants(v []*ProductionVariant) *CreateEndpointConfigInput {
	s.ProductionVariants = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEndpointConfigInput) SetTags(v []*Tag) *CreateEndpointConfigInput {
	s.Tags = v
	return s
}

type CreateEndpointConfigOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the endpoint configuration.
	//
	// EndpointConfigArn is a required field
	EndpointConfigArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateEndpointConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEndpointConfigOutput) GoString() string {
	return s.String()
}

// SetEndpointConfigArn sets the EndpointConfigArn field's value.
func (s *CreateEndpointConfigOutput) SetEndpointConfigArn(v string) *CreateEndpointConfigOutput {
	s.EndpointConfigArn = &v
	return s
}

type CreateEndpointInput struct {
	_ struct{} `type:"structure"`

	// The name of an endpoint configuration. For more information, see CreateEndpointConfig
	// (http://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html).
	//
	// EndpointConfigName is a required field
	EndpointConfigName *string `type:"string" required:"true"`

	// The name of the endpoint. The name must be unique within an AWS Region in
	// your AWS account.
	//
	// EndpointName is a required field
	EndpointName *string `type:"string" required:"true"`

	// An array of key-value pairs. For more information, see Using Cost Allocation
	// Tags (http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what)in
	// the AWS Billing and Cost Management User Guide.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEndpointInput"}
	if s.EndpointConfigName == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointConfigName"))
	}
	if s.EndpointName == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointName"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointConfigName sets the EndpointConfigName field's value.
func (s *CreateEndpointInput) SetEndpointConfigName(v string) *CreateEndpointInput {
	s.EndpointConfigName = &v
	return s
}

// SetEndpointName sets the EndpointName field's value.
func (s *CreateEndpointInput) SetEndpointName(v string) *CreateEndpointInput {
	s.EndpointName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEndpointInput) SetTags(v []*Tag) *CreateEndpointInput {
	s.Tags = v
	return s
}

type CreateEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the endpoint.
	//
	// EndpointArn is a required field
	EndpointArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEndpointOutput) GoString() string {
	return s.String()
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *CreateEndpointOutput) SetEndpointArn(v string) *CreateEndpointOutput {
	s.EndpointArn = &v
	return s
}

type CreateModelInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker can
	// assume to access model artifacts and docker image for deployment on ML compute
	// instances. Deploying on ML compute instances is part of model hosting. For
	// more information, see Amazon SageMaker Roles (http://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html).
	//
	// ExecutionRoleArn is a required field
	ExecutionRoleArn *string `min:"20" type:"string" required:"true"`

	// The name of the new model.
	//
	// ModelName is a required field
	ModelName *string `type:"string" required:"true"`

	// The location of the primary docker image containing inference code, associated
	// artifacts, and custom environment map that the inference code uses when the
	// model is deployed into production.
	//
	// PrimaryContainer is a required field
	PrimaryContainer *ContainerDefinition `type:"structure" required:"true"`

	// An array of key-value pairs. For more information, see Using Cost Allocation
	// Tags (http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what)
	// in the AWS Billing and Cost Management User Guide.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateModelInput"}
	if s.ExecutionRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ExecutionRoleArn"))
	}
	if s.ExecutionRoleArn != nil && len(*s.ExecutionRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ExecutionRoleArn", 20))
	}
	if s.ModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelName"))
	}
	if s.PrimaryContainer == nil {
		invalidParams.Add(request.NewErrParamRequired("PrimaryContainer"))
	}
	if s.PrimaryContainer != nil {
		if err := s.PrimaryContainer.Validate(); err != nil {
			invalidParams.AddNested("PrimaryContainer", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *CreateModelInput) SetExecutionRoleArn(v string) *CreateModelInput {
	s.ExecutionRoleArn = &v
	return s
}

// SetModelName sets the ModelName field's value.
func (s *CreateModelInput) SetModelName(v string) *CreateModelInput {
	s.ModelName = &v
	return s
}

// SetPrimaryContainer sets the PrimaryContainer field's value.
func (s *CreateModelInput) SetPrimaryContainer(v *ContainerDefinition) *CreateModelInput {
	s.PrimaryContainer = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateModelInput) SetTags(v []*Tag) *CreateModelInput {
	s.Tags = v
	return s
}

type CreateModelOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the model created in Amazon SageMaker.
	//
	// ModelArn is a required field
	ModelArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateModelOutput) GoString() string {
	return s.String()
}

// SetModelArn sets the ModelArn field's value.
func (s *CreateModelOutput) SetModelArn(v string) *CreateModelOutput {
	s.ModelArn = &v
	return s
}

type CreateNotebookInstanceInput struct {
	_ struct{} `type:"structure"`

	// Sets whether Amazon SageMaker provides internet access to the notebook instance.
	// If you set this to Disabled this notebook instance will be able to access
	// resources only in your VPC, and will not be able to connect to Amazon SageMaker
	// training and endpoint services unless your configure a NAT Gateway in your
	// VPC.
	//
	// For more information, see appendix-notebook-and-internet-access. You can
	// set the value of this parameter to Disabled only if you set a value for the
	// SubnetId parameter.
	DirectInternetAccess *string `type:"string" enum:"DirectInternetAccess"`

	// The type of ML compute instance to launch for the notebook instance.
	//
	// InstanceType is a required field
	InstanceType *string `type:"string" required:"true" enum:"InstanceType"`

	// If you provide a AWS KMS key ID, Amazon SageMaker uses it to encrypt data
	// at rest on the ML storage volume that is attached to your notebook instance.
	KmsKeyId *string `type:"string"`

	// The name of a lifecycle configuration to associate with the notebook instance.
	// For information about lifestyle configurations, see notebook-lifecycle-config.
	LifecycleConfigName *string `type:"string"`

	// The name of the new notebook instance.
	//
	// NotebookInstanceName is a required field
	NotebookInstanceName *string `type:"string" required:"true"`

	// When you send any requests to AWS resources from the notebook instance, Amazon
	// SageMaker assumes this role to perform tasks on your behalf. You must grant
	// this role necessary permissions so Amazon SageMaker can perform these tasks.
	// The policy must allow the Amazon SageMaker service principal (sagemaker.amazonaws.com)
	// permissions to assume this role. For more information, see Amazon SageMaker
	// Roles (http://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html).
	//
	// RoleArn is a required field
	RoleArn *string `min:"20" type:"string" required:"true"`

	// The VPC security group IDs, in the form sg-xxxxxxxx. The security groups
	// must be for the same VPC as specified in the subnet.
	SecurityGroupIds []*string `type:"list"`

	// The ID of the subnet in a VPC to which you would like to have a connectivity
	// from your ML compute instance.
	SubnetId *string `type:"string"`

	// A list of tags to associate with the notebook instance. You can add tags
	// later by using the CreateTags API.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateNotebookInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNotebookInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateNotebookInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateNotebookInstanceInput"}
	if s.InstanceType == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceType"))
	}
	if s.NotebookInstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("NotebookInstanceName"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectInternetAccess sets the DirectInternetAccess field's value.
func (s *CreateNotebookInstanceInput) SetDirectInternetAccess(v string) *CreateNotebookInstanceInput {
	s.DirectInternetAccess = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *CreateNotebookInstanceInput) SetInstanceType(v string) *CreateNotebookInstanceInput {
	s.InstanceType = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateNotebookInstanceInput) SetKmsKeyId(v string) *CreateNotebookInstanceInput {
	s.KmsKeyId = &v
	return s
}

// SetLifecycleConfigName sets the LifecycleConfigName field's value.
func (s *CreateNotebookInstanceInput) SetLifecycleConfigName(v string) *CreateNotebookInstanceInput {
	s.LifecycleConfigName = &v
	return s
}

// SetNotebookInstanceName sets the NotebookInstanceName field's value.
func (s *CreateNotebookInstanceInput) SetNotebookInstanceName(v string) *CreateNotebookInstanceInput {
	s.NotebookInstanceName = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateNotebookInstanceInput) SetRoleArn(v string) *CreateNotebookInstanceInput {
	s.RoleArn = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *CreateNotebookInstanceInput) SetSecurityGroupIds(v []*string) *CreateNotebookInstanceInput {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *CreateNotebookInstanceInput) SetSubnetId(v string) *CreateNotebookInstanceInput {
	s.SubnetId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateNotebookInstanceInput) SetTags(v []*Tag) *CreateNotebookInstanceInput {
	s.Tags = v
	return s
}

type CreateNotebookInstanceLifecycleConfigInput struct {
	_ struct{} `type:"structure"`

	// The name of the lifecycle configuration.
	//
	// NotebookInstanceLifecycleConfigName is a required field
	NotebookInstanceLifecycleConfigName *string `type:"string" required:"true"`

	// A shell script that runs only once, when you create a notebook instance.
	OnCreate []*NotebookInstanceLifecycleHook `type:"list"`

	// A shell script that runs every time you start a notebook instance, including
	// when you create the notebook instance.
	OnStart []*NotebookInstanceLifecycleHook `type:"list"`
}

// String returns the string representation
func (s CreateNotebookInstanceLifecycleConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNotebookInstanceLifecycleConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateNotebookInstanceLifecycleConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateNotebookInstanceLifecycleConfigInput"}
	if s.NotebookInstanceLifecycleConfigName == nil {
		invalidParams.Add(request.NewErrParamRequired("NotebookInstanceLifecycleConfigName"))
	}
	if s.OnCreate != nil {
		for i, v := range s.OnCreate {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OnCreate", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.OnStart != nil {
		for i, v := range s.OnStart {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OnStart", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNotebookInstanceLifecycleConfigName sets the NotebookInstanceLifecycleConfigName field's value.
func (s *CreateNotebookInstanceLifecycleConfigInput) SetNotebookInstanceLifecycleConfigName(v string) *CreateNotebookInstanceLifecycleConfigInput {
	s.NotebookInstanceLifecycleConfigName = &v
	return s
}

// SetOnCreate sets the OnCreate field's value.
func (s *CreateNotebookInstanceLifecycleConfigInput) SetOnCreate(v []*NotebookInstanceLifecycleHook) *CreateNotebookInstanceLifecycleConfigInput {
	s.OnCreate = v
	return s
}

// SetOnStart sets the OnStart field's value.
func (s *CreateNotebookInstanceLifecycleConfigInput) SetOnStart(v []*NotebookInstanceLifecycleHook) *CreateNotebookInstanceLifecycleConfigInput {
	s.OnStart = v
	return s
}

type CreateNotebookInstanceLifecycleConfigOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the lifecycle configuration.
	NotebookInstanceLifecycleConfigArn *string `type:"string"`
}

// String returns the string representation
func (s CreateNotebookInstanceLifecycleConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNotebookInstanceLifecycleConfigOutput) GoString() string {
	return s.String()
}

// SetNotebookInstanceLifecycleConfigArn sets the NotebookInstanceLifecycleConfigArn field's value.
func (s *CreateNotebookInstanceLifecycleConfigOutput) SetNotebookInstanceLifecycleConfigArn(v string) *CreateNotebookInstanceLifecycleConfigOutput {
	s.NotebookInstanceLifecycleConfigArn = &v
	return s
}

type CreateNotebookInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the notebook instance.
	NotebookInstanceArn *string `type:"string"`
}

// String returns the string representation
func (s CreateNotebookInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNotebookInstanceOutput) GoString() string {
	return s.String()
}

// SetNotebookInstanceArn sets the NotebookInstanceArn field's value.
func (s *CreateNotebookInstanceOutput) SetNotebookInstanceArn(v string) *CreateNotebookInstanceOutput {
	s.NotebookInstanceArn = &v
	return s
}

type CreatePresignedNotebookInstanceUrlInput struct {
	_ struct{} `type:"structure"`

	// The name of the notebook instance.
	//
	// NotebookInstanceName is a required field
	NotebookInstanceName *string `type:"string" required:"true"`

	// The duration of the session, in seconds. The default is 12 hours.
	SessionExpirationDurationInSeconds *int64 `min:"1800" type:"integer"`
}

// String returns the string representation
func (s CreatePresignedNotebookInstanceUrlInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePresignedNotebookInstanceUrlInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePresignedNotebookInstanceUrlInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePresignedNotebookInstanceUrlInput"}
	if s.NotebookInstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("NotebookInstanceName"))
	}
	if s.SessionExpirationDurationInSeconds != nil && *s.SessionExpirationDurationInSeconds < 1800 {
		invalidParams.Add(request.NewErrParamMinValue("SessionExpirationDurationInSeconds", 1800))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNotebookInstanceName sets the NotebookInstanceName field's value.
func (s *CreatePresignedNotebookInstanceUrlInput) SetNotebookInstanceName(v string) *CreatePresignedNotebookInstanceUrlInput {
	s.NotebookInstanceName = &v
	return s
}

// SetSessionExpirationDurationInSeconds sets the SessionExpirationDurationInSeconds field's value.
func (s *CreatePresignedNotebookInstanceUrlInput) SetSessionExpirationDurationInSeconds(v int64) *CreatePresignedNotebookInstanceUrlInput {
	s.SessionExpirationDurationInSeconds = &v
	return s
}

type CreatePresignedNotebookInstanceUrlOutput struct {
	_ struct{} `type:"structure"`

	// A JSON object that contains the URL string.
	AuthorizedUrl *string `type:"string"`
}

// String returns the string representation
func (s CreatePresignedNotebookInstanceUrlOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePresignedNotebookInstanceUrlOutput) GoString() string {
	return s.String()
}

// SetAuthorizedUrl sets the AuthorizedUrl field's value.
func (s *CreatePresignedNotebookInstanceUrlOutput) SetAuthorizedUrl(v string) *CreatePresignedNotebookInstanceUrlOutput {
	s.AuthorizedUrl = &v
	return s
}

type CreateTrainingJobInput struct {
	_ struct{} `type:"structure"`

	// The registry path of the Docker image that contains the training algorithm
	// and algorithm-specific metadata, including the input mode. For more information
	// about algorithms provided by Amazon SageMaker, see Algorithms (http://docs.aws.amazon.com/sagemaker/latest/dg/algos.html).
	// For information about providing your own algorithms, see Bring Your Own Algorithms
	//  (http://docs.aws.amazon.com/sagemaker/latest/dg/adv-topics-own-algo.html).
	//
	// AlgorithmSpecification is a required field
	AlgorithmSpecification *AlgorithmSpecification `type:"structure" required:"true"`

	// Algorithm-specific parameters. You set hyperparameters before you start the
	// learning process. Hyperparameters influence the quality of the model. For
	// a list of hyperparameters for each training algorithm provided by Amazon
	// SageMaker, see Algorithms (http://docs.aws.amazon.com/sagemaker/latest/dg/algos.html).
	//
	// You can specify a maximum of 100 hyperparameters. Each hyperparameter is
	// a key-value pair. Each key and value is limited to 256 characters, as specified
	// by the Length Constraint.
	HyperParameters map[string]*string `type:"map"`

	// An array of Channel objects. Each channel is a named input source. InputDataConfig
	// describes the input data and its location.
	//
	// Algorithms can accept input data from one or more channels. For example,
	// an algorithm might have two channels of input data, training_data and validation_data.
	// The configuration for each channel provides the S3 location where the input
	// data is stored. It also provides information about the stored data: the MIME
	// type, compression method, and whether the data is wrapped in RecordIO format.
	//
	// Depending on the input mode that the algorithm supports, Amazon SageMaker
	// either copies input data files from an S3 bucket to a local directory in
	// the Docker container, or makes it available as input streams.
	//
	// InputDataConfig is a required field
	InputDataConfig []*Channel `min:"1" type:"list" required:"true"`

	// Specifies the path to the S3 bucket where you want to store model artifacts.
	// Amazon SageMaker creates subfolders for the artifacts.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `type:"structure" required:"true"`

	// The resources, including the ML compute instances and ML storage volumes,
	// to use for model training.
	//
	// ML storage volumes store model artifacts and incremental states. Training
	// algorithms might also use ML storage volumes for scratch space. If you want
	// Amazon SageMaker to use the ML storage volume to store the training data,
	// choose File as the TrainingInputMode in the algorithm specification. For
	// distributed training algorithms, specify an instance count greater than 1.
	//
	// ResourceConfig is a required field
	ResourceConfig *ResourceConfig `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume
	// to perform tasks on your behalf.
	//
	// During model training, Amazon SageMaker needs your permission to read input
	// data from an S3 bucket, download a Docker image that contains training code,
	// write model artifacts to an S3 bucket, write logs to Amazon CloudWatch Logs,
	// and publish metrics to Amazon CloudWatch. You grant permissions for all of
	// these tasks to an IAM role. For more information, see Amazon SageMaker Roles
	// (http://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html).
	//
	// RoleArn is a required field
	RoleArn *string `min:"20" type:"string" required:"true"`

	// Sets a duration for training. Use this parameter to cap model training costs.
	// To stop a job, Amazon SageMaker sends the algorithm the SIGTERM signal, which
	// delays job termination for 120 seconds. Algorithms might use this 120-second
	// window to save the model artifacts.
	//
	// When Amazon SageMaker terminates a job because the stopping condition has
	// been met, training algorithms provided by Amazon SageMaker save the intermediate
	// results of the job. This intermediate data is a valid model artifact. You
	// can use it to create a model using the CreateModel API.
	//
	// StoppingCondition is a required field
	StoppingCondition *StoppingCondition `type:"structure" required:"true"`

	// An array of key-value pairs. For more information, see Using Cost Allocation
	// Tags (http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what)
	// in the AWS Billing and Cost Management User Guide.
	Tags []*Tag `type:"list"`

	// The name of the training job. The name must be unique within an AWS Region
	// in an AWS account. It appears in the Amazon SageMaker console.
	//
	// TrainingJobName is a required field
	TrainingJobName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateTrainingJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTrainingJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTrainingJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTrainingJobInput"}
	if s.AlgorithmSpecification == nil {
		invalidParams.Add(request.NewErrParamRequired("AlgorithmSpecification"))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.InputDataConfig != nil && len(s.InputDataConfig) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputDataConfig", 1))
	}
	if s.OutputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputDataConfig"))
	}
	if s.ResourceConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceConfig"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.StoppingCondition == nil {
		invalidParams.Add(request.NewErrParamRequired("StoppingCondition"))
	}
	if s.TrainingJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrainingJobName"))
	}
	if s.TrainingJobName != nil && len(*s.TrainingJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrainingJobName", 1))
	}
	if s.AlgorithmSpecification != nil {
		if err := s.AlgorithmSpecification.Validate(); err != nil {
			invalidParams.AddNested("AlgorithmSpecification", err.(request.ErrInvalidParams))
		}
	}
	if s.InputDataConfig != nil {
		for i, v := range s.InputDataConfig {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InputDataConfig", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.ResourceConfig != nil {
		if err := s.ResourceConfig.Validate(); err != nil {
			invalidParams.AddNested("ResourceConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.StoppingCondition != nil {
		if err := s.StoppingCondition.Validate(); err != nil {
			invalidParams.AddNested("StoppingCondition", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlgorithmSpecification sets the AlgorithmSpecification field's value.
func (s *CreateTrainingJobInput) SetAlgorithmSpecification(v *AlgorithmSpecification) *CreateTrainingJobInput {
	s.AlgorithmSpecification = v
	return s
}

// SetHyperParameters sets the HyperParameters field's value.
func (s *CreateTrainingJobInput) SetHyperParameters(v map[string]*string) *CreateTrainingJobInput {
	s.HyperParameters = v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *CreateTrainingJobInput) SetInputDataConfig(v []*Channel) *CreateTrainingJobInput {
	s.InputDataConfig = v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *CreateTrainingJobInput) SetOutputDataConfig(v *OutputDataConfig) *CreateTrainingJobInput {
	s.OutputDataConfig = v
	return s
}

// SetResourceConfig sets the ResourceConfig field's value.
func (s *CreateTrainingJobInput) SetResourceConfig(v *ResourceConfig) *CreateTrainingJobInput {
	s.ResourceConfig = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateTrainingJobInput) SetRoleArn(v string) *CreateTrainingJobInput {
	s.RoleArn = &v
	return s
}

// SetStoppingCondition sets the StoppingCondition field's value.
func (s *CreateTrainingJobInput) SetStoppingCondition(v *StoppingCondition) *CreateTrainingJobInput {
	s.StoppingCondition = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTrainingJobInput) SetTags(v []*Tag) *CreateTrainingJobInput {
	s.Tags = v
	return s
}

// SetTrainingJobName sets the TrainingJobName field's value.
func (s *CreateTrainingJobInput) SetTrainingJobName(v string) *CreateTrainingJobInput {
	s.TrainingJobName = &v
	return s
}

type CreateTrainingJobOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the training job.
	//
	// TrainingJobArn is a required field
	TrainingJobArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateTrainingJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTrainingJobOutput) GoString() string {
	return s.String()
}

// SetTrainingJobArn sets the TrainingJobArn field's value.
func (s *CreateTrainingJobOutput) SetTrainingJobArn(v string) *CreateTrainingJobOutput {
	s.TrainingJobArn = &v
	return s
}

// Describes the location of the channel data.
type DataSource struct {
	_ struct{} `type:"structure"`

	// The S3 location of the data source that is associated with a channel.
	//
	// S3DataSource is a required field
	S3DataSource *S3DataSource `type:"structure" required:"true"`
}

// String returns the string representation
func (s DataSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataSource"}
	if s.S3DataSource == nil {
		invalidParams.Add(request.NewErrParamRequired("S3DataSource"))
	}
	if s.S3DataSource != nil {
		if err := s.S3DataSource.Validate(); err != nil {
			invalidParams.AddNested("S3DataSource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3DataSource sets the S3DataSource field's value.
func (s *DataSource) SetS3DataSource(v *S3DataSource) *DataSource {
	s.S3DataSource = v
	return s
}

type DeleteEndpointConfigInput struct {
	_ struct{} `type:"structure"`

	// The name of the endpoint configuration that you want to delete.
	//
	// EndpointConfigName is a required field
	EndpointConfigName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEndpointConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEndpointConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEndpointConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEndpointConfigInput"}
	if s.EndpointConfigName == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointConfigName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointConfigName sets the EndpointConfigName field's value.
func (s *DeleteEndpointConfigInput) SetEndpointConfigName(v string) *DeleteEndpointConfigInput {
	s.EndpointConfigName = &v
	return s
}

type DeleteEndpointConfigOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteEndpointConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEndpointConfigOutput) GoString() string {
	return s.String()
}

type DeleteEndpointInput struct {
	_ struct{} `type:"structure"`

	// The name of the endpoint that you want to delete.
	//
	// EndpointName is a required field
	EndpointName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEndpointInput"}
	if s.EndpointName == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointName sets the EndpointName field's value.
func (s *DeleteEndpointInput) SetEndpointName(v string) *DeleteEndpointInput {
	s.EndpointName = &v
	return s
}

type DeleteEndpointOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEndpointOutput) GoString() string {
	return s.String()
}

type DeleteModelInput struct {
	_ struct{} `type:"structure"`

	// The name of the model to delete.
	//
	// ModelName is a required field
	ModelName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteModelInput"}
	if s.ModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetModelName sets the ModelName field's value.
func (s *DeleteModelInput) SetModelName(v string) *DeleteModelInput {
	s.ModelName = &v
	return s
}

type DeleteModelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteModelOutput) GoString() string {
	return s.String()
}

type DeleteNotebookInstanceInput struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon SageMaker notebook instance to delete.
	//
	// NotebookInstanceName is a required field
	NotebookInstanceName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteNotebookInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNotebookInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteNotebookInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteNotebookInstanceInput"}
	if s.NotebookInstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("NotebookInstanceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNotebookInstanceName sets the NotebookInstanceName field's value.
func (s *DeleteNotebookInstanceInput) SetNotebookInstanceName(v string) *DeleteNotebookInstanceInput {
	s.NotebookInstanceName = &v
	return s
}

type DeleteNotebookInstanceLifecycleConfigInput struct {
	_ struct{} `type:"structure"`

	// The name of the lifecycle configuration to delete.
	//
	// NotebookInstanceLifecycleConfigName is a required field
	NotebookInstanceLifecycleConfigName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteNotebookInstanceLifecycleConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNotebookInstanceLifecycleConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteNotebookInstanceLifecycleConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteNotebookInstanceLifecycleConfigInput"}
	if s.NotebookInstanceLifecycleConfigName == nil {
		invalidParams.Add(request.NewErrParamRequired("NotebookInstanceLifecycleConfigName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNotebookInstanceLifecycleConfigName sets the NotebookInstanceLifecycleConfigName field's value.
func (s *DeleteNotebookInstanceLifecycleConfigInput) SetNotebookInstanceLifecycleConfigName(v string) *DeleteNotebookInstanceLifecycleConfigInput {
	s.NotebookInstanceLifecycleConfigName = &v
	return s
}

type DeleteNotebookInstanceLifecycleConfigOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteNotebookInstanceLifecycleConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNotebookInstanceLifecycleConfigOutput) GoString() string {
	return s.String()
}

type DeleteNotebookInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteNotebookInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNotebookInstanceOutput) GoString() string {
	return s.String()
}

type DeleteTagsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource whose tags you want to delete.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	// An array or one or more tag keys to delete.
	//
	// TagKeys is a required field
	TagKeys []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTagsInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DeleteTagsInput) SetResourceArn(v string) *DeleteTagsInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *DeleteTagsInput) SetTagKeys(v []*string) *DeleteTagsInput {
	s.TagKeys = v
	return s
}

type DeleteTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTagsOutput) GoString() string {
	return s.String()
}

type DescribeEndpointConfigInput struct {
	_ struct{} `type:"structure"`

	// The name of the endpoint configuration.
	//
	// EndpointConfigName is a required field
	EndpointConfigName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeEndpointConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEndpointConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEndpointConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEndpointConfigInput"}
	if s.EndpointConfigName == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointConfigName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointConfigName sets the EndpointConfigName field's value.
func (s *DescribeEndpointConfigInput) SetEndpointConfigName(v string) *DescribeEndpointConfigInput {
	s.EndpointConfigName = &v
	return s
}

type DescribeEndpointConfigOutput struct {
	_ struct{} `type:"structure"`

	// A timestamp that shows when the endpoint configuration was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// The Amazon Resource Name (ARN) of the endpoint configuration.
	//
	// EndpointConfigArn is a required field
	EndpointConfigArn *string `min:"20" type:"string" required:"true"`

	// Name of the Amazon SageMaker endpoint configuration.
	//
	// EndpointConfigName is a required field
	EndpointConfigName *string `type:"string" required:"true"`

	// AWS KMS key ID Amazon SageMaker uses to encrypt data when storing it on the
	// ML storage volume attached to the instance.
	KmsKeyId *string `type:"string"`

	// An array of ProductionVariant objects, one for each model that you want to
	// host at this endpoint.
	//
	// ProductionVariants is a required field
	ProductionVariants []*ProductionVariant `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeEndpointConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEndpointConfigOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeEndpointConfigOutput) SetCreationTime(v time.Time) *DescribeEndpointConfigOutput {
	s.CreationTime = &v
	return s
}

// SetEndpointConfigArn sets the EndpointConfigArn field's value.
func (s *DescribeEndpointConfigOutput) SetEndpointConfigArn(v string) *DescribeEndpointConfigOutput {
	s.EndpointConfigArn = &v
	return s
}

// SetEndpointConfigName sets the EndpointConfigName field's value.
func (s *DescribeEndpointConfigOutput) SetEndpointConfigName(v string) *DescribeEndpointConfigOutput {
	s.EndpointConfigName = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *DescribeEndpointConfigOutput) SetKmsKeyId(v string) *DescribeEndpointConfigOutput {
	s.KmsKeyId = &v
	return s
}

// SetProductionVariants sets the ProductionVariants field's value.
func (s *DescribeEndpointConfigOutput) SetProductionVariants(v []*ProductionVariant) *DescribeEndpointConfigOutput {
	s.ProductionVariants = v
	return s
}

type DescribeEndpointInput struct {
	_ struct{} `type:"structure"`

	// The name of the endpoint.
	//
	// EndpointName is a required field
	EndpointName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEndpointInput"}
	if s.EndpointName == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointName sets the EndpointName field's value.
func (s *DescribeEndpointInput) SetEndpointName(v string) *DescribeEndpointInput {
	s.EndpointName = &v
	return s
}

type DescribeEndpointOutput struct {
	_ struct{} `type:"structure"`

	// A timestamp that shows when the endpoint was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// The Amazon Resource Name (ARN) of the endpoint.
	//
	// EndpointArn is a required field
	EndpointArn *string `min:"20" type:"string" required:"true"`

	// The name of the endpoint configuration associated with this endpoint.
	//
	// EndpointConfigName is a required field
	EndpointConfigName *string `type:"string" required:"true"`

	// Name of the endpoint.
	//
	// EndpointName is a required field
	EndpointName *string `type:"string" required:"true"`

	// The status of the endpoint.
	//
	// EndpointStatus is a required field
	EndpointStatus *string `type:"string" required:"true" enum:"EndpointStatus"`

	// If the status of the endpoint is Failed, the reason why it failed.
	FailureReason *string `type:"string"`

	// A timestamp that shows when the endpoint was last modified.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// An array of ProductionVariant objects, one for each model hosted behind this
	// endpoint.
	ProductionVariants []*ProductionVariantSummary `min:"1" type:"list"`
}

// String returns the string representation
func (s DescribeEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEndpointOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeEndpointOutput) SetCreationTime(v time.Time) *DescribeEndpointOutput {
	s.CreationTime = &v
	return s
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *DescribeEndpointOutput) SetEndpointArn(v string) *DescribeEndpointOutput {
	s.EndpointArn = &v
	return s
}

// SetEndpointConfigName sets the EndpointConfigName field's value.
func (s *DescribeEndpointOutput) SetEndpointConfigName(v string) *DescribeEndpointOutput {
	s.EndpointConfigName = &v
	return s
}

// SetEndpointName sets the EndpointName field's value.
func (s *DescribeEndpointOutput) SetEndpointName(v string) *DescribeEndpointOutput {
	s.EndpointName = &v
	return s
}

// SetEndpointStatus sets the EndpointStatus field's value.
func (s *DescribeEndpointOutput) SetEndpointStatus(v string) *DescribeEndpointOutput {
	s.EndpointStatus = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *DescribeEndpointOutput) SetFailureReason(v string) *DescribeEndpointOutput {
	s.FailureReason = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *DescribeEndpointOutput) SetLastModifiedTime(v time.Time) *DescribeEndpointOutput {
	s.LastModifiedTime = &v
	return s
}

// SetProductionVariants sets the ProductionVariants field's value.
func (s *DescribeEndpointOutput) SetProductionVariants(v []*ProductionVariantSummary) *DescribeEndpointOutput {
	s.ProductionVariants = v
	return s
}

type DescribeModelInput struct {
	_ struct{} `type:"structure"`

	// The name of the model.
	//
	// ModelName is a required field
	ModelName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeModelInput"}
	if s.ModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetModelName sets the ModelName field's value.
func (s *DescribeModelInput) SetModelName(v string) *DescribeModelInput {
	s.ModelName = &v
	return s
}

type DescribeModelOutput struct {
	_ struct{} `type:"structure"`

	// A timestamp that shows when the model was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role that you specified for the
	// model.
	//
	// ExecutionRoleArn is a required field
	ExecutionRoleArn *string `min:"20" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the model.
	//
	// ModelArn is a required field
	ModelArn *string `min:"20" type:"string" required:"true"`

	// Name of the Amazon SageMaker model.
	//
	// ModelName is a required field
	ModelName *string `type:"string" required:"true"`

	// The location of the primary inference code, associated artifacts, and custom
	// environment map that the inference code uses when it is deployed in production.
	//
	// PrimaryContainer is a required field
	PrimaryContainer *ContainerDefinition `type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeModelOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeModelOutput) SetCreationTime(v time.Time) *DescribeModelOutput {
	s.CreationTime = &v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *DescribeModelOutput) SetExecutionRoleArn(v string) *DescribeModelOutput {
	s.ExecutionRoleArn = &v
	return s
}

// SetModelArn sets the ModelArn field's value.
func (s *DescribeModelOutput) SetModelArn(v string) *DescribeModelOutput {
	s.ModelArn = &v
	return s
}

// SetModelName sets the ModelName field's value.
func (s *DescribeModelOutput) SetModelName(v string) *DescribeModelOutput {
	s.ModelName = &v
	return s
}

// SetPrimaryContainer sets the PrimaryContainer field's value.
func (s *DescribeModelOutput) SetPrimaryContainer(v *ContainerDefinition) *DescribeModelOutput {
	s.PrimaryContainer = v
	return s
}

type DescribeNotebookInstanceInput struct {
	_ struct{} `type:"structure"`

	// The name of the notebook instance that you want information about.
	//
	// NotebookInstanceName is a required field
	NotebookInstanceName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeNotebookInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeNotebookInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeNotebookInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeNotebookInstanceInput"}
	if s.NotebookInstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("NotebookInstanceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNotebookInstanceName sets the NotebookInstanceName field's value.
func (s *DescribeNotebookInstanceInput) SetNotebookInstanceName(v string) *DescribeNotebookInstanceInput {
	s.NotebookInstanceName = &v
	return s
}

type DescribeNotebookInstanceLifecycleConfigInput struct {
	_ struct{} `type:"structure"`

	// The name of the lifecycle configuration to describe.
	//
	// NotebookInstanceLifecycleConfigName is a required field
	NotebookInstanceLifecycleConfigName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeNotebookInstanceLifecycleConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeNotebookInstanceLifecycleConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeNotebookInstanceLifecycleConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeNotebookInstanceLifecycleConfigInput"}
	if s.NotebookInstanceLifecycleConfigName == nil {
		invalidParams.Add(request.NewErrParamRequired("NotebookInstanceLifecycleConfigName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNotebookInstanceLifecycleConfigName sets the NotebookInstanceLifecycleConfigName field's value.
func (s *DescribeNotebookInstanceLifecycleConfigInput) SetNotebookInstanceLifecycleConfigName(v string) *DescribeNotebookInstanceLifecycleConfigInput {
	s.NotebookInstanceLifecycleConfigName = &v
	return s
}

type DescribeNotebookInstanceLifecycleConfigOutput struct {
	_ struct{} `type:"structure"`

	// A timestamp that tells when the lifecycle configuration was created.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A timestamp that tells when the lifecycle configuration was last modified.
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The Amazon Resource Name (ARN) of the lifecycle configuration.
	NotebookInstanceLifecycleConfigArn *string `type:"string"`

	// The name of the lifecycle configuration.
	NotebookInstanceLifecycleConfigName *string `type:"string"`

	// The shell script that runs only once, when you create a notebook instance.
	OnCreate []*NotebookInstanceLifecycleHook `type:"list"`

	// The shell script that runs every time you start a notebook instance, including
	// when you create the notebook instance.
	OnStart []*NotebookInstanceLifecycleHook `type:"list"`
}

// String returns the string representation
func (s DescribeNotebookInstanceLifecycleConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeNotebookInstanceLifecycleConfigOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeNotebookInstanceLifecycleConfigOutput) SetCreationTime(v time.Time) *DescribeNotebookInstanceLifecycleConfigOutput {
	s.CreationTime = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *DescribeNotebookInstanceLifecycleConfigOutput) SetLastModifiedTime(v time.Time) *DescribeNotebookInstanceLifecycleConfigOutput {
	s.LastModifiedTime = &v
	return s
}

// SetNotebookInstanceLifecycleConfigArn sets the NotebookInstanceLifecycleConfigArn field's value.
func (s *DescribeNotebookInstanceLifecycleConfigOutput) SetNotebookInstanceLifecycleConfigArn(v string) *DescribeNotebookInstanceLifecycleConfigOutput {
	s.NotebookInstanceLifecycleConfigArn = &v
	return s
}

// SetNotebookInstanceLifecycleConfigName sets the NotebookInstanceLifecycleConfigName field's value.
func (s *DescribeNotebookInstanceLifecycleConfigOutput) SetNotebookInstanceLifecycleConfigName(v string) *DescribeNotebookInstanceLifecycleConfigOutput {
	s.NotebookInstanceLifecycleConfigName = &v
	return s
}

// SetOnCreate sets the OnCreate field's value.
func (s *DescribeNotebookInstanceLifecycleConfigOutput) SetOnCreate(v []*NotebookInstanceLifecycleHook) *DescribeNotebookInstanceLifecycleConfigOutput {
	s.OnCreate = v
	return s
}

// SetOnStart sets the OnStart field's value.
func (s *DescribeNotebookInstanceLifecycleConfigOutput) SetOnStart(v []*NotebookInstanceLifecycleHook) *DescribeNotebookInstanceLifecycleConfigOutput {
	s.OnStart = v
	return s
}

type DescribeNotebookInstanceOutput struct {
	_ struct{} `type:"structure"`

	// A timestamp. Use this parameter to return the time when the notebook instance
	// was created
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Describes whether the notebook instance has internet access.
	//
	// For more information, see appendix-notebook-and-internet-access.
	DirectInternetAccess *string `type:"string" enum:"DirectInternetAccess"`

	// If status is failed, the reason it failed.
	FailureReason *string `type:"string"`

	// The type of ML compute instance running on the notebook instance.
	InstanceType *string `type:"string" enum:"InstanceType"`

	// AWS KMS key ID Amazon SageMaker uses to encrypt data when storing it on the
	// ML storage volume attached to the instance.
	KmsKeyId *string `type:"string"`

	// A timestamp. Use this parameter to retrieve the time when the notebook instance
	// was last modified.
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Network interface IDs that Amazon SageMaker created at the time of creating
	// the instance.
	NetworkInterfaceId *string `type:"string"`

	// The Amazon Resource Name (ARN) of the notebook instance.
	NotebookInstanceArn *string `type:"string"`

	// Returns the name of a notebook instance lifecycle configuration.
	//
	// For information about notebook instance lifestyle configurations, see notebook-lifecycle-config.
	NotebookInstanceLifecycleConfigName *string `type:"string"`

	// Name of the Amazon SageMaker notebook instance.
	NotebookInstanceName *string `type:"string"`

	// The status of the notebook instance.
	NotebookInstanceStatus *string `type:"string" enum:"NotebookInstanceStatus"`

	// Amazon Resource Name (ARN) of the IAM role associated with the instance.
	RoleArn *string `min:"20" type:"string"`

	// The IDs of the VPC security groups.
	SecurityGroups []*string `type:"list"`

	// The ID of the VPC subnet.
	SubnetId *string `type:"string"`

	// The URL that you use to connect to the Jupyter notebook that is running in
	// your notebook instance.
	Url *string `type:"string"`
}

// String returns the string representation
func (s DescribeNotebookInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeNotebookInstanceOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeNotebookInstanceOutput) SetCreationTime(v time.Time) *DescribeNotebookInstanceOutput {
	s.CreationTime = &v
	return s
}

// SetDirectInternetAccess sets the DirectInternetAccess field's value.
func (s *DescribeNotebookInstanceOutput) SetDirectInternetAccess(v string) *DescribeNotebookInstanceOutput {
	s.DirectInternetAccess = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *DescribeNotebookInstanceOutput) SetFailureReason(v string) *DescribeNotebookInstanceOutput {
	s.FailureReason = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *DescribeNotebookInstanceOutput) SetInstanceType(v string) *DescribeNotebookInstanceOutput {
	s.InstanceType = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *DescribeNotebookInstanceOutput) SetKmsKeyId(v string) *DescribeNotebookInstanceOutput {
	s.KmsKeyId = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *DescribeNotebookInstanceOutput) SetLastModifiedTime(v time.Time) *DescribeNotebookInstanceOutput {
	s.LastModifiedTime = &v
	return s
}

// SetNetworkInterfaceId sets the NetworkInterfaceId field's value.
func (s *DescribeNotebookInstanceOutput) SetNetworkInterfaceId(v string) *DescribeNotebookInstanceOutput {
	s.NetworkInterfaceId = &v
	return s
}

// SetNotebookInstanceArn sets the NotebookInstanceArn field's value.
func (s *DescribeNotebookInstanceOutput) SetNotebookInstanceArn(v string) *DescribeNotebookInstanceOutput {
	s.NotebookInstanceArn = &v
	return s
}

// SetNotebookInstanceLifecycleConfigName sets the NotebookInstanceLifecycleConfigName field's value.
func (s *DescribeNotebookInstanceOutput) SetNotebookInstanceLifecycleConfigName(v string) *DescribeNotebookInstanceOutput {
	s.NotebookInstanceLifecycleConfigName = &v
	return s
}

// SetNotebookInstanceName sets the NotebookInstanceName field's value.
func (s *DescribeNotebookInstanceOutput) SetNotebookInstanceName(v string) *DescribeNotebookInstanceOutput {
	s.NotebookInstanceName = &v
	return s
}

// SetNotebookInstanceStatus sets the NotebookInstanceStatus field's value.
func (s *DescribeNotebookInstanceOutput) SetNotebookInstanceStatus(v string) *DescribeNotebookInstanceOutput {
	s.NotebookInstanceStatus = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeNotebookInstanceOutput) SetRoleArn(v string) *DescribeNotebookInstanceOutput {
	s.RoleArn = &v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *DescribeNotebookInstanceOutput) SetSecurityGroups(v []*string) *DescribeNotebookInstanceOutput {
	s.SecurityGroups = v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *DescribeNotebookInstanceOutput) SetSubnetId(v string) *DescribeNotebookInstanceOutput {
	s.SubnetId = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *DescribeNotebookInstanceOutput) SetUrl(v string) *DescribeNotebookInstanceOutput {
	s.Url = &v
	return s
}

type DescribeTrainingJobInput struct {
	_ struct{} `type:"structure"`

	// The name of the training job.
	//
	// TrainingJobName is a required field
	TrainingJobName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeTrainingJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTrainingJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTrainingJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTrainingJobInput"}
	if s.TrainingJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrainingJobName"))
	}
	if s.TrainingJobName != nil && len(*s.TrainingJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrainingJobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTrainingJobName sets the TrainingJobName field's value.
func (s *DescribeTrainingJobInput) SetTrainingJobName(v string) *DescribeTrainingJobInput {
	s.TrainingJobName = &v
	return s
}

type DescribeTrainingJobOutput struct {
	_ struct{} `type:"structure"`

	// Information about the algorithm used for training, and algorithm metadata.
	//
	// AlgorithmSpecification is a required field
	AlgorithmSpecification *AlgorithmSpecification `type:"structure" required:"true"`

	// A timestamp that indicates when the training job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// If the training job failed, the reason it failed.
	FailureReason *string `type:"string"`

	// Algorithm-specific parameters.
	HyperParameters map[string]*string `type:"map"`

	// An array of Channel objects that describes each data input channel.
	//
	// InputDataConfig is a required field
	InputDataConfig []*Channel `min:"1" type:"list" required:"true"`

	// A timestamp that indicates when the status of the training job was last modified.
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Information about the Amazon S3 location that is configured for storing model
	// artifacts.
	//
	// ModelArtifacts is a required field
	ModelArtifacts *ModelArtifacts `type:"structure" required:"true"`

	// The S3 path where model artifacts that you configured when creating the job
	// are stored. Amazon SageMaker creates subfolders for model artifacts.
	OutputDataConfig *OutputDataConfig `type:"structure"`

	// Resources, including ML compute instances and ML storage volumes, that are
	// configured for model training.
	//
	// ResourceConfig is a required field
	ResourceConfig *ResourceConfig `type:"structure" required:"true"`

	// The AWS Identity and Access Management (IAM) role configured for the training
	// job.
	RoleArn *string `min:"20" type:"string"`

	// Provides granular information about the system state. For more information,
	// see TrainingJobStatus.
	//
	// SecondaryStatus is a required field
	SecondaryStatus *string `type:"string" required:"true" enum:"SecondaryStatus"`

	// The condition under which to stop the training job.
	//
	// StoppingCondition is a required field
	StoppingCondition *StoppingCondition `type:"structure" required:"true"`

	// A timestamp that indicates when model training ended.
	TrainingEndTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The Amazon Resource Name (ARN) of the training job.
	//
	// TrainingJobArn is a required field
	TrainingJobArn *string `type:"string" required:"true"`

	// Name of the model training job.
	//
	// TrainingJobName is a required field
	TrainingJobName *string `min:"1" type:"string" required:"true"`

	// The status of the training job.
	//
	// For the InProgress status, Amazon SageMaker can return these secondary statuses:
	//
	//    * Starting - Preparing for training.
	//
	//    * Downloading - Optional stage for algorithms that support File training
	//    input mode. It indicates data is being downloaded to ML storage volumes.
	//
	//    * Training - Training is in progress.
	//
	//    * Uploading - Training is complete and model upload is in progress.
	//
	// For the Stopped training status, Amazon SageMaker can return these secondary
	// statuses:
	//
	//    * MaxRuntimeExceeded - Job stopped as a result of maximum allowed runtime
	//    exceeded.
	//
	// TrainingJobStatus is a required field
	TrainingJobStatus *string `type:"string" required:"true" enum:"TrainingJobStatus"`

	// A timestamp that indicates when training started.
	TrainingStartTime *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s DescribeTrainingJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTrainingJobOutput) GoString() string {
	return s.String()
}

// SetAlgorithmSpecification sets the AlgorithmSpecification field's value.
func (s *DescribeTrainingJobOutput) SetAlgorithmSpecification(v *AlgorithmSpecification) *DescribeTrainingJobOutput {
	s.AlgorithmSpecification = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeTrainingJobOutput) SetCreationTime(v time.Time) *DescribeTrainingJobOutput {
	s.CreationTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *DescribeTrainingJobOutput) SetFailureReason(v string) *DescribeTrainingJobOutput {
	s.FailureReason = &v
	return s
}

// SetHyperParameters sets the HyperParameters field's value.
func (s *DescribeTrainingJobOutput) SetHyperParameters(v map[string]*string) *DescribeTrainingJobOutput {
	s.HyperParameters = v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *DescribeTrainingJobOutput) SetInputDataConfig(v []*Channel) *DescribeTrainingJobOutput {
	s.InputDataConfig = v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *DescribeTrainingJobOutput) SetLastModifiedTime(v time.Time) *DescribeTrainingJobOutput {
	s.LastModifiedTime = &v
	return s
}

// SetModelArtifacts sets the ModelArtifacts field's value.
func (s *DescribeTrainingJobOutput) SetModelArtifacts(v *ModelArtifacts) *DescribeTrainingJobOutput {
	s.ModelArtifacts = v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *DescribeTrainingJobOutput) SetOutputDataConfig(v *OutputDataConfig) *DescribeTrainingJobOutput {
	s.OutputDataConfig = v
	return s
}

// SetResourceConfig sets the ResourceConfig field's value.
func (s *DescribeTrainingJobOutput) SetResourceConfig(v *ResourceConfig) *DescribeTrainingJobOutput {
	s.ResourceConfig = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeTrainingJobOutput) SetRoleArn(v string) *DescribeTrainingJobOutput {
	s.RoleArn = &v
	return s
}

// SetSecondaryStatus sets the SecondaryStatus field's value.
func (s *DescribeTrainingJobOutput) SetSecondaryStatus(v string) *DescribeTrainingJobOutput {
	s.SecondaryStatus = &v
	return s
}

// SetStoppingCondition sets the StoppingCondition field's value.
func (s *DescribeTrainingJobOutput) SetStoppingCondition(v *StoppingCondition) *DescribeTrainingJobOutput {
	s.StoppingCondition = v
	return s
}

// SetTrainingEndTime sets the TrainingEndTime field's value.
func (s *DescribeTrainingJobOutput) SetTrainingEndTime(v time.Time) *DescribeTrainingJobOutput {
	s.TrainingEndTime = &v
	return s
}

// SetTrainingJobArn sets the TrainingJobArn field's value.
func (s *DescribeTrainingJobOutput) SetTrainingJobArn(v string) *DescribeTrainingJobOutput {
	s.TrainingJobArn = &v
	return s
}

// SetTrainingJobName sets the TrainingJobName field's value.
func (s *DescribeTrainingJobOutput) SetTrainingJobName(v string) *DescribeTrainingJobOutput {
	s.TrainingJobName = &v
	return s
}

// SetTrainingJobStatus sets the TrainingJobStatus field's value.
func (s *DescribeTrainingJobOutput) SetTrainingJobStatus(v string) *DescribeTrainingJobOutput {
	s.TrainingJobStatus = &v
	return s
}

// SetTrainingStartTime sets the TrainingStartTime field's value.
func (s *DescribeTrainingJobOutput) SetTrainingStartTime(v time.Time) *DescribeTrainingJobOutput {
	s.TrainingStartTime = &v
	return s
}

// Specifies weight and capacity values for a production variant.
type DesiredWeightAndCapacity struct {
	_ struct{} `type:"structure"`

	// The variant's capacity.
	DesiredInstanceCount *int64 `min:"1" type:"integer"`

	// The variant's weight.
	DesiredWeight *float64 `type:"float"`

	// The name of the variant to update.
	//
	// VariantName is a required field
	VariantName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DesiredWeightAndCapacity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DesiredWeightAndCapacity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DesiredWeightAndCapacity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DesiredWeightAndCapacity"}
	if s.DesiredInstanceCount != nil && *s.DesiredInstanceCount < 1 {
		invalidParams.Add(request.NewErrParamMinValue("DesiredInstanceCount", 1))
	}
	if s.VariantName == nil {
		invalidParams.Add(request.NewErrParamRequired("VariantName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDesiredInstanceCount sets the DesiredInstanceCount field's value.
func (s *DesiredWeightAndCapacity) SetDesiredInstanceCount(v int64) *DesiredWeightAndCapacity {
	s.DesiredInstanceCount = &v
	return s
}

// SetDesiredWeight sets the DesiredWeight field's value.
func (s *DesiredWeightAndCapacity) SetDesiredWeight(v float64) *DesiredWeightAndCapacity {
	s.DesiredWeight = &v
	return s
}

// SetVariantName sets the VariantName field's value.
func (s *DesiredWeightAndCapacity) SetVariantName(v string) *DesiredWeightAndCapacity {
	s.VariantName = &v
	return s
}

// Provides summary information for an endpoint configuration.
type EndpointConfigSummary struct {
	_ struct{} `type:"structure"`

	// A timestamp that shows when the endpoint configuration was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// The Amazon Resource Name (ARN) of the endpoint configuration.
	//
	// EndpointConfigArn is a required field
	EndpointConfigArn *string `min:"20" type:"string" required:"true"`

	// The name of the endpoint configuration.
	//
	// EndpointConfigName is a required field
	EndpointConfigName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s EndpointConfigSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointConfigSummary) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *EndpointConfigSummary) SetCreationTime(v time.Time) *EndpointConfigSummary {
	s.CreationTime = &v
	return s
}

// SetEndpointConfigArn sets the EndpointConfigArn field's value.
func (s *EndpointConfigSummary) SetEndpointConfigArn(v string) *EndpointConfigSummary {
	s.EndpointConfigArn = &v
	return s
}

// SetEndpointConfigName sets the EndpointConfigName field's value.
func (s *EndpointConfigSummary) SetEndpointConfigName(v string) *EndpointConfigSummary {
	s.EndpointConfigName = &v
	return s
}

// Provides summary information for an endpoint.
type EndpointSummary struct {
	_ struct{} `type:"structure"`

	// A timestamp that shows when the endpoint was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// The Amazon Resource Name (ARN) of the endpoint.
	//
	// EndpointArn is a required field
	EndpointArn *string `min:"20" type:"string" required:"true"`

	// The name of the endpoint.
	//
	// EndpointName is a required field
	EndpointName *string `type:"string" required:"true"`

	// The status of the endpoint.
	//
	// EndpointStatus is a required field
	EndpointStatus *string `type:"string" required:"true" enum:"EndpointStatus"`

	// A timestamp that shows when the endpoint was last modified.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`
}

// String returns the string representation
func (s EndpointSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointSummary) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *EndpointSummary) SetCreationTime(v time.Time) *EndpointSummary {
	s.CreationTime = &v
	return s
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *EndpointSummary) SetEndpointArn(v string) *EndpointSummary {
	s.EndpointArn = &v
	return s
}

// SetEndpointName sets the EndpointName field's value.
func (s *EndpointSummary) SetEndpointName(v string) *EndpointSummary {
	s.EndpointName = &v
	return s
}

// SetEndpointStatus sets the EndpointStatus field's value.
func (s *EndpointSummary) SetEndpointStatus(v string) *EndpointSummary {
	s.EndpointStatus = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *EndpointSummary) SetLastModifiedTime(v time.Time) *EndpointSummary {
	s.LastModifiedTime = &v
	return s
}

type ListEndpointConfigsInput struct {
	_ struct{} `type:"structure"`

	// A filter that returns only endpoint configurations created after the specified
	// time (timestamp).
	CreationTimeAfter *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A filter that returns only endpoint configurations created before the specified
	// time (timestamp).
	CreationTimeBefore *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The maximum number of training jobs to return in the response.
	MaxResults *int64 `min:"1" type:"integer"`

	// A string in the endpoint configuration name. This filter returns only endpoint
	// configurations whose name contains the specified string.
	NameContains *string `type:"string"`

	// If the result of the previous ListEndpointConfig request was truncated, the
	// response includes a NextToken. To retrieve the next set of endpoint configurations,
	// use the token in the next request.
	NextToken *string `type:"string"`

	// The field to sort results by. The default is CreationTime.
	SortBy *string `type:"string" enum:"EndpointConfigSortKey"`

	// The sort order for results. The default is Ascending.
	SortOrder *string `type:"string" enum:"OrderKey"`
}

// String returns the string representation
func (s ListEndpointConfigsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEndpointConfigsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEndpointConfigsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEndpointConfigsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreationTimeAfter sets the CreationTimeAfter field's value.
func (s *ListEndpointConfigsInput) SetCreationTimeAfter(v time.Time) *ListEndpointConfigsInput {
	s.CreationTimeAfter = &v
	return s
}

// SetCreationTimeBefore sets the CreationTimeBefore field's value.
func (s *ListEndpointConfigsInput) SetCreationTimeBefore(v time.Time) *ListEndpointConfigsInput {
	s.CreationTimeBefore = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEndpointConfigsInput) SetMaxResults(v int64) *ListEndpointConfigsInput {
	s.MaxResults = &v
	return s
}

// SetNameContains sets the NameContains field's value.
func (s *ListEndpointConfigsInput) SetNameContains(v string) *ListEndpointConfigsInput {
	s.NameContains = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEndpointConfigsInput) SetNextToken(v string) *ListEndpointConfigsInput {
	s.NextToken = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListEndpointConfigsInput) SetSortBy(v string) *ListEndpointConfigsInput {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListEndpointConfigsInput) SetSortOrder(v string) *ListEndpointConfigsInput {
	s.SortOrder = &v
	return s
}

type ListEndpointConfigsOutput struct {
	_ struct{} `type:"structure"`

	// An array of endpoint configurations.
	//
	// EndpointConfigs is a required field
	EndpointConfigs []*EndpointConfigSummary `type:"list" required:"true"`

	// If the response is truncated, Amazon SageMaker returns this token. To retrieve
	// the next set of endpoint configurations, use it in the subsequent request
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListEndpointConfigsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEndpointConfigsOutput) GoString() string {
	return s.String()
}

// SetEndpointConfigs sets the EndpointConfigs field's value.
func (s *ListEndpointConfigsOutput) SetEndpointConfigs(v []*EndpointConfigSummary) *ListEndpointConfigsOutput {
	s.EndpointConfigs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEndpointConfigsOutput) SetNextToken(v string) *ListEndpointConfigsOutput {
	s.NextToken = &v
	return s
}

type ListEndpointsInput struct {
	_ struct{} `type:"structure"`

	// A filter that returns only endpoints that were created after the specified
	// time (timestamp).
	CreationTimeAfter *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A filter that returns only endpoints that were created before the specified
	// time (timestamp).
	CreationTimeBefore *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A filter that returns only endpoints that were modified after the specified
	// timestamp.
	LastModifiedTimeAfter *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A filter that returns only endpoints that were modified before the specified
	// timestamp.
	LastModifiedTimeBefore *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The maximum number of endpoints to return in the response.
	MaxResults *int64 `min:"1" type:"integer"`

	// A string in endpoint names. This filter returns only endpoints whose name
	// contains the specified string.
	NameContains *string `type:"string"`

	// If the result of a ListEndpoints request was truncated, the response includes
	// a NextToken. To retrieve the next set of endpoints, use the token in the
	// next request.
	NextToken *string `type:"string"`

	// Sorts the list of results. The default is CreationTime.
	SortBy *string `type:"string" enum:"EndpointSortKey"`

	// The sort order for results. The default is Ascending.
	SortOrder *string `type:"string" enum:"OrderKey"`

	// A filter that returns only endpoints with the specified status.
	StatusEquals *string `type:"string" enum:"EndpointStatus"`
}

// String returns the string representation
func (s ListEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEndpointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEndpointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEndpointsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreationTimeAfter sets the CreationTimeAfter field's value.
func (s *ListEndpointsInput) SetCreationTimeAfter(v time.Time) *ListEndpointsInput {
	s.CreationTimeAfter = &v
	return s
}

// SetCreationTimeBefore sets the CreationTimeBefore field's value.
func (s *ListEndpointsInput) SetCreationTimeBefore(v time.Time) *ListEndpointsInput {
	s.CreationTimeBefore = &v
	return s
}

// SetLastModifiedTimeAfter sets the LastModifiedTimeAfter field's value.
func (s *ListEndpointsInput) SetLastModifiedTimeAfter(v time.Time) *ListEndpointsInput {
	s.LastModifiedTimeAfter = &v
	return s
}

// SetLastModifiedTimeBefore sets the LastModifiedTimeBefore field's value.
func (s *ListEndpointsInput) SetLastModifiedTimeBefore(v time.Time) *ListEndpointsInput {
	s.LastModifiedTimeBefore = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEndpointsInput) SetMaxResults(v int64) *ListEndpointsInput {
	s.MaxResults = &v
	return s
}

// SetNameContains sets the NameContains field's value.
func (s *ListEndpointsInput) SetNameContains(v string) *ListEndpointsInput {
	s.NameContains = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEndpointsInput) SetNextToken(v string) *ListEndpointsInput {
	s.NextToken = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListEndpointsInput) SetSortBy(v string) *ListEndpointsInput {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListEndpointsInput) SetSortOrder(v string) *ListEndpointsInput {
	s.SortOrder = &v
	return s
}

// SetStatusEquals sets the StatusEquals field's value.
func (s *ListEndpointsInput) SetStatusEquals(v string) *ListEndpointsInput {
	s.StatusEquals = &v
	return s
}

type ListEndpointsOutput struct {
	_ struct{} `type:"structure"`

	// An array or endpoint objects.
	//
	// Endpoints is a required field
	Endpoints []*EndpointSummary `type:"list" required:"true"`

	// If the response is truncated, Amazon SageMaker returns this token. To retrieve
	// the next set of training jobs, use it in the subsequent request.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEndpointsOutput) GoString() string {
	return s.String()
}

// SetEndpoints sets the Endpoints field's value.
func (s *ListEndpointsOutput) SetEndpoints(v []*EndpointSummary) *ListEndpointsOutput {
	s.Endpoints = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEndpointsOutput) SetNextToken(v string) *ListEndpointsOutput {
	s.NextToken = &v
	return s
}

type ListModelsInput struct {
	_ struct{} `type:"structure"`

	// A filter that returns only models created after the specified time (timestamp).
	CreationTimeAfter *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A filter that returns only models created before the specified time (timestamp).
	CreationTimeBefore *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The maximum number of models to return in the response.
	MaxResults *int64 `min:"1" type:"integer"`

	// A string in the training job name. This filter returns only models in the
	// training job whose name contains the specified string.
	NameContains *string `type:"string"`

	// If the response to a previous ListModels request was truncated, the response
	// includes a NextToken. To retrieve the next set of models, use the token in
	// the next request.
	NextToken *string `type:"string"`

	// Sorts the list of results. The default is CreationTime.
	SortBy *string `type:"string" enum:"ModelSortKey"`

	// The sort order for results. The default is Ascending.
	SortOrder *string `type:"string" enum:"OrderKey"`
}

// String returns the string representation
func (s ListModelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListModelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListModelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListModelsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreationTimeAfter sets the CreationTimeAfter field's value.
func (s *ListModelsInput) SetCreationTimeAfter(v time.Time) *ListModelsInput {
	s.CreationTimeAfter = &v
	return s
}

// SetCreationTimeBefore sets the CreationTimeBefore field's value.
func (s *ListModelsInput) SetCreationTimeBefore(v time.Time) *ListModelsInput {
	s.CreationTimeBefore = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListModelsInput) SetMaxResults(v int64) *ListModelsInput {
	s.MaxResults = &v
	return s
}

// SetNameContains sets the NameContains field's value.
func (s *ListModelsInput) SetNameContains(v string) *ListModelsInput {
	s.NameContains = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListModelsInput) SetNextToken(v string) *ListModelsInput {
	s.NextToken = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListModelsInput) SetSortBy(v string) *ListModelsInput {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListModelsInput) SetSortOrder(v string) *ListModelsInput {
	s.SortOrder = &v
	return s
}

type ListModelsOutput struct {
	_ struct{} `type:"structure"`

	// An array of ModelSummary objects, each of which lists a model.
	//
	// Models is a required field
	Models []*ModelSummary `type:"list" required:"true"`

	// If the response is truncated, Amazon SageMaker returns this token. To retrieve
	// the next set of models, use it in the subsequent request.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListModelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListModelsOutput) GoString() string {
	return s.String()
}

// SetModels sets the Models field's value.
func (s *ListModelsOutput) SetModels(v []*ModelSummary) *ListModelsOutput {
	s.Models = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListModelsOutput) SetNextToken(v string) *ListModelsOutput {
	s.NextToken = &v
	return s
}

type ListNotebookInstanceLifecycleConfigsInput struct {
	_ struct{} `type:"structure"`

	// A filter that returns only lifecycle configurations that were created after
	// the specified time (timestamp).
	CreationTimeAfter *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A filter that returns only lifecycle configurations that were created before
	// the specified time (timestamp).
	CreationTimeBefore *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A filter that returns only lifecycle configurations that were modified after
	// the specified time (timestamp).
	LastModifiedTimeAfter *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A filter that returns only lifecycle configurations that were modified before
	// the specified time (timestamp).
	LastModifiedTimeBefore *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The maximum number of lifecycle configurations to return in the response.
	MaxResults *int64 `min:"1" type:"integer"`

	// A string in the lifecycle configuration name. This filter returns only lifecycle
	// configurations whose name contains the specified string.
	NameContains *string `type:"string"`

	// If the result of a ListNotebookInstanceLifecycleConfigs request was truncated,
	// the response includes a NextToken. To get the next set of lifecycle configurations,
	// use the token in the next request.
	NextToken *string `type:"string"`

	// Sorts the list of results. The default is CreationTime.
	SortBy *string `type:"string" enum:"NotebookInstanceLifecycleConfigSortKey"`

	// The sort order for results.
	SortOrder *string `type:"string" enum:"NotebookInstanceLifecycleConfigSortOrder"`
}

// String returns the string representation
func (s ListNotebookInstanceLifecycleConfigsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListNotebookInstanceLifecycleConfigsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListNotebookInstanceLifecycleConfigsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListNotebookInstanceLifecycleConfigsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreationTimeAfter sets the CreationTimeAfter field's value.
func (s *ListNotebookInstanceLifecycleConfigsInput) SetCreationTimeAfter(v time.Time) *ListNotebookInstanceLifecycleConfigsInput {
	s.CreationTimeAfter = &v
	return s
}

// SetCreationTimeBefore sets the CreationTimeBefore field's value.
func (s *ListNotebookInstanceLifecycleConfigsInput) SetCreationTimeBefore(v time.Time) *ListNotebookInstanceLifecycleConfigsInput {
	s.CreationTimeBefore = &v
	return s
}

// SetLastModifiedTimeAfter sets the LastModifiedTimeAfter field's value.
func (s *ListNotebookInstanceLifecycleConfigsInput) SetLastModifiedTimeAfter(v time.Time) *ListNotebookInstanceLifecycleConfigsInput {
	s.LastModifiedTimeAfter = &v
	return s
}

// SetLastModifiedTimeBefore sets the LastModifiedTimeBefore field's value.
func (s *ListNotebookInstanceLifecycleConfigsInput) SetLastModifiedTimeBefore(v time.Time) *ListNotebookInstanceLifecycleConfigsInput {
	s.LastModifiedTimeBefore = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListNotebookInstanceLifecycleConfigsInput) SetMaxResults(v int64) *ListNotebookInstanceLifecycleConfigsInput {
	s.MaxResults = &v
	return s
}

// SetNameContains sets the NameContains field's value.
func (s *ListNotebookInstanceLifecycleConfigsInput) SetNameContains(v string) *ListNotebookInstanceLifecycleConfigsInput {
	s.NameContains = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListNotebookInstanceLifecycleConfigsInput) SetNextToken(v string) *ListNotebookInstanceLifecycleConfigsInput {
	s.NextToken = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListNotebookInstanceLifecycleConfigsInput) SetSortBy(v string) *ListNotebookInstanceLifecycleConfigsInput {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListNotebookInstanceLifecycleConfigsInput) SetSortOrder(v string) *ListNotebookInstanceLifecycleConfigsInput {
	s.SortOrder = &v
	return s
}

type ListNotebookInstanceLifecycleConfigsOutput struct {
	_ struct{} `type:"structure"`

	// If the response is truncated, Amazon SageMaker returns this token. To get
	// the next set of lifecycle configurations, use it in the next request.
	NextToken *string `type:"string"`

	// An array of NotebookInstanceLifecycleConfiguration objects, each listing
	// a lifecycle configuration.
	NotebookInstanceLifecycleConfigs []*NotebookInstanceLifecycleConfigSummary `type:"list"`
}

// String returns the string representation
func (s ListNotebookInstanceLifecycleConfigsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListNotebookInstanceLifecycleConfigsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListNotebookInstanceLifecycleConfigsOutput) SetNextToken(v string) *ListNotebookInstanceLifecycleConfigsOutput {
	s.NextToken = &v
	return s
}

// SetNotebookInstanceLifecycleConfigs sets the NotebookInstanceLifecycleConfigs field's value.
func (s *ListNotebookInstanceLifecycleConfigsOutput) SetNotebookInstanceLifecycleConfigs(v []*NotebookInstanceLifecycleConfigSummary) *ListNotebookInstanceLifecycleConfigsOutput {
	s.NotebookInstanceLifecycleConfigs = v
	return s
}

type ListNotebookInstancesInput struct {
	_ struct{} `type:"structure"`

	// A filter that returns only notebook instances that were created after the
	// specified time (timestamp).
	CreationTimeAfter *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A filter that returns only notebook instances that were created before the
	// specified time (timestamp).
	CreationTimeBefore *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A filter that returns only notebook instances that were modified after the
	// specified time (timestamp).
	LastModifiedTimeAfter *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A filter that returns only notebook instances that were modified before the
	// specified time (timestamp).
	LastModifiedTimeBefore *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The maximum number of notebook instances to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// A string in the notebook instances' name. This filter returns only notebook
	// instances whose name contains the specified string.
	NameContains *string `type:"string"`

	// If the previous call to the ListNotebookInstances is truncated, the response
	// includes a NextToken. You can use this token in your subsequent ListNotebookInstances
	// request to fetch the next set of notebook instances.
	//
	// You might specify a filter or a sort order in your request. When response
	// is truncated, you must use the same values for the filer and sort order in
	// the next request.
	NextToken *string `type:"string"`

	// A string in the name of a notebook instances lifecycle configuration associated
	// with this notebook instance. This filter returns only notebook instances
	// associated with a lifecycle configuration with a name that contains the specified
	// string.
	NotebookInstanceLifecycleConfigNameContains *string `type:"string"`

	// The field to sort results by. The default is Name.
	SortBy *string `type:"string" enum:"NotebookInstanceSortKey"`

	// The sort order for results.
	SortOrder *string `type:"string" enum:"NotebookInstanceSortOrder"`

	// A filter that returns only notebook instances with the specified status.
	StatusEquals *string `type:"string" enum:"NotebookInstanceStatus"`
}

// String returns the string representation
func (s ListNotebookInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListNotebookInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListNotebookInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListNotebookInstancesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreationTimeAfter sets the CreationTimeAfter field's value.
func (s *ListNotebookInstancesInput) SetCreationTimeAfter(v time.Time) *ListNotebookInstancesInput {
	s.CreationTimeAfter = &v
	return s
}

// SetCreationTimeBefore sets the CreationTimeBefore field's value.
func (s *ListNotebookInstancesInput) SetCreationTimeBefore(v time.Time) *ListNotebookInstancesInput {
	s.CreationTimeBefore = &v
	return s
}

// SetLastModifiedTimeAfter sets the LastModifiedTimeAfter field's value.
func (s *ListNotebookInstancesInput) SetLastModifiedTimeAfter(v time.Time) *ListNotebookInstancesInput {
	s.LastModifiedTimeAfter = &v
	return s
}

// SetLastModifiedTimeBefore sets the LastModifiedTimeBefore field's value.
func (s *ListNotebookInstancesInput) SetLastModifiedTimeBefore(v time.Time) *ListNotebookInstancesInput {
	s.LastModifiedTimeBefore = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListNotebookInstancesInput) SetMaxResults(v int64) *ListNotebookInstancesInput {
	s.MaxResults = &v
	return s
}

// SetNameContains sets the NameContains field's value.
func (s *ListNotebookInstancesInput) SetNameContains(v string) *ListNotebookInstancesInput {
	s.NameContains = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListNotebookInstancesInput) SetNextToken(v string) *ListNotebookInstancesInput {
	s.NextToken = &v
	return s
}

// SetNotebookInstanceLifecycleConfigNameContains sets the NotebookInstanceLifecycleConfigNameContains field's value.
func (s *ListNotebookInstancesInput) SetNotebookInstanceLifecycleConfigNameContains(v string) *ListNotebookInstancesInput {
	s.NotebookInstanceLifecycleConfigNameContains = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListNotebookInstancesInput) SetSortBy(v string) *ListNotebookInstancesInput {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListNotebookInstancesInput) SetSortOrder(v string) *ListNotebookInstancesInput {
	s.SortOrder = &v
	return s
}

// SetStatusEquals sets the StatusEquals field's value.
func (s *ListNotebookInstancesInput) SetStatusEquals(v string) *ListNotebookInstancesInput {
	s.StatusEquals = &v
	return s
}

type ListNotebookInstancesOutput struct {
	_ struct{} `type:"structure"`

	// If the response to the previous ListNotebookInstances request was truncated,
	// Amazon SageMaker returns this token. To retrieve the next set of notebook
	// instances, use the token in the next request.
	NextToken *string `type:"string"`

	// An array of NotebookInstanceSummary objects, one for each notebook instance.
	NotebookInstances []*NotebookInstanceSummary `type:"list"`
}

// String returns the string representation
func (s ListNotebookInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListNotebookInstancesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListNotebookInstancesOutput) SetNextToken(v string) *ListNotebookInstancesOutput {
	s.NextToken = &v
	return s
}

// SetNotebookInstances sets the NotebookInstances field's value.
func (s *ListNotebookInstancesOutput) SetNotebookInstances(v []*NotebookInstanceSummary) *ListNotebookInstancesOutput {
	s.NotebookInstances = v
	return s
}

type ListTagsInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of tags to return.
	MaxResults *int64 `min:"50" type:"integer"`

	// If the response to the previous ListTags request is truncated, Amazon SageMaker
	// returns this token. To retrieve the next set of tags, use it in the subsequent
	// request.
	NextToken *string `type:"string"`

	// The Amazon Resource Name (ARN) of the resource whose tags you want to retrieve.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsInput"}
	if s.MaxResults != nil && *s.MaxResults < 50 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 50))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTagsInput) SetMaxResults(v int64) *ListTagsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsInput) SetNextToken(v string) *ListTagsInput {
	s.NextToken = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsInput) SetResourceArn(v string) *ListTagsInput {
	s.ResourceArn = &v
	return s
}

type ListTagsOutput struct {
	_ struct{} `type:"structure"`

	// If response is truncated, Amazon SageMaker includes a token in the response.
	// You can use this token in your subsequent request to fetch next set of tokens.
	NextToken *string `type:"string"`

	// An array of Tag objects, each with a tag key and a value.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s ListTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsOutput) SetNextToken(v string) *ListTagsOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsOutput) SetTags(v []*Tag) *ListTagsOutput {
	s.Tags = v
	return s
}

type ListTrainingJobsInput struct {
	_ struct{} `type:"structure"`

	// A filter that only training jobs created after the specified time (timestamp).
	CreationTimeAfter *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A filter that returns only training jobs created before the specified time
	// (timestamp).
	CreationTimeBefore *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A filter that returns only training jobs modified after the specified time
	// (timestamp).
	LastModifiedTimeAfter *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A filter that returns only training jobs modified before the specified time
	// (timestamp).
	LastModifiedTimeBefore *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The maximum number of training jobs to return in the response.
	MaxResults *int64 `min:"1" type:"integer"`

	// A string in the training job name. This filter returns only models whose
	// name contains the specified string.
	NameContains *string `type:"string"`

	// If the result of the previous ListTrainingJobs request was truncated, the
	// response includes a NextToken. To retrieve the next set of training jobs,
	// use the token in the next request.
	NextToken *string `type:"string"`

	// The field to sort results by. The default is CreationTime.
	SortBy *string `type:"string" enum:"SortBy"`

	// The sort order for results. The default is Ascending.
	SortOrder *string `type:"string" enum:"SortOrder"`

	// A filter that retrieves only training jobs with a specific status.
	StatusEquals *string `type:"string" enum:"TrainingJobStatus"`
}

// String returns the string representation
func (s ListTrainingJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTrainingJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTrainingJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTrainingJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreationTimeAfter sets the CreationTimeAfter field's value.
func (s *ListTrainingJobsInput) SetCreationTimeAfter(v time.Time) *ListTrainingJobsInput {
	s.CreationTimeAfter = &v
	return s
}

// SetCreationTimeBefore sets the CreationTimeBefore field's value.
func (s *ListTrainingJobsInput) SetCreationTimeBefore(v time.Time) *ListTrainingJobsInput {
	s.CreationTimeBefore = &v
	return s
}

// SetLastModifiedTimeAfter sets the LastModifiedTimeAfter field's value.
func (s *ListTrainingJobsInput) SetLastModifiedTimeAfter(v time.Time) *ListTrainingJobsInput {
	s.LastModifiedTimeAfter = &v
	return s
}

// SetLastModifiedTimeBefore sets the LastModifiedTimeBefore field's value.
func (s *ListTrainingJobsInput) SetLastModifiedTimeBefore(v time.Time) *ListTrainingJobsInput {
	s.LastModifiedTimeBefore = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTrainingJobsInput) SetMaxResults(v int64) *ListTrainingJobsInput {
	s.MaxResults = &v
	return s
}

// SetNameContains sets the NameContains field's value.
func (s *ListTrainingJobsInput) SetNameContains(v string) *ListTrainingJobsInput {
	s.NameContains = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTrainingJobsInput) SetNextToken(v string) *ListTrainingJobsInput {
	s.NextToken = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListTrainingJobsInput) SetSortBy(v string) *ListTrainingJobsInput {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListTrainingJobsInput) SetSortOrder(v string) *ListTrainingJobsInput {
	s.SortOrder = &v
	return s
}

// SetStatusEquals sets the StatusEquals field's value.
func (s *ListTrainingJobsInput) SetStatusEquals(v string) *ListTrainingJobsInput {
	s.StatusEquals = &v
	return s
}

type ListTrainingJobsOutput struct {
	_ struct{} `type:"structure"`

	// If the response is truncated, Amazon SageMaker returns this token. To retrieve
	// the next set of training jobs, use it in the subsequent request.
	NextToken *string `type:"string"`

	// An array of TrainingJobSummary objects, each listing a training job.
	//
	// TrainingJobSummaries is a required field
	TrainingJobSummaries []*TrainingJobSummary `type:"list" required:"true"`
}

// String returns the string representation
func (s ListTrainingJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTrainingJobsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTrainingJobsOutput) SetNextToken(v string) *ListTrainingJobsOutput {
	s.NextToken = &v
	return s
}

// SetTrainingJobSummaries sets the TrainingJobSummaries field's value.
func (s *ListTrainingJobsOutput) SetTrainingJobSummaries(v []*TrainingJobSummary) *ListTrainingJobsOutput {
	s.TrainingJobSummaries = v
	return s
}

// Provides information about the location that is configured for storing model
// artifacts.
type ModelArtifacts struct {
	_ struct{} `type:"structure"`

	// The path of the S3 object that contains the model artifacts. For example,
	// s3://bucket-name/keynameprefix/model.tar.gz.
	//
	// S3ModelArtifacts is a required field
	S3ModelArtifacts *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ModelArtifacts) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModelArtifacts) GoString() string {
	return s.String()
}

// SetS3ModelArtifacts sets the S3ModelArtifacts field's value.
func (s *ModelArtifacts) SetS3ModelArtifacts(v string) *ModelArtifacts {
	s.S3ModelArtifacts = &v
	return s
}

// Provides summary information about a model.
type ModelSummary struct {
	_ struct{} `type:"structure"`

	// A timestamp that indicates when the model was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// The Amazon Resource Name (ARN) of the model.
	//
	// ModelArn is a required field
	ModelArn *string `min:"20" type:"string" required:"true"`

	// The name of the model that you want a summary for.
	//
	// ModelName is a required field
	ModelName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ModelSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModelSummary) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *ModelSummary) SetCreationTime(v time.Time) *ModelSummary {
	s.CreationTime = &v
	return s
}

// SetModelArn sets the ModelArn field's value.
func (s *ModelSummary) SetModelArn(v string) *ModelSummary {
	s.ModelArn = &v
	return s
}

// SetModelName sets the ModelName field's value.
func (s *ModelSummary) SetModelName(v string) *ModelSummary {
	s.ModelName = &v
	return s
}

// Provides a summary of a notebook instance lifecycle configuration.
type NotebookInstanceLifecycleConfigSummary struct {
	_ struct{} `type:"structure"`

	// A timestamp that tells when the lifecycle configuration was created.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A timestamp that tells when the lifecycle configuration was last modified.
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The Amazon Resource Name (ARN) of the lifecycle configuration.
	//
	// NotebookInstanceLifecycleConfigArn is a required field
	NotebookInstanceLifecycleConfigArn *string `type:"string" required:"true"`

	// The name of the lifecycle configuration.
	//
	// NotebookInstanceLifecycleConfigName is a required field
	NotebookInstanceLifecycleConfigName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s NotebookInstanceLifecycleConfigSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotebookInstanceLifecycleConfigSummary) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *NotebookInstanceLifecycleConfigSummary) SetCreationTime(v time.Time) *NotebookInstanceLifecycleConfigSummary {
	s.CreationTime = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *NotebookInstanceLifecycleConfigSummary) SetLastModifiedTime(v time.Time) *NotebookInstanceLifecycleConfigSummary {
	s.LastModifiedTime = &v
	return s
}

// SetNotebookInstanceLifecycleConfigArn sets the NotebookInstanceLifecycleConfigArn field's value.
func (s *NotebookInstanceLifecycleConfigSummary) SetNotebookInstanceLifecycleConfigArn(v string) *NotebookInstanceLifecycleConfigSummary {
	s.NotebookInstanceLifecycleConfigArn = &v
	return s
}

// SetNotebookInstanceLifecycleConfigName sets the NotebookInstanceLifecycleConfigName field's value.
func (s *NotebookInstanceLifecycleConfigSummary) SetNotebookInstanceLifecycleConfigName(v string) *NotebookInstanceLifecycleConfigSummary {
	s.NotebookInstanceLifecycleConfigName = &v
	return s
}

// Contains the notebook instance lifecycle configuration script.
//
// This script runs in the path /sbin:bin:/usr/sbin:/usr/bin.
//
// For information about notebook instance lifestyle configurations, see notebook-lifecycle-config.
type NotebookInstanceLifecycleHook struct {
	_ struct{} `type:"structure"`

	// A base64-encoded string that contains a shell script for a notebook instance
	// lifecycle configuration.
	Content *string `min:"1" type:"string"`
}

// String returns the string representation
func (s NotebookInstanceLifecycleHook) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotebookInstanceLifecycleHook) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NotebookInstanceLifecycleHook) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NotebookInstanceLifecycleHook"}
	if s.Content != nil && len(*s.Content) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Content", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContent sets the Content field's value.
func (s *NotebookInstanceLifecycleHook) SetContent(v string) *NotebookInstanceLifecycleHook {
	s.Content = &v
	return s
}

// Provides summary information for an Amazon SageMaker notebook instance.
type NotebookInstanceSummary struct {
	_ struct{} `type:"structure"`

	// A timestamp that shows when the notebook instance was created.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The type of ML compute instance that the notebook instance is running on.
	InstanceType *string `type:"string" enum:"InstanceType"`

	// A timestamp that shows when the notebook instance was last modified.
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The Amazon Resource Name (ARN) of the notebook instance.
	//
	// NotebookInstanceArn is a required field
	NotebookInstanceArn *string `type:"string" required:"true"`

	// The name of a notebook instance lifecycle configuration associated with this
	// notebook instance.
	//
	// For information about notebook instance lifestyle configurations, see notebook-lifecycle-config.
	NotebookInstanceLifecycleConfigName *string `type:"string"`

	// The name of the notebook instance that you want a summary for.
	//
	// NotebookInstanceName is a required field
	NotebookInstanceName *string `type:"string" required:"true"`

	// The status of the notebook instance.
	NotebookInstanceStatus *string `type:"string" enum:"NotebookInstanceStatus"`

	// The URL that you use to connect to the Jupyter instance running in your notebook
	// instance.
	Url *string `type:"string"`
}

// String returns the string representation
func (s NotebookInstanceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotebookInstanceSummary) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *NotebookInstanceSummary) SetCreationTime(v time.Time) *NotebookInstanceSummary {
	s.CreationTime = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *NotebookInstanceSummary) SetInstanceType(v string) *NotebookInstanceSummary {
	s.InstanceType = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *NotebookInstanceSummary) SetLastModifiedTime(v time.Time) *NotebookInstanceSummary {
	s.LastModifiedTime = &v
	return s
}

// SetNotebookInstanceArn sets the NotebookInstanceArn field's value.
func (s *NotebookInstanceSummary) SetNotebookInstanceArn(v string) *NotebookInstanceSummary {
	s.NotebookInstanceArn = &v
	return s
}

// SetNotebookInstanceLifecycleConfigName sets the NotebookInstanceLifecycleConfigName field's value.
func (s *NotebookInstanceSummary) SetNotebookInstanceLifecycleConfigName(v string) *NotebookInstanceSummary {
	s.NotebookInstanceLifecycleConfigName = &v
	return s
}

// SetNotebookInstanceName sets the NotebookInstanceName field's value.
func (s *NotebookInstanceSummary) SetNotebookInstanceName(v string) *NotebookInstanceSummary {
	s.NotebookInstanceName = &v
	return s
}

// SetNotebookInstanceStatus sets the NotebookInstanceStatus field's value.
func (s *NotebookInstanceSummary) SetNotebookInstanceStatus(v string) *NotebookInstanceSummary {
	s.NotebookInstanceStatus = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *NotebookInstanceSummary) SetUrl(v string) *NotebookInstanceSummary {
	s.Url = &v
	return s
}

// Provides information about how to store model training results (model artifacts).
type OutputDataConfig struct {
	_ struct{} `type:"structure"`

	// The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to
	// encrypt the model artifacts at rest using Amazon S3 server-side encryption.
	//
	// If the configuration of the output S3 bucket requires server-side encryption
	// for objects, and you don't provide the KMS key ID, Amazon SageMaker uses
	// the default service key. For more information, see KMS-Managed Encryption
	// Keys (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html)
	// in Amazon Simple Storage Service developer guide.
	//
	// The KMS key policy must grant permission to the IAM role you specify in your
	// CreateTrainingJob request. Using Key Policies in AWS KMS (http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html)
	// in the AWS Key Management Service Developer Guide.
	KmsKeyId *string `type:"string"`

	// Identifies the S3 path where you want Amazon SageMaker to store the model
	// artifacts. For example, s3://bucket-name/key-name-prefix.
	//
	// S3OutputPath is a required field
	S3OutputPath *string `type:"string" required:"true"`
}

// String returns the string representation
func (s OutputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OutputDataConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputDataConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OutputDataConfig"}
	if s.S3OutputPath == nil {
		invalidParams.Add(request.NewErrParamRequired("S3OutputPath"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *OutputDataConfig) SetKmsKeyId(v string) *OutputDataConfig {
	s.KmsKeyId = &v
	return s
}

// SetS3OutputPath sets the S3OutputPath field's value.
func (s *OutputDataConfig) SetS3OutputPath(v string) *OutputDataConfig {
	s.S3OutputPath = &v
	return s
}

// Identifies a model that you want to host and the resources to deploy for
// hosting it. If you are deploying multiple models, tell Amazon SageMaker how
// to distribute traffic among the models by specifying variant weights.
type ProductionVariant struct {
	_ struct{} `type:"structure"`

	// Number of instances to launch initially.
	//
	// InitialInstanceCount is a required field
	InitialInstanceCount *int64 `min:"1" type:"integer" required:"true"`

	// Determines initial traffic distribution among all of the models that you
	// specify in the endpoint configuration. The traffic to a production variant
	// is determined by the ratio of the VariantWeight to the sum of all VariantWeight
	// values across all ProductionVariants. If unspecified, it defaults to 1.0.
	InitialVariantWeight *float64 `type:"float"`

	// The ML compute instance type.
	//
	// InstanceType is a required field
	InstanceType *string `type:"string" required:"true" enum:"ProductionVariantInstanceType"`

	// The name of the model that you want to host. This is the name that you specified
	// when creating the model.
	//
	// ModelName is a required field
	ModelName *string `type:"string" required:"true"`

	// The name of the production variant.
	//
	// VariantName is a required field
	VariantName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ProductionVariant) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProductionVariant) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProductionVariant) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProductionVariant"}
	if s.InitialInstanceCount == nil {
		invalidParams.Add(request.NewErrParamRequired("InitialInstanceCount"))
	}
	if s.InitialInstanceCount != nil && *s.InitialInstanceCount < 1 {
		invalidParams.Add(request.NewErrParamMinValue("InitialInstanceCount", 1))
	}
	if s.InstanceType == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceType"))
	}
	if s.ModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelName"))
	}
	if s.VariantName == nil {
		invalidParams.Add(request.NewErrParamRequired("VariantName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInitialInstanceCount sets the InitialInstanceCount field's value.
func (s *ProductionVariant) SetInitialInstanceCount(v int64) *ProductionVariant {
	s.InitialInstanceCount = &v
	return s
}

// SetInitialVariantWeight sets the InitialVariantWeight field's value.
func (s *ProductionVariant) SetInitialVariantWeight(v float64) *ProductionVariant {
	s.InitialVariantWeight = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *ProductionVariant) SetInstanceType(v string) *ProductionVariant {
	s.InstanceType = &v
	return s
}

// SetModelName sets the ModelName field's value.
func (s *ProductionVariant) SetModelName(v string) *ProductionVariant {
	s.ModelName = &v
	return s
}

// SetVariantName sets the VariantName field's value.
func (s *ProductionVariant) SetVariantName(v string) *ProductionVariant {
	s.VariantName = &v
	return s
}

// Describes weight and capacities for a production variant associated with
// an endpoint. If you sent a request to the UpdateEndpointWeightsAndCapacities
// API and the endpoint status is Updating, you get different desired and current
// values.
type ProductionVariantSummary struct {
	_ struct{} `type:"structure"`

	// The number of instances associated with the variant.
	CurrentInstanceCount *int64 `min:"1" type:"integer"`

	// The weight associated with the variant.
	CurrentWeight *float64 `type:"float"`

	// The number of instances requested in the UpdateEndpointWeightsAndCapacities
	// request.
	DesiredInstanceCount *int64 `min:"1" type:"integer"`

	// The requested weight, as specified in the UpdateEndpointWeightsAndCapacities
	// request.
	DesiredWeight *float64 `type:"float"`

	// The name of the variant.
	//
	// VariantName is a required field
	VariantName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ProductionVariantSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProductionVariantSummary) GoString() string {
	return s.String()
}

// SetCurrentInstanceCount sets the CurrentInstanceCount field's value.
func (s *ProductionVariantSummary) SetCurrentInstanceCount(v int64) *ProductionVariantSummary {
	s.CurrentInstanceCount = &v
	return s
}

// SetCurrentWeight sets the CurrentWeight field's value.
func (s *ProductionVariantSummary) SetCurrentWeight(v float64) *ProductionVariantSummary {
	s.CurrentWeight = &v
	return s
}

// SetDesiredInstanceCount sets the DesiredInstanceCount field's value.
func (s *ProductionVariantSummary) SetDesiredInstanceCount(v int64) *ProductionVariantSummary {
	s.DesiredInstanceCount = &v
	return s
}

// SetDesiredWeight sets the DesiredWeight field's value.
func (s *ProductionVariantSummary) SetDesiredWeight(v float64) *ProductionVariantSummary {
	s.DesiredWeight = &v
	return s
}

// SetVariantName sets the VariantName field's value.
func (s *ProductionVariantSummary) SetVariantName(v string) *ProductionVariantSummary {
	s.VariantName = &v
	return s
}

// Describes the resources, including ML compute instances and ML storage volumes,
// to use for model training.
type ResourceConfig struct {
	_ struct{} `type:"structure"`

	// The number of ML compute instances to use. For distributed training, provide
	// a value greater than 1.
	//
	// InstanceCount is a required field
	InstanceCount *int64 `min:"1" type:"integer" required:"true"`

	// The ML compute instance type.
	//
	// InstanceType is a required field
	InstanceType *string `type:"string" required:"true" enum:"TrainingInstanceType"`

	// The Amazon Resource Name (ARN) of a AWS Key Management Service key that Amazon
	// SageMaker uses to encrypt data on the storage volume attached to the ML compute
	// instance(s) that run the training job.
	VolumeKmsKeyId *string `type:"string"`

	// The size of the ML storage volume that you want to provision.
	//
	// ML storage volumes store model artifacts and incremental states. Training
	// algorithms might also use the ML storage volume for scratch space. If you
	// want to store the training data in the ML storage volume, choose File as
	// the TrainingInputMode in the algorithm specification.
	//
	// You must specify sufficient ML storage for your scenario.
	//
	// Amazon SageMaker supports only the General Purpose SSD (gp2) ML storage volume
	// type.
	//
	// VolumeSizeInGB is a required field
	VolumeSizeInGB *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s ResourceConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourceConfig"}
	if s.InstanceCount == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceCount"))
	}
	if s.InstanceCount != nil && *s.InstanceCount < 1 {
		invalidParams.Add(request.NewErrParamMinValue("InstanceCount", 1))
	}
	if s.InstanceType == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceType"))
	}
	if s.VolumeSizeInGB == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeSizeInGB"))
	}
	if s.VolumeSizeInGB != nil && *s.VolumeSizeInGB < 1 {
		invalidParams.Add(request.NewErrParamMinValue("VolumeSizeInGB", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceCount sets the InstanceCount field's value.
func (s *ResourceConfig) SetInstanceCount(v int64) *ResourceConfig {
	s.InstanceCount = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *ResourceConfig) SetInstanceType(v string) *ResourceConfig {
	s.InstanceType = &v
	return s
}

// SetVolumeKmsKeyId sets the VolumeKmsKeyId field's value.
func (s *ResourceConfig) SetVolumeKmsKeyId(v string) *ResourceConfig {
	s.VolumeKmsKeyId = &v
	return s
}

// SetVolumeSizeInGB sets the VolumeSizeInGB field's value.
func (s *ResourceConfig) SetVolumeSizeInGB(v int64) *ResourceConfig {
	s.VolumeSizeInGB = &v
	return s
}

// Describes the S3 data source.
type S3DataSource struct {
	_ struct{} `type:"structure"`

	// If you want Amazon SageMaker to replicate the entire dataset on each ML compute
	// instance that is launched for model training, specify FullyReplicated.
	//
	// If you want Amazon SageMaker to replicate a subset of data on each ML compute
	// instance that is launched for model training, specify ShardedByS3Key. If
	// there are n ML compute instances launched for a training job, each instance
	// gets approximately 1/n of the number of S3 objects. In this case, model training
	// on each machine uses only the subset of training data.
	//
	// Don't choose more ML compute instances for training than available S3 objects.
	// If you do, some nodes won't get any data and you will pay for nodes that
	// aren't getting any training data. This applies in both FILE and PIPE modes.
	// Keep this in mind when developing algorithms.
	//
	// In distributed training, where you use multiple ML compute EC2 instances,
	// you might choose ShardedByS3Key. If the algorithm requires copying training
	// data to the ML storage volume (when TrainingInputMode is set to File), this
	// copies 1/n of the number of objects.
	S3DataDistributionType *string `type:"string" enum:"S3DataDistribution"`

	// If you choose S3Prefix, S3Uri identifies a key name prefix. Amazon SageMaker
	// uses all objects with the specified key name prefix for model training.
	//
	// If you choose ManifestFile, S3Uri identifies an object that is a manifest
	// file containing a list of object keys that you want Amazon SageMaker to use
	// for model training.
	//
	// S3DataType is a required field
	S3DataType *string `type:"string" required:"true" enum:"S3DataType"`

	// Depending on the value specified for the S3DataType, identifies either a
	// key name prefix or a manifest. For example:
	//
	//    *  A key name prefix might look like this: s3://bucketname/exampleprefix.
	//
	//
	//    *  A manifest might look like this: s3://bucketname/example.manifest
	//
	//  The manifest is an S3 object which is a JSON file with the following format:
	//
	//
	// [
	//
	//  {"prefix": "s3://customer_bucket/some/prefix/"},
	//
	//  "relative/path/to/custdata-1",
	//
	//  "relative/path/custdata-2",
	//
	//  ...
	//
	//  ]
	//
	//  The preceding JSON matches the following s3Uris:
	//
	// s3://customer_bucket/some/prefix/relative/path/to/custdata-1
	//
	// s3://customer_bucket/some/prefix/relative/path/custdata-1
	//
	// ...
	//
	//  The complete set of s3uris in this manifest constitutes the input data for
	//    the channel for this datasource. The object that each s3uris points to
	//    must readable by the IAM role that Amazon SageMaker uses to perform tasks
	//    on your behalf.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s S3DataSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3DataSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3DataSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3DataSource"}
	if s.S3DataType == nil {
		invalidParams.Add(request.NewErrParamRequired("S3DataType"))
	}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3DataDistributionType sets the S3DataDistributionType field's value.
func (s *S3DataSource) SetS3DataDistributionType(v string) *S3DataSource {
	s.S3DataDistributionType = &v
	return s
}

// SetS3DataType sets the S3DataType field's value.
func (s *S3DataSource) SetS3DataType(v string) *S3DataSource {
	s.S3DataType = &v
	return s
}

// SetS3Uri sets the S3Uri field's value.
func (s *S3DataSource) SetS3Uri(v string) *S3DataSource {
	s.S3Uri = &v
	return s
}

type StartNotebookInstanceInput struct {
	_ struct{} `type:"structure"`

	// The name of the notebook instance to start.
	//
	// NotebookInstanceName is a required field
	NotebookInstanceName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StartNotebookInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartNotebookInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartNotebookInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartNotebookInstanceInput"}
	if s.NotebookInstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("NotebookInstanceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNotebookInstanceName sets the NotebookInstanceName field's value.
func (s *StartNotebookInstanceInput) SetNotebookInstanceName(v string) *StartNotebookInstanceInput {
	s.NotebookInstanceName = &v
	return s
}

type StartNotebookInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StartNotebookInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartNotebookInstanceOutput) GoString() string {
	return s.String()
}

type StopNotebookInstanceInput struct {
	_ struct{} `type:"structure"`

	// The name of the notebook instance to terminate.
	//
	// NotebookInstanceName is a required field
	NotebookInstanceName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StopNotebookInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopNotebookInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopNotebookInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopNotebookInstanceInput"}
	if s.NotebookInstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("NotebookInstanceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNotebookInstanceName sets the NotebookInstanceName field's value.
func (s *StopNotebookInstanceInput) SetNotebookInstanceName(v string) *StopNotebookInstanceInput {
	s.NotebookInstanceName = &v
	return s
}

type StopNotebookInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopNotebookInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopNotebookInstanceOutput) GoString() string {
	return s.String()
}

type StopTrainingJobInput struct {
	_ struct{} `type:"structure"`

	// The name of the training job to stop.
	//
	// TrainingJobName is a required field
	TrainingJobName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopTrainingJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopTrainingJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopTrainingJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopTrainingJobInput"}
	if s.TrainingJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrainingJobName"))
	}
	if s.TrainingJobName != nil && len(*s.TrainingJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrainingJobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTrainingJobName sets the TrainingJobName field's value.
func (s *StopTrainingJobInput) SetTrainingJobName(v string) *StopTrainingJobInput {
	s.TrainingJobName = &v
	return s
}

type StopTrainingJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopTrainingJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopTrainingJobOutput) GoString() string {
	return s.String()
}

// Specifies how long model training can run. When model training reaches the
// limit, Amazon SageMaker ends the training job. Use this API to cap model
// training cost.
//
// To stop a job, Amazon SageMaker sends the algorithm the SIGTERM signal, which
// delays job termination for120 seconds. Algorithms might use this 120-second
// window to save the model artifacts, so the results of training is not lost.
//
// Training algorithms provided by Amazon SageMaker automatically saves the
// intermediate results of a model training job (it is best effort case, as
// model might not be ready to save as some stages, for example training just
// started). This intermediate data is a valid model artifact. You can use it
// to create a model (CreateModel).
type StoppingCondition struct {
	_ struct{} `type:"structure"`

	// The maximum length of time, in seconds, that the training job can run. If
	// model training does not complete during this time, Amazon SageMaker ends
	// the job. If value is not specified, default value is 1 day. Maximum value
	// is 5 days.
	MaxRuntimeInSeconds *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s StoppingCondition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StoppingCondition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StoppingCondition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StoppingCondition"}
	if s.MaxRuntimeInSeconds != nil && *s.MaxRuntimeInSeconds < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxRuntimeInSeconds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxRuntimeInSeconds sets the MaxRuntimeInSeconds field's value.
func (s *StoppingCondition) SetMaxRuntimeInSeconds(v int64) *StoppingCondition {
	s.MaxRuntimeInSeconds = &v
	return s
}

// Describes a tag.
type Tag struct {
	_ struct{} `type:"structure"`

	// The tag key.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The tag value.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// Provides summary information about a training job.
type TrainingJobSummary struct {
	_ struct{} `type:"structure"`

	// A timestamp that shows when the training job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// Timestamp when the training job was last modified.
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A timestamp that shows when the training job ended. This field is set only
	// if the training job has one of the terminal statuses (Completed, Failed,
	// or Stopped).
	TrainingEndTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The Amazon Resource Name (ARN) of the training job.
	//
	// TrainingJobArn is a required field
	TrainingJobArn *string `type:"string" required:"true"`

	// The name of the training job that you want a summary for.
	//
	// TrainingJobName is a required field
	TrainingJobName *string `min:"1" type:"string" required:"true"`

	// The status of the training job.
	//
	// TrainingJobStatus is a required field
	TrainingJobStatus *string `type:"string" required:"true" enum:"TrainingJobStatus"`
}

// String returns the string representation
func (s TrainingJobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrainingJobSummary) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *TrainingJobSummary) SetCreationTime(v time.Time) *TrainingJobSummary {
	s.CreationTime = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *TrainingJobSummary) SetLastModifiedTime(v time.Time) *TrainingJobSummary {
	s.LastModifiedTime = &v
	return s
}

// SetTrainingEndTime sets the TrainingEndTime field's value.
func (s *TrainingJobSummary) SetTrainingEndTime(v time.Time) *TrainingJobSummary {
	s.TrainingEndTime = &v
	return s
}

// SetTrainingJobArn sets the TrainingJobArn field's value.
func (s *TrainingJobSummary) SetTrainingJobArn(v string) *TrainingJobSummary {
	s.TrainingJobArn = &v
	return s
}

// SetTrainingJobName sets the TrainingJobName field's value.
func (s *TrainingJobSummary) SetTrainingJobName(v string) *TrainingJobSummary {
	s.TrainingJobName = &v
	return s
}

// SetTrainingJobStatus sets the TrainingJobStatus field's value.
func (s *TrainingJobSummary) SetTrainingJobStatus(v string) *TrainingJobSummary {
	s.TrainingJobStatus = &v
	return s
}

type UpdateEndpointInput struct {
	_ struct{} `type:"structure"`

	// The name of the new endpoint configuration.
	//
	// EndpointConfigName is a required field
	EndpointConfigName *string `type:"string" required:"true"`

	// The name of the endpoint whose configuration you want to update.
	//
	// EndpointName is a required field
	EndpointName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateEndpointInput"}
	if s.EndpointConfigName == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointConfigName"))
	}
	if s.EndpointName == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointConfigName sets the EndpointConfigName field's value.
func (s *UpdateEndpointInput) SetEndpointConfigName(v string) *UpdateEndpointInput {
	s.EndpointConfigName = &v
	return s
}

// SetEndpointName sets the EndpointName field's value.
func (s *UpdateEndpointInput) SetEndpointName(v string) *UpdateEndpointInput {
	s.EndpointName = &v
	return s
}

type UpdateEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the endpoint.
	//
	// EndpointArn is a required field
	EndpointArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEndpointOutput) GoString() string {
	return s.String()
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *UpdateEndpointOutput) SetEndpointArn(v string) *UpdateEndpointOutput {
	s.EndpointArn = &v
	return s
}

type UpdateEndpointWeightsAndCapacitiesInput struct {
	_ struct{} `type:"structure"`

	// An object that provides new capacity and weight values for a variant.
	//
	// DesiredWeightsAndCapacities is a required field
	DesiredWeightsAndCapacities []*DesiredWeightAndCapacity `min:"1" type:"list" required:"true"`

	// The name of an existing Amazon SageMaker endpoint.
	//
	// EndpointName is a required field
	EndpointName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateEndpointWeightsAndCapacitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEndpointWeightsAndCapacitiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEndpointWeightsAndCapacitiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateEndpointWeightsAndCapacitiesInput"}
	if s.DesiredWeightsAndCapacities == nil {
		invalidParams.Add(request.NewErrParamRequired("DesiredWeightsAndCapacities"))
	}
	if s.DesiredWeightsAndCapacities != nil && len(s.DesiredWeightsAndCapacities) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DesiredWeightsAndCapacities", 1))
	}
	if s.EndpointName == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointName"))
	}
	if s.DesiredWeightsAndCapacities != nil {
		for i, v := range s.DesiredWeightsAndCapacities {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DesiredWeightsAndCapacities", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDesiredWeightsAndCapacities sets the DesiredWeightsAndCapacities field's value.
func (s *UpdateEndpointWeightsAndCapacitiesInput) SetDesiredWeightsAndCapacities(v []*DesiredWeightAndCapacity) *UpdateEndpointWeightsAndCapacitiesInput {
	s.DesiredWeightsAndCapacities = v
	return s
}

// SetEndpointName sets the EndpointName field's value.
func (s *UpdateEndpointWeightsAndCapacitiesInput) SetEndpointName(v string) *UpdateEndpointWeightsAndCapacitiesInput {
	s.EndpointName = &v
	return s
}

type UpdateEndpointWeightsAndCapacitiesOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the updated endpoint.
	//
	// EndpointArn is a required field
	EndpointArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateEndpointWeightsAndCapacitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEndpointWeightsAndCapacitiesOutput) GoString() string {
	return s.String()
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *UpdateEndpointWeightsAndCapacitiesOutput) SetEndpointArn(v string) *UpdateEndpointWeightsAndCapacitiesOutput {
	s.EndpointArn = &v
	return s
}

type UpdateNotebookInstanceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon ML compute instance type.
	InstanceType *string `type:"string" enum:"InstanceType"`

	// The name of the notebook instance to update.
	//
	// NotebookInstanceName is a required field
	NotebookInstanceName *string `type:"string" required:"true"`

	// Amazon Resource Name (ARN) of the IAM role to associate with the instance.
	RoleArn *string `min:"20" type:"string"`
}

// String returns the string representation
func (s UpdateNotebookInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateNotebookInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateNotebookInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateNotebookInstanceInput"}
	if s.NotebookInstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("NotebookInstanceName"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceType sets the InstanceType field's value.
func (s *UpdateNotebookInstanceInput) SetInstanceType(v string) *UpdateNotebookInstanceInput {
	s.InstanceType = &v
	return s
}

// SetNotebookInstanceName sets the NotebookInstanceName field's value.
func (s *UpdateNotebookInstanceInput) SetNotebookInstanceName(v string) *UpdateNotebookInstanceInput {
	s.NotebookInstanceName = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateNotebookInstanceInput) SetRoleArn(v string) *UpdateNotebookInstanceInput {
	s.RoleArn = &v
	return s
}

type UpdateNotebookInstanceLifecycleConfigInput struct {
	_ struct{} `type:"structure"`

	// The name of the lifecycle configuration.
	//
	// NotebookInstanceLifecycleConfigName is a required field
	NotebookInstanceLifecycleConfigName *string `type:"string" required:"true"`

	// The shell script that runs only once, when you create a notebook instance
	OnCreate []*NotebookInstanceLifecycleHook `type:"list"`

	// The shell script that runs every time you start a notebook instance, including
	// when you create the notebook instance.
	OnStart []*NotebookInstanceLifecycleHook `type:"list"`
}

// String returns the string representation
func (s UpdateNotebookInstanceLifecycleConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateNotebookInstanceLifecycleConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateNotebookInstanceLifecycleConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateNotebookInstanceLifecycleConfigInput"}
	if s.NotebookInstanceLifecycleConfigName == nil {
		invalidParams.Add(request.NewErrParamRequired("NotebookInstanceLifecycleConfigName"))
	}
	if s.OnCreate != nil {
		for i, v := range s.OnCreate {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OnCreate", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.OnStart != nil {
		for i, v := range s.OnStart {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OnStart", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNotebookInstanceLifecycleConfigName sets the NotebookInstanceLifecycleConfigName field's value.
func (s *UpdateNotebookInstanceLifecycleConfigInput) SetNotebookInstanceLifecycleConfigName(v string) *UpdateNotebookInstanceLifecycleConfigInput {
	s.NotebookInstanceLifecycleConfigName = &v
	return s
}

// SetOnCreate sets the OnCreate field's value.
func (s *UpdateNotebookInstanceLifecycleConfigInput) SetOnCreate(v []*NotebookInstanceLifecycleHook) *UpdateNotebookInstanceLifecycleConfigInput {
	s.OnCreate = v
	return s
}

// SetOnStart sets the OnStart field's value.
func (s *UpdateNotebookInstanceLifecycleConfigInput) SetOnStart(v []*NotebookInstanceLifecycleHook) *UpdateNotebookInstanceLifecycleConfigInput {
	s.OnStart = v
	return s
}

type UpdateNotebookInstanceLifecycleConfigOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateNotebookInstanceLifecycleConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateNotebookInstanceLifecycleConfigOutput) GoString() string {
	return s.String()
}

type UpdateNotebookInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateNotebookInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateNotebookInstanceOutput) GoString() string {
	return s.String()
}

const (
	// CompressionTypeNone is a CompressionType enum value
	CompressionTypeNone = "None"

	// CompressionTypeGzip is a CompressionType enum value
	CompressionTypeGzip = "Gzip"
)

const (
	// DirectInternetAccessEnabled is a DirectInternetAccess enum value
	DirectInternetAccessEnabled = "Enabled"

	// DirectInternetAccessDisabled is a DirectInternetAccess enum value
	DirectInternetAccessDisabled = "Disabled"
)

const (
	// EndpointConfigSortKeyName is a EndpointConfigSortKey enum value
	EndpointConfigSortKeyName = "Name"

	// EndpointConfigSortKeyCreationTime is a EndpointConfigSortKey enum value
	EndpointConfigSortKeyCreationTime = "CreationTime"
)

const (
	// EndpointSortKeyName is a EndpointSortKey enum value
	EndpointSortKeyName = "Name"

	// EndpointSortKeyCreationTime is a EndpointSortKey enum value
	EndpointSortKeyCreationTime = "CreationTime"

	// EndpointSortKeyStatus is a EndpointSortKey enum value
	EndpointSortKeyStatus = "Status"
)

const (
	// EndpointStatusOutOfService is a EndpointStatus enum value
	EndpointStatusOutOfService = "OutOfService"

	// EndpointStatusCreating is a EndpointStatus enum value
	EndpointStatusCreating = "Creating"

	// EndpointStatusUpdating is a EndpointStatus enum value
	EndpointStatusUpdating = "Updating"

	// EndpointStatusRollingBack is a EndpointStatus enum value
	EndpointStatusRollingBack = "RollingBack"

	// EndpointStatusInService is a EndpointStatus enum value
	EndpointStatusInService = "InService"

	// EndpointStatusDeleting is a EndpointStatus enum value
	EndpointStatusDeleting = "Deleting"

	// EndpointStatusFailed is a EndpointStatus enum value
	EndpointStatusFailed = "Failed"
)

const (
	// InstanceTypeMlT2Medium is a InstanceType enum value
	InstanceTypeMlT2Medium = "ml.t2.medium"

	// InstanceTypeMlM4Xlarge is a InstanceType enum value
	InstanceTypeMlM4Xlarge = "ml.m4.xlarge"

	// InstanceTypeMlP2Xlarge is a InstanceType enum value
	InstanceTypeMlP2Xlarge = "ml.p2.xlarge"

	// InstanceTypeMlP32xlarge is a InstanceType enum value
	InstanceTypeMlP32xlarge = "ml.p3.2xlarge"
)

const (
	// ModelSortKeyName is a ModelSortKey enum value
	ModelSortKeyName = "Name"

	// ModelSortKeyCreationTime is a ModelSortKey enum value
	ModelSortKeyCreationTime = "CreationTime"
)

const (
	// NotebookInstanceLifecycleConfigSortKeyName is a NotebookInstanceLifecycleConfigSortKey enum value
	NotebookInstanceLifecycleConfigSortKeyName = "Name"

	// NotebookInstanceLifecycleConfigSortKeyCreationTime is a NotebookInstanceLifecycleConfigSortKey enum value
	NotebookInstanceLifecycleConfigSortKeyCreationTime = "CreationTime"

	// NotebookInstanceLifecycleConfigSortKeyLastModifiedTime is a NotebookInstanceLifecycleConfigSortKey enum value
	NotebookInstanceLifecycleConfigSortKeyLastModifiedTime = "LastModifiedTime"
)

const (
	// NotebookInstanceLifecycleConfigSortOrderAscending is a NotebookInstanceLifecycleConfigSortOrder enum value
	NotebookInstanceLifecycleConfigSortOrderAscending = "Ascending"

	// NotebookInstanceLifecycleConfigSortOrderDescending is a NotebookInstanceLifecycleConfigSortOrder enum value
	NotebookInstanceLifecycleConfigSortOrderDescending = "Descending"
)

const (
	// NotebookInstanceSortKeyName is a NotebookInstanceSortKey enum value
	NotebookInstanceSortKeyName = "Name"

	// NotebookInstanceSortKeyCreationTime is a NotebookInstanceSortKey enum value
	NotebookInstanceSortKeyCreationTime = "CreationTime"

	// NotebookInstanceSortKeyStatus is a NotebookInstanceSortKey enum value
	NotebookInstanceSortKeyStatus = "Status"
)

const (
	// NotebookInstanceSortOrderAscending is a NotebookInstanceSortOrder enum value
	NotebookInstanceSortOrderAscending = "Ascending"

	// NotebookInstanceSortOrderDescending is a NotebookInstanceSortOrder enum value
	NotebookInstanceSortOrderDescending = "Descending"
)

const (
	// NotebookInstanceStatusPending is a NotebookInstanceStatus enum value
	NotebookInstanceStatusPending = "Pending"

	// NotebookInstanceStatusInService is a NotebookInstanceStatus enum value
	NotebookInstanceStatusInService = "InService"

	// NotebookInstanceStatusStopping is a NotebookInstanceStatus enum value
	NotebookInstanceStatusStopping = "Stopping"

	// NotebookInstanceStatusStopped is a NotebookInstanceStatus enum value
	NotebookInstanceStatusStopped = "Stopped"

	// NotebookInstanceStatusFailed is a NotebookInstanceStatus enum value
	NotebookInstanceStatusFailed = "Failed"

	// NotebookInstanceStatusDeleting is a NotebookInstanceStatus enum value
	NotebookInstanceStatusDeleting = "Deleting"
)

const (
	// OrderKeyAscending is a OrderKey enum value
	OrderKeyAscending = "Ascending"

	// OrderKeyDescending is a OrderKey enum value
	OrderKeyDescending = "Descending"
)

const (
	// ProductionVariantInstanceTypeMlC42xlarge is a ProductionVariantInstanceType enum value
	ProductionVariantInstanceTypeMlC42xlarge = "ml.c4.2xlarge"

	// ProductionVariantInstanceTypeMlC48xlarge is a ProductionVariantInstanceType enum value
	ProductionVariantInstanceTypeMlC48xlarge = "ml.c4.8xlarge"

	// ProductionVariantInstanceTypeMlC4Xlarge is a ProductionVariantInstanceType enum value
	ProductionVariantInstanceTypeMlC4Xlarge = "ml.c4.xlarge"

	// ProductionVariantInstanceTypeMlC52xlarge is a ProductionVariantInstanceType enum value
	ProductionVariantInstanceTypeMlC52xlarge = "ml.c5.2xlarge"

	// ProductionVariantInstanceTypeMlC59xlarge is a ProductionVariantInstanceType enum value
	ProductionVariantInstanceTypeMlC59xlarge = "ml.c5.9xlarge"

	// ProductionVariantInstanceTypeMlC5Xlarge is a ProductionVariantInstanceType enum value
	ProductionVariantInstanceTypeMlC5Xlarge = "ml.c5.xlarge"

	// ProductionVariantInstanceTypeMlM4Xlarge is a ProductionVariantInstanceType enum value
	ProductionVariantInstanceTypeMlM4Xlarge = "ml.m4.xlarge"

	// ProductionVariantInstanceTypeMlP2Xlarge is a ProductionVariantInstanceType enum value
	ProductionVariantInstanceTypeMlP2Xlarge = "ml.p2.xlarge"

	// ProductionVariantInstanceTypeMlP32xlarge is a ProductionVariantInstanceType enum value
	ProductionVariantInstanceTypeMlP32xlarge = "ml.p3.2xlarge"

	// ProductionVariantInstanceTypeMlT2Medium is a ProductionVariantInstanceType enum value
	ProductionVariantInstanceTypeMlT2Medium = "ml.t2.medium"
)

const (
	// RecordWrapperNone is a RecordWrapper enum value
	RecordWrapperNone = "None"

	// RecordWrapperRecordIo is a RecordWrapper enum value
	RecordWrapperRecordIo = "RecordIO"
)

const (
	// S3DataDistributionFullyReplicated is a S3DataDistribution enum value
	S3DataDistributionFullyReplicated = "FullyReplicated"

	// S3DataDistributionShardedByS3key is a S3DataDistribution enum value
	S3DataDistributionShardedByS3key = "ShardedByS3Key"
)

const (
	// S3DataTypeManifestFile is a S3DataType enum value
	S3DataTypeManifestFile = "ManifestFile"

	// S3DataTypeS3prefix is a S3DataType enum value
	S3DataTypeS3prefix = "S3Prefix"
)

const (
	// SecondaryStatusStarting is a SecondaryStatus enum value
	SecondaryStatusStarting = "Starting"

	// SecondaryStatusDownloading is a SecondaryStatus enum value
	SecondaryStatusDownloading = "Downloading"

	// SecondaryStatusTraining is a SecondaryStatus enum value
	SecondaryStatusTraining = "Training"

	// SecondaryStatusUploading is a SecondaryStatus enum value
	SecondaryStatusUploading = "Uploading"

	// SecondaryStatusStopping is a SecondaryStatus enum value
	SecondaryStatusStopping = "Stopping"

	// SecondaryStatusStopped is a SecondaryStatus enum value
	SecondaryStatusStopped = "Stopped"

	// SecondaryStatusMaxRuntimeExceeded is a SecondaryStatus enum value
	SecondaryStatusMaxRuntimeExceeded = "MaxRuntimeExceeded"

	// SecondaryStatusCompleted is a SecondaryStatus enum value
	SecondaryStatusCompleted = "Completed"

	// SecondaryStatusFailed is a SecondaryStatus enum value
	SecondaryStatusFailed = "Failed"
)

const (
	// SortByName is a SortBy enum value
	SortByName = "Name"

	// SortByCreationTime is a SortBy enum value
	SortByCreationTime = "CreationTime"

	// SortByStatus is a SortBy enum value
	SortByStatus = "Status"
)

const (
	// SortOrderAscending is a SortOrder enum value
	SortOrderAscending = "Ascending"

	// SortOrderDescending is a SortOrder enum value
	SortOrderDescending = "Descending"
)

const (
	// TrainingInputModePipe is a TrainingInputMode enum value
	TrainingInputModePipe = "Pipe"

	// TrainingInputModeFile is a TrainingInputMode enum value
	TrainingInputModeFile = "File"
)

const (
	// TrainingInstanceTypeMlM4Xlarge is a TrainingInstanceType enum value
	TrainingInstanceTypeMlM4Xlarge = "ml.m4.xlarge"

	// TrainingInstanceTypeMlM44xlarge is a TrainingInstanceType enum value
	TrainingInstanceTypeMlM44xlarge = "ml.m4.4xlarge"

	// TrainingInstanceTypeMlM410xlarge is a TrainingInstanceType enum value
	TrainingInstanceTypeMlM410xlarge = "ml.m4.10xlarge"

	// TrainingInstanceTypeMlC4Xlarge is a TrainingInstanceType enum value
	TrainingInstanceTypeMlC4Xlarge = "ml.c4.xlarge"

	// TrainingInstanceTypeMlC42xlarge is a TrainingInstanceType enum value
	TrainingInstanceTypeMlC42xlarge = "ml.c4.2xlarge"

	// TrainingInstanceTypeMlC48xlarge is a TrainingInstanceType enum value
	TrainingInstanceTypeMlC48xlarge = "ml.c4.8xlarge"

	// TrainingInstanceTypeMlP2Xlarge is a TrainingInstanceType enum value
	TrainingInstanceTypeMlP2Xlarge = "ml.p2.xlarge"

	// TrainingInstanceTypeMlP28xlarge is a TrainingInstanceType enum value
	TrainingInstanceTypeMlP28xlarge = "ml.p2.8xlarge"

	// TrainingInstanceTypeMlP216xlarge is a TrainingInstanceType enum value
	TrainingInstanceTypeMlP216xlarge = "ml.p2.16xlarge"

	// TrainingInstanceTypeMlP32xlarge is a TrainingInstanceType enum value
	TrainingInstanceTypeMlP32xlarge = "ml.p3.2xlarge"

	// TrainingInstanceTypeMlP38xlarge is a TrainingInstanceType enum value
	TrainingInstanceTypeMlP38xlarge = "ml.p3.8xlarge"

	// TrainingInstanceTypeMlP316xlarge is a TrainingInstanceType enum value
	TrainingInstanceTypeMlP316xlarge = "ml.p3.16xlarge"

	// TrainingInstanceTypeMlC5Xlarge is a TrainingInstanceType enum value
	TrainingInstanceTypeMlC5Xlarge = "ml.c5.xlarge"

	// TrainingInstanceTypeMlC52xlarge is a TrainingInstanceType enum value
	TrainingInstanceTypeMlC52xlarge = "ml.c5.2xlarge"

	// TrainingInstanceTypeMlC54xlarge is a TrainingInstanceType enum value
	TrainingInstanceTypeMlC54xlarge = "ml.c5.4xlarge"

	// TrainingInstanceTypeMlC59xlarge is a TrainingInstanceType enum value
	TrainingInstanceTypeMlC59xlarge = "ml.c5.9xlarge"

	// TrainingInstanceTypeMlC518xlarge is a TrainingInstanceType enum value
	TrainingInstanceTypeMlC518xlarge = "ml.c5.18xlarge"
)

const (
	// TrainingJobStatusInProgress is a TrainingJobStatus enum value
	TrainingJobStatusInProgress = "InProgress"

	// TrainingJobStatusCompleted is a TrainingJobStatus enum value
	TrainingJobStatusCompleted = "Completed"

	// TrainingJobStatusFailed is a TrainingJobStatus enum value
	TrainingJobStatusFailed = "Failed"

	// TrainingJobStatusStopping is a TrainingJobStatus enum value
	TrainingJobStatusStopping = "Stopping"

	// TrainingJobStatusStopped is a TrainingJobStatus enum value
	TrainingJobStatusStopped = "Stopped"
)
