// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package guardduty

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAcceptInvitation = "AcceptInvitation"

// AcceptInvitationRequest generates a "aws/request.Request" representing the
// client's request for the AcceptInvitation operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptInvitation for more information on using the AcceptInvitation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AcceptInvitationRequest method.
//    req, resp := client.AcceptInvitationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/AcceptInvitation
func (c *GuardDuty) AcceptInvitationRequest(input *AcceptInvitationInput) (req *request.Request, output *AcceptInvitationOutput) {
	op := &request.Operation{
		Name:       opAcceptInvitation,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/master",
	}

	if input == nil {
		input = &AcceptInvitationInput{}
	}

	output = &AcceptInvitationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AcceptInvitation API operation for Amazon GuardDuty.
//
// Accepts the invitation to be monitored by a master GuardDuty account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation AcceptInvitation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Error response object.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Error response object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/AcceptInvitation
func (c *GuardDuty) AcceptInvitation(input *AcceptInvitationInput) (*AcceptInvitationOutput, error) {
	req, out := c.AcceptInvitationRequest(input)
	return out, req.Send()
}

// AcceptInvitationWithContext is the same as AcceptInvitation with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptInvitation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) AcceptInvitationWithContext(ctx aws.Context, input *AcceptInvitationInput, opts ...request.Option) (*AcceptInvitationOutput, error) {
	req, out := c.AcceptInvitationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opArchiveFindings = "ArchiveFindings"

// ArchiveFindingsRequest generates a "aws/request.Request" representing the
// client's request for the ArchiveFindings operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ArchiveFindings for more information on using the ArchiveFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ArchiveFindingsRequest method.
//    req, resp := client.ArchiveFindingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ArchiveFindings
func (c *GuardDuty) ArchiveFindingsRequest(input *ArchiveFindingsInput) (req *request.Request, output *ArchiveFindingsOutput) {
	op := &request.Operation{
		Name:       opArchiveFindings,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/findings/archive",
	}

	if input == nil {
		input = &ArchiveFindingsInput{}
	}

	output = &ArchiveFindingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ArchiveFindings API operation for Amazon GuardDuty.
//
// Archives Amazon GuardDuty findings specified by the list of finding IDs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation ArchiveFindings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Error response object.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Error response object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ArchiveFindings
func (c *GuardDuty) ArchiveFindings(input *ArchiveFindingsInput) (*ArchiveFindingsOutput, error) {
	req, out := c.ArchiveFindingsRequest(input)
	return out, req.Send()
}

// ArchiveFindingsWithContext is the same as ArchiveFindings with the addition of
// the ability to pass a context and additional request options.
//
// See ArchiveFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) ArchiveFindingsWithContext(ctx aws.Context, input *ArchiveFindingsInput, opts ...request.Option) (*ArchiveFindingsOutput, error) {
	req, out := c.ArchiveFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDetector = "CreateDetector"

// CreateDetectorRequest generates a "aws/request.Request" representing the
// client's request for the CreateDetector operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDetector for more information on using the CreateDetector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDetectorRequest method.
//    req, resp := client.CreateDetectorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateDetector
func (c *GuardDuty) CreateDetectorRequest(input *CreateDetectorInput) (req *request.Request, output *CreateDetectorOutput) {
	op := &request.Operation{
		Name:       opCreateDetector,
		HTTPMethod: "POST",
		HTTPPath:   "/detector",
	}

	if input == nil {
		input = &CreateDetectorInput{}
	}

	output = &CreateDetectorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDetector API operation for Amazon GuardDuty.
//
// Creates a single Amazon GuardDuty detector. A detector is an object that
// represents the GuardDuty service. A detector must be created in order for
// GuardDuty to become operational.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation CreateDetector for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Error response object.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Error response object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateDetector
func (c *GuardDuty) CreateDetector(input *CreateDetectorInput) (*CreateDetectorOutput, error) {
	req, out := c.CreateDetectorRequest(input)
	return out, req.Send()
}

// CreateDetectorWithContext is the same as CreateDetector with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDetector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) CreateDetectorWithContext(ctx aws.Context, input *CreateDetectorInput, opts ...request.Option) (*CreateDetectorOutput, error) {
	req, out := c.CreateDetectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateIPSet = "CreateIPSet"

// CreateIPSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateIPSet operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateIPSet for more information on using the CreateIPSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateIPSetRequest method.
//    req, resp := client.CreateIPSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateIPSet
func (c *GuardDuty) CreateIPSetRequest(input *CreateIPSetInput) (req *request.Request, output *CreateIPSetOutput) {
	op := &request.Operation{
		Name:       opCreateIPSet,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/ipset",
	}

	if input == nil {
		input = &CreateIPSetInput{}
	}

	output = &CreateIPSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIPSet API operation for Amazon GuardDuty.
//
// Creates a new IPSet - a list of trusted IP addresses that have been whitelisted
// for secure communication with AWS infrastructure and applications.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation CreateIPSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Error response object.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Error response object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateIPSet
func (c *GuardDuty) CreateIPSet(input *CreateIPSetInput) (*CreateIPSetOutput, error) {
	req, out := c.CreateIPSetRequest(input)
	return out, req.Send()
}

// CreateIPSetWithContext is the same as CreateIPSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIPSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) CreateIPSetWithContext(ctx aws.Context, input *CreateIPSetInput, opts ...request.Option) (*CreateIPSetOutput, error) {
	req, out := c.CreateIPSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMembers = "CreateMembers"

// CreateMembersRequest generates a "aws/request.Request" representing the
// client's request for the CreateMembers operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMembers for more information on using the CreateMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateMembersRequest method.
//    req, resp := client.CreateMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateMembers
func (c *GuardDuty) CreateMembersRequest(input *CreateMembersInput) (req *request.Request, output *CreateMembersOutput) {
	op := &request.Operation{
		Name:       opCreateMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/member",
	}

	if input == nil {
		input = &CreateMembersInput{}
	}

	output = &CreateMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMembers API operation for Amazon GuardDuty.
//
// Creates member accounts of the current AWS account by specifying a list of
// AWS account IDs. The current AWS account can then invite these members to
// manage GuardDuty in their accounts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation CreateMembers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Error response object.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Error response object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateMembers
func (c *GuardDuty) CreateMembers(input *CreateMembersInput) (*CreateMembersOutput, error) {
	req, out := c.CreateMembersRequest(input)
	return out, req.Send()
}

// CreateMembersWithContext is the same as CreateMembers with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) CreateMembersWithContext(ctx aws.Context, input *CreateMembersInput, opts ...request.Option) (*CreateMembersOutput, error) {
	req, out := c.CreateMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSampleFindings = "CreateSampleFindings"

// CreateSampleFindingsRequest generates a "aws/request.Request" representing the
// client's request for the CreateSampleFindings operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSampleFindings for more information on using the CreateSampleFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSampleFindingsRequest method.
//    req, resp := client.CreateSampleFindingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateSampleFindings
func (c *GuardDuty) CreateSampleFindingsRequest(input *CreateSampleFindingsInput) (req *request.Request, output *CreateSampleFindingsOutput) {
	op := &request.Operation{
		Name:       opCreateSampleFindings,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/findings/create",
	}

	if input == nil {
		input = &CreateSampleFindingsInput{}
	}

	output = &CreateSampleFindingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSampleFindings API operation for Amazon GuardDuty.
//
// Generates example findings of types specified by the list of finding types.
// If 'NULL' is specified for findingTypes, the API generates example findings
// of all supported finding types.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation CreateSampleFindings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Error response object.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Error response object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateSampleFindings
func (c *GuardDuty) CreateSampleFindings(input *CreateSampleFindingsInput) (*CreateSampleFindingsOutput, error) {
	req, out := c.CreateSampleFindingsRequest(input)
	return out, req.Send()
}

// CreateSampleFindingsWithContext is the same as CreateSampleFindings with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSampleFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) CreateSampleFindingsWithContext(ctx aws.Context, input *CreateSampleFindingsInput, opts ...request.Option) (*CreateSampleFindingsOutput, error) {
	req, out := c.CreateSampleFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateThreatIntelSet = "CreateThreatIntelSet"

// CreateThreatIntelSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateThreatIntelSet operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateThreatIntelSet for more information on using the CreateThreatIntelSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateThreatIntelSetRequest method.
//    req, resp := client.CreateThreatIntelSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateThreatIntelSet
func (c *GuardDuty) CreateThreatIntelSetRequest(input *CreateThreatIntelSetInput) (req *request.Request, output *CreateThreatIntelSetOutput) {
	op := &request.Operation{
		Name:       opCreateThreatIntelSet,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/threatintelset",
	}

	if input == nil {
		input = &CreateThreatIntelSetInput{}
	}

	output = &CreateThreatIntelSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateThreatIntelSet API operation for Amazon GuardDuty.
//
// Create a new ThreatIntelSet. ThreatIntelSets consist of known malicious IP
// addresses. GuardDuty generates findings based on ThreatIntelSets.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation CreateThreatIntelSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Error response object.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Error response object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateThreatIntelSet
func (c *GuardDuty) CreateThreatIntelSet(input *CreateThreatIntelSetInput) (*CreateThreatIntelSetOutput, error) {
	req, out := c.CreateThreatIntelSetRequest(input)
	return out, req.Send()
}

// CreateThreatIntelSetWithContext is the same as CreateThreatIntelSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateThreatIntelSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) CreateThreatIntelSetWithContext(ctx aws.Context, input *CreateThreatIntelSetInput, opts ...request.Option) (*CreateThreatIntelSetOutput, error) {
	req, out := c.CreateThreatIntelSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeclineInvitations = "DeclineInvitations"

// DeclineInvitationsRequest generates a "aws/request.Request" representing the
// client's request for the DeclineInvitations operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeclineInvitations for more information on using the DeclineInvitations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeclineInvitationsRequest method.
//    req, resp := client.DeclineInvitationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeclineInvitations
func (c *GuardDuty) DeclineInvitationsRequest(input *DeclineInvitationsInput) (req *request.Request, output *DeclineInvitationsOutput) {
	op := &request.Operation{
		Name:       opDeclineInvitations,
		HTTPMethod: "POST",
		HTTPPath:   "/invitation/decline",
	}

	if input == nil {
		input = &DeclineInvitationsInput{}
	}

	output = &DeclineInvitationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeclineInvitations API operation for Amazon GuardDuty.
//
// Declines invitations sent to the current member account by AWS account specified
// by their account IDs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation DeclineInvitations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Error response object.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Error response object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeclineInvitations
func (c *GuardDuty) DeclineInvitations(input *DeclineInvitationsInput) (*DeclineInvitationsOutput, error) {
	req, out := c.DeclineInvitationsRequest(input)
	return out, req.Send()
}

// DeclineInvitationsWithContext is the same as DeclineInvitations with the addition of
// the ability to pass a context and additional request options.
//
// See DeclineInvitations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) DeclineInvitationsWithContext(ctx aws.Context, input *DeclineInvitationsInput, opts ...request.Option) (*DeclineInvitationsOutput, error) {
	req, out := c.DeclineInvitationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDetector = "DeleteDetector"

// DeleteDetectorRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDetector operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDetector for more information on using the DeleteDetector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDetectorRequest method.
//    req, resp := client.DeleteDetectorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteDetector
func (c *GuardDuty) DeleteDetectorRequest(input *DeleteDetectorInput) (req *request.Request, output *DeleteDetectorOutput) {
	op := &request.Operation{
		Name:       opDeleteDetector,
		HTTPMethod: "DELETE",
		HTTPPath:   "/detector/{detectorId}",
	}

	if input == nil {
		input = &DeleteDetectorInput{}
	}

	output = &DeleteDetectorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDetector API operation for Amazon GuardDuty.
//
// Deletes a Amazon GuardDuty detector specified by the detector ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation DeleteDetector for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Error response object.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Error response object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteDetector
func (c *GuardDuty) DeleteDetector(input *DeleteDetectorInput) (*DeleteDetectorOutput, error) {
	req, out := c.DeleteDetectorRequest(input)
	return out, req.Send()
}

// DeleteDetectorWithContext is the same as DeleteDetector with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDetector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) DeleteDetectorWithContext(ctx aws.Context, input *DeleteDetectorInput, opts ...request.Option) (*DeleteDetectorOutput, error) {
	req, out := c.DeleteDetectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIPSet = "DeleteIPSet"

// DeleteIPSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIPSet operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIPSet for more information on using the DeleteIPSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteIPSetRequest method.
//    req, resp := client.DeleteIPSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteIPSet
func (c *GuardDuty) DeleteIPSetRequest(input *DeleteIPSetInput) (req *request.Request, output *DeleteIPSetOutput) {
	op := &request.Operation{
		Name:       opDeleteIPSet,
		HTTPMethod: "DELETE",
		HTTPPath:   "/detector/{detectorId}/ipset/{ipSetId}",
	}

	if input == nil {
		input = &DeleteIPSetInput{}
	}

	output = &DeleteIPSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteIPSet API operation for Amazon GuardDuty.
//
// Deletes the IPSet specified by the IPSet ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation DeleteIPSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Error response object.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Error response object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteIPSet
func (c *GuardDuty) DeleteIPSet(input *DeleteIPSetInput) (*DeleteIPSetOutput, error) {
	req, out := c.DeleteIPSetRequest(input)
	return out, req.Send()
}

// DeleteIPSetWithContext is the same as DeleteIPSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIPSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) DeleteIPSetWithContext(ctx aws.Context, input *DeleteIPSetInput, opts ...request.Option) (*DeleteIPSetOutput, error) {
	req, out := c.DeleteIPSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInvitations = "DeleteInvitations"

// DeleteInvitationsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInvitations operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInvitations for more information on using the DeleteInvitations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteInvitationsRequest method.
//    req, resp := client.DeleteInvitationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteInvitations
func (c *GuardDuty) DeleteInvitationsRequest(input *DeleteInvitationsInput) (req *request.Request, output *DeleteInvitationsOutput) {
	op := &request.Operation{
		Name:       opDeleteInvitations,
		HTTPMethod: "POST",
		HTTPPath:   "/invitation/delete",
	}

	if input == nil {
		input = &DeleteInvitationsInput{}
	}

	output = &DeleteInvitationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteInvitations API operation for Amazon GuardDuty.
//
// Deletes invitations sent to the current member account by AWS accounts specified
// by their account IDs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation DeleteInvitations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Error response object.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Error response object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteInvitations
func (c *GuardDuty) DeleteInvitations(input *DeleteInvitationsInput) (*DeleteInvitationsOutput, error) {
	req, out := c.DeleteInvitationsRequest(input)
	return out, req.Send()
}

// DeleteInvitationsWithContext is the same as DeleteInvitations with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInvitations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) DeleteInvitationsWithContext(ctx aws.Context, input *DeleteInvitationsInput, opts ...request.Option) (*DeleteInvitationsOutput, error) {
	req, out := c.DeleteInvitationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMembers = "DeleteMembers"

// DeleteMembersRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMembers operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMembers for more information on using the DeleteMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteMembersRequest method.
//    req, resp := client.DeleteMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteMembers
func (c *GuardDuty) DeleteMembersRequest(input *DeleteMembersInput) (req *request.Request, output *DeleteMembersOutput) {
	op := &request.Operation{
		Name:       opDeleteMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/member/delete",
	}

	if input == nil {
		input = &DeleteMembersInput{}
	}

	output = &DeleteMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteMembers API operation for Amazon GuardDuty.
//
// Deletes GuardDuty member accounts (to the current GuardDuty master account)
// specified by the account IDs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation DeleteMembers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Error response object.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Error response object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteMembers
func (c *GuardDuty) DeleteMembers(input *DeleteMembersInput) (*DeleteMembersOutput, error) {
	req, out := c.DeleteMembersRequest(input)
	return out, req.Send()
}

// DeleteMembersWithContext is the same as DeleteMembers with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) DeleteMembersWithContext(ctx aws.Context, input *DeleteMembersInput, opts ...request.Option) (*DeleteMembersOutput, error) {
	req, out := c.DeleteMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteThreatIntelSet = "DeleteThreatIntelSet"

// DeleteThreatIntelSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteThreatIntelSet operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteThreatIntelSet for more information on using the DeleteThreatIntelSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteThreatIntelSetRequest method.
//    req, resp := client.DeleteThreatIntelSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteThreatIntelSet
func (c *GuardDuty) DeleteThreatIntelSetRequest(input *DeleteThreatIntelSetInput) (req *request.Request, output *DeleteThreatIntelSetOutput) {
	op := &request.Operation{
		Name:       opDeleteThreatIntelSet,
		HTTPMethod: "DELETE",
		HTTPPath:   "/detector/{detectorId}/threatintelset/{threatIntelSetId}",
	}

	if input == nil {
		input = &DeleteThreatIntelSetInput{}
	}

	output = &DeleteThreatIntelSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteThreatIntelSet API operation for Amazon GuardDuty.
//
// Deletes ThreatIntelSet specified by the ThreatIntelSet ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation DeleteThreatIntelSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Error response object.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Error response object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteThreatIntelSet
func (c *GuardDuty) DeleteThreatIntelSet(input *DeleteThreatIntelSetInput) (*DeleteThreatIntelSetOutput, error) {
	req, out := c.DeleteThreatIntelSetRequest(input)
	return out, req.Send()
}

// DeleteThreatIntelSetWithContext is the same as DeleteThreatIntelSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteThreatIntelSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) DeleteThreatIntelSetWithContext(ctx aws.Context, input *DeleteThreatIntelSetInput, opts ...request.Option) (*DeleteThreatIntelSetOutput, error) {
	req, out := c.DeleteThreatIntelSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateFromMasterAccount = "DisassociateFromMasterAccount"

// DisassociateFromMasterAccountRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateFromMasterAccount operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateFromMasterAccount for more information on using the DisassociateFromMasterAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateFromMasterAccountRequest method.
//    req, resp := client.DisassociateFromMasterAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DisassociateFromMasterAccount
func (c *GuardDuty) DisassociateFromMasterAccountRequest(input *DisassociateFromMasterAccountInput) (req *request.Request, output *DisassociateFromMasterAccountOutput) {
	op := &request.Operation{
		Name:       opDisassociateFromMasterAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/master/disassociate",
	}

	if input == nil {
		input = &DisassociateFromMasterAccountInput{}
	}

	output = &DisassociateFromMasterAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateFromMasterAccount API operation for Amazon GuardDuty.
//
// Disassociates the current GuardDuty member account from its master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation DisassociateFromMasterAccount for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Error response object.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Error response object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DisassociateFromMasterAccount
func (c *GuardDuty) DisassociateFromMasterAccount(input *DisassociateFromMasterAccountInput) (*DisassociateFromMasterAccountOutput, error) {
	req, out := c.DisassociateFromMasterAccountRequest(input)
	return out, req.Send()
}

// DisassociateFromMasterAccountWithContext is the same as DisassociateFromMasterAccount with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateFromMasterAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) DisassociateFromMasterAccountWithContext(ctx aws.Context, input *DisassociateFromMasterAccountInput, opts ...request.Option) (*DisassociateFromMasterAccountOutput, error) {
	req, out := c.DisassociateFromMasterAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateMembers = "DisassociateMembers"

// DisassociateMembersRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateMembers operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateMembers for more information on using the DisassociateMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateMembersRequest method.
//    req, resp := client.DisassociateMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DisassociateMembers
func (c *GuardDuty) DisassociateMembersRequest(input *DisassociateMembersInput) (req *request.Request, output *DisassociateMembersOutput) {
	op := &request.Operation{
		Name:       opDisassociateMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/member/disassociate",
	}

	if input == nil {
		input = &DisassociateMembersInput{}
	}

	output = &DisassociateMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateMembers API operation for Amazon GuardDuty.
//
// Disassociates GuardDuty member accounts (to the current GuardDuty master
// account) specified by the account IDs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation DisassociateMembers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Error response object.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Error response object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DisassociateMembers
func (c *GuardDuty) DisassociateMembers(input *DisassociateMembersInput) (*DisassociateMembersOutput, error) {
	req, out := c.DisassociateMembersRequest(input)
	return out, req.Send()
}

// DisassociateMembersWithContext is the same as DisassociateMembers with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) DisassociateMembersWithContext(ctx aws.Context, input *DisassociateMembersInput, opts ...request.Option) (*DisassociateMembersOutput, error) {
	req, out := c.DisassociateMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDetector = "GetDetector"

// GetDetectorRequest generates a "aws/request.Request" representing the
// client's request for the GetDetector operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDetector for more information on using the GetDetector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDetectorRequest method.
//    req, resp := client.GetDetectorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetDetector
func (c *GuardDuty) GetDetectorRequest(input *GetDetectorInput) (req *request.Request, output *GetDetectorOutput) {
	op := &request.Operation{
		Name:       opGetDetector,
		HTTPMethod: "GET",
		HTTPPath:   "/detector/{detectorId}",
	}

	if input == nil {
		input = &GetDetectorInput{}
	}

	output = &GetDetectorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDetector API operation for Amazon GuardDuty.
//
// Retrieves an Amazon GuardDuty detector specified by the detectorId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation GetDetector for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Error response object.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Error response object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetDetector
func (c *GuardDuty) GetDetector(input *GetDetectorInput) (*GetDetectorOutput, error) {
	req, out := c.GetDetectorRequest(input)
	return out, req.Send()
}

// GetDetectorWithContext is the same as GetDetector with the addition of
// the ability to pass a context and additional request options.
//
// See GetDetector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) GetDetectorWithContext(ctx aws.Context, input *GetDetectorInput, opts ...request.Option) (*GetDetectorOutput, error) {
	req, out := c.GetDetectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFindings = "GetFindings"

// GetFindingsRequest generates a "aws/request.Request" representing the
// client's request for the GetFindings operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFindings for more information on using the GetFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetFindingsRequest method.
//    req, resp := client.GetFindingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetFindings
func (c *GuardDuty) GetFindingsRequest(input *GetFindingsInput) (req *request.Request, output *GetFindingsOutput) {
	op := &request.Operation{
		Name:       opGetFindings,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/findings/get",
	}

	if input == nil {
		input = &GetFindingsInput{}
	}

	output = &GetFindingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFindings API operation for Amazon GuardDuty.
//
// Describes Amazon GuardDuty findings specified by finding IDs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation GetFindings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Error response object.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Error response object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetFindings
func (c *GuardDuty) GetFindings(input *GetFindingsInput) (*GetFindingsOutput, error) {
	req, out := c.GetFindingsRequest(input)
	return out, req.Send()
}

// GetFindingsWithContext is the same as GetFindings with the addition of
// the ability to pass a context and additional request options.
//
// See GetFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) GetFindingsWithContext(ctx aws.Context, input *GetFindingsInput, opts ...request.Option) (*GetFindingsOutput, error) {
	req, out := c.GetFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFindingsStatistics = "GetFindingsStatistics"

// GetFindingsStatisticsRequest generates a "aws/request.Request" representing the
// client's request for the GetFindingsStatistics operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFindingsStatistics for more information on using the GetFindingsStatistics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetFindingsStatisticsRequest method.
//    req, resp := client.GetFindingsStatisticsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetFindingsStatistics
func (c *GuardDuty) GetFindingsStatisticsRequest(input *GetFindingsStatisticsInput) (req *request.Request, output *GetFindingsStatisticsOutput) {
	op := &request.Operation{
		Name:       opGetFindingsStatistics,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/findings/statistics",
	}

	if input == nil {
		input = &GetFindingsStatisticsInput{}
	}

	output = &GetFindingsStatisticsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFindingsStatistics API operation for Amazon GuardDuty.
//
// Lists Amazon GuardDuty findings' statistics for the specified detector ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation GetFindingsStatistics for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Error response object.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Error response object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetFindingsStatistics
func (c *GuardDuty) GetFindingsStatistics(input *GetFindingsStatisticsInput) (*GetFindingsStatisticsOutput, error) {
	req, out := c.GetFindingsStatisticsRequest(input)
	return out, req.Send()
}

// GetFindingsStatisticsWithContext is the same as GetFindingsStatistics with the addition of
// the ability to pass a context and additional request options.
//
// See GetFindingsStatistics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) GetFindingsStatisticsWithContext(ctx aws.Context, input *GetFindingsStatisticsInput, opts ...request.Option) (*GetFindingsStatisticsOutput, error) {
	req, out := c.GetFindingsStatisticsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIPSet = "GetIPSet"

// GetIPSetRequest generates a "aws/request.Request" representing the
// client's request for the GetIPSet operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIPSet for more information on using the GetIPSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetIPSetRequest method.
//    req, resp := client.GetIPSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetIPSet
func (c *GuardDuty) GetIPSetRequest(input *GetIPSetInput) (req *request.Request, output *GetIPSetOutput) {
	op := &request.Operation{
		Name:       opGetIPSet,
		HTTPMethod: "GET",
		HTTPPath:   "/detector/{detectorId}/ipset/{ipSetId}",
	}

	if input == nil {
		input = &GetIPSetInput{}
	}

	output = &GetIPSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIPSet API operation for Amazon GuardDuty.
//
// Retrieves the IPSet specified by the IPSet ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation GetIPSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Error response object.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Error response object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetIPSet
func (c *GuardDuty) GetIPSet(input *GetIPSetInput) (*GetIPSetOutput, error) {
	req, out := c.GetIPSetRequest(input)
	return out, req.Send()
}

// GetIPSetWithContext is the same as GetIPSet with the addition of
// the ability to pass a context and additional request options.
//
// See GetIPSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) GetIPSetWithContext(ctx aws.Context, input *GetIPSetInput, opts ...request.Option) (*GetIPSetOutput, error) {
	req, out := c.GetIPSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInvitationsCount = "GetInvitationsCount"

// GetInvitationsCountRequest generates a "aws/request.Request" representing the
// client's request for the GetInvitationsCount operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInvitationsCount for more information on using the GetInvitationsCount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInvitationsCountRequest method.
//    req, resp := client.GetInvitationsCountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetInvitationsCount
func (c *GuardDuty) GetInvitationsCountRequest(input *GetInvitationsCountInput) (req *request.Request, output *GetInvitationsCountOutput) {
	op := &request.Operation{
		Name:       opGetInvitationsCount,
		HTTPMethod: "GET",
		HTTPPath:   "/invitation/count",
	}

	if input == nil {
		input = &GetInvitationsCountInput{}
	}

	output = &GetInvitationsCountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInvitationsCount API operation for Amazon GuardDuty.
//
// Returns the count of all GuardDuty membership invitations that were sent
// to the current member account except the currently accepted invitation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation GetInvitationsCount for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Error response object.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Error response object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetInvitationsCount
func (c *GuardDuty) GetInvitationsCount(input *GetInvitationsCountInput) (*GetInvitationsCountOutput, error) {
	req, out := c.GetInvitationsCountRequest(input)
	return out, req.Send()
}

// GetInvitationsCountWithContext is the same as GetInvitationsCount with the addition of
// the ability to pass a context and additional request options.
//
// See GetInvitationsCount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) GetInvitationsCountWithContext(ctx aws.Context, input *GetInvitationsCountInput, opts ...request.Option) (*GetInvitationsCountOutput, error) {
	req, out := c.GetInvitationsCountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMasterAccount = "GetMasterAccount"

// GetMasterAccountRequest generates a "aws/request.Request" representing the
// client's request for the GetMasterAccount operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMasterAccount for more information on using the GetMasterAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMasterAccountRequest method.
//    req, resp := client.GetMasterAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetMasterAccount
func (c *GuardDuty) GetMasterAccountRequest(input *GetMasterAccountInput) (req *request.Request, output *GetMasterAccountOutput) {
	op := &request.Operation{
		Name:       opGetMasterAccount,
		HTTPMethod: "GET",
		HTTPPath:   "/detector/{detectorId}/master",
	}

	if input == nil {
		input = &GetMasterAccountInput{}
	}

	output = &GetMasterAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMasterAccount API operation for Amazon GuardDuty.
//
// Provides the details for the GuardDuty master account to the current GuardDuty
// member account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation GetMasterAccount for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Error response object.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Error response object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetMasterAccount
func (c *GuardDuty) GetMasterAccount(input *GetMasterAccountInput) (*GetMasterAccountOutput, error) {
	req, out := c.GetMasterAccountRequest(input)
	return out, req.Send()
}

// GetMasterAccountWithContext is the same as GetMasterAccount with the addition of
// the ability to pass a context and additional request options.
//
// See GetMasterAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) GetMasterAccountWithContext(ctx aws.Context, input *GetMasterAccountInput, opts ...request.Option) (*GetMasterAccountOutput, error) {
	req, out := c.GetMasterAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMembers = "GetMembers"

// GetMembersRequest generates a "aws/request.Request" representing the
// client's request for the GetMembers operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMembers for more information on using the GetMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMembersRequest method.
//    req, resp := client.GetMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetMembers
func (c *GuardDuty) GetMembersRequest(input *GetMembersInput) (req *request.Request, output *GetMembersOutput) {
	op := &request.Operation{
		Name:       opGetMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/member/get",
	}

	if input == nil {
		input = &GetMembersInput{}
	}

	output = &GetMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMembers API operation for Amazon GuardDuty.
//
// Retrieves GuardDuty member accounts (to the current GuardDuty master account)
// specified by the account IDs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation GetMembers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Error response object.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Error response object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetMembers
func (c *GuardDuty) GetMembers(input *GetMembersInput) (*GetMembersOutput, error) {
	req, out := c.GetMembersRequest(input)
	return out, req.Send()
}

// GetMembersWithContext is the same as GetMembers with the addition of
// the ability to pass a context and additional request options.
//
// See GetMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) GetMembersWithContext(ctx aws.Context, input *GetMembersInput, opts ...request.Option) (*GetMembersOutput, error) {
	req, out := c.GetMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetThreatIntelSet = "GetThreatIntelSet"

// GetThreatIntelSetRequest generates a "aws/request.Request" representing the
// client's request for the GetThreatIntelSet operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetThreatIntelSet for more information on using the GetThreatIntelSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetThreatIntelSetRequest method.
//    req, resp := client.GetThreatIntelSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetThreatIntelSet
func (c *GuardDuty) GetThreatIntelSetRequest(input *GetThreatIntelSetInput) (req *request.Request, output *GetThreatIntelSetOutput) {
	op := &request.Operation{
		Name:       opGetThreatIntelSet,
		HTTPMethod: "GET",
		HTTPPath:   "/detector/{detectorId}/threatintelset/{threatIntelSetId}",
	}

	if input == nil {
		input = &GetThreatIntelSetInput{}
	}

	output = &GetThreatIntelSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetThreatIntelSet API operation for Amazon GuardDuty.
//
// Retrieves the ThreatIntelSet that is specified by the ThreatIntelSet ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation GetThreatIntelSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Error response object.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Error response object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetThreatIntelSet
func (c *GuardDuty) GetThreatIntelSet(input *GetThreatIntelSetInput) (*GetThreatIntelSetOutput, error) {
	req, out := c.GetThreatIntelSetRequest(input)
	return out, req.Send()
}

// GetThreatIntelSetWithContext is the same as GetThreatIntelSet with the addition of
// the ability to pass a context and additional request options.
//
// See GetThreatIntelSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) GetThreatIntelSetWithContext(ctx aws.Context, input *GetThreatIntelSetInput, opts ...request.Option) (*GetThreatIntelSetOutput, error) {
	req, out := c.GetThreatIntelSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opInviteMembers = "InviteMembers"

// InviteMembersRequest generates a "aws/request.Request" representing the
// client's request for the InviteMembers operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See InviteMembers for more information on using the InviteMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the InviteMembersRequest method.
//    req, resp := client.InviteMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/InviteMembers
func (c *GuardDuty) InviteMembersRequest(input *InviteMembersInput) (req *request.Request, output *InviteMembersOutput) {
	op := &request.Operation{
		Name:       opInviteMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/member/invite",
	}

	if input == nil {
		input = &InviteMembersInput{}
	}

	output = &InviteMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// InviteMembers API operation for Amazon GuardDuty.
//
// Invites other AWS accounts (created as members of the current AWS account
// by CreateMembers) to enable GuardDuty and allow the current AWS account to
// view and manage these accounts' GuardDuty findings on their behalf as the
// master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation InviteMembers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Error response object.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Error response object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/InviteMembers
func (c *GuardDuty) InviteMembers(input *InviteMembersInput) (*InviteMembersOutput, error) {
	req, out := c.InviteMembersRequest(input)
	return out, req.Send()
}

// InviteMembersWithContext is the same as InviteMembers with the addition of
// the ability to pass a context and additional request options.
//
// See InviteMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) InviteMembersWithContext(ctx aws.Context, input *InviteMembersInput, opts ...request.Option) (*InviteMembersOutput, error) {
	req, out := c.InviteMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDetectors = "ListDetectors"

// ListDetectorsRequest generates a "aws/request.Request" representing the
// client's request for the ListDetectors operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDetectors for more information on using the ListDetectors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDetectorsRequest method.
//    req, resp := client.ListDetectorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListDetectors
func (c *GuardDuty) ListDetectorsRequest(input *ListDetectorsInput) (req *request.Request, output *ListDetectorsOutput) {
	op := &request.Operation{
		Name:       opListDetectors,
		HTTPMethod: "GET",
		HTTPPath:   "/detector",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDetectorsInput{}
	}

	output = &ListDetectorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDetectors API operation for Amazon GuardDuty.
//
// Lists detectorIds of all the existing Amazon GuardDuty detector resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation ListDetectors for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Error response object.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Error response object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListDetectors
func (c *GuardDuty) ListDetectors(input *ListDetectorsInput) (*ListDetectorsOutput, error) {
	req, out := c.ListDetectorsRequest(input)
	return out, req.Send()
}

// ListDetectorsWithContext is the same as ListDetectors with the addition of
// the ability to pass a context and additional request options.
//
// See ListDetectors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) ListDetectorsWithContext(ctx aws.Context, input *ListDetectorsInput, opts ...request.Option) (*ListDetectorsOutput, error) {
	req, out := c.ListDetectorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDetectorsPages iterates over the pages of a ListDetectors operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDetectors method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDetectors operation.
//    pageNum := 0
//    err := client.ListDetectorsPages(params,
//        func(page *ListDetectorsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *GuardDuty) ListDetectorsPages(input *ListDetectorsInput, fn func(*ListDetectorsOutput, bool) bool) error {
	return c.ListDetectorsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDetectorsPagesWithContext same as ListDetectorsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) ListDetectorsPagesWithContext(ctx aws.Context, input *ListDetectorsInput, fn func(*ListDetectorsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDetectorsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDetectorsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListDetectorsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListFindings = "ListFindings"

// ListFindingsRequest generates a "aws/request.Request" representing the
// client's request for the ListFindings operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFindings for more information on using the ListFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFindingsRequest method.
//    req, resp := client.ListFindingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListFindings
func (c *GuardDuty) ListFindingsRequest(input *ListFindingsInput) (req *request.Request, output *ListFindingsOutput) {
	op := &request.Operation{
		Name:       opListFindings,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/findings",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFindingsInput{}
	}

	output = &ListFindingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFindings API operation for Amazon GuardDuty.
//
// Lists Amazon GuardDuty findings for the specified detector ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation ListFindings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Error response object.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Error response object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListFindings
func (c *GuardDuty) ListFindings(input *ListFindingsInput) (*ListFindingsOutput, error) {
	req, out := c.ListFindingsRequest(input)
	return out, req.Send()
}

// ListFindingsWithContext is the same as ListFindings with the addition of
// the ability to pass a context and additional request options.
//
// See ListFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) ListFindingsWithContext(ctx aws.Context, input *ListFindingsInput, opts ...request.Option) (*ListFindingsOutput, error) {
	req, out := c.ListFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFindingsPages iterates over the pages of a ListFindings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFindings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListFindings operation.
//    pageNum := 0
//    err := client.ListFindingsPages(params,
//        func(page *ListFindingsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *GuardDuty) ListFindingsPages(input *ListFindingsInput, fn func(*ListFindingsOutput, bool) bool) error {
	return c.ListFindingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFindingsPagesWithContext same as ListFindingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) ListFindingsPagesWithContext(ctx aws.Context, input *ListFindingsInput, fn func(*ListFindingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFindingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFindingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListFindingsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListIPSets = "ListIPSets"

// ListIPSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListIPSets operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIPSets for more information on using the ListIPSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListIPSetsRequest method.
//    req, resp := client.ListIPSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListIPSets
func (c *GuardDuty) ListIPSetsRequest(input *ListIPSetsInput) (req *request.Request, output *ListIPSetsOutput) {
	op := &request.Operation{
		Name:       opListIPSets,
		HTTPMethod: "GET",
		HTTPPath:   "/detector/{detectorId}/ipset",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListIPSetsInput{}
	}

	output = &ListIPSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIPSets API operation for Amazon GuardDuty.
//
// Lists the IPSets of the GuardDuty service specified by the detector ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation ListIPSets for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Error response object.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Error response object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListIPSets
func (c *GuardDuty) ListIPSets(input *ListIPSetsInput) (*ListIPSetsOutput, error) {
	req, out := c.ListIPSetsRequest(input)
	return out, req.Send()
}

// ListIPSetsWithContext is the same as ListIPSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListIPSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) ListIPSetsWithContext(ctx aws.Context, input *ListIPSetsInput, opts ...request.Option) (*ListIPSetsOutput, error) {
	req, out := c.ListIPSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListIPSetsPages iterates over the pages of a ListIPSets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListIPSets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListIPSets operation.
//    pageNum := 0
//    err := client.ListIPSetsPages(params,
//        func(page *ListIPSetsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *GuardDuty) ListIPSetsPages(input *ListIPSetsInput, fn func(*ListIPSetsOutput, bool) bool) error {
	return c.ListIPSetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListIPSetsPagesWithContext same as ListIPSetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) ListIPSetsPagesWithContext(ctx aws.Context, input *ListIPSetsInput, fn func(*ListIPSetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListIPSetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListIPSetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListIPSetsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListInvitations = "ListInvitations"

// ListInvitationsRequest generates a "aws/request.Request" representing the
// client's request for the ListInvitations operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInvitations for more information on using the ListInvitations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListInvitationsRequest method.
//    req, resp := client.ListInvitationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListInvitations
func (c *GuardDuty) ListInvitationsRequest(input *ListInvitationsInput) (req *request.Request, output *ListInvitationsOutput) {
	op := &request.Operation{
		Name:       opListInvitations,
		HTTPMethod: "GET",
		HTTPPath:   "/invitation",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInvitationsInput{}
	}

	output = &ListInvitationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInvitations API operation for Amazon GuardDuty.
//
// Lists all GuardDuty membership invitations that were sent to the current
// AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation ListInvitations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Error response object.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Error response object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListInvitations
func (c *GuardDuty) ListInvitations(input *ListInvitationsInput) (*ListInvitationsOutput, error) {
	req, out := c.ListInvitationsRequest(input)
	return out, req.Send()
}

// ListInvitationsWithContext is the same as ListInvitations with the addition of
// the ability to pass a context and additional request options.
//
// See ListInvitations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) ListInvitationsWithContext(ctx aws.Context, input *ListInvitationsInput, opts ...request.Option) (*ListInvitationsOutput, error) {
	req, out := c.ListInvitationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListInvitationsPages iterates over the pages of a ListInvitations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInvitations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListInvitations operation.
//    pageNum := 0
//    err := client.ListInvitationsPages(params,
//        func(page *ListInvitationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *GuardDuty) ListInvitationsPages(input *ListInvitationsInput, fn func(*ListInvitationsOutput, bool) bool) error {
	return c.ListInvitationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListInvitationsPagesWithContext same as ListInvitationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) ListInvitationsPagesWithContext(ctx aws.Context, input *ListInvitationsInput, fn func(*ListInvitationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListInvitationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListInvitationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListInvitationsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListMembers = "ListMembers"

// ListMembersRequest generates a "aws/request.Request" representing the
// client's request for the ListMembers operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMembers for more information on using the ListMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListMembersRequest method.
//    req, resp := client.ListMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListMembers
func (c *GuardDuty) ListMembersRequest(input *ListMembersInput) (req *request.Request, output *ListMembersOutput) {
	op := &request.Operation{
		Name:       opListMembers,
		HTTPMethod: "GET",
		HTTPPath:   "/detector/{detectorId}/member",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMembersInput{}
	}

	output = &ListMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMembers API operation for Amazon GuardDuty.
//
// Lists details about all member accounts for the current GuardDuty master
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation ListMembers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Error response object.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Error response object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListMembers
func (c *GuardDuty) ListMembers(input *ListMembersInput) (*ListMembersOutput, error) {
	req, out := c.ListMembersRequest(input)
	return out, req.Send()
}

// ListMembersWithContext is the same as ListMembers with the addition of
// the ability to pass a context and additional request options.
//
// See ListMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) ListMembersWithContext(ctx aws.Context, input *ListMembersInput, opts ...request.Option) (*ListMembersOutput, error) {
	req, out := c.ListMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMembersPages iterates over the pages of a ListMembers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMembers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListMembers operation.
//    pageNum := 0
//    err := client.ListMembersPages(params,
//        func(page *ListMembersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *GuardDuty) ListMembersPages(input *ListMembersInput, fn func(*ListMembersOutput, bool) bool) error {
	return c.ListMembersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMembersPagesWithContext same as ListMembersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) ListMembersPagesWithContext(ctx aws.Context, input *ListMembersInput, fn func(*ListMembersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMembersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMembersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListMembersOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListThreatIntelSets = "ListThreatIntelSets"

// ListThreatIntelSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListThreatIntelSets operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListThreatIntelSets for more information on using the ListThreatIntelSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListThreatIntelSetsRequest method.
//    req, resp := client.ListThreatIntelSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListThreatIntelSets
func (c *GuardDuty) ListThreatIntelSetsRequest(input *ListThreatIntelSetsInput) (req *request.Request, output *ListThreatIntelSetsOutput) {
	op := &request.Operation{
		Name:       opListThreatIntelSets,
		HTTPMethod: "GET",
		HTTPPath:   "/detector/{detectorId}/threatintelset",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListThreatIntelSetsInput{}
	}

	output = &ListThreatIntelSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListThreatIntelSets API operation for Amazon GuardDuty.
//
// Lists the ThreatIntelSets of the GuardDuty service specified by the detector
// ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation ListThreatIntelSets for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Error response object.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Error response object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListThreatIntelSets
func (c *GuardDuty) ListThreatIntelSets(input *ListThreatIntelSetsInput) (*ListThreatIntelSetsOutput, error) {
	req, out := c.ListThreatIntelSetsRequest(input)
	return out, req.Send()
}

// ListThreatIntelSetsWithContext is the same as ListThreatIntelSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListThreatIntelSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) ListThreatIntelSetsWithContext(ctx aws.Context, input *ListThreatIntelSetsInput, opts ...request.Option) (*ListThreatIntelSetsOutput, error) {
	req, out := c.ListThreatIntelSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListThreatIntelSetsPages iterates over the pages of a ListThreatIntelSets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListThreatIntelSets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListThreatIntelSets operation.
//    pageNum := 0
//    err := client.ListThreatIntelSetsPages(params,
//        func(page *ListThreatIntelSetsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *GuardDuty) ListThreatIntelSetsPages(input *ListThreatIntelSetsInput, fn func(*ListThreatIntelSetsOutput, bool) bool) error {
	return c.ListThreatIntelSetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListThreatIntelSetsPagesWithContext same as ListThreatIntelSetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) ListThreatIntelSetsPagesWithContext(ctx aws.Context, input *ListThreatIntelSetsInput, fn func(*ListThreatIntelSetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListThreatIntelSetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListThreatIntelSetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListThreatIntelSetsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opStartMonitoringMembers = "StartMonitoringMembers"

// StartMonitoringMembersRequest generates a "aws/request.Request" representing the
// client's request for the StartMonitoringMembers operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartMonitoringMembers for more information on using the StartMonitoringMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartMonitoringMembersRequest method.
//    req, resp := client.StartMonitoringMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/StartMonitoringMembers
func (c *GuardDuty) StartMonitoringMembersRequest(input *StartMonitoringMembersInput) (req *request.Request, output *StartMonitoringMembersOutput) {
	op := &request.Operation{
		Name:       opStartMonitoringMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/member/start",
	}

	if input == nil {
		input = &StartMonitoringMembersInput{}
	}

	output = &StartMonitoringMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartMonitoringMembers API operation for Amazon GuardDuty.
//
// Re-enables GuardDuty to monitor findings of the member accounts specified
// by the account IDs. A master GuardDuty account can run this command after
// disabling GuardDuty from monitoring these members' findings by running StopMonitoringMembers.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation StartMonitoringMembers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Error response object.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Error response object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/StartMonitoringMembers
func (c *GuardDuty) StartMonitoringMembers(input *StartMonitoringMembersInput) (*StartMonitoringMembersOutput, error) {
	req, out := c.StartMonitoringMembersRequest(input)
	return out, req.Send()
}

// StartMonitoringMembersWithContext is the same as StartMonitoringMembers with the addition of
// the ability to pass a context and additional request options.
//
// See StartMonitoringMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) StartMonitoringMembersWithContext(ctx aws.Context, input *StartMonitoringMembersInput, opts ...request.Option) (*StartMonitoringMembersOutput, error) {
	req, out := c.StartMonitoringMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopMonitoringMembers = "StopMonitoringMembers"

// StopMonitoringMembersRequest generates a "aws/request.Request" representing the
// client's request for the StopMonitoringMembers operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopMonitoringMembers for more information on using the StopMonitoringMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopMonitoringMembersRequest method.
//    req, resp := client.StopMonitoringMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/StopMonitoringMembers
func (c *GuardDuty) StopMonitoringMembersRequest(input *StopMonitoringMembersInput) (req *request.Request, output *StopMonitoringMembersOutput) {
	op := &request.Operation{
		Name:       opStopMonitoringMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/member/stop",
	}

	if input == nil {
		input = &StopMonitoringMembersInput{}
	}

	output = &StopMonitoringMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopMonitoringMembers API operation for Amazon GuardDuty.
//
// Disables GuardDuty from monitoring findings of the member accounts specified
// by the account IDs. After running this command, a master GuardDuty account
// can run StartMonitoringMembers to re-enable GuardDuty to monitor these members'
// findings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation StopMonitoringMembers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Error response object.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Error response object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/StopMonitoringMembers
func (c *GuardDuty) StopMonitoringMembers(input *StopMonitoringMembersInput) (*StopMonitoringMembersOutput, error) {
	req, out := c.StopMonitoringMembersRequest(input)
	return out, req.Send()
}

// StopMonitoringMembersWithContext is the same as StopMonitoringMembers with the addition of
// the ability to pass a context and additional request options.
//
// See StopMonitoringMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) StopMonitoringMembersWithContext(ctx aws.Context, input *StopMonitoringMembersInput, opts ...request.Option) (*StopMonitoringMembersOutput, error) {
	req, out := c.StopMonitoringMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUnarchiveFindings = "UnarchiveFindings"

// UnarchiveFindingsRequest generates a "aws/request.Request" representing the
// client's request for the UnarchiveFindings operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UnarchiveFindings for more information on using the UnarchiveFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UnarchiveFindingsRequest method.
//    req, resp := client.UnarchiveFindingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UnarchiveFindings
func (c *GuardDuty) UnarchiveFindingsRequest(input *UnarchiveFindingsInput) (req *request.Request, output *UnarchiveFindingsOutput) {
	op := &request.Operation{
		Name:       opUnarchiveFindings,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/findings/unarchive",
	}

	if input == nil {
		input = &UnarchiveFindingsInput{}
	}

	output = &UnarchiveFindingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UnarchiveFindings API operation for Amazon GuardDuty.
//
// Unarchives Amazon GuardDuty findings specified by the list of finding IDs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation UnarchiveFindings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Error response object.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Error response object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UnarchiveFindings
func (c *GuardDuty) UnarchiveFindings(input *UnarchiveFindingsInput) (*UnarchiveFindingsOutput, error) {
	req, out := c.UnarchiveFindingsRequest(input)
	return out, req.Send()
}

// UnarchiveFindingsWithContext is the same as UnarchiveFindings with the addition of
// the ability to pass a context and additional request options.
//
// See UnarchiveFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) UnarchiveFindingsWithContext(ctx aws.Context, input *UnarchiveFindingsInput, opts ...request.Option) (*UnarchiveFindingsOutput, error) {
	req, out := c.UnarchiveFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDetector = "UpdateDetector"

// UpdateDetectorRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDetector operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDetector for more information on using the UpdateDetector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDetectorRequest method.
//    req, resp := client.UpdateDetectorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateDetector
func (c *GuardDuty) UpdateDetectorRequest(input *UpdateDetectorInput) (req *request.Request, output *UpdateDetectorOutput) {
	op := &request.Operation{
		Name:       opUpdateDetector,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}",
	}

	if input == nil {
		input = &UpdateDetectorInput{}
	}

	output = &UpdateDetectorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDetector API operation for Amazon GuardDuty.
//
// Updates an Amazon GuardDuty detector specified by the detectorId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation UpdateDetector for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Error response object.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Error response object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateDetector
func (c *GuardDuty) UpdateDetector(input *UpdateDetectorInput) (*UpdateDetectorOutput, error) {
	req, out := c.UpdateDetectorRequest(input)
	return out, req.Send()
}

// UpdateDetectorWithContext is the same as UpdateDetector with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDetector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) UpdateDetectorWithContext(ctx aws.Context, input *UpdateDetectorInput, opts ...request.Option) (*UpdateDetectorOutput, error) {
	req, out := c.UpdateDetectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFindingsFeedback = "UpdateFindingsFeedback"

// UpdateFindingsFeedbackRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFindingsFeedback operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFindingsFeedback for more information on using the UpdateFindingsFeedback
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFindingsFeedbackRequest method.
//    req, resp := client.UpdateFindingsFeedbackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateFindingsFeedback
func (c *GuardDuty) UpdateFindingsFeedbackRequest(input *UpdateFindingsFeedbackInput) (req *request.Request, output *UpdateFindingsFeedbackOutput) {
	op := &request.Operation{
		Name:       opUpdateFindingsFeedback,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/findings/feedback",
	}

	if input == nil {
		input = &UpdateFindingsFeedbackInput{}
	}

	output = &UpdateFindingsFeedbackOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFindingsFeedback API operation for Amazon GuardDuty.
//
// Marks specified Amazon GuardDuty findings as useful or not useful.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation UpdateFindingsFeedback for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Error response object.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Error response object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateFindingsFeedback
func (c *GuardDuty) UpdateFindingsFeedback(input *UpdateFindingsFeedbackInput) (*UpdateFindingsFeedbackOutput, error) {
	req, out := c.UpdateFindingsFeedbackRequest(input)
	return out, req.Send()
}

// UpdateFindingsFeedbackWithContext is the same as UpdateFindingsFeedback with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFindingsFeedback for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) UpdateFindingsFeedbackWithContext(ctx aws.Context, input *UpdateFindingsFeedbackInput, opts ...request.Option) (*UpdateFindingsFeedbackOutput, error) {
	req, out := c.UpdateFindingsFeedbackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateIPSet = "UpdateIPSet"

// UpdateIPSetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateIPSet operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateIPSet for more information on using the UpdateIPSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateIPSetRequest method.
//    req, resp := client.UpdateIPSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateIPSet
func (c *GuardDuty) UpdateIPSetRequest(input *UpdateIPSetInput) (req *request.Request, output *UpdateIPSetOutput) {
	op := &request.Operation{
		Name:       opUpdateIPSet,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/ipset/{ipSetId}",
	}

	if input == nil {
		input = &UpdateIPSetInput{}
	}

	output = &UpdateIPSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateIPSet API operation for Amazon GuardDuty.
//
// Updates the IPSet specified by the IPSet ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation UpdateIPSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Error response object.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Error response object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateIPSet
func (c *GuardDuty) UpdateIPSet(input *UpdateIPSetInput) (*UpdateIPSetOutput, error) {
	req, out := c.UpdateIPSetRequest(input)
	return out, req.Send()
}

// UpdateIPSetWithContext is the same as UpdateIPSet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateIPSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) UpdateIPSetWithContext(ctx aws.Context, input *UpdateIPSetInput, opts ...request.Option) (*UpdateIPSetOutput, error) {
	req, out := c.UpdateIPSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateThreatIntelSet = "UpdateThreatIntelSet"

// UpdateThreatIntelSetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateThreatIntelSet operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateThreatIntelSet for more information on using the UpdateThreatIntelSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateThreatIntelSetRequest method.
//    req, resp := client.UpdateThreatIntelSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateThreatIntelSet
func (c *GuardDuty) UpdateThreatIntelSetRequest(input *UpdateThreatIntelSetInput) (req *request.Request, output *UpdateThreatIntelSetOutput) {
	op := &request.Operation{
		Name:       opUpdateThreatIntelSet,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/threatintelset/{threatIntelSetId}",
	}

	if input == nil {
		input = &UpdateThreatIntelSetInput{}
	}

	output = &UpdateThreatIntelSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateThreatIntelSet API operation for Amazon GuardDuty.
//
// Updates the ThreatIntelSet specified by ThreatIntelSet ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation UpdateThreatIntelSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Error response object.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Error response object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateThreatIntelSet
func (c *GuardDuty) UpdateThreatIntelSet(input *UpdateThreatIntelSetInput) (*UpdateThreatIntelSetOutput, error) {
	req, out := c.UpdateThreatIntelSetRequest(input)
	return out, req.Send()
}

// UpdateThreatIntelSetWithContext is the same as UpdateThreatIntelSet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateThreatIntelSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) UpdateThreatIntelSetWithContext(ctx aws.Context, input *UpdateThreatIntelSetInput, opts ...request.Option) (*UpdateThreatIntelSetOutput, error) {
	req, out := c.UpdateThreatIntelSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// AcceptInvitation request body.
type AcceptInvitationInput struct {
	_ struct{} `type:"structure"`

	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" type:"string" required:"true"`

	// This value is used to validate the master account to the member account.
	InvitationId *string `locationName:"invitationId" type:"string"`

	// The account ID of the master GuardDuty account whose invitation you're accepting.
	MasterId *string `locationName:"masterId" type:"string"`
}

// String returns the string representation
func (s AcceptInvitationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptInvitationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcceptInvitationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcceptInvitationInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *AcceptInvitationInput) SetDetectorId(v string) *AcceptInvitationInput {
	s.DetectorId = &v
	return s
}

// SetInvitationId sets the InvitationId field's value.
func (s *AcceptInvitationInput) SetInvitationId(v string) *AcceptInvitationInput {
	s.InvitationId = &v
	return s
}

// SetMasterId sets the MasterId field's value.
func (s *AcceptInvitationInput) SetMasterId(v string) *AcceptInvitationInput {
	s.MasterId = &v
	return s
}

type AcceptInvitationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AcceptInvitationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptInvitationOutput) GoString() string {
	return s.String()
}

// The IAM access key details (IAM user information) of a user that engaged
// in the activity that prompted GuardDuty to generate a finding.
type AccessKeyDetails struct {
	_ struct{} `type:"structure"`

	// Access key ID of the user.
	AccessKeyId *string `locationName:"accessKeyId" type:"string"`

	// The principal ID of the user.
	PrincipalId *string `locationName:"principalId" type:"string"`

	// The name of the user.
	UserName *string `locationName:"userName" type:"string"`

	// The type of the user.
	UserType *string `locationName:"userType" type:"string"`
}

// String returns the string representation
func (s AccessKeyDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessKeyDetails) GoString() string {
	return s.String()
}

// SetAccessKeyId sets the AccessKeyId field's value.
func (s *AccessKeyDetails) SetAccessKeyId(v string) *AccessKeyDetails {
	s.AccessKeyId = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *AccessKeyDetails) SetPrincipalId(v string) *AccessKeyDetails {
	s.PrincipalId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *AccessKeyDetails) SetUserName(v string) *AccessKeyDetails {
	s.UserName = &v
	return s
}

// SetUserType sets the UserType field's value.
func (s *AccessKeyDetails) SetUserType(v string) *AccessKeyDetails {
	s.UserType = &v
	return s
}

// An object containing the member's accountId and email address.
type AccountDetail struct {
	_ struct{} `type:"structure"`

	// Member account ID.
	AccountId *string `locationName:"accountId" type:"string"`

	// Member account's email address.
	Email *string `locationName:"email" type:"string"`
}

// String returns the string representation
func (s AccountDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountDetail) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *AccountDetail) SetAccountId(v string) *AccountDetail {
	s.AccountId = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *AccountDetail) SetEmail(v string) *AccountDetail {
	s.Email = &v
	return s
}

// Information about the activity described in a finding.
type Action struct {
	_ struct{} `type:"structure"`

	// GuardDuty Finding activity type.
	ActionType *string `locationName:"actionType" type:"string"`

	// Information about the AWS_API_CALL action described in this finding.
	AwsApiCallAction *AwsApiCallAction `locationName:"awsApiCallAction" type:"structure"`

	// Information about the DNS_REQUEST action described in this finding.
	DnsRequestAction *DnsRequestAction `locationName:"dnsRequestAction" type:"structure"`

	// Information about the NETWORK_CONNECTION action described in this finding.
	NetworkConnectionAction *NetworkConnectionAction `locationName:"networkConnectionAction" type:"structure"`

	// Information about the PORT_PROBE action described in this finding.
	PortProbeAction *PortProbeAction `locationName:"portProbeAction" type:"structure"`
}

// String returns the string representation
func (s Action) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Action) GoString() string {
	return s.String()
}

// SetActionType sets the ActionType field's value.
func (s *Action) SetActionType(v string) *Action {
	s.ActionType = &v
	return s
}

// SetAwsApiCallAction sets the AwsApiCallAction field's value.
func (s *Action) SetAwsApiCallAction(v *AwsApiCallAction) *Action {
	s.AwsApiCallAction = v
	return s
}

// SetDnsRequestAction sets the DnsRequestAction field's value.
func (s *Action) SetDnsRequestAction(v *DnsRequestAction) *Action {
	s.DnsRequestAction = v
	return s
}

// SetNetworkConnectionAction sets the NetworkConnectionAction field's value.
func (s *Action) SetNetworkConnectionAction(v *NetworkConnectionAction) *Action {
	s.NetworkConnectionAction = v
	return s
}

// SetPortProbeAction sets the PortProbeAction field's value.
func (s *Action) SetPortProbeAction(v *PortProbeAction) *Action {
	s.PortProbeAction = v
	return s
}

// Archive Findings Request
type ArchiveFindingsInput struct {
	_ struct{} `type:"structure"`

	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" type:"string" required:"true"`

	// IDs of the findings that you want to archive.
	FindingIds []*string `locationName:"findingIds" type:"list"`
}

// String returns the string representation
func (s ArchiveFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ArchiveFindingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ArchiveFindingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ArchiveFindingsInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *ArchiveFindingsInput) SetDetectorId(v string) *ArchiveFindingsInput {
	s.DetectorId = &v
	return s
}

// SetFindingIds sets the FindingIds field's value.
func (s *ArchiveFindingsInput) SetFindingIds(v []*string) *ArchiveFindingsInput {
	s.FindingIds = v
	return s
}

type ArchiveFindingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ArchiveFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ArchiveFindingsOutput) GoString() string {
	return s.String()
}

// Information about the AWS_API_CALL action described in this finding.
type AwsApiCallAction struct {
	_ struct{} `type:"structure"`

	// AWS API name.
	Api *string `locationName:"api" type:"string"`

	// AWS API caller type.
	CallerType *string `locationName:"callerType" type:"string"`

	// Domain information for the AWS API call.
	DomainDetails *DomainDetails `locationName:"domainDetails" type:"structure"`

	// Remote IP information of the connection.
	RemoteIpDetails *RemoteIpDetails `locationName:"remoteIpDetails" type:"structure"`

	// AWS service name whose API was invoked.
	ServiceName *string `locationName:"serviceName" type:"string"`
}

// String returns the string representation
func (s AwsApiCallAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsApiCallAction) GoString() string {
	return s.String()
}

// SetApi sets the Api field's value.
func (s *AwsApiCallAction) SetApi(v string) *AwsApiCallAction {
	s.Api = &v
	return s
}

// SetCallerType sets the CallerType field's value.
func (s *AwsApiCallAction) SetCallerType(v string) *AwsApiCallAction {
	s.CallerType = &v
	return s
}

// SetDomainDetails sets the DomainDetails field's value.
func (s *AwsApiCallAction) SetDomainDetails(v *DomainDetails) *AwsApiCallAction {
	s.DomainDetails = v
	return s
}

// SetRemoteIpDetails sets the RemoteIpDetails field's value.
func (s *AwsApiCallAction) SetRemoteIpDetails(v *RemoteIpDetails) *AwsApiCallAction {
	s.RemoteIpDetails = v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *AwsApiCallAction) SetServiceName(v string) *AwsApiCallAction {
	s.ServiceName = &v
	return s
}

// City information of the remote IP address.
type City struct {
	_ struct{} `type:"structure"`

	// City name of the remote IP address.
	CityName *string `locationName:"cityName" type:"string"`
}

// String returns the string representation
func (s City) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s City) GoString() string {
	return s.String()
}

// SetCityName sets the CityName field's value.
func (s *City) SetCityName(v string) *City {
	s.CityName = &v
	return s
}

// Finding attribute (for example, accountId) for which conditions and values
// must be specified when querying findings.
type Condition struct {
	_ struct{} `type:"structure"`

	// Represents the equal condition to be applied to a single field when querying
	// for findings.
	Eq []*string `locationName:"eq" type:"list"`

	// Represents the greater than condition to be applied to a single field when
	// querying for findings.
	Gt *int64 `locationName:"gt" type:"integer"`

	// Represents the greater than equal condition to be applied to a single field
	// when querying for findings.
	Gte *int64 `locationName:"gte" type:"integer"`

	// Represents the less than condition to be applied to a single field when querying
	// for findings.
	Lt *int64 `locationName:"lt" type:"integer"`

	// Represents the less than equal condition to be applied to a single field
	// when querying for findings.
	Lte *int64 `locationName:"lte" type:"integer"`

	// Represents the not equal condition to be applied to a single field when querying
	// for findings.
	Neq []*string `locationName:"neq" type:"list"`
}

// String returns the string representation
func (s Condition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Condition) GoString() string {
	return s.String()
}

// SetEq sets the Eq field's value.
func (s *Condition) SetEq(v []*string) *Condition {
	s.Eq = v
	return s
}

// SetGt sets the Gt field's value.
func (s *Condition) SetGt(v int64) *Condition {
	s.Gt = &v
	return s
}

// SetGte sets the Gte field's value.
func (s *Condition) SetGte(v int64) *Condition {
	s.Gte = &v
	return s
}

// SetLt sets the Lt field's value.
func (s *Condition) SetLt(v int64) *Condition {
	s.Lt = &v
	return s
}

// SetLte sets the Lte field's value.
func (s *Condition) SetLte(v int64) *Condition {
	s.Lte = &v
	return s
}

// SetNeq sets the Neq field's value.
func (s *Condition) SetNeq(v []*string) *Condition {
	s.Neq = v
	return s
}

// Country information of the remote IP address.
type Country struct {
	_ struct{} `type:"structure"`

	// Country code of the remote IP address.
	CountryCode *string `locationName:"countryCode" type:"string"`

	// Country name of the remote IP address.
	CountryName *string `locationName:"countryName" type:"string"`
}

// String returns the string representation
func (s Country) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Country) GoString() string {
	return s.String()
}

// SetCountryCode sets the CountryCode field's value.
func (s *Country) SetCountryCode(v string) *Country {
	s.CountryCode = &v
	return s
}

// SetCountryName sets the CountryName field's value.
func (s *Country) SetCountryName(v string) *Country {
	s.CountryName = &v
	return s
}

// Create Detector Request
type CreateDetectorInput struct {
	_ struct{} `type:"structure"`

	// A boolean value that specifies whether the detector is to be enabled.
	Enable *bool `locationName:"enable" type:"boolean"`
}

// String returns the string representation
func (s CreateDetectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDetectorInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *CreateDetectorInput) SetEnable(v bool) *CreateDetectorInput {
	s.Enable = &v
	return s
}

// CreateDetector response object.
type CreateDetectorOutput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the created detector.
	DetectorId *string `locationName:"detectorId" type:"string"`
}

// String returns the string representation
func (s CreateDetectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDetectorOutput) GoString() string {
	return s.String()
}

// SetDetectorId sets the DetectorId field's value.
func (s *CreateDetectorOutput) SetDetectorId(v string) *CreateDetectorOutput {
	s.DetectorId = &v
	return s
}

// Create IP Set Request
type CreateIPSetInput struct {
	_ struct{} `type:"structure"`

	// A boolean value that indicates whether GuardDuty is to start using the uploaded
	// IPSet.
	Activate *bool `locationName:"activate" type:"boolean"`

	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" type:"string" required:"true"`

	// The format of the file that contains the IPSet.
	Format *string `locationName:"format" type:"string" enum:"IpSetFormat"`

	// The URI of the file that contains the IPSet. For example (https://s3.us-west-2.amazonaws.com/my-bucket/my-object-key)
	Location *string `locationName:"location" type:"string"`

	// The user friendly name to identify the IPSet. This name is displayed in all
	// findings that are triggered by activity that involves IP addresses included
	// in this IPSet.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s CreateIPSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateIPSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateIPSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateIPSetInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActivate sets the Activate field's value.
func (s *CreateIPSetInput) SetActivate(v bool) *CreateIPSetInput {
	s.Activate = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *CreateIPSetInput) SetDetectorId(v string) *CreateIPSetInput {
	s.DetectorId = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *CreateIPSetInput) SetFormat(v string) *CreateIPSetInput {
	s.Format = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *CreateIPSetInput) SetLocation(v string) *CreateIPSetInput {
	s.Location = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateIPSetInput) SetName(v string) *CreateIPSetInput {
	s.Name = &v
	return s
}

// CreateIPSet response object.
type CreateIPSetOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for an IP Set
	IpSetId *string `locationName:"ipSetId" type:"string"`
}

// String returns the string representation
func (s CreateIPSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateIPSetOutput) GoString() string {
	return s.String()
}

// SetIpSetId sets the IpSetId field's value.
func (s *CreateIPSetOutput) SetIpSetId(v string) *CreateIPSetOutput {
	s.IpSetId = &v
	return s
}

// CreateMembers body
type CreateMembersInput struct {
	_ struct{} `type:"structure"`

	// A list of account ID and email address pairs of the accounts that you want
	// to associate with the master GuardDuty account.
	AccountDetails []*AccountDetail `locationName:"accountDetails" type:"list"`

	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMembersInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountDetails sets the AccountDetails field's value.
func (s *CreateMembersInput) SetAccountDetails(v []*AccountDetail) *CreateMembersInput {
	s.AccountDetails = v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *CreateMembersInput) SetDetectorId(v string) *CreateMembersInput {
	s.DetectorId = &v
	return s
}

// CreateMembers response object.
type CreateMembersOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects containing the unprocessed account and a result string
	// explaining why it was unprocessed.
	UnprocessedAccounts []*UnprocessedAccount `locationName:"unprocessedAccounts" type:"list"`
}

// String returns the string representation
func (s CreateMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMembersOutput) GoString() string {
	return s.String()
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *CreateMembersOutput) SetUnprocessedAccounts(v []*UnprocessedAccount) *CreateMembersOutput {
	s.UnprocessedAccounts = v
	return s
}

// Create Sample Findings Request
type CreateSampleFindingsInput struct {
	_ struct{} `type:"structure"`

	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" type:"string" required:"true"`

	// Types of sample findings that you want to generate.
	FindingTypes []*string `locationName:"findingTypes" type:"list"`
}

// String returns the string representation
func (s CreateSampleFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSampleFindingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSampleFindingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSampleFindingsInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *CreateSampleFindingsInput) SetDetectorId(v string) *CreateSampleFindingsInput {
	s.DetectorId = &v
	return s
}

// SetFindingTypes sets the FindingTypes field's value.
func (s *CreateSampleFindingsInput) SetFindingTypes(v []*string) *CreateSampleFindingsInput {
	s.FindingTypes = v
	return s
}

type CreateSampleFindingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateSampleFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSampleFindingsOutput) GoString() string {
	return s.String()
}

// Create Threat Intel Set Request
type CreateThreatIntelSetInput struct {
	_ struct{} `type:"structure"`

	// A boolean value that indicates whether GuardDuty is to start using the uploaded
	// ThreatIntelSet.
	Activate *bool `locationName:"activate" type:"boolean"`

	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" type:"string" required:"true"`

	// The format of the file that contains the ThreatIntelSet.
	Format *string `locationName:"format" type:"string" enum:"ThreatIntelSetFormat"`

	// The URI of the file that contains the ThreatIntelSet. For example (https://s3.us-west-2.amazonaws.com/my-bucket/my-object-key).
	Location *string `locationName:"location" type:"string"`

	// A user-friendly ThreatIntelSet name that is displayed in all finding generated
	// by activity that involves IP addresses included in this ThreatIntelSet.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s CreateThreatIntelSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateThreatIntelSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateThreatIntelSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateThreatIntelSetInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActivate sets the Activate field's value.
func (s *CreateThreatIntelSetInput) SetActivate(v bool) *CreateThreatIntelSetInput {
	s.Activate = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *CreateThreatIntelSetInput) SetDetectorId(v string) *CreateThreatIntelSetInput {
	s.DetectorId = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *CreateThreatIntelSetInput) SetFormat(v string) *CreateThreatIntelSetInput {
	s.Format = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *CreateThreatIntelSetInput) SetLocation(v string) *CreateThreatIntelSetInput {
	s.Location = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateThreatIntelSetInput) SetName(v string) *CreateThreatIntelSetInput {
	s.Name = &v
	return s
}

// CreateThreatIntelSet response object.
type CreateThreatIntelSetOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for an threat intel set
	ThreatIntelSetId *string `locationName:"threatIntelSetId" type:"string"`
}

// String returns the string representation
func (s CreateThreatIntelSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateThreatIntelSetOutput) GoString() string {
	return s.String()
}

// SetThreatIntelSetId sets the ThreatIntelSetId field's value.
func (s *CreateThreatIntelSetOutput) SetThreatIntelSetId(v string) *CreateThreatIntelSetOutput {
	s.ThreatIntelSetId = &v
	return s
}

// DeclineInvitations request body.
type DeclineInvitationsInput struct {
	_ struct{} `type:"structure"`

	// A list of account IDs of the AWS accounts that sent invitations to the current
	// member account that you want to decline invitations from.
	AccountIds []*string `locationName:"accountIds" type:"list"`
}

// String returns the string representation
func (s DeclineInvitationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeclineInvitationsInput) GoString() string {
	return s.String()
}

// SetAccountIds sets the AccountIds field's value.
func (s *DeclineInvitationsInput) SetAccountIds(v []*string) *DeclineInvitationsInput {
	s.AccountIds = v
	return s
}

// DeclineInvitations response object.
type DeclineInvitationsOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects containing the unprocessed account and a result string
	// explaining why it was unprocessed.
	UnprocessedAccounts []*UnprocessedAccount `locationName:"unprocessedAccounts" type:"list"`
}

// String returns the string representation
func (s DeclineInvitationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeclineInvitationsOutput) GoString() string {
	return s.String()
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *DeclineInvitationsOutput) SetUnprocessedAccounts(v []*UnprocessedAccount) *DeclineInvitationsOutput {
	s.UnprocessedAccounts = v
	return s
}

type DeleteDetectorInput struct {
	_ struct{} `type:"structure"`

	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDetectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDetectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDetectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDetectorInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *DeleteDetectorInput) SetDetectorId(v string) *DeleteDetectorInput {
	s.DetectorId = &v
	return s
}

type DeleteDetectorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDetectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDetectorOutput) GoString() string {
	return s.String()
}

type DeleteIPSetInput struct {
	_ struct{} `type:"structure"`

	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" type:"string" required:"true"`

	// IpSetId is a required field
	IpSetId *string `location:"uri" locationName:"ipSetId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteIPSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIPSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIPSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteIPSetInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.IpSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("IpSetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *DeleteIPSetInput) SetDetectorId(v string) *DeleteIPSetInput {
	s.DetectorId = &v
	return s
}

// SetIpSetId sets the IpSetId field's value.
func (s *DeleteIPSetInput) SetIpSetId(v string) *DeleteIPSetInput {
	s.IpSetId = &v
	return s
}

type DeleteIPSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteIPSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIPSetOutput) GoString() string {
	return s.String()
}

// DeleteInvitations request body.
type DeleteInvitationsInput struct {
	_ struct{} `type:"structure"`

	// A list of account IDs of the AWS accounts that sent invitations to the current
	// member account that you want to delete invitations from.
	AccountIds []*string `locationName:"accountIds" type:"list"`
}

// String returns the string representation
func (s DeleteInvitationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInvitationsInput) GoString() string {
	return s.String()
}

// SetAccountIds sets the AccountIds field's value.
func (s *DeleteInvitationsInput) SetAccountIds(v []*string) *DeleteInvitationsInput {
	s.AccountIds = v
	return s
}

// DeleteInvitations response object.
type DeleteInvitationsOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects containing the unprocessed account and a result string
	// explaining why it was unprocessed.
	UnprocessedAccounts []*UnprocessedAccount `locationName:"unprocessedAccounts" type:"list"`
}

// String returns the string representation
func (s DeleteInvitationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInvitationsOutput) GoString() string {
	return s.String()
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *DeleteInvitationsOutput) SetUnprocessedAccounts(v []*UnprocessedAccount) *DeleteInvitationsOutput {
	s.UnprocessedAccounts = v
	return s
}

// DeleteMembers request body.
type DeleteMembersInput struct {
	_ struct{} `type:"structure"`

	// A list of account IDs of the GuardDuty member accounts that you want to delete.
	AccountIds []*string `locationName:"accountIds" type:"list"`

	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMembersInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *DeleteMembersInput) SetAccountIds(v []*string) *DeleteMembersInput {
	s.AccountIds = v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *DeleteMembersInput) SetDetectorId(v string) *DeleteMembersInput {
	s.DetectorId = &v
	return s
}

// DeleteMembers response object.
type DeleteMembersOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects containing the unprocessed account and a result string
	// explaining why it was unprocessed.
	UnprocessedAccounts []*UnprocessedAccount `locationName:"unprocessedAccounts" type:"list"`
}

// String returns the string representation
func (s DeleteMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMembersOutput) GoString() string {
	return s.String()
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *DeleteMembersOutput) SetUnprocessedAccounts(v []*UnprocessedAccount) *DeleteMembersOutput {
	s.UnprocessedAccounts = v
	return s
}

type DeleteThreatIntelSetInput struct {
	_ struct{} `type:"structure"`

	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" type:"string" required:"true"`

	// ThreatIntelSetId is a required field
	ThreatIntelSetId *string `location:"uri" locationName:"threatIntelSetId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteThreatIntelSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteThreatIntelSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteThreatIntelSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteThreatIntelSetInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.ThreatIntelSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("ThreatIntelSetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *DeleteThreatIntelSetInput) SetDetectorId(v string) *DeleteThreatIntelSetInput {
	s.DetectorId = &v
	return s
}

// SetThreatIntelSetId sets the ThreatIntelSetId field's value.
func (s *DeleteThreatIntelSetInput) SetThreatIntelSetId(v string) *DeleteThreatIntelSetInput {
	s.ThreatIntelSetId = &v
	return s
}

type DeleteThreatIntelSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteThreatIntelSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteThreatIntelSetOutput) GoString() string {
	return s.String()
}

type DisassociateFromMasterAccountInput struct {
	_ struct{} `type:"structure"`

	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateFromMasterAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateFromMasterAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateFromMasterAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateFromMasterAccountInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *DisassociateFromMasterAccountInput) SetDetectorId(v string) *DisassociateFromMasterAccountInput {
	s.DetectorId = &v
	return s
}

type DisassociateFromMasterAccountOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateFromMasterAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateFromMasterAccountOutput) GoString() string {
	return s.String()
}

// DisassociateMembers request body.
type DisassociateMembersInput struct {
	_ struct{} `type:"structure"`

	// A list of account IDs of the GuardDuty member accounts that you want to disassociate
	// from master.
	AccountIds []*string `locationName:"accountIds" type:"list"`

	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateMembersInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *DisassociateMembersInput) SetAccountIds(v []*string) *DisassociateMembersInput {
	s.AccountIds = v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *DisassociateMembersInput) SetDetectorId(v string) *DisassociateMembersInput {
	s.DetectorId = &v
	return s
}

// DisassociateMembers response object.
type DisassociateMembersOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects containing the unprocessed account and a result string
	// explaining why it was unprocessed.
	UnprocessedAccounts []*UnprocessedAccount `locationName:"unprocessedAccounts" type:"list"`
}

// String returns the string representation
func (s DisassociateMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateMembersOutput) GoString() string {
	return s.String()
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *DisassociateMembersOutput) SetUnprocessedAccounts(v []*UnprocessedAccount) *DisassociateMembersOutput {
	s.UnprocessedAccounts = v
	return s
}

// Information about the DNS_REQUEST action described in this finding.
type DnsRequestAction struct {
	_ struct{} `type:"structure"`

	// Domain information for the DNS request.
	Domain *string `locationName:"domain" type:"string"`
}

// String returns the string representation
func (s DnsRequestAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DnsRequestAction) GoString() string {
	return s.String()
}

// SetDomain sets the Domain field's value.
func (s *DnsRequestAction) SetDomain(v string) *DnsRequestAction {
	s.Domain = &v
	return s
}

// Domain information for the AWS API call.
type DomainDetails struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DomainDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainDetails) GoString() string {
	return s.String()
}

// Representation of a abnormal or suspicious activity.
type Finding struct {
	_ struct{} `type:"structure"`

	// AWS account ID where the activity occurred that prompted GuardDuty to generate
	// a finding.
	AccountId *string `locationName:"accountId" type:"string"`

	// The ARN of a finding described by the action.
	Arn *string `locationName:"arn" type:"string"`

	// The confidence level of a finding.
	Confidence *float64 `locationName:"confidence" type:"double"`

	// The time stamp at which a finding was generated.
	CreatedAt *string `locationName:"createdAt" type:"string"`

	// The description of a finding.
	Description *string `locationName:"description" type:"string"`

	// The identifier that corresponds to a finding described by the action.
	Id *string `locationName:"id" type:"string"`

	// The AWS resource partition.
	Partition *string `locationName:"partition" type:"string"`

	// The AWS region where the activity occurred that prompted GuardDuty to generate
	// a finding.
	Region *string `locationName:"region" type:"string"`

	// The AWS resource associated with the activity that prompted GuardDuty to
	// generate a finding.
	Resource *Resource `locationName:"resource" type:"structure"`

	// Findings' schema version.
	SchemaVersion *string `locationName:"schemaVersion" type:"string"`

	// Additional information assigned to the generated finding by GuardDuty.
	Service *Service `locationName:"service" type:"structure"`

	// The severity of a finding.
	Severity *float64 `locationName:"severity" type:"double"`

	// The title of a finding.
	Title *string `locationName:"title" type:"string"`

	// The type of a finding described by the action.
	Type *string `locationName:"type" type:"string"`

	// The time stamp at which a finding was last updated.
	UpdatedAt *string `locationName:"updatedAt" type:"string"`
}

// String returns the string representation
func (s Finding) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Finding) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *Finding) SetAccountId(v string) *Finding {
	s.AccountId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *Finding) SetArn(v string) *Finding {
	s.Arn = &v
	return s
}

// SetConfidence sets the Confidence field's value.
func (s *Finding) SetConfidence(v float64) *Finding {
	s.Confidence = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Finding) SetCreatedAt(v string) *Finding {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Finding) SetDescription(v string) *Finding {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *Finding) SetId(v string) *Finding {
	s.Id = &v
	return s
}

// SetPartition sets the Partition field's value.
func (s *Finding) SetPartition(v string) *Finding {
	s.Partition = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *Finding) SetRegion(v string) *Finding {
	s.Region = &v
	return s
}

// SetResource sets the Resource field's value.
func (s *Finding) SetResource(v *Resource) *Finding {
	s.Resource = v
	return s
}

// SetSchemaVersion sets the SchemaVersion field's value.
func (s *Finding) SetSchemaVersion(v string) *Finding {
	s.SchemaVersion = &v
	return s
}

// SetService sets the Service field's value.
func (s *Finding) SetService(v *Service) *Finding {
	s.Service = v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *Finding) SetSeverity(v float64) *Finding {
	s.Severity = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *Finding) SetTitle(v string) *Finding {
	s.Title = &v
	return s
}

// SetType sets the Type field's value.
func (s *Finding) SetType(v string) *Finding {
	s.Type = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *Finding) SetUpdatedAt(v string) *Finding {
	s.UpdatedAt = &v
	return s
}

// Represents the criteria used for querying findings.
type FindingCriteria struct {
	_ struct{} `type:"structure"`

	// Represents a map of finding properties that match specified conditions and
	// values when querying findings.
	Criterion map[string]*Condition `locationName:"criterion" type:"map"`
}

// String returns the string representation
func (s FindingCriteria) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FindingCriteria) GoString() string {
	return s.String()
}

// SetCriterion sets the Criterion field's value.
func (s *FindingCriteria) SetCriterion(v map[string]*Condition) *FindingCriteria {
	s.Criterion = v
	return s
}

// Finding statistics object.
type FindingStatistics struct {
	_ struct{} `type:"structure"`

	// Represents a map of severity to count statistic for a set of findings
	CountBySeverity map[string]*int64 `locationName:"countBySeverity" type:"map"`
}

// String returns the string representation
func (s FindingStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FindingStatistics) GoString() string {
	return s.String()
}

// SetCountBySeverity sets the CountBySeverity field's value.
func (s *FindingStatistics) SetCountBySeverity(v map[string]*int64) *FindingStatistics {
	s.CountBySeverity = v
	return s
}

// Location information of the remote IP address.
type GeoLocation struct {
	_ struct{} `type:"structure"`

	// Latitude information of remote IP address.
	Lat *float64 `locationName:"lat" type:"double"`

	// Longitude information of remote IP address.
	Lon *float64 `locationName:"lon" type:"double"`
}

// String returns the string representation
func (s GeoLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GeoLocation) GoString() string {
	return s.String()
}

// SetLat sets the Lat field's value.
func (s *GeoLocation) SetLat(v float64) *GeoLocation {
	s.Lat = &v
	return s
}

// SetLon sets the Lon field's value.
func (s *GeoLocation) SetLon(v float64) *GeoLocation {
	s.Lon = &v
	return s
}

type GetDetectorInput struct {
	_ struct{} `type:"structure"`

	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDetectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDetectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDetectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDetectorInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *GetDetectorInput) SetDetectorId(v string) *GetDetectorInput {
	s.DetectorId = &v
	return s
}

// GetDetector response object.
type GetDetectorOutput struct {
	_ struct{} `type:"structure"`

	// The first time a resource was created. The format will be ISO-8601.
	CreatedAt *string `locationName:"createdAt" type:"string"`

	// Customer serviceRole name or ARN for accessing customer resources
	ServiceRole *string `locationName:"serviceRole" type:"string"`

	// The status of detector.
	Status *string `locationName:"status" type:"string" enum:"DetectorStatus"`

	// The first time a resource was created. The format will be ISO-8601.
	UpdatedAt *string `locationName:"updatedAt" type:"string"`
}

// String returns the string representation
func (s GetDetectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDetectorOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetDetectorOutput) SetCreatedAt(v string) *GetDetectorOutput {
	s.CreatedAt = &v
	return s
}

// SetServiceRole sets the ServiceRole field's value.
func (s *GetDetectorOutput) SetServiceRole(v string) *GetDetectorOutput {
	s.ServiceRole = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetDetectorOutput) SetStatus(v string) *GetDetectorOutput {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetDetectorOutput) SetUpdatedAt(v string) *GetDetectorOutput {
	s.UpdatedAt = &v
	return s
}

// Get Findings Request
type GetFindingsInput struct {
	_ struct{} `type:"structure"`

	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" type:"string" required:"true"`

	// IDs of the findings that you want to retrieve.
	FindingIds []*string `locationName:"findingIds" type:"list"`

	// Represents the criteria used for sorting findings.
	SortCriteria *SortCriteria `locationName:"sortCriteria" type:"structure"`
}

// String returns the string representation
func (s GetFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFindingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFindingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFindingsInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *GetFindingsInput) SetDetectorId(v string) *GetFindingsInput {
	s.DetectorId = &v
	return s
}

// SetFindingIds sets the FindingIds field's value.
func (s *GetFindingsInput) SetFindingIds(v []*string) *GetFindingsInput {
	s.FindingIds = v
	return s
}

// SetSortCriteria sets the SortCriteria field's value.
func (s *GetFindingsInput) SetSortCriteria(v *SortCriteria) *GetFindingsInput {
	s.SortCriteria = v
	return s
}

// GetFindings response object.
type GetFindingsOutput struct {
	_ struct{} `type:"structure"`

	// A list of findings.
	Findings []*Finding `locationName:"findings" type:"list"`
}

// String returns the string representation
func (s GetFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFindingsOutput) GoString() string {
	return s.String()
}

// SetFindings sets the Findings field's value.
func (s *GetFindingsOutput) SetFindings(v []*Finding) *GetFindingsOutput {
	s.Findings = v
	return s
}

// Get Findings Statistics Request
type GetFindingsStatisticsInput struct {
	_ struct{} `type:"structure"`

	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" type:"string" required:"true"`

	// Represents the criteria used for querying findings.
	FindingCriteria *FindingCriteria `locationName:"findingCriteria" type:"structure"`

	// Types of finding statistics to retrieve.
	FindingStatisticTypes []*string `locationName:"findingStatisticTypes" type:"list"`
}

// String returns the string representation
func (s GetFindingsStatisticsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFindingsStatisticsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFindingsStatisticsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFindingsStatisticsInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *GetFindingsStatisticsInput) SetDetectorId(v string) *GetFindingsStatisticsInput {
	s.DetectorId = &v
	return s
}

// SetFindingCriteria sets the FindingCriteria field's value.
func (s *GetFindingsStatisticsInput) SetFindingCriteria(v *FindingCriteria) *GetFindingsStatisticsInput {
	s.FindingCriteria = v
	return s
}

// SetFindingStatisticTypes sets the FindingStatisticTypes field's value.
func (s *GetFindingsStatisticsInput) SetFindingStatisticTypes(v []*string) *GetFindingsStatisticsInput {
	s.FindingStatisticTypes = v
	return s
}

// GetFindingsStatistics response object.
type GetFindingsStatisticsOutput struct {
	_ struct{} `type:"structure"`

	// Finding statistics object.
	FindingStatistics *FindingStatistics `locationName:"findingStatistics" type:"structure"`
}

// String returns the string representation
func (s GetFindingsStatisticsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFindingsStatisticsOutput) GoString() string {
	return s.String()
}

// SetFindingStatistics sets the FindingStatistics field's value.
func (s *GetFindingsStatisticsOutput) SetFindingStatistics(v *FindingStatistics) *GetFindingsStatisticsOutput {
	s.FindingStatistics = v
	return s
}

type GetIPSetInput struct {
	_ struct{} `type:"structure"`

	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" type:"string" required:"true"`

	// IpSetId is a required field
	IpSetId *string `location:"uri" locationName:"ipSetId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetIPSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIPSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIPSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIPSetInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.IpSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("IpSetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *GetIPSetInput) SetDetectorId(v string) *GetIPSetInput {
	s.DetectorId = &v
	return s
}

// SetIpSetId sets the IpSetId field's value.
func (s *GetIPSetInput) SetIpSetId(v string) *GetIPSetInput {
	s.IpSetId = &v
	return s
}

// GetIPSet response object.
type GetIPSetOutput struct {
	_ struct{} `type:"structure"`

	// The format of the file that contains the IPSet.
	Format *string `locationName:"format" type:"string" enum:"IpSetFormat"`

	// The URI of the file that contains the IPSet. For example (https://s3.us-west-2.amazonaws.com/my-bucket/my-object-key)
	Location *string `locationName:"location" type:"string"`

	// The user friendly name to identify the IPSet. This name is displayed in all
	// findings that are triggered by activity that involves IP addresses included
	// in this IPSet.
	Name *string `locationName:"name" type:"string"`

	// The status of ipSet file uploaded.
	Status *string `locationName:"status" type:"string" enum:"IpSetStatus"`
}

// String returns the string representation
func (s GetIPSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIPSetOutput) GoString() string {
	return s.String()
}

// SetFormat sets the Format field's value.
func (s *GetIPSetOutput) SetFormat(v string) *GetIPSetOutput {
	s.Format = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *GetIPSetOutput) SetLocation(v string) *GetIPSetOutput {
	s.Location = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetIPSetOutput) SetName(v string) *GetIPSetOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetIPSetOutput) SetStatus(v string) *GetIPSetOutput {
	s.Status = &v
	return s
}

type GetInvitationsCountInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetInvitationsCountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInvitationsCountInput) GoString() string {
	return s.String()
}

// GetInvitationsCount response object.
type GetInvitationsCountOutput struct {
	_ struct{} `type:"structure"`

	// The number of received invitations.
	InvitationsCount *int64 `locationName:"invitationsCount" type:"integer"`
}

// String returns the string representation
func (s GetInvitationsCountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInvitationsCountOutput) GoString() string {
	return s.String()
}

// SetInvitationsCount sets the InvitationsCount field's value.
func (s *GetInvitationsCountOutput) SetInvitationsCount(v int64) *GetInvitationsCountOutput {
	s.InvitationsCount = &v
	return s
}

type GetMasterAccountInput struct {
	_ struct{} `type:"structure"`

	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetMasterAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMasterAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMasterAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMasterAccountInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *GetMasterAccountInput) SetDetectorId(v string) *GetMasterAccountInput {
	s.DetectorId = &v
	return s
}

// GetMasterAccount response object.
type GetMasterAccountOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about the master account.
	Master *Master `locationName:"master" type:"structure"`
}

// String returns the string representation
func (s GetMasterAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMasterAccountOutput) GoString() string {
	return s.String()
}

// SetMaster sets the Master field's value.
func (s *GetMasterAccountOutput) SetMaster(v *Master) *GetMasterAccountOutput {
	s.Master = v
	return s
}

// GetMembers request body.
type GetMembersInput struct {
	_ struct{} `type:"structure"`

	// A list of account IDs of the GuardDuty member accounts that you want to describe.
	AccountIds []*string `locationName:"accountIds" type:"list"`

	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMembersInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *GetMembersInput) SetAccountIds(v []*string) *GetMembersInput {
	s.AccountIds = v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *GetMembersInput) SetDetectorId(v string) *GetMembersInput {
	s.DetectorId = &v
	return s
}

// GetMembers response object.
type GetMembersOutput struct {
	_ struct{} `type:"structure"`

	// A list of member descriptions.
	Members []*Member `locationName:"members" type:"list"`

	// A list of objects containing the unprocessed account and a result string
	// explaining why it was unprocessed.
	UnprocessedAccounts []*UnprocessedAccount `locationName:"unprocessedAccounts" type:"list"`
}

// String returns the string representation
func (s GetMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMembersOutput) GoString() string {
	return s.String()
}

// SetMembers sets the Members field's value.
func (s *GetMembersOutput) SetMembers(v []*Member) *GetMembersOutput {
	s.Members = v
	return s
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *GetMembersOutput) SetUnprocessedAccounts(v []*UnprocessedAccount) *GetMembersOutput {
	s.UnprocessedAccounts = v
	return s
}

type GetThreatIntelSetInput struct {
	_ struct{} `type:"structure"`

	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" type:"string" required:"true"`

	// ThreatIntelSetId is a required field
	ThreatIntelSetId *string `location:"uri" locationName:"threatIntelSetId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetThreatIntelSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetThreatIntelSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetThreatIntelSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetThreatIntelSetInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.ThreatIntelSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("ThreatIntelSetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *GetThreatIntelSetInput) SetDetectorId(v string) *GetThreatIntelSetInput {
	s.DetectorId = &v
	return s
}

// SetThreatIntelSetId sets the ThreatIntelSetId field's value.
func (s *GetThreatIntelSetInput) SetThreatIntelSetId(v string) *GetThreatIntelSetInput {
	s.ThreatIntelSetId = &v
	return s
}

// GetThreatIntelSet response object
type GetThreatIntelSetOutput struct {
	_ struct{} `type:"structure"`

	// The format of the threatIntelSet.
	Format *string `locationName:"format" type:"string" enum:"ThreatIntelSetFormat"`

	// The URI of the file that contains the ThreatIntelSet. For example (https://s3.us-west-2.amazonaws.com/my-bucket/my-object-key).
	Location *string `locationName:"location" type:"string"`

	// A user-friendly ThreatIntelSet name that is displayed in all finding generated
	// by activity that involves IP addresses included in this ThreatIntelSet.
	Name *string `locationName:"name" type:"string"`

	// The status of threatIntelSet file uploaded.
	Status *string `locationName:"status" type:"string" enum:"ThreatIntelSetStatus"`
}

// String returns the string representation
func (s GetThreatIntelSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetThreatIntelSetOutput) GoString() string {
	return s.String()
}

// SetFormat sets the Format field's value.
func (s *GetThreatIntelSetOutput) SetFormat(v string) *GetThreatIntelSetOutput {
	s.Format = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *GetThreatIntelSetOutput) SetLocation(v string) *GetThreatIntelSetOutput {
	s.Location = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetThreatIntelSetOutput) SetName(v string) *GetThreatIntelSetOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetThreatIntelSetOutput) SetStatus(v string) *GetThreatIntelSetOutput {
	s.Status = &v
	return s
}

// The profile information of the EC2 instance.
type IamInstanceProfile struct {
	_ struct{} `type:"structure"`

	// AWS EC2 instance profile ARN.
	Arn *string `locationName:"arn" type:"string"`

	// AWS EC2 instance profile ID.
	Id *string `locationName:"id" type:"string"`
}

// String returns the string representation
func (s IamInstanceProfile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IamInstanceProfile) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *IamInstanceProfile) SetArn(v string) *IamInstanceProfile {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *IamInstanceProfile) SetId(v string) *IamInstanceProfile {
	s.Id = &v
	return s
}

// The information about the EC2 instance associated with the activity that
// prompted GuardDuty to generate a finding.
type InstanceDetails struct {
	_ struct{} `type:"structure"`

	// The availability zone of the EC2 instance.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The profile information of the EC2 instance.
	IamInstanceProfile *IamInstanceProfile `locationName:"iamInstanceProfile" type:"structure"`

	// The image ID of the EC2 instance.
	ImageId *string `locationName:"imageId" type:"string"`

	// The ID of the EC2 instance.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// The state of the EC2 instance.
	InstanceState *string `locationName:"instanceState" type:"string"`

	// The type of the EC2 instance.
	InstanceType *string `locationName:"instanceType" type:"string"`

	// The launch time of the EC2 instance.
	LaunchTime *string `locationName:"launchTime" type:"string"`

	// The network interface information of the EC2 instance.
	NetworkInterfaces []*NetworkInterface `locationName:"networkInterfaces" type:"list"`

	// The platform of the EC2 instance.
	Platform *string `locationName:"platform" type:"string"`

	// The product code of the EC2 instance.
	ProductCodes []*ProductCode `locationName:"productCodes" type:"list"`

	// The tags of the EC2 instance.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s InstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceDetails) GoString() string {
	return s.String()
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *InstanceDetails) SetAvailabilityZone(v string) *InstanceDetails {
	s.AvailabilityZone = &v
	return s
}

// SetIamInstanceProfile sets the IamInstanceProfile field's value.
func (s *InstanceDetails) SetIamInstanceProfile(v *IamInstanceProfile) *InstanceDetails {
	s.IamInstanceProfile = v
	return s
}

// SetImageId sets the ImageId field's value.
func (s *InstanceDetails) SetImageId(v string) *InstanceDetails {
	s.ImageId = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *InstanceDetails) SetInstanceId(v string) *InstanceDetails {
	s.InstanceId = &v
	return s
}

// SetInstanceState sets the InstanceState field's value.
func (s *InstanceDetails) SetInstanceState(v string) *InstanceDetails {
	s.InstanceState = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *InstanceDetails) SetInstanceType(v string) *InstanceDetails {
	s.InstanceType = &v
	return s
}

// SetLaunchTime sets the LaunchTime field's value.
func (s *InstanceDetails) SetLaunchTime(v string) *InstanceDetails {
	s.LaunchTime = &v
	return s
}

// SetNetworkInterfaces sets the NetworkInterfaces field's value.
func (s *InstanceDetails) SetNetworkInterfaces(v []*NetworkInterface) *InstanceDetails {
	s.NetworkInterfaces = v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *InstanceDetails) SetPlatform(v string) *InstanceDetails {
	s.Platform = &v
	return s
}

// SetProductCodes sets the ProductCodes field's value.
func (s *InstanceDetails) SetProductCodes(v []*ProductCode) *InstanceDetails {
	s.ProductCodes = v
	return s
}

// SetTags sets the Tags field's value.
func (s *InstanceDetails) SetTags(v []*Tag) *InstanceDetails {
	s.Tags = v
	return s
}

// Invitation from an AWS account to become the current account's master.
type Invitation struct {
	_ struct{} `type:"structure"`

	// Inviter account ID
	AccountId *string `locationName:"accountId" type:"string"`

	// This value is used to validate the inviter account to the member account.
	InvitationId *string `locationName:"invitationId" type:"string"`

	// Timestamp at which the invitation was sent
	InvitedAt *string `locationName:"invitedAt" type:"string"`

	// The status of the relationship between the inviter and invitee accounts.
	RelationshipStatus *string `locationName:"relationshipStatus" type:"string"`
}

// String returns the string representation
func (s Invitation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Invitation) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *Invitation) SetAccountId(v string) *Invitation {
	s.AccountId = &v
	return s
}

// SetInvitationId sets the InvitationId field's value.
func (s *Invitation) SetInvitationId(v string) *Invitation {
	s.InvitationId = &v
	return s
}

// SetInvitedAt sets the InvitedAt field's value.
func (s *Invitation) SetInvitedAt(v string) *Invitation {
	s.InvitedAt = &v
	return s
}

// SetRelationshipStatus sets the RelationshipStatus field's value.
func (s *Invitation) SetRelationshipStatus(v string) *Invitation {
	s.RelationshipStatus = &v
	return s
}

// InviteMembers request body.
type InviteMembersInput struct {
	_ struct{} `type:"structure"`

	// A list of account IDs of the accounts that you want to invite to GuardDuty
	// as members.
	AccountIds []*string `locationName:"accountIds" type:"list"`

	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" type:"string" required:"true"`

	// The invitation message that you want to send to the accounts that you're
	// inviting to GuardDuty as members.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InviteMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InviteMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InviteMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InviteMembersInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *InviteMembersInput) SetAccountIds(v []*string) *InviteMembersInput {
	s.AccountIds = v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *InviteMembersInput) SetDetectorId(v string) *InviteMembersInput {
	s.DetectorId = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *InviteMembersInput) SetMessage(v string) *InviteMembersInput {
	s.Message = &v
	return s
}

// InviteMembers response object.
type InviteMembersOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects containing the unprocessed account and a result string
	// explaining why it was unprocessed.
	UnprocessedAccounts []*UnprocessedAccount `locationName:"unprocessedAccounts" type:"list"`
}

// String returns the string representation
func (s InviteMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InviteMembersOutput) GoString() string {
	return s.String()
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *InviteMembersOutput) SetUnprocessedAccounts(v []*UnprocessedAccount) *InviteMembersOutput {
	s.UnprocessedAccounts = v
	return s
}

type ListDetectorsInput struct {
	_ struct{} `type:"structure"`

	// You can use this parameter to indicate the maximum number of items that you
	// want in the response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDetectorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDetectorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDetectorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDetectorsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDetectorsInput) SetMaxResults(v int64) *ListDetectorsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDetectorsInput) SetNextToken(v string) *ListDetectorsInput {
	s.NextToken = &v
	return s
}

// ListDetectors response object.
type ListDetectorsOutput struct {
	_ struct{} `type:"structure"`

	// A list of detector Ids.
	DetectorIds []*string `locationName:"detectorIds" type:"list"`

	// You can use this parameter when paginating results. Set the value of this
	// parameter to null on your first call to the list action. For subsequent calls
	// to the action fill nextToken in the request with the value of NextToken from
	// the previous response to continue listing data.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDetectorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDetectorsOutput) GoString() string {
	return s.String()
}

// SetDetectorIds sets the DetectorIds field's value.
func (s *ListDetectorsOutput) SetDetectorIds(v []*string) *ListDetectorsOutput {
	s.DetectorIds = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDetectorsOutput) SetNextToken(v string) *ListDetectorsOutput {
	s.NextToken = &v
	return s
}

// List Findings Request
type ListFindingsInput struct {
	_ struct{} `type:"structure"`

	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" type:"string" required:"true"`

	// Represents the criteria used for querying findings.
	FindingCriteria *FindingCriteria `locationName:"findingCriteria" type:"structure"`

	// You can use this parameter to indicate the maximum number of items you want
	// in the response. The default value is 50. The maximum value is 50.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// You can use this parameter when paginating results. Set the value of this
	// parameter to null on your first call to the ListFindings action. For subsequent
	// calls to the action fill nextToken in the request with the value of nextToken
	// from the previous response to continue listing data.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Represents the criteria used for sorting findings.
	SortCriteria *SortCriteria `locationName:"sortCriteria" type:"structure"`
}

// String returns the string representation
func (s ListFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFindingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFindingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFindingsInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *ListFindingsInput) SetDetectorId(v string) *ListFindingsInput {
	s.DetectorId = &v
	return s
}

// SetFindingCriteria sets the FindingCriteria field's value.
func (s *ListFindingsInput) SetFindingCriteria(v *FindingCriteria) *ListFindingsInput {
	s.FindingCriteria = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFindingsInput) SetMaxResults(v int64) *ListFindingsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFindingsInput) SetNextToken(v string) *ListFindingsInput {
	s.NextToken = &v
	return s
}

// SetSortCriteria sets the SortCriteria field's value.
func (s *ListFindingsInput) SetSortCriteria(v *SortCriteria) *ListFindingsInput {
	s.SortCriteria = v
	return s
}

// ListFindings response object.
type ListFindingsOutput struct {
	_ struct{} `type:"structure"`

	// The list of the Findings.
	FindingIds []*string `locationName:"findingIds" type:"list"`

	// You can use this parameter when paginating results. Set the value of this
	// parameter to null on your first call to the list action. For subsequent calls
	// to the action fill nextToken in the request with the value of NextToken from
	// the previous response to continue listing data.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFindingsOutput) GoString() string {
	return s.String()
}

// SetFindingIds sets the FindingIds field's value.
func (s *ListFindingsOutput) SetFindingIds(v []*string) *ListFindingsOutput {
	s.FindingIds = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFindingsOutput) SetNextToken(v string) *ListFindingsOutput {
	s.NextToken = &v
	return s
}

type ListIPSetsInput struct {
	_ struct{} `type:"structure"`

	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" type:"string" required:"true"`

	// You can use this parameter to indicate the maximum number of items that you
	// want in the response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListIPSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIPSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIPSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIPSetsInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *ListIPSetsInput) SetDetectorId(v string) *ListIPSetsInput {
	s.DetectorId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListIPSetsInput) SetMaxResults(v int64) *ListIPSetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIPSetsInput) SetNextToken(v string) *ListIPSetsInput {
	s.NextToken = &v
	return s
}

// ListIPSets response object.
type ListIPSetsOutput struct {
	_ struct{} `type:"structure"`

	// A list of the IP set IDs
	IpSetIds []*string `locationName:"ipSetIds" type:"list"`

	// You can use this parameter when paginating results. Set the value of this
	// parameter to null on your first call to the list action. For subsequent calls
	// to the action fill nextToken in the request with the value of NextToken from
	// the previous response to continue listing data.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListIPSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIPSetsOutput) GoString() string {
	return s.String()
}

// SetIpSetIds sets the IpSetIds field's value.
func (s *ListIPSetsOutput) SetIpSetIds(v []*string) *ListIPSetsOutput {
	s.IpSetIds = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIPSetsOutput) SetNextToken(v string) *ListIPSetsOutput {
	s.NextToken = &v
	return s
}

type ListInvitationsInput struct {
	_ struct{} `type:"structure"`

	// You can use this parameter to indicate the maximum number of items that you
	// want in the response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListInvitationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInvitationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInvitationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInvitationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListInvitationsInput) SetMaxResults(v int64) *ListInvitationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInvitationsInput) SetNextToken(v string) *ListInvitationsInput {
	s.NextToken = &v
	return s
}

// ListInvitations response object.
type ListInvitationsOutput struct {
	_ struct{} `type:"structure"`

	// A list of invitation descriptions.
	Invitations []*Invitation `locationName:"invitations" type:"list"`

	// You can use this parameter when paginating results. Set the value of this
	// parameter to null on your first call to the list action. For subsequent calls
	// to the action fill nextToken in the request with the value of NextToken from
	// the previous response to continue listing data.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListInvitationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInvitationsOutput) GoString() string {
	return s.String()
}

// SetInvitations sets the Invitations field's value.
func (s *ListInvitationsOutput) SetInvitations(v []*Invitation) *ListInvitationsOutput {
	s.Invitations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInvitationsOutput) SetNextToken(v string) *ListInvitationsOutput {
	s.NextToken = &v
	return s
}

type ListMembersInput struct {
	_ struct{} `type:"structure"`

	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" type:"string" required:"true"`

	// You can use this parameter to indicate the maximum number of items that you
	// want in the response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	OnlyAssociated *string `location:"querystring" locationName:"onlyAssociated" type:"string"`
}

// String returns the string representation
func (s ListMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMembersInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *ListMembersInput) SetDetectorId(v string) *ListMembersInput {
	s.DetectorId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMembersInput) SetMaxResults(v int64) *ListMembersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMembersInput) SetNextToken(v string) *ListMembersInput {
	s.NextToken = &v
	return s
}

// SetOnlyAssociated sets the OnlyAssociated field's value.
func (s *ListMembersInput) SetOnlyAssociated(v string) *ListMembersInput {
	s.OnlyAssociated = &v
	return s
}

// ListMembers response object.
type ListMembersOutput struct {
	_ struct{} `type:"structure"`

	// A list of member descriptions.
	Members []*Member `locationName:"members" type:"list"`

	// You can use this parameter when paginating results. Set the value of this
	// parameter to null on your first call to the list action. For subsequent calls
	// to the action fill nextToken in the request with the value of NextToken from
	// the previous response to continue listing data.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMembersOutput) GoString() string {
	return s.String()
}

// SetMembers sets the Members field's value.
func (s *ListMembersOutput) SetMembers(v []*Member) *ListMembersOutput {
	s.Members = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMembersOutput) SetNextToken(v string) *ListMembersOutput {
	s.NextToken = &v
	return s
}

type ListThreatIntelSetsInput struct {
	_ struct{} `type:"structure"`

	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" type:"string" required:"true"`

	// You can use this parameter to indicate the maximum number of items that you
	// want in the response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListThreatIntelSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListThreatIntelSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListThreatIntelSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListThreatIntelSetsInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *ListThreatIntelSetsInput) SetDetectorId(v string) *ListThreatIntelSetsInput {
	s.DetectorId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListThreatIntelSetsInput) SetMaxResults(v int64) *ListThreatIntelSetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListThreatIntelSetsInput) SetNextToken(v string) *ListThreatIntelSetsInput {
	s.NextToken = &v
	return s
}

// ListThreatIntelSets response object.
type ListThreatIntelSetsOutput struct {
	_ struct{} `type:"structure"`

	// You can use this parameter when paginating results. Set the value of this
	// parameter to null on your first call to the list action. For subsequent calls
	// to the action fill nextToken in the request with the value of NextToken from
	// the previous response to continue listing data.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The list of the threat intel set IDs
	ThreatIntelSetIds []*string `locationName:"threatIntelSetIds" type:"list"`
}

// String returns the string representation
func (s ListThreatIntelSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListThreatIntelSetsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListThreatIntelSetsOutput) SetNextToken(v string) *ListThreatIntelSetsOutput {
	s.NextToken = &v
	return s
}

// SetThreatIntelSetIds sets the ThreatIntelSetIds field's value.
func (s *ListThreatIntelSetsOutput) SetThreatIntelSetIds(v []*string) *ListThreatIntelSetsOutput {
	s.ThreatIntelSetIds = v
	return s
}

// Local port information of the connection.
type LocalPortDetails struct {
	_ struct{} `type:"structure"`

	// Port number of the local connection.
	Port *int64 `locationName:"port" type:"integer"`

	// Port name of the local connection.
	PortName *string `locationName:"portName" type:"string"`
}

// String returns the string representation
func (s LocalPortDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LocalPortDetails) GoString() string {
	return s.String()
}

// SetPort sets the Port field's value.
func (s *LocalPortDetails) SetPort(v int64) *LocalPortDetails {
	s.Port = &v
	return s
}

// SetPortName sets the PortName field's value.
func (s *LocalPortDetails) SetPortName(v string) *LocalPortDetails {
	s.PortName = &v
	return s
}

// Contains details about the master account.
type Master struct {
	_ struct{} `type:"structure"`

	// Master account ID
	AccountId *string `locationName:"accountId" type:"string"`

	// This value is used to validate the master account to the member account.
	InvitationId *string `locationName:"invitationId" type:"string"`

	// Timestamp at which the invitation was sent
	InvitedAt *string `locationName:"invitedAt" type:"string"`

	// The status of the relationship between the master and member accounts.
	RelationshipStatus *string `locationName:"relationshipStatus" type:"string"`
}

// String returns the string representation
func (s Master) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Master) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *Master) SetAccountId(v string) *Master {
	s.AccountId = &v
	return s
}

// SetInvitationId sets the InvitationId field's value.
func (s *Master) SetInvitationId(v string) *Master {
	s.InvitationId = &v
	return s
}

// SetInvitedAt sets the InvitedAt field's value.
func (s *Master) SetInvitedAt(v string) *Master {
	s.InvitedAt = &v
	return s
}

// SetRelationshipStatus sets the RelationshipStatus field's value.
func (s *Master) SetRelationshipStatus(v string) *Master {
	s.RelationshipStatus = &v
	return s
}

// Contains details about the member account.
type Member struct {
	_ struct{} `type:"structure"`

	// AWS account ID.
	AccountId *string `locationName:"accountId" type:"string"`

	// The unique identifier for a detector.
	DetectorId *string `locationName:"detectorId" type:"string"`

	// Member account's email address.
	Email *string `locationName:"email" type:"string"`

	// Timestamp at which the invitation was sent
	InvitedAt *string `locationName:"invitedAt" type:"string"`

	// The master account ID.
	MasterId *string `locationName:"masterId" type:"string"`

	// The status of the relationship between the member and the master.
	RelationshipStatus *string `locationName:"relationshipStatus" type:"string"`

	// The first time a resource was created. The format will be ISO-8601.
	UpdatedAt *string `locationName:"updatedAt" type:"string"`
}

// String returns the string representation
func (s Member) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Member) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *Member) SetAccountId(v string) *Member {
	s.AccountId = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *Member) SetDetectorId(v string) *Member {
	s.DetectorId = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *Member) SetEmail(v string) *Member {
	s.Email = &v
	return s
}

// SetInvitedAt sets the InvitedAt field's value.
func (s *Member) SetInvitedAt(v string) *Member {
	s.InvitedAt = &v
	return s
}

// SetMasterId sets the MasterId field's value.
func (s *Member) SetMasterId(v string) *Member {
	s.MasterId = &v
	return s
}

// SetRelationshipStatus sets the RelationshipStatus field's value.
func (s *Member) SetRelationshipStatus(v string) *Member {
	s.RelationshipStatus = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *Member) SetUpdatedAt(v string) *Member {
	s.UpdatedAt = &v
	return s
}

// Information about the NETWORK_CONNECTION action described in this finding.
type NetworkConnectionAction struct {
	_ struct{} `type:"structure"`

	// Network connection blocked information.
	Blocked *bool `locationName:"blocked" type:"boolean"`

	// Network connection direction.
	ConnectionDirection *string `locationName:"connectionDirection" type:"string"`

	// Local port information of the connection.
	LocalPortDetails *LocalPortDetails `locationName:"localPortDetails" type:"structure"`

	// Network connection protocol.
	Protocol *string `locationName:"protocol" type:"string"`

	// Remote IP information of the connection.
	RemoteIpDetails *RemoteIpDetails `locationName:"remoteIpDetails" type:"structure"`

	// Remote port information of the connection.
	RemotePortDetails *RemotePortDetails `locationName:"remotePortDetails" type:"structure"`
}

// String returns the string representation
func (s NetworkConnectionAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NetworkConnectionAction) GoString() string {
	return s.String()
}

// SetBlocked sets the Blocked field's value.
func (s *NetworkConnectionAction) SetBlocked(v bool) *NetworkConnectionAction {
	s.Blocked = &v
	return s
}

// SetConnectionDirection sets the ConnectionDirection field's value.
func (s *NetworkConnectionAction) SetConnectionDirection(v string) *NetworkConnectionAction {
	s.ConnectionDirection = &v
	return s
}

// SetLocalPortDetails sets the LocalPortDetails field's value.
func (s *NetworkConnectionAction) SetLocalPortDetails(v *LocalPortDetails) *NetworkConnectionAction {
	s.LocalPortDetails = v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *NetworkConnectionAction) SetProtocol(v string) *NetworkConnectionAction {
	s.Protocol = &v
	return s
}

// SetRemoteIpDetails sets the RemoteIpDetails field's value.
func (s *NetworkConnectionAction) SetRemoteIpDetails(v *RemoteIpDetails) *NetworkConnectionAction {
	s.RemoteIpDetails = v
	return s
}

// SetRemotePortDetails sets the RemotePortDetails field's value.
func (s *NetworkConnectionAction) SetRemotePortDetails(v *RemotePortDetails) *NetworkConnectionAction {
	s.RemotePortDetails = v
	return s
}

// The network interface information of the EC2 instance.
type NetworkInterface struct {
	_ struct{} `type:"structure"`

	// A list of EC2 instance IPv6 address information.
	Ipv6Addresses []*string `locationName:"ipv6Addresses" type:"list"`

	// Private DNS name of the EC2 instance.
	PrivateDnsName *string `locationName:"privateDnsName" type:"string"`

	// Private IP address of the EC2 instance.
	PrivateIpAddress *string `locationName:"privateIpAddress" type:"string"`

	// Other private IP address information of the EC2 instance.
	PrivateIpAddresses []*PrivateIpAddressDetails `locationName:"privateIpAddresses" type:"list"`

	// Public DNS name of the EC2 instance.
	PublicDnsName *string `locationName:"publicDnsName" type:"string"`

	// Public IP address of the EC2 instance.
	PublicIp *string `locationName:"publicIp" type:"string"`

	// Security groups associated with the EC2 instance.
	SecurityGroups []*SecurityGroup `locationName:"securityGroups" type:"list"`

	// The subnet ID of the EC2 instance.
	SubnetId *string `locationName:"subnetId" type:"string"`

	// The VPC ID of the EC2 instance.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s NetworkInterface) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NetworkInterface) GoString() string {
	return s.String()
}

// SetIpv6Addresses sets the Ipv6Addresses field's value.
func (s *NetworkInterface) SetIpv6Addresses(v []*string) *NetworkInterface {
	s.Ipv6Addresses = v
	return s
}

// SetPrivateDnsName sets the PrivateDnsName field's value.
func (s *NetworkInterface) SetPrivateDnsName(v string) *NetworkInterface {
	s.PrivateDnsName = &v
	return s
}

// SetPrivateIpAddress sets the PrivateIpAddress field's value.
func (s *NetworkInterface) SetPrivateIpAddress(v string) *NetworkInterface {
	s.PrivateIpAddress = &v
	return s
}

// SetPrivateIpAddresses sets the PrivateIpAddresses field's value.
func (s *NetworkInterface) SetPrivateIpAddresses(v []*PrivateIpAddressDetails) *NetworkInterface {
	s.PrivateIpAddresses = v
	return s
}

// SetPublicDnsName sets the PublicDnsName field's value.
func (s *NetworkInterface) SetPublicDnsName(v string) *NetworkInterface {
	s.PublicDnsName = &v
	return s
}

// SetPublicIp sets the PublicIp field's value.
func (s *NetworkInterface) SetPublicIp(v string) *NetworkInterface {
	s.PublicIp = &v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *NetworkInterface) SetSecurityGroups(v []*SecurityGroup) *NetworkInterface {
	s.SecurityGroups = v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *NetworkInterface) SetSubnetId(v string) *NetworkInterface {
	s.SubnetId = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *NetworkInterface) SetVpcId(v string) *NetworkInterface {
	s.VpcId = &v
	return s
}

// ISP Organization information of the remote IP address.
type Organization struct {
	_ struct{} `type:"structure"`

	// Autonomous system number of the internet provider of the remote IP address.
	Asn *string `locationName:"asn" type:"string"`

	// Organization that registered this ASN.
	AsnOrg *string `locationName:"asnOrg" type:"string"`

	// ISP information for the internet provider.
	Isp *string `locationName:"isp" type:"string"`

	// Name of the internet provider.
	Org *string `locationName:"org" type:"string"`
}

// String returns the string representation
func (s Organization) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Organization) GoString() string {
	return s.String()
}

// SetAsn sets the Asn field's value.
func (s *Organization) SetAsn(v string) *Organization {
	s.Asn = &v
	return s
}

// SetAsnOrg sets the AsnOrg field's value.
func (s *Organization) SetAsnOrg(v string) *Organization {
	s.AsnOrg = &v
	return s
}

// SetIsp sets the Isp field's value.
func (s *Organization) SetIsp(v string) *Organization {
	s.Isp = &v
	return s
}

// SetOrg sets the Org field's value.
func (s *Organization) SetOrg(v string) *Organization {
	s.Org = &v
	return s
}

// Information about the PORT_PROBE action described in this finding.
type PortProbeAction struct {
	_ struct{} `type:"structure"`

	// Port probe blocked information.
	Blocked *bool `locationName:"blocked" type:"boolean"`

	// A list of port probe details objects.
	PortProbeDetails []*PortProbeDetail `locationName:"portProbeDetails" type:"list"`
}

// String returns the string representation
func (s PortProbeAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PortProbeAction) GoString() string {
	return s.String()
}

// SetBlocked sets the Blocked field's value.
func (s *PortProbeAction) SetBlocked(v bool) *PortProbeAction {
	s.Blocked = &v
	return s
}

// SetPortProbeDetails sets the PortProbeDetails field's value.
func (s *PortProbeAction) SetPortProbeDetails(v []*PortProbeDetail) *PortProbeAction {
	s.PortProbeDetails = v
	return s
}

// Details about the port probe finding.
type PortProbeDetail struct {
	_ struct{} `type:"structure"`

	// Local port information of the connection.
	LocalPortDetails *LocalPortDetails `locationName:"localPortDetails" type:"structure"`

	// Remote IP information of the connection.
	RemoteIpDetails *RemoteIpDetails `locationName:"remoteIpDetails" type:"structure"`
}

// String returns the string representation
func (s PortProbeDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PortProbeDetail) GoString() string {
	return s.String()
}

// SetLocalPortDetails sets the LocalPortDetails field's value.
func (s *PortProbeDetail) SetLocalPortDetails(v *LocalPortDetails) *PortProbeDetail {
	s.LocalPortDetails = v
	return s
}

// SetRemoteIpDetails sets the RemoteIpDetails field's value.
func (s *PortProbeDetail) SetRemoteIpDetails(v *RemoteIpDetails) *PortProbeDetail {
	s.RemoteIpDetails = v
	return s
}

// Other private IP address information of the EC2 instance.
type PrivateIpAddressDetails struct {
	_ struct{} `type:"structure"`

	// Private DNS name of the EC2 instance.
	PrivateDnsName *string `locationName:"privateDnsName" type:"string"`

	// Private IP address of the EC2 instance.
	PrivateIpAddress *string `locationName:"privateIpAddress" type:"string"`
}

// String returns the string representation
func (s PrivateIpAddressDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PrivateIpAddressDetails) GoString() string {
	return s.String()
}

// SetPrivateDnsName sets the PrivateDnsName field's value.
func (s *PrivateIpAddressDetails) SetPrivateDnsName(v string) *PrivateIpAddressDetails {
	s.PrivateDnsName = &v
	return s
}

// SetPrivateIpAddress sets the PrivateIpAddress field's value.
func (s *PrivateIpAddressDetails) SetPrivateIpAddress(v string) *PrivateIpAddressDetails {
	s.PrivateIpAddress = &v
	return s
}

// The product code of the EC2 instance.
type ProductCode struct {
	_ struct{} `type:"structure"`

	// Product code information.
	Code *string `locationName:"code" type:"string"`

	// Product code type.
	ProductType *string `locationName:"productType" type:"string"`
}

// String returns the string representation
func (s ProductCode) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProductCode) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *ProductCode) SetCode(v string) *ProductCode {
	s.Code = &v
	return s
}

// SetProductType sets the ProductType field's value.
func (s *ProductCode) SetProductType(v string) *ProductCode {
	s.ProductType = &v
	return s
}

// Remote IP information of the connection.
type RemoteIpDetails struct {
	_ struct{} `type:"structure"`

	// City information of the remote IP address.
	City *City `locationName:"city" type:"structure"`

	// Country code of the remote IP address.
	Country *Country `locationName:"country" type:"structure"`

	// Location information of the remote IP address.
	GeoLocation *GeoLocation `locationName:"geoLocation" type:"structure"`

	// IPV4 remote address of the connection.
	IpAddressV4 *string `locationName:"ipAddressV4" type:"string"`

	// ISP Organization information of the remote IP address.
	Organization *Organization `locationName:"organization" type:"structure"`
}

// String returns the string representation
func (s RemoteIpDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoteIpDetails) GoString() string {
	return s.String()
}

// SetCity sets the City field's value.
func (s *RemoteIpDetails) SetCity(v *City) *RemoteIpDetails {
	s.City = v
	return s
}

// SetCountry sets the Country field's value.
func (s *RemoteIpDetails) SetCountry(v *Country) *RemoteIpDetails {
	s.Country = v
	return s
}

// SetGeoLocation sets the GeoLocation field's value.
func (s *RemoteIpDetails) SetGeoLocation(v *GeoLocation) *RemoteIpDetails {
	s.GeoLocation = v
	return s
}

// SetIpAddressV4 sets the IpAddressV4 field's value.
func (s *RemoteIpDetails) SetIpAddressV4(v string) *RemoteIpDetails {
	s.IpAddressV4 = &v
	return s
}

// SetOrganization sets the Organization field's value.
func (s *RemoteIpDetails) SetOrganization(v *Organization) *RemoteIpDetails {
	s.Organization = v
	return s
}

// Remote port information of the connection.
type RemotePortDetails struct {
	_ struct{} `type:"structure"`

	// Port number of the remote connection.
	Port *int64 `locationName:"port" type:"integer"`

	// Port name of the remote connection.
	PortName *string `locationName:"portName" type:"string"`
}

// String returns the string representation
func (s RemotePortDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemotePortDetails) GoString() string {
	return s.String()
}

// SetPort sets the Port field's value.
func (s *RemotePortDetails) SetPort(v int64) *RemotePortDetails {
	s.Port = &v
	return s
}

// SetPortName sets the PortName field's value.
func (s *RemotePortDetails) SetPortName(v string) *RemotePortDetails {
	s.PortName = &v
	return s
}

// The AWS resource associated with the activity that prompted GuardDuty to
// generate a finding.
type Resource struct {
	_ struct{} `type:"structure"`

	// The IAM access key details (IAM user information) of a user that engaged
	// in the activity that prompted GuardDuty to generate a finding.
	AccessKeyDetails *AccessKeyDetails `locationName:"accessKeyDetails" type:"structure"`

	// The information about the EC2 instance associated with the activity that
	// prompted GuardDuty to generate a finding.
	InstanceDetails *InstanceDetails `locationName:"instanceDetails" type:"structure"`

	// The type of the AWS resource.
	ResourceType *string `locationName:"resourceType" type:"string"`
}

// String returns the string representation
func (s Resource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Resource) GoString() string {
	return s.String()
}

// SetAccessKeyDetails sets the AccessKeyDetails field's value.
func (s *Resource) SetAccessKeyDetails(v *AccessKeyDetails) *Resource {
	s.AccessKeyDetails = v
	return s
}

// SetInstanceDetails sets the InstanceDetails field's value.
func (s *Resource) SetInstanceDetails(v *InstanceDetails) *Resource {
	s.InstanceDetails = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *Resource) SetResourceType(v string) *Resource {
	s.ResourceType = &v
	return s
}

// Security groups associated with the EC2 instance.
type SecurityGroup struct {
	_ struct{} `type:"structure"`

	// EC2 instance's security group ID.
	GroupId *string `locationName:"groupId" type:"string"`

	// EC2 instance's security group name.
	GroupName *string `locationName:"groupName" type:"string"`
}

// String returns the string representation
func (s SecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SecurityGroup) GoString() string {
	return s.String()
}

// SetGroupId sets the GroupId field's value.
func (s *SecurityGroup) SetGroupId(v string) *SecurityGroup {
	s.GroupId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *SecurityGroup) SetGroupName(v string) *SecurityGroup {
	s.GroupName = &v
	return s
}

// Additional information assigned to the generated finding by GuardDuty.
type Service struct {
	_ struct{} `type:"structure"`

	// Information about the activity described in a finding.
	Action *Action `locationName:"action" type:"structure"`

	// Indicates whether this finding is archived.
	Archived *bool `locationName:"archived" type:"boolean"`

	// Total count of the occurrences of this finding type.
	Count *int64 `locationName:"count" type:"integer"`

	// Detector ID for the GuardDuty service.
	DetectorId *string `locationName:"detectorId" type:"string"`

	// First seen timestamp of the activity that prompted GuardDuty to generate
	// this finding.
	EventFirstSeen *string `locationName:"eventFirstSeen" type:"string"`

	// Last seen timestamp of the activity that prompted GuardDuty to generate this
	// finding.
	EventLastSeen *string `locationName:"eventLastSeen" type:"string"`

	// Resource role information for this finding.
	ResourceRole *string `locationName:"resourceRole" type:"string"`

	// The name of the AWS service (GuardDuty) that generated a finding.
	ServiceName *string `locationName:"serviceName" type:"string"`

	// Feedback left about the finding.
	UserFeedback *string `locationName:"userFeedback" type:"string"`
}

// String returns the string representation
func (s Service) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Service) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *Service) SetAction(v *Action) *Service {
	s.Action = v
	return s
}

// SetArchived sets the Archived field's value.
func (s *Service) SetArchived(v bool) *Service {
	s.Archived = &v
	return s
}

// SetCount sets the Count field's value.
func (s *Service) SetCount(v int64) *Service {
	s.Count = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *Service) SetDetectorId(v string) *Service {
	s.DetectorId = &v
	return s
}

// SetEventFirstSeen sets the EventFirstSeen field's value.
func (s *Service) SetEventFirstSeen(v string) *Service {
	s.EventFirstSeen = &v
	return s
}

// SetEventLastSeen sets the EventLastSeen field's value.
func (s *Service) SetEventLastSeen(v string) *Service {
	s.EventLastSeen = &v
	return s
}

// SetResourceRole sets the ResourceRole field's value.
func (s *Service) SetResourceRole(v string) *Service {
	s.ResourceRole = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *Service) SetServiceName(v string) *Service {
	s.ServiceName = &v
	return s
}

// SetUserFeedback sets the UserFeedback field's value.
func (s *Service) SetUserFeedback(v string) *Service {
	s.UserFeedback = &v
	return s
}

// Represents the criteria used for sorting findings.
type SortCriteria struct {
	_ struct{} `type:"structure"`

	// Represents the finding attribute (for example, accountId) by which to sort
	// findings.
	AttributeName *string `locationName:"attributeName" type:"string"`

	// Order by which the sorted findings are to be displayed.
	OrderBy *string `locationName:"orderBy" type:"string" enum:"OrderBy"`
}

// String returns the string representation
func (s SortCriteria) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SortCriteria) GoString() string {
	return s.String()
}

// SetAttributeName sets the AttributeName field's value.
func (s *SortCriteria) SetAttributeName(v string) *SortCriteria {
	s.AttributeName = &v
	return s
}

// SetOrderBy sets the OrderBy field's value.
func (s *SortCriteria) SetOrderBy(v string) *SortCriteria {
	s.OrderBy = &v
	return s
}

// StartMonitoringMembers request body.
type StartMonitoringMembersInput struct {
	_ struct{} `type:"structure"`

	// A list of account IDs of the GuardDuty member accounts whose findings you
	// want the master account to monitor.
	AccountIds []*string `locationName:"accountIds" type:"list"`

	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" type:"string" required:"true"`
}

// String returns the string representation
func (s StartMonitoringMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartMonitoringMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartMonitoringMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartMonitoringMembersInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *StartMonitoringMembersInput) SetAccountIds(v []*string) *StartMonitoringMembersInput {
	s.AccountIds = v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *StartMonitoringMembersInput) SetDetectorId(v string) *StartMonitoringMembersInput {
	s.DetectorId = &v
	return s
}

// StartMonitoringMembers response object.
type StartMonitoringMembersOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects containing the unprocessed account and a result string
	// explaining why it was unprocessed.
	UnprocessedAccounts []*UnprocessedAccount `locationName:"unprocessedAccounts" type:"list"`
}

// String returns the string representation
func (s StartMonitoringMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartMonitoringMembersOutput) GoString() string {
	return s.String()
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *StartMonitoringMembersOutput) SetUnprocessedAccounts(v []*UnprocessedAccount) *StartMonitoringMembersOutput {
	s.UnprocessedAccounts = v
	return s
}

// StopMonitoringMembers request body.
type StopMonitoringMembersInput struct {
	_ struct{} `type:"structure"`

	// A list of account IDs of the GuardDuty member accounts whose findings you
	// want the master account to stop monitoring.
	AccountIds []*string `locationName:"accountIds" type:"list"`

	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" type:"string" required:"true"`
}

// String returns the string representation
func (s StopMonitoringMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopMonitoringMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopMonitoringMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopMonitoringMembersInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *StopMonitoringMembersInput) SetAccountIds(v []*string) *StopMonitoringMembersInput {
	s.AccountIds = v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *StopMonitoringMembersInput) SetDetectorId(v string) *StopMonitoringMembersInput {
	s.DetectorId = &v
	return s
}

// StopMonitoringMembers response object.
type StopMonitoringMembersOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects containing the unprocessed account and a result string
	// explaining why it was unprocessed.
	UnprocessedAccounts []*UnprocessedAccount `locationName:"unprocessedAccounts" type:"list"`
}

// String returns the string representation
func (s StopMonitoringMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopMonitoringMembersOutput) GoString() string {
	return s.String()
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *StopMonitoringMembersOutput) SetUnprocessedAccounts(v []*UnprocessedAccount) *StopMonitoringMembersOutput {
	s.UnprocessedAccounts = v
	return s
}

// A tag of the EC2 instance.
type Tag struct {
	_ struct{} `type:"structure"`

	// EC2 instance tag key.
	Key *string `locationName:"key" type:"string"`

	// EC2 instance tag value.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// Unrchive Findings Request
type UnarchiveFindingsInput struct {
	_ struct{} `type:"structure"`

	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" type:"string" required:"true"`

	// IDs of the findings that you want to unarchive.
	FindingIds []*string `locationName:"findingIds" type:"list"`
}

// String returns the string representation
func (s UnarchiveFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnarchiveFindingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UnarchiveFindingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UnarchiveFindingsInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *UnarchiveFindingsInput) SetDetectorId(v string) *UnarchiveFindingsInput {
	s.DetectorId = &v
	return s
}

// SetFindingIds sets the FindingIds field's value.
func (s *UnarchiveFindingsInput) SetFindingIds(v []*string) *UnarchiveFindingsInput {
	s.FindingIds = v
	return s
}

type UnarchiveFindingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UnarchiveFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnarchiveFindingsOutput) GoString() string {
	return s.String()
}

// An object containing the unprocessed account and a result string explaining
// why it was unprocessed.
type UnprocessedAccount struct {
	_ struct{} `type:"structure"`

	// AWS Account ID.
	AccountId *string `locationName:"accountId" type:"string"`

	// A reason why the account hasn't been processed.
	Result *string `locationName:"result" type:"string"`
}

// String returns the string representation
func (s UnprocessedAccount) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnprocessedAccount) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *UnprocessedAccount) SetAccountId(v string) *UnprocessedAccount {
	s.AccountId = &v
	return s
}

// SetResult sets the Result field's value.
func (s *UnprocessedAccount) SetResult(v string) *UnprocessedAccount {
	s.Result = &v
	return s
}

// Update Detector Request
type UpdateDetectorInput struct {
	_ struct{} `type:"structure"`

	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" type:"string" required:"true"`

	// Updated boolean value for the detector that specifies whether the detector
	// is enabled.
	Enable *bool `locationName:"enable" type:"boolean"`
}

// String returns the string representation
func (s UpdateDetectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDetectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDetectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDetectorInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *UpdateDetectorInput) SetDetectorId(v string) *UpdateDetectorInput {
	s.DetectorId = &v
	return s
}

// SetEnable sets the Enable field's value.
func (s *UpdateDetectorInput) SetEnable(v bool) *UpdateDetectorInput {
	s.Enable = &v
	return s
}

type UpdateDetectorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateDetectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDetectorOutput) GoString() string {
	return s.String()
}

// Update findings feedback body
type UpdateFindingsFeedbackInput struct {
	_ struct{} `type:"structure"`

	// Additional feedback about the GuardDuty findings.
	Comments *string `locationName:"comments" type:"string"`

	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" type:"string" required:"true"`

	// Valid values: USEFUL | NOT_USEFUL
	Feedback *string `locationName:"feedback" type:"string" enum:"Feedback"`

	// IDs of the findings that you want to mark as useful or not useful.
	FindingIds []*string `locationName:"findingIds" type:"list"`
}

// String returns the string representation
func (s UpdateFindingsFeedbackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFindingsFeedbackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFindingsFeedbackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFindingsFeedbackInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComments sets the Comments field's value.
func (s *UpdateFindingsFeedbackInput) SetComments(v string) *UpdateFindingsFeedbackInput {
	s.Comments = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *UpdateFindingsFeedbackInput) SetDetectorId(v string) *UpdateFindingsFeedbackInput {
	s.DetectorId = &v
	return s
}

// SetFeedback sets the Feedback field's value.
func (s *UpdateFindingsFeedbackInput) SetFeedback(v string) *UpdateFindingsFeedbackInput {
	s.Feedback = &v
	return s
}

// SetFindingIds sets the FindingIds field's value.
func (s *UpdateFindingsFeedbackInput) SetFindingIds(v []*string) *UpdateFindingsFeedbackInput {
	s.FindingIds = v
	return s
}

type UpdateFindingsFeedbackOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateFindingsFeedbackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFindingsFeedbackOutput) GoString() string {
	return s.String()
}

// Update IP Set Request
type UpdateIPSetInput struct {
	_ struct{} `type:"structure"`

	// The updated boolean value that specifies whether the IPSet is active or not.
	Activate *bool `locationName:"activate" type:"boolean"`

	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" type:"string" required:"true"`

	// IpSetId is a required field
	IpSetId *string `location:"uri" locationName:"ipSetId" type:"string" required:"true"`

	// The updated URI of the file that contains the IPSet. For example (https://s3.us-west-2.amazonaws.com/my-bucket/my-object-key).
	Location *string `locationName:"location" type:"string"`

	// The unique ID that specifies the IPSet that you want to update.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s UpdateIPSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateIPSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateIPSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateIPSetInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.IpSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("IpSetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActivate sets the Activate field's value.
func (s *UpdateIPSetInput) SetActivate(v bool) *UpdateIPSetInput {
	s.Activate = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *UpdateIPSetInput) SetDetectorId(v string) *UpdateIPSetInput {
	s.DetectorId = &v
	return s
}

// SetIpSetId sets the IpSetId field's value.
func (s *UpdateIPSetInput) SetIpSetId(v string) *UpdateIPSetInput {
	s.IpSetId = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *UpdateIPSetInput) SetLocation(v string) *UpdateIPSetInput {
	s.Location = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateIPSetInput) SetName(v string) *UpdateIPSetInput {
	s.Name = &v
	return s
}

type UpdateIPSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateIPSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateIPSetOutput) GoString() string {
	return s.String()
}

// Update Threat Intel Set Request
type UpdateThreatIntelSetInput struct {
	_ struct{} `type:"structure"`

	// The updated boolean value that specifies whether the ThreateIntelSet is active
	// or not.
	Activate *bool `locationName:"activate" type:"boolean"`

	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" type:"string" required:"true"`

	// The updated URI of the file that contains the ThreateIntelSet. For example
	// (https://s3.us-west-2.amazonaws.com/my-bucket/my-object-key)
	Location *string `locationName:"location" type:"string"`

	// The unique ID that specifies the ThreatIntelSet that you want to update.
	Name *string `locationName:"name" type:"string"`

	// ThreatIntelSetId is a required field
	ThreatIntelSetId *string `location:"uri" locationName:"threatIntelSetId" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateThreatIntelSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateThreatIntelSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateThreatIntelSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateThreatIntelSetInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.ThreatIntelSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("ThreatIntelSetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActivate sets the Activate field's value.
func (s *UpdateThreatIntelSetInput) SetActivate(v bool) *UpdateThreatIntelSetInput {
	s.Activate = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *UpdateThreatIntelSetInput) SetDetectorId(v string) *UpdateThreatIntelSetInput {
	s.DetectorId = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *UpdateThreatIntelSetInput) SetLocation(v string) *UpdateThreatIntelSetInput {
	s.Location = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateThreatIntelSetInput) SetName(v string) *UpdateThreatIntelSetInput {
	s.Name = &v
	return s
}

// SetThreatIntelSetId sets the ThreatIntelSetId field's value.
func (s *UpdateThreatIntelSetInput) SetThreatIntelSetId(v string) *UpdateThreatIntelSetInput {
	s.ThreatIntelSetId = &v
	return s
}

type UpdateThreatIntelSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateThreatIntelSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateThreatIntelSetOutput) GoString() string {
	return s.String()
}

// The status of detector.
const (
	// DetectorStatusEnabled is a DetectorStatus enum value
	DetectorStatusEnabled = "ENABLED"

	// DetectorStatusDisabled is a DetectorStatus enum value
	DetectorStatusDisabled = "DISABLED"
)

// Finding Feedback Value
const (
	// FeedbackUseful is a Feedback enum value
	FeedbackUseful = "USEFUL"

	// FeedbackNotUseful is a Feedback enum value
	FeedbackNotUseful = "NOT_USEFUL"
)

// The types of finding statistics.
const (
	// FindingStatisticTypeCountBySeverity is a FindingStatisticType enum value
	FindingStatisticTypeCountBySeverity = "COUNT_BY_SEVERITY"
)

// The format of the ipSet.
const (
	// IpSetFormatTxt is a IpSetFormat enum value
	IpSetFormatTxt = "TXT"

	// IpSetFormatStix is a IpSetFormat enum value
	IpSetFormatStix = "STIX"

	// IpSetFormatOtxCsv is a IpSetFormat enum value
	IpSetFormatOtxCsv = "OTX_CSV"

	// IpSetFormatAlienVault is a IpSetFormat enum value
	IpSetFormatAlienVault = "ALIEN_VAULT"

	// IpSetFormatProofPoint is a IpSetFormat enum value
	IpSetFormatProofPoint = "PROOF_POINT"

	// IpSetFormatFireEye is a IpSetFormat enum value
	IpSetFormatFireEye = "FIRE_EYE"
)

// The status of ipSet file uploaded.
const (
	// IpSetStatusInactive is a IpSetStatus enum value
	IpSetStatusInactive = "INACTIVE"

	// IpSetStatusActivating is a IpSetStatus enum value
	IpSetStatusActivating = "ACTIVATING"

	// IpSetStatusActive is a IpSetStatus enum value
	IpSetStatusActive = "ACTIVE"

	// IpSetStatusDeactivating is a IpSetStatus enum value
	IpSetStatusDeactivating = "DEACTIVATING"

	// IpSetStatusError is a IpSetStatus enum value
	IpSetStatusError = "ERROR"

	// IpSetStatusDeletePending is a IpSetStatus enum value
	IpSetStatusDeletePending = "DELETE_PENDING"

	// IpSetStatusDeleted is a IpSetStatus enum value
	IpSetStatusDeleted = "DELETED"
)

const (
	// OrderByAsc is a OrderBy enum value
	OrderByAsc = "ASC"

	// OrderByDesc is a OrderBy enum value
	OrderByDesc = "DESC"
)

// The format of the threatIntelSet.
const (
	// ThreatIntelSetFormatTxt is a ThreatIntelSetFormat enum value
	ThreatIntelSetFormatTxt = "TXT"

	// ThreatIntelSetFormatStix is a ThreatIntelSetFormat enum value
	ThreatIntelSetFormatStix = "STIX"

	// ThreatIntelSetFormatOtxCsv is a ThreatIntelSetFormat enum value
	ThreatIntelSetFormatOtxCsv = "OTX_CSV"

	// ThreatIntelSetFormatAlienVault is a ThreatIntelSetFormat enum value
	ThreatIntelSetFormatAlienVault = "ALIEN_VAULT"

	// ThreatIntelSetFormatProofPoint is a ThreatIntelSetFormat enum value
	ThreatIntelSetFormatProofPoint = "PROOF_POINT"

	// ThreatIntelSetFormatFireEye is a ThreatIntelSetFormat enum value
	ThreatIntelSetFormatFireEye = "FIRE_EYE"
)

// The status of threatIntelSet file uploaded.
const (
	// ThreatIntelSetStatusInactive is a ThreatIntelSetStatus enum value
	ThreatIntelSetStatusInactive = "INACTIVE"

	// ThreatIntelSetStatusActivating is a ThreatIntelSetStatus enum value
	ThreatIntelSetStatusActivating = "ACTIVATING"

	// ThreatIntelSetStatusActive is a ThreatIntelSetStatus enum value
	ThreatIntelSetStatusActive = "ACTIVE"

	// ThreatIntelSetStatusDeactivating is a ThreatIntelSetStatus enum value
	ThreatIntelSetStatusDeactivating = "DEACTIVATING"

	// ThreatIntelSetStatusError is a ThreatIntelSetStatus enum value
	ThreatIntelSetStatusError = "ERROR"

	// ThreatIntelSetStatusDeletePending is a ThreatIntelSetStatus enum value
	ThreatIntelSetStatusDeletePending = "DELETE_PENDING"

	// ThreatIntelSetStatusDeleted is a ThreatIntelSetStatus enum value
	ThreatIntelSetStatusDeleted = "DELETED"
)
