package videosearch

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
)

// ErrorCode enumerates the values for error code.
type ErrorCode string

const (
	// InsufficientAuthorization ...
	InsufficientAuthorization ErrorCode = "InsufficientAuthorization"
	// InvalidAuthorization ...
	InvalidAuthorization ErrorCode = "InvalidAuthorization"
	// InvalidRequest ...
	InvalidRequest ErrorCode = "InvalidRequest"
	// None ...
	None ErrorCode = "None"
	// RateLimitExceeded ...
	RateLimitExceeded ErrorCode = "RateLimitExceeded"
	// ServerError ...
	ServerError ErrorCode = "ServerError"
)

// ErrorSubCode enumerates the values for error sub code.
type ErrorSubCode string

const (
	// AuthorizationDisabled ...
	AuthorizationDisabled ErrorSubCode = "AuthorizationDisabled"
	// AuthorizationExpired ...
	AuthorizationExpired ErrorSubCode = "AuthorizationExpired"
	// AuthorizationMissing ...
	AuthorizationMissing ErrorSubCode = "AuthorizationMissing"
	// AuthorizationRedundancy ...
	AuthorizationRedundancy ErrorSubCode = "AuthorizationRedundancy"
	// Blocked ...
	Blocked ErrorSubCode = "Blocked"
	// HTTPNotAllowed ...
	HTTPNotAllowed ErrorSubCode = "HttpNotAllowed"
	// NotImplemented ...
	NotImplemented ErrorSubCode = "NotImplemented"
	// ParameterInvalidValue ...
	ParameterInvalidValue ErrorSubCode = "ParameterInvalidValue"
	// ParameterMissing ...
	ParameterMissing ErrorSubCode = "ParameterMissing"
	// ResourceError ...
	ResourceError ErrorSubCode = "ResourceError"
	// UnexpectedError ...
	UnexpectedError ErrorSubCode = "UnexpectedError"
)

// Freshness enumerates the values for freshness.
type Freshness string

const (
	// Day ...
	Day Freshness = "Day"
	// Month ...
	Month Freshness = "Month"
	// Week ...
	Week Freshness = "Week"
)

// SafeSearch enumerates the values for safe search.
type SafeSearch string

const (
	// Moderate ...
	Moderate SafeSearch = "Moderate"
	// Off ...
	Off SafeSearch = "Off"
	// Strict ...
	Strict SafeSearch = "Strict"
)

// TextFormat enumerates the values for text format.
type TextFormat string

const (
	// HTML ...
	HTML TextFormat = "Html"
	// Raw ...
	Raw TextFormat = "Raw"
)

// Type enumerates the values for type.
type Type string

const (
	// TypeAnswer ...
	TypeAnswer Type = "Answer"
	// TypeCreativeWork ...
	TypeCreativeWork Type = "CreativeWork"
	// TypeErrorResponse ...
	TypeErrorResponse Type = "ErrorResponse"
	// TypeIdentifiable ...
	TypeIdentifiable Type = "Identifiable"
	// TypeImageObject ...
	TypeImageObject Type = "ImageObject"
	// TypeMediaObject ...
	TypeMediaObject Type = "MediaObject"
	// TypeResponse ...
	TypeResponse Type = "Response"
	// TypeResponseBase ...
	TypeResponseBase Type = "ResponseBase"
	// TypeSearchResultsAnswer ...
	TypeSearchResultsAnswer Type = "SearchResultsAnswer"
	// TypeThing ...
	TypeThing Type = "Thing"
	// TypeTrendingVideos ...
	TypeTrendingVideos Type = "TrendingVideos"
	// TypeVideoDetails ...
	TypeVideoDetails Type = "VideoDetails"
	// TypeVideoObject ...
	TypeVideoObject Type = "VideoObject"
	// TypeVideos ...
	TypeVideos Type = "Videos"
)

// VideoInsightModule enumerates the values for video insight module.
type VideoInsightModule string

const (
	// All ...
	All VideoInsightModule = "All"
	// RelatedVideos ...
	RelatedVideos VideoInsightModule = "RelatedVideos"
	// VideoResult ...
	VideoResult VideoInsightModule = "VideoResult"
)

// VideoLength enumerates the values for video length.
type VideoLength string

const (
	// VideoLengthAll ...
	VideoLengthAll VideoLength = "All"
	// VideoLengthLong ...
	VideoLengthLong VideoLength = "Long"
	// VideoLengthMedium ...
	VideoLengthMedium VideoLength = "Medium"
	// VideoLengthShort ...
	VideoLengthShort VideoLength = "Short"
)

// VideoPricing enumerates the values for video pricing.
type VideoPricing string

const (
	// VideoPricingAll ...
	VideoPricingAll VideoPricing = "All"
	// VideoPricingFree ...
	VideoPricingFree VideoPricing = "Free"
	// VideoPricingPaid ...
	VideoPricingPaid VideoPricing = "Paid"
)

// VideoQueryScenario enumerates the values for video query scenario.
type VideoQueryScenario string

const (
	// List ...
	List VideoQueryScenario = "List"
	// SingleDominantVideo ...
	SingleDominantVideo VideoQueryScenario = "SingleDominantVideo"
)

// VideoResolution enumerates the values for video resolution.
type VideoResolution string

const (
	// VideoResolutionAll ...
	VideoResolutionAll VideoResolution = "All"
	// VideoResolutionHD1080p ...
	VideoResolutionHD1080p VideoResolution = "HD1080p"
	// VideoResolutionHD720p ...
	VideoResolutionHD720p VideoResolution = "HD720p"
	// VideoResolutionSD480p ...
	VideoResolutionSD480p VideoResolution = "SD480p"
)

// BasicAnswer
type BasicAnswer interface {
	AsVideos() (*Videos, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
	AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool)
	AsAnswer() (*Answer, bool)
}

// Answer
type Answer struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeVideoObject', 'TypeVideos', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeTrendingVideos', 'TypeVideoDetails'
	Type Type `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL    *string  `json:"webSearchUrl,omitempty"`
	FollowUpQueries *[]Query `json:"followUpQueries,omitempty"`
}

func unmarshalBasicAnswer(body []byte) (BasicAnswer, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeVideos):
		var vVar Videos
		err := json.Unmarshal(body, &vVar)
		return vVar, err
	case string(TypeSearchResultsAnswer):
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	default:
		var a Answer
		err := json.Unmarshal(body, &a)
		return a, err
	}
}
func unmarshalBasicAnswerArray(body []byte) ([]BasicAnswer, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	aArray := make([]BasicAnswer, len(rawMessages))

	for index, rawMessage := range rawMessages {
		a, err := unmarshalBasicAnswer(*rawMessage)
		if err != nil {
			return nil, err
		}
		aArray[index] = a
	}
	return aArray, nil
}

// MarshalJSON is the custom marshaler for Answer.
func (a Answer) MarshalJSON() ([]byte, error) {
	a.Type = TypeAnswer
	type Alias Answer
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(a),
	})
}

// AsImageObject is the BasicResponseBase implementation for Answer.
func (a Answer) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for Answer.
func (a Answer) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsVideos is the BasicResponseBase implementation for Answer.
func (a Answer) AsVideos() (*Videos, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Answer.
func (a Answer) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for Answer.
func (a Answer) AsAnswer() (*Answer, bool) {
	return &a, true
}

// AsBasicAnswer is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicAnswer() (BasicAnswer, bool) {
	return &a, true
}

// AsMediaObject is the BasicResponseBase implementation for Answer.
func (a Answer) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Answer.
func (a Answer) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicResponse() (BasicResponse, bool) {
	return &a, true
}

// AsThing is the BasicResponseBase implementation for Answer.
func (a Answer) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Answer.
func (a Answer) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Answer.
func (a Answer) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &a, true
}

// AsErrorResponse is the BasicResponseBase implementation for Answer.
func (a Answer) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsTrendingVideos is the BasicResponseBase implementation for Answer.
func (a Answer) AsTrendingVideos() (*TrendingVideos, bool) {
	return nil, false
}

// AsVideoDetails is the BasicResponseBase implementation for Answer.
func (a Answer) AsVideoDetails() (*VideoDetails, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Answer.
func (a Answer) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &a, true
}

// BasicCreativeWork
type BasicCreativeWork interface {
	AsImageObject() (*ImageObject, bool)
	AsVideoObject() (*VideoObject, bool)
	AsMediaObject() (*MediaObject, bool)
	AsBasicMediaObject() (BasicMediaObject, bool)
	AsCreativeWork() (*CreativeWork, bool)
}

// CreativeWork
type CreativeWork struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeVideoObject', 'TypeVideos', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeTrendingVideos', 'TypeVideoDetails'
	Type Type `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL   *string      `json:"url,omitempty"`
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description   *string `json:"description,omitempty"`
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	Text     *string       `json:"text,omitempty"`
}

func unmarshalBasicCreativeWork(body []byte) (BasicCreativeWork, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	case string(TypeVideoObject):
		var vo VideoObject
		err := json.Unmarshal(body, &vo)
		return vo, err
	case string(TypeMediaObject):
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	default:
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	}
}
func unmarshalBasicCreativeWorkArray(body []byte) ([]BasicCreativeWork, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	cwArray := make([]BasicCreativeWork, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cw, err := unmarshalBasicCreativeWork(*rawMessage)
		if err != nil {
			return nil, err
		}
		cwArray[index] = cw
	}
	return cwArray, nil
}

// MarshalJSON is the custom marshaler for CreativeWork.
func (cw CreativeWork) MarshalJSON() ([]byte, error) {
	cw.Type = TypeCreativeWork
	type Alias CreativeWork
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(cw),
	})
}

// AsImageObject is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsVideos is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsVideos() (*Videos, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicResponse() (BasicResponse, bool) {
	return &cw, true
}

// AsThing is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicThing() (BasicThing, bool) {
	return &cw, true
}

// AsCreativeWork is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsCreativeWork() (*CreativeWork, bool) {
	return &cw, true
}

// AsBasicCreativeWork is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &cw, true
}

// AsIdentifiable is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &cw, true
}

// AsErrorResponse is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsTrendingVideos is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsTrendingVideos() (*TrendingVideos, bool) {
	return nil, false
}

// AsVideoDetails is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsVideoDetails() (*VideoDetails, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &cw, true
}

// UnmarshalJSON is the custom unmarshaler for CreativeWork struct.
func (cw *CreativeWork) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["thumbnailUrl"]
	if v != nil {
		var thumbnailURL string
		err = json.Unmarshal(*m["thumbnailUrl"], &thumbnailURL)
		if err != nil {
			return err
		}
		cw.ThumbnailURL = &thumbnailURL
	}

	v = m["provider"]
	if v != nil {
		provider, err := unmarshalBasicThingArray(*m["provider"])
		if err != nil {
			return err
		}
		cw.Provider = &provider
	}

	v = m["text"]
	if v != nil {
		var textVar string
		err = json.Unmarshal(*m["text"], &textVar)
		if err != nil {
			return err
		}
		cw.Text = &textVar
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		cw.Name = &name
	}

	v = m["url"]
	if v != nil {
		var URLVar string
		err = json.Unmarshal(*m["url"], &URLVar)
		if err != nil {
			return err
		}
		cw.URL = &URLVar
	}

	v = m["image"]
	if v != nil {
		var imageVar ImageObject
		err = json.Unmarshal(*m["image"], &imageVar)
		if err != nil {
			return err
		}
		cw.Image = &imageVar
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		cw.Description = &description
	}

	v = m["alternateName"]
	if v != nil {
		var alternateName string
		err = json.Unmarshal(*m["alternateName"], &alternateName)
		if err != nil {
			return err
		}
		cw.AlternateName = &alternateName
	}

	v = m["bingId"]
	if v != nil {
		var bingID string
		err = json.Unmarshal(*m["bingId"], &bingID)
		if err != nil {
			return err
		}
		cw.BingID = &bingID
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		cw.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		cw.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type Type
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		cw.Type = _type
	}

	return nil
}

// Error defines the error that occurred.
type Error struct {
	// Code - The error code that identifies the category of error. Possible values include: 'None', 'ServerError', 'InvalidRequest', 'RateLimitExceeded', 'InvalidAuthorization', 'InsufficientAuthorization'
	Code ErrorCode `json:"code,omitempty"`
	// SubCode - The error code that further helps to identify the error. Possible values include: 'UnexpectedError', 'ResourceError', 'NotImplemented', 'ParameterMissing', 'ParameterInvalidValue', 'HTTPNotAllowed', 'Blocked', 'AuthorizationMissing', 'AuthorizationRedundancy', 'AuthorizationDisabled', 'AuthorizationExpired'
	SubCode ErrorSubCode `json:"subCode,omitempty"`
	// Message - A description of the error.
	Message *string `json:"message,omitempty"`
	// MoreDetails - A description that provides additional information about the error.
	MoreDetails *string `json:"moreDetails,omitempty"`
	// Parameter - The parameter in the request that caused the error.
	Parameter *string `json:"parameter,omitempty"`
	// Value - The parameter's value in the request that was not valid.
	Value *string `json:"value,omitempty"`
}

// ErrorResponse the top-level response that represents a failed request.
type ErrorResponse struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeVideoObject', 'TypeVideos', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeTrendingVideos', 'TypeVideoDetails'
	Type Type `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Errors - A list of errors that describe the reasons why the request failed.
	Errors *[]Error `json:"errors,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorResponse.
func (er ErrorResponse) MarshalJSON() ([]byte, error) {
	er.Type = TypeErrorResponse
	type Alias ErrorResponse
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(er),
	})
}

// AsImageObject is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsVideos is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsVideos() (*Videos, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicResponse() (BasicResponse, bool) {
	return &er, true
}

// AsThing is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &er, true
}

// AsErrorResponse is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsErrorResponse() (*ErrorResponse, bool) {
	return &er, true
}

// AsTrendingVideos is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsTrendingVideos() (*TrendingVideos, bool) {
	return nil, false
}

// AsVideoDetails is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsVideoDetails() (*VideoDetails, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &er, true
}

// BasicIdentifiable defines the identity of a resource.
type BasicIdentifiable interface {
	AsImageObject() (*ImageObject, bool)
	AsVideoObject() (*VideoObject, bool)
	AsVideos() (*Videos, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
	AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool)
	AsAnswer() (*Answer, bool)
	AsBasicAnswer() (BasicAnswer, bool)
	AsMediaObject() (*MediaObject, bool)
	AsBasicMediaObject() (BasicMediaObject, bool)
	AsResponse() (*Response, bool)
	AsBasicResponse() (BasicResponse, bool)
	AsThing() (*Thing, bool)
	AsBasicThing() (BasicThing, bool)
	AsCreativeWork() (*CreativeWork, bool)
	AsBasicCreativeWork() (BasicCreativeWork, bool)
	AsErrorResponse() (*ErrorResponse, bool)
	AsTrendingVideos() (*TrendingVideos, bool)
	AsVideoDetails() (*VideoDetails, bool)
	AsIdentifiable() (*Identifiable, bool)
}

// Identifiable defines the identity of a resource.
type Identifiable struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeVideoObject', 'TypeVideos', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeTrendingVideos', 'TypeVideoDetails'
	Type Type `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
}

func unmarshalBasicIdentifiable(body []byte) (BasicIdentifiable, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	case string(TypeVideoObject):
		var vo VideoObject
		err := json.Unmarshal(body, &vo)
		return vo, err
	case string(TypeVideos):
		var vVar Videos
		err := json.Unmarshal(body, &vVar)
		return vVar, err
	case string(TypeSearchResultsAnswer):
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	case string(TypeAnswer):
		var a Answer
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeMediaObject):
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	case string(TypeResponse):
		var r Response
		err := json.Unmarshal(body, &r)
		return r, err
	case string(TypeThing):
		var t Thing
		err := json.Unmarshal(body, &t)
		return t, err
	case string(TypeCreativeWork):
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	case string(TypeErrorResponse):
		var er ErrorResponse
		err := json.Unmarshal(body, &er)
		return er, err
	case string(TypeTrendingVideos):
		var tv TrendingVideos
		err := json.Unmarshal(body, &tv)
		return tv, err
	case string(TypeVideoDetails):
		var vd VideoDetails
		err := json.Unmarshal(body, &vd)
		return vd, err
	default:
		var i Identifiable
		err := json.Unmarshal(body, &i)
		return i, err
	}
}
func unmarshalBasicIdentifiableArray(body []byte) ([]BasicIdentifiable, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	iArray := make([]BasicIdentifiable, len(rawMessages))

	for index, rawMessage := range rawMessages {
		i, err := unmarshalBasicIdentifiable(*rawMessage)
		if err != nil {
			return nil, err
		}
		iArray[index] = i
	}
	return iArray, nil
}

// MarshalJSON is the custom marshaler for Identifiable.
func (i Identifiable) MarshalJSON() ([]byte, error) {
	i.Type = TypeIdentifiable
	type Alias Identifiable
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(i),
	})
}

// AsImageObject is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsVideos is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsVideos() (*Videos, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicResponse() (BasicResponse, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsIdentifiable() (*Identifiable, bool) {
	return &i, true
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &i, true
}

// AsErrorResponse is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsTrendingVideos is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsTrendingVideos() (*TrendingVideos, bool) {
	return nil, false
}

// AsVideoDetails is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsVideoDetails() (*VideoDetails, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &i, true
}

// ImageObject defines an image
type ImageObject struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeVideoObject', 'TypeVideos', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeTrendingVideos', 'TypeVideoDetails'
	Type Type `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL   *string      `json:"url,omitempty"`
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description   *string `json:"description,omitempty"`
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	Text     *string       `json:"text,omitempty"`
	// ContentURL - Original URL to retrieve the source (file) for the media object (e.g the source URL for the image).
	ContentURL *string `json:"contentUrl,omitempty"`
	// HostPageURL - URL of the page that hosts the media object.
	HostPageURL *string `json:"hostPageUrl,omitempty"`
	// Width - The width of the source media object, in pixels.
	Width *int32 `json:"width,omitempty"`
	// Height - The height of the source media object, in pixels.
	Height *int32 `json:"height,omitempty"`
	// Thumbnail - The URL to a thumbnail of the image
	Thumbnail *ImageObject `json:"thumbnail,omitempty"`
}

// MarshalJSON is the custom marshaler for ImageObject.
func (ioVar ImageObject) MarshalJSON() ([]byte, error) {
	ioVar.Type = TypeImageObject
	type Alias ImageObject
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ioVar),
	})
}

// AsImageObject is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsImageObject() (*ImageObject, bool) {
	return &ioVar, true
}

// AsVideoObject is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsVideos is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsVideos() (*Videos, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicMediaObject() (BasicMediaObject, bool) {
	return &ioVar, true
}

// AsResponse is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicResponse() (BasicResponse, bool) {
	return &ioVar, true
}

// AsThing is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicThing() (BasicThing, bool) {
	return &ioVar, true
}

// AsCreativeWork is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &ioVar, true
}

// AsIdentifiable is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &ioVar, true
}

// AsErrorResponse is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsTrendingVideos is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsTrendingVideos() (*TrendingVideos, bool) {
	return nil, false
}

// AsVideoDetails is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsVideoDetails() (*VideoDetails, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &ioVar, true
}

// UnmarshalJSON is the custom unmarshaler for ImageObject struct.
func (ioVar *ImageObject) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["thumbnail"]
	if v != nil {
		var thumbnail ImageObject
		err = json.Unmarshal(*m["thumbnail"], &thumbnail)
		if err != nil {
			return err
		}
		ioVar.Thumbnail = &thumbnail
	}

	v = m["contentUrl"]
	if v != nil {
		var contentURL string
		err = json.Unmarshal(*m["contentUrl"], &contentURL)
		if err != nil {
			return err
		}
		ioVar.ContentURL = &contentURL
	}

	v = m["hostPageUrl"]
	if v != nil {
		var hostPageURL string
		err = json.Unmarshal(*m["hostPageUrl"], &hostPageURL)
		if err != nil {
			return err
		}
		ioVar.HostPageURL = &hostPageURL
	}

	v = m["width"]
	if v != nil {
		var width int32
		err = json.Unmarshal(*m["width"], &width)
		if err != nil {
			return err
		}
		ioVar.Width = &width
	}

	v = m["height"]
	if v != nil {
		var height int32
		err = json.Unmarshal(*m["height"], &height)
		if err != nil {
			return err
		}
		ioVar.Height = &height
	}

	v = m["thumbnailUrl"]
	if v != nil {
		var thumbnailURL string
		err = json.Unmarshal(*m["thumbnailUrl"], &thumbnailURL)
		if err != nil {
			return err
		}
		ioVar.ThumbnailURL = &thumbnailURL
	}

	v = m["provider"]
	if v != nil {
		provider, err := unmarshalBasicThingArray(*m["provider"])
		if err != nil {
			return err
		}
		ioVar.Provider = &provider
	}

	v = m["text"]
	if v != nil {
		var textVar string
		err = json.Unmarshal(*m["text"], &textVar)
		if err != nil {
			return err
		}
		ioVar.Text = &textVar
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		ioVar.Name = &name
	}

	v = m["url"]
	if v != nil {
		var URLVar string
		err = json.Unmarshal(*m["url"], &URLVar)
		if err != nil {
			return err
		}
		ioVar.URL = &URLVar
	}

	v = m["image"]
	if v != nil {
		var imageVar ImageObject
		err = json.Unmarshal(*m["image"], &imageVar)
		if err != nil {
			return err
		}
		ioVar.Image = &imageVar
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		ioVar.Description = &description
	}

	v = m["alternateName"]
	if v != nil {
		var alternateName string
		err = json.Unmarshal(*m["alternateName"], &alternateName)
		if err != nil {
			return err
		}
		ioVar.AlternateName = &alternateName
	}

	v = m["bingId"]
	if v != nil {
		var bingID string
		err = json.Unmarshal(*m["bingId"], &bingID)
		if err != nil {
			return err
		}
		ioVar.BingID = &bingID
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		ioVar.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		ioVar.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type Type
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		ioVar.Type = _type
	}

	return nil
}

// BasicMediaObject
type BasicMediaObject interface {
	AsImageObject() (*ImageObject, bool)
	AsVideoObject() (*VideoObject, bool)
	AsMediaObject() (*MediaObject, bool)
}

// MediaObject
type MediaObject struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeVideoObject', 'TypeVideos', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeTrendingVideos', 'TypeVideoDetails'
	Type Type `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL   *string      `json:"url,omitempty"`
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description   *string `json:"description,omitempty"`
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	Text     *string       `json:"text,omitempty"`
	// ContentURL - Original URL to retrieve the source (file) for the media object (e.g the source URL for the image).
	ContentURL *string `json:"contentUrl,omitempty"`
	// HostPageURL - URL of the page that hosts the media object.
	HostPageURL *string `json:"hostPageUrl,omitempty"`
	// Width - The width of the source media object, in pixels.
	Width *int32 `json:"width,omitempty"`
	// Height - The height of the source media object, in pixels.
	Height *int32 `json:"height,omitempty"`
}

func unmarshalBasicMediaObject(body []byte) (BasicMediaObject, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	case string(TypeVideoObject):
		var vo VideoObject
		err := json.Unmarshal(body, &vo)
		return vo, err
	default:
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	}
}
func unmarshalBasicMediaObjectArray(body []byte) ([]BasicMediaObject, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	moArray := make([]BasicMediaObject, len(rawMessages))

	for index, rawMessage := range rawMessages {
		mo, err := unmarshalBasicMediaObject(*rawMessage)
		if err != nil {
			return nil, err
		}
		moArray[index] = mo
	}
	return moArray, nil
}

// MarshalJSON is the custom marshaler for MediaObject.
func (mo MediaObject) MarshalJSON() ([]byte, error) {
	mo.Type = TypeMediaObject
	type Alias MediaObject
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(mo),
	})
}

// AsImageObject is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsVideos is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsVideos() (*Videos, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsMediaObject() (*MediaObject, bool) {
	return &mo, true
}

// AsBasicMediaObject is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicMediaObject() (BasicMediaObject, bool) {
	return &mo, true
}

// AsResponse is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicResponse() (BasicResponse, bool) {
	return &mo, true
}

// AsThing is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicThing() (BasicThing, bool) {
	return &mo, true
}

// AsCreativeWork is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &mo, true
}

// AsIdentifiable is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &mo, true
}

// AsErrorResponse is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsTrendingVideos is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsTrendingVideos() (*TrendingVideos, bool) {
	return nil, false
}

// AsVideoDetails is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsVideoDetails() (*VideoDetails, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &mo, true
}

// UnmarshalJSON is the custom unmarshaler for MediaObject struct.
func (mo *MediaObject) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["contentUrl"]
	if v != nil {
		var contentURL string
		err = json.Unmarshal(*m["contentUrl"], &contentURL)
		if err != nil {
			return err
		}
		mo.ContentURL = &contentURL
	}

	v = m["hostPageUrl"]
	if v != nil {
		var hostPageURL string
		err = json.Unmarshal(*m["hostPageUrl"], &hostPageURL)
		if err != nil {
			return err
		}
		mo.HostPageURL = &hostPageURL
	}

	v = m["width"]
	if v != nil {
		var width int32
		err = json.Unmarshal(*m["width"], &width)
		if err != nil {
			return err
		}
		mo.Width = &width
	}

	v = m["height"]
	if v != nil {
		var height int32
		err = json.Unmarshal(*m["height"], &height)
		if err != nil {
			return err
		}
		mo.Height = &height
	}

	v = m["thumbnailUrl"]
	if v != nil {
		var thumbnailURL string
		err = json.Unmarshal(*m["thumbnailUrl"], &thumbnailURL)
		if err != nil {
			return err
		}
		mo.ThumbnailURL = &thumbnailURL
	}

	v = m["provider"]
	if v != nil {
		provider, err := unmarshalBasicThingArray(*m["provider"])
		if err != nil {
			return err
		}
		mo.Provider = &provider
	}

	v = m["text"]
	if v != nil {
		var textVar string
		err = json.Unmarshal(*m["text"], &textVar)
		if err != nil {
			return err
		}
		mo.Text = &textVar
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		mo.Name = &name
	}

	v = m["url"]
	if v != nil {
		var URLVar string
		err = json.Unmarshal(*m["url"], &URLVar)
		if err != nil {
			return err
		}
		mo.URL = &URLVar
	}

	v = m["image"]
	if v != nil {
		var imageVar ImageObject
		err = json.Unmarshal(*m["image"], &imageVar)
		if err != nil {
			return err
		}
		mo.Image = &imageVar
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		mo.Description = &description
	}

	v = m["alternateName"]
	if v != nil {
		var alternateName string
		err = json.Unmarshal(*m["alternateName"], &alternateName)
		if err != nil {
			return err
		}
		mo.AlternateName = &alternateName
	}

	v = m["bingId"]
	if v != nil {
		var bingID string
		err = json.Unmarshal(*m["bingId"], &bingID)
		if err != nil {
			return err
		}
		mo.BingID = &bingID
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		mo.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		mo.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type Type
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		mo.Type = _type
	}

	return nil
}

// PivotSuggestions ...
type PivotSuggestions struct {
	Pivot       *string  `json:"pivot,omitempty"`
	Suggestions *[]Query `json:"suggestions,omitempty"`
}

// Query defines a search query.
type Query struct {
	// Text - The query string. Use this string as the query term in a new search request.
	Text *string `json:"text,omitempty"`
	// DisplayText - The display version of the query term. This version of the query term may contain special characters that highlight the search term found in the query string. The string contains the highlighting characters only if the query enabled hit highlighting
	DisplayText *string `json:"displayText,omitempty"`
	// WebSearchURL - The URL that takes the user to the Bing search results page for the query.Only related search results include this field.
	WebSearchURL *string      `json:"webSearchUrl,omitempty"`
	SearchLink   *string      `json:"searchLink,omitempty"`
	Thumbnail    *ImageObject `json:"thumbnail,omitempty"`
}

// QueryContext defines the query context that Bing used for the request.
type QueryContext struct {
	// OriginalQuery - The query string as specified in the request.
	OriginalQuery *string `json:"originalQuery,omitempty"`
	// AlteredQuery - The query string used by Bing to perform the query. Bing uses the altered query string if the original query string contained spelling mistakes. For example, if the query string is "saling downwind", the altered query string will be "sailing downwind". This field is included only if the original query string contains a spelling mistake.
	AlteredQuery *string `json:"alteredQuery,omitempty"`
	// AlterationOverrideQuery - The query string to use to force Bing to use the original string. For example, if the query string is "saling downwind", the override query string will be "+saling downwind". Remember to encode the query string which results in "%2Bsaling+downwind". This field is included only if the original query string contains a spelling mistake.
	AlterationOverrideQuery *string `json:"alterationOverrideQuery,omitempty"`
	// AdultIntent - A Boolean value that indicates whether the specified query has adult intent. The value is true if the query has adult intent; otherwise, false.
	AdultIntent *bool `json:"adultIntent,omitempty"`
	// AskUserForLocation - A Boolean value that indicates whether Bing requires the user's location to provide accurate results. If you specified the user's location by using the X-MSEdge-ClientIP and X-Search-Location headers, you can ignore this field. For location aware queries, such as "today's weather" or "restaurants near me" that need the user's location to provide accurate results, this field is set to true. For location aware queries that include the location (for example, "Seattle weather"), this field is set to false. This field is also set to false for queries that are not location aware, such as "best sellers".
	AskUserForLocation *bool `json:"askUserForLocation,omitempty"`
	IsTransactional    *bool `json:"isTransactional,omitempty"`
}

// BasicResponse defines a response. All schemas that could be returned at the root of a response should inherit from
// this
type BasicResponse interface {
	AsImageObject() (*ImageObject, bool)
	AsVideoObject() (*VideoObject, bool)
	AsVideos() (*Videos, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
	AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool)
	AsAnswer() (*Answer, bool)
	AsBasicAnswer() (BasicAnswer, bool)
	AsMediaObject() (*MediaObject, bool)
	AsBasicMediaObject() (BasicMediaObject, bool)
	AsThing() (*Thing, bool)
	AsBasicThing() (BasicThing, bool)
	AsCreativeWork() (*CreativeWork, bool)
	AsBasicCreativeWork() (BasicCreativeWork, bool)
	AsErrorResponse() (*ErrorResponse, bool)
	AsTrendingVideos() (*TrendingVideos, bool)
	AsVideoDetails() (*VideoDetails, bool)
	AsResponse() (*Response, bool)
}

// Response defines a response. All schemas that could be returned at the root of a response should inherit from this
type Response struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeVideoObject', 'TypeVideos', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeTrendingVideos', 'TypeVideoDetails'
	Type Type `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
}

func unmarshalBasicResponse(body []byte) (BasicResponse, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	case string(TypeVideoObject):
		var vo VideoObject
		err := json.Unmarshal(body, &vo)
		return vo, err
	case string(TypeVideos):
		var vVar Videos
		err := json.Unmarshal(body, &vVar)
		return vVar, err
	case string(TypeSearchResultsAnswer):
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	case string(TypeAnswer):
		var a Answer
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeMediaObject):
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	case string(TypeThing):
		var t Thing
		err := json.Unmarshal(body, &t)
		return t, err
	case string(TypeCreativeWork):
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	case string(TypeErrorResponse):
		var er ErrorResponse
		err := json.Unmarshal(body, &er)
		return er, err
	case string(TypeTrendingVideos):
		var tv TrendingVideos
		err := json.Unmarshal(body, &tv)
		return tv, err
	case string(TypeVideoDetails):
		var vd VideoDetails
		err := json.Unmarshal(body, &vd)
		return vd, err
	default:
		var r Response
		err := json.Unmarshal(body, &r)
		return r, err
	}
}
func unmarshalBasicResponseArray(body []byte) ([]BasicResponse, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rArray := make([]BasicResponse, len(rawMessages))

	for index, rawMessage := range rawMessages {
		r, err := unmarshalBasicResponse(*rawMessage)
		if err != nil {
			return nil, err
		}
		rArray[index] = r
	}
	return rArray, nil
}

// MarshalJSON is the custom marshaler for Response.
func (r Response) MarshalJSON() ([]byte, error) {
	r.Type = TypeResponse
	type Alias Response
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(r),
	})
}

// AsImageObject is the BasicResponseBase implementation for Response.
func (r Response) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for Response.
func (r Response) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsVideos is the BasicResponseBase implementation for Response.
func (r Response) AsVideos() (*Videos, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Response.
func (r Response) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Response.
func (r Response) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for Response.
func (r Response) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Response.
func (r Response) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Response.
func (r Response) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Response.
func (r Response) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Response.
func (r Response) AsResponse() (*Response, bool) {
	return &r, true
}

// AsBasicResponse is the BasicResponseBase implementation for Response.
func (r Response) AsBasicResponse() (BasicResponse, bool) {
	return &r, true
}

// AsThing is the BasicResponseBase implementation for Response.
func (r Response) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Response.
func (r Response) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Response.
func (r Response) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Response.
func (r Response) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Response.
func (r Response) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Response.
func (r Response) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &r, true
}

// AsErrorResponse is the BasicResponseBase implementation for Response.
func (r Response) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsTrendingVideos is the BasicResponseBase implementation for Response.
func (r Response) AsTrendingVideos() (*TrendingVideos, bool) {
	return nil, false
}

// AsVideoDetails is the BasicResponseBase implementation for Response.
func (r Response) AsVideoDetails() (*VideoDetails, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Response.
func (r Response) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Response.
func (r Response) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &r, true
}

// BasicResponseBase
type BasicResponseBase interface {
	AsImageObject() (*ImageObject, bool)
	AsVideoObject() (*VideoObject, bool)
	AsVideos() (*Videos, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
	AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool)
	AsAnswer() (*Answer, bool)
	AsBasicAnswer() (BasicAnswer, bool)
	AsMediaObject() (*MediaObject, bool)
	AsBasicMediaObject() (BasicMediaObject, bool)
	AsResponse() (*Response, bool)
	AsBasicResponse() (BasicResponse, bool)
	AsThing() (*Thing, bool)
	AsBasicThing() (BasicThing, bool)
	AsCreativeWork() (*CreativeWork, bool)
	AsBasicCreativeWork() (BasicCreativeWork, bool)
	AsIdentifiable() (*Identifiable, bool)
	AsBasicIdentifiable() (BasicIdentifiable, bool)
	AsErrorResponse() (*ErrorResponse, bool)
	AsTrendingVideos() (*TrendingVideos, bool)
	AsVideoDetails() (*VideoDetails, bool)
	AsResponseBase() (*ResponseBase, bool)
}

// ResponseBase
type ResponseBase struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeVideoObject', 'TypeVideos', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeTrendingVideos', 'TypeVideoDetails'
	Type Type `json:"_type,omitempty"`
}

func unmarshalBasicResponseBase(body []byte) (BasicResponseBase, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	case string(TypeVideoObject):
		var vo VideoObject
		err := json.Unmarshal(body, &vo)
		return vo, err
	case string(TypeVideos):
		var vVar Videos
		err := json.Unmarshal(body, &vVar)
		return vVar, err
	case string(TypeSearchResultsAnswer):
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	case string(TypeAnswer):
		var a Answer
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeMediaObject):
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	case string(TypeResponse):
		var r Response
		err := json.Unmarshal(body, &r)
		return r, err
	case string(TypeThing):
		var t Thing
		err := json.Unmarshal(body, &t)
		return t, err
	case string(TypeCreativeWork):
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	case string(TypeIdentifiable):
		var i Identifiable
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeErrorResponse):
		var er ErrorResponse
		err := json.Unmarshal(body, &er)
		return er, err
	case string(TypeTrendingVideos):
		var tv TrendingVideos
		err := json.Unmarshal(body, &tv)
		return tv, err
	case string(TypeVideoDetails):
		var vd VideoDetails
		err := json.Unmarshal(body, &vd)
		return vd, err
	default:
		var rb ResponseBase
		err := json.Unmarshal(body, &rb)
		return rb, err
	}
}
func unmarshalBasicResponseBaseArray(body []byte) ([]BasicResponseBase, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rbArray := make([]BasicResponseBase, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rb, err := unmarshalBasicResponseBase(*rawMessage)
		if err != nil {
			return nil, err
		}
		rbArray[index] = rb
	}
	return rbArray, nil
}

// MarshalJSON is the custom marshaler for ResponseBase.
func (rb ResponseBase) MarshalJSON() ([]byte, error) {
	rb.Type = TypeResponseBase
	type Alias ResponseBase
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(rb),
	})
}

// AsImageObject is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsVideos is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsVideos() (*Videos, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicResponse() (BasicResponse, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsTrendingVideos is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsTrendingVideos() (*TrendingVideos, bool) {
	return nil, false
}

// AsVideoDetails is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsVideoDetails() (*VideoDetails, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsResponseBase() (*ResponseBase, bool) {
	return &rb, true
}

// AsBasicResponseBase is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &rb, true
}

// BasicSearchResultsAnswer
type BasicSearchResultsAnswer interface {
	AsVideos() (*Videos, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
}

// SearchResultsAnswer
type SearchResultsAnswer struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeVideoObject', 'TypeVideos', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeTrendingVideos', 'TypeVideoDetails'
	Type Type `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL    *string  `json:"webSearchUrl,omitempty"`
	FollowUpQueries *[]Query `json:"followUpQueries,omitempty"`
	// TotalEstimatedMatches - The estimated number of webpages that are relevant to the query. Use this number along with the count and offset query parameters to page the results.
	TotalEstimatedMatches *int64 `json:"totalEstimatedMatches,omitempty"`
	IsFamilyFriendly      *bool  `json:"isFamilyFriendly,omitempty"`
}

func unmarshalBasicSearchResultsAnswer(body []byte) (BasicSearchResultsAnswer, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeVideos):
		var vVar Videos
		err := json.Unmarshal(body, &vVar)
		return vVar, err
	default:
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	}
}
func unmarshalBasicSearchResultsAnswerArray(body []byte) ([]BasicSearchResultsAnswer, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	sraArray := make([]BasicSearchResultsAnswer, len(rawMessages))

	for index, rawMessage := range rawMessages {
		sra, err := unmarshalBasicSearchResultsAnswer(*rawMessage)
		if err != nil {
			return nil, err
		}
		sraArray[index] = sra
	}
	return sraArray, nil
}

// MarshalJSON is the custom marshaler for SearchResultsAnswer.
func (sra SearchResultsAnswer) MarshalJSON() ([]byte, error) {
	sra.Type = TypeSearchResultsAnswer
	type Alias SearchResultsAnswer
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(sra),
	})
}

// AsImageObject is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsVideos is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsVideos() (*Videos, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return &sra, true
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return &sra, true
}

// AsAnswer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicAnswer() (BasicAnswer, bool) {
	return &sra, true
}

// AsMediaObject is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicResponse() (BasicResponse, bool) {
	return &sra, true
}

// AsThing is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &sra, true
}

// AsErrorResponse is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsTrendingVideos is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsTrendingVideos() (*TrendingVideos, bool) {
	return nil, false
}

// AsVideoDetails is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsVideoDetails() (*VideoDetails, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &sra, true
}

// BasicThing
type BasicThing interface {
	AsImageObject() (*ImageObject, bool)
	AsVideoObject() (*VideoObject, bool)
	AsMediaObject() (*MediaObject, bool)
	AsBasicMediaObject() (BasicMediaObject, bool)
	AsCreativeWork() (*CreativeWork, bool)
	AsBasicCreativeWork() (BasicCreativeWork, bool)
	AsThing() (*Thing, bool)
}

// Thing
type Thing struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeVideoObject', 'TypeVideos', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeTrendingVideos', 'TypeVideoDetails'
	Type Type `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL   *string      `json:"url,omitempty"`
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description   *string `json:"description,omitempty"`
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
}

func unmarshalBasicThing(body []byte) (BasicThing, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	case string(TypeVideoObject):
		var vo VideoObject
		err := json.Unmarshal(body, &vo)
		return vo, err
	case string(TypeMediaObject):
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	case string(TypeCreativeWork):
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	default:
		var t Thing
		err := json.Unmarshal(body, &t)
		return t, err
	}
}
func unmarshalBasicThingArray(body []byte) ([]BasicThing, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	tArray := make([]BasicThing, len(rawMessages))

	for index, rawMessage := range rawMessages {
		t, err := unmarshalBasicThing(*rawMessage)
		if err != nil {
			return nil, err
		}
		tArray[index] = t
	}
	return tArray, nil
}

// MarshalJSON is the custom marshaler for Thing.
func (t Thing) MarshalJSON() ([]byte, error) {
	t.Type = TypeThing
	type Alias Thing
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(t),
	})
}

// AsImageObject is the BasicResponseBase implementation for Thing.
func (t Thing) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for Thing.
func (t Thing) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsVideos is the BasicResponseBase implementation for Thing.
func (t Thing) AsVideos() (*Videos, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Thing.
func (t Thing) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for Thing.
func (t Thing) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Thing.
func (t Thing) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Thing.
func (t Thing) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicResponse() (BasicResponse, bool) {
	return &t, true
}

// AsThing is the BasicResponseBase implementation for Thing.
func (t Thing) AsThing() (*Thing, bool) {
	return &t, true
}

// AsBasicThing is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicThing() (BasicThing, bool) {
	return &t, true
}

// AsCreativeWork is the BasicResponseBase implementation for Thing.
func (t Thing) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Thing.
func (t Thing) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &t, true
}

// AsErrorResponse is the BasicResponseBase implementation for Thing.
func (t Thing) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsTrendingVideos is the BasicResponseBase implementation for Thing.
func (t Thing) AsTrendingVideos() (*TrendingVideos, bool) {
	return nil, false
}

// AsVideoDetails is the BasicResponseBase implementation for Thing.
func (t Thing) AsVideoDetails() (*VideoDetails, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Thing.
func (t Thing) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &t, true
}

// TrendingVideos ...
type TrendingVideos struct {
	autorest.Response `json:"-"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeVideoObject', 'TypeVideos', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeTrendingVideos', 'TypeVideoDetails'
	Type Type `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string                   `json:"webSearchUrl,omitempty"`
	BannerTiles  *[]TrendingVideosTile     `json:"bannerTiles,omitempty"`
	Categories   *[]TrendingVideosCategory `json:"categories,omitempty"`
}

// MarshalJSON is the custom marshaler for TrendingVideos.
func (tv TrendingVideos) MarshalJSON() ([]byte, error) {
	tv.Type = TypeTrendingVideos
	type Alias TrendingVideos
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(tv),
	})
}

// AsImageObject is the BasicResponseBase implementation for TrendingVideos.
func (tv TrendingVideos) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for TrendingVideos.
func (tv TrendingVideos) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsVideos is the BasicResponseBase implementation for TrendingVideos.
func (tv TrendingVideos) AsVideos() (*Videos, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for TrendingVideos.
func (tv TrendingVideos) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for TrendingVideos.
func (tv TrendingVideos) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for TrendingVideos.
func (tv TrendingVideos) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for TrendingVideos.
func (tv TrendingVideos) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for TrendingVideos.
func (tv TrendingVideos) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for TrendingVideos.
func (tv TrendingVideos) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for TrendingVideos.
func (tv TrendingVideos) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for TrendingVideos.
func (tv TrendingVideos) AsBasicResponse() (BasicResponse, bool) {
	return &tv, true
}

// AsThing is the BasicResponseBase implementation for TrendingVideos.
func (tv TrendingVideos) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for TrendingVideos.
func (tv TrendingVideos) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for TrendingVideos.
func (tv TrendingVideos) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for TrendingVideos.
func (tv TrendingVideos) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for TrendingVideos.
func (tv TrendingVideos) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for TrendingVideos.
func (tv TrendingVideos) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &tv, true
}

// AsErrorResponse is the BasicResponseBase implementation for TrendingVideos.
func (tv TrendingVideos) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsTrendingVideos is the BasicResponseBase implementation for TrendingVideos.
func (tv TrendingVideos) AsTrendingVideos() (*TrendingVideos, bool) {
	return &tv, true
}

// AsVideoDetails is the BasicResponseBase implementation for TrendingVideos.
func (tv TrendingVideos) AsVideoDetails() (*VideoDetails, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for TrendingVideos.
func (tv TrendingVideos) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for TrendingVideos.
func (tv TrendingVideos) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &tv, true
}

// TrendingVideosCategory ...
type TrendingVideosCategory struct {
	Title         *string                      `json:"title,omitempty"`
	Subcategories *[]TrendingVideosSubcategory `json:"subcategories,omitempty"`
}

// TrendingVideosSubcategory ...
type TrendingVideosSubcategory struct {
	Title *string               `json:"title,omitempty"`
	Tiles *[]TrendingVideosTile `json:"tiles,omitempty"`
}

// TrendingVideosTile ...
type TrendingVideosTile struct {
	Query *Query       `json:"query,omitempty"`
	Image *ImageObject `json:"image,omitempty"`
}

// VideoDetails ...
type VideoDetails struct {
	autorest.Response `json:"-"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeVideoObject', 'TypeVideos', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeTrendingVideos', 'TypeVideoDetails'
	Type Type `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL  *string       `json:"webSearchUrl,omitempty"`
	RelatedVideos *VideosModule `json:"relatedVideos,omitempty"`
	VideoResult   *VideoObject  `json:"videoResult,omitempty"`
}

// MarshalJSON is the custom marshaler for VideoDetails.
func (vd VideoDetails) MarshalJSON() ([]byte, error) {
	vd.Type = TypeVideoDetails
	type Alias VideoDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(vd),
	})
}

// AsImageObject is the BasicResponseBase implementation for VideoDetails.
func (vd VideoDetails) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for VideoDetails.
func (vd VideoDetails) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsVideos is the BasicResponseBase implementation for VideoDetails.
func (vd VideoDetails) AsVideos() (*Videos, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for VideoDetails.
func (vd VideoDetails) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for VideoDetails.
func (vd VideoDetails) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for VideoDetails.
func (vd VideoDetails) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for VideoDetails.
func (vd VideoDetails) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for VideoDetails.
func (vd VideoDetails) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for VideoDetails.
func (vd VideoDetails) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for VideoDetails.
func (vd VideoDetails) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for VideoDetails.
func (vd VideoDetails) AsBasicResponse() (BasicResponse, bool) {
	return &vd, true
}

// AsThing is the BasicResponseBase implementation for VideoDetails.
func (vd VideoDetails) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for VideoDetails.
func (vd VideoDetails) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for VideoDetails.
func (vd VideoDetails) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for VideoDetails.
func (vd VideoDetails) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for VideoDetails.
func (vd VideoDetails) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for VideoDetails.
func (vd VideoDetails) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &vd, true
}

// AsErrorResponse is the BasicResponseBase implementation for VideoDetails.
func (vd VideoDetails) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsTrendingVideos is the BasicResponseBase implementation for VideoDetails.
func (vd VideoDetails) AsTrendingVideos() (*TrendingVideos, bool) {
	return nil, false
}

// AsVideoDetails is the BasicResponseBase implementation for VideoDetails.
func (vd VideoDetails) AsVideoDetails() (*VideoDetails, bool) {
	return &vd, true
}

// AsResponseBase is the BasicResponseBase implementation for VideoDetails.
func (vd VideoDetails) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for VideoDetails.
func (vd VideoDetails) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &vd, true
}

// VideoObject defines a video object that is relevant to the query.
type VideoObject struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeVideoObject', 'TypeVideos', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeTrendingVideos', 'TypeVideoDetails'
	Type Type `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL   *string      `json:"url,omitempty"`
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description   *string `json:"description,omitempty"`
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	Text     *string       `json:"text,omitempty"`
	// ContentURL - Original URL to retrieve the source (file) for the media object (e.g the source URL for the image).
	ContentURL *string `json:"contentUrl,omitempty"`
	// HostPageURL - URL of the page that hosts the media object.
	HostPageURL *string `json:"hostPageUrl,omitempty"`
	// Width - The width of the source media object, in pixels.
	Width *int32 `json:"width,omitempty"`
	// Height - The height of the source media object, in pixels.
	Height             *int32       `json:"height,omitempty"`
	MotionThumbnailURL *string      `json:"motionThumbnailUrl,omitempty"`
	MotionThumbnailID  *string      `json:"motionThumbnailId,omitempty"`
	EmbedHTML          *string      `json:"embedHtml,omitempty"`
	AllowHTTPSEmbed    *bool        `json:"allowHttpsEmbed,omitempty"`
	ViewCount          *int32       `json:"viewCount,omitempty"`
	Thumbnail          *ImageObject `json:"thumbnail,omitempty"`
	VideoID            *string      `json:"videoId,omitempty"`
	AllowMobileEmbed   *bool        `json:"allowMobileEmbed,omitempty"`
	IsSuperfresh       *bool        `json:"isSuperfresh,omitempty"`
}

// MarshalJSON is the custom marshaler for VideoObject.
func (vo VideoObject) MarshalJSON() ([]byte, error) {
	vo.Type = TypeVideoObject
	type Alias VideoObject
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(vo),
	})
}

// AsImageObject is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsVideoObject() (*VideoObject, bool) {
	return &vo, true
}

// AsVideos is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsVideos() (*Videos, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsBasicMediaObject() (BasicMediaObject, bool) {
	return &vo, true
}

// AsResponse is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsBasicResponse() (BasicResponse, bool) {
	return &vo, true
}

// AsThing is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsBasicThing() (BasicThing, bool) {
	return &vo, true
}

// AsCreativeWork is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &vo, true
}

// AsIdentifiable is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &vo, true
}

// AsErrorResponse is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsTrendingVideos is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsTrendingVideos() (*TrendingVideos, bool) {
	return nil, false
}

// AsVideoDetails is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsVideoDetails() (*VideoDetails, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for VideoObject.
func (vo VideoObject) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &vo, true
}

// UnmarshalJSON is the custom unmarshaler for VideoObject struct.
func (vo *VideoObject) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["motionThumbnailUrl"]
	if v != nil {
		var motionThumbnailURL string
		err = json.Unmarshal(*m["motionThumbnailUrl"], &motionThumbnailURL)
		if err != nil {
			return err
		}
		vo.MotionThumbnailURL = &motionThumbnailURL
	}

	v = m["motionThumbnailId"]
	if v != nil {
		var motionThumbnailID string
		err = json.Unmarshal(*m["motionThumbnailId"], &motionThumbnailID)
		if err != nil {
			return err
		}
		vo.MotionThumbnailID = &motionThumbnailID
	}

	v = m["embedHtml"]
	if v != nil {
		var embedHTML string
		err = json.Unmarshal(*m["embedHtml"], &embedHTML)
		if err != nil {
			return err
		}
		vo.EmbedHTML = &embedHTML
	}

	v = m["allowHttpsEmbed"]
	if v != nil {
		var allowHTTPSEmbed bool
		err = json.Unmarshal(*m["allowHttpsEmbed"], &allowHTTPSEmbed)
		if err != nil {
			return err
		}
		vo.AllowHTTPSEmbed = &allowHTTPSEmbed
	}

	v = m["viewCount"]
	if v != nil {
		var viewCount int32
		err = json.Unmarshal(*m["viewCount"], &viewCount)
		if err != nil {
			return err
		}
		vo.ViewCount = &viewCount
	}

	v = m["thumbnail"]
	if v != nil {
		var thumbnail ImageObject
		err = json.Unmarshal(*m["thumbnail"], &thumbnail)
		if err != nil {
			return err
		}
		vo.Thumbnail = &thumbnail
	}

	v = m["videoId"]
	if v != nil {
		var videoID string
		err = json.Unmarshal(*m["videoId"], &videoID)
		if err != nil {
			return err
		}
		vo.VideoID = &videoID
	}

	v = m["allowMobileEmbed"]
	if v != nil {
		var allowMobileEmbed bool
		err = json.Unmarshal(*m["allowMobileEmbed"], &allowMobileEmbed)
		if err != nil {
			return err
		}
		vo.AllowMobileEmbed = &allowMobileEmbed
	}

	v = m["isSuperfresh"]
	if v != nil {
		var isSuperfresh bool
		err = json.Unmarshal(*m["isSuperfresh"], &isSuperfresh)
		if err != nil {
			return err
		}
		vo.IsSuperfresh = &isSuperfresh
	}

	v = m["contentUrl"]
	if v != nil {
		var contentURL string
		err = json.Unmarshal(*m["contentUrl"], &contentURL)
		if err != nil {
			return err
		}
		vo.ContentURL = &contentURL
	}

	v = m["hostPageUrl"]
	if v != nil {
		var hostPageURL string
		err = json.Unmarshal(*m["hostPageUrl"], &hostPageURL)
		if err != nil {
			return err
		}
		vo.HostPageURL = &hostPageURL
	}

	v = m["width"]
	if v != nil {
		var width int32
		err = json.Unmarshal(*m["width"], &width)
		if err != nil {
			return err
		}
		vo.Width = &width
	}

	v = m["height"]
	if v != nil {
		var height int32
		err = json.Unmarshal(*m["height"], &height)
		if err != nil {
			return err
		}
		vo.Height = &height
	}

	v = m["thumbnailUrl"]
	if v != nil {
		var thumbnailURL string
		err = json.Unmarshal(*m["thumbnailUrl"], &thumbnailURL)
		if err != nil {
			return err
		}
		vo.ThumbnailURL = &thumbnailURL
	}

	v = m["provider"]
	if v != nil {
		provider, err := unmarshalBasicThingArray(*m["provider"])
		if err != nil {
			return err
		}
		vo.Provider = &provider
	}

	v = m["text"]
	if v != nil {
		var textVar string
		err = json.Unmarshal(*m["text"], &textVar)
		if err != nil {
			return err
		}
		vo.Text = &textVar
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		vo.Name = &name
	}

	v = m["url"]
	if v != nil {
		var URLVar string
		err = json.Unmarshal(*m["url"], &URLVar)
		if err != nil {
			return err
		}
		vo.URL = &URLVar
	}

	v = m["image"]
	if v != nil {
		var imageVar ImageObject
		err = json.Unmarshal(*m["image"], &imageVar)
		if err != nil {
			return err
		}
		vo.Image = &imageVar
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		vo.Description = &description
	}

	v = m["alternateName"]
	if v != nil {
		var alternateName string
		err = json.Unmarshal(*m["alternateName"], &alternateName)
		if err != nil {
			return err
		}
		vo.AlternateName = &alternateName
	}

	v = m["bingId"]
	if v != nil {
		var bingID string
		err = json.Unmarshal(*m["bingId"], &bingID)
		if err != nil {
			return err
		}
		vo.BingID = &bingID
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		vo.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		vo.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type Type
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		vo.Type = _type
	}

	return nil
}

// Videos defines a video answer.
type Videos struct {
	autorest.Response `json:"-"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeVideoObject', 'TypeVideos', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeTrendingVideos', 'TypeVideoDetails'
	Type Type `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL    *string  `json:"webSearchUrl,omitempty"`
	FollowUpQueries *[]Query `json:"followUpQueries,omitempty"`
	// TotalEstimatedMatches - The estimated number of webpages that are relevant to the query. Use this number along with the count and offset query parameters to page the results.
	TotalEstimatedMatches *int64 `json:"totalEstimatedMatches,omitempty"`
	IsFamilyFriendly      *bool  `json:"isFamilyFriendly,omitempty"`
	// Value - A list of video objects that are relevant to the query.
	Value      *[]VideoObject `json:"value,omitempty"`
	NextOffset *int32         `json:"nextOffset,omitempty"`
	// Scenario - Possible values include: 'List', 'SingleDominantVideo'
	Scenario         VideoQueryScenario  `json:"scenario,omitempty"`
	QueryExpansions  *[]Query            `json:"queryExpansions,omitempty"`
	PivotSuggestions *[]PivotSuggestions `json:"pivotSuggestions,omitempty"`
}

// MarshalJSON is the custom marshaler for Videos.
func (vVar Videos) MarshalJSON() ([]byte, error) {
	vVar.Type = TypeVideos
	type Alias Videos
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(vVar),
	})
}

// AsImageObject is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsVideoObject is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsVideoObject() (*VideoObject, bool) {
	return nil, false
}

// AsVideos is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsVideos() (*Videos, bool) {
	return &vVar, true
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return &vVar, true
}

// AsAnswer is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsBasicAnswer() (BasicAnswer, bool) {
	return &vVar, true
}

// AsMediaObject is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsBasicResponse() (BasicResponse, bool) {
	return &vVar, true
}

// AsThing is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &vVar, true
}

// AsErrorResponse is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsTrendingVideos is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsTrendingVideos() (*TrendingVideos, bool) {
	return nil, false
}

// AsVideoDetails is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsVideoDetails() (*VideoDetails, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Videos.
func (vVar Videos) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &vVar, true
}

// VideosModule ...
type VideosModule struct {
	Value *[]VideoObject `json:"value,omitempty"`
}
