package imagesearch

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
)

// Currency enumerates the values for currency.
type Currency string

const (
	// AED ...
	AED Currency = "AED"
	// AFN ...
	AFN Currency = "AFN"
	// ALL ...
	ALL Currency = "ALL"
	// AMD ...
	AMD Currency = "AMD"
	// ANG ...
	ANG Currency = "ANG"
	// AOA ...
	AOA Currency = "AOA"
	// ARS ...
	ARS Currency = "ARS"
	// AUD ...
	AUD Currency = "AUD"
	// AWG ...
	AWG Currency = "AWG"
	// AZN ...
	AZN Currency = "AZN"
	// BAM ...
	BAM Currency = "BAM"
	// BBD ...
	BBD Currency = "BBD"
	// BDT ...
	BDT Currency = "BDT"
	// BGN ...
	BGN Currency = "BGN"
	// BHD ...
	BHD Currency = "BHD"
	// BIF ...
	BIF Currency = "BIF"
	// BMD ...
	BMD Currency = "BMD"
	// BND ...
	BND Currency = "BND"
	// BOB ...
	BOB Currency = "BOB"
	// BOV ...
	BOV Currency = "BOV"
	// BRL ...
	BRL Currency = "BRL"
	// BSD ...
	BSD Currency = "BSD"
	// BTN ...
	BTN Currency = "BTN"
	// BWP ...
	BWP Currency = "BWP"
	// BYR ...
	BYR Currency = "BYR"
	// BZD ...
	BZD Currency = "BZD"
	// CAD ...
	CAD Currency = "CAD"
	// CDF ...
	CDF Currency = "CDF"
	// CHE ...
	CHE Currency = "CHE"
	// CHF ...
	CHF Currency = "CHF"
	// CHW ...
	CHW Currency = "CHW"
	// CLF ...
	CLF Currency = "CLF"
	// CLP ...
	CLP Currency = "CLP"
	// CNY ...
	CNY Currency = "CNY"
	// COP ...
	COP Currency = "COP"
	// COU ...
	COU Currency = "COU"
	// CRC ...
	CRC Currency = "CRC"
	// CUC ...
	CUC Currency = "CUC"
	// CUP ...
	CUP Currency = "CUP"
	// CVE ...
	CVE Currency = "CVE"
	// CZK ...
	CZK Currency = "CZK"
	// DJF ...
	DJF Currency = "DJF"
	// DKK ...
	DKK Currency = "DKK"
	// DOP ...
	DOP Currency = "DOP"
	// DZD ...
	DZD Currency = "DZD"
	// EGP ...
	EGP Currency = "EGP"
	// ERN ...
	ERN Currency = "ERN"
	// ETB ...
	ETB Currency = "ETB"
	// EUR ...
	EUR Currency = "EUR"
	// FJD ...
	FJD Currency = "FJD"
	// FKP ...
	FKP Currency = "FKP"
	// GBP ...
	GBP Currency = "GBP"
	// GEL ...
	GEL Currency = "GEL"
	// GHS ...
	GHS Currency = "GHS"
	// GIP ...
	GIP Currency = "GIP"
	// GMD ...
	GMD Currency = "GMD"
	// GNF ...
	GNF Currency = "GNF"
	// GTQ ...
	GTQ Currency = "GTQ"
	// GYD ...
	GYD Currency = "GYD"
	// HKD ...
	HKD Currency = "HKD"
	// HNL ...
	HNL Currency = "HNL"
	// HRK ...
	HRK Currency = "HRK"
	// HTG ...
	HTG Currency = "HTG"
	// HUF ...
	HUF Currency = "HUF"
	// IDR ...
	IDR Currency = "IDR"
	// ILS ...
	ILS Currency = "ILS"
	// INR ...
	INR Currency = "INR"
	// IQD ...
	IQD Currency = "IQD"
	// IRR ...
	IRR Currency = "IRR"
	// ISK ...
	ISK Currency = "ISK"
	// JMD ...
	JMD Currency = "JMD"
	// JOD ...
	JOD Currency = "JOD"
	// JPY ...
	JPY Currency = "JPY"
	// KES ...
	KES Currency = "KES"
	// KGS ...
	KGS Currency = "KGS"
	// KHR ...
	KHR Currency = "KHR"
	// KMF ...
	KMF Currency = "KMF"
	// KPW ...
	KPW Currency = "KPW"
	// KRW ...
	KRW Currency = "KRW"
	// KWD ...
	KWD Currency = "KWD"
	// KYD ...
	KYD Currency = "KYD"
	// KZT ...
	KZT Currency = "KZT"
	// LAK ...
	LAK Currency = "LAK"
	// LBP ...
	LBP Currency = "LBP"
	// LKR ...
	LKR Currency = "LKR"
	// LRD ...
	LRD Currency = "LRD"
	// LSL ...
	LSL Currency = "LSL"
	// LYD ...
	LYD Currency = "LYD"
	// MAD ...
	MAD Currency = "MAD"
	// MDL ...
	MDL Currency = "MDL"
	// MGA ...
	MGA Currency = "MGA"
	// MKD ...
	MKD Currency = "MKD"
	// MMK ...
	MMK Currency = "MMK"
	// MNT ...
	MNT Currency = "MNT"
	// MOP ...
	MOP Currency = "MOP"
	// MRO ...
	MRO Currency = "MRO"
	// MUR ...
	MUR Currency = "MUR"
	// MVR ...
	MVR Currency = "MVR"
	// MWK ...
	MWK Currency = "MWK"
	// MXN ...
	MXN Currency = "MXN"
	// MXV ...
	MXV Currency = "MXV"
	// MYR ...
	MYR Currency = "MYR"
	// MZN ...
	MZN Currency = "MZN"
	// NAD ...
	NAD Currency = "NAD"
	// NGN ...
	NGN Currency = "NGN"
	// NIO ...
	NIO Currency = "NIO"
	// NOK ...
	NOK Currency = "NOK"
	// NPR ...
	NPR Currency = "NPR"
	// NZD ...
	NZD Currency = "NZD"
	// OMR ...
	OMR Currency = "OMR"
	// PAB ...
	PAB Currency = "PAB"
	// PEN ...
	PEN Currency = "PEN"
	// PGK ...
	PGK Currency = "PGK"
	// PHP ...
	PHP Currency = "PHP"
	// PKR ...
	PKR Currency = "PKR"
	// PLN ...
	PLN Currency = "PLN"
	// PYG ...
	PYG Currency = "PYG"
	// QAR ...
	QAR Currency = "QAR"
	// RON ...
	RON Currency = "RON"
	// RSD ...
	RSD Currency = "RSD"
	// RUB ...
	RUB Currency = "RUB"
	// RWF ...
	RWF Currency = "RWF"
	// SAR ...
	SAR Currency = "SAR"
	// SBD ...
	SBD Currency = "SBD"
	// SCR ...
	SCR Currency = "SCR"
	// SDG ...
	SDG Currency = "SDG"
	// SEK ...
	SEK Currency = "SEK"
	// SGD ...
	SGD Currency = "SGD"
	// SHP ...
	SHP Currency = "SHP"
	// SLL ...
	SLL Currency = "SLL"
	// SOS ...
	SOS Currency = "SOS"
	// SRD ...
	SRD Currency = "SRD"
	// SSP ...
	SSP Currency = "SSP"
	// STD ...
	STD Currency = "STD"
	// SYP ...
	SYP Currency = "SYP"
	// SZL ...
	SZL Currency = "SZL"
	// THB ...
	THB Currency = "THB"
	// TJS ...
	TJS Currency = "TJS"
	// TMT ...
	TMT Currency = "TMT"
	// TND ...
	TND Currency = "TND"
	// TOP ...
	TOP Currency = "TOP"
	// TRY ...
	TRY Currency = "TRY"
	// TTD ...
	TTD Currency = "TTD"
	// TWD ...
	TWD Currency = "TWD"
	// TZS ...
	TZS Currency = "TZS"
	// UAH ...
	UAH Currency = "UAH"
	// UGX ...
	UGX Currency = "UGX"
	// USD ...
	USD Currency = "USD"
	// UYU ...
	UYU Currency = "UYU"
	// UZS ...
	UZS Currency = "UZS"
	// VEF ...
	VEF Currency = "VEF"
	// VND ...
	VND Currency = "VND"
	// VUV ...
	VUV Currency = "VUV"
	// WST ...
	WST Currency = "WST"
	// XAF ...
	XAF Currency = "XAF"
	// XCD ...
	XCD Currency = "XCD"
	// XOF ...
	XOF Currency = "XOF"
	// XPF ...
	XPF Currency = "XPF"
	// YER ...
	YER Currency = "YER"
	// ZAR ...
	ZAR Currency = "ZAR"
	// ZMW ...
	ZMW Currency = "ZMW"
)

// ErrorCode enumerates the values for error code.
type ErrorCode string

const (
	// InsufficientAuthorization ...
	InsufficientAuthorization ErrorCode = "InsufficientAuthorization"
	// InvalidAuthorization ...
	InvalidAuthorization ErrorCode = "InvalidAuthorization"
	// InvalidRequest ...
	InvalidRequest ErrorCode = "InvalidRequest"
	// None ...
	None ErrorCode = "None"
	// RateLimitExceeded ...
	RateLimitExceeded ErrorCode = "RateLimitExceeded"
	// ServerError ...
	ServerError ErrorCode = "ServerError"
)

// ErrorSubCode enumerates the values for error sub code.
type ErrorSubCode string

const (
	// AuthorizationDisabled ...
	AuthorizationDisabled ErrorSubCode = "AuthorizationDisabled"
	// AuthorizationExpired ...
	AuthorizationExpired ErrorSubCode = "AuthorizationExpired"
	// AuthorizationMissing ...
	AuthorizationMissing ErrorSubCode = "AuthorizationMissing"
	// AuthorizationRedundancy ...
	AuthorizationRedundancy ErrorSubCode = "AuthorizationRedundancy"
	// Blocked ...
	Blocked ErrorSubCode = "Blocked"
	// HTTPNotAllowed ...
	HTTPNotAllowed ErrorSubCode = "HttpNotAllowed"
	// NotImplemented ...
	NotImplemented ErrorSubCode = "NotImplemented"
	// ParameterInvalidValue ...
	ParameterInvalidValue ErrorSubCode = "ParameterInvalidValue"
	// ParameterMissing ...
	ParameterMissing ErrorSubCode = "ParameterMissing"
	// ResourceError ...
	ResourceError ErrorSubCode = "ResourceError"
	// UnexpectedError ...
	UnexpectedError ErrorSubCode = "UnexpectedError"
)

// Freshness enumerates the values for freshness.
type Freshness string

const (
	// Day ...
	Day Freshness = "Day"
	// Month ...
	Month Freshness = "Month"
	// Week ...
	Week Freshness = "Week"
)

// ImageAspect enumerates the values for image aspect.
type ImageAspect string

const (
	// All ...
	All ImageAspect = "All"
	// Square ...
	Square ImageAspect = "Square"
	// Tall ...
	Tall ImageAspect = "Tall"
	// Wide ...
	Wide ImageAspect = "Wide"
)

// ImageColor enumerates the values for image color.
type ImageColor string

const (
	// Black ...
	Black ImageColor = "Black"
	// Blue ...
	Blue ImageColor = "Blue"
	// Brown ...
	Brown ImageColor = "Brown"
	// ColorOnly ...
	ColorOnly ImageColor = "ColorOnly"
	// Gray ...
	Gray ImageColor = "Gray"
	// Green ...
	Green ImageColor = "Green"
	// Monochrome ...
	Monochrome ImageColor = "Monochrome"
	// Orange ...
	Orange ImageColor = "Orange"
	// Pink ...
	Pink ImageColor = "Pink"
	// Purple ...
	Purple ImageColor = "Purple"
	// Red ...
	Red ImageColor = "Red"
	// Teal ...
	Teal ImageColor = "Teal"
	// White ...
	White ImageColor = "White"
	// Yellow ...
	Yellow ImageColor = "Yellow"
)

// ImageContent enumerates the values for image content.
type ImageContent string

const (
	// Face ...
	Face ImageContent = "Face"
	// Portrait ...
	Portrait ImageContent = "Portrait"
)

// ImageCropType enumerates the values for image crop type.
type ImageCropType string

const (
	// Rectangular ...
	Rectangular ImageCropType = "Rectangular"
)

// ImageInsightModule enumerates the values for image insight module.
type ImageInsightModule string

const (
	// ImageInsightModuleAll ...
	ImageInsightModuleAll ImageInsightModule = "All"
	// ImageInsightModuleBRQ ...
	ImageInsightModuleBRQ ImageInsightModule = "BRQ"
	// ImageInsightModuleCaption ...
	ImageInsightModuleCaption ImageInsightModule = "Caption"
	// ImageInsightModuleCollections ...
	ImageInsightModuleCollections ImageInsightModule = "Collections"
	// ImageInsightModulePagesIncluding ...
	ImageInsightModulePagesIncluding ImageInsightModule = "PagesIncluding"
	// ImageInsightModuleRecipes ...
	ImageInsightModuleRecipes ImageInsightModule = "Recipes"
	// ImageInsightModuleRecognizedEntities ...
	ImageInsightModuleRecognizedEntities ImageInsightModule = "RecognizedEntities"
	// ImageInsightModuleRelatedSearches ...
	ImageInsightModuleRelatedSearches ImageInsightModule = "RelatedSearches"
	// ImageInsightModuleShoppingSources ...
	ImageInsightModuleShoppingSources ImageInsightModule = "ShoppingSources"
	// ImageInsightModuleSimilarImages ...
	ImageInsightModuleSimilarImages ImageInsightModule = "SimilarImages"
	// ImageInsightModuleSimilarProducts ...
	ImageInsightModuleSimilarProducts ImageInsightModule = "SimilarProducts"
	// ImageInsightModuleTags ...
	ImageInsightModuleTags ImageInsightModule = "Tags"
)

// ImageLicense enumerates the values for image license.
type ImageLicense string

const (
	// ImageLicenseAll ...
	ImageLicenseAll ImageLicense = "All"
	// ImageLicenseAny ...
	ImageLicenseAny ImageLicense = "Any"
	// ImageLicenseModify ...
	ImageLicenseModify ImageLicense = "Modify"
	// ImageLicenseModifyCommercially ...
	ImageLicenseModifyCommercially ImageLicense = "ModifyCommercially"
	// ImageLicensePublic ...
	ImageLicensePublic ImageLicense = "Public"
	// ImageLicenseShare ...
	ImageLicenseShare ImageLicense = "Share"
	// ImageLicenseShareCommercially ...
	ImageLicenseShareCommercially ImageLicense = "ShareCommercially"
)

// ImageSize enumerates the values for image size.
type ImageSize string

const (
	// ImageSizeAll ...
	ImageSizeAll ImageSize = "All"
	// ImageSizeLarge ...
	ImageSizeLarge ImageSize = "Large"
	// ImageSizeMedium ...
	ImageSizeMedium ImageSize = "Medium"
	// ImageSizeSmall ...
	ImageSizeSmall ImageSize = "Small"
	// ImageSizeWallpaper ...
	ImageSizeWallpaper ImageSize = "Wallpaper"
)

// ImageType enumerates the values for image type.
type ImageType string

const (
	// AnimatedGif ...
	AnimatedGif ImageType = "AnimatedGif"
	// Clipart ...
	Clipart ImageType = "Clipart"
	// Line ...
	Line ImageType = "Line"
	// Photo ...
	Photo ImageType = "Photo"
	// Shopping ...
	Shopping ImageType = "Shopping"
	// Transparent ...
	Transparent ImageType = "Transparent"
)

// ItemAvailability enumerates the values for item availability.
type ItemAvailability string

const (
	// Discontinued ...
	Discontinued ItemAvailability = "Discontinued"
	// InStock ...
	InStock ItemAvailability = "InStock"
	// InStoreOnly ...
	InStoreOnly ItemAvailability = "InStoreOnly"
	// LimitedAvailability ...
	LimitedAvailability ItemAvailability = "LimitedAvailability"
	// OnlineOnly ...
	OnlineOnly ItemAvailability = "OnlineOnly"
	// OutOfStock ...
	OutOfStock ItemAvailability = "OutOfStock"
	// PreOrder ...
	PreOrder ItemAvailability = "PreOrder"
	// SoldOut ...
	SoldOut ItemAvailability = "SoldOut"
)

// SafeSearch enumerates the values for safe search.
type SafeSearch string

const (
	// Moderate ...
	Moderate SafeSearch = "Moderate"
	// Off ...
	Off SafeSearch = "Off"
	// Strict ...
	Strict SafeSearch = "Strict"
)

// Type enumerates the values for type.
type Type string

const (
	// TypeAggregateRating ...
	TypeAggregateRating Type = "AggregateRating"
	// TypePropertiesItem ...
	TypePropertiesItem Type = "Properties/Item"
	// TypeRating ...
	TypeRating Type = "Rating"
)

// TypeBasicResponseBase enumerates the values for type basic response base.
type TypeBasicResponseBase string

const (
	// TypeAggregateOffer ...
	TypeAggregateOffer TypeBasicResponseBase = "AggregateOffer"
	// TypeAnswer ...
	TypeAnswer TypeBasicResponseBase = "Answer"
	// TypeCollectionPage ...
	TypeCollectionPage TypeBasicResponseBase = "CollectionPage"
	// TypeCreativeWork ...
	TypeCreativeWork TypeBasicResponseBase = "CreativeWork"
	// TypeErrorResponse ...
	TypeErrorResponse TypeBasicResponseBase = "ErrorResponse"
	// TypeIdentifiable ...
	TypeIdentifiable TypeBasicResponseBase = "Identifiable"
	// TypeImageGallery ...
	TypeImageGallery TypeBasicResponseBase = "ImageGallery"
	// TypeImageInsights ...
	TypeImageInsights TypeBasicResponseBase = "ImageInsights"
	// TypeImageObject ...
	TypeImageObject TypeBasicResponseBase = "ImageObject"
	// TypeImages ...
	TypeImages TypeBasicResponseBase = "Images"
	// TypeIntangible ...
	TypeIntangible TypeBasicResponseBase = "Intangible"
	// TypeMediaObject ...
	TypeMediaObject TypeBasicResponseBase = "MediaObject"
	// TypeNormalizedRectangle ...
	TypeNormalizedRectangle TypeBasicResponseBase = "NormalizedRectangle"
	// TypeOffer ...
	TypeOffer TypeBasicResponseBase = "Offer"
	// TypeOrganization ...
	TypeOrganization TypeBasicResponseBase = "Organization"
	// TypePerson ...
	TypePerson TypeBasicResponseBase = "Person"
	// TypeRecipe ...
	TypeRecipe TypeBasicResponseBase = "Recipe"
	// TypeRecognizedEntity ...
	TypeRecognizedEntity TypeBasicResponseBase = "RecognizedEntity"
	// TypeRecognizedEntityRegion ...
	TypeRecognizedEntityRegion TypeBasicResponseBase = "RecognizedEntityRegion"
	// TypeResponse ...
	TypeResponse TypeBasicResponseBase = "Response"
	// TypeResponseBase ...
	TypeResponseBase TypeBasicResponseBase = "ResponseBase"
	// TypeSearchResultsAnswer ...
	TypeSearchResultsAnswer TypeBasicResponseBase = "SearchResultsAnswer"
	// TypeStructuredValue ...
	TypeStructuredValue TypeBasicResponseBase = "StructuredValue"
	// TypeThing ...
	TypeThing TypeBasicResponseBase = "Thing"
	// TypeTrendingImages ...
	TypeTrendingImages TypeBasicResponseBase = "TrendingImages"
	// TypeWebPage ...
	TypeWebPage TypeBasicResponseBase = "WebPage"
)

// AggregateOffer defines a list of offers from merchants that are related to the image.
type AggregateOffer struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeImageGallery', 'TypeRecipe', 'TypeNormalizedRectangle', 'TypeRecognizedEntity', 'TypeRecognizedEntityRegion', 'TypeImageInsights', 'TypeTrendingImages', 'TypeWebPage', 'TypePerson', 'TypeIntangible', 'TypeCollectionPage', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ReadLink - The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// Seller - Seller for this offer
	Seller *Organization `json:"seller,omitempty"`
	// Price - The item's price.
	Price *float64 `json:"price,omitempty"`
	// PriceCurrency - The monetary currency. For example, USD. Possible values include: 'USD', 'CAD', 'GBP', 'EUR', 'COP', 'JPY', 'CNY', 'AUD', 'INR', 'AED', 'AFN', 'ALL', 'AMD', 'ANG', 'AOA', 'ARS', 'AWG', 'AZN', 'BAM', 'BBD', 'BDT', 'BGN', 'BHD', 'BIF', 'BMD', 'BND', 'BOB', 'BOV', 'BRL', 'BSD', 'BTN', 'BWP', 'BYR', 'BZD', 'CDF', 'CHE', 'CHF', 'CHW', 'CLF', 'CLP', 'COU', 'CRC', 'CUC', 'CUP', 'CVE', 'CZK', 'DJF', 'DKK', 'DOP', 'DZD', 'EGP', 'ERN', 'ETB', 'FJD', 'FKP', 'GEL', 'GHS', 'GIP', 'GMD', 'GNF', 'GTQ', 'GYD', 'HKD', 'HNL', 'HRK', 'HTG', 'HUF', 'IDR', 'ILS', 'IQD', 'IRR', 'ISK', 'JMD', 'JOD', 'KES', 'KGS', 'KHR', 'KMF', 'KPW', 'KRW', 'KWD', 'KYD', 'KZT', 'LAK', 'LBP', 'LKR', 'LRD', 'LSL', 'LYD', 'MAD', 'MDL', 'MGA', 'MKD', 'MMK', 'MNT', 'MOP', 'MRO', 'MUR', 'MVR', 'MWK', 'MXN', 'MXV', 'MYR', 'MZN', 'NAD', 'NGN', 'NIO', 'NOK', 'NPR', 'NZD', 'OMR', 'PAB', 'PEN', 'PGK', 'PHP', 'PKR', 'PLN', 'PYG', 'QAR', 'RON', 'RSD', 'RUB', 'RWF', 'SAR', 'SBD', 'SCR', 'SDG', 'SEK', 'SGD', 'SHP', 'SLL', 'SOS', 'SRD', 'SSP', 'STD', 'SYP', 'SZL', 'THB', 'TJS', 'TMT', 'TND', 'TOP', 'TRY', 'TTD', 'TWD', 'TZS', 'UAH', 'UGX', 'UYU', 'UZS', 'VEF', 'VND', 'VUV', 'WST', 'XAF', 'XCD', 'XOF', 'XPF', 'YER', 'ZAR', 'ZMW'
	PriceCurrency Currency `json:"priceCurrency,omitempty"`
	// Availability - The item's availability. The following are the possible values: Discontinued, InStock, InStoreOnly, LimitedAvailability, OnlineOnly, OutOfStock, PreOrder, SoldOut. Possible values include: 'Discontinued', 'InStock', 'InStoreOnly', 'LimitedAvailability', 'OnlineOnly', 'OutOfStock', 'PreOrder', 'SoldOut'
	Availability ItemAvailability `json:"availability,omitempty"`
	// AggregateRating - An aggregated rating that indicates how well the product has been rated by others.
	AggregateRating *AggregateRating `json:"aggregateRating,omitempty"`
	// LastUpdated - The last date that the offer was updated. The date is in the form YYYY-MM-DD.
	LastUpdated *string `json:"lastUpdated,omitempty"`
	// Offers - A list of offers from merchants that have offerings related to the image.
	Offers *[]BasicOffer `json:"offers,omitempty"`
}

// MarshalJSON is the custom marshaler for AggregateOffer.
func (ao AggregateOffer) MarshalJSON() ([]byte, error) {
	ao.Type = TypeAggregateOffer
	type Alias AggregateOffer
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ao),
	})
}

// AsOrganization is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsBasicOffer() (BasicOffer, bool) {
	return &ao, true
}

// AsAggregateOffer is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsAggregateOffer() (*AggregateOffer, bool) {
	return &ao, true
}

// AsImageObject is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsBasicResponse() (BasicResponse, bool) {
	return &ao, true
}

// AsThing is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsBasicThing() (BasicThing, bool) {
	return &ao, true
}

// AsCreativeWork is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &ao, true
}

// AsErrorResponse is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsImageGallery is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsImageGallery() (*ImageGallery, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsNormalizedRectangle is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsNormalizedRectangle() (*NormalizedRectangle, bool) {
	return nil, false
}

// AsRecognizedEntity is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsRecognizedEntity() (*RecognizedEntity, bool) {
	return nil, false
}

// AsRecognizedEntityRegion is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsRecognizedEntityRegion() (*RecognizedEntityRegion, bool) {
	return nil, false
}

// AsImageInsights is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsImageInsights() (*ImageInsights, bool) {
	return nil, false
}

// AsTrendingImages is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsTrendingImages() (*TrendingImages, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsBasicWebPage is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsBasicWebPage() (BasicWebPage, bool) {
	return nil, false
}

// AsPerson is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsCollectionPage is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsCollectionPage() (*CollectionPage, bool) {
	return nil, false
}

// AsBasicCollectionPage is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsBasicCollectionPage() (BasicCollectionPage, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &ao, true
}

// UnmarshalJSON is the custom unmarshaler for AggregateOffer struct.
func (ao *AggregateOffer) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["offers"]
	if v != nil {
		offers, err := unmarshalBasicOfferArray(*m["offers"])
		if err != nil {
			return err
		}
		ao.Offers = &offers
	}

	v = m["seller"]
	if v != nil {
		var seller Organization
		err = json.Unmarshal(*m["seller"], &seller)
		if err != nil {
			return err
		}
		ao.Seller = &seller
	}

	v = m["price"]
	if v != nil {
		var price float64
		err = json.Unmarshal(*m["price"], &price)
		if err != nil {
			return err
		}
		ao.Price = &price
	}

	v = m["priceCurrency"]
	if v != nil {
		var priceCurrency Currency
		err = json.Unmarshal(*m["priceCurrency"], &priceCurrency)
		if err != nil {
			return err
		}
		ao.PriceCurrency = priceCurrency
	}

	v = m["availability"]
	if v != nil {
		var availability ItemAvailability
		err = json.Unmarshal(*m["availability"], &availability)
		if err != nil {
			return err
		}
		ao.Availability = availability
	}

	v = m["aggregateRating"]
	if v != nil {
		var aggregateRating AggregateRating
		err = json.Unmarshal(*m["aggregateRating"], &aggregateRating)
		if err != nil {
			return err
		}
		ao.AggregateRating = &aggregateRating
	}

	v = m["lastUpdated"]
	if v != nil {
		var lastUpdated string
		err = json.Unmarshal(*m["lastUpdated"], &lastUpdated)
		if err != nil {
			return err
		}
		ao.LastUpdated = &lastUpdated
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		ao.Name = &name
	}

	v = m["url"]
	if v != nil {
		var URLVar string
		err = json.Unmarshal(*m["url"], &URLVar)
		if err != nil {
			return err
		}
		ao.URL = &URLVar
	}

	v = m["image"]
	if v != nil {
		var imageVar ImageObject
		err = json.Unmarshal(*m["image"], &imageVar)
		if err != nil {
			return err
		}
		ao.Image = &imageVar
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		ao.Description = &description
	}

	v = m["alternateName"]
	if v != nil {
		var alternateName string
		err = json.Unmarshal(*m["alternateName"], &alternateName)
		if err != nil {
			return err
		}
		ao.AlternateName = &alternateName
	}

	v = m["bingId"]
	if v != nil {
		var bingID string
		err = json.Unmarshal(*m["bingId"], &bingID)
		if err != nil {
			return err
		}
		ao.BingID = &bingID
	}

	v = m["readLink"]
	if v != nil {
		var readLink string
		err = json.Unmarshal(*m["readLink"], &readLink)
		if err != nil {
			return err
		}
		ao.ReadLink = &readLink
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		ao.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		ao.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type TypeBasicResponseBase
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		ao.Type = _type
	}

	return nil
}

// AggregateRating defines the metrics that indicate how well an item was rated by others.
type AggregateRating struct {
	// Text - Text representation of an item.
	Text *string `json:"text,omitempty"`
	// Type - Possible values include: 'TypePropertiesItem', 'TypeAggregateRating', 'TypeRating'
	Type Type `json:"_type,omitempty"`
	// RatingValue - The mean (average) rating. The possible values are 1.0 through 5.0.
	RatingValue *float64 `json:"ratingValue,omitempty"`
	// BestRating - The highest rated review. The possible values are 1.0 through 5.0.
	BestRating *float64 `json:"bestRating,omitempty"`
	// ReviewCount - The number of times the recipe has been rated or reviewed.
	ReviewCount *int32 `json:"reviewCount,omitempty"`
}

// MarshalJSON is the custom marshaler for AggregateRating.
func (ar AggregateRating) MarshalJSON() ([]byte, error) {
	ar.Type = TypeAggregateRating
	type Alias AggregateRating
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ar),
	})
}

// AsAggregateRating is the BasicPropertiesItem implementation for AggregateRating.
func (ar AggregateRating) AsAggregateRating() (*AggregateRating, bool) {
	return &ar, true
}

// AsRating is the BasicPropertiesItem implementation for AggregateRating.
func (ar AggregateRating) AsRating() (*Rating, bool) {
	return nil, false
}

// AsBasicRating is the BasicPropertiesItem implementation for AggregateRating.
func (ar AggregateRating) AsBasicRating() (BasicRating, bool) {
	return &ar, true
}

// AsPropertiesItem is the BasicPropertiesItem implementation for AggregateRating.
func (ar AggregateRating) AsPropertiesItem() (*PropertiesItem, bool) {
	return nil, false
}

// AsBasicPropertiesItem is the BasicPropertiesItem implementation for AggregateRating.
func (ar AggregateRating) AsBasicPropertiesItem() (BasicPropertiesItem, bool) {
	return &ar, true
}

// BasicAnswer defines an answer.
type BasicAnswer interface {
	AsImages() (*Images, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
	AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool)
	AsAnswer() (*Answer, bool)
}

// Answer defines an answer.
type Answer struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeImageGallery', 'TypeRecipe', 'TypeNormalizedRectangle', 'TypeRecognizedEntity', 'TypeRecognizedEntityRegion', 'TypeImageInsights', 'TypeTrendingImages', 'TypeWebPage', 'TypePerson', 'TypeIntangible', 'TypeCollectionPage', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ReadLink - The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
}

func unmarshalBasicAnswer(body []byte) (BasicAnswer, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeImages):
		var i Images
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeSearchResultsAnswer):
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	default:
		var a Answer
		err := json.Unmarshal(body, &a)
		return a, err
	}
}
func unmarshalBasicAnswerArray(body []byte) ([]BasicAnswer, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	aArray := make([]BasicAnswer, len(rawMessages))

	for index, rawMessage := range rawMessages {
		a, err := unmarshalBasicAnswer(*rawMessage)
		if err != nil {
			return nil, err
		}
		aArray[index] = a
	}
	return aArray, nil
}

// MarshalJSON is the custom marshaler for Answer.
func (a Answer) MarshalJSON() ([]byte, error) {
	a.Type = TypeAnswer
	type Alias Answer
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(a),
	})
}

// AsOrganization is the BasicResponseBase implementation for Answer.
func (a Answer) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for Answer.
func (a Answer) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for Answer.
func (a Answer) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for Answer.
func (a Answer) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for Answer.
func (a Answer) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Answer.
func (a Answer) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for Answer.
func (a Answer) AsAnswer() (*Answer, bool) {
	return &a, true
}

// AsBasicAnswer is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicAnswer() (BasicAnswer, bool) {
	return &a, true
}

// AsMediaObject is the BasicResponseBase implementation for Answer.
func (a Answer) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Answer.
func (a Answer) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicResponse() (BasicResponse, bool) {
	return &a, true
}

// AsThing is the BasicResponseBase implementation for Answer.
func (a Answer) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Answer.
func (a Answer) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Answer.
func (a Answer) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &a, true
}

// AsErrorResponse is the BasicResponseBase implementation for Answer.
func (a Answer) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsImageGallery is the BasicResponseBase implementation for Answer.
func (a Answer) AsImageGallery() (*ImageGallery, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for Answer.
func (a Answer) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsNormalizedRectangle is the BasicResponseBase implementation for Answer.
func (a Answer) AsNormalizedRectangle() (*NormalizedRectangle, bool) {
	return nil, false
}

// AsRecognizedEntity is the BasicResponseBase implementation for Answer.
func (a Answer) AsRecognizedEntity() (*RecognizedEntity, bool) {
	return nil, false
}

// AsRecognizedEntityRegion is the BasicResponseBase implementation for Answer.
func (a Answer) AsRecognizedEntityRegion() (*RecognizedEntityRegion, bool) {
	return nil, false
}

// AsImageInsights is the BasicResponseBase implementation for Answer.
func (a Answer) AsImageInsights() (*ImageInsights, bool) {
	return nil, false
}

// AsTrendingImages is the BasicResponseBase implementation for Answer.
func (a Answer) AsTrendingImages() (*TrendingImages, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for Answer.
func (a Answer) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsBasicWebPage is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicWebPage() (BasicWebPage, bool) {
	return nil, false
}

// AsPerson is the BasicResponseBase implementation for Answer.
func (a Answer) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Answer.
func (a Answer) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsCollectionPage is the BasicResponseBase implementation for Answer.
func (a Answer) AsCollectionPage() (*CollectionPage, bool) {
	return nil, false
}

// AsBasicCollectionPage is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicCollectionPage() (BasicCollectionPage, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Answer.
func (a Answer) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Answer.
func (a Answer) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &a, true
}

// BasicCollectionPage defines a link to a webpage that contains a collection.
type BasicCollectionPage interface {
	AsImageGallery() (*ImageGallery, bool)
	AsCollectionPage() (*CollectionPage, bool)
}

// CollectionPage defines a link to a webpage that contains a collection.
type CollectionPage struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeImageGallery', 'TypeRecipe', 'TypeNormalizedRectangle', 'TypeRecognizedEntity', 'TypeRecognizedEntityRegion', 'TypeImageInsights', 'TypeTrendingImages', 'TypeWebPage', 'TypePerson', 'TypeIntangible', 'TypeCollectionPage', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ReadLink - The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	// DatePublished - The date on which the CreativeWork was published.
	DatePublished *string `json:"datePublished,omitempty"`
	// Text - Text content of this creative work
	Text *string `json:"text,omitempty"`
}

func unmarshalBasicCollectionPage(body []byte) (BasicCollectionPage, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeImageGallery):
		var ig ImageGallery
		err := json.Unmarshal(body, &ig)
		return ig, err
	default:
		var cp CollectionPage
		err := json.Unmarshal(body, &cp)
		return cp, err
	}
}
func unmarshalBasicCollectionPageArray(body []byte) ([]BasicCollectionPage, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	cpArray := make([]BasicCollectionPage, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cp, err := unmarshalBasicCollectionPage(*rawMessage)
		if err != nil {
			return nil, err
		}
		cpArray[index] = cp
	}
	return cpArray, nil
}

// MarshalJSON is the custom marshaler for CollectionPage.
func (cp CollectionPage) MarshalJSON() ([]byte, error) {
	cp.Type = TypeCollectionPage
	type Alias CollectionPage
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(cp),
	})
}

// AsOrganization is the BasicResponseBase implementation for CollectionPage.
func (cp CollectionPage) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for CollectionPage.
func (cp CollectionPage) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for CollectionPage.
func (cp CollectionPage) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for CollectionPage.
func (cp CollectionPage) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for CollectionPage.
func (cp CollectionPage) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for CollectionPage.
func (cp CollectionPage) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for CollectionPage.
func (cp CollectionPage) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for CollectionPage.
func (cp CollectionPage) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for CollectionPage.
func (cp CollectionPage) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for CollectionPage.
func (cp CollectionPage) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for CollectionPage.
func (cp CollectionPage) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for CollectionPage.
func (cp CollectionPage) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for CollectionPage.
func (cp CollectionPage) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for CollectionPage.
func (cp CollectionPage) AsBasicResponse() (BasicResponse, bool) {
	return &cp, true
}

// AsThing is the BasicResponseBase implementation for CollectionPage.
func (cp CollectionPage) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for CollectionPage.
func (cp CollectionPage) AsBasicThing() (BasicThing, bool) {
	return &cp, true
}

// AsCreativeWork is the BasicResponseBase implementation for CollectionPage.
func (cp CollectionPage) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for CollectionPage.
func (cp CollectionPage) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &cp, true
}

// AsIdentifiable is the BasicResponseBase implementation for CollectionPage.
func (cp CollectionPage) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for CollectionPage.
func (cp CollectionPage) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &cp, true
}

// AsErrorResponse is the BasicResponseBase implementation for CollectionPage.
func (cp CollectionPage) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsImageGallery is the BasicResponseBase implementation for CollectionPage.
func (cp CollectionPage) AsImageGallery() (*ImageGallery, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for CollectionPage.
func (cp CollectionPage) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsNormalizedRectangle is the BasicResponseBase implementation for CollectionPage.
func (cp CollectionPage) AsNormalizedRectangle() (*NormalizedRectangle, bool) {
	return nil, false
}

// AsRecognizedEntity is the BasicResponseBase implementation for CollectionPage.
func (cp CollectionPage) AsRecognizedEntity() (*RecognizedEntity, bool) {
	return nil, false
}

// AsRecognizedEntityRegion is the BasicResponseBase implementation for CollectionPage.
func (cp CollectionPage) AsRecognizedEntityRegion() (*RecognizedEntityRegion, bool) {
	return nil, false
}

// AsImageInsights is the BasicResponseBase implementation for CollectionPage.
func (cp CollectionPage) AsImageInsights() (*ImageInsights, bool) {
	return nil, false
}

// AsTrendingImages is the BasicResponseBase implementation for CollectionPage.
func (cp CollectionPage) AsTrendingImages() (*TrendingImages, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for CollectionPage.
func (cp CollectionPage) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsBasicWebPage is the BasicResponseBase implementation for CollectionPage.
func (cp CollectionPage) AsBasicWebPage() (BasicWebPage, bool) {
	return &cp, true
}

// AsPerson is the BasicResponseBase implementation for CollectionPage.
func (cp CollectionPage) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for CollectionPage.
func (cp CollectionPage) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for CollectionPage.
func (cp CollectionPage) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsCollectionPage is the BasicResponseBase implementation for CollectionPage.
func (cp CollectionPage) AsCollectionPage() (*CollectionPage, bool) {
	return &cp, true
}

// AsBasicCollectionPage is the BasicResponseBase implementation for CollectionPage.
func (cp CollectionPage) AsBasicCollectionPage() (BasicCollectionPage, bool) {
	return &cp, true
}

// AsStructuredValue is the BasicResponseBase implementation for CollectionPage.
func (cp CollectionPage) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for CollectionPage.
func (cp CollectionPage) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for CollectionPage.
func (cp CollectionPage) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for CollectionPage.
func (cp CollectionPage) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &cp, true
}

// UnmarshalJSON is the custom unmarshaler for CollectionPage struct.
func (cp *CollectionPage) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["thumbnailUrl"]
	if v != nil {
		var thumbnailURL string
		err = json.Unmarshal(*m["thumbnailUrl"], &thumbnailURL)
		if err != nil {
			return err
		}
		cp.ThumbnailURL = &thumbnailURL
	}

	v = m["provider"]
	if v != nil {
		provider, err := unmarshalBasicThingArray(*m["provider"])
		if err != nil {
			return err
		}
		cp.Provider = &provider
	}

	v = m["datePublished"]
	if v != nil {
		var datePublished string
		err = json.Unmarshal(*m["datePublished"], &datePublished)
		if err != nil {
			return err
		}
		cp.DatePublished = &datePublished
	}

	v = m["text"]
	if v != nil {
		var textVar string
		err = json.Unmarshal(*m["text"], &textVar)
		if err != nil {
			return err
		}
		cp.Text = &textVar
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		cp.Name = &name
	}

	v = m["url"]
	if v != nil {
		var URLVar string
		err = json.Unmarshal(*m["url"], &URLVar)
		if err != nil {
			return err
		}
		cp.URL = &URLVar
	}

	v = m["image"]
	if v != nil {
		var imageVar ImageObject
		err = json.Unmarshal(*m["image"], &imageVar)
		if err != nil {
			return err
		}
		cp.Image = &imageVar
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		cp.Description = &description
	}

	v = m["alternateName"]
	if v != nil {
		var alternateName string
		err = json.Unmarshal(*m["alternateName"], &alternateName)
		if err != nil {
			return err
		}
		cp.AlternateName = &alternateName
	}

	v = m["bingId"]
	if v != nil {
		var bingID string
		err = json.Unmarshal(*m["bingId"], &bingID)
		if err != nil {
			return err
		}
		cp.BingID = &bingID
	}

	v = m["readLink"]
	if v != nil {
		var readLink string
		err = json.Unmarshal(*m["readLink"], &readLink)
		if err != nil {
			return err
		}
		cp.ReadLink = &readLink
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		cp.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		cp.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type TypeBasicResponseBase
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		cp.Type = _type
	}

	return nil
}

// BasicCreativeWork the most generic kind of creative work, including books, movies, photographs, software programs,
// etc.
type BasicCreativeWork interface {
	AsImageObject() (*ImageObject, bool)
	AsMediaObject() (*MediaObject, bool)
	AsBasicMediaObject() (BasicMediaObject, bool)
	AsImageGallery() (*ImageGallery, bool)
	AsRecipe() (*Recipe, bool)
	AsWebPage() (*WebPage, bool)
	AsBasicWebPage() (BasicWebPage, bool)
	AsCollectionPage() (*CollectionPage, bool)
	AsBasicCollectionPage() (BasicCollectionPage, bool)
	AsCreativeWork() (*CreativeWork, bool)
}

// CreativeWork the most generic kind of creative work, including books, movies, photographs, software programs, etc.
type CreativeWork struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeImageGallery', 'TypeRecipe', 'TypeNormalizedRectangle', 'TypeRecognizedEntity', 'TypeRecognizedEntityRegion', 'TypeImageInsights', 'TypeTrendingImages', 'TypeWebPage', 'TypePerson', 'TypeIntangible', 'TypeCollectionPage', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ReadLink - The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	// DatePublished - The date on which the CreativeWork was published.
	DatePublished *string `json:"datePublished,omitempty"`
	// Text - Text content of this creative work
	Text *string `json:"text,omitempty"`
}

func unmarshalBasicCreativeWork(body []byte) (BasicCreativeWork, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	case string(TypeMediaObject):
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	case string(TypeImageGallery):
		var ig ImageGallery
		err := json.Unmarshal(body, &ig)
		return ig, err
	case string(TypeRecipe):
		var r Recipe
		err := json.Unmarshal(body, &r)
		return r, err
	case string(TypeWebPage):
		var wp WebPage
		err := json.Unmarshal(body, &wp)
		return wp, err
	case string(TypeCollectionPage):
		var cp CollectionPage
		err := json.Unmarshal(body, &cp)
		return cp, err
	default:
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	}
}
func unmarshalBasicCreativeWorkArray(body []byte) ([]BasicCreativeWork, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	cwArray := make([]BasicCreativeWork, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cw, err := unmarshalBasicCreativeWork(*rawMessage)
		if err != nil {
			return nil, err
		}
		cwArray[index] = cw
	}
	return cwArray, nil
}

// MarshalJSON is the custom marshaler for CreativeWork.
func (cw CreativeWork) MarshalJSON() ([]byte, error) {
	cw.Type = TypeCreativeWork
	type Alias CreativeWork
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(cw),
	})
}

// AsOrganization is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicResponse() (BasicResponse, bool) {
	return &cw, true
}

// AsThing is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicThing() (BasicThing, bool) {
	return &cw, true
}

// AsCreativeWork is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsCreativeWork() (*CreativeWork, bool) {
	return &cw, true
}

// AsBasicCreativeWork is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &cw, true
}

// AsIdentifiable is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &cw, true
}

// AsErrorResponse is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsImageGallery is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsImageGallery() (*ImageGallery, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsNormalizedRectangle is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsNormalizedRectangle() (*NormalizedRectangle, bool) {
	return nil, false
}

// AsRecognizedEntity is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsRecognizedEntity() (*RecognizedEntity, bool) {
	return nil, false
}

// AsRecognizedEntityRegion is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsRecognizedEntityRegion() (*RecognizedEntityRegion, bool) {
	return nil, false
}

// AsImageInsights is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsImageInsights() (*ImageInsights, bool) {
	return nil, false
}

// AsTrendingImages is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsTrendingImages() (*TrendingImages, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsBasicWebPage is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicWebPage() (BasicWebPage, bool) {
	return nil, false
}

// AsPerson is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsCollectionPage is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsCollectionPage() (*CollectionPage, bool) {
	return nil, false
}

// AsBasicCollectionPage is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicCollectionPage() (BasicCollectionPage, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &cw, true
}

// UnmarshalJSON is the custom unmarshaler for CreativeWork struct.
func (cw *CreativeWork) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["thumbnailUrl"]
	if v != nil {
		var thumbnailURL string
		err = json.Unmarshal(*m["thumbnailUrl"], &thumbnailURL)
		if err != nil {
			return err
		}
		cw.ThumbnailURL = &thumbnailURL
	}

	v = m["provider"]
	if v != nil {
		provider, err := unmarshalBasicThingArray(*m["provider"])
		if err != nil {
			return err
		}
		cw.Provider = &provider
	}

	v = m["datePublished"]
	if v != nil {
		var datePublished string
		err = json.Unmarshal(*m["datePublished"], &datePublished)
		if err != nil {
			return err
		}
		cw.DatePublished = &datePublished
	}

	v = m["text"]
	if v != nil {
		var textVar string
		err = json.Unmarshal(*m["text"], &textVar)
		if err != nil {
			return err
		}
		cw.Text = &textVar
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		cw.Name = &name
	}

	v = m["url"]
	if v != nil {
		var URLVar string
		err = json.Unmarshal(*m["url"], &URLVar)
		if err != nil {
			return err
		}
		cw.URL = &URLVar
	}

	v = m["image"]
	if v != nil {
		var imageVar ImageObject
		err = json.Unmarshal(*m["image"], &imageVar)
		if err != nil {
			return err
		}
		cw.Image = &imageVar
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		cw.Description = &description
	}

	v = m["alternateName"]
	if v != nil {
		var alternateName string
		err = json.Unmarshal(*m["alternateName"], &alternateName)
		if err != nil {
			return err
		}
		cw.AlternateName = &alternateName
	}

	v = m["bingId"]
	if v != nil {
		var bingID string
		err = json.Unmarshal(*m["bingId"], &bingID)
		if err != nil {
			return err
		}
		cw.BingID = &bingID
	}

	v = m["readLink"]
	if v != nil {
		var readLink string
		err = json.Unmarshal(*m["readLink"], &readLink)
		if err != nil {
			return err
		}
		cw.ReadLink = &readLink
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		cw.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		cw.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type TypeBasicResponseBase
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		cw.Type = _type
	}

	return nil
}

// Error defines the error that occurred.
type Error struct {
	// Code - The error code that identifies the category of error. Possible values include: 'None', 'ServerError', 'InvalidRequest', 'RateLimitExceeded', 'InvalidAuthorization', 'InsufficientAuthorization'
	Code ErrorCode `json:"code,omitempty"`
	// SubCode - The error code that further helps to identify the error. Possible values include: 'UnexpectedError', 'ResourceError', 'NotImplemented', 'ParameterMissing', 'ParameterInvalidValue', 'HTTPNotAllowed', 'Blocked', 'AuthorizationMissing', 'AuthorizationRedundancy', 'AuthorizationDisabled', 'AuthorizationExpired'
	SubCode ErrorSubCode `json:"subCode,omitempty"`
	// Message - A description of the error.
	Message *string `json:"message,omitempty"`
	// MoreDetails - A description that provides additional information about the error.
	MoreDetails *string `json:"moreDetails,omitempty"`
	// Parameter - The parameter in the request that caused the error.
	Parameter *string `json:"parameter,omitempty"`
	// Value - The parameter's value in the request that was not valid.
	Value *string `json:"value,omitempty"`
}

// ErrorResponse the top-level response that represents a failed request.
type ErrorResponse struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeImageGallery', 'TypeRecipe', 'TypeNormalizedRectangle', 'TypeRecognizedEntity', 'TypeRecognizedEntityRegion', 'TypeImageInsights', 'TypeTrendingImages', 'TypeWebPage', 'TypePerson', 'TypeIntangible', 'TypeCollectionPage', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ReadLink - The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Errors - A list of errors that describe the reasons why the request failed.
	Errors *[]Error `json:"errors,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorResponse.
func (er ErrorResponse) MarshalJSON() ([]byte, error) {
	er.Type = TypeErrorResponse
	type Alias ErrorResponse
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(er),
	})
}

// AsOrganization is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicResponse() (BasicResponse, bool) {
	return &er, true
}

// AsThing is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &er, true
}

// AsErrorResponse is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsErrorResponse() (*ErrorResponse, bool) {
	return &er, true
}

// AsImageGallery is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsImageGallery() (*ImageGallery, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsNormalizedRectangle is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsNormalizedRectangle() (*NormalizedRectangle, bool) {
	return nil, false
}

// AsRecognizedEntity is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsRecognizedEntity() (*RecognizedEntity, bool) {
	return nil, false
}

// AsRecognizedEntityRegion is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsRecognizedEntityRegion() (*RecognizedEntityRegion, bool) {
	return nil, false
}

// AsImageInsights is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsImageInsights() (*ImageInsights, bool) {
	return nil, false
}

// AsTrendingImages is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsTrendingImages() (*TrendingImages, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsBasicWebPage is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicWebPage() (BasicWebPage, bool) {
	return nil, false
}

// AsPerson is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsCollectionPage is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsCollectionPage() (*CollectionPage, bool) {
	return nil, false
}

// AsBasicCollectionPage is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicCollectionPage() (BasicCollectionPage, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &er, true
}

// BasicIdentifiable defines the identity of a resource.
type BasicIdentifiable interface {
	AsOrganization() (*Organization, bool)
	AsOffer() (*Offer, bool)
	AsBasicOffer() (BasicOffer, bool)
	AsAggregateOffer() (*AggregateOffer, bool)
	AsImageObject() (*ImageObject, bool)
	AsImages() (*Images, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
	AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool)
	AsAnswer() (*Answer, bool)
	AsBasicAnswer() (BasicAnswer, bool)
	AsMediaObject() (*MediaObject, bool)
	AsBasicMediaObject() (BasicMediaObject, bool)
	AsResponse() (*Response, bool)
	AsBasicResponse() (BasicResponse, bool)
	AsThing() (*Thing, bool)
	AsBasicThing() (BasicThing, bool)
	AsCreativeWork() (*CreativeWork, bool)
	AsBasicCreativeWork() (BasicCreativeWork, bool)
	AsErrorResponse() (*ErrorResponse, bool)
	AsImageGallery() (*ImageGallery, bool)
	AsRecipe() (*Recipe, bool)
	AsNormalizedRectangle() (*NormalizedRectangle, bool)
	AsRecognizedEntity() (*RecognizedEntity, bool)
	AsRecognizedEntityRegion() (*RecognizedEntityRegion, bool)
	AsImageInsights() (*ImageInsights, bool)
	AsTrendingImages() (*TrendingImages, bool)
	AsWebPage() (*WebPage, bool)
	AsBasicWebPage() (BasicWebPage, bool)
	AsPerson() (*Person, bool)
	AsIntangible() (*Intangible, bool)
	AsBasicIntangible() (BasicIntangible, bool)
	AsCollectionPage() (*CollectionPage, bool)
	AsBasicCollectionPage() (BasicCollectionPage, bool)
	AsStructuredValue() (*StructuredValue, bool)
	AsBasicStructuredValue() (BasicStructuredValue, bool)
	AsIdentifiable() (*Identifiable, bool)
}

// Identifiable defines the identity of a resource.
type Identifiable struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeImageGallery', 'TypeRecipe', 'TypeNormalizedRectangle', 'TypeRecognizedEntity', 'TypeRecognizedEntityRegion', 'TypeImageInsights', 'TypeTrendingImages', 'TypeWebPage', 'TypePerson', 'TypeIntangible', 'TypeCollectionPage', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
}

func unmarshalBasicIdentifiable(body []byte) (BasicIdentifiable, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeOrganization):
		var o Organization
		err := json.Unmarshal(body, &o)
		return o, err
	case string(TypeOffer):
		var o Offer
		err := json.Unmarshal(body, &o)
		return o, err
	case string(TypeAggregateOffer):
		var ao AggregateOffer
		err := json.Unmarshal(body, &ao)
		return ao, err
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	case string(TypeImages):
		var i Images
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeSearchResultsAnswer):
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	case string(TypeAnswer):
		var a Answer
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeMediaObject):
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	case string(TypeResponse):
		var r Response
		err := json.Unmarshal(body, &r)
		return r, err
	case string(TypeThing):
		var t Thing
		err := json.Unmarshal(body, &t)
		return t, err
	case string(TypeCreativeWork):
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	case string(TypeErrorResponse):
		var er ErrorResponse
		err := json.Unmarshal(body, &er)
		return er, err
	case string(TypeImageGallery):
		var ig ImageGallery
		err := json.Unmarshal(body, &ig)
		return ig, err
	case string(TypeRecipe):
		var r Recipe
		err := json.Unmarshal(body, &r)
		return r, err
	case string(TypeNormalizedRectangle):
		var nr NormalizedRectangle
		err := json.Unmarshal(body, &nr)
		return nr, err
	case string(TypeRecognizedEntity):
		var re RecognizedEntity
		err := json.Unmarshal(body, &re)
		return re, err
	case string(TypeRecognizedEntityRegion):
		var rer RecognizedEntityRegion
		err := json.Unmarshal(body, &rer)
		return rer, err
	case string(TypeImageInsights):
		var ii ImageInsights
		err := json.Unmarshal(body, &ii)
		return ii, err
	case string(TypeTrendingImages):
		var ti TrendingImages
		err := json.Unmarshal(body, &ti)
		return ti, err
	case string(TypeWebPage):
		var wp WebPage
		err := json.Unmarshal(body, &wp)
		return wp, err
	case string(TypePerson):
		var p Person
		err := json.Unmarshal(body, &p)
		return p, err
	case string(TypeIntangible):
		var i Intangible
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeCollectionPage):
		var cp CollectionPage
		err := json.Unmarshal(body, &cp)
		return cp, err
	case string(TypeStructuredValue):
		var sv StructuredValue
		err := json.Unmarshal(body, &sv)
		return sv, err
	default:
		var i Identifiable
		err := json.Unmarshal(body, &i)
		return i, err
	}
}
func unmarshalBasicIdentifiableArray(body []byte) ([]BasicIdentifiable, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	iArray := make([]BasicIdentifiable, len(rawMessages))

	for index, rawMessage := range rawMessages {
		i, err := unmarshalBasicIdentifiable(*rawMessage)
		if err != nil {
			return nil, err
		}
		iArray[index] = i
	}
	return iArray, nil
}

// MarshalJSON is the custom marshaler for Identifiable.
func (i Identifiable) MarshalJSON() ([]byte, error) {
	i.Type = TypeIdentifiable
	type Alias Identifiable
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(i),
	})
}

// AsOrganization is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicResponse() (BasicResponse, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsIdentifiable() (*Identifiable, bool) {
	return &i, true
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &i, true
}

// AsErrorResponse is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsImageGallery is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsImageGallery() (*ImageGallery, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsNormalizedRectangle is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsNormalizedRectangle() (*NormalizedRectangle, bool) {
	return nil, false
}

// AsRecognizedEntity is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsRecognizedEntity() (*RecognizedEntity, bool) {
	return nil, false
}

// AsRecognizedEntityRegion is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsRecognizedEntityRegion() (*RecognizedEntityRegion, bool) {
	return nil, false
}

// AsImageInsights is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsImageInsights() (*ImageInsights, bool) {
	return nil, false
}

// AsTrendingImages is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsTrendingImages() (*TrendingImages, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsBasicWebPage is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicWebPage() (BasicWebPage, bool) {
	return nil, false
}

// AsPerson is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsCollectionPage is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsCollectionPage() (*CollectionPage, bool) {
	return nil, false
}

// AsBasicCollectionPage is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicCollectionPage() (BasicCollectionPage, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &i, true
}

// ImageGallery defines a link to a webpage that contains a collection of related images.
type ImageGallery struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeImageGallery', 'TypeRecipe', 'TypeNormalizedRectangle', 'TypeRecognizedEntity', 'TypeRecognizedEntityRegion', 'TypeImageInsights', 'TypeTrendingImages', 'TypeWebPage', 'TypePerson', 'TypeIntangible', 'TypeCollectionPage', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ReadLink - The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	// DatePublished - The date on which the CreativeWork was published.
	DatePublished *string `json:"datePublished,omitempty"`
	// Text - Text content of this creative work
	Text *string `json:"text,omitempty"`
	// Source - The publisher or social network where the images were found. You must attribute the publisher as the source where the collection was found.
	Source *string `json:"source,omitempty"`
	// ImagesCount - The number of related images found in the collection.
	ImagesCount *int64 `json:"imagesCount,omitempty"`
	// FollowersCount - The number of users on the social network that follow the creator.
	FollowersCount *int64 `json:"followersCount,omitempty"`
}

// MarshalJSON is the custom marshaler for ImageGallery.
func (ig ImageGallery) MarshalJSON() ([]byte, error) {
	ig.Type = TypeImageGallery
	type Alias ImageGallery
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ig),
	})
}

// AsOrganization is the BasicResponseBase implementation for ImageGallery.
func (ig ImageGallery) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for ImageGallery.
func (ig ImageGallery) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for ImageGallery.
func (ig ImageGallery) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for ImageGallery.
func (ig ImageGallery) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for ImageGallery.
func (ig ImageGallery) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for ImageGallery.
func (ig ImageGallery) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for ImageGallery.
func (ig ImageGallery) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for ImageGallery.
func (ig ImageGallery) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for ImageGallery.
func (ig ImageGallery) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for ImageGallery.
func (ig ImageGallery) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for ImageGallery.
func (ig ImageGallery) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for ImageGallery.
func (ig ImageGallery) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for ImageGallery.
func (ig ImageGallery) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for ImageGallery.
func (ig ImageGallery) AsBasicResponse() (BasicResponse, bool) {
	return &ig, true
}

// AsThing is the BasicResponseBase implementation for ImageGallery.
func (ig ImageGallery) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for ImageGallery.
func (ig ImageGallery) AsBasicThing() (BasicThing, bool) {
	return &ig, true
}

// AsCreativeWork is the BasicResponseBase implementation for ImageGallery.
func (ig ImageGallery) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for ImageGallery.
func (ig ImageGallery) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &ig, true
}

// AsIdentifiable is the BasicResponseBase implementation for ImageGallery.
func (ig ImageGallery) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for ImageGallery.
func (ig ImageGallery) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &ig, true
}

// AsErrorResponse is the BasicResponseBase implementation for ImageGallery.
func (ig ImageGallery) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsImageGallery is the BasicResponseBase implementation for ImageGallery.
func (ig ImageGallery) AsImageGallery() (*ImageGallery, bool) {
	return &ig, true
}

// AsRecipe is the BasicResponseBase implementation for ImageGallery.
func (ig ImageGallery) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsNormalizedRectangle is the BasicResponseBase implementation for ImageGallery.
func (ig ImageGallery) AsNormalizedRectangle() (*NormalizedRectangle, bool) {
	return nil, false
}

// AsRecognizedEntity is the BasicResponseBase implementation for ImageGallery.
func (ig ImageGallery) AsRecognizedEntity() (*RecognizedEntity, bool) {
	return nil, false
}

// AsRecognizedEntityRegion is the BasicResponseBase implementation for ImageGallery.
func (ig ImageGallery) AsRecognizedEntityRegion() (*RecognizedEntityRegion, bool) {
	return nil, false
}

// AsImageInsights is the BasicResponseBase implementation for ImageGallery.
func (ig ImageGallery) AsImageInsights() (*ImageInsights, bool) {
	return nil, false
}

// AsTrendingImages is the BasicResponseBase implementation for ImageGallery.
func (ig ImageGallery) AsTrendingImages() (*TrendingImages, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for ImageGallery.
func (ig ImageGallery) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsBasicWebPage is the BasicResponseBase implementation for ImageGallery.
func (ig ImageGallery) AsBasicWebPage() (BasicWebPage, bool) {
	return &ig, true
}

// AsPerson is the BasicResponseBase implementation for ImageGallery.
func (ig ImageGallery) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for ImageGallery.
func (ig ImageGallery) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for ImageGallery.
func (ig ImageGallery) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsCollectionPage is the BasicResponseBase implementation for ImageGallery.
func (ig ImageGallery) AsCollectionPage() (*CollectionPage, bool) {
	return nil, false
}

// AsBasicCollectionPage is the BasicResponseBase implementation for ImageGallery.
func (ig ImageGallery) AsBasicCollectionPage() (BasicCollectionPage, bool) {
	return &ig, true
}

// AsStructuredValue is the BasicResponseBase implementation for ImageGallery.
func (ig ImageGallery) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for ImageGallery.
func (ig ImageGallery) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for ImageGallery.
func (ig ImageGallery) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for ImageGallery.
func (ig ImageGallery) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &ig, true
}

// UnmarshalJSON is the custom unmarshaler for ImageGallery struct.
func (ig *ImageGallery) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["source"]
	if v != nil {
		var source string
		err = json.Unmarshal(*m["source"], &source)
		if err != nil {
			return err
		}
		ig.Source = &source
	}

	v = m["imagesCount"]
	if v != nil {
		var imagesCount int64
		err = json.Unmarshal(*m["imagesCount"], &imagesCount)
		if err != nil {
			return err
		}
		ig.ImagesCount = &imagesCount
	}

	v = m["followersCount"]
	if v != nil {
		var followersCount int64
		err = json.Unmarshal(*m["followersCount"], &followersCount)
		if err != nil {
			return err
		}
		ig.FollowersCount = &followersCount
	}

	v = m["thumbnailUrl"]
	if v != nil {
		var thumbnailURL string
		err = json.Unmarshal(*m["thumbnailUrl"], &thumbnailURL)
		if err != nil {
			return err
		}
		ig.ThumbnailURL = &thumbnailURL
	}

	v = m["provider"]
	if v != nil {
		provider, err := unmarshalBasicThingArray(*m["provider"])
		if err != nil {
			return err
		}
		ig.Provider = &provider
	}

	v = m["datePublished"]
	if v != nil {
		var datePublished string
		err = json.Unmarshal(*m["datePublished"], &datePublished)
		if err != nil {
			return err
		}
		ig.DatePublished = &datePublished
	}

	v = m["text"]
	if v != nil {
		var textVar string
		err = json.Unmarshal(*m["text"], &textVar)
		if err != nil {
			return err
		}
		ig.Text = &textVar
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		ig.Name = &name
	}

	v = m["url"]
	if v != nil {
		var URLVar string
		err = json.Unmarshal(*m["url"], &URLVar)
		if err != nil {
			return err
		}
		ig.URL = &URLVar
	}

	v = m["image"]
	if v != nil {
		var imageVar ImageObject
		err = json.Unmarshal(*m["image"], &imageVar)
		if err != nil {
			return err
		}
		ig.Image = &imageVar
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		ig.Description = &description
	}

	v = m["alternateName"]
	if v != nil {
		var alternateName string
		err = json.Unmarshal(*m["alternateName"], &alternateName)
		if err != nil {
			return err
		}
		ig.AlternateName = &alternateName
	}

	v = m["bingId"]
	if v != nil {
		var bingID string
		err = json.Unmarshal(*m["bingId"], &bingID)
		if err != nil {
			return err
		}
		ig.BingID = &bingID
	}

	v = m["readLink"]
	if v != nil {
		var readLink string
		err = json.Unmarshal(*m["readLink"], &readLink)
		if err != nil {
			return err
		}
		ig.ReadLink = &readLink
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		ig.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		ig.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type TypeBasicResponseBase
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		ig.Type = _type
	}

	return nil
}

// ImageInsights the top-level object that the response includes when an image insights request succeeds. For
// information about requesting image insights, see the
// [insightsToken](https://docs.microsoft.com/en-us/rest/api/cognitiveservices/bing-images-api-v7-reference#insightstoken)
// query parameter. The modules query parameter affects the fields that Bing includes in the response. If you set
// [modules](https://docs.microsoft.com/en-us/rest/api/cognitiveservices/bing-images-api-v7-reference#modulesrequested)
// to only Caption, then this object includes only the imageCaption field.
type ImageInsights struct {
	autorest.Response `json:"-"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeImageGallery', 'TypeRecipe', 'TypeNormalizedRectangle', 'TypeRecognizedEntity', 'TypeRecognizedEntityRegion', 'TypeImageInsights', 'TypeTrendingImages', 'TypeWebPage', 'TypePerson', 'TypeIntangible', 'TypeCollectionPage', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ReadLink - The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ImageInsightsToken - A token that you use in a subsequent call to the Image Search API to get more information about the image. For information about using this token, see the insightsToken query parameter. This token has the same usage as the token in the Image object.
	ImageInsightsToken *string `json:"imageInsightsToken,omitempty"`
	// BestRepresentativeQuery - The query term that best represents the image. Clicking the link in the Query object, takes the user to a webpage with more pictures of the image.
	BestRepresentativeQuery *Query `json:"bestRepresentativeQuery,omitempty"`
	// ImageCaption - The caption to use for the image.
	ImageCaption *ImageInsightsImageCaption `json:"imageCaption,omitempty"`
	// RelatedCollections - A list of links to webpages that contain related images.
	RelatedCollections *RelatedCollectionsModule `json:"relatedCollections,omitempty"`
	// PagesIncluding - A list of webpages that contain the image. To access the webpage, use the URL in the image's hostPageUrl field.
	PagesIncluding *ImagesModule `json:"pagesIncluding,omitempty"`
	// ShoppingSources - A list of merchants that offer items related to the image. For example, if the image is of an apple pie, the list contains merchants that are selling apple pies.
	ShoppingSources *AggregateOffer `json:"shoppingSources,omitempty"`
	// RelatedSearches - A list of related queries made by others.
	RelatedSearches *RelatedSearchesModule `json:"relatedSearches,omitempty"`
	// Recipes - A list of recipes related to the image. For example, if the image is of an apple pie, the list contains recipes for making an apple pie.
	Recipes *RecipesModule `json:"recipes,omitempty"`
	// VisuallySimilarImages - A list of images that are visually similar to the original image. For example, if the specified image is of a sunset over a body of water, the list of similar images are of a sunset over a body of water. If the specified image is of a person, similar images might be of the same person or they might be of persons dressed similarly or in a similar setting. The criteria for similarity continues to evolve.
	VisuallySimilarImages *ImagesModule `json:"visuallySimilarImages,omitempty"`
	// VisuallySimilarProducts - A list of images that contain products that are visually similar to products found in the original image. For example, if the specified image contains a dress, the list of similar images contain a dress. The image provides summary information about offers that Bing found online for the product.
	VisuallySimilarProducts *ImagesModule `json:"visuallySimilarProducts,omitempty"`
	// RecognizedEntityGroups - A list of groups that contain images of entities that match the entity found in the specified image. For example, the response might include images from the general celebrity group if the entity was recognized in that group.
	RecognizedEntityGroups *RecognizedEntitiesModule `json:"recognizedEntityGroups,omitempty"`
	// ImageTags - A list of characteristics of the content found in the image. For example, if the image is of a person, the tags might indicate the person's gender and the type of clothes they're wearing.
	ImageTags *ImageTagsModule `json:"imageTags,omitempty"`
}

// MarshalJSON is the custom marshaler for ImageInsights.
func (ii ImageInsights) MarshalJSON() ([]byte, error) {
	ii.Type = TypeImageInsights
	type Alias ImageInsights
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ii),
	})
}

// AsOrganization is the BasicResponseBase implementation for ImageInsights.
func (ii ImageInsights) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for ImageInsights.
func (ii ImageInsights) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for ImageInsights.
func (ii ImageInsights) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for ImageInsights.
func (ii ImageInsights) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for ImageInsights.
func (ii ImageInsights) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for ImageInsights.
func (ii ImageInsights) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for ImageInsights.
func (ii ImageInsights) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for ImageInsights.
func (ii ImageInsights) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for ImageInsights.
func (ii ImageInsights) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for ImageInsights.
func (ii ImageInsights) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for ImageInsights.
func (ii ImageInsights) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for ImageInsights.
func (ii ImageInsights) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for ImageInsights.
func (ii ImageInsights) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for ImageInsights.
func (ii ImageInsights) AsBasicResponse() (BasicResponse, bool) {
	return &ii, true
}

// AsThing is the BasicResponseBase implementation for ImageInsights.
func (ii ImageInsights) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for ImageInsights.
func (ii ImageInsights) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for ImageInsights.
func (ii ImageInsights) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for ImageInsights.
func (ii ImageInsights) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for ImageInsights.
func (ii ImageInsights) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for ImageInsights.
func (ii ImageInsights) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &ii, true
}

// AsErrorResponse is the BasicResponseBase implementation for ImageInsights.
func (ii ImageInsights) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsImageGallery is the BasicResponseBase implementation for ImageInsights.
func (ii ImageInsights) AsImageGallery() (*ImageGallery, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for ImageInsights.
func (ii ImageInsights) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsNormalizedRectangle is the BasicResponseBase implementation for ImageInsights.
func (ii ImageInsights) AsNormalizedRectangle() (*NormalizedRectangle, bool) {
	return nil, false
}

// AsRecognizedEntity is the BasicResponseBase implementation for ImageInsights.
func (ii ImageInsights) AsRecognizedEntity() (*RecognizedEntity, bool) {
	return nil, false
}

// AsRecognizedEntityRegion is the BasicResponseBase implementation for ImageInsights.
func (ii ImageInsights) AsRecognizedEntityRegion() (*RecognizedEntityRegion, bool) {
	return nil, false
}

// AsImageInsights is the BasicResponseBase implementation for ImageInsights.
func (ii ImageInsights) AsImageInsights() (*ImageInsights, bool) {
	return &ii, true
}

// AsTrendingImages is the BasicResponseBase implementation for ImageInsights.
func (ii ImageInsights) AsTrendingImages() (*TrendingImages, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for ImageInsights.
func (ii ImageInsights) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsBasicWebPage is the BasicResponseBase implementation for ImageInsights.
func (ii ImageInsights) AsBasicWebPage() (BasicWebPage, bool) {
	return nil, false
}

// AsPerson is the BasicResponseBase implementation for ImageInsights.
func (ii ImageInsights) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for ImageInsights.
func (ii ImageInsights) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for ImageInsights.
func (ii ImageInsights) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsCollectionPage is the BasicResponseBase implementation for ImageInsights.
func (ii ImageInsights) AsCollectionPage() (*CollectionPage, bool) {
	return nil, false
}

// AsBasicCollectionPage is the BasicResponseBase implementation for ImageInsights.
func (ii ImageInsights) AsBasicCollectionPage() (BasicCollectionPage, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for ImageInsights.
func (ii ImageInsights) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for ImageInsights.
func (ii ImageInsights) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for ImageInsights.
func (ii ImageInsights) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for ImageInsights.
func (ii ImageInsights) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &ii, true
}

// ImageInsightsImageCaption defines an image's caption.
type ImageInsightsImageCaption struct {
	// Caption - A caption about the image.
	Caption *string `json:"caption,omitempty"`
	// DataSourceURL - The URL to the website where the caption was found. You must attribute the caption to the source. For example, by displaying the domain name from the URL next to the caption and using the URL to link to the source website.
	DataSourceURL *string `json:"dataSourceUrl,omitempty"`
	// RelatedSearches - A list of entities found in the caption. Use the contents of the Query object to find the entity in the caption and create a link. The link takes the user to images of the entity.
	RelatedSearches *[]Query `json:"relatedSearches,omitempty"`
}

// ImageObject defines an image
type ImageObject struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeImageGallery', 'TypeRecipe', 'TypeNormalizedRectangle', 'TypeRecognizedEntity', 'TypeRecognizedEntityRegion', 'TypeImageInsights', 'TypeTrendingImages', 'TypeWebPage', 'TypePerson', 'TypeIntangible', 'TypeCollectionPage', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ReadLink - The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	// DatePublished - The date on which the CreativeWork was published.
	DatePublished *string `json:"datePublished,omitempty"`
	// Text - Text content of this creative work
	Text *string `json:"text,omitempty"`
	// ContentURL - Original URL to retrieve the source (file) for the media object (e.g the source URL for the image).
	ContentURL *string `json:"contentUrl,omitempty"`
	// HostPageURL - URL of the page that hosts the media object.
	HostPageURL *string `json:"hostPageUrl,omitempty"`
	// ContentSize - Size of the media object content (use format "value unit" e.g "1024 B").
	ContentSize *string `json:"contentSize,omitempty"`
	// EncodingFormat - Encoding format (e.g mp3, mp4, jpeg, etc).
	EncodingFormat *string `json:"encodingFormat,omitempty"`
	// HostPageDisplayURL - Display URL of the page that hosts the media object.
	HostPageDisplayURL *string `json:"hostPageDisplayUrl,omitempty"`
	// Width - The width of the source media object, in pixels.
	Width *int32 `json:"width,omitempty"`
	// Height - The height of the source media object, in pixels.
	Height *int32 `json:"height,omitempty"`
	// Thumbnail - The URL to a thumbnail of the image
	Thumbnail *ImageObject `json:"thumbnail,omitempty"`
	// ImageInsightsToken - The token that you use in a subsequent call to the Image Search API to get additional information about the image. For information about using this token, see the insightsToken query parameter.
	ImageInsightsToken *string `json:"imageInsightsToken,omitempty"`
	// InsightsMetadata - A count of the number of websites where you can shop or perform other actions related to the image. For example, if the image is of an apple pie, this object includes a count of the number of websites where you can buy an apple pie. To indicate the number of offers in your UX, include badging such as a shopping cart icon that contains the count. When the user clicks on the icon, use imageInisghtsToken to get the list of websites.
	InsightsMetadata *ImagesImageMetadata `json:"insightsMetadata,omitempty"`
	// ImageID - Unique Id for the image
	ImageID *string `json:"imageId,omitempty"`
	// AccentColor - A three-byte hexadecimal number that represents the color that dominates the image. Use the color as the temporary background in your client until the image is loaded.
	AccentColor *string `json:"accentColor,omitempty"`
	// VisualWords - Visual representation of the image. Used for getting more sizes
	VisualWords *string `json:"visualWords,omitempty"`
}

// MarshalJSON is the custom marshaler for ImageObject.
func (ioVar ImageObject) MarshalJSON() ([]byte, error) {
	ioVar.Type = TypeImageObject
	type Alias ImageObject
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ioVar),
	})
}

// AsOrganization is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsImageObject() (*ImageObject, bool) {
	return &ioVar, true
}

// AsImages is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicMediaObject() (BasicMediaObject, bool) {
	return &ioVar, true
}

// AsResponse is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicResponse() (BasicResponse, bool) {
	return &ioVar, true
}

// AsThing is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicThing() (BasicThing, bool) {
	return &ioVar, true
}

// AsCreativeWork is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &ioVar, true
}

// AsIdentifiable is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &ioVar, true
}

// AsErrorResponse is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsImageGallery is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsImageGallery() (*ImageGallery, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsNormalizedRectangle is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsNormalizedRectangle() (*NormalizedRectangle, bool) {
	return nil, false
}

// AsRecognizedEntity is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsRecognizedEntity() (*RecognizedEntity, bool) {
	return nil, false
}

// AsRecognizedEntityRegion is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsRecognizedEntityRegion() (*RecognizedEntityRegion, bool) {
	return nil, false
}

// AsImageInsights is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsImageInsights() (*ImageInsights, bool) {
	return nil, false
}

// AsTrendingImages is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsTrendingImages() (*TrendingImages, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsBasicWebPage is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicWebPage() (BasicWebPage, bool) {
	return nil, false
}

// AsPerson is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsCollectionPage is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsCollectionPage() (*CollectionPage, bool) {
	return nil, false
}

// AsBasicCollectionPage is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicCollectionPage() (BasicCollectionPage, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &ioVar, true
}

// UnmarshalJSON is the custom unmarshaler for ImageObject struct.
func (ioVar *ImageObject) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["thumbnail"]
	if v != nil {
		var thumbnail ImageObject
		err = json.Unmarshal(*m["thumbnail"], &thumbnail)
		if err != nil {
			return err
		}
		ioVar.Thumbnail = &thumbnail
	}

	v = m["imageInsightsToken"]
	if v != nil {
		var imageInsightsToken string
		err = json.Unmarshal(*m["imageInsightsToken"], &imageInsightsToken)
		if err != nil {
			return err
		}
		ioVar.ImageInsightsToken = &imageInsightsToken
	}

	v = m["insightsMetadata"]
	if v != nil {
		var insightsMetadata ImagesImageMetadata
		err = json.Unmarshal(*m["insightsMetadata"], &insightsMetadata)
		if err != nil {
			return err
		}
		ioVar.InsightsMetadata = &insightsMetadata
	}

	v = m["imageId"]
	if v != nil {
		var imageID string
		err = json.Unmarshal(*m["imageId"], &imageID)
		if err != nil {
			return err
		}
		ioVar.ImageID = &imageID
	}

	v = m["accentColor"]
	if v != nil {
		var accentColor string
		err = json.Unmarshal(*m["accentColor"], &accentColor)
		if err != nil {
			return err
		}
		ioVar.AccentColor = &accentColor
	}

	v = m["visualWords"]
	if v != nil {
		var visualWords string
		err = json.Unmarshal(*m["visualWords"], &visualWords)
		if err != nil {
			return err
		}
		ioVar.VisualWords = &visualWords
	}

	v = m["contentUrl"]
	if v != nil {
		var contentURL string
		err = json.Unmarshal(*m["contentUrl"], &contentURL)
		if err != nil {
			return err
		}
		ioVar.ContentURL = &contentURL
	}

	v = m["hostPageUrl"]
	if v != nil {
		var hostPageURL string
		err = json.Unmarshal(*m["hostPageUrl"], &hostPageURL)
		if err != nil {
			return err
		}
		ioVar.HostPageURL = &hostPageURL
	}

	v = m["contentSize"]
	if v != nil {
		var contentSize string
		err = json.Unmarshal(*m["contentSize"], &contentSize)
		if err != nil {
			return err
		}
		ioVar.ContentSize = &contentSize
	}

	v = m["encodingFormat"]
	if v != nil {
		var encodingFormat string
		err = json.Unmarshal(*m["encodingFormat"], &encodingFormat)
		if err != nil {
			return err
		}
		ioVar.EncodingFormat = &encodingFormat
	}

	v = m["hostPageDisplayUrl"]
	if v != nil {
		var hostPageDisplayURL string
		err = json.Unmarshal(*m["hostPageDisplayUrl"], &hostPageDisplayURL)
		if err != nil {
			return err
		}
		ioVar.HostPageDisplayURL = &hostPageDisplayURL
	}

	v = m["width"]
	if v != nil {
		var width int32
		err = json.Unmarshal(*m["width"], &width)
		if err != nil {
			return err
		}
		ioVar.Width = &width
	}

	v = m["height"]
	if v != nil {
		var height int32
		err = json.Unmarshal(*m["height"], &height)
		if err != nil {
			return err
		}
		ioVar.Height = &height
	}

	v = m["thumbnailUrl"]
	if v != nil {
		var thumbnailURL string
		err = json.Unmarshal(*m["thumbnailUrl"], &thumbnailURL)
		if err != nil {
			return err
		}
		ioVar.ThumbnailURL = &thumbnailURL
	}

	v = m["provider"]
	if v != nil {
		provider, err := unmarshalBasicThingArray(*m["provider"])
		if err != nil {
			return err
		}
		ioVar.Provider = &provider
	}

	v = m["datePublished"]
	if v != nil {
		var datePublished string
		err = json.Unmarshal(*m["datePublished"], &datePublished)
		if err != nil {
			return err
		}
		ioVar.DatePublished = &datePublished
	}

	v = m["text"]
	if v != nil {
		var textVar string
		err = json.Unmarshal(*m["text"], &textVar)
		if err != nil {
			return err
		}
		ioVar.Text = &textVar
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		ioVar.Name = &name
	}

	v = m["url"]
	if v != nil {
		var URLVar string
		err = json.Unmarshal(*m["url"], &URLVar)
		if err != nil {
			return err
		}
		ioVar.URL = &URLVar
	}

	v = m["image"]
	if v != nil {
		var imageVar ImageObject
		err = json.Unmarshal(*m["image"], &imageVar)
		if err != nil {
			return err
		}
		ioVar.Image = &imageVar
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		ioVar.Description = &description
	}

	v = m["alternateName"]
	if v != nil {
		var alternateName string
		err = json.Unmarshal(*m["alternateName"], &alternateName)
		if err != nil {
			return err
		}
		ioVar.AlternateName = &alternateName
	}

	v = m["bingId"]
	if v != nil {
		var bingID string
		err = json.Unmarshal(*m["bingId"], &bingID)
		if err != nil {
			return err
		}
		ioVar.BingID = &bingID
	}

	v = m["readLink"]
	if v != nil {
		var readLink string
		err = json.Unmarshal(*m["readLink"], &readLink)
		if err != nil {
			return err
		}
		ioVar.ReadLink = &readLink
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		ioVar.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		ioVar.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type TypeBasicResponseBase
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		ioVar.Type = _type
	}

	return nil
}

// Images defines an image answer
type Images struct {
	autorest.Response `json:"-"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeImageGallery', 'TypeRecipe', 'TypeNormalizedRectangle', 'TypeRecognizedEntity', 'TypeRecognizedEntityRegion', 'TypeImageInsights', 'TypeTrendingImages', 'TypeWebPage', 'TypePerson', 'TypeIntangible', 'TypeCollectionPage', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ReadLink - The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// TotalEstimatedMatches - The estimated number of webpages that are relevant to the query. Use this number along with the count and offset query parameters to page the results.
	TotalEstimatedMatches *int64 `json:"totalEstimatedMatches,omitempty"`
	// NextOffset - Used as part of deduping. Tells client the next offset that client should use in the next pagination request
	NextOffset *int32 `json:"nextOffset,omitempty"`
	// Value - A list of image objects that are relevant to the query. If there are no results, the List is empty.
	Value *[]ImageObject `json:"value,omitempty"`
	// QueryExpansions - A list of expanded queries that narrows the original query. For example, if the query was Microsoft Surface, the expanded queries might be: Microsoft Surface Pro 3, Microsoft Surface RT, Microsoft Surface Phone, and Microsoft Surface Hub.
	QueryExpansions *[]Query `json:"queryExpansions,omitempty"`
	// PivotSuggestions - A list of segments in the original query. For example, if the query was Red Flowers, Bing might segment the query into Red and Flowers. The Flowers pivot may contain query suggestions such as Red Peonies and Red Daisies, and the Red pivot may contain query suggestions such as Green Flowers and Yellow Flowers.
	PivotSuggestions *[]PivotSuggestions `json:"pivotSuggestions,omitempty"`
	// SimilarTerms - A list of terms that are similar in meaning to the user's query term.
	SimilarTerms *[]Query `json:"similarTerms,omitempty"`
}

// MarshalJSON is the custom marshaler for Images.
func (i Images) MarshalJSON() ([]byte, error) {
	i.Type = TypeImages
	type Alias Images
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(i),
	})
}

// AsOrganization is the BasicResponseBase implementation for Images.
func (i Images) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for Images.
func (i Images) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for Images.
func (i Images) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for Images.
func (i Images) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for Images.
func (i Images) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for Images.
func (i Images) AsImages() (*Images, bool) {
	return &i, true
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Images.
func (i Images) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Images.
func (i Images) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return &i, true
}

// AsAnswer is the BasicResponseBase implementation for Images.
func (i Images) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Images.
func (i Images) AsBasicAnswer() (BasicAnswer, bool) {
	return &i, true
}

// AsMediaObject is the BasicResponseBase implementation for Images.
func (i Images) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Images.
func (i Images) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Images.
func (i Images) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Images.
func (i Images) AsBasicResponse() (BasicResponse, bool) {
	return &i, true
}

// AsThing is the BasicResponseBase implementation for Images.
func (i Images) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Images.
func (i Images) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Images.
func (i Images) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Images.
func (i Images) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Images.
func (i Images) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Images.
func (i Images) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &i, true
}

// AsErrorResponse is the BasicResponseBase implementation for Images.
func (i Images) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsImageGallery is the BasicResponseBase implementation for Images.
func (i Images) AsImageGallery() (*ImageGallery, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for Images.
func (i Images) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsNormalizedRectangle is the BasicResponseBase implementation for Images.
func (i Images) AsNormalizedRectangle() (*NormalizedRectangle, bool) {
	return nil, false
}

// AsRecognizedEntity is the BasicResponseBase implementation for Images.
func (i Images) AsRecognizedEntity() (*RecognizedEntity, bool) {
	return nil, false
}

// AsRecognizedEntityRegion is the BasicResponseBase implementation for Images.
func (i Images) AsRecognizedEntityRegion() (*RecognizedEntityRegion, bool) {
	return nil, false
}

// AsImageInsights is the BasicResponseBase implementation for Images.
func (i Images) AsImageInsights() (*ImageInsights, bool) {
	return nil, false
}

// AsTrendingImages is the BasicResponseBase implementation for Images.
func (i Images) AsTrendingImages() (*TrendingImages, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for Images.
func (i Images) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsBasicWebPage is the BasicResponseBase implementation for Images.
func (i Images) AsBasicWebPage() (BasicWebPage, bool) {
	return nil, false
}

// AsPerson is the BasicResponseBase implementation for Images.
func (i Images) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Images.
func (i Images) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for Images.
func (i Images) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsCollectionPage is the BasicResponseBase implementation for Images.
func (i Images) AsCollectionPage() (*CollectionPage, bool) {
	return nil, false
}

// AsBasicCollectionPage is the BasicResponseBase implementation for Images.
func (i Images) AsBasicCollectionPage() (BasicCollectionPage, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Images.
func (i Images) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for Images.
func (i Images) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Images.
func (i Images) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Images.
func (i Images) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &i, true
}

// ImagesImageMetadata defines a count of the number of websites where you can shop or perform other actions related to
// the image.
type ImagesImageMetadata struct {
	// ShoppingSourcesCount - The number of websites that offer goods of the products seen in the image.
	ShoppingSourcesCount *int32 `json:"shoppingSourcesCount,omitempty"`
	// RecipeSourcesCount - The number of websites that offer recipes of the food seen in the image.
	RecipeSourcesCount *int32 `json:"recipeSourcesCount,omitempty"`
	// AggregateOffer - A summary of the online offers of products found in the image. For example, if the image is of a dress, the offer might identify the lowest price and the number of offers found. Only visually similar products insights include this field. The offer includes the following fields: Name, AggregateRating, OfferCount, and LowPrice.
	AggregateOffer *AggregateOffer `json:"aggregateOffer,omitempty"`
}

// ImagesModule defines a list of images.
type ImagesModule struct {
	// Value - A list of images.
	Value *[]ImageObject `json:"value,omitempty"`
}

// ImageTagsModule defines the characteristics of content found in an image.
type ImageTagsModule struct {
	// Value - A list of tags that describe the characteristics of the content found in the image. For example, if the image is of a musical artist, the list might include Female, Dress, and Music to indicate the person is female music artist that's wearing a dress.
	Value *[]InsightsTag `json:"value,omitempty"`
}

// InsightsTag defines a characteristic of the content found in the image.
type InsightsTag struct {
	// Name - The name of the characteristic. For example, cat, kitty, calico cat.
	Name *string `json:"name,omitempty"`
}

// BasicIntangible a utility class that serves as the umbrella for a number of 'intangible' things such as quantities,
// structured values, etc.
type BasicIntangible interface {
	AsNormalizedRectangle() (*NormalizedRectangle, bool)
	AsStructuredValue() (*StructuredValue, bool)
	AsBasicStructuredValue() (BasicStructuredValue, bool)
	AsIntangible() (*Intangible, bool)
}

// Intangible a utility class that serves as the umbrella for a number of 'intangible' things such as quantities,
// structured values, etc.
type Intangible struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeImageGallery', 'TypeRecipe', 'TypeNormalizedRectangle', 'TypeRecognizedEntity', 'TypeRecognizedEntityRegion', 'TypeImageInsights', 'TypeTrendingImages', 'TypeWebPage', 'TypePerson', 'TypeIntangible', 'TypeCollectionPage', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ReadLink - The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
}

func unmarshalBasicIntangible(body []byte) (BasicIntangible, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeNormalizedRectangle):
		var nr NormalizedRectangle
		err := json.Unmarshal(body, &nr)
		return nr, err
	case string(TypeStructuredValue):
		var sv StructuredValue
		err := json.Unmarshal(body, &sv)
		return sv, err
	default:
		var i Intangible
		err := json.Unmarshal(body, &i)
		return i, err
	}
}
func unmarshalBasicIntangibleArray(body []byte) ([]BasicIntangible, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	iArray := make([]BasicIntangible, len(rawMessages))

	for index, rawMessage := range rawMessages {
		i, err := unmarshalBasicIntangible(*rawMessage)
		if err != nil {
			return nil, err
		}
		iArray[index] = i
	}
	return iArray, nil
}

// MarshalJSON is the custom marshaler for Intangible.
func (i Intangible) MarshalJSON() ([]byte, error) {
	i.Type = TypeIntangible
	type Alias Intangible
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(i),
	})
}

// AsOrganization is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicResponse() (BasicResponse, bool) {
	return &i, true
}

// AsThing is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicThing() (BasicThing, bool) {
	return &i, true
}

// AsCreativeWork is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &i, true
}

// AsErrorResponse is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsImageGallery is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsImageGallery() (*ImageGallery, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsNormalizedRectangle is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsNormalizedRectangle() (*NormalizedRectangle, bool) {
	return nil, false
}

// AsRecognizedEntity is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsRecognizedEntity() (*RecognizedEntity, bool) {
	return nil, false
}

// AsRecognizedEntityRegion is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsRecognizedEntityRegion() (*RecognizedEntityRegion, bool) {
	return nil, false
}

// AsImageInsights is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsImageInsights() (*ImageInsights, bool) {
	return nil, false
}

// AsTrendingImages is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsTrendingImages() (*TrendingImages, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsBasicWebPage is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicWebPage() (BasicWebPage, bool) {
	return nil, false
}

// AsPerson is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsIntangible() (*Intangible, bool) {
	return &i, true
}

// AsBasicIntangible is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicIntangible() (BasicIntangible, bool) {
	return &i, true
}

// AsCollectionPage is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsCollectionPage() (*CollectionPage, bool) {
	return nil, false
}

// AsBasicCollectionPage is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicCollectionPage() (BasicCollectionPage, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &i, true
}

// BasicMediaObject defines a media object.
type BasicMediaObject interface {
	AsImageObject() (*ImageObject, bool)
	AsMediaObject() (*MediaObject, bool)
}

// MediaObject defines a media object.
type MediaObject struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeImageGallery', 'TypeRecipe', 'TypeNormalizedRectangle', 'TypeRecognizedEntity', 'TypeRecognizedEntityRegion', 'TypeImageInsights', 'TypeTrendingImages', 'TypeWebPage', 'TypePerson', 'TypeIntangible', 'TypeCollectionPage', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ReadLink - The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	// DatePublished - The date on which the CreativeWork was published.
	DatePublished *string `json:"datePublished,omitempty"`
	// Text - Text content of this creative work
	Text *string `json:"text,omitempty"`
	// ContentURL - Original URL to retrieve the source (file) for the media object (e.g the source URL for the image).
	ContentURL *string `json:"contentUrl,omitempty"`
	// HostPageURL - URL of the page that hosts the media object.
	HostPageURL *string `json:"hostPageUrl,omitempty"`
	// ContentSize - Size of the media object content (use format "value unit" e.g "1024 B").
	ContentSize *string `json:"contentSize,omitempty"`
	// EncodingFormat - Encoding format (e.g mp3, mp4, jpeg, etc).
	EncodingFormat *string `json:"encodingFormat,omitempty"`
	// HostPageDisplayURL - Display URL of the page that hosts the media object.
	HostPageDisplayURL *string `json:"hostPageDisplayUrl,omitempty"`
	// Width - The width of the source media object, in pixels.
	Width *int32 `json:"width,omitempty"`
	// Height - The height of the source media object, in pixels.
	Height *int32 `json:"height,omitempty"`
}

func unmarshalBasicMediaObject(body []byte) (BasicMediaObject, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	default:
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	}
}
func unmarshalBasicMediaObjectArray(body []byte) ([]BasicMediaObject, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	moArray := make([]BasicMediaObject, len(rawMessages))

	for index, rawMessage := range rawMessages {
		mo, err := unmarshalBasicMediaObject(*rawMessage)
		if err != nil {
			return nil, err
		}
		moArray[index] = mo
	}
	return moArray, nil
}

// MarshalJSON is the custom marshaler for MediaObject.
func (mo MediaObject) MarshalJSON() ([]byte, error) {
	mo.Type = TypeMediaObject
	type Alias MediaObject
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(mo),
	})
}

// AsOrganization is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsMediaObject() (*MediaObject, bool) {
	return &mo, true
}

// AsBasicMediaObject is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicMediaObject() (BasicMediaObject, bool) {
	return &mo, true
}

// AsResponse is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicResponse() (BasicResponse, bool) {
	return &mo, true
}

// AsThing is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicThing() (BasicThing, bool) {
	return &mo, true
}

// AsCreativeWork is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &mo, true
}

// AsIdentifiable is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &mo, true
}

// AsErrorResponse is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsImageGallery is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsImageGallery() (*ImageGallery, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsNormalizedRectangle is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsNormalizedRectangle() (*NormalizedRectangle, bool) {
	return nil, false
}

// AsRecognizedEntity is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsRecognizedEntity() (*RecognizedEntity, bool) {
	return nil, false
}

// AsRecognizedEntityRegion is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsRecognizedEntityRegion() (*RecognizedEntityRegion, bool) {
	return nil, false
}

// AsImageInsights is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsImageInsights() (*ImageInsights, bool) {
	return nil, false
}

// AsTrendingImages is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsTrendingImages() (*TrendingImages, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsBasicWebPage is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicWebPage() (BasicWebPage, bool) {
	return nil, false
}

// AsPerson is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsCollectionPage is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsCollectionPage() (*CollectionPage, bool) {
	return nil, false
}

// AsBasicCollectionPage is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicCollectionPage() (BasicCollectionPage, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &mo, true
}

// UnmarshalJSON is the custom unmarshaler for MediaObject struct.
func (mo *MediaObject) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["contentUrl"]
	if v != nil {
		var contentURL string
		err = json.Unmarshal(*m["contentUrl"], &contentURL)
		if err != nil {
			return err
		}
		mo.ContentURL = &contentURL
	}

	v = m["hostPageUrl"]
	if v != nil {
		var hostPageURL string
		err = json.Unmarshal(*m["hostPageUrl"], &hostPageURL)
		if err != nil {
			return err
		}
		mo.HostPageURL = &hostPageURL
	}

	v = m["contentSize"]
	if v != nil {
		var contentSize string
		err = json.Unmarshal(*m["contentSize"], &contentSize)
		if err != nil {
			return err
		}
		mo.ContentSize = &contentSize
	}

	v = m["encodingFormat"]
	if v != nil {
		var encodingFormat string
		err = json.Unmarshal(*m["encodingFormat"], &encodingFormat)
		if err != nil {
			return err
		}
		mo.EncodingFormat = &encodingFormat
	}

	v = m["hostPageDisplayUrl"]
	if v != nil {
		var hostPageDisplayURL string
		err = json.Unmarshal(*m["hostPageDisplayUrl"], &hostPageDisplayURL)
		if err != nil {
			return err
		}
		mo.HostPageDisplayURL = &hostPageDisplayURL
	}

	v = m["width"]
	if v != nil {
		var width int32
		err = json.Unmarshal(*m["width"], &width)
		if err != nil {
			return err
		}
		mo.Width = &width
	}

	v = m["height"]
	if v != nil {
		var height int32
		err = json.Unmarshal(*m["height"], &height)
		if err != nil {
			return err
		}
		mo.Height = &height
	}

	v = m["thumbnailUrl"]
	if v != nil {
		var thumbnailURL string
		err = json.Unmarshal(*m["thumbnailUrl"], &thumbnailURL)
		if err != nil {
			return err
		}
		mo.ThumbnailURL = &thumbnailURL
	}

	v = m["provider"]
	if v != nil {
		provider, err := unmarshalBasicThingArray(*m["provider"])
		if err != nil {
			return err
		}
		mo.Provider = &provider
	}

	v = m["datePublished"]
	if v != nil {
		var datePublished string
		err = json.Unmarshal(*m["datePublished"], &datePublished)
		if err != nil {
			return err
		}
		mo.DatePublished = &datePublished
	}

	v = m["text"]
	if v != nil {
		var textVar string
		err = json.Unmarshal(*m["text"], &textVar)
		if err != nil {
			return err
		}
		mo.Text = &textVar
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		mo.Name = &name
	}

	v = m["url"]
	if v != nil {
		var URLVar string
		err = json.Unmarshal(*m["url"], &URLVar)
		if err != nil {
			return err
		}
		mo.URL = &URLVar
	}

	v = m["image"]
	if v != nil {
		var imageVar ImageObject
		err = json.Unmarshal(*m["image"], &imageVar)
		if err != nil {
			return err
		}
		mo.Image = &imageVar
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		mo.Description = &description
	}

	v = m["alternateName"]
	if v != nil {
		var alternateName string
		err = json.Unmarshal(*m["alternateName"], &alternateName)
		if err != nil {
			return err
		}
		mo.AlternateName = &alternateName
	}

	v = m["bingId"]
	if v != nil {
		var bingID string
		err = json.Unmarshal(*m["bingId"], &bingID)
		if err != nil {
			return err
		}
		mo.BingID = &bingID
	}

	v = m["readLink"]
	if v != nil {
		var readLink string
		err = json.Unmarshal(*m["readLink"], &readLink)
		if err != nil {
			return err
		}
		mo.ReadLink = &readLink
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		mo.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		mo.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type TypeBasicResponseBase
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		mo.Type = _type
	}

	return nil
}

// NormalizedRectangle defines a region of an image. The region is defined by the coordinates of the top, left corner
// and bottom, right corner of the region. The coordinates are fractional values of the original image's width and
// height in the range 0.0 through 1.0.
type NormalizedRectangle struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeImageGallery', 'TypeRecipe', 'TypeNormalizedRectangle', 'TypeRecognizedEntity', 'TypeRecognizedEntityRegion', 'TypeImageInsights', 'TypeTrendingImages', 'TypeWebPage', 'TypePerson', 'TypeIntangible', 'TypeCollectionPage', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ReadLink - The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// Left - The left coordinate.
	Left *float64 `json:"left,omitempty"`
	// Top - The top coordinate
	Top *float64 `json:"top,omitempty"`
	// Right - The right coordinate
	Right *float64 `json:"right,omitempty"`
	// Bottom - The bottom coordinate
	Bottom *float64 `json:"bottom,omitempty"`
}

// MarshalJSON is the custom marshaler for NormalizedRectangle.
func (nr NormalizedRectangle) MarshalJSON() ([]byte, error) {
	nr.Type = TypeNormalizedRectangle
	type Alias NormalizedRectangle
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(nr),
	})
}

// AsOrganization is the BasicResponseBase implementation for NormalizedRectangle.
func (nr NormalizedRectangle) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for NormalizedRectangle.
func (nr NormalizedRectangle) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for NormalizedRectangle.
func (nr NormalizedRectangle) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for NormalizedRectangle.
func (nr NormalizedRectangle) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for NormalizedRectangle.
func (nr NormalizedRectangle) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for NormalizedRectangle.
func (nr NormalizedRectangle) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for NormalizedRectangle.
func (nr NormalizedRectangle) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for NormalizedRectangle.
func (nr NormalizedRectangle) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for NormalizedRectangle.
func (nr NormalizedRectangle) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for NormalizedRectangle.
func (nr NormalizedRectangle) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for NormalizedRectangle.
func (nr NormalizedRectangle) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for NormalizedRectangle.
func (nr NormalizedRectangle) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for NormalizedRectangle.
func (nr NormalizedRectangle) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for NormalizedRectangle.
func (nr NormalizedRectangle) AsBasicResponse() (BasicResponse, bool) {
	return &nr, true
}

// AsThing is the BasicResponseBase implementation for NormalizedRectangle.
func (nr NormalizedRectangle) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for NormalizedRectangle.
func (nr NormalizedRectangle) AsBasicThing() (BasicThing, bool) {
	return &nr, true
}

// AsCreativeWork is the BasicResponseBase implementation for NormalizedRectangle.
func (nr NormalizedRectangle) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for NormalizedRectangle.
func (nr NormalizedRectangle) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for NormalizedRectangle.
func (nr NormalizedRectangle) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for NormalizedRectangle.
func (nr NormalizedRectangle) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &nr, true
}

// AsErrorResponse is the BasicResponseBase implementation for NormalizedRectangle.
func (nr NormalizedRectangle) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsImageGallery is the BasicResponseBase implementation for NormalizedRectangle.
func (nr NormalizedRectangle) AsImageGallery() (*ImageGallery, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for NormalizedRectangle.
func (nr NormalizedRectangle) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsNormalizedRectangle is the BasicResponseBase implementation for NormalizedRectangle.
func (nr NormalizedRectangle) AsNormalizedRectangle() (*NormalizedRectangle, bool) {
	return &nr, true
}

// AsRecognizedEntity is the BasicResponseBase implementation for NormalizedRectangle.
func (nr NormalizedRectangle) AsRecognizedEntity() (*RecognizedEntity, bool) {
	return nil, false
}

// AsRecognizedEntityRegion is the BasicResponseBase implementation for NormalizedRectangle.
func (nr NormalizedRectangle) AsRecognizedEntityRegion() (*RecognizedEntityRegion, bool) {
	return nil, false
}

// AsImageInsights is the BasicResponseBase implementation for NormalizedRectangle.
func (nr NormalizedRectangle) AsImageInsights() (*ImageInsights, bool) {
	return nil, false
}

// AsTrendingImages is the BasicResponseBase implementation for NormalizedRectangle.
func (nr NormalizedRectangle) AsTrendingImages() (*TrendingImages, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for NormalizedRectangle.
func (nr NormalizedRectangle) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsBasicWebPage is the BasicResponseBase implementation for NormalizedRectangle.
func (nr NormalizedRectangle) AsBasicWebPage() (BasicWebPage, bool) {
	return nil, false
}

// AsPerson is the BasicResponseBase implementation for NormalizedRectangle.
func (nr NormalizedRectangle) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for NormalizedRectangle.
func (nr NormalizedRectangle) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for NormalizedRectangle.
func (nr NormalizedRectangle) AsBasicIntangible() (BasicIntangible, bool) {
	return &nr, true
}

// AsCollectionPage is the BasicResponseBase implementation for NormalizedRectangle.
func (nr NormalizedRectangle) AsCollectionPage() (*CollectionPage, bool) {
	return nil, false
}

// AsBasicCollectionPage is the BasicResponseBase implementation for NormalizedRectangle.
func (nr NormalizedRectangle) AsBasicCollectionPage() (BasicCollectionPage, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for NormalizedRectangle.
func (nr NormalizedRectangle) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for NormalizedRectangle.
func (nr NormalizedRectangle) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return &nr, true
}

// AsResponseBase is the BasicResponseBase implementation for NormalizedRectangle.
func (nr NormalizedRectangle) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for NormalizedRectangle.
func (nr NormalizedRectangle) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &nr, true
}

// BasicOffer defines a merchant's offer.
type BasicOffer interface {
	AsAggregateOffer() (*AggregateOffer, bool)
	AsOffer() (*Offer, bool)
}

// Offer defines a merchant's offer.
type Offer struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeImageGallery', 'TypeRecipe', 'TypeNormalizedRectangle', 'TypeRecognizedEntity', 'TypeRecognizedEntityRegion', 'TypeImageInsights', 'TypeTrendingImages', 'TypeWebPage', 'TypePerson', 'TypeIntangible', 'TypeCollectionPage', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ReadLink - The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// Seller - Seller for this offer
	Seller *Organization `json:"seller,omitempty"`
	// Price - The item's price.
	Price *float64 `json:"price,omitempty"`
	// PriceCurrency - The monetary currency. For example, USD. Possible values include: 'USD', 'CAD', 'GBP', 'EUR', 'COP', 'JPY', 'CNY', 'AUD', 'INR', 'AED', 'AFN', 'ALL', 'AMD', 'ANG', 'AOA', 'ARS', 'AWG', 'AZN', 'BAM', 'BBD', 'BDT', 'BGN', 'BHD', 'BIF', 'BMD', 'BND', 'BOB', 'BOV', 'BRL', 'BSD', 'BTN', 'BWP', 'BYR', 'BZD', 'CDF', 'CHE', 'CHF', 'CHW', 'CLF', 'CLP', 'COU', 'CRC', 'CUC', 'CUP', 'CVE', 'CZK', 'DJF', 'DKK', 'DOP', 'DZD', 'EGP', 'ERN', 'ETB', 'FJD', 'FKP', 'GEL', 'GHS', 'GIP', 'GMD', 'GNF', 'GTQ', 'GYD', 'HKD', 'HNL', 'HRK', 'HTG', 'HUF', 'IDR', 'ILS', 'IQD', 'IRR', 'ISK', 'JMD', 'JOD', 'KES', 'KGS', 'KHR', 'KMF', 'KPW', 'KRW', 'KWD', 'KYD', 'KZT', 'LAK', 'LBP', 'LKR', 'LRD', 'LSL', 'LYD', 'MAD', 'MDL', 'MGA', 'MKD', 'MMK', 'MNT', 'MOP', 'MRO', 'MUR', 'MVR', 'MWK', 'MXN', 'MXV', 'MYR', 'MZN', 'NAD', 'NGN', 'NIO', 'NOK', 'NPR', 'NZD', 'OMR', 'PAB', 'PEN', 'PGK', 'PHP', 'PKR', 'PLN', 'PYG', 'QAR', 'RON', 'RSD', 'RUB', 'RWF', 'SAR', 'SBD', 'SCR', 'SDG', 'SEK', 'SGD', 'SHP', 'SLL', 'SOS', 'SRD', 'SSP', 'STD', 'SYP', 'SZL', 'THB', 'TJS', 'TMT', 'TND', 'TOP', 'TRY', 'TTD', 'TWD', 'TZS', 'UAH', 'UGX', 'UYU', 'UZS', 'VEF', 'VND', 'VUV', 'WST', 'XAF', 'XCD', 'XOF', 'XPF', 'YER', 'ZAR', 'ZMW'
	PriceCurrency Currency `json:"priceCurrency,omitempty"`
	// Availability - The item's availability. The following are the possible values: Discontinued, InStock, InStoreOnly, LimitedAvailability, OnlineOnly, OutOfStock, PreOrder, SoldOut. Possible values include: 'Discontinued', 'InStock', 'InStoreOnly', 'LimitedAvailability', 'OnlineOnly', 'OutOfStock', 'PreOrder', 'SoldOut'
	Availability ItemAvailability `json:"availability,omitempty"`
	// AggregateRating - An aggregated rating that indicates how well the product has been rated by others.
	AggregateRating *AggregateRating `json:"aggregateRating,omitempty"`
	// LastUpdated - The last date that the offer was updated. The date is in the form YYYY-MM-DD.
	LastUpdated *string `json:"lastUpdated,omitempty"`
}

func unmarshalBasicOffer(body []byte) (BasicOffer, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeAggregateOffer):
		var ao AggregateOffer
		err := json.Unmarshal(body, &ao)
		return ao, err
	default:
		var o Offer
		err := json.Unmarshal(body, &o)
		return o, err
	}
}
func unmarshalBasicOfferArray(body []byte) ([]BasicOffer, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	oArray := make([]BasicOffer, len(rawMessages))

	for index, rawMessage := range rawMessages {
		o, err := unmarshalBasicOffer(*rawMessage)
		if err != nil {
			return nil, err
		}
		oArray[index] = o
	}
	return oArray, nil
}

// MarshalJSON is the custom marshaler for Offer.
func (o Offer) MarshalJSON() ([]byte, error) {
	o.Type = TypeOffer
	type Alias Offer
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(o),
	})
}

// AsOrganization is the BasicResponseBase implementation for Offer.
func (o Offer) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for Offer.
func (o Offer) AsOffer() (*Offer, bool) {
	return &o, true
}

// AsBasicOffer is the BasicResponseBase implementation for Offer.
func (o Offer) AsBasicOffer() (BasicOffer, bool) {
	return &o, true
}

// AsAggregateOffer is the BasicResponseBase implementation for Offer.
func (o Offer) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for Offer.
func (o Offer) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for Offer.
func (o Offer) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Offer.
func (o Offer) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Offer.
func (o Offer) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for Offer.
func (o Offer) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Offer.
func (o Offer) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Offer.
func (o Offer) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Offer.
func (o Offer) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Offer.
func (o Offer) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Offer.
func (o Offer) AsBasicResponse() (BasicResponse, bool) {
	return &o, true
}

// AsThing is the BasicResponseBase implementation for Offer.
func (o Offer) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Offer.
func (o Offer) AsBasicThing() (BasicThing, bool) {
	return &o, true
}

// AsCreativeWork is the BasicResponseBase implementation for Offer.
func (o Offer) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Offer.
func (o Offer) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Offer.
func (o Offer) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Offer.
func (o Offer) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &o, true
}

// AsErrorResponse is the BasicResponseBase implementation for Offer.
func (o Offer) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsImageGallery is the BasicResponseBase implementation for Offer.
func (o Offer) AsImageGallery() (*ImageGallery, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for Offer.
func (o Offer) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsNormalizedRectangle is the BasicResponseBase implementation for Offer.
func (o Offer) AsNormalizedRectangle() (*NormalizedRectangle, bool) {
	return nil, false
}

// AsRecognizedEntity is the BasicResponseBase implementation for Offer.
func (o Offer) AsRecognizedEntity() (*RecognizedEntity, bool) {
	return nil, false
}

// AsRecognizedEntityRegion is the BasicResponseBase implementation for Offer.
func (o Offer) AsRecognizedEntityRegion() (*RecognizedEntityRegion, bool) {
	return nil, false
}

// AsImageInsights is the BasicResponseBase implementation for Offer.
func (o Offer) AsImageInsights() (*ImageInsights, bool) {
	return nil, false
}

// AsTrendingImages is the BasicResponseBase implementation for Offer.
func (o Offer) AsTrendingImages() (*TrendingImages, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for Offer.
func (o Offer) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsBasicWebPage is the BasicResponseBase implementation for Offer.
func (o Offer) AsBasicWebPage() (BasicWebPage, bool) {
	return nil, false
}

// AsPerson is the BasicResponseBase implementation for Offer.
func (o Offer) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Offer.
func (o Offer) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for Offer.
func (o Offer) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsCollectionPage is the BasicResponseBase implementation for Offer.
func (o Offer) AsCollectionPage() (*CollectionPage, bool) {
	return nil, false
}

// AsBasicCollectionPage is the BasicResponseBase implementation for Offer.
func (o Offer) AsBasicCollectionPage() (BasicCollectionPage, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Offer.
func (o Offer) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for Offer.
func (o Offer) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Offer.
func (o Offer) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Offer.
func (o Offer) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &o, true
}

// Organization defines an organization.
type Organization struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeImageGallery', 'TypeRecipe', 'TypeNormalizedRectangle', 'TypeRecognizedEntity', 'TypeRecognizedEntityRegion', 'TypeImageInsights', 'TypeTrendingImages', 'TypeWebPage', 'TypePerson', 'TypeIntangible', 'TypeCollectionPage', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ReadLink - The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
}

// MarshalJSON is the custom marshaler for Organization.
func (o Organization) MarshalJSON() ([]byte, error) {
	o.Type = TypeOrganization
	type Alias Organization
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(o),
	})
}

// AsOrganization is the BasicResponseBase implementation for Organization.
func (o Organization) AsOrganization() (*Organization, bool) {
	return &o, true
}

// AsOffer is the BasicResponseBase implementation for Organization.
func (o Organization) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for Organization.
func (o Organization) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for Organization.
func (o Organization) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for Organization.
func (o Organization) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Organization.
func (o Organization) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for Organization.
func (o Organization) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Organization.
func (o Organization) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Organization.
func (o Organization) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicResponse() (BasicResponse, bool) {
	return &o, true
}

// AsThing is the BasicResponseBase implementation for Organization.
func (o Organization) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicThing() (BasicThing, bool) {
	return &o, true
}

// AsCreativeWork is the BasicResponseBase implementation for Organization.
func (o Organization) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Organization.
func (o Organization) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &o, true
}

// AsErrorResponse is the BasicResponseBase implementation for Organization.
func (o Organization) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsImageGallery is the BasicResponseBase implementation for Organization.
func (o Organization) AsImageGallery() (*ImageGallery, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for Organization.
func (o Organization) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsNormalizedRectangle is the BasicResponseBase implementation for Organization.
func (o Organization) AsNormalizedRectangle() (*NormalizedRectangle, bool) {
	return nil, false
}

// AsRecognizedEntity is the BasicResponseBase implementation for Organization.
func (o Organization) AsRecognizedEntity() (*RecognizedEntity, bool) {
	return nil, false
}

// AsRecognizedEntityRegion is the BasicResponseBase implementation for Organization.
func (o Organization) AsRecognizedEntityRegion() (*RecognizedEntityRegion, bool) {
	return nil, false
}

// AsImageInsights is the BasicResponseBase implementation for Organization.
func (o Organization) AsImageInsights() (*ImageInsights, bool) {
	return nil, false
}

// AsTrendingImages is the BasicResponseBase implementation for Organization.
func (o Organization) AsTrendingImages() (*TrendingImages, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for Organization.
func (o Organization) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsBasicWebPage is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicWebPage() (BasicWebPage, bool) {
	return nil, false
}

// AsPerson is the BasicResponseBase implementation for Organization.
func (o Organization) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Organization.
func (o Organization) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsCollectionPage is the BasicResponseBase implementation for Organization.
func (o Organization) AsCollectionPage() (*CollectionPage, bool) {
	return nil, false
}

// AsBasicCollectionPage is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicCollectionPage() (BasicCollectionPage, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Organization.
func (o Organization) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Organization.
func (o Organization) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &o, true
}

// Person defines a person.
type Person struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeImageGallery', 'TypeRecipe', 'TypeNormalizedRectangle', 'TypeRecognizedEntity', 'TypeRecognizedEntityRegion', 'TypeImageInsights', 'TypeTrendingImages', 'TypeWebPage', 'TypePerson', 'TypeIntangible', 'TypeCollectionPage', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ReadLink - The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// JobTitle - The person's job title.
	JobTitle *string `json:"jobTitle,omitempty"`
	// TwitterProfile - The URL of the person's twitter profile.
	TwitterProfile *string `json:"twitterProfile,omitempty"`
}

// MarshalJSON is the custom marshaler for Person.
func (p Person) MarshalJSON() ([]byte, error) {
	p.Type = TypePerson
	type Alias Person
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(p),
	})
}

// AsOrganization is the BasicResponseBase implementation for Person.
func (p Person) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for Person.
func (p Person) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for Person.
func (p Person) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for Person.
func (p Person) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for Person.
func (p Person) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for Person.
func (p Person) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Person.
func (p Person) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Person.
func (p Person) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for Person.
func (p Person) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Person.
func (p Person) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Person.
func (p Person) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Person.
func (p Person) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Person.
func (p Person) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Person.
func (p Person) AsBasicResponse() (BasicResponse, bool) {
	return &p, true
}

// AsThing is the BasicResponseBase implementation for Person.
func (p Person) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Person.
func (p Person) AsBasicThing() (BasicThing, bool) {
	return &p, true
}

// AsCreativeWork is the BasicResponseBase implementation for Person.
func (p Person) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Person.
func (p Person) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Person.
func (p Person) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Person.
func (p Person) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &p, true
}

// AsErrorResponse is the BasicResponseBase implementation for Person.
func (p Person) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsImageGallery is the BasicResponseBase implementation for Person.
func (p Person) AsImageGallery() (*ImageGallery, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for Person.
func (p Person) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsNormalizedRectangle is the BasicResponseBase implementation for Person.
func (p Person) AsNormalizedRectangle() (*NormalizedRectangle, bool) {
	return nil, false
}

// AsRecognizedEntity is the BasicResponseBase implementation for Person.
func (p Person) AsRecognizedEntity() (*RecognizedEntity, bool) {
	return nil, false
}

// AsRecognizedEntityRegion is the BasicResponseBase implementation for Person.
func (p Person) AsRecognizedEntityRegion() (*RecognizedEntityRegion, bool) {
	return nil, false
}

// AsImageInsights is the BasicResponseBase implementation for Person.
func (p Person) AsImageInsights() (*ImageInsights, bool) {
	return nil, false
}

// AsTrendingImages is the BasicResponseBase implementation for Person.
func (p Person) AsTrendingImages() (*TrendingImages, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for Person.
func (p Person) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsBasicWebPage is the BasicResponseBase implementation for Person.
func (p Person) AsBasicWebPage() (BasicWebPage, bool) {
	return nil, false
}

// AsPerson is the BasicResponseBase implementation for Person.
func (p Person) AsPerson() (*Person, bool) {
	return &p, true
}

// AsIntangible is the BasicResponseBase implementation for Person.
func (p Person) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for Person.
func (p Person) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsCollectionPage is the BasicResponseBase implementation for Person.
func (p Person) AsCollectionPage() (*CollectionPage, bool) {
	return nil, false
}

// AsBasicCollectionPage is the BasicResponseBase implementation for Person.
func (p Person) AsBasicCollectionPage() (BasicCollectionPage, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Person.
func (p Person) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for Person.
func (p Person) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Person.
func (p Person) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Person.
func (p Person) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &p, true
}

// PivotSuggestions defines the pivot segment.
type PivotSuggestions struct {
	// Pivot - The segment from the original query to pivot on.
	Pivot *string `json:"pivot,omitempty"`
	// Suggestions - A list of suggested queries for the pivot.
	Suggestions *[]Query `json:"suggestions,omitempty"`
}

// BasicPropertiesItem defines an item.
type BasicPropertiesItem interface {
	AsAggregateRating() (*AggregateRating, bool)
	AsRating() (*Rating, bool)
	AsBasicRating() (BasicRating, bool)
	AsPropertiesItem() (*PropertiesItem, bool)
}

// PropertiesItem defines an item.
type PropertiesItem struct {
	// Text - Text representation of an item.
	Text *string `json:"text,omitempty"`
	// Type - Possible values include: 'TypePropertiesItem', 'TypeAggregateRating', 'TypeRating'
	Type Type `json:"_type,omitempty"`
}

func unmarshalBasicPropertiesItem(body []byte) (BasicPropertiesItem, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeAggregateRating):
		var ar AggregateRating
		err := json.Unmarshal(body, &ar)
		return ar, err
	case string(TypeRating):
		var r Rating
		err := json.Unmarshal(body, &r)
		return r, err
	default:
		var pi PropertiesItem
		err := json.Unmarshal(body, &pi)
		return pi, err
	}
}
func unmarshalBasicPropertiesItemArray(body []byte) ([]BasicPropertiesItem, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	piArray := make([]BasicPropertiesItem, len(rawMessages))

	for index, rawMessage := range rawMessages {
		pi, err := unmarshalBasicPropertiesItem(*rawMessage)
		if err != nil {
			return nil, err
		}
		piArray[index] = pi
	}
	return piArray, nil
}

// MarshalJSON is the custom marshaler for PropertiesItem.
func (pi PropertiesItem) MarshalJSON() ([]byte, error) {
	pi.Type = TypePropertiesItem
	type Alias PropertiesItem
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(pi),
	})
}

// AsAggregateRating is the BasicPropertiesItem implementation for PropertiesItem.
func (pi PropertiesItem) AsAggregateRating() (*AggregateRating, bool) {
	return nil, false
}

// AsRating is the BasicPropertiesItem implementation for PropertiesItem.
func (pi PropertiesItem) AsRating() (*Rating, bool) {
	return nil, false
}

// AsBasicRating is the BasicPropertiesItem implementation for PropertiesItem.
func (pi PropertiesItem) AsBasicRating() (BasicRating, bool) {
	return nil, false
}

// AsPropertiesItem is the BasicPropertiesItem implementation for PropertiesItem.
func (pi PropertiesItem) AsPropertiesItem() (*PropertiesItem, bool) {
	return &pi, true
}

// AsBasicPropertiesItem is the BasicPropertiesItem implementation for PropertiesItem.
func (pi PropertiesItem) AsBasicPropertiesItem() (BasicPropertiesItem, bool) {
	return &pi, true
}

// Query defines a search query.
type Query struct {
	// Text - The query string. Use this string as the query term in a new search request.
	Text *string `json:"text,omitempty"`
	// DisplayText - The display version of the query term. This version of the query term may contain special characters that highlight the search term found in the query string. The string contains the highlighting characters only if the query enabled hit highlighting
	DisplayText *string `json:"displayText,omitempty"`
	// WebSearchURL - The URL that takes the user to the Bing search results page for the query.Only related search results include this field.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// SearchLink - The URL that you use to get the results of the related search. Before using the URL, you must append query parameters as appropriate and include the Ocp-Apim-Subscription-Key header. Use this URL if you're displaying the results in your own user interface. Otherwise, use the webSearchUrl URL.
	SearchLink *string `json:"searchLink,omitempty"`
	// Thumbnail - The URL to a thumbnail of a related image.
	Thumbnail *ImageObject `json:"thumbnail,omitempty"`
}

// BasicRating defines a rating.
type BasicRating interface {
	AsAggregateRating() (*AggregateRating, bool)
	AsRating() (*Rating, bool)
}

// Rating defines a rating.
type Rating struct {
	// Text - Text representation of an item.
	Text *string `json:"text,omitempty"`
	// Type - Possible values include: 'TypePropertiesItem', 'TypeAggregateRating', 'TypeRating'
	Type Type `json:"_type,omitempty"`
	// RatingValue - The mean (average) rating. The possible values are 1.0 through 5.0.
	RatingValue *float64 `json:"ratingValue,omitempty"`
	// BestRating - The highest rated review. The possible values are 1.0 through 5.0.
	BestRating *float64 `json:"bestRating,omitempty"`
}

func unmarshalBasicRating(body []byte) (BasicRating, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeAggregateRating):
		var ar AggregateRating
		err := json.Unmarshal(body, &ar)
		return ar, err
	default:
		var r Rating
		err := json.Unmarshal(body, &r)
		return r, err
	}
}
func unmarshalBasicRatingArray(body []byte) ([]BasicRating, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rArray := make([]BasicRating, len(rawMessages))

	for index, rawMessage := range rawMessages {
		r, err := unmarshalBasicRating(*rawMessage)
		if err != nil {
			return nil, err
		}
		rArray[index] = r
	}
	return rArray, nil
}

// MarshalJSON is the custom marshaler for Rating.
func (r Rating) MarshalJSON() ([]byte, error) {
	r.Type = TypeRating
	type Alias Rating
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(r),
	})
}

// AsAggregateRating is the BasicPropertiesItem implementation for Rating.
func (r Rating) AsAggregateRating() (*AggregateRating, bool) {
	return nil, false
}

// AsRating is the BasicPropertiesItem implementation for Rating.
func (r Rating) AsRating() (*Rating, bool) {
	return &r, true
}

// AsBasicRating is the BasicPropertiesItem implementation for Rating.
func (r Rating) AsBasicRating() (BasicRating, bool) {
	return &r, true
}

// AsPropertiesItem is the BasicPropertiesItem implementation for Rating.
func (r Rating) AsPropertiesItem() (*PropertiesItem, bool) {
	return nil, false
}

// AsBasicPropertiesItem is the BasicPropertiesItem implementation for Rating.
func (r Rating) AsBasicPropertiesItem() (BasicPropertiesItem, bool) {
	return &r, true
}

// Recipe defines a cooking recipe.
type Recipe struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeImageGallery', 'TypeRecipe', 'TypeNormalizedRectangle', 'TypeRecognizedEntity', 'TypeRecognizedEntityRegion', 'TypeImageInsights', 'TypeTrendingImages', 'TypeWebPage', 'TypePerson', 'TypeIntangible', 'TypeCollectionPage', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ReadLink - The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	// DatePublished - The date on which the CreativeWork was published.
	DatePublished *string `json:"datePublished,omitempty"`
	// Text - Text content of this creative work
	Text *string `json:"text,omitempty"`
	// CookTime - The amount of time the food takes to cook. For example, PT25M. For information about the time format, see http://en.wikipedia.org/wiki/ISO_8601#Durations.
	CookTime *string `json:"cookTime,omitempty"`
	// PrepTime - The amount of time required to prepare the ingredients. For example, PT15M. For information about the time format, see http://en.wikipedia.org/wiki/ISO_8601#Durations.
	PrepTime *string `json:"prepTime,omitempty"`
	// TotalTime - The total amount of time it takes to prepare and cook the recipe. For example, PT45M. For information about the time format, see http://en.wikipedia.org/wiki/ISO_8601#Durations.
	TotalTime *string `json:"totalTime,omitempty"`
}

// MarshalJSON is the custom marshaler for Recipe.
func (r Recipe) MarshalJSON() ([]byte, error) {
	r.Type = TypeRecipe
	type Alias Recipe
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(r),
	})
}

// AsOrganization is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsBasicResponse() (BasicResponse, bool) {
	return &r, true
}

// AsThing is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsBasicThing() (BasicThing, bool) {
	return &r, true
}

// AsCreativeWork is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &r, true
}

// AsIdentifiable is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &r, true
}

// AsErrorResponse is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsImageGallery is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsImageGallery() (*ImageGallery, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsRecipe() (*Recipe, bool) {
	return &r, true
}

// AsNormalizedRectangle is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsNormalizedRectangle() (*NormalizedRectangle, bool) {
	return nil, false
}

// AsRecognizedEntity is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsRecognizedEntity() (*RecognizedEntity, bool) {
	return nil, false
}

// AsRecognizedEntityRegion is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsRecognizedEntityRegion() (*RecognizedEntityRegion, bool) {
	return nil, false
}

// AsImageInsights is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsImageInsights() (*ImageInsights, bool) {
	return nil, false
}

// AsTrendingImages is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsTrendingImages() (*TrendingImages, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsBasicWebPage is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsBasicWebPage() (BasicWebPage, bool) {
	return nil, false
}

// AsPerson is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsCollectionPage is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsCollectionPage() (*CollectionPage, bool) {
	return nil, false
}

// AsBasicCollectionPage is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsBasicCollectionPage() (BasicCollectionPage, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &r, true
}

// UnmarshalJSON is the custom unmarshaler for Recipe struct.
func (r *Recipe) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["cookTime"]
	if v != nil {
		var cookTime string
		err = json.Unmarshal(*m["cookTime"], &cookTime)
		if err != nil {
			return err
		}
		r.CookTime = &cookTime
	}

	v = m["prepTime"]
	if v != nil {
		var prepTime string
		err = json.Unmarshal(*m["prepTime"], &prepTime)
		if err != nil {
			return err
		}
		r.PrepTime = &prepTime
	}

	v = m["totalTime"]
	if v != nil {
		var totalTime string
		err = json.Unmarshal(*m["totalTime"], &totalTime)
		if err != nil {
			return err
		}
		r.TotalTime = &totalTime
	}

	v = m["thumbnailUrl"]
	if v != nil {
		var thumbnailURL string
		err = json.Unmarshal(*m["thumbnailUrl"], &thumbnailURL)
		if err != nil {
			return err
		}
		r.ThumbnailURL = &thumbnailURL
	}

	v = m["provider"]
	if v != nil {
		provider, err := unmarshalBasicThingArray(*m["provider"])
		if err != nil {
			return err
		}
		r.Provider = &provider
	}

	v = m["datePublished"]
	if v != nil {
		var datePublished string
		err = json.Unmarshal(*m["datePublished"], &datePublished)
		if err != nil {
			return err
		}
		r.DatePublished = &datePublished
	}

	v = m["text"]
	if v != nil {
		var textVar string
		err = json.Unmarshal(*m["text"], &textVar)
		if err != nil {
			return err
		}
		r.Text = &textVar
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		r.Name = &name
	}

	v = m["url"]
	if v != nil {
		var URLVar string
		err = json.Unmarshal(*m["url"], &URLVar)
		if err != nil {
			return err
		}
		r.URL = &URLVar
	}

	v = m["image"]
	if v != nil {
		var imageVar ImageObject
		err = json.Unmarshal(*m["image"], &imageVar)
		if err != nil {
			return err
		}
		r.Image = &imageVar
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		r.Description = &description
	}

	v = m["alternateName"]
	if v != nil {
		var alternateName string
		err = json.Unmarshal(*m["alternateName"], &alternateName)
		if err != nil {
			return err
		}
		r.AlternateName = &alternateName
	}

	v = m["bingId"]
	if v != nil {
		var bingID string
		err = json.Unmarshal(*m["bingId"], &bingID)
		if err != nil {
			return err
		}
		r.BingID = &bingID
	}

	v = m["readLink"]
	if v != nil {
		var readLink string
		err = json.Unmarshal(*m["readLink"], &readLink)
		if err != nil {
			return err
		}
		r.ReadLink = &readLink
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		r.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		r.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type TypeBasicResponseBase
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		r.Type = _type
	}

	return nil
}

// RecipesModule defines a list of recipes.
type RecipesModule struct {
	// Value - A list of recipes.
	Value *[]Recipe `json:"value,omitempty"`
}

// RecognizedEntitiesModule defines a list of previously recognized entities.
type RecognizedEntitiesModule struct {
	// Value - A list of recognized entities.
	Value *[]RecognizedEntityGroup `json:"value,omitempty"`
}

// RecognizedEntity defines a recognized entity.
type RecognizedEntity struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeImageGallery', 'TypeRecipe', 'TypeNormalizedRectangle', 'TypeRecognizedEntity', 'TypeRecognizedEntityRegion', 'TypeImageInsights', 'TypeTrendingImages', 'TypeWebPage', 'TypePerson', 'TypeIntangible', 'TypeCollectionPage', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ReadLink - The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Entity - The entity that was recognized. The following are the possible entity objects: Person
	Entity BasicThing `json:"entity,omitempty"`
	// MatchConfidence - The confidence that Bing has that the entity in the image matches this entity. The confidence ranges from 0.0 through 1.0 with 1.0 being very confident.
	MatchConfidence *float64 `json:"matchConfidence,omitempty"`
}

// MarshalJSON is the custom marshaler for RecognizedEntity.
func (re RecognizedEntity) MarshalJSON() ([]byte, error) {
	re.Type = TypeRecognizedEntity
	type Alias RecognizedEntity
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(re),
	})
}

// AsOrganization is the BasicResponseBase implementation for RecognizedEntity.
func (re RecognizedEntity) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for RecognizedEntity.
func (re RecognizedEntity) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for RecognizedEntity.
func (re RecognizedEntity) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for RecognizedEntity.
func (re RecognizedEntity) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for RecognizedEntity.
func (re RecognizedEntity) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for RecognizedEntity.
func (re RecognizedEntity) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for RecognizedEntity.
func (re RecognizedEntity) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for RecognizedEntity.
func (re RecognizedEntity) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for RecognizedEntity.
func (re RecognizedEntity) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for RecognizedEntity.
func (re RecognizedEntity) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for RecognizedEntity.
func (re RecognizedEntity) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for RecognizedEntity.
func (re RecognizedEntity) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for RecognizedEntity.
func (re RecognizedEntity) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for RecognizedEntity.
func (re RecognizedEntity) AsBasicResponse() (BasicResponse, bool) {
	return &re, true
}

// AsThing is the BasicResponseBase implementation for RecognizedEntity.
func (re RecognizedEntity) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for RecognizedEntity.
func (re RecognizedEntity) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for RecognizedEntity.
func (re RecognizedEntity) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for RecognizedEntity.
func (re RecognizedEntity) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for RecognizedEntity.
func (re RecognizedEntity) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for RecognizedEntity.
func (re RecognizedEntity) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &re, true
}

// AsErrorResponse is the BasicResponseBase implementation for RecognizedEntity.
func (re RecognizedEntity) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsImageGallery is the BasicResponseBase implementation for RecognizedEntity.
func (re RecognizedEntity) AsImageGallery() (*ImageGallery, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for RecognizedEntity.
func (re RecognizedEntity) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsNormalizedRectangle is the BasicResponseBase implementation for RecognizedEntity.
func (re RecognizedEntity) AsNormalizedRectangle() (*NormalizedRectangle, bool) {
	return nil, false
}

// AsRecognizedEntity is the BasicResponseBase implementation for RecognizedEntity.
func (re RecognizedEntity) AsRecognizedEntity() (*RecognizedEntity, bool) {
	return &re, true
}

// AsRecognizedEntityRegion is the BasicResponseBase implementation for RecognizedEntity.
func (re RecognizedEntity) AsRecognizedEntityRegion() (*RecognizedEntityRegion, bool) {
	return nil, false
}

// AsImageInsights is the BasicResponseBase implementation for RecognizedEntity.
func (re RecognizedEntity) AsImageInsights() (*ImageInsights, bool) {
	return nil, false
}

// AsTrendingImages is the BasicResponseBase implementation for RecognizedEntity.
func (re RecognizedEntity) AsTrendingImages() (*TrendingImages, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for RecognizedEntity.
func (re RecognizedEntity) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsBasicWebPage is the BasicResponseBase implementation for RecognizedEntity.
func (re RecognizedEntity) AsBasicWebPage() (BasicWebPage, bool) {
	return nil, false
}

// AsPerson is the BasicResponseBase implementation for RecognizedEntity.
func (re RecognizedEntity) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for RecognizedEntity.
func (re RecognizedEntity) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for RecognizedEntity.
func (re RecognizedEntity) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsCollectionPage is the BasicResponseBase implementation for RecognizedEntity.
func (re RecognizedEntity) AsCollectionPage() (*CollectionPage, bool) {
	return nil, false
}

// AsBasicCollectionPage is the BasicResponseBase implementation for RecognizedEntity.
func (re RecognizedEntity) AsBasicCollectionPage() (BasicCollectionPage, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for RecognizedEntity.
func (re RecognizedEntity) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for RecognizedEntity.
func (re RecognizedEntity) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for RecognizedEntity.
func (re RecognizedEntity) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for RecognizedEntity.
func (re RecognizedEntity) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &re, true
}

// UnmarshalJSON is the custom unmarshaler for RecognizedEntity struct.
func (re *RecognizedEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["entity"]
	if v != nil {
		entity, err := unmarshalBasicThing(*m["entity"])
		if err != nil {
			return err
		}
		re.Entity = entity
	}

	v = m["matchConfidence"]
	if v != nil {
		var matchConfidence float64
		err = json.Unmarshal(*m["matchConfidence"], &matchConfidence)
		if err != nil {
			return err
		}
		re.MatchConfidence = &matchConfidence
	}

	v = m["readLink"]
	if v != nil {
		var readLink string
		err = json.Unmarshal(*m["readLink"], &readLink)
		if err != nil {
			return err
		}
		re.ReadLink = &readLink
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		re.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		re.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type TypeBasicResponseBase
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		re.Type = _type
	}

	return nil
}

// RecognizedEntityGroup defines a group of previously recognized entities.
type RecognizedEntityGroup struct {
	// RecognizedEntityRegions - The regions of the image that contain entities.
	RecognizedEntityRegions *[]RecognizedEntityRegion `json:"recognizedEntityRegions,omitempty"`
	// Name - The name of the group where images of the entity were also found. The following are possible groups. CelebRecognitionAnnotations: Similar to CelebrityAnnotations but provides a higher probability of an accurate match. CelebrityAnnotations: Contains celebrities such as actors, politicians, athletes, and historical figures.
	Name *string `json:"name,omitempty"`
}

// RecognizedEntityRegion defines a region of the image where an entity was found and a list of entities that might
// match it.
type RecognizedEntityRegion struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeImageGallery', 'TypeRecipe', 'TypeNormalizedRectangle', 'TypeRecognizedEntity', 'TypeRecognizedEntityRegion', 'TypeImageInsights', 'TypeTrendingImages', 'TypeWebPage', 'TypePerson', 'TypeIntangible', 'TypeCollectionPage', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ReadLink - The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Region - A region of the image that contains an entity. The values of the rectangle are relative to the width and height of the original image and are in the range 0.0 through 1.0. For example, if the image is 300x200 and the region's top, left corner is at point (10, 20) and the bottom, right corner is at point (290, 150), then the normalized rectangle is: Left = 0.0333333333333333, Top = 0.1, Right = 0.9666666666666667, Bottom = 0.75. For people, the region represents the person's face.
	Region *NormalizedRectangle `json:"region,omitempty"`
	// MatchingEntities - A list of entities that Bing believes match the entity found in the region. The entities are in descending order of confidence (see the matchConfidence field of RecognizedEntity).
	MatchingEntities *[]RecognizedEntity `json:"matchingEntities,omitempty"`
}

// MarshalJSON is the custom marshaler for RecognizedEntityRegion.
func (rer RecognizedEntityRegion) MarshalJSON() ([]byte, error) {
	rer.Type = TypeRecognizedEntityRegion
	type Alias RecognizedEntityRegion
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(rer),
	})
}

// AsOrganization is the BasicResponseBase implementation for RecognizedEntityRegion.
func (rer RecognizedEntityRegion) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for RecognizedEntityRegion.
func (rer RecognizedEntityRegion) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for RecognizedEntityRegion.
func (rer RecognizedEntityRegion) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for RecognizedEntityRegion.
func (rer RecognizedEntityRegion) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for RecognizedEntityRegion.
func (rer RecognizedEntityRegion) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for RecognizedEntityRegion.
func (rer RecognizedEntityRegion) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for RecognizedEntityRegion.
func (rer RecognizedEntityRegion) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for RecognizedEntityRegion.
func (rer RecognizedEntityRegion) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for RecognizedEntityRegion.
func (rer RecognizedEntityRegion) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for RecognizedEntityRegion.
func (rer RecognizedEntityRegion) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for RecognizedEntityRegion.
func (rer RecognizedEntityRegion) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for RecognizedEntityRegion.
func (rer RecognizedEntityRegion) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for RecognizedEntityRegion.
func (rer RecognizedEntityRegion) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for RecognizedEntityRegion.
func (rer RecognizedEntityRegion) AsBasicResponse() (BasicResponse, bool) {
	return &rer, true
}

// AsThing is the BasicResponseBase implementation for RecognizedEntityRegion.
func (rer RecognizedEntityRegion) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for RecognizedEntityRegion.
func (rer RecognizedEntityRegion) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for RecognizedEntityRegion.
func (rer RecognizedEntityRegion) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for RecognizedEntityRegion.
func (rer RecognizedEntityRegion) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for RecognizedEntityRegion.
func (rer RecognizedEntityRegion) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for RecognizedEntityRegion.
func (rer RecognizedEntityRegion) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &rer, true
}

// AsErrorResponse is the BasicResponseBase implementation for RecognizedEntityRegion.
func (rer RecognizedEntityRegion) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsImageGallery is the BasicResponseBase implementation for RecognizedEntityRegion.
func (rer RecognizedEntityRegion) AsImageGallery() (*ImageGallery, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for RecognizedEntityRegion.
func (rer RecognizedEntityRegion) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsNormalizedRectangle is the BasicResponseBase implementation for RecognizedEntityRegion.
func (rer RecognizedEntityRegion) AsNormalizedRectangle() (*NormalizedRectangle, bool) {
	return nil, false
}

// AsRecognizedEntity is the BasicResponseBase implementation for RecognizedEntityRegion.
func (rer RecognizedEntityRegion) AsRecognizedEntity() (*RecognizedEntity, bool) {
	return nil, false
}

// AsRecognizedEntityRegion is the BasicResponseBase implementation for RecognizedEntityRegion.
func (rer RecognizedEntityRegion) AsRecognizedEntityRegion() (*RecognizedEntityRegion, bool) {
	return &rer, true
}

// AsImageInsights is the BasicResponseBase implementation for RecognizedEntityRegion.
func (rer RecognizedEntityRegion) AsImageInsights() (*ImageInsights, bool) {
	return nil, false
}

// AsTrendingImages is the BasicResponseBase implementation for RecognizedEntityRegion.
func (rer RecognizedEntityRegion) AsTrendingImages() (*TrendingImages, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for RecognizedEntityRegion.
func (rer RecognizedEntityRegion) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsBasicWebPage is the BasicResponseBase implementation for RecognizedEntityRegion.
func (rer RecognizedEntityRegion) AsBasicWebPage() (BasicWebPage, bool) {
	return nil, false
}

// AsPerson is the BasicResponseBase implementation for RecognizedEntityRegion.
func (rer RecognizedEntityRegion) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for RecognizedEntityRegion.
func (rer RecognizedEntityRegion) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for RecognizedEntityRegion.
func (rer RecognizedEntityRegion) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsCollectionPage is the BasicResponseBase implementation for RecognizedEntityRegion.
func (rer RecognizedEntityRegion) AsCollectionPage() (*CollectionPage, bool) {
	return nil, false
}

// AsBasicCollectionPage is the BasicResponseBase implementation for RecognizedEntityRegion.
func (rer RecognizedEntityRegion) AsBasicCollectionPage() (BasicCollectionPage, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for RecognizedEntityRegion.
func (rer RecognizedEntityRegion) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for RecognizedEntityRegion.
func (rer RecognizedEntityRegion) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for RecognizedEntityRegion.
func (rer RecognizedEntityRegion) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for RecognizedEntityRegion.
func (rer RecognizedEntityRegion) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &rer, true
}

// RelatedCollectionsModule defines a list of webpages that contain related images.
type RelatedCollectionsModule struct {
	// Value - A list of webpages that contain related images.
	Value *[]ImageGallery `json:"value,omitempty"`
}

// RelatedSearchesModule defines a list of related searches.
type RelatedSearchesModule struct {
	// Value - A list of related searches.
	Value *[]Query `json:"value,omitempty"`
}

// BasicResponse defines a response. All schemas that could be returned at the root of a response should inherit from
// this
type BasicResponse interface {
	AsOrganization() (*Organization, bool)
	AsOffer() (*Offer, bool)
	AsBasicOffer() (BasicOffer, bool)
	AsAggregateOffer() (*AggregateOffer, bool)
	AsImageObject() (*ImageObject, bool)
	AsImages() (*Images, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
	AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool)
	AsAnswer() (*Answer, bool)
	AsBasicAnswer() (BasicAnswer, bool)
	AsMediaObject() (*MediaObject, bool)
	AsBasicMediaObject() (BasicMediaObject, bool)
	AsThing() (*Thing, bool)
	AsBasicThing() (BasicThing, bool)
	AsCreativeWork() (*CreativeWork, bool)
	AsBasicCreativeWork() (BasicCreativeWork, bool)
	AsErrorResponse() (*ErrorResponse, bool)
	AsImageGallery() (*ImageGallery, bool)
	AsRecipe() (*Recipe, bool)
	AsNormalizedRectangle() (*NormalizedRectangle, bool)
	AsRecognizedEntity() (*RecognizedEntity, bool)
	AsRecognizedEntityRegion() (*RecognizedEntityRegion, bool)
	AsImageInsights() (*ImageInsights, bool)
	AsTrendingImages() (*TrendingImages, bool)
	AsWebPage() (*WebPage, bool)
	AsBasicWebPage() (BasicWebPage, bool)
	AsPerson() (*Person, bool)
	AsIntangible() (*Intangible, bool)
	AsBasicIntangible() (BasicIntangible, bool)
	AsCollectionPage() (*CollectionPage, bool)
	AsBasicCollectionPage() (BasicCollectionPage, bool)
	AsStructuredValue() (*StructuredValue, bool)
	AsBasicStructuredValue() (BasicStructuredValue, bool)
	AsResponse() (*Response, bool)
}

// Response defines a response. All schemas that could be returned at the root of a response should inherit from this
type Response struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeImageGallery', 'TypeRecipe', 'TypeNormalizedRectangle', 'TypeRecognizedEntity', 'TypeRecognizedEntityRegion', 'TypeImageInsights', 'TypeTrendingImages', 'TypeWebPage', 'TypePerson', 'TypeIntangible', 'TypeCollectionPage', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ReadLink - The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
}

func unmarshalBasicResponse(body []byte) (BasicResponse, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeOrganization):
		var o Organization
		err := json.Unmarshal(body, &o)
		return o, err
	case string(TypeOffer):
		var o Offer
		err := json.Unmarshal(body, &o)
		return o, err
	case string(TypeAggregateOffer):
		var ao AggregateOffer
		err := json.Unmarshal(body, &ao)
		return ao, err
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	case string(TypeImages):
		var i Images
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeSearchResultsAnswer):
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	case string(TypeAnswer):
		var a Answer
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeMediaObject):
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	case string(TypeThing):
		var t Thing
		err := json.Unmarshal(body, &t)
		return t, err
	case string(TypeCreativeWork):
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	case string(TypeErrorResponse):
		var er ErrorResponse
		err := json.Unmarshal(body, &er)
		return er, err
	case string(TypeImageGallery):
		var ig ImageGallery
		err := json.Unmarshal(body, &ig)
		return ig, err
	case string(TypeRecipe):
		var r Recipe
		err := json.Unmarshal(body, &r)
		return r, err
	case string(TypeNormalizedRectangle):
		var nr NormalizedRectangle
		err := json.Unmarshal(body, &nr)
		return nr, err
	case string(TypeRecognizedEntity):
		var re RecognizedEntity
		err := json.Unmarshal(body, &re)
		return re, err
	case string(TypeRecognizedEntityRegion):
		var rer RecognizedEntityRegion
		err := json.Unmarshal(body, &rer)
		return rer, err
	case string(TypeImageInsights):
		var ii ImageInsights
		err := json.Unmarshal(body, &ii)
		return ii, err
	case string(TypeTrendingImages):
		var ti TrendingImages
		err := json.Unmarshal(body, &ti)
		return ti, err
	case string(TypeWebPage):
		var wp WebPage
		err := json.Unmarshal(body, &wp)
		return wp, err
	case string(TypePerson):
		var p Person
		err := json.Unmarshal(body, &p)
		return p, err
	case string(TypeIntangible):
		var i Intangible
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeCollectionPage):
		var cp CollectionPage
		err := json.Unmarshal(body, &cp)
		return cp, err
	case string(TypeStructuredValue):
		var sv StructuredValue
		err := json.Unmarshal(body, &sv)
		return sv, err
	default:
		var r Response
		err := json.Unmarshal(body, &r)
		return r, err
	}
}
func unmarshalBasicResponseArray(body []byte) ([]BasicResponse, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rArray := make([]BasicResponse, len(rawMessages))

	for index, rawMessage := range rawMessages {
		r, err := unmarshalBasicResponse(*rawMessage)
		if err != nil {
			return nil, err
		}
		rArray[index] = r
	}
	return rArray, nil
}

// MarshalJSON is the custom marshaler for Response.
func (r Response) MarshalJSON() ([]byte, error) {
	r.Type = TypeResponse
	type Alias Response
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(r),
	})
}

// AsOrganization is the BasicResponseBase implementation for Response.
func (r Response) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for Response.
func (r Response) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for Response.
func (r Response) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for Response.
func (r Response) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for Response.
func (r Response) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for Response.
func (r Response) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Response.
func (r Response) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Response.
func (r Response) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for Response.
func (r Response) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Response.
func (r Response) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Response.
func (r Response) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Response.
func (r Response) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Response.
func (r Response) AsResponse() (*Response, bool) {
	return &r, true
}

// AsBasicResponse is the BasicResponseBase implementation for Response.
func (r Response) AsBasicResponse() (BasicResponse, bool) {
	return &r, true
}

// AsThing is the BasicResponseBase implementation for Response.
func (r Response) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Response.
func (r Response) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Response.
func (r Response) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Response.
func (r Response) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Response.
func (r Response) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Response.
func (r Response) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &r, true
}

// AsErrorResponse is the BasicResponseBase implementation for Response.
func (r Response) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsImageGallery is the BasicResponseBase implementation for Response.
func (r Response) AsImageGallery() (*ImageGallery, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for Response.
func (r Response) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsNormalizedRectangle is the BasicResponseBase implementation for Response.
func (r Response) AsNormalizedRectangle() (*NormalizedRectangle, bool) {
	return nil, false
}

// AsRecognizedEntity is the BasicResponseBase implementation for Response.
func (r Response) AsRecognizedEntity() (*RecognizedEntity, bool) {
	return nil, false
}

// AsRecognizedEntityRegion is the BasicResponseBase implementation for Response.
func (r Response) AsRecognizedEntityRegion() (*RecognizedEntityRegion, bool) {
	return nil, false
}

// AsImageInsights is the BasicResponseBase implementation for Response.
func (r Response) AsImageInsights() (*ImageInsights, bool) {
	return nil, false
}

// AsTrendingImages is the BasicResponseBase implementation for Response.
func (r Response) AsTrendingImages() (*TrendingImages, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for Response.
func (r Response) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsBasicWebPage is the BasicResponseBase implementation for Response.
func (r Response) AsBasicWebPage() (BasicWebPage, bool) {
	return nil, false
}

// AsPerson is the BasicResponseBase implementation for Response.
func (r Response) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Response.
func (r Response) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for Response.
func (r Response) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsCollectionPage is the BasicResponseBase implementation for Response.
func (r Response) AsCollectionPage() (*CollectionPage, bool) {
	return nil, false
}

// AsBasicCollectionPage is the BasicResponseBase implementation for Response.
func (r Response) AsBasicCollectionPage() (BasicCollectionPage, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Response.
func (r Response) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for Response.
func (r Response) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Response.
func (r Response) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Response.
func (r Response) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &r, true
}

// BasicResponseBase response base
type BasicResponseBase interface {
	AsOrganization() (*Organization, bool)
	AsOffer() (*Offer, bool)
	AsBasicOffer() (BasicOffer, bool)
	AsAggregateOffer() (*AggregateOffer, bool)
	AsImageObject() (*ImageObject, bool)
	AsImages() (*Images, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
	AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool)
	AsAnswer() (*Answer, bool)
	AsBasicAnswer() (BasicAnswer, bool)
	AsMediaObject() (*MediaObject, bool)
	AsBasicMediaObject() (BasicMediaObject, bool)
	AsResponse() (*Response, bool)
	AsBasicResponse() (BasicResponse, bool)
	AsThing() (*Thing, bool)
	AsBasicThing() (BasicThing, bool)
	AsCreativeWork() (*CreativeWork, bool)
	AsBasicCreativeWork() (BasicCreativeWork, bool)
	AsIdentifiable() (*Identifiable, bool)
	AsBasicIdentifiable() (BasicIdentifiable, bool)
	AsErrorResponse() (*ErrorResponse, bool)
	AsImageGallery() (*ImageGallery, bool)
	AsRecipe() (*Recipe, bool)
	AsNormalizedRectangle() (*NormalizedRectangle, bool)
	AsRecognizedEntity() (*RecognizedEntity, bool)
	AsRecognizedEntityRegion() (*RecognizedEntityRegion, bool)
	AsImageInsights() (*ImageInsights, bool)
	AsTrendingImages() (*TrendingImages, bool)
	AsWebPage() (*WebPage, bool)
	AsBasicWebPage() (BasicWebPage, bool)
	AsPerson() (*Person, bool)
	AsIntangible() (*Intangible, bool)
	AsBasicIntangible() (BasicIntangible, bool)
	AsCollectionPage() (*CollectionPage, bool)
	AsBasicCollectionPage() (BasicCollectionPage, bool)
	AsStructuredValue() (*StructuredValue, bool)
	AsBasicStructuredValue() (BasicStructuredValue, bool)
	AsResponseBase() (*ResponseBase, bool)
}

// ResponseBase response base
type ResponseBase struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeImageGallery', 'TypeRecipe', 'TypeNormalizedRectangle', 'TypeRecognizedEntity', 'TypeRecognizedEntityRegion', 'TypeImageInsights', 'TypeTrendingImages', 'TypeWebPage', 'TypePerson', 'TypeIntangible', 'TypeCollectionPage', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
}

func unmarshalBasicResponseBase(body []byte) (BasicResponseBase, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeOrganization):
		var o Organization
		err := json.Unmarshal(body, &o)
		return o, err
	case string(TypeOffer):
		var o Offer
		err := json.Unmarshal(body, &o)
		return o, err
	case string(TypeAggregateOffer):
		var ao AggregateOffer
		err := json.Unmarshal(body, &ao)
		return ao, err
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	case string(TypeImages):
		var i Images
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeSearchResultsAnswer):
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	case string(TypeAnswer):
		var a Answer
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeMediaObject):
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	case string(TypeResponse):
		var r Response
		err := json.Unmarshal(body, &r)
		return r, err
	case string(TypeThing):
		var t Thing
		err := json.Unmarshal(body, &t)
		return t, err
	case string(TypeCreativeWork):
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	case string(TypeIdentifiable):
		var i Identifiable
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeErrorResponse):
		var er ErrorResponse
		err := json.Unmarshal(body, &er)
		return er, err
	case string(TypeImageGallery):
		var ig ImageGallery
		err := json.Unmarshal(body, &ig)
		return ig, err
	case string(TypeRecipe):
		var r Recipe
		err := json.Unmarshal(body, &r)
		return r, err
	case string(TypeNormalizedRectangle):
		var nr NormalizedRectangle
		err := json.Unmarshal(body, &nr)
		return nr, err
	case string(TypeRecognizedEntity):
		var re RecognizedEntity
		err := json.Unmarshal(body, &re)
		return re, err
	case string(TypeRecognizedEntityRegion):
		var rer RecognizedEntityRegion
		err := json.Unmarshal(body, &rer)
		return rer, err
	case string(TypeImageInsights):
		var ii ImageInsights
		err := json.Unmarshal(body, &ii)
		return ii, err
	case string(TypeTrendingImages):
		var ti TrendingImages
		err := json.Unmarshal(body, &ti)
		return ti, err
	case string(TypeWebPage):
		var wp WebPage
		err := json.Unmarshal(body, &wp)
		return wp, err
	case string(TypePerson):
		var p Person
		err := json.Unmarshal(body, &p)
		return p, err
	case string(TypeIntangible):
		var i Intangible
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeCollectionPage):
		var cp CollectionPage
		err := json.Unmarshal(body, &cp)
		return cp, err
	case string(TypeStructuredValue):
		var sv StructuredValue
		err := json.Unmarshal(body, &sv)
		return sv, err
	default:
		var rb ResponseBase
		err := json.Unmarshal(body, &rb)
		return rb, err
	}
}
func unmarshalBasicResponseBaseArray(body []byte) ([]BasicResponseBase, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rbArray := make([]BasicResponseBase, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rb, err := unmarshalBasicResponseBase(*rawMessage)
		if err != nil {
			return nil, err
		}
		rbArray[index] = rb
	}
	return rbArray, nil
}

// MarshalJSON is the custom marshaler for ResponseBase.
func (rb ResponseBase) MarshalJSON() ([]byte, error) {
	rb.Type = TypeResponseBase
	type Alias ResponseBase
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(rb),
	})
}

// AsOrganization is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicResponse() (BasicResponse, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsImageGallery is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsImageGallery() (*ImageGallery, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsNormalizedRectangle is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsNormalizedRectangle() (*NormalizedRectangle, bool) {
	return nil, false
}

// AsRecognizedEntity is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsRecognizedEntity() (*RecognizedEntity, bool) {
	return nil, false
}

// AsRecognizedEntityRegion is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsRecognizedEntityRegion() (*RecognizedEntityRegion, bool) {
	return nil, false
}

// AsImageInsights is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsImageInsights() (*ImageInsights, bool) {
	return nil, false
}

// AsTrendingImages is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsTrendingImages() (*TrendingImages, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsBasicWebPage is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicWebPage() (BasicWebPage, bool) {
	return nil, false
}

// AsPerson is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsCollectionPage is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsCollectionPage() (*CollectionPage, bool) {
	return nil, false
}

// AsBasicCollectionPage is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicCollectionPage() (BasicCollectionPage, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsResponseBase() (*ResponseBase, bool) {
	return &rb, true
}

// AsBasicResponseBase is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &rb, true
}

// BasicSearchResultsAnswer defines a search result answer.
type BasicSearchResultsAnswer interface {
	AsImages() (*Images, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
}

// SearchResultsAnswer defines a search result answer.
type SearchResultsAnswer struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeImageGallery', 'TypeRecipe', 'TypeNormalizedRectangle', 'TypeRecognizedEntity', 'TypeRecognizedEntityRegion', 'TypeImageInsights', 'TypeTrendingImages', 'TypeWebPage', 'TypePerson', 'TypeIntangible', 'TypeCollectionPage', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ReadLink - The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// TotalEstimatedMatches - The estimated number of webpages that are relevant to the query. Use this number along with the count and offset query parameters to page the results.
	TotalEstimatedMatches *int64 `json:"totalEstimatedMatches,omitempty"`
}

func unmarshalBasicSearchResultsAnswer(body []byte) (BasicSearchResultsAnswer, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeImages):
		var i Images
		err := json.Unmarshal(body, &i)
		return i, err
	default:
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	}
}
func unmarshalBasicSearchResultsAnswerArray(body []byte) ([]BasicSearchResultsAnswer, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	sraArray := make([]BasicSearchResultsAnswer, len(rawMessages))

	for index, rawMessage := range rawMessages {
		sra, err := unmarshalBasicSearchResultsAnswer(*rawMessage)
		if err != nil {
			return nil, err
		}
		sraArray[index] = sra
	}
	return sraArray, nil
}

// MarshalJSON is the custom marshaler for SearchResultsAnswer.
func (sra SearchResultsAnswer) MarshalJSON() ([]byte, error) {
	sra.Type = TypeSearchResultsAnswer
	type Alias SearchResultsAnswer
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(sra),
	})
}

// AsOrganization is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return &sra, true
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return &sra, true
}

// AsAnswer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicAnswer() (BasicAnswer, bool) {
	return &sra, true
}

// AsMediaObject is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicResponse() (BasicResponse, bool) {
	return &sra, true
}

// AsThing is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &sra, true
}

// AsErrorResponse is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsImageGallery is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsImageGallery() (*ImageGallery, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsNormalizedRectangle is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsNormalizedRectangle() (*NormalizedRectangle, bool) {
	return nil, false
}

// AsRecognizedEntity is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsRecognizedEntity() (*RecognizedEntity, bool) {
	return nil, false
}

// AsRecognizedEntityRegion is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsRecognizedEntityRegion() (*RecognizedEntityRegion, bool) {
	return nil, false
}

// AsImageInsights is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsImageInsights() (*ImageInsights, bool) {
	return nil, false
}

// AsTrendingImages is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsTrendingImages() (*TrendingImages, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsBasicWebPage is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicWebPage() (BasicWebPage, bool) {
	return nil, false
}

// AsPerson is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsCollectionPage is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsCollectionPage() (*CollectionPage, bool) {
	return nil, false
}

// AsBasicCollectionPage is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicCollectionPage() (BasicCollectionPage, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &sra, true
}

// BasicStructuredValue
type BasicStructuredValue interface {
	AsNormalizedRectangle() (*NormalizedRectangle, bool)
	AsStructuredValue() (*StructuredValue, bool)
}

// StructuredValue
type StructuredValue struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeImageGallery', 'TypeRecipe', 'TypeNormalizedRectangle', 'TypeRecognizedEntity', 'TypeRecognizedEntityRegion', 'TypeImageInsights', 'TypeTrendingImages', 'TypeWebPage', 'TypePerson', 'TypeIntangible', 'TypeCollectionPage', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ReadLink - The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
}

func unmarshalBasicStructuredValue(body []byte) (BasicStructuredValue, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeNormalizedRectangle):
		var nr NormalizedRectangle
		err := json.Unmarshal(body, &nr)
		return nr, err
	default:
		var sv StructuredValue
		err := json.Unmarshal(body, &sv)
		return sv, err
	}
}
func unmarshalBasicStructuredValueArray(body []byte) ([]BasicStructuredValue, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	svArray := make([]BasicStructuredValue, len(rawMessages))

	for index, rawMessage := range rawMessages {
		sv, err := unmarshalBasicStructuredValue(*rawMessage)
		if err != nil {
			return nil, err
		}
		svArray[index] = sv
	}
	return svArray, nil
}

// MarshalJSON is the custom marshaler for StructuredValue.
func (sv StructuredValue) MarshalJSON() ([]byte, error) {
	sv.Type = TypeStructuredValue
	type Alias StructuredValue
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(sv),
	})
}

// AsOrganization is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicResponse() (BasicResponse, bool) {
	return &sv, true
}

// AsThing is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicThing() (BasicThing, bool) {
	return &sv, true
}

// AsCreativeWork is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &sv, true
}

// AsErrorResponse is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsImageGallery is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsImageGallery() (*ImageGallery, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsNormalizedRectangle is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsNormalizedRectangle() (*NormalizedRectangle, bool) {
	return nil, false
}

// AsRecognizedEntity is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsRecognizedEntity() (*RecognizedEntity, bool) {
	return nil, false
}

// AsRecognizedEntityRegion is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsRecognizedEntityRegion() (*RecognizedEntityRegion, bool) {
	return nil, false
}

// AsImageInsights is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsImageInsights() (*ImageInsights, bool) {
	return nil, false
}

// AsTrendingImages is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsTrendingImages() (*TrendingImages, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsBasicWebPage is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicWebPage() (BasicWebPage, bool) {
	return nil, false
}

// AsPerson is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicIntangible() (BasicIntangible, bool) {
	return &sv, true
}

// AsCollectionPage is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsCollectionPage() (*CollectionPage, bool) {
	return nil, false
}

// AsBasicCollectionPage is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicCollectionPage() (BasicCollectionPage, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsStructuredValue() (*StructuredValue, bool) {
	return &sv, true
}

// AsBasicStructuredValue is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return &sv, true
}

// AsResponseBase is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &sv, true
}

// BasicThing defines a thing.
type BasicThing interface {
	AsOrganization() (*Organization, bool)
	AsOffer() (*Offer, bool)
	AsBasicOffer() (BasicOffer, bool)
	AsAggregateOffer() (*AggregateOffer, bool)
	AsImageObject() (*ImageObject, bool)
	AsMediaObject() (*MediaObject, bool)
	AsBasicMediaObject() (BasicMediaObject, bool)
	AsCreativeWork() (*CreativeWork, bool)
	AsBasicCreativeWork() (BasicCreativeWork, bool)
	AsImageGallery() (*ImageGallery, bool)
	AsRecipe() (*Recipe, bool)
	AsNormalizedRectangle() (*NormalizedRectangle, bool)
	AsWebPage() (*WebPage, bool)
	AsBasicWebPage() (BasicWebPage, bool)
	AsPerson() (*Person, bool)
	AsIntangible() (*Intangible, bool)
	AsBasicIntangible() (BasicIntangible, bool)
	AsCollectionPage() (*CollectionPage, bool)
	AsBasicCollectionPage() (BasicCollectionPage, bool)
	AsStructuredValue() (*StructuredValue, bool)
	AsBasicStructuredValue() (BasicStructuredValue, bool)
	AsThing() (*Thing, bool)
}

// Thing defines a thing.
type Thing struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeImageGallery', 'TypeRecipe', 'TypeNormalizedRectangle', 'TypeRecognizedEntity', 'TypeRecognizedEntityRegion', 'TypeImageInsights', 'TypeTrendingImages', 'TypeWebPage', 'TypePerson', 'TypeIntangible', 'TypeCollectionPage', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ReadLink - The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
}

func unmarshalBasicThing(body []byte) (BasicThing, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeOrganization):
		var o Organization
		err := json.Unmarshal(body, &o)
		return o, err
	case string(TypeOffer):
		var o Offer
		err := json.Unmarshal(body, &o)
		return o, err
	case string(TypeAggregateOffer):
		var ao AggregateOffer
		err := json.Unmarshal(body, &ao)
		return ao, err
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	case string(TypeMediaObject):
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	case string(TypeCreativeWork):
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	case string(TypeImageGallery):
		var ig ImageGallery
		err := json.Unmarshal(body, &ig)
		return ig, err
	case string(TypeRecipe):
		var r Recipe
		err := json.Unmarshal(body, &r)
		return r, err
	case string(TypeNormalizedRectangle):
		var nr NormalizedRectangle
		err := json.Unmarshal(body, &nr)
		return nr, err
	case string(TypeWebPage):
		var wp WebPage
		err := json.Unmarshal(body, &wp)
		return wp, err
	case string(TypePerson):
		var p Person
		err := json.Unmarshal(body, &p)
		return p, err
	case string(TypeIntangible):
		var i Intangible
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeCollectionPage):
		var cp CollectionPage
		err := json.Unmarshal(body, &cp)
		return cp, err
	case string(TypeStructuredValue):
		var sv StructuredValue
		err := json.Unmarshal(body, &sv)
		return sv, err
	default:
		var t Thing
		err := json.Unmarshal(body, &t)
		return t, err
	}
}
func unmarshalBasicThingArray(body []byte) ([]BasicThing, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	tArray := make([]BasicThing, len(rawMessages))

	for index, rawMessage := range rawMessages {
		t, err := unmarshalBasicThing(*rawMessage)
		if err != nil {
			return nil, err
		}
		tArray[index] = t
	}
	return tArray, nil
}

// MarshalJSON is the custom marshaler for Thing.
func (t Thing) MarshalJSON() ([]byte, error) {
	t.Type = TypeThing
	type Alias Thing
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(t),
	})
}

// AsOrganization is the BasicResponseBase implementation for Thing.
func (t Thing) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for Thing.
func (t Thing) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for Thing.
func (t Thing) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for Thing.
func (t Thing) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for Thing.
func (t Thing) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Thing.
func (t Thing) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for Thing.
func (t Thing) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Thing.
func (t Thing) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Thing.
func (t Thing) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicResponse() (BasicResponse, bool) {
	return &t, true
}

// AsThing is the BasicResponseBase implementation for Thing.
func (t Thing) AsThing() (*Thing, bool) {
	return &t, true
}

// AsBasicThing is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicThing() (BasicThing, bool) {
	return &t, true
}

// AsCreativeWork is the BasicResponseBase implementation for Thing.
func (t Thing) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Thing.
func (t Thing) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &t, true
}

// AsErrorResponse is the BasicResponseBase implementation for Thing.
func (t Thing) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsImageGallery is the BasicResponseBase implementation for Thing.
func (t Thing) AsImageGallery() (*ImageGallery, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for Thing.
func (t Thing) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsNormalizedRectangle is the BasicResponseBase implementation for Thing.
func (t Thing) AsNormalizedRectangle() (*NormalizedRectangle, bool) {
	return nil, false
}

// AsRecognizedEntity is the BasicResponseBase implementation for Thing.
func (t Thing) AsRecognizedEntity() (*RecognizedEntity, bool) {
	return nil, false
}

// AsRecognizedEntityRegion is the BasicResponseBase implementation for Thing.
func (t Thing) AsRecognizedEntityRegion() (*RecognizedEntityRegion, bool) {
	return nil, false
}

// AsImageInsights is the BasicResponseBase implementation for Thing.
func (t Thing) AsImageInsights() (*ImageInsights, bool) {
	return nil, false
}

// AsTrendingImages is the BasicResponseBase implementation for Thing.
func (t Thing) AsTrendingImages() (*TrendingImages, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for Thing.
func (t Thing) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsBasicWebPage is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicWebPage() (BasicWebPage, bool) {
	return nil, false
}

// AsPerson is the BasicResponseBase implementation for Thing.
func (t Thing) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Thing.
func (t Thing) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsCollectionPage is the BasicResponseBase implementation for Thing.
func (t Thing) AsCollectionPage() (*CollectionPage, bool) {
	return nil, false
}

// AsBasicCollectionPage is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicCollectionPage() (BasicCollectionPage, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Thing.
func (t Thing) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Thing.
func (t Thing) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &t, true
}

// TrendingImages the top-level object that the response includes when a trending images request succeeds.
type TrendingImages struct {
	autorest.Response `json:"-"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeImageGallery', 'TypeRecipe', 'TypeNormalizedRectangle', 'TypeRecognizedEntity', 'TypeRecognizedEntityRegion', 'TypeImageInsights', 'TypeTrendingImages', 'TypeWebPage', 'TypePerson', 'TypeIntangible', 'TypeCollectionPage', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ReadLink - The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Categories - A list that identifies categories of images and a list of trending images in that category.
	Categories *[]TrendingImagesCategory `json:"categories,omitempty"`
}

// MarshalJSON is the custom marshaler for TrendingImages.
func (ti TrendingImages) MarshalJSON() ([]byte, error) {
	ti.Type = TypeTrendingImages
	type Alias TrendingImages
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ti),
	})
}

// AsOrganization is the BasicResponseBase implementation for TrendingImages.
func (ti TrendingImages) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for TrendingImages.
func (ti TrendingImages) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for TrendingImages.
func (ti TrendingImages) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for TrendingImages.
func (ti TrendingImages) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for TrendingImages.
func (ti TrendingImages) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for TrendingImages.
func (ti TrendingImages) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for TrendingImages.
func (ti TrendingImages) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for TrendingImages.
func (ti TrendingImages) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for TrendingImages.
func (ti TrendingImages) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for TrendingImages.
func (ti TrendingImages) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for TrendingImages.
func (ti TrendingImages) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for TrendingImages.
func (ti TrendingImages) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for TrendingImages.
func (ti TrendingImages) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for TrendingImages.
func (ti TrendingImages) AsBasicResponse() (BasicResponse, bool) {
	return &ti, true
}

// AsThing is the BasicResponseBase implementation for TrendingImages.
func (ti TrendingImages) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for TrendingImages.
func (ti TrendingImages) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for TrendingImages.
func (ti TrendingImages) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for TrendingImages.
func (ti TrendingImages) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for TrendingImages.
func (ti TrendingImages) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for TrendingImages.
func (ti TrendingImages) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &ti, true
}

// AsErrorResponse is the BasicResponseBase implementation for TrendingImages.
func (ti TrendingImages) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsImageGallery is the BasicResponseBase implementation for TrendingImages.
func (ti TrendingImages) AsImageGallery() (*ImageGallery, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for TrendingImages.
func (ti TrendingImages) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsNormalizedRectangle is the BasicResponseBase implementation for TrendingImages.
func (ti TrendingImages) AsNormalizedRectangle() (*NormalizedRectangle, bool) {
	return nil, false
}

// AsRecognizedEntity is the BasicResponseBase implementation for TrendingImages.
func (ti TrendingImages) AsRecognizedEntity() (*RecognizedEntity, bool) {
	return nil, false
}

// AsRecognizedEntityRegion is the BasicResponseBase implementation for TrendingImages.
func (ti TrendingImages) AsRecognizedEntityRegion() (*RecognizedEntityRegion, bool) {
	return nil, false
}

// AsImageInsights is the BasicResponseBase implementation for TrendingImages.
func (ti TrendingImages) AsImageInsights() (*ImageInsights, bool) {
	return nil, false
}

// AsTrendingImages is the BasicResponseBase implementation for TrendingImages.
func (ti TrendingImages) AsTrendingImages() (*TrendingImages, bool) {
	return &ti, true
}

// AsWebPage is the BasicResponseBase implementation for TrendingImages.
func (ti TrendingImages) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsBasicWebPage is the BasicResponseBase implementation for TrendingImages.
func (ti TrendingImages) AsBasicWebPage() (BasicWebPage, bool) {
	return nil, false
}

// AsPerson is the BasicResponseBase implementation for TrendingImages.
func (ti TrendingImages) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for TrendingImages.
func (ti TrendingImages) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for TrendingImages.
func (ti TrendingImages) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsCollectionPage is the BasicResponseBase implementation for TrendingImages.
func (ti TrendingImages) AsCollectionPage() (*CollectionPage, bool) {
	return nil, false
}

// AsBasicCollectionPage is the BasicResponseBase implementation for TrendingImages.
func (ti TrendingImages) AsBasicCollectionPage() (BasicCollectionPage, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for TrendingImages.
func (ti TrendingImages) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for TrendingImages.
func (ti TrendingImages) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for TrendingImages.
func (ti TrendingImages) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for TrendingImages.
func (ti TrendingImages) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &ti, true
}

// TrendingImagesCategory defines the category of trending images.
type TrendingImagesCategory struct {
	// Title - The name of the image category. For example, Popular People Searches.
	Title *string `json:"title,omitempty"`
	// Tiles - A list of images that are trending in the category. Each tile contains an image and a URL that returns more images of the subject. For example, if the category is Popular People Searches, the image is of a popular person and the URL would return more images of that person.
	Tiles *[]TrendingImagesTile `json:"tiles,omitempty"`
}

// TrendingImagesTile defines an image tile.
type TrendingImagesTile struct {
	// Query - A query that returns a Bing search results page with more images of the subject. For example, if the category is Popular People Searches, then the thumbnail is of a popular person. The query would return a Bing search results page with more images of that person.
	Query *Query `json:"query,omitempty"`
	// Image - The image's thumbnail.
	Image *ImageObject `json:"image,omitempty"`
}

// BasicWebPage defines a webpage that is relevant to the query.
type BasicWebPage interface {
	AsImageGallery() (*ImageGallery, bool)
	AsCollectionPage() (*CollectionPage, bool)
	AsBasicCollectionPage() (BasicCollectionPage, bool)
	AsWebPage() (*WebPage, bool)
}

// WebPage defines a webpage that is relevant to the query.
type WebPage struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeImageGallery', 'TypeRecipe', 'TypeNormalizedRectangle', 'TypeRecognizedEntity', 'TypeRecognizedEntityRegion', 'TypeImageInsights', 'TypeTrendingImages', 'TypeWebPage', 'TypePerson', 'TypeIntangible', 'TypeCollectionPage', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ReadLink - The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	// DatePublished - The date on which the CreativeWork was published.
	DatePublished *string `json:"datePublished,omitempty"`
	// Text - Text content of this creative work
	Text *string `json:"text,omitempty"`
}

func unmarshalBasicWebPage(body []byte) (BasicWebPage, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeImageGallery):
		var ig ImageGallery
		err := json.Unmarshal(body, &ig)
		return ig, err
	case string(TypeCollectionPage):
		var cp CollectionPage
		err := json.Unmarshal(body, &cp)
		return cp, err
	default:
		var wp WebPage
		err := json.Unmarshal(body, &wp)
		return wp, err
	}
}
func unmarshalBasicWebPageArray(body []byte) ([]BasicWebPage, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	wpArray := make([]BasicWebPage, len(rawMessages))

	for index, rawMessage := range rawMessages {
		wp, err := unmarshalBasicWebPage(*rawMessage)
		if err != nil {
			return nil, err
		}
		wpArray[index] = wp
	}
	return wpArray, nil
}

// MarshalJSON is the custom marshaler for WebPage.
func (wp WebPage) MarshalJSON() ([]byte, error) {
	wp.Type = TypeWebPage
	type Alias WebPage
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(wp),
	})
}

// AsOrganization is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicResponse() (BasicResponse, bool) {
	return &wp, true
}

// AsThing is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicThing() (BasicThing, bool) {
	return &wp, true
}

// AsCreativeWork is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &wp, true
}

// AsIdentifiable is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &wp, true
}

// AsErrorResponse is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsImageGallery is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsImageGallery() (*ImageGallery, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsNormalizedRectangle is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsNormalizedRectangle() (*NormalizedRectangle, bool) {
	return nil, false
}

// AsRecognizedEntity is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsRecognizedEntity() (*RecognizedEntity, bool) {
	return nil, false
}

// AsRecognizedEntityRegion is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsRecognizedEntityRegion() (*RecognizedEntityRegion, bool) {
	return nil, false
}

// AsImageInsights is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsImageInsights() (*ImageInsights, bool) {
	return nil, false
}

// AsTrendingImages is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsTrendingImages() (*TrendingImages, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsWebPage() (*WebPage, bool) {
	return &wp, true
}

// AsBasicWebPage is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicWebPage() (BasicWebPage, bool) {
	return &wp, true
}

// AsPerson is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsCollectionPage is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsCollectionPage() (*CollectionPage, bool) {
	return nil, false
}

// AsBasicCollectionPage is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicCollectionPage() (BasicCollectionPage, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &wp, true
}

// UnmarshalJSON is the custom unmarshaler for WebPage struct.
func (wp *WebPage) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["thumbnailUrl"]
	if v != nil {
		var thumbnailURL string
		err = json.Unmarshal(*m["thumbnailUrl"], &thumbnailURL)
		if err != nil {
			return err
		}
		wp.ThumbnailURL = &thumbnailURL
	}

	v = m["provider"]
	if v != nil {
		provider, err := unmarshalBasicThingArray(*m["provider"])
		if err != nil {
			return err
		}
		wp.Provider = &provider
	}

	v = m["datePublished"]
	if v != nil {
		var datePublished string
		err = json.Unmarshal(*m["datePublished"], &datePublished)
		if err != nil {
			return err
		}
		wp.DatePublished = &datePublished
	}

	v = m["text"]
	if v != nil {
		var textVar string
		err = json.Unmarshal(*m["text"], &textVar)
		if err != nil {
			return err
		}
		wp.Text = &textVar
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		wp.Name = &name
	}

	v = m["url"]
	if v != nil {
		var URLVar string
		err = json.Unmarshal(*m["url"], &URLVar)
		if err != nil {
			return err
		}
		wp.URL = &URLVar
	}

	v = m["image"]
	if v != nil {
		var imageVar ImageObject
		err = json.Unmarshal(*m["image"], &imageVar)
		if err != nil {
			return err
		}
		wp.Image = &imageVar
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		wp.Description = &description
	}

	v = m["alternateName"]
	if v != nil {
		var alternateName string
		err = json.Unmarshal(*m["alternateName"], &alternateName)
		if err != nil {
			return err
		}
		wp.AlternateName = &alternateName
	}

	v = m["bingId"]
	if v != nil {
		var bingID string
		err = json.Unmarshal(*m["bingId"], &bingID)
		if err != nil {
			return err
		}
		wp.BingID = &bingID
	}

	v = m["readLink"]
	if v != nil {
		var readLink string
		err = json.Unmarshal(*m["readLink"], &readLink)
		if err != nil {
			return err
		}
		wp.ReadLink = &readLink
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		wp.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		wp.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type TypeBasicResponseBase
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		wp.Type = _type
	}

	return nil
}
