// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package polly

import (
	"io"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opDeleteLexicon = "DeleteLexicon"

// DeleteLexiconRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLexicon operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLexicon for more information on using the DeleteLexicon
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteLexiconRequest method.
//    req, resp := client.DeleteLexiconRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/DeleteLexicon
func (c *Polly) DeleteLexiconRequest(input *DeleteLexiconInput) (req *request.Request, output *DeleteLexiconOutput) {
	op := &request.Operation{
		Name:       opDeleteLexicon,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/lexicons/{LexiconName}",
	}

	if input == nil {
		input = &DeleteLexiconInput{}
	}

	output = &DeleteLexiconOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteLexicon API operation for Amazon Polly.
//
// Deletes the specified pronunciation lexicon stored in an AWS Region. A lexicon
// which has been deleted is not available for speech synthesis, nor is it possible
// to retrieve it using either the GetLexicon or ListLexicon APIs.
//
// For more information, see Managing Lexicons (http://docs.aws.amazon.com/polly/latest/dg/managing-lexicons.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Polly's
// API operation DeleteLexicon for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLexiconNotFoundException "LexiconNotFoundException"
//   Amazon Polly can't find the specified lexicon. This could be caused by a
//   lexicon that is missing, its name is misspelled or specifying a lexicon that
//   is in a different region.
//
//   Verify that the lexicon exists, is in the region (see ListLexicons) and that
//   you spelled its name is spelled correctly. Then try again.
//
//   * ErrCodeServiceFailureException "ServiceFailureException"
//   An unknown condition has caused a service failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/DeleteLexicon
func (c *Polly) DeleteLexicon(input *DeleteLexiconInput) (*DeleteLexiconOutput, error) {
	req, out := c.DeleteLexiconRequest(input)
	return out, req.Send()
}

// DeleteLexiconWithContext is the same as DeleteLexicon with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLexicon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Polly) DeleteLexiconWithContext(ctx aws.Context, input *DeleteLexiconInput, opts ...request.Option) (*DeleteLexiconOutput, error) {
	req, out := c.DeleteLexiconRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeVoices = "DescribeVoices"

// DescribeVoicesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeVoices operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeVoices for more information on using the DescribeVoices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeVoicesRequest method.
//    req, resp := client.DescribeVoicesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/DescribeVoices
func (c *Polly) DescribeVoicesRequest(input *DescribeVoicesInput) (req *request.Request, output *DescribeVoicesOutput) {
	op := &request.Operation{
		Name:       opDescribeVoices,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/voices",
	}

	if input == nil {
		input = &DescribeVoicesInput{}
	}

	output = &DescribeVoicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeVoices API operation for Amazon Polly.
//
// Returns the list of voices that are available for use when requesting speech
// synthesis. Each voice speaks a specified language, is either male or female,
// and is identified by an ID, which is the ASCII version of the voice name.
//
// When synthesizing speech ( SynthesizeSpeech ), you provide the voice ID for
// the voice you want from the list of voices returned by DescribeVoices.
//
// For example, you want your news reader application to read news in a specific
// language, but giving a user the option to choose the voice. Using the DescribeVoices
// operation you can provide the user with a list of available voices to select
// from.
//
// You can optionally specify a language code to filter the available voices.
// For example, if you specify en-US, the operation returns a list of all available
// US English voices.
//
// This operation requires permissions to perform the polly:DescribeVoices action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Polly's
// API operation DescribeVoices for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The NextToken is invalid. Verify that it's spelled correctly, and then try
//   again.
//
//   * ErrCodeServiceFailureException "ServiceFailureException"
//   An unknown condition has caused a service failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/DescribeVoices
func (c *Polly) DescribeVoices(input *DescribeVoicesInput) (*DescribeVoicesOutput, error) {
	req, out := c.DescribeVoicesRequest(input)
	return out, req.Send()
}

// DescribeVoicesWithContext is the same as DescribeVoices with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeVoices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Polly) DescribeVoicesWithContext(ctx aws.Context, input *DescribeVoicesInput, opts ...request.Option) (*DescribeVoicesOutput, error) {
	req, out := c.DescribeVoicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLexicon = "GetLexicon"

// GetLexiconRequest generates a "aws/request.Request" representing the
// client's request for the GetLexicon operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLexicon for more information on using the GetLexicon
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetLexiconRequest method.
//    req, resp := client.GetLexiconRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/GetLexicon
func (c *Polly) GetLexiconRequest(input *GetLexiconInput) (req *request.Request, output *GetLexiconOutput) {
	op := &request.Operation{
		Name:       opGetLexicon,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/lexicons/{LexiconName}",
	}

	if input == nil {
		input = &GetLexiconInput{}
	}

	output = &GetLexiconOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLexicon API operation for Amazon Polly.
//
// Returns the content of the specified pronunciation lexicon stored in an AWS
// Region. For more information, see Managing Lexicons (http://docs.aws.amazon.com/polly/latest/dg/managing-lexicons.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Polly's
// API operation GetLexicon for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLexiconNotFoundException "LexiconNotFoundException"
//   Amazon Polly can't find the specified lexicon. This could be caused by a
//   lexicon that is missing, its name is misspelled or specifying a lexicon that
//   is in a different region.
//
//   Verify that the lexicon exists, is in the region (see ListLexicons) and that
//   you spelled its name is spelled correctly. Then try again.
//
//   * ErrCodeServiceFailureException "ServiceFailureException"
//   An unknown condition has caused a service failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/GetLexicon
func (c *Polly) GetLexicon(input *GetLexiconInput) (*GetLexiconOutput, error) {
	req, out := c.GetLexiconRequest(input)
	return out, req.Send()
}

// GetLexiconWithContext is the same as GetLexicon with the addition of
// the ability to pass a context and additional request options.
//
// See GetLexicon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Polly) GetLexiconWithContext(ctx aws.Context, input *GetLexiconInput, opts ...request.Option) (*GetLexiconOutput, error) {
	req, out := c.GetLexiconRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListLexicons = "ListLexicons"

// ListLexiconsRequest generates a "aws/request.Request" representing the
// client's request for the ListLexicons operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLexicons for more information on using the ListLexicons
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListLexiconsRequest method.
//    req, resp := client.ListLexiconsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/ListLexicons
func (c *Polly) ListLexiconsRequest(input *ListLexiconsInput) (req *request.Request, output *ListLexiconsOutput) {
	op := &request.Operation{
		Name:       opListLexicons,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/lexicons",
	}

	if input == nil {
		input = &ListLexiconsInput{}
	}

	output = &ListLexiconsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLexicons API operation for Amazon Polly.
//
// Returns a list of pronunciation lexicons stored in an AWS Region. For more
// information, see Managing Lexicons (http://docs.aws.amazon.com/polly/latest/dg/managing-lexicons.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Polly's
// API operation ListLexicons for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The NextToken is invalid. Verify that it's spelled correctly, and then try
//   again.
//
//   * ErrCodeServiceFailureException "ServiceFailureException"
//   An unknown condition has caused a service failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/ListLexicons
func (c *Polly) ListLexicons(input *ListLexiconsInput) (*ListLexiconsOutput, error) {
	req, out := c.ListLexiconsRequest(input)
	return out, req.Send()
}

// ListLexiconsWithContext is the same as ListLexicons with the addition of
// the ability to pass a context and additional request options.
//
// See ListLexicons for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Polly) ListLexiconsWithContext(ctx aws.Context, input *ListLexiconsInput, opts ...request.Option) (*ListLexiconsOutput, error) {
	req, out := c.ListLexiconsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutLexicon = "PutLexicon"

// PutLexiconRequest generates a "aws/request.Request" representing the
// client's request for the PutLexicon operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutLexicon for more information on using the PutLexicon
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutLexiconRequest method.
//    req, resp := client.PutLexiconRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/PutLexicon
func (c *Polly) PutLexiconRequest(input *PutLexiconInput) (req *request.Request, output *PutLexiconOutput) {
	op := &request.Operation{
		Name:       opPutLexicon,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/lexicons/{LexiconName}",
	}

	if input == nil {
		input = &PutLexiconInput{}
	}

	output = &PutLexiconOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutLexicon API operation for Amazon Polly.
//
// Stores a pronunciation lexicon in an AWS Region. If a lexicon with the same
// name already exists in the region, it is overwritten by the new lexicon.
// Lexicon operations have eventual consistency, therefore, it might take some
// time before the lexicon is available to the SynthesizeSpeech operation.
//
// For more information, see Managing Lexicons (http://docs.aws.amazon.com/polly/latest/dg/managing-lexicons.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Polly's
// API operation PutLexicon for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidLexiconException "InvalidLexiconException"
//   Amazon Polly can't find the specified lexicon. Verify that the lexicon's
//   name is spelled correctly, and then try again.
//
//   * ErrCodeUnsupportedPlsAlphabetException "UnsupportedPlsAlphabetException"
//   The alphabet specified by the lexicon is not a supported alphabet. Valid
//   values are x-sampa and ipa.
//
//   * ErrCodeUnsupportedPlsLanguageException "UnsupportedPlsLanguageException"
//   The language specified in the lexicon is unsupported. For a list of supported
//   languages, see Lexicon Attributes (http://docs.aws.amazon.com/polly/latest/dg/API_LexiconAttributes.html).
//
//   * ErrCodeLexiconSizeExceededException "LexiconSizeExceededException"
//   The maximum size of the specified lexicon would be exceeded by this operation.
//
//   * ErrCodeMaxLexemeLengthExceededException "MaxLexemeLengthExceededException"
//   The maximum size of the lexeme would be exceeded by this operation.
//
//   * ErrCodeMaxLexiconsNumberExceededException "MaxLexiconsNumberExceededException"
//   The maximum number of lexicons would be exceeded by this operation.
//
//   * ErrCodeServiceFailureException "ServiceFailureException"
//   An unknown condition has caused a service failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/PutLexicon
func (c *Polly) PutLexicon(input *PutLexiconInput) (*PutLexiconOutput, error) {
	req, out := c.PutLexiconRequest(input)
	return out, req.Send()
}

// PutLexiconWithContext is the same as PutLexicon with the addition of
// the ability to pass a context and additional request options.
//
// See PutLexicon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Polly) PutLexiconWithContext(ctx aws.Context, input *PutLexiconInput, opts ...request.Option) (*PutLexiconOutput, error) {
	req, out := c.PutLexiconRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSynthesizeSpeech = "SynthesizeSpeech"

// SynthesizeSpeechRequest generates a "aws/request.Request" representing the
// client's request for the SynthesizeSpeech operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SynthesizeSpeech for more information on using the SynthesizeSpeech
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SynthesizeSpeechRequest method.
//    req, resp := client.SynthesizeSpeechRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/SynthesizeSpeech
func (c *Polly) SynthesizeSpeechRequest(input *SynthesizeSpeechInput) (req *request.Request, output *SynthesizeSpeechOutput) {
	op := &request.Operation{
		Name:       opSynthesizeSpeech,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/speech",
	}

	if input == nil {
		input = &SynthesizeSpeechInput{}
	}

	output = &SynthesizeSpeechOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SynthesizeSpeech API operation for Amazon Polly.
//
// Synthesizes UTF-8 input, plain text or SSML, to a stream of bytes. SSML input
// must be valid, well-formed SSML. Some alphabets might not be available with
// all the voices (for example, Cyrillic might not be read at all by English
// voices) unless phoneme mapping is used. For more information, see How it
// Works (http://docs.aws.amazon.com/polly/latest/dg/how-text-to-speech-works.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Polly's
// API operation SynthesizeSpeech for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeTextLengthExceededException "TextLengthExceededException"
//   The value of the "Text" parameter is longer than the accepted limits. The
//   limit for input text is a maximum of 3000 characters total, of which no more
//   than 1500 can be billed characters. SSML tags are not counted as billed characters.
//
//   * ErrCodeInvalidSampleRateException "InvalidSampleRateException"
//   The specified sample rate is not valid.
//
//   * ErrCodeInvalidSsmlException "InvalidSsmlException"
//   The SSML you provided is invalid. Verify the SSML syntax, spelling of tags
//   and values, and then try again.
//
//   * ErrCodeLexiconNotFoundException "LexiconNotFoundException"
//   Amazon Polly can't find the specified lexicon. This could be caused by a
//   lexicon that is missing, its name is misspelled or specifying a lexicon that
//   is in a different region.
//
//   Verify that the lexicon exists, is in the region (see ListLexicons) and that
//   you spelled its name is spelled correctly. Then try again.
//
//   * ErrCodeServiceFailureException "ServiceFailureException"
//   An unknown condition has caused a service failure.
//
//   * ErrCodeMarksNotSupportedForFormatException "MarksNotSupportedForFormatException"
//   Speech marks are not supported for the OutputFormat selected. Speech marks
//   are only available for content in json format.
//
//   * ErrCodeSsmlMarksNotSupportedForTextTypeException "SsmlMarksNotSupportedForTextTypeException"
//   SSML speech marks are not supported for plain text-type input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/SynthesizeSpeech
func (c *Polly) SynthesizeSpeech(input *SynthesizeSpeechInput) (*SynthesizeSpeechOutput, error) {
	req, out := c.SynthesizeSpeechRequest(input)
	return out, req.Send()
}

// SynthesizeSpeechWithContext is the same as SynthesizeSpeech with the addition of
// the ability to pass a context and additional request options.
//
// See SynthesizeSpeech for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Polly) SynthesizeSpeechWithContext(ctx aws.Context, input *SynthesizeSpeechInput, opts ...request.Option) (*SynthesizeSpeechOutput, error) {
	req, out := c.SynthesizeSpeechRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/DeleteLexiconInput
type DeleteLexiconInput struct {
	_ struct{} `type:"structure"`

	// The name of the lexicon to delete. Must be an existing lexicon in the region.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"LexiconName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLexiconInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLexiconInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLexiconInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLexiconInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteLexiconInput) SetName(v string) *DeleteLexiconInput {
	s.Name = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/DeleteLexiconOutput
type DeleteLexiconOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteLexiconOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLexiconOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/DescribeVoicesInput
type DescribeVoicesInput struct {
	_ struct{} `type:"structure"`

	// The language identification tag (ISO 639 code for the language name-ISO 3166
	// country code) for filtering the list of voices returned. If you don't specify
	// this optional parameter, all available voices are returned.
	LanguageCode *string `location:"querystring" locationName:"LanguageCode" type:"string" enum:"LanguageCode"`

	// An opaque pagination token returned from the previous DescribeVoices operation.
	// If present, this indicates where to continue the listing.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s DescribeVoicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVoicesInput) GoString() string {
	return s.String()
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *DescribeVoicesInput) SetLanguageCode(v string) *DescribeVoicesInput {
	s.LanguageCode = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeVoicesInput) SetNextToken(v string) *DescribeVoicesInput {
	s.NextToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/DescribeVoicesOutput
type DescribeVoicesOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use in the next request to continue the listing of
	// voices. NextToken is returned only if the response is truncated.
	NextToken *string `type:"string"`

	// A list of voices with their properties.
	Voices []*Voice `type:"list"`
}

// String returns the string representation
func (s DescribeVoicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVoicesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeVoicesOutput) SetNextToken(v string) *DescribeVoicesOutput {
	s.NextToken = &v
	return s
}

// SetVoices sets the Voices field's value.
func (s *DescribeVoicesOutput) SetVoices(v []*Voice) *DescribeVoicesOutput {
	s.Voices = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/GetLexiconInput
type GetLexiconInput struct {
	_ struct{} `type:"structure"`

	// Name of the lexicon.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"LexiconName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetLexiconInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLexiconInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLexiconInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLexiconInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetLexiconInput) SetName(v string) *GetLexiconInput {
	s.Name = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/GetLexiconOutput
type GetLexiconOutput struct {
	_ struct{} `type:"structure"`

	// Lexicon object that provides name and the string content of the lexicon.
	Lexicon *Lexicon `type:"structure"`

	// Metadata of the lexicon, including phonetic alphabetic used, language code,
	// lexicon ARN, number of lexemes defined in the lexicon, and size of lexicon
	// in bytes.
	LexiconAttributes *LexiconAttributes `type:"structure"`
}

// String returns the string representation
func (s GetLexiconOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLexiconOutput) GoString() string {
	return s.String()
}

// SetLexicon sets the Lexicon field's value.
func (s *GetLexiconOutput) SetLexicon(v *Lexicon) *GetLexiconOutput {
	s.Lexicon = v
	return s
}

// SetLexiconAttributes sets the LexiconAttributes field's value.
func (s *GetLexiconOutput) SetLexiconAttributes(v *LexiconAttributes) *GetLexiconOutput {
	s.LexiconAttributes = v
	return s
}

// Provides lexicon name and lexicon content in string format. For more information,
// see Pronunciation Lexicon Specification (PLS) Version 1.0 (https://www.w3.org/TR/pronunciation-lexicon/).
// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/Lexicon
type Lexicon struct {
	_ struct{} `type:"structure"`

	// Lexicon content in string format. The content of a lexicon must be in PLS
	// format.
	Content *string `type:"string"`

	// Name of the lexicon.
	Name *string `type:"string"`
}

// String returns the string representation
func (s Lexicon) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Lexicon) GoString() string {
	return s.String()
}

// SetContent sets the Content field's value.
func (s *Lexicon) SetContent(v string) *Lexicon {
	s.Content = &v
	return s
}

// SetName sets the Name field's value.
func (s *Lexicon) SetName(v string) *Lexicon {
	s.Name = &v
	return s
}

// Contains metadata describing the lexicon such as the number of lexemes, language
// code, and so on. For more information, see Managing Lexicons (http://docs.aws.amazon.com/polly/latest/dg/managing-lexicons.html).
// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/LexiconAttributes
type LexiconAttributes struct {
	_ struct{} `type:"structure"`

	// Phonetic alphabet used in the lexicon. Valid values are ipa and x-sampa.
	Alphabet *string `type:"string"`

	// Language code that the lexicon applies to. A lexicon with a language code
	// such as "en" would be applied to all English languages (en-GB, en-US, en-AUS,
	// en-WLS, and so on.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// Date lexicon was last modified (a timestamp value).
	LastModified *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Number of lexemes in the lexicon.
	LexemesCount *int64 `type:"integer"`

	// Amazon Resource Name (ARN) of the lexicon.
	LexiconArn *string `type:"string"`

	// Total size of the lexicon, in characters.
	Size *int64 `type:"integer"`
}

// String returns the string representation
func (s LexiconAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LexiconAttributes) GoString() string {
	return s.String()
}

// SetAlphabet sets the Alphabet field's value.
func (s *LexiconAttributes) SetAlphabet(v string) *LexiconAttributes {
	s.Alphabet = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *LexiconAttributes) SetLanguageCode(v string) *LexiconAttributes {
	s.LanguageCode = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *LexiconAttributes) SetLastModified(v time.Time) *LexiconAttributes {
	s.LastModified = &v
	return s
}

// SetLexemesCount sets the LexemesCount field's value.
func (s *LexiconAttributes) SetLexemesCount(v int64) *LexiconAttributes {
	s.LexemesCount = &v
	return s
}

// SetLexiconArn sets the LexiconArn field's value.
func (s *LexiconAttributes) SetLexiconArn(v string) *LexiconAttributes {
	s.LexiconArn = &v
	return s
}

// SetSize sets the Size field's value.
func (s *LexiconAttributes) SetSize(v int64) *LexiconAttributes {
	s.Size = &v
	return s
}

// Describes the content of the lexicon.
// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/LexiconDescription
type LexiconDescription struct {
	_ struct{} `type:"structure"`

	// Provides lexicon metadata.
	Attributes *LexiconAttributes `type:"structure"`

	// Name of the lexicon.
	Name *string `type:"string"`
}

// String returns the string representation
func (s LexiconDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LexiconDescription) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *LexiconDescription) SetAttributes(v *LexiconAttributes) *LexiconDescription {
	s.Attributes = v
	return s
}

// SetName sets the Name field's value.
func (s *LexiconDescription) SetName(v string) *LexiconDescription {
	s.Name = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/ListLexiconsInput
type ListLexiconsInput struct {
	_ struct{} `type:"structure"`

	// An opaque pagination token returned from previous ListLexicons operation.
	// If present, indicates where to continue the list of lexicons.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListLexiconsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLexiconsInput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListLexiconsInput) SetNextToken(v string) *ListLexiconsInput {
	s.NextToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/ListLexiconsOutput
type ListLexiconsOutput struct {
	_ struct{} `type:"structure"`

	// A list of lexicon names and attributes.
	Lexicons []*LexiconDescription `type:"list"`

	// The pagination token to use in the next request to continue the listing of
	// lexicons. NextToken is returned only if the response is truncated.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListLexiconsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLexiconsOutput) GoString() string {
	return s.String()
}

// SetLexicons sets the Lexicons field's value.
func (s *ListLexiconsOutput) SetLexicons(v []*LexiconDescription) *ListLexiconsOutput {
	s.Lexicons = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLexiconsOutput) SetNextToken(v string) *ListLexiconsOutput {
	s.NextToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/PutLexiconInput
type PutLexiconInput struct {
	_ struct{} `type:"structure"`

	// Content of the PLS lexicon as string data.
	//
	// Content is a required field
	Content *string `type:"string" required:"true"`

	// Name of the lexicon. The name must follow the regular express format [0-9A-Za-z]{1,20}.
	// That is, the name is a case-sensitive alphanumeric string up to 20 characters
	// long.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"LexiconName" type:"string" required:"true"`
}

// String returns the string representation
func (s PutLexiconInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutLexiconInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutLexiconInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutLexiconInput"}
	if s.Content == nil {
		invalidParams.Add(request.NewErrParamRequired("Content"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContent sets the Content field's value.
func (s *PutLexiconInput) SetContent(v string) *PutLexiconInput {
	s.Content = &v
	return s
}

// SetName sets the Name field's value.
func (s *PutLexiconInput) SetName(v string) *PutLexiconInput {
	s.Name = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/PutLexiconOutput
type PutLexiconOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutLexiconOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutLexiconOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/SynthesizeSpeechInput
type SynthesizeSpeechInput struct {
	_ struct{} `type:"structure"`

	// List of one or more pronunciation lexicon names you want the service to apply
	// during synthesis. Lexicons are applied only if the language of the lexicon
	// is the same as the language of the voice. For information about storing lexicons,
	// see PutLexicon (http://docs.aws.amazon.com/polly/latest/dg/API_PutLexicon.html).
	LexiconNames []*string `type:"list"`

	// The format in which the returned output will be encoded. For audio stream,
	// this will be mp3, ogg_vorbis, or pcm. For speech marks, this will be json.
	//
	// OutputFormat is a required field
	OutputFormat *string `type:"string" required:"true" enum:"OutputFormat"`

	// The audio frequency specified in Hz.
	//
	// The valid values for mp3 and ogg_vorbis are "8000", "16000", and "22050".
	// The default value is "22050".
	//
	// Valid values for pcm are "8000" and "16000" The default value is "16000".
	SampleRate *string `type:"string"`

	// The type of speech marks returned for the input text.
	SpeechMarkTypes []*string `type:"list"`

	// Input text to synthesize. If you specify ssml as the TextType, follow the
	// SSML format for the input text.
	//
	// Text is a required field
	Text *string `type:"string" required:"true"`

	// Specifies whether the input text is plain text or SSML. The default value
	// is plain text. For more information, see Using SSML (http://docs.aws.amazon.com/polly/latest/dg/ssml.html).
	TextType *string `type:"string" enum:"TextType"`

	// Voice ID to use for the synthesis. You can get a list of available voice
	// IDs by calling the DescribeVoices (http://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html)
	// operation.
	//
	// VoiceId is a required field
	VoiceId *string `type:"string" required:"true" enum:"VoiceId"`
}

// String returns the string representation
func (s SynthesizeSpeechInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SynthesizeSpeechInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SynthesizeSpeechInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SynthesizeSpeechInput"}
	if s.OutputFormat == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputFormat"))
	}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.VoiceId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLexiconNames sets the LexiconNames field's value.
func (s *SynthesizeSpeechInput) SetLexiconNames(v []*string) *SynthesizeSpeechInput {
	s.LexiconNames = v
	return s
}

// SetOutputFormat sets the OutputFormat field's value.
func (s *SynthesizeSpeechInput) SetOutputFormat(v string) *SynthesizeSpeechInput {
	s.OutputFormat = &v
	return s
}

// SetSampleRate sets the SampleRate field's value.
func (s *SynthesizeSpeechInput) SetSampleRate(v string) *SynthesizeSpeechInput {
	s.SampleRate = &v
	return s
}

// SetSpeechMarkTypes sets the SpeechMarkTypes field's value.
func (s *SynthesizeSpeechInput) SetSpeechMarkTypes(v []*string) *SynthesizeSpeechInput {
	s.SpeechMarkTypes = v
	return s
}

// SetText sets the Text field's value.
func (s *SynthesizeSpeechInput) SetText(v string) *SynthesizeSpeechInput {
	s.Text = &v
	return s
}

// SetTextType sets the TextType field's value.
func (s *SynthesizeSpeechInput) SetTextType(v string) *SynthesizeSpeechInput {
	s.TextType = &v
	return s
}

// SetVoiceId sets the VoiceId field's value.
func (s *SynthesizeSpeechInput) SetVoiceId(v string) *SynthesizeSpeechInput {
	s.VoiceId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/SynthesizeSpeechOutput
type SynthesizeSpeechOutput struct {
	_ struct{} `type:"structure" payload:"AudioStream"`

	// Stream containing the synthesized speech.
	AudioStream io.ReadCloser `type:"blob"`

	// Specifies the type audio stream. This should reflect the OutputFormat parameter
	// in your request.
	//
	//    *  If you request mp3 as the OutputFormat, the ContentType returned is
	//    audio/mpeg.
	//
	//    *  If you request ogg_vorbis as the OutputFormat, the ContentType returned
	//    is audio/ogg.
	//
	//    *  If you request pcm as the OutputFormat, the ContentType returned is
	//    audio/pcm in a signed 16-bit, 1 channel (mono), little-endian format.
	//
	//
	//    * If you request json as the OutputFormat, the ContentType returned is
	//    audio/json.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`

	// Number of characters synthesized.
	RequestCharacters *int64 `location:"header" locationName:"x-amzn-RequestCharacters" type:"integer"`
}

// String returns the string representation
func (s SynthesizeSpeechOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SynthesizeSpeechOutput) GoString() string {
	return s.String()
}

// SetAudioStream sets the AudioStream field's value.
func (s *SynthesizeSpeechOutput) SetAudioStream(v io.ReadCloser) *SynthesizeSpeechOutput {
	s.AudioStream = v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *SynthesizeSpeechOutput) SetContentType(v string) *SynthesizeSpeechOutput {
	s.ContentType = &v
	return s
}

// SetRequestCharacters sets the RequestCharacters field's value.
func (s *SynthesizeSpeechOutput) SetRequestCharacters(v int64) *SynthesizeSpeechOutput {
	s.RequestCharacters = &v
	return s
}

// Description of the voice.
// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/Voice
type Voice struct {
	_ struct{} `type:"structure"`

	// Gender of the voice.
	Gender *string `type:"string" enum:"Gender"`

	// Amazon Polly assigned voice ID. This is the ID that you specify when calling
	// the SynthesizeSpeech operation.
	Id *string `type:"string" enum:"VoiceId"`

	// Language code of the voice.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// Human readable name of the language in English.
	LanguageName *string `type:"string"`

	// Name of the voice (for example, Salli, Kendra, etc.). This provides a human
	// readable voice name that you might display in your application.
	Name *string `type:"string"`
}

// String returns the string representation
func (s Voice) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Voice) GoString() string {
	return s.String()
}

// SetGender sets the Gender field's value.
func (s *Voice) SetGender(v string) *Voice {
	s.Gender = &v
	return s
}

// SetId sets the Id field's value.
func (s *Voice) SetId(v string) *Voice {
	s.Id = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *Voice) SetLanguageCode(v string) *Voice {
	s.LanguageCode = &v
	return s
}

// SetLanguageName sets the LanguageName field's value.
func (s *Voice) SetLanguageName(v string) *Voice {
	s.LanguageName = &v
	return s
}

// SetName sets the Name field's value.
func (s *Voice) SetName(v string) *Voice {
	s.Name = &v
	return s
}

const (
	// GenderFemale is a Gender enum value
	GenderFemale = "Female"

	// GenderMale is a Gender enum value
	GenderMale = "Male"
)

const (
	// LanguageCodeCyGb is a LanguageCode enum value
	LanguageCodeCyGb = "cy-GB"

	// LanguageCodeDaDk is a LanguageCode enum value
	LanguageCodeDaDk = "da-DK"

	// LanguageCodeDeDe is a LanguageCode enum value
	LanguageCodeDeDe = "de-DE"

	// LanguageCodeEnAu is a LanguageCode enum value
	LanguageCodeEnAu = "en-AU"

	// LanguageCodeEnGb is a LanguageCode enum value
	LanguageCodeEnGb = "en-GB"

	// LanguageCodeEnGbWls is a LanguageCode enum value
	LanguageCodeEnGbWls = "en-GB-WLS"

	// LanguageCodeEnIn is a LanguageCode enum value
	LanguageCodeEnIn = "en-IN"

	// LanguageCodeEnUs is a LanguageCode enum value
	LanguageCodeEnUs = "en-US"

	// LanguageCodeEsEs is a LanguageCode enum value
	LanguageCodeEsEs = "es-ES"

	// LanguageCodeEsUs is a LanguageCode enum value
	LanguageCodeEsUs = "es-US"

	// LanguageCodeFrCa is a LanguageCode enum value
	LanguageCodeFrCa = "fr-CA"

	// LanguageCodeFrFr is a LanguageCode enum value
	LanguageCodeFrFr = "fr-FR"

	// LanguageCodeIsIs is a LanguageCode enum value
	LanguageCodeIsIs = "is-IS"

	// LanguageCodeItIt is a LanguageCode enum value
	LanguageCodeItIt = "it-IT"

	// LanguageCodeKoKr is a LanguageCode enum value
	LanguageCodeKoKr = "ko-KR"

	// LanguageCodeJaJp is a LanguageCode enum value
	LanguageCodeJaJp = "ja-JP"

	// LanguageCodeNbNo is a LanguageCode enum value
	LanguageCodeNbNo = "nb-NO"

	// LanguageCodeNlNl is a LanguageCode enum value
	LanguageCodeNlNl = "nl-NL"

	// LanguageCodePlPl is a LanguageCode enum value
	LanguageCodePlPl = "pl-PL"

	// LanguageCodePtBr is a LanguageCode enum value
	LanguageCodePtBr = "pt-BR"

	// LanguageCodePtPt is a LanguageCode enum value
	LanguageCodePtPt = "pt-PT"

	// LanguageCodeRoRo is a LanguageCode enum value
	LanguageCodeRoRo = "ro-RO"

	// LanguageCodeRuRu is a LanguageCode enum value
	LanguageCodeRuRu = "ru-RU"

	// LanguageCodeSvSe is a LanguageCode enum value
	LanguageCodeSvSe = "sv-SE"

	// LanguageCodeTrTr is a LanguageCode enum value
	LanguageCodeTrTr = "tr-TR"
)

const (
	// OutputFormatJson is a OutputFormat enum value
	OutputFormatJson = "json"

	// OutputFormatMp3 is a OutputFormat enum value
	OutputFormatMp3 = "mp3"

	// OutputFormatOggVorbis is a OutputFormat enum value
	OutputFormatOggVorbis = "ogg_vorbis"

	// OutputFormatPcm is a OutputFormat enum value
	OutputFormatPcm = "pcm"
)

const (
	// SpeechMarkTypeSentence is a SpeechMarkType enum value
	SpeechMarkTypeSentence = "sentence"

	// SpeechMarkTypeSsml is a SpeechMarkType enum value
	SpeechMarkTypeSsml = "ssml"

	// SpeechMarkTypeViseme is a SpeechMarkType enum value
	SpeechMarkTypeViseme = "viseme"

	// SpeechMarkTypeWord is a SpeechMarkType enum value
	SpeechMarkTypeWord = "word"
)

const (
	// TextTypeSsml is a TextType enum value
	TextTypeSsml = "ssml"

	// TextTypeText is a TextType enum value
	TextTypeText = "text"
)

const (
	// VoiceIdGeraint is a VoiceId enum value
	VoiceIdGeraint = "Geraint"

	// VoiceIdGwyneth is a VoiceId enum value
	VoiceIdGwyneth = "Gwyneth"

	// VoiceIdMads is a VoiceId enum value
	VoiceIdMads = "Mads"

	// VoiceIdNaja is a VoiceId enum value
	VoiceIdNaja = "Naja"

	// VoiceIdHans is a VoiceId enum value
	VoiceIdHans = "Hans"

	// VoiceIdMarlene is a VoiceId enum value
	VoiceIdMarlene = "Marlene"

	// VoiceIdNicole is a VoiceId enum value
	VoiceIdNicole = "Nicole"

	// VoiceIdRussell is a VoiceId enum value
	VoiceIdRussell = "Russell"

	// VoiceIdAmy is a VoiceId enum value
	VoiceIdAmy = "Amy"

	// VoiceIdBrian is a VoiceId enum value
	VoiceIdBrian = "Brian"

	// VoiceIdEmma is a VoiceId enum value
	VoiceIdEmma = "Emma"

	// VoiceIdRaveena is a VoiceId enum value
	VoiceIdRaveena = "Raveena"

	// VoiceIdIvy is a VoiceId enum value
	VoiceIdIvy = "Ivy"

	// VoiceIdJoanna is a VoiceId enum value
	VoiceIdJoanna = "Joanna"

	// VoiceIdJoey is a VoiceId enum value
	VoiceIdJoey = "Joey"

	// VoiceIdJustin is a VoiceId enum value
	VoiceIdJustin = "Justin"

	// VoiceIdKendra is a VoiceId enum value
	VoiceIdKendra = "Kendra"

	// VoiceIdKimberly is a VoiceId enum value
	VoiceIdKimberly = "Kimberly"

	// VoiceIdMatthew is a VoiceId enum value
	VoiceIdMatthew = "Matthew"

	// VoiceIdSalli is a VoiceId enum value
	VoiceIdSalli = "Salli"

	// VoiceIdConchita is a VoiceId enum value
	VoiceIdConchita = "Conchita"

	// VoiceIdEnrique is a VoiceId enum value
	VoiceIdEnrique = "Enrique"

	// VoiceIdMiguel is a VoiceId enum value
	VoiceIdMiguel = "Miguel"

	// VoiceIdPenelope is a VoiceId enum value
	VoiceIdPenelope = "Penelope"

	// VoiceIdChantal is a VoiceId enum value
	VoiceIdChantal = "Chantal"

	// VoiceIdCeline is a VoiceId enum value
	VoiceIdCeline = "Celine"

	// VoiceIdMathieu is a VoiceId enum value
	VoiceIdMathieu = "Mathieu"

	// VoiceIdDora is a VoiceId enum value
	VoiceIdDora = "Dora"

	// VoiceIdKarl is a VoiceId enum value
	VoiceIdKarl = "Karl"

	// VoiceIdCarla is a VoiceId enum value
	VoiceIdCarla = "Carla"

	// VoiceIdGiorgio is a VoiceId enum value
	VoiceIdGiorgio = "Giorgio"

	// VoiceIdMizuki is a VoiceId enum value
	VoiceIdMizuki = "Mizuki"

	// VoiceIdLiv is a VoiceId enum value
	VoiceIdLiv = "Liv"

	// VoiceIdLotte is a VoiceId enum value
	VoiceIdLotte = "Lotte"

	// VoiceIdRuben is a VoiceId enum value
	VoiceIdRuben = "Ruben"

	// VoiceIdEwa is a VoiceId enum value
	VoiceIdEwa = "Ewa"

	// VoiceIdJacek is a VoiceId enum value
	VoiceIdJacek = "Jacek"

	// VoiceIdJan is a VoiceId enum value
	VoiceIdJan = "Jan"

	// VoiceIdMaja is a VoiceId enum value
	VoiceIdMaja = "Maja"

	// VoiceIdRicardo is a VoiceId enum value
	VoiceIdRicardo = "Ricardo"

	// VoiceIdVitoria is a VoiceId enum value
	VoiceIdVitoria = "Vitoria"

	// VoiceIdCristiano is a VoiceId enum value
	VoiceIdCristiano = "Cristiano"

	// VoiceIdInes is a VoiceId enum value
	VoiceIdInes = "Ines"

	// VoiceIdCarmen is a VoiceId enum value
	VoiceIdCarmen = "Carmen"

	// VoiceIdMaxim is a VoiceId enum value
	VoiceIdMaxim = "Maxim"

	// VoiceIdTatyana is a VoiceId enum value
	VoiceIdTatyana = "Tatyana"

	// VoiceIdAstrid is a VoiceId enum value
	VoiceIdAstrid = "Astrid"

	// VoiceIdFiliz is a VoiceId enum value
	VoiceIdFiliz = "Filiz"

	// VoiceIdVicki is a VoiceId enum value
	VoiceIdVicki = "Vicki"

	// VoiceIdTakumi is a VoiceId enum value
	VoiceIdTakumi = "Takumi"

	// VoiceIdSeoyeon is a VoiceId enum value
	VoiceIdSeoyeon = "Seoyeon"

	// VoiceIdAditi is a VoiceId enum value
	VoiceIdAditi = "Aditi"
)
