package web

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/validation"
	"net/http"
)

// DiagnosticsClient is the webSite Management Client
type DiagnosticsClient struct {
	BaseClient
}

// NewDiagnosticsClient creates an instance of the DiagnosticsClient client.
func NewDiagnosticsClient(subscriptionID string) DiagnosticsClient {
	return NewDiagnosticsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewDiagnosticsClientWithBaseURI creates an instance of the DiagnosticsClient client.
func NewDiagnosticsClientWithBaseURI(baseURI string, subscriptionID string) DiagnosticsClient {
	return DiagnosticsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// ExecuteSiteAnalysis execute Analysis
//
// resourceGroupName is name of the resource group to which the resource belongs. siteName is site Name
// diagnosticCategory is category Name analysisName is analysis Resource Name startTime is start Time endTime is end
// Time timeGrain is time Grain
func (client DiagnosticsClient) ExecuteSiteAnalysis(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, analysisName string, startTime *date.Time, endTime *date.Time, timeGrain string) (result DiagnosticAnalysis, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: timeGrain,
			Constraints: []validation.Constraint{{Target: "timeGrain", Name: validation.Pattern, Rule: `PT[1-9][0-9]+[SMH]`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.DiagnosticsClient", "ExecuteSiteAnalysis")
	}

	req, err := client.ExecuteSiteAnalysisPreparer(ctx, resourceGroupName, siteName, diagnosticCategory, analysisName, startTime, endTime, timeGrain)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ExecuteSiteAnalysis", nil, "Failure preparing request")
		return
	}

	resp, err := client.ExecuteSiteAnalysisSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ExecuteSiteAnalysis", resp, "Failure sending request")
		return
	}

	result, err = client.ExecuteSiteAnalysisResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ExecuteSiteAnalysis", resp, "Failure responding to request")
	}

	return
}

// ExecuteSiteAnalysisPreparer prepares the ExecuteSiteAnalysis request.
func (client DiagnosticsClient) ExecuteSiteAnalysisPreparer(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, analysisName string, startTime *date.Time, endTime *date.Time, timeGrain string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"analysisName":       autorest.Encode("path", analysisName),
		"diagnosticCategory": autorest.Encode("path", diagnosticCategory),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"siteName":           autorest.Encode("path", siteName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-03-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if startTime != nil {
		queryParameters["startTime"] = autorest.Encode("query", *startTime)
	}
	if endTime != nil {
		queryParameters["endTime"] = autorest.Encode("query", *endTime)
	}
	if len(timeGrain) > 0 {
		queryParameters["timeGrain"] = autorest.Encode("query", timeGrain)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/analyses/{analysisName}/execute", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ExecuteSiteAnalysisSender sends the ExecuteSiteAnalysis request. The method will close the
// http.Response Body if it receives an error.
func (client DiagnosticsClient) ExecuteSiteAnalysisSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ExecuteSiteAnalysisResponder handles the response to the ExecuteSiteAnalysis request. The method always
// closes the http.Response Body.
func (client DiagnosticsClient) ExecuteSiteAnalysisResponder(resp *http.Response) (result DiagnosticAnalysis, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ExecuteSiteAnalysisSlot execute Analysis
//
// resourceGroupName is name of the resource group to which the resource belongs. siteName is site Name
// diagnosticCategory is category Name analysisName is analysis Resource Name slot is slot Name startTime is start Time
// endTime is end Time timeGrain is time Grain
func (client DiagnosticsClient) ExecuteSiteAnalysisSlot(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, analysisName string, slot string, startTime *date.Time, endTime *date.Time, timeGrain string) (result DiagnosticAnalysis, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: timeGrain,
			Constraints: []validation.Constraint{{Target: "timeGrain", Name: validation.Pattern, Rule: `PT[1-9][0-9]+[SMH]`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.DiagnosticsClient", "ExecuteSiteAnalysisSlot")
	}

	req, err := client.ExecuteSiteAnalysisSlotPreparer(ctx, resourceGroupName, siteName, diagnosticCategory, analysisName, slot, startTime, endTime, timeGrain)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ExecuteSiteAnalysisSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ExecuteSiteAnalysisSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ExecuteSiteAnalysisSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ExecuteSiteAnalysisSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ExecuteSiteAnalysisSlot", resp, "Failure responding to request")
	}

	return
}

// ExecuteSiteAnalysisSlotPreparer prepares the ExecuteSiteAnalysisSlot request.
func (client DiagnosticsClient) ExecuteSiteAnalysisSlotPreparer(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, analysisName string, slot string, startTime *date.Time, endTime *date.Time, timeGrain string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"analysisName":       autorest.Encode("path", analysisName),
		"diagnosticCategory": autorest.Encode("path", diagnosticCategory),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"siteName":           autorest.Encode("path", siteName),
		"slot":               autorest.Encode("path", slot),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-03-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if startTime != nil {
		queryParameters["startTime"] = autorest.Encode("query", *startTime)
	}
	if endTime != nil {
		queryParameters["endTime"] = autorest.Encode("query", *endTime)
	}
	if len(timeGrain) > 0 {
		queryParameters["timeGrain"] = autorest.Encode("query", timeGrain)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/analyses/{analysisName}/execute", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ExecuteSiteAnalysisSlotSender sends the ExecuteSiteAnalysisSlot request. The method will close the
// http.Response Body if it receives an error.
func (client DiagnosticsClient) ExecuteSiteAnalysisSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ExecuteSiteAnalysisSlotResponder handles the response to the ExecuteSiteAnalysisSlot request. The method always
// closes the http.Response Body.
func (client DiagnosticsClient) ExecuteSiteAnalysisSlotResponder(resp *http.Response) (result DiagnosticAnalysis, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ExecuteSiteDetector execute Detector
//
// resourceGroupName is name of the resource group to which the resource belongs. siteName is site Name detectorName is
// detector Resource Name diagnosticCategory is category Name startTime is start Time endTime is end Time timeGrain is
// time Grain
func (client DiagnosticsClient) ExecuteSiteDetector(ctx context.Context, resourceGroupName string, siteName string, detectorName string, diagnosticCategory string, startTime *date.Time, endTime *date.Time, timeGrain string) (result DiagnosticDetectorResponse, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: timeGrain,
			Constraints: []validation.Constraint{{Target: "timeGrain", Name: validation.Pattern, Rule: `PT[1-9][0-9]+[SMH]`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.DiagnosticsClient", "ExecuteSiteDetector")
	}

	req, err := client.ExecuteSiteDetectorPreparer(ctx, resourceGroupName, siteName, detectorName, diagnosticCategory, startTime, endTime, timeGrain)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ExecuteSiteDetector", nil, "Failure preparing request")
		return
	}

	resp, err := client.ExecuteSiteDetectorSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ExecuteSiteDetector", resp, "Failure sending request")
		return
	}

	result, err = client.ExecuteSiteDetectorResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ExecuteSiteDetector", resp, "Failure responding to request")
	}

	return
}

// ExecuteSiteDetectorPreparer prepares the ExecuteSiteDetector request.
func (client DiagnosticsClient) ExecuteSiteDetectorPreparer(ctx context.Context, resourceGroupName string, siteName string, detectorName string, diagnosticCategory string, startTime *date.Time, endTime *date.Time, timeGrain string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"detectorName":       autorest.Encode("path", detectorName),
		"diagnosticCategory": autorest.Encode("path", diagnosticCategory),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"siteName":           autorest.Encode("path", siteName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-03-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if startTime != nil {
		queryParameters["startTime"] = autorest.Encode("query", *startTime)
	}
	if endTime != nil {
		queryParameters["endTime"] = autorest.Encode("query", *endTime)
	}
	if len(timeGrain) > 0 {
		queryParameters["timeGrain"] = autorest.Encode("query", timeGrain)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/detectors/{detectorName}/execute", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ExecuteSiteDetectorSender sends the ExecuteSiteDetector request. The method will close the
// http.Response Body if it receives an error.
func (client DiagnosticsClient) ExecuteSiteDetectorSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ExecuteSiteDetectorResponder handles the response to the ExecuteSiteDetector request. The method always
// closes the http.Response Body.
func (client DiagnosticsClient) ExecuteSiteDetectorResponder(resp *http.Response) (result DiagnosticDetectorResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ExecuteSiteDetectorSlot execute Detector
//
// resourceGroupName is name of the resource group to which the resource belongs. siteName is site Name detectorName is
// detector Resource Name diagnosticCategory is category Name slot is slot Name startTime is start Time endTime is end
// Time timeGrain is time Grain
func (client DiagnosticsClient) ExecuteSiteDetectorSlot(ctx context.Context, resourceGroupName string, siteName string, detectorName string, diagnosticCategory string, slot string, startTime *date.Time, endTime *date.Time, timeGrain string) (result DiagnosticDetectorResponse, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: timeGrain,
			Constraints: []validation.Constraint{{Target: "timeGrain", Name: validation.Pattern, Rule: `PT[1-9][0-9]+[SMH]`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.DiagnosticsClient", "ExecuteSiteDetectorSlot")
	}

	req, err := client.ExecuteSiteDetectorSlotPreparer(ctx, resourceGroupName, siteName, detectorName, diagnosticCategory, slot, startTime, endTime, timeGrain)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ExecuteSiteDetectorSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ExecuteSiteDetectorSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ExecuteSiteDetectorSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ExecuteSiteDetectorSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ExecuteSiteDetectorSlot", resp, "Failure responding to request")
	}

	return
}

// ExecuteSiteDetectorSlotPreparer prepares the ExecuteSiteDetectorSlot request.
func (client DiagnosticsClient) ExecuteSiteDetectorSlotPreparer(ctx context.Context, resourceGroupName string, siteName string, detectorName string, diagnosticCategory string, slot string, startTime *date.Time, endTime *date.Time, timeGrain string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"detectorName":       autorest.Encode("path", detectorName),
		"diagnosticCategory": autorest.Encode("path", diagnosticCategory),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"siteName":           autorest.Encode("path", siteName),
		"slot":               autorest.Encode("path", slot),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-03-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if startTime != nil {
		queryParameters["startTime"] = autorest.Encode("query", *startTime)
	}
	if endTime != nil {
		queryParameters["endTime"] = autorest.Encode("query", *endTime)
	}
	if len(timeGrain) > 0 {
		queryParameters["timeGrain"] = autorest.Encode("query", timeGrain)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/detectors/{detectorName}/execute", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ExecuteSiteDetectorSlotSender sends the ExecuteSiteDetectorSlot request. The method will close the
// http.Response Body if it receives an error.
func (client DiagnosticsClient) ExecuteSiteDetectorSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ExecuteSiteDetectorSlotResponder handles the response to the ExecuteSiteDetectorSlot request. The method always
// closes the http.Response Body.
func (client DiagnosticsClient) ExecuteSiteDetectorSlotResponder(resp *http.Response) (result DiagnosticDetectorResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteAnalysis get Site Analysis
//
// resourceGroupName is name of the resource group to which the resource belongs. siteName is site Name
// diagnosticCategory is diagnostic Category analysisName is analysis Name
func (client DiagnosticsClient) GetSiteAnalysis(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, analysisName string) (result DiagnosticAnalysis, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.DiagnosticsClient", "GetSiteAnalysis")
	}

	req, err := client.GetSiteAnalysisPreparer(ctx, resourceGroupName, siteName, diagnosticCategory, analysisName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "GetSiteAnalysis", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteAnalysisSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "GetSiteAnalysis", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteAnalysisResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "GetSiteAnalysis", resp, "Failure responding to request")
	}

	return
}

// GetSiteAnalysisPreparer prepares the GetSiteAnalysis request.
func (client DiagnosticsClient) GetSiteAnalysisPreparer(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, analysisName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"analysisName":       autorest.Encode("path", analysisName),
		"diagnosticCategory": autorest.Encode("path", diagnosticCategory),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"siteName":           autorest.Encode("path", siteName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-03-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/analyses/{analysisName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteAnalysisSender sends the GetSiteAnalysis request. The method will close the
// http.Response Body if it receives an error.
func (client DiagnosticsClient) GetSiteAnalysisSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetSiteAnalysisResponder handles the response to the GetSiteAnalysis request. The method always
// closes the http.Response Body.
func (client DiagnosticsClient) GetSiteAnalysisResponder(resp *http.Response) (result DiagnosticAnalysis, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteAnalysisSlot get Site Analysis
//
// resourceGroupName is name of the resource group to which the resource belongs. siteName is site Name
// diagnosticCategory is diagnostic Category analysisName is analysis Name slot is slot - optional
func (client DiagnosticsClient) GetSiteAnalysisSlot(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, analysisName string, slot string) (result DiagnosticAnalysis, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.DiagnosticsClient", "GetSiteAnalysisSlot")
	}

	req, err := client.GetSiteAnalysisSlotPreparer(ctx, resourceGroupName, siteName, diagnosticCategory, analysisName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "GetSiteAnalysisSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteAnalysisSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "GetSiteAnalysisSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteAnalysisSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "GetSiteAnalysisSlot", resp, "Failure responding to request")
	}

	return
}

// GetSiteAnalysisSlotPreparer prepares the GetSiteAnalysisSlot request.
func (client DiagnosticsClient) GetSiteAnalysisSlotPreparer(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, analysisName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"analysisName":       autorest.Encode("path", analysisName),
		"diagnosticCategory": autorest.Encode("path", diagnosticCategory),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"siteName":           autorest.Encode("path", siteName),
		"slot":               autorest.Encode("path", slot),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-03-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/analyses/{analysisName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteAnalysisSlotSender sends the GetSiteAnalysisSlot request. The method will close the
// http.Response Body if it receives an error.
func (client DiagnosticsClient) GetSiteAnalysisSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetSiteAnalysisSlotResponder handles the response to the GetSiteAnalysisSlot request. The method always
// closes the http.Response Body.
func (client DiagnosticsClient) GetSiteAnalysisSlotResponder(resp *http.Response) (result DiagnosticAnalysis, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteDetector get Detector
//
// resourceGroupName is name of the resource group to which the resource belongs. siteName is site Name
// diagnosticCategory is diagnostic Category detectorName is detector Name
func (client DiagnosticsClient) GetSiteDetector(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, detectorName string) (result DiagnosticDetectorCollectionPage, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.DiagnosticsClient", "GetSiteDetector")
	}

	result.fn = client.getSiteDetectorNextResults
	req, err := client.GetSiteDetectorPreparer(ctx, resourceGroupName, siteName, diagnosticCategory, detectorName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "GetSiteDetector", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteDetectorSender(req)
	if err != nil {
		result.ddc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "GetSiteDetector", resp, "Failure sending request")
		return
	}

	result.ddc, err = client.GetSiteDetectorResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "GetSiteDetector", resp, "Failure responding to request")
	}

	return
}

// GetSiteDetectorPreparer prepares the GetSiteDetector request.
func (client DiagnosticsClient) GetSiteDetectorPreparer(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, detectorName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"detectorName":       autorest.Encode("path", detectorName),
		"diagnosticCategory": autorest.Encode("path", diagnosticCategory),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"siteName":           autorest.Encode("path", siteName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-03-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/detectors/{detectorName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteDetectorSender sends the GetSiteDetector request. The method will close the
// http.Response Body if it receives an error.
func (client DiagnosticsClient) GetSiteDetectorSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetSiteDetectorResponder handles the response to the GetSiteDetector request. The method always
// closes the http.Response Body.
func (client DiagnosticsClient) GetSiteDetectorResponder(resp *http.Response) (result DiagnosticDetectorCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getSiteDetectorNextResults retrieves the next set of results, if any.
func (client DiagnosticsClient) getSiteDetectorNextResults(lastResults DiagnosticDetectorCollection) (result DiagnosticDetectorCollection, err error) {
	req, err := lastResults.diagnosticDetectorCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.DiagnosticsClient", "getSiteDetectorNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetSiteDetectorSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.DiagnosticsClient", "getSiteDetectorNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetSiteDetectorResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "getSiteDetectorNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetSiteDetectorComplete enumerates all values, automatically crossing page boundaries as required.
func (client DiagnosticsClient) GetSiteDetectorComplete(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, detectorName string) (result DiagnosticDetectorCollectionIterator, err error) {
	result.page, err = client.GetSiteDetector(ctx, resourceGroupName, siteName, diagnosticCategory, detectorName)
	return
}

// GetSiteDetectorSlot get Detector
//
// resourceGroupName is name of the resource group to which the resource belongs. siteName is site Name
// diagnosticCategory is diagnostic Category detectorName is detector Name slot is slot Name
func (client DiagnosticsClient) GetSiteDetectorSlot(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, detectorName string, slot string) (result DiagnosticDetectorCollectionPage, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.DiagnosticsClient", "GetSiteDetectorSlot")
	}

	result.fn = client.getSiteDetectorSlotNextResults
	req, err := client.GetSiteDetectorSlotPreparer(ctx, resourceGroupName, siteName, diagnosticCategory, detectorName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "GetSiteDetectorSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteDetectorSlotSender(req)
	if err != nil {
		result.ddc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "GetSiteDetectorSlot", resp, "Failure sending request")
		return
	}

	result.ddc, err = client.GetSiteDetectorSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "GetSiteDetectorSlot", resp, "Failure responding to request")
	}

	return
}

// GetSiteDetectorSlotPreparer prepares the GetSiteDetectorSlot request.
func (client DiagnosticsClient) GetSiteDetectorSlotPreparer(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, detectorName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"detectorName":       autorest.Encode("path", detectorName),
		"diagnosticCategory": autorest.Encode("path", diagnosticCategory),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"siteName":           autorest.Encode("path", siteName),
		"slot":               autorest.Encode("path", slot),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-03-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/detectors/{detectorName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteDetectorSlotSender sends the GetSiteDetectorSlot request. The method will close the
// http.Response Body if it receives an error.
func (client DiagnosticsClient) GetSiteDetectorSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetSiteDetectorSlotResponder handles the response to the GetSiteDetectorSlot request. The method always
// closes the http.Response Body.
func (client DiagnosticsClient) GetSiteDetectorSlotResponder(resp *http.Response) (result DiagnosticDetectorCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getSiteDetectorSlotNextResults retrieves the next set of results, if any.
func (client DiagnosticsClient) getSiteDetectorSlotNextResults(lastResults DiagnosticDetectorCollection) (result DiagnosticDetectorCollection, err error) {
	req, err := lastResults.diagnosticDetectorCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.DiagnosticsClient", "getSiteDetectorSlotNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetSiteDetectorSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.DiagnosticsClient", "getSiteDetectorSlotNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetSiteDetectorSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "getSiteDetectorSlotNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetSiteDetectorSlotComplete enumerates all values, automatically crossing page boundaries as required.
func (client DiagnosticsClient) GetSiteDetectorSlotComplete(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, detectorName string, slot string) (result DiagnosticDetectorCollectionIterator, err error) {
	result.page, err = client.GetSiteDetectorSlot(ctx, resourceGroupName, siteName, diagnosticCategory, detectorName, slot)
	return
}

// GetSiteDiagnosticCategory get Diagnostics Category
//
// resourceGroupName is name of the resource group to which the resource belongs. siteName is site Name
// diagnosticCategory is diagnostic Category
func (client DiagnosticsClient) GetSiteDiagnosticCategory(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string) (result DiagnosticCategory, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.DiagnosticsClient", "GetSiteDiagnosticCategory")
	}

	req, err := client.GetSiteDiagnosticCategoryPreparer(ctx, resourceGroupName, siteName, diagnosticCategory)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "GetSiteDiagnosticCategory", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteDiagnosticCategorySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "GetSiteDiagnosticCategory", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteDiagnosticCategoryResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "GetSiteDiagnosticCategory", resp, "Failure responding to request")
	}

	return
}

// GetSiteDiagnosticCategoryPreparer prepares the GetSiteDiagnosticCategory request.
func (client DiagnosticsClient) GetSiteDiagnosticCategoryPreparer(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"diagnosticCategory": autorest.Encode("path", diagnosticCategory),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"siteName":           autorest.Encode("path", siteName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-03-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteDiagnosticCategorySender sends the GetSiteDiagnosticCategory request. The method will close the
// http.Response Body if it receives an error.
func (client DiagnosticsClient) GetSiteDiagnosticCategorySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetSiteDiagnosticCategoryResponder handles the response to the GetSiteDiagnosticCategory request. The method always
// closes the http.Response Body.
func (client DiagnosticsClient) GetSiteDiagnosticCategoryResponder(resp *http.Response) (result DiagnosticCategory, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteDiagnosticCategorySlot get Diagnostics Category
//
// resourceGroupName is name of the resource group to which the resource belongs. siteName is site Name
// diagnosticCategory is diagnostic Category slot is slot Name
func (client DiagnosticsClient) GetSiteDiagnosticCategorySlot(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, slot string) (result DiagnosticCategory, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.DiagnosticsClient", "GetSiteDiagnosticCategorySlot")
	}

	req, err := client.GetSiteDiagnosticCategorySlotPreparer(ctx, resourceGroupName, siteName, diagnosticCategory, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "GetSiteDiagnosticCategorySlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteDiagnosticCategorySlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "GetSiteDiagnosticCategorySlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteDiagnosticCategorySlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "GetSiteDiagnosticCategorySlot", resp, "Failure responding to request")
	}

	return
}

// GetSiteDiagnosticCategorySlotPreparer prepares the GetSiteDiagnosticCategorySlot request.
func (client DiagnosticsClient) GetSiteDiagnosticCategorySlotPreparer(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"diagnosticCategory": autorest.Encode("path", diagnosticCategory),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"siteName":           autorest.Encode("path", siteName),
		"slot":               autorest.Encode("path", slot),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-03-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteDiagnosticCategorySlotSender sends the GetSiteDiagnosticCategorySlot request. The method will close the
// http.Response Body if it receives an error.
func (client DiagnosticsClient) GetSiteDiagnosticCategorySlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetSiteDiagnosticCategorySlotResponder handles the response to the GetSiteDiagnosticCategorySlot request. The method always
// closes the http.Response Body.
func (client DiagnosticsClient) GetSiteDiagnosticCategorySlotResponder(resp *http.Response) (result DiagnosticCategory, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSiteAnalyses get Site Analyses
//
// resourceGroupName is name of the resource group to which the resource belongs. siteName is site Name
// diagnosticCategory is diagnostic Category
func (client DiagnosticsClient) ListSiteAnalyses(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string) (result DiagnosticAnalysisCollectionPage, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.DiagnosticsClient", "ListSiteAnalyses")
	}

	result.fn = client.listSiteAnalysesNextResults
	req, err := client.ListSiteAnalysesPreparer(ctx, resourceGroupName, siteName, diagnosticCategory)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ListSiteAnalyses", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSiteAnalysesSender(req)
	if err != nil {
		result.dac.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ListSiteAnalyses", resp, "Failure sending request")
		return
	}

	result.dac, err = client.ListSiteAnalysesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ListSiteAnalyses", resp, "Failure responding to request")
	}

	return
}

// ListSiteAnalysesPreparer prepares the ListSiteAnalyses request.
func (client DiagnosticsClient) ListSiteAnalysesPreparer(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"diagnosticCategory": autorest.Encode("path", diagnosticCategory),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"siteName":           autorest.Encode("path", siteName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-03-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/analyses", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSiteAnalysesSender sends the ListSiteAnalyses request. The method will close the
// http.Response Body if it receives an error.
func (client DiagnosticsClient) ListSiteAnalysesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListSiteAnalysesResponder handles the response to the ListSiteAnalyses request. The method always
// closes the http.Response Body.
func (client DiagnosticsClient) ListSiteAnalysesResponder(resp *http.Response) (result DiagnosticAnalysisCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listSiteAnalysesNextResults retrieves the next set of results, if any.
func (client DiagnosticsClient) listSiteAnalysesNextResults(lastResults DiagnosticAnalysisCollection) (result DiagnosticAnalysisCollection, err error) {
	req, err := lastResults.diagnosticAnalysisCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.DiagnosticsClient", "listSiteAnalysesNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSiteAnalysesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.DiagnosticsClient", "listSiteAnalysesNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListSiteAnalysesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "listSiteAnalysesNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListSiteAnalysesComplete enumerates all values, automatically crossing page boundaries as required.
func (client DiagnosticsClient) ListSiteAnalysesComplete(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string) (result DiagnosticAnalysisCollectionIterator, err error) {
	result.page, err = client.ListSiteAnalyses(ctx, resourceGroupName, siteName, diagnosticCategory)
	return
}

// ListSiteAnalysesSlot get Site Analyses
//
// resourceGroupName is name of the resource group to which the resource belongs. siteName is site Name
// diagnosticCategory is diagnostic Category slot is slot Name
func (client DiagnosticsClient) ListSiteAnalysesSlot(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, slot string) (result DiagnosticAnalysisCollectionPage, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.DiagnosticsClient", "ListSiteAnalysesSlot")
	}

	result.fn = client.listSiteAnalysesSlotNextResults
	req, err := client.ListSiteAnalysesSlotPreparer(ctx, resourceGroupName, siteName, diagnosticCategory, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ListSiteAnalysesSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSiteAnalysesSlotSender(req)
	if err != nil {
		result.dac.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ListSiteAnalysesSlot", resp, "Failure sending request")
		return
	}

	result.dac, err = client.ListSiteAnalysesSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ListSiteAnalysesSlot", resp, "Failure responding to request")
	}

	return
}

// ListSiteAnalysesSlotPreparer prepares the ListSiteAnalysesSlot request.
func (client DiagnosticsClient) ListSiteAnalysesSlotPreparer(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"diagnosticCategory": autorest.Encode("path", diagnosticCategory),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"siteName":           autorest.Encode("path", siteName),
		"slot":               autorest.Encode("path", slot),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-03-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/analyses", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSiteAnalysesSlotSender sends the ListSiteAnalysesSlot request. The method will close the
// http.Response Body if it receives an error.
func (client DiagnosticsClient) ListSiteAnalysesSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListSiteAnalysesSlotResponder handles the response to the ListSiteAnalysesSlot request. The method always
// closes the http.Response Body.
func (client DiagnosticsClient) ListSiteAnalysesSlotResponder(resp *http.Response) (result DiagnosticAnalysisCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listSiteAnalysesSlotNextResults retrieves the next set of results, if any.
func (client DiagnosticsClient) listSiteAnalysesSlotNextResults(lastResults DiagnosticAnalysisCollection) (result DiagnosticAnalysisCollection, err error) {
	req, err := lastResults.diagnosticAnalysisCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.DiagnosticsClient", "listSiteAnalysesSlotNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSiteAnalysesSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.DiagnosticsClient", "listSiteAnalysesSlotNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListSiteAnalysesSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "listSiteAnalysesSlotNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListSiteAnalysesSlotComplete enumerates all values, automatically crossing page boundaries as required.
func (client DiagnosticsClient) ListSiteAnalysesSlotComplete(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, slot string) (result DiagnosticAnalysisCollectionIterator, err error) {
	result.page, err = client.ListSiteAnalysesSlot(ctx, resourceGroupName, siteName, diagnosticCategory, slot)
	return
}

// ListSiteDetectors get Detectors
//
// resourceGroupName is name of the resource group to which the resource belongs. siteName is site Name
// diagnosticCategory is diagnostic Category
func (client DiagnosticsClient) ListSiteDetectors(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string) (result DiagnosticDetectorCollectionPage, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.DiagnosticsClient", "ListSiteDetectors")
	}

	result.fn = client.listSiteDetectorsNextResults
	req, err := client.ListSiteDetectorsPreparer(ctx, resourceGroupName, siteName, diagnosticCategory)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ListSiteDetectors", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSiteDetectorsSender(req)
	if err != nil {
		result.ddc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ListSiteDetectors", resp, "Failure sending request")
		return
	}

	result.ddc, err = client.ListSiteDetectorsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ListSiteDetectors", resp, "Failure responding to request")
	}

	return
}

// ListSiteDetectorsPreparer prepares the ListSiteDetectors request.
func (client DiagnosticsClient) ListSiteDetectorsPreparer(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"diagnosticCategory": autorest.Encode("path", diagnosticCategory),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"siteName":           autorest.Encode("path", siteName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-03-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/detectors", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSiteDetectorsSender sends the ListSiteDetectors request. The method will close the
// http.Response Body if it receives an error.
func (client DiagnosticsClient) ListSiteDetectorsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListSiteDetectorsResponder handles the response to the ListSiteDetectors request. The method always
// closes the http.Response Body.
func (client DiagnosticsClient) ListSiteDetectorsResponder(resp *http.Response) (result DiagnosticDetectorCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listSiteDetectorsNextResults retrieves the next set of results, if any.
func (client DiagnosticsClient) listSiteDetectorsNextResults(lastResults DiagnosticDetectorCollection) (result DiagnosticDetectorCollection, err error) {
	req, err := lastResults.diagnosticDetectorCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.DiagnosticsClient", "listSiteDetectorsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSiteDetectorsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.DiagnosticsClient", "listSiteDetectorsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListSiteDetectorsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "listSiteDetectorsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListSiteDetectorsComplete enumerates all values, automatically crossing page boundaries as required.
func (client DiagnosticsClient) ListSiteDetectorsComplete(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string) (result DiagnosticDetectorCollectionIterator, err error) {
	result.page, err = client.ListSiteDetectors(ctx, resourceGroupName, siteName, diagnosticCategory)
	return
}

// ListSiteDetectorsSlot get Detectors
//
// resourceGroupName is name of the resource group to which the resource belongs. siteName is site Name
// diagnosticCategory is diagnostic Category slot is slot Name
func (client DiagnosticsClient) ListSiteDetectorsSlot(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, slot string) (result DiagnosticDetectorCollectionPage, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.DiagnosticsClient", "ListSiteDetectorsSlot")
	}

	result.fn = client.listSiteDetectorsSlotNextResults
	req, err := client.ListSiteDetectorsSlotPreparer(ctx, resourceGroupName, siteName, diagnosticCategory, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ListSiteDetectorsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSiteDetectorsSlotSender(req)
	if err != nil {
		result.ddc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ListSiteDetectorsSlot", resp, "Failure sending request")
		return
	}

	result.ddc, err = client.ListSiteDetectorsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ListSiteDetectorsSlot", resp, "Failure responding to request")
	}

	return
}

// ListSiteDetectorsSlotPreparer prepares the ListSiteDetectorsSlot request.
func (client DiagnosticsClient) ListSiteDetectorsSlotPreparer(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"diagnosticCategory": autorest.Encode("path", diagnosticCategory),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"siteName":           autorest.Encode("path", siteName),
		"slot":               autorest.Encode("path", slot),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-03-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/detectors", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSiteDetectorsSlotSender sends the ListSiteDetectorsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client DiagnosticsClient) ListSiteDetectorsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListSiteDetectorsSlotResponder handles the response to the ListSiteDetectorsSlot request. The method always
// closes the http.Response Body.
func (client DiagnosticsClient) ListSiteDetectorsSlotResponder(resp *http.Response) (result DiagnosticDetectorCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listSiteDetectorsSlotNextResults retrieves the next set of results, if any.
func (client DiagnosticsClient) listSiteDetectorsSlotNextResults(lastResults DiagnosticDetectorCollection) (result DiagnosticDetectorCollection, err error) {
	req, err := lastResults.diagnosticDetectorCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.DiagnosticsClient", "listSiteDetectorsSlotNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSiteDetectorsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.DiagnosticsClient", "listSiteDetectorsSlotNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListSiteDetectorsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "listSiteDetectorsSlotNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListSiteDetectorsSlotComplete enumerates all values, automatically crossing page boundaries as required.
func (client DiagnosticsClient) ListSiteDetectorsSlotComplete(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, slot string) (result DiagnosticDetectorCollectionIterator, err error) {
	result.page, err = client.ListSiteDetectorsSlot(ctx, resourceGroupName, siteName, diagnosticCategory, slot)
	return
}

// ListSiteDiagnosticCategories get Diagnostics Categories
//
// resourceGroupName is name of the resource group to which the resource belongs. siteName is site Name
func (client DiagnosticsClient) ListSiteDiagnosticCategories(ctx context.Context, resourceGroupName string, siteName string) (result DiagnosticCategoryCollectionPage, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.DiagnosticsClient", "ListSiteDiagnosticCategories")
	}

	result.fn = client.listSiteDiagnosticCategoriesNextResults
	req, err := client.ListSiteDiagnosticCategoriesPreparer(ctx, resourceGroupName, siteName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ListSiteDiagnosticCategories", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSiteDiagnosticCategoriesSender(req)
	if err != nil {
		result.dcc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ListSiteDiagnosticCategories", resp, "Failure sending request")
		return
	}

	result.dcc, err = client.ListSiteDiagnosticCategoriesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ListSiteDiagnosticCategories", resp, "Failure responding to request")
	}

	return
}

// ListSiteDiagnosticCategoriesPreparer prepares the ListSiteDiagnosticCategories request.
func (client DiagnosticsClient) ListSiteDiagnosticCategoriesPreparer(ctx context.Context, resourceGroupName string, siteName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"siteName":          autorest.Encode("path", siteName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-03-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSiteDiagnosticCategoriesSender sends the ListSiteDiagnosticCategories request. The method will close the
// http.Response Body if it receives an error.
func (client DiagnosticsClient) ListSiteDiagnosticCategoriesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListSiteDiagnosticCategoriesResponder handles the response to the ListSiteDiagnosticCategories request. The method always
// closes the http.Response Body.
func (client DiagnosticsClient) ListSiteDiagnosticCategoriesResponder(resp *http.Response) (result DiagnosticCategoryCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listSiteDiagnosticCategoriesNextResults retrieves the next set of results, if any.
func (client DiagnosticsClient) listSiteDiagnosticCategoriesNextResults(lastResults DiagnosticCategoryCollection) (result DiagnosticCategoryCollection, err error) {
	req, err := lastResults.diagnosticCategoryCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.DiagnosticsClient", "listSiteDiagnosticCategoriesNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSiteDiagnosticCategoriesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.DiagnosticsClient", "listSiteDiagnosticCategoriesNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListSiteDiagnosticCategoriesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "listSiteDiagnosticCategoriesNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListSiteDiagnosticCategoriesComplete enumerates all values, automatically crossing page boundaries as required.
func (client DiagnosticsClient) ListSiteDiagnosticCategoriesComplete(ctx context.Context, resourceGroupName string, siteName string) (result DiagnosticCategoryCollectionIterator, err error) {
	result.page, err = client.ListSiteDiagnosticCategories(ctx, resourceGroupName, siteName)
	return
}

// ListSiteDiagnosticCategoriesSlot get Diagnostics Categories
//
// resourceGroupName is name of the resource group to which the resource belongs. siteName is site Name slot is slot
// Name
func (client DiagnosticsClient) ListSiteDiagnosticCategoriesSlot(ctx context.Context, resourceGroupName string, siteName string, slot string) (result DiagnosticCategoryCollectionPage, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.DiagnosticsClient", "ListSiteDiagnosticCategoriesSlot")
	}

	result.fn = client.listSiteDiagnosticCategoriesSlotNextResults
	req, err := client.ListSiteDiagnosticCategoriesSlotPreparer(ctx, resourceGroupName, siteName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ListSiteDiagnosticCategoriesSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSiteDiagnosticCategoriesSlotSender(req)
	if err != nil {
		result.dcc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ListSiteDiagnosticCategoriesSlot", resp, "Failure sending request")
		return
	}

	result.dcc, err = client.ListSiteDiagnosticCategoriesSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ListSiteDiagnosticCategoriesSlot", resp, "Failure responding to request")
	}

	return
}

// ListSiteDiagnosticCategoriesSlotPreparer prepares the ListSiteDiagnosticCategoriesSlot request.
func (client DiagnosticsClient) ListSiteDiagnosticCategoriesSlotPreparer(ctx context.Context, resourceGroupName string, siteName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"siteName":          autorest.Encode("path", siteName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-03-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSiteDiagnosticCategoriesSlotSender sends the ListSiteDiagnosticCategoriesSlot request. The method will close the
// http.Response Body if it receives an error.
func (client DiagnosticsClient) ListSiteDiagnosticCategoriesSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListSiteDiagnosticCategoriesSlotResponder handles the response to the ListSiteDiagnosticCategoriesSlot request. The method always
// closes the http.Response Body.
func (client DiagnosticsClient) ListSiteDiagnosticCategoriesSlotResponder(resp *http.Response) (result DiagnosticCategoryCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listSiteDiagnosticCategoriesSlotNextResults retrieves the next set of results, if any.
func (client DiagnosticsClient) listSiteDiagnosticCategoriesSlotNextResults(lastResults DiagnosticCategoryCollection) (result DiagnosticCategoryCollection, err error) {
	req, err := lastResults.diagnosticCategoryCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.DiagnosticsClient", "listSiteDiagnosticCategoriesSlotNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSiteDiagnosticCategoriesSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.DiagnosticsClient", "listSiteDiagnosticCategoriesSlotNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListSiteDiagnosticCategoriesSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "listSiteDiagnosticCategoriesSlotNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListSiteDiagnosticCategoriesSlotComplete enumerates all values, automatically crossing page boundaries as required.
func (client DiagnosticsClient) ListSiteDiagnosticCategoriesSlotComplete(ctx context.Context, resourceGroupName string, siteName string, slot string) (result DiagnosticCategoryCollectionIterator, err error) {
	result.page, err = client.ListSiteDiagnosticCategoriesSlot(ctx, resourceGroupName, siteName, slot)
	return
}
