package storage

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
)

// AccessTier enumerates the values for access tier.
type AccessTier string

const (
	// Cool specifies the cool state for access tier.
	Cool AccessTier = "Cool"
	// Hot specifies the hot state for access tier.
	Hot AccessTier = "Hot"
)

// AccountStatus enumerates the values for account status.
type AccountStatus string

const (
	// Available specifies the available state for account status.
	Available AccountStatus = "available"
	// Unavailable specifies the unavailable state for account status.
	Unavailable AccountStatus = "unavailable"
)

// Action enumerates the values for action.
type Action string

const (
	// Allow specifies the allow state for action.
	Allow Action = "Allow"
)

// Bypass enumerates the values for bypass.
type Bypass string

const (
	// AzureServices specifies the azure services state for bypass.
	AzureServices Bypass = "AzureServices"
	// Logging specifies the logging state for bypass.
	Logging Bypass = "Logging"
	// Metrics specifies the metrics state for bypass.
	Metrics Bypass = "Metrics"
	// None specifies the none state for bypass.
	None Bypass = "None"
)

// DefaultAction enumerates the values for default action.
type DefaultAction string

const (
	// DefaultActionAllow specifies the default action allow state for default action.
	DefaultActionAllow DefaultAction = "Allow"
	// DefaultActionDeny specifies the default action deny state for default action.
	DefaultActionDeny DefaultAction = "Deny"
)

// HTTPProtocol enumerates the values for http protocol.
type HTTPProtocol string

const (
	// HTTPS specifies the https state for http protocol.
	HTTPS HTTPProtocol = "https"
	// Httpshttp specifies the httpshttp state for http protocol.
	Httpshttp HTTPProtocol = "https,http"
)

// KeyPermission enumerates the values for key permission.
type KeyPermission string

const (
	// Full specifies the full state for key permission.
	Full KeyPermission = "Full"
	// Read specifies the read state for key permission.
	Read KeyPermission = "Read"
)

// KeySource enumerates the values for key source.
type KeySource string

const (
	// MicrosoftKeyvault specifies the microsoft keyvault state for key source.
	MicrosoftKeyvault KeySource = "Microsoft.Keyvault"
	// MicrosoftStorage specifies the microsoft storage state for key source.
	MicrosoftStorage KeySource = "Microsoft.Storage"
)

// Kind enumerates the values for kind.
type Kind string

const (
	// BlobStorage specifies the blob storage state for kind.
	BlobStorage Kind = "BlobStorage"
	// Storage specifies the storage state for kind.
	Storage Kind = "Storage"
	// StorageV2 specifies the storage v2 state for kind.
	StorageV2 Kind = "StorageV2"
)

// Permissions enumerates the values for permissions.
type Permissions string

const (
	// A specifies the a state for permissions.
	A Permissions = "a"
	// C specifies the c state for permissions.
	C Permissions = "c"
	// D specifies the d state for permissions.
	D Permissions = "d"
	// L specifies the l state for permissions.
	L Permissions = "l"
	// P specifies the p state for permissions.
	P Permissions = "p"
	// R specifies the r state for permissions.
	R Permissions = "r"
	// U specifies the u state for permissions.
	U Permissions = "u"
	// W specifies the w state for permissions.
	W Permissions = "w"
)

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// Creating specifies the creating state for provisioning state.
	Creating ProvisioningState = "Creating"
	// ResolvingDNS specifies the resolving dns state for provisioning state.
	ResolvingDNS ProvisioningState = "ResolvingDNS"
	// Succeeded specifies the succeeded state for provisioning state.
	Succeeded ProvisioningState = "Succeeded"
)

// Reason enumerates the values for reason.
type Reason string

const (
	// AccountNameInvalid specifies the account name invalid state for reason.
	AccountNameInvalid Reason = "AccountNameInvalid"
	// AlreadyExists specifies the already exists state for reason.
	AlreadyExists Reason = "AlreadyExists"
)

// ReasonCode enumerates the values for reason code.
type ReasonCode string

const (
	// NotAvailableForSubscription specifies the not available for subscription state for reason code.
	NotAvailableForSubscription ReasonCode = "NotAvailableForSubscription"
	// QuotaID specifies the quota id state for reason code.
	QuotaID ReasonCode = "QuotaId"
)

// Services enumerates the values for services.
type Services string

const (
	// B specifies the b state for services.
	B Services = "b"
	// F specifies the f state for services.
	F Services = "f"
	// Q specifies the q state for services.
	Q Services = "q"
	// T specifies the t state for services.
	T Services = "t"
)

// SignedResource enumerates the values for signed resource.
type SignedResource string

const (
	// SignedResourceB specifies the signed resource b state for signed resource.
	SignedResourceB SignedResource = "b"
	// SignedResourceC specifies the signed resource c state for signed resource.
	SignedResourceC SignedResource = "c"
	// SignedResourceF specifies the signed resource f state for signed resource.
	SignedResourceF SignedResource = "f"
	// SignedResourceS specifies the signed resource s state for signed resource.
	SignedResourceS SignedResource = "s"
)

// SignedResourceTypes enumerates the values for signed resource types.
type SignedResourceTypes string

const (
	// SignedResourceTypesC specifies the signed resource types c state for signed resource types.
	SignedResourceTypesC SignedResourceTypes = "c"
	// SignedResourceTypesO specifies the signed resource types o state for signed resource types.
	SignedResourceTypesO SignedResourceTypes = "o"
	// SignedResourceTypesS specifies the signed resource types s state for signed resource types.
	SignedResourceTypesS SignedResourceTypes = "s"
)

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// PremiumLRS specifies the premium lrs state for sku name.
	PremiumLRS SkuName = "Premium_LRS"
	// StandardGRS specifies the standard grs state for sku name.
	StandardGRS SkuName = "Standard_GRS"
	// StandardLRS specifies the standard lrs state for sku name.
	StandardLRS SkuName = "Standard_LRS"
	// StandardRAGRS specifies the standard ragrs state for sku name.
	StandardRAGRS SkuName = "Standard_RAGRS"
	// StandardZRS specifies the standard zrs state for sku name.
	StandardZRS SkuName = "Standard_ZRS"
)

// SkuTier enumerates the values for sku tier.
type SkuTier string

const (
	// Premium specifies the premium state for sku tier.
	Premium SkuTier = "Premium"
	// Standard specifies the standard state for sku tier.
	Standard SkuTier = "Standard"
)

// State enumerates the values for state.
type State string

const (
	// StateDeprovisioning specifies the state deprovisioning state for state.
	StateDeprovisioning State = "deprovisioning"
	// StateFailed specifies the state failed state for state.
	StateFailed State = "failed"
	// StateNetworkSourceDeleted specifies the state network source deleted state for state.
	StateNetworkSourceDeleted State = "networkSourceDeleted"
	// StateProvisioning specifies the state provisioning state for state.
	StateProvisioning State = "provisioning"
	// StateSucceeded specifies the state succeeded state for state.
	StateSucceeded State = "succeeded"
)

// UsageUnit enumerates the values for usage unit.
type UsageUnit string

const (
	// Bytes specifies the bytes state for usage unit.
	Bytes UsageUnit = "Bytes"
	// BytesPerSecond specifies the bytes per second state for usage unit.
	BytesPerSecond UsageUnit = "BytesPerSecond"
	// Count specifies the count state for usage unit.
	Count UsageUnit = "Count"
	// CountsPerSecond specifies the counts per second state for usage unit.
	CountsPerSecond UsageUnit = "CountsPerSecond"
	// Percent specifies the percent state for usage unit.
	Percent UsageUnit = "Percent"
	// Seconds specifies the seconds state for usage unit.
	Seconds UsageUnit = "Seconds"
)

// Account is the storage account.
type Account struct {
	autorest.Response  `json:"-"`
	ID                 *string             `json:"id,omitempty"`
	Name               *string             `json:"name,omitempty"`
	Type               *string             `json:"type,omitempty"`
	Location           *string             `json:"location,omitempty"`
	Tags               *map[string]*string `json:"tags,omitempty"`
	Sku                *Sku                `json:"sku,omitempty"`
	Kind               Kind                `json:"kind,omitempty"`
	Identity           *Identity           `json:"identity,omitempty"`
	*AccountProperties `json:"properties,omitempty"`
}

// AccountCheckNameAvailabilityParameters is the parameters used to check the availabity of the storage account name.
type AccountCheckNameAvailabilityParameters struct {
	Name *string `json:"name,omitempty"`
	Type *string `json:"type,omitempty"`
}

// AccountCreateParameters is the parameters used when creating a storage account.
type AccountCreateParameters struct {
	Sku                                *Sku                `json:"sku,omitempty"`
	Kind                               Kind                `json:"kind,omitempty"`
	Location                           *string             `json:"location,omitempty"`
	Tags                               *map[string]*string `json:"tags,omitempty"`
	Identity                           *Identity           `json:"identity,omitempty"`
	*AccountPropertiesCreateParameters `json:"properties,omitempty"`
}

// AccountKey is an access key for the storage account.
type AccountKey struct {
	KeyName     *string       `json:"keyName,omitempty"`
	Value       *string       `json:"value,omitempty"`
	Permissions KeyPermission `json:"permissions,omitempty"`
}

// AccountListKeysResult is the response from the ListKeys operation.
type AccountListKeysResult struct {
	autorest.Response `json:"-"`
	Keys              *[]AccountKey `json:"keys,omitempty"`
}

// AccountListResult is the response from the List Storage Accounts operation.
type AccountListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Account `json:"value,omitempty"`
}

// AccountProperties is properties of the storage account.
type AccountProperties struct {
	ProvisioningState      ProvisioningState `json:"provisioningState,omitempty"`
	PrimaryEndpoints       *Endpoints        `json:"primaryEndpoints,omitempty"`
	PrimaryLocation        *string           `json:"primaryLocation,omitempty"`
	StatusOfPrimary        AccountStatus     `json:"statusOfPrimary,omitempty"`
	LastGeoFailoverTime    *date.Time        `json:"lastGeoFailoverTime,omitempty"`
	SecondaryLocation      *string           `json:"secondaryLocation,omitempty"`
	StatusOfSecondary      AccountStatus     `json:"statusOfSecondary,omitempty"`
	CreationTime           *date.Time        `json:"creationTime,omitempty"`
	CustomDomain           *CustomDomain     `json:"customDomain,omitempty"`
	SecondaryEndpoints     *Endpoints        `json:"secondaryEndpoints,omitempty"`
	Encryption             *Encryption       `json:"encryption,omitempty"`
	AccessTier             AccessTier        `json:"accessTier,omitempty"`
	EnableHTTPSTrafficOnly *bool             `json:"supportsHttpsTrafficOnly,omitempty"`
	NetworkRuleSet         *NetworkRuleSet   `json:"networkAcls,omitempty"`
}

// AccountPropertiesCreateParameters is the parameters used to create the storage account.
type AccountPropertiesCreateParameters struct {
	CustomDomain           *CustomDomain   `json:"customDomain,omitempty"`
	Encryption             *Encryption     `json:"encryption,omitempty"`
	NetworkRuleSet         *NetworkRuleSet `json:"networkAcls,omitempty"`
	AccessTier             AccessTier      `json:"accessTier,omitempty"`
	EnableHTTPSTrafficOnly *bool           `json:"supportsHttpsTrafficOnly,omitempty"`
}

// AccountPropertiesUpdateParameters is the parameters used when updating a storage account.
type AccountPropertiesUpdateParameters struct {
	CustomDomain           *CustomDomain   `json:"customDomain,omitempty"`
	Encryption             *Encryption     `json:"encryption,omitempty"`
	AccessTier             AccessTier      `json:"accessTier,omitempty"`
	EnableHTTPSTrafficOnly *bool           `json:"supportsHttpsTrafficOnly,omitempty"`
	NetworkRuleSet         *NetworkRuleSet `json:"networkAcls,omitempty"`
}

// AccountRegenerateKeyParameters is the parameters used to regenerate the storage account key.
type AccountRegenerateKeyParameters struct {
	KeyName *string `json:"keyName,omitempty"`
}

// AccountSasParameters is the parameters to list SAS credentials of a storage account.
type AccountSasParameters struct {
	Services               Services            `json:"signedServices,omitempty"`
	ResourceTypes          SignedResourceTypes `json:"signedResourceTypes,omitempty"`
	Permissions            Permissions         `json:"signedPermission,omitempty"`
	IPAddressOrRange       *string             `json:"signedIp,omitempty"`
	Protocols              HTTPProtocol        `json:"signedProtocol,omitempty"`
	SharedAccessStartTime  *date.Time          `json:"signedStart,omitempty"`
	SharedAccessExpiryTime *date.Time          `json:"signedExpiry,omitempty"`
	KeyToSign              *string             `json:"keyToSign,omitempty"`
}

// AccountUpdateParameters is the parameters that can be provided when updating the storage account properties.
type AccountUpdateParameters struct {
	Sku                                *Sku                `json:"sku,omitempty"`
	Tags                               *map[string]*string `json:"tags,omitempty"`
	Identity                           *Identity           `json:"identity,omitempty"`
	*AccountPropertiesUpdateParameters `json:"properties,omitempty"`
	Kind                               Kind `json:"kind,omitempty"`
}

// CheckNameAvailabilityResult is the CheckNameAvailability operation response.
type CheckNameAvailabilityResult struct {
	autorest.Response `json:"-"`
	NameAvailable     *bool   `json:"nameAvailable,omitempty"`
	Reason            Reason  `json:"reason,omitempty"`
	Message           *string `json:"message,omitempty"`
}

// CustomDomain is the custom domain assigned to this storage account. This can be set via Update.
type CustomDomain struct {
	Name         *string `json:"name,omitempty"`
	UseSubDomain *bool   `json:"useSubDomain,omitempty"`
}

// Dimension is dimension of blobs, possiblly be blob type or access tier.
type Dimension struct {
	Name        *string `json:"name,omitempty"`
	DisplayName *string `json:"displayName,omitempty"`
}

// Encryption is the encryption settings on the storage account.
type Encryption struct {
	Services           *EncryptionServices `json:"services,omitempty"`
	KeySource          KeySource           `json:"keySource,omitempty"`
	KeyVaultProperties *KeyVaultProperties `json:"keyvaultproperties,omitempty"`
}

// EncryptionService is a service that allows server-side encryption to be used.
type EncryptionService struct {
	Enabled         *bool      `json:"enabled,omitempty"`
	LastEnabledTime *date.Time `json:"lastEnabledTime,omitempty"`
}

// EncryptionServices is a list of services that support encryption.
type EncryptionServices struct {
	Blob  *EncryptionService `json:"blob,omitempty"`
	File  *EncryptionService `json:"file,omitempty"`
	Table *EncryptionService `json:"table,omitempty"`
	Queue *EncryptionService `json:"queue,omitempty"`
}

// Endpoints is the URIs that are used to perform a retrieval of a public blob, queue, or table object.
type Endpoints struct {
	Blob  *string `json:"blob,omitempty"`
	Queue *string `json:"queue,omitempty"`
	Table *string `json:"table,omitempty"`
	File  *string `json:"file,omitempty"`
}

// Identity is identity for the resource.
type Identity struct {
	PrincipalID *string `json:"principalId,omitempty"`
	TenantID    *string `json:"tenantId,omitempty"`
	Type        *string `json:"type,omitempty"`
}

// IPRule is IP rule with specific IP or IP range in CIDR format.
type IPRule struct {
	IPAddressOrRange *string `json:"value,omitempty"`
	Action           Action  `json:"action,omitempty"`
}

// KeyVaultProperties is properties of key vault.
type KeyVaultProperties struct {
	KeyName     *string `json:"keyname,omitempty"`
	KeyVersion  *string `json:"keyversion,omitempty"`
	KeyVaultURI *string `json:"keyvaulturi,omitempty"`
}

// ListAccountSasResponse is the List SAS credentials operation response.
type ListAccountSasResponse struct {
	autorest.Response `json:"-"`
	AccountSasToken   *string `json:"accountSasToken,omitempty"`
}

// ListServiceSasResponse is the List service SAS credentials operation response.
type ListServiceSasResponse struct {
	autorest.Response `json:"-"`
	ServiceSasToken   *string `json:"serviceSasToken,omitempty"`
}

// MetricSpecification is metric specification of operation.
type MetricSpecification struct {
	Name                            *string      `json:"name,omitempty"`
	DisplayName                     *string      `json:"displayName,omitempty"`
	DisplayDescription              *string      `json:"displayDescription,omitempty"`
	Unit                            *string      `json:"unit,omitempty"`
	Dimensions                      *[]Dimension `json:"dimensions,omitempty"`
	AggregationType                 *string      `json:"aggregationType,omitempty"`
	FillGapWithZero                 *bool        `json:"fillGapWithZero,omitempty"`
	Category                        *string      `json:"category,omitempty"`
	ResourceIDDimensionNameOverride *string      `json:"resourceIdDimensionNameOverride,omitempty"`
}

// NetworkRuleSet is network rule set
type NetworkRuleSet struct {
	Bypass              Bypass                `json:"bypass,omitempty"`
	VirtualNetworkRules *[]VirtualNetworkRule `json:"virtualNetworkRules,omitempty"`
	IPRules             *[]IPRule             `json:"ipRules,omitempty"`
	DefaultAction       DefaultAction         `json:"defaultAction,omitempty"`
}

// Operation is storage REST API operation definition.
type Operation struct {
	Name                 *string           `json:"name,omitempty"`
	Display              *OperationDisplay `json:"display,omitempty"`
	Origin               *string           `json:"origin,omitempty"`
	*OperationProperties `json:"properties,omitempty"`
}

// OperationDisplay is display metadata associated with the operation.
type OperationDisplay struct {
	Provider  *string `json:"provider,omitempty"`
	Resource  *string `json:"resource,omitempty"`
	Operation *string `json:"operation,omitempty"`
}

// OperationListResult is result of the request to list Storage operations. It contains a list of operations and a URL
// link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Operation `json:"value,omitempty"`
}

// OperationProperties is properties of operation, include metric specifications.
type OperationProperties struct {
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// Resource is describes a storage resource.
type Resource struct {
	ID       *string             `json:"id,omitempty"`
	Name     *string             `json:"name,omitempty"`
	Type     *string             `json:"type,omitempty"`
	Location *string             `json:"location,omitempty"`
	Tags     *map[string]*string `json:"tags,omitempty"`
}

// Restriction is the restriction because of which SKU cannot be used.
type Restriction struct {
	Type       *string    `json:"type,omitempty"`
	Values     *[]string  `json:"values,omitempty"`
	ReasonCode ReasonCode `json:"reasonCode,omitempty"`
}

// ServiceSasParameters is the parameters to list service SAS credentials of a speicific resource.
type ServiceSasParameters struct {
	CanonicalizedResource  *string        `json:"canonicalizedResource,omitempty"`
	Resource               SignedResource `json:"signedResource,omitempty"`
	Permissions            Permissions    `json:"signedPermission,omitempty"`
	IPAddressOrRange       *string        `json:"signedIp,omitempty"`
	Protocols              HTTPProtocol   `json:"signedProtocol,omitempty"`
	SharedAccessStartTime  *date.Time     `json:"signedStart,omitempty"`
	SharedAccessExpiryTime *date.Time     `json:"signedExpiry,omitempty"`
	Identifier             *string        `json:"signedIdentifier,omitempty"`
	PartitionKeyStart      *string        `json:"startPk,omitempty"`
	PartitionKeyEnd        *string        `json:"endPk,omitempty"`
	RowKeyStart            *string        `json:"startRk,omitempty"`
	RowKeyEnd              *string        `json:"endRk,omitempty"`
	KeyToSign              *string        `json:"keyToSign,omitempty"`
	CacheControl           *string        `json:"rscc,omitempty"`
	ContentDisposition     *string        `json:"rscd,omitempty"`
	ContentEncoding        *string        `json:"rsce,omitempty"`
	ContentLanguage        *string        `json:"rscl,omitempty"`
	ContentType            *string        `json:"rsct,omitempty"`
}

// ServiceSpecification is one property of operation, include metric specifications.
type ServiceSpecification struct {
	MetricSpecifications *[]MetricSpecification `json:"metricSpecifications,omitempty"`
}

// Sku is the SKU of the storage account.
type Sku struct {
	Name         SkuName          `json:"name,omitempty"`
	Tier         SkuTier          `json:"tier,omitempty"`
	ResourceType *string          `json:"resourceType,omitempty"`
	Kind         Kind             `json:"kind,omitempty"`
	Locations    *[]string        `json:"locations,omitempty"`
	Capabilities *[]SKUCapability `json:"capabilities,omitempty"`
	Restrictions *[]Restriction   `json:"restrictions,omitempty"`
}

// SKUCapability is the capability information in the specified sku, including file encryption, network acls, change
// notification, etc.
type SKUCapability struct {
	Name  *string `json:"name,omitempty"`
	Value *string `json:"value,omitempty"`
}

// SkuListResult is the response from the List Storage SKUs operation.
type SkuListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Sku `json:"value,omitempty"`
}

// Usage is describes Storage Resource Usage.
type Usage struct {
	Unit         UsageUnit  `json:"unit,omitempty"`
	CurrentValue *int32     `json:"currentValue,omitempty"`
	Limit        *int32     `json:"limit,omitempty"`
	Name         *UsageName `json:"name,omitempty"`
}

// UsageListResult is the response from the List Usages operation.
type UsageListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Usage `json:"value,omitempty"`
}

// UsageName is the usage names that can be used; currently limited to StorageAccount.
type UsageName struct {
	Value          *string `json:"value,omitempty"`
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// VirtualNetworkRule is virtual Network rule.
type VirtualNetworkRule struct {
	VirtualNetworkResourceID *string `json:"id,omitempty"`
	Action                   Action  `json:"action,omitempty"`
	State                    State   `json:"state,omitempty"`
}
