package servicefabric

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"net/http"
)

// ServiceTypesClient is the client for the ServiceTypes methods of the Servicefabric service.
type ServiceTypesClient struct {
	BaseClient
}

// NewServiceTypesClient creates an instance of the ServiceTypesClient client.
func NewServiceTypesClient(timeout *int32) ServiceTypesClient {
	return NewServiceTypesClientWithBaseURI(DefaultBaseURI, timeout)
}

// NewServiceTypesClientWithBaseURI creates an instance of the ServiceTypesClient client.
func NewServiceTypesClientWithBaseURI(baseURI string, timeout *int32) ServiceTypesClient {
	return ServiceTypesClient{NewWithBaseURI(baseURI, timeout)}
}

// Get get service types
//
// applicationTypeName is the name of the application type applicationTypeVersion is the version of the application
// type
func (client ServiceTypesClient) Get(ctx context.Context, applicationTypeName string, applicationTypeVersion string) (result ListServiceType, err error) {
	req, err := client.GetPreparer(ctx, applicationTypeName, applicationTypeVersion)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabric.ServiceTypesClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "servicefabric.ServiceTypesClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabric.ServiceTypesClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client ServiceTypesClient) GetPreparer(ctx context.Context, applicationTypeName string, applicationTypeVersion string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"applicationTypeName": autorest.Encode("path", applicationTypeName),
	}

	const APIVersion = "1.0.0"
	queryParameters := map[string]interface{}{
		"api-version":            APIVersion,
		"ApplicationTypeVersion": autorest.Encode("query", applicationTypeVersion),
	}
	if client.Timeout != nil {
		queryParameters["timeout"] = autorest.Encode("query", *client.Timeout)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/ApplicationTypes/{applicationTypeName}/$/GetServiceTypes", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client ServiceTypesClient) GetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client ServiceTypesClient) GetResponder(resp *http.Response) (result ListServiceType, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
