package search

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
)

// CjkBigramTokenFilterScripts enumerates the values for cjk bigram token filter scripts.
type CjkBigramTokenFilterScripts string

const (
	// Han ...
	Han CjkBigramTokenFilterScripts = "han"
	// Hangul ...
	Hangul CjkBigramTokenFilterScripts = "hangul"
	// Hiragana ...
	Hiragana CjkBigramTokenFilterScripts = "hiragana"
	// Katakana ...
	Katakana CjkBigramTokenFilterScripts = "katakana"
)

// EdgeNGramTokenFilterSide enumerates the values for edge n gram token filter side.
type EdgeNGramTokenFilterSide string

const (
	// Back ...
	Back EdgeNGramTokenFilterSide = "back"
	// Front ...
	Front EdgeNGramTokenFilterSide = "front"
)

// IndexActionType enumerates the values for index action type.
type IndexActionType string

const (
	// Delete ...
	Delete IndexActionType = "delete"
	// Merge ...
	Merge IndexActionType = "merge"
	// MergeOrUpload ...
	MergeOrUpload IndexActionType = "mergeOrUpload"
	// Upload ...
	Upload IndexActionType = "upload"
)

// IndexerExecutionStatus enumerates the values for indexer execution status.
type IndexerExecutionStatus string

const (
	// InProgress ...
	InProgress IndexerExecutionStatus = "inProgress"
	// Reset ...
	Reset IndexerExecutionStatus = "reset"
	// Success ...
	Success IndexerExecutionStatus = "success"
	// TransientFailure ...
	TransientFailure IndexerExecutionStatus = "transientFailure"
)

// IndexerStatus enumerates the values for indexer status.
type IndexerStatus string

const (
	// Error ...
	Error IndexerStatus = "error"
	// Running ...
	Running IndexerStatus = "running"
	// Unknown ...
	Unknown IndexerStatus = "unknown"
)

// MicrosoftStemmingTokenizerLanguage enumerates the values for microsoft stemming tokenizer language.
type MicrosoftStemmingTokenizerLanguage string

const (
	// Arabic ...
	Arabic MicrosoftStemmingTokenizerLanguage = "arabic"
	// Bangla ...
	Bangla MicrosoftStemmingTokenizerLanguage = "bangla"
	// Bulgarian ...
	Bulgarian MicrosoftStemmingTokenizerLanguage = "bulgarian"
	// Catalan ...
	Catalan MicrosoftStemmingTokenizerLanguage = "catalan"
	// Croatian ...
	Croatian MicrosoftStemmingTokenizerLanguage = "croatian"
	// Czech ...
	Czech MicrosoftStemmingTokenizerLanguage = "czech"
	// Danish ...
	Danish MicrosoftStemmingTokenizerLanguage = "danish"
	// Dutch ...
	Dutch MicrosoftStemmingTokenizerLanguage = "dutch"
	// English ...
	English MicrosoftStemmingTokenizerLanguage = "english"
	// Estonian ...
	Estonian MicrosoftStemmingTokenizerLanguage = "estonian"
	// Finnish ...
	Finnish MicrosoftStemmingTokenizerLanguage = "finnish"
	// French ...
	French MicrosoftStemmingTokenizerLanguage = "french"
	// German ...
	German MicrosoftStemmingTokenizerLanguage = "german"
	// Greek ...
	Greek MicrosoftStemmingTokenizerLanguage = "greek"
	// Gujarati ...
	Gujarati MicrosoftStemmingTokenizerLanguage = "gujarati"
	// Hebrew ...
	Hebrew MicrosoftStemmingTokenizerLanguage = "hebrew"
	// Hindi ...
	Hindi MicrosoftStemmingTokenizerLanguage = "hindi"
	// Hungarian ...
	Hungarian MicrosoftStemmingTokenizerLanguage = "hungarian"
	// Icelandic ...
	Icelandic MicrosoftStemmingTokenizerLanguage = "icelandic"
	// Indonesian ...
	Indonesian MicrosoftStemmingTokenizerLanguage = "indonesian"
	// Italian ...
	Italian MicrosoftStemmingTokenizerLanguage = "italian"
	// Kannada ...
	Kannada MicrosoftStemmingTokenizerLanguage = "kannada"
	// Latvian ...
	Latvian MicrosoftStemmingTokenizerLanguage = "latvian"
	// Lithuanian ...
	Lithuanian MicrosoftStemmingTokenizerLanguage = "lithuanian"
	// Malay ...
	Malay MicrosoftStemmingTokenizerLanguage = "malay"
	// Malayalam ...
	Malayalam MicrosoftStemmingTokenizerLanguage = "malayalam"
	// Marathi ...
	Marathi MicrosoftStemmingTokenizerLanguage = "marathi"
	// NorwegianBokmaal ...
	NorwegianBokmaal MicrosoftStemmingTokenizerLanguage = "norwegianBokmaal"
	// Polish ...
	Polish MicrosoftStemmingTokenizerLanguage = "polish"
	// Portuguese ...
	Portuguese MicrosoftStemmingTokenizerLanguage = "portuguese"
	// PortugueseBrazilian ...
	PortugueseBrazilian MicrosoftStemmingTokenizerLanguage = "portugueseBrazilian"
	// Punjabi ...
	Punjabi MicrosoftStemmingTokenizerLanguage = "punjabi"
	// Romanian ...
	Romanian MicrosoftStemmingTokenizerLanguage = "romanian"
	// Russian ...
	Russian MicrosoftStemmingTokenizerLanguage = "russian"
	// SerbianCyrillic ...
	SerbianCyrillic MicrosoftStemmingTokenizerLanguage = "serbianCyrillic"
	// SerbianLatin ...
	SerbianLatin MicrosoftStemmingTokenizerLanguage = "serbianLatin"
	// Slovak ...
	Slovak MicrosoftStemmingTokenizerLanguage = "slovak"
	// Slovenian ...
	Slovenian MicrosoftStemmingTokenizerLanguage = "slovenian"
	// Spanish ...
	Spanish MicrosoftStemmingTokenizerLanguage = "spanish"
	// Swedish ...
	Swedish MicrosoftStemmingTokenizerLanguage = "swedish"
	// Tamil ...
	Tamil MicrosoftStemmingTokenizerLanguage = "tamil"
	// Telugu ...
	Telugu MicrosoftStemmingTokenizerLanguage = "telugu"
	// Turkish ...
	Turkish MicrosoftStemmingTokenizerLanguage = "turkish"
	// Ukrainian ...
	Ukrainian MicrosoftStemmingTokenizerLanguage = "ukrainian"
	// Urdu ...
	Urdu MicrosoftStemmingTokenizerLanguage = "urdu"
)

// MicrosoftTokenizerLanguage enumerates the values for microsoft tokenizer language.
type MicrosoftTokenizerLanguage string

const (
	// MicrosoftTokenizerLanguageBangla ...
	MicrosoftTokenizerLanguageBangla MicrosoftTokenizerLanguage = "bangla"
	// MicrosoftTokenizerLanguageBulgarian ...
	MicrosoftTokenizerLanguageBulgarian MicrosoftTokenizerLanguage = "bulgarian"
	// MicrosoftTokenizerLanguageCatalan ...
	MicrosoftTokenizerLanguageCatalan MicrosoftTokenizerLanguage = "catalan"
	// MicrosoftTokenizerLanguageChineseSimplified ...
	MicrosoftTokenizerLanguageChineseSimplified MicrosoftTokenizerLanguage = "chineseSimplified"
	// MicrosoftTokenizerLanguageChineseTraditional ...
	MicrosoftTokenizerLanguageChineseTraditional MicrosoftTokenizerLanguage = "chineseTraditional"
	// MicrosoftTokenizerLanguageCroatian ...
	MicrosoftTokenizerLanguageCroatian MicrosoftTokenizerLanguage = "croatian"
	// MicrosoftTokenizerLanguageCzech ...
	MicrosoftTokenizerLanguageCzech MicrosoftTokenizerLanguage = "czech"
	// MicrosoftTokenizerLanguageDanish ...
	MicrosoftTokenizerLanguageDanish MicrosoftTokenizerLanguage = "danish"
	// MicrosoftTokenizerLanguageDutch ...
	MicrosoftTokenizerLanguageDutch MicrosoftTokenizerLanguage = "dutch"
	// MicrosoftTokenizerLanguageEnglish ...
	MicrosoftTokenizerLanguageEnglish MicrosoftTokenizerLanguage = "english"
	// MicrosoftTokenizerLanguageFrench ...
	MicrosoftTokenizerLanguageFrench MicrosoftTokenizerLanguage = "french"
	// MicrosoftTokenizerLanguageGerman ...
	MicrosoftTokenizerLanguageGerman MicrosoftTokenizerLanguage = "german"
	// MicrosoftTokenizerLanguageGreek ...
	MicrosoftTokenizerLanguageGreek MicrosoftTokenizerLanguage = "greek"
	// MicrosoftTokenizerLanguageGujarati ...
	MicrosoftTokenizerLanguageGujarati MicrosoftTokenizerLanguage = "gujarati"
	// MicrosoftTokenizerLanguageHindi ...
	MicrosoftTokenizerLanguageHindi MicrosoftTokenizerLanguage = "hindi"
	// MicrosoftTokenizerLanguageIcelandic ...
	MicrosoftTokenizerLanguageIcelandic MicrosoftTokenizerLanguage = "icelandic"
	// MicrosoftTokenizerLanguageIndonesian ...
	MicrosoftTokenizerLanguageIndonesian MicrosoftTokenizerLanguage = "indonesian"
	// MicrosoftTokenizerLanguageItalian ...
	MicrosoftTokenizerLanguageItalian MicrosoftTokenizerLanguage = "italian"
	// MicrosoftTokenizerLanguageJapanese ...
	MicrosoftTokenizerLanguageJapanese MicrosoftTokenizerLanguage = "japanese"
	// MicrosoftTokenizerLanguageKannada ...
	MicrosoftTokenizerLanguageKannada MicrosoftTokenizerLanguage = "kannada"
	// MicrosoftTokenizerLanguageKorean ...
	MicrosoftTokenizerLanguageKorean MicrosoftTokenizerLanguage = "korean"
	// MicrosoftTokenizerLanguageMalay ...
	MicrosoftTokenizerLanguageMalay MicrosoftTokenizerLanguage = "malay"
	// MicrosoftTokenizerLanguageMalayalam ...
	MicrosoftTokenizerLanguageMalayalam MicrosoftTokenizerLanguage = "malayalam"
	// MicrosoftTokenizerLanguageMarathi ...
	MicrosoftTokenizerLanguageMarathi MicrosoftTokenizerLanguage = "marathi"
	// MicrosoftTokenizerLanguageNorwegianBokmaal ...
	MicrosoftTokenizerLanguageNorwegianBokmaal MicrosoftTokenizerLanguage = "norwegianBokmaal"
	// MicrosoftTokenizerLanguagePolish ...
	MicrosoftTokenizerLanguagePolish MicrosoftTokenizerLanguage = "polish"
	// MicrosoftTokenizerLanguagePortuguese ...
	MicrosoftTokenizerLanguagePortuguese MicrosoftTokenizerLanguage = "portuguese"
	// MicrosoftTokenizerLanguagePortugueseBrazilian ...
	MicrosoftTokenizerLanguagePortugueseBrazilian MicrosoftTokenizerLanguage = "portugueseBrazilian"
	// MicrosoftTokenizerLanguagePunjabi ...
	MicrosoftTokenizerLanguagePunjabi MicrosoftTokenizerLanguage = "punjabi"
	// MicrosoftTokenizerLanguageRomanian ...
	MicrosoftTokenizerLanguageRomanian MicrosoftTokenizerLanguage = "romanian"
	// MicrosoftTokenizerLanguageRussian ...
	MicrosoftTokenizerLanguageRussian MicrosoftTokenizerLanguage = "russian"
	// MicrosoftTokenizerLanguageSerbianCyrillic ...
	MicrosoftTokenizerLanguageSerbianCyrillic MicrosoftTokenizerLanguage = "serbianCyrillic"
	// MicrosoftTokenizerLanguageSerbianLatin ...
	MicrosoftTokenizerLanguageSerbianLatin MicrosoftTokenizerLanguage = "serbianLatin"
	// MicrosoftTokenizerLanguageSlovenian ...
	MicrosoftTokenizerLanguageSlovenian MicrosoftTokenizerLanguage = "slovenian"
	// MicrosoftTokenizerLanguageSpanish ...
	MicrosoftTokenizerLanguageSpanish MicrosoftTokenizerLanguage = "spanish"
	// MicrosoftTokenizerLanguageSwedish ...
	MicrosoftTokenizerLanguageSwedish MicrosoftTokenizerLanguage = "swedish"
	// MicrosoftTokenizerLanguageTamil ...
	MicrosoftTokenizerLanguageTamil MicrosoftTokenizerLanguage = "tamil"
	// MicrosoftTokenizerLanguageTelugu ...
	MicrosoftTokenizerLanguageTelugu MicrosoftTokenizerLanguage = "telugu"
	// MicrosoftTokenizerLanguageThai ...
	MicrosoftTokenizerLanguageThai MicrosoftTokenizerLanguage = "thai"
	// MicrosoftTokenizerLanguageUkrainian ...
	MicrosoftTokenizerLanguageUkrainian MicrosoftTokenizerLanguage = "ukrainian"
	// MicrosoftTokenizerLanguageUrdu ...
	MicrosoftTokenizerLanguageUrdu MicrosoftTokenizerLanguage = "urdu"
	// MicrosoftTokenizerLanguageVietnamese ...
	MicrosoftTokenizerLanguageVietnamese MicrosoftTokenizerLanguage = "vietnamese"
)

// Mode enumerates the values for mode.
type Mode string

const (
	// All ...
	All Mode = "all"
	// Any ...
	Any Mode = "any"
)

// OdataType enumerates the values for odata type.
type OdataType string

const (
	// OdataTypeAnalyzer ...
	OdataTypeAnalyzer OdataType = "Analyzer"
	// OdataTypeMicrosoftAzureSearchCustomAnalyzer ...
	OdataTypeMicrosoftAzureSearchCustomAnalyzer OdataType = "#Microsoft.Azure.Search.CustomAnalyzer"
	// OdataTypeMicrosoftAzureSearchPatternAnalyzer ...
	OdataTypeMicrosoftAzureSearchPatternAnalyzer OdataType = "#Microsoft.Azure.Search.PatternAnalyzer"
	// OdataTypeMicrosoftAzureSearchStandardAnalyzer ...
	OdataTypeMicrosoftAzureSearchStandardAnalyzer OdataType = "#Microsoft.Azure.Search.StandardAnalyzer"
	// OdataTypeMicrosoftAzureSearchStopAnalyzer ...
	OdataTypeMicrosoftAzureSearchStopAnalyzer OdataType = "#Microsoft.Azure.Search.StopAnalyzer"
)

// OdataTypeBasicCharFilter enumerates the values for odata type basic char filter.
type OdataTypeBasicCharFilter string

const (
	// OdataTypeCharFilter ...
	OdataTypeCharFilter OdataTypeBasicCharFilter = "CharFilter"
	// OdataTypeMicrosoftAzureSearchMappingCharFilter ...
	OdataTypeMicrosoftAzureSearchMappingCharFilter OdataTypeBasicCharFilter = "#Microsoft.Azure.Search.MappingCharFilter"
	// OdataTypeMicrosoftAzureSearchPatternReplaceCharFilter ...
	OdataTypeMicrosoftAzureSearchPatternReplaceCharFilter OdataTypeBasicCharFilter = "#Microsoft.Azure.Search.PatternReplaceCharFilter"
)

// OdataTypeBasicDataChangeDetectionPolicy enumerates the values for odata type basic data change detection policy.
type OdataTypeBasicDataChangeDetectionPolicy string

const (
	// OdataTypeDataChangeDetectionPolicy ...
	OdataTypeDataChangeDetectionPolicy OdataTypeBasicDataChangeDetectionPolicy = "DataChangeDetectionPolicy"
	// OdataTypeMicrosoftAzureSearchHighWaterMarkChangeDetectionPolicy ...
	OdataTypeMicrosoftAzureSearchHighWaterMarkChangeDetectionPolicy OdataTypeBasicDataChangeDetectionPolicy = "#Microsoft.Azure.Search.HighWaterMarkChangeDetectionPolicy"
	// OdataTypeMicrosoftAzureSearchSQLIntegratedChangeTrackingPolicy ...
	OdataTypeMicrosoftAzureSearchSQLIntegratedChangeTrackingPolicy OdataTypeBasicDataChangeDetectionPolicy = "#Microsoft.Azure.Search.SqlIntegratedChangeTrackingPolicy"
)

// OdataTypeBasicDataDeletionDetectionPolicy enumerates the values for odata type basic data deletion detection policy.
type OdataTypeBasicDataDeletionDetectionPolicy string

const (
	// OdataTypeDataDeletionDetectionPolicy ...
	OdataTypeDataDeletionDetectionPolicy OdataTypeBasicDataDeletionDetectionPolicy = "DataDeletionDetectionPolicy"
	// OdataTypeMicrosoftAzureSearchSoftDeleteColumnDeletionDetectionPolicy ...
	OdataTypeMicrosoftAzureSearchSoftDeleteColumnDeletionDetectionPolicy OdataTypeBasicDataDeletionDetectionPolicy = "#Microsoft.Azure.Search.SoftDeleteColumnDeletionDetectionPolicy"
)

// OdataTypeBasicTokenFilter enumerates the values for odata type basic token filter.
type OdataTypeBasicTokenFilter string

const (
	// OdataTypeMicrosoftAzureSearchASCIIFoldingTokenFilter ...
	OdataTypeMicrosoftAzureSearchASCIIFoldingTokenFilter OdataTypeBasicTokenFilter = "#Microsoft.Azure.Search.AsciiFoldingTokenFilter"
	// OdataTypeMicrosoftAzureSearchCjkBigramTokenFilter ...
	OdataTypeMicrosoftAzureSearchCjkBigramTokenFilter OdataTypeBasicTokenFilter = "#Microsoft.Azure.Search.CjkBigramTokenFilter"
	// OdataTypeMicrosoftAzureSearchCommonGramTokenFilter ...
	OdataTypeMicrosoftAzureSearchCommonGramTokenFilter OdataTypeBasicTokenFilter = "#Microsoft.Azure.Search.CommonGramTokenFilter"
	// OdataTypeMicrosoftAzureSearchDictionaryDecompounderTokenFilter ...
	OdataTypeMicrosoftAzureSearchDictionaryDecompounderTokenFilter OdataTypeBasicTokenFilter = "#Microsoft.Azure.Search.DictionaryDecompounderTokenFilter"
	// OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilter ...
	OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilter OdataTypeBasicTokenFilter = "#Microsoft.Azure.Search.EdgeNGramTokenFilter"
	// OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilterV2 ...
	OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilterV2 OdataTypeBasicTokenFilter = "#Microsoft.Azure.Search.EdgeNGramTokenFilterV2"
	// OdataTypeMicrosoftAzureSearchElisionTokenFilter ...
	OdataTypeMicrosoftAzureSearchElisionTokenFilter OdataTypeBasicTokenFilter = "#Microsoft.Azure.Search.ElisionTokenFilter"
	// OdataTypeMicrosoftAzureSearchKeepTokenFilter ...
	OdataTypeMicrosoftAzureSearchKeepTokenFilter OdataTypeBasicTokenFilter = "#Microsoft.Azure.Search.KeepTokenFilter"
	// OdataTypeMicrosoftAzureSearchKeywordMarkerTokenFilter ...
	OdataTypeMicrosoftAzureSearchKeywordMarkerTokenFilter OdataTypeBasicTokenFilter = "#Microsoft.Azure.Search.KeywordMarkerTokenFilter"
	// OdataTypeMicrosoftAzureSearchLengthTokenFilter ...
	OdataTypeMicrosoftAzureSearchLengthTokenFilter OdataTypeBasicTokenFilter = "#Microsoft.Azure.Search.LengthTokenFilter"
	// OdataTypeMicrosoftAzureSearchLimitTokenFilter ...
	OdataTypeMicrosoftAzureSearchLimitTokenFilter OdataTypeBasicTokenFilter = "#Microsoft.Azure.Search.LimitTokenFilter"
	// OdataTypeMicrosoftAzureSearchNGramTokenFilter ...
	OdataTypeMicrosoftAzureSearchNGramTokenFilter OdataTypeBasicTokenFilter = "#Microsoft.Azure.Search.NGramTokenFilter"
	// OdataTypeMicrosoftAzureSearchNGramTokenFilterV2 ...
	OdataTypeMicrosoftAzureSearchNGramTokenFilterV2 OdataTypeBasicTokenFilter = "#Microsoft.Azure.Search.NGramTokenFilterV2"
	// OdataTypeMicrosoftAzureSearchPatternCaptureTokenFilter ...
	OdataTypeMicrosoftAzureSearchPatternCaptureTokenFilter OdataTypeBasicTokenFilter = "#Microsoft.Azure.Search.PatternCaptureTokenFilter"
	// OdataTypeMicrosoftAzureSearchPatternReplaceTokenFilter ...
	OdataTypeMicrosoftAzureSearchPatternReplaceTokenFilter OdataTypeBasicTokenFilter = "#Microsoft.Azure.Search.PatternReplaceTokenFilter"
	// OdataTypeMicrosoftAzureSearchPhoneticTokenFilter ...
	OdataTypeMicrosoftAzureSearchPhoneticTokenFilter OdataTypeBasicTokenFilter = "#Microsoft.Azure.Search.PhoneticTokenFilter"
	// OdataTypeMicrosoftAzureSearchShingleTokenFilter ...
	OdataTypeMicrosoftAzureSearchShingleTokenFilter OdataTypeBasicTokenFilter = "#Microsoft.Azure.Search.ShingleTokenFilter"
	// OdataTypeMicrosoftAzureSearchSnowballTokenFilter ...
	OdataTypeMicrosoftAzureSearchSnowballTokenFilter OdataTypeBasicTokenFilter = "#Microsoft.Azure.Search.SnowballTokenFilter"
	// OdataTypeMicrosoftAzureSearchStemmerOverrideTokenFilter ...
	OdataTypeMicrosoftAzureSearchStemmerOverrideTokenFilter OdataTypeBasicTokenFilter = "#Microsoft.Azure.Search.StemmerOverrideTokenFilter"
	// OdataTypeMicrosoftAzureSearchStemmerTokenFilter ...
	OdataTypeMicrosoftAzureSearchStemmerTokenFilter OdataTypeBasicTokenFilter = "#Microsoft.Azure.Search.StemmerTokenFilter"
	// OdataTypeMicrosoftAzureSearchStopwordsTokenFilter ...
	OdataTypeMicrosoftAzureSearchStopwordsTokenFilter OdataTypeBasicTokenFilter = "#Microsoft.Azure.Search.StopwordsTokenFilter"
	// OdataTypeMicrosoftAzureSearchSynonymTokenFilter ...
	OdataTypeMicrosoftAzureSearchSynonymTokenFilter OdataTypeBasicTokenFilter = "#Microsoft.Azure.Search.SynonymTokenFilter"
	// OdataTypeMicrosoftAzureSearchTruncateTokenFilter ...
	OdataTypeMicrosoftAzureSearchTruncateTokenFilter OdataTypeBasicTokenFilter = "#Microsoft.Azure.Search.TruncateTokenFilter"
	// OdataTypeMicrosoftAzureSearchUniqueTokenFilter ...
	OdataTypeMicrosoftAzureSearchUniqueTokenFilter OdataTypeBasicTokenFilter = "#Microsoft.Azure.Search.UniqueTokenFilter"
	// OdataTypeMicrosoftAzureSearchWordDelimiterTokenFilter ...
	OdataTypeMicrosoftAzureSearchWordDelimiterTokenFilter OdataTypeBasicTokenFilter = "#Microsoft.Azure.Search.WordDelimiterTokenFilter"
	// OdataTypeTokenFilter ...
	OdataTypeTokenFilter OdataTypeBasicTokenFilter = "TokenFilter"
)

// OdataTypeBasicTokenizer enumerates the values for odata type basic tokenizer.
type OdataTypeBasicTokenizer string

const (
	// OdataTypeMicrosoftAzureSearchClassicTokenizer ...
	OdataTypeMicrosoftAzureSearchClassicTokenizer OdataTypeBasicTokenizer = "#Microsoft.Azure.Search.ClassicTokenizer"
	// OdataTypeMicrosoftAzureSearchEdgeNGramTokenizer ...
	OdataTypeMicrosoftAzureSearchEdgeNGramTokenizer OdataTypeBasicTokenizer = "#Microsoft.Azure.Search.EdgeNGramTokenizer"
	// OdataTypeMicrosoftAzureSearchKeywordTokenizer ...
	OdataTypeMicrosoftAzureSearchKeywordTokenizer OdataTypeBasicTokenizer = "#Microsoft.Azure.Search.KeywordTokenizer"
	// OdataTypeMicrosoftAzureSearchKeywordTokenizerV2 ...
	OdataTypeMicrosoftAzureSearchKeywordTokenizerV2 OdataTypeBasicTokenizer = "#Microsoft.Azure.Search.KeywordTokenizerV2"
	// OdataTypeMicrosoftAzureSearchMicrosoftLanguageStemmingTokenizer ...
	OdataTypeMicrosoftAzureSearchMicrosoftLanguageStemmingTokenizer OdataTypeBasicTokenizer = "#Microsoft.Azure.Search.MicrosoftLanguageStemmingTokenizer"
	// OdataTypeMicrosoftAzureSearchMicrosoftLanguageTokenizer ...
	OdataTypeMicrosoftAzureSearchMicrosoftLanguageTokenizer OdataTypeBasicTokenizer = "#Microsoft.Azure.Search.MicrosoftLanguageTokenizer"
	// OdataTypeMicrosoftAzureSearchNGramTokenizer ...
	OdataTypeMicrosoftAzureSearchNGramTokenizer OdataTypeBasicTokenizer = "#Microsoft.Azure.Search.NGramTokenizer"
	// OdataTypeMicrosoftAzureSearchPathHierarchyTokenizer ...
	OdataTypeMicrosoftAzureSearchPathHierarchyTokenizer OdataTypeBasicTokenizer = "#Microsoft.Azure.Search.PathHierarchyTokenizer"
	// OdataTypeMicrosoftAzureSearchPathHierarchyTokenizerV2 ...
	OdataTypeMicrosoftAzureSearchPathHierarchyTokenizerV2 OdataTypeBasicTokenizer = "#Microsoft.Azure.Search.PathHierarchyTokenizerV2"
	// OdataTypeMicrosoftAzureSearchPatternTokenizer ...
	OdataTypeMicrosoftAzureSearchPatternTokenizer OdataTypeBasicTokenizer = "#Microsoft.Azure.Search.PatternTokenizer"
	// OdataTypeMicrosoftAzureSearchStandardTokenizer ...
	OdataTypeMicrosoftAzureSearchStandardTokenizer OdataTypeBasicTokenizer = "#Microsoft.Azure.Search.StandardTokenizer"
	// OdataTypeMicrosoftAzureSearchStandardTokenizerV2 ...
	OdataTypeMicrosoftAzureSearchStandardTokenizerV2 OdataTypeBasicTokenizer = "#Microsoft.Azure.Search.StandardTokenizerV2"
	// OdataTypeMicrosoftAzureSearchUaxURLEmailTokenizer ...
	OdataTypeMicrosoftAzureSearchUaxURLEmailTokenizer OdataTypeBasicTokenizer = "#Microsoft.Azure.Search.UaxUrlEmailTokenizer"
	// OdataTypeTokenizer ...
	OdataTypeTokenizer OdataTypeBasicTokenizer = "Tokenizer"
)

// PhoneticEncoder enumerates the values for phonetic encoder.
type PhoneticEncoder string

const (
	// BeiderMorse ...
	BeiderMorse PhoneticEncoder = "beiderMorse"
	// Caverphone1 ...
	Caverphone1 PhoneticEncoder = "caverphone1"
	// Caverphone2 ...
	Caverphone2 PhoneticEncoder = "caverphone2"
	// Cologne ...
	Cologne PhoneticEncoder = "cologne"
	// DoubleMetaphone ...
	DoubleMetaphone PhoneticEncoder = "doubleMetaphone"
	// HaasePhonetik ...
	HaasePhonetik PhoneticEncoder = "haasePhonetik"
	// KoelnerPhonetik ...
	KoelnerPhonetik PhoneticEncoder = "koelnerPhonetik"
	// Metaphone ...
	Metaphone PhoneticEncoder = "metaphone"
	// Nysiis ...
	Nysiis PhoneticEncoder = "nysiis"
	// RefinedSoundex ...
	RefinedSoundex PhoneticEncoder = "refinedSoundex"
	// Soundex ...
	Soundex PhoneticEncoder = "soundex"
)

// QueryType enumerates the values for query type.
type QueryType string

const (
	// Full ...
	Full QueryType = "full"
	// Simple ...
	Simple QueryType = "simple"
)

// ScoringFunctionAggregation enumerates the values for scoring function aggregation.
type ScoringFunctionAggregation string

const (
	// Average ...
	Average ScoringFunctionAggregation = "average"
	// FirstMatching ...
	FirstMatching ScoringFunctionAggregation = "firstMatching"
	// Maximum ...
	Maximum ScoringFunctionAggregation = "maximum"
	// Minimum ...
	Minimum ScoringFunctionAggregation = "minimum"
	// Sum ...
	Sum ScoringFunctionAggregation = "sum"
)

// ScoringFunctionInterpolation enumerates the values for scoring function interpolation.
type ScoringFunctionInterpolation string

const (
	// Constant ...
	Constant ScoringFunctionInterpolation = "constant"
	// Linear ...
	Linear ScoringFunctionInterpolation = "linear"
	// Logarithmic ...
	Logarithmic ScoringFunctionInterpolation = "logarithmic"
	// Quadratic ...
	Quadratic ScoringFunctionInterpolation = "quadratic"
)

// SnowballTokenFilterLanguage enumerates the values for snowball token filter language.
type SnowballTokenFilterLanguage string

const (
	// SnowballTokenFilterLanguageArmenian ...
	SnowballTokenFilterLanguageArmenian SnowballTokenFilterLanguage = "armenian"
	// SnowballTokenFilterLanguageBasque ...
	SnowballTokenFilterLanguageBasque SnowballTokenFilterLanguage = "basque"
	// SnowballTokenFilterLanguageCatalan ...
	SnowballTokenFilterLanguageCatalan SnowballTokenFilterLanguage = "catalan"
	// SnowballTokenFilterLanguageDanish ...
	SnowballTokenFilterLanguageDanish SnowballTokenFilterLanguage = "danish"
	// SnowballTokenFilterLanguageDutch ...
	SnowballTokenFilterLanguageDutch SnowballTokenFilterLanguage = "dutch"
	// SnowballTokenFilterLanguageEnglish ...
	SnowballTokenFilterLanguageEnglish SnowballTokenFilterLanguage = "english"
	// SnowballTokenFilterLanguageFinnish ...
	SnowballTokenFilterLanguageFinnish SnowballTokenFilterLanguage = "finnish"
	// SnowballTokenFilterLanguageFrench ...
	SnowballTokenFilterLanguageFrench SnowballTokenFilterLanguage = "french"
	// SnowballTokenFilterLanguageGerman ...
	SnowballTokenFilterLanguageGerman SnowballTokenFilterLanguage = "german"
	// SnowballTokenFilterLanguageGerman2 ...
	SnowballTokenFilterLanguageGerman2 SnowballTokenFilterLanguage = "german2"
	// SnowballTokenFilterLanguageHungarian ...
	SnowballTokenFilterLanguageHungarian SnowballTokenFilterLanguage = "hungarian"
	// SnowballTokenFilterLanguageItalian ...
	SnowballTokenFilterLanguageItalian SnowballTokenFilterLanguage = "italian"
	// SnowballTokenFilterLanguageKp ...
	SnowballTokenFilterLanguageKp SnowballTokenFilterLanguage = "kp"
	// SnowballTokenFilterLanguageLovins ...
	SnowballTokenFilterLanguageLovins SnowballTokenFilterLanguage = "lovins"
	// SnowballTokenFilterLanguageNorwegian ...
	SnowballTokenFilterLanguageNorwegian SnowballTokenFilterLanguage = "norwegian"
	// SnowballTokenFilterLanguagePorter ...
	SnowballTokenFilterLanguagePorter SnowballTokenFilterLanguage = "porter"
	// SnowballTokenFilterLanguagePortuguese ...
	SnowballTokenFilterLanguagePortuguese SnowballTokenFilterLanguage = "portuguese"
	// SnowballTokenFilterLanguageRomanian ...
	SnowballTokenFilterLanguageRomanian SnowballTokenFilterLanguage = "romanian"
	// SnowballTokenFilterLanguageRussian ...
	SnowballTokenFilterLanguageRussian SnowballTokenFilterLanguage = "russian"
	// SnowballTokenFilterLanguageSpanish ...
	SnowballTokenFilterLanguageSpanish SnowballTokenFilterLanguage = "spanish"
	// SnowballTokenFilterLanguageSwedish ...
	SnowballTokenFilterLanguageSwedish SnowballTokenFilterLanguage = "swedish"
	// SnowballTokenFilterLanguageTurkish ...
	SnowballTokenFilterLanguageTurkish SnowballTokenFilterLanguage = "turkish"
)

// StemmerTokenFilterLanguage enumerates the values for stemmer token filter language.
type StemmerTokenFilterLanguage string

const (
	// StemmerTokenFilterLanguageArabic ...
	StemmerTokenFilterLanguageArabic StemmerTokenFilterLanguage = "arabic"
	// StemmerTokenFilterLanguageArmenian ...
	StemmerTokenFilterLanguageArmenian StemmerTokenFilterLanguage = "armenian"
	// StemmerTokenFilterLanguageBasque ...
	StemmerTokenFilterLanguageBasque StemmerTokenFilterLanguage = "basque"
	// StemmerTokenFilterLanguageBrazilian ...
	StemmerTokenFilterLanguageBrazilian StemmerTokenFilterLanguage = "brazilian"
	// StemmerTokenFilterLanguageBulgarian ...
	StemmerTokenFilterLanguageBulgarian StemmerTokenFilterLanguage = "bulgarian"
	// StemmerTokenFilterLanguageCatalan ...
	StemmerTokenFilterLanguageCatalan StemmerTokenFilterLanguage = "catalan"
	// StemmerTokenFilterLanguageCzech ...
	StemmerTokenFilterLanguageCzech StemmerTokenFilterLanguage = "czech"
	// StemmerTokenFilterLanguageDanish ...
	StemmerTokenFilterLanguageDanish StemmerTokenFilterLanguage = "danish"
	// StemmerTokenFilterLanguageDutch ...
	StemmerTokenFilterLanguageDutch StemmerTokenFilterLanguage = "dutch"
	// StemmerTokenFilterLanguageDutchKp ...
	StemmerTokenFilterLanguageDutchKp StemmerTokenFilterLanguage = "dutchKp"
	// StemmerTokenFilterLanguageEnglish ...
	StemmerTokenFilterLanguageEnglish StemmerTokenFilterLanguage = "english"
	// StemmerTokenFilterLanguageFinnish ...
	StemmerTokenFilterLanguageFinnish StemmerTokenFilterLanguage = "finnish"
	// StemmerTokenFilterLanguageFrench ...
	StemmerTokenFilterLanguageFrench StemmerTokenFilterLanguage = "french"
	// StemmerTokenFilterLanguageGalician ...
	StemmerTokenFilterLanguageGalician StemmerTokenFilterLanguage = "galician"
	// StemmerTokenFilterLanguageGerman ...
	StemmerTokenFilterLanguageGerman StemmerTokenFilterLanguage = "german"
	// StemmerTokenFilterLanguageGerman2 ...
	StemmerTokenFilterLanguageGerman2 StemmerTokenFilterLanguage = "german2"
	// StemmerTokenFilterLanguageGreek ...
	StemmerTokenFilterLanguageGreek StemmerTokenFilterLanguage = "greek"
	// StemmerTokenFilterLanguageHindi ...
	StemmerTokenFilterLanguageHindi StemmerTokenFilterLanguage = "hindi"
	// StemmerTokenFilterLanguageHungarian ...
	StemmerTokenFilterLanguageHungarian StemmerTokenFilterLanguage = "hungarian"
	// StemmerTokenFilterLanguageIndonesian ...
	StemmerTokenFilterLanguageIndonesian StemmerTokenFilterLanguage = "indonesian"
	// StemmerTokenFilterLanguageIrish ...
	StemmerTokenFilterLanguageIrish StemmerTokenFilterLanguage = "irish"
	// StemmerTokenFilterLanguageItalian ...
	StemmerTokenFilterLanguageItalian StemmerTokenFilterLanguage = "italian"
	// StemmerTokenFilterLanguageLatvian ...
	StemmerTokenFilterLanguageLatvian StemmerTokenFilterLanguage = "latvian"
	// StemmerTokenFilterLanguageLightEnglish ...
	StemmerTokenFilterLanguageLightEnglish StemmerTokenFilterLanguage = "lightEnglish"
	// StemmerTokenFilterLanguageLightFinnish ...
	StemmerTokenFilterLanguageLightFinnish StemmerTokenFilterLanguage = "lightFinnish"
	// StemmerTokenFilterLanguageLightFrench ...
	StemmerTokenFilterLanguageLightFrench StemmerTokenFilterLanguage = "lightFrench"
	// StemmerTokenFilterLanguageLightGerman ...
	StemmerTokenFilterLanguageLightGerman StemmerTokenFilterLanguage = "lightGerman"
	// StemmerTokenFilterLanguageLightHungarian ...
	StemmerTokenFilterLanguageLightHungarian StemmerTokenFilterLanguage = "lightHungarian"
	// StemmerTokenFilterLanguageLightItalian ...
	StemmerTokenFilterLanguageLightItalian StemmerTokenFilterLanguage = "lightItalian"
	// StemmerTokenFilterLanguageLightNorwegian ...
	StemmerTokenFilterLanguageLightNorwegian StemmerTokenFilterLanguage = "lightNorwegian"
	// StemmerTokenFilterLanguageLightNynorsk ...
	StemmerTokenFilterLanguageLightNynorsk StemmerTokenFilterLanguage = "lightNynorsk"
	// StemmerTokenFilterLanguageLightPortuguese ...
	StemmerTokenFilterLanguageLightPortuguese StemmerTokenFilterLanguage = "lightPortuguese"
	// StemmerTokenFilterLanguageLightRussian ...
	StemmerTokenFilterLanguageLightRussian StemmerTokenFilterLanguage = "lightRussian"
	// StemmerTokenFilterLanguageLightSpanish ...
	StemmerTokenFilterLanguageLightSpanish StemmerTokenFilterLanguage = "lightSpanish"
	// StemmerTokenFilterLanguageLightSwedish ...
	StemmerTokenFilterLanguageLightSwedish StemmerTokenFilterLanguage = "lightSwedish"
	// StemmerTokenFilterLanguageLovins ...
	StemmerTokenFilterLanguageLovins StemmerTokenFilterLanguage = "lovins"
	// StemmerTokenFilterLanguageMinimalEnglish ...
	StemmerTokenFilterLanguageMinimalEnglish StemmerTokenFilterLanguage = "minimalEnglish"
	// StemmerTokenFilterLanguageMinimalFrench ...
	StemmerTokenFilterLanguageMinimalFrench StemmerTokenFilterLanguage = "minimalFrench"
	// StemmerTokenFilterLanguageMinimalGalician ...
	StemmerTokenFilterLanguageMinimalGalician StemmerTokenFilterLanguage = "minimalGalician"
	// StemmerTokenFilterLanguageMinimalGerman ...
	StemmerTokenFilterLanguageMinimalGerman StemmerTokenFilterLanguage = "minimalGerman"
	// StemmerTokenFilterLanguageMinimalNorwegian ...
	StemmerTokenFilterLanguageMinimalNorwegian StemmerTokenFilterLanguage = "minimalNorwegian"
	// StemmerTokenFilterLanguageMinimalNynorsk ...
	StemmerTokenFilterLanguageMinimalNynorsk StemmerTokenFilterLanguage = "minimalNynorsk"
	// StemmerTokenFilterLanguageMinimalPortuguese ...
	StemmerTokenFilterLanguageMinimalPortuguese StemmerTokenFilterLanguage = "minimalPortuguese"
	// StemmerTokenFilterLanguageNorwegian ...
	StemmerTokenFilterLanguageNorwegian StemmerTokenFilterLanguage = "norwegian"
	// StemmerTokenFilterLanguagePorter2 ...
	StemmerTokenFilterLanguagePorter2 StemmerTokenFilterLanguage = "porter2"
	// StemmerTokenFilterLanguagePortuguese ...
	StemmerTokenFilterLanguagePortuguese StemmerTokenFilterLanguage = "portuguese"
	// StemmerTokenFilterLanguagePortugueseRslp ...
	StemmerTokenFilterLanguagePortugueseRslp StemmerTokenFilterLanguage = "portugueseRslp"
	// StemmerTokenFilterLanguagePossessiveEnglish ...
	StemmerTokenFilterLanguagePossessiveEnglish StemmerTokenFilterLanguage = "possessiveEnglish"
	// StemmerTokenFilterLanguageRomanian ...
	StemmerTokenFilterLanguageRomanian StemmerTokenFilterLanguage = "romanian"
	// StemmerTokenFilterLanguageRussian ...
	StemmerTokenFilterLanguageRussian StemmerTokenFilterLanguage = "russian"
	// StemmerTokenFilterLanguageSorani ...
	StemmerTokenFilterLanguageSorani StemmerTokenFilterLanguage = "sorani"
	// StemmerTokenFilterLanguageSpanish ...
	StemmerTokenFilterLanguageSpanish StemmerTokenFilterLanguage = "spanish"
	// StemmerTokenFilterLanguageSwedish ...
	StemmerTokenFilterLanguageSwedish StemmerTokenFilterLanguage = "swedish"
	// StemmerTokenFilterLanguageTurkish ...
	StemmerTokenFilterLanguageTurkish StemmerTokenFilterLanguage = "turkish"
)

// StopwordsList enumerates the values for stopwords list.
type StopwordsList string

const (
	// StopwordsListArabic ...
	StopwordsListArabic StopwordsList = "arabic"
	// StopwordsListArmenian ...
	StopwordsListArmenian StopwordsList = "armenian"
	// StopwordsListBasque ...
	StopwordsListBasque StopwordsList = "basque"
	// StopwordsListBrazilian ...
	StopwordsListBrazilian StopwordsList = "brazilian"
	// StopwordsListBulgarian ...
	StopwordsListBulgarian StopwordsList = "bulgarian"
	// StopwordsListCatalan ...
	StopwordsListCatalan StopwordsList = "catalan"
	// StopwordsListCzech ...
	StopwordsListCzech StopwordsList = "czech"
	// StopwordsListDanish ...
	StopwordsListDanish StopwordsList = "danish"
	// StopwordsListDutch ...
	StopwordsListDutch StopwordsList = "dutch"
	// StopwordsListEnglish ...
	StopwordsListEnglish StopwordsList = "english"
	// StopwordsListFinnish ...
	StopwordsListFinnish StopwordsList = "finnish"
	// StopwordsListFrench ...
	StopwordsListFrench StopwordsList = "french"
	// StopwordsListGalician ...
	StopwordsListGalician StopwordsList = "galician"
	// StopwordsListGerman ...
	StopwordsListGerman StopwordsList = "german"
	// StopwordsListGreek ...
	StopwordsListGreek StopwordsList = "greek"
	// StopwordsListHindi ...
	StopwordsListHindi StopwordsList = "hindi"
	// StopwordsListHungarian ...
	StopwordsListHungarian StopwordsList = "hungarian"
	// StopwordsListIndonesian ...
	StopwordsListIndonesian StopwordsList = "indonesian"
	// StopwordsListIrish ...
	StopwordsListIrish StopwordsList = "irish"
	// StopwordsListItalian ...
	StopwordsListItalian StopwordsList = "italian"
	// StopwordsListLatvian ...
	StopwordsListLatvian StopwordsList = "latvian"
	// StopwordsListNorwegian ...
	StopwordsListNorwegian StopwordsList = "norwegian"
	// StopwordsListPersian ...
	StopwordsListPersian StopwordsList = "persian"
	// StopwordsListPortuguese ...
	StopwordsListPortuguese StopwordsList = "portuguese"
	// StopwordsListRomanian ...
	StopwordsListRomanian StopwordsList = "romanian"
	// StopwordsListRussian ...
	StopwordsListRussian StopwordsList = "russian"
	// StopwordsListSorani ...
	StopwordsListSorani StopwordsList = "sorani"
	// StopwordsListSpanish ...
	StopwordsListSpanish StopwordsList = "spanish"
	// StopwordsListSwedish ...
	StopwordsListSwedish StopwordsList = "swedish"
	// StopwordsListThai ...
	StopwordsListThai StopwordsList = "thai"
	// StopwordsListTurkish ...
	StopwordsListTurkish StopwordsList = "turkish"
)

// SuggesterSearchMode enumerates the values for suggester search mode.
type SuggesterSearchMode string

const (
	// AnalyzingInfixMatching ...
	AnalyzingInfixMatching SuggesterSearchMode = "analyzingInfixMatching"
)

// TokenCharacterKind enumerates the values for token character kind.
type TokenCharacterKind string

const (
	// Digit ...
	Digit TokenCharacterKind = "digit"
	// Letter ...
	Letter TokenCharacterKind = "letter"
	// Punctuation ...
	Punctuation TokenCharacterKind = "punctuation"
	// Symbol ...
	Symbol TokenCharacterKind = "symbol"
	// Whitespace ...
	Whitespace TokenCharacterKind = "whitespace"
)

// Type enumerates the values for type.
type Type string

const (
	// TypeDistance ...
	TypeDistance Type = "distance"
	// TypeFreshness ...
	TypeFreshness Type = "freshness"
	// TypeMagnitude ...
	TypeMagnitude Type = "magnitude"
	// TypeScoringFunction ...
	TypeScoringFunction Type = "ScoringFunction"
	// TypeTag ...
	TypeTag Type = "tag"
)

// BasicAnalyzer abstract base class for analyzers.
type BasicAnalyzer interface {
	AsCustomAnalyzer() (*CustomAnalyzer, bool)
	AsPatternAnalyzer() (*PatternAnalyzer, bool)
	AsStandardAnalyzer() (*StandardAnalyzer, bool)
	AsStopAnalyzer() (*StopAnalyzer, bool)
	AsAnalyzer() (*Analyzer, bool)
}

// Analyzer abstract base class for analyzers.
type Analyzer struct {
	// Name - The name of the analyzer. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeAnalyzer', 'OdataTypeMicrosoftAzureSearchCustomAnalyzer', 'OdataTypeMicrosoftAzureSearchPatternAnalyzer', 'OdataTypeMicrosoftAzureSearchStandardAnalyzer', 'OdataTypeMicrosoftAzureSearchStopAnalyzer'
	OdataType OdataType `json:"@odata.type,omitempty"`
}

func unmarshalBasicAnalyzer(body []byte) (BasicAnalyzer, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@odata.type"] {
	case string(OdataTypeMicrosoftAzureSearchCustomAnalyzer):
		var ca CustomAnalyzer
		err := json.Unmarshal(body, &ca)
		return ca, err
	case string(OdataTypeMicrosoftAzureSearchPatternAnalyzer):
		var pa PatternAnalyzer
		err := json.Unmarshal(body, &pa)
		return pa, err
	case string(OdataTypeMicrosoftAzureSearchStandardAnalyzer):
		var sa StandardAnalyzer
		err := json.Unmarshal(body, &sa)
		return sa, err
	case string(OdataTypeMicrosoftAzureSearchStopAnalyzer):
		var sa StopAnalyzer
		err := json.Unmarshal(body, &sa)
		return sa, err
	default:
		var a Analyzer
		err := json.Unmarshal(body, &a)
		return a, err
	}
}
func unmarshalBasicAnalyzerArray(body []byte) ([]BasicAnalyzer, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	aArray := make([]BasicAnalyzer, len(rawMessages))

	for index, rawMessage := range rawMessages {
		a, err := unmarshalBasicAnalyzer(*rawMessage)
		if err != nil {
			return nil, err
		}
		aArray[index] = a
	}
	return aArray, nil
}

// MarshalJSON is the custom marshaler for Analyzer.
func (a Analyzer) MarshalJSON() ([]byte, error) {
	a.OdataType = OdataTypeAnalyzer
	type Alias Analyzer
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(a),
	})
}

// AsCustomAnalyzer is the BasicAnalyzer implementation for Analyzer.
func (a Analyzer) AsCustomAnalyzer() (*CustomAnalyzer, bool) {
	return nil, false
}

// AsPatternAnalyzer is the BasicAnalyzer implementation for Analyzer.
func (a Analyzer) AsPatternAnalyzer() (*PatternAnalyzer, bool) {
	return nil, false
}

// AsStandardAnalyzer is the BasicAnalyzer implementation for Analyzer.
func (a Analyzer) AsStandardAnalyzer() (*StandardAnalyzer, bool) {
	return nil, false
}

// AsStopAnalyzer is the BasicAnalyzer implementation for Analyzer.
func (a Analyzer) AsStopAnalyzer() (*StopAnalyzer, bool) {
	return nil, false
}

// AsAnalyzer is the BasicAnalyzer implementation for Analyzer.
func (a Analyzer) AsAnalyzer() (*Analyzer, bool) {
	return &a, true
}

// AsBasicAnalyzer is the BasicAnalyzer implementation for Analyzer.
func (a Analyzer) AsBasicAnalyzer() (BasicAnalyzer, bool) {
	return &a, true
}

// AnalyzeRequest specifies some text and analysis components used to break that text into tokens.
type AnalyzeRequest struct {
	// Text - The text to break into tokens.
	Text *string `json:"text,omitempty"`
	// Analyzer - The name of the analyzer to use to break the given text. If this parameter is not specified, you must specify a tokenizer instead. The tokenizer and analyzer parameters are mutually exclusive.
	Analyzer *AnalyzerName `json:"analyzer,omitempty"`
	// Tokenizer - The name of the tokenizer to use to break the given text. If this parameter is not specified, you must specify an analyzer instead. The tokenizer and analyzer parameters are mutually exclusive.
	Tokenizer *TokenizerName `json:"tokenizer,omitempty"`
	// TokenFilters - An optional list of token filters to use when breaking the given text. This parameter can only be set when using the tokenizer parameter.
	TokenFilters *[]TokenFilterName `json:"tokenFilters,omitempty"`
	// CharFilters - An optional list of character filters to use when breaking the given text. This parameter can only be set when using the tokenizer parameter.
	CharFilters *[]CharFilterName `json:"charFilters,omitempty"`
}

// AnalyzeResult the result of testing an analyzer on text.
type AnalyzeResult struct {
	autorest.Response `json:"-"`
	// Tokens - The list of tokens returned by the analyzer specified in the request.
	Tokens *[]TokenInfo `json:"tokens,omitempty"`
}

// AnalyzerName defines the names of all text analyzers supported by Azure Search.
type AnalyzerName struct {
	Name *string `json:"name,omitempty"`
}

// ASCIIFoldingTokenFilter converts alphabetic, numeric, and symbolic Unicode characters which are not in the first 127
// ASCII characters (the "Basic Latin" Unicode block) into their ASCII equivalents, if such equivalents exist. This
// token filter is implemented using Apache Lucene.
type ASCIIFoldingTokenFilter struct {
	// Name - The name of the token filter. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeTokenFilter', 'OdataTypeMicrosoftAzureSearchASCIIFoldingTokenFilter', 'OdataTypeMicrosoftAzureSearchCjkBigramTokenFilter', 'OdataTypeMicrosoftAzureSearchCommonGramTokenFilter', 'OdataTypeMicrosoftAzureSearchDictionaryDecompounderTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchElisionTokenFilter', 'OdataTypeMicrosoftAzureSearchKeepTokenFilter', 'OdataTypeMicrosoftAzureSearchKeywordMarkerTokenFilter', 'OdataTypeMicrosoftAzureSearchLengthTokenFilter', 'OdataTypeMicrosoftAzureSearchLimitTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchPatternCaptureTokenFilter', 'OdataTypeMicrosoftAzureSearchPatternReplaceTokenFilter', 'OdataTypeMicrosoftAzureSearchPhoneticTokenFilter', 'OdataTypeMicrosoftAzureSearchShingleTokenFilter', 'OdataTypeMicrosoftAzureSearchSnowballTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerOverrideTokenFilter', 'OdataTypeMicrosoftAzureSearchStopwordsTokenFilter', 'OdataTypeMicrosoftAzureSearchSynonymTokenFilter', 'OdataTypeMicrosoftAzureSearchTruncateTokenFilter', 'OdataTypeMicrosoftAzureSearchUniqueTokenFilter', 'OdataTypeMicrosoftAzureSearchWordDelimiterTokenFilter'
	OdataType OdataTypeBasicTokenFilter `json:"@odata.type,omitempty"`
	// PreserveOriginal - A value indicating whether the original token will be kept. Default is false.
	PreserveOriginal *bool `json:"preserveOriginal,omitempty"`
}

// MarshalJSON is the custom marshaler for ASCIIFoldingTokenFilter.
func (aftf ASCIIFoldingTokenFilter) MarshalJSON() ([]byte, error) {
	aftf.OdataType = OdataTypeMicrosoftAzureSearchASCIIFoldingTokenFilter
	type Alias ASCIIFoldingTokenFilter
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(aftf),
	})
}

// AsASCIIFoldingTokenFilter is the BasicTokenFilter implementation for ASCIIFoldingTokenFilter.
func (aftf ASCIIFoldingTokenFilter) AsASCIIFoldingTokenFilter() (*ASCIIFoldingTokenFilter, bool) {
	return &aftf, true
}

// AsCjkBigramTokenFilter is the BasicTokenFilter implementation for ASCIIFoldingTokenFilter.
func (aftf ASCIIFoldingTokenFilter) AsCjkBigramTokenFilter() (*CjkBigramTokenFilter, bool) {
	return nil, false
}

// AsCommonGramTokenFilter is the BasicTokenFilter implementation for ASCIIFoldingTokenFilter.
func (aftf ASCIIFoldingTokenFilter) AsCommonGramTokenFilter() (*CommonGramTokenFilter, bool) {
	return nil, false
}

// AsDictionaryDecompounderTokenFilter is the BasicTokenFilter implementation for ASCIIFoldingTokenFilter.
func (aftf ASCIIFoldingTokenFilter) AsDictionaryDecompounderTokenFilter() (*DictionaryDecompounderTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilter is the BasicTokenFilter implementation for ASCIIFoldingTokenFilter.
func (aftf ASCIIFoldingTokenFilter) AsEdgeNGramTokenFilter() (*EdgeNGramTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilterV2 is the BasicTokenFilter implementation for ASCIIFoldingTokenFilter.
func (aftf ASCIIFoldingTokenFilter) AsEdgeNGramTokenFilterV2() (*EdgeNGramTokenFilterV2, bool) {
	return nil, false
}

// AsElisionTokenFilter is the BasicTokenFilter implementation for ASCIIFoldingTokenFilter.
func (aftf ASCIIFoldingTokenFilter) AsElisionTokenFilter() (*ElisionTokenFilter, bool) {
	return nil, false
}

// AsKeepTokenFilter is the BasicTokenFilter implementation for ASCIIFoldingTokenFilter.
func (aftf ASCIIFoldingTokenFilter) AsKeepTokenFilter() (*KeepTokenFilter, bool) {
	return nil, false
}

// AsKeywordMarkerTokenFilter is the BasicTokenFilter implementation for ASCIIFoldingTokenFilter.
func (aftf ASCIIFoldingTokenFilter) AsKeywordMarkerTokenFilter() (*KeywordMarkerTokenFilter, bool) {
	return nil, false
}

// AsLengthTokenFilter is the BasicTokenFilter implementation for ASCIIFoldingTokenFilter.
func (aftf ASCIIFoldingTokenFilter) AsLengthTokenFilter() (*LengthTokenFilter, bool) {
	return nil, false
}

// AsLimitTokenFilter is the BasicTokenFilter implementation for ASCIIFoldingTokenFilter.
func (aftf ASCIIFoldingTokenFilter) AsLimitTokenFilter() (*LimitTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilter is the BasicTokenFilter implementation for ASCIIFoldingTokenFilter.
func (aftf ASCIIFoldingTokenFilter) AsNGramTokenFilter() (*NGramTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilterV2 is the BasicTokenFilter implementation for ASCIIFoldingTokenFilter.
func (aftf ASCIIFoldingTokenFilter) AsNGramTokenFilterV2() (*NGramTokenFilterV2, bool) {
	return nil, false
}

// AsPatternCaptureTokenFilter is the BasicTokenFilter implementation for ASCIIFoldingTokenFilter.
func (aftf ASCIIFoldingTokenFilter) AsPatternCaptureTokenFilter() (*PatternCaptureTokenFilter, bool) {
	return nil, false
}

// AsPatternReplaceTokenFilter is the BasicTokenFilter implementation for ASCIIFoldingTokenFilter.
func (aftf ASCIIFoldingTokenFilter) AsPatternReplaceTokenFilter() (*PatternReplaceTokenFilter, bool) {
	return nil, false
}

// AsPhoneticTokenFilter is the BasicTokenFilter implementation for ASCIIFoldingTokenFilter.
func (aftf ASCIIFoldingTokenFilter) AsPhoneticTokenFilter() (*PhoneticTokenFilter, bool) {
	return nil, false
}

// AsShingleTokenFilter is the BasicTokenFilter implementation for ASCIIFoldingTokenFilter.
func (aftf ASCIIFoldingTokenFilter) AsShingleTokenFilter() (*ShingleTokenFilter, bool) {
	return nil, false
}

// AsSnowballTokenFilter is the BasicTokenFilter implementation for ASCIIFoldingTokenFilter.
func (aftf ASCIIFoldingTokenFilter) AsSnowballTokenFilter() (*SnowballTokenFilter, bool) {
	return nil, false
}

// AsStemmerTokenFilter is the BasicTokenFilter implementation for ASCIIFoldingTokenFilter.
func (aftf ASCIIFoldingTokenFilter) AsStemmerTokenFilter() (*StemmerTokenFilter, bool) {
	return nil, false
}

// AsStemmerOverrideTokenFilter is the BasicTokenFilter implementation for ASCIIFoldingTokenFilter.
func (aftf ASCIIFoldingTokenFilter) AsStemmerOverrideTokenFilter() (*StemmerOverrideTokenFilter, bool) {
	return nil, false
}

// AsStopwordsTokenFilter is the BasicTokenFilter implementation for ASCIIFoldingTokenFilter.
func (aftf ASCIIFoldingTokenFilter) AsStopwordsTokenFilter() (*StopwordsTokenFilter, bool) {
	return nil, false
}

// AsSynonymTokenFilter is the BasicTokenFilter implementation for ASCIIFoldingTokenFilter.
func (aftf ASCIIFoldingTokenFilter) AsSynonymTokenFilter() (*SynonymTokenFilter, bool) {
	return nil, false
}

// AsTruncateTokenFilter is the BasicTokenFilter implementation for ASCIIFoldingTokenFilter.
func (aftf ASCIIFoldingTokenFilter) AsTruncateTokenFilter() (*TruncateTokenFilter, bool) {
	return nil, false
}

// AsUniqueTokenFilter is the BasicTokenFilter implementation for ASCIIFoldingTokenFilter.
func (aftf ASCIIFoldingTokenFilter) AsUniqueTokenFilter() (*UniqueTokenFilter, bool) {
	return nil, false
}

// AsWordDelimiterTokenFilter is the BasicTokenFilter implementation for ASCIIFoldingTokenFilter.
func (aftf ASCIIFoldingTokenFilter) AsWordDelimiterTokenFilter() (*WordDelimiterTokenFilter, bool) {
	return nil, false
}

// AsTokenFilter is the BasicTokenFilter implementation for ASCIIFoldingTokenFilter.
func (aftf ASCIIFoldingTokenFilter) AsTokenFilter() (*TokenFilter, bool) {
	return nil, false
}

// AsBasicTokenFilter is the BasicTokenFilter implementation for ASCIIFoldingTokenFilter.
func (aftf ASCIIFoldingTokenFilter) AsBasicTokenFilter() (BasicTokenFilter, bool) {
	return &aftf, true
}

// BasicCharFilter abstract base class for character filters.
type BasicCharFilter interface {
	AsMappingCharFilter() (*MappingCharFilter, bool)
	AsPatternReplaceCharFilter() (*PatternReplaceCharFilter, bool)
	AsCharFilter() (*CharFilter, bool)
}

// CharFilter abstract base class for character filters.
type CharFilter struct {
	// Name - The name of the char filter. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeCharFilter', 'OdataTypeMicrosoftAzureSearchMappingCharFilter', 'OdataTypeMicrosoftAzureSearchPatternReplaceCharFilter'
	OdataType OdataTypeBasicCharFilter `json:"@odata.type,omitempty"`
}

func unmarshalBasicCharFilter(body []byte) (BasicCharFilter, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@odata.type"] {
	case string(OdataTypeMicrosoftAzureSearchMappingCharFilter):
		var mcf MappingCharFilter
		err := json.Unmarshal(body, &mcf)
		return mcf, err
	case string(OdataTypeMicrosoftAzureSearchPatternReplaceCharFilter):
		var prcf PatternReplaceCharFilter
		err := json.Unmarshal(body, &prcf)
		return prcf, err
	default:
		var cf CharFilter
		err := json.Unmarshal(body, &cf)
		return cf, err
	}
}
func unmarshalBasicCharFilterArray(body []byte) ([]BasicCharFilter, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	cfArray := make([]BasicCharFilter, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cf, err := unmarshalBasicCharFilter(*rawMessage)
		if err != nil {
			return nil, err
		}
		cfArray[index] = cf
	}
	return cfArray, nil
}

// MarshalJSON is the custom marshaler for CharFilter.
func (cf CharFilter) MarshalJSON() ([]byte, error) {
	cf.OdataType = OdataTypeCharFilter
	type Alias CharFilter
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(cf),
	})
}

// AsMappingCharFilter is the BasicCharFilter implementation for CharFilter.
func (cf CharFilter) AsMappingCharFilter() (*MappingCharFilter, bool) {
	return nil, false
}

// AsPatternReplaceCharFilter is the BasicCharFilter implementation for CharFilter.
func (cf CharFilter) AsPatternReplaceCharFilter() (*PatternReplaceCharFilter, bool) {
	return nil, false
}

// AsCharFilter is the BasicCharFilter implementation for CharFilter.
func (cf CharFilter) AsCharFilter() (*CharFilter, bool) {
	return &cf, true
}

// AsBasicCharFilter is the BasicCharFilter implementation for CharFilter.
func (cf CharFilter) AsBasicCharFilter() (BasicCharFilter, bool) {
	return &cf, true
}

// CharFilterName defines the names of all character filters supported by Azure Search.
type CharFilterName struct {
	Name *string `json:"name,omitempty"`
}

// CjkBigramTokenFilter forms bigrams of CJK terms that are generated from StandardTokenizer. This token filter is
// implemented using Apache Lucene.
type CjkBigramTokenFilter struct {
	// Name - The name of the token filter. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeTokenFilter', 'OdataTypeMicrosoftAzureSearchASCIIFoldingTokenFilter', 'OdataTypeMicrosoftAzureSearchCjkBigramTokenFilter', 'OdataTypeMicrosoftAzureSearchCommonGramTokenFilter', 'OdataTypeMicrosoftAzureSearchDictionaryDecompounderTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchElisionTokenFilter', 'OdataTypeMicrosoftAzureSearchKeepTokenFilter', 'OdataTypeMicrosoftAzureSearchKeywordMarkerTokenFilter', 'OdataTypeMicrosoftAzureSearchLengthTokenFilter', 'OdataTypeMicrosoftAzureSearchLimitTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchPatternCaptureTokenFilter', 'OdataTypeMicrosoftAzureSearchPatternReplaceTokenFilter', 'OdataTypeMicrosoftAzureSearchPhoneticTokenFilter', 'OdataTypeMicrosoftAzureSearchShingleTokenFilter', 'OdataTypeMicrosoftAzureSearchSnowballTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerOverrideTokenFilter', 'OdataTypeMicrosoftAzureSearchStopwordsTokenFilter', 'OdataTypeMicrosoftAzureSearchSynonymTokenFilter', 'OdataTypeMicrosoftAzureSearchTruncateTokenFilter', 'OdataTypeMicrosoftAzureSearchUniqueTokenFilter', 'OdataTypeMicrosoftAzureSearchWordDelimiterTokenFilter'
	OdataType OdataTypeBasicTokenFilter `json:"@odata.type,omitempty"`
	// IgnoreScripts - The scripts to ignore.
	IgnoreScripts *[]CjkBigramTokenFilterScripts `json:"ignoreScripts,omitempty"`
	// OutputUnigrams - A value indicating whether to output both unigrams and bigrams (if true), or just bigrams (if false). Default is false.
	OutputUnigrams *bool `json:"outputUnigrams,omitempty"`
}

// MarshalJSON is the custom marshaler for CjkBigramTokenFilter.
func (cbtf CjkBigramTokenFilter) MarshalJSON() ([]byte, error) {
	cbtf.OdataType = OdataTypeMicrosoftAzureSearchCjkBigramTokenFilter
	type Alias CjkBigramTokenFilter
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(cbtf),
	})
}

// AsASCIIFoldingTokenFilter is the BasicTokenFilter implementation for CjkBigramTokenFilter.
func (cbtf CjkBigramTokenFilter) AsASCIIFoldingTokenFilter() (*ASCIIFoldingTokenFilter, bool) {
	return nil, false
}

// AsCjkBigramTokenFilter is the BasicTokenFilter implementation for CjkBigramTokenFilter.
func (cbtf CjkBigramTokenFilter) AsCjkBigramTokenFilter() (*CjkBigramTokenFilter, bool) {
	return &cbtf, true
}

// AsCommonGramTokenFilter is the BasicTokenFilter implementation for CjkBigramTokenFilter.
func (cbtf CjkBigramTokenFilter) AsCommonGramTokenFilter() (*CommonGramTokenFilter, bool) {
	return nil, false
}

// AsDictionaryDecompounderTokenFilter is the BasicTokenFilter implementation for CjkBigramTokenFilter.
func (cbtf CjkBigramTokenFilter) AsDictionaryDecompounderTokenFilter() (*DictionaryDecompounderTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilter is the BasicTokenFilter implementation for CjkBigramTokenFilter.
func (cbtf CjkBigramTokenFilter) AsEdgeNGramTokenFilter() (*EdgeNGramTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilterV2 is the BasicTokenFilter implementation for CjkBigramTokenFilter.
func (cbtf CjkBigramTokenFilter) AsEdgeNGramTokenFilterV2() (*EdgeNGramTokenFilterV2, bool) {
	return nil, false
}

// AsElisionTokenFilter is the BasicTokenFilter implementation for CjkBigramTokenFilter.
func (cbtf CjkBigramTokenFilter) AsElisionTokenFilter() (*ElisionTokenFilter, bool) {
	return nil, false
}

// AsKeepTokenFilter is the BasicTokenFilter implementation for CjkBigramTokenFilter.
func (cbtf CjkBigramTokenFilter) AsKeepTokenFilter() (*KeepTokenFilter, bool) {
	return nil, false
}

// AsKeywordMarkerTokenFilter is the BasicTokenFilter implementation for CjkBigramTokenFilter.
func (cbtf CjkBigramTokenFilter) AsKeywordMarkerTokenFilter() (*KeywordMarkerTokenFilter, bool) {
	return nil, false
}

// AsLengthTokenFilter is the BasicTokenFilter implementation for CjkBigramTokenFilter.
func (cbtf CjkBigramTokenFilter) AsLengthTokenFilter() (*LengthTokenFilter, bool) {
	return nil, false
}

// AsLimitTokenFilter is the BasicTokenFilter implementation for CjkBigramTokenFilter.
func (cbtf CjkBigramTokenFilter) AsLimitTokenFilter() (*LimitTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilter is the BasicTokenFilter implementation for CjkBigramTokenFilter.
func (cbtf CjkBigramTokenFilter) AsNGramTokenFilter() (*NGramTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilterV2 is the BasicTokenFilter implementation for CjkBigramTokenFilter.
func (cbtf CjkBigramTokenFilter) AsNGramTokenFilterV2() (*NGramTokenFilterV2, bool) {
	return nil, false
}

// AsPatternCaptureTokenFilter is the BasicTokenFilter implementation for CjkBigramTokenFilter.
func (cbtf CjkBigramTokenFilter) AsPatternCaptureTokenFilter() (*PatternCaptureTokenFilter, bool) {
	return nil, false
}

// AsPatternReplaceTokenFilter is the BasicTokenFilter implementation for CjkBigramTokenFilter.
func (cbtf CjkBigramTokenFilter) AsPatternReplaceTokenFilter() (*PatternReplaceTokenFilter, bool) {
	return nil, false
}

// AsPhoneticTokenFilter is the BasicTokenFilter implementation for CjkBigramTokenFilter.
func (cbtf CjkBigramTokenFilter) AsPhoneticTokenFilter() (*PhoneticTokenFilter, bool) {
	return nil, false
}

// AsShingleTokenFilter is the BasicTokenFilter implementation for CjkBigramTokenFilter.
func (cbtf CjkBigramTokenFilter) AsShingleTokenFilter() (*ShingleTokenFilter, bool) {
	return nil, false
}

// AsSnowballTokenFilter is the BasicTokenFilter implementation for CjkBigramTokenFilter.
func (cbtf CjkBigramTokenFilter) AsSnowballTokenFilter() (*SnowballTokenFilter, bool) {
	return nil, false
}

// AsStemmerTokenFilter is the BasicTokenFilter implementation for CjkBigramTokenFilter.
func (cbtf CjkBigramTokenFilter) AsStemmerTokenFilter() (*StemmerTokenFilter, bool) {
	return nil, false
}

// AsStemmerOverrideTokenFilter is the BasicTokenFilter implementation for CjkBigramTokenFilter.
func (cbtf CjkBigramTokenFilter) AsStemmerOverrideTokenFilter() (*StemmerOverrideTokenFilter, bool) {
	return nil, false
}

// AsStopwordsTokenFilter is the BasicTokenFilter implementation for CjkBigramTokenFilter.
func (cbtf CjkBigramTokenFilter) AsStopwordsTokenFilter() (*StopwordsTokenFilter, bool) {
	return nil, false
}

// AsSynonymTokenFilter is the BasicTokenFilter implementation for CjkBigramTokenFilter.
func (cbtf CjkBigramTokenFilter) AsSynonymTokenFilter() (*SynonymTokenFilter, bool) {
	return nil, false
}

// AsTruncateTokenFilter is the BasicTokenFilter implementation for CjkBigramTokenFilter.
func (cbtf CjkBigramTokenFilter) AsTruncateTokenFilter() (*TruncateTokenFilter, bool) {
	return nil, false
}

// AsUniqueTokenFilter is the BasicTokenFilter implementation for CjkBigramTokenFilter.
func (cbtf CjkBigramTokenFilter) AsUniqueTokenFilter() (*UniqueTokenFilter, bool) {
	return nil, false
}

// AsWordDelimiterTokenFilter is the BasicTokenFilter implementation for CjkBigramTokenFilter.
func (cbtf CjkBigramTokenFilter) AsWordDelimiterTokenFilter() (*WordDelimiterTokenFilter, bool) {
	return nil, false
}

// AsTokenFilter is the BasicTokenFilter implementation for CjkBigramTokenFilter.
func (cbtf CjkBigramTokenFilter) AsTokenFilter() (*TokenFilter, bool) {
	return nil, false
}

// AsBasicTokenFilter is the BasicTokenFilter implementation for CjkBigramTokenFilter.
func (cbtf CjkBigramTokenFilter) AsBasicTokenFilter() (BasicTokenFilter, bool) {
	return &cbtf, true
}

// ClassicTokenizer grammar-based tokenizer that is suitable for processing most European-language documents. This
// tokenizer is implemented using Apache Lucene.
type ClassicTokenizer struct {
	// Name - The name of the tokenizer. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeTokenizer', 'OdataTypeMicrosoftAzureSearchClassicTokenizer', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenizer', 'OdataTypeMicrosoftAzureSearchKeywordTokenizer', 'OdataTypeMicrosoftAzureSearchKeywordTokenizerV2', 'OdataTypeMicrosoftAzureSearchMicrosoftLanguageTokenizer', 'OdataTypeMicrosoftAzureSearchMicrosoftLanguageStemmingTokenizer', 'OdataTypeMicrosoftAzureSearchNGramTokenizer', 'OdataTypeMicrosoftAzureSearchPathHierarchyTokenizer', 'OdataTypeMicrosoftAzureSearchPathHierarchyTokenizerV2', 'OdataTypeMicrosoftAzureSearchPatternTokenizer', 'OdataTypeMicrosoftAzureSearchStandardTokenizer', 'OdataTypeMicrosoftAzureSearchStandardTokenizerV2', 'OdataTypeMicrosoftAzureSearchUaxURLEmailTokenizer'
	OdataType OdataTypeBasicTokenizer `json:"@odata.type,omitempty"`
	// MaxTokenLength - The maximum token length. Default is 255. Tokens longer than the maximum length are split. The maximum token length that can be used is 300 characters.
	MaxTokenLength *int32 `json:"maxTokenLength,omitempty"`
}

// MarshalJSON is the custom marshaler for ClassicTokenizer.
func (ct ClassicTokenizer) MarshalJSON() ([]byte, error) {
	ct.OdataType = OdataTypeMicrosoftAzureSearchClassicTokenizer
	type Alias ClassicTokenizer
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ct),
	})
}

// AsClassicTokenizer is the BasicTokenizer implementation for ClassicTokenizer.
func (ct ClassicTokenizer) AsClassicTokenizer() (*ClassicTokenizer, bool) {
	return &ct, true
}

// AsEdgeNGramTokenizer is the BasicTokenizer implementation for ClassicTokenizer.
func (ct ClassicTokenizer) AsEdgeNGramTokenizer() (*EdgeNGramTokenizer, bool) {
	return nil, false
}

// AsKeywordTokenizer is the BasicTokenizer implementation for ClassicTokenizer.
func (ct ClassicTokenizer) AsKeywordTokenizer() (*KeywordTokenizer, bool) {
	return nil, false
}

// AsKeywordTokenizerV2 is the BasicTokenizer implementation for ClassicTokenizer.
func (ct ClassicTokenizer) AsKeywordTokenizerV2() (*KeywordTokenizerV2, bool) {
	return nil, false
}

// AsMicrosoftLanguageTokenizer is the BasicTokenizer implementation for ClassicTokenizer.
func (ct ClassicTokenizer) AsMicrosoftLanguageTokenizer() (*MicrosoftLanguageTokenizer, bool) {
	return nil, false
}

// AsMicrosoftLanguageStemmingTokenizer is the BasicTokenizer implementation for ClassicTokenizer.
func (ct ClassicTokenizer) AsMicrosoftLanguageStemmingTokenizer() (*MicrosoftLanguageStemmingTokenizer, bool) {
	return nil, false
}

// AsNGramTokenizer is the BasicTokenizer implementation for ClassicTokenizer.
func (ct ClassicTokenizer) AsNGramTokenizer() (*NGramTokenizer, bool) {
	return nil, false
}

// AsPathHierarchyTokenizer is the BasicTokenizer implementation for ClassicTokenizer.
func (ct ClassicTokenizer) AsPathHierarchyTokenizer() (*PathHierarchyTokenizer, bool) {
	return nil, false
}

// AsPathHierarchyTokenizerV2 is the BasicTokenizer implementation for ClassicTokenizer.
func (ct ClassicTokenizer) AsPathHierarchyTokenizerV2() (*PathHierarchyTokenizerV2, bool) {
	return nil, false
}

// AsPatternTokenizer is the BasicTokenizer implementation for ClassicTokenizer.
func (ct ClassicTokenizer) AsPatternTokenizer() (*PatternTokenizer, bool) {
	return nil, false
}

// AsStandardTokenizer is the BasicTokenizer implementation for ClassicTokenizer.
func (ct ClassicTokenizer) AsStandardTokenizer() (*StandardTokenizer, bool) {
	return nil, false
}

// AsStandardTokenizerV2 is the BasicTokenizer implementation for ClassicTokenizer.
func (ct ClassicTokenizer) AsStandardTokenizerV2() (*StandardTokenizerV2, bool) {
	return nil, false
}

// AsUaxURLEmailTokenizer is the BasicTokenizer implementation for ClassicTokenizer.
func (ct ClassicTokenizer) AsUaxURLEmailTokenizer() (*UaxURLEmailTokenizer, bool) {
	return nil, false
}

// AsTokenizer is the BasicTokenizer implementation for ClassicTokenizer.
func (ct ClassicTokenizer) AsTokenizer() (*Tokenizer, bool) {
	return nil, false
}

// AsBasicTokenizer is the BasicTokenizer implementation for ClassicTokenizer.
func (ct ClassicTokenizer) AsBasicTokenizer() (BasicTokenizer, bool) {
	return &ct, true
}

// CommonGramTokenFilter construct bigrams for frequently occurring terms while indexing. Single terms are still
// indexed too, with bigrams overlaid. This token filter is implemented using Apache Lucene.
type CommonGramTokenFilter struct {
	// Name - The name of the token filter. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeTokenFilter', 'OdataTypeMicrosoftAzureSearchASCIIFoldingTokenFilter', 'OdataTypeMicrosoftAzureSearchCjkBigramTokenFilter', 'OdataTypeMicrosoftAzureSearchCommonGramTokenFilter', 'OdataTypeMicrosoftAzureSearchDictionaryDecompounderTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchElisionTokenFilter', 'OdataTypeMicrosoftAzureSearchKeepTokenFilter', 'OdataTypeMicrosoftAzureSearchKeywordMarkerTokenFilter', 'OdataTypeMicrosoftAzureSearchLengthTokenFilter', 'OdataTypeMicrosoftAzureSearchLimitTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchPatternCaptureTokenFilter', 'OdataTypeMicrosoftAzureSearchPatternReplaceTokenFilter', 'OdataTypeMicrosoftAzureSearchPhoneticTokenFilter', 'OdataTypeMicrosoftAzureSearchShingleTokenFilter', 'OdataTypeMicrosoftAzureSearchSnowballTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerOverrideTokenFilter', 'OdataTypeMicrosoftAzureSearchStopwordsTokenFilter', 'OdataTypeMicrosoftAzureSearchSynonymTokenFilter', 'OdataTypeMicrosoftAzureSearchTruncateTokenFilter', 'OdataTypeMicrosoftAzureSearchUniqueTokenFilter', 'OdataTypeMicrosoftAzureSearchWordDelimiterTokenFilter'
	OdataType OdataTypeBasicTokenFilter `json:"@odata.type,omitempty"`
	// CommonWords - The set of common words.
	CommonWords *[]string `json:"commonWords,omitempty"`
	// IgnoreCase - A value indicating whether common words matching will be case insensitive. Default is false.
	IgnoreCase *bool `json:"ignoreCase,omitempty"`
	// UseQueryMode - A value that indicates whether the token filter is in query mode. When in query mode, the token filter generates bigrams and then removes common words and single terms followed by a common word. Default is false.
	UseQueryMode *bool `json:"queryMode,omitempty"`
}

// MarshalJSON is the custom marshaler for CommonGramTokenFilter.
func (cgtf CommonGramTokenFilter) MarshalJSON() ([]byte, error) {
	cgtf.OdataType = OdataTypeMicrosoftAzureSearchCommonGramTokenFilter
	type Alias CommonGramTokenFilter
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(cgtf),
	})
}

// AsASCIIFoldingTokenFilter is the BasicTokenFilter implementation for CommonGramTokenFilter.
func (cgtf CommonGramTokenFilter) AsASCIIFoldingTokenFilter() (*ASCIIFoldingTokenFilter, bool) {
	return nil, false
}

// AsCjkBigramTokenFilter is the BasicTokenFilter implementation for CommonGramTokenFilter.
func (cgtf CommonGramTokenFilter) AsCjkBigramTokenFilter() (*CjkBigramTokenFilter, bool) {
	return nil, false
}

// AsCommonGramTokenFilter is the BasicTokenFilter implementation for CommonGramTokenFilter.
func (cgtf CommonGramTokenFilter) AsCommonGramTokenFilter() (*CommonGramTokenFilter, bool) {
	return &cgtf, true
}

// AsDictionaryDecompounderTokenFilter is the BasicTokenFilter implementation for CommonGramTokenFilter.
func (cgtf CommonGramTokenFilter) AsDictionaryDecompounderTokenFilter() (*DictionaryDecompounderTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilter is the BasicTokenFilter implementation for CommonGramTokenFilter.
func (cgtf CommonGramTokenFilter) AsEdgeNGramTokenFilter() (*EdgeNGramTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilterV2 is the BasicTokenFilter implementation for CommonGramTokenFilter.
func (cgtf CommonGramTokenFilter) AsEdgeNGramTokenFilterV2() (*EdgeNGramTokenFilterV2, bool) {
	return nil, false
}

// AsElisionTokenFilter is the BasicTokenFilter implementation for CommonGramTokenFilter.
func (cgtf CommonGramTokenFilter) AsElisionTokenFilter() (*ElisionTokenFilter, bool) {
	return nil, false
}

// AsKeepTokenFilter is the BasicTokenFilter implementation for CommonGramTokenFilter.
func (cgtf CommonGramTokenFilter) AsKeepTokenFilter() (*KeepTokenFilter, bool) {
	return nil, false
}

// AsKeywordMarkerTokenFilter is the BasicTokenFilter implementation for CommonGramTokenFilter.
func (cgtf CommonGramTokenFilter) AsKeywordMarkerTokenFilter() (*KeywordMarkerTokenFilter, bool) {
	return nil, false
}

// AsLengthTokenFilter is the BasicTokenFilter implementation for CommonGramTokenFilter.
func (cgtf CommonGramTokenFilter) AsLengthTokenFilter() (*LengthTokenFilter, bool) {
	return nil, false
}

// AsLimitTokenFilter is the BasicTokenFilter implementation for CommonGramTokenFilter.
func (cgtf CommonGramTokenFilter) AsLimitTokenFilter() (*LimitTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilter is the BasicTokenFilter implementation for CommonGramTokenFilter.
func (cgtf CommonGramTokenFilter) AsNGramTokenFilter() (*NGramTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilterV2 is the BasicTokenFilter implementation for CommonGramTokenFilter.
func (cgtf CommonGramTokenFilter) AsNGramTokenFilterV2() (*NGramTokenFilterV2, bool) {
	return nil, false
}

// AsPatternCaptureTokenFilter is the BasicTokenFilter implementation for CommonGramTokenFilter.
func (cgtf CommonGramTokenFilter) AsPatternCaptureTokenFilter() (*PatternCaptureTokenFilter, bool) {
	return nil, false
}

// AsPatternReplaceTokenFilter is the BasicTokenFilter implementation for CommonGramTokenFilter.
func (cgtf CommonGramTokenFilter) AsPatternReplaceTokenFilter() (*PatternReplaceTokenFilter, bool) {
	return nil, false
}

// AsPhoneticTokenFilter is the BasicTokenFilter implementation for CommonGramTokenFilter.
func (cgtf CommonGramTokenFilter) AsPhoneticTokenFilter() (*PhoneticTokenFilter, bool) {
	return nil, false
}

// AsShingleTokenFilter is the BasicTokenFilter implementation for CommonGramTokenFilter.
func (cgtf CommonGramTokenFilter) AsShingleTokenFilter() (*ShingleTokenFilter, bool) {
	return nil, false
}

// AsSnowballTokenFilter is the BasicTokenFilter implementation for CommonGramTokenFilter.
func (cgtf CommonGramTokenFilter) AsSnowballTokenFilter() (*SnowballTokenFilter, bool) {
	return nil, false
}

// AsStemmerTokenFilter is the BasicTokenFilter implementation for CommonGramTokenFilter.
func (cgtf CommonGramTokenFilter) AsStemmerTokenFilter() (*StemmerTokenFilter, bool) {
	return nil, false
}

// AsStemmerOverrideTokenFilter is the BasicTokenFilter implementation for CommonGramTokenFilter.
func (cgtf CommonGramTokenFilter) AsStemmerOverrideTokenFilter() (*StemmerOverrideTokenFilter, bool) {
	return nil, false
}

// AsStopwordsTokenFilter is the BasicTokenFilter implementation for CommonGramTokenFilter.
func (cgtf CommonGramTokenFilter) AsStopwordsTokenFilter() (*StopwordsTokenFilter, bool) {
	return nil, false
}

// AsSynonymTokenFilter is the BasicTokenFilter implementation for CommonGramTokenFilter.
func (cgtf CommonGramTokenFilter) AsSynonymTokenFilter() (*SynonymTokenFilter, bool) {
	return nil, false
}

// AsTruncateTokenFilter is the BasicTokenFilter implementation for CommonGramTokenFilter.
func (cgtf CommonGramTokenFilter) AsTruncateTokenFilter() (*TruncateTokenFilter, bool) {
	return nil, false
}

// AsUniqueTokenFilter is the BasicTokenFilter implementation for CommonGramTokenFilter.
func (cgtf CommonGramTokenFilter) AsUniqueTokenFilter() (*UniqueTokenFilter, bool) {
	return nil, false
}

// AsWordDelimiterTokenFilter is the BasicTokenFilter implementation for CommonGramTokenFilter.
func (cgtf CommonGramTokenFilter) AsWordDelimiterTokenFilter() (*WordDelimiterTokenFilter, bool) {
	return nil, false
}

// AsTokenFilter is the BasicTokenFilter implementation for CommonGramTokenFilter.
func (cgtf CommonGramTokenFilter) AsTokenFilter() (*TokenFilter, bool) {
	return nil, false
}

// AsBasicTokenFilter is the BasicTokenFilter implementation for CommonGramTokenFilter.
func (cgtf CommonGramTokenFilter) AsBasicTokenFilter() (BasicTokenFilter, bool) {
	return &cgtf, true
}

// CorsOptions defines options to control Cross-Origin Resource Sharing (CORS) for an index.
type CorsOptions struct {
	// AllowedOrigins - The list of origins from which JavaScript code will be granted access to your index. Can contain a list of hosts of the form {protocol}://{fully-qualified-domain-name}[:{port#}], or a single '*' to allow all origins (not recommended).
	AllowedOrigins *[]string `json:"allowedOrigins,omitempty"`
	// MaxAgeInSeconds - The duration for which browsers should cache CORS preflight responses. Defaults to 5 mintues.
	MaxAgeInSeconds *int64 `json:"maxAgeInSeconds,omitempty"`
}

// CustomAnalyzer allows you to take control over the process of converting text into indexable/searchable tokens. It's
// a user-defined configuration consisting of a single predefined tokenizer and one or more filters. The tokenizer is
// responsible for breaking text into tokens, and the filters for modifying tokens emitted by the tokenizer.
type CustomAnalyzer struct {
	// Name - The name of the analyzer. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeAnalyzer', 'OdataTypeMicrosoftAzureSearchCustomAnalyzer', 'OdataTypeMicrosoftAzureSearchPatternAnalyzer', 'OdataTypeMicrosoftAzureSearchStandardAnalyzer', 'OdataTypeMicrosoftAzureSearchStopAnalyzer'
	OdataType OdataType `json:"@odata.type,omitempty"`
	// Tokenizer - The name of the tokenizer to use to divide continuous text into a sequence of tokens, such as breaking a sentence into words.
	Tokenizer *TokenizerName `json:"tokenizer,omitempty"`
	// TokenFilters - A list of token filters used to filter out or modify the tokens generated by a tokenizer. For example, you can specify a lowercase filter that converts all characters to lowercase. The filters are run in the order in which they are listed.
	TokenFilters *[]TokenFilterName `json:"tokenFilters,omitempty"`
	// CharFilters - A list of character filters used to prepare input text before it is processed by the tokenizer. For instance, they can replace certain characters or symbols. The filters are run in the order in which they are listed.
	CharFilters *[]CharFilterName `json:"charFilters,omitempty"`
}

// MarshalJSON is the custom marshaler for CustomAnalyzer.
func (ca CustomAnalyzer) MarshalJSON() ([]byte, error) {
	ca.OdataType = OdataTypeMicrosoftAzureSearchCustomAnalyzer
	type Alias CustomAnalyzer
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ca),
	})
}

// AsCustomAnalyzer is the BasicAnalyzer implementation for CustomAnalyzer.
func (ca CustomAnalyzer) AsCustomAnalyzer() (*CustomAnalyzer, bool) {
	return &ca, true
}

// AsPatternAnalyzer is the BasicAnalyzer implementation for CustomAnalyzer.
func (ca CustomAnalyzer) AsPatternAnalyzer() (*PatternAnalyzer, bool) {
	return nil, false
}

// AsStandardAnalyzer is the BasicAnalyzer implementation for CustomAnalyzer.
func (ca CustomAnalyzer) AsStandardAnalyzer() (*StandardAnalyzer, bool) {
	return nil, false
}

// AsStopAnalyzer is the BasicAnalyzer implementation for CustomAnalyzer.
func (ca CustomAnalyzer) AsStopAnalyzer() (*StopAnalyzer, bool) {
	return nil, false
}

// AsAnalyzer is the BasicAnalyzer implementation for CustomAnalyzer.
func (ca CustomAnalyzer) AsAnalyzer() (*Analyzer, bool) {
	return nil, false
}

// AsBasicAnalyzer is the BasicAnalyzer implementation for CustomAnalyzer.
func (ca CustomAnalyzer) AsBasicAnalyzer() (BasicAnalyzer, bool) {
	return &ca, true
}

// BasicDataChangeDetectionPolicy abstract base class for data change detection policies.
type BasicDataChangeDetectionPolicy interface {
	AsHighWaterMarkChangeDetectionPolicy() (*HighWaterMarkChangeDetectionPolicy, bool)
	AsSQLIntegratedChangeTrackingPolicy() (*SQLIntegratedChangeTrackingPolicy, bool)
	AsDataChangeDetectionPolicy() (*DataChangeDetectionPolicy, bool)
}

// DataChangeDetectionPolicy abstract base class for data change detection policies.
type DataChangeDetectionPolicy struct {
	// OdataType - Possible values include: 'OdataTypeDataChangeDetectionPolicy', 'OdataTypeMicrosoftAzureSearchHighWaterMarkChangeDetectionPolicy', 'OdataTypeMicrosoftAzureSearchSQLIntegratedChangeTrackingPolicy'
	OdataType OdataTypeBasicDataChangeDetectionPolicy `json:"@odata.type,omitempty"`
}

func unmarshalBasicDataChangeDetectionPolicy(body []byte) (BasicDataChangeDetectionPolicy, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@odata.type"] {
	case string(OdataTypeMicrosoftAzureSearchHighWaterMarkChangeDetectionPolicy):
		var hwmcdp HighWaterMarkChangeDetectionPolicy
		err := json.Unmarshal(body, &hwmcdp)
		return hwmcdp, err
	case string(OdataTypeMicrosoftAzureSearchSQLIntegratedChangeTrackingPolicy):
		var sictp SQLIntegratedChangeTrackingPolicy
		err := json.Unmarshal(body, &sictp)
		return sictp, err
	default:
		var dcdp DataChangeDetectionPolicy
		err := json.Unmarshal(body, &dcdp)
		return dcdp, err
	}
}
func unmarshalBasicDataChangeDetectionPolicyArray(body []byte) ([]BasicDataChangeDetectionPolicy, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	dcdpArray := make([]BasicDataChangeDetectionPolicy, len(rawMessages))

	for index, rawMessage := range rawMessages {
		dcdp, err := unmarshalBasicDataChangeDetectionPolicy(*rawMessage)
		if err != nil {
			return nil, err
		}
		dcdpArray[index] = dcdp
	}
	return dcdpArray, nil
}

// MarshalJSON is the custom marshaler for DataChangeDetectionPolicy.
func (dcdp DataChangeDetectionPolicy) MarshalJSON() ([]byte, error) {
	dcdp.OdataType = OdataTypeDataChangeDetectionPolicy
	type Alias DataChangeDetectionPolicy
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(dcdp),
	})
}

// AsHighWaterMarkChangeDetectionPolicy is the BasicDataChangeDetectionPolicy implementation for DataChangeDetectionPolicy.
func (dcdp DataChangeDetectionPolicy) AsHighWaterMarkChangeDetectionPolicy() (*HighWaterMarkChangeDetectionPolicy, bool) {
	return nil, false
}

// AsSQLIntegratedChangeTrackingPolicy is the BasicDataChangeDetectionPolicy implementation for DataChangeDetectionPolicy.
func (dcdp DataChangeDetectionPolicy) AsSQLIntegratedChangeTrackingPolicy() (*SQLIntegratedChangeTrackingPolicy, bool) {
	return nil, false
}

// AsDataChangeDetectionPolicy is the BasicDataChangeDetectionPolicy implementation for DataChangeDetectionPolicy.
func (dcdp DataChangeDetectionPolicy) AsDataChangeDetectionPolicy() (*DataChangeDetectionPolicy, bool) {
	return &dcdp, true
}

// AsBasicDataChangeDetectionPolicy is the BasicDataChangeDetectionPolicy implementation for DataChangeDetectionPolicy.
func (dcdp DataChangeDetectionPolicy) AsBasicDataChangeDetectionPolicy() (BasicDataChangeDetectionPolicy, bool) {
	return &dcdp, true
}

// DataContainer represents information about the entity (such as Azure SQL table or DocumentDb collection) that will
// be indexed.
type DataContainer struct {
	// Name - The name of the table or view (for Azure SQL data source) or collection (for DocumentDB data source) that will be indexed.
	Name *string `json:"name,omitempty"`
	// Query - A query that is applied to this data container. The syntax and meaning of this parameter is datasource-specific. Not supported by Azure SQL datasources.
	Query *string `json:"query,omitempty"`
}

// BasicDataDeletionDetectionPolicy abstract base class for data deletion detection policies.
type BasicDataDeletionDetectionPolicy interface {
	AsSoftDeleteColumnDeletionDetectionPolicy() (*SoftDeleteColumnDeletionDetectionPolicy, bool)
	AsDataDeletionDetectionPolicy() (*DataDeletionDetectionPolicy, bool)
}

// DataDeletionDetectionPolicy abstract base class for data deletion detection policies.
type DataDeletionDetectionPolicy struct {
	// OdataType - Possible values include: 'OdataTypeDataDeletionDetectionPolicy', 'OdataTypeMicrosoftAzureSearchSoftDeleteColumnDeletionDetectionPolicy'
	OdataType OdataTypeBasicDataDeletionDetectionPolicy `json:"@odata.type,omitempty"`
}

func unmarshalBasicDataDeletionDetectionPolicy(body []byte) (BasicDataDeletionDetectionPolicy, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@odata.type"] {
	case string(OdataTypeMicrosoftAzureSearchSoftDeleteColumnDeletionDetectionPolicy):
		var sdcddp SoftDeleteColumnDeletionDetectionPolicy
		err := json.Unmarshal(body, &sdcddp)
		return sdcddp, err
	default:
		var dddp DataDeletionDetectionPolicy
		err := json.Unmarshal(body, &dddp)
		return dddp, err
	}
}
func unmarshalBasicDataDeletionDetectionPolicyArray(body []byte) ([]BasicDataDeletionDetectionPolicy, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	dddpArray := make([]BasicDataDeletionDetectionPolicy, len(rawMessages))

	for index, rawMessage := range rawMessages {
		dddp, err := unmarshalBasicDataDeletionDetectionPolicy(*rawMessage)
		if err != nil {
			return nil, err
		}
		dddpArray[index] = dddp
	}
	return dddpArray, nil
}

// MarshalJSON is the custom marshaler for DataDeletionDetectionPolicy.
func (dddp DataDeletionDetectionPolicy) MarshalJSON() ([]byte, error) {
	dddp.OdataType = OdataTypeDataDeletionDetectionPolicy
	type Alias DataDeletionDetectionPolicy
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(dddp),
	})
}

// AsSoftDeleteColumnDeletionDetectionPolicy is the BasicDataDeletionDetectionPolicy implementation for DataDeletionDetectionPolicy.
func (dddp DataDeletionDetectionPolicy) AsSoftDeleteColumnDeletionDetectionPolicy() (*SoftDeleteColumnDeletionDetectionPolicy, bool) {
	return nil, false
}

// AsDataDeletionDetectionPolicy is the BasicDataDeletionDetectionPolicy implementation for DataDeletionDetectionPolicy.
func (dddp DataDeletionDetectionPolicy) AsDataDeletionDetectionPolicy() (*DataDeletionDetectionPolicy, bool) {
	return &dddp, true
}

// AsBasicDataDeletionDetectionPolicy is the BasicDataDeletionDetectionPolicy implementation for DataDeletionDetectionPolicy.
func (dddp DataDeletionDetectionPolicy) AsBasicDataDeletionDetectionPolicy() (BasicDataDeletionDetectionPolicy, bool) {
	return &dddp, true
}

// DataSource represents a datasource definition in Azure Search, which can be used to configure an indexer.
type DataSource struct {
	autorest.Response `json:"-"`
	// Name - The name of the datasource.
	Name *string `json:"name,omitempty"`
	// Description - The description of the datasource.
	Description *string `json:"description,omitempty"`
	// Type - The type of the datasource.
	Type *DataSourceType `json:"type,omitempty"`
	// Credentials - Credentials for the datasource.
	Credentials *DataSourceCredentials `json:"credentials,omitempty"`
	// Container - The data container for the datasource.
	Container *DataContainer `json:"container,omitempty"`
	// DataChangeDetectionPolicy - The data change detection policy for the datasource.
	DataChangeDetectionPolicy BasicDataChangeDetectionPolicy `json:"dataChangeDetectionPolicy,omitempty"`
	// DataDeletionDetectionPolicy - The data deletion detection policy for the datasource.
	DataDeletionDetectionPolicy BasicDataDeletionDetectionPolicy `json:"dataDeletionDetectionPolicy,omitempty"`
	// ETag - The ETag of the DataSource.
	ETag *string `json:"@odata.etag,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for DataSource struct.
func (ds *DataSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		ds.Name = &name
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		ds.Description = &description
	}

	v = m["type"]
	if v != nil {
		var typeVar DataSourceType
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		ds.Type = &typeVar
	}

	v = m["credentials"]
	if v != nil {
		var credentials DataSourceCredentials
		err = json.Unmarshal(*m["credentials"], &credentials)
		if err != nil {
			return err
		}
		ds.Credentials = &credentials
	}

	v = m["container"]
	if v != nil {
		var containerVar DataContainer
		err = json.Unmarshal(*m["container"], &containerVar)
		if err != nil {
			return err
		}
		ds.Container = &containerVar
	}

	v = m["dataChangeDetectionPolicy"]
	if v != nil {
		dataChangeDetectionPolicy, err := unmarshalBasicDataChangeDetectionPolicy(*m["dataChangeDetectionPolicy"])
		if err != nil {
			return err
		}
		ds.DataChangeDetectionPolicy = dataChangeDetectionPolicy
	}

	v = m["dataDeletionDetectionPolicy"]
	if v != nil {
		dataDeletionDetectionPolicy, err := unmarshalBasicDataDeletionDetectionPolicy(*m["dataDeletionDetectionPolicy"])
		if err != nil {
			return err
		}
		ds.DataDeletionDetectionPolicy = dataDeletionDetectionPolicy
	}

	v = m["@odata.etag"]
	if v != nil {
		var odataetag string
		err = json.Unmarshal(*m["@odata.etag"], &odataetag)
		if err != nil {
			return err
		}
		ds.ETag = &odataetag
	}

	return nil
}

// DataSourceCredentials represents credentials that can be used to connect to a datasource.
type DataSourceCredentials struct {
	// ConnectionString - The connection string for the datasource.
	ConnectionString *string `json:"connectionString,omitempty"`
}

// DataSourceListResult response from a List Datasources request. If successful, it includes the full definitions of
// all datasources.
type DataSourceListResult struct {
	autorest.Response `json:"-"`
	// DataSources - The datasources in the Search service.
	DataSources *[]DataSource `json:"value,omitempty"`
}

// DataSourceType defines the type of an Azure Search datasource.
type DataSourceType struct {
	Name *string `json:"name,omitempty"`
}

// DataType defines the data type of a field in an Azure Search index.
type DataType struct {
	Name *string `json:"name,omitempty"`
}

// DictionaryDecompounderTokenFilter decomposes compound words found in many Germanic languages. This token filter is
// implemented using Apache Lucene.
type DictionaryDecompounderTokenFilter struct {
	// Name - The name of the token filter. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeTokenFilter', 'OdataTypeMicrosoftAzureSearchASCIIFoldingTokenFilter', 'OdataTypeMicrosoftAzureSearchCjkBigramTokenFilter', 'OdataTypeMicrosoftAzureSearchCommonGramTokenFilter', 'OdataTypeMicrosoftAzureSearchDictionaryDecompounderTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchElisionTokenFilter', 'OdataTypeMicrosoftAzureSearchKeepTokenFilter', 'OdataTypeMicrosoftAzureSearchKeywordMarkerTokenFilter', 'OdataTypeMicrosoftAzureSearchLengthTokenFilter', 'OdataTypeMicrosoftAzureSearchLimitTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchPatternCaptureTokenFilter', 'OdataTypeMicrosoftAzureSearchPatternReplaceTokenFilter', 'OdataTypeMicrosoftAzureSearchPhoneticTokenFilter', 'OdataTypeMicrosoftAzureSearchShingleTokenFilter', 'OdataTypeMicrosoftAzureSearchSnowballTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerOverrideTokenFilter', 'OdataTypeMicrosoftAzureSearchStopwordsTokenFilter', 'OdataTypeMicrosoftAzureSearchSynonymTokenFilter', 'OdataTypeMicrosoftAzureSearchTruncateTokenFilter', 'OdataTypeMicrosoftAzureSearchUniqueTokenFilter', 'OdataTypeMicrosoftAzureSearchWordDelimiterTokenFilter'
	OdataType OdataTypeBasicTokenFilter `json:"@odata.type,omitempty"`
	// WordList - The list of words to match against.
	WordList *[]string `json:"wordList,omitempty"`
	// MinWordSize - The minimum word size. Only words longer than this get processed. Default is 5. Maximum is 300.
	MinWordSize *int32 `json:"minWordSize,omitempty"`
	// MinSubwordSize - The minimum subword size. Only subwords longer than this are outputted. Default is 2. Maximum is 300.
	MinSubwordSize *int32 `json:"minSubwordSize,omitempty"`
	// MaxSubwordSize - The maximum subword size. Only subwords shorter than this are outputted. Default is 15. Maximum is 300.
	MaxSubwordSize *int32 `json:"maxSubwordSize,omitempty"`
	// OnlyLongestMatch - A value indicating whether to add only the longest matching subword to the output. Default is false.
	OnlyLongestMatch *bool `json:"onlyLongestMatch,omitempty"`
}

// MarshalJSON is the custom marshaler for DictionaryDecompounderTokenFilter.
func (ddtf DictionaryDecompounderTokenFilter) MarshalJSON() ([]byte, error) {
	ddtf.OdataType = OdataTypeMicrosoftAzureSearchDictionaryDecompounderTokenFilter
	type Alias DictionaryDecompounderTokenFilter
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ddtf),
	})
}

// AsASCIIFoldingTokenFilter is the BasicTokenFilter implementation for DictionaryDecompounderTokenFilter.
func (ddtf DictionaryDecompounderTokenFilter) AsASCIIFoldingTokenFilter() (*ASCIIFoldingTokenFilter, bool) {
	return nil, false
}

// AsCjkBigramTokenFilter is the BasicTokenFilter implementation for DictionaryDecompounderTokenFilter.
func (ddtf DictionaryDecompounderTokenFilter) AsCjkBigramTokenFilter() (*CjkBigramTokenFilter, bool) {
	return nil, false
}

// AsCommonGramTokenFilter is the BasicTokenFilter implementation for DictionaryDecompounderTokenFilter.
func (ddtf DictionaryDecompounderTokenFilter) AsCommonGramTokenFilter() (*CommonGramTokenFilter, bool) {
	return nil, false
}

// AsDictionaryDecompounderTokenFilter is the BasicTokenFilter implementation for DictionaryDecompounderTokenFilter.
func (ddtf DictionaryDecompounderTokenFilter) AsDictionaryDecompounderTokenFilter() (*DictionaryDecompounderTokenFilter, bool) {
	return &ddtf, true
}

// AsEdgeNGramTokenFilter is the BasicTokenFilter implementation for DictionaryDecompounderTokenFilter.
func (ddtf DictionaryDecompounderTokenFilter) AsEdgeNGramTokenFilter() (*EdgeNGramTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilterV2 is the BasicTokenFilter implementation for DictionaryDecompounderTokenFilter.
func (ddtf DictionaryDecompounderTokenFilter) AsEdgeNGramTokenFilterV2() (*EdgeNGramTokenFilterV2, bool) {
	return nil, false
}

// AsElisionTokenFilter is the BasicTokenFilter implementation for DictionaryDecompounderTokenFilter.
func (ddtf DictionaryDecompounderTokenFilter) AsElisionTokenFilter() (*ElisionTokenFilter, bool) {
	return nil, false
}

// AsKeepTokenFilter is the BasicTokenFilter implementation for DictionaryDecompounderTokenFilter.
func (ddtf DictionaryDecompounderTokenFilter) AsKeepTokenFilter() (*KeepTokenFilter, bool) {
	return nil, false
}

// AsKeywordMarkerTokenFilter is the BasicTokenFilter implementation for DictionaryDecompounderTokenFilter.
func (ddtf DictionaryDecompounderTokenFilter) AsKeywordMarkerTokenFilter() (*KeywordMarkerTokenFilter, bool) {
	return nil, false
}

// AsLengthTokenFilter is the BasicTokenFilter implementation for DictionaryDecompounderTokenFilter.
func (ddtf DictionaryDecompounderTokenFilter) AsLengthTokenFilter() (*LengthTokenFilter, bool) {
	return nil, false
}

// AsLimitTokenFilter is the BasicTokenFilter implementation for DictionaryDecompounderTokenFilter.
func (ddtf DictionaryDecompounderTokenFilter) AsLimitTokenFilter() (*LimitTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilter is the BasicTokenFilter implementation for DictionaryDecompounderTokenFilter.
func (ddtf DictionaryDecompounderTokenFilter) AsNGramTokenFilter() (*NGramTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilterV2 is the BasicTokenFilter implementation for DictionaryDecompounderTokenFilter.
func (ddtf DictionaryDecompounderTokenFilter) AsNGramTokenFilterV2() (*NGramTokenFilterV2, bool) {
	return nil, false
}

// AsPatternCaptureTokenFilter is the BasicTokenFilter implementation for DictionaryDecompounderTokenFilter.
func (ddtf DictionaryDecompounderTokenFilter) AsPatternCaptureTokenFilter() (*PatternCaptureTokenFilter, bool) {
	return nil, false
}

// AsPatternReplaceTokenFilter is the BasicTokenFilter implementation for DictionaryDecompounderTokenFilter.
func (ddtf DictionaryDecompounderTokenFilter) AsPatternReplaceTokenFilter() (*PatternReplaceTokenFilter, bool) {
	return nil, false
}

// AsPhoneticTokenFilter is the BasicTokenFilter implementation for DictionaryDecompounderTokenFilter.
func (ddtf DictionaryDecompounderTokenFilter) AsPhoneticTokenFilter() (*PhoneticTokenFilter, bool) {
	return nil, false
}

// AsShingleTokenFilter is the BasicTokenFilter implementation for DictionaryDecompounderTokenFilter.
func (ddtf DictionaryDecompounderTokenFilter) AsShingleTokenFilter() (*ShingleTokenFilter, bool) {
	return nil, false
}

// AsSnowballTokenFilter is the BasicTokenFilter implementation for DictionaryDecompounderTokenFilter.
func (ddtf DictionaryDecompounderTokenFilter) AsSnowballTokenFilter() (*SnowballTokenFilter, bool) {
	return nil, false
}

// AsStemmerTokenFilter is the BasicTokenFilter implementation for DictionaryDecompounderTokenFilter.
func (ddtf DictionaryDecompounderTokenFilter) AsStemmerTokenFilter() (*StemmerTokenFilter, bool) {
	return nil, false
}

// AsStemmerOverrideTokenFilter is the BasicTokenFilter implementation for DictionaryDecompounderTokenFilter.
func (ddtf DictionaryDecompounderTokenFilter) AsStemmerOverrideTokenFilter() (*StemmerOverrideTokenFilter, bool) {
	return nil, false
}

// AsStopwordsTokenFilter is the BasicTokenFilter implementation for DictionaryDecompounderTokenFilter.
func (ddtf DictionaryDecompounderTokenFilter) AsStopwordsTokenFilter() (*StopwordsTokenFilter, bool) {
	return nil, false
}

// AsSynonymTokenFilter is the BasicTokenFilter implementation for DictionaryDecompounderTokenFilter.
func (ddtf DictionaryDecompounderTokenFilter) AsSynonymTokenFilter() (*SynonymTokenFilter, bool) {
	return nil, false
}

// AsTruncateTokenFilter is the BasicTokenFilter implementation for DictionaryDecompounderTokenFilter.
func (ddtf DictionaryDecompounderTokenFilter) AsTruncateTokenFilter() (*TruncateTokenFilter, bool) {
	return nil, false
}

// AsUniqueTokenFilter is the BasicTokenFilter implementation for DictionaryDecompounderTokenFilter.
func (ddtf DictionaryDecompounderTokenFilter) AsUniqueTokenFilter() (*UniqueTokenFilter, bool) {
	return nil, false
}

// AsWordDelimiterTokenFilter is the BasicTokenFilter implementation for DictionaryDecompounderTokenFilter.
func (ddtf DictionaryDecompounderTokenFilter) AsWordDelimiterTokenFilter() (*WordDelimiterTokenFilter, bool) {
	return nil, false
}

// AsTokenFilter is the BasicTokenFilter implementation for DictionaryDecompounderTokenFilter.
func (ddtf DictionaryDecompounderTokenFilter) AsTokenFilter() (*TokenFilter, bool) {
	return nil, false
}

// AsBasicTokenFilter is the BasicTokenFilter implementation for DictionaryDecompounderTokenFilter.
func (ddtf DictionaryDecompounderTokenFilter) AsBasicTokenFilter() (BasicTokenFilter, bool) {
	return &ddtf, true
}

// DistanceScoringFunction defines a function that boosts scores based on distance from a geographic location.
type DistanceScoringFunction struct {
	// FieldName - The name of the field used as input to the scoring function.
	FieldName *string `json:"fieldName,omitempty"`
	// Boost - A multiplier for the raw score. Must be a positive number not equal to 1.0.
	Boost *float64 `json:"boost,omitempty"`
	// Interpolation - A value indicating how boosting will be interpolated across document scores; defaults to "Linear". Possible values include: 'Linear', 'Constant', 'Quadratic', 'Logarithmic'
	Interpolation ScoringFunctionInterpolation `json:"interpolation,omitempty"`
	// Type - Possible values include: 'TypeScoringFunction', 'TypeDistance', 'TypeFreshness', 'TypeMagnitude', 'TypeTag'
	Type Type `json:"type,omitempty"`
	// Parameters - Parameter values for the distance scoring function.
	Parameters *DistanceScoringParameters `json:"distance,omitempty"`
}

// MarshalJSON is the custom marshaler for DistanceScoringFunction.
func (dsf DistanceScoringFunction) MarshalJSON() ([]byte, error) {
	dsf.Type = TypeDistance
	type Alias DistanceScoringFunction
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(dsf),
	})
}

// AsDistanceScoringFunction is the BasicScoringFunction implementation for DistanceScoringFunction.
func (dsf DistanceScoringFunction) AsDistanceScoringFunction() (*DistanceScoringFunction, bool) {
	return &dsf, true
}

// AsFreshnessScoringFunction is the BasicScoringFunction implementation for DistanceScoringFunction.
func (dsf DistanceScoringFunction) AsFreshnessScoringFunction() (*FreshnessScoringFunction, bool) {
	return nil, false
}

// AsMagnitudeScoringFunction is the BasicScoringFunction implementation for DistanceScoringFunction.
func (dsf DistanceScoringFunction) AsMagnitudeScoringFunction() (*MagnitudeScoringFunction, bool) {
	return nil, false
}

// AsTagScoringFunction is the BasicScoringFunction implementation for DistanceScoringFunction.
func (dsf DistanceScoringFunction) AsTagScoringFunction() (*TagScoringFunction, bool) {
	return nil, false
}

// AsScoringFunction is the BasicScoringFunction implementation for DistanceScoringFunction.
func (dsf DistanceScoringFunction) AsScoringFunction() (*ScoringFunction, bool) {
	return nil, false
}

// AsBasicScoringFunction is the BasicScoringFunction implementation for DistanceScoringFunction.
func (dsf DistanceScoringFunction) AsBasicScoringFunction() (BasicScoringFunction, bool) {
	return &dsf, true
}

// DistanceScoringParameters provides parameter values to a distance scoring function.
type DistanceScoringParameters struct {
	// ReferencePointParameter - The name of the parameter passed in search queries to specify the reference location.
	ReferencePointParameter *string `json:"referencePointParameter,omitempty"`
	// BoostingDistance - The distance in kilometers from the reference location where the boosting range ends.
	BoostingDistance *float64 `json:"boostingDistance,omitempty"`
}

// DocumentIndexResult response containing the status of operations for all documents in the indexing request.
type DocumentIndexResult struct {
	// Results - The list of status information for each document in the indexing request.
	Results *[]IndexingResult `json:"value,omitempty"`
}

// EdgeNGramTokenFilter generates n-grams of the given size(s) starting from the front or the back of an input token.
// This token filter is implemented using Apache Lucene.
type EdgeNGramTokenFilter struct {
	// Name - The name of the token filter. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeTokenFilter', 'OdataTypeMicrosoftAzureSearchASCIIFoldingTokenFilter', 'OdataTypeMicrosoftAzureSearchCjkBigramTokenFilter', 'OdataTypeMicrosoftAzureSearchCommonGramTokenFilter', 'OdataTypeMicrosoftAzureSearchDictionaryDecompounderTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchElisionTokenFilter', 'OdataTypeMicrosoftAzureSearchKeepTokenFilter', 'OdataTypeMicrosoftAzureSearchKeywordMarkerTokenFilter', 'OdataTypeMicrosoftAzureSearchLengthTokenFilter', 'OdataTypeMicrosoftAzureSearchLimitTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchPatternCaptureTokenFilter', 'OdataTypeMicrosoftAzureSearchPatternReplaceTokenFilter', 'OdataTypeMicrosoftAzureSearchPhoneticTokenFilter', 'OdataTypeMicrosoftAzureSearchShingleTokenFilter', 'OdataTypeMicrosoftAzureSearchSnowballTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerOverrideTokenFilter', 'OdataTypeMicrosoftAzureSearchStopwordsTokenFilter', 'OdataTypeMicrosoftAzureSearchSynonymTokenFilter', 'OdataTypeMicrosoftAzureSearchTruncateTokenFilter', 'OdataTypeMicrosoftAzureSearchUniqueTokenFilter', 'OdataTypeMicrosoftAzureSearchWordDelimiterTokenFilter'
	OdataType OdataTypeBasicTokenFilter `json:"@odata.type,omitempty"`
	// MinGram - The minimum n-gram length. Default is 1. Must be less than the value of maxGram.
	MinGram *int32 `json:"minGram,omitempty"`
	// MaxGram - The maximum n-gram length. Default is 2.
	MaxGram *int32 `json:"maxGram,omitempty"`
	// Side - Specifies which side of the input the n-gram should be generated from. Default is "front". Possible values include: 'Front', 'Back'
	Side EdgeNGramTokenFilterSide `json:"side,omitempty"`
}

// MarshalJSON is the custom marshaler for EdgeNGramTokenFilter.
func (engtf EdgeNGramTokenFilter) MarshalJSON() ([]byte, error) {
	engtf.OdataType = OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilter
	type Alias EdgeNGramTokenFilter
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(engtf),
	})
}

// AsASCIIFoldingTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilter.
func (engtf EdgeNGramTokenFilter) AsASCIIFoldingTokenFilter() (*ASCIIFoldingTokenFilter, bool) {
	return nil, false
}

// AsCjkBigramTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilter.
func (engtf EdgeNGramTokenFilter) AsCjkBigramTokenFilter() (*CjkBigramTokenFilter, bool) {
	return nil, false
}

// AsCommonGramTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilter.
func (engtf EdgeNGramTokenFilter) AsCommonGramTokenFilter() (*CommonGramTokenFilter, bool) {
	return nil, false
}

// AsDictionaryDecompounderTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilter.
func (engtf EdgeNGramTokenFilter) AsDictionaryDecompounderTokenFilter() (*DictionaryDecompounderTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilter.
func (engtf EdgeNGramTokenFilter) AsEdgeNGramTokenFilter() (*EdgeNGramTokenFilter, bool) {
	return &engtf, true
}

// AsEdgeNGramTokenFilterV2 is the BasicTokenFilter implementation for EdgeNGramTokenFilter.
func (engtf EdgeNGramTokenFilter) AsEdgeNGramTokenFilterV2() (*EdgeNGramTokenFilterV2, bool) {
	return nil, false
}

// AsElisionTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilter.
func (engtf EdgeNGramTokenFilter) AsElisionTokenFilter() (*ElisionTokenFilter, bool) {
	return nil, false
}

// AsKeepTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilter.
func (engtf EdgeNGramTokenFilter) AsKeepTokenFilter() (*KeepTokenFilter, bool) {
	return nil, false
}

// AsKeywordMarkerTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilter.
func (engtf EdgeNGramTokenFilter) AsKeywordMarkerTokenFilter() (*KeywordMarkerTokenFilter, bool) {
	return nil, false
}

// AsLengthTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilter.
func (engtf EdgeNGramTokenFilter) AsLengthTokenFilter() (*LengthTokenFilter, bool) {
	return nil, false
}

// AsLimitTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilter.
func (engtf EdgeNGramTokenFilter) AsLimitTokenFilter() (*LimitTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilter.
func (engtf EdgeNGramTokenFilter) AsNGramTokenFilter() (*NGramTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilterV2 is the BasicTokenFilter implementation for EdgeNGramTokenFilter.
func (engtf EdgeNGramTokenFilter) AsNGramTokenFilterV2() (*NGramTokenFilterV2, bool) {
	return nil, false
}

// AsPatternCaptureTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilter.
func (engtf EdgeNGramTokenFilter) AsPatternCaptureTokenFilter() (*PatternCaptureTokenFilter, bool) {
	return nil, false
}

// AsPatternReplaceTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilter.
func (engtf EdgeNGramTokenFilter) AsPatternReplaceTokenFilter() (*PatternReplaceTokenFilter, bool) {
	return nil, false
}

// AsPhoneticTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilter.
func (engtf EdgeNGramTokenFilter) AsPhoneticTokenFilter() (*PhoneticTokenFilter, bool) {
	return nil, false
}

// AsShingleTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilter.
func (engtf EdgeNGramTokenFilter) AsShingleTokenFilter() (*ShingleTokenFilter, bool) {
	return nil, false
}

// AsSnowballTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilter.
func (engtf EdgeNGramTokenFilter) AsSnowballTokenFilter() (*SnowballTokenFilter, bool) {
	return nil, false
}

// AsStemmerTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilter.
func (engtf EdgeNGramTokenFilter) AsStemmerTokenFilter() (*StemmerTokenFilter, bool) {
	return nil, false
}

// AsStemmerOverrideTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilter.
func (engtf EdgeNGramTokenFilter) AsStemmerOverrideTokenFilter() (*StemmerOverrideTokenFilter, bool) {
	return nil, false
}

// AsStopwordsTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilter.
func (engtf EdgeNGramTokenFilter) AsStopwordsTokenFilter() (*StopwordsTokenFilter, bool) {
	return nil, false
}

// AsSynonymTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilter.
func (engtf EdgeNGramTokenFilter) AsSynonymTokenFilter() (*SynonymTokenFilter, bool) {
	return nil, false
}

// AsTruncateTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilter.
func (engtf EdgeNGramTokenFilter) AsTruncateTokenFilter() (*TruncateTokenFilter, bool) {
	return nil, false
}

// AsUniqueTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilter.
func (engtf EdgeNGramTokenFilter) AsUniqueTokenFilter() (*UniqueTokenFilter, bool) {
	return nil, false
}

// AsWordDelimiterTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilter.
func (engtf EdgeNGramTokenFilter) AsWordDelimiterTokenFilter() (*WordDelimiterTokenFilter, bool) {
	return nil, false
}

// AsTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilter.
func (engtf EdgeNGramTokenFilter) AsTokenFilter() (*TokenFilter, bool) {
	return nil, false
}

// AsBasicTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilter.
func (engtf EdgeNGramTokenFilter) AsBasicTokenFilter() (BasicTokenFilter, bool) {
	return &engtf, true
}

// EdgeNGramTokenFilterV2 generates n-grams of the given size(s) starting from the front or the back of an input token.
// This token filter is implemented using Apache Lucene.
type EdgeNGramTokenFilterV2 struct {
	// Name - The name of the token filter. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeTokenFilter', 'OdataTypeMicrosoftAzureSearchASCIIFoldingTokenFilter', 'OdataTypeMicrosoftAzureSearchCjkBigramTokenFilter', 'OdataTypeMicrosoftAzureSearchCommonGramTokenFilter', 'OdataTypeMicrosoftAzureSearchDictionaryDecompounderTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchElisionTokenFilter', 'OdataTypeMicrosoftAzureSearchKeepTokenFilter', 'OdataTypeMicrosoftAzureSearchKeywordMarkerTokenFilter', 'OdataTypeMicrosoftAzureSearchLengthTokenFilter', 'OdataTypeMicrosoftAzureSearchLimitTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchPatternCaptureTokenFilter', 'OdataTypeMicrosoftAzureSearchPatternReplaceTokenFilter', 'OdataTypeMicrosoftAzureSearchPhoneticTokenFilter', 'OdataTypeMicrosoftAzureSearchShingleTokenFilter', 'OdataTypeMicrosoftAzureSearchSnowballTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerOverrideTokenFilter', 'OdataTypeMicrosoftAzureSearchStopwordsTokenFilter', 'OdataTypeMicrosoftAzureSearchSynonymTokenFilter', 'OdataTypeMicrosoftAzureSearchTruncateTokenFilter', 'OdataTypeMicrosoftAzureSearchUniqueTokenFilter', 'OdataTypeMicrosoftAzureSearchWordDelimiterTokenFilter'
	OdataType OdataTypeBasicTokenFilter `json:"@odata.type,omitempty"`
	// MinGram - The minimum n-gram length. Default is 1. Maximum is 300. Must be less than the value of maxGram.
	MinGram *int32 `json:"minGram,omitempty"`
	// MaxGram - The maximum n-gram length. Default is 2. Maximum is 300.
	MaxGram *int32 `json:"maxGram,omitempty"`
	// Side - Specifies which side of the input the n-gram should be generated from. Default is "front". Possible values include: 'Front', 'Back'
	Side EdgeNGramTokenFilterSide `json:"side,omitempty"`
}

// MarshalJSON is the custom marshaler for EdgeNGramTokenFilterV2.
func (engtfv EdgeNGramTokenFilterV2) MarshalJSON() ([]byte, error) {
	engtfv.OdataType = OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilterV2
	type Alias EdgeNGramTokenFilterV2
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(engtfv),
	})
}

// AsASCIIFoldingTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilterV2.
func (engtfv EdgeNGramTokenFilterV2) AsASCIIFoldingTokenFilter() (*ASCIIFoldingTokenFilter, bool) {
	return nil, false
}

// AsCjkBigramTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilterV2.
func (engtfv EdgeNGramTokenFilterV2) AsCjkBigramTokenFilter() (*CjkBigramTokenFilter, bool) {
	return nil, false
}

// AsCommonGramTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilterV2.
func (engtfv EdgeNGramTokenFilterV2) AsCommonGramTokenFilter() (*CommonGramTokenFilter, bool) {
	return nil, false
}

// AsDictionaryDecompounderTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilterV2.
func (engtfv EdgeNGramTokenFilterV2) AsDictionaryDecompounderTokenFilter() (*DictionaryDecompounderTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilterV2.
func (engtfv EdgeNGramTokenFilterV2) AsEdgeNGramTokenFilter() (*EdgeNGramTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilterV2 is the BasicTokenFilter implementation for EdgeNGramTokenFilterV2.
func (engtfv EdgeNGramTokenFilterV2) AsEdgeNGramTokenFilterV2() (*EdgeNGramTokenFilterV2, bool) {
	return &engtfv, true
}

// AsElisionTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilterV2.
func (engtfv EdgeNGramTokenFilterV2) AsElisionTokenFilter() (*ElisionTokenFilter, bool) {
	return nil, false
}

// AsKeepTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilterV2.
func (engtfv EdgeNGramTokenFilterV2) AsKeepTokenFilter() (*KeepTokenFilter, bool) {
	return nil, false
}

// AsKeywordMarkerTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilterV2.
func (engtfv EdgeNGramTokenFilterV2) AsKeywordMarkerTokenFilter() (*KeywordMarkerTokenFilter, bool) {
	return nil, false
}

// AsLengthTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilterV2.
func (engtfv EdgeNGramTokenFilterV2) AsLengthTokenFilter() (*LengthTokenFilter, bool) {
	return nil, false
}

// AsLimitTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilterV2.
func (engtfv EdgeNGramTokenFilterV2) AsLimitTokenFilter() (*LimitTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilterV2.
func (engtfv EdgeNGramTokenFilterV2) AsNGramTokenFilter() (*NGramTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilterV2 is the BasicTokenFilter implementation for EdgeNGramTokenFilterV2.
func (engtfv EdgeNGramTokenFilterV2) AsNGramTokenFilterV2() (*NGramTokenFilterV2, bool) {
	return nil, false
}

// AsPatternCaptureTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilterV2.
func (engtfv EdgeNGramTokenFilterV2) AsPatternCaptureTokenFilter() (*PatternCaptureTokenFilter, bool) {
	return nil, false
}

// AsPatternReplaceTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilterV2.
func (engtfv EdgeNGramTokenFilterV2) AsPatternReplaceTokenFilter() (*PatternReplaceTokenFilter, bool) {
	return nil, false
}

// AsPhoneticTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilterV2.
func (engtfv EdgeNGramTokenFilterV2) AsPhoneticTokenFilter() (*PhoneticTokenFilter, bool) {
	return nil, false
}

// AsShingleTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilterV2.
func (engtfv EdgeNGramTokenFilterV2) AsShingleTokenFilter() (*ShingleTokenFilter, bool) {
	return nil, false
}

// AsSnowballTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilterV2.
func (engtfv EdgeNGramTokenFilterV2) AsSnowballTokenFilter() (*SnowballTokenFilter, bool) {
	return nil, false
}

// AsStemmerTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilterV2.
func (engtfv EdgeNGramTokenFilterV2) AsStemmerTokenFilter() (*StemmerTokenFilter, bool) {
	return nil, false
}

// AsStemmerOverrideTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilterV2.
func (engtfv EdgeNGramTokenFilterV2) AsStemmerOverrideTokenFilter() (*StemmerOverrideTokenFilter, bool) {
	return nil, false
}

// AsStopwordsTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilterV2.
func (engtfv EdgeNGramTokenFilterV2) AsStopwordsTokenFilter() (*StopwordsTokenFilter, bool) {
	return nil, false
}

// AsSynonymTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilterV2.
func (engtfv EdgeNGramTokenFilterV2) AsSynonymTokenFilter() (*SynonymTokenFilter, bool) {
	return nil, false
}

// AsTruncateTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilterV2.
func (engtfv EdgeNGramTokenFilterV2) AsTruncateTokenFilter() (*TruncateTokenFilter, bool) {
	return nil, false
}

// AsUniqueTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilterV2.
func (engtfv EdgeNGramTokenFilterV2) AsUniqueTokenFilter() (*UniqueTokenFilter, bool) {
	return nil, false
}

// AsWordDelimiterTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilterV2.
func (engtfv EdgeNGramTokenFilterV2) AsWordDelimiterTokenFilter() (*WordDelimiterTokenFilter, bool) {
	return nil, false
}

// AsTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilterV2.
func (engtfv EdgeNGramTokenFilterV2) AsTokenFilter() (*TokenFilter, bool) {
	return nil, false
}

// AsBasicTokenFilter is the BasicTokenFilter implementation for EdgeNGramTokenFilterV2.
func (engtfv EdgeNGramTokenFilterV2) AsBasicTokenFilter() (BasicTokenFilter, bool) {
	return &engtfv, true
}

// EdgeNGramTokenizer tokenizes the input from an edge into n-grams of the given size(s). This tokenizer is implemented
// using Apache Lucene.
type EdgeNGramTokenizer struct {
	// Name - The name of the tokenizer. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeTokenizer', 'OdataTypeMicrosoftAzureSearchClassicTokenizer', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenizer', 'OdataTypeMicrosoftAzureSearchKeywordTokenizer', 'OdataTypeMicrosoftAzureSearchKeywordTokenizerV2', 'OdataTypeMicrosoftAzureSearchMicrosoftLanguageTokenizer', 'OdataTypeMicrosoftAzureSearchMicrosoftLanguageStemmingTokenizer', 'OdataTypeMicrosoftAzureSearchNGramTokenizer', 'OdataTypeMicrosoftAzureSearchPathHierarchyTokenizer', 'OdataTypeMicrosoftAzureSearchPathHierarchyTokenizerV2', 'OdataTypeMicrosoftAzureSearchPatternTokenizer', 'OdataTypeMicrosoftAzureSearchStandardTokenizer', 'OdataTypeMicrosoftAzureSearchStandardTokenizerV2', 'OdataTypeMicrosoftAzureSearchUaxURLEmailTokenizer'
	OdataType OdataTypeBasicTokenizer `json:"@odata.type,omitempty"`
	// MinGram - The minimum n-gram length. Default is 1. Maximum is 300. Must be less than the value of maxGram.
	MinGram *int32 `json:"minGram,omitempty"`
	// MaxGram - The maximum n-gram length. Default is 2. Maximum is 300.
	MaxGram *int32 `json:"maxGram,omitempty"`
	// TokenChars - Character classes to keep in the tokens.
	TokenChars *[]TokenCharacterKind `json:"tokenChars,omitempty"`
}

// MarshalJSON is the custom marshaler for EdgeNGramTokenizer.
func (engt EdgeNGramTokenizer) MarshalJSON() ([]byte, error) {
	engt.OdataType = OdataTypeMicrosoftAzureSearchEdgeNGramTokenizer
	type Alias EdgeNGramTokenizer
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(engt),
	})
}

// AsClassicTokenizer is the BasicTokenizer implementation for EdgeNGramTokenizer.
func (engt EdgeNGramTokenizer) AsClassicTokenizer() (*ClassicTokenizer, bool) {
	return nil, false
}

// AsEdgeNGramTokenizer is the BasicTokenizer implementation for EdgeNGramTokenizer.
func (engt EdgeNGramTokenizer) AsEdgeNGramTokenizer() (*EdgeNGramTokenizer, bool) {
	return &engt, true
}

// AsKeywordTokenizer is the BasicTokenizer implementation for EdgeNGramTokenizer.
func (engt EdgeNGramTokenizer) AsKeywordTokenizer() (*KeywordTokenizer, bool) {
	return nil, false
}

// AsKeywordTokenizerV2 is the BasicTokenizer implementation for EdgeNGramTokenizer.
func (engt EdgeNGramTokenizer) AsKeywordTokenizerV2() (*KeywordTokenizerV2, bool) {
	return nil, false
}

// AsMicrosoftLanguageTokenizer is the BasicTokenizer implementation for EdgeNGramTokenizer.
func (engt EdgeNGramTokenizer) AsMicrosoftLanguageTokenizer() (*MicrosoftLanguageTokenizer, bool) {
	return nil, false
}

// AsMicrosoftLanguageStemmingTokenizer is the BasicTokenizer implementation for EdgeNGramTokenizer.
func (engt EdgeNGramTokenizer) AsMicrosoftLanguageStemmingTokenizer() (*MicrosoftLanguageStemmingTokenizer, bool) {
	return nil, false
}

// AsNGramTokenizer is the BasicTokenizer implementation for EdgeNGramTokenizer.
func (engt EdgeNGramTokenizer) AsNGramTokenizer() (*NGramTokenizer, bool) {
	return nil, false
}

// AsPathHierarchyTokenizer is the BasicTokenizer implementation for EdgeNGramTokenizer.
func (engt EdgeNGramTokenizer) AsPathHierarchyTokenizer() (*PathHierarchyTokenizer, bool) {
	return nil, false
}

// AsPathHierarchyTokenizerV2 is the BasicTokenizer implementation for EdgeNGramTokenizer.
func (engt EdgeNGramTokenizer) AsPathHierarchyTokenizerV2() (*PathHierarchyTokenizerV2, bool) {
	return nil, false
}

// AsPatternTokenizer is the BasicTokenizer implementation for EdgeNGramTokenizer.
func (engt EdgeNGramTokenizer) AsPatternTokenizer() (*PatternTokenizer, bool) {
	return nil, false
}

// AsStandardTokenizer is the BasicTokenizer implementation for EdgeNGramTokenizer.
func (engt EdgeNGramTokenizer) AsStandardTokenizer() (*StandardTokenizer, bool) {
	return nil, false
}

// AsStandardTokenizerV2 is the BasicTokenizer implementation for EdgeNGramTokenizer.
func (engt EdgeNGramTokenizer) AsStandardTokenizerV2() (*StandardTokenizerV2, bool) {
	return nil, false
}

// AsUaxURLEmailTokenizer is the BasicTokenizer implementation for EdgeNGramTokenizer.
func (engt EdgeNGramTokenizer) AsUaxURLEmailTokenizer() (*UaxURLEmailTokenizer, bool) {
	return nil, false
}

// AsTokenizer is the BasicTokenizer implementation for EdgeNGramTokenizer.
func (engt EdgeNGramTokenizer) AsTokenizer() (*Tokenizer, bool) {
	return nil, false
}

// AsBasicTokenizer is the BasicTokenizer implementation for EdgeNGramTokenizer.
func (engt EdgeNGramTokenizer) AsBasicTokenizer() (BasicTokenizer, bool) {
	return &engt, true
}

// ElisionTokenFilter removes elisions. For example, "l'avion" (the plane) will be converted to "avion" (plane). This
// token filter is implemented using Apache Lucene.
type ElisionTokenFilter struct {
	// Name - The name of the token filter. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeTokenFilter', 'OdataTypeMicrosoftAzureSearchASCIIFoldingTokenFilter', 'OdataTypeMicrosoftAzureSearchCjkBigramTokenFilter', 'OdataTypeMicrosoftAzureSearchCommonGramTokenFilter', 'OdataTypeMicrosoftAzureSearchDictionaryDecompounderTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchElisionTokenFilter', 'OdataTypeMicrosoftAzureSearchKeepTokenFilter', 'OdataTypeMicrosoftAzureSearchKeywordMarkerTokenFilter', 'OdataTypeMicrosoftAzureSearchLengthTokenFilter', 'OdataTypeMicrosoftAzureSearchLimitTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchPatternCaptureTokenFilter', 'OdataTypeMicrosoftAzureSearchPatternReplaceTokenFilter', 'OdataTypeMicrosoftAzureSearchPhoneticTokenFilter', 'OdataTypeMicrosoftAzureSearchShingleTokenFilter', 'OdataTypeMicrosoftAzureSearchSnowballTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerOverrideTokenFilter', 'OdataTypeMicrosoftAzureSearchStopwordsTokenFilter', 'OdataTypeMicrosoftAzureSearchSynonymTokenFilter', 'OdataTypeMicrosoftAzureSearchTruncateTokenFilter', 'OdataTypeMicrosoftAzureSearchUniqueTokenFilter', 'OdataTypeMicrosoftAzureSearchWordDelimiterTokenFilter'
	OdataType OdataTypeBasicTokenFilter `json:"@odata.type,omitempty"`
	// Articles - The set of articles to remove.
	Articles *[]string `json:"articles,omitempty"`
}

// MarshalJSON is the custom marshaler for ElisionTokenFilter.
func (etf ElisionTokenFilter) MarshalJSON() ([]byte, error) {
	etf.OdataType = OdataTypeMicrosoftAzureSearchElisionTokenFilter
	type Alias ElisionTokenFilter
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(etf),
	})
}

// AsASCIIFoldingTokenFilter is the BasicTokenFilter implementation for ElisionTokenFilter.
func (etf ElisionTokenFilter) AsASCIIFoldingTokenFilter() (*ASCIIFoldingTokenFilter, bool) {
	return nil, false
}

// AsCjkBigramTokenFilter is the BasicTokenFilter implementation for ElisionTokenFilter.
func (etf ElisionTokenFilter) AsCjkBigramTokenFilter() (*CjkBigramTokenFilter, bool) {
	return nil, false
}

// AsCommonGramTokenFilter is the BasicTokenFilter implementation for ElisionTokenFilter.
func (etf ElisionTokenFilter) AsCommonGramTokenFilter() (*CommonGramTokenFilter, bool) {
	return nil, false
}

// AsDictionaryDecompounderTokenFilter is the BasicTokenFilter implementation for ElisionTokenFilter.
func (etf ElisionTokenFilter) AsDictionaryDecompounderTokenFilter() (*DictionaryDecompounderTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilter is the BasicTokenFilter implementation for ElisionTokenFilter.
func (etf ElisionTokenFilter) AsEdgeNGramTokenFilter() (*EdgeNGramTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilterV2 is the BasicTokenFilter implementation for ElisionTokenFilter.
func (etf ElisionTokenFilter) AsEdgeNGramTokenFilterV2() (*EdgeNGramTokenFilterV2, bool) {
	return nil, false
}

// AsElisionTokenFilter is the BasicTokenFilter implementation for ElisionTokenFilter.
func (etf ElisionTokenFilter) AsElisionTokenFilter() (*ElisionTokenFilter, bool) {
	return &etf, true
}

// AsKeepTokenFilter is the BasicTokenFilter implementation for ElisionTokenFilter.
func (etf ElisionTokenFilter) AsKeepTokenFilter() (*KeepTokenFilter, bool) {
	return nil, false
}

// AsKeywordMarkerTokenFilter is the BasicTokenFilter implementation for ElisionTokenFilter.
func (etf ElisionTokenFilter) AsKeywordMarkerTokenFilter() (*KeywordMarkerTokenFilter, bool) {
	return nil, false
}

// AsLengthTokenFilter is the BasicTokenFilter implementation for ElisionTokenFilter.
func (etf ElisionTokenFilter) AsLengthTokenFilter() (*LengthTokenFilter, bool) {
	return nil, false
}

// AsLimitTokenFilter is the BasicTokenFilter implementation for ElisionTokenFilter.
func (etf ElisionTokenFilter) AsLimitTokenFilter() (*LimitTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilter is the BasicTokenFilter implementation for ElisionTokenFilter.
func (etf ElisionTokenFilter) AsNGramTokenFilter() (*NGramTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilterV2 is the BasicTokenFilter implementation for ElisionTokenFilter.
func (etf ElisionTokenFilter) AsNGramTokenFilterV2() (*NGramTokenFilterV2, bool) {
	return nil, false
}

// AsPatternCaptureTokenFilter is the BasicTokenFilter implementation for ElisionTokenFilter.
func (etf ElisionTokenFilter) AsPatternCaptureTokenFilter() (*PatternCaptureTokenFilter, bool) {
	return nil, false
}

// AsPatternReplaceTokenFilter is the BasicTokenFilter implementation for ElisionTokenFilter.
func (etf ElisionTokenFilter) AsPatternReplaceTokenFilter() (*PatternReplaceTokenFilter, bool) {
	return nil, false
}

// AsPhoneticTokenFilter is the BasicTokenFilter implementation for ElisionTokenFilter.
func (etf ElisionTokenFilter) AsPhoneticTokenFilter() (*PhoneticTokenFilter, bool) {
	return nil, false
}

// AsShingleTokenFilter is the BasicTokenFilter implementation for ElisionTokenFilter.
func (etf ElisionTokenFilter) AsShingleTokenFilter() (*ShingleTokenFilter, bool) {
	return nil, false
}

// AsSnowballTokenFilter is the BasicTokenFilter implementation for ElisionTokenFilter.
func (etf ElisionTokenFilter) AsSnowballTokenFilter() (*SnowballTokenFilter, bool) {
	return nil, false
}

// AsStemmerTokenFilter is the BasicTokenFilter implementation for ElisionTokenFilter.
func (etf ElisionTokenFilter) AsStemmerTokenFilter() (*StemmerTokenFilter, bool) {
	return nil, false
}

// AsStemmerOverrideTokenFilter is the BasicTokenFilter implementation for ElisionTokenFilter.
func (etf ElisionTokenFilter) AsStemmerOverrideTokenFilter() (*StemmerOverrideTokenFilter, bool) {
	return nil, false
}

// AsStopwordsTokenFilter is the BasicTokenFilter implementation for ElisionTokenFilter.
func (etf ElisionTokenFilter) AsStopwordsTokenFilter() (*StopwordsTokenFilter, bool) {
	return nil, false
}

// AsSynonymTokenFilter is the BasicTokenFilter implementation for ElisionTokenFilter.
func (etf ElisionTokenFilter) AsSynonymTokenFilter() (*SynonymTokenFilter, bool) {
	return nil, false
}

// AsTruncateTokenFilter is the BasicTokenFilter implementation for ElisionTokenFilter.
func (etf ElisionTokenFilter) AsTruncateTokenFilter() (*TruncateTokenFilter, bool) {
	return nil, false
}

// AsUniqueTokenFilter is the BasicTokenFilter implementation for ElisionTokenFilter.
func (etf ElisionTokenFilter) AsUniqueTokenFilter() (*UniqueTokenFilter, bool) {
	return nil, false
}

// AsWordDelimiterTokenFilter is the BasicTokenFilter implementation for ElisionTokenFilter.
func (etf ElisionTokenFilter) AsWordDelimiterTokenFilter() (*WordDelimiterTokenFilter, bool) {
	return nil, false
}

// AsTokenFilter is the BasicTokenFilter implementation for ElisionTokenFilter.
func (etf ElisionTokenFilter) AsTokenFilter() (*TokenFilter, bool) {
	return nil, false
}

// AsBasicTokenFilter is the BasicTokenFilter implementation for ElisionTokenFilter.
func (etf ElisionTokenFilter) AsBasicTokenFilter() (BasicTokenFilter, bool) {
	return &etf, true
}

// Field represents a field in an index definition in Azure Search, which describes the name, data type, and search
// behavior of a field.
type Field struct {
	// Name - The name of the field.
	Name *string `json:"name,omitempty"`
	// Type - The data type of the field.
	Type *DataType `json:"type,omitempty"`
	// Analyzer - The name of the analyzer to use for the field at search time and indexing time. This option can be used only with searchable fields and it can't be set together with either searchAnalyzer or indexAnalyzer. Once the analyzer is chosen, it cannot be changed for the field.
	Analyzer *AnalyzerName `json:"analyzer,omitempty"`
	// SearchAnalyzer - The name of the analyzer used at search time for the field. This option can be used only with searchable fields. It must be set together with indexAnalyzer and it cannot be set together with the analyzer option. This analyzer can be updated on an existing field.
	SearchAnalyzer *AnalyzerName `json:"searchAnalyzer,omitempty"`
	// IndexAnalyzer - The name of the analyzer used at indexing time for the field. This option can be used only with searchable fields. It must be set together with searchAnalyzer and it cannot be set together with the analyzer option. Once the analyzer is chosen, it cannot be changed for the field.
	IndexAnalyzer *AnalyzerName `json:"indexAnalyzer,omitempty"`
	// IsKey - A value indicating whether the field is the key of the index. Valid only for string fields. Every index must have exactly one key field.
	IsKey *bool `json:"key,omitempty"`
	// IsSearchable - A value indicating whether the field is included in full-text searches. Valid only forstring or string collection fields. Default is false.
	IsSearchable *bool `json:"searchable,omitempty"`
	// IsFilterable - A value indicating whether the field can be used in filter expressions. Default is false.
	IsFilterable *bool `json:"filterable,omitempty"`
	// IsSortable - A value indicating whether the field can be used in orderby expressions. Not valid for string collection fields. Default is false.
	IsSortable *bool `json:"sortable,omitempty"`
	// IsFacetable - A value indicating whether it is possible to facet on this field. Not valid for geo-point fields. Default is false.
	IsFacetable *bool `json:"facetable,omitempty"`
	// IsRetrievable - A value indicating whether the field can be returned in a search result. Default is true.
	IsRetrievable *bool `json:"retrievable,omitempty"`
}

// FieldMapping defines a mapping between a field in a data source and a target field in an index.
type FieldMapping struct {
	// SourceFieldName - The name of the field in the data source.
	SourceFieldName *string `json:"sourceFieldName,omitempty"`
	// TargetFieldName - The name of the target field in the index. Same as the source field name by default.
	TargetFieldName *string `json:"targetFieldName,omitempty"`
	// MappingFunction - A function to apply to each source field value before indexing.
	MappingFunction *FieldMappingFunction `json:"mappingFunction,omitempty"`
}

// FieldMappingFunction represents a function that transforms a value from a data source before indexing.
type FieldMappingFunction struct {
	// Name - The name of the field mapping function.
	Name *string `json:"name,omitempty"`
	// Parameters - A dictionary of parameter name/value pairs to pass to the function. Each value must be of a primitive type.
	Parameters *map[string]*map[string]interface{} `json:"parameters,omitempty"`
}

// FreshnessScoringFunction defines a function that boosts scores based on the value of a date-time field.
type FreshnessScoringFunction struct {
	// FieldName - The name of the field used as input to the scoring function.
	FieldName *string `json:"fieldName,omitempty"`
	// Boost - A multiplier for the raw score. Must be a positive number not equal to 1.0.
	Boost *float64 `json:"boost,omitempty"`
	// Interpolation - A value indicating how boosting will be interpolated across document scores; defaults to "Linear". Possible values include: 'Linear', 'Constant', 'Quadratic', 'Logarithmic'
	Interpolation ScoringFunctionInterpolation `json:"interpolation,omitempty"`
	// Type - Possible values include: 'TypeScoringFunction', 'TypeDistance', 'TypeFreshness', 'TypeMagnitude', 'TypeTag'
	Type Type `json:"type,omitempty"`
	// Parameters - Parameter values for the freshness scoring function.
	Parameters *FreshnessScoringParameters `json:"freshness,omitempty"`
}

// MarshalJSON is the custom marshaler for FreshnessScoringFunction.
func (fsf FreshnessScoringFunction) MarshalJSON() ([]byte, error) {
	fsf.Type = TypeFreshness
	type Alias FreshnessScoringFunction
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(fsf),
	})
}

// AsDistanceScoringFunction is the BasicScoringFunction implementation for FreshnessScoringFunction.
func (fsf FreshnessScoringFunction) AsDistanceScoringFunction() (*DistanceScoringFunction, bool) {
	return nil, false
}

// AsFreshnessScoringFunction is the BasicScoringFunction implementation for FreshnessScoringFunction.
func (fsf FreshnessScoringFunction) AsFreshnessScoringFunction() (*FreshnessScoringFunction, bool) {
	return &fsf, true
}

// AsMagnitudeScoringFunction is the BasicScoringFunction implementation for FreshnessScoringFunction.
func (fsf FreshnessScoringFunction) AsMagnitudeScoringFunction() (*MagnitudeScoringFunction, bool) {
	return nil, false
}

// AsTagScoringFunction is the BasicScoringFunction implementation for FreshnessScoringFunction.
func (fsf FreshnessScoringFunction) AsTagScoringFunction() (*TagScoringFunction, bool) {
	return nil, false
}

// AsScoringFunction is the BasicScoringFunction implementation for FreshnessScoringFunction.
func (fsf FreshnessScoringFunction) AsScoringFunction() (*ScoringFunction, bool) {
	return nil, false
}

// AsBasicScoringFunction is the BasicScoringFunction implementation for FreshnessScoringFunction.
func (fsf FreshnessScoringFunction) AsBasicScoringFunction() (BasicScoringFunction, bool) {
	return &fsf, true
}

// FreshnessScoringParameters provides parameter values to a freshness scoring function.
type FreshnessScoringParameters struct {
	// BoostingDuration - The expiration period after which boosting will stop for a particular document.
	BoostingDuration *string `json:"boostingDuration,omitempty"`
}

// HighWaterMarkChangeDetectionPolicy defines a data change detection policy that captures changes based on the value
// of a high water mark column.
type HighWaterMarkChangeDetectionPolicy struct {
	// OdataType - Possible values include: 'OdataTypeDataChangeDetectionPolicy', 'OdataTypeMicrosoftAzureSearchHighWaterMarkChangeDetectionPolicy', 'OdataTypeMicrosoftAzureSearchSQLIntegratedChangeTrackingPolicy'
	OdataType OdataTypeBasicDataChangeDetectionPolicy `json:"@odata.type,omitempty"`
	// HighWaterMarkColumnName - The name of the high water mark column.
	HighWaterMarkColumnName *string `json:"highWaterMarkColumnName,omitempty"`
}

// MarshalJSON is the custom marshaler for HighWaterMarkChangeDetectionPolicy.
func (hwmcdp HighWaterMarkChangeDetectionPolicy) MarshalJSON() ([]byte, error) {
	hwmcdp.OdataType = OdataTypeMicrosoftAzureSearchHighWaterMarkChangeDetectionPolicy
	type Alias HighWaterMarkChangeDetectionPolicy
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(hwmcdp),
	})
}

// AsHighWaterMarkChangeDetectionPolicy is the BasicDataChangeDetectionPolicy implementation for HighWaterMarkChangeDetectionPolicy.
func (hwmcdp HighWaterMarkChangeDetectionPolicy) AsHighWaterMarkChangeDetectionPolicy() (*HighWaterMarkChangeDetectionPolicy, bool) {
	return &hwmcdp, true
}

// AsSQLIntegratedChangeTrackingPolicy is the BasicDataChangeDetectionPolicy implementation for HighWaterMarkChangeDetectionPolicy.
func (hwmcdp HighWaterMarkChangeDetectionPolicy) AsSQLIntegratedChangeTrackingPolicy() (*SQLIntegratedChangeTrackingPolicy, bool) {
	return nil, false
}

// AsDataChangeDetectionPolicy is the BasicDataChangeDetectionPolicy implementation for HighWaterMarkChangeDetectionPolicy.
func (hwmcdp HighWaterMarkChangeDetectionPolicy) AsDataChangeDetectionPolicy() (*DataChangeDetectionPolicy, bool) {
	return nil, false
}

// AsBasicDataChangeDetectionPolicy is the BasicDataChangeDetectionPolicy implementation for HighWaterMarkChangeDetectionPolicy.
func (hwmcdp HighWaterMarkChangeDetectionPolicy) AsBasicDataChangeDetectionPolicy() (BasicDataChangeDetectionPolicy, bool) {
	return &hwmcdp, true
}

// Index represents an index definition in Azure Search, which describes the fields and search behavior of an index.
type Index struct {
	autorest.Response `json:"-"`
	// Name - The name of the index.
	Name *string `json:"name,omitempty"`
	// Fields - The fields of the index.
	Fields *[]Field `json:"fields,omitempty"`
	// ScoringProfiles - The scoring profiles for the index.
	ScoringProfiles *[]ScoringProfile `json:"scoringProfiles,omitempty"`
	// DefaultScoringProfile - The name of the scoring profile to use if none is specified in the query. If this property is not set and no scoring profile is specified in the query, then default scoring (tf-idf) will be used.
	DefaultScoringProfile *string `json:"defaultScoringProfile,omitempty"`
	// CorsOptions - Options to control Cross-Origin Resource Sharing (CORS) for the index.
	CorsOptions *CorsOptions `json:"corsOptions,omitempty"`
	// Suggesters - The suggesters for the index.
	Suggesters *[]Suggester `json:"suggesters,omitempty"`
	// Analyzers - The analyzers for the index.
	Analyzers *[]BasicAnalyzer `json:"analyzers,omitempty"`
	// Tokenizers - The tokenizers for the index.
	Tokenizers *[]BasicTokenizer `json:"tokenizers,omitempty"`
	// TokenFilters - The token filters for the index.
	TokenFilters *[]BasicTokenFilter `json:"tokenFilters,omitempty"`
	// CharFilters - The character filters for the index.
	CharFilters *[]BasicCharFilter `json:"charFilters,omitempty"`
	// ETag - The ETag of the index.
	ETag *string `json:"@odata.etag,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for Index struct.
func (i *Index) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		i.Name = &name
	}

	v = m["fields"]
	if v != nil {
		var fields []Field
		err = json.Unmarshal(*m["fields"], &fields)
		if err != nil {
			return err
		}
		i.Fields = &fields
	}

	v = m["scoringProfiles"]
	if v != nil {
		var scoringProfiles []ScoringProfile
		err = json.Unmarshal(*m["scoringProfiles"], &scoringProfiles)
		if err != nil {
			return err
		}
		i.ScoringProfiles = &scoringProfiles
	}

	v = m["defaultScoringProfile"]
	if v != nil {
		var defaultScoringProfile string
		err = json.Unmarshal(*m["defaultScoringProfile"], &defaultScoringProfile)
		if err != nil {
			return err
		}
		i.DefaultScoringProfile = &defaultScoringProfile
	}

	v = m["corsOptions"]
	if v != nil {
		var corsOptions CorsOptions
		err = json.Unmarshal(*m["corsOptions"], &corsOptions)
		if err != nil {
			return err
		}
		i.CorsOptions = &corsOptions
	}

	v = m["suggesters"]
	if v != nil {
		var suggesters []Suggester
		err = json.Unmarshal(*m["suggesters"], &suggesters)
		if err != nil {
			return err
		}
		i.Suggesters = &suggesters
	}

	v = m["analyzers"]
	if v != nil {
		analyzers, err := unmarshalBasicAnalyzerArray(*m["analyzers"])
		if err != nil {
			return err
		}
		i.Analyzers = &analyzers
	}

	v = m["tokenizers"]
	if v != nil {
		tokenizers, err := unmarshalBasicTokenizerArray(*m["tokenizers"])
		if err != nil {
			return err
		}
		i.Tokenizers = &tokenizers
	}

	v = m["tokenFilters"]
	if v != nil {
		tokenFilters, err := unmarshalBasicTokenFilterArray(*m["tokenFilters"])
		if err != nil {
			return err
		}
		i.TokenFilters = &tokenFilters
	}

	v = m["charFilters"]
	if v != nil {
		charFilters, err := unmarshalBasicCharFilterArray(*m["charFilters"])
		if err != nil {
			return err
		}
		i.CharFilters = &charFilters
	}

	v = m["@odata.etag"]
	if v != nil {
		var odataetag string
		err = json.Unmarshal(*m["@odata.etag"], &odataetag)
		if err != nil {
			return err
		}
		i.ETag = &odataetag
	}

	return nil
}

// Indexer represents an Azure Search indexer.
type Indexer struct {
	autorest.Response `json:"-"`
	// Name - The name of the indexer.
	Name *string `json:"name,omitempty"`
	// Description - The description of the indexer.
	Description *string `json:"description,omitempty"`
	// DataSourceName - The name of the datasource from which this indexer reads data.
	DataSourceName *string `json:"dataSourceName,omitempty"`
	// TargetIndexName - The name of the index to which this indexer writes data.
	TargetIndexName *string `json:"targetIndexName,omitempty"`
	// Schedule - The schedule for this indexer.
	Schedule *IndexingSchedule `json:"schedule,omitempty"`
	// Parameters - Parameters for indexer execution.
	Parameters *IndexingParameters `json:"parameters,omitempty"`
	// FieldMappings - Defines mappings between fields in the data source and corresponding target fields in the index.
	FieldMappings *[]FieldMapping `json:"fieldMappings,omitempty"`
	// IsDisabled - A value indicating whether the indexer is disabled. Default is false.
	IsDisabled *bool `json:"disabled,omitempty"`
	// ETag - The ETag of the Indexer.
	ETag *string `json:"@odata.etag,omitempty"`
}

// IndexerExecutionInfo represents the current status and execution history of an indexer.
type IndexerExecutionInfo struct {
	autorest.Response `json:"-"`
	// Status - Overall indexer status. Possible values include: 'Unknown', 'Error', 'Running'
	Status IndexerStatus `json:"status,omitempty"`
	// LastResult - The result of the most recent or an in-progress indexer execution.
	LastResult *IndexerExecutionResult `json:"lastResult,omitempty"`
	// ExecutionHistory - History of the recent indexer executions, sorted in reverse chronological order.
	ExecutionHistory *[]IndexerExecutionResult `json:"executionHistory,omitempty"`
}

// IndexerExecutionResult represents the result of an individual indexer execution.
type IndexerExecutionResult struct {
	// Status - The outcome of this indexer execution. Possible values include: 'TransientFailure', 'Success', 'InProgress', 'Reset'
	Status IndexerExecutionStatus `json:"status,omitempty"`
	// ErrorMessage - The error message indicating the top-level error, if any.
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// StartTime - The start time of this indexer execution.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The end time of this indexer execution, if the execution has already completed.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Errors - The item-level indexing errors
	Errors *[]ItemError `json:"errors,omitempty"`
	// ItemCount - The number of items that were processed during this indexer execution. This includes both successfully processed items and items where indexing was attempted but failed.
	ItemCount *int32 `json:"itemsProcessed,omitempty"`
	// FailedItemCount - The number of items that failed to be indexed during this indexer execution.
	FailedItemCount *int32 `json:"itemsFailed,omitempty"`
	// InitialTrackingState - Change tracking state with which an indexer execution started.
	InitialTrackingState *string `json:"initialTrackingState,omitempty"`
	// FinalTrackingState - Change tracking state with which an indexer execution finished.
	FinalTrackingState *string `json:"finalTrackingState,omitempty"`
}

// IndexerListResult response from a List Indexers request. If successful, it includes the full definitions of all
// indexers.
type IndexerListResult struct {
	autorest.Response `json:"-"`
	// Indexers - The indexers in the Search service.
	Indexers *[]Indexer `json:"value,omitempty"`
}

// IndexGetStatisticsResult statistics for a given index. Statistics are collected periodically and are not guaranteed
// to always be up-to-date.
type IndexGetStatisticsResult struct {
	autorest.Response `json:"-"`
	// DocumentCount - The number of documents in the index.
	DocumentCount *int64 `json:"documentCount,omitempty"`
	// StorageSize - The amount of storage in bytes consumed by the index.
	StorageSize *int64 `json:"storageSize,omitempty"`
}

// IndexingParameters represents parameters for indexer execution.
type IndexingParameters struct {
	// BatchSize - The number of items that are read from the data source and indexed as a single batch in order to improve performance. The default depends on the data source type.
	BatchSize *int32 `json:"batchSize,omitempty"`
	// MaxFailedItems - The maximum number of items that can fail indexing for indexer execution to still be considered successful. -1 means no limit. Default is 0.
	MaxFailedItems *int32 `json:"maxFailedItems,omitempty"`
	// MaxFailedItemsPerBatch - The maximum number of items in a single batch that can fail indexing for the batch to still be considered successful. -1 means no limit. Default is 0.
	MaxFailedItemsPerBatch *int32 `json:"maxFailedItemsPerBatch,omitempty"`
	// Base64EncodeKeys - Whether indexer will base64-encode all values that are inserted into key field of the target index. This is needed if keys can contain characters that are invalid in keys (such as dot '.'). Default is false.
	Base64EncodeKeys *bool `json:"base64EncodeKeys,omitempty"`
	// Configuration - A dictionary of indexer-specific configuration properties. Each name is the name of a specific property. Each value must be of a primitive type.
	Configuration *map[string]*map[string]interface{} `json:"configuration,omitempty"`
}

// IndexingResult status of an indexing operation for a single document.
type IndexingResult struct {
	// Key - The key of a document that was in the indexing request.
	Key *string `json:"key,omitempty"`
	// ErrorMessage - The error message explaining why the indexing operation failed for the document identified by the key; null if indexing succeeded.
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// Succeeded - A value indicating whether the indexing operation succeeded for the document identified by the key.
	Succeeded *bool `json:"status,omitempty"`
	// StatusCode - The status code of the indexing operation. Possible values include: 200 for a successful update or delete, 201 for successful document creation, 400 for a malformed input document, 404 for document not found, 409 for a version conflict, 422 when the index is temporarily unavailable, or 503 for when the service is too busy.
	StatusCode *int32 `json:"statusCode,omitempty"`
}

// IndexingSchedule represents a schedule for indexer execution.
type IndexingSchedule struct {
	// Interval - The interval of time between indexer executions.
	Interval *string `json:"interval,omitempty"`
	// StartTime - The time when an indexer should start running.
	StartTime *date.Time `json:"startTime,omitempty"`
}

// IndexListResult response from a List Indexes request. If successful, it includes the full definitions of all
// indexes.
type IndexListResult struct {
	autorest.Response `json:"-"`
	// Indexes - The indexes in the Search service.
	Indexes *[]Index `json:"value,omitempty"`
}

// Int64 ...
type Int64 struct {
	autorest.Response `json:"-"`
	Value             *int64 `json:"value,omitempty"`
}

// ItemError represents an item- or document-level indexing error.
type ItemError struct {
	// Key - The key of the item for which indexing failed.
	Key *string `json:"key,omitempty"`
	// ErrorMessage - The message describing the error that occurred while attempting to index the item.
	ErrorMessage *string `json:"errorMessage,omitempty"`
}

// KeepTokenFilter a token filter that only keeps tokens with text contained in a specified list of words. This token
// filter is implemented using Apache Lucene.
type KeepTokenFilter struct {
	// Name - The name of the token filter. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeTokenFilter', 'OdataTypeMicrosoftAzureSearchASCIIFoldingTokenFilter', 'OdataTypeMicrosoftAzureSearchCjkBigramTokenFilter', 'OdataTypeMicrosoftAzureSearchCommonGramTokenFilter', 'OdataTypeMicrosoftAzureSearchDictionaryDecompounderTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchElisionTokenFilter', 'OdataTypeMicrosoftAzureSearchKeepTokenFilter', 'OdataTypeMicrosoftAzureSearchKeywordMarkerTokenFilter', 'OdataTypeMicrosoftAzureSearchLengthTokenFilter', 'OdataTypeMicrosoftAzureSearchLimitTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchPatternCaptureTokenFilter', 'OdataTypeMicrosoftAzureSearchPatternReplaceTokenFilter', 'OdataTypeMicrosoftAzureSearchPhoneticTokenFilter', 'OdataTypeMicrosoftAzureSearchShingleTokenFilter', 'OdataTypeMicrosoftAzureSearchSnowballTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerOverrideTokenFilter', 'OdataTypeMicrosoftAzureSearchStopwordsTokenFilter', 'OdataTypeMicrosoftAzureSearchSynonymTokenFilter', 'OdataTypeMicrosoftAzureSearchTruncateTokenFilter', 'OdataTypeMicrosoftAzureSearchUniqueTokenFilter', 'OdataTypeMicrosoftAzureSearchWordDelimiterTokenFilter'
	OdataType OdataTypeBasicTokenFilter `json:"@odata.type,omitempty"`
	// KeepWords - The list of words to keep.
	KeepWords *[]string `json:"keepWords,omitempty"`
	// LowerCaseKeepWords - A value indicating whether to lower case all words first. Default is false.
	LowerCaseKeepWords *bool `json:"keepWordsCase,omitempty"`
}

// MarshalJSON is the custom marshaler for KeepTokenFilter.
func (ktf KeepTokenFilter) MarshalJSON() ([]byte, error) {
	ktf.OdataType = OdataTypeMicrosoftAzureSearchKeepTokenFilter
	type Alias KeepTokenFilter
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ktf),
	})
}

// AsASCIIFoldingTokenFilter is the BasicTokenFilter implementation for KeepTokenFilter.
func (ktf KeepTokenFilter) AsASCIIFoldingTokenFilter() (*ASCIIFoldingTokenFilter, bool) {
	return nil, false
}

// AsCjkBigramTokenFilter is the BasicTokenFilter implementation for KeepTokenFilter.
func (ktf KeepTokenFilter) AsCjkBigramTokenFilter() (*CjkBigramTokenFilter, bool) {
	return nil, false
}

// AsCommonGramTokenFilter is the BasicTokenFilter implementation for KeepTokenFilter.
func (ktf KeepTokenFilter) AsCommonGramTokenFilter() (*CommonGramTokenFilter, bool) {
	return nil, false
}

// AsDictionaryDecompounderTokenFilter is the BasicTokenFilter implementation for KeepTokenFilter.
func (ktf KeepTokenFilter) AsDictionaryDecompounderTokenFilter() (*DictionaryDecompounderTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilter is the BasicTokenFilter implementation for KeepTokenFilter.
func (ktf KeepTokenFilter) AsEdgeNGramTokenFilter() (*EdgeNGramTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilterV2 is the BasicTokenFilter implementation for KeepTokenFilter.
func (ktf KeepTokenFilter) AsEdgeNGramTokenFilterV2() (*EdgeNGramTokenFilterV2, bool) {
	return nil, false
}

// AsElisionTokenFilter is the BasicTokenFilter implementation for KeepTokenFilter.
func (ktf KeepTokenFilter) AsElisionTokenFilter() (*ElisionTokenFilter, bool) {
	return nil, false
}

// AsKeepTokenFilter is the BasicTokenFilter implementation for KeepTokenFilter.
func (ktf KeepTokenFilter) AsKeepTokenFilter() (*KeepTokenFilter, bool) {
	return &ktf, true
}

// AsKeywordMarkerTokenFilter is the BasicTokenFilter implementation for KeepTokenFilter.
func (ktf KeepTokenFilter) AsKeywordMarkerTokenFilter() (*KeywordMarkerTokenFilter, bool) {
	return nil, false
}

// AsLengthTokenFilter is the BasicTokenFilter implementation for KeepTokenFilter.
func (ktf KeepTokenFilter) AsLengthTokenFilter() (*LengthTokenFilter, bool) {
	return nil, false
}

// AsLimitTokenFilter is the BasicTokenFilter implementation for KeepTokenFilter.
func (ktf KeepTokenFilter) AsLimitTokenFilter() (*LimitTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilter is the BasicTokenFilter implementation for KeepTokenFilter.
func (ktf KeepTokenFilter) AsNGramTokenFilter() (*NGramTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilterV2 is the BasicTokenFilter implementation for KeepTokenFilter.
func (ktf KeepTokenFilter) AsNGramTokenFilterV2() (*NGramTokenFilterV2, bool) {
	return nil, false
}

// AsPatternCaptureTokenFilter is the BasicTokenFilter implementation for KeepTokenFilter.
func (ktf KeepTokenFilter) AsPatternCaptureTokenFilter() (*PatternCaptureTokenFilter, bool) {
	return nil, false
}

// AsPatternReplaceTokenFilter is the BasicTokenFilter implementation for KeepTokenFilter.
func (ktf KeepTokenFilter) AsPatternReplaceTokenFilter() (*PatternReplaceTokenFilter, bool) {
	return nil, false
}

// AsPhoneticTokenFilter is the BasicTokenFilter implementation for KeepTokenFilter.
func (ktf KeepTokenFilter) AsPhoneticTokenFilter() (*PhoneticTokenFilter, bool) {
	return nil, false
}

// AsShingleTokenFilter is the BasicTokenFilter implementation for KeepTokenFilter.
func (ktf KeepTokenFilter) AsShingleTokenFilter() (*ShingleTokenFilter, bool) {
	return nil, false
}

// AsSnowballTokenFilter is the BasicTokenFilter implementation for KeepTokenFilter.
func (ktf KeepTokenFilter) AsSnowballTokenFilter() (*SnowballTokenFilter, bool) {
	return nil, false
}

// AsStemmerTokenFilter is the BasicTokenFilter implementation for KeepTokenFilter.
func (ktf KeepTokenFilter) AsStemmerTokenFilter() (*StemmerTokenFilter, bool) {
	return nil, false
}

// AsStemmerOverrideTokenFilter is the BasicTokenFilter implementation for KeepTokenFilter.
func (ktf KeepTokenFilter) AsStemmerOverrideTokenFilter() (*StemmerOverrideTokenFilter, bool) {
	return nil, false
}

// AsStopwordsTokenFilter is the BasicTokenFilter implementation for KeepTokenFilter.
func (ktf KeepTokenFilter) AsStopwordsTokenFilter() (*StopwordsTokenFilter, bool) {
	return nil, false
}

// AsSynonymTokenFilter is the BasicTokenFilter implementation for KeepTokenFilter.
func (ktf KeepTokenFilter) AsSynonymTokenFilter() (*SynonymTokenFilter, bool) {
	return nil, false
}

// AsTruncateTokenFilter is the BasicTokenFilter implementation for KeepTokenFilter.
func (ktf KeepTokenFilter) AsTruncateTokenFilter() (*TruncateTokenFilter, bool) {
	return nil, false
}

// AsUniqueTokenFilter is the BasicTokenFilter implementation for KeepTokenFilter.
func (ktf KeepTokenFilter) AsUniqueTokenFilter() (*UniqueTokenFilter, bool) {
	return nil, false
}

// AsWordDelimiterTokenFilter is the BasicTokenFilter implementation for KeepTokenFilter.
func (ktf KeepTokenFilter) AsWordDelimiterTokenFilter() (*WordDelimiterTokenFilter, bool) {
	return nil, false
}

// AsTokenFilter is the BasicTokenFilter implementation for KeepTokenFilter.
func (ktf KeepTokenFilter) AsTokenFilter() (*TokenFilter, bool) {
	return nil, false
}

// AsBasicTokenFilter is the BasicTokenFilter implementation for KeepTokenFilter.
func (ktf KeepTokenFilter) AsBasicTokenFilter() (BasicTokenFilter, bool) {
	return &ktf, true
}

// KeywordMarkerTokenFilter marks terms as keywords. This token filter is implemented using Apache Lucene.
type KeywordMarkerTokenFilter struct {
	// Name - The name of the token filter. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeTokenFilter', 'OdataTypeMicrosoftAzureSearchASCIIFoldingTokenFilter', 'OdataTypeMicrosoftAzureSearchCjkBigramTokenFilter', 'OdataTypeMicrosoftAzureSearchCommonGramTokenFilter', 'OdataTypeMicrosoftAzureSearchDictionaryDecompounderTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchElisionTokenFilter', 'OdataTypeMicrosoftAzureSearchKeepTokenFilter', 'OdataTypeMicrosoftAzureSearchKeywordMarkerTokenFilter', 'OdataTypeMicrosoftAzureSearchLengthTokenFilter', 'OdataTypeMicrosoftAzureSearchLimitTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchPatternCaptureTokenFilter', 'OdataTypeMicrosoftAzureSearchPatternReplaceTokenFilter', 'OdataTypeMicrosoftAzureSearchPhoneticTokenFilter', 'OdataTypeMicrosoftAzureSearchShingleTokenFilter', 'OdataTypeMicrosoftAzureSearchSnowballTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerOverrideTokenFilter', 'OdataTypeMicrosoftAzureSearchStopwordsTokenFilter', 'OdataTypeMicrosoftAzureSearchSynonymTokenFilter', 'OdataTypeMicrosoftAzureSearchTruncateTokenFilter', 'OdataTypeMicrosoftAzureSearchUniqueTokenFilter', 'OdataTypeMicrosoftAzureSearchWordDelimiterTokenFilter'
	OdataType OdataTypeBasicTokenFilter `json:"@odata.type,omitempty"`
	// Keywords - A list of words to mark as keywords.
	Keywords *[]string `json:"keywords,omitempty"`
	// IgnoreCase - A value indicating whether to ignore case. If true, all words are converted to lower case first. Default is false.
	IgnoreCase *bool `json:"ignoreCase,omitempty"`
}

// MarshalJSON is the custom marshaler for KeywordMarkerTokenFilter.
func (kmtf KeywordMarkerTokenFilter) MarshalJSON() ([]byte, error) {
	kmtf.OdataType = OdataTypeMicrosoftAzureSearchKeywordMarkerTokenFilter
	type Alias KeywordMarkerTokenFilter
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(kmtf),
	})
}

// AsASCIIFoldingTokenFilter is the BasicTokenFilter implementation for KeywordMarkerTokenFilter.
func (kmtf KeywordMarkerTokenFilter) AsASCIIFoldingTokenFilter() (*ASCIIFoldingTokenFilter, bool) {
	return nil, false
}

// AsCjkBigramTokenFilter is the BasicTokenFilter implementation for KeywordMarkerTokenFilter.
func (kmtf KeywordMarkerTokenFilter) AsCjkBigramTokenFilter() (*CjkBigramTokenFilter, bool) {
	return nil, false
}

// AsCommonGramTokenFilter is the BasicTokenFilter implementation for KeywordMarkerTokenFilter.
func (kmtf KeywordMarkerTokenFilter) AsCommonGramTokenFilter() (*CommonGramTokenFilter, bool) {
	return nil, false
}

// AsDictionaryDecompounderTokenFilter is the BasicTokenFilter implementation for KeywordMarkerTokenFilter.
func (kmtf KeywordMarkerTokenFilter) AsDictionaryDecompounderTokenFilter() (*DictionaryDecompounderTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilter is the BasicTokenFilter implementation for KeywordMarkerTokenFilter.
func (kmtf KeywordMarkerTokenFilter) AsEdgeNGramTokenFilter() (*EdgeNGramTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilterV2 is the BasicTokenFilter implementation for KeywordMarkerTokenFilter.
func (kmtf KeywordMarkerTokenFilter) AsEdgeNGramTokenFilterV2() (*EdgeNGramTokenFilterV2, bool) {
	return nil, false
}

// AsElisionTokenFilter is the BasicTokenFilter implementation for KeywordMarkerTokenFilter.
func (kmtf KeywordMarkerTokenFilter) AsElisionTokenFilter() (*ElisionTokenFilter, bool) {
	return nil, false
}

// AsKeepTokenFilter is the BasicTokenFilter implementation for KeywordMarkerTokenFilter.
func (kmtf KeywordMarkerTokenFilter) AsKeepTokenFilter() (*KeepTokenFilter, bool) {
	return nil, false
}

// AsKeywordMarkerTokenFilter is the BasicTokenFilter implementation for KeywordMarkerTokenFilter.
func (kmtf KeywordMarkerTokenFilter) AsKeywordMarkerTokenFilter() (*KeywordMarkerTokenFilter, bool) {
	return &kmtf, true
}

// AsLengthTokenFilter is the BasicTokenFilter implementation for KeywordMarkerTokenFilter.
func (kmtf KeywordMarkerTokenFilter) AsLengthTokenFilter() (*LengthTokenFilter, bool) {
	return nil, false
}

// AsLimitTokenFilter is the BasicTokenFilter implementation for KeywordMarkerTokenFilter.
func (kmtf KeywordMarkerTokenFilter) AsLimitTokenFilter() (*LimitTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilter is the BasicTokenFilter implementation for KeywordMarkerTokenFilter.
func (kmtf KeywordMarkerTokenFilter) AsNGramTokenFilter() (*NGramTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilterV2 is the BasicTokenFilter implementation for KeywordMarkerTokenFilter.
func (kmtf KeywordMarkerTokenFilter) AsNGramTokenFilterV2() (*NGramTokenFilterV2, bool) {
	return nil, false
}

// AsPatternCaptureTokenFilter is the BasicTokenFilter implementation for KeywordMarkerTokenFilter.
func (kmtf KeywordMarkerTokenFilter) AsPatternCaptureTokenFilter() (*PatternCaptureTokenFilter, bool) {
	return nil, false
}

// AsPatternReplaceTokenFilter is the BasicTokenFilter implementation for KeywordMarkerTokenFilter.
func (kmtf KeywordMarkerTokenFilter) AsPatternReplaceTokenFilter() (*PatternReplaceTokenFilter, bool) {
	return nil, false
}

// AsPhoneticTokenFilter is the BasicTokenFilter implementation for KeywordMarkerTokenFilter.
func (kmtf KeywordMarkerTokenFilter) AsPhoneticTokenFilter() (*PhoneticTokenFilter, bool) {
	return nil, false
}

// AsShingleTokenFilter is the BasicTokenFilter implementation for KeywordMarkerTokenFilter.
func (kmtf KeywordMarkerTokenFilter) AsShingleTokenFilter() (*ShingleTokenFilter, bool) {
	return nil, false
}

// AsSnowballTokenFilter is the BasicTokenFilter implementation for KeywordMarkerTokenFilter.
func (kmtf KeywordMarkerTokenFilter) AsSnowballTokenFilter() (*SnowballTokenFilter, bool) {
	return nil, false
}

// AsStemmerTokenFilter is the BasicTokenFilter implementation for KeywordMarkerTokenFilter.
func (kmtf KeywordMarkerTokenFilter) AsStemmerTokenFilter() (*StemmerTokenFilter, bool) {
	return nil, false
}

// AsStemmerOverrideTokenFilter is the BasicTokenFilter implementation for KeywordMarkerTokenFilter.
func (kmtf KeywordMarkerTokenFilter) AsStemmerOverrideTokenFilter() (*StemmerOverrideTokenFilter, bool) {
	return nil, false
}

// AsStopwordsTokenFilter is the BasicTokenFilter implementation for KeywordMarkerTokenFilter.
func (kmtf KeywordMarkerTokenFilter) AsStopwordsTokenFilter() (*StopwordsTokenFilter, bool) {
	return nil, false
}

// AsSynonymTokenFilter is the BasicTokenFilter implementation for KeywordMarkerTokenFilter.
func (kmtf KeywordMarkerTokenFilter) AsSynonymTokenFilter() (*SynonymTokenFilter, bool) {
	return nil, false
}

// AsTruncateTokenFilter is the BasicTokenFilter implementation for KeywordMarkerTokenFilter.
func (kmtf KeywordMarkerTokenFilter) AsTruncateTokenFilter() (*TruncateTokenFilter, bool) {
	return nil, false
}

// AsUniqueTokenFilter is the BasicTokenFilter implementation for KeywordMarkerTokenFilter.
func (kmtf KeywordMarkerTokenFilter) AsUniqueTokenFilter() (*UniqueTokenFilter, bool) {
	return nil, false
}

// AsWordDelimiterTokenFilter is the BasicTokenFilter implementation for KeywordMarkerTokenFilter.
func (kmtf KeywordMarkerTokenFilter) AsWordDelimiterTokenFilter() (*WordDelimiterTokenFilter, bool) {
	return nil, false
}

// AsTokenFilter is the BasicTokenFilter implementation for KeywordMarkerTokenFilter.
func (kmtf KeywordMarkerTokenFilter) AsTokenFilter() (*TokenFilter, bool) {
	return nil, false
}

// AsBasicTokenFilter is the BasicTokenFilter implementation for KeywordMarkerTokenFilter.
func (kmtf KeywordMarkerTokenFilter) AsBasicTokenFilter() (BasicTokenFilter, bool) {
	return &kmtf, true
}

// KeywordTokenizer emits the entire input as a single token. This tokenizer is implemented using Apache Lucene.
type KeywordTokenizer struct {
	// Name - The name of the tokenizer. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeTokenizer', 'OdataTypeMicrosoftAzureSearchClassicTokenizer', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenizer', 'OdataTypeMicrosoftAzureSearchKeywordTokenizer', 'OdataTypeMicrosoftAzureSearchKeywordTokenizerV2', 'OdataTypeMicrosoftAzureSearchMicrosoftLanguageTokenizer', 'OdataTypeMicrosoftAzureSearchMicrosoftLanguageStemmingTokenizer', 'OdataTypeMicrosoftAzureSearchNGramTokenizer', 'OdataTypeMicrosoftAzureSearchPathHierarchyTokenizer', 'OdataTypeMicrosoftAzureSearchPathHierarchyTokenizerV2', 'OdataTypeMicrosoftAzureSearchPatternTokenizer', 'OdataTypeMicrosoftAzureSearchStandardTokenizer', 'OdataTypeMicrosoftAzureSearchStandardTokenizerV2', 'OdataTypeMicrosoftAzureSearchUaxURLEmailTokenizer'
	OdataType OdataTypeBasicTokenizer `json:"@odata.type,omitempty"`
	// BufferSize - The read buffer size in bytes. Default is 256.
	BufferSize *int32 `json:"bufferSize,omitempty"`
}

// MarshalJSON is the custom marshaler for KeywordTokenizer.
func (kt KeywordTokenizer) MarshalJSON() ([]byte, error) {
	kt.OdataType = OdataTypeMicrosoftAzureSearchKeywordTokenizer
	type Alias KeywordTokenizer
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(kt),
	})
}

// AsClassicTokenizer is the BasicTokenizer implementation for KeywordTokenizer.
func (kt KeywordTokenizer) AsClassicTokenizer() (*ClassicTokenizer, bool) {
	return nil, false
}

// AsEdgeNGramTokenizer is the BasicTokenizer implementation for KeywordTokenizer.
func (kt KeywordTokenizer) AsEdgeNGramTokenizer() (*EdgeNGramTokenizer, bool) {
	return nil, false
}

// AsKeywordTokenizer is the BasicTokenizer implementation for KeywordTokenizer.
func (kt KeywordTokenizer) AsKeywordTokenizer() (*KeywordTokenizer, bool) {
	return &kt, true
}

// AsKeywordTokenizerV2 is the BasicTokenizer implementation for KeywordTokenizer.
func (kt KeywordTokenizer) AsKeywordTokenizerV2() (*KeywordTokenizerV2, bool) {
	return nil, false
}

// AsMicrosoftLanguageTokenizer is the BasicTokenizer implementation for KeywordTokenizer.
func (kt KeywordTokenizer) AsMicrosoftLanguageTokenizer() (*MicrosoftLanguageTokenizer, bool) {
	return nil, false
}

// AsMicrosoftLanguageStemmingTokenizer is the BasicTokenizer implementation for KeywordTokenizer.
func (kt KeywordTokenizer) AsMicrosoftLanguageStemmingTokenizer() (*MicrosoftLanguageStemmingTokenizer, bool) {
	return nil, false
}

// AsNGramTokenizer is the BasicTokenizer implementation for KeywordTokenizer.
func (kt KeywordTokenizer) AsNGramTokenizer() (*NGramTokenizer, bool) {
	return nil, false
}

// AsPathHierarchyTokenizer is the BasicTokenizer implementation for KeywordTokenizer.
func (kt KeywordTokenizer) AsPathHierarchyTokenizer() (*PathHierarchyTokenizer, bool) {
	return nil, false
}

// AsPathHierarchyTokenizerV2 is the BasicTokenizer implementation for KeywordTokenizer.
func (kt KeywordTokenizer) AsPathHierarchyTokenizerV2() (*PathHierarchyTokenizerV2, bool) {
	return nil, false
}

// AsPatternTokenizer is the BasicTokenizer implementation for KeywordTokenizer.
func (kt KeywordTokenizer) AsPatternTokenizer() (*PatternTokenizer, bool) {
	return nil, false
}

// AsStandardTokenizer is the BasicTokenizer implementation for KeywordTokenizer.
func (kt KeywordTokenizer) AsStandardTokenizer() (*StandardTokenizer, bool) {
	return nil, false
}

// AsStandardTokenizerV2 is the BasicTokenizer implementation for KeywordTokenizer.
func (kt KeywordTokenizer) AsStandardTokenizerV2() (*StandardTokenizerV2, bool) {
	return nil, false
}

// AsUaxURLEmailTokenizer is the BasicTokenizer implementation for KeywordTokenizer.
func (kt KeywordTokenizer) AsUaxURLEmailTokenizer() (*UaxURLEmailTokenizer, bool) {
	return nil, false
}

// AsTokenizer is the BasicTokenizer implementation for KeywordTokenizer.
func (kt KeywordTokenizer) AsTokenizer() (*Tokenizer, bool) {
	return nil, false
}

// AsBasicTokenizer is the BasicTokenizer implementation for KeywordTokenizer.
func (kt KeywordTokenizer) AsBasicTokenizer() (BasicTokenizer, bool) {
	return &kt, true
}

// KeywordTokenizerV2 emits the entire input as a single token.
type KeywordTokenizerV2 struct {
	// Name - The name of the tokenizer. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeTokenizer', 'OdataTypeMicrosoftAzureSearchClassicTokenizer', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenizer', 'OdataTypeMicrosoftAzureSearchKeywordTokenizer', 'OdataTypeMicrosoftAzureSearchKeywordTokenizerV2', 'OdataTypeMicrosoftAzureSearchMicrosoftLanguageTokenizer', 'OdataTypeMicrosoftAzureSearchMicrosoftLanguageStemmingTokenizer', 'OdataTypeMicrosoftAzureSearchNGramTokenizer', 'OdataTypeMicrosoftAzureSearchPathHierarchyTokenizer', 'OdataTypeMicrosoftAzureSearchPathHierarchyTokenizerV2', 'OdataTypeMicrosoftAzureSearchPatternTokenizer', 'OdataTypeMicrosoftAzureSearchStandardTokenizer', 'OdataTypeMicrosoftAzureSearchStandardTokenizerV2', 'OdataTypeMicrosoftAzureSearchUaxURLEmailTokenizer'
	OdataType OdataTypeBasicTokenizer `json:"@odata.type,omitempty"`
	// MaxTokenLength - The maximum token length. Default is 256. Tokens longer than the maximum length are split. The maximum token length that can be used is 300 characters.
	MaxTokenLength *int32 `json:"maxTokenLength,omitempty"`
}

// MarshalJSON is the custom marshaler for KeywordTokenizerV2.
func (ktv KeywordTokenizerV2) MarshalJSON() ([]byte, error) {
	ktv.OdataType = OdataTypeMicrosoftAzureSearchKeywordTokenizerV2
	type Alias KeywordTokenizerV2
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ktv),
	})
}

// AsClassicTokenizer is the BasicTokenizer implementation for KeywordTokenizerV2.
func (ktv KeywordTokenizerV2) AsClassicTokenizer() (*ClassicTokenizer, bool) {
	return nil, false
}

// AsEdgeNGramTokenizer is the BasicTokenizer implementation for KeywordTokenizerV2.
func (ktv KeywordTokenizerV2) AsEdgeNGramTokenizer() (*EdgeNGramTokenizer, bool) {
	return nil, false
}

// AsKeywordTokenizer is the BasicTokenizer implementation for KeywordTokenizerV2.
func (ktv KeywordTokenizerV2) AsKeywordTokenizer() (*KeywordTokenizer, bool) {
	return nil, false
}

// AsKeywordTokenizerV2 is the BasicTokenizer implementation for KeywordTokenizerV2.
func (ktv KeywordTokenizerV2) AsKeywordTokenizerV2() (*KeywordTokenizerV2, bool) {
	return &ktv, true
}

// AsMicrosoftLanguageTokenizer is the BasicTokenizer implementation for KeywordTokenizerV2.
func (ktv KeywordTokenizerV2) AsMicrosoftLanguageTokenizer() (*MicrosoftLanguageTokenizer, bool) {
	return nil, false
}

// AsMicrosoftLanguageStemmingTokenizer is the BasicTokenizer implementation for KeywordTokenizerV2.
func (ktv KeywordTokenizerV2) AsMicrosoftLanguageStemmingTokenizer() (*MicrosoftLanguageStemmingTokenizer, bool) {
	return nil, false
}

// AsNGramTokenizer is the BasicTokenizer implementation for KeywordTokenizerV2.
func (ktv KeywordTokenizerV2) AsNGramTokenizer() (*NGramTokenizer, bool) {
	return nil, false
}

// AsPathHierarchyTokenizer is the BasicTokenizer implementation for KeywordTokenizerV2.
func (ktv KeywordTokenizerV2) AsPathHierarchyTokenizer() (*PathHierarchyTokenizer, bool) {
	return nil, false
}

// AsPathHierarchyTokenizerV2 is the BasicTokenizer implementation for KeywordTokenizerV2.
func (ktv KeywordTokenizerV2) AsPathHierarchyTokenizerV2() (*PathHierarchyTokenizerV2, bool) {
	return nil, false
}

// AsPatternTokenizer is the BasicTokenizer implementation for KeywordTokenizerV2.
func (ktv KeywordTokenizerV2) AsPatternTokenizer() (*PatternTokenizer, bool) {
	return nil, false
}

// AsStandardTokenizer is the BasicTokenizer implementation for KeywordTokenizerV2.
func (ktv KeywordTokenizerV2) AsStandardTokenizer() (*StandardTokenizer, bool) {
	return nil, false
}

// AsStandardTokenizerV2 is the BasicTokenizer implementation for KeywordTokenizerV2.
func (ktv KeywordTokenizerV2) AsStandardTokenizerV2() (*StandardTokenizerV2, bool) {
	return nil, false
}

// AsUaxURLEmailTokenizer is the BasicTokenizer implementation for KeywordTokenizerV2.
func (ktv KeywordTokenizerV2) AsUaxURLEmailTokenizer() (*UaxURLEmailTokenizer, bool) {
	return nil, false
}

// AsTokenizer is the BasicTokenizer implementation for KeywordTokenizerV2.
func (ktv KeywordTokenizerV2) AsTokenizer() (*Tokenizer, bool) {
	return nil, false
}

// AsBasicTokenizer is the BasicTokenizer implementation for KeywordTokenizerV2.
func (ktv KeywordTokenizerV2) AsBasicTokenizer() (BasicTokenizer, bool) {
	return &ktv, true
}

// LengthTokenFilter removes words that are too long or too short. This token filter is implemented using Apache
// Lucene.
type LengthTokenFilter struct {
	// Name - The name of the token filter. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeTokenFilter', 'OdataTypeMicrosoftAzureSearchASCIIFoldingTokenFilter', 'OdataTypeMicrosoftAzureSearchCjkBigramTokenFilter', 'OdataTypeMicrosoftAzureSearchCommonGramTokenFilter', 'OdataTypeMicrosoftAzureSearchDictionaryDecompounderTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchElisionTokenFilter', 'OdataTypeMicrosoftAzureSearchKeepTokenFilter', 'OdataTypeMicrosoftAzureSearchKeywordMarkerTokenFilter', 'OdataTypeMicrosoftAzureSearchLengthTokenFilter', 'OdataTypeMicrosoftAzureSearchLimitTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchPatternCaptureTokenFilter', 'OdataTypeMicrosoftAzureSearchPatternReplaceTokenFilter', 'OdataTypeMicrosoftAzureSearchPhoneticTokenFilter', 'OdataTypeMicrosoftAzureSearchShingleTokenFilter', 'OdataTypeMicrosoftAzureSearchSnowballTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerOverrideTokenFilter', 'OdataTypeMicrosoftAzureSearchStopwordsTokenFilter', 'OdataTypeMicrosoftAzureSearchSynonymTokenFilter', 'OdataTypeMicrosoftAzureSearchTruncateTokenFilter', 'OdataTypeMicrosoftAzureSearchUniqueTokenFilter', 'OdataTypeMicrosoftAzureSearchWordDelimiterTokenFilter'
	OdataType OdataTypeBasicTokenFilter `json:"@odata.type,omitempty"`
	// Min - The minimum length in characters. Default is 0. Maximum is 300. Must be less than the value of max.
	Min *int32 `json:"min,omitempty"`
	// Max - The maximum length in characters. Default and maximum is 300.
	Max *int32 `json:"max,omitempty"`
}

// MarshalJSON is the custom marshaler for LengthTokenFilter.
func (ltf LengthTokenFilter) MarshalJSON() ([]byte, error) {
	ltf.OdataType = OdataTypeMicrosoftAzureSearchLengthTokenFilter
	type Alias LengthTokenFilter
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ltf),
	})
}

// AsASCIIFoldingTokenFilter is the BasicTokenFilter implementation for LengthTokenFilter.
func (ltf LengthTokenFilter) AsASCIIFoldingTokenFilter() (*ASCIIFoldingTokenFilter, bool) {
	return nil, false
}

// AsCjkBigramTokenFilter is the BasicTokenFilter implementation for LengthTokenFilter.
func (ltf LengthTokenFilter) AsCjkBigramTokenFilter() (*CjkBigramTokenFilter, bool) {
	return nil, false
}

// AsCommonGramTokenFilter is the BasicTokenFilter implementation for LengthTokenFilter.
func (ltf LengthTokenFilter) AsCommonGramTokenFilter() (*CommonGramTokenFilter, bool) {
	return nil, false
}

// AsDictionaryDecompounderTokenFilter is the BasicTokenFilter implementation for LengthTokenFilter.
func (ltf LengthTokenFilter) AsDictionaryDecompounderTokenFilter() (*DictionaryDecompounderTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilter is the BasicTokenFilter implementation for LengthTokenFilter.
func (ltf LengthTokenFilter) AsEdgeNGramTokenFilter() (*EdgeNGramTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilterV2 is the BasicTokenFilter implementation for LengthTokenFilter.
func (ltf LengthTokenFilter) AsEdgeNGramTokenFilterV2() (*EdgeNGramTokenFilterV2, bool) {
	return nil, false
}

// AsElisionTokenFilter is the BasicTokenFilter implementation for LengthTokenFilter.
func (ltf LengthTokenFilter) AsElisionTokenFilter() (*ElisionTokenFilter, bool) {
	return nil, false
}

// AsKeepTokenFilter is the BasicTokenFilter implementation for LengthTokenFilter.
func (ltf LengthTokenFilter) AsKeepTokenFilter() (*KeepTokenFilter, bool) {
	return nil, false
}

// AsKeywordMarkerTokenFilter is the BasicTokenFilter implementation for LengthTokenFilter.
func (ltf LengthTokenFilter) AsKeywordMarkerTokenFilter() (*KeywordMarkerTokenFilter, bool) {
	return nil, false
}

// AsLengthTokenFilter is the BasicTokenFilter implementation for LengthTokenFilter.
func (ltf LengthTokenFilter) AsLengthTokenFilter() (*LengthTokenFilter, bool) {
	return &ltf, true
}

// AsLimitTokenFilter is the BasicTokenFilter implementation for LengthTokenFilter.
func (ltf LengthTokenFilter) AsLimitTokenFilter() (*LimitTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilter is the BasicTokenFilter implementation for LengthTokenFilter.
func (ltf LengthTokenFilter) AsNGramTokenFilter() (*NGramTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilterV2 is the BasicTokenFilter implementation for LengthTokenFilter.
func (ltf LengthTokenFilter) AsNGramTokenFilterV2() (*NGramTokenFilterV2, bool) {
	return nil, false
}

// AsPatternCaptureTokenFilter is the BasicTokenFilter implementation for LengthTokenFilter.
func (ltf LengthTokenFilter) AsPatternCaptureTokenFilter() (*PatternCaptureTokenFilter, bool) {
	return nil, false
}

// AsPatternReplaceTokenFilter is the BasicTokenFilter implementation for LengthTokenFilter.
func (ltf LengthTokenFilter) AsPatternReplaceTokenFilter() (*PatternReplaceTokenFilter, bool) {
	return nil, false
}

// AsPhoneticTokenFilter is the BasicTokenFilter implementation for LengthTokenFilter.
func (ltf LengthTokenFilter) AsPhoneticTokenFilter() (*PhoneticTokenFilter, bool) {
	return nil, false
}

// AsShingleTokenFilter is the BasicTokenFilter implementation for LengthTokenFilter.
func (ltf LengthTokenFilter) AsShingleTokenFilter() (*ShingleTokenFilter, bool) {
	return nil, false
}

// AsSnowballTokenFilter is the BasicTokenFilter implementation for LengthTokenFilter.
func (ltf LengthTokenFilter) AsSnowballTokenFilter() (*SnowballTokenFilter, bool) {
	return nil, false
}

// AsStemmerTokenFilter is the BasicTokenFilter implementation for LengthTokenFilter.
func (ltf LengthTokenFilter) AsStemmerTokenFilter() (*StemmerTokenFilter, bool) {
	return nil, false
}

// AsStemmerOverrideTokenFilter is the BasicTokenFilter implementation for LengthTokenFilter.
func (ltf LengthTokenFilter) AsStemmerOverrideTokenFilter() (*StemmerOverrideTokenFilter, bool) {
	return nil, false
}

// AsStopwordsTokenFilter is the BasicTokenFilter implementation for LengthTokenFilter.
func (ltf LengthTokenFilter) AsStopwordsTokenFilter() (*StopwordsTokenFilter, bool) {
	return nil, false
}

// AsSynonymTokenFilter is the BasicTokenFilter implementation for LengthTokenFilter.
func (ltf LengthTokenFilter) AsSynonymTokenFilter() (*SynonymTokenFilter, bool) {
	return nil, false
}

// AsTruncateTokenFilter is the BasicTokenFilter implementation for LengthTokenFilter.
func (ltf LengthTokenFilter) AsTruncateTokenFilter() (*TruncateTokenFilter, bool) {
	return nil, false
}

// AsUniqueTokenFilter is the BasicTokenFilter implementation for LengthTokenFilter.
func (ltf LengthTokenFilter) AsUniqueTokenFilter() (*UniqueTokenFilter, bool) {
	return nil, false
}

// AsWordDelimiterTokenFilter is the BasicTokenFilter implementation for LengthTokenFilter.
func (ltf LengthTokenFilter) AsWordDelimiterTokenFilter() (*WordDelimiterTokenFilter, bool) {
	return nil, false
}

// AsTokenFilter is the BasicTokenFilter implementation for LengthTokenFilter.
func (ltf LengthTokenFilter) AsTokenFilter() (*TokenFilter, bool) {
	return nil, false
}

// AsBasicTokenFilter is the BasicTokenFilter implementation for LengthTokenFilter.
func (ltf LengthTokenFilter) AsBasicTokenFilter() (BasicTokenFilter, bool) {
	return &ltf, true
}

// LimitTokenFilter limits the number of tokens while indexing. This token filter is implemented using Apache Lucene.
type LimitTokenFilter struct {
	// Name - The name of the token filter. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeTokenFilter', 'OdataTypeMicrosoftAzureSearchASCIIFoldingTokenFilter', 'OdataTypeMicrosoftAzureSearchCjkBigramTokenFilter', 'OdataTypeMicrosoftAzureSearchCommonGramTokenFilter', 'OdataTypeMicrosoftAzureSearchDictionaryDecompounderTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchElisionTokenFilter', 'OdataTypeMicrosoftAzureSearchKeepTokenFilter', 'OdataTypeMicrosoftAzureSearchKeywordMarkerTokenFilter', 'OdataTypeMicrosoftAzureSearchLengthTokenFilter', 'OdataTypeMicrosoftAzureSearchLimitTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchPatternCaptureTokenFilter', 'OdataTypeMicrosoftAzureSearchPatternReplaceTokenFilter', 'OdataTypeMicrosoftAzureSearchPhoneticTokenFilter', 'OdataTypeMicrosoftAzureSearchShingleTokenFilter', 'OdataTypeMicrosoftAzureSearchSnowballTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerOverrideTokenFilter', 'OdataTypeMicrosoftAzureSearchStopwordsTokenFilter', 'OdataTypeMicrosoftAzureSearchSynonymTokenFilter', 'OdataTypeMicrosoftAzureSearchTruncateTokenFilter', 'OdataTypeMicrosoftAzureSearchUniqueTokenFilter', 'OdataTypeMicrosoftAzureSearchWordDelimiterTokenFilter'
	OdataType OdataTypeBasicTokenFilter `json:"@odata.type,omitempty"`
	// MaxTokenCount - The maximum number of tokens to produce. Default is 1.
	MaxTokenCount *int32 `json:"maxTokenCount,omitempty"`
	// ConsumeAllTokens - A value indicating whether all tokens from the input must be consumed even if maxTokenCount is reached. Default is false.
	ConsumeAllTokens *bool `json:"consumeAllTokens,omitempty"`
}

// MarshalJSON is the custom marshaler for LimitTokenFilter.
func (ltf LimitTokenFilter) MarshalJSON() ([]byte, error) {
	ltf.OdataType = OdataTypeMicrosoftAzureSearchLimitTokenFilter
	type Alias LimitTokenFilter
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ltf),
	})
}

// AsASCIIFoldingTokenFilter is the BasicTokenFilter implementation for LimitTokenFilter.
func (ltf LimitTokenFilter) AsASCIIFoldingTokenFilter() (*ASCIIFoldingTokenFilter, bool) {
	return nil, false
}

// AsCjkBigramTokenFilter is the BasicTokenFilter implementation for LimitTokenFilter.
func (ltf LimitTokenFilter) AsCjkBigramTokenFilter() (*CjkBigramTokenFilter, bool) {
	return nil, false
}

// AsCommonGramTokenFilter is the BasicTokenFilter implementation for LimitTokenFilter.
func (ltf LimitTokenFilter) AsCommonGramTokenFilter() (*CommonGramTokenFilter, bool) {
	return nil, false
}

// AsDictionaryDecompounderTokenFilter is the BasicTokenFilter implementation for LimitTokenFilter.
func (ltf LimitTokenFilter) AsDictionaryDecompounderTokenFilter() (*DictionaryDecompounderTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilter is the BasicTokenFilter implementation for LimitTokenFilter.
func (ltf LimitTokenFilter) AsEdgeNGramTokenFilter() (*EdgeNGramTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilterV2 is the BasicTokenFilter implementation for LimitTokenFilter.
func (ltf LimitTokenFilter) AsEdgeNGramTokenFilterV2() (*EdgeNGramTokenFilterV2, bool) {
	return nil, false
}

// AsElisionTokenFilter is the BasicTokenFilter implementation for LimitTokenFilter.
func (ltf LimitTokenFilter) AsElisionTokenFilter() (*ElisionTokenFilter, bool) {
	return nil, false
}

// AsKeepTokenFilter is the BasicTokenFilter implementation for LimitTokenFilter.
func (ltf LimitTokenFilter) AsKeepTokenFilter() (*KeepTokenFilter, bool) {
	return nil, false
}

// AsKeywordMarkerTokenFilter is the BasicTokenFilter implementation for LimitTokenFilter.
func (ltf LimitTokenFilter) AsKeywordMarkerTokenFilter() (*KeywordMarkerTokenFilter, bool) {
	return nil, false
}

// AsLengthTokenFilter is the BasicTokenFilter implementation for LimitTokenFilter.
func (ltf LimitTokenFilter) AsLengthTokenFilter() (*LengthTokenFilter, bool) {
	return nil, false
}

// AsLimitTokenFilter is the BasicTokenFilter implementation for LimitTokenFilter.
func (ltf LimitTokenFilter) AsLimitTokenFilter() (*LimitTokenFilter, bool) {
	return &ltf, true
}

// AsNGramTokenFilter is the BasicTokenFilter implementation for LimitTokenFilter.
func (ltf LimitTokenFilter) AsNGramTokenFilter() (*NGramTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilterV2 is the BasicTokenFilter implementation for LimitTokenFilter.
func (ltf LimitTokenFilter) AsNGramTokenFilterV2() (*NGramTokenFilterV2, bool) {
	return nil, false
}

// AsPatternCaptureTokenFilter is the BasicTokenFilter implementation for LimitTokenFilter.
func (ltf LimitTokenFilter) AsPatternCaptureTokenFilter() (*PatternCaptureTokenFilter, bool) {
	return nil, false
}

// AsPatternReplaceTokenFilter is the BasicTokenFilter implementation for LimitTokenFilter.
func (ltf LimitTokenFilter) AsPatternReplaceTokenFilter() (*PatternReplaceTokenFilter, bool) {
	return nil, false
}

// AsPhoneticTokenFilter is the BasicTokenFilter implementation for LimitTokenFilter.
func (ltf LimitTokenFilter) AsPhoneticTokenFilter() (*PhoneticTokenFilter, bool) {
	return nil, false
}

// AsShingleTokenFilter is the BasicTokenFilter implementation for LimitTokenFilter.
func (ltf LimitTokenFilter) AsShingleTokenFilter() (*ShingleTokenFilter, bool) {
	return nil, false
}

// AsSnowballTokenFilter is the BasicTokenFilter implementation for LimitTokenFilter.
func (ltf LimitTokenFilter) AsSnowballTokenFilter() (*SnowballTokenFilter, bool) {
	return nil, false
}

// AsStemmerTokenFilter is the BasicTokenFilter implementation for LimitTokenFilter.
func (ltf LimitTokenFilter) AsStemmerTokenFilter() (*StemmerTokenFilter, bool) {
	return nil, false
}

// AsStemmerOverrideTokenFilter is the BasicTokenFilter implementation for LimitTokenFilter.
func (ltf LimitTokenFilter) AsStemmerOverrideTokenFilter() (*StemmerOverrideTokenFilter, bool) {
	return nil, false
}

// AsStopwordsTokenFilter is the BasicTokenFilter implementation for LimitTokenFilter.
func (ltf LimitTokenFilter) AsStopwordsTokenFilter() (*StopwordsTokenFilter, bool) {
	return nil, false
}

// AsSynonymTokenFilter is the BasicTokenFilter implementation for LimitTokenFilter.
func (ltf LimitTokenFilter) AsSynonymTokenFilter() (*SynonymTokenFilter, bool) {
	return nil, false
}

// AsTruncateTokenFilter is the BasicTokenFilter implementation for LimitTokenFilter.
func (ltf LimitTokenFilter) AsTruncateTokenFilter() (*TruncateTokenFilter, bool) {
	return nil, false
}

// AsUniqueTokenFilter is the BasicTokenFilter implementation for LimitTokenFilter.
func (ltf LimitTokenFilter) AsUniqueTokenFilter() (*UniqueTokenFilter, bool) {
	return nil, false
}

// AsWordDelimiterTokenFilter is the BasicTokenFilter implementation for LimitTokenFilter.
func (ltf LimitTokenFilter) AsWordDelimiterTokenFilter() (*WordDelimiterTokenFilter, bool) {
	return nil, false
}

// AsTokenFilter is the BasicTokenFilter implementation for LimitTokenFilter.
func (ltf LimitTokenFilter) AsTokenFilter() (*TokenFilter, bool) {
	return nil, false
}

// AsBasicTokenFilter is the BasicTokenFilter implementation for LimitTokenFilter.
func (ltf LimitTokenFilter) AsBasicTokenFilter() (BasicTokenFilter, bool) {
	return &ltf, true
}

// MagnitudeScoringFunction defines a function that boosts scores based on the magnitude of a numeric field.
type MagnitudeScoringFunction struct {
	// FieldName - The name of the field used as input to the scoring function.
	FieldName *string `json:"fieldName,omitempty"`
	// Boost - A multiplier for the raw score. Must be a positive number not equal to 1.0.
	Boost *float64 `json:"boost,omitempty"`
	// Interpolation - A value indicating how boosting will be interpolated across document scores; defaults to "Linear". Possible values include: 'Linear', 'Constant', 'Quadratic', 'Logarithmic'
	Interpolation ScoringFunctionInterpolation `json:"interpolation,omitempty"`
	// Type - Possible values include: 'TypeScoringFunction', 'TypeDistance', 'TypeFreshness', 'TypeMagnitude', 'TypeTag'
	Type Type `json:"type,omitempty"`
	// Parameters - Parameter values for the magnitude scoring function.
	Parameters *MagnitudeScoringParameters `json:"magnitude,omitempty"`
}

// MarshalJSON is the custom marshaler for MagnitudeScoringFunction.
func (msf MagnitudeScoringFunction) MarshalJSON() ([]byte, error) {
	msf.Type = TypeMagnitude
	type Alias MagnitudeScoringFunction
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(msf),
	})
}

// AsDistanceScoringFunction is the BasicScoringFunction implementation for MagnitudeScoringFunction.
func (msf MagnitudeScoringFunction) AsDistanceScoringFunction() (*DistanceScoringFunction, bool) {
	return nil, false
}

// AsFreshnessScoringFunction is the BasicScoringFunction implementation for MagnitudeScoringFunction.
func (msf MagnitudeScoringFunction) AsFreshnessScoringFunction() (*FreshnessScoringFunction, bool) {
	return nil, false
}

// AsMagnitudeScoringFunction is the BasicScoringFunction implementation for MagnitudeScoringFunction.
func (msf MagnitudeScoringFunction) AsMagnitudeScoringFunction() (*MagnitudeScoringFunction, bool) {
	return &msf, true
}

// AsTagScoringFunction is the BasicScoringFunction implementation for MagnitudeScoringFunction.
func (msf MagnitudeScoringFunction) AsTagScoringFunction() (*TagScoringFunction, bool) {
	return nil, false
}

// AsScoringFunction is the BasicScoringFunction implementation for MagnitudeScoringFunction.
func (msf MagnitudeScoringFunction) AsScoringFunction() (*ScoringFunction, bool) {
	return nil, false
}

// AsBasicScoringFunction is the BasicScoringFunction implementation for MagnitudeScoringFunction.
func (msf MagnitudeScoringFunction) AsBasicScoringFunction() (BasicScoringFunction, bool) {
	return &msf, true
}

// MagnitudeScoringParameters provides parameter values to a magnitude scoring function.
type MagnitudeScoringParameters struct {
	// BoostingRangeStart - The field value at which boosting starts.
	BoostingRangeStart *float64 `json:"boostingRangeStart,omitempty"`
	// BoostingRangeEnd - The field value at which boosting ends.
	BoostingRangeEnd *float64 `json:"boostingRangeEnd,omitempty"`
	// ShouldBoostBeyondRangeByConstant - A value indicating whether to apply a constant boost for field values beyond the range end value; default is false.
	ShouldBoostBeyondRangeByConstant *bool `json:"constantBoostBeyondRange,omitempty"`
}

// MappingCharFilter a character filter that applies mappings defined with the mappings option. Matching is greedy
// (longest pattern matching at a given point wins). Replacement is allowed to be the empty string. This character
// filter is implemented using Apache Lucene.
type MappingCharFilter struct {
	// Name - The name of the char filter. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeCharFilter', 'OdataTypeMicrosoftAzureSearchMappingCharFilter', 'OdataTypeMicrosoftAzureSearchPatternReplaceCharFilter'
	OdataType OdataTypeBasicCharFilter `json:"@odata.type,omitempty"`
	// Mappings - A list of mappings of the following format: "a=>b" (all occurrences of the character "a" will be replaced with character "b").
	Mappings *[]string `json:"mappings,omitempty"`
}

// MarshalJSON is the custom marshaler for MappingCharFilter.
func (mcf MappingCharFilter) MarshalJSON() ([]byte, error) {
	mcf.OdataType = OdataTypeMicrosoftAzureSearchMappingCharFilter
	type Alias MappingCharFilter
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(mcf),
	})
}

// AsMappingCharFilter is the BasicCharFilter implementation for MappingCharFilter.
func (mcf MappingCharFilter) AsMappingCharFilter() (*MappingCharFilter, bool) {
	return &mcf, true
}

// AsPatternReplaceCharFilter is the BasicCharFilter implementation for MappingCharFilter.
func (mcf MappingCharFilter) AsPatternReplaceCharFilter() (*PatternReplaceCharFilter, bool) {
	return nil, false
}

// AsCharFilter is the BasicCharFilter implementation for MappingCharFilter.
func (mcf MappingCharFilter) AsCharFilter() (*CharFilter, bool) {
	return nil, false
}

// AsBasicCharFilter is the BasicCharFilter implementation for MappingCharFilter.
func (mcf MappingCharFilter) AsBasicCharFilter() (BasicCharFilter, bool) {
	return &mcf, true
}

// MicrosoftLanguageStemmingTokenizer divides text using language-specific rules and reduces words to their base forms.
type MicrosoftLanguageStemmingTokenizer struct {
	// Name - The name of the tokenizer. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeTokenizer', 'OdataTypeMicrosoftAzureSearchClassicTokenizer', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenizer', 'OdataTypeMicrosoftAzureSearchKeywordTokenizer', 'OdataTypeMicrosoftAzureSearchKeywordTokenizerV2', 'OdataTypeMicrosoftAzureSearchMicrosoftLanguageTokenizer', 'OdataTypeMicrosoftAzureSearchMicrosoftLanguageStemmingTokenizer', 'OdataTypeMicrosoftAzureSearchNGramTokenizer', 'OdataTypeMicrosoftAzureSearchPathHierarchyTokenizer', 'OdataTypeMicrosoftAzureSearchPathHierarchyTokenizerV2', 'OdataTypeMicrosoftAzureSearchPatternTokenizer', 'OdataTypeMicrosoftAzureSearchStandardTokenizer', 'OdataTypeMicrosoftAzureSearchStandardTokenizerV2', 'OdataTypeMicrosoftAzureSearchUaxURLEmailTokenizer'
	OdataType OdataTypeBasicTokenizer `json:"@odata.type,omitempty"`
	// MaxTokenLength - The maximum token length. Tokens longer than the maximum length are split. Maximum token length that can be used is 300 characters. Tokens longer than 300 characters are first split into tokens of length 300 and then each of those tokens is split based on the max token length set. Default is 255.
	MaxTokenLength *int32 `json:"maxTokenLength,omitempty"`
	// IsSearchTokenizer - A value indicating how the tokenizer is used. Set to true if used as the search tokenizer, set to false if used as the indexing tokenizer. Default is false.
	IsSearchTokenizer *bool `json:"isSearchTokenizer,omitempty"`
	// Language - The language to use. The default is English. Possible values include: 'Arabic', 'Bangla', 'Bulgarian', 'Catalan', 'Croatian', 'Czech', 'Danish', 'Dutch', 'English', 'Estonian', 'Finnish', 'French', 'German', 'Greek', 'Gujarati', 'Hebrew', 'Hindi', 'Hungarian', 'Icelandic', 'Indonesian', 'Italian', 'Kannada', 'Latvian', 'Lithuanian', 'Malay', 'Malayalam', 'Marathi', 'NorwegianBokmaal', 'Polish', 'Portuguese', 'PortugueseBrazilian', 'Punjabi', 'Romanian', 'Russian', 'SerbianCyrillic', 'SerbianLatin', 'Slovak', 'Slovenian', 'Spanish', 'Swedish', 'Tamil', 'Telugu', 'Turkish', 'Ukrainian', 'Urdu'
	Language MicrosoftStemmingTokenizerLanguage `json:"language,omitempty"`
}

// MarshalJSON is the custom marshaler for MicrosoftLanguageStemmingTokenizer.
func (mlst MicrosoftLanguageStemmingTokenizer) MarshalJSON() ([]byte, error) {
	mlst.OdataType = OdataTypeMicrosoftAzureSearchMicrosoftLanguageStemmingTokenizer
	type Alias MicrosoftLanguageStemmingTokenizer
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(mlst),
	})
}

// AsClassicTokenizer is the BasicTokenizer implementation for MicrosoftLanguageStemmingTokenizer.
func (mlst MicrosoftLanguageStemmingTokenizer) AsClassicTokenizer() (*ClassicTokenizer, bool) {
	return nil, false
}

// AsEdgeNGramTokenizer is the BasicTokenizer implementation for MicrosoftLanguageStemmingTokenizer.
func (mlst MicrosoftLanguageStemmingTokenizer) AsEdgeNGramTokenizer() (*EdgeNGramTokenizer, bool) {
	return nil, false
}

// AsKeywordTokenizer is the BasicTokenizer implementation for MicrosoftLanguageStemmingTokenizer.
func (mlst MicrosoftLanguageStemmingTokenizer) AsKeywordTokenizer() (*KeywordTokenizer, bool) {
	return nil, false
}

// AsKeywordTokenizerV2 is the BasicTokenizer implementation for MicrosoftLanguageStemmingTokenizer.
func (mlst MicrosoftLanguageStemmingTokenizer) AsKeywordTokenizerV2() (*KeywordTokenizerV2, bool) {
	return nil, false
}

// AsMicrosoftLanguageTokenizer is the BasicTokenizer implementation for MicrosoftLanguageStemmingTokenizer.
func (mlst MicrosoftLanguageStemmingTokenizer) AsMicrosoftLanguageTokenizer() (*MicrosoftLanguageTokenizer, bool) {
	return nil, false
}

// AsMicrosoftLanguageStemmingTokenizer is the BasicTokenizer implementation for MicrosoftLanguageStemmingTokenizer.
func (mlst MicrosoftLanguageStemmingTokenizer) AsMicrosoftLanguageStemmingTokenizer() (*MicrosoftLanguageStemmingTokenizer, bool) {
	return &mlst, true
}

// AsNGramTokenizer is the BasicTokenizer implementation for MicrosoftLanguageStemmingTokenizer.
func (mlst MicrosoftLanguageStemmingTokenizer) AsNGramTokenizer() (*NGramTokenizer, bool) {
	return nil, false
}

// AsPathHierarchyTokenizer is the BasicTokenizer implementation for MicrosoftLanguageStemmingTokenizer.
func (mlst MicrosoftLanguageStemmingTokenizer) AsPathHierarchyTokenizer() (*PathHierarchyTokenizer, bool) {
	return nil, false
}

// AsPathHierarchyTokenizerV2 is the BasicTokenizer implementation for MicrosoftLanguageStemmingTokenizer.
func (mlst MicrosoftLanguageStemmingTokenizer) AsPathHierarchyTokenizerV2() (*PathHierarchyTokenizerV2, bool) {
	return nil, false
}

// AsPatternTokenizer is the BasicTokenizer implementation for MicrosoftLanguageStemmingTokenizer.
func (mlst MicrosoftLanguageStemmingTokenizer) AsPatternTokenizer() (*PatternTokenizer, bool) {
	return nil, false
}

// AsStandardTokenizer is the BasicTokenizer implementation for MicrosoftLanguageStemmingTokenizer.
func (mlst MicrosoftLanguageStemmingTokenizer) AsStandardTokenizer() (*StandardTokenizer, bool) {
	return nil, false
}

// AsStandardTokenizerV2 is the BasicTokenizer implementation for MicrosoftLanguageStemmingTokenizer.
func (mlst MicrosoftLanguageStemmingTokenizer) AsStandardTokenizerV2() (*StandardTokenizerV2, bool) {
	return nil, false
}

// AsUaxURLEmailTokenizer is the BasicTokenizer implementation for MicrosoftLanguageStemmingTokenizer.
func (mlst MicrosoftLanguageStemmingTokenizer) AsUaxURLEmailTokenizer() (*UaxURLEmailTokenizer, bool) {
	return nil, false
}

// AsTokenizer is the BasicTokenizer implementation for MicrosoftLanguageStemmingTokenizer.
func (mlst MicrosoftLanguageStemmingTokenizer) AsTokenizer() (*Tokenizer, bool) {
	return nil, false
}

// AsBasicTokenizer is the BasicTokenizer implementation for MicrosoftLanguageStemmingTokenizer.
func (mlst MicrosoftLanguageStemmingTokenizer) AsBasicTokenizer() (BasicTokenizer, bool) {
	return &mlst, true
}

// MicrosoftLanguageTokenizer divides text using language-specific rules.
type MicrosoftLanguageTokenizer struct {
	// Name - The name of the tokenizer. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeTokenizer', 'OdataTypeMicrosoftAzureSearchClassicTokenizer', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenizer', 'OdataTypeMicrosoftAzureSearchKeywordTokenizer', 'OdataTypeMicrosoftAzureSearchKeywordTokenizerV2', 'OdataTypeMicrosoftAzureSearchMicrosoftLanguageTokenizer', 'OdataTypeMicrosoftAzureSearchMicrosoftLanguageStemmingTokenizer', 'OdataTypeMicrosoftAzureSearchNGramTokenizer', 'OdataTypeMicrosoftAzureSearchPathHierarchyTokenizer', 'OdataTypeMicrosoftAzureSearchPathHierarchyTokenizerV2', 'OdataTypeMicrosoftAzureSearchPatternTokenizer', 'OdataTypeMicrosoftAzureSearchStandardTokenizer', 'OdataTypeMicrosoftAzureSearchStandardTokenizerV2', 'OdataTypeMicrosoftAzureSearchUaxURLEmailTokenizer'
	OdataType OdataTypeBasicTokenizer `json:"@odata.type,omitempty"`
	// MaxTokenLength - The maximum token length. Tokens longer than the maximum length are split. Maximum token length that can be used is 300 characters. Tokens longer than 300 characters are first split into tokens of length 300 and then each of those tokens is split based on the max token length set. Default is 255.
	MaxTokenLength *int32 `json:"maxTokenLength,omitempty"`
	// IsSearchTokenizer - A value indicating how the tokenizer is used. Set to true if used as the search tokenizer, set to false if used as the indexing tokenizer. Default is false.
	IsSearchTokenizer *bool `json:"isSearchTokenizer,omitempty"`
	// Language - The language to use. The default is English. Possible values include: 'MicrosoftTokenizerLanguageBangla', 'MicrosoftTokenizerLanguageBulgarian', 'MicrosoftTokenizerLanguageCatalan', 'MicrosoftTokenizerLanguageChineseSimplified', 'MicrosoftTokenizerLanguageChineseTraditional', 'MicrosoftTokenizerLanguageCroatian', 'MicrosoftTokenizerLanguageCzech', 'MicrosoftTokenizerLanguageDanish', 'MicrosoftTokenizerLanguageDutch', 'MicrosoftTokenizerLanguageEnglish', 'MicrosoftTokenizerLanguageFrench', 'MicrosoftTokenizerLanguageGerman', 'MicrosoftTokenizerLanguageGreek', 'MicrosoftTokenizerLanguageGujarati', 'MicrosoftTokenizerLanguageHindi', 'MicrosoftTokenizerLanguageIcelandic', 'MicrosoftTokenizerLanguageIndonesian', 'MicrosoftTokenizerLanguageItalian', 'MicrosoftTokenizerLanguageJapanese', 'MicrosoftTokenizerLanguageKannada', 'MicrosoftTokenizerLanguageKorean', 'MicrosoftTokenizerLanguageMalay', 'MicrosoftTokenizerLanguageMalayalam', 'MicrosoftTokenizerLanguageMarathi', 'MicrosoftTokenizerLanguageNorwegianBokmaal', 'MicrosoftTokenizerLanguagePolish', 'MicrosoftTokenizerLanguagePortuguese', 'MicrosoftTokenizerLanguagePortugueseBrazilian', 'MicrosoftTokenizerLanguagePunjabi', 'MicrosoftTokenizerLanguageRomanian', 'MicrosoftTokenizerLanguageRussian', 'MicrosoftTokenizerLanguageSerbianCyrillic', 'MicrosoftTokenizerLanguageSerbianLatin', 'MicrosoftTokenizerLanguageSlovenian', 'MicrosoftTokenizerLanguageSpanish', 'MicrosoftTokenizerLanguageSwedish', 'MicrosoftTokenizerLanguageTamil', 'MicrosoftTokenizerLanguageTelugu', 'MicrosoftTokenizerLanguageThai', 'MicrosoftTokenizerLanguageUkrainian', 'MicrosoftTokenizerLanguageUrdu', 'MicrosoftTokenizerLanguageVietnamese'
	Language MicrosoftTokenizerLanguage `json:"language,omitempty"`
}

// MarshalJSON is the custom marshaler for MicrosoftLanguageTokenizer.
func (mlt MicrosoftLanguageTokenizer) MarshalJSON() ([]byte, error) {
	mlt.OdataType = OdataTypeMicrosoftAzureSearchMicrosoftLanguageTokenizer
	type Alias MicrosoftLanguageTokenizer
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(mlt),
	})
}

// AsClassicTokenizer is the BasicTokenizer implementation for MicrosoftLanguageTokenizer.
func (mlt MicrosoftLanguageTokenizer) AsClassicTokenizer() (*ClassicTokenizer, bool) {
	return nil, false
}

// AsEdgeNGramTokenizer is the BasicTokenizer implementation for MicrosoftLanguageTokenizer.
func (mlt MicrosoftLanguageTokenizer) AsEdgeNGramTokenizer() (*EdgeNGramTokenizer, bool) {
	return nil, false
}

// AsKeywordTokenizer is the BasicTokenizer implementation for MicrosoftLanguageTokenizer.
func (mlt MicrosoftLanguageTokenizer) AsKeywordTokenizer() (*KeywordTokenizer, bool) {
	return nil, false
}

// AsKeywordTokenizerV2 is the BasicTokenizer implementation for MicrosoftLanguageTokenizer.
func (mlt MicrosoftLanguageTokenizer) AsKeywordTokenizerV2() (*KeywordTokenizerV2, bool) {
	return nil, false
}

// AsMicrosoftLanguageTokenizer is the BasicTokenizer implementation for MicrosoftLanguageTokenizer.
func (mlt MicrosoftLanguageTokenizer) AsMicrosoftLanguageTokenizer() (*MicrosoftLanguageTokenizer, bool) {
	return &mlt, true
}

// AsMicrosoftLanguageStemmingTokenizer is the BasicTokenizer implementation for MicrosoftLanguageTokenizer.
func (mlt MicrosoftLanguageTokenizer) AsMicrosoftLanguageStemmingTokenizer() (*MicrosoftLanguageStemmingTokenizer, bool) {
	return nil, false
}

// AsNGramTokenizer is the BasicTokenizer implementation for MicrosoftLanguageTokenizer.
func (mlt MicrosoftLanguageTokenizer) AsNGramTokenizer() (*NGramTokenizer, bool) {
	return nil, false
}

// AsPathHierarchyTokenizer is the BasicTokenizer implementation for MicrosoftLanguageTokenizer.
func (mlt MicrosoftLanguageTokenizer) AsPathHierarchyTokenizer() (*PathHierarchyTokenizer, bool) {
	return nil, false
}

// AsPathHierarchyTokenizerV2 is the BasicTokenizer implementation for MicrosoftLanguageTokenizer.
func (mlt MicrosoftLanguageTokenizer) AsPathHierarchyTokenizerV2() (*PathHierarchyTokenizerV2, bool) {
	return nil, false
}

// AsPatternTokenizer is the BasicTokenizer implementation for MicrosoftLanguageTokenizer.
func (mlt MicrosoftLanguageTokenizer) AsPatternTokenizer() (*PatternTokenizer, bool) {
	return nil, false
}

// AsStandardTokenizer is the BasicTokenizer implementation for MicrosoftLanguageTokenizer.
func (mlt MicrosoftLanguageTokenizer) AsStandardTokenizer() (*StandardTokenizer, bool) {
	return nil, false
}

// AsStandardTokenizerV2 is the BasicTokenizer implementation for MicrosoftLanguageTokenizer.
func (mlt MicrosoftLanguageTokenizer) AsStandardTokenizerV2() (*StandardTokenizerV2, bool) {
	return nil, false
}

// AsUaxURLEmailTokenizer is the BasicTokenizer implementation for MicrosoftLanguageTokenizer.
func (mlt MicrosoftLanguageTokenizer) AsUaxURLEmailTokenizer() (*UaxURLEmailTokenizer, bool) {
	return nil, false
}

// AsTokenizer is the BasicTokenizer implementation for MicrosoftLanguageTokenizer.
func (mlt MicrosoftLanguageTokenizer) AsTokenizer() (*Tokenizer, bool) {
	return nil, false
}

// AsBasicTokenizer is the BasicTokenizer implementation for MicrosoftLanguageTokenizer.
func (mlt MicrosoftLanguageTokenizer) AsBasicTokenizer() (BasicTokenizer, bool) {
	return &mlt, true
}

// NGramTokenFilter generates n-grams of the given size(s). This token filter is implemented using Apache Lucene.
type NGramTokenFilter struct {
	// Name - The name of the token filter. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeTokenFilter', 'OdataTypeMicrosoftAzureSearchASCIIFoldingTokenFilter', 'OdataTypeMicrosoftAzureSearchCjkBigramTokenFilter', 'OdataTypeMicrosoftAzureSearchCommonGramTokenFilter', 'OdataTypeMicrosoftAzureSearchDictionaryDecompounderTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchElisionTokenFilter', 'OdataTypeMicrosoftAzureSearchKeepTokenFilter', 'OdataTypeMicrosoftAzureSearchKeywordMarkerTokenFilter', 'OdataTypeMicrosoftAzureSearchLengthTokenFilter', 'OdataTypeMicrosoftAzureSearchLimitTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchPatternCaptureTokenFilter', 'OdataTypeMicrosoftAzureSearchPatternReplaceTokenFilter', 'OdataTypeMicrosoftAzureSearchPhoneticTokenFilter', 'OdataTypeMicrosoftAzureSearchShingleTokenFilter', 'OdataTypeMicrosoftAzureSearchSnowballTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerOverrideTokenFilter', 'OdataTypeMicrosoftAzureSearchStopwordsTokenFilter', 'OdataTypeMicrosoftAzureSearchSynonymTokenFilter', 'OdataTypeMicrosoftAzureSearchTruncateTokenFilter', 'OdataTypeMicrosoftAzureSearchUniqueTokenFilter', 'OdataTypeMicrosoftAzureSearchWordDelimiterTokenFilter'
	OdataType OdataTypeBasicTokenFilter `json:"@odata.type,omitempty"`
	// MinGram - The minimum n-gram length. Default is 1. Must be less than the value of maxGram.
	MinGram *int32 `json:"minGram,omitempty"`
	// MaxGram - The maximum n-gram length. Default is 2.
	MaxGram *int32 `json:"maxGram,omitempty"`
}

// MarshalJSON is the custom marshaler for NGramTokenFilter.
func (ngtf NGramTokenFilter) MarshalJSON() ([]byte, error) {
	ngtf.OdataType = OdataTypeMicrosoftAzureSearchNGramTokenFilter
	type Alias NGramTokenFilter
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ngtf),
	})
}

// AsASCIIFoldingTokenFilter is the BasicTokenFilter implementation for NGramTokenFilter.
func (ngtf NGramTokenFilter) AsASCIIFoldingTokenFilter() (*ASCIIFoldingTokenFilter, bool) {
	return nil, false
}

// AsCjkBigramTokenFilter is the BasicTokenFilter implementation for NGramTokenFilter.
func (ngtf NGramTokenFilter) AsCjkBigramTokenFilter() (*CjkBigramTokenFilter, bool) {
	return nil, false
}

// AsCommonGramTokenFilter is the BasicTokenFilter implementation for NGramTokenFilter.
func (ngtf NGramTokenFilter) AsCommonGramTokenFilter() (*CommonGramTokenFilter, bool) {
	return nil, false
}

// AsDictionaryDecompounderTokenFilter is the BasicTokenFilter implementation for NGramTokenFilter.
func (ngtf NGramTokenFilter) AsDictionaryDecompounderTokenFilter() (*DictionaryDecompounderTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilter is the BasicTokenFilter implementation for NGramTokenFilter.
func (ngtf NGramTokenFilter) AsEdgeNGramTokenFilter() (*EdgeNGramTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilterV2 is the BasicTokenFilter implementation for NGramTokenFilter.
func (ngtf NGramTokenFilter) AsEdgeNGramTokenFilterV2() (*EdgeNGramTokenFilterV2, bool) {
	return nil, false
}

// AsElisionTokenFilter is the BasicTokenFilter implementation for NGramTokenFilter.
func (ngtf NGramTokenFilter) AsElisionTokenFilter() (*ElisionTokenFilter, bool) {
	return nil, false
}

// AsKeepTokenFilter is the BasicTokenFilter implementation for NGramTokenFilter.
func (ngtf NGramTokenFilter) AsKeepTokenFilter() (*KeepTokenFilter, bool) {
	return nil, false
}

// AsKeywordMarkerTokenFilter is the BasicTokenFilter implementation for NGramTokenFilter.
func (ngtf NGramTokenFilter) AsKeywordMarkerTokenFilter() (*KeywordMarkerTokenFilter, bool) {
	return nil, false
}

// AsLengthTokenFilter is the BasicTokenFilter implementation for NGramTokenFilter.
func (ngtf NGramTokenFilter) AsLengthTokenFilter() (*LengthTokenFilter, bool) {
	return nil, false
}

// AsLimitTokenFilter is the BasicTokenFilter implementation for NGramTokenFilter.
func (ngtf NGramTokenFilter) AsLimitTokenFilter() (*LimitTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilter is the BasicTokenFilter implementation for NGramTokenFilter.
func (ngtf NGramTokenFilter) AsNGramTokenFilter() (*NGramTokenFilter, bool) {
	return &ngtf, true
}

// AsNGramTokenFilterV2 is the BasicTokenFilter implementation for NGramTokenFilter.
func (ngtf NGramTokenFilter) AsNGramTokenFilterV2() (*NGramTokenFilterV2, bool) {
	return nil, false
}

// AsPatternCaptureTokenFilter is the BasicTokenFilter implementation for NGramTokenFilter.
func (ngtf NGramTokenFilter) AsPatternCaptureTokenFilter() (*PatternCaptureTokenFilter, bool) {
	return nil, false
}

// AsPatternReplaceTokenFilter is the BasicTokenFilter implementation for NGramTokenFilter.
func (ngtf NGramTokenFilter) AsPatternReplaceTokenFilter() (*PatternReplaceTokenFilter, bool) {
	return nil, false
}

// AsPhoneticTokenFilter is the BasicTokenFilter implementation for NGramTokenFilter.
func (ngtf NGramTokenFilter) AsPhoneticTokenFilter() (*PhoneticTokenFilter, bool) {
	return nil, false
}

// AsShingleTokenFilter is the BasicTokenFilter implementation for NGramTokenFilter.
func (ngtf NGramTokenFilter) AsShingleTokenFilter() (*ShingleTokenFilter, bool) {
	return nil, false
}

// AsSnowballTokenFilter is the BasicTokenFilter implementation for NGramTokenFilter.
func (ngtf NGramTokenFilter) AsSnowballTokenFilter() (*SnowballTokenFilter, bool) {
	return nil, false
}

// AsStemmerTokenFilter is the BasicTokenFilter implementation for NGramTokenFilter.
func (ngtf NGramTokenFilter) AsStemmerTokenFilter() (*StemmerTokenFilter, bool) {
	return nil, false
}

// AsStemmerOverrideTokenFilter is the BasicTokenFilter implementation for NGramTokenFilter.
func (ngtf NGramTokenFilter) AsStemmerOverrideTokenFilter() (*StemmerOverrideTokenFilter, bool) {
	return nil, false
}

// AsStopwordsTokenFilter is the BasicTokenFilter implementation for NGramTokenFilter.
func (ngtf NGramTokenFilter) AsStopwordsTokenFilter() (*StopwordsTokenFilter, bool) {
	return nil, false
}

// AsSynonymTokenFilter is the BasicTokenFilter implementation for NGramTokenFilter.
func (ngtf NGramTokenFilter) AsSynonymTokenFilter() (*SynonymTokenFilter, bool) {
	return nil, false
}

// AsTruncateTokenFilter is the BasicTokenFilter implementation for NGramTokenFilter.
func (ngtf NGramTokenFilter) AsTruncateTokenFilter() (*TruncateTokenFilter, bool) {
	return nil, false
}

// AsUniqueTokenFilter is the BasicTokenFilter implementation for NGramTokenFilter.
func (ngtf NGramTokenFilter) AsUniqueTokenFilter() (*UniqueTokenFilter, bool) {
	return nil, false
}

// AsWordDelimiterTokenFilter is the BasicTokenFilter implementation for NGramTokenFilter.
func (ngtf NGramTokenFilter) AsWordDelimiterTokenFilter() (*WordDelimiterTokenFilter, bool) {
	return nil, false
}

// AsTokenFilter is the BasicTokenFilter implementation for NGramTokenFilter.
func (ngtf NGramTokenFilter) AsTokenFilter() (*TokenFilter, bool) {
	return nil, false
}

// AsBasicTokenFilter is the BasicTokenFilter implementation for NGramTokenFilter.
func (ngtf NGramTokenFilter) AsBasicTokenFilter() (BasicTokenFilter, bool) {
	return &ngtf, true
}

// NGramTokenFilterV2 generates n-grams of the given size(s). This token filter is implemented using Apache Lucene.
type NGramTokenFilterV2 struct {
	// Name - The name of the token filter. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeTokenFilter', 'OdataTypeMicrosoftAzureSearchASCIIFoldingTokenFilter', 'OdataTypeMicrosoftAzureSearchCjkBigramTokenFilter', 'OdataTypeMicrosoftAzureSearchCommonGramTokenFilter', 'OdataTypeMicrosoftAzureSearchDictionaryDecompounderTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchElisionTokenFilter', 'OdataTypeMicrosoftAzureSearchKeepTokenFilter', 'OdataTypeMicrosoftAzureSearchKeywordMarkerTokenFilter', 'OdataTypeMicrosoftAzureSearchLengthTokenFilter', 'OdataTypeMicrosoftAzureSearchLimitTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchPatternCaptureTokenFilter', 'OdataTypeMicrosoftAzureSearchPatternReplaceTokenFilter', 'OdataTypeMicrosoftAzureSearchPhoneticTokenFilter', 'OdataTypeMicrosoftAzureSearchShingleTokenFilter', 'OdataTypeMicrosoftAzureSearchSnowballTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerOverrideTokenFilter', 'OdataTypeMicrosoftAzureSearchStopwordsTokenFilter', 'OdataTypeMicrosoftAzureSearchSynonymTokenFilter', 'OdataTypeMicrosoftAzureSearchTruncateTokenFilter', 'OdataTypeMicrosoftAzureSearchUniqueTokenFilter', 'OdataTypeMicrosoftAzureSearchWordDelimiterTokenFilter'
	OdataType OdataTypeBasicTokenFilter `json:"@odata.type,omitempty"`
	// MinGram - The minimum n-gram length. Default is 1. Maximum is 300. Must be less than the value of maxGram.
	MinGram *int32 `json:"minGram,omitempty"`
	// MaxGram - The maximum n-gram length. Default is 2. Maximum is 300.
	MaxGram *int32 `json:"maxGram,omitempty"`
}

// MarshalJSON is the custom marshaler for NGramTokenFilterV2.
func (ngtfv NGramTokenFilterV2) MarshalJSON() ([]byte, error) {
	ngtfv.OdataType = OdataTypeMicrosoftAzureSearchNGramTokenFilterV2
	type Alias NGramTokenFilterV2
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ngtfv),
	})
}

// AsASCIIFoldingTokenFilter is the BasicTokenFilter implementation for NGramTokenFilterV2.
func (ngtfv NGramTokenFilterV2) AsASCIIFoldingTokenFilter() (*ASCIIFoldingTokenFilter, bool) {
	return nil, false
}

// AsCjkBigramTokenFilter is the BasicTokenFilter implementation for NGramTokenFilterV2.
func (ngtfv NGramTokenFilterV2) AsCjkBigramTokenFilter() (*CjkBigramTokenFilter, bool) {
	return nil, false
}

// AsCommonGramTokenFilter is the BasicTokenFilter implementation for NGramTokenFilterV2.
func (ngtfv NGramTokenFilterV2) AsCommonGramTokenFilter() (*CommonGramTokenFilter, bool) {
	return nil, false
}

// AsDictionaryDecompounderTokenFilter is the BasicTokenFilter implementation for NGramTokenFilterV2.
func (ngtfv NGramTokenFilterV2) AsDictionaryDecompounderTokenFilter() (*DictionaryDecompounderTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilter is the BasicTokenFilter implementation for NGramTokenFilterV2.
func (ngtfv NGramTokenFilterV2) AsEdgeNGramTokenFilter() (*EdgeNGramTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilterV2 is the BasicTokenFilter implementation for NGramTokenFilterV2.
func (ngtfv NGramTokenFilterV2) AsEdgeNGramTokenFilterV2() (*EdgeNGramTokenFilterV2, bool) {
	return nil, false
}

// AsElisionTokenFilter is the BasicTokenFilter implementation for NGramTokenFilterV2.
func (ngtfv NGramTokenFilterV2) AsElisionTokenFilter() (*ElisionTokenFilter, bool) {
	return nil, false
}

// AsKeepTokenFilter is the BasicTokenFilter implementation for NGramTokenFilterV2.
func (ngtfv NGramTokenFilterV2) AsKeepTokenFilter() (*KeepTokenFilter, bool) {
	return nil, false
}

// AsKeywordMarkerTokenFilter is the BasicTokenFilter implementation for NGramTokenFilterV2.
func (ngtfv NGramTokenFilterV2) AsKeywordMarkerTokenFilter() (*KeywordMarkerTokenFilter, bool) {
	return nil, false
}

// AsLengthTokenFilter is the BasicTokenFilter implementation for NGramTokenFilterV2.
func (ngtfv NGramTokenFilterV2) AsLengthTokenFilter() (*LengthTokenFilter, bool) {
	return nil, false
}

// AsLimitTokenFilter is the BasicTokenFilter implementation for NGramTokenFilterV2.
func (ngtfv NGramTokenFilterV2) AsLimitTokenFilter() (*LimitTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilter is the BasicTokenFilter implementation for NGramTokenFilterV2.
func (ngtfv NGramTokenFilterV2) AsNGramTokenFilter() (*NGramTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilterV2 is the BasicTokenFilter implementation for NGramTokenFilterV2.
func (ngtfv NGramTokenFilterV2) AsNGramTokenFilterV2() (*NGramTokenFilterV2, bool) {
	return &ngtfv, true
}

// AsPatternCaptureTokenFilter is the BasicTokenFilter implementation for NGramTokenFilterV2.
func (ngtfv NGramTokenFilterV2) AsPatternCaptureTokenFilter() (*PatternCaptureTokenFilter, bool) {
	return nil, false
}

// AsPatternReplaceTokenFilter is the BasicTokenFilter implementation for NGramTokenFilterV2.
func (ngtfv NGramTokenFilterV2) AsPatternReplaceTokenFilter() (*PatternReplaceTokenFilter, bool) {
	return nil, false
}

// AsPhoneticTokenFilter is the BasicTokenFilter implementation for NGramTokenFilterV2.
func (ngtfv NGramTokenFilterV2) AsPhoneticTokenFilter() (*PhoneticTokenFilter, bool) {
	return nil, false
}

// AsShingleTokenFilter is the BasicTokenFilter implementation for NGramTokenFilterV2.
func (ngtfv NGramTokenFilterV2) AsShingleTokenFilter() (*ShingleTokenFilter, bool) {
	return nil, false
}

// AsSnowballTokenFilter is the BasicTokenFilter implementation for NGramTokenFilterV2.
func (ngtfv NGramTokenFilterV2) AsSnowballTokenFilter() (*SnowballTokenFilter, bool) {
	return nil, false
}

// AsStemmerTokenFilter is the BasicTokenFilter implementation for NGramTokenFilterV2.
func (ngtfv NGramTokenFilterV2) AsStemmerTokenFilter() (*StemmerTokenFilter, bool) {
	return nil, false
}

// AsStemmerOverrideTokenFilter is the BasicTokenFilter implementation for NGramTokenFilterV2.
func (ngtfv NGramTokenFilterV2) AsStemmerOverrideTokenFilter() (*StemmerOverrideTokenFilter, bool) {
	return nil, false
}

// AsStopwordsTokenFilter is the BasicTokenFilter implementation for NGramTokenFilterV2.
func (ngtfv NGramTokenFilterV2) AsStopwordsTokenFilter() (*StopwordsTokenFilter, bool) {
	return nil, false
}

// AsSynonymTokenFilter is the BasicTokenFilter implementation for NGramTokenFilterV2.
func (ngtfv NGramTokenFilterV2) AsSynonymTokenFilter() (*SynonymTokenFilter, bool) {
	return nil, false
}

// AsTruncateTokenFilter is the BasicTokenFilter implementation for NGramTokenFilterV2.
func (ngtfv NGramTokenFilterV2) AsTruncateTokenFilter() (*TruncateTokenFilter, bool) {
	return nil, false
}

// AsUniqueTokenFilter is the BasicTokenFilter implementation for NGramTokenFilterV2.
func (ngtfv NGramTokenFilterV2) AsUniqueTokenFilter() (*UniqueTokenFilter, bool) {
	return nil, false
}

// AsWordDelimiterTokenFilter is the BasicTokenFilter implementation for NGramTokenFilterV2.
func (ngtfv NGramTokenFilterV2) AsWordDelimiterTokenFilter() (*WordDelimiterTokenFilter, bool) {
	return nil, false
}

// AsTokenFilter is the BasicTokenFilter implementation for NGramTokenFilterV2.
func (ngtfv NGramTokenFilterV2) AsTokenFilter() (*TokenFilter, bool) {
	return nil, false
}

// AsBasicTokenFilter is the BasicTokenFilter implementation for NGramTokenFilterV2.
func (ngtfv NGramTokenFilterV2) AsBasicTokenFilter() (BasicTokenFilter, bool) {
	return &ngtfv, true
}

// NGramTokenizer tokenizes the input into n-grams of the given size(s). This tokenizer is implemented using Apache
// Lucene.
type NGramTokenizer struct {
	// Name - The name of the tokenizer. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeTokenizer', 'OdataTypeMicrosoftAzureSearchClassicTokenizer', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenizer', 'OdataTypeMicrosoftAzureSearchKeywordTokenizer', 'OdataTypeMicrosoftAzureSearchKeywordTokenizerV2', 'OdataTypeMicrosoftAzureSearchMicrosoftLanguageTokenizer', 'OdataTypeMicrosoftAzureSearchMicrosoftLanguageStemmingTokenizer', 'OdataTypeMicrosoftAzureSearchNGramTokenizer', 'OdataTypeMicrosoftAzureSearchPathHierarchyTokenizer', 'OdataTypeMicrosoftAzureSearchPathHierarchyTokenizerV2', 'OdataTypeMicrosoftAzureSearchPatternTokenizer', 'OdataTypeMicrosoftAzureSearchStandardTokenizer', 'OdataTypeMicrosoftAzureSearchStandardTokenizerV2', 'OdataTypeMicrosoftAzureSearchUaxURLEmailTokenizer'
	OdataType OdataTypeBasicTokenizer `json:"@odata.type,omitempty"`
	// MinGram - The minimum n-gram length. Default is 1. Maximum is 300. Must be less than the value of maxGram.
	MinGram *int32 `json:"minGram,omitempty"`
	// MaxGram - The maximum n-gram length. Default is 2. Maximum is 300.
	MaxGram *int32 `json:"maxGram,omitempty"`
	// TokenChars - Character classes to keep in the tokens.
	TokenChars *[]TokenCharacterKind `json:"tokenChars,omitempty"`
}

// MarshalJSON is the custom marshaler for NGramTokenizer.
func (ngt NGramTokenizer) MarshalJSON() ([]byte, error) {
	ngt.OdataType = OdataTypeMicrosoftAzureSearchNGramTokenizer
	type Alias NGramTokenizer
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ngt),
	})
}

// AsClassicTokenizer is the BasicTokenizer implementation for NGramTokenizer.
func (ngt NGramTokenizer) AsClassicTokenizer() (*ClassicTokenizer, bool) {
	return nil, false
}

// AsEdgeNGramTokenizer is the BasicTokenizer implementation for NGramTokenizer.
func (ngt NGramTokenizer) AsEdgeNGramTokenizer() (*EdgeNGramTokenizer, bool) {
	return nil, false
}

// AsKeywordTokenizer is the BasicTokenizer implementation for NGramTokenizer.
func (ngt NGramTokenizer) AsKeywordTokenizer() (*KeywordTokenizer, bool) {
	return nil, false
}

// AsKeywordTokenizerV2 is the BasicTokenizer implementation for NGramTokenizer.
func (ngt NGramTokenizer) AsKeywordTokenizerV2() (*KeywordTokenizerV2, bool) {
	return nil, false
}

// AsMicrosoftLanguageTokenizer is the BasicTokenizer implementation for NGramTokenizer.
func (ngt NGramTokenizer) AsMicrosoftLanguageTokenizer() (*MicrosoftLanguageTokenizer, bool) {
	return nil, false
}

// AsMicrosoftLanguageStemmingTokenizer is the BasicTokenizer implementation for NGramTokenizer.
func (ngt NGramTokenizer) AsMicrosoftLanguageStemmingTokenizer() (*MicrosoftLanguageStemmingTokenizer, bool) {
	return nil, false
}

// AsNGramTokenizer is the BasicTokenizer implementation for NGramTokenizer.
func (ngt NGramTokenizer) AsNGramTokenizer() (*NGramTokenizer, bool) {
	return &ngt, true
}

// AsPathHierarchyTokenizer is the BasicTokenizer implementation for NGramTokenizer.
func (ngt NGramTokenizer) AsPathHierarchyTokenizer() (*PathHierarchyTokenizer, bool) {
	return nil, false
}

// AsPathHierarchyTokenizerV2 is the BasicTokenizer implementation for NGramTokenizer.
func (ngt NGramTokenizer) AsPathHierarchyTokenizerV2() (*PathHierarchyTokenizerV2, bool) {
	return nil, false
}

// AsPatternTokenizer is the BasicTokenizer implementation for NGramTokenizer.
func (ngt NGramTokenizer) AsPatternTokenizer() (*PatternTokenizer, bool) {
	return nil, false
}

// AsStandardTokenizer is the BasicTokenizer implementation for NGramTokenizer.
func (ngt NGramTokenizer) AsStandardTokenizer() (*StandardTokenizer, bool) {
	return nil, false
}

// AsStandardTokenizerV2 is the BasicTokenizer implementation for NGramTokenizer.
func (ngt NGramTokenizer) AsStandardTokenizerV2() (*StandardTokenizerV2, bool) {
	return nil, false
}

// AsUaxURLEmailTokenizer is the BasicTokenizer implementation for NGramTokenizer.
func (ngt NGramTokenizer) AsUaxURLEmailTokenizer() (*UaxURLEmailTokenizer, bool) {
	return nil, false
}

// AsTokenizer is the BasicTokenizer implementation for NGramTokenizer.
func (ngt NGramTokenizer) AsTokenizer() (*Tokenizer, bool) {
	return nil, false
}

// AsBasicTokenizer is the BasicTokenizer implementation for NGramTokenizer.
func (ngt NGramTokenizer) AsBasicTokenizer() (BasicTokenizer, bool) {
	return &ngt, true
}

// ParametersPayload parameters for filtering, sorting, faceting, paging, and other search query behaviors.
type ParametersPayload struct {
	// Count - A value that specifies whether to fetch the total count of results. Default is false. Setting this value to true may have a performance impact. Note that the count returned is an approximation.
	Count *bool `json:"count,omitempty"`
	// Facets - The list of facet expressions to apply to the search query. Each facet expression contains a field name, optionally followed by a comma-separated list of name:value pairs.
	Facets *[]string `json:"facets,omitempty"`
	// Filter - The OData $filter expression to apply to the search query.
	Filter *string `json:"filter,omitempty"`
	// Highlight - The comma-separated list of field names to use for hit highlights. Only searchable fields can be used for hit highlighting.
	Highlight *string `json:"highlight,omitempty"`
	// HighlightPostTag - A string tag that is appended to hit highlights. Must be set with HighlightPreTag. Default is &lt;/em&gt;.
	HighlightPostTag *string `json:"highlightPostTag,omitempty"`
	// HighlightPreTag - A string tag that is prepended to hit highlights. Must be set with HighlightPostTag. Default is &lt;em&gt;.
	HighlightPreTag *string `json:"highlightPreTag,omitempty"`
	// MinimumCoverage - A number between 0 and 100 indicating the percentage of the index that must be covered by a search query in order for the query to be reported as a success. This parameter can be useful for ensuring search availability even for services with only one replica. The default is 100.
	MinimumCoverage *float64 `json:"minimumCoverage,omitempty"`
	// OrderBy - The comma-separated list of OData $orderby expressions by which to sort the results. Each expression can be either a field name or a call to the geo.distance() function. Each expression can be followed by asc to indicate ascending, and desc to indicate descending. The default is ascending order. Ties will be broken by the match scores of documents. If no OrderBy is specified, the default sort order is descending by document match score. There can be at most 32 Orderby clauses.
	OrderBy *string `json:"orderby,omitempty"`
	// QueryType - Gets or sets a value that specifies the syntax of the search query. The default is 'simple'. Use 'full' if your query uses the Lucene query syntax. Possible values include: 'Simple', 'Full'
	QueryType QueryType `json:"queryType,omitempty"`
	// ScoringParameters - The list of parameter values to be used in scoring functions (for example, referencePointParameter) using the format name:value. For example, if the scoring profile defines a function with a parameter called 'mylocation' the parameter string would be "mylocation:-122.2,44.8"(without the quotes).
	ScoringParameters *[]string `json:"scoringParameters,omitempty"`
	// ScoringProfile - The name of a scoring profile to evaluate match scores for matching documents in order to sort the results.
	ScoringProfile *string `json:"scoringProfile,omitempty"`
	// SearchProperty - A full-text search query expression; Use null or "*" to match all documents.
	SearchProperty *string `json:"search,omitempty"`
	// SearchFields - The comma-separated list of field names to include in the full-text search.
	SearchFields *string `json:"searchFields,omitempty"`
	// SearchMode - A value that specifies whether any or all of the search terms must be matched in order to count the document as a match. Possible values include: 'Any', 'All'
	SearchMode Mode `json:"searchMode,omitempty"`
	// Select - The comma-separated list of fields to retrieve. If unspecified, all fields marked as retrievable in the schema are included.
	Select *string `json:"select,omitempty"`
	// Skip - The number of search results to skip. This value cannot be greater than 100,000. If you need to scan documents in sequence, but cannot use Skip due to this limitation, consider using OrderBy on a totally-ordered key and Filter with a range query instead.
	Skip *int32 `json:"skip,omitempty"`
	// Top - The number of search results to retrieve. This can be used in conjunction with Skip to implement client-side paging of search results. If results are truncated due to server-side paging, the response will include a continuation token that can be passed to ContinueSearch to retrieve the next page of results. See DocumentSearchResponse.ContinuationToken for more information.
	Top *int32 `json:"top,omitempty"`
}

// PathHierarchyTokenizer tokenizer for path-like hierarchies. This tokenizer is implemented using Apache Lucene.
type PathHierarchyTokenizer struct {
	// Name - The name of the tokenizer. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeTokenizer', 'OdataTypeMicrosoftAzureSearchClassicTokenizer', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenizer', 'OdataTypeMicrosoftAzureSearchKeywordTokenizer', 'OdataTypeMicrosoftAzureSearchKeywordTokenizerV2', 'OdataTypeMicrosoftAzureSearchMicrosoftLanguageTokenizer', 'OdataTypeMicrosoftAzureSearchMicrosoftLanguageStemmingTokenizer', 'OdataTypeMicrosoftAzureSearchNGramTokenizer', 'OdataTypeMicrosoftAzureSearchPathHierarchyTokenizer', 'OdataTypeMicrosoftAzureSearchPathHierarchyTokenizerV2', 'OdataTypeMicrosoftAzureSearchPatternTokenizer', 'OdataTypeMicrosoftAzureSearchStandardTokenizer', 'OdataTypeMicrosoftAzureSearchStandardTokenizerV2', 'OdataTypeMicrosoftAzureSearchUaxURLEmailTokenizer'
	OdataType OdataTypeBasicTokenizer `json:"@odata.type,omitempty"`
	// Delimiter - The delimiter character to use. Default is "/".
	Delimiter *string `json:"delimiter,omitempty"`
	// Replacement - A value that, if set, replaces the delimiter character. Default is "/".
	Replacement *string `json:"replacement,omitempty"`
	// BufferSize - The buffer size. Default is 1024.
	BufferSize *int32 `json:"bufferSize,omitempty"`
	// ReverseTokenOrder - A value indicating whether to generate tokens in reverse order. Default is false.
	ReverseTokenOrder *bool `json:"reverse,omitempty"`
	// NumberOfTokensToSkip - The number of initial tokens to skip. Default is 0.
	NumberOfTokensToSkip *int32 `json:"skip,omitempty"`
}

// MarshalJSON is the custom marshaler for PathHierarchyTokenizer.
func (pht PathHierarchyTokenizer) MarshalJSON() ([]byte, error) {
	pht.OdataType = OdataTypeMicrosoftAzureSearchPathHierarchyTokenizer
	type Alias PathHierarchyTokenizer
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(pht),
	})
}

// AsClassicTokenizer is the BasicTokenizer implementation for PathHierarchyTokenizer.
func (pht PathHierarchyTokenizer) AsClassicTokenizer() (*ClassicTokenizer, bool) {
	return nil, false
}

// AsEdgeNGramTokenizer is the BasicTokenizer implementation for PathHierarchyTokenizer.
func (pht PathHierarchyTokenizer) AsEdgeNGramTokenizer() (*EdgeNGramTokenizer, bool) {
	return nil, false
}

// AsKeywordTokenizer is the BasicTokenizer implementation for PathHierarchyTokenizer.
func (pht PathHierarchyTokenizer) AsKeywordTokenizer() (*KeywordTokenizer, bool) {
	return nil, false
}

// AsKeywordTokenizerV2 is the BasicTokenizer implementation for PathHierarchyTokenizer.
func (pht PathHierarchyTokenizer) AsKeywordTokenizerV2() (*KeywordTokenizerV2, bool) {
	return nil, false
}

// AsMicrosoftLanguageTokenizer is the BasicTokenizer implementation for PathHierarchyTokenizer.
func (pht PathHierarchyTokenizer) AsMicrosoftLanguageTokenizer() (*MicrosoftLanguageTokenizer, bool) {
	return nil, false
}

// AsMicrosoftLanguageStemmingTokenizer is the BasicTokenizer implementation for PathHierarchyTokenizer.
func (pht PathHierarchyTokenizer) AsMicrosoftLanguageStemmingTokenizer() (*MicrosoftLanguageStemmingTokenizer, bool) {
	return nil, false
}

// AsNGramTokenizer is the BasicTokenizer implementation for PathHierarchyTokenizer.
func (pht PathHierarchyTokenizer) AsNGramTokenizer() (*NGramTokenizer, bool) {
	return nil, false
}

// AsPathHierarchyTokenizer is the BasicTokenizer implementation for PathHierarchyTokenizer.
func (pht PathHierarchyTokenizer) AsPathHierarchyTokenizer() (*PathHierarchyTokenizer, bool) {
	return &pht, true
}

// AsPathHierarchyTokenizerV2 is the BasicTokenizer implementation for PathHierarchyTokenizer.
func (pht PathHierarchyTokenizer) AsPathHierarchyTokenizerV2() (*PathHierarchyTokenizerV2, bool) {
	return nil, false
}

// AsPatternTokenizer is the BasicTokenizer implementation for PathHierarchyTokenizer.
func (pht PathHierarchyTokenizer) AsPatternTokenizer() (*PatternTokenizer, bool) {
	return nil, false
}

// AsStandardTokenizer is the BasicTokenizer implementation for PathHierarchyTokenizer.
func (pht PathHierarchyTokenizer) AsStandardTokenizer() (*StandardTokenizer, bool) {
	return nil, false
}

// AsStandardTokenizerV2 is the BasicTokenizer implementation for PathHierarchyTokenizer.
func (pht PathHierarchyTokenizer) AsStandardTokenizerV2() (*StandardTokenizerV2, bool) {
	return nil, false
}

// AsUaxURLEmailTokenizer is the BasicTokenizer implementation for PathHierarchyTokenizer.
func (pht PathHierarchyTokenizer) AsUaxURLEmailTokenizer() (*UaxURLEmailTokenizer, bool) {
	return nil, false
}

// AsTokenizer is the BasicTokenizer implementation for PathHierarchyTokenizer.
func (pht PathHierarchyTokenizer) AsTokenizer() (*Tokenizer, bool) {
	return nil, false
}

// AsBasicTokenizer is the BasicTokenizer implementation for PathHierarchyTokenizer.
func (pht PathHierarchyTokenizer) AsBasicTokenizer() (BasicTokenizer, bool) {
	return &pht, true
}

// PathHierarchyTokenizerV2 tokenizer for path-like hierarchies. This tokenizer is implemented using Apache Lucene.
type PathHierarchyTokenizerV2 struct {
	// Name - The name of the tokenizer. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeTokenizer', 'OdataTypeMicrosoftAzureSearchClassicTokenizer', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenizer', 'OdataTypeMicrosoftAzureSearchKeywordTokenizer', 'OdataTypeMicrosoftAzureSearchKeywordTokenizerV2', 'OdataTypeMicrosoftAzureSearchMicrosoftLanguageTokenizer', 'OdataTypeMicrosoftAzureSearchMicrosoftLanguageStemmingTokenizer', 'OdataTypeMicrosoftAzureSearchNGramTokenizer', 'OdataTypeMicrosoftAzureSearchPathHierarchyTokenizer', 'OdataTypeMicrosoftAzureSearchPathHierarchyTokenizerV2', 'OdataTypeMicrosoftAzureSearchPatternTokenizer', 'OdataTypeMicrosoftAzureSearchStandardTokenizer', 'OdataTypeMicrosoftAzureSearchStandardTokenizerV2', 'OdataTypeMicrosoftAzureSearchUaxURLEmailTokenizer'
	OdataType OdataTypeBasicTokenizer `json:"@odata.type,omitempty"`
	// Delimiter - The delimiter character to use. Default is "/".
	Delimiter *string `json:"delimiter,omitempty"`
	// Replacement - A value that, if set, replaces the delimiter character. Default is "/".
	Replacement *string `json:"replacement,omitempty"`
	// MaxTokenLength - The maximum token length. Default and maximum is 300.
	MaxTokenLength *int32 `json:"maxTokenLength,omitempty"`
	// ReverseTokenOrder - A value indicating whether to generate tokens in reverse order. Default is false.
	ReverseTokenOrder *bool `json:"reverse,omitempty"`
	// NumberOfTokensToSkip - The number of initial tokens to skip. Default is 0.
	NumberOfTokensToSkip *int32 `json:"skip,omitempty"`
}

// MarshalJSON is the custom marshaler for PathHierarchyTokenizerV2.
func (phtv PathHierarchyTokenizerV2) MarshalJSON() ([]byte, error) {
	phtv.OdataType = OdataTypeMicrosoftAzureSearchPathHierarchyTokenizerV2
	type Alias PathHierarchyTokenizerV2
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(phtv),
	})
}

// AsClassicTokenizer is the BasicTokenizer implementation for PathHierarchyTokenizerV2.
func (phtv PathHierarchyTokenizerV2) AsClassicTokenizer() (*ClassicTokenizer, bool) {
	return nil, false
}

// AsEdgeNGramTokenizer is the BasicTokenizer implementation for PathHierarchyTokenizerV2.
func (phtv PathHierarchyTokenizerV2) AsEdgeNGramTokenizer() (*EdgeNGramTokenizer, bool) {
	return nil, false
}

// AsKeywordTokenizer is the BasicTokenizer implementation for PathHierarchyTokenizerV2.
func (phtv PathHierarchyTokenizerV2) AsKeywordTokenizer() (*KeywordTokenizer, bool) {
	return nil, false
}

// AsKeywordTokenizerV2 is the BasicTokenizer implementation for PathHierarchyTokenizerV2.
func (phtv PathHierarchyTokenizerV2) AsKeywordTokenizerV2() (*KeywordTokenizerV2, bool) {
	return nil, false
}

// AsMicrosoftLanguageTokenizer is the BasicTokenizer implementation for PathHierarchyTokenizerV2.
func (phtv PathHierarchyTokenizerV2) AsMicrosoftLanguageTokenizer() (*MicrosoftLanguageTokenizer, bool) {
	return nil, false
}

// AsMicrosoftLanguageStemmingTokenizer is the BasicTokenizer implementation for PathHierarchyTokenizerV2.
func (phtv PathHierarchyTokenizerV2) AsMicrosoftLanguageStemmingTokenizer() (*MicrosoftLanguageStemmingTokenizer, bool) {
	return nil, false
}

// AsNGramTokenizer is the BasicTokenizer implementation for PathHierarchyTokenizerV2.
func (phtv PathHierarchyTokenizerV2) AsNGramTokenizer() (*NGramTokenizer, bool) {
	return nil, false
}

// AsPathHierarchyTokenizer is the BasicTokenizer implementation for PathHierarchyTokenizerV2.
func (phtv PathHierarchyTokenizerV2) AsPathHierarchyTokenizer() (*PathHierarchyTokenizer, bool) {
	return nil, false
}

// AsPathHierarchyTokenizerV2 is the BasicTokenizer implementation for PathHierarchyTokenizerV2.
func (phtv PathHierarchyTokenizerV2) AsPathHierarchyTokenizerV2() (*PathHierarchyTokenizerV2, bool) {
	return &phtv, true
}

// AsPatternTokenizer is the BasicTokenizer implementation for PathHierarchyTokenizerV2.
func (phtv PathHierarchyTokenizerV2) AsPatternTokenizer() (*PatternTokenizer, bool) {
	return nil, false
}

// AsStandardTokenizer is the BasicTokenizer implementation for PathHierarchyTokenizerV2.
func (phtv PathHierarchyTokenizerV2) AsStandardTokenizer() (*StandardTokenizer, bool) {
	return nil, false
}

// AsStandardTokenizerV2 is the BasicTokenizer implementation for PathHierarchyTokenizerV2.
func (phtv PathHierarchyTokenizerV2) AsStandardTokenizerV2() (*StandardTokenizerV2, bool) {
	return nil, false
}

// AsUaxURLEmailTokenizer is the BasicTokenizer implementation for PathHierarchyTokenizerV2.
func (phtv PathHierarchyTokenizerV2) AsUaxURLEmailTokenizer() (*UaxURLEmailTokenizer, bool) {
	return nil, false
}

// AsTokenizer is the BasicTokenizer implementation for PathHierarchyTokenizerV2.
func (phtv PathHierarchyTokenizerV2) AsTokenizer() (*Tokenizer, bool) {
	return nil, false
}

// AsBasicTokenizer is the BasicTokenizer implementation for PathHierarchyTokenizerV2.
func (phtv PathHierarchyTokenizerV2) AsBasicTokenizer() (BasicTokenizer, bool) {
	return &phtv, true
}

// PatternAnalyzer flexibly separates text into terms via a regular expression pattern. This analyzer is implemented
// using Apache Lucene.
type PatternAnalyzer struct {
	// Name - The name of the analyzer. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeAnalyzer', 'OdataTypeMicrosoftAzureSearchCustomAnalyzer', 'OdataTypeMicrosoftAzureSearchPatternAnalyzer', 'OdataTypeMicrosoftAzureSearchStandardAnalyzer', 'OdataTypeMicrosoftAzureSearchStopAnalyzer'
	OdataType OdataType `json:"@odata.type,omitempty"`
	// LowerCaseTerms - A value indicating whether terms should be lower-cased. Default is true.
	LowerCaseTerms *bool `json:"lowercase,omitempty"`
	// Pattern - A regular expression pattern to match token separators. Default is an expression that matches one or more whitespace characters.
	Pattern *string `json:"pattern,omitempty"`
	// Flags - Regular expression flags.
	Flags *RegexFlags `json:"flags,omitempty"`
	// Stopwords - A list of stopwords.
	Stopwords *[]string `json:"stopwords,omitempty"`
}

// MarshalJSON is the custom marshaler for PatternAnalyzer.
func (pa PatternAnalyzer) MarshalJSON() ([]byte, error) {
	pa.OdataType = OdataTypeMicrosoftAzureSearchPatternAnalyzer
	type Alias PatternAnalyzer
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(pa),
	})
}

// AsCustomAnalyzer is the BasicAnalyzer implementation for PatternAnalyzer.
func (pa PatternAnalyzer) AsCustomAnalyzer() (*CustomAnalyzer, bool) {
	return nil, false
}

// AsPatternAnalyzer is the BasicAnalyzer implementation for PatternAnalyzer.
func (pa PatternAnalyzer) AsPatternAnalyzer() (*PatternAnalyzer, bool) {
	return &pa, true
}

// AsStandardAnalyzer is the BasicAnalyzer implementation for PatternAnalyzer.
func (pa PatternAnalyzer) AsStandardAnalyzer() (*StandardAnalyzer, bool) {
	return nil, false
}

// AsStopAnalyzer is the BasicAnalyzer implementation for PatternAnalyzer.
func (pa PatternAnalyzer) AsStopAnalyzer() (*StopAnalyzer, bool) {
	return nil, false
}

// AsAnalyzer is the BasicAnalyzer implementation for PatternAnalyzer.
func (pa PatternAnalyzer) AsAnalyzer() (*Analyzer, bool) {
	return nil, false
}

// AsBasicAnalyzer is the BasicAnalyzer implementation for PatternAnalyzer.
func (pa PatternAnalyzer) AsBasicAnalyzer() (BasicAnalyzer, bool) {
	return &pa, true
}

// PatternCaptureTokenFilter uses Java regexes to emit multiple tokens - one for each capture group in one or more
// patterns. This token filter is implemented using Apache Lucene.
type PatternCaptureTokenFilter struct {
	// Name - The name of the token filter. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeTokenFilter', 'OdataTypeMicrosoftAzureSearchASCIIFoldingTokenFilter', 'OdataTypeMicrosoftAzureSearchCjkBigramTokenFilter', 'OdataTypeMicrosoftAzureSearchCommonGramTokenFilter', 'OdataTypeMicrosoftAzureSearchDictionaryDecompounderTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchElisionTokenFilter', 'OdataTypeMicrosoftAzureSearchKeepTokenFilter', 'OdataTypeMicrosoftAzureSearchKeywordMarkerTokenFilter', 'OdataTypeMicrosoftAzureSearchLengthTokenFilter', 'OdataTypeMicrosoftAzureSearchLimitTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchPatternCaptureTokenFilter', 'OdataTypeMicrosoftAzureSearchPatternReplaceTokenFilter', 'OdataTypeMicrosoftAzureSearchPhoneticTokenFilter', 'OdataTypeMicrosoftAzureSearchShingleTokenFilter', 'OdataTypeMicrosoftAzureSearchSnowballTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerOverrideTokenFilter', 'OdataTypeMicrosoftAzureSearchStopwordsTokenFilter', 'OdataTypeMicrosoftAzureSearchSynonymTokenFilter', 'OdataTypeMicrosoftAzureSearchTruncateTokenFilter', 'OdataTypeMicrosoftAzureSearchUniqueTokenFilter', 'OdataTypeMicrosoftAzureSearchWordDelimiterTokenFilter'
	OdataType OdataTypeBasicTokenFilter `json:"@odata.type,omitempty"`
	// Patterns - A list of patterns to match against each token.
	Patterns *[]string `json:"patterns,omitempty"`
	// PreserveOriginal - A value indicating whether to return the original token even if one of the patterns matches. Default is true.
	PreserveOriginal *bool `json:"preserveOriginal,omitempty"`
}

// MarshalJSON is the custom marshaler for PatternCaptureTokenFilter.
func (pctf PatternCaptureTokenFilter) MarshalJSON() ([]byte, error) {
	pctf.OdataType = OdataTypeMicrosoftAzureSearchPatternCaptureTokenFilter
	type Alias PatternCaptureTokenFilter
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(pctf),
	})
}

// AsASCIIFoldingTokenFilter is the BasicTokenFilter implementation for PatternCaptureTokenFilter.
func (pctf PatternCaptureTokenFilter) AsASCIIFoldingTokenFilter() (*ASCIIFoldingTokenFilter, bool) {
	return nil, false
}

// AsCjkBigramTokenFilter is the BasicTokenFilter implementation for PatternCaptureTokenFilter.
func (pctf PatternCaptureTokenFilter) AsCjkBigramTokenFilter() (*CjkBigramTokenFilter, bool) {
	return nil, false
}

// AsCommonGramTokenFilter is the BasicTokenFilter implementation for PatternCaptureTokenFilter.
func (pctf PatternCaptureTokenFilter) AsCommonGramTokenFilter() (*CommonGramTokenFilter, bool) {
	return nil, false
}

// AsDictionaryDecompounderTokenFilter is the BasicTokenFilter implementation for PatternCaptureTokenFilter.
func (pctf PatternCaptureTokenFilter) AsDictionaryDecompounderTokenFilter() (*DictionaryDecompounderTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilter is the BasicTokenFilter implementation for PatternCaptureTokenFilter.
func (pctf PatternCaptureTokenFilter) AsEdgeNGramTokenFilter() (*EdgeNGramTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilterV2 is the BasicTokenFilter implementation for PatternCaptureTokenFilter.
func (pctf PatternCaptureTokenFilter) AsEdgeNGramTokenFilterV2() (*EdgeNGramTokenFilterV2, bool) {
	return nil, false
}

// AsElisionTokenFilter is the BasicTokenFilter implementation for PatternCaptureTokenFilter.
func (pctf PatternCaptureTokenFilter) AsElisionTokenFilter() (*ElisionTokenFilter, bool) {
	return nil, false
}

// AsKeepTokenFilter is the BasicTokenFilter implementation for PatternCaptureTokenFilter.
func (pctf PatternCaptureTokenFilter) AsKeepTokenFilter() (*KeepTokenFilter, bool) {
	return nil, false
}

// AsKeywordMarkerTokenFilter is the BasicTokenFilter implementation for PatternCaptureTokenFilter.
func (pctf PatternCaptureTokenFilter) AsKeywordMarkerTokenFilter() (*KeywordMarkerTokenFilter, bool) {
	return nil, false
}

// AsLengthTokenFilter is the BasicTokenFilter implementation for PatternCaptureTokenFilter.
func (pctf PatternCaptureTokenFilter) AsLengthTokenFilter() (*LengthTokenFilter, bool) {
	return nil, false
}

// AsLimitTokenFilter is the BasicTokenFilter implementation for PatternCaptureTokenFilter.
func (pctf PatternCaptureTokenFilter) AsLimitTokenFilter() (*LimitTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilter is the BasicTokenFilter implementation for PatternCaptureTokenFilter.
func (pctf PatternCaptureTokenFilter) AsNGramTokenFilter() (*NGramTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilterV2 is the BasicTokenFilter implementation for PatternCaptureTokenFilter.
func (pctf PatternCaptureTokenFilter) AsNGramTokenFilterV2() (*NGramTokenFilterV2, bool) {
	return nil, false
}

// AsPatternCaptureTokenFilter is the BasicTokenFilter implementation for PatternCaptureTokenFilter.
func (pctf PatternCaptureTokenFilter) AsPatternCaptureTokenFilter() (*PatternCaptureTokenFilter, bool) {
	return &pctf, true
}

// AsPatternReplaceTokenFilter is the BasicTokenFilter implementation for PatternCaptureTokenFilter.
func (pctf PatternCaptureTokenFilter) AsPatternReplaceTokenFilter() (*PatternReplaceTokenFilter, bool) {
	return nil, false
}

// AsPhoneticTokenFilter is the BasicTokenFilter implementation for PatternCaptureTokenFilter.
func (pctf PatternCaptureTokenFilter) AsPhoneticTokenFilter() (*PhoneticTokenFilter, bool) {
	return nil, false
}

// AsShingleTokenFilter is the BasicTokenFilter implementation for PatternCaptureTokenFilter.
func (pctf PatternCaptureTokenFilter) AsShingleTokenFilter() (*ShingleTokenFilter, bool) {
	return nil, false
}

// AsSnowballTokenFilter is the BasicTokenFilter implementation for PatternCaptureTokenFilter.
func (pctf PatternCaptureTokenFilter) AsSnowballTokenFilter() (*SnowballTokenFilter, bool) {
	return nil, false
}

// AsStemmerTokenFilter is the BasicTokenFilter implementation for PatternCaptureTokenFilter.
func (pctf PatternCaptureTokenFilter) AsStemmerTokenFilter() (*StemmerTokenFilter, bool) {
	return nil, false
}

// AsStemmerOverrideTokenFilter is the BasicTokenFilter implementation for PatternCaptureTokenFilter.
func (pctf PatternCaptureTokenFilter) AsStemmerOverrideTokenFilter() (*StemmerOverrideTokenFilter, bool) {
	return nil, false
}

// AsStopwordsTokenFilter is the BasicTokenFilter implementation for PatternCaptureTokenFilter.
func (pctf PatternCaptureTokenFilter) AsStopwordsTokenFilter() (*StopwordsTokenFilter, bool) {
	return nil, false
}

// AsSynonymTokenFilter is the BasicTokenFilter implementation for PatternCaptureTokenFilter.
func (pctf PatternCaptureTokenFilter) AsSynonymTokenFilter() (*SynonymTokenFilter, bool) {
	return nil, false
}

// AsTruncateTokenFilter is the BasicTokenFilter implementation for PatternCaptureTokenFilter.
func (pctf PatternCaptureTokenFilter) AsTruncateTokenFilter() (*TruncateTokenFilter, bool) {
	return nil, false
}

// AsUniqueTokenFilter is the BasicTokenFilter implementation for PatternCaptureTokenFilter.
func (pctf PatternCaptureTokenFilter) AsUniqueTokenFilter() (*UniqueTokenFilter, bool) {
	return nil, false
}

// AsWordDelimiterTokenFilter is the BasicTokenFilter implementation for PatternCaptureTokenFilter.
func (pctf PatternCaptureTokenFilter) AsWordDelimiterTokenFilter() (*WordDelimiterTokenFilter, bool) {
	return nil, false
}

// AsTokenFilter is the BasicTokenFilter implementation for PatternCaptureTokenFilter.
func (pctf PatternCaptureTokenFilter) AsTokenFilter() (*TokenFilter, bool) {
	return nil, false
}

// AsBasicTokenFilter is the BasicTokenFilter implementation for PatternCaptureTokenFilter.
func (pctf PatternCaptureTokenFilter) AsBasicTokenFilter() (BasicTokenFilter, bool) {
	return &pctf, true
}

// PatternReplaceCharFilter a character filter that replaces characters in the input string. It uses a regular
// expression to identify character sequences to preserve and a replacement pattern to identify characters to replace.
// For example, given the input text "aa bb aa bb", pattern "(aa)\s+(bb)", and replacement "$1#$2", the result would be
// "aa#bb aa#bb". This character filter is implemented using Apache Lucene.
type PatternReplaceCharFilter struct {
	// Name - The name of the char filter. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeCharFilter', 'OdataTypeMicrosoftAzureSearchMappingCharFilter', 'OdataTypeMicrosoftAzureSearchPatternReplaceCharFilter'
	OdataType OdataTypeBasicCharFilter `json:"@odata.type,omitempty"`
	// Pattern - A regular expression pattern.
	Pattern *string `json:"pattern,omitempty"`
	// Replacement - The replacement text.
	Replacement *string `json:"replacement,omitempty"`
}

// MarshalJSON is the custom marshaler for PatternReplaceCharFilter.
func (prcf PatternReplaceCharFilter) MarshalJSON() ([]byte, error) {
	prcf.OdataType = OdataTypeMicrosoftAzureSearchPatternReplaceCharFilter
	type Alias PatternReplaceCharFilter
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(prcf),
	})
}

// AsMappingCharFilter is the BasicCharFilter implementation for PatternReplaceCharFilter.
func (prcf PatternReplaceCharFilter) AsMappingCharFilter() (*MappingCharFilter, bool) {
	return nil, false
}

// AsPatternReplaceCharFilter is the BasicCharFilter implementation for PatternReplaceCharFilter.
func (prcf PatternReplaceCharFilter) AsPatternReplaceCharFilter() (*PatternReplaceCharFilter, bool) {
	return &prcf, true
}

// AsCharFilter is the BasicCharFilter implementation for PatternReplaceCharFilter.
func (prcf PatternReplaceCharFilter) AsCharFilter() (*CharFilter, bool) {
	return nil, false
}

// AsBasicCharFilter is the BasicCharFilter implementation for PatternReplaceCharFilter.
func (prcf PatternReplaceCharFilter) AsBasicCharFilter() (BasicCharFilter, bool) {
	return &prcf, true
}

// PatternReplaceTokenFilter a character filter that replaces characters in the input string. It uses a regular
// expression to identify character sequences to preserve and a replacement pattern to identify characters to replace.
// For example, given the input text "aa bb aa bb", pattern "(aa)\s+(bb)", and replacement "$1#$2", the result would be
// "aa#bb aa#bb". This token filter is implemented using Apache Lucene.
type PatternReplaceTokenFilter struct {
	// Name - The name of the token filter. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeTokenFilter', 'OdataTypeMicrosoftAzureSearchASCIIFoldingTokenFilter', 'OdataTypeMicrosoftAzureSearchCjkBigramTokenFilter', 'OdataTypeMicrosoftAzureSearchCommonGramTokenFilter', 'OdataTypeMicrosoftAzureSearchDictionaryDecompounderTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchElisionTokenFilter', 'OdataTypeMicrosoftAzureSearchKeepTokenFilter', 'OdataTypeMicrosoftAzureSearchKeywordMarkerTokenFilter', 'OdataTypeMicrosoftAzureSearchLengthTokenFilter', 'OdataTypeMicrosoftAzureSearchLimitTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchPatternCaptureTokenFilter', 'OdataTypeMicrosoftAzureSearchPatternReplaceTokenFilter', 'OdataTypeMicrosoftAzureSearchPhoneticTokenFilter', 'OdataTypeMicrosoftAzureSearchShingleTokenFilter', 'OdataTypeMicrosoftAzureSearchSnowballTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerOverrideTokenFilter', 'OdataTypeMicrosoftAzureSearchStopwordsTokenFilter', 'OdataTypeMicrosoftAzureSearchSynonymTokenFilter', 'OdataTypeMicrosoftAzureSearchTruncateTokenFilter', 'OdataTypeMicrosoftAzureSearchUniqueTokenFilter', 'OdataTypeMicrosoftAzureSearchWordDelimiterTokenFilter'
	OdataType OdataTypeBasicTokenFilter `json:"@odata.type,omitempty"`
	// Pattern - A regular expression pattern.
	Pattern *string `json:"pattern,omitempty"`
	// Replacement - The replacement text.
	Replacement *string `json:"replacement,omitempty"`
}

// MarshalJSON is the custom marshaler for PatternReplaceTokenFilter.
func (prtf PatternReplaceTokenFilter) MarshalJSON() ([]byte, error) {
	prtf.OdataType = OdataTypeMicrosoftAzureSearchPatternReplaceTokenFilter
	type Alias PatternReplaceTokenFilter
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(prtf),
	})
}

// AsASCIIFoldingTokenFilter is the BasicTokenFilter implementation for PatternReplaceTokenFilter.
func (prtf PatternReplaceTokenFilter) AsASCIIFoldingTokenFilter() (*ASCIIFoldingTokenFilter, bool) {
	return nil, false
}

// AsCjkBigramTokenFilter is the BasicTokenFilter implementation for PatternReplaceTokenFilter.
func (prtf PatternReplaceTokenFilter) AsCjkBigramTokenFilter() (*CjkBigramTokenFilter, bool) {
	return nil, false
}

// AsCommonGramTokenFilter is the BasicTokenFilter implementation for PatternReplaceTokenFilter.
func (prtf PatternReplaceTokenFilter) AsCommonGramTokenFilter() (*CommonGramTokenFilter, bool) {
	return nil, false
}

// AsDictionaryDecompounderTokenFilter is the BasicTokenFilter implementation for PatternReplaceTokenFilter.
func (prtf PatternReplaceTokenFilter) AsDictionaryDecompounderTokenFilter() (*DictionaryDecompounderTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilter is the BasicTokenFilter implementation for PatternReplaceTokenFilter.
func (prtf PatternReplaceTokenFilter) AsEdgeNGramTokenFilter() (*EdgeNGramTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilterV2 is the BasicTokenFilter implementation for PatternReplaceTokenFilter.
func (prtf PatternReplaceTokenFilter) AsEdgeNGramTokenFilterV2() (*EdgeNGramTokenFilterV2, bool) {
	return nil, false
}

// AsElisionTokenFilter is the BasicTokenFilter implementation for PatternReplaceTokenFilter.
func (prtf PatternReplaceTokenFilter) AsElisionTokenFilter() (*ElisionTokenFilter, bool) {
	return nil, false
}

// AsKeepTokenFilter is the BasicTokenFilter implementation for PatternReplaceTokenFilter.
func (prtf PatternReplaceTokenFilter) AsKeepTokenFilter() (*KeepTokenFilter, bool) {
	return nil, false
}

// AsKeywordMarkerTokenFilter is the BasicTokenFilter implementation for PatternReplaceTokenFilter.
func (prtf PatternReplaceTokenFilter) AsKeywordMarkerTokenFilter() (*KeywordMarkerTokenFilter, bool) {
	return nil, false
}

// AsLengthTokenFilter is the BasicTokenFilter implementation for PatternReplaceTokenFilter.
func (prtf PatternReplaceTokenFilter) AsLengthTokenFilter() (*LengthTokenFilter, bool) {
	return nil, false
}

// AsLimitTokenFilter is the BasicTokenFilter implementation for PatternReplaceTokenFilter.
func (prtf PatternReplaceTokenFilter) AsLimitTokenFilter() (*LimitTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilter is the BasicTokenFilter implementation for PatternReplaceTokenFilter.
func (prtf PatternReplaceTokenFilter) AsNGramTokenFilter() (*NGramTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilterV2 is the BasicTokenFilter implementation for PatternReplaceTokenFilter.
func (prtf PatternReplaceTokenFilter) AsNGramTokenFilterV2() (*NGramTokenFilterV2, bool) {
	return nil, false
}

// AsPatternCaptureTokenFilter is the BasicTokenFilter implementation for PatternReplaceTokenFilter.
func (prtf PatternReplaceTokenFilter) AsPatternCaptureTokenFilter() (*PatternCaptureTokenFilter, bool) {
	return nil, false
}

// AsPatternReplaceTokenFilter is the BasicTokenFilter implementation for PatternReplaceTokenFilter.
func (prtf PatternReplaceTokenFilter) AsPatternReplaceTokenFilter() (*PatternReplaceTokenFilter, bool) {
	return &prtf, true
}

// AsPhoneticTokenFilter is the BasicTokenFilter implementation for PatternReplaceTokenFilter.
func (prtf PatternReplaceTokenFilter) AsPhoneticTokenFilter() (*PhoneticTokenFilter, bool) {
	return nil, false
}

// AsShingleTokenFilter is the BasicTokenFilter implementation for PatternReplaceTokenFilter.
func (prtf PatternReplaceTokenFilter) AsShingleTokenFilter() (*ShingleTokenFilter, bool) {
	return nil, false
}

// AsSnowballTokenFilter is the BasicTokenFilter implementation for PatternReplaceTokenFilter.
func (prtf PatternReplaceTokenFilter) AsSnowballTokenFilter() (*SnowballTokenFilter, bool) {
	return nil, false
}

// AsStemmerTokenFilter is the BasicTokenFilter implementation for PatternReplaceTokenFilter.
func (prtf PatternReplaceTokenFilter) AsStemmerTokenFilter() (*StemmerTokenFilter, bool) {
	return nil, false
}

// AsStemmerOverrideTokenFilter is the BasicTokenFilter implementation for PatternReplaceTokenFilter.
func (prtf PatternReplaceTokenFilter) AsStemmerOverrideTokenFilter() (*StemmerOverrideTokenFilter, bool) {
	return nil, false
}

// AsStopwordsTokenFilter is the BasicTokenFilter implementation for PatternReplaceTokenFilter.
func (prtf PatternReplaceTokenFilter) AsStopwordsTokenFilter() (*StopwordsTokenFilter, bool) {
	return nil, false
}

// AsSynonymTokenFilter is the BasicTokenFilter implementation for PatternReplaceTokenFilter.
func (prtf PatternReplaceTokenFilter) AsSynonymTokenFilter() (*SynonymTokenFilter, bool) {
	return nil, false
}

// AsTruncateTokenFilter is the BasicTokenFilter implementation for PatternReplaceTokenFilter.
func (prtf PatternReplaceTokenFilter) AsTruncateTokenFilter() (*TruncateTokenFilter, bool) {
	return nil, false
}

// AsUniqueTokenFilter is the BasicTokenFilter implementation for PatternReplaceTokenFilter.
func (prtf PatternReplaceTokenFilter) AsUniqueTokenFilter() (*UniqueTokenFilter, bool) {
	return nil, false
}

// AsWordDelimiterTokenFilter is the BasicTokenFilter implementation for PatternReplaceTokenFilter.
func (prtf PatternReplaceTokenFilter) AsWordDelimiterTokenFilter() (*WordDelimiterTokenFilter, bool) {
	return nil, false
}

// AsTokenFilter is the BasicTokenFilter implementation for PatternReplaceTokenFilter.
func (prtf PatternReplaceTokenFilter) AsTokenFilter() (*TokenFilter, bool) {
	return nil, false
}

// AsBasicTokenFilter is the BasicTokenFilter implementation for PatternReplaceTokenFilter.
func (prtf PatternReplaceTokenFilter) AsBasicTokenFilter() (BasicTokenFilter, bool) {
	return &prtf, true
}

// PatternTokenizer tokenizer that uses regex pattern matching to construct distinct tokens. This tokenizer is
// implemented using Apache Lucene.
type PatternTokenizer struct {
	// Name - The name of the tokenizer. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeTokenizer', 'OdataTypeMicrosoftAzureSearchClassicTokenizer', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenizer', 'OdataTypeMicrosoftAzureSearchKeywordTokenizer', 'OdataTypeMicrosoftAzureSearchKeywordTokenizerV2', 'OdataTypeMicrosoftAzureSearchMicrosoftLanguageTokenizer', 'OdataTypeMicrosoftAzureSearchMicrosoftLanguageStemmingTokenizer', 'OdataTypeMicrosoftAzureSearchNGramTokenizer', 'OdataTypeMicrosoftAzureSearchPathHierarchyTokenizer', 'OdataTypeMicrosoftAzureSearchPathHierarchyTokenizerV2', 'OdataTypeMicrosoftAzureSearchPatternTokenizer', 'OdataTypeMicrosoftAzureSearchStandardTokenizer', 'OdataTypeMicrosoftAzureSearchStandardTokenizerV2', 'OdataTypeMicrosoftAzureSearchUaxURLEmailTokenizer'
	OdataType OdataTypeBasicTokenizer `json:"@odata.type,omitempty"`
	// Pattern - A regular expression pattern to match token separators. Default is an expression that matches one or more whitespace characters.
	Pattern *string `json:"pattern,omitempty"`
	// Flags - Regular expression flags.
	Flags *RegexFlags `json:"flags,omitempty"`
	// Group - The zero-based ordinal of the matching group in the regular expression pattern to extract into tokens. Use -1 if you want to use the entire pattern to split the input into tokens, irrespective of matching groups. Default is -1.
	Group *int32 `json:"group,omitempty"`
}

// MarshalJSON is the custom marshaler for PatternTokenizer.
func (pt PatternTokenizer) MarshalJSON() ([]byte, error) {
	pt.OdataType = OdataTypeMicrosoftAzureSearchPatternTokenizer
	type Alias PatternTokenizer
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(pt),
	})
}

// AsClassicTokenizer is the BasicTokenizer implementation for PatternTokenizer.
func (pt PatternTokenizer) AsClassicTokenizer() (*ClassicTokenizer, bool) {
	return nil, false
}

// AsEdgeNGramTokenizer is the BasicTokenizer implementation for PatternTokenizer.
func (pt PatternTokenizer) AsEdgeNGramTokenizer() (*EdgeNGramTokenizer, bool) {
	return nil, false
}

// AsKeywordTokenizer is the BasicTokenizer implementation for PatternTokenizer.
func (pt PatternTokenizer) AsKeywordTokenizer() (*KeywordTokenizer, bool) {
	return nil, false
}

// AsKeywordTokenizerV2 is the BasicTokenizer implementation for PatternTokenizer.
func (pt PatternTokenizer) AsKeywordTokenizerV2() (*KeywordTokenizerV2, bool) {
	return nil, false
}

// AsMicrosoftLanguageTokenizer is the BasicTokenizer implementation for PatternTokenizer.
func (pt PatternTokenizer) AsMicrosoftLanguageTokenizer() (*MicrosoftLanguageTokenizer, bool) {
	return nil, false
}

// AsMicrosoftLanguageStemmingTokenizer is the BasicTokenizer implementation for PatternTokenizer.
func (pt PatternTokenizer) AsMicrosoftLanguageStemmingTokenizer() (*MicrosoftLanguageStemmingTokenizer, bool) {
	return nil, false
}

// AsNGramTokenizer is the BasicTokenizer implementation for PatternTokenizer.
func (pt PatternTokenizer) AsNGramTokenizer() (*NGramTokenizer, bool) {
	return nil, false
}

// AsPathHierarchyTokenizer is the BasicTokenizer implementation for PatternTokenizer.
func (pt PatternTokenizer) AsPathHierarchyTokenizer() (*PathHierarchyTokenizer, bool) {
	return nil, false
}

// AsPathHierarchyTokenizerV2 is the BasicTokenizer implementation for PatternTokenizer.
func (pt PatternTokenizer) AsPathHierarchyTokenizerV2() (*PathHierarchyTokenizerV2, bool) {
	return nil, false
}

// AsPatternTokenizer is the BasicTokenizer implementation for PatternTokenizer.
func (pt PatternTokenizer) AsPatternTokenizer() (*PatternTokenizer, bool) {
	return &pt, true
}

// AsStandardTokenizer is the BasicTokenizer implementation for PatternTokenizer.
func (pt PatternTokenizer) AsStandardTokenizer() (*StandardTokenizer, bool) {
	return nil, false
}

// AsStandardTokenizerV2 is the BasicTokenizer implementation for PatternTokenizer.
func (pt PatternTokenizer) AsStandardTokenizerV2() (*StandardTokenizerV2, bool) {
	return nil, false
}

// AsUaxURLEmailTokenizer is the BasicTokenizer implementation for PatternTokenizer.
func (pt PatternTokenizer) AsUaxURLEmailTokenizer() (*UaxURLEmailTokenizer, bool) {
	return nil, false
}

// AsTokenizer is the BasicTokenizer implementation for PatternTokenizer.
func (pt PatternTokenizer) AsTokenizer() (*Tokenizer, bool) {
	return nil, false
}

// AsBasicTokenizer is the BasicTokenizer implementation for PatternTokenizer.
func (pt PatternTokenizer) AsBasicTokenizer() (BasicTokenizer, bool) {
	return &pt, true
}

// PhoneticTokenFilter create tokens for phonetic matches. This token filter is implemented using Apache Lucene.
type PhoneticTokenFilter struct {
	// Name - The name of the token filter. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeTokenFilter', 'OdataTypeMicrosoftAzureSearchASCIIFoldingTokenFilter', 'OdataTypeMicrosoftAzureSearchCjkBigramTokenFilter', 'OdataTypeMicrosoftAzureSearchCommonGramTokenFilter', 'OdataTypeMicrosoftAzureSearchDictionaryDecompounderTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchElisionTokenFilter', 'OdataTypeMicrosoftAzureSearchKeepTokenFilter', 'OdataTypeMicrosoftAzureSearchKeywordMarkerTokenFilter', 'OdataTypeMicrosoftAzureSearchLengthTokenFilter', 'OdataTypeMicrosoftAzureSearchLimitTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchPatternCaptureTokenFilter', 'OdataTypeMicrosoftAzureSearchPatternReplaceTokenFilter', 'OdataTypeMicrosoftAzureSearchPhoneticTokenFilter', 'OdataTypeMicrosoftAzureSearchShingleTokenFilter', 'OdataTypeMicrosoftAzureSearchSnowballTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerOverrideTokenFilter', 'OdataTypeMicrosoftAzureSearchStopwordsTokenFilter', 'OdataTypeMicrosoftAzureSearchSynonymTokenFilter', 'OdataTypeMicrosoftAzureSearchTruncateTokenFilter', 'OdataTypeMicrosoftAzureSearchUniqueTokenFilter', 'OdataTypeMicrosoftAzureSearchWordDelimiterTokenFilter'
	OdataType OdataTypeBasicTokenFilter `json:"@odata.type,omitempty"`
	// Encoder - The phonetic encoder to use. Default is "metaphone". Possible values include: 'Metaphone', 'DoubleMetaphone', 'Soundex', 'RefinedSoundex', 'Caverphone1', 'Caverphone2', 'Cologne', 'Nysiis', 'KoelnerPhonetik', 'HaasePhonetik', 'BeiderMorse'
	Encoder PhoneticEncoder `json:"encoder,omitempty"`
	// ReplaceOriginalTokens - A value indicating whether encoded tokens should replace original tokens. If false, encoded tokens are added as synonyms. Default is true.
	ReplaceOriginalTokens *bool `json:"replace,omitempty"`
}

// MarshalJSON is the custom marshaler for PhoneticTokenFilter.
func (ptf PhoneticTokenFilter) MarshalJSON() ([]byte, error) {
	ptf.OdataType = OdataTypeMicrosoftAzureSearchPhoneticTokenFilter
	type Alias PhoneticTokenFilter
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ptf),
	})
}

// AsASCIIFoldingTokenFilter is the BasicTokenFilter implementation for PhoneticTokenFilter.
func (ptf PhoneticTokenFilter) AsASCIIFoldingTokenFilter() (*ASCIIFoldingTokenFilter, bool) {
	return nil, false
}

// AsCjkBigramTokenFilter is the BasicTokenFilter implementation for PhoneticTokenFilter.
func (ptf PhoneticTokenFilter) AsCjkBigramTokenFilter() (*CjkBigramTokenFilter, bool) {
	return nil, false
}

// AsCommonGramTokenFilter is the BasicTokenFilter implementation for PhoneticTokenFilter.
func (ptf PhoneticTokenFilter) AsCommonGramTokenFilter() (*CommonGramTokenFilter, bool) {
	return nil, false
}

// AsDictionaryDecompounderTokenFilter is the BasicTokenFilter implementation for PhoneticTokenFilter.
func (ptf PhoneticTokenFilter) AsDictionaryDecompounderTokenFilter() (*DictionaryDecompounderTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilter is the BasicTokenFilter implementation for PhoneticTokenFilter.
func (ptf PhoneticTokenFilter) AsEdgeNGramTokenFilter() (*EdgeNGramTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilterV2 is the BasicTokenFilter implementation for PhoneticTokenFilter.
func (ptf PhoneticTokenFilter) AsEdgeNGramTokenFilterV2() (*EdgeNGramTokenFilterV2, bool) {
	return nil, false
}

// AsElisionTokenFilter is the BasicTokenFilter implementation for PhoneticTokenFilter.
func (ptf PhoneticTokenFilter) AsElisionTokenFilter() (*ElisionTokenFilter, bool) {
	return nil, false
}

// AsKeepTokenFilter is the BasicTokenFilter implementation for PhoneticTokenFilter.
func (ptf PhoneticTokenFilter) AsKeepTokenFilter() (*KeepTokenFilter, bool) {
	return nil, false
}

// AsKeywordMarkerTokenFilter is the BasicTokenFilter implementation for PhoneticTokenFilter.
func (ptf PhoneticTokenFilter) AsKeywordMarkerTokenFilter() (*KeywordMarkerTokenFilter, bool) {
	return nil, false
}

// AsLengthTokenFilter is the BasicTokenFilter implementation for PhoneticTokenFilter.
func (ptf PhoneticTokenFilter) AsLengthTokenFilter() (*LengthTokenFilter, bool) {
	return nil, false
}

// AsLimitTokenFilter is the BasicTokenFilter implementation for PhoneticTokenFilter.
func (ptf PhoneticTokenFilter) AsLimitTokenFilter() (*LimitTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilter is the BasicTokenFilter implementation for PhoneticTokenFilter.
func (ptf PhoneticTokenFilter) AsNGramTokenFilter() (*NGramTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilterV2 is the BasicTokenFilter implementation for PhoneticTokenFilter.
func (ptf PhoneticTokenFilter) AsNGramTokenFilterV2() (*NGramTokenFilterV2, bool) {
	return nil, false
}

// AsPatternCaptureTokenFilter is the BasicTokenFilter implementation for PhoneticTokenFilter.
func (ptf PhoneticTokenFilter) AsPatternCaptureTokenFilter() (*PatternCaptureTokenFilter, bool) {
	return nil, false
}

// AsPatternReplaceTokenFilter is the BasicTokenFilter implementation for PhoneticTokenFilter.
func (ptf PhoneticTokenFilter) AsPatternReplaceTokenFilter() (*PatternReplaceTokenFilter, bool) {
	return nil, false
}

// AsPhoneticTokenFilter is the BasicTokenFilter implementation for PhoneticTokenFilter.
func (ptf PhoneticTokenFilter) AsPhoneticTokenFilter() (*PhoneticTokenFilter, bool) {
	return &ptf, true
}

// AsShingleTokenFilter is the BasicTokenFilter implementation for PhoneticTokenFilter.
func (ptf PhoneticTokenFilter) AsShingleTokenFilter() (*ShingleTokenFilter, bool) {
	return nil, false
}

// AsSnowballTokenFilter is the BasicTokenFilter implementation for PhoneticTokenFilter.
func (ptf PhoneticTokenFilter) AsSnowballTokenFilter() (*SnowballTokenFilter, bool) {
	return nil, false
}

// AsStemmerTokenFilter is the BasicTokenFilter implementation for PhoneticTokenFilter.
func (ptf PhoneticTokenFilter) AsStemmerTokenFilter() (*StemmerTokenFilter, bool) {
	return nil, false
}

// AsStemmerOverrideTokenFilter is the BasicTokenFilter implementation for PhoneticTokenFilter.
func (ptf PhoneticTokenFilter) AsStemmerOverrideTokenFilter() (*StemmerOverrideTokenFilter, bool) {
	return nil, false
}

// AsStopwordsTokenFilter is the BasicTokenFilter implementation for PhoneticTokenFilter.
func (ptf PhoneticTokenFilter) AsStopwordsTokenFilter() (*StopwordsTokenFilter, bool) {
	return nil, false
}

// AsSynonymTokenFilter is the BasicTokenFilter implementation for PhoneticTokenFilter.
func (ptf PhoneticTokenFilter) AsSynonymTokenFilter() (*SynonymTokenFilter, bool) {
	return nil, false
}

// AsTruncateTokenFilter is the BasicTokenFilter implementation for PhoneticTokenFilter.
func (ptf PhoneticTokenFilter) AsTruncateTokenFilter() (*TruncateTokenFilter, bool) {
	return nil, false
}

// AsUniqueTokenFilter is the BasicTokenFilter implementation for PhoneticTokenFilter.
func (ptf PhoneticTokenFilter) AsUniqueTokenFilter() (*UniqueTokenFilter, bool) {
	return nil, false
}

// AsWordDelimiterTokenFilter is the BasicTokenFilter implementation for PhoneticTokenFilter.
func (ptf PhoneticTokenFilter) AsWordDelimiterTokenFilter() (*WordDelimiterTokenFilter, bool) {
	return nil, false
}

// AsTokenFilter is the BasicTokenFilter implementation for PhoneticTokenFilter.
func (ptf PhoneticTokenFilter) AsTokenFilter() (*TokenFilter, bool) {
	return nil, false
}

// AsBasicTokenFilter is the BasicTokenFilter implementation for PhoneticTokenFilter.
func (ptf PhoneticTokenFilter) AsBasicTokenFilter() (BasicTokenFilter, bool) {
	return &ptf, true
}

// RegexFlags defines flags that can be combined to control how regular expressions are used in the pattern analyzer
// and pattern tokenizer.
type RegexFlags struct {
	Name *string `json:"name,omitempty"`
}

// BasicScoringFunction abstract base class for functions that can modify document scores during ranking.
type BasicScoringFunction interface {
	AsDistanceScoringFunction() (*DistanceScoringFunction, bool)
	AsFreshnessScoringFunction() (*FreshnessScoringFunction, bool)
	AsMagnitudeScoringFunction() (*MagnitudeScoringFunction, bool)
	AsTagScoringFunction() (*TagScoringFunction, bool)
	AsScoringFunction() (*ScoringFunction, bool)
}

// ScoringFunction abstract base class for functions that can modify document scores during ranking.
type ScoringFunction struct {
	// FieldName - The name of the field used as input to the scoring function.
	FieldName *string `json:"fieldName,omitempty"`
	// Boost - A multiplier for the raw score. Must be a positive number not equal to 1.0.
	Boost *float64 `json:"boost,omitempty"`
	// Interpolation - A value indicating how boosting will be interpolated across document scores; defaults to "Linear". Possible values include: 'Linear', 'Constant', 'Quadratic', 'Logarithmic'
	Interpolation ScoringFunctionInterpolation `json:"interpolation,omitempty"`
	// Type - Possible values include: 'TypeScoringFunction', 'TypeDistance', 'TypeFreshness', 'TypeMagnitude', 'TypeTag'
	Type Type `json:"type,omitempty"`
}

func unmarshalBasicScoringFunction(body []byte) (BasicScoringFunction, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeDistance):
		var dsf DistanceScoringFunction
		err := json.Unmarshal(body, &dsf)
		return dsf, err
	case string(TypeFreshness):
		var fsf FreshnessScoringFunction
		err := json.Unmarshal(body, &fsf)
		return fsf, err
	case string(TypeMagnitude):
		var msf MagnitudeScoringFunction
		err := json.Unmarshal(body, &msf)
		return msf, err
	case string(TypeTag):
		var tsf TagScoringFunction
		err := json.Unmarshal(body, &tsf)
		return tsf, err
	default:
		var sf ScoringFunction
		err := json.Unmarshal(body, &sf)
		return sf, err
	}
}
func unmarshalBasicScoringFunctionArray(body []byte) ([]BasicScoringFunction, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	sfArray := make([]BasicScoringFunction, len(rawMessages))

	for index, rawMessage := range rawMessages {
		sf, err := unmarshalBasicScoringFunction(*rawMessage)
		if err != nil {
			return nil, err
		}
		sfArray[index] = sf
	}
	return sfArray, nil
}

// MarshalJSON is the custom marshaler for ScoringFunction.
func (sf ScoringFunction) MarshalJSON() ([]byte, error) {
	sf.Type = TypeScoringFunction
	type Alias ScoringFunction
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(sf),
	})
}

// AsDistanceScoringFunction is the BasicScoringFunction implementation for ScoringFunction.
func (sf ScoringFunction) AsDistanceScoringFunction() (*DistanceScoringFunction, bool) {
	return nil, false
}

// AsFreshnessScoringFunction is the BasicScoringFunction implementation for ScoringFunction.
func (sf ScoringFunction) AsFreshnessScoringFunction() (*FreshnessScoringFunction, bool) {
	return nil, false
}

// AsMagnitudeScoringFunction is the BasicScoringFunction implementation for ScoringFunction.
func (sf ScoringFunction) AsMagnitudeScoringFunction() (*MagnitudeScoringFunction, bool) {
	return nil, false
}

// AsTagScoringFunction is the BasicScoringFunction implementation for ScoringFunction.
func (sf ScoringFunction) AsTagScoringFunction() (*TagScoringFunction, bool) {
	return nil, false
}

// AsScoringFunction is the BasicScoringFunction implementation for ScoringFunction.
func (sf ScoringFunction) AsScoringFunction() (*ScoringFunction, bool) {
	return &sf, true
}

// AsBasicScoringFunction is the BasicScoringFunction implementation for ScoringFunction.
func (sf ScoringFunction) AsBasicScoringFunction() (BasicScoringFunction, bool) {
	return &sf, true
}

// ScoringProfile defines parameters for an Azure Search index that influence scoring in search queries.
type ScoringProfile struct {
	// Name - The name of the scoring profile.
	Name *string `json:"name,omitempty"`
	// TextWeights - Parameters that boost scoring based on text matches in certain index fields.
	TextWeights *TextWeights `json:"text,omitempty"`
	// Functions - The collection of functions that influence the scoring of documents.
	Functions *[]BasicScoringFunction `json:"functions,omitempty"`
	// FunctionAggregation - A value indicating how the results of individual scoring functions should be combined. Defaults to "Sum". Ignored if there are no scoring functions. Possible values include: 'Sum', 'Average', 'Minimum', 'Maximum', 'FirstMatching'
	FunctionAggregation ScoringFunctionAggregation `json:"functionAggregation,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ScoringProfile struct.
func (sp *ScoringProfile) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		sp.Name = &name
	}

	v = m["text"]
	if v != nil {
		var textVar TextWeights
		err = json.Unmarshal(*m["text"], &textVar)
		if err != nil {
			return err
		}
		sp.TextWeights = &textVar
	}

	v = m["functions"]
	if v != nil {
		functions, err := unmarshalBasicScoringFunctionArray(*m["functions"])
		if err != nil {
			return err
		}
		sp.Functions = &functions
	}

	v = m["functionAggregation"]
	if v != nil {
		var functionAggregation ScoringFunctionAggregation
		err = json.Unmarshal(*m["functionAggregation"], &functionAggregation)
		if err != nil {
			return err
		}
		sp.FunctionAggregation = functionAggregation
	}

	return nil
}

// ShingleTokenFilter creates combinations of tokens as a single token. This token filter is implemented using Apache
// Lucene.
type ShingleTokenFilter struct {
	// Name - The name of the token filter. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeTokenFilter', 'OdataTypeMicrosoftAzureSearchASCIIFoldingTokenFilter', 'OdataTypeMicrosoftAzureSearchCjkBigramTokenFilter', 'OdataTypeMicrosoftAzureSearchCommonGramTokenFilter', 'OdataTypeMicrosoftAzureSearchDictionaryDecompounderTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchElisionTokenFilter', 'OdataTypeMicrosoftAzureSearchKeepTokenFilter', 'OdataTypeMicrosoftAzureSearchKeywordMarkerTokenFilter', 'OdataTypeMicrosoftAzureSearchLengthTokenFilter', 'OdataTypeMicrosoftAzureSearchLimitTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchPatternCaptureTokenFilter', 'OdataTypeMicrosoftAzureSearchPatternReplaceTokenFilter', 'OdataTypeMicrosoftAzureSearchPhoneticTokenFilter', 'OdataTypeMicrosoftAzureSearchShingleTokenFilter', 'OdataTypeMicrosoftAzureSearchSnowballTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerOverrideTokenFilter', 'OdataTypeMicrosoftAzureSearchStopwordsTokenFilter', 'OdataTypeMicrosoftAzureSearchSynonymTokenFilter', 'OdataTypeMicrosoftAzureSearchTruncateTokenFilter', 'OdataTypeMicrosoftAzureSearchUniqueTokenFilter', 'OdataTypeMicrosoftAzureSearchWordDelimiterTokenFilter'
	OdataType OdataTypeBasicTokenFilter `json:"@odata.type,omitempty"`
	// MaxShingleSize - The maximum shingle size. Default and minimum value is 2.
	MaxShingleSize *int32 `json:"maxShingleSize,omitempty"`
	// MinShingleSize - The minimum shingle size. Default and minimum value is 2. Must be less than the value of maxShingleSize.
	MinShingleSize *int32 `json:"minShingleSize,omitempty"`
	// OutputUnigrams - A value indicating whether the output stream will contain the input tokens (unigrams) as well as shingles. Default is true.
	OutputUnigrams *bool `json:"outputUnigrams,omitempty"`
	// OutputUnigramsIfNoShingles - A value indicating whether to output unigrams for those times when no shingles are available. This property takes precedence when outputUnigrams is set to false. Default is false.
	OutputUnigramsIfNoShingles *bool `json:"outputUnigramsIfNoShingles,omitempty"`
	// TokenSeparator - The string to use when joining adjacent tokens to form a shingle. Default is a single space (" ").
	TokenSeparator *string `json:"tokenSeparator,omitempty"`
	// FilterToken - The string to insert for each position at which there is no token. Default is an underscore ("_").
	FilterToken *string `json:"filterToken,omitempty"`
}

// MarshalJSON is the custom marshaler for ShingleTokenFilter.
func (stf ShingleTokenFilter) MarshalJSON() ([]byte, error) {
	stf.OdataType = OdataTypeMicrosoftAzureSearchShingleTokenFilter
	type Alias ShingleTokenFilter
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(stf),
	})
}

// AsASCIIFoldingTokenFilter is the BasicTokenFilter implementation for ShingleTokenFilter.
func (stf ShingleTokenFilter) AsASCIIFoldingTokenFilter() (*ASCIIFoldingTokenFilter, bool) {
	return nil, false
}

// AsCjkBigramTokenFilter is the BasicTokenFilter implementation for ShingleTokenFilter.
func (stf ShingleTokenFilter) AsCjkBigramTokenFilter() (*CjkBigramTokenFilter, bool) {
	return nil, false
}

// AsCommonGramTokenFilter is the BasicTokenFilter implementation for ShingleTokenFilter.
func (stf ShingleTokenFilter) AsCommonGramTokenFilter() (*CommonGramTokenFilter, bool) {
	return nil, false
}

// AsDictionaryDecompounderTokenFilter is the BasicTokenFilter implementation for ShingleTokenFilter.
func (stf ShingleTokenFilter) AsDictionaryDecompounderTokenFilter() (*DictionaryDecompounderTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilter is the BasicTokenFilter implementation for ShingleTokenFilter.
func (stf ShingleTokenFilter) AsEdgeNGramTokenFilter() (*EdgeNGramTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilterV2 is the BasicTokenFilter implementation for ShingleTokenFilter.
func (stf ShingleTokenFilter) AsEdgeNGramTokenFilterV2() (*EdgeNGramTokenFilterV2, bool) {
	return nil, false
}

// AsElisionTokenFilter is the BasicTokenFilter implementation for ShingleTokenFilter.
func (stf ShingleTokenFilter) AsElisionTokenFilter() (*ElisionTokenFilter, bool) {
	return nil, false
}

// AsKeepTokenFilter is the BasicTokenFilter implementation for ShingleTokenFilter.
func (stf ShingleTokenFilter) AsKeepTokenFilter() (*KeepTokenFilter, bool) {
	return nil, false
}

// AsKeywordMarkerTokenFilter is the BasicTokenFilter implementation for ShingleTokenFilter.
func (stf ShingleTokenFilter) AsKeywordMarkerTokenFilter() (*KeywordMarkerTokenFilter, bool) {
	return nil, false
}

// AsLengthTokenFilter is the BasicTokenFilter implementation for ShingleTokenFilter.
func (stf ShingleTokenFilter) AsLengthTokenFilter() (*LengthTokenFilter, bool) {
	return nil, false
}

// AsLimitTokenFilter is the BasicTokenFilter implementation for ShingleTokenFilter.
func (stf ShingleTokenFilter) AsLimitTokenFilter() (*LimitTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilter is the BasicTokenFilter implementation for ShingleTokenFilter.
func (stf ShingleTokenFilter) AsNGramTokenFilter() (*NGramTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilterV2 is the BasicTokenFilter implementation for ShingleTokenFilter.
func (stf ShingleTokenFilter) AsNGramTokenFilterV2() (*NGramTokenFilterV2, bool) {
	return nil, false
}

// AsPatternCaptureTokenFilter is the BasicTokenFilter implementation for ShingleTokenFilter.
func (stf ShingleTokenFilter) AsPatternCaptureTokenFilter() (*PatternCaptureTokenFilter, bool) {
	return nil, false
}

// AsPatternReplaceTokenFilter is the BasicTokenFilter implementation for ShingleTokenFilter.
func (stf ShingleTokenFilter) AsPatternReplaceTokenFilter() (*PatternReplaceTokenFilter, bool) {
	return nil, false
}

// AsPhoneticTokenFilter is the BasicTokenFilter implementation for ShingleTokenFilter.
func (stf ShingleTokenFilter) AsPhoneticTokenFilter() (*PhoneticTokenFilter, bool) {
	return nil, false
}

// AsShingleTokenFilter is the BasicTokenFilter implementation for ShingleTokenFilter.
func (stf ShingleTokenFilter) AsShingleTokenFilter() (*ShingleTokenFilter, bool) {
	return &stf, true
}

// AsSnowballTokenFilter is the BasicTokenFilter implementation for ShingleTokenFilter.
func (stf ShingleTokenFilter) AsSnowballTokenFilter() (*SnowballTokenFilter, bool) {
	return nil, false
}

// AsStemmerTokenFilter is the BasicTokenFilter implementation for ShingleTokenFilter.
func (stf ShingleTokenFilter) AsStemmerTokenFilter() (*StemmerTokenFilter, bool) {
	return nil, false
}

// AsStemmerOverrideTokenFilter is the BasicTokenFilter implementation for ShingleTokenFilter.
func (stf ShingleTokenFilter) AsStemmerOverrideTokenFilter() (*StemmerOverrideTokenFilter, bool) {
	return nil, false
}

// AsStopwordsTokenFilter is the BasicTokenFilter implementation for ShingleTokenFilter.
func (stf ShingleTokenFilter) AsStopwordsTokenFilter() (*StopwordsTokenFilter, bool) {
	return nil, false
}

// AsSynonymTokenFilter is the BasicTokenFilter implementation for ShingleTokenFilter.
func (stf ShingleTokenFilter) AsSynonymTokenFilter() (*SynonymTokenFilter, bool) {
	return nil, false
}

// AsTruncateTokenFilter is the BasicTokenFilter implementation for ShingleTokenFilter.
func (stf ShingleTokenFilter) AsTruncateTokenFilter() (*TruncateTokenFilter, bool) {
	return nil, false
}

// AsUniqueTokenFilter is the BasicTokenFilter implementation for ShingleTokenFilter.
func (stf ShingleTokenFilter) AsUniqueTokenFilter() (*UniqueTokenFilter, bool) {
	return nil, false
}

// AsWordDelimiterTokenFilter is the BasicTokenFilter implementation for ShingleTokenFilter.
func (stf ShingleTokenFilter) AsWordDelimiterTokenFilter() (*WordDelimiterTokenFilter, bool) {
	return nil, false
}

// AsTokenFilter is the BasicTokenFilter implementation for ShingleTokenFilter.
func (stf ShingleTokenFilter) AsTokenFilter() (*TokenFilter, bool) {
	return nil, false
}

// AsBasicTokenFilter is the BasicTokenFilter implementation for ShingleTokenFilter.
func (stf ShingleTokenFilter) AsBasicTokenFilter() (BasicTokenFilter, bool) {
	return &stf, true
}

// SnowballTokenFilter a filter that stems words using a Snowball-generated stemmer. This token filter is implemented
// using Apache Lucene.
type SnowballTokenFilter struct {
	// Name - The name of the token filter. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeTokenFilter', 'OdataTypeMicrosoftAzureSearchASCIIFoldingTokenFilter', 'OdataTypeMicrosoftAzureSearchCjkBigramTokenFilter', 'OdataTypeMicrosoftAzureSearchCommonGramTokenFilter', 'OdataTypeMicrosoftAzureSearchDictionaryDecompounderTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchElisionTokenFilter', 'OdataTypeMicrosoftAzureSearchKeepTokenFilter', 'OdataTypeMicrosoftAzureSearchKeywordMarkerTokenFilter', 'OdataTypeMicrosoftAzureSearchLengthTokenFilter', 'OdataTypeMicrosoftAzureSearchLimitTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchPatternCaptureTokenFilter', 'OdataTypeMicrosoftAzureSearchPatternReplaceTokenFilter', 'OdataTypeMicrosoftAzureSearchPhoneticTokenFilter', 'OdataTypeMicrosoftAzureSearchShingleTokenFilter', 'OdataTypeMicrosoftAzureSearchSnowballTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerOverrideTokenFilter', 'OdataTypeMicrosoftAzureSearchStopwordsTokenFilter', 'OdataTypeMicrosoftAzureSearchSynonymTokenFilter', 'OdataTypeMicrosoftAzureSearchTruncateTokenFilter', 'OdataTypeMicrosoftAzureSearchUniqueTokenFilter', 'OdataTypeMicrosoftAzureSearchWordDelimiterTokenFilter'
	OdataType OdataTypeBasicTokenFilter `json:"@odata.type,omitempty"`
	// Language - The language to use. Possible values include: 'SnowballTokenFilterLanguageArmenian', 'SnowballTokenFilterLanguageBasque', 'SnowballTokenFilterLanguageCatalan', 'SnowballTokenFilterLanguageDanish', 'SnowballTokenFilterLanguageDutch', 'SnowballTokenFilterLanguageEnglish', 'SnowballTokenFilterLanguageFinnish', 'SnowballTokenFilterLanguageFrench', 'SnowballTokenFilterLanguageGerman', 'SnowballTokenFilterLanguageGerman2', 'SnowballTokenFilterLanguageHungarian', 'SnowballTokenFilterLanguageItalian', 'SnowballTokenFilterLanguageKp', 'SnowballTokenFilterLanguageLovins', 'SnowballTokenFilterLanguageNorwegian', 'SnowballTokenFilterLanguagePorter', 'SnowballTokenFilterLanguagePortuguese', 'SnowballTokenFilterLanguageRomanian', 'SnowballTokenFilterLanguageRussian', 'SnowballTokenFilterLanguageSpanish', 'SnowballTokenFilterLanguageSwedish', 'SnowballTokenFilterLanguageTurkish'
	Language SnowballTokenFilterLanguage `json:"language,omitempty"`
}

// MarshalJSON is the custom marshaler for SnowballTokenFilter.
func (stf SnowballTokenFilter) MarshalJSON() ([]byte, error) {
	stf.OdataType = OdataTypeMicrosoftAzureSearchSnowballTokenFilter
	type Alias SnowballTokenFilter
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(stf),
	})
}

// AsASCIIFoldingTokenFilter is the BasicTokenFilter implementation for SnowballTokenFilter.
func (stf SnowballTokenFilter) AsASCIIFoldingTokenFilter() (*ASCIIFoldingTokenFilter, bool) {
	return nil, false
}

// AsCjkBigramTokenFilter is the BasicTokenFilter implementation for SnowballTokenFilter.
func (stf SnowballTokenFilter) AsCjkBigramTokenFilter() (*CjkBigramTokenFilter, bool) {
	return nil, false
}

// AsCommonGramTokenFilter is the BasicTokenFilter implementation for SnowballTokenFilter.
func (stf SnowballTokenFilter) AsCommonGramTokenFilter() (*CommonGramTokenFilter, bool) {
	return nil, false
}

// AsDictionaryDecompounderTokenFilter is the BasicTokenFilter implementation for SnowballTokenFilter.
func (stf SnowballTokenFilter) AsDictionaryDecompounderTokenFilter() (*DictionaryDecompounderTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilter is the BasicTokenFilter implementation for SnowballTokenFilter.
func (stf SnowballTokenFilter) AsEdgeNGramTokenFilter() (*EdgeNGramTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilterV2 is the BasicTokenFilter implementation for SnowballTokenFilter.
func (stf SnowballTokenFilter) AsEdgeNGramTokenFilterV2() (*EdgeNGramTokenFilterV2, bool) {
	return nil, false
}

// AsElisionTokenFilter is the BasicTokenFilter implementation for SnowballTokenFilter.
func (stf SnowballTokenFilter) AsElisionTokenFilter() (*ElisionTokenFilter, bool) {
	return nil, false
}

// AsKeepTokenFilter is the BasicTokenFilter implementation for SnowballTokenFilter.
func (stf SnowballTokenFilter) AsKeepTokenFilter() (*KeepTokenFilter, bool) {
	return nil, false
}

// AsKeywordMarkerTokenFilter is the BasicTokenFilter implementation for SnowballTokenFilter.
func (stf SnowballTokenFilter) AsKeywordMarkerTokenFilter() (*KeywordMarkerTokenFilter, bool) {
	return nil, false
}

// AsLengthTokenFilter is the BasicTokenFilter implementation for SnowballTokenFilter.
func (stf SnowballTokenFilter) AsLengthTokenFilter() (*LengthTokenFilter, bool) {
	return nil, false
}

// AsLimitTokenFilter is the BasicTokenFilter implementation for SnowballTokenFilter.
func (stf SnowballTokenFilter) AsLimitTokenFilter() (*LimitTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilter is the BasicTokenFilter implementation for SnowballTokenFilter.
func (stf SnowballTokenFilter) AsNGramTokenFilter() (*NGramTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilterV2 is the BasicTokenFilter implementation for SnowballTokenFilter.
func (stf SnowballTokenFilter) AsNGramTokenFilterV2() (*NGramTokenFilterV2, bool) {
	return nil, false
}

// AsPatternCaptureTokenFilter is the BasicTokenFilter implementation for SnowballTokenFilter.
func (stf SnowballTokenFilter) AsPatternCaptureTokenFilter() (*PatternCaptureTokenFilter, bool) {
	return nil, false
}

// AsPatternReplaceTokenFilter is the BasicTokenFilter implementation for SnowballTokenFilter.
func (stf SnowballTokenFilter) AsPatternReplaceTokenFilter() (*PatternReplaceTokenFilter, bool) {
	return nil, false
}

// AsPhoneticTokenFilter is the BasicTokenFilter implementation for SnowballTokenFilter.
func (stf SnowballTokenFilter) AsPhoneticTokenFilter() (*PhoneticTokenFilter, bool) {
	return nil, false
}

// AsShingleTokenFilter is the BasicTokenFilter implementation for SnowballTokenFilter.
func (stf SnowballTokenFilter) AsShingleTokenFilter() (*ShingleTokenFilter, bool) {
	return nil, false
}

// AsSnowballTokenFilter is the BasicTokenFilter implementation for SnowballTokenFilter.
func (stf SnowballTokenFilter) AsSnowballTokenFilter() (*SnowballTokenFilter, bool) {
	return &stf, true
}

// AsStemmerTokenFilter is the BasicTokenFilter implementation for SnowballTokenFilter.
func (stf SnowballTokenFilter) AsStemmerTokenFilter() (*StemmerTokenFilter, bool) {
	return nil, false
}

// AsStemmerOverrideTokenFilter is the BasicTokenFilter implementation for SnowballTokenFilter.
func (stf SnowballTokenFilter) AsStemmerOverrideTokenFilter() (*StemmerOverrideTokenFilter, bool) {
	return nil, false
}

// AsStopwordsTokenFilter is the BasicTokenFilter implementation for SnowballTokenFilter.
func (stf SnowballTokenFilter) AsStopwordsTokenFilter() (*StopwordsTokenFilter, bool) {
	return nil, false
}

// AsSynonymTokenFilter is the BasicTokenFilter implementation for SnowballTokenFilter.
func (stf SnowballTokenFilter) AsSynonymTokenFilter() (*SynonymTokenFilter, bool) {
	return nil, false
}

// AsTruncateTokenFilter is the BasicTokenFilter implementation for SnowballTokenFilter.
func (stf SnowballTokenFilter) AsTruncateTokenFilter() (*TruncateTokenFilter, bool) {
	return nil, false
}

// AsUniqueTokenFilter is the BasicTokenFilter implementation for SnowballTokenFilter.
func (stf SnowballTokenFilter) AsUniqueTokenFilter() (*UniqueTokenFilter, bool) {
	return nil, false
}

// AsWordDelimiterTokenFilter is the BasicTokenFilter implementation for SnowballTokenFilter.
func (stf SnowballTokenFilter) AsWordDelimiterTokenFilter() (*WordDelimiterTokenFilter, bool) {
	return nil, false
}

// AsTokenFilter is the BasicTokenFilter implementation for SnowballTokenFilter.
func (stf SnowballTokenFilter) AsTokenFilter() (*TokenFilter, bool) {
	return nil, false
}

// AsBasicTokenFilter is the BasicTokenFilter implementation for SnowballTokenFilter.
func (stf SnowballTokenFilter) AsBasicTokenFilter() (BasicTokenFilter, bool) {
	return &stf, true
}

// SoftDeleteColumnDeletionDetectionPolicy defines a data deletion detection policy that implements a soft-deletion
// strategy. It determines whether an item should be deleted based on the value of a designated 'soft delete' column.
type SoftDeleteColumnDeletionDetectionPolicy struct {
	// OdataType - Possible values include: 'OdataTypeDataDeletionDetectionPolicy', 'OdataTypeMicrosoftAzureSearchSoftDeleteColumnDeletionDetectionPolicy'
	OdataType OdataTypeBasicDataDeletionDetectionPolicy `json:"@odata.type,omitempty"`
	// SoftDeleteColumnName - The name of the column to use for soft-deletion detection.
	SoftDeleteColumnName *string `json:"softDeleteColumnName,omitempty"`
	// SoftDeleteMarkerValue - The marker value that indentifies an item as deleted.
	SoftDeleteMarkerValue *string `json:"softDeleteMarkerValue,omitempty"`
}

// MarshalJSON is the custom marshaler for SoftDeleteColumnDeletionDetectionPolicy.
func (sdcddp SoftDeleteColumnDeletionDetectionPolicy) MarshalJSON() ([]byte, error) {
	sdcddp.OdataType = OdataTypeMicrosoftAzureSearchSoftDeleteColumnDeletionDetectionPolicy
	type Alias SoftDeleteColumnDeletionDetectionPolicy
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(sdcddp),
	})
}

// AsSoftDeleteColumnDeletionDetectionPolicy is the BasicDataDeletionDetectionPolicy implementation for SoftDeleteColumnDeletionDetectionPolicy.
func (sdcddp SoftDeleteColumnDeletionDetectionPolicy) AsSoftDeleteColumnDeletionDetectionPolicy() (*SoftDeleteColumnDeletionDetectionPolicy, bool) {
	return &sdcddp, true
}

// AsDataDeletionDetectionPolicy is the BasicDataDeletionDetectionPolicy implementation for SoftDeleteColumnDeletionDetectionPolicy.
func (sdcddp SoftDeleteColumnDeletionDetectionPolicy) AsDataDeletionDetectionPolicy() (*DataDeletionDetectionPolicy, bool) {
	return nil, false
}

// AsBasicDataDeletionDetectionPolicy is the BasicDataDeletionDetectionPolicy implementation for SoftDeleteColumnDeletionDetectionPolicy.
func (sdcddp SoftDeleteColumnDeletionDetectionPolicy) AsBasicDataDeletionDetectionPolicy() (BasicDataDeletionDetectionPolicy, bool) {
	return &sdcddp, true
}

// SQLIntegratedChangeTrackingPolicy defines a data change detection policy that captures changes using the Integrated
// Change Tracking feature of Azure SQL Database.
type SQLIntegratedChangeTrackingPolicy struct {
	// OdataType - Possible values include: 'OdataTypeDataChangeDetectionPolicy', 'OdataTypeMicrosoftAzureSearchHighWaterMarkChangeDetectionPolicy', 'OdataTypeMicrosoftAzureSearchSQLIntegratedChangeTrackingPolicy'
	OdataType OdataTypeBasicDataChangeDetectionPolicy `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLIntegratedChangeTrackingPolicy.
func (sictp SQLIntegratedChangeTrackingPolicy) MarshalJSON() ([]byte, error) {
	sictp.OdataType = OdataTypeMicrosoftAzureSearchSQLIntegratedChangeTrackingPolicy
	type Alias SQLIntegratedChangeTrackingPolicy
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(sictp),
	})
}

// AsHighWaterMarkChangeDetectionPolicy is the BasicDataChangeDetectionPolicy implementation for SQLIntegratedChangeTrackingPolicy.
func (sictp SQLIntegratedChangeTrackingPolicy) AsHighWaterMarkChangeDetectionPolicy() (*HighWaterMarkChangeDetectionPolicy, bool) {
	return nil, false
}

// AsSQLIntegratedChangeTrackingPolicy is the BasicDataChangeDetectionPolicy implementation for SQLIntegratedChangeTrackingPolicy.
func (sictp SQLIntegratedChangeTrackingPolicy) AsSQLIntegratedChangeTrackingPolicy() (*SQLIntegratedChangeTrackingPolicy, bool) {
	return &sictp, true
}

// AsDataChangeDetectionPolicy is the BasicDataChangeDetectionPolicy implementation for SQLIntegratedChangeTrackingPolicy.
func (sictp SQLIntegratedChangeTrackingPolicy) AsDataChangeDetectionPolicy() (*DataChangeDetectionPolicy, bool) {
	return nil, false
}

// AsBasicDataChangeDetectionPolicy is the BasicDataChangeDetectionPolicy implementation for SQLIntegratedChangeTrackingPolicy.
func (sictp SQLIntegratedChangeTrackingPolicy) AsBasicDataChangeDetectionPolicy() (BasicDataChangeDetectionPolicy, bool) {
	return &sictp, true
}

// StandardAnalyzer standard Apache Lucene analyzer; Composed of the standard tokenizer, lowercase filter and stop
// filter.
type StandardAnalyzer struct {
	// Name - The name of the analyzer. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeAnalyzer', 'OdataTypeMicrosoftAzureSearchCustomAnalyzer', 'OdataTypeMicrosoftAzureSearchPatternAnalyzer', 'OdataTypeMicrosoftAzureSearchStandardAnalyzer', 'OdataTypeMicrosoftAzureSearchStopAnalyzer'
	OdataType OdataType `json:"@odata.type,omitempty"`
	// MaxTokenLength - The maximum token length. Default is 255. Tokens longer than the maximum length are split. The maximum token length that can be used is 300 characters.
	MaxTokenLength *int32 `json:"maxTokenLength,omitempty"`
	// Stopwords - A list of stopwords.
	Stopwords *[]string `json:"stopwords,omitempty"`
}

// MarshalJSON is the custom marshaler for StandardAnalyzer.
func (sa StandardAnalyzer) MarshalJSON() ([]byte, error) {
	sa.OdataType = OdataTypeMicrosoftAzureSearchStandardAnalyzer
	type Alias StandardAnalyzer
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(sa),
	})
}

// AsCustomAnalyzer is the BasicAnalyzer implementation for StandardAnalyzer.
func (sa StandardAnalyzer) AsCustomAnalyzer() (*CustomAnalyzer, bool) {
	return nil, false
}

// AsPatternAnalyzer is the BasicAnalyzer implementation for StandardAnalyzer.
func (sa StandardAnalyzer) AsPatternAnalyzer() (*PatternAnalyzer, bool) {
	return nil, false
}

// AsStandardAnalyzer is the BasicAnalyzer implementation for StandardAnalyzer.
func (sa StandardAnalyzer) AsStandardAnalyzer() (*StandardAnalyzer, bool) {
	return &sa, true
}

// AsStopAnalyzer is the BasicAnalyzer implementation for StandardAnalyzer.
func (sa StandardAnalyzer) AsStopAnalyzer() (*StopAnalyzer, bool) {
	return nil, false
}

// AsAnalyzer is the BasicAnalyzer implementation for StandardAnalyzer.
func (sa StandardAnalyzer) AsAnalyzer() (*Analyzer, bool) {
	return nil, false
}

// AsBasicAnalyzer is the BasicAnalyzer implementation for StandardAnalyzer.
func (sa StandardAnalyzer) AsBasicAnalyzer() (BasicAnalyzer, bool) {
	return &sa, true
}

// StandardTokenizer breaks text following the Unicode Text Segmentation rules. This tokenizer is implemented using
// Apache Lucene.
type StandardTokenizer struct {
	// Name - The name of the tokenizer. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeTokenizer', 'OdataTypeMicrosoftAzureSearchClassicTokenizer', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenizer', 'OdataTypeMicrosoftAzureSearchKeywordTokenizer', 'OdataTypeMicrosoftAzureSearchKeywordTokenizerV2', 'OdataTypeMicrosoftAzureSearchMicrosoftLanguageTokenizer', 'OdataTypeMicrosoftAzureSearchMicrosoftLanguageStemmingTokenizer', 'OdataTypeMicrosoftAzureSearchNGramTokenizer', 'OdataTypeMicrosoftAzureSearchPathHierarchyTokenizer', 'OdataTypeMicrosoftAzureSearchPathHierarchyTokenizerV2', 'OdataTypeMicrosoftAzureSearchPatternTokenizer', 'OdataTypeMicrosoftAzureSearchStandardTokenizer', 'OdataTypeMicrosoftAzureSearchStandardTokenizerV2', 'OdataTypeMicrosoftAzureSearchUaxURLEmailTokenizer'
	OdataType OdataTypeBasicTokenizer `json:"@odata.type,omitempty"`
	// MaxTokenLength - The maximum token length. Default is 255. Tokens longer than the maximum length are split
	MaxTokenLength *int32 `json:"maxTokenLength,omitempty"`
}

// MarshalJSON is the custom marshaler for StandardTokenizer.
func (st StandardTokenizer) MarshalJSON() ([]byte, error) {
	st.OdataType = OdataTypeMicrosoftAzureSearchStandardTokenizer
	type Alias StandardTokenizer
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(st),
	})
}

// AsClassicTokenizer is the BasicTokenizer implementation for StandardTokenizer.
func (st StandardTokenizer) AsClassicTokenizer() (*ClassicTokenizer, bool) {
	return nil, false
}

// AsEdgeNGramTokenizer is the BasicTokenizer implementation for StandardTokenizer.
func (st StandardTokenizer) AsEdgeNGramTokenizer() (*EdgeNGramTokenizer, bool) {
	return nil, false
}

// AsKeywordTokenizer is the BasicTokenizer implementation for StandardTokenizer.
func (st StandardTokenizer) AsKeywordTokenizer() (*KeywordTokenizer, bool) {
	return nil, false
}

// AsKeywordTokenizerV2 is the BasicTokenizer implementation for StandardTokenizer.
func (st StandardTokenizer) AsKeywordTokenizerV2() (*KeywordTokenizerV2, bool) {
	return nil, false
}

// AsMicrosoftLanguageTokenizer is the BasicTokenizer implementation for StandardTokenizer.
func (st StandardTokenizer) AsMicrosoftLanguageTokenizer() (*MicrosoftLanguageTokenizer, bool) {
	return nil, false
}

// AsMicrosoftLanguageStemmingTokenizer is the BasicTokenizer implementation for StandardTokenizer.
func (st StandardTokenizer) AsMicrosoftLanguageStemmingTokenizer() (*MicrosoftLanguageStemmingTokenizer, bool) {
	return nil, false
}

// AsNGramTokenizer is the BasicTokenizer implementation for StandardTokenizer.
func (st StandardTokenizer) AsNGramTokenizer() (*NGramTokenizer, bool) {
	return nil, false
}

// AsPathHierarchyTokenizer is the BasicTokenizer implementation for StandardTokenizer.
func (st StandardTokenizer) AsPathHierarchyTokenizer() (*PathHierarchyTokenizer, bool) {
	return nil, false
}

// AsPathHierarchyTokenizerV2 is the BasicTokenizer implementation for StandardTokenizer.
func (st StandardTokenizer) AsPathHierarchyTokenizerV2() (*PathHierarchyTokenizerV2, bool) {
	return nil, false
}

// AsPatternTokenizer is the BasicTokenizer implementation for StandardTokenizer.
func (st StandardTokenizer) AsPatternTokenizer() (*PatternTokenizer, bool) {
	return nil, false
}

// AsStandardTokenizer is the BasicTokenizer implementation for StandardTokenizer.
func (st StandardTokenizer) AsStandardTokenizer() (*StandardTokenizer, bool) {
	return &st, true
}

// AsStandardTokenizerV2 is the BasicTokenizer implementation for StandardTokenizer.
func (st StandardTokenizer) AsStandardTokenizerV2() (*StandardTokenizerV2, bool) {
	return nil, false
}

// AsUaxURLEmailTokenizer is the BasicTokenizer implementation for StandardTokenizer.
func (st StandardTokenizer) AsUaxURLEmailTokenizer() (*UaxURLEmailTokenizer, bool) {
	return nil, false
}

// AsTokenizer is the BasicTokenizer implementation for StandardTokenizer.
func (st StandardTokenizer) AsTokenizer() (*Tokenizer, bool) {
	return nil, false
}

// AsBasicTokenizer is the BasicTokenizer implementation for StandardTokenizer.
func (st StandardTokenizer) AsBasicTokenizer() (BasicTokenizer, bool) {
	return &st, true
}

// StandardTokenizerV2 breaks text following the Unicode Text Segmentation rules. This tokenizer is implemented using
// Apache Lucene.
type StandardTokenizerV2 struct {
	// Name - The name of the tokenizer. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeTokenizer', 'OdataTypeMicrosoftAzureSearchClassicTokenizer', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenizer', 'OdataTypeMicrosoftAzureSearchKeywordTokenizer', 'OdataTypeMicrosoftAzureSearchKeywordTokenizerV2', 'OdataTypeMicrosoftAzureSearchMicrosoftLanguageTokenizer', 'OdataTypeMicrosoftAzureSearchMicrosoftLanguageStemmingTokenizer', 'OdataTypeMicrosoftAzureSearchNGramTokenizer', 'OdataTypeMicrosoftAzureSearchPathHierarchyTokenizer', 'OdataTypeMicrosoftAzureSearchPathHierarchyTokenizerV2', 'OdataTypeMicrosoftAzureSearchPatternTokenizer', 'OdataTypeMicrosoftAzureSearchStandardTokenizer', 'OdataTypeMicrosoftAzureSearchStandardTokenizerV2', 'OdataTypeMicrosoftAzureSearchUaxURLEmailTokenizer'
	OdataType OdataTypeBasicTokenizer `json:"@odata.type,omitempty"`
	// MaxTokenLength - The maximum token length. Default is 255. Tokens longer than the maximum length are split. The maximum token length that can be used is 300 characters.
	MaxTokenLength *int32 `json:"maxTokenLength,omitempty"`
}

// MarshalJSON is the custom marshaler for StandardTokenizerV2.
func (stv StandardTokenizerV2) MarshalJSON() ([]byte, error) {
	stv.OdataType = OdataTypeMicrosoftAzureSearchStandardTokenizerV2
	type Alias StandardTokenizerV2
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(stv),
	})
}

// AsClassicTokenizer is the BasicTokenizer implementation for StandardTokenizerV2.
func (stv StandardTokenizerV2) AsClassicTokenizer() (*ClassicTokenizer, bool) {
	return nil, false
}

// AsEdgeNGramTokenizer is the BasicTokenizer implementation for StandardTokenizerV2.
func (stv StandardTokenizerV2) AsEdgeNGramTokenizer() (*EdgeNGramTokenizer, bool) {
	return nil, false
}

// AsKeywordTokenizer is the BasicTokenizer implementation for StandardTokenizerV2.
func (stv StandardTokenizerV2) AsKeywordTokenizer() (*KeywordTokenizer, bool) {
	return nil, false
}

// AsKeywordTokenizerV2 is the BasicTokenizer implementation for StandardTokenizerV2.
func (stv StandardTokenizerV2) AsKeywordTokenizerV2() (*KeywordTokenizerV2, bool) {
	return nil, false
}

// AsMicrosoftLanguageTokenizer is the BasicTokenizer implementation for StandardTokenizerV2.
func (stv StandardTokenizerV2) AsMicrosoftLanguageTokenizer() (*MicrosoftLanguageTokenizer, bool) {
	return nil, false
}

// AsMicrosoftLanguageStemmingTokenizer is the BasicTokenizer implementation for StandardTokenizerV2.
func (stv StandardTokenizerV2) AsMicrosoftLanguageStemmingTokenizer() (*MicrosoftLanguageStemmingTokenizer, bool) {
	return nil, false
}

// AsNGramTokenizer is the BasicTokenizer implementation for StandardTokenizerV2.
func (stv StandardTokenizerV2) AsNGramTokenizer() (*NGramTokenizer, bool) {
	return nil, false
}

// AsPathHierarchyTokenizer is the BasicTokenizer implementation for StandardTokenizerV2.
func (stv StandardTokenizerV2) AsPathHierarchyTokenizer() (*PathHierarchyTokenizer, bool) {
	return nil, false
}

// AsPathHierarchyTokenizerV2 is the BasicTokenizer implementation for StandardTokenizerV2.
func (stv StandardTokenizerV2) AsPathHierarchyTokenizerV2() (*PathHierarchyTokenizerV2, bool) {
	return nil, false
}

// AsPatternTokenizer is the BasicTokenizer implementation for StandardTokenizerV2.
func (stv StandardTokenizerV2) AsPatternTokenizer() (*PatternTokenizer, bool) {
	return nil, false
}

// AsStandardTokenizer is the BasicTokenizer implementation for StandardTokenizerV2.
func (stv StandardTokenizerV2) AsStandardTokenizer() (*StandardTokenizer, bool) {
	return nil, false
}

// AsStandardTokenizerV2 is the BasicTokenizer implementation for StandardTokenizerV2.
func (stv StandardTokenizerV2) AsStandardTokenizerV2() (*StandardTokenizerV2, bool) {
	return &stv, true
}

// AsUaxURLEmailTokenizer is the BasicTokenizer implementation for StandardTokenizerV2.
func (stv StandardTokenizerV2) AsUaxURLEmailTokenizer() (*UaxURLEmailTokenizer, bool) {
	return nil, false
}

// AsTokenizer is the BasicTokenizer implementation for StandardTokenizerV2.
func (stv StandardTokenizerV2) AsTokenizer() (*Tokenizer, bool) {
	return nil, false
}

// AsBasicTokenizer is the BasicTokenizer implementation for StandardTokenizerV2.
func (stv StandardTokenizerV2) AsBasicTokenizer() (BasicTokenizer, bool) {
	return &stv, true
}

// StemmerOverrideTokenFilter provides the ability to override other stemming filters with custom dictionary-based
// stemming. Any dictionary-stemmed terms will be marked as keywords so that they will not be stemmed with stemmers
// down the chain. Must be placed before any stemming filters. This token filter is implemented using Apache Lucene.
type StemmerOverrideTokenFilter struct {
	// Name - The name of the token filter. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeTokenFilter', 'OdataTypeMicrosoftAzureSearchASCIIFoldingTokenFilter', 'OdataTypeMicrosoftAzureSearchCjkBigramTokenFilter', 'OdataTypeMicrosoftAzureSearchCommonGramTokenFilter', 'OdataTypeMicrosoftAzureSearchDictionaryDecompounderTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchElisionTokenFilter', 'OdataTypeMicrosoftAzureSearchKeepTokenFilter', 'OdataTypeMicrosoftAzureSearchKeywordMarkerTokenFilter', 'OdataTypeMicrosoftAzureSearchLengthTokenFilter', 'OdataTypeMicrosoftAzureSearchLimitTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchPatternCaptureTokenFilter', 'OdataTypeMicrosoftAzureSearchPatternReplaceTokenFilter', 'OdataTypeMicrosoftAzureSearchPhoneticTokenFilter', 'OdataTypeMicrosoftAzureSearchShingleTokenFilter', 'OdataTypeMicrosoftAzureSearchSnowballTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerOverrideTokenFilter', 'OdataTypeMicrosoftAzureSearchStopwordsTokenFilter', 'OdataTypeMicrosoftAzureSearchSynonymTokenFilter', 'OdataTypeMicrosoftAzureSearchTruncateTokenFilter', 'OdataTypeMicrosoftAzureSearchUniqueTokenFilter', 'OdataTypeMicrosoftAzureSearchWordDelimiterTokenFilter'
	OdataType OdataTypeBasicTokenFilter `json:"@odata.type,omitempty"`
	// Rules - A list of stemming rules in the following format: "word => stem", for example: "ran => run"
	Rules *[]string `json:"rules,omitempty"`
}

// MarshalJSON is the custom marshaler for StemmerOverrideTokenFilter.
func (sotf StemmerOverrideTokenFilter) MarshalJSON() ([]byte, error) {
	sotf.OdataType = OdataTypeMicrosoftAzureSearchStemmerOverrideTokenFilter
	type Alias StemmerOverrideTokenFilter
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(sotf),
	})
}

// AsASCIIFoldingTokenFilter is the BasicTokenFilter implementation for StemmerOverrideTokenFilter.
func (sotf StemmerOverrideTokenFilter) AsASCIIFoldingTokenFilter() (*ASCIIFoldingTokenFilter, bool) {
	return nil, false
}

// AsCjkBigramTokenFilter is the BasicTokenFilter implementation for StemmerOverrideTokenFilter.
func (sotf StemmerOverrideTokenFilter) AsCjkBigramTokenFilter() (*CjkBigramTokenFilter, bool) {
	return nil, false
}

// AsCommonGramTokenFilter is the BasicTokenFilter implementation for StemmerOverrideTokenFilter.
func (sotf StemmerOverrideTokenFilter) AsCommonGramTokenFilter() (*CommonGramTokenFilter, bool) {
	return nil, false
}

// AsDictionaryDecompounderTokenFilter is the BasicTokenFilter implementation for StemmerOverrideTokenFilter.
func (sotf StemmerOverrideTokenFilter) AsDictionaryDecompounderTokenFilter() (*DictionaryDecompounderTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilter is the BasicTokenFilter implementation for StemmerOverrideTokenFilter.
func (sotf StemmerOverrideTokenFilter) AsEdgeNGramTokenFilter() (*EdgeNGramTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilterV2 is the BasicTokenFilter implementation for StemmerOverrideTokenFilter.
func (sotf StemmerOverrideTokenFilter) AsEdgeNGramTokenFilterV2() (*EdgeNGramTokenFilterV2, bool) {
	return nil, false
}

// AsElisionTokenFilter is the BasicTokenFilter implementation for StemmerOverrideTokenFilter.
func (sotf StemmerOverrideTokenFilter) AsElisionTokenFilter() (*ElisionTokenFilter, bool) {
	return nil, false
}

// AsKeepTokenFilter is the BasicTokenFilter implementation for StemmerOverrideTokenFilter.
func (sotf StemmerOverrideTokenFilter) AsKeepTokenFilter() (*KeepTokenFilter, bool) {
	return nil, false
}

// AsKeywordMarkerTokenFilter is the BasicTokenFilter implementation for StemmerOverrideTokenFilter.
func (sotf StemmerOverrideTokenFilter) AsKeywordMarkerTokenFilter() (*KeywordMarkerTokenFilter, bool) {
	return nil, false
}

// AsLengthTokenFilter is the BasicTokenFilter implementation for StemmerOverrideTokenFilter.
func (sotf StemmerOverrideTokenFilter) AsLengthTokenFilter() (*LengthTokenFilter, bool) {
	return nil, false
}

// AsLimitTokenFilter is the BasicTokenFilter implementation for StemmerOverrideTokenFilter.
func (sotf StemmerOverrideTokenFilter) AsLimitTokenFilter() (*LimitTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilter is the BasicTokenFilter implementation for StemmerOverrideTokenFilter.
func (sotf StemmerOverrideTokenFilter) AsNGramTokenFilter() (*NGramTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilterV2 is the BasicTokenFilter implementation for StemmerOverrideTokenFilter.
func (sotf StemmerOverrideTokenFilter) AsNGramTokenFilterV2() (*NGramTokenFilterV2, bool) {
	return nil, false
}

// AsPatternCaptureTokenFilter is the BasicTokenFilter implementation for StemmerOverrideTokenFilter.
func (sotf StemmerOverrideTokenFilter) AsPatternCaptureTokenFilter() (*PatternCaptureTokenFilter, bool) {
	return nil, false
}

// AsPatternReplaceTokenFilter is the BasicTokenFilter implementation for StemmerOverrideTokenFilter.
func (sotf StemmerOverrideTokenFilter) AsPatternReplaceTokenFilter() (*PatternReplaceTokenFilter, bool) {
	return nil, false
}

// AsPhoneticTokenFilter is the BasicTokenFilter implementation for StemmerOverrideTokenFilter.
func (sotf StemmerOverrideTokenFilter) AsPhoneticTokenFilter() (*PhoneticTokenFilter, bool) {
	return nil, false
}

// AsShingleTokenFilter is the BasicTokenFilter implementation for StemmerOverrideTokenFilter.
func (sotf StemmerOverrideTokenFilter) AsShingleTokenFilter() (*ShingleTokenFilter, bool) {
	return nil, false
}

// AsSnowballTokenFilter is the BasicTokenFilter implementation for StemmerOverrideTokenFilter.
func (sotf StemmerOverrideTokenFilter) AsSnowballTokenFilter() (*SnowballTokenFilter, bool) {
	return nil, false
}

// AsStemmerTokenFilter is the BasicTokenFilter implementation for StemmerOverrideTokenFilter.
func (sotf StemmerOverrideTokenFilter) AsStemmerTokenFilter() (*StemmerTokenFilter, bool) {
	return nil, false
}

// AsStemmerOverrideTokenFilter is the BasicTokenFilter implementation for StemmerOverrideTokenFilter.
func (sotf StemmerOverrideTokenFilter) AsStemmerOverrideTokenFilter() (*StemmerOverrideTokenFilter, bool) {
	return &sotf, true
}

// AsStopwordsTokenFilter is the BasicTokenFilter implementation for StemmerOverrideTokenFilter.
func (sotf StemmerOverrideTokenFilter) AsStopwordsTokenFilter() (*StopwordsTokenFilter, bool) {
	return nil, false
}

// AsSynonymTokenFilter is the BasicTokenFilter implementation for StemmerOverrideTokenFilter.
func (sotf StemmerOverrideTokenFilter) AsSynonymTokenFilter() (*SynonymTokenFilter, bool) {
	return nil, false
}

// AsTruncateTokenFilter is the BasicTokenFilter implementation for StemmerOverrideTokenFilter.
func (sotf StemmerOverrideTokenFilter) AsTruncateTokenFilter() (*TruncateTokenFilter, bool) {
	return nil, false
}

// AsUniqueTokenFilter is the BasicTokenFilter implementation for StemmerOverrideTokenFilter.
func (sotf StemmerOverrideTokenFilter) AsUniqueTokenFilter() (*UniqueTokenFilter, bool) {
	return nil, false
}

// AsWordDelimiterTokenFilter is the BasicTokenFilter implementation for StemmerOverrideTokenFilter.
func (sotf StemmerOverrideTokenFilter) AsWordDelimiterTokenFilter() (*WordDelimiterTokenFilter, bool) {
	return nil, false
}

// AsTokenFilter is the BasicTokenFilter implementation for StemmerOverrideTokenFilter.
func (sotf StemmerOverrideTokenFilter) AsTokenFilter() (*TokenFilter, bool) {
	return nil, false
}

// AsBasicTokenFilter is the BasicTokenFilter implementation for StemmerOverrideTokenFilter.
func (sotf StemmerOverrideTokenFilter) AsBasicTokenFilter() (BasicTokenFilter, bool) {
	return &sotf, true
}

// StemmerTokenFilter language specific stemming filter. This token filter is implemented using Apache Lucene.
type StemmerTokenFilter struct {
	// Name - The name of the token filter. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeTokenFilter', 'OdataTypeMicrosoftAzureSearchASCIIFoldingTokenFilter', 'OdataTypeMicrosoftAzureSearchCjkBigramTokenFilter', 'OdataTypeMicrosoftAzureSearchCommonGramTokenFilter', 'OdataTypeMicrosoftAzureSearchDictionaryDecompounderTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchElisionTokenFilter', 'OdataTypeMicrosoftAzureSearchKeepTokenFilter', 'OdataTypeMicrosoftAzureSearchKeywordMarkerTokenFilter', 'OdataTypeMicrosoftAzureSearchLengthTokenFilter', 'OdataTypeMicrosoftAzureSearchLimitTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchPatternCaptureTokenFilter', 'OdataTypeMicrosoftAzureSearchPatternReplaceTokenFilter', 'OdataTypeMicrosoftAzureSearchPhoneticTokenFilter', 'OdataTypeMicrosoftAzureSearchShingleTokenFilter', 'OdataTypeMicrosoftAzureSearchSnowballTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerOverrideTokenFilter', 'OdataTypeMicrosoftAzureSearchStopwordsTokenFilter', 'OdataTypeMicrosoftAzureSearchSynonymTokenFilter', 'OdataTypeMicrosoftAzureSearchTruncateTokenFilter', 'OdataTypeMicrosoftAzureSearchUniqueTokenFilter', 'OdataTypeMicrosoftAzureSearchWordDelimiterTokenFilter'
	OdataType OdataTypeBasicTokenFilter `json:"@odata.type,omitempty"`
	// Language - The language to use. Possible values include: 'StemmerTokenFilterLanguageArabic', 'StemmerTokenFilterLanguageArmenian', 'StemmerTokenFilterLanguageBasque', 'StemmerTokenFilterLanguageBrazilian', 'StemmerTokenFilterLanguageBulgarian', 'StemmerTokenFilterLanguageCatalan', 'StemmerTokenFilterLanguageCzech', 'StemmerTokenFilterLanguageDanish', 'StemmerTokenFilterLanguageDutch', 'StemmerTokenFilterLanguageDutchKp', 'StemmerTokenFilterLanguageEnglish', 'StemmerTokenFilterLanguageLightEnglish', 'StemmerTokenFilterLanguageMinimalEnglish', 'StemmerTokenFilterLanguagePossessiveEnglish', 'StemmerTokenFilterLanguagePorter2', 'StemmerTokenFilterLanguageLovins', 'StemmerTokenFilterLanguageFinnish', 'StemmerTokenFilterLanguageLightFinnish', 'StemmerTokenFilterLanguageFrench', 'StemmerTokenFilterLanguageLightFrench', 'StemmerTokenFilterLanguageMinimalFrench', 'StemmerTokenFilterLanguageGalician', 'StemmerTokenFilterLanguageMinimalGalician', 'StemmerTokenFilterLanguageGerman', 'StemmerTokenFilterLanguageGerman2', 'StemmerTokenFilterLanguageLightGerman', 'StemmerTokenFilterLanguageMinimalGerman', 'StemmerTokenFilterLanguageGreek', 'StemmerTokenFilterLanguageHindi', 'StemmerTokenFilterLanguageHungarian', 'StemmerTokenFilterLanguageLightHungarian', 'StemmerTokenFilterLanguageIndonesian', 'StemmerTokenFilterLanguageIrish', 'StemmerTokenFilterLanguageItalian', 'StemmerTokenFilterLanguageLightItalian', 'StemmerTokenFilterLanguageSorani', 'StemmerTokenFilterLanguageLatvian', 'StemmerTokenFilterLanguageNorwegian', 'StemmerTokenFilterLanguageLightNorwegian', 'StemmerTokenFilterLanguageMinimalNorwegian', 'StemmerTokenFilterLanguageLightNynorsk', 'StemmerTokenFilterLanguageMinimalNynorsk', 'StemmerTokenFilterLanguagePortuguese', 'StemmerTokenFilterLanguageLightPortuguese', 'StemmerTokenFilterLanguageMinimalPortuguese', 'StemmerTokenFilterLanguagePortugueseRslp', 'StemmerTokenFilterLanguageRomanian', 'StemmerTokenFilterLanguageRussian', 'StemmerTokenFilterLanguageLightRussian', 'StemmerTokenFilterLanguageSpanish', 'StemmerTokenFilterLanguageLightSpanish', 'StemmerTokenFilterLanguageSwedish', 'StemmerTokenFilterLanguageLightSwedish', 'StemmerTokenFilterLanguageTurkish'
	Language StemmerTokenFilterLanguage `json:"language,omitempty"`
}

// MarshalJSON is the custom marshaler for StemmerTokenFilter.
func (stf StemmerTokenFilter) MarshalJSON() ([]byte, error) {
	stf.OdataType = OdataTypeMicrosoftAzureSearchStemmerTokenFilter
	type Alias StemmerTokenFilter
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(stf),
	})
}

// AsASCIIFoldingTokenFilter is the BasicTokenFilter implementation for StemmerTokenFilter.
func (stf StemmerTokenFilter) AsASCIIFoldingTokenFilter() (*ASCIIFoldingTokenFilter, bool) {
	return nil, false
}

// AsCjkBigramTokenFilter is the BasicTokenFilter implementation for StemmerTokenFilter.
func (stf StemmerTokenFilter) AsCjkBigramTokenFilter() (*CjkBigramTokenFilter, bool) {
	return nil, false
}

// AsCommonGramTokenFilter is the BasicTokenFilter implementation for StemmerTokenFilter.
func (stf StemmerTokenFilter) AsCommonGramTokenFilter() (*CommonGramTokenFilter, bool) {
	return nil, false
}

// AsDictionaryDecompounderTokenFilter is the BasicTokenFilter implementation for StemmerTokenFilter.
func (stf StemmerTokenFilter) AsDictionaryDecompounderTokenFilter() (*DictionaryDecompounderTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilter is the BasicTokenFilter implementation for StemmerTokenFilter.
func (stf StemmerTokenFilter) AsEdgeNGramTokenFilter() (*EdgeNGramTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilterV2 is the BasicTokenFilter implementation for StemmerTokenFilter.
func (stf StemmerTokenFilter) AsEdgeNGramTokenFilterV2() (*EdgeNGramTokenFilterV2, bool) {
	return nil, false
}

// AsElisionTokenFilter is the BasicTokenFilter implementation for StemmerTokenFilter.
func (stf StemmerTokenFilter) AsElisionTokenFilter() (*ElisionTokenFilter, bool) {
	return nil, false
}

// AsKeepTokenFilter is the BasicTokenFilter implementation for StemmerTokenFilter.
func (stf StemmerTokenFilter) AsKeepTokenFilter() (*KeepTokenFilter, bool) {
	return nil, false
}

// AsKeywordMarkerTokenFilter is the BasicTokenFilter implementation for StemmerTokenFilter.
func (stf StemmerTokenFilter) AsKeywordMarkerTokenFilter() (*KeywordMarkerTokenFilter, bool) {
	return nil, false
}

// AsLengthTokenFilter is the BasicTokenFilter implementation for StemmerTokenFilter.
func (stf StemmerTokenFilter) AsLengthTokenFilter() (*LengthTokenFilter, bool) {
	return nil, false
}

// AsLimitTokenFilter is the BasicTokenFilter implementation for StemmerTokenFilter.
func (stf StemmerTokenFilter) AsLimitTokenFilter() (*LimitTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilter is the BasicTokenFilter implementation for StemmerTokenFilter.
func (stf StemmerTokenFilter) AsNGramTokenFilter() (*NGramTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilterV2 is the BasicTokenFilter implementation for StemmerTokenFilter.
func (stf StemmerTokenFilter) AsNGramTokenFilterV2() (*NGramTokenFilterV2, bool) {
	return nil, false
}

// AsPatternCaptureTokenFilter is the BasicTokenFilter implementation for StemmerTokenFilter.
func (stf StemmerTokenFilter) AsPatternCaptureTokenFilter() (*PatternCaptureTokenFilter, bool) {
	return nil, false
}

// AsPatternReplaceTokenFilter is the BasicTokenFilter implementation for StemmerTokenFilter.
func (stf StemmerTokenFilter) AsPatternReplaceTokenFilter() (*PatternReplaceTokenFilter, bool) {
	return nil, false
}

// AsPhoneticTokenFilter is the BasicTokenFilter implementation for StemmerTokenFilter.
func (stf StemmerTokenFilter) AsPhoneticTokenFilter() (*PhoneticTokenFilter, bool) {
	return nil, false
}

// AsShingleTokenFilter is the BasicTokenFilter implementation for StemmerTokenFilter.
func (stf StemmerTokenFilter) AsShingleTokenFilter() (*ShingleTokenFilter, bool) {
	return nil, false
}

// AsSnowballTokenFilter is the BasicTokenFilter implementation for StemmerTokenFilter.
func (stf StemmerTokenFilter) AsSnowballTokenFilter() (*SnowballTokenFilter, bool) {
	return nil, false
}

// AsStemmerTokenFilter is the BasicTokenFilter implementation for StemmerTokenFilter.
func (stf StemmerTokenFilter) AsStemmerTokenFilter() (*StemmerTokenFilter, bool) {
	return &stf, true
}

// AsStemmerOverrideTokenFilter is the BasicTokenFilter implementation for StemmerTokenFilter.
func (stf StemmerTokenFilter) AsStemmerOverrideTokenFilter() (*StemmerOverrideTokenFilter, bool) {
	return nil, false
}

// AsStopwordsTokenFilter is the BasicTokenFilter implementation for StemmerTokenFilter.
func (stf StemmerTokenFilter) AsStopwordsTokenFilter() (*StopwordsTokenFilter, bool) {
	return nil, false
}

// AsSynonymTokenFilter is the BasicTokenFilter implementation for StemmerTokenFilter.
func (stf StemmerTokenFilter) AsSynonymTokenFilter() (*SynonymTokenFilter, bool) {
	return nil, false
}

// AsTruncateTokenFilter is the BasicTokenFilter implementation for StemmerTokenFilter.
func (stf StemmerTokenFilter) AsTruncateTokenFilter() (*TruncateTokenFilter, bool) {
	return nil, false
}

// AsUniqueTokenFilter is the BasicTokenFilter implementation for StemmerTokenFilter.
func (stf StemmerTokenFilter) AsUniqueTokenFilter() (*UniqueTokenFilter, bool) {
	return nil, false
}

// AsWordDelimiterTokenFilter is the BasicTokenFilter implementation for StemmerTokenFilter.
func (stf StemmerTokenFilter) AsWordDelimiterTokenFilter() (*WordDelimiterTokenFilter, bool) {
	return nil, false
}

// AsTokenFilter is the BasicTokenFilter implementation for StemmerTokenFilter.
func (stf StemmerTokenFilter) AsTokenFilter() (*TokenFilter, bool) {
	return nil, false
}

// AsBasicTokenFilter is the BasicTokenFilter implementation for StemmerTokenFilter.
func (stf StemmerTokenFilter) AsBasicTokenFilter() (BasicTokenFilter, bool) {
	return &stf, true
}

// StopAnalyzer divides text at non-letters; Applies the lowercase and stopword token filters. This analyzer is
// implemented using Apache Lucene.
type StopAnalyzer struct {
	// Name - The name of the analyzer. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeAnalyzer', 'OdataTypeMicrosoftAzureSearchCustomAnalyzer', 'OdataTypeMicrosoftAzureSearchPatternAnalyzer', 'OdataTypeMicrosoftAzureSearchStandardAnalyzer', 'OdataTypeMicrosoftAzureSearchStopAnalyzer'
	OdataType OdataType `json:"@odata.type,omitempty"`
	// Stopwords - A list of stopwords.
	Stopwords *[]string `json:"stopwords,omitempty"`
}

// MarshalJSON is the custom marshaler for StopAnalyzer.
func (sa StopAnalyzer) MarshalJSON() ([]byte, error) {
	sa.OdataType = OdataTypeMicrosoftAzureSearchStopAnalyzer
	type Alias StopAnalyzer
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(sa),
	})
}

// AsCustomAnalyzer is the BasicAnalyzer implementation for StopAnalyzer.
func (sa StopAnalyzer) AsCustomAnalyzer() (*CustomAnalyzer, bool) {
	return nil, false
}

// AsPatternAnalyzer is the BasicAnalyzer implementation for StopAnalyzer.
func (sa StopAnalyzer) AsPatternAnalyzer() (*PatternAnalyzer, bool) {
	return nil, false
}

// AsStandardAnalyzer is the BasicAnalyzer implementation for StopAnalyzer.
func (sa StopAnalyzer) AsStandardAnalyzer() (*StandardAnalyzer, bool) {
	return nil, false
}

// AsStopAnalyzer is the BasicAnalyzer implementation for StopAnalyzer.
func (sa StopAnalyzer) AsStopAnalyzer() (*StopAnalyzer, bool) {
	return &sa, true
}

// AsAnalyzer is the BasicAnalyzer implementation for StopAnalyzer.
func (sa StopAnalyzer) AsAnalyzer() (*Analyzer, bool) {
	return nil, false
}

// AsBasicAnalyzer is the BasicAnalyzer implementation for StopAnalyzer.
func (sa StopAnalyzer) AsBasicAnalyzer() (BasicAnalyzer, bool) {
	return &sa, true
}

// StopwordsTokenFilter removes stop words from a token stream. This token filter is implemented using Apache Lucene.
type StopwordsTokenFilter struct {
	// Name - The name of the token filter. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeTokenFilter', 'OdataTypeMicrosoftAzureSearchASCIIFoldingTokenFilter', 'OdataTypeMicrosoftAzureSearchCjkBigramTokenFilter', 'OdataTypeMicrosoftAzureSearchCommonGramTokenFilter', 'OdataTypeMicrosoftAzureSearchDictionaryDecompounderTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchElisionTokenFilter', 'OdataTypeMicrosoftAzureSearchKeepTokenFilter', 'OdataTypeMicrosoftAzureSearchKeywordMarkerTokenFilter', 'OdataTypeMicrosoftAzureSearchLengthTokenFilter', 'OdataTypeMicrosoftAzureSearchLimitTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchPatternCaptureTokenFilter', 'OdataTypeMicrosoftAzureSearchPatternReplaceTokenFilter', 'OdataTypeMicrosoftAzureSearchPhoneticTokenFilter', 'OdataTypeMicrosoftAzureSearchShingleTokenFilter', 'OdataTypeMicrosoftAzureSearchSnowballTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerOverrideTokenFilter', 'OdataTypeMicrosoftAzureSearchStopwordsTokenFilter', 'OdataTypeMicrosoftAzureSearchSynonymTokenFilter', 'OdataTypeMicrosoftAzureSearchTruncateTokenFilter', 'OdataTypeMicrosoftAzureSearchUniqueTokenFilter', 'OdataTypeMicrosoftAzureSearchWordDelimiterTokenFilter'
	OdataType OdataTypeBasicTokenFilter `json:"@odata.type,omitempty"`
	// Stopwords - The list of stopwords. This property and the stopwords list property cannot both be set.
	Stopwords *[]string `json:"stopwords,omitempty"`
	// StopwordsList - A predefined list of stopwords to use. This property and the stopwords property cannot both be set. Default is English. Possible values include: 'StopwordsListArabic', 'StopwordsListArmenian', 'StopwordsListBasque', 'StopwordsListBrazilian', 'StopwordsListBulgarian', 'StopwordsListCatalan', 'StopwordsListCzech', 'StopwordsListDanish', 'StopwordsListDutch', 'StopwordsListEnglish', 'StopwordsListFinnish', 'StopwordsListFrench', 'StopwordsListGalician', 'StopwordsListGerman', 'StopwordsListGreek', 'StopwordsListHindi', 'StopwordsListHungarian', 'StopwordsListIndonesian', 'StopwordsListIrish', 'StopwordsListItalian', 'StopwordsListLatvian', 'StopwordsListNorwegian', 'StopwordsListPersian', 'StopwordsListPortuguese', 'StopwordsListRomanian', 'StopwordsListRussian', 'StopwordsListSorani', 'StopwordsListSpanish', 'StopwordsListSwedish', 'StopwordsListThai', 'StopwordsListTurkish'
	StopwordsList StopwordsList `json:"stopwordsList,omitempty"`
	// IgnoreCase - A value indicating whether to ignore case. If true, all words are converted to lower case first. Default is false.
	IgnoreCase *bool `json:"ignoreCase,omitempty"`
	// RemoveTrailingStopWords - A value indicating whether to ignore the last search term if it's a stop word. Default is true.
	RemoveTrailingStopWords *bool `json:"removeTrailing,omitempty"`
}

// MarshalJSON is the custom marshaler for StopwordsTokenFilter.
func (stf StopwordsTokenFilter) MarshalJSON() ([]byte, error) {
	stf.OdataType = OdataTypeMicrosoftAzureSearchStopwordsTokenFilter
	type Alias StopwordsTokenFilter
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(stf),
	})
}

// AsASCIIFoldingTokenFilter is the BasicTokenFilter implementation for StopwordsTokenFilter.
func (stf StopwordsTokenFilter) AsASCIIFoldingTokenFilter() (*ASCIIFoldingTokenFilter, bool) {
	return nil, false
}

// AsCjkBigramTokenFilter is the BasicTokenFilter implementation for StopwordsTokenFilter.
func (stf StopwordsTokenFilter) AsCjkBigramTokenFilter() (*CjkBigramTokenFilter, bool) {
	return nil, false
}

// AsCommonGramTokenFilter is the BasicTokenFilter implementation for StopwordsTokenFilter.
func (stf StopwordsTokenFilter) AsCommonGramTokenFilter() (*CommonGramTokenFilter, bool) {
	return nil, false
}

// AsDictionaryDecompounderTokenFilter is the BasicTokenFilter implementation for StopwordsTokenFilter.
func (stf StopwordsTokenFilter) AsDictionaryDecompounderTokenFilter() (*DictionaryDecompounderTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilter is the BasicTokenFilter implementation for StopwordsTokenFilter.
func (stf StopwordsTokenFilter) AsEdgeNGramTokenFilter() (*EdgeNGramTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilterV2 is the BasicTokenFilter implementation for StopwordsTokenFilter.
func (stf StopwordsTokenFilter) AsEdgeNGramTokenFilterV2() (*EdgeNGramTokenFilterV2, bool) {
	return nil, false
}

// AsElisionTokenFilter is the BasicTokenFilter implementation for StopwordsTokenFilter.
func (stf StopwordsTokenFilter) AsElisionTokenFilter() (*ElisionTokenFilter, bool) {
	return nil, false
}

// AsKeepTokenFilter is the BasicTokenFilter implementation for StopwordsTokenFilter.
func (stf StopwordsTokenFilter) AsKeepTokenFilter() (*KeepTokenFilter, bool) {
	return nil, false
}

// AsKeywordMarkerTokenFilter is the BasicTokenFilter implementation for StopwordsTokenFilter.
func (stf StopwordsTokenFilter) AsKeywordMarkerTokenFilter() (*KeywordMarkerTokenFilter, bool) {
	return nil, false
}

// AsLengthTokenFilter is the BasicTokenFilter implementation for StopwordsTokenFilter.
func (stf StopwordsTokenFilter) AsLengthTokenFilter() (*LengthTokenFilter, bool) {
	return nil, false
}

// AsLimitTokenFilter is the BasicTokenFilter implementation for StopwordsTokenFilter.
func (stf StopwordsTokenFilter) AsLimitTokenFilter() (*LimitTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilter is the BasicTokenFilter implementation for StopwordsTokenFilter.
func (stf StopwordsTokenFilter) AsNGramTokenFilter() (*NGramTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilterV2 is the BasicTokenFilter implementation for StopwordsTokenFilter.
func (stf StopwordsTokenFilter) AsNGramTokenFilterV2() (*NGramTokenFilterV2, bool) {
	return nil, false
}

// AsPatternCaptureTokenFilter is the BasicTokenFilter implementation for StopwordsTokenFilter.
func (stf StopwordsTokenFilter) AsPatternCaptureTokenFilter() (*PatternCaptureTokenFilter, bool) {
	return nil, false
}

// AsPatternReplaceTokenFilter is the BasicTokenFilter implementation for StopwordsTokenFilter.
func (stf StopwordsTokenFilter) AsPatternReplaceTokenFilter() (*PatternReplaceTokenFilter, bool) {
	return nil, false
}

// AsPhoneticTokenFilter is the BasicTokenFilter implementation for StopwordsTokenFilter.
func (stf StopwordsTokenFilter) AsPhoneticTokenFilter() (*PhoneticTokenFilter, bool) {
	return nil, false
}

// AsShingleTokenFilter is the BasicTokenFilter implementation for StopwordsTokenFilter.
func (stf StopwordsTokenFilter) AsShingleTokenFilter() (*ShingleTokenFilter, bool) {
	return nil, false
}

// AsSnowballTokenFilter is the BasicTokenFilter implementation for StopwordsTokenFilter.
func (stf StopwordsTokenFilter) AsSnowballTokenFilter() (*SnowballTokenFilter, bool) {
	return nil, false
}

// AsStemmerTokenFilter is the BasicTokenFilter implementation for StopwordsTokenFilter.
func (stf StopwordsTokenFilter) AsStemmerTokenFilter() (*StemmerTokenFilter, bool) {
	return nil, false
}

// AsStemmerOverrideTokenFilter is the BasicTokenFilter implementation for StopwordsTokenFilter.
func (stf StopwordsTokenFilter) AsStemmerOverrideTokenFilter() (*StemmerOverrideTokenFilter, bool) {
	return nil, false
}

// AsStopwordsTokenFilter is the BasicTokenFilter implementation for StopwordsTokenFilter.
func (stf StopwordsTokenFilter) AsStopwordsTokenFilter() (*StopwordsTokenFilter, bool) {
	return &stf, true
}

// AsSynonymTokenFilter is the BasicTokenFilter implementation for StopwordsTokenFilter.
func (stf StopwordsTokenFilter) AsSynonymTokenFilter() (*SynonymTokenFilter, bool) {
	return nil, false
}

// AsTruncateTokenFilter is the BasicTokenFilter implementation for StopwordsTokenFilter.
func (stf StopwordsTokenFilter) AsTruncateTokenFilter() (*TruncateTokenFilter, bool) {
	return nil, false
}

// AsUniqueTokenFilter is the BasicTokenFilter implementation for StopwordsTokenFilter.
func (stf StopwordsTokenFilter) AsUniqueTokenFilter() (*UniqueTokenFilter, bool) {
	return nil, false
}

// AsWordDelimiterTokenFilter is the BasicTokenFilter implementation for StopwordsTokenFilter.
func (stf StopwordsTokenFilter) AsWordDelimiterTokenFilter() (*WordDelimiterTokenFilter, bool) {
	return nil, false
}

// AsTokenFilter is the BasicTokenFilter implementation for StopwordsTokenFilter.
func (stf StopwordsTokenFilter) AsTokenFilter() (*TokenFilter, bool) {
	return nil, false
}

// AsBasicTokenFilter is the BasicTokenFilter implementation for StopwordsTokenFilter.
func (stf StopwordsTokenFilter) AsBasicTokenFilter() (BasicTokenFilter, bool) {
	return &stf, true
}

// Suggester defines how the Suggest API should apply to a group of fields in the index.
type Suggester struct {
	// Name - The name of the suggester.
	Name *string `json:"name,omitempty"`
	// SearchMode - A value indicating the capabilities of the suggester.
	SearchMode *string `json:"searchMode,omitempty"`
	// SourceFields - The list of field names to which the suggester applies. Each field must be searchable.
	SourceFields *[]string `json:"sourceFields,omitempty"`
}

// SuggestParametersPayload parameters for filtering, sorting, fuzzy matching, and other suggestions query behaviors.
type SuggestParametersPayload struct {
	// Filter - The OData $filter expression to apply to the suggestions query.
	Filter *string `json:"filter,omitempty"`
	// Fuzzy - A value indicating whether to use fuzzy matching for the suggestion query. Default is false. when set to true, the query will find suggestions even if there's a substituted or missing character in the search text. While this provides a better experience in some scenarios it comes at a performance cost as fuzzy suggestion searches are slower and consume more resources.
	Fuzzy *bool `json:"fuzzy,omitempty"`
	// HighlightPostTag - A string tag that is appended to hit highlights. Must be set with HighlightPreTag. If omitted, hit highlighting of suggestions is disabled.
	HighlightPostTag *string `json:"highlightPostTag,omitempty"`
	// HighlightPreTag - A string tag that is prepended to hit highlights. Must be set with HighlightPostTag. If omitted, hit highlighting of suggestions is disabled.
	HighlightPreTag *string `json:"highlightPreTag,omitempty"`
	// MinimumCoverage - A number between 0 and 100 indicating the percentage of the index that must be covered by a suggestion query in order for the query to be reported as a success. This parameter can be useful for ensuring search availability even for services with only one replica. The default is 80.
	MinimumCoverage *float64 `json:"minimumCoverage,omitempty"`
	// OrderBy - The comma-separated list of OData $orderby expressions by which to sort the results. Each expression can be either a field name or a call to the geo.distance() function. Each expression can be followed by asc to indicate ascending, and desc to indicate descending. The default is ascending order. Ties will be broken by the match scores of documents. If no OrderBy is specified, the default sort order is descending by document match score. There can be at most 32 Orderby clauses.
	OrderBy *string `json:"orderby,omitempty"`
	// SearchProperty - The search text on which to base suggestions.
	SearchProperty *string `json:"search,omitempty"`
	// SearchFields - The comma-separated list of field names to consider when querying for suggestions.
	SearchFields *string `json:"searchFields,omitempty"`
	// Select - The comma-separated list of fields to retrieve. If unspecified, all fields marked as retrievable in the schema are included.
	Select *string `json:"select,omitempty"`
	// SuggesterName - The name of the suggester as specified in the suggesters collection that's part of the index definition.
	SuggesterName *string `json:"suggesterName,omitempty"`
	// Top - The number of suggestions to retrieve. This must be a value between 1 and 100. The default is to 5.
	Top *int32 `json:"top,omitempty"`
}

// SynonymTokenFilter matches single or multi-word synonyms in a token stream. This token filter is implemented using
// Apache Lucene.
type SynonymTokenFilter struct {
	// Name - The name of the token filter. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeTokenFilter', 'OdataTypeMicrosoftAzureSearchASCIIFoldingTokenFilter', 'OdataTypeMicrosoftAzureSearchCjkBigramTokenFilter', 'OdataTypeMicrosoftAzureSearchCommonGramTokenFilter', 'OdataTypeMicrosoftAzureSearchDictionaryDecompounderTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchElisionTokenFilter', 'OdataTypeMicrosoftAzureSearchKeepTokenFilter', 'OdataTypeMicrosoftAzureSearchKeywordMarkerTokenFilter', 'OdataTypeMicrosoftAzureSearchLengthTokenFilter', 'OdataTypeMicrosoftAzureSearchLimitTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchPatternCaptureTokenFilter', 'OdataTypeMicrosoftAzureSearchPatternReplaceTokenFilter', 'OdataTypeMicrosoftAzureSearchPhoneticTokenFilter', 'OdataTypeMicrosoftAzureSearchShingleTokenFilter', 'OdataTypeMicrosoftAzureSearchSnowballTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerOverrideTokenFilter', 'OdataTypeMicrosoftAzureSearchStopwordsTokenFilter', 'OdataTypeMicrosoftAzureSearchSynonymTokenFilter', 'OdataTypeMicrosoftAzureSearchTruncateTokenFilter', 'OdataTypeMicrosoftAzureSearchUniqueTokenFilter', 'OdataTypeMicrosoftAzureSearchWordDelimiterTokenFilter'
	OdataType OdataTypeBasicTokenFilter `json:"@odata.type,omitempty"`
	// Synonyms - A list of synonyms in following one of two formats: 1. incredible, unbelievable, fabulous => amazing - all terms on the left side of => symbol will be replaced with all terms on its right side; 2. incredible, unbelievable, fabulous, amazing - comma separated list of equivalent words. Set the expand option to change how this list is interpreted.
	Synonyms *[]string `json:"synonyms,omitempty"`
	// IgnoreCase - A value indicating whether to case-fold input for matching. Default is false.
	IgnoreCase *bool `json:"ignoreCase,omitempty"`
	// Expand - A value indicating whether all words in the list of synonyms (if => notation is not used) will map to one another. If true, all words in the list of synonyms (if => notation is not used) will map to one another. The following list: incredible, unbelievable, fabulous, amazing is equivalent to: incredible, unbelievable, fabulous, amazing => incredible, unbelievable, fabulous, amazing. If false, the following list: incredible, unbelievable, fabulous, amazing will be equivalent to: incredible, unbelievable, fabulous, amazing => incredible. Default is true.
	Expand *bool `json:"expand,omitempty"`
}

// MarshalJSON is the custom marshaler for SynonymTokenFilter.
func (stf SynonymTokenFilter) MarshalJSON() ([]byte, error) {
	stf.OdataType = OdataTypeMicrosoftAzureSearchSynonymTokenFilter
	type Alias SynonymTokenFilter
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(stf),
	})
}

// AsASCIIFoldingTokenFilter is the BasicTokenFilter implementation for SynonymTokenFilter.
func (stf SynonymTokenFilter) AsASCIIFoldingTokenFilter() (*ASCIIFoldingTokenFilter, bool) {
	return nil, false
}

// AsCjkBigramTokenFilter is the BasicTokenFilter implementation for SynonymTokenFilter.
func (stf SynonymTokenFilter) AsCjkBigramTokenFilter() (*CjkBigramTokenFilter, bool) {
	return nil, false
}

// AsCommonGramTokenFilter is the BasicTokenFilter implementation for SynonymTokenFilter.
func (stf SynonymTokenFilter) AsCommonGramTokenFilter() (*CommonGramTokenFilter, bool) {
	return nil, false
}

// AsDictionaryDecompounderTokenFilter is the BasicTokenFilter implementation for SynonymTokenFilter.
func (stf SynonymTokenFilter) AsDictionaryDecompounderTokenFilter() (*DictionaryDecompounderTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilter is the BasicTokenFilter implementation for SynonymTokenFilter.
func (stf SynonymTokenFilter) AsEdgeNGramTokenFilter() (*EdgeNGramTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilterV2 is the BasicTokenFilter implementation for SynonymTokenFilter.
func (stf SynonymTokenFilter) AsEdgeNGramTokenFilterV2() (*EdgeNGramTokenFilterV2, bool) {
	return nil, false
}

// AsElisionTokenFilter is the BasicTokenFilter implementation for SynonymTokenFilter.
func (stf SynonymTokenFilter) AsElisionTokenFilter() (*ElisionTokenFilter, bool) {
	return nil, false
}

// AsKeepTokenFilter is the BasicTokenFilter implementation for SynonymTokenFilter.
func (stf SynonymTokenFilter) AsKeepTokenFilter() (*KeepTokenFilter, bool) {
	return nil, false
}

// AsKeywordMarkerTokenFilter is the BasicTokenFilter implementation for SynonymTokenFilter.
func (stf SynonymTokenFilter) AsKeywordMarkerTokenFilter() (*KeywordMarkerTokenFilter, bool) {
	return nil, false
}

// AsLengthTokenFilter is the BasicTokenFilter implementation for SynonymTokenFilter.
func (stf SynonymTokenFilter) AsLengthTokenFilter() (*LengthTokenFilter, bool) {
	return nil, false
}

// AsLimitTokenFilter is the BasicTokenFilter implementation for SynonymTokenFilter.
func (stf SynonymTokenFilter) AsLimitTokenFilter() (*LimitTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilter is the BasicTokenFilter implementation for SynonymTokenFilter.
func (stf SynonymTokenFilter) AsNGramTokenFilter() (*NGramTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilterV2 is the BasicTokenFilter implementation for SynonymTokenFilter.
func (stf SynonymTokenFilter) AsNGramTokenFilterV2() (*NGramTokenFilterV2, bool) {
	return nil, false
}

// AsPatternCaptureTokenFilter is the BasicTokenFilter implementation for SynonymTokenFilter.
func (stf SynonymTokenFilter) AsPatternCaptureTokenFilter() (*PatternCaptureTokenFilter, bool) {
	return nil, false
}

// AsPatternReplaceTokenFilter is the BasicTokenFilter implementation for SynonymTokenFilter.
func (stf SynonymTokenFilter) AsPatternReplaceTokenFilter() (*PatternReplaceTokenFilter, bool) {
	return nil, false
}

// AsPhoneticTokenFilter is the BasicTokenFilter implementation for SynonymTokenFilter.
func (stf SynonymTokenFilter) AsPhoneticTokenFilter() (*PhoneticTokenFilter, bool) {
	return nil, false
}

// AsShingleTokenFilter is the BasicTokenFilter implementation for SynonymTokenFilter.
func (stf SynonymTokenFilter) AsShingleTokenFilter() (*ShingleTokenFilter, bool) {
	return nil, false
}

// AsSnowballTokenFilter is the BasicTokenFilter implementation for SynonymTokenFilter.
func (stf SynonymTokenFilter) AsSnowballTokenFilter() (*SnowballTokenFilter, bool) {
	return nil, false
}

// AsStemmerTokenFilter is the BasicTokenFilter implementation for SynonymTokenFilter.
func (stf SynonymTokenFilter) AsStemmerTokenFilter() (*StemmerTokenFilter, bool) {
	return nil, false
}

// AsStemmerOverrideTokenFilter is the BasicTokenFilter implementation for SynonymTokenFilter.
func (stf SynonymTokenFilter) AsStemmerOverrideTokenFilter() (*StemmerOverrideTokenFilter, bool) {
	return nil, false
}

// AsStopwordsTokenFilter is the BasicTokenFilter implementation for SynonymTokenFilter.
func (stf SynonymTokenFilter) AsStopwordsTokenFilter() (*StopwordsTokenFilter, bool) {
	return nil, false
}

// AsSynonymTokenFilter is the BasicTokenFilter implementation for SynonymTokenFilter.
func (stf SynonymTokenFilter) AsSynonymTokenFilter() (*SynonymTokenFilter, bool) {
	return &stf, true
}

// AsTruncateTokenFilter is the BasicTokenFilter implementation for SynonymTokenFilter.
func (stf SynonymTokenFilter) AsTruncateTokenFilter() (*TruncateTokenFilter, bool) {
	return nil, false
}

// AsUniqueTokenFilter is the BasicTokenFilter implementation for SynonymTokenFilter.
func (stf SynonymTokenFilter) AsUniqueTokenFilter() (*UniqueTokenFilter, bool) {
	return nil, false
}

// AsWordDelimiterTokenFilter is the BasicTokenFilter implementation for SynonymTokenFilter.
func (stf SynonymTokenFilter) AsWordDelimiterTokenFilter() (*WordDelimiterTokenFilter, bool) {
	return nil, false
}

// AsTokenFilter is the BasicTokenFilter implementation for SynonymTokenFilter.
func (stf SynonymTokenFilter) AsTokenFilter() (*TokenFilter, bool) {
	return nil, false
}

// AsBasicTokenFilter is the BasicTokenFilter implementation for SynonymTokenFilter.
func (stf SynonymTokenFilter) AsBasicTokenFilter() (BasicTokenFilter, bool) {
	return &stf, true
}

// TagScoringFunction defines a function that boosts scores of documents with string values matching a given list of
// tags.
type TagScoringFunction struct {
	// FieldName - The name of the field used as input to the scoring function.
	FieldName *string `json:"fieldName,omitempty"`
	// Boost - A multiplier for the raw score. Must be a positive number not equal to 1.0.
	Boost *float64 `json:"boost,omitempty"`
	// Interpolation - A value indicating how boosting will be interpolated across document scores; defaults to "Linear". Possible values include: 'Linear', 'Constant', 'Quadratic', 'Logarithmic'
	Interpolation ScoringFunctionInterpolation `json:"interpolation,omitempty"`
	// Type - Possible values include: 'TypeScoringFunction', 'TypeDistance', 'TypeFreshness', 'TypeMagnitude', 'TypeTag'
	Type Type `json:"type,omitempty"`
	// Parameters - Parameter values for the tag scoring function.
	Parameters *TagScoringParameters `json:"tag,omitempty"`
}

// MarshalJSON is the custom marshaler for TagScoringFunction.
func (tsf TagScoringFunction) MarshalJSON() ([]byte, error) {
	tsf.Type = TypeTag
	type Alias TagScoringFunction
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(tsf),
	})
}

// AsDistanceScoringFunction is the BasicScoringFunction implementation for TagScoringFunction.
func (tsf TagScoringFunction) AsDistanceScoringFunction() (*DistanceScoringFunction, bool) {
	return nil, false
}

// AsFreshnessScoringFunction is the BasicScoringFunction implementation for TagScoringFunction.
func (tsf TagScoringFunction) AsFreshnessScoringFunction() (*FreshnessScoringFunction, bool) {
	return nil, false
}

// AsMagnitudeScoringFunction is the BasicScoringFunction implementation for TagScoringFunction.
func (tsf TagScoringFunction) AsMagnitudeScoringFunction() (*MagnitudeScoringFunction, bool) {
	return nil, false
}

// AsTagScoringFunction is the BasicScoringFunction implementation for TagScoringFunction.
func (tsf TagScoringFunction) AsTagScoringFunction() (*TagScoringFunction, bool) {
	return &tsf, true
}

// AsScoringFunction is the BasicScoringFunction implementation for TagScoringFunction.
func (tsf TagScoringFunction) AsScoringFunction() (*ScoringFunction, bool) {
	return nil, false
}

// AsBasicScoringFunction is the BasicScoringFunction implementation for TagScoringFunction.
func (tsf TagScoringFunction) AsBasicScoringFunction() (BasicScoringFunction, bool) {
	return &tsf, true
}

// TagScoringParameters provides parameter values to a tag scoring function.
type TagScoringParameters struct {
	// TagsParameter - The name of the parameter passed in search queries to specify the list of tags to compare against the target field.
	TagsParameter *string `json:"tagsParameter,omitempty"`
}

// TextWeights defines weights on index fields for which matches should boost scoring in search queries.
type TextWeights struct {
	// Weights - The dictionary of per-field weights to boost document scoring. The keys are field names and the values are the weights for each field.
	Weights *map[string]*float64 `json:"weights,omitempty"`
}

// BasicTokenFilter abstract base class for token filters.
type BasicTokenFilter interface {
	AsASCIIFoldingTokenFilter() (*ASCIIFoldingTokenFilter, bool)
	AsCjkBigramTokenFilter() (*CjkBigramTokenFilter, bool)
	AsCommonGramTokenFilter() (*CommonGramTokenFilter, bool)
	AsDictionaryDecompounderTokenFilter() (*DictionaryDecompounderTokenFilter, bool)
	AsEdgeNGramTokenFilter() (*EdgeNGramTokenFilter, bool)
	AsEdgeNGramTokenFilterV2() (*EdgeNGramTokenFilterV2, bool)
	AsElisionTokenFilter() (*ElisionTokenFilter, bool)
	AsKeepTokenFilter() (*KeepTokenFilter, bool)
	AsKeywordMarkerTokenFilter() (*KeywordMarkerTokenFilter, bool)
	AsLengthTokenFilter() (*LengthTokenFilter, bool)
	AsLimitTokenFilter() (*LimitTokenFilter, bool)
	AsNGramTokenFilter() (*NGramTokenFilter, bool)
	AsNGramTokenFilterV2() (*NGramTokenFilterV2, bool)
	AsPatternCaptureTokenFilter() (*PatternCaptureTokenFilter, bool)
	AsPatternReplaceTokenFilter() (*PatternReplaceTokenFilter, bool)
	AsPhoneticTokenFilter() (*PhoneticTokenFilter, bool)
	AsShingleTokenFilter() (*ShingleTokenFilter, bool)
	AsSnowballTokenFilter() (*SnowballTokenFilter, bool)
	AsStemmerTokenFilter() (*StemmerTokenFilter, bool)
	AsStemmerOverrideTokenFilter() (*StemmerOverrideTokenFilter, bool)
	AsStopwordsTokenFilter() (*StopwordsTokenFilter, bool)
	AsSynonymTokenFilter() (*SynonymTokenFilter, bool)
	AsTruncateTokenFilter() (*TruncateTokenFilter, bool)
	AsUniqueTokenFilter() (*UniqueTokenFilter, bool)
	AsWordDelimiterTokenFilter() (*WordDelimiterTokenFilter, bool)
	AsTokenFilter() (*TokenFilter, bool)
}

// TokenFilter abstract base class for token filters.
type TokenFilter struct {
	// Name - The name of the token filter. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeTokenFilter', 'OdataTypeMicrosoftAzureSearchASCIIFoldingTokenFilter', 'OdataTypeMicrosoftAzureSearchCjkBigramTokenFilter', 'OdataTypeMicrosoftAzureSearchCommonGramTokenFilter', 'OdataTypeMicrosoftAzureSearchDictionaryDecompounderTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchElisionTokenFilter', 'OdataTypeMicrosoftAzureSearchKeepTokenFilter', 'OdataTypeMicrosoftAzureSearchKeywordMarkerTokenFilter', 'OdataTypeMicrosoftAzureSearchLengthTokenFilter', 'OdataTypeMicrosoftAzureSearchLimitTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchPatternCaptureTokenFilter', 'OdataTypeMicrosoftAzureSearchPatternReplaceTokenFilter', 'OdataTypeMicrosoftAzureSearchPhoneticTokenFilter', 'OdataTypeMicrosoftAzureSearchShingleTokenFilter', 'OdataTypeMicrosoftAzureSearchSnowballTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerOverrideTokenFilter', 'OdataTypeMicrosoftAzureSearchStopwordsTokenFilter', 'OdataTypeMicrosoftAzureSearchSynonymTokenFilter', 'OdataTypeMicrosoftAzureSearchTruncateTokenFilter', 'OdataTypeMicrosoftAzureSearchUniqueTokenFilter', 'OdataTypeMicrosoftAzureSearchWordDelimiterTokenFilter'
	OdataType OdataTypeBasicTokenFilter `json:"@odata.type,omitempty"`
}

func unmarshalBasicTokenFilter(body []byte) (BasicTokenFilter, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@odata.type"] {
	case string(OdataTypeMicrosoftAzureSearchASCIIFoldingTokenFilter):
		var aftf ASCIIFoldingTokenFilter
		err := json.Unmarshal(body, &aftf)
		return aftf, err
	case string(OdataTypeMicrosoftAzureSearchCjkBigramTokenFilter):
		var cbtf CjkBigramTokenFilter
		err := json.Unmarshal(body, &cbtf)
		return cbtf, err
	case string(OdataTypeMicrosoftAzureSearchCommonGramTokenFilter):
		var cgtf CommonGramTokenFilter
		err := json.Unmarshal(body, &cgtf)
		return cgtf, err
	case string(OdataTypeMicrosoftAzureSearchDictionaryDecompounderTokenFilter):
		var ddtf DictionaryDecompounderTokenFilter
		err := json.Unmarshal(body, &ddtf)
		return ddtf, err
	case string(OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilter):
		var engtf EdgeNGramTokenFilter
		err := json.Unmarshal(body, &engtf)
		return engtf, err
	case string(OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilterV2):
		var engtfv EdgeNGramTokenFilterV2
		err := json.Unmarshal(body, &engtfv)
		return engtfv, err
	case string(OdataTypeMicrosoftAzureSearchElisionTokenFilter):
		var etf ElisionTokenFilter
		err := json.Unmarshal(body, &etf)
		return etf, err
	case string(OdataTypeMicrosoftAzureSearchKeepTokenFilter):
		var ktf KeepTokenFilter
		err := json.Unmarshal(body, &ktf)
		return ktf, err
	case string(OdataTypeMicrosoftAzureSearchKeywordMarkerTokenFilter):
		var kmtf KeywordMarkerTokenFilter
		err := json.Unmarshal(body, &kmtf)
		return kmtf, err
	case string(OdataTypeMicrosoftAzureSearchLengthTokenFilter):
		var ltf LengthTokenFilter
		err := json.Unmarshal(body, &ltf)
		return ltf, err
	case string(OdataTypeMicrosoftAzureSearchLimitTokenFilter):
		var ltf LimitTokenFilter
		err := json.Unmarshal(body, &ltf)
		return ltf, err
	case string(OdataTypeMicrosoftAzureSearchNGramTokenFilter):
		var ngtf NGramTokenFilter
		err := json.Unmarshal(body, &ngtf)
		return ngtf, err
	case string(OdataTypeMicrosoftAzureSearchNGramTokenFilterV2):
		var ngtfv NGramTokenFilterV2
		err := json.Unmarshal(body, &ngtfv)
		return ngtfv, err
	case string(OdataTypeMicrosoftAzureSearchPatternCaptureTokenFilter):
		var pctf PatternCaptureTokenFilter
		err := json.Unmarshal(body, &pctf)
		return pctf, err
	case string(OdataTypeMicrosoftAzureSearchPatternReplaceTokenFilter):
		var prtf PatternReplaceTokenFilter
		err := json.Unmarshal(body, &prtf)
		return prtf, err
	case string(OdataTypeMicrosoftAzureSearchPhoneticTokenFilter):
		var ptf PhoneticTokenFilter
		err := json.Unmarshal(body, &ptf)
		return ptf, err
	case string(OdataTypeMicrosoftAzureSearchShingleTokenFilter):
		var stf ShingleTokenFilter
		err := json.Unmarshal(body, &stf)
		return stf, err
	case string(OdataTypeMicrosoftAzureSearchSnowballTokenFilter):
		var stf SnowballTokenFilter
		err := json.Unmarshal(body, &stf)
		return stf, err
	case string(OdataTypeMicrosoftAzureSearchStemmerTokenFilter):
		var stf StemmerTokenFilter
		err := json.Unmarshal(body, &stf)
		return stf, err
	case string(OdataTypeMicrosoftAzureSearchStemmerOverrideTokenFilter):
		var sotf StemmerOverrideTokenFilter
		err := json.Unmarshal(body, &sotf)
		return sotf, err
	case string(OdataTypeMicrosoftAzureSearchStopwordsTokenFilter):
		var stf StopwordsTokenFilter
		err := json.Unmarshal(body, &stf)
		return stf, err
	case string(OdataTypeMicrosoftAzureSearchSynonymTokenFilter):
		var stf SynonymTokenFilter
		err := json.Unmarshal(body, &stf)
		return stf, err
	case string(OdataTypeMicrosoftAzureSearchTruncateTokenFilter):
		var ttf TruncateTokenFilter
		err := json.Unmarshal(body, &ttf)
		return ttf, err
	case string(OdataTypeMicrosoftAzureSearchUniqueTokenFilter):
		var utf UniqueTokenFilter
		err := json.Unmarshal(body, &utf)
		return utf, err
	case string(OdataTypeMicrosoftAzureSearchWordDelimiterTokenFilter):
		var wdtf WordDelimiterTokenFilter
		err := json.Unmarshal(body, &wdtf)
		return wdtf, err
	default:
		var tf TokenFilter
		err := json.Unmarshal(body, &tf)
		return tf, err
	}
}
func unmarshalBasicTokenFilterArray(body []byte) ([]BasicTokenFilter, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	tfArray := make([]BasicTokenFilter, len(rawMessages))

	for index, rawMessage := range rawMessages {
		tf, err := unmarshalBasicTokenFilter(*rawMessage)
		if err != nil {
			return nil, err
		}
		tfArray[index] = tf
	}
	return tfArray, nil
}

// MarshalJSON is the custom marshaler for TokenFilter.
func (tf TokenFilter) MarshalJSON() ([]byte, error) {
	tf.OdataType = OdataTypeTokenFilter
	type Alias TokenFilter
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(tf),
	})
}

// AsASCIIFoldingTokenFilter is the BasicTokenFilter implementation for TokenFilter.
func (tf TokenFilter) AsASCIIFoldingTokenFilter() (*ASCIIFoldingTokenFilter, bool) {
	return nil, false
}

// AsCjkBigramTokenFilter is the BasicTokenFilter implementation for TokenFilter.
func (tf TokenFilter) AsCjkBigramTokenFilter() (*CjkBigramTokenFilter, bool) {
	return nil, false
}

// AsCommonGramTokenFilter is the BasicTokenFilter implementation for TokenFilter.
func (tf TokenFilter) AsCommonGramTokenFilter() (*CommonGramTokenFilter, bool) {
	return nil, false
}

// AsDictionaryDecompounderTokenFilter is the BasicTokenFilter implementation for TokenFilter.
func (tf TokenFilter) AsDictionaryDecompounderTokenFilter() (*DictionaryDecompounderTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilter is the BasicTokenFilter implementation for TokenFilter.
func (tf TokenFilter) AsEdgeNGramTokenFilter() (*EdgeNGramTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilterV2 is the BasicTokenFilter implementation for TokenFilter.
func (tf TokenFilter) AsEdgeNGramTokenFilterV2() (*EdgeNGramTokenFilterV2, bool) {
	return nil, false
}

// AsElisionTokenFilter is the BasicTokenFilter implementation for TokenFilter.
func (tf TokenFilter) AsElisionTokenFilter() (*ElisionTokenFilter, bool) {
	return nil, false
}

// AsKeepTokenFilter is the BasicTokenFilter implementation for TokenFilter.
func (tf TokenFilter) AsKeepTokenFilter() (*KeepTokenFilter, bool) {
	return nil, false
}

// AsKeywordMarkerTokenFilter is the BasicTokenFilter implementation for TokenFilter.
func (tf TokenFilter) AsKeywordMarkerTokenFilter() (*KeywordMarkerTokenFilter, bool) {
	return nil, false
}

// AsLengthTokenFilter is the BasicTokenFilter implementation for TokenFilter.
func (tf TokenFilter) AsLengthTokenFilter() (*LengthTokenFilter, bool) {
	return nil, false
}

// AsLimitTokenFilter is the BasicTokenFilter implementation for TokenFilter.
func (tf TokenFilter) AsLimitTokenFilter() (*LimitTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilter is the BasicTokenFilter implementation for TokenFilter.
func (tf TokenFilter) AsNGramTokenFilter() (*NGramTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilterV2 is the BasicTokenFilter implementation for TokenFilter.
func (tf TokenFilter) AsNGramTokenFilterV2() (*NGramTokenFilterV2, bool) {
	return nil, false
}

// AsPatternCaptureTokenFilter is the BasicTokenFilter implementation for TokenFilter.
func (tf TokenFilter) AsPatternCaptureTokenFilter() (*PatternCaptureTokenFilter, bool) {
	return nil, false
}

// AsPatternReplaceTokenFilter is the BasicTokenFilter implementation for TokenFilter.
func (tf TokenFilter) AsPatternReplaceTokenFilter() (*PatternReplaceTokenFilter, bool) {
	return nil, false
}

// AsPhoneticTokenFilter is the BasicTokenFilter implementation for TokenFilter.
func (tf TokenFilter) AsPhoneticTokenFilter() (*PhoneticTokenFilter, bool) {
	return nil, false
}

// AsShingleTokenFilter is the BasicTokenFilter implementation for TokenFilter.
func (tf TokenFilter) AsShingleTokenFilter() (*ShingleTokenFilter, bool) {
	return nil, false
}

// AsSnowballTokenFilter is the BasicTokenFilter implementation for TokenFilter.
func (tf TokenFilter) AsSnowballTokenFilter() (*SnowballTokenFilter, bool) {
	return nil, false
}

// AsStemmerTokenFilter is the BasicTokenFilter implementation for TokenFilter.
func (tf TokenFilter) AsStemmerTokenFilter() (*StemmerTokenFilter, bool) {
	return nil, false
}

// AsStemmerOverrideTokenFilter is the BasicTokenFilter implementation for TokenFilter.
func (tf TokenFilter) AsStemmerOverrideTokenFilter() (*StemmerOverrideTokenFilter, bool) {
	return nil, false
}

// AsStopwordsTokenFilter is the BasicTokenFilter implementation for TokenFilter.
func (tf TokenFilter) AsStopwordsTokenFilter() (*StopwordsTokenFilter, bool) {
	return nil, false
}

// AsSynonymTokenFilter is the BasicTokenFilter implementation for TokenFilter.
func (tf TokenFilter) AsSynonymTokenFilter() (*SynonymTokenFilter, bool) {
	return nil, false
}

// AsTruncateTokenFilter is the BasicTokenFilter implementation for TokenFilter.
func (tf TokenFilter) AsTruncateTokenFilter() (*TruncateTokenFilter, bool) {
	return nil, false
}

// AsUniqueTokenFilter is the BasicTokenFilter implementation for TokenFilter.
func (tf TokenFilter) AsUniqueTokenFilter() (*UniqueTokenFilter, bool) {
	return nil, false
}

// AsWordDelimiterTokenFilter is the BasicTokenFilter implementation for TokenFilter.
func (tf TokenFilter) AsWordDelimiterTokenFilter() (*WordDelimiterTokenFilter, bool) {
	return nil, false
}

// AsTokenFilter is the BasicTokenFilter implementation for TokenFilter.
func (tf TokenFilter) AsTokenFilter() (*TokenFilter, bool) {
	return &tf, true
}

// AsBasicTokenFilter is the BasicTokenFilter implementation for TokenFilter.
func (tf TokenFilter) AsBasicTokenFilter() (BasicTokenFilter, bool) {
	return &tf, true
}

// TokenFilterName defines the names of all token filters supported by Azure Search.
type TokenFilterName struct {
	Name *string `json:"name,omitempty"`
}

// TokenInfo information about a token returned by an analyzer.
type TokenInfo struct {
	// Token - The token returned by the analyzer.
	Token *string `json:"token,omitempty"`
	// StartOffset - The index of the first character of the token in the input text.
	StartOffset *int32 `json:"startOffset,omitempty"`
	// EndOffset - The index of the last character of the token in the input text.
	EndOffset *int32 `json:"endOffset,omitempty"`
	// Position - The position of the token in the input text relative to other tokens. The first token in the input text has position 0, the next has position 1, and so on. Depending on the analyzer used, some tokens might have the same position, for example if they are synonyms of each other.
	Position *int32 `json:"position,omitempty"`
}

// BasicTokenizer abstract base class for tokenizers.
type BasicTokenizer interface {
	AsClassicTokenizer() (*ClassicTokenizer, bool)
	AsEdgeNGramTokenizer() (*EdgeNGramTokenizer, bool)
	AsKeywordTokenizer() (*KeywordTokenizer, bool)
	AsKeywordTokenizerV2() (*KeywordTokenizerV2, bool)
	AsMicrosoftLanguageTokenizer() (*MicrosoftLanguageTokenizer, bool)
	AsMicrosoftLanguageStemmingTokenizer() (*MicrosoftLanguageStemmingTokenizer, bool)
	AsNGramTokenizer() (*NGramTokenizer, bool)
	AsPathHierarchyTokenizer() (*PathHierarchyTokenizer, bool)
	AsPathHierarchyTokenizerV2() (*PathHierarchyTokenizerV2, bool)
	AsPatternTokenizer() (*PatternTokenizer, bool)
	AsStandardTokenizer() (*StandardTokenizer, bool)
	AsStandardTokenizerV2() (*StandardTokenizerV2, bool)
	AsUaxURLEmailTokenizer() (*UaxURLEmailTokenizer, bool)
	AsTokenizer() (*Tokenizer, bool)
}

// Tokenizer abstract base class for tokenizers.
type Tokenizer struct {
	// Name - The name of the tokenizer. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeTokenizer', 'OdataTypeMicrosoftAzureSearchClassicTokenizer', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenizer', 'OdataTypeMicrosoftAzureSearchKeywordTokenizer', 'OdataTypeMicrosoftAzureSearchKeywordTokenizerV2', 'OdataTypeMicrosoftAzureSearchMicrosoftLanguageTokenizer', 'OdataTypeMicrosoftAzureSearchMicrosoftLanguageStemmingTokenizer', 'OdataTypeMicrosoftAzureSearchNGramTokenizer', 'OdataTypeMicrosoftAzureSearchPathHierarchyTokenizer', 'OdataTypeMicrosoftAzureSearchPathHierarchyTokenizerV2', 'OdataTypeMicrosoftAzureSearchPatternTokenizer', 'OdataTypeMicrosoftAzureSearchStandardTokenizer', 'OdataTypeMicrosoftAzureSearchStandardTokenizerV2', 'OdataTypeMicrosoftAzureSearchUaxURLEmailTokenizer'
	OdataType OdataTypeBasicTokenizer `json:"@odata.type,omitempty"`
}

func unmarshalBasicTokenizer(body []byte) (BasicTokenizer, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@odata.type"] {
	case string(OdataTypeMicrosoftAzureSearchClassicTokenizer):
		var ct ClassicTokenizer
		err := json.Unmarshal(body, &ct)
		return ct, err
	case string(OdataTypeMicrosoftAzureSearchEdgeNGramTokenizer):
		var engt EdgeNGramTokenizer
		err := json.Unmarshal(body, &engt)
		return engt, err
	case string(OdataTypeMicrosoftAzureSearchKeywordTokenizer):
		var kt KeywordTokenizer
		err := json.Unmarshal(body, &kt)
		return kt, err
	case string(OdataTypeMicrosoftAzureSearchKeywordTokenizerV2):
		var ktv KeywordTokenizerV2
		err := json.Unmarshal(body, &ktv)
		return ktv, err
	case string(OdataTypeMicrosoftAzureSearchMicrosoftLanguageTokenizer):
		var mlt MicrosoftLanguageTokenizer
		err := json.Unmarshal(body, &mlt)
		return mlt, err
	case string(OdataTypeMicrosoftAzureSearchMicrosoftLanguageStemmingTokenizer):
		var mlst MicrosoftLanguageStemmingTokenizer
		err := json.Unmarshal(body, &mlst)
		return mlst, err
	case string(OdataTypeMicrosoftAzureSearchNGramTokenizer):
		var ngt NGramTokenizer
		err := json.Unmarshal(body, &ngt)
		return ngt, err
	case string(OdataTypeMicrosoftAzureSearchPathHierarchyTokenizer):
		var pht PathHierarchyTokenizer
		err := json.Unmarshal(body, &pht)
		return pht, err
	case string(OdataTypeMicrosoftAzureSearchPathHierarchyTokenizerV2):
		var phtv PathHierarchyTokenizerV2
		err := json.Unmarshal(body, &phtv)
		return phtv, err
	case string(OdataTypeMicrosoftAzureSearchPatternTokenizer):
		var pt PatternTokenizer
		err := json.Unmarshal(body, &pt)
		return pt, err
	case string(OdataTypeMicrosoftAzureSearchStandardTokenizer):
		var st StandardTokenizer
		err := json.Unmarshal(body, &st)
		return st, err
	case string(OdataTypeMicrosoftAzureSearchStandardTokenizerV2):
		var stv StandardTokenizerV2
		err := json.Unmarshal(body, &stv)
		return stv, err
	case string(OdataTypeMicrosoftAzureSearchUaxURLEmailTokenizer):
		var uuet UaxURLEmailTokenizer
		err := json.Unmarshal(body, &uuet)
		return uuet, err
	default:
		var t Tokenizer
		err := json.Unmarshal(body, &t)
		return t, err
	}
}
func unmarshalBasicTokenizerArray(body []byte) ([]BasicTokenizer, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	tArray := make([]BasicTokenizer, len(rawMessages))

	for index, rawMessage := range rawMessages {
		t, err := unmarshalBasicTokenizer(*rawMessage)
		if err != nil {
			return nil, err
		}
		tArray[index] = t
	}
	return tArray, nil
}

// MarshalJSON is the custom marshaler for Tokenizer.
func (t Tokenizer) MarshalJSON() ([]byte, error) {
	t.OdataType = OdataTypeTokenizer
	type Alias Tokenizer
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(t),
	})
}

// AsClassicTokenizer is the BasicTokenizer implementation for Tokenizer.
func (t Tokenizer) AsClassicTokenizer() (*ClassicTokenizer, bool) {
	return nil, false
}

// AsEdgeNGramTokenizer is the BasicTokenizer implementation for Tokenizer.
func (t Tokenizer) AsEdgeNGramTokenizer() (*EdgeNGramTokenizer, bool) {
	return nil, false
}

// AsKeywordTokenizer is the BasicTokenizer implementation for Tokenizer.
func (t Tokenizer) AsKeywordTokenizer() (*KeywordTokenizer, bool) {
	return nil, false
}

// AsKeywordTokenizerV2 is the BasicTokenizer implementation for Tokenizer.
func (t Tokenizer) AsKeywordTokenizerV2() (*KeywordTokenizerV2, bool) {
	return nil, false
}

// AsMicrosoftLanguageTokenizer is the BasicTokenizer implementation for Tokenizer.
func (t Tokenizer) AsMicrosoftLanguageTokenizer() (*MicrosoftLanguageTokenizer, bool) {
	return nil, false
}

// AsMicrosoftLanguageStemmingTokenizer is the BasicTokenizer implementation for Tokenizer.
func (t Tokenizer) AsMicrosoftLanguageStemmingTokenizer() (*MicrosoftLanguageStemmingTokenizer, bool) {
	return nil, false
}

// AsNGramTokenizer is the BasicTokenizer implementation for Tokenizer.
func (t Tokenizer) AsNGramTokenizer() (*NGramTokenizer, bool) {
	return nil, false
}

// AsPathHierarchyTokenizer is the BasicTokenizer implementation for Tokenizer.
func (t Tokenizer) AsPathHierarchyTokenizer() (*PathHierarchyTokenizer, bool) {
	return nil, false
}

// AsPathHierarchyTokenizerV2 is the BasicTokenizer implementation for Tokenizer.
func (t Tokenizer) AsPathHierarchyTokenizerV2() (*PathHierarchyTokenizerV2, bool) {
	return nil, false
}

// AsPatternTokenizer is the BasicTokenizer implementation for Tokenizer.
func (t Tokenizer) AsPatternTokenizer() (*PatternTokenizer, bool) {
	return nil, false
}

// AsStandardTokenizer is the BasicTokenizer implementation for Tokenizer.
func (t Tokenizer) AsStandardTokenizer() (*StandardTokenizer, bool) {
	return nil, false
}

// AsStandardTokenizerV2 is the BasicTokenizer implementation for Tokenizer.
func (t Tokenizer) AsStandardTokenizerV2() (*StandardTokenizerV2, bool) {
	return nil, false
}

// AsUaxURLEmailTokenizer is the BasicTokenizer implementation for Tokenizer.
func (t Tokenizer) AsUaxURLEmailTokenizer() (*UaxURLEmailTokenizer, bool) {
	return nil, false
}

// AsTokenizer is the BasicTokenizer implementation for Tokenizer.
func (t Tokenizer) AsTokenizer() (*Tokenizer, bool) {
	return &t, true
}

// AsBasicTokenizer is the BasicTokenizer implementation for Tokenizer.
func (t Tokenizer) AsBasicTokenizer() (BasicTokenizer, bool) {
	return &t, true
}

// TokenizerName defines the names of all tokenizers supported by Azure Search.
type TokenizerName struct {
	Name *string `json:"name,omitempty"`
}

// TruncateTokenFilter truncates the terms to a specific length. This token filter is implemented using Apache Lucene.
type TruncateTokenFilter struct {
	// Name - The name of the token filter. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeTokenFilter', 'OdataTypeMicrosoftAzureSearchASCIIFoldingTokenFilter', 'OdataTypeMicrosoftAzureSearchCjkBigramTokenFilter', 'OdataTypeMicrosoftAzureSearchCommonGramTokenFilter', 'OdataTypeMicrosoftAzureSearchDictionaryDecompounderTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchElisionTokenFilter', 'OdataTypeMicrosoftAzureSearchKeepTokenFilter', 'OdataTypeMicrosoftAzureSearchKeywordMarkerTokenFilter', 'OdataTypeMicrosoftAzureSearchLengthTokenFilter', 'OdataTypeMicrosoftAzureSearchLimitTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchPatternCaptureTokenFilter', 'OdataTypeMicrosoftAzureSearchPatternReplaceTokenFilter', 'OdataTypeMicrosoftAzureSearchPhoneticTokenFilter', 'OdataTypeMicrosoftAzureSearchShingleTokenFilter', 'OdataTypeMicrosoftAzureSearchSnowballTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerOverrideTokenFilter', 'OdataTypeMicrosoftAzureSearchStopwordsTokenFilter', 'OdataTypeMicrosoftAzureSearchSynonymTokenFilter', 'OdataTypeMicrosoftAzureSearchTruncateTokenFilter', 'OdataTypeMicrosoftAzureSearchUniqueTokenFilter', 'OdataTypeMicrosoftAzureSearchWordDelimiterTokenFilter'
	OdataType OdataTypeBasicTokenFilter `json:"@odata.type,omitempty"`
	// Length - The length at which terms will be truncated. Default and maximum is 300.
	Length *int32 `json:"length,omitempty"`
}

// MarshalJSON is the custom marshaler for TruncateTokenFilter.
func (ttf TruncateTokenFilter) MarshalJSON() ([]byte, error) {
	ttf.OdataType = OdataTypeMicrosoftAzureSearchTruncateTokenFilter
	type Alias TruncateTokenFilter
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ttf),
	})
}

// AsASCIIFoldingTokenFilter is the BasicTokenFilter implementation for TruncateTokenFilter.
func (ttf TruncateTokenFilter) AsASCIIFoldingTokenFilter() (*ASCIIFoldingTokenFilter, bool) {
	return nil, false
}

// AsCjkBigramTokenFilter is the BasicTokenFilter implementation for TruncateTokenFilter.
func (ttf TruncateTokenFilter) AsCjkBigramTokenFilter() (*CjkBigramTokenFilter, bool) {
	return nil, false
}

// AsCommonGramTokenFilter is the BasicTokenFilter implementation for TruncateTokenFilter.
func (ttf TruncateTokenFilter) AsCommonGramTokenFilter() (*CommonGramTokenFilter, bool) {
	return nil, false
}

// AsDictionaryDecompounderTokenFilter is the BasicTokenFilter implementation for TruncateTokenFilter.
func (ttf TruncateTokenFilter) AsDictionaryDecompounderTokenFilter() (*DictionaryDecompounderTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilter is the BasicTokenFilter implementation for TruncateTokenFilter.
func (ttf TruncateTokenFilter) AsEdgeNGramTokenFilter() (*EdgeNGramTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilterV2 is the BasicTokenFilter implementation for TruncateTokenFilter.
func (ttf TruncateTokenFilter) AsEdgeNGramTokenFilterV2() (*EdgeNGramTokenFilterV2, bool) {
	return nil, false
}

// AsElisionTokenFilter is the BasicTokenFilter implementation for TruncateTokenFilter.
func (ttf TruncateTokenFilter) AsElisionTokenFilter() (*ElisionTokenFilter, bool) {
	return nil, false
}

// AsKeepTokenFilter is the BasicTokenFilter implementation for TruncateTokenFilter.
func (ttf TruncateTokenFilter) AsKeepTokenFilter() (*KeepTokenFilter, bool) {
	return nil, false
}

// AsKeywordMarkerTokenFilter is the BasicTokenFilter implementation for TruncateTokenFilter.
func (ttf TruncateTokenFilter) AsKeywordMarkerTokenFilter() (*KeywordMarkerTokenFilter, bool) {
	return nil, false
}

// AsLengthTokenFilter is the BasicTokenFilter implementation for TruncateTokenFilter.
func (ttf TruncateTokenFilter) AsLengthTokenFilter() (*LengthTokenFilter, bool) {
	return nil, false
}

// AsLimitTokenFilter is the BasicTokenFilter implementation for TruncateTokenFilter.
func (ttf TruncateTokenFilter) AsLimitTokenFilter() (*LimitTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilter is the BasicTokenFilter implementation for TruncateTokenFilter.
func (ttf TruncateTokenFilter) AsNGramTokenFilter() (*NGramTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilterV2 is the BasicTokenFilter implementation for TruncateTokenFilter.
func (ttf TruncateTokenFilter) AsNGramTokenFilterV2() (*NGramTokenFilterV2, bool) {
	return nil, false
}

// AsPatternCaptureTokenFilter is the BasicTokenFilter implementation for TruncateTokenFilter.
func (ttf TruncateTokenFilter) AsPatternCaptureTokenFilter() (*PatternCaptureTokenFilter, bool) {
	return nil, false
}

// AsPatternReplaceTokenFilter is the BasicTokenFilter implementation for TruncateTokenFilter.
func (ttf TruncateTokenFilter) AsPatternReplaceTokenFilter() (*PatternReplaceTokenFilter, bool) {
	return nil, false
}

// AsPhoneticTokenFilter is the BasicTokenFilter implementation for TruncateTokenFilter.
func (ttf TruncateTokenFilter) AsPhoneticTokenFilter() (*PhoneticTokenFilter, bool) {
	return nil, false
}

// AsShingleTokenFilter is the BasicTokenFilter implementation for TruncateTokenFilter.
func (ttf TruncateTokenFilter) AsShingleTokenFilter() (*ShingleTokenFilter, bool) {
	return nil, false
}

// AsSnowballTokenFilter is the BasicTokenFilter implementation for TruncateTokenFilter.
func (ttf TruncateTokenFilter) AsSnowballTokenFilter() (*SnowballTokenFilter, bool) {
	return nil, false
}

// AsStemmerTokenFilter is the BasicTokenFilter implementation for TruncateTokenFilter.
func (ttf TruncateTokenFilter) AsStemmerTokenFilter() (*StemmerTokenFilter, bool) {
	return nil, false
}

// AsStemmerOverrideTokenFilter is the BasicTokenFilter implementation for TruncateTokenFilter.
func (ttf TruncateTokenFilter) AsStemmerOverrideTokenFilter() (*StemmerOverrideTokenFilter, bool) {
	return nil, false
}

// AsStopwordsTokenFilter is the BasicTokenFilter implementation for TruncateTokenFilter.
func (ttf TruncateTokenFilter) AsStopwordsTokenFilter() (*StopwordsTokenFilter, bool) {
	return nil, false
}

// AsSynonymTokenFilter is the BasicTokenFilter implementation for TruncateTokenFilter.
func (ttf TruncateTokenFilter) AsSynonymTokenFilter() (*SynonymTokenFilter, bool) {
	return nil, false
}

// AsTruncateTokenFilter is the BasicTokenFilter implementation for TruncateTokenFilter.
func (ttf TruncateTokenFilter) AsTruncateTokenFilter() (*TruncateTokenFilter, bool) {
	return &ttf, true
}

// AsUniqueTokenFilter is the BasicTokenFilter implementation for TruncateTokenFilter.
func (ttf TruncateTokenFilter) AsUniqueTokenFilter() (*UniqueTokenFilter, bool) {
	return nil, false
}

// AsWordDelimiterTokenFilter is the BasicTokenFilter implementation for TruncateTokenFilter.
func (ttf TruncateTokenFilter) AsWordDelimiterTokenFilter() (*WordDelimiterTokenFilter, bool) {
	return nil, false
}

// AsTokenFilter is the BasicTokenFilter implementation for TruncateTokenFilter.
func (ttf TruncateTokenFilter) AsTokenFilter() (*TokenFilter, bool) {
	return nil, false
}

// AsBasicTokenFilter is the BasicTokenFilter implementation for TruncateTokenFilter.
func (ttf TruncateTokenFilter) AsBasicTokenFilter() (BasicTokenFilter, bool) {
	return &ttf, true
}

// UaxURLEmailTokenizer tokenizes urls and emails as one token. This tokenizer is implemented using Apache Lucene.
type UaxURLEmailTokenizer struct {
	// Name - The name of the tokenizer. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeTokenizer', 'OdataTypeMicrosoftAzureSearchClassicTokenizer', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenizer', 'OdataTypeMicrosoftAzureSearchKeywordTokenizer', 'OdataTypeMicrosoftAzureSearchKeywordTokenizerV2', 'OdataTypeMicrosoftAzureSearchMicrosoftLanguageTokenizer', 'OdataTypeMicrosoftAzureSearchMicrosoftLanguageStemmingTokenizer', 'OdataTypeMicrosoftAzureSearchNGramTokenizer', 'OdataTypeMicrosoftAzureSearchPathHierarchyTokenizer', 'OdataTypeMicrosoftAzureSearchPathHierarchyTokenizerV2', 'OdataTypeMicrosoftAzureSearchPatternTokenizer', 'OdataTypeMicrosoftAzureSearchStandardTokenizer', 'OdataTypeMicrosoftAzureSearchStandardTokenizerV2', 'OdataTypeMicrosoftAzureSearchUaxURLEmailTokenizer'
	OdataType OdataTypeBasicTokenizer `json:"@odata.type,omitempty"`
	// MaxTokenLength - The maximum token length. Default is 255. Tokens longer than the maximum length are split. The maximum token length that can be used is 300 characters.
	MaxTokenLength *int32 `json:"maxTokenLength,omitempty"`
}

// MarshalJSON is the custom marshaler for UaxURLEmailTokenizer.
func (uuet UaxURLEmailTokenizer) MarshalJSON() ([]byte, error) {
	uuet.OdataType = OdataTypeMicrosoftAzureSearchUaxURLEmailTokenizer
	type Alias UaxURLEmailTokenizer
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(uuet),
	})
}

// AsClassicTokenizer is the BasicTokenizer implementation for UaxURLEmailTokenizer.
func (uuet UaxURLEmailTokenizer) AsClassicTokenizer() (*ClassicTokenizer, bool) {
	return nil, false
}

// AsEdgeNGramTokenizer is the BasicTokenizer implementation for UaxURLEmailTokenizer.
func (uuet UaxURLEmailTokenizer) AsEdgeNGramTokenizer() (*EdgeNGramTokenizer, bool) {
	return nil, false
}

// AsKeywordTokenizer is the BasicTokenizer implementation for UaxURLEmailTokenizer.
func (uuet UaxURLEmailTokenizer) AsKeywordTokenizer() (*KeywordTokenizer, bool) {
	return nil, false
}

// AsKeywordTokenizerV2 is the BasicTokenizer implementation for UaxURLEmailTokenizer.
func (uuet UaxURLEmailTokenizer) AsKeywordTokenizerV2() (*KeywordTokenizerV2, bool) {
	return nil, false
}

// AsMicrosoftLanguageTokenizer is the BasicTokenizer implementation for UaxURLEmailTokenizer.
func (uuet UaxURLEmailTokenizer) AsMicrosoftLanguageTokenizer() (*MicrosoftLanguageTokenizer, bool) {
	return nil, false
}

// AsMicrosoftLanguageStemmingTokenizer is the BasicTokenizer implementation for UaxURLEmailTokenizer.
func (uuet UaxURLEmailTokenizer) AsMicrosoftLanguageStemmingTokenizer() (*MicrosoftLanguageStemmingTokenizer, bool) {
	return nil, false
}

// AsNGramTokenizer is the BasicTokenizer implementation for UaxURLEmailTokenizer.
func (uuet UaxURLEmailTokenizer) AsNGramTokenizer() (*NGramTokenizer, bool) {
	return nil, false
}

// AsPathHierarchyTokenizer is the BasicTokenizer implementation for UaxURLEmailTokenizer.
func (uuet UaxURLEmailTokenizer) AsPathHierarchyTokenizer() (*PathHierarchyTokenizer, bool) {
	return nil, false
}

// AsPathHierarchyTokenizerV2 is the BasicTokenizer implementation for UaxURLEmailTokenizer.
func (uuet UaxURLEmailTokenizer) AsPathHierarchyTokenizerV2() (*PathHierarchyTokenizerV2, bool) {
	return nil, false
}

// AsPatternTokenizer is the BasicTokenizer implementation for UaxURLEmailTokenizer.
func (uuet UaxURLEmailTokenizer) AsPatternTokenizer() (*PatternTokenizer, bool) {
	return nil, false
}

// AsStandardTokenizer is the BasicTokenizer implementation for UaxURLEmailTokenizer.
func (uuet UaxURLEmailTokenizer) AsStandardTokenizer() (*StandardTokenizer, bool) {
	return nil, false
}

// AsStandardTokenizerV2 is the BasicTokenizer implementation for UaxURLEmailTokenizer.
func (uuet UaxURLEmailTokenizer) AsStandardTokenizerV2() (*StandardTokenizerV2, bool) {
	return nil, false
}

// AsUaxURLEmailTokenizer is the BasicTokenizer implementation for UaxURLEmailTokenizer.
func (uuet UaxURLEmailTokenizer) AsUaxURLEmailTokenizer() (*UaxURLEmailTokenizer, bool) {
	return &uuet, true
}

// AsTokenizer is the BasicTokenizer implementation for UaxURLEmailTokenizer.
func (uuet UaxURLEmailTokenizer) AsTokenizer() (*Tokenizer, bool) {
	return nil, false
}

// AsBasicTokenizer is the BasicTokenizer implementation for UaxURLEmailTokenizer.
func (uuet UaxURLEmailTokenizer) AsBasicTokenizer() (BasicTokenizer, bool) {
	return &uuet, true
}

// UniqueTokenFilter filters out tokens with same text as the previous token. This token filter is implemented using
// Apache Lucene.
type UniqueTokenFilter struct {
	// Name - The name of the token filter. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeTokenFilter', 'OdataTypeMicrosoftAzureSearchASCIIFoldingTokenFilter', 'OdataTypeMicrosoftAzureSearchCjkBigramTokenFilter', 'OdataTypeMicrosoftAzureSearchCommonGramTokenFilter', 'OdataTypeMicrosoftAzureSearchDictionaryDecompounderTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchElisionTokenFilter', 'OdataTypeMicrosoftAzureSearchKeepTokenFilter', 'OdataTypeMicrosoftAzureSearchKeywordMarkerTokenFilter', 'OdataTypeMicrosoftAzureSearchLengthTokenFilter', 'OdataTypeMicrosoftAzureSearchLimitTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchPatternCaptureTokenFilter', 'OdataTypeMicrosoftAzureSearchPatternReplaceTokenFilter', 'OdataTypeMicrosoftAzureSearchPhoneticTokenFilter', 'OdataTypeMicrosoftAzureSearchShingleTokenFilter', 'OdataTypeMicrosoftAzureSearchSnowballTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerOverrideTokenFilter', 'OdataTypeMicrosoftAzureSearchStopwordsTokenFilter', 'OdataTypeMicrosoftAzureSearchSynonymTokenFilter', 'OdataTypeMicrosoftAzureSearchTruncateTokenFilter', 'OdataTypeMicrosoftAzureSearchUniqueTokenFilter', 'OdataTypeMicrosoftAzureSearchWordDelimiterTokenFilter'
	OdataType OdataTypeBasicTokenFilter `json:"@odata.type,omitempty"`
	// OnlyOnSamePosition - A value indicating whether to remove duplicates only at the same position. Default is false.
	OnlyOnSamePosition *bool `json:"onlyOnSamePosition,omitempty"`
}

// MarshalJSON is the custom marshaler for UniqueTokenFilter.
func (utf UniqueTokenFilter) MarshalJSON() ([]byte, error) {
	utf.OdataType = OdataTypeMicrosoftAzureSearchUniqueTokenFilter
	type Alias UniqueTokenFilter
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(utf),
	})
}

// AsASCIIFoldingTokenFilter is the BasicTokenFilter implementation for UniqueTokenFilter.
func (utf UniqueTokenFilter) AsASCIIFoldingTokenFilter() (*ASCIIFoldingTokenFilter, bool) {
	return nil, false
}

// AsCjkBigramTokenFilter is the BasicTokenFilter implementation for UniqueTokenFilter.
func (utf UniqueTokenFilter) AsCjkBigramTokenFilter() (*CjkBigramTokenFilter, bool) {
	return nil, false
}

// AsCommonGramTokenFilter is the BasicTokenFilter implementation for UniqueTokenFilter.
func (utf UniqueTokenFilter) AsCommonGramTokenFilter() (*CommonGramTokenFilter, bool) {
	return nil, false
}

// AsDictionaryDecompounderTokenFilter is the BasicTokenFilter implementation for UniqueTokenFilter.
func (utf UniqueTokenFilter) AsDictionaryDecompounderTokenFilter() (*DictionaryDecompounderTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilter is the BasicTokenFilter implementation for UniqueTokenFilter.
func (utf UniqueTokenFilter) AsEdgeNGramTokenFilter() (*EdgeNGramTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilterV2 is the BasicTokenFilter implementation for UniqueTokenFilter.
func (utf UniqueTokenFilter) AsEdgeNGramTokenFilterV2() (*EdgeNGramTokenFilterV2, bool) {
	return nil, false
}

// AsElisionTokenFilter is the BasicTokenFilter implementation for UniqueTokenFilter.
func (utf UniqueTokenFilter) AsElisionTokenFilter() (*ElisionTokenFilter, bool) {
	return nil, false
}

// AsKeepTokenFilter is the BasicTokenFilter implementation for UniqueTokenFilter.
func (utf UniqueTokenFilter) AsKeepTokenFilter() (*KeepTokenFilter, bool) {
	return nil, false
}

// AsKeywordMarkerTokenFilter is the BasicTokenFilter implementation for UniqueTokenFilter.
func (utf UniqueTokenFilter) AsKeywordMarkerTokenFilter() (*KeywordMarkerTokenFilter, bool) {
	return nil, false
}

// AsLengthTokenFilter is the BasicTokenFilter implementation for UniqueTokenFilter.
func (utf UniqueTokenFilter) AsLengthTokenFilter() (*LengthTokenFilter, bool) {
	return nil, false
}

// AsLimitTokenFilter is the BasicTokenFilter implementation for UniqueTokenFilter.
func (utf UniqueTokenFilter) AsLimitTokenFilter() (*LimitTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilter is the BasicTokenFilter implementation for UniqueTokenFilter.
func (utf UniqueTokenFilter) AsNGramTokenFilter() (*NGramTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilterV2 is the BasicTokenFilter implementation for UniqueTokenFilter.
func (utf UniqueTokenFilter) AsNGramTokenFilterV2() (*NGramTokenFilterV2, bool) {
	return nil, false
}

// AsPatternCaptureTokenFilter is the BasicTokenFilter implementation for UniqueTokenFilter.
func (utf UniqueTokenFilter) AsPatternCaptureTokenFilter() (*PatternCaptureTokenFilter, bool) {
	return nil, false
}

// AsPatternReplaceTokenFilter is the BasicTokenFilter implementation for UniqueTokenFilter.
func (utf UniqueTokenFilter) AsPatternReplaceTokenFilter() (*PatternReplaceTokenFilter, bool) {
	return nil, false
}

// AsPhoneticTokenFilter is the BasicTokenFilter implementation for UniqueTokenFilter.
func (utf UniqueTokenFilter) AsPhoneticTokenFilter() (*PhoneticTokenFilter, bool) {
	return nil, false
}

// AsShingleTokenFilter is the BasicTokenFilter implementation for UniqueTokenFilter.
func (utf UniqueTokenFilter) AsShingleTokenFilter() (*ShingleTokenFilter, bool) {
	return nil, false
}

// AsSnowballTokenFilter is the BasicTokenFilter implementation for UniqueTokenFilter.
func (utf UniqueTokenFilter) AsSnowballTokenFilter() (*SnowballTokenFilter, bool) {
	return nil, false
}

// AsStemmerTokenFilter is the BasicTokenFilter implementation for UniqueTokenFilter.
func (utf UniqueTokenFilter) AsStemmerTokenFilter() (*StemmerTokenFilter, bool) {
	return nil, false
}

// AsStemmerOverrideTokenFilter is the BasicTokenFilter implementation for UniqueTokenFilter.
func (utf UniqueTokenFilter) AsStemmerOverrideTokenFilter() (*StemmerOverrideTokenFilter, bool) {
	return nil, false
}

// AsStopwordsTokenFilter is the BasicTokenFilter implementation for UniqueTokenFilter.
func (utf UniqueTokenFilter) AsStopwordsTokenFilter() (*StopwordsTokenFilter, bool) {
	return nil, false
}

// AsSynonymTokenFilter is the BasicTokenFilter implementation for UniqueTokenFilter.
func (utf UniqueTokenFilter) AsSynonymTokenFilter() (*SynonymTokenFilter, bool) {
	return nil, false
}

// AsTruncateTokenFilter is the BasicTokenFilter implementation for UniqueTokenFilter.
func (utf UniqueTokenFilter) AsTruncateTokenFilter() (*TruncateTokenFilter, bool) {
	return nil, false
}

// AsUniqueTokenFilter is the BasicTokenFilter implementation for UniqueTokenFilter.
func (utf UniqueTokenFilter) AsUniqueTokenFilter() (*UniqueTokenFilter, bool) {
	return &utf, true
}

// AsWordDelimiterTokenFilter is the BasicTokenFilter implementation for UniqueTokenFilter.
func (utf UniqueTokenFilter) AsWordDelimiterTokenFilter() (*WordDelimiterTokenFilter, bool) {
	return nil, false
}

// AsTokenFilter is the BasicTokenFilter implementation for UniqueTokenFilter.
func (utf UniqueTokenFilter) AsTokenFilter() (*TokenFilter, bool) {
	return nil, false
}

// AsBasicTokenFilter is the BasicTokenFilter implementation for UniqueTokenFilter.
func (utf UniqueTokenFilter) AsBasicTokenFilter() (BasicTokenFilter, bool) {
	return &utf, true
}

// WordDelimiterTokenFilter splits words into subwords and performs optional transformations on subword groups. This
// token filter is implemented using Apache Lucene.
type WordDelimiterTokenFilter struct {
	// Name - The name of the token filter. It must only contain letters, digits, spaces, dashes or underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
	Name *string `json:"name,omitempty"`
	// OdataType - Possible values include: 'OdataTypeTokenFilter', 'OdataTypeMicrosoftAzureSearchASCIIFoldingTokenFilter', 'OdataTypeMicrosoftAzureSearchCjkBigramTokenFilter', 'OdataTypeMicrosoftAzureSearchCommonGramTokenFilter', 'OdataTypeMicrosoftAzureSearchDictionaryDecompounderTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchEdgeNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchElisionTokenFilter', 'OdataTypeMicrosoftAzureSearchKeepTokenFilter', 'OdataTypeMicrosoftAzureSearchKeywordMarkerTokenFilter', 'OdataTypeMicrosoftAzureSearchLengthTokenFilter', 'OdataTypeMicrosoftAzureSearchLimitTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilter', 'OdataTypeMicrosoftAzureSearchNGramTokenFilterV2', 'OdataTypeMicrosoftAzureSearchPatternCaptureTokenFilter', 'OdataTypeMicrosoftAzureSearchPatternReplaceTokenFilter', 'OdataTypeMicrosoftAzureSearchPhoneticTokenFilter', 'OdataTypeMicrosoftAzureSearchShingleTokenFilter', 'OdataTypeMicrosoftAzureSearchSnowballTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerTokenFilter', 'OdataTypeMicrosoftAzureSearchStemmerOverrideTokenFilter', 'OdataTypeMicrosoftAzureSearchStopwordsTokenFilter', 'OdataTypeMicrosoftAzureSearchSynonymTokenFilter', 'OdataTypeMicrosoftAzureSearchTruncateTokenFilter', 'OdataTypeMicrosoftAzureSearchUniqueTokenFilter', 'OdataTypeMicrosoftAzureSearchWordDelimiterTokenFilter'
	OdataType OdataTypeBasicTokenFilter `json:"@odata.type,omitempty"`
	// GenerateWordParts - A value indicating whether to generate part words. If set, causes parts of words to be generated; for example "AzureSearch" becomes "Azure" "Search". Default is true.
	GenerateWordParts *bool `json:"generateWordParts,omitempty"`
	// GenerateNumberParts - A value indicating whether to generate number subwords. Default is true.
	GenerateNumberParts *bool `json:"generateNumberParts,omitempty"`
	// CatenateWords - A value indicating whether maximum runs of word parts will be catenated. For example, if this is set to true, "Azure-Search" becomes "AzureSearch". Default is false.
	CatenateWords *bool `json:"catenateWords,omitempty"`
	// CatenateNumbers - A value indicating whether maximum runs of number parts will be catenated. For example, if this is set to true, "1-2" becomes "12". Default is false.
	CatenateNumbers *bool `json:"catenateNumbers,omitempty"`
	// CatenateAll - A value indicating whether all subword parts will be catenated. For example, if this is set to true, "Azure-Search-1" becomes "AzureSearch1". Default is false.
	CatenateAll *bool `json:"catenateAll,omitempty"`
	// SplitOnCaseChange - A value indicating whether to split words on caseChange. For example, if this is set to true, "AzureSearch" becomes "Azure" "Search". Default is true.
	SplitOnCaseChange *bool `json:"splitOnCaseChange,omitempty"`
	// PreserveOriginal - A value indicating whether original words will be preserved and added to the subword list. Default is false.
	PreserveOriginal *bool `json:"preserveOriginal,omitempty"`
	// SplitOnNumerics - A value indicating whether to split on numbers. For example, if this is set to true, "Azure1Search" becomes "Azure" "1" "Search". Default is true.
	SplitOnNumerics *bool `json:"splitOnNumerics,omitempty"`
	// StemEnglishPossessive - A value indicating whether to remove trailing "'s" for each subword. Default is true.
	StemEnglishPossessive *bool `json:"stemEnglishPossessive,omitempty"`
	// ProtectedWords - A list of tokens to protect from being delimited.
	ProtectedWords *[]string `json:"protectedWords,omitempty"`
}

// MarshalJSON is the custom marshaler for WordDelimiterTokenFilter.
func (wdtf WordDelimiterTokenFilter) MarshalJSON() ([]byte, error) {
	wdtf.OdataType = OdataTypeMicrosoftAzureSearchWordDelimiterTokenFilter
	type Alias WordDelimiterTokenFilter
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(wdtf),
	})
}

// AsASCIIFoldingTokenFilter is the BasicTokenFilter implementation for WordDelimiterTokenFilter.
func (wdtf WordDelimiterTokenFilter) AsASCIIFoldingTokenFilter() (*ASCIIFoldingTokenFilter, bool) {
	return nil, false
}

// AsCjkBigramTokenFilter is the BasicTokenFilter implementation for WordDelimiterTokenFilter.
func (wdtf WordDelimiterTokenFilter) AsCjkBigramTokenFilter() (*CjkBigramTokenFilter, bool) {
	return nil, false
}

// AsCommonGramTokenFilter is the BasicTokenFilter implementation for WordDelimiterTokenFilter.
func (wdtf WordDelimiterTokenFilter) AsCommonGramTokenFilter() (*CommonGramTokenFilter, bool) {
	return nil, false
}

// AsDictionaryDecompounderTokenFilter is the BasicTokenFilter implementation for WordDelimiterTokenFilter.
func (wdtf WordDelimiterTokenFilter) AsDictionaryDecompounderTokenFilter() (*DictionaryDecompounderTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilter is the BasicTokenFilter implementation for WordDelimiterTokenFilter.
func (wdtf WordDelimiterTokenFilter) AsEdgeNGramTokenFilter() (*EdgeNGramTokenFilter, bool) {
	return nil, false
}

// AsEdgeNGramTokenFilterV2 is the BasicTokenFilter implementation for WordDelimiterTokenFilter.
func (wdtf WordDelimiterTokenFilter) AsEdgeNGramTokenFilterV2() (*EdgeNGramTokenFilterV2, bool) {
	return nil, false
}

// AsElisionTokenFilter is the BasicTokenFilter implementation for WordDelimiterTokenFilter.
func (wdtf WordDelimiterTokenFilter) AsElisionTokenFilter() (*ElisionTokenFilter, bool) {
	return nil, false
}

// AsKeepTokenFilter is the BasicTokenFilter implementation for WordDelimiterTokenFilter.
func (wdtf WordDelimiterTokenFilter) AsKeepTokenFilter() (*KeepTokenFilter, bool) {
	return nil, false
}

// AsKeywordMarkerTokenFilter is the BasicTokenFilter implementation for WordDelimiterTokenFilter.
func (wdtf WordDelimiterTokenFilter) AsKeywordMarkerTokenFilter() (*KeywordMarkerTokenFilter, bool) {
	return nil, false
}

// AsLengthTokenFilter is the BasicTokenFilter implementation for WordDelimiterTokenFilter.
func (wdtf WordDelimiterTokenFilter) AsLengthTokenFilter() (*LengthTokenFilter, bool) {
	return nil, false
}

// AsLimitTokenFilter is the BasicTokenFilter implementation for WordDelimiterTokenFilter.
func (wdtf WordDelimiterTokenFilter) AsLimitTokenFilter() (*LimitTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilter is the BasicTokenFilter implementation for WordDelimiterTokenFilter.
func (wdtf WordDelimiterTokenFilter) AsNGramTokenFilter() (*NGramTokenFilter, bool) {
	return nil, false
}

// AsNGramTokenFilterV2 is the BasicTokenFilter implementation for WordDelimiterTokenFilter.
func (wdtf WordDelimiterTokenFilter) AsNGramTokenFilterV2() (*NGramTokenFilterV2, bool) {
	return nil, false
}

// AsPatternCaptureTokenFilter is the BasicTokenFilter implementation for WordDelimiterTokenFilter.
func (wdtf WordDelimiterTokenFilter) AsPatternCaptureTokenFilter() (*PatternCaptureTokenFilter, bool) {
	return nil, false
}

// AsPatternReplaceTokenFilter is the BasicTokenFilter implementation for WordDelimiterTokenFilter.
func (wdtf WordDelimiterTokenFilter) AsPatternReplaceTokenFilter() (*PatternReplaceTokenFilter, bool) {
	return nil, false
}

// AsPhoneticTokenFilter is the BasicTokenFilter implementation for WordDelimiterTokenFilter.
func (wdtf WordDelimiterTokenFilter) AsPhoneticTokenFilter() (*PhoneticTokenFilter, bool) {
	return nil, false
}

// AsShingleTokenFilter is the BasicTokenFilter implementation for WordDelimiterTokenFilter.
func (wdtf WordDelimiterTokenFilter) AsShingleTokenFilter() (*ShingleTokenFilter, bool) {
	return nil, false
}

// AsSnowballTokenFilter is the BasicTokenFilter implementation for WordDelimiterTokenFilter.
func (wdtf WordDelimiterTokenFilter) AsSnowballTokenFilter() (*SnowballTokenFilter, bool) {
	return nil, false
}

// AsStemmerTokenFilter is the BasicTokenFilter implementation for WordDelimiterTokenFilter.
func (wdtf WordDelimiterTokenFilter) AsStemmerTokenFilter() (*StemmerTokenFilter, bool) {
	return nil, false
}

// AsStemmerOverrideTokenFilter is the BasicTokenFilter implementation for WordDelimiterTokenFilter.
func (wdtf WordDelimiterTokenFilter) AsStemmerOverrideTokenFilter() (*StemmerOverrideTokenFilter, bool) {
	return nil, false
}

// AsStopwordsTokenFilter is the BasicTokenFilter implementation for WordDelimiterTokenFilter.
func (wdtf WordDelimiterTokenFilter) AsStopwordsTokenFilter() (*StopwordsTokenFilter, bool) {
	return nil, false
}

// AsSynonymTokenFilter is the BasicTokenFilter implementation for WordDelimiterTokenFilter.
func (wdtf WordDelimiterTokenFilter) AsSynonymTokenFilter() (*SynonymTokenFilter, bool) {
	return nil, false
}

// AsTruncateTokenFilter is the BasicTokenFilter implementation for WordDelimiterTokenFilter.
func (wdtf WordDelimiterTokenFilter) AsTruncateTokenFilter() (*TruncateTokenFilter, bool) {
	return nil, false
}

// AsUniqueTokenFilter is the BasicTokenFilter implementation for WordDelimiterTokenFilter.
func (wdtf WordDelimiterTokenFilter) AsUniqueTokenFilter() (*UniqueTokenFilter, bool) {
	return nil, false
}

// AsWordDelimiterTokenFilter is the BasicTokenFilter implementation for WordDelimiterTokenFilter.
func (wdtf WordDelimiterTokenFilter) AsWordDelimiterTokenFilter() (*WordDelimiterTokenFilter, bool) {
	return &wdtf, true
}

// AsTokenFilter is the BasicTokenFilter implementation for WordDelimiterTokenFilter.
func (wdtf WordDelimiterTokenFilter) AsTokenFilter() (*TokenFilter, bool) {
	return nil, false
}

// AsBasicTokenFilter is the BasicTokenFilter implementation for WordDelimiterTokenFilter.
func (wdtf WordDelimiterTokenFilter) AsBasicTokenFilter() (BasicTokenFilter, bool) {
	return &wdtf, true
}
