package search

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/satori/go.uuid"
	"net/http"
)

// DataSourcesClient is the search Client
type DataSourcesClient struct {
	BaseClient
}

// NewDataSourcesClient creates an instance of the DataSourcesClient client.
func NewDataSourcesClient() DataSourcesClient {
	return NewDataSourcesClientWithBaseURI(DefaultBaseURI)
}

// NewDataSourcesClientWithBaseURI creates an instance of the DataSourcesClient client.
func NewDataSourcesClientWithBaseURI(baseURI string) DataSourcesClient {
	return DataSourcesClient{NewWithBaseURI(baseURI)}
}

// Create creates a new Azure Search datasource.
//
// dataSource is the definition of the datasource to create. clientRequestID is the tracking ID sent with the request
// to help with debugging.
func (client DataSourcesClient) Create(ctx context.Context, dataSource DataSource, clientRequestID *uuid.UUID) (result DataSource, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: dataSource,
			Constraints: []validation.Constraint{{Target: "dataSource.Name", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "dataSource.Type", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "dataSource.Credentials", Name: validation.Null, Rule: true,
					Chain: []validation.Constraint{{Target: "dataSource.Credentials.ConnectionString", Name: validation.Null, Rule: true, Chain: nil}}},
				{Target: "dataSource.Container", Name: validation.Null, Rule: true,
					Chain: []validation.Constraint{{Target: "dataSource.Container.Name", Name: validation.Null, Rule: true, Chain: nil}}}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "search.DataSourcesClient", "Create")
	}

	req, err := client.CreatePreparer(ctx, dataSource, clientRequestID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "search.DataSourcesClient", "Create", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "search.DataSourcesClient", "Create", resp, "Failure sending request")
		return
	}

	result, err = client.CreateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "search.DataSourcesClient", "Create", resp, "Failure responding to request")
	}

	return
}

// CreatePreparer prepares the Create request.
func (client DataSourcesClient) CreatePreparer(ctx context.Context, dataSource DataSource, clientRequestID *uuid.UUID) (*http.Request, error) {
	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPath("/datasources"),
		autorest.WithJSON(dataSource),
		autorest.WithQueryParameters(queryParameters))
	if clientRequestID != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("client-request-id", autorest.String(clientRequestID)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateSender sends the Create request. The method will close the
// http.Response Body if it receives an error.
func (client DataSourcesClient) CreateSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CreateResponder handles the response to the Create request. The method always
// closes the http.Response Body.
func (client DataSourcesClient) CreateResponder(resp *http.Response) (result DataSource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdate creates a new Azure Search datasource or updates a datasource if it already exists.
//
// dataSourceName is the name of the datasource to create or update. dataSource is the definition of the datasource to
// create or update. clientRequestID is the tracking ID sent with the request to help with debugging. ifMatch is
// defines the If-Match condition. The operation will be performed only if the ETag on the server matches this value.
// ifNoneMatch is defines the If-None-Match condition. The operation will be performed only if the ETag on the server
// does not match this value.
func (client DataSourcesClient) CreateOrUpdate(ctx context.Context, dataSourceName string, dataSource DataSource, clientRequestID *uuid.UUID, ifMatch string, ifNoneMatch string) (result DataSource, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: dataSource,
			Constraints: []validation.Constraint{{Target: "dataSource.Name", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "dataSource.Type", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "dataSource.Credentials", Name: validation.Null, Rule: true,
					Chain: []validation.Constraint{{Target: "dataSource.Credentials.ConnectionString", Name: validation.Null, Rule: true, Chain: nil}}},
				{Target: "dataSource.Container", Name: validation.Null, Rule: true,
					Chain: []validation.Constraint{{Target: "dataSource.Container.Name", Name: validation.Null, Rule: true, Chain: nil}}}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "search.DataSourcesClient", "CreateOrUpdate")
	}

	req, err := client.CreateOrUpdatePreparer(ctx, dataSourceName, dataSource, clientRequestID, ifMatch, ifNoneMatch)
	if err != nil {
		err = autorest.NewErrorWithError(err, "search.DataSourcesClient", "CreateOrUpdate", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "search.DataSourcesClient", "CreateOrUpdate", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "search.DataSourcesClient", "CreateOrUpdate", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client DataSourcesClient) CreateOrUpdatePreparer(ctx context.Context, dataSourceName string, dataSource DataSource, clientRequestID *uuid.UUID, ifMatch string, ifNoneMatch string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"dataSourceName": autorest.Encode("path", dataSourceName),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/datasources('{dataSourceName}')", pathParameters),
		autorest.WithJSON(dataSource),
		autorest.WithQueryParameters(queryParameters))
	if clientRequestID != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("client-request-id", autorest.String(clientRequestID)))
	}
	if len(ifMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Match", autorest.String(ifMatch)))
	}
	if len(ifNoneMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-None-Match", autorest.String(ifNoneMatch)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client DataSourcesClient) CreateOrUpdateSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client DataSourcesClient) CreateOrUpdateResponder(resp *http.Response) (result DataSource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete deletes an Azure Search datasource.
//
// dataSourceName is the name of the datasource to delete. clientRequestID is the tracking ID sent with the request to
// help with debugging. ifMatch is defines the If-Match condition. The operation will be performed only if the ETag on
// the server matches this value. ifNoneMatch is defines the If-None-Match condition. The operation will be performed
// only if the ETag on the server does not match this value.
func (client DataSourcesClient) Delete(ctx context.Context, dataSourceName string, clientRequestID *uuid.UUID, ifMatch string, ifNoneMatch string) (result autorest.Response, err error) {
	req, err := client.DeletePreparer(ctx, dataSourceName, clientRequestID, ifMatch, ifNoneMatch)
	if err != nil {
		err = autorest.NewErrorWithError(err, "search.DataSourcesClient", "Delete", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "search.DataSourcesClient", "Delete", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "search.DataSourcesClient", "Delete", resp, "Failure responding to request")
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client DataSourcesClient) DeletePreparer(ctx context.Context, dataSourceName string, clientRequestID *uuid.UUID, ifMatch string, ifNoneMatch string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"dataSourceName": autorest.Encode("path", dataSourceName),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/datasources('{dataSourceName}')", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	if clientRequestID != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("client-request-id", autorest.String(clientRequestID)))
	}
	if len(ifMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Match", autorest.String(ifMatch)))
	}
	if len(ifNoneMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-None-Match", autorest.String(ifNoneMatch)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client DataSourcesClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client DataSourcesClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get retrieves a datasource definition from Azure Search.
//
// dataSourceName is the name of the datasource to retrieve. clientRequestID is the tracking ID sent with the request
// to help with debugging.
func (client DataSourcesClient) Get(ctx context.Context, dataSourceName string, clientRequestID *uuid.UUID) (result DataSource, err error) {
	req, err := client.GetPreparer(ctx, dataSourceName, clientRequestID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "search.DataSourcesClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "search.DataSourcesClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "search.DataSourcesClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client DataSourcesClient) GetPreparer(ctx context.Context, dataSourceName string, clientRequestID *uuid.UUID) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"dataSourceName": autorest.Encode("path", dataSourceName),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/datasources('{dataSourceName}')", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	if clientRequestID != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("client-request-id", autorest.String(clientRequestID)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client DataSourcesClient) GetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client DataSourcesClient) GetResponder(resp *http.Response) (result DataSource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List lists all datasources available for an Azure Search service.
//
// clientRequestID is the tracking ID sent with the request to help with debugging.
func (client DataSourcesClient) List(ctx context.Context, clientRequestID *uuid.UUID) (result DataSourceListResult, err error) {
	req, err := client.ListPreparer(ctx, clientRequestID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "search.DataSourcesClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "search.DataSourcesClient", "List", resp, "Failure sending request")
		return
	}

	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "search.DataSourcesClient", "List", resp, "Failure responding to request")
	}

	return
}

// ListPreparer prepares the List request.
func (client DataSourcesClient) ListPreparer(ctx context.Context, clientRequestID *uuid.UUID) (*http.Request, error) {
	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPath("/datasources"),
		autorest.WithQueryParameters(queryParameters))
	if clientRequestID != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("client-request-id", autorest.String(clientRequestID)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client DataSourcesClient) ListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client DataSourcesClient) ListResponder(resp *http.Response) (result DataSourceListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
