package redis

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// DayOfWeek enumerates the values for day of week.
type DayOfWeek string

const (
	// Everyday ...
	Everyday DayOfWeek = "Everyday"
	// Friday ...
	Friday DayOfWeek = "Friday"
	// Monday ...
	Monday DayOfWeek = "Monday"
	// Saturday ...
	Saturday DayOfWeek = "Saturday"
	// Sunday ...
	Sunday DayOfWeek = "Sunday"
	// Thursday ...
	Thursday DayOfWeek = "Thursday"
	// Tuesday ...
	Tuesday DayOfWeek = "Tuesday"
	// Wednesday ...
	Wednesday DayOfWeek = "Wednesday"
	// Weekend ...
	Weekend DayOfWeek = "Weekend"
)

// KeyType enumerates the values for key type.
type KeyType string

const (
	// Primary ...
	Primary KeyType = "Primary"
	// Secondary ...
	Secondary KeyType = "Secondary"
)

// RebootType enumerates the values for reboot type.
type RebootType string

const (
	// AllNodes ...
	AllNodes RebootType = "AllNodes"
	// PrimaryNode ...
	PrimaryNode RebootType = "PrimaryNode"
	// SecondaryNode ...
	SecondaryNode RebootType = "SecondaryNode"
)

// SkuFamily enumerates the values for sku family.
type SkuFamily string

const (
	// C ...
	C SkuFamily = "C"
	// P ...
	P SkuFamily = "P"
)

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// Basic ...
	Basic SkuName = "Basic"
	// Premium ...
	Premium SkuName = "Premium"
	// Standard ...
	Standard SkuName = "Standard"
)

// AccessKeys redis cache access keys.
type AccessKeys struct {
	autorest.Response `json:"-"`
	// PrimaryKey - The current primary key that clients can use to authenticate with Redis cache.
	PrimaryKey *string `json:"primaryKey,omitempty"`
	// SecondaryKey - The current secondary key that clients can use to authenticate with Redis cache.
	SecondaryKey *string `json:"secondaryKey,omitempty"`
}

// CreateParameters parameters supplied to the Create Redis operation.
type CreateParameters struct {
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags *map[string]*string `json:"tags,omitempty"`
	// CreateProperties - Redis cache properties.
	*CreateProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for CreateParameters struct.
func (cp *CreateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		var properties CreateProperties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		cp.CreateProperties = &properties
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		cp.ID = &ID
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		cp.Name = &name
	}

	v = m["type"]
	if v != nil {
		var typeVar string
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		cp.Type = &typeVar
	}

	v = m["location"]
	if v != nil {
		var location string
		err = json.Unmarshal(*m["location"], &location)
		if err != nil {
			return err
		}
		cp.Location = &location
	}

	v = m["tags"]
	if v != nil {
		var tags map[string]*string
		err = json.Unmarshal(*m["tags"], &tags)
		if err != nil {
			return err
		}
		cp.Tags = &tags
	}

	return nil
}

// CreateProperties properties supplied to Create Redis operation.
type CreateProperties struct {
	// RedisConfiguration - All Redis Settings. Few possible keys: rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value etc.
	RedisConfiguration *map[string]*string `json:"redisConfiguration,omitempty"`
	// EnableNonSslPort - Specifies whether the non-ssl Redis server port (6379) is enabled.
	EnableNonSslPort *bool `json:"enableNonSslPort,omitempty"`
	// TenantSettings - tenantSettings
	TenantSettings *map[string]*string `json:"tenantSettings,omitempty"`
	// ShardCount - The number of shards to be created on a Premium Cluster Cache.
	ShardCount *int32 `json:"shardCount,omitempty"`
	// SubnetID - The full resource ID of a subnet in a virtual network to deploy the Redis cache in. Example format: /subscriptions/{subid}/resourceGroups/{resourceGroupName}/Microsoft.{Network|ClassicNetwork}/VirtualNetworks/vnet1/subnets/subnet1
	SubnetID *string `json:"subnetId,omitempty"`
	// StaticIP - Static IP address. Required when deploying a Redis cache inside an existing Azure Virtual Network.
	StaticIP *string `json:"staticIP,omitempty"`
	// Sku - The SKU of the Redis cache to deploy.
	Sku *Sku `json:"sku,omitempty"`
}

// ExportRDBParameters parameters for Redis export operation.
type ExportRDBParameters struct {
	// Format - File format.
	Format *string `json:"format,omitempty"`
	// Prefix - Prefix to use for exported files.
	Prefix *string `json:"prefix,omitempty"`
	// Container - Container name to export to.
	Container *string `json:"container,omitempty"`
}

// FirewallRule a firewall rule on a redis cache has a name, and describes a contiguous range of IP addresses permitted
// to connect
type FirewallRule struct {
	autorest.Response `json:"-"`
	// ID - resource ID (of the firewall rule)
	ID *string `json:"id,omitempty"`
	// Name - name of the firewall rule
	Name *string `json:"name,omitempty"`
	// Type - type (of the firewall rule resource = 'Microsoft.Cache/redis/firewallRule')
	Type *string `json:"type,omitempty"`
	// FirewallRuleProperties - redis cache firewall rule properties
	*FirewallRuleProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for FirewallRule struct.
func (fr *FirewallRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		fr.ID = &ID
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		fr.Name = &name
	}

	v = m["type"]
	if v != nil {
		var typeVar string
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		fr.Type = &typeVar
	}

	v = m["properties"]
	if v != nil {
		var properties FirewallRuleProperties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		fr.FirewallRuleProperties = &properties
	}

	return nil
}

// FirewallRuleListResult the response of list firewall rules Redis operation.
type FirewallRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - Results of the list firewall rules operation.
	Value *[]FirewallRule `json:"value,omitempty"`
	// NextLink - Link for next set of locations.
	NextLink *string `json:"nextLink,omitempty"`
}

// FirewallRuleListResultIterator provides access to a complete listing of FirewallRule values.
type FirewallRuleListResultIterator struct {
	i    int
	page FirewallRuleListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *FirewallRuleListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter FirewallRuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter FirewallRuleListResultIterator) Response() FirewallRuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter FirewallRuleListResultIterator) Value() FirewallRule {
	if !iter.page.NotDone() {
		return FirewallRule{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (frlr FirewallRuleListResult) IsEmpty() bool {
	return frlr.Value == nil || len(*frlr.Value) == 0
}

// firewallRuleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (frlr FirewallRuleListResult) firewallRuleListResultPreparer() (*http.Request, error) {
	if frlr.NextLink == nil || len(to.String(frlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(frlr.NextLink)))
}

// FirewallRuleListResultPage contains a page of FirewallRule values.
type FirewallRuleListResultPage struct {
	fn   func(FirewallRuleListResult) (FirewallRuleListResult, error)
	frlr FirewallRuleListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *FirewallRuleListResultPage) Next() error {
	next, err := page.fn(page.frlr)
	if err != nil {
		return err
	}
	page.frlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page FirewallRuleListResultPage) NotDone() bool {
	return !page.frlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page FirewallRuleListResultPage) Response() FirewallRuleListResult {
	return page.frlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page FirewallRuleListResultPage) Values() []FirewallRule {
	if page.frlr.IsEmpty() {
		return nil
	}
	return *page.frlr.Value
}

// FirewallRuleProperties specifies a range of IP addresses permitted to connect to the cache
type FirewallRuleProperties struct {
	// StartIP - lowest IP address included in the range
	StartIP *string `json:"startIP,omitempty"`
	// EndIP - highest IP address included in the range
	EndIP *string `json:"endIP,omitempty"`
}

// ForceRebootResponse response to force reboot for Redis cache.
type ForceRebootResponse struct {
	autorest.Response `json:"-"`
	// Message - Status message
	Message *string `json:"Message,omitempty"`
}

// ImportRDBParameters parameters for Redis import operation.
type ImportRDBParameters struct {
	// Format - File format.
	Format *string `json:"format,omitempty"`
	// Files - files to import.
	Files *[]string `json:"files,omitempty"`
}

// ListResult the response of list Redis operation.
type ListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Redis cache instances.
	Value *[]ResourceType `json:"value,omitempty"`
	// NextLink - Link for next set of locations.
	NextLink *string `json:"nextLink,omitempty"`
}

// ListResultIterator provides access to a complete listing of ResourceType values.
type ListResultIterator struct {
	i    int
	page ListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListResultIterator) Response() ListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListResultIterator) Value() ResourceType {
	if !iter.page.NotDone() {
		return ResourceType{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (lr ListResult) IsEmpty() bool {
	return lr.Value == nil || len(*lr.Value) == 0
}

// listResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lr ListResult) listResultPreparer() (*http.Request, error) {
	if lr.NextLink == nil || len(to.String(lr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lr.NextLink)))
}

// ListResultPage contains a page of ResourceType values.
type ListResultPage struct {
	fn func(ListResult) (ListResult, error)
	lr ListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListResultPage) Next() error {
	next, err := page.fn(page.lr)
	if err != nil {
		return err
	}
	page.lr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListResultPage) NotDone() bool {
	return !page.lr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListResultPage) Response() ListResult {
	return page.lr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListResultPage) Values() []ResourceType {
	if page.lr.IsEmpty() {
		return nil
	}
	return *page.lr.Value
}

// Operation REST API operation
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - The object that describes the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay the object that describes the operation.
type OperationDisplay struct {
	// Provider - Friendly name of the resource provider
	Provider *string `json:"provider,omitempty"`
	// Operation - Operation type: read, write, delete, listKeys/action, etc.
	Operation *string `json:"operation,omitempty"`
	// Resource - Resource type on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
	// Description - Friendly name of the operation
	Description *string `json:"description,omitempty"`
}

// OperationListResult result of the request to list REST API operations. It contains a list of operations and a URL
// nextLink to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of operations supported by the resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer() (*http.Request, error) {
	if olr.NextLink == nil || len(to.String(olr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) Next() error {
	next, err := page.fn(page.olr)
	if err != nil {
		return err
	}
	page.olr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// PatchSchedule response to put/get patch schedules for Redis cache.
type PatchSchedule struct {
	autorest.Response `json:"-"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// ScheduleEntries - List of patch schedules for a Redis cache.
	*ScheduleEntries `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for PatchSchedule struct.
func (ps *PatchSchedule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		ps.ID = &ID
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		ps.Name = &name
	}

	v = m["type"]
	if v != nil {
		var typeVar string
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		ps.Type = &typeVar
	}

	v = m["location"]
	if v != nil {
		var location string
		err = json.Unmarshal(*m["location"], &location)
		if err != nil {
			return err
		}
		ps.Location = &location
	}

	v = m["properties"]
	if v != nil {
		var properties ScheduleEntries
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		ps.ScheduleEntries = &properties
	}

	return nil
}

// Properties properties supplied to Create or Update Redis operation.
type Properties struct {
	// RedisConfiguration - All Redis Settings. Few possible keys: rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value etc.
	RedisConfiguration *map[string]*string `json:"redisConfiguration,omitempty"`
	// EnableNonSslPort - Specifies whether the non-ssl Redis server port (6379) is enabled.
	EnableNonSslPort *bool `json:"enableNonSslPort,omitempty"`
	// TenantSettings - tenantSettings
	TenantSettings *map[string]*string `json:"tenantSettings,omitempty"`
	// ShardCount - The number of shards to be created on a Premium Cluster Cache.
	ShardCount *int32 `json:"shardCount,omitempty"`
	// SubnetID - The full resource ID of a subnet in a virtual network to deploy the Redis cache in. Example format: /subscriptions/{subid}/resourceGroups/{resourceGroupName}/Microsoft.{Network|ClassicNetwork}/VirtualNetworks/vnet1/subnets/subnet1
	SubnetID *string `json:"subnetId,omitempty"`
	// StaticIP - Static IP address. Required when deploying a Redis cache inside an existing Azure Virtual Network.
	StaticIP *string `json:"staticIP,omitempty"`
}

// RebootParameters specifies which Redis node(s) to reboot.
type RebootParameters struct {
	// RebootType - Which Redis node(s) to reboot. Depending on this value data loss is possible. Possible values include: 'PrimaryNode', 'SecondaryNode', 'AllNodes'
	RebootType RebootType `json:"rebootType,omitempty"`
	// ShardID - If clustering is enabled, the ID of the shard to be rebooted.
	ShardID *int32 `json:"shardId,omitempty"`
}

// RedisCreateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type RedisCreateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future RedisCreateFuture) Result(client Client) (rt ResourceType, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		return
	}
	if !done {
		return rt, autorest.NewError("redis.RedisCreateFuture", "Result", "asynchronous operation has not completed")
	}
	if future.PollingMethod() == azure.PollingLocation {
		rt, err = client.CreateResponder(future.Response())
		return
	}
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, autorest.ChangeToGet(future.req),
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return
	}
	rt, err = client.CreateResponder(resp)
	return
}

// RedisDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type RedisDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future RedisDeleteFuture) Result(client Client) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		return
	}
	if !done {
		return ar, autorest.NewError("redis.RedisDeleteFuture", "Result", "asynchronous operation has not completed")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		return
	}
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, autorest.ChangeToGet(future.req),
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return
	}
	ar, err = client.DeleteResponder(resp)
	return
}

// RedisExportDataFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type RedisExportDataFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future RedisExportDataFuture) Result(client Client) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		return
	}
	if !done {
		return ar, autorest.NewError("redis.RedisExportDataFuture", "Result", "asynchronous operation has not completed")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.ExportDataResponder(future.Response())
		return
	}
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, autorest.ChangeToGet(future.req),
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return
	}
	ar, err = client.ExportDataResponder(resp)
	return
}

// RedisImportDataFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type RedisImportDataFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future RedisImportDataFuture) Result(client Client) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		return
	}
	if !done {
		return ar, autorest.NewError("redis.RedisImportDataFuture", "Result", "asynchronous operation has not completed")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.ImportDataResponder(future.Response())
		return
	}
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, autorest.ChangeToGet(future.req),
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return
	}
	ar, err = client.ImportDataResponder(resp)
	return
}

// RegenerateKeyParameters specifies which Redis access keys to reset.
type RegenerateKeyParameters struct {
	// KeyType - The Redis access key to regenerate. Possible values include: 'Primary', 'Secondary'
	KeyType KeyType `json:"keyType,omitempty"`
}

// Resource the Resource definition.
type Resource struct {
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags *map[string]*string `json:"tags,omitempty"`
}

// ResourceProperties parameters describing a Redis instance.
type ResourceProperties struct {
	// RedisConfiguration - All Redis Settings. Few possible keys: rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value etc.
	RedisConfiguration *map[string]*string `json:"redisConfiguration,omitempty"`
	// EnableNonSslPort - Specifies whether the non-ssl Redis server port (6379) is enabled.
	EnableNonSslPort *bool `json:"enableNonSslPort,omitempty"`
	// TenantSettings - tenantSettings
	TenantSettings *map[string]*string `json:"tenantSettings,omitempty"`
	// ShardCount - The number of shards to be created on a Premium Cluster Cache.
	ShardCount *int32 `json:"shardCount,omitempty"`
	// SubnetID - The full resource ID of a subnet in a virtual network to deploy the Redis cache in. Example format: /subscriptions/{subid}/resourceGroups/{resourceGroupName}/Microsoft.{Network|ClassicNetwork}/VirtualNetworks/vnet1/subnets/subnet1
	SubnetID *string `json:"subnetId,omitempty"`
	// StaticIP - Static IP address. Required when deploying a Redis cache inside an existing Azure Virtual Network.
	StaticIP *string `json:"staticIP,omitempty"`
	// Sku - The SKU of the Redis cache to deploy.
	Sku *Sku `json:"sku,omitempty"`
	// RedisVersion - Redis version.
	RedisVersion *string `json:"redisVersion,omitempty"`
	// ProvisioningState - Redis instance provisioning status.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// HostName - Redis host name.
	HostName *string `json:"hostName,omitempty"`
	// Port - Redis non-SSL port.
	Port *int32 `json:"port,omitempty"`
	// SslPort - Redis SSL port.
	SslPort *int32 `json:"sslPort,omitempty"`
	// AccessKeys - The keys of the Redis cache - not set if this object is not the response to Create or Update redis cache
	AccessKeys *AccessKeys `json:"accessKeys,omitempty"`
}

// ResourceType a single Redis item in List or Get Operation.
type ResourceType struct {
	autorest.Response `json:"-"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags *map[string]*string `json:"tags,omitempty"`
	// ResourceProperties - Redis cache properties.
	*ResourceProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ResourceType struct.
func (rt *ResourceType) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		var properties ResourceProperties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		rt.ResourceProperties = &properties
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		rt.ID = &ID
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		rt.Name = &name
	}

	v = m["type"]
	if v != nil {
		var typeVar string
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		rt.Type = &typeVar
	}

	v = m["location"]
	if v != nil {
		var location string
		err = json.Unmarshal(*m["location"], &location)
		if err != nil {
			return err
		}
		rt.Location = &location
	}

	v = m["tags"]
	if v != nil {
		var tags map[string]*string
		err = json.Unmarshal(*m["tags"], &tags)
		if err != nil {
			return err
		}
		rt.Tags = &tags
	}

	return nil
}

// ScheduleEntries list of patch schedules for a Redis cache.
type ScheduleEntries struct {
	// ScheduleEntries - List of patch schedules for a Redis cache.
	ScheduleEntries *[]ScheduleEntry `json:"scheduleEntries,omitempty"`
}

// ScheduleEntry patch schedule entry for a Premium Redis Cache.
type ScheduleEntry struct {
	// DayOfWeek - Day of the week when a cache can be patched. Possible values include: 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday', 'Everyday', 'Weekend'
	DayOfWeek DayOfWeek `json:"dayOfWeek,omitempty"`
	// StartHourUtc - Start hour after which cache patching can start.
	StartHourUtc *int32 `json:"startHourUtc,omitempty"`
	// MaintenanceWindow - ISO8601 timespan specifying how much time cache patching can take.
	MaintenanceWindow *string `json:"maintenanceWindow,omitempty"`
}

// Sku SKU parameters supplied to the create Redis operation.
type Sku struct {
	// Name - The type of Redis cache to deploy. Valid values: (Basic, Standard, Premium). Possible values include: 'Basic', 'Standard', 'Premium'
	Name SkuName `json:"name,omitempty"`
	// Family - The SKU family to use. Valid values: (C, P). (C = Basic/Standard, P = Premium). Possible values include: 'C', 'P'
	Family SkuFamily `json:"family,omitempty"`
	// Capacity - The size of the Redis cache to deploy. Valid values: for C (Basic/Standard) family (0, 1, 2, 3, 4, 5, 6), for P (Premium) family (1, 2, 3, 4).
	Capacity *int32 `json:"capacity,omitempty"`
}

// UpdateParameters parameters supplied to the Update Redis operation.
type UpdateParameters struct {
	// UpdateProperties - Redis cache properties.
	*UpdateProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags *map[string]*string `json:"tags,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for UpdateParameters struct.
func (up *UpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		var properties UpdateProperties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		up.UpdateProperties = &properties
	}

	v = m["tags"]
	if v != nil {
		var tags map[string]*string
		err = json.Unmarshal(*m["tags"], &tags)
		if err != nil {
			return err
		}
		up.Tags = &tags
	}

	return nil
}

// UpdateProperties properties supplied to Update Redis operation.
type UpdateProperties struct {
	// RedisConfiguration - All Redis Settings. Few possible keys: rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value etc.
	RedisConfiguration *map[string]*string `json:"redisConfiguration,omitempty"`
	// EnableNonSslPort - Specifies whether the non-ssl Redis server port (6379) is enabled.
	EnableNonSslPort *bool `json:"enableNonSslPort,omitempty"`
	// TenantSettings - tenantSettings
	TenantSettings *map[string]*string `json:"tenantSettings,omitempty"`
	// ShardCount - The number of shards to be created on a Premium Cluster Cache.
	ShardCount *int32 `json:"shardCount,omitempty"`
	// SubnetID - The full resource ID of a subnet in a virtual network to deploy the Redis cache in. Example format: /subscriptions/{subid}/resourceGroups/{resourceGroupName}/Microsoft.{Network|ClassicNetwork}/VirtualNetworks/vnet1/subnets/subnet1
	SubnetID *string `json:"subnetId,omitempty"`
	// StaticIP - Static IP address. Required when deploying a Redis cache inside an existing Azure Virtual Network.
	StaticIP *string `json:"staticIP,omitempty"`
	// Sku - The SKU of the Redis cache to deploy.
	Sku *Sku `json:"sku,omitempty"`
}
