package servicemap

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// Accuracy enumerates the values for accuracy.
type Accuracy string

const (
	// Actual ...
	Actual Accuracy = "actual"
	// Estimated ...
	Estimated Accuracy = "estimated"
)

// Bitness enumerates the values for bitness.
type Bitness string

const (
	// SixFourbit ...
	SixFourbit Bitness = "64bit"
	// ThreeTwobit ...
	ThreeTwobit Bitness = "32bit"
)

// ConnectionFailureState enumerates the values for connection failure state.
type ConnectionFailureState string

const (
	// Failed ...
	Failed ConnectionFailureState = "failed"
	// Mixed ...
	Mixed ConnectionFailureState = "mixed"
	// Ok ...
	Ok ConnectionFailureState = "ok"
)

// HypervisorType enumerates the values for hypervisor type.
type HypervisorType string

const (
	// Hyperv ...
	Hyperv HypervisorType = "hyperv"
	// Unknown ...
	Unknown HypervisorType = "unknown"
)

// Kind enumerates the values for kind.
type Kind string

const (
	// KindRefmachine ...
	KindRefmachine Kind = "ref:machine"
	// KindRefmachinewithhints ...
	KindRefmachinewithhints Kind = "ref:machinewithhints"
	// KindRefport ...
	KindRefport Kind = "ref:port"
	// KindRefprocess ...
	KindRefprocess Kind = "ref:process"
	// KindResourceReference ...
	KindResourceReference Kind = "ResourceReference"
)

// KindBasicCoreResource enumerates the values for kind basic core resource.
type KindBasicCoreResource string

const (
	// KindClientGroup ...
	KindClientGroup KindBasicCoreResource = "clientGroup"
	// KindCoreResource ...
	KindCoreResource KindBasicCoreResource = "CoreResource"
	// KindMachine ...
	KindMachine KindBasicCoreResource = "machine"
	// KindMachineGroup ...
	KindMachineGroup KindBasicCoreResource = "machineGroup"
	// KindPort ...
	KindPort KindBasicCoreResource = "port"
	// KindProcess ...
	KindProcess KindBasicCoreResource = "process"
)

// KindBasicMapRequest enumerates the values for kind basic map request.
type KindBasicMapRequest string

const (
	// KindMapmachineGroupDependency ...
	KindMapmachineGroupDependency KindBasicMapRequest = "map:machine-group-dependency"
	// KindMapRequest ...
	KindMapRequest KindBasicMapRequest = "MapRequest"
	// KindMapsingleMachineDependency ...
	KindMapsingleMachineDependency KindBasicMapRequest = "map:single-machine-dependency"
)

// KindBasicRelationship enumerates the values for kind basic relationship.
type KindBasicRelationship string

const (
	// KindRelacceptor ...
	KindRelacceptor KindBasicRelationship = "rel:acceptor"
	// KindRelationship ...
	KindRelationship KindBasicRelationship = "Relationship"
	// KindRelconnection ...
	KindRelconnection KindBasicRelationship = "rel:connection"
)

// MachineRebootStatus enumerates the values for machine reboot status.
type MachineRebootStatus string

const (
	// MachineRebootStatusNotRebooted ...
	MachineRebootStatusNotRebooted MachineRebootStatus = "notRebooted"
	// MachineRebootStatusRebooted ...
	MachineRebootStatusRebooted MachineRebootStatus = "rebooted"
	// MachineRebootStatusUnknown ...
	MachineRebootStatusUnknown MachineRebootStatus = "unknown"
)

// MonitoringState enumerates the values for monitoring state.
type MonitoringState string

const (
	// Discovered ...
	Discovered MonitoringState = "discovered"
	// Monitored ...
	Monitored MonitoringState = "monitored"
)

// OperatingSystemFamily enumerates the values for operating system family.
type OperatingSystemFamily string

const (
	// OperatingSystemFamilyAix ...
	OperatingSystemFamilyAix OperatingSystemFamily = "aix"
	// OperatingSystemFamilyLinux ...
	OperatingSystemFamilyLinux OperatingSystemFamily = "linux"
	// OperatingSystemFamilySolaris ...
	OperatingSystemFamilySolaris OperatingSystemFamily = "solaris"
	// OperatingSystemFamilyUnknown ...
	OperatingSystemFamilyUnknown OperatingSystemFamily = "unknown"
	// OperatingSystemFamilyWindows ...
	OperatingSystemFamilyWindows OperatingSystemFamily = "windows"
)

// ProcessRole enumerates the values for process role.
type ProcessRole string

const (
	// AppServer ...
	AppServer ProcessRole = "appServer"
	// DatabaseServer ...
	DatabaseServer ProcessRole = "databaseServer"
	// LdapServer ...
	LdapServer ProcessRole = "ldapServer"
	// SmbServer ...
	SmbServer ProcessRole = "smbServer"
	// WebServer ...
	WebServer ProcessRole = "webServer"
)

// VirtualizationState enumerates the values for virtualization state.
type VirtualizationState string

const (
	// VirtualizationStateHypervisor ...
	VirtualizationStateHypervisor VirtualizationState = "hypervisor"
	// VirtualizationStatePhysical ...
	VirtualizationStatePhysical VirtualizationState = "physical"
	// VirtualizationStateUnknown ...
	VirtualizationStateUnknown VirtualizationState = "unknown"
	// VirtualizationStateVirtual ...
	VirtualizationStateVirtual VirtualizationState = "virtual"
)

// VirtualMachineType enumerates the values for virtual machine type.
type VirtualMachineType string

const (
	// VirtualMachineTypeHyperv ...
	VirtualMachineTypeHyperv VirtualMachineType = "hyperv"
	// VirtualMachineTypeLdom ...
	VirtualMachineTypeLdom VirtualMachineType = "ldom"
	// VirtualMachineTypeLpar ...
	VirtualMachineTypeLpar VirtualMachineType = "lpar"
	// VirtualMachineTypeUnknown ...
	VirtualMachineTypeUnknown VirtualMachineType = "unknown"
	// VirtualMachineTypeVirtualPc ...
	VirtualMachineTypeVirtualPc VirtualMachineType = "virtualPc"
	// VirtualMachineTypeVmware ...
	VirtualMachineTypeVmware VirtualMachineType = "vmware"
	// VirtualMachineTypeXen ...
	VirtualMachineTypeXen VirtualMachineType = "xen"
)

// Acceptor a process accepting on a port.
type Acceptor struct {
	// ID - Resource identifier.
	ID *string `json:"id,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Kind - Possible values include: 'KindRelationship', 'KindRelconnection', 'KindRelacceptor'
	Kind                KindBasicRelationship `json:"kind,omitempty"`
	*AcceptorProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Acceptor.
func (a Acceptor) MarshalJSON() ([]byte, error) {
	a.Kind = KindRelacceptor
	type Alias Acceptor
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(a),
	})
}

// AsCoreResource is the BasicResource implementation for Acceptor.
func (a Acceptor) AsCoreResource() (*CoreResource, bool) {
	return nil, false
}

// AsBasicCoreResource is the BasicResource implementation for Acceptor.
func (a Acceptor) AsBasicCoreResource() (BasicCoreResource, bool) {
	return nil, false
}

// AsMachine is the BasicResource implementation for Acceptor.
func (a Acceptor) AsMachine() (*Machine, bool) {
	return nil, false
}

// AsProcess is the BasicResource implementation for Acceptor.
func (a Acceptor) AsProcess() (*Process, bool) {
	return nil, false
}

// AsPort is the BasicResource implementation for Acceptor.
func (a Acceptor) AsPort() (*Port, bool) {
	return nil, false
}

// AsClientGroup is the BasicResource implementation for Acceptor.
func (a Acceptor) AsClientGroup() (*ClientGroup, bool) {
	return nil, false
}

// AsClientGroupMember is the BasicResource implementation for Acceptor.
func (a Acceptor) AsClientGroupMember() (*ClientGroupMember, bool) {
	return nil, false
}

// AsMachineGroup is the BasicResource implementation for Acceptor.
func (a Acceptor) AsMachineGroup() (*MachineGroup, bool) {
	return nil, false
}

// AsSummary is the BasicResource implementation for Acceptor.
func (a Acceptor) AsSummary() (*Summary, bool) {
	return nil, false
}

// AsMachinesSummary is the BasicResource implementation for Acceptor.
func (a Acceptor) AsMachinesSummary() (*MachinesSummary, bool) {
	return nil, false
}

// AsRelationship is the BasicResource implementation for Acceptor.
func (a Acceptor) AsRelationship() (*Relationship, bool) {
	return nil, false
}

// AsBasicRelationship is the BasicResource implementation for Acceptor.
func (a Acceptor) AsBasicRelationship() (BasicRelationship, bool) {
	return &a, true
}

// AsConnection is the BasicResource implementation for Acceptor.
func (a Acceptor) AsConnection() (*Connection, bool) {
	return nil, false
}

// AsAcceptor is the BasicResource implementation for Acceptor.
func (a Acceptor) AsAcceptor() (*Acceptor, bool) {
	return &a, true
}

// UnmarshalJSON is the custom unmarshaler for Acceptor struct.
func (a *Acceptor) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		var properties AcceptorProperties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		a.AcceptorProperties = &properties
	}

	v = m["kind"]
	if v != nil {
		var kind KindBasicRelationship
		err = json.Unmarshal(*m["kind"], &kind)
		if err != nil {
			return err
		}
		a.Kind = kind
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		a.ID = &ID
	}

	v = m["type"]
	if v != nil {
		var typeVar string
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		a.Type = &typeVar
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		a.Name = &name
	}

	return nil
}

// AcceptorProperties properties for an acceptor relationship.
type AcceptorProperties struct {
	// Source - Port being accepted.
	Source *PortReference `json:"source,omitempty"`
	// Destination - Accepting process.
	Destination *ProcessReference `json:"destination,omitempty"`
	// StartTime - Relationship start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Relationship end time.
	EndTime *date.Time `json:"endTime,omitempty"`
}

// AgentConfiguration describes the configuration of the Dependency Agent installed on a machine.
type AgentConfiguration struct {
	// AgentID - Health Service Agent unique identifier.
	AgentID *string `json:"agentId,omitempty"`
	// DependencyAgentID - Dependency Agent unique identifier.
	DependencyAgentID *string `json:"dependencyAgentId,omitempty"`
	// DependencyAgentVersion - Dependency Agent version number.
	DependencyAgentVersion *string `json:"dependencyAgentVersion,omitempty"`
	// DependencyAgentRevision - Dependency Agent revision number.
	DependencyAgentRevision *string `json:"dependencyAgentRevision,omitempty"`
	// RebootStatus - Specifies whether the machine has been rebooted since the Dependency Agent installation. Possible values include: 'MachineRebootStatusUnknown', 'MachineRebootStatusRebooted', 'MachineRebootStatusNotRebooted'
	RebootStatus MachineRebootStatus `json:"rebootStatus,omitempty"`
	// ClockGranularity - Machine clock granularity in milliseconds.
	ClockGranularity *int32 `json:"clockGranularity,omitempty"`
}

// ClientGroup represents a collection of clients of a resource. A client group can represent the clients of a port,
// process, or a machine.
type ClientGroup struct {
	autorest.Response `json:"-"`
	// ID - Resource identifier.
	ID *string `json:"id,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Etag - Resource ETAG.
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindCoreResource', 'KindMachine', 'KindProcess', 'KindPort', 'KindClientGroup', 'KindMachineGroup'
	Kind KindBasicCoreResource `json:"kind,omitempty"`
	// ClientGroupProperties - Resource properties.
	*ClientGroupProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ClientGroup.
func (cg ClientGroup) MarshalJSON() ([]byte, error) {
	cg.Kind = KindClientGroup
	type Alias ClientGroup
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(cg),
	})
}

// AsCoreResource is the BasicResource implementation for ClientGroup.
func (cg ClientGroup) AsCoreResource() (*CoreResource, bool) {
	return nil, false
}

// AsBasicCoreResource is the BasicResource implementation for ClientGroup.
func (cg ClientGroup) AsBasicCoreResource() (BasicCoreResource, bool) {
	return &cg, true
}

// AsMachine is the BasicResource implementation for ClientGroup.
func (cg ClientGroup) AsMachine() (*Machine, bool) {
	return nil, false
}

// AsProcess is the BasicResource implementation for ClientGroup.
func (cg ClientGroup) AsProcess() (*Process, bool) {
	return nil, false
}

// AsPort is the BasicResource implementation for ClientGroup.
func (cg ClientGroup) AsPort() (*Port, bool) {
	return nil, false
}

// AsClientGroup is the BasicResource implementation for ClientGroup.
func (cg ClientGroup) AsClientGroup() (*ClientGroup, bool) {
	return &cg, true
}

// AsClientGroupMember is the BasicResource implementation for ClientGroup.
func (cg ClientGroup) AsClientGroupMember() (*ClientGroupMember, bool) {
	return nil, false
}

// AsMachineGroup is the BasicResource implementation for ClientGroup.
func (cg ClientGroup) AsMachineGroup() (*MachineGroup, bool) {
	return nil, false
}

// AsSummary is the BasicResource implementation for ClientGroup.
func (cg ClientGroup) AsSummary() (*Summary, bool) {
	return nil, false
}

// AsMachinesSummary is the BasicResource implementation for ClientGroup.
func (cg ClientGroup) AsMachinesSummary() (*MachinesSummary, bool) {
	return nil, false
}

// AsRelationship is the BasicResource implementation for ClientGroup.
func (cg ClientGroup) AsRelationship() (*Relationship, bool) {
	return nil, false
}

// AsBasicRelationship is the BasicResource implementation for ClientGroup.
func (cg ClientGroup) AsBasicRelationship() (BasicRelationship, bool) {
	return nil, false
}

// AsConnection is the BasicResource implementation for ClientGroup.
func (cg ClientGroup) AsConnection() (*Connection, bool) {
	return nil, false
}

// AsAcceptor is the BasicResource implementation for ClientGroup.
func (cg ClientGroup) AsAcceptor() (*Acceptor, bool) {
	return nil, false
}

// UnmarshalJSON is the custom unmarshaler for ClientGroup struct.
func (cg *ClientGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		var properties ClientGroupProperties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		cg.ClientGroupProperties = &properties
	}

	v = m["etag"]
	if v != nil {
		var etag string
		err = json.Unmarshal(*m["etag"], &etag)
		if err != nil {
			return err
		}
		cg.Etag = &etag
	}

	v = m["kind"]
	if v != nil {
		var kind KindBasicCoreResource
		err = json.Unmarshal(*m["kind"], &kind)
		if err != nil {
			return err
		}
		cg.Kind = kind
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		cg.ID = &ID
	}

	v = m["type"]
	if v != nil {
		var typeVar string
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		cg.Type = &typeVar
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		cg.Name = &name
	}

	return nil
}

// ClientGroupMember represents a member of a client group
type ClientGroupMember struct {
	// ID - Resource identifier.
	ID *string `json:"id,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// ClientGroupMemberProperties - Resource properties.
	*ClientGroupMemberProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ClientGroupMember struct.
func (cgm *ClientGroupMember) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		var properties ClientGroupMemberProperties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		cgm.ClientGroupMemberProperties = &properties
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		cgm.ID = &ID
	}

	v = m["type"]
	if v != nil {
		var typeVar string
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		cgm.Type = &typeVar
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		cgm.Name = &name
	}

	return nil
}

// ClientGroupMemberProperties resource properties.
type ClientGroupMemberProperties struct {
	// IPAddress - IP address.
	IPAddress *string `json:"ipAddress,omitempty"`
	// Port - Port into which this client connected
	Port *PortReference `json:"port,omitempty"`
	// Processes - Processes accepting on the above port that received connections from this client.
	Processes *[]ProcessReference `json:"processes,omitempty"`
}

// ClientGroupMembersCollection collection of ClientGroupMember resources.
type ClientGroupMembersCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of ClientGroupMember resources.
	Value *[]ClientGroupMember `json:"value,omitempty"`
	// NextLink - The URL to the next set of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// ClientGroupMembersCollectionIterator provides access to a complete listing of ClientGroupMember values.
type ClientGroupMembersCollectionIterator struct {
	i    int
	page ClientGroupMembersCollectionPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ClientGroupMembersCollectionIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ClientGroupMembersCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ClientGroupMembersCollectionIterator) Response() ClientGroupMembersCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ClientGroupMembersCollectionIterator) Value() ClientGroupMember {
	if !iter.page.NotDone() {
		return ClientGroupMember{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (cgmc ClientGroupMembersCollection) IsEmpty() bool {
	return cgmc.Value == nil || len(*cgmc.Value) == 0
}

// clientGroupMembersCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cgmc ClientGroupMembersCollection) clientGroupMembersCollectionPreparer() (*http.Request, error) {
	if cgmc.NextLink == nil || len(to.String(cgmc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cgmc.NextLink)))
}

// ClientGroupMembersCollectionPage contains a page of ClientGroupMember values.
type ClientGroupMembersCollectionPage struct {
	fn   func(ClientGroupMembersCollection) (ClientGroupMembersCollection, error)
	cgmc ClientGroupMembersCollection
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ClientGroupMembersCollectionPage) Next() error {
	next, err := page.fn(page.cgmc)
	if err != nil {
		return err
	}
	page.cgmc = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ClientGroupMembersCollectionPage) NotDone() bool {
	return !page.cgmc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ClientGroupMembersCollectionPage) Response() ClientGroupMembersCollection {
	return page.cgmc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ClientGroupMembersCollectionPage) Values() []ClientGroupMember {
	if page.cgmc.IsEmpty() {
		return nil
	}
	return *page.cgmc.Value
}

// ClientGroupMembersCount specifies the number of members in a client group.
type ClientGroupMembersCount struct {
	autorest.Response `json:"-"`
	// StartTime - Membership interval start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Membership interval start time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// GroupID - Client Group URI.
	GroupID *string `json:"groupId,omitempty"`
	// Count - Number of members in the client group. Use this value together with the value of ```accuracy```. If accuracy is `exact` then the value represents the actual number of members in the cloud. When accuracy is `estimated`, the actual number of members is larger than the value of ```count```.
	Count *int32 `json:"count,omitempty"`
	// Accuracy - Accuracy of the reported count. Possible values include: 'Actual', 'Estimated'
	Accuracy Accuracy `json:"accuracy,omitempty"`
}

// ClientGroupProperties resource properties.
type ClientGroupProperties struct {
	// ClientsOf - Reference to the resource whose clients are represented by this group.
	ClientsOf BasicResourceReference `json:"clientsOf,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ClientGroupProperties struct.
func (cg *ClientGroupProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["clientsOf"]
	if v != nil {
		clientsOf, err := unmarshalBasicResourceReference(*m["clientsOf"])
		if err != nil {
			return err
		}
		cg.ClientsOf = clientsOf
	}

	return nil
}

// Connection a network connection.
type Connection struct {
	// ID - Resource identifier.
	ID *string `json:"id,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Kind - Possible values include: 'KindRelationship', 'KindRelconnection', 'KindRelacceptor'
	Kind                  KindBasicRelationship `json:"kind,omitempty"`
	*ConnectionProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Connection.
func (c Connection) MarshalJSON() ([]byte, error) {
	c.Kind = KindRelconnection
	type Alias Connection
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(c),
	})
}

// AsCoreResource is the BasicResource implementation for Connection.
func (c Connection) AsCoreResource() (*CoreResource, bool) {
	return nil, false
}

// AsBasicCoreResource is the BasicResource implementation for Connection.
func (c Connection) AsBasicCoreResource() (BasicCoreResource, bool) {
	return nil, false
}

// AsMachine is the BasicResource implementation for Connection.
func (c Connection) AsMachine() (*Machine, bool) {
	return nil, false
}

// AsProcess is the BasicResource implementation for Connection.
func (c Connection) AsProcess() (*Process, bool) {
	return nil, false
}

// AsPort is the BasicResource implementation for Connection.
func (c Connection) AsPort() (*Port, bool) {
	return nil, false
}

// AsClientGroup is the BasicResource implementation for Connection.
func (c Connection) AsClientGroup() (*ClientGroup, bool) {
	return nil, false
}

// AsClientGroupMember is the BasicResource implementation for Connection.
func (c Connection) AsClientGroupMember() (*ClientGroupMember, bool) {
	return nil, false
}

// AsMachineGroup is the BasicResource implementation for Connection.
func (c Connection) AsMachineGroup() (*MachineGroup, bool) {
	return nil, false
}

// AsSummary is the BasicResource implementation for Connection.
func (c Connection) AsSummary() (*Summary, bool) {
	return nil, false
}

// AsMachinesSummary is the BasicResource implementation for Connection.
func (c Connection) AsMachinesSummary() (*MachinesSummary, bool) {
	return nil, false
}

// AsRelationship is the BasicResource implementation for Connection.
func (c Connection) AsRelationship() (*Relationship, bool) {
	return nil, false
}

// AsBasicRelationship is the BasicResource implementation for Connection.
func (c Connection) AsBasicRelationship() (BasicRelationship, bool) {
	return &c, true
}

// AsConnection is the BasicResource implementation for Connection.
func (c Connection) AsConnection() (*Connection, bool) {
	return &c, true
}

// AsAcceptor is the BasicResource implementation for Connection.
func (c Connection) AsAcceptor() (*Acceptor, bool) {
	return nil, false
}

// UnmarshalJSON is the custom unmarshaler for Connection struct.
func (c *Connection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		var properties ConnectionProperties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		c.ConnectionProperties = &properties
	}

	v = m["kind"]
	if v != nil {
		var kind KindBasicRelationship
		err = json.Unmarshal(*m["kind"], &kind)
		if err != nil {
			return err
		}
		c.Kind = kind
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		c.ID = &ID
	}

	v = m["type"]
	if v != nil {
		var typeVar string
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		c.Type = &typeVar
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		c.Name = &name
	}

	return nil
}

// ConnectionCollection collection of Connection resources.
type ConnectionCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of Connection resources.
	Value *[]Connection `json:"value,omitempty"`
	// NextLink - The URL to the next set of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// ConnectionCollectionIterator provides access to a complete listing of Connection values.
type ConnectionCollectionIterator struct {
	i    int
	page ConnectionCollectionPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ConnectionCollectionIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ConnectionCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ConnectionCollectionIterator) Response() ConnectionCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ConnectionCollectionIterator) Value() Connection {
	if !iter.page.NotDone() {
		return Connection{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (cc ConnectionCollection) IsEmpty() bool {
	return cc.Value == nil || len(*cc.Value) == 0
}

// connectionCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cc ConnectionCollection) connectionCollectionPreparer() (*http.Request, error) {
	if cc.NextLink == nil || len(to.String(cc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cc.NextLink)))
}

// ConnectionCollectionPage contains a page of Connection values.
type ConnectionCollectionPage struct {
	fn func(ConnectionCollection) (ConnectionCollection, error)
	cc ConnectionCollection
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ConnectionCollectionPage) Next() error {
	next, err := page.fn(page.cc)
	if err != nil {
		return err
	}
	page.cc = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ConnectionCollectionPage) NotDone() bool {
	return !page.cc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ConnectionCollectionPage) Response() ConnectionCollection {
	return page.cc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ConnectionCollectionPage) Values() []Connection {
	if page.cc.IsEmpty() {
		return nil
	}
	return *page.cc.Value
}

// ConnectionProperties properties for a connection resource.
type ConnectionProperties struct {
	// Source - Source resource of the relationship.
	Source BasicResourceReference `json:"source,omitempty"`
	// Destination - Destination resource of the relationship.
	Destination BasicResourceReference `json:"destination,omitempty"`
	// StartTime - Relationship start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Relationship end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// ServerPort - Reference to the server port via which this connection has been established.
	ServerPort *PortReference `json:"serverPort,omitempty"`
	// FailureState - Specifies whether there are only successful, failed or a mixture of both connections represented by this resource. Possible values include: 'Ok', 'Failed', 'Mixed'
	FailureState ConnectionFailureState `json:"failureState,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ConnectionProperties struct.
func (cp *ConnectionProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["serverPort"]
	if v != nil {
		var serverPort PortReference
		err = json.Unmarshal(*m["serverPort"], &serverPort)
		if err != nil {
			return err
		}
		cp.ServerPort = &serverPort
	}

	v = m["failureState"]
	if v != nil {
		var failureState ConnectionFailureState
		err = json.Unmarshal(*m["failureState"], &failureState)
		if err != nil {
			return err
		}
		cp.FailureState = failureState
	}

	v = m["source"]
	if v != nil {
		source, err := unmarshalBasicResourceReference(*m["source"])
		if err != nil {
			return err
		}
		cp.Source = source
	}

	v = m["destination"]
	if v != nil {
		destination, err := unmarshalBasicResourceReference(*m["destination"])
		if err != nil {
			return err
		}
		cp.Destination = destination
	}

	v = m["startTime"]
	if v != nil {
		var startTime date.Time
		err = json.Unmarshal(*m["startTime"], &startTime)
		if err != nil {
			return err
		}
		cp.StartTime = &startTime
	}

	v = m["endTime"]
	if v != nil {
		var endTime date.Time
		err = json.Unmarshal(*m["endTime"], &endTime)
		if err != nil {
			return err
		}
		cp.EndTime = &endTime
	}

	return nil
}

// BasicCoreResource marker resource for the core Service Map resources
type BasicCoreResource interface {
	AsMachine() (*Machine, bool)
	AsProcess() (*Process, bool)
	AsPort() (*Port, bool)
	AsClientGroup() (*ClientGroup, bool)
	AsMachineGroup() (*MachineGroup, bool)
	AsCoreResource() (*CoreResource, bool)
}

// CoreResource marker resource for the core Service Map resources
type CoreResource struct {
	// ID - Resource identifier.
	ID *string `json:"id,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Etag - Resource ETAG.
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindCoreResource', 'KindMachine', 'KindProcess', 'KindPort', 'KindClientGroup', 'KindMachineGroup'
	Kind KindBasicCoreResource `json:"kind,omitempty"`
}

func unmarshalBasicCoreResource(body []byte) (BasicCoreResource, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m[""] {
	case string(KindMachine):
		var mVar Machine
		err := json.Unmarshal(body, &mVar)
		return mVar, err
	case string(KindProcess):
		var p Process
		err := json.Unmarshal(body, &p)
		return p, err
	case string(KindPort):
		var p Port
		err := json.Unmarshal(body, &p)
		return p, err
	case string(KindClientGroup):
		var cg ClientGroup
		err := json.Unmarshal(body, &cg)
		return cg, err
	case string(KindMachineGroup):
		var mg MachineGroup
		err := json.Unmarshal(body, &mg)
		return mg, err
	default:
		var cr CoreResource
		err := json.Unmarshal(body, &cr)
		return cr, err
	}
}
func unmarshalBasicCoreResourceArray(body []byte) ([]BasicCoreResource, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	crArray := make([]BasicCoreResource, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cr, err := unmarshalBasicCoreResource(*rawMessage)
		if err != nil {
			return nil, err
		}
		crArray[index] = cr
	}
	return crArray, nil
}

// MarshalJSON is the custom marshaler for CoreResource.
func (cr CoreResource) MarshalJSON() ([]byte, error) {
	cr.Kind = KindCoreResource
	type Alias CoreResource
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(cr),
	})
}

// AsCoreResource is the BasicResource implementation for CoreResource.
func (cr CoreResource) AsCoreResource() (*CoreResource, bool) {
	return &cr, true
}

// AsBasicCoreResource is the BasicResource implementation for CoreResource.
func (cr CoreResource) AsBasicCoreResource() (BasicCoreResource, bool) {
	return &cr, true
}

// AsMachine is the BasicResource implementation for CoreResource.
func (cr CoreResource) AsMachine() (*Machine, bool) {
	return nil, false
}

// AsProcess is the BasicResource implementation for CoreResource.
func (cr CoreResource) AsProcess() (*Process, bool) {
	return nil, false
}

// AsPort is the BasicResource implementation for CoreResource.
func (cr CoreResource) AsPort() (*Port, bool) {
	return nil, false
}

// AsClientGroup is the BasicResource implementation for CoreResource.
func (cr CoreResource) AsClientGroup() (*ClientGroup, bool) {
	return nil, false
}

// AsClientGroupMember is the BasicResource implementation for CoreResource.
func (cr CoreResource) AsClientGroupMember() (*ClientGroupMember, bool) {
	return nil, false
}

// AsMachineGroup is the BasicResource implementation for CoreResource.
func (cr CoreResource) AsMachineGroup() (*MachineGroup, bool) {
	return nil, false
}

// AsSummary is the BasicResource implementation for CoreResource.
func (cr CoreResource) AsSummary() (*Summary, bool) {
	return nil, false
}

// AsMachinesSummary is the BasicResource implementation for CoreResource.
func (cr CoreResource) AsMachinesSummary() (*MachinesSummary, bool) {
	return nil, false
}

// AsRelationship is the BasicResource implementation for CoreResource.
func (cr CoreResource) AsRelationship() (*Relationship, bool) {
	return nil, false
}

// AsBasicRelationship is the BasicResource implementation for CoreResource.
func (cr CoreResource) AsBasicRelationship() (BasicRelationship, bool) {
	return nil, false
}

// AsConnection is the BasicResource implementation for CoreResource.
func (cr CoreResource) AsConnection() (*Connection, bool) {
	return nil, false
}

// AsAcceptor is the BasicResource implementation for CoreResource.
func (cr CoreResource) AsAcceptor() (*Acceptor, bool) {
	return nil, false
}

// Error error details.
type Error struct {
	// Code - Error code identifying the specific error.
	Code *string `json:"code,omitempty"`
	// Message - Error message in the caller's locale.
	Message *string `json:"message,omitempty"`
}

// ErrorResponse an error response from the API.
type ErrorResponse struct {
	// Error - Error information.
	Error *Error `json:"error,omitempty"`
}

// HypervisorConfiguration describes the hypervisor configuration of a machine.
type HypervisorConfiguration struct {
	// HypervisorType - Specifies the virtualization technology used by the hypervisor (hyperv, vmware, etc.). Possible values include: 'Unknown', 'Hyperv'
	HypervisorType HypervisorType `json:"hypervisorType,omitempty"`
	// NativeHostMachineID - The unique identifier of the hypervisor machine as reported by the underlying virtualization system.
	NativeHostMachineID *string `json:"nativeHostMachineId,omitempty"`
}

// Ipv4NetworkInterface describes an IPv4 network interface.
type Ipv4NetworkInterface struct {
	// IPAddress - IPv4 address.
	IPAddress *string `json:"ipAddress,omitempty"`
	// SubnetMask - IPv4 subnet mask.
	SubnetMask *string `json:"subnetMask,omitempty"`
}

// Ipv6NetworkInterface describes an IPv6 network interface.
type Ipv6NetworkInterface struct {
	// IPAddress - IPv6 address.
	IPAddress *string `json:"ipAddress,omitempty"`
}

// Liveness specifies the contents of a check liveness response.
type Liveness struct {
	autorest.Response `json:"-"`
	// StartTime - Liveness interval start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Liveness interval end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Live - `true` if the resource is live during [startTime, endTime], `false` otherwise
	Live *bool `json:"live,omitempty"`
}

// Machine a machine resource represents a discovered computer system. It can be *monitored*, i.e., a Dependency Agent
// is running on it, or *discovered*, i.e., its existence was inferred by observing the data stream from monitored
// machines. As machines change, prior versions of the machine resource are preserved and available for access. A
// machine is live during an interval of time, if either its Dependency Agent has reported data during (parts) of that
// interval, or a Dependency agent running on other machines has reported activity associated with the machine.
type Machine struct {
	autorest.Response `json:"-"`
	// ID - Resource identifier.
	ID *string `json:"id,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Etag - Resource ETAG.
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindCoreResource', 'KindMachine', 'KindProcess', 'KindPort', 'KindClientGroup', 'KindMachineGroup'
	Kind KindBasicCoreResource `json:"kind,omitempty"`
	// MachineProperties - Resource properties.
	*MachineProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Machine.
func (mVar Machine) MarshalJSON() ([]byte, error) {
	mVar.Kind = KindMachine
	type Alias Machine
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(mVar),
	})
}

// AsCoreResource is the BasicResource implementation for Machine.
func (mVar Machine) AsCoreResource() (*CoreResource, bool) {
	return nil, false
}

// AsBasicCoreResource is the BasicResource implementation for Machine.
func (mVar Machine) AsBasicCoreResource() (BasicCoreResource, bool) {
	return &mVar, true
}

// AsMachine is the BasicResource implementation for Machine.
func (mVar Machine) AsMachine() (*Machine, bool) {
	return &mVar, true
}

// AsProcess is the BasicResource implementation for Machine.
func (mVar Machine) AsProcess() (*Process, bool) {
	return nil, false
}

// AsPort is the BasicResource implementation for Machine.
func (mVar Machine) AsPort() (*Port, bool) {
	return nil, false
}

// AsClientGroup is the BasicResource implementation for Machine.
func (mVar Machine) AsClientGroup() (*ClientGroup, bool) {
	return nil, false
}

// AsClientGroupMember is the BasicResource implementation for Machine.
func (mVar Machine) AsClientGroupMember() (*ClientGroupMember, bool) {
	return nil, false
}

// AsMachineGroup is the BasicResource implementation for Machine.
func (mVar Machine) AsMachineGroup() (*MachineGroup, bool) {
	return nil, false
}

// AsSummary is the BasicResource implementation for Machine.
func (mVar Machine) AsSummary() (*Summary, bool) {
	return nil, false
}

// AsMachinesSummary is the BasicResource implementation for Machine.
func (mVar Machine) AsMachinesSummary() (*MachinesSummary, bool) {
	return nil, false
}

// AsRelationship is the BasicResource implementation for Machine.
func (mVar Machine) AsRelationship() (*Relationship, bool) {
	return nil, false
}

// AsBasicRelationship is the BasicResource implementation for Machine.
func (mVar Machine) AsBasicRelationship() (BasicRelationship, bool) {
	return nil, false
}

// AsConnection is the BasicResource implementation for Machine.
func (mVar Machine) AsConnection() (*Connection, bool) {
	return nil, false
}

// AsAcceptor is the BasicResource implementation for Machine.
func (mVar Machine) AsAcceptor() (*Acceptor, bool) {
	return nil, false
}

// UnmarshalJSON is the custom unmarshaler for Machine struct.
func (mVar *Machine) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		var properties MachineProperties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		mVar.MachineProperties = &properties
	}

	v = m["etag"]
	if v != nil {
		var etag string
		err = json.Unmarshal(*m["etag"], &etag)
		if err != nil {
			return err
		}
		mVar.Etag = &etag
	}

	v = m["kind"]
	if v != nil {
		var kind KindBasicCoreResource
		err = json.Unmarshal(*m["kind"], &kind)
		if err != nil {
			return err
		}
		mVar.Kind = kind
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		mVar.ID = &ID
	}

	v = m["type"]
	if v != nil {
		var typeVar string
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		mVar.Type = &typeVar
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		mVar.Name = &name
	}

	return nil
}

// MachineCollection collection of Machine resources.
type MachineCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of Machine resources.
	Value *[]Machine `json:"value,omitempty"`
	// NextLink - The URL to the next set of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MachineCollectionIterator provides access to a complete listing of Machine values.
type MachineCollectionIterator struct {
	i    int
	page MachineCollectionPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *MachineCollectionIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter MachineCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter MachineCollectionIterator) Response() MachineCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter MachineCollectionIterator) Value() Machine {
	if !iter.page.NotDone() {
		return Machine{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (mc MachineCollection) IsEmpty() bool {
	return mc.Value == nil || len(*mc.Value) == 0
}

// machineCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mc MachineCollection) machineCollectionPreparer() (*http.Request, error) {
	if mc.NextLink == nil || len(to.String(mc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mc.NextLink)))
}

// MachineCollectionPage contains a page of Machine values.
type MachineCollectionPage struct {
	fn func(MachineCollection) (MachineCollection, error)
	mc MachineCollection
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *MachineCollectionPage) Next() error {
	next, err := page.fn(page.mc)
	if err != nil {
		return err
	}
	page.mc = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page MachineCollectionPage) NotDone() bool {
	return !page.mc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page MachineCollectionPage) Response() MachineCollection {
	return page.mc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page MachineCollectionPage) Values() []Machine {
	if page.mc.IsEmpty() {
		return nil
	}
	return *page.mc.Value
}

// MachineCountsByOperatingSystem machines by operating system.
type MachineCountsByOperatingSystem struct {
	// Windows - Number of live Windows machines.
	Windows *int32 `json:"windows,omitempty"`
	// Linux - Number of live Linux machines.
	Linux *int32 `json:"linux,omitempty"`
}

// MachineGroup a user-defined logical grouping of machines.
type MachineGroup struct {
	autorest.Response `json:"-"`
	// ID - Resource identifier.
	ID *string `json:"id,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Etag - Resource ETAG.
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindCoreResource', 'KindMachine', 'KindProcess', 'KindPort', 'KindClientGroup', 'KindMachineGroup'
	Kind KindBasicCoreResource `json:"kind,omitempty"`
	// MachineGroupProperties - Resource properties.
	*MachineGroupProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for MachineGroup.
func (mg MachineGroup) MarshalJSON() ([]byte, error) {
	mg.Kind = KindMachineGroup
	type Alias MachineGroup
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(mg),
	})
}

// AsCoreResource is the BasicResource implementation for MachineGroup.
func (mg MachineGroup) AsCoreResource() (*CoreResource, bool) {
	return nil, false
}

// AsBasicCoreResource is the BasicResource implementation for MachineGroup.
func (mg MachineGroup) AsBasicCoreResource() (BasicCoreResource, bool) {
	return &mg, true
}

// AsMachine is the BasicResource implementation for MachineGroup.
func (mg MachineGroup) AsMachine() (*Machine, bool) {
	return nil, false
}

// AsProcess is the BasicResource implementation for MachineGroup.
func (mg MachineGroup) AsProcess() (*Process, bool) {
	return nil, false
}

// AsPort is the BasicResource implementation for MachineGroup.
func (mg MachineGroup) AsPort() (*Port, bool) {
	return nil, false
}

// AsClientGroup is the BasicResource implementation for MachineGroup.
func (mg MachineGroup) AsClientGroup() (*ClientGroup, bool) {
	return nil, false
}

// AsClientGroupMember is the BasicResource implementation for MachineGroup.
func (mg MachineGroup) AsClientGroupMember() (*ClientGroupMember, bool) {
	return nil, false
}

// AsMachineGroup is the BasicResource implementation for MachineGroup.
func (mg MachineGroup) AsMachineGroup() (*MachineGroup, bool) {
	return &mg, true
}

// AsSummary is the BasicResource implementation for MachineGroup.
func (mg MachineGroup) AsSummary() (*Summary, bool) {
	return nil, false
}

// AsMachinesSummary is the BasicResource implementation for MachineGroup.
func (mg MachineGroup) AsMachinesSummary() (*MachinesSummary, bool) {
	return nil, false
}

// AsRelationship is the BasicResource implementation for MachineGroup.
func (mg MachineGroup) AsRelationship() (*Relationship, bool) {
	return nil, false
}

// AsBasicRelationship is the BasicResource implementation for MachineGroup.
func (mg MachineGroup) AsBasicRelationship() (BasicRelationship, bool) {
	return nil, false
}

// AsConnection is the BasicResource implementation for MachineGroup.
func (mg MachineGroup) AsConnection() (*Connection, bool) {
	return nil, false
}

// AsAcceptor is the BasicResource implementation for MachineGroup.
func (mg MachineGroup) AsAcceptor() (*Acceptor, bool) {
	return nil, false
}

// UnmarshalJSON is the custom unmarshaler for MachineGroup struct.
func (mg *MachineGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		var properties MachineGroupProperties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		mg.MachineGroupProperties = &properties
	}

	v = m["etag"]
	if v != nil {
		var etag string
		err = json.Unmarshal(*m["etag"], &etag)
		if err != nil {
			return err
		}
		mg.Etag = &etag
	}

	v = m["kind"]
	if v != nil {
		var kind KindBasicCoreResource
		err = json.Unmarshal(*m["kind"], &kind)
		if err != nil {
			return err
		}
		mg.Kind = kind
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		mg.ID = &ID
	}

	v = m["type"]
	if v != nil {
		var typeVar string
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		mg.Type = &typeVar
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		mg.Name = &name
	}

	return nil
}

// MachineGroupCollection collection of Machine Group resources.
type MachineGroupCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of Machine Group resources.
	Value *[]MachineGroup `json:"value,omitempty"`
	// NextLink - The URL to the next set of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MachineGroupCollectionIterator provides access to a complete listing of MachineGroup values.
type MachineGroupCollectionIterator struct {
	i    int
	page MachineGroupCollectionPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *MachineGroupCollectionIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter MachineGroupCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter MachineGroupCollectionIterator) Response() MachineGroupCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter MachineGroupCollectionIterator) Value() MachineGroup {
	if !iter.page.NotDone() {
		return MachineGroup{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (mgc MachineGroupCollection) IsEmpty() bool {
	return mgc.Value == nil || len(*mgc.Value) == 0
}

// machineGroupCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mgc MachineGroupCollection) machineGroupCollectionPreparer() (*http.Request, error) {
	if mgc.NextLink == nil || len(to.String(mgc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mgc.NextLink)))
}

// MachineGroupCollectionPage contains a page of MachineGroup values.
type MachineGroupCollectionPage struct {
	fn  func(MachineGroupCollection) (MachineGroupCollection, error)
	mgc MachineGroupCollection
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *MachineGroupCollectionPage) Next() error {
	next, err := page.fn(page.mgc)
	if err != nil {
		return err
	}
	page.mgc = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page MachineGroupCollectionPage) NotDone() bool {
	return !page.mgc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page MachineGroupCollectionPage) Response() MachineGroupCollection {
	return page.mgc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page MachineGroupCollectionPage) Values() []MachineGroup {
	if page.mgc.IsEmpty() {
		return nil
	}
	return *page.mgc.Value
}

// MachineGroupMapRequest specifies the computation of a machine group dependency map. A machine group dependency map
// includes all direct dependencies of a group of machines.
type MachineGroupMapRequest struct {
	// StartTime - Map interval start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Map interval end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Kind - Possible values include: 'KindMapRequest', 'KindMapsingleMachineDependency', 'KindMapmachineGroupDependency'
	Kind KindBasicMapRequest `json:"kind,omitempty"`
	// MachineGroupID - URI of machine group resource for which to generate the map.
	MachineGroupID *string `json:"machineGroupId,omitempty"`
	// FilterProcesses - If true, only processes between grouped machines will be included. Any connections in or out of those processes will be included.
	FilterProcesses *bool `json:"filterProcesses,omitempty"`
}

// MarshalJSON is the custom marshaler for MachineGroupMapRequest.
func (mgmr MachineGroupMapRequest) MarshalJSON() ([]byte, error) {
	mgmr.Kind = KindMapmachineGroupDependency
	type Alias MachineGroupMapRequest
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(mgmr),
	})
}

// AsSingleMachineDependencyMapRequest is the BasicMapRequest implementation for MachineGroupMapRequest.
func (mgmr MachineGroupMapRequest) AsSingleMachineDependencyMapRequest() (*SingleMachineDependencyMapRequest, bool) {
	return nil, false
}

// AsMachineGroupMapRequest is the BasicMapRequest implementation for MachineGroupMapRequest.
func (mgmr MachineGroupMapRequest) AsMachineGroupMapRequest() (*MachineGroupMapRequest, bool) {
	return &mgmr, true
}

// AsMapRequest is the BasicMapRequest implementation for MachineGroupMapRequest.
func (mgmr MachineGroupMapRequest) AsMapRequest() (*MapRequest, bool) {
	return nil, false
}

// AsBasicMapRequest is the BasicMapRequest implementation for MachineGroupMapRequest.
func (mgmr MachineGroupMapRequest) AsBasicMapRequest() (BasicMapRequest, bool) {
	return &mgmr, true
}

// MachineGroupProperties resource properties.
type MachineGroupProperties struct {
	// DisplayName - User defined name for the group
	DisplayName *string `json:"displayName,omitempty"`
	// Machines - References of the machines in this group. The hints within each reference do not represent the current value of  the corresponding fields. They are a snapshot created during the last time the machine group was updated.
	Machines *[]MachineReferenceWithHints `json:"machines,omitempty"`
}

// MachineProperties resource properties.
type MachineProperties struct {
	// Timestamp - UTC date and time when this resource was updated in the system.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// MonitoringState - Specifies whether the machine is actively monitored or discovered. Possible values include: 'Monitored', 'Discovered'
	MonitoringState MonitoringState `json:"monitoringState,omitempty"`
	// VirtualizationState - Specifies whether the machine is virtualized. Possible values include: 'VirtualizationStateUnknown', 'VirtualizationStatePhysical', 'VirtualizationStateVirtual', 'VirtualizationStateHypervisor'
	VirtualizationState VirtualizationState `json:"virtualizationState,omitempty"`
	// DisplayName - Name to use for display purposes
	DisplayName *string `json:"displayName,omitempty"`
	// ComputerName - Name of the machine, e.g., server
	ComputerName *string `json:"computerName,omitempty"`
	// FullyQualifiedDomainName - Fully-qualified name of the machine, e.g., server.company.com
	FullyQualifiedDomainName *string `json:"fullyQualifiedDomainName,omitempty"`
	// BootTime - UTC date and time when the machine last booted
	BootTime *date.Time `json:"bootTime,omitempty"`
	// Timezone - Timezone of the machine.
	Timezone *Timezone `json:"timezone,omitempty"`
	// Agent - Dependency Agent configuration.
	Agent *AgentConfiguration `json:"agent,omitempty"`
	// Resources - Machine resources (memory, cpu, etc.).
	Resources *MachineResourcesConfiguration `json:"resources,omitempty"`
	// Networking - Network configuration (ips, gateways, dns, etc.)
	Networking *NetworkConfiguration `json:"networking,omitempty"`
	// OperatingSystem - Operating system information.
	OperatingSystem *OperatingSystemConfiguration `json:"operatingSystem,omitempty"`
	// VirtualMachine - Virtualization-related configuration. Present only when `virtualizationState` is `virtual`.
	VirtualMachine *VirtualMachineConfiguration `json:"virtualMachine,omitempty"`
	// Hypervisor - Hypervisor-related configuration. Present only when 'virtualizationState' is `hypervisor`.
	Hypervisor *HypervisorConfiguration `json:"hypervisor,omitempty"`
}

// MachineReference reference to a machine.
type MachineReference struct {
	// ID - Resource URI.
	ID *string `json:"id,omitempty"`
	// Type - Resource type qualifier.
	Type *string `json:"type,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Kind - Possible values include: 'KindResourceReference', 'KindRefmachine', 'KindRefprocess', 'KindRefport', 'KindRefmachinewithhints'
	Kind Kind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for MachineReference.
func (mr MachineReference) MarshalJSON() ([]byte, error) {
	mr.Kind = KindRefmachine
	type Alias MachineReference
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(mr),
	})
}

// AsMachineReference is the BasicResourceReference implementation for MachineReference.
func (mr MachineReference) AsMachineReference() (*MachineReference, bool) {
	return &mr, true
}

// AsProcessReference is the BasicResourceReference implementation for MachineReference.
func (mr MachineReference) AsProcessReference() (*ProcessReference, bool) {
	return nil, false
}

// AsPortReference is the BasicResourceReference implementation for MachineReference.
func (mr MachineReference) AsPortReference() (*PortReference, bool) {
	return nil, false
}

// AsMachineReferenceWithHints is the BasicResourceReference implementation for MachineReference.
func (mr MachineReference) AsMachineReferenceWithHints() (*MachineReferenceWithHints, bool) {
	return nil, false
}

// AsResourceReference is the BasicResourceReference implementation for MachineReference.
func (mr MachineReference) AsResourceReference() (*ResourceReference, bool) {
	return nil, false
}

// AsBasicResourceReference is the BasicResourceReference implementation for MachineReference.
func (mr MachineReference) AsBasicResourceReference() (BasicResourceReference, bool) {
	return &mr, true
}

// MachineReferenceWithHints a machine reference with a hint of the machine's name and operating system.
type MachineReferenceWithHints struct {
	// ID - Resource URI.
	ID *string `json:"id,omitempty"`
	// Type - Resource type qualifier.
	Type *string `json:"type,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Kind - Possible values include: 'KindResourceReference', 'KindRefmachine', 'KindRefprocess', 'KindRefport', 'KindRefmachinewithhints'
	Kind Kind `json:"kind,omitempty"`
	// MachineReferenceWithHintsProperties - Machine reference with name and os hints.
	*MachineReferenceWithHintsProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for MachineReferenceWithHints.
func (mrwh MachineReferenceWithHints) MarshalJSON() ([]byte, error) {
	mrwh.Kind = KindRefmachinewithhints
	type Alias MachineReferenceWithHints
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(mrwh),
	})
}

// AsMachineReference is the BasicResourceReference implementation for MachineReferenceWithHints.
func (mrwh MachineReferenceWithHints) AsMachineReference() (*MachineReference, bool) {
	return nil, false
}

// AsProcessReference is the BasicResourceReference implementation for MachineReferenceWithHints.
func (mrwh MachineReferenceWithHints) AsProcessReference() (*ProcessReference, bool) {
	return nil, false
}

// AsPortReference is the BasicResourceReference implementation for MachineReferenceWithHints.
func (mrwh MachineReferenceWithHints) AsPortReference() (*PortReference, bool) {
	return nil, false
}

// AsMachineReferenceWithHints is the BasicResourceReference implementation for MachineReferenceWithHints.
func (mrwh MachineReferenceWithHints) AsMachineReferenceWithHints() (*MachineReferenceWithHints, bool) {
	return &mrwh, true
}

// AsResourceReference is the BasicResourceReference implementation for MachineReferenceWithHints.
func (mrwh MachineReferenceWithHints) AsResourceReference() (*ResourceReference, bool) {
	return nil, false
}

// AsBasicResourceReference is the BasicResourceReference implementation for MachineReferenceWithHints.
func (mrwh MachineReferenceWithHints) AsBasicResourceReference() (BasicResourceReference, bool) {
	return &mrwh, true
}

// UnmarshalJSON is the custom unmarshaler for MachineReferenceWithHints struct.
func (mrwh *MachineReferenceWithHints) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		var properties MachineReferenceWithHintsProperties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		mrwh.MachineReferenceWithHintsProperties = &properties
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		mrwh.ID = &ID
	}

	v = m["type"]
	if v != nil {
		var typeVar string
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		mrwh.Type = &typeVar
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		mrwh.Name = &name
	}

	v = m["kind"]
	if v != nil {
		var kind Kind
		err = json.Unmarshal(*m["kind"], &kind)
		if err != nil {
			return err
		}
		mrwh.Kind = kind
	}

	return nil
}

// MachineReferenceWithHintsProperties machine reference with name and os hints.
type MachineReferenceWithHintsProperties struct {
	// DisplayNameHint - Last known display name.
	DisplayNameHint *string `json:"displayNameHint,omitempty"`
	// OsFamilyHint - Last known operating system family. Possible values include: 'OperatingSystemFamilyUnknown', 'OperatingSystemFamilyWindows', 'OperatingSystemFamilyLinux', 'OperatingSystemFamilySolaris', 'OperatingSystemFamilyAix'
	OsFamilyHint OperatingSystemFamily `json:"osFamilyHint,omitempty"`
}

// MachineResourcesConfiguration describes the resources of a machine.
type MachineResourcesConfiguration struct {
	// PhysicalMemory - Physical memory in megabytes (MB).
	PhysicalMemory *int32 `json:"physicalMemory,omitempty"`
	// Cpus - Number of CPUs.
	Cpus *int32 `json:"cpus,omitempty"`
	// CPUSpeed - CPU speed in megahertz (Mhz).
	CPUSpeed *int32 `json:"cpuSpeed,omitempty"`
	// CPUSpeedAccuracy - Describes the accuracy of the cpuSpeed field. Possible values include: 'Actual', 'Estimated'
	CPUSpeedAccuracy Accuracy `json:"cpuSpeedAccuracy,omitempty"`
}

// MachinesSummary a summary of the machines in the workspace.
type MachinesSummary struct {
	autorest.Response `json:"-"`
	// ID - Resource identifier.
	ID *string `json:"id,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Name - Resource name.
	Name                       *string `json:"name,omitempty"`
	*MachinesSummaryProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for MachinesSummary struct.
func (ms *MachinesSummary) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		var properties MachinesSummaryProperties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		ms.MachinesSummaryProperties = &properties
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		ms.ID = &ID
	}

	v = m["type"]
	if v != nil {
		var typeVar string
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		ms.Type = &typeVar
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		ms.Name = &name
	}

	return nil
}

// MachinesSummaryProperties summarizes machines in the workspace.
type MachinesSummaryProperties struct {
	// StartTime - Summary interval start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Summary interval end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Total - Total number of machines.
	Total *int32 `json:"total,omitempty"`
	// Live - Number of live machines.
	Live *int32 `json:"live,omitempty"`
	// Os - Machine counts by operating system.
	Os *MachineCountsByOperatingSystem `json:"os,omitempty"`
}

// Map a map of resources and relationships between them.
type Map struct {
	Nodes *MapNodes `json:"nodes,omitempty"`
	Edges *MapEdges `json:"edges,omitempty"`
}

// MapEdges the edges (relationships) of a map.
type MapEdges struct {
	// Connections - Network connections.
	Connections *[]Connection `json:"connections,omitempty"`
	// Acceptors - Processes accepting on a port.
	Acceptors *[]Acceptor `json:"acceptors,omitempty"`
}

// MapNodes the nodes (entities) of a map.
type MapNodes struct {
	// Machines - Machine resources.
	Machines *[]Machine `json:"machines,omitempty"`
	// Processes - Process resources.
	Processes *[]Process `json:"processes,omitempty"`
	// Ports - Port resources.
	Ports *[]Port `json:"Ports,omitempty"`
	// ClientGroups - Client Group resources.
	ClientGroups *[]ClientGroup `json:"ClientGroups,omitempty"`
}

// BasicMapRequest specifies the contents of request to generate a map.
type BasicMapRequest interface {
	AsSingleMachineDependencyMapRequest() (*SingleMachineDependencyMapRequest, bool)
	AsMachineGroupMapRequest() (*MachineGroupMapRequest, bool)
	AsMapRequest() (*MapRequest, bool)
}

// MapRequest specifies the contents of request to generate a map.
type MapRequest struct {
	// StartTime - Map interval start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Map interval end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Kind - Possible values include: 'KindMapRequest', 'KindMapsingleMachineDependency', 'KindMapmachineGroupDependency'
	Kind KindBasicMapRequest `json:"kind,omitempty"`
}

func unmarshalBasicMapRequest(body []byte) (BasicMapRequest, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindMapsingleMachineDependency):
		var smdmr SingleMachineDependencyMapRequest
		err := json.Unmarshal(body, &smdmr)
		return smdmr, err
	case string(KindMapmachineGroupDependency):
		var mgmr MachineGroupMapRequest
		err := json.Unmarshal(body, &mgmr)
		return mgmr, err
	default:
		var mr MapRequest
		err := json.Unmarshal(body, &mr)
		return mr, err
	}
}
func unmarshalBasicMapRequestArray(body []byte) ([]BasicMapRequest, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	mrArray := make([]BasicMapRequest, len(rawMessages))

	for index, rawMessage := range rawMessages {
		mr, err := unmarshalBasicMapRequest(*rawMessage)
		if err != nil {
			return nil, err
		}
		mrArray[index] = mr
	}
	return mrArray, nil
}

// MarshalJSON is the custom marshaler for MapRequest.
func (mr MapRequest) MarshalJSON() ([]byte, error) {
	mr.Kind = KindMapRequest
	type Alias MapRequest
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(mr),
	})
}

// AsSingleMachineDependencyMapRequest is the BasicMapRequest implementation for MapRequest.
func (mr MapRequest) AsSingleMachineDependencyMapRequest() (*SingleMachineDependencyMapRequest, bool) {
	return nil, false
}

// AsMachineGroupMapRequest is the BasicMapRequest implementation for MapRequest.
func (mr MapRequest) AsMachineGroupMapRequest() (*MachineGroupMapRequest, bool) {
	return nil, false
}

// AsMapRequest is the BasicMapRequest implementation for MapRequest.
func (mr MapRequest) AsMapRequest() (*MapRequest, bool) {
	return &mr, true
}

// AsBasicMapRequest is the BasicMapRequest implementation for MapRequest.
func (mr MapRequest) AsBasicMapRequest() (BasicMapRequest, bool) {
	return &mr, true
}

// MapResponse specified the contents of a map response.
type MapResponse struct {
	autorest.Response `json:"-"`
	// StartTime - Map interval start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Map interval end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Map - The generated map.
	Map *Map `json:"map,omitempty"`
}

// NetworkConfiguration describes the network configuration of a machine.
type NetworkConfiguration struct {
	// Ipv4Interfaces - IPv4 interfaces.
	Ipv4Interfaces *[]Ipv4NetworkInterface `json:"ipv4Interfaces,omitempty"`
	// Ipv6Interfaces - IPv6 interfaces.
	Ipv6Interfaces *[]Ipv6NetworkInterface `json:"ipv6Interfaces,omitempty"`
	// DefaultIpv4Gateways - Default IPv4 gateways.
	DefaultIpv4Gateways *[]string `json:"defaultIpv4Gateways,omitempty"`
	// MacAddresses - MAC addresses of all active network interfaces.
	MacAddresses *[]string `json:"macAddresses,omitempty"`
	// DNSNames - DNS names associated with the machine.
	DNSNames *[]string `json:"dnsNames,omitempty"`
}

// OperatingSystemConfiguration describes the configuration of the operating system of a machine.
type OperatingSystemConfiguration struct {
	// Family - Windows, Linux, etc. Possible values include: 'OperatingSystemFamilyUnknown', 'OperatingSystemFamilyWindows', 'OperatingSystemFamilyLinux', 'OperatingSystemFamilySolaris', 'OperatingSystemFamilyAix'
	Family OperatingSystemFamily `json:"family,omitempty"`
	// FullName - Operating system full name.
	FullName *string `json:"fullName,omitempty"`
	// Bitness - Operating system bitness (32-bit or 64-bit). Possible values include: 'ThreeTwobit', 'SixFourbit'
	Bitness Bitness `json:"bitness,omitempty"`
}

// Port a port resource represents a server port on a machine. The port may be actively *monitored*, i.e., a Dependency
// Agent is running on its machine, or *discovered*, i.e., its existence was inferred by observing the data stream from
// monitored machines. A port is live during an interval of time, if that port had associated activity during (parts)
// of that interval.
type Port struct {
	autorest.Response `json:"-"`
	// ID - Resource identifier.
	ID *string `json:"id,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Etag - Resource ETAG.
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindCoreResource', 'KindMachine', 'KindProcess', 'KindPort', 'KindClientGroup', 'KindMachineGroup'
	Kind KindBasicCoreResource `json:"kind,omitempty"`
	// PortProperties - Resource properties.
	*PortProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Port.
func (p Port) MarshalJSON() ([]byte, error) {
	p.Kind = KindPort
	type Alias Port
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(p),
	})
}

// AsCoreResource is the BasicResource implementation for Port.
func (p Port) AsCoreResource() (*CoreResource, bool) {
	return nil, false
}

// AsBasicCoreResource is the BasicResource implementation for Port.
func (p Port) AsBasicCoreResource() (BasicCoreResource, bool) {
	return &p, true
}

// AsMachine is the BasicResource implementation for Port.
func (p Port) AsMachine() (*Machine, bool) {
	return nil, false
}

// AsProcess is the BasicResource implementation for Port.
func (p Port) AsProcess() (*Process, bool) {
	return nil, false
}

// AsPort is the BasicResource implementation for Port.
func (p Port) AsPort() (*Port, bool) {
	return &p, true
}

// AsClientGroup is the BasicResource implementation for Port.
func (p Port) AsClientGroup() (*ClientGroup, bool) {
	return nil, false
}

// AsClientGroupMember is the BasicResource implementation for Port.
func (p Port) AsClientGroupMember() (*ClientGroupMember, bool) {
	return nil, false
}

// AsMachineGroup is the BasicResource implementation for Port.
func (p Port) AsMachineGroup() (*MachineGroup, bool) {
	return nil, false
}

// AsSummary is the BasicResource implementation for Port.
func (p Port) AsSummary() (*Summary, bool) {
	return nil, false
}

// AsMachinesSummary is the BasicResource implementation for Port.
func (p Port) AsMachinesSummary() (*MachinesSummary, bool) {
	return nil, false
}

// AsRelationship is the BasicResource implementation for Port.
func (p Port) AsRelationship() (*Relationship, bool) {
	return nil, false
}

// AsBasicRelationship is the BasicResource implementation for Port.
func (p Port) AsBasicRelationship() (BasicRelationship, bool) {
	return nil, false
}

// AsConnection is the BasicResource implementation for Port.
func (p Port) AsConnection() (*Connection, bool) {
	return nil, false
}

// AsAcceptor is the BasicResource implementation for Port.
func (p Port) AsAcceptor() (*Acceptor, bool) {
	return nil, false
}

// UnmarshalJSON is the custom unmarshaler for Port struct.
func (p *Port) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		var properties PortProperties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		p.PortProperties = &properties
	}

	v = m["etag"]
	if v != nil {
		var etag string
		err = json.Unmarshal(*m["etag"], &etag)
		if err != nil {
			return err
		}
		p.Etag = &etag
	}

	v = m["kind"]
	if v != nil {
		var kind KindBasicCoreResource
		err = json.Unmarshal(*m["kind"], &kind)
		if err != nil {
			return err
		}
		p.Kind = kind
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		p.ID = &ID
	}

	v = m["type"]
	if v != nil {
		var typeVar string
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		p.Type = &typeVar
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		p.Name = &name
	}

	return nil
}

// PortCollection collection of Port resources.
type PortCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of Port resources.
	Value *[]Port `json:"value,omitempty"`
	// NextLink - The URL to the next set of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// PortCollectionIterator provides access to a complete listing of Port values.
type PortCollectionIterator struct {
	i    int
	page PortCollectionPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PortCollectionIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PortCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PortCollectionIterator) Response() PortCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PortCollectionIterator) Value() Port {
	if !iter.page.NotDone() {
		return Port{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (pc PortCollection) IsEmpty() bool {
	return pc.Value == nil || len(*pc.Value) == 0
}

// portCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pc PortCollection) portCollectionPreparer() (*http.Request, error) {
	if pc.NextLink == nil || len(to.String(pc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pc.NextLink)))
}

// PortCollectionPage contains a page of Port values.
type PortCollectionPage struct {
	fn func(PortCollection) (PortCollection, error)
	pc PortCollection
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PortCollectionPage) Next() error {
	next, err := page.fn(page.pc)
	if err != nil {
		return err
	}
	page.pc = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PortCollectionPage) NotDone() bool {
	return !page.pc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PortCollectionPage) Response() PortCollection {
	return page.pc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PortCollectionPage) Values() []Port {
	if page.pc.IsEmpty() {
		return nil
	}
	return *page.pc.Value
}

// PortProperties resource properties.
type PortProperties struct {
	// MonitoringState - Specifies whether the port is actively monitored or discovered. Possible values include: 'Monitored', 'Discovered'
	MonitoringState MonitoringState `json:"monitoringState,omitempty"`
	// Machine - Machine hosting this port.
	Machine BasicResourceReference `json:"machine,omitempty"`
	// DisplayName - Name to use for display purposes.
	DisplayName *string `json:"displayName,omitempty"`
	// IPAddress - IP address associated with the port. At present only IPv4 addresses are supported.
	IPAddress *string `json:"ipAddress,omitempty"`
	// PortNumber - Port number.
	PortNumber *int32 `json:"portNumber,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for PortProperties struct.
func (p *PortProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["monitoringState"]
	if v != nil {
		var monitoringState MonitoringState
		err = json.Unmarshal(*m["monitoringState"], &monitoringState)
		if err != nil {
			return err
		}
		p.MonitoringState = monitoringState
	}

	v = m["machine"]
	if v != nil {
		machine, err := unmarshalBasicResourceReference(*m["machine"])
		if err != nil {
			return err
		}
		p.Machine = machine
	}

	v = m["displayName"]
	if v != nil {
		var displayName string
		err = json.Unmarshal(*m["displayName"], &displayName)
		if err != nil {
			return err
		}
		p.DisplayName = &displayName
	}

	v = m["ipAddress"]
	if v != nil {
		var IPAddress string
		err = json.Unmarshal(*m["ipAddress"], &IPAddress)
		if err != nil {
			return err
		}
		p.IPAddress = &IPAddress
	}

	v = m["portNumber"]
	if v != nil {
		var portNumber int32
		err = json.Unmarshal(*m["portNumber"], &portNumber)
		if err != nil {
			return err
		}
		p.PortNumber = &portNumber
	}

	return nil
}

// PortReference reference to a port.
type PortReference struct {
	// ID - Resource URI.
	ID *string `json:"id,omitempty"`
	// Type - Resource type qualifier.
	Type *string `json:"type,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Kind - Possible values include: 'KindResourceReference', 'KindRefmachine', 'KindRefprocess', 'KindRefport', 'KindRefmachinewithhints'
	Kind Kind `json:"kind,omitempty"`
	// PortReferenceProperties - Resource properties.
	*PortReferenceProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for PortReference.
func (pr PortReference) MarshalJSON() ([]byte, error) {
	pr.Kind = KindRefport
	type Alias PortReference
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(pr),
	})
}

// AsMachineReference is the BasicResourceReference implementation for PortReference.
func (pr PortReference) AsMachineReference() (*MachineReference, bool) {
	return nil, false
}

// AsProcessReference is the BasicResourceReference implementation for PortReference.
func (pr PortReference) AsProcessReference() (*ProcessReference, bool) {
	return nil, false
}

// AsPortReference is the BasicResourceReference implementation for PortReference.
func (pr PortReference) AsPortReference() (*PortReference, bool) {
	return &pr, true
}

// AsMachineReferenceWithHints is the BasicResourceReference implementation for PortReference.
func (pr PortReference) AsMachineReferenceWithHints() (*MachineReferenceWithHints, bool) {
	return nil, false
}

// AsResourceReference is the BasicResourceReference implementation for PortReference.
func (pr PortReference) AsResourceReference() (*ResourceReference, bool) {
	return nil, false
}

// AsBasicResourceReference is the BasicResourceReference implementation for PortReference.
func (pr PortReference) AsBasicResourceReference() (BasicResourceReference, bool) {
	return &pr, true
}

// UnmarshalJSON is the custom unmarshaler for PortReference struct.
func (pr *PortReference) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		var properties PortReferenceProperties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		pr.PortReferenceProperties = &properties
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		pr.ID = &ID
	}

	v = m["type"]
	if v != nil {
		var typeVar string
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		pr.Type = &typeVar
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		pr.Name = &name
	}

	v = m["kind"]
	if v != nil {
		var kind Kind
		err = json.Unmarshal(*m["kind"], &kind)
		if err != nil {
			return err
		}
		pr.Kind = kind
	}

	return nil
}

// PortReferenceProperties resource properties.
type PortReferenceProperties struct {
	// Machine - Machine hosting the port.
	Machine *MachineReference `json:"machine,omitempty"`
	// IPAddress - IP address of the port.
	IPAddress *string `json:"ipAddress,omitempty"`
	// PortNumber - Port number.
	PortNumber *int32 `json:"portNumber,omitempty"`
}

// Process a process resource represents a process running on a machine. The process may be actively *monitored*, i.e.,
// a Dependency Agent is running on its machine, or *discovered*, i.e., its existence was inferred by observing the
// data stream from monitored machines. A process resource represents a pool of actual operating system resources that
// share command lines and metadata. As the process pool evolves over time, prior versions of the process resource are
// preserved and available for access. A process is live during an interval of time, if that process is executing
// during (parts) of that interval
type Process struct {
	autorest.Response `json:"-"`
	// ID - Resource identifier.
	ID *string `json:"id,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Etag - Resource ETAG.
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindCoreResource', 'KindMachine', 'KindProcess', 'KindPort', 'KindClientGroup', 'KindMachineGroup'
	Kind KindBasicCoreResource `json:"kind,omitempty"`
	// ProcessProperties - Resource properties.
	*ProcessProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Process.
func (p Process) MarshalJSON() ([]byte, error) {
	p.Kind = KindProcess
	type Alias Process
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(p),
	})
}

// AsCoreResource is the BasicResource implementation for Process.
func (p Process) AsCoreResource() (*CoreResource, bool) {
	return nil, false
}

// AsBasicCoreResource is the BasicResource implementation for Process.
func (p Process) AsBasicCoreResource() (BasicCoreResource, bool) {
	return &p, true
}

// AsMachine is the BasicResource implementation for Process.
func (p Process) AsMachine() (*Machine, bool) {
	return nil, false
}

// AsProcess is the BasicResource implementation for Process.
func (p Process) AsProcess() (*Process, bool) {
	return &p, true
}

// AsPort is the BasicResource implementation for Process.
func (p Process) AsPort() (*Port, bool) {
	return nil, false
}

// AsClientGroup is the BasicResource implementation for Process.
func (p Process) AsClientGroup() (*ClientGroup, bool) {
	return nil, false
}

// AsClientGroupMember is the BasicResource implementation for Process.
func (p Process) AsClientGroupMember() (*ClientGroupMember, bool) {
	return nil, false
}

// AsMachineGroup is the BasicResource implementation for Process.
func (p Process) AsMachineGroup() (*MachineGroup, bool) {
	return nil, false
}

// AsSummary is the BasicResource implementation for Process.
func (p Process) AsSummary() (*Summary, bool) {
	return nil, false
}

// AsMachinesSummary is the BasicResource implementation for Process.
func (p Process) AsMachinesSummary() (*MachinesSummary, bool) {
	return nil, false
}

// AsRelationship is the BasicResource implementation for Process.
func (p Process) AsRelationship() (*Relationship, bool) {
	return nil, false
}

// AsBasicRelationship is the BasicResource implementation for Process.
func (p Process) AsBasicRelationship() (BasicRelationship, bool) {
	return nil, false
}

// AsConnection is the BasicResource implementation for Process.
func (p Process) AsConnection() (*Connection, bool) {
	return nil, false
}

// AsAcceptor is the BasicResource implementation for Process.
func (p Process) AsAcceptor() (*Acceptor, bool) {
	return nil, false
}

// UnmarshalJSON is the custom unmarshaler for Process struct.
func (p *Process) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		var properties ProcessProperties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		p.ProcessProperties = &properties
	}

	v = m["etag"]
	if v != nil {
		var etag string
		err = json.Unmarshal(*m["etag"], &etag)
		if err != nil {
			return err
		}
		p.Etag = &etag
	}

	v = m["kind"]
	if v != nil {
		var kind KindBasicCoreResource
		err = json.Unmarshal(*m["kind"], &kind)
		if err != nil {
			return err
		}
		p.Kind = kind
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		p.ID = &ID
	}

	v = m["type"]
	if v != nil {
		var typeVar string
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		p.Type = &typeVar
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		p.Name = &name
	}

	return nil
}

// ProcessCollection collection of Process resources.
type ProcessCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of Process resources.
	Value *[]Process `json:"value,omitempty"`
	// NextLink - The URL to the next set of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProcessCollectionIterator provides access to a complete listing of Process values.
type ProcessCollectionIterator struct {
	i    int
	page ProcessCollectionPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProcessCollectionIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProcessCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProcessCollectionIterator) Response() ProcessCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProcessCollectionIterator) Value() Process {
	if !iter.page.NotDone() {
		return Process{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (pc ProcessCollection) IsEmpty() bool {
	return pc.Value == nil || len(*pc.Value) == 0
}

// processCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pc ProcessCollection) processCollectionPreparer() (*http.Request, error) {
	if pc.NextLink == nil || len(to.String(pc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pc.NextLink)))
}

// ProcessCollectionPage contains a page of Process values.
type ProcessCollectionPage struct {
	fn func(ProcessCollection) (ProcessCollection, error)
	pc ProcessCollection
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProcessCollectionPage) Next() error {
	next, err := page.fn(page.pc)
	if err != nil {
		return err
	}
	page.pc = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProcessCollectionPage) NotDone() bool {
	return !page.pc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProcessCollectionPage) Response() ProcessCollection {
	return page.pc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProcessCollectionPage) Values() []Process {
	if page.pc.IsEmpty() {
		return nil
	}
	return *page.pc.Value
}

// ProcessDetails describes process metadata.
type ProcessDetails struct {
	// PersistentKey - A unique indentifier for a process, generally resilient to process restart, computed by Service Map.
	PersistentKey *string `json:"persistentKey,omitempty"`
	// PoolID - Represents the identity of the process pool assigned to the process by Dependency Agent.
	PoolID *int32 `json:"poolId,omitempty"`
	// FirstPid - The Operating System Process Idendifier (PID) of the first process in this process pool.
	FirstPid *int32 `json:"firstPid,omitempty"`
	// Description - Process description.
	Description *string `json:"description,omitempty"`
	// CompanyName - Name of company that created the process executable.
	CompanyName *string `json:"companyName,omitempty"`
	// InternalName - Internal process name.
	InternalName *string `json:"internalName,omitempty"`
	// ProductName - Product name.
	ProductName *string `json:"productName,omitempty"`
	// ProductVersion - Product version.
	ProductVersion *string `json:"productVersion,omitempty"`
	// FileVersion - File version.
	FileVersion *string `json:"fileVersion,omitempty"`
	// CommandLine - Process command line.
	CommandLine *string `json:"commandLine,omitempty"`
	// ExecutablePath - Process executable path.
	ExecutablePath *string `json:"executablePath,omitempty"`
	// WorkingDirectory - Process workingDirectory.
	WorkingDirectory *string `json:"workingDirectory,omitempty"`
}

// ProcessProperties resource properties.
type ProcessProperties struct {
	// Timestamp - UTC date and time when this process resource was updated in the system
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// MonitoringState - Specifies whether the process is actively monitored or discovered. Possible values include: 'Monitored', 'Discovered'
	MonitoringState MonitoringState `json:"monitoringState,omitempty"`
	// Machine - Machine hosting this process.
	Machine BasicResourceReference `json:"machine,omitempty"`
	// ExecutableName - The name of the process executable
	ExecutableName *string `json:"executableName,omitempty"`
	// DisplayName - Name to use for display purposes
	DisplayName *string `json:"displayName,omitempty"`
	// StartTime - UTC date and time when the process started
	StartTime *date.Time `json:"startTime,omitempty"`
	// Role - The inferred role of this process based on its name, command line, etc. Possible values include: 'WebServer', 'AppServer', 'DatabaseServer', 'LdapServer', 'SmbServer'
	Role ProcessRole `json:"role,omitempty"`
	// Details - Process metadata (command line, product name, etc.).
	Details *ProcessDetails `json:"details,omitempty"`
	// User - Information about the account under which the process is executing.
	User *ProcessUser `json:"user,omitempty"`
	// ClientOf - Present only for a discovered process acting as a client of a monitored process/machine/port. References the monitored process/machine/port that this process is a client of.
	ClientOf BasicResourceReference `json:"clientOf,omitempty"`
	// AcceptorOf - Present only for a discovered process acting as a server. References the port on which the discovered process is accepting.
	AcceptorOf BasicResourceReference `json:"acceptorOf,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ProcessProperties struct.
func (p *ProcessProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["timestamp"]
	if v != nil {
		var timestamp date.Time
		err = json.Unmarshal(*m["timestamp"], &timestamp)
		if err != nil {
			return err
		}
		p.Timestamp = &timestamp
	}

	v = m["monitoringState"]
	if v != nil {
		var monitoringState MonitoringState
		err = json.Unmarshal(*m["monitoringState"], &monitoringState)
		if err != nil {
			return err
		}
		p.MonitoringState = monitoringState
	}

	v = m["machine"]
	if v != nil {
		machine, err := unmarshalBasicResourceReference(*m["machine"])
		if err != nil {
			return err
		}
		p.Machine = machine
	}

	v = m["executableName"]
	if v != nil {
		var executableName string
		err = json.Unmarshal(*m["executableName"], &executableName)
		if err != nil {
			return err
		}
		p.ExecutableName = &executableName
	}

	v = m["displayName"]
	if v != nil {
		var displayName string
		err = json.Unmarshal(*m["displayName"], &displayName)
		if err != nil {
			return err
		}
		p.DisplayName = &displayName
	}

	v = m["startTime"]
	if v != nil {
		var startTime date.Time
		err = json.Unmarshal(*m["startTime"], &startTime)
		if err != nil {
			return err
		}
		p.StartTime = &startTime
	}

	v = m["role"]
	if v != nil {
		var role ProcessRole
		err = json.Unmarshal(*m["role"], &role)
		if err != nil {
			return err
		}
		p.Role = role
	}

	v = m["details"]
	if v != nil {
		var details ProcessDetails
		err = json.Unmarshal(*m["details"], &details)
		if err != nil {
			return err
		}
		p.Details = &details
	}

	v = m["user"]
	if v != nil {
		var userVar ProcessUser
		err = json.Unmarshal(*m["user"], &userVar)
		if err != nil {
			return err
		}
		p.User = &userVar
	}

	v = m["clientOf"]
	if v != nil {
		clientOf, err := unmarshalBasicResourceReference(*m["clientOf"])
		if err != nil {
			return err
		}
		p.ClientOf = clientOf
	}

	v = m["acceptorOf"]
	if v != nil {
		acceptorOf, err := unmarshalBasicResourceReference(*m["acceptorOf"])
		if err != nil {
			return err
		}
		p.AcceptorOf = acceptorOf
	}

	return nil
}

// ProcessReference reference to a process.
type ProcessReference struct {
	// ID - Resource URI.
	ID *string `json:"id,omitempty"`
	// Type - Resource type qualifier.
	Type *string `json:"type,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Kind - Possible values include: 'KindResourceReference', 'KindRefmachine', 'KindRefprocess', 'KindRefport', 'KindRefmachinewithhints'
	Kind Kind `json:"kind,omitempty"`
	// ProcessReferenceProperties - Resource properties.
	*ProcessReferenceProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ProcessReference.
func (pr ProcessReference) MarshalJSON() ([]byte, error) {
	pr.Kind = KindRefprocess
	type Alias ProcessReference
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(pr),
	})
}

// AsMachineReference is the BasicResourceReference implementation for ProcessReference.
func (pr ProcessReference) AsMachineReference() (*MachineReference, bool) {
	return nil, false
}

// AsProcessReference is the BasicResourceReference implementation for ProcessReference.
func (pr ProcessReference) AsProcessReference() (*ProcessReference, bool) {
	return &pr, true
}

// AsPortReference is the BasicResourceReference implementation for ProcessReference.
func (pr ProcessReference) AsPortReference() (*PortReference, bool) {
	return nil, false
}

// AsMachineReferenceWithHints is the BasicResourceReference implementation for ProcessReference.
func (pr ProcessReference) AsMachineReferenceWithHints() (*MachineReferenceWithHints, bool) {
	return nil, false
}

// AsResourceReference is the BasicResourceReference implementation for ProcessReference.
func (pr ProcessReference) AsResourceReference() (*ResourceReference, bool) {
	return nil, false
}

// AsBasicResourceReference is the BasicResourceReference implementation for ProcessReference.
func (pr ProcessReference) AsBasicResourceReference() (BasicResourceReference, bool) {
	return &pr, true
}

// UnmarshalJSON is the custom unmarshaler for ProcessReference struct.
func (pr *ProcessReference) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		var properties ProcessReferenceProperties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		pr.ProcessReferenceProperties = &properties
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		pr.ID = &ID
	}

	v = m["type"]
	if v != nil {
		var typeVar string
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		pr.Type = &typeVar
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		pr.Name = &name
	}

	v = m["kind"]
	if v != nil {
		var kind Kind
		err = json.Unmarshal(*m["kind"], &kind)
		if err != nil {
			return err
		}
		pr.Kind = kind
	}

	return nil
}

// ProcessReferenceProperties resource properties.
type ProcessReferenceProperties struct {
	// Machine - Machine hosting the process.
	Machine *MachineReference `json:"machine,omitempty"`
}

// ProcessUser describes the user under which a process is running.
type ProcessUser struct {
	// UserName - User name under which the process is running.
	UserName *string `json:"userName,omitempty"`
	// UserDomain - Domain name for the user.
	UserDomain *string `json:"userDomain,omitempty"`
}

// BasicRelationship a typed relationship between two entities.
type BasicRelationship interface {
	AsConnection() (*Connection, bool)
	AsAcceptor() (*Acceptor, bool)
	AsRelationship() (*Relationship, bool)
}

// Relationship a typed relationship between two entities.
type Relationship struct {
	// ID - Resource identifier.
	ID *string `json:"id,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Kind - Possible values include: 'KindRelationship', 'KindRelconnection', 'KindRelacceptor'
	Kind KindBasicRelationship `json:"kind,omitempty"`
}

func unmarshalBasicRelationship(body []byte) (BasicRelationship, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m[""] {
	case string(KindRelconnection):
		var c Connection
		err := json.Unmarshal(body, &c)
		return c, err
	case string(KindRelacceptor):
		var a Acceptor
		err := json.Unmarshal(body, &a)
		return a, err
	default:
		var r Relationship
		err := json.Unmarshal(body, &r)
		return r, err
	}
}
func unmarshalBasicRelationshipArray(body []byte) ([]BasicRelationship, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rArray := make([]BasicRelationship, len(rawMessages))

	for index, rawMessage := range rawMessages {
		r, err := unmarshalBasicRelationship(*rawMessage)
		if err != nil {
			return nil, err
		}
		rArray[index] = r
	}
	return rArray, nil
}

// MarshalJSON is the custom marshaler for Relationship.
func (r Relationship) MarshalJSON() ([]byte, error) {
	r.Kind = KindRelationship
	type Alias Relationship
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(r),
	})
}

// AsCoreResource is the BasicResource implementation for Relationship.
func (r Relationship) AsCoreResource() (*CoreResource, bool) {
	return nil, false
}

// AsBasicCoreResource is the BasicResource implementation for Relationship.
func (r Relationship) AsBasicCoreResource() (BasicCoreResource, bool) {
	return nil, false
}

// AsMachine is the BasicResource implementation for Relationship.
func (r Relationship) AsMachine() (*Machine, bool) {
	return nil, false
}

// AsProcess is the BasicResource implementation for Relationship.
func (r Relationship) AsProcess() (*Process, bool) {
	return nil, false
}

// AsPort is the BasicResource implementation for Relationship.
func (r Relationship) AsPort() (*Port, bool) {
	return nil, false
}

// AsClientGroup is the BasicResource implementation for Relationship.
func (r Relationship) AsClientGroup() (*ClientGroup, bool) {
	return nil, false
}

// AsClientGroupMember is the BasicResource implementation for Relationship.
func (r Relationship) AsClientGroupMember() (*ClientGroupMember, bool) {
	return nil, false
}

// AsMachineGroup is the BasicResource implementation for Relationship.
func (r Relationship) AsMachineGroup() (*MachineGroup, bool) {
	return nil, false
}

// AsSummary is the BasicResource implementation for Relationship.
func (r Relationship) AsSummary() (*Summary, bool) {
	return nil, false
}

// AsMachinesSummary is the BasicResource implementation for Relationship.
func (r Relationship) AsMachinesSummary() (*MachinesSummary, bool) {
	return nil, false
}

// AsRelationship is the BasicResource implementation for Relationship.
func (r Relationship) AsRelationship() (*Relationship, bool) {
	return &r, true
}

// AsBasicRelationship is the BasicResource implementation for Relationship.
func (r Relationship) AsBasicRelationship() (BasicRelationship, bool) {
	return &r, true
}

// AsConnection is the BasicResource implementation for Relationship.
func (r Relationship) AsConnection() (*Connection, bool) {
	return nil, false
}

// AsAcceptor is the BasicResource implementation for Relationship.
func (r Relationship) AsAcceptor() (*Acceptor, bool) {
	return nil, false
}

// RelationshipProperties relationship properties.
type RelationshipProperties struct {
	// Source - Source resource of the relationship.
	Source BasicResourceReference `json:"source,omitempty"`
	// Destination - Destination resource of the relationship.
	Destination BasicResourceReference `json:"destination,omitempty"`
	// StartTime - Relationship start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Relationship end time.
	EndTime *date.Time `json:"endTime,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for RelationshipProperties struct.
func (rp *RelationshipProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["source"]
	if v != nil {
		source, err := unmarshalBasicResourceReference(*m["source"])
		if err != nil {
			return err
		}
		rp.Source = source
	}

	v = m["destination"]
	if v != nil {
		destination, err := unmarshalBasicResourceReference(*m["destination"])
		if err != nil {
			return err
		}
		rp.Destination = destination
	}

	v = m["startTime"]
	if v != nil {
		var startTime date.Time
		err = json.Unmarshal(*m["startTime"], &startTime)
		if err != nil {
			return err
		}
		rp.StartTime = &startTime
	}

	v = m["endTime"]
	if v != nil {
		var endTime date.Time
		err = json.Unmarshal(*m["endTime"], &endTime)
		if err != nil {
			return err
		}
		rp.EndTime = &endTime
	}

	return nil
}

// Resource resource model definition.
type Resource struct {
	// ID - Resource identifier.
	ID *string `json:"id,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
}

// BasicResourceReference represents a reference to another resource.
type BasicResourceReference interface {
	AsMachineReference() (*MachineReference, bool)
	AsProcessReference() (*ProcessReference, bool)
	AsPortReference() (*PortReference, bool)
	AsMachineReferenceWithHints() (*MachineReferenceWithHints, bool)
	AsResourceReference() (*ResourceReference, bool)
}

// ResourceReference represents a reference to another resource.
type ResourceReference struct {
	// ID - Resource URI.
	ID *string `json:"id,omitempty"`
	// Type - Resource type qualifier.
	Type *string `json:"type,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Kind - Possible values include: 'KindResourceReference', 'KindRefmachine', 'KindRefprocess', 'KindRefport', 'KindRefmachinewithhints'
	Kind Kind `json:"kind,omitempty"`
}

func unmarshalBasicResourceReference(body []byte) (BasicResourceReference, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindRefmachine):
		var mr MachineReference
		err := json.Unmarshal(body, &mr)
		return mr, err
	case string(KindRefprocess):
		var pr ProcessReference
		err := json.Unmarshal(body, &pr)
		return pr, err
	case string(KindRefport):
		var pr PortReference
		err := json.Unmarshal(body, &pr)
		return pr, err
	case string(KindRefmachinewithhints):
		var mrwh MachineReferenceWithHints
		err := json.Unmarshal(body, &mrwh)
		return mrwh, err
	default:
		var rr ResourceReference
		err := json.Unmarshal(body, &rr)
		return rr, err
	}
}
func unmarshalBasicResourceReferenceArray(body []byte) ([]BasicResourceReference, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rrArray := make([]BasicResourceReference, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rr, err := unmarshalBasicResourceReference(*rawMessage)
		if err != nil {
			return nil, err
		}
		rrArray[index] = rr
	}
	return rrArray, nil
}

// MarshalJSON is the custom marshaler for ResourceReference.
func (rr ResourceReference) MarshalJSON() ([]byte, error) {
	rr.Kind = KindResourceReference
	type Alias ResourceReference
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(rr),
	})
}

// AsMachineReference is the BasicResourceReference implementation for ResourceReference.
func (rr ResourceReference) AsMachineReference() (*MachineReference, bool) {
	return nil, false
}

// AsProcessReference is the BasicResourceReference implementation for ResourceReference.
func (rr ResourceReference) AsProcessReference() (*ProcessReference, bool) {
	return nil, false
}

// AsPortReference is the BasicResourceReference implementation for ResourceReference.
func (rr ResourceReference) AsPortReference() (*PortReference, bool) {
	return nil, false
}

// AsMachineReferenceWithHints is the BasicResourceReference implementation for ResourceReference.
func (rr ResourceReference) AsMachineReferenceWithHints() (*MachineReferenceWithHints, bool) {
	return nil, false
}

// AsResourceReference is the BasicResourceReference implementation for ResourceReference.
func (rr ResourceReference) AsResourceReference() (*ResourceReference, bool) {
	return &rr, true
}

// AsBasicResourceReference is the BasicResourceReference implementation for ResourceReference.
func (rr ResourceReference) AsBasicResourceReference() (BasicResourceReference, bool) {
	return &rr, true
}

// SingleMachineDependencyMapRequest specifies the computation of a single server dependency map. A single server
// dependency map includes all direct dependencies of a given machine.
type SingleMachineDependencyMapRequest struct {
	// StartTime - Map interval start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Map interval end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Kind - Possible values include: 'KindMapRequest', 'KindMapsingleMachineDependency', 'KindMapmachineGroupDependency'
	Kind KindBasicMapRequest `json:"kind,omitempty"`
	// MachineID - URI of machine resource for which to generate the map.
	MachineID *string `json:"machineId,omitempty"`
}

// MarshalJSON is the custom marshaler for SingleMachineDependencyMapRequest.
func (smdmr SingleMachineDependencyMapRequest) MarshalJSON() ([]byte, error) {
	smdmr.Kind = KindMapsingleMachineDependency
	type Alias SingleMachineDependencyMapRequest
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(smdmr),
	})
}

// AsSingleMachineDependencyMapRequest is the BasicMapRequest implementation for SingleMachineDependencyMapRequest.
func (smdmr SingleMachineDependencyMapRequest) AsSingleMachineDependencyMapRequest() (*SingleMachineDependencyMapRequest, bool) {
	return &smdmr, true
}

// AsMachineGroupMapRequest is the BasicMapRequest implementation for SingleMachineDependencyMapRequest.
func (smdmr SingleMachineDependencyMapRequest) AsMachineGroupMapRequest() (*MachineGroupMapRequest, bool) {
	return nil, false
}

// AsMapRequest is the BasicMapRequest implementation for SingleMachineDependencyMapRequest.
func (smdmr SingleMachineDependencyMapRequest) AsMapRequest() (*MapRequest, bool) {
	return nil, false
}

// AsBasicMapRequest is the BasicMapRequest implementation for SingleMachineDependencyMapRequest.
func (smdmr SingleMachineDependencyMapRequest) AsBasicMapRequest() (BasicMapRequest, bool) {
	return &smdmr, true
}

// Summary base for all resource summaries.
type Summary struct {
	// ID - Resource identifier.
	ID *string `json:"id,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
}

// SummaryProperties base for all summaries.
type SummaryProperties struct {
	// StartTime - Summary interval start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Summary interval end time.
	EndTime *date.Time `json:"endTime,omitempty"`
}

// Timezone describes a timezone.
type Timezone struct {
	// FullName - Timezone full name.
	FullName *string `json:"fullName,omitempty"`
}

// VirtualMachineConfiguration describes the virtualizaton-related configuration of a machine.
type VirtualMachineConfiguration struct {
	// VirtualMachineType - Specifies the virtualization technology used by the machine (hyperv, vmware, etc.). Possible values include: 'VirtualMachineTypeUnknown', 'VirtualMachineTypeHyperv', 'VirtualMachineTypeLdom', 'VirtualMachineTypeLpar', 'VirtualMachineTypeVmware', 'VirtualMachineTypeVirtualPc', 'VirtualMachineTypeXen'
	VirtualMachineType VirtualMachineType `json:"virtualMachineType,omitempty"`
	// NativeMachineID - The unique identifier of the virtual machine as reported by the underlying virtualization sytem.
	NativeMachineID *string `json:"nativeMachineId,omitempty"`
	// VirtualMachineName - The Name of the virtual machine.
	VirtualMachineName *string `json:"virtualMachineName,omitempty"`
	// NativeHostMachineID - The unique identifier of the host of this virtual machine as reported by the underlying virtualization system.
	NativeHostMachineID *string `json:"nativeHostMachineId,omitempty"`
}
