package operationalinsights

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// DataSourceKind enumerates the values for data source kind.
type DataSourceKind string

const (
	// AzureActivityLog ...
	AzureActivityLog DataSourceKind = "AzureActivityLog"
	// ChangeTrackingCustomRegistry ...
	ChangeTrackingCustomRegistry DataSourceKind = "ChangeTrackingCustomRegistry"
	// ChangeTrackingDefaultPath ...
	ChangeTrackingDefaultPath DataSourceKind = "ChangeTrackingDefaultPath"
	// ChangeTrackingDefaultRegistry ...
	ChangeTrackingDefaultRegistry DataSourceKind = "ChangeTrackingDefaultRegistry"
	// ChangeTrackingPath ...
	ChangeTrackingPath DataSourceKind = "ChangeTrackingPath"
	// CustomLog ...
	CustomLog DataSourceKind = "CustomLog"
	// CustomLogCollection ...
	CustomLogCollection DataSourceKind = "CustomLogCollection"
	// GenericDataSource ...
	GenericDataSource DataSourceKind = "GenericDataSource"
	// IISLogs ...
	IISLogs DataSourceKind = "IISLogs"
	// LinuxPerformanceCollection ...
	LinuxPerformanceCollection DataSourceKind = "LinuxPerformanceCollection"
	// LinuxPerformanceObject ...
	LinuxPerformanceObject DataSourceKind = "LinuxPerformanceObject"
	// LinuxSyslog ...
	LinuxSyslog DataSourceKind = "LinuxSyslog"
	// LinuxSyslogCollection ...
	LinuxSyslogCollection DataSourceKind = "LinuxSyslogCollection"
	// WindowsEvent ...
	WindowsEvent DataSourceKind = "WindowsEvent"
	// WindowsPerformanceCounter ...
	WindowsPerformanceCounter DataSourceKind = "WindowsPerformanceCounter"
)

// EntityStatus enumerates the values for entity status.
type EntityStatus string

const (
	// Canceled ...
	Canceled EntityStatus = "Canceled"
	// Creating ...
	Creating EntityStatus = "Creating"
	// Deleting ...
	Deleting EntityStatus = "Deleting"
	// Failed ...
	Failed EntityStatus = "Failed"
	// ProvisioningAccount ...
	ProvisioningAccount EntityStatus = "ProvisioningAccount"
	// Succeeded ...
	Succeeded EntityStatus = "Succeeded"
)

// SearchSortEnum enumerates the values for search sort enum.
type SearchSortEnum string

const (
	// Asc ...
	Asc SearchSortEnum = "asc"
	// Desc ...
	Desc SearchSortEnum = "desc"
)

// SkuNameEnum enumerates the values for sku name enum.
type SkuNameEnum string

const (
	// Free ...
	Free SkuNameEnum = "Free"
	// PerNode ...
	PerNode SkuNameEnum = "PerNode"
	// Premium ...
	Premium SkuNameEnum = "Premium"
	// Standalone ...
	Standalone SkuNameEnum = "Standalone"
	// Standard ...
	Standard SkuNameEnum = "Standard"
	// Unlimited ...
	Unlimited SkuNameEnum = "Unlimited"
)

// StorageInsightState enumerates the values for storage insight state.
type StorageInsightState string

const (
	// ERROR ...
	ERROR StorageInsightState = "ERROR"
	// OK ...
	OK StorageInsightState = "OK"
)

// CoreSummary the core summary of a search.
type CoreSummary struct {
	// Status - The status of a core summary.
	Status *string `json:"Status,omitempty"`
	// NumberOfDocuments - The number of documents of a core summary.
	NumberOfDocuments *int64 `json:"NumberOfDocuments,omitempty"`
}

// DataSource datasources under OMS Workspace.
type DataSource struct {
	autorest.Response `json:"-"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags *map[string]*string `json:"tags,omitempty"`
	// Properties - The data source properties in raw json format, each kind of data source have it's own schema.
	Properties *map[string]interface{} `json:"properties,omitempty"`
	// ETag - The ETag of the data source.
	ETag *string `json:"eTag,omitempty"`
	// Kind - Possible values include: 'AzureActivityLog', 'ChangeTrackingPath', 'ChangeTrackingDefaultPath', 'ChangeTrackingDefaultRegistry', 'ChangeTrackingCustomRegistry', 'CustomLog', 'CustomLogCollection', 'GenericDataSource', 'IISLogs', 'LinuxPerformanceObject', 'LinuxPerformanceCollection', 'LinuxSyslog', 'LinuxSyslogCollection', 'WindowsEvent', 'WindowsPerformanceCounter'
	Kind DataSourceKind `json:"kind,omitempty"`
}

// DataSourceFilter dataSource filter. Right now, only filter by kind is supported.
type DataSourceFilter struct {
	// Kind - Possible values include: 'AzureActivityLog', 'ChangeTrackingPath', 'ChangeTrackingDefaultPath', 'ChangeTrackingDefaultRegistry', 'ChangeTrackingCustomRegistry', 'CustomLog', 'CustomLogCollection', 'GenericDataSource', 'IISLogs', 'LinuxPerformanceObject', 'LinuxPerformanceCollection', 'LinuxSyslog', 'LinuxSyslogCollection', 'WindowsEvent', 'WindowsPerformanceCounter'
	Kind DataSourceKind `json:"kind,omitempty"`
}

// DataSourceListResult the list data source by workspace operation response.
type DataSourceListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of datasources.
	Value *[]DataSource `json:"value,omitempty"`
	// NextLink - The link (url) to the next page of datasources.
	NextLink *string `json:"nextLink,omitempty"`
}

// DataSourceListResultIterator provides access to a complete listing of DataSource values.
type DataSourceListResultIterator struct {
	i    int
	page DataSourceListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DataSourceListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DataSourceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DataSourceListResultIterator) Response() DataSourceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DataSourceListResultIterator) Value() DataSource {
	if !iter.page.NotDone() {
		return DataSource{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (dslr DataSourceListResult) IsEmpty() bool {
	return dslr.Value == nil || len(*dslr.Value) == 0
}

// dataSourceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dslr DataSourceListResult) dataSourceListResultPreparer() (*http.Request, error) {
	if dslr.NextLink == nil || len(to.String(dslr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dslr.NextLink)))
}

// DataSourceListResultPage contains a page of DataSource values.
type DataSourceListResultPage struct {
	fn   func(DataSourceListResult) (DataSourceListResult, error)
	dslr DataSourceListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DataSourceListResultPage) Next() error {
	next, err := page.fn(page.dslr)
	if err != nil {
		return err
	}
	page.dslr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DataSourceListResultPage) NotDone() bool {
	return !page.dslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DataSourceListResultPage) Response() DataSourceListResult {
	return page.dslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DataSourceListResultPage) Values() []DataSource {
	if page.dslr.IsEmpty() {
		return nil
	}
	return *page.dslr.Value
}

// IntelligencePack intelligence Pack containing a string name and boolean indicating if it's enabled.
type IntelligencePack struct {
	// Name - The name of the intelligence pack.
	Name *string `json:"name,omitempty"`
	// Enabled - The enabled boolean for the intelligence pack.
	Enabled *bool `json:"enabled,omitempty"`
}

// LinkedService the top level Linked service resource container.
type LinkedService struct {
	autorest.Response `json:"-"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags *map[string]*string `json:"tags,omitempty"`
	// LinkedServiceProperties - The properties of the linked service.
	*LinkedServiceProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for LinkedService struct.
func (ls *LinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		var properties LinkedServiceProperties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		ls.LinkedServiceProperties = &properties
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		ls.ID = &ID
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		ls.Name = &name
	}

	v = m["type"]
	if v != nil {
		var typeVar string
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		ls.Type = &typeVar
	}

	v = m["tags"]
	if v != nil {
		var tags map[string]*string
		err = json.Unmarshal(*m["tags"], &tags)
		if err != nil {
			return err
		}
		ls.Tags = &tags
	}

	return nil
}

// LinkedServiceListResult the list linked service operation response.
type LinkedServiceListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of linked service instances.
	Value *[]LinkedService `json:"value,omitempty"`
}

// LinkedServiceProperties linked service properties.
type LinkedServiceProperties struct {
	// ResourceID - The resource id of the resource that will be linked to the workspace.
	ResourceID *string `json:"resourceId,omitempty"`
}

// LinkTarget metadata for a workspace that isn't linked to an Azure subscription.
type LinkTarget struct {
	// CustomerID - The GUID that uniquely identifies the workspace.
	CustomerID *string `json:"customerId,omitempty"`
	// DisplayName - The display name of the workspace.
	DisplayName *string `json:"accountName,omitempty"`
	// WorkspaceName - The DNS valid workspace name.
	WorkspaceName *string `json:"workspaceName,omitempty"`
	// Location - The location of the workspace.
	Location *string `json:"location,omitempty"`
}

// ListIntelligencePack ...
type ListIntelligencePack struct {
	autorest.Response `json:"-"`
	Value             *[]IntelligencePack `json:"value,omitempty"`
}

// ListLinkTarget ...
type ListLinkTarget struct {
	autorest.Response `json:"-"`
	Value             *[]LinkTarget `json:"value,omitempty"`
}

// ManagementGroup a management group that is connected to a workspace
type ManagementGroup struct {
	// ManagementGroupProperties - The properties of the management group.
	*ManagementGroupProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ManagementGroup struct.
func (mg *ManagementGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		var properties ManagementGroupProperties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		mg.ManagementGroupProperties = &properties
	}

	return nil
}

// ManagementGroupProperties management group properties.
type ManagementGroupProperties struct {
	// ServerCount - The number of servers connected to the management group.
	ServerCount *int32 `json:"serverCount,omitempty"`
	// IsGateway - Gets or sets a value indicating whether the management group is a gateway.
	IsGateway *bool `json:"isGateway,omitempty"`
	// Name - The name of the management group.
	Name *string `json:"name,omitempty"`
	// ID - The unique ID of the management group.
	ID *string `json:"id,omitempty"`
	// Created - The datetime that the management group was created.
	Created *date.Time `json:"created,omitempty"`
	// DataReceived - The last datetime that the management group received data.
	DataReceived *date.Time `json:"dataReceived,omitempty"`
	// Version - The version of System Center that is managing the management group.
	Version *string `json:"version,omitempty"`
	// Sku - The SKU of System Center that is managing the management group.
	Sku *string `json:"sku,omitempty"`
}

// MetricName the name of a metric.
type MetricName struct {
	// Value - The system name of the metric.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - The localized name of the metric.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// ProxyResource common properties of proxy resource.
type ProxyResource struct {
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags *map[string]*string `json:"tags,omitempty"`
}

// Resource the resource definition.
type Resource struct {
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags *map[string]*string `json:"tags,omitempty"`
}

// SavedSearch value object for saved search results.
type SavedSearch struct {
	autorest.Response `json:"-"`
	// ID - The id of the saved search.
	ID *string `json:"id,omitempty"`
	// Etag - The etag of the saved search.
	Etag *string `json:"etag,omitempty"`
	// SavedSearchProperties - Gets or sets properties of the saved search.
	*SavedSearchProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for SavedSearch struct.
func (ss *SavedSearch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		ss.ID = &ID
	}

	v = m["etag"]
	if v != nil {
		var etag string
		err = json.Unmarshal(*m["etag"], &etag)
		if err != nil {
			return err
		}
		ss.Etag = &etag
	}

	v = m["properties"]
	if v != nil {
		var properties SavedSearchProperties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		ss.SavedSearchProperties = &properties
	}

	return nil
}

// SavedSearchesListResult the saved search operation response.
type SavedSearchesListResult struct {
	autorest.Response `json:"-"`
	// Metadata - The metadata from search results.
	Metadata *SearchMetadata `json:"__metadata,omitempty"`
	// Value - The array of result values.
	Value *[]SavedSearch `json:"value,omitempty"`
}

// SavedSearchProperties value object for saved search results.
type SavedSearchProperties struct {
	// Category - The category of the saved search. This helps the user to find a saved search faster.
	Category *string `json:"Category,omitempty"`
	// DisplayName - Saved search display name.
	DisplayName *string `json:"DisplayName,omitempty"`
	// Query - The query expression for the saved search. Please see https://docs.microsoft.com/en-us/azure/log-analytics/log-analytics-search-reference for reference.
	Query *string `json:"Query,omitempty"`
	// Version - The version number of the query lanuage. Only verion 1 is allowed here.
	Version *int64 `json:"Version,omitempty"`
	// Tags - The tags attached to the saved search.
	Tags *[]Tag `json:"Tags,omitempty"`
}

// SearchError details for a search error.
type SearchError struct {
	// Type - The error type.
	Type *string `json:"type,omitempty"`
	// Message - The error message.
	Message *string `json:"message,omitempty"`
}

// SearchGetSchemaResponse the get schema operation response.
type SearchGetSchemaResponse struct {
	autorest.Response `json:"-"`
	// Metadata - The metadata from search results.
	Metadata *SearchMetadata `json:"__metadata,omitempty"`
	// Value - The array of result values.
	Value *[]SearchSchemaValue `json:"value,omitempty"`
}

// SearchHighlight highlight details.
type SearchHighlight struct {
	// Pre - The string that is put before a matched result.
	Pre *string `json:"pre,omitempty"`
	// Post - The string that is put after a matched result.
	Post *string `json:"post,omitempty"`
}

// SearchMetadata metadata for search results.
type SearchMetadata struct {
	// SearchID - The request id of the search.
	SearchID *string `json:"RequestId,omitempty"`
	// ResultType - The search result type.
	ResultType *string `json:"resultType,omitempty"`
	// Total - The total number of search results.
	Total *int64 `json:"total,omitempty"`
	// Top - The number of top search results.
	Top *int64 `json:"top,omitempty"`
	// ID - The id of the search results request.
	ID *string `json:"id,omitempty"`
	// CoreSummaries - The core summaries.
	CoreSummaries *[]CoreSummary `json:"CoreSummaries,omitempty"`
	// Status - The status of the search results.
	Status *string `json:"Status,omitempty"`
	// StartTime - The start time for the search.
	StartTime *date.Time `json:"StartTime,omitempty"`
	// LastUpdated - The time of last update.
	LastUpdated *date.Time `json:"LastUpdated,omitempty"`
	// ETag - The ETag of the search results.
	ETag *string `json:"ETag,omitempty"`
	// Sort - How the results are sorted.
	Sort *[]SearchSort `json:"sort,omitempty"`
	// RequestTime - The request time.
	RequestTime *int64 `json:"requestTime,omitempty"`
	// AggregatedValueField - The aggregated value field.
	AggregatedValueField *string `json:"aggregatedValueField,omitempty"`
	// AggregatedGroupingFields - The aggregated grouping fields.
	AggregatedGroupingFields *string `json:"aggregatedGroupingFields,omitempty"`
	// Sum - The sum of all aggregates returned in the result set.
	Sum *int64 `json:"sum,omitempty"`
	// Max - The max of all aggregates returned in the result set.
	Max *int64 `json:"max,omitempty"`
	// Schema - The schema.
	Schema *SearchMetadataSchema `json:"schema,omitempty"`
}

// SearchMetadataSchema schema metadata for search.
type SearchMetadataSchema struct {
	// Name - The name of the metadata schema.
	Name *string `json:"name,omitempty"`
	// Version - The version of the metadata schema.
	Version *int32 `json:"version,omitempty"`
}

// SearchParameters parameters specifying the search query and range.
type SearchParameters struct {
	// Top - The number to get from the top.
	Top *int64 `json:"top,omitempty"`
	// Highlight - The highlight that looks for all occurences of a string.
	Highlight *SearchHighlight `json:"highlight,omitempty"`
	// Query - The query to search.
	Query *string `json:"query,omitempty"`
	// Start - The start date filter, so the only query results returned are after this date.
	Start *date.Time `json:"start,omitempty"`
	// End - The end date filter, so the only query results returned are before this date.
	End *date.Time `json:"end,omitempty"`
}

// SearchResultsResponse the get search result operation response.
type SearchResultsResponse struct {
	autorest.Response `json:"-"`
	// ID - The id of the search, which includes the full url.
	ID *string `json:"id,omitempty"`
	// Metadata - The metadata from search results.
	Metadata *SearchMetadata `json:"__metadata,omitempty"`
	// Value - The array of result values.
	Value *[]map[string]interface{} `json:"value,omitempty"`
	// Error - The error.
	Error *SearchError `json:"error,omitempty"`
}

// SearchSchemaValue value object for schema results.
type SearchSchemaValue struct {
	// Name - The name of the schema.
	Name *string `json:"name,omitempty"`
	// DisplayName - The display name of the schema.
	DisplayName *string `json:"displayName,omitempty"`
	// Type - The type.
	Type *string `json:"type,omitempty"`
	// Indexed - The boolean that indicates the field is searchable as free text.
	Indexed *bool `json:"indexed,omitempty"`
	// Stored - The boolean that indicates whether or not the field is stored.
	Stored *bool `json:"stored,omitempty"`
	// Facet - The boolean that indicates whether or not the field is a facet.
	Facet *bool `json:"facet,omitempty"`
	// OwnerType - The array of workflows containing the field.
	OwnerType *[]string `json:"ownerType,omitempty"`
}

// SearchSort the sort parameters for search.
type SearchSort struct {
	// Name - The name of the field the search query is sorted on.
	Name *string `json:"name,omitempty"`
	// Order - The sort order of the search. Possible values include: 'Asc', 'Desc'
	Order SearchSortEnum `json:"order,omitempty"`
}

// SharedKeys the shared keys for a workspace.
type SharedKeys struct {
	autorest.Response `json:"-"`
	// PrimarySharedKey - The primary shared key of a workspace.
	PrimarySharedKey *string `json:"primarySharedKey,omitempty"`
	// SecondarySharedKey - The secondary shared key of a workspace.
	SecondarySharedKey *string `json:"secondarySharedKey,omitempty"`
}

// Sku the SKU (tier) of a workspace.
type Sku struct {
	// Name - The name of the SKU. Possible values include: 'Free', 'Standard', 'Premium', 'Unlimited', 'PerNode', 'Standalone'
	Name SkuNameEnum `json:"name,omitempty"`
}

// StorageAccount describes a storage account connection.
type StorageAccount struct {
	// ID - The Azure Resource Manager ID of the storage account resource.
	ID *string `json:"id,omitempty"`
	// Key - The storage account key.
	Key *string `json:"key,omitempty"`
}

// StorageInsight the top level storage insight resource container.
type StorageInsight struct {
	autorest.Response `json:"-"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags *map[string]*string `json:"tags,omitempty"`
	// StorageInsightProperties - Storage insight properties.
	*StorageInsightProperties `json:"properties,omitempty"`
	// ETag - The ETag of the storage insight.
	ETag *string `json:"eTag,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for StorageInsight struct.
func (si *StorageInsight) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		var properties StorageInsightProperties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		si.StorageInsightProperties = &properties
	}

	v = m["eTag"]
	if v != nil {
		var eTag string
		err = json.Unmarshal(*m["eTag"], &eTag)
		if err != nil {
			return err
		}
		si.ETag = &eTag
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		si.ID = &ID
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		si.Name = &name
	}

	v = m["type"]
	if v != nil {
		var typeVar string
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		si.Type = &typeVar
	}

	v = m["tags"]
	if v != nil {
		var tags map[string]*string
		err = json.Unmarshal(*m["tags"], &tags)
		if err != nil {
			return err
		}
		si.Tags = &tags
	}

	return nil
}

// StorageInsightListResult the list storage insights operation response.
type StorageInsightListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of storage insight instances.
	Value *[]StorageInsight `json:"value,omitempty"`
	// OdataNextLink - The link (url) to the next page of results.
	OdataNextLink *string `json:"@odata.nextLink,omitempty"`
}

// StorageInsightListResultIterator provides access to a complete listing of StorageInsight values.
type StorageInsightListResultIterator struct {
	i    int
	page StorageInsightListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *StorageInsightListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter StorageInsightListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter StorageInsightListResultIterator) Response() StorageInsightListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter StorageInsightListResultIterator) Value() StorageInsight {
	if !iter.page.NotDone() {
		return StorageInsight{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (silr StorageInsightListResult) IsEmpty() bool {
	return silr.Value == nil || len(*silr.Value) == 0
}

// storageInsightListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (silr StorageInsightListResult) storageInsightListResultPreparer() (*http.Request, error) {
	if silr.OdataNextLink == nil || len(to.String(silr.OdataNextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(silr.OdataNextLink)))
}

// StorageInsightListResultPage contains a page of StorageInsight values.
type StorageInsightListResultPage struct {
	fn   func(StorageInsightListResult) (StorageInsightListResult, error)
	silr StorageInsightListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *StorageInsightListResultPage) Next() error {
	next, err := page.fn(page.silr)
	if err != nil {
		return err
	}
	page.silr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page StorageInsightListResultPage) NotDone() bool {
	return !page.silr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page StorageInsightListResultPage) Response() StorageInsightListResult {
	return page.silr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page StorageInsightListResultPage) Values() []StorageInsight {
	if page.silr.IsEmpty() {
		return nil
	}
	return *page.silr.Value
}

// StorageInsightProperties storage insight properties.
type StorageInsightProperties struct {
	// Containers - The names of the blob containers that the workspace should read
	Containers *[]string `json:"containers,omitempty"`
	// Tables - The names of the Azure tables that the workspace should read
	Tables *[]string `json:"tables,omitempty"`
	// StorageAccount - The storage account connection details
	StorageAccount *StorageAccount `json:"storageAccount,omitempty"`
	// Status - The status of the storage insight
	Status *StorageInsightStatus `json:"status,omitempty"`
}

// StorageInsightStatus the status of the storage insight.
type StorageInsightStatus struct {
	// State - The state of the storage insight connection to the workspace. Possible values include: 'OK', 'ERROR'
	State StorageInsightState `json:"state,omitempty"`
	// Description - Description of the state of the storage insight.
	Description *string `json:"description,omitempty"`
}

// Tag a tag of a saved search.
type Tag struct {
	// Name - The tag name.
	Name *string `json:"Name,omitempty"`
	// Value - The tag value.
	Value *string `json:"Value,omitempty"`
}

// UsageMetric a metric describing the usage of a resource.
type UsageMetric struct {
	// Name - The name of the metric.
	Name *MetricName `json:"name,omitempty"`
	// Unit - The units used for the metric.
	Unit *string `json:"unit,omitempty"`
	// CurrentValue - The current value of the metric.
	CurrentValue *float64 `json:"currentValue,omitempty"`
	// Limit - The quota limit for the metric.
	Limit *float64 `json:"limit,omitempty"`
	// NextResetTime - The time that the metric's value will reset.
	NextResetTime *date.Time `json:"nextResetTime,omitempty"`
	// QuotaPeriod - The quota period that determines the length of time between value resets.
	QuotaPeriod *string `json:"quotaPeriod,omitempty"`
}

// Workspace the top level Workspace resource container.
type Workspace struct {
	autorest.Response `json:"-"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags *map[string]*string `json:"tags,omitempty"`
	// WorkspaceProperties - Workspace properties.
	*WorkspaceProperties `json:"properties,omitempty"`
	// ETag - The ETag of the workspace.
	ETag *string `json:"eTag,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for Workspace struct.
func (w *Workspace) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		var properties WorkspaceProperties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		w.WorkspaceProperties = &properties
	}

	v = m["eTag"]
	if v != nil {
		var eTag string
		err = json.Unmarshal(*m["eTag"], &eTag)
		if err != nil {
			return err
		}
		w.ETag = &eTag
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		w.ID = &ID
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		w.Name = &name
	}

	v = m["type"]
	if v != nil {
		var typeVar string
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		w.Type = &typeVar
	}

	v = m["location"]
	if v != nil {
		var location string
		err = json.Unmarshal(*m["location"], &location)
		if err != nil {
			return err
		}
		w.Location = &location
	}

	v = m["tags"]
	if v != nil {
		var tags map[string]*string
		err = json.Unmarshal(*m["tags"], &tags)
		if err != nil {
			return err
		}
		w.Tags = &tags
	}

	return nil
}

// WorkspaceListManagementGroupsResult the list workspace managmement groups operation response.
type WorkspaceListManagementGroupsResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of management groups attached to the workspace.
	Value *[]ManagementGroup `json:"value,omitempty"`
}

// WorkspaceListResult the list workspaces operation response.
type WorkspaceListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of workspaces.
	Value *[]Workspace `json:"value,omitempty"`
}

// WorkspaceListUsagesResult the list workspace usages operation response.
type WorkspaceListUsagesResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of usage metrics for a workspace.
	Value *[]UsageMetric `json:"value,omitempty"`
}

// WorkspaceProperties workspace properties.
type WorkspaceProperties struct {
	// ProvisioningState - The provisioning state of the workspace. Possible values include: 'Creating', 'Succeeded', 'Failed', 'Canceled', 'Deleting', 'ProvisioningAccount'
	ProvisioningState EntityStatus `json:"provisioningState,omitempty"`
	// Source - The source of the workspace.  Source defines where the workspace was created. 'Azure' implies it was created in Azure.  'External' implies it was created via the Operational Insights Portal. This value is set on the service side and read-only on the client side.
	Source *string `json:"source,omitempty"`
	// CustomerID - The ID associated with the workspace.  Setting this value at creation time allows the workspace being created to be linked to an existing workspace.
	CustomerID *string `json:"customerId,omitempty"`
	// PortalURL - The URL of the Operational Insights portal for this workspace.  This value is set on the service side and read-only on the client side.
	PortalURL *string `json:"portalUrl,omitempty"`
	// Sku - The SKU of the workspace.
	Sku *Sku `json:"sku,omitempty"`
	// RetentionInDays - The workspace data retention in days. -1 means Unlimited retention for the Unlimited Sku. 730 days is the maximum allowed for all other Skus.
	RetentionInDays *int32 `json:"retentionInDays,omitempty"`
}

// WorkspacesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type WorkspacesCreateOrUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future WorkspacesCreateOrUpdateFuture) Result(client WorkspacesClient) (w Workspace, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		return
	}
	if !done {
		return w, autorest.NewError("operationalinsights.WorkspacesCreateOrUpdateFuture", "Result", "asynchronous operation has not completed")
	}
	if future.PollingMethod() == azure.PollingLocation {
		w, err = client.CreateOrUpdateResponder(future.Response())
		return
	}
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, autorest.ChangeToGet(future.req),
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return
	}
	w, err = client.CreateOrUpdateResponder(resp)
	return
}

// WorkspacesGetSearchResultsFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type WorkspacesGetSearchResultsFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future WorkspacesGetSearchResultsFuture) Result(client WorkspacesClient) (srr SearchResultsResponse, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		return
	}
	if !done {
		return srr, autorest.NewError("operationalinsights.WorkspacesGetSearchResultsFuture", "Result", "asynchronous operation has not completed")
	}
	if future.PollingMethod() == azure.PollingLocation {
		srr, err = client.GetSearchResultsResponder(future.Response())
		return
	}
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, autorest.ChangeToGet(future.req),
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return
	}
	srr, err = client.GetSearchResultsResponder(resp)
	return
}
