package notificationhubs

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// AccessRights enumerates the values for access rights.
type AccessRights string

const (
	// Listen ...
	Listen AccessRights = "Listen"
	// Manage ...
	Manage AccessRights = "Manage"
	// Send ...
	Send AccessRights = "Send"
)

// NamespaceType enumerates the values for namespace type.
type NamespaceType string

const (
	// Messaging ...
	Messaging NamespaceType = "Messaging"
	// NotificationHub ...
	NotificationHub NamespaceType = "NotificationHub"
)

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// Basic ...
	Basic SkuName = "Basic"
	// Free ...
	Free SkuName = "Free"
	// Standard ...
	Standard SkuName = "Standard"
)

// AdmCredential description of a NotificationHub AdmCredential.
type AdmCredential struct {
	// AdmCredentialProperties - Properties of NotificationHub AdmCredential.
	*AdmCredentialProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AdmCredential struct.
func (ac *AdmCredential) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		var properties AdmCredentialProperties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		ac.AdmCredentialProperties = &properties
	}

	return nil
}

// AdmCredentialProperties description of a NotificationHub AdmCredential.
type AdmCredentialProperties struct {
	// ClientID - The client identifier.
	ClientID *string `json:"clientId,omitempty"`
	// ClientSecret - The credential secret access key.
	ClientSecret *string `json:"clientSecret,omitempty"`
	// AuthTokenURL - The URL of the authorization token.
	AuthTokenURL *string `json:"authTokenUrl,omitempty"`
}

// ApnsCredential description of a NotificationHub ApnsCredential.
type ApnsCredential struct {
	// ApnsCredentialProperties - Properties of NotificationHub ApnsCredential.
	*ApnsCredentialProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ApnsCredential struct.
func (ac *ApnsCredential) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		var properties ApnsCredentialProperties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		ac.ApnsCredentialProperties = &properties
	}

	return nil
}

// ApnsCredentialProperties description of a NotificationHub ApnsCredential.
type ApnsCredentialProperties struct {
	// ApnsCertificate - The APNS certificate.
	ApnsCertificate *string `json:"apnsCertificate,omitempty"`
	// CertificateKey - The certificate key.
	CertificateKey *string `json:"certificateKey,omitempty"`
	// Endpoint - The endpoint of this credential.
	Endpoint *string `json:"endpoint,omitempty"`
	// Thumbprint - The Apns certificate Thumbprint
	Thumbprint *string `json:"thumbprint,omitempty"`
	// KeyID - A 10-character key identifier (kid) key, obtained from your developer account
	KeyID *string `json:"keyId,omitempty"`
	// AppName - The name of the application
	AppName *string `json:"appName,omitempty"`
	// AppID - The issuer (iss) registered claim key, whose value is your 10-character Team ID, obtained from your developer account
	AppID *string `json:"appId,omitempty"`
	// Token - Provider Authentication Token, obtained through your developer account
	Token *string `json:"token,omitempty"`
}

// BaiduCredential description of a NotificationHub BaiduCredential.
type BaiduCredential struct {
	// BaiduCredentialProperties - Properties of NotificationHub BaiduCredential.
	*BaiduCredentialProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for BaiduCredential struct.
func (bc *BaiduCredential) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		var properties BaiduCredentialProperties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		bc.BaiduCredentialProperties = &properties
	}

	return nil
}

// BaiduCredentialProperties description of a NotificationHub BaiduCredential.
type BaiduCredentialProperties struct {
	// BaiduAPIKey - Baidu Api Key.
	BaiduAPIKey *string `json:"baiduApiKey,omitempty"`
	// BaiduEndPoint - Baidu Endpoint.
	BaiduEndPoint *string `json:"baiduEndPoint,omitempty"`
	// BaiduSecretKey - Baidu Secret Key
	BaiduSecretKey *string `json:"baiduSecretKey,omitempty"`
}

// CheckAvailabilityParameters parameters supplied to the Check Name Availability for Namespace and NotificationHubs.
type CheckAvailabilityParameters struct {
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags *map[string]*string `json:"tags,omitempty"`
	// Sku - The sku of the created namespace
	Sku *Sku `json:"sku,omitempty"`
	// IsAvailiable - True if the name is available and can be used to create new Namespace/NotificationHub. Otherwise false.
	IsAvailiable *bool `json:"isAvailiable,omitempty"`
}

// CheckAvailabilityResult description of a CheckAvailibility resource.
type CheckAvailabilityResult struct {
	autorest.Response `json:"-"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags *map[string]*string `json:"tags,omitempty"`
	// Sku - The sku of the created namespace
	Sku *Sku `json:"sku,omitempty"`
	// IsAvailiable - True if the name is available and can be used to create new Namespace/NotificationHub. Otherwise false.
	IsAvailiable *bool `json:"isAvailiable,omitempty"`
}

// CheckNameAvailabilityRequestParameters parameters supplied to the Check Name Availability for Namespace and
// NotificationHubs.
type CheckNameAvailabilityRequestParameters struct {
	// Name - Resource name
	Name *string `json:"Name,omitempty"`
	// Type - Resource type
	Type *string `json:"Type,omitempty"`
}

// CheckNameAvailabilityResponse ...
type CheckNameAvailabilityResponse struct {
	autorest.Response `json:"-"`
	// NameAvailable - Checks if the namespace name is available
	NameAvailable *bool `json:"NameAvailable,omitempty"`
	// Reason - States the reason due to which the namespace name is not available
	Reason *string `json:"Reason,omitempty"`
	// Message - The messsage returned when checking for namespace name availability
	Message *string `json:"Message,omitempty"`
}

// CreateOrUpdateParameters parameters supplied to the CreateOrUpdate NotificationHub operation.
type CreateOrUpdateParameters struct {
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags *map[string]*string `json:"tags,omitempty"`
	// Sku - The sku of the created namespace
	Sku *Sku `json:"sku,omitempty"`
	// Properties - Properties of the NotificationHub.
	*Properties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for CreateOrUpdateParameters struct.
func (coup *CreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		var properties Properties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		coup.Properties = &properties
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		coup.ID = &ID
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		coup.Name = &name
	}

	v = m["type"]
	if v != nil {
		var typeVar string
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		coup.Type = &typeVar
	}

	v = m["location"]
	if v != nil {
		var location string
		err = json.Unmarshal(*m["location"], &location)
		if err != nil {
			return err
		}
		coup.Location = &location
	}

	v = m["tags"]
	if v != nil {
		var tags map[string]*string
		err = json.Unmarshal(*m["tags"], &tags)
		if err != nil {
			return err
		}
		coup.Tags = &tags
	}

	v = m["sku"]
	if v != nil {
		var sku Sku
		err = json.Unmarshal(*m["sku"], &sku)
		if err != nil {
			return err
		}
		coup.Sku = &sku
	}

	return nil
}

// GcmCredential description of a NotificationHub GcmCredential.
type GcmCredential struct {
	// GcmCredentialProperties - Properties of NotificationHub GcmCredential.
	*GcmCredentialProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for GcmCredential struct.
func (gc *GcmCredential) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		var properties GcmCredentialProperties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		gc.GcmCredentialProperties = &properties
	}

	return nil
}

// GcmCredentialProperties description of a NotificationHub GcmCredential.
type GcmCredentialProperties struct {
	// GcmEndpoint - The GCM endpoint.
	GcmEndpoint *string `json:"gcmEndpoint,omitempty"`
	// GoogleAPIKey - The Google API key.
	GoogleAPIKey *string `json:"googleApiKey,omitempty"`
}

// ListResult the response of the List NotificationHub operation.
type ListResult struct {
	autorest.Response `json:"-"`
	// Value - Result of the List NotificationHub operation.
	Value *[]ResourceType `json:"value,omitempty"`
	// NextLink - Link to the next set of results. Not empty if Value contains incomplete list of NotificationHub
	NextLink *string `json:"nextLink,omitempty"`
}

// ListResultIterator provides access to a complete listing of ResourceType values.
type ListResultIterator struct {
	i    int
	page ListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListResultIterator) Response() ListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListResultIterator) Value() ResourceType {
	if !iter.page.NotDone() {
		return ResourceType{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (lr ListResult) IsEmpty() bool {
	return lr.Value == nil || len(*lr.Value) == 0
}

// listResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lr ListResult) listResultPreparer() (*http.Request, error) {
	if lr.NextLink == nil || len(to.String(lr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lr.NextLink)))
}

// ListResultPage contains a page of ResourceType values.
type ListResultPage struct {
	fn func(ListResult) (ListResult, error)
	lr ListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListResultPage) Next() error {
	next, err := page.fn(page.lr)
	if err != nil {
		return err
	}
	page.lr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListResultPage) NotDone() bool {
	return !page.lr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListResultPage) Response() ListResult {
	return page.lr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListResultPage) Values() []ResourceType {
	if page.lr.IsEmpty() {
		return nil
	}
	return *page.lr.Value
}

// MpnsCredential description of a NotificationHub MpnsCredential.
type MpnsCredential struct {
	// MpnsCredentialProperties - Properties of NotificationHub MpnsCredential.
	*MpnsCredentialProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for MpnsCredential struct.
func (mc *MpnsCredential) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		var properties MpnsCredentialProperties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		mc.MpnsCredentialProperties = &properties
	}

	return nil
}

// MpnsCredentialProperties description of a NotificationHub MpnsCredential.
type MpnsCredentialProperties struct {
	// MpnsCertificate - The MPNS certificate.
	MpnsCertificate *string `json:"mpnsCertificate,omitempty"`
	// CertificateKey - The certificate key for this credential.
	CertificateKey *string `json:"certificateKey,omitempty"`
	// Thumbprint - The Mpns certificate Thumbprint
	Thumbprint *string `json:"thumbprint,omitempty"`
}

// NamespaceCreateOrUpdateParameters parameters supplied to the CreateOrUpdate Namespace operation.
type NamespaceCreateOrUpdateParameters struct {
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags *map[string]*string `json:"tags,omitempty"`
	// Sku - The sku of the created namespace
	Sku *Sku `json:"sku,omitempty"`
	// NamespaceProperties - Properties of the Namespace.
	*NamespaceProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for NamespaceCreateOrUpdateParameters struct.
func (ncoup *NamespaceCreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		var properties NamespaceProperties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		ncoup.NamespaceProperties = &properties
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		ncoup.ID = &ID
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		ncoup.Name = &name
	}

	v = m["type"]
	if v != nil {
		var typeVar string
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		ncoup.Type = &typeVar
	}

	v = m["location"]
	if v != nil {
		var location string
		err = json.Unmarshal(*m["location"], &location)
		if err != nil {
			return err
		}
		ncoup.Location = &location
	}

	v = m["tags"]
	if v != nil {
		var tags map[string]*string
		err = json.Unmarshal(*m["tags"], &tags)
		if err != nil {
			return err
		}
		ncoup.Tags = &tags
	}

	v = m["sku"]
	if v != nil {
		var sku Sku
		err = json.Unmarshal(*m["sku"], &sku)
		if err != nil {
			return err
		}
		ncoup.Sku = &sku
	}

	return nil
}

// NamespaceListResult the response of the List Namespace operation.
type NamespaceListResult struct {
	autorest.Response `json:"-"`
	// Value - Result of the List Namespace operation.
	Value *[]NamespaceResource `json:"value,omitempty"`
	// NextLink - Link to the next set of results. Not empty if Value contains incomplete list of Namespaces
	NextLink *string `json:"nextLink,omitempty"`
}

// NamespaceListResultIterator provides access to a complete listing of NamespaceResource values.
type NamespaceListResultIterator struct {
	i    int
	page NamespaceListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *NamespaceListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter NamespaceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter NamespaceListResultIterator) Response() NamespaceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter NamespaceListResultIterator) Value() NamespaceResource {
	if !iter.page.NotDone() {
		return NamespaceResource{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (nlr NamespaceListResult) IsEmpty() bool {
	return nlr.Value == nil || len(*nlr.Value) == 0
}

// namespaceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (nlr NamespaceListResult) namespaceListResultPreparer() (*http.Request, error) {
	if nlr.NextLink == nil || len(to.String(nlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(nlr.NextLink)))
}

// NamespaceListResultPage contains a page of NamespaceResource values.
type NamespaceListResultPage struct {
	fn  func(NamespaceListResult) (NamespaceListResult, error)
	nlr NamespaceListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *NamespaceListResultPage) Next() error {
	next, err := page.fn(page.nlr)
	if err != nil {
		return err
	}
	page.nlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page NamespaceListResultPage) NotDone() bool {
	return !page.nlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page NamespaceListResultPage) Response() NamespaceListResult {
	return page.nlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page NamespaceListResultPage) Values() []NamespaceResource {
	if page.nlr.IsEmpty() {
		return nil
	}
	return *page.nlr.Value
}

// NamespacePatchParameters parameters supplied to the Patch Namespace operation.
type NamespacePatchParameters struct {
	// Tags - Resource tags
	Tags *map[string]*string `json:"tags,omitempty"`
	// Sku - The sku of the created namespace
	Sku *Sku `json:"sku,omitempty"`
}

// NamespaceProperties namespace properties.
type NamespaceProperties struct {
	// Name - The name of the namespace.
	Name *string `json:"name,omitempty"`
	// ProvisioningState - Provisioning state of the Namespace.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// Region - Specifies the targeted region in which the namespace should be created. It can be any of the following values: Australia EastAustralia SoutheastCentral USEast USEast US 2West USNorth Central USSouth Central USEast AsiaSoutheast AsiaBrazil SouthJapan EastJapan WestNorth EuropeWest Europe
	Region *string `json:"region,omitempty"`
	// Status - Status of the namespace. It can be any of these values:1 = Created/Active2 = Creating3 = Suspended4 = Deleting
	Status *string `json:"status,omitempty"`
	// CreatedAt - The time the namespace was created.
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// ServiceBusEndpoint - Endpoint you can use to perform NotificationHub operations.
	ServiceBusEndpoint *string `json:"serviceBusEndpoint,omitempty"`
	// SubscriptionID - The Id of the Azure subscription associated with the namespace.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// ScaleUnit - ScaleUnit where the namespace gets created
	ScaleUnit *string `json:"scaleUnit,omitempty"`
	// Enabled - Whether or not the namespace is currently enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// Critical - Whether or not the namespace is set as Critical.
	Critical *bool `json:"critical,omitempty"`
	// NamespaceType - The namespace type. Possible values include: 'Messaging', 'NotificationHub'
	NamespaceType NamespaceType `json:"namespaceType,omitempty"`
}

// NamespaceResource description of a Namespace resource.
type NamespaceResource struct {
	autorest.Response `json:"-"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags *map[string]*string `json:"tags,omitempty"`
	// Sku - The sku of the created namespace
	Sku *Sku `json:"sku,omitempty"`
	// NamespaceProperties - Properties of the Namespace.
	*NamespaceProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for NamespaceResource struct.
func (nr *NamespaceResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		var properties NamespaceProperties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		nr.NamespaceProperties = &properties
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		nr.ID = &ID
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		nr.Name = &name
	}

	v = m["type"]
	if v != nil {
		var typeVar string
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		nr.Type = &typeVar
	}

	v = m["location"]
	if v != nil {
		var location string
		err = json.Unmarshal(*m["location"], &location)
		if err != nil {
			return err
		}
		nr.Location = &location
	}

	v = m["tags"]
	if v != nil {
		var tags map[string]*string
		err = json.Unmarshal(*m["tags"], &tags)
		if err != nil {
			return err
		}
		nr.Tags = &tags
	}

	v = m["sku"]
	if v != nil {
		var sku Sku
		err = json.Unmarshal(*m["sku"], &sku)
		if err != nil {
			return err
		}
		nr.Sku = &sku
	}

	return nil
}

// NamespacesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type NamespacesDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future NamespacesDeleteFuture) Result(client NamespacesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		return
	}
	if !done {
		return ar, autorest.NewError("notificationhubs.NamespacesDeleteFuture", "Result", "asynchronous operation has not completed")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		return
	}
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, autorest.ChangeToGet(future.req),
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return
	}
	ar, err = client.DeleteResponder(resp)
	return
}

// PnsCredentialsProperties description of a NotificationHub PNS Credentials.
type PnsCredentialsProperties struct {
	// ApnsCredential - The ApnsCredential of the created NotificationHub
	ApnsCredential *ApnsCredential `json:"apnsCredential,omitempty"`
	// WnsCredential - The WnsCredential of the created NotificationHub
	WnsCredential *WnsCredential `json:"wnsCredential,omitempty"`
	// GcmCredential - The GcmCredential of the created NotificationHub
	GcmCredential *GcmCredential `json:"gcmCredential,omitempty"`
	// MpnsCredential - The MpnsCredential of the created NotificationHub
	MpnsCredential *MpnsCredential `json:"mpnsCredential,omitempty"`
	// AdmCredential - The AdmCredential of the created NotificationHub
	AdmCredential *AdmCredential `json:"admCredential,omitempty"`
	// BaiduCredential - The BaiduCredential of the created NotificationHub
	BaiduCredential *BaiduCredential `json:"baiduCredential,omitempty"`
}

// PnsCredentialsResource description of a NotificationHub PNS Credentials.
type PnsCredentialsResource struct {
	autorest.Response `json:"-"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags *map[string]*string `json:"tags,omitempty"`
	// Sku - The sku of the created namespace
	Sku *Sku `json:"sku,omitempty"`
	// PnsCredentialsProperties - NotificationHub PNS Credentials.
	*PnsCredentialsProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for PnsCredentialsResource struct.
func (pcr *PnsCredentialsResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		var properties PnsCredentialsProperties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		pcr.PnsCredentialsProperties = &properties
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		pcr.ID = &ID
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		pcr.Name = &name
	}

	v = m["type"]
	if v != nil {
		var typeVar string
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		pcr.Type = &typeVar
	}

	v = m["location"]
	if v != nil {
		var location string
		err = json.Unmarshal(*m["location"], &location)
		if err != nil {
			return err
		}
		pcr.Location = &location
	}

	v = m["tags"]
	if v != nil {
		var tags map[string]*string
		err = json.Unmarshal(*m["tags"], &tags)
		if err != nil {
			return err
		}
		pcr.Tags = &tags
	}

	v = m["sku"]
	if v != nil {
		var sku Sku
		err = json.Unmarshal(*m["sku"], &sku)
		if err != nil {
			return err
		}
		pcr.Sku = &sku
	}

	return nil
}

// PolicykeyResource namespace/NotificationHub Regenerate Keys
type PolicykeyResource struct {
	// PolicyKey - Name of the key that has to be regenerated for the Namespace/Notification Hub Authorization Rule. The value can be Primary Key/Secondary Key.
	PolicyKey *string `json:"policyKey,omitempty"`
}

// Properties notificationHub properties.
type Properties struct {
	// Name - The NotificationHub name.
	Name *string `json:"name,omitempty"`
	// RegistrationTTL - The RegistrationTtl of the created NotificationHub
	RegistrationTTL *string `json:"registrationTtl,omitempty"`
	// AuthorizationRules - The AuthorizationRules of the created NotificationHub
	AuthorizationRules *[]SharedAccessAuthorizationRuleProperties `json:"authorizationRules,omitempty"`
	// ApnsCredential - The ApnsCredential of the created NotificationHub
	ApnsCredential *ApnsCredential `json:"apnsCredential,omitempty"`
	// WnsCredential - The WnsCredential of the created NotificationHub
	WnsCredential *WnsCredential `json:"wnsCredential,omitempty"`
	// GcmCredential - The GcmCredential of the created NotificationHub
	GcmCredential *GcmCredential `json:"gcmCredential,omitempty"`
	// MpnsCredential - The MpnsCredential of the created NotificationHub
	MpnsCredential *MpnsCredential `json:"mpnsCredential,omitempty"`
	// AdmCredential - The AdmCredential of the created NotificationHub
	AdmCredential *AdmCredential `json:"admCredential,omitempty"`
	// BaiduCredential - The BaiduCredential of the created NotificationHub
	BaiduCredential *BaiduCredential `json:"baiduCredential,omitempty"`
}

// Resource ...
type Resource struct {
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags *map[string]*string `json:"tags,omitempty"`
	// Sku - The sku of the created namespace
	Sku *Sku `json:"sku,omitempty"`
}

// ResourceListKeys namespace/NotificationHub Connection String
type ResourceListKeys struct {
	autorest.Response `json:"-"`
	// PrimaryConnectionString - PrimaryConnectionString of the AuthorizationRule.
	PrimaryConnectionString *string `json:"primaryConnectionString,omitempty"`
	// SecondaryConnectionString - SecondaryConnectionString of the created AuthorizationRule
	SecondaryConnectionString *string `json:"secondaryConnectionString,omitempty"`
	// PrimaryKey - PrimaryKey of the created AuthorizationRule.
	PrimaryKey *string `json:"primaryKey,omitempty"`
	// SecondaryKey - SecondaryKey of the created AuthorizationRule
	SecondaryKey *string `json:"secondaryKey,omitempty"`
	// KeyName - KeyName of the created AuthorizationRule
	KeyName *string `json:"keyName,omitempty"`
}

// ResourceType description of a NotificationHub Resource.
type ResourceType struct {
	autorest.Response `json:"-"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags *map[string]*string `json:"tags,omitempty"`
	// Sku - The sku of the created namespace
	Sku *Sku `json:"sku,omitempty"`
	// Properties - Properties of the NotificationHub.
	*Properties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ResourceType struct.
func (rt *ResourceType) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		var properties Properties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		rt.Properties = &properties
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		rt.ID = &ID
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		rt.Name = &name
	}

	v = m["type"]
	if v != nil {
		var typeVar string
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		rt.Type = &typeVar
	}

	v = m["location"]
	if v != nil {
		var location string
		err = json.Unmarshal(*m["location"], &location)
		if err != nil {
			return err
		}
		rt.Location = &location
	}

	v = m["tags"]
	if v != nil {
		var tags map[string]*string
		err = json.Unmarshal(*m["tags"], &tags)
		if err != nil {
			return err
		}
		rt.Tags = &tags
	}

	v = m["sku"]
	if v != nil {
		var sku Sku
		err = json.Unmarshal(*m["sku"], &sku)
		if err != nil {
			return err
		}
		rt.Sku = &sku
	}

	return nil
}

// SharedAccessAuthorizationRuleCreateOrUpdateParameters parameters supplied to the CreateOrUpdate Namespace
// AuthorizationRules.
type SharedAccessAuthorizationRuleCreateOrUpdateParameters struct {
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags *map[string]*string `json:"tags,omitempty"`
	// Sku - The sku of the created namespace
	Sku *Sku `json:"sku,omitempty"`
	// Properties - Properties of the Namespace AuthorizationRules.
	Properties *SharedAccessAuthorizationRuleProperties `json:"properties,omitempty"`
}

// SharedAccessAuthorizationRuleListResult the response of the List Namespace operation.
type SharedAccessAuthorizationRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - Result of the List AuthorizationRules operation.
	Value *[]SharedAccessAuthorizationRuleResource `json:"value,omitempty"`
	// NextLink - Link to the next set of results. Not empty if Value contains incomplete list of AuthorizationRules
	NextLink *string `json:"nextLink,omitempty"`
}

// SharedAccessAuthorizationRuleListResultIterator provides access to a complete listing of
// SharedAccessAuthorizationRuleResource values.
type SharedAccessAuthorizationRuleListResultIterator struct {
	i    int
	page SharedAccessAuthorizationRuleListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SharedAccessAuthorizationRuleListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SharedAccessAuthorizationRuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SharedAccessAuthorizationRuleListResultIterator) Response() SharedAccessAuthorizationRuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SharedAccessAuthorizationRuleListResultIterator) Value() SharedAccessAuthorizationRuleResource {
	if !iter.page.NotDone() {
		return SharedAccessAuthorizationRuleResource{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (saarlr SharedAccessAuthorizationRuleListResult) IsEmpty() bool {
	return saarlr.Value == nil || len(*saarlr.Value) == 0
}

// sharedAccessAuthorizationRuleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (saarlr SharedAccessAuthorizationRuleListResult) sharedAccessAuthorizationRuleListResultPreparer() (*http.Request, error) {
	if saarlr.NextLink == nil || len(to.String(saarlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(saarlr.NextLink)))
}

// SharedAccessAuthorizationRuleListResultPage contains a page of SharedAccessAuthorizationRuleResource values.
type SharedAccessAuthorizationRuleListResultPage struct {
	fn     func(SharedAccessAuthorizationRuleListResult) (SharedAccessAuthorizationRuleListResult, error)
	saarlr SharedAccessAuthorizationRuleListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SharedAccessAuthorizationRuleListResultPage) Next() error {
	next, err := page.fn(page.saarlr)
	if err != nil {
		return err
	}
	page.saarlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SharedAccessAuthorizationRuleListResultPage) NotDone() bool {
	return !page.saarlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SharedAccessAuthorizationRuleListResultPage) Response() SharedAccessAuthorizationRuleListResult {
	return page.saarlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SharedAccessAuthorizationRuleListResultPage) Values() []SharedAccessAuthorizationRuleResource {
	if page.saarlr.IsEmpty() {
		return nil
	}
	return *page.saarlr.Value
}

// SharedAccessAuthorizationRuleProperties sharedAccessAuthorizationRule properties.
type SharedAccessAuthorizationRuleProperties struct {
	// Rights - The rights associated with the rule.
	Rights *[]AccessRights `json:"rights,omitempty"`
}

// SharedAccessAuthorizationRuleResource description of a Namespace AuthorizationRules.
type SharedAccessAuthorizationRuleResource struct {
	autorest.Response `json:"-"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags *map[string]*string `json:"tags,omitempty"`
	// Sku - The sku of the created namespace
	Sku *Sku `json:"sku,omitempty"`
	// SharedAccessAuthorizationRuleProperties - Pproperties of the Namespace AuthorizationRule.
	*SharedAccessAuthorizationRuleProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for SharedAccessAuthorizationRuleResource struct.
func (saarr *SharedAccessAuthorizationRuleResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		var properties SharedAccessAuthorizationRuleProperties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		saarr.SharedAccessAuthorizationRuleProperties = &properties
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		saarr.ID = &ID
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		saarr.Name = &name
	}

	v = m["type"]
	if v != nil {
		var typeVar string
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		saarr.Type = &typeVar
	}

	v = m["location"]
	if v != nil {
		var location string
		err = json.Unmarshal(*m["location"], &location)
		if err != nil {
			return err
		}
		saarr.Location = &location
	}

	v = m["tags"]
	if v != nil {
		var tags map[string]*string
		err = json.Unmarshal(*m["tags"], &tags)
		if err != nil {
			return err
		}
		saarr.Tags = &tags
	}

	v = m["sku"]
	if v != nil {
		var sku Sku
		err = json.Unmarshal(*m["sku"], &sku)
		if err != nil {
			return err
		}
		saarr.Sku = &sku
	}

	return nil
}

// Sku the Sku description for a namespace
type Sku struct {
	// Name - Name of the notification hub sku. Possible values include: 'Free', 'Basic', 'Standard'
	Name SkuName `json:"name,omitempty"`
	// Tier - The tier of particular sku
	Tier *string `json:"tier,omitempty"`
	// Size - The Sku size
	Size *string `json:"size,omitempty"`
	// Family - The Sku Family
	Family *string `json:"family,omitempty"`
	// Capacity - The capacity of the resource
	Capacity *int32 `json:"capacity,omitempty"`
}

// SubResource ...
type SubResource struct {
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// WnsCredential description of a NotificationHub WnsCredential.
type WnsCredential struct {
	// WnsCredentialProperties - Properties of NotificationHub WnsCredential.
	*WnsCredentialProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for WnsCredential struct.
func (wc *WnsCredential) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		var properties WnsCredentialProperties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		wc.WnsCredentialProperties = &properties
	}

	return nil
}

// WnsCredentialProperties description of a NotificationHub WnsCredential.
type WnsCredentialProperties struct {
	// PackageSid - The package ID for this credential.
	PackageSid *string `json:"packageSid,omitempty"`
	// SecretKey - The secret key.
	SecretKey *string `json:"secretKey,omitempty"`
	// WindowsLiveEndpoint - The Windows Live endpoint.
	WindowsLiveEndpoint *string `json:"windowsLiveEndpoint,omitempty"`
}
