package keyvault

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/satori/go.uuid"
	"net/http"
)

// CertificatePermissions enumerates the values for certificate permissions.
type CertificatePermissions string

const (
	// All ...
	All CertificatePermissions = "all"
	// Create ...
	Create CertificatePermissions = "create"
	// Delete ...
	Delete CertificatePermissions = "delete"
	// Deleteissuers ...
	Deleteissuers CertificatePermissions = "deleteissuers"
	// Get ...
	Get CertificatePermissions = "get"
	// Getissuers ...
	Getissuers CertificatePermissions = "getissuers"
	// Import ...
	Import CertificatePermissions = "import"
	// List ...
	List CertificatePermissions = "list"
	// Listissuers ...
	Listissuers CertificatePermissions = "listissuers"
	// Managecontacts ...
	Managecontacts CertificatePermissions = "managecontacts"
	// Manageissuers ...
	Manageissuers CertificatePermissions = "manageissuers"
	// Purge ...
	Purge CertificatePermissions = "purge"
	// Recover ...
	Recover CertificatePermissions = "recover"
	// Setissuers ...
	Setissuers CertificatePermissions = "setissuers"
	// Update ...
	Update CertificatePermissions = "update"
)

// KeyPermissions enumerates the values for key permissions.
type KeyPermissions string

const (
	// KeyPermissionsAll ...
	KeyPermissionsAll KeyPermissions = "all"
	// KeyPermissionsBackup ...
	KeyPermissionsBackup KeyPermissions = "backup"
	// KeyPermissionsCreate ...
	KeyPermissionsCreate KeyPermissions = "create"
	// KeyPermissionsDecrypt ...
	KeyPermissionsDecrypt KeyPermissions = "decrypt"
	// KeyPermissionsDelete ...
	KeyPermissionsDelete KeyPermissions = "delete"
	// KeyPermissionsEncrypt ...
	KeyPermissionsEncrypt KeyPermissions = "encrypt"
	// KeyPermissionsGet ...
	KeyPermissionsGet KeyPermissions = "get"
	// KeyPermissionsImport ...
	KeyPermissionsImport KeyPermissions = "import"
	// KeyPermissionsList ...
	KeyPermissionsList KeyPermissions = "list"
	// KeyPermissionsPurge ...
	KeyPermissionsPurge KeyPermissions = "purge"
	// KeyPermissionsRecover ...
	KeyPermissionsRecover KeyPermissions = "recover"
	// KeyPermissionsRestore ...
	KeyPermissionsRestore KeyPermissions = "restore"
	// KeyPermissionsSign ...
	KeyPermissionsSign KeyPermissions = "sign"
	// KeyPermissionsUnwrapKey ...
	KeyPermissionsUnwrapKey KeyPermissions = "unwrapKey"
	// KeyPermissionsUpdate ...
	KeyPermissionsUpdate KeyPermissions = "update"
	// KeyPermissionsVerify ...
	KeyPermissionsVerify KeyPermissions = "verify"
	// KeyPermissionsWrapKey ...
	KeyPermissionsWrapKey KeyPermissions = "wrapKey"
)

// SecretPermissions enumerates the values for secret permissions.
type SecretPermissions string

const (
	// SecretPermissionsAll ...
	SecretPermissionsAll SecretPermissions = "all"
	// SecretPermissionsBackup ...
	SecretPermissionsBackup SecretPermissions = "backup"
	// SecretPermissionsDelete ...
	SecretPermissionsDelete SecretPermissions = "delete"
	// SecretPermissionsGet ...
	SecretPermissionsGet SecretPermissions = "get"
	// SecretPermissionsList ...
	SecretPermissionsList SecretPermissions = "list"
	// SecretPermissionsPurge ...
	SecretPermissionsPurge SecretPermissions = "purge"
	// SecretPermissionsRecover ...
	SecretPermissionsRecover SecretPermissions = "recover"
	// SecretPermissionsRestore ...
	SecretPermissionsRestore SecretPermissions = "restore"
	// SecretPermissionsSet ...
	SecretPermissionsSet SecretPermissions = "set"
)

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// Premium ...
	Premium SkuName = "premium"
	// Standard ...
	Standard SkuName = "standard"
)

// AccessPolicyEntry an identity that have access to the key vault. All identities in the array must use the same
// tenant ID as the key vault's tenant ID.
type AccessPolicyEntry struct {
	// TenantID - The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault.
	TenantID *uuid.UUID `json:"tenantId,omitempty"`
	// ObjectID - The object ID of a user, service principal or security group in the Azure Active Directory tenant for the vault. The object ID must be unique for the list of access policies.
	ObjectID *string `json:"objectId,omitempty"`
	// ApplicationID -  Application ID of the client making request on behalf of a principal
	ApplicationID *uuid.UUID `json:"applicationId,omitempty"`
	// Permissions - Permissions the identity has for keys, secrets and certificates.
	Permissions *Permissions `json:"permissions,omitempty"`
}

// Permissions permissions the identity has for keys, secrets and certificates.
type Permissions struct {
	// Keys - Permissions to keys
	Keys *[]KeyPermissions `json:"keys,omitempty"`
	// Secrets - Permissions to secrets
	Secrets *[]SecretPermissions `json:"secrets,omitempty"`
	// Certificates - Permissions to certificates
	Certificates *[]CertificatePermissions `json:"certificates,omitempty"`
}

// Resource key Vault resource
type Resource struct {
	// ID - The Azure Resource Manager resource ID for the key vault.
	ID *string `json:"id,omitempty"`
	// Name - The name of the key vault.
	Name *string `json:"name,omitempty"`
	// Type - The resource type of the key vault.
	Type *string `json:"type,omitempty"`
	// Location - The supported Azure location where the key vault should be created.
	Location *string `json:"location,omitempty"`
	// Tags - The tags that will be assigned to the key vault.
	Tags *map[string]*string `json:"tags,omitempty"`
}

// ResourceListResult list of vault resources.
type ResourceListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets the list of vault resources.
	Value *[]Resource `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of vault resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResourceListResultIterator provides access to a complete listing of Resource values.
type ResourceListResultIterator struct {
	i    int
	page ResourceListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResourceListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResourceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResourceListResultIterator) Response() ResourceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResourceListResultIterator) Value() Resource {
	if !iter.page.NotDone() {
		return Resource{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (rlr ResourceListResult) IsEmpty() bool {
	return rlr.Value == nil || len(*rlr.Value) == 0
}

// resourceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rlr ResourceListResult) resourceListResultPreparer() (*http.Request, error) {
	if rlr.NextLink == nil || len(to.String(rlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rlr.NextLink)))
}

// ResourceListResultPage contains a page of Resource values.
type ResourceListResultPage struct {
	fn  func(ResourceListResult) (ResourceListResult, error)
	rlr ResourceListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResourceListResultPage) Next() error {
	next, err := page.fn(page.rlr)
	if err != nil {
		return err
	}
	page.rlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResourceListResultPage) NotDone() bool {
	return !page.rlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResourceListResultPage) Response() ResourceListResult {
	return page.rlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResourceListResultPage) Values() []Resource {
	if page.rlr.IsEmpty() {
		return nil
	}
	return *page.rlr.Value
}

// Sku SKU details
type Sku struct {
	// Family - SKU family name
	Family *string `json:"family,omitempty"`
	// Name - SKU name to specify whether the key vault is a standard vault or a premium vault. Possible values include: 'Standard', 'Premium'
	Name SkuName `json:"name,omitempty"`
}

// Vault resource information with extended details.
type Vault struct {
	autorest.Response `json:"-"`
	// ID - The Azure Resource Manager resource ID for the key vault.
	ID *string `json:"id,omitempty"`
	// Name - The name of the key vault.
	Name *string `json:"name,omitempty"`
	// Type - The resource type of the key vault.
	Type *string `json:"type,omitempty"`
	// Location - The supported Azure location where the key vault should be created.
	Location *string `json:"location,omitempty"`
	// Tags - The tags that will be assigned to the key vault.
	Tags *map[string]*string `json:"tags,omitempty"`
	// Properties - Properties of the vault
	Properties *VaultProperties `json:"properties,omitempty"`
}

// VaultCreateOrUpdateParameters parameters for creating or updating a vault
type VaultCreateOrUpdateParameters struct {
	// Location - The supported Azure location where the key vault should be created.
	Location *string `json:"location,omitempty"`
	// Tags - The tags that will be assigned to the key vault.
	Tags *map[string]*string `json:"tags,omitempty"`
	// Properties - Properties of the vault
	Properties *VaultProperties `json:"properties,omitempty"`
}

// VaultListResult list of vaults
type VaultListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets the list of vaults.
	Value *[]Vault `json:"value,omitempty"`
	// NextLink - Gets or sets the URL to get the next set of vaults.
	NextLink *string `json:"nextLink,omitempty"`
}

// VaultListResultIterator provides access to a complete listing of Vault values.
type VaultListResultIterator struct {
	i    int
	page VaultListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VaultListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VaultListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VaultListResultIterator) Response() VaultListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VaultListResultIterator) Value() Vault {
	if !iter.page.NotDone() {
		return Vault{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (vlr VaultListResult) IsEmpty() bool {
	return vlr.Value == nil || len(*vlr.Value) == 0
}

// vaultListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vlr VaultListResult) vaultListResultPreparer() (*http.Request, error) {
	if vlr.NextLink == nil || len(to.String(vlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vlr.NextLink)))
}

// VaultListResultPage contains a page of Vault values.
type VaultListResultPage struct {
	fn  func(VaultListResult) (VaultListResult, error)
	vlr VaultListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VaultListResultPage) Next() error {
	next, err := page.fn(page.vlr)
	if err != nil {
		return err
	}
	page.vlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VaultListResultPage) NotDone() bool {
	return !page.vlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VaultListResultPage) Response() VaultListResult {
	return page.vlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VaultListResultPage) Values() []Vault {
	if page.vlr.IsEmpty() {
		return nil
	}
	return *page.vlr.Value
}

// VaultProperties properties of the vault
type VaultProperties struct {
	// VaultURI - The URI of the vault for performing operations on keys and secrets.
	VaultURI *string `json:"vaultUri,omitempty"`
	// TenantID - The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault.
	TenantID *uuid.UUID `json:"tenantId,omitempty"`
	// Sku - SKU details
	Sku *Sku `json:"sku,omitempty"`
	// AccessPolicies - An array of 0 to 16 identities that have access to the key vault. All identities in the array must use the same tenant ID as the key vault's tenant ID.
	AccessPolicies *[]AccessPolicyEntry `json:"accessPolicies,omitempty"`
	// EnabledForDeployment - Property to specify whether Azure Virtual Machines are permitted to retrieve certificates stored as secrets from the key vault.
	EnabledForDeployment *bool `json:"enabledForDeployment,omitempty"`
	// EnabledForDiskEncryption - Property to specify whether Azure Disk Encryption is permitted to retrieve secrets from the vault and unwrap keys.
	EnabledForDiskEncryption *bool `json:"enabledForDiskEncryption,omitempty"`
	// EnabledForTemplateDeployment - Property to specify whether Azure Resource Manager is permitted to retrieve secrets from the key vault.
	EnabledForTemplateDeployment *bool `json:"enabledForTemplateDeployment,omitempty"`
	// EnableSoftDelete - Property to specify whether the 'soft delete' functionality is enabled for this key vault.
	EnableSoftDelete *bool `json:"enableSoftDelete,omitempty"`
}
