package devices

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"net/http"
)

// IotHubResourceClient is the use this API to manage the IoT hubs in your Azure subscription.
type IotHubResourceClient struct {
	BaseClient
}

// NewIotHubResourceClient creates an instance of the IotHubResourceClient client.
func NewIotHubResourceClient(subscriptionID string) IotHubResourceClient {
	return NewIotHubResourceClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewIotHubResourceClientWithBaseURI creates an instance of the IotHubResourceClient client.
func NewIotHubResourceClientWithBaseURI(baseURI string, subscriptionID string) IotHubResourceClient {
	return IotHubResourceClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CheckNameAvailability check if an IoT hub name is available.
//
// operationInputs is set the name parameter in the OperationInputs structure to the name of the IoT hub to check.
func (client IotHubResourceClient) CheckNameAvailability(ctx context.Context, operationInputs OperationInputs) (result IotHubNameAvailabilityInfo, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: operationInputs,
			Constraints: []validation.Constraint{{Target: "operationInputs.Name", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "devices.IotHubResourceClient", "CheckNameAvailability")
	}

	req, err := client.CheckNameAvailabilityPreparer(ctx, operationInputs)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "CheckNameAvailability", nil, "Failure preparing request")
		return
	}

	resp, err := client.CheckNameAvailabilitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "CheckNameAvailability", resp, "Failure sending request")
		return
	}

	result, err = client.CheckNameAvailabilityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "CheckNameAvailability", resp, "Failure responding to request")
	}

	return
}

// CheckNameAvailabilityPreparer prepares the CheckNameAvailability request.
func (client IotHubResourceClient) CheckNameAvailabilityPreparer(ctx context.Context, operationInputs OperationInputs) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-07-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Devices/checkNameAvailability", pathParameters),
		autorest.WithJSON(operationInputs),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CheckNameAvailabilitySender sends the CheckNameAvailability request. The method will close the
// http.Response Body if it receives an error.
func (client IotHubResourceClient) CheckNameAvailabilitySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// CheckNameAvailabilityResponder handles the response to the CheckNameAvailability request. The method always
// closes the http.Response Body.
func (client IotHubResourceClient) CheckNameAvailabilityResponder(resp *http.Response) (result IotHubNameAvailabilityInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateEventHubConsumerGroup add a consumer group to an Event Hub-compatible endpoint in an IoT hub.
//
// resourceGroupName is the name of the resource group that contains the IoT hub. resourceName is the name of the IoT
// hub. eventHubEndpointName is the name of the Event Hub-compatible endpoint in the IoT hub. name is the name of the
// consumer group to add.
func (client IotHubResourceClient) CreateEventHubConsumerGroup(ctx context.Context, resourceGroupName string, resourceName string, eventHubEndpointName string, name string) (result EventHubConsumerGroupInfo, err error) {
	req, err := client.CreateEventHubConsumerGroupPreparer(ctx, resourceGroupName, resourceName, eventHubEndpointName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "CreateEventHubConsumerGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateEventHubConsumerGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "CreateEventHubConsumerGroup", resp, "Failure sending request")
		return
	}

	result, err = client.CreateEventHubConsumerGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "CreateEventHubConsumerGroup", resp, "Failure responding to request")
	}

	return
}

// CreateEventHubConsumerGroupPreparer prepares the CreateEventHubConsumerGroup request.
func (client IotHubResourceClient) CreateEventHubConsumerGroupPreparer(ctx context.Context, resourceGroupName string, resourceName string, eventHubEndpointName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"eventHubEndpointName": autorest.Encode("path", eventHubEndpointName),
		"name":                 autorest.Encode("path", name),
		"resourceGroupName":    autorest.Encode("path", resourceGroupName),
		"resourceName":         autorest.Encode("path", resourceName),
		"subscriptionId":       autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-07-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/eventHubEndpoints/{eventHubEndpointName}/ConsumerGroups/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateEventHubConsumerGroupSender sends the CreateEventHubConsumerGroup request. The method will close the
// http.Response Body if it receives an error.
func (client IotHubResourceClient) CreateEventHubConsumerGroupSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// CreateEventHubConsumerGroupResponder handles the response to the CreateEventHubConsumerGroup request. The method always
// closes the http.Response Body.
func (client IotHubResourceClient) CreateEventHubConsumerGroupResponder(resp *http.Response) (result EventHubConsumerGroupInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdate create or update the metadata of an Iot hub. The usual pattern to modify a property is to retrieve
// the IoT hub metadata and security metadata, and then combine them with the modified values in a new body to update
// the IoT hub.
//
// resourceGroupName is the name of the resource group that contains the IoT hub. resourceName is the name of the IoT
// hub. iotHubDescription is the IoT hub metadata and security metadata. ifMatch is eTag of the IoT Hub. Do not specify
// for creating a brand new IoT Hub. Required to update an existing IoT Hub.
func (client IotHubResourceClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, resourceName string, iotHubDescription IotHubDescription, ifMatch string) (result IotHubResourceCreateOrUpdateFuture, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: iotHubDescription,
			Constraints: []validation.Constraint{{Target: "iotHubDescription.Subscriptionid", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "iotHubDescription.Resourcegroup", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "iotHubDescription.Properties", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "iotHubDescription.Properties.Routing", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "iotHubDescription.Properties.Routing.FallbackRoute", Name: validation.Null, Rule: false,
							Chain: []validation.Constraint{{Target: "iotHubDescription.Properties.Routing.FallbackRoute.Source", Name: validation.Null, Rule: true, Chain: nil},
								{Target: "iotHubDescription.Properties.Routing.FallbackRoute.EndpointNames", Name: validation.Null, Rule: true,
									Chain: []validation.Constraint{{Target: "iotHubDescription.Properties.Routing.FallbackRoute.EndpointNames", Name: validation.MaxItems, Rule: 1, Chain: nil},
										{Target: "iotHubDescription.Properties.Routing.FallbackRoute.EndpointNames", Name: validation.MinItems, Rule: 1, Chain: nil},
									}},
								{Target: "iotHubDescription.Properties.Routing.FallbackRoute.IsEnabled", Name: validation.Null, Rule: true, Chain: nil},
							}},
						}},
						{Target: "iotHubDescription.Properties.CloudToDevice", Name: validation.Null, Rule: false,
							Chain: []validation.Constraint{{Target: "iotHubDescription.Properties.CloudToDevice.MaxDeliveryCount", Name: validation.Null, Rule: false,
								Chain: []validation.Constraint{{Target: "iotHubDescription.Properties.CloudToDevice.MaxDeliveryCount", Name: validation.InclusiveMaximum, Rule: 100, Chain: nil},
									{Target: "iotHubDescription.Properties.CloudToDevice.MaxDeliveryCount", Name: validation.InclusiveMinimum, Rule: 1, Chain: nil},
								}},
								{Target: "iotHubDescription.Properties.CloudToDevice.Feedback", Name: validation.Null, Rule: false,
									Chain: []validation.Constraint{{Target: "iotHubDescription.Properties.CloudToDevice.Feedback.MaxDeliveryCount", Name: validation.Null, Rule: false,
										Chain: []validation.Constraint{{Target: "iotHubDescription.Properties.CloudToDevice.Feedback.MaxDeliveryCount", Name: validation.InclusiveMaximum, Rule: 100, Chain: nil},
											{Target: "iotHubDescription.Properties.CloudToDevice.Feedback.MaxDeliveryCount", Name: validation.InclusiveMinimum, Rule: 1, Chain: nil},
										}},
									}},
							}},
					}},
				{Target: "iotHubDescription.Sku", Name: validation.Null, Rule: true,
					Chain: []validation.Constraint{{Target: "iotHubDescription.Sku.Capacity", Name: validation.Null, Rule: true, Chain: nil}}}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "devices.IotHubResourceClient", "CreateOrUpdate")
	}

	req, err := client.CreateOrUpdatePreparer(ctx, resourceGroupName, resourceName, iotHubDescription, ifMatch)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "CreateOrUpdate", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateOrUpdateSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "CreateOrUpdate", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client IotHubResourceClient) CreateOrUpdatePreparer(ctx context.Context, resourceGroupName string, resourceName string, iotHubDescription IotHubDescription, ifMatch string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"resourceName":      autorest.Encode("path", resourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-07-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}", pathParameters),
		autorest.WithJSON(iotHubDescription),
		autorest.WithQueryParameters(queryParameters))
	if len(ifMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Match", autorest.String(ifMatch)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client IotHubResourceClient) CreateOrUpdateSender(req *http.Request) (future IotHubResourceCreateOrUpdateFuture, err error) {
	sender := autorest.DecorateSender(client, azure.DoRetryWithRegistration(client.Client))
	future.Future = azure.NewFuture(req)
	future.req = req
	_, err = future.Done(sender)
	if err != nil {
		return
	}
	err = autorest.Respond(future.Response(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated))
	return
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client IotHubResourceClient) CreateOrUpdateResponder(resp *http.Response) (result IotHubDescription, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete delete an IoT hub.
//
// resourceGroupName is the name of the resource group that contains the IoT hub. resourceName is the name of the IoT
// hub.
func (client IotHubResourceClient) Delete(ctx context.Context, resourceGroupName string, resourceName string) (result IotHubResourceDeleteFuture, err error) {
	req, err := client.DeletePreparer(ctx, resourceGroupName, resourceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "Delete", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "Delete", result.Response(), "Failure sending request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client IotHubResourceClient) DeletePreparer(ctx context.Context, resourceGroupName string, resourceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"resourceName":      autorest.Encode("path", resourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-07-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client IotHubResourceClient) DeleteSender(req *http.Request) (future IotHubResourceDeleteFuture, err error) {
	sender := autorest.DecorateSender(client, azure.DoRetryWithRegistration(client.Client))
	future.Future = azure.NewFuture(req)
	future.req = req
	_, err = future.Done(sender)
	if err != nil {
		return
	}
	err = autorest.Respond(future.Response(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent, http.StatusNotFound))
	return
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client IotHubResourceClient) DeleteResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteEventHubConsumerGroup delete a consumer group from an Event Hub-compatible endpoint in an IoT hub.
//
// resourceGroupName is the name of the resource group that contains the IoT hub. resourceName is the name of the IoT
// hub. eventHubEndpointName is the name of the Event Hub-compatible endpoint in the IoT hub. name is the name of the
// consumer group to delete.
func (client IotHubResourceClient) DeleteEventHubConsumerGroup(ctx context.Context, resourceGroupName string, resourceName string, eventHubEndpointName string, name string) (result autorest.Response, err error) {
	req, err := client.DeleteEventHubConsumerGroupPreparer(ctx, resourceGroupName, resourceName, eventHubEndpointName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "DeleteEventHubConsumerGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteEventHubConsumerGroupSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "DeleteEventHubConsumerGroup", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteEventHubConsumerGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "DeleteEventHubConsumerGroup", resp, "Failure responding to request")
	}

	return
}

// DeleteEventHubConsumerGroupPreparer prepares the DeleteEventHubConsumerGroup request.
func (client IotHubResourceClient) DeleteEventHubConsumerGroupPreparer(ctx context.Context, resourceGroupName string, resourceName string, eventHubEndpointName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"eventHubEndpointName": autorest.Encode("path", eventHubEndpointName),
		"name":                 autorest.Encode("path", name),
		"resourceGroupName":    autorest.Encode("path", resourceGroupName),
		"resourceName":         autorest.Encode("path", resourceName),
		"subscriptionId":       autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-07-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/eventHubEndpoints/{eventHubEndpointName}/ConsumerGroups/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteEventHubConsumerGroupSender sends the DeleteEventHubConsumerGroup request. The method will close the
// http.Response Body if it receives an error.
func (client IotHubResourceClient) DeleteEventHubConsumerGroupSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteEventHubConsumerGroupResponder handles the response to the DeleteEventHubConsumerGroup request. The method always
// closes the http.Response Body.
func (client IotHubResourceClient) DeleteEventHubConsumerGroupResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// ExportDevices exports all the device identities in the IoT hub identity registry to an Azure Storage blob container.
// For more information, see:
// https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry#import-and-export-device-identities.
//
// resourceGroupName is the name of the resource group that contains the IoT hub. resourceName is the name of the IoT
// hub. exportDevicesParameters is the parameters that specify the export devices operation.
func (client IotHubResourceClient) ExportDevices(ctx context.Context, resourceGroupName string, resourceName string, exportDevicesParameters ExportDevicesRequest) (result JobResponse, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: exportDevicesParameters,
			Constraints: []validation.Constraint{{Target: "exportDevicesParameters.ExportBlobContainerURI", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "exportDevicesParameters.ExcludeKeys", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "devices.IotHubResourceClient", "ExportDevices")
	}

	req, err := client.ExportDevicesPreparer(ctx, resourceGroupName, resourceName, exportDevicesParameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "ExportDevices", nil, "Failure preparing request")
		return
	}

	resp, err := client.ExportDevicesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "ExportDevices", resp, "Failure sending request")
		return
	}

	result, err = client.ExportDevicesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "ExportDevices", resp, "Failure responding to request")
	}

	return
}

// ExportDevicesPreparer prepares the ExportDevices request.
func (client IotHubResourceClient) ExportDevicesPreparer(ctx context.Context, resourceGroupName string, resourceName string, exportDevicesParameters ExportDevicesRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"resourceName":      autorest.Encode("path", resourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-07-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/exportDevices", pathParameters),
		autorest.WithJSON(exportDevicesParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ExportDevicesSender sends the ExportDevices request. The method will close the
// http.Response Body if it receives an error.
func (client IotHubResourceClient) ExportDevicesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ExportDevicesResponder handles the response to the ExportDevices request. The method always
// closes the http.Response Body.
func (client IotHubResourceClient) ExportDevicesResponder(resp *http.Response) (result JobResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Get get the non-security related metadata of an IoT hub.
//
// resourceGroupName is the name of the resource group that contains the IoT hub. resourceName is the name of the IoT
// hub.
func (client IotHubResourceClient) Get(ctx context.Context, resourceGroupName string, resourceName string) (result IotHubDescription, err error) {
	req, err := client.GetPreparer(ctx, resourceGroupName, resourceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client IotHubResourceClient) GetPreparer(ctx context.Context, resourceGroupName string, resourceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"resourceName":      autorest.Encode("path", resourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-07-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client IotHubResourceClient) GetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client IotHubResourceClient) GetResponder(resp *http.Response) (result IotHubDescription, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetEventHubConsumerGroup get a consumer group from the Event Hub-compatible device-to-cloud endpoint for an IoT hub.
//
// resourceGroupName is the name of the resource group that contains the IoT hub. resourceName is the name of the IoT
// hub. eventHubEndpointName is the name of the Event Hub-compatible endpoint in the IoT hub. name is the name of the
// consumer group to retrieve.
func (client IotHubResourceClient) GetEventHubConsumerGroup(ctx context.Context, resourceGroupName string, resourceName string, eventHubEndpointName string, name string) (result EventHubConsumerGroupInfo, err error) {
	req, err := client.GetEventHubConsumerGroupPreparer(ctx, resourceGroupName, resourceName, eventHubEndpointName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "GetEventHubConsumerGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetEventHubConsumerGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "GetEventHubConsumerGroup", resp, "Failure sending request")
		return
	}

	result, err = client.GetEventHubConsumerGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "GetEventHubConsumerGroup", resp, "Failure responding to request")
	}

	return
}

// GetEventHubConsumerGroupPreparer prepares the GetEventHubConsumerGroup request.
func (client IotHubResourceClient) GetEventHubConsumerGroupPreparer(ctx context.Context, resourceGroupName string, resourceName string, eventHubEndpointName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"eventHubEndpointName": autorest.Encode("path", eventHubEndpointName),
		"name":                 autorest.Encode("path", name),
		"resourceGroupName":    autorest.Encode("path", resourceGroupName),
		"resourceName":         autorest.Encode("path", resourceName),
		"subscriptionId":       autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-07-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/eventHubEndpoints/{eventHubEndpointName}/ConsumerGroups/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetEventHubConsumerGroupSender sends the GetEventHubConsumerGroup request. The method will close the
// http.Response Body if it receives an error.
func (client IotHubResourceClient) GetEventHubConsumerGroupSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetEventHubConsumerGroupResponder handles the response to the GetEventHubConsumerGroup request. The method always
// closes the http.Response Body.
func (client IotHubResourceClient) GetEventHubConsumerGroupResponder(resp *http.Response) (result EventHubConsumerGroupInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetJob get the details of a job from an IoT hub. For more information, see:
// https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry.
//
// resourceGroupName is the name of the resource group that contains the IoT hub. resourceName is the name of the IoT
// hub. jobID is the job identifier.
func (client IotHubResourceClient) GetJob(ctx context.Context, resourceGroupName string, resourceName string, jobID string) (result JobResponse, err error) {
	req, err := client.GetJobPreparer(ctx, resourceGroupName, resourceName, jobID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "GetJob", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetJobSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "GetJob", resp, "Failure sending request")
		return
	}

	result, err = client.GetJobResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "GetJob", resp, "Failure responding to request")
	}

	return
}

// GetJobPreparer prepares the GetJob request.
func (client IotHubResourceClient) GetJobPreparer(ctx context.Context, resourceGroupName string, resourceName string, jobID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"jobId":             autorest.Encode("path", jobID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"resourceName":      autorest.Encode("path", resourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-07-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/jobs/{jobId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetJobSender sends the GetJob request. The method will close the
// http.Response Body if it receives an error.
func (client IotHubResourceClient) GetJobSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetJobResponder handles the response to the GetJob request. The method always
// closes the http.Response Body.
func (client IotHubResourceClient) GetJobResponder(resp *http.Response) (result JobResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetKeysForKeyName get a shared access policy by name from an IoT hub. For more information, see:
// https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-security.
//
// resourceGroupName is the name of the resource group that contains the IoT hub. resourceName is the name of the IoT
// hub. keyName is the name of the shared access policy.
func (client IotHubResourceClient) GetKeysForKeyName(ctx context.Context, resourceGroupName string, resourceName string, keyName string) (result SharedAccessSignatureAuthorizationRule, err error) {
	req, err := client.GetKeysForKeyNamePreparer(ctx, resourceGroupName, resourceName, keyName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "GetKeysForKeyName", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetKeysForKeyNameSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "GetKeysForKeyName", resp, "Failure sending request")
		return
	}

	result, err = client.GetKeysForKeyNameResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "GetKeysForKeyName", resp, "Failure responding to request")
	}

	return
}

// GetKeysForKeyNamePreparer prepares the GetKeysForKeyName request.
func (client IotHubResourceClient) GetKeysForKeyNamePreparer(ctx context.Context, resourceGroupName string, resourceName string, keyName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"keyName":           autorest.Encode("path", keyName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"resourceName":      autorest.Encode("path", resourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-07-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/IotHubKeys/{keyName}/listkeys", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetKeysForKeyNameSender sends the GetKeysForKeyName request. The method will close the
// http.Response Body if it receives an error.
func (client IotHubResourceClient) GetKeysForKeyNameSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetKeysForKeyNameResponder handles the response to the GetKeysForKeyName request. The method always
// closes the http.Response Body.
func (client IotHubResourceClient) GetKeysForKeyNameResponder(resp *http.Response) (result SharedAccessSignatureAuthorizationRule, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetQuotaMetrics get the quota metrics for an IoT hub.
//
// resourceGroupName is the name of the resource group that contains the IoT hub. resourceName is the name of the IoT
// hub.
func (client IotHubResourceClient) GetQuotaMetrics(ctx context.Context, resourceGroupName string, resourceName string) (result IotHubQuotaMetricInfoListResultPage, err error) {
	result.fn = client.getQuotaMetricsNextResults
	req, err := client.GetQuotaMetricsPreparer(ctx, resourceGroupName, resourceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "GetQuotaMetrics", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetQuotaMetricsSender(req)
	if err != nil {
		result.ihqmilr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "GetQuotaMetrics", resp, "Failure sending request")
		return
	}

	result.ihqmilr, err = client.GetQuotaMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "GetQuotaMetrics", resp, "Failure responding to request")
	}

	return
}

// GetQuotaMetricsPreparer prepares the GetQuotaMetrics request.
func (client IotHubResourceClient) GetQuotaMetricsPreparer(ctx context.Context, resourceGroupName string, resourceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"resourceName":      autorest.Encode("path", resourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-07-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/quotaMetrics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetQuotaMetricsSender sends the GetQuotaMetrics request. The method will close the
// http.Response Body if it receives an error.
func (client IotHubResourceClient) GetQuotaMetricsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetQuotaMetricsResponder handles the response to the GetQuotaMetrics request. The method always
// closes the http.Response Body.
func (client IotHubResourceClient) GetQuotaMetricsResponder(resp *http.Response) (result IotHubQuotaMetricInfoListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getQuotaMetricsNextResults retrieves the next set of results, if any.
func (client IotHubResourceClient) getQuotaMetricsNextResults(lastResults IotHubQuotaMetricInfoListResult) (result IotHubQuotaMetricInfoListResult, err error) {
	req, err := lastResults.iotHubQuotaMetricInfoListResultPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "getQuotaMetricsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetQuotaMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "getQuotaMetricsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetQuotaMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "getQuotaMetricsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetQuotaMetricsComplete enumerates all values, automatically crossing page boundaries as required.
func (client IotHubResourceClient) GetQuotaMetricsComplete(ctx context.Context, resourceGroupName string, resourceName string) (result IotHubQuotaMetricInfoListResultIterator, err error) {
	result.page, err = client.GetQuotaMetrics(ctx, resourceGroupName, resourceName)
	return
}

// GetStats get the statistics from an IoT hub.
//
// resourceGroupName is the name of the resource group that contains the IoT hub. resourceName is the name of the IoT
// hub.
func (client IotHubResourceClient) GetStats(ctx context.Context, resourceGroupName string, resourceName string) (result RegistryStatistics, err error) {
	req, err := client.GetStatsPreparer(ctx, resourceGroupName, resourceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "GetStats", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetStatsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "GetStats", resp, "Failure sending request")
		return
	}

	result, err = client.GetStatsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "GetStats", resp, "Failure responding to request")
	}

	return
}

// GetStatsPreparer prepares the GetStats request.
func (client IotHubResourceClient) GetStatsPreparer(ctx context.Context, resourceGroupName string, resourceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"resourceName":      autorest.Encode("path", resourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-07-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/IotHubStats", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetStatsSender sends the GetStats request. The method will close the
// http.Response Body if it receives an error.
func (client IotHubResourceClient) GetStatsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetStatsResponder handles the response to the GetStats request. The method always
// closes the http.Response Body.
func (client IotHubResourceClient) GetStatsResponder(resp *http.Response) (result RegistryStatistics, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetValidSkus get the list of valid SKUs for an IoT hub.
//
// resourceGroupName is the name of the resource group that contains the IoT hub. resourceName is the name of the IoT
// hub.
func (client IotHubResourceClient) GetValidSkus(ctx context.Context, resourceGroupName string, resourceName string) (result IotHubSkuDescriptionListResultPage, err error) {
	result.fn = client.getValidSkusNextResults
	req, err := client.GetValidSkusPreparer(ctx, resourceGroupName, resourceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "GetValidSkus", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetValidSkusSender(req)
	if err != nil {
		result.ihsdlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "GetValidSkus", resp, "Failure sending request")
		return
	}

	result.ihsdlr, err = client.GetValidSkusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "GetValidSkus", resp, "Failure responding to request")
	}

	return
}

// GetValidSkusPreparer prepares the GetValidSkus request.
func (client IotHubResourceClient) GetValidSkusPreparer(ctx context.Context, resourceGroupName string, resourceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"resourceName":      autorest.Encode("path", resourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-07-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/skus", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetValidSkusSender sends the GetValidSkus request. The method will close the
// http.Response Body if it receives an error.
func (client IotHubResourceClient) GetValidSkusSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetValidSkusResponder handles the response to the GetValidSkus request. The method always
// closes the http.Response Body.
func (client IotHubResourceClient) GetValidSkusResponder(resp *http.Response) (result IotHubSkuDescriptionListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getValidSkusNextResults retrieves the next set of results, if any.
func (client IotHubResourceClient) getValidSkusNextResults(lastResults IotHubSkuDescriptionListResult) (result IotHubSkuDescriptionListResult, err error) {
	req, err := lastResults.iotHubSkuDescriptionListResultPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "getValidSkusNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetValidSkusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "getValidSkusNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetValidSkusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "getValidSkusNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetValidSkusComplete enumerates all values, automatically crossing page boundaries as required.
func (client IotHubResourceClient) GetValidSkusComplete(ctx context.Context, resourceGroupName string, resourceName string) (result IotHubSkuDescriptionListResultIterator, err error) {
	result.page, err = client.GetValidSkus(ctx, resourceGroupName, resourceName)
	return
}

// ImportDevices import, update, or delete device identities in the IoT hub identity registry from a blob. For more
// information, see:
// https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry#import-and-export-device-identities.
//
// resourceGroupName is the name of the resource group that contains the IoT hub. resourceName is the name of the IoT
// hub. importDevicesParameters is the parameters that specify the import devices operation.
func (client IotHubResourceClient) ImportDevices(ctx context.Context, resourceGroupName string, resourceName string, importDevicesParameters ImportDevicesRequest) (result JobResponse, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: importDevicesParameters,
			Constraints: []validation.Constraint{{Target: "importDevicesParameters.InputBlobContainerURI", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "importDevicesParameters.OutputBlobContainerURI", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "devices.IotHubResourceClient", "ImportDevices")
	}

	req, err := client.ImportDevicesPreparer(ctx, resourceGroupName, resourceName, importDevicesParameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "ImportDevices", nil, "Failure preparing request")
		return
	}

	resp, err := client.ImportDevicesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "ImportDevices", resp, "Failure sending request")
		return
	}

	result, err = client.ImportDevicesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "ImportDevices", resp, "Failure responding to request")
	}

	return
}

// ImportDevicesPreparer prepares the ImportDevices request.
func (client IotHubResourceClient) ImportDevicesPreparer(ctx context.Context, resourceGroupName string, resourceName string, importDevicesParameters ImportDevicesRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"resourceName":      autorest.Encode("path", resourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-07-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/importDevices", pathParameters),
		autorest.WithJSON(importDevicesParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ImportDevicesSender sends the ImportDevices request. The method will close the
// http.Response Body if it receives an error.
func (client IotHubResourceClient) ImportDevicesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ImportDevicesResponder handles the response to the ImportDevices request. The method always
// closes the http.Response Body.
func (client IotHubResourceClient) ImportDevicesResponder(resp *http.Response) (result JobResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByResourceGroup get all the IoT hubs in a resource group.
//
// resourceGroupName is the name of the resource group that contains the IoT hub.
func (client IotHubResourceClient) ListByResourceGroup(ctx context.Context, resourceGroupName string) (result IotHubDescriptionListResultPage, err error) {
	result.fn = client.listByResourceGroupNextResults
	req, err := client.ListByResourceGroupPreparer(ctx, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "ListByResourceGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.ihdlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "ListByResourceGroup", resp, "Failure sending request")
		return
	}

	result.ihdlr, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "ListByResourceGroup", resp, "Failure responding to request")
	}

	return
}

// ListByResourceGroupPreparer prepares the ListByResourceGroup request.
func (client IotHubResourceClient) ListByResourceGroupPreparer(ctx context.Context, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-07-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByResourceGroupSender sends the ListByResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client IotHubResourceClient) ListByResourceGroupSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListByResourceGroupResponder handles the response to the ListByResourceGroup request. The method always
// closes the http.Response Body.
func (client IotHubResourceClient) ListByResourceGroupResponder(resp *http.Response) (result IotHubDescriptionListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByResourceGroupNextResults retrieves the next set of results, if any.
func (client IotHubResourceClient) listByResourceGroupNextResults(lastResults IotHubDescriptionListResult) (result IotHubDescriptionListResult, err error) {
	req, err := lastResults.iotHubDescriptionListResultPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "listByResourceGroupNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "listByResourceGroupNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "listByResourceGroupNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByResourceGroupComplete enumerates all values, automatically crossing page boundaries as required.
func (client IotHubResourceClient) ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result IotHubDescriptionListResultIterator, err error) {
	result.page, err = client.ListByResourceGroup(ctx, resourceGroupName)
	return
}

// ListBySubscription get all the IoT hubs in a subscription.
func (client IotHubResourceClient) ListBySubscription(ctx context.Context) (result IotHubDescriptionListResultPage, err error) {
	result.fn = client.listBySubscriptionNextResults
	req, err := client.ListBySubscriptionPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "ListBySubscription", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListBySubscriptionSender(req)
	if err != nil {
		result.ihdlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "ListBySubscription", resp, "Failure sending request")
		return
	}

	result.ihdlr, err = client.ListBySubscriptionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "ListBySubscription", resp, "Failure responding to request")
	}

	return
}

// ListBySubscriptionPreparer prepares the ListBySubscription request.
func (client IotHubResourceClient) ListBySubscriptionPreparer(ctx context.Context) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-07-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Devices/IotHubs", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListBySubscriptionSender sends the ListBySubscription request. The method will close the
// http.Response Body if it receives an error.
func (client IotHubResourceClient) ListBySubscriptionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListBySubscriptionResponder handles the response to the ListBySubscription request. The method always
// closes the http.Response Body.
func (client IotHubResourceClient) ListBySubscriptionResponder(resp *http.Response) (result IotHubDescriptionListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listBySubscriptionNextResults retrieves the next set of results, if any.
func (client IotHubResourceClient) listBySubscriptionNextResults(lastResults IotHubDescriptionListResult) (result IotHubDescriptionListResult, err error) {
	req, err := lastResults.iotHubDescriptionListResultPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "listBySubscriptionNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListBySubscriptionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "listBySubscriptionNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListBySubscriptionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "listBySubscriptionNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListBySubscriptionComplete enumerates all values, automatically crossing page boundaries as required.
func (client IotHubResourceClient) ListBySubscriptionComplete(ctx context.Context) (result IotHubDescriptionListResultIterator, err error) {
	result.page, err = client.ListBySubscription(ctx)
	return
}

// ListEventHubConsumerGroups get a list of the consumer groups in the Event Hub-compatible device-to-cloud endpoint in
// an IoT hub.
//
// resourceGroupName is the name of the resource group that contains the IoT hub. resourceName is the name of the IoT
// hub. eventHubEndpointName is the name of the Event Hub-compatible endpoint.
func (client IotHubResourceClient) ListEventHubConsumerGroups(ctx context.Context, resourceGroupName string, resourceName string, eventHubEndpointName string) (result EventHubConsumerGroupsListResultPage, err error) {
	result.fn = client.listEventHubConsumerGroupsNextResults
	req, err := client.ListEventHubConsumerGroupsPreparer(ctx, resourceGroupName, resourceName, eventHubEndpointName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "ListEventHubConsumerGroups", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListEventHubConsumerGroupsSender(req)
	if err != nil {
		result.ehcglr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "ListEventHubConsumerGroups", resp, "Failure sending request")
		return
	}

	result.ehcglr, err = client.ListEventHubConsumerGroupsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "ListEventHubConsumerGroups", resp, "Failure responding to request")
	}

	return
}

// ListEventHubConsumerGroupsPreparer prepares the ListEventHubConsumerGroups request.
func (client IotHubResourceClient) ListEventHubConsumerGroupsPreparer(ctx context.Context, resourceGroupName string, resourceName string, eventHubEndpointName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"eventHubEndpointName": autorest.Encode("path", eventHubEndpointName),
		"resourceGroupName":    autorest.Encode("path", resourceGroupName),
		"resourceName":         autorest.Encode("path", resourceName),
		"subscriptionId":       autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-07-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/eventHubEndpoints/{eventHubEndpointName}/ConsumerGroups", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListEventHubConsumerGroupsSender sends the ListEventHubConsumerGroups request. The method will close the
// http.Response Body if it receives an error.
func (client IotHubResourceClient) ListEventHubConsumerGroupsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListEventHubConsumerGroupsResponder handles the response to the ListEventHubConsumerGroups request. The method always
// closes the http.Response Body.
func (client IotHubResourceClient) ListEventHubConsumerGroupsResponder(resp *http.Response) (result EventHubConsumerGroupsListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listEventHubConsumerGroupsNextResults retrieves the next set of results, if any.
func (client IotHubResourceClient) listEventHubConsumerGroupsNextResults(lastResults EventHubConsumerGroupsListResult) (result EventHubConsumerGroupsListResult, err error) {
	req, err := lastResults.eventHubConsumerGroupsListResultPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "listEventHubConsumerGroupsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListEventHubConsumerGroupsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "listEventHubConsumerGroupsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListEventHubConsumerGroupsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "listEventHubConsumerGroupsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListEventHubConsumerGroupsComplete enumerates all values, automatically crossing page boundaries as required.
func (client IotHubResourceClient) ListEventHubConsumerGroupsComplete(ctx context.Context, resourceGroupName string, resourceName string, eventHubEndpointName string) (result EventHubConsumerGroupsListResultIterator, err error) {
	result.page, err = client.ListEventHubConsumerGroups(ctx, resourceGroupName, resourceName, eventHubEndpointName)
	return
}

// ListJobs get a list of all the jobs in an IoT hub. For more information, see:
// https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry.
//
// resourceGroupName is the name of the resource group that contains the IoT hub. resourceName is the name of the IoT
// hub.
func (client IotHubResourceClient) ListJobs(ctx context.Context, resourceGroupName string, resourceName string) (result JobResponseListResultPage, err error) {
	result.fn = client.listJobsNextResults
	req, err := client.ListJobsPreparer(ctx, resourceGroupName, resourceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "ListJobs", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListJobsSender(req)
	if err != nil {
		result.jrlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "ListJobs", resp, "Failure sending request")
		return
	}

	result.jrlr, err = client.ListJobsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "ListJobs", resp, "Failure responding to request")
	}

	return
}

// ListJobsPreparer prepares the ListJobs request.
func (client IotHubResourceClient) ListJobsPreparer(ctx context.Context, resourceGroupName string, resourceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"resourceName":      autorest.Encode("path", resourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-07-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/jobs", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListJobsSender sends the ListJobs request. The method will close the
// http.Response Body if it receives an error.
func (client IotHubResourceClient) ListJobsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListJobsResponder handles the response to the ListJobs request. The method always
// closes the http.Response Body.
func (client IotHubResourceClient) ListJobsResponder(resp *http.Response) (result JobResponseListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listJobsNextResults retrieves the next set of results, if any.
func (client IotHubResourceClient) listJobsNextResults(lastResults JobResponseListResult) (result JobResponseListResult, err error) {
	req, err := lastResults.jobResponseListResultPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "listJobsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListJobsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "listJobsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListJobsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "listJobsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListJobsComplete enumerates all values, automatically crossing page boundaries as required.
func (client IotHubResourceClient) ListJobsComplete(ctx context.Context, resourceGroupName string, resourceName string) (result JobResponseListResultIterator, err error) {
	result.page, err = client.ListJobs(ctx, resourceGroupName, resourceName)
	return
}

// ListKeys get the security metadata for an IoT hub. For more information, see:
// https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-security.
//
// resourceGroupName is the name of the resource group that contains the IoT hub. resourceName is the name of the IoT
// hub.
func (client IotHubResourceClient) ListKeys(ctx context.Context, resourceGroupName string, resourceName string) (result SharedAccessSignatureAuthorizationRuleListResultPage, err error) {
	result.fn = client.listKeysNextResults
	req, err := client.ListKeysPreparer(ctx, resourceGroupName, resourceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "ListKeys", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListKeysSender(req)
	if err != nil {
		result.sasarlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "ListKeys", resp, "Failure sending request")
		return
	}

	result.sasarlr, err = client.ListKeysResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "ListKeys", resp, "Failure responding to request")
	}

	return
}

// ListKeysPreparer prepares the ListKeys request.
func (client IotHubResourceClient) ListKeysPreparer(ctx context.Context, resourceGroupName string, resourceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"resourceName":      autorest.Encode("path", resourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-07-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/listkeys", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListKeysSender sends the ListKeys request. The method will close the
// http.Response Body if it receives an error.
func (client IotHubResourceClient) ListKeysSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListKeysResponder handles the response to the ListKeys request. The method always
// closes the http.Response Body.
func (client IotHubResourceClient) ListKeysResponder(resp *http.Response) (result SharedAccessSignatureAuthorizationRuleListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listKeysNextResults retrieves the next set of results, if any.
func (client IotHubResourceClient) listKeysNextResults(lastResults SharedAccessSignatureAuthorizationRuleListResult) (result SharedAccessSignatureAuthorizationRuleListResult, err error) {
	req, err := lastResults.sharedAccessSignatureAuthorizationRuleListResultPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "listKeysNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListKeysSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "listKeysNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListKeysResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceClient", "listKeysNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListKeysComplete enumerates all values, automatically crossing page boundaries as required.
func (client IotHubResourceClient) ListKeysComplete(ctx context.Context, resourceGroupName string, resourceName string) (result SharedAccessSignatureAuthorizationRuleListResultIterator, err error) {
	result.page, err = client.ListKeys(ctx, resourceGroupName, resourceName)
	return
}
