package eventgrid

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest/date"
)

// Event properties of an event published to an Event Grid topic.
type Event struct {
	// ID - An unique identifier for the event.
	ID *string `json:"id,omitempty"`
	// Topic - The resource path of the event source.
	Topic *string `json:"topic,omitempty"`
	// Subject - A resource path relative to the topic path.
	Subject *string `json:"subject,omitempty"`
	// Data - Event data specific to the event type.
	Data *map[string]interface{} `json:"data,omitempty"`
	// EventType - The type of the event that occurred.
	EventType *string `json:"eventType,omitempty"`
	// EventTime - The time (in UTC) the event was generated.
	EventTime *date.Time `json:"eventTime,omitempty"`
	// MetadataVersion - The schema version of the event metadata.
	MetadataVersion *string `json:"metadataVersion,omitempty"`
	// DataVersion - The schema version of the data object.
	DataVersion *string `json:"dataVersion,omitempty"`
}
