package account

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/satori/go.uuid"
	"net/http"
)

// DataLakeStoreAccountState enumerates the values for data lake store account state.
type DataLakeStoreAccountState string

const (
	// Active ...
	Active DataLakeStoreAccountState = "Active"
	// Suspended ...
	Suspended DataLakeStoreAccountState = "Suspended"
)

// DataLakeStoreAccountStatus enumerates the values for data lake store account status.
type DataLakeStoreAccountStatus string

const (
	// Canceled ...
	Canceled DataLakeStoreAccountStatus = "Canceled"
	// Creating ...
	Creating DataLakeStoreAccountStatus = "Creating"
	// Deleted ...
	Deleted DataLakeStoreAccountStatus = "Deleted"
	// Deleting ...
	Deleting DataLakeStoreAccountStatus = "Deleting"
	// Failed ...
	Failed DataLakeStoreAccountStatus = "Failed"
	// Patching ...
	Patching DataLakeStoreAccountStatus = "Patching"
	// Resuming ...
	Resuming DataLakeStoreAccountStatus = "Resuming"
	// Running ...
	Running DataLakeStoreAccountStatus = "Running"
	// Succeeded ...
	Succeeded DataLakeStoreAccountStatus = "Succeeded"
	// Suspending ...
	Suspending DataLakeStoreAccountStatus = "Suspending"
	// Undeleting ...
	Undeleting DataLakeStoreAccountStatus = "Undeleting"
)

// EncryptionConfigType enumerates the values for encryption config type.
type EncryptionConfigType string

const (
	// ServiceManaged ...
	ServiceManaged EncryptionConfigType = "ServiceManaged"
	// UserManaged ...
	UserManaged EncryptionConfigType = "UserManaged"
)

// EncryptionProvisioningState enumerates the values for encryption provisioning state.
type EncryptionProvisioningState string

const (
	// EncryptionProvisioningStateCreating ...
	EncryptionProvisioningStateCreating EncryptionProvisioningState = "Creating"
	// EncryptionProvisioningStateSucceeded ...
	EncryptionProvisioningStateSucceeded EncryptionProvisioningState = "Succeeded"
)

// EncryptionState enumerates the values for encryption state.
type EncryptionState string

const (
	// Disabled ...
	Disabled EncryptionState = "Disabled"
	// Enabled ...
	Enabled EncryptionState = "Enabled"
)

// FirewallAllowAzureIpsState enumerates the values for firewall allow azure ips state.
type FirewallAllowAzureIpsState string

const (
	// FirewallAllowAzureIpsStateDisabled ...
	FirewallAllowAzureIpsStateDisabled FirewallAllowAzureIpsState = "Disabled"
	// FirewallAllowAzureIpsStateEnabled ...
	FirewallAllowAzureIpsStateEnabled FirewallAllowAzureIpsState = "Enabled"
)

// FirewallState enumerates the values for firewall state.
type FirewallState string

const (
	// FirewallStateDisabled ...
	FirewallStateDisabled FirewallState = "Disabled"
	// FirewallStateEnabled ...
	FirewallStateEnabled FirewallState = "Enabled"
)

// OperationOrigin enumerates the values for operation origin.
type OperationOrigin string

const (
	// System ...
	System OperationOrigin = "system"
	// User ...
	User OperationOrigin = "user"
	// Usersystem ...
	Usersystem OperationOrigin = "user,system"
)

// SubscriptionState enumerates the values for subscription state.
type SubscriptionState string

const (
	// SubscriptionStateDeleted ...
	SubscriptionStateDeleted SubscriptionState = "Deleted"
	// SubscriptionStateRegistered ...
	SubscriptionStateRegistered SubscriptionState = "Registered"
	// SubscriptionStateSuspended ...
	SubscriptionStateSuspended SubscriptionState = "Suspended"
	// SubscriptionStateUnregistered ...
	SubscriptionStateUnregistered SubscriptionState = "Unregistered"
	// SubscriptionStateWarned ...
	SubscriptionStateWarned SubscriptionState = "Warned"
)

// TierType enumerates the values for tier type.
type TierType string

const (
	// Commitment100TB ...
	Commitment100TB TierType = "Commitment_100TB"
	// Commitment10TB ...
	Commitment10TB TierType = "Commitment_10TB"
	// Commitment1PB ...
	Commitment1PB TierType = "Commitment_1PB"
	// Commitment1TB ...
	Commitment1TB TierType = "Commitment_1TB"
	// Commitment500TB ...
	Commitment500TB TierType = "Commitment_500TB"
	// Commitment5PB ...
	Commitment5PB TierType = "Commitment_5PB"
	// Consumption ...
	Consumption TierType = "Consumption"
)

// TrustedIDProviderState enumerates the values for trusted id provider state.
type TrustedIDProviderState string

const (
	// TrustedIDProviderStateDisabled ...
	TrustedIDProviderStateDisabled TrustedIDProviderState = "Disabled"
	// TrustedIDProviderStateEnabled ...
	TrustedIDProviderStateEnabled TrustedIDProviderState = "Enabled"
)

// AccountCreateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type AccountCreateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future AccountCreateFuture) Result(client Client) (dlsa DataLakeStoreAccount, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		return
	}
	if !done {
		return dlsa, autorest.NewError("account.AccountCreateFuture", "Result", "asynchronous operation has not completed")
	}
	if future.PollingMethod() == azure.PollingLocation {
		dlsa, err = client.CreateResponder(future.Response())
		return
	}
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, autorest.ChangeToGet(future.req),
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return
	}
	dlsa, err = client.CreateResponder(resp)
	return
}

// AccountDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type AccountDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future AccountDeleteFuture) Result(client Client) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		return
	}
	if !done {
		return ar, autorest.NewError("account.AccountDeleteFuture", "Result", "asynchronous operation has not completed")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		return
	}
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, autorest.ChangeToGet(future.req),
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return
	}
	ar, err = client.DeleteResponder(resp)
	return
}

// AccountUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type AccountUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future AccountUpdateFuture) Result(client Client) (dlsa DataLakeStoreAccount, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		return
	}
	if !done {
		return dlsa, autorest.NewError("account.AccountUpdateFuture", "Result", "asynchronous operation has not completed")
	}
	if future.PollingMethod() == azure.PollingLocation {
		dlsa, err = client.UpdateResponder(future.Response())
		return
	}
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, autorest.ChangeToGet(future.req),
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return
	}
	dlsa, err = client.UpdateResponder(resp)
	return
}

// CapabilityInformation subscription-level properties and limits for Data Lake Store
type CapabilityInformation struct {
	autorest.Response `json:"-"`
	// SubscriptionID - the subscription credentials that uniquely identifies the subscription.
	SubscriptionID *uuid.UUID `json:"subscriptionId,omitempty"`
	// State - the subscription state. Possible values include: 'SubscriptionStateRegistered', 'SubscriptionStateSuspended', 'SubscriptionStateDeleted', 'SubscriptionStateUnregistered', 'SubscriptionStateWarned'
	State SubscriptionState `json:"state,omitempty"`
	// MaxAccountCount - the maximum supported number of accounts under this subscription.
	MaxAccountCount *int32 `json:"maxAccountCount,omitempty"`
	// AccountCount - the current number of accounts under this subscription.
	AccountCount *int32 `json:"accountCount,omitempty"`
	// MigrationState - the Boolean value of true or false to indicate the maintenance state.
	MigrationState *bool `json:"migrationState,omitempty"`
}

// CheckNameAvailabilityParameters data Lake Store account name availability check parameters
type CheckNameAvailabilityParameters struct {
	// Name - the Data Lake Store name to check availability for.
	Name *string `json:"name,omitempty"`
	// Type - the Resource type. Note: This should not be set by the user, as the constant value is Microsoft.DataLakeStore/accounts
	Type *string `json:"type,omitempty"`
}

// DataLakeStoreAccount data Lake Store account information
type DataLakeStoreAccount struct {
	autorest.Response `json:"-"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags *map[string]*string `json:"tags,omitempty"`
	// Identity - The Key Vault encryption identity, if any.
	Identity *EncryptionIdentity `json:"identity,omitempty"`
	// DataLakeStoreAccountProperties - the Data Lake Store account properties.
	*DataLakeStoreAccountProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for DataLakeStoreAccount struct.
func (dlsa *DataLakeStoreAccount) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["identity"]
	if v != nil {
		var identity EncryptionIdentity
		err = json.Unmarshal(*m["identity"], &identity)
		if err != nil {
			return err
		}
		dlsa.Identity = &identity
	}

	v = m["properties"]
	if v != nil {
		var properties DataLakeStoreAccountProperties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		dlsa.DataLakeStoreAccountProperties = &properties
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		dlsa.ID = &ID
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		dlsa.Name = &name
	}

	v = m["type"]
	if v != nil {
		var typeVar string
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		dlsa.Type = &typeVar
	}

	v = m["location"]
	if v != nil {
		var location string
		err = json.Unmarshal(*m["location"], &location)
		if err != nil {
			return err
		}
		dlsa.Location = &location
	}

	v = m["tags"]
	if v != nil {
		var tags map[string]*string
		err = json.Unmarshal(*m["tags"], &tags)
		if err != nil {
			return err
		}
		dlsa.Tags = &tags
	}

	return nil
}

// DataLakeStoreAccountBasic basic Data Lake Store account information, returned on list calls.
type DataLakeStoreAccountBasic struct {
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags *map[string]*string `json:"tags,omitempty"`
	// DataLakeStoreAccountPropertiesBasic - the basic Data Lake Store account properties.
	*DataLakeStoreAccountPropertiesBasic `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for DataLakeStoreAccountBasic struct.
func (dlsab *DataLakeStoreAccountBasic) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		var properties DataLakeStoreAccountPropertiesBasic
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		dlsab.DataLakeStoreAccountPropertiesBasic = &properties
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		dlsab.ID = &ID
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		dlsab.Name = &name
	}

	v = m["type"]
	if v != nil {
		var typeVar string
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		dlsab.Type = &typeVar
	}

	v = m["location"]
	if v != nil {
		var location string
		err = json.Unmarshal(*m["location"], &location)
		if err != nil {
			return err
		}
		dlsab.Location = &location
	}

	v = m["tags"]
	if v != nil {
		var tags map[string]*string
		err = json.Unmarshal(*m["tags"], &tags)
		if err != nil {
			return err
		}
		dlsab.Tags = &tags
	}

	return nil
}

// DataLakeStoreAccountListResult data Lake Store account list information response.
type DataLakeStoreAccountListResult struct {
	autorest.Response `json:"-"`
	// Value - the results of the list operation
	Value *[]DataLakeStoreAccountBasic `json:"value,omitempty"`
	// NextLink - the link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// DataLakeStoreAccountListResultIterator provides access to a complete listing of DataLakeStoreAccountBasic values.
type DataLakeStoreAccountListResultIterator struct {
	i    int
	page DataLakeStoreAccountListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DataLakeStoreAccountListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DataLakeStoreAccountListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DataLakeStoreAccountListResultIterator) Response() DataLakeStoreAccountListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DataLakeStoreAccountListResultIterator) Value() DataLakeStoreAccountBasic {
	if !iter.page.NotDone() {
		return DataLakeStoreAccountBasic{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (dlsalr DataLakeStoreAccountListResult) IsEmpty() bool {
	return dlsalr.Value == nil || len(*dlsalr.Value) == 0
}

// dataLakeStoreAccountListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dlsalr DataLakeStoreAccountListResult) dataLakeStoreAccountListResultPreparer() (*http.Request, error) {
	if dlsalr.NextLink == nil || len(to.String(dlsalr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dlsalr.NextLink)))
}

// DataLakeStoreAccountListResultPage contains a page of DataLakeStoreAccountBasic values.
type DataLakeStoreAccountListResultPage struct {
	fn     func(DataLakeStoreAccountListResult) (DataLakeStoreAccountListResult, error)
	dlsalr DataLakeStoreAccountListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DataLakeStoreAccountListResultPage) Next() error {
	next, err := page.fn(page.dlsalr)
	if err != nil {
		return err
	}
	page.dlsalr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DataLakeStoreAccountListResultPage) NotDone() bool {
	return !page.dlsalr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DataLakeStoreAccountListResultPage) Response() DataLakeStoreAccountListResult {
	return page.dlsalr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DataLakeStoreAccountListResultPage) Values() []DataLakeStoreAccountBasic {
	if page.dlsalr.IsEmpty() {
		return nil
	}
	return *page.dlsalr.Value
}

// DataLakeStoreAccountProperties data Lake Store account properties information
type DataLakeStoreAccountProperties struct {
	// ProvisioningState - the provisioning status of the Data Lake Store account. Possible values include: 'Failed', 'Creating', 'Running', 'Succeeded', 'Patching', 'Suspending', 'Resuming', 'Deleting', 'Deleted', 'Undeleting', 'Canceled'
	ProvisioningState DataLakeStoreAccountStatus `json:"provisioningState,omitempty"`
	// State - the state of the Data Lake Store account. Possible values include: 'Active', 'Suspended'
	State DataLakeStoreAccountState `json:"state,omitempty"`
	// CreationTime - the account creation time.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// LastModifiedTime - the account last modified time.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// Endpoint - the full CName endpoint for this account.
	Endpoint *string `json:"endpoint,omitempty"`
	// AccountID - The unique identifier associated with this Data Lake Store account.
	AccountID *uuid.UUID `json:"accountId,omitempty"`
	// EncryptionState - The current state of encryption for this Data Lake store account. Possible values include: 'Enabled', 'Disabled'
	EncryptionState EncryptionState `json:"encryptionState,omitempty"`
	// EncryptionProvisioningState - The current state of encryption provisioning for this Data Lake store account. Possible values include: 'EncryptionProvisioningStateCreating', 'EncryptionProvisioningStateSucceeded'
	EncryptionProvisioningState EncryptionProvisioningState `json:"encryptionProvisioningState,omitempty"`
	// EncryptionConfig - The Key Vault encryption configuration.
	EncryptionConfig *EncryptionConfig `json:"encryptionConfig,omitempty"`
	// FirewallState - The current state of the IP address firewall for this Data Lake store account. Possible values include: 'FirewallStateEnabled', 'FirewallStateDisabled'
	FirewallState FirewallState `json:"firewallState,omitempty"`
	// FirewallRules - The list of firewall rules associated with this Data Lake store account.
	FirewallRules *[]FirewallRule `json:"firewallRules,omitempty"`
	// TrustedIDProviderState - The current state of the trusted identity provider feature for this Data Lake store account. Possible values include: 'TrustedIDProviderStateEnabled', 'TrustedIDProviderStateDisabled'
	TrustedIDProviderState TrustedIDProviderState `json:"trustedIdProviderState,omitempty"`
	// TrustedIDProviders - The list of trusted identity providers associated with this Data Lake store account.
	TrustedIDProviders *[]TrustedIDProvider `json:"trustedIdProviders,omitempty"`
	// DefaultGroup - the default owner group for all new folders and files created in the Data Lake Store account.
	DefaultGroup *string `json:"defaultGroup,omitempty"`
	// NewTier - the commitment tier to use for next month. Possible values include: 'Consumption', 'Commitment1TB', 'Commitment10TB', 'Commitment100TB', 'Commitment500TB', 'Commitment1PB', 'Commitment5PB'
	NewTier TierType `json:"newTier,omitempty"`
	// CurrentTier - the commitment tier in use for the current month. Possible values include: 'Consumption', 'Commitment1TB', 'Commitment10TB', 'Commitment100TB', 'Commitment500TB', 'Commitment1PB', 'Commitment5PB'
	CurrentTier TierType `json:"currentTier,omitempty"`
	// FirewallAllowAzureIps - The current state of allowing or disallowing IPs originating within Azure through the firewall. If the firewall is disabled, this is not enforced. Possible values include: 'FirewallAllowAzureIpsStateEnabled', 'FirewallAllowAzureIpsStateDisabled'
	FirewallAllowAzureIps FirewallAllowAzureIpsState `json:"firewallAllowAzureIps,omitempty"`
}

// DataLakeStoreAccountPropertiesBasic the basic account specific properties that are associated with an underlying
// Data Lake Store account.
type DataLakeStoreAccountPropertiesBasic struct {
	// ProvisioningState - the provisioning status of the Data Lake Store account. Possible values include: 'Failed', 'Creating', 'Running', 'Succeeded', 'Patching', 'Suspending', 'Resuming', 'Deleting', 'Deleted', 'Undeleting', 'Canceled'
	ProvisioningState DataLakeStoreAccountStatus `json:"provisioningState,omitempty"`
	// State - the state of the Data Lake Store account. Possible values include: 'Active', 'Suspended'
	State DataLakeStoreAccountState `json:"state,omitempty"`
	// CreationTime - the account creation time.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// LastModifiedTime - the account last modified time.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// Endpoint - the full CName endpoint for this account.
	Endpoint *string `json:"endpoint,omitempty"`
	// AccountID - The unique identifier associated with this Data Lake Store account.
	AccountID *uuid.UUID `json:"accountId,omitempty"`
}

// DataLakeStoreAccountUpdateParameters data Lake Store account information to update
type DataLakeStoreAccountUpdateParameters struct {
	// Tags - Resource tags
	Tags *map[string]*string `json:"tags,omitempty"`
	// UpdateDataLakeStoreAccountProperties - the Data Lake Store account properties to update.
	*UpdateDataLakeStoreAccountProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for DataLakeStoreAccountUpdateParameters struct.
func (dlsaup *DataLakeStoreAccountUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["tags"]
	if v != nil {
		var tags map[string]*string
		err = json.Unmarshal(*m["tags"], &tags)
		if err != nil {
			return err
		}
		dlsaup.Tags = &tags
	}

	v = m["properties"]
	if v != nil {
		var properties UpdateDataLakeStoreAccountProperties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		dlsaup.UpdateDataLakeStoreAccountProperties = &properties
	}

	return nil
}

// DataLakeStoreFirewallRuleListResult data Lake Store firewall rule list information.
type DataLakeStoreFirewallRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - the results of the list operation
	Value *[]FirewallRule `json:"value,omitempty"`
	// NextLink - the link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// DataLakeStoreFirewallRuleListResultIterator provides access to a complete listing of FirewallRule values.
type DataLakeStoreFirewallRuleListResultIterator struct {
	i    int
	page DataLakeStoreFirewallRuleListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DataLakeStoreFirewallRuleListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DataLakeStoreFirewallRuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DataLakeStoreFirewallRuleListResultIterator) Response() DataLakeStoreFirewallRuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DataLakeStoreFirewallRuleListResultIterator) Value() FirewallRule {
	if !iter.page.NotDone() {
		return FirewallRule{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (dlsfrlr DataLakeStoreFirewallRuleListResult) IsEmpty() bool {
	return dlsfrlr.Value == nil || len(*dlsfrlr.Value) == 0
}

// dataLakeStoreFirewallRuleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dlsfrlr DataLakeStoreFirewallRuleListResult) dataLakeStoreFirewallRuleListResultPreparer() (*http.Request, error) {
	if dlsfrlr.NextLink == nil || len(to.String(dlsfrlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dlsfrlr.NextLink)))
}

// DataLakeStoreFirewallRuleListResultPage contains a page of FirewallRule values.
type DataLakeStoreFirewallRuleListResultPage struct {
	fn      func(DataLakeStoreFirewallRuleListResult) (DataLakeStoreFirewallRuleListResult, error)
	dlsfrlr DataLakeStoreFirewallRuleListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DataLakeStoreFirewallRuleListResultPage) Next() error {
	next, err := page.fn(page.dlsfrlr)
	if err != nil {
		return err
	}
	page.dlsfrlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DataLakeStoreFirewallRuleListResultPage) NotDone() bool {
	return !page.dlsfrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DataLakeStoreFirewallRuleListResultPage) Response() DataLakeStoreFirewallRuleListResult {
	return page.dlsfrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DataLakeStoreFirewallRuleListResultPage) Values() []FirewallRule {
	if page.dlsfrlr.IsEmpty() {
		return nil
	}
	return *page.dlsfrlr.Value
}

// DataLakeStoreTrustedIDProviderListResult data Lake Store trusted identity provider list information.
type DataLakeStoreTrustedIDProviderListResult struct {
	autorest.Response `json:"-"`
	// Value - the results of the list operation
	Value *[]TrustedIDProvider `json:"value,omitempty"`
	// NextLink - the link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// DataLakeStoreTrustedIDProviderListResultIterator provides access to a complete listing of TrustedIDProvider values.
type DataLakeStoreTrustedIDProviderListResultIterator struct {
	i    int
	page DataLakeStoreTrustedIDProviderListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DataLakeStoreTrustedIDProviderListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DataLakeStoreTrustedIDProviderListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DataLakeStoreTrustedIDProviderListResultIterator) Response() DataLakeStoreTrustedIDProviderListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DataLakeStoreTrustedIDProviderListResultIterator) Value() TrustedIDProvider {
	if !iter.page.NotDone() {
		return TrustedIDProvider{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (dlstiplr DataLakeStoreTrustedIDProviderListResult) IsEmpty() bool {
	return dlstiplr.Value == nil || len(*dlstiplr.Value) == 0
}

// dataLakeStoreTrustedIDProviderListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dlstiplr DataLakeStoreTrustedIDProviderListResult) dataLakeStoreTrustedIDProviderListResultPreparer() (*http.Request, error) {
	if dlstiplr.NextLink == nil || len(to.String(dlstiplr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dlstiplr.NextLink)))
}

// DataLakeStoreTrustedIDProviderListResultPage contains a page of TrustedIDProvider values.
type DataLakeStoreTrustedIDProviderListResultPage struct {
	fn       func(DataLakeStoreTrustedIDProviderListResult) (DataLakeStoreTrustedIDProviderListResult, error)
	dlstiplr DataLakeStoreTrustedIDProviderListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DataLakeStoreTrustedIDProviderListResultPage) Next() error {
	next, err := page.fn(page.dlstiplr)
	if err != nil {
		return err
	}
	page.dlstiplr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DataLakeStoreTrustedIDProviderListResultPage) NotDone() bool {
	return !page.dlstiplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DataLakeStoreTrustedIDProviderListResultPage) Response() DataLakeStoreTrustedIDProviderListResult {
	return page.dlstiplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DataLakeStoreTrustedIDProviderListResultPage) Values() []TrustedIDProvider {
	if page.dlstiplr.IsEmpty() {
		return nil
	}
	return *page.dlstiplr.Value
}

// EncryptionConfig the encryption configuration for the account.
type EncryptionConfig struct {
	// Type - The type of encryption configuration being used. Currently the only supported types are 'UserManaged' and 'ServiceManaged'. Possible values include: 'UserManaged', 'ServiceManaged'
	Type EncryptionConfigType `json:"type,omitempty"`
	// KeyVaultMetaInfo - The Key Vault information for connecting to user managed encryption keys.
	KeyVaultMetaInfo *KeyVaultMetaInfo `json:"keyVaultMetaInfo,omitempty"`
}

// EncryptionIdentity the encryption identity properties.
type EncryptionIdentity struct {
	// Type - The type of encryption being used. Currently the only supported type is 'SystemAssigned'.
	Type *string `json:"type,omitempty"`
	// PrincipalID - The principal identifier associated with the encryption.
	PrincipalID *uuid.UUID `json:"principalId,omitempty"`
	// TenantID - The tenant identifier associated with the encryption.
	TenantID *uuid.UUID `json:"tenantId,omitempty"`
}

// ErrorDetails data Lake Store error details information
type ErrorDetails struct {
	// Code - the HTTP status code or error code associated with this error
	Code *string `json:"code,omitempty"`
	// Message - the error message localized based on Accept-Language
	Message *string `json:"message,omitempty"`
	// Target - the target of the particular error (for example, the name of the property in error).
	Target *string `json:"target,omitempty"`
}

// FirewallRule data Lake Store firewall rule information
type FirewallRule struct {
	autorest.Response `json:"-"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// FirewallRuleProperties - the properties of the firewall rule.
	*FirewallRuleProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for FirewallRule struct.
func (fr *FirewallRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		var properties FirewallRuleProperties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		fr.FirewallRuleProperties = &properties
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		fr.ID = &ID
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		fr.Name = &name
	}

	v = m["type"]
	if v != nil {
		var typeVar string
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		fr.Type = &typeVar
	}

	return nil
}

// FirewallRuleProperties data Lake Store firewall rule properties information
type FirewallRuleProperties struct {
	// StartIPAddress - the start IP address for the firewall rule. This can be either ipv4 or ipv6. Start and End should be in the same protocol.
	StartIPAddress *string `json:"startIpAddress,omitempty"`
	// EndIPAddress - the end IP address for the firewall rule. This can be either ipv4 or ipv6. Start and End should be in the same protocol.
	EndIPAddress *string `json:"endIpAddress,omitempty"`
}

// KeyVaultMetaInfo metadata information used by account encryption.
type KeyVaultMetaInfo struct {
	// KeyVaultResourceID - The resource identifier for the user managed Key Vault being used to encrypt.
	KeyVaultResourceID *string `json:"keyVaultResourceId,omitempty"`
	// EncryptionKeyName - The name of the user managed encryption key.
	EncryptionKeyName *string `json:"encryptionKeyName,omitempty"`
	// EncryptionKeyVersion - The version of the user managed encryption key.
	EncryptionKeyVersion *string `json:"encryptionKeyVersion,omitempty"`
}

// NameAvailabilityInformation data Lake Store account name availability result information
type NameAvailabilityInformation struct {
	autorest.Response `json:"-"`
	// NameAvailable - the Boolean value of true or false to indicate whether the Data Lake Store account name is available or not.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - the reason why the Data Lake Store account name is not available, if nameAvailable is false.
	Reason *string `json:"reason,omitempty"`
	// Message - the message describing why the Data Lake Store account name is not available, if nameAvailable is false.
	Message *string `json:"message,omitempty"`
}

// Operation an available operation for Data Lake Store
type Operation struct {
	// Name - the name of the operation.
	Name *string `json:"name,omitempty"`
	// Display - the display information for the operation.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - the intended executor of the operation. Possible values include: 'User', 'System', 'Usersystem'
	Origin OperationOrigin `json:"origin,omitempty"`
}

// OperationDisplay the display information for a particular operation
type OperationDisplay struct {
	// Provider - the Resource provider of the operation.
	Provider *string `json:"provider,omitempty"`
	// Resource - the Resource type of the operation.
	Resource *string `json:"resource,omitempty"`
	// Operation - a friendly name of the operation.
	Operation *string `json:"operation,omitempty"`
	// Description - a friendly description of the operation.
	Description *string `json:"description,omitempty"`
}

// OperationListResult the list of available operations for Data Lake Store
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - the results of the list operation.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - the link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// Resource the Resource model definition.
type Resource struct {
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags *map[string]*string `json:"tags,omitempty"`
}

// SubResource the Resource model definition for a nested resource.
type SubResource struct {
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
}

// TrustedIDProvider data Lake Store Trusted Identity Provider information
type TrustedIDProvider struct {
	autorest.Response `json:"-"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// TrustedIDProviderProperties - the properties of the trusted identity provider.
	*TrustedIDProviderProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for TrustedIDProvider struct.
func (tip *TrustedIDProvider) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		var properties TrustedIDProviderProperties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		tip.TrustedIDProviderProperties = &properties
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		tip.ID = &ID
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		tip.Name = &name
	}

	v = m["type"]
	if v != nil {
		var typeVar string
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		tip.Type = &typeVar
	}

	return nil
}

// TrustedIDProviderProperties data Lake Store trusted identity provider properties information
type TrustedIDProviderProperties struct {
	// IDProvider - The URL of this trusted identity provider
	IDProvider *string `json:"idProvider,omitempty"`
}

// UpdateDataLakeStoreAccountProperties data Lake Store account properties information to be updated.
type UpdateDataLakeStoreAccountProperties struct {
	// FirewallState - The current state of the IP address firewall for this Data Lake store account. Disabling the firewall does not remove existing rules, they will just be ignored until the firewall is re-enabled. Possible values include: 'FirewallStateEnabled', 'FirewallStateDisabled'
	FirewallState FirewallState `json:"firewallState,omitempty"`
	// TrustedIDProviderState - The current state of the trusted identity provider feature for this Data Lake store account. Disabling trusted identity provider functionality does not remove the providers, they will just be ignored until this feature is re-enabled. Possible values include: 'TrustedIDProviderStateEnabled', 'TrustedIDProviderStateDisabled'
	TrustedIDProviderState TrustedIDProviderState `json:"trustedIdProviderState,omitempty"`
	// DefaultGroup - the default owner group for all new folders and files created in the Data Lake Store account.
	DefaultGroup *string `json:"defaultGroup,omitempty"`
	// NewTier - the commitment tier to use for next month. Possible values include: 'Consumption', 'Commitment1TB', 'Commitment10TB', 'Commitment100TB', 'Commitment500TB', 'Commitment1PB', 'Commitment5PB'
	NewTier TierType `json:"newTier,omitempty"`
	// FirewallAllowAzureIps - The current state of allowing or disallowing IPs originating within Azure through the firewall. If the firewall is disabled, this is not enforced. Possible values include: 'FirewallAllowAzureIpsStateEnabled', 'FirewallAllowAzureIpsStateDisabled'
	FirewallAllowAzureIps FirewallAllowAzureIpsState `json:"firewallAllowAzureIps,omitempty"`
	// EncryptionConfig - Used for rotation of user managed Key Vault keys. Can only be used to rotate a user managed encryption Key Vault key.
	EncryptionConfig *UpdateEncryptionConfig `json:"encryptionConfig,omitempty"`
}

// UpdateEncryptionConfig the encryption configuration used to update a user managed Key Vault key.
type UpdateEncryptionConfig struct {
	// KeyVaultMetaInfo - The updated Key Vault key to use in user managed key rotation.
	KeyVaultMetaInfo *UpdateKeyVaultMetaInfo `json:"keyVaultMetaInfo,omitempty"`
}

// UpdateFirewallRuleParameters data Lake Store firewall rule update parameters
type UpdateFirewallRuleParameters struct {
	// UpdateFirewallRuleProperties - the properties of the firewall rule to update.
	*UpdateFirewallRuleProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for UpdateFirewallRuleParameters struct.
func (ufrp *UpdateFirewallRuleParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		var properties UpdateFirewallRuleProperties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		ufrp.UpdateFirewallRuleProperties = &properties
	}

	return nil
}

// UpdateFirewallRuleProperties data Lake Store firewall rule properties information
type UpdateFirewallRuleProperties struct {
	// StartIPAddress - the start IP address for the firewall rule. This can be either ipv4 or ipv6. Start and End should be in the same protocol.
	StartIPAddress *string `json:"startIpAddress,omitempty"`
	// EndIPAddress - the end IP address for the firewall rule. This can be either ipv4 or ipv6. Start and End should be in the same protocol.
	EndIPAddress *string `json:"endIpAddress,omitempty"`
}

// UpdateKeyVaultMetaInfo the Key Vault update information used for user managed key rotation.
type UpdateKeyVaultMetaInfo struct {
	// EncryptionKeyVersion - The version of the user managed encryption key to update through a key rotation.
	EncryptionKeyVersion *string `json:"encryptionKeyVersion,omitempty"`
}

// UpdateTrustedIDProviderParameters data Lake Store Trusted Identity Provider update parameters
type UpdateTrustedIDProviderParameters struct {
	// UpdateTrustedIDProviderProperties - the properties of the trusted identity provider to update.
	*UpdateTrustedIDProviderProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for UpdateTrustedIDProviderParameters struct.
func (utipp *UpdateTrustedIDProviderParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		var properties UpdateTrustedIDProviderProperties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		utipp.UpdateTrustedIDProviderProperties = &properties
	}

	return nil
}

// UpdateTrustedIDProviderProperties data Lake Store trusted identity provider property update information
type UpdateTrustedIDProviderProperties struct {
	// IDProvider - The URL of this trusted identity provider
	IDProvider *string `json:"idProvider,omitempty"`
}
