package job

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/satori/go.uuid"
	"net/http"
)

// CompileMode enumerates the values for compile mode.
type CompileMode string

const (
	// Full ...
	Full CompileMode = "Full"
	// Semantic ...
	Semantic CompileMode = "Semantic"
	// SingleBox ...
	SingleBox CompileMode = "SingleBox"
)

// ResourceType enumerates the values for resource type.
type ResourceType string

const (
	// JobManagerResource ...
	JobManagerResource ResourceType = "JobManagerResource"
	// JobManagerResourceInUserFolder ...
	JobManagerResourceInUserFolder ResourceType = "JobManagerResourceInUserFolder"
	// StatisticsResource ...
	StatisticsResource ResourceType = "StatisticsResource"
	// StatisticsResourceInUserFolder ...
	StatisticsResourceInUserFolder ResourceType = "StatisticsResourceInUserFolder"
	// VertexResource ...
	VertexResource ResourceType = "VertexResource"
	// VertexResourceInUserFolder ...
	VertexResourceInUserFolder ResourceType = "VertexResourceInUserFolder"
)

// Result enumerates the values for result.
type Result string

const (
	// Cancelled ...
	Cancelled Result = "Cancelled"
	// Failed ...
	Failed Result = "Failed"
	// None ...
	None Result = "None"
	// Succeeded ...
	Succeeded Result = "Succeeded"
)

// SeverityTypes enumerates the values for severity types.
type SeverityTypes string

const (
	// Deprecated ...
	Deprecated SeverityTypes = "Deprecated"
	// Error ...
	Error SeverityTypes = "Error"
	// Info ...
	Info SeverityTypes = "Info"
	// SevereWarning ...
	SevereWarning SeverityTypes = "SevereWarning"
	// UserWarning ...
	UserWarning SeverityTypes = "UserWarning"
	// Warning ...
	Warning SeverityTypes = "Warning"
)

// State enumerates the values for state.
type State string

const (
	// StateAccepted ...
	StateAccepted State = "Accepted"
	// StateCompiling ...
	StateCompiling State = "Compiling"
	// StateEnded ...
	StateEnded State = "Ended"
	// StateNew ...
	StateNew State = "New"
	// StatePaused ...
	StatePaused State = "Paused"
	// StateQueued ...
	StateQueued State = "Queued"
	// StateRunning ...
	StateRunning State = "Running"
	// StateScheduling ...
	StateScheduling State = "Scheduling"
	// StateStarting ...
	StateStarting State = "Starting"
	// StateWaitingForCapacity ...
	StateWaitingForCapacity State = "WaitingForCapacity"
)

// Type enumerates the values for type.
type Type string

const (
	// Hive ...
	Hive Type = "Hive"
	// Scope ...
	Scope Type = "Scope"
	// USQL ...
	USQL Type = "USql"
)

// TypeBasicCreateJobProperties enumerates the values for type basic create job properties.
type TypeBasicCreateJobProperties string

const (
	// TypeCreateJobProperties ...
	TypeCreateJobProperties TypeBasicCreateJobProperties = "CreateJobProperties"
	// TypeScope ...
	TypeScope TypeBasicCreateJobProperties = "Scope"
	// TypeUSQL ...
	TypeUSQL TypeBasicCreateJobProperties = "USql"
)

// TypeBasicProperties enumerates the values for type basic properties.
type TypeBasicProperties string

const (
	// TypeBasicPropertiesTypeHive ...
	TypeBasicPropertiesTypeHive TypeBasicProperties = "Hive"
	// TypeBasicPropertiesTypeJobProperties ...
	TypeBasicPropertiesTypeJobProperties TypeBasicProperties = "JobProperties"
	// TypeBasicPropertiesTypeScope ...
	TypeBasicPropertiesTypeScope TypeBasicProperties = "Scope"
	// TypeBasicPropertiesTypeUSQL ...
	TypeBasicPropertiesTypeUSQL TypeBasicProperties = "USql"
)

// BaseJobParameters data Lake Analytics Job Parameters base class for build and submit.
type BaseJobParameters struct {
	// Type - the job type of the current job (Hive, USql, or Scope (for internal use only)). Possible values include: 'USQL', 'Hive', 'Scope'
	Type Type `json:"type,omitempty"`
	// Properties - the job specific properties.
	Properties BasicCreateJobProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for BaseJobParameters struct.
func (bjp *BaseJobParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["type"]
	if v != nil {
		var typeVar Type
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		bjp.Type = typeVar
	}

	v = m["properties"]
	if v != nil {
		properties, err := unmarshalBasicCreateJobProperties(*m["properties"])
		if err != nil {
			return err
		}
		bjp.Properties = properties
	}

	return nil
}

// BuildJobParameters the parameters used to build a new Data Lake Analytics job.
type BuildJobParameters struct {
	// Type - the job type of the current job (Hive, USql, or Scope (for internal use only)). Possible values include: 'USQL', 'Hive', 'Scope'
	Type Type `json:"type,omitempty"`
	// Properties - the job specific properties.
	Properties BasicCreateJobProperties `json:"properties,omitempty"`
	// Name - the friendly name of the job to build.
	Name *string `json:"name,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for BuildJobParameters struct.
func (bjp *BuildJobParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		bjp.Name = &name
	}

	v = m["type"]
	if v != nil {
		var typeVar Type
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		bjp.Type = typeVar
	}

	v = m["properties"]
	if v != nil {
		properties, err := unmarshalBasicCreateJobProperties(*m["properties"])
		if err != nil {
			return err
		}
		bjp.Properties = properties
	}

	return nil
}

// CreateJobParameters the parameters used to submit a new Data Lake Analytics job.
type CreateJobParameters struct {
	// Type - the job type of the current job (Hive, USql, or Scope (for internal use only)). Possible values include: 'USQL', 'Hive', 'Scope'
	Type Type `json:"type,omitempty"`
	// Properties - the job specific properties.
	Properties BasicCreateJobProperties `json:"properties,omitempty"`
	// Name - the friendly name of the job to submit.
	Name *string `json:"name,omitempty"`
	// DegreeOfParallelism - the degree of parallelism to use for this job. This must be greater than 0, if set to less than 0 it will default to 1.
	DegreeOfParallelism *int32 `json:"degreeOfParallelism,omitempty"`
	// Priority - the priority value to use for the current job. Lower numbers have a higher priority. By default, a job has a priority of 1000. This must be greater than 0.
	Priority *int32 `json:"priority,omitempty"`
	// LogFilePatterns - the list of log file name patterns to find in the logFolder. '*' is the only matching character allowed. Example format: jobExecution*.log or *mylog*.txt
	LogFilePatterns *[]string `json:"logFilePatterns,omitempty"`
	// Related - the recurring job relationship information properties.
	Related *RelationshipProperties `json:"related,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for CreateJobParameters struct.
func (cjp *CreateJobParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		cjp.Name = &name
	}

	v = m["degreeOfParallelism"]
	if v != nil {
		var degreeOfParallelism int32
		err = json.Unmarshal(*m["degreeOfParallelism"], &degreeOfParallelism)
		if err != nil {
			return err
		}
		cjp.DegreeOfParallelism = &degreeOfParallelism
	}

	v = m["priority"]
	if v != nil {
		var priority int32
		err = json.Unmarshal(*m["priority"], &priority)
		if err != nil {
			return err
		}
		cjp.Priority = &priority
	}

	v = m["logFilePatterns"]
	if v != nil {
		var logFilePatterns []string
		err = json.Unmarshal(*m["logFilePatterns"], &logFilePatterns)
		if err != nil {
			return err
		}
		cjp.LogFilePatterns = &logFilePatterns
	}

	v = m["related"]
	if v != nil {
		var related RelationshipProperties
		err = json.Unmarshal(*m["related"], &related)
		if err != nil {
			return err
		}
		cjp.Related = &related
	}

	v = m["type"]
	if v != nil {
		var typeVar Type
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		cjp.Type = typeVar
	}

	v = m["properties"]
	if v != nil {
		properties, err := unmarshalBasicCreateJobProperties(*m["properties"])
		if err != nil {
			return err
		}
		cjp.Properties = properties
	}

	return nil
}

// BasicCreateJobProperties the common Data Lake Analytics job properties for job submission.
type BasicCreateJobProperties interface {
	AsCreateUSQLJobProperties() (*CreateUSQLJobProperties, bool)
	AsCreateScopeJobProperties() (*CreateScopeJobProperties, bool)
	AsCreateJobProperties() (*CreateJobProperties, bool)
}

// CreateJobProperties the common Data Lake Analytics job properties for job submission.
type CreateJobProperties struct {
	// RuntimeVersion - the runtime version of the Data Lake Analytics engine to use for the specific type of job being run.
	RuntimeVersion *string `json:"runtimeVersion,omitempty"`
	// Script - the script to run. Please note that the maximum script size is 3 MB.
	Script *string `json:"script,omitempty"`
	// Type - Possible values include: 'TypeCreateJobProperties', 'TypeUSQL', 'TypeScope'
	Type TypeBasicCreateJobProperties `json:"type,omitempty"`
}

func unmarshalBasicCreateJobProperties(body []byte) (BasicCreateJobProperties, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeUSQL):
		var cusjp CreateUSQLJobProperties
		err := json.Unmarshal(body, &cusjp)
		return cusjp, err
	case string(TypeScope):
		var csjp CreateScopeJobProperties
		err := json.Unmarshal(body, &csjp)
		return csjp, err
	default:
		var cjp CreateJobProperties
		err := json.Unmarshal(body, &cjp)
		return cjp, err
	}
}
func unmarshalBasicCreateJobPropertiesArray(body []byte) ([]BasicCreateJobProperties, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	cjpArray := make([]BasicCreateJobProperties, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cjp, err := unmarshalBasicCreateJobProperties(*rawMessage)
		if err != nil {
			return nil, err
		}
		cjpArray[index] = cjp
	}
	return cjpArray, nil
}

// MarshalJSON is the custom marshaler for CreateJobProperties.
func (cjp CreateJobProperties) MarshalJSON() ([]byte, error) {
	cjp.Type = TypeCreateJobProperties
	type Alias CreateJobProperties
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(cjp),
	})
}

// AsCreateUSQLJobProperties is the BasicCreateJobProperties implementation for CreateJobProperties.
func (cjp CreateJobProperties) AsCreateUSQLJobProperties() (*CreateUSQLJobProperties, bool) {
	return nil, false
}

// AsCreateScopeJobProperties is the BasicCreateJobProperties implementation for CreateJobProperties.
func (cjp CreateJobProperties) AsCreateScopeJobProperties() (*CreateScopeJobProperties, bool) {
	return nil, false
}

// AsCreateJobProperties is the BasicCreateJobProperties implementation for CreateJobProperties.
func (cjp CreateJobProperties) AsCreateJobProperties() (*CreateJobProperties, bool) {
	return &cjp, true
}

// AsBasicCreateJobProperties is the BasicCreateJobProperties implementation for CreateJobProperties.
func (cjp CreateJobProperties) AsBasicCreateJobProperties() (BasicCreateJobProperties, bool) {
	return &cjp, true
}

// CreateScopeJobParameters the parameters used to submit a new Data Lake Analytics Scope job. (Only for use internally
// with Scope job type.)
type CreateScopeJobParameters struct {
	// Type - the job type of the current job (Hive, USql, or Scope (for internal use only)). Possible values include: 'USQL', 'Hive', 'Scope'
	Type Type `json:"type,omitempty"`
	// Properties - the job specific properties.
	Properties BasicCreateJobProperties `json:"properties,omitempty"`
	// Name - the friendly name of the job to submit.
	Name *string `json:"name,omitempty"`
	// DegreeOfParallelism - the degree of parallelism to use for this job. This must be greater than 0, if set to less than 0 it will default to 1.
	DegreeOfParallelism *int32 `json:"degreeOfParallelism,omitempty"`
	// Priority - the priority value to use for the current job. Lower numbers have a higher priority. By default, a job has a priority of 1000. This must be greater than 0.
	Priority *int32 `json:"priority,omitempty"`
	// LogFilePatterns - the list of log file name patterns to find in the logFolder. '*' is the only matching character allowed. Example format: jobExecution*.log or *mylog*.txt
	LogFilePatterns *[]string `json:"logFilePatterns,omitempty"`
	// Related - the recurring job relationship information properties.
	Related *RelationshipProperties `json:"related,omitempty"`
	// Tags - the key-value pairs used to add additional metadata to the job information. (Only for use internally with Scope job type.)
	Tags *map[string]*string `json:"tags,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for CreateScopeJobParameters struct.
func (csjp *CreateScopeJobParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["tags"]
	if v != nil {
		var tags map[string]*string
		err = json.Unmarshal(*m["tags"], &tags)
		if err != nil {
			return err
		}
		csjp.Tags = &tags
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		csjp.Name = &name
	}

	v = m["degreeOfParallelism"]
	if v != nil {
		var degreeOfParallelism int32
		err = json.Unmarshal(*m["degreeOfParallelism"], &degreeOfParallelism)
		if err != nil {
			return err
		}
		csjp.DegreeOfParallelism = &degreeOfParallelism
	}

	v = m["priority"]
	if v != nil {
		var priority int32
		err = json.Unmarshal(*m["priority"], &priority)
		if err != nil {
			return err
		}
		csjp.Priority = &priority
	}

	v = m["logFilePatterns"]
	if v != nil {
		var logFilePatterns []string
		err = json.Unmarshal(*m["logFilePatterns"], &logFilePatterns)
		if err != nil {
			return err
		}
		csjp.LogFilePatterns = &logFilePatterns
	}

	v = m["related"]
	if v != nil {
		var related RelationshipProperties
		err = json.Unmarshal(*m["related"], &related)
		if err != nil {
			return err
		}
		csjp.Related = &related
	}

	v = m["type"]
	if v != nil {
		var typeVar Type
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		csjp.Type = typeVar
	}

	v = m["properties"]
	if v != nil {
		properties, err := unmarshalBasicCreateJobProperties(*m["properties"])
		if err != nil {
			return err
		}
		csjp.Properties = properties
	}

	return nil
}

// CreateScopeJobProperties scope job properties used when submitting Scope jobs.
type CreateScopeJobProperties struct {
	// RuntimeVersion - the runtime version of the Data Lake Analytics engine to use for the specific type of job being run.
	RuntimeVersion *string `json:"runtimeVersion,omitempty"`
	// Script - the script to run. Please note that the maximum script size is 3 MB.
	Script *string `json:"script,omitempty"`
	// Type - Possible values include: 'TypeCreateJobProperties', 'TypeUSQL', 'TypeScope'
	Type TypeBasicCreateJobProperties `json:"type,omitempty"`
	// Resources - the list of resources that are required by the job.
	Resources *[]ScopeJobResource `json:"resources,omitempty"`
	// Notifier - the list of email addresses, separated by semi-colons, to notify when the job reaches a terminal state.
	Notifier *string `json:"notifier,omitempty"`
}

// MarshalJSON is the custom marshaler for CreateScopeJobProperties.
func (csjp CreateScopeJobProperties) MarshalJSON() ([]byte, error) {
	csjp.Type = TypeScope
	type Alias CreateScopeJobProperties
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(csjp),
	})
}

// AsCreateUSQLJobProperties is the BasicCreateJobProperties implementation for CreateScopeJobProperties.
func (csjp CreateScopeJobProperties) AsCreateUSQLJobProperties() (*CreateUSQLJobProperties, bool) {
	return nil, false
}

// AsCreateScopeJobProperties is the BasicCreateJobProperties implementation for CreateScopeJobProperties.
func (csjp CreateScopeJobProperties) AsCreateScopeJobProperties() (*CreateScopeJobProperties, bool) {
	return &csjp, true
}

// AsCreateJobProperties is the BasicCreateJobProperties implementation for CreateScopeJobProperties.
func (csjp CreateScopeJobProperties) AsCreateJobProperties() (*CreateJobProperties, bool) {
	return nil, false
}

// AsBasicCreateJobProperties is the BasicCreateJobProperties implementation for CreateScopeJobProperties.
func (csjp CreateScopeJobProperties) AsBasicCreateJobProperties() (BasicCreateJobProperties, bool) {
	return &csjp, true
}

// CreateUSQLJobProperties u-SQL job properties used when submitting U-SQL jobs.
type CreateUSQLJobProperties struct {
	// RuntimeVersion - the runtime version of the Data Lake Analytics engine to use for the specific type of job being run.
	RuntimeVersion *string `json:"runtimeVersion,omitempty"`
	// Script - the script to run. Please note that the maximum script size is 3 MB.
	Script *string `json:"script,omitempty"`
	// Type - Possible values include: 'TypeCreateJobProperties', 'TypeUSQL', 'TypeScope'
	Type TypeBasicCreateJobProperties `json:"type,omitempty"`
	// CompileMode - the specific compilation mode for the job used during execution. If this is not specified during submission, the server will determine the optimal compilation mode. Possible values include: 'Semantic', 'Full', 'SingleBox'
	CompileMode CompileMode `json:"compileMode,omitempty"`
}

// MarshalJSON is the custom marshaler for CreateUSQLJobProperties.
func (cusjp CreateUSQLJobProperties) MarshalJSON() ([]byte, error) {
	cusjp.Type = TypeUSQL
	type Alias CreateUSQLJobProperties
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(cusjp),
	})
}

// AsCreateUSQLJobProperties is the BasicCreateJobProperties implementation for CreateUSQLJobProperties.
func (cusjp CreateUSQLJobProperties) AsCreateUSQLJobProperties() (*CreateUSQLJobProperties, bool) {
	return &cusjp, true
}

// AsCreateScopeJobProperties is the BasicCreateJobProperties implementation for CreateUSQLJobProperties.
func (cusjp CreateUSQLJobProperties) AsCreateScopeJobProperties() (*CreateScopeJobProperties, bool) {
	return nil, false
}

// AsCreateJobProperties is the BasicCreateJobProperties implementation for CreateUSQLJobProperties.
func (cusjp CreateUSQLJobProperties) AsCreateJobProperties() (*CreateJobProperties, bool) {
	return nil, false
}

// AsBasicCreateJobProperties is the BasicCreateJobProperties implementation for CreateUSQLJobProperties.
func (cusjp CreateUSQLJobProperties) AsBasicCreateJobProperties() (BasicCreateJobProperties, bool) {
	return &cusjp, true
}

// DataPath a Data Lake Analytics job data path item.
type DataPath struct {
	autorest.Response `json:"-"`
	// JobID - the id of the job this data is for.
	JobID *uuid.UUID `json:"jobId,omitempty"`
	// Command - the command that this job data relates to.
	Command *string `json:"command,omitempty"`
	// Paths - the list of paths to all of the job data.
	Paths *[]string `json:"paths,omitempty"`
}

// Diagnostics error diagnostic information for failed jobs.
type Diagnostics struct {
	// ColumnNumber - the column where the error occured.
	ColumnNumber *int32 `json:"columnNumber,omitempty"`
	// End - the ending index of the error.
	End *int32 `json:"end,omitempty"`
	// LineNumber - the line number the error occured on.
	LineNumber *int32 `json:"lineNumber,omitempty"`
	// Message - the error message.
	Message *string `json:"message,omitempty"`
	// Severity - the severity of the error. Possible values include: 'Warning', 'Error', 'Info', 'SevereWarning', 'Deprecated', 'UserWarning'
	Severity SeverityTypes `json:"severity,omitempty"`
	// Start - the starting index of the error.
	Start *int32 `json:"start,omitempty"`
}

// ErrorDetails the Data Lake Analytics job error details.
type ErrorDetails struct {
	// Description - the error message description
	Description *string `json:"description,omitempty"`
	// Details - the details of the error message.
	Details *string `json:"details,omitempty"`
	// EndOffset - the end offset in the job where the error was found.
	EndOffset *int32 `json:"endOffset,omitempty"`
	// ErrorID - the specific identifier for the type of error encountered in the job.
	ErrorID *string `json:"errorId,omitempty"`
	// FilePath - the path to any supplemental error files, if any.
	FilePath *string `json:"filePath,omitempty"`
	// HelpLink - the link to MSDN or Azure help for this type of error, if any.
	HelpLink *string `json:"helpLink,omitempty"`
	// InternalDiagnostics - the internal diagnostic stack trace if the user requesting the job error details has sufficient permissions it will be retrieved, otherwise it will be empty.
	InternalDiagnostics *string `json:"internalDiagnostics,omitempty"`
	// LineNumber - the specific line number in the job where the error occured.
	LineNumber *int32 `json:"lineNumber,omitempty"`
	// Message - the user friendly error message for the failure.
	Message *string `json:"message,omitempty"`
	// Resolution - the recommended resolution for the failure, if any.
	Resolution *string `json:"resolution,omitempty"`
	// InnerError - the inner error of this specific job error message, if any.
	InnerError *InnerError `json:"innerError,omitempty"`
	// Severity - the severity level of the failure. Possible values include: 'Warning', 'Error', 'Info', 'SevereWarning', 'Deprecated', 'UserWarning'
	Severity SeverityTypes `json:"severity,omitempty"`
	// Source - the ultimate source of the failure (usually either SYSTEM or USER).
	Source *string `json:"source,omitempty"`
	// StartOffset - the start offset in the job where the error was found
	StartOffset *int32 `json:"startOffset,omitempty"`
}

// HiveJobProperties hive job properties used when retrieving Hive jobs.
type HiveJobProperties struct {
	// RuntimeVersion - the runtime version of the Data Lake Analytics engine to use for the specific type of job being run.
	RuntimeVersion *string `json:"runtimeVersion,omitempty"`
	// Script - the script to run. Please note that the maximum script size is 3 MB.
	Script *string `json:"script,omitempty"`
	// Type - Possible values include: 'TypeBasicPropertiesTypeJobProperties', 'TypeBasicPropertiesTypeUSQL', 'TypeBasicPropertiesTypeScope', 'TypeBasicPropertiesTypeHive'
	Type TypeBasicProperties `json:"type,omitempty"`
	// LogsLocation - the Hive logs location
	LogsLocation *string `json:"logsLocation,omitempty"`
	// OutputLocation - the location of Hive job output files (both execution output and results)
	OutputLocation *string `json:"outputLocation,omitempty"`
	// StatementCount - the number of statements that will be run based on the script
	StatementCount *int32 `json:"statementCount,omitempty"`
	// ExecutedStatementCount - the number of statements that have been run based on the script
	ExecutedStatementCount *int32 `json:"executedStatementCount,omitempty"`
}

// MarshalJSON is the custom marshaler for HiveJobProperties.
func (hjp HiveJobProperties) MarshalJSON() ([]byte, error) {
	hjp.Type = TypeBasicPropertiesTypeHive
	type Alias HiveJobProperties
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(hjp),
	})
}

// AsUSQLJobProperties is the BasicProperties implementation for HiveJobProperties.
func (hjp HiveJobProperties) AsUSQLJobProperties() (*USQLJobProperties, bool) {
	return nil, false
}

// AsScopeJobProperties is the BasicProperties implementation for HiveJobProperties.
func (hjp HiveJobProperties) AsScopeJobProperties() (*ScopeJobProperties, bool) {
	return nil, false
}

// AsHiveJobProperties is the BasicProperties implementation for HiveJobProperties.
func (hjp HiveJobProperties) AsHiveJobProperties() (*HiveJobProperties, bool) {
	return &hjp, true
}

// AsProperties is the BasicProperties implementation for HiveJobProperties.
func (hjp HiveJobProperties) AsProperties() (*Properties, bool) {
	return nil, false
}

// AsBasicProperties is the BasicProperties implementation for HiveJobProperties.
func (hjp HiveJobProperties) AsBasicProperties() (BasicProperties, bool) {
	return &hjp, true
}

// InfoListResult list of JobInfo items.
type InfoListResult struct {
	autorest.Response `json:"-"`
	// Value - the list of JobInfo items.
	Value *[]InformationBasic `json:"value,omitempty"`
	// NextLink - the link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// InfoListResultIterator provides access to a complete listing of InformationBasic values.
type InfoListResultIterator struct {
	i    int
	page InfoListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *InfoListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter InfoListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter InfoListResultIterator) Response() InfoListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter InfoListResultIterator) Value() InformationBasic {
	if !iter.page.NotDone() {
		return InformationBasic{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (ilr InfoListResult) IsEmpty() bool {
	return ilr.Value == nil || len(*ilr.Value) == 0
}

// infoListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ilr InfoListResult) infoListResultPreparer() (*http.Request, error) {
	if ilr.NextLink == nil || len(to.String(ilr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ilr.NextLink)))
}

// InfoListResultPage contains a page of InformationBasic values.
type InfoListResultPage struct {
	fn  func(InfoListResult) (InfoListResult, error)
	ilr InfoListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *InfoListResultPage) Next() error {
	next, err := page.fn(page.ilr)
	if err != nil {
		return err
	}
	page.ilr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page InfoListResultPage) NotDone() bool {
	return !page.ilr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page InfoListResultPage) Response() InfoListResult {
	return page.ilr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page InfoListResultPage) Values() []InformationBasic {
	if page.ilr.IsEmpty() {
		return nil
	}
	return *page.ilr.Value
}

// Information the extended Data Lake Analytics job information properties returned when retrieving a specific job.
type Information struct {
	autorest.Response `json:"-"`
	// JobID - the job's unique identifier (a GUID).
	JobID *uuid.UUID `json:"jobId,omitempty"`
	// Name - the friendly name of the job.
	Name *string `json:"name,omitempty"`
	// Type - the job type of the current job (Hive, USql, or Scope (for internal use only)). Possible values include: 'USQL', 'Hive', 'Scope'
	Type Type `json:"type,omitempty"`
	// Submitter - the user or account that submitted the job.
	Submitter *string `json:"submitter,omitempty"`
	// DegreeOfParallelism - the degree of parallelism used for this job. This must be greater than 0, if set to less than 0 it will default to 1.
	DegreeOfParallelism *int32 `json:"degreeOfParallelism,omitempty"`
	// Priority - the priority value for the current job. Lower numbers have a higher priority. By default, a job has a priority of 1000. This must be greater than 0.
	Priority *int32 `json:"priority,omitempty"`
	// SubmitTime - the time the job was submitted to the service.
	SubmitTime *date.Time `json:"submitTime,omitempty"`
	// StartTime - the start time of the job.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - the completion time of the job.
	EndTime *date.Time `json:"endTime,omitempty"`
	// State - the job state. When the job is in the Ended state, refer to Result and ErrorMessage for details. Possible values include: 'StateAccepted', 'StateCompiling', 'StateEnded', 'StateNew', 'StateQueued', 'StateRunning', 'StateScheduling', 'StateStarting', 'StatePaused', 'StateWaitingForCapacity'
	State State `json:"state,omitempty"`
	// Result - the result of job execution or the current result of the running job. Possible values include: 'None', 'Succeeded', 'Cancelled', 'Failed'
	Result Result `json:"result,omitempty"`
	// LogFolder - the log folder path to use in the following format: adl://<accountName>.azuredatalakestore.net/system/jobservice/jobs/Usql/2016/03/13/17/18/5fe51957-93bc-4de0-8ddc-c5a4753b068b/logs/.
	LogFolder *string `json:"logFolder,omitempty"`
	// LogFilePatterns - the list of log file name patterns to find in the logFolder. '*' is the only matching character allowed. Example format: jobExecution*.log or *mylog*.txt
	LogFilePatterns *[]string `json:"logFilePatterns,omitempty"`
	// Related - the recurring job relationship information properties.
	Related *RelationshipProperties `json:"related,omitempty"`
	// Tags - the key-value pairs used to add additional metadata to the job information. (Only for use internally with Scope job type.)
	Tags *map[string]*string `json:"tags,omitempty"`
	// ErrorMessage - the error message details for the job, if the job failed.
	ErrorMessage *[]ErrorDetails `json:"errorMessage,omitempty"`
	// StateAuditRecords - the job state audit records, indicating when various operations have been performed on this job.
	StateAuditRecords *[]StateAuditRecord `json:"stateAuditRecords,omitempty"`
	// Properties - the job specific properties.
	Properties BasicProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for Information struct.
func (i *Information) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["errorMessage"]
	if v != nil {
		var errorMessage []ErrorDetails
		err = json.Unmarshal(*m["errorMessage"], &errorMessage)
		if err != nil {
			return err
		}
		i.ErrorMessage = &errorMessage
	}

	v = m["stateAuditRecords"]
	if v != nil {
		var stateAuditRecords []StateAuditRecord
		err = json.Unmarshal(*m["stateAuditRecords"], &stateAuditRecords)
		if err != nil {
			return err
		}
		i.StateAuditRecords = &stateAuditRecords
	}

	v = m["properties"]
	if v != nil {
		properties, err := unmarshalBasicProperties(*m["properties"])
		if err != nil {
			return err
		}
		i.Properties = properties
	}

	v = m["jobId"]
	if v != nil {
		var jobID uuid.UUID
		err = json.Unmarshal(*m["jobId"], &jobID)
		if err != nil {
			return err
		}
		i.JobID = &jobID
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		i.Name = &name
	}

	v = m["type"]
	if v != nil {
		var typeVar Type
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		i.Type = typeVar
	}

	v = m["submitter"]
	if v != nil {
		var submitter string
		err = json.Unmarshal(*m["submitter"], &submitter)
		if err != nil {
			return err
		}
		i.Submitter = &submitter
	}

	v = m["degreeOfParallelism"]
	if v != nil {
		var degreeOfParallelism int32
		err = json.Unmarshal(*m["degreeOfParallelism"], &degreeOfParallelism)
		if err != nil {
			return err
		}
		i.DegreeOfParallelism = &degreeOfParallelism
	}

	v = m["priority"]
	if v != nil {
		var priority int32
		err = json.Unmarshal(*m["priority"], &priority)
		if err != nil {
			return err
		}
		i.Priority = &priority
	}

	v = m["submitTime"]
	if v != nil {
		var submitTime date.Time
		err = json.Unmarshal(*m["submitTime"], &submitTime)
		if err != nil {
			return err
		}
		i.SubmitTime = &submitTime
	}

	v = m["startTime"]
	if v != nil {
		var startTime date.Time
		err = json.Unmarshal(*m["startTime"], &startTime)
		if err != nil {
			return err
		}
		i.StartTime = &startTime
	}

	v = m["endTime"]
	if v != nil {
		var endTime date.Time
		err = json.Unmarshal(*m["endTime"], &endTime)
		if err != nil {
			return err
		}
		i.EndTime = &endTime
	}

	v = m["state"]
	if v != nil {
		var state State
		err = json.Unmarshal(*m["state"], &state)
		if err != nil {
			return err
		}
		i.State = state
	}

	v = m["result"]
	if v != nil {
		var resultVar Result
		err = json.Unmarshal(*m["result"], &resultVar)
		if err != nil {
			return err
		}
		i.Result = resultVar
	}

	v = m["logFolder"]
	if v != nil {
		var logFolder string
		err = json.Unmarshal(*m["logFolder"], &logFolder)
		if err != nil {
			return err
		}
		i.LogFolder = &logFolder
	}

	v = m["logFilePatterns"]
	if v != nil {
		var logFilePatterns []string
		err = json.Unmarshal(*m["logFilePatterns"], &logFilePatterns)
		if err != nil {
			return err
		}
		i.LogFilePatterns = &logFilePatterns
	}

	v = m["related"]
	if v != nil {
		var related RelationshipProperties
		err = json.Unmarshal(*m["related"], &related)
		if err != nil {
			return err
		}
		i.Related = &related
	}

	v = m["tags"]
	if v != nil {
		var tags map[string]*string
		err = json.Unmarshal(*m["tags"], &tags)
		if err != nil {
			return err
		}
		i.Tags = &tags
	}

	return nil
}

// InformationBasic the common Data Lake Analytics job information properties.
type InformationBasic struct {
	// JobID - the job's unique identifier (a GUID).
	JobID *uuid.UUID `json:"jobId,omitempty"`
	// Name - the friendly name of the job.
	Name *string `json:"name,omitempty"`
	// Type - the job type of the current job (Hive, USql, or Scope (for internal use only)). Possible values include: 'USQL', 'Hive', 'Scope'
	Type Type `json:"type,omitempty"`
	// Submitter - the user or account that submitted the job.
	Submitter *string `json:"submitter,omitempty"`
	// DegreeOfParallelism - the degree of parallelism used for this job. This must be greater than 0, if set to less than 0 it will default to 1.
	DegreeOfParallelism *int32 `json:"degreeOfParallelism,omitempty"`
	// Priority - the priority value for the current job. Lower numbers have a higher priority. By default, a job has a priority of 1000. This must be greater than 0.
	Priority *int32 `json:"priority,omitempty"`
	// SubmitTime - the time the job was submitted to the service.
	SubmitTime *date.Time `json:"submitTime,omitempty"`
	// StartTime - the start time of the job.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - the completion time of the job.
	EndTime *date.Time `json:"endTime,omitempty"`
	// State - the job state. When the job is in the Ended state, refer to Result and ErrorMessage for details. Possible values include: 'StateAccepted', 'StateCompiling', 'StateEnded', 'StateNew', 'StateQueued', 'StateRunning', 'StateScheduling', 'StateStarting', 'StatePaused', 'StateWaitingForCapacity'
	State State `json:"state,omitempty"`
	// Result - the result of job execution or the current result of the running job. Possible values include: 'None', 'Succeeded', 'Cancelled', 'Failed'
	Result Result `json:"result,omitempty"`
	// LogFolder - the log folder path to use in the following format: adl://<accountName>.azuredatalakestore.net/system/jobservice/jobs/Usql/2016/03/13/17/18/5fe51957-93bc-4de0-8ddc-c5a4753b068b/logs/.
	LogFolder *string `json:"logFolder,omitempty"`
	// LogFilePatterns - the list of log file name patterns to find in the logFolder. '*' is the only matching character allowed. Example format: jobExecution*.log or *mylog*.txt
	LogFilePatterns *[]string `json:"logFilePatterns,omitempty"`
	// Related - the recurring job relationship information properties.
	Related *RelationshipProperties `json:"related,omitempty"`
	// Tags - the key-value pairs used to add additional metadata to the job information. (Only for use internally with Scope job type.)
	Tags *map[string]*string `json:"tags,omitempty"`
}

// InnerError the Data Lake Analytics job error details.
type InnerError struct {
	// DiagnosticCode - the diagnostic error code.
	DiagnosticCode *int32 `json:"diagnosticCode,omitempty"`
	// Severity - the severity level of the failure. Possible values include: 'Warning', 'Error', 'Info', 'SevereWarning', 'Deprecated', 'UserWarning'
	Severity SeverityTypes `json:"severity,omitempty"`
	// Details - the details of the error message.
	Details *string `json:"details,omitempty"`
	// Component - the component that failed.
	Component *string `json:"component,omitempty"`
	// ErrorID - the specific identifier for the type of error encountered in the job.
	ErrorID *string `json:"errorId,omitempty"`
	// HelpLink - the link to MSDN or Azure help for this type of error, if any.
	HelpLink *string `json:"helpLink,omitempty"`
	// InternalDiagnostics - the internal diagnostic stack trace if the user requesting the job error details has sufficient permissions it will be retrieved, otherwise it will be empty.
	InternalDiagnostics *string `json:"internalDiagnostics,omitempty"`
	// Message - the user friendly error message for the failure.
	Message *string `json:"message,omitempty"`
	// Resolution - the recommended resolution for the failure, if any.
	Resolution *string `json:"resolution,omitempty"`
	// Source - the ultimate source of the failure (usually either SYSTEM or USER).
	Source *string `json:"source,omitempty"`
	// Description - the error message description
	Description *string `json:"description,omitempty"`
	// InnerError - the inner error of this specific job error message, if any.
	InnerError *InnerError `json:"innerError,omitempty"`
}

// JobCancelFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type JobCancelFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future JobCancelFuture) Result(client Client) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		return
	}
	if !done {
		return ar, autorest.NewError("job.JobCancelFuture", "Result", "asynchronous operation has not completed")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.CancelResponder(future.Response())
		return
	}
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, autorest.ChangeToGet(future.req),
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return
	}
	ar, err = client.CancelResponder(resp)
	return
}

// JobUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type JobUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future JobUpdateFuture) Result(client Client) (i Information, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		return
	}
	if !done {
		return i, autorest.NewError("job.JobUpdateFuture", "Result", "asynchronous operation has not completed")
	}
	if future.PollingMethod() == azure.PollingLocation {
		i, err = client.UpdateResponder(future.Response())
		return
	}
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, autorest.ChangeToGet(future.req),
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return
	}
	i, err = client.UpdateResponder(resp)
	return
}

// JobYieldFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type JobYieldFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future JobYieldFuture) Result(client Client) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		return
	}
	if !done {
		return ar, autorest.NewError("job.JobYieldFuture", "Result", "asynchronous operation has not completed")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.YieldResponder(future.Response())
		return
	}
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, autorest.ChangeToGet(future.req),
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return
	}
	ar, err = client.YieldResponder(resp)
	return
}

// PipelineInformation job Pipeline Information, showing the relationship of jobs and recurrences of those jobs in a
// pipeline.
type PipelineInformation struct {
	autorest.Response `json:"-"`
	// PipelineID - the job relationship pipeline identifier (a GUID).
	PipelineID *uuid.UUID `json:"pipelineId,omitempty"`
	// PipelineName - the friendly name of the job relationship pipeline, which does not need to be unique.
	PipelineName *string `json:"pipelineName,omitempty"`
	// PipelineURI - the pipeline uri, unique, links to the originating service for this pipeline.
	PipelineURI *string `json:"pipelineUri,omitempty"`
	// NumJobsFailed - the number of jobs in this pipeline that have failed.
	NumJobsFailed *int32 `json:"numJobsFailed,omitempty"`
	// NumJobsCanceled - the number of jobs in this pipeline that have been canceled.
	NumJobsCanceled *int32 `json:"numJobsCanceled,omitempty"`
	// NumJobsSucceeded - the number of jobs in this pipeline that have succeeded.
	NumJobsSucceeded *int32 `json:"numJobsSucceeded,omitempty"`
	// AuHoursFailed - the number of job execution hours that resulted in failed jobs.
	AuHoursFailed *float64 `json:"auHoursFailed,omitempty"`
	// AuHoursCanceled - the number of job execution hours that resulted in canceled jobs.
	AuHoursCanceled *float64 `json:"auHoursCanceled,omitempty"`
	// AuHoursSucceeded - the number of job execution hours that resulted in successful jobs.
	AuHoursSucceeded *float64 `json:"auHoursSucceeded,omitempty"`
	// LastSubmitTime - the last time a job in this pipeline was submitted.
	LastSubmitTime *date.Time `json:"lastSubmitTime,omitempty"`
	// Runs - the list of recurrence identifiers representing each run of this pipeline.
	Runs *[]PipelineRunInformation `json:"runs,omitempty"`
	// Recurrences - the list of recurrence identifiers representing each run of this pipeline.
	Recurrences *[]uuid.UUID `json:"recurrences,omitempty"`
}

// PipelineInformationListResult list of job pipeline information items.
type PipelineInformationListResult struct {
	autorest.Response `json:"-"`
	// Value - the list of job pipeline information items.
	Value *[]PipelineInformation `json:"value,omitempty"`
	// NextLink - the link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// PipelineInformationListResultIterator provides access to a complete listing of PipelineInformation values.
type PipelineInformationListResultIterator struct {
	i    int
	page PipelineInformationListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PipelineInformationListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PipelineInformationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PipelineInformationListResultIterator) Response() PipelineInformationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PipelineInformationListResultIterator) Value() PipelineInformation {
	if !iter.page.NotDone() {
		return PipelineInformation{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (pilr PipelineInformationListResult) IsEmpty() bool {
	return pilr.Value == nil || len(*pilr.Value) == 0
}

// pipelineInformationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pilr PipelineInformationListResult) pipelineInformationListResultPreparer() (*http.Request, error) {
	if pilr.NextLink == nil || len(to.String(pilr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pilr.NextLink)))
}

// PipelineInformationListResultPage contains a page of PipelineInformation values.
type PipelineInformationListResultPage struct {
	fn   func(PipelineInformationListResult) (PipelineInformationListResult, error)
	pilr PipelineInformationListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PipelineInformationListResultPage) Next() error {
	next, err := page.fn(page.pilr)
	if err != nil {
		return err
	}
	page.pilr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PipelineInformationListResultPage) NotDone() bool {
	return !page.pilr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PipelineInformationListResultPage) Response() PipelineInformationListResult {
	return page.pilr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PipelineInformationListResultPage) Values() []PipelineInformation {
	if page.pilr.IsEmpty() {
		return nil
	}
	return *page.pilr.Value
}

// PipelineRunInformation run info for a specific job pipeline.
type PipelineRunInformation struct {
	// RunID - the run identifier of an instance of pipeline executions (a GUID).
	RunID *uuid.UUID `json:"runId,omitempty"`
	// LastSubmitTime - the time this instance was last submitted.
	LastSubmitTime *date.Time `json:"lastSubmitTime,omitempty"`
}

// BasicProperties the common Data Lake Analytics job properties.
type BasicProperties interface {
	AsUSQLJobProperties() (*USQLJobProperties, bool)
	AsScopeJobProperties() (*ScopeJobProperties, bool)
	AsHiveJobProperties() (*HiveJobProperties, bool)
	AsProperties() (*Properties, bool)
}

// Properties the common Data Lake Analytics job properties.
type Properties struct {
	// RuntimeVersion - the runtime version of the Data Lake Analytics engine to use for the specific type of job being run.
	RuntimeVersion *string `json:"runtimeVersion,omitempty"`
	// Script - the script to run. Please note that the maximum script size is 3 MB.
	Script *string `json:"script,omitempty"`
	// Type - Possible values include: 'TypeBasicPropertiesTypeJobProperties', 'TypeBasicPropertiesTypeUSQL', 'TypeBasicPropertiesTypeScope', 'TypeBasicPropertiesTypeHive'
	Type TypeBasicProperties `json:"type,omitempty"`
}

func unmarshalBasicProperties(body []byte) (BasicProperties, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeBasicPropertiesTypeUSQL):
		var usjp USQLJobProperties
		err := json.Unmarshal(body, &usjp)
		return usjp, err
	case string(TypeBasicPropertiesTypeScope):
		var sjp ScopeJobProperties
		err := json.Unmarshal(body, &sjp)
		return sjp, err
	case string(TypeBasicPropertiesTypeHive):
		var hjp HiveJobProperties
		err := json.Unmarshal(body, &hjp)
		return hjp, err
	default:
		var p Properties
		err := json.Unmarshal(body, &p)
		return p, err
	}
}
func unmarshalBasicPropertiesArray(body []byte) ([]BasicProperties, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	pArray := make([]BasicProperties, len(rawMessages))

	for index, rawMessage := range rawMessages {
		p, err := unmarshalBasicProperties(*rawMessage)
		if err != nil {
			return nil, err
		}
		pArray[index] = p
	}
	return pArray, nil
}

// MarshalJSON is the custom marshaler for Properties.
func (p Properties) MarshalJSON() ([]byte, error) {
	p.Type = TypeBasicPropertiesTypeJobProperties
	type Alias Properties
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(p),
	})
}

// AsUSQLJobProperties is the BasicProperties implementation for Properties.
func (p Properties) AsUSQLJobProperties() (*USQLJobProperties, bool) {
	return nil, false
}

// AsScopeJobProperties is the BasicProperties implementation for Properties.
func (p Properties) AsScopeJobProperties() (*ScopeJobProperties, bool) {
	return nil, false
}

// AsHiveJobProperties is the BasicProperties implementation for Properties.
func (p Properties) AsHiveJobProperties() (*HiveJobProperties, bool) {
	return nil, false
}

// AsProperties is the BasicProperties implementation for Properties.
func (p Properties) AsProperties() (*Properties, bool) {
	return &p, true
}

// AsBasicProperties is the BasicProperties implementation for Properties.
func (p Properties) AsBasicProperties() (BasicProperties, bool) {
	return &p, true
}

// RecurrenceInformation recurrence job information for a specific recurrence.
type RecurrenceInformation struct {
	autorest.Response `json:"-"`
	// RecurrenceID - the recurrence identifier (a GUID), unique per activity/script, regardless of iterations. This is something to link different occurrences of the same job together.
	RecurrenceID *uuid.UUID `json:"recurrenceId,omitempty"`
	// RecurrenceName - the recurrence name, user friendly name for the correlation between jobs.
	RecurrenceName *string `json:"recurrenceName,omitempty"`
	// NumJobsFailed - the number of jobs in this recurrence that have failed.
	NumJobsFailed *int32 `json:"numJobsFailed,omitempty"`
	// NumJobsCanceled - the number of jobs in this recurrence that have been canceled.
	NumJobsCanceled *int32 `json:"numJobsCanceled,omitempty"`
	// NumJobsSucceeded - the number of jobs in this recurrence that have succeeded.
	NumJobsSucceeded *int32 `json:"numJobsSucceeded,omitempty"`
	// AuHoursFailed - the number of job execution hours that resulted in failed jobs.
	AuHoursFailed *float64 `json:"auHoursFailed,omitempty"`
	// AuHoursCanceled - the number of job execution hours that resulted in canceled jobs.
	AuHoursCanceled *float64 `json:"auHoursCanceled,omitempty"`
	// AuHoursSucceeded - the number of job execution hours that resulted in successful jobs.
	AuHoursSucceeded *float64 `json:"auHoursSucceeded,omitempty"`
	// LastSubmitTime - the last time a job in this recurrence was submitted.
	LastSubmitTime *date.Time `json:"lastSubmitTime,omitempty"`
}

// RecurrenceInformationListResult list of job recurrence information items.
type RecurrenceInformationListResult struct {
	autorest.Response `json:"-"`
	// Value - the list of job recurrence information items.
	Value *[]RecurrenceInformation `json:"value,omitempty"`
	// NextLink - the link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RecurrenceInformationListResultIterator provides access to a complete listing of RecurrenceInformation values.
type RecurrenceInformationListResultIterator struct {
	i    int
	page RecurrenceInformationListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RecurrenceInformationListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RecurrenceInformationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RecurrenceInformationListResultIterator) Response() RecurrenceInformationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RecurrenceInformationListResultIterator) Value() RecurrenceInformation {
	if !iter.page.NotDone() {
		return RecurrenceInformation{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (rilr RecurrenceInformationListResult) IsEmpty() bool {
	return rilr.Value == nil || len(*rilr.Value) == 0
}

// recurrenceInformationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rilr RecurrenceInformationListResult) recurrenceInformationListResultPreparer() (*http.Request, error) {
	if rilr.NextLink == nil || len(to.String(rilr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rilr.NextLink)))
}

// RecurrenceInformationListResultPage contains a page of RecurrenceInformation values.
type RecurrenceInformationListResultPage struct {
	fn   func(RecurrenceInformationListResult) (RecurrenceInformationListResult, error)
	rilr RecurrenceInformationListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RecurrenceInformationListResultPage) Next() error {
	next, err := page.fn(page.rilr)
	if err != nil {
		return err
	}
	page.rilr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RecurrenceInformationListResultPage) NotDone() bool {
	return !page.rilr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RecurrenceInformationListResultPage) Response() RecurrenceInformationListResult {
	return page.rilr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RecurrenceInformationListResultPage) Values() []RecurrenceInformation {
	if page.rilr.IsEmpty() {
		return nil
	}
	return *page.rilr.Value
}

// RelationshipProperties job relationship information properties including pipeline information, correlation
// information, etc.
type RelationshipProperties struct {
	// PipelineID - the job relationship pipeline identifier (a GUID).
	PipelineID *uuid.UUID `json:"pipelineId,omitempty"`
	// PipelineName - the friendly name of the job relationship pipeline, which does not need to be unique.
	PipelineName *string `json:"pipelineName,omitempty"`
	// PipelineURI - the pipeline uri, unique, links to the originating service for this pipeline.
	PipelineURI *string `json:"pipelineUri,omitempty"`
	// RunID - the run identifier (a GUID), unique identifier of the iteration of this pipeline.
	RunID *uuid.UUID `json:"runId,omitempty"`
	// RecurrenceID - the recurrence identifier (a GUID), unique per activity/script, regardless of iterations. This is something to link different occurrences of the same job together.
	RecurrenceID *uuid.UUID `json:"recurrenceId,omitempty"`
	// RecurrenceName - the recurrence name, user friendly name for the correlation between jobs.
	RecurrenceName *string `json:"recurrenceName,omitempty"`
}

// Resource the Data Lake Analytics job resources.
type Resource struct {
	// Name - the name of the resource.
	Name *string `json:"name,omitempty"`
	// ResourcePath - the path to the resource.
	ResourcePath *string `json:"resourcePath,omitempty"`
	// Type - the job resource type. Possible values include: 'VertexResource', 'JobManagerResource', 'StatisticsResource', 'VertexResourceInUserFolder', 'JobManagerResourceInUserFolder', 'StatisticsResourceInUserFolder'
	Type ResourceType `json:"type,omitempty"`
}

// ResourceUsageStatistics the statistics information for resource usage.
type ResourceUsageStatistics struct {
	// Average - the average value.
	Average *float64 `json:"average,omitempty"`
	// Minimum - the minimum value.
	Minimum *int64 `json:"minimum,omitempty"`
	// Maximum - the maximum value.
	Maximum *int64 `json:"maximum,omitempty"`
}

// ScopeJobProperties scope job properties used when submitting and retrieving Scope jobs. (Only for use internally
// with Scope job type.)
type ScopeJobProperties struct {
	// RuntimeVersion - the runtime version of the Data Lake Analytics engine to use for the specific type of job being run.
	RuntimeVersion *string `json:"runtimeVersion,omitempty"`
	// Script - the script to run. Please note that the maximum script size is 3 MB.
	Script *string `json:"script,omitempty"`
	// Type - Possible values include: 'TypeBasicPropertiesTypeJobProperties', 'TypeBasicPropertiesTypeUSQL', 'TypeBasicPropertiesTypeScope', 'TypeBasicPropertiesTypeHive'
	Type TypeBasicProperties `json:"type,omitempty"`
	// Resources - the list of resources that are required by the job
	Resources *[]ScopeJobResource `json:"resources,omitempty"`
	// UserAlgebraPath - the algebra file path after the job has completed
	UserAlgebraPath *string `json:"userAlgebraPath,omitempty"`
	// Notifier - the list of email addresses, separated by semi-colons, to notify when the job reaches a terminal state.
	Notifier *string `json:"notifier,omitempty"`
	// TotalCompilationTime - the total time this job spent compiling. This value should not be set by the user and will be ignored if it is.
	TotalCompilationTime *string `json:"totalCompilationTime,omitempty"`
	// TotalPausedTime - the total time this job spent paused. This value should not be set by the user and will be ignored if it is.
	TotalPausedTime *string `json:"totalPausedTime,omitempty"`
	// TotalQueuedTime - the total time this job spent queued. This value should not be set by the user and will be ignored if it is.
	TotalQueuedTime *string `json:"totalQueuedTime,omitempty"`
	// TotalRunningTime - the total time this job spent executing. This value should not be set by the user and will be ignored if it is.
	TotalRunningTime *string `json:"totalRunningTime,omitempty"`
	// RootProcessNodeID - the ID used to identify the job manager coordinating job execution. This value should not be set by the user and will be ignored if it is.
	RootProcessNodeID *string `json:"rootProcessNodeId,omitempty"`
	// YarnApplicationID - the ID used to identify the yarn application executing the job. This value should not be set by the user and will be ignored if it is.
	YarnApplicationID *string `json:"yarnApplicationId,omitempty"`
}

// MarshalJSON is the custom marshaler for ScopeJobProperties.
func (sjp ScopeJobProperties) MarshalJSON() ([]byte, error) {
	sjp.Type = TypeBasicPropertiesTypeScope
	type Alias ScopeJobProperties
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(sjp),
	})
}

// AsUSQLJobProperties is the BasicProperties implementation for ScopeJobProperties.
func (sjp ScopeJobProperties) AsUSQLJobProperties() (*USQLJobProperties, bool) {
	return nil, false
}

// AsScopeJobProperties is the BasicProperties implementation for ScopeJobProperties.
func (sjp ScopeJobProperties) AsScopeJobProperties() (*ScopeJobProperties, bool) {
	return &sjp, true
}

// AsHiveJobProperties is the BasicProperties implementation for ScopeJobProperties.
func (sjp ScopeJobProperties) AsHiveJobProperties() (*HiveJobProperties, bool) {
	return nil, false
}

// AsProperties is the BasicProperties implementation for ScopeJobProperties.
func (sjp ScopeJobProperties) AsProperties() (*Properties, bool) {
	return nil, false
}

// AsBasicProperties is the BasicProperties implementation for ScopeJobProperties.
func (sjp ScopeJobProperties) AsBasicProperties() (BasicProperties, bool) {
	return &sjp, true
}

// ScopeJobResource the Scope job resources. (Only for use internally with Scope job type.)
type ScopeJobResource struct {
	// Name - the name of the resource.
	Name *string `json:"name,omitempty"`
	// Path - the path to the resource.
	Path *string `json:"path,omitempty"`
}

// StateAuditRecord the Data Lake Analytics job state audit records for tracking the lifecycle of a job.
type StateAuditRecord struct {
	// NewState - the new state the job is in.
	NewState *string `json:"newState,omitempty"`
	// TimeStamp - the time stamp that the state change took place.
	TimeStamp *date.Time `json:"timeStamp,omitempty"`
	// RequestedByUser - the user who requests the change.
	RequestedByUser *string `json:"requestedByUser,omitempty"`
	// Details - the details of the audit log.
	Details *string `json:"details,omitempty"`
}

// Statistics the Data Lake Analytics job execution statistics.
type Statistics struct {
	autorest.Response `json:"-"`
	// LastUpdateTimeUtc - the last update time for the statistics.
	LastUpdateTimeUtc *date.Time `json:"lastUpdateTimeUtc,omitempty"`
	// FinalizingTimeUtc - the job finalizing start time.
	FinalizingTimeUtc *date.Time `json:"finalizingTimeUtc,omitempty"`
	// Stages - the list of stages for the job.
	Stages *[]StatisticsVertexStage `json:"stages,omitempty"`
}

// StatisticsVertex the detailed information for a vertex.
type StatisticsVertex struct {
	// Name - the name of the vertex.
	Name *string `json:"name,omitempty"`
	// VertexID - the id of the vertex.
	VertexID *uuid.UUID `json:"vertexId,omitempty"`
	// ExecutionTime - the amount of execution time of the vertex.
	ExecutionTime *string `json:"executionTime,omitempty"`
	// DataRead - the amount of data read of the vertex, in bytes.
	DataRead *int64 `json:"dataRead,omitempty"`
	// PeakMemUsage - the amount of peak memory usage of the vertex, in bytes.
	PeakMemUsage *int64 `json:"peakMemUsage,omitempty"`
}

// StatisticsVertexStage the Data Lake Analytics job statistics vertex stage information.
type StatisticsVertexStage struct {
	// DataRead - the amount of data read, in bytes.
	DataRead *int64 `json:"dataRead,omitempty"`
	// DataReadCrossPod - the amount of data read across multiple pods, in bytes.
	DataReadCrossPod *int64 `json:"dataReadCrossPod,omitempty"`
	// DataReadIntraPod - the amount of data read in one pod, in bytes.
	DataReadIntraPod *int64 `json:"dataReadIntraPod,omitempty"`
	// DataToRead - the amount of data remaining to be read, in bytes.
	DataToRead *int64 `json:"dataToRead,omitempty"`
	// DataWritten - the amount of data written, in bytes.
	DataWritten *int64 `json:"dataWritten,omitempty"`
	// DuplicateDiscardCount - the number of duplicates that were discarded.
	DuplicateDiscardCount *int32 `json:"duplicateDiscardCount,omitempty"`
	// FailedCount - the number of failures that occured in this stage.
	FailedCount *int32 `json:"failedCount,omitempty"`
	// MaxVertexDataRead - the maximum amount of data read in a single vertex, in bytes.
	MaxVertexDataRead *int64 `json:"maxVertexDataRead,omitempty"`
	// MinVertexDataRead - the minimum amount of data read in a single vertex, in bytes.
	MinVertexDataRead *int64 `json:"minVertexDataRead,omitempty"`
	// ReadFailureCount - the number of read failures in this stage.
	ReadFailureCount *int32 `json:"readFailureCount,omitempty"`
	// RevocationCount - the number of vertices that were revoked during this stage.
	RevocationCount *int32 `json:"revocationCount,omitempty"`
	// RunningCount - the number of currently running vertices in this stage.
	RunningCount *int32 `json:"runningCount,omitempty"`
	// ScheduledCount - the number of currently scheduled vertices in this stage
	ScheduledCount *int32 `json:"scheduledCount,omitempty"`
	// StageName - the name of this stage in job execution.
	StageName *string `json:"stageName,omitempty"`
	// SucceededCount - the number of vertices that succeeded in this stage.
	SucceededCount *int32 `json:"succeededCount,omitempty"`
	// TempDataWritten - the amount of temporary data written, in bytes.
	TempDataWritten *int64 `json:"tempDataWritten,omitempty"`
	// TotalCount - the total vertex count for this stage.
	TotalCount *int32 `json:"totalCount,omitempty"`
	// TotalFailedTime - the amount of time that failed vertices took up in this stage.
	TotalFailedTime *string `json:"totalFailedTime,omitempty"`
	// TotalProgress - the current progress of this stage, as a percentage.
	TotalProgress *int32 `json:"totalProgress,omitempty"`
	// TotalSucceededTime - the amount of time all successful vertices took in this stage.
	TotalSucceededTime *string `json:"totalSucceededTime,omitempty"`
	// TotalPeakMemUsage - the sum of the peak memory usage of all the vertices in the stage, in bytes.
	TotalPeakMemUsage *int64 `json:"totalPeakMemUsage,omitempty"`
	// TotalExecutionTime - the sum of the total execution time of all the vertices in the stage.
	TotalExecutionTime *string `json:"totalExecutionTime,omitempty"`
	// MaxDataReadVertex - the vertex with the maximum amount of data read.
	MaxDataReadVertex *StatisticsVertex `json:"maxDataReadVertex,omitempty"`
	// MaxExecutionTimeVertex - the vertex with the maximum execution time.
	MaxExecutionTimeVertex *StatisticsVertex `json:"maxExecutionTimeVertex,omitempty"`
	// MaxPeakMemUsageVertex - the vertex with the maximum peak memory usage.
	MaxPeakMemUsageVertex *StatisticsVertex `json:"maxPeakMemUsageVertex,omitempty"`
	// EstimatedVertexCPUCoreCount - the estimated vertex CPU core count.
	EstimatedVertexCPUCoreCount *int32 `json:"estimatedVertexCpuCoreCount,omitempty"`
	// EstimatedVertexPeakCPUCoreCount - the estimated vertex peak CPU core count.
	EstimatedVertexPeakCPUCoreCount *int32 `json:"estimatedVertexPeakCpuCoreCount,omitempty"`
	// EstimatedVertexMemSize - the estimated vertex memory size, in bytes.
	EstimatedVertexMemSize *int64 `json:"estimatedVertexMemSize,omitempty"`
	// AllocatedContainerCPUCoreCount - the statistics information for the allocated container CPU core count.
	AllocatedContainerCPUCoreCount *ResourceUsageStatistics `json:"allocatedContainerCpuCoreCount,omitempty"`
	// AllocatedContainerMemSize - the statistics information for the allocated container memory size.
	AllocatedContainerMemSize *ResourceUsageStatistics `json:"allocatedContainerMemSize,omitempty"`
	// UsedVertexCPUCoreCount - the statistics information for the used vertex CPU core count.
	UsedVertexCPUCoreCount *ResourceUsageStatistics `json:"usedVertexCpuCoreCount,omitempty"`
	// UsedVertexPeakMemSize - the statistics information for the used vertex peak memory size.
	UsedVertexPeakMemSize *ResourceUsageStatistics `json:"usedVertexPeakMemSize,omitempty"`
}

// UpdateJobParameters the parameters that can be used to update existing Data Lake Analytics job information
// properties. (Only for use internally with Scope job type.)
type UpdateJobParameters struct {
	// DegreeOfParallelism - the degree of parallelism used for this job. This must be greater than 0, if set to less than 0 it will default to 1.
	DegreeOfParallelism *int32 `json:"degreeOfParallelism,omitempty"`
	// Priority - the priority value for the current job. Lower numbers have a higher priority. By default, a job has a priority of 1000. This must be greater than 0.
	Priority *int32 `json:"priority,omitempty"`
	// Tags - the key-value pairs used to add additional metadata to the job information. (Only for use internally with Scope job type.)
	Tags *map[string]*string `json:"tags,omitempty"`
}

// USQLJobProperties u-SQL job properties used when retrieving U-SQL jobs.
type USQLJobProperties struct {
	// RuntimeVersion - the runtime version of the Data Lake Analytics engine to use for the specific type of job being run.
	RuntimeVersion *string `json:"runtimeVersion,omitempty"`
	// Script - the script to run. Please note that the maximum script size is 3 MB.
	Script *string `json:"script,omitempty"`
	// Type - Possible values include: 'TypeBasicPropertiesTypeJobProperties', 'TypeBasicPropertiesTypeUSQL', 'TypeBasicPropertiesTypeScope', 'TypeBasicPropertiesTypeHive'
	Type TypeBasicProperties `json:"type,omitempty"`
	// Resources - the list of resources that are required by the job
	Resources *[]Resource `json:"resources,omitempty"`
	// Statistics - the job specific statistics.
	Statistics *Statistics `json:"statistics,omitempty"`
	// DebugData - the job specific debug data locations.
	DebugData *DataPath `json:"debugData,omitempty"`
	// Diagnostics - the diagnostics for the job.
	Diagnostics *[]Diagnostics `json:"diagnostics,omitempty"`
	// AlgebraFilePath - the algebra file path after the job has completed
	AlgebraFilePath *string `json:"algebraFilePath,omitempty"`
	// TotalCompilationTime - the total time this job spent compiling. This value should not be set by the user and will be ignored if it is.
	TotalCompilationTime *string `json:"totalCompilationTime,omitempty"`
	// TotalPausedTime - the total time this job spent paused. This value should not be set by the user and will be ignored if it is.
	TotalPausedTime *string `json:"totalPausedTime,omitempty"`
	// TotalQueuedTime - the total time this job spent queued. This value should not be set by the user and will be ignored if it is.
	TotalQueuedTime *string `json:"totalQueuedTime,omitempty"`
	// TotalRunningTime - the total time this job spent executing. This value should not be set by the user and will be ignored if it is.
	TotalRunningTime *string `json:"totalRunningTime,omitempty"`
	// RootProcessNodeID - the ID used to identify the job manager coordinating job execution. This value should not be set by the user and will be ignored if it is.
	RootProcessNodeID *string `json:"rootProcessNodeId,omitempty"`
	// YarnApplicationID - the ID used to identify the yarn application executing the job. This value should not be set by the user and will be ignored if it is.
	YarnApplicationID *string `json:"yarnApplicationId,omitempty"`
	// YarnApplicationTimeStamp - the timestamp (in ticks) for the yarn application executing the job. This value should not be set by the user and will be ignored if it is.
	YarnApplicationTimeStamp *int64 `json:"yarnApplicationTimeStamp,omitempty"`
	// CompileMode - the specific compilation mode for the job used during execution. If this is not specified during submission, the server will determine the optimal compilation mode. Possible values include: 'Semantic', 'Full', 'SingleBox'
	CompileMode CompileMode `json:"compileMode,omitempty"`
}

// MarshalJSON is the custom marshaler for USQLJobProperties.
func (usjp USQLJobProperties) MarshalJSON() ([]byte, error) {
	usjp.Type = TypeBasicPropertiesTypeUSQL
	type Alias USQLJobProperties
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(usjp),
	})
}

// AsUSQLJobProperties is the BasicProperties implementation for USQLJobProperties.
func (usjp USQLJobProperties) AsUSQLJobProperties() (*USQLJobProperties, bool) {
	return &usjp, true
}

// AsScopeJobProperties is the BasicProperties implementation for USQLJobProperties.
func (usjp USQLJobProperties) AsScopeJobProperties() (*ScopeJobProperties, bool) {
	return nil, false
}

// AsHiveJobProperties is the BasicProperties implementation for USQLJobProperties.
func (usjp USQLJobProperties) AsHiveJobProperties() (*HiveJobProperties, bool) {
	return nil, false
}

// AsProperties is the BasicProperties implementation for USQLJobProperties.
func (usjp USQLJobProperties) AsProperties() (*Properties, bool) {
	return nil, false
}

// AsBasicProperties is the BasicProperties implementation for USQLJobProperties.
func (usjp USQLJobProperties) AsBasicProperties() (BasicProperties, bool) {
	return &usjp, true
}
